/*
 * Copyright 2009 Freescale Semiconductor, Inc. All Rights Reserved.
 */

/*
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */
////////////////////////////////////////////////////////////////////////////////
//
// WARNING!  THIS FILE IS AUTOMATICALLY GENERATED FROM XML.
//                DO NOT MODIFY THIS FILE DIRECTLY.
//
////////////////////////////////////////////////////////////////////////////////
//
// The following naming conventions are followed in this file.
//      XX_<module>_<regname>_<field>
//
// XX specifies the define / macro class
//      HW pertains to a register
//      BM indicates a Bit Mask
//      BF indicates a Bit Field macro
//
// <module> is the hardware module name which can be any of the following...
//      USB20 (Note when there is more than one copy of a given module, the
//      module name includes a number starting from 0 for the first instance
//      of that module)
//
// <regname> is the specific register within that module
//
// <field> is the specific bitfield within that <module>_<register>
//
// We also define the following...
//      hw_<module>_<regname>_t is typedef of anonymous union
//
////////////////////////////////////////////////////////////////////////////////

#ifndef _REGSAUDIOOUT_H
#define _REGSAUDIOOUT_H  1

#include "regs.h"

#ifndef REGS_AUDIOOUT_BASE
#define REGS_AUDIOOUT_BASE (REGS_BASE + 0x00048000)
#endif

////////////////////////////////////////////////////////////////////////////////
//// HW_AUDIOOUT_CTRL - AUDIOOUT Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RUN                 :  1;
        unsigned FIFO_ERROR_IRQ_EN   :  1;
        unsigned FIFO_OVERFLOW_IRQ   :  1;
        unsigned FIFO_UNDERFLOW_IRQ  :  1;
        unsigned LOOPBACK            :  1;
        unsigned DAC_ZERO_ENABLE     :  1;
        unsigned WORD_LENGTH         :  1;
        unsigned RSRVD1              :  1;
        unsigned SS3D_EFFECT         :  2;
        unsigned RSRVD2              :  2;
        unsigned INVERT_1BIT         :  1;
        unsigned EDGE_SYNC           :  1;
        unsigned LR_SWAP             :  1;
        unsigned RSRVD3              :  1;
        unsigned DMAWAIT_COUNT       :  5;
        unsigned RSRVD4              :  9;
        unsigned CLKGATE             :  1;
        unsigned SFTRST              :  1;
    } B;
} hw_audioout_ctrl_t;
#endif


//
// constants & macros for entire HW_AUDIOOUT_CTRL register
//

#define HW_AUDIOOUT_CTRL_ADDR      (REGS_AUDIOOUT_BASE + 0x00000000)
#define HW_AUDIOOUT_CTRL_SET_ADDR  (REGS_AUDIOOUT_BASE + 0x00000004)
#define HW_AUDIOOUT_CTRL_CLR_ADDR  (REGS_AUDIOOUT_BASE + 0x00000008)
#define HW_AUDIOOUT_CTRL_TOG_ADDR  (REGS_AUDIOOUT_BASE + 0x0000000C)

#ifndef __LANGUAGE_ASM__
#define HW_AUDIOOUT_CTRL           (*(volatile hw_audioout_ctrl_t *) HW_AUDIOOUT_CTRL_ADDR)
#define HW_AUDIOOUT_CTRL_RD()      (HW_AUDIOOUT_CTRL.U)
#define HW_AUDIOOUT_CTRL_WR(v)     (HW_AUDIOOUT_CTRL.U = (v))
#define HW_AUDIOOUT_CTRL_SET(v)    ((*(volatile reg32_t *) HW_AUDIOOUT_CTRL_SET_ADDR) = (v))
#define HW_AUDIOOUT_CTRL_CLR(v)    ((*(volatile reg32_t *) HW_AUDIOOUT_CTRL_CLR_ADDR) = (v))
#define HW_AUDIOOUT_CTRL_TOG(v)    ((*(volatile reg32_t *) HW_AUDIOOUT_CTRL_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_AUDIOOUT_CTRL bitfields
//

//--- Register HW_AUDIOOUT_CTRL, field SFTRST

#define BP_AUDIOOUT_CTRL_SFTRST      31
#define BM_AUDIOOUT_CTRL_SFTRST      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_AUDIOOUT_CTRL_SFTRST(v)   ((((reg32_t) v) << 31) & BM_AUDIOOUT_CTRL_SFTRST)
#else
#define BF_AUDIOOUT_CTRL_SFTRST(v)   (((v) << 31) & BM_AUDIOOUT_CTRL_SFTRST)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_CTRL_SFTRST(v)   BF_CS1(AUDIOOUT_CTRL, SFTRST, v)
#endif

//--- Register HW_AUDIOOUT_CTRL, field CLKGATE

#define BP_AUDIOOUT_CTRL_CLKGATE      30
#define BM_AUDIOOUT_CTRL_CLKGATE      0x40000000

#define BF_AUDIOOUT_CTRL_CLKGATE(v)   (((v) << 30) & BM_AUDIOOUT_CTRL_CLKGATE)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_CTRL_CLKGATE(v)   BF_CS1(AUDIOOUT_CTRL, CLKGATE, v)
#endif

//--- Register HW_AUDIOOUT_CTRL, field DMAWAIT_COUNT

#define BP_AUDIOOUT_CTRL_DMAWAIT_COUNT      16
#define BM_AUDIOOUT_CTRL_DMAWAIT_COUNT      0x001F0000

#define BF_AUDIOOUT_CTRL_DMAWAIT_COUNT(v)   (((v) << 16) & BM_AUDIOOUT_CTRL_DMAWAIT_COUNT)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_CTRL_DMAWAIT_COUNT(v)   BF_CS1(AUDIOOUT_CTRL, DMAWAIT_COUNT, v)
#endif

//--- Register HW_AUDIOOUT_CTRL, field LR_SWAP

#define BP_AUDIOOUT_CTRL_LR_SWAP      14
#define BM_AUDIOOUT_CTRL_LR_SWAP      0x00004000

#define BF_AUDIOOUT_CTRL_LR_SWAP(v)   (((v) << 14) & BM_AUDIOOUT_CTRL_LR_SWAP)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_CTRL_LR_SWAP(v)   BF_CS1(AUDIOOUT_CTRL, LR_SWAP, v)
#endif

//--- Register HW_AUDIOOUT_CTRL, field EDGE_SYNC

#define BP_AUDIOOUT_CTRL_EDGE_SYNC      13
#define BM_AUDIOOUT_CTRL_EDGE_SYNC      0x00002000

#define BF_AUDIOOUT_CTRL_EDGE_SYNC(v)   (((v) << 13) & BM_AUDIOOUT_CTRL_EDGE_SYNC)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_CTRL_EDGE_SYNC(v)   BF_CS1(AUDIOOUT_CTRL, EDGE_SYNC, v)
#endif

//--- Register HW_AUDIOOUT_CTRL, field INVERT_1BIT

#define BP_AUDIOOUT_CTRL_INVERT_1BIT      12
#define BM_AUDIOOUT_CTRL_INVERT_1BIT      0x00001000

#define BF_AUDIOOUT_CTRL_INVERT_1BIT(v)   (((v) << 12) & BM_AUDIOOUT_CTRL_INVERT_1BIT)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_CTRL_INVERT_1BIT(v)   BF_CS1(AUDIOOUT_CTRL, INVERT_1BIT, v)
#endif

//--- Register HW_AUDIOOUT_CTRL, field SS3D_EFFECT

#define BP_AUDIOOUT_CTRL_SS3D_EFFECT      8
#define BM_AUDIOOUT_CTRL_SS3D_EFFECT      0x00000300

#define BF_AUDIOOUT_CTRL_SS3D_EFFECT(v)   (((v) << 8) & BM_AUDIOOUT_CTRL_SS3D_EFFECT)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_CTRL_SS3D_EFFECT(v)   BF_CS1(AUDIOOUT_CTRL, SS3D_EFFECT, v)
#endif

//--- Register HW_AUDIOOUT_CTRL, field WORD_LENGTH

#define BP_AUDIOOUT_CTRL_WORD_LENGTH      6
#define BM_AUDIOOUT_CTRL_WORD_LENGTH      0x00000040

#define BF_AUDIOOUT_CTRL_WORD_LENGTH(v)   (((v) << 6) & BM_AUDIOOUT_CTRL_WORD_LENGTH)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_CTRL_WORD_LENGTH(v)   BF_CS1(AUDIOOUT_CTRL, WORD_LENGTH, v)
#endif

//--- Register HW_AUDIOOUT_CTRL, field DAC_ZERO_ENABLE

#define BP_AUDIOOUT_CTRL_DAC_ZERO_ENABLE      5
#define BM_AUDIOOUT_CTRL_DAC_ZERO_ENABLE      0x00000020

#define BF_AUDIOOUT_CTRL_DAC_ZERO_ENABLE(v)   (((v) << 5) & BM_AUDIOOUT_CTRL_DAC_ZERO_ENABLE)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_CTRL_DAC_ZERO_ENABLE(v)   BF_CS1(AUDIOOUT_CTRL, DAC_ZERO_ENABLE, v)
#endif

//--- Register HW_AUDIOOUT_CTRL, field LOOPBACK

#define BP_AUDIOOUT_CTRL_LOOPBACK      4
#define BM_AUDIOOUT_CTRL_LOOPBACK      0x00000010

#define BF_AUDIOOUT_CTRL_LOOPBACK(v)   (((v) << 4) & BM_AUDIOOUT_CTRL_LOOPBACK)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_CTRL_LOOPBACK(v)   BF_CS1(AUDIOOUT_CTRL, LOOPBACK, v)
#endif

//--- Register HW_AUDIOOUT_CTRL, field FIFO_UNDERFLOW_IRQ

#define BP_AUDIOOUT_CTRL_FIFO_UNDERFLOW_IRQ      3
#define BM_AUDIOOUT_CTRL_FIFO_UNDERFLOW_IRQ      0x00000008

#define BF_AUDIOOUT_CTRL_FIFO_UNDERFLOW_IRQ(v)   (((v) << 3) & BM_AUDIOOUT_CTRL_FIFO_UNDERFLOW_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_CTRL_FIFO_UNDERFLOW_IRQ(v)   BF_CS1(AUDIOOUT_CTRL, FIFO_UNDERFLOW_IRQ, v)
#endif

//--- Register HW_AUDIOOUT_CTRL, field FIFO_OVERFLOW_IRQ

#define BP_AUDIOOUT_CTRL_FIFO_OVERFLOW_IRQ      2
#define BM_AUDIOOUT_CTRL_FIFO_OVERFLOW_IRQ      0x00000004

#define BF_AUDIOOUT_CTRL_FIFO_OVERFLOW_IRQ(v)   (((v) << 2) & BM_AUDIOOUT_CTRL_FIFO_OVERFLOW_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_CTRL_FIFO_OVERFLOW_IRQ(v)   BF_CS1(AUDIOOUT_CTRL, FIFO_OVERFLOW_IRQ, v)
#endif

//--- Register HW_AUDIOOUT_CTRL, field FIFO_ERROR_IRQ_EN

#define BP_AUDIOOUT_CTRL_FIFO_ERROR_IRQ_EN      1
#define BM_AUDIOOUT_CTRL_FIFO_ERROR_IRQ_EN      0x00000002

#define BF_AUDIOOUT_CTRL_FIFO_ERROR_IRQ_EN(v)   (((v) << 1) & BM_AUDIOOUT_CTRL_FIFO_ERROR_IRQ_EN)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_CTRL_FIFO_ERROR_IRQ_EN(v)   BF_CS1(AUDIOOUT_CTRL, FIFO_ERROR_IRQ_EN, v)
#endif

//--- Register HW_AUDIOOUT_CTRL, field RUN

#define BP_AUDIOOUT_CTRL_RUN      0
#define BM_AUDIOOUT_CTRL_RUN      0x00000001

#define BF_AUDIOOUT_CTRL_RUN(v)   (((v) << 0) & BM_AUDIOOUT_CTRL_RUN)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_CTRL_RUN(v)   BF_CS1(AUDIOOUT_CTRL, RUN, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_AUDIOOUT_STAT - AUDIOOUT Status Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSRVD1       : 31;
        unsigned DAC_PRESENT  :  1;
    } B;
} hw_audioout_stat_t;
#endif


//
// constants & macros for entire HW_AUDIOOUT_STAT register
//

#define HW_AUDIOOUT_STAT_ADDR      (REGS_AUDIOOUT_BASE + 0x00000010)

#ifndef __LANGUAGE_ASM__
#define HW_AUDIOOUT_STAT           (*(volatile hw_audioout_stat_t *) HW_AUDIOOUT_STAT_ADDR)
#define HW_AUDIOOUT_STAT_RD()      (HW_AUDIOOUT_STAT.U)
#endif


//
// constants & macros for individual HW_AUDIOOUT_STAT bitfields
//

//--- Register HW_AUDIOOUT_STAT, field DAC_PRESENT

#define BP_AUDIOOUT_STAT_DAC_PRESENT      31
#define BM_AUDIOOUT_STAT_DAC_PRESENT      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_AUDIOOUT_STAT_DAC_PRESENT(v)   ((((reg32_t) v) << 31) & BM_AUDIOOUT_STAT_DAC_PRESENT)
#else
#define BF_AUDIOOUT_STAT_DAC_PRESENT(v)   (((v) << 31) & BM_AUDIOOUT_STAT_DAC_PRESENT)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_AUDIOOUT_DACSRR - AUDIOOUT Sample Rate Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned SRC_FRAC  : 13;
        unsigned RSRVD0    :  3;
        unsigned SRC_INT   :  5;
        unsigned RSRVD1    :  3;
        unsigned SRC_HOLD  :  3;
        unsigned RSRVD2    :  1;
        unsigned BASEMULT  :  3;
        unsigned OSR       :  1;
    } B;
} hw_audioout_dacsrr_t;
#endif


//
// constants & macros for entire HW_AUDIOOUT_DACSRR register
//

#define HW_AUDIOOUT_DACSRR_ADDR      (REGS_AUDIOOUT_BASE + 0x00000020)
#define HW_AUDIOOUT_DACSRR_SET_ADDR  (REGS_AUDIOOUT_BASE + 0x00000024)
#define HW_AUDIOOUT_DACSRR_CLR_ADDR  (REGS_AUDIOOUT_BASE + 0x00000028)
#define HW_AUDIOOUT_DACSRR_TOG_ADDR  (REGS_AUDIOOUT_BASE + 0x0000002C)

#ifndef __LANGUAGE_ASM__
#define HW_AUDIOOUT_DACSRR           (*(volatile hw_audioout_dacsrr_t *) HW_AUDIOOUT_DACSRR_ADDR)
#define HW_AUDIOOUT_DACSRR_RD()      (HW_AUDIOOUT_DACSRR.U)
#define HW_AUDIOOUT_DACSRR_WR(v)     (HW_AUDIOOUT_DACSRR.U = (v))
#define HW_AUDIOOUT_DACSRR_SET(v)    ((*(volatile reg32_t *) HW_AUDIOOUT_DACSRR_SET_ADDR) = (v))
#define HW_AUDIOOUT_DACSRR_CLR(v)    ((*(volatile reg32_t *) HW_AUDIOOUT_DACSRR_CLR_ADDR) = (v))
#define HW_AUDIOOUT_DACSRR_TOG(v)    ((*(volatile reg32_t *) HW_AUDIOOUT_DACSRR_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_AUDIOOUT_DACSRR bitfields
//

//--- Register HW_AUDIOOUT_DACSRR, field OSR

#define BP_AUDIOOUT_DACSRR_OSR      31
#define BM_AUDIOOUT_DACSRR_OSR      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_AUDIOOUT_DACSRR_OSR(v)   ((((reg32_t) v) << 31) & BM_AUDIOOUT_DACSRR_OSR)
#else
#define BF_AUDIOOUT_DACSRR_OSR(v)   (((v) << 31) & BM_AUDIOOUT_DACSRR_OSR)
#endif

#define BV_AUDIOOUT_DACSRR_OSR__OSR6   0x0
#define BV_AUDIOOUT_DACSRR_OSR__OSR12  0x1

//--- Register HW_AUDIOOUT_DACSRR, field BASEMULT

#define BP_AUDIOOUT_DACSRR_BASEMULT      28
#define BM_AUDIOOUT_DACSRR_BASEMULT      0x70000000

#define BF_AUDIOOUT_DACSRR_BASEMULT(v)   (((v) << 28) & BM_AUDIOOUT_DACSRR_BASEMULT)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_DACSRR_BASEMULT(v)   BF_CS1(AUDIOOUT_DACSRR, BASEMULT, v)
#endif

#define BV_AUDIOOUT_DACSRR_BASEMULT__SINGLE_RATE  0x1
#define BV_AUDIOOUT_DACSRR_BASEMULT__DOUBLE_RATE  0x2
#define BV_AUDIOOUT_DACSRR_BASEMULT__QUAD_RATE    0x4

//--- Register HW_AUDIOOUT_DACSRR, field SRC_HOLD

#define BP_AUDIOOUT_DACSRR_SRC_HOLD      24
#define BM_AUDIOOUT_DACSRR_SRC_HOLD      0x07000000

#define BF_AUDIOOUT_DACSRR_SRC_HOLD(v)   (((v) << 24) & BM_AUDIOOUT_DACSRR_SRC_HOLD)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_DACSRR_SRC_HOLD(v)   BF_CS1(AUDIOOUT_DACSRR, SRC_HOLD, v)
#endif

//--- Register HW_AUDIOOUT_DACSRR, field SRC_INT

#define BP_AUDIOOUT_DACSRR_SRC_INT      16
#define BM_AUDIOOUT_DACSRR_SRC_INT      0x001F0000

#define BF_AUDIOOUT_DACSRR_SRC_INT(v)   (((v) << 16) & BM_AUDIOOUT_DACSRR_SRC_INT)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_DACSRR_SRC_INT(v)   BF_CS1(AUDIOOUT_DACSRR, SRC_INT, v)
#endif

//--- Register HW_AUDIOOUT_DACSRR, field SRC_FRAC

#define BP_AUDIOOUT_DACSRR_SRC_FRAC      0
#define BM_AUDIOOUT_DACSRR_SRC_FRAC      0x00001FFF

#define BF_AUDIOOUT_DACSRR_SRC_FRAC(v)   (((v) << 0) & BM_AUDIOOUT_DACSRR_SRC_FRAC)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_DACSRR_SRC_FRAC(v)   BF_CS1(AUDIOOUT_DACSRR, SRC_FRAC, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_AUDIOOUT_DACVOLUME - AUDIOOUT Volume Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg8_t   VOLUME_RIGHT;
        unsigned MUTE_RIGHT           :  1;
        unsigned RSRVD1               :  3;
        unsigned VOLUME_UPDATE_RIGHT  :  1;
        unsigned RSRVD2               :  3;
        reg8_t   VOLUME_LEFT;
        unsigned MUTE_LEFT            :  1;
        unsigned EN_ZCD               :  1;
        unsigned RSRVD3               :  2;
        unsigned VOLUME_UPDATE_LEFT   :  1;
        unsigned RSRVD4               :  3;
    } B;
} hw_audioout_dacvolume_t;
#endif


//
// constants & macros for entire HW_AUDIOOUT_DACVOLUME register
//

#define HW_AUDIOOUT_DACVOLUME_ADDR      (REGS_AUDIOOUT_BASE + 0x00000030)
#define HW_AUDIOOUT_DACVOLUME_SET_ADDR  (REGS_AUDIOOUT_BASE + 0x00000034)
#define HW_AUDIOOUT_DACVOLUME_CLR_ADDR  (REGS_AUDIOOUT_BASE + 0x00000038)
#define HW_AUDIOOUT_DACVOLUME_TOG_ADDR  (REGS_AUDIOOUT_BASE + 0x0000003C)

#ifndef __LANGUAGE_ASM__
#define HW_AUDIOOUT_DACVOLUME           (*(volatile hw_audioout_dacvolume_t *) HW_AUDIOOUT_DACVOLUME_ADDR)
#define HW_AUDIOOUT_DACVOLUME_RD()      (HW_AUDIOOUT_DACVOLUME.U)
#define HW_AUDIOOUT_DACVOLUME_WR(v)     (HW_AUDIOOUT_DACVOLUME.U = (v))
#define HW_AUDIOOUT_DACVOLUME_SET(v)    ((*(volatile reg32_t *) HW_AUDIOOUT_DACVOLUME_SET_ADDR) = (v))
#define HW_AUDIOOUT_DACVOLUME_CLR(v)    ((*(volatile reg32_t *) HW_AUDIOOUT_DACVOLUME_CLR_ADDR) = (v))
#define HW_AUDIOOUT_DACVOLUME_TOG(v)    ((*(volatile reg32_t *) HW_AUDIOOUT_DACVOLUME_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_AUDIOOUT_DACVOLUME bitfields
//

//--- Register HW_AUDIOOUT_DACVOLUME, field VOLUME_UPDATE_LEFT

#define BP_AUDIOOUT_DACVOLUME_VOLUME_UPDATE_LEFT      28
#define BM_AUDIOOUT_DACVOLUME_VOLUME_UPDATE_LEFT      0x10000000

#define BF_AUDIOOUT_DACVOLUME_VOLUME_UPDATE_LEFT(v)   (((v) << 28) & BM_AUDIOOUT_DACVOLUME_VOLUME_UPDATE_LEFT)

//--- Register HW_AUDIOOUT_DACVOLUME, field EN_ZCD

#define BP_AUDIOOUT_DACVOLUME_EN_ZCD      25
#define BM_AUDIOOUT_DACVOLUME_EN_ZCD      0x02000000

#define BF_AUDIOOUT_DACVOLUME_EN_ZCD(v)   (((v) << 25) & BM_AUDIOOUT_DACVOLUME_EN_ZCD)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_DACVOLUME_EN_ZCD(v)   BF_CS1(AUDIOOUT_DACVOLUME, EN_ZCD, v)
#endif

//--- Register HW_AUDIOOUT_DACVOLUME, field MUTE_LEFT

#define BP_AUDIOOUT_DACVOLUME_MUTE_LEFT      24
#define BM_AUDIOOUT_DACVOLUME_MUTE_LEFT      0x01000000

#define BF_AUDIOOUT_DACVOLUME_MUTE_LEFT(v)   (((v) << 24) & BM_AUDIOOUT_DACVOLUME_MUTE_LEFT)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_DACVOLUME_MUTE_LEFT(v)   BF_CS1(AUDIOOUT_DACVOLUME, MUTE_LEFT, v)
#endif

//--- Register HW_AUDIOOUT_DACVOLUME, field VOLUME_LEFT

#define BP_AUDIOOUT_DACVOLUME_VOLUME_LEFT      16
#define BM_AUDIOOUT_DACVOLUME_VOLUME_LEFT      0x00FF0000

#define BF_AUDIOOUT_DACVOLUME_VOLUME_LEFT(v)   (((v) << 16) & BM_AUDIOOUT_DACVOLUME_VOLUME_LEFT)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_DACVOLUME_VOLUME_LEFT(v)   (HW_AUDIOOUT_DACVOLUME.B.VOLUME_LEFT = (v))
#endif

//--- Register HW_AUDIOOUT_DACVOLUME, field VOLUME_UPDATE_RIGHT

#define BP_AUDIOOUT_DACVOLUME_VOLUME_UPDATE_RIGHT      12
#define BM_AUDIOOUT_DACVOLUME_VOLUME_UPDATE_RIGHT      0x00001000

#define BF_AUDIOOUT_DACVOLUME_VOLUME_UPDATE_RIGHT(v)   (((v) << 12) & BM_AUDIOOUT_DACVOLUME_VOLUME_UPDATE_RIGHT)

//--- Register HW_AUDIOOUT_DACVOLUME, field MUTE_RIGHT

#define BP_AUDIOOUT_DACVOLUME_MUTE_RIGHT      8
#define BM_AUDIOOUT_DACVOLUME_MUTE_RIGHT      0x00000100

#define BF_AUDIOOUT_DACVOLUME_MUTE_RIGHT(v)   (((v) << 8) & BM_AUDIOOUT_DACVOLUME_MUTE_RIGHT)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_DACVOLUME_MUTE_RIGHT(v)   BF_CS1(AUDIOOUT_DACVOLUME, MUTE_RIGHT, v)
#endif

//--- Register HW_AUDIOOUT_DACVOLUME, field VOLUME_RIGHT

#define BP_AUDIOOUT_DACVOLUME_VOLUME_RIGHT      0
#define BM_AUDIOOUT_DACVOLUME_VOLUME_RIGHT      0x000000FF

#define BF_AUDIOOUT_DACVOLUME_VOLUME_RIGHT(v)   (((v) << 0) & BM_AUDIOOUT_DACVOLUME_VOLUME_RIGHT)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_DACVOLUME_VOLUME_RIGHT(v)   (HW_AUDIOOUT_DACVOLUME.B.VOLUME_RIGHT = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_AUDIOOUT_DACDEBUG - AUDIOOUT Debug Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned FIFO_STATUS                :  1;
        unsigned DMA_PREQ                   :  1;
        unsigned SET_INTERRUPT0_HAND_SHAKE  :  1;
        unsigned SET_INTERRUPT1_HAND_SHAKE  :  1;
        unsigned SET_INTERRUPT0_CLK_CROSS   :  1;
        unsigned SET_INTERRUPT1_CLK_CROSS   :  1;
        unsigned RSRVD1                     :  2;
        unsigned RAM_SS                     :  4;
        unsigned RSRVD2                     : 19;
        unsigned ENABLE_DACDMA              :  1;
    } B;
} hw_audioout_dacdebug_t;
#endif


//
// constants & macros for entire HW_AUDIOOUT_DACDEBUG register
//

#define HW_AUDIOOUT_DACDEBUG_ADDR      (REGS_AUDIOOUT_BASE + 0x00000040)
#define HW_AUDIOOUT_DACDEBUG_SET_ADDR  (REGS_AUDIOOUT_BASE + 0x00000044)
#define HW_AUDIOOUT_DACDEBUG_CLR_ADDR  (REGS_AUDIOOUT_BASE + 0x00000048)
#define HW_AUDIOOUT_DACDEBUG_TOG_ADDR  (REGS_AUDIOOUT_BASE + 0x0000004C)

#ifndef __LANGUAGE_ASM__
#define HW_AUDIOOUT_DACDEBUG           (*(volatile hw_audioout_dacdebug_t *) HW_AUDIOOUT_DACDEBUG_ADDR)
#define HW_AUDIOOUT_DACDEBUG_RD()      (HW_AUDIOOUT_DACDEBUG.U)
#define HW_AUDIOOUT_DACDEBUG_WR(v)     (HW_AUDIOOUT_DACDEBUG.U = (v))
#define HW_AUDIOOUT_DACDEBUG_SET(v)    ((*(volatile reg32_t *) HW_AUDIOOUT_DACDEBUG_SET_ADDR) = (v))
#define HW_AUDIOOUT_DACDEBUG_CLR(v)    ((*(volatile reg32_t *) HW_AUDIOOUT_DACDEBUG_CLR_ADDR) = (v))
#define HW_AUDIOOUT_DACDEBUG_TOG(v)    ((*(volatile reg32_t *) HW_AUDIOOUT_DACDEBUG_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_AUDIOOUT_DACDEBUG bitfields
//

//--- Register HW_AUDIOOUT_DACDEBUG, field ENABLE_DACDMA

#define BP_AUDIOOUT_DACDEBUG_ENABLE_DACDMA      31
#define BM_AUDIOOUT_DACDEBUG_ENABLE_DACDMA      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_AUDIOOUT_DACDEBUG_ENABLE_DACDMA(v)   ((((reg32_t) v) << 31) & BM_AUDIOOUT_DACDEBUG_ENABLE_DACDMA)
#else
#define BF_AUDIOOUT_DACDEBUG_ENABLE_DACDMA(v)   (((v) << 31) & BM_AUDIOOUT_DACDEBUG_ENABLE_DACDMA)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_DACDEBUG_ENABLE_DACDMA(v)   BF_CS1(AUDIOOUT_DACDEBUG, ENABLE_DACDMA, v)
#endif

//--- Register HW_AUDIOOUT_DACDEBUG, field RAM_SS

#define BP_AUDIOOUT_DACDEBUG_RAM_SS      8
#define BM_AUDIOOUT_DACDEBUG_RAM_SS      0x00000F00

#define BF_AUDIOOUT_DACDEBUG_RAM_SS(v)   (((v) << 8) & BM_AUDIOOUT_DACDEBUG_RAM_SS)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_DACDEBUG_RAM_SS(v)   BF_CS1(AUDIOOUT_DACDEBUG, RAM_SS, v)
#endif

//--- Register HW_AUDIOOUT_DACDEBUG, field SET_INTERRUPT1_CLK_CROSS

#define BP_AUDIOOUT_DACDEBUG_SET_INTERRUPT1_CLK_CROSS      5
#define BM_AUDIOOUT_DACDEBUG_SET_INTERRUPT1_CLK_CROSS      0x00000020

#define BF_AUDIOOUT_DACDEBUG_SET_INTERRUPT1_CLK_CROSS(v)   (((v) << 5) & BM_AUDIOOUT_DACDEBUG_SET_INTERRUPT1_CLK_CROSS)

//--- Register HW_AUDIOOUT_DACDEBUG, field SET_INTERRUPT0_CLK_CROSS

#define BP_AUDIOOUT_DACDEBUG_SET_INTERRUPT0_CLK_CROSS      4
#define BM_AUDIOOUT_DACDEBUG_SET_INTERRUPT0_CLK_CROSS      0x00000010

#define BF_AUDIOOUT_DACDEBUG_SET_INTERRUPT0_CLK_CROSS(v)   (((v) << 4) & BM_AUDIOOUT_DACDEBUG_SET_INTERRUPT0_CLK_CROSS)

//--- Register HW_AUDIOOUT_DACDEBUG, field SET_INTERRUPT1_HAND_SHAKE

#define BP_AUDIOOUT_DACDEBUG_SET_INTERRUPT1_HAND_SHAKE      3
#define BM_AUDIOOUT_DACDEBUG_SET_INTERRUPT1_HAND_SHAKE      0x00000008

#define BF_AUDIOOUT_DACDEBUG_SET_INTERRUPT1_HAND_SHAKE(v)   (((v) << 3) & BM_AUDIOOUT_DACDEBUG_SET_INTERRUPT1_HAND_SHAKE)

//--- Register HW_AUDIOOUT_DACDEBUG, field SET_INTERRUPT0_HAND_SHAKE

#define BP_AUDIOOUT_DACDEBUG_SET_INTERRUPT0_HAND_SHAKE      2
#define BM_AUDIOOUT_DACDEBUG_SET_INTERRUPT0_HAND_SHAKE      0x00000004

#define BF_AUDIOOUT_DACDEBUG_SET_INTERRUPT0_HAND_SHAKE(v)   (((v) << 2) & BM_AUDIOOUT_DACDEBUG_SET_INTERRUPT0_HAND_SHAKE)

//--- Register HW_AUDIOOUT_DACDEBUG, field DMA_PREQ

#define BP_AUDIOOUT_DACDEBUG_DMA_PREQ      1
#define BM_AUDIOOUT_DACDEBUG_DMA_PREQ      0x00000002

#define BF_AUDIOOUT_DACDEBUG_DMA_PREQ(v)   (((v) << 1) & BM_AUDIOOUT_DACDEBUG_DMA_PREQ)

//--- Register HW_AUDIOOUT_DACDEBUG, field FIFO_STATUS

#define BP_AUDIOOUT_DACDEBUG_FIFO_STATUS      0
#define BM_AUDIOOUT_DACDEBUG_FIFO_STATUS      0x00000001

#define BF_AUDIOOUT_DACDEBUG_FIFO_STATUS(v)   (((v) << 0) & BM_AUDIOOUT_DACDEBUG_FIFO_STATUS)


////////////////////////////////////////////////////////////////////////////////
//// HW_AUDIOOUT_HPVOL - Headphone Volume and Select Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned VOL_RIGHT              :  7;
        unsigned RSRVD1                 :  1;
        unsigned VOL_LEFT               :  7;
        unsigned RSRVD2                 :  1;
        unsigned SELECT                 :  1;
        unsigned RSRVD3                 :  7;
        unsigned MUTE                   :  1;
        unsigned EN_MSTR_ZCD            :  1;
        unsigned RSRVD4                 :  2;
        unsigned VOLUME_UPDATE_PENDING  :  1;
        unsigned RSRVD5                 :  3;
    } B;
} hw_audioout_hpvol_t;
#endif


//
// constants & macros for entire HW_AUDIOOUT_HPVOL register
//

#define HW_AUDIOOUT_HPVOL_ADDR      (REGS_AUDIOOUT_BASE + 0x00000050)
#define HW_AUDIOOUT_HPVOL_SET_ADDR  (REGS_AUDIOOUT_BASE + 0x00000054)
#define HW_AUDIOOUT_HPVOL_CLR_ADDR  (REGS_AUDIOOUT_BASE + 0x00000058)
#define HW_AUDIOOUT_HPVOL_TOG_ADDR  (REGS_AUDIOOUT_BASE + 0x0000005C)

#ifndef __LANGUAGE_ASM__
#define HW_AUDIOOUT_HPVOL           (*(volatile hw_audioout_hpvol_t *) HW_AUDIOOUT_HPVOL_ADDR)
#define HW_AUDIOOUT_HPVOL_RD()      (HW_AUDIOOUT_HPVOL.U)
#define HW_AUDIOOUT_HPVOL_WR(v)     (HW_AUDIOOUT_HPVOL.U = (v))
#define HW_AUDIOOUT_HPVOL_SET(v)    ((*(volatile reg32_t *) HW_AUDIOOUT_HPVOL_SET_ADDR) = (v))
#define HW_AUDIOOUT_HPVOL_CLR(v)    ((*(volatile reg32_t *) HW_AUDIOOUT_HPVOL_CLR_ADDR) = (v))
#define HW_AUDIOOUT_HPVOL_TOG(v)    ((*(volatile reg32_t *) HW_AUDIOOUT_HPVOL_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_AUDIOOUT_HPVOL bitfields
//

//--- Register HW_AUDIOOUT_HPVOL, field VOLUME_UPDATE_PENDING

#define BP_AUDIOOUT_HPVOL_VOLUME_UPDATE_PENDING      28
#define BM_AUDIOOUT_HPVOL_VOLUME_UPDATE_PENDING      0x10000000

#define BF_AUDIOOUT_HPVOL_VOLUME_UPDATE_PENDING(v)   (((v) << 28) & BM_AUDIOOUT_HPVOL_VOLUME_UPDATE_PENDING)

//--- Register HW_AUDIOOUT_HPVOL, field EN_MSTR_ZCD

#define BP_AUDIOOUT_HPVOL_EN_MSTR_ZCD      25
#define BM_AUDIOOUT_HPVOL_EN_MSTR_ZCD      0x02000000

#define BF_AUDIOOUT_HPVOL_EN_MSTR_ZCD(v)   (((v) << 25) & BM_AUDIOOUT_HPVOL_EN_MSTR_ZCD)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_HPVOL_EN_MSTR_ZCD(v)   BF_CS1(AUDIOOUT_HPVOL, EN_MSTR_ZCD, v)
#endif

//--- Register HW_AUDIOOUT_HPVOL, field MUTE

#define BP_AUDIOOUT_HPVOL_MUTE      24
#define BM_AUDIOOUT_HPVOL_MUTE      0x01000000

#define BF_AUDIOOUT_HPVOL_MUTE(v)   (((v) << 24) & BM_AUDIOOUT_HPVOL_MUTE)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_HPVOL_MUTE(v)   BF_CS1(AUDIOOUT_HPVOL, MUTE, v)
#endif

//--- Register HW_AUDIOOUT_HPVOL, field SELECT

#define BP_AUDIOOUT_HPVOL_SELECT      16
#define BM_AUDIOOUT_HPVOL_SELECT      0x00010000

#define BF_AUDIOOUT_HPVOL_SELECT(v)   (((v) << 16) & BM_AUDIOOUT_HPVOL_SELECT)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_HPVOL_SELECT(v)   BF_CS1(AUDIOOUT_HPVOL, SELECT, v)
#endif

//--- Register HW_AUDIOOUT_HPVOL, field VOL_LEFT

#define BP_AUDIOOUT_HPVOL_VOL_LEFT      8
#define BM_AUDIOOUT_HPVOL_VOL_LEFT      0x00007F00

#define BF_AUDIOOUT_HPVOL_VOL_LEFT(v)   (((v) << 8) & BM_AUDIOOUT_HPVOL_VOL_LEFT)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_HPVOL_VOL_LEFT(v)   BF_CS1(AUDIOOUT_HPVOL, VOL_LEFT, v)
#endif

//--- Register HW_AUDIOOUT_HPVOL, field VOL_RIGHT

#define BP_AUDIOOUT_HPVOL_VOL_RIGHT      0
#define BM_AUDIOOUT_HPVOL_VOL_RIGHT      0x0000007F

#define BF_AUDIOOUT_HPVOL_VOL_RIGHT(v)   (((v) << 0) & BM_AUDIOOUT_HPVOL_VOL_RIGHT)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_HPVOL_VOL_RIGHT(v)   BF_CS1(AUDIOOUT_HPVOL, VOL_RIGHT, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_AUDIOOUT_RESERVED - Reserved Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  RSRVD1;
    } B;
} hw_audioout_reserved_t;
#endif


//
// constants & macros for entire HW_AUDIOOUT_RESERVED register
//

#define HW_AUDIOOUT_RESERVED_ADDR      (REGS_AUDIOOUT_BASE + 0x00000060)

#ifndef __LANGUAGE_ASM__
#define HW_AUDIOOUT_RESERVED           (*(volatile hw_audioout_reserved_t *) HW_AUDIOOUT_RESERVED_ADDR)
#define HW_AUDIOOUT_RESERVED_RD()      (HW_AUDIOOUT_RESERVED.U)
#endif


//
// constants & macros for individual HW_AUDIOOUT_RESERVED bitfields
//


////////////////////////////////////////////////////////////////////////////////
//// HW_AUDIOOUT_PWRDN - Audio Power-Down Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned HEADPHONE  :  1;
        unsigned RSRVD1     :  3;
        unsigned CAPLESS    :  1;
        unsigned RSRVD2     :  3;
        unsigned ADC        :  1;
        unsigned RSRVD3     :  3;
        unsigned DAC        :  1;
        unsigned RSRVD4     :  3;
        unsigned RIGHT_ADC  :  1;
        unsigned RSRVD5     :  3;
        unsigned SELFBIAS   :  1;
        unsigned RSRVD6     :  3;
        unsigned SPEAKER    :  1;
        unsigned RSRVD7     :  7;
    } B;
} hw_audioout_pwrdn_t;
#endif


//
// constants & macros for entire HW_AUDIOOUT_PWRDN register
//

#define HW_AUDIOOUT_PWRDN_ADDR      (REGS_AUDIOOUT_BASE + 0x00000070)
#define HW_AUDIOOUT_PWRDN_SET_ADDR  (REGS_AUDIOOUT_BASE + 0x00000074)
#define HW_AUDIOOUT_PWRDN_CLR_ADDR  (REGS_AUDIOOUT_BASE + 0x00000078)
#define HW_AUDIOOUT_PWRDN_TOG_ADDR  (REGS_AUDIOOUT_BASE + 0x0000007C)

#ifndef __LANGUAGE_ASM__
#define HW_AUDIOOUT_PWRDN           (*(volatile hw_audioout_pwrdn_t *) HW_AUDIOOUT_PWRDN_ADDR)
#define HW_AUDIOOUT_PWRDN_RD()      (HW_AUDIOOUT_PWRDN.U)
#define HW_AUDIOOUT_PWRDN_WR(v)     (HW_AUDIOOUT_PWRDN.U = (v))
#define HW_AUDIOOUT_PWRDN_SET(v)    ((*(volatile reg32_t *) HW_AUDIOOUT_PWRDN_SET_ADDR) = (v))
#define HW_AUDIOOUT_PWRDN_CLR(v)    ((*(volatile reg32_t *) HW_AUDIOOUT_PWRDN_CLR_ADDR) = (v))
#define HW_AUDIOOUT_PWRDN_TOG(v)    ((*(volatile reg32_t *) HW_AUDIOOUT_PWRDN_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_AUDIOOUT_PWRDN bitfields
//

//--- Register HW_AUDIOOUT_PWRDN, field SPEAKER

#define BP_AUDIOOUT_PWRDN_SPEAKER      24
#define BM_AUDIOOUT_PWRDN_SPEAKER      0x01000000

#define BF_AUDIOOUT_PWRDN_SPEAKER(v)   (((v) << 24) & BM_AUDIOOUT_PWRDN_SPEAKER)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_PWRDN_SPEAKER(v)   BF_CS1(AUDIOOUT_PWRDN, SPEAKER, v)
#endif

//--- Register HW_AUDIOOUT_PWRDN, field SELFBIAS

#define BP_AUDIOOUT_PWRDN_SELFBIAS      20
#define BM_AUDIOOUT_PWRDN_SELFBIAS      0x00100000

#define BF_AUDIOOUT_PWRDN_SELFBIAS(v)   (((v) << 20) & BM_AUDIOOUT_PWRDN_SELFBIAS)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_PWRDN_SELFBIAS(v)   BF_CS1(AUDIOOUT_PWRDN, SELFBIAS, v)
#endif

//--- Register HW_AUDIOOUT_PWRDN, field RIGHT_ADC

#define BP_AUDIOOUT_PWRDN_RIGHT_ADC      16
#define BM_AUDIOOUT_PWRDN_RIGHT_ADC      0x00010000

#define BF_AUDIOOUT_PWRDN_RIGHT_ADC(v)   (((v) << 16) & BM_AUDIOOUT_PWRDN_RIGHT_ADC)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_PWRDN_RIGHT_ADC(v)   BF_CS1(AUDIOOUT_PWRDN, RIGHT_ADC, v)
#endif

//--- Register HW_AUDIOOUT_PWRDN, field DAC

#define BP_AUDIOOUT_PWRDN_DAC      12
#define BM_AUDIOOUT_PWRDN_DAC      0x00001000

#define BF_AUDIOOUT_PWRDN_DAC(v)   (((v) << 12) & BM_AUDIOOUT_PWRDN_DAC)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_PWRDN_DAC(v)   BF_CS1(AUDIOOUT_PWRDN, DAC, v)
#endif

//--- Register HW_AUDIOOUT_PWRDN, field ADC

#define BP_AUDIOOUT_PWRDN_ADC      8
#define BM_AUDIOOUT_PWRDN_ADC      0x00000100

#define BF_AUDIOOUT_PWRDN_ADC(v)   (((v) << 8) & BM_AUDIOOUT_PWRDN_ADC)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_PWRDN_ADC(v)   BF_CS1(AUDIOOUT_PWRDN, ADC, v)
#endif

//--- Register HW_AUDIOOUT_PWRDN, field CAPLESS

#define BP_AUDIOOUT_PWRDN_CAPLESS      4
#define BM_AUDIOOUT_PWRDN_CAPLESS      0x00000010

#define BF_AUDIOOUT_PWRDN_CAPLESS(v)   (((v) << 4) & BM_AUDIOOUT_PWRDN_CAPLESS)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_PWRDN_CAPLESS(v)   BF_CS1(AUDIOOUT_PWRDN, CAPLESS, v)
#endif

//--- Register HW_AUDIOOUT_PWRDN, field HEADPHONE

#define BP_AUDIOOUT_PWRDN_HEADPHONE      0
#define BM_AUDIOOUT_PWRDN_HEADPHONE      0x00000001

#define BF_AUDIOOUT_PWRDN_HEADPHONE(v)   (((v) << 0) & BM_AUDIOOUT_PWRDN_HEADPHONE)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_PWRDN_HEADPHONE(v)   BF_CS1(AUDIOOUT_PWRDN, HEADPHONE, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_AUDIOOUT_REFCTRL - AUDIOOUT Reference Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DAC_ADJ          :  3;
        unsigned RSRVD1           :  1;
        unsigned VAG_VAL          :  4;
        unsigned ADC_REFVAL       :  4;
        unsigned ADJ_VAG          :  1;
        unsigned ADJ_ADC          :  1;
        unsigned VDDXTAL_TO_VDDD  :  1;
        unsigned RSRVD2           :  1;
        unsigned BIAS_CTRL        :  2;
        unsigned LW_REF           :  1;
        unsigned LOW_PWR          :  1;
        unsigned VBG_ADJ          :  3;
        unsigned RSRVD3           :  1;
        unsigned XTAL_BGR_BIAS    :  1;
        unsigned RAISE_REF        :  1;
        unsigned FASTSETTLING     :  1;
        unsigned RSRVD4           :  5;
    } B;
} hw_audioout_refctrl_t;
#endif


//
// constants & macros for entire HW_AUDIOOUT_REFCTRL register
//

#define HW_AUDIOOUT_REFCTRL_ADDR      (REGS_AUDIOOUT_BASE + 0x00000080)
#define HW_AUDIOOUT_REFCTRL_SET_ADDR  (REGS_AUDIOOUT_BASE + 0x00000084)
#define HW_AUDIOOUT_REFCTRL_CLR_ADDR  (REGS_AUDIOOUT_BASE + 0x00000088)
#define HW_AUDIOOUT_REFCTRL_TOG_ADDR  (REGS_AUDIOOUT_BASE + 0x0000008C)

#ifndef __LANGUAGE_ASM__
#define HW_AUDIOOUT_REFCTRL           (*(volatile hw_audioout_refctrl_t *) HW_AUDIOOUT_REFCTRL_ADDR)
#define HW_AUDIOOUT_REFCTRL_RD()      (HW_AUDIOOUT_REFCTRL.U)
#define HW_AUDIOOUT_REFCTRL_WR(v)     (HW_AUDIOOUT_REFCTRL.U = (v))
#define HW_AUDIOOUT_REFCTRL_SET(v)    ((*(volatile reg32_t *) HW_AUDIOOUT_REFCTRL_SET_ADDR) = (v))
#define HW_AUDIOOUT_REFCTRL_CLR(v)    ((*(volatile reg32_t *) HW_AUDIOOUT_REFCTRL_CLR_ADDR) = (v))
#define HW_AUDIOOUT_REFCTRL_TOG(v)    ((*(volatile reg32_t *) HW_AUDIOOUT_REFCTRL_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_AUDIOOUT_REFCTRL bitfields
//

//--- Register HW_AUDIOOUT_REFCTRL, field FASTSETTLING

#define BP_AUDIOOUT_REFCTRL_FASTSETTLING      26
#define BM_AUDIOOUT_REFCTRL_FASTSETTLING      0x04000000

#define BF_AUDIOOUT_REFCTRL_FASTSETTLING(v)   (((v) << 26) & BM_AUDIOOUT_REFCTRL_FASTSETTLING)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_REFCTRL_FASTSETTLING(v)   BF_CS1(AUDIOOUT_REFCTRL, FASTSETTLING, v)
#endif

//--- Register HW_AUDIOOUT_REFCTRL, field RAISE_REF

#define BP_AUDIOOUT_REFCTRL_RAISE_REF      25
#define BM_AUDIOOUT_REFCTRL_RAISE_REF      0x02000000

#define BF_AUDIOOUT_REFCTRL_RAISE_REF(v)   (((v) << 25) & BM_AUDIOOUT_REFCTRL_RAISE_REF)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_REFCTRL_RAISE_REF(v)   BF_CS1(AUDIOOUT_REFCTRL, RAISE_REF, v)
#endif

//--- Register HW_AUDIOOUT_REFCTRL, field XTAL_BGR_BIAS

#define BP_AUDIOOUT_REFCTRL_XTAL_BGR_BIAS      24
#define BM_AUDIOOUT_REFCTRL_XTAL_BGR_BIAS      0x01000000

#define BF_AUDIOOUT_REFCTRL_XTAL_BGR_BIAS(v)   (((v) << 24) & BM_AUDIOOUT_REFCTRL_XTAL_BGR_BIAS)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_REFCTRL_XTAL_BGR_BIAS(v)   BF_CS1(AUDIOOUT_REFCTRL, XTAL_BGR_BIAS, v)
#endif

//--- Register HW_AUDIOOUT_REFCTRL, field VBG_ADJ

#define BP_AUDIOOUT_REFCTRL_VBG_ADJ      20
#define BM_AUDIOOUT_REFCTRL_VBG_ADJ      0x00700000

#define BF_AUDIOOUT_REFCTRL_VBG_ADJ(v)   (((v) << 20) & BM_AUDIOOUT_REFCTRL_VBG_ADJ)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_REFCTRL_VBG_ADJ(v)   BF_CS1(AUDIOOUT_REFCTRL, VBG_ADJ, v)
#endif

//--- Register HW_AUDIOOUT_REFCTRL, field LOW_PWR

#define BP_AUDIOOUT_REFCTRL_LOW_PWR      19
#define BM_AUDIOOUT_REFCTRL_LOW_PWR      0x00080000

#define BF_AUDIOOUT_REFCTRL_LOW_PWR(v)   (((v) << 19) & BM_AUDIOOUT_REFCTRL_LOW_PWR)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_REFCTRL_LOW_PWR(v)   BF_CS1(AUDIOOUT_REFCTRL, LOW_PWR, v)
#endif

//--- Register HW_AUDIOOUT_REFCTRL, field LW_REF

#define BP_AUDIOOUT_REFCTRL_LW_REF      18
#define BM_AUDIOOUT_REFCTRL_LW_REF      0x00040000

#define BF_AUDIOOUT_REFCTRL_LW_REF(v)   (((v) << 18) & BM_AUDIOOUT_REFCTRL_LW_REF)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_REFCTRL_LW_REF(v)   BF_CS1(AUDIOOUT_REFCTRL, LW_REF, v)
#endif

//--- Register HW_AUDIOOUT_REFCTRL, field BIAS_CTRL

#define BP_AUDIOOUT_REFCTRL_BIAS_CTRL      16
#define BM_AUDIOOUT_REFCTRL_BIAS_CTRL      0x00030000

#define BF_AUDIOOUT_REFCTRL_BIAS_CTRL(v)   (((v) << 16) & BM_AUDIOOUT_REFCTRL_BIAS_CTRL)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_REFCTRL_BIAS_CTRL(v)   BF_CS1(AUDIOOUT_REFCTRL, BIAS_CTRL, v)
#endif

//--- Register HW_AUDIOOUT_REFCTRL, field VDDXTAL_TO_VDDD

#define BP_AUDIOOUT_REFCTRL_VDDXTAL_TO_VDDD      14
#define BM_AUDIOOUT_REFCTRL_VDDXTAL_TO_VDDD      0x00004000

#define BF_AUDIOOUT_REFCTRL_VDDXTAL_TO_VDDD(v)   (((v) << 14) & BM_AUDIOOUT_REFCTRL_VDDXTAL_TO_VDDD)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_REFCTRL_VDDXTAL_TO_VDDD(v)   BF_CS1(AUDIOOUT_REFCTRL, VDDXTAL_TO_VDDD, v)
#endif

//--- Register HW_AUDIOOUT_REFCTRL, field ADJ_ADC

#define BP_AUDIOOUT_REFCTRL_ADJ_ADC      13
#define BM_AUDIOOUT_REFCTRL_ADJ_ADC      0x00002000

#define BF_AUDIOOUT_REFCTRL_ADJ_ADC(v)   (((v) << 13) & BM_AUDIOOUT_REFCTRL_ADJ_ADC)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_REFCTRL_ADJ_ADC(v)   BF_CS1(AUDIOOUT_REFCTRL, ADJ_ADC, v)
#endif

//--- Register HW_AUDIOOUT_REFCTRL, field ADJ_VAG

#define BP_AUDIOOUT_REFCTRL_ADJ_VAG      12
#define BM_AUDIOOUT_REFCTRL_ADJ_VAG      0x00001000

#define BF_AUDIOOUT_REFCTRL_ADJ_VAG(v)   (((v) << 12) & BM_AUDIOOUT_REFCTRL_ADJ_VAG)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_REFCTRL_ADJ_VAG(v)   BF_CS1(AUDIOOUT_REFCTRL, ADJ_VAG, v)
#endif

//--- Register HW_AUDIOOUT_REFCTRL, field ADC_REFVAL

#define BP_AUDIOOUT_REFCTRL_ADC_REFVAL      8
#define BM_AUDIOOUT_REFCTRL_ADC_REFVAL      0x00000F00

#define BF_AUDIOOUT_REFCTRL_ADC_REFVAL(v)   (((v) << 8) & BM_AUDIOOUT_REFCTRL_ADC_REFVAL)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_REFCTRL_ADC_REFVAL(v)   BF_CS1(AUDIOOUT_REFCTRL, ADC_REFVAL, v)
#endif

//--- Register HW_AUDIOOUT_REFCTRL, field VAG_VAL

#define BP_AUDIOOUT_REFCTRL_VAG_VAL      4
#define BM_AUDIOOUT_REFCTRL_VAG_VAL      0x000000F0

#define BF_AUDIOOUT_REFCTRL_VAG_VAL(v)   (((v) << 4) & BM_AUDIOOUT_REFCTRL_VAG_VAL)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_REFCTRL_VAG_VAL(v)   BF_CS1(AUDIOOUT_REFCTRL, VAG_VAL, v)
#endif

//--- Register HW_AUDIOOUT_REFCTRL, field DAC_ADJ

#define BP_AUDIOOUT_REFCTRL_DAC_ADJ      0
#define BM_AUDIOOUT_REFCTRL_DAC_ADJ      0x00000007

#define BF_AUDIOOUT_REFCTRL_DAC_ADJ(v)   (((v) << 0) & BM_AUDIOOUT_REFCTRL_DAC_ADJ)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_REFCTRL_DAC_ADJ(v)   BF_CS1(AUDIOOUT_REFCTRL, DAC_ADJ, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_AUDIOOUT_ANACTRL - Miscellaneous Audio Controls Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSRVD1         :  4;
        unsigned HP_CLASSAB     :  1;
        unsigned HP_HOLD_GND    :  1;
        unsigned RSRVD2         :  2;
        unsigned SHORT_LVLADJR  :  3;
        unsigned RSRVD3         :  1;
        unsigned SHORT_LVLADJL  :  3;
        unsigned RSRVD4         :  2;
        unsigned SHORTMODE_LR   :  2;
        unsigned RSRVD5         :  1;
        unsigned SHORTMODE_CM   :  2;
        unsigned RSRVD6         :  2;
        unsigned SHORT_LR_STS   :  1;
        unsigned RSRVD7         :  3;
        unsigned SHORT_CM_STS   :  1;
        unsigned RSRVD8         :  3;
    } B;
} hw_audioout_anactrl_t;
#endif


//
// constants & macros for entire HW_AUDIOOUT_ANACTRL register
//

#define HW_AUDIOOUT_ANACTRL_ADDR      (REGS_AUDIOOUT_BASE + 0x00000090)
#define HW_AUDIOOUT_ANACTRL_SET_ADDR  (REGS_AUDIOOUT_BASE + 0x00000094)
#define HW_AUDIOOUT_ANACTRL_CLR_ADDR  (REGS_AUDIOOUT_BASE + 0x00000098)
#define HW_AUDIOOUT_ANACTRL_TOG_ADDR  (REGS_AUDIOOUT_BASE + 0x0000009C)

#ifndef __LANGUAGE_ASM__
#define HW_AUDIOOUT_ANACTRL           (*(volatile hw_audioout_anactrl_t *) HW_AUDIOOUT_ANACTRL_ADDR)
#define HW_AUDIOOUT_ANACTRL_RD()      (HW_AUDIOOUT_ANACTRL.U)
#define HW_AUDIOOUT_ANACTRL_WR(v)     (HW_AUDIOOUT_ANACTRL.U = (v))
#define HW_AUDIOOUT_ANACTRL_SET(v)    ((*(volatile reg32_t *) HW_AUDIOOUT_ANACTRL_SET_ADDR) = (v))
#define HW_AUDIOOUT_ANACTRL_CLR(v)    ((*(volatile reg32_t *) HW_AUDIOOUT_ANACTRL_CLR_ADDR) = (v))
#define HW_AUDIOOUT_ANACTRL_TOG(v)    ((*(volatile reg32_t *) HW_AUDIOOUT_ANACTRL_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_AUDIOOUT_ANACTRL bitfields
//

//--- Register HW_AUDIOOUT_ANACTRL, field SHORT_CM_STS

#define BP_AUDIOOUT_ANACTRL_SHORT_CM_STS      28
#define BM_AUDIOOUT_ANACTRL_SHORT_CM_STS      0x10000000

#define BF_AUDIOOUT_ANACTRL_SHORT_CM_STS(v)   (((v) << 28) & BM_AUDIOOUT_ANACTRL_SHORT_CM_STS)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_ANACTRL_SHORT_CM_STS(v)   BF_CS1(AUDIOOUT_ANACTRL, SHORT_CM_STS, v)
#endif

//--- Register HW_AUDIOOUT_ANACTRL, field SHORT_LR_STS

#define BP_AUDIOOUT_ANACTRL_SHORT_LR_STS      24
#define BM_AUDIOOUT_ANACTRL_SHORT_LR_STS      0x01000000

#define BF_AUDIOOUT_ANACTRL_SHORT_LR_STS(v)   (((v) << 24) & BM_AUDIOOUT_ANACTRL_SHORT_LR_STS)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_ANACTRL_SHORT_LR_STS(v)   BF_CS1(AUDIOOUT_ANACTRL, SHORT_LR_STS, v)
#endif

//--- Register HW_AUDIOOUT_ANACTRL, field SHORTMODE_CM

#define BP_AUDIOOUT_ANACTRL_SHORTMODE_CM      20
#define BM_AUDIOOUT_ANACTRL_SHORTMODE_CM      0x00300000

#define BF_AUDIOOUT_ANACTRL_SHORTMODE_CM(v)   (((v) << 20) & BM_AUDIOOUT_ANACTRL_SHORTMODE_CM)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_ANACTRL_SHORTMODE_CM(v)   BF_CS1(AUDIOOUT_ANACTRL, SHORTMODE_CM, v)
#endif

//--- Register HW_AUDIOOUT_ANACTRL, field SHORTMODE_LR

#define BP_AUDIOOUT_ANACTRL_SHORTMODE_LR      17
#define BM_AUDIOOUT_ANACTRL_SHORTMODE_LR      0x00060000

#define BF_AUDIOOUT_ANACTRL_SHORTMODE_LR(v)   (((v) << 17) & BM_AUDIOOUT_ANACTRL_SHORTMODE_LR)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_ANACTRL_SHORTMODE_LR(v)   BF_CS1(AUDIOOUT_ANACTRL, SHORTMODE_LR, v)
#endif

//--- Register HW_AUDIOOUT_ANACTRL, field SHORT_LVLADJL

#define BP_AUDIOOUT_ANACTRL_SHORT_LVLADJL      12
#define BM_AUDIOOUT_ANACTRL_SHORT_LVLADJL      0x00007000

#define BF_AUDIOOUT_ANACTRL_SHORT_LVLADJL(v)   (((v) << 12) & BM_AUDIOOUT_ANACTRL_SHORT_LVLADJL)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_ANACTRL_SHORT_LVLADJL(v)   BF_CS1(AUDIOOUT_ANACTRL, SHORT_LVLADJL, v)
#endif

//--- Register HW_AUDIOOUT_ANACTRL, field SHORT_LVLADJR

#define BP_AUDIOOUT_ANACTRL_SHORT_LVLADJR      8
#define BM_AUDIOOUT_ANACTRL_SHORT_LVLADJR      0x00000700

#define BF_AUDIOOUT_ANACTRL_SHORT_LVLADJR(v)   (((v) << 8) & BM_AUDIOOUT_ANACTRL_SHORT_LVLADJR)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_ANACTRL_SHORT_LVLADJR(v)   BF_CS1(AUDIOOUT_ANACTRL, SHORT_LVLADJR, v)
#endif

//--- Register HW_AUDIOOUT_ANACTRL, field HP_HOLD_GND

#define BP_AUDIOOUT_ANACTRL_HP_HOLD_GND      5
#define BM_AUDIOOUT_ANACTRL_HP_HOLD_GND      0x00000020

#define BF_AUDIOOUT_ANACTRL_HP_HOLD_GND(v)   (((v) << 5) & BM_AUDIOOUT_ANACTRL_HP_HOLD_GND)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_ANACTRL_HP_HOLD_GND(v)   BF_CS1(AUDIOOUT_ANACTRL, HP_HOLD_GND, v)
#endif

//--- Register HW_AUDIOOUT_ANACTRL, field HP_CLASSAB

#define BP_AUDIOOUT_ANACTRL_HP_CLASSAB      4
#define BM_AUDIOOUT_ANACTRL_HP_CLASSAB      0x00000010

#define BF_AUDIOOUT_ANACTRL_HP_CLASSAB(v)   (((v) << 4) & BM_AUDIOOUT_ANACTRL_HP_CLASSAB)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_ANACTRL_HP_CLASSAB(v)   BF_CS1(AUDIOOUT_ANACTRL, HP_CLASSAB, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_AUDIOOUT_TEST - Miscellaneous Test Audio Controls Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DAC_DIS_RTZ    :  1;
        unsigned DAC_DOUBLE_I   :  1;
        unsigned DAC_CLASSA     :  1;
        unsigned ADCTODAC_LOOP  :  1;
        unsigned RSRVD1         :  8;
        unsigned VAG_DOUBLE_I   :  1;
        unsigned VAG_CLASSA     :  1;
        unsigned RSRVD2         :  6;
        unsigned HP_IALL_ADJ    :  2;
        unsigned HP_I1_ADJ      :  2;
        unsigned TM_HPCOMMON    :  1;
        unsigned TM_LOOP        :  1;
        unsigned TM_ADCIN_TOHP  :  1;
        unsigned RSRVD3         :  1;
        unsigned HP_ANTIPOP     :  3;
        unsigned RSRVD4         :  1;
    } B;
} hw_audioout_test_t;
#endif


//
// constants & macros for entire HW_AUDIOOUT_TEST register
//

#define HW_AUDIOOUT_TEST_ADDR      (REGS_AUDIOOUT_BASE + 0x000000A0)
#define HW_AUDIOOUT_TEST_SET_ADDR  (REGS_AUDIOOUT_BASE + 0x000000A4)
#define HW_AUDIOOUT_TEST_CLR_ADDR  (REGS_AUDIOOUT_BASE + 0x000000A8)
#define HW_AUDIOOUT_TEST_TOG_ADDR  (REGS_AUDIOOUT_BASE + 0x000000AC)

#ifndef __LANGUAGE_ASM__
#define HW_AUDIOOUT_TEST           (*(volatile hw_audioout_test_t *) HW_AUDIOOUT_TEST_ADDR)
#define HW_AUDIOOUT_TEST_RD()      (HW_AUDIOOUT_TEST.U)
#define HW_AUDIOOUT_TEST_WR(v)     (HW_AUDIOOUT_TEST.U = (v))
#define HW_AUDIOOUT_TEST_SET(v)    ((*(volatile reg32_t *) HW_AUDIOOUT_TEST_SET_ADDR) = (v))
#define HW_AUDIOOUT_TEST_CLR(v)    ((*(volatile reg32_t *) HW_AUDIOOUT_TEST_CLR_ADDR) = (v))
#define HW_AUDIOOUT_TEST_TOG(v)    ((*(volatile reg32_t *) HW_AUDIOOUT_TEST_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_AUDIOOUT_TEST bitfields
//

//--- Register HW_AUDIOOUT_TEST, field HP_ANTIPOP

#define BP_AUDIOOUT_TEST_HP_ANTIPOP      28
#define BM_AUDIOOUT_TEST_HP_ANTIPOP      0x70000000

#define BF_AUDIOOUT_TEST_HP_ANTIPOP(v)   (((v) << 28) & BM_AUDIOOUT_TEST_HP_ANTIPOP)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_TEST_HP_ANTIPOP(v)   BF_CS1(AUDIOOUT_TEST, HP_ANTIPOP, v)
#endif

//--- Register HW_AUDIOOUT_TEST, field TM_ADCIN_TOHP

#define BP_AUDIOOUT_TEST_TM_ADCIN_TOHP      26
#define BM_AUDIOOUT_TEST_TM_ADCIN_TOHP      0x04000000

#define BF_AUDIOOUT_TEST_TM_ADCIN_TOHP(v)   (((v) << 26) & BM_AUDIOOUT_TEST_TM_ADCIN_TOHP)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_TEST_TM_ADCIN_TOHP(v)   BF_CS1(AUDIOOUT_TEST, TM_ADCIN_TOHP, v)
#endif

//--- Register HW_AUDIOOUT_TEST, field TM_LOOP

#define BP_AUDIOOUT_TEST_TM_LOOP      25
#define BM_AUDIOOUT_TEST_TM_LOOP      0x02000000

#define BF_AUDIOOUT_TEST_TM_LOOP(v)   (((v) << 25) & BM_AUDIOOUT_TEST_TM_LOOP)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_TEST_TM_LOOP(v)   BF_CS1(AUDIOOUT_TEST, TM_LOOP, v)
#endif

//--- Register HW_AUDIOOUT_TEST, field TM_HPCOMMON

#define BP_AUDIOOUT_TEST_TM_HPCOMMON      24
#define BM_AUDIOOUT_TEST_TM_HPCOMMON      0x01000000

#define BF_AUDIOOUT_TEST_TM_HPCOMMON(v)   (((v) << 24) & BM_AUDIOOUT_TEST_TM_HPCOMMON)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_TEST_TM_HPCOMMON(v)   BF_CS1(AUDIOOUT_TEST, TM_HPCOMMON, v)
#endif

//--- Register HW_AUDIOOUT_TEST, field HP_I1_ADJ

#define BP_AUDIOOUT_TEST_HP_I1_ADJ      22
#define BM_AUDIOOUT_TEST_HP_I1_ADJ      0x00C00000

#define BF_AUDIOOUT_TEST_HP_I1_ADJ(v)   (((v) << 22) & BM_AUDIOOUT_TEST_HP_I1_ADJ)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_TEST_HP_I1_ADJ(v)   BF_CS1(AUDIOOUT_TEST, HP_I1_ADJ, v)
#endif

//--- Register HW_AUDIOOUT_TEST, field HP_IALL_ADJ

#define BP_AUDIOOUT_TEST_HP_IALL_ADJ      20
#define BM_AUDIOOUT_TEST_HP_IALL_ADJ      0x00300000

#define BF_AUDIOOUT_TEST_HP_IALL_ADJ(v)   (((v) << 20) & BM_AUDIOOUT_TEST_HP_IALL_ADJ)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_TEST_HP_IALL_ADJ(v)   BF_CS1(AUDIOOUT_TEST, HP_IALL_ADJ, v)
#endif

//--- Register HW_AUDIOOUT_TEST, field VAG_CLASSA

#define BP_AUDIOOUT_TEST_VAG_CLASSA      13
#define BM_AUDIOOUT_TEST_VAG_CLASSA      0x00002000

#define BF_AUDIOOUT_TEST_VAG_CLASSA(v)   (((v) << 13) & BM_AUDIOOUT_TEST_VAG_CLASSA)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_TEST_VAG_CLASSA(v)   BF_CS1(AUDIOOUT_TEST, VAG_CLASSA, v)
#endif

//--- Register HW_AUDIOOUT_TEST, field VAG_DOUBLE_I

#define BP_AUDIOOUT_TEST_VAG_DOUBLE_I      12
#define BM_AUDIOOUT_TEST_VAG_DOUBLE_I      0x00001000

#define BF_AUDIOOUT_TEST_VAG_DOUBLE_I(v)   (((v) << 12) & BM_AUDIOOUT_TEST_VAG_DOUBLE_I)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_TEST_VAG_DOUBLE_I(v)   BF_CS1(AUDIOOUT_TEST, VAG_DOUBLE_I, v)
#endif

//--- Register HW_AUDIOOUT_TEST, field ADCTODAC_LOOP

#define BP_AUDIOOUT_TEST_ADCTODAC_LOOP      3
#define BM_AUDIOOUT_TEST_ADCTODAC_LOOP      0x00000008

#define BF_AUDIOOUT_TEST_ADCTODAC_LOOP(v)   (((v) << 3) & BM_AUDIOOUT_TEST_ADCTODAC_LOOP)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_TEST_ADCTODAC_LOOP(v)   BF_CS1(AUDIOOUT_TEST, ADCTODAC_LOOP, v)
#endif

//--- Register HW_AUDIOOUT_TEST, field DAC_CLASSA

#define BP_AUDIOOUT_TEST_DAC_CLASSA      2
#define BM_AUDIOOUT_TEST_DAC_CLASSA      0x00000004

#define BF_AUDIOOUT_TEST_DAC_CLASSA(v)   (((v) << 2) & BM_AUDIOOUT_TEST_DAC_CLASSA)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_TEST_DAC_CLASSA(v)   BF_CS1(AUDIOOUT_TEST, DAC_CLASSA, v)
#endif

//--- Register HW_AUDIOOUT_TEST, field DAC_DOUBLE_I

#define BP_AUDIOOUT_TEST_DAC_DOUBLE_I      1
#define BM_AUDIOOUT_TEST_DAC_DOUBLE_I      0x00000002

#define BF_AUDIOOUT_TEST_DAC_DOUBLE_I(v)   (((v) << 1) & BM_AUDIOOUT_TEST_DAC_DOUBLE_I)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_TEST_DAC_DOUBLE_I(v)   BF_CS1(AUDIOOUT_TEST, DAC_DOUBLE_I, v)
#endif

//--- Register HW_AUDIOOUT_TEST, field DAC_DIS_RTZ

#define BP_AUDIOOUT_TEST_DAC_DIS_RTZ      0
#define BM_AUDIOOUT_TEST_DAC_DIS_RTZ      0x00000001

#define BF_AUDIOOUT_TEST_DAC_DIS_RTZ(v)   (((v) << 0) & BM_AUDIOOUT_TEST_DAC_DIS_RTZ)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_TEST_DAC_DIS_RTZ(v)   BF_CS1(AUDIOOUT_TEST, DAC_DIS_RTZ, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_AUDIOOUT_BISTCTRL - BIST Control and Status Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned START  :  1;
        unsigned DONE   :  1;
        unsigned PASS   :  1;
        unsigned FAIL   :  1;
        unsigned RSVD0  : 28;
    } B;
} hw_audioout_bistctrl_t;
#endif


//
// constants & macros for entire HW_AUDIOOUT_BISTCTRL register
//

#define HW_AUDIOOUT_BISTCTRL_ADDR      (REGS_AUDIOOUT_BASE + 0x000000B0)
#define HW_AUDIOOUT_BISTCTRL_SET_ADDR  (REGS_AUDIOOUT_BASE + 0x000000B4)
#define HW_AUDIOOUT_BISTCTRL_CLR_ADDR  (REGS_AUDIOOUT_BASE + 0x000000B8)
#define HW_AUDIOOUT_BISTCTRL_TOG_ADDR  (REGS_AUDIOOUT_BASE + 0x000000BC)

#ifndef __LANGUAGE_ASM__
#define HW_AUDIOOUT_BISTCTRL           (*(volatile hw_audioout_bistctrl_t *) HW_AUDIOOUT_BISTCTRL_ADDR)
#define HW_AUDIOOUT_BISTCTRL_RD()      (HW_AUDIOOUT_BISTCTRL.U)
#define HW_AUDIOOUT_BISTCTRL_WR(v)     (HW_AUDIOOUT_BISTCTRL.U = (v))
#define HW_AUDIOOUT_BISTCTRL_SET(v)    ((*(volatile reg32_t *) HW_AUDIOOUT_BISTCTRL_SET_ADDR) = (v))
#define HW_AUDIOOUT_BISTCTRL_CLR(v)    ((*(volatile reg32_t *) HW_AUDIOOUT_BISTCTRL_CLR_ADDR) = (v))
#define HW_AUDIOOUT_BISTCTRL_TOG(v)    ((*(volatile reg32_t *) HW_AUDIOOUT_BISTCTRL_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_AUDIOOUT_BISTCTRL bitfields
//

//--- Register HW_AUDIOOUT_BISTCTRL, field FAIL

#define BP_AUDIOOUT_BISTCTRL_FAIL      3
#define BM_AUDIOOUT_BISTCTRL_FAIL      0x00000008

#define BF_AUDIOOUT_BISTCTRL_FAIL(v)   (((v) << 3) & BM_AUDIOOUT_BISTCTRL_FAIL)

//--- Register HW_AUDIOOUT_BISTCTRL, field PASS

#define BP_AUDIOOUT_BISTCTRL_PASS      2
#define BM_AUDIOOUT_BISTCTRL_PASS      0x00000004

#define BF_AUDIOOUT_BISTCTRL_PASS(v)   (((v) << 2) & BM_AUDIOOUT_BISTCTRL_PASS)

//--- Register HW_AUDIOOUT_BISTCTRL, field DONE

#define BP_AUDIOOUT_BISTCTRL_DONE      1
#define BM_AUDIOOUT_BISTCTRL_DONE      0x00000002

#define BF_AUDIOOUT_BISTCTRL_DONE(v)   (((v) << 1) & BM_AUDIOOUT_BISTCTRL_DONE)

//--- Register HW_AUDIOOUT_BISTCTRL, field START

#define BP_AUDIOOUT_BISTCTRL_START      0
#define BM_AUDIOOUT_BISTCTRL_START      0x00000001

#define BF_AUDIOOUT_BISTCTRL_START(v)   (((v) << 0) & BM_AUDIOOUT_BISTCTRL_START)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_BISTCTRL_START(v)   BF_CS1(AUDIOOUT_BISTCTRL, START, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_AUDIOOUT_BISTSTAT0 - Hardware BIST Status 0 Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DATA   : 24;
        reg8_t   RSVD0;
    } B;
} hw_audioout_biststat0_t;
#endif


//
// constants & macros for entire HW_AUDIOOUT_BISTSTAT0 register
//

#define HW_AUDIOOUT_BISTSTAT0_ADDR      (REGS_AUDIOOUT_BASE + 0x000000C0)

#ifndef __LANGUAGE_ASM__
#define HW_AUDIOOUT_BISTSTAT0           (*(volatile hw_audioout_biststat0_t *) HW_AUDIOOUT_BISTSTAT0_ADDR)
#define HW_AUDIOOUT_BISTSTAT0_RD()      (HW_AUDIOOUT_BISTSTAT0.U)
#endif


//
// constants & macros for individual HW_AUDIOOUT_BISTSTAT0 bitfields
//

//--- Register HW_AUDIOOUT_BISTSTAT0, field DATA

#define BP_AUDIOOUT_BISTSTAT0_DATA      0
#define BM_AUDIOOUT_BISTSTAT0_DATA      0x00FFFFFF

#define BF_AUDIOOUT_BISTSTAT0_DATA(v)   (((v) << 0) & BM_AUDIOOUT_BISTSTAT0_DATA)


////////////////////////////////////////////////////////////////////////////////
//// HW_AUDIOOUT_BISTSTAT1 - Hardware AUDIOUT BIST Status 1 Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg8_t   ADDR;
        unsigned RSVD0  : 16;
        unsigned STATE  :  5;
        unsigned RSVD1  :  3;
    } B;
} hw_audioout_biststat1_t;
#endif


//
// constants & macros for entire HW_AUDIOOUT_BISTSTAT1 register
//

#define HW_AUDIOOUT_BISTSTAT1_ADDR      (REGS_AUDIOOUT_BASE + 0x000000D0)

#ifndef __LANGUAGE_ASM__
#define HW_AUDIOOUT_BISTSTAT1           (*(volatile hw_audioout_biststat1_t *) HW_AUDIOOUT_BISTSTAT1_ADDR)
#define HW_AUDIOOUT_BISTSTAT1_RD()      (HW_AUDIOOUT_BISTSTAT1.U)
#endif


//
// constants & macros for individual HW_AUDIOOUT_BISTSTAT1 bitfields
//

//--- Register HW_AUDIOOUT_BISTSTAT1, field STATE

#define BP_AUDIOOUT_BISTSTAT1_STATE      24
#define BM_AUDIOOUT_BISTSTAT1_STATE      0x1F000000

#define BF_AUDIOOUT_BISTSTAT1_STATE(v)   (((v) << 24) & BM_AUDIOOUT_BISTSTAT1_STATE)

//--- Register HW_AUDIOOUT_BISTSTAT1, field ADDR

#define BP_AUDIOOUT_BISTSTAT1_ADDR      0
#define BM_AUDIOOUT_BISTSTAT1_ADDR      0x000000FF

#define BF_AUDIOOUT_BISTSTAT1_ADDR(v)   (((v) << 0) & BM_AUDIOOUT_BISTSTAT1_ADDR)


////////////////////////////////////////////////////////////////////////////////
//// HW_AUDIOOUT_ANACLKCTRL - Analog Clock Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DACDIV         :  3;
        unsigned RSRVD2         :  1;
        unsigned INVERT_DACCLK  :  1;
        unsigned RSRVD3         : 26;
        unsigned CLKGATE        :  1;
    } B;
} hw_audioout_anaclkctrl_t;
#endif


//
// constants & macros for entire HW_AUDIOOUT_ANACLKCTRL register
//

#define HW_AUDIOOUT_ANACLKCTRL_ADDR      (REGS_AUDIOOUT_BASE + 0x000000E0)
#define HW_AUDIOOUT_ANACLKCTRL_SET_ADDR  (REGS_AUDIOOUT_BASE + 0x000000E4)
#define HW_AUDIOOUT_ANACLKCTRL_CLR_ADDR  (REGS_AUDIOOUT_BASE + 0x000000E8)
#define HW_AUDIOOUT_ANACLKCTRL_TOG_ADDR  (REGS_AUDIOOUT_BASE + 0x000000EC)

#ifndef __LANGUAGE_ASM__
#define HW_AUDIOOUT_ANACLKCTRL           (*(volatile hw_audioout_anaclkctrl_t *) HW_AUDIOOUT_ANACLKCTRL_ADDR)
#define HW_AUDIOOUT_ANACLKCTRL_RD()      (HW_AUDIOOUT_ANACLKCTRL.U)
#define HW_AUDIOOUT_ANACLKCTRL_WR(v)     (HW_AUDIOOUT_ANACLKCTRL.U = (v))
#define HW_AUDIOOUT_ANACLKCTRL_SET(v)    ((*(volatile reg32_t *) HW_AUDIOOUT_ANACLKCTRL_SET_ADDR) = (v))
#define HW_AUDIOOUT_ANACLKCTRL_CLR(v)    ((*(volatile reg32_t *) HW_AUDIOOUT_ANACLKCTRL_CLR_ADDR) = (v))
#define HW_AUDIOOUT_ANACLKCTRL_TOG(v)    ((*(volatile reg32_t *) HW_AUDIOOUT_ANACLKCTRL_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_AUDIOOUT_ANACLKCTRL bitfields
//

//--- Register HW_AUDIOOUT_ANACLKCTRL, field CLKGATE

#define BP_AUDIOOUT_ANACLKCTRL_CLKGATE      31
#define BM_AUDIOOUT_ANACLKCTRL_CLKGATE      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_AUDIOOUT_ANACLKCTRL_CLKGATE(v)   ((((reg32_t) v) << 31) & BM_AUDIOOUT_ANACLKCTRL_CLKGATE)
#else
#define BF_AUDIOOUT_ANACLKCTRL_CLKGATE(v)   (((v) << 31) & BM_AUDIOOUT_ANACLKCTRL_CLKGATE)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_ANACLKCTRL_CLKGATE(v)   BF_CS1(AUDIOOUT_ANACLKCTRL, CLKGATE, v)
#endif

//--- Register HW_AUDIOOUT_ANACLKCTRL, field INVERT_DACCLK

#define BP_AUDIOOUT_ANACLKCTRL_INVERT_DACCLK      4
#define BM_AUDIOOUT_ANACLKCTRL_INVERT_DACCLK      0x00000010

#define BF_AUDIOOUT_ANACLKCTRL_INVERT_DACCLK(v)   (((v) << 4) & BM_AUDIOOUT_ANACLKCTRL_INVERT_DACCLK)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_ANACLKCTRL_INVERT_DACCLK(v)   BF_CS1(AUDIOOUT_ANACLKCTRL, INVERT_DACCLK, v)
#endif

//--- Register HW_AUDIOOUT_ANACLKCTRL, field DACDIV

#define BP_AUDIOOUT_ANACLKCTRL_DACDIV      0
#define BM_AUDIOOUT_ANACLKCTRL_DACDIV      0x00000007

#define BF_AUDIOOUT_ANACLKCTRL_DACDIV(v)   (((v) << 0) & BM_AUDIOOUT_ANACLKCTRL_DACDIV)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_ANACLKCTRL_DACDIV(v)   BF_CS1(AUDIOOUT_ANACLKCTRL, DACDIV, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_AUDIOOUT_DATA - AUDIOOUT Write Data Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg16_t  LOW;
        reg16_t  HIGH;
    } B;
} hw_audioout_data_t;
#endif


//
// constants & macros for entire HW_AUDIOOUT_DATA register
//

#define HW_AUDIOOUT_DATA_ADDR      (REGS_AUDIOOUT_BASE + 0x000000F0)
#define HW_AUDIOOUT_DATA_SET_ADDR  (REGS_AUDIOOUT_BASE + 0x000000F4)
#define HW_AUDIOOUT_DATA_CLR_ADDR  (REGS_AUDIOOUT_BASE + 0x000000F8)
#define HW_AUDIOOUT_DATA_TOG_ADDR  (REGS_AUDIOOUT_BASE + 0x000000FC)

#ifndef __LANGUAGE_ASM__
#define HW_AUDIOOUT_DATA           (*(volatile hw_audioout_data_t *) HW_AUDIOOUT_DATA_ADDR)
#define HW_AUDIOOUT_DATA_RD()      (HW_AUDIOOUT_DATA.U)
#define HW_AUDIOOUT_DATA_WR(v)     (HW_AUDIOOUT_DATA.U = (v))
#define HW_AUDIOOUT_DATA_SET(v)    ((*(volatile reg32_t *) HW_AUDIOOUT_DATA_SET_ADDR) = (v))
#define HW_AUDIOOUT_DATA_CLR(v)    ((*(volatile reg32_t *) HW_AUDIOOUT_DATA_CLR_ADDR) = (v))
#define HW_AUDIOOUT_DATA_TOG(v)    ((*(volatile reg32_t *) HW_AUDIOOUT_DATA_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_AUDIOOUT_DATA bitfields
//

//--- Register HW_AUDIOOUT_DATA, field HIGH

#define BP_AUDIOOUT_DATA_HIGH      16
#define BM_AUDIOOUT_DATA_HIGH      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_AUDIOOUT_DATA_HIGH(v)   ((((reg32_t) v) << 16) & BM_AUDIOOUT_DATA_HIGH)
#else
#define BF_AUDIOOUT_DATA_HIGH(v)   (((v) << 16) & BM_AUDIOOUT_DATA_HIGH)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_DATA_HIGH(v)   (HW_AUDIOOUT_DATA.B.HIGH = (v))
#endif

//--- Register HW_AUDIOOUT_DATA, field LOW

#define BP_AUDIOOUT_DATA_LOW      0
#define BM_AUDIOOUT_DATA_LOW      0x0000FFFF

#define BF_AUDIOOUT_DATA_LOW(v)   (((v) << 0) & BM_AUDIOOUT_DATA_LOW)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_DATA_LOW(v)   (HW_AUDIOOUT_DATA.B.LOW = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_AUDIOOUT_SPEAKERCTRL - AUDIOOUT Speaker Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSRVD0     : 12;
        unsigned NEGDRIVER  :  2;
        unsigned POSDRIVER  :  2;
        unsigned RSRVD1     :  4;
        unsigned IALL_ADJ   :  2;
        unsigned I1_ADJ     :  2;
        unsigned MUTE       :  1;
        unsigned RSRVD2     :  7;
    } B;
} hw_audioout_speakerctrl_t;
#endif


//
// constants & macros for entire HW_AUDIOOUT_SPEAKERCTRL register
//

#define HW_AUDIOOUT_SPEAKERCTRL_ADDR      (REGS_AUDIOOUT_BASE + 0x00000100)
#define HW_AUDIOOUT_SPEAKERCTRL_SET_ADDR  (REGS_AUDIOOUT_BASE + 0x00000104)
#define HW_AUDIOOUT_SPEAKERCTRL_CLR_ADDR  (REGS_AUDIOOUT_BASE + 0x00000108)
#define HW_AUDIOOUT_SPEAKERCTRL_TOG_ADDR  (REGS_AUDIOOUT_BASE + 0x0000010C)

#ifndef __LANGUAGE_ASM__
#define HW_AUDIOOUT_SPEAKERCTRL           (*(volatile hw_audioout_speakerctrl_t *) HW_AUDIOOUT_SPEAKERCTRL_ADDR)
#define HW_AUDIOOUT_SPEAKERCTRL_RD()      (HW_AUDIOOUT_SPEAKERCTRL.U)
#define HW_AUDIOOUT_SPEAKERCTRL_WR(v)     (HW_AUDIOOUT_SPEAKERCTRL.U = (v))
#define HW_AUDIOOUT_SPEAKERCTRL_SET(v)    ((*(volatile reg32_t *) HW_AUDIOOUT_SPEAKERCTRL_SET_ADDR) = (v))
#define HW_AUDIOOUT_SPEAKERCTRL_CLR(v)    ((*(volatile reg32_t *) HW_AUDIOOUT_SPEAKERCTRL_CLR_ADDR) = (v))
#define HW_AUDIOOUT_SPEAKERCTRL_TOG(v)    ((*(volatile reg32_t *) HW_AUDIOOUT_SPEAKERCTRL_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_AUDIOOUT_SPEAKERCTRL bitfields
//

//--- Register HW_AUDIOOUT_SPEAKERCTRL, field MUTE

#define BP_AUDIOOUT_SPEAKERCTRL_MUTE      24
#define BM_AUDIOOUT_SPEAKERCTRL_MUTE      0x01000000

#define BF_AUDIOOUT_SPEAKERCTRL_MUTE(v)   (((v) << 24) & BM_AUDIOOUT_SPEAKERCTRL_MUTE)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_SPEAKERCTRL_MUTE(v)   BF_CS1(AUDIOOUT_SPEAKERCTRL, MUTE, v)
#endif

//--- Register HW_AUDIOOUT_SPEAKERCTRL, field I1_ADJ

#define BP_AUDIOOUT_SPEAKERCTRL_I1_ADJ      22
#define BM_AUDIOOUT_SPEAKERCTRL_I1_ADJ      0x00C00000

#define BF_AUDIOOUT_SPEAKERCTRL_I1_ADJ(v)   (((v) << 22) & BM_AUDIOOUT_SPEAKERCTRL_I1_ADJ)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_SPEAKERCTRL_I1_ADJ(v)   BF_CS1(AUDIOOUT_SPEAKERCTRL, I1_ADJ, v)
#endif

//--- Register HW_AUDIOOUT_SPEAKERCTRL, field IALL_ADJ

#define BP_AUDIOOUT_SPEAKERCTRL_IALL_ADJ      20
#define BM_AUDIOOUT_SPEAKERCTRL_IALL_ADJ      0x00300000

#define BF_AUDIOOUT_SPEAKERCTRL_IALL_ADJ(v)   (((v) << 20) & BM_AUDIOOUT_SPEAKERCTRL_IALL_ADJ)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_SPEAKERCTRL_IALL_ADJ(v)   BF_CS1(AUDIOOUT_SPEAKERCTRL, IALL_ADJ, v)
#endif

//--- Register HW_AUDIOOUT_SPEAKERCTRL, field POSDRIVER

#define BP_AUDIOOUT_SPEAKERCTRL_POSDRIVER      14
#define BM_AUDIOOUT_SPEAKERCTRL_POSDRIVER      0x0000C000

#define BF_AUDIOOUT_SPEAKERCTRL_POSDRIVER(v)   (((v) << 14) & BM_AUDIOOUT_SPEAKERCTRL_POSDRIVER)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_SPEAKERCTRL_POSDRIVER(v)   BF_CS1(AUDIOOUT_SPEAKERCTRL, POSDRIVER, v)
#endif

//--- Register HW_AUDIOOUT_SPEAKERCTRL, field NEGDRIVER

#define BP_AUDIOOUT_SPEAKERCTRL_NEGDRIVER      12
#define BM_AUDIOOUT_SPEAKERCTRL_NEGDRIVER      0x00003000

#define BF_AUDIOOUT_SPEAKERCTRL_NEGDRIVER(v)   (((v) << 12) & BM_AUDIOOUT_SPEAKERCTRL_NEGDRIVER)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOOUT_SPEAKERCTRL_NEGDRIVER(v)   BF_CS1(AUDIOOUT_SPEAKERCTRL, NEGDRIVER, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_AUDIOOUT_VERSION - AUDIOOUT Version Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg16_t  STEP;
        reg8_t   MINOR;
        reg8_t   MAJOR;
    } B;
} hw_audioout_version_t;
#endif


//
// constants & macros for entire HW_AUDIOOUT_VERSION register
//

#define HW_AUDIOOUT_VERSION_ADDR      (REGS_AUDIOOUT_BASE + 0x00000200)

#ifndef __LANGUAGE_ASM__
#define HW_AUDIOOUT_VERSION           (*(volatile hw_audioout_version_t *) HW_AUDIOOUT_VERSION_ADDR)
#define HW_AUDIOOUT_VERSION_RD()      (HW_AUDIOOUT_VERSION.U)
#endif


//
// constants & macros for individual HW_AUDIOOUT_VERSION bitfields
//

//--- Register HW_AUDIOOUT_VERSION, field MAJOR

#define BP_AUDIOOUT_VERSION_MAJOR      24
#define BM_AUDIOOUT_VERSION_MAJOR      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_AUDIOOUT_VERSION_MAJOR(v)   ((((reg32_t) v) << 24) & BM_AUDIOOUT_VERSION_MAJOR)
#else
#define BF_AUDIOOUT_VERSION_MAJOR(v)   (((v) << 24) & BM_AUDIOOUT_VERSION_MAJOR)
#endif

//--- Register HW_AUDIOOUT_VERSION, field MINOR

#define BP_AUDIOOUT_VERSION_MINOR      16
#define BM_AUDIOOUT_VERSION_MINOR      0x00FF0000

#define BF_AUDIOOUT_VERSION_MINOR(v)   (((v) << 16) & BM_AUDIOOUT_VERSION_MINOR)

//--- Register HW_AUDIOOUT_VERSION, field STEP

#define BP_AUDIOOUT_VERSION_STEP      0
#define BM_AUDIOOUT_VERSION_STEP      0x0000FFFF

#define BF_AUDIOOUT_VERSION_STEP(v)   (((v) << 0) & BM_AUDIOOUT_VERSION_STEP)


#endif // _REGSAUDIOOUT_H

////////////////////////////////////////////////////////////////////////////////
