/*
 * Copyright 2009 Freescale Semiconductor, Inc. All Rights Reserved.
 */

/*
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */
////////////////////////////////////////////////////////////////////////////////
//
// WARNING!  THIS FILE IS AUTOMATICALLY GENERATED FROM XML.
//                DO NOT MODIFY THIS FILE DIRECTLY.
//
////////////////////////////////////////////////////////////////////////////////
//
// The following naming conventions are followed in this file.
//      XX_<module>_<regname>_<field>
//
// XX specifies the define / macro class
//      HW pertains to a register
//      BM indicates a Bit Mask
//      BF indicates a Bit Field macro
//
// <module> is the hardware module name which can be any of the following...
//      USB20 (Note when there is more than one copy of a given module, the
//      module name includes a number starting from 0 for the first instance
//      of that module)
//
// <regname> is the specific register within that module
//
// <field> is the specific bitfield within that <module>_<register>
//
// We also define the following...
//      hw_<module>_<regname>_t is typedef of anonymous union
//
////////////////////////////////////////////////////////////////////////////////

#ifndef _REGSDIGCTL_H
#define _REGSDIGCTL_H  1

#include "regs.h"

#ifndef REGS_DIGCTL_BASE
#define REGS_DIGCTL_BASE (REGS_BASE + 0x0001C000)
#endif

////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_CTRL - DIGCTL Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned LATCH_ENTROPY        :  1;
        unsigned JTAG_SHIELD          :  1;
        unsigned USB_CLKGATE          :  1;
        unsigned DEBUG_DISABLE        :  1;
        unsigned TRAP_ENABLE          :  1;
        unsigned TRAP_IN_RANGE        :  1;
        unsigned USE_SERIAL_JTAG      :  1;
        unsigned SY_CLKGATE           :  1;
        unsigned SY_SFTRST            :  1;
        unsigned SY_ENDIAN            :  1;
        unsigned RSVD1                :  1;
        unsigned SAIF_ALT_BITCLK_SEL  :  1;
        unsigned SAIF_CLKMST_SEL      :  1;
        unsigned SAIF_CLKMUX_SEL      :  2;
        unsigned SAIF_LOOPBACK        :  1;
        unsigned UART_LOOPBACK        :  1;
        unsigned ARM_BIST_START       :  1;
        unsigned DIGITAL_TESTMODE     :  1;
        unsigned ANALOG_TESTMODE      :  1;
        unsigned USB_TESTMODE         :  1;
        unsigned ARM_BIST_CLKEN       :  1;
        unsigned DCP_BIST_START       :  1;
        unsigned DCP_BIST_CLKEN       :  1;
        unsigned LCD_BIST_START       :  1;
        unsigned LCD_BIST_CLKEN       :  1;
        unsigned CACHE_BIST_TMODE     :  1;
        unsigned RSVD2                :  2;
        unsigned TRAP_IRQ             :  1;
        unsigned XTAL24M_GATE         :  1;
        unsigned RSVD3                :  1;
    } B;
} hw_digctl_ctrl_t;
#endif


//
// constants & macros for entire HW_DIGCTL_CTRL register
//

#define HW_DIGCTL_CTRL_ADDR      (REGS_DIGCTL_BASE + 0x00000000)
#define HW_DIGCTL_CTRL_SET_ADDR  (REGS_DIGCTL_BASE + 0x00000004)
#define HW_DIGCTL_CTRL_CLR_ADDR  (REGS_DIGCTL_BASE + 0x00000008)
#define HW_DIGCTL_CTRL_TOG_ADDR  (REGS_DIGCTL_BASE + 0x0000000C)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_CTRL           (*(volatile hw_digctl_ctrl_t *) HW_DIGCTL_CTRL_ADDR)
#define HW_DIGCTL_CTRL_RD()      (HW_DIGCTL_CTRL.U)
#define HW_DIGCTL_CTRL_WR(v)     (HW_DIGCTL_CTRL.U = (v))
#define HW_DIGCTL_CTRL_SET(v)    ((*(volatile reg32_t *) HW_DIGCTL_CTRL_SET_ADDR) = (v))
#define HW_DIGCTL_CTRL_CLR(v)    ((*(volatile reg32_t *) HW_DIGCTL_CTRL_CLR_ADDR) = (v))
#define HW_DIGCTL_CTRL_TOG(v)    ((*(volatile reg32_t *) HW_DIGCTL_CTRL_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_DIGCTL_CTRL bitfields
//

//--- Register HW_DIGCTL_CTRL, field XTAL24M_GATE

#define BP_DIGCTL_CTRL_XTAL24M_GATE      30
#define BM_DIGCTL_CTRL_XTAL24M_GATE      0x40000000

#define BF_DIGCTL_CTRL_XTAL24M_GATE(v)   (((v) << 30) & BM_DIGCTL_CTRL_XTAL24M_GATE)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_CTRL_XTAL24M_GATE(v)   BF_CS1(DIGCTL_CTRL, XTAL24M_GATE, v)
#endif

//--- Register HW_DIGCTL_CTRL, field TRAP_IRQ

#define BP_DIGCTL_CTRL_TRAP_IRQ      29
#define BM_DIGCTL_CTRL_TRAP_IRQ      0x20000000

#define BF_DIGCTL_CTRL_TRAP_IRQ(v)   (((v) << 29) & BM_DIGCTL_CTRL_TRAP_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_CTRL_TRAP_IRQ(v)   BF_CS1(DIGCTL_CTRL, TRAP_IRQ, v)
#endif

//--- Register HW_DIGCTL_CTRL, field CACHE_BIST_TMODE

#define BP_DIGCTL_CTRL_CACHE_BIST_TMODE      26
#define BM_DIGCTL_CTRL_CACHE_BIST_TMODE      0x04000000

#define BF_DIGCTL_CTRL_CACHE_BIST_TMODE(v)   (((v) << 26) & BM_DIGCTL_CTRL_CACHE_BIST_TMODE)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_CTRL_CACHE_BIST_TMODE(v)   BF_CS1(DIGCTL_CTRL, CACHE_BIST_TMODE, v)
#endif

//--- Register HW_DIGCTL_CTRL, field LCD_BIST_CLKEN

#define BP_DIGCTL_CTRL_LCD_BIST_CLKEN      25
#define BM_DIGCTL_CTRL_LCD_BIST_CLKEN      0x02000000

#define BF_DIGCTL_CTRL_LCD_BIST_CLKEN(v)   (((v) << 25) & BM_DIGCTL_CTRL_LCD_BIST_CLKEN)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_CTRL_LCD_BIST_CLKEN(v)   BF_CS1(DIGCTL_CTRL, LCD_BIST_CLKEN, v)
#endif

//--- Register HW_DIGCTL_CTRL, field LCD_BIST_START

#define BP_DIGCTL_CTRL_LCD_BIST_START      24
#define BM_DIGCTL_CTRL_LCD_BIST_START      0x01000000

#define BF_DIGCTL_CTRL_LCD_BIST_START(v)   (((v) << 24) & BM_DIGCTL_CTRL_LCD_BIST_START)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_CTRL_LCD_BIST_START(v)   BF_CS1(DIGCTL_CTRL, LCD_BIST_START, v)
#endif

//--- Register HW_DIGCTL_CTRL, field DCP_BIST_CLKEN

#define BP_DIGCTL_CTRL_DCP_BIST_CLKEN      23
#define BM_DIGCTL_CTRL_DCP_BIST_CLKEN      0x00800000

#define BF_DIGCTL_CTRL_DCP_BIST_CLKEN(v)   (((v) << 23) & BM_DIGCTL_CTRL_DCP_BIST_CLKEN)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_CTRL_DCP_BIST_CLKEN(v)   BF_CS1(DIGCTL_CTRL, DCP_BIST_CLKEN, v)
#endif

//--- Register HW_DIGCTL_CTRL, field DCP_BIST_START

#define BP_DIGCTL_CTRL_DCP_BIST_START      22
#define BM_DIGCTL_CTRL_DCP_BIST_START      0x00400000

#define BF_DIGCTL_CTRL_DCP_BIST_START(v)   (((v) << 22) & BM_DIGCTL_CTRL_DCP_BIST_START)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_CTRL_DCP_BIST_START(v)   BF_CS1(DIGCTL_CTRL, DCP_BIST_START, v)
#endif

//--- Register HW_DIGCTL_CTRL, field ARM_BIST_CLKEN

#define BP_DIGCTL_CTRL_ARM_BIST_CLKEN      21
#define BM_DIGCTL_CTRL_ARM_BIST_CLKEN      0x00200000

#define BF_DIGCTL_CTRL_ARM_BIST_CLKEN(v)   (((v) << 21) & BM_DIGCTL_CTRL_ARM_BIST_CLKEN)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_CTRL_ARM_BIST_CLKEN(v)   BF_CS1(DIGCTL_CTRL, ARM_BIST_CLKEN, v)
#endif

//--- Register HW_DIGCTL_CTRL, field USB_TESTMODE

#define BP_DIGCTL_CTRL_USB_TESTMODE      20
#define BM_DIGCTL_CTRL_USB_TESTMODE      0x00100000

#define BF_DIGCTL_CTRL_USB_TESTMODE(v)   (((v) << 20) & BM_DIGCTL_CTRL_USB_TESTMODE)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_CTRL_USB_TESTMODE(v)   BF_CS1(DIGCTL_CTRL, USB_TESTMODE, v)
#endif

//--- Register HW_DIGCTL_CTRL, field ANALOG_TESTMODE

#define BP_DIGCTL_CTRL_ANALOG_TESTMODE      19
#define BM_DIGCTL_CTRL_ANALOG_TESTMODE      0x00080000

#define BF_DIGCTL_CTRL_ANALOG_TESTMODE(v)   (((v) << 19) & BM_DIGCTL_CTRL_ANALOG_TESTMODE)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_CTRL_ANALOG_TESTMODE(v)   BF_CS1(DIGCTL_CTRL, ANALOG_TESTMODE, v)
#endif

//--- Register HW_DIGCTL_CTRL, field DIGITAL_TESTMODE

#define BP_DIGCTL_CTRL_DIGITAL_TESTMODE      18
#define BM_DIGCTL_CTRL_DIGITAL_TESTMODE      0x00040000

#define BF_DIGCTL_CTRL_DIGITAL_TESTMODE(v)   (((v) << 18) & BM_DIGCTL_CTRL_DIGITAL_TESTMODE)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_CTRL_DIGITAL_TESTMODE(v)   BF_CS1(DIGCTL_CTRL, DIGITAL_TESTMODE, v)
#endif

//--- Register HW_DIGCTL_CTRL, field ARM_BIST_START

#define BP_DIGCTL_CTRL_ARM_BIST_START      17
#define BM_DIGCTL_CTRL_ARM_BIST_START      0x00020000

#define BF_DIGCTL_CTRL_ARM_BIST_START(v)   (((v) << 17) & BM_DIGCTL_CTRL_ARM_BIST_START)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_CTRL_ARM_BIST_START(v)   BF_CS1(DIGCTL_CTRL, ARM_BIST_START, v)
#endif

//--- Register HW_DIGCTL_CTRL, field UART_LOOPBACK

#define BP_DIGCTL_CTRL_UART_LOOPBACK      16
#define BM_DIGCTL_CTRL_UART_LOOPBACK      0x00010000

#define BF_DIGCTL_CTRL_UART_LOOPBACK(v)   (((v) << 16) & BM_DIGCTL_CTRL_UART_LOOPBACK)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_CTRL_UART_LOOPBACK(v)   BF_CS1(DIGCTL_CTRL, UART_LOOPBACK, v)
#endif

#define BV_DIGCTL_CTRL_UART_LOOPBACK__NORMAL  0x0
#define BV_DIGCTL_CTRL_UART_LOOPBACK__LOOPIT  0x1

//--- Register HW_DIGCTL_CTRL, field SAIF_LOOPBACK

#define BP_DIGCTL_CTRL_SAIF_LOOPBACK      15
#define BM_DIGCTL_CTRL_SAIF_LOOPBACK      0x00008000

#define BF_DIGCTL_CTRL_SAIF_LOOPBACK(v)   (((v) << 15) & BM_DIGCTL_CTRL_SAIF_LOOPBACK)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_CTRL_SAIF_LOOPBACK(v)   BF_CS1(DIGCTL_CTRL, SAIF_LOOPBACK, v)
#endif

#define BV_DIGCTL_CTRL_SAIF_LOOPBACK__NORMAL  0x0
#define BV_DIGCTL_CTRL_SAIF_LOOPBACK__LOOPIT  0x1

//--- Register HW_DIGCTL_CTRL, field SAIF_CLKMUX_SEL

#define BP_DIGCTL_CTRL_SAIF_CLKMUX_SEL      13
#define BM_DIGCTL_CTRL_SAIF_CLKMUX_SEL      0x00006000

#define BF_DIGCTL_CTRL_SAIF_CLKMUX_SEL(v)   (((v) << 13) & BM_DIGCTL_CTRL_SAIF_CLKMUX_SEL)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_CTRL_SAIF_CLKMUX_SEL(v)   BF_CS1(DIGCTL_CTRL, SAIF_CLKMUX_SEL, v)
#endif

#define BV_DIGCTL_CTRL_SAIF_CLKMUX_SEL__MBL_CLK_OUT          0x0
#define BV_DIGCTL_CTRL_SAIF_CLKMUX_SEL__BL_CLK_OUT           0x1
#define BV_DIGCTL_CTRL_SAIF_CLKMUX_SEL__M_CLK_OUT_BL_CLK_IN  0x2
#define BV_DIGCTL_CTRL_SAIF_CLKMUX_SEL__BL_CLK_IN            0x3

//--- Register HW_DIGCTL_CTRL, field SAIF_CLKMST_SEL

#define BP_DIGCTL_CTRL_SAIF_CLKMST_SEL      12
#define BM_DIGCTL_CTRL_SAIF_CLKMST_SEL      0x00001000

#define BF_DIGCTL_CTRL_SAIF_CLKMST_SEL(v)   (((v) << 12) & BM_DIGCTL_CTRL_SAIF_CLKMST_SEL)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_CTRL_SAIF_CLKMST_SEL(v)   BF_CS1(DIGCTL_CTRL, SAIF_CLKMST_SEL, v)
#endif

#define BV_DIGCTL_CTRL_SAIF_CLKMST_SEL__SAIF1_MST  0x0
#define BV_DIGCTL_CTRL_SAIF_CLKMST_SEL__SAIF2_MST  0x1

//--- Register HW_DIGCTL_CTRL, field SAIF_ALT_BITCLK_SEL

#define BP_DIGCTL_CTRL_SAIF_ALT_BITCLK_SEL      11
#define BM_DIGCTL_CTRL_SAIF_ALT_BITCLK_SEL      0x00000800

#define BF_DIGCTL_CTRL_SAIF_ALT_BITCLK_SEL(v)   (((v) << 11) & BM_DIGCTL_CTRL_SAIF_ALT_BITCLK_SEL)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_CTRL_SAIF_ALT_BITCLK_SEL(v)   BF_CS1(DIGCTL_CTRL, SAIF_ALT_BITCLK_SEL, v)
#endif

//--- Register HW_DIGCTL_CTRL, field SY_ENDIAN

#define BP_DIGCTL_CTRL_SY_ENDIAN      9
#define BM_DIGCTL_CTRL_SY_ENDIAN      0x00000200

#define BF_DIGCTL_CTRL_SY_ENDIAN(v)   (((v) << 9) & BM_DIGCTL_CTRL_SY_ENDIAN)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_CTRL_SY_ENDIAN(v)   BF_CS1(DIGCTL_CTRL, SY_ENDIAN, v)
#endif

//--- Register HW_DIGCTL_CTRL, field SY_SFTRST

#define BP_DIGCTL_CTRL_SY_SFTRST      8
#define BM_DIGCTL_CTRL_SY_SFTRST      0x00000100

#define BF_DIGCTL_CTRL_SY_SFTRST(v)   (((v) << 8) & BM_DIGCTL_CTRL_SY_SFTRST)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_CTRL_SY_SFTRST(v)   BF_CS1(DIGCTL_CTRL, SY_SFTRST, v)
#endif

//--- Register HW_DIGCTL_CTRL, field SY_CLKGATE

#define BP_DIGCTL_CTRL_SY_CLKGATE      7
#define BM_DIGCTL_CTRL_SY_CLKGATE      0x00000080

#define BF_DIGCTL_CTRL_SY_CLKGATE(v)   (((v) << 7) & BM_DIGCTL_CTRL_SY_CLKGATE)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_CTRL_SY_CLKGATE(v)   BF_CS1(DIGCTL_CTRL, SY_CLKGATE, v)
#endif

//--- Register HW_DIGCTL_CTRL, field USE_SERIAL_JTAG

#define BP_DIGCTL_CTRL_USE_SERIAL_JTAG      6
#define BM_DIGCTL_CTRL_USE_SERIAL_JTAG      0x00000040

#define BF_DIGCTL_CTRL_USE_SERIAL_JTAG(v)   (((v) << 6) & BM_DIGCTL_CTRL_USE_SERIAL_JTAG)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_CTRL_USE_SERIAL_JTAG(v)   BF_CS1(DIGCTL_CTRL, USE_SERIAL_JTAG, v)
#endif

#define BV_DIGCTL_CTRL_USE_SERIAL_JTAG__OLD_JTAG     0x0
#define BV_DIGCTL_CTRL_USE_SERIAL_JTAG__SERIAL_JTAG  0x1

//--- Register HW_DIGCTL_CTRL, field TRAP_IN_RANGE

#define BP_DIGCTL_CTRL_TRAP_IN_RANGE      5
#define BM_DIGCTL_CTRL_TRAP_IN_RANGE      0x00000020

#define BF_DIGCTL_CTRL_TRAP_IN_RANGE(v)   (((v) << 5) & BM_DIGCTL_CTRL_TRAP_IN_RANGE)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_CTRL_TRAP_IN_RANGE(v)   BF_CS1(DIGCTL_CTRL, TRAP_IN_RANGE, v)
#endif

//--- Register HW_DIGCTL_CTRL, field TRAP_ENABLE

#define BP_DIGCTL_CTRL_TRAP_ENABLE      4
#define BM_DIGCTL_CTRL_TRAP_ENABLE      0x00000010

#define BF_DIGCTL_CTRL_TRAP_ENABLE(v)   (((v) << 4) & BM_DIGCTL_CTRL_TRAP_ENABLE)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_CTRL_TRAP_ENABLE(v)   BF_CS1(DIGCTL_CTRL, TRAP_ENABLE, v)
#endif

//--- Register HW_DIGCTL_CTRL, field DEBUG_DISABLE

#define BP_DIGCTL_CTRL_DEBUG_DISABLE      3
#define BM_DIGCTL_CTRL_DEBUG_DISABLE      0x00000008

#define BF_DIGCTL_CTRL_DEBUG_DISABLE(v)   (((v) << 3) & BM_DIGCTL_CTRL_DEBUG_DISABLE)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_CTRL_DEBUG_DISABLE(v)   BF_CS1(DIGCTL_CTRL, DEBUG_DISABLE, v)
#endif

//--- Register HW_DIGCTL_CTRL, field USB_CLKGATE

#define BP_DIGCTL_CTRL_USB_CLKGATE      2
#define BM_DIGCTL_CTRL_USB_CLKGATE      0x00000004

#define BF_DIGCTL_CTRL_USB_CLKGATE(v)   (((v) << 2) & BM_DIGCTL_CTRL_USB_CLKGATE)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_CTRL_USB_CLKGATE(v)   BF_CS1(DIGCTL_CTRL, USB_CLKGATE, v)
#endif

#define BV_DIGCTL_CTRL_USB_CLKGATE__RUN      0x0
#define BV_DIGCTL_CTRL_USB_CLKGATE__NO_CLKS  0x1

//--- Register HW_DIGCTL_CTRL, field JTAG_SHIELD

#define BP_DIGCTL_CTRL_JTAG_SHIELD      1
#define BM_DIGCTL_CTRL_JTAG_SHIELD      0x00000002

#define BF_DIGCTL_CTRL_JTAG_SHIELD(v)   (((v) << 1) & BM_DIGCTL_CTRL_JTAG_SHIELD)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_CTRL_JTAG_SHIELD(v)   BF_CS1(DIGCTL_CTRL, JTAG_SHIELD, v)
#endif

#define BV_DIGCTL_CTRL_JTAG_SHIELD__NORMAL      0x0
#define BV_DIGCTL_CTRL_JTAG_SHIELD__SHIELDS_UP  0x1

//--- Register HW_DIGCTL_CTRL, field LATCH_ENTROPY

#define BP_DIGCTL_CTRL_LATCH_ENTROPY      0
#define BM_DIGCTL_CTRL_LATCH_ENTROPY      0x00000001

#define BF_DIGCTL_CTRL_LATCH_ENTROPY(v)   (((v) << 0) & BM_DIGCTL_CTRL_LATCH_ENTROPY)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_CTRL_LATCH_ENTROPY(v)   BF_CS1(DIGCTL_CTRL, LATCH_ENTROPY, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_STATUS - DIGCTL Status Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned WRITTEN             :  1;
        unsigned PACKAGE_TYPE        :  3;
        unsigned JTAG_IN_USE         :  1;
        unsigned LCD_BIST_DONE       :  1;
        unsigned LCD_BIST_PASS       :  1;
        unsigned LCD_BIST_FAIL       :  1;
        unsigned DCP_BIST_DONE       :  1;
        unsigned DCP_BIST_PASS       :  1;
        unsigned DCP_BIST_FAIL       :  1;
        unsigned RSVD2               : 17;
        unsigned USB_DEVICE_PRESENT  :  1;
        unsigned USB_HOST_PRESENT    :  1;
        unsigned USB_OTG_PRESENT     :  1;
        unsigned USB_HS_PRESENT      :  1;
    } B;
} hw_digctl_status_t;
#endif


//
// constants & macros for entire HW_DIGCTL_STATUS register
//

#define HW_DIGCTL_STATUS_ADDR      (REGS_DIGCTL_BASE + 0x00000010)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_STATUS           (*(volatile hw_digctl_status_t *) HW_DIGCTL_STATUS_ADDR)
#define HW_DIGCTL_STATUS_RD()      (HW_DIGCTL_STATUS.U)
#endif


//
// constants & macros for individual HW_DIGCTL_STATUS bitfields
//

//--- Register HW_DIGCTL_STATUS, field USB_HS_PRESENT

#define BP_DIGCTL_STATUS_USB_HS_PRESENT      31
#define BM_DIGCTL_STATUS_USB_HS_PRESENT      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_STATUS_USB_HS_PRESENT(v)   ((((reg32_t) v) << 31) & BM_DIGCTL_STATUS_USB_HS_PRESENT)
#else
#define BF_DIGCTL_STATUS_USB_HS_PRESENT(v)   (((v) << 31) & BM_DIGCTL_STATUS_USB_HS_PRESENT)
#endif

//--- Register HW_DIGCTL_STATUS, field USB_OTG_PRESENT

#define BP_DIGCTL_STATUS_USB_OTG_PRESENT      30
#define BM_DIGCTL_STATUS_USB_OTG_PRESENT      0x40000000

#define BF_DIGCTL_STATUS_USB_OTG_PRESENT(v)   (((v) << 30) & BM_DIGCTL_STATUS_USB_OTG_PRESENT)

//--- Register HW_DIGCTL_STATUS, field USB_HOST_PRESENT

#define BP_DIGCTL_STATUS_USB_HOST_PRESENT      29
#define BM_DIGCTL_STATUS_USB_HOST_PRESENT      0x20000000

#define BF_DIGCTL_STATUS_USB_HOST_PRESENT(v)   (((v) << 29) & BM_DIGCTL_STATUS_USB_HOST_PRESENT)

//--- Register HW_DIGCTL_STATUS, field USB_DEVICE_PRESENT

#define BP_DIGCTL_STATUS_USB_DEVICE_PRESENT      28
#define BM_DIGCTL_STATUS_USB_DEVICE_PRESENT      0x10000000

#define BF_DIGCTL_STATUS_USB_DEVICE_PRESENT(v)   (((v) << 28) & BM_DIGCTL_STATUS_USB_DEVICE_PRESENT)

//--- Register HW_DIGCTL_STATUS, field DCP_BIST_FAIL

#define BP_DIGCTL_STATUS_DCP_BIST_FAIL      10
#define BM_DIGCTL_STATUS_DCP_BIST_FAIL      0x00000400

#define BF_DIGCTL_STATUS_DCP_BIST_FAIL(v)   (((v) << 10) & BM_DIGCTL_STATUS_DCP_BIST_FAIL)

//--- Register HW_DIGCTL_STATUS, field DCP_BIST_PASS

#define BP_DIGCTL_STATUS_DCP_BIST_PASS      9
#define BM_DIGCTL_STATUS_DCP_BIST_PASS      0x00000200

#define BF_DIGCTL_STATUS_DCP_BIST_PASS(v)   (((v) << 9) & BM_DIGCTL_STATUS_DCP_BIST_PASS)

//--- Register HW_DIGCTL_STATUS, field DCP_BIST_DONE

#define BP_DIGCTL_STATUS_DCP_BIST_DONE      8
#define BM_DIGCTL_STATUS_DCP_BIST_DONE      0x00000100

#define BF_DIGCTL_STATUS_DCP_BIST_DONE(v)   (((v) << 8) & BM_DIGCTL_STATUS_DCP_BIST_DONE)

//--- Register HW_DIGCTL_STATUS, field LCD_BIST_FAIL

#define BP_DIGCTL_STATUS_LCD_BIST_FAIL      7
#define BM_DIGCTL_STATUS_LCD_BIST_FAIL      0x00000080

#define BF_DIGCTL_STATUS_LCD_BIST_FAIL(v)   (((v) << 7) & BM_DIGCTL_STATUS_LCD_BIST_FAIL)

//--- Register HW_DIGCTL_STATUS, field LCD_BIST_PASS

#define BP_DIGCTL_STATUS_LCD_BIST_PASS      6
#define BM_DIGCTL_STATUS_LCD_BIST_PASS      0x00000040

#define BF_DIGCTL_STATUS_LCD_BIST_PASS(v)   (((v) << 6) & BM_DIGCTL_STATUS_LCD_BIST_PASS)

//--- Register HW_DIGCTL_STATUS, field LCD_BIST_DONE

#define BP_DIGCTL_STATUS_LCD_BIST_DONE      5
#define BM_DIGCTL_STATUS_LCD_BIST_DONE      0x00000020

#define BF_DIGCTL_STATUS_LCD_BIST_DONE(v)   (((v) << 5) & BM_DIGCTL_STATUS_LCD_BIST_DONE)

//--- Register HW_DIGCTL_STATUS, field JTAG_IN_USE

#define BP_DIGCTL_STATUS_JTAG_IN_USE      4
#define BM_DIGCTL_STATUS_JTAG_IN_USE      0x00000010

#define BF_DIGCTL_STATUS_JTAG_IN_USE(v)   (((v) << 4) & BM_DIGCTL_STATUS_JTAG_IN_USE)

//--- Register HW_DIGCTL_STATUS, field PACKAGE_TYPE

#define BP_DIGCTL_STATUS_PACKAGE_TYPE      1
#define BM_DIGCTL_STATUS_PACKAGE_TYPE      0x0000000E

#define BF_DIGCTL_STATUS_PACKAGE_TYPE(v)   (((v) << 1) & BM_DIGCTL_STATUS_PACKAGE_TYPE)

//--- Register HW_DIGCTL_STATUS, field WRITTEN

#define BP_DIGCTL_STATUS_WRITTEN      0
#define BM_DIGCTL_STATUS_WRITTEN      0x00000001

#define BF_DIGCTL_STATUS_WRITTEN(v)   (((v) << 0) & BM_DIGCTL_STATUS_WRITTEN)


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_HCLKCOUNT - Free-Running HCLK Counter Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  COUNT;
    } B;
} hw_digctl_hclkcount_t;
#endif


//
// constants & macros for entire HW_DIGCTL_HCLKCOUNT register
//

#define HW_DIGCTL_HCLKCOUNT_ADDR      (REGS_DIGCTL_BASE + 0x00000020)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_HCLKCOUNT           (*(volatile hw_digctl_hclkcount_t *) HW_DIGCTL_HCLKCOUNT_ADDR)
#define HW_DIGCTL_HCLKCOUNT_RD()      (HW_DIGCTL_HCLKCOUNT.U)
#endif


//
// constants & macros for individual HW_DIGCTL_HCLKCOUNT bitfields
//

//--- Register HW_DIGCTL_HCLKCOUNT, field COUNT

#define BP_DIGCTL_HCLKCOUNT_COUNT      0
#define BM_DIGCTL_HCLKCOUNT_COUNT      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_HCLKCOUNT_COUNT(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_HCLKCOUNT_COUNT(v)   (v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_RAMCTRL - On-Chip RAM Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RAM_REPAIR_EN  :  1;
        unsigned RSVD0          :  7;
        unsigned SPEED_SELECT   :  4;
        unsigned RSVD1          : 20;
    } B;
} hw_digctl_ramctrl_t;
#endif


//
// constants & macros for entire HW_DIGCTL_RAMCTRL register
//

#define HW_DIGCTL_RAMCTRL_ADDR      (REGS_DIGCTL_BASE + 0x00000030)
#define HW_DIGCTL_RAMCTRL_SET_ADDR  (REGS_DIGCTL_BASE + 0x00000034)
#define HW_DIGCTL_RAMCTRL_CLR_ADDR  (REGS_DIGCTL_BASE + 0x00000038)
#define HW_DIGCTL_RAMCTRL_TOG_ADDR  (REGS_DIGCTL_BASE + 0x0000003C)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_RAMCTRL           (*(volatile hw_digctl_ramctrl_t *) HW_DIGCTL_RAMCTRL_ADDR)
#define HW_DIGCTL_RAMCTRL_RD()      (HW_DIGCTL_RAMCTRL.U)
#define HW_DIGCTL_RAMCTRL_WR(v)     (HW_DIGCTL_RAMCTRL.U = (v))
#define HW_DIGCTL_RAMCTRL_SET(v)    ((*(volatile reg32_t *) HW_DIGCTL_RAMCTRL_SET_ADDR) = (v))
#define HW_DIGCTL_RAMCTRL_CLR(v)    ((*(volatile reg32_t *) HW_DIGCTL_RAMCTRL_CLR_ADDR) = (v))
#define HW_DIGCTL_RAMCTRL_TOG(v)    ((*(volatile reg32_t *) HW_DIGCTL_RAMCTRL_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_DIGCTL_RAMCTRL bitfields
//

//--- Register HW_DIGCTL_RAMCTRL, field SPEED_SELECT

#define BP_DIGCTL_RAMCTRL_SPEED_SELECT      8
#define BM_DIGCTL_RAMCTRL_SPEED_SELECT      0x00000F00

#define BF_DIGCTL_RAMCTRL_SPEED_SELECT(v)   (((v) << 8) & BM_DIGCTL_RAMCTRL_SPEED_SELECT)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_RAMCTRL_SPEED_SELECT(v)   BF_CS1(DIGCTL_RAMCTRL, SPEED_SELECT, v)
#endif

//--- Register HW_DIGCTL_RAMCTRL, field RAM_REPAIR_EN

#define BP_DIGCTL_RAMCTRL_RAM_REPAIR_EN      0
#define BM_DIGCTL_RAMCTRL_RAM_REPAIR_EN      0x00000001

#define BF_DIGCTL_RAMCTRL_RAM_REPAIR_EN(v)   (((v) << 0) & BM_DIGCTL_RAMCTRL_RAM_REPAIR_EN)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_RAMCTRL_RAM_REPAIR_EN(v)   BF_CS1(DIGCTL_RAMCTRL, RAM_REPAIR_EN, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_RAMREPAIR - On-Chip RAM Repair Address Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg16_t  ADDR;
        reg16_t  RSVD1;
    } B;
} hw_digctl_ramrepair_t;
#endif


//
// constants & macros for entire HW_DIGCTL_RAMREPAIR register
//

#define HW_DIGCTL_RAMREPAIR_ADDR      (REGS_DIGCTL_BASE + 0x00000040)
#define HW_DIGCTL_RAMREPAIR_SET_ADDR  (REGS_DIGCTL_BASE + 0x00000044)
#define HW_DIGCTL_RAMREPAIR_CLR_ADDR  (REGS_DIGCTL_BASE + 0x00000048)
#define HW_DIGCTL_RAMREPAIR_TOG_ADDR  (REGS_DIGCTL_BASE + 0x0000004C)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_RAMREPAIR           (*(volatile hw_digctl_ramrepair_t *) HW_DIGCTL_RAMREPAIR_ADDR)
#define HW_DIGCTL_RAMREPAIR_RD()      (HW_DIGCTL_RAMREPAIR.U)
#define HW_DIGCTL_RAMREPAIR_WR(v)     (HW_DIGCTL_RAMREPAIR.U = (v))
#define HW_DIGCTL_RAMREPAIR_SET(v)    ((*(volatile reg32_t *) HW_DIGCTL_RAMREPAIR_SET_ADDR) = (v))
#define HW_DIGCTL_RAMREPAIR_CLR(v)    ((*(volatile reg32_t *) HW_DIGCTL_RAMREPAIR_CLR_ADDR) = (v))
#define HW_DIGCTL_RAMREPAIR_TOG(v)    ((*(volatile reg32_t *) HW_DIGCTL_RAMREPAIR_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_DIGCTL_RAMREPAIR bitfields
//

//--- Register HW_DIGCTL_RAMREPAIR, field ADDR

#define BP_DIGCTL_RAMREPAIR_ADDR      0
#define BM_DIGCTL_RAMREPAIR_ADDR      0x0000FFFF

#define BF_DIGCTL_RAMREPAIR_ADDR(v)   (((v) << 0) & BM_DIGCTL_RAMREPAIR_ADDR)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_RAMREPAIR_ADDR(v)   (HW_DIGCTL_RAMREPAIR.B.ADDR = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_ROMCTRL - On-Chip ROM Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RD_MARGIN  :  4;
        unsigned RSVD0      : 28;
    } B;
} hw_digctl_romctrl_t;
#endif


//
// constants & macros for entire HW_DIGCTL_ROMCTRL register
//

#define HW_DIGCTL_ROMCTRL_ADDR      (REGS_DIGCTL_BASE + 0x00000050)
#define HW_DIGCTL_ROMCTRL_SET_ADDR  (REGS_DIGCTL_BASE + 0x00000054)
#define HW_DIGCTL_ROMCTRL_CLR_ADDR  (REGS_DIGCTL_BASE + 0x00000058)
#define HW_DIGCTL_ROMCTRL_TOG_ADDR  (REGS_DIGCTL_BASE + 0x0000005C)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_ROMCTRL           (*(volatile hw_digctl_romctrl_t *) HW_DIGCTL_ROMCTRL_ADDR)
#define HW_DIGCTL_ROMCTRL_RD()      (HW_DIGCTL_ROMCTRL.U)
#define HW_DIGCTL_ROMCTRL_WR(v)     (HW_DIGCTL_ROMCTRL.U = (v))
#define HW_DIGCTL_ROMCTRL_SET(v)    ((*(volatile reg32_t *) HW_DIGCTL_ROMCTRL_SET_ADDR) = (v))
#define HW_DIGCTL_ROMCTRL_CLR(v)    ((*(volatile reg32_t *) HW_DIGCTL_ROMCTRL_CLR_ADDR) = (v))
#define HW_DIGCTL_ROMCTRL_TOG(v)    ((*(volatile reg32_t *) HW_DIGCTL_ROMCTRL_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_DIGCTL_ROMCTRL bitfields
//

//--- Register HW_DIGCTL_ROMCTRL, field RD_MARGIN

#define BP_DIGCTL_ROMCTRL_RD_MARGIN      0
#define BM_DIGCTL_ROMCTRL_RD_MARGIN      0x0000000F

#define BF_DIGCTL_ROMCTRL_RD_MARGIN(v)   (((v) << 0) & BM_DIGCTL_ROMCTRL_RD_MARGIN)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_ROMCTRL_RD_MARGIN(v)   BF_CS1(DIGCTL_ROMCTRL, RD_MARGIN, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_WRITEONCE - Software Write-Once Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  BITS;
    } B;
} hw_digctl_writeonce_t;
#endif


//
// constants & macros for entire HW_DIGCTL_WRITEONCE register
//

#define HW_DIGCTL_WRITEONCE_ADDR      (REGS_DIGCTL_BASE + 0x00000060)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_WRITEONCE           (*(volatile hw_digctl_writeonce_t *) HW_DIGCTL_WRITEONCE_ADDR)
#define HW_DIGCTL_WRITEONCE_RD()      (HW_DIGCTL_WRITEONCE.U)
#define HW_DIGCTL_WRITEONCE_WR(v)     (HW_DIGCTL_WRITEONCE.U = (v))
#define HW_DIGCTL_WRITEONCE_SET(v)    (HW_DIGCTL_WRITEONCE_WR(HW_DIGCTL_WRITEONCE_RD() |  (v)))
#define HW_DIGCTL_WRITEONCE_CLR(v)    (HW_DIGCTL_WRITEONCE_WR(HW_DIGCTL_WRITEONCE_RD() & ~(v)))
#define HW_DIGCTL_WRITEONCE_TOG(v)    (HW_DIGCTL_WRITEONCE_WR(HW_DIGCTL_WRITEONCE_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DIGCTL_WRITEONCE bitfields
//

//--- Register HW_DIGCTL_WRITEONCE, field BITS

#define BP_DIGCTL_WRITEONCE_BITS      0
#define BM_DIGCTL_WRITEONCE_BITS      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_WRITEONCE_BITS(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_WRITEONCE_BITS(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_WRITEONCE_BITS(v)   (HW_DIGCTL_WRITEONCE.B.BITS = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_ENTROPY - Entropy Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  VALUE;
    } B;
} hw_digctl_entropy_t;
#endif


//
// constants & macros for entire HW_DIGCTL_ENTROPY register
//

#define HW_DIGCTL_ENTROPY_ADDR      (REGS_DIGCTL_BASE + 0x00000090)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_ENTROPY           (*(volatile hw_digctl_entropy_t *) HW_DIGCTL_ENTROPY_ADDR)
#define HW_DIGCTL_ENTROPY_RD()      (HW_DIGCTL_ENTROPY.U)
#endif


//
// constants & macros for individual HW_DIGCTL_ENTROPY bitfields
//

//--- Register HW_DIGCTL_ENTROPY, field VALUE

#define BP_DIGCTL_ENTROPY_VALUE      0
#define BM_DIGCTL_ENTROPY_VALUE      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_ENTROPY_VALUE(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_ENTROPY_VALUE(v)   (v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_ENTROPY_LATCHED - Entropy Latched Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  VALUE;
    } B;
} hw_digctl_entropy_latched_t;
#endif


//
// constants & macros for entire HW_DIGCTL_ENTROPY_LATCHED register
//

#define HW_DIGCTL_ENTROPY_LATCHED_ADDR      (REGS_DIGCTL_BASE + 0x000000A0)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_ENTROPY_LATCHED           (*(volatile hw_digctl_entropy_latched_t *) HW_DIGCTL_ENTROPY_LATCHED_ADDR)
#define HW_DIGCTL_ENTROPY_LATCHED_RD()      (HW_DIGCTL_ENTROPY_LATCHED.U)
#endif


//
// constants & macros for individual HW_DIGCTL_ENTROPY_LATCHED bitfields
//

//--- Register HW_DIGCTL_ENTROPY_LATCHED, field VALUE

#define BP_DIGCTL_ENTROPY_LATCHED_VALUE      0
#define BM_DIGCTL_ENTROPY_LATCHED_VALUE      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_ENTROPY_LATCHED_VALUE(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_ENTROPY_LATCHED_VALUE(v)   (v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_SJTAGDBG - SJTAG Debug Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned SJTAG_DEBUG_OE    :  1;
        unsigned SJTAG_DEBUG_DATA  :  1;
        unsigned SJTAG_PIN_STATE   :  1;
        unsigned ACTIVE            :  1;
        unsigned DELAYED_ACTIVE    :  4;
        unsigned SJTAG_MODE        :  1;
        unsigned SJTAG_TDI         :  1;
        unsigned SJTAG_TDO         :  1;
        unsigned RSVD1             :  5;
        unsigned SJTAG_STATE       : 11;
        unsigned RSVD2             :  5;
    } B;
} hw_digctl_sjtagdbg_t;
#endif


//
// constants & macros for entire HW_DIGCTL_SJTAGDBG register
//

#define HW_DIGCTL_SJTAGDBG_ADDR      (REGS_DIGCTL_BASE + 0x000000B0)
#define HW_DIGCTL_SJTAGDBG_SET_ADDR  (REGS_DIGCTL_BASE + 0x000000B4)
#define HW_DIGCTL_SJTAGDBG_CLR_ADDR  (REGS_DIGCTL_BASE + 0x000000B8)
#define HW_DIGCTL_SJTAGDBG_TOG_ADDR  (REGS_DIGCTL_BASE + 0x000000BC)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_SJTAGDBG           (*(volatile hw_digctl_sjtagdbg_t *) HW_DIGCTL_SJTAGDBG_ADDR)
#define HW_DIGCTL_SJTAGDBG_RD()      (HW_DIGCTL_SJTAGDBG.U)
#define HW_DIGCTL_SJTAGDBG_WR(v)     (HW_DIGCTL_SJTAGDBG.U = (v))
#define HW_DIGCTL_SJTAGDBG_SET(v)    ((*(volatile reg32_t *) HW_DIGCTL_SJTAGDBG_SET_ADDR) = (v))
#define HW_DIGCTL_SJTAGDBG_CLR(v)    ((*(volatile reg32_t *) HW_DIGCTL_SJTAGDBG_CLR_ADDR) = (v))
#define HW_DIGCTL_SJTAGDBG_TOG(v)    ((*(volatile reg32_t *) HW_DIGCTL_SJTAGDBG_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_DIGCTL_SJTAGDBG bitfields
//

//--- Register HW_DIGCTL_SJTAGDBG, field SJTAG_STATE

#define BP_DIGCTL_SJTAGDBG_SJTAG_STATE      16
#define BM_DIGCTL_SJTAGDBG_SJTAG_STATE      0x07FF0000

#define BF_DIGCTL_SJTAGDBG_SJTAG_STATE(v)   (((v) << 16) & BM_DIGCTL_SJTAGDBG_SJTAG_STATE)

//--- Register HW_DIGCTL_SJTAGDBG, field SJTAG_TDO

#define BP_DIGCTL_SJTAGDBG_SJTAG_TDO      10
#define BM_DIGCTL_SJTAGDBG_SJTAG_TDO      0x00000400

#define BF_DIGCTL_SJTAGDBG_SJTAG_TDO(v)   (((v) << 10) & BM_DIGCTL_SJTAGDBG_SJTAG_TDO)

//--- Register HW_DIGCTL_SJTAGDBG, field SJTAG_TDI

#define BP_DIGCTL_SJTAGDBG_SJTAG_TDI      9
#define BM_DIGCTL_SJTAGDBG_SJTAG_TDI      0x00000200

#define BF_DIGCTL_SJTAGDBG_SJTAG_TDI(v)   (((v) << 9) & BM_DIGCTL_SJTAGDBG_SJTAG_TDI)

//--- Register HW_DIGCTL_SJTAGDBG, field SJTAG_MODE

#define BP_DIGCTL_SJTAGDBG_SJTAG_MODE      8
#define BM_DIGCTL_SJTAGDBG_SJTAG_MODE      0x00000100

#define BF_DIGCTL_SJTAGDBG_SJTAG_MODE(v)   (((v) << 8) & BM_DIGCTL_SJTAGDBG_SJTAG_MODE)

//--- Register HW_DIGCTL_SJTAGDBG, field DELAYED_ACTIVE

#define BP_DIGCTL_SJTAGDBG_DELAYED_ACTIVE      4
#define BM_DIGCTL_SJTAGDBG_DELAYED_ACTIVE      0x000000F0

#define BF_DIGCTL_SJTAGDBG_DELAYED_ACTIVE(v)   (((v) << 4) & BM_DIGCTL_SJTAGDBG_DELAYED_ACTIVE)

//--- Register HW_DIGCTL_SJTAGDBG, field ACTIVE

#define BP_DIGCTL_SJTAGDBG_ACTIVE      3
#define BM_DIGCTL_SJTAGDBG_ACTIVE      0x00000008

#define BF_DIGCTL_SJTAGDBG_ACTIVE(v)   (((v) << 3) & BM_DIGCTL_SJTAGDBG_ACTIVE)

//--- Register HW_DIGCTL_SJTAGDBG, field SJTAG_PIN_STATE

#define BP_DIGCTL_SJTAGDBG_SJTAG_PIN_STATE      2
#define BM_DIGCTL_SJTAGDBG_SJTAG_PIN_STATE      0x00000004

#define BF_DIGCTL_SJTAGDBG_SJTAG_PIN_STATE(v)   (((v) << 2) & BM_DIGCTL_SJTAGDBG_SJTAG_PIN_STATE)

//--- Register HW_DIGCTL_SJTAGDBG, field SJTAG_DEBUG_DATA

#define BP_DIGCTL_SJTAGDBG_SJTAG_DEBUG_DATA      1
#define BM_DIGCTL_SJTAGDBG_SJTAG_DEBUG_DATA      0x00000002

#define BF_DIGCTL_SJTAGDBG_SJTAG_DEBUG_DATA(v)   (((v) << 1) & BM_DIGCTL_SJTAGDBG_SJTAG_DEBUG_DATA)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_SJTAGDBG_SJTAG_DEBUG_DATA(v)   BF_CS1(DIGCTL_SJTAGDBG, SJTAG_DEBUG_DATA, v)
#endif

//--- Register HW_DIGCTL_SJTAGDBG, field SJTAG_DEBUG_OE

#define BP_DIGCTL_SJTAGDBG_SJTAG_DEBUG_OE      0
#define BM_DIGCTL_SJTAGDBG_SJTAG_DEBUG_OE      0x00000001

#define BF_DIGCTL_SJTAGDBG_SJTAG_DEBUG_OE(v)   (((v) << 0) & BM_DIGCTL_SJTAGDBG_SJTAG_DEBUG_OE)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_SJTAGDBG_SJTAG_DEBUG_OE(v)   BF_CS1(DIGCTL_SJTAGDBG, SJTAG_DEBUG_OE, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_MICROSECONDS - Digital Control Microseconds Counter Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  VALUE;
    } B;
} hw_digctl_microseconds_t;
#endif


//
// constants & macros for entire HW_DIGCTL_MICROSECONDS register
//

#define HW_DIGCTL_MICROSECONDS_ADDR      (REGS_DIGCTL_BASE + 0x000000C0)
#define HW_DIGCTL_MICROSECONDS_SET_ADDR  (REGS_DIGCTL_BASE + 0x000000C4)
#define HW_DIGCTL_MICROSECONDS_CLR_ADDR  (REGS_DIGCTL_BASE + 0x000000C8)
#define HW_DIGCTL_MICROSECONDS_TOG_ADDR  (REGS_DIGCTL_BASE + 0x000000CC)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_MICROSECONDS           (*(volatile hw_digctl_microseconds_t *) HW_DIGCTL_MICROSECONDS_ADDR)
#define HW_DIGCTL_MICROSECONDS_RD()      (HW_DIGCTL_MICROSECONDS.U)
#define HW_DIGCTL_MICROSECONDS_WR(v)     (HW_DIGCTL_MICROSECONDS.U = (v))
#define HW_DIGCTL_MICROSECONDS_SET(v)    ((*(volatile reg32_t *) HW_DIGCTL_MICROSECONDS_SET_ADDR) = (v))
#define HW_DIGCTL_MICROSECONDS_CLR(v)    ((*(volatile reg32_t *) HW_DIGCTL_MICROSECONDS_CLR_ADDR) = (v))
#define HW_DIGCTL_MICROSECONDS_TOG(v)    ((*(volatile reg32_t *) HW_DIGCTL_MICROSECONDS_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_DIGCTL_MICROSECONDS bitfields
//

//--- Register HW_DIGCTL_MICROSECONDS, field VALUE

#define BP_DIGCTL_MICROSECONDS_VALUE      0
#define BM_DIGCTL_MICROSECONDS_VALUE      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_MICROSECONDS_VALUE(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_MICROSECONDS_VALUE(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_MICROSECONDS_VALUE(v)   (HW_DIGCTL_MICROSECONDS.B.VALUE = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_DBGRD - Digital Control Debug Read Test Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  COMPLEMENT;
    } B;
} hw_digctl_dbgrd_t;
#endif


//
// constants & macros for entire HW_DIGCTL_DBGRD register
//

#define HW_DIGCTL_DBGRD_ADDR      (REGS_DIGCTL_BASE + 0x000000D0)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_DBGRD           (*(volatile hw_digctl_dbgrd_t *) HW_DIGCTL_DBGRD_ADDR)
#define HW_DIGCTL_DBGRD_RD()      (HW_DIGCTL_DBGRD.U)
#endif


//
// constants & macros for individual HW_DIGCTL_DBGRD bitfields
//

//--- Register HW_DIGCTL_DBGRD, field COMPLEMENT

#define BP_DIGCTL_DBGRD_COMPLEMENT      0
#define BM_DIGCTL_DBGRD_COMPLEMENT      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_DBGRD_COMPLEMENT(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_DBGRD_COMPLEMENT(v)   (v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_DBG - Digital Control Debug Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  VALUE;
    } B;
} hw_digctl_dbg_t;
#endif


//
// constants & macros for entire HW_DIGCTL_DBG register
//

#define HW_DIGCTL_DBG_ADDR      (REGS_DIGCTL_BASE + 0x000000E0)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_DBG           (*(volatile hw_digctl_dbg_t *) HW_DIGCTL_DBG_ADDR)
#define HW_DIGCTL_DBG_RD()      (HW_DIGCTL_DBG.U)
#endif


//
// constants & macros for individual HW_DIGCTL_DBG bitfields
//

//--- Register HW_DIGCTL_DBG, field VALUE

#define BP_DIGCTL_DBG_VALUE      0
#define BM_DIGCTL_DBG_VALUE      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_DBG_VALUE(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_DBG_VALUE(v)   (v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_OCRAM_BIST_CSR - SRAM BIST Control and Status Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned START             :  1;
        unsigned DONE              :  1;
        unsigned PASS              :  1;
        unsigned FAIL              :  1;
        unsigned RSVD0             :  4;
        unsigned BIST_CLKEN        :  1;
        unsigned BIST_DATA_CHANGE  :  1;
        unsigned BIST_DEBUG_MODE   :  1;
        unsigned RSVD1             : 21;
    } B;
} hw_digctl_ocram_bist_csr_t;
#endif


//
// constants & macros for entire HW_DIGCTL_OCRAM_BIST_CSR register
//

#define HW_DIGCTL_OCRAM_BIST_CSR_ADDR      (REGS_DIGCTL_BASE + 0x000000F0)
#define HW_DIGCTL_OCRAM_BIST_CSR_SET_ADDR  (REGS_DIGCTL_BASE + 0x000000F4)
#define HW_DIGCTL_OCRAM_BIST_CSR_CLR_ADDR  (REGS_DIGCTL_BASE + 0x000000F8)
#define HW_DIGCTL_OCRAM_BIST_CSR_TOG_ADDR  (REGS_DIGCTL_BASE + 0x000000FC)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_OCRAM_BIST_CSR           (*(volatile hw_digctl_ocram_bist_csr_t *) HW_DIGCTL_OCRAM_BIST_CSR_ADDR)
#define HW_DIGCTL_OCRAM_BIST_CSR_RD()      (HW_DIGCTL_OCRAM_BIST_CSR.U)
#define HW_DIGCTL_OCRAM_BIST_CSR_WR(v)     (HW_DIGCTL_OCRAM_BIST_CSR.U = (v))
#define HW_DIGCTL_OCRAM_BIST_CSR_SET(v)    ((*(volatile reg32_t *) HW_DIGCTL_OCRAM_BIST_CSR_SET_ADDR) = (v))
#define HW_DIGCTL_OCRAM_BIST_CSR_CLR(v)    ((*(volatile reg32_t *) HW_DIGCTL_OCRAM_BIST_CSR_CLR_ADDR) = (v))
#define HW_DIGCTL_OCRAM_BIST_CSR_TOG(v)    ((*(volatile reg32_t *) HW_DIGCTL_OCRAM_BIST_CSR_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_DIGCTL_OCRAM_BIST_CSR bitfields
//

//--- Register HW_DIGCTL_OCRAM_BIST_CSR, field BIST_DEBUG_MODE

#define BP_DIGCTL_OCRAM_BIST_CSR_BIST_DEBUG_MODE      10
#define BM_DIGCTL_OCRAM_BIST_CSR_BIST_DEBUG_MODE      0x00000400

#define BF_DIGCTL_OCRAM_BIST_CSR_BIST_DEBUG_MODE(v)   (((v) << 10) & BM_DIGCTL_OCRAM_BIST_CSR_BIST_DEBUG_MODE)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_OCRAM_BIST_CSR_BIST_DEBUG_MODE(v)   BF_CS1(DIGCTL_OCRAM_BIST_CSR, BIST_DEBUG_MODE, v)
#endif

//--- Register HW_DIGCTL_OCRAM_BIST_CSR, field BIST_DATA_CHANGE

#define BP_DIGCTL_OCRAM_BIST_CSR_BIST_DATA_CHANGE      9
#define BM_DIGCTL_OCRAM_BIST_CSR_BIST_DATA_CHANGE      0x00000200

#define BF_DIGCTL_OCRAM_BIST_CSR_BIST_DATA_CHANGE(v)   (((v) << 9) & BM_DIGCTL_OCRAM_BIST_CSR_BIST_DATA_CHANGE)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_OCRAM_BIST_CSR_BIST_DATA_CHANGE(v)   BF_CS1(DIGCTL_OCRAM_BIST_CSR, BIST_DATA_CHANGE, v)
#endif

//--- Register HW_DIGCTL_OCRAM_BIST_CSR, field BIST_CLKEN

#define BP_DIGCTL_OCRAM_BIST_CSR_BIST_CLKEN      8
#define BM_DIGCTL_OCRAM_BIST_CSR_BIST_CLKEN      0x00000100

#define BF_DIGCTL_OCRAM_BIST_CSR_BIST_CLKEN(v)   (((v) << 8) & BM_DIGCTL_OCRAM_BIST_CSR_BIST_CLKEN)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_OCRAM_BIST_CSR_BIST_CLKEN(v)   BF_CS1(DIGCTL_OCRAM_BIST_CSR, BIST_CLKEN, v)
#endif

//--- Register HW_DIGCTL_OCRAM_BIST_CSR, field FAIL

#define BP_DIGCTL_OCRAM_BIST_CSR_FAIL      3
#define BM_DIGCTL_OCRAM_BIST_CSR_FAIL      0x00000008

#define BF_DIGCTL_OCRAM_BIST_CSR_FAIL(v)   (((v) << 3) & BM_DIGCTL_OCRAM_BIST_CSR_FAIL)

//--- Register HW_DIGCTL_OCRAM_BIST_CSR, field PASS

#define BP_DIGCTL_OCRAM_BIST_CSR_PASS      2
#define BM_DIGCTL_OCRAM_BIST_CSR_PASS      0x00000004

#define BF_DIGCTL_OCRAM_BIST_CSR_PASS(v)   (((v) << 2) & BM_DIGCTL_OCRAM_BIST_CSR_PASS)

//--- Register HW_DIGCTL_OCRAM_BIST_CSR, field DONE

#define BP_DIGCTL_OCRAM_BIST_CSR_DONE      1
#define BM_DIGCTL_OCRAM_BIST_CSR_DONE      0x00000002

#define BF_DIGCTL_OCRAM_BIST_CSR_DONE(v)   (((v) << 1) & BM_DIGCTL_OCRAM_BIST_CSR_DONE)

//--- Register HW_DIGCTL_OCRAM_BIST_CSR, field START

#define BP_DIGCTL_OCRAM_BIST_CSR_START      0
#define BM_DIGCTL_OCRAM_BIST_CSR_START      0x00000001

#define BF_DIGCTL_OCRAM_BIST_CSR_START(v)   (((v) << 0) & BM_DIGCTL_OCRAM_BIST_CSR_START)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_OCRAM_BIST_CSR_START(v)   BF_CS1(DIGCTL_OCRAM_BIST_CSR, START, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_OCRAM_STATUS0 - SRAM Status Register 0
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  FAILDATA00;
    } B;
} hw_digctl_ocram_status0_t;
#endif


//
// constants & macros for entire HW_DIGCTL_OCRAM_STATUS0 register
//

#define HW_DIGCTL_OCRAM_STATUS0_ADDR      (REGS_DIGCTL_BASE + 0x00000110)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_OCRAM_STATUS0           (*(volatile hw_digctl_ocram_status0_t *) HW_DIGCTL_OCRAM_STATUS0_ADDR)
#define HW_DIGCTL_OCRAM_STATUS0_RD()      (HW_DIGCTL_OCRAM_STATUS0.U)
#endif


//
// constants & macros for individual HW_DIGCTL_OCRAM_STATUS0 bitfields
//

//--- Register HW_DIGCTL_OCRAM_STATUS0, field FAILDATA00

#define BP_DIGCTL_OCRAM_STATUS0_FAILDATA00      0
#define BM_DIGCTL_OCRAM_STATUS0_FAILDATA00      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_OCRAM_STATUS0_FAILDATA00(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_OCRAM_STATUS0_FAILDATA00(v)   (v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_OCRAM_STATUS1 - SRAM Status Register 1
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  FAILDATA01;
    } B;
} hw_digctl_ocram_status1_t;
#endif


//
// constants & macros for entire HW_DIGCTL_OCRAM_STATUS1 register
//

#define HW_DIGCTL_OCRAM_STATUS1_ADDR      (REGS_DIGCTL_BASE + 0x00000120)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_OCRAM_STATUS1           (*(volatile hw_digctl_ocram_status1_t *) HW_DIGCTL_OCRAM_STATUS1_ADDR)
#define HW_DIGCTL_OCRAM_STATUS1_RD()      (HW_DIGCTL_OCRAM_STATUS1.U)
#endif


//
// constants & macros for individual HW_DIGCTL_OCRAM_STATUS1 bitfields
//

//--- Register HW_DIGCTL_OCRAM_STATUS1, field FAILDATA01

#define BP_DIGCTL_OCRAM_STATUS1_FAILDATA01      0
#define BM_DIGCTL_OCRAM_STATUS1_FAILDATA01      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_OCRAM_STATUS1_FAILDATA01(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_OCRAM_STATUS1_FAILDATA01(v)   (v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_OCRAM_STATUS2 - SRAM Status Register 2
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  FAILDATA10;
    } B;
} hw_digctl_ocram_status2_t;
#endif


//
// constants & macros for entire HW_DIGCTL_OCRAM_STATUS2 register
//

#define HW_DIGCTL_OCRAM_STATUS2_ADDR      (REGS_DIGCTL_BASE + 0x00000130)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_OCRAM_STATUS2           (*(volatile hw_digctl_ocram_status2_t *) HW_DIGCTL_OCRAM_STATUS2_ADDR)
#define HW_DIGCTL_OCRAM_STATUS2_RD()      (HW_DIGCTL_OCRAM_STATUS2.U)
#endif


//
// constants & macros for individual HW_DIGCTL_OCRAM_STATUS2 bitfields
//

//--- Register HW_DIGCTL_OCRAM_STATUS2, field FAILDATA10

#define BP_DIGCTL_OCRAM_STATUS2_FAILDATA10      0
#define BM_DIGCTL_OCRAM_STATUS2_FAILDATA10      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_OCRAM_STATUS2_FAILDATA10(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_OCRAM_STATUS2_FAILDATA10(v)   (v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_OCRAM_STATUS3 - SRAM Status Register 3
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  FAILDATA11;
    } B;
} hw_digctl_ocram_status3_t;
#endif


//
// constants & macros for entire HW_DIGCTL_OCRAM_STATUS3 register
//

#define HW_DIGCTL_OCRAM_STATUS3_ADDR      (REGS_DIGCTL_BASE + 0x00000140)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_OCRAM_STATUS3           (*(volatile hw_digctl_ocram_status3_t *) HW_DIGCTL_OCRAM_STATUS3_ADDR)
#define HW_DIGCTL_OCRAM_STATUS3_RD()      (HW_DIGCTL_OCRAM_STATUS3.U)
#endif


//
// constants & macros for individual HW_DIGCTL_OCRAM_STATUS3 bitfields
//

//--- Register HW_DIGCTL_OCRAM_STATUS3, field FAILDATA11

#define BP_DIGCTL_OCRAM_STATUS3_FAILDATA11      0
#define BM_DIGCTL_OCRAM_STATUS3_FAILDATA11      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_OCRAM_STATUS3_FAILDATA11(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_OCRAM_STATUS3_FAILDATA11(v)   (v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_OCRAM_STATUS4 - SRAM Status Register 4
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  FAILDATA20;
    } B;
} hw_digctl_ocram_status4_t;
#endif


//
// constants & macros for entire HW_DIGCTL_OCRAM_STATUS4 register
//

#define HW_DIGCTL_OCRAM_STATUS4_ADDR      (REGS_DIGCTL_BASE + 0x00000150)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_OCRAM_STATUS4           (*(volatile hw_digctl_ocram_status4_t *) HW_DIGCTL_OCRAM_STATUS4_ADDR)
#define HW_DIGCTL_OCRAM_STATUS4_RD()      (HW_DIGCTL_OCRAM_STATUS4.U)
#endif


//
// constants & macros for individual HW_DIGCTL_OCRAM_STATUS4 bitfields
//

//--- Register HW_DIGCTL_OCRAM_STATUS4, field FAILDATA20

#define BP_DIGCTL_OCRAM_STATUS4_FAILDATA20      0
#define BM_DIGCTL_OCRAM_STATUS4_FAILDATA20      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_OCRAM_STATUS4_FAILDATA20(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_OCRAM_STATUS4_FAILDATA20(v)   (v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_OCRAM_STATUS5 - SRAM Status Register 5
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  FAILDATA21;
    } B;
} hw_digctl_ocram_status5_t;
#endif


//
// constants & macros for entire HW_DIGCTL_OCRAM_STATUS5 register
//

#define HW_DIGCTL_OCRAM_STATUS5_ADDR      (REGS_DIGCTL_BASE + 0x00000160)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_OCRAM_STATUS5           (*(volatile hw_digctl_ocram_status5_t *) HW_DIGCTL_OCRAM_STATUS5_ADDR)
#define HW_DIGCTL_OCRAM_STATUS5_RD()      (HW_DIGCTL_OCRAM_STATUS5.U)
#endif


//
// constants & macros for individual HW_DIGCTL_OCRAM_STATUS5 bitfields
//

//--- Register HW_DIGCTL_OCRAM_STATUS5, field FAILDATA21

#define BP_DIGCTL_OCRAM_STATUS5_FAILDATA21      0
#define BM_DIGCTL_OCRAM_STATUS5_FAILDATA21      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_OCRAM_STATUS5_FAILDATA21(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_OCRAM_STATUS5_FAILDATA21(v)   (v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_OCRAM_STATUS6 - SRAM Status Register 6
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  FAILDATA30;
    } B;
} hw_digctl_ocram_status6_t;
#endif


//
// constants & macros for entire HW_DIGCTL_OCRAM_STATUS6 register
//

#define HW_DIGCTL_OCRAM_STATUS6_ADDR      (REGS_DIGCTL_BASE + 0x00000170)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_OCRAM_STATUS6           (*(volatile hw_digctl_ocram_status6_t *) HW_DIGCTL_OCRAM_STATUS6_ADDR)
#define HW_DIGCTL_OCRAM_STATUS6_RD()      (HW_DIGCTL_OCRAM_STATUS6.U)
#endif


//
// constants & macros for individual HW_DIGCTL_OCRAM_STATUS6 bitfields
//

//--- Register HW_DIGCTL_OCRAM_STATUS6, field FAILDATA30

#define BP_DIGCTL_OCRAM_STATUS6_FAILDATA30      0
#define BM_DIGCTL_OCRAM_STATUS6_FAILDATA30      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_OCRAM_STATUS6_FAILDATA30(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_OCRAM_STATUS6_FAILDATA30(v)   (v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_OCRAM_STATUS7 - SRAM Status Register 7
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  FAILDATA31;
    } B;
} hw_digctl_ocram_status7_t;
#endif


//
// constants & macros for entire HW_DIGCTL_OCRAM_STATUS7 register
//

#define HW_DIGCTL_OCRAM_STATUS7_ADDR      (REGS_DIGCTL_BASE + 0x00000180)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_OCRAM_STATUS7           (*(volatile hw_digctl_ocram_status7_t *) HW_DIGCTL_OCRAM_STATUS7_ADDR)
#define HW_DIGCTL_OCRAM_STATUS7_RD()      (HW_DIGCTL_OCRAM_STATUS7.U)
#endif


//
// constants & macros for individual HW_DIGCTL_OCRAM_STATUS7 bitfields
//

//--- Register HW_DIGCTL_OCRAM_STATUS7, field FAILDATA31

#define BP_DIGCTL_OCRAM_STATUS7_FAILDATA31      0
#define BM_DIGCTL_OCRAM_STATUS7_FAILDATA31      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_OCRAM_STATUS7_FAILDATA31(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_OCRAM_STATUS7_FAILDATA31(v)   (v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_OCRAM_STATUS8 - SRAM Status Register 8
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned FAILADDR00  : 13;
        unsigned RSVD2       :  3;
        unsigned FAILADDR01  : 13;
        unsigned RSVD3       :  3;
    } B;
} hw_digctl_ocram_status8_t;
#endif


//
// constants & macros for entire HW_DIGCTL_OCRAM_STATUS8 register
//

#define HW_DIGCTL_OCRAM_STATUS8_ADDR      (REGS_DIGCTL_BASE + 0x00000190)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_OCRAM_STATUS8           (*(volatile hw_digctl_ocram_status8_t *) HW_DIGCTL_OCRAM_STATUS8_ADDR)
#define HW_DIGCTL_OCRAM_STATUS8_RD()      (HW_DIGCTL_OCRAM_STATUS8.U)
#endif


//
// constants & macros for individual HW_DIGCTL_OCRAM_STATUS8 bitfields
//

//--- Register HW_DIGCTL_OCRAM_STATUS8, field FAILADDR01

#define BP_DIGCTL_OCRAM_STATUS8_FAILADDR01      16
#define BM_DIGCTL_OCRAM_STATUS8_FAILADDR01      0x1FFF0000

#define BF_DIGCTL_OCRAM_STATUS8_FAILADDR01(v)   (((v) << 16) & BM_DIGCTL_OCRAM_STATUS8_FAILADDR01)

//--- Register HW_DIGCTL_OCRAM_STATUS8, field FAILADDR00

#define BP_DIGCTL_OCRAM_STATUS8_FAILADDR00      0
#define BM_DIGCTL_OCRAM_STATUS8_FAILADDR00      0x00001FFF

#define BF_DIGCTL_OCRAM_STATUS8_FAILADDR00(v)   (((v) << 0) & BM_DIGCTL_OCRAM_STATUS8_FAILADDR00)


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_OCRAM_STATUS9 - SRAM Status Register 9
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned FAILADDR10  : 13;
        unsigned RSVD2       :  3;
        unsigned FAILADDR11  : 13;
        unsigned RSVD3       :  3;
    } B;
} hw_digctl_ocram_status9_t;
#endif


//
// constants & macros for entire HW_DIGCTL_OCRAM_STATUS9 register
//

#define HW_DIGCTL_OCRAM_STATUS9_ADDR      (REGS_DIGCTL_BASE + 0x000001A0)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_OCRAM_STATUS9           (*(volatile hw_digctl_ocram_status9_t *) HW_DIGCTL_OCRAM_STATUS9_ADDR)
#define HW_DIGCTL_OCRAM_STATUS9_RD()      (HW_DIGCTL_OCRAM_STATUS9.U)
#endif


//
// constants & macros for individual HW_DIGCTL_OCRAM_STATUS9 bitfields
//

//--- Register HW_DIGCTL_OCRAM_STATUS9, field FAILADDR11

#define BP_DIGCTL_OCRAM_STATUS9_FAILADDR11      16
#define BM_DIGCTL_OCRAM_STATUS9_FAILADDR11      0x1FFF0000

#define BF_DIGCTL_OCRAM_STATUS9_FAILADDR11(v)   (((v) << 16) & BM_DIGCTL_OCRAM_STATUS9_FAILADDR11)

//--- Register HW_DIGCTL_OCRAM_STATUS9, field FAILADDR10

#define BP_DIGCTL_OCRAM_STATUS9_FAILADDR10      0
#define BM_DIGCTL_OCRAM_STATUS9_FAILADDR10      0x00001FFF

#define BF_DIGCTL_OCRAM_STATUS9_FAILADDR10(v)   (((v) << 0) & BM_DIGCTL_OCRAM_STATUS9_FAILADDR10)


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_OCRAM_STATUS10 - SRAM Status Register 10
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned FAILADDR20  : 13;
        unsigned RSVD2       :  3;
        unsigned FAILADDR21  : 13;
        unsigned RSVD3       :  3;
    } B;
} hw_digctl_ocram_status10_t;
#endif


//
// constants & macros for entire HW_DIGCTL_OCRAM_STATUS10 register
//

#define HW_DIGCTL_OCRAM_STATUS10_ADDR      (REGS_DIGCTL_BASE + 0x000001B0)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_OCRAM_STATUS10           (*(volatile hw_digctl_ocram_status10_t *) HW_DIGCTL_OCRAM_STATUS10_ADDR)
#define HW_DIGCTL_OCRAM_STATUS10_RD()      (HW_DIGCTL_OCRAM_STATUS10.U)
#endif


//
// constants & macros for individual HW_DIGCTL_OCRAM_STATUS10 bitfields
//

//--- Register HW_DIGCTL_OCRAM_STATUS10, field FAILADDR21

#define BP_DIGCTL_OCRAM_STATUS10_FAILADDR21      16
#define BM_DIGCTL_OCRAM_STATUS10_FAILADDR21      0x1FFF0000

#define BF_DIGCTL_OCRAM_STATUS10_FAILADDR21(v)   (((v) << 16) & BM_DIGCTL_OCRAM_STATUS10_FAILADDR21)

//--- Register HW_DIGCTL_OCRAM_STATUS10, field FAILADDR20

#define BP_DIGCTL_OCRAM_STATUS10_FAILADDR20      0
#define BM_DIGCTL_OCRAM_STATUS10_FAILADDR20      0x00001FFF

#define BF_DIGCTL_OCRAM_STATUS10_FAILADDR20(v)   (((v) << 0) & BM_DIGCTL_OCRAM_STATUS10_FAILADDR20)


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_OCRAM_STATUS11 - SRAM Status Register 11
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned FAILADDR30  : 13;
        unsigned RSVD2       :  3;
        unsigned FAILADDR31  : 13;
        unsigned RSVD3       :  3;
    } B;
} hw_digctl_ocram_status11_t;
#endif


//
// constants & macros for entire HW_DIGCTL_OCRAM_STATUS11 register
//

#define HW_DIGCTL_OCRAM_STATUS11_ADDR      (REGS_DIGCTL_BASE + 0x000001C0)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_OCRAM_STATUS11           (*(volatile hw_digctl_ocram_status11_t *) HW_DIGCTL_OCRAM_STATUS11_ADDR)
#define HW_DIGCTL_OCRAM_STATUS11_RD()      (HW_DIGCTL_OCRAM_STATUS11.U)
#endif


//
// constants & macros for individual HW_DIGCTL_OCRAM_STATUS11 bitfields
//

//--- Register HW_DIGCTL_OCRAM_STATUS11, field FAILADDR31

#define BP_DIGCTL_OCRAM_STATUS11_FAILADDR31      16
#define BM_DIGCTL_OCRAM_STATUS11_FAILADDR31      0x1FFF0000

#define BF_DIGCTL_OCRAM_STATUS11_FAILADDR31(v)   (((v) << 16) & BM_DIGCTL_OCRAM_STATUS11_FAILADDR31)

//--- Register HW_DIGCTL_OCRAM_STATUS11, field FAILADDR30

#define BP_DIGCTL_OCRAM_STATUS11_FAILADDR30      0
#define BM_DIGCTL_OCRAM_STATUS11_FAILADDR30      0x00001FFF

#define BF_DIGCTL_OCRAM_STATUS11_FAILADDR30(v)   (((v) << 0) & BM_DIGCTL_OCRAM_STATUS11_FAILADDR30)


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_OCRAM_STATUS12 - SRAM Status Register 12
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned FAILSTATE00  :  4;
        unsigned RSVD0        :  4;
        unsigned FAILSTATE01  :  4;
        unsigned RSVD1        :  4;
        unsigned FAILSTATE10  :  4;
        unsigned RSVD2        :  4;
        unsigned FAILSTATE11  :  4;
        unsigned RSVD3        :  4;
    } B;
} hw_digctl_ocram_status12_t;
#endif


//
// constants & macros for entire HW_DIGCTL_OCRAM_STATUS12 register
//

#define HW_DIGCTL_OCRAM_STATUS12_ADDR      (REGS_DIGCTL_BASE + 0x000001D0)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_OCRAM_STATUS12           (*(volatile hw_digctl_ocram_status12_t *) HW_DIGCTL_OCRAM_STATUS12_ADDR)
#define HW_DIGCTL_OCRAM_STATUS12_RD()      (HW_DIGCTL_OCRAM_STATUS12.U)
#endif


//
// constants & macros for individual HW_DIGCTL_OCRAM_STATUS12 bitfields
//

//--- Register HW_DIGCTL_OCRAM_STATUS12, field FAILSTATE11

#define BP_DIGCTL_OCRAM_STATUS12_FAILSTATE11      24
#define BM_DIGCTL_OCRAM_STATUS12_FAILSTATE11      0x0F000000

#define BF_DIGCTL_OCRAM_STATUS12_FAILSTATE11(v)   (((v) << 24) & BM_DIGCTL_OCRAM_STATUS12_FAILSTATE11)

//--- Register HW_DIGCTL_OCRAM_STATUS12, field FAILSTATE10

#define BP_DIGCTL_OCRAM_STATUS12_FAILSTATE10      16
#define BM_DIGCTL_OCRAM_STATUS12_FAILSTATE10      0x000F0000

#define BF_DIGCTL_OCRAM_STATUS12_FAILSTATE10(v)   (((v) << 16) & BM_DIGCTL_OCRAM_STATUS12_FAILSTATE10)

//--- Register HW_DIGCTL_OCRAM_STATUS12, field FAILSTATE01

#define BP_DIGCTL_OCRAM_STATUS12_FAILSTATE01      8
#define BM_DIGCTL_OCRAM_STATUS12_FAILSTATE01      0x00000F00

#define BF_DIGCTL_OCRAM_STATUS12_FAILSTATE01(v)   (((v) << 8) & BM_DIGCTL_OCRAM_STATUS12_FAILSTATE01)

//--- Register HW_DIGCTL_OCRAM_STATUS12, field FAILSTATE00

#define BP_DIGCTL_OCRAM_STATUS12_FAILSTATE00      0
#define BM_DIGCTL_OCRAM_STATUS12_FAILSTATE00      0x0000000F

#define BF_DIGCTL_OCRAM_STATUS12_FAILSTATE00(v)   (((v) << 0) & BM_DIGCTL_OCRAM_STATUS12_FAILSTATE00)


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_OCRAM_STATUS13 - SRAM Status Register 13
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned FAILSTATE20  :  4;
        unsigned RSVD0        :  4;
        unsigned FAILSTATE21  :  4;
        unsigned RSVD1        :  4;
        unsigned FAILSTATE30  :  4;
        unsigned RSVD2        :  4;
        unsigned FAILSTATE31  :  4;
        unsigned RSVD3        :  4;
    } B;
} hw_digctl_ocram_status13_t;
#endif


//
// constants & macros for entire HW_DIGCTL_OCRAM_STATUS13 register
//

#define HW_DIGCTL_OCRAM_STATUS13_ADDR      (REGS_DIGCTL_BASE + 0x000001E0)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_OCRAM_STATUS13           (*(volatile hw_digctl_ocram_status13_t *) HW_DIGCTL_OCRAM_STATUS13_ADDR)
#define HW_DIGCTL_OCRAM_STATUS13_RD()      (HW_DIGCTL_OCRAM_STATUS13.U)
#endif


//
// constants & macros for individual HW_DIGCTL_OCRAM_STATUS13 bitfields
//

//--- Register HW_DIGCTL_OCRAM_STATUS13, field FAILSTATE31

#define BP_DIGCTL_OCRAM_STATUS13_FAILSTATE31      24
#define BM_DIGCTL_OCRAM_STATUS13_FAILSTATE31      0x0F000000

#define BF_DIGCTL_OCRAM_STATUS13_FAILSTATE31(v)   (((v) << 24) & BM_DIGCTL_OCRAM_STATUS13_FAILSTATE31)

//--- Register HW_DIGCTL_OCRAM_STATUS13, field FAILSTATE30

#define BP_DIGCTL_OCRAM_STATUS13_FAILSTATE30      16
#define BM_DIGCTL_OCRAM_STATUS13_FAILSTATE30      0x000F0000

#define BF_DIGCTL_OCRAM_STATUS13_FAILSTATE30(v)   (((v) << 16) & BM_DIGCTL_OCRAM_STATUS13_FAILSTATE30)

//--- Register HW_DIGCTL_OCRAM_STATUS13, field FAILSTATE21

#define BP_DIGCTL_OCRAM_STATUS13_FAILSTATE21      8
#define BM_DIGCTL_OCRAM_STATUS13_FAILSTATE21      0x00000F00

#define BF_DIGCTL_OCRAM_STATUS13_FAILSTATE21(v)   (((v) << 8) & BM_DIGCTL_OCRAM_STATUS13_FAILSTATE21)

//--- Register HW_DIGCTL_OCRAM_STATUS13, field FAILSTATE20

#define BP_DIGCTL_OCRAM_STATUS13_FAILSTATE20      0
#define BM_DIGCTL_OCRAM_STATUS13_FAILSTATE20      0x0000000F

#define BF_DIGCTL_OCRAM_STATUS13_FAILSTATE20(v)   (((v) << 0) & BM_DIGCTL_OCRAM_STATUS13_FAILSTATE20)


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_SCRATCH0 - Digital Control Scratch Register 0
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  PTR;
    } B;
} hw_digctl_scratch0_t;
#endif


//
// constants & macros for entire HW_DIGCTL_SCRATCH0 register
//

#define HW_DIGCTL_SCRATCH0_ADDR      (REGS_DIGCTL_BASE + 0x00000290)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_SCRATCH0           (*(volatile hw_digctl_scratch0_t *) HW_DIGCTL_SCRATCH0_ADDR)
#define HW_DIGCTL_SCRATCH0_RD()      (HW_DIGCTL_SCRATCH0.U)
#define HW_DIGCTL_SCRATCH0_WR(v)     (HW_DIGCTL_SCRATCH0.U = (v))
#define HW_DIGCTL_SCRATCH0_SET(v)    (HW_DIGCTL_SCRATCH0_WR(HW_DIGCTL_SCRATCH0_RD() |  (v)))
#define HW_DIGCTL_SCRATCH0_CLR(v)    (HW_DIGCTL_SCRATCH0_WR(HW_DIGCTL_SCRATCH0_RD() & ~(v)))
#define HW_DIGCTL_SCRATCH0_TOG(v)    (HW_DIGCTL_SCRATCH0_WR(HW_DIGCTL_SCRATCH0_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DIGCTL_SCRATCH0 bitfields
//

//--- Register HW_DIGCTL_SCRATCH0, field PTR

#define BP_DIGCTL_SCRATCH0_PTR      0
#define BM_DIGCTL_SCRATCH0_PTR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_SCRATCH0_PTR(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_SCRATCH0_PTR(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_SCRATCH0_PTR(v)   (HW_DIGCTL_SCRATCH0.B.PTR = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_SCRATCH1 - Digital Control Scratch Register 1
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  PTR;
    } B;
} hw_digctl_scratch1_t;
#endif


//
// constants & macros for entire HW_DIGCTL_SCRATCH1 register
//

#define HW_DIGCTL_SCRATCH1_ADDR      (REGS_DIGCTL_BASE + 0x000002A0)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_SCRATCH1           (*(volatile hw_digctl_scratch1_t *) HW_DIGCTL_SCRATCH1_ADDR)
#define HW_DIGCTL_SCRATCH1_RD()      (HW_DIGCTL_SCRATCH1.U)
#define HW_DIGCTL_SCRATCH1_WR(v)     (HW_DIGCTL_SCRATCH1.U = (v))
#define HW_DIGCTL_SCRATCH1_SET(v)    (HW_DIGCTL_SCRATCH1_WR(HW_DIGCTL_SCRATCH1_RD() |  (v)))
#define HW_DIGCTL_SCRATCH1_CLR(v)    (HW_DIGCTL_SCRATCH1_WR(HW_DIGCTL_SCRATCH1_RD() & ~(v)))
#define HW_DIGCTL_SCRATCH1_TOG(v)    (HW_DIGCTL_SCRATCH1_WR(HW_DIGCTL_SCRATCH1_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DIGCTL_SCRATCH1 bitfields
//

//--- Register HW_DIGCTL_SCRATCH1, field PTR

#define BP_DIGCTL_SCRATCH1_PTR      0
#define BM_DIGCTL_SCRATCH1_PTR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_SCRATCH1_PTR(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_SCRATCH1_PTR(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_SCRATCH1_PTR(v)   (HW_DIGCTL_SCRATCH1.B.PTR = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_ARMCACHE - Digital Control ARM Cache Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ITAG_SS   :  2;
        unsigned RSVD0     :  2;
        unsigned DTAG_SS   :  2;
        unsigned RSVD1     :  2;
        unsigned CACHE_SS  :  2;
        unsigned RSVD2     :  2;
        unsigned DRTY_SS   :  2;
        unsigned RSVD3     :  2;
        unsigned VALID_SS  :  2;
        unsigned RSVD4     : 14;
    } B;
} hw_digctl_armcache_t;
#endif


//
// constants & macros for entire HW_DIGCTL_ARMCACHE register
//

#define HW_DIGCTL_ARMCACHE_ADDR      (REGS_DIGCTL_BASE + 0x000002B0)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_ARMCACHE           (*(volatile hw_digctl_armcache_t *) HW_DIGCTL_ARMCACHE_ADDR)
#define HW_DIGCTL_ARMCACHE_RD()      (HW_DIGCTL_ARMCACHE.U)
#define HW_DIGCTL_ARMCACHE_WR(v)     (HW_DIGCTL_ARMCACHE.U = (v))
#define HW_DIGCTL_ARMCACHE_SET(v)    (HW_DIGCTL_ARMCACHE_WR(HW_DIGCTL_ARMCACHE_RD() |  (v)))
#define HW_DIGCTL_ARMCACHE_CLR(v)    (HW_DIGCTL_ARMCACHE_WR(HW_DIGCTL_ARMCACHE_RD() & ~(v)))
#define HW_DIGCTL_ARMCACHE_TOG(v)    (HW_DIGCTL_ARMCACHE_WR(HW_DIGCTL_ARMCACHE_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DIGCTL_ARMCACHE bitfields
//

//--- Register HW_DIGCTL_ARMCACHE, field VALID_SS

#define BP_DIGCTL_ARMCACHE_VALID_SS      16
#define BM_DIGCTL_ARMCACHE_VALID_SS      0x00030000

#define BF_DIGCTL_ARMCACHE_VALID_SS(v)   (((v) << 16) & BM_DIGCTL_ARMCACHE_VALID_SS)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_ARMCACHE_VALID_SS(v)   BF_CS1(DIGCTL_ARMCACHE, VALID_SS, v)
#endif

//--- Register HW_DIGCTL_ARMCACHE, field DRTY_SS

#define BP_DIGCTL_ARMCACHE_DRTY_SS      12
#define BM_DIGCTL_ARMCACHE_DRTY_SS      0x00003000

#define BF_DIGCTL_ARMCACHE_DRTY_SS(v)   (((v) << 12) & BM_DIGCTL_ARMCACHE_DRTY_SS)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_ARMCACHE_DRTY_SS(v)   BF_CS1(DIGCTL_ARMCACHE, DRTY_SS, v)
#endif

//--- Register HW_DIGCTL_ARMCACHE, field CACHE_SS

#define BP_DIGCTL_ARMCACHE_CACHE_SS      8
#define BM_DIGCTL_ARMCACHE_CACHE_SS      0x00000300

#define BF_DIGCTL_ARMCACHE_CACHE_SS(v)   (((v) << 8) & BM_DIGCTL_ARMCACHE_CACHE_SS)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_ARMCACHE_CACHE_SS(v)   BF_CS1(DIGCTL_ARMCACHE, CACHE_SS, v)
#endif

//--- Register HW_DIGCTL_ARMCACHE, field DTAG_SS

#define BP_DIGCTL_ARMCACHE_DTAG_SS      4
#define BM_DIGCTL_ARMCACHE_DTAG_SS      0x00000030

#define BF_DIGCTL_ARMCACHE_DTAG_SS(v)   (((v) << 4) & BM_DIGCTL_ARMCACHE_DTAG_SS)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_ARMCACHE_DTAG_SS(v)   BF_CS1(DIGCTL_ARMCACHE, DTAG_SS, v)
#endif

//--- Register HW_DIGCTL_ARMCACHE, field ITAG_SS

#define BP_DIGCTL_ARMCACHE_ITAG_SS      0
#define BM_DIGCTL_ARMCACHE_ITAG_SS      0x00000003

#define BF_DIGCTL_ARMCACHE_ITAG_SS(v)   (((v) << 0) & BM_DIGCTL_ARMCACHE_ITAG_SS)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_ARMCACHE_ITAG_SS(v)   BF_CS1(DIGCTL_ARMCACHE, ITAG_SS, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_DEBUG_TRAP_ADDR_LOW - Debug Trap Range Low Address
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  ADDR;
    } B;
} hw_digctl_debug_trap_addr_low_t;
#endif


//
// constants & macros for entire HW_DIGCTL_DEBUG_TRAP_ADDR_LOW register
//

#define HW_DIGCTL_DEBUG_TRAP_ADDR_LOW_ADDR      (REGS_DIGCTL_BASE + 0x000002C0)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_DEBUG_TRAP_ADDR_LOW           (*(volatile hw_digctl_debug_trap_addr_low_t *) HW_DIGCTL_DEBUG_TRAP_ADDR_LOW_ADDR)
#define HW_DIGCTL_DEBUG_TRAP_ADDR_LOW_RD()      (HW_DIGCTL_DEBUG_TRAP_ADDR_LOW.U)
#define HW_DIGCTL_DEBUG_TRAP_ADDR_LOW_WR(v)     (HW_DIGCTL_DEBUG_TRAP_ADDR_LOW.U = (v))
#define HW_DIGCTL_DEBUG_TRAP_ADDR_LOW_SET(v)    (HW_DIGCTL_DEBUG_TRAP_ADDR_LOW_WR(HW_DIGCTL_DEBUG_TRAP_ADDR_LOW_RD() |  (v)))
#define HW_DIGCTL_DEBUG_TRAP_ADDR_LOW_CLR(v)    (HW_DIGCTL_DEBUG_TRAP_ADDR_LOW_WR(HW_DIGCTL_DEBUG_TRAP_ADDR_LOW_RD() & ~(v)))
#define HW_DIGCTL_DEBUG_TRAP_ADDR_LOW_TOG(v)    (HW_DIGCTL_DEBUG_TRAP_ADDR_LOW_WR(HW_DIGCTL_DEBUG_TRAP_ADDR_LOW_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DIGCTL_DEBUG_TRAP_ADDR_LOW bitfields
//

//--- Register HW_DIGCTL_DEBUG_TRAP_ADDR_LOW, field ADDR

#define BP_DIGCTL_DEBUG_TRAP_ADDR_LOW_ADDR      0
#define BM_DIGCTL_DEBUG_TRAP_ADDR_LOW_ADDR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_DEBUG_TRAP_ADDR_LOW_ADDR(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_DEBUG_TRAP_ADDR_LOW_ADDR(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_DEBUG_TRAP_ADDR_LOW_ADDR(v)   (HW_DIGCTL_DEBUG_TRAP_ADDR_LOW.B.ADDR = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_DEBUG_TRAP_ADDR_HIGH - Debug Trap Range High Address
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  ADDR;
    } B;
} hw_digctl_debug_trap_addr_high_t;
#endif


//
// constants & macros for entire HW_DIGCTL_DEBUG_TRAP_ADDR_HIGH register
//

#define HW_DIGCTL_DEBUG_TRAP_ADDR_HIGH_ADDR      (REGS_DIGCTL_BASE + 0x000002D0)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_DEBUG_TRAP_ADDR_HIGH           (*(volatile hw_digctl_debug_trap_addr_high_t *) HW_DIGCTL_DEBUG_TRAP_ADDR_HIGH_ADDR)
#define HW_DIGCTL_DEBUG_TRAP_ADDR_HIGH_RD()      (HW_DIGCTL_DEBUG_TRAP_ADDR_HIGH.U)
#define HW_DIGCTL_DEBUG_TRAP_ADDR_HIGH_WR(v)     (HW_DIGCTL_DEBUG_TRAP_ADDR_HIGH.U = (v))
#define HW_DIGCTL_DEBUG_TRAP_ADDR_HIGH_SET(v)    (HW_DIGCTL_DEBUG_TRAP_ADDR_HIGH_WR(HW_DIGCTL_DEBUG_TRAP_ADDR_HIGH_RD() |  (v)))
#define HW_DIGCTL_DEBUG_TRAP_ADDR_HIGH_CLR(v)    (HW_DIGCTL_DEBUG_TRAP_ADDR_HIGH_WR(HW_DIGCTL_DEBUG_TRAP_ADDR_HIGH_RD() & ~(v)))
#define HW_DIGCTL_DEBUG_TRAP_ADDR_HIGH_TOG(v)    (HW_DIGCTL_DEBUG_TRAP_ADDR_HIGH_WR(HW_DIGCTL_DEBUG_TRAP_ADDR_HIGH_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DIGCTL_DEBUG_TRAP_ADDR_HIGH bitfields
//

//--- Register HW_DIGCTL_DEBUG_TRAP_ADDR_HIGH, field ADDR

#define BP_DIGCTL_DEBUG_TRAP_ADDR_HIGH_ADDR      0
#define BM_DIGCTL_DEBUG_TRAP_ADDR_HIGH_ADDR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_DEBUG_TRAP_ADDR_HIGH_ADDR(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_DEBUG_TRAP_ADDR_HIGH_ADDR(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_DEBUG_TRAP_ADDR_HIGH_ADDR(v)   (HW_DIGCTL_DEBUG_TRAP_ADDR_HIGH.B.ADDR = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_SGTL - SigmaTel Copyright Identifier Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  COPYRIGHT;
    } B;
} hw_digctl_sgtl_t;
#endif


//
// constants & macros for entire HW_DIGCTL_SGTL register
//

#define HW_DIGCTL_SGTL_ADDR      (REGS_DIGCTL_BASE + 0x00000300)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_SGTL           (*(volatile hw_digctl_sgtl_t *) HW_DIGCTL_SGTL_ADDR)
#define HW_DIGCTL_SGTL_RD()      (HW_DIGCTL_SGTL.U)
#endif


//
// constants & macros for individual HW_DIGCTL_SGTL bitfields
//

//--- Register HW_DIGCTL_SGTL, field COPYRIGHT

#define BP_DIGCTL_SGTL_COPYRIGHT      0
#define BM_DIGCTL_SGTL_COPYRIGHT      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_SGTL_COPYRIGHT(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_SGTL_COPYRIGHT(v)   (v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_CHIPID - Digital Control Chip Revision Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg8_t   REVISION;
        reg8_t   RSVD0;
        reg16_t  PRODUCT_CODE;
    } B;
} hw_digctl_chipid_t;
#endif


//
// constants & macros for entire HW_DIGCTL_CHIPID register
//

#define HW_DIGCTL_CHIPID_ADDR      (REGS_DIGCTL_BASE + 0x00000310)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_CHIPID           (*(volatile hw_digctl_chipid_t *) HW_DIGCTL_CHIPID_ADDR)
#define HW_DIGCTL_CHIPID_RD()      (HW_DIGCTL_CHIPID.U)
#endif


//
// constants & macros for individual HW_DIGCTL_CHIPID bitfields
//

//--- Register HW_DIGCTL_CHIPID, field PRODUCT_CODE

#define BP_DIGCTL_CHIPID_PRODUCT_CODE      16
#define BM_DIGCTL_CHIPID_PRODUCT_CODE      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_CHIPID_PRODUCT_CODE(v)   ((((reg32_t) v) << 16) & BM_DIGCTL_CHIPID_PRODUCT_CODE)
#else
#define BF_DIGCTL_CHIPID_PRODUCT_CODE(v)   (((v) << 16) & BM_DIGCTL_CHIPID_PRODUCT_CODE)
#endif

//--- Register HW_DIGCTL_CHIPID, field REVISION

#define BP_DIGCTL_CHIPID_REVISION      0
#define BM_DIGCTL_CHIPID_REVISION      0x000000FF

#define BF_DIGCTL_CHIPID_REVISION(v)   (((v) << 0) & BM_DIGCTL_CHIPID_REVISION)


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_AHB_STATS_SELECT - AHB Statistics Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned L0_MASTER_SELECT  :  4;
        unsigned RSVD0             :  4;
        unsigned L1_MASTER_SELECT  :  4;
        unsigned RSVD1             :  4;
        unsigned L2_MASTER_SELECT  :  4;
        unsigned RSVD2             :  4;
        unsigned L3_MASTER_SELECT  :  4;
        unsigned RSVD3             :  4;
    } B;
} hw_digctl_ahb_stats_select_t;
#endif


//
// constants & macros for entire HW_DIGCTL_AHB_STATS_SELECT register
//

#define HW_DIGCTL_AHB_STATS_SELECT_ADDR      (REGS_DIGCTL_BASE + 0x00000330)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_AHB_STATS_SELECT           (*(volatile hw_digctl_ahb_stats_select_t *) HW_DIGCTL_AHB_STATS_SELECT_ADDR)
#define HW_DIGCTL_AHB_STATS_SELECT_RD()      (HW_DIGCTL_AHB_STATS_SELECT.U)
#define HW_DIGCTL_AHB_STATS_SELECT_WR(v)     (HW_DIGCTL_AHB_STATS_SELECT.U = (v))
#define HW_DIGCTL_AHB_STATS_SELECT_SET(v)    (HW_DIGCTL_AHB_STATS_SELECT_WR(HW_DIGCTL_AHB_STATS_SELECT_RD() |  (v)))
#define HW_DIGCTL_AHB_STATS_SELECT_CLR(v)    (HW_DIGCTL_AHB_STATS_SELECT_WR(HW_DIGCTL_AHB_STATS_SELECT_RD() & ~(v)))
#define HW_DIGCTL_AHB_STATS_SELECT_TOG(v)    (HW_DIGCTL_AHB_STATS_SELECT_WR(HW_DIGCTL_AHB_STATS_SELECT_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DIGCTL_AHB_STATS_SELECT bitfields
//

//--- Register HW_DIGCTL_AHB_STATS_SELECT, field L3_MASTER_SELECT

#define BP_DIGCTL_AHB_STATS_SELECT_L3_MASTER_SELECT      24
#define BM_DIGCTL_AHB_STATS_SELECT_L3_MASTER_SELECT      0x0F000000

#define BF_DIGCTL_AHB_STATS_SELECT_L3_MASTER_SELECT(v)   (((v) << 24) & BM_DIGCTL_AHB_STATS_SELECT_L3_MASTER_SELECT)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_AHB_STATS_SELECT_L3_MASTER_SELECT(v)   BF_CS1(DIGCTL_AHB_STATS_SELECT, L3_MASTER_SELECT, v)
#endif

#define BV_DIGCTL_AHB_STATS_SELECT_L3_MASTER_SELECT__APBH  0x1
#define BV_DIGCTL_AHB_STATS_SELECT_L3_MASTER_SELECT__APBX  0x2
#define BV_DIGCTL_AHB_STATS_SELECT_L3_MASTER_SELECT__USB   0x4

//--- Register HW_DIGCTL_AHB_STATS_SELECT, field L2_MASTER_SELECT

#define BP_DIGCTL_AHB_STATS_SELECT_L2_MASTER_SELECT      16
#define BM_DIGCTL_AHB_STATS_SELECT_L2_MASTER_SELECT      0x000F0000

#define BF_DIGCTL_AHB_STATS_SELECT_L2_MASTER_SELECT(v)   (((v) << 16) & BM_DIGCTL_AHB_STATS_SELECT_L2_MASTER_SELECT)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_AHB_STATS_SELECT_L2_MASTER_SELECT(v)   BF_CS1(DIGCTL_AHB_STATS_SELECT, L2_MASTER_SELECT, v)
#endif

#define BV_DIGCTL_AHB_STATS_SELECT_L2_MASTER_SELECT__ARM_D  0x1

//--- Register HW_DIGCTL_AHB_STATS_SELECT, field L1_MASTER_SELECT

#define BP_DIGCTL_AHB_STATS_SELECT_L1_MASTER_SELECT      8
#define BM_DIGCTL_AHB_STATS_SELECT_L1_MASTER_SELECT      0x00000F00

#define BF_DIGCTL_AHB_STATS_SELECT_L1_MASTER_SELECT(v)   (((v) << 8) & BM_DIGCTL_AHB_STATS_SELECT_L1_MASTER_SELECT)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_AHB_STATS_SELECT_L1_MASTER_SELECT(v)   BF_CS1(DIGCTL_AHB_STATS_SELECT, L1_MASTER_SELECT, v)
#endif

#define BV_DIGCTL_AHB_STATS_SELECT_L1_MASTER_SELECT__ARM_I  0x1

//--- Register HW_DIGCTL_AHB_STATS_SELECT, field L0_MASTER_SELECT

#define BP_DIGCTL_AHB_STATS_SELECT_L0_MASTER_SELECT      0
#define BM_DIGCTL_AHB_STATS_SELECT_L0_MASTER_SELECT      0x0000000F

#define BF_DIGCTL_AHB_STATS_SELECT_L0_MASTER_SELECT(v)   (((v) << 0) & BM_DIGCTL_AHB_STATS_SELECT_L0_MASTER_SELECT)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_AHB_STATS_SELECT_L0_MASTER_SELECT(v)   BF_CS1(DIGCTL_AHB_STATS_SELECT, L0_MASTER_SELECT, v)
#endif

#define BV_DIGCTL_AHB_STATS_SELECT_L0_MASTER_SELECT__ECC8    0x1
#define BV_DIGCTL_AHB_STATS_SELECT_L0_MASTER_SELECT__CRYPTO  0x2


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_L0_AHB_ACTIVE_CYCLES - AHB Layer 0 Transfer Count Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  COUNT;
    } B;
} hw_digctl_l0_ahb_active_cycles_t;
#endif


//
// constants & macros for entire HW_DIGCTL_L0_AHB_ACTIVE_CYCLES register
//

#define HW_DIGCTL_L0_AHB_ACTIVE_CYCLES_ADDR      (REGS_DIGCTL_BASE + 0x00000340)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_L0_AHB_ACTIVE_CYCLES           (*(volatile hw_digctl_l0_ahb_active_cycles_t *) HW_DIGCTL_L0_AHB_ACTIVE_CYCLES_ADDR)
#define HW_DIGCTL_L0_AHB_ACTIVE_CYCLES_RD()      (HW_DIGCTL_L0_AHB_ACTIVE_CYCLES.U)
#define HW_DIGCTL_L0_AHB_ACTIVE_CYCLES_WR(v)     (HW_DIGCTL_L0_AHB_ACTIVE_CYCLES.U = (v))
#define HW_DIGCTL_L0_AHB_ACTIVE_CYCLES_SET(v)    (HW_DIGCTL_L0_AHB_ACTIVE_CYCLES_WR(HW_DIGCTL_L0_AHB_ACTIVE_CYCLES_RD() |  (v)))
#define HW_DIGCTL_L0_AHB_ACTIVE_CYCLES_CLR(v)    (HW_DIGCTL_L0_AHB_ACTIVE_CYCLES_WR(HW_DIGCTL_L0_AHB_ACTIVE_CYCLES_RD() & ~(v)))
#define HW_DIGCTL_L0_AHB_ACTIVE_CYCLES_TOG(v)    (HW_DIGCTL_L0_AHB_ACTIVE_CYCLES_WR(HW_DIGCTL_L0_AHB_ACTIVE_CYCLES_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DIGCTL_L0_AHB_ACTIVE_CYCLES bitfields
//

//--- Register HW_DIGCTL_L0_AHB_ACTIVE_CYCLES, field COUNT

#define BP_DIGCTL_L0_AHB_ACTIVE_CYCLES_COUNT      0
#define BM_DIGCTL_L0_AHB_ACTIVE_CYCLES_COUNT      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_L0_AHB_ACTIVE_CYCLES_COUNT(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_L0_AHB_ACTIVE_CYCLES_COUNT(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_L0_AHB_ACTIVE_CYCLES_COUNT(v)   (HW_DIGCTL_L0_AHB_ACTIVE_CYCLES.B.COUNT = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_L0_AHB_DATA_STALLED - AHB Layer 0 Performance Metric for Stalled Bus Cycles Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  COUNT;
    } B;
} hw_digctl_l0_ahb_data_stalled_t;
#endif


//
// constants & macros for entire HW_DIGCTL_L0_AHB_DATA_STALLED register
//

#define HW_DIGCTL_L0_AHB_DATA_STALLED_ADDR      (REGS_DIGCTL_BASE + 0x00000350)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_L0_AHB_DATA_STALLED           (*(volatile hw_digctl_l0_ahb_data_stalled_t *) HW_DIGCTL_L0_AHB_DATA_STALLED_ADDR)
#define HW_DIGCTL_L0_AHB_DATA_STALLED_RD()      (HW_DIGCTL_L0_AHB_DATA_STALLED.U)
#define HW_DIGCTL_L0_AHB_DATA_STALLED_WR(v)     (HW_DIGCTL_L0_AHB_DATA_STALLED.U = (v))
#define HW_DIGCTL_L0_AHB_DATA_STALLED_SET(v)    (HW_DIGCTL_L0_AHB_DATA_STALLED_WR(HW_DIGCTL_L0_AHB_DATA_STALLED_RD() |  (v)))
#define HW_DIGCTL_L0_AHB_DATA_STALLED_CLR(v)    (HW_DIGCTL_L0_AHB_DATA_STALLED_WR(HW_DIGCTL_L0_AHB_DATA_STALLED_RD() & ~(v)))
#define HW_DIGCTL_L0_AHB_DATA_STALLED_TOG(v)    (HW_DIGCTL_L0_AHB_DATA_STALLED_WR(HW_DIGCTL_L0_AHB_DATA_STALLED_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DIGCTL_L0_AHB_DATA_STALLED bitfields
//

//--- Register HW_DIGCTL_L0_AHB_DATA_STALLED, field COUNT

#define BP_DIGCTL_L0_AHB_DATA_STALLED_COUNT      0
#define BM_DIGCTL_L0_AHB_DATA_STALLED_COUNT      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_L0_AHB_DATA_STALLED_COUNT(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_L0_AHB_DATA_STALLED_COUNT(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_L0_AHB_DATA_STALLED_COUNT(v)   (HW_DIGCTL_L0_AHB_DATA_STALLED.B.COUNT = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_L0_AHB_DATA_CYCLES - AHB Layer 0 Performance Metric for Valid Bus Cycles Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  COUNT;
    } B;
} hw_digctl_l0_ahb_data_cycles_t;
#endif


//
// constants & macros for entire HW_DIGCTL_L0_AHB_DATA_CYCLES register
//

#define HW_DIGCTL_L0_AHB_DATA_CYCLES_ADDR      (REGS_DIGCTL_BASE + 0x00000360)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_L0_AHB_DATA_CYCLES           (*(volatile hw_digctl_l0_ahb_data_cycles_t *) HW_DIGCTL_L0_AHB_DATA_CYCLES_ADDR)
#define HW_DIGCTL_L0_AHB_DATA_CYCLES_RD()      (HW_DIGCTL_L0_AHB_DATA_CYCLES.U)
#define HW_DIGCTL_L0_AHB_DATA_CYCLES_WR(v)     (HW_DIGCTL_L0_AHB_DATA_CYCLES.U = (v))
#define HW_DIGCTL_L0_AHB_DATA_CYCLES_SET(v)    (HW_DIGCTL_L0_AHB_DATA_CYCLES_WR(HW_DIGCTL_L0_AHB_DATA_CYCLES_RD() |  (v)))
#define HW_DIGCTL_L0_AHB_DATA_CYCLES_CLR(v)    (HW_DIGCTL_L0_AHB_DATA_CYCLES_WR(HW_DIGCTL_L0_AHB_DATA_CYCLES_RD() & ~(v)))
#define HW_DIGCTL_L0_AHB_DATA_CYCLES_TOG(v)    (HW_DIGCTL_L0_AHB_DATA_CYCLES_WR(HW_DIGCTL_L0_AHB_DATA_CYCLES_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DIGCTL_L0_AHB_DATA_CYCLES bitfields
//

//--- Register HW_DIGCTL_L0_AHB_DATA_CYCLES, field COUNT

#define BP_DIGCTL_L0_AHB_DATA_CYCLES_COUNT      0
#define BM_DIGCTL_L0_AHB_DATA_CYCLES_COUNT      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_L0_AHB_DATA_CYCLES_COUNT(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_L0_AHB_DATA_CYCLES_COUNT(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_L0_AHB_DATA_CYCLES_COUNT(v)   (HW_DIGCTL_L0_AHB_DATA_CYCLES.B.COUNT = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_L1_AHB_ACTIVE_CYCLES - AHB Layer 1 Transfer Count Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  COUNT;
    } B;
} hw_digctl_l1_ahb_active_cycles_t;
#endif


//
// constants & macros for entire HW_DIGCTL_L1_AHB_ACTIVE_CYCLES register
//

#define HW_DIGCTL_L1_AHB_ACTIVE_CYCLES_ADDR      (REGS_DIGCTL_BASE + 0x00000370)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_L1_AHB_ACTIVE_CYCLES           (*(volatile hw_digctl_l1_ahb_active_cycles_t *) HW_DIGCTL_L1_AHB_ACTIVE_CYCLES_ADDR)
#define HW_DIGCTL_L1_AHB_ACTIVE_CYCLES_RD()      (HW_DIGCTL_L1_AHB_ACTIVE_CYCLES.U)
#define HW_DIGCTL_L1_AHB_ACTIVE_CYCLES_WR(v)     (HW_DIGCTL_L1_AHB_ACTIVE_CYCLES.U = (v))
#define HW_DIGCTL_L1_AHB_ACTIVE_CYCLES_SET(v)    (HW_DIGCTL_L1_AHB_ACTIVE_CYCLES_WR(HW_DIGCTL_L1_AHB_ACTIVE_CYCLES_RD() |  (v)))
#define HW_DIGCTL_L1_AHB_ACTIVE_CYCLES_CLR(v)    (HW_DIGCTL_L1_AHB_ACTIVE_CYCLES_WR(HW_DIGCTL_L1_AHB_ACTIVE_CYCLES_RD() & ~(v)))
#define HW_DIGCTL_L1_AHB_ACTIVE_CYCLES_TOG(v)    (HW_DIGCTL_L1_AHB_ACTIVE_CYCLES_WR(HW_DIGCTL_L1_AHB_ACTIVE_CYCLES_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DIGCTL_L1_AHB_ACTIVE_CYCLES bitfields
//

//--- Register HW_DIGCTL_L1_AHB_ACTIVE_CYCLES, field COUNT

#define BP_DIGCTL_L1_AHB_ACTIVE_CYCLES_COUNT      0
#define BM_DIGCTL_L1_AHB_ACTIVE_CYCLES_COUNT      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_L1_AHB_ACTIVE_CYCLES_COUNT(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_L1_AHB_ACTIVE_CYCLES_COUNT(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_L1_AHB_ACTIVE_CYCLES_COUNT(v)   (HW_DIGCTL_L1_AHB_ACTIVE_CYCLES.B.COUNT = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_L1_AHB_DATA_STALLED - AHB Layer 1 Performance Metric for Stalled Bus Cycles Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  COUNT;
    } B;
} hw_digctl_l1_ahb_data_stalled_t;
#endif


//
// constants & macros for entire HW_DIGCTL_L1_AHB_DATA_STALLED register
//

#define HW_DIGCTL_L1_AHB_DATA_STALLED_ADDR      (REGS_DIGCTL_BASE + 0x00000380)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_L1_AHB_DATA_STALLED           (*(volatile hw_digctl_l1_ahb_data_stalled_t *) HW_DIGCTL_L1_AHB_DATA_STALLED_ADDR)
#define HW_DIGCTL_L1_AHB_DATA_STALLED_RD()      (HW_DIGCTL_L1_AHB_DATA_STALLED.U)
#define HW_DIGCTL_L1_AHB_DATA_STALLED_WR(v)     (HW_DIGCTL_L1_AHB_DATA_STALLED.U = (v))
#define HW_DIGCTL_L1_AHB_DATA_STALLED_SET(v)    (HW_DIGCTL_L1_AHB_DATA_STALLED_WR(HW_DIGCTL_L1_AHB_DATA_STALLED_RD() |  (v)))
#define HW_DIGCTL_L1_AHB_DATA_STALLED_CLR(v)    (HW_DIGCTL_L1_AHB_DATA_STALLED_WR(HW_DIGCTL_L1_AHB_DATA_STALLED_RD() & ~(v)))
#define HW_DIGCTL_L1_AHB_DATA_STALLED_TOG(v)    (HW_DIGCTL_L1_AHB_DATA_STALLED_WR(HW_DIGCTL_L1_AHB_DATA_STALLED_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DIGCTL_L1_AHB_DATA_STALLED bitfields
//

//--- Register HW_DIGCTL_L1_AHB_DATA_STALLED, field COUNT

#define BP_DIGCTL_L1_AHB_DATA_STALLED_COUNT      0
#define BM_DIGCTL_L1_AHB_DATA_STALLED_COUNT      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_L1_AHB_DATA_STALLED_COUNT(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_L1_AHB_DATA_STALLED_COUNT(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_L1_AHB_DATA_STALLED_COUNT(v)   (HW_DIGCTL_L1_AHB_DATA_STALLED.B.COUNT = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_L1_AHB_DATA_CYCLES - AHB Layer 1 Performance Metric for Valid Bus Cycles Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  COUNT;
    } B;
} hw_digctl_l1_ahb_data_cycles_t;
#endif


//
// constants & macros for entire HW_DIGCTL_L1_AHB_DATA_CYCLES register
//

#define HW_DIGCTL_L1_AHB_DATA_CYCLES_ADDR      (REGS_DIGCTL_BASE + 0x00000390)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_L1_AHB_DATA_CYCLES           (*(volatile hw_digctl_l1_ahb_data_cycles_t *) HW_DIGCTL_L1_AHB_DATA_CYCLES_ADDR)
#define HW_DIGCTL_L1_AHB_DATA_CYCLES_RD()      (HW_DIGCTL_L1_AHB_DATA_CYCLES.U)
#define HW_DIGCTL_L1_AHB_DATA_CYCLES_WR(v)     (HW_DIGCTL_L1_AHB_DATA_CYCLES.U = (v))
#define HW_DIGCTL_L1_AHB_DATA_CYCLES_SET(v)    (HW_DIGCTL_L1_AHB_DATA_CYCLES_WR(HW_DIGCTL_L1_AHB_DATA_CYCLES_RD() |  (v)))
#define HW_DIGCTL_L1_AHB_DATA_CYCLES_CLR(v)    (HW_DIGCTL_L1_AHB_DATA_CYCLES_WR(HW_DIGCTL_L1_AHB_DATA_CYCLES_RD() & ~(v)))
#define HW_DIGCTL_L1_AHB_DATA_CYCLES_TOG(v)    (HW_DIGCTL_L1_AHB_DATA_CYCLES_WR(HW_DIGCTL_L1_AHB_DATA_CYCLES_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DIGCTL_L1_AHB_DATA_CYCLES bitfields
//

//--- Register HW_DIGCTL_L1_AHB_DATA_CYCLES, field COUNT

#define BP_DIGCTL_L1_AHB_DATA_CYCLES_COUNT      0
#define BM_DIGCTL_L1_AHB_DATA_CYCLES_COUNT      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_L1_AHB_DATA_CYCLES_COUNT(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_L1_AHB_DATA_CYCLES_COUNT(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_L1_AHB_DATA_CYCLES_COUNT(v)   (HW_DIGCTL_L1_AHB_DATA_CYCLES.B.COUNT = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_L2_AHB_ACTIVE_CYCLES - AHB Layer 2 Transfer Count Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  COUNT;
    } B;
} hw_digctl_l2_ahb_active_cycles_t;
#endif


//
// constants & macros for entire HW_DIGCTL_L2_AHB_ACTIVE_CYCLES register
//

#define HW_DIGCTL_L2_AHB_ACTIVE_CYCLES_ADDR      (REGS_DIGCTL_BASE + 0x000003A0)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_L2_AHB_ACTIVE_CYCLES           (*(volatile hw_digctl_l2_ahb_active_cycles_t *) HW_DIGCTL_L2_AHB_ACTIVE_CYCLES_ADDR)
#define HW_DIGCTL_L2_AHB_ACTIVE_CYCLES_RD()      (HW_DIGCTL_L2_AHB_ACTIVE_CYCLES.U)
#define HW_DIGCTL_L2_AHB_ACTIVE_CYCLES_WR(v)     (HW_DIGCTL_L2_AHB_ACTIVE_CYCLES.U = (v))
#define HW_DIGCTL_L2_AHB_ACTIVE_CYCLES_SET(v)    (HW_DIGCTL_L2_AHB_ACTIVE_CYCLES_WR(HW_DIGCTL_L2_AHB_ACTIVE_CYCLES_RD() |  (v)))
#define HW_DIGCTL_L2_AHB_ACTIVE_CYCLES_CLR(v)    (HW_DIGCTL_L2_AHB_ACTIVE_CYCLES_WR(HW_DIGCTL_L2_AHB_ACTIVE_CYCLES_RD() & ~(v)))
#define HW_DIGCTL_L2_AHB_ACTIVE_CYCLES_TOG(v)    (HW_DIGCTL_L2_AHB_ACTIVE_CYCLES_WR(HW_DIGCTL_L2_AHB_ACTIVE_CYCLES_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DIGCTL_L2_AHB_ACTIVE_CYCLES bitfields
//

//--- Register HW_DIGCTL_L2_AHB_ACTIVE_CYCLES, field COUNT

#define BP_DIGCTL_L2_AHB_ACTIVE_CYCLES_COUNT      0
#define BM_DIGCTL_L2_AHB_ACTIVE_CYCLES_COUNT      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_L2_AHB_ACTIVE_CYCLES_COUNT(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_L2_AHB_ACTIVE_CYCLES_COUNT(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_L2_AHB_ACTIVE_CYCLES_COUNT(v)   (HW_DIGCTL_L2_AHB_ACTIVE_CYCLES.B.COUNT = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_L2_AHB_DATA_STALLED - AHB Layer 2 Performance Metric for Stalled Bus Cycles Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  COUNT;
    } B;
} hw_digctl_l2_ahb_data_stalled_t;
#endif


//
// constants & macros for entire HW_DIGCTL_L2_AHB_DATA_STALLED register
//

#define HW_DIGCTL_L2_AHB_DATA_STALLED_ADDR      (REGS_DIGCTL_BASE + 0x000003B0)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_L2_AHB_DATA_STALLED           (*(volatile hw_digctl_l2_ahb_data_stalled_t *) HW_DIGCTL_L2_AHB_DATA_STALLED_ADDR)
#define HW_DIGCTL_L2_AHB_DATA_STALLED_RD()      (HW_DIGCTL_L2_AHB_DATA_STALLED.U)
#define HW_DIGCTL_L2_AHB_DATA_STALLED_WR(v)     (HW_DIGCTL_L2_AHB_DATA_STALLED.U = (v))
#define HW_DIGCTL_L2_AHB_DATA_STALLED_SET(v)    (HW_DIGCTL_L2_AHB_DATA_STALLED_WR(HW_DIGCTL_L2_AHB_DATA_STALLED_RD() |  (v)))
#define HW_DIGCTL_L2_AHB_DATA_STALLED_CLR(v)    (HW_DIGCTL_L2_AHB_DATA_STALLED_WR(HW_DIGCTL_L2_AHB_DATA_STALLED_RD() & ~(v)))
#define HW_DIGCTL_L2_AHB_DATA_STALLED_TOG(v)    (HW_DIGCTL_L2_AHB_DATA_STALLED_WR(HW_DIGCTL_L2_AHB_DATA_STALLED_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DIGCTL_L2_AHB_DATA_STALLED bitfields
//

//--- Register HW_DIGCTL_L2_AHB_DATA_STALLED, field COUNT

#define BP_DIGCTL_L2_AHB_DATA_STALLED_COUNT      0
#define BM_DIGCTL_L2_AHB_DATA_STALLED_COUNT      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_L2_AHB_DATA_STALLED_COUNT(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_L2_AHB_DATA_STALLED_COUNT(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_L2_AHB_DATA_STALLED_COUNT(v)   (HW_DIGCTL_L2_AHB_DATA_STALLED.B.COUNT = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_L2_AHB_DATA_CYCLES - AHB Layer 2 Performance Metric for Valid Bus Cycles Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  COUNT;
    } B;
} hw_digctl_l2_ahb_data_cycles_t;
#endif


//
// constants & macros for entire HW_DIGCTL_L2_AHB_DATA_CYCLES register
//

#define HW_DIGCTL_L2_AHB_DATA_CYCLES_ADDR      (REGS_DIGCTL_BASE + 0x000003C0)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_L2_AHB_DATA_CYCLES           (*(volatile hw_digctl_l2_ahb_data_cycles_t *) HW_DIGCTL_L2_AHB_DATA_CYCLES_ADDR)
#define HW_DIGCTL_L2_AHB_DATA_CYCLES_RD()      (HW_DIGCTL_L2_AHB_DATA_CYCLES.U)
#define HW_DIGCTL_L2_AHB_DATA_CYCLES_WR(v)     (HW_DIGCTL_L2_AHB_DATA_CYCLES.U = (v))
#define HW_DIGCTL_L2_AHB_DATA_CYCLES_SET(v)    (HW_DIGCTL_L2_AHB_DATA_CYCLES_WR(HW_DIGCTL_L2_AHB_DATA_CYCLES_RD() |  (v)))
#define HW_DIGCTL_L2_AHB_DATA_CYCLES_CLR(v)    (HW_DIGCTL_L2_AHB_DATA_CYCLES_WR(HW_DIGCTL_L2_AHB_DATA_CYCLES_RD() & ~(v)))
#define HW_DIGCTL_L2_AHB_DATA_CYCLES_TOG(v)    (HW_DIGCTL_L2_AHB_DATA_CYCLES_WR(HW_DIGCTL_L2_AHB_DATA_CYCLES_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DIGCTL_L2_AHB_DATA_CYCLES bitfields
//

//--- Register HW_DIGCTL_L2_AHB_DATA_CYCLES, field COUNT

#define BP_DIGCTL_L2_AHB_DATA_CYCLES_COUNT      0
#define BM_DIGCTL_L2_AHB_DATA_CYCLES_COUNT      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_L2_AHB_DATA_CYCLES_COUNT(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_L2_AHB_DATA_CYCLES_COUNT(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_L2_AHB_DATA_CYCLES_COUNT(v)   (HW_DIGCTL_L2_AHB_DATA_CYCLES.B.COUNT = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_L3_AHB_ACTIVE_CYCLES - AHB Layer 3 Transfer Count Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  COUNT;
    } B;
} hw_digctl_l3_ahb_active_cycles_t;
#endif


//
// constants & macros for entire HW_DIGCTL_L3_AHB_ACTIVE_CYCLES register
//

#define HW_DIGCTL_L3_AHB_ACTIVE_CYCLES_ADDR      (REGS_DIGCTL_BASE + 0x000003D0)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_L3_AHB_ACTIVE_CYCLES           (*(volatile hw_digctl_l3_ahb_active_cycles_t *) HW_DIGCTL_L3_AHB_ACTIVE_CYCLES_ADDR)
#define HW_DIGCTL_L3_AHB_ACTIVE_CYCLES_RD()      (HW_DIGCTL_L3_AHB_ACTIVE_CYCLES.U)
#define HW_DIGCTL_L3_AHB_ACTIVE_CYCLES_WR(v)     (HW_DIGCTL_L3_AHB_ACTIVE_CYCLES.U = (v))
#define HW_DIGCTL_L3_AHB_ACTIVE_CYCLES_SET(v)    (HW_DIGCTL_L3_AHB_ACTIVE_CYCLES_WR(HW_DIGCTL_L3_AHB_ACTIVE_CYCLES_RD() |  (v)))
#define HW_DIGCTL_L3_AHB_ACTIVE_CYCLES_CLR(v)    (HW_DIGCTL_L3_AHB_ACTIVE_CYCLES_WR(HW_DIGCTL_L3_AHB_ACTIVE_CYCLES_RD() & ~(v)))
#define HW_DIGCTL_L3_AHB_ACTIVE_CYCLES_TOG(v)    (HW_DIGCTL_L3_AHB_ACTIVE_CYCLES_WR(HW_DIGCTL_L3_AHB_ACTIVE_CYCLES_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DIGCTL_L3_AHB_ACTIVE_CYCLES bitfields
//

//--- Register HW_DIGCTL_L3_AHB_ACTIVE_CYCLES, field COUNT

#define BP_DIGCTL_L3_AHB_ACTIVE_CYCLES_COUNT      0
#define BM_DIGCTL_L3_AHB_ACTIVE_CYCLES_COUNT      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_L3_AHB_ACTIVE_CYCLES_COUNT(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_L3_AHB_ACTIVE_CYCLES_COUNT(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_L3_AHB_ACTIVE_CYCLES_COUNT(v)   (HW_DIGCTL_L3_AHB_ACTIVE_CYCLES.B.COUNT = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_L3_AHB_DATA_STALLED - AHB Layer 3 Performance Metric for Stalled Bus Cycles Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  COUNT;
    } B;
} hw_digctl_l3_ahb_data_stalled_t;
#endif


//
// constants & macros for entire HW_DIGCTL_L3_AHB_DATA_STALLED register
//

#define HW_DIGCTL_L3_AHB_DATA_STALLED_ADDR      (REGS_DIGCTL_BASE + 0x000003E0)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_L3_AHB_DATA_STALLED           (*(volatile hw_digctl_l3_ahb_data_stalled_t *) HW_DIGCTL_L3_AHB_DATA_STALLED_ADDR)
#define HW_DIGCTL_L3_AHB_DATA_STALLED_RD()      (HW_DIGCTL_L3_AHB_DATA_STALLED.U)
#define HW_DIGCTL_L3_AHB_DATA_STALLED_WR(v)     (HW_DIGCTL_L3_AHB_DATA_STALLED.U = (v))
#define HW_DIGCTL_L3_AHB_DATA_STALLED_SET(v)    (HW_DIGCTL_L3_AHB_DATA_STALLED_WR(HW_DIGCTL_L3_AHB_DATA_STALLED_RD() |  (v)))
#define HW_DIGCTL_L3_AHB_DATA_STALLED_CLR(v)    (HW_DIGCTL_L3_AHB_DATA_STALLED_WR(HW_DIGCTL_L3_AHB_DATA_STALLED_RD() & ~(v)))
#define HW_DIGCTL_L3_AHB_DATA_STALLED_TOG(v)    (HW_DIGCTL_L3_AHB_DATA_STALLED_WR(HW_DIGCTL_L3_AHB_DATA_STALLED_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DIGCTL_L3_AHB_DATA_STALLED bitfields
//

//--- Register HW_DIGCTL_L3_AHB_DATA_STALLED, field COUNT

#define BP_DIGCTL_L3_AHB_DATA_STALLED_COUNT      0
#define BM_DIGCTL_L3_AHB_DATA_STALLED_COUNT      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_L3_AHB_DATA_STALLED_COUNT(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_L3_AHB_DATA_STALLED_COUNT(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_L3_AHB_DATA_STALLED_COUNT(v)   (HW_DIGCTL_L3_AHB_DATA_STALLED.B.COUNT = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_L3_AHB_DATA_CYCLES - AHB Layer 3 Performance Metric for Valid Bus Cycles Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  COUNT;
    } B;
} hw_digctl_l3_ahb_data_cycles_t;
#endif


//
// constants & macros for entire HW_DIGCTL_L3_AHB_DATA_CYCLES register
//

#define HW_DIGCTL_L3_AHB_DATA_CYCLES_ADDR      (REGS_DIGCTL_BASE + 0x000003F0)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_L3_AHB_DATA_CYCLES           (*(volatile hw_digctl_l3_ahb_data_cycles_t *) HW_DIGCTL_L3_AHB_DATA_CYCLES_ADDR)
#define HW_DIGCTL_L3_AHB_DATA_CYCLES_RD()      (HW_DIGCTL_L3_AHB_DATA_CYCLES.U)
#define HW_DIGCTL_L3_AHB_DATA_CYCLES_WR(v)     (HW_DIGCTL_L3_AHB_DATA_CYCLES.U = (v))
#define HW_DIGCTL_L3_AHB_DATA_CYCLES_SET(v)    (HW_DIGCTL_L3_AHB_DATA_CYCLES_WR(HW_DIGCTL_L3_AHB_DATA_CYCLES_RD() |  (v)))
#define HW_DIGCTL_L3_AHB_DATA_CYCLES_CLR(v)    (HW_DIGCTL_L3_AHB_DATA_CYCLES_WR(HW_DIGCTL_L3_AHB_DATA_CYCLES_RD() & ~(v)))
#define HW_DIGCTL_L3_AHB_DATA_CYCLES_TOG(v)    (HW_DIGCTL_L3_AHB_DATA_CYCLES_WR(HW_DIGCTL_L3_AHB_DATA_CYCLES_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DIGCTL_L3_AHB_DATA_CYCLES bitfields
//

//--- Register HW_DIGCTL_L3_AHB_DATA_CYCLES, field COUNT

#define BP_DIGCTL_L3_AHB_DATA_CYCLES_COUNT      0
#define BM_DIGCTL_L3_AHB_DATA_CYCLES_COUNT      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_L3_AHB_DATA_CYCLES_COUNT(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_L3_AHB_DATA_CYCLES_COUNT(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_L3_AHB_DATA_CYCLES_COUNT(v)   (HW_DIGCTL_L3_AHB_DATA_CYCLES.B.COUNT = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// multi-register-define name HW_DIGCTL_MPTEn_LOC : base 0x8001C400 : count 16 : offset 0x10
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned LOC    : 12;
        unsigned RSVD0  : 20;
    } B;
} hw_digctl_mpten_loc_t;
#endif


//
// constants & macros for entire HW_DIGCTL_MPTEn_LOC multi-register
//

#define HW_DIGCTL_MPTEn_LOC_COUNT        16
#define HW_DIGCTL_MPTEn_LOC_ADDR(n)      (REGS_DIGCTL_BASE + 0x00000400 + ((n) * 0x10))

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_MPTEn_LOC(n)           (*(volatile hw_digctl_mpten_loc_t *) HW_DIGCTL_MPTEn_LOC_ADDR(n))
#define HW_DIGCTL_MPTEn_LOC_RD(n)        (HW_DIGCTL_MPTEn_LOC(n).U)
#define HW_DIGCTL_MPTEn_LOC_WR(n, v)     (HW_DIGCTL_MPTEn_LOC(n).U = (v))
#define HW_DIGCTL_MPTEn_LOC_SET(n, v)    (HW_DIGCTL_MPTEn_LOC_WR(n, HW_DIGCTL_MPTEn_LOC_RD(n) |  (v)))
#define HW_DIGCTL_MPTEn_LOC_CLR(n, v)    (HW_DIGCTL_MPTEn_LOC_WR(n, HW_DIGCTL_MPTEn_LOC_RD(n) & ~(v)))
#define HW_DIGCTL_MPTEn_LOC_TOG(n, v)    (HW_DIGCTL_MPTEn_LOC_WR(n, HW_DIGCTL_MPTEn_LOC_RD(n) ^  (v)))
#endif


//
// constants & macros for individual HW_DIGCTL_MPTEn_LOC multi-register bitfields
//

//--- Register HW_DIGCTL_MPTEn_LOC, field LOC

#define BP_DIGCTL_MPTEn_LOC_LOC      0
#define BM_DIGCTL_MPTEn_LOC_LOC      0x00000FFF

#define BF_DIGCTL_MPTEn_LOC_LOC(v)   (((v) << 0) & BM_DIGCTL_MPTEn_LOC_LOC)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_MPTEn_LOC_LOC(n, v)  BF_CS1n(DIGCTL_MPTEn_LOC, n, LOC, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DIGCTL_EMICLK_DELAY - EMI CLK/CLKN Delay Adjustment
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned NUM_TAPS  :  5;
        unsigned RSVD0     : 27;
    } B;
} hw_digctl_emiclk_delay_t;
#endif


//
// constants & macros for entire HW_DIGCTL_EMICLK_DELAY register
//

#define HW_DIGCTL_EMICLK_DELAY_ADDR      (REGS_DIGCTL_BASE + 0x00000500)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_EMICLK_DELAY           (*(volatile hw_digctl_emiclk_delay_t *) HW_DIGCTL_EMICLK_DELAY_ADDR)
#define HW_DIGCTL_EMICLK_DELAY_RD()      (HW_DIGCTL_EMICLK_DELAY.U)
#define HW_DIGCTL_EMICLK_DELAY_WR(v)     (HW_DIGCTL_EMICLK_DELAY.U = (v))
#define HW_DIGCTL_EMICLK_DELAY_SET(v)    (HW_DIGCTL_EMICLK_DELAY_WR(HW_DIGCTL_EMICLK_DELAY_RD() |  (v)))
#define HW_DIGCTL_EMICLK_DELAY_CLR(v)    (HW_DIGCTL_EMICLK_DELAY_WR(HW_DIGCTL_EMICLK_DELAY_RD() & ~(v)))
#define HW_DIGCTL_EMICLK_DELAY_TOG(v)    (HW_DIGCTL_EMICLK_DELAY_WR(HW_DIGCTL_EMICLK_DELAY_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DIGCTL_EMICLK_DELAY bitfields
//

//--- Register HW_DIGCTL_EMICLK_DELAY, field NUM_TAPS

#define BP_DIGCTL_EMICLK_DELAY_NUM_TAPS      0
#define BM_DIGCTL_EMICLK_DELAY_NUM_TAPS      0x0000001F

#define BF_DIGCTL_EMICLK_DELAY_NUM_TAPS(v)   (((v) << 0) & BM_DIGCTL_EMICLK_DELAY_NUM_TAPS)

#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_EMICLK_DELAY_NUM_TAPS(v)   BF_CS1(DIGCTL_EMICLK_DELAY, NUM_TAPS, v)
#endif


#endif // _REGSDIGCTL_H

////////////////////////////////////////////////////////////////////////////////
