/*
 * Copyright 2009 Freescale Semiconductor, Inc. All Rights Reserved.
 */

/*
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */
////////////////////////////////////////////////////////////////////////////////
//
// WARNING!  THIS FILE IS AUTOMATICALLY GENERATED FROM XML.
//                DO NOT MODIFY THIS FILE DIRECTLY.
//
////////////////////////////////////////////////////////////////////////////////
//
// The following naming conventions are followed in this file.
//      XX_<module>_<regname>_<field>
//
// XX specifies the define / macro class
//      HW pertains to a register
//      BM indicates a Bit Mask
//      BF indicates a Bit Field macro
//
// <module> is the hardware module name which can be any of the following...
//      USB20 (Note when there is more than one copy of a given module, the
//      module name includes a number starting from 0 for the first instance
//      of that module)
//
// <regname> is the specific register within that module
//
// <field> is the specific bitfield within that <module>_<register>
//
// We also define the following...
//      hw_<module>_<regname>_t is typedef of anonymous union
//
////////////////////////////////////////////////////////////////////////////////

#ifndef _REGSPOWER_H
#define _REGSPOWER_H  1

#include "regs.h"

#ifndef REGS_POWER_BASE
#define REGS_POWER_BASE (REGS_BASE + 0x00044000)
#endif

////////////////////////////////////////////////////////////////////////////////
//// HW_POWER_CTRL - Power Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ENIRQ_VDD5V_GT_VDDIO     :  1;
        unsigned VDD5V_GT_VDDIO_IRQ       :  1;
        unsigned POLARITY_VDD5V_GT_VDDIO  :  1;
        unsigned ENIRQ_VBUS_VALID         :  1;
        unsigned VBUSVALID_IRQ            :  1;
        unsigned POLARITY_VBUSVALID       :  1;
        unsigned ENIRQ_VDDD_BO            :  1;
        unsigned VDDD_BO_IRQ              :  1;
        unsigned ENIRQ_VDDA_BO            :  1;
        unsigned VDDA_BO_IRQ              :  1;
        unsigned ENIRQ_VDDIO_BO           :  1;
        unsigned VDDIO_BO_IRQ             :  1;
        unsigned ENIRQBATT_BO             :  1;
        unsigned BATT_BO_IRQ              :  1;
        unsigned ENIRQ_DC_OK              :  1;
        unsigned DC_OK_IRQ                :  1;
        unsigned POLARITY_DC_OK           :  1;
        unsigned ENIRQ_PSWITCH            :  1;
        unsigned POLARITY_PSWITCH         :  1;
        unsigned PSWITCH_IRQ_SRC          :  1;
        unsigned PSWITCH_IRQ              :  1;
        unsigned ENIRQ_VDD5V_DROOP        :  1;
        unsigned VDD5V_DROOP_IRQ          :  1;
        unsigned ENIRQ_DCDC4P2_BO         :  1;
        unsigned DCDC4P2_BO_IRQ           :  1;
        unsigned RSRVD1                   :  2;
        unsigned PSWITCH_MID_TRAN         :  1;
        unsigned RSRVD2                   :  2;
        unsigned CLKGATE                  :  1;
        unsigned RSRVD3                   :  1;
    } B;
} hw_power_ctrl_t;
#endif


//
// constants & macros for entire HW_POWER_CTRL register
//

#define HW_POWER_CTRL_ADDR      (REGS_POWER_BASE + 0x00000000)
#define HW_POWER_CTRL_SET_ADDR  (REGS_POWER_BASE + 0x00000004)
#define HW_POWER_CTRL_CLR_ADDR  (REGS_POWER_BASE + 0x00000008)
#define HW_POWER_CTRL_TOG_ADDR  (REGS_POWER_BASE + 0x0000000C)

#ifndef __LANGUAGE_ASM__
#define HW_POWER_CTRL           (*(volatile hw_power_ctrl_t *) HW_POWER_CTRL_ADDR)
#define HW_POWER_CTRL_RD()      (HW_POWER_CTRL.U)
#define HW_POWER_CTRL_WR(v)     (HW_POWER_CTRL.U = (v))
#define HW_POWER_CTRL_SET(v)    ((*(volatile reg32_t *) HW_POWER_CTRL_SET_ADDR) = (v))
#define HW_POWER_CTRL_CLR(v)    ((*(volatile reg32_t *) HW_POWER_CTRL_CLR_ADDR) = (v))
#define HW_POWER_CTRL_TOG(v)    ((*(volatile reg32_t *) HW_POWER_CTRL_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_POWER_CTRL bitfields
//

//--- Register HW_POWER_CTRL, field CLKGATE

#define BP_POWER_CTRL_CLKGATE      30
#define BM_POWER_CTRL_CLKGATE      0x40000000

#define BF_POWER_CTRL_CLKGATE(v)   (((v) << 30) & BM_POWER_CTRL_CLKGATE)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_CTRL_CLKGATE(v)   BF_CS1(POWER_CTRL, CLKGATE, v)
#endif

//--- Register HW_POWER_CTRL, field PSWITCH_MID_TRAN

#define BP_POWER_CTRL_PSWITCH_MID_TRAN      27
#define BM_POWER_CTRL_PSWITCH_MID_TRAN      0x08000000

#define BF_POWER_CTRL_PSWITCH_MID_TRAN(v)   (((v) << 27) & BM_POWER_CTRL_PSWITCH_MID_TRAN)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_CTRL_PSWITCH_MID_TRAN(v)   BF_CS1(POWER_CTRL, PSWITCH_MID_TRAN, v)
#endif

//--- Register HW_POWER_CTRL, field DCDC4P2_BO_IRQ

#define BP_POWER_CTRL_DCDC4P2_BO_IRQ      24
#define BM_POWER_CTRL_DCDC4P2_BO_IRQ      0x01000000

#define BF_POWER_CTRL_DCDC4P2_BO_IRQ(v)   (((v) << 24) & BM_POWER_CTRL_DCDC4P2_BO_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_CTRL_DCDC4P2_BO_IRQ(v)   BF_CS1(POWER_CTRL, DCDC4P2_BO_IRQ, v)
#endif

//--- Register HW_POWER_CTRL, field ENIRQ_DCDC4P2_BO

#define BP_POWER_CTRL_ENIRQ_DCDC4P2_BO      23
#define BM_POWER_CTRL_ENIRQ_DCDC4P2_BO      0x00800000

#define BF_POWER_CTRL_ENIRQ_DCDC4P2_BO(v)   (((v) << 23) & BM_POWER_CTRL_ENIRQ_DCDC4P2_BO)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_CTRL_ENIRQ_DCDC4P2_BO(v)   BF_CS1(POWER_CTRL, ENIRQ_DCDC4P2_BO, v)
#endif

//--- Register HW_POWER_CTRL, field VDD5V_DROOP_IRQ

#define BP_POWER_CTRL_VDD5V_DROOP_IRQ      22
#define BM_POWER_CTRL_VDD5V_DROOP_IRQ      0x00400000

#define BF_POWER_CTRL_VDD5V_DROOP_IRQ(v)   (((v) << 22) & BM_POWER_CTRL_VDD5V_DROOP_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_CTRL_VDD5V_DROOP_IRQ(v)   BF_CS1(POWER_CTRL, VDD5V_DROOP_IRQ, v)
#endif

//--- Register HW_POWER_CTRL, field ENIRQ_VDD5V_DROOP

#define BP_POWER_CTRL_ENIRQ_VDD5V_DROOP      21
#define BM_POWER_CTRL_ENIRQ_VDD5V_DROOP      0x00200000

#define BF_POWER_CTRL_ENIRQ_VDD5V_DROOP(v)   (((v) << 21) & BM_POWER_CTRL_ENIRQ_VDD5V_DROOP)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_CTRL_ENIRQ_VDD5V_DROOP(v)   BF_CS1(POWER_CTRL, ENIRQ_VDD5V_DROOP, v)
#endif

//--- Register HW_POWER_CTRL, field PSWITCH_IRQ

#define BP_POWER_CTRL_PSWITCH_IRQ      20
#define BM_POWER_CTRL_PSWITCH_IRQ      0x00100000

#define BF_POWER_CTRL_PSWITCH_IRQ(v)   (((v) << 20) & BM_POWER_CTRL_PSWITCH_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_CTRL_PSWITCH_IRQ(v)   BF_CS1(POWER_CTRL, PSWITCH_IRQ, v)
#endif

//--- Register HW_POWER_CTRL, field PSWITCH_IRQ_SRC

#define BP_POWER_CTRL_PSWITCH_IRQ_SRC      19
#define BM_POWER_CTRL_PSWITCH_IRQ_SRC      0x00080000

#define BF_POWER_CTRL_PSWITCH_IRQ_SRC(v)   (((v) << 19) & BM_POWER_CTRL_PSWITCH_IRQ_SRC)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_CTRL_PSWITCH_IRQ_SRC(v)   BF_CS1(POWER_CTRL, PSWITCH_IRQ_SRC, v)
#endif

//--- Register HW_POWER_CTRL, field POLARITY_PSWITCH

#define BP_POWER_CTRL_POLARITY_PSWITCH      18
#define BM_POWER_CTRL_POLARITY_PSWITCH      0x00040000

#define BF_POWER_CTRL_POLARITY_PSWITCH(v)   (((v) << 18) & BM_POWER_CTRL_POLARITY_PSWITCH)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_CTRL_POLARITY_PSWITCH(v)   BF_CS1(POWER_CTRL, POLARITY_PSWITCH, v)
#endif

//--- Register HW_POWER_CTRL, field ENIRQ_PSWITCH

#define BP_POWER_CTRL_ENIRQ_PSWITCH      17
#define BM_POWER_CTRL_ENIRQ_PSWITCH      0x00020000

#define BF_POWER_CTRL_ENIRQ_PSWITCH(v)   (((v) << 17) & BM_POWER_CTRL_ENIRQ_PSWITCH)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_CTRL_ENIRQ_PSWITCH(v)   BF_CS1(POWER_CTRL, ENIRQ_PSWITCH, v)
#endif

//--- Register HW_POWER_CTRL, field POLARITY_DC_OK

#define BP_POWER_CTRL_POLARITY_DC_OK      16
#define BM_POWER_CTRL_POLARITY_DC_OK      0x00010000

#define BF_POWER_CTRL_POLARITY_DC_OK(v)   (((v) << 16) & BM_POWER_CTRL_POLARITY_DC_OK)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_CTRL_POLARITY_DC_OK(v)   BF_CS1(POWER_CTRL, POLARITY_DC_OK, v)
#endif

//--- Register HW_POWER_CTRL, field DC_OK_IRQ

#define BP_POWER_CTRL_DC_OK_IRQ      15
#define BM_POWER_CTRL_DC_OK_IRQ      0x00008000

#define BF_POWER_CTRL_DC_OK_IRQ(v)   (((v) << 15) & BM_POWER_CTRL_DC_OK_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_CTRL_DC_OK_IRQ(v)   BF_CS1(POWER_CTRL, DC_OK_IRQ, v)
#endif

//--- Register HW_POWER_CTRL, field ENIRQ_DC_OK

#define BP_POWER_CTRL_ENIRQ_DC_OK      14
#define BM_POWER_CTRL_ENIRQ_DC_OK      0x00004000

#define BF_POWER_CTRL_ENIRQ_DC_OK(v)   (((v) << 14) & BM_POWER_CTRL_ENIRQ_DC_OK)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_CTRL_ENIRQ_DC_OK(v)   BF_CS1(POWER_CTRL, ENIRQ_DC_OK, v)
#endif

//--- Register HW_POWER_CTRL, field BATT_BO_IRQ

#define BP_POWER_CTRL_BATT_BO_IRQ      13
#define BM_POWER_CTRL_BATT_BO_IRQ      0x00002000

#define BF_POWER_CTRL_BATT_BO_IRQ(v)   (((v) << 13) & BM_POWER_CTRL_BATT_BO_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_CTRL_BATT_BO_IRQ(v)   BF_CS1(POWER_CTRL, BATT_BO_IRQ, v)
#endif

//--- Register HW_POWER_CTRL, field ENIRQBATT_BO

#define BP_POWER_CTRL_ENIRQBATT_BO      12
#define BM_POWER_CTRL_ENIRQBATT_BO      0x00001000

#define BF_POWER_CTRL_ENIRQBATT_BO(v)   (((v) << 12) & BM_POWER_CTRL_ENIRQBATT_BO)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_CTRL_ENIRQBATT_BO(v)   BF_CS1(POWER_CTRL, ENIRQBATT_BO, v)
#endif

//--- Register HW_POWER_CTRL, field VDDIO_BO_IRQ

#define BP_POWER_CTRL_VDDIO_BO_IRQ      11
#define BM_POWER_CTRL_VDDIO_BO_IRQ      0x00000800

#define BF_POWER_CTRL_VDDIO_BO_IRQ(v)   (((v) << 11) & BM_POWER_CTRL_VDDIO_BO_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_CTRL_VDDIO_BO_IRQ(v)   BF_CS1(POWER_CTRL, VDDIO_BO_IRQ, v)
#endif

//--- Register HW_POWER_CTRL, field ENIRQ_VDDIO_BO

#define BP_POWER_CTRL_ENIRQ_VDDIO_BO      10
#define BM_POWER_CTRL_ENIRQ_VDDIO_BO      0x00000400

#define BF_POWER_CTRL_ENIRQ_VDDIO_BO(v)   (((v) << 10) & BM_POWER_CTRL_ENIRQ_VDDIO_BO)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_CTRL_ENIRQ_VDDIO_BO(v)   BF_CS1(POWER_CTRL, ENIRQ_VDDIO_BO, v)
#endif

//--- Register HW_POWER_CTRL, field VDDA_BO_IRQ

#define BP_POWER_CTRL_VDDA_BO_IRQ      9
#define BM_POWER_CTRL_VDDA_BO_IRQ      0x00000200

#define BF_POWER_CTRL_VDDA_BO_IRQ(v)   (((v) << 9) & BM_POWER_CTRL_VDDA_BO_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_CTRL_VDDA_BO_IRQ(v)   BF_CS1(POWER_CTRL, VDDA_BO_IRQ, v)
#endif

//--- Register HW_POWER_CTRL, field ENIRQ_VDDA_BO

#define BP_POWER_CTRL_ENIRQ_VDDA_BO      8
#define BM_POWER_CTRL_ENIRQ_VDDA_BO      0x00000100

#define BF_POWER_CTRL_ENIRQ_VDDA_BO(v)   (((v) << 8) & BM_POWER_CTRL_ENIRQ_VDDA_BO)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_CTRL_ENIRQ_VDDA_BO(v)   BF_CS1(POWER_CTRL, ENIRQ_VDDA_BO, v)
#endif

//--- Register HW_POWER_CTRL, field VDDD_BO_IRQ

#define BP_POWER_CTRL_VDDD_BO_IRQ      7
#define BM_POWER_CTRL_VDDD_BO_IRQ      0x00000080

#define BF_POWER_CTRL_VDDD_BO_IRQ(v)   (((v) << 7) & BM_POWER_CTRL_VDDD_BO_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_CTRL_VDDD_BO_IRQ(v)   BF_CS1(POWER_CTRL, VDDD_BO_IRQ, v)
#endif

//--- Register HW_POWER_CTRL, field ENIRQ_VDDD_BO

#define BP_POWER_CTRL_ENIRQ_VDDD_BO      6
#define BM_POWER_CTRL_ENIRQ_VDDD_BO      0x00000040

#define BF_POWER_CTRL_ENIRQ_VDDD_BO(v)   (((v) << 6) & BM_POWER_CTRL_ENIRQ_VDDD_BO)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_CTRL_ENIRQ_VDDD_BO(v)   BF_CS1(POWER_CTRL, ENIRQ_VDDD_BO, v)
#endif

//--- Register HW_POWER_CTRL, field POLARITY_VBUSVALID

#define BP_POWER_CTRL_POLARITY_VBUSVALID      5
#define BM_POWER_CTRL_POLARITY_VBUSVALID      0x00000020

#define BF_POWER_CTRL_POLARITY_VBUSVALID(v)   (((v) << 5) & BM_POWER_CTRL_POLARITY_VBUSVALID)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_CTRL_POLARITY_VBUSVALID(v)   BF_CS1(POWER_CTRL, POLARITY_VBUSVALID, v)
#endif

//--- Register HW_POWER_CTRL, field VBUSVALID_IRQ

#define BP_POWER_CTRL_VBUSVALID_IRQ      4
#define BM_POWER_CTRL_VBUSVALID_IRQ      0x00000010

#define BF_POWER_CTRL_VBUSVALID_IRQ(v)   (((v) << 4) & BM_POWER_CTRL_VBUSVALID_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_CTRL_VBUSVALID_IRQ(v)   BF_CS1(POWER_CTRL, VBUSVALID_IRQ, v)
#endif

//--- Register HW_POWER_CTRL, field ENIRQ_VBUS_VALID

#define BP_POWER_CTRL_ENIRQ_VBUS_VALID      3
#define BM_POWER_CTRL_ENIRQ_VBUS_VALID      0x00000008

#define BF_POWER_CTRL_ENIRQ_VBUS_VALID(v)   (((v) << 3) & BM_POWER_CTRL_ENIRQ_VBUS_VALID)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_CTRL_ENIRQ_VBUS_VALID(v)   BF_CS1(POWER_CTRL, ENIRQ_VBUS_VALID, v)
#endif

//--- Register HW_POWER_CTRL, field POLARITY_VDD5V_GT_VDDIO

#define BP_POWER_CTRL_POLARITY_VDD5V_GT_VDDIO      2
#define BM_POWER_CTRL_POLARITY_VDD5V_GT_VDDIO      0x00000004

#define BF_POWER_CTRL_POLARITY_VDD5V_GT_VDDIO(v)   (((v) << 2) & BM_POWER_CTRL_POLARITY_VDD5V_GT_VDDIO)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_CTRL_POLARITY_VDD5V_GT_VDDIO(v)   BF_CS1(POWER_CTRL, POLARITY_VDD5V_GT_VDDIO, v)
#endif

//--- Register HW_POWER_CTRL, field VDD5V_GT_VDDIO_IRQ

#define BP_POWER_CTRL_VDD5V_GT_VDDIO_IRQ      1
#define BM_POWER_CTRL_VDD5V_GT_VDDIO_IRQ      0x00000002

#define BF_POWER_CTRL_VDD5V_GT_VDDIO_IRQ(v)   (((v) << 1) & BM_POWER_CTRL_VDD5V_GT_VDDIO_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_CTRL_VDD5V_GT_VDDIO_IRQ(v)   BF_CS1(POWER_CTRL, VDD5V_GT_VDDIO_IRQ, v)
#endif

//--- Register HW_POWER_CTRL, field ENIRQ_VDD5V_GT_VDDIO

#define BP_POWER_CTRL_ENIRQ_VDD5V_GT_VDDIO      0
#define BM_POWER_CTRL_ENIRQ_VDD5V_GT_VDDIO      0x00000001

#define BF_POWER_CTRL_ENIRQ_VDD5V_GT_VDDIO(v)   (((v) << 0) & BM_POWER_CTRL_ENIRQ_VDD5V_GT_VDDIO)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_CTRL_ENIRQ_VDD5V_GT_VDDIO(v)   BF_CS1(POWER_CTRL, ENIRQ_VDD5V_GT_VDDIO, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_POWER_5VCTRL - DC-DC 5V Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ENABLE_DCDC           :  1;
        unsigned PWRUP_VBUS_CMPS       :  1;
        unsigned ILIMIT_EQ_ZERO        :  1;
        unsigned VBUSVALID_TO_B        :  1;
        unsigned VBUSVALID_5VDETECT    :  1;
        unsigned DCDC_XFER             :  1;
        unsigned ENABLE_LINREG_ILIMIT  :  1;
        unsigned PWDN_5VBRNOUT         :  1;
        unsigned VBUSVALID_TRSH        :  3;
        unsigned RSRVD2                :  1;
        unsigned CHARGE_4P2_ILIMIT     :  6;
        unsigned RSRVD3                :  2;
        unsigned PWD_CHARGE_4P2        :  1;
        unsigned RSRVD4                :  3;
        unsigned HEADROOM_ADJ          :  3;
        unsigned RSRVD5                :  1;
        unsigned VBUSDROOP_TRSH        :  2;
        unsigned RSRVD6                :  2;
    } B;
} hw_power_5vctrl_t;
#endif


//
// constants & macros for entire HW_POWER_5VCTRL register
//

#define HW_POWER_5VCTRL_ADDR      (REGS_POWER_BASE + 0x00000010)
#define HW_POWER_5VCTRL_SET_ADDR  (REGS_POWER_BASE + 0x00000014)
#define HW_POWER_5VCTRL_CLR_ADDR  (REGS_POWER_BASE + 0x00000018)
#define HW_POWER_5VCTRL_TOG_ADDR  (REGS_POWER_BASE + 0x0000001C)

#ifndef __LANGUAGE_ASM__
#define HW_POWER_5VCTRL           (*(volatile hw_power_5vctrl_t *) HW_POWER_5VCTRL_ADDR)
#define HW_POWER_5VCTRL_RD()      (HW_POWER_5VCTRL.U)
#define HW_POWER_5VCTRL_WR(v)     (HW_POWER_5VCTRL.U = (v))
#define HW_POWER_5VCTRL_SET(v)    ((*(volatile reg32_t *) HW_POWER_5VCTRL_SET_ADDR) = (v))
#define HW_POWER_5VCTRL_CLR(v)    ((*(volatile reg32_t *) HW_POWER_5VCTRL_CLR_ADDR) = (v))
#define HW_POWER_5VCTRL_TOG(v)    ((*(volatile reg32_t *) HW_POWER_5VCTRL_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_POWER_5VCTRL bitfields
//

//--- Register HW_POWER_5VCTRL, field VBUSDROOP_TRSH

#define BP_POWER_5VCTRL_VBUSDROOP_TRSH      28
#define BM_POWER_5VCTRL_VBUSDROOP_TRSH      0x30000000

#define BF_POWER_5VCTRL_VBUSDROOP_TRSH(v)   (((v) << 28) & BM_POWER_5VCTRL_VBUSDROOP_TRSH)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_5VCTRL_VBUSDROOP_TRSH(v)   BF_CS1(POWER_5VCTRL, VBUSDROOP_TRSH, v)
#endif

//--- Register HW_POWER_5VCTRL, field HEADROOM_ADJ

#define BP_POWER_5VCTRL_HEADROOM_ADJ      24
#define BM_POWER_5VCTRL_HEADROOM_ADJ      0x07000000

#define BF_POWER_5VCTRL_HEADROOM_ADJ(v)   (((v) << 24) & BM_POWER_5VCTRL_HEADROOM_ADJ)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_5VCTRL_HEADROOM_ADJ(v)   BF_CS1(POWER_5VCTRL, HEADROOM_ADJ, v)
#endif

//--- Register HW_POWER_5VCTRL, field PWD_CHARGE_4P2

#define BP_POWER_5VCTRL_PWD_CHARGE_4P2      20
#define BM_POWER_5VCTRL_PWD_CHARGE_4P2      0x00100000

#define BF_POWER_5VCTRL_PWD_CHARGE_4P2(v)   (((v) << 20) & BM_POWER_5VCTRL_PWD_CHARGE_4P2)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_5VCTRL_PWD_CHARGE_4P2(v)   BF_CS1(POWER_5VCTRL, PWD_CHARGE_4P2, v)
#endif

//--- Register HW_POWER_5VCTRL, field CHARGE_4P2_ILIMIT

#define BP_POWER_5VCTRL_CHARGE_4P2_ILIMIT      12
#define BM_POWER_5VCTRL_CHARGE_4P2_ILIMIT      0x0003F000

#define BF_POWER_5VCTRL_CHARGE_4P2_ILIMIT(v)   (((v) << 12) & BM_POWER_5VCTRL_CHARGE_4P2_ILIMIT)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_5VCTRL_CHARGE_4P2_ILIMIT(v)   BF_CS1(POWER_5VCTRL, CHARGE_4P2_ILIMIT, v)
#endif

//--- Register HW_POWER_5VCTRL, field VBUSVALID_TRSH

#define BP_POWER_5VCTRL_VBUSVALID_TRSH      8
#define BM_POWER_5VCTRL_VBUSVALID_TRSH      0x00000700

#define BF_POWER_5VCTRL_VBUSVALID_TRSH(v)   (((v) << 8) & BM_POWER_5VCTRL_VBUSVALID_TRSH)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_5VCTRL_VBUSVALID_TRSH(v)   BF_CS1(POWER_5VCTRL, VBUSVALID_TRSH, v)
#endif

//--- Register HW_POWER_5VCTRL, field PWDN_5VBRNOUT

#define BP_POWER_5VCTRL_PWDN_5VBRNOUT      7
#define BM_POWER_5VCTRL_PWDN_5VBRNOUT      0x00000080

#define BF_POWER_5VCTRL_PWDN_5VBRNOUT(v)   (((v) << 7) & BM_POWER_5VCTRL_PWDN_5VBRNOUT)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_5VCTRL_PWDN_5VBRNOUT(v)   BF_CS1(POWER_5VCTRL, PWDN_5VBRNOUT, v)
#endif

//--- Register HW_POWER_5VCTRL, field ENABLE_LINREG_ILIMIT

#define BP_POWER_5VCTRL_ENABLE_LINREG_ILIMIT      6
#define BM_POWER_5VCTRL_ENABLE_LINREG_ILIMIT      0x00000040

#define BF_POWER_5VCTRL_ENABLE_LINREG_ILIMIT(v)   (((v) << 6) & BM_POWER_5VCTRL_ENABLE_LINREG_ILIMIT)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_5VCTRL_ENABLE_LINREG_ILIMIT(v)   BF_CS1(POWER_5VCTRL, ENABLE_LINREG_ILIMIT, v)
#endif

//--- Register HW_POWER_5VCTRL, field DCDC_XFER

#define BP_POWER_5VCTRL_DCDC_XFER      5
#define BM_POWER_5VCTRL_DCDC_XFER      0x00000020

#define BF_POWER_5VCTRL_DCDC_XFER(v)   (((v) << 5) & BM_POWER_5VCTRL_DCDC_XFER)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_5VCTRL_DCDC_XFER(v)   BF_CS1(POWER_5VCTRL, DCDC_XFER, v)
#endif

//--- Register HW_POWER_5VCTRL, field VBUSVALID_5VDETECT

#define BP_POWER_5VCTRL_VBUSVALID_5VDETECT      4
#define BM_POWER_5VCTRL_VBUSVALID_5VDETECT      0x00000010

#define BF_POWER_5VCTRL_VBUSVALID_5VDETECT(v)   (((v) << 4) & BM_POWER_5VCTRL_VBUSVALID_5VDETECT)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_5VCTRL_VBUSVALID_5VDETECT(v)   BF_CS1(POWER_5VCTRL, VBUSVALID_5VDETECT, v)
#endif

//--- Register HW_POWER_5VCTRL, field VBUSVALID_TO_B

#define BP_POWER_5VCTRL_VBUSVALID_TO_B      3
#define BM_POWER_5VCTRL_VBUSVALID_TO_B      0x00000008

#define BF_POWER_5VCTRL_VBUSVALID_TO_B(v)   (((v) << 3) & BM_POWER_5VCTRL_VBUSVALID_TO_B)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_5VCTRL_VBUSVALID_TO_B(v)   BF_CS1(POWER_5VCTRL, VBUSVALID_TO_B, v)
#endif

//--- Register HW_POWER_5VCTRL, field ILIMIT_EQ_ZERO

#define BP_POWER_5VCTRL_ILIMIT_EQ_ZERO      2
#define BM_POWER_5VCTRL_ILIMIT_EQ_ZERO      0x00000004

#define BF_POWER_5VCTRL_ILIMIT_EQ_ZERO(v)   (((v) << 2) & BM_POWER_5VCTRL_ILIMIT_EQ_ZERO)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_5VCTRL_ILIMIT_EQ_ZERO(v)   BF_CS1(POWER_5VCTRL, ILIMIT_EQ_ZERO, v)
#endif

//--- Register HW_POWER_5VCTRL, field PWRUP_VBUS_CMPS

#define BP_POWER_5VCTRL_PWRUP_VBUS_CMPS      1
#define BM_POWER_5VCTRL_PWRUP_VBUS_CMPS      0x00000002

#define BF_POWER_5VCTRL_PWRUP_VBUS_CMPS(v)   (((v) << 1) & BM_POWER_5VCTRL_PWRUP_VBUS_CMPS)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_5VCTRL_PWRUP_VBUS_CMPS(v)   BF_CS1(POWER_5VCTRL, PWRUP_VBUS_CMPS, v)
#endif

//--- Register HW_POWER_5VCTRL, field ENABLE_DCDC

#define BP_POWER_5VCTRL_ENABLE_DCDC      0
#define BM_POWER_5VCTRL_ENABLE_DCDC      0x00000001

#define BF_POWER_5VCTRL_ENABLE_DCDC(v)   (((v) << 0) & BM_POWER_5VCTRL_ENABLE_DCDC)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_5VCTRL_ENABLE_DCDC(v)   BF_CS1(POWER_5VCTRL, ENABLE_DCDC, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_POWER_MINPWR - DC-DC Minimum Power and Miscellaneous Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DC_HALFCLK       :  1;
        unsigned EN_DC_PFM        :  1;
        unsigned DC_STOPCLK       :  1;
        unsigned PWD_XTAL24       :  1;
        unsigned LESSANA_I        :  1;
        unsigned HALF_FETS        :  1;
        unsigned DOUBLE_FETS      :  1;
        unsigned VBG_OFF          :  1;
        unsigned SELECT_OSC       :  1;
        unsigned ENABLE_OSC       :  1;
        unsigned PWD_ANA_CMPS     :  1;
        unsigned USE_VDDXTAL_VBG  :  1;
        unsigned PWD_BO           :  1;
        unsigned VDAC_DUMP_CTRL   :  1;
        unsigned LOWPWR_4P2       :  1;
        unsigned RSRVD1           : 17;
    } B;
} hw_power_minpwr_t;
#endif


//
// constants & macros for entire HW_POWER_MINPWR register
//

#define HW_POWER_MINPWR_ADDR      (REGS_POWER_BASE + 0x00000020)
#define HW_POWER_MINPWR_SET_ADDR  (REGS_POWER_BASE + 0x00000024)
#define HW_POWER_MINPWR_CLR_ADDR  (REGS_POWER_BASE + 0x00000028)
#define HW_POWER_MINPWR_TOG_ADDR  (REGS_POWER_BASE + 0x0000002C)

#ifndef __LANGUAGE_ASM__
#define HW_POWER_MINPWR           (*(volatile hw_power_minpwr_t *) HW_POWER_MINPWR_ADDR)
#define HW_POWER_MINPWR_RD()      (HW_POWER_MINPWR.U)
#define HW_POWER_MINPWR_WR(v)     (HW_POWER_MINPWR.U = (v))
#define HW_POWER_MINPWR_SET(v)    ((*(volatile reg32_t *) HW_POWER_MINPWR_SET_ADDR) = (v))
#define HW_POWER_MINPWR_CLR(v)    ((*(volatile reg32_t *) HW_POWER_MINPWR_CLR_ADDR) = (v))
#define HW_POWER_MINPWR_TOG(v)    ((*(volatile reg32_t *) HW_POWER_MINPWR_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_POWER_MINPWR bitfields
//

//--- Register HW_POWER_MINPWR, field LOWPWR_4P2

#define BP_POWER_MINPWR_LOWPWR_4P2      14
#define BM_POWER_MINPWR_LOWPWR_4P2      0x00004000

#define BF_POWER_MINPWR_LOWPWR_4P2(v)   (((v) << 14) & BM_POWER_MINPWR_LOWPWR_4P2)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_MINPWR_LOWPWR_4P2(v)   BF_CS1(POWER_MINPWR, LOWPWR_4P2, v)
#endif

//--- Register HW_POWER_MINPWR, field VDAC_DUMP_CTRL

#define BP_POWER_MINPWR_VDAC_DUMP_CTRL      13
#define BM_POWER_MINPWR_VDAC_DUMP_CTRL      0x00002000

#define BF_POWER_MINPWR_VDAC_DUMP_CTRL(v)   (((v) << 13) & BM_POWER_MINPWR_VDAC_DUMP_CTRL)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_MINPWR_VDAC_DUMP_CTRL(v)   BF_CS1(POWER_MINPWR, VDAC_DUMP_CTRL, v)
#endif

//--- Register HW_POWER_MINPWR, field PWD_BO

#define BP_POWER_MINPWR_PWD_BO      12
#define BM_POWER_MINPWR_PWD_BO      0x00001000

#define BF_POWER_MINPWR_PWD_BO(v)   (((v) << 12) & BM_POWER_MINPWR_PWD_BO)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_MINPWR_PWD_BO(v)   BF_CS1(POWER_MINPWR, PWD_BO, v)
#endif

//--- Register HW_POWER_MINPWR, field USE_VDDXTAL_VBG

#define BP_POWER_MINPWR_USE_VDDXTAL_VBG      11
#define BM_POWER_MINPWR_USE_VDDXTAL_VBG      0x00000800

#define BF_POWER_MINPWR_USE_VDDXTAL_VBG(v)   (((v) << 11) & BM_POWER_MINPWR_USE_VDDXTAL_VBG)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_MINPWR_USE_VDDXTAL_VBG(v)   BF_CS1(POWER_MINPWR, USE_VDDXTAL_VBG, v)
#endif

//--- Register HW_POWER_MINPWR, field PWD_ANA_CMPS

#define BP_POWER_MINPWR_PWD_ANA_CMPS      10
#define BM_POWER_MINPWR_PWD_ANA_CMPS      0x00000400

#define BF_POWER_MINPWR_PWD_ANA_CMPS(v)   (((v) << 10) & BM_POWER_MINPWR_PWD_ANA_CMPS)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_MINPWR_PWD_ANA_CMPS(v)   BF_CS1(POWER_MINPWR, PWD_ANA_CMPS, v)
#endif

//--- Register HW_POWER_MINPWR, field ENABLE_OSC

#define BP_POWER_MINPWR_ENABLE_OSC      9
#define BM_POWER_MINPWR_ENABLE_OSC      0x00000200

#define BF_POWER_MINPWR_ENABLE_OSC(v)   (((v) << 9) & BM_POWER_MINPWR_ENABLE_OSC)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_MINPWR_ENABLE_OSC(v)   BF_CS1(POWER_MINPWR, ENABLE_OSC, v)
#endif

//--- Register HW_POWER_MINPWR, field SELECT_OSC

#define BP_POWER_MINPWR_SELECT_OSC      8
#define BM_POWER_MINPWR_SELECT_OSC      0x00000100

#define BF_POWER_MINPWR_SELECT_OSC(v)   (((v) << 8) & BM_POWER_MINPWR_SELECT_OSC)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_MINPWR_SELECT_OSC(v)   BF_CS1(POWER_MINPWR, SELECT_OSC, v)
#endif

//--- Register HW_POWER_MINPWR, field VBG_OFF

#define BP_POWER_MINPWR_VBG_OFF      7
#define BM_POWER_MINPWR_VBG_OFF      0x00000080

#define BF_POWER_MINPWR_VBG_OFF(v)   (((v) << 7) & BM_POWER_MINPWR_VBG_OFF)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_MINPWR_VBG_OFF(v)   BF_CS1(POWER_MINPWR, VBG_OFF, v)
#endif

//--- Register HW_POWER_MINPWR, field DOUBLE_FETS

#define BP_POWER_MINPWR_DOUBLE_FETS      6
#define BM_POWER_MINPWR_DOUBLE_FETS      0x00000040

#define BF_POWER_MINPWR_DOUBLE_FETS(v)   (((v) << 6) & BM_POWER_MINPWR_DOUBLE_FETS)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_MINPWR_DOUBLE_FETS(v)   BF_CS1(POWER_MINPWR, DOUBLE_FETS, v)
#endif

//--- Register HW_POWER_MINPWR, field HALF_FETS

#define BP_POWER_MINPWR_HALF_FETS      5
#define BM_POWER_MINPWR_HALF_FETS      0x00000020

#define BF_POWER_MINPWR_HALF_FETS(v)   (((v) << 5) & BM_POWER_MINPWR_HALF_FETS)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_MINPWR_HALF_FETS(v)   BF_CS1(POWER_MINPWR, HALF_FETS, v)
#endif

//--- Register HW_POWER_MINPWR, field LESSANA_I

#define BP_POWER_MINPWR_LESSANA_I      4
#define BM_POWER_MINPWR_LESSANA_I      0x00000010

#define BF_POWER_MINPWR_LESSANA_I(v)   (((v) << 4) & BM_POWER_MINPWR_LESSANA_I)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_MINPWR_LESSANA_I(v)   BF_CS1(POWER_MINPWR, LESSANA_I, v)
#endif

//--- Register HW_POWER_MINPWR, field PWD_XTAL24

#define BP_POWER_MINPWR_PWD_XTAL24      3
#define BM_POWER_MINPWR_PWD_XTAL24      0x00000008

#define BF_POWER_MINPWR_PWD_XTAL24(v)   (((v) << 3) & BM_POWER_MINPWR_PWD_XTAL24)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_MINPWR_PWD_XTAL24(v)   BF_CS1(POWER_MINPWR, PWD_XTAL24, v)
#endif

//--- Register HW_POWER_MINPWR, field DC_STOPCLK

#define BP_POWER_MINPWR_DC_STOPCLK      2
#define BM_POWER_MINPWR_DC_STOPCLK      0x00000004

#define BF_POWER_MINPWR_DC_STOPCLK(v)   (((v) << 2) & BM_POWER_MINPWR_DC_STOPCLK)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_MINPWR_DC_STOPCLK(v)   BF_CS1(POWER_MINPWR, DC_STOPCLK, v)
#endif

//--- Register HW_POWER_MINPWR, field EN_DC_PFM

#define BP_POWER_MINPWR_EN_DC_PFM      1
#define BM_POWER_MINPWR_EN_DC_PFM      0x00000002

#define BF_POWER_MINPWR_EN_DC_PFM(v)   (((v) << 1) & BM_POWER_MINPWR_EN_DC_PFM)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_MINPWR_EN_DC_PFM(v)   BF_CS1(POWER_MINPWR, EN_DC_PFM, v)
#endif

//--- Register HW_POWER_MINPWR, field DC_HALFCLK

#define BP_POWER_MINPWR_DC_HALFCLK      0
#define BM_POWER_MINPWR_DC_HALFCLK      0x00000001

#define BF_POWER_MINPWR_DC_HALFCLK(v)   (((v) << 0) & BM_POWER_MINPWR_DC_HALFCLK)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_MINPWR_DC_HALFCLK(v)   BF_CS1(POWER_MINPWR, DC_HALFCLK, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_POWER_CHARGE - Battery Charge Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BATTCHRG_I                :  6;
        unsigned RSVD1                     :  2;
        unsigned STOP_ILIMIT               :  4;
        unsigned RSVD2                     :  4;
        unsigned PWD_BATTCHRG              :  1;
        unsigned USE_EXTERN_R              :  1;
        unsigned RSVD3                     :  1;
        unsigned CHRG_STS_OFF              :  1;
        unsigned ENABLE_FAULT_DETECT       :  1;
        unsigned ENABLE_CHARGER_RESISTORS  :  1;
        unsigned ENABLE_LOAD               :  1;
        unsigned RSRVD3                    :  1;
        unsigned ADJ_VOLT                  :  3;
        unsigned RSVD4                     :  5;
    } B;
} hw_power_charge_t;
#endif


//
// constants & macros for entire HW_POWER_CHARGE register
//

#define HW_POWER_CHARGE_ADDR      (REGS_POWER_BASE + 0x00000030)
#define HW_POWER_CHARGE_SET_ADDR  (REGS_POWER_BASE + 0x00000034)
#define HW_POWER_CHARGE_CLR_ADDR  (REGS_POWER_BASE + 0x00000038)
#define HW_POWER_CHARGE_TOG_ADDR  (REGS_POWER_BASE + 0x0000003C)

#ifndef __LANGUAGE_ASM__
#define HW_POWER_CHARGE           (*(volatile hw_power_charge_t *) HW_POWER_CHARGE_ADDR)
#define HW_POWER_CHARGE_RD()      (HW_POWER_CHARGE.U)
#define HW_POWER_CHARGE_WR(v)     (HW_POWER_CHARGE.U = (v))
#define HW_POWER_CHARGE_SET(v)    ((*(volatile reg32_t *) HW_POWER_CHARGE_SET_ADDR) = (v))
#define HW_POWER_CHARGE_CLR(v)    ((*(volatile reg32_t *) HW_POWER_CHARGE_CLR_ADDR) = (v))
#define HW_POWER_CHARGE_TOG(v)    ((*(volatile reg32_t *) HW_POWER_CHARGE_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_POWER_CHARGE bitfields
//

//--- Register HW_POWER_CHARGE, field ADJ_VOLT

#define BP_POWER_CHARGE_ADJ_VOLT      24
#define BM_POWER_CHARGE_ADJ_VOLT      0x07000000

#define BF_POWER_CHARGE_ADJ_VOLT(v)   (((v) << 24) & BM_POWER_CHARGE_ADJ_VOLT)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_CHARGE_ADJ_VOLT(v)   BF_CS1(POWER_CHARGE, ADJ_VOLT, v)
#endif

//--- Register HW_POWER_CHARGE, field RSRVD3

#define BP_POWER_CHARGE_RSRVD3      23
#define BM_POWER_CHARGE_RSRVD3      0x00800000

#define BF_POWER_CHARGE_RSRVD3(v)   (((v) << 23) & BM_POWER_CHARGE_RSRVD3)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_CHARGE_RSRVD3(v)   BF_CS1(POWER_CHARGE, RSRVD3, v)
#endif

//--- Register HW_POWER_CHARGE, field ENABLE_LOAD

#define BP_POWER_CHARGE_ENABLE_LOAD      22
#define BM_POWER_CHARGE_ENABLE_LOAD      0x00400000

#define BF_POWER_CHARGE_ENABLE_LOAD(v)   (((v) << 22) & BM_POWER_CHARGE_ENABLE_LOAD)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_CHARGE_ENABLE_LOAD(v)   BF_CS1(POWER_CHARGE, ENABLE_LOAD, v)
#endif

//--- Register HW_POWER_CHARGE, field ENABLE_CHARGER_RESISTORS

#define BP_POWER_CHARGE_ENABLE_CHARGER_RESISTORS      21
#define BM_POWER_CHARGE_ENABLE_CHARGER_RESISTORS      0x00200000

#define BF_POWER_CHARGE_ENABLE_CHARGER_RESISTORS(v)   (((v) << 21) & BM_POWER_CHARGE_ENABLE_CHARGER_RESISTORS)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_CHARGE_ENABLE_CHARGER_RESISTORS(v)   BF_CS1(POWER_CHARGE, ENABLE_CHARGER_RESISTORS, v)
#endif

//--- Register HW_POWER_CHARGE, field ENABLE_FAULT_DETECT

#define BP_POWER_CHARGE_ENABLE_FAULT_DETECT      20
#define BM_POWER_CHARGE_ENABLE_FAULT_DETECT      0x00100000

#define BF_POWER_CHARGE_ENABLE_FAULT_DETECT(v)   (((v) << 20) & BM_POWER_CHARGE_ENABLE_FAULT_DETECT)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_CHARGE_ENABLE_FAULT_DETECT(v)   BF_CS1(POWER_CHARGE, ENABLE_FAULT_DETECT, v)
#endif

//--- Register HW_POWER_CHARGE, field CHRG_STS_OFF

#define BP_POWER_CHARGE_CHRG_STS_OFF      19
#define BM_POWER_CHARGE_CHRG_STS_OFF      0x00080000

#define BF_POWER_CHARGE_CHRG_STS_OFF(v)   (((v) << 19) & BM_POWER_CHARGE_CHRG_STS_OFF)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_CHARGE_CHRG_STS_OFF(v)   BF_CS1(POWER_CHARGE, CHRG_STS_OFF, v)
#endif

//--- Register HW_POWER_CHARGE, field USE_EXTERN_R

#define BP_POWER_CHARGE_USE_EXTERN_R      17
#define BM_POWER_CHARGE_USE_EXTERN_R      0x00020000

#define BF_POWER_CHARGE_USE_EXTERN_R(v)   (((v) << 17) & BM_POWER_CHARGE_USE_EXTERN_R)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_CHARGE_USE_EXTERN_R(v)   BF_CS1(POWER_CHARGE, USE_EXTERN_R, v)
#endif

//--- Register HW_POWER_CHARGE, field PWD_BATTCHRG

#define BP_POWER_CHARGE_PWD_BATTCHRG      16
#define BM_POWER_CHARGE_PWD_BATTCHRG      0x00010000

#define BF_POWER_CHARGE_PWD_BATTCHRG(v)   (((v) << 16) & BM_POWER_CHARGE_PWD_BATTCHRG)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_CHARGE_PWD_BATTCHRG(v)   BF_CS1(POWER_CHARGE, PWD_BATTCHRG, v)
#endif

//--- Register HW_POWER_CHARGE, field STOP_ILIMIT

#define BP_POWER_CHARGE_STOP_ILIMIT      8
#define BM_POWER_CHARGE_STOP_ILIMIT      0x00000F00

#define BF_POWER_CHARGE_STOP_ILIMIT(v)   (((v) << 8) & BM_POWER_CHARGE_STOP_ILIMIT)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_CHARGE_STOP_ILIMIT(v)   BF_CS1(POWER_CHARGE, STOP_ILIMIT, v)
#endif

//--- Register HW_POWER_CHARGE, field BATTCHRG_I

#define BP_POWER_CHARGE_BATTCHRG_I      0
#define BM_POWER_CHARGE_BATTCHRG_I      0x0000003F

#define BF_POWER_CHARGE_BATTCHRG_I(v)   (((v) << 0) & BM_POWER_CHARGE_BATTCHRG_I)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_CHARGE_BATTCHRG_I(v)   BF_CS1(POWER_CHARGE, BATTCHRG_I, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_POWER_VDDDCTRL - VDDD Supply Targets and Brownouts Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TRG               :  5;
        unsigned RSRVD1            :  3;
        unsigned BO_OFFSET         :  3;
        unsigned RSRVD2            :  5;
        unsigned LINREG_OFFSET     :  2;
        unsigned RSRVD3            :  2;
        unsigned DISABLE_FET       :  1;
        unsigned ENABLE_LINREG     :  1;
        unsigned DISABLE_STEPPING  :  1;
        unsigned PWDN_BRNOUT       :  1;
        unsigned RSRVD4            :  4;
        unsigned ADJTN             :  4;
    } B;
} hw_power_vdddctrl_t;
#endif


//
// constants & macros for entire HW_POWER_VDDDCTRL register
//

#define HW_POWER_VDDDCTRL_ADDR      (REGS_POWER_BASE + 0x00000040)

#ifndef __LANGUAGE_ASM__
#define HW_POWER_VDDDCTRL           (*(volatile hw_power_vdddctrl_t *) HW_POWER_VDDDCTRL_ADDR)
#define HW_POWER_VDDDCTRL_RD()      (HW_POWER_VDDDCTRL.U)
#define HW_POWER_VDDDCTRL_WR(v)     (HW_POWER_VDDDCTRL.U = (v))
#define HW_POWER_VDDDCTRL_SET(v)    (HW_POWER_VDDDCTRL_WR(HW_POWER_VDDDCTRL_RD() |  (v)))
#define HW_POWER_VDDDCTRL_CLR(v)    (HW_POWER_VDDDCTRL_WR(HW_POWER_VDDDCTRL_RD() & ~(v)))
#define HW_POWER_VDDDCTRL_TOG(v)    (HW_POWER_VDDDCTRL_WR(HW_POWER_VDDDCTRL_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_POWER_VDDDCTRL bitfields
//

//--- Register HW_POWER_VDDDCTRL, field ADJTN

#define BP_POWER_VDDDCTRL_ADJTN      28
#define BM_POWER_VDDDCTRL_ADJTN      0xF0000000

#ifndef __LANGUAGE_ASM__
#define BF_POWER_VDDDCTRL_ADJTN(v)   ((((reg32_t) v) << 28) & BM_POWER_VDDDCTRL_ADJTN)
#else
#define BF_POWER_VDDDCTRL_ADJTN(v)   (((v) << 28) & BM_POWER_VDDDCTRL_ADJTN)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_POWER_VDDDCTRL_ADJTN(v)   BF_CS1(POWER_VDDDCTRL, ADJTN, v)
#endif

//--- Register HW_POWER_VDDDCTRL, field PWDN_BRNOUT

#define BP_POWER_VDDDCTRL_PWDN_BRNOUT      23
#define BM_POWER_VDDDCTRL_PWDN_BRNOUT      0x00800000

#define BF_POWER_VDDDCTRL_PWDN_BRNOUT(v)   (((v) << 23) & BM_POWER_VDDDCTRL_PWDN_BRNOUT)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_VDDDCTRL_PWDN_BRNOUT(v)   BF_CS1(POWER_VDDDCTRL, PWDN_BRNOUT, v)
#endif

//--- Register HW_POWER_VDDDCTRL, field DISABLE_STEPPING

#define BP_POWER_VDDDCTRL_DISABLE_STEPPING      22
#define BM_POWER_VDDDCTRL_DISABLE_STEPPING      0x00400000

#define BF_POWER_VDDDCTRL_DISABLE_STEPPING(v)   (((v) << 22) & BM_POWER_VDDDCTRL_DISABLE_STEPPING)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_VDDDCTRL_DISABLE_STEPPING(v)   BF_CS1(POWER_VDDDCTRL, DISABLE_STEPPING, v)
#endif

//--- Register HW_POWER_VDDDCTRL, field ENABLE_LINREG

#define BP_POWER_VDDDCTRL_ENABLE_LINREG      21
#define BM_POWER_VDDDCTRL_ENABLE_LINREG      0x00200000

#define BF_POWER_VDDDCTRL_ENABLE_LINREG(v)   (((v) << 21) & BM_POWER_VDDDCTRL_ENABLE_LINREG)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_VDDDCTRL_ENABLE_LINREG(v)   BF_CS1(POWER_VDDDCTRL, ENABLE_LINREG, v)
#endif

//--- Register HW_POWER_VDDDCTRL, field DISABLE_FET

#define BP_POWER_VDDDCTRL_DISABLE_FET      20
#define BM_POWER_VDDDCTRL_DISABLE_FET      0x00100000

#define BF_POWER_VDDDCTRL_DISABLE_FET(v)   (((v) << 20) & BM_POWER_VDDDCTRL_DISABLE_FET)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_VDDDCTRL_DISABLE_FET(v)   BF_CS1(POWER_VDDDCTRL, DISABLE_FET, v)
#endif

//--- Register HW_POWER_VDDDCTRL, field LINREG_OFFSET

#define BP_POWER_VDDDCTRL_LINREG_OFFSET      16
#define BM_POWER_VDDDCTRL_LINREG_OFFSET      0x00030000

#define BF_POWER_VDDDCTRL_LINREG_OFFSET(v)   (((v) << 16) & BM_POWER_VDDDCTRL_LINREG_OFFSET)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_VDDDCTRL_LINREG_OFFSET(v)   BF_CS1(POWER_VDDDCTRL, LINREG_OFFSET, v)
#endif

//--- Register HW_POWER_VDDDCTRL, field BO_OFFSET

#define BP_POWER_VDDDCTRL_BO_OFFSET      8
#define BM_POWER_VDDDCTRL_BO_OFFSET      0x00000700

#define BF_POWER_VDDDCTRL_BO_OFFSET(v)   (((v) << 8) & BM_POWER_VDDDCTRL_BO_OFFSET)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_VDDDCTRL_BO_OFFSET(v)   BF_CS1(POWER_VDDDCTRL, BO_OFFSET, v)
#endif

//--- Register HW_POWER_VDDDCTRL, field TRG

#define BP_POWER_VDDDCTRL_TRG      0
#define BM_POWER_VDDDCTRL_TRG      0x0000001F

#define BF_POWER_VDDDCTRL_TRG(v)   (((v) << 0) & BM_POWER_VDDDCTRL_TRG)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_VDDDCTRL_TRG(v)   BF_CS1(POWER_VDDDCTRL, TRG, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_POWER_VDDACTRL - VDDA Supply Targets and Brownouts Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TRG               :  5;
        unsigned RSRVD1            :  3;
        unsigned BO_OFFSET         :  3;
        unsigned RSRVD2            :  1;
        unsigned LINREG_OFFSET     :  2;
        unsigned RSRVD3            :  2;
        unsigned DISABLE_FET       :  1;
        unsigned ENABLE_LINREG     :  1;
        unsigned DISABLE_STEPPING  :  1;
        unsigned PWDN_BRNOUT       :  1;
        unsigned RSRVD4            : 12;
    } B;
} hw_power_vddactrl_t;
#endif


//
// constants & macros for entire HW_POWER_VDDACTRL register
//

#define HW_POWER_VDDACTRL_ADDR      (REGS_POWER_BASE + 0x00000050)

#ifndef __LANGUAGE_ASM__
#define HW_POWER_VDDACTRL           (*(volatile hw_power_vddactrl_t *) HW_POWER_VDDACTRL_ADDR)
#define HW_POWER_VDDACTRL_RD()      (HW_POWER_VDDACTRL.U)
#define HW_POWER_VDDACTRL_WR(v)     (HW_POWER_VDDACTRL.U = (v))
#define HW_POWER_VDDACTRL_SET(v)    (HW_POWER_VDDACTRL_WR(HW_POWER_VDDACTRL_RD() |  (v)))
#define HW_POWER_VDDACTRL_CLR(v)    (HW_POWER_VDDACTRL_WR(HW_POWER_VDDACTRL_RD() & ~(v)))
#define HW_POWER_VDDACTRL_TOG(v)    (HW_POWER_VDDACTRL_WR(HW_POWER_VDDACTRL_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_POWER_VDDACTRL bitfields
//

//--- Register HW_POWER_VDDACTRL, field PWDN_BRNOUT

#define BP_POWER_VDDACTRL_PWDN_BRNOUT      19
#define BM_POWER_VDDACTRL_PWDN_BRNOUT      0x00080000

#define BF_POWER_VDDACTRL_PWDN_BRNOUT(v)   (((v) << 19) & BM_POWER_VDDACTRL_PWDN_BRNOUT)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_VDDACTRL_PWDN_BRNOUT(v)   BF_CS1(POWER_VDDACTRL, PWDN_BRNOUT, v)
#endif

//--- Register HW_POWER_VDDACTRL, field DISABLE_STEPPING

#define BP_POWER_VDDACTRL_DISABLE_STEPPING      18
#define BM_POWER_VDDACTRL_DISABLE_STEPPING      0x00040000

#define BF_POWER_VDDACTRL_DISABLE_STEPPING(v)   (((v) << 18) & BM_POWER_VDDACTRL_DISABLE_STEPPING)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_VDDACTRL_DISABLE_STEPPING(v)   BF_CS1(POWER_VDDACTRL, DISABLE_STEPPING, v)
#endif

//--- Register HW_POWER_VDDACTRL, field ENABLE_LINREG

#define BP_POWER_VDDACTRL_ENABLE_LINREG      17
#define BM_POWER_VDDACTRL_ENABLE_LINREG      0x00020000

#define BF_POWER_VDDACTRL_ENABLE_LINREG(v)   (((v) << 17) & BM_POWER_VDDACTRL_ENABLE_LINREG)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_VDDACTRL_ENABLE_LINREG(v)   BF_CS1(POWER_VDDACTRL, ENABLE_LINREG, v)
#endif

//--- Register HW_POWER_VDDACTRL, field DISABLE_FET

#define BP_POWER_VDDACTRL_DISABLE_FET      16
#define BM_POWER_VDDACTRL_DISABLE_FET      0x00010000

#define BF_POWER_VDDACTRL_DISABLE_FET(v)   (((v) << 16) & BM_POWER_VDDACTRL_DISABLE_FET)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_VDDACTRL_DISABLE_FET(v)   BF_CS1(POWER_VDDACTRL, DISABLE_FET, v)
#endif

//--- Register HW_POWER_VDDACTRL, field LINREG_OFFSET

#define BP_POWER_VDDACTRL_LINREG_OFFSET      12
#define BM_POWER_VDDACTRL_LINREG_OFFSET      0x00003000

#define BF_POWER_VDDACTRL_LINREG_OFFSET(v)   (((v) << 12) & BM_POWER_VDDACTRL_LINREG_OFFSET)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_VDDACTRL_LINREG_OFFSET(v)   BF_CS1(POWER_VDDACTRL, LINREG_OFFSET, v)
#endif

//--- Register HW_POWER_VDDACTRL, field BO_OFFSET

#define BP_POWER_VDDACTRL_BO_OFFSET      8
#define BM_POWER_VDDACTRL_BO_OFFSET      0x00000700

#define BF_POWER_VDDACTRL_BO_OFFSET(v)   (((v) << 8) & BM_POWER_VDDACTRL_BO_OFFSET)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_VDDACTRL_BO_OFFSET(v)   BF_CS1(POWER_VDDACTRL, BO_OFFSET, v)
#endif

//--- Register HW_POWER_VDDACTRL, field TRG

#define BP_POWER_VDDACTRL_TRG      0
#define BM_POWER_VDDACTRL_TRG      0x0000001F

#define BF_POWER_VDDACTRL_TRG(v)   (((v) << 0) & BM_POWER_VDDACTRL_TRG)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_VDDACTRL_TRG(v)   BF_CS1(POWER_VDDACTRL, TRG, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_POWER_VDDIOCTRL - VDDIO Supply Targets and Brownouts Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TRG               :  5;
        unsigned RSRVD1            :  3;
        unsigned BO_OFFSET         :  3;
        unsigned RSRVD2            :  1;
        unsigned LINREG_OFFSET     :  2;
        unsigned RSRVD3            :  2;
        unsigned DISABLE_FET       :  1;
        unsigned DISABLE_STEPPING  :  1;
        unsigned PWDN_BRNOUT       :  1;
        unsigned RSRVD4            :  1;
        unsigned ADJTN             :  4;
        reg8_t   RSRVD5;
    } B;
} hw_power_vddioctrl_t;
#endif


//
// constants & macros for entire HW_POWER_VDDIOCTRL register
//

#define HW_POWER_VDDIOCTRL_ADDR      (REGS_POWER_BASE + 0x00000060)

#ifndef __LANGUAGE_ASM__
#define HW_POWER_VDDIOCTRL           (*(volatile hw_power_vddioctrl_t *) HW_POWER_VDDIOCTRL_ADDR)
#define HW_POWER_VDDIOCTRL_RD()      (HW_POWER_VDDIOCTRL.U)
#define HW_POWER_VDDIOCTRL_WR(v)     (HW_POWER_VDDIOCTRL.U = (v))
#define HW_POWER_VDDIOCTRL_SET(v)    (HW_POWER_VDDIOCTRL_WR(HW_POWER_VDDIOCTRL_RD() |  (v)))
#define HW_POWER_VDDIOCTRL_CLR(v)    (HW_POWER_VDDIOCTRL_WR(HW_POWER_VDDIOCTRL_RD() & ~(v)))
#define HW_POWER_VDDIOCTRL_TOG(v)    (HW_POWER_VDDIOCTRL_WR(HW_POWER_VDDIOCTRL_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_POWER_VDDIOCTRL bitfields
//

//--- Register HW_POWER_VDDIOCTRL, field ADJTN

#define BP_POWER_VDDIOCTRL_ADJTN      20
#define BM_POWER_VDDIOCTRL_ADJTN      0x00F00000

#define BF_POWER_VDDIOCTRL_ADJTN(v)   (((v) << 20) & BM_POWER_VDDIOCTRL_ADJTN)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_VDDIOCTRL_ADJTN(v)   BF_CS1(POWER_VDDIOCTRL, ADJTN, v)
#endif

//--- Register HW_POWER_VDDIOCTRL, field PWDN_BRNOUT

#define BP_POWER_VDDIOCTRL_PWDN_BRNOUT      18
#define BM_POWER_VDDIOCTRL_PWDN_BRNOUT      0x00040000

#define BF_POWER_VDDIOCTRL_PWDN_BRNOUT(v)   (((v) << 18) & BM_POWER_VDDIOCTRL_PWDN_BRNOUT)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_VDDIOCTRL_PWDN_BRNOUT(v)   BF_CS1(POWER_VDDIOCTRL, PWDN_BRNOUT, v)
#endif

//--- Register HW_POWER_VDDIOCTRL, field DISABLE_STEPPING

#define BP_POWER_VDDIOCTRL_DISABLE_STEPPING      17
#define BM_POWER_VDDIOCTRL_DISABLE_STEPPING      0x00020000

#define BF_POWER_VDDIOCTRL_DISABLE_STEPPING(v)   (((v) << 17) & BM_POWER_VDDIOCTRL_DISABLE_STEPPING)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_VDDIOCTRL_DISABLE_STEPPING(v)   BF_CS1(POWER_VDDIOCTRL, DISABLE_STEPPING, v)
#endif

//--- Register HW_POWER_VDDIOCTRL, field DISABLE_FET

#define BP_POWER_VDDIOCTRL_DISABLE_FET      16
#define BM_POWER_VDDIOCTRL_DISABLE_FET      0x00010000

#define BF_POWER_VDDIOCTRL_DISABLE_FET(v)   (((v) << 16) & BM_POWER_VDDIOCTRL_DISABLE_FET)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_VDDIOCTRL_DISABLE_FET(v)   BF_CS1(POWER_VDDIOCTRL, DISABLE_FET, v)
#endif

//--- Register HW_POWER_VDDIOCTRL, field LINREG_OFFSET

#define BP_POWER_VDDIOCTRL_LINREG_OFFSET      12
#define BM_POWER_VDDIOCTRL_LINREG_OFFSET      0x00003000

#define BF_POWER_VDDIOCTRL_LINREG_OFFSET(v)   (((v) << 12) & BM_POWER_VDDIOCTRL_LINREG_OFFSET)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_VDDIOCTRL_LINREG_OFFSET(v)   BF_CS1(POWER_VDDIOCTRL, LINREG_OFFSET, v)
#endif

//--- Register HW_POWER_VDDIOCTRL, field BO_OFFSET

#define BP_POWER_VDDIOCTRL_BO_OFFSET      8
#define BM_POWER_VDDIOCTRL_BO_OFFSET      0x00000700

#define BF_POWER_VDDIOCTRL_BO_OFFSET(v)   (((v) << 8) & BM_POWER_VDDIOCTRL_BO_OFFSET)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_VDDIOCTRL_BO_OFFSET(v)   BF_CS1(POWER_VDDIOCTRL, BO_OFFSET, v)
#endif

//--- Register HW_POWER_VDDIOCTRL, field TRG

#define BP_POWER_VDDIOCTRL_TRG      0
#define BM_POWER_VDDIOCTRL_TRG      0x0000001F

#define BF_POWER_VDDIOCTRL_TRG(v)   (((v) << 0) & BM_POWER_VDDIOCTRL_TRG)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_VDDIOCTRL_TRG(v)   BF_CS1(POWER_VDDIOCTRL, TRG, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_POWER_VDDMEMCTRL - VDDIO Supply Targets and Brownouts Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TRG              :  5;
        unsigned RSRVD1           :  3;
        unsigned ENABLE_LINREG    :  1;
        unsigned ENABLE_ILIMIT    :  1;
        unsigned PULLDOWN_ACTIVE  :  1;
        unsigned RSRVD2           : 21;
    } B;
} hw_power_vddmemctrl_t;
#endif


//
// constants & macros for entire HW_POWER_VDDMEMCTRL register
//

#define HW_POWER_VDDMEMCTRL_ADDR      (REGS_POWER_BASE + 0x00000070)

#ifndef __LANGUAGE_ASM__
#define HW_POWER_VDDMEMCTRL           (*(volatile hw_power_vddmemctrl_t *) HW_POWER_VDDMEMCTRL_ADDR)
#define HW_POWER_VDDMEMCTRL_RD()      (HW_POWER_VDDMEMCTRL.U)
#define HW_POWER_VDDMEMCTRL_WR(v)     (HW_POWER_VDDMEMCTRL.U = (v))
#define HW_POWER_VDDMEMCTRL_SET(v)    (HW_POWER_VDDMEMCTRL_WR(HW_POWER_VDDMEMCTRL_RD() |  (v)))
#define HW_POWER_VDDMEMCTRL_CLR(v)    (HW_POWER_VDDMEMCTRL_WR(HW_POWER_VDDMEMCTRL_RD() & ~(v)))
#define HW_POWER_VDDMEMCTRL_TOG(v)    (HW_POWER_VDDMEMCTRL_WR(HW_POWER_VDDMEMCTRL_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_POWER_VDDMEMCTRL bitfields
//

//--- Register HW_POWER_VDDMEMCTRL, field PULLDOWN_ACTIVE

#define BP_POWER_VDDMEMCTRL_PULLDOWN_ACTIVE      10
#define BM_POWER_VDDMEMCTRL_PULLDOWN_ACTIVE      0x00000400

#define BF_POWER_VDDMEMCTRL_PULLDOWN_ACTIVE(v)   (((v) << 10) & BM_POWER_VDDMEMCTRL_PULLDOWN_ACTIVE)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_VDDMEMCTRL_PULLDOWN_ACTIVE(v)   BF_CS1(POWER_VDDMEMCTRL, PULLDOWN_ACTIVE, v)
#endif

//--- Register HW_POWER_VDDMEMCTRL, field ENABLE_ILIMIT

#define BP_POWER_VDDMEMCTRL_ENABLE_ILIMIT      9
#define BM_POWER_VDDMEMCTRL_ENABLE_ILIMIT      0x00000200

#define BF_POWER_VDDMEMCTRL_ENABLE_ILIMIT(v)   (((v) << 9) & BM_POWER_VDDMEMCTRL_ENABLE_ILIMIT)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_VDDMEMCTRL_ENABLE_ILIMIT(v)   BF_CS1(POWER_VDDMEMCTRL, ENABLE_ILIMIT, v)
#endif

//--- Register HW_POWER_VDDMEMCTRL, field ENABLE_LINREG

#define BP_POWER_VDDMEMCTRL_ENABLE_LINREG      8
#define BM_POWER_VDDMEMCTRL_ENABLE_LINREG      0x00000100

#define BF_POWER_VDDMEMCTRL_ENABLE_LINREG(v)   (((v) << 8) & BM_POWER_VDDMEMCTRL_ENABLE_LINREG)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_VDDMEMCTRL_ENABLE_LINREG(v)   BF_CS1(POWER_VDDMEMCTRL, ENABLE_LINREG, v)
#endif

//--- Register HW_POWER_VDDMEMCTRL, field TRG

#define BP_POWER_VDDMEMCTRL_TRG      0
#define BM_POWER_VDDMEMCTRL_TRG      0x0000001F

#define BF_POWER_VDDMEMCTRL_TRG(v)   (((v) << 0) & BM_POWER_VDDMEMCTRL_TRG)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_VDDMEMCTRL_TRG(v)   BF_CS1(POWER_VDDMEMCTRL, TRG, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_POWER_DCDC4P2 - DC-DC Converter 4.2V Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned CMPTRIP        :  5;
        unsigned RSRVD1         :  3;
        unsigned BO             :  5;
        unsigned RSRVD2         :  3;
        unsigned TRG            :  3;
        unsigned RSRVD3         :  1;
        unsigned HYST_THRESH    :  1;
        unsigned HYST_DIR       :  1;
        unsigned ENABLE_DCDC    :  1;
        unsigned ENABLE_4P2     :  1;
        unsigned ISTEAL_THRESH  :  2;
        unsigned RSRVD5         :  2;
        unsigned DROPOUT_CTRL   :  4;
    } B;
} hw_power_dcdc4p2_t;
#endif


//
// constants & macros for entire HW_POWER_DCDC4P2 register
//

#define HW_POWER_DCDC4P2_ADDR      (REGS_POWER_BASE + 0x00000080)

#ifndef __LANGUAGE_ASM__
#define HW_POWER_DCDC4P2           (*(volatile hw_power_dcdc4p2_t *) HW_POWER_DCDC4P2_ADDR)
#define HW_POWER_DCDC4P2_RD()      (HW_POWER_DCDC4P2.U)
#define HW_POWER_DCDC4P2_WR(v)     (HW_POWER_DCDC4P2.U = (v))
#define HW_POWER_DCDC4P2_SET(v)    (HW_POWER_DCDC4P2_WR(HW_POWER_DCDC4P2_RD() |  (v)))
#define HW_POWER_DCDC4P2_CLR(v)    (HW_POWER_DCDC4P2_WR(HW_POWER_DCDC4P2_RD() & ~(v)))
#define HW_POWER_DCDC4P2_TOG(v)    (HW_POWER_DCDC4P2_WR(HW_POWER_DCDC4P2_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_POWER_DCDC4P2 bitfields
//

//--- Register HW_POWER_DCDC4P2, field DROPOUT_CTRL

#define BP_POWER_DCDC4P2_DROPOUT_CTRL      28
#define BM_POWER_DCDC4P2_DROPOUT_CTRL      0xF0000000

#ifndef __LANGUAGE_ASM__
#define BF_POWER_DCDC4P2_DROPOUT_CTRL(v)   ((((reg32_t) v) << 28) & BM_POWER_DCDC4P2_DROPOUT_CTRL)
#else
#define BF_POWER_DCDC4P2_DROPOUT_CTRL(v)   (((v) << 28) & BM_POWER_DCDC4P2_DROPOUT_CTRL)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_POWER_DCDC4P2_DROPOUT_CTRL(v)   BF_CS1(POWER_DCDC4P2, DROPOUT_CTRL, v)
#endif

//--- Register HW_POWER_DCDC4P2, field ISTEAL_THRESH

#define BP_POWER_DCDC4P2_ISTEAL_THRESH      24
#define BM_POWER_DCDC4P2_ISTEAL_THRESH      0x03000000

#define BF_POWER_DCDC4P2_ISTEAL_THRESH(v)   (((v) << 24) & BM_POWER_DCDC4P2_ISTEAL_THRESH)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_DCDC4P2_ISTEAL_THRESH(v)   BF_CS1(POWER_DCDC4P2, ISTEAL_THRESH, v)
#endif

//--- Register HW_POWER_DCDC4P2, field ENABLE_4P2

#define BP_POWER_DCDC4P2_ENABLE_4P2      23
#define BM_POWER_DCDC4P2_ENABLE_4P2      0x00800000

#define BF_POWER_DCDC4P2_ENABLE_4P2(v)   (((v) << 23) & BM_POWER_DCDC4P2_ENABLE_4P2)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_DCDC4P2_ENABLE_4P2(v)   BF_CS1(POWER_DCDC4P2, ENABLE_4P2, v)
#endif

//--- Register HW_POWER_DCDC4P2, field ENABLE_DCDC

#define BP_POWER_DCDC4P2_ENABLE_DCDC      22
#define BM_POWER_DCDC4P2_ENABLE_DCDC      0x00400000

#define BF_POWER_DCDC4P2_ENABLE_DCDC(v)   (((v) << 22) & BM_POWER_DCDC4P2_ENABLE_DCDC)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_DCDC4P2_ENABLE_DCDC(v)   BF_CS1(POWER_DCDC4P2, ENABLE_DCDC, v)
#endif

//--- Register HW_POWER_DCDC4P2, field HYST_DIR

#define BP_POWER_DCDC4P2_HYST_DIR      21
#define BM_POWER_DCDC4P2_HYST_DIR      0x00200000

#define BF_POWER_DCDC4P2_HYST_DIR(v)   (((v) << 21) & BM_POWER_DCDC4P2_HYST_DIR)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_DCDC4P2_HYST_DIR(v)   BF_CS1(POWER_DCDC4P2, HYST_DIR, v)
#endif

//--- Register HW_POWER_DCDC4P2, field HYST_THRESH

#define BP_POWER_DCDC4P2_HYST_THRESH      20
#define BM_POWER_DCDC4P2_HYST_THRESH      0x00100000

#define BF_POWER_DCDC4P2_HYST_THRESH(v)   (((v) << 20) & BM_POWER_DCDC4P2_HYST_THRESH)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_DCDC4P2_HYST_THRESH(v)   BF_CS1(POWER_DCDC4P2, HYST_THRESH, v)
#endif

//--- Register HW_POWER_DCDC4P2, field TRG

#define BP_POWER_DCDC4P2_TRG      16
#define BM_POWER_DCDC4P2_TRG      0x00070000

#define BF_POWER_DCDC4P2_TRG(v)   (((v) << 16) & BM_POWER_DCDC4P2_TRG)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_DCDC4P2_TRG(v)   BF_CS1(POWER_DCDC4P2, TRG, v)
#endif

//--- Register HW_POWER_DCDC4P2, field BO

#define BP_POWER_DCDC4P2_BO      8
#define BM_POWER_DCDC4P2_BO      0x00001F00

#define BF_POWER_DCDC4P2_BO(v)   (((v) << 8) & BM_POWER_DCDC4P2_BO)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_DCDC4P2_BO(v)   BF_CS1(POWER_DCDC4P2, BO, v)
#endif

//--- Register HW_POWER_DCDC4P2, field CMPTRIP

#define BP_POWER_DCDC4P2_CMPTRIP      0
#define BM_POWER_DCDC4P2_CMPTRIP      0x0000001F

#define BF_POWER_DCDC4P2_CMPTRIP(v)   (((v) << 0) & BM_POWER_DCDC4P2_CMPTRIP)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_DCDC4P2_CMPTRIP(v)   BF_CS1(POWER_DCDC4P2, CMPTRIP, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_POWER_MISC - DC-DC Miscellaneous Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned SEL_PLLCLK    :  1;
        unsigned TEST          :  1;
        unsigned DELAY_TIMING  :  1;
        unsigned RSRVD1        :  1;
        unsigned FREQSEL       :  3;
        unsigned RSRVD2        : 25;
    } B;
} hw_power_misc_t;
#endif


//
// constants & macros for entire HW_POWER_MISC register
//

#define HW_POWER_MISC_ADDR      (REGS_POWER_BASE + 0x00000090)

#ifndef __LANGUAGE_ASM__
#define HW_POWER_MISC           (*(volatile hw_power_misc_t *) HW_POWER_MISC_ADDR)
#define HW_POWER_MISC_RD()      (HW_POWER_MISC.U)
#define HW_POWER_MISC_WR(v)     (HW_POWER_MISC.U = (v))
#define HW_POWER_MISC_SET(v)    (HW_POWER_MISC_WR(HW_POWER_MISC_RD() |  (v)))
#define HW_POWER_MISC_CLR(v)    (HW_POWER_MISC_WR(HW_POWER_MISC_RD() & ~(v)))
#define HW_POWER_MISC_TOG(v)    (HW_POWER_MISC_WR(HW_POWER_MISC_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_POWER_MISC bitfields
//

//--- Register HW_POWER_MISC, field FREQSEL

#define BP_POWER_MISC_FREQSEL      4
#define BM_POWER_MISC_FREQSEL      0x00000070

#define BF_POWER_MISC_FREQSEL(v)   (((v) << 4) & BM_POWER_MISC_FREQSEL)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_MISC_FREQSEL(v)   BF_CS1(POWER_MISC, FREQSEL, v)
#endif

//--- Register HW_POWER_MISC, field RSRVD1

#define BP_POWER_MISC_RSRVD1      3
#define BM_POWER_MISC_RSRVD1      0x00000008

#define BF_POWER_MISC_RSRVD1(v)   (((v) << 3) & BM_POWER_MISC_RSRVD1)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_MISC_RSRVD1(v)   BF_CS1(POWER_MISC, RSRVD1, v)
#endif

//--- Register HW_POWER_MISC, field DELAY_TIMING

#define BP_POWER_MISC_DELAY_TIMING      2
#define BM_POWER_MISC_DELAY_TIMING      0x00000004

#define BF_POWER_MISC_DELAY_TIMING(v)   (((v) << 2) & BM_POWER_MISC_DELAY_TIMING)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_MISC_DELAY_TIMING(v)   BF_CS1(POWER_MISC, DELAY_TIMING, v)
#endif

//--- Register HW_POWER_MISC, field TEST

#define BP_POWER_MISC_TEST      1
#define BM_POWER_MISC_TEST      0x00000002

#define BF_POWER_MISC_TEST(v)   (((v) << 1) & BM_POWER_MISC_TEST)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_MISC_TEST(v)   BF_CS1(POWER_MISC, TEST, v)
#endif

//--- Register HW_POWER_MISC, field SEL_PLLCLK

#define BP_POWER_MISC_SEL_PLLCLK      0
#define BM_POWER_MISC_SEL_PLLCLK      0x00000001

#define BF_POWER_MISC_SEL_PLLCLK(v)   (((v) << 0) & BM_POWER_MISC_SEL_PLLCLK)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_MISC_SEL_PLLCLK(v)   BF_CS1(POWER_MISC, SEL_PLLCLK, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_POWER_DCLIMITS - DC-DC Duty Cycle Limits Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned NEGLIMIT       :  7;
        unsigned RSRVD1         :  1;
        unsigned POSLIMIT_BUCK  :  7;
        unsigned RSRVD2         :  1;
        reg16_t  RSRVD3;
    } B;
} hw_power_dclimits_t;
#endif


//
// constants & macros for entire HW_POWER_DCLIMITS register
//

#define HW_POWER_DCLIMITS_ADDR      (REGS_POWER_BASE + 0x000000A0)

#ifndef __LANGUAGE_ASM__
#define HW_POWER_DCLIMITS           (*(volatile hw_power_dclimits_t *) HW_POWER_DCLIMITS_ADDR)
#define HW_POWER_DCLIMITS_RD()      (HW_POWER_DCLIMITS.U)
#define HW_POWER_DCLIMITS_WR(v)     (HW_POWER_DCLIMITS.U = (v))
#define HW_POWER_DCLIMITS_SET(v)    (HW_POWER_DCLIMITS_WR(HW_POWER_DCLIMITS_RD() |  (v)))
#define HW_POWER_DCLIMITS_CLR(v)    (HW_POWER_DCLIMITS_WR(HW_POWER_DCLIMITS_RD() & ~(v)))
#define HW_POWER_DCLIMITS_TOG(v)    (HW_POWER_DCLIMITS_WR(HW_POWER_DCLIMITS_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_POWER_DCLIMITS bitfields
//

//--- Register HW_POWER_DCLIMITS, field POSLIMIT_BUCK

#define BP_POWER_DCLIMITS_POSLIMIT_BUCK      8
#define BM_POWER_DCLIMITS_POSLIMIT_BUCK      0x00007F00

#define BF_POWER_DCLIMITS_POSLIMIT_BUCK(v)   (((v) << 8) & BM_POWER_DCLIMITS_POSLIMIT_BUCK)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_DCLIMITS_POSLIMIT_BUCK(v)   BF_CS1(POWER_DCLIMITS, POSLIMIT_BUCK, v)
#endif

//--- Register HW_POWER_DCLIMITS, field NEGLIMIT

#define BP_POWER_DCLIMITS_NEGLIMIT      0
#define BM_POWER_DCLIMITS_NEGLIMIT      0x0000007F

#define BF_POWER_DCLIMITS_NEGLIMIT(v)   (((v) << 0) & BM_POWER_DCLIMITS_NEGLIMIT)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_DCLIMITS_NEGLIMIT(v)   BF_CS1(POWER_DCLIMITS, NEGLIMIT, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_POWER_LOOPCTRL - Converter Loop Behavior Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DC_C            :  2;
        unsigned RSRVD1          :  2;
        unsigned DC_R            :  4;
        unsigned DC_FF           :  3;
        unsigned RSRVD2          :  1;
        unsigned EN_RCSCALE      :  2;
        unsigned RCSCALE_THRESH  :  1;
        unsigned DF_HYST_THRESH  :  1;
        unsigned CM_HYST_THRESH  :  1;
        unsigned EN_DF_HYST      :  1;
        unsigned EN_CM_HYST      :  1;
        unsigned HYST_SIGN       :  1;
        unsigned TOGGLE_DIF      :  1;
        unsigned RSRVD3          : 11;
    } B;
} hw_power_loopctrl_t;
#endif


//
// constants & macros for entire HW_POWER_LOOPCTRL register
//

#define HW_POWER_LOOPCTRL_ADDR      (REGS_POWER_BASE + 0x000000B0)
#define HW_POWER_LOOPCTRL_SET_ADDR  (REGS_POWER_BASE + 0x000000B4)
#define HW_POWER_LOOPCTRL_CLR_ADDR  (REGS_POWER_BASE + 0x000000B8)
#define HW_POWER_LOOPCTRL_TOG_ADDR  (REGS_POWER_BASE + 0x000000BC)

#ifndef __LANGUAGE_ASM__
#define HW_POWER_LOOPCTRL           (*(volatile hw_power_loopctrl_t *) HW_POWER_LOOPCTRL_ADDR)
#define HW_POWER_LOOPCTRL_RD()      (HW_POWER_LOOPCTRL.U)
#define HW_POWER_LOOPCTRL_WR(v)     (HW_POWER_LOOPCTRL.U = (v))
#define HW_POWER_LOOPCTRL_SET(v)    ((*(volatile reg32_t *) HW_POWER_LOOPCTRL_SET_ADDR) = (v))
#define HW_POWER_LOOPCTRL_CLR(v)    ((*(volatile reg32_t *) HW_POWER_LOOPCTRL_CLR_ADDR) = (v))
#define HW_POWER_LOOPCTRL_TOG(v)    ((*(volatile reg32_t *) HW_POWER_LOOPCTRL_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_POWER_LOOPCTRL bitfields
//

//--- Register HW_POWER_LOOPCTRL, field TOGGLE_DIF

#define BP_POWER_LOOPCTRL_TOGGLE_DIF      20
#define BM_POWER_LOOPCTRL_TOGGLE_DIF      0x00100000

#define BF_POWER_LOOPCTRL_TOGGLE_DIF(v)   (((v) << 20) & BM_POWER_LOOPCTRL_TOGGLE_DIF)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_LOOPCTRL_TOGGLE_DIF(v)   BF_CS1(POWER_LOOPCTRL, TOGGLE_DIF, v)
#endif

//--- Register HW_POWER_LOOPCTRL, field HYST_SIGN

#define BP_POWER_LOOPCTRL_HYST_SIGN      19
#define BM_POWER_LOOPCTRL_HYST_SIGN      0x00080000

#define BF_POWER_LOOPCTRL_HYST_SIGN(v)   (((v) << 19) & BM_POWER_LOOPCTRL_HYST_SIGN)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_LOOPCTRL_HYST_SIGN(v)   BF_CS1(POWER_LOOPCTRL, HYST_SIGN, v)
#endif

//--- Register HW_POWER_LOOPCTRL, field EN_CM_HYST

#define BP_POWER_LOOPCTRL_EN_CM_HYST      18
#define BM_POWER_LOOPCTRL_EN_CM_HYST      0x00040000

#define BF_POWER_LOOPCTRL_EN_CM_HYST(v)   (((v) << 18) & BM_POWER_LOOPCTRL_EN_CM_HYST)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_LOOPCTRL_EN_CM_HYST(v)   BF_CS1(POWER_LOOPCTRL, EN_CM_HYST, v)
#endif

//--- Register HW_POWER_LOOPCTRL, field EN_DF_HYST

#define BP_POWER_LOOPCTRL_EN_DF_HYST      17
#define BM_POWER_LOOPCTRL_EN_DF_HYST      0x00020000

#define BF_POWER_LOOPCTRL_EN_DF_HYST(v)   (((v) << 17) & BM_POWER_LOOPCTRL_EN_DF_HYST)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_LOOPCTRL_EN_DF_HYST(v)   BF_CS1(POWER_LOOPCTRL, EN_DF_HYST, v)
#endif

//--- Register HW_POWER_LOOPCTRL, field CM_HYST_THRESH

#define BP_POWER_LOOPCTRL_CM_HYST_THRESH      16
#define BM_POWER_LOOPCTRL_CM_HYST_THRESH      0x00010000

#define BF_POWER_LOOPCTRL_CM_HYST_THRESH(v)   (((v) << 16) & BM_POWER_LOOPCTRL_CM_HYST_THRESH)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_LOOPCTRL_CM_HYST_THRESH(v)   BF_CS1(POWER_LOOPCTRL, CM_HYST_THRESH, v)
#endif

//--- Register HW_POWER_LOOPCTRL, field DF_HYST_THRESH

#define BP_POWER_LOOPCTRL_DF_HYST_THRESH      15
#define BM_POWER_LOOPCTRL_DF_HYST_THRESH      0x00008000

#define BF_POWER_LOOPCTRL_DF_HYST_THRESH(v)   (((v) << 15) & BM_POWER_LOOPCTRL_DF_HYST_THRESH)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_LOOPCTRL_DF_HYST_THRESH(v)   BF_CS1(POWER_LOOPCTRL, DF_HYST_THRESH, v)
#endif

//--- Register HW_POWER_LOOPCTRL, field RCSCALE_THRESH

#define BP_POWER_LOOPCTRL_RCSCALE_THRESH      14
#define BM_POWER_LOOPCTRL_RCSCALE_THRESH      0x00004000

#define BF_POWER_LOOPCTRL_RCSCALE_THRESH(v)   (((v) << 14) & BM_POWER_LOOPCTRL_RCSCALE_THRESH)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_LOOPCTRL_RCSCALE_THRESH(v)   BF_CS1(POWER_LOOPCTRL, RCSCALE_THRESH, v)
#endif

//--- Register HW_POWER_LOOPCTRL, field EN_RCSCALE

#define BP_POWER_LOOPCTRL_EN_RCSCALE      12
#define BM_POWER_LOOPCTRL_EN_RCSCALE      0x00003000

#define BF_POWER_LOOPCTRL_EN_RCSCALE(v)   (((v) << 12) & BM_POWER_LOOPCTRL_EN_RCSCALE)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_LOOPCTRL_EN_RCSCALE(v)   BF_CS1(POWER_LOOPCTRL, EN_RCSCALE, v)
#endif

//--- Register HW_POWER_LOOPCTRL, field DC_FF

#define BP_POWER_LOOPCTRL_DC_FF      8
#define BM_POWER_LOOPCTRL_DC_FF      0x00000700

#define BF_POWER_LOOPCTRL_DC_FF(v)   (((v) << 8) & BM_POWER_LOOPCTRL_DC_FF)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_LOOPCTRL_DC_FF(v)   BF_CS1(POWER_LOOPCTRL, DC_FF, v)
#endif

//--- Register HW_POWER_LOOPCTRL, field DC_R

#define BP_POWER_LOOPCTRL_DC_R      4
#define BM_POWER_LOOPCTRL_DC_R      0x000000F0

#define BF_POWER_LOOPCTRL_DC_R(v)   (((v) << 4) & BM_POWER_LOOPCTRL_DC_R)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_LOOPCTRL_DC_R(v)   BF_CS1(POWER_LOOPCTRL, DC_R, v)
#endif

//--- Register HW_POWER_LOOPCTRL, field DC_C

#define BP_POWER_LOOPCTRL_DC_C      0
#define BM_POWER_LOOPCTRL_DC_C      0x00000003

#define BF_POWER_LOOPCTRL_DC_C(v)   (((v) << 0) & BM_POWER_LOOPCTRL_DC_C)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_LOOPCTRL_DC_C(v)   BF_CS1(POWER_LOOPCTRL, DC_C, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_POWER_STS - Power Subsystem Status Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned SESSEND           :  1;
        unsigned VBUSVALID         :  1;
        unsigned BVALID            :  1;
        unsigned AVALID            :  1;
        unsigned VDD5V_DROOP       :  1;
        unsigned VDD5V_GT_VDDIO    :  1;
        unsigned VDDD_BO           :  1;
        unsigned VDDA_BO           :  1;
        unsigned VDDIO_BO          :  1;
        unsigned DC_OK             :  1;
        unsigned DCDC_4P2_BO       :  1;
        unsigned CHRGSTS           :  1;
        unsigned VDD5V_FAULT       :  1;
        unsigned BATT_BO           :  1;
        unsigned SESSEND_STATUS    :  1;
        unsigned VBUSVALID_STATUS  :  1;
        unsigned BVALID_STATUS     :  1;
        unsigned AVALID_STATUS     :  1;
        unsigned RSRVD1            :  2;
        unsigned PSWITCH           :  2;
        unsigned RSRVD2            :  2;
        unsigned PWRUP_SOURCE      :  6;
        unsigned RSRVD3            :  2;
    } B;
} hw_power_sts_t;
#endif


//
// constants & macros for entire HW_POWER_STS register
//

#define HW_POWER_STS_ADDR      (REGS_POWER_BASE + 0x000000C0)

#ifndef __LANGUAGE_ASM__
#define HW_POWER_STS           (*(volatile hw_power_sts_t *) HW_POWER_STS_ADDR)
#define HW_POWER_STS_RD()      (HW_POWER_STS.U)
#define HW_POWER_STS_WR(v)     (HW_POWER_STS.U = (v))
#define HW_POWER_STS_SET(v)    (HW_POWER_STS_WR(HW_POWER_STS_RD() |  (v)))
#define HW_POWER_STS_CLR(v)    (HW_POWER_STS_WR(HW_POWER_STS_RD() & ~(v)))
#define HW_POWER_STS_TOG(v)    (HW_POWER_STS_WR(HW_POWER_STS_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_POWER_STS bitfields
//

//--- Register HW_POWER_STS, field PWRUP_SOURCE

#define BP_POWER_STS_PWRUP_SOURCE      24
#define BM_POWER_STS_PWRUP_SOURCE      0x3F000000

#define BF_POWER_STS_PWRUP_SOURCE(v)   (((v) << 24) & BM_POWER_STS_PWRUP_SOURCE)

//--- Register HW_POWER_STS, field PSWITCH

#define BP_POWER_STS_PSWITCH      20
#define BM_POWER_STS_PSWITCH      0x00300000

#define BF_POWER_STS_PSWITCH(v)   (((v) << 20) & BM_POWER_STS_PSWITCH)

//--- Register HW_POWER_STS, field AVALID_STATUS

#define BP_POWER_STS_AVALID_STATUS      17
#define BM_POWER_STS_AVALID_STATUS      0x00020000

#define BF_POWER_STS_AVALID_STATUS(v)   (((v) << 17) & BM_POWER_STS_AVALID_STATUS)

//--- Register HW_POWER_STS, field BVALID_STATUS

#define BP_POWER_STS_BVALID_STATUS      16
#define BM_POWER_STS_BVALID_STATUS      0x00010000

#define BF_POWER_STS_BVALID_STATUS(v)   (((v) << 16) & BM_POWER_STS_BVALID_STATUS)

//--- Register HW_POWER_STS, field VBUSVALID_STATUS

#define BP_POWER_STS_VBUSVALID_STATUS      15
#define BM_POWER_STS_VBUSVALID_STATUS      0x00008000

#define BF_POWER_STS_VBUSVALID_STATUS(v)   (((v) << 15) & BM_POWER_STS_VBUSVALID_STATUS)

//--- Register HW_POWER_STS, field SESSEND_STATUS

#define BP_POWER_STS_SESSEND_STATUS      14
#define BM_POWER_STS_SESSEND_STATUS      0x00004000

#define BF_POWER_STS_SESSEND_STATUS(v)   (((v) << 14) & BM_POWER_STS_SESSEND_STATUS)

//--- Register HW_POWER_STS, field BATT_BO

#define BP_POWER_STS_BATT_BO      13
#define BM_POWER_STS_BATT_BO      0x00002000

#define BF_POWER_STS_BATT_BO(v)   (((v) << 13) & BM_POWER_STS_BATT_BO)

//--- Register HW_POWER_STS, field VDD5V_FAULT

#define BP_POWER_STS_VDD5V_FAULT      12
#define BM_POWER_STS_VDD5V_FAULT      0x00001000

#define BF_POWER_STS_VDD5V_FAULT(v)   (((v) << 12) & BM_POWER_STS_VDD5V_FAULT)

//--- Register HW_POWER_STS, field CHRGSTS

#define BP_POWER_STS_CHRGSTS      11
#define BM_POWER_STS_CHRGSTS      0x00000800

#define BF_POWER_STS_CHRGSTS(v)   (((v) << 11) & BM_POWER_STS_CHRGSTS)

//--- Register HW_POWER_STS, field DCDC_4P2_BO

#define BP_POWER_STS_DCDC_4P2_BO      10
#define BM_POWER_STS_DCDC_4P2_BO      0x00000400

#define BF_POWER_STS_DCDC_4P2_BO(v)   (((v) << 10) & BM_POWER_STS_DCDC_4P2_BO)

//--- Register HW_POWER_STS, field DC_OK

#define BP_POWER_STS_DC_OK      9
#define BM_POWER_STS_DC_OK      0x00000200

#define BF_POWER_STS_DC_OK(v)   (((v) << 9) & BM_POWER_STS_DC_OK)

//--- Register HW_POWER_STS, field VDDIO_BO

#define BP_POWER_STS_VDDIO_BO      8
#define BM_POWER_STS_VDDIO_BO      0x00000100

#define BF_POWER_STS_VDDIO_BO(v)   (((v) << 8) & BM_POWER_STS_VDDIO_BO)

//--- Register HW_POWER_STS, field VDDA_BO

#define BP_POWER_STS_VDDA_BO      7
#define BM_POWER_STS_VDDA_BO      0x00000080

#define BF_POWER_STS_VDDA_BO(v)   (((v) << 7) & BM_POWER_STS_VDDA_BO)

//--- Register HW_POWER_STS, field VDDD_BO

#define BP_POWER_STS_VDDD_BO      6
#define BM_POWER_STS_VDDD_BO      0x00000040

#define BF_POWER_STS_VDDD_BO(v)   (((v) << 6) & BM_POWER_STS_VDDD_BO)

//--- Register HW_POWER_STS, field VDD5V_GT_VDDIO

#define BP_POWER_STS_VDD5V_GT_VDDIO      5
#define BM_POWER_STS_VDD5V_GT_VDDIO      0x00000020

#define BF_POWER_STS_VDD5V_GT_VDDIO(v)   (((v) << 5) & BM_POWER_STS_VDD5V_GT_VDDIO)

//--- Register HW_POWER_STS, field VDD5V_DROOP

#define BP_POWER_STS_VDD5V_DROOP      4
#define BM_POWER_STS_VDD5V_DROOP      0x00000010

#define BF_POWER_STS_VDD5V_DROOP(v)   (((v) << 4) & BM_POWER_STS_VDD5V_DROOP)

//--- Register HW_POWER_STS, field AVALID

#define BP_POWER_STS_AVALID      3
#define BM_POWER_STS_AVALID      0x00000008

#define BF_POWER_STS_AVALID(v)   (((v) << 3) & BM_POWER_STS_AVALID)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_STS_AVALID(v)   BF_CS1(POWER_STS, AVALID, v)
#endif

//--- Register HW_POWER_STS, field BVALID

#define BP_POWER_STS_BVALID      2
#define BM_POWER_STS_BVALID      0x00000004

#define BF_POWER_STS_BVALID(v)   (((v) << 2) & BM_POWER_STS_BVALID)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_STS_BVALID(v)   BF_CS1(POWER_STS, BVALID, v)
#endif

//--- Register HW_POWER_STS, field VBUSVALID

#define BP_POWER_STS_VBUSVALID      1
#define BM_POWER_STS_VBUSVALID      0x00000002

#define BF_POWER_STS_VBUSVALID(v)   (((v) << 1) & BM_POWER_STS_VBUSVALID)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_STS_VBUSVALID(v)   BF_CS1(POWER_STS, VBUSVALID, v)
#endif

//--- Register HW_POWER_STS, field SESSEND

#define BP_POWER_STS_SESSEND      0
#define BM_POWER_STS_SESSEND      0x00000001

#define BF_POWER_STS_SESSEND(v)   (((v) << 0) & BM_POWER_STS_SESSEND)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_STS_SESSEND(v)   BF_CS1(POWER_STS, SESSEND, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_POWER_SPEED - Transistor Speed Control and Status Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned CTRL    :  2;
        unsigned RSRVD0  : 14;
        reg8_t   STATUS;
        reg8_t   RSRVD1;
    } B;
} hw_power_speed_t;
#endif


//
// constants & macros for entire HW_POWER_SPEED register
//

#define HW_POWER_SPEED_ADDR      (REGS_POWER_BASE + 0x000000D0)
#define HW_POWER_SPEED_SET_ADDR  (REGS_POWER_BASE + 0x000000D4)
#define HW_POWER_SPEED_CLR_ADDR  (REGS_POWER_BASE + 0x000000D8)
#define HW_POWER_SPEED_TOG_ADDR  (REGS_POWER_BASE + 0x000000DC)

#ifndef __LANGUAGE_ASM__
#define HW_POWER_SPEED           (*(volatile hw_power_speed_t *) HW_POWER_SPEED_ADDR)
#define HW_POWER_SPEED_RD()      (HW_POWER_SPEED.U)
#define HW_POWER_SPEED_WR(v)     (HW_POWER_SPEED.U = (v))
#define HW_POWER_SPEED_SET(v)    ((*(volatile reg32_t *) HW_POWER_SPEED_SET_ADDR) = (v))
#define HW_POWER_SPEED_CLR(v)    ((*(volatile reg32_t *) HW_POWER_SPEED_CLR_ADDR) = (v))
#define HW_POWER_SPEED_TOG(v)    ((*(volatile reg32_t *) HW_POWER_SPEED_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_POWER_SPEED bitfields
//

//--- Register HW_POWER_SPEED, field STATUS

#define BP_POWER_SPEED_STATUS      16
#define BM_POWER_SPEED_STATUS      0x00FF0000

#define BF_POWER_SPEED_STATUS(v)   (((v) << 16) & BM_POWER_SPEED_STATUS)

//--- Register HW_POWER_SPEED, field CTRL

#define BP_POWER_SPEED_CTRL      0
#define BM_POWER_SPEED_CTRL      0x00000003

#define BF_POWER_SPEED_CTRL(v)   (((v) << 0) & BM_POWER_SPEED_CTRL)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_SPEED_CTRL(v)   BF_CS1(POWER_SPEED, CTRL, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_POWER_BATTMONITOR - Battery Level Monitor Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BRWNOUT_LVL      :  5;
        unsigned RSRVD1           :  3;
        unsigned BRWNOUT_PWD      :  1;
        unsigned PWDN_BATTBRNOUT  :  1;
        unsigned EN_BATADJ        :  1;
        unsigned RSRVD2           :  5;
        unsigned BATT_VAL         : 10;
        unsigned RSRVD3           :  6;
    } B;
} hw_power_battmonitor_t;
#endif


//
// constants & macros for entire HW_POWER_BATTMONITOR register
//

#define HW_POWER_BATTMONITOR_ADDR      (REGS_POWER_BASE + 0x000000E0)

#ifndef __LANGUAGE_ASM__
#define HW_POWER_BATTMONITOR           (*(volatile hw_power_battmonitor_t *) HW_POWER_BATTMONITOR_ADDR)
#define HW_POWER_BATTMONITOR_RD()      (HW_POWER_BATTMONITOR.U)
#define HW_POWER_BATTMONITOR_WR(v)     (HW_POWER_BATTMONITOR.U = (v))
#define HW_POWER_BATTMONITOR_SET(v)    (HW_POWER_BATTMONITOR_WR(HW_POWER_BATTMONITOR_RD() |  (v)))
#define HW_POWER_BATTMONITOR_CLR(v)    (HW_POWER_BATTMONITOR_WR(HW_POWER_BATTMONITOR_RD() & ~(v)))
#define HW_POWER_BATTMONITOR_TOG(v)    (HW_POWER_BATTMONITOR_WR(HW_POWER_BATTMONITOR_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_POWER_BATTMONITOR bitfields
//

//--- Register HW_POWER_BATTMONITOR, field BATT_VAL

#define BP_POWER_BATTMONITOR_BATT_VAL      16
#define BM_POWER_BATTMONITOR_BATT_VAL      0x03FF0000

#define BF_POWER_BATTMONITOR_BATT_VAL(v)   (((v) << 16) & BM_POWER_BATTMONITOR_BATT_VAL)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_BATTMONITOR_BATT_VAL(v)   BF_CS1(POWER_BATTMONITOR, BATT_VAL, v)
#endif

//--- Register HW_POWER_BATTMONITOR, field EN_BATADJ

#define BP_POWER_BATTMONITOR_EN_BATADJ      10
#define BM_POWER_BATTMONITOR_EN_BATADJ      0x00000400

#define BF_POWER_BATTMONITOR_EN_BATADJ(v)   (((v) << 10) & BM_POWER_BATTMONITOR_EN_BATADJ)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_BATTMONITOR_EN_BATADJ(v)   BF_CS1(POWER_BATTMONITOR, EN_BATADJ, v)
#endif

//--- Register HW_POWER_BATTMONITOR, field PWDN_BATTBRNOUT

#define BP_POWER_BATTMONITOR_PWDN_BATTBRNOUT      9
#define BM_POWER_BATTMONITOR_PWDN_BATTBRNOUT      0x00000200

#define BF_POWER_BATTMONITOR_PWDN_BATTBRNOUT(v)   (((v) << 9) & BM_POWER_BATTMONITOR_PWDN_BATTBRNOUT)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_BATTMONITOR_PWDN_BATTBRNOUT(v)   BF_CS1(POWER_BATTMONITOR, PWDN_BATTBRNOUT, v)
#endif

//--- Register HW_POWER_BATTMONITOR, field BRWNOUT_PWD

#define BP_POWER_BATTMONITOR_BRWNOUT_PWD      8
#define BM_POWER_BATTMONITOR_BRWNOUT_PWD      0x00000100

#define BF_POWER_BATTMONITOR_BRWNOUT_PWD(v)   (((v) << 8) & BM_POWER_BATTMONITOR_BRWNOUT_PWD)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_BATTMONITOR_BRWNOUT_PWD(v)   BF_CS1(POWER_BATTMONITOR, BRWNOUT_PWD, v)
#endif

//--- Register HW_POWER_BATTMONITOR, field BRWNOUT_LVL

#define BP_POWER_BATTMONITOR_BRWNOUT_LVL      0
#define BM_POWER_BATTMONITOR_BRWNOUT_LVL      0x0000001F

#define BF_POWER_BATTMONITOR_BRWNOUT_LVL(v)   (((v) << 0) & BM_POWER_BATTMONITOR_BRWNOUT_LVL)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_BATTMONITOR_BRWNOUT_LVL(v)   BF_CS1(POWER_BATTMONITOR, BRWNOUT_LVL, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_POWER_RESET - Power Module Reset Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PWD      :  1;
        unsigned PWD_OFF  :  1;
        unsigned RSRVD1   : 14;
        reg16_t  UNLOCK;
    } B;
} hw_power_reset_t;
#endif


//
// constants & macros for entire HW_POWER_RESET register
//

#define HW_POWER_RESET_ADDR      (REGS_POWER_BASE + 0x00000100)
#define HW_POWER_RESET_SET_ADDR  (REGS_POWER_BASE + 0x00000104)
#define HW_POWER_RESET_CLR_ADDR  (REGS_POWER_BASE + 0x00000108)
#define HW_POWER_RESET_TOG_ADDR  (REGS_POWER_BASE + 0x0000010C)

#ifndef __LANGUAGE_ASM__
#define HW_POWER_RESET           (*(volatile hw_power_reset_t *) HW_POWER_RESET_ADDR)
#define HW_POWER_RESET_RD()      (HW_POWER_RESET.U)
#define HW_POWER_RESET_WR(v)     (HW_POWER_RESET.U = (v))
#define HW_POWER_RESET_SET(v)    ((*(volatile reg32_t *) HW_POWER_RESET_SET_ADDR) = (v))
#define HW_POWER_RESET_CLR(v)    ((*(volatile reg32_t *) HW_POWER_RESET_CLR_ADDR) = (v))
#define HW_POWER_RESET_TOG(v)    ((*(volatile reg32_t *) HW_POWER_RESET_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_POWER_RESET bitfields
//

//--- Register HW_POWER_RESET, field UNLOCK

#define BP_POWER_RESET_UNLOCK      16
#define BM_POWER_RESET_UNLOCK      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_POWER_RESET_UNLOCK(v)   ((((reg32_t) v) << 16) & BM_POWER_RESET_UNLOCK)
#else
#define BF_POWER_RESET_UNLOCK(v)   (((v) << 16) & BM_POWER_RESET_UNLOCK)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_POWER_RESET_UNLOCK(v)   (HW_POWER_RESET.B.UNLOCK = (v))
#endif

#define BV_POWER_RESET_UNLOCK__KEY  0x3E77

//--- Register HW_POWER_RESET, field PWD_OFF

#define BP_POWER_RESET_PWD_OFF      1
#define BM_POWER_RESET_PWD_OFF      0x00000002

#define BF_POWER_RESET_PWD_OFF(v)   (((v) << 1) & BM_POWER_RESET_PWD_OFF)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_RESET_PWD_OFF(v)   BF_CS1(POWER_RESET, PWD_OFF, v)
#endif

//--- Register HW_POWER_RESET, field PWD

#define BP_POWER_RESET_PWD      0
#define BM_POWER_RESET_PWD      0x00000001

#define BF_POWER_RESET_PWD(v)   (((v) << 0) & BM_POWER_RESET_PWD)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_RESET_PWD(v)   BF_CS1(POWER_RESET, PWD, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_POWER_DEBUG - Power Module Debug Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned SESSENDPIOLOCK    :  1;
        unsigned BVALIDPIOLOCK     :  1;
        unsigned AVALIDPIOLOCK     :  1;
        unsigned VBUSVALIDPIOLOCK  :  1;
        unsigned RSRVD0            : 28;
    } B;
} hw_power_debug_t;
#endif


//
// constants & macros for entire HW_POWER_DEBUG register
//

#define HW_POWER_DEBUG_ADDR      (REGS_POWER_BASE + 0x00000110)
#define HW_POWER_DEBUG_SET_ADDR  (REGS_POWER_BASE + 0x00000114)
#define HW_POWER_DEBUG_CLR_ADDR  (REGS_POWER_BASE + 0x00000118)
#define HW_POWER_DEBUG_TOG_ADDR  (REGS_POWER_BASE + 0x0000011C)

#ifndef __LANGUAGE_ASM__
#define HW_POWER_DEBUG           (*(volatile hw_power_debug_t *) HW_POWER_DEBUG_ADDR)
#define HW_POWER_DEBUG_RD()      (HW_POWER_DEBUG.U)
#define HW_POWER_DEBUG_WR(v)     (HW_POWER_DEBUG.U = (v))
#define HW_POWER_DEBUG_SET(v)    ((*(volatile reg32_t *) HW_POWER_DEBUG_SET_ADDR) = (v))
#define HW_POWER_DEBUG_CLR(v)    ((*(volatile reg32_t *) HW_POWER_DEBUG_CLR_ADDR) = (v))
#define HW_POWER_DEBUG_TOG(v)    ((*(volatile reg32_t *) HW_POWER_DEBUG_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_POWER_DEBUG bitfields
//

//--- Register HW_POWER_DEBUG, field VBUSVALIDPIOLOCK

#define BP_POWER_DEBUG_VBUSVALIDPIOLOCK      3
#define BM_POWER_DEBUG_VBUSVALIDPIOLOCK      0x00000008

#define BF_POWER_DEBUG_VBUSVALIDPIOLOCK(v)   (((v) << 3) & BM_POWER_DEBUG_VBUSVALIDPIOLOCK)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_DEBUG_VBUSVALIDPIOLOCK(v)   BF_CS1(POWER_DEBUG, VBUSVALIDPIOLOCK, v)
#endif

//--- Register HW_POWER_DEBUG, field AVALIDPIOLOCK

#define BP_POWER_DEBUG_AVALIDPIOLOCK      2
#define BM_POWER_DEBUG_AVALIDPIOLOCK      0x00000004

#define BF_POWER_DEBUG_AVALIDPIOLOCK(v)   (((v) << 2) & BM_POWER_DEBUG_AVALIDPIOLOCK)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_DEBUG_AVALIDPIOLOCK(v)   BF_CS1(POWER_DEBUG, AVALIDPIOLOCK, v)
#endif

//--- Register HW_POWER_DEBUG, field BVALIDPIOLOCK

#define BP_POWER_DEBUG_BVALIDPIOLOCK      1
#define BM_POWER_DEBUG_BVALIDPIOLOCK      0x00000002

#define BF_POWER_DEBUG_BVALIDPIOLOCK(v)   (((v) << 1) & BM_POWER_DEBUG_BVALIDPIOLOCK)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_DEBUG_BVALIDPIOLOCK(v)   BF_CS1(POWER_DEBUG, BVALIDPIOLOCK, v)
#endif

//--- Register HW_POWER_DEBUG, field SESSENDPIOLOCK

#define BP_POWER_DEBUG_SESSENDPIOLOCK      0
#define BM_POWER_DEBUG_SESSENDPIOLOCK      0x00000001

#define BF_POWER_DEBUG_SESSENDPIOLOCK(v)   (((v) << 0) & BM_POWER_DEBUG_SESSENDPIOLOCK)

#ifndef __LANGUAGE_ASM__
#define BW_POWER_DEBUG_SESSENDPIOLOCK(v)   BF_CS1(POWER_DEBUG, SESSENDPIOLOCK, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_POWER_SPECIAL - Power Module Special Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  TEST;
    } B;
} hw_power_special_t;
#endif


//
// constants & macros for entire HW_POWER_SPECIAL register
//

#define HW_POWER_SPECIAL_ADDR      (REGS_POWER_BASE + 0x00000120)
#define HW_POWER_SPECIAL_SET_ADDR  (REGS_POWER_BASE + 0x00000124)
#define HW_POWER_SPECIAL_CLR_ADDR  (REGS_POWER_BASE + 0x00000128)
#define HW_POWER_SPECIAL_TOG_ADDR  (REGS_POWER_BASE + 0x0000012C)

#ifndef __LANGUAGE_ASM__
#define HW_POWER_SPECIAL           (*(volatile hw_power_special_t *) HW_POWER_SPECIAL_ADDR)
#define HW_POWER_SPECIAL_RD()      (HW_POWER_SPECIAL.U)
#define HW_POWER_SPECIAL_WR(v)     (HW_POWER_SPECIAL.U = (v))
#define HW_POWER_SPECIAL_SET(v)    ((*(volatile reg32_t *) HW_POWER_SPECIAL_SET_ADDR) = (v))
#define HW_POWER_SPECIAL_CLR(v)    ((*(volatile reg32_t *) HW_POWER_SPECIAL_CLR_ADDR) = (v))
#define HW_POWER_SPECIAL_TOG(v)    ((*(volatile reg32_t *) HW_POWER_SPECIAL_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_POWER_SPECIAL bitfields
//

//--- Register HW_POWER_SPECIAL, field TEST

#define BP_POWER_SPECIAL_TEST      0
#define BM_POWER_SPECIAL_TEST      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_POWER_SPECIAL_TEST(v)   ((reg32_t) v)
#else
#define BF_POWER_SPECIAL_TEST(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_POWER_SPECIAL_TEST(v)   (HW_POWER_SPECIAL.B.TEST = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_POWER_VERSION - Power Module Version Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg16_t  STEP;
        reg8_t   MINOR;
        reg8_t   MAJOR;
    } B;
} hw_power_version_t;
#endif


//
// constants & macros for entire HW_POWER_VERSION register
//

#define HW_POWER_VERSION_ADDR      (REGS_POWER_BASE + 0x00000130)

#ifndef __LANGUAGE_ASM__
#define HW_POWER_VERSION           (*(volatile hw_power_version_t *) HW_POWER_VERSION_ADDR)
#define HW_POWER_VERSION_RD()      (HW_POWER_VERSION.U)
#endif


//
// constants & macros for individual HW_POWER_VERSION bitfields
//

//--- Register HW_POWER_VERSION, field MAJOR

#define BP_POWER_VERSION_MAJOR      24
#define BM_POWER_VERSION_MAJOR      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_POWER_VERSION_MAJOR(v)   ((((reg32_t) v) << 24) & BM_POWER_VERSION_MAJOR)
#else
#define BF_POWER_VERSION_MAJOR(v)   (((v) << 24) & BM_POWER_VERSION_MAJOR)
#endif

//--- Register HW_POWER_VERSION, field MINOR

#define BP_POWER_VERSION_MINOR      16
#define BM_POWER_VERSION_MINOR      0x00FF0000

#define BF_POWER_VERSION_MINOR(v)   (((v) << 16) & BM_POWER_VERSION_MINOR)

//--- Register HW_POWER_VERSION, field STEP

#define BP_POWER_VERSION_STEP      0
#define BM_POWER_VERSION_STEP      0x0000FFFF

#define BF_POWER_VERSION_STEP(v)   (((v) << 0) & BM_POWER_VERSION_STEP)


#endif // _REGSPOWER_H

////////////////////////////////////////////////////////////////////////////////
