/*
 * Copyright 2009 Freescale Semiconductor, Inc. All Rights Reserved.
 */

/*
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */
////////////////////////////////////////////////////////////////////////////////
//
// WARNING!  THIS FILE IS AUTOMATICALLY GENERATED FROM XML.
//                DO NOT MODIFY THIS FILE DIRECTLY.
//
////////////////////////////////////////////////////////////////////////////////
//
// The following naming conventions are followed in this file.
//      XX_<module>_<regname>_<field>
//
// XX specifies the define / macro class
//      HW pertains to a register
//      BM indicates a Bit Mask
//      BF indicates a Bit Field macro
//
// <module> is the hardware module name which can be any of the following...
//      USB20 (Note when there is more than one copy of a given module, the
//      module name includes a number starting from 0 for the first instance
//      of that module)
//
// <regname> is the specific register within that module
//
// <field> is the specific bitfield within that <module>_<register>
//
// We also define the following...
//      hw_<module>_<regname>_t is typedef of anonymous union
//
////////////////////////////////////////////////////////////////////////////////

#ifndef _REGSSY_H
#define _REGSSY_H  1

#include "regs.h"

#ifndef REGS_SY_BASE
#define REGS_SY_BASE (REGS_BASE + 0x000D0000)
#endif

////////////////////////////////////////////////////////////////////////////////
//// HW_SY_CTRL - SY IP CONTROL Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_sy_ctrl_t;
#endif


//
// constants & macros for entire HW_SY_CTRL register
//

#define HW_SY_CTRL_ADDR      (REGS_SY_BASE + 0x00000000)

#ifndef __LANGUAGE_ASM__
#define HW_SY_CTRL           (*(volatile hw_sy_ctrl_t *) HW_SY_CTRL_ADDR)
#define HW_SY_CTRL_RD()      (HW_SY_CTRL.U)
#define HW_SY_CTRL_WR(v)     (HW_SY_CTRL.U = (v))
#define HW_SY_CTRL_SET(v)    (HW_SY_CTRL_WR(HW_SY_CTRL_RD() |  (v)))
#define HW_SY_CTRL_CLR(v)    (HW_SY_CTRL_WR(HW_SY_CTRL_RD() & ~(v)))
#define HW_SY_CTRL_TOG(v)    (HW_SY_CTRL_WR(HW_SY_CTRL_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_SY_CTRL bitfields
//

//--- Register HW_SY_CTRL, field DATA

#define BP_SY_CTRL_DATA      0
#define BM_SY_CTRL_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SY_CTRL_DATA(v)   ((reg32_t) v)
#else
#define BF_SY_CTRL_DATA(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_SY_CTRL_DATA(v)   (HW_SY_CTRL.B.DATA = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SY_REG1 - SY IP Register 1
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_sy_reg1_t;
#endif


//
// constants & macros for entire HW_SY_REG1 register
//

#define HW_SY_REG1_ADDR      (REGS_SY_BASE + 0x00000008)

#ifndef __LANGUAGE_ASM__
#define HW_SY_REG1           (*(volatile hw_sy_reg1_t *) HW_SY_REG1_ADDR)
#define HW_SY_REG1_RD()      (HW_SY_REG1.U)
#define HW_SY_REG1_WR(v)     (HW_SY_REG1.U = (v))
#define HW_SY_REG1_SET(v)    (HW_SY_REG1_WR(HW_SY_REG1_RD() |  (v)))
#define HW_SY_REG1_CLR(v)    (HW_SY_REG1_WR(HW_SY_REG1_RD() & ~(v)))
#define HW_SY_REG1_TOG(v)    (HW_SY_REG1_WR(HW_SY_REG1_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_SY_REG1 bitfields
//

//--- Register HW_SY_REG1, field DATA

#define BP_SY_REG1_DATA      0
#define BM_SY_REG1_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SY_REG1_DATA(v)   ((reg32_t) v)
#else
#define BF_SY_REG1_DATA(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_SY_REG1_DATA(v)   (HW_SY_REG1.B.DATA = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SY_REG2 - SY IP Register 2
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_sy_reg2_t;
#endif


//
// constants & macros for entire HW_SY_REG2 register
//

#define HW_SY_REG2_ADDR      (REGS_SY_BASE + 0x00000010)

#ifndef __LANGUAGE_ASM__
#define HW_SY_REG2           (*(volatile hw_sy_reg2_t *) HW_SY_REG2_ADDR)
#define HW_SY_REG2_RD()      (HW_SY_REG2.U)
#define HW_SY_REG2_WR(v)     (HW_SY_REG2.U = (v))
#define HW_SY_REG2_SET(v)    (HW_SY_REG2_WR(HW_SY_REG2_RD() |  (v)))
#define HW_SY_REG2_CLR(v)    (HW_SY_REG2_WR(HW_SY_REG2_RD() & ~(v)))
#define HW_SY_REG2_TOG(v)    (HW_SY_REG2_WR(HW_SY_REG2_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_SY_REG2 bitfields
//

//--- Register HW_SY_REG2, field DATA

#define BP_SY_REG2_DATA      0
#define BM_SY_REG2_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SY_REG2_DATA(v)   ((reg32_t) v)
#else
#define BF_SY_REG2_DATA(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_SY_REG2_DATA(v)   (HW_SY_REG2.B.DATA = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SY_REG3 - SY IP Register 3
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_sy_reg3_t;
#endif


//
// constants & macros for entire HW_SY_REG3 register
//

#define HW_SY_REG3_ADDR      (REGS_SY_BASE + 0x00000018)

#ifndef __LANGUAGE_ASM__
#define HW_SY_REG3           (*(volatile hw_sy_reg3_t *) HW_SY_REG3_ADDR)
#define HW_SY_REG3_RD()      (HW_SY_REG3.U)
#endif


//
// constants & macros for individual HW_SY_REG3 bitfields
//

//--- Register HW_SY_REG3, field DATA

#define BP_SY_REG3_DATA      0
#define BM_SY_REG3_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SY_REG3_DATA(v)   ((reg32_t) v)
#else
#define BF_SY_REG3_DATA(v)   (v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SY_REG4 - SY IP Register 4
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_sy_reg4_t;
#endif


//
// constants & macros for entire HW_SY_REG4 register
//

#define HW_SY_REG4_ADDR      (REGS_SY_BASE + 0x00000020)

#ifndef __LANGUAGE_ASM__
#define HW_SY_REG4           (*(volatile hw_sy_reg4_t *) HW_SY_REG4_ADDR)
#define HW_SY_REG4_RD()      (HW_SY_REG4.U)
#define HW_SY_REG4_WR(v)     (HW_SY_REG4.U = (v))
#define HW_SY_REG4_SET(v)    (HW_SY_REG4_WR(HW_SY_REG4_RD() |  (v)))
#define HW_SY_REG4_CLR(v)    (HW_SY_REG4_WR(HW_SY_REG4_RD() & ~(v)))
#define HW_SY_REG4_TOG(v)    (HW_SY_REG4_WR(HW_SY_REG4_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_SY_REG4 bitfields
//

//--- Register HW_SY_REG4, field DATA

#define BP_SY_REG4_DATA      0
#define BM_SY_REG4_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SY_REG4_DATA(v)   ((reg32_t) v)
#else
#define BF_SY_REG4_DATA(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_SY_REG4_DATA(v)   (HW_SY_REG4.B.DATA = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SY_REG5 - SY IP Register 5
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_sy_reg5_t;
#endif


//
// constants & macros for entire HW_SY_REG5 register
//

#define HW_SY_REG5_ADDR      (REGS_SY_BASE + 0x00000028)

#ifndef __LANGUAGE_ASM__
#define HW_SY_REG5           (*(volatile hw_sy_reg5_t *) HW_SY_REG5_ADDR)
#define HW_SY_REG5_RD()      (HW_SY_REG5.U)
#define HW_SY_REG5_WR(v)     (HW_SY_REG5.U = (v))
#define HW_SY_REG5_SET(v)    (HW_SY_REG5_WR(HW_SY_REG5_RD() |  (v)))
#define HW_SY_REG5_CLR(v)    (HW_SY_REG5_WR(HW_SY_REG5_RD() & ~(v)))
#define HW_SY_REG5_TOG(v)    (HW_SY_REG5_WR(HW_SY_REG5_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_SY_REG5 bitfields
//

//--- Register HW_SY_REG5, field DATA

#define BP_SY_REG5_DATA      0
#define BM_SY_REG5_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SY_REG5_DATA(v)   ((reg32_t) v)
#else
#define BF_SY_REG5_DATA(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_SY_REG5_DATA(v)   (HW_SY_REG5.B.DATA = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SY_REG6 - SY IP Register 6
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_sy_reg6_t;
#endif


//
// constants & macros for entire HW_SY_REG6 register
//

#define HW_SY_REG6_ADDR      (REGS_SY_BASE + 0x00000030)

#ifndef __LANGUAGE_ASM__
#define HW_SY_REG6           (*(volatile hw_sy_reg6_t *) HW_SY_REG6_ADDR)
#define HW_SY_REG6_RD()      (HW_SY_REG6.U)
#endif


//
// constants & macros for individual HW_SY_REG6 bitfields
//

//--- Register HW_SY_REG6, field DATA

#define BP_SY_REG6_DATA      0
#define BM_SY_REG6_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SY_REG6_DATA(v)   ((reg32_t) v)
#else
#define BF_SY_REG6_DATA(v)   (v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SY_REG7 - SY IP Register 7
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_sy_reg7_t;
#endif


//
// constants & macros for entire HW_SY_REG7 register
//

#define HW_SY_REG7_ADDR      (REGS_SY_BASE + 0x00000038)

#ifndef __LANGUAGE_ASM__
#define HW_SY_REG7           (*(volatile hw_sy_reg7_t *) HW_SY_REG7_ADDR)
#define HW_SY_REG7_RD()      (HW_SY_REG7.U)
#define HW_SY_REG7_WR(v)     (HW_SY_REG7.U = (v))
#define HW_SY_REG7_SET(v)    (HW_SY_REG7_WR(HW_SY_REG7_RD() |  (v)))
#define HW_SY_REG7_CLR(v)    (HW_SY_REG7_WR(HW_SY_REG7_RD() & ~(v)))
#define HW_SY_REG7_TOG(v)    (HW_SY_REG7_WR(HW_SY_REG7_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_SY_REG7 bitfields
//

//--- Register HW_SY_REG7, field DATA

#define BP_SY_REG7_DATA      0
#define BM_SY_REG7_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SY_REG7_DATA(v)   ((reg32_t) v)
#else
#define BF_SY_REG7_DATA(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_SY_REG7_DATA(v)   (HW_SY_REG7.B.DATA = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SY_REG8 - SY IP Register 8
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_sy_reg8_t;
#endif


//
// constants & macros for entire HW_SY_REG8 register
//

#define HW_SY_REG8_ADDR      (REGS_SY_BASE + 0x00000040)

#ifndef __LANGUAGE_ASM__
#define HW_SY_REG8           (*(volatile hw_sy_reg8_t *) HW_SY_REG8_ADDR)
#define HW_SY_REG8_RD()      (HW_SY_REG8.U)
#define HW_SY_REG8_WR(v)     (HW_SY_REG8.U = (v))
#define HW_SY_REG8_SET(v)    (HW_SY_REG8_WR(HW_SY_REG8_RD() |  (v)))
#define HW_SY_REG8_CLR(v)    (HW_SY_REG8_WR(HW_SY_REG8_RD() & ~(v)))
#define HW_SY_REG8_TOG(v)    (HW_SY_REG8_WR(HW_SY_REG8_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_SY_REG8 bitfields
//

//--- Register HW_SY_REG8, field DATA

#define BP_SY_REG8_DATA      0
#define BM_SY_REG8_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SY_REG8_DATA(v)   ((reg32_t) v)
#else
#define BF_SY_REG8_DATA(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_SY_REG8_DATA(v)   (HW_SY_REG8.B.DATA = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SY_REG9 - SY IP Register 9
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_sy_reg9_t;
#endif


//
// constants & macros for entire HW_SY_REG9 register
//

#define HW_SY_REG9_ADDR      (REGS_SY_BASE + 0x00000048)

#ifndef __LANGUAGE_ASM__
#define HW_SY_REG9           (*(volatile hw_sy_reg9_t *) HW_SY_REG9_ADDR)
#define HW_SY_REG9_RD()      (HW_SY_REG9.U)
#define HW_SY_REG9_WR(v)     (HW_SY_REG9.U = (v))
#define HW_SY_REG9_SET(v)    (HW_SY_REG9_WR(HW_SY_REG9_RD() |  (v)))
#define HW_SY_REG9_CLR(v)    (HW_SY_REG9_WR(HW_SY_REG9_RD() & ~(v)))
#define HW_SY_REG9_TOG(v)    (HW_SY_REG9_WR(HW_SY_REG9_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_SY_REG9 bitfields
//

//--- Register HW_SY_REG9, field DATA

#define BP_SY_REG9_DATA      0
#define BM_SY_REG9_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SY_REG9_DATA(v)   ((reg32_t) v)
#else
#define BF_SY_REG9_DATA(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_SY_REG9_DATA(v)   (HW_SY_REG9.B.DATA = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SY_REG10 - SY IP Register 10
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_sy_reg10_t;
#endif


//
// constants & macros for entire HW_SY_REG10 register
//

#define HW_SY_REG10_ADDR      (REGS_SY_BASE + 0x00000050)

#ifndef __LANGUAGE_ASM__
#define HW_SY_REG10           (*(volatile hw_sy_reg10_t *) HW_SY_REG10_ADDR)
#define HW_SY_REG10_RD()      (HW_SY_REG10.U)
#define HW_SY_REG10_WR(v)     (HW_SY_REG10.U = (v))
#define HW_SY_REG10_SET(v)    (HW_SY_REG10_WR(HW_SY_REG10_RD() |  (v)))
#define HW_SY_REG10_CLR(v)    (HW_SY_REG10_WR(HW_SY_REG10_RD() & ~(v)))
#define HW_SY_REG10_TOG(v)    (HW_SY_REG10_WR(HW_SY_REG10_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_SY_REG10 bitfields
//

//--- Register HW_SY_REG10, field DATA

#define BP_SY_REG10_DATA      0
#define BM_SY_REG10_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SY_REG10_DATA(v)   ((reg32_t) v)
#else
#define BF_SY_REG10_DATA(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_SY_REG10_DATA(v)   (HW_SY_REG10.B.DATA = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SY_REG11 - SY IP Register 11
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_sy_reg11_t;
#endif


//
// constants & macros for entire HW_SY_REG11 register
//

#define HW_SY_REG11_ADDR      (REGS_SY_BASE + 0x00000054)

#ifndef __LANGUAGE_ASM__
#define HW_SY_REG11           (*(volatile hw_sy_reg11_t *) HW_SY_REG11_ADDR)
#define HW_SY_REG11_RD()      (HW_SY_REG11.U)
#define HW_SY_REG11_WR(v)     (HW_SY_REG11.U = (v))
#define HW_SY_REG11_SET(v)    (HW_SY_REG11_WR(HW_SY_REG11_RD() |  (v)))
#define HW_SY_REG11_CLR(v)    (HW_SY_REG11_WR(HW_SY_REG11_RD() & ~(v)))
#define HW_SY_REG11_TOG(v)    (HW_SY_REG11_WR(HW_SY_REG11_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_SY_REG11 bitfields
//

//--- Register HW_SY_REG11, field DATA

#define BP_SY_REG11_DATA      0
#define BM_SY_REG11_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SY_REG11_DATA(v)   ((reg32_t) v)
#else
#define BF_SY_REG11_DATA(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_SY_REG11_DATA(v)   (HW_SY_REG11.B.DATA = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SY_REG12 - SY IP Register 12
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_sy_reg12_t;
#endif


//
// constants & macros for entire HW_SY_REG12 register
//

#define HW_SY_REG12_ADDR      (REGS_SY_BASE + 0x00000058)

#ifndef __LANGUAGE_ASM__
#define HW_SY_REG12           (*(volatile hw_sy_reg12_t *) HW_SY_REG12_ADDR)
#define HW_SY_REG12_RD()      (HW_SY_REG12.U)
#define HW_SY_REG12_WR(v)     (HW_SY_REG12.U = (v))
#define HW_SY_REG12_SET(v)    (HW_SY_REG12_WR(HW_SY_REG12_RD() |  (v)))
#define HW_SY_REG12_CLR(v)    (HW_SY_REG12_WR(HW_SY_REG12_RD() & ~(v)))
#define HW_SY_REG12_TOG(v)    (HW_SY_REG12_WR(HW_SY_REG12_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_SY_REG12 bitfields
//

//--- Register HW_SY_REG12, field DATA

#define BP_SY_REG12_DATA      0
#define BM_SY_REG12_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SY_REG12_DATA(v)   ((reg32_t) v)
#else
#define BF_SY_REG12_DATA(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_SY_REG12_DATA(v)   (HW_SY_REG12.B.DATA = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SY_REG13 - SY IP Register 13
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_sy_reg13_t;
#endif


//
// constants & macros for entire HW_SY_REG13 register
//

#define HW_SY_REG13_ADDR      (REGS_SY_BASE + 0x0000005C)

#ifndef __LANGUAGE_ASM__
#define HW_SY_REG13           (*(volatile hw_sy_reg13_t *) HW_SY_REG13_ADDR)
#define HW_SY_REG13_RD()      (HW_SY_REG13.U)
#define HW_SY_REG13_WR(v)     (HW_SY_REG13.U = (v))
#define HW_SY_REG13_SET(v)    (HW_SY_REG13_WR(HW_SY_REG13_RD() |  (v)))
#define HW_SY_REG13_CLR(v)    (HW_SY_REG13_WR(HW_SY_REG13_RD() & ~(v)))
#define HW_SY_REG13_TOG(v)    (HW_SY_REG13_WR(HW_SY_REG13_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_SY_REG13 bitfields
//

//--- Register HW_SY_REG13, field DATA

#define BP_SY_REG13_DATA      0
#define BM_SY_REG13_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SY_REG13_DATA(v)   ((reg32_t) v)
#else
#define BF_SY_REG13_DATA(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_SY_REG13_DATA(v)   (HW_SY_REG13.B.DATA = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SY_REG14 - SY IP Register 14
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_sy_reg14_t;
#endif


//
// constants & macros for entire HW_SY_REG14 register
//

#define HW_SY_REG14_ADDR      (REGS_SY_BASE + 0x00000060)

#ifndef __LANGUAGE_ASM__
#define HW_SY_REG14           (*(volatile hw_sy_reg14_t *) HW_SY_REG14_ADDR)
#define HW_SY_REG14_RD()      (HW_SY_REG14.U)
#define HW_SY_REG14_WR(v)     (HW_SY_REG14.U = (v))
#define HW_SY_REG14_SET(v)    (HW_SY_REG14_WR(HW_SY_REG14_RD() |  (v)))
#define HW_SY_REG14_CLR(v)    (HW_SY_REG14_WR(HW_SY_REG14_RD() & ~(v)))
#define HW_SY_REG14_TOG(v)    (HW_SY_REG14_WR(HW_SY_REG14_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_SY_REG14 bitfields
//

//--- Register HW_SY_REG14, field DATA

#define BP_SY_REG14_DATA      0
#define BM_SY_REG14_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SY_REG14_DATA(v)   ((reg32_t) v)
#else
#define BF_SY_REG14_DATA(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_SY_REG14_DATA(v)   (HW_SY_REG14.B.DATA = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SY_REG15 - SY IP Register 15
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_sy_reg15_t;
#endif


//
// constants & macros for entire HW_SY_REG15 register
//

#define HW_SY_REG15_ADDR      (REGS_SY_BASE + 0x00000064)

#ifndef __LANGUAGE_ASM__
#define HW_SY_REG15           (*(volatile hw_sy_reg15_t *) HW_SY_REG15_ADDR)
#define HW_SY_REG15_RD()      (HW_SY_REG15.U)
#define HW_SY_REG15_WR(v)     (HW_SY_REG15.U = (v))
#define HW_SY_REG15_SET(v)    (HW_SY_REG15_WR(HW_SY_REG15_RD() |  (v)))
#define HW_SY_REG15_CLR(v)    (HW_SY_REG15_WR(HW_SY_REG15_RD() & ~(v)))
#define HW_SY_REG15_TOG(v)    (HW_SY_REG15_WR(HW_SY_REG15_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_SY_REG15 bitfields
//

//--- Register HW_SY_REG15, field DATA

#define BP_SY_REG15_DATA      0
#define BM_SY_REG15_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SY_REG15_DATA(v)   ((reg32_t) v)
#else
#define BF_SY_REG15_DATA(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_SY_REG15_DATA(v)   (HW_SY_REG15.B.DATA = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SY_REG16 - SY IP Register 16
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_sy_reg16_t;
#endif


//
// constants & macros for entire HW_SY_REG16 register
//

#define HW_SY_REG16_ADDR      (REGS_SY_BASE + 0x00000068)

#ifndef __LANGUAGE_ASM__
#define HW_SY_REG16           (*(volatile hw_sy_reg16_t *) HW_SY_REG16_ADDR)
#define HW_SY_REG16_RD()      (HW_SY_REG16.U)
#define HW_SY_REG16_WR(v)     (HW_SY_REG16.U = (v))
#define HW_SY_REG16_SET(v)    (HW_SY_REG16_WR(HW_SY_REG16_RD() |  (v)))
#define HW_SY_REG16_CLR(v)    (HW_SY_REG16_WR(HW_SY_REG16_RD() & ~(v)))
#define HW_SY_REG16_TOG(v)    (HW_SY_REG16_WR(HW_SY_REG16_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_SY_REG16 bitfields
//

//--- Register HW_SY_REG16, field DATA

#define BP_SY_REG16_DATA      0
#define BM_SY_REG16_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SY_REG16_DATA(v)   ((reg32_t) v)
#else
#define BF_SY_REG16_DATA(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_SY_REG16_DATA(v)   (HW_SY_REG16.B.DATA = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SY_REG17 - SY IP Register 17
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_sy_reg17_t;
#endif


//
// constants & macros for entire HW_SY_REG17 register
//

#define HW_SY_REG17_ADDR      (REGS_SY_BASE + 0x0000006C)

#ifndef __LANGUAGE_ASM__
#define HW_SY_REG17           (*(volatile hw_sy_reg17_t *) HW_SY_REG17_ADDR)
#define HW_SY_REG17_RD()      (HW_SY_REG17.U)
#define HW_SY_REG17_WR(v)     (HW_SY_REG17.U = (v))
#define HW_SY_REG17_SET(v)    (HW_SY_REG17_WR(HW_SY_REG17_RD() |  (v)))
#define HW_SY_REG17_CLR(v)    (HW_SY_REG17_WR(HW_SY_REG17_RD() & ~(v)))
#define HW_SY_REG17_TOG(v)    (HW_SY_REG17_WR(HW_SY_REG17_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_SY_REG17 bitfields
//

//--- Register HW_SY_REG17, field DATA

#define BP_SY_REG17_DATA      0
#define BM_SY_REG17_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SY_REG17_DATA(v)   ((reg32_t) v)
#else
#define BF_SY_REG17_DATA(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_SY_REG17_DATA(v)   (HW_SY_REG17.B.DATA = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SY_REG18 - SY IP Register 18
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_sy_reg18_t;
#endif


//
// constants & macros for entire HW_SY_REG18 register
//

#define HW_SY_REG18_ADDR      (REGS_SY_BASE + 0x00000070)

#ifndef __LANGUAGE_ASM__
#define HW_SY_REG18           (*(volatile hw_sy_reg18_t *) HW_SY_REG18_ADDR)
#define HW_SY_REG18_RD()      (HW_SY_REG18.U)
#endif


//
// constants & macros for individual HW_SY_REG18 bitfields
//

//--- Register HW_SY_REG18, field DATA

#define BP_SY_REG18_DATA      0
#define BM_SY_REG18_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SY_REG18_DATA(v)   ((reg32_t) v)
#else
#define BF_SY_REG18_DATA(v)   (v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SY_REG19 - SY IP Register 19
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_sy_reg19_t;
#endif


//
// constants & macros for entire HW_SY_REG19 register
//

#define HW_SY_REG19_ADDR      (REGS_SY_BASE + 0x00000074)

#ifndef __LANGUAGE_ASM__
#define HW_SY_REG19           (*(volatile hw_sy_reg19_t *) HW_SY_REG19_ADDR)
#define HW_SY_REG19_RD()      (HW_SY_REG19.U)
#endif


//
// constants & macros for individual HW_SY_REG19 bitfields
//

//--- Register HW_SY_REG19, field DATA

#define BP_SY_REG19_DATA      0
#define BM_SY_REG19_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SY_REG19_DATA(v)   ((reg32_t) v)
#else
#define BF_SY_REG19_DATA(v)   (v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SY_REG20 - SY IP Register 20
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_sy_reg20_t;
#endif


//
// constants & macros for entire HW_SY_REG20 register
//

#define HW_SY_REG20_ADDR      (REGS_SY_BASE + 0x00000078)

#ifndef __LANGUAGE_ASM__
#define HW_SY_REG20           (*(volatile hw_sy_reg20_t *) HW_SY_REG20_ADDR)
#define HW_SY_REG20_RD()      (HW_SY_REG20.U)
#endif


//
// constants & macros for individual HW_SY_REG20 bitfields
//

//--- Register HW_SY_REG20, field DATA

#define BP_SY_REG20_DATA      0
#define BM_SY_REG20_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SY_REG20_DATA(v)   ((reg32_t) v)
#else
#define BF_SY_REG20_DATA(v)   (v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SY_REG21 - SY IP Register 21
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_sy_reg21_t;
#endif


//
// constants & macros for entire HW_SY_REG21 register
//

#define HW_SY_REG21_ADDR      (REGS_SY_BASE + 0x0000007C)

#ifndef __LANGUAGE_ASM__
#define HW_SY_REG21           (*(volatile hw_sy_reg21_t *) HW_SY_REG21_ADDR)
#define HW_SY_REG21_RD()      (HW_SY_REG21.U)
#endif


//
// constants & macros for individual HW_SY_REG21 bitfields
//

//--- Register HW_SY_REG21, field DATA

#define BP_SY_REG21_DATA      0
#define BM_SY_REG21_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SY_REG21_DATA(v)   ((reg32_t) v)
#else
#define BF_SY_REG21_DATA(v)   (v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SY_IBS_CTRL - SY IBS Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg16_t  RSVD0;
        unsigned ICLR   :  1;
        unsigned RSVD1  :  3;
        unsigned IEN    :  1;
        unsigned RSVD2  : 10;
        unsigned SRST   :  1;
    } B;
} hw_sy_ibs_ctrl_t;
#endif


//
// constants & macros for entire HW_SY_IBS_CTRL register
//

#define HW_SY_IBS_CTRL_ADDR      (REGS_SY_BASE + 0x00000080)

#ifndef __LANGUAGE_ASM__
#define HW_SY_IBS_CTRL           (*(volatile hw_sy_ibs_ctrl_t *) HW_SY_IBS_CTRL_ADDR)
#define HW_SY_IBS_CTRL_RD()      (HW_SY_IBS_CTRL.U)
#define HW_SY_IBS_CTRL_WR(v)     (HW_SY_IBS_CTRL.U = (v))
#define HW_SY_IBS_CTRL_SET(v)    (HW_SY_IBS_CTRL_WR(HW_SY_IBS_CTRL_RD() |  (v)))
#define HW_SY_IBS_CTRL_CLR(v)    (HW_SY_IBS_CTRL_WR(HW_SY_IBS_CTRL_RD() & ~(v)))
#define HW_SY_IBS_CTRL_TOG(v)    (HW_SY_IBS_CTRL_WR(HW_SY_IBS_CTRL_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_SY_IBS_CTRL bitfields
//

//--- Register HW_SY_IBS_CTRL, field SRST

#define BP_SY_IBS_CTRL_SRST      31
#define BM_SY_IBS_CTRL_SRST      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_SY_IBS_CTRL_SRST(v)   ((((reg32_t) v) << 31) & BM_SY_IBS_CTRL_SRST)
#else
#define BF_SY_IBS_CTRL_SRST(v)   (((v) << 31) & BM_SY_IBS_CTRL_SRST)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_SY_IBS_CTRL_SRST(v)   BF_CS1(SY_IBS_CTRL, SRST, v)
#endif

//--- Register HW_SY_IBS_CTRL, field IEN

#define BP_SY_IBS_CTRL_IEN      20
#define BM_SY_IBS_CTRL_IEN      0x00100000

#define BF_SY_IBS_CTRL_IEN(v)   (((v) << 20) & BM_SY_IBS_CTRL_IEN)

#ifndef __LANGUAGE_ASM__
#define BW_SY_IBS_CTRL_IEN(v)   BF_CS1(SY_IBS_CTRL, IEN, v)
#endif

//--- Register HW_SY_IBS_CTRL, field ICLR

#define BP_SY_IBS_CTRL_ICLR      16
#define BM_SY_IBS_CTRL_ICLR      0x00010000

#define BF_SY_IBS_CTRL_ICLR(v)   (((v) << 16) & BM_SY_IBS_CTRL_ICLR)

#ifndef __LANGUAGE_ASM__
#define BW_SY_IBS_CTRL_ICLR(v)   BF_CS1(SY_IBS_CTRL, ICLR, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SY_IBS_STSR - SY IBS Status Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg16_t  RSVD0;
        unsigned BSY     :  1;
        unsigned INT     :  1;
        unsigned RSVD1   :  4;
        unsigned WTRANS  :  1;
        unsigned RTRANS  :  1;
        reg8_t   RSVD2;
    } B;
} hw_sy_ibs_stsr_t;
#endif


//
// constants & macros for entire HW_SY_IBS_STSR register
//

#define HW_SY_IBS_STSR_ADDR      (REGS_SY_BASE + 0x00000088)

#ifndef __LANGUAGE_ASM__
#define HW_SY_IBS_STSR           (*(volatile hw_sy_ibs_stsr_t *) HW_SY_IBS_STSR_ADDR)
#define HW_SY_IBS_STSR_RD()      (HW_SY_IBS_STSR.U)
#endif


//
// constants & macros for individual HW_SY_IBS_STSR bitfields
//

//--- Register HW_SY_IBS_STSR, field RTRANS

#define BP_SY_IBS_STSR_RTRANS      23
#define BM_SY_IBS_STSR_RTRANS      0x00800000

#define BF_SY_IBS_STSR_RTRANS(v)   (((v) << 23) & BM_SY_IBS_STSR_RTRANS)

//--- Register HW_SY_IBS_STSR, field WTRANS

#define BP_SY_IBS_STSR_WTRANS      22
#define BM_SY_IBS_STSR_WTRANS      0x00400000

#define BF_SY_IBS_STSR_WTRANS(v)   (((v) << 22) & BM_SY_IBS_STSR_WTRANS)

//--- Register HW_SY_IBS_STSR, field INT

#define BP_SY_IBS_STSR_INT      17
#define BM_SY_IBS_STSR_INT      0x00020000

#define BF_SY_IBS_STSR_INT(v)   (((v) << 17) & BM_SY_IBS_STSR_INT)

//--- Register HW_SY_IBS_STSR, field BSY

#define BP_SY_IBS_STSR_BSY      16
#define BM_SY_IBS_STSR_BSY      0x00010000

#define BF_SY_IBS_STSR_BSY(v)   (((v) << 16) & BM_SY_IBS_STSR_BSY)


////////////////////////////////////////////////////////////////////////////////
//// HW_SY_IBS_DMODR - SY IBS DMA Mode Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg16_t  RSVD0;
        unsigned DMAEN   :  1;
        unsigned RSVD1   :  7;
        unsigned WB_LEN  :  2;
        unsigned RSVD2   :  2;
        unsigned RB_LEN  :  2;
        unsigned RSVD3   :  2;
    } B;
} hw_sy_ibs_dmodr_t;
#endif


//
// constants & macros for entire HW_SY_IBS_DMODR register
//

#define HW_SY_IBS_DMODR_ADDR      (REGS_SY_BASE + 0x00000090)

#ifndef __LANGUAGE_ASM__
#define HW_SY_IBS_DMODR           (*(volatile hw_sy_ibs_dmodr_t *) HW_SY_IBS_DMODR_ADDR)
#define HW_SY_IBS_DMODR_RD()      (HW_SY_IBS_DMODR.U)
#define HW_SY_IBS_DMODR_WR(v)     (HW_SY_IBS_DMODR.U = (v))
#define HW_SY_IBS_DMODR_SET(v)    (HW_SY_IBS_DMODR_WR(HW_SY_IBS_DMODR_RD() |  (v)))
#define HW_SY_IBS_DMODR_CLR(v)    (HW_SY_IBS_DMODR_WR(HW_SY_IBS_DMODR_RD() & ~(v)))
#define HW_SY_IBS_DMODR_TOG(v)    (HW_SY_IBS_DMODR_WR(HW_SY_IBS_DMODR_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_SY_IBS_DMODR bitfields
//

//--- Register HW_SY_IBS_DMODR, field RB_LEN

#define BP_SY_IBS_DMODR_RB_LEN      28
#define BM_SY_IBS_DMODR_RB_LEN      0x30000000

#define BF_SY_IBS_DMODR_RB_LEN(v)   (((v) << 28) & BM_SY_IBS_DMODR_RB_LEN)

#ifndef __LANGUAGE_ASM__
#define BW_SY_IBS_DMODR_RB_LEN(v)   BF_CS1(SY_IBS_DMODR, RB_LEN, v)
#endif

//--- Register HW_SY_IBS_DMODR, field WB_LEN

#define BP_SY_IBS_DMODR_WB_LEN      24
#define BM_SY_IBS_DMODR_WB_LEN      0x03000000

#define BF_SY_IBS_DMODR_WB_LEN(v)   (((v) << 24) & BM_SY_IBS_DMODR_WB_LEN)

//--- Register HW_SY_IBS_DMODR, field DMAEN

#define BP_SY_IBS_DMODR_DMAEN      16
#define BM_SY_IBS_DMODR_DMAEN      0x00010000

#define BF_SY_IBS_DMODR_DMAEN(v)   (((v) << 16) & BM_SY_IBS_DMODR_DMAEN)

#ifndef __LANGUAGE_ASM__
#define BW_SY_IBS_DMODR_DMAEN(v)   BF_CS1(SY_IBS_DMODR, DMAEN, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SY_IBS_BSSR - SY IBS Barrel Shift Size Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg16_t  RSVD0;
        unsigned WBSS   :  2;
        unsigned RSVD1  :  6;
        unsigned RBSS   :  2;
        unsigned RSVD2  :  6;
    } B;
} hw_sy_ibs_bssr_t;
#endif


//
// constants & macros for entire HW_SY_IBS_BSSR register
//

#define HW_SY_IBS_BSSR_ADDR      (REGS_SY_BASE + 0x00000098)

#ifndef __LANGUAGE_ASM__
#define HW_SY_IBS_BSSR           (*(volatile hw_sy_ibs_bssr_t *) HW_SY_IBS_BSSR_ADDR)
#define HW_SY_IBS_BSSR_RD()      (HW_SY_IBS_BSSR.U)
#define HW_SY_IBS_BSSR_WR(v)     (HW_SY_IBS_BSSR.U = (v))
#define HW_SY_IBS_BSSR_SET(v)    (HW_SY_IBS_BSSR_WR(HW_SY_IBS_BSSR_RD() |  (v)))
#define HW_SY_IBS_BSSR_CLR(v)    (HW_SY_IBS_BSSR_WR(HW_SY_IBS_BSSR_RD() & ~(v)))
#define HW_SY_IBS_BSSR_TOG(v)    (HW_SY_IBS_BSSR_WR(HW_SY_IBS_BSSR_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_SY_IBS_BSSR bitfields
//

//--- Register HW_SY_IBS_BSSR, field RBSS

#define BP_SY_IBS_BSSR_RBSS      24
#define BM_SY_IBS_BSSR_RBSS      0x03000000

#define BF_SY_IBS_BSSR_RBSS(v)   (((v) << 24) & BM_SY_IBS_BSSR_RBSS)

//--- Register HW_SY_IBS_BSSR, field WBSS

#define BP_SY_IBS_BSSR_WBSS      16
#define BM_SY_IBS_BSSR_WBSS      0x00030000

#define BF_SY_IBS_BSSR_WBSS(v)   (((v) << 16) & BM_SY_IBS_BSSR_WBSS)

#ifndef __LANGUAGE_ASM__
#define BW_SY_IBS_BSSR_WBSS(v)   BF_CS1(SY_IBS_BSSR, WBSS, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SY_IBS_CMDR - SY IBS Command Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg16_t  RSVD0;
        reg16_t  DATA;
    } B;
} hw_sy_ibs_cmdr_t;
#endif


//
// constants & macros for entire HW_SY_IBS_CMDR register
//

#define HW_SY_IBS_CMDR_ADDR      (REGS_SY_BASE + 0x000000A0)

#ifndef __LANGUAGE_ASM__
#define HW_SY_IBS_CMDR           (*(volatile hw_sy_ibs_cmdr_t *) HW_SY_IBS_CMDR_ADDR)
#define HW_SY_IBS_CMDR_RD()      (HW_SY_IBS_CMDR.U)
#define HW_SY_IBS_CMDR_WR(v)     (HW_SY_IBS_CMDR.U = (v))
#define HW_SY_IBS_CMDR_SET(v)    (HW_SY_IBS_CMDR_WR(HW_SY_IBS_CMDR_RD() |  (v)))
#define HW_SY_IBS_CMDR_CLR(v)    (HW_SY_IBS_CMDR_WR(HW_SY_IBS_CMDR_RD() & ~(v)))
#define HW_SY_IBS_CMDR_TOG(v)    (HW_SY_IBS_CMDR_WR(HW_SY_IBS_CMDR_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_SY_IBS_CMDR bitfields
//

//--- Register HW_SY_IBS_CMDR, field DATA

#define BP_SY_IBS_CMDR_DATA      16
#define BM_SY_IBS_CMDR_DATA      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_SY_IBS_CMDR_DATA(v)   ((((reg32_t) v) << 16) & BM_SY_IBS_CMDR_DATA)
#else
#define BF_SY_IBS_CMDR_DATA(v)   (((v) << 16) & BM_SY_IBS_CMDR_DATA)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_SY_IBS_CMDR_DATA(v)   (HW_SY_IBS_CMDR.B.DATA = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SY_IBS_MCMDR - SY IBS MCMDR Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg16_t  RSVD0;
        reg16_t  DATA;
    } B;
} hw_sy_ibs_mcmdr_t;
#endif


//
// constants & macros for entire HW_SY_IBS_MCMDR register
//

#define HW_SY_IBS_MCMDR_ADDR      (REGS_SY_BASE + 0x000000A8)

#ifndef __LANGUAGE_ASM__
#define HW_SY_IBS_MCMDR           (*(volatile hw_sy_ibs_mcmdr_t *) HW_SY_IBS_MCMDR_ADDR)
#define HW_SY_IBS_MCMDR_RD()      (HW_SY_IBS_MCMDR.U)
#define HW_SY_IBS_MCMDR_WR(v)     (HW_SY_IBS_MCMDR.U = (v))
#define HW_SY_IBS_MCMDR_SET(v)    (HW_SY_IBS_MCMDR_WR(HW_SY_IBS_MCMDR_RD() |  (v)))
#define HW_SY_IBS_MCMDR_CLR(v)    (HW_SY_IBS_MCMDR_WR(HW_SY_IBS_MCMDR_RD() & ~(v)))
#define HW_SY_IBS_MCMDR_TOG(v)    (HW_SY_IBS_MCMDR_WR(HW_SY_IBS_MCMDR_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_SY_IBS_MCMDR bitfields
//

//--- Register HW_SY_IBS_MCMDR, field DATA

#define BP_SY_IBS_MCMDR_DATA      16
#define BM_SY_IBS_MCMDR_DATA      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_SY_IBS_MCMDR_DATA(v)   ((((reg32_t) v) << 16) & BM_SY_IBS_MCMDR_DATA)
#else
#define BF_SY_IBS_MCMDR_DATA(v)   (((v) << 16) & BM_SY_IBS_MCMDR_DATA)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_SY_IBS_MCMDR_DATA(v)   (HW_SY_IBS_MCMDR.B.DATA = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SY_IBS_VERR - SY IBS Version Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSVD0  : 20;
        unsigned DATA   : 12;
    } B;
} hw_sy_ibs_verr_t;
#endif


//
// constants & macros for entire HW_SY_IBS_VERR register
//

#define HW_SY_IBS_VERR_ADDR      (REGS_SY_BASE + 0x000000B0)

#ifndef __LANGUAGE_ASM__
#define HW_SY_IBS_VERR           (*(volatile hw_sy_ibs_verr_t *) HW_SY_IBS_VERR_ADDR)
#define HW_SY_IBS_VERR_RD()      (HW_SY_IBS_VERR.U)
#endif


//
// constants & macros for individual HW_SY_IBS_VERR bitfields
//

//--- Register HW_SY_IBS_VERR, field DATA

#define BP_SY_IBS_VERR_DATA      20
#define BM_SY_IBS_VERR_DATA      0xFFF00000

#ifndef __LANGUAGE_ASM__
#define BF_SY_IBS_VERR_DATA(v)   ((((reg32_t) v) << 20) & BM_SY_IBS_VERR_DATA)
#else
#define BF_SY_IBS_VERR_DATA(v)   (((v) << 20) & BM_SY_IBS_VERR_DATA)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SY_IBS_DSIZER - SY IBS Data Size Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_sy_ibs_dsizer_t;
#endif


//
// constants & macros for entire HW_SY_IBS_DSIZER register
//

#define HW_SY_IBS_DSIZER_ADDR      (REGS_SY_BASE + 0x000000C0)

#ifndef __LANGUAGE_ASM__
#define HW_SY_IBS_DSIZER           (*(volatile hw_sy_ibs_dsizer_t *) HW_SY_IBS_DSIZER_ADDR)
#define HW_SY_IBS_DSIZER_RD()      (HW_SY_IBS_DSIZER.U)
#define HW_SY_IBS_DSIZER_WR(v)     (HW_SY_IBS_DSIZER.U = (v))
#define HW_SY_IBS_DSIZER_SET(v)    (HW_SY_IBS_DSIZER_WR(HW_SY_IBS_DSIZER_RD() |  (v)))
#define HW_SY_IBS_DSIZER_CLR(v)    (HW_SY_IBS_DSIZER_WR(HW_SY_IBS_DSIZER_RD() & ~(v)))
#define HW_SY_IBS_DSIZER_TOG(v)    (HW_SY_IBS_DSIZER_WR(HW_SY_IBS_DSIZER_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_SY_IBS_DSIZER bitfields
//

//--- Register HW_SY_IBS_DSIZER, field DATA

#define BP_SY_IBS_DSIZER_DATA      0
#define BM_SY_IBS_DSIZER_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SY_IBS_DSIZER_DATA(v)   ((reg32_t) v)
#else
#define BF_SY_IBS_DSIZER_DATA(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_SY_IBS_DSIZER_DATA(v)   (HW_SY_IBS_DSIZER.B.DATA = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SY_IBS_WDATAR - SY IBS Write DATA Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_sy_ibs_wdatar_t;
#endif


//
// constants & macros for entire HW_SY_IBS_WDATAR register
//

#define HW_SY_IBS_WDATAR_ADDR      (REGS_SY_BASE + 0x000000D0)

#ifndef __LANGUAGE_ASM__
#define HW_SY_IBS_WDATAR           (*(volatile hw_sy_ibs_wdatar_t *) HW_SY_IBS_WDATAR_ADDR)
#define HW_SY_IBS_WDATAR_RD()      (HW_SY_IBS_WDATAR.U)
#define HW_SY_IBS_WDATAR_WR(v)     (HW_SY_IBS_WDATAR.U = (v))
#define HW_SY_IBS_WDATAR_SET(v)    (HW_SY_IBS_WDATAR_WR(HW_SY_IBS_WDATAR_RD() |  (v)))
#define HW_SY_IBS_WDATAR_CLR(v)    (HW_SY_IBS_WDATAR_WR(HW_SY_IBS_WDATAR_RD() & ~(v)))
#define HW_SY_IBS_WDATAR_TOG(v)    (HW_SY_IBS_WDATAR_WR(HW_SY_IBS_WDATAR_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_SY_IBS_WDATAR bitfields
//

//--- Register HW_SY_IBS_WDATAR, field DATA

#define BP_SY_IBS_WDATAR_DATA      0
#define BM_SY_IBS_WDATAR_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SY_IBS_WDATAR_DATA(v)   ((reg32_t) v)
#else
#define BF_SY_IBS_WDATAR_DATA(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_SY_IBS_WDATAR_DATA(v)   (HW_SY_IBS_WDATAR.B.DATA = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SY_IBS_IVR0 - SY IBS Initial Vector Register 0
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_sy_ibs_ivr0_t;
#endif


//
// constants & macros for entire HW_SY_IBS_IVR0 register
//

#define HW_SY_IBS_IVR0_ADDR      (REGS_SY_BASE + 0x000000E0)

#ifndef __LANGUAGE_ASM__
#define HW_SY_IBS_IVR0           (*(volatile hw_sy_ibs_ivr0_t *) HW_SY_IBS_IVR0_ADDR)
#define HW_SY_IBS_IVR0_RD()      (HW_SY_IBS_IVR0.U)
#define HW_SY_IBS_IVR0_WR(v)     (HW_SY_IBS_IVR0.U = (v))
#define HW_SY_IBS_IVR0_SET(v)    (HW_SY_IBS_IVR0_WR(HW_SY_IBS_IVR0_RD() |  (v)))
#define HW_SY_IBS_IVR0_CLR(v)    (HW_SY_IBS_IVR0_WR(HW_SY_IBS_IVR0_RD() & ~(v)))
#define HW_SY_IBS_IVR0_TOG(v)    (HW_SY_IBS_IVR0_WR(HW_SY_IBS_IVR0_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_SY_IBS_IVR0 bitfields
//

//--- Register HW_SY_IBS_IVR0, field DATA

#define BP_SY_IBS_IVR0_DATA      0
#define BM_SY_IBS_IVR0_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SY_IBS_IVR0_DATA(v)   ((reg32_t) v)
#else
#define BF_SY_IBS_IVR0_DATA(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_SY_IBS_IVR0_DATA(v)   (HW_SY_IBS_IVR0.B.DATA = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SY_IBS_IVR1 - SY IBS Initial Vector Register 1
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_sy_ibs_ivr1_t;
#endif


//
// constants & macros for entire HW_SY_IBS_IVR1 register
//

#define HW_SY_IBS_IVR1_ADDR      (REGS_SY_BASE + 0x000000E4)

#ifndef __LANGUAGE_ASM__
#define HW_SY_IBS_IVR1           (*(volatile hw_sy_ibs_ivr1_t *) HW_SY_IBS_IVR1_ADDR)
#define HW_SY_IBS_IVR1_RD()      (HW_SY_IBS_IVR1.U)
#define HW_SY_IBS_IVR1_WR(v)     (HW_SY_IBS_IVR1.U = (v))
#define HW_SY_IBS_IVR1_SET(v)    (HW_SY_IBS_IVR1_WR(HW_SY_IBS_IVR1_RD() |  (v)))
#define HW_SY_IBS_IVR1_CLR(v)    (HW_SY_IBS_IVR1_WR(HW_SY_IBS_IVR1_RD() & ~(v)))
#define HW_SY_IBS_IVR1_TOG(v)    (HW_SY_IBS_IVR1_WR(HW_SY_IBS_IVR1_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_SY_IBS_IVR1 bitfields
//

//--- Register HW_SY_IBS_IVR1, field DATA

#define BP_SY_IBS_IVR1_DATA      0
#define BM_SY_IBS_IVR1_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SY_IBS_IVR1_DATA(v)   ((reg32_t) v)
#else
#define BF_SY_IBS_IVR1_DATA(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_SY_IBS_IVR1_DATA(v)   (HW_SY_IBS_IVR1.B.DATA = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SY_IBS_IVR2 - SY IBS Initial Vector Register 2
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_sy_ibs_ivr2_t;
#endif


//
// constants & macros for entire HW_SY_IBS_IVR2 register
//

#define HW_SY_IBS_IVR2_ADDR      (REGS_SY_BASE + 0x000000E8)

#ifndef __LANGUAGE_ASM__
#define HW_SY_IBS_IVR2           (*(volatile hw_sy_ibs_ivr2_t *) HW_SY_IBS_IVR2_ADDR)
#define HW_SY_IBS_IVR2_RD()      (HW_SY_IBS_IVR2.U)
#define HW_SY_IBS_IVR2_WR(v)     (HW_SY_IBS_IVR2.U = (v))
#define HW_SY_IBS_IVR2_SET(v)    (HW_SY_IBS_IVR2_WR(HW_SY_IBS_IVR2_RD() |  (v)))
#define HW_SY_IBS_IVR2_CLR(v)    (HW_SY_IBS_IVR2_WR(HW_SY_IBS_IVR2_RD() & ~(v)))
#define HW_SY_IBS_IVR2_TOG(v)    (HW_SY_IBS_IVR2_WR(HW_SY_IBS_IVR2_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_SY_IBS_IVR2 bitfields
//

//--- Register HW_SY_IBS_IVR2, field DATA

#define BP_SY_IBS_IVR2_DATA      0
#define BM_SY_IBS_IVR2_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SY_IBS_IVR2_DATA(v)   ((reg32_t) v)
#else
#define BF_SY_IBS_IVR2_DATA(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_SY_IBS_IVR2_DATA(v)   (HW_SY_IBS_IVR2.B.DATA = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SY_IBS_IVR3 - SY IBS Initial Vector Register 3
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_sy_ibs_ivr3_t;
#endif


//
// constants & macros for entire HW_SY_IBS_IVR3 register
//

#define HW_SY_IBS_IVR3_ADDR      (REGS_SY_BASE + 0x000000EC)

#ifndef __LANGUAGE_ASM__
#define HW_SY_IBS_IVR3           (*(volatile hw_sy_ibs_ivr3_t *) HW_SY_IBS_IVR3_ADDR)
#define HW_SY_IBS_IVR3_RD()      (HW_SY_IBS_IVR3.U)
#define HW_SY_IBS_IVR3_WR(v)     (HW_SY_IBS_IVR3.U = (v))
#define HW_SY_IBS_IVR3_SET(v)    (HW_SY_IBS_IVR3_WR(HW_SY_IBS_IVR3_RD() |  (v)))
#define HW_SY_IBS_IVR3_CLR(v)    (HW_SY_IBS_IVR3_WR(HW_SY_IBS_IVR3_RD() & ~(v)))
#define HW_SY_IBS_IVR3_TOG(v)    (HW_SY_IBS_IVR3_WR(HW_SY_IBS_IVR3_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_SY_IBS_IVR3 bitfields
//

//--- Register HW_SY_IBS_IVR3, field DATA

#define BP_SY_IBS_IVR3_DATA      0
#define BM_SY_IBS_IVR3_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SY_IBS_IVR3_DATA(v)   ((reg32_t) v)
#else
#define BF_SY_IBS_IVR3_DATA(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_SY_IBS_IVR3_DATA(v)   (HW_SY_IBS_IVR3.B.DATA = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SY_IBS_RDATAR - SY IBS Read Data Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_sy_ibs_rdatar_t;
#endif


//
// constants & macros for entire HW_SY_IBS_RDATAR register
//

#define HW_SY_IBS_RDATAR_ADDR      (REGS_SY_BASE + 0x000000F0)

#ifndef __LANGUAGE_ASM__
#define HW_SY_IBS_RDATAR           (*(volatile hw_sy_ibs_rdatar_t *) HW_SY_IBS_RDATAR_ADDR)
#define HW_SY_IBS_RDATAR_RD()      (HW_SY_IBS_RDATAR.U)
#endif


//
// constants & macros for individual HW_SY_IBS_RDATAR bitfields
//

//--- Register HW_SY_IBS_RDATAR, field DATA

#define BP_SY_IBS_RDATAR_DATA      0
#define BM_SY_IBS_RDATAR_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SY_IBS_RDATAR_DATA(v)   ((reg32_t) v)
#else
#define BF_SY_IBS_RDATAR_DATA(v)   (v)
#endif


#endif // _REGSSY_H

////////////////////////////////////////////////////////////////////////////////
