/*
 * Copyright 2008-2009 Freescale Semiconductor, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

 * WARNING!  THIS FILE IS AUTOMATICALLY GENERATED FROM XML.
 *                DO NOT MODIFY THIS FILE DIRECTLY.
 *
 * Xml Revision: 1.50
 *
 * Template revision: 26195
 *
 *
 * The following naming conventions are followed in this file.
 *      XX_<module>_<regname>_<field>
 *
 * XX specifies the define / macro class
 *      HW pertains to a register
 *      BM indicates a Bit Mask
 *      BF indicates a Bit Field macro
 *
 * <module> is the hardware module name which can be any of the following...
 *      USB20 (Note when there is more than one copy of a given module, the
 *      module name includes a number starting from 0 for the first instance
 *      of that module)
 *
 * <regname> is the specific register within that module
 *
 * <field> is the specific bitfield within that <module>_<register>
 *
 * We also define the following...
 *      hw_<module>_<regname>_t is typedef of anonymous union
 *
 */

#ifndef _DRAM_H
#define _DRAM_H  1

#include "regs.h"

#ifndef REGS_DRAM_BASE
#define REGS_DRAM_BASE (REGS_BASE + 0xe0000)
#endif

/*
 * HW_DRAM_CTL00 - DRAM Control Register 00
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BRESP_TIMING      :  1;
        unsigned SREFRESH_ENTER    :  1;
        unsigned CKE_SELECT        :  1;
        unsigned USER_DEF_REG_0_1  : 29;
    } B;
} hw_dram_ctl00_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL00 register
 */
#define HW_DRAM_CTL00_ADDR         (REGS_DRAM_BASE + 0x0)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL00           (*(volatile hw_dram_ctl00_t *) HW_DRAM_CTL00_ADDR)
#define HW_DRAM_CTL00_RD()      (HW_DRAM_CTL00.U)
#define HW_DRAM_CTL00_WR(v)     (HW_DRAM_CTL00.U = (v))
#define HW_DRAM_CTL00_SET(v)    (HW_DRAM_CTL00_WR(HW_DRAM_CTL00_RD() |  (v)))
#define HW_DRAM_CTL00_CLR(v)    (HW_DRAM_CTL00_WR(HW_DRAM_CTL00_RD() & ~(v)))
#define HW_DRAM_CTL00_TOG(v)    (HW_DRAM_CTL00_WR(HW_DRAM_CTL00_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL00 bitfields
 */
/* --- Register HW_DRAM_CTL00, field USER_DEF_REG_0_1 */

#define BP_DRAM_CTL00_USER_DEF_REG_0_1      3
#define BM_DRAM_CTL00_USER_DEF_REG_0_1      0xFFFFFFF8

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL00_USER_DEF_REG_0_1(v)   ((((reg32_t) v) << 3) & BM_DRAM_CTL00_USER_DEF_REG_0_1)
#else
#define BF_DRAM_CTL00_USER_DEF_REG_0_1(v)   (((v) << 3) & BM_DRAM_CTL00_USER_DEF_REG_0_1)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL00_USER_DEF_REG_0_1(v)   BF_CS1(DRAM_CTL00, USER_DEF_REG_0_1, v)
#endif

/* --- Register HW_DRAM_CTL00, field CKE_SELECT */

#define BP_DRAM_CTL00_CKE_SELECT      2
#define BM_DRAM_CTL00_CKE_SELECT      0x00000004

#define BF_DRAM_CTL00_CKE_SELECT(v)   (((v) << 2) & BM_DRAM_CTL00_CKE_SELECT)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL00_CKE_SELECT(v)   BF_CS1(DRAM_CTL00, CKE_SELECT, v)
#endif

#define BV_DRAM_CTL00_CKE_SELECT__DDR2   0x0
#define BV_DRAM_CTL00_CKE_SELECT__LPDDR  0x1

/* --- Register HW_DRAM_CTL00, field SREFRESH_ENTER */

#define BP_DRAM_CTL00_SREFRESH_ENTER      1
#define BM_DRAM_CTL00_SREFRESH_ENTER      0x00000002

#define BF_DRAM_CTL00_SREFRESH_ENTER(v)   (((v) << 1) & BM_DRAM_CTL00_SREFRESH_ENTER)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL00_SREFRESH_ENTER(v)   BF_CS1(DRAM_CTL00, SREFRESH_ENTER, v)
#endif

/* --- Register HW_DRAM_CTL00, field BRESP_TIMING */

#define BP_DRAM_CTL00_BRESP_TIMING      0
#define BM_DRAM_CTL00_BRESP_TIMING      0x00000001

#define BF_DRAM_CTL00_BRESP_TIMING(v)   (((v) << 0) & BM_DRAM_CTL00_BRESP_TIMING)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL00_BRESP_TIMING(v)   BF_CS1(DRAM_CTL00, BRESP_TIMING, v)
#endif

#define BV_DRAM_CTL00_BRESP_TIMING__BUFFERABLE       0x0
#define BV_DRAM_CTL00_BRESP_TIMING__SEMI_BUFFERABLE  0x1



/*
 * HW_DRAM_CTL01 - AXI Monitor Control
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned MON_DISABLE     :  4;
        unsigned SLVERR          :  4;
        unsigned MON_DBG_STB     :  1;
        unsigned USER_DEF_REG_1  : 23;
    } B;
} hw_dram_ctl01_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL01 register
 */
#define HW_DRAM_CTL01_ADDR         (REGS_DRAM_BASE + 0x4)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL01           (*(volatile hw_dram_ctl01_t *) HW_DRAM_CTL01_ADDR)
#define HW_DRAM_CTL01_RD()      (HW_DRAM_CTL01.U)
#define HW_DRAM_CTL01_WR(v)     (HW_DRAM_CTL01.U = (v))
#define HW_DRAM_CTL01_SET(v)    (HW_DRAM_CTL01_WR(HW_DRAM_CTL01_RD() |  (v)))
#define HW_DRAM_CTL01_CLR(v)    (HW_DRAM_CTL01_WR(HW_DRAM_CTL01_RD() & ~(v)))
#define HW_DRAM_CTL01_TOG(v)    (HW_DRAM_CTL01_WR(HW_DRAM_CTL01_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL01 bitfields
 */
/* --- Register HW_DRAM_CTL01, field USER_DEF_REG_1 */

#define BP_DRAM_CTL01_USER_DEF_REG_1      9
#define BM_DRAM_CTL01_USER_DEF_REG_1      0xFFFFFE00

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL01_USER_DEF_REG_1(v)   ((((reg32_t) v) << 9) & BM_DRAM_CTL01_USER_DEF_REG_1)
#else
#define BF_DRAM_CTL01_USER_DEF_REG_1(v)   (((v) << 9) & BM_DRAM_CTL01_USER_DEF_REG_1)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL01_USER_DEF_REG_1(v)   BF_CS1(DRAM_CTL01, USER_DEF_REG_1, v)
#endif

/* --- Register HW_DRAM_CTL01, field MON_DBG_STB */

#define BP_DRAM_CTL01_MON_DBG_STB      8
#define BM_DRAM_CTL01_MON_DBG_STB      0x00000100

#define BF_DRAM_CTL01_MON_DBG_STB(v)   (((v) << 8) & BM_DRAM_CTL01_MON_DBG_STB)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL01_MON_DBG_STB(v)   BF_CS1(DRAM_CTL01, MON_DBG_STB, v)
#endif

/* --- Register HW_DRAM_CTL01, field SLVERR */

#define BP_DRAM_CTL01_SLVERR      4
#define BM_DRAM_CTL01_SLVERR      0x000000F0

#define BF_DRAM_CTL01_SLVERR(v)   (((v) << 4) & BM_DRAM_CTL01_SLVERR)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL01_SLVERR(v)   BF_CS1(DRAM_CTL01, SLVERR, v)
#endif

/* --- Register HW_DRAM_CTL01, field MON_DISABLE */

#define BP_DRAM_CTL01_MON_DISABLE      0
#define BM_DRAM_CTL01_MON_DISABLE      0x0000000F

#define BF_DRAM_CTL01_MON_DISABLE(v)   (((v) << 0) & BM_DRAM_CTL01_MON_DISABLE)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL01_MON_DISABLE(v)   BF_CS1(DRAM_CTL01, MON_DISABLE, v)
#endif



/*
 * HW_DRAM_CTL02 - DRAM Control Register 02
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned USER_DEF_REG_2  : 32;
    } B;
} hw_dram_ctl02_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL02 register
 */
#define HW_DRAM_CTL02_ADDR         (REGS_DRAM_BASE + 0x8)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL02           (*(volatile hw_dram_ctl02_t *) HW_DRAM_CTL02_ADDR)
#define HW_DRAM_CTL02_RD()      (HW_DRAM_CTL02.U)
#define HW_DRAM_CTL02_WR(v)     (HW_DRAM_CTL02.U = (v))
#define HW_DRAM_CTL02_SET(v)    (HW_DRAM_CTL02_WR(HW_DRAM_CTL02_RD() |  (v)))
#define HW_DRAM_CTL02_CLR(v)    (HW_DRAM_CTL02_WR(HW_DRAM_CTL02_RD() & ~(v)))
#define HW_DRAM_CTL02_TOG(v)    (HW_DRAM_CTL02_WR(HW_DRAM_CTL02_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL02 bitfields
 */
/* --- Register HW_DRAM_CTL02, field USER_DEF_REG_2 */

#define BP_DRAM_CTL02_USER_DEF_REG_2      0
#define BM_DRAM_CTL02_USER_DEF_REG_2      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL02_USER_DEF_REG_2(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL02_USER_DEF_REG_2(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL02_USER_DEF_REG_2(v)   (HW_DRAM_CTL02.B.USER_DEF_REG_2 = (v))
#endif



/*
 * HW_DRAM_CTL03 - DRAM Control Register 03
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned USER_DEF_REG_3  : 32;
    } B;
} hw_dram_ctl03_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL03 register
 */
#define HW_DRAM_CTL03_ADDR         (REGS_DRAM_BASE + 0xc)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL03           (*(volatile hw_dram_ctl03_t *) HW_DRAM_CTL03_ADDR)
#define HW_DRAM_CTL03_RD()      (HW_DRAM_CTL03.U)
#define HW_DRAM_CTL03_WR(v)     (HW_DRAM_CTL03.U = (v))
#define HW_DRAM_CTL03_SET(v)    (HW_DRAM_CTL03_WR(HW_DRAM_CTL03_RD() |  (v)))
#define HW_DRAM_CTL03_CLR(v)    (HW_DRAM_CTL03_WR(HW_DRAM_CTL03_RD() & ~(v)))
#define HW_DRAM_CTL03_TOG(v)    (HW_DRAM_CTL03_WR(HW_DRAM_CTL03_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL03 bitfields
 */
/* --- Register HW_DRAM_CTL03, field USER_DEF_REG_3 */

#define BP_DRAM_CTL03_USER_DEF_REG_3      0
#define BM_DRAM_CTL03_USER_DEF_REG_3      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL03_USER_DEF_REG_3(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL03_USER_DEF_REG_3(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL03_USER_DEF_REG_3(v)   (HW_DRAM_CTL03.B.USER_DEF_REG_3 = (v))
#endif



/*
 * HW_DRAM_CTL04 - DRAM Control Register 04
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned USER_DEF_REG_4  : 32;
    } B;
} hw_dram_ctl04_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL04 register
 */
#define HW_DRAM_CTL04_ADDR         (REGS_DRAM_BASE + 0x10)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL04           (*(volatile hw_dram_ctl04_t *) HW_DRAM_CTL04_ADDR)
#define HW_DRAM_CTL04_RD()      (HW_DRAM_CTL04.U)
#define HW_DRAM_CTL04_WR(v)     (HW_DRAM_CTL04.U = (v))
#define HW_DRAM_CTL04_SET(v)    (HW_DRAM_CTL04_WR(HW_DRAM_CTL04_RD() |  (v)))
#define HW_DRAM_CTL04_CLR(v)    (HW_DRAM_CTL04_WR(HW_DRAM_CTL04_RD() & ~(v)))
#define HW_DRAM_CTL04_TOG(v)    (HW_DRAM_CTL04_WR(HW_DRAM_CTL04_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL04 bitfields
 */
/* --- Register HW_DRAM_CTL04, field USER_DEF_REG_4 */

#define BP_DRAM_CTL04_USER_DEF_REG_4      0
#define BM_DRAM_CTL04_USER_DEF_REG_4      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL04_USER_DEF_REG_4(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL04_USER_DEF_REG_4(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL04_USER_DEF_REG_4(v)   (HW_DRAM_CTL04.B.USER_DEF_REG_4 = (v))
#endif



/*
 * HW_DRAM_CTL05 - DRAM Control Register 05
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned USER_DEF_REG_5  : 32;
    } B;
} hw_dram_ctl05_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL05 register
 */
#define HW_DRAM_CTL05_ADDR         (REGS_DRAM_BASE + 0x14)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL05           (*(volatile hw_dram_ctl05_t *) HW_DRAM_CTL05_ADDR)
#define HW_DRAM_CTL05_RD()      (HW_DRAM_CTL05.U)
#define HW_DRAM_CTL05_WR(v)     (HW_DRAM_CTL05.U = (v))
#define HW_DRAM_CTL05_SET(v)    (HW_DRAM_CTL05_WR(HW_DRAM_CTL05_RD() |  (v)))
#define HW_DRAM_CTL05_CLR(v)    (HW_DRAM_CTL05_WR(HW_DRAM_CTL05_RD() & ~(v)))
#define HW_DRAM_CTL05_TOG(v)    (HW_DRAM_CTL05_WR(HW_DRAM_CTL05_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL05 bitfields
 */
/* --- Register HW_DRAM_CTL05, field USER_DEF_REG_5 */

#define BP_DRAM_CTL05_USER_DEF_REG_5      0
#define BM_DRAM_CTL05_USER_DEF_REG_5      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL05_USER_DEF_REG_5(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL05_USER_DEF_REG_5(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL05_USER_DEF_REG_5(v)   (HW_DRAM_CTL05.B.USER_DEF_REG_5 = (v))
#endif



/*
 * HW_DRAM_CTL06 - DRAM Control Register 06
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned USER_DEF_REG_6  : 32;
    } B;
} hw_dram_ctl06_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL06 register
 */
#define HW_DRAM_CTL06_ADDR         (REGS_DRAM_BASE + 0x18)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL06           (*(volatile hw_dram_ctl06_t *) HW_DRAM_CTL06_ADDR)
#define HW_DRAM_CTL06_RD()      (HW_DRAM_CTL06.U)
#define HW_DRAM_CTL06_WR(v)     (HW_DRAM_CTL06.U = (v))
#define HW_DRAM_CTL06_SET(v)    (HW_DRAM_CTL06_WR(HW_DRAM_CTL06_RD() |  (v)))
#define HW_DRAM_CTL06_CLR(v)    (HW_DRAM_CTL06_WR(HW_DRAM_CTL06_RD() & ~(v)))
#define HW_DRAM_CTL06_TOG(v)    (HW_DRAM_CTL06_WR(HW_DRAM_CTL06_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL06 bitfields
 */
/* --- Register HW_DRAM_CTL06, field USER_DEF_REG_6 */

#define BP_DRAM_CTL06_USER_DEF_REG_6      0
#define BM_DRAM_CTL06_USER_DEF_REG_6      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL06_USER_DEF_REG_6(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL06_USER_DEF_REG_6(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL06_USER_DEF_REG_6(v)   (HW_DRAM_CTL06.B.USER_DEF_REG_6 = (v))
#endif



/*
 * HW_DRAM_CTL07 - DRAM Control Register 07
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned USER_DEF_REG_7  : 32;
    } B;
} hw_dram_ctl07_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL07 register
 */
#define HW_DRAM_CTL07_ADDR         (REGS_DRAM_BASE + 0x1c)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL07           (*(volatile hw_dram_ctl07_t *) HW_DRAM_CTL07_ADDR)
#define HW_DRAM_CTL07_RD()      (HW_DRAM_CTL07.U)
#define HW_DRAM_CTL07_WR(v)     (HW_DRAM_CTL07.U = (v))
#define HW_DRAM_CTL07_SET(v)    (HW_DRAM_CTL07_WR(HW_DRAM_CTL07_RD() |  (v)))
#define HW_DRAM_CTL07_CLR(v)    (HW_DRAM_CTL07_WR(HW_DRAM_CTL07_RD() & ~(v)))
#define HW_DRAM_CTL07_TOG(v)    (HW_DRAM_CTL07_WR(HW_DRAM_CTL07_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL07 bitfields
 */
/* --- Register HW_DRAM_CTL07, field USER_DEF_REG_7 */

#define BP_DRAM_CTL07_USER_DEF_REG_7      0
#define BM_DRAM_CTL07_USER_DEF_REG_7      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL07_USER_DEF_REG_7(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL07_USER_DEF_REG_7(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL07_USER_DEF_REG_7(v)   (HW_DRAM_CTL07.B.USER_DEF_REG_7 = (v))
#endif



/*
 * HW_DRAM_CTL08 - DRAM Control Register 08
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned COMMAND_ACCEPTED    :  4;
        unsigned CKE_STATUS          :  1;
        unsigned SREFRESH_ACK        :  1;
        unsigned Q_ALMOST_FULL       :  1;
        unsigned REFRESH_IN_PROCESS  :  1;
        unsigned CONTROLLER_BUSY     :  1;
        unsigned USER_DEF_REG_RO_0   : 23;
    } B;
} hw_dram_ctl08_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL08 register
 */
#define HW_DRAM_CTL08_ADDR         (REGS_DRAM_BASE + 0x20)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL08           (*(volatile hw_dram_ctl08_t *) HW_DRAM_CTL08_ADDR)
#define HW_DRAM_CTL08_RD()      (HW_DRAM_CTL08.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL08 bitfields
 */
/* --- Register HW_DRAM_CTL08, field USER_DEF_REG_RO_0 */

#define BP_DRAM_CTL08_USER_DEF_REG_RO_0      9
#define BM_DRAM_CTL08_USER_DEF_REG_RO_0      0xFFFFFE00

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL08_USER_DEF_REG_RO_0(v)   ((((reg32_t) v) << 9) & BM_DRAM_CTL08_USER_DEF_REG_RO_0)
#else
#define BF_DRAM_CTL08_USER_DEF_REG_RO_0(v)   (((v) << 9) & BM_DRAM_CTL08_USER_DEF_REG_RO_0)
#endif
/* --- Register HW_DRAM_CTL08, field CONTROLLER_BUSY */

#define BP_DRAM_CTL08_CONTROLLER_BUSY      8
#define BM_DRAM_CTL08_CONTROLLER_BUSY      0x00000100

#define BF_DRAM_CTL08_CONTROLLER_BUSY(v)   (((v) << 8) & BM_DRAM_CTL08_CONTROLLER_BUSY)
/* --- Register HW_DRAM_CTL08, field REFRESH_IN_PROCESS */

#define BP_DRAM_CTL08_REFRESH_IN_PROCESS      7
#define BM_DRAM_CTL08_REFRESH_IN_PROCESS      0x00000080

#define BF_DRAM_CTL08_REFRESH_IN_PROCESS(v)   (((v) << 7) & BM_DRAM_CTL08_REFRESH_IN_PROCESS)
/* --- Register HW_DRAM_CTL08, field Q_ALMOST_FULL */

#define BP_DRAM_CTL08_Q_ALMOST_FULL      6
#define BM_DRAM_CTL08_Q_ALMOST_FULL      0x00000040

#define BF_DRAM_CTL08_Q_ALMOST_FULL(v)   (((v) << 6) & BM_DRAM_CTL08_Q_ALMOST_FULL)
/* --- Register HW_DRAM_CTL08, field SREFRESH_ACK */

#define BP_DRAM_CTL08_SREFRESH_ACK      5
#define BM_DRAM_CTL08_SREFRESH_ACK      0x00000020

#define BF_DRAM_CTL08_SREFRESH_ACK(v)   (((v) << 5) & BM_DRAM_CTL08_SREFRESH_ACK)
/* --- Register HW_DRAM_CTL08, field CKE_STATUS */

#define BP_DRAM_CTL08_CKE_STATUS      4
#define BM_DRAM_CTL08_CKE_STATUS      0x00000010

#define BF_DRAM_CTL08_CKE_STATUS(v)   (((v) << 4) & BM_DRAM_CTL08_CKE_STATUS)
/* --- Register HW_DRAM_CTL08, field COMMAND_ACCEPTED */

#define BP_DRAM_CTL08_COMMAND_ACCEPTED      0
#define BM_DRAM_CTL08_COMMAND_ACCEPTED      0x0000000F

#define BF_DRAM_CTL08_COMMAND_ACCEPTED(v)   (((v) << 0) & BM_DRAM_CTL08_COMMAND_ACCEPTED)


/*
 * HW_DRAM_CTL09 - DRAM Control Register 09
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned USER_DEF_REG_RO_1  : 32;
    } B;
} hw_dram_ctl09_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL09 register
 */
#define HW_DRAM_CTL09_ADDR         (REGS_DRAM_BASE + 0x24)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL09           (*(volatile hw_dram_ctl09_t *) HW_DRAM_CTL09_ADDR)
#define HW_DRAM_CTL09_RD()      (HW_DRAM_CTL09.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL09 bitfields
 */
/* --- Register HW_DRAM_CTL09, field USER_DEF_REG_RO_1 */

#define BP_DRAM_CTL09_USER_DEF_REG_RO_1      0
#define BM_DRAM_CTL09_USER_DEF_REG_RO_1      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL09_USER_DEF_REG_RO_1(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL09_USER_DEF_REG_RO_1(v)   (v)
#endif


/*
 * HW_DRAM_CTL10 - AXI0 Debug 0
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned WDATA_CNT  :  8;
        unsigned WRESP_CNT  :  8;
        unsigned READ_CNT   :  8;
        unsigned RSVD       :  8;
    } B;
} hw_dram_ctl10_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL10 register
 */
#define HW_DRAM_CTL10_ADDR         (REGS_DRAM_BASE + 0x28)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL10           (*(volatile hw_dram_ctl10_t *) HW_DRAM_CTL10_ADDR)
#define HW_DRAM_CTL10_RD()      (HW_DRAM_CTL10.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL10 bitfields
 */
/* --- Register HW_DRAM_CTL10, field RSVD */

#define BP_DRAM_CTL10_RSVD      24
#define BM_DRAM_CTL10_RSVD      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL10_RSVD(v)   ((((reg32_t) v) << 24) & BM_DRAM_CTL10_RSVD)
#else
#define BF_DRAM_CTL10_RSVD(v)   (((v) << 24) & BM_DRAM_CTL10_RSVD)
#endif
/* --- Register HW_DRAM_CTL10, field READ_CNT */

#define BP_DRAM_CTL10_READ_CNT      16
#define BM_DRAM_CTL10_READ_CNT      0x00FF0000

#define BF_DRAM_CTL10_READ_CNT(v)   (((v) << 16) & BM_DRAM_CTL10_READ_CNT)
/* --- Register HW_DRAM_CTL10, field WRESP_CNT */

#define BP_DRAM_CTL10_WRESP_CNT      8
#define BM_DRAM_CTL10_WRESP_CNT      0x0000FF00

#define BF_DRAM_CTL10_WRESP_CNT(v)   (((v) << 8) & BM_DRAM_CTL10_WRESP_CNT)
/* --- Register HW_DRAM_CTL10, field WDATA_CNT */

#define BP_DRAM_CTL10_WDATA_CNT      0
#define BM_DRAM_CTL10_WDATA_CNT      0x000000FF

#define BF_DRAM_CTL10_WDATA_CNT(v)   (((v) << 0) & BM_DRAM_CTL10_WDATA_CNT)


/*
 * HW_DRAM_CTL11 - AXI0 Debug 1
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned WLEN    :  8;
        unsigned RLEN    :  8;
        unsigned RSTATE  :  8;
        unsigned WSTATE  :  8;
    } B;
} hw_dram_ctl11_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL11 register
 */
#define HW_DRAM_CTL11_ADDR         (REGS_DRAM_BASE + 0x2c)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL11           (*(volatile hw_dram_ctl11_t *) HW_DRAM_CTL11_ADDR)
#define HW_DRAM_CTL11_RD()      (HW_DRAM_CTL11.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL11 bitfields
 */
/* --- Register HW_DRAM_CTL11, field WSTATE */

#define BP_DRAM_CTL11_WSTATE      24
#define BM_DRAM_CTL11_WSTATE      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL11_WSTATE(v)   ((((reg32_t) v) << 24) & BM_DRAM_CTL11_WSTATE)
#else
#define BF_DRAM_CTL11_WSTATE(v)   (((v) << 24) & BM_DRAM_CTL11_WSTATE)
#endif
/* --- Register HW_DRAM_CTL11, field RSTATE */

#define BP_DRAM_CTL11_RSTATE      16
#define BM_DRAM_CTL11_RSTATE      0x00FF0000

#define BF_DRAM_CTL11_RSTATE(v)   (((v) << 16) & BM_DRAM_CTL11_RSTATE)
/* --- Register HW_DRAM_CTL11, field RLEN */

#define BP_DRAM_CTL11_RLEN      8
#define BM_DRAM_CTL11_RLEN      0x0000FF00

#define BF_DRAM_CTL11_RLEN(v)   (((v) << 8) & BM_DRAM_CTL11_RLEN)
/* --- Register HW_DRAM_CTL11, field WLEN */

#define BP_DRAM_CTL11_WLEN      0
#define BM_DRAM_CTL11_WLEN      0x000000FF

#define BF_DRAM_CTL11_WLEN(v)   (((v) << 0) & BM_DRAM_CTL11_WLEN)


/*
 * HW_DRAM_CTL12 - AXI1 Debug 0
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned WDATA_CNT  :  8;
        unsigned WRESP_CNT  :  8;
        unsigned READ_CNT   :  8;
        unsigned RSVD       :  8;
    } B;
} hw_dram_ctl12_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL12 register
 */
#define HW_DRAM_CTL12_ADDR         (REGS_DRAM_BASE + 0x30)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL12           (*(volatile hw_dram_ctl12_t *) HW_DRAM_CTL12_ADDR)
#define HW_DRAM_CTL12_RD()      (HW_DRAM_CTL12.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL12 bitfields
 */
/* --- Register HW_DRAM_CTL12, field RSVD */

#define BP_DRAM_CTL12_RSVD      24
#define BM_DRAM_CTL12_RSVD      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL12_RSVD(v)   ((((reg32_t) v) << 24) & BM_DRAM_CTL12_RSVD)
#else
#define BF_DRAM_CTL12_RSVD(v)   (((v) << 24) & BM_DRAM_CTL12_RSVD)
#endif
/* --- Register HW_DRAM_CTL12, field READ_CNT */

#define BP_DRAM_CTL12_READ_CNT      16
#define BM_DRAM_CTL12_READ_CNT      0x00FF0000

#define BF_DRAM_CTL12_READ_CNT(v)   (((v) << 16) & BM_DRAM_CTL12_READ_CNT)
/* --- Register HW_DRAM_CTL12, field WRESP_CNT */

#define BP_DRAM_CTL12_WRESP_CNT      8
#define BM_DRAM_CTL12_WRESP_CNT      0x0000FF00

#define BF_DRAM_CTL12_WRESP_CNT(v)   (((v) << 8) & BM_DRAM_CTL12_WRESP_CNT)
/* --- Register HW_DRAM_CTL12, field WDATA_CNT */

#define BP_DRAM_CTL12_WDATA_CNT      0
#define BM_DRAM_CTL12_WDATA_CNT      0x000000FF

#define BF_DRAM_CTL12_WDATA_CNT(v)   (((v) << 0) & BM_DRAM_CTL12_WDATA_CNT)


/*
 * HW_DRAM_CTL13 - AXI1 Debug 1
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned WLEN    :  8;
        unsigned RLEN    :  8;
        unsigned RSTATE  :  8;
        unsigned WSTATE  :  8;
    } B;
} hw_dram_ctl13_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL13 register
 */
#define HW_DRAM_CTL13_ADDR         (REGS_DRAM_BASE + 0x34)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL13           (*(volatile hw_dram_ctl13_t *) HW_DRAM_CTL13_ADDR)
#define HW_DRAM_CTL13_RD()      (HW_DRAM_CTL13.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL13 bitfields
 */
/* --- Register HW_DRAM_CTL13, field WSTATE */

#define BP_DRAM_CTL13_WSTATE      24
#define BM_DRAM_CTL13_WSTATE      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL13_WSTATE(v)   ((((reg32_t) v) << 24) & BM_DRAM_CTL13_WSTATE)
#else
#define BF_DRAM_CTL13_WSTATE(v)   (((v) << 24) & BM_DRAM_CTL13_WSTATE)
#endif
/* --- Register HW_DRAM_CTL13, field RSTATE */

#define BP_DRAM_CTL13_RSTATE      16
#define BM_DRAM_CTL13_RSTATE      0x00FF0000

#define BF_DRAM_CTL13_RSTATE(v)   (((v) << 16) & BM_DRAM_CTL13_RSTATE)
/* --- Register HW_DRAM_CTL13, field RLEN */

#define BP_DRAM_CTL13_RLEN      8
#define BM_DRAM_CTL13_RLEN      0x0000FF00

#define BF_DRAM_CTL13_RLEN(v)   (((v) << 8) & BM_DRAM_CTL13_RLEN)
/* --- Register HW_DRAM_CTL13, field WLEN */

#define BP_DRAM_CTL13_WLEN      0
#define BM_DRAM_CTL13_WLEN      0x000000FF

#define BF_DRAM_CTL13_WLEN(v)   (((v) << 0) & BM_DRAM_CTL13_WLEN)


/*
 * HW_DRAM_CTL14 - AXI2 Debug 0
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned WDATA_CNT  :  8;
        unsigned WRESP_CNT  :  8;
        unsigned READ_CNT   :  8;
        unsigned RSVD       :  8;
    } B;
} hw_dram_ctl14_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL14 register
 */
#define HW_DRAM_CTL14_ADDR         (REGS_DRAM_BASE + 0x38)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL14           (*(volatile hw_dram_ctl14_t *) HW_DRAM_CTL14_ADDR)
#define HW_DRAM_CTL14_RD()      (HW_DRAM_CTL14.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL14 bitfields
 */
/* --- Register HW_DRAM_CTL14, field RSVD */

#define BP_DRAM_CTL14_RSVD      24
#define BM_DRAM_CTL14_RSVD      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL14_RSVD(v)   ((((reg32_t) v) << 24) & BM_DRAM_CTL14_RSVD)
#else
#define BF_DRAM_CTL14_RSVD(v)   (((v) << 24) & BM_DRAM_CTL14_RSVD)
#endif
/* --- Register HW_DRAM_CTL14, field READ_CNT */

#define BP_DRAM_CTL14_READ_CNT      16
#define BM_DRAM_CTL14_READ_CNT      0x00FF0000

#define BF_DRAM_CTL14_READ_CNT(v)   (((v) << 16) & BM_DRAM_CTL14_READ_CNT)
/* --- Register HW_DRAM_CTL14, field WRESP_CNT */

#define BP_DRAM_CTL14_WRESP_CNT      8
#define BM_DRAM_CTL14_WRESP_CNT      0x0000FF00

#define BF_DRAM_CTL14_WRESP_CNT(v)   (((v) << 8) & BM_DRAM_CTL14_WRESP_CNT)
/* --- Register HW_DRAM_CTL14, field WDATA_CNT */

#define BP_DRAM_CTL14_WDATA_CNT      0
#define BM_DRAM_CTL14_WDATA_CNT      0x000000FF

#define BF_DRAM_CTL14_WDATA_CNT(v)   (((v) << 0) & BM_DRAM_CTL14_WDATA_CNT)


/*
 * HW_DRAM_CTL15 - AXI2 Debug 1
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned WLEN    :  8;
        unsigned RLEN    :  8;
        unsigned RSTATE  :  8;
        unsigned WSTATE  :  8;
    } B;
} hw_dram_ctl15_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL15 register
 */
#define HW_DRAM_CTL15_ADDR         (REGS_DRAM_BASE + 0x3c)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL15           (*(volatile hw_dram_ctl15_t *) HW_DRAM_CTL15_ADDR)
#define HW_DRAM_CTL15_RD()      (HW_DRAM_CTL15.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL15 bitfields
 */
/* --- Register HW_DRAM_CTL15, field WSTATE */

#define BP_DRAM_CTL15_WSTATE      24
#define BM_DRAM_CTL15_WSTATE      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL15_WSTATE(v)   ((((reg32_t) v) << 24) & BM_DRAM_CTL15_WSTATE)
#else
#define BF_DRAM_CTL15_WSTATE(v)   (((v) << 24) & BM_DRAM_CTL15_WSTATE)
#endif
/* --- Register HW_DRAM_CTL15, field RSTATE */

#define BP_DRAM_CTL15_RSTATE      16
#define BM_DRAM_CTL15_RSTATE      0x00FF0000

#define BF_DRAM_CTL15_RSTATE(v)   (((v) << 16) & BM_DRAM_CTL15_RSTATE)
/* --- Register HW_DRAM_CTL15, field RLEN */

#define BP_DRAM_CTL15_RLEN      8
#define BM_DRAM_CTL15_RLEN      0x0000FF00

#define BF_DRAM_CTL15_RLEN(v)   (((v) << 8) & BM_DRAM_CTL15_RLEN)
/* --- Register HW_DRAM_CTL15, field WLEN */

#define BP_DRAM_CTL15_WLEN      0
#define BM_DRAM_CTL15_WLEN      0x000000FF

#define BF_DRAM_CTL15_WLEN(v)   (((v) << 0) & BM_DRAM_CTL15_WLEN)


/*
 * HW_DRAM_CTL16 - DRAM Control Register 16
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned START          :  1;
        unsigned RSVD1          :  7;
        unsigned OBSOLETE       :  8;
        unsigned POWER_DOWN     :  1;
        unsigned RSVD2          :  7;
        unsigned WRITE_MODEREG  :  1;
        unsigned RSVD3          :  7;
    } B;
} hw_dram_ctl16_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL16 register
 */
#define HW_DRAM_CTL16_ADDR         (REGS_DRAM_BASE + 0x40)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL16           (*(volatile hw_dram_ctl16_t *) HW_DRAM_CTL16_ADDR)
#define HW_DRAM_CTL16_RD()      (HW_DRAM_CTL16.U)
#define HW_DRAM_CTL16_WR(v)     (HW_DRAM_CTL16.U = (v))
#define HW_DRAM_CTL16_SET(v)    (HW_DRAM_CTL16_WR(HW_DRAM_CTL16_RD() |  (v)))
#define HW_DRAM_CTL16_CLR(v)    (HW_DRAM_CTL16_WR(HW_DRAM_CTL16_RD() & ~(v)))
#define HW_DRAM_CTL16_TOG(v)    (HW_DRAM_CTL16_WR(HW_DRAM_CTL16_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL16 bitfields
 */
/* --- Register HW_DRAM_CTL16, field RSVD3 */

#define BP_DRAM_CTL16_RSVD3      25
#define BM_DRAM_CTL16_RSVD3      0xFE000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL16_RSVD3(v)   ((((reg32_t) v) << 25) & BM_DRAM_CTL16_RSVD3)
#else
#define BF_DRAM_CTL16_RSVD3(v)   (((v) << 25) & BM_DRAM_CTL16_RSVD3)
#endif
/* --- Register HW_DRAM_CTL16, field WRITE_MODEREG */

#define BP_DRAM_CTL16_WRITE_MODEREG      24
#define BM_DRAM_CTL16_WRITE_MODEREG      0x01000000

#define BF_DRAM_CTL16_WRITE_MODEREG(v)   (((v) << 24) & BM_DRAM_CTL16_WRITE_MODEREG)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL16_WRITE_MODEREG(v)   BF_CS1(DRAM_CTL16, WRITE_MODEREG, v)
#endif

/* --- Register HW_DRAM_CTL16, field RSVD2 */

#define BP_DRAM_CTL16_RSVD2      17
#define BM_DRAM_CTL16_RSVD2      0x00FE0000

#define BF_DRAM_CTL16_RSVD2(v)   (((v) << 17) & BM_DRAM_CTL16_RSVD2)
/* --- Register HW_DRAM_CTL16, field POWER_DOWN */

#define BP_DRAM_CTL16_POWER_DOWN      16
#define BM_DRAM_CTL16_POWER_DOWN      0x00010000

#define BF_DRAM_CTL16_POWER_DOWN(v)   (((v) << 16) & BM_DRAM_CTL16_POWER_DOWN)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL16_POWER_DOWN(v)   BF_CS1(DRAM_CTL16, POWER_DOWN, v)
#endif

/* --- Register HW_DRAM_CTL16, field OBSOLETE */

#define BP_DRAM_CTL16_OBSOLETE      8
#define BM_DRAM_CTL16_OBSOLETE      0x0000FF00

#define BF_DRAM_CTL16_OBSOLETE(v)   (((v) << 8) & BM_DRAM_CTL16_OBSOLETE)
/* --- Register HW_DRAM_CTL16, field RSVD1 */

#define BP_DRAM_CTL16_RSVD1      1
#define BM_DRAM_CTL16_RSVD1      0x000000FE

#define BF_DRAM_CTL16_RSVD1(v)   (((v) << 1) & BM_DRAM_CTL16_RSVD1)
/* --- Register HW_DRAM_CTL16, field START */

#define BP_DRAM_CTL16_START      0
#define BM_DRAM_CTL16_START      0x00000001

#define BF_DRAM_CTL16_START(v)   (((v) << 0) & BM_DRAM_CTL16_START)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL16_START(v)   BF_CS1(DRAM_CTL16, START, v)
#endif



/*
 * HW_DRAM_CTL17 - DRAM Control Register 17
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned SREFRESH               :  1;
        unsigned RSVD1                  :  7;
        unsigned ENABLE_QUICK_SREFRESH  :  1;
        unsigned RSVD2                  :  7;
        unsigned AREFRESH               :  1;
        unsigned RSVD3                  :  7;
        unsigned AUTO_REFRESH_MODE      :  1;
        unsigned RSVD4                  :  7;
    } B;
} hw_dram_ctl17_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL17 register
 */
#define HW_DRAM_CTL17_ADDR         (REGS_DRAM_BASE + 0x44)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL17           (*(volatile hw_dram_ctl17_t *) HW_DRAM_CTL17_ADDR)
#define HW_DRAM_CTL17_RD()      (HW_DRAM_CTL17.U)
#define HW_DRAM_CTL17_WR(v)     (HW_DRAM_CTL17.U = (v))
#define HW_DRAM_CTL17_SET(v)    (HW_DRAM_CTL17_WR(HW_DRAM_CTL17_RD() |  (v)))
#define HW_DRAM_CTL17_CLR(v)    (HW_DRAM_CTL17_WR(HW_DRAM_CTL17_RD() & ~(v)))
#define HW_DRAM_CTL17_TOG(v)    (HW_DRAM_CTL17_WR(HW_DRAM_CTL17_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL17 bitfields
 */
/* --- Register HW_DRAM_CTL17, field RSVD4 */

#define BP_DRAM_CTL17_RSVD4      25
#define BM_DRAM_CTL17_RSVD4      0xFE000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL17_RSVD4(v)   ((((reg32_t) v) << 25) & BM_DRAM_CTL17_RSVD4)
#else
#define BF_DRAM_CTL17_RSVD4(v)   (((v) << 25) & BM_DRAM_CTL17_RSVD4)
#endif
/* --- Register HW_DRAM_CTL17, field AUTO_REFRESH_MODE */

#define BP_DRAM_CTL17_AUTO_REFRESH_MODE      24
#define BM_DRAM_CTL17_AUTO_REFRESH_MODE      0x01000000

#define BF_DRAM_CTL17_AUTO_REFRESH_MODE(v)   (((v) << 24) & BM_DRAM_CTL17_AUTO_REFRESH_MODE)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL17_AUTO_REFRESH_MODE(v)   BF_CS1(DRAM_CTL17, AUTO_REFRESH_MODE, v)
#endif

/* --- Register HW_DRAM_CTL17, field RSVD3 */

#define BP_DRAM_CTL17_RSVD3      17
#define BM_DRAM_CTL17_RSVD3      0x00FE0000

#define BF_DRAM_CTL17_RSVD3(v)   (((v) << 17) & BM_DRAM_CTL17_RSVD3)
/* --- Register HW_DRAM_CTL17, field AREFRESH */

#define BP_DRAM_CTL17_AREFRESH      16
#define BM_DRAM_CTL17_AREFRESH      0x00010000

#define BF_DRAM_CTL17_AREFRESH(v)   (((v) << 16) & BM_DRAM_CTL17_AREFRESH)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL17_AREFRESH(v)   BF_CS1(DRAM_CTL17, AREFRESH, v)
#endif

/* --- Register HW_DRAM_CTL17, field RSVD2 */

#define BP_DRAM_CTL17_RSVD2      9
#define BM_DRAM_CTL17_RSVD2      0x0000FE00

#define BF_DRAM_CTL17_RSVD2(v)   (((v) << 9) & BM_DRAM_CTL17_RSVD2)
/* --- Register HW_DRAM_CTL17, field ENABLE_QUICK_SREFRESH */

#define BP_DRAM_CTL17_ENABLE_QUICK_SREFRESH      8
#define BM_DRAM_CTL17_ENABLE_QUICK_SREFRESH      0x00000100

#define BF_DRAM_CTL17_ENABLE_QUICK_SREFRESH(v)   (((v) << 8) & BM_DRAM_CTL17_ENABLE_QUICK_SREFRESH)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL17_ENABLE_QUICK_SREFRESH(v)   BF_CS1(DRAM_CTL17, ENABLE_QUICK_SREFRESH, v)
#endif

/* --- Register HW_DRAM_CTL17, field RSVD1 */

#define BP_DRAM_CTL17_RSVD1      1
#define BM_DRAM_CTL17_RSVD1      0x000000FE

#define BF_DRAM_CTL17_RSVD1(v)   (((v) << 1) & BM_DRAM_CTL17_RSVD1)
/* --- Register HW_DRAM_CTL17, field SREFRESH */

#define BP_DRAM_CTL17_SREFRESH      0
#define BM_DRAM_CTL17_SREFRESH      0x00000001

#define BF_DRAM_CTL17_SREFRESH(v)   (((v) << 0) & BM_DRAM_CTL17_SREFRESH)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL17_SREFRESH(v)   BF_CS1(DRAM_CTL17, SREFRESH, v)
#endif



/*
 * HW_DRAM_CTL21 - DRAM Control Register 21
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_BYPASS_MODE  :  1;
        unsigned RSVD1            :  7;
        unsigned DLLLOCKREG       :  1;
        unsigned RSVD2            :  7;
        unsigned DLL_LOCK         :  8;
        unsigned CKE_DELAY        :  3;
        unsigned RSVD3            :  5;
    } B;
} hw_dram_ctl21_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL21 register
 */
#define HW_DRAM_CTL21_ADDR         (REGS_DRAM_BASE + 0x54)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL21           (*(volatile hw_dram_ctl21_t *) HW_DRAM_CTL21_ADDR)
#define HW_DRAM_CTL21_RD()      (HW_DRAM_CTL21.U)
#define HW_DRAM_CTL21_WR(v)     (HW_DRAM_CTL21.U = (v))
#define HW_DRAM_CTL21_SET(v)    (HW_DRAM_CTL21_WR(HW_DRAM_CTL21_RD() |  (v)))
#define HW_DRAM_CTL21_CLR(v)    (HW_DRAM_CTL21_WR(HW_DRAM_CTL21_RD() & ~(v)))
#define HW_DRAM_CTL21_TOG(v)    (HW_DRAM_CTL21_WR(HW_DRAM_CTL21_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL21 bitfields
 */
/* --- Register HW_DRAM_CTL21, field RSVD3 */

#define BP_DRAM_CTL21_RSVD3      27
#define BM_DRAM_CTL21_RSVD3      0xF8000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL21_RSVD3(v)   ((((reg32_t) v) << 27) & BM_DRAM_CTL21_RSVD3)
#else
#define BF_DRAM_CTL21_RSVD3(v)   (((v) << 27) & BM_DRAM_CTL21_RSVD3)
#endif
/* --- Register HW_DRAM_CTL21, field CKE_DELAY */

#define BP_DRAM_CTL21_CKE_DELAY      24
#define BM_DRAM_CTL21_CKE_DELAY      0x07000000

#define BF_DRAM_CTL21_CKE_DELAY(v)   (((v) << 24) & BM_DRAM_CTL21_CKE_DELAY)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL21_CKE_DELAY(v)   BF_CS1(DRAM_CTL21, CKE_DELAY, v)
#endif

/* --- Register HW_DRAM_CTL21, field DLL_LOCK */

#define BP_DRAM_CTL21_DLL_LOCK      16
#define BM_DRAM_CTL21_DLL_LOCK      0x00FF0000

#define BF_DRAM_CTL21_DLL_LOCK(v)   (((v) << 16) & BM_DRAM_CTL21_DLL_LOCK)
/* --- Register HW_DRAM_CTL21, field RSVD2 */

#define BP_DRAM_CTL21_RSVD2      9
#define BM_DRAM_CTL21_RSVD2      0x0000FE00

#define BF_DRAM_CTL21_RSVD2(v)   (((v) << 9) & BM_DRAM_CTL21_RSVD2)
/* --- Register HW_DRAM_CTL21, field DLLLOCKREG */

#define BP_DRAM_CTL21_DLLLOCKREG      8
#define BM_DRAM_CTL21_DLLLOCKREG      0x00000100

#define BF_DRAM_CTL21_DLLLOCKREG(v)   (((v) << 8) & BM_DRAM_CTL21_DLLLOCKREG)
/* --- Register HW_DRAM_CTL21, field RSVD1 */

#define BP_DRAM_CTL21_RSVD1      1
#define BM_DRAM_CTL21_RSVD1      0x000000FE

#define BF_DRAM_CTL21_RSVD1(v)   (((v) << 1) & BM_DRAM_CTL21_RSVD1)
/* --- Register HW_DRAM_CTL21, field DLL_BYPASS_MODE */

#define BP_DRAM_CTL21_DLL_BYPASS_MODE      0
#define BM_DRAM_CTL21_DLL_BYPASS_MODE      0x00000001

#define BF_DRAM_CTL21_DLL_BYPASS_MODE(v)   (((v) << 0) & BM_DRAM_CTL21_DLL_BYPASS_MODE)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL21_DLL_BYPASS_MODE(v)   BF_CS1(DRAM_CTL21, DLL_BYPASS_MODE, v)
#endif



/*
 * HW_DRAM_CTL22 - DRAM Control Register 22
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned LOWPOWER_AUTO_ENABLE     :  5;
        unsigned RSVD1                    :  3;
        unsigned LOWPOWER_CONTROL         :  5;
        unsigned RSVD2                    :  3;
        unsigned LOWPOWER_REFRESH_ENABLE  :  4;
        unsigned RSVD3                    :  4;
        unsigned OBSOLETE                 :  8;
    } B;
} hw_dram_ctl22_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL22 register
 */
#define HW_DRAM_CTL22_ADDR         (REGS_DRAM_BASE + 0x58)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL22           (*(volatile hw_dram_ctl22_t *) HW_DRAM_CTL22_ADDR)
#define HW_DRAM_CTL22_RD()      (HW_DRAM_CTL22.U)
#define HW_DRAM_CTL22_WR(v)     (HW_DRAM_CTL22.U = (v))
#define HW_DRAM_CTL22_SET(v)    (HW_DRAM_CTL22_WR(HW_DRAM_CTL22_RD() |  (v)))
#define HW_DRAM_CTL22_CLR(v)    (HW_DRAM_CTL22_WR(HW_DRAM_CTL22_RD() & ~(v)))
#define HW_DRAM_CTL22_TOG(v)    (HW_DRAM_CTL22_WR(HW_DRAM_CTL22_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL22 bitfields
 */
/* --- Register HW_DRAM_CTL22, field OBSOLETE */

#define BP_DRAM_CTL22_OBSOLETE      24
#define BM_DRAM_CTL22_OBSOLETE      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL22_OBSOLETE(v)   ((((reg32_t) v) << 24) & BM_DRAM_CTL22_OBSOLETE)
#else
#define BF_DRAM_CTL22_OBSOLETE(v)   (((v) << 24) & BM_DRAM_CTL22_OBSOLETE)
#endif
/* --- Register HW_DRAM_CTL22, field RSVD3 */

#define BP_DRAM_CTL22_RSVD3      20
#define BM_DRAM_CTL22_RSVD3      0x00F00000

#define BF_DRAM_CTL22_RSVD3(v)   (((v) << 20) & BM_DRAM_CTL22_RSVD3)
/* --- Register HW_DRAM_CTL22, field LOWPOWER_REFRESH_ENABLE */

#define BP_DRAM_CTL22_LOWPOWER_REFRESH_ENABLE      16
#define BM_DRAM_CTL22_LOWPOWER_REFRESH_ENABLE      0x000F0000

#define BF_DRAM_CTL22_LOWPOWER_REFRESH_ENABLE(v)   (((v) << 16) & BM_DRAM_CTL22_LOWPOWER_REFRESH_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL22_LOWPOWER_REFRESH_ENABLE(v)   BF_CS1(DRAM_CTL22, LOWPOWER_REFRESH_ENABLE, v)
#endif

/* --- Register HW_DRAM_CTL22, field RSVD2 */

#define BP_DRAM_CTL22_RSVD2      13
#define BM_DRAM_CTL22_RSVD2      0x0000E000

#define BF_DRAM_CTL22_RSVD2(v)   (((v) << 13) & BM_DRAM_CTL22_RSVD2)
/* --- Register HW_DRAM_CTL22, field LOWPOWER_CONTROL */

#define BP_DRAM_CTL22_LOWPOWER_CONTROL      8
#define BM_DRAM_CTL22_LOWPOWER_CONTROL      0x00001F00

#define BF_DRAM_CTL22_LOWPOWER_CONTROL(v)   (((v) << 8) & BM_DRAM_CTL22_LOWPOWER_CONTROL)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL22_LOWPOWER_CONTROL(v)   BF_CS1(DRAM_CTL22, LOWPOWER_CONTROL, v)
#endif

/* --- Register HW_DRAM_CTL22, field RSVD1 */

#define BP_DRAM_CTL22_RSVD1      5
#define BM_DRAM_CTL22_RSVD1      0x000000E0

#define BF_DRAM_CTL22_RSVD1(v)   (((v) << 5) & BM_DRAM_CTL22_RSVD1)
/* --- Register HW_DRAM_CTL22, field LOWPOWER_AUTO_ENABLE */

#define BP_DRAM_CTL22_LOWPOWER_AUTO_ENABLE      0
#define BM_DRAM_CTL22_LOWPOWER_AUTO_ENABLE      0x0000001F

#define BF_DRAM_CTL22_LOWPOWER_AUTO_ENABLE(v)   (((v) << 0) & BM_DRAM_CTL22_LOWPOWER_AUTO_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL22_LOWPOWER_AUTO_ENABLE(v)   BF_CS1(DRAM_CTL22, LOWPOWER_AUTO_ENABLE, v)
#endif



/*
 * HW_DRAM_CTL23 - DRAM Control Register 23
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned LOWPOWER_EXTERNAL_CNT  : 16;
        unsigned LOWPOWER_INTERNAL_CNT  : 16;
    } B;
} hw_dram_ctl23_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL23 register
 */
#define HW_DRAM_CTL23_ADDR         (REGS_DRAM_BASE + 0x5c)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL23           (*(volatile hw_dram_ctl23_t *) HW_DRAM_CTL23_ADDR)
#define HW_DRAM_CTL23_RD()      (HW_DRAM_CTL23.U)
#define HW_DRAM_CTL23_WR(v)     (HW_DRAM_CTL23.U = (v))
#define HW_DRAM_CTL23_SET(v)    (HW_DRAM_CTL23_WR(HW_DRAM_CTL23_RD() |  (v)))
#define HW_DRAM_CTL23_CLR(v)    (HW_DRAM_CTL23_WR(HW_DRAM_CTL23_RD() & ~(v)))
#define HW_DRAM_CTL23_TOG(v)    (HW_DRAM_CTL23_WR(HW_DRAM_CTL23_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL23 bitfields
 */
/* --- Register HW_DRAM_CTL23, field LOWPOWER_INTERNAL_CNT */

#define BP_DRAM_CTL23_LOWPOWER_INTERNAL_CNT      16
#define BM_DRAM_CTL23_LOWPOWER_INTERNAL_CNT      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL23_LOWPOWER_INTERNAL_CNT(v)   ((((reg32_t) v) << 16) & BM_DRAM_CTL23_LOWPOWER_INTERNAL_CNT)
#else
#define BF_DRAM_CTL23_LOWPOWER_INTERNAL_CNT(v)   (((v) << 16) & BM_DRAM_CTL23_LOWPOWER_INTERNAL_CNT)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL23_LOWPOWER_INTERNAL_CNT(v)   (HW_DRAM_CTL23.B.LOWPOWER_INTERNAL_CNT = (v))
#endif

/* --- Register HW_DRAM_CTL23, field LOWPOWER_EXTERNAL_CNT */

#define BP_DRAM_CTL23_LOWPOWER_EXTERNAL_CNT      0
#define BM_DRAM_CTL23_LOWPOWER_EXTERNAL_CNT      0x0000FFFF

#define BF_DRAM_CTL23_LOWPOWER_EXTERNAL_CNT(v)   (((v) << 0) & BM_DRAM_CTL23_LOWPOWER_EXTERNAL_CNT)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL23_LOWPOWER_EXTERNAL_CNT(v)   (HW_DRAM_CTL23.B.LOWPOWER_EXTERNAL_CNT = (v))
#endif



/*
 * HW_DRAM_CTL24 - DRAM Control Register 24
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned LOWPOWER_REFRESH_HOLD      : 16;
        unsigned LOWPOWER_SELF_REFRESH_CNT  : 16;
    } B;
} hw_dram_ctl24_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL24 register
 */
#define HW_DRAM_CTL24_ADDR         (REGS_DRAM_BASE + 0x60)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL24           (*(volatile hw_dram_ctl24_t *) HW_DRAM_CTL24_ADDR)
#define HW_DRAM_CTL24_RD()      (HW_DRAM_CTL24.U)
#define HW_DRAM_CTL24_WR(v)     (HW_DRAM_CTL24.U = (v))
#define HW_DRAM_CTL24_SET(v)    (HW_DRAM_CTL24_WR(HW_DRAM_CTL24_RD() |  (v)))
#define HW_DRAM_CTL24_CLR(v)    (HW_DRAM_CTL24_WR(HW_DRAM_CTL24_RD() & ~(v)))
#define HW_DRAM_CTL24_TOG(v)    (HW_DRAM_CTL24_WR(HW_DRAM_CTL24_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL24 bitfields
 */
/* --- Register HW_DRAM_CTL24, field LOWPOWER_SELF_REFRESH_CNT */

#define BP_DRAM_CTL24_LOWPOWER_SELF_REFRESH_CNT      16
#define BM_DRAM_CTL24_LOWPOWER_SELF_REFRESH_CNT      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL24_LOWPOWER_SELF_REFRESH_CNT(v)   ((((reg32_t) v) << 16) & BM_DRAM_CTL24_LOWPOWER_SELF_REFRESH_CNT)
#else
#define BF_DRAM_CTL24_LOWPOWER_SELF_REFRESH_CNT(v)   (((v) << 16) & BM_DRAM_CTL24_LOWPOWER_SELF_REFRESH_CNT)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL24_LOWPOWER_SELF_REFRESH_CNT(v)   (HW_DRAM_CTL24.B.LOWPOWER_SELF_REFRESH_CNT = (v))
#endif

/* --- Register HW_DRAM_CTL24, field LOWPOWER_REFRESH_HOLD */

#define BP_DRAM_CTL24_LOWPOWER_REFRESH_HOLD      0
#define BM_DRAM_CTL24_LOWPOWER_REFRESH_HOLD      0x0000FFFF

#define BF_DRAM_CTL24_LOWPOWER_REFRESH_HOLD(v)   (((v) << 0) & BM_DRAM_CTL24_LOWPOWER_REFRESH_HOLD)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL24_LOWPOWER_REFRESH_HOLD(v)   (HW_DRAM_CTL24.B.LOWPOWER_REFRESH_HOLD = (v))
#endif



/*
 * HW_DRAM_CTL25 - DRAM Control Register 25
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned LOWPOWER_POWER_DOWN_CNT  : 16;
        unsigned OBSOLETE                 : 16;
    } B;
} hw_dram_ctl25_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL25 register
 */
#define HW_DRAM_CTL25_ADDR         (REGS_DRAM_BASE + 0x64)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL25           (*(volatile hw_dram_ctl25_t *) HW_DRAM_CTL25_ADDR)
#define HW_DRAM_CTL25_RD()      (HW_DRAM_CTL25.U)
#define HW_DRAM_CTL25_WR(v)     (HW_DRAM_CTL25.U = (v))
#define HW_DRAM_CTL25_SET(v)    (HW_DRAM_CTL25_WR(HW_DRAM_CTL25_RD() |  (v)))
#define HW_DRAM_CTL25_CLR(v)    (HW_DRAM_CTL25_WR(HW_DRAM_CTL25_RD() & ~(v)))
#define HW_DRAM_CTL25_TOG(v)    (HW_DRAM_CTL25_WR(HW_DRAM_CTL25_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL25 bitfields
 */
/* --- Register HW_DRAM_CTL25, field OBSOLETE */

#define BP_DRAM_CTL25_OBSOLETE      16
#define BM_DRAM_CTL25_OBSOLETE      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL25_OBSOLETE(v)   ((((reg32_t) v) << 16) & BM_DRAM_CTL25_OBSOLETE)
#else
#define BF_DRAM_CTL25_OBSOLETE(v)   (((v) << 16) & BM_DRAM_CTL25_OBSOLETE)
#endif
/* --- Register HW_DRAM_CTL25, field LOWPOWER_POWER_DOWN_CNT */

#define BP_DRAM_CTL25_LOWPOWER_POWER_DOWN_CNT      0
#define BM_DRAM_CTL25_LOWPOWER_POWER_DOWN_CNT      0x0000FFFF

#define BF_DRAM_CTL25_LOWPOWER_POWER_DOWN_CNT(v)   (((v) << 0) & BM_DRAM_CTL25_LOWPOWER_POWER_DOWN_CNT)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL25_LOWPOWER_POWER_DOWN_CNT(v)   (HW_DRAM_CTL25.B.LOWPOWER_POWER_DOWN_CNT = (v))
#endif



/*
 * HW_DRAM_CTL26 - DRAM Control Register 26
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PLACEMENT_EN  :  1;
        unsigned RSVD1         :  7;
        unsigned ADDR_CMP_EN   :  1;
        unsigned RSVD2         :  7;
        unsigned PRIORITY_EN   :  1;
        unsigned RSVD3         :  7;
        unsigned OBSOLETE      :  8;
    } B;
} hw_dram_ctl26_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL26 register
 */
#define HW_DRAM_CTL26_ADDR         (REGS_DRAM_BASE + 0x68)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL26           (*(volatile hw_dram_ctl26_t *) HW_DRAM_CTL26_ADDR)
#define HW_DRAM_CTL26_RD()      (HW_DRAM_CTL26.U)
#define HW_DRAM_CTL26_WR(v)     (HW_DRAM_CTL26.U = (v))
#define HW_DRAM_CTL26_SET(v)    (HW_DRAM_CTL26_WR(HW_DRAM_CTL26_RD() |  (v)))
#define HW_DRAM_CTL26_CLR(v)    (HW_DRAM_CTL26_WR(HW_DRAM_CTL26_RD() & ~(v)))
#define HW_DRAM_CTL26_TOG(v)    (HW_DRAM_CTL26_WR(HW_DRAM_CTL26_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL26 bitfields
 */
/* --- Register HW_DRAM_CTL26, field OBSOLETE */

#define BP_DRAM_CTL26_OBSOLETE      24
#define BM_DRAM_CTL26_OBSOLETE      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL26_OBSOLETE(v)   ((((reg32_t) v) << 24) & BM_DRAM_CTL26_OBSOLETE)
#else
#define BF_DRAM_CTL26_OBSOLETE(v)   (((v) << 24) & BM_DRAM_CTL26_OBSOLETE)
#endif
/* --- Register HW_DRAM_CTL26, field RSVD3 */

#define BP_DRAM_CTL26_RSVD3      17
#define BM_DRAM_CTL26_RSVD3      0x00FE0000

#define BF_DRAM_CTL26_RSVD3(v)   (((v) << 17) & BM_DRAM_CTL26_RSVD3)
/* --- Register HW_DRAM_CTL26, field PRIORITY_EN */

#define BP_DRAM_CTL26_PRIORITY_EN      16
#define BM_DRAM_CTL26_PRIORITY_EN      0x00010000

#define BF_DRAM_CTL26_PRIORITY_EN(v)   (((v) << 16) & BM_DRAM_CTL26_PRIORITY_EN)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL26_PRIORITY_EN(v)   BF_CS1(DRAM_CTL26, PRIORITY_EN, v)
#endif

/* --- Register HW_DRAM_CTL26, field RSVD2 */

#define BP_DRAM_CTL26_RSVD2      9
#define BM_DRAM_CTL26_RSVD2      0x0000FE00

#define BF_DRAM_CTL26_RSVD2(v)   (((v) << 9) & BM_DRAM_CTL26_RSVD2)
/* --- Register HW_DRAM_CTL26, field ADDR_CMP_EN */

#define BP_DRAM_CTL26_ADDR_CMP_EN      8
#define BM_DRAM_CTL26_ADDR_CMP_EN      0x00000100

#define BF_DRAM_CTL26_ADDR_CMP_EN(v)   (((v) << 8) & BM_DRAM_CTL26_ADDR_CMP_EN)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL26_ADDR_CMP_EN(v)   BF_CS1(DRAM_CTL26, ADDR_CMP_EN, v)
#endif

/* --- Register HW_DRAM_CTL26, field RSVD1 */

#define BP_DRAM_CTL26_RSVD1      1
#define BM_DRAM_CTL26_RSVD1      0x000000FE

#define BF_DRAM_CTL26_RSVD1(v)   (((v) << 1) & BM_DRAM_CTL26_RSVD1)
/* --- Register HW_DRAM_CTL26, field PLACEMENT_EN */

#define BP_DRAM_CTL26_PLACEMENT_EN      0
#define BM_DRAM_CTL26_PLACEMENT_EN      0x00000001

#define BF_DRAM_CTL26_PLACEMENT_EN(v)   (((v) << 0) & BM_DRAM_CTL26_PLACEMENT_EN)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL26_PLACEMENT_EN(v)   BF_CS1(DRAM_CTL26, PLACEMENT_EN, v)
#endif



/*
 * HW_DRAM_CTL27 - DRAM Control Register 27
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RW_SAME_EN            :  1;
        unsigned RSVD1                 :  7;
        unsigned BANK_SPLIT_EN         :  1;
        unsigned RSVD2                 :  7;
        unsigned SWAP_EN               :  1;
        unsigned RSVD3                 :  7;
        unsigned SWAP_PORT_RW_SAME_EN  :  1;
        unsigned RSVD4                 :  7;
    } B;
} hw_dram_ctl27_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL27 register
 */
#define HW_DRAM_CTL27_ADDR         (REGS_DRAM_BASE + 0x6c)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL27           (*(volatile hw_dram_ctl27_t *) HW_DRAM_CTL27_ADDR)
#define HW_DRAM_CTL27_RD()      (HW_DRAM_CTL27.U)
#define HW_DRAM_CTL27_WR(v)     (HW_DRAM_CTL27.U = (v))
#define HW_DRAM_CTL27_SET(v)    (HW_DRAM_CTL27_WR(HW_DRAM_CTL27_RD() |  (v)))
#define HW_DRAM_CTL27_CLR(v)    (HW_DRAM_CTL27_WR(HW_DRAM_CTL27_RD() & ~(v)))
#define HW_DRAM_CTL27_TOG(v)    (HW_DRAM_CTL27_WR(HW_DRAM_CTL27_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL27 bitfields
 */
/* --- Register HW_DRAM_CTL27, field RSVD4 */

#define BP_DRAM_CTL27_RSVD4      25
#define BM_DRAM_CTL27_RSVD4      0xFE000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL27_RSVD4(v)   ((((reg32_t) v) << 25) & BM_DRAM_CTL27_RSVD4)
#else
#define BF_DRAM_CTL27_RSVD4(v)   (((v) << 25) & BM_DRAM_CTL27_RSVD4)
#endif
/* --- Register HW_DRAM_CTL27, field SWAP_PORT_RW_SAME_EN */

#define BP_DRAM_CTL27_SWAP_PORT_RW_SAME_EN      24
#define BM_DRAM_CTL27_SWAP_PORT_RW_SAME_EN      0x01000000

#define BF_DRAM_CTL27_SWAP_PORT_RW_SAME_EN(v)   (((v) << 24) & BM_DRAM_CTL27_SWAP_PORT_RW_SAME_EN)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL27_SWAP_PORT_RW_SAME_EN(v)   BF_CS1(DRAM_CTL27, SWAP_PORT_RW_SAME_EN, v)
#endif

/* --- Register HW_DRAM_CTL27, field RSVD3 */

#define BP_DRAM_CTL27_RSVD3      17
#define BM_DRAM_CTL27_RSVD3      0x00FE0000

#define BF_DRAM_CTL27_RSVD3(v)   (((v) << 17) & BM_DRAM_CTL27_RSVD3)
/* --- Register HW_DRAM_CTL27, field SWAP_EN */

#define BP_DRAM_CTL27_SWAP_EN      16
#define BM_DRAM_CTL27_SWAP_EN      0x00010000

#define BF_DRAM_CTL27_SWAP_EN(v)   (((v) << 16) & BM_DRAM_CTL27_SWAP_EN)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL27_SWAP_EN(v)   BF_CS1(DRAM_CTL27, SWAP_EN, v)
#endif

/* --- Register HW_DRAM_CTL27, field RSVD2 */

#define BP_DRAM_CTL27_RSVD2      9
#define BM_DRAM_CTL27_RSVD2      0x0000FE00

#define BF_DRAM_CTL27_RSVD2(v)   (((v) << 9) & BM_DRAM_CTL27_RSVD2)
/* --- Register HW_DRAM_CTL27, field BANK_SPLIT_EN */

#define BP_DRAM_CTL27_BANK_SPLIT_EN      8
#define BM_DRAM_CTL27_BANK_SPLIT_EN      0x00000100

#define BF_DRAM_CTL27_BANK_SPLIT_EN(v)   (((v) << 8) & BM_DRAM_CTL27_BANK_SPLIT_EN)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL27_BANK_SPLIT_EN(v)   BF_CS1(DRAM_CTL27, BANK_SPLIT_EN, v)
#endif

/* --- Register HW_DRAM_CTL27, field RSVD1 */

#define BP_DRAM_CTL27_RSVD1      1
#define BM_DRAM_CTL27_RSVD1      0x000000FE

#define BF_DRAM_CTL27_RSVD1(v)   (((v) << 1) & BM_DRAM_CTL27_RSVD1)
/* --- Register HW_DRAM_CTL27, field RW_SAME_EN */

#define BP_DRAM_CTL27_RW_SAME_EN      0
#define BM_DRAM_CTL27_RW_SAME_EN      0x00000001

#define BF_DRAM_CTL27_RW_SAME_EN(v)   (((v) << 0) & BM_DRAM_CTL27_RW_SAME_EN)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL27_RW_SAME_EN(v)   BF_CS1(DRAM_CTL27, RW_SAME_EN, v)
#endif



/*
 * HW_DRAM_CTL28 - DRAM Control Register 28
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ACTIVE_AGING       :  1;
        unsigned RSVD1              :  7;
        unsigned COMMAND_AGE_COUNT  :  4;
        unsigned RSVD2              :  4;
        unsigned AGE_COUNT          :  4;
        unsigned RSVD3              :  4;
        unsigned Q_FULLNESS         :  3;
        unsigned RSVD4              :  5;
    } B;
} hw_dram_ctl28_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL28 register
 */
#define HW_DRAM_CTL28_ADDR         (REGS_DRAM_BASE + 0x70)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL28           (*(volatile hw_dram_ctl28_t *) HW_DRAM_CTL28_ADDR)
#define HW_DRAM_CTL28_RD()      (HW_DRAM_CTL28.U)
#define HW_DRAM_CTL28_WR(v)     (HW_DRAM_CTL28.U = (v))
#define HW_DRAM_CTL28_SET(v)    (HW_DRAM_CTL28_WR(HW_DRAM_CTL28_RD() |  (v)))
#define HW_DRAM_CTL28_CLR(v)    (HW_DRAM_CTL28_WR(HW_DRAM_CTL28_RD() & ~(v)))
#define HW_DRAM_CTL28_TOG(v)    (HW_DRAM_CTL28_WR(HW_DRAM_CTL28_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL28 bitfields
 */
/* --- Register HW_DRAM_CTL28, field RSVD4 */

#define BP_DRAM_CTL28_RSVD4      27
#define BM_DRAM_CTL28_RSVD4      0xF8000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL28_RSVD4(v)   ((((reg32_t) v) << 27) & BM_DRAM_CTL28_RSVD4)
#else
#define BF_DRAM_CTL28_RSVD4(v)   (((v) << 27) & BM_DRAM_CTL28_RSVD4)
#endif
/* --- Register HW_DRAM_CTL28, field Q_FULLNESS */

#define BP_DRAM_CTL28_Q_FULLNESS      24
#define BM_DRAM_CTL28_Q_FULLNESS      0x07000000

#define BF_DRAM_CTL28_Q_FULLNESS(v)   (((v) << 24) & BM_DRAM_CTL28_Q_FULLNESS)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL28_Q_FULLNESS(v)   BF_CS1(DRAM_CTL28, Q_FULLNESS, v)
#endif

/* --- Register HW_DRAM_CTL28, field RSVD3 */

#define BP_DRAM_CTL28_RSVD3      20
#define BM_DRAM_CTL28_RSVD3      0x00F00000

#define BF_DRAM_CTL28_RSVD3(v)   (((v) << 20) & BM_DRAM_CTL28_RSVD3)
/* --- Register HW_DRAM_CTL28, field AGE_COUNT */

#define BP_DRAM_CTL28_AGE_COUNT      16
#define BM_DRAM_CTL28_AGE_COUNT      0x000F0000

#define BF_DRAM_CTL28_AGE_COUNT(v)   (((v) << 16) & BM_DRAM_CTL28_AGE_COUNT)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL28_AGE_COUNT(v)   BF_CS1(DRAM_CTL28, AGE_COUNT, v)
#endif

/* --- Register HW_DRAM_CTL28, field RSVD2 */

#define BP_DRAM_CTL28_RSVD2      12
#define BM_DRAM_CTL28_RSVD2      0x0000F000

#define BF_DRAM_CTL28_RSVD2(v)   (((v) << 12) & BM_DRAM_CTL28_RSVD2)
/* --- Register HW_DRAM_CTL28, field COMMAND_AGE_COUNT */

#define BP_DRAM_CTL28_COMMAND_AGE_COUNT      8
#define BM_DRAM_CTL28_COMMAND_AGE_COUNT      0x00000F00

#define BF_DRAM_CTL28_COMMAND_AGE_COUNT(v)   (((v) << 8) & BM_DRAM_CTL28_COMMAND_AGE_COUNT)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL28_COMMAND_AGE_COUNT(v)   BF_CS1(DRAM_CTL28, COMMAND_AGE_COUNT, v)
#endif

/* --- Register HW_DRAM_CTL28, field RSVD1 */

#define BP_DRAM_CTL28_RSVD1      1
#define BM_DRAM_CTL28_RSVD1      0x000000FE

#define BF_DRAM_CTL28_RSVD1(v)   (((v) << 1) & BM_DRAM_CTL28_RSVD1)
/* --- Register HW_DRAM_CTL28, field ACTIVE_AGING */

#define BP_DRAM_CTL28_ACTIVE_AGING      0
#define BM_DRAM_CTL28_ACTIVE_AGING      0x00000001

#define BF_DRAM_CTL28_ACTIVE_AGING(v)   (((v) << 0) & BM_DRAM_CTL28_ACTIVE_AGING)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL28_ACTIVE_AGING(v)   BF_CS1(DRAM_CTL28, ACTIVE_AGING, v)
#endif



/*
 * HW_DRAM_CTL29 - DRAM Control Register 29
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned APREBIT      :  4;
        unsigned RSVD1        :  4;
        unsigned ADDR_PINS    :  3;
        unsigned RSVD2        :  5;
        unsigned COLUMN_SIZE  :  3;
        unsigned RSVD3        :  5;
        unsigned CS_MAP       :  4;
        unsigned RSVD4        :  4;
    } B;
} hw_dram_ctl29_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL29 register
 */
#define HW_DRAM_CTL29_ADDR         (REGS_DRAM_BASE + 0x74)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL29           (*(volatile hw_dram_ctl29_t *) HW_DRAM_CTL29_ADDR)
#define HW_DRAM_CTL29_RD()      (HW_DRAM_CTL29.U)
#define HW_DRAM_CTL29_WR(v)     (HW_DRAM_CTL29.U = (v))
#define HW_DRAM_CTL29_SET(v)    (HW_DRAM_CTL29_WR(HW_DRAM_CTL29_RD() |  (v)))
#define HW_DRAM_CTL29_CLR(v)    (HW_DRAM_CTL29_WR(HW_DRAM_CTL29_RD() & ~(v)))
#define HW_DRAM_CTL29_TOG(v)    (HW_DRAM_CTL29_WR(HW_DRAM_CTL29_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL29 bitfields
 */
/* --- Register HW_DRAM_CTL29, field RSVD4 */

#define BP_DRAM_CTL29_RSVD4      28
#define BM_DRAM_CTL29_RSVD4      0xF0000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL29_RSVD4(v)   ((((reg32_t) v) << 28) & BM_DRAM_CTL29_RSVD4)
#else
#define BF_DRAM_CTL29_RSVD4(v)   (((v) << 28) & BM_DRAM_CTL29_RSVD4)
#endif
/* --- Register HW_DRAM_CTL29, field CS_MAP */

#define BP_DRAM_CTL29_CS_MAP      24
#define BM_DRAM_CTL29_CS_MAP      0x0F000000

#define BF_DRAM_CTL29_CS_MAP(v)   (((v) << 24) & BM_DRAM_CTL29_CS_MAP)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL29_CS_MAP(v)   BF_CS1(DRAM_CTL29, CS_MAP, v)
#endif

/* --- Register HW_DRAM_CTL29, field RSVD3 */

#define BP_DRAM_CTL29_RSVD3      19
#define BM_DRAM_CTL29_RSVD3      0x00F80000

#define BF_DRAM_CTL29_RSVD3(v)   (((v) << 19) & BM_DRAM_CTL29_RSVD3)
/* --- Register HW_DRAM_CTL29, field COLUMN_SIZE */

#define BP_DRAM_CTL29_COLUMN_SIZE      16
#define BM_DRAM_CTL29_COLUMN_SIZE      0x00070000

#define BF_DRAM_CTL29_COLUMN_SIZE(v)   (((v) << 16) & BM_DRAM_CTL29_COLUMN_SIZE)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL29_COLUMN_SIZE(v)   BF_CS1(DRAM_CTL29, COLUMN_SIZE, v)
#endif

/* --- Register HW_DRAM_CTL29, field RSVD2 */

#define BP_DRAM_CTL29_RSVD2      11
#define BM_DRAM_CTL29_RSVD2      0x0000F800

#define BF_DRAM_CTL29_RSVD2(v)   (((v) << 11) & BM_DRAM_CTL29_RSVD2)
/* --- Register HW_DRAM_CTL29, field ADDR_PINS */

#define BP_DRAM_CTL29_ADDR_PINS      8
#define BM_DRAM_CTL29_ADDR_PINS      0x00000700

#define BF_DRAM_CTL29_ADDR_PINS(v)   (((v) << 8) & BM_DRAM_CTL29_ADDR_PINS)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL29_ADDR_PINS(v)   BF_CS1(DRAM_CTL29, ADDR_PINS, v)
#endif

/* --- Register HW_DRAM_CTL29, field RSVD1 */

#define BP_DRAM_CTL29_RSVD1      4
#define BM_DRAM_CTL29_RSVD1      0x000000F0

#define BF_DRAM_CTL29_RSVD1(v)   (((v) << 4) & BM_DRAM_CTL29_RSVD1)
/* --- Register HW_DRAM_CTL29, field APREBIT */

#define BP_DRAM_CTL29_APREBIT      0
#define BM_DRAM_CTL29_APREBIT      0x0000000F

#define BF_DRAM_CTL29_APREBIT(v)   (((v) << 0) & BM_DRAM_CTL29_APREBIT)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL29_APREBIT(v)   BF_CS1(DRAM_CTL29, APREBIT, v)
#endif



/*
 * HW_DRAM_CTL30 - DRAM Control Register 30
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned MAX_COL_REG  :  4;
        unsigned RSVD1        :  4;
        unsigned MAX_ROW_REG  :  4;
        unsigned RSVD2        :  4;
        unsigned MAX_CS_REG   :  3;
        unsigned RSVD3        :  5;
        unsigned OBSOLETE     :  8;
    } B;
} hw_dram_ctl30_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL30 register
 */
#define HW_DRAM_CTL30_ADDR         (REGS_DRAM_BASE + 0x78)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL30           (*(volatile hw_dram_ctl30_t *) HW_DRAM_CTL30_ADDR)
#define HW_DRAM_CTL30_RD()      (HW_DRAM_CTL30.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL30 bitfields
 */
/* --- Register HW_DRAM_CTL30, field OBSOLETE */

#define BP_DRAM_CTL30_OBSOLETE      24
#define BM_DRAM_CTL30_OBSOLETE      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL30_OBSOLETE(v)   ((((reg32_t) v) << 24) & BM_DRAM_CTL30_OBSOLETE)
#else
#define BF_DRAM_CTL30_OBSOLETE(v)   (((v) << 24) & BM_DRAM_CTL30_OBSOLETE)
#endif
/* --- Register HW_DRAM_CTL30, field RSVD3 */

#define BP_DRAM_CTL30_RSVD3      19
#define BM_DRAM_CTL30_RSVD3      0x00F80000

#define BF_DRAM_CTL30_RSVD3(v)   (((v) << 19) & BM_DRAM_CTL30_RSVD3)
/* --- Register HW_DRAM_CTL30, field MAX_CS_REG */

#define BP_DRAM_CTL30_MAX_CS_REG      16
#define BM_DRAM_CTL30_MAX_CS_REG      0x00070000

#define BF_DRAM_CTL30_MAX_CS_REG(v)   (((v) << 16) & BM_DRAM_CTL30_MAX_CS_REG)
/* --- Register HW_DRAM_CTL30, field RSVD2 */

#define BP_DRAM_CTL30_RSVD2      12
#define BM_DRAM_CTL30_RSVD2      0x0000F000

#define BF_DRAM_CTL30_RSVD2(v)   (((v) << 12) & BM_DRAM_CTL30_RSVD2)
/* --- Register HW_DRAM_CTL30, field MAX_ROW_REG */

#define BP_DRAM_CTL30_MAX_ROW_REG      8
#define BM_DRAM_CTL30_MAX_ROW_REG      0x00000F00

#define BF_DRAM_CTL30_MAX_ROW_REG(v)   (((v) << 8) & BM_DRAM_CTL30_MAX_ROW_REG)
/* --- Register HW_DRAM_CTL30, field RSVD1 */

#define BP_DRAM_CTL30_RSVD1      4
#define BM_DRAM_CTL30_RSVD1      0x000000F0

#define BF_DRAM_CTL30_RSVD1(v)   (((v) << 4) & BM_DRAM_CTL30_RSVD1)
/* --- Register HW_DRAM_CTL30, field MAX_COL_REG */

#define BP_DRAM_CTL30_MAX_COL_REG      0
#define BM_DRAM_CTL30_MAX_COL_REG      0x0000000F

#define BF_DRAM_CTL30_MAX_COL_REG(v)   (((v) << 0) & BM_DRAM_CTL30_MAX_COL_REG)


/*
 * HW_DRAM_CTL31 - DRAM Control Register 31
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DQS_N_EN         :  1;
        unsigned RSVD1            :  7;
        unsigned DRIVE_DQ_DQS     :  1;
        unsigned RSVD2            :  7;
        unsigned EIGHT_BANK_MODE  :  1;
        unsigned RSVD3            :  7;
        unsigned OBSOLETE         :  8;
    } B;
} hw_dram_ctl31_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL31 register
 */
#define HW_DRAM_CTL31_ADDR         (REGS_DRAM_BASE + 0x7c)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL31           (*(volatile hw_dram_ctl31_t *) HW_DRAM_CTL31_ADDR)
#define HW_DRAM_CTL31_RD()      (HW_DRAM_CTL31.U)
#define HW_DRAM_CTL31_WR(v)     (HW_DRAM_CTL31.U = (v))
#define HW_DRAM_CTL31_SET(v)    (HW_DRAM_CTL31_WR(HW_DRAM_CTL31_RD() |  (v)))
#define HW_DRAM_CTL31_CLR(v)    (HW_DRAM_CTL31_WR(HW_DRAM_CTL31_RD() & ~(v)))
#define HW_DRAM_CTL31_TOG(v)    (HW_DRAM_CTL31_WR(HW_DRAM_CTL31_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL31 bitfields
 */
/* --- Register HW_DRAM_CTL31, field OBSOLETE */

#define BP_DRAM_CTL31_OBSOLETE      24
#define BM_DRAM_CTL31_OBSOLETE      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL31_OBSOLETE(v)   ((((reg32_t) v) << 24) & BM_DRAM_CTL31_OBSOLETE)
#else
#define BF_DRAM_CTL31_OBSOLETE(v)   (((v) << 24) & BM_DRAM_CTL31_OBSOLETE)
#endif
/* --- Register HW_DRAM_CTL31, field RSVD3 */

#define BP_DRAM_CTL31_RSVD3      17
#define BM_DRAM_CTL31_RSVD3      0x00FE0000

#define BF_DRAM_CTL31_RSVD3(v)   (((v) << 17) & BM_DRAM_CTL31_RSVD3)
/* --- Register HW_DRAM_CTL31, field EIGHT_BANK_MODE */

#define BP_DRAM_CTL31_EIGHT_BANK_MODE      16
#define BM_DRAM_CTL31_EIGHT_BANK_MODE      0x00010000

#define BF_DRAM_CTL31_EIGHT_BANK_MODE(v)   (((v) << 16) & BM_DRAM_CTL31_EIGHT_BANK_MODE)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL31_EIGHT_BANK_MODE(v)   BF_CS1(DRAM_CTL31, EIGHT_BANK_MODE, v)
#endif

/* --- Register HW_DRAM_CTL31, field RSVD2 */

#define BP_DRAM_CTL31_RSVD2      9
#define BM_DRAM_CTL31_RSVD2      0x0000FE00

#define BF_DRAM_CTL31_RSVD2(v)   (((v) << 9) & BM_DRAM_CTL31_RSVD2)
/* --- Register HW_DRAM_CTL31, field DRIVE_DQ_DQS */

#define BP_DRAM_CTL31_DRIVE_DQ_DQS      8
#define BM_DRAM_CTL31_DRIVE_DQ_DQS      0x00000100

#define BF_DRAM_CTL31_DRIVE_DQ_DQS(v)   (((v) << 8) & BM_DRAM_CTL31_DRIVE_DQ_DQS)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL31_DRIVE_DQ_DQS(v)   BF_CS1(DRAM_CTL31, DRIVE_DQ_DQS, v)
#endif

/* --- Register HW_DRAM_CTL31, field RSVD1 */

#define BP_DRAM_CTL31_RSVD1      1
#define BM_DRAM_CTL31_RSVD1      0x000000FE

#define BF_DRAM_CTL31_RSVD1(v)   (((v) << 1) & BM_DRAM_CTL31_RSVD1)
/* --- Register HW_DRAM_CTL31, field DQS_N_EN */

#define BP_DRAM_CTL31_DQS_N_EN      0
#define BM_DRAM_CTL31_DQS_N_EN      0x00000001

#define BF_DRAM_CTL31_DQS_N_EN(v)   (((v) << 0) & BM_DRAM_CTL31_DQS_N_EN)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL31_DQS_N_EN(v)   BF_CS1(DRAM_CTL31, DQS_N_EN, v)
#endif



/*
 * HW_DRAM_CTL32 - DRAM Control Register 32
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned REG_DIMM_ENABLE  :  1;
        unsigned RSVD1            :  7;
        unsigned REDUC            :  1;
        unsigned RSVD2            :  7;
        unsigned OBSOLETE         : 16;
    } B;
} hw_dram_ctl32_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL32 register
 */
#define HW_DRAM_CTL32_ADDR         (REGS_DRAM_BASE + 0x80)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL32           (*(volatile hw_dram_ctl32_t *) HW_DRAM_CTL32_ADDR)
#define HW_DRAM_CTL32_RD()      (HW_DRAM_CTL32.U)
#define HW_DRAM_CTL32_WR(v)     (HW_DRAM_CTL32.U = (v))
#define HW_DRAM_CTL32_SET(v)    (HW_DRAM_CTL32_WR(HW_DRAM_CTL32_RD() |  (v)))
#define HW_DRAM_CTL32_CLR(v)    (HW_DRAM_CTL32_WR(HW_DRAM_CTL32_RD() & ~(v)))
#define HW_DRAM_CTL32_TOG(v)    (HW_DRAM_CTL32_WR(HW_DRAM_CTL32_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL32 bitfields
 */
/* --- Register HW_DRAM_CTL32, field OBSOLETE */

#define BP_DRAM_CTL32_OBSOLETE      16
#define BM_DRAM_CTL32_OBSOLETE      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL32_OBSOLETE(v)   ((((reg32_t) v) << 16) & BM_DRAM_CTL32_OBSOLETE)
#else
#define BF_DRAM_CTL32_OBSOLETE(v)   (((v) << 16) & BM_DRAM_CTL32_OBSOLETE)
#endif
/* --- Register HW_DRAM_CTL32, field RSVD2 */

#define BP_DRAM_CTL32_RSVD2      9
#define BM_DRAM_CTL32_RSVD2      0x0000FE00

#define BF_DRAM_CTL32_RSVD2(v)   (((v) << 9) & BM_DRAM_CTL32_RSVD2)
/* --- Register HW_DRAM_CTL32, field REDUC */

#define BP_DRAM_CTL32_REDUC      8
#define BM_DRAM_CTL32_REDUC      0x00000100

#define BF_DRAM_CTL32_REDUC(v)   (((v) << 8) & BM_DRAM_CTL32_REDUC)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL32_REDUC(v)   BF_CS1(DRAM_CTL32, REDUC, v)
#endif

/* --- Register HW_DRAM_CTL32, field RSVD1 */

#define BP_DRAM_CTL32_RSVD1      1
#define BM_DRAM_CTL32_RSVD1      0x000000FE

#define BF_DRAM_CTL32_RSVD1(v)   (((v) << 1) & BM_DRAM_CTL32_RSVD1)
/* --- Register HW_DRAM_CTL32, field REG_DIMM_ENABLE */

#define BP_DRAM_CTL32_REG_DIMM_ENABLE      0
#define BM_DRAM_CTL32_REG_DIMM_ENABLE      0x00000001

#define BF_DRAM_CTL32_REG_DIMM_ENABLE(v)   (((v) << 0) & BM_DRAM_CTL32_REG_DIMM_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL32_REG_DIMM_ENABLE(v)   BF_CS1(DRAM_CTL32, REG_DIMM_ENABLE, v)
#endif



/*
 * HW_DRAM_CTL33 - DRAM Control Register 33
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned AP            :  1;
        unsigned RSVD1         :  7;
        unsigned CONCURRENTAP  :  1;
        unsigned RSVD2         :  7;
        unsigned OBSOLETE      : 16;
    } B;
} hw_dram_ctl33_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL33 register
 */
#define HW_DRAM_CTL33_ADDR         (REGS_DRAM_BASE + 0x84)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL33           (*(volatile hw_dram_ctl33_t *) HW_DRAM_CTL33_ADDR)
#define HW_DRAM_CTL33_RD()      (HW_DRAM_CTL33.U)
#define HW_DRAM_CTL33_WR(v)     (HW_DRAM_CTL33.U = (v))
#define HW_DRAM_CTL33_SET(v)    (HW_DRAM_CTL33_WR(HW_DRAM_CTL33_RD() |  (v)))
#define HW_DRAM_CTL33_CLR(v)    (HW_DRAM_CTL33_WR(HW_DRAM_CTL33_RD() & ~(v)))
#define HW_DRAM_CTL33_TOG(v)    (HW_DRAM_CTL33_WR(HW_DRAM_CTL33_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL33 bitfields
 */
/* --- Register HW_DRAM_CTL33, field OBSOLETE */

#define BP_DRAM_CTL33_OBSOLETE      16
#define BM_DRAM_CTL33_OBSOLETE      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL33_OBSOLETE(v)   ((((reg32_t) v) << 16) & BM_DRAM_CTL33_OBSOLETE)
#else
#define BF_DRAM_CTL33_OBSOLETE(v)   (((v) << 16) & BM_DRAM_CTL33_OBSOLETE)
#endif
/* --- Register HW_DRAM_CTL33, field RSVD2 */

#define BP_DRAM_CTL33_RSVD2      9
#define BM_DRAM_CTL33_RSVD2      0x0000FE00

#define BF_DRAM_CTL33_RSVD2(v)   (((v) << 9) & BM_DRAM_CTL33_RSVD2)
/* --- Register HW_DRAM_CTL33, field CONCURRENTAP */

#define BP_DRAM_CTL33_CONCURRENTAP      8
#define BM_DRAM_CTL33_CONCURRENTAP      0x00000100

#define BF_DRAM_CTL33_CONCURRENTAP(v)   (((v) << 8) & BM_DRAM_CTL33_CONCURRENTAP)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL33_CONCURRENTAP(v)   BF_CS1(DRAM_CTL33, CONCURRENTAP, v)
#endif

/* --- Register HW_DRAM_CTL33, field RSVD1 */

#define BP_DRAM_CTL33_RSVD1      1
#define BM_DRAM_CTL33_RSVD1      0x000000FE

#define BF_DRAM_CTL33_RSVD1(v)   (((v) << 1) & BM_DRAM_CTL33_RSVD1)
/* --- Register HW_DRAM_CTL33, field AP */

#define BP_DRAM_CTL33_AP      0
#define BM_DRAM_CTL33_AP      0x00000001

#define BF_DRAM_CTL33_AP(v)   (((v) << 0) & BM_DRAM_CTL33_AP)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL33_AP(v)   BF_CS1(DRAM_CTL33, AP, v)
#endif



/*
 * HW_DRAM_CTL34 - DRAM Control Register 34
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned INTRPTAPBURST  :  1;
        unsigned RSVD1          :  7;
        unsigned INTRPTREADA    :  1;
        unsigned RSVD2          :  7;
        unsigned INTRPTWRITEA   :  1;
        unsigned RSVD3          :  7;
        unsigned WRITEINTERP    :  1;
        unsigned RSVD4          :  7;
    } B;
} hw_dram_ctl34_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL34 register
 */
#define HW_DRAM_CTL34_ADDR         (REGS_DRAM_BASE + 0x88)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL34           (*(volatile hw_dram_ctl34_t *) HW_DRAM_CTL34_ADDR)
#define HW_DRAM_CTL34_RD()      (HW_DRAM_CTL34.U)
#define HW_DRAM_CTL34_WR(v)     (HW_DRAM_CTL34.U = (v))
#define HW_DRAM_CTL34_SET(v)    (HW_DRAM_CTL34_WR(HW_DRAM_CTL34_RD() |  (v)))
#define HW_DRAM_CTL34_CLR(v)    (HW_DRAM_CTL34_WR(HW_DRAM_CTL34_RD() & ~(v)))
#define HW_DRAM_CTL34_TOG(v)    (HW_DRAM_CTL34_WR(HW_DRAM_CTL34_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL34 bitfields
 */
/* --- Register HW_DRAM_CTL34, field RSVD4 */

#define BP_DRAM_CTL34_RSVD4      25
#define BM_DRAM_CTL34_RSVD4      0xFE000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL34_RSVD4(v)   ((((reg32_t) v) << 25) & BM_DRAM_CTL34_RSVD4)
#else
#define BF_DRAM_CTL34_RSVD4(v)   (((v) << 25) & BM_DRAM_CTL34_RSVD4)
#endif
/* --- Register HW_DRAM_CTL34, field WRITEINTERP */

#define BP_DRAM_CTL34_WRITEINTERP      24
#define BM_DRAM_CTL34_WRITEINTERP      0x01000000

#define BF_DRAM_CTL34_WRITEINTERP(v)   (((v) << 24) & BM_DRAM_CTL34_WRITEINTERP)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL34_WRITEINTERP(v)   BF_CS1(DRAM_CTL34, WRITEINTERP, v)
#endif

/* --- Register HW_DRAM_CTL34, field RSVD3 */

#define BP_DRAM_CTL34_RSVD3      17
#define BM_DRAM_CTL34_RSVD3      0x00FE0000

#define BF_DRAM_CTL34_RSVD3(v)   (((v) << 17) & BM_DRAM_CTL34_RSVD3)
/* --- Register HW_DRAM_CTL34, field INTRPTWRITEA */

#define BP_DRAM_CTL34_INTRPTWRITEA      16
#define BM_DRAM_CTL34_INTRPTWRITEA      0x00010000

#define BF_DRAM_CTL34_INTRPTWRITEA(v)   (((v) << 16) & BM_DRAM_CTL34_INTRPTWRITEA)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL34_INTRPTWRITEA(v)   BF_CS1(DRAM_CTL34, INTRPTWRITEA, v)
#endif

/* --- Register HW_DRAM_CTL34, field RSVD2 */

#define BP_DRAM_CTL34_RSVD2      9
#define BM_DRAM_CTL34_RSVD2      0x0000FE00

#define BF_DRAM_CTL34_RSVD2(v)   (((v) << 9) & BM_DRAM_CTL34_RSVD2)
/* --- Register HW_DRAM_CTL34, field INTRPTREADA */

#define BP_DRAM_CTL34_INTRPTREADA      8
#define BM_DRAM_CTL34_INTRPTREADA      0x00000100

#define BF_DRAM_CTL34_INTRPTREADA(v)   (((v) << 8) & BM_DRAM_CTL34_INTRPTREADA)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL34_INTRPTREADA(v)   BF_CS1(DRAM_CTL34, INTRPTREADA, v)
#endif

/* --- Register HW_DRAM_CTL34, field RSVD1 */

#define BP_DRAM_CTL34_RSVD1      1
#define BM_DRAM_CTL34_RSVD1      0x000000FE

#define BF_DRAM_CTL34_RSVD1(v)   (((v) << 1) & BM_DRAM_CTL34_RSVD1)
/* --- Register HW_DRAM_CTL34, field INTRPTAPBURST */

#define BP_DRAM_CTL34_INTRPTAPBURST      0
#define BM_DRAM_CTL34_INTRPTAPBURST      0x00000001

#define BF_DRAM_CTL34_INTRPTAPBURST(v)   (((v) << 0) & BM_DRAM_CTL34_INTRPTAPBURST)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL34_INTRPTAPBURST(v)   BF_CS1(DRAM_CTL34, INTRPTAPBURST, v)
#endif



/*
 * HW_DRAM_CTL35 - DRAM Control Register 35
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned INITAREF             :  4;
        unsigned RSVD1                :  4;
        unsigned NO_CMD_INIT          :  1;
        unsigned RSVD2                :  7;
        unsigned PWRUP_SREFRESH_EXIT  :  1;
        unsigned RSVD3                :  7;
        unsigned OBSOLETE             :  8;
    } B;
} hw_dram_ctl35_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL35 register
 */
#define HW_DRAM_CTL35_ADDR         (REGS_DRAM_BASE + 0x8c)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL35           (*(volatile hw_dram_ctl35_t *) HW_DRAM_CTL35_ADDR)
#define HW_DRAM_CTL35_RD()      (HW_DRAM_CTL35.U)
#define HW_DRAM_CTL35_WR(v)     (HW_DRAM_CTL35.U = (v))
#define HW_DRAM_CTL35_SET(v)    (HW_DRAM_CTL35_WR(HW_DRAM_CTL35_RD() |  (v)))
#define HW_DRAM_CTL35_CLR(v)    (HW_DRAM_CTL35_WR(HW_DRAM_CTL35_RD() & ~(v)))
#define HW_DRAM_CTL35_TOG(v)    (HW_DRAM_CTL35_WR(HW_DRAM_CTL35_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL35 bitfields
 */
/* --- Register HW_DRAM_CTL35, field OBSOLETE */

#define BP_DRAM_CTL35_OBSOLETE      24
#define BM_DRAM_CTL35_OBSOLETE      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL35_OBSOLETE(v)   ((((reg32_t) v) << 24) & BM_DRAM_CTL35_OBSOLETE)
#else
#define BF_DRAM_CTL35_OBSOLETE(v)   (((v) << 24) & BM_DRAM_CTL35_OBSOLETE)
#endif
/* --- Register HW_DRAM_CTL35, field RSVD3 */

#define BP_DRAM_CTL35_RSVD3      17
#define BM_DRAM_CTL35_RSVD3      0x00FE0000

#define BF_DRAM_CTL35_RSVD3(v)   (((v) << 17) & BM_DRAM_CTL35_RSVD3)
/* --- Register HW_DRAM_CTL35, field PWRUP_SREFRESH_EXIT */

#define BP_DRAM_CTL35_PWRUP_SREFRESH_EXIT      16
#define BM_DRAM_CTL35_PWRUP_SREFRESH_EXIT      0x00010000

#define BF_DRAM_CTL35_PWRUP_SREFRESH_EXIT(v)   (((v) << 16) & BM_DRAM_CTL35_PWRUP_SREFRESH_EXIT)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL35_PWRUP_SREFRESH_EXIT(v)   BF_CS1(DRAM_CTL35, PWRUP_SREFRESH_EXIT, v)
#endif

/* --- Register HW_DRAM_CTL35, field RSVD2 */

#define BP_DRAM_CTL35_RSVD2      9
#define BM_DRAM_CTL35_RSVD2      0x0000FE00

#define BF_DRAM_CTL35_RSVD2(v)   (((v) << 9) & BM_DRAM_CTL35_RSVD2)
/* --- Register HW_DRAM_CTL35, field NO_CMD_INIT */

#define BP_DRAM_CTL35_NO_CMD_INIT      8
#define BM_DRAM_CTL35_NO_CMD_INIT      0x00000100

#define BF_DRAM_CTL35_NO_CMD_INIT(v)   (((v) << 8) & BM_DRAM_CTL35_NO_CMD_INIT)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL35_NO_CMD_INIT(v)   BF_CS1(DRAM_CTL35, NO_CMD_INIT, v)
#endif

/* --- Register HW_DRAM_CTL35, field RSVD1 */

#define BP_DRAM_CTL35_RSVD1      4
#define BM_DRAM_CTL35_RSVD1      0x000000F0

#define BF_DRAM_CTL35_RSVD1(v)   (((v) << 4) & BM_DRAM_CTL35_RSVD1)
/* --- Register HW_DRAM_CTL35, field INITAREF */

#define BP_DRAM_CTL35_INITAREF      0
#define BM_DRAM_CTL35_INITAREF      0x0000000F

#define BF_DRAM_CTL35_INITAREF(v)   (((v) << 0) & BM_DRAM_CTL35_INITAREF)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL35_INITAREF(v)   BF_CS1(DRAM_CTL35, INITAREF, v)
#endif



/*
 * HW_DRAM_CTL36 - DRAM Control Register 36
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned FAST_WRITE    :  1;
        unsigned RSVD1         :  7;
        unsigned OBSOLETE      :  8;
        unsigned TRAS_LOCKOUT  :  1;
        unsigned RSVD2         :  7;
        unsigned TREF_ENABLE   :  1;
        unsigned RSVD3         :  7;
    } B;
} hw_dram_ctl36_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL36 register
 */
#define HW_DRAM_CTL36_ADDR         (REGS_DRAM_BASE + 0x90)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL36           (*(volatile hw_dram_ctl36_t *) HW_DRAM_CTL36_ADDR)
#define HW_DRAM_CTL36_RD()      (HW_DRAM_CTL36.U)
#define HW_DRAM_CTL36_WR(v)     (HW_DRAM_CTL36.U = (v))
#define HW_DRAM_CTL36_SET(v)    (HW_DRAM_CTL36_WR(HW_DRAM_CTL36_RD() |  (v)))
#define HW_DRAM_CTL36_CLR(v)    (HW_DRAM_CTL36_WR(HW_DRAM_CTL36_RD() & ~(v)))
#define HW_DRAM_CTL36_TOG(v)    (HW_DRAM_CTL36_WR(HW_DRAM_CTL36_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL36 bitfields
 */
/* --- Register HW_DRAM_CTL36, field RSVD3 */

#define BP_DRAM_CTL36_RSVD3      25
#define BM_DRAM_CTL36_RSVD3      0xFE000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL36_RSVD3(v)   ((((reg32_t) v) << 25) & BM_DRAM_CTL36_RSVD3)
#else
#define BF_DRAM_CTL36_RSVD3(v)   (((v) << 25) & BM_DRAM_CTL36_RSVD3)
#endif
/* --- Register HW_DRAM_CTL36, field TREF_ENABLE */

#define BP_DRAM_CTL36_TREF_ENABLE      24
#define BM_DRAM_CTL36_TREF_ENABLE      0x01000000

#define BF_DRAM_CTL36_TREF_ENABLE(v)   (((v) << 24) & BM_DRAM_CTL36_TREF_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL36_TREF_ENABLE(v)   BF_CS1(DRAM_CTL36, TREF_ENABLE, v)
#endif

/* --- Register HW_DRAM_CTL36, field RSVD2 */

#define BP_DRAM_CTL36_RSVD2      17
#define BM_DRAM_CTL36_RSVD2      0x00FE0000

#define BF_DRAM_CTL36_RSVD2(v)   (((v) << 17) & BM_DRAM_CTL36_RSVD2)
/* --- Register HW_DRAM_CTL36, field TRAS_LOCKOUT */

#define BP_DRAM_CTL36_TRAS_LOCKOUT      16
#define BM_DRAM_CTL36_TRAS_LOCKOUT      0x00010000

#define BF_DRAM_CTL36_TRAS_LOCKOUT(v)   (((v) << 16) & BM_DRAM_CTL36_TRAS_LOCKOUT)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL36_TRAS_LOCKOUT(v)   BF_CS1(DRAM_CTL36, TRAS_LOCKOUT, v)
#endif

/* --- Register HW_DRAM_CTL36, field OBSOLETE */

#define BP_DRAM_CTL36_OBSOLETE      8
#define BM_DRAM_CTL36_OBSOLETE      0x0000FF00

#define BF_DRAM_CTL36_OBSOLETE(v)   (((v) << 8) & BM_DRAM_CTL36_OBSOLETE)
/* --- Register HW_DRAM_CTL36, field RSVD1 */

#define BP_DRAM_CTL36_RSVD1      1
#define BM_DRAM_CTL36_RSVD1      0x000000FE

#define BF_DRAM_CTL36_RSVD1(v)   (((v) << 1) & BM_DRAM_CTL36_RSVD1)
/* --- Register HW_DRAM_CTL36, field FAST_WRITE */

#define BP_DRAM_CTL36_FAST_WRITE      0
#define BM_DRAM_CTL36_FAST_WRITE      0x00000001

#define BF_DRAM_CTL36_FAST_WRITE(v)   (((v) << 0) & BM_DRAM_CTL36_FAST_WRITE)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL36_FAST_WRITE(v)   BF_CS1(DRAM_CTL36, FAST_WRITE, v)
#endif



/*
 * HW_DRAM_CTL37 - DRAM Control Register 37
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned WRLAT            :  4;
        unsigned RSVD1            :  4;
        unsigned CASLAT           :  3;
        unsigned RSVD2            :  5;
        unsigned CASLAT_LIN       :  4;
        unsigned RSVD3            :  4;
        unsigned CASLAT_LIN_GATE  :  4;
        unsigned RSVD4            :  4;
    } B;
} hw_dram_ctl37_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL37 register
 */
#define HW_DRAM_CTL37_ADDR         (REGS_DRAM_BASE + 0x94)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL37           (*(volatile hw_dram_ctl37_t *) HW_DRAM_CTL37_ADDR)
#define HW_DRAM_CTL37_RD()      (HW_DRAM_CTL37.U)
#define HW_DRAM_CTL37_WR(v)     (HW_DRAM_CTL37.U = (v))
#define HW_DRAM_CTL37_SET(v)    (HW_DRAM_CTL37_WR(HW_DRAM_CTL37_RD() |  (v)))
#define HW_DRAM_CTL37_CLR(v)    (HW_DRAM_CTL37_WR(HW_DRAM_CTL37_RD() & ~(v)))
#define HW_DRAM_CTL37_TOG(v)    (HW_DRAM_CTL37_WR(HW_DRAM_CTL37_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL37 bitfields
 */
/* --- Register HW_DRAM_CTL37, field RSVD4 */

#define BP_DRAM_CTL37_RSVD4      28
#define BM_DRAM_CTL37_RSVD4      0xF0000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL37_RSVD4(v)   ((((reg32_t) v) << 28) & BM_DRAM_CTL37_RSVD4)
#else
#define BF_DRAM_CTL37_RSVD4(v)   (((v) << 28) & BM_DRAM_CTL37_RSVD4)
#endif
/* --- Register HW_DRAM_CTL37, field CASLAT_LIN_GATE */

#define BP_DRAM_CTL37_CASLAT_LIN_GATE      24
#define BM_DRAM_CTL37_CASLAT_LIN_GATE      0x0F000000

#define BF_DRAM_CTL37_CASLAT_LIN_GATE(v)   (((v) << 24) & BM_DRAM_CTL37_CASLAT_LIN_GATE)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL37_CASLAT_LIN_GATE(v)   BF_CS1(DRAM_CTL37, CASLAT_LIN_GATE, v)
#endif

/* --- Register HW_DRAM_CTL37, field RSVD3 */

#define BP_DRAM_CTL37_RSVD3      20
#define BM_DRAM_CTL37_RSVD3      0x00F00000

#define BF_DRAM_CTL37_RSVD3(v)   (((v) << 20) & BM_DRAM_CTL37_RSVD3)
/* --- Register HW_DRAM_CTL37, field CASLAT_LIN */

#define BP_DRAM_CTL37_CASLAT_LIN      16
#define BM_DRAM_CTL37_CASLAT_LIN      0x000F0000

#define BF_DRAM_CTL37_CASLAT_LIN(v)   (((v) << 16) & BM_DRAM_CTL37_CASLAT_LIN)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL37_CASLAT_LIN(v)   BF_CS1(DRAM_CTL37, CASLAT_LIN, v)
#endif

/* --- Register HW_DRAM_CTL37, field RSVD2 */

#define BP_DRAM_CTL37_RSVD2      11
#define BM_DRAM_CTL37_RSVD2      0x0000F800

#define BF_DRAM_CTL37_RSVD2(v)   (((v) << 11) & BM_DRAM_CTL37_RSVD2)
/* --- Register HW_DRAM_CTL37, field CASLAT */

#define BP_DRAM_CTL37_CASLAT      8
#define BM_DRAM_CTL37_CASLAT      0x00000700

#define BF_DRAM_CTL37_CASLAT(v)   (((v) << 8) & BM_DRAM_CTL37_CASLAT)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL37_CASLAT(v)   BF_CS1(DRAM_CTL37, CASLAT, v)
#endif

/* --- Register HW_DRAM_CTL37, field RSVD1 */

#define BP_DRAM_CTL37_RSVD1      4
#define BM_DRAM_CTL37_RSVD1      0x000000F0

#define BF_DRAM_CTL37_RSVD1(v)   (((v) << 4) & BM_DRAM_CTL37_RSVD1)
/* --- Register HW_DRAM_CTL37, field WRLAT */

#define BP_DRAM_CTL37_WRLAT      0
#define BM_DRAM_CTL37_WRLAT      0x0000000F

#define BF_DRAM_CTL37_WRLAT(v)   (((v) << 0) & BM_DRAM_CTL37_WRLAT)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL37_WRLAT(v)   BF_CS1(DRAM_CTL37, WRLAT, v)
#endif



/*
 * HW_DRAM_CTL38 - DRAM Control Register 38
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TCKE   :  3;
        unsigned RSVD1  :  5;
        unsigned TCPD   : 16;
        unsigned TDAL   :  5;
        unsigned RSVD2  :  3;
    } B;
} hw_dram_ctl38_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL38 register
 */
#define HW_DRAM_CTL38_ADDR         (REGS_DRAM_BASE + 0x98)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL38           (*(volatile hw_dram_ctl38_t *) HW_DRAM_CTL38_ADDR)
#define HW_DRAM_CTL38_RD()      (HW_DRAM_CTL38.U)
#define HW_DRAM_CTL38_WR(v)     (HW_DRAM_CTL38.U = (v))
#define HW_DRAM_CTL38_SET(v)    (HW_DRAM_CTL38_WR(HW_DRAM_CTL38_RD() |  (v)))
#define HW_DRAM_CTL38_CLR(v)    (HW_DRAM_CTL38_WR(HW_DRAM_CTL38_RD() & ~(v)))
#define HW_DRAM_CTL38_TOG(v)    (HW_DRAM_CTL38_WR(HW_DRAM_CTL38_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL38 bitfields
 */
/* --- Register HW_DRAM_CTL38, field RSVD2 */

#define BP_DRAM_CTL38_RSVD2      29
#define BM_DRAM_CTL38_RSVD2      0xE0000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL38_RSVD2(v)   ((((reg32_t) v) << 29) & BM_DRAM_CTL38_RSVD2)
#else
#define BF_DRAM_CTL38_RSVD2(v)   (((v) << 29) & BM_DRAM_CTL38_RSVD2)
#endif
/* --- Register HW_DRAM_CTL38, field TDAL */

#define BP_DRAM_CTL38_TDAL      24
#define BM_DRAM_CTL38_TDAL      0x1F000000

#define BF_DRAM_CTL38_TDAL(v)   (((v) << 24) & BM_DRAM_CTL38_TDAL)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL38_TDAL(v)   BF_CS1(DRAM_CTL38, TDAL, v)
#endif

/* --- Register HW_DRAM_CTL38, field TCPD */

#define BP_DRAM_CTL38_TCPD      8
#define BM_DRAM_CTL38_TCPD      0x00FFFF00

#define BF_DRAM_CTL38_TCPD(v)   (((v) << 8) & BM_DRAM_CTL38_TCPD)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL38_TCPD(v)   BF_CS1(DRAM_CTL38, TCPD, v)
#endif

/* --- Register HW_DRAM_CTL38, field RSVD1 */

#define BP_DRAM_CTL38_RSVD1      3
#define BM_DRAM_CTL38_RSVD1      0x000000F8

#define BF_DRAM_CTL38_RSVD1(v)   (((v) << 3) & BM_DRAM_CTL38_RSVD1)
/* --- Register HW_DRAM_CTL38, field TCKE */

#define BP_DRAM_CTL38_TCKE      0
#define BM_DRAM_CTL38_TCKE      0x00000007

#define BF_DRAM_CTL38_TCKE(v)   (((v) << 0) & BM_DRAM_CTL38_TCKE)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL38_TCKE(v)   BF_CS1(DRAM_CTL38, TCKE, v)
#endif



/*
 * HW_DRAM_CTL39 - DRAM Control Register 39
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TDLL      : 16;
        unsigned OBSOLETE  :  8;
        unsigned TFAW      :  6;
        unsigned RSVD1     :  2;
    } B;
} hw_dram_ctl39_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL39 register
 */
#define HW_DRAM_CTL39_ADDR         (REGS_DRAM_BASE + 0x9c)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL39           (*(volatile hw_dram_ctl39_t *) HW_DRAM_CTL39_ADDR)
#define HW_DRAM_CTL39_RD()      (HW_DRAM_CTL39.U)
#define HW_DRAM_CTL39_WR(v)     (HW_DRAM_CTL39.U = (v))
#define HW_DRAM_CTL39_SET(v)    (HW_DRAM_CTL39_WR(HW_DRAM_CTL39_RD() |  (v)))
#define HW_DRAM_CTL39_CLR(v)    (HW_DRAM_CTL39_WR(HW_DRAM_CTL39_RD() & ~(v)))
#define HW_DRAM_CTL39_TOG(v)    (HW_DRAM_CTL39_WR(HW_DRAM_CTL39_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL39 bitfields
 */
/* --- Register HW_DRAM_CTL39, field RSVD1 */

#define BP_DRAM_CTL39_RSVD1      30
#define BM_DRAM_CTL39_RSVD1      0xC0000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL39_RSVD1(v)   ((((reg32_t) v) << 30) & BM_DRAM_CTL39_RSVD1)
#else
#define BF_DRAM_CTL39_RSVD1(v)   (((v) << 30) & BM_DRAM_CTL39_RSVD1)
#endif
/* --- Register HW_DRAM_CTL39, field TFAW */

#define BP_DRAM_CTL39_TFAW      24
#define BM_DRAM_CTL39_TFAW      0x3F000000

#define BF_DRAM_CTL39_TFAW(v)   (((v) << 24) & BM_DRAM_CTL39_TFAW)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL39_TFAW(v)   BF_CS1(DRAM_CTL39, TFAW, v)
#endif

/* --- Register HW_DRAM_CTL39, field OBSOLETE */

#define BP_DRAM_CTL39_OBSOLETE      16
#define BM_DRAM_CTL39_OBSOLETE      0x00FF0000

#define BF_DRAM_CTL39_OBSOLETE(v)   (((v) << 16) & BM_DRAM_CTL39_OBSOLETE)
/* --- Register HW_DRAM_CTL39, field TDLL */

#define BP_DRAM_CTL39_TDLL      0
#define BM_DRAM_CTL39_TDLL      0x0000FFFF

#define BF_DRAM_CTL39_TDLL(v)   (((v) << 0) & BM_DRAM_CTL39_TDLL)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL39_TDLL(v)   (HW_DRAM_CTL39.B.TDLL = (v))
#endif



/*
 * HW_DRAM_CTL40 - DRAM Control Register 40
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TINIT  : 24;
        unsigned TMRD   :  5;
        unsigned RSVD1  :  3;
    } B;
} hw_dram_ctl40_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL40 register
 */
#define HW_DRAM_CTL40_ADDR         (REGS_DRAM_BASE + 0xa0)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL40           (*(volatile hw_dram_ctl40_t *) HW_DRAM_CTL40_ADDR)
#define HW_DRAM_CTL40_RD()      (HW_DRAM_CTL40.U)
#define HW_DRAM_CTL40_WR(v)     (HW_DRAM_CTL40.U = (v))
#define HW_DRAM_CTL40_SET(v)    (HW_DRAM_CTL40_WR(HW_DRAM_CTL40_RD() |  (v)))
#define HW_DRAM_CTL40_CLR(v)    (HW_DRAM_CTL40_WR(HW_DRAM_CTL40_RD() & ~(v)))
#define HW_DRAM_CTL40_TOG(v)    (HW_DRAM_CTL40_WR(HW_DRAM_CTL40_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL40 bitfields
 */
/* --- Register HW_DRAM_CTL40, field RSVD1 */

#define BP_DRAM_CTL40_RSVD1      29
#define BM_DRAM_CTL40_RSVD1      0xE0000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL40_RSVD1(v)   ((((reg32_t) v) << 29) & BM_DRAM_CTL40_RSVD1)
#else
#define BF_DRAM_CTL40_RSVD1(v)   (((v) << 29) & BM_DRAM_CTL40_RSVD1)
#endif
/* --- Register HW_DRAM_CTL40, field TMRD */

#define BP_DRAM_CTL40_TMRD      24
#define BM_DRAM_CTL40_TMRD      0x1F000000

#define BF_DRAM_CTL40_TMRD(v)   (((v) << 24) & BM_DRAM_CTL40_TMRD)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL40_TMRD(v)   BF_CS1(DRAM_CTL40, TMRD, v)
#endif

/* --- Register HW_DRAM_CTL40, field TINIT */

#define BP_DRAM_CTL40_TINIT      0
#define BM_DRAM_CTL40_TINIT      0x00FFFFFF

#define BF_DRAM_CTL40_TINIT(v)   (((v) << 0) & BM_DRAM_CTL40_TINIT)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL40_TINIT(v)   BF_CS1(DRAM_CTL40, TINIT, v)
#endif



/*
 * HW_DRAM_CTL41 - DRAM Control Register 41
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TRC       :  6;
        unsigned RSVD1     :  2;
        unsigned TRCD_INT  :  8;
        unsigned TPDEX     : 16;
    } B;
} hw_dram_ctl41_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL41 register
 */
#define HW_DRAM_CTL41_ADDR         (REGS_DRAM_BASE + 0xa4)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL41           (*(volatile hw_dram_ctl41_t *) HW_DRAM_CTL41_ADDR)
#define HW_DRAM_CTL41_RD()      (HW_DRAM_CTL41.U)
#define HW_DRAM_CTL41_WR(v)     (HW_DRAM_CTL41.U = (v))
#define HW_DRAM_CTL41_SET(v)    (HW_DRAM_CTL41_WR(HW_DRAM_CTL41_RD() |  (v)))
#define HW_DRAM_CTL41_CLR(v)    (HW_DRAM_CTL41_WR(HW_DRAM_CTL41_RD() & ~(v)))
#define HW_DRAM_CTL41_TOG(v)    (HW_DRAM_CTL41_WR(HW_DRAM_CTL41_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL41 bitfields
 */
/* --- Register HW_DRAM_CTL41, field TPDEX */

#define BP_DRAM_CTL41_TPDEX      16
#define BM_DRAM_CTL41_TPDEX      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL41_TPDEX(v)   ((((reg32_t) v) << 16) & BM_DRAM_CTL41_TPDEX)
#else
#define BF_DRAM_CTL41_TPDEX(v)   (((v) << 16) & BM_DRAM_CTL41_TPDEX)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL41_TPDEX(v)   (HW_DRAM_CTL41.B.TPDEX = (v))
#endif

/* --- Register HW_DRAM_CTL41, field TRCD_INT */

#define BP_DRAM_CTL41_TRCD_INT      8
#define BM_DRAM_CTL41_TRCD_INT      0x0000FF00

#define BF_DRAM_CTL41_TRCD_INT(v)   (((v) << 8) & BM_DRAM_CTL41_TRCD_INT)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL41_TRCD_INT(v)   (HW_DRAM_CTL41.B.TRCD_INT = (v))
#endif

/* --- Register HW_DRAM_CTL41, field RSVD1 */

#define BP_DRAM_CTL41_RSVD1      6
#define BM_DRAM_CTL41_RSVD1      0x000000C0

#define BF_DRAM_CTL41_RSVD1(v)   (((v) << 6) & BM_DRAM_CTL41_RSVD1)
/* --- Register HW_DRAM_CTL41, field TRC */

#define BP_DRAM_CTL41_TRC      0
#define BM_DRAM_CTL41_TRC      0x0000003F

#define BF_DRAM_CTL41_TRC(v)   (((v) << 0) & BM_DRAM_CTL41_TRC)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL41_TRC(v)   BF_CS1(DRAM_CTL41, TRC, v)
#endif



/*
 * HW_DRAM_CTL42 - DRAM Control Register 42
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TRAS_MIN  :  8;
        unsigned TRAS_MAX  : 16;
        unsigned OBSOLETE  :  8;
    } B;
} hw_dram_ctl42_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL42 register
 */
#define HW_DRAM_CTL42_ADDR         (REGS_DRAM_BASE + 0xa8)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL42           (*(volatile hw_dram_ctl42_t *) HW_DRAM_CTL42_ADDR)
#define HW_DRAM_CTL42_RD()      (HW_DRAM_CTL42.U)
#define HW_DRAM_CTL42_WR(v)     (HW_DRAM_CTL42.U = (v))
#define HW_DRAM_CTL42_SET(v)    (HW_DRAM_CTL42_WR(HW_DRAM_CTL42_RD() |  (v)))
#define HW_DRAM_CTL42_CLR(v)    (HW_DRAM_CTL42_WR(HW_DRAM_CTL42_RD() & ~(v)))
#define HW_DRAM_CTL42_TOG(v)    (HW_DRAM_CTL42_WR(HW_DRAM_CTL42_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL42 bitfields
 */
/* --- Register HW_DRAM_CTL42, field OBSOLETE */

#define BP_DRAM_CTL42_OBSOLETE      24
#define BM_DRAM_CTL42_OBSOLETE      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL42_OBSOLETE(v)   ((((reg32_t) v) << 24) & BM_DRAM_CTL42_OBSOLETE)
#else
#define BF_DRAM_CTL42_OBSOLETE(v)   (((v) << 24) & BM_DRAM_CTL42_OBSOLETE)
#endif
/* --- Register HW_DRAM_CTL42, field TRAS_MAX */

#define BP_DRAM_CTL42_TRAS_MAX      8
#define BM_DRAM_CTL42_TRAS_MAX      0x00FFFF00

#define BF_DRAM_CTL42_TRAS_MAX(v)   (((v) << 8) & BM_DRAM_CTL42_TRAS_MAX)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL42_TRAS_MAX(v)   BF_CS1(DRAM_CTL42, TRAS_MAX, v)
#endif

/* --- Register HW_DRAM_CTL42, field TRAS_MIN */

#define BP_DRAM_CTL42_TRAS_MIN      0
#define BM_DRAM_CTL42_TRAS_MIN      0x000000FF

#define BF_DRAM_CTL42_TRAS_MIN(v)   (((v) << 0) & BM_DRAM_CTL42_TRAS_MIN)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL42_TRAS_MIN(v)   (HW_DRAM_CTL42.B.TRAS_MIN = (v))
#endif



/*
 * HW_DRAM_CTL43 - DRAM Control Register 43
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TREF   : 14;
        unsigned RSVD1  :  2;
        unsigned TRFC   :  8;
        unsigned TRP    :  4;
        unsigned RSVD2  :  4;
    } B;
} hw_dram_ctl43_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL43 register
 */
#define HW_DRAM_CTL43_ADDR         (REGS_DRAM_BASE + 0xac)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL43           (*(volatile hw_dram_ctl43_t *) HW_DRAM_CTL43_ADDR)
#define HW_DRAM_CTL43_RD()      (HW_DRAM_CTL43.U)
#define HW_DRAM_CTL43_WR(v)     (HW_DRAM_CTL43.U = (v))
#define HW_DRAM_CTL43_SET(v)    (HW_DRAM_CTL43_WR(HW_DRAM_CTL43_RD() |  (v)))
#define HW_DRAM_CTL43_CLR(v)    (HW_DRAM_CTL43_WR(HW_DRAM_CTL43_RD() & ~(v)))
#define HW_DRAM_CTL43_TOG(v)    (HW_DRAM_CTL43_WR(HW_DRAM_CTL43_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL43 bitfields
 */
/* --- Register HW_DRAM_CTL43, field RSVD2 */

#define BP_DRAM_CTL43_RSVD2      28
#define BM_DRAM_CTL43_RSVD2      0xF0000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL43_RSVD2(v)   ((((reg32_t) v) << 28) & BM_DRAM_CTL43_RSVD2)
#else
#define BF_DRAM_CTL43_RSVD2(v)   (((v) << 28) & BM_DRAM_CTL43_RSVD2)
#endif
/* --- Register HW_DRAM_CTL43, field TRP */

#define BP_DRAM_CTL43_TRP      24
#define BM_DRAM_CTL43_TRP      0x0F000000

#define BF_DRAM_CTL43_TRP(v)   (((v) << 24) & BM_DRAM_CTL43_TRP)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL43_TRP(v)   BF_CS1(DRAM_CTL43, TRP, v)
#endif

/* --- Register HW_DRAM_CTL43, field TRFC */

#define BP_DRAM_CTL43_TRFC      16
#define BM_DRAM_CTL43_TRFC      0x00FF0000

#define BF_DRAM_CTL43_TRFC(v)   (((v) << 16) & BM_DRAM_CTL43_TRFC)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL43_TRFC(v)   (HW_DRAM_CTL43.B.TRFC = (v))
#endif

/* --- Register HW_DRAM_CTL43, field RSVD1 */

#define BP_DRAM_CTL43_RSVD1      14
#define BM_DRAM_CTL43_RSVD1      0x0000C000

#define BF_DRAM_CTL43_RSVD1(v)   (((v) << 14) & BM_DRAM_CTL43_RSVD1)
/* --- Register HW_DRAM_CTL43, field TREF */

#define BP_DRAM_CTL43_TREF      0
#define BM_DRAM_CTL43_TREF      0x00003FFF

#define BF_DRAM_CTL43_TREF(v)   (((v) << 0) & BM_DRAM_CTL43_TREF)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL43_TREF(v)   BF_CS1(DRAM_CTL43, TREF, v)
#endif



/*
 * HW_DRAM_CTL44 - DRAM Control Register 44
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TRRD     :  3;
        unsigned RSVD1    :  5;
        unsigned TRTP     :  3;
        unsigned RSVD2    :  5;
        unsigned TWR_INT  :  5;
        unsigned RSVD3    :  3;
        unsigned TWTR     :  4;
        unsigned RSVD4    :  4;
    } B;
} hw_dram_ctl44_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL44 register
 */
#define HW_DRAM_CTL44_ADDR         (REGS_DRAM_BASE + 0xb0)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL44           (*(volatile hw_dram_ctl44_t *) HW_DRAM_CTL44_ADDR)
#define HW_DRAM_CTL44_RD()      (HW_DRAM_CTL44.U)
#define HW_DRAM_CTL44_WR(v)     (HW_DRAM_CTL44.U = (v))
#define HW_DRAM_CTL44_SET(v)    (HW_DRAM_CTL44_WR(HW_DRAM_CTL44_RD() |  (v)))
#define HW_DRAM_CTL44_CLR(v)    (HW_DRAM_CTL44_WR(HW_DRAM_CTL44_RD() & ~(v)))
#define HW_DRAM_CTL44_TOG(v)    (HW_DRAM_CTL44_WR(HW_DRAM_CTL44_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL44 bitfields
 */
/* --- Register HW_DRAM_CTL44, field RSVD4 */

#define BP_DRAM_CTL44_RSVD4      28
#define BM_DRAM_CTL44_RSVD4      0xF0000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL44_RSVD4(v)   ((((reg32_t) v) << 28) & BM_DRAM_CTL44_RSVD4)
#else
#define BF_DRAM_CTL44_RSVD4(v)   (((v) << 28) & BM_DRAM_CTL44_RSVD4)
#endif
/* --- Register HW_DRAM_CTL44, field TWTR */

#define BP_DRAM_CTL44_TWTR      24
#define BM_DRAM_CTL44_TWTR      0x0F000000

#define BF_DRAM_CTL44_TWTR(v)   (((v) << 24) & BM_DRAM_CTL44_TWTR)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL44_TWTR(v)   BF_CS1(DRAM_CTL44, TWTR, v)
#endif

/* --- Register HW_DRAM_CTL44, field RSVD3 */

#define BP_DRAM_CTL44_RSVD3      21
#define BM_DRAM_CTL44_RSVD3      0x00E00000

#define BF_DRAM_CTL44_RSVD3(v)   (((v) << 21) & BM_DRAM_CTL44_RSVD3)
/* --- Register HW_DRAM_CTL44, field TWR_INT */

#define BP_DRAM_CTL44_TWR_INT      16
#define BM_DRAM_CTL44_TWR_INT      0x001F0000

#define BF_DRAM_CTL44_TWR_INT(v)   (((v) << 16) & BM_DRAM_CTL44_TWR_INT)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL44_TWR_INT(v)   BF_CS1(DRAM_CTL44, TWR_INT, v)
#endif

/* --- Register HW_DRAM_CTL44, field RSVD2 */

#define BP_DRAM_CTL44_RSVD2      11
#define BM_DRAM_CTL44_RSVD2      0x0000F800

#define BF_DRAM_CTL44_RSVD2(v)   (((v) << 11) & BM_DRAM_CTL44_RSVD2)
/* --- Register HW_DRAM_CTL44, field TRTP */

#define BP_DRAM_CTL44_TRTP      8
#define BM_DRAM_CTL44_TRTP      0x00000700

#define BF_DRAM_CTL44_TRTP(v)   (((v) << 8) & BM_DRAM_CTL44_TRTP)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL44_TRTP(v)   BF_CS1(DRAM_CTL44, TRTP, v)
#endif

/* --- Register HW_DRAM_CTL44, field RSVD1 */

#define BP_DRAM_CTL44_RSVD1      3
#define BM_DRAM_CTL44_RSVD1      0x000000F8

#define BF_DRAM_CTL44_RSVD1(v)   (((v) << 3) & BM_DRAM_CTL44_RSVD1)
/* --- Register HW_DRAM_CTL44, field TRRD */

#define BP_DRAM_CTL44_TRRD      0
#define BM_DRAM_CTL44_TRRD      0x00000007

#define BF_DRAM_CTL44_TRRD(v)   (((v) << 0) & BM_DRAM_CTL44_TRRD)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL44_TRRD(v)   BF_CS1(DRAM_CTL44, TRRD, v)
#endif



/*
 * HW_DRAM_CTL45 - DRAM Control Register 45
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TXSNR  : 16;
        unsigned TXSR   : 16;
    } B;
} hw_dram_ctl45_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL45 register
 */
#define HW_DRAM_CTL45_ADDR         (REGS_DRAM_BASE + 0xb4)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL45           (*(volatile hw_dram_ctl45_t *) HW_DRAM_CTL45_ADDR)
#define HW_DRAM_CTL45_RD()      (HW_DRAM_CTL45.U)
#define HW_DRAM_CTL45_WR(v)     (HW_DRAM_CTL45.U = (v))
#define HW_DRAM_CTL45_SET(v)    (HW_DRAM_CTL45_WR(HW_DRAM_CTL45_RD() |  (v)))
#define HW_DRAM_CTL45_CLR(v)    (HW_DRAM_CTL45_WR(HW_DRAM_CTL45_RD() & ~(v)))
#define HW_DRAM_CTL45_TOG(v)    (HW_DRAM_CTL45_WR(HW_DRAM_CTL45_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL45 bitfields
 */
/* --- Register HW_DRAM_CTL45, field TXSR */

#define BP_DRAM_CTL45_TXSR      16
#define BM_DRAM_CTL45_TXSR      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL45_TXSR(v)   ((((reg32_t) v) << 16) & BM_DRAM_CTL45_TXSR)
#else
#define BF_DRAM_CTL45_TXSR(v)   (((v) << 16) & BM_DRAM_CTL45_TXSR)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL45_TXSR(v)   (HW_DRAM_CTL45.B.TXSR = (v))
#endif

/* --- Register HW_DRAM_CTL45, field TXSNR */

#define BP_DRAM_CTL45_TXSNR      0
#define BM_DRAM_CTL45_TXSNR      0x0000FFFF

#define BF_DRAM_CTL45_TXSNR(v)   (((v) << 0) & BM_DRAM_CTL45_TXSNR)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL45_TXSNR(v)   (HW_DRAM_CTL45.B.TXSNR = (v))
#endif



/*
 * HW_DRAM_CTL48 - DRAM Control Register 48
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned AXI0_FIFO_TYPE_REG  :  2;
        unsigned RSVD1               :  6;
        unsigned AXI0_BDW            :  7;
        unsigned RSVD2               :  1;
        unsigned AXI0_BDW_OVFLOW     :  1;
        unsigned RSVD3               :  7;
        unsigned AXI0_CURRENT_BDW    :  7;
        unsigned RSVD4               :  1;
    } B;
} hw_dram_ctl48_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL48 register
 */
#define HW_DRAM_CTL48_ADDR         (REGS_DRAM_BASE + 0xc0)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL48           (*(volatile hw_dram_ctl48_t *) HW_DRAM_CTL48_ADDR)
#define HW_DRAM_CTL48_RD()      (HW_DRAM_CTL48.U)
#define HW_DRAM_CTL48_WR(v)     (HW_DRAM_CTL48.U = (v))
#define HW_DRAM_CTL48_SET(v)    (HW_DRAM_CTL48_WR(HW_DRAM_CTL48_RD() |  (v)))
#define HW_DRAM_CTL48_CLR(v)    (HW_DRAM_CTL48_WR(HW_DRAM_CTL48_RD() & ~(v)))
#define HW_DRAM_CTL48_TOG(v)    (HW_DRAM_CTL48_WR(HW_DRAM_CTL48_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL48 bitfields
 */
/* --- Register HW_DRAM_CTL48, field RSVD4 */

#define BP_DRAM_CTL48_RSVD4      31
#define BM_DRAM_CTL48_RSVD4      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL48_RSVD4(v)   ((((reg32_t) v) << 31) & BM_DRAM_CTL48_RSVD4)
#else
#define BF_DRAM_CTL48_RSVD4(v)   (((v) << 31) & BM_DRAM_CTL48_RSVD4)
#endif
/* --- Register HW_DRAM_CTL48, field AXI0_CURRENT_BDW */

#define BP_DRAM_CTL48_AXI0_CURRENT_BDW      24
#define BM_DRAM_CTL48_AXI0_CURRENT_BDW      0x7F000000

#define BF_DRAM_CTL48_AXI0_CURRENT_BDW(v)   (((v) << 24) & BM_DRAM_CTL48_AXI0_CURRENT_BDW)
/* --- Register HW_DRAM_CTL48, field RSVD3 */

#define BP_DRAM_CTL48_RSVD3      17
#define BM_DRAM_CTL48_RSVD3      0x00FE0000

#define BF_DRAM_CTL48_RSVD3(v)   (((v) << 17) & BM_DRAM_CTL48_RSVD3)
/* --- Register HW_DRAM_CTL48, field AXI0_BDW_OVFLOW */

#define BP_DRAM_CTL48_AXI0_BDW_OVFLOW      16
#define BM_DRAM_CTL48_AXI0_BDW_OVFLOW      0x00010000

#define BF_DRAM_CTL48_AXI0_BDW_OVFLOW(v)   (((v) << 16) & BM_DRAM_CTL48_AXI0_BDW_OVFLOW)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL48_AXI0_BDW_OVFLOW(v)   BF_CS1(DRAM_CTL48, AXI0_BDW_OVFLOW, v)
#endif

/* --- Register HW_DRAM_CTL48, field RSVD2 */

#define BP_DRAM_CTL48_RSVD2      15
#define BM_DRAM_CTL48_RSVD2      0x00008000

#define BF_DRAM_CTL48_RSVD2(v)   (((v) << 15) & BM_DRAM_CTL48_RSVD2)
/* --- Register HW_DRAM_CTL48, field AXI0_BDW */

#define BP_DRAM_CTL48_AXI0_BDW      8
#define BM_DRAM_CTL48_AXI0_BDW      0x00007F00

#define BF_DRAM_CTL48_AXI0_BDW(v)   (((v) << 8) & BM_DRAM_CTL48_AXI0_BDW)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL48_AXI0_BDW(v)   BF_CS1(DRAM_CTL48, AXI0_BDW, v)
#endif

/* --- Register HW_DRAM_CTL48, field RSVD1 */

#define BP_DRAM_CTL48_RSVD1      2
#define BM_DRAM_CTL48_RSVD1      0x000000FC

#define BF_DRAM_CTL48_RSVD1(v)   (((v) << 2) & BM_DRAM_CTL48_RSVD1)
/* --- Register HW_DRAM_CTL48, field AXI0_FIFO_TYPE_REG */

#define BP_DRAM_CTL48_AXI0_FIFO_TYPE_REG      0
#define BM_DRAM_CTL48_AXI0_FIFO_TYPE_REG      0x00000003

#define BF_DRAM_CTL48_AXI0_FIFO_TYPE_REG(v)   (((v) << 0) & BM_DRAM_CTL48_AXI0_FIFO_TYPE_REG)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL48_AXI0_FIFO_TYPE_REG(v)   BF_CS1(DRAM_CTL48, AXI0_FIFO_TYPE_REG, v)
#endif



/*
 * HW_DRAM_CTL49 - DRAM Control Register 49
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned AXI0_R_PRIORITY              :  3;
        unsigned RSVD1                        :  5;
        unsigned AXI0_W_PRIORITY              :  3;
        unsigned RSVD2                        :  5;
        unsigned AXI0_EN_SIZE_LT_WIDTH_INSTR  : 16;
    } B;
} hw_dram_ctl49_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL49 register
 */
#define HW_DRAM_CTL49_ADDR         (REGS_DRAM_BASE + 0xc4)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL49           (*(volatile hw_dram_ctl49_t *) HW_DRAM_CTL49_ADDR)
#define HW_DRAM_CTL49_RD()      (HW_DRAM_CTL49.U)
#define HW_DRAM_CTL49_WR(v)     (HW_DRAM_CTL49.U = (v))
#define HW_DRAM_CTL49_SET(v)    (HW_DRAM_CTL49_WR(HW_DRAM_CTL49_RD() |  (v)))
#define HW_DRAM_CTL49_CLR(v)    (HW_DRAM_CTL49_WR(HW_DRAM_CTL49_RD() & ~(v)))
#define HW_DRAM_CTL49_TOG(v)    (HW_DRAM_CTL49_WR(HW_DRAM_CTL49_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL49 bitfields
 */
/* --- Register HW_DRAM_CTL49, field AXI0_EN_SIZE_LT_WIDTH_INSTR */

#define BP_DRAM_CTL49_AXI0_EN_SIZE_LT_WIDTH_INSTR      16
#define BM_DRAM_CTL49_AXI0_EN_SIZE_LT_WIDTH_INSTR      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL49_AXI0_EN_SIZE_LT_WIDTH_INSTR(v)   ((((reg32_t) v) << 16) & BM_DRAM_CTL49_AXI0_EN_SIZE_LT_WIDTH_INSTR)
#else
#define BF_DRAM_CTL49_AXI0_EN_SIZE_LT_WIDTH_INSTR(v)   (((v) << 16) & BM_DRAM_CTL49_AXI0_EN_SIZE_LT_WIDTH_INSTR)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL49_AXI0_EN_SIZE_LT_WIDTH_INSTR(v)   (HW_DRAM_CTL49.B.AXI0_EN_SIZE_LT_WIDTH_INSTR = (v))
#endif

/* --- Register HW_DRAM_CTL49, field RSVD2 */

#define BP_DRAM_CTL49_RSVD2      11
#define BM_DRAM_CTL49_RSVD2      0x0000F800

#define BF_DRAM_CTL49_RSVD2(v)   (((v) << 11) & BM_DRAM_CTL49_RSVD2)
/* --- Register HW_DRAM_CTL49, field AXI0_W_PRIORITY */

#define BP_DRAM_CTL49_AXI0_W_PRIORITY      8
#define BM_DRAM_CTL49_AXI0_W_PRIORITY      0x00000700

#define BF_DRAM_CTL49_AXI0_W_PRIORITY(v)   (((v) << 8) & BM_DRAM_CTL49_AXI0_W_PRIORITY)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL49_AXI0_W_PRIORITY(v)   BF_CS1(DRAM_CTL49, AXI0_W_PRIORITY, v)
#endif

/* --- Register HW_DRAM_CTL49, field RSVD1 */

#define BP_DRAM_CTL49_RSVD1      3
#define BM_DRAM_CTL49_RSVD1      0x000000F8

#define BF_DRAM_CTL49_RSVD1(v)   (((v) << 3) & BM_DRAM_CTL49_RSVD1)
/* --- Register HW_DRAM_CTL49, field AXI0_R_PRIORITY */

#define BP_DRAM_CTL49_AXI0_R_PRIORITY      0
#define BM_DRAM_CTL49_AXI0_R_PRIORITY      0x00000007

#define BF_DRAM_CTL49_AXI0_R_PRIORITY(v)   (((v) << 0) & BM_DRAM_CTL49_AXI0_R_PRIORITY)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL49_AXI0_R_PRIORITY(v)   BF_CS1(DRAM_CTL49, AXI0_R_PRIORITY, v)
#endif



/*
 * HW_DRAM_CTL50 - DRAM Control Register 50
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned AXI1_FIFO_TYPE_REG  :  2;
        unsigned RSVD1               :  6;
        unsigned AXI1_BDW            :  7;
        unsigned RSVD2               :  1;
        unsigned AXI1_BDW_OVFLOW     :  1;
        unsigned RSVD3               :  7;
        unsigned AXI1_CURRENT_BDW    :  7;
        unsigned RSVD4               :  1;
    } B;
} hw_dram_ctl50_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL50 register
 */
#define HW_DRAM_CTL50_ADDR         (REGS_DRAM_BASE + 0xc8)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL50           (*(volatile hw_dram_ctl50_t *) HW_DRAM_CTL50_ADDR)
#define HW_DRAM_CTL50_RD()      (HW_DRAM_CTL50.U)
#define HW_DRAM_CTL50_WR(v)     (HW_DRAM_CTL50.U = (v))
#define HW_DRAM_CTL50_SET(v)    (HW_DRAM_CTL50_WR(HW_DRAM_CTL50_RD() |  (v)))
#define HW_DRAM_CTL50_CLR(v)    (HW_DRAM_CTL50_WR(HW_DRAM_CTL50_RD() & ~(v)))
#define HW_DRAM_CTL50_TOG(v)    (HW_DRAM_CTL50_WR(HW_DRAM_CTL50_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL50 bitfields
 */
/* --- Register HW_DRAM_CTL50, field RSVD4 */

#define BP_DRAM_CTL50_RSVD4      31
#define BM_DRAM_CTL50_RSVD4      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL50_RSVD4(v)   ((((reg32_t) v) << 31) & BM_DRAM_CTL50_RSVD4)
#else
#define BF_DRAM_CTL50_RSVD4(v)   (((v) << 31) & BM_DRAM_CTL50_RSVD4)
#endif
/* --- Register HW_DRAM_CTL50, field AXI1_CURRENT_BDW */

#define BP_DRAM_CTL50_AXI1_CURRENT_BDW      24
#define BM_DRAM_CTL50_AXI1_CURRENT_BDW      0x7F000000

#define BF_DRAM_CTL50_AXI1_CURRENT_BDW(v)   (((v) << 24) & BM_DRAM_CTL50_AXI1_CURRENT_BDW)
/* --- Register HW_DRAM_CTL50, field RSVD3 */

#define BP_DRAM_CTL50_RSVD3      17
#define BM_DRAM_CTL50_RSVD3      0x00FE0000

#define BF_DRAM_CTL50_RSVD3(v)   (((v) << 17) & BM_DRAM_CTL50_RSVD3)
/* --- Register HW_DRAM_CTL50, field AXI1_BDW_OVFLOW */

#define BP_DRAM_CTL50_AXI1_BDW_OVFLOW      16
#define BM_DRAM_CTL50_AXI1_BDW_OVFLOW      0x00010000

#define BF_DRAM_CTL50_AXI1_BDW_OVFLOW(v)   (((v) << 16) & BM_DRAM_CTL50_AXI1_BDW_OVFLOW)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL50_AXI1_BDW_OVFLOW(v)   BF_CS1(DRAM_CTL50, AXI1_BDW_OVFLOW, v)
#endif

/* --- Register HW_DRAM_CTL50, field RSVD2 */

#define BP_DRAM_CTL50_RSVD2      15
#define BM_DRAM_CTL50_RSVD2      0x00008000

#define BF_DRAM_CTL50_RSVD2(v)   (((v) << 15) & BM_DRAM_CTL50_RSVD2)
/* --- Register HW_DRAM_CTL50, field AXI1_BDW */

#define BP_DRAM_CTL50_AXI1_BDW      8
#define BM_DRAM_CTL50_AXI1_BDW      0x00007F00

#define BF_DRAM_CTL50_AXI1_BDW(v)   (((v) << 8) & BM_DRAM_CTL50_AXI1_BDW)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL50_AXI1_BDW(v)   BF_CS1(DRAM_CTL50, AXI1_BDW, v)
#endif

/* --- Register HW_DRAM_CTL50, field RSVD1 */

#define BP_DRAM_CTL50_RSVD1      2
#define BM_DRAM_CTL50_RSVD1      0x000000FC

#define BF_DRAM_CTL50_RSVD1(v)   (((v) << 2) & BM_DRAM_CTL50_RSVD1)
/* --- Register HW_DRAM_CTL50, field AXI1_FIFO_TYPE_REG */

#define BP_DRAM_CTL50_AXI1_FIFO_TYPE_REG      0
#define BM_DRAM_CTL50_AXI1_FIFO_TYPE_REG      0x00000003

#define BF_DRAM_CTL50_AXI1_FIFO_TYPE_REG(v)   (((v) << 0) & BM_DRAM_CTL50_AXI1_FIFO_TYPE_REG)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL50_AXI1_FIFO_TYPE_REG(v)   BF_CS1(DRAM_CTL50, AXI1_FIFO_TYPE_REG, v)
#endif



/*
 * HW_DRAM_CTL51 - DRAM Control Register 51
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned AXI1_R_PRIORITY              :  3;
        unsigned RSVD1                        :  5;
        unsigned AXI1_W_PRIORITY              :  3;
        unsigned RSVD2                        :  5;
        unsigned AXI1_EN_SIZE_LT_WIDTH_INSTR  : 16;
    } B;
} hw_dram_ctl51_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL51 register
 */
#define HW_DRAM_CTL51_ADDR         (REGS_DRAM_BASE + 0xcc)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL51           (*(volatile hw_dram_ctl51_t *) HW_DRAM_CTL51_ADDR)
#define HW_DRAM_CTL51_RD()      (HW_DRAM_CTL51.U)
#define HW_DRAM_CTL51_WR(v)     (HW_DRAM_CTL51.U = (v))
#define HW_DRAM_CTL51_SET(v)    (HW_DRAM_CTL51_WR(HW_DRAM_CTL51_RD() |  (v)))
#define HW_DRAM_CTL51_CLR(v)    (HW_DRAM_CTL51_WR(HW_DRAM_CTL51_RD() & ~(v)))
#define HW_DRAM_CTL51_TOG(v)    (HW_DRAM_CTL51_WR(HW_DRAM_CTL51_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL51 bitfields
 */
/* --- Register HW_DRAM_CTL51, field AXI1_EN_SIZE_LT_WIDTH_INSTR */

#define BP_DRAM_CTL51_AXI1_EN_SIZE_LT_WIDTH_INSTR      16
#define BM_DRAM_CTL51_AXI1_EN_SIZE_LT_WIDTH_INSTR      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL51_AXI1_EN_SIZE_LT_WIDTH_INSTR(v)   ((((reg32_t) v) << 16) & BM_DRAM_CTL51_AXI1_EN_SIZE_LT_WIDTH_INSTR)
#else
#define BF_DRAM_CTL51_AXI1_EN_SIZE_LT_WIDTH_INSTR(v)   (((v) << 16) & BM_DRAM_CTL51_AXI1_EN_SIZE_LT_WIDTH_INSTR)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL51_AXI1_EN_SIZE_LT_WIDTH_INSTR(v)   (HW_DRAM_CTL51.B.AXI1_EN_SIZE_LT_WIDTH_INSTR = (v))
#endif

/* --- Register HW_DRAM_CTL51, field RSVD2 */

#define BP_DRAM_CTL51_RSVD2      11
#define BM_DRAM_CTL51_RSVD2      0x0000F800

#define BF_DRAM_CTL51_RSVD2(v)   (((v) << 11) & BM_DRAM_CTL51_RSVD2)
/* --- Register HW_DRAM_CTL51, field AXI1_W_PRIORITY */

#define BP_DRAM_CTL51_AXI1_W_PRIORITY      8
#define BM_DRAM_CTL51_AXI1_W_PRIORITY      0x00000700

#define BF_DRAM_CTL51_AXI1_W_PRIORITY(v)   (((v) << 8) & BM_DRAM_CTL51_AXI1_W_PRIORITY)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL51_AXI1_W_PRIORITY(v)   BF_CS1(DRAM_CTL51, AXI1_W_PRIORITY, v)
#endif

/* --- Register HW_DRAM_CTL51, field RSVD1 */

#define BP_DRAM_CTL51_RSVD1      3
#define BM_DRAM_CTL51_RSVD1      0x000000F8

#define BF_DRAM_CTL51_RSVD1(v)   (((v) << 3) & BM_DRAM_CTL51_RSVD1)
/* --- Register HW_DRAM_CTL51, field AXI1_R_PRIORITY */

#define BP_DRAM_CTL51_AXI1_R_PRIORITY      0
#define BM_DRAM_CTL51_AXI1_R_PRIORITY      0x00000007

#define BF_DRAM_CTL51_AXI1_R_PRIORITY(v)   (((v) << 0) & BM_DRAM_CTL51_AXI1_R_PRIORITY)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL51_AXI1_R_PRIORITY(v)   BF_CS1(DRAM_CTL51, AXI1_R_PRIORITY, v)
#endif



/*
 * HW_DRAM_CTL52 - DRAM Control Register 52
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned AXI2_FIFO_TYPE_REG  :  2;
        unsigned RSVD1               :  6;
        unsigned AXI2_BDW            :  7;
        unsigned RSVD2               :  1;
        unsigned AXI2_BDW_OVFLOW     :  1;
        unsigned RSVD3               :  7;
        unsigned AXI2_CURRENT_BDW    :  7;
        unsigned RSVD4               :  1;
    } B;
} hw_dram_ctl52_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL52 register
 */
#define HW_DRAM_CTL52_ADDR         (REGS_DRAM_BASE + 0xd0)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL52           (*(volatile hw_dram_ctl52_t *) HW_DRAM_CTL52_ADDR)
#define HW_DRAM_CTL52_RD()      (HW_DRAM_CTL52.U)
#define HW_DRAM_CTL52_WR(v)     (HW_DRAM_CTL52.U = (v))
#define HW_DRAM_CTL52_SET(v)    (HW_DRAM_CTL52_WR(HW_DRAM_CTL52_RD() |  (v)))
#define HW_DRAM_CTL52_CLR(v)    (HW_DRAM_CTL52_WR(HW_DRAM_CTL52_RD() & ~(v)))
#define HW_DRAM_CTL52_TOG(v)    (HW_DRAM_CTL52_WR(HW_DRAM_CTL52_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL52 bitfields
 */
/* --- Register HW_DRAM_CTL52, field RSVD4 */

#define BP_DRAM_CTL52_RSVD4      31
#define BM_DRAM_CTL52_RSVD4      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL52_RSVD4(v)   ((((reg32_t) v) << 31) & BM_DRAM_CTL52_RSVD4)
#else
#define BF_DRAM_CTL52_RSVD4(v)   (((v) << 31) & BM_DRAM_CTL52_RSVD4)
#endif
/* --- Register HW_DRAM_CTL52, field AXI2_CURRENT_BDW */

#define BP_DRAM_CTL52_AXI2_CURRENT_BDW      24
#define BM_DRAM_CTL52_AXI2_CURRENT_BDW      0x7F000000

#define BF_DRAM_CTL52_AXI2_CURRENT_BDW(v)   (((v) << 24) & BM_DRAM_CTL52_AXI2_CURRENT_BDW)
/* --- Register HW_DRAM_CTL52, field RSVD3 */

#define BP_DRAM_CTL52_RSVD3      17
#define BM_DRAM_CTL52_RSVD3      0x00FE0000

#define BF_DRAM_CTL52_RSVD3(v)   (((v) << 17) & BM_DRAM_CTL52_RSVD3)
/* --- Register HW_DRAM_CTL52, field AXI2_BDW_OVFLOW */

#define BP_DRAM_CTL52_AXI2_BDW_OVFLOW      16
#define BM_DRAM_CTL52_AXI2_BDW_OVFLOW      0x00010000

#define BF_DRAM_CTL52_AXI2_BDW_OVFLOW(v)   (((v) << 16) & BM_DRAM_CTL52_AXI2_BDW_OVFLOW)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL52_AXI2_BDW_OVFLOW(v)   BF_CS1(DRAM_CTL52, AXI2_BDW_OVFLOW, v)
#endif

/* --- Register HW_DRAM_CTL52, field RSVD2 */

#define BP_DRAM_CTL52_RSVD2      15
#define BM_DRAM_CTL52_RSVD2      0x00008000

#define BF_DRAM_CTL52_RSVD2(v)   (((v) << 15) & BM_DRAM_CTL52_RSVD2)
/* --- Register HW_DRAM_CTL52, field AXI2_BDW */

#define BP_DRAM_CTL52_AXI2_BDW      8
#define BM_DRAM_CTL52_AXI2_BDW      0x00007F00

#define BF_DRAM_CTL52_AXI2_BDW(v)   (((v) << 8) & BM_DRAM_CTL52_AXI2_BDW)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL52_AXI2_BDW(v)   BF_CS1(DRAM_CTL52, AXI2_BDW, v)
#endif

/* --- Register HW_DRAM_CTL52, field RSVD1 */

#define BP_DRAM_CTL52_RSVD1      2
#define BM_DRAM_CTL52_RSVD1      0x000000FC

#define BF_DRAM_CTL52_RSVD1(v)   (((v) << 2) & BM_DRAM_CTL52_RSVD1)
/* --- Register HW_DRAM_CTL52, field AXI2_FIFO_TYPE_REG */

#define BP_DRAM_CTL52_AXI2_FIFO_TYPE_REG      0
#define BM_DRAM_CTL52_AXI2_FIFO_TYPE_REG      0x00000003

#define BF_DRAM_CTL52_AXI2_FIFO_TYPE_REG(v)   (((v) << 0) & BM_DRAM_CTL52_AXI2_FIFO_TYPE_REG)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL52_AXI2_FIFO_TYPE_REG(v)   BF_CS1(DRAM_CTL52, AXI2_FIFO_TYPE_REG, v)
#endif



/*
 * HW_DRAM_CTL53 - DRAM Control Register 53
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned AXI2_R_PRIORITY              :  3;
        unsigned RSVD1                        :  5;
        unsigned AXI2_W_PRIORITY              :  3;
        unsigned RSVD2                        :  5;
        unsigned AXI2_EN_SIZE_LT_WIDTH_INSTR  : 16;
    } B;
} hw_dram_ctl53_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL53 register
 */
#define HW_DRAM_CTL53_ADDR         (REGS_DRAM_BASE + 0xd4)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL53           (*(volatile hw_dram_ctl53_t *) HW_DRAM_CTL53_ADDR)
#define HW_DRAM_CTL53_RD()      (HW_DRAM_CTL53.U)
#define HW_DRAM_CTL53_WR(v)     (HW_DRAM_CTL53.U = (v))
#define HW_DRAM_CTL53_SET(v)    (HW_DRAM_CTL53_WR(HW_DRAM_CTL53_RD() |  (v)))
#define HW_DRAM_CTL53_CLR(v)    (HW_DRAM_CTL53_WR(HW_DRAM_CTL53_RD() & ~(v)))
#define HW_DRAM_CTL53_TOG(v)    (HW_DRAM_CTL53_WR(HW_DRAM_CTL53_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL53 bitfields
 */
/* --- Register HW_DRAM_CTL53, field AXI2_EN_SIZE_LT_WIDTH_INSTR */

#define BP_DRAM_CTL53_AXI2_EN_SIZE_LT_WIDTH_INSTR      16
#define BM_DRAM_CTL53_AXI2_EN_SIZE_LT_WIDTH_INSTR      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL53_AXI2_EN_SIZE_LT_WIDTH_INSTR(v)   ((((reg32_t) v) << 16) & BM_DRAM_CTL53_AXI2_EN_SIZE_LT_WIDTH_INSTR)
#else
#define BF_DRAM_CTL53_AXI2_EN_SIZE_LT_WIDTH_INSTR(v)   (((v) << 16) & BM_DRAM_CTL53_AXI2_EN_SIZE_LT_WIDTH_INSTR)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL53_AXI2_EN_SIZE_LT_WIDTH_INSTR(v)   (HW_DRAM_CTL53.B.AXI2_EN_SIZE_LT_WIDTH_INSTR = (v))
#endif

/* --- Register HW_DRAM_CTL53, field RSVD2 */

#define BP_DRAM_CTL53_RSVD2      11
#define BM_DRAM_CTL53_RSVD2      0x0000F800

#define BF_DRAM_CTL53_RSVD2(v)   (((v) << 11) & BM_DRAM_CTL53_RSVD2)
/* --- Register HW_DRAM_CTL53, field AXI2_W_PRIORITY */

#define BP_DRAM_CTL53_AXI2_W_PRIORITY      8
#define BM_DRAM_CTL53_AXI2_W_PRIORITY      0x00000700

#define BF_DRAM_CTL53_AXI2_W_PRIORITY(v)   (((v) << 8) & BM_DRAM_CTL53_AXI2_W_PRIORITY)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL53_AXI2_W_PRIORITY(v)   BF_CS1(DRAM_CTL53, AXI2_W_PRIORITY, v)
#endif

/* --- Register HW_DRAM_CTL53, field RSVD1 */

#define BP_DRAM_CTL53_RSVD1      3
#define BM_DRAM_CTL53_RSVD1      0x000000F8

#define BF_DRAM_CTL53_RSVD1(v)   (((v) << 3) & BM_DRAM_CTL53_RSVD1)
/* --- Register HW_DRAM_CTL53, field AXI2_R_PRIORITY */

#define BP_DRAM_CTL53_AXI2_R_PRIORITY      0
#define BM_DRAM_CTL53_AXI2_R_PRIORITY      0x00000007

#define BF_DRAM_CTL53_AXI2_R_PRIORITY(v)   (((v) << 0) & BM_DRAM_CTL53_AXI2_R_PRIORITY)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL53_AXI2_R_PRIORITY(v)   BF_CS1(DRAM_CTL53, AXI2_R_PRIORITY, v)
#endif



/*
 * HW_DRAM_CTL54 - DRAM Control Register 54
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned AXI3_FIFO_TYPE_REG  :  2;
        unsigned RSVD1               :  6;
        unsigned AXI3_BDW            :  7;
        unsigned RSVD2               :  1;
        unsigned AXI3_BDW_OVFLOW     :  1;
        unsigned RSVD3               :  7;
        unsigned AXI3_CURRENT_BDW    :  7;
        unsigned RSVD4               :  1;
    } B;
} hw_dram_ctl54_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL54 register
 */
#define HW_DRAM_CTL54_ADDR         (REGS_DRAM_BASE + 0xd8)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL54           (*(volatile hw_dram_ctl54_t *) HW_DRAM_CTL54_ADDR)
#define HW_DRAM_CTL54_RD()      (HW_DRAM_CTL54.U)
#define HW_DRAM_CTL54_WR(v)     (HW_DRAM_CTL54.U = (v))
#define HW_DRAM_CTL54_SET(v)    (HW_DRAM_CTL54_WR(HW_DRAM_CTL54_RD() |  (v)))
#define HW_DRAM_CTL54_CLR(v)    (HW_DRAM_CTL54_WR(HW_DRAM_CTL54_RD() & ~(v)))
#define HW_DRAM_CTL54_TOG(v)    (HW_DRAM_CTL54_WR(HW_DRAM_CTL54_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL54 bitfields
 */
/* --- Register HW_DRAM_CTL54, field RSVD4 */

#define BP_DRAM_CTL54_RSVD4      31
#define BM_DRAM_CTL54_RSVD4      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL54_RSVD4(v)   ((((reg32_t) v) << 31) & BM_DRAM_CTL54_RSVD4)
#else
#define BF_DRAM_CTL54_RSVD4(v)   (((v) << 31) & BM_DRAM_CTL54_RSVD4)
#endif
/* --- Register HW_DRAM_CTL54, field AXI3_CURRENT_BDW */

#define BP_DRAM_CTL54_AXI3_CURRENT_BDW      24
#define BM_DRAM_CTL54_AXI3_CURRENT_BDW      0x7F000000

#define BF_DRAM_CTL54_AXI3_CURRENT_BDW(v)   (((v) << 24) & BM_DRAM_CTL54_AXI3_CURRENT_BDW)
/* --- Register HW_DRAM_CTL54, field RSVD3 */

#define BP_DRAM_CTL54_RSVD3      17
#define BM_DRAM_CTL54_RSVD3      0x00FE0000

#define BF_DRAM_CTL54_RSVD3(v)   (((v) << 17) & BM_DRAM_CTL54_RSVD3)
/* --- Register HW_DRAM_CTL54, field AXI3_BDW_OVFLOW */

#define BP_DRAM_CTL54_AXI3_BDW_OVFLOW      16
#define BM_DRAM_CTL54_AXI3_BDW_OVFLOW      0x00010000

#define BF_DRAM_CTL54_AXI3_BDW_OVFLOW(v)   (((v) << 16) & BM_DRAM_CTL54_AXI3_BDW_OVFLOW)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL54_AXI3_BDW_OVFLOW(v)   BF_CS1(DRAM_CTL54, AXI3_BDW_OVFLOW, v)
#endif

/* --- Register HW_DRAM_CTL54, field RSVD2 */

#define BP_DRAM_CTL54_RSVD2      15
#define BM_DRAM_CTL54_RSVD2      0x00008000

#define BF_DRAM_CTL54_RSVD2(v)   (((v) << 15) & BM_DRAM_CTL54_RSVD2)
/* --- Register HW_DRAM_CTL54, field AXI3_BDW */

#define BP_DRAM_CTL54_AXI3_BDW      8
#define BM_DRAM_CTL54_AXI3_BDW      0x00007F00

#define BF_DRAM_CTL54_AXI3_BDW(v)   (((v) << 8) & BM_DRAM_CTL54_AXI3_BDW)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL54_AXI3_BDW(v)   BF_CS1(DRAM_CTL54, AXI3_BDW, v)
#endif

/* --- Register HW_DRAM_CTL54, field RSVD1 */

#define BP_DRAM_CTL54_RSVD1      2
#define BM_DRAM_CTL54_RSVD1      0x000000FC

#define BF_DRAM_CTL54_RSVD1(v)   (((v) << 2) & BM_DRAM_CTL54_RSVD1)
/* --- Register HW_DRAM_CTL54, field AXI3_FIFO_TYPE_REG */

#define BP_DRAM_CTL54_AXI3_FIFO_TYPE_REG      0
#define BM_DRAM_CTL54_AXI3_FIFO_TYPE_REG      0x00000003

#define BF_DRAM_CTL54_AXI3_FIFO_TYPE_REG(v)   (((v) << 0) & BM_DRAM_CTL54_AXI3_FIFO_TYPE_REG)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL54_AXI3_FIFO_TYPE_REG(v)   BF_CS1(DRAM_CTL54, AXI3_FIFO_TYPE_REG, v)
#endif



/*
 * HW_DRAM_CTL55 - DRAM Control Register 55
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned AXI3_R_PRIORITY              :  3;
        unsigned RSVD1                        :  5;
        unsigned AXI3_W_PRIORITY              :  3;
        unsigned RSVD2                        :  5;
        unsigned AXI3_EN_SIZE_LT_WIDTH_INSTR  : 16;
    } B;
} hw_dram_ctl55_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL55 register
 */
#define HW_DRAM_CTL55_ADDR         (REGS_DRAM_BASE + 0xdc)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL55           (*(volatile hw_dram_ctl55_t *) HW_DRAM_CTL55_ADDR)
#define HW_DRAM_CTL55_RD()      (HW_DRAM_CTL55.U)
#define HW_DRAM_CTL55_WR(v)     (HW_DRAM_CTL55.U = (v))
#define HW_DRAM_CTL55_SET(v)    (HW_DRAM_CTL55_WR(HW_DRAM_CTL55_RD() |  (v)))
#define HW_DRAM_CTL55_CLR(v)    (HW_DRAM_CTL55_WR(HW_DRAM_CTL55_RD() & ~(v)))
#define HW_DRAM_CTL55_TOG(v)    (HW_DRAM_CTL55_WR(HW_DRAM_CTL55_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL55 bitfields
 */
/* --- Register HW_DRAM_CTL55, field AXI3_EN_SIZE_LT_WIDTH_INSTR */

#define BP_DRAM_CTL55_AXI3_EN_SIZE_LT_WIDTH_INSTR      16
#define BM_DRAM_CTL55_AXI3_EN_SIZE_LT_WIDTH_INSTR      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL55_AXI3_EN_SIZE_LT_WIDTH_INSTR(v)   ((((reg32_t) v) << 16) & BM_DRAM_CTL55_AXI3_EN_SIZE_LT_WIDTH_INSTR)
#else
#define BF_DRAM_CTL55_AXI3_EN_SIZE_LT_WIDTH_INSTR(v)   (((v) << 16) & BM_DRAM_CTL55_AXI3_EN_SIZE_LT_WIDTH_INSTR)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL55_AXI3_EN_SIZE_LT_WIDTH_INSTR(v)   (HW_DRAM_CTL55.B.AXI3_EN_SIZE_LT_WIDTH_INSTR = (v))
#endif

/* --- Register HW_DRAM_CTL55, field RSVD2 */

#define BP_DRAM_CTL55_RSVD2      11
#define BM_DRAM_CTL55_RSVD2      0x0000F800

#define BF_DRAM_CTL55_RSVD2(v)   (((v) << 11) & BM_DRAM_CTL55_RSVD2)
/* --- Register HW_DRAM_CTL55, field AXI3_W_PRIORITY */

#define BP_DRAM_CTL55_AXI3_W_PRIORITY      8
#define BM_DRAM_CTL55_AXI3_W_PRIORITY      0x00000700

#define BF_DRAM_CTL55_AXI3_W_PRIORITY(v)   (((v) << 8) & BM_DRAM_CTL55_AXI3_W_PRIORITY)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL55_AXI3_W_PRIORITY(v)   BF_CS1(DRAM_CTL55, AXI3_W_PRIORITY, v)
#endif

/* --- Register HW_DRAM_CTL55, field RSVD1 */

#define BP_DRAM_CTL55_RSVD1      3
#define BM_DRAM_CTL55_RSVD1      0x000000F8

#define BF_DRAM_CTL55_RSVD1(v)   (((v) << 3) & BM_DRAM_CTL55_RSVD1)
/* --- Register HW_DRAM_CTL55, field AXI3_R_PRIORITY */

#define BP_DRAM_CTL55_AXI3_R_PRIORITY      0
#define BM_DRAM_CTL55_AXI3_R_PRIORITY      0x00000007

#define BF_DRAM_CTL55_AXI3_R_PRIORITY(v)   (((v) << 0) & BM_DRAM_CTL55_AXI3_R_PRIORITY)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL55_AXI3_R_PRIORITY(v)   BF_CS1(DRAM_CTL55, AXI3_R_PRIORITY, v)
#endif



/*
 * HW_DRAM_CTL56 - DRAM Control Register 56
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ARB_CMD_Q_THRESHOLD  :  3;
        unsigned RSVD1                :  5;
        unsigned OBSOLETE             : 24;
    } B;
} hw_dram_ctl56_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL56 register
 */
#define HW_DRAM_CTL56_ADDR         (REGS_DRAM_BASE + 0xe0)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL56           (*(volatile hw_dram_ctl56_t *) HW_DRAM_CTL56_ADDR)
#define HW_DRAM_CTL56_RD()      (HW_DRAM_CTL56.U)
#define HW_DRAM_CTL56_WR(v)     (HW_DRAM_CTL56.U = (v))
#define HW_DRAM_CTL56_SET(v)    (HW_DRAM_CTL56_WR(HW_DRAM_CTL56_RD() |  (v)))
#define HW_DRAM_CTL56_CLR(v)    (HW_DRAM_CTL56_WR(HW_DRAM_CTL56_RD() & ~(v)))
#define HW_DRAM_CTL56_TOG(v)    (HW_DRAM_CTL56_WR(HW_DRAM_CTL56_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL56 bitfields
 */
/* --- Register HW_DRAM_CTL56, field OBSOLETE */

#define BP_DRAM_CTL56_OBSOLETE      8
#define BM_DRAM_CTL56_OBSOLETE      0xFFFFFF00

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL56_OBSOLETE(v)   ((((reg32_t) v) << 8) & BM_DRAM_CTL56_OBSOLETE)
#else
#define BF_DRAM_CTL56_OBSOLETE(v)   (((v) << 8) & BM_DRAM_CTL56_OBSOLETE)
#endif
/* --- Register HW_DRAM_CTL56, field RSVD1 */

#define BP_DRAM_CTL56_RSVD1      3
#define BM_DRAM_CTL56_RSVD1      0x000000F8

#define BF_DRAM_CTL56_RSVD1(v)   (((v) << 3) & BM_DRAM_CTL56_RSVD1)
/* --- Register HW_DRAM_CTL56, field ARB_CMD_Q_THRESHOLD */

#define BP_DRAM_CTL56_ARB_CMD_Q_THRESHOLD      0
#define BM_DRAM_CTL56_ARB_CMD_Q_THRESHOLD      0x00000007

#define BF_DRAM_CTL56_ARB_CMD_Q_THRESHOLD(v)   (((v) << 0) & BM_DRAM_CTL56_ARB_CMD_Q_THRESHOLD)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL56_ARB_CMD_Q_THRESHOLD(v)   BF_CS1(DRAM_CTL56, ARB_CMD_Q_THRESHOLD, v)
#endif



/*
 * HW_DRAM_CTL58 - DRAM Control Register 58
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned INT_MASK    : 11;
        unsigned RSVD1       :  5;
        unsigned INT_STATUS  : 11;
        unsigned RSVD2       :  5;
    } B;
} hw_dram_ctl58_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL58 register
 */
#define HW_DRAM_CTL58_ADDR         (REGS_DRAM_BASE + 0xe8)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL58           (*(volatile hw_dram_ctl58_t *) HW_DRAM_CTL58_ADDR)
#define HW_DRAM_CTL58_RD()      (HW_DRAM_CTL58.U)
#define HW_DRAM_CTL58_WR(v)     (HW_DRAM_CTL58.U = (v))
#define HW_DRAM_CTL58_SET(v)    (HW_DRAM_CTL58_WR(HW_DRAM_CTL58_RD() |  (v)))
#define HW_DRAM_CTL58_CLR(v)    (HW_DRAM_CTL58_WR(HW_DRAM_CTL58_RD() & ~(v)))
#define HW_DRAM_CTL58_TOG(v)    (HW_DRAM_CTL58_WR(HW_DRAM_CTL58_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL58 bitfields
 */
/* --- Register HW_DRAM_CTL58, field RSVD2 */

#define BP_DRAM_CTL58_RSVD2      27
#define BM_DRAM_CTL58_RSVD2      0xF8000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL58_RSVD2(v)   ((((reg32_t) v) << 27) & BM_DRAM_CTL58_RSVD2)
#else
#define BF_DRAM_CTL58_RSVD2(v)   (((v) << 27) & BM_DRAM_CTL58_RSVD2)
#endif
/* --- Register HW_DRAM_CTL58, field INT_STATUS */

#define BP_DRAM_CTL58_INT_STATUS      16
#define BM_DRAM_CTL58_INT_STATUS      0x07FF0000

#define BF_DRAM_CTL58_INT_STATUS(v)   (((v) << 16) & BM_DRAM_CTL58_INT_STATUS)
/* --- Register HW_DRAM_CTL58, field RSVD1 */

#define BP_DRAM_CTL58_RSVD1      11
#define BM_DRAM_CTL58_RSVD1      0x0000F800

#define BF_DRAM_CTL58_RSVD1(v)   (((v) << 11) & BM_DRAM_CTL58_RSVD1)
/* --- Register HW_DRAM_CTL58, field INT_MASK */

#define BP_DRAM_CTL58_INT_MASK      0
#define BM_DRAM_CTL58_INT_MASK      0x000007FF

#define BF_DRAM_CTL58_INT_MASK(v)   (((v) << 0) & BM_DRAM_CTL58_INT_MASK)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL58_INT_MASK(v)   BF_CS1(DRAM_CTL58, INT_MASK, v)
#endif



/*
 * HW_DRAM_CTL59 - DRAM Control Register 59
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned OUT_OF_RANGE_ADDR  : 32;
    } B;
} hw_dram_ctl59_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL59 register
 */
#define HW_DRAM_CTL59_ADDR         (REGS_DRAM_BASE + 0xec)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL59           (*(volatile hw_dram_ctl59_t *) HW_DRAM_CTL59_ADDR)
#define HW_DRAM_CTL59_RD()      (HW_DRAM_CTL59.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL59 bitfields
 */
/* --- Register HW_DRAM_CTL59, field OUT_OF_RANGE_ADDR */

#define BP_DRAM_CTL59_OUT_OF_RANGE_ADDR      0
#define BM_DRAM_CTL59_OUT_OF_RANGE_ADDR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL59_OUT_OF_RANGE_ADDR(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL59_OUT_OF_RANGE_ADDR(v)   (v)
#endif


/*
 * HW_DRAM_CTL60 - DRAM Control Register 60
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned OUT_OF_RANGE_ADDR  :  2;
        unsigned RSVD1              :  6;
        unsigned OBSOLETE           : 24;
    } B;
} hw_dram_ctl60_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL60 register
 */
#define HW_DRAM_CTL60_ADDR         (REGS_DRAM_BASE + 0xf0)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL60           (*(volatile hw_dram_ctl60_t *) HW_DRAM_CTL60_ADDR)
#define HW_DRAM_CTL60_RD()      (HW_DRAM_CTL60.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL60 bitfields
 */
/* --- Register HW_DRAM_CTL60, field OBSOLETE */

#define BP_DRAM_CTL60_OBSOLETE      8
#define BM_DRAM_CTL60_OBSOLETE      0xFFFFFF00

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL60_OBSOLETE(v)   ((((reg32_t) v) << 8) & BM_DRAM_CTL60_OBSOLETE)
#else
#define BF_DRAM_CTL60_OBSOLETE(v)   (((v) << 8) & BM_DRAM_CTL60_OBSOLETE)
#endif
/* --- Register HW_DRAM_CTL60, field RSVD1 */

#define BP_DRAM_CTL60_RSVD1      2
#define BM_DRAM_CTL60_RSVD1      0x000000FC

#define BF_DRAM_CTL60_RSVD1(v)   (((v) << 2) & BM_DRAM_CTL60_RSVD1)
/* --- Register HW_DRAM_CTL60, field OUT_OF_RANGE_ADDR */

#define BP_DRAM_CTL60_OUT_OF_RANGE_ADDR      0
#define BM_DRAM_CTL60_OUT_OF_RANGE_ADDR      0x00000003

#define BF_DRAM_CTL60_OUT_OF_RANGE_ADDR(v)   (((v) << 0) & BM_DRAM_CTL60_OUT_OF_RANGE_ADDR)


/*
 * HW_DRAM_CTL61 - DRAM Control Register 61
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned OUT_OF_RANGE_SOURCE_ID  : 13;
        unsigned RSVD1                   :  3;
        unsigned OUT_OF_RANGE_LENGTH     :  7;
        unsigned RSVD2                   :  1;
        unsigned OUT_OF_RANGE_TYPE       :  6;
        unsigned RSVD3                   :  2;
    } B;
} hw_dram_ctl61_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL61 register
 */
#define HW_DRAM_CTL61_ADDR         (REGS_DRAM_BASE + 0xf4)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL61           (*(volatile hw_dram_ctl61_t *) HW_DRAM_CTL61_ADDR)
#define HW_DRAM_CTL61_RD()      (HW_DRAM_CTL61.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL61 bitfields
 */
/* --- Register HW_DRAM_CTL61, field RSVD3 */

#define BP_DRAM_CTL61_RSVD3      30
#define BM_DRAM_CTL61_RSVD3      0xC0000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL61_RSVD3(v)   ((((reg32_t) v) << 30) & BM_DRAM_CTL61_RSVD3)
#else
#define BF_DRAM_CTL61_RSVD3(v)   (((v) << 30) & BM_DRAM_CTL61_RSVD3)
#endif
/* --- Register HW_DRAM_CTL61, field OUT_OF_RANGE_TYPE */

#define BP_DRAM_CTL61_OUT_OF_RANGE_TYPE      24
#define BM_DRAM_CTL61_OUT_OF_RANGE_TYPE      0x3F000000

#define BF_DRAM_CTL61_OUT_OF_RANGE_TYPE(v)   (((v) << 24) & BM_DRAM_CTL61_OUT_OF_RANGE_TYPE)
/* --- Register HW_DRAM_CTL61, field RSVD2 */

#define BP_DRAM_CTL61_RSVD2      23
#define BM_DRAM_CTL61_RSVD2      0x00800000

#define BF_DRAM_CTL61_RSVD2(v)   (((v) << 23) & BM_DRAM_CTL61_RSVD2)
/* --- Register HW_DRAM_CTL61, field OUT_OF_RANGE_LENGTH */

#define BP_DRAM_CTL61_OUT_OF_RANGE_LENGTH      16
#define BM_DRAM_CTL61_OUT_OF_RANGE_LENGTH      0x007F0000

#define BF_DRAM_CTL61_OUT_OF_RANGE_LENGTH(v)   (((v) << 16) & BM_DRAM_CTL61_OUT_OF_RANGE_LENGTH)
/* --- Register HW_DRAM_CTL61, field RSVD1 */

#define BP_DRAM_CTL61_RSVD1      13
#define BM_DRAM_CTL61_RSVD1      0x0000E000

#define BF_DRAM_CTL61_RSVD1(v)   (((v) << 13) & BM_DRAM_CTL61_RSVD1)
/* --- Register HW_DRAM_CTL61, field OUT_OF_RANGE_SOURCE_ID */

#define BP_DRAM_CTL61_OUT_OF_RANGE_SOURCE_ID      0
#define BM_DRAM_CTL61_OUT_OF_RANGE_SOURCE_ID      0x00001FFF

#define BF_DRAM_CTL61_OUT_OF_RANGE_SOURCE_ID(v)   (((v) << 0) & BM_DRAM_CTL61_OUT_OF_RANGE_SOURCE_ID)


/*
 * HW_DRAM_CTL62 - DRAM Control Register 62
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PORT_CMD_ERROR_ADDR  : 32;
    } B;
} hw_dram_ctl62_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL62 register
 */
#define HW_DRAM_CTL62_ADDR         (REGS_DRAM_BASE + 0xf8)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL62           (*(volatile hw_dram_ctl62_t *) HW_DRAM_CTL62_ADDR)
#define HW_DRAM_CTL62_RD()      (HW_DRAM_CTL62.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL62 bitfields
 */
/* --- Register HW_DRAM_CTL62, field PORT_CMD_ERROR_ADDR */

#define BP_DRAM_CTL62_PORT_CMD_ERROR_ADDR      0
#define BM_DRAM_CTL62_PORT_CMD_ERROR_ADDR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL62_PORT_CMD_ERROR_ADDR(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL62_PORT_CMD_ERROR_ADDR(v)   (v)
#endif


/*
 * HW_DRAM_CTL63 - DRAM Control Register 63
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PORT_CMD_ERROR_ADDR  :  2;
        unsigned RSVD1                :  6;
        unsigned OBSOLETE             : 24;
    } B;
} hw_dram_ctl63_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL63 register
 */
#define HW_DRAM_CTL63_ADDR         (REGS_DRAM_BASE + 0xfc)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL63           (*(volatile hw_dram_ctl63_t *) HW_DRAM_CTL63_ADDR)
#define HW_DRAM_CTL63_RD()      (HW_DRAM_CTL63.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL63 bitfields
 */
/* --- Register HW_DRAM_CTL63, field OBSOLETE */

#define BP_DRAM_CTL63_OBSOLETE      8
#define BM_DRAM_CTL63_OBSOLETE      0xFFFFFF00

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL63_OBSOLETE(v)   ((((reg32_t) v) << 8) & BM_DRAM_CTL63_OBSOLETE)
#else
#define BF_DRAM_CTL63_OBSOLETE(v)   (((v) << 8) & BM_DRAM_CTL63_OBSOLETE)
#endif
/* --- Register HW_DRAM_CTL63, field RSVD1 */

#define BP_DRAM_CTL63_RSVD1      2
#define BM_DRAM_CTL63_RSVD1      0x000000FC

#define BF_DRAM_CTL63_RSVD1(v)   (((v) << 2) & BM_DRAM_CTL63_RSVD1)
/* --- Register HW_DRAM_CTL63, field PORT_CMD_ERROR_ADDR */

#define BP_DRAM_CTL63_PORT_CMD_ERROR_ADDR      0
#define BM_DRAM_CTL63_PORT_CMD_ERROR_ADDR      0x00000003

#define BF_DRAM_CTL63_PORT_CMD_ERROR_ADDR(v)   (((v) << 0) & BM_DRAM_CTL63_PORT_CMD_ERROR_ADDR)


/*
 * HW_DRAM_CTL64 - DRAM Control Register 64
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PORT_CMD_ERROR_TYPE  :  4;
        unsigned RSVD1                :  4;
        unsigned PORT_CMD_ERROR_ID    : 13;
        unsigned RSVD2                :  3;
        unsigned OBSOLETE             :  8;
    } B;
} hw_dram_ctl64_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL64 register
 */
#define HW_DRAM_CTL64_ADDR         (REGS_DRAM_BASE + 0x100)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL64           (*(volatile hw_dram_ctl64_t *) HW_DRAM_CTL64_ADDR)
#define HW_DRAM_CTL64_RD()      (HW_DRAM_CTL64.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL64 bitfields
 */
/* --- Register HW_DRAM_CTL64, field OBSOLETE */

#define BP_DRAM_CTL64_OBSOLETE      24
#define BM_DRAM_CTL64_OBSOLETE      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL64_OBSOLETE(v)   ((((reg32_t) v) << 24) & BM_DRAM_CTL64_OBSOLETE)
#else
#define BF_DRAM_CTL64_OBSOLETE(v)   (((v) << 24) & BM_DRAM_CTL64_OBSOLETE)
#endif
/* --- Register HW_DRAM_CTL64, field RSVD2 */

#define BP_DRAM_CTL64_RSVD2      21
#define BM_DRAM_CTL64_RSVD2      0x00E00000

#define BF_DRAM_CTL64_RSVD2(v)   (((v) << 21) & BM_DRAM_CTL64_RSVD2)
/* --- Register HW_DRAM_CTL64, field PORT_CMD_ERROR_ID */

#define BP_DRAM_CTL64_PORT_CMD_ERROR_ID      8
#define BM_DRAM_CTL64_PORT_CMD_ERROR_ID      0x001FFF00

#define BF_DRAM_CTL64_PORT_CMD_ERROR_ID(v)   (((v) << 8) & BM_DRAM_CTL64_PORT_CMD_ERROR_ID)
/* --- Register HW_DRAM_CTL64, field RSVD1 */

#define BP_DRAM_CTL64_RSVD1      4
#define BM_DRAM_CTL64_RSVD1      0x000000F0

#define BF_DRAM_CTL64_RSVD1(v)   (((v) << 4) & BM_DRAM_CTL64_RSVD1)
/* --- Register HW_DRAM_CTL64, field PORT_CMD_ERROR_TYPE */

#define BP_DRAM_CTL64_PORT_CMD_ERROR_TYPE      0
#define BM_DRAM_CTL64_PORT_CMD_ERROR_TYPE      0x0000000F

#define BF_DRAM_CTL64_PORT_CMD_ERROR_TYPE(v)   (((v) << 0) & BM_DRAM_CTL64_PORT_CMD_ERROR_TYPE)


/*
 * HW_DRAM_CTL65 - DRAM Control Register 65
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PORT_DATA_ERROR_TYPE  :  3;
        unsigned RSVD1                 :  5;
        unsigned PORT_DATA_ERROR_ID    : 13;
        unsigned RSVD2                 :  3;
        unsigned OBSOLETE              :  8;
    } B;
} hw_dram_ctl65_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL65 register
 */
#define HW_DRAM_CTL65_ADDR         (REGS_DRAM_BASE + 0x104)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL65           (*(volatile hw_dram_ctl65_t *) HW_DRAM_CTL65_ADDR)
#define HW_DRAM_CTL65_RD()      (HW_DRAM_CTL65.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL65 bitfields
 */
/* --- Register HW_DRAM_CTL65, field OBSOLETE */

#define BP_DRAM_CTL65_OBSOLETE      24
#define BM_DRAM_CTL65_OBSOLETE      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL65_OBSOLETE(v)   ((((reg32_t) v) << 24) & BM_DRAM_CTL65_OBSOLETE)
#else
#define BF_DRAM_CTL65_OBSOLETE(v)   (((v) << 24) & BM_DRAM_CTL65_OBSOLETE)
#endif
/* --- Register HW_DRAM_CTL65, field RSVD2 */

#define BP_DRAM_CTL65_RSVD2      21
#define BM_DRAM_CTL65_RSVD2      0x00E00000

#define BF_DRAM_CTL65_RSVD2(v)   (((v) << 21) & BM_DRAM_CTL65_RSVD2)
/* --- Register HW_DRAM_CTL65, field PORT_DATA_ERROR_ID */

#define BP_DRAM_CTL65_PORT_DATA_ERROR_ID      8
#define BM_DRAM_CTL65_PORT_DATA_ERROR_ID      0x001FFF00

#define BF_DRAM_CTL65_PORT_DATA_ERROR_ID(v)   (((v) << 8) & BM_DRAM_CTL65_PORT_DATA_ERROR_ID)
/* --- Register HW_DRAM_CTL65, field RSVD1 */

#define BP_DRAM_CTL65_RSVD1      3
#define BM_DRAM_CTL65_RSVD1      0x000000F8

#define BF_DRAM_CTL65_RSVD1(v)   (((v) << 3) & BM_DRAM_CTL65_RSVD1)
/* --- Register HW_DRAM_CTL65, field PORT_DATA_ERROR_TYPE */

#define BP_DRAM_CTL65_PORT_DATA_ERROR_TYPE      0
#define BM_DRAM_CTL65_PORT_DATA_ERROR_TYPE      0x00000007

#define BF_DRAM_CTL65_PORT_DATA_ERROR_TYPE(v)   (((v) << 0) & BM_DRAM_CTL65_PORT_DATA_ERROR_TYPE)


/*
 * HW_DRAM_CTL66 - DRAM Control Register 66
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TDFI_CTRLUPD_MAX  : 14;
        unsigned RSVD1             :  2;
        unsigned TDFI_CTRLUPD_MIN  :  4;
        unsigned RSVD2             :  4;
        unsigned OBSOLETE          :  8;
    } B;
} hw_dram_ctl66_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL66 register
 */
#define HW_DRAM_CTL66_ADDR         (REGS_DRAM_BASE + 0x108)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL66           (*(volatile hw_dram_ctl66_t *) HW_DRAM_CTL66_ADDR)
#define HW_DRAM_CTL66_RD()      (HW_DRAM_CTL66.U)
#define HW_DRAM_CTL66_WR(v)     (HW_DRAM_CTL66.U = (v))
#define HW_DRAM_CTL66_SET(v)    (HW_DRAM_CTL66_WR(HW_DRAM_CTL66_RD() |  (v)))
#define HW_DRAM_CTL66_CLR(v)    (HW_DRAM_CTL66_WR(HW_DRAM_CTL66_RD() & ~(v)))
#define HW_DRAM_CTL66_TOG(v)    (HW_DRAM_CTL66_WR(HW_DRAM_CTL66_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL66 bitfields
 */
/* --- Register HW_DRAM_CTL66, field OBSOLETE */

#define BP_DRAM_CTL66_OBSOLETE      24
#define BM_DRAM_CTL66_OBSOLETE      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL66_OBSOLETE(v)   ((((reg32_t) v) << 24) & BM_DRAM_CTL66_OBSOLETE)
#else
#define BF_DRAM_CTL66_OBSOLETE(v)   (((v) << 24) & BM_DRAM_CTL66_OBSOLETE)
#endif
/* --- Register HW_DRAM_CTL66, field RSVD2 */

#define BP_DRAM_CTL66_RSVD2      20
#define BM_DRAM_CTL66_RSVD2      0x00F00000

#define BF_DRAM_CTL66_RSVD2(v)   (((v) << 20) & BM_DRAM_CTL66_RSVD2)
/* --- Register HW_DRAM_CTL66, field TDFI_CTRLUPD_MIN */

#define BP_DRAM_CTL66_TDFI_CTRLUPD_MIN      16
#define BM_DRAM_CTL66_TDFI_CTRLUPD_MIN      0x000F0000

#define BF_DRAM_CTL66_TDFI_CTRLUPD_MIN(v)   (((v) << 16) & BM_DRAM_CTL66_TDFI_CTRLUPD_MIN)
/* --- Register HW_DRAM_CTL66, field RSVD1 */

#define BP_DRAM_CTL66_RSVD1      14
#define BM_DRAM_CTL66_RSVD1      0x0000C000

#define BF_DRAM_CTL66_RSVD1(v)   (((v) << 14) & BM_DRAM_CTL66_RSVD1)
/* --- Register HW_DRAM_CTL66, field TDFI_CTRLUPD_MAX */

#define BP_DRAM_CTL66_TDFI_CTRLUPD_MAX      0
#define BM_DRAM_CTL66_TDFI_CTRLUPD_MAX      0x00003FFF

#define BF_DRAM_CTL66_TDFI_CTRLUPD_MAX(v)   (((v) << 0) & BM_DRAM_CTL66_TDFI_CTRLUPD_MAX)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL66_TDFI_CTRLUPD_MAX(v)   BF_CS1(DRAM_CTL66, TDFI_CTRLUPD_MAX, v)
#endif



/*
 * HW_DRAM_CTL67 - DRAM Control Register 67
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TDFI_CTRL_DELAY        :  4;
        unsigned RSVD1                  :  4;
        unsigned DRAM_CLK_ENABLE        :  4;
        unsigned RSVD2                  :  4;
        unsigned TDFI_DRAM_CLK_DISABLE  :  3;
        unsigned RSVD3                  :  5;
        unsigned TDFI_DRAM_CLK_ENABLE   :  4;
        unsigned RSVD4                  :  4;
    } B;
} hw_dram_ctl67_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL67 register
 */
#define HW_DRAM_CTL67_ADDR         (REGS_DRAM_BASE + 0x10c)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL67           (*(volatile hw_dram_ctl67_t *) HW_DRAM_CTL67_ADDR)
#define HW_DRAM_CTL67_RD()      (HW_DRAM_CTL67.U)
#define HW_DRAM_CTL67_WR(v)     (HW_DRAM_CTL67.U = (v))
#define HW_DRAM_CTL67_SET(v)    (HW_DRAM_CTL67_WR(HW_DRAM_CTL67_RD() |  (v)))
#define HW_DRAM_CTL67_CLR(v)    (HW_DRAM_CTL67_WR(HW_DRAM_CTL67_RD() & ~(v)))
#define HW_DRAM_CTL67_TOG(v)    (HW_DRAM_CTL67_WR(HW_DRAM_CTL67_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL67 bitfields
 */
/* --- Register HW_DRAM_CTL67, field RSVD4 */

#define BP_DRAM_CTL67_RSVD4      28
#define BM_DRAM_CTL67_RSVD4      0xF0000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL67_RSVD4(v)   ((((reg32_t) v) << 28) & BM_DRAM_CTL67_RSVD4)
#else
#define BF_DRAM_CTL67_RSVD4(v)   (((v) << 28) & BM_DRAM_CTL67_RSVD4)
#endif
/* --- Register HW_DRAM_CTL67, field TDFI_DRAM_CLK_ENABLE */

#define BP_DRAM_CTL67_TDFI_DRAM_CLK_ENABLE      24
#define BM_DRAM_CTL67_TDFI_DRAM_CLK_ENABLE      0x0F000000

#define BF_DRAM_CTL67_TDFI_DRAM_CLK_ENABLE(v)   (((v) << 24) & BM_DRAM_CTL67_TDFI_DRAM_CLK_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL67_TDFI_DRAM_CLK_ENABLE(v)   BF_CS1(DRAM_CTL67, TDFI_DRAM_CLK_ENABLE, v)
#endif

/* --- Register HW_DRAM_CTL67, field RSVD3 */

#define BP_DRAM_CTL67_RSVD3      19
#define BM_DRAM_CTL67_RSVD3      0x00F80000

#define BF_DRAM_CTL67_RSVD3(v)   (((v) << 19) & BM_DRAM_CTL67_RSVD3)
/* --- Register HW_DRAM_CTL67, field TDFI_DRAM_CLK_DISABLE */

#define BP_DRAM_CTL67_TDFI_DRAM_CLK_DISABLE      16
#define BM_DRAM_CTL67_TDFI_DRAM_CLK_DISABLE      0x00070000

#define BF_DRAM_CTL67_TDFI_DRAM_CLK_DISABLE(v)   (((v) << 16) & BM_DRAM_CTL67_TDFI_DRAM_CLK_DISABLE)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL67_TDFI_DRAM_CLK_DISABLE(v)   BF_CS1(DRAM_CTL67, TDFI_DRAM_CLK_DISABLE, v)
#endif

/* --- Register HW_DRAM_CTL67, field RSVD2 */

#define BP_DRAM_CTL67_RSVD2      12
#define BM_DRAM_CTL67_RSVD2      0x0000F000

#define BF_DRAM_CTL67_RSVD2(v)   (((v) << 12) & BM_DRAM_CTL67_RSVD2)
/* --- Register HW_DRAM_CTL67, field DRAM_CLK_ENABLE */

#define BP_DRAM_CTL67_DRAM_CLK_ENABLE      8
#define BM_DRAM_CTL67_DRAM_CLK_ENABLE      0x00000F00

#define BF_DRAM_CTL67_DRAM_CLK_ENABLE(v)   (((v) << 8) & BM_DRAM_CTL67_DRAM_CLK_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL67_DRAM_CLK_ENABLE(v)   BF_CS1(DRAM_CTL67, DRAM_CLK_ENABLE, v)
#endif

/* --- Register HW_DRAM_CTL67, field RSVD1 */

#define BP_DRAM_CTL67_RSVD1      4
#define BM_DRAM_CTL67_RSVD1      0x000000F0

#define BF_DRAM_CTL67_RSVD1(v)   (((v) << 4) & BM_DRAM_CTL67_RSVD1)
/* --- Register HW_DRAM_CTL67, field TDFI_CTRL_DELAY */

#define BP_DRAM_CTL67_TDFI_CTRL_DELAY      0
#define BM_DRAM_CTL67_TDFI_CTRL_DELAY      0x0000000F

#define BF_DRAM_CTL67_TDFI_CTRL_DELAY(v)   (((v) << 0) & BM_DRAM_CTL67_TDFI_CTRL_DELAY)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL67_TDFI_CTRL_DELAY(v)   BF_CS1(DRAM_CTL67, TDFI_CTRL_DELAY, v)
#endif



/*
 * HW_DRAM_CTL68 - DRAM Control Register 68
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TDFI_PHYUPD_RESP   : 14;
        unsigned RSVD1              :  2;
        unsigned TDFI_PHYUPD_TYPE0  : 14;
        unsigned RSVD2              :  2;
    } B;
} hw_dram_ctl68_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL68 register
 */
#define HW_DRAM_CTL68_ADDR         (REGS_DRAM_BASE + 0x110)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL68           (*(volatile hw_dram_ctl68_t *) HW_DRAM_CTL68_ADDR)
#define HW_DRAM_CTL68_RD()      (HW_DRAM_CTL68.U)
#define HW_DRAM_CTL68_WR(v)     (HW_DRAM_CTL68.U = (v))
#define HW_DRAM_CTL68_SET(v)    (HW_DRAM_CTL68_WR(HW_DRAM_CTL68_RD() |  (v)))
#define HW_DRAM_CTL68_CLR(v)    (HW_DRAM_CTL68_WR(HW_DRAM_CTL68_RD() & ~(v)))
#define HW_DRAM_CTL68_TOG(v)    (HW_DRAM_CTL68_WR(HW_DRAM_CTL68_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL68 bitfields
 */
/* --- Register HW_DRAM_CTL68, field RSVD2 */

#define BP_DRAM_CTL68_RSVD2      30
#define BM_DRAM_CTL68_RSVD2      0xC0000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL68_RSVD2(v)   ((((reg32_t) v) << 30) & BM_DRAM_CTL68_RSVD2)
#else
#define BF_DRAM_CTL68_RSVD2(v)   (((v) << 30) & BM_DRAM_CTL68_RSVD2)
#endif
/* --- Register HW_DRAM_CTL68, field TDFI_PHYUPD_TYPE0 */

#define BP_DRAM_CTL68_TDFI_PHYUPD_TYPE0      16
#define BM_DRAM_CTL68_TDFI_PHYUPD_TYPE0      0x3FFF0000

#define BF_DRAM_CTL68_TDFI_PHYUPD_TYPE0(v)   (((v) << 16) & BM_DRAM_CTL68_TDFI_PHYUPD_TYPE0)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL68_TDFI_PHYUPD_TYPE0(v)   BF_CS1(DRAM_CTL68, TDFI_PHYUPD_TYPE0, v)
#endif

/* --- Register HW_DRAM_CTL68, field RSVD1 */

#define BP_DRAM_CTL68_RSVD1      14
#define BM_DRAM_CTL68_RSVD1      0x0000C000

#define BF_DRAM_CTL68_RSVD1(v)   (((v) << 14) & BM_DRAM_CTL68_RSVD1)
/* --- Register HW_DRAM_CTL68, field TDFI_PHYUPD_RESP */

#define BP_DRAM_CTL68_TDFI_PHYUPD_RESP      0
#define BM_DRAM_CTL68_TDFI_PHYUPD_RESP      0x00003FFF

#define BF_DRAM_CTL68_TDFI_PHYUPD_RESP(v)   (((v) << 0) & BM_DRAM_CTL68_TDFI_PHYUPD_RESP)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL68_TDFI_PHYUPD_RESP(v)   BF_CS1(DRAM_CTL68, TDFI_PHYUPD_RESP, v)
#endif



/*
 * HW_DRAM_CTL69 - DRAM Control Register 69
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TDFI_PHY_WRLAT       :  4;
        unsigned RSVD1                :  4;
        unsigned TDFI_PHY_WRLAT_BASE  :  4;
        unsigned RSVD2                :  4;
        unsigned OBSOLETE             : 16;
    } B;
} hw_dram_ctl69_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL69 register
 */
#define HW_DRAM_CTL69_ADDR         (REGS_DRAM_BASE + 0x114)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL69           (*(volatile hw_dram_ctl69_t *) HW_DRAM_CTL69_ADDR)
#define HW_DRAM_CTL69_RD()      (HW_DRAM_CTL69.U)
#define HW_DRAM_CTL69_WR(v)     (HW_DRAM_CTL69.U = (v))
#define HW_DRAM_CTL69_SET(v)    (HW_DRAM_CTL69_WR(HW_DRAM_CTL69_RD() |  (v)))
#define HW_DRAM_CTL69_CLR(v)    (HW_DRAM_CTL69_WR(HW_DRAM_CTL69_RD() & ~(v)))
#define HW_DRAM_CTL69_TOG(v)    (HW_DRAM_CTL69_WR(HW_DRAM_CTL69_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL69 bitfields
 */
/* --- Register HW_DRAM_CTL69, field OBSOLETE */

#define BP_DRAM_CTL69_OBSOLETE      16
#define BM_DRAM_CTL69_OBSOLETE      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL69_OBSOLETE(v)   ((((reg32_t) v) << 16) & BM_DRAM_CTL69_OBSOLETE)
#else
#define BF_DRAM_CTL69_OBSOLETE(v)   (((v) << 16) & BM_DRAM_CTL69_OBSOLETE)
#endif
/* --- Register HW_DRAM_CTL69, field RSVD2 */

#define BP_DRAM_CTL69_RSVD2      12
#define BM_DRAM_CTL69_RSVD2      0x0000F000

#define BF_DRAM_CTL69_RSVD2(v)   (((v) << 12) & BM_DRAM_CTL69_RSVD2)
/* --- Register HW_DRAM_CTL69, field TDFI_PHY_WRLAT_BASE */

#define BP_DRAM_CTL69_TDFI_PHY_WRLAT_BASE      8
#define BM_DRAM_CTL69_TDFI_PHY_WRLAT_BASE      0x00000F00

#define BF_DRAM_CTL69_TDFI_PHY_WRLAT_BASE(v)   (((v) << 8) & BM_DRAM_CTL69_TDFI_PHY_WRLAT_BASE)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL69_TDFI_PHY_WRLAT_BASE(v)   BF_CS1(DRAM_CTL69, TDFI_PHY_WRLAT_BASE, v)
#endif

/* --- Register HW_DRAM_CTL69, field RSVD1 */

#define BP_DRAM_CTL69_RSVD1      4
#define BM_DRAM_CTL69_RSVD1      0x000000F0

#define BF_DRAM_CTL69_RSVD1(v)   (((v) << 4) & BM_DRAM_CTL69_RSVD1)
/* --- Register HW_DRAM_CTL69, field TDFI_PHY_WRLAT */

#define BP_DRAM_CTL69_TDFI_PHY_WRLAT      0
#define BM_DRAM_CTL69_TDFI_PHY_WRLAT      0x0000000F

#define BF_DRAM_CTL69_TDFI_PHY_WRLAT(v)   (((v) << 0) & BM_DRAM_CTL69_TDFI_PHY_WRLAT)


/*
 * HW_DRAM_CTL70 - DRAM Control Register 70
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TDFI_PHY_RDLAT       :  4;
        unsigned RSVD1                :  4;
        unsigned TDFI_RDDATA_EN       :  4;
        unsigned RSVD2                :  4;
        unsigned TDFI_RDDATA_EN_BASE  :  4;
        unsigned RSVD3                :  4;
        unsigned OBSOLETE             :  8;
    } B;
} hw_dram_ctl70_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL70 register
 */
#define HW_DRAM_CTL70_ADDR         (REGS_DRAM_BASE + 0x118)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL70           (*(volatile hw_dram_ctl70_t *) HW_DRAM_CTL70_ADDR)
#define HW_DRAM_CTL70_RD()      (HW_DRAM_CTL70.U)
#define HW_DRAM_CTL70_WR(v)     (HW_DRAM_CTL70.U = (v))
#define HW_DRAM_CTL70_SET(v)    (HW_DRAM_CTL70_WR(HW_DRAM_CTL70_RD() |  (v)))
#define HW_DRAM_CTL70_CLR(v)    (HW_DRAM_CTL70_WR(HW_DRAM_CTL70_RD() & ~(v)))
#define HW_DRAM_CTL70_TOG(v)    (HW_DRAM_CTL70_WR(HW_DRAM_CTL70_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL70 bitfields
 */
/* --- Register HW_DRAM_CTL70, field OBSOLETE */

#define BP_DRAM_CTL70_OBSOLETE      24
#define BM_DRAM_CTL70_OBSOLETE      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL70_OBSOLETE(v)   ((((reg32_t) v) << 24) & BM_DRAM_CTL70_OBSOLETE)
#else
#define BF_DRAM_CTL70_OBSOLETE(v)   (((v) << 24) & BM_DRAM_CTL70_OBSOLETE)
#endif
/* --- Register HW_DRAM_CTL70, field RSVD3 */

#define BP_DRAM_CTL70_RSVD3      20
#define BM_DRAM_CTL70_RSVD3      0x00F00000

#define BF_DRAM_CTL70_RSVD3(v)   (((v) << 20) & BM_DRAM_CTL70_RSVD3)
/* --- Register HW_DRAM_CTL70, field TDFI_RDDATA_EN_BASE */

#define BP_DRAM_CTL70_TDFI_RDDATA_EN_BASE      16
#define BM_DRAM_CTL70_TDFI_RDDATA_EN_BASE      0x000F0000

#define BF_DRAM_CTL70_TDFI_RDDATA_EN_BASE(v)   (((v) << 16) & BM_DRAM_CTL70_TDFI_RDDATA_EN_BASE)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL70_TDFI_RDDATA_EN_BASE(v)   BF_CS1(DRAM_CTL70, TDFI_RDDATA_EN_BASE, v)
#endif

/* --- Register HW_DRAM_CTL70, field RSVD2 */

#define BP_DRAM_CTL70_RSVD2      12
#define BM_DRAM_CTL70_RSVD2      0x0000F000

#define BF_DRAM_CTL70_RSVD2(v)   (((v) << 12) & BM_DRAM_CTL70_RSVD2)
/* --- Register HW_DRAM_CTL70, field TDFI_RDDATA_EN */

#define BP_DRAM_CTL70_TDFI_RDDATA_EN      8
#define BM_DRAM_CTL70_TDFI_RDDATA_EN      0x00000F00

#define BF_DRAM_CTL70_TDFI_RDDATA_EN(v)   (((v) << 8) & BM_DRAM_CTL70_TDFI_RDDATA_EN)
/* --- Register HW_DRAM_CTL70, field RSVD1 */

#define BP_DRAM_CTL70_RSVD1      4
#define BM_DRAM_CTL70_RSVD1      0x000000F0

#define BF_DRAM_CTL70_RSVD1(v)   (((v) << 4) & BM_DRAM_CTL70_RSVD1)
/* --- Register HW_DRAM_CTL70, field TDFI_PHY_RDLAT */

#define BP_DRAM_CTL70_TDFI_PHY_RDLAT      0
#define BM_DRAM_CTL70_TDFI_PHY_RDLAT      0x0000000F

#define BF_DRAM_CTL70_TDFI_PHY_RDLAT(v)   (((v) << 0) & BM_DRAM_CTL70_TDFI_PHY_RDLAT)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL70_TDFI_PHY_RDLAT(v)   BF_CS1(DRAM_CTL70, TDFI_PHY_RDLAT, v)
#endif



/*
 * HW_DRAM_CTL71 - DRAM Control Register 71
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PHY_CTRL_REG_0_0  : 32;
    } B;
} hw_dram_ctl71_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL71 register
 */
#define HW_DRAM_CTL71_ADDR         (REGS_DRAM_BASE + 0x11c)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL71           (*(volatile hw_dram_ctl71_t *) HW_DRAM_CTL71_ADDR)
#define HW_DRAM_CTL71_RD()      (HW_DRAM_CTL71.U)
#define HW_DRAM_CTL71_WR(v)     (HW_DRAM_CTL71.U = (v))
#define HW_DRAM_CTL71_SET(v)    (HW_DRAM_CTL71_WR(HW_DRAM_CTL71_RD() |  (v)))
#define HW_DRAM_CTL71_CLR(v)    (HW_DRAM_CTL71_WR(HW_DRAM_CTL71_RD() & ~(v)))
#define HW_DRAM_CTL71_TOG(v)    (HW_DRAM_CTL71_WR(HW_DRAM_CTL71_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL71 bitfields
 */
/* --- Register HW_DRAM_CTL71, field PHY_CTRL_REG_0_0 */

#define BP_DRAM_CTL71_PHY_CTRL_REG_0_0      0
#define BM_DRAM_CTL71_PHY_CTRL_REG_0_0      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL71_PHY_CTRL_REG_0_0(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL71_PHY_CTRL_REG_0_0(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL71_PHY_CTRL_REG_0_0(v)   (HW_DRAM_CTL71.B.PHY_CTRL_REG_0_0 = (v))
#endif



/*
 * HW_DRAM_CTL72 - DRAM Control Register 72
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PHY_CTRL_REG_0_1  : 32;
    } B;
} hw_dram_ctl72_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL72 register
 */
#define HW_DRAM_CTL72_ADDR         (REGS_DRAM_BASE + 0x120)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL72           (*(volatile hw_dram_ctl72_t *) HW_DRAM_CTL72_ADDR)
#define HW_DRAM_CTL72_RD()      (HW_DRAM_CTL72.U)
#define HW_DRAM_CTL72_WR(v)     (HW_DRAM_CTL72.U = (v))
#define HW_DRAM_CTL72_SET(v)    (HW_DRAM_CTL72_WR(HW_DRAM_CTL72_RD() |  (v)))
#define HW_DRAM_CTL72_CLR(v)    (HW_DRAM_CTL72_WR(HW_DRAM_CTL72_RD() & ~(v)))
#define HW_DRAM_CTL72_TOG(v)    (HW_DRAM_CTL72_WR(HW_DRAM_CTL72_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL72 bitfields
 */
/* --- Register HW_DRAM_CTL72, field PHY_CTRL_REG_0_1 */

#define BP_DRAM_CTL72_PHY_CTRL_REG_0_1      0
#define BM_DRAM_CTL72_PHY_CTRL_REG_0_1      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL72_PHY_CTRL_REG_0_1(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL72_PHY_CTRL_REG_0_1(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL72_PHY_CTRL_REG_0_1(v)   (HW_DRAM_CTL72.B.PHY_CTRL_REG_0_1 = (v))
#endif



/*
 * HW_DRAM_CTL73 - DRAM Control Register 73
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PHY_CTRL_REG_0_2  : 32;
    } B;
} hw_dram_ctl73_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL73 register
 */
#define HW_DRAM_CTL73_ADDR         (REGS_DRAM_BASE + 0x124)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL73           (*(volatile hw_dram_ctl73_t *) HW_DRAM_CTL73_ADDR)
#define HW_DRAM_CTL73_RD()      (HW_DRAM_CTL73.U)
#define HW_DRAM_CTL73_WR(v)     (HW_DRAM_CTL73.U = (v))
#define HW_DRAM_CTL73_SET(v)    (HW_DRAM_CTL73_WR(HW_DRAM_CTL73_RD() |  (v)))
#define HW_DRAM_CTL73_CLR(v)    (HW_DRAM_CTL73_WR(HW_DRAM_CTL73_RD() & ~(v)))
#define HW_DRAM_CTL73_TOG(v)    (HW_DRAM_CTL73_WR(HW_DRAM_CTL73_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL73 bitfields
 */
/* --- Register HW_DRAM_CTL73, field PHY_CTRL_REG_0_2 */

#define BP_DRAM_CTL73_PHY_CTRL_REG_0_2      0
#define BM_DRAM_CTL73_PHY_CTRL_REG_0_2      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL73_PHY_CTRL_REG_0_2(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL73_PHY_CTRL_REG_0_2(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL73_PHY_CTRL_REG_0_2(v)   (HW_DRAM_CTL73.B.PHY_CTRL_REG_0_2 = (v))
#endif



/*
 * HW_DRAM_CTL74 - DRAM Control Register 74
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PHY_CTRL_REG_0_3  : 32;
    } B;
} hw_dram_ctl74_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL74 register
 */
#define HW_DRAM_CTL74_ADDR         (REGS_DRAM_BASE + 0x128)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL74           (*(volatile hw_dram_ctl74_t *) HW_DRAM_CTL74_ADDR)
#define HW_DRAM_CTL74_RD()      (HW_DRAM_CTL74.U)
#define HW_DRAM_CTL74_WR(v)     (HW_DRAM_CTL74.U = (v))
#define HW_DRAM_CTL74_SET(v)    (HW_DRAM_CTL74_WR(HW_DRAM_CTL74_RD() |  (v)))
#define HW_DRAM_CTL74_CLR(v)    (HW_DRAM_CTL74_WR(HW_DRAM_CTL74_RD() & ~(v)))
#define HW_DRAM_CTL74_TOG(v)    (HW_DRAM_CTL74_WR(HW_DRAM_CTL74_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL74 bitfields
 */
/* --- Register HW_DRAM_CTL74, field PHY_CTRL_REG_0_3 */

#define BP_DRAM_CTL74_PHY_CTRL_REG_0_3      0
#define BM_DRAM_CTL74_PHY_CTRL_REG_0_3      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL74_PHY_CTRL_REG_0_3(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL74_PHY_CTRL_REG_0_3(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL74_PHY_CTRL_REG_0_3(v)   (HW_DRAM_CTL74.B.PHY_CTRL_REG_0_3 = (v))
#endif



/*
 * HW_DRAM_CTL75 - DRAM Control Register 75
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PHY_CTRL_REG_1_0  : 32;
    } B;
} hw_dram_ctl75_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL75 register
 */
#define HW_DRAM_CTL75_ADDR         (REGS_DRAM_BASE + 0x12c)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL75           (*(volatile hw_dram_ctl75_t *) HW_DRAM_CTL75_ADDR)
#define HW_DRAM_CTL75_RD()      (HW_DRAM_CTL75.U)
#define HW_DRAM_CTL75_WR(v)     (HW_DRAM_CTL75.U = (v))
#define HW_DRAM_CTL75_SET(v)    (HW_DRAM_CTL75_WR(HW_DRAM_CTL75_RD() |  (v)))
#define HW_DRAM_CTL75_CLR(v)    (HW_DRAM_CTL75_WR(HW_DRAM_CTL75_RD() & ~(v)))
#define HW_DRAM_CTL75_TOG(v)    (HW_DRAM_CTL75_WR(HW_DRAM_CTL75_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL75 bitfields
 */
/* --- Register HW_DRAM_CTL75, field PHY_CTRL_REG_1_0 */

#define BP_DRAM_CTL75_PHY_CTRL_REG_1_0      0
#define BM_DRAM_CTL75_PHY_CTRL_REG_1_0      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL75_PHY_CTRL_REG_1_0(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL75_PHY_CTRL_REG_1_0(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL75_PHY_CTRL_REG_1_0(v)   (HW_DRAM_CTL75.B.PHY_CTRL_REG_1_0 = (v))
#endif



/*
 * HW_DRAM_CTL76 - DRAM Control Register 76
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PHY_CTRL_REG_1_1  : 32;
    } B;
} hw_dram_ctl76_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL76 register
 */
#define HW_DRAM_CTL76_ADDR         (REGS_DRAM_BASE + 0x130)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL76           (*(volatile hw_dram_ctl76_t *) HW_DRAM_CTL76_ADDR)
#define HW_DRAM_CTL76_RD()      (HW_DRAM_CTL76.U)
#define HW_DRAM_CTL76_WR(v)     (HW_DRAM_CTL76.U = (v))
#define HW_DRAM_CTL76_SET(v)    (HW_DRAM_CTL76_WR(HW_DRAM_CTL76_RD() |  (v)))
#define HW_DRAM_CTL76_CLR(v)    (HW_DRAM_CTL76_WR(HW_DRAM_CTL76_RD() & ~(v)))
#define HW_DRAM_CTL76_TOG(v)    (HW_DRAM_CTL76_WR(HW_DRAM_CTL76_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL76 bitfields
 */
/* --- Register HW_DRAM_CTL76, field PHY_CTRL_REG_1_1 */

#define BP_DRAM_CTL76_PHY_CTRL_REG_1_1      0
#define BM_DRAM_CTL76_PHY_CTRL_REG_1_1      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL76_PHY_CTRL_REG_1_1(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL76_PHY_CTRL_REG_1_1(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL76_PHY_CTRL_REG_1_1(v)   (HW_DRAM_CTL76.B.PHY_CTRL_REG_1_1 = (v))
#endif



/*
 * HW_DRAM_CTL77 - DRAM Control Register 77
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PHY_CTRL_REG_1_2  : 32;
    } B;
} hw_dram_ctl77_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL77 register
 */
#define HW_DRAM_CTL77_ADDR         (REGS_DRAM_BASE + 0x134)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL77           (*(volatile hw_dram_ctl77_t *) HW_DRAM_CTL77_ADDR)
#define HW_DRAM_CTL77_RD()      (HW_DRAM_CTL77.U)
#define HW_DRAM_CTL77_WR(v)     (HW_DRAM_CTL77.U = (v))
#define HW_DRAM_CTL77_SET(v)    (HW_DRAM_CTL77_WR(HW_DRAM_CTL77_RD() |  (v)))
#define HW_DRAM_CTL77_CLR(v)    (HW_DRAM_CTL77_WR(HW_DRAM_CTL77_RD() & ~(v)))
#define HW_DRAM_CTL77_TOG(v)    (HW_DRAM_CTL77_WR(HW_DRAM_CTL77_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL77 bitfields
 */
/* --- Register HW_DRAM_CTL77, field PHY_CTRL_REG_1_2 */

#define BP_DRAM_CTL77_PHY_CTRL_REG_1_2      0
#define BM_DRAM_CTL77_PHY_CTRL_REG_1_2      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL77_PHY_CTRL_REG_1_2(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL77_PHY_CTRL_REG_1_2(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL77_PHY_CTRL_REG_1_2(v)   (HW_DRAM_CTL77.B.PHY_CTRL_REG_1_2 = (v))
#endif



/*
 * HW_DRAM_CTL78 - DRAM Control Register 78
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PHY_CTRL_REG_1_3  : 32;
    } B;
} hw_dram_ctl78_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL78 register
 */
#define HW_DRAM_CTL78_ADDR         (REGS_DRAM_BASE + 0x138)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL78           (*(volatile hw_dram_ctl78_t *) HW_DRAM_CTL78_ADDR)
#define HW_DRAM_CTL78_RD()      (HW_DRAM_CTL78.U)
#define HW_DRAM_CTL78_WR(v)     (HW_DRAM_CTL78.U = (v))
#define HW_DRAM_CTL78_SET(v)    (HW_DRAM_CTL78_WR(HW_DRAM_CTL78_RD() |  (v)))
#define HW_DRAM_CTL78_CLR(v)    (HW_DRAM_CTL78_WR(HW_DRAM_CTL78_RD() & ~(v)))
#define HW_DRAM_CTL78_TOG(v)    (HW_DRAM_CTL78_WR(HW_DRAM_CTL78_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL78 bitfields
 */
/* --- Register HW_DRAM_CTL78, field PHY_CTRL_REG_1_3 */

#define BP_DRAM_CTL78_PHY_CTRL_REG_1_3      0
#define BM_DRAM_CTL78_PHY_CTRL_REG_1_3      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL78_PHY_CTRL_REG_1_3(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL78_PHY_CTRL_REG_1_3(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL78_PHY_CTRL_REG_1_3(v)   (HW_DRAM_CTL78.B.PHY_CTRL_REG_1_3 = (v))
#endif



/*
 * HW_DRAM_CTL79 - DRAM Control Register 79
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PHY_CTRL_REG_2  : 32;
    } B;
} hw_dram_ctl79_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL79 register
 */
#define HW_DRAM_CTL79_ADDR         (REGS_DRAM_BASE + 0x13c)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL79           (*(volatile hw_dram_ctl79_t *) HW_DRAM_CTL79_ADDR)
#define HW_DRAM_CTL79_RD()      (HW_DRAM_CTL79.U)
#define HW_DRAM_CTL79_WR(v)     (HW_DRAM_CTL79.U = (v))
#define HW_DRAM_CTL79_SET(v)    (HW_DRAM_CTL79_WR(HW_DRAM_CTL79_RD() |  (v)))
#define HW_DRAM_CTL79_CLR(v)    (HW_DRAM_CTL79_WR(HW_DRAM_CTL79_RD() & ~(v)))
#define HW_DRAM_CTL79_TOG(v)    (HW_DRAM_CTL79_WR(HW_DRAM_CTL79_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL79 bitfields
 */
/* --- Register HW_DRAM_CTL79, field PHY_CTRL_REG_2 */

#define BP_DRAM_CTL79_PHY_CTRL_REG_2      0
#define BM_DRAM_CTL79_PHY_CTRL_REG_2      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL79_PHY_CTRL_REG_2(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL79_PHY_CTRL_REG_2(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL79_PHY_CTRL_REG_2(v)   (HW_DRAM_CTL79.B.PHY_CTRL_REG_2 = (v))
#endif



/*
 * HW_DRAM_CTL80 - DRAM Control Register 80
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DFT_CTRL_REG  : 32;
    } B;
} hw_dram_ctl80_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL80 register
 */
#define HW_DRAM_CTL80_ADDR         (REGS_DRAM_BASE + 0x140)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL80           (*(volatile hw_dram_ctl80_t *) HW_DRAM_CTL80_ADDR)
#define HW_DRAM_CTL80_RD()      (HW_DRAM_CTL80.U)
#define HW_DRAM_CTL80_WR(v)     (HW_DRAM_CTL80.U = (v))
#define HW_DRAM_CTL80_SET(v)    (HW_DRAM_CTL80_WR(HW_DRAM_CTL80_RD() |  (v)))
#define HW_DRAM_CTL80_CLR(v)    (HW_DRAM_CTL80_WR(HW_DRAM_CTL80_RD() & ~(v)))
#define HW_DRAM_CTL80_TOG(v)    (HW_DRAM_CTL80_WR(HW_DRAM_CTL80_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL80 bitfields
 */
/* --- Register HW_DRAM_CTL80, field DFT_CTRL_REG */

#define BP_DRAM_CTL80_DFT_CTRL_REG      0
#define BM_DRAM_CTL80_DFT_CTRL_REG      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL80_DFT_CTRL_REG(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL80_DFT_CTRL_REG(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL80_DFT_CTRL_REG(v)   (HW_DRAM_CTL80.B.DFT_CTRL_REG = (v))
#endif



/*
 * HW_DRAM_CTL81 - DRAM Control Register 81
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned OCD_ADJUST_PDN_CS_0  :  5;
        unsigned RSVD1                :  3;
        unsigned OCD_ADJUST_PUP_CS_0  :  5;
        unsigned RSVD2                :  3;
        unsigned OBSOLETE             : 16;
    } B;
} hw_dram_ctl81_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL81 register
 */
#define HW_DRAM_CTL81_ADDR         (REGS_DRAM_BASE + 0x144)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL81           (*(volatile hw_dram_ctl81_t *) HW_DRAM_CTL81_ADDR)
#define HW_DRAM_CTL81_RD()      (HW_DRAM_CTL81.U)
#define HW_DRAM_CTL81_WR(v)     (HW_DRAM_CTL81.U = (v))
#define HW_DRAM_CTL81_SET(v)    (HW_DRAM_CTL81_WR(HW_DRAM_CTL81_RD() |  (v)))
#define HW_DRAM_CTL81_CLR(v)    (HW_DRAM_CTL81_WR(HW_DRAM_CTL81_RD() & ~(v)))
#define HW_DRAM_CTL81_TOG(v)    (HW_DRAM_CTL81_WR(HW_DRAM_CTL81_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL81 bitfields
 */
/* --- Register HW_DRAM_CTL81, field OBSOLETE */

#define BP_DRAM_CTL81_OBSOLETE      16
#define BM_DRAM_CTL81_OBSOLETE      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL81_OBSOLETE(v)   ((((reg32_t) v) << 16) & BM_DRAM_CTL81_OBSOLETE)
#else
#define BF_DRAM_CTL81_OBSOLETE(v)   (((v) << 16) & BM_DRAM_CTL81_OBSOLETE)
#endif
/* --- Register HW_DRAM_CTL81, field RSVD2 */

#define BP_DRAM_CTL81_RSVD2      13
#define BM_DRAM_CTL81_RSVD2      0x0000E000

#define BF_DRAM_CTL81_RSVD2(v)   (((v) << 13) & BM_DRAM_CTL81_RSVD2)
/* --- Register HW_DRAM_CTL81, field OCD_ADJUST_PUP_CS_0 */

#define BP_DRAM_CTL81_OCD_ADJUST_PUP_CS_0      8
#define BM_DRAM_CTL81_OCD_ADJUST_PUP_CS_0      0x00001F00

#define BF_DRAM_CTL81_OCD_ADJUST_PUP_CS_0(v)   (((v) << 8) & BM_DRAM_CTL81_OCD_ADJUST_PUP_CS_0)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL81_OCD_ADJUST_PUP_CS_0(v)   BF_CS1(DRAM_CTL81, OCD_ADJUST_PUP_CS_0, v)
#endif

/* --- Register HW_DRAM_CTL81, field RSVD1 */

#define BP_DRAM_CTL81_RSVD1      5
#define BM_DRAM_CTL81_RSVD1      0x000000E0

#define BF_DRAM_CTL81_RSVD1(v)   (((v) << 5) & BM_DRAM_CTL81_RSVD1)
/* --- Register HW_DRAM_CTL81, field OCD_ADJUST_PDN_CS_0 */

#define BP_DRAM_CTL81_OCD_ADJUST_PDN_CS_0      0
#define BM_DRAM_CTL81_OCD_ADJUST_PDN_CS_0      0x0000001F

#define BF_DRAM_CTL81_OCD_ADJUST_PDN_CS_0(v)   (((v) << 0) & BM_DRAM_CTL81_OCD_ADJUST_PDN_CS_0)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL81_OCD_ADJUST_PDN_CS_0(v)   BF_CS1(DRAM_CTL81, OCD_ADJUST_PDN_CS_0, v)
#endif



/*
 * HW_DRAM_CTL82 - DRAM Control Register 82
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned OBSOLETE    : 24;
        unsigned ODT_ALT_EN  :  1;
        unsigned RSVD1       :  7;
    } B;
} hw_dram_ctl82_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL82 register
 */
#define HW_DRAM_CTL82_ADDR         (REGS_DRAM_BASE + 0x148)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL82           (*(volatile hw_dram_ctl82_t *) HW_DRAM_CTL82_ADDR)
#define HW_DRAM_CTL82_RD()      (HW_DRAM_CTL82.U)
#define HW_DRAM_CTL82_WR(v)     (HW_DRAM_CTL82.U = (v))
#define HW_DRAM_CTL82_SET(v)    (HW_DRAM_CTL82_WR(HW_DRAM_CTL82_RD() |  (v)))
#define HW_DRAM_CTL82_CLR(v)    (HW_DRAM_CTL82_WR(HW_DRAM_CTL82_RD() & ~(v)))
#define HW_DRAM_CTL82_TOG(v)    (HW_DRAM_CTL82_WR(HW_DRAM_CTL82_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL82 bitfields
 */
/* --- Register HW_DRAM_CTL82, field RSVD1 */

#define BP_DRAM_CTL82_RSVD1      25
#define BM_DRAM_CTL82_RSVD1      0xFE000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL82_RSVD1(v)   ((((reg32_t) v) << 25) & BM_DRAM_CTL82_RSVD1)
#else
#define BF_DRAM_CTL82_RSVD1(v)   (((v) << 25) & BM_DRAM_CTL82_RSVD1)
#endif
/* --- Register HW_DRAM_CTL82, field ODT_ALT_EN */

#define BP_DRAM_CTL82_ODT_ALT_EN      24
#define BM_DRAM_CTL82_ODT_ALT_EN      0x01000000

#define BF_DRAM_CTL82_ODT_ALT_EN(v)   (((v) << 24) & BM_DRAM_CTL82_ODT_ALT_EN)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL82_ODT_ALT_EN(v)   BF_CS1(DRAM_CTL82, ODT_ALT_EN, v)
#endif

/* --- Register HW_DRAM_CTL82, field OBSOLETE */

#define BP_DRAM_CTL82_OBSOLETE      0
#define BM_DRAM_CTL82_OBSOLETE      0x00FFFFFF

#define BF_DRAM_CTL82_OBSOLETE(v)   (((v) << 0) & BM_DRAM_CTL82_OBSOLETE)


/*
 * HW_DRAM_CTL83 - DRAM Control Register 83
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ODT_RD_MAP_CS0  :  4;
        unsigned RSVD1           :  4;
        unsigned ODT_RD_MAP_CS1  :  4;
        unsigned RSVD2           :  4;
        unsigned ODT_RD_MAP_CS2  :  4;
        unsigned RSVD3           :  4;
        unsigned ODT_RD_MAP_CS3  :  4;
        unsigned RSVD4           :  4;
    } B;
} hw_dram_ctl83_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL83 register
 */
#define HW_DRAM_CTL83_ADDR         (REGS_DRAM_BASE + 0x14c)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL83           (*(volatile hw_dram_ctl83_t *) HW_DRAM_CTL83_ADDR)
#define HW_DRAM_CTL83_RD()      (HW_DRAM_CTL83.U)
#define HW_DRAM_CTL83_WR(v)     (HW_DRAM_CTL83.U = (v))
#define HW_DRAM_CTL83_SET(v)    (HW_DRAM_CTL83_WR(HW_DRAM_CTL83_RD() |  (v)))
#define HW_DRAM_CTL83_CLR(v)    (HW_DRAM_CTL83_WR(HW_DRAM_CTL83_RD() & ~(v)))
#define HW_DRAM_CTL83_TOG(v)    (HW_DRAM_CTL83_WR(HW_DRAM_CTL83_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL83 bitfields
 */
/* --- Register HW_DRAM_CTL83, field RSVD4 */

#define BP_DRAM_CTL83_RSVD4      28
#define BM_DRAM_CTL83_RSVD4      0xF0000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL83_RSVD4(v)   ((((reg32_t) v) << 28) & BM_DRAM_CTL83_RSVD4)
#else
#define BF_DRAM_CTL83_RSVD4(v)   (((v) << 28) & BM_DRAM_CTL83_RSVD4)
#endif
/* --- Register HW_DRAM_CTL83, field ODT_RD_MAP_CS3 */

#define BP_DRAM_CTL83_ODT_RD_MAP_CS3      24
#define BM_DRAM_CTL83_ODT_RD_MAP_CS3      0x0F000000

#define BF_DRAM_CTL83_ODT_RD_MAP_CS3(v)   (((v) << 24) & BM_DRAM_CTL83_ODT_RD_MAP_CS3)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL83_ODT_RD_MAP_CS3(v)   BF_CS1(DRAM_CTL83, ODT_RD_MAP_CS3, v)
#endif

/* --- Register HW_DRAM_CTL83, field RSVD3 */

#define BP_DRAM_CTL83_RSVD3      20
#define BM_DRAM_CTL83_RSVD3      0x00F00000

#define BF_DRAM_CTL83_RSVD3(v)   (((v) << 20) & BM_DRAM_CTL83_RSVD3)
/* --- Register HW_DRAM_CTL83, field ODT_RD_MAP_CS2 */

#define BP_DRAM_CTL83_ODT_RD_MAP_CS2      16
#define BM_DRAM_CTL83_ODT_RD_MAP_CS2      0x000F0000

#define BF_DRAM_CTL83_ODT_RD_MAP_CS2(v)   (((v) << 16) & BM_DRAM_CTL83_ODT_RD_MAP_CS2)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL83_ODT_RD_MAP_CS2(v)   BF_CS1(DRAM_CTL83, ODT_RD_MAP_CS2, v)
#endif

/* --- Register HW_DRAM_CTL83, field RSVD2 */

#define BP_DRAM_CTL83_RSVD2      12
#define BM_DRAM_CTL83_RSVD2      0x0000F000

#define BF_DRAM_CTL83_RSVD2(v)   (((v) << 12) & BM_DRAM_CTL83_RSVD2)
/* --- Register HW_DRAM_CTL83, field ODT_RD_MAP_CS1 */

#define BP_DRAM_CTL83_ODT_RD_MAP_CS1      8
#define BM_DRAM_CTL83_ODT_RD_MAP_CS1      0x00000F00

#define BF_DRAM_CTL83_ODT_RD_MAP_CS1(v)   (((v) << 8) & BM_DRAM_CTL83_ODT_RD_MAP_CS1)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL83_ODT_RD_MAP_CS1(v)   BF_CS1(DRAM_CTL83, ODT_RD_MAP_CS1, v)
#endif

/* --- Register HW_DRAM_CTL83, field RSVD1 */

#define BP_DRAM_CTL83_RSVD1      4
#define BM_DRAM_CTL83_RSVD1      0x000000F0

#define BF_DRAM_CTL83_RSVD1(v)   (((v) << 4) & BM_DRAM_CTL83_RSVD1)
/* --- Register HW_DRAM_CTL83, field ODT_RD_MAP_CS0 */

#define BP_DRAM_CTL83_ODT_RD_MAP_CS0      0
#define BM_DRAM_CTL83_ODT_RD_MAP_CS0      0x0000000F

#define BF_DRAM_CTL83_ODT_RD_MAP_CS0(v)   (((v) << 0) & BM_DRAM_CTL83_ODT_RD_MAP_CS0)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL83_ODT_RD_MAP_CS0(v)   BF_CS1(DRAM_CTL83, ODT_RD_MAP_CS0, v)
#endif



/*
 * HW_DRAM_CTL84 - DRAM Control Register 84
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ODT_WR_MAP_CS0  :  4;
        unsigned RSVD1           :  4;
        unsigned ODT_WR_MAP_CS1  :  4;
        unsigned RSVD2           :  4;
        unsigned ODT_WR_MAP_CS2  :  4;
        unsigned RSVD3           :  4;
        unsigned ODT_WR_MAP_CS3  :  4;
        unsigned RSVD4           :  4;
    } B;
} hw_dram_ctl84_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL84 register
 */
#define HW_DRAM_CTL84_ADDR         (REGS_DRAM_BASE + 0x150)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL84           (*(volatile hw_dram_ctl84_t *) HW_DRAM_CTL84_ADDR)
#define HW_DRAM_CTL84_RD()      (HW_DRAM_CTL84.U)
#define HW_DRAM_CTL84_WR(v)     (HW_DRAM_CTL84.U = (v))
#define HW_DRAM_CTL84_SET(v)    (HW_DRAM_CTL84_WR(HW_DRAM_CTL84_RD() |  (v)))
#define HW_DRAM_CTL84_CLR(v)    (HW_DRAM_CTL84_WR(HW_DRAM_CTL84_RD() & ~(v)))
#define HW_DRAM_CTL84_TOG(v)    (HW_DRAM_CTL84_WR(HW_DRAM_CTL84_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL84 bitfields
 */
/* --- Register HW_DRAM_CTL84, field RSVD4 */

#define BP_DRAM_CTL84_RSVD4      28
#define BM_DRAM_CTL84_RSVD4      0xF0000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL84_RSVD4(v)   ((((reg32_t) v) << 28) & BM_DRAM_CTL84_RSVD4)
#else
#define BF_DRAM_CTL84_RSVD4(v)   (((v) << 28) & BM_DRAM_CTL84_RSVD4)
#endif
/* --- Register HW_DRAM_CTL84, field ODT_WR_MAP_CS3 */

#define BP_DRAM_CTL84_ODT_WR_MAP_CS3      24
#define BM_DRAM_CTL84_ODT_WR_MAP_CS3      0x0F000000

#define BF_DRAM_CTL84_ODT_WR_MAP_CS3(v)   (((v) << 24) & BM_DRAM_CTL84_ODT_WR_MAP_CS3)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL84_ODT_WR_MAP_CS3(v)   BF_CS1(DRAM_CTL84, ODT_WR_MAP_CS3, v)
#endif

/* --- Register HW_DRAM_CTL84, field RSVD3 */

#define BP_DRAM_CTL84_RSVD3      20
#define BM_DRAM_CTL84_RSVD3      0x00F00000

#define BF_DRAM_CTL84_RSVD3(v)   (((v) << 20) & BM_DRAM_CTL84_RSVD3)
/* --- Register HW_DRAM_CTL84, field ODT_WR_MAP_CS2 */

#define BP_DRAM_CTL84_ODT_WR_MAP_CS2      16
#define BM_DRAM_CTL84_ODT_WR_MAP_CS2      0x000F0000

#define BF_DRAM_CTL84_ODT_WR_MAP_CS2(v)   (((v) << 16) & BM_DRAM_CTL84_ODT_WR_MAP_CS2)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL84_ODT_WR_MAP_CS2(v)   BF_CS1(DRAM_CTL84, ODT_WR_MAP_CS2, v)
#endif

/* --- Register HW_DRAM_CTL84, field RSVD2 */

#define BP_DRAM_CTL84_RSVD2      12
#define BM_DRAM_CTL84_RSVD2      0x0000F000

#define BF_DRAM_CTL84_RSVD2(v)   (((v) << 12) & BM_DRAM_CTL84_RSVD2)
/* --- Register HW_DRAM_CTL84, field ODT_WR_MAP_CS1 */

#define BP_DRAM_CTL84_ODT_WR_MAP_CS1      8
#define BM_DRAM_CTL84_ODT_WR_MAP_CS1      0x00000F00

#define BF_DRAM_CTL84_ODT_WR_MAP_CS1(v)   (((v) << 8) & BM_DRAM_CTL84_ODT_WR_MAP_CS1)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL84_ODT_WR_MAP_CS1(v)   BF_CS1(DRAM_CTL84, ODT_WR_MAP_CS1, v)
#endif

/* --- Register HW_DRAM_CTL84, field RSVD1 */

#define BP_DRAM_CTL84_RSVD1      4
#define BM_DRAM_CTL84_RSVD1      0x000000F0

#define BF_DRAM_CTL84_RSVD1(v)   (((v) << 4) & BM_DRAM_CTL84_RSVD1)
/* --- Register HW_DRAM_CTL84, field ODT_WR_MAP_CS0 */

#define BP_DRAM_CTL84_ODT_WR_MAP_CS0      0
#define BM_DRAM_CTL84_ODT_WR_MAP_CS0      0x0000000F

#define BF_DRAM_CTL84_ODT_WR_MAP_CS0(v)   (((v) << 0) & BM_DRAM_CTL84_ODT_WR_MAP_CS0)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL84_ODT_WR_MAP_CS0(v)   BF_CS1(DRAM_CTL84, ODT_WR_MAP_CS0, v)
#endif



/*
 * HW_DRAM_CTL85 - DRAM Control Register 85
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PAD_CTRL_REG_0  : 32;
    } B;
} hw_dram_ctl85_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL85 register
 */
#define HW_DRAM_CTL85_ADDR         (REGS_DRAM_BASE + 0x154)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL85           (*(volatile hw_dram_ctl85_t *) HW_DRAM_CTL85_ADDR)
#define HW_DRAM_CTL85_RD()      (HW_DRAM_CTL85.U)
#define HW_DRAM_CTL85_WR(v)     (HW_DRAM_CTL85.U = (v))
#define HW_DRAM_CTL85_SET(v)    (HW_DRAM_CTL85_WR(HW_DRAM_CTL85_RD() |  (v)))
#define HW_DRAM_CTL85_CLR(v)    (HW_DRAM_CTL85_WR(HW_DRAM_CTL85_RD() & ~(v)))
#define HW_DRAM_CTL85_TOG(v)    (HW_DRAM_CTL85_WR(HW_DRAM_CTL85_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL85 bitfields
 */
/* --- Register HW_DRAM_CTL85, field PAD_CTRL_REG_0 */

#define BP_DRAM_CTL85_PAD_CTRL_REG_0      0
#define BM_DRAM_CTL85_PAD_CTRL_REG_0      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL85_PAD_CTRL_REG_0(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL85_PAD_CTRL_REG_0(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL85_PAD_CTRL_REG_0(v)   (HW_DRAM_CTL85.B.PAD_CTRL_REG_0 = (v))
#endif



/*
 * HW_DRAM_CTL86 - DRAM Control Register 86
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned VERSION   : 16;
        unsigned OBSOLETE  : 16;
    } B;
} hw_dram_ctl86_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL86 register
 */
#define HW_DRAM_CTL86_ADDR         (REGS_DRAM_BASE + 0x158)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL86           (*(volatile hw_dram_ctl86_t *) HW_DRAM_CTL86_ADDR)
#define HW_DRAM_CTL86_RD()      (HW_DRAM_CTL86.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL86 bitfields
 */
/* --- Register HW_DRAM_CTL86, field OBSOLETE */

#define BP_DRAM_CTL86_OBSOLETE      16
#define BM_DRAM_CTL86_OBSOLETE      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL86_OBSOLETE(v)   ((((reg32_t) v) << 16) & BM_DRAM_CTL86_OBSOLETE)
#else
#define BF_DRAM_CTL86_OBSOLETE(v)   (((v) << 16) & BM_DRAM_CTL86_OBSOLETE)
#endif
/* --- Register HW_DRAM_CTL86, field VERSION */

#define BP_DRAM_CTL86_VERSION      0
#define BM_DRAM_CTL86_VERSION      0x0000FFFF

#define BF_DRAM_CTL86_VERSION(v)   (((v) << 0) & BM_DRAM_CTL86_VERSION)


/*
 * HW_DRAM_CTL87 - DRAM Control Register 87
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_CTRL_REG_0_0  : 32;
    } B;
} hw_dram_ctl87_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL87 register
 */
#define HW_DRAM_CTL87_ADDR         (REGS_DRAM_BASE + 0x15c)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL87           (*(volatile hw_dram_ctl87_t *) HW_DRAM_CTL87_ADDR)
#define HW_DRAM_CTL87_RD()      (HW_DRAM_CTL87.U)
#define HW_DRAM_CTL87_WR(v)     (HW_DRAM_CTL87.U = (v))
#define HW_DRAM_CTL87_SET(v)    (HW_DRAM_CTL87_WR(HW_DRAM_CTL87_RD() |  (v)))
#define HW_DRAM_CTL87_CLR(v)    (HW_DRAM_CTL87_WR(HW_DRAM_CTL87_RD() & ~(v)))
#define HW_DRAM_CTL87_TOG(v)    (HW_DRAM_CTL87_WR(HW_DRAM_CTL87_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL87 bitfields
 */
/* --- Register HW_DRAM_CTL87, field DLL_CTRL_REG_0_0 */

#define BP_DRAM_CTL87_DLL_CTRL_REG_0_0      0
#define BM_DRAM_CTL87_DLL_CTRL_REG_0_0      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL87_DLL_CTRL_REG_0_0(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL87_DLL_CTRL_REG_0_0(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL87_DLL_CTRL_REG_0_0(v)   (HW_DRAM_CTL87.B.DLL_CTRL_REG_0_0 = (v))
#endif



/*
 * HW_DRAM_CTL88 - DRAM Control Register 88
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_CTRL_REG_0_1  : 32;
    } B;
} hw_dram_ctl88_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL88 register
 */
#define HW_DRAM_CTL88_ADDR         (REGS_DRAM_BASE + 0x160)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL88           (*(volatile hw_dram_ctl88_t *) HW_DRAM_CTL88_ADDR)
#define HW_DRAM_CTL88_RD()      (HW_DRAM_CTL88.U)
#define HW_DRAM_CTL88_WR(v)     (HW_DRAM_CTL88.U = (v))
#define HW_DRAM_CTL88_SET(v)    (HW_DRAM_CTL88_WR(HW_DRAM_CTL88_RD() |  (v)))
#define HW_DRAM_CTL88_CLR(v)    (HW_DRAM_CTL88_WR(HW_DRAM_CTL88_RD() & ~(v)))
#define HW_DRAM_CTL88_TOG(v)    (HW_DRAM_CTL88_WR(HW_DRAM_CTL88_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL88 bitfields
 */
/* --- Register HW_DRAM_CTL88, field DLL_CTRL_REG_0_1 */

#define BP_DRAM_CTL88_DLL_CTRL_REG_0_1      0
#define BM_DRAM_CTL88_DLL_CTRL_REG_0_1      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL88_DLL_CTRL_REG_0_1(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL88_DLL_CTRL_REG_0_1(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL88_DLL_CTRL_REG_0_1(v)   (HW_DRAM_CTL88.B.DLL_CTRL_REG_0_1 = (v))
#endif



/*
 * HW_DRAM_CTL89 - DRAM Control Register 89
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_CTRL_REG_0_2  : 32;
    } B;
} hw_dram_ctl89_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL89 register
 */
#define HW_DRAM_CTL89_ADDR         (REGS_DRAM_BASE + 0x164)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL89           (*(volatile hw_dram_ctl89_t *) HW_DRAM_CTL89_ADDR)
#define HW_DRAM_CTL89_RD()      (HW_DRAM_CTL89.U)
#define HW_DRAM_CTL89_WR(v)     (HW_DRAM_CTL89.U = (v))
#define HW_DRAM_CTL89_SET(v)    (HW_DRAM_CTL89_WR(HW_DRAM_CTL89_RD() |  (v)))
#define HW_DRAM_CTL89_CLR(v)    (HW_DRAM_CTL89_WR(HW_DRAM_CTL89_RD() & ~(v)))
#define HW_DRAM_CTL89_TOG(v)    (HW_DRAM_CTL89_WR(HW_DRAM_CTL89_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL89 bitfields
 */
/* --- Register HW_DRAM_CTL89, field DLL_CTRL_REG_0_2 */

#define BP_DRAM_CTL89_DLL_CTRL_REG_0_2      0
#define BM_DRAM_CTL89_DLL_CTRL_REG_0_2      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL89_DLL_CTRL_REG_0_2(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL89_DLL_CTRL_REG_0_2(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL89_DLL_CTRL_REG_0_2(v)   (HW_DRAM_CTL89.B.DLL_CTRL_REG_0_2 = (v))
#endif



/*
 * HW_DRAM_CTL90 - DRAM Control Register 90
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_CTRL_REG_0_3  : 32;
    } B;
} hw_dram_ctl90_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL90 register
 */
#define HW_DRAM_CTL90_ADDR         (REGS_DRAM_BASE + 0x168)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL90           (*(volatile hw_dram_ctl90_t *) HW_DRAM_CTL90_ADDR)
#define HW_DRAM_CTL90_RD()      (HW_DRAM_CTL90.U)
#define HW_DRAM_CTL90_WR(v)     (HW_DRAM_CTL90.U = (v))
#define HW_DRAM_CTL90_SET(v)    (HW_DRAM_CTL90_WR(HW_DRAM_CTL90_RD() |  (v)))
#define HW_DRAM_CTL90_CLR(v)    (HW_DRAM_CTL90_WR(HW_DRAM_CTL90_RD() & ~(v)))
#define HW_DRAM_CTL90_TOG(v)    (HW_DRAM_CTL90_WR(HW_DRAM_CTL90_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL90 bitfields
 */
/* --- Register HW_DRAM_CTL90, field DLL_CTRL_REG_0_3 */

#define BP_DRAM_CTL90_DLL_CTRL_REG_0_3      0
#define BM_DRAM_CTL90_DLL_CTRL_REG_0_3      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL90_DLL_CTRL_REG_0_3(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL90_DLL_CTRL_REG_0_3(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL90_DLL_CTRL_REG_0_3(v)   (HW_DRAM_CTL90.B.DLL_CTRL_REG_0_3 = (v))
#endif



/*
 * HW_DRAM_CTL91 - DRAM Control Register 91
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_CTRL_REG_1_0  : 32;
    } B;
} hw_dram_ctl91_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL91 register
 */
#define HW_DRAM_CTL91_ADDR         (REGS_DRAM_BASE + 0x16c)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL91           (*(volatile hw_dram_ctl91_t *) HW_DRAM_CTL91_ADDR)
#define HW_DRAM_CTL91_RD()      (HW_DRAM_CTL91.U)
#define HW_DRAM_CTL91_WR(v)     (HW_DRAM_CTL91.U = (v))
#define HW_DRAM_CTL91_SET(v)    (HW_DRAM_CTL91_WR(HW_DRAM_CTL91_RD() |  (v)))
#define HW_DRAM_CTL91_CLR(v)    (HW_DRAM_CTL91_WR(HW_DRAM_CTL91_RD() & ~(v)))
#define HW_DRAM_CTL91_TOG(v)    (HW_DRAM_CTL91_WR(HW_DRAM_CTL91_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL91 bitfields
 */
/* --- Register HW_DRAM_CTL91, field DLL_CTRL_REG_1_0 */

#define BP_DRAM_CTL91_DLL_CTRL_REG_1_0      0
#define BM_DRAM_CTL91_DLL_CTRL_REG_1_0      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL91_DLL_CTRL_REG_1_0(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL91_DLL_CTRL_REG_1_0(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL91_DLL_CTRL_REG_1_0(v)   (HW_DRAM_CTL91.B.DLL_CTRL_REG_1_0 = (v))
#endif



/*
 * HW_DRAM_CTL92 - DRAM Control Register 92
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_CTRL_REG_1_1  : 32;
    } B;
} hw_dram_ctl92_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL92 register
 */
#define HW_DRAM_CTL92_ADDR         (REGS_DRAM_BASE + 0x170)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL92           (*(volatile hw_dram_ctl92_t *) HW_DRAM_CTL92_ADDR)
#define HW_DRAM_CTL92_RD()      (HW_DRAM_CTL92.U)
#define HW_DRAM_CTL92_WR(v)     (HW_DRAM_CTL92.U = (v))
#define HW_DRAM_CTL92_SET(v)    (HW_DRAM_CTL92_WR(HW_DRAM_CTL92_RD() |  (v)))
#define HW_DRAM_CTL92_CLR(v)    (HW_DRAM_CTL92_WR(HW_DRAM_CTL92_RD() & ~(v)))
#define HW_DRAM_CTL92_TOG(v)    (HW_DRAM_CTL92_WR(HW_DRAM_CTL92_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL92 bitfields
 */
/* --- Register HW_DRAM_CTL92, field DLL_CTRL_REG_1_1 */

#define BP_DRAM_CTL92_DLL_CTRL_REG_1_1      0
#define BM_DRAM_CTL92_DLL_CTRL_REG_1_1      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL92_DLL_CTRL_REG_1_1(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL92_DLL_CTRL_REG_1_1(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL92_DLL_CTRL_REG_1_1(v)   (HW_DRAM_CTL92.B.DLL_CTRL_REG_1_1 = (v))
#endif



/*
 * HW_DRAM_CTL93 - DRAM Control Register 93
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_CTRL_REG_1_2  : 32;
    } B;
} hw_dram_ctl93_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL93 register
 */
#define HW_DRAM_CTL93_ADDR         (REGS_DRAM_BASE + 0x174)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL93           (*(volatile hw_dram_ctl93_t *) HW_DRAM_CTL93_ADDR)
#define HW_DRAM_CTL93_RD()      (HW_DRAM_CTL93.U)
#define HW_DRAM_CTL93_WR(v)     (HW_DRAM_CTL93.U = (v))
#define HW_DRAM_CTL93_SET(v)    (HW_DRAM_CTL93_WR(HW_DRAM_CTL93_RD() |  (v)))
#define HW_DRAM_CTL93_CLR(v)    (HW_DRAM_CTL93_WR(HW_DRAM_CTL93_RD() & ~(v)))
#define HW_DRAM_CTL93_TOG(v)    (HW_DRAM_CTL93_WR(HW_DRAM_CTL93_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL93 bitfields
 */
/* --- Register HW_DRAM_CTL93, field DLL_CTRL_REG_1_2 */

#define BP_DRAM_CTL93_DLL_CTRL_REG_1_2      0
#define BM_DRAM_CTL93_DLL_CTRL_REG_1_2      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL93_DLL_CTRL_REG_1_2(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL93_DLL_CTRL_REG_1_2(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL93_DLL_CTRL_REG_1_2(v)   (HW_DRAM_CTL93.B.DLL_CTRL_REG_1_2 = (v))
#endif



/*
 * HW_DRAM_CTL94 - DRAM Control Register 94
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_CTRL_REG_1_3  : 32;
    } B;
} hw_dram_ctl94_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL94 register
 */
#define HW_DRAM_CTL94_ADDR         (REGS_DRAM_BASE + 0x178)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL94           (*(volatile hw_dram_ctl94_t *) HW_DRAM_CTL94_ADDR)
#define HW_DRAM_CTL94_RD()      (HW_DRAM_CTL94.U)
#define HW_DRAM_CTL94_WR(v)     (HW_DRAM_CTL94.U = (v))
#define HW_DRAM_CTL94_SET(v)    (HW_DRAM_CTL94_WR(HW_DRAM_CTL94_RD() |  (v)))
#define HW_DRAM_CTL94_CLR(v)    (HW_DRAM_CTL94_WR(HW_DRAM_CTL94_RD() & ~(v)))
#define HW_DRAM_CTL94_TOG(v)    (HW_DRAM_CTL94_WR(HW_DRAM_CTL94_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL94 bitfields
 */
/* --- Register HW_DRAM_CTL94, field DLL_CTRL_REG_1_3 */

#define BP_DRAM_CTL94_DLL_CTRL_REG_1_3      0
#define BM_DRAM_CTL94_DLL_CTRL_REG_1_3      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL94_DLL_CTRL_REG_1_3(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL94_DLL_CTRL_REG_1_3(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL94_DLL_CTRL_REG_1_3(v)   (HW_DRAM_CTL94.B.DLL_CTRL_REG_1_3 = (v))
#endif



/*
 * HW_DRAM_CTL95 - DRAM Control Register 95
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_0_0  : 32;
    } B;
} hw_dram_ctl95_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL95 register
 */
#define HW_DRAM_CTL95_ADDR         (REGS_DRAM_BASE + 0x17c)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL95           (*(volatile hw_dram_ctl95_t *) HW_DRAM_CTL95_ADDR)
#define HW_DRAM_CTL95_RD()      (HW_DRAM_CTL95.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL95 bitfields
 */
/* --- Register HW_DRAM_CTL95, field DLL_OBS_REG_0_0 */

#define BP_DRAM_CTL95_DLL_OBS_REG_0_0      0
#define BM_DRAM_CTL95_DLL_OBS_REG_0_0      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL95_DLL_OBS_REG_0_0(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL95_DLL_OBS_REG_0_0(v)   (v)
#endif


/*
 * HW_DRAM_CTL96 - DRAM Control Register 96
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_0_1  : 32;
    } B;
} hw_dram_ctl96_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL96 register
 */
#define HW_DRAM_CTL96_ADDR         (REGS_DRAM_BASE + 0x180)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL96           (*(volatile hw_dram_ctl96_t *) HW_DRAM_CTL96_ADDR)
#define HW_DRAM_CTL96_RD()      (HW_DRAM_CTL96.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL96 bitfields
 */
/* --- Register HW_DRAM_CTL96, field DLL_OBS_REG_0_1 */

#define BP_DRAM_CTL96_DLL_OBS_REG_0_1      0
#define BM_DRAM_CTL96_DLL_OBS_REG_0_1      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL96_DLL_OBS_REG_0_1(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL96_DLL_OBS_REG_0_1(v)   (v)
#endif


/*
 * HW_DRAM_CTL97 - DRAM Control Register 97
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_0_2  : 32;
    } B;
} hw_dram_ctl97_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL97 register
 */
#define HW_DRAM_CTL97_ADDR         (REGS_DRAM_BASE + 0x184)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL97           (*(volatile hw_dram_ctl97_t *) HW_DRAM_CTL97_ADDR)
#define HW_DRAM_CTL97_RD()      (HW_DRAM_CTL97.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL97 bitfields
 */
/* --- Register HW_DRAM_CTL97, field DLL_OBS_REG_0_2 */

#define BP_DRAM_CTL97_DLL_OBS_REG_0_2      0
#define BM_DRAM_CTL97_DLL_OBS_REG_0_2      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL97_DLL_OBS_REG_0_2(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL97_DLL_OBS_REG_0_2(v)   (v)
#endif


/*
 * HW_DRAM_CTL98 - DRAM Control Register 98
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_0_3  : 32;
    } B;
} hw_dram_ctl98_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL98 register
 */
#define HW_DRAM_CTL98_ADDR         (REGS_DRAM_BASE + 0x188)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL98           (*(volatile hw_dram_ctl98_t *) HW_DRAM_CTL98_ADDR)
#define HW_DRAM_CTL98_RD()      (HW_DRAM_CTL98.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL98 bitfields
 */
/* --- Register HW_DRAM_CTL98, field DLL_OBS_REG_0_3 */

#define BP_DRAM_CTL98_DLL_OBS_REG_0_3      0
#define BM_DRAM_CTL98_DLL_OBS_REG_0_3      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL98_DLL_OBS_REG_0_3(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL98_DLL_OBS_REG_0_3(v)   (v)
#endif


/*
 * HW_DRAM_CTL99 - DRAM Control Register 99
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PHY_OBS_REG_0_0  : 32;
    } B;
} hw_dram_ctl99_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL99 register
 */
#define HW_DRAM_CTL99_ADDR         (REGS_DRAM_BASE + 0x18c)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL99           (*(volatile hw_dram_ctl99_t *) HW_DRAM_CTL99_ADDR)
#define HW_DRAM_CTL99_RD()      (HW_DRAM_CTL99.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL99 bitfields
 */
/* --- Register HW_DRAM_CTL99, field PHY_OBS_REG_0_0 */

#define BP_DRAM_CTL99_PHY_OBS_REG_0_0      0
#define BM_DRAM_CTL99_PHY_OBS_REG_0_0      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL99_PHY_OBS_REG_0_0(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL99_PHY_OBS_REG_0_0(v)   (v)
#endif


/*
 * HW_DRAM_CTL100 - DRAM Control Register 100
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PHY_OBS_REG_0_1  : 32;
    } B;
} hw_dram_ctl100_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL100 register
 */
#define HW_DRAM_CTL100_ADDR         (REGS_DRAM_BASE + 0x190)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL100           (*(volatile hw_dram_ctl100_t *) HW_DRAM_CTL100_ADDR)
#define HW_DRAM_CTL100_RD()      (HW_DRAM_CTL100.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL100 bitfields
 */
/* --- Register HW_DRAM_CTL100, field PHY_OBS_REG_0_1 */

#define BP_DRAM_CTL100_PHY_OBS_REG_0_1      0
#define BM_DRAM_CTL100_PHY_OBS_REG_0_1      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL100_PHY_OBS_REG_0_1(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL100_PHY_OBS_REG_0_1(v)   (v)
#endif


/*
 * HW_DRAM_CTL101 - DRAM Control Register 101
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PHY_OBS_REG_0_2  : 32;
    } B;
} hw_dram_ctl101_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL101 register
 */
#define HW_DRAM_CTL101_ADDR         (REGS_DRAM_BASE + 0x194)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL101           (*(volatile hw_dram_ctl101_t *) HW_DRAM_CTL101_ADDR)
#define HW_DRAM_CTL101_RD()      (HW_DRAM_CTL101.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL101 bitfields
 */
/* --- Register HW_DRAM_CTL101, field PHY_OBS_REG_0_2 */

#define BP_DRAM_CTL101_PHY_OBS_REG_0_2      0
#define BM_DRAM_CTL101_PHY_OBS_REG_0_2      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL101_PHY_OBS_REG_0_2(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL101_PHY_OBS_REG_0_2(v)   (v)
#endif


/*
 * HW_DRAM_CTL102 - DRAM Control Register 102
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PHY_OBS_REG_0_3  : 32;
    } B;
} hw_dram_ctl102_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL102 register
 */
#define HW_DRAM_CTL102_ADDR         (REGS_DRAM_BASE + 0x198)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL102           (*(volatile hw_dram_ctl102_t *) HW_DRAM_CTL102_ADDR)
#define HW_DRAM_CTL102_RD()      (HW_DRAM_CTL102.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL102 bitfields
 */
/* --- Register HW_DRAM_CTL102, field PHY_OBS_REG_0_3 */

#define BP_DRAM_CTL102_PHY_OBS_REG_0_3      0
#define BM_DRAM_CTL102_PHY_OBS_REG_0_3      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL102_PHY_OBS_REG_0_3(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL102_PHY_OBS_REG_0_3(v)   (v)
#endif


/*
 * HW_DRAM_CTL103 - DRAM Control Register 103
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_1_0  : 32;
    } B;
} hw_dram_ctl103_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL103 register
 */
#define HW_DRAM_CTL103_ADDR         (REGS_DRAM_BASE + 0x19c)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL103           (*(volatile hw_dram_ctl103_t *) HW_DRAM_CTL103_ADDR)
#define HW_DRAM_CTL103_RD()      (HW_DRAM_CTL103.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL103 bitfields
 */
/* --- Register HW_DRAM_CTL103, field DLL_OBS_REG_1_0 */

#define BP_DRAM_CTL103_DLL_OBS_REG_1_0      0
#define BM_DRAM_CTL103_DLL_OBS_REG_1_0      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL103_DLL_OBS_REG_1_0(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL103_DLL_OBS_REG_1_0(v)   (v)
#endif


/*
 * HW_DRAM_CTL104 - DRAM Control Register 104
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_1_0  : 32;
    } B;
} hw_dram_ctl104_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL104 register
 */
#define HW_DRAM_CTL104_ADDR         (REGS_DRAM_BASE + 0x1a0)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL104           (*(volatile hw_dram_ctl104_t *) HW_DRAM_CTL104_ADDR)
#define HW_DRAM_CTL104_RD()      (HW_DRAM_CTL104.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL104 bitfields
 */
/* --- Register HW_DRAM_CTL104, field DLL_OBS_REG_1_0 */

#define BP_DRAM_CTL104_DLL_OBS_REG_1_0      0
#define BM_DRAM_CTL104_DLL_OBS_REG_1_0      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL104_DLL_OBS_REG_1_0(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL104_DLL_OBS_REG_1_0(v)   (v)
#endif


/*
 * HW_DRAM_CTL105 - DRAM Control Register 105
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_1_0  : 32;
    } B;
} hw_dram_ctl105_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL105 register
 */
#define HW_DRAM_CTL105_ADDR         (REGS_DRAM_BASE + 0x1a4)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL105           (*(volatile hw_dram_ctl105_t *) HW_DRAM_CTL105_ADDR)
#define HW_DRAM_CTL105_RD()      (HW_DRAM_CTL105.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL105 bitfields
 */
/* --- Register HW_DRAM_CTL105, field DLL_OBS_REG_1_0 */

#define BP_DRAM_CTL105_DLL_OBS_REG_1_0      0
#define BM_DRAM_CTL105_DLL_OBS_REG_1_0      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL105_DLL_OBS_REG_1_0(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL105_DLL_OBS_REG_1_0(v)   (v)
#endif


/*
 * HW_DRAM_CTL106 - DRAM Control Register 106
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_1_0  : 32;
    } B;
} hw_dram_ctl106_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL106 register
 */
#define HW_DRAM_CTL106_ADDR         (REGS_DRAM_BASE + 0x1a8)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL106           (*(volatile hw_dram_ctl106_t *) HW_DRAM_CTL106_ADDR)
#define HW_DRAM_CTL106_RD()      (HW_DRAM_CTL106.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL106 bitfields
 */
/* --- Register HW_DRAM_CTL106, field DLL_OBS_REG_1_0 */

#define BP_DRAM_CTL106_DLL_OBS_REG_1_0      0
#define BM_DRAM_CTL106_DLL_OBS_REG_1_0      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL106_DLL_OBS_REG_1_0(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL106_DLL_OBS_REG_1_0(v)   (v)
#endif


/*
 * HW_DRAM_CTL107 - DRAM Control Register 107
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_1_0  :  9;
        unsigned RSVD1            :  7;
        unsigned OBSOLETE         : 16;
    } B;
} hw_dram_ctl107_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL107 register
 */
#define HW_DRAM_CTL107_ADDR         (REGS_DRAM_BASE + 0x1ac)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL107           (*(volatile hw_dram_ctl107_t *) HW_DRAM_CTL107_ADDR)
#define HW_DRAM_CTL107_RD()      (HW_DRAM_CTL107.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL107 bitfields
 */
/* --- Register HW_DRAM_CTL107, field OBSOLETE */

#define BP_DRAM_CTL107_OBSOLETE      16
#define BM_DRAM_CTL107_OBSOLETE      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL107_OBSOLETE(v)   ((((reg32_t) v) << 16) & BM_DRAM_CTL107_OBSOLETE)
#else
#define BF_DRAM_CTL107_OBSOLETE(v)   (((v) << 16) & BM_DRAM_CTL107_OBSOLETE)
#endif
/* --- Register HW_DRAM_CTL107, field RSVD1 */

#define BP_DRAM_CTL107_RSVD1      9
#define BM_DRAM_CTL107_RSVD1      0x0000FE00

#define BF_DRAM_CTL107_RSVD1(v)   (((v) << 9) & BM_DRAM_CTL107_RSVD1)
/* --- Register HW_DRAM_CTL107, field DLL_OBS_REG_1_0 */

#define BP_DRAM_CTL107_DLL_OBS_REG_1_0      0
#define BM_DRAM_CTL107_DLL_OBS_REG_1_0      0x000001FF

#define BF_DRAM_CTL107_DLL_OBS_REG_1_0(v)   (((v) << 0) & BM_DRAM_CTL107_DLL_OBS_REG_1_0)


/*
 * HW_DRAM_CTL108 - DRAM Control Register 108
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_1_1  : 32;
    } B;
} hw_dram_ctl108_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL108 register
 */
#define HW_DRAM_CTL108_ADDR         (REGS_DRAM_BASE + 0x1b0)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL108           (*(volatile hw_dram_ctl108_t *) HW_DRAM_CTL108_ADDR)
#define HW_DRAM_CTL108_RD()      (HW_DRAM_CTL108.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL108 bitfields
 */
/* --- Register HW_DRAM_CTL108, field DLL_OBS_REG_1_1 */

#define BP_DRAM_CTL108_DLL_OBS_REG_1_1      0
#define BM_DRAM_CTL108_DLL_OBS_REG_1_1      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL108_DLL_OBS_REG_1_1(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL108_DLL_OBS_REG_1_1(v)   (v)
#endif


/*
 * HW_DRAM_CTL109 - DRAM Control Register 109
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_1_1  : 32;
    } B;
} hw_dram_ctl109_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL109 register
 */
#define HW_DRAM_CTL109_ADDR         (REGS_DRAM_BASE + 0x1b4)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL109           (*(volatile hw_dram_ctl109_t *) HW_DRAM_CTL109_ADDR)
#define HW_DRAM_CTL109_RD()      (HW_DRAM_CTL109.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL109 bitfields
 */
/* --- Register HW_DRAM_CTL109, field DLL_OBS_REG_1_1 */

#define BP_DRAM_CTL109_DLL_OBS_REG_1_1      0
#define BM_DRAM_CTL109_DLL_OBS_REG_1_1      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL109_DLL_OBS_REG_1_1(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL109_DLL_OBS_REG_1_1(v)   (v)
#endif


/*
 * HW_DRAM_CTL110 - DRAM Control Register 110
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_1_1  : 32;
    } B;
} hw_dram_ctl110_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL110 register
 */
#define HW_DRAM_CTL110_ADDR         (REGS_DRAM_BASE + 0x1b8)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL110           (*(volatile hw_dram_ctl110_t *) HW_DRAM_CTL110_ADDR)
#define HW_DRAM_CTL110_RD()      (HW_DRAM_CTL110.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL110 bitfields
 */
/* --- Register HW_DRAM_CTL110, field DLL_OBS_REG_1_1 */

#define BP_DRAM_CTL110_DLL_OBS_REG_1_1      0
#define BM_DRAM_CTL110_DLL_OBS_REG_1_1      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL110_DLL_OBS_REG_1_1(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL110_DLL_OBS_REG_1_1(v)   (v)
#endif


/*
 * HW_DRAM_CTL111 - DRAM Control Register 111
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_1_1  : 32;
    } B;
} hw_dram_ctl111_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL111 register
 */
#define HW_DRAM_CTL111_ADDR         (REGS_DRAM_BASE + 0x1bc)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL111           (*(volatile hw_dram_ctl111_t *) HW_DRAM_CTL111_ADDR)
#define HW_DRAM_CTL111_RD()      (HW_DRAM_CTL111.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL111 bitfields
 */
/* --- Register HW_DRAM_CTL111, field DLL_OBS_REG_1_1 */

#define BP_DRAM_CTL111_DLL_OBS_REG_1_1      0
#define BM_DRAM_CTL111_DLL_OBS_REG_1_1      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL111_DLL_OBS_REG_1_1(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL111_DLL_OBS_REG_1_1(v)   (v)
#endif


/*
 * HW_DRAM_CTL112 - DRAM Control Register 112
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_1_1  :  9;
        unsigned RSVD1            :  7;
        unsigned OBSOLETE         : 16;
    } B;
} hw_dram_ctl112_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL112 register
 */
#define HW_DRAM_CTL112_ADDR         (REGS_DRAM_BASE + 0x1c0)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL112           (*(volatile hw_dram_ctl112_t *) HW_DRAM_CTL112_ADDR)
#define HW_DRAM_CTL112_RD()      (HW_DRAM_CTL112.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL112 bitfields
 */
/* --- Register HW_DRAM_CTL112, field OBSOLETE */

#define BP_DRAM_CTL112_OBSOLETE      16
#define BM_DRAM_CTL112_OBSOLETE      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL112_OBSOLETE(v)   ((((reg32_t) v) << 16) & BM_DRAM_CTL112_OBSOLETE)
#else
#define BF_DRAM_CTL112_OBSOLETE(v)   (((v) << 16) & BM_DRAM_CTL112_OBSOLETE)
#endif
/* --- Register HW_DRAM_CTL112, field RSVD1 */

#define BP_DRAM_CTL112_RSVD1      9
#define BM_DRAM_CTL112_RSVD1      0x0000FE00

#define BF_DRAM_CTL112_RSVD1(v)   (((v) << 9) & BM_DRAM_CTL112_RSVD1)
/* --- Register HW_DRAM_CTL112, field DLL_OBS_REG_1_1 */

#define BP_DRAM_CTL112_DLL_OBS_REG_1_1      0
#define BM_DRAM_CTL112_DLL_OBS_REG_1_1      0x000001FF

#define BF_DRAM_CTL112_DLL_OBS_REG_1_1(v)   (((v) << 0) & BM_DRAM_CTL112_DLL_OBS_REG_1_1)


/*
 * HW_DRAM_CTL113 - DRAM Control Register 113
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_1_2  : 32;
    } B;
} hw_dram_ctl113_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL113 register
 */
#define HW_DRAM_CTL113_ADDR         (REGS_DRAM_BASE + 0x1c4)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL113           (*(volatile hw_dram_ctl113_t *) HW_DRAM_CTL113_ADDR)
#define HW_DRAM_CTL113_RD()      (HW_DRAM_CTL113.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL113 bitfields
 */
/* --- Register HW_DRAM_CTL113, field DLL_OBS_REG_1_2 */

#define BP_DRAM_CTL113_DLL_OBS_REG_1_2      0
#define BM_DRAM_CTL113_DLL_OBS_REG_1_2      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL113_DLL_OBS_REG_1_2(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL113_DLL_OBS_REG_1_2(v)   (v)
#endif


/*
 * HW_DRAM_CTL114 - DRAM Control Register 114
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_1_2  : 32;
    } B;
} hw_dram_ctl114_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL114 register
 */
#define HW_DRAM_CTL114_ADDR         (REGS_DRAM_BASE + 0x1c8)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL114           (*(volatile hw_dram_ctl114_t *) HW_DRAM_CTL114_ADDR)
#define HW_DRAM_CTL114_RD()      (HW_DRAM_CTL114.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL114 bitfields
 */
/* --- Register HW_DRAM_CTL114, field DLL_OBS_REG_1_2 */

#define BP_DRAM_CTL114_DLL_OBS_REG_1_2      0
#define BM_DRAM_CTL114_DLL_OBS_REG_1_2      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL114_DLL_OBS_REG_1_2(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL114_DLL_OBS_REG_1_2(v)   (v)
#endif


/*
 * HW_DRAM_CTL115 - DRAM Control Register 115
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_1_2  : 32;
    } B;
} hw_dram_ctl115_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL115 register
 */
#define HW_DRAM_CTL115_ADDR         (REGS_DRAM_BASE + 0x1cc)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL115           (*(volatile hw_dram_ctl115_t *) HW_DRAM_CTL115_ADDR)
#define HW_DRAM_CTL115_RD()      (HW_DRAM_CTL115.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL115 bitfields
 */
/* --- Register HW_DRAM_CTL115, field DLL_OBS_REG_1_2 */

#define BP_DRAM_CTL115_DLL_OBS_REG_1_2      0
#define BM_DRAM_CTL115_DLL_OBS_REG_1_2      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL115_DLL_OBS_REG_1_2(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL115_DLL_OBS_REG_1_2(v)   (v)
#endif


/*
 * HW_DRAM_CTL116 - DRAM Control Register 116
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_1_2  : 32;
    } B;
} hw_dram_ctl116_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL116 register
 */
#define HW_DRAM_CTL116_ADDR         (REGS_DRAM_BASE + 0x1d0)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL116           (*(volatile hw_dram_ctl116_t *) HW_DRAM_CTL116_ADDR)
#define HW_DRAM_CTL116_RD()      (HW_DRAM_CTL116.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL116 bitfields
 */
/* --- Register HW_DRAM_CTL116, field DLL_OBS_REG_1_2 */

#define BP_DRAM_CTL116_DLL_OBS_REG_1_2      0
#define BM_DRAM_CTL116_DLL_OBS_REG_1_2      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL116_DLL_OBS_REG_1_2(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL116_DLL_OBS_REG_1_2(v)   (v)
#endif


/*
 * HW_DRAM_CTL117 - DRAM Control Register 117
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_1_2  :  9;
        unsigned RSVD1            :  7;
        unsigned OBSOLETE         : 16;
    } B;
} hw_dram_ctl117_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL117 register
 */
#define HW_DRAM_CTL117_ADDR         (REGS_DRAM_BASE + 0x1d4)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL117           (*(volatile hw_dram_ctl117_t *) HW_DRAM_CTL117_ADDR)
#define HW_DRAM_CTL117_RD()      (HW_DRAM_CTL117.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL117 bitfields
 */
/* --- Register HW_DRAM_CTL117, field OBSOLETE */

#define BP_DRAM_CTL117_OBSOLETE      16
#define BM_DRAM_CTL117_OBSOLETE      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL117_OBSOLETE(v)   ((((reg32_t) v) << 16) & BM_DRAM_CTL117_OBSOLETE)
#else
#define BF_DRAM_CTL117_OBSOLETE(v)   (((v) << 16) & BM_DRAM_CTL117_OBSOLETE)
#endif
/* --- Register HW_DRAM_CTL117, field RSVD1 */

#define BP_DRAM_CTL117_RSVD1      9
#define BM_DRAM_CTL117_RSVD1      0x0000FE00

#define BF_DRAM_CTL117_RSVD1(v)   (((v) << 9) & BM_DRAM_CTL117_RSVD1)
/* --- Register HW_DRAM_CTL117, field DLL_OBS_REG_1_2 */

#define BP_DRAM_CTL117_DLL_OBS_REG_1_2      0
#define BM_DRAM_CTL117_DLL_OBS_REG_1_2      0x000001FF

#define BF_DRAM_CTL117_DLL_OBS_REG_1_2(v)   (((v) << 0) & BM_DRAM_CTL117_DLL_OBS_REG_1_2)


/*
 * HW_DRAM_CTL118 - DRAM Control Register 118
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_1_3  : 32;
    } B;
} hw_dram_ctl118_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL118 register
 */
#define HW_DRAM_CTL118_ADDR         (REGS_DRAM_BASE + 0x1d8)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL118           (*(volatile hw_dram_ctl118_t *) HW_DRAM_CTL118_ADDR)
#define HW_DRAM_CTL118_RD()      (HW_DRAM_CTL118.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL118 bitfields
 */
/* --- Register HW_DRAM_CTL118, field DLL_OBS_REG_1_3 */

#define BP_DRAM_CTL118_DLL_OBS_REG_1_3      0
#define BM_DRAM_CTL118_DLL_OBS_REG_1_3      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL118_DLL_OBS_REG_1_3(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL118_DLL_OBS_REG_1_3(v)   (v)
#endif


/*
 * HW_DRAM_CTL119 - DRAM Control Register 119
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_1_3  : 32;
    } B;
} hw_dram_ctl119_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL119 register
 */
#define HW_DRAM_CTL119_ADDR         (REGS_DRAM_BASE + 0x1dc)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL119           (*(volatile hw_dram_ctl119_t *) HW_DRAM_CTL119_ADDR)
#define HW_DRAM_CTL119_RD()      (HW_DRAM_CTL119.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL119 bitfields
 */
/* --- Register HW_DRAM_CTL119, field DLL_OBS_REG_1_3 */

#define BP_DRAM_CTL119_DLL_OBS_REG_1_3      0
#define BM_DRAM_CTL119_DLL_OBS_REG_1_3      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL119_DLL_OBS_REG_1_3(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL119_DLL_OBS_REG_1_3(v)   (v)
#endif


/*
 * HW_DRAM_CTL120 - DRAM Control Register 120
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_1_3  : 32;
    } B;
} hw_dram_ctl120_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL120 register
 */
#define HW_DRAM_CTL120_ADDR         (REGS_DRAM_BASE + 0x1e0)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL120           (*(volatile hw_dram_ctl120_t *) HW_DRAM_CTL120_ADDR)
#define HW_DRAM_CTL120_RD()      (HW_DRAM_CTL120.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL120 bitfields
 */
/* --- Register HW_DRAM_CTL120, field DLL_OBS_REG_1_3 */

#define BP_DRAM_CTL120_DLL_OBS_REG_1_3      0
#define BM_DRAM_CTL120_DLL_OBS_REG_1_3      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL120_DLL_OBS_REG_1_3(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL120_DLL_OBS_REG_1_3(v)   (v)
#endif


/*
 * HW_DRAM_CTL121 - DRAM Control Register 121
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_1_3  : 32;
    } B;
} hw_dram_ctl121_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL121 register
 */
#define HW_DRAM_CTL121_ADDR         (REGS_DRAM_BASE + 0x1e4)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL121           (*(volatile hw_dram_ctl121_t *) HW_DRAM_CTL121_ADDR)
#define HW_DRAM_CTL121_RD()      (HW_DRAM_CTL121.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL121 bitfields
 */
/* --- Register HW_DRAM_CTL121, field DLL_OBS_REG_1_3 */

#define BP_DRAM_CTL121_DLL_OBS_REG_1_3      0
#define BM_DRAM_CTL121_DLL_OBS_REG_1_3      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL121_DLL_OBS_REG_1_3(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL121_DLL_OBS_REG_1_3(v)   (v)
#endif


/*
 * HW_DRAM_CTL122 - DRAM Control Register 122
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_1_3  :  9;
        unsigned RSVD1            :  7;
        unsigned OBSOLETE         : 16;
    } B;
} hw_dram_ctl122_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL122 register
 */
#define HW_DRAM_CTL122_ADDR         (REGS_DRAM_BASE + 0x1e8)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL122           (*(volatile hw_dram_ctl122_t *) HW_DRAM_CTL122_ADDR)
#define HW_DRAM_CTL122_RD()      (HW_DRAM_CTL122.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL122 bitfields
 */
/* --- Register HW_DRAM_CTL122, field OBSOLETE */

#define BP_DRAM_CTL122_OBSOLETE      16
#define BM_DRAM_CTL122_OBSOLETE      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL122_OBSOLETE(v)   ((((reg32_t) v) << 16) & BM_DRAM_CTL122_OBSOLETE)
#else
#define BF_DRAM_CTL122_OBSOLETE(v)   (((v) << 16) & BM_DRAM_CTL122_OBSOLETE)
#endif
/* --- Register HW_DRAM_CTL122, field RSVD1 */

#define BP_DRAM_CTL122_RSVD1      9
#define BM_DRAM_CTL122_RSVD1      0x0000FE00

#define BF_DRAM_CTL122_RSVD1(v)   (((v) << 9) & BM_DRAM_CTL122_RSVD1)
/* --- Register HW_DRAM_CTL122, field DLL_OBS_REG_1_3 */

#define BP_DRAM_CTL122_DLL_OBS_REG_1_3      0
#define BM_DRAM_CTL122_DLL_OBS_REG_1_3      0x000001FF

#define BF_DRAM_CTL122_DLL_OBS_REG_1_3(v)   (((v) << 0) & BM_DRAM_CTL122_DLL_OBS_REG_1_3)


/*
 * HW_DRAM_CTL123 - DRAM Control Register 123
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_2_0  : 32;
    } B;
} hw_dram_ctl123_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL123 register
 */
#define HW_DRAM_CTL123_ADDR         (REGS_DRAM_BASE + 0x1ec)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL123           (*(volatile hw_dram_ctl123_t *) HW_DRAM_CTL123_ADDR)
#define HW_DRAM_CTL123_RD()      (HW_DRAM_CTL123.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL123 bitfields
 */
/* --- Register HW_DRAM_CTL123, field DLL_OBS_REG_2_0 */

#define BP_DRAM_CTL123_DLL_OBS_REG_2_0      0
#define BM_DRAM_CTL123_DLL_OBS_REG_2_0      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL123_DLL_OBS_REG_2_0(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL123_DLL_OBS_REG_2_0(v)   (v)
#endif


/*
 * HW_DRAM_CTL124 - DRAM Control Register 124
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_2_0  : 32;
    } B;
} hw_dram_ctl124_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL124 register
 */
#define HW_DRAM_CTL124_ADDR         (REGS_DRAM_BASE + 0x1f0)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL124           (*(volatile hw_dram_ctl124_t *) HW_DRAM_CTL124_ADDR)
#define HW_DRAM_CTL124_RD()      (HW_DRAM_CTL124.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL124 bitfields
 */
/* --- Register HW_DRAM_CTL124, field DLL_OBS_REG_2_0 */

#define BP_DRAM_CTL124_DLL_OBS_REG_2_0      0
#define BM_DRAM_CTL124_DLL_OBS_REG_2_0      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL124_DLL_OBS_REG_2_0(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL124_DLL_OBS_REG_2_0(v)   (v)
#endif


/*
 * HW_DRAM_CTL125 - DRAM Control Register 125
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_2_0  : 32;
    } B;
} hw_dram_ctl125_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL125 register
 */
#define HW_DRAM_CTL125_ADDR         (REGS_DRAM_BASE + 0x1f4)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL125           (*(volatile hw_dram_ctl125_t *) HW_DRAM_CTL125_ADDR)
#define HW_DRAM_CTL125_RD()      (HW_DRAM_CTL125.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL125 bitfields
 */
/* --- Register HW_DRAM_CTL125, field DLL_OBS_REG_2_0 */

#define BP_DRAM_CTL125_DLL_OBS_REG_2_0      0
#define BM_DRAM_CTL125_DLL_OBS_REG_2_0      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL125_DLL_OBS_REG_2_0(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL125_DLL_OBS_REG_2_0(v)   (v)
#endif


/*
 * HW_DRAM_CTL126 - DRAM Control Register 126
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_2_0  : 32;
    } B;
} hw_dram_ctl126_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL126 register
 */
#define HW_DRAM_CTL126_ADDR         (REGS_DRAM_BASE + 0x1f8)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL126           (*(volatile hw_dram_ctl126_t *) HW_DRAM_CTL126_ADDR)
#define HW_DRAM_CTL126_RD()      (HW_DRAM_CTL126.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL126 bitfields
 */
/* --- Register HW_DRAM_CTL126, field DLL_OBS_REG_2_0 */

#define BP_DRAM_CTL126_DLL_OBS_REG_2_0      0
#define BM_DRAM_CTL126_DLL_OBS_REG_2_0      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL126_DLL_OBS_REG_2_0(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL126_DLL_OBS_REG_2_0(v)   (v)
#endif


/*
 * HW_DRAM_CTL127 - DRAM Control Register 127
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_2_0  :  9;
        unsigned RSVD1            :  7;
        unsigned OBSOLETE         : 16;
    } B;
} hw_dram_ctl127_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL127 register
 */
#define HW_DRAM_CTL127_ADDR         (REGS_DRAM_BASE + 0x1fc)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL127           (*(volatile hw_dram_ctl127_t *) HW_DRAM_CTL127_ADDR)
#define HW_DRAM_CTL127_RD()      (HW_DRAM_CTL127.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL127 bitfields
 */
/* --- Register HW_DRAM_CTL127, field OBSOLETE */

#define BP_DRAM_CTL127_OBSOLETE      16
#define BM_DRAM_CTL127_OBSOLETE      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL127_OBSOLETE(v)   ((((reg32_t) v) << 16) & BM_DRAM_CTL127_OBSOLETE)
#else
#define BF_DRAM_CTL127_OBSOLETE(v)   (((v) << 16) & BM_DRAM_CTL127_OBSOLETE)
#endif
/* --- Register HW_DRAM_CTL127, field RSVD1 */

#define BP_DRAM_CTL127_RSVD1      9
#define BM_DRAM_CTL127_RSVD1      0x0000FE00

#define BF_DRAM_CTL127_RSVD1(v)   (((v) << 9) & BM_DRAM_CTL127_RSVD1)
/* --- Register HW_DRAM_CTL127, field DLL_OBS_REG_2_0 */

#define BP_DRAM_CTL127_DLL_OBS_REG_2_0      0
#define BM_DRAM_CTL127_DLL_OBS_REG_2_0      0x000001FF

#define BF_DRAM_CTL127_DLL_OBS_REG_2_0(v)   (((v) << 0) & BM_DRAM_CTL127_DLL_OBS_REG_2_0)


/*
 * HW_DRAM_CTL128 - DRAM Control Register 128
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_2_1  : 32;
    } B;
} hw_dram_ctl128_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL128 register
 */
#define HW_DRAM_CTL128_ADDR         (REGS_DRAM_BASE + 0x200)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL128           (*(volatile hw_dram_ctl128_t *) HW_DRAM_CTL128_ADDR)
#define HW_DRAM_CTL128_RD()      (HW_DRAM_CTL128.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL128 bitfields
 */
/* --- Register HW_DRAM_CTL128, field DLL_OBS_REG_2_1 */

#define BP_DRAM_CTL128_DLL_OBS_REG_2_1      0
#define BM_DRAM_CTL128_DLL_OBS_REG_2_1      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL128_DLL_OBS_REG_2_1(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL128_DLL_OBS_REG_2_1(v)   (v)
#endif


/*
 * HW_DRAM_CTL129 - DRAM Control Register 129
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_2_1  : 32;
    } B;
} hw_dram_ctl129_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL129 register
 */
#define HW_DRAM_CTL129_ADDR         (REGS_DRAM_BASE + 0x204)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL129           (*(volatile hw_dram_ctl129_t *) HW_DRAM_CTL129_ADDR)
#define HW_DRAM_CTL129_RD()      (HW_DRAM_CTL129.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL129 bitfields
 */
/* --- Register HW_DRAM_CTL129, field DLL_OBS_REG_2_1 */

#define BP_DRAM_CTL129_DLL_OBS_REG_2_1      0
#define BM_DRAM_CTL129_DLL_OBS_REG_2_1      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL129_DLL_OBS_REG_2_1(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL129_DLL_OBS_REG_2_1(v)   (v)
#endif


/*
 * HW_DRAM_CTL130 - DRAM Control Register 130
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_2_1  : 32;
    } B;
} hw_dram_ctl130_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL130 register
 */
#define HW_DRAM_CTL130_ADDR         (REGS_DRAM_BASE + 0x208)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL130           (*(volatile hw_dram_ctl130_t *) HW_DRAM_CTL130_ADDR)
#define HW_DRAM_CTL130_RD()      (HW_DRAM_CTL130.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL130 bitfields
 */
/* --- Register HW_DRAM_CTL130, field DLL_OBS_REG_2_1 */

#define BP_DRAM_CTL130_DLL_OBS_REG_2_1      0
#define BM_DRAM_CTL130_DLL_OBS_REG_2_1      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL130_DLL_OBS_REG_2_1(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL130_DLL_OBS_REG_2_1(v)   (v)
#endif


/*
 * HW_DRAM_CTL131 - DRAM Control Register 131
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_2_1  : 32;
    } B;
} hw_dram_ctl131_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL131 register
 */
#define HW_DRAM_CTL131_ADDR         (REGS_DRAM_BASE + 0x20c)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL131           (*(volatile hw_dram_ctl131_t *) HW_DRAM_CTL131_ADDR)
#define HW_DRAM_CTL131_RD()      (HW_DRAM_CTL131.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL131 bitfields
 */
/* --- Register HW_DRAM_CTL131, field DLL_OBS_REG_2_1 */

#define BP_DRAM_CTL131_DLL_OBS_REG_2_1      0
#define BM_DRAM_CTL131_DLL_OBS_REG_2_1      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL131_DLL_OBS_REG_2_1(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL131_DLL_OBS_REG_2_1(v)   (v)
#endif


/*
 * HW_DRAM_CTL132 - DRAM Control Register 132
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_2_1  :  9;
        unsigned RSVD1            :  7;
        unsigned OBSOLETE         : 16;
    } B;
} hw_dram_ctl132_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL132 register
 */
#define HW_DRAM_CTL132_ADDR         (REGS_DRAM_BASE + 0x210)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL132           (*(volatile hw_dram_ctl132_t *) HW_DRAM_CTL132_ADDR)
#define HW_DRAM_CTL132_RD()      (HW_DRAM_CTL132.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL132 bitfields
 */
/* --- Register HW_DRAM_CTL132, field OBSOLETE */

#define BP_DRAM_CTL132_OBSOLETE      16
#define BM_DRAM_CTL132_OBSOLETE      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL132_OBSOLETE(v)   ((((reg32_t) v) << 16) & BM_DRAM_CTL132_OBSOLETE)
#else
#define BF_DRAM_CTL132_OBSOLETE(v)   (((v) << 16) & BM_DRAM_CTL132_OBSOLETE)
#endif
/* --- Register HW_DRAM_CTL132, field RSVD1 */

#define BP_DRAM_CTL132_RSVD1      9
#define BM_DRAM_CTL132_RSVD1      0x0000FE00

#define BF_DRAM_CTL132_RSVD1(v)   (((v) << 9) & BM_DRAM_CTL132_RSVD1)
/* --- Register HW_DRAM_CTL132, field DLL_OBS_REG_2_1 */

#define BP_DRAM_CTL132_DLL_OBS_REG_2_1      0
#define BM_DRAM_CTL132_DLL_OBS_REG_2_1      0x000001FF

#define BF_DRAM_CTL132_DLL_OBS_REG_2_1(v)   (((v) << 0) & BM_DRAM_CTL132_DLL_OBS_REG_2_1)


/*
 * HW_DRAM_CTL133 - DRAM Control Register 133
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_2_2  : 32;
    } B;
} hw_dram_ctl133_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL133 register
 */
#define HW_DRAM_CTL133_ADDR         (REGS_DRAM_BASE + 0x214)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL133           (*(volatile hw_dram_ctl133_t *) HW_DRAM_CTL133_ADDR)
#define HW_DRAM_CTL133_RD()      (HW_DRAM_CTL133.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL133 bitfields
 */
/* --- Register HW_DRAM_CTL133, field DLL_OBS_REG_2_2 */

#define BP_DRAM_CTL133_DLL_OBS_REG_2_2      0
#define BM_DRAM_CTL133_DLL_OBS_REG_2_2      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL133_DLL_OBS_REG_2_2(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL133_DLL_OBS_REG_2_2(v)   (v)
#endif


/*
 * HW_DRAM_CTL134 - DRAM Control Register 134
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_2_2  : 32;
    } B;
} hw_dram_ctl134_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL134 register
 */
#define HW_DRAM_CTL134_ADDR         (REGS_DRAM_BASE + 0x218)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL134           (*(volatile hw_dram_ctl134_t *) HW_DRAM_CTL134_ADDR)
#define HW_DRAM_CTL134_RD()      (HW_DRAM_CTL134.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL134 bitfields
 */
/* --- Register HW_DRAM_CTL134, field DLL_OBS_REG_2_2 */

#define BP_DRAM_CTL134_DLL_OBS_REG_2_2      0
#define BM_DRAM_CTL134_DLL_OBS_REG_2_2      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL134_DLL_OBS_REG_2_2(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL134_DLL_OBS_REG_2_2(v)   (v)
#endif


/*
 * HW_DRAM_CTL135 - DRAM Control Register 135
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_2_2  : 32;
    } B;
} hw_dram_ctl135_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL135 register
 */
#define HW_DRAM_CTL135_ADDR         (REGS_DRAM_BASE + 0x21c)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL135           (*(volatile hw_dram_ctl135_t *) HW_DRAM_CTL135_ADDR)
#define HW_DRAM_CTL135_RD()      (HW_DRAM_CTL135.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL135 bitfields
 */
/* --- Register HW_DRAM_CTL135, field DLL_OBS_REG_2_2 */

#define BP_DRAM_CTL135_DLL_OBS_REG_2_2      0
#define BM_DRAM_CTL135_DLL_OBS_REG_2_2      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL135_DLL_OBS_REG_2_2(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL135_DLL_OBS_REG_2_2(v)   (v)
#endif


/*
 * HW_DRAM_CTL136 - DRAM Control Register 136
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_2_2  : 32;
    } B;
} hw_dram_ctl136_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL136 register
 */
#define HW_DRAM_CTL136_ADDR         (REGS_DRAM_BASE + 0x220)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL136           (*(volatile hw_dram_ctl136_t *) HW_DRAM_CTL136_ADDR)
#define HW_DRAM_CTL136_RD()      (HW_DRAM_CTL136.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL136 bitfields
 */
/* --- Register HW_DRAM_CTL136, field DLL_OBS_REG_2_2 */

#define BP_DRAM_CTL136_DLL_OBS_REG_2_2      0
#define BM_DRAM_CTL136_DLL_OBS_REG_2_2      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL136_DLL_OBS_REG_2_2(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL136_DLL_OBS_REG_2_2(v)   (v)
#endif


/*
 * HW_DRAM_CTL137 - DRAM Control Register 137
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_2_2  :  9;
        unsigned RSVD1            :  7;
        unsigned OBSOLETE         : 16;
    } B;
} hw_dram_ctl137_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL137 register
 */
#define HW_DRAM_CTL137_ADDR         (REGS_DRAM_BASE + 0x224)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL137           (*(volatile hw_dram_ctl137_t *) HW_DRAM_CTL137_ADDR)
#define HW_DRAM_CTL137_RD()      (HW_DRAM_CTL137.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL137 bitfields
 */
/* --- Register HW_DRAM_CTL137, field OBSOLETE */

#define BP_DRAM_CTL137_OBSOLETE      16
#define BM_DRAM_CTL137_OBSOLETE      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL137_OBSOLETE(v)   ((((reg32_t) v) << 16) & BM_DRAM_CTL137_OBSOLETE)
#else
#define BF_DRAM_CTL137_OBSOLETE(v)   (((v) << 16) & BM_DRAM_CTL137_OBSOLETE)
#endif
/* --- Register HW_DRAM_CTL137, field RSVD1 */

#define BP_DRAM_CTL137_RSVD1      9
#define BM_DRAM_CTL137_RSVD1      0x0000FE00

#define BF_DRAM_CTL137_RSVD1(v)   (((v) << 9) & BM_DRAM_CTL137_RSVD1)
/* --- Register HW_DRAM_CTL137, field DLL_OBS_REG_2_2 */

#define BP_DRAM_CTL137_DLL_OBS_REG_2_2      0
#define BM_DRAM_CTL137_DLL_OBS_REG_2_2      0x000001FF

#define BF_DRAM_CTL137_DLL_OBS_REG_2_2(v)   (((v) << 0) & BM_DRAM_CTL137_DLL_OBS_REG_2_2)


/*
 * HW_DRAM_CTL138 - DRAM Control Register 138
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_2_3  : 32;
    } B;
} hw_dram_ctl138_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL138 register
 */
#define HW_DRAM_CTL138_ADDR         (REGS_DRAM_BASE + 0x228)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL138           (*(volatile hw_dram_ctl138_t *) HW_DRAM_CTL138_ADDR)
#define HW_DRAM_CTL138_RD()      (HW_DRAM_CTL138.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL138 bitfields
 */
/* --- Register HW_DRAM_CTL138, field DLL_OBS_REG_2_3 */

#define BP_DRAM_CTL138_DLL_OBS_REG_2_3      0
#define BM_DRAM_CTL138_DLL_OBS_REG_2_3      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL138_DLL_OBS_REG_2_3(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL138_DLL_OBS_REG_2_3(v)   (v)
#endif


/*
 * HW_DRAM_CTL139 - DRAM Control Register 139
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_2_3  : 32;
    } B;
} hw_dram_ctl139_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL139 register
 */
#define HW_DRAM_CTL139_ADDR         (REGS_DRAM_BASE + 0x22c)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL139           (*(volatile hw_dram_ctl139_t *) HW_DRAM_CTL139_ADDR)
#define HW_DRAM_CTL139_RD()      (HW_DRAM_CTL139.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL139 bitfields
 */
/* --- Register HW_DRAM_CTL139, field DLL_OBS_REG_2_3 */

#define BP_DRAM_CTL139_DLL_OBS_REG_2_3      0
#define BM_DRAM_CTL139_DLL_OBS_REG_2_3      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL139_DLL_OBS_REG_2_3(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL139_DLL_OBS_REG_2_3(v)   (v)
#endif


/*
 * HW_DRAM_CTL140 - DRAM Control Register 140
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_2_3  : 32;
    } B;
} hw_dram_ctl140_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL140 register
 */
#define HW_DRAM_CTL140_ADDR         (REGS_DRAM_BASE + 0x230)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL140           (*(volatile hw_dram_ctl140_t *) HW_DRAM_CTL140_ADDR)
#define HW_DRAM_CTL140_RD()      (HW_DRAM_CTL140.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL140 bitfields
 */
/* --- Register HW_DRAM_CTL140, field DLL_OBS_REG_2_3 */

#define BP_DRAM_CTL140_DLL_OBS_REG_2_3      0
#define BM_DRAM_CTL140_DLL_OBS_REG_2_3      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL140_DLL_OBS_REG_2_3(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL140_DLL_OBS_REG_2_3(v)   (v)
#endif


/*
 * HW_DRAM_CTL141 - DRAM Control Register 141
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_2_3  : 32;
    } B;
} hw_dram_ctl141_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL141 register
 */
#define HW_DRAM_CTL141_ADDR         (REGS_DRAM_BASE + 0x234)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL141           (*(volatile hw_dram_ctl141_t *) HW_DRAM_CTL141_ADDR)
#define HW_DRAM_CTL141_RD()      (HW_DRAM_CTL141.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL141 bitfields
 */
/* --- Register HW_DRAM_CTL141, field DLL_OBS_REG_2_3 */

#define BP_DRAM_CTL141_DLL_OBS_REG_2_3      0
#define BM_DRAM_CTL141_DLL_OBS_REG_2_3      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL141_DLL_OBS_REG_2_3(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL141_DLL_OBS_REG_2_3(v)   (v)
#endif


/*
 * HW_DRAM_CTL142 - DRAM Control Register 142
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_2_3  :  9;
        unsigned RSVD1            :  7;
        unsigned OBSOLETE         : 16;
    } B;
} hw_dram_ctl142_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL142 register
 */
#define HW_DRAM_CTL142_ADDR         (REGS_DRAM_BASE + 0x238)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL142           (*(volatile hw_dram_ctl142_t *) HW_DRAM_CTL142_ADDR)
#define HW_DRAM_CTL142_RD()      (HW_DRAM_CTL142.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL142 bitfields
 */
/* --- Register HW_DRAM_CTL142, field OBSOLETE */

#define BP_DRAM_CTL142_OBSOLETE      16
#define BM_DRAM_CTL142_OBSOLETE      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL142_OBSOLETE(v)   ((((reg32_t) v) << 16) & BM_DRAM_CTL142_OBSOLETE)
#else
#define BF_DRAM_CTL142_OBSOLETE(v)   (((v) << 16) & BM_DRAM_CTL142_OBSOLETE)
#endif
/* --- Register HW_DRAM_CTL142, field RSVD1 */

#define BP_DRAM_CTL142_RSVD1      9
#define BM_DRAM_CTL142_RSVD1      0x0000FE00

#define BF_DRAM_CTL142_RSVD1(v)   (((v) << 9) & BM_DRAM_CTL142_RSVD1)
/* --- Register HW_DRAM_CTL142, field DLL_OBS_REG_2_3 */

#define BP_DRAM_CTL142_DLL_OBS_REG_2_3      0
#define BM_DRAM_CTL142_DLL_OBS_REG_2_3      0x000001FF

#define BF_DRAM_CTL142_DLL_OBS_REG_2_3(v)   (((v) << 0) & BM_DRAM_CTL142_DLL_OBS_REG_2_3)


/*
 * HW_DRAM_CTL143 - DRAM Control Register 143
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_3_0  : 32;
    } B;
} hw_dram_ctl143_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL143 register
 */
#define HW_DRAM_CTL143_ADDR         (REGS_DRAM_BASE + 0x23c)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL143           (*(volatile hw_dram_ctl143_t *) HW_DRAM_CTL143_ADDR)
#define HW_DRAM_CTL143_RD()      (HW_DRAM_CTL143.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL143 bitfields
 */
/* --- Register HW_DRAM_CTL143, field DLL_OBS_REG_3_0 */

#define BP_DRAM_CTL143_DLL_OBS_REG_3_0      0
#define BM_DRAM_CTL143_DLL_OBS_REG_3_0      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL143_DLL_OBS_REG_3_0(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL143_DLL_OBS_REG_3_0(v)   (v)
#endif


/*
 * HW_DRAM_CTL144 - DRAM Control Register 144
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_3_0  : 32;
    } B;
} hw_dram_ctl144_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL144 register
 */
#define HW_DRAM_CTL144_ADDR         (REGS_DRAM_BASE + 0x240)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL144           (*(volatile hw_dram_ctl144_t *) HW_DRAM_CTL144_ADDR)
#define HW_DRAM_CTL144_RD()      (HW_DRAM_CTL144.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL144 bitfields
 */
/* --- Register HW_DRAM_CTL144, field DLL_OBS_REG_3_0 */

#define BP_DRAM_CTL144_DLL_OBS_REG_3_0      0
#define BM_DRAM_CTL144_DLL_OBS_REG_3_0      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL144_DLL_OBS_REG_3_0(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL144_DLL_OBS_REG_3_0(v)   (v)
#endif


/*
 * HW_DRAM_CTL145 - DRAM Control Register 145
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_3_0  : 32;
    } B;
} hw_dram_ctl145_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL145 register
 */
#define HW_DRAM_CTL145_ADDR         (REGS_DRAM_BASE + 0x244)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL145           (*(volatile hw_dram_ctl145_t *) HW_DRAM_CTL145_ADDR)
#define HW_DRAM_CTL145_RD()      (HW_DRAM_CTL145.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL145 bitfields
 */
/* --- Register HW_DRAM_CTL145, field DLL_OBS_REG_3_0 */

#define BP_DRAM_CTL145_DLL_OBS_REG_3_0      0
#define BM_DRAM_CTL145_DLL_OBS_REG_3_0      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL145_DLL_OBS_REG_3_0(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL145_DLL_OBS_REG_3_0(v)   (v)
#endif


/*
 * HW_DRAM_CTL146 - DRAM Control Register 146
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_3_0  : 32;
    } B;
} hw_dram_ctl146_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL146 register
 */
#define HW_DRAM_CTL146_ADDR         (REGS_DRAM_BASE + 0x248)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL146           (*(volatile hw_dram_ctl146_t *) HW_DRAM_CTL146_ADDR)
#define HW_DRAM_CTL146_RD()      (HW_DRAM_CTL146.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL146 bitfields
 */
/* --- Register HW_DRAM_CTL146, field DLL_OBS_REG_3_0 */

#define BP_DRAM_CTL146_DLL_OBS_REG_3_0      0
#define BM_DRAM_CTL146_DLL_OBS_REG_3_0      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL146_DLL_OBS_REG_3_0(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL146_DLL_OBS_REG_3_0(v)   (v)
#endif


/*
 * HW_DRAM_CTL147 - DRAM Control Register 147
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_3_0  :  9;
        unsigned RSVD1            :  7;
        unsigned OBSOLETE         : 16;
    } B;
} hw_dram_ctl147_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL147 register
 */
#define HW_DRAM_CTL147_ADDR         (REGS_DRAM_BASE + 0x24c)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL147           (*(volatile hw_dram_ctl147_t *) HW_DRAM_CTL147_ADDR)
#define HW_DRAM_CTL147_RD()      (HW_DRAM_CTL147.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL147 bitfields
 */
/* --- Register HW_DRAM_CTL147, field OBSOLETE */

#define BP_DRAM_CTL147_OBSOLETE      16
#define BM_DRAM_CTL147_OBSOLETE      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL147_OBSOLETE(v)   ((((reg32_t) v) << 16) & BM_DRAM_CTL147_OBSOLETE)
#else
#define BF_DRAM_CTL147_OBSOLETE(v)   (((v) << 16) & BM_DRAM_CTL147_OBSOLETE)
#endif
/* --- Register HW_DRAM_CTL147, field RSVD1 */

#define BP_DRAM_CTL147_RSVD1      9
#define BM_DRAM_CTL147_RSVD1      0x0000FE00

#define BF_DRAM_CTL147_RSVD1(v)   (((v) << 9) & BM_DRAM_CTL147_RSVD1)
/* --- Register HW_DRAM_CTL147, field DLL_OBS_REG_3_0 */

#define BP_DRAM_CTL147_DLL_OBS_REG_3_0      0
#define BM_DRAM_CTL147_DLL_OBS_REG_3_0      0x000001FF

#define BF_DRAM_CTL147_DLL_OBS_REG_3_0(v)   (((v) << 0) & BM_DRAM_CTL147_DLL_OBS_REG_3_0)


/*
 * HW_DRAM_CTL148 - DRAM Control Register 148
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_3_1  : 32;
    } B;
} hw_dram_ctl148_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL148 register
 */
#define HW_DRAM_CTL148_ADDR         (REGS_DRAM_BASE + 0x250)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL148           (*(volatile hw_dram_ctl148_t *) HW_DRAM_CTL148_ADDR)
#define HW_DRAM_CTL148_RD()      (HW_DRAM_CTL148.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL148 bitfields
 */
/* --- Register HW_DRAM_CTL148, field DLL_OBS_REG_3_1 */

#define BP_DRAM_CTL148_DLL_OBS_REG_3_1      0
#define BM_DRAM_CTL148_DLL_OBS_REG_3_1      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL148_DLL_OBS_REG_3_1(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL148_DLL_OBS_REG_3_1(v)   (v)
#endif


/*
 * HW_DRAM_CTL149 - DRAM Control Register 149
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_3_1  : 32;
    } B;
} hw_dram_ctl149_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL149 register
 */
#define HW_DRAM_CTL149_ADDR         (REGS_DRAM_BASE + 0x254)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL149           (*(volatile hw_dram_ctl149_t *) HW_DRAM_CTL149_ADDR)
#define HW_DRAM_CTL149_RD()      (HW_DRAM_CTL149.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL149 bitfields
 */
/* --- Register HW_DRAM_CTL149, field DLL_OBS_REG_3_1 */

#define BP_DRAM_CTL149_DLL_OBS_REG_3_1      0
#define BM_DRAM_CTL149_DLL_OBS_REG_3_1      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL149_DLL_OBS_REG_3_1(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL149_DLL_OBS_REG_3_1(v)   (v)
#endif


/*
 * HW_DRAM_CTL150 - DRAM Control Register 150
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_3_1  : 32;
    } B;
} hw_dram_ctl150_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL150 register
 */
#define HW_DRAM_CTL150_ADDR         (REGS_DRAM_BASE + 0x258)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL150           (*(volatile hw_dram_ctl150_t *) HW_DRAM_CTL150_ADDR)
#define HW_DRAM_CTL150_RD()      (HW_DRAM_CTL150.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL150 bitfields
 */
/* --- Register HW_DRAM_CTL150, field DLL_OBS_REG_3_1 */

#define BP_DRAM_CTL150_DLL_OBS_REG_3_1      0
#define BM_DRAM_CTL150_DLL_OBS_REG_3_1      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL150_DLL_OBS_REG_3_1(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL150_DLL_OBS_REG_3_1(v)   (v)
#endif


/*
 * HW_DRAM_CTL151 - DRAM Control Register 151
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_3_1  : 32;
    } B;
} hw_dram_ctl151_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL151 register
 */
#define HW_DRAM_CTL151_ADDR         (REGS_DRAM_BASE + 0x25c)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL151           (*(volatile hw_dram_ctl151_t *) HW_DRAM_CTL151_ADDR)
#define HW_DRAM_CTL151_RD()      (HW_DRAM_CTL151.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL151 bitfields
 */
/* --- Register HW_DRAM_CTL151, field DLL_OBS_REG_3_1 */

#define BP_DRAM_CTL151_DLL_OBS_REG_3_1      0
#define BM_DRAM_CTL151_DLL_OBS_REG_3_1      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL151_DLL_OBS_REG_3_1(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL151_DLL_OBS_REG_3_1(v)   (v)
#endif


/*
 * HW_DRAM_CTL152 - DRAM Control Register 152
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_3_1  :  9;
        unsigned RSVD1            :  7;
        unsigned OBSOLETE         : 16;
    } B;
} hw_dram_ctl152_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL152 register
 */
#define HW_DRAM_CTL152_ADDR         (REGS_DRAM_BASE + 0x260)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL152           (*(volatile hw_dram_ctl152_t *) HW_DRAM_CTL152_ADDR)
#define HW_DRAM_CTL152_RD()      (HW_DRAM_CTL152.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL152 bitfields
 */
/* --- Register HW_DRAM_CTL152, field OBSOLETE */

#define BP_DRAM_CTL152_OBSOLETE      16
#define BM_DRAM_CTL152_OBSOLETE      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL152_OBSOLETE(v)   ((((reg32_t) v) << 16) & BM_DRAM_CTL152_OBSOLETE)
#else
#define BF_DRAM_CTL152_OBSOLETE(v)   (((v) << 16) & BM_DRAM_CTL152_OBSOLETE)
#endif
/* --- Register HW_DRAM_CTL152, field RSVD1 */

#define BP_DRAM_CTL152_RSVD1      9
#define BM_DRAM_CTL152_RSVD1      0x0000FE00

#define BF_DRAM_CTL152_RSVD1(v)   (((v) << 9) & BM_DRAM_CTL152_RSVD1)
/* --- Register HW_DRAM_CTL152, field DLL_OBS_REG_3_1 */

#define BP_DRAM_CTL152_DLL_OBS_REG_3_1      0
#define BM_DRAM_CTL152_DLL_OBS_REG_3_1      0x000001FF

#define BF_DRAM_CTL152_DLL_OBS_REG_3_1(v)   (((v) << 0) & BM_DRAM_CTL152_DLL_OBS_REG_3_1)


/*
 * HW_DRAM_CTL153 - DRAM Control Register 153
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_3_2  : 32;
    } B;
} hw_dram_ctl153_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL153 register
 */
#define HW_DRAM_CTL153_ADDR         (REGS_DRAM_BASE + 0x264)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL153           (*(volatile hw_dram_ctl153_t *) HW_DRAM_CTL153_ADDR)
#define HW_DRAM_CTL153_RD()      (HW_DRAM_CTL153.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL153 bitfields
 */
/* --- Register HW_DRAM_CTL153, field DLL_OBS_REG_3_2 */

#define BP_DRAM_CTL153_DLL_OBS_REG_3_2      0
#define BM_DRAM_CTL153_DLL_OBS_REG_3_2      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL153_DLL_OBS_REG_3_2(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL153_DLL_OBS_REG_3_2(v)   (v)
#endif


/*
 * HW_DRAM_CTL154 - DRAM Control Register 154
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_3_2  : 32;
    } B;
} hw_dram_ctl154_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL154 register
 */
#define HW_DRAM_CTL154_ADDR         (REGS_DRAM_BASE + 0x268)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL154           (*(volatile hw_dram_ctl154_t *) HW_DRAM_CTL154_ADDR)
#define HW_DRAM_CTL154_RD()      (HW_DRAM_CTL154.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL154 bitfields
 */
/* --- Register HW_DRAM_CTL154, field DLL_OBS_REG_3_2 */

#define BP_DRAM_CTL154_DLL_OBS_REG_3_2      0
#define BM_DRAM_CTL154_DLL_OBS_REG_3_2      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL154_DLL_OBS_REG_3_2(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL154_DLL_OBS_REG_3_2(v)   (v)
#endif


/*
 * HW_DRAM_CTL155 - DRAM Control Register 155
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_3_2  : 32;
    } B;
} hw_dram_ctl155_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL155 register
 */
#define HW_DRAM_CTL155_ADDR         (REGS_DRAM_BASE + 0x26c)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL155           (*(volatile hw_dram_ctl155_t *) HW_DRAM_CTL155_ADDR)
#define HW_DRAM_CTL155_RD()      (HW_DRAM_CTL155.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL155 bitfields
 */
/* --- Register HW_DRAM_CTL155, field DLL_OBS_REG_3_2 */

#define BP_DRAM_CTL155_DLL_OBS_REG_3_2      0
#define BM_DRAM_CTL155_DLL_OBS_REG_3_2      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL155_DLL_OBS_REG_3_2(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL155_DLL_OBS_REG_3_2(v)   (v)
#endif


/*
 * HW_DRAM_CTL156 - DRAM Control Register 156
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_3_2  : 32;
    } B;
} hw_dram_ctl156_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL156 register
 */
#define HW_DRAM_CTL156_ADDR         (REGS_DRAM_BASE + 0x270)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL156           (*(volatile hw_dram_ctl156_t *) HW_DRAM_CTL156_ADDR)
#define HW_DRAM_CTL156_RD()      (HW_DRAM_CTL156.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL156 bitfields
 */
/* --- Register HW_DRAM_CTL156, field DLL_OBS_REG_3_2 */

#define BP_DRAM_CTL156_DLL_OBS_REG_3_2      0
#define BM_DRAM_CTL156_DLL_OBS_REG_3_2      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL156_DLL_OBS_REG_3_2(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL156_DLL_OBS_REG_3_2(v)   (v)
#endif


/*
 * HW_DRAM_CTL157 - DRAM Control Register 157
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_3_2  :  9;
        unsigned RSVD1            :  7;
        unsigned OBSOLETE         : 16;
    } B;
} hw_dram_ctl157_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL157 register
 */
#define HW_DRAM_CTL157_ADDR         (REGS_DRAM_BASE + 0x274)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL157           (*(volatile hw_dram_ctl157_t *) HW_DRAM_CTL157_ADDR)
#define HW_DRAM_CTL157_RD()      (HW_DRAM_CTL157.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL157 bitfields
 */
/* --- Register HW_DRAM_CTL157, field OBSOLETE */

#define BP_DRAM_CTL157_OBSOLETE      16
#define BM_DRAM_CTL157_OBSOLETE      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL157_OBSOLETE(v)   ((((reg32_t) v) << 16) & BM_DRAM_CTL157_OBSOLETE)
#else
#define BF_DRAM_CTL157_OBSOLETE(v)   (((v) << 16) & BM_DRAM_CTL157_OBSOLETE)
#endif
/* --- Register HW_DRAM_CTL157, field RSVD1 */

#define BP_DRAM_CTL157_RSVD1      9
#define BM_DRAM_CTL157_RSVD1      0x0000FE00

#define BF_DRAM_CTL157_RSVD1(v)   (((v) << 9) & BM_DRAM_CTL157_RSVD1)
/* --- Register HW_DRAM_CTL157, field DLL_OBS_REG_3_2 */

#define BP_DRAM_CTL157_DLL_OBS_REG_3_2      0
#define BM_DRAM_CTL157_DLL_OBS_REG_3_2      0x000001FF

#define BF_DRAM_CTL157_DLL_OBS_REG_3_2(v)   (((v) << 0) & BM_DRAM_CTL157_DLL_OBS_REG_3_2)


/*
 * HW_DRAM_CTL158 - DRAM Control Register 158
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_3_3  : 32;
    } B;
} hw_dram_ctl158_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL158 register
 */
#define HW_DRAM_CTL158_ADDR         (REGS_DRAM_BASE + 0x278)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL158           (*(volatile hw_dram_ctl158_t *) HW_DRAM_CTL158_ADDR)
#define HW_DRAM_CTL158_RD()      (HW_DRAM_CTL158.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL158 bitfields
 */
/* --- Register HW_DRAM_CTL158, field DLL_OBS_REG_3_3 */

#define BP_DRAM_CTL158_DLL_OBS_REG_3_3      0
#define BM_DRAM_CTL158_DLL_OBS_REG_3_3      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL158_DLL_OBS_REG_3_3(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL158_DLL_OBS_REG_3_3(v)   (v)
#endif


/*
 * HW_DRAM_CTL159 - DRAM Control Register 159
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_3_3  : 32;
    } B;
} hw_dram_ctl159_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL159 register
 */
#define HW_DRAM_CTL159_ADDR         (REGS_DRAM_BASE + 0x27c)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL159           (*(volatile hw_dram_ctl159_t *) HW_DRAM_CTL159_ADDR)
#define HW_DRAM_CTL159_RD()      (HW_DRAM_CTL159.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL159 bitfields
 */
/* --- Register HW_DRAM_CTL159, field DLL_OBS_REG_3_3 */

#define BP_DRAM_CTL159_DLL_OBS_REG_3_3      0
#define BM_DRAM_CTL159_DLL_OBS_REG_3_3      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL159_DLL_OBS_REG_3_3(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL159_DLL_OBS_REG_3_3(v)   (v)
#endif


/*
 * HW_DRAM_CTL160 - DRAM Control Register 160
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_3_3  : 32;
    } B;
} hw_dram_ctl160_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL160 register
 */
#define HW_DRAM_CTL160_ADDR         (REGS_DRAM_BASE + 0x280)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL160           (*(volatile hw_dram_ctl160_t *) HW_DRAM_CTL160_ADDR)
#define HW_DRAM_CTL160_RD()      (HW_DRAM_CTL160.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL160 bitfields
 */
/* --- Register HW_DRAM_CTL160, field DLL_OBS_REG_3_3 */

#define BP_DRAM_CTL160_DLL_OBS_REG_3_3      0
#define BM_DRAM_CTL160_DLL_OBS_REG_3_3      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL160_DLL_OBS_REG_3_3(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL160_DLL_OBS_REG_3_3(v)   (v)
#endif


/*
 * HW_DRAM_CTL161 - DRAM Control Register 161
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_3_3  : 32;
    } B;
} hw_dram_ctl161_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL161 register
 */
#define HW_DRAM_CTL161_ADDR         (REGS_DRAM_BASE + 0x284)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL161           (*(volatile hw_dram_ctl161_t *) HW_DRAM_CTL161_ADDR)
#define HW_DRAM_CTL161_RD()      (HW_DRAM_CTL161.U)
#endif


/*
 * constants & macros for individual HW_DRAM_CTL161 bitfields
 */
/* --- Register HW_DRAM_CTL161, field DLL_OBS_REG_3_3 */

#define BP_DRAM_CTL161_DLL_OBS_REG_3_3      0
#define BM_DRAM_CTL161_DLL_OBS_REG_3_3      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL161_DLL_OBS_REG_3_3(v)   ((reg32_t) v)
#else
#define BF_DRAM_CTL161_DLL_OBS_REG_3_3(v)   (v)
#endif


/*
 * HW_DRAM_CTL162 - DRAM Control Register 162
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_OBS_REG_3_3  :  9;
        unsigned RSVD1            :  7;
        unsigned W2R_DIFFCS_DLY   :  3;
        unsigned RSVD2            :  5;
        unsigned W2R_SAMECS_DLY   :  3;
        unsigned RSVD3            :  5;
    } B;
} hw_dram_ctl162_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL162 register
 */
#define HW_DRAM_CTL162_ADDR         (REGS_DRAM_BASE + 0x288)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL162           (*(volatile hw_dram_ctl162_t *) HW_DRAM_CTL162_ADDR)
#define HW_DRAM_CTL162_RD()      (HW_DRAM_CTL162.U)
#define HW_DRAM_CTL162_WR(v)     (HW_DRAM_CTL162.U = (v))
#define HW_DRAM_CTL162_SET(v)    (HW_DRAM_CTL162_WR(HW_DRAM_CTL162_RD() |  (v)))
#define HW_DRAM_CTL162_CLR(v)    (HW_DRAM_CTL162_WR(HW_DRAM_CTL162_RD() & ~(v)))
#define HW_DRAM_CTL162_TOG(v)    (HW_DRAM_CTL162_WR(HW_DRAM_CTL162_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL162 bitfields
 */
/* --- Register HW_DRAM_CTL162, field RSVD3 */

#define BP_DRAM_CTL162_RSVD3      27
#define BM_DRAM_CTL162_RSVD3      0xF8000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL162_RSVD3(v)   ((((reg32_t) v) << 27) & BM_DRAM_CTL162_RSVD3)
#else
#define BF_DRAM_CTL162_RSVD3(v)   (((v) << 27) & BM_DRAM_CTL162_RSVD3)
#endif
/* --- Register HW_DRAM_CTL162, field W2R_SAMECS_DLY */

#define BP_DRAM_CTL162_W2R_SAMECS_DLY      24
#define BM_DRAM_CTL162_W2R_SAMECS_DLY      0x07000000

#define BF_DRAM_CTL162_W2R_SAMECS_DLY(v)   (((v) << 24) & BM_DRAM_CTL162_W2R_SAMECS_DLY)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL162_W2R_SAMECS_DLY(v)   BF_CS1(DRAM_CTL162, W2R_SAMECS_DLY, v)
#endif

/* --- Register HW_DRAM_CTL162, field RSVD2 */

#define BP_DRAM_CTL162_RSVD2      19
#define BM_DRAM_CTL162_RSVD2      0x00F80000

#define BF_DRAM_CTL162_RSVD2(v)   (((v) << 19) & BM_DRAM_CTL162_RSVD2)
/* --- Register HW_DRAM_CTL162, field W2R_DIFFCS_DLY */

#define BP_DRAM_CTL162_W2R_DIFFCS_DLY      16
#define BM_DRAM_CTL162_W2R_DIFFCS_DLY      0x00070000

#define BF_DRAM_CTL162_W2R_DIFFCS_DLY(v)   (((v) << 16) & BM_DRAM_CTL162_W2R_DIFFCS_DLY)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL162_W2R_DIFFCS_DLY(v)   BF_CS1(DRAM_CTL162, W2R_DIFFCS_DLY, v)
#endif

/* --- Register HW_DRAM_CTL162, field RSVD1 */

#define BP_DRAM_CTL162_RSVD1      9
#define BM_DRAM_CTL162_RSVD1      0x0000FE00

#define BF_DRAM_CTL162_RSVD1(v)   (((v) << 9) & BM_DRAM_CTL162_RSVD1)
/* --- Register HW_DRAM_CTL162, field DLL_OBS_REG_3_3 */

#define BP_DRAM_CTL162_DLL_OBS_REG_3_3      0
#define BM_DRAM_CTL162_DLL_OBS_REG_3_3      0x000001FF

#define BF_DRAM_CTL162_DLL_OBS_REG_3_3(v)   (((v) << 0) & BM_DRAM_CTL162_DLL_OBS_REG_3_3)


/*
 * HW_DRAM_CTL163 - DRAM Control Register 163
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DRAM_CLASS       :  4;
        unsigned RSVD1            :  4;
        unsigned RDLAT_ADJ        :  4;
        unsigned RSVD2            :  4;
        unsigned WRLAT_ADJ        :  4;
        unsigned RSVD3            :  4;
        unsigned DLL_RST_ADJ_DLY  :  8;
    } B;
} hw_dram_ctl163_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL163 register
 */
#define HW_DRAM_CTL163_ADDR         (REGS_DRAM_BASE + 0x28c)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL163           (*(volatile hw_dram_ctl163_t *) HW_DRAM_CTL163_ADDR)
#define HW_DRAM_CTL163_RD()      (HW_DRAM_CTL163.U)
#define HW_DRAM_CTL163_WR(v)     (HW_DRAM_CTL163.U = (v))
#define HW_DRAM_CTL163_SET(v)    (HW_DRAM_CTL163_WR(HW_DRAM_CTL163_RD() |  (v)))
#define HW_DRAM_CTL163_CLR(v)    (HW_DRAM_CTL163_WR(HW_DRAM_CTL163_RD() & ~(v)))
#define HW_DRAM_CTL163_TOG(v)    (HW_DRAM_CTL163_WR(HW_DRAM_CTL163_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL163 bitfields
 */
/* --- Register HW_DRAM_CTL163, field DLL_RST_ADJ_DLY */

#define BP_DRAM_CTL163_DLL_RST_ADJ_DLY      24
#define BM_DRAM_CTL163_DLL_RST_ADJ_DLY      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL163_DLL_RST_ADJ_DLY(v)   ((((reg32_t) v) << 24) & BM_DRAM_CTL163_DLL_RST_ADJ_DLY)
#else
#define BF_DRAM_CTL163_DLL_RST_ADJ_DLY(v)   (((v) << 24) & BM_DRAM_CTL163_DLL_RST_ADJ_DLY)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL163_DLL_RST_ADJ_DLY(v)   (HW_DRAM_CTL163.B.DLL_RST_ADJ_DLY = (v))
#endif

/* --- Register HW_DRAM_CTL163, field RSVD3 */

#define BP_DRAM_CTL163_RSVD3      20
#define BM_DRAM_CTL163_RSVD3      0x00F00000

#define BF_DRAM_CTL163_RSVD3(v)   (((v) << 20) & BM_DRAM_CTL163_RSVD3)
/* --- Register HW_DRAM_CTL163, field WRLAT_ADJ */

#define BP_DRAM_CTL163_WRLAT_ADJ      16
#define BM_DRAM_CTL163_WRLAT_ADJ      0x000F0000

#define BF_DRAM_CTL163_WRLAT_ADJ(v)   (((v) << 16) & BM_DRAM_CTL163_WRLAT_ADJ)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL163_WRLAT_ADJ(v)   BF_CS1(DRAM_CTL163, WRLAT_ADJ, v)
#endif

/* --- Register HW_DRAM_CTL163, field RSVD2 */

#define BP_DRAM_CTL163_RSVD2      12
#define BM_DRAM_CTL163_RSVD2      0x0000F000

#define BF_DRAM_CTL163_RSVD2(v)   (((v) << 12) & BM_DRAM_CTL163_RSVD2)
/* --- Register HW_DRAM_CTL163, field RDLAT_ADJ */

#define BP_DRAM_CTL163_RDLAT_ADJ      8
#define BM_DRAM_CTL163_RDLAT_ADJ      0x00000F00

#define BF_DRAM_CTL163_RDLAT_ADJ(v)   (((v) << 8) & BM_DRAM_CTL163_RDLAT_ADJ)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL163_RDLAT_ADJ(v)   BF_CS1(DRAM_CTL163, RDLAT_ADJ, v)
#endif

/* --- Register HW_DRAM_CTL163, field RSVD1 */

#define BP_DRAM_CTL163_RSVD1      4
#define BM_DRAM_CTL163_RSVD1      0x000000F0

#define BF_DRAM_CTL163_RSVD1(v)   (((v) << 4) & BM_DRAM_CTL163_RSVD1)
/* --- Register HW_DRAM_CTL163, field DRAM_CLASS */

#define BP_DRAM_CTL163_DRAM_CLASS      0
#define BM_DRAM_CTL163_DRAM_CLASS      0x0000000F

#define BF_DRAM_CTL163_DRAM_CLASS(v)   (((v) << 0) & BM_DRAM_CTL163_DRAM_CLASS)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL163_DRAM_CLASS(v)   BF_CS1(DRAM_CTL163, DRAM_CLASS, v)
#endif



/*
 * HW_DRAM_CTL164 - DRAM Control Register 164
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TMOD      :  8;
        unsigned INT_ACK   : 10;
        unsigned RSVD1     :  6;
        unsigned OBSOLETE  :  8;
    } B;
} hw_dram_ctl164_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL164 register
 */
#define HW_DRAM_CTL164_ADDR         (REGS_DRAM_BASE + 0x290)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL164           (*(volatile hw_dram_ctl164_t *) HW_DRAM_CTL164_ADDR)
#define HW_DRAM_CTL164_RD()      (HW_DRAM_CTL164.U)
#define HW_DRAM_CTL164_WR(v)     (HW_DRAM_CTL164.U = (v))
#define HW_DRAM_CTL164_SET(v)    (HW_DRAM_CTL164_WR(HW_DRAM_CTL164_RD() |  (v)))
#define HW_DRAM_CTL164_CLR(v)    (HW_DRAM_CTL164_WR(HW_DRAM_CTL164_RD() & ~(v)))
#define HW_DRAM_CTL164_TOG(v)    (HW_DRAM_CTL164_WR(HW_DRAM_CTL164_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL164 bitfields
 */
/* --- Register HW_DRAM_CTL164, field OBSOLETE */

#define BP_DRAM_CTL164_OBSOLETE      24
#define BM_DRAM_CTL164_OBSOLETE      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL164_OBSOLETE(v)   ((((reg32_t) v) << 24) & BM_DRAM_CTL164_OBSOLETE)
#else
#define BF_DRAM_CTL164_OBSOLETE(v)   (((v) << 24) & BM_DRAM_CTL164_OBSOLETE)
#endif
/* --- Register HW_DRAM_CTL164, field RSVD1 */

#define BP_DRAM_CTL164_RSVD1      18
#define BM_DRAM_CTL164_RSVD1      0x00FC0000

#define BF_DRAM_CTL164_RSVD1(v)   (((v) << 18) & BM_DRAM_CTL164_RSVD1)
/* --- Register HW_DRAM_CTL164, field INT_ACK */

#define BP_DRAM_CTL164_INT_ACK      8
#define BM_DRAM_CTL164_INT_ACK      0x0003FF00

#define BF_DRAM_CTL164_INT_ACK(v)   (((v) << 8) & BM_DRAM_CTL164_INT_ACK)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL164_INT_ACK(v)   BF_CS1(DRAM_CTL164, INT_ACK, v)
#endif

/* --- Register HW_DRAM_CTL164, field TMOD */

#define BP_DRAM_CTL164_TMOD      0
#define BM_DRAM_CTL164_TMOD      0x000000FF

#define BF_DRAM_CTL164_TMOD(v)   (((v) << 0) & BM_DRAM_CTL164_TMOD)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL164_TMOD(v)   (HW_DRAM_CTL164.B.TMOD = (v))
#endif



/*
 * HW_DRAM_CTL171 - DRAM Control Register 171
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DLL_RST_DELAY    : 16;
        unsigned AXI4_BDW_OVFLOW  :  1;
        unsigned RSVD1            :  7;
        unsigned AXI5_BDW_OVFLOW  :  1;
        unsigned RSVD2            :  7;
    } B;
} hw_dram_ctl171_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL171 register
 */
#define HW_DRAM_CTL171_ADDR         (REGS_DRAM_BASE + 0x2ac)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL171           (*(volatile hw_dram_ctl171_t *) HW_DRAM_CTL171_ADDR)
#define HW_DRAM_CTL171_RD()      (HW_DRAM_CTL171.U)
#define HW_DRAM_CTL171_WR(v)     (HW_DRAM_CTL171.U = (v))
#define HW_DRAM_CTL171_SET(v)    (HW_DRAM_CTL171_WR(HW_DRAM_CTL171_RD() |  (v)))
#define HW_DRAM_CTL171_CLR(v)    (HW_DRAM_CTL171_WR(HW_DRAM_CTL171_RD() & ~(v)))
#define HW_DRAM_CTL171_TOG(v)    (HW_DRAM_CTL171_WR(HW_DRAM_CTL171_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL171 bitfields
 */
/* --- Register HW_DRAM_CTL171, field RSVD2 */

#define BP_DRAM_CTL171_RSVD2      25
#define BM_DRAM_CTL171_RSVD2      0xFE000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL171_RSVD2(v)   ((((reg32_t) v) << 25) & BM_DRAM_CTL171_RSVD2)
#else
#define BF_DRAM_CTL171_RSVD2(v)   (((v) << 25) & BM_DRAM_CTL171_RSVD2)
#endif
/* --- Register HW_DRAM_CTL171, field AXI5_BDW_OVFLOW */

#define BP_DRAM_CTL171_AXI5_BDW_OVFLOW      24
#define BM_DRAM_CTL171_AXI5_BDW_OVFLOW      0x01000000

#define BF_DRAM_CTL171_AXI5_BDW_OVFLOW(v)   (((v) << 24) & BM_DRAM_CTL171_AXI5_BDW_OVFLOW)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL171_AXI5_BDW_OVFLOW(v)   BF_CS1(DRAM_CTL171, AXI5_BDW_OVFLOW, v)
#endif

/* --- Register HW_DRAM_CTL171, field RSVD1 */

#define BP_DRAM_CTL171_RSVD1      17
#define BM_DRAM_CTL171_RSVD1      0x00FE0000

#define BF_DRAM_CTL171_RSVD1(v)   (((v) << 17) & BM_DRAM_CTL171_RSVD1)
/* --- Register HW_DRAM_CTL171, field AXI4_BDW_OVFLOW */

#define BP_DRAM_CTL171_AXI4_BDW_OVFLOW      16
#define BM_DRAM_CTL171_AXI4_BDW_OVFLOW      0x00010000

#define BF_DRAM_CTL171_AXI4_BDW_OVFLOW(v)   (((v) << 16) & BM_DRAM_CTL171_AXI4_BDW_OVFLOW)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL171_AXI4_BDW_OVFLOW(v)   BF_CS1(DRAM_CTL171, AXI4_BDW_OVFLOW, v)
#endif

/* --- Register HW_DRAM_CTL171, field DLL_RST_DELAY */

#define BP_DRAM_CTL171_DLL_RST_DELAY      0
#define BM_DRAM_CTL171_DLL_RST_DELAY      0x0000FFFF

#define BF_DRAM_CTL171_DLL_RST_DELAY(v)   (((v) << 0) & BM_DRAM_CTL171_DLL_RST_DELAY)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL171_DLL_RST_DELAY(v)   (HW_DRAM_CTL171.B.DLL_RST_DELAY = (v))
#endif



/*
 * HW_DRAM_CTL172 - DRAM Control Register 172
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned CKE_STATUS              :  1;
        unsigned RSVD1                   :  7;
        unsigned CONCURRENTAP_WR_ONLY    :  1;
        unsigned RSVD2                   :  7;
        unsigned RESYNC_DLL              :  1;
        unsigned RSVD3                   :  7;
        unsigned RESYNC_DLL_PER_AREF_EN  :  1;
        unsigned RSVD4                   :  7;
    } B;
} hw_dram_ctl172_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL172 register
 */
#define HW_DRAM_CTL172_ADDR         (REGS_DRAM_BASE + 0x2b0)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL172           (*(volatile hw_dram_ctl172_t *) HW_DRAM_CTL172_ADDR)
#define HW_DRAM_CTL172_RD()      (HW_DRAM_CTL172.U)
#define HW_DRAM_CTL172_WR(v)     (HW_DRAM_CTL172.U = (v))
#define HW_DRAM_CTL172_SET(v)    (HW_DRAM_CTL172_WR(HW_DRAM_CTL172_RD() |  (v)))
#define HW_DRAM_CTL172_CLR(v)    (HW_DRAM_CTL172_WR(HW_DRAM_CTL172_RD() & ~(v)))
#define HW_DRAM_CTL172_TOG(v)    (HW_DRAM_CTL172_WR(HW_DRAM_CTL172_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL172 bitfields
 */
/* --- Register HW_DRAM_CTL172, field RSVD4 */

#define BP_DRAM_CTL172_RSVD4      25
#define BM_DRAM_CTL172_RSVD4      0xFE000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL172_RSVD4(v)   ((((reg32_t) v) << 25) & BM_DRAM_CTL172_RSVD4)
#else
#define BF_DRAM_CTL172_RSVD4(v)   (((v) << 25) & BM_DRAM_CTL172_RSVD4)
#endif
/* --- Register HW_DRAM_CTL172, field RESYNC_DLL_PER_AREF_EN */

#define BP_DRAM_CTL172_RESYNC_DLL_PER_AREF_EN      24
#define BM_DRAM_CTL172_RESYNC_DLL_PER_AREF_EN      0x01000000

#define BF_DRAM_CTL172_RESYNC_DLL_PER_AREF_EN(v)   (((v) << 24) & BM_DRAM_CTL172_RESYNC_DLL_PER_AREF_EN)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL172_RESYNC_DLL_PER_AREF_EN(v)   BF_CS1(DRAM_CTL172, RESYNC_DLL_PER_AREF_EN, v)
#endif

/* --- Register HW_DRAM_CTL172, field RSVD3 */

#define BP_DRAM_CTL172_RSVD3      17
#define BM_DRAM_CTL172_RSVD3      0x00FE0000

#define BF_DRAM_CTL172_RSVD3(v)   (((v) << 17) & BM_DRAM_CTL172_RSVD3)
/* --- Register HW_DRAM_CTL172, field RESYNC_DLL */

#define BP_DRAM_CTL172_RESYNC_DLL      16
#define BM_DRAM_CTL172_RESYNC_DLL      0x00010000

#define BF_DRAM_CTL172_RESYNC_DLL(v)   (((v) << 16) & BM_DRAM_CTL172_RESYNC_DLL)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL172_RESYNC_DLL(v)   BF_CS1(DRAM_CTL172, RESYNC_DLL, v)
#endif

/* --- Register HW_DRAM_CTL172, field RSVD2 */

#define BP_DRAM_CTL172_RSVD2      9
#define BM_DRAM_CTL172_RSVD2      0x0000FE00

#define BF_DRAM_CTL172_RSVD2(v)   (((v) << 9) & BM_DRAM_CTL172_RSVD2)
/* --- Register HW_DRAM_CTL172, field CONCURRENTAP_WR_ONLY */

#define BP_DRAM_CTL172_CONCURRENTAP_WR_ONLY      8
#define BM_DRAM_CTL172_CONCURRENTAP_WR_ONLY      0x00000100

#define BF_DRAM_CTL172_CONCURRENTAP_WR_ONLY(v)   (((v) << 8) & BM_DRAM_CTL172_CONCURRENTAP_WR_ONLY)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL172_CONCURRENTAP_WR_ONLY(v)   BF_CS1(DRAM_CTL172, CONCURRENTAP_WR_ONLY, v)
#endif

/* --- Register HW_DRAM_CTL172, field RSVD1 */

#define BP_DRAM_CTL172_RSVD1      1
#define BM_DRAM_CTL172_RSVD1      0x000000FE

#define BF_DRAM_CTL172_RSVD1(v)   (((v) << 1) & BM_DRAM_CTL172_RSVD1)
/* --- Register HW_DRAM_CTL172, field CKE_STATUS */

#define BP_DRAM_CTL172_CKE_STATUS      0
#define BM_DRAM_CTL172_CKE_STATUS      0x00000001

#define BF_DRAM_CTL172_CKE_STATUS(v)   (((v) << 0) & BM_DRAM_CTL172_CKE_STATUS)


/*
 * HW_DRAM_CTL173 - DRAM Control Register 173
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned AXI4_FIFO_TYPE_REG  :  2;
        unsigned RSVD1               :  6;
        unsigned AXI5_FIFO_TYPE_REG  :  2;
        unsigned RSVD2               :  6;
        unsigned AXI4_R_PRIORITY     :  3;
        unsigned RSVD3               :  5;
        unsigned AXI4_W_PRIORITY     :  3;
        unsigned RSVD4               :  5;
    } B;
} hw_dram_ctl173_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL173 register
 */
#define HW_DRAM_CTL173_ADDR         (REGS_DRAM_BASE + 0x2b4)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL173           (*(volatile hw_dram_ctl173_t *) HW_DRAM_CTL173_ADDR)
#define HW_DRAM_CTL173_RD()      (HW_DRAM_CTL173.U)
#define HW_DRAM_CTL173_WR(v)     (HW_DRAM_CTL173.U = (v))
#define HW_DRAM_CTL173_SET(v)    (HW_DRAM_CTL173_WR(HW_DRAM_CTL173_RD() |  (v)))
#define HW_DRAM_CTL173_CLR(v)    (HW_DRAM_CTL173_WR(HW_DRAM_CTL173_RD() & ~(v)))
#define HW_DRAM_CTL173_TOG(v)    (HW_DRAM_CTL173_WR(HW_DRAM_CTL173_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL173 bitfields
 */
/* --- Register HW_DRAM_CTL173, field RSVD4 */

#define BP_DRAM_CTL173_RSVD4      27
#define BM_DRAM_CTL173_RSVD4      0xF8000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL173_RSVD4(v)   ((((reg32_t) v) << 27) & BM_DRAM_CTL173_RSVD4)
#else
#define BF_DRAM_CTL173_RSVD4(v)   (((v) << 27) & BM_DRAM_CTL173_RSVD4)
#endif
/* --- Register HW_DRAM_CTL173, field AXI4_W_PRIORITY */

#define BP_DRAM_CTL173_AXI4_W_PRIORITY      24
#define BM_DRAM_CTL173_AXI4_W_PRIORITY      0x07000000

#define BF_DRAM_CTL173_AXI4_W_PRIORITY(v)   (((v) << 24) & BM_DRAM_CTL173_AXI4_W_PRIORITY)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL173_AXI4_W_PRIORITY(v)   BF_CS1(DRAM_CTL173, AXI4_W_PRIORITY, v)
#endif

/* --- Register HW_DRAM_CTL173, field RSVD3 */

#define BP_DRAM_CTL173_RSVD3      19
#define BM_DRAM_CTL173_RSVD3      0x00F80000

#define BF_DRAM_CTL173_RSVD3(v)   (((v) << 19) & BM_DRAM_CTL173_RSVD3)
/* --- Register HW_DRAM_CTL173, field AXI4_R_PRIORITY */

#define BP_DRAM_CTL173_AXI4_R_PRIORITY      16
#define BM_DRAM_CTL173_AXI4_R_PRIORITY      0x00070000

#define BF_DRAM_CTL173_AXI4_R_PRIORITY(v)   (((v) << 16) & BM_DRAM_CTL173_AXI4_R_PRIORITY)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL173_AXI4_R_PRIORITY(v)   BF_CS1(DRAM_CTL173, AXI4_R_PRIORITY, v)
#endif

/* --- Register HW_DRAM_CTL173, field RSVD2 */

#define BP_DRAM_CTL173_RSVD2      10
#define BM_DRAM_CTL173_RSVD2      0x0000FC00

#define BF_DRAM_CTL173_RSVD2(v)   (((v) << 10) & BM_DRAM_CTL173_RSVD2)
/* --- Register HW_DRAM_CTL173, field AXI5_FIFO_TYPE_REG */

#define BP_DRAM_CTL173_AXI5_FIFO_TYPE_REG      8
#define BM_DRAM_CTL173_AXI5_FIFO_TYPE_REG      0x00000300

#define BF_DRAM_CTL173_AXI5_FIFO_TYPE_REG(v)   (((v) << 8) & BM_DRAM_CTL173_AXI5_FIFO_TYPE_REG)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL173_AXI5_FIFO_TYPE_REG(v)   BF_CS1(DRAM_CTL173, AXI5_FIFO_TYPE_REG, v)
#endif

/* --- Register HW_DRAM_CTL173, field RSVD1 */

#define BP_DRAM_CTL173_RSVD1      2
#define BM_DRAM_CTL173_RSVD1      0x000000FC

#define BF_DRAM_CTL173_RSVD1(v)   (((v) << 2) & BM_DRAM_CTL173_RSVD1)
/* --- Register HW_DRAM_CTL173, field AXI4_FIFO_TYPE_REG */

#define BP_DRAM_CTL173_AXI4_FIFO_TYPE_REG      0
#define BM_DRAM_CTL173_AXI4_FIFO_TYPE_REG      0x00000003

#define BF_DRAM_CTL173_AXI4_FIFO_TYPE_REG(v)   (((v) << 0) & BM_DRAM_CTL173_AXI4_FIFO_TYPE_REG)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL173_AXI4_FIFO_TYPE_REG(v)   BF_CS1(DRAM_CTL173, AXI4_FIFO_TYPE_REG, v)
#endif



/*
 * HW_DRAM_CTL174 - DRAM Control Register 174
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned AXI5_R_PRIORITY  :  3;
        unsigned RSVD1            :  5;
        unsigned AXI5_W_PRIORITY  :  3;
        unsigned RSVD2            :  5;
        unsigned R2R_DIFFCS_DLY   :  3;
        unsigned RSVD3            :  5;
        unsigned R2R_SAMECS_DLY   :  3;
        unsigned RSVD4            :  5;
    } B;
} hw_dram_ctl174_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL174 register
 */
#define HW_DRAM_CTL174_ADDR         (REGS_DRAM_BASE + 0x2b8)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL174           (*(volatile hw_dram_ctl174_t *) HW_DRAM_CTL174_ADDR)
#define HW_DRAM_CTL174_RD()      (HW_DRAM_CTL174.U)
#define HW_DRAM_CTL174_WR(v)     (HW_DRAM_CTL174.U = (v))
#define HW_DRAM_CTL174_SET(v)    (HW_DRAM_CTL174_WR(HW_DRAM_CTL174_RD() |  (v)))
#define HW_DRAM_CTL174_CLR(v)    (HW_DRAM_CTL174_WR(HW_DRAM_CTL174_RD() & ~(v)))
#define HW_DRAM_CTL174_TOG(v)    (HW_DRAM_CTL174_WR(HW_DRAM_CTL174_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL174 bitfields
 */
/* --- Register HW_DRAM_CTL174, field RSVD4 */

#define BP_DRAM_CTL174_RSVD4      27
#define BM_DRAM_CTL174_RSVD4      0xF8000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL174_RSVD4(v)   ((((reg32_t) v) << 27) & BM_DRAM_CTL174_RSVD4)
#else
#define BF_DRAM_CTL174_RSVD4(v)   (((v) << 27) & BM_DRAM_CTL174_RSVD4)
#endif
/* --- Register HW_DRAM_CTL174, field R2R_SAMECS_DLY */

#define BP_DRAM_CTL174_R2R_SAMECS_DLY      24
#define BM_DRAM_CTL174_R2R_SAMECS_DLY      0x07000000

#define BF_DRAM_CTL174_R2R_SAMECS_DLY(v)   (((v) << 24) & BM_DRAM_CTL174_R2R_SAMECS_DLY)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL174_R2R_SAMECS_DLY(v)   BF_CS1(DRAM_CTL174, R2R_SAMECS_DLY, v)
#endif

/* --- Register HW_DRAM_CTL174, field RSVD3 */

#define BP_DRAM_CTL174_RSVD3      19
#define BM_DRAM_CTL174_RSVD3      0x00F80000

#define BF_DRAM_CTL174_RSVD3(v)   (((v) << 19) & BM_DRAM_CTL174_RSVD3)
/* --- Register HW_DRAM_CTL174, field R2R_DIFFCS_DLY */

#define BP_DRAM_CTL174_R2R_DIFFCS_DLY      16
#define BM_DRAM_CTL174_R2R_DIFFCS_DLY      0x00070000

#define BF_DRAM_CTL174_R2R_DIFFCS_DLY(v)   (((v) << 16) & BM_DRAM_CTL174_R2R_DIFFCS_DLY)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL174_R2R_DIFFCS_DLY(v)   BF_CS1(DRAM_CTL174, R2R_DIFFCS_DLY, v)
#endif

/* --- Register HW_DRAM_CTL174, field RSVD2 */

#define BP_DRAM_CTL174_RSVD2      11
#define BM_DRAM_CTL174_RSVD2      0x0000F800

#define BF_DRAM_CTL174_RSVD2(v)   (((v) << 11) & BM_DRAM_CTL174_RSVD2)
/* --- Register HW_DRAM_CTL174, field AXI5_W_PRIORITY */

#define BP_DRAM_CTL174_AXI5_W_PRIORITY      8
#define BM_DRAM_CTL174_AXI5_W_PRIORITY      0x00000700

#define BF_DRAM_CTL174_AXI5_W_PRIORITY(v)   (((v) << 8) & BM_DRAM_CTL174_AXI5_W_PRIORITY)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL174_AXI5_W_PRIORITY(v)   BF_CS1(DRAM_CTL174, AXI5_W_PRIORITY, v)
#endif

/* --- Register HW_DRAM_CTL174, field RSVD1 */

#define BP_DRAM_CTL174_RSVD1      3
#define BM_DRAM_CTL174_RSVD1      0x000000F8

#define BF_DRAM_CTL174_RSVD1(v)   (((v) << 3) & BM_DRAM_CTL174_RSVD1)
/* --- Register HW_DRAM_CTL174, field AXI5_R_PRIORITY */

#define BP_DRAM_CTL174_AXI5_R_PRIORITY      0
#define BM_DRAM_CTL174_AXI5_R_PRIORITY      0x00000007

#define BF_DRAM_CTL174_AXI5_R_PRIORITY(v)   (((v) << 0) & BM_DRAM_CTL174_AXI5_R_PRIORITY)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL174_AXI5_R_PRIORITY(v)   BF_CS1(DRAM_CTL174, AXI5_R_PRIORITY, v)
#endif



/*
 * HW_DRAM_CTL175 - DRAM Control Register 175
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned R2W_DIFFCS_DLY     :  3;
        unsigned RSVD1              :  5;
        unsigned R2W_SAMECS_DLY     :  3;
        unsigned RSVD2              :  5;
        unsigned TBST_INT_INTERVAL  :  3;
        unsigned RSVD3              :  5;
        unsigned W2W_DIFFCS_DLY     :  3;
        unsigned RSVD4              :  5;
    } B;
} hw_dram_ctl175_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL175 register
 */
#define HW_DRAM_CTL175_ADDR         (REGS_DRAM_BASE + 0x2bc)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL175           (*(volatile hw_dram_ctl175_t *) HW_DRAM_CTL175_ADDR)
#define HW_DRAM_CTL175_RD()      (HW_DRAM_CTL175.U)
#define HW_DRAM_CTL175_WR(v)     (HW_DRAM_CTL175.U = (v))
#define HW_DRAM_CTL175_SET(v)    (HW_DRAM_CTL175_WR(HW_DRAM_CTL175_RD() |  (v)))
#define HW_DRAM_CTL175_CLR(v)    (HW_DRAM_CTL175_WR(HW_DRAM_CTL175_RD() & ~(v)))
#define HW_DRAM_CTL175_TOG(v)    (HW_DRAM_CTL175_WR(HW_DRAM_CTL175_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL175 bitfields
 */
/* --- Register HW_DRAM_CTL175, field RSVD4 */

#define BP_DRAM_CTL175_RSVD4      27
#define BM_DRAM_CTL175_RSVD4      0xF8000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL175_RSVD4(v)   ((((reg32_t) v) << 27) & BM_DRAM_CTL175_RSVD4)
#else
#define BF_DRAM_CTL175_RSVD4(v)   (((v) << 27) & BM_DRAM_CTL175_RSVD4)
#endif
/* --- Register HW_DRAM_CTL175, field W2W_DIFFCS_DLY */

#define BP_DRAM_CTL175_W2W_DIFFCS_DLY      24
#define BM_DRAM_CTL175_W2W_DIFFCS_DLY      0x07000000

#define BF_DRAM_CTL175_W2W_DIFFCS_DLY(v)   (((v) << 24) & BM_DRAM_CTL175_W2W_DIFFCS_DLY)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL175_W2W_DIFFCS_DLY(v)   BF_CS1(DRAM_CTL175, W2W_DIFFCS_DLY, v)
#endif

/* --- Register HW_DRAM_CTL175, field RSVD3 */

#define BP_DRAM_CTL175_RSVD3      19
#define BM_DRAM_CTL175_RSVD3      0x00F80000

#define BF_DRAM_CTL175_RSVD3(v)   (((v) << 19) & BM_DRAM_CTL175_RSVD3)
/* --- Register HW_DRAM_CTL175, field TBST_INT_INTERVAL */

#define BP_DRAM_CTL175_TBST_INT_INTERVAL      16
#define BM_DRAM_CTL175_TBST_INT_INTERVAL      0x00070000

#define BF_DRAM_CTL175_TBST_INT_INTERVAL(v)   (((v) << 16) & BM_DRAM_CTL175_TBST_INT_INTERVAL)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL175_TBST_INT_INTERVAL(v)   BF_CS1(DRAM_CTL175, TBST_INT_INTERVAL, v)
#endif

/* --- Register HW_DRAM_CTL175, field RSVD2 */

#define BP_DRAM_CTL175_RSVD2      11
#define BM_DRAM_CTL175_RSVD2      0x0000F800

#define BF_DRAM_CTL175_RSVD2(v)   (((v) << 11) & BM_DRAM_CTL175_RSVD2)
/* --- Register HW_DRAM_CTL175, field R2W_SAMECS_DLY */

#define BP_DRAM_CTL175_R2W_SAMECS_DLY      8
#define BM_DRAM_CTL175_R2W_SAMECS_DLY      0x00000700

#define BF_DRAM_CTL175_R2W_SAMECS_DLY(v)   (((v) << 8) & BM_DRAM_CTL175_R2W_SAMECS_DLY)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL175_R2W_SAMECS_DLY(v)   BF_CS1(DRAM_CTL175, R2W_SAMECS_DLY, v)
#endif

/* --- Register HW_DRAM_CTL175, field RSVD1 */

#define BP_DRAM_CTL175_RSVD1      3
#define BM_DRAM_CTL175_RSVD1      0x000000F8

#define BF_DRAM_CTL175_RSVD1(v)   (((v) << 3) & BM_DRAM_CTL175_RSVD1)
/* --- Register HW_DRAM_CTL175, field R2W_DIFFCS_DLY */

#define BP_DRAM_CTL175_R2W_DIFFCS_DLY      0
#define BM_DRAM_CTL175_R2W_DIFFCS_DLY      0x00000007

#define BF_DRAM_CTL175_R2W_DIFFCS_DLY(v)   (((v) << 0) & BM_DRAM_CTL175_R2W_DIFFCS_DLY)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL175_R2W_DIFFCS_DLY(v)   BF_CS1(DRAM_CTL175, R2W_DIFFCS_DLY, v)
#endif



/*
 * HW_DRAM_CTL176 - DRAM Control Register 176
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned W2W_SAMECS_DLY               :  3;
        unsigned RSVD1                        :  5;
        unsigned ADD_ODT_CLK_DIFFTYPE_DIFFCS  :  4;
        unsigned RSVD2                        :  4;
        unsigned ADD_ODT_CLK_DIFFTYPE_SAMECS  :  4;
        unsigned RSVD3                        :  4;
        unsigned ADD_ODT_CLK_SAMETYPE_DIFFCS  :  4;
        unsigned RSVD4                        :  4;
    } B;
} hw_dram_ctl176_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL176 register
 */
#define HW_DRAM_CTL176_ADDR         (REGS_DRAM_BASE + 0x2c0)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL176           (*(volatile hw_dram_ctl176_t *) HW_DRAM_CTL176_ADDR)
#define HW_DRAM_CTL176_RD()      (HW_DRAM_CTL176.U)
#define HW_DRAM_CTL176_WR(v)     (HW_DRAM_CTL176.U = (v))
#define HW_DRAM_CTL176_SET(v)    (HW_DRAM_CTL176_WR(HW_DRAM_CTL176_RD() |  (v)))
#define HW_DRAM_CTL176_CLR(v)    (HW_DRAM_CTL176_WR(HW_DRAM_CTL176_RD() & ~(v)))
#define HW_DRAM_CTL176_TOG(v)    (HW_DRAM_CTL176_WR(HW_DRAM_CTL176_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL176 bitfields
 */
/* --- Register HW_DRAM_CTL176, field RSVD4 */

#define BP_DRAM_CTL176_RSVD4      28
#define BM_DRAM_CTL176_RSVD4      0xF0000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL176_RSVD4(v)   ((((reg32_t) v) << 28) & BM_DRAM_CTL176_RSVD4)
#else
#define BF_DRAM_CTL176_RSVD4(v)   (((v) << 28) & BM_DRAM_CTL176_RSVD4)
#endif
/* --- Register HW_DRAM_CTL176, field ADD_ODT_CLK_SAMETYPE_DIFFCS */

#define BP_DRAM_CTL176_ADD_ODT_CLK_SAMETYPE_DIFFCS      24
#define BM_DRAM_CTL176_ADD_ODT_CLK_SAMETYPE_DIFFCS      0x0F000000

#define BF_DRAM_CTL176_ADD_ODT_CLK_SAMETYPE_DIFFCS(v)   (((v) << 24) & BM_DRAM_CTL176_ADD_ODT_CLK_SAMETYPE_DIFFCS)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL176_ADD_ODT_CLK_SAMETYPE_DIFFCS(v)   BF_CS1(DRAM_CTL176, ADD_ODT_CLK_SAMETYPE_DIFFCS, v)
#endif

/* --- Register HW_DRAM_CTL176, field RSVD3 */

#define BP_DRAM_CTL176_RSVD3      20
#define BM_DRAM_CTL176_RSVD3      0x00F00000

#define BF_DRAM_CTL176_RSVD3(v)   (((v) << 20) & BM_DRAM_CTL176_RSVD3)
/* --- Register HW_DRAM_CTL176, field ADD_ODT_CLK_DIFFTYPE_SAMECS */

#define BP_DRAM_CTL176_ADD_ODT_CLK_DIFFTYPE_SAMECS      16
#define BM_DRAM_CTL176_ADD_ODT_CLK_DIFFTYPE_SAMECS      0x000F0000

#define BF_DRAM_CTL176_ADD_ODT_CLK_DIFFTYPE_SAMECS(v)   (((v) << 16) & BM_DRAM_CTL176_ADD_ODT_CLK_DIFFTYPE_SAMECS)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL176_ADD_ODT_CLK_DIFFTYPE_SAMECS(v)   BF_CS1(DRAM_CTL176, ADD_ODT_CLK_DIFFTYPE_SAMECS, v)
#endif

/* --- Register HW_DRAM_CTL176, field RSVD2 */

#define BP_DRAM_CTL176_RSVD2      12
#define BM_DRAM_CTL176_RSVD2      0x0000F000

#define BF_DRAM_CTL176_RSVD2(v)   (((v) << 12) & BM_DRAM_CTL176_RSVD2)
/* --- Register HW_DRAM_CTL176, field ADD_ODT_CLK_DIFFTYPE_DIFFCS */

#define BP_DRAM_CTL176_ADD_ODT_CLK_DIFFTYPE_DIFFCS      8
#define BM_DRAM_CTL176_ADD_ODT_CLK_DIFFTYPE_DIFFCS      0x00000F00

#define BF_DRAM_CTL176_ADD_ODT_CLK_DIFFTYPE_DIFFCS(v)   (((v) << 8) & BM_DRAM_CTL176_ADD_ODT_CLK_DIFFTYPE_DIFFCS)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL176_ADD_ODT_CLK_DIFFTYPE_DIFFCS(v)   BF_CS1(DRAM_CTL176, ADD_ODT_CLK_DIFFTYPE_DIFFCS, v)
#endif

/* --- Register HW_DRAM_CTL176, field RSVD1 */

#define BP_DRAM_CTL176_RSVD1      3
#define BM_DRAM_CTL176_RSVD1      0x000000F8

#define BF_DRAM_CTL176_RSVD1(v)   (((v) << 3) & BM_DRAM_CTL176_RSVD1)
/* --- Register HW_DRAM_CTL176, field W2W_SAMECS_DLY */

#define BP_DRAM_CTL176_W2W_SAMECS_DLY      0
#define BM_DRAM_CTL176_W2W_SAMECS_DLY      0x00000007

#define BF_DRAM_CTL176_W2W_SAMECS_DLY(v)   (((v) << 0) & BM_DRAM_CTL176_W2W_SAMECS_DLY)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL176_W2W_SAMECS_DLY(v)   BF_CS1(DRAM_CTL176, W2W_SAMECS_DLY, v)
#endif



/*
 * HW_DRAM_CTL177 - DRAM Control Register 177
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned CKSRE   :  4;
        unsigned RSVD1   :  4;
        unsigned CKSRX   :  4;
        unsigned RSVD2   :  4;
        unsigned TRP_AB  :  4;
        unsigned RSVD3   :  4;
        unsigned TCCD    :  5;
        unsigned RSVD4   :  3;
    } B;
} hw_dram_ctl177_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL177 register
 */
#define HW_DRAM_CTL177_ADDR         (REGS_DRAM_BASE + 0x2c4)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL177           (*(volatile hw_dram_ctl177_t *) HW_DRAM_CTL177_ADDR)
#define HW_DRAM_CTL177_RD()      (HW_DRAM_CTL177.U)
#define HW_DRAM_CTL177_WR(v)     (HW_DRAM_CTL177.U = (v))
#define HW_DRAM_CTL177_SET(v)    (HW_DRAM_CTL177_WR(HW_DRAM_CTL177_RD() |  (v)))
#define HW_DRAM_CTL177_CLR(v)    (HW_DRAM_CTL177_WR(HW_DRAM_CTL177_RD() & ~(v)))
#define HW_DRAM_CTL177_TOG(v)    (HW_DRAM_CTL177_WR(HW_DRAM_CTL177_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL177 bitfields
 */
/* --- Register HW_DRAM_CTL177, field RSVD4 */

#define BP_DRAM_CTL177_RSVD4      29
#define BM_DRAM_CTL177_RSVD4      0xE0000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL177_RSVD4(v)   ((((reg32_t) v) << 29) & BM_DRAM_CTL177_RSVD4)
#else
#define BF_DRAM_CTL177_RSVD4(v)   (((v) << 29) & BM_DRAM_CTL177_RSVD4)
#endif
/* --- Register HW_DRAM_CTL177, field TCCD */

#define BP_DRAM_CTL177_TCCD      24
#define BM_DRAM_CTL177_TCCD      0x1F000000

#define BF_DRAM_CTL177_TCCD(v)   (((v) << 24) & BM_DRAM_CTL177_TCCD)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL177_TCCD(v)   BF_CS1(DRAM_CTL177, TCCD, v)
#endif

/* --- Register HW_DRAM_CTL177, field RSVD3 */

#define BP_DRAM_CTL177_RSVD3      20
#define BM_DRAM_CTL177_RSVD3      0x00F00000

#define BF_DRAM_CTL177_RSVD3(v)   (((v) << 20) & BM_DRAM_CTL177_RSVD3)
/* --- Register HW_DRAM_CTL177, field TRP_AB */

#define BP_DRAM_CTL177_TRP_AB      16
#define BM_DRAM_CTL177_TRP_AB      0x000F0000

#define BF_DRAM_CTL177_TRP_AB(v)   (((v) << 16) & BM_DRAM_CTL177_TRP_AB)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL177_TRP_AB(v)   BF_CS1(DRAM_CTL177, TRP_AB, v)
#endif

/* --- Register HW_DRAM_CTL177, field RSVD2 */

#define BP_DRAM_CTL177_RSVD2      12
#define BM_DRAM_CTL177_RSVD2      0x0000F000

#define BF_DRAM_CTL177_RSVD2(v)   (((v) << 12) & BM_DRAM_CTL177_RSVD2)
/* --- Register HW_DRAM_CTL177, field CKSRX */

#define BP_DRAM_CTL177_CKSRX      8
#define BM_DRAM_CTL177_CKSRX      0x00000F00

#define BF_DRAM_CTL177_CKSRX(v)   (((v) << 8) & BM_DRAM_CTL177_CKSRX)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL177_CKSRX(v)   BF_CS1(DRAM_CTL177, CKSRX, v)
#endif

/* --- Register HW_DRAM_CTL177, field RSVD1 */

#define BP_DRAM_CTL177_RSVD1      4
#define BM_DRAM_CTL177_RSVD1      0x000000F0

#define BF_DRAM_CTL177_RSVD1(v)   (((v) << 4) & BM_DRAM_CTL177_RSVD1)
/* --- Register HW_DRAM_CTL177, field CKSRE */

#define BP_DRAM_CTL177_CKSRE      0
#define BM_DRAM_CTL177_CKSRE      0x0000000F

#define BF_DRAM_CTL177_CKSRE(v)   (((v) << 0) & BM_DRAM_CTL177_CKSRE)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL177_CKSRE(v)   BF_CS1(DRAM_CTL177, CKSRE, v)
#endif



/*
 * HW_DRAM_CTL178 - DRAM Control Register 178
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TCKESR            :  5;
        unsigned RSVD1             :  3;
        unsigned AXI4_BDW          :  7;
        unsigned RSVD2             :  1;
        unsigned AXI4_CURRENT_BDW  :  7;
        unsigned RSVD3             :  1;
        unsigned AXI5_BDW          :  7;
        unsigned RSVD4             :  1;
    } B;
} hw_dram_ctl178_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL178 register
 */
#define HW_DRAM_CTL178_ADDR         (REGS_DRAM_BASE + 0x2c8)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL178           (*(volatile hw_dram_ctl178_t *) HW_DRAM_CTL178_ADDR)
#define HW_DRAM_CTL178_RD()      (HW_DRAM_CTL178.U)
#define HW_DRAM_CTL178_WR(v)     (HW_DRAM_CTL178.U = (v))
#define HW_DRAM_CTL178_SET(v)    (HW_DRAM_CTL178_WR(HW_DRAM_CTL178_RD() |  (v)))
#define HW_DRAM_CTL178_CLR(v)    (HW_DRAM_CTL178_WR(HW_DRAM_CTL178_RD() & ~(v)))
#define HW_DRAM_CTL178_TOG(v)    (HW_DRAM_CTL178_WR(HW_DRAM_CTL178_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL178 bitfields
 */
/* --- Register HW_DRAM_CTL178, field RSVD4 */

#define BP_DRAM_CTL178_RSVD4      31
#define BM_DRAM_CTL178_RSVD4      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL178_RSVD4(v)   ((((reg32_t) v) << 31) & BM_DRAM_CTL178_RSVD4)
#else
#define BF_DRAM_CTL178_RSVD4(v)   (((v) << 31) & BM_DRAM_CTL178_RSVD4)
#endif
/* --- Register HW_DRAM_CTL178, field AXI5_BDW */

#define BP_DRAM_CTL178_AXI5_BDW      24
#define BM_DRAM_CTL178_AXI5_BDW      0x7F000000

#define BF_DRAM_CTL178_AXI5_BDW(v)   (((v) << 24) & BM_DRAM_CTL178_AXI5_BDW)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL178_AXI5_BDW(v)   BF_CS1(DRAM_CTL178, AXI5_BDW, v)
#endif

/* --- Register HW_DRAM_CTL178, field RSVD3 */

#define BP_DRAM_CTL178_RSVD3      23
#define BM_DRAM_CTL178_RSVD3      0x00800000

#define BF_DRAM_CTL178_RSVD3(v)   (((v) << 23) & BM_DRAM_CTL178_RSVD3)
/* --- Register HW_DRAM_CTL178, field AXI4_CURRENT_BDW */

#define BP_DRAM_CTL178_AXI4_CURRENT_BDW      16
#define BM_DRAM_CTL178_AXI4_CURRENT_BDW      0x007F0000

#define BF_DRAM_CTL178_AXI4_CURRENT_BDW(v)   (((v) << 16) & BM_DRAM_CTL178_AXI4_CURRENT_BDW)
/* --- Register HW_DRAM_CTL178, field RSVD2 */

#define BP_DRAM_CTL178_RSVD2      15
#define BM_DRAM_CTL178_RSVD2      0x00008000

#define BF_DRAM_CTL178_RSVD2(v)   (((v) << 15) & BM_DRAM_CTL178_RSVD2)
/* --- Register HW_DRAM_CTL178, field AXI4_BDW */

#define BP_DRAM_CTL178_AXI4_BDW      8
#define BM_DRAM_CTL178_AXI4_BDW      0x00007F00

#define BF_DRAM_CTL178_AXI4_BDW(v)   (((v) << 8) & BM_DRAM_CTL178_AXI4_BDW)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL178_AXI4_BDW(v)   BF_CS1(DRAM_CTL178, AXI4_BDW, v)
#endif

/* --- Register HW_DRAM_CTL178, field RSVD1 */

#define BP_DRAM_CTL178_RSVD1      5
#define BM_DRAM_CTL178_RSVD1      0x000000E0

#define BF_DRAM_CTL178_RSVD1(v)   (((v) << 5) & BM_DRAM_CTL178_RSVD1)
/* --- Register HW_DRAM_CTL178, field TCKESR */

#define BP_DRAM_CTL178_TCKESR      0
#define BM_DRAM_CTL178_TCKESR      0x0000001F

#define BF_DRAM_CTL178_TCKESR(v)   (((v) << 0) & BM_DRAM_CTL178_TCKESR)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL178_TCKESR(v)   BF_CS1(DRAM_CTL178, TCKESR, v)
#endif



/*
 * HW_DRAM_CTL179 - DRAM Control Register 179
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned AXI5_CURRENT_BDW   :  7;
        unsigned RSVD1              :  1;
        unsigned TDFI_PHYUPD_TYPE1  : 14;
        unsigned RSVD2              :  2;
        unsigned RSVD3              :  8;
    } B;
} hw_dram_ctl179_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL179 register
 */
#define HW_DRAM_CTL179_ADDR         (REGS_DRAM_BASE + 0x2cc)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL179           (*(volatile hw_dram_ctl179_t *) HW_DRAM_CTL179_ADDR)
#define HW_DRAM_CTL179_RD()      (HW_DRAM_CTL179.U)
#define HW_DRAM_CTL179_WR(v)     (HW_DRAM_CTL179.U = (v))
#define HW_DRAM_CTL179_SET(v)    (HW_DRAM_CTL179_WR(HW_DRAM_CTL179_RD() |  (v)))
#define HW_DRAM_CTL179_CLR(v)    (HW_DRAM_CTL179_WR(HW_DRAM_CTL179_RD() & ~(v)))
#define HW_DRAM_CTL179_TOG(v)    (HW_DRAM_CTL179_WR(HW_DRAM_CTL179_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL179 bitfields
 */
/* --- Register HW_DRAM_CTL179, field RSVD3 */

#define BP_DRAM_CTL179_RSVD3      24
#define BM_DRAM_CTL179_RSVD3      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL179_RSVD3(v)   ((((reg32_t) v) << 24) & BM_DRAM_CTL179_RSVD3)
#else
#define BF_DRAM_CTL179_RSVD3(v)   (((v) << 24) & BM_DRAM_CTL179_RSVD3)
#endif
/* --- Register HW_DRAM_CTL179, field RSVD2 */

#define BP_DRAM_CTL179_RSVD2      22
#define BM_DRAM_CTL179_RSVD2      0x00C00000

#define BF_DRAM_CTL179_RSVD2(v)   (((v) << 22) & BM_DRAM_CTL179_RSVD2)
/* --- Register HW_DRAM_CTL179, field TDFI_PHYUPD_TYPE1 */

#define BP_DRAM_CTL179_TDFI_PHYUPD_TYPE1      8
#define BM_DRAM_CTL179_TDFI_PHYUPD_TYPE1      0x003FFF00

#define BF_DRAM_CTL179_TDFI_PHYUPD_TYPE1(v)   (((v) << 8) & BM_DRAM_CTL179_TDFI_PHYUPD_TYPE1)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL179_TDFI_PHYUPD_TYPE1(v)   BF_CS1(DRAM_CTL179, TDFI_PHYUPD_TYPE1, v)
#endif

/* --- Register HW_DRAM_CTL179, field RSVD1 */

#define BP_DRAM_CTL179_RSVD1      7
#define BM_DRAM_CTL179_RSVD1      0x00000080

#define BF_DRAM_CTL179_RSVD1(v)   (((v) << 7) & BM_DRAM_CTL179_RSVD1)
/* --- Register HW_DRAM_CTL179, field AXI5_CURRENT_BDW */

#define BP_DRAM_CTL179_AXI5_CURRENT_BDW      0
#define BM_DRAM_CTL179_AXI5_CURRENT_BDW      0x0000007F

#define BF_DRAM_CTL179_AXI5_CURRENT_BDW(v)   (((v) << 0) & BM_DRAM_CTL179_AXI5_CURRENT_BDW)


/*
 * HW_DRAM_CTL180 - DRAM Control Register 180
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TDFI_PHYUPD_TYPE2  : 14;
        unsigned RSVD1              :  2;
        unsigned TDFI_PHYUPD_TYPE3  : 14;
        unsigned RSVD2              :  2;
    } B;
} hw_dram_ctl180_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL180 register
 */
#define HW_DRAM_CTL180_ADDR         (REGS_DRAM_BASE + 0x2d0)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL180           (*(volatile hw_dram_ctl180_t *) HW_DRAM_CTL180_ADDR)
#define HW_DRAM_CTL180_RD()      (HW_DRAM_CTL180.U)
#define HW_DRAM_CTL180_WR(v)     (HW_DRAM_CTL180.U = (v))
#define HW_DRAM_CTL180_SET(v)    (HW_DRAM_CTL180_WR(HW_DRAM_CTL180_RD() |  (v)))
#define HW_DRAM_CTL180_CLR(v)    (HW_DRAM_CTL180_WR(HW_DRAM_CTL180_RD() & ~(v)))
#define HW_DRAM_CTL180_TOG(v)    (HW_DRAM_CTL180_WR(HW_DRAM_CTL180_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL180 bitfields
 */
/* --- Register HW_DRAM_CTL180, field RSVD2 */

#define BP_DRAM_CTL180_RSVD2      30
#define BM_DRAM_CTL180_RSVD2      0xC0000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL180_RSVD2(v)   ((((reg32_t) v) << 30) & BM_DRAM_CTL180_RSVD2)
#else
#define BF_DRAM_CTL180_RSVD2(v)   (((v) << 30) & BM_DRAM_CTL180_RSVD2)
#endif
/* --- Register HW_DRAM_CTL180, field TDFI_PHYUPD_TYPE3 */

#define BP_DRAM_CTL180_TDFI_PHYUPD_TYPE3      16
#define BM_DRAM_CTL180_TDFI_PHYUPD_TYPE3      0x3FFF0000

#define BF_DRAM_CTL180_TDFI_PHYUPD_TYPE3(v)   (((v) << 16) & BM_DRAM_CTL180_TDFI_PHYUPD_TYPE3)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL180_TDFI_PHYUPD_TYPE3(v)   BF_CS1(DRAM_CTL180, TDFI_PHYUPD_TYPE3, v)
#endif

/* --- Register HW_DRAM_CTL180, field RSVD1 */

#define BP_DRAM_CTL180_RSVD1      14
#define BM_DRAM_CTL180_RSVD1      0x0000C000

#define BF_DRAM_CTL180_RSVD1(v)   (((v) << 14) & BM_DRAM_CTL180_RSVD1)
/* --- Register HW_DRAM_CTL180, field TDFI_PHYUPD_TYPE2 */

#define BP_DRAM_CTL180_TDFI_PHYUPD_TYPE2      0
#define BM_DRAM_CTL180_TDFI_PHYUPD_TYPE2      0x00003FFF

#define BF_DRAM_CTL180_TDFI_PHYUPD_TYPE2(v)   (((v) << 0) & BM_DRAM_CTL180_TDFI_PHYUPD_TYPE2)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL180_TDFI_PHYUPD_TYPE2(v)   BF_CS1(DRAM_CTL180, TDFI_PHYUPD_TYPE2, v)
#endif



/*
 * HW_DRAM_CTL181 - DRAM Control Register 181
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned MR0_DATA_0  : 15;
        unsigned RSVD1       :  1;
        unsigned MR0_DATA_1  : 15;
        unsigned RSVD2       :  1;
    } B;
} hw_dram_ctl181_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL181 register
 */
#define HW_DRAM_CTL181_ADDR         (REGS_DRAM_BASE + 0x2d4)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL181           (*(volatile hw_dram_ctl181_t *) HW_DRAM_CTL181_ADDR)
#define HW_DRAM_CTL181_RD()      (HW_DRAM_CTL181.U)
#define HW_DRAM_CTL181_WR(v)     (HW_DRAM_CTL181.U = (v))
#define HW_DRAM_CTL181_SET(v)    (HW_DRAM_CTL181_WR(HW_DRAM_CTL181_RD() |  (v)))
#define HW_DRAM_CTL181_CLR(v)    (HW_DRAM_CTL181_WR(HW_DRAM_CTL181_RD() & ~(v)))
#define HW_DRAM_CTL181_TOG(v)    (HW_DRAM_CTL181_WR(HW_DRAM_CTL181_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL181 bitfields
 */
/* --- Register HW_DRAM_CTL181, field RSVD2 */

#define BP_DRAM_CTL181_RSVD2      31
#define BM_DRAM_CTL181_RSVD2      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL181_RSVD2(v)   ((((reg32_t) v) << 31) & BM_DRAM_CTL181_RSVD2)
#else
#define BF_DRAM_CTL181_RSVD2(v)   (((v) << 31) & BM_DRAM_CTL181_RSVD2)
#endif
/* --- Register HW_DRAM_CTL181, field MR0_DATA_1 */

#define BP_DRAM_CTL181_MR0_DATA_1      16
#define BM_DRAM_CTL181_MR0_DATA_1      0x7FFF0000

#define BF_DRAM_CTL181_MR0_DATA_1(v)   (((v) << 16) & BM_DRAM_CTL181_MR0_DATA_1)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL181_MR0_DATA_1(v)   BF_CS1(DRAM_CTL181, MR0_DATA_1, v)
#endif

/* --- Register HW_DRAM_CTL181, field RSVD1 */

#define BP_DRAM_CTL181_RSVD1      15
#define BM_DRAM_CTL181_RSVD1      0x00008000

#define BF_DRAM_CTL181_RSVD1(v)   (((v) << 15) & BM_DRAM_CTL181_RSVD1)
/* --- Register HW_DRAM_CTL181, field MR0_DATA_0 */

#define BP_DRAM_CTL181_MR0_DATA_0      0
#define BM_DRAM_CTL181_MR0_DATA_0      0x00007FFF

#define BF_DRAM_CTL181_MR0_DATA_0(v)   (((v) << 0) & BM_DRAM_CTL181_MR0_DATA_0)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL181_MR0_DATA_0(v)   BF_CS1(DRAM_CTL181, MR0_DATA_0, v)
#endif



/*
 * HW_DRAM_CTL182 - DRAM Control Register 182
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned MR0_DATA_2  : 15;
        unsigned RSVD1       :  1;
        unsigned MR0_DATA_3  : 15;
        unsigned RSVD2       :  1;
    } B;
} hw_dram_ctl182_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL182 register
 */
#define HW_DRAM_CTL182_ADDR         (REGS_DRAM_BASE + 0x2d8)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL182           (*(volatile hw_dram_ctl182_t *) HW_DRAM_CTL182_ADDR)
#define HW_DRAM_CTL182_RD()      (HW_DRAM_CTL182.U)
#define HW_DRAM_CTL182_WR(v)     (HW_DRAM_CTL182.U = (v))
#define HW_DRAM_CTL182_SET(v)    (HW_DRAM_CTL182_WR(HW_DRAM_CTL182_RD() |  (v)))
#define HW_DRAM_CTL182_CLR(v)    (HW_DRAM_CTL182_WR(HW_DRAM_CTL182_RD() & ~(v)))
#define HW_DRAM_CTL182_TOG(v)    (HW_DRAM_CTL182_WR(HW_DRAM_CTL182_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL182 bitfields
 */
/* --- Register HW_DRAM_CTL182, field RSVD2 */

#define BP_DRAM_CTL182_RSVD2      31
#define BM_DRAM_CTL182_RSVD2      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL182_RSVD2(v)   ((((reg32_t) v) << 31) & BM_DRAM_CTL182_RSVD2)
#else
#define BF_DRAM_CTL182_RSVD2(v)   (((v) << 31) & BM_DRAM_CTL182_RSVD2)
#endif
/* --- Register HW_DRAM_CTL182, field MR0_DATA_3 */

#define BP_DRAM_CTL182_MR0_DATA_3      16
#define BM_DRAM_CTL182_MR0_DATA_3      0x7FFF0000

#define BF_DRAM_CTL182_MR0_DATA_3(v)   (((v) << 16) & BM_DRAM_CTL182_MR0_DATA_3)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL182_MR0_DATA_3(v)   BF_CS1(DRAM_CTL182, MR0_DATA_3, v)
#endif

/* --- Register HW_DRAM_CTL182, field RSVD1 */

#define BP_DRAM_CTL182_RSVD1      15
#define BM_DRAM_CTL182_RSVD1      0x00008000

#define BF_DRAM_CTL182_RSVD1(v)   (((v) << 15) & BM_DRAM_CTL182_RSVD1)
/* --- Register HW_DRAM_CTL182, field MR0_DATA_2 */

#define BP_DRAM_CTL182_MR0_DATA_2      0
#define BM_DRAM_CTL182_MR0_DATA_2      0x00007FFF

#define BF_DRAM_CTL182_MR0_DATA_2(v)   (((v) << 0) & BM_DRAM_CTL182_MR0_DATA_2)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL182_MR0_DATA_2(v)   BF_CS1(DRAM_CTL182, MR0_DATA_2, v)
#endif



/*
 * HW_DRAM_CTL183 - DRAM Control Register 183
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned MR1_DATA_0  : 15;
        unsigned RSVD1       :  1;
        unsigned MR1_DATA_1  : 15;
        unsigned RSVD2       :  1;
    } B;
} hw_dram_ctl183_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL183 register
 */
#define HW_DRAM_CTL183_ADDR         (REGS_DRAM_BASE + 0x2dc)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL183           (*(volatile hw_dram_ctl183_t *) HW_DRAM_CTL183_ADDR)
#define HW_DRAM_CTL183_RD()      (HW_DRAM_CTL183.U)
#define HW_DRAM_CTL183_WR(v)     (HW_DRAM_CTL183.U = (v))
#define HW_DRAM_CTL183_SET(v)    (HW_DRAM_CTL183_WR(HW_DRAM_CTL183_RD() |  (v)))
#define HW_DRAM_CTL183_CLR(v)    (HW_DRAM_CTL183_WR(HW_DRAM_CTL183_RD() & ~(v)))
#define HW_DRAM_CTL183_TOG(v)    (HW_DRAM_CTL183_WR(HW_DRAM_CTL183_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL183 bitfields
 */
/* --- Register HW_DRAM_CTL183, field RSVD2 */

#define BP_DRAM_CTL183_RSVD2      31
#define BM_DRAM_CTL183_RSVD2      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL183_RSVD2(v)   ((((reg32_t) v) << 31) & BM_DRAM_CTL183_RSVD2)
#else
#define BF_DRAM_CTL183_RSVD2(v)   (((v) << 31) & BM_DRAM_CTL183_RSVD2)
#endif
/* --- Register HW_DRAM_CTL183, field MR1_DATA_1 */

#define BP_DRAM_CTL183_MR1_DATA_1      16
#define BM_DRAM_CTL183_MR1_DATA_1      0x7FFF0000

#define BF_DRAM_CTL183_MR1_DATA_1(v)   (((v) << 16) & BM_DRAM_CTL183_MR1_DATA_1)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL183_MR1_DATA_1(v)   BF_CS1(DRAM_CTL183, MR1_DATA_1, v)
#endif

/* --- Register HW_DRAM_CTL183, field RSVD1 */

#define BP_DRAM_CTL183_RSVD1      15
#define BM_DRAM_CTL183_RSVD1      0x00008000

#define BF_DRAM_CTL183_RSVD1(v)   (((v) << 15) & BM_DRAM_CTL183_RSVD1)
/* --- Register HW_DRAM_CTL183, field MR1_DATA_0 */

#define BP_DRAM_CTL183_MR1_DATA_0      0
#define BM_DRAM_CTL183_MR1_DATA_0      0x00007FFF

#define BF_DRAM_CTL183_MR1_DATA_0(v)   (((v) << 0) & BM_DRAM_CTL183_MR1_DATA_0)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL183_MR1_DATA_0(v)   BF_CS1(DRAM_CTL183, MR1_DATA_0, v)
#endif



/*
 * HW_DRAM_CTL184 - DRAM Control Register 184
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned MR1_DATA_2  : 15;
        unsigned RSVD1       :  1;
        unsigned MR1_DATA_3  : 15;
        unsigned RSVD2       :  1;
    } B;
} hw_dram_ctl184_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL184 register
 */
#define HW_DRAM_CTL184_ADDR         (REGS_DRAM_BASE + 0x2e0)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL184           (*(volatile hw_dram_ctl184_t *) HW_DRAM_CTL184_ADDR)
#define HW_DRAM_CTL184_RD()      (HW_DRAM_CTL184.U)
#define HW_DRAM_CTL184_WR(v)     (HW_DRAM_CTL184.U = (v))
#define HW_DRAM_CTL184_SET(v)    (HW_DRAM_CTL184_WR(HW_DRAM_CTL184_RD() |  (v)))
#define HW_DRAM_CTL184_CLR(v)    (HW_DRAM_CTL184_WR(HW_DRAM_CTL184_RD() & ~(v)))
#define HW_DRAM_CTL184_TOG(v)    (HW_DRAM_CTL184_WR(HW_DRAM_CTL184_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL184 bitfields
 */
/* --- Register HW_DRAM_CTL184, field RSVD2 */

#define BP_DRAM_CTL184_RSVD2      31
#define BM_DRAM_CTL184_RSVD2      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL184_RSVD2(v)   ((((reg32_t) v) << 31) & BM_DRAM_CTL184_RSVD2)
#else
#define BF_DRAM_CTL184_RSVD2(v)   (((v) << 31) & BM_DRAM_CTL184_RSVD2)
#endif
/* --- Register HW_DRAM_CTL184, field MR1_DATA_3 */

#define BP_DRAM_CTL184_MR1_DATA_3      16
#define BM_DRAM_CTL184_MR1_DATA_3      0x7FFF0000

#define BF_DRAM_CTL184_MR1_DATA_3(v)   (((v) << 16) & BM_DRAM_CTL184_MR1_DATA_3)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL184_MR1_DATA_3(v)   BF_CS1(DRAM_CTL184, MR1_DATA_3, v)
#endif

/* --- Register HW_DRAM_CTL184, field RSVD1 */

#define BP_DRAM_CTL184_RSVD1      15
#define BM_DRAM_CTL184_RSVD1      0x00008000

#define BF_DRAM_CTL184_RSVD1(v)   (((v) << 15) & BM_DRAM_CTL184_RSVD1)
/* --- Register HW_DRAM_CTL184, field MR1_DATA_2 */

#define BP_DRAM_CTL184_MR1_DATA_2      0
#define BM_DRAM_CTL184_MR1_DATA_2      0x00007FFF

#define BF_DRAM_CTL184_MR1_DATA_2(v)   (((v) << 0) & BM_DRAM_CTL184_MR1_DATA_2)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL184_MR1_DATA_2(v)   BF_CS1(DRAM_CTL184, MR1_DATA_2, v)
#endif



/*
 * HW_DRAM_CTL185 - DRAM Control Register 185
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned MR2_DATA_0  : 15;
        unsigned RSVD1       :  1;
        unsigned MR2_DATA_1  : 15;
        unsigned RSVD2       :  1;
    } B;
} hw_dram_ctl185_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL185 register
 */
#define HW_DRAM_CTL185_ADDR         (REGS_DRAM_BASE + 0x2e4)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL185           (*(volatile hw_dram_ctl185_t *) HW_DRAM_CTL185_ADDR)
#define HW_DRAM_CTL185_RD()      (HW_DRAM_CTL185.U)
#define HW_DRAM_CTL185_WR(v)     (HW_DRAM_CTL185.U = (v))
#define HW_DRAM_CTL185_SET(v)    (HW_DRAM_CTL185_WR(HW_DRAM_CTL185_RD() |  (v)))
#define HW_DRAM_CTL185_CLR(v)    (HW_DRAM_CTL185_WR(HW_DRAM_CTL185_RD() & ~(v)))
#define HW_DRAM_CTL185_TOG(v)    (HW_DRAM_CTL185_WR(HW_DRAM_CTL185_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL185 bitfields
 */
/* --- Register HW_DRAM_CTL185, field RSVD2 */

#define BP_DRAM_CTL185_RSVD2      31
#define BM_DRAM_CTL185_RSVD2      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL185_RSVD2(v)   ((((reg32_t) v) << 31) & BM_DRAM_CTL185_RSVD2)
#else
#define BF_DRAM_CTL185_RSVD2(v)   (((v) << 31) & BM_DRAM_CTL185_RSVD2)
#endif
/* --- Register HW_DRAM_CTL185, field MR2_DATA_1 */

#define BP_DRAM_CTL185_MR2_DATA_1      16
#define BM_DRAM_CTL185_MR2_DATA_1      0x7FFF0000

#define BF_DRAM_CTL185_MR2_DATA_1(v)   (((v) << 16) & BM_DRAM_CTL185_MR2_DATA_1)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL185_MR2_DATA_1(v)   BF_CS1(DRAM_CTL185, MR2_DATA_1, v)
#endif

/* --- Register HW_DRAM_CTL185, field RSVD1 */

#define BP_DRAM_CTL185_RSVD1      15
#define BM_DRAM_CTL185_RSVD1      0x00008000

#define BF_DRAM_CTL185_RSVD1(v)   (((v) << 15) & BM_DRAM_CTL185_RSVD1)
/* --- Register HW_DRAM_CTL185, field MR2_DATA_0 */

#define BP_DRAM_CTL185_MR2_DATA_0      0
#define BM_DRAM_CTL185_MR2_DATA_0      0x00007FFF

#define BF_DRAM_CTL185_MR2_DATA_0(v)   (((v) << 0) & BM_DRAM_CTL185_MR2_DATA_0)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL185_MR2_DATA_0(v)   BF_CS1(DRAM_CTL185, MR2_DATA_0, v)
#endif



/*
 * HW_DRAM_CTL186 - DRAM Control Register 186
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned MR2_DATA_2  : 15;
        unsigned RSVD1       :  1;
        unsigned MR2_DATA_3  : 15;
        unsigned RSVD2       :  1;
    } B;
} hw_dram_ctl186_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL186 register
 */
#define HW_DRAM_CTL186_ADDR         (REGS_DRAM_BASE + 0x2e8)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL186           (*(volatile hw_dram_ctl186_t *) HW_DRAM_CTL186_ADDR)
#define HW_DRAM_CTL186_RD()      (HW_DRAM_CTL186.U)
#define HW_DRAM_CTL186_WR(v)     (HW_DRAM_CTL186.U = (v))
#define HW_DRAM_CTL186_SET(v)    (HW_DRAM_CTL186_WR(HW_DRAM_CTL186_RD() |  (v)))
#define HW_DRAM_CTL186_CLR(v)    (HW_DRAM_CTL186_WR(HW_DRAM_CTL186_RD() & ~(v)))
#define HW_DRAM_CTL186_TOG(v)    (HW_DRAM_CTL186_WR(HW_DRAM_CTL186_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL186 bitfields
 */
/* --- Register HW_DRAM_CTL186, field RSVD2 */

#define BP_DRAM_CTL186_RSVD2      31
#define BM_DRAM_CTL186_RSVD2      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL186_RSVD2(v)   ((((reg32_t) v) << 31) & BM_DRAM_CTL186_RSVD2)
#else
#define BF_DRAM_CTL186_RSVD2(v)   (((v) << 31) & BM_DRAM_CTL186_RSVD2)
#endif
/* --- Register HW_DRAM_CTL186, field MR2_DATA_3 */

#define BP_DRAM_CTL186_MR2_DATA_3      16
#define BM_DRAM_CTL186_MR2_DATA_3      0x7FFF0000

#define BF_DRAM_CTL186_MR2_DATA_3(v)   (((v) << 16) & BM_DRAM_CTL186_MR2_DATA_3)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL186_MR2_DATA_3(v)   BF_CS1(DRAM_CTL186, MR2_DATA_3, v)
#endif

/* --- Register HW_DRAM_CTL186, field RSVD1 */

#define BP_DRAM_CTL186_RSVD1      15
#define BM_DRAM_CTL186_RSVD1      0x00008000

#define BF_DRAM_CTL186_RSVD1(v)   (((v) << 15) & BM_DRAM_CTL186_RSVD1)
/* --- Register HW_DRAM_CTL186, field MR2_DATA_2 */

#define BP_DRAM_CTL186_MR2_DATA_2      0
#define BM_DRAM_CTL186_MR2_DATA_2      0x00007FFF

#define BF_DRAM_CTL186_MR2_DATA_2(v)   (((v) << 0) & BM_DRAM_CTL186_MR2_DATA_2)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL186_MR2_DATA_2(v)   BF_CS1(DRAM_CTL186, MR2_DATA_2, v)
#endif



/*
 * HW_DRAM_CTL187 - DRAM Control Register 187
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned MR3_DATA_0  : 15;
        unsigned RSVD1       :  1;
        unsigned MR3_DATA_1  : 15;
        unsigned RSVD2       :  1;
    } B;
} hw_dram_ctl187_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL187 register
 */
#define HW_DRAM_CTL187_ADDR         (REGS_DRAM_BASE + 0x2ec)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL187           (*(volatile hw_dram_ctl187_t *) HW_DRAM_CTL187_ADDR)
#define HW_DRAM_CTL187_RD()      (HW_DRAM_CTL187.U)
#define HW_DRAM_CTL187_WR(v)     (HW_DRAM_CTL187.U = (v))
#define HW_DRAM_CTL187_SET(v)    (HW_DRAM_CTL187_WR(HW_DRAM_CTL187_RD() |  (v)))
#define HW_DRAM_CTL187_CLR(v)    (HW_DRAM_CTL187_WR(HW_DRAM_CTL187_RD() & ~(v)))
#define HW_DRAM_CTL187_TOG(v)    (HW_DRAM_CTL187_WR(HW_DRAM_CTL187_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL187 bitfields
 */
/* --- Register HW_DRAM_CTL187, field RSVD2 */

#define BP_DRAM_CTL187_RSVD2      31
#define BM_DRAM_CTL187_RSVD2      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL187_RSVD2(v)   ((((reg32_t) v) << 31) & BM_DRAM_CTL187_RSVD2)
#else
#define BF_DRAM_CTL187_RSVD2(v)   (((v) << 31) & BM_DRAM_CTL187_RSVD2)
#endif
/* --- Register HW_DRAM_CTL187, field MR3_DATA_1 */

#define BP_DRAM_CTL187_MR3_DATA_1      16
#define BM_DRAM_CTL187_MR3_DATA_1      0x7FFF0000

#define BF_DRAM_CTL187_MR3_DATA_1(v)   (((v) << 16) & BM_DRAM_CTL187_MR3_DATA_1)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL187_MR3_DATA_1(v)   BF_CS1(DRAM_CTL187, MR3_DATA_1, v)
#endif

/* --- Register HW_DRAM_CTL187, field RSVD1 */

#define BP_DRAM_CTL187_RSVD1      15
#define BM_DRAM_CTL187_RSVD1      0x00008000

#define BF_DRAM_CTL187_RSVD1(v)   (((v) << 15) & BM_DRAM_CTL187_RSVD1)
/* --- Register HW_DRAM_CTL187, field MR3_DATA_0 */

#define BP_DRAM_CTL187_MR3_DATA_0      0
#define BM_DRAM_CTL187_MR3_DATA_0      0x00007FFF

#define BF_DRAM_CTL187_MR3_DATA_0(v)   (((v) << 0) & BM_DRAM_CTL187_MR3_DATA_0)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL187_MR3_DATA_0(v)   BF_CS1(DRAM_CTL187, MR3_DATA_0, v)
#endif



/*
 * HW_DRAM_CTL188 - DRAM Control Register 188
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned MR3_DATA_2  : 15;
        unsigned RSVD1       :  1;
        unsigned MR3_DATA_3  : 15;
        unsigned RSVD2       :  1;
    } B;
} hw_dram_ctl188_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL188 register
 */
#define HW_DRAM_CTL188_ADDR         (REGS_DRAM_BASE + 0x2f0)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL188           (*(volatile hw_dram_ctl188_t *) HW_DRAM_CTL188_ADDR)
#define HW_DRAM_CTL188_RD()      (HW_DRAM_CTL188.U)
#define HW_DRAM_CTL188_WR(v)     (HW_DRAM_CTL188.U = (v))
#define HW_DRAM_CTL188_SET(v)    (HW_DRAM_CTL188_WR(HW_DRAM_CTL188_RD() |  (v)))
#define HW_DRAM_CTL188_CLR(v)    (HW_DRAM_CTL188_WR(HW_DRAM_CTL188_RD() & ~(v)))
#define HW_DRAM_CTL188_TOG(v)    (HW_DRAM_CTL188_WR(HW_DRAM_CTL188_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL188 bitfields
 */
/* --- Register HW_DRAM_CTL188, field RSVD2 */

#define BP_DRAM_CTL188_RSVD2      31
#define BM_DRAM_CTL188_RSVD2      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL188_RSVD2(v)   ((((reg32_t) v) << 31) & BM_DRAM_CTL188_RSVD2)
#else
#define BF_DRAM_CTL188_RSVD2(v)   (((v) << 31) & BM_DRAM_CTL188_RSVD2)
#endif
/* --- Register HW_DRAM_CTL188, field MR3_DATA_3 */

#define BP_DRAM_CTL188_MR3_DATA_3      16
#define BM_DRAM_CTL188_MR3_DATA_3      0x7FFF0000

#define BF_DRAM_CTL188_MR3_DATA_3(v)   (((v) << 16) & BM_DRAM_CTL188_MR3_DATA_3)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL188_MR3_DATA_3(v)   BF_CS1(DRAM_CTL188, MR3_DATA_3, v)
#endif

/* --- Register HW_DRAM_CTL188, field RSVD1 */

#define BP_DRAM_CTL188_RSVD1      15
#define BM_DRAM_CTL188_RSVD1      0x00008000

#define BF_DRAM_CTL188_RSVD1(v)   (((v) << 15) & BM_DRAM_CTL188_RSVD1)
/* --- Register HW_DRAM_CTL188, field MR3_DATA_2 */

#define BP_DRAM_CTL188_MR3_DATA_2      0
#define BM_DRAM_CTL188_MR3_DATA_2      0x00007FFF

#define BF_DRAM_CTL188_MR3_DATA_2(v)   (((v) << 0) & BM_DRAM_CTL188_MR3_DATA_2)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL188_MR3_DATA_2(v)   BF_CS1(DRAM_CTL188, MR3_DATA_2, v)
#endif



/*
 * HW_DRAM_CTL189 - DRAM Control Register 189
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned AXI4_EN_SIZE_LT_WIDTH_INSTR  : 16;
        unsigned AXI5_EN_SIZE_LT_WIDTH_INSTR  : 16;
    } B;
} hw_dram_ctl189_t;
#endif

/*
 * constants & macros for entire HW_DRAM_CTL189 register
 */
#define HW_DRAM_CTL189_ADDR         (REGS_DRAM_BASE + 0x2f4)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL189           (*(volatile hw_dram_ctl189_t *) HW_DRAM_CTL189_ADDR)
#define HW_DRAM_CTL189_RD()      (HW_DRAM_CTL189.U)
#define HW_DRAM_CTL189_WR(v)     (HW_DRAM_CTL189.U = (v))
#define HW_DRAM_CTL189_SET(v)    (HW_DRAM_CTL189_WR(HW_DRAM_CTL189_RD() |  (v)))
#define HW_DRAM_CTL189_CLR(v)    (HW_DRAM_CTL189_WR(HW_DRAM_CTL189_RD() & ~(v)))
#define HW_DRAM_CTL189_TOG(v)    (HW_DRAM_CTL189_WR(HW_DRAM_CTL189_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DRAM_CTL189 bitfields
 */
/* --- Register HW_DRAM_CTL189, field AXI5_EN_SIZE_LT_WIDTH_INSTR */

#define BP_DRAM_CTL189_AXI5_EN_SIZE_LT_WIDTH_INSTR      16
#define BM_DRAM_CTL189_AXI5_EN_SIZE_LT_WIDTH_INSTR      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL189_AXI5_EN_SIZE_LT_WIDTH_INSTR(v)   ((((reg32_t) v) << 16) & BM_DRAM_CTL189_AXI5_EN_SIZE_LT_WIDTH_INSTR)
#else
#define BF_DRAM_CTL189_AXI5_EN_SIZE_LT_WIDTH_INSTR(v)   (((v) << 16) & BM_DRAM_CTL189_AXI5_EN_SIZE_LT_WIDTH_INSTR)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL189_AXI5_EN_SIZE_LT_WIDTH_INSTR(v)   (HW_DRAM_CTL189.B.AXI5_EN_SIZE_LT_WIDTH_INSTR = (v))
#endif

/* --- Register HW_DRAM_CTL189, field AXI4_EN_SIZE_LT_WIDTH_INSTR */

#define BP_DRAM_CTL189_AXI4_EN_SIZE_LT_WIDTH_INSTR      0
#define BM_DRAM_CTL189_AXI4_EN_SIZE_LT_WIDTH_INSTR      0x0000FFFF

#define BF_DRAM_CTL189_AXI4_EN_SIZE_LT_WIDTH_INSTR(v)   (((v) << 0) & BM_DRAM_CTL189_AXI4_EN_SIZE_LT_WIDTH_INSTR)
#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL189_AXI4_EN_SIZE_LT_WIDTH_INSTR(v)   (HW_DRAM_CTL189.B.AXI4_EN_SIZE_LT_WIDTH_INSTR = (v))
#endif


#endif /* _DRAM_H */

////////////////////////////////////////////////////////////////////////////////
