/*
 * Copyright 2008-2009 Freescale Semiconductor, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

 * WARNING!  THIS FILE IS AUTOMATICALLY GENERATED FROM XML.
 *                DO NOT MODIFY THIS FILE DIRECTLY.
 *
 * Xml Revision: 1.0
 *
 * Template revision: 26195
 *
 *
 * The following naming conventions are followed in this file.
 *      XX_<module>_<regname>_<field>
 *
 * XX specifies the define / macro class
 *      HW pertains to a register
 *      BM indicates a Bit Mask
 *      BF indicates a Bit Field macro
 *
 * <module> is the hardware module name which can be any of the following...
 *      USB20 (Note when there is more than one copy of a given module, the
 *      module name includes a number starting from 0 for the first instance
 *      of that module)
 *
 * <regname> is the specific register within that module
 *
 * <field> is the specific bitfield within that <module>_<register>
 *
 * We also define the following...
 *      hw_<module>_<regname>_t is typedef of anonymous union
 *
 */

#ifndef _HSADC_H
#define _HSADC_H  1

#include "regs.h"

#ifndef REGS_HSADC_BASE
#define REGS_HSADC_BASE (REGS_BASE + 0x2000)
#endif

/*
 * HW_HSADC_CTRL0 - HSADC Control Register 0
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned HSADC_RUN                  :  1;
        unsigned TRIGGER_DELAY_CYCLES       :  5;
        unsigned HSADC_PRESENT              :  1;
        unsigned RSRVD0                     :  5;
        unsigned ADC_SAMPLE_SHIFT_BITS_NUM  :  3;
        unsigned ADC_SAMPLE_HALFWORD_SWAP   :  1;
        unsigned ADC_SAMPLE_ENDIAN          :  1;
        unsigned ADC_SAMPLE_PRECISION       :  2;
        unsigned DISCARD                    :  2;
        unsigned RSRVD1                     :  6;
        unsigned SOFTWARE_TRIGGER           :  1;
        unsigned TRIGGER_SOURCE             :  2;
        unsigned CLKGATE                    :  1;
        unsigned SFTRST                     :  1;
    } B;
} hw_hsadc_ctrl0_t;
#endif

/*
 * constants & macros for entire HW_HSADC_CTRL0 register
 */
#define HW_HSADC_CTRL0_ADDR         (REGS_HSADC_BASE + 0x0)
#define HW_HSADC_CTRL0_SET_ADDR     (HW_HSADC_CTRL0_ADDR + 4)
#define HW_HSADC_CTRL0_CLR_ADDR     (HW_HSADC_CTRL0_ADDR + 8)
#define HW_HSADC_CTRL0_TOG_ADDR     (HW_HSADC_CTRL0_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_HSADC_CTRL0           (*(volatile hw_hsadc_ctrl0_t *) HW_HSADC_CTRL0_ADDR)
#define HW_HSADC_CTRL0_RD()      (HW_HSADC_CTRL0.U)
#define HW_HSADC_CTRL0_WR(v)     (HW_HSADC_CTRL0.U = (v))
#define HW_HSADC_CTRL0_SET(v)    ((*(volatile reg32_t *) HW_HSADC_CTRL0_SET_ADDR) = (v))
#define HW_HSADC_CTRL0_CLR(v)    ((*(volatile reg32_t *) HW_HSADC_CTRL0_CLR_ADDR) = (v))
#define HW_HSADC_CTRL0_TOG(v)    ((*(volatile reg32_t *) HW_HSADC_CTRL0_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_HSADC_CTRL0 bitfields
 */
/* --- Register HW_HSADC_CTRL0, field SFTRST */

#define BP_HSADC_CTRL0_SFTRST      31
#define BM_HSADC_CTRL0_SFTRST      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_HSADC_CTRL0_SFTRST(v)   ((((reg32_t) v) << 31) & BM_HSADC_CTRL0_SFTRST)
#else
#define BF_HSADC_CTRL0_SFTRST(v)   (((v) << 31) & BM_HSADC_CTRL0_SFTRST)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_HSADC_CTRL0_SFTRST(v)   BF_CS1(HSADC_CTRL0, SFTRST, v)
#endif

/* --- Register HW_HSADC_CTRL0, field CLKGATE */

#define BP_HSADC_CTRL0_CLKGATE      30
#define BM_HSADC_CTRL0_CLKGATE      0x40000000

#define BF_HSADC_CTRL0_CLKGATE(v)   (((v) << 30) & BM_HSADC_CTRL0_CLKGATE)
#ifndef __LANGUAGE_ASM__
#define BW_HSADC_CTRL0_CLKGATE(v)   BF_CS1(HSADC_CTRL0, CLKGATE, v)
#endif

/* --- Register HW_HSADC_CTRL0, field TRIGGER_SOURCE */

#define BP_HSADC_CTRL0_TRIGGER_SOURCE      28
#define BM_HSADC_CTRL0_TRIGGER_SOURCE      0x30000000

#define BF_HSADC_CTRL0_TRIGGER_SOURCE(v)   (((v) << 28) & BM_HSADC_CTRL0_TRIGGER_SOURCE)
#ifndef __LANGUAGE_ASM__
#define BW_HSADC_CTRL0_TRIGGER_SOURCE(v)   BF_CS1(HSADC_CTRL0, TRIGGER_SOURCE, v)
#endif

/* --- Register HW_HSADC_CTRL0, field SOFTWARE_TRIGGER */

#define BP_HSADC_CTRL0_SOFTWARE_TRIGGER      27
#define BM_HSADC_CTRL0_SOFTWARE_TRIGGER      0x08000000

#define BF_HSADC_CTRL0_SOFTWARE_TRIGGER(v)   (((v) << 27) & BM_HSADC_CTRL0_SOFTWARE_TRIGGER)
#ifndef __LANGUAGE_ASM__
#define BW_HSADC_CTRL0_SOFTWARE_TRIGGER(v)   BF_CS1(HSADC_CTRL0, SOFTWARE_TRIGGER, v)
#endif

/* --- Register HW_HSADC_CTRL0, field RSRVD1 */

#define BP_HSADC_CTRL0_RSRVD1      21
#define BM_HSADC_CTRL0_RSRVD1      0x07E00000

#define BF_HSADC_CTRL0_RSRVD1(v)   (((v) << 21) & BM_HSADC_CTRL0_RSRVD1)
/* --- Register HW_HSADC_CTRL0, field DISCARD */

#define BP_HSADC_CTRL0_DISCARD      19
#define BM_HSADC_CTRL0_DISCARD      0x00180000

#define BF_HSADC_CTRL0_DISCARD(v)   (((v) << 19) & BM_HSADC_CTRL0_DISCARD)
#ifndef __LANGUAGE_ASM__
#define BW_HSADC_CTRL0_DISCARD(v)   BF_CS1(HSADC_CTRL0, DISCARD, v)
#endif

/* --- Register HW_HSADC_CTRL0, field ADC_SAMPLE_PRECISION */

#define BP_HSADC_CTRL0_ADC_SAMPLE_PRECISION      17
#define BM_HSADC_CTRL0_ADC_SAMPLE_PRECISION      0x00060000

#define BF_HSADC_CTRL0_ADC_SAMPLE_PRECISION(v)   (((v) << 17) & BM_HSADC_CTRL0_ADC_SAMPLE_PRECISION)
#ifndef __LANGUAGE_ASM__
#define BW_HSADC_CTRL0_ADC_SAMPLE_PRECISION(v)   BF_CS1(HSADC_CTRL0, ADC_SAMPLE_PRECISION, v)
#endif

/* --- Register HW_HSADC_CTRL0, field ADC_SAMPLE_ENDIAN */

#define BP_HSADC_CTRL0_ADC_SAMPLE_ENDIAN      16
#define BM_HSADC_CTRL0_ADC_SAMPLE_ENDIAN      0x00010000

#define BF_HSADC_CTRL0_ADC_SAMPLE_ENDIAN(v)   (((v) << 16) & BM_HSADC_CTRL0_ADC_SAMPLE_ENDIAN)
#ifndef __LANGUAGE_ASM__
#define BW_HSADC_CTRL0_ADC_SAMPLE_ENDIAN(v)   BF_CS1(HSADC_CTRL0, ADC_SAMPLE_ENDIAN, v)
#endif

/* --- Register HW_HSADC_CTRL0, field ADC_SAMPLE_HALFWORD_SWAP */

#define BP_HSADC_CTRL0_ADC_SAMPLE_HALFWORD_SWAP      15
#define BM_HSADC_CTRL0_ADC_SAMPLE_HALFWORD_SWAP      0x00008000

#define BF_HSADC_CTRL0_ADC_SAMPLE_HALFWORD_SWAP(v)   (((v) << 15) & BM_HSADC_CTRL0_ADC_SAMPLE_HALFWORD_SWAP)
#ifndef __LANGUAGE_ASM__
#define BW_HSADC_CTRL0_ADC_SAMPLE_HALFWORD_SWAP(v)   BF_CS1(HSADC_CTRL0, ADC_SAMPLE_HALFWORD_SWAP, v)
#endif

/* --- Register HW_HSADC_CTRL0, field ADC_SAMPLE_SHIFT_BITS_NUM */

#define BP_HSADC_CTRL0_ADC_SAMPLE_SHIFT_BITS_NUM      12
#define BM_HSADC_CTRL0_ADC_SAMPLE_SHIFT_BITS_NUM      0x00007000

#define BF_HSADC_CTRL0_ADC_SAMPLE_SHIFT_BITS_NUM(v)   (((v) << 12) & BM_HSADC_CTRL0_ADC_SAMPLE_SHIFT_BITS_NUM)
#ifndef __LANGUAGE_ASM__
#define BW_HSADC_CTRL0_ADC_SAMPLE_SHIFT_BITS_NUM(v)   BF_CS1(HSADC_CTRL0, ADC_SAMPLE_SHIFT_BITS_NUM, v)
#endif

/* --- Register HW_HSADC_CTRL0, field RSRVD0 */

#define BP_HSADC_CTRL0_RSRVD0      7
#define BM_HSADC_CTRL0_RSRVD0      0x00000F80

#define BF_HSADC_CTRL0_RSRVD0(v)   (((v) << 7) & BM_HSADC_CTRL0_RSRVD0)
/* --- Register HW_HSADC_CTRL0, field HSADC_PRESENT */

#define BP_HSADC_CTRL0_HSADC_PRESENT      6
#define BM_HSADC_CTRL0_HSADC_PRESENT      0x00000040

#define BF_HSADC_CTRL0_HSADC_PRESENT(v)   (((v) << 6) & BM_HSADC_CTRL0_HSADC_PRESENT)
/* --- Register HW_HSADC_CTRL0, field TRIGGER_DELAY_CYCLES */

#define BP_HSADC_CTRL0_TRIGGER_DELAY_CYCLES      1
#define BM_HSADC_CTRL0_TRIGGER_DELAY_CYCLES      0x0000003E

#define BF_HSADC_CTRL0_TRIGGER_DELAY_CYCLES(v)   (((v) << 1) & BM_HSADC_CTRL0_TRIGGER_DELAY_CYCLES)
#ifndef __LANGUAGE_ASM__
#define BW_HSADC_CTRL0_TRIGGER_DELAY_CYCLES(v)   BF_CS1(HSADC_CTRL0, TRIGGER_DELAY_CYCLES, v)
#endif

/* --- Register HW_HSADC_CTRL0, field HSADC_RUN */

#define BP_HSADC_CTRL0_HSADC_RUN      0
#define BM_HSADC_CTRL0_HSADC_RUN      0x00000001

#define BF_HSADC_CTRL0_HSADC_RUN(v)   (((v) << 0) & BM_HSADC_CTRL0_HSADC_RUN)
#ifndef __LANGUAGE_ASM__
#define BW_HSADC_CTRL0_HSADC_RUN(v)   BF_CS1(HSADC_CTRL0, HSADC_RUN, v)
#endif



/*
 * HW_HSADC_CTRL1 - HSADC Control Register 1
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned INTERRUPT                          :  1;
        unsigned INTERRUPT_TIMEOUT_STATUS           :  1;
        unsigned INTERRUPT_FIFO_OVERFLOW_STATUS     :  1;
        unsigned INTERRUPT_ADC_DONE_STATUS          :  1;
        unsigned INTERRUPT_END_ONE_SEQUENCE_STATUS  :  1;
        unsigned FIFO_READ_EMPTY                    :  1;
        unsigned RSRVD1                             : 20;
        unsigned INTERRUPT_STATUS_CLR               :  1;
        unsigned INTERRUPT_CLR                      :  1;
        unsigned INTERRUPT_TIMEOUT_ENABLE           :  1;
        unsigned INTERRUPT_FIFO_OVERFLOW_ENABLE     :  1;
        unsigned INTERRUPT_ADC_DONE_ENABLE          :  1;
        unsigned INTERRUPT_END_ONE_SEQUENCE_ENABLE  :  1;
    } B;
} hw_hsadc_ctrl1_t;
#endif

/*
 * constants & macros for entire HW_HSADC_CTRL1 register
 */
#define HW_HSADC_CTRL1_ADDR         (REGS_HSADC_BASE + 0x10)
#define HW_HSADC_CTRL1_SET_ADDR     (HW_HSADC_CTRL1_ADDR + 4)
#define HW_HSADC_CTRL1_CLR_ADDR     (HW_HSADC_CTRL1_ADDR + 8)
#define HW_HSADC_CTRL1_TOG_ADDR     (HW_HSADC_CTRL1_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_HSADC_CTRL1           (*(volatile hw_hsadc_ctrl1_t *) HW_HSADC_CTRL1_ADDR)
#define HW_HSADC_CTRL1_RD()      (HW_HSADC_CTRL1.U)
#define HW_HSADC_CTRL1_WR(v)     (HW_HSADC_CTRL1.U = (v))
#define HW_HSADC_CTRL1_SET(v)    ((*(volatile reg32_t *) HW_HSADC_CTRL1_SET_ADDR) = (v))
#define HW_HSADC_CTRL1_CLR(v)    ((*(volatile reg32_t *) HW_HSADC_CTRL1_CLR_ADDR) = (v))
#define HW_HSADC_CTRL1_TOG(v)    ((*(volatile reg32_t *) HW_HSADC_CTRL1_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_HSADC_CTRL1 bitfields
 */
/* --- Register HW_HSADC_CTRL1, field INTERRUPT_END_ONE_SEQUENCE_ENABLE */

#define BP_HSADC_CTRL1_INTERRUPT_END_ONE_SEQUENCE_ENABLE      31
#define BM_HSADC_CTRL1_INTERRUPT_END_ONE_SEQUENCE_ENABLE      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_HSADC_CTRL1_INTERRUPT_END_ONE_SEQUENCE_ENABLE(v)   ((((reg32_t) v) << 31) & BM_HSADC_CTRL1_INTERRUPT_END_ONE_SEQUENCE_ENABLE)
#else
#define BF_HSADC_CTRL1_INTERRUPT_END_ONE_SEQUENCE_ENABLE(v)   (((v) << 31) & BM_HSADC_CTRL1_INTERRUPT_END_ONE_SEQUENCE_ENABLE)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_HSADC_CTRL1_INTERRUPT_END_ONE_SEQUENCE_ENABLE(v)   BF_CS1(HSADC_CTRL1, INTERRUPT_END_ONE_SEQUENCE_ENABLE, v)
#endif

/* --- Register HW_HSADC_CTRL1, field INTERRUPT_ADC_DONE_ENABLE */

#define BP_HSADC_CTRL1_INTERRUPT_ADC_DONE_ENABLE      30
#define BM_HSADC_CTRL1_INTERRUPT_ADC_DONE_ENABLE      0x40000000

#define BF_HSADC_CTRL1_INTERRUPT_ADC_DONE_ENABLE(v)   (((v) << 30) & BM_HSADC_CTRL1_INTERRUPT_ADC_DONE_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_HSADC_CTRL1_INTERRUPT_ADC_DONE_ENABLE(v)   BF_CS1(HSADC_CTRL1, INTERRUPT_ADC_DONE_ENABLE, v)
#endif

/* --- Register HW_HSADC_CTRL1, field INTERRUPT_FIFO_OVERFLOW_ENABLE */

#define BP_HSADC_CTRL1_INTERRUPT_FIFO_OVERFLOW_ENABLE      29
#define BM_HSADC_CTRL1_INTERRUPT_FIFO_OVERFLOW_ENABLE      0x20000000

#define BF_HSADC_CTRL1_INTERRUPT_FIFO_OVERFLOW_ENABLE(v)   (((v) << 29) & BM_HSADC_CTRL1_INTERRUPT_FIFO_OVERFLOW_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_HSADC_CTRL1_INTERRUPT_FIFO_OVERFLOW_ENABLE(v)   BF_CS1(HSADC_CTRL1, INTERRUPT_FIFO_OVERFLOW_ENABLE, v)
#endif

/* --- Register HW_HSADC_CTRL1, field INTERRUPT_TIMEOUT_ENABLE */

#define BP_HSADC_CTRL1_INTERRUPT_TIMEOUT_ENABLE      28
#define BM_HSADC_CTRL1_INTERRUPT_TIMEOUT_ENABLE      0x10000000

#define BF_HSADC_CTRL1_INTERRUPT_TIMEOUT_ENABLE(v)   (((v) << 28) & BM_HSADC_CTRL1_INTERRUPT_TIMEOUT_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_HSADC_CTRL1_INTERRUPT_TIMEOUT_ENABLE(v)   BF_CS1(HSADC_CTRL1, INTERRUPT_TIMEOUT_ENABLE, v)
#endif

/* --- Register HW_HSADC_CTRL1, field INTERRUPT_CLR */

#define BP_HSADC_CTRL1_INTERRUPT_CLR      27
#define BM_HSADC_CTRL1_INTERRUPT_CLR      0x08000000

#define BF_HSADC_CTRL1_INTERRUPT_CLR(v)   (((v) << 27) & BM_HSADC_CTRL1_INTERRUPT_CLR)
#ifndef __LANGUAGE_ASM__
#define BW_HSADC_CTRL1_INTERRUPT_CLR(v)   BF_CS1(HSADC_CTRL1, INTERRUPT_CLR, v)
#endif

/* --- Register HW_HSADC_CTRL1, field INTERRUPT_STATUS_CLR */

#define BP_HSADC_CTRL1_INTERRUPT_STATUS_CLR      26
#define BM_HSADC_CTRL1_INTERRUPT_STATUS_CLR      0x04000000

#define BF_HSADC_CTRL1_INTERRUPT_STATUS_CLR(v)   (((v) << 26) & BM_HSADC_CTRL1_INTERRUPT_STATUS_CLR)
#ifndef __LANGUAGE_ASM__
#define BW_HSADC_CTRL1_INTERRUPT_STATUS_CLR(v)   BF_CS1(HSADC_CTRL1, INTERRUPT_STATUS_CLR, v)
#endif

/* --- Register HW_HSADC_CTRL1, field RSRVD1 */

#define BP_HSADC_CTRL1_RSRVD1      6
#define BM_HSADC_CTRL1_RSRVD1      0x03FFFFC0

#define BF_HSADC_CTRL1_RSRVD1(v)   (((v) << 6) & BM_HSADC_CTRL1_RSRVD1)
/* --- Register HW_HSADC_CTRL1, field FIFO_READ_EMPTY */

#define BP_HSADC_CTRL1_FIFO_READ_EMPTY      5
#define BM_HSADC_CTRL1_FIFO_READ_EMPTY      0x00000020

#define BF_HSADC_CTRL1_FIFO_READ_EMPTY(v)   (((v) << 5) & BM_HSADC_CTRL1_FIFO_READ_EMPTY)
/* --- Register HW_HSADC_CTRL1, field INTERRUPT_END_ONE_SEQUENCE_STATUS */

#define BP_HSADC_CTRL1_INTERRUPT_END_ONE_SEQUENCE_STATUS      4
#define BM_HSADC_CTRL1_INTERRUPT_END_ONE_SEQUENCE_STATUS      0x00000010

#define BF_HSADC_CTRL1_INTERRUPT_END_ONE_SEQUENCE_STATUS(v)   (((v) << 4) & BM_HSADC_CTRL1_INTERRUPT_END_ONE_SEQUENCE_STATUS)
/* --- Register HW_HSADC_CTRL1, field INTERRUPT_ADC_DONE_STATUS */

#define BP_HSADC_CTRL1_INTERRUPT_ADC_DONE_STATUS      3
#define BM_HSADC_CTRL1_INTERRUPT_ADC_DONE_STATUS      0x00000008

#define BF_HSADC_CTRL1_INTERRUPT_ADC_DONE_STATUS(v)   (((v) << 3) & BM_HSADC_CTRL1_INTERRUPT_ADC_DONE_STATUS)
/* --- Register HW_HSADC_CTRL1, field INTERRUPT_FIFO_OVERFLOW_STATUS */

#define BP_HSADC_CTRL1_INTERRUPT_FIFO_OVERFLOW_STATUS      2
#define BM_HSADC_CTRL1_INTERRUPT_FIFO_OVERFLOW_STATUS      0x00000004

#define BF_HSADC_CTRL1_INTERRUPT_FIFO_OVERFLOW_STATUS(v)   (((v) << 2) & BM_HSADC_CTRL1_INTERRUPT_FIFO_OVERFLOW_STATUS)
/* --- Register HW_HSADC_CTRL1, field INTERRUPT_TIMEOUT_STATUS */

#define BP_HSADC_CTRL1_INTERRUPT_TIMEOUT_STATUS      1
#define BM_HSADC_CTRL1_INTERRUPT_TIMEOUT_STATUS      0x00000002

#define BF_HSADC_CTRL1_INTERRUPT_TIMEOUT_STATUS(v)   (((v) << 1) & BM_HSADC_CTRL1_INTERRUPT_TIMEOUT_STATUS)
/* --- Register HW_HSADC_CTRL1, field INTERRUPT */

#define BP_HSADC_CTRL1_INTERRUPT      0
#define BM_HSADC_CTRL1_INTERRUPT      0x00000001

#define BF_HSADC_CTRL1_INTERRUPT(v)   (((v) << 0) & BM_HSADC_CTRL1_INTERRUPT)


/*
 * HW_HSADC_CTRL2 - HSADC Control Register 2
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ADC_PRECHARGE    :  1;
        unsigned ADC_CHANNEL_SEL  :  3;
        unsigned ADC_SH_BYPASS    :  1;
        unsigned ONCHIP_GROUND    :  1;
        unsigned SAH_BIAS_ADJ     :  2;
        unsigned DAC_ADJCURRENT   :  1;
        unsigned DAC_ADJHEADROOM  :  1;
        unsigned SAH_GAIN_ADJ     :  3;
        unsigned POWER_DOWN       :  1;
        unsigned RSRVD1           : 18;
    } B;
} hw_hsadc_ctrl2_t;
#endif

/*
 * constants & macros for entire HW_HSADC_CTRL2 register
 */
#define HW_HSADC_CTRL2_ADDR         (REGS_HSADC_BASE + 0x20)
#define HW_HSADC_CTRL2_SET_ADDR     (HW_HSADC_CTRL2_ADDR + 4)
#define HW_HSADC_CTRL2_CLR_ADDR     (HW_HSADC_CTRL2_ADDR + 8)
#define HW_HSADC_CTRL2_TOG_ADDR     (HW_HSADC_CTRL2_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_HSADC_CTRL2           (*(volatile hw_hsadc_ctrl2_t *) HW_HSADC_CTRL2_ADDR)
#define HW_HSADC_CTRL2_RD()      (HW_HSADC_CTRL2.U)
#define HW_HSADC_CTRL2_WR(v)     (HW_HSADC_CTRL2.U = (v))
#define HW_HSADC_CTRL2_SET(v)    ((*(volatile reg32_t *) HW_HSADC_CTRL2_SET_ADDR) = (v))
#define HW_HSADC_CTRL2_CLR(v)    ((*(volatile reg32_t *) HW_HSADC_CTRL2_CLR_ADDR) = (v))
#define HW_HSADC_CTRL2_TOG(v)    ((*(volatile reg32_t *) HW_HSADC_CTRL2_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_HSADC_CTRL2 bitfields
 */
/* --- Register HW_HSADC_CTRL2, field RSRVD1 */

#define BP_HSADC_CTRL2_RSRVD1      14
#define BM_HSADC_CTRL2_RSRVD1      0xFFFFC000

#ifndef __LANGUAGE_ASM__
#define BF_HSADC_CTRL2_RSRVD1(v)   ((((reg32_t) v) << 14) & BM_HSADC_CTRL2_RSRVD1)
#else
#define BF_HSADC_CTRL2_RSRVD1(v)   (((v) << 14) & BM_HSADC_CTRL2_RSRVD1)
#endif
/* --- Register HW_HSADC_CTRL2, field POWER_DOWN */

#define BP_HSADC_CTRL2_POWER_DOWN      13
#define BM_HSADC_CTRL2_POWER_DOWN      0x00002000

#define BF_HSADC_CTRL2_POWER_DOWN(v)   (((v) << 13) & BM_HSADC_CTRL2_POWER_DOWN)
#ifndef __LANGUAGE_ASM__
#define BW_HSADC_CTRL2_POWER_DOWN(v)   BF_CS1(HSADC_CTRL2, POWER_DOWN, v)
#endif

/* --- Register HW_HSADC_CTRL2, field SAH_GAIN_ADJ */

#define BP_HSADC_CTRL2_SAH_GAIN_ADJ      10
#define BM_HSADC_CTRL2_SAH_GAIN_ADJ      0x00001C00

#define BF_HSADC_CTRL2_SAH_GAIN_ADJ(v)   (((v) << 10) & BM_HSADC_CTRL2_SAH_GAIN_ADJ)
#ifndef __LANGUAGE_ASM__
#define BW_HSADC_CTRL2_SAH_GAIN_ADJ(v)   BF_CS1(HSADC_CTRL2, SAH_GAIN_ADJ, v)
#endif

/* --- Register HW_HSADC_CTRL2, field DAC_ADJHEADROOM */

#define BP_HSADC_CTRL2_DAC_ADJHEADROOM      9
#define BM_HSADC_CTRL2_DAC_ADJHEADROOM      0x00000200

#define BF_HSADC_CTRL2_DAC_ADJHEADROOM(v)   (((v) << 9) & BM_HSADC_CTRL2_DAC_ADJHEADROOM)
#ifndef __LANGUAGE_ASM__
#define BW_HSADC_CTRL2_DAC_ADJHEADROOM(v)   BF_CS1(HSADC_CTRL2, DAC_ADJHEADROOM, v)
#endif

/* --- Register HW_HSADC_CTRL2, field DAC_ADJCURRENT */

#define BP_HSADC_CTRL2_DAC_ADJCURRENT      8
#define BM_HSADC_CTRL2_DAC_ADJCURRENT      0x00000100

#define BF_HSADC_CTRL2_DAC_ADJCURRENT(v)   (((v) << 8) & BM_HSADC_CTRL2_DAC_ADJCURRENT)
#ifndef __LANGUAGE_ASM__
#define BW_HSADC_CTRL2_DAC_ADJCURRENT(v)   BF_CS1(HSADC_CTRL2, DAC_ADJCURRENT, v)
#endif

/* --- Register HW_HSADC_CTRL2, field SAH_BIAS_ADJ */

#define BP_HSADC_CTRL2_SAH_BIAS_ADJ      6
#define BM_HSADC_CTRL2_SAH_BIAS_ADJ      0x000000C0

#define BF_HSADC_CTRL2_SAH_BIAS_ADJ(v)   (((v) << 6) & BM_HSADC_CTRL2_SAH_BIAS_ADJ)
#ifndef __LANGUAGE_ASM__
#define BW_HSADC_CTRL2_SAH_BIAS_ADJ(v)   BF_CS1(HSADC_CTRL2, SAH_BIAS_ADJ, v)
#endif

/* --- Register HW_HSADC_CTRL2, field ONCHIP_GROUND */

#define BP_HSADC_CTRL2_ONCHIP_GROUND      5
#define BM_HSADC_CTRL2_ONCHIP_GROUND      0x00000020

#define BF_HSADC_CTRL2_ONCHIP_GROUND(v)   (((v) << 5) & BM_HSADC_CTRL2_ONCHIP_GROUND)
#ifndef __LANGUAGE_ASM__
#define BW_HSADC_CTRL2_ONCHIP_GROUND(v)   BF_CS1(HSADC_CTRL2, ONCHIP_GROUND, v)
#endif

/* --- Register HW_HSADC_CTRL2, field ADC_SH_BYPASS */

#define BP_HSADC_CTRL2_ADC_SH_BYPASS      4
#define BM_HSADC_CTRL2_ADC_SH_BYPASS      0x00000010

#define BF_HSADC_CTRL2_ADC_SH_BYPASS(v)   (((v) << 4) & BM_HSADC_CTRL2_ADC_SH_BYPASS)
#ifndef __LANGUAGE_ASM__
#define BW_HSADC_CTRL2_ADC_SH_BYPASS(v)   BF_CS1(HSADC_CTRL2, ADC_SH_BYPASS, v)
#endif

/* --- Register HW_HSADC_CTRL2, field ADC_CHANNEL_SEL */

#define BP_HSADC_CTRL2_ADC_CHANNEL_SEL      1
#define BM_HSADC_CTRL2_ADC_CHANNEL_SEL      0x0000000E

#define BF_HSADC_CTRL2_ADC_CHANNEL_SEL(v)   (((v) << 1) & BM_HSADC_CTRL2_ADC_CHANNEL_SEL)
#ifndef __LANGUAGE_ASM__
#define BW_HSADC_CTRL2_ADC_CHANNEL_SEL(v)   BF_CS1(HSADC_CTRL2, ADC_CHANNEL_SEL, v)
#endif

/* --- Register HW_HSADC_CTRL2, field ADC_PRECHARGE */

#define BP_HSADC_CTRL2_ADC_PRECHARGE      0
#define BM_HSADC_CTRL2_ADC_PRECHARGE      0x00000001

#define BF_HSADC_CTRL2_ADC_PRECHARGE(v)   (((v) << 0) & BM_HSADC_CTRL2_ADC_PRECHARGE)
#ifndef __LANGUAGE_ASM__
#define BW_HSADC_CTRL2_ADC_PRECHARGE(v)   BF_CS1(HSADC_CTRL2, ADC_PRECHARGE, v)
#endif



/*
 * HW_HSADC_SEQUENCE_SAMPLES_NUM - HSADC Sequence Samples Number Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned SEQUENCE_SAMPLES_NUM  : 32;
    } B;
} hw_hsadc_sequence_samples_num_t;
#endif

/*
 * constants & macros for entire HW_HSADC_SEQUENCE_SAMPLES_NUM register
 */
#define HW_HSADC_SEQUENCE_SAMPLES_NUM_ADDR         (REGS_HSADC_BASE + 0x30)
#define HW_HSADC_SEQUENCE_SAMPLES_NUM_SET_ADDR     (HW_HSADC_SEQUENCE_SAMPLES_NUM_ADDR + 4)
#define HW_HSADC_SEQUENCE_SAMPLES_NUM_CLR_ADDR     (HW_HSADC_SEQUENCE_SAMPLES_NUM_ADDR + 8)
#define HW_HSADC_SEQUENCE_SAMPLES_NUM_TOG_ADDR     (HW_HSADC_SEQUENCE_SAMPLES_NUM_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_HSADC_SEQUENCE_SAMPLES_NUM           (*(volatile hw_hsadc_sequence_samples_num_t *) HW_HSADC_SEQUENCE_SAMPLES_NUM_ADDR)
#define HW_HSADC_SEQUENCE_SAMPLES_NUM_RD()      (HW_HSADC_SEQUENCE_SAMPLES_NUM.U)
#define HW_HSADC_SEQUENCE_SAMPLES_NUM_WR(v)     (HW_HSADC_SEQUENCE_SAMPLES_NUM.U = (v))
#define HW_HSADC_SEQUENCE_SAMPLES_NUM_SET(v)    ((*(volatile reg32_t *) HW_HSADC_SEQUENCE_SAMPLES_NUM_SET_ADDR) = (v))
#define HW_HSADC_SEQUENCE_SAMPLES_NUM_CLR(v)    ((*(volatile reg32_t *) HW_HSADC_SEQUENCE_SAMPLES_NUM_CLR_ADDR) = (v))
#define HW_HSADC_SEQUENCE_SAMPLES_NUM_TOG(v)    ((*(volatile reg32_t *) HW_HSADC_SEQUENCE_SAMPLES_NUM_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_HSADC_SEQUENCE_SAMPLES_NUM bitfields
 */
/* --- Register HW_HSADC_SEQUENCE_SAMPLES_NUM, field SEQUENCE_SAMPLES_NUM */

#define BP_HSADC_SEQUENCE_SAMPLES_NUM_SEQUENCE_SAMPLES_NUM      0
#define BM_HSADC_SEQUENCE_SAMPLES_NUM_SEQUENCE_SAMPLES_NUM      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_HSADC_SEQUENCE_SAMPLES_NUM_SEQUENCE_SAMPLES_NUM(v)   ((reg32_t) v)
#else
#define BF_HSADC_SEQUENCE_SAMPLES_NUM_SEQUENCE_SAMPLES_NUM(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_HSADC_SEQUENCE_SAMPLES_NUM_SEQUENCE_SAMPLES_NUM(v)   (HW_HSADC_SEQUENCE_SAMPLES_NUM.B.SEQUENCE_SAMPLES_NUM = (v))
#endif



/*
 * HW_HSADC_SEQUENCE_NUM - HSADC Sequence Number Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned SEQUENCE_NUM  : 32;
    } B;
} hw_hsadc_sequence_num_t;
#endif

/*
 * constants & macros for entire HW_HSADC_SEQUENCE_NUM register
 */
#define HW_HSADC_SEQUENCE_NUM_ADDR         (REGS_HSADC_BASE + 0x40)
#define HW_HSADC_SEQUENCE_NUM_SET_ADDR     (HW_HSADC_SEQUENCE_NUM_ADDR + 4)
#define HW_HSADC_SEQUENCE_NUM_CLR_ADDR     (HW_HSADC_SEQUENCE_NUM_ADDR + 8)
#define HW_HSADC_SEQUENCE_NUM_TOG_ADDR     (HW_HSADC_SEQUENCE_NUM_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_HSADC_SEQUENCE_NUM           (*(volatile hw_hsadc_sequence_num_t *) HW_HSADC_SEQUENCE_NUM_ADDR)
#define HW_HSADC_SEQUENCE_NUM_RD()      (HW_HSADC_SEQUENCE_NUM.U)
#define HW_HSADC_SEQUENCE_NUM_WR(v)     (HW_HSADC_SEQUENCE_NUM.U = (v))
#define HW_HSADC_SEQUENCE_NUM_SET(v)    ((*(volatile reg32_t *) HW_HSADC_SEQUENCE_NUM_SET_ADDR) = (v))
#define HW_HSADC_SEQUENCE_NUM_CLR(v)    ((*(volatile reg32_t *) HW_HSADC_SEQUENCE_NUM_CLR_ADDR) = (v))
#define HW_HSADC_SEQUENCE_NUM_TOG(v)    ((*(volatile reg32_t *) HW_HSADC_SEQUENCE_NUM_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_HSADC_SEQUENCE_NUM bitfields
 */
/* --- Register HW_HSADC_SEQUENCE_NUM, field SEQUENCE_NUM */

#define BP_HSADC_SEQUENCE_NUM_SEQUENCE_NUM      0
#define BM_HSADC_SEQUENCE_NUM_SEQUENCE_NUM      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_HSADC_SEQUENCE_NUM_SEQUENCE_NUM(v)   ((reg32_t) v)
#else
#define BF_HSADC_SEQUENCE_NUM_SEQUENCE_NUM(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_HSADC_SEQUENCE_NUM_SEQUENCE_NUM(v)   (HW_HSADC_SEQUENCE_NUM.B.SEQUENCE_NUM = (v))
#endif



/*
 * HW_HSADC_FIFO_DATA - HSADC FIFO Data Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned FIFO_DATA  : 32;
    } B;
} hw_hsadc_fifo_data_t;
#endif

/*
 * constants & macros for entire HW_HSADC_FIFO_DATA register
 */
#define HW_HSADC_FIFO_DATA_ADDR         (REGS_HSADC_BASE + 0x50)

#ifndef __LANGUAGE_ASM__
#define HW_HSADC_FIFO_DATA           (*(volatile hw_hsadc_fifo_data_t *) HW_HSADC_FIFO_DATA_ADDR)
#define HW_HSADC_FIFO_DATA_RD()      (HW_HSADC_FIFO_DATA.U)
#endif


/*
 * constants & macros for individual HW_HSADC_FIFO_DATA bitfields
 */
/* --- Register HW_HSADC_FIFO_DATA, field FIFO_DATA */

#define BP_HSADC_FIFO_DATA_FIFO_DATA      0
#define BM_HSADC_FIFO_DATA_FIFO_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_HSADC_FIFO_DATA_FIFO_DATA(v)   ((reg32_t) v)
#else
#define BF_HSADC_FIFO_DATA_FIFO_DATA(v)   (v)
#endif


/*
 * HW_HSADC_DBG_INFO0 - HSADC Debug Information 0 Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned HSADC_FSM_STATE  :  3;
        unsigned DMA_FSM_STATE    :  3;
        unsigned RSRVD1           : 26;
    } B;
} hw_hsadc_dbg_info0_t;
#endif

/*
 * constants & macros for entire HW_HSADC_DBG_INFO0 register
 */
#define HW_HSADC_DBG_INFO0_ADDR         (REGS_HSADC_BASE + 0x60)

#ifndef __LANGUAGE_ASM__
#define HW_HSADC_DBG_INFO0           (*(volatile hw_hsadc_dbg_info0_t *) HW_HSADC_DBG_INFO0_ADDR)
#define HW_HSADC_DBG_INFO0_RD()      (HW_HSADC_DBG_INFO0.U)
#endif


/*
 * constants & macros for individual HW_HSADC_DBG_INFO0 bitfields
 */
/* --- Register HW_HSADC_DBG_INFO0, field RSRVD1 */

#define BP_HSADC_DBG_INFO0_RSRVD1      6
#define BM_HSADC_DBG_INFO0_RSRVD1      0xFFFFFFC0

#ifndef __LANGUAGE_ASM__
#define BF_HSADC_DBG_INFO0_RSRVD1(v)   ((((reg32_t) v) << 6) & BM_HSADC_DBG_INFO0_RSRVD1)
#else
#define BF_HSADC_DBG_INFO0_RSRVD1(v)   (((v) << 6) & BM_HSADC_DBG_INFO0_RSRVD1)
#endif
/* --- Register HW_HSADC_DBG_INFO0, field DMA_FSM_STATE */

#define BP_HSADC_DBG_INFO0_DMA_FSM_STATE      3
#define BM_HSADC_DBG_INFO0_DMA_FSM_STATE      0x00000038

#define BF_HSADC_DBG_INFO0_DMA_FSM_STATE(v)   (((v) << 3) & BM_HSADC_DBG_INFO0_DMA_FSM_STATE)
/* --- Register HW_HSADC_DBG_INFO0, field HSADC_FSM_STATE */

#define BP_HSADC_DBG_INFO0_HSADC_FSM_STATE      0
#define BM_HSADC_DBG_INFO0_HSADC_FSM_STATE      0x00000007

#define BF_HSADC_DBG_INFO0_HSADC_FSM_STATE(v)   (((v) << 0) & BM_HSADC_DBG_INFO0_HSADC_FSM_STATE)


/*
 * HW_HSADC_DBG_INFO1 - HSADC Debug Information 1 Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned SEQUENCE_SAMPLE_CNT  : 32;
    } B;
} hw_hsadc_dbg_info1_t;
#endif

/*
 * constants & macros for entire HW_HSADC_DBG_INFO1 register
 */
#define HW_HSADC_DBG_INFO1_ADDR         (REGS_HSADC_BASE + 0x70)

#ifndef __LANGUAGE_ASM__
#define HW_HSADC_DBG_INFO1           (*(volatile hw_hsadc_dbg_info1_t *) HW_HSADC_DBG_INFO1_ADDR)
#define HW_HSADC_DBG_INFO1_RD()      (HW_HSADC_DBG_INFO1.U)
#endif


/*
 * constants & macros for individual HW_HSADC_DBG_INFO1 bitfields
 */
/* --- Register HW_HSADC_DBG_INFO1, field SEQUENCE_SAMPLE_CNT */

#define BP_HSADC_DBG_INFO1_SEQUENCE_SAMPLE_CNT      0
#define BM_HSADC_DBG_INFO1_SEQUENCE_SAMPLE_CNT      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_HSADC_DBG_INFO1_SEQUENCE_SAMPLE_CNT(v)   ((reg32_t) v)
#else
#define BF_HSADC_DBG_INFO1_SEQUENCE_SAMPLE_CNT(v)   (v)
#endif


/*
 * HW_HSADC_DBG_INFO2 - HSADC Debug Information 2 Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned SEQUENCE_CNT  : 32;
    } B;
} hw_hsadc_dbg_info2_t;
#endif

/*
 * constants & macros for entire HW_HSADC_DBG_INFO2 register
 */
#define HW_HSADC_DBG_INFO2_ADDR         (REGS_HSADC_BASE + 0x80)

#ifndef __LANGUAGE_ASM__
#define HW_HSADC_DBG_INFO2           (*(volatile hw_hsadc_dbg_info2_t *) HW_HSADC_DBG_INFO2_ADDR)
#define HW_HSADC_DBG_INFO2_RD()      (HW_HSADC_DBG_INFO2.U)
#endif


/*
 * constants & macros for individual HW_HSADC_DBG_INFO2 bitfields
 */
/* --- Register HW_HSADC_DBG_INFO2, field SEQUENCE_CNT */

#define BP_HSADC_DBG_INFO2_SEQUENCE_CNT      0
#define BM_HSADC_DBG_INFO2_SEQUENCE_CNT      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_HSADC_DBG_INFO2_SEQUENCE_CNT(v)   ((reg32_t) v)
#else
#define BF_HSADC_DBG_INFO2_SEQUENCE_CNT(v)   (v)
#endif


/*
 * HW_HSADC_VERSION - HSADC Version Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned STEP   : 16;
        unsigned MINOR  :  8;
        unsigned MAJOR  :  8;
    } B;
} hw_hsadc_version_t;
#endif

/*
 * constants & macros for entire HW_HSADC_VERSION register
 */
#define HW_HSADC_VERSION_ADDR         (REGS_HSADC_BASE + 0xb0)

#ifndef __LANGUAGE_ASM__
#define HW_HSADC_VERSION           (*(volatile hw_hsadc_version_t *) HW_HSADC_VERSION_ADDR)
#define HW_HSADC_VERSION_RD()      (HW_HSADC_VERSION.U)
#endif


/*
 * constants & macros for individual HW_HSADC_VERSION bitfields
 */
/* --- Register HW_HSADC_VERSION, field MAJOR */

#define BP_HSADC_VERSION_MAJOR      24
#define BM_HSADC_VERSION_MAJOR      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_HSADC_VERSION_MAJOR(v)   ((((reg32_t) v) << 24) & BM_HSADC_VERSION_MAJOR)
#else
#define BF_HSADC_VERSION_MAJOR(v)   (((v) << 24) & BM_HSADC_VERSION_MAJOR)
#endif
/* --- Register HW_HSADC_VERSION, field MINOR */

#define BP_HSADC_VERSION_MINOR      16
#define BM_HSADC_VERSION_MINOR      0x00FF0000

#define BF_HSADC_VERSION_MINOR(v)   (((v) << 16) & BM_HSADC_VERSION_MINOR)
/* --- Register HW_HSADC_VERSION, field STEP */

#define BP_HSADC_VERSION_STEP      0
#define BM_HSADC_VERSION_STEP      0x0000FFFF

#define BF_HSADC_VERSION_STEP(v)   (((v) << 0) & BM_HSADC_VERSION_STEP)

#endif /* _HSADC_H */

////////////////////////////////////////////////////////////////////////////////
