/*
 * Copyright 2008-2009 Freescale Semiconductor, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

 * WARNING!  THIS FILE IS AUTOMATICALLY GENERATED FROM XML.
 *                DO NOT MODIFY THIS FILE DIRECTLY.
 *
 * Xml Revision: 1.21
 *
 * Template revision: 26195
 *
 *
 * The following naming conventions are followed in this file.
 *      XX_<module>_<regname>_<field>
 *
 * XX specifies the define / macro class
 *      HW pertains to a register
 *      BM indicates a Bit Mask
 *      BF indicates a Bit Field macro
 *
 * <module> is the hardware module name which can be any of the following...
 *      USB20 (Note when there is more than one copy of a given module, the
 *      module name includes a number starting from 0 for the first instance
 *      of that module)
 *
 * <regname> is the specific register within that module
 *
 * <field> is the specific bitfield within that <module>_<register>
 *
 * We also define the following...
 *      hw_<module>_<regname>_t is typedef of anonymous union
 *
 */

#ifndef _OCOTP_H
#define _OCOTP_H  1

#include "regs.h"

#ifndef REGS_OCOTP_BASE
#define REGS_OCOTP_BASE (REGS_BASE + 0x2c000)
#endif

/*
 * HW_OCOTP_CTRL - OTP Controller Control Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ADDR            :  6;
        unsigned RSRVD0          :  2;
        unsigned BUSY            :  1;
        unsigned ERROR           :  1;
        unsigned RSRVD1          :  2;
        unsigned RD_BANK_OPEN    :  1;
        unsigned RELOAD_SHADOWS  :  1;
        unsigned RSRVD2          :  2;
        unsigned WR_UNLOCK       : 16;
    } B;
} hw_ocotp_ctrl_t;
#endif

/*
 * constants & macros for entire HW_OCOTP_CTRL register
 */
#define HW_OCOTP_CTRL_ADDR         (REGS_OCOTP_BASE + 0x0)
#define HW_OCOTP_CTRL_SET_ADDR     (HW_OCOTP_CTRL_ADDR + 4)
#define HW_OCOTP_CTRL_CLR_ADDR     (HW_OCOTP_CTRL_ADDR + 8)
#define HW_OCOTP_CTRL_TOG_ADDR     (HW_OCOTP_CTRL_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_CTRL           (*(volatile hw_ocotp_ctrl_t *) HW_OCOTP_CTRL_ADDR)
#define HW_OCOTP_CTRL_RD()      (HW_OCOTP_CTRL.U)
#define HW_OCOTP_CTRL_WR(v)     (HW_OCOTP_CTRL.U = (v))
#define HW_OCOTP_CTRL_SET(v)    ((*(volatile reg32_t *) HW_OCOTP_CTRL_SET_ADDR) = (v))
#define HW_OCOTP_CTRL_CLR(v)    ((*(volatile reg32_t *) HW_OCOTP_CTRL_CLR_ADDR) = (v))
#define HW_OCOTP_CTRL_TOG(v)    ((*(volatile reg32_t *) HW_OCOTP_CTRL_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_OCOTP_CTRL bitfields
 */
/* --- Register HW_OCOTP_CTRL, field WR_UNLOCK */

#define BP_OCOTP_CTRL_WR_UNLOCK      16
#define BM_OCOTP_CTRL_WR_UNLOCK      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_OCOTP_CTRL_WR_UNLOCK(v)   ((((reg32_t) v) << 16) & BM_OCOTP_CTRL_WR_UNLOCK)
#else
#define BF_OCOTP_CTRL_WR_UNLOCK(v)   (((v) << 16) & BM_OCOTP_CTRL_WR_UNLOCK)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_OCOTP_CTRL_WR_UNLOCK(v)   (HW_OCOTP_CTRL.B.WR_UNLOCK = (v))
#endif

#define BV_OCOTP_CTRL_WR_UNLOCK__KEY  0x3E77

/* --- Register HW_OCOTP_CTRL, field RSRVD2 */

#define BP_OCOTP_CTRL_RSRVD2      14
#define BM_OCOTP_CTRL_RSRVD2      0x0000C000

#define BF_OCOTP_CTRL_RSRVD2(v)   (((v) << 14) & BM_OCOTP_CTRL_RSRVD2)
/* --- Register HW_OCOTP_CTRL, field RELOAD_SHADOWS */

#define BP_OCOTP_CTRL_RELOAD_SHADOWS      13
#define BM_OCOTP_CTRL_RELOAD_SHADOWS      0x00002000

#define BF_OCOTP_CTRL_RELOAD_SHADOWS(v)   (((v) << 13) & BM_OCOTP_CTRL_RELOAD_SHADOWS)
#ifndef __LANGUAGE_ASM__
#define BW_OCOTP_CTRL_RELOAD_SHADOWS(v)   BF_CS1(OCOTP_CTRL, RELOAD_SHADOWS, v)
#endif

/* --- Register HW_OCOTP_CTRL, field RD_BANK_OPEN */

#define BP_OCOTP_CTRL_RD_BANK_OPEN      12
#define BM_OCOTP_CTRL_RD_BANK_OPEN      0x00001000

#define BF_OCOTP_CTRL_RD_BANK_OPEN(v)   (((v) << 12) & BM_OCOTP_CTRL_RD_BANK_OPEN)
#ifndef __LANGUAGE_ASM__
#define BW_OCOTP_CTRL_RD_BANK_OPEN(v)   BF_CS1(OCOTP_CTRL, RD_BANK_OPEN, v)
#endif

/* --- Register HW_OCOTP_CTRL, field RSRVD1 */

#define BP_OCOTP_CTRL_RSRVD1      10
#define BM_OCOTP_CTRL_RSRVD1      0x00000C00

#define BF_OCOTP_CTRL_RSRVD1(v)   (((v) << 10) & BM_OCOTP_CTRL_RSRVD1)
/* --- Register HW_OCOTP_CTRL, field ERROR */

#define BP_OCOTP_CTRL_ERROR      9
#define BM_OCOTP_CTRL_ERROR      0x00000200

#define BF_OCOTP_CTRL_ERROR(v)   (((v) << 9) & BM_OCOTP_CTRL_ERROR)
#ifndef __LANGUAGE_ASM__
#define BW_OCOTP_CTRL_ERROR(v)   BF_CS1(OCOTP_CTRL, ERROR, v)
#endif

/* --- Register HW_OCOTP_CTRL, field BUSY */

#define BP_OCOTP_CTRL_BUSY      8
#define BM_OCOTP_CTRL_BUSY      0x00000100

#define BF_OCOTP_CTRL_BUSY(v)   (((v) << 8) & BM_OCOTP_CTRL_BUSY)
/* --- Register HW_OCOTP_CTRL, field RSRVD0 */

#define BP_OCOTP_CTRL_RSRVD0      6
#define BM_OCOTP_CTRL_RSRVD0      0x000000C0

#define BF_OCOTP_CTRL_RSRVD0(v)   (((v) << 6) & BM_OCOTP_CTRL_RSRVD0)
/* --- Register HW_OCOTP_CTRL, field ADDR */

#define BP_OCOTP_CTRL_ADDR      0
#define BM_OCOTP_CTRL_ADDR      0x0000003F

#define BF_OCOTP_CTRL_ADDR(v)   (((v) << 0) & BM_OCOTP_CTRL_ADDR)
#ifndef __LANGUAGE_ASM__
#define BW_OCOTP_CTRL_ADDR(v)   BF_CS1(OCOTP_CTRL, ADDR, v)
#endif



/*
 * HW_OCOTP_DATA - OTP Controller Write Data Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DATA  : 32;
    } B;
} hw_ocotp_data_t;
#endif

/*
 * constants & macros for entire HW_OCOTP_DATA register
 */
#define HW_OCOTP_DATA_ADDR         (REGS_OCOTP_BASE + 0x10)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_DATA           (*(volatile hw_ocotp_data_t *) HW_OCOTP_DATA_ADDR)
#define HW_OCOTP_DATA_RD()      (HW_OCOTP_DATA.U)
#define HW_OCOTP_DATA_WR(v)     (HW_OCOTP_DATA.U = (v))
#define HW_OCOTP_DATA_SET(v)    (HW_OCOTP_DATA_WR(HW_OCOTP_DATA_RD() |  (v)))
#define HW_OCOTP_DATA_CLR(v)    (HW_OCOTP_DATA_WR(HW_OCOTP_DATA_RD() & ~(v)))
#define HW_OCOTP_DATA_TOG(v)    (HW_OCOTP_DATA_WR(HW_OCOTP_DATA_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_OCOTP_DATA bitfields
 */
/* --- Register HW_OCOTP_DATA, field DATA */

#define BP_OCOTP_DATA_DATA      0
#define BM_OCOTP_DATA_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_OCOTP_DATA_DATA(v)   ((reg32_t) v)
#else
#define BF_OCOTP_DATA_DATA(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_OCOTP_DATA_DATA(v)   (HW_OCOTP_DATA.B.DATA = (v))
#endif



/*
 *  multi-register-define name HW_OCOTP_CUSTn
 *              base 0x00000020
 *              count 4
 *              offset 0x10
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BITS  : 32;
    } B;
} hw_ocotp_custn_t;
#endif

    /*
     * constants & macros for entire HW_OCOTP_CUSTn multi-register
     */
    #define HW_OCOTP_CUSTn_COUNT        4
    #define HW_OCOTP_CUSTn_ADDR(n)      (REGS_OCOTP_BASE + 0x20 + ((n) * 0x10))

    #ifndef __LANGUAGE_ASM__
    #define HW_OCOTP_CUSTn(n)           (*(volatile hw_ocotp_custn_t *) HW_OCOTP_CUSTn_ADDR(n))
    #define HW_OCOTP_CUSTn_RD(n)        (HW_OCOTP_CUSTn(n).U)
    #endif


/*
 * constants & macros for individual HW_OCOTP_CUSTn multi-register bitfields
 */
/* --- Register HW_OCOTP_CUSTn, field BITS */

#define BP_OCOTP_CUSTn_BITS      0
#define BM_OCOTP_CUSTn_BITS      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_OCOTP_CUSTn_BITS(v)   ((reg32_t) v)
#else
#define BF_OCOTP_CUSTn_BITS(v)   (v)
#endif


/*
 *  multi-register-define name HW_OCOTP_CRYPTOn
 *              base 0x00000060
 *              count 4
 *              offset 0x10
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BITS  : 32;
    } B;
} hw_ocotp_crypton_t;
#endif

    /*
     * constants & macros for entire HW_OCOTP_CRYPTOn multi-register
     */
    #define HW_OCOTP_CRYPTOn_COUNT        4
    #define HW_OCOTP_CRYPTOn_ADDR(n)      (REGS_OCOTP_BASE + 0x60 + ((n) * 0x10))

    #ifndef __LANGUAGE_ASM__
    #define HW_OCOTP_CRYPTOn(n)           (*(volatile hw_ocotp_crypton_t *) HW_OCOTP_CRYPTOn_ADDR(n))
    #define HW_OCOTP_CRYPTOn_RD(n)        (HW_OCOTP_CRYPTOn(n).U)
    #endif


/*
 * constants & macros for individual HW_OCOTP_CRYPTOn multi-register bitfields
 */
/* --- Register HW_OCOTP_CRYPTOn, field BITS */

#define BP_OCOTP_CRYPTOn_BITS      0
#define BM_OCOTP_CRYPTOn_BITS      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_OCOTP_CRYPTOn_BITS(v)   ((reg32_t) v)
#else
#define BF_OCOTP_CRYPTOn_BITS(v)   (v)
#endif


/*
 *  multi-register-define name HW_OCOTP_HWCAPn
 *              base 0x000000A0
 *              count 6
 *              offset 0x10
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BITS  : 32;
    } B;
} hw_ocotp_hwcapn_t;
#endif

    /*
     * constants & macros for entire HW_OCOTP_HWCAPn multi-register
     */
    #define HW_OCOTP_HWCAPn_COUNT        6
    #define HW_OCOTP_HWCAPn_ADDR(n)      (REGS_OCOTP_BASE + 0xa0 + ((n) * 0x10))

    #ifndef __LANGUAGE_ASM__
    #define HW_OCOTP_HWCAPn(n)           (*(volatile hw_ocotp_hwcapn_t *) HW_OCOTP_HWCAPn_ADDR(n))
    #define HW_OCOTP_HWCAPn_RD(n)        (HW_OCOTP_HWCAPn(n).U)
    #define HW_OCOTP_HWCAPn_WR(n, v)     (HW_OCOTP_HWCAPn(n).U = (v))
    #define HW_OCOTP_HWCAPn_SET(n, v)    (HW_OCOTP_HWCAPn_WR(n, HW_OCOTP_HWCAPn_RD(n) |  (v)))
    #define HW_OCOTP_HWCAPn_CLR(n, v)    (HW_OCOTP_HWCAPn_WR(n, HW_OCOTP_HWCAPn_RD(n) & ~(v)))
    #define HW_OCOTP_HWCAPn_TOG(n, v)    (HW_OCOTP_HWCAPn_WR(n, HW_OCOTP_HWCAPn_RD(n) ^  (v)))
    #endif


/*
 * constants & macros for individual HW_OCOTP_HWCAPn multi-register bitfields
 */
/* --- Register HW_OCOTP_HWCAPn, field BITS */

#define BP_OCOTP_HWCAPn_BITS      0
#define BM_OCOTP_HWCAPn_BITS      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_OCOTP_HWCAPn_BITS(v)   ((reg32_t) v)
#else
#define BF_OCOTP_HWCAPn_BITS(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_OCOTP_HWCAPn_BITS(n, v)  (HW_OCOTP_HWCAPn(n).B.BITS = (v))
#endif



/*
 * HW_OCOTP_SWCAP - SW Capability Shadow Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BITS  : 32;
    } B;
} hw_ocotp_swcap_t;
#endif

/*
 * constants & macros for entire HW_OCOTP_SWCAP register
 */
#define HW_OCOTP_SWCAP_ADDR         (REGS_OCOTP_BASE + 0x100)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_SWCAP           (*(volatile hw_ocotp_swcap_t *) HW_OCOTP_SWCAP_ADDR)
#define HW_OCOTP_SWCAP_RD()      (HW_OCOTP_SWCAP.U)
#define HW_OCOTP_SWCAP_WR(v)     (HW_OCOTP_SWCAP.U = (v))
#define HW_OCOTP_SWCAP_SET(v)    (HW_OCOTP_SWCAP_WR(HW_OCOTP_SWCAP_RD() |  (v)))
#define HW_OCOTP_SWCAP_CLR(v)    (HW_OCOTP_SWCAP_WR(HW_OCOTP_SWCAP_RD() & ~(v)))
#define HW_OCOTP_SWCAP_TOG(v)    (HW_OCOTP_SWCAP_WR(HW_OCOTP_SWCAP_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_OCOTP_SWCAP bitfields
 */
/* --- Register HW_OCOTP_SWCAP, field BITS */

#define BP_OCOTP_SWCAP_BITS      0
#define BM_OCOTP_SWCAP_BITS      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_OCOTP_SWCAP_BITS(v)   ((reg32_t) v)
#else
#define BF_OCOTP_SWCAP_BITS(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_OCOTP_SWCAP_BITS(v)   (HW_OCOTP_SWCAP.B.BITS = (v))
#endif



/*
 * HW_OCOTP_CUSTCAP - Customer Capability Shadow Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSRVD0                  :  1;
        unsigned RTC_XTAL_32000_PRESENT  :  1;
        unsigned RTC_XTAL_32768_PRESENT  :  1;
        unsigned RSRVD1                  : 29;
    } B;
} hw_ocotp_custcap_t;
#endif

/*
 * constants & macros for entire HW_OCOTP_CUSTCAP register
 */
#define HW_OCOTP_CUSTCAP_ADDR         (REGS_OCOTP_BASE + 0x110)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_CUSTCAP           (*(volatile hw_ocotp_custcap_t *) HW_OCOTP_CUSTCAP_ADDR)
#define HW_OCOTP_CUSTCAP_RD()      (HW_OCOTP_CUSTCAP.U)
#define HW_OCOTP_CUSTCAP_WR(v)     (HW_OCOTP_CUSTCAP.U = (v))
#define HW_OCOTP_CUSTCAP_SET(v)    (HW_OCOTP_CUSTCAP_WR(HW_OCOTP_CUSTCAP_RD() |  (v)))
#define HW_OCOTP_CUSTCAP_CLR(v)    (HW_OCOTP_CUSTCAP_WR(HW_OCOTP_CUSTCAP_RD() & ~(v)))
#define HW_OCOTP_CUSTCAP_TOG(v)    (HW_OCOTP_CUSTCAP_WR(HW_OCOTP_CUSTCAP_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_OCOTP_CUSTCAP bitfields
 */
/* --- Register HW_OCOTP_CUSTCAP, field RSRVD1 */

#define BP_OCOTP_CUSTCAP_RSRVD1      3
#define BM_OCOTP_CUSTCAP_RSRVD1      0xFFFFFFF8

#ifndef __LANGUAGE_ASM__
#define BF_OCOTP_CUSTCAP_RSRVD1(v)   ((((reg32_t) v) << 3) & BM_OCOTP_CUSTCAP_RSRVD1)
#else
#define BF_OCOTP_CUSTCAP_RSRVD1(v)   (((v) << 3) & BM_OCOTP_CUSTCAP_RSRVD1)
#endif
/* --- Register HW_OCOTP_CUSTCAP, field RTC_XTAL_32768_PRESENT */

#define BP_OCOTP_CUSTCAP_RTC_XTAL_32768_PRESENT      2
#define BM_OCOTP_CUSTCAP_RTC_XTAL_32768_PRESENT      0x00000004

#define BF_OCOTP_CUSTCAP_RTC_XTAL_32768_PRESENT(v)   (((v) << 2) & BM_OCOTP_CUSTCAP_RTC_XTAL_32768_PRESENT)
#ifndef __LANGUAGE_ASM__
#define BW_OCOTP_CUSTCAP_RTC_XTAL_32768_PRESENT(v)   BF_CS1(OCOTP_CUSTCAP, RTC_XTAL_32768_PRESENT, v)
#endif

/* --- Register HW_OCOTP_CUSTCAP, field RTC_XTAL_32000_PRESENT */

#define BP_OCOTP_CUSTCAP_RTC_XTAL_32000_PRESENT      1
#define BM_OCOTP_CUSTCAP_RTC_XTAL_32000_PRESENT      0x00000002

#define BF_OCOTP_CUSTCAP_RTC_XTAL_32000_PRESENT(v)   (((v) << 1) & BM_OCOTP_CUSTCAP_RTC_XTAL_32000_PRESENT)
#ifndef __LANGUAGE_ASM__
#define BW_OCOTP_CUSTCAP_RTC_XTAL_32000_PRESENT(v)   BF_CS1(OCOTP_CUSTCAP, RTC_XTAL_32000_PRESENT, v)
#endif

/* --- Register HW_OCOTP_CUSTCAP, field RSRVD0 */

#define BP_OCOTP_CUSTCAP_RSRVD0      0
#define BM_OCOTP_CUSTCAP_RSRVD0      0x00000001

#define BF_OCOTP_CUSTCAP_RSRVD0(v)   (((v) << 0) & BM_OCOTP_CUSTCAP_RSRVD0)


/*
 * HW_OCOTP_LOCK - LOCK Shadow Register OTP Bank 2 Word 0
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned CUST0            :  1;
        unsigned CUST1            :  1;
        unsigned CUST2            :  1;
        unsigned CUST3            :  1;
        unsigned CRYPTOKEY        :  1;
        unsigned CRYPTODCP        :  1;
        unsigned HWSW_SHADOW      :  1;
        unsigned CUSTCAP_SHADOW   :  1;
        unsigned HWSW             :  1;
        unsigned CUSTCAP          :  1;
        unsigned ROM_SHADOW       :  1;
        unsigned SRK_SHADOW       :  1;
        unsigned UNALLOCATED      :  3;
        unsigned SRK              :  1;
        unsigned UN0              :  1;
        unsigned UN1              :  1;
        unsigned UN2              :  1;
        unsigned OPS              :  1;
        unsigned PIN              :  1;
        unsigned CRYPTOKEY_ALT    :  1;
        unsigned CRYPTODCP_ALT    :  1;
        unsigned HWSW_SHADOW_ALT  :  1;
        unsigned ROM0             :  1;
        unsigned ROM1             :  1;
        unsigned ROM2             :  1;
        unsigned ROM3             :  1;
        unsigned ROM4             :  1;
        unsigned ROM5             :  1;
        unsigned ROM6             :  1;
        unsigned ROM7             :  1;
    } B;
} hw_ocotp_lock_t;
#endif

/*
 * constants & macros for entire HW_OCOTP_LOCK register
 */
#define HW_OCOTP_LOCK_ADDR         (REGS_OCOTP_BASE + 0x120)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_LOCK           (*(volatile hw_ocotp_lock_t *) HW_OCOTP_LOCK_ADDR)
#define HW_OCOTP_LOCK_RD()      (HW_OCOTP_LOCK.U)
#endif


/*
 * constants & macros for individual HW_OCOTP_LOCK bitfields
 */
/* --- Register HW_OCOTP_LOCK, field ROM7 */

#define BP_OCOTP_LOCK_ROM7      31
#define BM_OCOTP_LOCK_ROM7      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_OCOTP_LOCK_ROM7(v)   ((((reg32_t) v) << 31) & BM_OCOTP_LOCK_ROM7)
#else
#define BF_OCOTP_LOCK_ROM7(v)   (((v) << 31) & BM_OCOTP_LOCK_ROM7)
#endif
/* --- Register HW_OCOTP_LOCK, field ROM6 */

#define BP_OCOTP_LOCK_ROM6      30
#define BM_OCOTP_LOCK_ROM6      0x40000000

#define BF_OCOTP_LOCK_ROM6(v)   (((v) << 30) & BM_OCOTP_LOCK_ROM6)
/* --- Register HW_OCOTP_LOCK, field ROM5 */

#define BP_OCOTP_LOCK_ROM5      29
#define BM_OCOTP_LOCK_ROM5      0x20000000

#define BF_OCOTP_LOCK_ROM5(v)   (((v) << 29) & BM_OCOTP_LOCK_ROM5)
/* --- Register HW_OCOTP_LOCK, field ROM4 */

#define BP_OCOTP_LOCK_ROM4      28
#define BM_OCOTP_LOCK_ROM4      0x10000000

#define BF_OCOTP_LOCK_ROM4(v)   (((v) << 28) & BM_OCOTP_LOCK_ROM4)
/* --- Register HW_OCOTP_LOCK, field ROM3 */

#define BP_OCOTP_LOCK_ROM3      27
#define BM_OCOTP_LOCK_ROM3      0x08000000

#define BF_OCOTP_LOCK_ROM3(v)   (((v) << 27) & BM_OCOTP_LOCK_ROM3)
/* --- Register HW_OCOTP_LOCK, field ROM2 */

#define BP_OCOTP_LOCK_ROM2      26
#define BM_OCOTP_LOCK_ROM2      0x04000000

#define BF_OCOTP_LOCK_ROM2(v)   (((v) << 26) & BM_OCOTP_LOCK_ROM2)
/* --- Register HW_OCOTP_LOCK, field ROM1 */

#define BP_OCOTP_LOCK_ROM1      25
#define BM_OCOTP_LOCK_ROM1      0x02000000

#define BF_OCOTP_LOCK_ROM1(v)   (((v) << 25) & BM_OCOTP_LOCK_ROM1)
/* --- Register HW_OCOTP_LOCK, field ROM0 */

#define BP_OCOTP_LOCK_ROM0      24
#define BM_OCOTP_LOCK_ROM0      0x01000000

#define BF_OCOTP_LOCK_ROM0(v)   (((v) << 24) & BM_OCOTP_LOCK_ROM0)
/* --- Register HW_OCOTP_LOCK, field HWSW_SHADOW_ALT */

#define BP_OCOTP_LOCK_HWSW_SHADOW_ALT      23
#define BM_OCOTP_LOCK_HWSW_SHADOW_ALT      0x00800000

#define BF_OCOTP_LOCK_HWSW_SHADOW_ALT(v)   (((v) << 23) & BM_OCOTP_LOCK_HWSW_SHADOW_ALT)
/* --- Register HW_OCOTP_LOCK, field CRYPTODCP_ALT */

#define BP_OCOTP_LOCK_CRYPTODCP_ALT      22
#define BM_OCOTP_LOCK_CRYPTODCP_ALT      0x00400000

#define BF_OCOTP_LOCK_CRYPTODCP_ALT(v)   (((v) << 22) & BM_OCOTP_LOCK_CRYPTODCP_ALT)
/* --- Register HW_OCOTP_LOCK, field CRYPTOKEY_ALT */

#define BP_OCOTP_LOCK_CRYPTOKEY_ALT      21
#define BM_OCOTP_LOCK_CRYPTOKEY_ALT      0x00200000

#define BF_OCOTP_LOCK_CRYPTOKEY_ALT(v)   (((v) << 21) & BM_OCOTP_LOCK_CRYPTOKEY_ALT)
/* --- Register HW_OCOTP_LOCK, field PIN */

#define BP_OCOTP_LOCK_PIN      20
#define BM_OCOTP_LOCK_PIN      0x00100000

#define BF_OCOTP_LOCK_PIN(v)   (((v) << 20) & BM_OCOTP_LOCK_PIN)
/* --- Register HW_OCOTP_LOCK, field OPS */

#define BP_OCOTP_LOCK_OPS      19
#define BM_OCOTP_LOCK_OPS      0x00080000

#define BF_OCOTP_LOCK_OPS(v)   (((v) << 19) & BM_OCOTP_LOCK_OPS)
/* --- Register HW_OCOTP_LOCK, field UN2 */

#define BP_OCOTP_LOCK_UN2      18
#define BM_OCOTP_LOCK_UN2      0x00040000

#define BF_OCOTP_LOCK_UN2(v)   (((v) << 18) & BM_OCOTP_LOCK_UN2)
/* --- Register HW_OCOTP_LOCK, field UN1 */

#define BP_OCOTP_LOCK_UN1      17
#define BM_OCOTP_LOCK_UN1      0x00020000

#define BF_OCOTP_LOCK_UN1(v)   (((v) << 17) & BM_OCOTP_LOCK_UN1)
/* --- Register HW_OCOTP_LOCK, field UN0 */

#define BP_OCOTP_LOCK_UN0      16
#define BM_OCOTP_LOCK_UN0      0x00010000

#define BF_OCOTP_LOCK_UN0(v)   (((v) << 16) & BM_OCOTP_LOCK_UN0)
/* --- Register HW_OCOTP_LOCK, field SRK */

#define BP_OCOTP_LOCK_SRK      15
#define BM_OCOTP_LOCK_SRK      0x00008000

#define BF_OCOTP_LOCK_SRK(v)   (((v) << 15) & BM_OCOTP_LOCK_SRK)
/* --- Register HW_OCOTP_LOCK, field UNALLOCATED */

#define BP_OCOTP_LOCK_UNALLOCATED      12
#define BM_OCOTP_LOCK_UNALLOCATED      0x00007000

#define BF_OCOTP_LOCK_UNALLOCATED(v)   (((v) << 12) & BM_OCOTP_LOCK_UNALLOCATED)
/* --- Register HW_OCOTP_LOCK, field SRK_SHADOW */

#define BP_OCOTP_LOCK_SRK_SHADOW      11
#define BM_OCOTP_LOCK_SRK_SHADOW      0x00000800

#define BF_OCOTP_LOCK_SRK_SHADOW(v)   (((v) << 11) & BM_OCOTP_LOCK_SRK_SHADOW)
/* --- Register HW_OCOTP_LOCK, field ROM_SHADOW */

#define BP_OCOTP_LOCK_ROM_SHADOW      10
#define BM_OCOTP_LOCK_ROM_SHADOW      0x00000400

#define BF_OCOTP_LOCK_ROM_SHADOW(v)   (((v) << 10) & BM_OCOTP_LOCK_ROM_SHADOW)
/* --- Register HW_OCOTP_LOCK, field CUSTCAP */

#define BP_OCOTP_LOCK_CUSTCAP      9
#define BM_OCOTP_LOCK_CUSTCAP      0x00000200

#define BF_OCOTP_LOCK_CUSTCAP(v)   (((v) << 9) & BM_OCOTP_LOCK_CUSTCAP)
/* --- Register HW_OCOTP_LOCK, field HWSW */

#define BP_OCOTP_LOCK_HWSW      8
#define BM_OCOTP_LOCK_HWSW      0x00000100

#define BF_OCOTP_LOCK_HWSW(v)   (((v) << 8) & BM_OCOTP_LOCK_HWSW)
/* --- Register HW_OCOTP_LOCK, field CUSTCAP_SHADOW */

#define BP_OCOTP_LOCK_CUSTCAP_SHADOW      7
#define BM_OCOTP_LOCK_CUSTCAP_SHADOW      0x00000080

#define BF_OCOTP_LOCK_CUSTCAP_SHADOW(v)   (((v) << 7) & BM_OCOTP_LOCK_CUSTCAP_SHADOW)
/* --- Register HW_OCOTP_LOCK, field HWSW_SHADOW */

#define BP_OCOTP_LOCK_HWSW_SHADOW      6
#define BM_OCOTP_LOCK_HWSW_SHADOW      0x00000040

#define BF_OCOTP_LOCK_HWSW_SHADOW(v)   (((v) << 6) & BM_OCOTP_LOCK_HWSW_SHADOW)
/* --- Register HW_OCOTP_LOCK, field CRYPTODCP */

#define BP_OCOTP_LOCK_CRYPTODCP      5
#define BM_OCOTP_LOCK_CRYPTODCP      0x00000020

#define BF_OCOTP_LOCK_CRYPTODCP(v)   (((v) << 5) & BM_OCOTP_LOCK_CRYPTODCP)
/* --- Register HW_OCOTP_LOCK, field CRYPTOKEY */

#define BP_OCOTP_LOCK_CRYPTOKEY      4
#define BM_OCOTP_LOCK_CRYPTOKEY      0x00000010

#define BF_OCOTP_LOCK_CRYPTOKEY(v)   (((v) << 4) & BM_OCOTP_LOCK_CRYPTOKEY)
/* --- Register HW_OCOTP_LOCK, field CUST3 */

#define BP_OCOTP_LOCK_CUST3      3
#define BM_OCOTP_LOCK_CUST3      0x00000008

#define BF_OCOTP_LOCK_CUST3(v)   (((v) << 3) & BM_OCOTP_LOCK_CUST3)
/* --- Register HW_OCOTP_LOCK, field CUST2 */

#define BP_OCOTP_LOCK_CUST2      2
#define BM_OCOTP_LOCK_CUST2      0x00000004

#define BF_OCOTP_LOCK_CUST2(v)   (((v) << 2) & BM_OCOTP_LOCK_CUST2)
/* --- Register HW_OCOTP_LOCK, field CUST1 */

#define BP_OCOTP_LOCK_CUST1      1
#define BM_OCOTP_LOCK_CUST1      0x00000002

#define BF_OCOTP_LOCK_CUST1(v)   (((v) << 1) & BM_OCOTP_LOCK_CUST1)
/* --- Register HW_OCOTP_LOCK, field CUST0 */

#define BP_OCOTP_LOCK_CUST0      0
#define BM_OCOTP_LOCK_CUST0      0x00000001

#define BF_OCOTP_LOCK_CUST0(v)   (((v) << 0) & BM_OCOTP_LOCK_CUST0)


/*
 *  multi-register-define name HW_OCOTP_OPSn
 *              base 0x00000130
 *              count 4
 *              offset 0x10
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BITS  : 32;
    } B;
} hw_ocotp_opsn_t;
#endif

    /*
     * constants & macros for entire HW_OCOTP_OPSn multi-register
     */
    #define HW_OCOTP_OPSn_COUNT        4
    #define HW_OCOTP_OPSn_ADDR(n)      (REGS_OCOTP_BASE + 0x130 + ((n) * 0x10))

    #ifndef __LANGUAGE_ASM__
    #define HW_OCOTP_OPSn(n)           (*(volatile hw_ocotp_opsn_t *) HW_OCOTP_OPSn_ADDR(n))
    #define HW_OCOTP_OPSn_RD(n)        (HW_OCOTP_OPSn(n).U)
    #endif


/*
 * constants & macros for individual HW_OCOTP_OPSn multi-register bitfields
 */
/* --- Register HW_OCOTP_OPSn, field BITS */

#define BP_OCOTP_OPSn_BITS      0
#define BM_OCOTP_OPSn_BITS      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_OCOTP_OPSn_BITS(v)   ((reg32_t) v)
#else
#define BF_OCOTP_OPSn_BITS(v)   (v)
#endif


/*
 *  multi-register-define name HW_OCOTP_UNn
 *              base 0x00000170
 *              count 3
 *              offset 0x10
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BITS  : 32;
    } B;
} hw_ocotp_unn_t;
#endif

    /*
     * constants & macros for entire HW_OCOTP_UNn multi-register
     */
    #define HW_OCOTP_UNn_COUNT        3
    #define HW_OCOTP_UNn_ADDR(n)      (REGS_OCOTP_BASE + 0x170 + ((n) * 0x10))

    #ifndef __LANGUAGE_ASM__
    #define HW_OCOTP_UNn(n)           (*(volatile hw_ocotp_unn_t *) HW_OCOTP_UNn_ADDR(n))
    #define HW_OCOTP_UNn_RD(n)        (HW_OCOTP_UNn(n).U)
    #endif


/*
 * constants & macros for individual HW_OCOTP_UNn multi-register bitfields
 */
/* --- Register HW_OCOTP_UNn, field BITS */

#define BP_OCOTP_UNn_BITS      0
#define BM_OCOTP_UNn_BITS      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_OCOTP_UNn_BITS(v)   ((reg32_t) v)
#else
#define BF_OCOTP_UNn_BITS(v)   (v)
#endif


/*
 *  multi-register-define name HW_OCOTP_ROMn
 *              base 0x000001A0
 *              count 8
 *              offset 0x10
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSRVD0                      :  1;
        unsigned RSRVD1                      :  1;
        unsigned RSRVD2                      :  1;
        unsigned SD_MBR_BOOT                 :  1;
        unsigned ENABLE_UNENCRYPTED_BOOT     :  1;
        unsigned ENABLE_USB_BOOT_SERIAL_NUM  :  1;
        unsigned DISABLE_SPI_NOR_FAST_READ   :  1;
        unsigned EMMC_USE_DDR                :  1;
        unsigned SSP_SCK_INDEX               :  4;
        unsigned SD_BUS_WIDTH                :  2;
        unsigned SD_POWER_UP_DELAY           :  6;
        unsigned SD_POWER_GATE_GPIO          :  2;
        unsigned SD_MMC_MODE                 :  2;
        unsigned BOOT_MODE                   :  8;
    } B;
} hw_ocotp_romn_t;
#endif

    /*
     * constants & macros for entire HW_OCOTP_ROMn multi-register
     */
    #define HW_OCOTP_ROMn_COUNT        8
    #define HW_OCOTP_ROMn_ADDR(n)      (REGS_OCOTP_BASE + 0x1a0 + ((n) * 0x10))

    #ifndef __LANGUAGE_ASM__
    #define HW_OCOTP_ROMn(n)           (*(volatile hw_ocotp_romn_t *) HW_OCOTP_ROMn_ADDR(n))
    #define HW_OCOTP_ROMn_RD(n)        (HW_OCOTP_ROMn(n).U)
    #define HW_OCOTP_ROMn_WR(n, v)     (HW_OCOTP_ROMn(n).U = (v))
    #define HW_OCOTP_ROMn_SET(n, v)    (HW_OCOTP_ROMn_WR(n, HW_OCOTP_ROMn_RD(n) |  (v)))
    #define HW_OCOTP_ROMn_CLR(n, v)    (HW_OCOTP_ROMn_WR(n, HW_OCOTP_ROMn_RD(n) & ~(v)))
    #define HW_OCOTP_ROMn_TOG(n, v)    (HW_OCOTP_ROMn_WR(n, HW_OCOTP_ROMn_RD(n) ^  (v)))
    #endif


/*
 * constants & macros for individual HW_OCOTP_ROMn multi-register bitfields
 */
/* --- Register HW_OCOTP_ROMn, field BOOT_MODE */

#define BP_OCOTP_ROMn_BOOT_MODE      24
#define BM_OCOTP_ROMn_BOOT_MODE      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_OCOTP_ROMn_BOOT_MODE(v)   ((((reg32_t) v) << 24) & BM_OCOTP_ROMn_BOOT_MODE)
#else
#define BF_OCOTP_ROMn_BOOT_MODE(v)   (((v) << 24) & BM_OCOTP_ROMn_BOOT_MODE)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_OCOTP_ROMn_BOOT_MODE(n, v)  (HW_OCOTP_ROMn(n).B.BOOT_MODE = (v))
#endif

/* --- Register HW_OCOTP_ROMn, field SD_MMC_MODE */

#define BP_OCOTP_ROMn_SD_MMC_MODE      22
#define BM_OCOTP_ROMn_SD_MMC_MODE      0x00C00000

#define BF_OCOTP_ROMn_SD_MMC_MODE(v)   (((v) << 22) & BM_OCOTP_ROMn_SD_MMC_MODE)
#ifndef __LANGUAGE_ASM__
#define BW_OCOTP_ROMn_SD_MMC_MODE(n, v)  BF_CS1n(OCOTP_ROMn, n, SD_MMC_MODE, v)
#endif

/* --- Register HW_OCOTP_ROMn, field SD_POWER_GATE_GPIO */

#define BP_OCOTP_ROMn_SD_POWER_GATE_GPIO      20
#define BM_OCOTP_ROMn_SD_POWER_GATE_GPIO      0x00300000

#define BF_OCOTP_ROMn_SD_POWER_GATE_GPIO(v)   (((v) << 20) & BM_OCOTP_ROMn_SD_POWER_GATE_GPIO)
#ifndef __LANGUAGE_ASM__
#define BW_OCOTP_ROMn_SD_POWER_GATE_GPIO(n, v)  BF_CS1n(OCOTP_ROMn, n, SD_POWER_GATE_GPIO, v)
#endif

/* --- Register HW_OCOTP_ROMn, field SD_POWER_UP_DELAY */

#define BP_OCOTP_ROMn_SD_POWER_UP_DELAY      14
#define BM_OCOTP_ROMn_SD_POWER_UP_DELAY      0x000FC000

#define BF_OCOTP_ROMn_SD_POWER_UP_DELAY(v)   (((v) << 14) & BM_OCOTP_ROMn_SD_POWER_UP_DELAY)
#ifndef __LANGUAGE_ASM__
#define BW_OCOTP_ROMn_SD_POWER_UP_DELAY(n, v)  BF_CS1n(OCOTP_ROMn, n, SD_POWER_UP_DELAY, v)
#endif

/* --- Register HW_OCOTP_ROMn, field SD_BUS_WIDTH */

#define BP_OCOTP_ROMn_SD_BUS_WIDTH      12
#define BM_OCOTP_ROMn_SD_BUS_WIDTH      0x00003000

#define BF_OCOTP_ROMn_SD_BUS_WIDTH(v)   (((v) << 12) & BM_OCOTP_ROMn_SD_BUS_WIDTH)
#ifndef __LANGUAGE_ASM__
#define BW_OCOTP_ROMn_SD_BUS_WIDTH(n, v)  BF_CS1n(OCOTP_ROMn, n, SD_BUS_WIDTH, v)
#endif

/* --- Register HW_OCOTP_ROMn, field SSP_SCK_INDEX */

#define BP_OCOTP_ROMn_SSP_SCK_INDEX      8
#define BM_OCOTP_ROMn_SSP_SCK_INDEX      0x00000F00

#define BF_OCOTP_ROMn_SSP_SCK_INDEX(v)   (((v) << 8) & BM_OCOTP_ROMn_SSP_SCK_INDEX)
#ifndef __LANGUAGE_ASM__
#define BW_OCOTP_ROMn_SSP_SCK_INDEX(n, v)  BF_CS1n(OCOTP_ROMn, n, SSP_SCK_INDEX, v)
#endif

/* --- Register HW_OCOTP_ROMn, field EMMC_USE_DDR */

#define BP_OCOTP_ROMn_EMMC_USE_DDR      7
#define BM_OCOTP_ROMn_EMMC_USE_DDR      0x00000080

#define BF_OCOTP_ROMn_EMMC_USE_DDR(v)   (((v) << 7) & BM_OCOTP_ROMn_EMMC_USE_DDR)
#ifndef __LANGUAGE_ASM__
#define BW_OCOTP_ROMn_EMMC_USE_DDR(n, v)  BF_CS1n(OCOTP_ROMn, n, EMMC_USE_DDR, v)
#endif

/* --- Register HW_OCOTP_ROMn, field DISABLE_SPI_NOR_FAST_READ */

#define BP_OCOTP_ROMn_DISABLE_SPI_NOR_FAST_READ      6
#define BM_OCOTP_ROMn_DISABLE_SPI_NOR_FAST_READ      0x00000040

#define BF_OCOTP_ROMn_DISABLE_SPI_NOR_FAST_READ(v)   (((v) << 6) & BM_OCOTP_ROMn_DISABLE_SPI_NOR_FAST_READ)
#ifndef __LANGUAGE_ASM__
#define BW_OCOTP_ROMn_DISABLE_SPI_NOR_FAST_READ(n, v)  BF_CS1n(OCOTP_ROMn, n, DISABLE_SPI_NOR_FAST_READ, v)
#endif

/* --- Register HW_OCOTP_ROMn, field ENABLE_USB_BOOT_SERIAL_NUM */

#define BP_OCOTP_ROMn_ENABLE_USB_BOOT_SERIAL_NUM      5
#define BM_OCOTP_ROMn_ENABLE_USB_BOOT_SERIAL_NUM      0x00000020

#define BF_OCOTP_ROMn_ENABLE_USB_BOOT_SERIAL_NUM(v)   (((v) << 5) & BM_OCOTP_ROMn_ENABLE_USB_BOOT_SERIAL_NUM)
#ifndef __LANGUAGE_ASM__
#define BW_OCOTP_ROMn_ENABLE_USB_BOOT_SERIAL_NUM(n, v)  BF_CS1n(OCOTP_ROMn, n, ENABLE_USB_BOOT_SERIAL_NUM, v)
#endif

/* --- Register HW_OCOTP_ROMn, field ENABLE_UNENCRYPTED_BOOT */

#define BP_OCOTP_ROMn_ENABLE_UNENCRYPTED_BOOT      4
#define BM_OCOTP_ROMn_ENABLE_UNENCRYPTED_BOOT      0x00000010

#define BF_OCOTP_ROMn_ENABLE_UNENCRYPTED_BOOT(v)   (((v) << 4) & BM_OCOTP_ROMn_ENABLE_UNENCRYPTED_BOOT)
#ifndef __LANGUAGE_ASM__
#define BW_OCOTP_ROMn_ENABLE_UNENCRYPTED_BOOT(n, v)  BF_CS1n(OCOTP_ROMn, n, ENABLE_UNENCRYPTED_BOOT, v)
#endif

/* --- Register HW_OCOTP_ROMn, field SD_MBR_BOOT */

#define BP_OCOTP_ROMn_SD_MBR_BOOT      3
#define BM_OCOTP_ROMn_SD_MBR_BOOT      0x00000008

#define BF_OCOTP_ROMn_SD_MBR_BOOT(v)   (((v) << 3) & BM_OCOTP_ROMn_SD_MBR_BOOT)
#ifndef __LANGUAGE_ASM__
#define BW_OCOTP_ROMn_SD_MBR_BOOT(n, v)  BF_CS1n(OCOTP_ROMn, n, SD_MBR_BOOT, v)
#endif

/* --- Register HW_OCOTP_ROMn, field RSRVD2 */

#define BP_OCOTP_ROMn_RSRVD2      2
#define BM_OCOTP_ROMn_RSRVD2      0x00000004

#define BF_OCOTP_ROMn_RSRVD2(v)   (((v) << 2) & BM_OCOTP_ROMn_RSRVD2)
/* --- Register HW_OCOTP_ROMn, field RSRVD1 */

#define BP_OCOTP_ROMn_RSRVD1      1
#define BM_OCOTP_ROMn_RSRVD1      0x00000002

#define BF_OCOTP_ROMn_RSRVD1(v)   (((v) << 1) & BM_OCOTP_ROMn_RSRVD1)
/* --- Register HW_OCOTP_ROMn, field RSRVD0 */

#define BP_OCOTP_ROMn_RSRVD0      0
#define BM_OCOTP_ROMn_RSRVD0      0x00000001

#define BF_OCOTP_ROMn_RSRVD0(v)   (((v) << 0) & BM_OCOTP_ROMn_RSRVD0)


/*
 *  multi-register-define name HW_OCOTP_SRKn
 *              base 0x00000220
 *              count 8
 *              offset 0x10
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BITS  : 32;
    } B;
} hw_ocotp_srkn_t;
#endif

    /*
     * constants & macros for entire HW_OCOTP_SRKn multi-register
     */
    #define HW_OCOTP_SRKn_COUNT        8
    #define HW_OCOTP_SRKn_ADDR(n)      (REGS_OCOTP_BASE + 0x220 + ((n) * 0x10))

    #ifndef __LANGUAGE_ASM__
    #define HW_OCOTP_SRKn(n)           (*(volatile hw_ocotp_srkn_t *) HW_OCOTP_SRKn_ADDR(n))
    #define HW_OCOTP_SRKn_RD(n)        (HW_OCOTP_SRKn(n).U)
    #define HW_OCOTP_SRKn_WR(n, v)     (HW_OCOTP_SRKn(n).U = (v))
    #define HW_OCOTP_SRKn_SET(n, v)    (HW_OCOTP_SRKn_WR(n, HW_OCOTP_SRKn_RD(n) |  (v)))
    #define HW_OCOTP_SRKn_CLR(n, v)    (HW_OCOTP_SRKn_WR(n, HW_OCOTP_SRKn_RD(n) & ~(v)))
    #define HW_OCOTP_SRKn_TOG(n, v)    (HW_OCOTP_SRKn_WR(n, HW_OCOTP_SRKn_RD(n) ^  (v)))
    #endif


/*
 * constants & macros for individual HW_OCOTP_SRKn multi-register bitfields
 */
/* --- Register HW_OCOTP_SRKn, field BITS */

#define BP_OCOTP_SRKn_BITS      0
#define BM_OCOTP_SRKn_BITS      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_OCOTP_SRKn_BITS(v)   ((reg32_t) v)
#else
#define BF_OCOTP_SRKn_BITS(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_OCOTP_SRKn_BITS(n, v)  (HW_OCOTP_SRKn(n).B.BITS = (v))
#endif



/*
 * HW_OCOTP_VERSION - OTP Controller Version Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned STEP   : 16;
        unsigned MINOR  :  8;
        unsigned MAJOR  :  8;
    } B;
} hw_ocotp_version_t;
#endif

/*
 * constants & macros for entire HW_OCOTP_VERSION register
 */
#define HW_OCOTP_VERSION_ADDR         (REGS_OCOTP_BASE + 0x2a0)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_VERSION           (*(volatile hw_ocotp_version_t *) HW_OCOTP_VERSION_ADDR)
#define HW_OCOTP_VERSION_RD()      (HW_OCOTP_VERSION.U)
#endif


/*
 * constants & macros for individual HW_OCOTP_VERSION bitfields
 */
/* --- Register HW_OCOTP_VERSION, field MAJOR */

#define BP_OCOTP_VERSION_MAJOR      24
#define BM_OCOTP_VERSION_MAJOR      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_OCOTP_VERSION_MAJOR(v)   ((((reg32_t) v) << 24) & BM_OCOTP_VERSION_MAJOR)
#else
#define BF_OCOTP_VERSION_MAJOR(v)   (((v) << 24) & BM_OCOTP_VERSION_MAJOR)
#endif
/* --- Register HW_OCOTP_VERSION, field MINOR */

#define BP_OCOTP_VERSION_MINOR      16
#define BM_OCOTP_VERSION_MINOR      0x00FF0000

#define BF_OCOTP_VERSION_MINOR(v)   (((v) << 16) & BM_OCOTP_VERSION_MINOR)
/* --- Register HW_OCOTP_VERSION, field STEP */

#define BP_OCOTP_VERSION_STEP      0
#define BM_OCOTP_VERSION_STEP      0x0000FFFF

#define BF_OCOTP_VERSION_STEP(v)   (((v) << 0) & BM_OCOTP_VERSION_STEP)

#endif /* _OCOTP_H */

////////////////////////////////////////////////////////////////////////////////
