/*
 * Copyright 2008-2009 Freescale Semiconductor, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

 * WARNING!  THIS FILE IS AUTOMATICALLY GENERATED FROM XML.
 *                DO NOT MODIFY THIS FILE DIRECTLY.
 *
 * Xml Revision: 4.0
 *
 * Template revision: 26195
 *
 *
 * The following naming conventions are followed in this file.
 *      XX_<module>_<regname>_<field>
 *
 * XX specifies the define / macro class
 *      HW pertains to a register
 *      BM indicates a Bit Mask
 *      BF indicates a Bit Field macro
 *
 * <module> is the hardware module name which can be any of the following...
 *      USB20 (Note when there is more than one copy of a given module, the
 *      module name includes a number starting from 0 for the first instance
 *      of that module)
 *
 * <regname> is the specific register within that module
 *
 * <field> is the specific bitfield within that <module>_<register>
 *
 * We also define the following...
 *      hw_<module>_<regname>_t is typedef of anonymous union
 *
 */

#ifndef _SSP_H
#define _SSP_H  1

#include "regs.h"

#ifndef REGS_SSP_BASE
#define REGS_SSP0_BASE (REGS_BASE + 0x10000)
#define REGS_SSP1_BASE (REGS_BASE + 0x12000)
#define REGS_SSP2_BASE (REGS_BASE + 0x14000)
#define REGS_SSP3_BASE (REGS_BASE + 0x16000)
#define REGS_SSP_BASE(x) ( x == 0 ? REGS_SSP0_BASE : x == 1 ? REGS_SSP1_BASE : x == 2 ? REGS_SSP2_BASE : x == 3 ? REGS_SSP3_BASE : 0xffff0000)
#endif

/*
 * HW_SSP_CTRL0 - SSP Control Register 0
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSVD0           : 16;
        unsigned ENABLE          :  1;
        unsigned GET_RESP        :  1;
        unsigned CHECK_RESP      :  1;
        unsigned LONG_RESP       :  1;
        unsigned WAIT_FOR_CMD    :  1;
        unsigned WAIT_FOR_IRQ    :  1;
        unsigned BUS_WIDTH       :  2;
        unsigned DATA_XFER       :  1;
        unsigned READ            :  1;
        unsigned IGNORE_CRC      :  1;
        unsigned LOCK_CS         :  1;
        unsigned SDIO_IRQ_CHECK  :  1;
        unsigned RUN             :  1;
        unsigned CLKGATE         :  1;
        unsigned SFTRST          :  1;
    } B;
} hw_ssp_ctrl0_t;
#endif

/*
 * constants & macros for entire multi-block HW_SSP_CTRL0 register
 */
#define HW_SSP_CTRL0_ADDR(x)      (REGS_SSP_BASE(x) + 0x0)
#define HW_SSP_CTRL0_SET_ADDR(x)  (HW_SSP_CTRL0_ADDR(x) + 4)
#define HW_SSP_CTRL0_CLR_ADDR(x)  (HW_SSP_CTRL0_ADDR(x) + 8)
#define HW_SSP_CTRL0_TOG_ADDR(x)  (HW_SSP_CTRL0_ADDR(x) + 12)

#ifndef __LANGUAGE_ASM__
#define HW_SSP_CTRL0(x)           (*(volatile hw_ssp_ctrl0_t *) HW_SSP_CTRL0_ADDR(x))
#define HW_SSP_CTRL0_RD(x)      (HW_SSP_CTRL0(x).U)
#define HW_SSP_CTRL0_WR(x, v)     (HW_SSP_CTRL0(x).U = (v))
#define HW_SSP_CTRL0_SET(x, v)    ((*(volatile reg32_t *) HW_SSP_CTRL0_SET_ADDR(x)) = (v))
#define HW_SSP_CTRL0_CLR(x, v)    ((*(volatile reg32_t *) HW_SSP_CTRL0_CLR_ADDR(x)) = (v))
#define HW_SSP_CTRL0_TOG(x, v)    ((*(volatile reg32_t *) HW_SSP_CTRL0_TOG_ADDR(x)) = (v))
#endif


/*
 * constants & macros for individual HW_SSP_CTRL0 bitfields
 */
/* --- Register HW_SSP_CTRL0, field SFTRST */

#define BP_SSP_CTRL0_SFTRST      31
#define BM_SSP_CTRL0_SFTRST      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_SSP_CTRL0_SFTRST(v)   ((((reg32_t) v) << 31) & BM_SSP_CTRL0_SFTRST)
#else
#define BF_SSP_CTRL0_SFTRST(v)   (((v) << 31) & BM_SSP_CTRL0_SFTRST)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL0_SFTRST(n, v)   BFn_CS1(SSP_CTRL0, n, SFTRST, v)
#endif

/* --- Register HW_SSP_CTRL0, field CLKGATE */

#define BP_SSP_CTRL0_CLKGATE      30
#define BM_SSP_CTRL0_CLKGATE      0x40000000

#define BF_SSP_CTRL0_CLKGATE(v)   (((v) << 30) & BM_SSP_CTRL0_CLKGATE)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL0_CLKGATE(n, v)   BFn_CS1(SSP_CTRL0, n, CLKGATE, v)
#endif

/* --- Register HW_SSP_CTRL0, field RUN */

#define BP_SSP_CTRL0_RUN      29
#define BM_SSP_CTRL0_RUN      0x20000000

#define BF_SSP_CTRL0_RUN(v)   (((v) << 29) & BM_SSP_CTRL0_RUN)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL0_RUN(n, v)   BFn_CS1(SSP_CTRL0, n, RUN, v)
#endif

/* --- Register HW_SSP_CTRL0, field SDIO_IRQ_CHECK */

#define BP_SSP_CTRL0_SDIO_IRQ_CHECK      28
#define BM_SSP_CTRL0_SDIO_IRQ_CHECK      0x10000000

#define BF_SSP_CTRL0_SDIO_IRQ_CHECK(v)   (((v) << 28) & BM_SSP_CTRL0_SDIO_IRQ_CHECK)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL0_SDIO_IRQ_CHECK(n, v)   BFn_CS1(SSP_CTRL0, n, SDIO_IRQ_CHECK, v)
#endif

/* --- Register HW_SSP_CTRL0, field LOCK_CS */

#define BP_SSP_CTRL0_LOCK_CS      27
#define BM_SSP_CTRL0_LOCK_CS      0x08000000

#define BF_SSP_CTRL0_LOCK_CS(v)   (((v) << 27) & BM_SSP_CTRL0_LOCK_CS)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL0_LOCK_CS(n, v)   BFn_CS1(SSP_CTRL0, n, LOCK_CS, v)
#endif

/* --- Register HW_SSP_CTRL0, field IGNORE_CRC */

#define BP_SSP_CTRL0_IGNORE_CRC      26
#define BM_SSP_CTRL0_IGNORE_CRC      0x04000000

#define BF_SSP_CTRL0_IGNORE_CRC(v)   (((v) << 26) & BM_SSP_CTRL0_IGNORE_CRC)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL0_IGNORE_CRC(n, v)   BFn_CS1(SSP_CTRL0, n, IGNORE_CRC, v)
#endif

/* --- Register HW_SSP_CTRL0, field READ */

#define BP_SSP_CTRL0_READ      25
#define BM_SSP_CTRL0_READ      0x02000000

#define BF_SSP_CTRL0_READ(v)   (((v) << 25) & BM_SSP_CTRL0_READ)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL0_READ(n, v)   BFn_CS1(SSP_CTRL0, n, READ, v)
#endif

/* --- Register HW_SSP_CTRL0, field DATA_XFER */

#define BP_SSP_CTRL0_DATA_XFER      24
#define BM_SSP_CTRL0_DATA_XFER      0x01000000

#define BF_SSP_CTRL0_DATA_XFER(v)   (((v) << 24) & BM_SSP_CTRL0_DATA_XFER)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL0_DATA_XFER(n, v)   BFn_CS1(SSP_CTRL0, n, DATA_XFER, v)
#endif

/* --- Register HW_SSP_CTRL0, field BUS_WIDTH */

#define BP_SSP_CTRL0_BUS_WIDTH      22
#define BM_SSP_CTRL0_BUS_WIDTH      0x00C00000

#define BF_SSP_CTRL0_BUS_WIDTH(v)   (((v) << 22) & BM_SSP_CTRL0_BUS_WIDTH)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL0_BUS_WIDTH(n, v)   BFn_CS1(SSP_CTRL0, n, BUS_WIDTH, v)
#endif

#define BV_SSP_CTRL0_BUS_WIDTH__ONE_BIT    0x0
#define BV_SSP_CTRL0_BUS_WIDTH__FOUR_BIT   0x1
#define BV_SSP_CTRL0_BUS_WIDTH__EIGHT_BIT  0x2

/* --- Register HW_SSP_CTRL0, field WAIT_FOR_IRQ */

#define BP_SSP_CTRL0_WAIT_FOR_IRQ      21
#define BM_SSP_CTRL0_WAIT_FOR_IRQ      0x00200000

#define BF_SSP_CTRL0_WAIT_FOR_IRQ(v)   (((v) << 21) & BM_SSP_CTRL0_WAIT_FOR_IRQ)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL0_WAIT_FOR_IRQ(n, v)   BFn_CS1(SSP_CTRL0, n, WAIT_FOR_IRQ, v)
#endif

/* --- Register HW_SSP_CTRL0, field WAIT_FOR_CMD */

#define BP_SSP_CTRL0_WAIT_FOR_CMD      20
#define BM_SSP_CTRL0_WAIT_FOR_CMD      0x00100000

#define BF_SSP_CTRL0_WAIT_FOR_CMD(v)   (((v) << 20) & BM_SSP_CTRL0_WAIT_FOR_CMD)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL0_WAIT_FOR_CMD(n, v)   BFn_CS1(SSP_CTRL0, n, WAIT_FOR_CMD, v)
#endif

/* --- Register HW_SSP_CTRL0, field LONG_RESP */

#define BP_SSP_CTRL0_LONG_RESP      19
#define BM_SSP_CTRL0_LONG_RESP      0x00080000

#define BF_SSP_CTRL0_LONG_RESP(v)   (((v) << 19) & BM_SSP_CTRL0_LONG_RESP)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL0_LONG_RESP(n, v)   BFn_CS1(SSP_CTRL0, n, LONG_RESP, v)
#endif

/* --- Register HW_SSP_CTRL0, field CHECK_RESP */

#define BP_SSP_CTRL0_CHECK_RESP      18
#define BM_SSP_CTRL0_CHECK_RESP      0x00040000

#define BF_SSP_CTRL0_CHECK_RESP(v)   (((v) << 18) & BM_SSP_CTRL0_CHECK_RESP)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL0_CHECK_RESP(n, v)   BFn_CS1(SSP_CTRL0, n, CHECK_RESP, v)
#endif

/* --- Register HW_SSP_CTRL0, field GET_RESP */

#define BP_SSP_CTRL0_GET_RESP      17
#define BM_SSP_CTRL0_GET_RESP      0x00020000

#define BF_SSP_CTRL0_GET_RESP(v)   (((v) << 17) & BM_SSP_CTRL0_GET_RESP)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL0_GET_RESP(n, v)   BFn_CS1(SSP_CTRL0, n, GET_RESP, v)
#endif

/* --- Register HW_SSP_CTRL0, field ENABLE */

#define BP_SSP_CTRL0_ENABLE      16
#define BM_SSP_CTRL0_ENABLE      0x00010000

#define BF_SSP_CTRL0_ENABLE(v)   (((v) << 16) & BM_SSP_CTRL0_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL0_ENABLE(n, v)   BFn_CS1(SSP_CTRL0, n, ENABLE, v)
#endif

/* --- Register HW_SSP_CTRL0, field RSVD0 */

#define BP_SSP_CTRL0_RSVD0      0
#define BM_SSP_CTRL0_RSVD0      0x0000FFFF

#define BF_SSP_CTRL0_RSVD0(v)   (((v) << 0) & BM_SSP_CTRL0_RSVD0)


/*
 * HW_SSP_CMD0 - SD/MMC and MS Command Register 0
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned CMD               :  8;
        unsigned RSVD1             : 12;
        unsigned APPEND_8CYC       :  1;
        unsigned CONT_CLKING_EN    :  1;
        unsigned SLOW_CLKING_EN    :  1;
        unsigned BOOT_ACK_EN       :  1;
        unsigned PRIM_BOOT_OP_EN   :  1;
        unsigned DBL_DATA_RATE_EN  :  1;
        unsigned SOFT_TERMINATE    :  1;
        unsigned RSVD0             :  5;
    } B;
} hw_ssp_cmd0_t;
#endif

/*
 * constants & macros for entire multi-block HW_SSP_CMD0 register
 */
#define HW_SSP_CMD0_ADDR(x)      (REGS_SSP_BASE(x) + 0x10)
#define HW_SSP_CMD0_SET_ADDR(x)  (HW_SSP_CMD0_ADDR(x) + 4)
#define HW_SSP_CMD0_CLR_ADDR(x)  (HW_SSP_CMD0_ADDR(x) + 8)
#define HW_SSP_CMD0_TOG_ADDR(x)  (HW_SSP_CMD0_ADDR(x) + 12)

#ifndef __LANGUAGE_ASM__
#define HW_SSP_CMD0(x)           (*(volatile hw_ssp_cmd0_t *) HW_SSP_CMD0_ADDR(x))
#define HW_SSP_CMD0_RD(x)      (HW_SSP_CMD0(x).U)
#define HW_SSP_CMD0_WR(x, v)     (HW_SSP_CMD0(x).U = (v))
#define HW_SSP_CMD0_SET(x, v)    ((*(volatile reg32_t *) HW_SSP_CMD0_SET_ADDR(x)) = (v))
#define HW_SSP_CMD0_CLR(x, v)    ((*(volatile reg32_t *) HW_SSP_CMD0_CLR_ADDR(x)) = (v))
#define HW_SSP_CMD0_TOG(x, v)    ((*(volatile reg32_t *) HW_SSP_CMD0_TOG_ADDR(x)) = (v))
#endif


/*
 * constants & macros for individual HW_SSP_CMD0 bitfields
 */
/* --- Register HW_SSP_CMD0, field RSVD0 */

#define BP_SSP_CMD0_RSVD0      27
#define BM_SSP_CMD0_RSVD0      0xF8000000

#ifndef __LANGUAGE_ASM__
#define BF_SSP_CMD0_RSVD0(v)   ((((reg32_t) v) << 27) & BM_SSP_CMD0_RSVD0)
#else
#define BF_SSP_CMD0_RSVD0(v)   (((v) << 27) & BM_SSP_CMD0_RSVD0)
#endif
/* --- Register HW_SSP_CMD0, field SOFT_TERMINATE */

#define BP_SSP_CMD0_SOFT_TERMINATE      26
#define BM_SSP_CMD0_SOFT_TERMINATE      0x04000000

#define BF_SSP_CMD0_SOFT_TERMINATE(v)   (((v) << 26) & BM_SSP_CMD0_SOFT_TERMINATE)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CMD0_SOFT_TERMINATE(n, v)   BFn_CS1(SSP_CMD0, n, SOFT_TERMINATE, v)
#endif

/* --- Register HW_SSP_CMD0, field DBL_DATA_RATE_EN */

#define BP_SSP_CMD0_DBL_DATA_RATE_EN      25
#define BM_SSP_CMD0_DBL_DATA_RATE_EN      0x02000000

#define BF_SSP_CMD0_DBL_DATA_RATE_EN(v)   (((v) << 25) & BM_SSP_CMD0_DBL_DATA_RATE_EN)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CMD0_DBL_DATA_RATE_EN(n, v)   BFn_CS1(SSP_CMD0, n, DBL_DATA_RATE_EN, v)
#endif

/* --- Register HW_SSP_CMD0, field PRIM_BOOT_OP_EN */

#define BP_SSP_CMD0_PRIM_BOOT_OP_EN      24
#define BM_SSP_CMD0_PRIM_BOOT_OP_EN      0x01000000

#define BF_SSP_CMD0_PRIM_BOOT_OP_EN(v)   (((v) << 24) & BM_SSP_CMD0_PRIM_BOOT_OP_EN)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CMD0_PRIM_BOOT_OP_EN(n, v)   BFn_CS1(SSP_CMD0, n, PRIM_BOOT_OP_EN, v)
#endif

/* --- Register HW_SSP_CMD0, field BOOT_ACK_EN */

#define BP_SSP_CMD0_BOOT_ACK_EN      23
#define BM_SSP_CMD0_BOOT_ACK_EN      0x00800000

#define BF_SSP_CMD0_BOOT_ACK_EN(v)   (((v) << 23) & BM_SSP_CMD0_BOOT_ACK_EN)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CMD0_BOOT_ACK_EN(n, v)   BFn_CS1(SSP_CMD0, n, BOOT_ACK_EN, v)
#endif

/* --- Register HW_SSP_CMD0, field SLOW_CLKING_EN */

#define BP_SSP_CMD0_SLOW_CLKING_EN      22
#define BM_SSP_CMD0_SLOW_CLKING_EN      0x00400000

#define BF_SSP_CMD0_SLOW_CLKING_EN(v)   (((v) << 22) & BM_SSP_CMD0_SLOW_CLKING_EN)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CMD0_SLOW_CLKING_EN(n, v)   BFn_CS1(SSP_CMD0, n, SLOW_CLKING_EN, v)
#endif

/* --- Register HW_SSP_CMD0, field CONT_CLKING_EN */

#define BP_SSP_CMD0_CONT_CLKING_EN      21
#define BM_SSP_CMD0_CONT_CLKING_EN      0x00200000

#define BF_SSP_CMD0_CONT_CLKING_EN(v)   (((v) << 21) & BM_SSP_CMD0_CONT_CLKING_EN)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CMD0_CONT_CLKING_EN(n, v)   BFn_CS1(SSP_CMD0, n, CONT_CLKING_EN, v)
#endif

/* --- Register HW_SSP_CMD0, field APPEND_8CYC */

#define BP_SSP_CMD0_APPEND_8CYC      20
#define BM_SSP_CMD0_APPEND_8CYC      0x00100000

#define BF_SSP_CMD0_APPEND_8CYC(v)   (((v) << 20) & BM_SSP_CMD0_APPEND_8CYC)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CMD0_APPEND_8CYC(n, v)   BFn_CS1(SSP_CMD0, n, APPEND_8CYC, v)
#endif

/* --- Register HW_SSP_CMD0, field RSVD1 */

#define BP_SSP_CMD0_RSVD1      8
#define BM_SSP_CMD0_RSVD1      0x000FFF00

#define BF_SSP_CMD0_RSVD1(v)   (((v) << 8) & BM_SSP_CMD0_RSVD1)
/* --- Register HW_SSP_CMD0, field CMD */

#define BP_SSP_CMD0_CMD      0
#define BM_SSP_CMD0_CMD      0x000000FF

#define BF_SSP_CMD0_CMD(v)   (((v) << 0) & BM_SSP_CMD0_CMD)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CMD0_CMD(n, v)   (HW_SSP_CMD0(n).B.CMD = (v))
#endif

#define BV_SSP_CMD0_CMD__MMC_GO_IDLE_STATE         0x00
#define BV_SSP_CMD0_CMD__MMC_SEND_OP_COND          0x01
#define BV_SSP_CMD0_CMD__MMC_ALL_SEND_CID          0x02
#define BV_SSP_CMD0_CMD__MMC_SET_RELATIVE_ADDR     0x03
#define BV_SSP_CMD0_CMD__MMC_SET_DSR               0x04
#define BV_SSP_CMD0_CMD__MMC_RESERVED_5            0x05
#define BV_SSP_CMD0_CMD__MMC_SWITCH                0x06
#define BV_SSP_CMD0_CMD__MMC_SELECT_DESELECT_CARD  0x07
#define BV_SSP_CMD0_CMD__MMC_SEND_EXT_CSD          0x08
#define BV_SSP_CMD0_CMD__MMC_SEND_CSD              0x09
#define BV_SSP_CMD0_CMD__MMC_SEND_CID              0x0A
#define BV_SSP_CMD0_CMD__MMC_READ_DAT_UNTIL_STOP   0x0B
#define BV_SSP_CMD0_CMD__MMC_STOP_TRANSMISSION     0x0C
#define BV_SSP_CMD0_CMD__MMC_SEND_STATUS           0x0D
#define BV_SSP_CMD0_CMD__MMC_BUSTEST_R             0x0E
#define BV_SSP_CMD0_CMD__MMC_GO_INACTIVE_STATE     0x0F
#define BV_SSP_CMD0_CMD__MMC_SET_BLOCKLEN          0x10
#define BV_SSP_CMD0_CMD__MMC_READ_SINGLE_BLOCK     0x11
#define BV_SSP_CMD0_CMD__MMC_READ_MULTIPLE_BLOCK   0x12
#define BV_SSP_CMD0_CMD__MMC_BUSTEST_W             0x13
#define BV_SSP_CMD0_CMD__MMC_WRITE_DAT_UNTIL_STOP  0x14
#define BV_SSP_CMD0_CMD__MMC_SET_BLOCK_COUNT       0x17
#define BV_SSP_CMD0_CMD__MMC_WRITE_BLOCK           0x18
#define BV_SSP_CMD0_CMD__MMC_WRITE_MULTIPLE_BLOCK  0x19
#define BV_SSP_CMD0_CMD__MMC_PROGRAM_CID           0x1A
#define BV_SSP_CMD0_CMD__MMC_PROGRAM_CSD           0x1B
#define BV_SSP_CMD0_CMD__MMC_SET_WRITE_PROT        0x1C
#define BV_SSP_CMD0_CMD__MMC_CLR_WRITE_PROT        0x1D
#define BV_SSP_CMD0_CMD__MMC_SEND_WRITE_PROT       0x1E
#define BV_SSP_CMD0_CMD__MMC_ERASE_GROUP_START     0x23
#define BV_SSP_CMD0_CMD__MMC_ERASE_GROUP_END       0x24
#define BV_SSP_CMD0_CMD__MMC_ERASE                 0x26
#define BV_SSP_CMD0_CMD__MMC_FAST_IO               0x27
#define BV_SSP_CMD0_CMD__MMC_GO_IRQ_STATE          0x28
#define BV_SSP_CMD0_CMD__MMC_LOCK_UNLOCK           0x2A
#define BV_SSP_CMD0_CMD__MMC_APP_CMD               0x37
#define BV_SSP_CMD0_CMD__MMC_GEN_CMD               0x38
#define BV_SSP_CMD0_CMD__SD_GO_IDLE_STATE          0x00
#define BV_SSP_CMD0_CMD__SD_ALL_SEND_CID           0x02
#define BV_SSP_CMD0_CMD__SD_SEND_RELATIVE_ADDR     0x03
#define BV_SSP_CMD0_CMD__SD_SET_DSR                0x04
#define BV_SSP_CMD0_CMD__SD_IO_SEND_OP_COND        0x05
#define BV_SSP_CMD0_CMD__SD_SELECT_DESELECT_CARD   0x07
#define BV_SSP_CMD0_CMD__SD_SEND_CSD               0x09
#define BV_SSP_CMD0_CMD__SD_SEND_CID               0x0A
#define BV_SSP_CMD0_CMD__SD_STOP_TRANSMISSION      0x0C
#define BV_SSP_CMD0_CMD__SD_SEND_STATUS            0x0D
#define BV_SSP_CMD0_CMD__SD_GO_INACTIVE_STATE      0x0F
#define BV_SSP_CMD0_CMD__SD_SET_BLOCKLEN           0x10
#define BV_SSP_CMD0_CMD__SD_READ_SINGLE_BLOCK      0x11
#define BV_SSP_CMD0_CMD__SD_READ_MULTIPLE_BLOCK    0x12
#define BV_SSP_CMD0_CMD__SD_WRITE_BLOCK            0x18
#define BV_SSP_CMD0_CMD__SD_WRITE_MULTIPLE_BLOCK   0x19
#define BV_SSP_CMD0_CMD__SD_PROGRAM_CSD            0x1B
#define BV_SSP_CMD0_CMD__SD_SET_WRITE_PROT         0x1C
#define BV_SSP_CMD0_CMD__SD_CLR_WRITE_PROT         0x1D
#define BV_SSP_CMD0_CMD__SD_SEND_WRITE_PROT        0x1E
#define BV_SSP_CMD0_CMD__SD_ERASE_WR_BLK_START     0x20
#define BV_SSP_CMD0_CMD__SD_ERASE_WR_BLK_END       0x21
#define BV_SSP_CMD0_CMD__SD_ERASE_GROUP_START      0x23
#define BV_SSP_CMD0_CMD__SD_ERASE_GROUP_END        0x24
#define BV_SSP_CMD0_CMD__SD_ERASE                  0x26
#define BV_SSP_CMD0_CMD__SD_LOCK_UNLOCK            0x2A
#define BV_SSP_CMD0_CMD__SD_IO_RW_DIRECT           0x34
#define BV_SSP_CMD0_CMD__SD_IO_RW_EXTENDED         0x35
#define BV_SSP_CMD0_CMD__SD_APP_CMD                0x37
#define BV_SSP_CMD0_CMD__SD_GEN_CMD                0x38



/*
 * HW_SSP_CMD1 - SD/MMC Command Register 1
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned CMD_ARG  : 32;
    } B;
} hw_ssp_cmd1_t;
#endif

/*
 * constants & macros for entire multi-block HW_SSP_CMD1 register
 */
#define HW_SSP_CMD1_ADDR(x)      (REGS_SSP_BASE(x) + 0x20)

#ifndef __LANGUAGE_ASM__
#define HW_SSP_CMD1(x)           (*(volatile hw_ssp_cmd1_t *) HW_SSP_CMD1_ADDR(x))
#define HW_SSP_CMD1_RD(x)      (HW_SSP_CMD1(x).U)
#define HW_SSP_CMD1_WR(x, v)     (HW_SSP_CMD1(x).U = (v))
#define HW_SSP_CMD1_SET(x, v)    (HW_SSP_CMD1_WR(x, HW_SSP_CMD1_RD(x) |  (v)))
#define HW_SSP_CMD1_CLR(x, v)    (HW_SSP_CMD1_WR(x, HW_SSP_CMD1_RD(x) & ~(v)))
#define HW_SSP_CMD1_TOG(x, v)    (HW_SSP_CMD1_WR(x, HW_SSP_CMD1_RD(x) ^  (v)))
#endif


/*
 * constants & macros for individual HW_SSP_CMD1 bitfields
 */
/* --- Register HW_SSP_CMD1, field CMD_ARG */

#define BP_SSP_CMD1_CMD_ARG      0
#define BM_SSP_CMD1_CMD_ARG      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SSP_CMD1_CMD_ARG(v)   ((reg32_t) v)
#else
#define BF_SSP_CMD1_CMD_ARG(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CMD1_CMD_ARG(n, v)   (HW_SSP_CMD1(n).B.CMD_ARG = (v))
#endif



/*
 * HW_SSP_XFER_SIZE - Transfer Count Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned XFER_COUNT  : 32;
    } B;
} hw_ssp_xfer_size_t;
#endif

/*
 * constants & macros for entire multi-block HW_SSP_XFER_SIZE register
 */
#define HW_SSP_XFER_SIZE_ADDR(x)      (REGS_SSP_BASE(x) + 0x30)

#ifndef __LANGUAGE_ASM__
#define HW_SSP_XFER_SIZE(x)           (*(volatile hw_ssp_xfer_size_t *) HW_SSP_XFER_SIZE_ADDR(x))
#define HW_SSP_XFER_SIZE_RD(x)      (HW_SSP_XFER_SIZE(x).U)
#define HW_SSP_XFER_SIZE_WR(x, v)     (HW_SSP_XFER_SIZE(x).U = (v))
#define HW_SSP_XFER_SIZE_SET(x, v)    (HW_SSP_XFER_SIZE_WR(x, HW_SSP_XFER_SIZE_RD(x) |  (v)))
#define HW_SSP_XFER_SIZE_CLR(x, v)    (HW_SSP_XFER_SIZE_WR(x, HW_SSP_XFER_SIZE_RD(x) & ~(v)))
#define HW_SSP_XFER_SIZE_TOG(x, v)    (HW_SSP_XFER_SIZE_WR(x, HW_SSP_XFER_SIZE_RD(x) ^  (v)))
#endif


/*
 * constants & macros for individual HW_SSP_XFER_SIZE bitfields
 */
/* --- Register HW_SSP_XFER_SIZE, field XFER_COUNT */

#define BP_SSP_XFER_SIZE_XFER_COUNT      0
#define BM_SSP_XFER_SIZE_XFER_COUNT      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SSP_XFER_SIZE_XFER_COUNT(v)   ((reg32_t) v)
#else
#define BF_SSP_XFER_SIZE_XFER_COUNT(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_SSP_XFER_SIZE_XFER_COUNT(n, v)   (HW_SSP_XFER_SIZE(n).B.XFER_COUNT = (v))
#endif



/*
 * HW_SSP_BLOCK_SIZE - SD/MMC BLOCK SIZE and COUNT Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BLOCK_SIZE   :  4;
        unsigned BLOCK_COUNT  : 24;
        unsigned RSVD0        :  4;
    } B;
} hw_ssp_block_size_t;
#endif

/*
 * constants & macros for entire multi-block HW_SSP_BLOCK_SIZE register
 */
#define HW_SSP_BLOCK_SIZE_ADDR(x)      (REGS_SSP_BASE(x) + 0x40)

#ifndef __LANGUAGE_ASM__
#define HW_SSP_BLOCK_SIZE(x)           (*(volatile hw_ssp_block_size_t *) HW_SSP_BLOCK_SIZE_ADDR(x))
#define HW_SSP_BLOCK_SIZE_RD(x)      (HW_SSP_BLOCK_SIZE(x).U)
#define HW_SSP_BLOCK_SIZE_WR(x, v)     (HW_SSP_BLOCK_SIZE(x).U = (v))
#define HW_SSP_BLOCK_SIZE_SET(x, v)    (HW_SSP_BLOCK_SIZE_WR(x, HW_SSP_BLOCK_SIZE_RD(x) |  (v)))
#define HW_SSP_BLOCK_SIZE_CLR(x, v)    (HW_SSP_BLOCK_SIZE_WR(x, HW_SSP_BLOCK_SIZE_RD(x) & ~(v)))
#define HW_SSP_BLOCK_SIZE_TOG(x, v)    (HW_SSP_BLOCK_SIZE_WR(x, HW_SSP_BLOCK_SIZE_RD(x) ^  (v)))
#endif


/*
 * constants & macros for individual HW_SSP_BLOCK_SIZE bitfields
 */
/* --- Register HW_SSP_BLOCK_SIZE, field RSVD0 */

#define BP_SSP_BLOCK_SIZE_RSVD0      28
#define BM_SSP_BLOCK_SIZE_RSVD0      0xF0000000

#ifndef __LANGUAGE_ASM__
#define BF_SSP_BLOCK_SIZE_RSVD0(v)   ((((reg32_t) v) << 28) & BM_SSP_BLOCK_SIZE_RSVD0)
#else
#define BF_SSP_BLOCK_SIZE_RSVD0(v)   (((v) << 28) & BM_SSP_BLOCK_SIZE_RSVD0)
#endif
/* --- Register HW_SSP_BLOCK_SIZE, field BLOCK_COUNT */

#define BP_SSP_BLOCK_SIZE_BLOCK_COUNT      4
#define BM_SSP_BLOCK_SIZE_BLOCK_COUNT      0x0FFFFFF0

#define BF_SSP_BLOCK_SIZE_BLOCK_COUNT(v)   (((v) << 4) & BM_SSP_BLOCK_SIZE_BLOCK_COUNT)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_BLOCK_SIZE_BLOCK_COUNT(n, v)   BFn_CS1(SSP_BLOCK_SIZE, n, BLOCK_COUNT, v)
#endif

/* --- Register HW_SSP_BLOCK_SIZE, field BLOCK_SIZE */

#define BP_SSP_BLOCK_SIZE_BLOCK_SIZE      0
#define BM_SSP_BLOCK_SIZE_BLOCK_SIZE      0x0000000F

#define BF_SSP_BLOCK_SIZE_BLOCK_SIZE(v)   (((v) << 0) & BM_SSP_BLOCK_SIZE_BLOCK_SIZE)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_BLOCK_SIZE_BLOCK_SIZE(n, v)   BFn_CS1(SSP_BLOCK_SIZE, n, BLOCK_SIZE, v)
#endif



/*
 * HW_SSP_COMPREF - SD/MMC and MS Compare Reference
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned REFERENCE  : 32;
    } B;
} hw_ssp_compref_t;
#endif

/*
 * constants & macros for entire multi-block HW_SSP_COMPREF register
 */
#define HW_SSP_COMPREF_ADDR(x)      (REGS_SSP_BASE(x) + 0x50)

#ifndef __LANGUAGE_ASM__
#define HW_SSP_COMPREF(x)           (*(volatile hw_ssp_compref_t *) HW_SSP_COMPREF_ADDR(x))
#define HW_SSP_COMPREF_RD(x)      (HW_SSP_COMPREF(x).U)
#define HW_SSP_COMPREF_WR(x, v)     (HW_SSP_COMPREF(x).U = (v))
#define HW_SSP_COMPREF_SET(x, v)    (HW_SSP_COMPREF_WR(x, HW_SSP_COMPREF_RD(x) |  (v)))
#define HW_SSP_COMPREF_CLR(x, v)    (HW_SSP_COMPREF_WR(x, HW_SSP_COMPREF_RD(x) & ~(v)))
#define HW_SSP_COMPREF_TOG(x, v)    (HW_SSP_COMPREF_WR(x, HW_SSP_COMPREF_RD(x) ^  (v)))
#endif


/*
 * constants & macros for individual HW_SSP_COMPREF bitfields
 */
/* --- Register HW_SSP_COMPREF, field REFERENCE */

#define BP_SSP_COMPREF_REFERENCE      0
#define BM_SSP_COMPREF_REFERENCE      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SSP_COMPREF_REFERENCE(v)   ((reg32_t) v)
#else
#define BF_SSP_COMPREF_REFERENCE(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_SSP_COMPREF_REFERENCE(n, v)   (HW_SSP_COMPREF(n).B.REFERENCE = (v))
#endif



/*
 * HW_SSP_COMPMASK - SD/MMC and MS compare mask
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned MASK  : 32;
    } B;
} hw_ssp_compmask_t;
#endif

/*
 * constants & macros for entire multi-block HW_SSP_COMPMASK register
 */
#define HW_SSP_COMPMASK_ADDR(x)      (REGS_SSP_BASE(x) + 0x60)

#ifndef __LANGUAGE_ASM__
#define HW_SSP_COMPMASK(x)           (*(volatile hw_ssp_compmask_t *) HW_SSP_COMPMASK_ADDR(x))
#define HW_SSP_COMPMASK_RD(x)      (HW_SSP_COMPMASK(x).U)
#define HW_SSP_COMPMASK_WR(x, v)     (HW_SSP_COMPMASK(x).U = (v))
#define HW_SSP_COMPMASK_SET(x, v)    (HW_SSP_COMPMASK_WR(x, HW_SSP_COMPMASK_RD(x) |  (v)))
#define HW_SSP_COMPMASK_CLR(x, v)    (HW_SSP_COMPMASK_WR(x, HW_SSP_COMPMASK_RD(x) & ~(v)))
#define HW_SSP_COMPMASK_TOG(x, v)    (HW_SSP_COMPMASK_WR(x, HW_SSP_COMPMASK_RD(x) ^  (v)))
#endif


/*
 * constants & macros for individual HW_SSP_COMPMASK bitfields
 */
/* --- Register HW_SSP_COMPMASK, field MASK */

#define BP_SSP_COMPMASK_MASK      0
#define BM_SSP_COMPMASK_MASK      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SSP_COMPMASK_MASK(v)   ((reg32_t) v)
#else
#define BF_SSP_COMPMASK_MASK(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_SSP_COMPMASK_MASK(n, v)   (HW_SSP_COMPMASK(n).B.MASK = (v))
#endif



/*
 * HW_SSP_TIMING - SSP Timing Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned CLOCK_RATE    :  8;
        unsigned CLOCK_DIVIDE  :  8;
        unsigned TIMEOUT       : 16;
    } B;
} hw_ssp_timing_t;
#endif

/*
 * constants & macros for entire multi-block HW_SSP_TIMING register
 */
#define HW_SSP_TIMING_ADDR(x)      (REGS_SSP_BASE(x) + 0x70)

#ifndef __LANGUAGE_ASM__
#define HW_SSP_TIMING(x)           (*(volatile hw_ssp_timing_t *) HW_SSP_TIMING_ADDR(x))
#define HW_SSP_TIMING_RD(x)      (HW_SSP_TIMING(x).U)
#define HW_SSP_TIMING_WR(x, v)     (HW_SSP_TIMING(x).U = (v))
#define HW_SSP_TIMING_SET(x, v)    (HW_SSP_TIMING_WR(x, HW_SSP_TIMING_RD(x) |  (v)))
#define HW_SSP_TIMING_CLR(x, v)    (HW_SSP_TIMING_WR(x, HW_SSP_TIMING_RD(x) & ~(v)))
#define HW_SSP_TIMING_TOG(x, v)    (HW_SSP_TIMING_WR(x, HW_SSP_TIMING_RD(x) ^  (v)))
#endif


/*
 * constants & macros for individual HW_SSP_TIMING bitfields
 */
/* --- Register HW_SSP_TIMING, field TIMEOUT */

#define BP_SSP_TIMING_TIMEOUT      16
#define BM_SSP_TIMING_TIMEOUT      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_SSP_TIMING_TIMEOUT(v)   ((((reg32_t) v) << 16) & BM_SSP_TIMING_TIMEOUT)
#else
#define BF_SSP_TIMING_TIMEOUT(v)   (((v) << 16) & BM_SSP_TIMING_TIMEOUT)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_SSP_TIMING_TIMEOUT(n, v)   (HW_SSP_TIMING(n).B.TIMEOUT = (v))
#endif

/* --- Register HW_SSP_TIMING, field CLOCK_DIVIDE */

#define BP_SSP_TIMING_CLOCK_DIVIDE      8
#define BM_SSP_TIMING_CLOCK_DIVIDE      0x0000FF00

#define BF_SSP_TIMING_CLOCK_DIVIDE(v)   (((v) << 8) & BM_SSP_TIMING_CLOCK_DIVIDE)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_TIMING_CLOCK_DIVIDE(n, v)   (HW_SSP_TIMING(n).B.CLOCK_DIVIDE = (v))
#endif

/* --- Register HW_SSP_TIMING, field CLOCK_RATE */

#define BP_SSP_TIMING_CLOCK_RATE      0
#define BM_SSP_TIMING_CLOCK_RATE      0x000000FF

#define BF_SSP_TIMING_CLOCK_RATE(v)   (((v) << 0) & BM_SSP_TIMING_CLOCK_RATE)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_TIMING_CLOCK_RATE(n, v)   (HW_SSP_TIMING(n).B.CLOCK_RATE = (v))
#endif



/*
 * HW_SSP_CTRL1 - SSP Control Register 1
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned SSP_MODE              :  4;
        unsigned WORD_LENGTH           :  4;
        unsigned SLAVE_MODE            :  1;
        unsigned POLARITY              :  1;
        unsigned PHASE                 :  1;
        unsigned SLAVE_OUT_DISABLE     :  1;
        unsigned CEATA_CCS_ERR_EN      :  1;
        unsigned DMA_ENABLE            :  1;
        unsigned FIFO_OVERRUN_IRQ_EN   :  1;
        unsigned FIFO_OVERRUN_IRQ      :  1;
        unsigned RECV_TIMEOUT_IRQ_EN   :  1;
        unsigned RECV_TIMEOUT_IRQ      :  1;
        unsigned CEATA_CCS_ERR_IRQ_EN  :  1;
        unsigned CEATA_CCS_ERR_IRQ     :  1;
        unsigned FIFO_UNDERRUN_EN      :  1;
        unsigned FIFO_UNDERRUN_IRQ     :  1;
        unsigned DATA_CRC_IRQ_EN       :  1;
        unsigned DATA_CRC_IRQ          :  1;
        unsigned DATA_TIMEOUT_IRQ_EN   :  1;
        unsigned DATA_TIMEOUT_IRQ      :  1;
        unsigned RESP_TIMEOUT_IRQ_EN   :  1;
        unsigned RESP_TIMEOUT_IRQ      :  1;
        unsigned RESP_ERR_IRQ_EN       :  1;
        unsigned RESP_ERR_IRQ          :  1;
        unsigned SDIO_IRQ_EN           :  1;
        unsigned SDIO_IRQ              :  1;
    } B;
} hw_ssp_ctrl1_t;
#endif

/*
 * constants & macros for entire multi-block HW_SSP_CTRL1 register
 */
#define HW_SSP_CTRL1_ADDR(x)      (REGS_SSP_BASE(x) + 0x80)
#define HW_SSP_CTRL1_SET_ADDR(x)  (HW_SSP_CTRL1_ADDR(x) + 4)
#define HW_SSP_CTRL1_CLR_ADDR(x)  (HW_SSP_CTRL1_ADDR(x) + 8)
#define HW_SSP_CTRL1_TOG_ADDR(x)  (HW_SSP_CTRL1_ADDR(x) + 12)

#ifndef __LANGUAGE_ASM__
#define HW_SSP_CTRL1(x)           (*(volatile hw_ssp_ctrl1_t *) HW_SSP_CTRL1_ADDR(x))
#define HW_SSP_CTRL1_RD(x)      (HW_SSP_CTRL1(x).U)
#define HW_SSP_CTRL1_WR(x, v)     (HW_SSP_CTRL1(x).U = (v))
#define HW_SSP_CTRL1_SET(x, v)    ((*(volatile reg32_t *) HW_SSP_CTRL1_SET_ADDR(x)) = (v))
#define HW_SSP_CTRL1_CLR(x, v)    ((*(volatile reg32_t *) HW_SSP_CTRL1_CLR_ADDR(x)) = (v))
#define HW_SSP_CTRL1_TOG(x, v)    ((*(volatile reg32_t *) HW_SSP_CTRL1_TOG_ADDR(x)) = (v))
#endif


/*
 * constants & macros for individual HW_SSP_CTRL1 bitfields
 */
/* --- Register HW_SSP_CTRL1, field SDIO_IRQ */

#define BP_SSP_CTRL1_SDIO_IRQ      31
#define BM_SSP_CTRL1_SDIO_IRQ      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_SSP_CTRL1_SDIO_IRQ(v)   ((((reg32_t) v) << 31) & BM_SSP_CTRL1_SDIO_IRQ)
#else
#define BF_SSP_CTRL1_SDIO_IRQ(v)   (((v) << 31) & BM_SSP_CTRL1_SDIO_IRQ)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_SDIO_IRQ(n, v)   BFn_CS1(SSP_CTRL1, n, SDIO_IRQ, v)
#endif

/* --- Register HW_SSP_CTRL1, field SDIO_IRQ_EN */

#define BP_SSP_CTRL1_SDIO_IRQ_EN      30
#define BM_SSP_CTRL1_SDIO_IRQ_EN      0x40000000

#define BF_SSP_CTRL1_SDIO_IRQ_EN(v)   (((v) << 30) & BM_SSP_CTRL1_SDIO_IRQ_EN)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_SDIO_IRQ_EN(n, v)   BFn_CS1(SSP_CTRL1, n, SDIO_IRQ_EN, v)
#endif

/* --- Register HW_SSP_CTRL1, field RESP_ERR_IRQ */

#define BP_SSP_CTRL1_RESP_ERR_IRQ      29
#define BM_SSP_CTRL1_RESP_ERR_IRQ      0x20000000

#define BF_SSP_CTRL1_RESP_ERR_IRQ(v)   (((v) << 29) & BM_SSP_CTRL1_RESP_ERR_IRQ)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_RESP_ERR_IRQ(n, v)   BFn_CS1(SSP_CTRL1, n, RESP_ERR_IRQ, v)
#endif

/* --- Register HW_SSP_CTRL1, field RESP_ERR_IRQ_EN */

#define BP_SSP_CTRL1_RESP_ERR_IRQ_EN      28
#define BM_SSP_CTRL1_RESP_ERR_IRQ_EN      0x10000000

#define BF_SSP_CTRL1_RESP_ERR_IRQ_EN(v)   (((v) << 28) & BM_SSP_CTRL1_RESP_ERR_IRQ_EN)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_RESP_ERR_IRQ_EN(n, v)   BFn_CS1(SSP_CTRL1, n, RESP_ERR_IRQ_EN, v)
#endif

/* --- Register HW_SSP_CTRL1, field RESP_TIMEOUT_IRQ */

#define BP_SSP_CTRL1_RESP_TIMEOUT_IRQ      27
#define BM_SSP_CTRL1_RESP_TIMEOUT_IRQ      0x08000000

#define BF_SSP_CTRL1_RESP_TIMEOUT_IRQ(v)   (((v) << 27) & BM_SSP_CTRL1_RESP_TIMEOUT_IRQ)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_RESP_TIMEOUT_IRQ(n, v)   BFn_CS1(SSP_CTRL1, n, RESP_TIMEOUT_IRQ, v)
#endif

/* --- Register HW_SSP_CTRL1, field RESP_TIMEOUT_IRQ_EN */

#define BP_SSP_CTRL1_RESP_TIMEOUT_IRQ_EN      26
#define BM_SSP_CTRL1_RESP_TIMEOUT_IRQ_EN      0x04000000

#define BF_SSP_CTRL1_RESP_TIMEOUT_IRQ_EN(v)   (((v) << 26) & BM_SSP_CTRL1_RESP_TIMEOUT_IRQ_EN)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_RESP_TIMEOUT_IRQ_EN(n, v)   BFn_CS1(SSP_CTRL1, n, RESP_TIMEOUT_IRQ_EN, v)
#endif

/* --- Register HW_SSP_CTRL1, field DATA_TIMEOUT_IRQ */

#define BP_SSP_CTRL1_DATA_TIMEOUT_IRQ      25
#define BM_SSP_CTRL1_DATA_TIMEOUT_IRQ      0x02000000

#define BF_SSP_CTRL1_DATA_TIMEOUT_IRQ(v)   (((v) << 25) & BM_SSP_CTRL1_DATA_TIMEOUT_IRQ)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_DATA_TIMEOUT_IRQ(n, v)   BFn_CS1(SSP_CTRL1, n, DATA_TIMEOUT_IRQ, v)
#endif

/* --- Register HW_SSP_CTRL1, field DATA_TIMEOUT_IRQ_EN */

#define BP_SSP_CTRL1_DATA_TIMEOUT_IRQ_EN      24
#define BM_SSP_CTRL1_DATA_TIMEOUT_IRQ_EN      0x01000000

#define BF_SSP_CTRL1_DATA_TIMEOUT_IRQ_EN(v)   (((v) << 24) & BM_SSP_CTRL1_DATA_TIMEOUT_IRQ_EN)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_DATA_TIMEOUT_IRQ_EN(n, v)   BFn_CS1(SSP_CTRL1, n, DATA_TIMEOUT_IRQ_EN, v)
#endif

/* --- Register HW_SSP_CTRL1, field DATA_CRC_IRQ */

#define BP_SSP_CTRL1_DATA_CRC_IRQ      23
#define BM_SSP_CTRL1_DATA_CRC_IRQ      0x00800000

#define BF_SSP_CTRL1_DATA_CRC_IRQ(v)   (((v) << 23) & BM_SSP_CTRL1_DATA_CRC_IRQ)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_DATA_CRC_IRQ(n, v)   BFn_CS1(SSP_CTRL1, n, DATA_CRC_IRQ, v)
#endif

/* --- Register HW_SSP_CTRL1, field DATA_CRC_IRQ_EN */

#define BP_SSP_CTRL1_DATA_CRC_IRQ_EN      22
#define BM_SSP_CTRL1_DATA_CRC_IRQ_EN      0x00400000

#define BF_SSP_CTRL1_DATA_CRC_IRQ_EN(v)   (((v) << 22) & BM_SSP_CTRL1_DATA_CRC_IRQ_EN)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_DATA_CRC_IRQ_EN(n, v)   BFn_CS1(SSP_CTRL1, n, DATA_CRC_IRQ_EN, v)
#endif

/* --- Register HW_SSP_CTRL1, field FIFO_UNDERRUN_IRQ */

#define BP_SSP_CTRL1_FIFO_UNDERRUN_IRQ      21
#define BM_SSP_CTRL1_FIFO_UNDERRUN_IRQ      0x00200000

#define BF_SSP_CTRL1_FIFO_UNDERRUN_IRQ(v)   (((v) << 21) & BM_SSP_CTRL1_FIFO_UNDERRUN_IRQ)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_FIFO_UNDERRUN_IRQ(n, v)   BFn_CS1(SSP_CTRL1, n, FIFO_UNDERRUN_IRQ, v)
#endif

/* --- Register HW_SSP_CTRL1, field FIFO_UNDERRUN_EN */

#define BP_SSP_CTRL1_FIFO_UNDERRUN_EN      20
#define BM_SSP_CTRL1_FIFO_UNDERRUN_EN      0x00100000

#define BF_SSP_CTRL1_FIFO_UNDERRUN_EN(v)   (((v) << 20) & BM_SSP_CTRL1_FIFO_UNDERRUN_EN)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_FIFO_UNDERRUN_EN(n, v)   BFn_CS1(SSP_CTRL1, n, FIFO_UNDERRUN_EN, v)
#endif

/* --- Register HW_SSP_CTRL1, field CEATA_CCS_ERR_IRQ */

#define BP_SSP_CTRL1_CEATA_CCS_ERR_IRQ      19
#define BM_SSP_CTRL1_CEATA_CCS_ERR_IRQ      0x00080000

#define BF_SSP_CTRL1_CEATA_CCS_ERR_IRQ(v)   (((v) << 19) & BM_SSP_CTRL1_CEATA_CCS_ERR_IRQ)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_CEATA_CCS_ERR_IRQ(n, v)   BFn_CS1(SSP_CTRL1, n, CEATA_CCS_ERR_IRQ, v)
#endif

/* --- Register HW_SSP_CTRL1, field CEATA_CCS_ERR_IRQ_EN */

#define BP_SSP_CTRL1_CEATA_CCS_ERR_IRQ_EN      18
#define BM_SSP_CTRL1_CEATA_CCS_ERR_IRQ_EN      0x00040000

#define BF_SSP_CTRL1_CEATA_CCS_ERR_IRQ_EN(v)   (((v) << 18) & BM_SSP_CTRL1_CEATA_CCS_ERR_IRQ_EN)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_CEATA_CCS_ERR_IRQ_EN(n, v)   BFn_CS1(SSP_CTRL1, n, CEATA_CCS_ERR_IRQ_EN, v)
#endif

/* --- Register HW_SSP_CTRL1, field RECV_TIMEOUT_IRQ */

#define BP_SSP_CTRL1_RECV_TIMEOUT_IRQ      17
#define BM_SSP_CTRL1_RECV_TIMEOUT_IRQ      0x00020000

#define BF_SSP_CTRL1_RECV_TIMEOUT_IRQ(v)   (((v) << 17) & BM_SSP_CTRL1_RECV_TIMEOUT_IRQ)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_RECV_TIMEOUT_IRQ(n, v)   BFn_CS1(SSP_CTRL1, n, RECV_TIMEOUT_IRQ, v)
#endif

/* --- Register HW_SSP_CTRL1, field RECV_TIMEOUT_IRQ_EN */

#define BP_SSP_CTRL1_RECV_TIMEOUT_IRQ_EN      16
#define BM_SSP_CTRL1_RECV_TIMEOUT_IRQ_EN      0x00010000

#define BF_SSP_CTRL1_RECV_TIMEOUT_IRQ_EN(v)   (((v) << 16) & BM_SSP_CTRL1_RECV_TIMEOUT_IRQ_EN)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_RECV_TIMEOUT_IRQ_EN(n, v)   BFn_CS1(SSP_CTRL1, n, RECV_TIMEOUT_IRQ_EN, v)
#endif

/* --- Register HW_SSP_CTRL1, field FIFO_OVERRUN_IRQ */

#define BP_SSP_CTRL1_FIFO_OVERRUN_IRQ      15
#define BM_SSP_CTRL1_FIFO_OVERRUN_IRQ      0x00008000

#define BF_SSP_CTRL1_FIFO_OVERRUN_IRQ(v)   (((v) << 15) & BM_SSP_CTRL1_FIFO_OVERRUN_IRQ)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_FIFO_OVERRUN_IRQ(n, v)   BFn_CS1(SSP_CTRL1, n, FIFO_OVERRUN_IRQ, v)
#endif

/* --- Register HW_SSP_CTRL1, field FIFO_OVERRUN_IRQ_EN */

#define BP_SSP_CTRL1_FIFO_OVERRUN_IRQ_EN      14
#define BM_SSP_CTRL1_FIFO_OVERRUN_IRQ_EN      0x00004000

#define BF_SSP_CTRL1_FIFO_OVERRUN_IRQ_EN(v)   (((v) << 14) & BM_SSP_CTRL1_FIFO_OVERRUN_IRQ_EN)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_FIFO_OVERRUN_IRQ_EN(n, v)   BFn_CS1(SSP_CTRL1, n, FIFO_OVERRUN_IRQ_EN, v)
#endif

/* --- Register HW_SSP_CTRL1, field DMA_ENABLE */

#define BP_SSP_CTRL1_DMA_ENABLE      13
#define BM_SSP_CTRL1_DMA_ENABLE      0x00002000

#define BF_SSP_CTRL1_DMA_ENABLE(v)   (((v) << 13) & BM_SSP_CTRL1_DMA_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_DMA_ENABLE(n, v)   BFn_CS1(SSP_CTRL1, n, DMA_ENABLE, v)
#endif

/* --- Register HW_SSP_CTRL1, field CEATA_CCS_ERR_EN */

#define BP_SSP_CTRL1_CEATA_CCS_ERR_EN      12
#define BM_SSP_CTRL1_CEATA_CCS_ERR_EN      0x00001000

#define BF_SSP_CTRL1_CEATA_CCS_ERR_EN(v)   (((v) << 12) & BM_SSP_CTRL1_CEATA_CCS_ERR_EN)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_CEATA_CCS_ERR_EN(n, v)   BFn_CS1(SSP_CTRL1, n, CEATA_CCS_ERR_EN, v)
#endif

/* --- Register HW_SSP_CTRL1, field SLAVE_OUT_DISABLE */

#define BP_SSP_CTRL1_SLAVE_OUT_DISABLE      11
#define BM_SSP_CTRL1_SLAVE_OUT_DISABLE      0x00000800

#define BF_SSP_CTRL1_SLAVE_OUT_DISABLE(v)   (((v) << 11) & BM_SSP_CTRL1_SLAVE_OUT_DISABLE)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_SLAVE_OUT_DISABLE(n, v)   BFn_CS1(SSP_CTRL1, n, SLAVE_OUT_DISABLE, v)
#endif

/* --- Register HW_SSP_CTRL1, field PHASE */

#define BP_SSP_CTRL1_PHASE      10
#define BM_SSP_CTRL1_PHASE      0x00000400

#define BF_SSP_CTRL1_PHASE(v)   (((v) << 10) & BM_SSP_CTRL1_PHASE)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_PHASE(n, v)   BFn_CS1(SSP_CTRL1, n, PHASE, v)
#endif

/* --- Register HW_SSP_CTRL1, field POLARITY */

#define BP_SSP_CTRL1_POLARITY      9
#define BM_SSP_CTRL1_POLARITY      0x00000200

#define BF_SSP_CTRL1_POLARITY(v)   (((v) << 9) & BM_SSP_CTRL1_POLARITY)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_POLARITY(n, v)   BFn_CS1(SSP_CTRL1, n, POLARITY, v)
#endif

/* --- Register HW_SSP_CTRL1, field SLAVE_MODE */

#define BP_SSP_CTRL1_SLAVE_MODE      8
#define BM_SSP_CTRL1_SLAVE_MODE      0x00000100

#define BF_SSP_CTRL1_SLAVE_MODE(v)   (((v) << 8) & BM_SSP_CTRL1_SLAVE_MODE)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_SLAVE_MODE(n, v)   BFn_CS1(SSP_CTRL1, n, SLAVE_MODE, v)
#endif

/* --- Register HW_SSP_CTRL1, field WORD_LENGTH */

#define BP_SSP_CTRL1_WORD_LENGTH      4
#define BM_SSP_CTRL1_WORD_LENGTH      0x000000F0

#define BF_SSP_CTRL1_WORD_LENGTH(v)   (((v) << 4) & BM_SSP_CTRL1_WORD_LENGTH)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_WORD_LENGTH(n, v)   BFn_CS1(SSP_CTRL1, n, WORD_LENGTH, v)
#endif

#define BV_SSP_CTRL1_WORD_LENGTH__RESERVED0     0x0
#define BV_SSP_CTRL1_WORD_LENGTH__RESERVED1     0x1
#define BV_SSP_CTRL1_WORD_LENGTH__RESERVED2     0x2
#define BV_SSP_CTRL1_WORD_LENGTH__FOUR_BITS     0x3
#define BV_SSP_CTRL1_WORD_LENGTH__EIGHT_BITS    0x7
#define BV_SSP_CTRL1_WORD_LENGTH__SIXTEEN_BITS  0xF

/* --- Register HW_SSP_CTRL1, field SSP_MODE */

#define BP_SSP_CTRL1_SSP_MODE      0
#define BM_SSP_CTRL1_SSP_MODE      0x0000000F

#define BF_SSP_CTRL1_SSP_MODE(v)   (((v) << 0) & BM_SSP_CTRL1_SSP_MODE)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_SSP_MODE(n, v)   BFn_CS1(SSP_CTRL1, n, SSP_MODE, v)
#endif

#define BV_SSP_CTRL1_SSP_MODE__SPI     0x0
#define BV_SSP_CTRL1_SSP_MODE__SSI     0x1
#define BV_SSP_CTRL1_SSP_MODE__SD_MMC  0x3
#define BV_SSP_CTRL1_SSP_MODE__MS      0x4



/*
 * HW_SSP_DATA - SSP Data Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DATA  : 32;
    } B;
} hw_ssp_data_t;
#endif

/*
 * constants & macros for entire multi-block HW_SSP_DATA register
 */
#define HW_SSP_DATA_ADDR(x)      (REGS_SSP_BASE(x) + 0x90)

#ifndef __LANGUAGE_ASM__
#define HW_SSP_DATA(x)           (*(volatile hw_ssp_data_t *) HW_SSP_DATA_ADDR(x))
#define HW_SSP_DATA_RD(x)      (HW_SSP_DATA(x).U)
#define HW_SSP_DATA_WR(x, v)     (HW_SSP_DATA(x).U = (v))
#define HW_SSP_DATA_SET(x, v)    (HW_SSP_DATA_WR(x, HW_SSP_DATA_RD(x) |  (v)))
#define HW_SSP_DATA_CLR(x, v)    (HW_SSP_DATA_WR(x, HW_SSP_DATA_RD(x) & ~(v)))
#define HW_SSP_DATA_TOG(x, v)    (HW_SSP_DATA_WR(x, HW_SSP_DATA_RD(x) ^  (v)))
#endif


/*
 * constants & macros for individual HW_SSP_DATA bitfields
 */
/* --- Register HW_SSP_DATA, field DATA */

#define BP_SSP_DATA_DATA      0
#define BM_SSP_DATA_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SSP_DATA_DATA(v)   ((reg32_t) v)
#else
#define BF_SSP_DATA_DATA(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_SSP_DATA_DATA(n, v)   (HW_SSP_DATA(n).B.DATA = (v))
#endif



/*
 * HW_SSP_SDRESP0 - SD/MMC Card Response Register 0
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RESP0  : 32;
    } B;
} hw_ssp_sdresp0_t;
#endif

/*
 * constants & macros for entire multi-block HW_SSP_SDRESP0 register
 */
#define HW_SSP_SDRESP0_ADDR(x)      (REGS_SSP_BASE(x) + 0xa0)

#ifndef __LANGUAGE_ASM__
#define HW_SSP_SDRESP0(x)           (*(volatile hw_ssp_sdresp0_t *) HW_SSP_SDRESP0_ADDR(x))
#define HW_SSP_SDRESP0_RD(x)      (HW_SSP_SDRESP0(x).U)
#endif


/*
 * constants & macros for individual HW_SSP_SDRESP0 bitfields
 */
/* --- Register HW_SSP_SDRESP0, field RESP0 */

#define BP_SSP_SDRESP0_RESP0      0
#define BM_SSP_SDRESP0_RESP0      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SSP_SDRESP0_RESP0(v)   ((reg32_t) v)
#else
#define BF_SSP_SDRESP0_RESP0(v)   (v)
#endif


/*
 * HW_SSP_SDRESP1 - SD/MMC Card Response Register 1
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RESP1  : 32;
    } B;
} hw_ssp_sdresp1_t;
#endif

/*
 * constants & macros for entire multi-block HW_SSP_SDRESP1 register
 */
#define HW_SSP_SDRESP1_ADDR(x)      (REGS_SSP_BASE(x) + 0xb0)

#ifndef __LANGUAGE_ASM__
#define HW_SSP_SDRESP1(x)           (*(volatile hw_ssp_sdresp1_t *) HW_SSP_SDRESP1_ADDR(x))
#define HW_SSP_SDRESP1_RD(x)      (HW_SSP_SDRESP1(x).U)
#endif


/*
 * constants & macros for individual HW_SSP_SDRESP1 bitfields
 */
/* --- Register HW_SSP_SDRESP1, field RESP1 */

#define BP_SSP_SDRESP1_RESP1      0
#define BM_SSP_SDRESP1_RESP1      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SSP_SDRESP1_RESP1(v)   ((reg32_t) v)
#else
#define BF_SSP_SDRESP1_RESP1(v)   (v)
#endif


/*
 * HW_SSP_SDRESP2 - SD/MMC Card Response Register 2
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RESP2  : 32;
    } B;
} hw_ssp_sdresp2_t;
#endif

/*
 * constants & macros for entire multi-block HW_SSP_SDRESP2 register
 */
#define HW_SSP_SDRESP2_ADDR(x)      (REGS_SSP_BASE(x) + 0xc0)

#ifndef __LANGUAGE_ASM__
#define HW_SSP_SDRESP2(x)           (*(volatile hw_ssp_sdresp2_t *) HW_SSP_SDRESP2_ADDR(x))
#define HW_SSP_SDRESP2_RD(x)      (HW_SSP_SDRESP2(x).U)
#endif


/*
 * constants & macros for individual HW_SSP_SDRESP2 bitfields
 */
/* --- Register HW_SSP_SDRESP2, field RESP2 */

#define BP_SSP_SDRESP2_RESP2      0
#define BM_SSP_SDRESP2_RESP2      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SSP_SDRESP2_RESP2(v)   ((reg32_t) v)
#else
#define BF_SSP_SDRESP2_RESP2(v)   (v)
#endif


/*
 * HW_SSP_SDRESP3 - SD/MMC Card Response Register 3
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RESP3  : 32;
    } B;
} hw_ssp_sdresp3_t;
#endif

/*
 * constants & macros for entire multi-block HW_SSP_SDRESP3 register
 */
#define HW_SSP_SDRESP3_ADDR(x)      (REGS_SSP_BASE(x) + 0xd0)

#ifndef __LANGUAGE_ASM__
#define HW_SSP_SDRESP3(x)           (*(volatile hw_ssp_sdresp3_t *) HW_SSP_SDRESP3_ADDR(x))
#define HW_SSP_SDRESP3_RD(x)      (HW_SSP_SDRESP3(x).U)
#endif


/*
 * constants & macros for individual HW_SSP_SDRESP3 bitfields
 */
/* --- Register HW_SSP_SDRESP3, field RESP3 */

#define BP_SSP_SDRESP3_RESP3      0
#define BM_SSP_SDRESP3_RESP3      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SSP_SDRESP3_RESP3(v)   ((reg32_t) v)
#else
#define BF_SSP_SDRESP3_RESP3(v)   (v)
#endif


/*
 * HW_SSP_DDR_CTRL - SD/MMC Double Data Rate Control Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TXCLK_DELAY_TYPE  :  1;
        unsigned NIBBLE_POS        :  1;
        unsigned RSVD0             : 28;
        unsigned DMA_BURST_TYPE    :  2;
    } B;
} hw_ssp_ddr_ctrl_t;
#endif

/*
 * constants & macros for entire multi-block HW_SSP_DDR_CTRL register
 */
#define HW_SSP_DDR_CTRL_ADDR(x)      (REGS_SSP_BASE(x) + 0xe0)

#ifndef __LANGUAGE_ASM__
#define HW_SSP_DDR_CTRL(x)           (*(volatile hw_ssp_ddr_ctrl_t *) HW_SSP_DDR_CTRL_ADDR(x))
#define HW_SSP_DDR_CTRL_RD(x)      (HW_SSP_DDR_CTRL(x).U)
#define HW_SSP_DDR_CTRL_WR(x, v)     (HW_SSP_DDR_CTRL(x).U = (v))
#define HW_SSP_DDR_CTRL_SET(x, v)    (HW_SSP_DDR_CTRL_WR(x, HW_SSP_DDR_CTRL_RD(x) |  (v)))
#define HW_SSP_DDR_CTRL_CLR(x, v)    (HW_SSP_DDR_CTRL_WR(x, HW_SSP_DDR_CTRL_RD(x) & ~(v)))
#define HW_SSP_DDR_CTRL_TOG(x, v)    (HW_SSP_DDR_CTRL_WR(x, HW_SSP_DDR_CTRL_RD(x) ^  (v)))
#endif


/*
 * constants & macros for individual HW_SSP_DDR_CTRL bitfields
 */
/* --- Register HW_SSP_DDR_CTRL, field DMA_BURST_TYPE */

#define BP_SSP_DDR_CTRL_DMA_BURST_TYPE      30
#define BM_SSP_DDR_CTRL_DMA_BURST_TYPE      0xC0000000

#ifndef __LANGUAGE_ASM__
#define BF_SSP_DDR_CTRL_DMA_BURST_TYPE(v)   ((((reg32_t) v) << 30) & BM_SSP_DDR_CTRL_DMA_BURST_TYPE)
#else
#define BF_SSP_DDR_CTRL_DMA_BURST_TYPE(v)   (((v) << 30) & BM_SSP_DDR_CTRL_DMA_BURST_TYPE)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_SSP_DDR_CTRL_DMA_BURST_TYPE(n, v)   BFn_CS1(SSP_DDR_CTRL, n, DMA_BURST_TYPE, v)
#endif

/* --- Register HW_SSP_DDR_CTRL, field RSVD0 */

#define BP_SSP_DDR_CTRL_RSVD0      2
#define BM_SSP_DDR_CTRL_RSVD0      0x3FFFFFFC

#define BF_SSP_DDR_CTRL_RSVD0(v)   (((v) << 2) & BM_SSP_DDR_CTRL_RSVD0)
/* --- Register HW_SSP_DDR_CTRL, field NIBBLE_POS */

#define BP_SSP_DDR_CTRL_NIBBLE_POS      1
#define BM_SSP_DDR_CTRL_NIBBLE_POS      0x00000002

#define BF_SSP_DDR_CTRL_NIBBLE_POS(v)   (((v) << 1) & BM_SSP_DDR_CTRL_NIBBLE_POS)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_DDR_CTRL_NIBBLE_POS(n, v)   BFn_CS1(SSP_DDR_CTRL, n, NIBBLE_POS, v)
#endif

/* --- Register HW_SSP_DDR_CTRL, field TXCLK_DELAY_TYPE */

#define BP_SSP_DDR_CTRL_TXCLK_DELAY_TYPE      0
#define BM_SSP_DDR_CTRL_TXCLK_DELAY_TYPE      0x00000001

#define BF_SSP_DDR_CTRL_TXCLK_DELAY_TYPE(v)   (((v) << 0) & BM_SSP_DDR_CTRL_TXCLK_DELAY_TYPE)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_DDR_CTRL_TXCLK_DELAY_TYPE(n, v)   BFn_CS1(SSP_DDR_CTRL, n, TXCLK_DELAY_TYPE, v)
#endif



/*
 * HW_SSP_DLL_CTRL - SD/MMC DLL Control Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ENABLE            :  1;
        unsigned RESET             :  1;
        unsigned SLV_FORCE_UPD     :  1;
        unsigned SLV_DLY_TARGET    :  4;
        unsigned GATE_UPDATE       :  1;
        unsigned RSVD0             :  1;
        unsigned SLV_OVERRIDE      :  1;
        unsigned SLV_OVERRIDE_VAL  :  6;
        unsigned RSVD1             :  4;
        unsigned SLV_UPDATE_INT    :  8;
        unsigned REF_UPDATE_INT    :  4;
    } B;
} hw_ssp_dll_ctrl_t;
#endif

/*
 * constants & macros for entire multi-block HW_SSP_DLL_CTRL register
 */
#define HW_SSP_DLL_CTRL_ADDR(x)      (REGS_SSP_BASE(x) + 0xf0)

#ifndef __LANGUAGE_ASM__
#define HW_SSP_DLL_CTRL(x)           (*(volatile hw_ssp_dll_ctrl_t *) HW_SSP_DLL_CTRL_ADDR(x))
#define HW_SSP_DLL_CTRL_RD(x)      (HW_SSP_DLL_CTRL(x).U)
#define HW_SSP_DLL_CTRL_WR(x, v)     (HW_SSP_DLL_CTRL(x).U = (v))
#define HW_SSP_DLL_CTRL_SET(x, v)    (HW_SSP_DLL_CTRL_WR(x, HW_SSP_DLL_CTRL_RD(x) |  (v)))
#define HW_SSP_DLL_CTRL_CLR(x, v)    (HW_SSP_DLL_CTRL_WR(x, HW_SSP_DLL_CTRL_RD(x) & ~(v)))
#define HW_SSP_DLL_CTRL_TOG(x, v)    (HW_SSP_DLL_CTRL_WR(x, HW_SSP_DLL_CTRL_RD(x) ^  (v)))
#endif


/*
 * constants & macros for individual HW_SSP_DLL_CTRL bitfields
 */
/* --- Register HW_SSP_DLL_CTRL, field REF_UPDATE_INT */

#define BP_SSP_DLL_CTRL_REF_UPDATE_INT      28
#define BM_SSP_DLL_CTRL_REF_UPDATE_INT      0xF0000000

#ifndef __LANGUAGE_ASM__
#define BF_SSP_DLL_CTRL_REF_UPDATE_INT(v)   ((((reg32_t) v) << 28) & BM_SSP_DLL_CTRL_REF_UPDATE_INT)
#else
#define BF_SSP_DLL_CTRL_REF_UPDATE_INT(v)   (((v) << 28) & BM_SSP_DLL_CTRL_REF_UPDATE_INT)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_SSP_DLL_CTRL_REF_UPDATE_INT(n, v)   BFn_CS1(SSP_DLL_CTRL, n, REF_UPDATE_INT, v)
#endif

/* --- Register HW_SSP_DLL_CTRL, field SLV_UPDATE_INT */

#define BP_SSP_DLL_CTRL_SLV_UPDATE_INT      20
#define BM_SSP_DLL_CTRL_SLV_UPDATE_INT      0x0FF00000

#define BF_SSP_DLL_CTRL_SLV_UPDATE_INT(v)   (((v) << 20) & BM_SSP_DLL_CTRL_SLV_UPDATE_INT)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_DLL_CTRL_SLV_UPDATE_INT(n, v)   BFn_CS1(SSP_DLL_CTRL, n, SLV_UPDATE_INT, v)
#endif

/* --- Register HW_SSP_DLL_CTRL, field RSVD1 */

#define BP_SSP_DLL_CTRL_RSVD1      16
#define BM_SSP_DLL_CTRL_RSVD1      0x000F0000

#define BF_SSP_DLL_CTRL_RSVD1(v)   (((v) << 16) & BM_SSP_DLL_CTRL_RSVD1)
/* --- Register HW_SSP_DLL_CTRL, field SLV_OVERRIDE_VAL */

#define BP_SSP_DLL_CTRL_SLV_OVERRIDE_VAL      10
#define BM_SSP_DLL_CTRL_SLV_OVERRIDE_VAL      0x0000FC00

#define BF_SSP_DLL_CTRL_SLV_OVERRIDE_VAL(v)   (((v) << 10) & BM_SSP_DLL_CTRL_SLV_OVERRIDE_VAL)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_DLL_CTRL_SLV_OVERRIDE_VAL(n, v)   BFn_CS1(SSP_DLL_CTRL, n, SLV_OVERRIDE_VAL, v)
#endif

/* --- Register HW_SSP_DLL_CTRL, field SLV_OVERRIDE */

#define BP_SSP_DLL_CTRL_SLV_OVERRIDE      9
#define BM_SSP_DLL_CTRL_SLV_OVERRIDE      0x00000200

#define BF_SSP_DLL_CTRL_SLV_OVERRIDE(v)   (((v) << 9) & BM_SSP_DLL_CTRL_SLV_OVERRIDE)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_DLL_CTRL_SLV_OVERRIDE(n, v)   BFn_CS1(SSP_DLL_CTRL, n, SLV_OVERRIDE, v)
#endif

/* --- Register HW_SSP_DLL_CTRL, field RSVD0 */

#define BP_SSP_DLL_CTRL_RSVD0      8
#define BM_SSP_DLL_CTRL_RSVD0      0x00000100

#define BF_SSP_DLL_CTRL_RSVD0(v)   (((v) << 8) & BM_SSP_DLL_CTRL_RSVD0)
/* --- Register HW_SSP_DLL_CTRL, field GATE_UPDATE */

#define BP_SSP_DLL_CTRL_GATE_UPDATE      7
#define BM_SSP_DLL_CTRL_GATE_UPDATE      0x00000080

#define BF_SSP_DLL_CTRL_GATE_UPDATE(v)   (((v) << 7) & BM_SSP_DLL_CTRL_GATE_UPDATE)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_DLL_CTRL_GATE_UPDATE(n, v)   BFn_CS1(SSP_DLL_CTRL, n, GATE_UPDATE, v)
#endif

/* --- Register HW_SSP_DLL_CTRL, field SLV_DLY_TARGET */

#define BP_SSP_DLL_CTRL_SLV_DLY_TARGET      3
#define BM_SSP_DLL_CTRL_SLV_DLY_TARGET      0x00000078

#define BF_SSP_DLL_CTRL_SLV_DLY_TARGET(v)   (((v) << 3) & BM_SSP_DLL_CTRL_SLV_DLY_TARGET)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_DLL_CTRL_SLV_DLY_TARGET(n, v)   BFn_CS1(SSP_DLL_CTRL, n, SLV_DLY_TARGET, v)
#endif

/* --- Register HW_SSP_DLL_CTRL, field SLV_FORCE_UPD */

#define BP_SSP_DLL_CTRL_SLV_FORCE_UPD      2
#define BM_SSP_DLL_CTRL_SLV_FORCE_UPD      0x00000004

#define BF_SSP_DLL_CTRL_SLV_FORCE_UPD(v)   (((v) << 2) & BM_SSP_DLL_CTRL_SLV_FORCE_UPD)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_DLL_CTRL_SLV_FORCE_UPD(n, v)   BFn_CS1(SSP_DLL_CTRL, n, SLV_FORCE_UPD, v)
#endif

/* --- Register HW_SSP_DLL_CTRL, field RESET */

#define BP_SSP_DLL_CTRL_RESET      1
#define BM_SSP_DLL_CTRL_RESET      0x00000002

#define BF_SSP_DLL_CTRL_RESET(v)   (((v) << 1) & BM_SSP_DLL_CTRL_RESET)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_DLL_CTRL_RESET(n, v)   BFn_CS1(SSP_DLL_CTRL, n, RESET, v)
#endif

/* --- Register HW_SSP_DLL_CTRL, field ENABLE */

#define BP_SSP_DLL_CTRL_ENABLE      0
#define BM_SSP_DLL_CTRL_ENABLE      0x00000001

#define BF_SSP_DLL_CTRL_ENABLE(v)   (((v) << 0) & BM_SSP_DLL_CTRL_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_SSP_DLL_CTRL_ENABLE(n, v)   BFn_CS1(SSP_DLL_CTRL, n, ENABLE, v)
#endif



/*
 * HW_SSP_STATUS - SSP Status Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BUSY               :  1;
        unsigned RSVD0              :  1;
        unsigned DATA_BUSY          :  1;
        unsigned CMD_BUSY           :  1;
        unsigned FIFO_UNDRFLW       :  1;
        unsigned FIFO_EMPTY         :  1;
        unsigned RSVD1              :  2;
        unsigned FIFO_FULL          :  1;
        unsigned FIFO_OVRFLW        :  1;
        unsigned CEATA_CCS_ERR      :  1;
        unsigned RECV_TIMEOUT_STAT  :  1;
        unsigned TIMEOUT            :  1;
        unsigned DATA_CRC_ERR       :  1;
        unsigned RESP_TIMEOUT       :  1;
        unsigned RESP_ERR           :  1;
        unsigned RESP_CRC_ERR       :  1;
        unsigned SDIO_IRQ           :  1;
        unsigned DMAEND             :  1;
        unsigned DMAREQ             :  1;
        unsigned DMATERM            :  1;
        unsigned DMASENSE           :  1;
        unsigned DMABURST           :  1;
        unsigned RSVD3              :  5;
        unsigned CARD_DETECT        :  1;
        unsigned SD_PRESENT         :  1;
        unsigned MS_PRESENT         :  1;
        unsigned PRESENT            :  1;
    } B;
} hw_ssp_status_t;
#endif

/*
 * constants & macros for entire multi-block HW_SSP_STATUS register
 */
#define HW_SSP_STATUS_ADDR(x)      (REGS_SSP_BASE(x) + 0x100)

#ifndef __LANGUAGE_ASM__
#define HW_SSP_STATUS(x)           (*(volatile hw_ssp_status_t *) HW_SSP_STATUS_ADDR(x))
#define HW_SSP_STATUS_RD(x)      (HW_SSP_STATUS(x).U)
#endif


/*
 * constants & macros for individual HW_SSP_STATUS bitfields
 */
/* --- Register HW_SSP_STATUS, field PRESENT */

#define BP_SSP_STATUS_PRESENT      31
#define BM_SSP_STATUS_PRESENT      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_SSP_STATUS_PRESENT(v)   ((((reg32_t) v) << 31) & BM_SSP_STATUS_PRESENT)
#else
#define BF_SSP_STATUS_PRESENT(v)   (((v) << 31) & BM_SSP_STATUS_PRESENT)
#endif
/* --- Register HW_SSP_STATUS, field MS_PRESENT */

#define BP_SSP_STATUS_MS_PRESENT      30
#define BM_SSP_STATUS_MS_PRESENT      0x40000000

#define BF_SSP_STATUS_MS_PRESENT(v)   (((v) << 30) & BM_SSP_STATUS_MS_PRESENT)
/* --- Register HW_SSP_STATUS, field SD_PRESENT */

#define BP_SSP_STATUS_SD_PRESENT      29
#define BM_SSP_STATUS_SD_PRESENT      0x20000000

#define BF_SSP_STATUS_SD_PRESENT(v)   (((v) << 29) & BM_SSP_STATUS_SD_PRESENT)
/* --- Register HW_SSP_STATUS, field CARD_DETECT */

#define BP_SSP_STATUS_CARD_DETECT      28
#define BM_SSP_STATUS_CARD_DETECT      0x10000000

#define BF_SSP_STATUS_CARD_DETECT(v)   (((v) << 28) & BM_SSP_STATUS_CARD_DETECT)
/* --- Register HW_SSP_STATUS, field RSVD3 */

#define BP_SSP_STATUS_RSVD3      23
#define BM_SSP_STATUS_RSVD3      0x0F800000

#define BF_SSP_STATUS_RSVD3(v)   (((v) << 23) & BM_SSP_STATUS_RSVD3)
/* --- Register HW_SSP_STATUS, field DMABURST */

#define BP_SSP_STATUS_DMABURST      22
#define BM_SSP_STATUS_DMABURST      0x00400000

#define BF_SSP_STATUS_DMABURST(v)   (((v) << 22) & BM_SSP_STATUS_DMABURST)
/* --- Register HW_SSP_STATUS, field DMASENSE */

#define BP_SSP_STATUS_DMASENSE      21
#define BM_SSP_STATUS_DMASENSE      0x00200000

#define BF_SSP_STATUS_DMASENSE(v)   (((v) << 21) & BM_SSP_STATUS_DMASENSE)
/* --- Register HW_SSP_STATUS, field DMATERM */

#define BP_SSP_STATUS_DMATERM      20
#define BM_SSP_STATUS_DMATERM      0x00100000

#define BF_SSP_STATUS_DMATERM(v)   (((v) << 20) & BM_SSP_STATUS_DMATERM)
/* --- Register HW_SSP_STATUS, field DMAREQ */

#define BP_SSP_STATUS_DMAREQ      19
#define BM_SSP_STATUS_DMAREQ      0x00080000

#define BF_SSP_STATUS_DMAREQ(v)   (((v) << 19) & BM_SSP_STATUS_DMAREQ)
/* --- Register HW_SSP_STATUS, field DMAEND */

#define BP_SSP_STATUS_DMAEND      18
#define BM_SSP_STATUS_DMAEND      0x00040000

#define BF_SSP_STATUS_DMAEND(v)   (((v) << 18) & BM_SSP_STATUS_DMAEND)
/* --- Register HW_SSP_STATUS, field SDIO_IRQ */

#define BP_SSP_STATUS_SDIO_IRQ      17
#define BM_SSP_STATUS_SDIO_IRQ      0x00020000

#define BF_SSP_STATUS_SDIO_IRQ(v)   (((v) << 17) & BM_SSP_STATUS_SDIO_IRQ)
/* --- Register HW_SSP_STATUS, field RESP_CRC_ERR */

#define BP_SSP_STATUS_RESP_CRC_ERR      16
#define BM_SSP_STATUS_RESP_CRC_ERR      0x00010000

#define BF_SSP_STATUS_RESP_CRC_ERR(v)   (((v) << 16) & BM_SSP_STATUS_RESP_CRC_ERR)
/* --- Register HW_SSP_STATUS, field RESP_ERR */

#define BP_SSP_STATUS_RESP_ERR      15
#define BM_SSP_STATUS_RESP_ERR      0x00008000

#define BF_SSP_STATUS_RESP_ERR(v)   (((v) << 15) & BM_SSP_STATUS_RESP_ERR)
/* --- Register HW_SSP_STATUS, field RESP_TIMEOUT */

#define BP_SSP_STATUS_RESP_TIMEOUT      14
#define BM_SSP_STATUS_RESP_TIMEOUT      0x00004000

#define BF_SSP_STATUS_RESP_TIMEOUT(v)   (((v) << 14) & BM_SSP_STATUS_RESP_TIMEOUT)
/* --- Register HW_SSP_STATUS, field DATA_CRC_ERR */

#define BP_SSP_STATUS_DATA_CRC_ERR      13
#define BM_SSP_STATUS_DATA_CRC_ERR      0x00002000

#define BF_SSP_STATUS_DATA_CRC_ERR(v)   (((v) << 13) & BM_SSP_STATUS_DATA_CRC_ERR)
/* --- Register HW_SSP_STATUS, field TIMEOUT */

#define BP_SSP_STATUS_TIMEOUT      12
#define BM_SSP_STATUS_TIMEOUT      0x00001000

#define BF_SSP_STATUS_TIMEOUT(v)   (((v) << 12) & BM_SSP_STATUS_TIMEOUT)
/* --- Register HW_SSP_STATUS, field RECV_TIMEOUT_STAT */

#define BP_SSP_STATUS_RECV_TIMEOUT_STAT      11
#define BM_SSP_STATUS_RECV_TIMEOUT_STAT      0x00000800

#define BF_SSP_STATUS_RECV_TIMEOUT_STAT(v)   (((v) << 11) & BM_SSP_STATUS_RECV_TIMEOUT_STAT)
/* --- Register HW_SSP_STATUS, field CEATA_CCS_ERR */

#define BP_SSP_STATUS_CEATA_CCS_ERR      10
#define BM_SSP_STATUS_CEATA_CCS_ERR      0x00000400

#define BF_SSP_STATUS_CEATA_CCS_ERR(v)   (((v) << 10) & BM_SSP_STATUS_CEATA_CCS_ERR)
/* --- Register HW_SSP_STATUS, field FIFO_OVRFLW */

#define BP_SSP_STATUS_FIFO_OVRFLW      9
#define BM_SSP_STATUS_FIFO_OVRFLW      0x00000200

#define BF_SSP_STATUS_FIFO_OVRFLW(v)   (((v) << 9) & BM_SSP_STATUS_FIFO_OVRFLW)
/* --- Register HW_SSP_STATUS, field FIFO_FULL */

#define BP_SSP_STATUS_FIFO_FULL      8
#define BM_SSP_STATUS_FIFO_FULL      0x00000100

#define BF_SSP_STATUS_FIFO_FULL(v)   (((v) << 8) & BM_SSP_STATUS_FIFO_FULL)
/* --- Register HW_SSP_STATUS, field RSVD1 */

#define BP_SSP_STATUS_RSVD1      6
#define BM_SSP_STATUS_RSVD1      0x000000C0

#define BF_SSP_STATUS_RSVD1(v)   (((v) << 6) & BM_SSP_STATUS_RSVD1)
/* --- Register HW_SSP_STATUS, field FIFO_EMPTY */

#define BP_SSP_STATUS_FIFO_EMPTY      5
#define BM_SSP_STATUS_FIFO_EMPTY      0x00000020

#define BF_SSP_STATUS_FIFO_EMPTY(v)   (((v) << 5) & BM_SSP_STATUS_FIFO_EMPTY)
/* --- Register HW_SSP_STATUS, field FIFO_UNDRFLW */

#define BP_SSP_STATUS_FIFO_UNDRFLW      4
#define BM_SSP_STATUS_FIFO_UNDRFLW      0x00000010

#define BF_SSP_STATUS_FIFO_UNDRFLW(v)   (((v) << 4) & BM_SSP_STATUS_FIFO_UNDRFLW)
/* --- Register HW_SSP_STATUS, field CMD_BUSY */

#define BP_SSP_STATUS_CMD_BUSY      3
#define BM_SSP_STATUS_CMD_BUSY      0x00000008

#define BF_SSP_STATUS_CMD_BUSY(v)   (((v) << 3) & BM_SSP_STATUS_CMD_BUSY)
/* --- Register HW_SSP_STATUS, field DATA_BUSY */

#define BP_SSP_STATUS_DATA_BUSY      2
#define BM_SSP_STATUS_DATA_BUSY      0x00000004

#define BF_SSP_STATUS_DATA_BUSY(v)   (((v) << 2) & BM_SSP_STATUS_DATA_BUSY)
/* --- Register HW_SSP_STATUS, field RSVD0 */

#define BP_SSP_STATUS_RSVD0      1
#define BM_SSP_STATUS_RSVD0      0x00000002

#define BF_SSP_STATUS_RSVD0(v)   (((v) << 1) & BM_SSP_STATUS_RSVD0)
/* --- Register HW_SSP_STATUS, field BUSY */

#define BP_SSP_STATUS_BUSY      0
#define BM_SSP_STATUS_BUSY      0x00000001

#define BF_SSP_STATUS_BUSY(v)   (((v) << 0) & BM_SSP_STATUS_BUSY)


/*
 * HW_SSP_DLL_STS - SD/MMC DLL Status Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned SLV_LOCK  :  1;
        unsigned REF_LOCK  :  1;
        unsigned SLV_SEL   :  6;
        unsigned REF_SEL   :  6;
        unsigned RSVD0     : 18;
    } B;
} hw_ssp_dll_sts_t;
#endif

/*
 * constants & macros for entire multi-block HW_SSP_DLL_STS register
 */
#define HW_SSP_DLL_STS_ADDR(x)      (REGS_SSP_BASE(x) + 0x110)

#ifndef __LANGUAGE_ASM__
#define HW_SSP_DLL_STS(x)           (*(volatile hw_ssp_dll_sts_t *) HW_SSP_DLL_STS_ADDR(x))
#define HW_SSP_DLL_STS_RD(x)      (HW_SSP_DLL_STS(x).U)
#endif


/*
 * constants & macros for individual HW_SSP_DLL_STS bitfields
 */
/* --- Register HW_SSP_DLL_STS, field RSVD0 */

#define BP_SSP_DLL_STS_RSVD0      14
#define BM_SSP_DLL_STS_RSVD0      0xFFFFC000

#ifndef __LANGUAGE_ASM__
#define BF_SSP_DLL_STS_RSVD0(v)   ((((reg32_t) v) << 14) & BM_SSP_DLL_STS_RSVD0)
#else
#define BF_SSP_DLL_STS_RSVD0(v)   (((v) << 14) & BM_SSP_DLL_STS_RSVD0)
#endif
/* --- Register HW_SSP_DLL_STS, field REF_SEL */

#define BP_SSP_DLL_STS_REF_SEL      8
#define BM_SSP_DLL_STS_REF_SEL      0x00003F00

#define BF_SSP_DLL_STS_REF_SEL(v)   (((v) << 8) & BM_SSP_DLL_STS_REF_SEL)
/* --- Register HW_SSP_DLL_STS, field SLV_SEL */

#define BP_SSP_DLL_STS_SLV_SEL      2
#define BM_SSP_DLL_STS_SLV_SEL      0x000000FC

#define BF_SSP_DLL_STS_SLV_SEL(v)   (((v) << 2) & BM_SSP_DLL_STS_SLV_SEL)
/* --- Register HW_SSP_DLL_STS, field REF_LOCK */

#define BP_SSP_DLL_STS_REF_LOCK      1
#define BM_SSP_DLL_STS_REF_LOCK      0x00000002

#define BF_SSP_DLL_STS_REF_LOCK(v)   (((v) << 1) & BM_SSP_DLL_STS_REF_LOCK)
/* --- Register HW_SSP_DLL_STS, field SLV_LOCK */

#define BP_SSP_DLL_STS_SLV_LOCK      0
#define BM_SSP_DLL_STS_SLV_LOCK      0x00000001

#define BF_SSP_DLL_STS_SLV_LOCK(v)   (((v) << 0) & BM_SSP_DLL_STS_SLV_LOCK)


/*
 * HW_SSP_DEBUG - SSP Debug Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned SSP_RXD      :  8;
        unsigned SSP_RESP     :  1;
        unsigned SSP_CMD      :  1;
        unsigned CMD_SM       :  2;
        unsigned MMC_SM       :  4;
        unsigned DMA_SM       :  3;
        unsigned CMD_OE       :  1;
        unsigned MSTK_SM      :  4;
        unsigned DAT_SM       :  3;
        unsigned DATA_STALL   :  1;
        unsigned DATACRC_ERR  :  4;
    } B;
} hw_ssp_debug_t;
#endif

/*
 * constants & macros for entire multi-block HW_SSP_DEBUG register
 */
#define HW_SSP_DEBUG_ADDR(x)      (REGS_SSP_BASE(x) + 0x120)

#ifndef __LANGUAGE_ASM__
#define HW_SSP_DEBUG(x)           (*(volatile hw_ssp_debug_t *) HW_SSP_DEBUG_ADDR(x))
#define HW_SSP_DEBUG_RD(x)      (HW_SSP_DEBUG(x).U)
#endif


/*
 * constants & macros for individual HW_SSP_DEBUG bitfields
 */
/* --- Register HW_SSP_DEBUG, field DATACRC_ERR */

#define BP_SSP_DEBUG_DATACRC_ERR      28
#define BM_SSP_DEBUG_DATACRC_ERR      0xF0000000

#ifndef __LANGUAGE_ASM__
#define BF_SSP_DEBUG_DATACRC_ERR(v)   ((((reg32_t) v) << 28) & BM_SSP_DEBUG_DATACRC_ERR)
#else
#define BF_SSP_DEBUG_DATACRC_ERR(v)   (((v) << 28) & BM_SSP_DEBUG_DATACRC_ERR)
#endif
/* --- Register HW_SSP_DEBUG, field DATA_STALL */

#define BP_SSP_DEBUG_DATA_STALL      27
#define BM_SSP_DEBUG_DATA_STALL      0x08000000

#define BF_SSP_DEBUG_DATA_STALL(v)   (((v) << 27) & BM_SSP_DEBUG_DATA_STALL)
/* --- Register HW_SSP_DEBUG, field DAT_SM */

#define BP_SSP_DEBUG_DAT_SM      24
#define BM_SSP_DEBUG_DAT_SM      0x07000000

#define BF_SSP_DEBUG_DAT_SM(v)   (((v) << 24) & BM_SSP_DEBUG_DAT_SM)
#define BV_SSP_DEBUG_DAT_SM__DSM_IDLE  0x0
#define BV_SSP_DEBUG_DAT_SM__DSM_WORD  0x2
#define BV_SSP_DEBUG_DAT_SM__DSM_CRC1  0x3
#define BV_SSP_DEBUG_DAT_SM__DSM_CRC2  0x4
#define BV_SSP_DEBUG_DAT_SM__DSM_END   0x5

/* --- Register HW_SSP_DEBUG, field MSTK_SM */

#define BP_SSP_DEBUG_MSTK_SM      20
#define BM_SSP_DEBUG_MSTK_SM      0x00F00000

#define BF_SSP_DEBUG_MSTK_SM(v)   (((v) << 20) & BM_SSP_DEBUG_MSTK_SM)
#define BV_SSP_DEBUG_MSTK_SM__MSTK_IDLE   0x0
#define BV_SSP_DEBUG_MSTK_SM__MSTK_CKON   0x1
#define BV_SSP_DEBUG_MSTK_SM__MSTK_BS1    0x2
#define BV_SSP_DEBUG_MSTK_SM__MSTK_TPC    0x3
#define BV_SSP_DEBUG_MSTK_SM__MSTK_BS2    0x4
#define BV_SSP_DEBUG_MSTK_SM__MSTK_HDSHK  0x5
#define BV_SSP_DEBUG_MSTK_SM__MSTK_BS3    0x6
#define BV_SSP_DEBUG_MSTK_SM__MSTK_RW     0x7
#define BV_SSP_DEBUG_MSTK_SM__MSTK_CRC1   0x8
#define BV_SSP_DEBUG_MSTK_SM__MSTK_CRC2   0x9
#define BV_SSP_DEBUG_MSTK_SM__MSTK_BS0    0xA
#define BV_SSP_DEBUG_MSTK_SM__MSTK_END1   0xB
#define BV_SSP_DEBUG_MSTK_SM__MSTK_END2W  0xC
#define BV_SSP_DEBUG_MSTK_SM__MSTK_END2R  0xD
#define BV_SSP_DEBUG_MSTK_SM__MSTK_DONE   0xE

/* --- Register HW_SSP_DEBUG, field CMD_OE */

#define BP_SSP_DEBUG_CMD_OE      19
#define BM_SSP_DEBUG_CMD_OE      0x00080000

#define BF_SSP_DEBUG_CMD_OE(v)   (((v) << 19) & BM_SSP_DEBUG_CMD_OE)
/* --- Register HW_SSP_DEBUG, field DMA_SM */

#define BP_SSP_DEBUG_DMA_SM      16
#define BM_SSP_DEBUG_DMA_SM      0x00070000

#define BF_SSP_DEBUG_DMA_SM(v)   (((v) << 16) & BM_SSP_DEBUG_DMA_SM)
#define BV_SSP_DEBUG_DMA_SM__DMA_IDLE    0x0
#define BV_SSP_DEBUG_DMA_SM__DMA_DMAREQ  0x1
#define BV_SSP_DEBUG_DMA_SM__DMA_DMAACK  0x2
#define BV_SSP_DEBUG_DMA_SM__DMA_STALL   0x3
#define BV_SSP_DEBUG_DMA_SM__DMA_BUSY    0x4
#define BV_SSP_DEBUG_DMA_SM__DMA_DONE    0x5
#define BV_SSP_DEBUG_DMA_SM__DMA_COUNT   0x6

/* --- Register HW_SSP_DEBUG, field MMC_SM */

#define BP_SSP_DEBUG_MMC_SM      12
#define BM_SSP_DEBUG_MMC_SM      0x0000F000

#define BF_SSP_DEBUG_MMC_SM(v)   (((v) << 12) & BM_SSP_DEBUG_MMC_SM)
#define BV_SSP_DEBUG_MMC_SM__MMC_IDLE  0x0
#define BV_SSP_DEBUG_MMC_SM__MMC_CMD   0x1
#define BV_SSP_DEBUG_MMC_SM__MMC_TRC   0x2
#define BV_SSP_DEBUG_MMC_SM__MMC_RESP  0x3
#define BV_SSP_DEBUG_MMC_SM__MMC_RPRX  0x4
#define BV_SSP_DEBUG_MMC_SM__MMC_TX    0x5
#define BV_SSP_DEBUG_MMC_SM__MMC_CTOK  0x6
#define BV_SSP_DEBUG_MMC_SM__MMC_RX    0x7
#define BV_SSP_DEBUG_MMC_SM__MMC_CCS   0x8
#define BV_SSP_DEBUG_MMC_SM__MMC_PUP   0x9
#define BV_SSP_DEBUG_MMC_SM__MMC_WAIT  0xA

/* --- Register HW_SSP_DEBUG, field CMD_SM */

#define BP_SSP_DEBUG_CMD_SM      10
#define BM_SSP_DEBUG_CMD_SM      0x00000C00

#define BF_SSP_DEBUG_CMD_SM(v)   (((v) << 10) & BM_SSP_DEBUG_CMD_SM)
#define BV_SSP_DEBUG_CMD_SM__CSM_IDLE   0x0
#define BV_SSP_DEBUG_CMD_SM__CSM_INDEX  0x1
#define BV_SSP_DEBUG_CMD_SM__CSM_ARG    0x2
#define BV_SSP_DEBUG_CMD_SM__CSM_CRC    0x3

/* --- Register HW_SSP_DEBUG, field SSP_CMD */

#define BP_SSP_DEBUG_SSP_CMD      9
#define BM_SSP_DEBUG_SSP_CMD      0x00000200

#define BF_SSP_DEBUG_SSP_CMD(v)   (((v) << 9) & BM_SSP_DEBUG_SSP_CMD)
/* --- Register HW_SSP_DEBUG, field SSP_RESP */

#define BP_SSP_DEBUG_SSP_RESP      8
#define BM_SSP_DEBUG_SSP_RESP      0x00000100

#define BF_SSP_DEBUG_SSP_RESP(v)   (((v) << 8) & BM_SSP_DEBUG_SSP_RESP)
/* --- Register HW_SSP_DEBUG, field SSP_RXD */

#define BP_SSP_DEBUG_SSP_RXD      0
#define BM_SSP_DEBUG_SSP_RXD      0x000000FF

#define BF_SSP_DEBUG_SSP_RXD(v)   (((v) << 0) & BM_SSP_DEBUG_SSP_RXD)


/*
 * HW_SSP_VERSION - SSP Version Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned STEP   : 16;
        unsigned MINOR  :  8;
        unsigned MAJOR  :  8;
    } B;
} hw_ssp_version_t;
#endif

/*
 * constants & macros for entire multi-block HW_SSP_VERSION register
 */
#define HW_SSP_VERSION_ADDR(x)      (REGS_SSP_BASE(x) + 0x130)

#ifndef __LANGUAGE_ASM__
#define HW_SSP_VERSION(x)           (*(volatile hw_ssp_version_t *) HW_SSP_VERSION_ADDR(x))
#define HW_SSP_VERSION_RD(x)      (HW_SSP_VERSION(x).U)
#endif


/*
 * constants & macros for individual HW_SSP_VERSION bitfields
 */
/* --- Register HW_SSP_VERSION, field MAJOR */

#define BP_SSP_VERSION_MAJOR      24
#define BM_SSP_VERSION_MAJOR      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_SSP_VERSION_MAJOR(v)   ((((reg32_t) v) << 24) & BM_SSP_VERSION_MAJOR)
#else
#define BF_SSP_VERSION_MAJOR(v)   (((v) << 24) & BM_SSP_VERSION_MAJOR)
#endif
/* --- Register HW_SSP_VERSION, field MINOR */

#define BP_SSP_VERSION_MINOR      16
#define BM_SSP_VERSION_MINOR      0x00FF0000

#define BF_SSP_VERSION_MINOR(v)   (((v) << 16) & BM_SSP_VERSION_MINOR)
/* --- Register HW_SSP_VERSION, field STEP */

#define BP_SSP_VERSION_STEP      0
#define BM_SSP_VERSION_STEP      0x0000FFFF

#define BF_SSP_VERSION_STEP(v)   (((v) << 0) & BM_SSP_VERSION_STEP)

#endif /* _SSP_H */

////////////////////////////////////////////////////////////////////////////////
