/*
 * Copyright 2008-2009 Freescale Semiconductor, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

 * WARNING!  THIS FILE IS AUTOMATICALLY GENERATED FROM XML.
 *                DO NOT MODIFY THIS FILE DIRECTLY.
 *
 * Xml Revision: 1.32
 *
 * Template revision: 26195
 *
 *
 * The following naming conventions are followed in this file.
 *      XX_<module>_<regname>_<field>
 *
 * XX specifies the define / macro class
 *      HW pertains to a register
 *      BM indicates a Bit Mask
 *      BF indicates a Bit Field macro
 *
 * <module> is the hardware module name which can be any of the following...
 *      USB20 (Note when there is more than one copy of a given module, the
 *      module name includes a number starting from 0 for the first instance
 *      of that module)
 *
 * <regname> is the specific register within that module
 *
 * <field> is the specific bitfield within that <module>_<register>
 *
 * We also define the following...
 *      hw_<module>_<regname>_t is typedef of anonymous union
 *
 */

#ifndef _SWITCH_H
#define _SWITCH_H  1

#include "regs.h"

#ifndef REGS_ENET_BASE
#define REGS_ENET_BASE (REGS_BASE + 0xf0000)
#endif

/*
 * HW_ENET_SWI_REVISION - ENET SWI revision
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned CORE_REVISION      : 16;
        unsigned CUSTOMER_REVISION  : 16;
    } B;
} hw_enet_swi_revision_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_REVISION register
 */
#define HW_ENET_SWI_REVISION_ADDR         (REGS_ENET_BASE + 0x8000)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_REVISION           (*(volatile hw_enet_swi_revision_t *) HW_ENET_SWI_REVISION_ADDR)
#define HW_ENET_SWI_REVISION_RD()      (HW_ENET_SWI_REVISION.U)
#endif


/*
 * constants & macros for individual HW_ENET_SWI_REVISION bitfields
 */
/* --- Register HW_ENET_SWI_REVISION, field CUSTOMER_REVISION */

#define BP_ENET_SWI_REVISION_CUSTOMER_REVISION      16
#define BM_ENET_SWI_REVISION_CUSTOMER_REVISION      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_REVISION_CUSTOMER_REVISION(v)   ((((reg32_t) v) << 16) & BM_ENET_SWI_REVISION_CUSTOMER_REVISION)
#else
#define BF_ENET_SWI_REVISION_CUSTOMER_REVISION(v)   (((v) << 16) & BM_ENET_SWI_REVISION_CUSTOMER_REVISION)
#endif
/* --- Register HW_ENET_SWI_REVISION, field CORE_REVISION */

#define BP_ENET_SWI_REVISION_CORE_REVISION      0
#define BM_ENET_SWI_REVISION_CORE_REVISION      0x0000FFFF

#define BF_ENET_SWI_REVISION_CORE_REVISION(v)   (((v) << 0) & BM_ENET_SWI_REVISION_CORE_REVISION)


/*
 * HW_ENET_SWI_SCRATCH - ENET SWI Scratch Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned COMPARE0  : 32;
    } B;
} hw_enet_swi_scratch_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_SCRATCH register
 */
#define HW_ENET_SWI_SCRATCH_ADDR         (REGS_ENET_BASE + 0x8004)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_SCRATCH           (*(volatile hw_enet_swi_scratch_t *) HW_ENET_SWI_SCRATCH_ADDR)
#define HW_ENET_SWI_SCRATCH_RD()      (HW_ENET_SWI_SCRATCH.U)
#define HW_ENET_SWI_SCRATCH_WR(v)     (HW_ENET_SWI_SCRATCH.U = (v))
#define HW_ENET_SWI_SCRATCH_SET(v)    (HW_ENET_SWI_SCRATCH_WR(HW_ENET_SWI_SCRATCH_RD() |  (v)))
#define HW_ENET_SWI_SCRATCH_CLR(v)    (HW_ENET_SWI_SCRATCH_WR(HW_ENET_SWI_SCRATCH_RD() & ~(v)))
#define HW_ENET_SWI_SCRATCH_TOG(v)    (HW_ENET_SWI_SCRATCH_WR(HW_ENET_SWI_SCRATCH_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_SCRATCH bitfields
 */
/* --- Register HW_ENET_SWI_SCRATCH, field COMPARE0 */

#define BP_ENET_SWI_SCRATCH_COMPARE0      0
#define BM_ENET_SWI_SCRATCH_COMPARE0      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_SCRATCH_COMPARE0(v)   ((reg32_t) v)
#else
#define BF_ENET_SWI_SCRATCH_COMPARE0(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_SCRATCH_COMPARE0(v)   (HW_ENET_SWI_SCRATCH.B.COMPARE0 = (v))
#endif



/*
 * HW_ENET_SWI_PORT_ENA - ENET SWI Port Enable Bits.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ENA_TRANSMIT_0  :  1;
        unsigned ENA_TRANSMIT_1  :  1;
        unsigned ENA_TRANSMIT_2  :  1;
        unsigned RSRVD0          : 13;
        unsigned ENA_RECEIVE_0   :  1;
        unsigned ENA_RECEIVE_1   :  1;
        unsigned ENA_RECEIVE_2   :  1;
        unsigned RSRVD1          : 13;
    } B;
} hw_enet_swi_port_ena_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_PORT_ENA register
 */
#define HW_ENET_SWI_PORT_ENA_ADDR         (REGS_ENET_BASE + 0x8008)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_PORT_ENA           (*(volatile hw_enet_swi_port_ena_t *) HW_ENET_SWI_PORT_ENA_ADDR)
#define HW_ENET_SWI_PORT_ENA_RD()      (HW_ENET_SWI_PORT_ENA.U)
#define HW_ENET_SWI_PORT_ENA_WR(v)     (HW_ENET_SWI_PORT_ENA.U = (v))
#define HW_ENET_SWI_PORT_ENA_SET(v)    (HW_ENET_SWI_PORT_ENA_WR(HW_ENET_SWI_PORT_ENA_RD() |  (v)))
#define HW_ENET_SWI_PORT_ENA_CLR(v)    (HW_ENET_SWI_PORT_ENA_WR(HW_ENET_SWI_PORT_ENA_RD() & ~(v)))
#define HW_ENET_SWI_PORT_ENA_TOG(v)    (HW_ENET_SWI_PORT_ENA_WR(HW_ENET_SWI_PORT_ENA_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_PORT_ENA bitfields
 */
/* --- Register HW_ENET_SWI_PORT_ENA, field RSRVD1 */

#define BP_ENET_SWI_PORT_ENA_RSRVD1      19
#define BM_ENET_SWI_PORT_ENA_RSRVD1      0xFFF80000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_PORT_ENA_RSRVD1(v)   ((((reg32_t) v) << 19) & BM_ENET_SWI_PORT_ENA_RSRVD1)
#else
#define BF_ENET_SWI_PORT_ENA_RSRVD1(v)   (((v) << 19) & BM_ENET_SWI_PORT_ENA_RSRVD1)
#endif
/* --- Register HW_ENET_SWI_PORT_ENA, field ENA_RECEIVE_2 */

#define BP_ENET_SWI_PORT_ENA_ENA_RECEIVE_2      18
#define BM_ENET_SWI_PORT_ENA_ENA_RECEIVE_2      0x00040000

#define BF_ENET_SWI_PORT_ENA_ENA_RECEIVE_2(v)   (((v) << 18) & BM_ENET_SWI_PORT_ENA_ENA_RECEIVE_2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PORT_ENA_ENA_RECEIVE_2(v)   BF_CS1(ENET_SWI_PORT_ENA, ENA_RECEIVE_2, v)
#endif

/* --- Register HW_ENET_SWI_PORT_ENA, field ENA_RECEIVE_1 */

#define BP_ENET_SWI_PORT_ENA_ENA_RECEIVE_1      17
#define BM_ENET_SWI_PORT_ENA_ENA_RECEIVE_1      0x00020000

#define BF_ENET_SWI_PORT_ENA_ENA_RECEIVE_1(v)   (((v) << 17) & BM_ENET_SWI_PORT_ENA_ENA_RECEIVE_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PORT_ENA_ENA_RECEIVE_1(v)   BF_CS1(ENET_SWI_PORT_ENA, ENA_RECEIVE_1, v)
#endif

/* --- Register HW_ENET_SWI_PORT_ENA, field ENA_RECEIVE_0 */

#define BP_ENET_SWI_PORT_ENA_ENA_RECEIVE_0      16
#define BM_ENET_SWI_PORT_ENA_ENA_RECEIVE_0      0x00010000

#define BF_ENET_SWI_PORT_ENA_ENA_RECEIVE_0(v)   (((v) << 16) & BM_ENET_SWI_PORT_ENA_ENA_RECEIVE_0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PORT_ENA_ENA_RECEIVE_0(v)   BF_CS1(ENET_SWI_PORT_ENA, ENA_RECEIVE_0, v)
#endif

/* --- Register HW_ENET_SWI_PORT_ENA, field RSRVD0 */

#define BP_ENET_SWI_PORT_ENA_RSRVD0      3
#define BM_ENET_SWI_PORT_ENA_RSRVD0      0x0000FFF8

#define BF_ENET_SWI_PORT_ENA_RSRVD0(v)   (((v) << 3) & BM_ENET_SWI_PORT_ENA_RSRVD0)
/* --- Register HW_ENET_SWI_PORT_ENA, field ENA_TRANSMIT_2 */

#define BP_ENET_SWI_PORT_ENA_ENA_TRANSMIT_2      2
#define BM_ENET_SWI_PORT_ENA_ENA_TRANSMIT_2      0x00000004

#define BF_ENET_SWI_PORT_ENA_ENA_TRANSMIT_2(v)   (((v) << 2) & BM_ENET_SWI_PORT_ENA_ENA_TRANSMIT_2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PORT_ENA_ENA_TRANSMIT_2(v)   BF_CS1(ENET_SWI_PORT_ENA, ENA_TRANSMIT_2, v)
#endif

/* --- Register HW_ENET_SWI_PORT_ENA, field ENA_TRANSMIT_1 */

#define BP_ENET_SWI_PORT_ENA_ENA_TRANSMIT_1      1
#define BM_ENET_SWI_PORT_ENA_ENA_TRANSMIT_1      0x00000002

#define BF_ENET_SWI_PORT_ENA_ENA_TRANSMIT_1(v)   (((v) << 1) & BM_ENET_SWI_PORT_ENA_ENA_TRANSMIT_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PORT_ENA_ENA_TRANSMIT_1(v)   BF_CS1(ENET_SWI_PORT_ENA, ENA_TRANSMIT_1, v)
#endif

/* --- Register HW_ENET_SWI_PORT_ENA, field ENA_TRANSMIT_0 */

#define BP_ENET_SWI_PORT_ENA_ENA_TRANSMIT_0      0
#define BM_ENET_SWI_PORT_ENA_ENA_TRANSMIT_0      0x00000001

#define BF_ENET_SWI_PORT_ENA_ENA_TRANSMIT_0(v)   (((v) << 0) & BM_ENET_SWI_PORT_ENA_ENA_TRANSMIT_0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PORT_ENA_ENA_TRANSMIT_0(v)   BF_CS1(ENET_SWI_PORT_ENA, ENA_TRANSMIT_0, v)
#endif



/*
 * HW_ENET_SWI_VLAN_VERIFY - ENET SWI Verify VLAN domain.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned VLAN_VERIFY_0  :  1;
        unsigned VLAN_VERIFY_1  :  1;
        unsigned VLAN_VERIFY_2  :  1;
        unsigned RSRVD0         : 13;
        unsigned DISCARD_P0     :  1;
        unsigned DISCARD_P1     :  1;
        unsigned DISCARD_P2     :  1;
        unsigned RSRVD1         : 13;
    } B;
} hw_enet_swi_vlan_verify_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_VLAN_VERIFY register
 */
#define HW_ENET_SWI_VLAN_VERIFY_ADDR         (REGS_ENET_BASE + 0x8010)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_VLAN_VERIFY           (*(volatile hw_enet_swi_vlan_verify_t *) HW_ENET_SWI_VLAN_VERIFY_ADDR)
#define HW_ENET_SWI_VLAN_VERIFY_RD()      (HW_ENET_SWI_VLAN_VERIFY.U)
#define HW_ENET_SWI_VLAN_VERIFY_WR(v)     (HW_ENET_SWI_VLAN_VERIFY.U = (v))
#define HW_ENET_SWI_VLAN_VERIFY_SET(v)    (HW_ENET_SWI_VLAN_VERIFY_WR(HW_ENET_SWI_VLAN_VERIFY_RD() |  (v)))
#define HW_ENET_SWI_VLAN_VERIFY_CLR(v)    (HW_ENET_SWI_VLAN_VERIFY_WR(HW_ENET_SWI_VLAN_VERIFY_RD() & ~(v)))
#define HW_ENET_SWI_VLAN_VERIFY_TOG(v)    (HW_ENET_SWI_VLAN_VERIFY_WR(HW_ENET_SWI_VLAN_VERIFY_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_VLAN_VERIFY bitfields
 */
/* --- Register HW_ENET_SWI_VLAN_VERIFY, field RSRVD1 */

#define BP_ENET_SWI_VLAN_VERIFY_RSRVD1      19
#define BM_ENET_SWI_VLAN_VERIFY_RSRVD1      0xFFF80000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_VLAN_VERIFY_RSRVD1(v)   ((((reg32_t) v) << 19) & BM_ENET_SWI_VLAN_VERIFY_RSRVD1)
#else
#define BF_ENET_SWI_VLAN_VERIFY_RSRVD1(v)   (((v) << 19) & BM_ENET_SWI_VLAN_VERIFY_RSRVD1)
#endif
/* --- Register HW_ENET_SWI_VLAN_VERIFY, field DISCARD_P2 */

#define BP_ENET_SWI_VLAN_VERIFY_DISCARD_P2      18
#define BM_ENET_SWI_VLAN_VERIFY_DISCARD_P2      0x00040000

#define BF_ENET_SWI_VLAN_VERIFY_DISCARD_P2(v)   (((v) << 18) & BM_ENET_SWI_VLAN_VERIFY_DISCARD_P2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_VERIFY_DISCARD_P2(v)   BF_CS1(ENET_SWI_VLAN_VERIFY, DISCARD_P2, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_VERIFY, field DISCARD_P1 */

#define BP_ENET_SWI_VLAN_VERIFY_DISCARD_P1      17
#define BM_ENET_SWI_VLAN_VERIFY_DISCARD_P1      0x00020000

#define BF_ENET_SWI_VLAN_VERIFY_DISCARD_P1(v)   (((v) << 17) & BM_ENET_SWI_VLAN_VERIFY_DISCARD_P1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_VERIFY_DISCARD_P1(v)   BF_CS1(ENET_SWI_VLAN_VERIFY, DISCARD_P1, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_VERIFY, field DISCARD_P0 */

#define BP_ENET_SWI_VLAN_VERIFY_DISCARD_P0      16
#define BM_ENET_SWI_VLAN_VERIFY_DISCARD_P0      0x00010000

#define BF_ENET_SWI_VLAN_VERIFY_DISCARD_P0(v)   (((v) << 16) & BM_ENET_SWI_VLAN_VERIFY_DISCARD_P0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_VERIFY_DISCARD_P0(v)   BF_CS1(ENET_SWI_VLAN_VERIFY, DISCARD_P0, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_VERIFY, field RSRVD0 */

#define BP_ENET_SWI_VLAN_VERIFY_RSRVD0      3
#define BM_ENET_SWI_VLAN_VERIFY_RSRVD0      0x0000FFF8

#define BF_ENET_SWI_VLAN_VERIFY_RSRVD0(v)   (((v) << 3) & BM_ENET_SWI_VLAN_VERIFY_RSRVD0)
/* --- Register HW_ENET_SWI_VLAN_VERIFY, field VLAN_VERIFY_2 */

#define BP_ENET_SWI_VLAN_VERIFY_VLAN_VERIFY_2      2
#define BM_ENET_SWI_VLAN_VERIFY_VLAN_VERIFY_2      0x00000004

#define BF_ENET_SWI_VLAN_VERIFY_VLAN_VERIFY_2(v)   (((v) << 2) & BM_ENET_SWI_VLAN_VERIFY_VLAN_VERIFY_2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_VERIFY_VLAN_VERIFY_2(v)   BF_CS1(ENET_SWI_VLAN_VERIFY, VLAN_VERIFY_2, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_VERIFY, field VLAN_VERIFY_1 */

#define BP_ENET_SWI_VLAN_VERIFY_VLAN_VERIFY_1      1
#define BM_ENET_SWI_VLAN_VERIFY_VLAN_VERIFY_1      0x00000002

#define BF_ENET_SWI_VLAN_VERIFY_VLAN_VERIFY_1(v)   (((v) << 1) & BM_ENET_SWI_VLAN_VERIFY_VLAN_VERIFY_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_VERIFY_VLAN_VERIFY_1(v)   BF_CS1(ENET_SWI_VLAN_VERIFY, VLAN_VERIFY_1, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_VERIFY, field VLAN_VERIFY_0 */

#define BP_ENET_SWI_VLAN_VERIFY_VLAN_VERIFY_0      0
#define BM_ENET_SWI_VLAN_VERIFY_VLAN_VERIFY_0      0x00000001

#define BF_ENET_SWI_VLAN_VERIFY_VLAN_VERIFY_0(v)   (((v) << 0) & BM_ENET_SWI_VLAN_VERIFY_VLAN_VERIFY_0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_VERIFY_VLAN_VERIFY_0(v)   BF_CS1(ENET_SWI_VLAN_VERIFY, VLAN_VERIFY_0, v)
#endif



/*
 * HW_ENET_SWI_BCAST_DEFAULT_MASK - ENET SWI Default broadcast resolution.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BCAST_DEFAULT_MASK_0  :  1;
        unsigned BCAST_DEFAULT_MASK_1  :  1;
        unsigned BCAST_DEFAULT_MASK_2  :  1;
        unsigned RSRVD0                : 29;
    } B;
} hw_enet_swi_bcast_default_mask_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_BCAST_DEFAULT_MASK register
 */
#define HW_ENET_SWI_BCAST_DEFAULT_MASK_ADDR         (REGS_ENET_BASE + 0x8014)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_BCAST_DEFAULT_MASK           (*(volatile hw_enet_swi_bcast_default_mask_t *) HW_ENET_SWI_BCAST_DEFAULT_MASK_ADDR)
#define HW_ENET_SWI_BCAST_DEFAULT_MASK_RD()      (HW_ENET_SWI_BCAST_DEFAULT_MASK.U)
#define HW_ENET_SWI_BCAST_DEFAULT_MASK_WR(v)     (HW_ENET_SWI_BCAST_DEFAULT_MASK.U = (v))
#define HW_ENET_SWI_BCAST_DEFAULT_MASK_SET(v)    (HW_ENET_SWI_BCAST_DEFAULT_MASK_WR(HW_ENET_SWI_BCAST_DEFAULT_MASK_RD() |  (v)))
#define HW_ENET_SWI_BCAST_DEFAULT_MASK_CLR(v)    (HW_ENET_SWI_BCAST_DEFAULT_MASK_WR(HW_ENET_SWI_BCAST_DEFAULT_MASK_RD() & ~(v)))
#define HW_ENET_SWI_BCAST_DEFAULT_MASK_TOG(v)    (HW_ENET_SWI_BCAST_DEFAULT_MASK_WR(HW_ENET_SWI_BCAST_DEFAULT_MASK_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_BCAST_DEFAULT_MASK bitfields
 */
/* --- Register HW_ENET_SWI_BCAST_DEFAULT_MASK, field RSRVD0 */

#define BP_ENET_SWI_BCAST_DEFAULT_MASK_RSRVD0      3
#define BM_ENET_SWI_BCAST_DEFAULT_MASK_RSRVD0      0xFFFFFFF8

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_BCAST_DEFAULT_MASK_RSRVD0(v)   ((((reg32_t) v) << 3) & BM_ENET_SWI_BCAST_DEFAULT_MASK_RSRVD0)
#else
#define BF_ENET_SWI_BCAST_DEFAULT_MASK_RSRVD0(v)   (((v) << 3) & BM_ENET_SWI_BCAST_DEFAULT_MASK_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_BCAST_DEFAULT_MASK, field BCAST_DEFAULT_MASK_2 */

#define BP_ENET_SWI_BCAST_DEFAULT_MASK_BCAST_DEFAULT_MASK_2      2
#define BM_ENET_SWI_BCAST_DEFAULT_MASK_BCAST_DEFAULT_MASK_2      0x00000004

#define BF_ENET_SWI_BCAST_DEFAULT_MASK_BCAST_DEFAULT_MASK_2(v)   (((v) << 2) & BM_ENET_SWI_BCAST_DEFAULT_MASK_BCAST_DEFAULT_MASK_2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_BCAST_DEFAULT_MASK_BCAST_DEFAULT_MASK_2(v)   BF_CS1(ENET_SWI_BCAST_DEFAULT_MASK, BCAST_DEFAULT_MASK_2, v)
#endif

/* --- Register HW_ENET_SWI_BCAST_DEFAULT_MASK, field BCAST_DEFAULT_MASK_1 */

#define BP_ENET_SWI_BCAST_DEFAULT_MASK_BCAST_DEFAULT_MASK_1      1
#define BM_ENET_SWI_BCAST_DEFAULT_MASK_BCAST_DEFAULT_MASK_1      0x00000002

#define BF_ENET_SWI_BCAST_DEFAULT_MASK_BCAST_DEFAULT_MASK_1(v)   (((v) << 1) & BM_ENET_SWI_BCAST_DEFAULT_MASK_BCAST_DEFAULT_MASK_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_BCAST_DEFAULT_MASK_BCAST_DEFAULT_MASK_1(v)   BF_CS1(ENET_SWI_BCAST_DEFAULT_MASK, BCAST_DEFAULT_MASK_1, v)
#endif

/* --- Register HW_ENET_SWI_BCAST_DEFAULT_MASK, field BCAST_DEFAULT_MASK_0 */

#define BP_ENET_SWI_BCAST_DEFAULT_MASK_BCAST_DEFAULT_MASK_0      0
#define BM_ENET_SWI_BCAST_DEFAULT_MASK_BCAST_DEFAULT_MASK_0      0x00000001

#define BF_ENET_SWI_BCAST_DEFAULT_MASK_BCAST_DEFAULT_MASK_0(v)   (((v) << 0) & BM_ENET_SWI_BCAST_DEFAULT_MASK_BCAST_DEFAULT_MASK_0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_BCAST_DEFAULT_MASK_BCAST_DEFAULT_MASK_0(v)   BF_CS1(ENET_SWI_BCAST_DEFAULT_MASK, BCAST_DEFAULT_MASK_0, v)
#endif



/*
 * HW_ENET_SWI_MCAST_DEFAULT_MASK - ENET SWI Default multicast resolution.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned MCAST_DEFAULT_MASK_0  :  1;
        unsigned MCAST_DEFAULT_MASK_1  :  1;
        unsigned MCAST_DEFAULT_MASK_2  :  1;
        unsigned RSRVD0                : 29;
    } B;
} hw_enet_swi_mcast_default_mask_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_MCAST_DEFAULT_MASK register
 */
#define HW_ENET_SWI_MCAST_DEFAULT_MASK_ADDR         (REGS_ENET_BASE + 0x8018)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_MCAST_DEFAULT_MASK           (*(volatile hw_enet_swi_mcast_default_mask_t *) HW_ENET_SWI_MCAST_DEFAULT_MASK_ADDR)
#define HW_ENET_SWI_MCAST_DEFAULT_MASK_RD()      (HW_ENET_SWI_MCAST_DEFAULT_MASK.U)
#define HW_ENET_SWI_MCAST_DEFAULT_MASK_WR(v)     (HW_ENET_SWI_MCAST_DEFAULT_MASK.U = (v))
#define HW_ENET_SWI_MCAST_DEFAULT_MASK_SET(v)    (HW_ENET_SWI_MCAST_DEFAULT_MASK_WR(HW_ENET_SWI_MCAST_DEFAULT_MASK_RD() |  (v)))
#define HW_ENET_SWI_MCAST_DEFAULT_MASK_CLR(v)    (HW_ENET_SWI_MCAST_DEFAULT_MASK_WR(HW_ENET_SWI_MCAST_DEFAULT_MASK_RD() & ~(v)))
#define HW_ENET_SWI_MCAST_DEFAULT_MASK_TOG(v)    (HW_ENET_SWI_MCAST_DEFAULT_MASK_WR(HW_ENET_SWI_MCAST_DEFAULT_MASK_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_MCAST_DEFAULT_MASK bitfields
 */
/* --- Register HW_ENET_SWI_MCAST_DEFAULT_MASK, field RSRVD0 */

#define BP_ENET_SWI_MCAST_DEFAULT_MASK_RSRVD0      3
#define BM_ENET_SWI_MCAST_DEFAULT_MASK_RSRVD0      0xFFFFFFF8

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_MCAST_DEFAULT_MASK_RSRVD0(v)   ((((reg32_t) v) << 3) & BM_ENET_SWI_MCAST_DEFAULT_MASK_RSRVD0)
#else
#define BF_ENET_SWI_MCAST_DEFAULT_MASK_RSRVD0(v)   (((v) << 3) & BM_ENET_SWI_MCAST_DEFAULT_MASK_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_MCAST_DEFAULT_MASK, field MCAST_DEFAULT_MASK_2 */

#define BP_ENET_SWI_MCAST_DEFAULT_MASK_MCAST_DEFAULT_MASK_2      2
#define BM_ENET_SWI_MCAST_DEFAULT_MASK_MCAST_DEFAULT_MASK_2      0x00000004

#define BF_ENET_SWI_MCAST_DEFAULT_MASK_MCAST_DEFAULT_MASK_2(v)   (((v) << 2) & BM_ENET_SWI_MCAST_DEFAULT_MASK_MCAST_DEFAULT_MASK_2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_MCAST_DEFAULT_MASK_MCAST_DEFAULT_MASK_2(v)   BF_CS1(ENET_SWI_MCAST_DEFAULT_MASK, MCAST_DEFAULT_MASK_2, v)
#endif

/* --- Register HW_ENET_SWI_MCAST_DEFAULT_MASK, field MCAST_DEFAULT_MASK_1 */

#define BP_ENET_SWI_MCAST_DEFAULT_MASK_MCAST_DEFAULT_MASK_1      1
#define BM_ENET_SWI_MCAST_DEFAULT_MASK_MCAST_DEFAULT_MASK_1      0x00000002

#define BF_ENET_SWI_MCAST_DEFAULT_MASK_MCAST_DEFAULT_MASK_1(v)   (((v) << 1) & BM_ENET_SWI_MCAST_DEFAULT_MASK_MCAST_DEFAULT_MASK_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_MCAST_DEFAULT_MASK_MCAST_DEFAULT_MASK_1(v)   BF_CS1(ENET_SWI_MCAST_DEFAULT_MASK, MCAST_DEFAULT_MASK_1, v)
#endif

/* --- Register HW_ENET_SWI_MCAST_DEFAULT_MASK, field MCAST_DEFAULT_MASK_0 */

#define BP_ENET_SWI_MCAST_DEFAULT_MASK_MCAST_DEFAULT_MASK_0      0
#define BM_ENET_SWI_MCAST_DEFAULT_MASK_MCAST_DEFAULT_MASK_0      0x00000001

#define BF_ENET_SWI_MCAST_DEFAULT_MASK_MCAST_DEFAULT_MASK_0(v)   (((v) << 0) & BM_ENET_SWI_MCAST_DEFAULT_MASK_MCAST_DEFAULT_MASK_0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_MCAST_DEFAULT_MASK_MCAST_DEFAULT_MASK_0(v)   BF_CS1(ENET_SWI_MCAST_DEFAULT_MASK, MCAST_DEFAULT_MASK_0, v)
#endif



/*
 * HW_ENET_SWI_INPUT_LEARN_BLOCK - ENET SWI Define port in blocking state and enable or disable learning.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BLOCKING_ENA_P0  :  1;
        unsigned BLOCKING_ENA_P1  :  1;
        unsigned BLOCKING_ENA_P2  :  1;
        unsigned RSRVD0           : 13;
        unsigned LEARNING_DI_P0   :  1;
        unsigned LEARNING_DI_P1   :  1;
        unsigned LEARNING_DIS_P2  :  1;
        unsigned RSRVD1           : 13;
    } B;
} hw_enet_swi_input_learn_block_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_INPUT_LEARN_BLOCK register
 */
#define HW_ENET_SWI_INPUT_LEARN_BLOCK_ADDR         (REGS_ENET_BASE + 0x801c)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_INPUT_LEARN_BLOCK           (*(volatile hw_enet_swi_input_learn_block_t *) HW_ENET_SWI_INPUT_LEARN_BLOCK_ADDR)
#define HW_ENET_SWI_INPUT_LEARN_BLOCK_RD()      (HW_ENET_SWI_INPUT_LEARN_BLOCK.U)
#define HW_ENET_SWI_INPUT_LEARN_BLOCK_WR(v)     (HW_ENET_SWI_INPUT_LEARN_BLOCK.U = (v))
#define HW_ENET_SWI_INPUT_LEARN_BLOCK_SET(v)    (HW_ENET_SWI_INPUT_LEARN_BLOCK_WR(HW_ENET_SWI_INPUT_LEARN_BLOCK_RD() |  (v)))
#define HW_ENET_SWI_INPUT_LEARN_BLOCK_CLR(v)    (HW_ENET_SWI_INPUT_LEARN_BLOCK_WR(HW_ENET_SWI_INPUT_LEARN_BLOCK_RD() & ~(v)))
#define HW_ENET_SWI_INPUT_LEARN_BLOCK_TOG(v)    (HW_ENET_SWI_INPUT_LEARN_BLOCK_WR(HW_ENET_SWI_INPUT_LEARN_BLOCK_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_INPUT_LEARN_BLOCK bitfields
 */
/* --- Register HW_ENET_SWI_INPUT_LEARN_BLOCK, field RSRVD1 */

#define BP_ENET_SWI_INPUT_LEARN_BLOCK_RSRVD1      19
#define BM_ENET_SWI_INPUT_LEARN_BLOCK_RSRVD1      0xFFF80000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_INPUT_LEARN_BLOCK_RSRVD1(v)   ((((reg32_t) v) << 19) & BM_ENET_SWI_INPUT_LEARN_BLOCK_RSRVD1)
#else
#define BF_ENET_SWI_INPUT_LEARN_BLOCK_RSRVD1(v)   (((v) << 19) & BM_ENET_SWI_INPUT_LEARN_BLOCK_RSRVD1)
#endif
/* --- Register HW_ENET_SWI_INPUT_LEARN_BLOCK, field LEARNING_DIS_P2 */

#define BP_ENET_SWI_INPUT_LEARN_BLOCK_LEARNING_DIS_P2      18
#define BM_ENET_SWI_INPUT_LEARN_BLOCK_LEARNING_DIS_P2      0x00040000

#define BF_ENET_SWI_INPUT_LEARN_BLOCK_LEARNING_DIS_P2(v)   (((v) << 18) & BM_ENET_SWI_INPUT_LEARN_BLOCK_LEARNING_DIS_P2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_INPUT_LEARN_BLOCK_LEARNING_DIS_P2(v)   BF_CS1(ENET_SWI_INPUT_LEARN_BLOCK, LEARNING_DIS_P2, v)
#endif

/* --- Register HW_ENET_SWI_INPUT_LEARN_BLOCK, field LEARNING_DI_P1 */

#define BP_ENET_SWI_INPUT_LEARN_BLOCK_LEARNING_DI_P1      17
#define BM_ENET_SWI_INPUT_LEARN_BLOCK_LEARNING_DI_P1      0x00020000

#define BF_ENET_SWI_INPUT_LEARN_BLOCK_LEARNING_DI_P1(v)   (((v) << 17) & BM_ENET_SWI_INPUT_LEARN_BLOCK_LEARNING_DI_P1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_INPUT_LEARN_BLOCK_LEARNING_DI_P1(v)   BF_CS1(ENET_SWI_INPUT_LEARN_BLOCK, LEARNING_DI_P1, v)
#endif

/* --- Register HW_ENET_SWI_INPUT_LEARN_BLOCK, field LEARNING_DI_P0 */

#define BP_ENET_SWI_INPUT_LEARN_BLOCK_LEARNING_DI_P0      16
#define BM_ENET_SWI_INPUT_LEARN_BLOCK_LEARNING_DI_P0      0x00010000

#define BF_ENET_SWI_INPUT_LEARN_BLOCK_LEARNING_DI_P0(v)   (((v) << 16) & BM_ENET_SWI_INPUT_LEARN_BLOCK_LEARNING_DI_P0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_INPUT_LEARN_BLOCK_LEARNING_DI_P0(v)   BF_CS1(ENET_SWI_INPUT_LEARN_BLOCK, LEARNING_DI_P0, v)
#endif

/* --- Register HW_ENET_SWI_INPUT_LEARN_BLOCK, field RSRVD0 */

#define BP_ENET_SWI_INPUT_LEARN_BLOCK_RSRVD0      3
#define BM_ENET_SWI_INPUT_LEARN_BLOCK_RSRVD0      0x0000FFF8

#define BF_ENET_SWI_INPUT_LEARN_BLOCK_RSRVD0(v)   (((v) << 3) & BM_ENET_SWI_INPUT_LEARN_BLOCK_RSRVD0)
/* --- Register HW_ENET_SWI_INPUT_LEARN_BLOCK, field BLOCKING_ENA_P2 */

#define BP_ENET_SWI_INPUT_LEARN_BLOCK_BLOCKING_ENA_P2      2
#define BM_ENET_SWI_INPUT_LEARN_BLOCK_BLOCKING_ENA_P2      0x00000004

#define BF_ENET_SWI_INPUT_LEARN_BLOCK_BLOCKING_ENA_P2(v)   (((v) << 2) & BM_ENET_SWI_INPUT_LEARN_BLOCK_BLOCKING_ENA_P2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_INPUT_LEARN_BLOCK_BLOCKING_ENA_P2(v)   BF_CS1(ENET_SWI_INPUT_LEARN_BLOCK, BLOCKING_ENA_P2, v)
#endif

/* --- Register HW_ENET_SWI_INPUT_LEARN_BLOCK, field BLOCKING_ENA_P1 */

#define BP_ENET_SWI_INPUT_LEARN_BLOCK_BLOCKING_ENA_P1      1
#define BM_ENET_SWI_INPUT_LEARN_BLOCK_BLOCKING_ENA_P1      0x00000002

#define BF_ENET_SWI_INPUT_LEARN_BLOCK_BLOCKING_ENA_P1(v)   (((v) << 1) & BM_ENET_SWI_INPUT_LEARN_BLOCK_BLOCKING_ENA_P1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_INPUT_LEARN_BLOCK_BLOCKING_ENA_P1(v)   BF_CS1(ENET_SWI_INPUT_LEARN_BLOCK, BLOCKING_ENA_P1, v)
#endif

/* --- Register HW_ENET_SWI_INPUT_LEARN_BLOCK, field BLOCKING_ENA_P0 */

#define BP_ENET_SWI_INPUT_LEARN_BLOCK_BLOCKING_ENA_P0      0
#define BM_ENET_SWI_INPUT_LEARN_BLOCK_BLOCKING_ENA_P0      0x00000001

#define BF_ENET_SWI_INPUT_LEARN_BLOCK_BLOCKING_ENA_P0(v)   (((v) << 0) & BM_ENET_SWI_INPUT_LEARN_BLOCK_BLOCKING_ENA_P0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_INPUT_LEARN_BLOCK_BLOCKING_ENA_P0(v)   BF_CS1(ENET_SWI_INPUT_LEARN_BLOCK, BLOCKING_ENA_P0, v)
#endif



/*
 * HW_ENET_SWI_MGMT_CONFIG - ENET SWI Bridge Management Port Configuration.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PORT                 :  4;
        unsigned RSRVD0               :  1;
        unsigned MESSAGE_TRANSMITTED  :  1;
        unsigned ENABLE               :  1;
        unsigned DISCARD              :  1;
        unsigned RSRVD1               :  5;
        unsigned PRIORITY             :  3;
        unsigned PORTMASK             :  3;
        unsigned RSRVD2               : 13;
    } B;
} hw_enet_swi_mgmt_config_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_MGMT_CONFIG register
 */
#define HW_ENET_SWI_MGMT_CONFIG_ADDR         (REGS_ENET_BASE + 0x8020)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_MGMT_CONFIG           (*(volatile hw_enet_swi_mgmt_config_t *) HW_ENET_SWI_MGMT_CONFIG_ADDR)
#define HW_ENET_SWI_MGMT_CONFIG_RD()      (HW_ENET_SWI_MGMT_CONFIG.U)
#define HW_ENET_SWI_MGMT_CONFIG_WR(v)     (HW_ENET_SWI_MGMT_CONFIG.U = (v))
#define HW_ENET_SWI_MGMT_CONFIG_SET(v)    (HW_ENET_SWI_MGMT_CONFIG_WR(HW_ENET_SWI_MGMT_CONFIG_RD() |  (v)))
#define HW_ENET_SWI_MGMT_CONFIG_CLR(v)    (HW_ENET_SWI_MGMT_CONFIG_WR(HW_ENET_SWI_MGMT_CONFIG_RD() & ~(v)))
#define HW_ENET_SWI_MGMT_CONFIG_TOG(v)    (HW_ENET_SWI_MGMT_CONFIG_WR(HW_ENET_SWI_MGMT_CONFIG_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_MGMT_CONFIG bitfields
 */
/* --- Register HW_ENET_SWI_MGMT_CONFIG, field RSRVD2 */

#define BP_ENET_SWI_MGMT_CONFIG_RSRVD2      19
#define BM_ENET_SWI_MGMT_CONFIG_RSRVD2      0xFFF80000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_MGMT_CONFIG_RSRVD2(v)   ((((reg32_t) v) << 19) & BM_ENET_SWI_MGMT_CONFIG_RSRVD2)
#else
#define BF_ENET_SWI_MGMT_CONFIG_RSRVD2(v)   (((v) << 19) & BM_ENET_SWI_MGMT_CONFIG_RSRVD2)
#endif
/* --- Register HW_ENET_SWI_MGMT_CONFIG, field PORTMASK */

#define BP_ENET_SWI_MGMT_CONFIG_PORTMASK      16
#define BM_ENET_SWI_MGMT_CONFIG_PORTMASK      0x00070000

#define BF_ENET_SWI_MGMT_CONFIG_PORTMASK(v)   (((v) << 16) & BM_ENET_SWI_MGMT_CONFIG_PORTMASK)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_MGMT_CONFIG_PORTMASK(v)   BF_CS1(ENET_SWI_MGMT_CONFIG, PORTMASK, v)
#endif

/* --- Register HW_ENET_SWI_MGMT_CONFIG, field PRIORITY */

#define BP_ENET_SWI_MGMT_CONFIG_PRIORITY      13
#define BM_ENET_SWI_MGMT_CONFIG_PRIORITY      0x0000E000

#define BF_ENET_SWI_MGMT_CONFIG_PRIORITY(v)   (((v) << 13) & BM_ENET_SWI_MGMT_CONFIG_PRIORITY)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_MGMT_CONFIG_PRIORITY(v)   BF_CS1(ENET_SWI_MGMT_CONFIG, PRIORITY, v)
#endif

/* --- Register HW_ENET_SWI_MGMT_CONFIG, field RSRVD1 */

#define BP_ENET_SWI_MGMT_CONFIG_RSRVD1      8
#define BM_ENET_SWI_MGMT_CONFIG_RSRVD1      0x00001F00

#define BF_ENET_SWI_MGMT_CONFIG_RSRVD1(v)   (((v) << 8) & BM_ENET_SWI_MGMT_CONFIG_RSRVD1)
/* --- Register HW_ENET_SWI_MGMT_CONFIG, field DISCARD */

#define BP_ENET_SWI_MGMT_CONFIG_DISCARD      7
#define BM_ENET_SWI_MGMT_CONFIG_DISCARD      0x00000080

#define BF_ENET_SWI_MGMT_CONFIG_DISCARD(v)   (((v) << 7) & BM_ENET_SWI_MGMT_CONFIG_DISCARD)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_MGMT_CONFIG_DISCARD(v)   BF_CS1(ENET_SWI_MGMT_CONFIG, DISCARD, v)
#endif

/* --- Register HW_ENET_SWI_MGMT_CONFIG, field ENABLE */

#define BP_ENET_SWI_MGMT_CONFIG_ENABLE      6
#define BM_ENET_SWI_MGMT_CONFIG_ENABLE      0x00000040

#define BF_ENET_SWI_MGMT_CONFIG_ENABLE(v)   (((v) << 6) & BM_ENET_SWI_MGMT_CONFIG_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_MGMT_CONFIG_ENABLE(v)   BF_CS1(ENET_SWI_MGMT_CONFIG, ENABLE, v)
#endif

/* --- Register HW_ENET_SWI_MGMT_CONFIG, field MESSAGE_TRANSMITTED */

#define BP_ENET_SWI_MGMT_CONFIG_MESSAGE_TRANSMITTED      5
#define BM_ENET_SWI_MGMT_CONFIG_MESSAGE_TRANSMITTED      0x00000020

#define BF_ENET_SWI_MGMT_CONFIG_MESSAGE_TRANSMITTED(v)   (((v) << 5) & BM_ENET_SWI_MGMT_CONFIG_MESSAGE_TRANSMITTED)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_MGMT_CONFIG_MESSAGE_TRANSMITTED(v)   BF_CS1(ENET_SWI_MGMT_CONFIG, MESSAGE_TRANSMITTED, v)
#endif

/* --- Register HW_ENET_SWI_MGMT_CONFIG, field RSRVD0 */

#define BP_ENET_SWI_MGMT_CONFIG_RSRVD0      4
#define BM_ENET_SWI_MGMT_CONFIG_RSRVD0      0x00000010

#define BF_ENET_SWI_MGMT_CONFIG_RSRVD0(v)   (((v) << 4) & BM_ENET_SWI_MGMT_CONFIG_RSRVD0)
/* --- Register HW_ENET_SWI_MGMT_CONFIG, field PORT */

#define BP_ENET_SWI_MGMT_CONFIG_PORT      0
#define BM_ENET_SWI_MGMT_CONFIG_PORT      0x0000000F

#define BF_ENET_SWI_MGMT_CONFIG_PORT(v)   (((v) << 0) & BM_ENET_SWI_MGMT_CONFIG_PORT)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_MGMT_CONFIG_PORT(v)   BF_CS1(ENET_SWI_MGMT_CONFIG, PORT, v)
#endif



/*
 * HW_ENET_SWI_MODE_CONFIG - ENET SWI Defines several global configuration settings.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned SWITCH_RESET       :  1;
        unsigned SWITCH_EN          :  1;
        unsigned RSRVD0             :  5;
        unsigned STOP_EN            :  1;
        unsigned CRC_TRANSPARENT    :  1;
        unsigned P0BUF_CUT_THROUGH  :  1;
        unsigned RSRVD1             : 21;
        unsigned STATSRESET         :  1;
    } B;
} hw_enet_swi_mode_config_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_MODE_CONFIG register
 */
#define HW_ENET_SWI_MODE_CONFIG_ADDR         (REGS_ENET_BASE + 0x8024)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_MODE_CONFIG           (*(volatile hw_enet_swi_mode_config_t *) HW_ENET_SWI_MODE_CONFIG_ADDR)
#define HW_ENET_SWI_MODE_CONFIG_RD()      (HW_ENET_SWI_MODE_CONFIG.U)
#define HW_ENET_SWI_MODE_CONFIG_WR(v)     (HW_ENET_SWI_MODE_CONFIG.U = (v))
#define HW_ENET_SWI_MODE_CONFIG_SET(v)    (HW_ENET_SWI_MODE_CONFIG_WR(HW_ENET_SWI_MODE_CONFIG_RD() |  (v)))
#define HW_ENET_SWI_MODE_CONFIG_CLR(v)    (HW_ENET_SWI_MODE_CONFIG_WR(HW_ENET_SWI_MODE_CONFIG_RD() & ~(v)))
#define HW_ENET_SWI_MODE_CONFIG_TOG(v)    (HW_ENET_SWI_MODE_CONFIG_WR(HW_ENET_SWI_MODE_CONFIG_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_MODE_CONFIG bitfields
 */
/* --- Register HW_ENET_SWI_MODE_CONFIG, field STATSRESET */

#define BP_ENET_SWI_MODE_CONFIG_STATSRESET      31
#define BM_ENET_SWI_MODE_CONFIG_STATSRESET      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_MODE_CONFIG_STATSRESET(v)   ((((reg32_t) v) << 31) & BM_ENET_SWI_MODE_CONFIG_STATSRESET)
#else
#define BF_ENET_SWI_MODE_CONFIG_STATSRESET(v)   (((v) << 31) & BM_ENET_SWI_MODE_CONFIG_STATSRESET)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_MODE_CONFIG_STATSRESET(v)   BF_CS1(ENET_SWI_MODE_CONFIG, STATSRESET, v)
#endif

/* --- Register HW_ENET_SWI_MODE_CONFIG, field RSRVD1 */

#define BP_ENET_SWI_MODE_CONFIG_RSRVD1      10
#define BM_ENET_SWI_MODE_CONFIG_RSRVD1      0x7FFFFC00

#define BF_ENET_SWI_MODE_CONFIG_RSRVD1(v)   (((v) << 10) & BM_ENET_SWI_MODE_CONFIG_RSRVD1)
/* --- Register HW_ENET_SWI_MODE_CONFIG, field P0BUF_CUT_THROUGH */

#define BP_ENET_SWI_MODE_CONFIG_P0BUF_CUT_THROUGH      9
#define BM_ENET_SWI_MODE_CONFIG_P0BUF_CUT_THROUGH      0x00000200

#define BF_ENET_SWI_MODE_CONFIG_P0BUF_CUT_THROUGH(v)   (((v) << 9) & BM_ENET_SWI_MODE_CONFIG_P0BUF_CUT_THROUGH)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_MODE_CONFIG_P0BUF_CUT_THROUGH(v)   BF_CS1(ENET_SWI_MODE_CONFIG, P0BUF_CUT_THROUGH, v)
#endif

/* --- Register HW_ENET_SWI_MODE_CONFIG, field CRC_TRANSPARENT */

#define BP_ENET_SWI_MODE_CONFIG_CRC_TRANSPARENT      8
#define BM_ENET_SWI_MODE_CONFIG_CRC_TRANSPARENT      0x00000100

#define BF_ENET_SWI_MODE_CONFIG_CRC_TRANSPARENT(v)   (((v) << 8) & BM_ENET_SWI_MODE_CONFIG_CRC_TRANSPARENT)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_MODE_CONFIG_CRC_TRANSPARENT(v)   BF_CS1(ENET_SWI_MODE_CONFIG, CRC_TRANSPARENT, v)
#endif

/* --- Register HW_ENET_SWI_MODE_CONFIG, field STOP_EN */

#define BP_ENET_SWI_MODE_CONFIG_STOP_EN      7
#define BM_ENET_SWI_MODE_CONFIG_STOP_EN      0x00000080

#define BF_ENET_SWI_MODE_CONFIG_STOP_EN(v)   (((v) << 7) & BM_ENET_SWI_MODE_CONFIG_STOP_EN)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_MODE_CONFIG_STOP_EN(v)   BF_CS1(ENET_SWI_MODE_CONFIG, STOP_EN, v)
#endif

/* --- Register HW_ENET_SWI_MODE_CONFIG, field RSRVD0 */

#define BP_ENET_SWI_MODE_CONFIG_RSRVD0      2
#define BM_ENET_SWI_MODE_CONFIG_RSRVD0      0x0000007C

#define BF_ENET_SWI_MODE_CONFIG_RSRVD0(v)   (((v) << 2) & BM_ENET_SWI_MODE_CONFIG_RSRVD0)
/* --- Register HW_ENET_SWI_MODE_CONFIG, field SWITCH_EN */

#define BP_ENET_SWI_MODE_CONFIG_SWITCH_EN      1
#define BM_ENET_SWI_MODE_CONFIG_SWITCH_EN      0x00000002

#define BF_ENET_SWI_MODE_CONFIG_SWITCH_EN(v)   (((v) << 1) & BM_ENET_SWI_MODE_CONFIG_SWITCH_EN)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_MODE_CONFIG_SWITCH_EN(v)   BF_CS1(ENET_SWI_MODE_CONFIG, SWITCH_EN, v)
#endif

/* --- Register HW_ENET_SWI_MODE_CONFIG, field SWITCH_RESET */

#define BP_ENET_SWI_MODE_CONFIG_SWITCH_RESET      0
#define BM_ENET_SWI_MODE_CONFIG_SWITCH_RESET      0x00000001

#define BF_ENET_SWI_MODE_CONFIG_SWITCH_RESET(v)   (((v) << 0) & BM_ENET_SWI_MODE_CONFIG_SWITCH_RESET)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_MODE_CONFIG_SWITCH_RESET(v)   BF_CS1(ENET_SWI_MODE_CONFIG, SWITCH_RESET, v)
#endif



/*
 * HW_ENET_SWI_VLAN_IN_MODE - ENET SWI Define behavior of VLAN input manipulation function
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned VLAN_IN_MODE_0  :  2;
        unsigned VLAN_IN_MODE_1  :  2;
        unsigned VLAN_IN_MODE_2  :  2;
        unsigned RSRVD0          : 26;
    } B;
} hw_enet_swi_vlan_in_mode_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_VLAN_IN_MODE register
 */
#define HW_ENET_SWI_VLAN_IN_MODE_ADDR         (REGS_ENET_BASE + 0x8028)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_VLAN_IN_MODE           (*(volatile hw_enet_swi_vlan_in_mode_t *) HW_ENET_SWI_VLAN_IN_MODE_ADDR)
#define HW_ENET_SWI_VLAN_IN_MODE_RD()      (HW_ENET_SWI_VLAN_IN_MODE.U)
#define HW_ENET_SWI_VLAN_IN_MODE_WR(v)     (HW_ENET_SWI_VLAN_IN_MODE.U = (v))
#define HW_ENET_SWI_VLAN_IN_MODE_SET(v)    (HW_ENET_SWI_VLAN_IN_MODE_WR(HW_ENET_SWI_VLAN_IN_MODE_RD() |  (v)))
#define HW_ENET_SWI_VLAN_IN_MODE_CLR(v)    (HW_ENET_SWI_VLAN_IN_MODE_WR(HW_ENET_SWI_VLAN_IN_MODE_RD() & ~(v)))
#define HW_ENET_SWI_VLAN_IN_MODE_TOG(v)    (HW_ENET_SWI_VLAN_IN_MODE_WR(HW_ENET_SWI_VLAN_IN_MODE_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_VLAN_IN_MODE bitfields
 */
/* --- Register HW_ENET_SWI_VLAN_IN_MODE, field RSRVD0 */

#define BP_ENET_SWI_VLAN_IN_MODE_RSRVD0      6
#define BM_ENET_SWI_VLAN_IN_MODE_RSRVD0      0xFFFFFFC0

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_VLAN_IN_MODE_RSRVD0(v)   ((((reg32_t) v) << 6) & BM_ENET_SWI_VLAN_IN_MODE_RSRVD0)
#else
#define BF_ENET_SWI_VLAN_IN_MODE_RSRVD0(v)   (((v) << 6) & BM_ENET_SWI_VLAN_IN_MODE_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_VLAN_IN_MODE, field VLAN_IN_MODE_2 */

#define BP_ENET_SWI_VLAN_IN_MODE_VLAN_IN_MODE_2      4
#define BM_ENET_SWI_VLAN_IN_MODE_VLAN_IN_MODE_2      0x00000030

#define BF_ENET_SWI_VLAN_IN_MODE_VLAN_IN_MODE_2(v)   (((v) << 4) & BM_ENET_SWI_VLAN_IN_MODE_VLAN_IN_MODE_2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_IN_MODE_VLAN_IN_MODE_2(v)   BF_CS1(ENET_SWI_VLAN_IN_MODE, VLAN_IN_MODE_2, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_IN_MODE, field VLAN_IN_MODE_1 */

#define BP_ENET_SWI_VLAN_IN_MODE_VLAN_IN_MODE_1      2
#define BM_ENET_SWI_VLAN_IN_MODE_VLAN_IN_MODE_1      0x0000000C

#define BF_ENET_SWI_VLAN_IN_MODE_VLAN_IN_MODE_1(v)   (((v) << 2) & BM_ENET_SWI_VLAN_IN_MODE_VLAN_IN_MODE_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_IN_MODE_VLAN_IN_MODE_1(v)   BF_CS1(ENET_SWI_VLAN_IN_MODE, VLAN_IN_MODE_1, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_IN_MODE, field VLAN_IN_MODE_0 */

#define BP_ENET_SWI_VLAN_IN_MODE_VLAN_IN_MODE_0      0
#define BM_ENET_SWI_VLAN_IN_MODE_VLAN_IN_MODE_0      0x00000003

#define BF_ENET_SWI_VLAN_IN_MODE_VLAN_IN_MODE_0(v)   (((v) << 0) & BM_ENET_SWI_VLAN_IN_MODE_VLAN_IN_MODE_0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_IN_MODE_VLAN_IN_MODE_0(v)   BF_CS1(ENET_SWI_VLAN_IN_MODE, VLAN_IN_MODE_0, v)
#endif



/*
 * HW_ENET_SWI_VLAN_OUT_MODE - ENET SWI Define behavior of VLAN output manipulation function
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned VLAN_OUT_MODE_0  :  2;
        unsigned VLAN_OUT_MODE_1  :  2;
        unsigned VLAN_OUT_MODE_2  :  2;
        unsigned RSRVD0           : 26;
    } B;
} hw_enet_swi_vlan_out_mode_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_VLAN_OUT_MODE register
 */
#define HW_ENET_SWI_VLAN_OUT_MODE_ADDR         (REGS_ENET_BASE + 0x802c)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_VLAN_OUT_MODE           (*(volatile hw_enet_swi_vlan_out_mode_t *) HW_ENET_SWI_VLAN_OUT_MODE_ADDR)
#define HW_ENET_SWI_VLAN_OUT_MODE_RD()      (HW_ENET_SWI_VLAN_OUT_MODE.U)
#define HW_ENET_SWI_VLAN_OUT_MODE_WR(v)     (HW_ENET_SWI_VLAN_OUT_MODE.U = (v))
#define HW_ENET_SWI_VLAN_OUT_MODE_SET(v)    (HW_ENET_SWI_VLAN_OUT_MODE_WR(HW_ENET_SWI_VLAN_OUT_MODE_RD() |  (v)))
#define HW_ENET_SWI_VLAN_OUT_MODE_CLR(v)    (HW_ENET_SWI_VLAN_OUT_MODE_WR(HW_ENET_SWI_VLAN_OUT_MODE_RD() & ~(v)))
#define HW_ENET_SWI_VLAN_OUT_MODE_TOG(v)    (HW_ENET_SWI_VLAN_OUT_MODE_WR(HW_ENET_SWI_VLAN_OUT_MODE_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_VLAN_OUT_MODE bitfields
 */
/* --- Register HW_ENET_SWI_VLAN_OUT_MODE, field RSRVD0 */

#define BP_ENET_SWI_VLAN_OUT_MODE_RSRVD0      6
#define BM_ENET_SWI_VLAN_OUT_MODE_RSRVD0      0xFFFFFFC0

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_VLAN_OUT_MODE_RSRVD0(v)   ((((reg32_t) v) << 6) & BM_ENET_SWI_VLAN_OUT_MODE_RSRVD0)
#else
#define BF_ENET_SWI_VLAN_OUT_MODE_RSRVD0(v)   (((v) << 6) & BM_ENET_SWI_VLAN_OUT_MODE_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_VLAN_OUT_MODE, field VLAN_OUT_MODE_2 */

#define BP_ENET_SWI_VLAN_OUT_MODE_VLAN_OUT_MODE_2      4
#define BM_ENET_SWI_VLAN_OUT_MODE_VLAN_OUT_MODE_2      0x00000030

#define BF_ENET_SWI_VLAN_OUT_MODE_VLAN_OUT_MODE_2(v)   (((v) << 4) & BM_ENET_SWI_VLAN_OUT_MODE_VLAN_OUT_MODE_2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_OUT_MODE_VLAN_OUT_MODE_2(v)   BF_CS1(ENET_SWI_VLAN_OUT_MODE, VLAN_OUT_MODE_2, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_OUT_MODE, field VLAN_OUT_MODE_1 */

#define BP_ENET_SWI_VLAN_OUT_MODE_VLAN_OUT_MODE_1      2
#define BM_ENET_SWI_VLAN_OUT_MODE_VLAN_OUT_MODE_1      0x0000000C

#define BF_ENET_SWI_VLAN_OUT_MODE_VLAN_OUT_MODE_1(v)   (((v) << 2) & BM_ENET_SWI_VLAN_OUT_MODE_VLAN_OUT_MODE_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_OUT_MODE_VLAN_OUT_MODE_1(v)   BF_CS1(ENET_SWI_VLAN_OUT_MODE, VLAN_OUT_MODE_1, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_OUT_MODE, field VLAN_OUT_MODE_0 */

#define BP_ENET_SWI_VLAN_OUT_MODE_VLAN_OUT_MODE_0      0
#define BM_ENET_SWI_VLAN_OUT_MODE_VLAN_OUT_MODE_0      0x00000003

#define BF_ENET_SWI_VLAN_OUT_MODE_VLAN_OUT_MODE_0(v)   (((v) << 0) & BM_ENET_SWI_VLAN_OUT_MODE_VLAN_OUT_MODE_0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_OUT_MODE_VLAN_OUT_MODE_0(v)   BF_CS1(ENET_SWI_VLAN_OUT_MODE, VLAN_OUT_MODE_0, v)
#endif



/*
 * HW_ENET_SWI_VLAN_IN_MODE_ENA - ENET SWI Enable the input processing according to the VLAN_IN_MODE for a port
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned VLAN_IN_MODE_ENA_0  :  1;
        unsigned VLAN_IN_MODE_ENA_1  :  1;
        unsigned VLAN_IN_MODE_ENA_2  :  1;
        unsigned RSRVD0              : 29;
    } B;
} hw_enet_swi_vlan_in_mode_ena_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_VLAN_IN_MODE_ENA register
 */
#define HW_ENET_SWI_VLAN_IN_MODE_ENA_ADDR         (REGS_ENET_BASE + 0x8030)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_VLAN_IN_MODE_ENA           (*(volatile hw_enet_swi_vlan_in_mode_ena_t *) HW_ENET_SWI_VLAN_IN_MODE_ENA_ADDR)
#define HW_ENET_SWI_VLAN_IN_MODE_ENA_RD()      (HW_ENET_SWI_VLAN_IN_MODE_ENA.U)
#define HW_ENET_SWI_VLAN_IN_MODE_ENA_WR(v)     (HW_ENET_SWI_VLAN_IN_MODE_ENA.U = (v))
#define HW_ENET_SWI_VLAN_IN_MODE_ENA_SET(v)    (HW_ENET_SWI_VLAN_IN_MODE_ENA_WR(HW_ENET_SWI_VLAN_IN_MODE_ENA_RD() |  (v)))
#define HW_ENET_SWI_VLAN_IN_MODE_ENA_CLR(v)    (HW_ENET_SWI_VLAN_IN_MODE_ENA_WR(HW_ENET_SWI_VLAN_IN_MODE_ENA_RD() & ~(v)))
#define HW_ENET_SWI_VLAN_IN_MODE_ENA_TOG(v)    (HW_ENET_SWI_VLAN_IN_MODE_ENA_WR(HW_ENET_SWI_VLAN_IN_MODE_ENA_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_VLAN_IN_MODE_ENA bitfields
 */
/* --- Register HW_ENET_SWI_VLAN_IN_MODE_ENA, field RSRVD0 */

#define BP_ENET_SWI_VLAN_IN_MODE_ENA_RSRVD0      3
#define BM_ENET_SWI_VLAN_IN_MODE_ENA_RSRVD0      0xFFFFFFF8

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_VLAN_IN_MODE_ENA_RSRVD0(v)   ((((reg32_t) v) << 3) & BM_ENET_SWI_VLAN_IN_MODE_ENA_RSRVD0)
#else
#define BF_ENET_SWI_VLAN_IN_MODE_ENA_RSRVD0(v)   (((v) << 3) & BM_ENET_SWI_VLAN_IN_MODE_ENA_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_VLAN_IN_MODE_ENA, field VLAN_IN_MODE_ENA_2 */

#define BP_ENET_SWI_VLAN_IN_MODE_ENA_VLAN_IN_MODE_ENA_2      2
#define BM_ENET_SWI_VLAN_IN_MODE_ENA_VLAN_IN_MODE_ENA_2      0x00000004

#define BF_ENET_SWI_VLAN_IN_MODE_ENA_VLAN_IN_MODE_ENA_2(v)   (((v) << 2) & BM_ENET_SWI_VLAN_IN_MODE_ENA_VLAN_IN_MODE_ENA_2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_IN_MODE_ENA_VLAN_IN_MODE_ENA_2(v)   BF_CS1(ENET_SWI_VLAN_IN_MODE_ENA, VLAN_IN_MODE_ENA_2, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_IN_MODE_ENA, field VLAN_IN_MODE_ENA_1 */

#define BP_ENET_SWI_VLAN_IN_MODE_ENA_VLAN_IN_MODE_ENA_1      1
#define BM_ENET_SWI_VLAN_IN_MODE_ENA_VLAN_IN_MODE_ENA_1      0x00000002

#define BF_ENET_SWI_VLAN_IN_MODE_ENA_VLAN_IN_MODE_ENA_1(v)   (((v) << 1) & BM_ENET_SWI_VLAN_IN_MODE_ENA_VLAN_IN_MODE_ENA_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_IN_MODE_ENA_VLAN_IN_MODE_ENA_1(v)   BF_CS1(ENET_SWI_VLAN_IN_MODE_ENA, VLAN_IN_MODE_ENA_1, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_IN_MODE_ENA, field VLAN_IN_MODE_ENA_0 */

#define BP_ENET_SWI_VLAN_IN_MODE_ENA_VLAN_IN_MODE_ENA_0      0
#define BM_ENET_SWI_VLAN_IN_MODE_ENA_VLAN_IN_MODE_ENA_0      0x00000001

#define BF_ENET_SWI_VLAN_IN_MODE_ENA_VLAN_IN_MODE_ENA_0(v)   (((v) << 0) & BM_ENET_SWI_VLAN_IN_MODE_ENA_VLAN_IN_MODE_ENA_0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_IN_MODE_ENA_VLAN_IN_MODE_ENA_0(v)   BF_CS1(ENET_SWI_VLAN_IN_MODE_ENA, VLAN_IN_MODE_ENA_0, v)
#endif



/*
 * HW_ENET_SWI_VLAN_TAG_ID - ENET SWI The VLAN type field value to expect to identify a VLAN tagged frame.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned SWI_VLAN_TAG_ID  : 16;
        unsigned RSRVD0           : 16;
    } B;
} hw_enet_swi_vlan_tag_id_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_VLAN_TAG_ID register
 */
#define HW_ENET_SWI_VLAN_TAG_ID_ADDR         (REGS_ENET_BASE + 0x8034)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_VLAN_TAG_ID           (*(volatile hw_enet_swi_vlan_tag_id_t *) HW_ENET_SWI_VLAN_TAG_ID_ADDR)
#define HW_ENET_SWI_VLAN_TAG_ID_RD()      (HW_ENET_SWI_VLAN_TAG_ID.U)
#define HW_ENET_SWI_VLAN_TAG_ID_WR(v)     (HW_ENET_SWI_VLAN_TAG_ID.U = (v))
#define HW_ENET_SWI_VLAN_TAG_ID_SET(v)    (HW_ENET_SWI_VLAN_TAG_ID_WR(HW_ENET_SWI_VLAN_TAG_ID_RD() |  (v)))
#define HW_ENET_SWI_VLAN_TAG_ID_CLR(v)    (HW_ENET_SWI_VLAN_TAG_ID_WR(HW_ENET_SWI_VLAN_TAG_ID_RD() & ~(v)))
#define HW_ENET_SWI_VLAN_TAG_ID_TOG(v)    (HW_ENET_SWI_VLAN_TAG_ID_WR(HW_ENET_SWI_VLAN_TAG_ID_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_VLAN_TAG_ID bitfields
 */
/* --- Register HW_ENET_SWI_VLAN_TAG_ID, field RSRVD0 */

#define BP_ENET_SWI_VLAN_TAG_ID_RSRVD0      16
#define BM_ENET_SWI_VLAN_TAG_ID_RSRVD0      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_VLAN_TAG_ID_RSRVD0(v)   ((((reg32_t) v) << 16) & BM_ENET_SWI_VLAN_TAG_ID_RSRVD0)
#else
#define BF_ENET_SWI_VLAN_TAG_ID_RSRVD0(v)   (((v) << 16) & BM_ENET_SWI_VLAN_TAG_ID_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_VLAN_TAG_ID, field SWI_VLAN_TAG_ID */

#define BP_ENET_SWI_VLAN_TAG_ID_SWI_VLAN_TAG_ID      0
#define BM_ENET_SWI_VLAN_TAG_ID_SWI_VLAN_TAG_ID      0x0000FFFF

#define BF_ENET_SWI_VLAN_TAG_ID_SWI_VLAN_TAG_ID(v)   (((v) << 0) & BM_ENET_SWI_VLAN_TAG_ID_SWI_VLAN_TAG_ID)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_TAG_ID_SWI_VLAN_TAG_ID(v)   (HW_ENET_SWI_VLAN_TAG_ID.B.SWI_VLAN_TAG_ID = (v))
#endif



/*
 * HW_ENET_SWI_MIRROR_CONTROL - ENET SWI Port Mirroring configuration.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PORTX           :  4;
        unsigned MIRROR_ENABLE   :  1;
        unsigned ING_MAP_ENABLE  :  1;
        unsigned EG_MAP_ENABLE   :  1;
        unsigned ING_SA_MATCH    :  1;
        unsigned ING_DA_MATCH    :  1;
        unsigned EG_SA_MATCH     :  1;
        unsigned EG_DA_MATCH     :  1;
        unsigned RSRVD0          : 21;
    } B;
} hw_enet_swi_mirror_control_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_MIRROR_CONTROL register
 */
#define HW_ENET_SWI_MIRROR_CONTROL_ADDR         (REGS_ENET_BASE + 0x8040)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_MIRROR_CONTROL           (*(volatile hw_enet_swi_mirror_control_t *) HW_ENET_SWI_MIRROR_CONTROL_ADDR)
#define HW_ENET_SWI_MIRROR_CONTROL_RD()      (HW_ENET_SWI_MIRROR_CONTROL.U)
#define HW_ENET_SWI_MIRROR_CONTROL_WR(v)     (HW_ENET_SWI_MIRROR_CONTROL.U = (v))
#define HW_ENET_SWI_MIRROR_CONTROL_SET(v)    (HW_ENET_SWI_MIRROR_CONTROL_WR(HW_ENET_SWI_MIRROR_CONTROL_RD() |  (v)))
#define HW_ENET_SWI_MIRROR_CONTROL_CLR(v)    (HW_ENET_SWI_MIRROR_CONTROL_WR(HW_ENET_SWI_MIRROR_CONTROL_RD() & ~(v)))
#define HW_ENET_SWI_MIRROR_CONTROL_TOG(v)    (HW_ENET_SWI_MIRROR_CONTROL_WR(HW_ENET_SWI_MIRROR_CONTROL_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_MIRROR_CONTROL bitfields
 */
/* --- Register HW_ENET_SWI_MIRROR_CONTROL, field RSRVD0 */

#define BP_ENET_SWI_MIRROR_CONTROL_RSRVD0      11
#define BM_ENET_SWI_MIRROR_CONTROL_RSRVD0      0xFFFFF800

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_MIRROR_CONTROL_RSRVD0(v)   ((((reg32_t) v) << 11) & BM_ENET_SWI_MIRROR_CONTROL_RSRVD0)
#else
#define BF_ENET_SWI_MIRROR_CONTROL_RSRVD0(v)   (((v) << 11) & BM_ENET_SWI_MIRROR_CONTROL_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_MIRROR_CONTROL, field EG_DA_MATCH */

#define BP_ENET_SWI_MIRROR_CONTROL_EG_DA_MATCH      10
#define BM_ENET_SWI_MIRROR_CONTROL_EG_DA_MATCH      0x00000400

#define BF_ENET_SWI_MIRROR_CONTROL_EG_DA_MATCH(v)   (((v) << 10) & BM_ENET_SWI_MIRROR_CONTROL_EG_DA_MATCH)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_MIRROR_CONTROL_EG_DA_MATCH(v)   BF_CS1(ENET_SWI_MIRROR_CONTROL, EG_DA_MATCH, v)
#endif

/* --- Register HW_ENET_SWI_MIRROR_CONTROL, field EG_SA_MATCH */

#define BP_ENET_SWI_MIRROR_CONTROL_EG_SA_MATCH      9
#define BM_ENET_SWI_MIRROR_CONTROL_EG_SA_MATCH      0x00000200

#define BF_ENET_SWI_MIRROR_CONTROL_EG_SA_MATCH(v)   (((v) << 9) & BM_ENET_SWI_MIRROR_CONTROL_EG_SA_MATCH)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_MIRROR_CONTROL_EG_SA_MATCH(v)   BF_CS1(ENET_SWI_MIRROR_CONTROL, EG_SA_MATCH, v)
#endif

/* --- Register HW_ENET_SWI_MIRROR_CONTROL, field ING_DA_MATCH */

#define BP_ENET_SWI_MIRROR_CONTROL_ING_DA_MATCH      8
#define BM_ENET_SWI_MIRROR_CONTROL_ING_DA_MATCH      0x00000100

#define BF_ENET_SWI_MIRROR_CONTROL_ING_DA_MATCH(v)   (((v) << 8) & BM_ENET_SWI_MIRROR_CONTROL_ING_DA_MATCH)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_MIRROR_CONTROL_ING_DA_MATCH(v)   BF_CS1(ENET_SWI_MIRROR_CONTROL, ING_DA_MATCH, v)
#endif

/* --- Register HW_ENET_SWI_MIRROR_CONTROL, field ING_SA_MATCH */

#define BP_ENET_SWI_MIRROR_CONTROL_ING_SA_MATCH      7
#define BM_ENET_SWI_MIRROR_CONTROL_ING_SA_MATCH      0x00000080

#define BF_ENET_SWI_MIRROR_CONTROL_ING_SA_MATCH(v)   (((v) << 7) & BM_ENET_SWI_MIRROR_CONTROL_ING_SA_MATCH)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_MIRROR_CONTROL_ING_SA_MATCH(v)   BF_CS1(ENET_SWI_MIRROR_CONTROL, ING_SA_MATCH, v)
#endif

/* --- Register HW_ENET_SWI_MIRROR_CONTROL, field EG_MAP_ENABLE */

#define BP_ENET_SWI_MIRROR_CONTROL_EG_MAP_ENABLE      6
#define BM_ENET_SWI_MIRROR_CONTROL_EG_MAP_ENABLE      0x00000040

#define BF_ENET_SWI_MIRROR_CONTROL_EG_MAP_ENABLE(v)   (((v) << 6) & BM_ENET_SWI_MIRROR_CONTROL_EG_MAP_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_MIRROR_CONTROL_EG_MAP_ENABLE(v)   BF_CS1(ENET_SWI_MIRROR_CONTROL, EG_MAP_ENABLE, v)
#endif

/* --- Register HW_ENET_SWI_MIRROR_CONTROL, field ING_MAP_ENABLE */

#define BP_ENET_SWI_MIRROR_CONTROL_ING_MAP_ENABLE      5
#define BM_ENET_SWI_MIRROR_CONTROL_ING_MAP_ENABLE      0x00000020

#define BF_ENET_SWI_MIRROR_CONTROL_ING_MAP_ENABLE(v)   (((v) << 5) & BM_ENET_SWI_MIRROR_CONTROL_ING_MAP_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_MIRROR_CONTROL_ING_MAP_ENABLE(v)   BF_CS1(ENET_SWI_MIRROR_CONTROL, ING_MAP_ENABLE, v)
#endif

/* --- Register HW_ENET_SWI_MIRROR_CONTROL, field MIRROR_ENABLE */

#define BP_ENET_SWI_MIRROR_CONTROL_MIRROR_ENABLE      4
#define BM_ENET_SWI_MIRROR_CONTROL_MIRROR_ENABLE      0x00000010

#define BF_ENET_SWI_MIRROR_CONTROL_MIRROR_ENABLE(v)   (((v) << 4) & BM_ENET_SWI_MIRROR_CONTROL_MIRROR_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_MIRROR_CONTROL_MIRROR_ENABLE(v)   BF_CS1(ENET_SWI_MIRROR_CONTROL, MIRROR_ENABLE, v)
#endif

/* --- Register HW_ENET_SWI_MIRROR_CONTROL, field PORTX */

#define BP_ENET_SWI_MIRROR_CONTROL_PORTX      0
#define BM_ENET_SWI_MIRROR_CONTROL_PORTX      0x0000000F

#define BF_ENET_SWI_MIRROR_CONTROL_PORTX(v)   (((v) << 0) & BM_ENET_SWI_MIRROR_CONTROL_PORTX)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_MIRROR_CONTROL_PORTX(v)   BF_CS1(ENET_SWI_MIRROR_CONTROL, PORTX, v)
#endif



/*
 * HW_ENET_SWI_MIRROR_EG_MAP - ENET SWI Port Mirroring Egress port definitions.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned MIRROR_EG_MAP_0  :  1;
        unsigned MIRROR_EG_MAP_1  :  1;
        unsigned MIRROR_EG_MAP_2  :  1;
        unsigned RSRVD0           : 29;
    } B;
} hw_enet_swi_mirror_eg_map_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_MIRROR_EG_MAP register
 */
#define HW_ENET_SWI_MIRROR_EG_MAP_ADDR         (REGS_ENET_BASE + 0x8044)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_MIRROR_EG_MAP           (*(volatile hw_enet_swi_mirror_eg_map_t *) HW_ENET_SWI_MIRROR_EG_MAP_ADDR)
#define HW_ENET_SWI_MIRROR_EG_MAP_RD()      (HW_ENET_SWI_MIRROR_EG_MAP.U)
#define HW_ENET_SWI_MIRROR_EG_MAP_WR(v)     (HW_ENET_SWI_MIRROR_EG_MAP.U = (v))
#define HW_ENET_SWI_MIRROR_EG_MAP_SET(v)    (HW_ENET_SWI_MIRROR_EG_MAP_WR(HW_ENET_SWI_MIRROR_EG_MAP_RD() |  (v)))
#define HW_ENET_SWI_MIRROR_EG_MAP_CLR(v)    (HW_ENET_SWI_MIRROR_EG_MAP_WR(HW_ENET_SWI_MIRROR_EG_MAP_RD() & ~(v)))
#define HW_ENET_SWI_MIRROR_EG_MAP_TOG(v)    (HW_ENET_SWI_MIRROR_EG_MAP_WR(HW_ENET_SWI_MIRROR_EG_MAP_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_MIRROR_EG_MAP bitfields
 */
/* --- Register HW_ENET_SWI_MIRROR_EG_MAP, field RSRVD0 */

#define BP_ENET_SWI_MIRROR_EG_MAP_RSRVD0      3
#define BM_ENET_SWI_MIRROR_EG_MAP_RSRVD0      0xFFFFFFF8

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_MIRROR_EG_MAP_RSRVD0(v)   ((((reg32_t) v) << 3) & BM_ENET_SWI_MIRROR_EG_MAP_RSRVD0)
#else
#define BF_ENET_SWI_MIRROR_EG_MAP_RSRVD0(v)   (((v) << 3) & BM_ENET_SWI_MIRROR_EG_MAP_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_MIRROR_EG_MAP, field MIRROR_EG_MAP_2 */

#define BP_ENET_SWI_MIRROR_EG_MAP_MIRROR_EG_MAP_2      2
#define BM_ENET_SWI_MIRROR_EG_MAP_MIRROR_EG_MAP_2      0x00000004

#define BF_ENET_SWI_MIRROR_EG_MAP_MIRROR_EG_MAP_2(v)   (((v) << 2) & BM_ENET_SWI_MIRROR_EG_MAP_MIRROR_EG_MAP_2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_MIRROR_EG_MAP_MIRROR_EG_MAP_2(v)   BF_CS1(ENET_SWI_MIRROR_EG_MAP, MIRROR_EG_MAP_2, v)
#endif

/* --- Register HW_ENET_SWI_MIRROR_EG_MAP, field MIRROR_EG_MAP_1 */

#define BP_ENET_SWI_MIRROR_EG_MAP_MIRROR_EG_MAP_1      1
#define BM_ENET_SWI_MIRROR_EG_MAP_MIRROR_EG_MAP_1      0x00000002

#define BF_ENET_SWI_MIRROR_EG_MAP_MIRROR_EG_MAP_1(v)   (((v) << 1) & BM_ENET_SWI_MIRROR_EG_MAP_MIRROR_EG_MAP_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_MIRROR_EG_MAP_MIRROR_EG_MAP_1(v)   BF_CS1(ENET_SWI_MIRROR_EG_MAP, MIRROR_EG_MAP_1, v)
#endif

/* --- Register HW_ENET_SWI_MIRROR_EG_MAP, field MIRROR_EG_MAP_0 */

#define BP_ENET_SWI_MIRROR_EG_MAP_MIRROR_EG_MAP_0      0
#define BM_ENET_SWI_MIRROR_EG_MAP_MIRROR_EG_MAP_0      0x00000001

#define BF_ENET_SWI_MIRROR_EG_MAP_MIRROR_EG_MAP_0(v)   (((v) << 0) & BM_ENET_SWI_MIRROR_EG_MAP_MIRROR_EG_MAP_0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_MIRROR_EG_MAP_MIRROR_EG_MAP_0(v)   BF_CS1(ENET_SWI_MIRROR_EG_MAP, MIRROR_EG_MAP_0, v)
#endif



/*
 * HW_ENET_SWI_MIRROR_ING_MAP - ENET SWI Port Mirroring Ingress port definitions.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned MIRROR_ING_MAP_0  :  1;
        unsigned MIRROR_ING_MAP_1  :  1;
        unsigned MIRROR_ING_MAP_2  :  1;
        unsigned RSRVD0            : 29;
    } B;
} hw_enet_swi_mirror_ing_map_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_MIRROR_ING_MAP register
 */
#define HW_ENET_SWI_MIRROR_ING_MAP_ADDR         (REGS_ENET_BASE + 0x8048)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_MIRROR_ING_MAP           (*(volatile hw_enet_swi_mirror_ing_map_t *) HW_ENET_SWI_MIRROR_ING_MAP_ADDR)
#define HW_ENET_SWI_MIRROR_ING_MAP_RD()      (HW_ENET_SWI_MIRROR_ING_MAP.U)
#define HW_ENET_SWI_MIRROR_ING_MAP_WR(v)     (HW_ENET_SWI_MIRROR_ING_MAP.U = (v))
#define HW_ENET_SWI_MIRROR_ING_MAP_SET(v)    (HW_ENET_SWI_MIRROR_ING_MAP_WR(HW_ENET_SWI_MIRROR_ING_MAP_RD() |  (v)))
#define HW_ENET_SWI_MIRROR_ING_MAP_CLR(v)    (HW_ENET_SWI_MIRROR_ING_MAP_WR(HW_ENET_SWI_MIRROR_ING_MAP_RD() & ~(v)))
#define HW_ENET_SWI_MIRROR_ING_MAP_TOG(v)    (HW_ENET_SWI_MIRROR_ING_MAP_WR(HW_ENET_SWI_MIRROR_ING_MAP_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_MIRROR_ING_MAP bitfields
 */
/* --- Register HW_ENET_SWI_MIRROR_ING_MAP, field RSRVD0 */

#define BP_ENET_SWI_MIRROR_ING_MAP_RSRVD0      3
#define BM_ENET_SWI_MIRROR_ING_MAP_RSRVD0      0xFFFFFFF8

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_MIRROR_ING_MAP_RSRVD0(v)   ((((reg32_t) v) << 3) & BM_ENET_SWI_MIRROR_ING_MAP_RSRVD0)
#else
#define BF_ENET_SWI_MIRROR_ING_MAP_RSRVD0(v)   (((v) << 3) & BM_ENET_SWI_MIRROR_ING_MAP_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_MIRROR_ING_MAP, field MIRROR_ING_MAP_2 */

#define BP_ENET_SWI_MIRROR_ING_MAP_MIRROR_ING_MAP_2      2
#define BM_ENET_SWI_MIRROR_ING_MAP_MIRROR_ING_MAP_2      0x00000004

#define BF_ENET_SWI_MIRROR_ING_MAP_MIRROR_ING_MAP_2(v)   (((v) << 2) & BM_ENET_SWI_MIRROR_ING_MAP_MIRROR_ING_MAP_2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_MIRROR_ING_MAP_MIRROR_ING_MAP_2(v)   BF_CS1(ENET_SWI_MIRROR_ING_MAP, MIRROR_ING_MAP_2, v)
#endif

/* --- Register HW_ENET_SWI_MIRROR_ING_MAP, field MIRROR_ING_MAP_1 */

#define BP_ENET_SWI_MIRROR_ING_MAP_MIRROR_ING_MAP_1      1
#define BM_ENET_SWI_MIRROR_ING_MAP_MIRROR_ING_MAP_1      0x00000002

#define BF_ENET_SWI_MIRROR_ING_MAP_MIRROR_ING_MAP_1(v)   (((v) << 1) & BM_ENET_SWI_MIRROR_ING_MAP_MIRROR_ING_MAP_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_MIRROR_ING_MAP_MIRROR_ING_MAP_1(v)   BF_CS1(ENET_SWI_MIRROR_ING_MAP, MIRROR_ING_MAP_1, v)
#endif

/* --- Register HW_ENET_SWI_MIRROR_ING_MAP, field MIRROR_ING_MAP_0 */

#define BP_ENET_SWI_MIRROR_ING_MAP_MIRROR_ING_MAP_0      0
#define BM_ENET_SWI_MIRROR_ING_MAP_MIRROR_ING_MAP_0      0x00000001

#define BF_ENET_SWI_MIRROR_ING_MAP_MIRROR_ING_MAP_0(v)   (((v) << 0) & BM_ENET_SWI_MIRROR_ING_MAP_MIRROR_ING_MAP_0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_MIRROR_ING_MAP_MIRROR_ING_MAP_0(v)   BF_CS1(ENET_SWI_MIRROR_ING_MAP, MIRROR_ING_MAP_0, v)
#endif



/*
 * HW_ENET_SWI_MIRROR_ISRC_0 - ENET SWI Ingress Source MAC Address for Mirror filtering.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned MIRROR_ISRC_0  : 32;
    } B;
} hw_enet_swi_mirror_isrc_0_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_MIRROR_ISRC_0 register
 */
#define HW_ENET_SWI_MIRROR_ISRC_0_ADDR         (REGS_ENET_BASE + 0x804c)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_MIRROR_ISRC_0           (*(volatile hw_enet_swi_mirror_isrc_0_t *) HW_ENET_SWI_MIRROR_ISRC_0_ADDR)
#define HW_ENET_SWI_MIRROR_ISRC_0_RD()      (HW_ENET_SWI_MIRROR_ISRC_0.U)
#define HW_ENET_SWI_MIRROR_ISRC_0_WR(v)     (HW_ENET_SWI_MIRROR_ISRC_0.U = (v))
#define HW_ENET_SWI_MIRROR_ISRC_0_SET(v)    (HW_ENET_SWI_MIRROR_ISRC_0_WR(HW_ENET_SWI_MIRROR_ISRC_0_RD() |  (v)))
#define HW_ENET_SWI_MIRROR_ISRC_0_CLR(v)    (HW_ENET_SWI_MIRROR_ISRC_0_WR(HW_ENET_SWI_MIRROR_ISRC_0_RD() & ~(v)))
#define HW_ENET_SWI_MIRROR_ISRC_0_TOG(v)    (HW_ENET_SWI_MIRROR_ISRC_0_WR(HW_ENET_SWI_MIRROR_ISRC_0_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_MIRROR_ISRC_0 bitfields
 */
/* --- Register HW_ENET_SWI_MIRROR_ISRC_0, field MIRROR_ISRC_0 */

#define BP_ENET_SWI_MIRROR_ISRC_0_MIRROR_ISRC_0      0
#define BM_ENET_SWI_MIRROR_ISRC_0_MIRROR_ISRC_0      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_MIRROR_ISRC_0_MIRROR_ISRC_0(v)   ((reg32_t) v)
#else
#define BF_ENET_SWI_MIRROR_ISRC_0_MIRROR_ISRC_0(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_MIRROR_ISRC_0_MIRROR_ISRC_0(v)   (HW_ENET_SWI_MIRROR_ISRC_0.B.MIRROR_ISRC_0 = (v))
#endif



/*
 * HW_ENET_SWI_MIRROR_ISRC_1 - ENET SWI Ingress Source MAC Address for Mirror filtering.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned MIRROR_ISRC_1  : 16;
        unsigned RSRVD0         : 16;
    } B;
} hw_enet_swi_mirror_isrc_1_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_MIRROR_ISRC_1 register
 */
#define HW_ENET_SWI_MIRROR_ISRC_1_ADDR         (REGS_ENET_BASE + 0x8050)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_MIRROR_ISRC_1           (*(volatile hw_enet_swi_mirror_isrc_1_t *) HW_ENET_SWI_MIRROR_ISRC_1_ADDR)
#define HW_ENET_SWI_MIRROR_ISRC_1_RD()      (HW_ENET_SWI_MIRROR_ISRC_1.U)
#define HW_ENET_SWI_MIRROR_ISRC_1_WR(v)     (HW_ENET_SWI_MIRROR_ISRC_1.U = (v))
#define HW_ENET_SWI_MIRROR_ISRC_1_SET(v)    (HW_ENET_SWI_MIRROR_ISRC_1_WR(HW_ENET_SWI_MIRROR_ISRC_1_RD() |  (v)))
#define HW_ENET_SWI_MIRROR_ISRC_1_CLR(v)    (HW_ENET_SWI_MIRROR_ISRC_1_WR(HW_ENET_SWI_MIRROR_ISRC_1_RD() & ~(v)))
#define HW_ENET_SWI_MIRROR_ISRC_1_TOG(v)    (HW_ENET_SWI_MIRROR_ISRC_1_WR(HW_ENET_SWI_MIRROR_ISRC_1_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_MIRROR_ISRC_1 bitfields
 */
/* --- Register HW_ENET_SWI_MIRROR_ISRC_1, field RSRVD0 */

#define BP_ENET_SWI_MIRROR_ISRC_1_RSRVD0      16
#define BM_ENET_SWI_MIRROR_ISRC_1_RSRVD0      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_MIRROR_ISRC_1_RSRVD0(v)   ((((reg32_t) v) << 16) & BM_ENET_SWI_MIRROR_ISRC_1_RSRVD0)
#else
#define BF_ENET_SWI_MIRROR_ISRC_1_RSRVD0(v)   (((v) << 16) & BM_ENET_SWI_MIRROR_ISRC_1_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_MIRROR_ISRC_1, field MIRROR_ISRC_1 */

#define BP_ENET_SWI_MIRROR_ISRC_1_MIRROR_ISRC_1      0
#define BM_ENET_SWI_MIRROR_ISRC_1_MIRROR_ISRC_1      0x0000FFFF

#define BF_ENET_SWI_MIRROR_ISRC_1_MIRROR_ISRC_1(v)   (((v) << 0) & BM_ENET_SWI_MIRROR_ISRC_1_MIRROR_ISRC_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_MIRROR_ISRC_1_MIRROR_ISRC_1(v)   (HW_ENET_SWI_MIRROR_ISRC_1.B.MIRROR_ISRC_1 = (v))
#endif



/*
 * HW_ENET_SWI_MIRROR_IDST_0 - ENET SWI Ingress Destination MAC Address for Mirror filtering.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned MIRROR_IDST_0  : 32;
    } B;
} hw_enet_swi_mirror_idst_0_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_MIRROR_IDST_0 register
 */
#define HW_ENET_SWI_MIRROR_IDST_0_ADDR         (REGS_ENET_BASE + 0x8054)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_MIRROR_IDST_0           (*(volatile hw_enet_swi_mirror_idst_0_t *) HW_ENET_SWI_MIRROR_IDST_0_ADDR)
#define HW_ENET_SWI_MIRROR_IDST_0_RD()      (HW_ENET_SWI_MIRROR_IDST_0.U)
#define HW_ENET_SWI_MIRROR_IDST_0_WR(v)     (HW_ENET_SWI_MIRROR_IDST_0.U = (v))
#define HW_ENET_SWI_MIRROR_IDST_0_SET(v)    (HW_ENET_SWI_MIRROR_IDST_0_WR(HW_ENET_SWI_MIRROR_IDST_0_RD() |  (v)))
#define HW_ENET_SWI_MIRROR_IDST_0_CLR(v)    (HW_ENET_SWI_MIRROR_IDST_0_WR(HW_ENET_SWI_MIRROR_IDST_0_RD() & ~(v)))
#define HW_ENET_SWI_MIRROR_IDST_0_TOG(v)    (HW_ENET_SWI_MIRROR_IDST_0_WR(HW_ENET_SWI_MIRROR_IDST_0_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_MIRROR_IDST_0 bitfields
 */
/* --- Register HW_ENET_SWI_MIRROR_IDST_0, field MIRROR_IDST_0 */

#define BP_ENET_SWI_MIRROR_IDST_0_MIRROR_IDST_0      0
#define BM_ENET_SWI_MIRROR_IDST_0_MIRROR_IDST_0      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_MIRROR_IDST_0_MIRROR_IDST_0(v)   ((reg32_t) v)
#else
#define BF_ENET_SWI_MIRROR_IDST_0_MIRROR_IDST_0(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_MIRROR_IDST_0_MIRROR_IDST_0(v)   (HW_ENET_SWI_MIRROR_IDST_0.B.MIRROR_IDST_0 = (v))
#endif



/*
 * HW_ENET_SWI_MIRROR_IDST_1 - ENET SWI Ingress Destination MAC Address for Mirror filtering.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned MIRROR_IDST_1  : 16;
        unsigned RSRVD0         : 16;
    } B;
} hw_enet_swi_mirror_idst_1_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_MIRROR_IDST_1 register
 */
#define HW_ENET_SWI_MIRROR_IDST_1_ADDR         (REGS_ENET_BASE + 0x8058)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_MIRROR_IDST_1           (*(volatile hw_enet_swi_mirror_idst_1_t *) HW_ENET_SWI_MIRROR_IDST_1_ADDR)
#define HW_ENET_SWI_MIRROR_IDST_1_RD()      (HW_ENET_SWI_MIRROR_IDST_1.U)
#define HW_ENET_SWI_MIRROR_IDST_1_WR(v)     (HW_ENET_SWI_MIRROR_IDST_1.U = (v))
#define HW_ENET_SWI_MIRROR_IDST_1_SET(v)    (HW_ENET_SWI_MIRROR_IDST_1_WR(HW_ENET_SWI_MIRROR_IDST_1_RD() |  (v)))
#define HW_ENET_SWI_MIRROR_IDST_1_CLR(v)    (HW_ENET_SWI_MIRROR_IDST_1_WR(HW_ENET_SWI_MIRROR_IDST_1_RD() & ~(v)))
#define HW_ENET_SWI_MIRROR_IDST_1_TOG(v)    (HW_ENET_SWI_MIRROR_IDST_1_WR(HW_ENET_SWI_MIRROR_IDST_1_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_MIRROR_IDST_1 bitfields
 */
/* --- Register HW_ENET_SWI_MIRROR_IDST_1, field RSRVD0 */

#define BP_ENET_SWI_MIRROR_IDST_1_RSRVD0      16
#define BM_ENET_SWI_MIRROR_IDST_1_RSRVD0      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_MIRROR_IDST_1_RSRVD0(v)   ((((reg32_t) v) << 16) & BM_ENET_SWI_MIRROR_IDST_1_RSRVD0)
#else
#define BF_ENET_SWI_MIRROR_IDST_1_RSRVD0(v)   (((v) << 16) & BM_ENET_SWI_MIRROR_IDST_1_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_MIRROR_IDST_1, field MIRROR_IDST_1 */

#define BP_ENET_SWI_MIRROR_IDST_1_MIRROR_IDST_1      0
#define BM_ENET_SWI_MIRROR_IDST_1_MIRROR_IDST_1      0x0000FFFF

#define BF_ENET_SWI_MIRROR_IDST_1_MIRROR_IDST_1(v)   (((v) << 0) & BM_ENET_SWI_MIRROR_IDST_1_MIRROR_IDST_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_MIRROR_IDST_1_MIRROR_IDST_1(v)   (HW_ENET_SWI_MIRROR_IDST_1.B.MIRROR_IDST_1 = (v))
#endif



/*
 * HW_ENET_SWI_MIRROR_ESRC_0 - ENET SWI Egress Source MAC Address for Mirror filtering.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned MIRROR_ESRC_0  : 32;
    } B;
} hw_enet_swi_mirror_esrc_0_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_MIRROR_ESRC_0 register
 */
#define HW_ENET_SWI_MIRROR_ESRC_0_ADDR         (REGS_ENET_BASE + 0x805c)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_MIRROR_ESRC_0           (*(volatile hw_enet_swi_mirror_esrc_0_t *) HW_ENET_SWI_MIRROR_ESRC_0_ADDR)
#define HW_ENET_SWI_MIRROR_ESRC_0_RD()      (HW_ENET_SWI_MIRROR_ESRC_0.U)
#define HW_ENET_SWI_MIRROR_ESRC_0_WR(v)     (HW_ENET_SWI_MIRROR_ESRC_0.U = (v))
#define HW_ENET_SWI_MIRROR_ESRC_0_SET(v)    (HW_ENET_SWI_MIRROR_ESRC_0_WR(HW_ENET_SWI_MIRROR_ESRC_0_RD() |  (v)))
#define HW_ENET_SWI_MIRROR_ESRC_0_CLR(v)    (HW_ENET_SWI_MIRROR_ESRC_0_WR(HW_ENET_SWI_MIRROR_ESRC_0_RD() & ~(v)))
#define HW_ENET_SWI_MIRROR_ESRC_0_TOG(v)    (HW_ENET_SWI_MIRROR_ESRC_0_WR(HW_ENET_SWI_MIRROR_ESRC_0_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_MIRROR_ESRC_0 bitfields
 */
/* --- Register HW_ENET_SWI_MIRROR_ESRC_0, field MIRROR_ESRC_0 */

#define BP_ENET_SWI_MIRROR_ESRC_0_MIRROR_ESRC_0      0
#define BM_ENET_SWI_MIRROR_ESRC_0_MIRROR_ESRC_0      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_MIRROR_ESRC_0_MIRROR_ESRC_0(v)   ((reg32_t) v)
#else
#define BF_ENET_SWI_MIRROR_ESRC_0_MIRROR_ESRC_0(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_MIRROR_ESRC_0_MIRROR_ESRC_0(v)   (HW_ENET_SWI_MIRROR_ESRC_0.B.MIRROR_ESRC_0 = (v))
#endif



/*
 * HW_ENET_SWI_MIRROR_ESRC_1 - ENET SWI Egress Source MAC Address for Mirror filtering.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned MIRROR_ESRC_1  : 16;
        unsigned RSRVD0         : 16;
    } B;
} hw_enet_swi_mirror_esrc_1_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_MIRROR_ESRC_1 register
 */
#define HW_ENET_SWI_MIRROR_ESRC_1_ADDR         (REGS_ENET_BASE + 0x8060)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_MIRROR_ESRC_1           (*(volatile hw_enet_swi_mirror_esrc_1_t *) HW_ENET_SWI_MIRROR_ESRC_1_ADDR)
#define HW_ENET_SWI_MIRROR_ESRC_1_RD()      (HW_ENET_SWI_MIRROR_ESRC_1.U)
#define HW_ENET_SWI_MIRROR_ESRC_1_WR(v)     (HW_ENET_SWI_MIRROR_ESRC_1.U = (v))
#define HW_ENET_SWI_MIRROR_ESRC_1_SET(v)    (HW_ENET_SWI_MIRROR_ESRC_1_WR(HW_ENET_SWI_MIRROR_ESRC_1_RD() |  (v)))
#define HW_ENET_SWI_MIRROR_ESRC_1_CLR(v)    (HW_ENET_SWI_MIRROR_ESRC_1_WR(HW_ENET_SWI_MIRROR_ESRC_1_RD() & ~(v)))
#define HW_ENET_SWI_MIRROR_ESRC_1_TOG(v)    (HW_ENET_SWI_MIRROR_ESRC_1_WR(HW_ENET_SWI_MIRROR_ESRC_1_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_MIRROR_ESRC_1 bitfields
 */
/* --- Register HW_ENET_SWI_MIRROR_ESRC_1, field RSRVD0 */

#define BP_ENET_SWI_MIRROR_ESRC_1_RSRVD0      16
#define BM_ENET_SWI_MIRROR_ESRC_1_RSRVD0      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_MIRROR_ESRC_1_RSRVD0(v)   ((((reg32_t) v) << 16) & BM_ENET_SWI_MIRROR_ESRC_1_RSRVD0)
#else
#define BF_ENET_SWI_MIRROR_ESRC_1_RSRVD0(v)   (((v) << 16) & BM_ENET_SWI_MIRROR_ESRC_1_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_MIRROR_ESRC_1, field MIRROR_ESRC_1 */

#define BP_ENET_SWI_MIRROR_ESRC_1_MIRROR_ESRC_1      0
#define BM_ENET_SWI_MIRROR_ESRC_1_MIRROR_ESRC_1      0x0000FFFF

#define BF_ENET_SWI_MIRROR_ESRC_1_MIRROR_ESRC_1(v)   (((v) << 0) & BM_ENET_SWI_MIRROR_ESRC_1_MIRROR_ESRC_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_MIRROR_ESRC_1_MIRROR_ESRC_1(v)   (HW_ENET_SWI_MIRROR_ESRC_1.B.MIRROR_ESRC_1 = (v))
#endif



/*
 * HW_ENET_SWI_MIRROR_EDST_0 - ENET SWI Egress Destination MAC Address for Mirror filtering.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned MIRROR_ESRC_0  : 32;
    } B;
} hw_enet_swi_mirror_edst_0_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_MIRROR_EDST_0 register
 */
#define HW_ENET_SWI_MIRROR_EDST_0_ADDR         (REGS_ENET_BASE + 0x8064)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_MIRROR_EDST_0           (*(volatile hw_enet_swi_mirror_edst_0_t *) HW_ENET_SWI_MIRROR_EDST_0_ADDR)
#define HW_ENET_SWI_MIRROR_EDST_0_RD()      (HW_ENET_SWI_MIRROR_EDST_0.U)
#define HW_ENET_SWI_MIRROR_EDST_0_WR(v)     (HW_ENET_SWI_MIRROR_EDST_0.U = (v))
#define HW_ENET_SWI_MIRROR_EDST_0_SET(v)    (HW_ENET_SWI_MIRROR_EDST_0_WR(HW_ENET_SWI_MIRROR_EDST_0_RD() |  (v)))
#define HW_ENET_SWI_MIRROR_EDST_0_CLR(v)    (HW_ENET_SWI_MIRROR_EDST_0_WR(HW_ENET_SWI_MIRROR_EDST_0_RD() & ~(v)))
#define HW_ENET_SWI_MIRROR_EDST_0_TOG(v)    (HW_ENET_SWI_MIRROR_EDST_0_WR(HW_ENET_SWI_MIRROR_EDST_0_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_MIRROR_EDST_0 bitfields
 */
/* --- Register HW_ENET_SWI_MIRROR_EDST_0, field MIRROR_ESRC_0 */

#define BP_ENET_SWI_MIRROR_EDST_0_MIRROR_ESRC_0      0
#define BM_ENET_SWI_MIRROR_EDST_0_MIRROR_ESRC_0      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_MIRROR_EDST_0_MIRROR_ESRC_0(v)   ((reg32_t) v)
#else
#define BF_ENET_SWI_MIRROR_EDST_0_MIRROR_ESRC_0(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_MIRROR_EDST_0_MIRROR_ESRC_0(v)   (HW_ENET_SWI_MIRROR_EDST_0.B.MIRROR_ESRC_0 = (v))
#endif



/*
 * HW_ENET_SWI_MIRROR_EDST_1 - ENET SWI Egress Destination MAC Address for Mirror filtering.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned MIRROR_ESRC_1  : 16;
        unsigned RSRVD0         : 16;
    } B;
} hw_enet_swi_mirror_edst_1_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_MIRROR_EDST_1 register
 */
#define HW_ENET_SWI_MIRROR_EDST_1_ADDR         (REGS_ENET_BASE + 0x8068)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_MIRROR_EDST_1           (*(volatile hw_enet_swi_mirror_edst_1_t *) HW_ENET_SWI_MIRROR_EDST_1_ADDR)
#define HW_ENET_SWI_MIRROR_EDST_1_RD()      (HW_ENET_SWI_MIRROR_EDST_1.U)
#define HW_ENET_SWI_MIRROR_EDST_1_WR(v)     (HW_ENET_SWI_MIRROR_EDST_1.U = (v))
#define HW_ENET_SWI_MIRROR_EDST_1_SET(v)    (HW_ENET_SWI_MIRROR_EDST_1_WR(HW_ENET_SWI_MIRROR_EDST_1_RD() |  (v)))
#define HW_ENET_SWI_MIRROR_EDST_1_CLR(v)    (HW_ENET_SWI_MIRROR_EDST_1_WR(HW_ENET_SWI_MIRROR_EDST_1_RD() & ~(v)))
#define HW_ENET_SWI_MIRROR_EDST_1_TOG(v)    (HW_ENET_SWI_MIRROR_EDST_1_WR(HW_ENET_SWI_MIRROR_EDST_1_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_MIRROR_EDST_1 bitfields
 */
/* --- Register HW_ENET_SWI_MIRROR_EDST_1, field RSRVD0 */

#define BP_ENET_SWI_MIRROR_EDST_1_RSRVD0      16
#define BM_ENET_SWI_MIRROR_EDST_1_RSRVD0      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_MIRROR_EDST_1_RSRVD0(v)   ((((reg32_t) v) << 16) & BM_ENET_SWI_MIRROR_EDST_1_RSRVD0)
#else
#define BF_ENET_SWI_MIRROR_EDST_1_RSRVD0(v)   (((v) << 16) & BM_ENET_SWI_MIRROR_EDST_1_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_MIRROR_EDST_1, field MIRROR_ESRC_1 */

#define BP_ENET_SWI_MIRROR_EDST_1_MIRROR_ESRC_1      0
#define BM_ENET_SWI_MIRROR_EDST_1_MIRROR_ESRC_1      0x0000FFFF

#define BF_ENET_SWI_MIRROR_EDST_1_MIRROR_ESRC_1(v)   (((v) << 0) & BM_ENET_SWI_MIRROR_EDST_1_MIRROR_ESRC_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_MIRROR_EDST_1_MIRROR_ESRC_1(v)   (HW_ENET_SWI_MIRROR_EDST_1.B.MIRROR_ESRC_1 = (v))
#endif



/*
 * HW_ENET_SWI_MIRROR_CNT - ENET SWI Count Value for Mirror filtering.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned MIRROR_CNT  :  8;
        unsigned RSRVD0      : 24;
    } B;
} hw_enet_swi_mirror_cnt_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_MIRROR_CNT register
 */
#define HW_ENET_SWI_MIRROR_CNT_ADDR         (REGS_ENET_BASE + 0x806c)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_MIRROR_CNT           (*(volatile hw_enet_swi_mirror_cnt_t *) HW_ENET_SWI_MIRROR_CNT_ADDR)
#define HW_ENET_SWI_MIRROR_CNT_RD()      (HW_ENET_SWI_MIRROR_CNT.U)
#define HW_ENET_SWI_MIRROR_CNT_WR(v)     (HW_ENET_SWI_MIRROR_CNT.U = (v))
#define HW_ENET_SWI_MIRROR_CNT_SET(v)    (HW_ENET_SWI_MIRROR_CNT_WR(HW_ENET_SWI_MIRROR_CNT_RD() |  (v)))
#define HW_ENET_SWI_MIRROR_CNT_CLR(v)    (HW_ENET_SWI_MIRROR_CNT_WR(HW_ENET_SWI_MIRROR_CNT_RD() & ~(v)))
#define HW_ENET_SWI_MIRROR_CNT_TOG(v)    (HW_ENET_SWI_MIRROR_CNT_WR(HW_ENET_SWI_MIRROR_CNT_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_MIRROR_CNT bitfields
 */
/* --- Register HW_ENET_SWI_MIRROR_CNT, field RSRVD0 */

#define BP_ENET_SWI_MIRROR_CNT_RSRVD0      8
#define BM_ENET_SWI_MIRROR_CNT_RSRVD0      0xFFFFFF00

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_MIRROR_CNT_RSRVD0(v)   ((((reg32_t) v) << 8) & BM_ENET_SWI_MIRROR_CNT_RSRVD0)
#else
#define BF_ENET_SWI_MIRROR_CNT_RSRVD0(v)   (((v) << 8) & BM_ENET_SWI_MIRROR_CNT_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_MIRROR_CNT, field MIRROR_CNT */

#define BP_ENET_SWI_MIRROR_CNT_MIRROR_CNT      0
#define BM_ENET_SWI_MIRROR_CNT_MIRROR_CNT      0x000000FF

#define BF_ENET_SWI_MIRROR_CNT_MIRROR_CNT(v)   (((v) << 0) & BM_ENET_SWI_MIRROR_CNT_MIRROR_CNT)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_MIRROR_CNT_MIRROR_CNT(v)   (HW_ENET_SWI_MIRROR_CNT.B.MIRROR_CNT = (v))
#endif



/*
 * HW_ENET_SWI_OQMGR_STATUS - ENET SWI Memory Manager Status.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BUSY_INITIALIZING  :  1;
        unsigned NO_CELL_LATCH      :  1;
        unsigned MEM_FULL           :  1;
        unsigned MEM_FULL_LATCH     :  1;
        unsigned RSRVD0             :  2;
        unsigned DEQUEUE_GRANT      :  1;
        unsigned RSRVD1             :  9;
        unsigned CELLS_AVAILABLE    :  8;
        unsigned RSRVD2             :  8;
    } B;
} hw_enet_swi_oqmgr_status_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_OQMGR_STATUS register
 */
#define HW_ENET_SWI_OQMGR_STATUS_ADDR         (REGS_ENET_BASE + 0x8080)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_OQMGR_STATUS           (*(volatile hw_enet_swi_oqmgr_status_t *) HW_ENET_SWI_OQMGR_STATUS_ADDR)
#define HW_ENET_SWI_OQMGR_STATUS_RD()      (HW_ENET_SWI_OQMGR_STATUS.U)
#define HW_ENET_SWI_OQMGR_STATUS_WR(v)     (HW_ENET_SWI_OQMGR_STATUS.U = (v))
#define HW_ENET_SWI_OQMGR_STATUS_SET(v)    (HW_ENET_SWI_OQMGR_STATUS_WR(HW_ENET_SWI_OQMGR_STATUS_RD() |  (v)))
#define HW_ENET_SWI_OQMGR_STATUS_CLR(v)    (HW_ENET_SWI_OQMGR_STATUS_WR(HW_ENET_SWI_OQMGR_STATUS_RD() & ~(v)))
#define HW_ENET_SWI_OQMGR_STATUS_TOG(v)    (HW_ENET_SWI_OQMGR_STATUS_WR(HW_ENET_SWI_OQMGR_STATUS_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_OQMGR_STATUS bitfields
 */
/* --- Register HW_ENET_SWI_OQMGR_STATUS, field RSRVD2 */

#define BP_ENET_SWI_OQMGR_STATUS_RSRVD2      24
#define BM_ENET_SWI_OQMGR_STATUS_RSRVD2      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_OQMGR_STATUS_RSRVD2(v)   ((((reg32_t) v) << 24) & BM_ENET_SWI_OQMGR_STATUS_RSRVD2)
#else
#define BF_ENET_SWI_OQMGR_STATUS_RSRVD2(v)   (((v) << 24) & BM_ENET_SWI_OQMGR_STATUS_RSRVD2)
#endif
/* --- Register HW_ENET_SWI_OQMGR_STATUS, field CELLS_AVAILABLE */

#define BP_ENET_SWI_OQMGR_STATUS_CELLS_AVAILABLE      16
#define BM_ENET_SWI_OQMGR_STATUS_CELLS_AVAILABLE      0x00FF0000

#define BF_ENET_SWI_OQMGR_STATUS_CELLS_AVAILABLE(v)   (((v) << 16) & BM_ENET_SWI_OQMGR_STATUS_CELLS_AVAILABLE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_OQMGR_STATUS_CELLS_AVAILABLE(v)   (HW_ENET_SWI_OQMGR_STATUS.B.CELLS_AVAILABLE = (v))
#endif

/* --- Register HW_ENET_SWI_OQMGR_STATUS, field RSRVD1 */

#define BP_ENET_SWI_OQMGR_STATUS_RSRVD1      7
#define BM_ENET_SWI_OQMGR_STATUS_RSRVD1      0x0000FF80

#define BF_ENET_SWI_OQMGR_STATUS_RSRVD1(v)   (((v) << 7) & BM_ENET_SWI_OQMGR_STATUS_RSRVD1)
/* --- Register HW_ENET_SWI_OQMGR_STATUS, field DEQUEUE_GRANT */

#define BP_ENET_SWI_OQMGR_STATUS_DEQUEUE_GRANT      6
#define BM_ENET_SWI_OQMGR_STATUS_DEQUEUE_GRANT      0x00000040

#define BF_ENET_SWI_OQMGR_STATUS_DEQUEUE_GRANT(v)   (((v) << 6) & BM_ENET_SWI_OQMGR_STATUS_DEQUEUE_GRANT)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_OQMGR_STATUS_DEQUEUE_GRANT(v)   BF_CS1(ENET_SWI_OQMGR_STATUS, DEQUEUE_GRANT, v)
#endif

/* --- Register HW_ENET_SWI_OQMGR_STATUS, field RSRVD0 */

#define BP_ENET_SWI_OQMGR_STATUS_RSRVD0      4
#define BM_ENET_SWI_OQMGR_STATUS_RSRVD0      0x00000030

#define BF_ENET_SWI_OQMGR_STATUS_RSRVD0(v)   (((v) << 4) & BM_ENET_SWI_OQMGR_STATUS_RSRVD0)
/* --- Register HW_ENET_SWI_OQMGR_STATUS, field MEM_FULL_LATCH */

#define BP_ENET_SWI_OQMGR_STATUS_MEM_FULL_LATCH      3
#define BM_ENET_SWI_OQMGR_STATUS_MEM_FULL_LATCH      0x00000008

#define BF_ENET_SWI_OQMGR_STATUS_MEM_FULL_LATCH(v)   (((v) << 3) & BM_ENET_SWI_OQMGR_STATUS_MEM_FULL_LATCH)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_OQMGR_STATUS_MEM_FULL_LATCH(v)   BF_CS1(ENET_SWI_OQMGR_STATUS, MEM_FULL_LATCH, v)
#endif

/* --- Register HW_ENET_SWI_OQMGR_STATUS, field MEM_FULL */

#define BP_ENET_SWI_OQMGR_STATUS_MEM_FULL      2
#define BM_ENET_SWI_OQMGR_STATUS_MEM_FULL      0x00000004

#define BF_ENET_SWI_OQMGR_STATUS_MEM_FULL(v)   (((v) << 2) & BM_ENET_SWI_OQMGR_STATUS_MEM_FULL)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_OQMGR_STATUS_MEM_FULL(v)   BF_CS1(ENET_SWI_OQMGR_STATUS, MEM_FULL, v)
#endif

/* --- Register HW_ENET_SWI_OQMGR_STATUS, field NO_CELL_LATCH */

#define BP_ENET_SWI_OQMGR_STATUS_NO_CELL_LATCH      1
#define BM_ENET_SWI_OQMGR_STATUS_NO_CELL_LATCH      0x00000002

#define BF_ENET_SWI_OQMGR_STATUS_NO_CELL_LATCH(v)   (((v) << 1) & BM_ENET_SWI_OQMGR_STATUS_NO_CELL_LATCH)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_OQMGR_STATUS_NO_CELL_LATCH(v)   BF_CS1(ENET_SWI_OQMGR_STATUS, NO_CELL_LATCH, v)
#endif

/* --- Register HW_ENET_SWI_OQMGR_STATUS, field BUSY_INITIALIZING */

#define BP_ENET_SWI_OQMGR_STATUS_BUSY_INITIALIZING      0
#define BM_ENET_SWI_OQMGR_STATUS_BUSY_INITIALIZING      0x00000001

#define BF_ENET_SWI_OQMGR_STATUS_BUSY_INITIALIZING(v)   (((v) << 0) & BM_ENET_SWI_OQMGR_STATUS_BUSY_INITIALIZING)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_OQMGR_STATUS_BUSY_INITIALIZING(v)   BF_CS1(ENET_SWI_OQMGR_STATUS, BUSY_INITIALIZING, v)
#endif



/*
 * HW_ENET_SWI_QMGR_MINCELLS - ENET SWI Low Memory threshold.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned QMGR_MINCELLS  :  8;
        unsigned RSRVD0         : 24;
    } B;
} hw_enet_swi_qmgr_mincells_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_QMGR_MINCELLS register
 */
#define HW_ENET_SWI_QMGR_MINCELLS_ADDR         (REGS_ENET_BASE + 0x8084)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_QMGR_MINCELLS           (*(volatile hw_enet_swi_qmgr_mincells_t *) HW_ENET_SWI_QMGR_MINCELLS_ADDR)
#define HW_ENET_SWI_QMGR_MINCELLS_RD()      (HW_ENET_SWI_QMGR_MINCELLS.U)
#define HW_ENET_SWI_QMGR_MINCELLS_WR(v)     (HW_ENET_SWI_QMGR_MINCELLS.U = (v))
#define HW_ENET_SWI_QMGR_MINCELLS_SET(v)    (HW_ENET_SWI_QMGR_MINCELLS_WR(HW_ENET_SWI_QMGR_MINCELLS_RD() |  (v)))
#define HW_ENET_SWI_QMGR_MINCELLS_CLR(v)    (HW_ENET_SWI_QMGR_MINCELLS_WR(HW_ENET_SWI_QMGR_MINCELLS_RD() & ~(v)))
#define HW_ENET_SWI_QMGR_MINCELLS_TOG(v)    (HW_ENET_SWI_QMGR_MINCELLS_WR(HW_ENET_SWI_QMGR_MINCELLS_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_QMGR_MINCELLS bitfields
 */
/* --- Register HW_ENET_SWI_QMGR_MINCELLS, field RSRVD0 */

#define BP_ENET_SWI_QMGR_MINCELLS_RSRVD0      8
#define BM_ENET_SWI_QMGR_MINCELLS_RSRVD0      0xFFFFFF00

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_QMGR_MINCELLS_RSRVD0(v)   ((((reg32_t) v) << 8) & BM_ENET_SWI_QMGR_MINCELLS_RSRVD0)
#else
#define BF_ENET_SWI_QMGR_MINCELLS_RSRVD0(v)   (((v) << 8) & BM_ENET_SWI_QMGR_MINCELLS_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_QMGR_MINCELLS, field QMGR_MINCELLS */

#define BP_ENET_SWI_QMGR_MINCELLS_QMGR_MINCELLS      0
#define BM_ENET_SWI_QMGR_MINCELLS_QMGR_MINCELLS      0x000000FF

#define BF_ENET_SWI_QMGR_MINCELLS_QMGR_MINCELLS(v)   (((v) << 0) & BM_ENET_SWI_QMGR_MINCELLS_QMGR_MINCELLS)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_QMGR_MINCELLS_QMGR_MINCELLS(v)   (HW_ENET_SWI_QMGR_MINCELLS.B.QMGR_MINCELLS = (v))
#endif



/*
 * HW_ENET_SWI_QMGR_ST_MINCELLS - ENET SWI Statistic providing the lowest number of free cells reached in memory
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned QMGR_ST_MINCELLS  : 32;
    } B;
} hw_enet_swi_qmgr_st_mincells_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_QMGR_ST_MINCELLS register
 */
#define HW_ENET_SWI_QMGR_ST_MINCELLS_ADDR         (REGS_ENET_BASE + 0x8088)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_QMGR_ST_MINCELLS           (*(volatile hw_enet_swi_qmgr_st_mincells_t *) HW_ENET_SWI_QMGR_ST_MINCELLS_ADDR)
#define HW_ENET_SWI_QMGR_ST_MINCELLS_RD()      (HW_ENET_SWI_QMGR_ST_MINCELLS.U)
#define HW_ENET_SWI_QMGR_ST_MINCELLS_WR(v)     (HW_ENET_SWI_QMGR_ST_MINCELLS.U = (v))
#define HW_ENET_SWI_QMGR_ST_MINCELLS_SET(v)    (HW_ENET_SWI_QMGR_ST_MINCELLS_WR(HW_ENET_SWI_QMGR_ST_MINCELLS_RD() |  (v)))
#define HW_ENET_SWI_QMGR_ST_MINCELLS_CLR(v)    (HW_ENET_SWI_QMGR_ST_MINCELLS_WR(HW_ENET_SWI_QMGR_ST_MINCELLS_RD() & ~(v)))
#define HW_ENET_SWI_QMGR_ST_MINCELLS_TOG(v)    (HW_ENET_SWI_QMGR_ST_MINCELLS_WR(HW_ENET_SWI_QMGR_ST_MINCELLS_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_QMGR_ST_MINCELLS bitfields
 */
/* --- Register HW_ENET_SWI_QMGR_ST_MINCELLS, field QMGR_ST_MINCELLS */

#define BP_ENET_SWI_QMGR_ST_MINCELLS_QMGR_ST_MINCELLS      0
#define BM_ENET_SWI_QMGR_ST_MINCELLS_QMGR_ST_MINCELLS      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_QMGR_ST_MINCELLS_QMGR_ST_MINCELLS(v)   ((reg32_t) v)
#else
#define BF_ENET_SWI_QMGR_ST_MINCELLS_QMGR_ST_MINCELLS(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_QMGR_ST_MINCELLS_QMGR_ST_MINCELLS(v)   (HW_ENET_SWI_QMGR_ST_MINCELLS.B.QMGR_ST_MINCELLS = (v))
#endif



/*
 * HW_ENET_SWI_QMGR_CONGEST_STAT - ENET SWI Port Congestion status (internal).
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned QMGR_CONGEST_STAT_0  :  1;
        unsigned QMGR_CONGEST_STAT_1  :  1;
        unsigned QMGR_CONGEST_STAT_2  :  1;
        unsigned RSRVD0               : 29;
    } B;
} hw_enet_swi_qmgr_congest_stat_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_QMGR_CONGEST_STAT register
 */
#define HW_ENET_SWI_QMGR_CONGEST_STAT_ADDR         (REGS_ENET_BASE + 0x808c)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_QMGR_CONGEST_STAT           (*(volatile hw_enet_swi_qmgr_congest_stat_t *) HW_ENET_SWI_QMGR_CONGEST_STAT_ADDR)
#define HW_ENET_SWI_QMGR_CONGEST_STAT_RD()      (HW_ENET_SWI_QMGR_CONGEST_STAT.U)
#endif


/*
 * constants & macros for individual HW_ENET_SWI_QMGR_CONGEST_STAT bitfields
 */
/* --- Register HW_ENET_SWI_QMGR_CONGEST_STAT, field RSRVD0 */

#define BP_ENET_SWI_QMGR_CONGEST_STAT_RSRVD0      3
#define BM_ENET_SWI_QMGR_CONGEST_STAT_RSRVD0      0xFFFFFFF8

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_QMGR_CONGEST_STAT_RSRVD0(v)   ((((reg32_t) v) << 3) & BM_ENET_SWI_QMGR_CONGEST_STAT_RSRVD0)
#else
#define BF_ENET_SWI_QMGR_CONGEST_STAT_RSRVD0(v)   (((v) << 3) & BM_ENET_SWI_QMGR_CONGEST_STAT_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_QMGR_CONGEST_STAT, field QMGR_CONGEST_STAT_2 */

#define BP_ENET_SWI_QMGR_CONGEST_STAT_QMGR_CONGEST_STAT_2      2
#define BM_ENET_SWI_QMGR_CONGEST_STAT_QMGR_CONGEST_STAT_2      0x00000004

#define BF_ENET_SWI_QMGR_CONGEST_STAT_QMGR_CONGEST_STAT_2(v)   (((v) << 2) & BM_ENET_SWI_QMGR_CONGEST_STAT_QMGR_CONGEST_STAT_2)
/* --- Register HW_ENET_SWI_QMGR_CONGEST_STAT, field QMGR_CONGEST_STAT_1 */

#define BP_ENET_SWI_QMGR_CONGEST_STAT_QMGR_CONGEST_STAT_1      1
#define BM_ENET_SWI_QMGR_CONGEST_STAT_QMGR_CONGEST_STAT_1      0x00000002

#define BF_ENET_SWI_QMGR_CONGEST_STAT_QMGR_CONGEST_STAT_1(v)   (((v) << 1) & BM_ENET_SWI_QMGR_CONGEST_STAT_QMGR_CONGEST_STAT_1)
/* --- Register HW_ENET_SWI_QMGR_CONGEST_STAT, field QMGR_CONGEST_STAT_0 */

#define BP_ENET_SWI_QMGR_CONGEST_STAT_QMGR_CONGEST_STAT_0      0
#define BM_ENET_SWI_QMGR_CONGEST_STAT_QMGR_CONGEST_STAT_0      0x00000001

#define BF_ENET_SWI_QMGR_CONGEST_STAT_QMGR_CONGEST_STAT_0(v)   (((v) << 0) & BM_ENET_SWI_QMGR_CONGEST_STAT_QMGR_CONGEST_STAT_0)


/*
 * HW_ENET_SWI_QMGR_IFACE_STAT - ENET SWI Switch input and output interface status (internal).
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned OUTPUT_0  :  1;
        unsigned OUTPUT_1  :  1;
        unsigned OUTPUT_2  :  1;
        unsigned RSRVD0    : 13;
        unsigned INPUT_0   :  1;
        unsigned INPUT_1   :  1;
        unsigned INPUT_2   :  1;
        unsigned RSRVD1    : 13;
    } B;
} hw_enet_swi_qmgr_iface_stat_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_QMGR_IFACE_STAT register
 */
#define HW_ENET_SWI_QMGR_IFACE_STAT_ADDR         (REGS_ENET_BASE + 0x8090)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_QMGR_IFACE_STAT           (*(volatile hw_enet_swi_qmgr_iface_stat_t *) HW_ENET_SWI_QMGR_IFACE_STAT_ADDR)
#define HW_ENET_SWI_QMGR_IFACE_STAT_RD()      (HW_ENET_SWI_QMGR_IFACE_STAT.U)
#endif


/*
 * constants & macros for individual HW_ENET_SWI_QMGR_IFACE_STAT bitfields
 */
/* --- Register HW_ENET_SWI_QMGR_IFACE_STAT, field RSRVD1 */

#define BP_ENET_SWI_QMGR_IFACE_STAT_RSRVD1      19
#define BM_ENET_SWI_QMGR_IFACE_STAT_RSRVD1      0xFFF80000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_QMGR_IFACE_STAT_RSRVD1(v)   ((((reg32_t) v) << 19) & BM_ENET_SWI_QMGR_IFACE_STAT_RSRVD1)
#else
#define BF_ENET_SWI_QMGR_IFACE_STAT_RSRVD1(v)   (((v) << 19) & BM_ENET_SWI_QMGR_IFACE_STAT_RSRVD1)
#endif
/* --- Register HW_ENET_SWI_QMGR_IFACE_STAT, field INPUT_2 */

#define BP_ENET_SWI_QMGR_IFACE_STAT_INPUT_2      18
#define BM_ENET_SWI_QMGR_IFACE_STAT_INPUT_2      0x00040000

#define BF_ENET_SWI_QMGR_IFACE_STAT_INPUT_2(v)   (((v) << 18) & BM_ENET_SWI_QMGR_IFACE_STAT_INPUT_2)
/* --- Register HW_ENET_SWI_QMGR_IFACE_STAT, field INPUT_1 */

#define BP_ENET_SWI_QMGR_IFACE_STAT_INPUT_1      17
#define BM_ENET_SWI_QMGR_IFACE_STAT_INPUT_1      0x00020000

#define BF_ENET_SWI_QMGR_IFACE_STAT_INPUT_1(v)   (((v) << 17) & BM_ENET_SWI_QMGR_IFACE_STAT_INPUT_1)
/* --- Register HW_ENET_SWI_QMGR_IFACE_STAT, field INPUT_0 */

#define BP_ENET_SWI_QMGR_IFACE_STAT_INPUT_0      16
#define BM_ENET_SWI_QMGR_IFACE_STAT_INPUT_0      0x00010000

#define BF_ENET_SWI_QMGR_IFACE_STAT_INPUT_0(v)   (((v) << 16) & BM_ENET_SWI_QMGR_IFACE_STAT_INPUT_0)
/* --- Register HW_ENET_SWI_QMGR_IFACE_STAT, field RSRVD0 */

#define BP_ENET_SWI_QMGR_IFACE_STAT_RSRVD0      3
#define BM_ENET_SWI_QMGR_IFACE_STAT_RSRVD0      0x0000FFF8

#define BF_ENET_SWI_QMGR_IFACE_STAT_RSRVD0(v)   (((v) << 3) & BM_ENET_SWI_QMGR_IFACE_STAT_RSRVD0)
/* --- Register HW_ENET_SWI_QMGR_IFACE_STAT, field OUTPUT_2 */

#define BP_ENET_SWI_QMGR_IFACE_STAT_OUTPUT_2      2
#define BM_ENET_SWI_QMGR_IFACE_STAT_OUTPUT_2      0x00000004

#define BF_ENET_SWI_QMGR_IFACE_STAT_OUTPUT_2(v)   (((v) << 2) & BM_ENET_SWI_QMGR_IFACE_STAT_OUTPUT_2)
/* --- Register HW_ENET_SWI_QMGR_IFACE_STAT, field OUTPUT_1 */

#define BP_ENET_SWI_QMGR_IFACE_STAT_OUTPUT_1      1
#define BM_ENET_SWI_QMGR_IFACE_STAT_OUTPUT_1      0x00000002

#define BF_ENET_SWI_QMGR_IFACE_STAT_OUTPUT_1(v)   (((v) << 1) & BM_ENET_SWI_QMGR_IFACE_STAT_OUTPUT_1)
/* --- Register HW_ENET_SWI_QMGR_IFACE_STAT, field OUTPUT_0 */

#define BP_ENET_SWI_QMGR_IFACE_STAT_OUTPUT_0      0
#define BM_ENET_SWI_QMGR_IFACE_STAT_OUTPUT_0      0x00000001

#define BF_ENET_SWI_QMGR_IFACE_STAT_OUTPUT_0(v)   (((v) << 0) & BM_ENET_SWI_QMGR_IFACE_STAT_OUTPUT_0)


/*
 * HW_ENET_SWI_QM_WEIGHTS - ENET SWI Queue weights for each queue.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned QUEUE_0  :  5;
        unsigned RSRVD0   :  3;
        unsigned QUEUE_1  :  5;
        unsigned RSRVD1   :  3;
        unsigned QUEUE_2  :  5;
        unsigned RSRVD2   :  3;
        unsigned QUEUE_3  :  5;
        unsigned RSRVD3   :  3;
    } B;
} hw_enet_swi_qm_weights_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_QM_WEIGHTS register
 */
#define HW_ENET_SWI_QM_WEIGHTS_ADDR         (REGS_ENET_BASE + 0x8094)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_QM_WEIGHTS           (*(volatile hw_enet_swi_qm_weights_t *) HW_ENET_SWI_QM_WEIGHTS_ADDR)
#define HW_ENET_SWI_QM_WEIGHTS_RD()      (HW_ENET_SWI_QM_WEIGHTS.U)
#define HW_ENET_SWI_QM_WEIGHTS_WR(v)     (HW_ENET_SWI_QM_WEIGHTS.U = (v))
#define HW_ENET_SWI_QM_WEIGHTS_SET(v)    (HW_ENET_SWI_QM_WEIGHTS_WR(HW_ENET_SWI_QM_WEIGHTS_RD() |  (v)))
#define HW_ENET_SWI_QM_WEIGHTS_CLR(v)    (HW_ENET_SWI_QM_WEIGHTS_WR(HW_ENET_SWI_QM_WEIGHTS_RD() & ~(v)))
#define HW_ENET_SWI_QM_WEIGHTS_TOG(v)    (HW_ENET_SWI_QM_WEIGHTS_WR(HW_ENET_SWI_QM_WEIGHTS_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_QM_WEIGHTS bitfields
 */
/* --- Register HW_ENET_SWI_QM_WEIGHTS, field RSRVD3 */

#define BP_ENET_SWI_QM_WEIGHTS_RSRVD3      29
#define BM_ENET_SWI_QM_WEIGHTS_RSRVD3      0xE0000000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_QM_WEIGHTS_RSRVD3(v)   ((((reg32_t) v) << 29) & BM_ENET_SWI_QM_WEIGHTS_RSRVD3)
#else
#define BF_ENET_SWI_QM_WEIGHTS_RSRVD3(v)   (((v) << 29) & BM_ENET_SWI_QM_WEIGHTS_RSRVD3)
#endif
/* --- Register HW_ENET_SWI_QM_WEIGHTS, field QUEUE_3 */

#define BP_ENET_SWI_QM_WEIGHTS_QUEUE_3      24
#define BM_ENET_SWI_QM_WEIGHTS_QUEUE_3      0x1F000000

#define BF_ENET_SWI_QM_WEIGHTS_QUEUE_3(v)   (((v) << 24) & BM_ENET_SWI_QM_WEIGHTS_QUEUE_3)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_QM_WEIGHTS_QUEUE_3(v)   BF_CS1(ENET_SWI_QM_WEIGHTS, QUEUE_3, v)
#endif

/* --- Register HW_ENET_SWI_QM_WEIGHTS, field RSRVD2 */

#define BP_ENET_SWI_QM_WEIGHTS_RSRVD2      21
#define BM_ENET_SWI_QM_WEIGHTS_RSRVD2      0x00E00000

#define BF_ENET_SWI_QM_WEIGHTS_RSRVD2(v)   (((v) << 21) & BM_ENET_SWI_QM_WEIGHTS_RSRVD2)
/* --- Register HW_ENET_SWI_QM_WEIGHTS, field QUEUE_2 */

#define BP_ENET_SWI_QM_WEIGHTS_QUEUE_2      16
#define BM_ENET_SWI_QM_WEIGHTS_QUEUE_2      0x001F0000

#define BF_ENET_SWI_QM_WEIGHTS_QUEUE_2(v)   (((v) << 16) & BM_ENET_SWI_QM_WEIGHTS_QUEUE_2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_QM_WEIGHTS_QUEUE_2(v)   BF_CS1(ENET_SWI_QM_WEIGHTS, QUEUE_2, v)
#endif

/* --- Register HW_ENET_SWI_QM_WEIGHTS, field RSRVD1 */

#define BP_ENET_SWI_QM_WEIGHTS_RSRVD1      13
#define BM_ENET_SWI_QM_WEIGHTS_RSRVD1      0x0000E000

#define BF_ENET_SWI_QM_WEIGHTS_RSRVD1(v)   (((v) << 13) & BM_ENET_SWI_QM_WEIGHTS_RSRVD1)
/* --- Register HW_ENET_SWI_QM_WEIGHTS, field QUEUE_1 */

#define BP_ENET_SWI_QM_WEIGHTS_QUEUE_1      8
#define BM_ENET_SWI_QM_WEIGHTS_QUEUE_1      0x00001F00

#define BF_ENET_SWI_QM_WEIGHTS_QUEUE_1(v)   (((v) << 8) & BM_ENET_SWI_QM_WEIGHTS_QUEUE_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_QM_WEIGHTS_QUEUE_1(v)   BF_CS1(ENET_SWI_QM_WEIGHTS, QUEUE_1, v)
#endif

/* --- Register HW_ENET_SWI_QM_WEIGHTS, field RSRVD0 */

#define BP_ENET_SWI_QM_WEIGHTS_RSRVD0      5
#define BM_ENET_SWI_QM_WEIGHTS_RSRVD0      0x000000E0

#define BF_ENET_SWI_QM_WEIGHTS_RSRVD0(v)   (((v) << 5) & BM_ENET_SWI_QM_WEIGHTS_RSRVD0)
/* --- Register HW_ENET_SWI_QM_WEIGHTS, field QUEUE_0 */

#define BP_ENET_SWI_QM_WEIGHTS_QUEUE_0      0
#define BM_ENET_SWI_QM_WEIGHTS_QUEUE_0      0x0000001F

#define BF_ENET_SWI_QM_WEIGHTS_QUEUE_0(v)   (((v) << 0) & BM_ENET_SWI_QM_WEIGHTS_QUEUE_0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_QM_WEIGHTS_QUEUE_0(v)   BF_CS1(ENET_SWI_QM_WEIGHTS, QUEUE_0, v)
#endif



/*
 * HW_ENET_SWI_QMGR_MINCELLSP0 - ENET SWI Define congestion threshold for Port0 backpressure.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned QMGR_MINCELLSP0  :  8;
        unsigned RSRVD0           : 24;
    } B;
} hw_enet_swi_qmgr_mincellsp0_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_QMGR_MINCELLSP0 register
 */
#define HW_ENET_SWI_QMGR_MINCELLSP0_ADDR         (REGS_ENET_BASE + 0x809c)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_QMGR_MINCELLSP0           (*(volatile hw_enet_swi_qmgr_mincellsp0_t *) HW_ENET_SWI_QMGR_MINCELLSP0_ADDR)
#define HW_ENET_SWI_QMGR_MINCELLSP0_RD()      (HW_ENET_SWI_QMGR_MINCELLSP0.U)
#define HW_ENET_SWI_QMGR_MINCELLSP0_WR(v)     (HW_ENET_SWI_QMGR_MINCELLSP0.U = (v))
#define HW_ENET_SWI_QMGR_MINCELLSP0_SET(v)    (HW_ENET_SWI_QMGR_MINCELLSP0_WR(HW_ENET_SWI_QMGR_MINCELLSP0_RD() |  (v)))
#define HW_ENET_SWI_QMGR_MINCELLSP0_CLR(v)    (HW_ENET_SWI_QMGR_MINCELLSP0_WR(HW_ENET_SWI_QMGR_MINCELLSP0_RD() & ~(v)))
#define HW_ENET_SWI_QMGR_MINCELLSP0_TOG(v)    (HW_ENET_SWI_QMGR_MINCELLSP0_WR(HW_ENET_SWI_QMGR_MINCELLSP0_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_QMGR_MINCELLSP0 bitfields
 */
/* --- Register HW_ENET_SWI_QMGR_MINCELLSP0, field RSRVD0 */

#define BP_ENET_SWI_QMGR_MINCELLSP0_RSRVD0      8
#define BM_ENET_SWI_QMGR_MINCELLSP0_RSRVD0      0xFFFFFF00

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_QMGR_MINCELLSP0_RSRVD0(v)   ((((reg32_t) v) << 8) & BM_ENET_SWI_QMGR_MINCELLSP0_RSRVD0)
#else
#define BF_ENET_SWI_QMGR_MINCELLSP0_RSRVD0(v)   (((v) << 8) & BM_ENET_SWI_QMGR_MINCELLSP0_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_QMGR_MINCELLSP0, field QMGR_MINCELLSP0 */

#define BP_ENET_SWI_QMGR_MINCELLSP0_QMGR_MINCELLSP0      0
#define BM_ENET_SWI_QMGR_MINCELLSP0_QMGR_MINCELLSP0      0x000000FF

#define BF_ENET_SWI_QMGR_MINCELLSP0_QMGR_MINCELLSP0(v)   (((v) << 0) & BM_ENET_SWI_QMGR_MINCELLSP0_QMGR_MINCELLSP0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_QMGR_MINCELLSP0_QMGR_MINCELLSP0(v)   (HW_ENET_SWI_QMGR_MINCELLSP0.B.QMGR_MINCELLSP0 = (v))
#endif



/*
 * HW_ENET_SWI_FORCE_FWD_P0 - ENET SWI Enable forced forwarding for a frame processed from port 0
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned FORCE_ENABLE       :  1;
        unsigned RSRVD0             :  1;
        unsigned FORCE_DESTINATION  :  2;
        unsigned RSRVD1             : 28;
    } B;
} hw_enet_swi_force_fwd_p0_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_FORCE_FWD_P0 register
 */
#define HW_ENET_SWI_FORCE_FWD_P0_ADDR         (REGS_ENET_BASE + 0x80bc)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_FORCE_FWD_P0           (*(volatile hw_enet_swi_force_fwd_p0_t *) HW_ENET_SWI_FORCE_FWD_P0_ADDR)
#define HW_ENET_SWI_FORCE_FWD_P0_RD()      (HW_ENET_SWI_FORCE_FWD_P0.U)
#define HW_ENET_SWI_FORCE_FWD_P0_WR(v)     (HW_ENET_SWI_FORCE_FWD_P0.U = (v))
#define HW_ENET_SWI_FORCE_FWD_P0_SET(v)    (HW_ENET_SWI_FORCE_FWD_P0_WR(HW_ENET_SWI_FORCE_FWD_P0_RD() |  (v)))
#define HW_ENET_SWI_FORCE_FWD_P0_CLR(v)    (HW_ENET_SWI_FORCE_FWD_P0_WR(HW_ENET_SWI_FORCE_FWD_P0_RD() & ~(v)))
#define HW_ENET_SWI_FORCE_FWD_P0_TOG(v)    (HW_ENET_SWI_FORCE_FWD_P0_WR(HW_ENET_SWI_FORCE_FWD_P0_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_FORCE_FWD_P0 bitfields
 */
/* --- Register HW_ENET_SWI_FORCE_FWD_P0, field RSRVD1 */

#define BP_ENET_SWI_FORCE_FWD_P0_RSRVD1      4
#define BM_ENET_SWI_FORCE_FWD_P0_RSRVD1      0xFFFFFFF0

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_FORCE_FWD_P0_RSRVD1(v)   ((((reg32_t) v) << 4) & BM_ENET_SWI_FORCE_FWD_P0_RSRVD1)
#else
#define BF_ENET_SWI_FORCE_FWD_P0_RSRVD1(v)   (((v) << 4) & BM_ENET_SWI_FORCE_FWD_P0_RSRVD1)
#endif
/* --- Register HW_ENET_SWI_FORCE_FWD_P0, field FORCE_DESTINATION */

#define BP_ENET_SWI_FORCE_FWD_P0_FORCE_DESTINATION      2
#define BM_ENET_SWI_FORCE_FWD_P0_FORCE_DESTINATION      0x0000000C

#define BF_ENET_SWI_FORCE_FWD_P0_FORCE_DESTINATION(v)   (((v) << 2) & BM_ENET_SWI_FORCE_FWD_P0_FORCE_DESTINATION)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_FORCE_FWD_P0_FORCE_DESTINATION(v)   BF_CS1(ENET_SWI_FORCE_FWD_P0, FORCE_DESTINATION, v)
#endif

/* --- Register HW_ENET_SWI_FORCE_FWD_P0, field RSRVD0 */

#define BP_ENET_SWI_FORCE_FWD_P0_RSRVD0      1
#define BM_ENET_SWI_FORCE_FWD_P0_RSRVD0      0x00000002

#define BF_ENET_SWI_FORCE_FWD_P0_RSRVD0(v)   (((v) << 1) & BM_ENET_SWI_FORCE_FWD_P0_RSRVD0)
/* --- Register HW_ENET_SWI_FORCE_FWD_P0, field FORCE_ENABLE */

#define BP_ENET_SWI_FORCE_FWD_P0_FORCE_ENABLE      0
#define BM_ENET_SWI_FORCE_FWD_P0_FORCE_ENABLE      0x00000001

#define BF_ENET_SWI_FORCE_FWD_P0_FORCE_ENABLE(v)   (((v) << 0) & BM_ENET_SWI_FORCE_FWD_P0_FORCE_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_FORCE_FWD_P0_FORCE_ENABLE(v)   BF_CS1(ENET_SWI_FORCE_FWD_P0, FORCE_ENABLE, v)
#endif



/*
 * HW_ENET_SWI_PORTSNOOP1 - ENET SWI Port Snooping function. Eight independent entries are available.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ENABLE            :  1;
        unsigned MODE              :  2;
        unsigned COMPARE_DEST      :  1;
        unsigned COMPARE_SOURCE    :  1;
        unsigned RSRVD0            : 11;
        unsigned DESTINATION_PORT  : 16;
    } B;
} hw_enet_swi_portsnoop1_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_PORTSNOOP1 register
 */
#define HW_ENET_SWI_PORTSNOOP1_ADDR         (REGS_ENET_BASE + 0x80c0)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_PORTSNOOP1           (*(volatile hw_enet_swi_portsnoop1_t *) HW_ENET_SWI_PORTSNOOP1_ADDR)
#define HW_ENET_SWI_PORTSNOOP1_RD()      (HW_ENET_SWI_PORTSNOOP1.U)
#define HW_ENET_SWI_PORTSNOOP1_WR(v)     (HW_ENET_SWI_PORTSNOOP1.U = (v))
#define HW_ENET_SWI_PORTSNOOP1_SET(v)    (HW_ENET_SWI_PORTSNOOP1_WR(HW_ENET_SWI_PORTSNOOP1_RD() |  (v)))
#define HW_ENET_SWI_PORTSNOOP1_CLR(v)    (HW_ENET_SWI_PORTSNOOP1_WR(HW_ENET_SWI_PORTSNOOP1_RD() & ~(v)))
#define HW_ENET_SWI_PORTSNOOP1_TOG(v)    (HW_ENET_SWI_PORTSNOOP1_WR(HW_ENET_SWI_PORTSNOOP1_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_PORTSNOOP1 bitfields
 */
/* --- Register HW_ENET_SWI_PORTSNOOP1, field DESTINATION_PORT */

#define BP_ENET_SWI_PORTSNOOP1_DESTINATION_PORT      16
#define BM_ENET_SWI_PORTSNOOP1_DESTINATION_PORT      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_PORTSNOOP1_DESTINATION_PORT(v)   ((((reg32_t) v) << 16) & BM_ENET_SWI_PORTSNOOP1_DESTINATION_PORT)
#else
#define BF_ENET_SWI_PORTSNOOP1_DESTINATION_PORT(v)   (((v) << 16) & BM_ENET_SWI_PORTSNOOP1_DESTINATION_PORT)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PORTSNOOP1_DESTINATION_PORT(v)   (HW_ENET_SWI_PORTSNOOP1.B.DESTINATION_PORT = (v))
#endif

/* --- Register HW_ENET_SWI_PORTSNOOP1, field RSRVD0 */

#define BP_ENET_SWI_PORTSNOOP1_RSRVD0      5
#define BM_ENET_SWI_PORTSNOOP1_RSRVD0      0x0000FFE0

#define BF_ENET_SWI_PORTSNOOP1_RSRVD0(v)   (((v) << 5) & BM_ENET_SWI_PORTSNOOP1_RSRVD0)
/* --- Register HW_ENET_SWI_PORTSNOOP1, field COMPARE_SOURCE */

#define BP_ENET_SWI_PORTSNOOP1_COMPARE_SOURCE      4
#define BM_ENET_SWI_PORTSNOOP1_COMPARE_SOURCE      0x00000010

#define BF_ENET_SWI_PORTSNOOP1_COMPARE_SOURCE(v)   (((v) << 4) & BM_ENET_SWI_PORTSNOOP1_COMPARE_SOURCE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PORTSNOOP1_COMPARE_SOURCE(v)   BF_CS1(ENET_SWI_PORTSNOOP1, COMPARE_SOURCE, v)
#endif

/* --- Register HW_ENET_SWI_PORTSNOOP1, field COMPARE_DEST */

#define BP_ENET_SWI_PORTSNOOP1_COMPARE_DEST      3
#define BM_ENET_SWI_PORTSNOOP1_COMPARE_DEST      0x00000008

#define BF_ENET_SWI_PORTSNOOP1_COMPARE_DEST(v)   (((v) << 3) & BM_ENET_SWI_PORTSNOOP1_COMPARE_DEST)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PORTSNOOP1_COMPARE_DEST(v)   BF_CS1(ENET_SWI_PORTSNOOP1, COMPARE_DEST, v)
#endif

/* --- Register HW_ENET_SWI_PORTSNOOP1, field MODE */

#define BP_ENET_SWI_PORTSNOOP1_MODE      1
#define BM_ENET_SWI_PORTSNOOP1_MODE      0x00000006

#define BF_ENET_SWI_PORTSNOOP1_MODE(v)   (((v) << 1) & BM_ENET_SWI_PORTSNOOP1_MODE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PORTSNOOP1_MODE(v)   BF_CS1(ENET_SWI_PORTSNOOP1, MODE, v)
#endif

/* --- Register HW_ENET_SWI_PORTSNOOP1, field ENABLE */

#define BP_ENET_SWI_PORTSNOOP1_ENABLE      0
#define BM_ENET_SWI_PORTSNOOP1_ENABLE      0x00000001

#define BF_ENET_SWI_PORTSNOOP1_ENABLE(v)   (((v) << 0) & BM_ENET_SWI_PORTSNOOP1_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PORTSNOOP1_ENABLE(v)   BF_CS1(ENET_SWI_PORTSNOOP1, ENABLE, v)
#endif



/*
 * HW_ENET_SWI_PORTSNOOP2 - ENET SWI Port Snooping function. Eight independent entries are available.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ENABLE            :  1;
        unsigned MODE              :  2;
        unsigned COMPARE_DEST      :  1;
        unsigned COMPARE_SOURCE    :  1;
        unsigned RSRVD0            : 11;
        unsigned DESTINATION_PORT  : 16;
    } B;
} hw_enet_swi_portsnoop2_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_PORTSNOOP2 register
 */
#define HW_ENET_SWI_PORTSNOOP2_ADDR         (REGS_ENET_BASE + 0x80c4)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_PORTSNOOP2           (*(volatile hw_enet_swi_portsnoop2_t *) HW_ENET_SWI_PORTSNOOP2_ADDR)
#define HW_ENET_SWI_PORTSNOOP2_RD()      (HW_ENET_SWI_PORTSNOOP2.U)
#define HW_ENET_SWI_PORTSNOOP2_WR(v)     (HW_ENET_SWI_PORTSNOOP2.U = (v))
#define HW_ENET_SWI_PORTSNOOP2_SET(v)    (HW_ENET_SWI_PORTSNOOP2_WR(HW_ENET_SWI_PORTSNOOP2_RD() |  (v)))
#define HW_ENET_SWI_PORTSNOOP2_CLR(v)    (HW_ENET_SWI_PORTSNOOP2_WR(HW_ENET_SWI_PORTSNOOP2_RD() & ~(v)))
#define HW_ENET_SWI_PORTSNOOP2_TOG(v)    (HW_ENET_SWI_PORTSNOOP2_WR(HW_ENET_SWI_PORTSNOOP2_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_PORTSNOOP2 bitfields
 */
/* --- Register HW_ENET_SWI_PORTSNOOP2, field DESTINATION_PORT */

#define BP_ENET_SWI_PORTSNOOP2_DESTINATION_PORT      16
#define BM_ENET_SWI_PORTSNOOP2_DESTINATION_PORT      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_PORTSNOOP2_DESTINATION_PORT(v)   ((((reg32_t) v) << 16) & BM_ENET_SWI_PORTSNOOP2_DESTINATION_PORT)
#else
#define BF_ENET_SWI_PORTSNOOP2_DESTINATION_PORT(v)   (((v) << 16) & BM_ENET_SWI_PORTSNOOP2_DESTINATION_PORT)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PORTSNOOP2_DESTINATION_PORT(v)   (HW_ENET_SWI_PORTSNOOP2.B.DESTINATION_PORT = (v))
#endif

/* --- Register HW_ENET_SWI_PORTSNOOP2, field RSRVD0 */

#define BP_ENET_SWI_PORTSNOOP2_RSRVD0      5
#define BM_ENET_SWI_PORTSNOOP2_RSRVD0      0x0000FFE0

#define BF_ENET_SWI_PORTSNOOP2_RSRVD0(v)   (((v) << 5) & BM_ENET_SWI_PORTSNOOP2_RSRVD0)
/* --- Register HW_ENET_SWI_PORTSNOOP2, field COMPARE_SOURCE */

#define BP_ENET_SWI_PORTSNOOP2_COMPARE_SOURCE      4
#define BM_ENET_SWI_PORTSNOOP2_COMPARE_SOURCE      0x00000010

#define BF_ENET_SWI_PORTSNOOP2_COMPARE_SOURCE(v)   (((v) << 4) & BM_ENET_SWI_PORTSNOOP2_COMPARE_SOURCE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PORTSNOOP2_COMPARE_SOURCE(v)   BF_CS1(ENET_SWI_PORTSNOOP2, COMPARE_SOURCE, v)
#endif

/* --- Register HW_ENET_SWI_PORTSNOOP2, field COMPARE_DEST */

#define BP_ENET_SWI_PORTSNOOP2_COMPARE_DEST      3
#define BM_ENET_SWI_PORTSNOOP2_COMPARE_DEST      0x00000008

#define BF_ENET_SWI_PORTSNOOP2_COMPARE_DEST(v)   (((v) << 3) & BM_ENET_SWI_PORTSNOOP2_COMPARE_DEST)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PORTSNOOP2_COMPARE_DEST(v)   BF_CS1(ENET_SWI_PORTSNOOP2, COMPARE_DEST, v)
#endif

/* --- Register HW_ENET_SWI_PORTSNOOP2, field MODE */

#define BP_ENET_SWI_PORTSNOOP2_MODE      1
#define BM_ENET_SWI_PORTSNOOP2_MODE      0x00000006

#define BF_ENET_SWI_PORTSNOOP2_MODE(v)   (((v) << 1) & BM_ENET_SWI_PORTSNOOP2_MODE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PORTSNOOP2_MODE(v)   BF_CS1(ENET_SWI_PORTSNOOP2, MODE, v)
#endif

/* --- Register HW_ENET_SWI_PORTSNOOP2, field ENABLE */

#define BP_ENET_SWI_PORTSNOOP2_ENABLE      0
#define BM_ENET_SWI_PORTSNOOP2_ENABLE      0x00000001

#define BF_ENET_SWI_PORTSNOOP2_ENABLE(v)   (((v) << 0) & BM_ENET_SWI_PORTSNOOP2_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PORTSNOOP2_ENABLE(v)   BF_CS1(ENET_SWI_PORTSNOOP2, ENABLE, v)
#endif



/*
 * HW_ENET_SWI_PORTSNOOP3 - ENET SWI Port Snooping function. Eight independent entries are available.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ENABLE            :  1;
        unsigned MODE              :  2;
        unsigned COMPARE_DEST      :  1;
        unsigned COMPARE_SOURCE    :  1;
        unsigned RSRVD0            : 11;
        unsigned DESTINATION_PORT  : 16;
    } B;
} hw_enet_swi_portsnoop3_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_PORTSNOOP3 register
 */
#define HW_ENET_SWI_PORTSNOOP3_ADDR         (REGS_ENET_BASE + 0x80c8)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_PORTSNOOP3           (*(volatile hw_enet_swi_portsnoop3_t *) HW_ENET_SWI_PORTSNOOP3_ADDR)
#define HW_ENET_SWI_PORTSNOOP3_RD()      (HW_ENET_SWI_PORTSNOOP3.U)
#define HW_ENET_SWI_PORTSNOOP3_WR(v)     (HW_ENET_SWI_PORTSNOOP3.U = (v))
#define HW_ENET_SWI_PORTSNOOP3_SET(v)    (HW_ENET_SWI_PORTSNOOP3_WR(HW_ENET_SWI_PORTSNOOP3_RD() |  (v)))
#define HW_ENET_SWI_PORTSNOOP3_CLR(v)    (HW_ENET_SWI_PORTSNOOP3_WR(HW_ENET_SWI_PORTSNOOP3_RD() & ~(v)))
#define HW_ENET_SWI_PORTSNOOP3_TOG(v)    (HW_ENET_SWI_PORTSNOOP3_WR(HW_ENET_SWI_PORTSNOOP3_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_PORTSNOOP3 bitfields
 */
/* --- Register HW_ENET_SWI_PORTSNOOP3, field DESTINATION_PORT */

#define BP_ENET_SWI_PORTSNOOP3_DESTINATION_PORT      16
#define BM_ENET_SWI_PORTSNOOP3_DESTINATION_PORT      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_PORTSNOOP3_DESTINATION_PORT(v)   ((((reg32_t) v) << 16) & BM_ENET_SWI_PORTSNOOP3_DESTINATION_PORT)
#else
#define BF_ENET_SWI_PORTSNOOP3_DESTINATION_PORT(v)   (((v) << 16) & BM_ENET_SWI_PORTSNOOP3_DESTINATION_PORT)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PORTSNOOP3_DESTINATION_PORT(v)   (HW_ENET_SWI_PORTSNOOP3.B.DESTINATION_PORT = (v))
#endif

/* --- Register HW_ENET_SWI_PORTSNOOP3, field RSRVD0 */

#define BP_ENET_SWI_PORTSNOOP3_RSRVD0      5
#define BM_ENET_SWI_PORTSNOOP3_RSRVD0      0x0000FFE0

#define BF_ENET_SWI_PORTSNOOP3_RSRVD0(v)   (((v) << 5) & BM_ENET_SWI_PORTSNOOP3_RSRVD0)
/* --- Register HW_ENET_SWI_PORTSNOOP3, field COMPARE_SOURCE */

#define BP_ENET_SWI_PORTSNOOP3_COMPARE_SOURCE      4
#define BM_ENET_SWI_PORTSNOOP3_COMPARE_SOURCE      0x00000010

#define BF_ENET_SWI_PORTSNOOP3_COMPARE_SOURCE(v)   (((v) << 4) & BM_ENET_SWI_PORTSNOOP3_COMPARE_SOURCE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PORTSNOOP3_COMPARE_SOURCE(v)   BF_CS1(ENET_SWI_PORTSNOOP3, COMPARE_SOURCE, v)
#endif

/* --- Register HW_ENET_SWI_PORTSNOOP3, field COMPARE_DEST */

#define BP_ENET_SWI_PORTSNOOP3_COMPARE_DEST      3
#define BM_ENET_SWI_PORTSNOOP3_COMPARE_DEST      0x00000008

#define BF_ENET_SWI_PORTSNOOP3_COMPARE_DEST(v)   (((v) << 3) & BM_ENET_SWI_PORTSNOOP3_COMPARE_DEST)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PORTSNOOP3_COMPARE_DEST(v)   BF_CS1(ENET_SWI_PORTSNOOP3, COMPARE_DEST, v)
#endif

/* --- Register HW_ENET_SWI_PORTSNOOP3, field MODE */

#define BP_ENET_SWI_PORTSNOOP3_MODE      1
#define BM_ENET_SWI_PORTSNOOP3_MODE      0x00000006

#define BF_ENET_SWI_PORTSNOOP3_MODE(v)   (((v) << 1) & BM_ENET_SWI_PORTSNOOP3_MODE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PORTSNOOP3_MODE(v)   BF_CS1(ENET_SWI_PORTSNOOP3, MODE, v)
#endif

/* --- Register HW_ENET_SWI_PORTSNOOP3, field ENABLE */

#define BP_ENET_SWI_PORTSNOOP3_ENABLE      0
#define BM_ENET_SWI_PORTSNOOP3_ENABLE      0x00000001

#define BF_ENET_SWI_PORTSNOOP3_ENABLE(v)   (((v) << 0) & BM_ENET_SWI_PORTSNOOP3_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PORTSNOOP3_ENABLE(v)   BF_CS1(ENET_SWI_PORTSNOOP3, ENABLE, v)
#endif



/*
 * HW_ENET_SWI_PORTSNOOP4 - ENET SWI Port Snooping function. Eight independent entries are available.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ENABLE            :  1;
        unsigned MODE              :  2;
        unsigned COMPARE_DEST      :  1;
        unsigned COMPARE_SOURCE    :  1;
        unsigned RSRVD0            : 11;
        unsigned DESTINATION_PORT  : 16;
    } B;
} hw_enet_swi_portsnoop4_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_PORTSNOOP4 register
 */
#define HW_ENET_SWI_PORTSNOOP4_ADDR         (REGS_ENET_BASE + 0x80cc)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_PORTSNOOP4           (*(volatile hw_enet_swi_portsnoop4_t *) HW_ENET_SWI_PORTSNOOP4_ADDR)
#define HW_ENET_SWI_PORTSNOOP4_RD()      (HW_ENET_SWI_PORTSNOOP4.U)
#define HW_ENET_SWI_PORTSNOOP4_WR(v)     (HW_ENET_SWI_PORTSNOOP4.U = (v))
#define HW_ENET_SWI_PORTSNOOP4_SET(v)    (HW_ENET_SWI_PORTSNOOP4_WR(HW_ENET_SWI_PORTSNOOP4_RD() |  (v)))
#define HW_ENET_SWI_PORTSNOOP4_CLR(v)    (HW_ENET_SWI_PORTSNOOP4_WR(HW_ENET_SWI_PORTSNOOP4_RD() & ~(v)))
#define HW_ENET_SWI_PORTSNOOP4_TOG(v)    (HW_ENET_SWI_PORTSNOOP4_WR(HW_ENET_SWI_PORTSNOOP4_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_PORTSNOOP4 bitfields
 */
/* --- Register HW_ENET_SWI_PORTSNOOP4, field DESTINATION_PORT */

#define BP_ENET_SWI_PORTSNOOP4_DESTINATION_PORT      16
#define BM_ENET_SWI_PORTSNOOP4_DESTINATION_PORT      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_PORTSNOOP4_DESTINATION_PORT(v)   ((((reg32_t) v) << 16) & BM_ENET_SWI_PORTSNOOP4_DESTINATION_PORT)
#else
#define BF_ENET_SWI_PORTSNOOP4_DESTINATION_PORT(v)   (((v) << 16) & BM_ENET_SWI_PORTSNOOP4_DESTINATION_PORT)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PORTSNOOP4_DESTINATION_PORT(v)   (HW_ENET_SWI_PORTSNOOP4.B.DESTINATION_PORT = (v))
#endif

/* --- Register HW_ENET_SWI_PORTSNOOP4, field RSRVD0 */

#define BP_ENET_SWI_PORTSNOOP4_RSRVD0      5
#define BM_ENET_SWI_PORTSNOOP4_RSRVD0      0x0000FFE0

#define BF_ENET_SWI_PORTSNOOP4_RSRVD0(v)   (((v) << 5) & BM_ENET_SWI_PORTSNOOP4_RSRVD0)
/* --- Register HW_ENET_SWI_PORTSNOOP4, field COMPARE_SOURCE */

#define BP_ENET_SWI_PORTSNOOP4_COMPARE_SOURCE      4
#define BM_ENET_SWI_PORTSNOOP4_COMPARE_SOURCE      0x00000010

#define BF_ENET_SWI_PORTSNOOP4_COMPARE_SOURCE(v)   (((v) << 4) & BM_ENET_SWI_PORTSNOOP4_COMPARE_SOURCE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PORTSNOOP4_COMPARE_SOURCE(v)   BF_CS1(ENET_SWI_PORTSNOOP4, COMPARE_SOURCE, v)
#endif

/* --- Register HW_ENET_SWI_PORTSNOOP4, field COMPARE_DEST */

#define BP_ENET_SWI_PORTSNOOP4_COMPARE_DEST      3
#define BM_ENET_SWI_PORTSNOOP4_COMPARE_DEST      0x00000008

#define BF_ENET_SWI_PORTSNOOP4_COMPARE_DEST(v)   (((v) << 3) & BM_ENET_SWI_PORTSNOOP4_COMPARE_DEST)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PORTSNOOP4_COMPARE_DEST(v)   BF_CS1(ENET_SWI_PORTSNOOP4, COMPARE_DEST, v)
#endif

/* --- Register HW_ENET_SWI_PORTSNOOP4, field MODE */

#define BP_ENET_SWI_PORTSNOOP4_MODE      1
#define BM_ENET_SWI_PORTSNOOP4_MODE      0x00000006

#define BF_ENET_SWI_PORTSNOOP4_MODE(v)   (((v) << 1) & BM_ENET_SWI_PORTSNOOP4_MODE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PORTSNOOP4_MODE(v)   BF_CS1(ENET_SWI_PORTSNOOP4, MODE, v)
#endif

/* --- Register HW_ENET_SWI_PORTSNOOP4, field ENABLE */

#define BP_ENET_SWI_PORTSNOOP4_ENABLE      0
#define BM_ENET_SWI_PORTSNOOP4_ENABLE      0x00000001

#define BF_ENET_SWI_PORTSNOOP4_ENABLE(v)   (((v) << 0) & BM_ENET_SWI_PORTSNOOP4_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PORTSNOOP4_ENABLE(v)   BF_CS1(ENET_SWI_PORTSNOOP4, ENABLE, v)
#endif



/*
 * HW_ENET_SWI_PORTSNOOP5 - ENET SWI Port Snooping function. Eight independent entries are available.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ENABLE            :  1;
        unsigned MODE              :  2;
        unsigned COMPARE_DEST      :  1;
        unsigned COMPARE_SOURCE    :  1;
        unsigned RSRVD0            : 11;
        unsigned DESTINATION_PORT  : 16;
    } B;
} hw_enet_swi_portsnoop5_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_PORTSNOOP5 register
 */
#define HW_ENET_SWI_PORTSNOOP5_ADDR         (REGS_ENET_BASE + 0x80d0)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_PORTSNOOP5           (*(volatile hw_enet_swi_portsnoop5_t *) HW_ENET_SWI_PORTSNOOP5_ADDR)
#define HW_ENET_SWI_PORTSNOOP5_RD()      (HW_ENET_SWI_PORTSNOOP5.U)
#define HW_ENET_SWI_PORTSNOOP5_WR(v)     (HW_ENET_SWI_PORTSNOOP5.U = (v))
#define HW_ENET_SWI_PORTSNOOP5_SET(v)    (HW_ENET_SWI_PORTSNOOP5_WR(HW_ENET_SWI_PORTSNOOP5_RD() |  (v)))
#define HW_ENET_SWI_PORTSNOOP5_CLR(v)    (HW_ENET_SWI_PORTSNOOP5_WR(HW_ENET_SWI_PORTSNOOP5_RD() & ~(v)))
#define HW_ENET_SWI_PORTSNOOP5_TOG(v)    (HW_ENET_SWI_PORTSNOOP5_WR(HW_ENET_SWI_PORTSNOOP5_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_PORTSNOOP5 bitfields
 */
/* --- Register HW_ENET_SWI_PORTSNOOP5, field DESTINATION_PORT */

#define BP_ENET_SWI_PORTSNOOP5_DESTINATION_PORT      16
#define BM_ENET_SWI_PORTSNOOP5_DESTINATION_PORT      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_PORTSNOOP5_DESTINATION_PORT(v)   ((((reg32_t) v) << 16) & BM_ENET_SWI_PORTSNOOP5_DESTINATION_PORT)
#else
#define BF_ENET_SWI_PORTSNOOP5_DESTINATION_PORT(v)   (((v) << 16) & BM_ENET_SWI_PORTSNOOP5_DESTINATION_PORT)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PORTSNOOP5_DESTINATION_PORT(v)   (HW_ENET_SWI_PORTSNOOP5.B.DESTINATION_PORT = (v))
#endif

/* --- Register HW_ENET_SWI_PORTSNOOP5, field RSRVD0 */

#define BP_ENET_SWI_PORTSNOOP5_RSRVD0      5
#define BM_ENET_SWI_PORTSNOOP5_RSRVD0      0x0000FFE0

#define BF_ENET_SWI_PORTSNOOP5_RSRVD0(v)   (((v) << 5) & BM_ENET_SWI_PORTSNOOP5_RSRVD0)
/* --- Register HW_ENET_SWI_PORTSNOOP5, field COMPARE_SOURCE */

#define BP_ENET_SWI_PORTSNOOP5_COMPARE_SOURCE      4
#define BM_ENET_SWI_PORTSNOOP5_COMPARE_SOURCE      0x00000010

#define BF_ENET_SWI_PORTSNOOP5_COMPARE_SOURCE(v)   (((v) << 4) & BM_ENET_SWI_PORTSNOOP5_COMPARE_SOURCE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PORTSNOOP5_COMPARE_SOURCE(v)   BF_CS1(ENET_SWI_PORTSNOOP5, COMPARE_SOURCE, v)
#endif

/* --- Register HW_ENET_SWI_PORTSNOOP5, field COMPARE_DEST */

#define BP_ENET_SWI_PORTSNOOP5_COMPARE_DEST      3
#define BM_ENET_SWI_PORTSNOOP5_COMPARE_DEST      0x00000008

#define BF_ENET_SWI_PORTSNOOP5_COMPARE_DEST(v)   (((v) << 3) & BM_ENET_SWI_PORTSNOOP5_COMPARE_DEST)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PORTSNOOP5_COMPARE_DEST(v)   BF_CS1(ENET_SWI_PORTSNOOP5, COMPARE_DEST, v)
#endif

/* --- Register HW_ENET_SWI_PORTSNOOP5, field MODE */

#define BP_ENET_SWI_PORTSNOOP5_MODE      1
#define BM_ENET_SWI_PORTSNOOP5_MODE      0x00000006

#define BF_ENET_SWI_PORTSNOOP5_MODE(v)   (((v) << 1) & BM_ENET_SWI_PORTSNOOP5_MODE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PORTSNOOP5_MODE(v)   BF_CS1(ENET_SWI_PORTSNOOP5, MODE, v)
#endif

/* --- Register HW_ENET_SWI_PORTSNOOP5, field ENABLE */

#define BP_ENET_SWI_PORTSNOOP5_ENABLE      0
#define BM_ENET_SWI_PORTSNOOP5_ENABLE      0x00000001

#define BF_ENET_SWI_PORTSNOOP5_ENABLE(v)   (((v) << 0) & BM_ENET_SWI_PORTSNOOP5_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PORTSNOOP5_ENABLE(v)   BF_CS1(ENET_SWI_PORTSNOOP5, ENABLE, v)
#endif



/*
 * HW_ENET_SWI_PORTSNOOP6 - ENET SWI Port Snooping function. Eight independent entries are available.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ENABLE            :  1;
        unsigned MODE              :  2;
        unsigned COMPARE_DEST      :  1;
        unsigned COMPARE_SOURCE    :  1;
        unsigned RSRVD0            : 11;
        unsigned DESTINATION_PORT  : 16;
    } B;
} hw_enet_swi_portsnoop6_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_PORTSNOOP6 register
 */
#define HW_ENET_SWI_PORTSNOOP6_ADDR         (REGS_ENET_BASE + 0x80d4)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_PORTSNOOP6           (*(volatile hw_enet_swi_portsnoop6_t *) HW_ENET_SWI_PORTSNOOP6_ADDR)
#define HW_ENET_SWI_PORTSNOOP6_RD()      (HW_ENET_SWI_PORTSNOOP6.U)
#define HW_ENET_SWI_PORTSNOOP6_WR(v)     (HW_ENET_SWI_PORTSNOOP6.U = (v))
#define HW_ENET_SWI_PORTSNOOP6_SET(v)    (HW_ENET_SWI_PORTSNOOP6_WR(HW_ENET_SWI_PORTSNOOP6_RD() |  (v)))
#define HW_ENET_SWI_PORTSNOOP6_CLR(v)    (HW_ENET_SWI_PORTSNOOP6_WR(HW_ENET_SWI_PORTSNOOP6_RD() & ~(v)))
#define HW_ENET_SWI_PORTSNOOP6_TOG(v)    (HW_ENET_SWI_PORTSNOOP6_WR(HW_ENET_SWI_PORTSNOOP6_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_PORTSNOOP6 bitfields
 */
/* --- Register HW_ENET_SWI_PORTSNOOP6, field DESTINATION_PORT */

#define BP_ENET_SWI_PORTSNOOP6_DESTINATION_PORT      16
#define BM_ENET_SWI_PORTSNOOP6_DESTINATION_PORT      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_PORTSNOOP6_DESTINATION_PORT(v)   ((((reg32_t) v) << 16) & BM_ENET_SWI_PORTSNOOP6_DESTINATION_PORT)
#else
#define BF_ENET_SWI_PORTSNOOP6_DESTINATION_PORT(v)   (((v) << 16) & BM_ENET_SWI_PORTSNOOP6_DESTINATION_PORT)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PORTSNOOP6_DESTINATION_PORT(v)   (HW_ENET_SWI_PORTSNOOP6.B.DESTINATION_PORT = (v))
#endif

/* --- Register HW_ENET_SWI_PORTSNOOP6, field RSRVD0 */

#define BP_ENET_SWI_PORTSNOOP6_RSRVD0      5
#define BM_ENET_SWI_PORTSNOOP6_RSRVD0      0x0000FFE0

#define BF_ENET_SWI_PORTSNOOP6_RSRVD0(v)   (((v) << 5) & BM_ENET_SWI_PORTSNOOP6_RSRVD0)
/* --- Register HW_ENET_SWI_PORTSNOOP6, field COMPARE_SOURCE */

#define BP_ENET_SWI_PORTSNOOP6_COMPARE_SOURCE      4
#define BM_ENET_SWI_PORTSNOOP6_COMPARE_SOURCE      0x00000010

#define BF_ENET_SWI_PORTSNOOP6_COMPARE_SOURCE(v)   (((v) << 4) & BM_ENET_SWI_PORTSNOOP6_COMPARE_SOURCE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PORTSNOOP6_COMPARE_SOURCE(v)   BF_CS1(ENET_SWI_PORTSNOOP6, COMPARE_SOURCE, v)
#endif

/* --- Register HW_ENET_SWI_PORTSNOOP6, field COMPARE_DEST */

#define BP_ENET_SWI_PORTSNOOP6_COMPARE_DEST      3
#define BM_ENET_SWI_PORTSNOOP6_COMPARE_DEST      0x00000008

#define BF_ENET_SWI_PORTSNOOP6_COMPARE_DEST(v)   (((v) << 3) & BM_ENET_SWI_PORTSNOOP6_COMPARE_DEST)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PORTSNOOP6_COMPARE_DEST(v)   BF_CS1(ENET_SWI_PORTSNOOP6, COMPARE_DEST, v)
#endif

/* --- Register HW_ENET_SWI_PORTSNOOP6, field MODE */

#define BP_ENET_SWI_PORTSNOOP6_MODE      1
#define BM_ENET_SWI_PORTSNOOP6_MODE      0x00000006

#define BF_ENET_SWI_PORTSNOOP6_MODE(v)   (((v) << 1) & BM_ENET_SWI_PORTSNOOP6_MODE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PORTSNOOP6_MODE(v)   BF_CS1(ENET_SWI_PORTSNOOP6, MODE, v)
#endif

/* --- Register HW_ENET_SWI_PORTSNOOP6, field ENABLE */

#define BP_ENET_SWI_PORTSNOOP6_ENABLE      0
#define BM_ENET_SWI_PORTSNOOP6_ENABLE      0x00000001

#define BF_ENET_SWI_PORTSNOOP6_ENABLE(v)   (((v) << 0) & BM_ENET_SWI_PORTSNOOP6_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PORTSNOOP6_ENABLE(v)   BF_CS1(ENET_SWI_PORTSNOOP6, ENABLE, v)
#endif



/*
 * HW_ENET_SWI_PORTSNOOP7 - ENET SWI Port Snooping function. Eight independent entries are available.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ENABLE            :  1;
        unsigned MODE              :  2;
        unsigned COMPARE_DEST      :  1;
        unsigned COMPARE_SOURCE    :  1;
        unsigned RSRVD0            : 11;
        unsigned DESTINATION_PORT  : 16;
    } B;
} hw_enet_swi_portsnoop7_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_PORTSNOOP7 register
 */
#define HW_ENET_SWI_PORTSNOOP7_ADDR         (REGS_ENET_BASE + 0x80d8)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_PORTSNOOP7           (*(volatile hw_enet_swi_portsnoop7_t *) HW_ENET_SWI_PORTSNOOP7_ADDR)
#define HW_ENET_SWI_PORTSNOOP7_RD()      (HW_ENET_SWI_PORTSNOOP7.U)
#define HW_ENET_SWI_PORTSNOOP7_WR(v)     (HW_ENET_SWI_PORTSNOOP7.U = (v))
#define HW_ENET_SWI_PORTSNOOP7_SET(v)    (HW_ENET_SWI_PORTSNOOP7_WR(HW_ENET_SWI_PORTSNOOP7_RD() |  (v)))
#define HW_ENET_SWI_PORTSNOOP7_CLR(v)    (HW_ENET_SWI_PORTSNOOP7_WR(HW_ENET_SWI_PORTSNOOP7_RD() & ~(v)))
#define HW_ENET_SWI_PORTSNOOP7_TOG(v)    (HW_ENET_SWI_PORTSNOOP7_WR(HW_ENET_SWI_PORTSNOOP7_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_PORTSNOOP7 bitfields
 */
/* --- Register HW_ENET_SWI_PORTSNOOP7, field DESTINATION_PORT */

#define BP_ENET_SWI_PORTSNOOP7_DESTINATION_PORT      16
#define BM_ENET_SWI_PORTSNOOP7_DESTINATION_PORT      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_PORTSNOOP7_DESTINATION_PORT(v)   ((((reg32_t) v) << 16) & BM_ENET_SWI_PORTSNOOP7_DESTINATION_PORT)
#else
#define BF_ENET_SWI_PORTSNOOP7_DESTINATION_PORT(v)   (((v) << 16) & BM_ENET_SWI_PORTSNOOP7_DESTINATION_PORT)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PORTSNOOP7_DESTINATION_PORT(v)   (HW_ENET_SWI_PORTSNOOP7.B.DESTINATION_PORT = (v))
#endif

/* --- Register HW_ENET_SWI_PORTSNOOP7, field RSRVD0 */

#define BP_ENET_SWI_PORTSNOOP7_RSRVD0      5
#define BM_ENET_SWI_PORTSNOOP7_RSRVD0      0x0000FFE0

#define BF_ENET_SWI_PORTSNOOP7_RSRVD0(v)   (((v) << 5) & BM_ENET_SWI_PORTSNOOP7_RSRVD0)
/* --- Register HW_ENET_SWI_PORTSNOOP7, field COMPARE_SOURCE */

#define BP_ENET_SWI_PORTSNOOP7_COMPARE_SOURCE      4
#define BM_ENET_SWI_PORTSNOOP7_COMPARE_SOURCE      0x00000010

#define BF_ENET_SWI_PORTSNOOP7_COMPARE_SOURCE(v)   (((v) << 4) & BM_ENET_SWI_PORTSNOOP7_COMPARE_SOURCE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PORTSNOOP7_COMPARE_SOURCE(v)   BF_CS1(ENET_SWI_PORTSNOOP7, COMPARE_SOURCE, v)
#endif

/* --- Register HW_ENET_SWI_PORTSNOOP7, field COMPARE_DEST */

#define BP_ENET_SWI_PORTSNOOP7_COMPARE_DEST      3
#define BM_ENET_SWI_PORTSNOOP7_COMPARE_DEST      0x00000008

#define BF_ENET_SWI_PORTSNOOP7_COMPARE_DEST(v)   (((v) << 3) & BM_ENET_SWI_PORTSNOOP7_COMPARE_DEST)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PORTSNOOP7_COMPARE_DEST(v)   BF_CS1(ENET_SWI_PORTSNOOP7, COMPARE_DEST, v)
#endif

/* --- Register HW_ENET_SWI_PORTSNOOP7, field MODE */

#define BP_ENET_SWI_PORTSNOOP7_MODE      1
#define BM_ENET_SWI_PORTSNOOP7_MODE      0x00000006

#define BF_ENET_SWI_PORTSNOOP7_MODE(v)   (((v) << 1) & BM_ENET_SWI_PORTSNOOP7_MODE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PORTSNOOP7_MODE(v)   BF_CS1(ENET_SWI_PORTSNOOP7, MODE, v)
#endif

/* --- Register HW_ENET_SWI_PORTSNOOP7, field ENABLE */

#define BP_ENET_SWI_PORTSNOOP7_ENABLE      0
#define BM_ENET_SWI_PORTSNOOP7_ENABLE      0x00000001

#define BF_ENET_SWI_PORTSNOOP7_ENABLE(v)   (((v) << 0) & BM_ENET_SWI_PORTSNOOP7_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PORTSNOOP7_ENABLE(v)   BF_CS1(ENET_SWI_PORTSNOOP7, ENABLE, v)
#endif



/*
 * HW_ENET_SWI_PORTSNOOP8 - ENET SWI Port Snooping function. Eight independent entries are available.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ENABLE            :  1;
        unsigned MODE              :  2;
        unsigned COMPARE_DEST      :  1;
        unsigned COMPARE_SOURCE    :  1;
        unsigned RSRVD0            : 11;
        unsigned DESTINATION_PORT  : 16;
    } B;
} hw_enet_swi_portsnoop8_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_PORTSNOOP8 register
 */
#define HW_ENET_SWI_PORTSNOOP8_ADDR         (REGS_ENET_BASE + 0x80dc)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_PORTSNOOP8           (*(volatile hw_enet_swi_portsnoop8_t *) HW_ENET_SWI_PORTSNOOP8_ADDR)
#define HW_ENET_SWI_PORTSNOOP8_RD()      (HW_ENET_SWI_PORTSNOOP8.U)
#define HW_ENET_SWI_PORTSNOOP8_WR(v)     (HW_ENET_SWI_PORTSNOOP8.U = (v))
#define HW_ENET_SWI_PORTSNOOP8_SET(v)    (HW_ENET_SWI_PORTSNOOP8_WR(HW_ENET_SWI_PORTSNOOP8_RD() |  (v)))
#define HW_ENET_SWI_PORTSNOOP8_CLR(v)    (HW_ENET_SWI_PORTSNOOP8_WR(HW_ENET_SWI_PORTSNOOP8_RD() & ~(v)))
#define HW_ENET_SWI_PORTSNOOP8_TOG(v)    (HW_ENET_SWI_PORTSNOOP8_WR(HW_ENET_SWI_PORTSNOOP8_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_PORTSNOOP8 bitfields
 */
/* --- Register HW_ENET_SWI_PORTSNOOP8, field DESTINATION_PORT */

#define BP_ENET_SWI_PORTSNOOP8_DESTINATION_PORT      16
#define BM_ENET_SWI_PORTSNOOP8_DESTINATION_PORT      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_PORTSNOOP8_DESTINATION_PORT(v)   ((((reg32_t) v) << 16) & BM_ENET_SWI_PORTSNOOP8_DESTINATION_PORT)
#else
#define BF_ENET_SWI_PORTSNOOP8_DESTINATION_PORT(v)   (((v) << 16) & BM_ENET_SWI_PORTSNOOP8_DESTINATION_PORT)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PORTSNOOP8_DESTINATION_PORT(v)   (HW_ENET_SWI_PORTSNOOP8.B.DESTINATION_PORT = (v))
#endif

/* --- Register HW_ENET_SWI_PORTSNOOP8, field RSRVD0 */

#define BP_ENET_SWI_PORTSNOOP8_RSRVD0      5
#define BM_ENET_SWI_PORTSNOOP8_RSRVD0      0x0000FFE0

#define BF_ENET_SWI_PORTSNOOP8_RSRVD0(v)   (((v) << 5) & BM_ENET_SWI_PORTSNOOP8_RSRVD0)
/* --- Register HW_ENET_SWI_PORTSNOOP8, field COMPARE_SOURCE */

#define BP_ENET_SWI_PORTSNOOP8_COMPARE_SOURCE      4
#define BM_ENET_SWI_PORTSNOOP8_COMPARE_SOURCE      0x00000010

#define BF_ENET_SWI_PORTSNOOP8_COMPARE_SOURCE(v)   (((v) << 4) & BM_ENET_SWI_PORTSNOOP8_COMPARE_SOURCE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PORTSNOOP8_COMPARE_SOURCE(v)   BF_CS1(ENET_SWI_PORTSNOOP8, COMPARE_SOURCE, v)
#endif

/* --- Register HW_ENET_SWI_PORTSNOOP8, field COMPARE_DEST */

#define BP_ENET_SWI_PORTSNOOP8_COMPARE_DEST      3
#define BM_ENET_SWI_PORTSNOOP8_COMPARE_DEST      0x00000008

#define BF_ENET_SWI_PORTSNOOP8_COMPARE_DEST(v)   (((v) << 3) & BM_ENET_SWI_PORTSNOOP8_COMPARE_DEST)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PORTSNOOP8_COMPARE_DEST(v)   BF_CS1(ENET_SWI_PORTSNOOP8, COMPARE_DEST, v)
#endif

/* --- Register HW_ENET_SWI_PORTSNOOP8, field MODE */

#define BP_ENET_SWI_PORTSNOOP8_MODE      1
#define BM_ENET_SWI_PORTSNOOP8_MODE      0x00000006

#define BF_ENET_SWI_PORTSNOOP8_MODE(v)   (((v) << 1) & BM_ENET_SWI_PORTSNOOP8_MODE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PORTSNOOP8_MODE(v)   BF_CS1(ENET_SWI_PORTSNOOP8, MODE, v)
#endif

/* --- Register HW_ENET_SWI_PORTSNOOP8, field ENABLE */

#define BP_ENET_SWI_PORTSNOOP8_ENABLE      0
#define BM_ENET_SWI_PORTSNOOP8_ENABLE      0x00000001

#define BF_ENET_SWI_PORTSNOOP8_ENABLE(v)   (((v) << 0) & BM_ENET_SWI_PORTSNOOP8_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PORTSNOOP8_ENABLE(v)   BF_CS1(ENET_SWI_PORTSNOOP8, ENABLE, v)
#endif



/*
 * HW_ENET_SWI_IPSNOOP1 - ENET SWI IP Snooping function1
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ENABLE    :  1;
        unsigned MODE      :  2;
        unsigned RSRVD0    :  5;
        unsigned PROTOCOL  :  8;
        unsigned RSRVD1    : 16;
    } B;
} hw_enet_swi_ipsnoop1_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_IPSNOOP1 register
 */
#define HW_ENET_SWI_IPSNOOP1_ADDR         (REGS_ENET_BASE + 0x80e0)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_IPSNOOP1           (*(volatile hw_enet_swi_ipsnoop1_t *) HW_ENET_SWI_IPSNOOP1_ADDR)
#define HW_ENET_SWI_IPSNOOP1_RD()      (HW_ENET_SWI_IPSNOOP1.U)
#define HW_ENET_SWI_IPSNOOP1_WR(v)     (HW_ENET_SWI_IPSNOOP1.U = (v))
#define HW_ENET_SWI_IPSNOOP1_SET(v)    (HW_ENET_SWI_IPSNOOP1_WR(HW_ENET_SWI_IPSNOOP1_RD() |  (v)))
#define HW_ENET_SWI_IPSNOOP1_CLR(v)    (HW_ENET_SWI_IPSNOOP1_WR(HW_ENET_SWI_IPSNOOP1_RD() & ~(v)))
#define HW_ENET_SWI_IPSNOOP1_TOG(v)    (HW_ENET_SWI_IPSNOOP1_WR(HW_ENET_SWI_IPSNOOP1_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_IPSNOOP1 bitfields
 */
/* --- Register HW_ENET_SWI_IPSNOOP1, field RSRVD1 */

#define BP_ENET_SWI_IPSNOOP1_RSRVD1      16
#define BM_ENET_SWI_IPSNOOP1_RSRVD1      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_IPSNOOP1_RSRVD1(v)   ((((reg32_t) v) << 16) & BM_ENET_SWI_IPSNOOP1_RSRVD1)
#else
#define BF_ENET_SWI_IPSNOOP1_RSRVD1(v)   (((v) << 16) & BM_ENET_SWI_IPSNOOP1_RSRVD1)
#endif
/* --- Register HW_ENET_SWI_IPSNOOP1, field PROTOCOL */

#define BP_ENET_SWI_IPSNOOP1_PROTOCOL      8
#define BM_ENET_SWI_IPSNOOP1_PROTOCOL      0x0000FF00

#define BF_ENET_SWI_IPSNOOP1_PROTOCOL(v)   (((v) << 8) & BM_ENET_SWI_IPSNOOP1_PROTOCOL)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_IPSNOOP1_PROTOCOL(v)   (HW_ENET_SWI_IPSNOOP1.B.PROTOCOL = (v))
#endif

/* --- Register HW_ENET_SWI_IPSNOOP1, field RSRVD0 */

#define BP_ENET_SWI_IPSNOOP1_RSRVD0      3
#define BM_ENET_SWI_IPSNOOP1_RSRVD0      0x000000F8

#define BF_ENET_SWI_IPSNOOP1_RSRVD0(v)   (((v) << 3) & BM_ENET_SWI_IPSNOOP1_RSRVD0)
/* --- Register HW_ENET_SWI_IPSNOOP1, field MODE */

#define BP_ENET_SWI_IPSNOOP1_MODE      1
#define BM_ENET_SWI_IPSNOOP1_MODE      0x00000006

#define BF_ENET_SWI_IPSNOOP1_MODE(v)   (((v) << 1) & BM_ENET_SWI_IPSNOOP1_MODE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_IPSNOOP1_MODE(v)   BF_CS1(ENET_SWI_IPSNOOP1, MODE, v)
#endif

/* --- Register HW_ENET_SWI_IPSNOOP1, field ENABLE */

#define BP_ENET_SWI_IPSNOOP1_ENABLE      0
#define BM_ENET_SWI_IPSNOOP1_ENABLE      0x00000001

#define BF_ENET_SWI_IPSNOOP1_ENABLE(v)   (((v) << 0) & BM_ENET_SWI_IPSNOOP1_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_IPSNOOP1_ENABLE(v)   BF_CS1(ENET_SWI_IPSNOOP1, ENABLE, v)
#endif



/*
 * HW_ENET_SWI_IPSNOOP2 - ENET SWI IP Snooping function2
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ENABLE    :  1;
        unsigned MODE      :  2;
        unsigned RSRVD0    :  5;
        unsigned PROTOCOL  :  8;
        unsigned RSRVD1    : 16;
    } B;
} hw_enet_swi_ipsnoop2_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_IPSNOOP2 register
 */
#define HW_ENET_SWI_IPSNOOP2_ADDR         (REGS_ENET_BASE + 0x80e4)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_IPSNOOP2           (*(volatile hw_enet_swi_ipsnoop2_t *) HW_ENET_SWI_IPSNOOP2_ADDR)
#define HW_ENET_SWI_IPSNOOP2_RD()      (HW_ENET_SWI_IPSNOOP2.U)
#define HW_ENET_SWI_IPSNOOP2_WR(v)     (HW_ENET_SWI_IPSNOOP2.U = (v))
#define HW_ENET_SWI_IPSNOOP2_SET(v)    (HW_ENET_SWI_IPSNOOP2_WR(HW_ENET_SWI_IPSNOOP2_RD() |  (v)))
#define HW_ENET_SWI_IPSNOOP2_CLR(v)    (HW_ENET_SWI_IPSNOOP2_WR(HW_ENET_SWI_IPSNOOP2_RD() & ~(v)))
#define HW_ENET_SWI_IPSNOOP2_TOG(v)    (HW_ENET_SWI_IPSNOOP2_WR(HW_ENET_SWI_IPSNOOP2_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_IPSNOOP2 bitfields
 */
/* --- Register HW_ENET_SWI_IPSNOOP2, field RSRVD1 */

#define BP_ENET_SWI_IPSNOOP2_RSRVD1      16
#define BM_ENET_SWI_IPSNOOP2_RSRVD1      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_IPSNOOP2_RSRVD1(v)   ((((reg32_t) v) << 16) & BM_ENET_SWI_IPSNOOP2_RSRVD1)
#else
#define BF_ENET_SWI_IPSNOOP2_RSRVD1(v)   (((v) << 16) & BM_ENET_SWI_IPSNOOP2_RSRVD1)
#endif
/* --- Register HW_ENET_SWI_IPSNOOP2, field PROTOCOL */

#define BP_ENET_SWI_IPSNOOP2_PROTOCOL      8
#define BM_ENET_SWI_IPSNOOP2_PROTOCOL      0x0000FF00

#define BF_ENET_SWI_IPSNOOP2_PROTOCOL(v)   (((v) << 8) & BM_ENET_SWI_IPSNOOP2_PROTOCOL)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_IPSNOOP2_PROTOCOL(v)   (HW_ENET_SWI_IPSNOOP2.B.PROTOCOL = (v))
#endif

/* --- Register HW_ENET_SWI_IPSNOOP2, field RSRVD0 */

#define BP_ENET_SWI_IPSNOOP2_RSRVD0      3
#define BM_ENET_SWI_IPSNOOP2_RSRVD0      0x000000F8

#define BF_ENET_SWI_IPSNOOP2_RSRVD0(v)   (((v) << 3) & BM_ENET_SWI_IPSNOOP2_RSRVD0)
/* --- Register HW_ENET_SWI_IPSNOOP2, field MODE */

#define BP_ENET_SWI_IPSNOOP2_MODE      1
#define BM_ENET_SWI_IPSNOOP2_MODE      0x00000006

#define BF_ENET_SWI_IPSNOOP2_MODE(v)   (((v) << 1) & BM_ENET_SWI_IPSNOOP2_MODE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_IPSNOOP2_MODE(v)   BF_CS1(ENET_SWI_IPSNOOP2, MODE, v)
#endif

/* --- Register HW_ENET_SWI_IPSNOOP2, field ENABLE */

#define BP_ENET_SWI_IPSNOOP2_ENABLE      0
#define BM_ENET_SWI_IPSNOOP2_ENABLE      0x00000001

#define BF_ENET_SWI_IPSNOOP2_ENABLE(v)   (((v) << 0) & BM_ENET_SWI_IPSNOOP2_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_IPSNOOP2_ENABLE(v)   BF_CS1(ENET_SWI_IPSNOOP2, ENABLE, v)
#endif



/*
 * HW_ENET_SWI_IPSNOOP3 - ENET SWI IP Snooping function3
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ENABLE    :  1;
        unsigned MODE      :  2;
        unsigned RSRVD0    :  5;
        unsigned PROTOCOL  :  8;
        unsigned RSRVD1    : 16;
    } B;
} hw_enet_swi_ipsnoop3_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_IPSNOOP3 register
 */
#define HW_ENET_SWI_IPSNOOP3_ADDR         (REGS_ENET_BASE + 0x80e8)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_IPSNOOP3           (*(volatile hw_enet_swi_ipsnoop3_t *) HW_ENET_SWI_IPSNOOP3_ADDR)
#define HW_ENET_SWI_IPSNOOP3_RD()      (HW_ENET_SWI_IPSNOOP3.U)
#define HW_ENET_SWI_IPSNOOP3_WR(v)     (HW_ENET_SWI_IPSNOOP3.U = (v))
#define HW_ENET_SWI_IPSNOOP3_SET(v)    (HW_ENET_SWI_IPSNOOP3_WR(HW_ENET_SWI_IPSNOOP3_RD() |  (v)))
#define HW_ENET_SWI_IPSNOOP3_CLR(v)    (HW_ENET_SWI_IPSNOOP3_WR(HW_ENET_SWI_IPSNOOP3_RD() & ~(v)))
#define HW_ENET_SWI_IPSNOOP3_TOG(v)    (HW_ENET_SWI_IPSNOOP3_WR(HW_ENET_SWI_IPSNOOP3_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_IPSNOOP3 bitfields
 */
/* --- Register HW_ENET_SWI_IPSNOOP3, field RSRVD1 */

#define BP_ENET_SWI_IPSNOOP3_RSRVD1      16
#define BM_ENET_SWI_IPSNOOP3_RSRVD1      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_IPSNOOP3_RSRVD1(v)   ((((reg32_t) v) << 16) & BM_ENET_SWI_IPSNOOP3_RSRVD1)
#else
#define BF_ENET_SWI_IPSNOOP3_RSRVD1(v)   (((v) << 16) & BM_ENET_SWI_IPSNOOP3_RSRVD1)
#endif
/* --- Register HW_ENET_SWI_IPSNOOP3, field PROTOCOL */

#define BP_ENET_SWI_IPSNOOP3_PROTOCOL      8
#define BM_ENET_SWI_IPSNOOP3_PROTOCOL      0x0000FF00

#define BF_ENET_SWI_IPSNOOP3_PROTOCOL(v)   (((v) << 8) & BM_ENET_SWI_IPSNOOP3_PROTOCOL)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_IPSNOOP3_PROTOCOL(v)   (HW_ENET_SWI_IPSNOOP3.B.PROTOCOL = (v))
#endif

/* --- Register HW_ENET_SWI_IPSNOOP3, field RSRVD0 */

#define BP_ENET_SWI_IPSNOOP3_RSRVD0      3
#define BM_ENET_SWI_IPSNOOP3_RSRVD0      0x000000F8

#define BF_ENET_SWI_IPSNOOP3_RSRVD0(v)   (((v) << 3) & BM_ENET_SWI_IPSNOOP3_RSRVD0)
/* --- Register HW_ENET_SWI_IPSNOOP3, field MODE */

#define BP_ENET_SWI_IPSNOOP3_MODE      1
#define BM_ENET_SWI_IPSNOOP3_MODE      0x00000006

#define BF_ENET_SWI_IPSNOOP3_MODE(v)   (((v) << 1) & BM_ENET_SWI_IPSNOOP3_MODE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_IPSNOOP3_MODE(v)   BF_CS1(ENET_SWI_IPSNOOP3, MODE, v)
#endif

/* --- Register HW_ENET_SWI_IPSNOOP3, field ENABLE */

#define BP_ENET_SWI_IPSNOOP3_ENABLE      0
#define BM_ENET_SWI_IPSNOOP3_ENABLE      0x00000001

#define BF_ENET_SWI_IPSNOOP3_ENABLE(v)   (((v) << 0) & BM_ENET_SWI_IPSNOOP3_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_IPSNOOP3_ENABLE(v)   BF_CS1(ENET_SWI_IPSNOOP3, ENABLE, v)
#endif



/*
 * HW_ENET_SWI_IPSNOOP4 - ENET SWI IP Snooping function4
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ENABLE    :  1;
        unsigned MODE      :  2;
        unsigned RSRVD0    :  5;
        unsigned PROTOCOL  :  8;
        unsigned RSRVD1    : 16;
    } B;
} hw_enet_swi_ipsnoop4_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_IPSNOOP4 register
 */
#define HW_ENET_SWI_IPSNOOP4_ADDR         (REGS_ENET_BASE + 0x80ec)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_IPSNOOP4           (*(volatile hw_enet_swi_ipsnoop4_t *) HW_ENET_SWI_IPSNOOP4_ADDR)
#define HW_ENET_SWI_IPSNOOP4_RD()      (HW_ENET_SWI_IPSNOOP4.U)
#define HW_ENET_SWI_IPSNOOP4_WR(v)     (HW_ENET_SWI_IPSNOOP4.U = (v))
#define HW_ENET_SWI_IPSNOOP4_SET(v)    (HW_ENET_SWI_IPSNOOP4_WR(HW_ENET_SWI_IPSNOOP4_RD() |  (v)))
#define HW_ENET_SWI_IPSNOOP4_CLR(v)    (HW_ENET_SWI_IPSNOOP4_WR(HW_ENET_SWI_IPSNOOP4_RD() & ~(v)))
#define HW_ENET_SWI_IPSNOOP4_TOG(v)    (HW_ENET_SWI_IPSNOOP4_WR(HW_ENET_SWI_IPSNOOP4_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_IPSNOOP4 bitfields
 */
/* --- Register HW_ENET_SWI_IPSNOOP4, field RSRVD1 */

#define BP_ENET_SWI_IPSNOOP4_RSRVD1      16
#define BM_ENET_SWI_IPSNOOP4_RSRVD1      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_IPSNOOP4_RSRVD1(v)   ((((reg32_t) v) << 16) & BM_ENET_SWI_IPSNOOP4_RSRVD1)
#else
#define BF_ENET_SWI_IPSNOOP4_RSRVD1(v)   (((v) << 16) & BM_ENET_SWI_IPSNOOP4_RSRVD1)
#endif
/* --- Register HW_ENET_SWI_IPSNOOP4, field PROTOCOL */

#define BP_ENET_SWI_IPSNOOP4_PROTOCOL      8
#define BM_ENET_SWI_IPSNOOP4_PROTOCOL      0x0000FF00

#define BF_ENET_SWI_IPSNOOP4_PROTOCOL(v)   (((v) << 8) & BM_ENET_SWI_IPSNOOP4_PROTOCOL)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_IPSNOOP4_PROTOCOL(v)   (HW_ENET_SWI_IPSNOOP4.B.PROTOCOL = (v))
#endif

/* --- Register HW_ENET_SWI_IPSNOOP4, field RSRVD0 */

#define BP_ENET_SWI_IPSNOOP4_RSRVD0      3
#define BM_ENET_SWI_IPSNOOP4_RSRVD0      0x000000F8

#define BF_ENET_SWI_IPSNOOP4_RSRVD0(v)   (((v) << 3) & BM_ENET_SWI_IPSNOOP4_RSRVD0)
/* --- Register HW_ENET_SWI_IPSNOOP4, field MODE */

#define BP_ENET_SWI_IPSNOOP4_MODE      1
#define BM_ENET_SWI_IPSNOOP4_MODE      0x00000006

#define BF_ENET_SWI_IPSNOOP4_MODE(v)   (((v) << 1) & BM_ENET_SWI_IPSNOOP4_MODE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_IPSNOOP4_MODE(v)   BF_CS1(ENET_SWI_IPSNOOP4, MODE, v)
#endif

/* --- Register HW_ENET_SWI_IPSNOOP4, field ENABLE */

#define BP_ENET_SWI_IPSNOOP4_ENABLE      0
#define BM_ENET_SWI_IPSNOOP4_ENABLE      0x00000001

#define BF_ENET_SWI_IPSNOOP4_ENABLE(v)   (((v) << 0) & BM_ENET_SWI_IPSNOOP4_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_IPSNOOP4_ENABLE(v)   BF_CS1(ENET_SWI_IPSNOOP4, ENABLE, v)
#endif



/*
 * HW_ENET_SWI_IPSNOOP5 - ENET SWI IP Snooping function5
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ENABLE    :  1;
        unsigned MODE      :  2;
        unsigned RSRVD0    :  5;
        unsigned PROTOCOL  :  8;
        unsigned RSRVD1    : 16;
    } B;
} hw_enet_swi_ipsnoop5_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_IPSNOOP5 register
 */
#define HW_ENET_SWI_IPSNOOP5_ADDR         (REGS_ENET_BASE + 0x80f0)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_IPSNOOP5           (*(volatile hw_enet_swi_ipsnoop5_t *) HW_ENET_SWI_IPSNOOP5_ADDR)
#define HW_ENET_SWI_IPSNOOP5_RD()      (HW_ENET_SWI_IPSNOOP5.U)
#define HW_ENET_SWI_IPSNOOP5_WR(v)     (HW_ENET_SWI_IPSNOOP5.U = (v))
#define HW_ENET_SWI_IPSNOOP5_SET(v)    (HW_ENET_SWI_IPSNOOP5_WR(HW_ENET_SWI_IPSNOOP5_RD() |  (v)))
#define HW_ENET_SWI_IPSNOOP5_CLR(v)    (HW_ENET_SWI_IPSNOOP5_WR(HW_ENET_SWI_IPSNOOP5_RD() & ~(v)))
#define HW_ENET_SWI_IPSNOOP5_TOG(v)    (HW_ENET_SWI_IPSNOOP5_WR(HW_ENET_SWI_IPSNOOP5_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_IPSNOOP5 bitfields
 */
/* --- Register HW_ENET_SWI_IPSNOOP5, field RSRVD1 */

#define BP_ENET_SWI_IPSNOOP5_RSRVD1      16
#define BM_ENET_SWI_IPSNOOP5_RSRVD1      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_IPSNOOP5_RSRVD1(v)   ((((reg32_t) v) << 16) & BM_ENET_SWI_IPSNOOP5_RSRVD1)
#else
#define BF_ENET_SWI_IPSNOOP5_RSRVD1(v)   (((v) << 16) & BM_ENET_SWI_IPSNOOP5_RSRVD1)
#endif
/* --- Register HW_ENET_SWI_IPSNOOP5, field PROTOCOL */

#define BP_ENET_SWI_IPSNOOP5_PROTOCOL      8
#define BM_ENET_SWI_IPSNOOP5_PROTOCOL      0x0000FF00

#define BF_ENET_SWI_IPSNOOP5_PROTOCOL(v)   (((v) << 8) & BM_ENET_SWI_IPSNOOP5_PROTOCOL)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_IPSNOOP5_PROTOCOL(v)   (HW_ENET_SWI_IPSNOOP5.B.PROTOCOL = (v))
#endif

/* --- Register HW_ENET_SWI_IPSNOOP5, field RSRVD0 */

#define BP_ENET_SWI_IPSNOOP5_RSRVD0      3
#define BM_ENET_SWI_IPSNOOP5_RSRVD0      0x000000F8

#define BF_ENET_SWI_IPSNOOP5_RSRVD0(v)   (((v) << 3) & BM_ENET_SWI_IPSNOOP5_RSRVD0)
/* --- Register HW_ENET_SWI_IPSNOOP5, field MODE */

#define BP_ENET_SWI_IPSNOOP5_MODE      1
#define BM_ENET_SWI_IPSNOOP5_MODE      0x00000006

#define BF_ENET_SWI_IPSNOOP5_MODE(v)   (((v) << 1) & BM_ENET_SWI_IPSNOOP5_MODE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_IPSNOOP5_MODE(v)   BF_CS1(ENET_SWI_IPSNOOP5, MODE, v)
#endif

/* --- Register HW_ENET_SWI_IPSNOOP5, field ENABLE */

#define BP_ENET_SWI_IPSNOOP5_ENABLE      0
#define BM_ENET_SWI_IPSNOOP5_ENABLE      0x00000001

#define BF_ENET_SWI_IPSNOOP5_ENABLE(v)   (((v) << 0) & BM_ENET_SWI_IPSNOOP5_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_IPSNOOP5_ENABLE(v)   BF_CS1(ENET_SWI_IPSNOOP5, ENABLE, v)
#endif



/*
 * HW_ENET_SWI_IPSNOOP6 - ENET SWI IP Snooping function6
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ENABLE    :  1;
        unsigned MODE      :  2;
        unsigned RSRVD0    :  5;
        unsigned PROTOCOL  :  8;
        unsigned RSRVD1    : 16;
    } B;
} hw_enet_swi_ipsnoop6_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_IPSNOOP6 register
 */
#define HW_ENET_SWI_IPSNOOP6_ADDR         (REGS_ENET_BASE + 0x80f4)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_IPSNOOP6           (*(volatile hw_enet_swi_ipsnoop6_t *) HW_ENET_SWI_IPSNOOP6_ADDR)
#define HW_ENET_SWI_IPSNOOP6_RD()      (HW_ENET_SWI_IPSNOOP6.U)
#define HW_ENET_SWI_IPSNOOP6_WR(v)     (HW_ENET_SWI_IPSNOOP6.U = (v))
#define HW_ENET_SWI_IPSNOOP6_SET(v)    (HW_ENET_SWI_IPSNOOP6_WR(HW_ENET_SWI_IPSNOOP6_RD() |  (v)))
#define HW_ENET_SWI_IPSNOOP6_CLR(v)    (HW_ENET_SWI_IPSNOOP6_WR(HW_ENET_SWI_IPSNOOP6_RD() & ~(v)))
#define HW_ENET_SWI_IPSNOOP6_TOG(v)    (HW_ENET_SWI_IPSNOOP6_WR(HW_ENET_SWI_IPSNOOP6_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_IPSNOOP6 bitfields
 */
/* --- Register HW_ENET_SWI_IPSNOOP6, field RSRVD1 */

#define BP_ENET_SWI_IPSNOOP6_RSRVD1      16
#define BM_ENET_SWI_IPSNOOP6_RSRVD1      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_IPSNOOP6_RSRVD1(v)   ((((reg32_t) v) << 16) & BM_ENET_SWI_IPSNOOP6_RSRVD1)
#else
#define BF_ENET_SWI_IPSNOOP6_RSRVD1(v)   (((v) << 16) & BM_ENET_SWI_IPSNOOP6_RSRVD1)
#endif
/* --- Register HW_ENET_SWI_IPSNOOP6, field PROTOCOL */

#define BP_ENET_SWI_IPSNOOP6_PROTOCOL      8
#define BM_ENET_SWI_IPSNOOP6_PROTOCOL      0x0000FF00

#define BF_ENET_SWI_IPSNOOP6_PROTOCOL(v)   (((v) << 8) & BM_ENET_SWI_IPSNOOP6_PROTOCOL)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_IPSNOOP6_PROTOCOL(v)   (HW_ENET_SWI_IPSNOOP6.B.PROTOCOL = (v))
#endif

/* --- Register HW_ENET_SWI_IPSNOOP6, field RSRVD0 */

#define BP_ENET_SWI_IPSNOOP6_RSRVD0      3
#define BM_ENET_SWI_IPSNOOP6_RSRVD0      0x000000F8

#define BF_ENET_SWI_IPSNOOP6_RSRVD0(v)   (((v) << 3) & BM_ENET_SWI_IPSNOOP6_RSRVD0)
/* --- Register HW_ENET_SWI_IPSNOOP6, field MODE */

#define BP_ENET_SWI_IPSNOOP6_MODE      1
#define BM_ENET_SWI_IPSNOOP6_MODE      0x00000006

#define BF_ENET_SWI_IPSNOOP6_MODE(v)   (((v) << 1) & BM_ENET_SWI_IPSNOOP6_MODE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_IPSNOOP6_MODE(v)   BF_CS1(ENET_SWI_IPSNOOP6, MODE, v)
#endif

/* --- Register HW_ENET_SWI_IPSNOOP6, field ENABLE */

#define BP_ENET_SWI_IPSNOOP6_ENABLE      0
#define BM_ENET_SWI_IPSNOOP6_ENABLE      0x00000001

#define BF_ENET_SWI_IPSNOOP6_ENABLE(v)   (((v) << 0) & BM_ENET_SWI_IPSNOOP6_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_IPSNOOP6_ENABLE(v)   BF_CS1(ENET_SWI_IPSNOOP6, ENABLE, v)
#endif



/*
 * HW_ENET_SWI_IPSNOOP7 - ENET SWI IP Snooping function7
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ENABLE    :  1;
        unsigned MODE      :  2;
        unsigned RSRVD0    :  5;
        unsigned PROTOCOL  :  8;
        unsigned RSRVD1    : 16;
    } B;
} hw_enet_swi_ipsnoop7_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_IPSNOOP7 register
 */
#define HW_ENET_SWI_IPSNOOP7_ADDR         (REGS_ENET_BASE + 0x80f8)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_IPSNOOP7           (*(volatile hw_enet_swi_ipsnoop7_t *) HW_ENET_SWI_IPSNOOP7_ADDR)
#define HW_ENET_SWI_IPSNOOP7_RD()      (HW_ENET_SWI_IPSNOOP7.U)
#define HW_ENET_SWI_IPSNOOP7_WR(v)     (HW_ENET_SWI_IPSNOOP7.U = (v))
#define HW_ENET_SWI_IPSNOOP7_SET(v)    (HW_ENET_SWI_IPSNOOP7_WR(HW_ENET_SWI_IPSNOOP7_RD() |  (v)))
#define HW_ENET_SWI_IPSNOOP7_CLR(v)    (HW_ENET_SWI_IPSNOOP7_WR(HW_ENET_SWI_IPSNOOP7_RD() & ~(v)))
#define HW_ENET_SWI_IPSNOOP7_TOG(v)    (HW_ENET_SWI_IPSNOOP7_WR(HW_ENET_SWI_IPSNOOP7_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_IPSNOOP7 bitfields
 */
/* --- Register HW_ENET_SWI_IPSNOOP7, field RSRVD1 */

#define BP_ENET_SWI_IPSNOOP7_RSRVD1      16
#define BM_ENET_SWI_IPSNOOP7_RSRVD1      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_IPSNOOP7_RSRVD1(v)   ((((reg32_t) v) << 16) & BM_ENET_SWI_IPSNOOP7_RSRVD1)
#else
#define BF_ENET_SWI_IPSNOOP7_RSRVD1(v)   (((v) << 16) & BM_ENET_SWI_IPSNOOP7_RSRVD1)
#endif
/* --- Register HW_ENET_SWI_IPSNOOP7, field PROTOCOL */

#define BP_ENET_SWI_IPSNOOP7_PROTOCOL      8
#define BM_ENET_SWI_IPSNOOP7_PROTOCOL      0x0000FF00

#define BF_ENET_SWI_IPSNOOP7_PROTOCOL(v)   (((v) << 8) & BM_ENET_SWI_IPSNOOP7_PROTOCOL)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_IPSNOOP7_PROTOCOL(v)   (HW_ENET_SWI_IPSNOOP7.B.PROTOCOL = (v))
#endif

/* --- Register HW_ENET_SWI_IPSNOOP7, field RSRVD0 */

#define BP_ENET_SWI_IPSNOOP7_RSRVD0      3
#define BM_ENET_SWI_IPSNOOP7_RSRVD0      0x000000F8

#define BF_ENET_SWI_IPSNOOP7_RSRVD0(v)   (((v) << 3) & BM_ENET_SWI_IPSNOOP7_RSRVD0)
/* --- Register HW_ENET_SWI_IPSNOOP7, field MODE */

#define BP_ENET_SWI_IPSNOOP7_MODE      1
#define BM_ENET_SWI_IPSNOOP7_MODE      0x00000006

#define BF_ENET_SWI_IPSNOOP7_MODE(v)   (((v) << 1) & BM_ENET_SWI_IPSNOOP7_MODE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_IPSNOOP7_MODE(v)   BF_CS1(ENET_SWI_IPSNOOP7, MODE, v)
#endif

/* --- Register HW_ENET_SWI_IPSNOOP7, field ENABLE */

#define BP_ENET_SWI_IPSNOOP7_ENABLE      0
#define BM_ENET_SWI_IPSNOOP7_ENABLE      0x00000001

#define BF_ENET_SWI_IPSNOOP7_ENABLE(v)   (((v) << 0) & BM_ENET_SWI_IPSNOOP7_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_IPSNOOP7_ENABLE(v)   BF_CS1(ENET_SWI_IPSNOOP7, ENABLE, v)
#endif



/*
 * HW_ENET_SWI_IPSNOOP8 - ENET SWI IP Snooping function8
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ENABLE    :  1;
        unsigned MODE      :  2;
        unsigned RSRVD0    :  5;
        unsigned PROTOCOL  :  8;
        unsigned RSRVD1    : 16;
    } B;
} hw_enet_swi_ipsnoop8_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_IPSNOOP8 register
 */
#define HW_ENET_SWI_IPSNOOP8_ADDR         (REGS_ENET_BASE + 0x80fc)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_IPSNOOP8           (*(volatile hw_enet_swi_ipsnoop8_t *) HW_ENET_SWI_IPSNOOP8_ADDR)
#define HW_ENET_SWI_IPSNOOP8_RD()      (HW_ENET_SWI_IPSNOOP8.U)
#define HW_ENET_SWI_IPSNOOP8_WR(v)     (HW_ENET_SWI_IPSNOOP8.U = (v))
#define HW_ENET_SWI_IPSNOOP8_SET(v)    (HW_ENET_SWI_IPSNOOP8_WR(HW_ENET_SWI_IPSNOOP8_RD() |  (v)))
#define HW_ENET_SWI_IPSNOOP8_CLR(v)    (HW_ENET_SWI_IPSNOOP8_WR(HW_ENET_SWI_IPSNOOP8_RD() & ~(v)))
#define HW_ENET_SWI_IPSNOOP8_TOG(v)    (HW_ENET_SWI_IPSNOOP8_WR(HW_ENET_SWI_IPSNOOP8_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_IPSNOOP8 bitfields
 */
/* --- Register HW_ENET_SWI_IPSNOOP8, field RSRVD1 */

#define BP_ENET_SWI_IPSNOOP8_RSRVD1      16
#define BM_ENET_SWI_IPSNOOP8_RSRVD1      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_IPSNOOP8_RSRVD1(v)   ((((reg32_t) v) << 16) & BM_ENET_SWI_IPSNOOP8_RSRVD1)
#else
#define BF_ENET_SWI_IPSNOOP8_RSRVD1(v)   (((v) << 16) & BM_ENET_SWI_IPSNOOP8_RSRVD1)
#endif
/* --- Register HW_ENET_SWI_IPSNOOP8, field PROTOCOL */

#define BP_ENET_SWI_IPSNOOP8_PROTOCOL      8
#define BM_ENET_SWI_IPSNOOP8_PROTOCOL      0x0000FF00

#define BF_ENET_SWI_IPSNOOP8_PROTOCOL(v)   (((v) << 8) & BM_ENET_SWI_IPSNOOP8_PROTOCOL)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_IPSNOOP8_PROTOCOL(v)   (HW_ENET_SWI_IPSNOOP8.B.PROTOCOL = (v))
#endif

/* --- Register HW_ENET_SWI_IPSNOOP8, field RSRVD0 */

#define BP_ENET_SWI_IPSNOOP8_RSRVD0      3
#define BM_ENET_SWI_IPSNOOP8_RSRVD0      0x000000F8

#define BF_ENET_SWI_IPSNOOP8_RSRVD0(v)   (((v) << 3) & BM_ENET_SWI_IPSNOOP8_RSRVD0)
/* --- Register HW_ENET_SWI_IPSNOOP8, field MODE */

#define BP_ENET_SWI_IPSNOOP8_MODE      1
#define BM_ENET_SWI_IPSNOOP8_MODE      0x00000006

#define BF_ENET_SWI_IPSNOOP8_MODE(v)   (((v) << 1) & BM_ENET_SWI_IPSNOOP8_MODE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_IPSNOOP8_MODE(v)   BF_CS1(ENET_SWI_IPSNOOP8, MODE, v)
#endif

/* --- Register HW_ENET_SWI_IPSNOOP8, field ENABLE */

#define BP_ENET_SWI_IPSNOOP8_ENABLE      0
#define BM_ENET_SWI_IPSNOOP8_ENABLE      0x00000001

#define BF_ENET_SWI_IPSNOOP8_ENABLE(v)   (((v) << 0) & BM_ENET_SWI_IPSNOOP8_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_IPSNOOP8_ENABLE(v)   BF_CS1(ENET_SWI_IPSNOOP8, ENABLE, v)
#endif



/*
 * HW_ENET_SWI_VLAN_PRIORITY0 - ENET SWI Port 0 VLAN priority resolution map
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned P0      :  3;
        unsigned P1      :  3;
        unsigned P2      :  3;
        unsigned P3      :  3;
        unsigned P4      :  3;
        unsigned P5      :  3;
        unsigned P6      :  3;
        unsigned P7      :  3;
        unsigned RSRVD0  :  8;
    } B;
} hw_enet_swi_vlan_priority0_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_VLAN_PRIORITY0 register
 */
#define HW_ENET_SWI_VLAN_PRIORITY0_ADDR         (REGS_ENET_BASE + 0x8100)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_VLAN_PRIORITY0           (*(volatile hw_enet_swi_vlan_priority0_t *) HW_ENET_SWI_VLAN_PRIORITY0_ADDR)
#define HW_ENET_SWI_VLAN_PRIORITY0_RD()      (HW_ENET_SWI_VLAN_PRIORITY0.U)
#define HW_ENET_SWI_VLAN_PRIORITY0_WR(v)     (HW_ENET_SWI_VLAN_PRIORITY0.U = (v))
#define HW_ENET_SWI_VLAN_PRIORITY0_SET(v)    (HW_ENET_SWI_VLAN_PRIORITY0_WR(HW_ENET_SWI_VLAN_PRIORITY0_RD() |  (v)))
#define HW_ENET_SWI_VLAN_PRIORITY0_CLR(v)    (HW_ENET_SWI_VLAN_PRIORITY0_WR(HW_ENET_SWI_VLAN_PRIORITY0_RD() & ~(v)))
#define HW_ENET_SWI_VLAN_PRIORITY0_TOG(v)    (HW_ENET_SWI_VLAN_PRIORITY0_WR(HW_ENET_SWI_VLAN_PRIORITY0_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_VLAN_PRIORITY0 bitfields
 */
/* --- Register HW_ENET_SWI_VLAN_PRIORITY0, field RSRVD0 */

#define BP_ENET_SWI_VLAN_PRIORITY0_RSRVD0      24
#define BM_ENET_SWI_VLAN_PRIORITY0_RSRVD0      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_VLAN_PRIORITY0_RSRVD0(v)   ((((reg32_t) v) << 24) & BM_ENET_SWI_VLAN_PRIORITY0_RSRVD0)
#else
#define BF_ENET_SWI_VLAN_PRIORITY0_RSRVD0(v)   (((v) << 24) & BM_ENET_SWI_VLAN_PRIORITY0_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_VLAN_PRIORITY0, field P7 */

#define BP_ENET_SWI_VLAN_PRIORITY0_P7      21
#define BM_ENET_SWI_VLAN_PRIORITY0_P7      0x00E00000

#define BF_ENET_SWI_VLAN_PRIORITY0_P7(v)   (((v) << 21) & BM_ENET_SWI_VLAN_PRIORITY0_P7)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_PRIORITY0_P7(v)   BF_CS1(ENET_SWI_VLAN_PRIORITY0, P7, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_PRIORITY0, field P6 */

#define BP_ENET_SWI_VLAN_PRIORITY0_P6      18
#define BM_ENET_SWI_VLAN_PRIORITY0_P6      0x001C0000

#define BF_ENET_SWI_VLAN_PRIORITY0_P6(v)   (((v) << 18) & BM_ENET_SWI_VLAN_PRIORITY0_P6)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_PRIORITY0_P6(v)   BF_CS1(ENET_SWI_VLAN_PRIORITY0, P6, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_PRIORITY0, field P5 */

#define BP_ENET_SWI_VLAN_PRIORITY0_P5      15
#define BM_ENET_SWI_VLAN_PRIORITY0_P5      0x00038000

#define BF_ENET_SWI_VLAN_PRIORITY0_P5(v)   (((v) << 15) & BM_ENET_SWI_VLAN_PRIORITY0_P5)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_PRIORITY0_P5(v)   BF_CS1(ENET_SWI_VLAN_PRIORITY0, P5, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_PRIORITY0, field P4 */

#define BP_ENET_SWI_VLAN_PRIORITY0_P4      12
#define BM_ENET_SWI_VLAN_PRIORITY0_P4      0x00007000

#define BF_ENET_SWI_VLAN_PRIORITY0_P4(v)   (((v) << 12) & BM_ENET_SWI_VLAN_PRIORITY0_P4)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_PRIORITY0_P4(v)   BF_CS1(ENET_SWI_VLAN_PRIORITY0, P4, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_PRIORITY0, field P3 */

#define BP_ENET_SWI_VLAN_PRIORITY0_P3      9
#define BM_ENET_SWI_VLAN_PRIORITY0_P3      0x00000E00

#define BF_ENET_SWI_VLAN_PRIORITY0_P3(v)   (((v) << 9) & BM_ENET_SWI_VLAN_PRIORITY0_P3)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_PRIORITY0_P3(v)   BF_CS1(ENET_SWI_VLAN_PRIORITY0, P3, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_PRIORITY0, field P2 */

#define BP_ENET_SWI_VLAN_PRIORITY0_P2      6
#define BM_ENET_SWI_VLAN_PRIORITY0_P2      0x000001C0

#define BF_ENET_SWI_VLAN_PRIORITY0_P2(v)   (((v) << 6) & BM_ENET_SWI_VLAN_PRIORITY0_P2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_PRIORITY0_P2(v)   BF_CS1(ENET_SWI_VLAN_PRIORITY0, P2, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_PRIORITY0, field P1 */

#define BP_ENET_SWI_VLAN_PRIORITY0_P1      3
#define BM_ENET_SWI_VLAN_PRIORITY0_P1      0x00000038

#define BF_ENET_SWI_VLAN_PRIORITY0_P1(v)   (((v) << 3) & BM_ENET_SWI_VLAN_PRIORITY0_P1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_PRIORITY0_P1(v)   BF_CS1(ENET_SWI_VLAN_PRIORITY0, P1, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_PRIORITY0, field P0 */

#define BP_ENET_SWI_VLAN_PRIORITY0_P0      0
#define BM_ENET_SWI_VLAN_PRIORITY0_P0      0x00000007

#define BF_ENET_SWI_VLAN_PRIORITY0_P0(v)   (((v) << 0) & BM_ENET_SWI_VLAN_PRIORITY0_P0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_PRIORITY0_P0(v)   BF_CS1(ENET_SWI_VLAN_PRIORITY0, P0, v)
#endif



/*
 * HW_ENET_SWI_VLAN_PRIORITY1 - ENET SWI Port 1 VLAN priority resolution map
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned P0      :  3;
        unsigned P1      :  3;
        unsigned P2      :  3;
        unsigned P3      :  3;
        unsigned P4      :  3;
        unsigned P5      :  3;
        unsigned P6      :  3;
        unsigned P7      :  3;
        unsigned RSRVD0  :  8;
    } B;
} hw_enet_swi_vlan_priority1_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_VLAN_PRIORITY1 register
 */
#define HW_ENET_SWI_VLAN_PRIORITY1_ADDR         (REGS_ENET_BASE + 0x8104)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_VLAN_PRIORITY1           (*(volatile hw_enet_swi_vlan_priority1_t *) HW_ENET_SWI_VLAN_PRIORITY1_ADDR)
#define HW_ENET_SWI_VLAN_PRIORITY1_RD()      (HW_ENET_SWI_VLAN_PRIORITY1.U)
#define HW_ENET_SWI_VLAN_PRIORITY1_WR(v)     (HW_ENET_SWI_VLAN_PRIORITY1.U = (v))
#define HW_ENET_SWI_VLAN_PRIORITY1_SET(v)    (HW_ENET_SWI_VLAN_PRIORITY1_WR(HW_ENET_SWI_VLAN_PRIORITY1_RD() |  (v)))
#define HW_ENET_SWI_VLAN_PRIORITY1_CLR(v)    (HW_ENET_SWI_VLAN_PRIORITY1_WR(HW_ENET_SWI_VLAN_PRIORITY1_RD() & ~(v)))
#define HW_ENET_SWI_VLAN_PRIORITY1_TOG(v)    (HW_ENET_SWI_VLAN_PRIORITY1_WR(HW_ENET_SWI_VLAN_PRIORITY1_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_VLAN_PRIORITY1 bitfields
 */
/* --- Register HW_ENET_SWI_VLAN_PRIORITY1, field RSRVD0 */

#define BP_ENET_SWI_VLAN_PRIORITY1_RSRVD0      24
#define BM_ENET_SWI_VLAN_PRIORITY1_RSRVD0      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_VLAN_PRIORITY1_RSRVD0(v)   ((((reg32_t) v) << 24) & BM_ENET_SWI_VLAN_PRIORITY1_RSRVD0)
#else
#define BF_ENET_SWI_VLAN_PRIORITY1_RSRVD0(v)   (((v) << 24) & BM_ENET_SWI_VLAN_PRIORITY1_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_VLAN_PRIORITY1, field P7 */

#define BP_ENET_SWI_VLAN_PRIORITY1_P7      21
#define BM_ENET_SWI_VLAN_PRIORITY1_P7      0x00E00000

#define BF_ENET_SWI_VLAN_PRIORITY1_P7(v)   (((v) << 21) & BM_ENET_SWI_VLAN_PRIORITY1_P7)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_PRIORITY1_P7(v)   BF_CS1(ENET_SWI_VLAN_PRIORITY1, P7, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_PRIORITY1, field P6 */

#define BP_ENET_SWI_VLAN_PRIORITY1_P6      18
#define BM_ENET_SWI_VLAN_PRIORITY1_P6      0x001C0000

#define BF_ENET_SWI_VLAN_PRIORITY1_P6(v)   (((v) << 18) & BM_ENET_SWI_VLAN_PRIORITY1_P6)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_PRIORITY1_P6(v)   BF_CS1(ENET_SWI_VLAN_PRIORITY1, P6, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_PRIORITY1, field P5 */

#define BP_ENET_SWI_VLAN_PRIORITY1_P5      15
#define BM_ENET_SWI_VLAN_PRIORITY1_P5      0x00038000

#define BF_ENET_SWI_VLAN_PRIORITY1_P5(v)   (((v) << 15) & BM_ENET_SWI_VLAN_PRIORITY1_P5)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_PRIORITY1_P5(v)   BF_CS1(ENET_SWI_VLAN_PRIORITY1, P5, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_PRIORITY1, field P4 */

#define BP_ENET_SWI_VLAN_PRIORITY1_P4      12
#define BM_ENET_SWI_VLAN_PRIORITY1_P4      0x00007000

#define BF_ENET_SWI_VLAN_PRIORITY1_P4(v)   (((v) << 12) & BM_ENET_SWI_VLAN_PRIORITY1_P4)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_PRIORITY1_P4(v)   BF_CS1(ENET_SWI_VLAN_PRIORITY1, P4, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_PRIORITY1, field P3 */

#define BP_ENET_SWI_VLAN_PRIORITY1_P3      9
#define BM_ENET_SWI_VLAN_PRIORITY1_P3      0x00000E00

#define BF_ENET_SWI_VLAN_PRIORITY1_P3(v)   (((v) << 9) & BM_ENET_SWI_VLAN_PRIORITY1_P3)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_PRIORITY1_P3(v)   BF_CS1(ENET_SWI_VLAN_PRIORITY1, P3, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_PRIORITY1, field P2 */

#define BP_ENET_SWI_VLAN_PRIORITY1_P2      6
#define BM_ENET_SWI_VLAN_PRIORITY1_P2      0x000001C0

#define BF_ENET_SWI_VLAN_PRIORITY1_P2(v)   (((v) << 6) & BM_ENET_SWI_VLAN_PRIORITY1_P2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_PRIORITY1_P2(v)   BF_CS1(ENET_SWI_VLAN_PRIORITY1, P2, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_PRIORITY1, field P1 */

#define BP_ENET_SWI_VLAN_PRIORITY1_P1      3
#define BM_ENET_SWI_VLAN_PRIORITY1_P1      0x00000038

#define BF_ENET_SWI_VLAN_PRIORITY1_P1(v)   (((v) << 3) & BM_ENET_SWI_VLAN_PRIORITY1_P1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_PRIORITY1_P1(v)   BF_CS1(ENET_SWI_VLAN_PRIORITY1, P1, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_PRIORITY1, field P0 */

#define BP_ENET_SWI_VLAN_PRIORITY1_P0      0
#define BM_ENET_SWI_VLAN_PRIORITY1_P0      0x00000007

#define BF_ENET_SWI_VLAN_PRIORITY1_P0(v)   (((v) << 0) & BM_ENET_SWI_VLAN_PRIORITY1_P0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_PRIORITY1_P0(v)   BF_CS1(ENET_SWI_VLAN_PRIORITY1, P0, v)
#endif



/*
 * HW_ENET_SWI_VLAN_PRIORITY2 - ENET SWI Port 2 VLAN priority resolution map
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned P0      :  3;
        unsigned P1      :  3;
        unsigned P2      :  3;
        unsigned P3      :  3;
        unsigned P4      :  3;
        unsigned P5      :  3;
        unsigned P6      :  3;
        unsigned P7      :  3;
        unsigned RSRVD0  :  8;
    } B;
} hw_enet_swi_vlan_priority2_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_VLAN_PRIORITY2 register
 */
#define HW_ENET_SWI_VLAN_PRIORITY2_ADDR         (REGS_ENET_BASE + 0x8108)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_VLAN_PRIORITY2           (*(volatile hw_enet_swi_vlan_priority2_t *) HW_ENET_SWI_VLAN_PRIORITY2_ADDR)
#define HW_ENET_SWI_VLAN_PRIORITY2_RD()      (HW_ENET_SWI_VLAN_PRIORITY2.U)
#define HW_ENET_SWI_VLAN_PRIORITY2_WR(v)     (HW_ENET_SWI_VLAN_PRIORITY2.U = (v))
#define HW_ENET_SWI_VLAN_PRIORITY2_SET(v)    (HW_ENET_SWI_VLAN_PRIORITY2_WR(HW_ENET_SWI_VLAN_PRIORITY2_RD() |  (v)))
#define HW_ENET_SWI_VLAN_PRIORITY2_CLR(v)    (HW_ENET_SWI_VLAN_PRIORITY2_WR(HW_ENET_SWI_VLAN_PRIORITY2_RD() & ~(v)))
#define HW_ENET_SWI_VLAN_PRIORITY2_TOG(v)    (HW_ENET_SWI_VLAN_PRIORITY2_WR(HW_ENET_SWI_VLAN_PRIORITY2_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_VLAN_PRIORITY2 bitfields
 */
/* --- Register HW_ENET_SWI_VLAN_PRIORITY2, field RSRVD0 */

#define BP_ENET_SWI_VLAN_PRIORITY2_RSRVD0      24
#define BM_ENET_SWI_VLAN_PRIORITY2_RSRVD0      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_VLAN_PRIORITY2_RSRVD0(v)   ((((reg32_t) v) << 24) & BM_ENET_SWI_VLAN_PRIORITY2_RSRVD0)
#else
#define BF_ENET_SWI_VLAN_PRIORITY2_RSRVD0(v)   (((v) << 24) & BM_ENET_SWI_VLAN_PRIORITY2_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_VLAN_PRIORITY2, field P7 */

#define BP_ENET_SWI_VLAN_PRIORITY2_P7      21
#define BM_ENET_SWI_VLAN_PRIORITY2_P7      0x00E00000

#define BF_ENET_SWI_VLAN_PRIORITY2_P7(v)   (((v) << 21) & BM_ENET_SWI_VLAN_PRIORITY2_P7)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_PRIORITY2_P7(v)   BF_CS1(ENET_SWI_VLAN_PRIORITY2, P7, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_PRIORITY2, field P6 */

#define BP_ENET_SWI_VLAN_PRIORITY2_P6      18
#define BM_ENET_SWI_VLAN_PRIORITY2_P6      0x001C0000

#define BF_ENET_SWI_VLAN_PRIORITY2_P6(v)   (((v) << 18) & BM_ENET_SWI_VLAN_PRIORITY2_P6)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_PRIORITY2_P6(v)   BF_CS1(ENET_SWI_VLAN_PRIORITY2, P6, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_PRIORITY2, field P5 */

#define BP_ENET_SWI_VLAN_PRIORITY2_P5      15
#define BM_ENET_SWI_VLAN_PRIORITY2_P5      0x00038000

#define BF_ENET_SWI_VLAN_PRIORITY2_P5(v)   (((v) << 15) & BM_ENET_SWI_VLAN_PRIORITY2_P5)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_PRIORITY2_P5(v)   BF_CS1(ENET_SWI_VLAN_PRIORITY2, P5, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_PRIORITY2, field P4 */

#define BP_ENET_SWI_VLAN_PRIORITY2_P4      12
#define BM_ENET_SWI_VLAN_PRIORITY2_P4      0x00007000

#define BF_ENET_SWI_VLAN_PRIORITY2_P4(v)   (((v) << 12) & BM_ENET_SWI_VLAN_PRIORITY2_P4)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_PRIORITY2_P4(v)   BF_CS1(ENET_SWI_VLAN_PRIORITY2, P4, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_PRIORITY2, field P3 */

#define BP_ENET_SWI_VLAN_PRIORITY2_P3      9
#define BM_ENET_SWI_VLAN_PRIORITY2_P3      0x00000E00

#define BF_ENET_SWI_VLAN_PRIORITY2_P3(v)   (((v) << 9) & BM_ENET_SWI_VLAN_PRIORITY2_P3)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_PRIORITY2_P3(v)   BF_CS1(ENET_SWI_VLAN_PRIORITY2, P3, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_PRIORITY2, field P2 */

#define BP_ENET_SWI_VLAN_PRIORITY2_P2      6
#define BM_ENET_SWI_VLAN_PRIORITY2_P2      0x000001C0

#define BF_ENET_SWI_VLAN_PRIORITY2_P2(v)   (((v) << 6) & BM_ENET_SWI_VLAN_PRIORITY2_P2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_PRIORITY2_P2(v)   BF_CS1(ENET_SWI_VLAN_PRIORITY2, P2, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_PRIORITY2, field P1 */

#define BP_ENET_SWI_VLAN_PRIORITY2_P1      3
#define BM_ENET_SWI_VLAN_PRIORITY2_P1      0x00000038

#define BF_ENET_SWI_VLAN_PRIORITY2_P1(v)   (((v) << 3) & BM_ENET_SWI_VLAN_PRIORITY2_P1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_PRIORITY2_P1(v)   BF_CS1(ENET_SWI_VLAN_PRIORITY2, P1, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_PRIORITY2, field P0 */

#define BP_ENET_SWI_VLAN_PRIORITY2_P0      0
#define BM_ENET_SWI_VLAN_PRIORITY2_P0      0x00000007

#define BF_ENET_SWI_VLAN_PRIORITY2_P0(v)   (((v) << 0) & BM_ENET_SWI_VLAN_PRIORITY2_P0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_PRIORITY2_P0(v)   BF_CS1(ENET_SWI_VLAN_PRIORITY2, P0, v)
#endif



/*
 * HW_ENET_SWI_IP_PRIORITY - ENET SWI IPv4 and IPv6 priority resolution table programming
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ADDRESS         :  8;
        unsigned IPV4_SELECT     :  1;
        unsigned PRIORITY_PORT0  :  2;
        unsigned PRIORITY_PORT1  :  2;
        unsigned PRIORITY_PORT2  :  2;
        unsigned RSRVD0          : 16;
        unsigned READ            :  1;
    } B;
} hw_enet_swi_ip_priority_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_IP_PRIORITY register
 */
#define HW_ENET_SWI_IP_PRIORITY_ADDR         (REGS_ENET_BASE + 0x8140)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_IP_PRIORITY           (*(volatile hw_enet_swi_ip_priority_t *) HW_ENET_SWI_IP_PRIORITY_ADDR)
#define HW_ENET_SWI_IP_PRIORITY_RD()      (HW_ENET_SWI_IP_PRIORITY.U)
#define HW_ENET_SWI_IP_PRIORITY_WR(v)     (HW_ENET_SWI_IP_PRIORITY.U = (v))
#define HW_ENET_SWI_IP_PRIORITY_SET(v)    (HW_ENET_SWI_IP_PRIORITY_WR(HW_ENET_SWI_IP_PRIORITY_RD() |  (v)))
#define HW_ENET_SWI_IP_PRIORITY_CLR(v)    (HW_ENET_SWI_IP_PRIORITY_WR(HW_ENET_SWI_IP_PRIORITY_RD() & ~(v)))
#define HW_ENET_SWI_IP_PRIORITY_TOG(v)    (HW_ENET_SWI_IP_PRIORITY_WR(HW_ENET_SWI_IP_PRIORITY_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_IP_PRIORITY bitfields
 */
/* --- Register HW_ENET_SWI_IP_PRIORITY, field READ */

#define BP_ENET_SWI_IP_PRIORITY_READ      31
#define BM_ENET_SWI_IP_PRIORITY_READ      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_IP_PRIORITY_READ(v)   ((((reg32_t) v) << 31) & BM_ENET_SWI_IP_PRIORITY_READ)
#else
#define BF_ENET_SWI_IP_PRIORITY_READ(v)   (((v) << 31) & BM_ENET_SWI_IP_PRIORITY_READ)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_IP_PRIORITY_READ(v)   BF_CS1(ENET_SWI_IP_PRIORITY, READ, v)
#endif

/* --- Register HW_ENET_SWI_IP_PRIORITY, field RSRVD0 */

#define BP_ENET_SWI_IP_PRIORITY_RSRVD0      15
#define BM_ENET_SWI_IP_PRIORITY_RSRVD0      0x7FFF8000

#define BF_ENET_SWI_IP_PRIORITY_RSRVD0(v)   (((v) << 15) & BM_ENET_SWI_IP_PRIORITY_RSRVD0)
/* --- Register HW_ENET_SWI_IP_PRIORITY, field PRIORITY_PORT2 */

#define BP_ENET_SWI_IP_PRIORITY_PRIORITY_PORT2      13
#define BM_ENET_SWI_IP_PRIORITY_PRIORITY_PORT2      0x00006000

#define BF_ENET_SWI_IP_PRIORITY_PRIORITY_PORT2(v)   (((v) << 13) & BM_ENET_SWI_IP_PRIORITY_PRIORITY_PORT2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_IP_PRIORITY_PRIORITY_PORT2(v)   BF_CS1(ENET_SWI_IP_PRIORITY, PRIORITY_PORT2, v)
#endif

/* --- Register HW_ENET_SWI_IP_PRIORITY, field PRIORITY_PORT1 */

#define BP_ENET_SWI_IP_PRIORITY_PRIORITY_PORT1      11
#define BM_ENET_SWI_IP_PRIORITY_PRIORITY_PORT1      0x00001800

#define BF_ENET_SWI_IP_PRIORITY_PRIORITY_PORT1(v)   (((v) << 11) & BM_ENET_SWI_IP_PRIORITY_PRIORITY_PORT1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_IP_PRIORITY_PRIORITY_PORT1(v)   BF_CS1(ENET_SWI_IP_PRIORITY, PRIORITY_PORT1, v)
#endif

/* --- Register HW_ENET_SWI_IP_PRIORITY, field PRIORITY_PORT0 */

#define BP_ENET_SWI_IP_PRIORITY_PRIORITY_PORT0      9
#define BM_ENET_SWI_IP_PRIORITY_PRIORITY_PORT0      0x00000600

#define BF_ENET_SWI_IP_PRIORITY_PRIORITY_PORT0(v)   (((v) << 9) & BM_ENET_SWI_IP_PRIORITY_PRIORITY_PORT0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_IP_PRIORITY_PRIORITY_PORT0(v)   BF_CS1(ENET_SWI_IP_PRIORITY, PRIORITY_PORT0, v)
#endif

/* --- Register HW_ENET_SWI_IP_PRIORITY, field IPV4_SELECT */

#define BP_ENET_SWI_IP_PRIORITY_IPV4_SELECT      8
#define BM_ENET_SWI_IP_PRIORITY_IPV4_SELECT      0x00000100

#define BF_ENET_SWI_IP_PRIORITY_IPV4_SELECT(v)   (((v) << 8) & BM_ENET_SWI_IP_PRIORITY_IPV4_SELECT)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_IP_PRIORITY_IPV4_SELECT(v)   BF_CS1(ENET_SWI_IP_PRIORITY, IPV4_SELECT, v)
#endif

/* --- Register HW_ENET_SWI_IP_PRIORITY, field ADDRESS */

#define BP_ENET_SWI_IP_PRIORITY_ADDRESS      0
#define BM_ENET_SWI_IP_PRIORITY_ADDRESS      0x000000FF

#define BF_ENET_SWI_IP_PRIORITY_ADDRESS(v)   (((v) << 0) & BM_ENET_SWI_IP_PRIORITY_ADDRESS)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_IP_PRIORITY_ADDRESS(v)   (HW_ENET_SWI_IP_PRIORITY.B.ADDRESS = (v))
#endif



/*
 * HW_ENET_SWI_PRIORITY_CFG0 - ENET SWI Port 0 Priority resolution configuration
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned VLAN_EN           :  1;
        unsigned IP_EN             :  1;
        unsigned MAC_EN            :  1;
        unsigned RSRVD0            :  1;
        unsigned DEFAULT_PRIORITY  :  3;
        unsigned RSRVD1            : 25;
    } B;
} hw_enet_swi_priority_cfg0_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_PRIORITY_CFG0 register
 */
#define HW_ENET_SWI_PRIORITY_CFG0_ADDR         (REGS_ENET_BASE + 0x8180)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_PRIORITY_CFG0           (*(volatile hw_enet_swi_priority_cfg0_t *) HW_ENET_SWI_PRIORITY_CFG0_ADDR)
#define HW_ENET_SWI_PRIORITY_CFG0_RD()      (HW_ENET_SWI_PRIORITY_CFG0.U)
#define HW_ENET_SWI_PRIORITY_CFG0_WR(v)     (HW_ENET_SWI_PRIORITY_CFG0.U = (v))
#define HW_ENET_SWI_PRIORITY_CFG0_SET(v)    (HW_ENET_SWI_PRIORITY_CFG0_WR(HW_ENET_SWI_PRIORITY_CFG0_RD() |  (v)))
#define HW_ENET_SWI_PRIORITY_CFG0_CLR(v)    (HW_ENET_SWI_PRIORITY_CFG0_WR(HW_ENET_SWI_PRIORITY_CFG0_RD() & ~(v)))
#define HW_ENET_SWI_PRIORITY_CFG0_TOG(v)    (HW_ENET_SWI_PRIORITY_CFG0_WR(HW_ENET_SWI_PRIORITY_CFG0_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_PRIORITY_CFG0 bitfields
 */
/* --- Register HW_ENET_SWI_PRIORITY_CFG0, field RSRVD1 */

#define BP_ENET_SWI_PRIORITY_CFG0_RSRVD1      7
#define BM_ENET_SWI_PRIORITY_CFG0_RSRVD1      0xFFFFFF80

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_PRIORITY_CFG0_RSRVD1(v)   ((((reg32_t) v) << 7) & BM_ENET_SWI_PRIORITY_CFG0_RSRVD1)
#else
#define BF_ENET_SWI_PRIORITY_CFG0_RSRVD1(v)   (((v) << 7) & BM_ENET_SWI_PRIORITY_CFG0_RSRVD1)
#endif
/* --- Register HW_ENET_SWI_PRIORITY_CFG0, field DEFAULT_PRIORITY */

#define BP_ENET_SWI_PRIORITY_CFG0_DEFAULT_PRIORITY      4
#define BM_ENET_SWI_PRIORITY_CFG0_DEFAULT_PRIORITY      0x00000070

#define BF_ENET_SWI_PRIORITY_CFG0_DEFAULT_PRIORITY(v)   (((v) << 4) & BM_ENET_SWI_PRIORITY_CFG0_DEFAULT_PRIORITY)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PRIORITY_CFG0_DEFAULT_PRIORITY(v)   BF_CS1(ENET_SWI_PRIORITY_CFG0, DEFAULT_PRIORITY, v)
#endif

/* --- Register HW_ENET_SWI_PRIORITY_CFG0, field RSRVD0 */

#define BP_ENET_SWI_PRIORITY_CFG0_RSRVD0      3
#define BM_ENET_SWI_PRIORITY_CFG0_RSRVD0      0x00000008

#define BF_ENET_SWI_PRIORITY_CFG0_RSRVD0(v)   (((v) << 3) & BM_ENET_SWI_PRIORITY_CFG0_RSRVD0)
/* --- Register HW_ENET_SWI_PRIORITY_CFG0, field MAC_EN */

#define BP_ENET_SWI_PRIORITY_CFG0_MAC_EN      2
#define BM_ENET_SWI_PRIORITY_CFG0_MAC_EN      0x00000004

#define BF_ENET_SWI_PRIORITY_CFG0_MAC_EN(v)   (((v) << 2) & BM_ENET_SWI_PRIORITY_CFG0_MAC_EN)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PRIORITY_CFG0_MAC_EN(v)   BF_CS1(ENET_SWI_PRIORITY_CFG0, MAC_EN, v)
#endif

/* --- Register HW_ENET_SWI_PRIORITY_CFG0, field IP_EN */

#define BP_ENET_SWI_PRIORITY_CFG0_IP_EN      1
#define BM_ENET_SWI_PRIORITY_CFG0_IP_EN      0x00000002

#define BF_ENET_SWI_PRIORITY_CFG0_IP_EN(v)   (((v) << 1) & BM_ENET_SWI_PRIORITY_CFG0_IP_EN)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PRIORITY_CFG0_IP_EN(v)   BF_CS1(ENET_SWI_PRIORITY_CFG0, IP_EN, v)
#endif

/* --- Register HW_ENET_SWI_PRIORITY_CFG0, field VLAN_EN */

#define BP_ENET_SWI_PRIORITY_CFG0_VLAN_EN      0
#define BM_ENET_SWI_PRIORITY_CFG0_VLAN_EN      0x00000001

#define BF_ENET_SWI_PRIORITY_CFG0_VLAN_EN(v)   (((v) << 0) & BM_ENET_SWI_PRIORITY_CFG0_VLAN_EN)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PRIORITY_CFG0_VLAN_EN(v)   BF_CS1(ENET_SWI_PRIORITY_CFG0, VLAN_EN, v)
#endif



/*
 * HW_ENET_SWI_PRIORITY_CFG1 - ENET SWI Port 1 Priority resolution configuration
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned VLAN_EN           :  1;
        unsigned IP_EN             :  1;
        unsigned MAC_EN            :  1;
        unsigned RSRVD0            :  1;
        unsigned DEFAULT_PRIORITY  :  3;
        unsigned RSRVD1            : 25;
    } B;
} hw_enet_swi_priority_cfg1_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_PRIORITY_CFG1 register
 */
#define HW_ENET_SWI_PRIORITY_CFG1_ADDR         (REGS_ENET_BASE + 0x8184)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_PRIORITY_CFG1           (*(volatile hw_enet_swi_priority_cfg1_t *) HW_ENET_SWI_PRIORITY_CFG1_ADDR)
#define HW_ENET_SWI_PRIORITY_CFG1_RD()      (HW_ENET_SWI_PRIORITY_CFG1.U)
#define HW_ENET_SWI_PRIORITY_CFG1_WR(v)     (HW_ENET_SWI_PRIORITY_CFG1.U = (v))
#define HW_ENET_SWI_PRIORITY_CFG1_SET(v)    (HW_ENET_SWI_PRIORITY_CFG1_WR(HW_ENET_SWI_PRIORITY_CFG1_RD() |  (v)))
#define HW_ENET_SWI_PRIORITY_CFG1_CLR(v)    (HW_ENET_SWI_PRIORITY_CFG1_WR(HW_ENET_SWI_PRIORITY_CFG1_RD() & ~(v)))
#define HW_ENET_SWI_PRIORITY_CFG1_TOG(v)    (HW_ENET_SWI_PRIORITY_CFG1_WR(HW_ENET_SWI_PRIORITY_CFG1_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_PRIORITY_CFG1 bitfields
 */
/* --- Register HW_ENET_SWI_PRIORITY_CFG1, field RSRVD1 */

#define BP_ENET_SWI_PRIORITY_CFG1_RSRVD1      7
#define BM_ENET_SWI_PRIORITY_CFG1_RSRVD1      0xFFFFFF80

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_PRIORITY_CFG1_RSRVD1(v)   ((((reg32_t) v) << 7) & BM_ENET_SWI_PRIORITY_CFG1_RSRVD1)
#else
#define BF_ENET_SWI_PRIORITY_CFG1_RSRVD1(v)   (((v) << 7) & BM_ENET_SWI_PRIORITY_CFG1_RSRVD1)
#endif
/* --- Register HW_ENET_SWI_PRIORITY_CFG1, field DEFAULT_PRIORITY */

#define BP_ENET_SWI_PRIORITY_CFG1_DEFAULT_PRIORITY      4
#define BM_ENET_SWI_PRIORITY_CFG1_DEFAULT_PRIORITY      0x00000070

#define BF_ENET_SWI_PRIORITY_CFG1_DEFAULT_PRIORITY(v)   (((v) << 4) & BM_ENET_SWI_PRIORITY_CFG1_DEFAULT_PRIORITY)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PRIORITY_CFG1_DEFAULT_PRIORITY(v)   BF_CS1(ENET_SWI_PRIORITY_CFG1, DEFAULT_PRIORITY, v)
#endif

/* --- Register HW_ENET_SWI_PRIORITY_CFG1, field RSRVD0 */

#define BP_ENET_SWI_PRIORITY_CFG1_RSRVD0      3
#define BM_ENET_SWI_PRIORITY_CFG1_RSRVD0      0x00000008

#define BF_ENET_SWI_PRIORITY_CFG1_RSRVD0(v)   (((v) << 3) & BM_ENET_SWI_PRIORITY_CFG1_RSRVD0)
/* --- Register HW_ENET_SWI_PRIORITY_CFG1, field MAC_EN */

#define BP_ENET_SWI_PRIORITY_CFG1_MAC_EN      2
#define BM_ENET_SWI_PRIORITY_CFG1_MAC_EN      0x00000004

#define BF_ENET_SWI_PRIORITY_CFG1_MAC_EN(v)   (((v) << 2) & BM_ENET_SWI_PRIORITY_CFG1_MAC_EN)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PRIORITY_CFG1_MAC_EN(v)   BF_CS1(ENET_SWI_PRIORITY_CFG1, MAC_EN, v)
#endif

/* --- Register HW_ENET_SWI_PRIORITY_CFG1, field IP_EN */

#define BP_ENET_SWI_PRIORITY_CFG1_IP_EN      1
#define BM_ENET_SWI_PRIORITY_CFG1_IP_EN      0x00000002

#define BF_ENET_SWI_PRIORITY_CFG1_IP_EN(v)   (((v) << 1) & BM_ENET_SWI_PRIORITY_CFG1_IP_EN)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PRIORITY_CFG1_IP_EN(v)   BF_CS1(ENET_SWI_PRIORITY_CFG1, IP_EN, v)
#endif

/* --- Register HW_ENET_SWI_PRIORITY_CFG1, field VLAN_EN */

#define BP_ENET_SWI_PRIORITY_CFG1_VLAN_EN      0
#define BM_ENET_SWI_PRIORITY_CFG1_VLAN_EN      0x00000001

#define BF_ENET_SWI_PRIORITY_CFG1_VLAN_EN(v)   (((v) << 0) & BM_ENET_SWI_PRIORITY_CFG1_VLAN_EN)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PRIORITY_CFG1_VLAN_EN(v)   BF_CS1(ENET_SWI_PRIORITY_CFG1, VLAN_EN, v)
#endif



/*
 * HW_ENET_SWI_PRIORITY_CFG2 - ENET SWI Port 2 Priority resolution configuration
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned VLAN_EN           :  1;
        unsigned IP_EN             :  1;
        unsigned MAC_EN            :  1;
        unsigned RSRVD0            :  1;
        unsigned DEFAULT_PRIORITY  :  3;
        unsigned RSRVD1            : 25;
    } B;
} hw_enet_swi_priority_cfg2_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_PRIORITY_CFG2 register
 */
#define HW_ENET_SWI_PRIORITY_CFG2_ADDR         (REGS_ENET_BASE + 0x8188)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_PRIORITY_CFG2           (*(volatile hw_enet_swi_priority_cfg2_t *) HW_ENET_SWI_PRIORITY_CFG2_ADDR)
#define HW_ENET_SWI_PRIORITY_CFG2_RD()      (HW_ENET_SWI_PRIORITY_CFG2.U)
#define HW_ENET_SWI_PRIORITY_CFG2_WR(v)     (HW_ENET_SWI_PRIORITY_CFG2.U = (v))
#define HW_ENET_SWI_PRIORITY_CFG2_SET(v)    (HW_ENET_SWI_PRIORITY_CFG2_WR(HW_ENET_SWI_PRIORITY_CFG2_RD() |  (v)))
#define HW_ENET_SWI_PRIORITY_CFG2_CLR(v)    (HW_ENET_SWI_PRIORITY_CFG2_WR(HW_ENET_SWI_PRIORITY_CFG2_RD() & ~(v)))
#define HW_ENET_SWI_PRIORITY_CFG2_TOG(v)    (HW_ENET_SWI_PRIORITY_CFG2_WR(HW_ENET_SWI_PRIORITY_CFG2_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_PRIORITY_CFG2 bitfields
 */
/* --- Register HW_ENET_SWI_PRIORITY_CFG2, field RSRVD1 */

#define BP_ENET_SWI_PRIORITY_CFG2_RSRVD1      7
#define BM_ENET_SWI_PRIORITY_CFG2_RSRVD1      0xFFFFFF80

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_PRIORITY_CFG2_RSRVD1(v)   ((((reg32_t) v) << 7) & BM_ENET_SWI_PRIORITY_CFG2_RSRVD1)
#else
#define BF_ENET_SWI_PRIORITY_CFG2_RSRVD1(v)   (((v) << 7) & BM_ENET_SWI_PRIORITY_CFG2_RSRVD1)
#endif
/* --- Register HW_ENET_SWI_PRIORITY_CFG2, field DEFAULT_PRIORITY */

#define BP_ENET_SWI_PRIORITY_CFG2_DEFAULT_PRIORITY      4
#define BM_ENET_SWI_PRIORITY_CFG2_DEFAULT_PRIORITY      0x00000070

#define BF_ENET_SWI_PRIORITY_CFG2_DEFAULT_PRIORITY(v)   (((v) << 4) & BM_ENET_SWI_PRIORITY_CFG2_DEFAULT_PRIORITY)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PRIORITY_CFG2_DEFAULT_PRIORITY(v)   BF_CS1(ENET_SWI_PRIORITY_CFG2, DEFAULT_PRIORITY, v)
#endif

/* --- Register HW_ENET_SWI_PRIORITY_CFG2, field RSRVD0 */

#define BP_ENET_SWI_PRIORITY_CFG2_RSRVD0      3
#define BM_ENET_SWI_PRIORITY_CFG2_RSRVD0      0x00000008

#define BF_ENET_SWI_PRIORITY_CFG2_RSRVD0(v)   (((v) << 3) & BM_ENET_SWI_PRIORITY_CFG2_RSRVD0)
/* --- Register HW_ENET_SWI_PRIORITY_CFG2, field MAC_EN */

#define BP_ENET_SWI_PRIORITY_CFG2_MAC_EN      2
#define BM_ENET_SWI_PRIORITY_CFG2_MAC_EN      0x00000004

#define BF_ENET_SWI_PRIORITY_CFG2_MAC_EN(v)   (((v) << 2) & BM_ENET_SWI_PRIORITY_CFG2_MAC_EN)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PRIORITY_CFG2_MAC_EN(v)   BF_CS1(ENET_SWI_PRIORITY_CFG2, MAC_EN, v)
#endif

/* --- Register HW_ENET_SWI_PRIORITY_CFG2, field IP_EN */

#define BP_ENET_SWI_PRIORITY_CFG2_IP_EN      1
#define BM_ENET_SWI_PRIORITY_CFG2_IP_EN      0x00000002

#define BF_ENET_SWI_PRIORITY_CFG2_IP_EN(v)   (((v) << 1) & BM_ENET_SWI_PRIORITY_CFG2_IP_EN)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PRIORITY_CFG2_IP_EN(v)   BF_CS1(ENET_SWI_PRIORITY_CFG2, IP_EN, v)
#endif

/* --- Register HW_ENET_SWI_PRIORITY_CFG2, field VLAN_EN */

#define BP_ENET_SWI_PRIORITY_CFG2_VLAN_EN      0
#define BM_ENET_SWI_PRIORITY_CFG2_VLAN_EN      0x00000001

#define BF_ENET_SWI_PRIORITY_CFG2_VLAN_EN(v)   (((v) << 0) & BM_ENET_SWI_PRIORITY_CFG2_VLAN_EN)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_PRIORITY_CFG2_VLAN_EN(v)   BF_CS1(ENET_SWI_PRIORITY_CFG2, VLAN_EN, v)
#endif



/*
 * HW_ENET_SWI_SYSTEM_TAGINFO0 - ENET SWI Port 0 VLAN-ID field for VLAN input manipulation function
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned SYSTEM_TAGINFO0  : 16;
        unsigned RSRVD0           : 16;
    } B;
} hw_enet_swi_system_taginfo0_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_SYSTEM_TAGINFO0 register
 */
#define HW_ENET_SWI_SYSTEM_TAGINFO0_ADDR         (REGS_ENET_BASE + 0x8200)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_SYSTEM_TAGINFO0           (*(volatile hw_enet_swi_system_taginfo0_t *) HW_ENET_SWI_SYSTEM_TAGINFO0_ADDR)
#define HW_ENET_SWI_SYSTEM_TAGINFO0_RD()      (HW_ENET_SWI_SYSTEM_TAGINFO0.U)
#define HW_ENET_SWI_SYSTEM_TAGINFO0_WR(v)     (HW_ENET_SWI_SYSTEM_TAGINFO0.U = (v))
#define HW_ENET_SWI_SYSTEM_TAGINFO0_SET(v)    (HW_ENET_SWI_SYSTEM_TAGINFO0_WR(HW_ENET_SWI_SYSTEM_TAGINFO0_RD() |  (v)))
#define HW_ENET_SWI_SYSTEM_TAGINFO0_CLR(v)    (HW_ENET_SWI_SYSTEM_TAGINFO0_WR(HW_ENET_SWI_SYSTEM_TAGINFO0_RD() & ~(v)))
#define HW_ENET_SWI_SYSTEM_TAGINFO0_TOG(v)    (HW_ENET_SWI_SYSTEM_TAGINFO0_WR(HW_ENET_SWI_SYSTEM_TAGINFO0_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_SYSTEM_TAGINFO0 bitfields
 */
/* --- Register HW_ENET_SWI_SYSTEM_TAGINFO0, field RSRVD0 */

#define BP_ENET_SWI_SYSTEM_TAGINFO0_RSRVD0      16
#define BM_ENET_SWI_SYSTEM_TAGINFO0_RSRVD0      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_SYSTEM_TAGINFO0_RSRVD0(v)   ((((reg32_t) v) << 16) & BM_ENET_SWI_SYSTEM_TAGINFO0_RSRVD0)
#else
#define BF_ENET_SWI_SYSTEM_TAGINFO0_RSRVD0(v)   (((v) << 16) & BM_ENET_SWI_SYSTEM_TAGINFO0_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_SYSTEM_TAGINFO0, field SYSTEM_TAGINFO0 */

#define BP_ENET_SWI_SYSTEM_TAGINFO0_SYSTEM_TAGINFO0      0
#define BM_ENET_SWI_SYSTEM_TAGINFO0_SYSTEM_TAGINFO0      0x0000FFFF

#define BF_ENET_SWI_SYSTEM_TAGINFO0_SYSTEM_TAGINFO0(v)   (((v) << 0) & BM_ENET_SWI_SYSTEM_TAGINFO0_SYSTEM_TAGINFO0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_SYSTEM_TAGINFO0_SYSTEM_TAGINFO0(v)   (HW_ENET_SWI_SYSTEM_TAGINFO0.B.SYSTEM_TAGINFO0 = (v))
#endif



/*
 * HW_ENET_SWI_SYSTEM_TAGINFO1 - ENET SWI Port 1 VLAN-ID field for VLAN input manipulation function
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned SYSTEM_TAGINFO0  : 16;
        unsigned RSRVD0           : 16;
    } B;
} hw_enet_swi_system_taginfo1_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_SYSTEM_TAGINFO1 register
 */
#define HW_ENET_SWI_SYSTEM_TAGINFO1_ADDR         (REGS_ENET_BASE + 0x8204)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_SYSTEM_TAGINFO1           (*(volatile hw_enet_swi_system_taginfo1_t *) HW_ENET_SWI_SYSTEM_TAGINFO1_ADDR)
#define HW_ENET_SWI_SYSTEM_TAGINFO1_RD()      (HW_ENET_SWI_SYSTEM_TAGINFO1.U)
#define HW_ENET_SWI_SYSTEM_TAGINFO1_WR(v)     (HW_ENET_SWI_SYSTEM_TAGINFO1.U = (v))
#define HW_ENET_SWI_SYSTEM_TAGINFO1_SET(v)    (HW_ENET_SWI_SYSTEM_TAGINFO1_WR(HW_ENET_SWI_SYSTEM_TAGINFO1_RD() |  (v)))
#define HW_ENET_SWI_SYSTEM_TAGINFO1_CLR(v)    (HW_ENET_SWI_SYSTEM_TAGINFO1_WR(HW_ENET_SWI_SYSTEM_TAGINFO1_RD() & ~(v)))
#define HW_ENET_SWI_SYSTEM_TAGINFO1_TOG(v)    (HW_ENET_SWI_SYSTEM_TAGINFO1_WR(HW_ENET_SWI_SYSTEM_TAGINFO1_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_SYSTEM_TAGINFO1 bitfields
 */
/* --- Register HW_ENET_SWI_SYSTEM_TAGINFO1, field RSRVD0 */

#define BP_ENET_SWI_SYSTEM_TAGINFO1_RSRVD0      16
#define BM_ENET_SWI_SYSTEM_TAGINFO1_RSRVD0      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_SYSTEM_TAGINFO1_RSRVD0(v)   ((((reg32_t) v) << 16) & BM_ENET_SWI_SYSTEM_TAGINFO1_RSRVD0)
#else
#define BF_ENET_SWI_SYSTEM_TAGINFO1_RSRVD0(v)   (((v) << 16) & BM_ENET_SWI_SYSTEM_TAGINFO1_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_SYSTEM_TAGINFO1, field SYSTEM_TAGINFO0 */

#define BP_ENET_SWI_SYSTEM_TAGINFO1_SYSTEM_TAGINFO0      0
#define BM_ENET_SWI_SYSTEM_TAGINFO1_SYSTEM_TAGINFO0      0x0000FFFF

#define BF_ENET_SWI_SYSTEM_TAGINFO1_SYSTEM_TAGINFO0(v)   (((v) << 0) & BM_ENET_SWI_SYSTEM_TAGINFO1_SYSTEM_TAGINFO0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_SYSTEM_TAGINFO1_SYSTEM_TAGINFO0(v)   (HW_ENET_SWI_SYSTEM_TAGINFO1.B.SYSTEM_TAGINFO0 = (v))
#endif



/*
 * HW_ENET_SWI_SYSTEM_TAGINFO2 - ENET SWI Port 2 VLAN-ID field for VLAN input manipulation function
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned SYSTEM_TAGINFO0  : 16;
        unsigned RSRVD0           : 16;
    } B;
} hw_enet_swi_system_taginfo2_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_SYSTEM_TAGINFO2 register
 */
#define HW_ENET_SWI_SYSTEM_TAGINFO2_ADDR         (REGS_ENET_BASE + 0x8208)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_SYSTEM_TAGINFO2           (*(volatile hw_enet_swi_system_taginfo2_t *) HW_ENET_SWI_SYSTEM_TAGINFO2_ADDR)
#define HW_ENET_SWI_SYSTEM_TAGINFO2_RD()      (HW_ENET_SWI_SYSTEM_TAGINFO2.U)
#define HW_ENET_SWI_SYSTEM_TAGINFO2_WR(v)     (HW_ENET_SWI_SYSTEM_TAGINFO2.U = (v))
#define HW_ENET_SWI_SYSTEM_TAGINFO2_SET(v)    (HW_ENET_SWI_SYSTEM_TAGINFO2_WR(HW_ENET_SWI_SYSTEM_TAGINFO2_RD() |  (v)))
#define HW_ENET_SWI_SYSTEM_TAGINFO2_CLR(v)    (HW_ENET_SWI_SYSTEM_TAGINFO2_WR(HW_ENET_SWI_SYSTEM_TAGINFO2_RD() & ~(v)))
#define HW_ENET_SWI_SYSTEM_TAGINFO2_TOG(v)    (HW_ENET_SWI_SYSTEM_TAGINFO2_WR(HW_ENET_SWI_SYSTEM_TAGINFO2_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_SYSTEM_TAGINFO2 bitfields
 */
/* --- Register HW_ENET_SWI_SYSTEM_TAGINFO2, field RSRVD0 */

#define BP_ENET_SWI_SYSTEM_TAGINFO2_RSRVD0      16
#define BM_ENET_SWI_SYSTEM_TAGINFO2_RSRVD0      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_SYSTEM_TAGINFO2_RSRVD0(v)   ((((reg32_t) v) << 16) & BM_ENET_SWI_SYSTEM_TAGINFO2_RSRVD0)
#else
#define BF_ENET_SWI_SYSTEM_TAGINFO2_RSRVD0(v)   (((v) << 16) & BM_ENET_SWI_SYSTEM_TAGINFO2_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_SYSTEM_TAGINFO2, field SYSTEM_TAGINFO0 */

#define BP_ENET_SWI_SYSTEM_TAGINFO2_SYSTEM_TAGINFO0      0
#define BM_ENET_SWI_SYSTEM_TAGINFO2_SYSTEM_TAGINFO0      0x0000FFFF

#define BF_ENET_SWI_SYSTEM_TAGINFO2_SYSTEM_TAGINFO0(v)   (((v) << 0) & BM_ENET_SWI_SYSTEM_TAGINFO2_SYSTEM_TAGINFO0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_SYSTEM_TAGINFO2_SYSTEM_TAGINFO0(v)   (HW_ENET_SWI_SYSTEM_TAGINFO2.B.SYSTEM_TAGINFO0 = (v))
#endif



/*
 * HW_ENET_SWI_VLAN_RES_TABLE_0 - ENET SWI VLAN domain resolution entry 0.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PORT_0     :  1;
        unsigned PORT_1     :  1;
        unsigned PORT_2     :  1;
        unsigned VLAN_ID_0  : 12;
        unsigned RSRVD0     : 17;
    } B;
} hw_enet_swi_vlan_res_table_0_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_VLAN_RES_TABLE_0 register
 */
#define HW_ENET_SWI_VLAN_RES_TABLE_0_ADDR         (REGS_ENET_BASE + 0x8280)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_VLAN_RES_TABLE_0           (*(volatile hw_enet_swi_vlan_res_table_0_t *) HW_ENET_SWI_VLAN_RES_TABLE_0_ADDR)
#define HW_ENET_SWI_VLAN_RES_TABLE_0_RD()      (HW_ENET_SWI_VLAN_RES_TABLE_0.U)
#define HW_ENET_SWI_VLAN_RES_TABLE_0_WR(v)     (HW_ENET_SWI_VLAN_RES_TABLE_0.U = (v))
#define HW_ENET_SWI_VLAN_RES_TABLE_0_SET(v)    (HW_ENET_SWI_VLAN_RES_TABLE_0_WR(HW_ENET_SWI_VLAN_RES_TABLE_0_RD() |  (v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_0_CLR(v)    (HW_ENET_SWI_VLAN_RES_TABLE_0_WR(HW_ENET_SWI_VLAN_RES_TABLE_0_RD() & ~(v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_0_TOG(v)    (HW_ENET_SWI_VLAN_RES_TABLE_0_WR(HW_ENET_SWI_VLAN_RES_TABLE_0_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_VLAN_RES_TABLE_0 bitfields
 */
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_0, field RSRVD0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_0_RSRVD0      15
#define BM_ENET_SWI_VLAN_RES_TABLE_0_RSRVD0      0xFFFF8000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_VLAN_RES_TABLE_0_RSRVD0(v)   ((((reg32_t) v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_0_RSRVD0)
#else
#define BF_ENET_SWI_VLAN_RES_TABLE_0_RSRVD0(v)   (((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_0_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_0, field VLAN_ID_0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_0_VLAN_ID_0      3
#define BM_ENET_SWI_VLAN_RES_TABLE_0_VLAN_ID_0      0x00007FF8

#define BF_ENET_SWI_VLAN_RES_TABLE_0_VLAN_ID_0(v)   (((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_0_VLAN_ID_0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_0_VLAN_ID_0(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_0, VLAN_ID_0, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_0, field PORT_2 */

#define BP_ENET_SWI_VLAN_RES_TABLE_0_PORT_2      2
#define BM_ENET_SWI_VLAN_RES_TABLE_0_PORT_2      0x00000004

#define BF_ENET_SWI_VLAN_RES_TABLE_0_PORT_2(v)   (((v) << 2) & BM_ENET_SWI_VLAN_RES_TABLE_0_PORT_2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_0_PORT_2(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_0, PORT_2, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_0, field PORT_1 */

#define BP_ENET_SWI_VLAN_RES_TABLE_0_PORT_1      1
#define BM_ENET_SWI_VLAN_RES_TABLE_0_PORT_1      0x00000002

#define BF_ENET_SWI_VLAN_RES_TABLE_0_PORT_1(v)   (((v) << 1) & BM_ENET_SWI_VLAN_RES_TABLE_0_PORT_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_0_PORT_1(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_0, PORT_1, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_0, field PORT_0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_0_PORT_0      0
#define BM_ENET_SWI_VLAN_RES_TABLE_0_PORT_0      0x00000001

#define BF_ENET_SWI_VLAN_RES_TABLE_0_PORT_0(v)   (((v) << 0) & BM_ENET_SWI_VLAN_RES_TABLE_0_PORT_0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_0_PORT_0(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_0, PORT_0, v)
#endif



/*
 * HW_ENET_SWI_VLAN_RES_TABLE_1 - ENET SWI VLAN domain resolution entry 1.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PORT_0     :  1;
        unsigned PORT_1     :  1;
        unsigned PORT_2     :  1;
        unsigned VLAN_ID_1  : 12;
        unsigned RSRVD0     : 17;
    } B;
} hw_enet_swi_vlan_res_table_1_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_VLAN_RES_TABLE_1 register
 */
#define HW_ENET_SWI_VLAN_RES_TABLE_1_ADDR         (REGS_ENET_BASE + 0x8284)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_VLAN_RES_TABLE_1           (*(volatile hw_enet_swi_vlan_res_table_1_t *) HW_ENET_SWI_VLAN_RES_TABLE_1_ADDR)
#define HW_ENET_SWI_VLAN_RES_TABLE_1_RD()      (HW_ENET_SWI_VLAN_RES_TABLE_1.U)
#define HW_ENET_SWI_VLAN_RES_TABLE_1_WR(v)     (HW_ENET_SWI_VLAN_RES_TABLE_1.U = (v))
#define HW_ENET_SWI_VLAN_RES_TABLE_1_SET(v)    (HW_ENET_SWI_VLAN_RES_TABLE_1_WR(HW_ENET_SWI_VLAN_RES_TABLE_1_RD() |  (v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_1_CLR(v)    (HW_ENET_SWI_VLAN_RES_TABLE_1_WR(HW_ENET_SWI_VLAN_RES_TABLE_1_RD() & ~(v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_1_TOG(v)    (HW_ENET_SWI_VLAN_RES_TABLE_1_WR(HW_ENET_SWI_VLAN_RES_TABLE_1_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_VLAN_RES_TABLE_1 bitfields
 */
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_1, field RSRVD0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_1_RSRVD0      15
#define BM_ENET_SWI_VLAN_RES_TABLE_1_RSRVD0      0xFFFF8000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_VLAN_RES_TABLE_1_RSRVD0(v)   ((((reg32_t) v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_1_RSRVD0)
#else
#define BF_ENET_SWI_VLAN_RES_TABLE_1_RSRVD0(v)   (((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_1_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_1, field VLAN_ID_1 */

#define BP_ENET_SWI_VLAN_RES_TABLE_1_VLAN_ID_1      3
#define BM_ENET_SWI_VLAN_RES_TABLE_1_VLAN_ID_1      0x00007FF8

#define BF_ENET_SWI_VLAN_RES_TABLE_1_VLAN_ID_1(v)   (((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_1_VLAN_ID_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_1_VLAN_ID_1(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_1, VLAN_ID_1, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_1, field PORT_2 */

#define BP_ENET_SWI_VLAN_RES_TABLE_1_PORT_2      2
#define BM_ENET_SWI_VLAN_RES_TABLE_1_PORT_2      0x00000004

#define BF_ENET_SWI_VLAN_RES_TABLE_1_PORT_2(v)   (((v) << 2) & BM_ENET_SWI_VLAN_RES_TABLE_1_PORT_2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_1_PORT_2(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_1, PORT_2, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_1, field PORT_1 */

#define BP_ENET_SWI_VLAN_RES_TABLE_1_PORT_1      1
#define BM_ENET_SWI_VLAN_RES_TABLE_1_PORT_1      0x00000002

#define BF_ENET_SWI_VLAN_RES_TABLE_1_PORT_1(v)   (((v) << 1) & BM_ENET_SWI_VLAN_RES_TABLE_1_PORT_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_1_PORT_1(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_1, PORT_1, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_1, field PORT_0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_1_PORT_0      0
#define BM_ENET_SWI_VLAN_RES_TABLE_1_PORT_0      0x00000001

#define BF_ENET_SWI_VLAN_RES_TABLE_1_PORT_0(v)   (((v) << 0) & BM_ENET_SWI_VLAN_RES_TABLE_1_PORT_0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_1_PORT_0(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_1, PORT_0, v)
#endif



/*
 * HW_ENET_SWI_VLAN_RES_TABLE_2 - ENET SWI VLAN domain resolution entry 2.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PORT_0     :  1;
        unsigned PORT_1     :  1;
        unsigned PORT_2     :  1;
        unsigned VLAN_ID_2  : 12;
        unsigned RSRVD0     : 17;
    } B;
} hw_enet_swi_vlan_res_table_2_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_VLAN_RES_TABLE_2 register
 */
#define HW_ENET_SWI_VLAN_RES_TABLE_2_ADDR         (REGS_ENET_BASE + 0x8288)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_VLAN_RES_TABLE_2           (*(volatile hw_enet_swi_vlan_res_table_2_t *) HW_ENET_SWI_VLAN_RES_TABLE_2_ADDR)
#define HW_ENET_SWI_VLAN_RES_TABLE_2_RD()      (HW_ENET_SWI_VLAN_RES_TABLE_2.U)
#define HW_ENET_SWI_VLAN_RES_TABLE_2_WR(v)     (HW_ENET_SWI_VLAN_RES_TABLE_2.U = (v))
#define HW_ENET_SWI_VLAN_RES_TABLE_2_SET(v)    (HW_ENET_SWI_VLAN_RES_TABLE_2_WR(HW_ENET_SWI_VLAN_RES_TABLE_2_RD() |  (v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_2_CLR(v)    (HW_ENET_SWI_VLAN_RES_TABLE_2_WR(HW_ENET_SWI_VLAN_RES_TABLE_2_RD() & ~(v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_2_TOG(v)    (HW_ENET_SWI_VLAN_RES_TABLE_2_WR(HW_ENET_SWI_VLAN_RES_TABLE_2_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_VLAN_RES_TABLE_2 bitfields
 */
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_2, field RSRVD0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_2_RSRVD0      15
#define BM_ENET_SWI_VLAN_RES_TABLE_2_RSRVD0      0xFFFF8000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_VLAN_RES_TABLE_2_RSRVD0(v)   ((((reg32_t) v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_2_RSRVD0)
#else
#define BF_ENET_SWI_VLAN_RES_TABLE_2_RSRVD0(v)   (((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_2_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_2, field VLAN_ID_2 */

#define BP_ENET_SWI_VLAN_RES_TABLE_2_VLAN_ID_2      3
#define BM_ENET_SWI_VLAN_RES_TABLE_2_VLAN_ID_2      0x00007FF8

#define BF_ENET_SWI_VLAN_RES_TABLE_2_VLAN_ID_2(v)   (((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_2_VLAN_ID_2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_2_VLAN_ID_2(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_2, VLAN_ID_2, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_2, field PORT_2 */

#define BP_ENET_SWI_VLAN_RES_TABLE_2_PORT_2      2
#define BM_ENET_SWI_VLAN_RES_TABLE_2_PORT_2      0x00000004

#define BF_ENET_SWI_VLAN_RES_TABLE_2_PORT_2(v)   (((v) << 2) & BM_ENET_SWI_VLAN_RES_TABLE_2_PORT_2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_2_PORT_2(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_2, PORT_2, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_2, field PORT_1 */

#define BP_ENET_SWI_VLAN_RES_TABLE_2_PORT_1      1
#define BM_ENET_SWI_VLAN_RES_TABLE_2_PORT_1      0x00000002

#define BF_ENET_SWI_VLAN_RES_TABLE_2_PORT_1(v)   (((v) << 1) & BM_ENET_SWI_VLAN_RES_TABLE_2_PORT_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_2_PORT_1(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_2, PORT_1, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_2, field PORT_0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_2_PORT_0      0
#define BM_ENET_SWI_VLAN_RES_TABLE_2_PORT_0      0x00000001

#define BF_ENET_SWI_VLAN_RES_TABLE_2_PORT_0(v)   (((v) << 0) & BM_ENET_SWI_VLAN_RES_TABLE_2_PORT_0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_2_PORT_0(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_2, PORT_0, v)
#endif



/*
 * HW_ENET_SWI_VLAN_RES_TABLE_3 - ENET SWI VLAN domain resolution entry 3.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PORT_0     :  1;
        unsigned PORT_1     :  1;
        unsigned PORT_2     :  1;
        unsigned VLAN_ID_3  : 12;
        unsigned RSRVD0     : 17;
    } B;
} hw_enet_swi_vlan_res_table_3_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_VLAN_RES_TABLE_3 register
 */
#define HW_ENET_SWI_VLAN_RES_TABLE_3_ADDR         (REGS_ENET_BASE + 0x828c)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_VLAN_RES_TABLE_3           (*(volatile hw_enet_swi_vlan_res_table_3_t *) HW_ENET_SWI_VLAN_RES_TABLE_3_ADDR)
#define HW_ENET_SWI_VLAN_RES_TABLE_3_RD()      (HW_ENET_SWI_VLAN_RES_TABLE_3.U)
#define HW_ENET_SWI_VLAN_RES_TABLE_3_WR(v)     (HW_ENET_SWI_VLAN_RES_TABLE_3.U = (v))
#define HW_ENET_SWI_VLAN_RES_TABLE_3_SET(v)    (HW_ENET_SWI_VLAN_RES_TABLE_3_WR(HW_ENET_SWI_VLAN_RES_TABLE_3_RD() |  (v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_3_CLR(v)    (HW_ENET_SWI_VLAN_RES_TABLE_3_WR(HW_ENET_SWI_VLAN_RES_TABLE_3_RD() & ~(v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_3_TOG(v)    (HW_ENET_SWI_VLAN_RES_TABLE_3_WR(HW_ENET_SWI_VLAN_RES_TABLE_3_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_VLAN_RES_TABLE_3 bitfields
 */
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_3, field RSRVD0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_3_RSRVD0      15
#define BM_ENET_SWI_VLAN_RES_TABLE_3_RSRVD0      0xFFFF8000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_VLAN_RES_TABLE_3_RSRVD0(v)   ((((reg32_t) v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_3_RSRVD0)
#else
#define BF_ENET_SWI_VLAN_RES_TABLE_3_RSRVD0(v)   (((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_3_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_3, field VLAN_ID_3 */

#define BP_ENET_SWI_VLAN_RES_TABLE_3_VLAN_ID_3      3
#define BM_ENET_SWI_VLAN_RES_TABLE_3_VLAN_ID_3      0x00007FF8

#define BF_ENET_SWI_VLAN_RES_TABLE_3_VLAN_ID_3(v)   (((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_3_VLAN_ID_3)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_3_VLAN_ID_3(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_3, VLAN_ID_3, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_3, field PORT_2 */

#define BP_ENET_SWI_VLAN_RES_TABLE_3_PORT_2      2
#define BM_ENET_SWI_VLAN_RES_TABLE_3_PORT_2      0x00000004

#define BF_ENET_SWI_VLAN_RES_TABLE_3_PORT_2(v)   (((v) << 2) & BM_ENET_SWI_VLAN_RES_TABLE_3_PORT_2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_3_PORT_2(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_3, PORT_2, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_3, field PORT_1 */

#define BP_ENET_SWI_VLAN_RES_TABLE_3_PORT_1      1
#define BM_ENET_SWI_VLAN_RES_TABLE_3_PORT_1      0x00000002

#define BF_ENET_SWI_VLAN_RES_TABLE_3_PORT_1(v)   (((v) << 1) & BM_ENET_SWI_VLAN_RES_TABLE_3_PORT_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_3_PORT_1(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_3, PORT_1, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_3, field PORT_0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_3_PORT_0      0
#define BM_ENET_SWI_VLAN_RES_TABLE_3_PORT_0      0x00000001

#define BF_ENET_SWI_VLAN_RES_TABLE_3_PORT_0(v)   (((v) << 0) & BM_ENET_SWI_VLAN_RES_TABLE_3_PORT_0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_3_PORT_0(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_3, PORT_0, v)
#endif



/*
 * HW_ENET_SWI_VLAN_RES_TABLE_4 - ENET SWI VLAN domain resolution entry 4.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PORT_0     :  1;
        unsigned PORT_1     :  1;
        unsigned PORT_2     :  1;
        unsigned VLAN_ID_4  : 12;
        unsigned RSRVD0     : 17;
    } B;
} hw_enet_swi_vlan_res_table_4_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_VLAN_RES_TABLE_4 register
 */
#define HW_ENET_SWI_VLAN_RES_TABLE_4_ADDR         (REGS_ENET_BASE + 0x8290)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_VLAN_RES_TABLE_4           (*(volatile hw_enet_swi_vlan_res_table_4_t *) HW_ENET_SWI_VLAN_RES_TABLE_4_ADDR)
#define HW_ENET_SWI_VLAN_RES_TABLE_4_RD()      (HW_ENET_SWI_VLAN_RES_TABLE_4.U)
#define HW_ENET_SWI_VLAN_RES_TABLE_4_WR(v)     (HW_ENET_SWI_VLAN_RES_TABLE_4.U = (v))
#define HW_ENET_SWI_VLAN_RES_TABLE_4_SET(v)    (HW_ENET_SWI_VLAN_RES_TABLE_4_WR(HW_ENET_SWI_VLAN_RES_TABLE_4_RD() |  (v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_4_CLR(v)    (HW_ENET_SWI_VLAN_RES_TABLE_4_WR(HW_ENET_SWI_VLAN_RES_TABLE_4_RD() & ~(v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_4_TOG(v)    (HW_ENET_SWI_VLAN_RES_TABLE_4_WR(HW_ENET_SWI_VLAN_RES_TABLE_4_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_VLAN_RES_TABLE_4 bitfields
 */
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_4, field RSRVD0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_4_RSRVD0      15
#define BM_ENET_SWI_VLAN_RES_TABLE_4_RSRVD0      0xFFFF8000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_VLAN_RES_TABLE_4_RSRVD0(v)   ((((reg32_t) v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_4_RSRVD0)
#else
#define BF_ENET_SWI_VLAN_RES_TABLE_4_RSRVD0(v)   (((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_4_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_4, field VLAN_ID_4 */

#define BP_ENET_SWI_VLAN_RES_TABLE_4_VLAN_ID_4      3
#define BM_ENET_SWI_VLAN_RES_TABLE_4_VLAN_ID_4      0x00007FF8

#define BF_ENET_SWI_VLAN_RES_TABLE_4_VLAN_ID_4(v)   (((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_4_VLAN_ID_4)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_4_VLAN_ID_4(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_4, VLAN_ID_4, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_4, field PORT_2 */

#define BP_ENET_SWI_VLAN_RES_TABLE_4_PORT_2      2
#define BM_ENET_SWI_VLAN_RES_TABLE_4_PORT_2      0x00000004

#define BF_ENET_SWI_VLAN_RES_TABLE_4_PORT_2(v)   (((v) << 2) & BM_ENET_SWI_VLAN_RES_TABLE_4_PORT_2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_4_PORT_2(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_4, PORT_2, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_4, field PORT_1 */

#define BP_ENET_SWI_VLAN_RES_TABLE_4_PORT_1      1
#define BM_ENET_SWI_VLAN_RES_TABLE_4_PORT_1      0x00000002

#define BF_ENET_SWI_VLAN_RES_TABLE_4_PORT_1(v)   (((v) << 1) & BM_ENET_SWI_VLAN_RES_TABLE_4_PORT_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_4_PORT_1(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_4, PORT_1, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_4, field PORT_0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_4_PORT_0      0
#define BM_ENET_SWI_VLAN_RES_TABLE_4_PORT_0      0x00000001

#define BF_ENET_SWI_VLAN_RES_TABLE_4_PORT_0(v)   (((v) << 0) & BM_ENET_SWI_VLAN_RES_TABLE_4_PORT_0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_4_PORT_0(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_4, PORT_0, v)
#endif



/*
 * HW_ENET_SWI_VLAN_RES_TABLE_5 - ENET SWI VLAN domain resolution entry 5.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PORT_0     :  1;
        unsigned PORT_1     :  1;
        unsigned PORT_2     :  1;
        unsigned VLAN_ID_5  : 12;
        unsigned RSRVD0     : 17;
    } B;
} hw_enet_swi_vlan_res_table_5_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_VLAN_RES_TABLE_5 register
 */
#define HW_ENET_SWI_VLAN_RES_TABLE_5_ADDR         (REGS_ENET_BASE + 0x8294)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_VLAN_RES_TABLE_5           (*(volatile hw_enet_swi_vlan_res_table_5_t *) HW_ENET_SWI_VLAN_RES_TABLE_5_ADDR)
#define HW_ENET_SWI_VLAN_RES_TABLE_5_RD()      (HW_ENET_SWI_VLAN_RES_TABLE_5.U)
#define HW_ENET_SWI_VLAN_RES_TABLE_5_WR(v)     (HW_ENET_SWI_VLAN_RES_TABLE_5.U = (v))
#define HW_ENET_SWI_VLAN_RES_TABLE_5_SET(v)    (HW_ENET_SWI_VLAN_RES_TABLE_5_WR(HW_ENET_SWI_VLAN_RES_TABLE_5_RD() |  (v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_5_CLR(v)    (HW_ENET_SWI_VLAN_RES_TABLE_5_WR(HW_ENET_SWI_VLAN_RES_TABLE_5_RD() & ~(v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_5_TOG(v)    (HW_ENET_SWI_VLAN_RES_TABLE_5_WR(HW_ENET_SWI_VLAN_RES_TABLE_5_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_VLAN_RES_TABLE_5 bitfields
 */
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_5, field RSRVD0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_5_RSRVD0      15
#define BM_ENET_SWI_VLAN_RES_TABLE_5_RSRVD0      0xFFFF8000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_VLAN_RES_TABLE_5_RSRVD0(v)   ((((reg32_t) v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_5_RSRVD0)
#else
#define BF_ENET_SWI_VLAN_RES_TABLE_5_RSRVD0(v)   (((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_5_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_5, field VLAN_ID_5 */

#define BP_ENET_SWI_VLAN_RES_TABLE_5_VLAN_ID_5      3
#define BM_ENET_SWI_VLAN_RES_TABLE_5_VLAN_ID_5      0x00007FF8

#define BF_ENET_SWI_VLAN_RES_TABLE_5_VLAN_ID_5(v)   (((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_5_VLAN_ID_5)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_5_VLAN_ID_5(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_5, VLAN_ID_5, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_5, field PORT_2 */

#define BP_ENET_SWI_VLAN_RES_TABLE_5_PORT_2      2
#define BM_ENET_SWI_VLAN_RES_TABLE_5_PORT_2      0x00000004

#define BF_ENET_SWI_VLAN_RES_TABLE_5_PORT_2(v)   (((v) << 2) & BM_ENET_SWI_VLAN_RES_TABLE_5_PORT_2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_5_PORT_2(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_5, PORT_2, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_5, field PORT_1 */

#define BP_ENET_SWI_VLAN_RES_TABLE_5_PORT_1      1
#define BM_ENET_SWI_VLAN_RES_TABLE_5_PORT_1      0x00000002

#define BF_ENET_SWI_VLAN_RES_TABLE_5_PORT_1(v)   (((v) << 1) & BM_ENET_SWI_VLAN_RES_TABLE_5_PORT_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_5_PORT_1(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_5, PORT_1, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_5, field PORT_0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_5_PORT_0      0
#define BM_ENET_SWI_VLAN_RES_TABLE_5_PORT_0      0x00000001

#define BF_ENET_SWI_VLAN_RES_TABLE_5_PORT_0(v)   (((v) << 0) & BM_ENET_SWI_VLAN_RES_TABLE_5_PORT_0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_5_PORT_0(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_5, PORT_0, v)
#endif



/*
 * HW_ENET_SWI_VLAN_RES_TABLE_6 - ENET SWI VLAN domain resolution entry 6.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PORT_0     :  1;
        unsigned PORT_1     :  1;
        unsigned PORT_2     :  1;
        unsigned VLAN_ID_6  : 12;
        unsigned RSRVD0     : 17;
    } B;
} hw_enet_swi_vlan_res_table_6_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_VLAN_RES_TABLE_6 register
 */
#define HW_ENET_SWI_VLAN_RES_TABLE_6_ADDR         (REGS_ENET_BASE + 0x8298)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_VLAN_RES_TABLE_6           (*(volatile hw_enet_swi_vlan_res_table_6_t *) HW_ENET_SWI_VLAN_RES_TABLE_6_ADDR)
#define HW_ENET_SWI_VLAN_RES_TABLE_6_RD()      (HW_ENET_SWI_VLAN_RES_TABLE_6.U)
#define HW_ENET_SWI_VLAN_RES_TABLE_6_WR(v)     (HW_ENET_SWI_VLAN_RES_TABLE_6.U = (v))
#define HW_ENET_SWI_VLAN_RES_TABLE_6_SET(v)    (HW_ENET_SWI_VLAN_RES_TABLE_6_WR(HW_ENET_SWI_VLAN_RES_TABLE_6_RD() |  (v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_6_CLR(v)    (HW_ENET_SWI_VLAN_RES_TABLE_6_WR(HW_ENET_SWI_VLAN_RES_TABLE_6_RD() & ~(v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_6_TOG(v)    (HW_ENET_SWI_VLAN_RES_TABLE_6_WR(HW_ENET_SWI_VLAN_RES_TABLE_6_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_VLAN_RES_TABLE_6 bitfields
 */
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_6, field RSRVD0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_6_RSRVD0      15
#define BM_ENET_SWI_VLAN_RES_TABLE_6_RSRVD0      0xFFFF8000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_VLAN_RES_TABLE_6_RSRVD0(v)   ((((reg32_t) v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_6_RSRVD0)
#else
#define BF_ENET_SWI_VLAN_RES_TABLE_6_RSRVD0(v)   (((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_6_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_6, field VLAN_ID_6 */

#define BP_ENET_SWI_VLAN_RES_TABLE_6_VLAN_ID_6      3
#define BM_ENET_SWI_VLAN_RES_TABLE_6_VLAN_ID_6      0x00007FF8

#define BF_ENET_SWI_VLAN_RES_TABLE_6_VLAN_ID_6(v)   (((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_6_VLAN_ID_6)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_6_VLAN_ID_6(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_6, VLAN_ID_6, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_6, field PORT_2 */

#define BP_ENET_SWI_VLAN_RES_TABLE_6_PORT_2      2
#define BM_ENET_SWI_VLAN_RES_TABLE_6_PORT_2      0x00000004

#define BF_ENET_SWI_VLAN_RES_TABLE_6_PORT_2(v)   (((v) << 2) & BM_ENET_SWI_VLAN_RES_TABLE_6_PORT_2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_6_PORT_2(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_6, PORT_2, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_6, field PORT_1 */

#define BP_ENET_SWI_VLAN_RES_TABLE_6_PORT_1      1
#define BM_ENET_SWI_VLAN_RES_TABLE_6_PORT_1      0x00000002

#define BF_ENET_SWI_VLAN_RES_TABLE_6_PORT_1(v)   (((v) << 1) & BM_ENET_SWI_VLAN_RES_TABLE_6_PORT_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_6_PORT_1(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_6, PORT_1, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_6, field PORT_0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_6_PORT_0      0
#define BM_ENET_SWI_VLAN_RES_TABLE_6_PORT_0      0x00000001

#define BF_ENET_SWI_VLAN_RES_TABLE_6_PORT_0(v)   (((v) << 0) & BM_ENET_SWI_VLAN_RES_TABLE_6_PORT_0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_6_PORT_0(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_6, PORT_0, v)
#endif



/*
 * HW_ENET_SWI_VLAN_RES_TABLE_7 - ENET SWI VLAN domain resolution entry 7.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PORT_0     :  1;
        unsigned PORT_1     :  1;
        unsigned PORT_2     :  1;
        unsigned VLAN_ID_7  : 12;
        unsigned RSRVD0     : 17;
    } B;
} hw_enet_swi_vlan_res_table_7_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_VLAN_RES_TABLE_7 register
 */
#define HW_ENET_SWI_VLAN_RES_TABLE_7_ADDR         (REGS_ENET_BASE + 0x829c)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_VLAN_RES_TABLE_7           (*(volatile hw_enet_swi_vlan_res_table_7_t *) HW_ENET_SWI_VLAN_RES_TABLE_7_ADDR)
#define HW_ENET_SWI_VLAN_RES_TABLE_7_RD()      (HW_ENET_SWI_VLAN_RES_TABLE_7.U)
#define HW_ENET_SWI_VLAN_RES_TABLE_7_WR(v)     (HW_ENET_SWI_VLAN_RES_TABLE_7.U = (v))
#define HW_ENET_SWI_VLAN_RES_TABLE_7_SET(v)    (HW_ENET_SWI_VLAN_RES_TABLE_7_WR(HW_ENET_SWI_VLAN_RES_TABLE_7_RD() |  (v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_7_CLR(v)    (HW_ENET_SWI_VLAN_RES_TABLE_7_WR(HW_ENET_SWI_VLAN_RES_TABLE_7_RD() & ~(v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_7_TOG(v)    (HW_ENET_SWI_VLAN_RES_TABLE_7_WR(HW_ENET_SWI_VLAN_RES_TABLE_7_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_VLAN_RES_TABLE_7 bitfields
 */
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_7, field RSRVD0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_7_RSRVD0      15
#define BM_ENET_SWI_VLAN_RES_TABLE_7_RSRVD0      0xFFFF8000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_VLAN_RES_TABLE_7_RSRVD0(v)   ((((reg32_t) v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_7_RSRVD0)
#else
#define BF_ENET_SWI_VLAN_RES_TABLE_7_RSRVD0(v)   (((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_7_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_7, field VLAN_ID_7 */

#define BP_ENET_SWI_VLAN_RES_TABLE_7_VLAN_ID_7      3
#define BM_ENET_SWI_VLAN_RES_TABLE_7_VLAN_ID_7      0x00007FF8

#define BF_ENET_SWI_VLAN_RES_TABLE_7_VLAN_ID_7(v)   (((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_7_VLAN_ID_7)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_7_VLAN_ID_7(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_7, VLAN_ID_7, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_7, field PORT_2 */

#define BP_ENET_SWI_VLAN_RES_TABLE_7_PORT_2      2
#define BM_ENET_SWI_VLAN_RES_TABLE_7_PORT_2      0x00000004

#define BF_ENET_SWI_VLAN_RES_TABLE_7_PORT_2(v)   (((v) << 2) & BM_ENET_SWI_VLAN_RES_TABLE_7_PORT_2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_7_PORT_2(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_7, PORT_2, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_7, field PORT_1 */

#define BP_ENET_SWI_VLAN_RES_TABLE_7_PORT_1      1
#define BM_ENET_SWI_VLAN_RES_TABLE_7_PORT_1      0x00000002

#define BF_ENET_SWI_VLAN_RES_TABLE_7_PORT_1(v)   (((v) << 1) & BM_ENET_SWI_VLAN_RES_TABLE_7_PORT_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_7_PORT_1(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_7, PORT_1, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_7, field PORT_0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_7_PORT_0      0
#define BM_ENET_SWI_VLAN_RES_TABLE_7_PORT_0      0x00000001

#define BF_ENET_SWI_VLAN_RES_TABLE_7_PORT_0(v)   (((v) << 0) & BM_ENET_SWI_VLAN_RES_TABLE_7_PORT_0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_7_PORT_0(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_7, PORT_0, v)
#endif



/*
 * HW_ENET_SWI_VLAN_RES_TABLE_8 - ENET SWI VLAN domain resolution entry 8.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PORT_0     :  1;
        unsigned PORT_1     :  1;
        unsigned PORT_2     :  1;
        unsigned VLAN_ID_8  : 12;
        unsigned RSRVD0     : 17;
    } B;
} hw_enet_swi_vlan_res_table_8_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_VLAN_RES_TABLE_8 register
 */
#define HW_ENET_SWI_VLAN_RES_TABLE_8_ADDR         (REGS_ENET_BASE + 0x82a0)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_VLAN_RES_TABLE_8           (*(volatile hw_enet_swi_vlan_res_table_8_t *) HW_ENET_SWI_VLAN_RES_TABLE_8_ADDR)
#define HW_ENET_SWI_VLAN_RES_TABLE_8_RD()      (HW_ENET_SWI_VLAN_RES_TABLE_8.U)
#define HW_ENET_SWI_VLAN_RES_TABLE_8_WR(v)     (HW_ENET_SWI_VLAN_RES_TABLE_8.U = (v))
#define HW_ENET_SWI_VLAN_RES_TABLE_8_SET(v)    (HW_ENET_SWI_VLAN_RES_TABLE_8_WR(HW_ENET_SWI_VLAN_RES_TABLE_8_RD() |  (v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_8_CLR(v)    (HW_ENET_SWI_VLAN_RES_TABLE_8_WR(HW_ENET_SWI_VLAN_RES_TABLE_8_RD() & ~(v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_8_TOG(v)    (HW_ENET_SWI_VLAN_RES_TABLE_8_WR(HW_ENET_SWI_VLAN_RES_TABLE_8_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_VLAN_RES_TABLE_8 bitfields
 */
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_8, field RSRVD0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_8_RSRVD0      15
#define BM_ENET_SWI_VLAN_RES_TABLE_8_RSRVD0      0xFFFF8000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_VLAN_RES_TABLE_8_RSRVD0(v)   ((((reg32_t) v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_8_RSRVD0)
#else
#define BF_ENET_SWI_VLAN_RES_TABLE_8_RSRVD0(v)   (((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_8_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_8, field VLAN_ID_8 */

#define BP_ENET_SWI_VLAN_RES_TABLE_8_VLAN_ID_8      3
#define BM_ENET_SWI_VLAN_RES_TABLE_8_VLAN_ID_8      0x00007FF8

#define BF_ENET_SWI_VLAN_RES_TABLE_8_VLAN_ID_8(v)   (((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_8_VLAN_ID_8)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_8_VLAN_ID_8(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_8, VLAN_ID_8, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_8, field PORT_2 */

#define BP_ENET_SWI_VLAN_RES_TABLE_8_PORT_2      2
#define BM_ENET_SWI_VLAN_RES_TABLE_8_PORT_2      0x00000004

#define BF_ENET_SWI_VLAN_RES_TABLE_8_PORT_2(v)   (((v) << 2) & BM_ENET_SWI_VLAN_RES_TABLE_8_PORT_2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_8_PORT_2(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_8, PORT_2, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_8, field PORT_1 */

#define BP_ENET_SWI_VLAN_RES_TABLE_8_PORT_1      1
#define BM_ENET_SWI_VLAN_RES_TABLE_8_PORT_1      0x00000002

#define BF_ENET_SWI_VLAN_RES_TABLE_8_PORT_1(v)   (((v) << 1) & BM_ENET_SWI_VLAN_RES_TABLE_8_PORT_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_8_PORT_1(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_8, PORT_1, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_8, field PORT_0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_8_PORT_0      0
#define BM_ENET_SWI_VLAN_RES_TABLE_8_PORT_0      0x00000001

#define BF_ENET_SWI_VLAN_RES_TABLE_8_PORT_0(v)   (((v) << 0) & BM_ENET_SWI_VLAN_RES_TABLE_8_PORT_0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_8_PORT_0(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_8, PORT_0, v)
#endif



/*
 * HW_ENET_SWI_VLAN_RES_TABLE_9 - ENET SWI VLAN domain resolution entry 9.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PORT_0     :  1;
        unsigned PORT_1     :  1;
        unsigned PORT_2     :  1;
        unsigned VLAN_ID_9  : 12;
        unsigned RSRVD0     : 17;
    } B;
} hw_enet_swi_vlan_res_table_9_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_VLAN_RES_TABLE_9 register
 */
#define HW_ENET_SWI_VLAN_RES_TABLE_9_ADDR         (REGS_ENET_BASE + 0x82a4)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_VLAN_RES_TABLE_9           (*(volatile hw_enet_swi_vlan_res_table_9_t *) HW_ENET_SWI_VLAN_RES_TABLE_9_ADDR)
#define HW_ENET_SWI_VLAN_RES_TABLE_9_RD()      (HW_ENET_SWI_VLAN_RES_TABLE_9.U)
#define HW_ENET_SWI_VLAN_RES_TABLE_9_WR(v)     (HW_ENET_SWI_VLAN_RES_TABLE_9.U = (v))
#define HW_ENET_SWI_VLAN_RES_TABLE_9_SET(v)    (HW_ENET_SWI_VLAN_RES_TABLE_9_WR(HW_ENET_SWI_VLAN_RES_TABLE_9_RD() |  (v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_9_CLR(v)    (HW_ENET_SWI_VLAN_RES_TABLE_9_WR(HW_ENET_SWI_VLAN_RES_TABLE_9_RD() & ~(v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_9_TOG(v)    (HW_ENET_SWI_VLAN_RES_TABLE_9_WR(HW_ENET_SWI_VLAN_RES_TABLE_9_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_VLAN_RES_TABLE_9 bitfields
 */
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_9, field RSRVD0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_9_RSRVD0      15
#define BM_ENET_SWI_VLAN_RES_TABLE_9_RSRVD0      0xFFFF8000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_VLAN_RES_TABLE_9_RSRVD0(v)   ((((reg32_t) v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_9_RSRVD0)
#else
#define BF_ENET_SWI_VLAN_RES_TABLE_9_RSRVD0(v)   (((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_9_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_9, field VLAN_ID_9 */

#define BP_ENET_SWI_VLAN_RES_TABLE_9_VLAN_ID_9      3
#define BM_ENET_SWI_VLAN_RES_TABLE_9_VLAN_ID_9      0x00007FF8

#define BF_ENET_SWI_VLAN_RES_TABLE_9_VLAN_ID_9(v)   (((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_9_VLAN_ID_9)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_9_VLAN_ID_9(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_9, VLAN_ID_9, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_9, field PORT_2 */

#define BP_ENET_SWI_VLAN_RES_TABLE_9_PORT_2      2
#define BM_ENET_SWI_VLAN_RES_TABLE_9_PORT_2      0x00000004

#define BF_ENET_SWI_VLAN_RES_TABLE_9_PORT_2(v)   (((v) << 2) & BM_ENET_SWI_VLAN_RES_TABLE_9_PORT_2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_9_PORT_2(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_9, PORT_2, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_9, field PORT_1 */

#define BP_ENET_SWI_VLAN_RES_TABLE_9_PORT_1      1
#define BM_ENET_SWI_VLAN_RES_TABLE_9_PORT_1      0x00000002

#define BF_ENET_SWI_VLAN_RES_TABLE_9_PORT_1(v)   (((v) << 1) & BM_ENET_SWI_VLAN_RES_TABLE_9_PORT_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_9_PORT_1(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_9, PORT_1, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_9, field PORT_0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_9_PORT_0      0
#define BM_ENET_SWI_VLAN_RES_TABLE_9_PORT_0      0x00000001

#define BF_ENET_SWI_VLAN_RES_TABLE_9_PORT_0(v)   (((v) << 0) & BM_ENET_SWI_VLAN_RES_TABLE_9_PORT_0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_9_PORT_0(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_9, PORT_0, v)
#endif



/*
 * HW_ENET_SWI_VLAN_RES_TABLE_10 - ENET SWI VLAN domain resolution entry 10.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PORT_0      :  1;
        unsigned PORT_1      :  1;
        unsigned PORT_2      :  1;
        unsigned VLAN_ID_10  : 12;
        unsigned RSRVD0      : 17;
    } B;
} hw_enet_swi_vlan_res_table_10_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_VLAN_RES_TABLE_10 register
 */
#define HW_ENET_SWI_VLAN_RES_TABLE_10_ADDR         (REGS_ENET_BASE + 0x82a8)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_VLAN_RES_TABLE_10           (*(volatile hw_enet_swi_vlan_res_table_10_t *) HW_ENET_SWI_VLAN_RES_TABLE_10_ADDR)
#define HW_ENET_SWI_VLAN_RES_TABLE_10_RD()      (HW_ENET_SWI_VLAN_RES_TABLE_10.U)
#define HW_ENET_SWI_VLAN_RES_TABLE_10_WR(v)     (HW_ENET_SWI_VLAN_RES_TABLE_10.U = (v))
#define HW_ENET_SWI_VLAN_RES_TABLE_10_SET(v)    (HW_ENET_SWI_VLAN_RES_TABLE_10_WR(HW_ENET_SWI_VLAN_RES_TABLE_10_RD() |  (v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_10_CLR(v)    (HW_ENET_SWI_VLAN_RES_TABLE_10_WR(HW_ENET_SWI_VLAN_RES_TABLE_10_RD() & ~(v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_10_TOG(v)    (HW_ENET_SWI_VLAN_RES_TABLE_10_WR(HW_ENET_SWI_VLAN_RES_TABLE_10_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_VLAN_RES_TABLE_10 bitfields
 */
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_10, field RSRVD0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_10_RSRVD0      15
#define BM_ENET_SWI_VLAN_RES_TABLE_10_RSRVD0      0xFFFF8000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_VLAN_RES_TABLE_10_RSRVD0(v)   ((((reg32_t) v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_10_RSRVD0)
#else
#define BF_ENET_SWI_VLAN_RES_TABLE_10_RSRVD0(v)   (((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_10_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_10, field VLAN_ID_10 */

#define BP_ENET_SWI_VLAN_RES_TABLE_10_VLAN_ID_10      3
#define BM_ENET_SWI_VLAN_RES_TABLE_10_VLAN_ID_10      0x00007FF8

#define BF_ENET_SWI_VLAN_RES_TABLE_10_VLAN_ID_10(v)   (((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_10_VLAN_ID_10)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_10_VLAN_ID_10(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_10, VLAN_ID_10, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_10, field PORT_2 */

#define BP_ENET_SWI_VLAN_RES_TABLE_10_PORT_2      2
#define BM_ENET_SWI_VLAN_RES_TABLE_10_PORT_2      0x00000004

#define BF_ENET_SWI_VLAN_RES_TABLE_10_PORT_2(v)   (((v) << 2) & BM_ENET_SWI_VLAN_RES_TABLE_10_PORT_2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_10_PORT_2(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_10, PORT_2, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_10, field PORT_1 */

#define BP_ENET_SWI_VLAN_RES_TABLE_10_PORT_1      1
#define BM_ENET_SWI_VLAN_RES_TABLE_10_PORT_1      0x00000002

#define BF_ENET_SWI_VLAN_RES_TABLE_10_PORT_1(v)   (((v) << 1) & BM_ENET_SWI_VLAN_RES_TABLE_10_PORT_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_10_PORT_1(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_10, PORT_1, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_10, field PORT_0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_10_PORT_0      0
#define BM_ENET_SWI_VLAN_RES_TABLE_10_PORT_0      0x00000001

#define BF_ENET_SWI_VLAN_RES_TABLE_10_PORT_0(v)   (((v) << 0) & BM_ENET_SWI_VLAN_RES_TABLE_10_PORT_0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_10_PORT_0(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_10, PORT_0, v)
#endif



/*
 * HW_ENET_SWI_VLAN_RES_TABLE_11 - ENET SWI VLAN domain resolution entry 11.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PORT_0      :  1;
        unsigned PORT_1      :  1;
        unsigned PORT_2      :  1;
        unsigned VLAN_ID_11  : 12;
        unsigned RSRVD0      : 17;
    } B;
} hw_enet_swi_vlan_res_table_11_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_VLAN_RES_TABLE_11 register
 */
#define HW_ENET_SWI_VLAN_RES_TABLE_11_ADDR         (REGS_ENET_BASE + 0x82ac)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_VLAN_RES_TABLE_11           (*(volatile hw_enet_swi_vlan_res_table_11_t *) HW_ENET_SWI_VLAN_RES_TABLE_11_ADDR)
#define HW_ENET_SWI_VLAN_RES_TABLE_11_RD()      (HW_ENET_SWI_VLAN_RES_TABLE_11.U)
#define HW_ENET_SWI_VLAN_RES_TABLE_11_WR(v)     (HW_ENET_SWI_VLAN_RES_TABLE_11.U = (v))
#define HW_ENET_SWI_VLAN_RES_TABLE_11_SET(v)    (HW_ENET_SWI_VLAN_RES_TABLE_11_WR(HW_ENET_SWI_VLAN_RES_TABLE_11_RD() |  (v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_11_CLR(v)    (HW_ENET_SWI_VLAN_RES_TABLE_11_WR(HW_ENET_SWI_VLAN_RES_TABLE_11_RD() & ~(v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_11_TOG(v)    (HW_ENET_SWI_VLAN_RES_TABLE_11_WR(HW_ENET_SWI_VLAN_RES_TABLE_11_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_VLAN_RES_TABLE_11 bitfields
 */
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_11, field RSRVD0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_11_RSRVD0      15
#define BM_ENET_SWI_VLAN_RES_TABLE_11_RSRVD0      0xFFFF8000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_VLAN_RES_TABLE_11_RSRVD0(v)   ((((reg32_t) v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_11_RSRVD0)
#else
#define BF_ENET_SWI_VLAN_RES_TABLE_11_RSRVD0(v)   (((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_11_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_11, field VLAN_ID_11 */

#define BP_ENET_SWI_VLAN_RES_TABLE_11_VLAN_ID_11      3
#define BM_ENET_SWI_VLAN_RES_TABLE_11_VLAN_ID_11      0x00007FF8

#define BF_ENET_SWI_VLAN_RES_TABLE_11_VLAN_ID_11(v)   (((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_11_VLAN_ID_11)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_11_VLAN_ID_11(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_11, VLAN_ID_11, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_11, field PORT_2 */

#define BP_ENET_SWI_VLAN_RES_TABLE_11_PORT_2      2
#define BM_ENET_SWI_VLAN_RES_TABLE_11_PORT_2      0x00000004

#define BF_ENET_SWI_VLAN_RES_TABLE_11_PORT_2(v)   (((v) << 2) & BM_ENET_SWI_VLAN_RES_TABLE_11_PORT_2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_11_PORT_2(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_11, PORT_2, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_11, field PORT_1 */

#define BP_ENET_SWI_VLAN_RES_TABLE_11_PORT_1      1
#define BM_ENET_SWI_VLAN_RES_TABLE_11_PORT_1      0x00000002

#define BF_ENET_SWI_VLAN_RES_TABLE_11_PORT_1(v)   (((v) << 1) & BM_ENET_SWI_VLAN_RES_TABLE_11_PORT_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_11_PORT_1(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_11, PORT_1, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_11, field PORT_0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_11_PORT_0      0
#define BM_ENET_SWI_VLAN_RES_TABLE_11_PORT_0      0x00000001

#define BF_ENET_SWI_VLAN_RES_TABLE_11_PORT_0(v)   (((v) << 0) & BM_ENET_SWI_VLAN_RES_TABLE_11_PORT_0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_11_PORT_0(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_11, PORT_0, v)
#endif



/*
 * HW_ENET_SWI_VLAN_RES_TABLE_12 - ENET SWI VLAN domain resolution entry 12.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PORT_0      :  1;
        unsigned PORT_1      :  1;
        unsigned PORT_2      :  1;
        unsigned VLAN_ID_12  : 12;
        unsigned RSRVD0      : 17;
    } B;
} hw_enet_swi_vlan_res_table_12_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_VLAN_RES_TABLE_12 register
 */
#define HW_ENET_SWI_VLAN_RES_TABLE_12_ADDR         (REGS_ENET_BASE + 0x82b0)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_VLAN_RES_TABLE_12           (*(volatile hw_enet_swi_vlan_res_table_12_t *) HW_ENET_SWI_VLAN_RES_TABLE_12_ADDR)
#define HW_ENET_SWI_VLAN_RES_TABLE_12_RD()      (HW_ENET_SWI_VLAN_RES_TABLE_12.U)
#define HW_ENET_SWI_VLAN_RES_TABLE_12_WR(v)     (HW_ENET_SWI_VLAN_RES_TABLE_12.U = (v))
#define HW_ENET_SWI_VLAN_RES_TABLE_12_SET(v)    (HW_ENET_SWI_VLAN_RES_TABLE_12_WR(HW_ENET_SWI_VLAN_RES_TABLE_12_RD() |  (v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_12_CLR(v)    (HW_ENET_SWI_VLAN_RES_TABLE_12_WR(HW_ENET_SWI_VLAN_RES_TABLE_12_RD() & ~(v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_12_TOG(v)    (HW_ENET_SWI_VLAN_RES_TABLE_12_WR(HW_ENET_SWI_VLAN_RES_TABLE_12_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_VLAN_RES_TABLE_12 bitfields
 */
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_12, field RSRVD0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_12_RSRVD0      15
#define BM_ENET_SWI_VLAN_RES_TABLE_12_RSRVD0      0xFFFF8000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_VLAN_RES_TABLE_12_RSRVD0(v)   ((((reg32_t) v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_12_RSRVD0)
#else
#define BF_ENET_SWI_VLAN_RES_TABLE_12_RSRVD0(v)   (((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_12_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_12, field VLAN_ID_12 */

#define BP_ENET_SWI_VLAN_RES_TABLE_12_VLAN_ID_12      3
#define BM_ENET_SWI_VLAN_RES_TABLE_12_VLAN_ID_12      0x00007FF8

#define BF_ENET_SWI_VLAN_RES_TABLE_12_VLAN_ID_12(v)   (((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_12_VLAN_ID_12)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_12_VLAN_ID_12(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_12, VLAN_ID_12, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_12, field PORT_2 */

#define BP_ENET_SWI_VLAN_RES_TABLE_12_PORT_2      2
#define BM_ENET_SWI_VLAN_RES_TABLE_12_PORT_2      0x00000004

#define BF_ENET_SWI_VLAN_RES_TABLE_12_PORT_2(v)   (((v) << 2) & BM_ENET_SWI_VLAN_RES_TABLE_12_PORT_2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_12_PORT_2(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_12, PORT_2, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_12, field PORT_1 */

#define BP_ENET_SWI_VLAN_RES_TABLE_12_PORT_1      1
#define BM_ENET_SWI_VLAN_RES_TABLE_12_PORT_1      0x00000002

#define BF_ENET_SWI_VLAN_RES_TABLE_12_PORT_1(v)   (((v) << 1) & BM_ENET_SWI_VLAN_RES_TABLE_12_PORT_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_12_PORT_1(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_12, PORT_1, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_12, field PORT_0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_12_PORT_0      0
#define BM_ENET_SWI_VLAN_RES_TABLE_12_PORT_0      0x00000001

#define BF_ENET_SWI_VLAN_RES_TABLE_12_PORT_0(v)   (((v) << 0) & BM_ENET_SWI_VLAN_RES_TABLE_12_PORT_0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_12_PORT_0(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_12, PORT_0, v)
#endif



/*
 * HW_ENET_SWI_VLAN_RES_TABLE_13 - ENET SWI VLAN domain resolution entry 13.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PORT_0      :  1;
        unsigned PORT_1      :  1;
        unsigned PORT_2      :  1;
        unsigned VLAN_ID_13  : 12;
        unsigned RSRVD0      : 17;
    } B;
} hw_enet_swi_vlan_res_table_13_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_VLAN_RES_TABLE_13 register
 */
#define HW_ENET_SWI_VLAN_RES_TABLE_13_ADDR         (REGS_ENET_BASE + 0x82b4)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_VLAN_RES_TABLE_13           (*(volatile hw_enet_swi_vlan_res_table_13_t *) HW_ENET_SWI_VLAN_RES_TABLE_13_ADDR)
#define HW_ENET_SWI_VLAN_RES_TABLE_13_RD()      (HW_ENET_SWI_VLAN_RES_TABLE_13.U)
#define HW_ENET_SWI_VLAN_RES_TABLE_13_WR(v)     (HW_ENET_SWI_VLAN_RES_TABLE_13.U = (v))
#define HW_ENET_SWI_VLAN_RES_TABLE_13_SET(v)    (HW_ENET_SWI_VLAN_RES_TABLE_13_WR(HW_ENET_SWI_VLAN_RES_TABLE_13_RD() |  (v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_13_CLR(v)    (HW_ENET_SWI_VLAN_RES_TABLE_13_WR(HW_ENET_SWI_VLAN_RES_TABLE_13_RD() & ~(v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_13_TOG(v)    (HW_ENET_SWI_VLAN_RES_TABLE_13_WR(HW_ENET_SWI_VLAN_RES_TABLE_13_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_VLAN_RES_TABLE_13 bitfields
 */
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_13, field RSRVD0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_13_RSRVD0      15
#define BM_ENET_SWI_VLAN_RES_TABLE_13_RSRVD0      0xFFFF8000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_VLAN_RES_TABLE_13_RSRVD0(v)   ((((reg32_t) v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_13_RSRVD0)
#else
#define BF_ENET_SWI_VLAN_RES_TABLE_13_RSRVD0(v)   (((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_13_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_13, field VLAN_ID_13 */

#define BP_ENET_SWI_VLAN_RES_TABLE_13_VLAN_ID_13      3
#define BM_ENET_SWI_VLAN_RES_TABLE_13_VLAN_ID_13      0x00007FF8

#define BF_ENET_SWI_VLAN_RES_TABLE_13_VLAN_ID_13(v)   (((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_13_VLAN_ID_13)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_13_VLAN_ID_13(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_13, VLAN_ID_13, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_13, field PORT_2 */

#define BP_ENET_SWI_VLAN_RES_TABLE_13_PORT_2      2
#define BM_ENET_SWI_VLAN_RES_TABLE_13_PORT_2      0x00000004

#define BF_ENET_SWI_VLAN_RES_TABLE_13_PORT_2(v)   (((v) << 2) & BM_ENET_SWI_VLAN_RES_TABLE_13_PORT_2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_13_PORT_2(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_13, PORT_2, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_13, field PORT_1 */

#define BP_ENET_SWI_VLAN_RES_TABLE_13_PORT_1      1
#define BM_ENET_SWI_VLAN_RES_TABLE_13_PORT_1      0x00000002

#define BF_ENET_SWI_VLAN_RES_TABLE_13_PORT_1(v)   (((v) << 1) & BM_ENET_SWI_VLAN_RES_TABLE_13_PORT_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_13_PORT_1(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_13, PORT_1, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_13, field PORT_0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_13_PORT_0      0
#define BM_ENET_SWI_VLAN_RES_TABLE_13_PORT_0      0x00000001

#define BF_ENET_SWI_VLAN_RES_TABLE_13_PORT_0(v)   (((v) << 0) & BM_ENET_SWI_VLAN_RES_TABLE_13_PORT_0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_13_PORT_0(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_13, PORT_0, v)
#endif



/*
 * HW_ENET_SWI_VLAN_RES_TABLE_14 - ENET SWI VLAN domain resolution entry 14.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PORT_0      :  1;
        unsigned PORT_1      :  1;
        unsigned PORT_2      :  1;
        unsigned VLAN_ID_14  : 12;
        unsigned RSRVD0      : 17;
    } B;
} hw_enet_swi_vlan_res_table_14_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_VLAN_RES_TABLE_14 register
 */
#define HW_ENET_SWI_VLAN_RES_TABLE_14_ADDR         (REGS_ENET_BASE + 0x82b8)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_VLAN_RES_TABLE_14           (*(volatile hw_enet_swi_vlan_res_table_14_t *) HW_ENET_SWI_VLAN_RES_TABLE_14_ADDR)
#define HW_ENET_SWI_VLAN_RES_TABLE_14_RD()      (HW_ENET_SWI_VLAN_RES_TABLE_14.U)
#define HW_ENET_SWI_VLAN_RES_TABLE_14_WR(v)     (HW_ENET_SWI_VLAN_RES_TABLE_14.U = (v))
#define HW_ENET_SWI_VLAN_RES_TABLE_14_SET(v)    (HW_ENET_SWI_VLAN_RES_TABLE_14_WR(HW_ENET_SWI_VLAN_RES_TABLE_14_RD() |  (v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_14_CLR(v)    (HW_ENET_SWI_VLAN_RES_TABLE_14_WR(HW_ENET_SWI_VLAN_RES_TABLE_14_RD() & ~(v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_14_TOG(v)    (HW_ENET_SWI_VLAN_RES_TABLE_14_WR(HW_ENET_SWI_VLAN_RES_TABLE_14_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_VLAN_RES_TABLE_14 bitfields
 */
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_14, field RSRVD0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_14_RSRVD0      15
#define BM_ENET_SWI_VLAN_RES_TABLE_14_RSRVD0      0xFFFF8000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_VLAN_RES_TABLE_14_RSRVD0(v)   ((((reg32_t) v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_14_RSRVD0)
#else
#define BF_ENET_SWI_VLAN_RES_TABLE_14_RSRVD0(v)   (((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_14_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_14, field VLAN_ID_14 */

#define BP_ENET_SWI_VLAN_RES_TABLE_14_VLAN_ID_14      3
#define BM_ENET_SWI_VLAN_RES_TABLE_14_VLAN_ID_14      0x00007FF8

#define BF_ENET_SWI_VLAN_RES_TABLE_14_VLAN_ID_14(v)   (((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_14_VLAN_ID_14)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_14_VLAN_ID_14(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_14, VLAN_ID_14, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_14, field PORT_2 */

#define BP_ENET_SWI_VLAN_RES_TABLE_14_PORT_2      2
#define BM_ENET_SWI_VLAN_RES_TABLE_14_PORT_2      0x00000004

#define BF_ENET_SWI_VLAN_RES_TABLE_14_PORT_2(v)   (((v) << 2) & BM_ENET_SWI_VLAN_RES_TABLE_14_PORT_2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_14_PORT_2(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_14, PORT_2, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_14, field PORT_1 */

#define BP_ENET_SWI_VLAN_RES_TABLE_14_PORT_1      1
#define BM_ENET_SWI_VLAN_RES_TABLE_14_PORT_1      0x00000002

#define BF_ENET_SWI_VLAN_RES_TABLE_14_PORT_1(v)   (((v) << 1) & BM_ENET_SWI_VLAN_RES_TABLE_14_PORT_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_14_PORT_1(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_14, PORT_1, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_14, field PORT_0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_14_PORT_0      0
#define BM_ENET_SWI_VLAN_RES_TABLE_14_PORT_0      0x00000001

#define BF_ENET_SWI_VLAN_RES_TABLE_14_PORT_0(v)   (((v) << 0) & BM_ENET_SWI_VLAN_RES_TABLE_14_PORT_0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_14_PORT_0(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_14, PORT_0, v)
#endif



/*
 * HW_ENET_SWI_VLAN_RES_TABLE_15 - ENET SWI VLAN domain resolution entry 15.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PORT_0      :  1;
        unsigned PORT_1      :  1;
        unsigned PORT_2      :  1;
        unsigned VLAN_ID_15  : 12;
        unsigned RSRVD0      : 17;
    } B;
} hw_enet_swi_vlan_res_table_15_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_VLAN_RES_TABLE_15 register
 */
#define HW_ENET_SWI_VLAN_RES_TABLE_15_ADDR         (REGS_ENET_BASE + 0x82bc)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_VLAN_RES_TABLE_15           (*(volatile hw_enet_swi_vlan_res_table_15_t *) HW_ENET_SWI_VLAN_RES_TABLE_15_ADDR)
#define HW_ENET_SWI_VLAN_RES_TABLE_15_RD()      (HW_ENET_SWI_VLAN_RES_TABLE_15.U)
#define HW_ENET_SWI_VLAN_RES_TABLE_15_WR(v)     (HW_ENET_SWI_VLAN_RES_TABLE_15.U = (v))
#define HW_ENET_SWI_VLAN_RES_TABLE_15_SET(v)    (HW_ENET_SWI_VLAN_RES_TABLE_15_WR(HW_ENET_SWI_VLAN_RES_TABLE_15_RD() |  (v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_15_CLR(v)    (HW_ENET_SWI_VLAN_RES_TABLE_15_WR(HW_ENET_SWI_VLAN_RES_TABLE_15_RD() & ~(v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_15_TOG(v)    (HW_ENET_SWI_VLAN_RES_TABLE_15_WR(HW_ENET_SWI_VLAN_RES_TABLE_15_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_VLAN_RES_TABLE_15 bitfields
 */
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_15, field RSRVD0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_15_RSRVD0      15
#define BM_ENET_SWI_VLAN_RES_TABLE_15_RSRVD0      0xFFFF8000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_VLAN_RES_TABLE_15_RSRVD0(v)   ((((reg32_t) v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_15_RSRVD0)
#else
#define BF_ENET_SWI_VLAN_RES_TABLE_15_RSRVD0(v)   (((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_15_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_15, field VLAN_ID_15 */

#define BP_ENET_SWI_VLAN_RES_TABLE_15_VLAN_ID_15      3
#define BM_ENET_SWI_VLAN_RES_TABLE_15_VLAN_ID_15      0x00007FF8

#define BF_ENET_SWI_VLAN_RES_TABLE_15_VLAN_ID_15(v)   (((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_15_VLAN_ID_15)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_15_VLAN_ID_15(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_15, VLAN_ID_15, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_15, field PORT_2 */

#define BP_ENET_SWI_VLAN_RES_TABLE_15_PORT_2      2
#define BM_ENET_SWI_VLAN_RES_TABLE_15_PORT_2      0x00000004

#define BF_ENET_SWI_VLAN_RES_TABLE_15_PORT_2(v)   (((v) << 2) & BM_ENET_SWI_VLAN_RES_TABLE_15_PORT_2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_15_PORT_2(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_15, PORT_2, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_15, field PORT_1 */

#define BP_ENET_SWI_VLAN_RES_TABLE_15_PORT_1      1
#define BM_ENET_SWI_VLAN_RES_TABLE_15_PORT_1      0x00000002

#define BF_ENET_SWI_VLAN_RES_TABLE_15_PORT_1(v)   (((v) << 1) & BM_ENET_SWI_VLAN_RES_TABLE_15_PORT_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_15_PORT_1(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_15, PORT_1, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_15, field PORT_0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_15_PORT_0      0
#define BM_ENET_SWI_VLAN_RES_TABLE_15_PORT_0      0x00000001

#define BF_ENET_SWI_VLAN_RES_TABLE_15_PORT_0(v)   (((v) << 0) & BM_ENET_SWI_VLAN_RES_TABLE_15_PORT_0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_15_PORT_0(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_15, PORT_0, v)
#endif



/*
 * HW_ENET_SWI_VLAN_RES_TABLE_16 - ENET SWI VLAN domain resolution entry 16.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PORT_0      :  1;
        unsigned PORT_1      :  1;
        unsigned PORT_2      :  1;
        unsigned VLAN_ID_16  : 12;
        unsigned RSRVD0      : 17;
    } B;
} hw_enet_swi_vlan_res_table_16_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_VLAN_RES_TABLE_16 register
 */
#define HW_ENET_SWI_VLAN_RES_TABLE_16_ADDR         (REGS_ENET_BASE + 0x82c0)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_VLAN_RES_TABLE_16           (*(volatile hw_enet_swi_vlan_res_table_16_t *) HW_ENET_SWI_VLAN_RES_TABLE_16_ADDR)
#define HW_ENET_SWI_VLAN_RES_TABLE_16_RD()      (HW_ENET_SWI_VLAN_RES_TABLE_16.U)
#define HW_ENET_SWI_VLAN_RES_TABLE_16_WR(v)     (HW_ENET_SWI_VLAN_RES_TABLE_16.U = (v))
#define HW_ENET_SWI_VLAN_RES_TABLE_16_SET(v)    (HW_ENET_SWI_VLAN_RES_TABLE_16_WR(HW_ENET_SWI_VLAN_RES_TABLE_16_RD() |  (v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_16_CLR(v)    (HW_ENET_SWI_VLAN_RES_TABLE_16_WR(HW_ENET_SWI_VLAN_RES_TABLE_16_RD() & ~(v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_16_TOG(v)    (HW_ENET_SWI_VLAN_RES_TABLE_16_WR(HW_ENET_SWI_VLAN_RES_TABLE_16_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_VLAN_RES_TABLE_16 bitfields
 */
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_16, field RSRVD0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_16_RSRVD0      15
#define BM_ENET_SWI_VLAN_RES_TABLE_16_RSRVD0      0xFFFF8000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_VLAN_RES_TABLE_16_RSRVD0(v)   ((((reg32_t) v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_16_RSRVD0)
#else
#define BF_ENET_SWI_VLAN_RES_TABLE_16_RSRVD0(v)   (((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_16_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_16, field VLAN_ID_16 */

#define BP_ENET_SWI_VLAN_RES_TABLE_16_VLAN_ID_16      3
#define BM_ENET_SWI_VLAN_RES_TABLE_16_VLAN_ID_16      0x00007FF8

#define BF_ENET_SWI_VLAN_RES_TABLE_16_VLAN_ID_16(v)   (((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_16_VLAN_ID_16)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_16_VLAN_ID_16(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_16, VLAN_ID_16, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_16, field PORT_2 */

#define BP_ENET_SWI_VLAN_RES_TABLE_16_PORT_2      2
#define BM_ENET_SWI_VLAN_RES_TABLE_16_PORT_2      0x00000004

#define BF_ENET_SWI_VLAN_RES_TABLE_16_PORT_2(v)   (((v) << 2) & BM_ENET_SWI_VLAN_RES_TABLE_16_PORT_2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_16_PORT_2(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_16, PORT_2, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_16, field PORT_1 */

#define BP_ENET_SWI_VLAN_RES_TABLE_16_PORT_1      1
#define BM_ENET_SWI_VLAN_RES_TABLE_16_PORT_1      0x00000002

#define BF_ENET_SWI_VLAN_RES_TABLE_16_PORT_1(v)   (((v) << 1) & BM_ENET_SWI_VLAN_RES_TABLE_16_PORT_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_16_PORT_1(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_16, PORT_1, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_16, field PORT_0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_16_PORT_0      0
#define BM_ENET_SWI_VLAN_RES_TABLE_16_PORT_0      0x00000001

#define BF_ENET_SWI_VLAN_RES_TABLE_16_PORT_0(v)   (((v) << 0) & BM_ENET_SWI_VLAN_RES_TABLE_16_PORT_0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_16_PORT_0(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_16, PORT_0, v)
#endif



/*
 * HW_ENET_SWI_VLAN_RES_TABLE_17 - ENET SWI VLAN domain resolution entry 17.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PORT_0      :  1;
        unsigned PORT_1      :  1;
        unsigned PORT_2      :  1;
        unsigned VLAN_ID_17  : 12;
        unsigned RSRVD0      : 17;
    } B;
} hw_enet_swi_vlan_res_table_17_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_VLAN_RES_TABLE_17 register
 */
#define HW_ENET_SWI_VLAN_RES_TABLE_17_ADDR         (REGS_ENET_BASE + 0x82c4)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_VLAN_RES_TABLE_17           (*(volatile hw_enet_swi_vlan_res_table_17_t *) HW_ENET_SWI_VLAN_RES_TABLE_17_ADDR)
#define HW_ENET_SWI_VLAN_RES_TABLE_17_RD()      (HW_ENET_SWI_VLAN_RES_TABLE_17.U)
#define HW_ENET_SWI_VLAN_RES_TABLE_17_WR(v)     (HW_ENET_SWI_VLAN_RES_TABLE_17.U = (v))
#define HW_ENET_SWI_VLAN_RES_TABLE_17_SET(v)    (HW_ENET_SWI_VLAN_RES_TABLE_17_WR(HW_ENET_SWI_VLAN_RES_TABLE_17_RD() |  (v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_17_CLR(v)    (HW_ENET_SWI_VLAN_RES_TABLE_17_WR(HW_ENET_SWI_VLAN_RES_TABLE_17_RD() & ~(v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_17_TOG(v)    (HW_ENET_SWI_VLAN_RES_TABLE_17_WR(HW_ENET_SWI_VLAN_RES_TABLE_17_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_VLAN_RES_TABLE_17 bitfields
 */
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_17, field RSRVD0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_17_RSRVD0      15
#define BM_ENET_SWI_VLAN_RES_TABLE_17_RSRVD0      0xFFFF8000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_VLAN_RES_TABLE_17_RSRVD0(v)   ((((reg32_t) v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_17_RSRVD0)
#else
#define BF_ENET_SWI_VLAN_RES_TABLE_17_RSRVD0(v)   (((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_17_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_17, field VLAN_ID_17 */

#define BP_ENET_SWI_VLAN_RES_TABLE_17_VLAN_ID_17      3
#define BM_ENET_SWI_VLAN_RES_TABLE_17_VLAN_ID_17      0x00007FF8

#define BF_ENET_SWI_VLAN_RES_TABLE_17_VLAN_ID_17(v)   (((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_17_VLAN_ID_17)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_17_VLAN_ID_17(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_17, VLAN_ID_17, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_17, field PORT_2 */

#define BP_ENET_SWI_VLAN_RES_TABLE_17_PORT_2      2
#define BM_ENET_SWI_VLAN_RES_TABLE_17_PORT_2      0x00000004

#define BF_ENET_SWI_VLAN_RES_TABLE_17_PORT_2(v)   (((v) << 2) & BM_ENET_SWI_VLAN_RES_TABLE_17_PORT_2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_17_PORT_2(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_17, PORT_2, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_17, field PORT_1 */

#define BP_ENET_SWI_VLAN_RES_TABLE_17_PORT_1      1
#define BM_ENET_SWI_VLAN_RES_TABLE_17_PORT_1      0x00000002

#define BF_ENET_SWI_VLAN_RES_TABLE_17_PORT_1(v)   (((v) << 1) & BM_ENET_SWI_VLAN_RES_TABLE_17_PORT_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_17_PORT_1(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_17, PORT_1, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_17, field PORT_0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_17_PORT_0      0
#define BM_ENET_SWI_VLAN_RES_TABLE_17_PORT_0      0x00000001

#define BF_ENET_SWI_VLAN_RES_TABLE_17_PORT_0(v)   (((v) << 0) & BM_ENET_SWI_VLAN_RES_TABLE_17_PORT_0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_17_PORT_0(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_17, PORT_0, v)
#endif



/*
 * HW_ENET_SWI_VLAN_RES_TABLE_18 - ENET SWI VLAN domain resolution entry 18.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PORT_0      :  1;
        unsigned PORT_1      :  1;
        unsigned PORT_2      :  1;
        unsigned VLAN_ID_18  : 12;
        unsigned RSRVD0      : 17;
    } B;
} hw_enet_swi_vlan_res_table_18_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_VLAN_RES_TABLE_18 register
 */
#define HW_ENET_SWI_VLAN_RES_TABLE_18_ADDR         (REGS_ENET_BASE + 0x82c8)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_VLAN_RES_TABLE_18           (*(volatile hw_enet_swi_vlan_res_table_18_t *) HW_ENET_SWI_VLAN_RES_TABLE_18_ADDR)
#define HW_ENET_SWI_VLAN_RES_TABLE_18_RD()      (HW_ENET_SWI_VLAN_RES_TABLE_18.U)
#define HW_ENET_SWI_VLAN_RES_TABLE_18_WR(v)     (HW_ENET_SWI_VLAN_RES_TABLE_18.U = (v))
#define HW_ENET_SWI_VLAN_RES_TABLE_18_SET(v)    (HW_ENET_SWI_VLAN_RES_TABLE_18_WR(HW_ENET_SWI_VLAN_RES_TABLE_18_RD() |  (v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_18_CLR(v)    (HW_ENET_SWI_VLAN_RES_TABLE_18_WR(HW_ENET_SWI_VLAN_RES_TABLE_18_RD() & ~(v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_18_TOG(v)    (HW_ENET_SWI_VLAN_RES_TABLE_18_WR(HW_ENET_SWI_VLAN_RES_TABLE_18_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_VLAN_RES_TABLE_18 bitfields
 */
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_18, field RSRVD0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_18_RSRVD0      15
#define BM_ENET_SWI_VLAN_RES_TABLE_18_RSRVD0      0xFFFF8000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_VLAN_RES_TABLE_18_RSRVD0(v)   ((((reg32_t) v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_18_RSRVD0)
#else
#define BF_ENET_SWI_VLAN_RES_TABLE_18_RSRVD0(v)   (((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_18_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_18, field VLAN_ID_18 */

#define BP_ENET_SWI_VLAN_RES_TABLE_18_VLAN_ID_18      3
#define BM_ENET_SWI_VLAN_RES_TABLE_18_VLAN_ID_18      0x00007FF8

#define BF_ENET_SWI_VLAN_RES_TABLE_18_VLAN_ID_18(v)   (((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_18_VLAN_ID_18)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_18_VLAN_ID_18(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_18, VLAN_ID_18, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_18, field PORT_2 */

#define BP_ENET_SWI_VLAN_RES_TABLE_18_PORT_2      2
#define BM_ENET_SWI_VLAN_RES_TABLE_18_PORT_2      0x00000004

#define BF_ENET_SWI_VLAN_RES_TABLE_18_PORT_2(v)   (((v) << 2) & BM_ENET_SWI_VLAN_RES_TABLE_18_PORT_2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_18_PORT_2(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_18, PORT_2, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_18, field PORT_1 */

#define BP_ENET_SWI_VLAN_RES_TABLE_18_PORT_1      1
#define BM_ENET_SWI_VLAN_RES_TABLE_18_PORT_1      0x00000002

#define BF_ENET_SWI_VLAN_RES_TABLE_18_PORT_1(v)   (((v) << 1) & BM_ENET_SWI_VLAN_RES_TABLE_18_PORT_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_18_PORT_1(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_18, PORT_1, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_18, field PORT_0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_18_PORT_0      0
#define BM_ENET_SWI_VLAN_RES_TABLE_18_PORT_0      0x00000001

#define BF_ENET_SWI_VLAN_RES_TABLE_18_PORT_0(v)   (((v) << 0) & BM_ENET_SWI_VLAN_RES_TABLE_18_PORT_0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_18_PORT_0(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_18, PORT_0, v)
#endif



/*
 * HW_ENET_SWI_VLAN_RES_TABLE_19 - ENET SWI VLAN domain resolution entry 19.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PORT_0      :  1;
        unsigned PORT_1      :  1;
        unsigned PORT_2      :  1;
        unsigned VLAN_ID_19  : 12;
        unsigned RSRVD0      : 17;
    } B;
} hw_enet_swi_vlan_res_table_19_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_VLAN_RES_TABLE_19 register
 */
#define HW_ENET_SWI_VLAN_RES_TABLE_19_ADDR         (REGS_ENET_BASE + 0x82cc)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_VLAN_RES_TABLE_19           (*(volatile hw_enet_swi_vlan_res_table_19_t *) HW_ENET_SWI_VLAN_RES_TABLE_19_ADDR)
#define HW_ENET_SWI_VLAN_RES_TABLE_19_RD()      (HW_ENET_SWI_VLAN_RES_TABLE_19.U)
#define HW_ENET_SWI_VLAN_RES_TABLE_19_WR(v)     (HW_ENET_SWI_VLAN_RES_TABLE_19.U = (v))
#define HW_ENET_SWI_VLAN_RES_TABLE_19_SET(v)    (HW_ENET_SWI_VLAN_RES_TABLE_19_WR(HW_ENET_SWI_VLAN_RES_TABLE_19_RD() |  (v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_19_CLR(v)    (HW_ENET_SWI_VLAN_RES_TABLE_19_WR(HW_ENET_SWI_VLAN_RES_TABLE_19_RD() & ~(v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_19_TOG(v)    (HW_ENET_SWI_VLAN_RES_TABLE_19_WR(HW_ENET_SWI_VLAN_RES_TABLE_19_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_VLAN_RES_TABLE_19 bitfields
 */
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_19, field RSRVD0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_19_RSRVD0      15
#define BM_ENET_SWI_VLAN_RES_TABLE_19_RSRVD0      0xFFFF8000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_VLAN_RES_TABLE_19_RSRVD0(v)   ((((reg32_t) v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_19_RSRVD0)
#else
#define BF_ENET_SWI_VLAN_RES_TABLE_19_RSRVD0(v)   (((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_19_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_19, field VLAN_ID_19 */

#define BP_ENET_SWI_VLAN_RES_TABLE_19_VLAN_ID_19      3
#define BM_ENET_SWI_VLAN_RES_TABLE_19_VLAN_ID_19      0x00007FF8

#define BF_ENET_SWI_VLAN_RES_TABLE_19_VLAN_ID_19(v)   (((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_19_VLAN_ID_19)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_19_VLAN_ID_19(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_19, VLAN_ID_19, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_19, field PORT_2 */

#define BP_ENET_SWI_VLAN_RES_TABLE_19_PORT_2      2
#define BM_ENET_SWI_VLAN_RES_TABLE_19_PORT_2      0x00000004

#define BF_ENET_SWI_VLAN_RES_TABLE_19_PORT_2(v)   (((v) << 2) & BM_ENET_SWI_VLAN_RES_TABLE_19_PORT_2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_19_PORT_2(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_19, PORT_2, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_19, field PORT_1 */

#define BP_ENET_SWI_VLAN_RES_TABLE_19_PORT_1      1
#define BM_ENET_SWI_VLAN_RES_TABLE_19_PORT_1      0x00000002

#define BF_ENET_SWI_VLAN_RES_TABLE_19_PORT_1(v)   (((v) << 1) & BM_ENET_SWI_VLAN_RES_TABLE_19_PORT_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_19_PORT_1(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_19, PORT_1, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_19, field PORT_0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_19_PORT_0      0
#define BM_ENET_SWI_VLAN_RES_TABLE_19_PORT_0      0x00000001

#define BF_ENET_SWI_VLAN_RES_TABLE_19_PORT_0(v)   (((v) << 0) & BM_ENET_SWI_VLAN_RES_TABLE_19_PORT_0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_19_PORT_0(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_19, PORT_0, v)
#endif



/*
 * HW_ENET_SWI_VLAN_RES_TABLE_20 - ENET SWI VLAN domain resolution entry 20.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PORT_0      :  1;
        unsigned PORT_1      :  1;
        unsigned PORT_2      :  1;
        unsigned VLAN_ID_20  : 12;
        unsigned RSRVD0      : 17;
    } B;
} hw_enet_swi_vlan_res_table_20_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_VLAN_RES_TABLE_20 register
 */
#define HW_ENET_SWI_VLAN_RES_TABLE_20_ADDR         (REGS_ENET_BASE + 0x82d0)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_VLAN_RES_TABLE_20           (*(volatile hw_enet_swi_vlan_res_table_20_t *) HW_ENET_SWI_VLAN_RES_TABLE_20_ADDR)
#define HW_ENET_SWI_VLAN_RES_TABLE_20_RD()      (HW_ENET_SWI_VLAN_RES_TABLE_20.U)
#define HW_ENET_SWI_VLAN_RES_TABLE_20_WR(v)     (HW_ENET_SWI_VLAN_RES_TABLE_20.U = (v))
#define HW_ENET_SWI_VLAN_RES_TABLE_20_SET(v)    (HW_ENET_SWI_VLAN_RES_TABLE_20_WR(HW_ENET_SWI_VLAN_RES_TABLE_20_RD() |  (v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_20_CLR(v)    (HW_ENET_SWI_VLAN_RES_TABLE_20_WR(HW_ENET_SWI_VLAN_RES_TABLE_20_RD() & ~(v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_20_TOG(v)    (HW_ENET_SWI_VLAN_RES_TABLE_20_WR(HW_ENET_SWI_VLAN_RES_TABLE_20_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_VLAN_RES_TABLE_20 bitfields
 */
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_20, field RSRVD0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_20_RSRVD0      15
#define BM_ENET_SWI_VLAN_RES_TABLE_20_RSRVD0      0xFFFF8000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_VLAN_RES_TABLE_20_RSRVD0(v)   ((((reg32_t) v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_20_RSRVD0)
#else
#define BF_ENET_SWI_VLAN_RES_TABLE_20_RSRVD0(v)   (((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_20_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_20, field VLAN_ID_20 */

#define BP_ENET_SWI_VLAN_RES_TABLE_20_VLAN_ID_20      3
#define BM_ENET_SWI_VLAN_RES_TABLE_20_VLAN_ID_20      0x00007FF8

#define BF_ENET_SWI_VLAN_RES_TABLE_20_VLAN_ID_20(v)   (((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_20_VLAN_ID_20)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_20_VLAN_ID_20(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_20, VLAN_ID_20, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_20, field PORT_2 */

#define BP_ENET_SWI_VLAN_RES_TABLE_20_PORT_2      2
#define BM_ENET_SWI_VLAN_RES_TABLE_20_PORT_2      0x00000004

#define BF_ENET_SWI_VLAN_RES_TABLE_20_PORT_2(v)   (((v) << 2) & BM_ENET_SWI_VLAN_RES_TABLE_20_PORT_2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_20_PORT_2(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_20, PORT_2, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_20, field PORT_1 */

#define BP_ENET_SWI_VLAN_RES_TABLE_20_PORT_1      1
#define BM_ENET_SWI_VLAN_RES_TABLE_20_PORT_1      0x00000002

#define BF_ENET_SWI_VLAN_RES_TABLE_20_PORT_1(v)   (((v) << 1) & BM_ENET_SWI_VLAN_RES_TABLE_20_PORT_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_20_PORT_1(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_20, PORT_1, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_20, field PORT_0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_20_PORT_0      0
#define BM_ENET_SWI_VLAN_RES_TABLE_20_PORT_0      0x00000001

#define BF_ENET_SWI_VLAN_RES_TABLE_20_PORT_0(v)   (((v) << 0) & BM_ENET_SWI_VLAN_RES_TABLE_20_PORT_0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_20_PORT_0(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_20, PORT_0, v)
#endif



/*
 * HW_ENET_SWI_VLAN_RES_TABLE_21 - ENET SWI VLAN domain resolution entry 21.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PORT_0      :  1;
        unsigned PORT_1      :  1;
        unsigned PORT_2      :  1;
        unsigned VLAN_ID_21  : 12;
        unsigned RSRVD0      : 17;
    } B;
} hw_enet_swi_vlan_res_table_21_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_VLAN_RES_TABLE_21 register
 */
#define HW_ENET_SWI_VLAN_RES_TABLE_21_ADDR         (REGS_ENET_BASE + 0x82d4)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_VLAN_RES_TABLE_21           (*(volatile hw_enet_swi_vlan_res_table_21_t *) HW_ENET_SWI_VLAN_RES_TABLE_21_ADDR)
#define HW_ENET_SWI_VLAN_RES_TABLE_21_RD()      (HW_ENET_SWI_VLAN_RES_TABLE_21.U)
#define HW_ENET_SWI_VLAN_RES_TABLE_21_WR(v)     (HW_ENET_SWI_VLAN_RES_TABLE_21.U = (v))
#define HW_ENET_SWI_VLAN_RES_TABLE_21_SET(v)    (HW_ENET_SWI_VLAN_RES_TABLE_21_WR(HW_ENET_SWI_VLAN_RES_TABLE_21_RD() |  (v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_21_CLR(v)    (HW_ENET_SWI_VLAN_RES_TABLE_21_WR(HW_ENET_SWI_VLAN_RES_TABLE_21_RD() & ~(v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_21_TOG(v)    (HW_ENET_SWI_VLAN_RES_TABLE_21_WR(HW_ENET_SWI_VLAN_RES_TABLE_21_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_VLAN_RES_TABLE_21 bitfields
 */
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_21, field RSRVD0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_21_RSRVD0      15
#define BM_ENET_SWI_VLAN_RES_TABLE_21_RSRVD0      0xFFFF8000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_VLAN_RES_TABLE_21_RSRVD0(v)   ((((reg32_t) v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_21_RSRVD0)
#else
#define BF_ENET_SWI_VLAN_RES_TABLE_21_RSRVD0(v)   (((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_21_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_21, field VLAN_ID_21 */

#define BP_ENET_SWI_VLAN_RES_TABLE_21_VLAN_ID_21      3
#define BM_ENET_SWI_VLAN_RES_TABLE_21_VLAN_ID_21      0x00007FF8

#define BF_ENET_SWI_VLAN_RES_TABLE_21_VLAN_ID_21(v)   (((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_21_VLAN_ID_21)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_21_VLAN_ID_21(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_21, VLAN_ID_21, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_21, field PORT_2 */

#define BP_ENET_SWI_VLAN_RES_TABLE_21_PORT_2      2
#define BM_ENET_SWI_VLAN_RES_TABLE_21_PORT_2      0x00000004

#define BF_ENET_SWI_VLAN_RES_TABLE_21_PORT_2(v)   (((v) << 2) & BM_ENET_SWI_VLAN_RES_TABLE_21_PORT_2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_21_PORT_2(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_21, PORT_2, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_21, field PORT_1 */

#define BP_ENET_SWI_VLAN_RES_TABLE_21_PORT_1      1
#define BM_ENET_SWI_VLAN_RES_TABLE_21_PORT_1      0x00000002

#define BF_ENET_SWI_VLAN_RES_TABLE_21_PORT_1(v)   (((v) << 1) & BM_ENET_SWI_VLAN_RES_TABLE_21_PORT_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_21_PORT_1(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_21, PORT_1, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_21, field PORT_0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_21_PORT_0      0
#define BM_ENET_SWI_VLAN_RES_TABLE_21_PORT_0      0x00000001

#define BF_ENET_SWI_VLAN_RES_TABLE_21_PORT_0(v)   (((v) << 0) & BM_ENET_SWI_VLAN_RES_TABLE_21_PORT_0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_21_PORT_0(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_21, PORT_0, v)
#endif



/*
 * HW_ENET_SWI_VLAN_RES_TABLE_22 - ENET SWI VLAN domain resolution entry 22.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PORT_0      :  1;
        unsigned PORT_1      :  1;
        unsigned PORT_2      :  1;
        unsigned VLAN_ID_22  : 12;
        unsigned RSRVD0      : 17;
    } B;
} hw_enet_swi_vlan_res_table_22_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_VLAN_RES_TABLE_22 register
 */
#define HW_ENET_SWI_VLAN_RES_TABLE_22_ADDR         (REGS_ENET_BASE + 0x82d8)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_VLAN_RES_TABLE_22           (*(volatile hw_enet_swi_vlan_res_table_22_t *) HW_ENET_SWI_VLAN_RES_TABLE_22_ADDR)
#define HW_ENET_SWI_VLAN_RES_TABLE_22_RD()      (HW_ENET_SWI_VLAN_RES_TABLE_22.U)
#define HW_ENET_SWI_VLAN_RES_TABLE_22_WR(v)     (HW_ENET_SWI_VLAN_RES_TABLE_22.U = (v))
#define HW_ENET_SWI_VLAN_RES_TABLE_22_SET(v)    (HW_ENET_SWI_VLAN_RES_TABLE_22_WR(HW_ENET_SWI_VLAN_RES_TABLE_22_RD() |  (v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_22_CLR(v)    (HW_ENET_SWI_VLAN_RES_TABLE_22_WR(HW_ENET_SWI_VLAN_RES_TABLE_22_RD() & ~(v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_22_TOG(v)    (HW_ENET_SWI_VLAN_RES_TABLE_22_WR(HW_ENET_SWI_VLAN_RES_TABLE_22_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_VLAN_RES_TABLE_22 bitfields
 */
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_22, field RSRVD0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_22_RSRVD0      15
#define BM_ENET_SWI_VLAN_RES_TABLE_22_RSRVD0      0xFFFF8000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_VLAN_RES_TABLE_22_RSRVD0(v)   ((((reg32_t) v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_22_RSRVD0)
#else
#define BF_ENET_SWI_VLAN_RES_TABLE_22_RSRVD0(v)   (((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_22_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_22, field VLAN_ID_22 */

#define BP_ENET_SWI_VLAN_RES_TABLE_22_VLAN_ID_22      3
#define BM_ENET_SWI_VLAN_RES_TABLE_22_VLAN_ID_22      0x00007FF8

#define BF_ENET_SWI_VLAN_RES_TABLE_22_VLAN_ID_22(v)   (((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_22_VLAN_ID_22)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_22_VLAN_ID_22(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_22, VLAN_ID_22, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_22, field PORT_2 */

#define BP_ENET_SWI_VLAN_RES_TABLE_22_PORT_2      2
#define BM_ENET_SWI_VLAN_RES_TABLE_22_PORT_2      0x00000004

#define BF_ENET_SWI_VLAN_RES_TABLE_22_PORT_2(v)   (((v) << 2) & BM_ENET_SWI_VLAN_RES_TABLE_22_PORT_2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_22_PORT_2(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_22, PORT_2, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_22, field PORT_1 */

#define BP_ENET_SWI_VLAN_RES_TABLE_22_PORT_1      1
#define BM_ENET_SWI_VLAN_RES_TABLE_22_PORT_1      0x00000002

#define BF_ENET_SWI_VLAN_RES_TABLE_22_PORT_1(v)   (((v) << 1) & BM_ENET_SWI_VLAN_RES_TABLE_22_PORT_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_22_PORT_1(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_22, PORT_1, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_22, field PORT_0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_22_PORT_0      0
#define BM_ENET_SWI_VLAN_RES_TABLE_22_PORT_0      0x00000001

#define BF_ENET_SWI_VLAN_RES_TABLE_22_PORT_0(v)   (((v) << 0) & BM_ENET_SWI_VLAN_RES_TABLE_22_PORT_0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_22_PORT_0(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_22, PORT_0, v)
#endif



/*
 * HW_ENET_SWI_VLAN_RES_TABLE_23 - ENET SWI VLAN domain resolution entry 23.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PORT_0      :  1;
        unsigned PORT_1      :  1;
        unsigned PORT_2      :  1;
        unsigned VLAN_ID_23  : 12;
        unsigned RSRVD0      : 17;
    } B;
} hw_enet_swi_vlan_res_table_23_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_VLAN_RES_TABLE_23 register
 */
#define HW_ENET_SWI_VLAN_RES_TABLE_23_ADDR         (REGS_ENET_BASE + 0x82dc)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_VLAN_RES_TABLE_23           (*(volatile hw_enet_swi_vlan_res_table_23_t *) HW_ENET_SWI_VLAN_RES_TABLE_23_ADDR)
#define HW_ENET_SWI_VLAN_RES_TABLE_23_RD()      (HW_ENET_SWI_VLAN_RES_TABLE_23.U)
#define HW_ENET_SWI_VLAN_RES_TABLE_23_WR(v)     (HW_ENET_SWI_VLAN_RES_TABLE_23.U = (v))
#define HW_ENET_SWI_VLAN_RES_TABLE_23_SET(v)    (HW_ENET_SWI_VLAN_RES_TABLE_23_WR(HW_ENET_SWI_VLAN_RES_TABLE_23_RD() |  (v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_23_CLR(v)    (HW_ENET_SWI_VLAN_RES_TABLE_23_WR(HW_ENET_SWI_VLAN_RES_TABLE_23_RD() & ~(v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_23_TOG(v)    (HW_ENET_SWI_VLAN_RES_TABLE_23_WR(HW_ENET_SWI_VLAN_RES_TABLE_23_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_VLAN_RES_TABLE_23 bitfields
 */
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_23, field RSRVD0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_23_RSRVD0      15
#define BM_ENET_SWI_VLAN_RES_TABLE_23_RSRVD0      0xFFFF8000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_VLAN_RES_TABLE_23_RSRVD0(v)   ((((reg32_t) v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_23_RSRVD0)
#else
#define BF_ENET_SWI_VLAN_RES_TABLE_23_RSRVD0(v)   (((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_23_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_23, field VLAN_ID_23 */

#define BP_ENET_SWI_VLAN_RES_TABLE_23_VLAN_ID_23      3
#define BM_ENET_SWI_VLAN_RES_TABLE_23_VLAN_ID_23      0x00007FF8

#define BF_ENET_SWI_VLAN_RES_TABLE_23_VLAN_ID_23(v)   (((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_23_VLAN_ID_23)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_23_VLAN_ID_23(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_23, VLAN_ID_23, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_23, field PORT_2 */

#define BP_ENET_SWI_VLAN_RES_TABLE_23_PORT_2      2
#define BM_ENET_SWI_VLAN_RES_TABLE_23_PORT_2      0x00000004

#define BF_ENET_SWI_VLAN_RES_TABLE_23_PORT_2(v)   (((v) << 2) & BM_ENET_SWI_VLAN_RES_TABLE_23_PORT_2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_23_PORT_2(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_23, PORT_2, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_23, field PORT_1 */

#define BP_ENET_SWI_VLAN_RES_TABLE_23_PORT_1      1
#define BM_ENET_SWI_VLAN_RES_TABLE_23_PORT_1      0x00000002

#define BF_ENET_SWI_VLAN_RES_TABLE_23_PORT_1(v)   (((v) << 1) & BM_ENET_SWI_VLAN_RES_TABLE_23_PORT_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_23_PORT_1(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_23, PORT_1, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_23, field PORT_0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_23_PORT_0      0
#define BM_ENET_SWI_VLAN_RES_TABLE_23_PORT_0      0x00000001

#define BF_ENET_SWI_VLAN_RES_TABLE_23_PORT_0(v)   (((v) << 0) & BM_ENET_SWI_VLAN_RES_TABLE_23_PORT_0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_23_PORT_0(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_23, PORT_0, v)
#endif



/*
 * HW_ENET_SWI_VLAN_RES_TABLE_24 - ENET SWI VLAN domain resolution entry 24.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PORT_0      :  1;
        unsigned PORT_1      :  1;
        unsigned PORT_2      :  1;
        unsigned VLAN_ID_24  : 12;
        unsigned RSRVD0      : 17;
    } B;
} hw_enet_swi_vlan_res_table_24_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_VLAN_RES_TABLE_24 register
 */
#define HW_ENET_SWI_VLAN_RES_TABLE_24_ADDR         (REGS_ENET_BASE + 0x82e0)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_VLAN_RES_TABLE_24           (*(volatile hw_enet_swi_vlan_res_table_24_t *) HW_ENET_SWI_VLAN_RES_TABLE_24_ADDR)
#define HW_ENET_SWI_VLAN_RES_TABLE_24_RD()      (HW_ENET_SWI_VLAN_RES_TABLE_24.U)
#define HW_ENET_SWI_VLAN_RES_TABLE_24_WR(v)     (HW_ENET_SWI_VLAN_RES_TABLE_24.U = (v))
#define HW_ENET_SWI_VLAN_RES_TABLE_24_SET(v)    (HW_ENET_SWI_VLAN_RES_TABLE_24_WR(HW_ENET_SWI_VLAN_RES_TABLE_24_RD() |  (v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_24_CLR(v)    (HW_ENET_SWI_VLAN_RES_TABLE_24_WR(HW_ENET_SWI_VLAN_RES_TABLE_24_RD() & ~(v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_24_TOG(v)    (HW_ENET_SWI_VLAN_RES_TABLE_24_WR(HW_ENET_SWI_VLAN_RES_TABLE_24_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_VLAN_RES_TABLE_24 bitfields
 */
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_24, field RSRVD0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_24_RSRVD0      15
#define BM_ENET_SWI_VLAN_RES_TABLE_24_RSRVD0      0xFFFF8000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_VLAN_RES_TABLE_24_RSRVD0(v)   ((((reg32_t) v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_24_RSRVD0)
#else
#define BF_ENET_SWI_VLAN_RES_TABLE_24_RSRVD0(v)   (((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_24_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_24, field VLAN_ID_24 */

#define BP_ENET_SWI_VLAN_RES_TABLE_24_VLAN_ID_24      3
#define BM_ENET_SWI_VLAN_RES_TABLE_24_VLAN_ID_24      0x00007FF8

#define BF_ENET_SWI_VLAN_RES_TABLE_24_VLAN_ID_24(v)   (((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_24_VLAN_ID_24)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_24_VLAN_ID_24(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_24, VLAN_ID_24, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_24, field PORT_2 */

#define BP_ENET_SWI_VLAN_RES_TABLE_24_PORT_2      2
#define BM_ENET_SWI_VLAN_RES_TABLE_24_PORT_2      0x00000004

#define BF_ENET_SWI_VLAN_RES_TABLE_24_PORT_2(v)   (((v) << 2) & BM_ENET_SWI_VLAN_RES_TABLE_24_PORT_2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_24_PORT_2(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_24, PORT_2, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_24, field PORT_1 */

#define BP_ENET_SWI_VLAN_RES_TABLE_24_PORT_1      1
#define BM_ENET_SWI_VLAN_RES_TABLE_24_PORT_1      0x00000002

#define BF_ENET_SWI_VLAN_RES_TABLE_24_PORT_1(v)   (((v) << 1) & BM_ENET_SWI_VLAN_RES_TABLE_24_PORT_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_24_PORT_1(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_24, PORT_1, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_24, field PORT_0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_24_PORT_0      0
#define BM_ENET_SWI_VLAN_RES_TABLE_24_PORT_0      0x00000001

#define BF_ENET_SWI_VLAN_RES_TABLE_24_PORT_0(v)   (((v) << 0) & BM_ENET_SWI_VLAN_RES_TABLE_24_PORT_0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_24_PORT_0(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_24, PORT_0, v)
#endif



/*
 * HW_ENET_SWI_VLAN_RES_TABLE_25 - ENET SWI VLAN domain resolution entry 25.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PORT_0      :  1;
        unsigned PORT_1      :  1;
        unsigned PORT_2      :  1;
        unsigned VLAN_ID_25  : 12;
        unsigned RSRVD0      : 17;
    } B;
} hw_enet_swi_vlan_res_table_25_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_VLAN_RES_TABLE_25 register
 */
#define HW_ENET_SWI_VLAN_RES_TABLE_25_ADDR         (REGS_ENET_BASE + 0x82e4)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_VLAN_RES_TABLE_25           (*(volatile hw_enet_swi_vlan_res_table_25_t *) HW_ENET_SWI_VLAN_RES_TABLE_25_ADDR)
#define HW_ENET_SWI_VLAN_RES_TABLE_25_RD()      (HW_ENET_SWI_VLAN_RES_TABLE_25.U)
#define HW_ENET_SWI_VLAN_RES_TABLE_25_WR(v)     (HW_ENET_SWI_VLAN_RES_TABLE_25.U = (v))
#define HW_ENET_SWI_VLAN_RES_TABLE_25_SET(v)    (HW_ENET_SWI_VLAN_RES_TABLE_25_WR(HW_ENET_SWI_VLAN_RES_TABLE_25_RD() |  (v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_25_CLR(v)    (HW_ENET_SWI_VLAN_RES_TABLE_25_WR(HW_ENET_SWI_VLAN_RES_TABLE_25_RD() & ~(v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_25_TOG(v)    (HW_ENET_SWI_VLAN_RES_TABLE_25_WR(HW_ENET_SWI_VLAN_RES_TABLE_25_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_VLAN_RES_TABLE_25 bitfields
 */
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_25, field RSRVD0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_25_RSRVD0      15
#define BM_ENET_SWI_VLAN_RES_TABLE_25_RSRVD0      0xFFFF8000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_VLAN_RES_TABLE_25_RSRVD0(v)   ((((reg32_t) v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_25_RSRVD0)
#else
#define BF_ENET_SWI_VLAN_RES_TABLE_25_RSRVD0(v)   (((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_25_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_25, field VLAN_ID_25 */

#define BP_ENET_SWI_VLAN_RES_TABLE_25_VLAN_ID_25      3
#define BM_ENET_SWI_VLAN_RES_TABLE_25_VLAN_ID_25      0x00007FF8

#define BF_ENET_SWI_VLAN_RES_TABLE_25_VLAN_ID_25(v)   (((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_25_VLAN_ID_25)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_25_VLAN_ID_25(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_25, VLAN_ID_25, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_25, field PORT_2 */

#define BP_ENET_SWI_VLAN_RES_TABLE_25_PORT_2      2
#define BM_ENET_SWI_VLAN_RES_TABLE_25_PORT_2      0x00000004

#define BF_ENET_SWI_VLAN_RES_TABLE_25_PORT_2(v)   (((v) << 2) & BM_ENET_SWI_VLAN_RES_TABLE_25_PORT_2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_25_PORT_2(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_25, PORT_2, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_25, field PORT_1 */

#define BP_ENET_SWI_VLAN_RES_TABLE_25_PORT_1      1
#define BM_ENET_SWI_VLAN_RES_TABLE_25_PORT_1      0x00000002

#define BF_ENET_SWI_VLAN_RES_TABLE_25_PORT_1(v)   (((v) << 1) & BM_ENET_SWI_VLAN_RES_TABLE_25_PORT_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_25_PORT_1(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_25, PORT_1, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_25, field PORT_0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_25_PORT_0      0
#define BM_ENET_SWI_VLAN_RES_TABLE_25_PORT_0      0x00000001

#define BF_ENET_SWI_VLAN_RES_TABLE_25_PORT_0(v)   (((v) << 0) & BM_ENET_SWI_VLAN_RES_TABLE_25_PORT_0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_25_PORT_0(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_25, PORT_0, v)
#endif



/*
 * HW_ENET_SWI_VLAN_RES_TABLE_26 - ENET SWI VLAN domain resolution entry 26.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PORT_0      :  1;
        unsigned PORT_1      :  1;
        unsigned PORT_2      :  1;
        unsigned VLAN_ID_26  : 12;
        unsigned RSRVD0      : 17;
    } B;
} hw_enet_swi_vlan_res_table_26_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_VLAN_RES_TABLE_26 register
 */
#define HW_ENET_SWI_VLAN_RES_TABLE_26_ADDR         (REGS_ENET_BASE + 0x82e8)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_VLAN_RES_TABLE_26           (*(volatile hw_enet_swi_vlan_res_table_26_t *) HW_ENET_SWI_VLAN_RES_TABLE_26_ADDR)
#define HW_ENET_SWI_VLAN_RES_TABLE_26_RD()      (HW_ENET_SWI_VLAN_RES_TABLE_26.U)
#define HW_ENET_SWI_VLAN_RES_TABLE_26_WR(v)     (HW_ENET_SWI_VLAN_RES_TABLE_26.U = (v))
#define HW_ENET_SWI_VLAN_RES_TABLE_26_SET(v)    (HW_ENET_SWI_VLAN_RES_TABLE_26_WR(HW_ENET_SWI_VLAN_RES_TABLE_26_RD() |  (v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_26_CLR(v)    (HW_ENET_SWI_VLAN_RES_TABLE_26_WR(HW_ENET_SWI_VLAN_RES_TABLE_26_RD() & ~(v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_26_TOG(v)    (HW_ENET_SWI_VLAN_RES_TABLE_26_WR(HW_ENET_SWI_VLAN_RES_TABLE_26_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_VLAN_RES_TABLE_26 bitfields
 */
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_26, field RSRVD0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_26_RSRVD0      15
#define BM_ENET_SWI_VLAN_RES_TABLE_26_RSRVD0      0xFFFF8000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_VLAN_RES_TABLE_26_RSRVD0(v)   ((((reg32_t) v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_26_RSRVD0)
#else
#define BF_ENET_SWI_VLAN_RES_TABLE_26_RSRVD0(v)   (((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_26_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_26, field VLAN_ID_26 */

#define BP_ENET_SWI_VLAN_RES_TABLE_26_VLAN_ID_26      3
#define BM_ENET_SWI_VLAN_RES_TABLE_26_VLAN_ID_26      0x00007FF8

#define BF_ENET_SWI_VLAN_RES_TABLE_26_VLAN_ID_26(v)   (((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_26_VLAN_ID_26)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_26_VLAN_ID_26(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_26, VLAN_ID_26, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_26, field PORT_2 */

#define BP_ENET_SWI_VLAN_RES_TABLE_26_PORT_2      2
#define BM_ENET_SWI_VLAN_RES_TABLE_26_PORT_2      0x00000004

#define BF_ENET_SWI_VLAN_RES_TABLE_26_PORT_2(v)   (((v) << 2) & BM_ENET_SWI_VLAN_RES_TABLE_26_PORT_2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_26_PORT_2(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_26, PORT_2, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_26, field PORT_1 */

#define BP_ENET_SWI_VLAN_RES_TABLE_26_PORT_1      1
#define BM_ENET_SWI_VLAN_RES_TABLE_26_PORT_1      0x00000002

#define BF_ENET_SWI_VLAN_RES_TABLE_26_PORT_1(v)   (((v) << 1) & BM_ENET_SWI_VLAN_RES_TABLE_26_PORT_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_26_PORT_1(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_26, PORT_1, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_26, field PORT_0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_26_PORT_0      0
#define BM_ENET_SWI_VLAN_RES_TABLE_26_PORT_0      0x00000001

#define BF_ENET_SWI_VLAN_RES_TABLE_26_PORT_0(v)   (((v) << 0) & BM_ENET_SWI_VLAN_RES_TABLE_26_PORT_0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_26_PORT_0(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_26, PORT_0, v)
#endif



/*
 * HW_ENET_SWI_VLAN_RES_TABLE_27 - ENET SWI VLAN domain resolution entry 27.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PORT_0      :  1;
        unsigned PORT_1      :  1;
        unsigned PORT_2      :  1;
        unsigned VLAN_ID_27  : 12;
        unsigned RSRVD0      : 17;
    } B;
} hw_enet_swi_vlan_res_table_27_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_VLAN_RES_TABLE_27 register
 */
#define HW_ENET_SWI_VLAN_RES_TABLE_27_ADDR         (REGS_ENET_BASE + 0x82ec)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_VLAN_RES_TABLE_27           (*(volatile hw_enet_swi_vlan_res_table_27_t *) HW_ENET_SWI_VLAN_RES_TABLE_27_ADDR)
#define HW_ENET_SWI_VLAN_RES_TABLE_27_RD()      (HW_ENET_SWI_VLAN_RES_TABLE_27.U)
#define HW_ENET_SWI_VLAN_RES_TABLE_27_WR(v)     (HW_ENET_SWI_VLAN_RES_TABLE_27.U = (v))
#define HW_ENET_SWI_VLAN_RES_TABLE_27_SET(v)    (HW_ENET_SWI_VLAN_RES_TABLE_27_WR(HW_ENET_SWI_VLAN_RES_TABLE_27_RD() |  (v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_27_CLR(v)    (HW_ENET_SWI_VLAN_RES_TABLE_27_WR(HW_ENET_SWI_VLAN_RES_TABLE_27_RD() & ~(v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_27_TOG(v)    (HW_ENET_SWI_VLAN_RES_TABLE_27_WR(HW_ENET_SWI_VLAN_RES_TABLE_27_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_VLAN_RES_TABLE_27 bitfields
 */
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_27, field RSRVD0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_27_RSRVD0      15
#define BM_ENET_SWI_VLAN_RES_TABLE_27_RSRVD0      0xFFFF8000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_VLAN_RES_TABLE_27_RSRVD0(v)   ((((reg32_t) v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_27_RSRVD0)
#else
#define BF_ENET_SWI_VLAN_RES_TABLE_27_RSRVD0(v)   (((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_27_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_27, field VLAN_ID_27 */

#define BP_ENET_SWI_VLAN_RES_TABLE_27_VLAN_ID_27      3
#define BM_ENET_SWI_VLAN_RES_TABLE_27_VLAN_ID_27      0x00007FF8

#define BF_ENET_SWI_VLAN_RES_TABLE_27_VLAN_ID_27(v)   (((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_27_VLAN_ID_27)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_27_VLAN_ID_27(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_27, VLAN_ID_27, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_27, field PORT_2 */

#define BP_ENET_SWI_VLAN_RES_TABLE_27_PORT_2      2
#define BM_ENET_SWI_VLAN_RES_TABLE_27_PORT_2      0x00000004

#define BF_ENET_SWI_VLAN_RES_TABLE_27_PORT_2(v)   (((v) << 2) & BM_ENET_SWI_VLAN_RES_TABLE_27_PORT_2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_27_PORT_2(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_27, PORT_2, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_27, field PORT_1 */

#define BP_ENET_SWI_VLAN_RES_TABLE_27_PORT_1      1
#define BM_ENET_SWI_VLAN_RES_TABLE_27_PORT_1      0x00000002

#define BF_ENET_SWI_VLAN_RES_TABLE_27_PORT_1(v)   (((v) << 1) & BM_ENET_SWI_VLAN_RES_TABLE_27_PORT_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_27_PORT_1(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_27, PORT_1, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_27, field PORT_0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_27_PORT_0      0
#define BM_ENET_SWI_VLAN_RES_TABLE_27_PORT_0      0x00000001

#define BF_ENET_SWI_VLAN_RES_TABLE_27_PORT_0(v)   (((v) << 0) & BM_ENET_SWI_VLAN_RES_TABLE_27_PORT_0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_27_PORT_0(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_27, PORT_0, v)
#endif



/*
 * HW_ENET_SWI_VLAN_RES_TABLE_28 - ENET SWI VLAN domain resolution entry 28.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PORT_0      :  1;
        unsigned PORT_1      :  1;
        unsigned PORT_2      :  1;
        unsigned VLAN_ID_28  : 12;
        unsigned RSRVD0      : 17;
    } B;
} hw_enet_swi_vlan_res_table_28_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_VLAN_RES_TABLE_28 register
 */
#define HW_ENET_SWI_VLAN_RES_TABLE_28_ADDR         (REGS_ENET_BASE + 0x82f0)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_VLAN_RES_TABLE_28           (*(volatile hw_enet_swi_vlan_res_table_28_t *) HW_ENET_SWI_VLAN_RES_TABLE_28_ADDR)
#define HW_ENET_SWI_VLAN_RES_TABLE_28_RD()      (HW_ENET_SWI_VLAN_RES_TABLE_28.U)
#define HW_ENET_SWI_VLAN_RES_TABLE_28_WR(v)     (HW_ENET_SWI_VLAN_RES_TABLE_28.U = (v))
#define HW_ENET_SWI_VLAN_RES_TABLE_28_SET(v)    (HW_ENET_SWI_VLAN_RES_TABLE_28_WR(HW_ENET_SWI_VLAN_RES_TABLE_28_RD() |  (v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_28_CLR(v)    (HW_ENET_SWI_VLAN_RES_TABLE_28_WR(HW_ENET_SWI_VLAN_RES_TABLE_28_RD() & ~(v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_28_TOG(v)    (HW_ENET_SWI_VLAN_RES_TABLE_28_WR(HW_ENET_SWI_VLAN_RES_TABLE_28_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_VLAN_RES_TABLE_28 bitfields
 */
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_28, field RSRVD0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_28_RSRVD0      15
#define BM_ENET_SWI_VLAN_RES_TABLE_28_RSRVD0      0xFFFF8000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_VLAN_RES_TABLE_28_RSRVD0(v)   ((((reg32_t) v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_28_RSRVD0)
#else
#define BF_ENET_SWI_VLAN_RES_TABLE_28_RSRVD0(v)   (((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_28_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_28, field VLAN_ID_28 */

#define BP_ENET_SWI_VLAN_RES_TABLE_28_VLAN_ID_28      3
#define BM_ENET_SWI_VLAN_RES_TABLE_28_VLAN_ID_28      0x00007FF8

#define BF_ENET_SWI_VLAN_RES_TABLE_28_VLAN_ID_28(v)   (((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_28_VLAN_ID_28)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_28_VLAN_ID_28(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_28, VLAN_ID_28, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_28, field PORT_2 */

#define BP_ENET_SWI_VLAN_RES_TABLE_28_PORT_2      2
#define BM_ENET_SWI_VLAN_RES_TABLE_28_PORT_2      0x00000004

#define BF_ENET_SWI_VLAN_RES_TABLE_28_PORT_2(v)   (((v) << 2) & BM_ENET_SWI_VLAN_RES_TABLE_28_PORT_2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_28_PORT_2(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_28, PORT_2, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_28, field PORT_1 */

#define BP_ENET_SWI_VLAN_RES_TABLE_28_PORT_1      1
#define BM_ENET_SWI_VLAN_RES_TABLE_28_PORT_1      0x00000002

#define BF_ENET_SWI_VLAN_RES_TABLE_28_PORT_1(v)   (((v) << 1) & BM_ENET_SWI_VLAN_RES_TABLE_28_PORT_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_28_PORT_1(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_28, PORT_1, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_28, field PORT_0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_28_PORT_0      0
#define BM_ENET_SWI_VLAN_RES_TABLE_28_PORT_0      0x00000001

#define BF_ENET_SWI_VLAN_RES_TABLE_28_PORT_0(v)   (((v) << 0) & BM_ENET_SWI_VLAN_RES_TABLE_28_PORT_0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_28_PORT_0(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_28, PORT_0, v)
#endif



/*
 * HW_ENET_SWI_VLAN_RES_TABLE_29 - ENET SWI VLAN domain resolution entry 29.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PORT_0      :  1;
        unsigned PORT_1      :  1;
        unsigned PORT_2      :  1;
        unsigned VLAN_ID_29  : 12;
        unsigned RSRVD0      : 17;
    } B;
} hw_enet_swi_vlan_res_table_29_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_VLAN_RES_TABLE_29 register
 */
#define HW_ENET_SWI_VLAN_RES_TABLE_29_ADDR         (REGS_ENET_BASE + 0x82f4)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_VLAN_RES_TABLE_29           (*(volatile hw_enet_swi_vlan_res_table_29_t *) HW_ENET_SWI_VLAN_RES_TABLE_29_ADDR)
#define HW_ENET_SWI_VLAN_RES_TABLE_29_RD()      (HW_ENET_SWI_VLAN_RES_TABLE_29.U)
#define HW_ENET_SWI_VLAN_RES_TABLE_29_WR(v)     (HW_ENET_SWI_VLAN_RES_TABLE_29.U = (v))
#define HW_ENET_SWI_VLAN_RES_TABLE_29_SET(v)    (HW_ENET_SWI_VLAN_RES_TABLE_29_WR(HW_ENET_SWI_VLAN_RES_TABLE_29_RD() |  (v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_29_CLR(v)    (HW_ENET_SWI_VLAN_RES_TABLE_29_WR(HW_ENET_SWI_VLAN_RES_TABLE_29_RD() & ~(v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_29_TOG(v)    (HW_ENET_SWI_VLAN_RES_TABLE_29_WR(HW_ENET_SWI_VLAN_RES_TABLE_29_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_VLAN_RES_TABLE_29 bitfields
 */
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_29, field RSRVD0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_29_RSRVD0      15
#define BM_ENET_SWI_VLAN_RES_TABLE_29_RSRVD0      0xFFFF8000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_VLAN_RES_TABLE_29_RSRVD0(v)   ((((reg32_t) v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_29_RSRVD0)
#else
#define BF_ENET_SWI_VLAN_RES_TABLE_29_RSRVD0(v)   (((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_29_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_29, field VLAN_ID_29 */

#define BP_ENET_SWI_VLAN_RES_TABLE_29_VLAN_ID_29      3
#define BM_ENET_SWI_VLAN_RES_TABLE_29_VLAN_ID_29      0x00007FF8

#define BF_ENET_SWI_VLAN_RES_TABLE_29_VLAN_ID_29(v)   (((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_29_VLAN_ID_29)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_29_VLAN_ID_29(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_29, VLAN_ID_29, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_29, field PORT_2 */

#define BP_ENET_SWI_VLAN_RES_TABLE_29_PORT_2      2
#define BM_ENET_SWI_VLAN_RES_TABLE_29_PORT_2      0x00000004

#define BF_ENET_SWI_VLAN_RES_TABLE_29_PORT_2(v)   (((v) << 2) & BM_ENET_SWI_VLAN_RES_TABLE_29_PORT_2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_29_PORT_2(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_29, PORT_2, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_29, field PORT_1 */

#define BP_ENET_SWI_VLAN_RES_TABLE_29_PORT_1      1
#define BM_ENET_SWI_VLAN_RES_TABLE_29_PORT_1      0x00000002

#define BF_ENET_SWI_VLAN_RES_TABLE_29_PORT_1(v)   (((v) << 1) & BM_ENET_SWI_VLAN_RES_TABLE_29_PORT_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_29_PORT_1(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_29, PORT_1, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_29, field PORT_0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_29_PORT_0      0
#define BM_ENET_SWI_VLAN_RES_TABLE_29_PORT_0      0x00000001

#define BF_ENET_SWI_VLAN_RES_TABLE_29_PORT_0(v)   (((v) << 0) & BM_ENET_SWI_VLAN_RES_TABLE_29_PORT_0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_29_PORT_0(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_29, PORT_0, v)
#endif



/*
 * HW_ENET_SWI_VLAN_RES_TABLE_30 - ENET SWI VLAN domain resolution entry 30.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PORT_0      :  1;
        unsigned PORT_1      :  1;
        unsigned PORT_2      :  1;
        unsigned VLAN_ID_30  : 12;
        unsigned RSRVD0      : 17;
    } B;
} hw_enet_swi_vlan_res_table_30_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_VLAN_RES_TABLE_30 register
 */
#define HW_ENET_SWI_VLAN_RES_TABLE_30_ADDR         (REGS_ENET_BASE + 0x82f8)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_VLAN_RES_TABLE_30           (*(volatile hw_enet_swi_vlan_res_table_30_t *) HW_ENET_SWI_VLAN_RES_TABLE_30_ADDR)
#define HW_ENET_SWI_VLAN_RES_TABLE_30_RD()      (HW_ENET_SWI_VLAN_RES_TABLE_30.U)
#define HW_ENET_SWI_VLAN_RES_TABLE_30_WR(v)     (HW_ENET_SWI_VLAN_RES_TABLE_30.U = (v))
#define HW_ENET_SWI_VLAN_RES_TABLE_30_SET(v)    (HW_ENET_SWI_VLAN_RES_TABLE_30_WR(HW_ENET_SWI_VLAN_RES_TABLE_30_RD() |  (v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_30_CLR(v)    (HW_ENET_SWI_VLAN_RES_TABLE_30_WR(HW_ENET_SWI_VLAN_RES_TABLE_30_RD() & ~(v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_30_TOG(v)    (HW_ENET_SWI_VLAN_RES_TABLE_30_WR(HW_ENET_SWI_VLAN_RES_TABLE_30_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_VLAN_RES_TABLE_30 bitfields
 */
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_30, field RSRVD0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_30_RSRVD0      15
#define BM_ENET_SWI_VLAN_RES_TABLE_30_RSRVD0      0xFFFF8000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_VLAN_RES_TABLE_30_RSRVD0(v)   ((((reg32_t) v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_30_RSRVD0)
#else
#define BF_ENET_SWI_VLAN_RES_TABLE_30_RSRVD0(v)   (((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_30_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_30, field VLAN_ID_30 */

#define BP_ENET_SWI_VLAN_RES_TABLE_30_VLAN_ID_30      3
#define BM_ENET_SWI_VLAN_RES_TABLE_30_VLAN_ID_30      0x00007FF8

#define BF_ENET_SWI_VLAN_RES_TABLE_30_VLAN_ID_30(v)   (((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_30_VLAN_ID_30)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_30_VLAN_ID_30(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_30, VLAN_ID_30, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_30, field PORT_2 */

#define BP_ENET_SWI_VLAN_RES_TABLE_30_PORT_2      2
#define BM_ENET_SWI_VLAN_RES_TABLE_30_PORT_2      0x00000004

#define BF_ENET_SWI_VLAN_RES_TABLE_30_PORT_2(v)   (((v) << 2) & BM_ENET_SWI_VLAN_RES_TABLE_30_PORT_2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_30_PORT_2(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_30, PORT_2, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_30, field PORT_1 */

#define BP_ENET_SWI_VLAN_RES_TABLE_30_PORT_1      1
#define BM_ENET_SWI_VLAN_RES_TABLE_30_PORT_1      0x00000002

#define BF_ENET_SWI_VLAN_RES_TABLE_30_PORT_1(v)   (((v) << 1) & BM_ENET_SWI_VLAN_RES_TABLE_30_PORT_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_30_PORT_1(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_30, PORT_1, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_30, field PORT_0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_30_PORT_0      0
#define BM_ENET_SWI_VLAN_RES_TABLE_30_PORT_0      0x00000001

#define BF_ENET_SWI_VLAN_RES_TABLE_30_PORT_0(v)   (((v) << 0) & BM_ENET_SWI_VLAN_RES_TABLE_30_PORT_0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_30_PORT_0(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_30, PORT_0, v)
#endif



/*
 * HW_ENET_SWI_VLAN_RES_TABLE_31 - ENET SWI VLAN domain resolution entry 31.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PORT_0      :  1;
        unsigned PORT_1      :  1;
        unsigned PORT_2      :  1;
        unsigned VLAN_ID_31  : 12;
        unsigned RSRVD0      : 17;
    } B;
} hw_enet_swi_vlan_res_table_31_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_VLAN_RES_TABLE_31 register
 */
#define HW_ENET_SWI_VLAN_RES_TABLE_31_ADDR         (REGS_ENET_BASE + 0x82fc)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_VLAN_RES_TABLE_31           (*(volatile hw_enet_swi_vlan_res_table_31_t *) HW_ENET_SWI_VLAN_RES_TABLE_31_ADDR)
#define HW_ENET_SWI_VLAN_RES_TABLE_31_RD()      (HW_ENET_SWI_VLAN_RES_TABLE_31.U)
#define HW_ENET_SWI_VLAN_RES_TABLE_31_WR(v)     (HW_ENET_SWI_VLAN_RES_TABLE_31.U = (v))
#define HW_ENET_SWI_VLAN_RES_TABLE_31_SET(v)    (HW_ENET_SWI_VLAN_RES_TABLE_31_WR(HW_ENET_SWI_VLAN_RES_TABLE_31_RD() |  (v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_31_CLR(v)    (HW_ENET_SWI_VLAN_RES_TABLE_31_WR(HW_ENET_SWI_VLAN_RES_TABLE_31_RD() & ~(v)))
#define HW_ENET_SWI_VLAN_RES_TABLE_31_TOG(v)    (HW_ENET_SWI_VLAN_RES_TABLE_31_WR(HW_ENET_SWI_VLAN_RES_TABLE_31_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_VLAN_RES_TABLE_31 bitfields
 */
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_31, field RSRVD0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_31_RSRVD0      15
#define BM_ENET_SWI_VLAN_RES_TABLE_31_RSRVD0      0xFFFF8000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_VLAN_RES_TABLE_31_RSRVD0(v)   ((((reg32_t) v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_31_RSRVD0)
#else
#define BF_ENET_SWI_VLAN_RES_TABLE_31_RSRVD0(v)   (((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_31_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_31, field VLAN_ID_31 */

#define BP_ENET_SWI_VLAN_RES_TABLE_31_VLAN_ID_31      3
#define BM_ENET_SWI_VLAN_RES_TABLE_31_VLAN_ID_31      0x00007FF8

#define BF_ENET_SWI_VLAN_RES_TABLE_31_VLAN_ID_31(v)   (((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_31_VLAN_ID_31)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_31_VLAN_ID_31(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_31, VLAN_ID_31, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_31, field PORT_2 */

#define BP_ENET_SWI_VLAN_RES_TABLE_31_PORT_2      2
#define BM_ENET_SWI_VLAN_RES_TABLE_31_PORT_2      0x00000004

#define BF_ENET_SWI_VLAN_RES_TABLE_31_PORT_2(v)   (((v) << 2) & BM_ENET_SWI_VLAN_RES_TABLE_31_PORT_2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_31_PORT_2(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_31, PORT_2, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_31, field PORT_1 */

#define BP_ENET_SWI_VLAN_RES_TABLE_31_PORT_1      1
#define BM_ENET_SWI_VLAN_RES_TABLE_31_PORT_1      0x00000002

#define BF_ENET_SWI_VLAN_RES_TABLE_31_PORT_1(v)   (((v) << 1) & BM_ENET_SWI_VLAN_RES_TABLE_31_PORT_1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_31_PORT_1(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_31, PORT_1, v)
#endif

/* --- Register HW_ENET_SWI_VLAN_RES_TABLE_31, field PORT_0 */

#define BP_ENET_SWI_VLAN_RES_TABLE_31_PORT_0      0
#define BM_ENET_SWI_VLAN_RES_TABLE_31_PORT_0      0x00000001

#define BF_ENET_SWI_VLAN_RES_TABLE_31_PORT_0(v)   (((v) << 0) & BM_ENET_SWI_VLAN_RES_TABLE_31_PORT_0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_VLAN_RES_TABLE_31_PORT_0(v)   BF_CS1(ENET_SWI_VLAN_RES_TABLE_31, PORT_0, v)
#endif



/*
 * HW_ENET_SWI_TOTAL_DISC - ENET SWI Total number of incoming frames processed
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TOTAL_DISC  : 32;
    } B;
} hw_enet_swi_total_disc_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_TOTAL_DISC register
 */
#define HW_ENET_SWI_TOTAL_DISC_ADDR         (REGS_ENET_BASE + 0x8300)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_TOTAL_DISC           (*(volatile hw_enet_swi_total_disc_t *) HW_ENET_SWI_TOTAL_DISC_ADDR)
#define HW_ENET_SWI_TOTAL_DISC_RD()      (HW_ENET_SWI_TOTAL_DISC.U)
#endif


/*
 * constants & macros for individual HW_ENET_SWI_TOTAL_DISC bitfields
 */
/* --- Register HW_ENET_SWI_TOTAL_DISC, field TOTAL_DISC */

#define BP_ENET_SWI_TOTAL_DISC_TOTAL_DISC      0
#define BM_ENET_SWI_TOTAL_DISC_TOTAL_DISC      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_TOTAL_DISC_TOTAL_DISC(v)   ((reg32_t) v)
#else
#define BF_ENET_SWI_TOTAL_DISC_TOTAL_DISC(v)   (v)
#endif


/*
 * HW_ENET_SWI_TOTAL_BYT_DISC - ENET SWI Sum of bytes of frames counted in TOTAL_DISC
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TOTAL_BYT_DISC  : 32;
    } B;
} hw_enet_swi_total_byt_disc_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_TOTAL_BYT_DISC register
 */
#define HW_ENET_SWI_TOTAL_BYT_DISC_ADDR         (REGS_ENET_BASE + 0x8304)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_TOTAL_BYT_DISC           (*(volatile hw_enet_swi_total_byt_disc_t *) HW_ENET_SWI_TOTAL_BYT_DISC_ADDR)
#define HW_ENET_SWI_TOTAL_BYT_DISC_RD()      (HW_ENET_SWI_TOTAL_BYT_DISC.U)
#endif


/*
 * constants & macros for individual HW_ENET_SWI_TOTAL_BYT_DISC bitfields
 */
/* --- Register HW_ENET_SWI_TOTAL_BYT_DISC, field TOTAL_BYT_DISC */

#define BP_ENET_SWI_TOTAL_BYT_DISC_TOTAL_BYT_DISC      0
#define BM_ENET_SWI_TOTAL_BYT_DISC_TOTAL_BYT_DISC      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_TOTAL_BYT_DISC_TOTAL_BYT_DISC(v)   ((reg32_t) v)
#else
#define BF_ENET_SWI_TOTAL_BYT_DISC_TOTAL_BYT_DISC(v)   (v)
#endif


/*
 * HW_ENET_SWI_TOTAL_FRM - ENET SWI Total number of incoming frames processed
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TOTAL_FRM  : 32;
    } B;
} hw_enet_swi_total_frm_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_TOTAL_FRM register
 */
#define HW_ENET_SWI_TOTAL_FRM_ADDR         (REGS_ENET_BASE + 0x8308)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_TOTAL_FRM           (*(volatile hw_enet_swi_total_frm_t *) HW_ENET_SWI_TOTAL_FRM_ADDR)
#define HW_ENET_SWI_TOTAL_FRM_RD()      (HW_ENET_SWI_TOTAL_FRM.U)
#endif


/*
 * constants & macros for individual HW_ENET_SWI_TOTAL_FRM bitfields
 */
/* --- Register HW_ENET_SWI_TOTAL_FRM, field TOTAL_FRM */

#define BP_ENET_SWI_TOTAL_FRM_TOTAL_FRM      0
#define BM_ENET_SWI_TOTAL_FRM_TOTAL_FRM      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_TOTAL_FRM_TOTAL_FRM(v)   ((reg32_t) v)
#else
#define BF_ENET_SWI_TOTAL_FRM_TOTAL_FRM(v)   (v)
#endif


/*
 * HW_ENET_SWI_TOTAL_BYT_FRM - ENET SWI Sum of bytes of frames counted in TOTAL_FRM
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TOTAL_BYT_FRM  : 32;
    } B;
} hw_enet_swi_total_byt_frm_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_TOTAL_BYT_FRM register
 */
#define HW_ENET_SWI_TOTAL_BYT_FRM_ADDR         (REGS_ENET_BASE + 0x830c)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_TOTAL_BYT_FRM           (*(volatile hw_enet_swi_total_byt_frm_t *) HW_ENET_SWI_TOTAL_BYT_FRM_ADDR)
#define HW_ENET_SWI_TOTAL_BYT_FRM_RD()      (HW_ENET_SWI_TOTAL_BYT_FRM.U)
#endif


/*
 * constants & macros for individual HW_ENET_SWI_TOTAL_BYT_FRM bitfields
 */
/* --- Register HW_ENET_SWI_TOTAL_BYT_FRM, field TOTAL_BYT_FRM */

#define BP_ENET_SWI_TOTAL_BYT_FRM_TOTAL_BYT_FRM      0
#define BM_ENET_SWI_TOTAL_BYT_FRM_TOTAL_BYT_FRM      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_TOTAL_BYT_FRM_TOTAL_BYT_FRM(v)   ((reg32_t) v)
#else
#define BF_ENET_SWI_TOTAL_BYT_FRM_TOTAL_BYT_FRM(v)   (v)
#endif


/*
 * HW_ENET_SWI_ODISC0 - ENET SWI Port 0 Outgoing frames discarded due to output Queue congestion
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ODISC0  : 32;
    } B;
} hw_enet_swi_odisc0_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_ODISC0 register
 */
#define HW_ENET_SWI_ODISC0_ADDR         (REGS_ENET_BASE + 0x8310)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_ODISC0           (*(volatile hw_enet_swi_odisc0_t *) HW_ENET_SWI_ODISC0_ADDR)
#define HW_ENET_SWI_ODISC0_RD()      (HW_ENET_SWI_ODISC0.U)
#endif


/*
 * constants & macros for individual HW_ENET_SWI_ODISC0 bitfields
 */
/* --- Register HW_ENET_SWI_ODISC0, field ODISC0 */

#define BP_ENET_SWI_ODISC0_ODISC0      0
#define BM_ENET_SWI_ODISC0_ODISC0      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_ODISC0_ODISC0(v)   ((reg32_t) v)
#else
#define BF_ENET_SWI_ODISC0_ODISC0(v)   (v)
#endif


/*
 * HW_ENET_SWI_IDISC_VLAN0 - ENET SWI Port 0 incoming frames discarded due to mismatching or missing VLAN id
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IDISC_VLAN0  : 32;
    } B;
} hw_enet_swi_idisc_vlan0_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_IDISC_VLAN0 register
 */
#define HW_ENET_SWI_IDISC_VLAN0_ADDR         (REGS_ENET_BASE + 0x8314)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_IDISC_VLAN0           (*(volatile hw_enet_swi_idisc_vlan0_t *) HW_ENET_SWI_IDISC_VLAN0_ADDR)
#define HW_ENET_SWI_IDISC_VLAN0_RD()      (HW_ENET_SWI_IDISC_VLAN0.U)
#endif


/*
 * constants & macros for individual HW_ENET_SWI_IDISC_VLAN0 bitfields
 */
/* --- Register HW_ENET_SWI_IDISC_VLAN0, field IDISC_VLAN0 */

#define BP_ENET_SWI_IDISC_VLAN0_IDISC_VLAN0      0
#define BM_ENET_SWI_IDISC_VLAN0_IDISC_VLAN0      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_IDISC_VLAN0_IDISC_VLAN0(v)   ((reg32_t) v)
#else
#define BF_ENET_SWI_IDISC_VLAN0_IDISC_VLAN0(v)   (v)
#endif


/*
 * HW_ENET_SWI_IDISC_UNTAGGED0 - ENET SWI Port 0 incoming frames discarded due to missing vlan tag
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IDISC_UNTAGGED0  : 32;
    } B;
} hw_enet_swi_idisc_untagged0_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_IDISC_UNTAGGED0 register
 */
#define HW_ENET_SWI_IDISC_UNTAGGED0_ADDR         (REGS_ENET_BASE + 0x8318)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_IDISC_UNTAGGED0           (*(volatile hw_enet_swi_idisc_untagged0_t *) HW_ENET_SWI_IDISC_UNTAGGED0_ADDR)
#define HW_ENET_SWI_IDISC_UNTAGGED0_RD()      (HW_ENET_SWI_IDISC_UNTAGGED0.U)
#endif


/*
 * constants & macros for individual HW_ENET_SWI_IDISC_UNTAGGED0 bitfields
 */
/* --- Register HW_ENET_SWI_IDISC_UNTAGGED0, field IDISC_UNTAGGED0 */

#define BP_ENET_SWI_IDISC_UNTAGGED0_IDISC_UNTAGGED0      0
#define BM_ENET_SWI_IDISC_UNTAGGED0_IDISC_UNTAGGED0      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_IDISC_UNTAGGED0_IDISC_UNTAGGED0(v)   ((reg32_t) v)
#else
#define BF_ENET_SWI_IDISC_UNTAGGED0_IDISC_UNTAGGED0(v)   (v)
#endif


/*
 * HW_ENET_SWI_IDISC_BLOCKED0 - ENET SWI Port 0 incoming frames discarded (after learning) as port is configured in blocking mode
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IDISC_BLOCKED0  : 32;
    } B;
} hw_enet_swi_idisc_blocked0_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_IDISC_BLOCKED0 register
 */
#define HW_ENET_SWI_IDISC_BLOCKED0_ADDR         (REGS_ENET_BASE + 0x831c)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_IDISC_BLOCKED0           (*(volatile hw_enet_swi_idisc_blocked0_t *) HW_ENET_SWI_IDISC_BLOCKED0_ADDR)
#define HW_ENET_SWI_IDISC_BLOCKED0_RD()      (HW_ENET_SWI_IDISC_BLOCKED0.U)
#endif


/*
 * constants & macros for individual HW_ENET_SWI_IDISC_BLOCKED0 bitfields
 */
/* --- Register HW_ENET_SWI_IDISC_BLOCKED0, field IDISC_BLOCKED0 */

#define BP_ENET_SWI_IDISC_BLOCKED0_IDISC_BLOCKED0      0
#define BM_ENET_SWI_IDISC_BLOCKED0_IDISC_BLOCKED0      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_IDISC_BLOCKED0_IDISC_BLOCKED0(v)   ((reg32_t) v)
#else
#define BF_ENET_SWI_IDISC_BLOCKED0_IDISC_BLOCKED0(v)   (v)
#endif


/*
 * HW_ENET_SWI_ODISC1 - ENET SWI Port 1 Outgoing frames discarded due to output Queue congestion
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ODISC1  : 32;
    } B;
} hw_enet_swi_odisc1_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_ODISC1 register
 */
#define HW_ENET_SWI_ODISC1_ADDR         (REGS_ENET_BASE + 0x8320)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_ODISC1           (*(volatile hw_enet_swi_odisc1_t *) HW_ENET_SWI_ODISC1_ADDR)
#define HW_ENET_SWI_ODISC1_RD()      (HW_ENET_SWI_ODISC1.U)
#endif


/*
 * constants & macros for individual HW_ENET_SWI_ODISC1 bitfields
 */
/* --- Register HW_ENET_SWI_ODISC1, field ODISC1 */

#define BP_ENET_SWI_ODISC1_ODISC1      0
#define BM_ENET_SWI_ODISC1_ODISC1      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_ODISC1_ODISC1(v)   ((reg32_t) v)
#else
#define BF_ENET_SWI_ODISC1_ODISC1(v)   (v)
#endif


/*
 * HW_ENET_SWI_IDISC_VLAN1 - ENET SWI Port 1 incoming frames discarded due to mismatching or missing VLAN id
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IDISC_VLAN1  : 32;
    } B;
} hw_enet_swi_idisc_vlan1_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_IDISC_VLAN1 register
 */
#define HW_ENET_SWI_IDISC_VLAN1_ADDR         (REGS_ENET_BASE + 0x8324)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_IDISC_VLAN1           (*(volatile hw_enet_swi_idisc_vlan1_t *) HW_ENET_SWI_IDISC_VLAN1_ADDR)
#define HW_ENET_SWI_IDISC_VLAN1_RD()      (HW_ENET_SWI_IDISC_VLAN1.U)
#endif


/*
 * constants & macros for individual HW_ENET_SWI_IDISC_VLAN1 bitfields
 */
/* --- Register HW_ENET_SWI_IDISC_VLAN1, field IDISC_VLAN1 */

#define BP_ENET_SWI_IDISC_VLAN1_IDISC_VLAN1      0
#define BM_ENET_SWI_IDISC_VLAN1_IDISC_VLAN1      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_IDISC_VLAN1_IDISC_VLAN1(v)   ((reg32_t) v)
#else
#define BF_ENET_SWI_IDISC_VLAN1_IDISC_VLAN1(v)   (v)
#endif


/*
 * HW_ENET_SWI_IDISC_UNTAGGED1 - ENET SWI Port 1 incoming frames discarded due to missing vlan tag
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IDISC_UNTAGGED1  : 32;
    } B;
} hw_enet_swi_idisc_untagged1_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_IDISC_UNTAGGED1 register
 */
#define HW_ENET_SWI_IDISC_UNTAGGED1_ADDR         (REGS_ENET_BASE + 0x8328)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_IDISC_UNTAGGED1           (*(volatile hw_enet_swi_idisc_untagged1_t *) HW_ENET_SWI_IDISC_UNTAGGED1_ADDR)
#define HW_ENET_SWI_IDISC_UNTAGGED1_RD()      (HW_ENET_SWI_IDISC_UNTAGGED1.U)
#endif


/*
 * constants & macros for individual HW_ENET_SWI_IDISC_UNTAGGED1 bitfields
 */
/* --- Register HW_ENET_SWI_IDISC_UNTAGGED1, field IDISC_UNTAGGED1 */

#define BP_ENET_SWI_IDISC_UNTAGGED1_IDISC_UNTAGGED1      0
#define BM_ENET_SWI_IDISC_UNTAGGED1_IDISC_UNTAGGED1      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_IDISC_UNTAGGED1_IDISC_UNTAGGED1(v)   ((reg32_t) v)
#else
#define BF_ENET_SWI_IDISC_UNTAGGED1_IDISC_UNTAGGED1(v)   (v)
#endif


/*
 * HW_ENET_SWI_IDISC_BLOCKED1 - ENET SWI Port 1 incoming frames discarded (after learning) as port is configured in blocking mode
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IDISC_BLOCKED1  : 32;
    } B;
} hw_enet_swi_idisc_blocked1_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_IDISC_BLOCKED1 register
 */
#define HW_ENET_SWI_IDISC_BLOCKED1_ADDR         (REGS_ENET_BASE + 0x832c)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_IDISC_BLOCKED1           (*(volatile hw_enet_swi_idisc_blocked1_t *) HW_ENET_SWI_IDISC_BLOCKED1_ADDR)
#define HW_ENET_SWI_IDISC_BLOCKED1_RD()      (HW_ENET_SWI_IDISC_BLOCKED1.U)
#endif


/*
 * constants & macros for individual HW_ENET_SWI_IDISC_BLOCKED1 bitfields
 */
/* --- Register HW_ENET_SWI_IDISC_BLOCKED1, field IDISC_BLOCKED1 */

#define BP_ENET_SWI_IDISC_BLOCKED1_IDISC_BLOCKED1      0
#define BM_ENET_SWI_IDISC_BLOCKED1_IDISC_BLOCKED1      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_IDISC_BLOCKED1_IDISC_BLOCKED1(v)   ((reg32_t) v)
#else
#define BF_ENET_SWI_IDISC_BLOCKED1_IDISC_BLOCKED1(v)   (v)
#endif


/*
 * HW_ENET_SWI_ODISC2 - ENET SWI Port 2 Outgoing frames discarded due to output Queue congestion
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ODISC2  : 32;
    } B;
} hw_enet_swi_odisc2_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_ODISC2 register
 */
#define HW_ENET_SWI_ODISC2_ADDR         (REGS_ENET_BASE + 0x8330)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_ODISC2           (*(volatile hw_enet_swi_odisc2_t *) HW_ENET_SWI_ODISC2_ADDR)
#define HW_ENET_SWI_ODISC2_RD()      (HW_ENET_SWI_ODISC2.U)
#endif


/*
 * constants & macros for individual HW_ENET_SWI_ODISC2 bitfields
 */
/* --- Register HW_ENET_SWI_ODISC2, field ODISC2 */

#define BP_ENET_SWI_ODISC2_ODISC2      0
#define BM_ENET_SWI_ODISC2_ODISC2      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_ODISC2_ODISC2(v)   ((reg32_t) v)
#else
#define BF_ENET_SWI_ODISC2_ODISC2(v)   (v)
#endif


/*
 * HW_ENET_SWI_IDISC_VLAN2 - ENET SWI Port 2 incoming frames discarded due to mismatching or missing VLAN id
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IDISC_VLAN2  : 32;
    } B;
} hw_enet_swi_idisc_vlan2_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_IDISC_VLAN2 register
 */
#define HW_ENET_SWI_IDISC_VLAN2_ADDR         (REGS_ENET_BASE + 0x8334)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_IDISC_VLAN2           (*(volatile hw_enet_swi_idisc_vlan2_t *) HW_ENET_SWI_IDISC_VLAN2_ADDR)
#define HW_ENET_SWI_IDISC_VLAN2_RD()      (HW_ENET_SWI_IDISC_VLAN2.U)
#endif


/*
 * constants & macros for individual HW_ENET_SWI_IDISC_VLAN2 bitfields
 */
/* --- Register HW_ENET_SWI_IDISC_VLAN2, field IDISC_VLAN2 */

#define BP_ENET_SWI_IDISC_VLAN2_IDISC_VLAN2      0
#define BM_ENET_SWI_IDISC_VLAN2_IDISC_VLAN2      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_IDISC_VLAN2_IDISC_VLAN2(v)   ((reg32_t) v)
#else
#define BF_ENET_SWI_IDISC_VLAN2_IDISC_VLAN2(v)   (v)
#endif


/*
 * HW_ENET_SWI_IDISC_UNTAGGED2 - ENET SWI Port 2 incoming frames discarded due to missing vlan tag
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IDISC_UNTAGGED2  : 32;
    } B;
} hw_enet_swi_idisc_untagged2_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_IDISC_UNTAGGED2 register
 */
#define HW_ENET_SWI_IDISC_UNTAGGED2_ADDR         (REGS_ENET_BASE + 0x8338)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_IDISC_UNTAGGED2           (*(volatile hw_enet_swi_idisc_untagged2_t *) HW_ENET_SWI_IDISC_UNTAGGED2_ADDR)
#define HW_ENET_SWI_IDISC_UNTAGGED2_RD()      (HW_ENET_SWI_IDISC_UNTAGGED2.U)
#endif


/*
 * constants & macros for individual HW_ENET_SWI_IDISC_UNTAGGED2 bitfields
 */
/* --- Register HW_ENET_SWI_IDISC_UNTAGGED2, field IDISC_UNTAGGED2 */

#define BP_ENET_SWI_IDISC_UNTAGGED2_IDISC_UNTAGGED2      0
#define BM_ENET_SWI_IDISC_UNTAGGED2_IDISC_UNTAGGED2      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_IDISC_UNTAGGED2_IDISC_UNTAGGED2(v)   ((reg32_t) v)
#else
#define BF_ENET_SWI_IDISC_UNTAGGED2_IDISC_UNTAGGED2(v)   (v)
#endif


/*
 * HW_ENET_SWI_IDISC_BLOCKED2 - ENET SWI Port 2 incoming frames discarded (after learning) as port is configured in blocking mod
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IDISC_BLOCKED2  : 32;
    } B;
} hw_enet_swi_idisc_blocked2_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_IDISC_BLOCKED2 register
 */
#define HW_ENET_SWI_IDISC_BLOCKED2_ADDR         (REGS_ENET_BASE + 0x833c)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_IDISC_BLOCKED2           (*(volatile hw_enet_swi_idisc_blocked2_t *) HW_ENET_SWI_IDISC_BLOCKED2_ADDR)
#define HW_ENET_SWI_IDISC_BLOCKED2_RD()      (HW_ENET_SWI_IDISC_BLOCKED2.U)
#endif


/*
 * constants & macros for individual HW_ENET_SWI_IDISC_BLOCKED2 bitfields
 */
/* --- Register HW_ENET_SWI_IDISC_BLOCKED2, field IDISC_BLOCKED2 */

#define BP_ENET_SWI_IDISC_BLOCKED2_IDISC_BLOCKED2      0
#define BM_ENET_SWI_IDISC_BLOCKED2_IDISC_BLOCKED2      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_IDISC_BLOCKED2_IDISC_BLOCKED2(v)   ((reg32_t) v)
#else
#define BF_ENET_SWI_IDISC_BLOCKED2_IDISC_BLOCKED2(v)   (v)
#endif


/*
 * HW_ENET_SWI_EIR - ENET SWI Interrupt Event Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned EBERR   :  1;
        unsigned RXB     :  1;
        unsigned RXF     :  1;
        unsigned TXB     :  1;
        unsigned TXF     :  1;
        unsigned QM      :  1;
        unsigned OD0     :  1;
        unsigned OD1     :  1;
        unsigned OD2     :  1;
        unsigned LRN     :  1;
        unsigned RSRVD0  : 22;
    } B;
} hw_enet_swi_eir_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_EIR register
 */
#define HW_ENET_SWI_EIR_ADDR         (REGS_ENET_BASE + 0x8400)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_EIR           (*(volatile hw_enet_swi_eir_t *) HW_ENET_SWI_EIR_ADDR)
#define HW_ENET_SWI_EIR_RD()      (HW_ENET_SWI_EIR.U)
#define HW_ENET_SWI_EIR_WR(v)     (HW_ENET_SWI_EIR.U = (v))
#define HW_ENET_SWI_EIR_SET(v)    (HW_ENET_SWI_EIR_WR(HW_ENET_SWI_EIR_RD() |  (v)))
#define HW_ENET_SWI_EIR_CLR(v)    (HW_ENET_SWI_EIR_WR(HW_ENET_SWI_EIR_RD() & ~(v)))
#define HW_ENET_SWI_EIR_TOG(v)    (HW_ENET_SWI_EIR_WR(HW_ENET_SWI_EIR_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_EIR bitfields
 */
/* --- Register HW_ENET_SWI_EIR, field RSRVD0 */

#define BP_ENET_SWI_EIR_RSRVD0      10
#define BM_ENET_SWI_EIR_RSRVD0      0xFFFFFC00

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_EIR_RSRVD0(v)   ((((reg32_t) v) << 10) & BM_ENET_SWI_EIR_RSRVD0)
#else
#define BF_ENET_SWI_EIR_RSRVD0(v)   (((v) << 10) & BM_ENET_SWI_EIR_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_EIR, field LRN */

#define BP_ENET_SWI_EIR_LRN      9
#define BM_ENET_SWI_EIR_LRN      0x00000200

#define BF_ENET_SWI_EIR_LRN(v)   (((v) << 9) & BM_ENET_SWI_EIR_LRN)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_EIR_LRN(v)   BF_CS1(ENET_SWI_EIR, LRN, v)
#endif

/* --- Register HW_ENET_SWI_EIR, field OD2 */

#define BP_ENET_SWI_EIR_OD2      8
#define BM_ENET_SWI_EIR_OD2      0x00000100

#define BF_ENET_SWI_EIR_OD2(v)   (((v) << 8) & BM_ENET_SWI_EIR_OD2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_EIR_OD2(v)   BF_CS1(ENET_SWI_EIR, OD2, v)
#endif

/* --- Register HW_ENET_SWI_EIR, field OD1 */

#define BP_ENET_SWI_EIR_OD1      7
#define BM_ENET_SWI_EIR_OD1      0x00000080

#define BF_ENET_SWI_EIR_OD1(v)   (((v) << 7) & BM_ENET_SWI_EIR_OD1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_EIR_OD1(v)   BF_CS1(ENET_SWI_EIR, OD1, v)
#endif

/* --- Register HW_ENET_SWI_EIR, field OD0 */

#define BP_ENET_SWI_EIR_OD0      6
#define BM_ENET_SWI_EIR_OD0      0x00000040

#define BF_ENET_SWI_EIR_OD0(v)   (((v) << 6) & BM_ENET_SWI_EIR_OD0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_EIR_OD0(v)   BF_CS1(ENET_SWI_EIR, OD0, v)
#endif

/* --- Register HW_ENET_SWI_EIR, field QM */

#define BP_ENET_SWI_EIR_QM      5
#define BM_ENET_SWI_EIR_QM      0x00000020

#define BF_ENET_SWI_EIR_QM(v)   (((v) << 5) & BM_ENET_SWI_EIR_QM)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_EIR_QM(v)   BF_CS1(ENET_SWI_EIR, QM, v)
#endif

/* --- Register HW_ENET_SWI_EIR, field TXF */

#define BP_ENET_SWI_EIR_TXF      4
#define BM_ENET_SWI_EIR_TXF      0x00000010

#define BF_ENET_SWI_EIR_TXF(v)   (((v) << 4) & BM_ENET_SWI_EIR_TXF)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_EIR_TXF(v)   BF_CS1(ENET_SWI_EIR, TXF, v)
#endif

/* --- Register HW_ENET_SWI_EIR, field TXB */

#define BP_ENET_SWI_EIR_TXB      3
#define BM_ENET_SWI_EIR_TXB      0x00000008

#define BF_ENET_SWI_EIR_TXB(v)   (((v) << 3) & BM_ENET_SWI_EIR_TXB)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_EIR_TXB(v)   BF_CS1(ENET_SWI_EIR, TXB, v)
#endif

/* --- Register HW_ENET_SWI_EIR, field RXF */

#define BP_ENET_SWI_EIR_RXF      2
#define BM_ENET_SWI_EIR_RXF      0x00000004

#define BF_ENET_SWI_EIR_RXF(v)   (((v) << 2) & BM_ENET_SWI_EIR_RXF)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_EIR_RXF(v)   BF_CS1(ENET_SWI_EIR, RXF, v)
#endif

/* --- Register HW_ENET_SWI_EIR, field RXB */

#define BP_ENET_SWI_EIR_RXB      1
#define BM_ENET_SWI_EIR_RXB      0x00000002

#define BF_ENET_SWI_EIR_RXB(v)   (((v) << 1) & BM_ENET_SWI_EIR_RXB)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_EIR_RXB(v)   BF_CS1(ENET_SWI_EIR, RXB, v)
#endif

/* --- Register HW_ENET_SWI_EIR, field EBERR */

#define BP_ENET_SWI_EIR_EBERR      0
#define BM_ENET_SWI_EIR_EBERR      0x00000001

#define BF_ENET_SWI_EIR_EBERR(v)   (((v) << 0) & BM_ENET_SWI_EIR_EBERR)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_EIR_EBERR(v)   BF_CS1(ENET_SWI_EIR, EBERR, v)
#endif



/*
 * HW_ENET_SWI_EIMR - ENET SWI Interrupt Mask Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned EBERR   :  1;
        unsigned RXB     :  1;
        unsigned RXF     :  1;
        unsigned TXB     :  1;
        unsigned TXF     :  1;
        unsigned QM      :  1;
        unsigned OD0     :  1;
        unsigned OD1     :  1;
        unsigned OD2     :  1;
        unsigned LRN     :  1;
        unsigned RSRVD0  : 22;
    } B;
} hw_enet_swi_eimr_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_EIMR register
 */
#define HW_ENET_SWI_EIMR_ADDR         (REGS_ENET_BASE + 0x8404)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_EIMR           (*(volatile hw_enet_swi_eimr_t *) HW_ENET_SWI_EIMR_ADDR)
#define HW_ENET_SWI_EIMR_RD()      (HW_ENET_SWI_EIMR.U)
#define HW_ENET_SWI_EIMR_WR(v)     (HW_ENET_SWI_EIMR.U = (v))
#define HW_ENET_SWI_EIMR_SET(v)    (HW_ENET_SWI_EIMR_WR(HW_ENET_SWI_EIMR_RD() |  (v)))
#define HW_ENET_SWI_EIMR_CLR(v)    (HW_ENET_SWI_EIMR_WR(HW_ENET_SWI_EIMR_RD() & ~(v)))
#define HW_ENET_SWI_EIMR_TOG(v)    (HW_ENET_SWI_EIMR_WR(HW_ENET_SWI_EIMR_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_EIMR bitfields
 */
/* --- Register HW_ENET_SWI_EIMR, field RSRVD0 */

#define BP_ENET_SWI_EIMR_RSRVD0      10
#define BM_ENET_SWI_EIMR_RSRVD0      0xFFFFFC00

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_EIMR_RSRVD0(v)   ((((reg32_t) v) << 10) & BM_ENET_SWI_EIMR_RSRVD0)
#else
#define BF_ENET_SWI_EIMR_RSRVD0(v)   (((v) << 10) & BM_ENET_SWI_EIMR_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_EIMR, field LRN */

#define BP_ENET_SWI_EIMR_LRN      9
#define BM_ENET_SWI_EIMR_LRN      0x00000200

#define BF_ENET_SWI_EIMR_LRN(v)   (((v) << 9) & BM_ENET_SWI_EIMR_LRN)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_EIMR_LRN(v)   BF_CS1(ENET_SWI_EIMR, LRN, v)
#endif

/* --- Register HW_ENET_SWI_EIMR, field OD2 */

#define BP_ENET_SWI_EIMR_OD2      8
#define BM_ENET_SWI_EIMR_OD2      0x00000100

#define BF_ENET_SWI_EIMR_OD2(v)   (((v) << 8) & BM_ENET_SWI_EIMR_OD2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_EIMR_OD2(v)   BF_CS1(ENET_SWI_EIMR, OD2, v)
#endif

/* --- Register HW_ENET_SWI_EIMR, field OD1 */

#define BP_ENET_SWI_EIMR_OD1      7
#define BM_ENET_SWI_EIMR_OD1      0x00000080

#define BF_ENET_SWI_EIMR_OD1(v)   (((v) << 7) & BM_ENET_SWI_EIMR_OD1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_EIMR_OD1(v)   BF_CS1(ENET_SWI_EIMR, OD1, v)
#endif

/* --- Register HW_ENET_SWI_EIMR, field OD0 */

#define BP_ENET_SWI_EIMR_OD0      6
#define BM_ENET_SWI_EIMR_OD0      0x00000040

#define BF_ENET_SWI_EIMR_OD0(v)   (((v) << 6) & BM_ENET_SWI_EIMR_OD0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_EIMR_OD0(v)   BF_CS1(ENET_SWI_EIMR, OD0, v)
#endif

/* --- Register HW_ENET_SWI_EIMR, field QM */

#define BP_ENET_SWI_EIMR_QM      5
#define BM_ENET_SWI_EIMR_QM      0x00000020

#define BF_ENET_SWI_EIMR_QM(v)   (((v) << 5) & BM_ENET_SWI_EIMR_QM)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_EIMR_QM(v)   BF_CS1(ENET_SWI_EIMR, QM, v)
#endif

/* --- Register HW_ENET_SWI_EIMR, field TXF */

#define BP_ENET_SWI_EIMR_TXF      4
#define BM_ENET_SWI_EIMR_TXF      0x00000010

#define BF_ENET_SWI_EIMR_TXF(v)   (((v) << 4) & BM_ENET_SWI_EIMR_TXF)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_EIMR_TXF(v)   BF_CS1(ENET_SWI_EIMR, TXF, v)
#endif

/* --- Register HW_ENET_SWI_EIMR, field TXB */

#define BP_ENET_SWI_EIMR_TXB      3
#define BM_ENET_SWI_EIMR_TXB      0x00000008

#define BF_ENET_SWI_EIMR_TXB(v)   (((v) << 3) & BM_ENET_SWI_EIMR_TXB)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_EIMR_TXB(v)   BF_CS1(ENET_SWI_EIMR, TXB, v)
#endif

/* --- Register HW_ENET_SWI_EIMR, field RXF */

#define BP_ENET_SWI_EIMR_RXF      2
#define BM_ENET_SWI_EIMR_RXF      0x00000004

#define BF_ENET_SWI_EIMR_RXF(v)   (((v) << 2) & BM_ENET_SWI_EIMR_RXF)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_EIMR_RXF(v)   BF_CS1(ENET_SWI_EIMR, RXF, v)
#endif

/* --- Register HW_ENET_SWI_EIMR, field RXB */

#define BP_ENET_SWI_EIMR_RXB      1
#define BM_ENET_SWI_EIMR_RXB      0x00000002

#define BF_ENET_SWI_EIMR_RXB(v)   (((v) << 1) & BM_ENET_SWI_EIMR_RXB)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_EIMR_RXB(v)   BF_CS1(ENET_SWI_EIMR, RXB, v)
#endif

/* --- Register HW_ENET_SWI_EIMR, field EBERR */

#define BP_ENET_SWI_EIMR_EBERR      0
#define BM_ENET_SWI_EIMR_EBERR      0x00000001

#define BF_ENET_SWI_EIMR_EBERR(v)   (((v) << 0) & BM_ENET_SWI_EIMR_EBERR)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_EIMR_EBERR(v)   BF_CS1(ENET_SWI_EIMR, EBERR, v)
#endif



/*
 * HW_ENET_SWI_ERDSR - ENET SWI Pointer to Receive Descriptor Ring
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSRVD0  :  2;
        unsigned ERDSR   : 30;
    } B;
} hw_enet_swi_erdsr_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_ERDSR register
 */
#define HW_ENET_SWI_ERDSR_ADDR         (REGS_ENET_BASE + 0x8408)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_ERDSR           (*(volatile hw_enet_swi_erdsr_t *) HW_ENET_SWI_ERDSR_ADDR)
#define HW_ENET_SWI_ERDSR_RD()      (HW_ENET_SWI_ERDSR.U)
#define HW_ENET_SWI_ERDSR_WR(v)     (HW_ENET_SWI_ERDSR.U = (v))
#define HW_ENET_SWI_ERDSR_SET(v)    (HW_ENET_SWI_ERDSR_WR(HW_ENET_SWI_ERDSR_RD() |  (v)))
#define HW_ENET_SWI_ERDSR_CLR(v)    (HW_ENET_SWI_ERDSR_WR(HW_ENET_SWI_ERDSR_RD() & ~(v)))
#define HW_ENET_SWI_ERDSR_TOG(v)    (HW_ENET_SWI_ERDSR_WR(HW_ENET_SWI_ERDSR_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_ERDSR bitfields
 */
/* --- Register HW_ENET_SWI_ERDSR, field ERDSR */

#define BP_ENET_SWI_ERDSR_ERDSR      2
#define BM_ENET_SWI_ERDSR_ERDSR      0xFFFFFFFC

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_ERDSR_ERDSR(v)   ((((reg32_t) v) << 2) & BM_ENET_SWI_ERDSR_ERDSR)
#else
#define BF_ENET_SWI_ERDSR_ERDSR(v)   (((v) << 2) & BM_ENET_SWI_ERDSR_ERDSR)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_ERDSR_ERDSR(v)   BF_CS1(ENET_SWI_ERDSR, ERDSR, v)
#endif

/* --- Register HW_ENET_SWI_ERDSR, field RSRVD0 */

#define BP_ENET_SWI_ERDSR_RSRVD0      0
#define BM_ENET_SWI_ERDSR_RSRVD0      0x00000003

#define BF_ENET_SWI_ERDSR_RSRVD0(v)   (((v) << 0) & BM_ENET_SWI_ERDSR_RSRVD0)


/*
 * HW_ENET_SWI_ETDSR - ENET SWI Pointer to Transmit Descriptor Ring
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSRVD0  :  2;
        unsigned ETDSR   : 30;
    } B;
} hw_enet_swi_etdsr_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_ETDSR register
 */
#define HW_ENET_SWI_ETDSR_ADDR         (REGS_ENET_BASE + 0x840c)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_ETDSR           (*(volatile hw_enet_swi_etdsr_t *) HW_ENET_SWI_ETDSR_ADDR)
#define HW_ENET_SWI_ETDSR_RD()      (HW_ENET_SWI_ETDSR.U)
#define HW_ENET_SWI_ETDSR_WR(v)     (HW_ENET_SWI_ETDSR.U = (v))
#define HW_ENET_SWI_ETDSR_SET(v)    (HW_ENET_SWI_ETDSR_WR(HW_ENET_SWI_ETDSR_RD() |  (v)))
#define HW_ENET_SWI_ETDSR_CLR(v)    (HW_ENET_SWI_ETDSR_WR(HW_ENET_SWI_ETDSR_RD() & ~(v)))
#define HW_ENET_SWI_ETDSR_TOG(v)    (HW_ENET_SWI_ETDSR_WR(HW_ENET_SWI_ETDSR_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_ETDSR bitfields
 */
/* --- Register HW_ENET_SWI_ETDSR, field ETDSR */

#define BP_ENET_SWI_ETDSR_ETDSR      2
#define BM_ENET_SWI_ETDSR_ETDSR      0xFFFFFFFC

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_ETDSR_ETDSR(v)   ((((reg32_t) v) << 2) & BM_ENET_SWI_ETDSR_ETDSR)
#else
#define BF_ENET_SWI_ETDSR_ETDSR(v)   (((v) << 2) & BM_ENET_SWI_ETDSR_ETDSR)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_ETDSR_ETDSR(v)   BF_CS1(ENET_SWI_ETDSR, ETDSR, v)
#endif

/* --- Register HW_ENET_SWI_ETDSR, field RSRVD0 */

#define BP_ENET_SWI_ETDSR_RSRVD0      0
#define BM_ENET_SWI_ETDSR_RSRVD0      0x00000003

#define BF_ENET_SWI_ETDSR_RSRVD0(v)   (((v) << 0) & BM_ENET_SWI_ETDSR_RSRVD0)


/*
 * HW_ENET_SWI_EMRBR - ENET SWI Maximum Receive Buffer Size
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSRVD0  :  4;
        unsigned EMRBR   : 10;
        unsigned RSRVD1  : 18;
    } B;
} hw_enet_swi_emrbr_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_EMRBR register
 */
#define HW_ENET_SWI_EMRBR_ADDR         (REGS_ENET_BASE + 0x8410)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_EMRBR           (*(volatile hw_enet_swi_emrbr_t *) HW_ENET_SWI_EMRBR_ADDR)
#define HW_ENET_SWI_EMRBR_RD()      (HW_ENET_SWI_EMRBR.U)
#define HW_ENET_SWI_EMRBR_WR(v)     (HW_ENET_SWI_EMRBR.U = (v))
#define HW_ENET_SWI_EMRBR_SET(v)    (HW_ENET_SWI_EMRBR_WR(HW_ENET_SWI_EMRBR_RD() |  (v)))
#define HW_ENET_SWI_EMRBR_CLR(v)    (HW_ENET_SWI_EMRBR_WR(HW_ENET_SWI_EMRBR_RD() & ~(v)))
#define HW_ENET_SWI_EMRBR_TOG(v)    (HW_ENET_SWI_EMRBR_WR(HW_ENET_SWI_EMRBR_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_EMRBR bitfields
 */
/* --- Register HW_ENET_SWI_EMRBR, field RSRVD1 */

#define BP_ENET_SWI_EMRBR_RSRVD1      14
#define BM_ENET_SWI_EMRBR_RSRVD1      0xFFFFC000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_EMRBR_RSRVD1(v)   ((((reg32_t) v) << 14) & BM_ENET_SWI_EMRBR_RSRVD1)
#else
#define BF_ENET_SWI_EMRBR_RSRVD1(v)   (((v) << 14) & BM_ENET_SWI_EMRBR_RSRVD1)
#endif
/* --- Register HW_ENET_SWI_EMRBR, field EMRBR */

#define BP_ENET_SWI_EMRBR_EMRBR      4
#define BM_ENET_SWI_EMRBR_EMRBR      0x00003FF0

#define BF_ENET_SWI_EMRBR_EMRBR(v)   (((v) << 4) & BM_ENET_SWI_EMRBR_EMRBR)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_EMRBR_EMRBR(v)   BF_CS1(ENET_SWI_EMRBR, EMRBR, v)
#endif

/* --- Register HW_ENET_SWI_EMRBR, field RSRVD0 */

#define BP_ENET_SWI_EMRBR_RSRVD0      0
#define BM_ENET_SWI_EMRBR_RSRVD0      0x0000000F

#define BF_ENET_SWI_EMRBR_RSRVD0(v)   (((v) << 0) & BM_ENET_SWI_EMRBR_RSRVD0)


/*
 * HW_ENET_SWI_RDAR - ENET SWI Receive Descriptor Active Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RDAR  : 32;
    } B;
} hw_enet_swi_rdar_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_RDAR register
 */
#define HW_ENET_SWI_RDAR_ADDR         (REGS_ENET_BASE + 0x8414)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_RDAR           (*(volatile hw_enet_swi_rdar_t *) HW_ENET_SWI_RDAR_ADDR)
#define HW_ENET_SWI_RDAR_RD()      (HW_ENET_SWI_RDAR.U)
#define HW_ENET_SWI_RDAR_WR(v)     (HW_ENET_SWI_RDAR.U = (v))
#define HW_ENET_SWI_RDAR_SET(v)    (HW_ENET_SWI_RDAR_WR(HW_ENET_SWI_RDAR_RD() |  (v)))
#define HW_ENET_SWI_RDAR_CLR(v)    (HW_ENET_SWI_RDAR_WR(HW_ENET_SWI_RDAR_RD() & ~(v)))
#define HW_ENET_SWI_RDAR_TOG(v)    (HW_ENET_SWI_RDAR_WR(HW_ENET_SWI_RDAR_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_RDAR bitfields
 */
/* --- Register HW_ENET_SWI_RDAR, field RDAR */

#define BP_ENET_SWI_RDAR_RDAR      0
#define BM_ENET_SWI_RDAR_RDAR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_RDAR_RDAR(v)   ((reg32_t) v)
#else
#define BF_ENET_SWI_RDAR_RDAR(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_RDAR_RDAR(v)   (HW_ENET_SWI_RDAR.B.RDAR = (v))
#endif



/*
 * HW_ENET_SWI_TDAR - ENET SWI Transmit Descriptor Active Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TDAR  : 32;
    } B;
} hw_enet_swi_tdar_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_TDAR register
 */
#define HW_ENET_SWI_TDAR_ADDR         (REGS_ENET_BASE + 0x8418)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_TDAR           (*(volatile hw_enet_swi_tdar_t *) HW_ENET_SWI_TDAR_ADDR)
#define HW_ENET_SWI_TDAR_RD()      (HW_ENET_SWI_TDAR.U)
#define HW_ENET_SWI_TDAR_WR(v)     (HW_ENET_SWI_TDAR.U = (v))
#define HW_ENET_SWI_TDAR_SET(v)    (HW_ENET_SWI_TDAR_WR(HW_ENET_SWI_TDAR_RD() |  (v)))
#define HW_ENET_SWI_TDAR_CLR(v)    (HW_ENET_SWI_TDAR_WR(HW_ENET_SWI_TDAR_RD() & ~(v)))
#define HW_ENET_SWI_TDAR_TOG(v)    (HW_ENET_SWI_TDAR_WR(HW_ENET_SWI_TDAR_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_TDAR bitfields
 */
/* --- Register HW_ENET_SWI_TDAR, field TDAR */

#define BP_ENET_SWI_TDAR_TDAR      0
#define BM_ENET_SWI_TDAR_TDAR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_TDAR_TDAR(v)   ((reg32_t) v)
#else
#define BF_ENET_SWI_TDAR_TDAR(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_TDAR_TDAR(v)   (HW_ENET_SWI_TDAR.B.TDAR = (v))
#endif



/*
 * HW_ENET_SWI_LRN_REC_0 - ENET SWI Learning Records A (0) and B (1)
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned LRN_REC_0  : 32;
    } B;
} hw_enet_swi_lrn_rec_0_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_LRN_REC_0 register
 */
#define HW_ENET_SWI_LRN_REC_0_ADDR         (REGS_ENET_BASE + 0x8500)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_LRN_REC_0           (*(volatile hw_enet_swi_lrn_rec_0_t *) HW_ENET_SWI_LRN_REC_0_ADDR)
#define HW_ENET_SWI_LRN_REC_0_RD()      (HW_ENET_SWI_LRN_REC_0.U)
#endif


/*
 * constants & macros for individual HW_ENET_SWI_LRN_REC_0 bitfields
 */
/* --- Register HW_ENET_SWI_LRN_REC_0, field LRN_REC_0 */

#define BP_ENET_SWI_LRN_REC_0_LRN_REC_0      0
#define BM_ENET_SWI_LRN_REC_0_LRN_REC_0      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_LRN_REC_0_LRN_REC_0(v)   ((reg32_t) v)
#else
#define BF_ENET_SWI_LRN_REC_0_LRN_REC_0(v)   (v)
#endif


/*
 * HW_ENET_SWI_LRN_REC_1 - ENET SWI Learning Record B(1)
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned MAC_ADDR1  : 16;
        unsigned HASH       :  8;
        unsigned SW_PORT    :  2;
        unsigned RSRVD0     :  6;
    } B;
} hw_enet_swi_lrn_rec_1_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_LRN_REC_1 register
 */
#define HW_ENET_SWI_LRN_REC_1_ADDR         (REGS_ENET_BASE + 0x8504)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_LRN_REC_1           (*(volatile hw_enet_swi_lrn_rec_1_t *) HW_ENET_SWI_LRN_REC_1_ADDR)
#define HW_ENET_SWI_LRN_REC_1_RD()      (HW_ENET_SWI_LRN_REC_1.U)
#endif


/*
 * constants & macros for individual HW_ENET_SWI_LRN_REC_1 bitfields
 */
/* --- Register HW_ENET_SWI_LRN_REC_1, field RSRVD0 */

#define BP_ENET_SWI_LRN_REC_1_RSRVD0      26
#define BM_ENET_SWI_LRN_REC_1_RSRVD0      0xFC000000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_LRN_REC_1_RSRVD0(v)   ((((reg32_t) v) << 26) & BM_ENET_SWI_LRN_REC_1_RSRVD0)
#else
#define BF_ENET_SWI_LRN_REC_1_RSRVD0(v)   (((v) << 26) & BM_ENET_SWI_LRN_REC_1_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_LRN_REC_1, field SW_PORT */

#define BP_ENET_SWI_LRN_REC_1_SW_PORT      24
#define BM_ENET_SWI_LRN_REC_1_SW_PORT      0x03000000

#define BF_ENET_SWI_LRN_REC_1_SW_PORT(v)   (((v) << 24) & BM_ENET_SWI_LRN_REC_1_SW_PORT)
/* --- Register HW_ENET_SWI_LRN_REC_1, field HASH */

#define BP_ENET_SWI_LRN_REC_1_HASH      16
#define BM_ENET_SWI_LRN_REC_1_HASH      0x00FF0000

#define BF_ENET_SWI_LRN_REC_1_HASH(v)   (((v) << 16) & BM_ENET_SWI_LRN_REC_1_HASH)
/* --- Register HW_ENET_SWI_LRN_REC_1, field MAC_ADDR1 */

#define BP_ENET_SWI_LRN_REC_1_MAC_ADDR1      0
#define BM_ENET_SWI_LRN_REC_1_MAC_ADDR1      0x0000FFFF

#define BF_ENET_SWI_LRN_REC_1_MAC_ADDR1(v)   (((v) << 0) & BM_ENET_SWI_LRN_REC_1_MAC_ADDR1)


/*
 * HW_ENET_SWI_LRN_STATUS - ENET SWI Learning data available status.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned LRN_STATUS  :  1;
        unsigned RSRVD0      : 31;
    } B;
} hw_enet_swi_lrn_status_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_LRN_STATUS register
 */
#define HW_ENET_SWI_LRN_STATUS_ADDR         (REGS_ENET_BASE + 0x8508)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_LRN_STATUS           (*(volatile hw_enet_swi_lrn_status_t *) HW_ENET_SWI_LRN_STATUS_ADDR)
#define HW_ENET_SWI_LRN_STATUS_RD()      (HW_ENET_SWI_LRN_STATUS.U)
#endif


/*
 * constants & macros for individual HW_ENET_SWI_LRN_STATUS bitfields
 */
/* --- Register HW_ENET_SWI_LRN_STATUS, field RSRVD0 */

#define BP_ENET_SWI_LRN_STATUS_RSRVD0      1
#define BM_ENET_SWI_LRN_STATUS_RSRVD0      0xFFFFFFFE

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_LRN_STATUS_RSRVD0(v)   ((((reg32_t) v) << 1) & BM_ENET_SWI_LRN_STATUS_RSRVD0)
#else
#define BF_ENET_SWI_LRN_STATUS_RSRVD0(v)   (((v) << 1) & BM_ENET_SWI_LRN_STATUS_RSRVD0)
#endif
/* --- Register HW_ENET_SWI_LRN_STATUS, field LRN_STATUS */

#define BP_ENET_SWI_LRN_STATUS_LRN_STATUS      0
#define BM_ENET_SWI_LRN_STATUS_LRN_STATUS      0x00000001

#define BF_ENET_SWI_LRN_STATUS_LRN_STATUS(v)   (((v) << 0) & BM_ENET_SWI_LRN_STATUS_LRN_STATUS)


/*
 * HW_ENET_SWI_LOOKUP_MEMORY_START - ENET SWI lookup MAC address memory start
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned MEMORY_DATA  : 32;
    } B;
} hw_enet_swi_lookup_memory_start_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_LOOKUP_MEMORY_START register
 */
#define HW_ENET_SWI_LOOKUP_MEMORY_START_ADDR         (REGS_ENET_BASE + 0xc000)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_LOOKUP_MEMORY_START           (*(volatile hw_enet_swi_lookup_memory_start_t *) HW_ENET_SWI_LOOKUP_MEMORY_START_ADDR)
#define HW_ENET_SWI_LOOKUP_MEMORY_START_RD()      (HW_ENET_SWI_LOOKUP_MEMORY_START.U)
#define HW_ENET_SWI_LOOKUP_MEMORY_START_WR(v)     (HW_ENET_SWI_LOOKUP_MEMORY_START.U = (v))
#define HW_ENET_SWI_LOOKUP_MEMORY_START_SET(v)    (HW_ENET_SWI_LOOKUP_MEMORY_START_WR(HW_ENET_SWI_LOOKUP_MEMORY_START_RD() |  (v)))
#define HW_ENET_SWI_LOOKUP_MEMORY_START_CLR(v)    (HW_ENET_SWI_LOOKUP_MEMORY_START_WR(HW_ENET_SWI_LOOKUP_MEMORY_START_RD() & ~(v)))
#define HW_ENET_SWI_LOOKUP_MEMORY_START_TOG(v)    (HW_ENET_SWI_LOOKUP_MEMORY_START_WR(HW_ENET_SWI_LOOKUP_MEMORY_START_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_LOOKUP_MEMORY_START bitfields
 */
/* --- Register HW_ENET_SWI_LOOKUP_MEMORY_START, field MEMORY_DATA */

#define BP_ENET_SWI_LOOKUP_MEMORY_START_MEMORY_DATA      0
#define BM_ENET_SWI_LOOKUP_MEMORY_START_MEMORY_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_LOOKUP_MEMORY_START_MEMORY_DATA(v)   ((reg32_t) v)
#else
#define BF_ENET_SWI_LOOKUP_MEMORY_START_MEMORY_DATA(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_LOOKUP_MEMORY_START_MEMORY_DATA(v)   (HW_ENET_SWI_LOOKUP_MEMORY_START.B.MEMORY_DATA = (v))
#endif



/*
 * HW_ENET_SWI_LOOKUP_MEMORY_END - ENET SWI lookup MAC address memory end
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned MEMORY_DATA  : 32;
    } B;
} hw_enet_swi_lookup_memory_end_t;
#endif

/*
 * constants & macros for entire HW_ENET_SWI_LOOKUP_MEMORY_END register
 */
#define HW_ENET_SWI_LOOKUP_MEMORY_END_ADDR         (REGS_ENET_BASE + 0xfffc)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_SWI_LOOKUP_MEMORY_END           (*(volatile hw_enet_swi_lookup_memory_end_t *) HW_ENET_SWI_LOOKUP_MEMORY_END_ADDR)
#define HW_ENET_SWI_LOOKUP_MEMORY_END_RD()      (HW_ENET_SWI_LOOKUP_MEMORY_END.U)
#define HW_ENET_SWI_LOOKUP_MEMORY_END_WR(v)     (HW_ENET_SWI_LOOKUP_MEMORY_END.U = (v))
#define HW_ENET_SWI_LOOKUP_MEMORY_END_SET(v)    (HW_ENET_SWI_LOOKUP_MEMORY_END_WR(HW_ENET_SWI_LOOKUP_MEMORY_END_RD() |  (v)))
#define HW_ENET_SWI_LOOKUP_MEMORY_END_CLR(v)    (HW_ENET_SWI_LOOKUP_MEMORY_END_WR(HW_ENET_SWI_LOOKUP_MEMORY_END_RD() & ~(v)))
#define HW_ENET_SWI_LOOKUP_MEMORY_END_TOG(v)    (HW_ENET_SWI_LOOKUP_MEMORY_END_WR(HW_ENET_SWI_LOOKUP_MEMORY_END_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_SWI_LOOKUP_MEMORY_END bitfields
 */
/* --- Register HW_ENET_SWI_LOOKUP_MEMORY_END, field MEMORY_DATA */

#define BP_ENET_SWI_LOOKUP_MEMORY_END_MEMORY_DATA      0
#define BM_ENET_SWI_LOOKUP_MEMORY_END_MEMORY_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_SWI_LOOKUP_MEMORY_END_MEMORY_DATA(v)   ((reg32_t) v)
#else
#define BF_ENET_SWI_LOOKUP_MEMORY_END_MEMORY_DATA(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_SWI_LOOKUP_MEMORY_END_MEMORY_DATA(v)   (HW_ENET_SWI_LOOKUP_MEMORY_END.B.MEMORY_DATA = (v))
#endif


#endif /* _SWITCH_H */

////////////////////////////////////////////////////////////////////////////////
