/*
 * Copyright 2009 Freescale Semiconductor, Inc. All Rights Reserved.
 */

/*
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */
////////////////////////////////////////////////////////////////////////////////
//
// WARNING!  THIS FILE IS AUTOMATICALLY GENERATED FROM XML.
//                DO NOT MODIFY THIS FILE DIRECTLY.
//
////////////////////////////////////////////////////////////////////////////////
//
// The following naming conventions are followed in this file.
//      XX_<module>_<regname>_<field>
//
// XX specifies the define / macro class
//      HW pertains to a register
//      BM indicates a Bit Mask
//      BF indicates a Bit Field macro
//
// <module> is the hardware module name which can be any of the following...
//      USB20 (Note when there is more than one copy of a given module, the
//      module name includes a number starting from 0 for the first instance
//      of that module)
//
// <regname> is the specific register within that module
//
// <field> is the specific bitfield within that <module>_<register>
//
// We also define the following...
//      hw_<module>_<regname>_t is typedef of anonymous union
//
////////////////////////////////////////////////////////////////////////////////

#ifndef _REGSTVENC_H
#define _REGSTVENC_H  1

#include "regs.h"

#ifndef REGS_TVENC_BASE
#define REGS_TVENC_BASE (REGS_BASE + 0x00038000)
#endif

////////////////////////////////////////////////////////////////////////////////
//// HW_TVENC_CTRL - TV Encoder Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DAC_MUX_MODE               :  1;
        unsigned RSRVD2                     :  2;
        unsigned DAC_DATA_FIFO_RST          :  1;
        unsigned DAC_FIFO_NO_READ           :  1;
        unsigned DAC_FIFO_NO_WRITE          :  1;
        unsigned RSRVD1                     : 20;
        unsigned TVENC_COMPONENT_PRESENT    :  1;
        unsigned TVENC_SVIDEO_PRESENT       :  1;
        unsigned TVENC_COMPOSITE_PRESENT    :  1;
        unsigned TVENC_MACROVISION_PRESENT  :  1;
        unsigned CLKGATE                    :  1;
        unsigned SFTRST                     :  1;
    } B;
} hw_tvenc_ctrl_t;
#endif


//
// constants & macros for entire HW_TVENC_CTRL register
//

#define HW_TVENC_CTRL_ADDR      (REGS_TVENC_BASE + 0x00000000)
#define HW_TVENC_CTRL_SET_ADDR  (REGS_TVENC_BASE + 0x00000004)
#define HW_TVENC_CTRL_CLR_ADDR  (REGS_TVENC_BASE + 0x00000008)
#define HW_TVENC_CTRL_TOG_ADDR  (REGS_TVENC_BASE + 0x0000000C)

#ifndef __LANGUAGE_ASM__
#define HW_TVENC_CTRL           (*(volatile hw_tvenc_ctrl_t *) HW_TVENC_CTRL_ADDR)
#define HW_TVENC_CTRL_RD()      (HW_TVENC_CTRL.U)
#define HW_TVENC_CTRL_WR(v)     (HW_TVENC_CTRL.U = (v))
#define HW_TVENC_CTRL_SET(v)    ((*(volatile reg32_t *) HW_TVENC_CTRL_SET_ADDR) = (v))
#define HW_TVENC_CTRL_CLR(v)    ((*(volatile reg32_t *) HW_TVENC_CTRL_CLR_ADDR) = (v))
#define HW_TVENC_CTRL_TOG(v)    ((*(volatile reg32_t *) HW_TVENC_CTRL_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_TVENC_CTRL bitfields
//

//--- Register HW_TVENC_CTRL, field SFTRST

#define BP_TVENC_CTRL_SFTRST      31
#define BM_TVENC_CTRL_SFTRST      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_TVENC_CTRL_SFTRST(v)   ((((reg32_t) v) << 31) & BM_TVENC_CTRL_SFTRST)
#else
#define BF_TVENC_CTRL_SFTRST(v)   (((v) << 31) & BM_TVENC_CTRL_SFTRST)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_CTRL_SFTRST(v)   BF_CS1(TVENC_CTRL, SFTRST, v)
#endif

//--- Register HW_TVENC_CTRL, field CLKGATE

#define BP_TVENC_CTRL_CLKGATE      30
#define BM_TVENC_CTRL_CLKGATE      0x40000000

#define BF_TVENC_CTRL_CLKGATE(v)   (((v) << 30) & BM_TVENC_CTRL_CLKGATE)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_CTRL_CLKGATE(v)   BF_CS1(TVENC_CTRL, CLKGATE, v)
#endif

//--- Register HW_TVENC_CTRL, field TVENC_MACROVISION_PRESENT

#define BP_TVENC_CTRL_TVENC_MACROVISION_PRESENT      29
#define BM_TVENC_CTRL_TVENC_MACROVISION_PRESENT      0x20000000

#define BF_TVENC_CTRL_TVENC_MACROVISION_PRESENT(v)   (((v) << 29) & BM_TVENC_CTRL_TVENC_MACROVISION_PRESENT)

//--- Register HW_TVENC_CTRL, field TVENC_COMPOSITE_PRESENT

#define BP_TVENC_CTRL_TVENC_COMPOSITE_PRESENT      28
#define BM_TVENC_CTRL_TVENC_COMPOSITE_PRESENT      0x10000000

#define BF_TVENC_CTRL_TVENC_COMPOSITE_PRESENT(v)   (((v) << 28) & BM_TVENC_CTRL_TVENC_COMPOSITE_PRESENT)

//--- Register HW_TVENC_CTRL, field TVENC_SVIDEO_PRESENT

#define BP_TVENC_CTRL_TVENC_SVIDEO_PRESENT      27
#define BM_TVENC_CTRL_TVENC_SVIDEO_PRESENT      0x08000000

#define BF_TVENC_CTRL_TVENC_SVIDEO_PRESENT(v)   (((v) << 27) & BM_TVENC_CTRL_TVENC_SVIDEO_PRESENT)

//--- Register HW_TVENC_CTRL, field TVENC_COMPONENT_PRESENT

#define BP_TVENC_CTRL_TVENC_COMPONENT_PRESENT      26
#define BM_TVENC_CTRL_TVENC_COMPONENT_PRESENT      0x04000000

#define BF_TVENC_CTRL_TVENC_COMPONENT_PRESENT(v)   (((v) << 26) & BM_TVENC_CTRL_TVENC_COMPONENT_PRESENT)

//--- Register HW_TVENC_CTRL, field DAC_FIFO_NO_WRITE

#define BP_TVENC_CTRL_DAC_FIFO_NO_WRITE      5
#define BM_TVENC_CTRL_DAC_FIFO_NO_WRITE      0x00000020

#define BF_TVENC_CTRL_DAC_FIFO_NO_WRITE(v)   (((v) << 5) & BM_TVENC_CTRL_DAC_FIFO_NO_WRITE)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_CTRL_DAC_FIFO_NO_WRITE(v)   BF_CS1(TVENC_CTRL, DAC_FIFO_NO_WRITE, v)
#endif

//--- Register HW_TVENC_CTRL, field DAC_FIFO_NO_READ

#define BP_TVENC_CTRL_DAC_FIFO_NO_READ      4
#define BM_TVENC_CTRL_DAC_FIFO_NO_READ      0x00000010

#define BF_TVENC_CTRL_DAC_FIFO_NO_READ(v)   (((v) << 4) & BM_TVENC_CTRL_DAC_FIFO_NO_READ)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_CTRL_DAC_FIFO_NO_READ(v)   BF_CS1(TVENC_CTRL, DAC_FIFO_NO_READ, v)
#endif

//--- Register HW_TVENC_CTRL, field DAC_DATA_FIFO_RST

#define BP_TVENC_CTRL_DAC_DATA_FIFO_RST      3
#define BM_TVENC_CTRL_DAC_DATA_FIFO_RST      0x00000008

#define BF_TVENC_CTRL_DAC_DATA_FIFO_RST(v)   (((v) << 3) & BM_TVENC_CTRL_DAC_DATA_FIFO_RST)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_CTRL_DAC_DATA_FIFO_RST(v)   BF_CS1(TVENC_CTRL, DAC_DATA_FIFO_RST, v)
#endif

//--- Register HW_TVENC_CTRL, field DAC_MUX_MODE

#define BP_TVENC_CTRL_DAC_MUX_MODE      0
#define BM_TVENC_CTRL_DAC_MUX_MODE      0x00000001

#define BF_TVENC_CTRL_DAC_MUX_MODE(v)   (((v) << 0) & BM_TVENC_CTRL_DAC_MUX_MODE)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_CTRL_DAC_MUX_MODE(v)   BF_CS1(TVENC_CTRL, DAC_MUX_MODE, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_TVENC_CONFIG - TV Encoder Configuration Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ENCD_MODE        :  3;
        unsigned RSRVD1           :  1;
        unsigned SYNC_MODE        :  3;
        unsigned VSYNC_PHS        :  1;
        unsigned HSYNC_PHS        :  1;
        unsigned FSYNC_PHS        :  1;
        unsigned FSYNC_ENBL       :  1;
        unsigned RSRVD2           :  1;
        unsigned CLK_PHS          :  2;
        unsigned CGAIN            :  2;
        unsigned YGAIN_SEL        :  2;
        unsigned COLOR_BAR_EN     :  1;
        unsigned NO_PED           :  1;
        unsigned PAL_SHAPE        :  1;
        unsigned ADD_YPBPR_PED    :  1;
        unsigned RSRVD3           :  1;
        unsigned RSRVD4           :  1;
        unsigned YDEL_ADJ         :  3;
        unsigned DEFAULT_PICFORM  :  1;
        unsigned RSRVD5           :  4;
    } B;
} hw_tvenc_config_t;
#endif


//
// constants & macros for entire HW_TVENC_CONFIG register
//

#define HW_TVENC_CONFIG_ADDR      (REGS_TVENC_BASE + 0x00000010)
#define HW_TVENC_CONFIG_SET_ADDR  (REGS_TVENC_BASE + 0x00000014)
#define HW_TVENC_CONFIG_CLR_ADDR  (REGS_TVENC_BASE + 0x00000018)
#define HW_TVENC_CONFIG_TOG_ADDR  (REGS_TVENC_BASE + 0x0000001C)

#ifndef __LANGUAGE_ASM__
#define HW_TVENC_CONFIG           (*(volatile hw_tvenc_config_t *) HW_TVENC_CONFIG_ADDR)
#define HW_TVENC_CONFIG_RD()      (HW_TVENC_CONFIG.U)
#define HW_TVENC_CONFIG_WR(v)     (HW_TVENC_CONFIG.U = (v))
#define HW_TVENC_CONFIG_SET(v)    ((*(volatile reg32_t *) HW_TVENC_CONFIG_SET_ADDR) = (v))
#define HW_TVENC_CONFIG_CLR(v)    ((*(volatile reg32_t *) HW_TVENC_CONFIG_CLR_ADDR) = (v))
#define HW_TVENC_CONFIG_TOG(v)    ((*(volatile reg32_t *) HW_TVENC_CONFIG_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_TVENC_CONFIG bitfields
//

//--- Register HW_TVENC_CONFIG, field DEFAULT_PICFORM

#define BP_TVENC_CONFIG_DEFAULT_PICFORM      27
#define BM_TVENC_CONFIG_DEFAULT_PICFORM      0x08000000

#define BF_TVENC_CONFIG_DEFAULT_PICFORM(v)   (((v) << 27) & BM_TVENC_CONFIG_DEFAULT_PICFORM)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_CONFIG_DEFAULT_PICFORM(v)   BF_CS1(TVENC_CONFIG, DEFAULT_PICFORM, v)
#endif

//--- Register HW_TVENC_CONFIG, field YDEL_ADJ

#define BP_TVENC_CONFIG_YDEL_ADJ      24
#define BM_TVENC_CONFIG_YDEL_ADJ      0x07000000

#define BF_TVENC_CONFIG_YDEL_ADJ(v)   (((v) << 24) & BM_TVENC_CONFIG_YDEL_ADJ)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_CONFIG_YDEL_ADJ(v)   BF_CS1(TVENC_CONFIG, YDEL_ADJ, v)
#endif

//--- Register HW_TVENC_CONFIG, field ADD_YPBPR_PED

#define BP_TVENC_CONFIG_ADD_YPBPR_PED      21
#define BM_TVENC_CONFIG_ADD_YPBPR_PED      0x00200000

#define BF_TVENC_CONFIG_ADD_YPBPR_PED(v)   (((v) << 21) & BM_TVENC_CONFIG_ADD_YPBPR_PED)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_CONFIG_ADD_YPBPR_PED(v)   BF_CS1(TVENC_CONFIG, ADD_YPBPR_PED, v)
#endif

//--- Register HW_TVENC_CONFIG, field PAL_SHAPE

#define BP_TVENC_CONFIG_PAL_SHAPE      20
#define BM_TVENC_CONFIG_PAL_SHAPE      0x00100000

#define BF_TVENC_CONFIG_PAL_SHAPE(v)   (((v) << 20) & BM_TVENC_CONFIG_PAL_SHAPE)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_CONFIG_PAL_SHAPE(v)   BF_CS1(TVENC_CONFIG, PAL_SHAPE, v)
#endif

//--- Register HW_TVENC_CONFIG, field NO_PED

#define BP_TVENC_CONFIG_NO_PED      19
#define BM_TVENC_CONFIG_NO_PED      0x00080000

#define BF_TVENC_CONFIG_NO_PED(v)   (((v) << 19) & BM_TVENC_CONFIG_NO_PED)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_CONFIG_NO_PED(v)   BF_CS1(TVENC_CONFIG, NO_PED, v)
#endif

//--- Register HW_TVENC_CONFIG, field COLOR_BAR_EN

#define BP_TVENC_CONFIG_COLOR_BAR_EN      18
#define BM_TVENC_CONFIG_COLOR_BAR_EN      0x00040000

#define BF_TVENC_CONFIG_COLOR_BAR_EN(v)   (((v) << 18) & BM_TVENC_CONFIG_COLOR_BAR_EN)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_CONFIG_COLOR_BAR_EN(v)   BF_CS1(TVENC_CONFIG, COLOR_BAR_EN, v)
#endif

//--- Register HW_TVENC_CONFIG, field YGAIN_SEL

#define BP_TVENC_CONFIG_YGAIN_SEL      16
#define BM_TVENC_CONFIG_YGAIN_SEL      0x00030000

#define BF_TVENC_CONFIG_YGAIN_SEL(v)   (((v) << 16) & BM_TVENC_CONFIG_YGAIN_SEL)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_CONFIG_YGAIN_SEL(v)   BF_CS1(TVENC_CONFIG, YGAIN_SEL, v)
#endif

//--- Register HW_TVENC_CONFIG, field CGAIN

#define BP_TVENC_CONFIG_CGAIN      14
#define BM_TVENC_CONFIG_CGAIN      0x0000C000

#define BF_TVENC_CONFIG_CGAIN(v)   (((v) << 14) & BM_TVENC_CONFIG_CGAIN)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_CONFIG_CGAIN(v)   BF_CS1(TVENC_CONFIG, CGAIN, v)
#endif

//--- Register HW_TVENC_CONFIG, field CLK_PHS

#define BP_TVENC_CONFIG_CLK_PHS      12
#define BM_TVENC_CONFIG_CLK_PHS      0x00003000

#define BF_TVENC_CONFIG_CLK_PHS(v)   (((v) << 12) & BM_TVENC_CONFIG_CLK_PHS)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_CONFIG_CLK_PHS(v)   BF_CS1(TVENC_CONFIG, CLK_PHS, v)
#endif

//--- Register HW_TVENC_CONFIG, field FSYNC_ENBL

#define BP_TVENC_CONFIG_FSYNC_ENBL      10
#define BM_TVENC_CONFIG_FSYNC_ENBL      0x00000400

#define BF_TVENC_CONFIG_FSYNC_ENBL(v)   (((v) << 10) & BM_TVENC_CONFIG_FSYNC_ENBL)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_CONFIG_FSYNC_ENBL(v)   BF_CS1(TVENC_CONFIG, FSYNC_ENBL, v)
#endif

//--- Register HW_TVENC_CONFIG, field FSYNC_PHS

#define BP_TVENC_CONFIG_FSYNC_PHS      9
#define BM_TVENC_CONFIG_FSYNC_PHS      0x00000200

#define BF_TVENC_CONFIG_FSYNC_PHS(v)   (((v) << 9) & BM_TVENC_CONFIG_FSYNC_PHS)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_CONFIG_FSYNC_PHS(v)   BF_CS1(TVENC_CONFIG, FSYNC_PHS, v)
#endif

//--- Register HW_TVENC_CONFIG, field HSYNC_PHS

#define BP_TVENC_CONFIG_HSYNC_PHS      8
#define BM_TVENC_CONFIG_HSYNC_PHS      0x00000100

#define BF_TVENC_CONFIG_HSYNC_PHS(v)   (((v) << 8) & BM_TVENC_CONFIG_HSYNC_PHS)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_CONFIG_HSYNC_PHS(v)   BF_CS1(TVENC_CONFIG, HSYNC_PHS, v)
#endif

//--- Register HW_TVENC_CONFIG, field VSYNC_PHS

#define BP_TVENC_CONFIG_VSYNC_PHS      7
#define BM_TVENC_CONFIG_VSYNC_PHS      0x00000080

#define BF_TVENC_CONFIG_VSYNC_PHS(v)   (((v) << 7) & BM_TVENC_CONFIG_VSYNC_PHS)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_CONFIG_VSYNC_PHS(v)   BF_CS1(TVENC_CONFIG, VSYNC_PHS, v)
#endif

//--- Register HW_TVENC_CONFIG, field SYNC_MODE

#define BP_TVENC_CONFIG_SYNC_MODE      4
#define BM_TVENC_CONFIG_SYNC_MODE      0x00000070

#define BF_TVENC_CONFIG_SYNC_MODE(v)   (((v) << 4) & BM_TVENC_CONFIG_SYNC_MODE)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_CONFIG_SYNC_MODE(v)   BF_CS1(TVENC_CONFIG, SYNC_MODE, v)
#endif

//--- Register HW_TVENC_CONFIG, field ENCD_MODE

#define BP_TVENC_CONFIG_ENCD_MODE      0
#define BM_TVENC_CONFIG_ENCD_MODE      0x00000007

#define BF_TVENC_CONFIG_ENCD_MODE(v)   (((v) << 0) & BM_TVENC_CONFIG_ENCD_MODE)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_CONFIG_ENCD_MODE(v)   BF_CS1(TVENC_CONFIG, ENCD_MODE, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_TVENC_FILTCTRL - TV Encoder Filter Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg8_t   RSRVD4;
        unsigned RSRVD3        :  1;
        unsigned RSRVD2        :  1;
        unsigned YS_GAINSEL    :  2;
        unsigned YS_GAINSGN    :  1;
        unsigned COEFSEL_CLPF  :  1;
        unsigned YLPF_COEFSEL  :  1;
        unsigned SEL_YSHARP    :  1;
        unsigned SEL_CLPF      :  1;
        unsigned SEL_YLPF      :  1;
        unsigned YD_OFFSETSEL  :  1;
        unsigned YSHARP_BW     :  1;
        unsigned RSRVD1        : 12;
    } B;
} hw_tvenc_filtctrl_t;
#endif


//
// constants & macros for entire HW_TVENC_FILTCTRL register
//

#define HW_TVENC_FILTCTRL_ADDR      (REGS_TVENC_BASE + 0x00000020)
#define HW_TVENC_FILTCTRL_SET_ADDR  (REGS_TVENC_BASE + 0x00000024)
#define HW_TVENC_FILTCTRL_CLR_ADDR  (REGS_TVENC_BASE + 0x00000028)
#define HW_TVENC_FILTCTRL_TOG_ADDR  (REGS_TVENC_BASE + 0x0000002C)

#ifndef __LANGUAGE_ASM__
#define HW_TVENC_FILTCTRL           (*(volatile hw_tvenc_filtctrl_t *) HW_TVENC_FILTCTRL_ADDR)
#define HW_TVENC_FILTCTRL_RD()      (HW_TVENC_FILTCTRL.U)
#define HW_TVENC_FILTCTRL_WR(v)     (HW_TVENC_FILTCTRL.U = (v))
#define HW_TVENC_FILTCTRL_SET(v)    ((*(volatile reg32_t *) HW_TVENC_FILTCTRL_SET_ADDR) = (v))
#define HW_TVENC_FILTCTRL_CLR(v)    ((*(volatile reg32_t *) HW_TVENC_FILTCTRL_CLR_ADDR) = (v))
#define HW_TVENC_FILTCTRL_TOG(v)    ((*(volatile reg32_t *) HW_TVENC_FILTCTRL_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_TVENC_FILTCTRL bitfields
//

//--- Register HW_TVENC_FILTCTRL, field YSHARP_BW

#define BP_TVENC_FILTCTRL_YSHARP_BW      19
#define BM_TVENC_FILTCTRL_YSHARP_BW      0x00080000

#define BF_TVENC_FILTCTRL_YSHARP_BW(v)   (((v) << 19) & BM_TVENC_FILTCTRL_YSHARP_BW)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_FILTCTRL_YSHARP_BW(v)   BF_CS1(TVENC_FILTCTRL, YSHARP_BW, v)
#endif

//--- Register HW_TVENC_FILTCTRL, field YD_OFFSETSEL

#define BP_TVENC_FILTCTRL_YD_OFFSETSEL      18
#define BM_TVENC_FILTCTRL_YD_OFFSETSEL      0x00040000

#define BF_TVENC_FILTCTRL_YD_OFFSETSEL(v)   (((v) << 18) & BM_TVENC_FILTCTRL_YD_OFFSETSEL)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_FILTCTRL_YD_OFFSETSEL(v)   BF_CS1(TVENC_FILTCTRL, YD_OFFSETSEL, v)
#endif

//--- Register HW_TVENC_FILTCTRL, field SEL_YLPF

#define BP_TVENC_FILTCTRL_SEL_YLPF      17
#define BM_TVENC_FILTCTRL_SEL_YLPF      0x00020000

#define BF_TVENC_FILTCTRL_SEL_YLPF(v)   (((v) << 17) & BM_TVENC_FILTCTRL_SEL_YLPF)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_FILTCTRL_SEL_YLPF(v)   BF_CS1(TVENC_FILTCTRL, SEL_YLPF, v)
#endif

//--- Register HW_TVENC_FILTCTRL, field SEL_CLPF

#define BP_TVENC_FILTCTRL_SEL_CLPF      16
#define BM_TVENC_FILTCTRL_SEL_CLPF      0x00010000

#define BF_TVENC_FILTCTRL_SEL_CLPF(v)   (((v) << 16) & BM_TVENC_FILTCTRL_SEL_CLPF)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_FILTCTRL_SEL_CLPF(v)   BF_CS1(TVENC_FILTCTRL, SEL_CLPF, v)
#endif

//--- Register HW_TVENC_FILTCTRL, field SEL_YSHARP

#define BP_TVENC_FILTCTRL_SEL_YSHARP      15
#define BM_TVENC_FILTCTRL_SEL_YSHARP      0x00008000

#define BF_TVENC_FILTCTRL_SEL_YSHARP(v)   (((v) << 15) & BM_TVENC_FILTCTRL_SEL_YSHARP)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_FILTCTRL_SEL_YSHARP(v)   BF_CS1(TVENC_FILTCTRL, SEL_YSHARP, v)
#endif

//--- Register HW_TVENC_FILTCTRL, field YLPF_COEFSEL

#define BP_TVENC_FILTCTRL_YLPF_COEFSEL      14
#define BM_TVENC_FILTCTRL_YLPF_COEFSEL      0x00004000

#define BF_TVENC_FILTCTRL_YLPF_COEFSEL(v)   (((v) << 14) & BM_TVENC_FILTCTRL_YLPF_COEFSEL)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_FILTCTRL_YLPF_COEFSEL(v)   BF_CS1(TVENC_FILTCTRL, YLPF_COEFSEL, v)
#endif

//--- Register HW_TVENC_FILTCTRL, field COEFSEL_CLPF

#define BP_TVENC_FILTCTRL_COEFSEL_CLPF      13
#define BM_TVENC_FILTCTRL_COEFSEL_CLPF      0x00002000

#define BF_TVENC_FILTCTRL_COEFSEL_CLPF(v)   (((v) << 13) & BM_TVENC_FILTCTRL_COEFSEL_CLPF)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_FILTCTRL_COEFSEL_CLPF(v)   BF_CS1(TVENC_FILTCTRL, COEFSEL_CLPF, v)
#endif

//--- Register HW_TVENC_FILTCTRL, field YS_GAINSGN

#define BP_TVENC_FILTCTRL_YS_GAINSGN      12
#define BM_TVENC_FILTCTRL_YS_GAINSGN      0x00001000

#define BF_TVENC_FILTCTRL_YS_GAINSGN(v)   (((v) << 12) & BM_TVENC_FILTCTRL_YS_GAINSGN)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_FILTCTRL_YS_GAINSGN(v)   BF_CS1(TVENC_FILTCTRL, YS_GAINSGN, v)
#endif

//--- Register HW_TVENC_FILTCTRL, field YS_GAINSEL

#define BP_TVENC_FILTCTRL_YS_GAINSEL      10
#define BM_TVENC_FILTCTRL_YS_GAINSEL      0x00000C00

#define BF_TVENC_FILTCTRL_YS_GAINSEL(v)   (((v) << 10) & BM_TVENC_FILTCTRL_YS_GAINSEL)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_FILTCTRL_YS_GAINSEL(v)   BF_CS1(TVENC_FILTCTRL, YS_GAINSEL, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_TVENC_SYNCOFFSET - TV Sync Offset Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned HLC     : 10;
        unsigned VSO     : 10;
        unsigned HSO     : 11;
        unsigned RSRVD1  :  1;
    } B;
} hw_tvenc_syncoffset_t;
#endif


//
// constants & macros for entire HW_TVENC_SYNCOFFSET register
//

#define HW_TVENC_SYNCOFFSET_ADDR      (REGS_TVENC_BASE + 0x00000030)
#define HW_TVENC_SYNCOFFSET_SET_ADDR  (REGS_TVENC_BASE + 0x00000034)
#define HW_TVENC_SYNCOFFSET_CLR_ADDR  (REGS_TVENC_BASE + 0x00000038)
#define HW_TVENC_SYNCOFFSET_TOG_ADDR  (REGS_TVENC_BASE + 0x0000003C)

#ifndef __LANGUAGE_ASM__
#define HW_TVENC_SYNCOFFSET           (*(volatile hw_tvenc_syncoffset_t *) HW_TVENC_SYNCOFFSET_ADDR)
#define HW_TVENC_SYNCOFFSET_RD()      (HW_TVENC_SYNCOFFSET.U)
#define HW_TVENC_SYNCOFFSET_WR(v)     (HW_TVENC_SYNCOFFSET.U = (v))
#define HW_TVENC_SYNCOFFSET_SET(v)    ((*(volatile reg32_t *) HW_TVENC_SYNCOFFSET_SET_ADDR) = (v))
#define HW_TVENC_SYNCOFFSET_CLR(v)    ((*(volatile reg32_t *) HW_TVENC_SYNCOFFSET_CLR_ADDR) = (v))
#define HW_TVENC_SYNCOFFSET_TOG(v)    ((*(volatile reg32_t *) HW_TVENC_SYNCOFFSET_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_TVENC_SYNCOFFSET bitfields
//

//--- Register HW_TVENC_SYNCOFFSET, field HSO

#define BP_TVENC_SYNCOFFSET_HSO      20
#define BM_TVENC_SYNCOFFSET_HSO      0x7FF00000

#define BF_TVENC_SYNCOFFSET_HSO(v)   (((v) << 20) & BM_TVENC_SYNCOFFSET_HSO)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_SYNCOFFSET_HSO(v)   BF_CS1(TVENC_SYNCOFFSET, HSO, v)
#endif

//--- Register HW_TVENC_SYNCOFFSET, field VSO

#define BP_TVENC_SYNCOFFSET_VSO      10
#define BM_TVENC_SYNCOFFSET_VSO      0x000FFC00

#define BF_TVENC_SYNCOFFSET_VSO(v)   (((v) << 10) & BM_TVENC_SYNCOFFSET_VSO)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_SYNCOFFSET_VSO(v)   BF_CS1(TVENC_SYNCOFFSET, VSO, v)
#endif

//--- Register HW_TVENC_SYNCOFFSET, field HLC

#define BP_TVENC_SYNCOFFSET_HLC      0
#define BM_TVENC_SYNCOFFSET_HLC      0x000003FF

#define BF_TVENC_SYNCOFFSET_HLC(v)   (((v) << 0) & BM_TVENC_SYNCOFFSET_HLC)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_SYNCOFFSET_HLC(v)   BF_CS1(TVENC_SYNCOFFSET, HLC, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_TVENC_HTIMINGSYNC0 - TV Encoder Horizontal Timing Sync Register 0
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned SYNC_STRT  : 10;
        unsigned RSRVD1     :  6;
        unsigned SYNC_END   : 10;
        unsigned RSRVD2     :  6;
    } B;
} hw_tvenc_htimingsync0_t;
#endif


//
// constants & macros for entire HW_TVENC_HTIMINGSYNC0 register
//

#define HW_TVENC_HTIMINGSYNC0_ADDR      (REGS_TVENC_BASE + 0x00000040)
#define HW_TVENC_HTIMINGSYNC0_SET_ADDR  (REGS_TVENC_BASE + 0x00000044)
#define HW_TVENC_HTIMINGSYNC0_CLR_ADDR  (REGS_TVENC_BASE + 0x00000048)
#define HW_TVENC_HTIMINGSYNC0_TOG_ADDR  (REGS_TVENC_BASE + 0x0000004C)

#ifndef __LANGUAGE_ASM__
#define HW_TVENC_HTIMINGSYNC0           (*(volatile hw_tvenc_htimingsync0_t *) HW_TVENC_HTIMINGSYNC0_ADDR)
#define HW_TVENC_HTIMINGSYNC0_RD()      (HW_TVENC_HTIMINGSYNC0.U)
#define HW_TVENC_HTIMINGSYNC0_WR(v)     (HW_TVENC_HTIMINGSYNC0.U = (v))
#define HW_TVENC_HTIMINGSYNC0_SET(v)    ((*(volatile reg32_t *) HW_TVENC_HTIMINGSYNC0_SET_ADDR) = (v))
#define HW_TVENC_HTIMINGSYNC0_CLR(v)    ((*(volatile reg32_t *) HW_TVENC_HTIMINGSYNC0_CLR_ADDR) = (v))
#define HW_TVENC_HTIMINGSYNC0_TOG(v)    ((*(volatile reg32_t *) HW_TVENC_HTIMINGSYNC0_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_TVENC_HTIMINGSYNC0 bitfields
//

//--- Register HW_TVENC_HTIMINGSYNC0, field SYNC_END

#define BP_TVENC_HTIMINGSYNC0_SYNC_END      16
#define BM_TVENC_HTIMINGSYNC0_SYNC_END      0x03FF0000

#define BF_TVENC_HTIMINGSYNC0_SYNC_END(v)   (((v) << 16) & BM_TVENC_HTIMINGSYNC0_SYNC_END)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_HTIMINGSYNC0_SYNC_END(v)   BF_CS1(TVENC_HTIMINGSYNC0, SYNC_END, v)
#endif

//--- Register HW_TVENC_HTIMINGSYNC0, field SYNC_STRT

#define BP_TVENC_HTIMINGSYNC0_SYNC_STRT      0
#define BM_TVENC_HTIMINGSYNC0_SYNC_STRT      0x000003FF

#define BF_TVENC_HTIMINGSYNC0_SYNC_STRT(v)   (((v) << 0) & BM_TVENC_HTIMINGSYNC0_SYNC_STRT)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_HTIMINGSYNC0_SYNC_STRT(v)   BF_CS1(TVENC_HTIMINGSYNC0, SYNC_STRT, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_TVENC_HTIMINGSYNC1 - TV Encoder Horizontal Timing Sync Register 1
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned SYNC_SREND  : 10;
        unsigned RSRVD1      :  6;
        unsigned SYNC_EQEND  : 10;
        unsigned RSRVD2      :  6;
    } B;
} hw_tvenc_htimingsync1_t;
#endif


//
// constants & macros for entire HW_TVENC_HTIMINGSYNC1 register
//

#define HW_TVENC_HTIMINGSYNC1_ADDR      (REGS_TVENC_BASE + 0x00000050)
#define HW_TVENC_HTIMINGSYNC1_SET_ADDR  (REGS_TVENC_BASE + 0x00000054)
#define HW_TVENC_HTIMINGSYNC1_CLR_ADDR  (REGS_TVENC_BASE + 0x00000058)
#define HW_TVENC_HTIMINGSYNC1_TOG_ADDR  (REGS_TVENC_BASE + 0x0000005C)

#ifndef __LANGUAGE_ASM__
#define HW_TVENC_HTIMINGSYNC1           (*(volatile hw_tvenc_htimingsync1_t *) HW_TVENC_HTIMINGSYNC1_ADDR)
#define HW_TVENC_HTIMINGSYNC1_RD()      (HW_TVENC_HTIMINGSYNC1.U)
#define HW_TVENC_HTIMINGSYNC1_WR(v)     (HW_TVENC_HTIMINGSYNC1.U = (v))
#define HW_TVENC_HTIMINGSYNC1_SET(v)    ((*(volatile reg32_t *) HW_TVENC_HTIMINGSYNC1_SET_ADDR) = (v))
#define HW_TVENC_HTIMINGSYNC1_CLR(v)    ((*(volatile reg32_t *) HW_TVENC_HTIMINGSYNC1_CLR_ADDR) = (v))
#define HW_TVENC_HTIMINGSYNC1_TOG(v)    ((*(volatile reg32_t *) HW_TVENC_HTIMINGSYNC1_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_TVENC_HTIMINGSYNC1 bitfields
//

//--- Register HW_TVENC_HTIMINGSYNC1, field SYNC_EQEND

#define BP_TVENC_HTIMINGSYNC1_SYNC_EQEND      16
#define BM_TVENC_HTIMINGSYNC1_SYNC_EQEND      0x03FF0000

#define BF_TVENC_HTIMINGSYNC1_SYNC_EQEND(v)   (((v) << 16) & BM_TVENC_HTIMINGSYNC1_SYNC_EQEND)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_HTIMINGSYNC1_SYNC_EQEND(v)   BF_CS1(TVENC_HTIMINGSYNC1, SYNC_EQEND, v)
#endif

//--- Register HW_TVENC_HTIMINGSYNC1, field SYNC_SREND

#define BP_TVENC_HTIMINGSYNC1_SYNC_SREND      0
#define BM_TVENC_HTIMINGSYNC1_SYNC_SREND      0x000003FF

#define BF_TVENC_HTIMINGSYNC1_SYNC_SREND(v)   (((v) << 0) & BM_TVENC_HTIMINGSYNC1_SYNC_SREND)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_HTIMINGSYNC1_SYNC_SREND(v)   BF_CS1(TVENC_HTIMINGSYNC1, SYNC_SREND, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_TVENC_HTIMINGACTIVE - TV Encoder Horizontal Timing Active Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ACTV_STRT  : 10;
        unsigned RSRVD1     :  6;
        unsigned ACTV_END   : 10;
        unsigned RSRVD2     :  6;
    } B;
} hw_tvenc_htimingactive_t;
#endif


//
// constants & macros for entire HW_TVENC_HTIMINGACTIVE register
//

#define HW_TVENC_HTIMINGACTIVE_ADDR      (REGS_TVENC_BASE + 0x00000060)
#define HW_TVENC_HTIMINGACTIVE_SET_ADDR  (REGS_TVENC_BASE + 0x00000064)
#define HW_TVENC_HTIMINGACTIVE_CLR_ADDR  (REGS_TVENC_BASE + 0x00000068)
#define HW_TVENC_HTIMINGACTIVE_TOG_ADDR  (REGS_TVENC_BASE + 0x0000006C)

#ifndef __LANGUAGE_ASM__
#define HW_TVENC_HTIMINGACTIVE           (*(volatile hw_tvenc_htimingactive_t *) HW_TVENC_HTIMINGACTIVE_ADDR)
#define HW_TVENC_HTIMINGACTIVE_RD()      (HW_TVENC_HTIMINGACTIVE.U)
#define HW_TVENC_HTIMINGACTIVE_WR(v)     (HW_TVENC_HTIMINGACTIVE.U = (v))
#define HW_TVENC_HTIMINGACTIVE_SET(v)    ((*(volatile reg32_t *) HW_TVENC_HTIMINGACTIVE_SET_ADDR) = (v))
#define HW_TVENC_HTIMINGACTIVE_CLR(v)    ((*(volatile reg32_t *) HW_TVENC_HTIMINGACTIVE_CLR_ADDR) = (v))
#define HW_TVENC_HTIMINGACTIVE_TOG(v)    ((*(volatile reg32_t *) HW_TVENC_HTIMINGACTIVE_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_TVENC_HTIMINGACTIVE bitfields
//

//--- Register HW_TVENC_HTIMINGACTIVE, field ACTV_END

#define BP_TVENC_HTIMINGACTIVE_ACTV_END      16
#define BM_TVENC_HTIMINGACTIVE_ACTV_END      0x03FF0000

#define BF_TVENC_HTIMINGACTIVE_ACTV_END(v)   (((v) << 16) & BM_TVENC_HTIMINGACTIVE_ACTV_END)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_HTIMINGACTIVE_ACTV_END(v)   BF_CS1(TVENC_HTIMINGACTIVE, ACTV_END, v)
#endif

//--- Register HW_TVENC_HTIMINGACTIVE, field ACTV_STRT

#define BP_TVENC_HTIMINGACTIVE_ACTV_STRT      0
#define BM_TVENC_HTIMINGACTIVE_ACTV_STRT      0x000003FF

#define BF_TVENC_HTIMINGACTIVE_ACTV_STRT(v)   (((v) << 0) & BM_TVENC_HTIMINGACTIVE_ACTV_STRT)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_HTIMINGACTIVE_ACTV_STRT(v)   BF_CS1(TVENC_HTIMINGACTIVE, ACTV_STRT, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_TVENC_HTIMINGBURST0 - TV Encoder Horizontal Timing Color Burst Register 0
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned NBRST_STRT  : 10;
        unsigned RSRVD1      :  6;
        unsigned WBRST_STRT  : 10;
        unsigned RSRVD2      :  6;
    } B;
} hw_tvenc_htimingburst0_t;
#endif


//
// constants & macros for entire HW_TVENC_HTIMINGBURST0 register
//

#define HW_TVENC_HTIMINGBURST0_ADDR      (REGS_TVENC_BASE + 0x00000070)
#define HW_TVENC_HTIMINGBURST0_SET_ADDR  (REGS_TVENC_BASE + 0x00000074)
#define HW_TVENC_HTIMINGBURST0_CLR_ADDR  (REGS_TVENC_BASE + 0x00000078)
#define HW_TVENC_HTIMINGBURST0_TOG_ADDR  (REGS_TVENC_BASE + 0x0000007C)

#ifndef __LANGUAGE_ASM__
#define HW_TVENC_HTIMINGBURST0           (*(volatile hw_tvenc_htimingburst0_t *) HW_TVENC_HTIMINGBURST0_ADDR)
#define HW_TVENC_HTIMINGBURST0_RD()      (HW_TVENC_HTIMINGBURST0.U)
#define HW_TVENC_HTIMINGBURST0_WR(v)     (HW_TVENC_HTIMINGBURST0.U = (v))
#define HW_TVENC_HTIMINGBURST0_SET(v)    ((*(volatile reg32_t *) HW_TVENC_HTIMINGBURST0_SET_ADDR) = (v))
#define HW_TVENC_HTIMINGBURST0_CLR(v)    ((*(volatile reg32_t *) HW_TVENC_HTIMINGBURST0_CLR_ADDR) = (v))
#define HW_TVENC_HTIMINGBURST0_TOG(v)    ((*(volatile reg32_t *) HW_TVENC_HTIMINGBURST0_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_TVENC_HTIMINGBURST0 bitfields
//

//--- Register HW_TVENC_HTIMINGBURST0, field WBRST_STRT

#define BP_TVENC_HTIMINGBURST0_WBRST_STRT      16
#define BM_TVENC_HTIMINGBURST0_WBRST_STRT      0x03FF0000

#define BF_TVENC_HTIMINGBURST0_WBRST_STRT(v)   (((v) << 16) & BM_TVENC_HTIMINGBURST0_WBRST_STRT)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_HTIMINGBURST0_WBRST_STRT(v)   BF_CS1(TVENC_HTIMINGBURST0, WBRST_STRT, v)
#endif

//--- Register HW_TVENC_HTIMINGBURST0, field NBRST_STRT

#define BP_TVENC_HTIMINGBURST0_NBRST_STRT      0
#define BM_TVENC_HTIMINGBURST0_NBRST_STRT      0x000003FF

#define BF_TVENC_HTIMINGBURST0_NBRST_STRT(v)   (((v) << 0) & BM_TVENC_HTIMINGBURST0_NBRST_STRT)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_HTIMINGBURST0_NBRST_STRT(v)   BF_CS1(TVENC_HTIMINGBURST0, NBRST_STRT, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_TVENC_HTIMINGBURST1 - TV Encoder Horizontal Timing Color Burst Register 1
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BRST_END  : 10;
        unsigned RSRVD1    : 22;
    } B;
} hw_tvenc_htimingburst1_t;
#endif


//
// constants & macros for entire HW_TVENC_HTIMINGBURST1 register
//

#define HW_TVENC_HTIMINGBURST1_ADDR      (REGS_TVENC_BASE + 0x00000080)
#define HW_TVENC_HTIMINGBURST1_SET_ADDR  (REGS_TVENC_BASE + 0x00000084)
#define HW_TVENC_HTIMINGBURST1_CLR_ADDR  (REGS_TVENC_BASE + 0x00000088)
#define HW_TVENC_HTIMINGBURST1_TOG_ADDR  (REGS_TVENC_BASE + 0x0000008C)

#ifndef __LANGUAGE_ASM__
#define HW_TVENC_HTIMINGBURST1           (*(volatile hw_tvenc_htimingburst1_t *) HW_TVENC_HTIMINGBURST1_ADDR)
#define HW_TVENC_HTIMINGBURST1_RD()      (HW_TVENC_HTIMINGBURST1.U)
#define HW_TVENC_HTIMINGBURST1_WR(v)     (HW_TVENC_HTIMINGBURST1.U = (v))
#define HW_TVENC_HTIMINGBURST1_SET(v)    ((*(volatile reg32_t *) HW_TVENC_HTIMINGBURST1_SET_ADDR) = (v))
#define HW_TVENC_HTIMINGBURST1_CLR(v)    ((*(volatile reg32_t *) HW_TVENC_HTIMINGBURST1_CLR_ADDR) = (v))
#define HW_TVENC_HTIMINGBURST1_TOG(v)    ((*(volatile reg32_t *) HW_TVENC_HTIMINGBURST1_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_TVENC_HTIMINGBURST1 bitfields
//

//--- Register HW_TVENC_HTIMINGBURST1, field BRST_END

#define BP_TVENC_HTIMINGBURST1_BRST_END      0
#define BM_TVENC_HTIMINGBURST1_BRST_END      0x000003FF

#define BF_TVENC_HTIMINGBURST1_BRST_END(v)   (((v) << 0) & BM_TVENC_HTIMINGBURST1_BRST_END)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_HTIMINGBURST1_BRST_END(v)   BF_CS1(TVENC_HTIMINGBURST1, BRST_END, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_TVENC_VTIMING0 - TV Encoder Vertical Timing Register 0
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned VSTRT_SUBPH  :  6;
        unsigned RSRVD1       :  2;
        unsigned VSTRT_ACTV   :  6;
        unsigned RSRVD2       :  2;
        unsigned VSTRT_PREEQ  : 10;
        unsigned RSRVD3       :  6;
    } B;
} hw_tvenc_vtiming0_t;
#endif


//
// constants & macros for entire HW_TVENC_VTIMING0 register
//

#define HW_TVENC_VTIMING0_ADDR      (REGS_TVENC_BASE + 0x00000090)
#define HW_TVENC_VTIMING0_SET_ADDR  (REGS_TVENC_BASE + 0x00000094)
#define HW_TVENC_VTIMING0_CLR_ADDR  (REGS_TVENC_BASE + 0x00000098)
#define HW_TVENC_VTIMING0_TOG_ADDR  (REGS_TVENC_BASE + 0x0000009C)

#ifndef __LANGUAGE_ASM__
#define HW_TVENC_VTIMING0           (*(volatile hw_tvenc_vtiming0_t *) HW_TVENC_VTIMING0_ADDR)
#define HW_TVENC_VTIMING0_RD()      (HW_TVENC_VTIMING0.U)
#define HW_TVENC_VTIMING0_WR(v)     (HW_TVENC_VTIMING0.U = (v))
#define HW_TVENC_VTIMING0_SET(v)    ((*(volatile reg32_t *) HW_TVENC_VTIMING0_SET_ADDR) = (v))
#define HW_TVENC_VTIMING0_CLR(v)    ((*(volatile reg32_t *) HW_TVENC_VTIMING0_CLR_ADDR) = (v))
#define HW_TVENC_VTIMING0_TOG(v)    ((*(volatile reg32_t *) HW_TVENC_VTIMING0_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_TVENC_VTIMING0 bitfields
//

//--- Register HW_TVENC_VTIMING0, field VSTRT_PREEQ

#define BP_TVENC_VTIMING0_VSTRT_PREEQ      16
#define BM_TVENC_VTIMING0_VSTRT_PREEQ      0x03FF0000

#define BF_TVENC_VTIMING0_VSTRT_PREEQ(v)   (((v) << 16) & BM_TVENC_VTIMING0_VSTRT_PREEQ)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_VTIMING0_VSTRT_PREEQ(v)   BF_CS1(TVENC_VTIMING0, VSTRT_PREEQ, v)
#endif

//--- Register HW_TVENC_VTIMING0, field VSTRT_ACTV

#define BP_TVENC_VTIMING0_VSTRT_ACTV      8
#define BM_TVENC_VTIMING0_VSTRT_ACTV      0x00003F00

#define BF_TVENC_VTIMING0_VSTRT_ACTV(v)   (((v) << 8) & BM_TVENC_VTIMING0_VSTRT_ACTV)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_VTIMING0_VSTRT_ACTV(v)   BF_CS1(TVENC_VTIMING0, VSTRT_ACTV, v)
#endif

//--- Register HW_TVENC_VTIMING0, field VSTRT_SUBPH

#define BP_TVENC_VTIMING0_VSTRT_SUBPH      0
#define BM_TVENC_VTIMING0_VSTRT_SUBPH      0x0000003F

#define BF_TVENC_VTIMING0_VSTRT_SUBPH(v)   (((v) << 0) & BM_TVENC_VTIMING0_VSTRT_SUBPH)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_VTIMING0_VSTRT_SUBPH(v)   BF_CS1(TVENC_VTIMING0, VSTRT_SUBPH, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_TVENC_VTIMING1 - TV Encoder Vertical Timing Register 1
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned LAST_FLD_LN   : 10;
        unsigned RSRVD1        :  6;
        unsigned VSTRT_SERRA   :  6;
        unsigned RSRVD2        :  2;
        unsigned VSTRT_POSTEQ  :  6;
        unsigned RSRVD3        :  2;
    } B;
} hw_tvenc_vtiming1_t;
#endif


//
// constants & macros for entire HW_TVENC_VTIMING1 register
//

#define HW_TVENC_VTIMING1_ADDR      (REGS_TVENC_BASE + 0x000000A0)
#define HW_TVENC_VTIMING1_SET_ADDR  (REGS_TVENC_BASE + 0x000000A4)
#define HW_TVENC_VTIMING1_CLR_ADDR  (REGS_TVENC_BASE + 0x000000A8)
#define HW_TVENC_VTIMING1_TOG_ADDR  (REGS_TVENC_BASE + 0x000000AC)

#ifndef __LANGUAGE_ASM__
#define HW_TVENC_VTIMING1           (*(volatile hw_tvenc_vtiming1_t *) HW_TVENC_VTIMING1_ADDR)
#define HW_TVENC_VTIMING1_RD()      (HW_TVENC_VTIMING1.U)
#define HW_TVENC_VTIMING1_WR(v)     (HW_TVENC_VTIMING1.U = (v))
#define HW_TVENC_VTIMING1_SET(v)    ((*(volatile reg32_t *) HW_TVENC_VTIMING1_SET_ADDR) = (v))
#define HW_TVENC_VTIMING1_CLR(v)    ((*(volatile reg32_t *) HW_TVENC_VTIMING1_CLR_ADDR) = (v))
#define HW_TVENC_VTIMING1_TOG(v)    ((*(volatile reg32_t *) HW_TVENC_VTIMING1_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_TVENC_VTIMING1 bitfields
//

//--- Register HW_TVENC_VTIMING1, field VSTRT_POSTEQ

#define BP_TVENC_VTIMING1_VSTRT_POSTEQ      24
#define BM_TVENC_VTIMING1_VSTRT_POSTEQ      0x3F000000

#define BF_TVENC_VTIMING1_VSTRT_POSTEQ(v)   (((v) << 24) & BM_TVENC_VTIMING1_VSTRT_POSTEQ)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_VTIMING1_VSTRT_POSTEQ(v)   BF_CS1(TVENC_VTIMING1, VSTRT_POSTEQ, v)
#endif

//--- Register HW_TVENC_VTIMING1, field VSTRT_SERRA

#define BP_TVENC_VTIMING1_VSTRT_SERRA      16
#define BM_TVENC_VTIMING1_VSTRT_SERRA      0x003F0000

#define BF_TVENC_VTIMING1_VSTRT_SERRA(v)   (((v) << 16) & BM_TVENC_VTIMING1_VSTRT_SERRA)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_VTIMING1_VSTRT_SERRA(v)   BF_CS1(TVENC_VTIMING1, VSTRT_SERRA, v)
#endif

//--- Register HW_TVENC_VTIMING1, field LAST_FLD_LN

#define BP_TVENC_VTIMING1_LAST_FLD_LN      0
#define BM_TVENC_VTIMING1_LAST_FLD_LN      0x000003FF

#define BF_TVENC_VTIMING1_LAST_FLD_LN(v)   (((v) << 0) & BM_TVENC_VTIMING1_LAST_FLD_LN)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_VTIMING1_LAST_FLD_LN(v)   BF_CS1(TVENC_VTIMING1, LAST_FLD_LN, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_TVENC_MISC - TV Encoder Miscellaneous Line Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned Y_BLANK_CTRL       :  2;
        unsigned CS_INVERT_CTRL     :  1;
        unsigned RSRVD1             :  1;
        unsigned AGC_LVL_CTRL       :  2;
        unsigned BRUCHB             :  2;
        unsigned FSC_PHASE_RST      :  2;
        unsigned PAL_FSC_PHASE_ALT  :  1;
        unsigned NTSC_LN_CNT        :  1;
        unsigned RSRVD2             :  4;
        unsigned LPF_RST_OFF        :  9;
        unsigned RSRVD3             :  7;
    } B;
} hw_tvenc_misc_t;
#endif


//
// constants & macros for entire HW_TVENC_MISC register
//

#define HW_TVENC_MISC_ADDR      (REGS_TVENC_BASE + 0x000000B0)
#define HW_TVENC_MISC_SET_ADDR  (REGS_TVENC_BASE + 0x000000B4)
#define HW_TVENC_MISC_CLR_ADDR  (REGS_TVENC_BASE + 0x000000B8)
#define HW_TVENC_MISC_TOG_ADDR  (REGS_TVENC_BASE + 0x000000BC)

#ifndef __LANGUAGE_ASM__
#define HW_TVENC_MISC           (*(volatile hw_tvenc_misc_t *) HW_TVENC_MISC_ADDR)
#define HW_TVENC_MISC_RD()      (HW_TVENC_MISC.U)
#define HW_TVENC_MISC_WR(v)     (HW_TVENC_MISC.U = (v))
#define HW_TVENC_MISC_SET(v)    ((*(volatile reg32_t *) HW_TVENC_MISC_SET_ADDR) = (v))
#define HW_TVENC_MISC_CLR(v)    ((*(volatile reg32_t *) HW_TVENC_MISC_CLR_ADDR) = (v))
#define HW_TVENC_MISC_TOG(v)    ((*(volatile reg32_t *) HW_TVENC_MISC_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_TVENC_MISC bitfields
//

//--- Register HW_TVENC_MISC, field LPF_RST_OFF

#define BP_TVENC_MISC_LPF_RST_OFF      16
#define BM_TVENC_MISC_LPF_RST_OFF      0x01FF0000

#define BF_TVENC_MISC_LPF_RST_OFF(v)   (((v) << 16) & BM_TVENC_MISC_LPF_RST_OFF)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_MISC_LPF_RST_OFF(v)   BF_CS1(TVENC_MISC, LPF_RST_OFF, v)
#endif

//--- Register HW_TVENC_MISC, field NTSC_LN_CNT

#define BP_TVENC_MISC_NTSC_LN_CNT      11
#define BM_TVENC_MISC_NTSC_LN_CNT      0x00000800

#define BF_TVENC_MISC_NTSC_LN_CNT(v)   (((v) << 11) & BM_TVENC_MISC_NTSC_LN_CNT)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_MISC_NTSC_LN_CNT(v)   BF_CS1(TVENC_MISC, NTSC_LN_CNT, v)
#endif

//--- Register HW_TVENC_MISC, field PAL_FSC_PHASE_ALT

#define BP_TVENC_MISC_PAL_FSC_PHASE_ALT      10
#define BM_TVENC_MISC_PAL_FSC_PHASE_ALT      0x00000400

#define BF_TVENC_MISC_PAL_FSC_PHASE_ALT(v)   (((v) << 10) & BM_TVENC_MISC_PAL_FSC_PHASE_ALT)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_MISC_PAL_FSC_PHASE_ALT(v)   BF_CS1(TVENC_MISC, PAL_FSC_PHASE_ALT, v)
#endif

//--- Register HW_TVENC_MISC, field FSC_PHASE_RST

#define BP_TVENC_MISC_FSC_PHASE_RST      8
#define BM_TVENC_MISC_FSC_PHASE_RST      0x00000300

#define BF_TVENC_MISC_FSC_PHASE_RST(v)   (((v) << 8) & BM_TVENC_MISC_FSC_PHASE_RST)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_MISC_FSC_PHASE_RST(v)   BF_CS1(TVENC_MISC, FSC_PHASE_RST, v)
#endif

//--- Register HW_TVENC_MISC, field BRUCHB

#define BP_TVENC_MISC_BRUCHB      6
#define BM_TVENC_MISC_BRUCHB      0x000000C0

#define BF_TVENC_MISC_BRUCHB(v)   (((v) << 6) & BM_TVENC_MISC_BRUCHB)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_MISC_BRUCHB(v)   BF_CS1(TVENC_MISC, BRUCHB, v)
#endif

//--- Register HW_TVENC_MISC, field AGC_LVL_CTRL

#define BP_TVENC_MISC_AGC_LVL_CTRL      4
#define BM_TVENC_MISC_AGC_LVL_CTRL      0x00000030

#define BF_TVENC_MISC_AGC_LVL_CTRL(v)   (((v) << 4) & BM_TVENC_MISC_AGC_LVL_CTRL)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_MISC_AGC_LVL_CTRL(v)   BF_CS1(TVENC_MISC, AGC_LVL_CTRL, v)
#endif

//--- Register HW_TVENC_MISC, field CS_INVERT_CTRL

#define BP_TVENC_MISC_CS_INVERT_CTRL      2
#define BM_TVENC_MISC_CS_INVERT_CTRL      0x00000004

#define BF_TVENC_MISC_CS_INVERT_CTRL(v)   (((v) << 2) & BM_TVENC_MISC_CS_INVERT_CTRL)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_MISC_CS_INVERT_CTRL(v)   BF_CS1(TVENC_MISC, CS_INVERT_CTRL, v)
#endif

//--- Register HW_TVENC_MISC, field Y_BLANK_CTRL

#define BP_TVENC_MISC_Y_BLANK_CTRL      0
#define BM_TVENC_MISC_Y_BLANK_CTRL      0x00000003

#define BF_TVENC_MISC_Y_BLANK_CTRL(v)   (((v) << 0) & BM_TVENC_MISC_Y_BLANK_CTRL)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_MISC_Y_BLANK_CTRL(v)   BF_CS1(TVENC_MISC, Y_BLANK_CTRL, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_TVENC_COLORSUB0 - TV Encoder Color Subcarrier Register 0
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  PHASE_INC;
    } B;
} hw_tvenc_colorsub0_t;
#endif


//
// constants & macros for entire HW_TVENC_COLORSUB0 register
//

#define HW_TVENC_COLORSUB0_ADDR      (REGS_TVENC_BASE + 0x000000C0)
#define HW_TVENC_COLORSUB0_SET_ADDR  (REGS_TVENC_BASE + 0x000000C4)
#define HW_TVENC_COLORSUB0_CLR_ADDR  (REGS_TVENC_BASE + 0x000000C8)
#define HW_TVENC_COLORSUB0_TOG_ADDR  (REGS_TVENC_BASE + 0x000000CC)

#ifndef __LANGUAGE_ASM__
#define HW_TVENC_COLORSUB0           (*(volatile hw_tvenc_colorsub0_t *) HW_TVENC_COLORSUB0_ADDR)
#define HW_TVENC_COLORSUB0_RD()      (HW_TVENC_COLORSUB0.U)
#define HW_TVENC_COLORSUB0_WR(v)     (HW_TVENC_COLORSUB0.U = (v))
#define HW_TVENC_COLORSUB0_SET(v)    ((*(volatile reg32_t *) HW_TVENC_COLORSUB0_SET_ADDR) = (v))
#define HW_TVENC_COLORSUB0_CLR(v)    ((*(volatile reg32_t *) HW_TVENC_COLORSUB0_CLR_ADDR) = (v))
#define HW_TVENC_COLORSUB0_TOG(v)    ((*(volatile reg32_t *) HW_TVENC_COLORSUB0_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_TVENC_COLORSUB0 bitfields
//

//--- Register HW_TVENC_COLORSUB0, field PHASE_INC

#define BP_TVENC_COLORSUB0_PHASE_INC      0
#define BM_TVENC_COLORSUB0_PHASE_INC      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_TVENC_COLORSUB0_PHASE_INC(v)   ((reg32_t) v)
#else
#define BF_TVENC_COLORSUB0_PHASE_INC(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_COLORSUB0_PHASE_INC(v)   (HW_TVENC_COLORSUB0.B.PHASE_INC = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_TVENC_COLORSUB1 - TV Encoder Color Subcarrier Register 1
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  PHASE_OFFSET;
    } B;
} hw_tvenc_colorsub1_t;
#endif


//
// constants & macros for entire HW_TVENC_COLORSUB1 register
//

#define HW_TVENC_COLORSUB1_ADDR      (REGS_TVENC_BASE + 0x000000D0)
#define HW_TVENC_COLORSUB1_SET_ADDR  (REGS_TVENC_BASE + 0x000000D4)
#define HW_TVENC_COLORSUB1_CLR_ADDR  (REGS_TVENC_BASE + 0x000000D8)
#define HW_TVENC_COLORSUB1_TOG_ADDR  (REGS_TVENC_BASE + 0x000000DC)

#ifndef __LANGUAGE_ASM__
#define HW_TVENC_COLORSUB1           (*(volatile hw_tvenc_colorsub1_t *) HW_TVENC_COLORSUB1_ADDR)
#define HW_TVENC_COLORSUB1_RD()      (HW_TVENC_COLORSUB1.U)
#define HW_TVENC_COLORSUB1_WR(v)     (HW_TVENC_COLORSUB1.U = (v))
#define HW_TVENC_COLORSUB1_SET(v)    ((*(volatile reg32_t *) HW_TVENC_COLORSUB1_SET_ADDR) = (v))
#define HW_TVENC_COLORSUB1_CLR(v)    ((*(volatile reg32_t *) HW_TVENC_COLORSUB1_CLR_ADDR) = (v))
#define HW_TVENC_COLORSUB1_TOG(v)    ((*(volatile reg32_t *) HW_TVENC_COLORSUB1_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_TVENC_COLORSUB1 bitfields
//

//--- Register HW_TVENC_COLORSUB1, field PHASE_OFFSET

#define BP_TVENC_COLORSUB1_PHASE_OFFSET      0
#define BM_TVENC_COLORSUB1_PHASE_OFFSET      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_TVENC_COLORSUB1_PHASE_OFFSET(v)   ((reg32_t) v)
#else
#define BF_TVENC_COLORSUB1_PHASE_OFFSET(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_COLORSUB1_PHASE_OFFSET(v)   (HW_TVENC_COLORSUB1.B.PHASE_OFFSET = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_TVENC_COPYPROTECT - TV Encoder Copy Protect Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned WSS_CGMS_DATA  : 14;
        unsigned CGMS_ENBL      :  1;
        unsigned WSS_ENBL       :  1;
        reg16_t  RSRVD1;
    } B;
} hw_tvenc_copyprotect_t;
#endif


//
// constants & macros for entire HW_TVENC_COPYPROTECT register
//

#define HW_TVENC_COPYPROTECT_ADDR      (REGS_TVENC_BASE + 0x000000E0)
#define HW_TVENC_COPYPROTECT_SET_ADDR  (REGS_TVENC_BASE + 0x000000E4)
#define HW_TVENC_COPYPROTECT_CLR_ADDR  (REGS_TVENC_BASE + 0x000000E8)
#define HW_TVENC_COPYPROTECT_TOG_ADDR  (REGS_TVENC_BASE + 0x000000EC)

#ifndef __LANGUAGE_ASM__
#define HW_TVENC_COPYPROTECT           (*(volatile hw_tvenc_copyprotect_t *) HW_TVENC_COPYPROTECT_ADDR)
#define HW_TVENC_COPYPROTECT_RD()      (HW_TVENC_COPYPROTECT.U)
#define HW_TVENC_COPYPROTECT_WR(v)     (HW_TVENC_COPYPROTECT.U = (v))
#define HW_TVENC_COPYPROTECT_SET(v)    ((*(volatile reg32_t *) HW_TVENC_COPYPROTECT_SET_ADDR) = (v))
#define HW_TVENC_COPYPROTECT_CLR(v)    ((*(volatile reg32_t *) HW_TVENC_COPYPROTECT_CLR_ADDR) = (v))
#define HW_TVENC_COPYPROTECT_TOG(v)    ((*(volatile reg32_t *) HW_TVENC_COPYPROTECT_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_TVENC_COPYPROTECT bitfields
//

//--- Register HW_TVENC_COPYPROTECT, field WSS_ENBL

#define BP_TVENC_COPYPROTECT_WSS_ENBL      15
#define BM_TVENC_COPYPROTECT_WSS_ENBL      0x00008000

#define BF_TVENC_COPYPROTECT_WSS_ENBL(v)   (((v) << 15) & BM_TVENC_COPYPROTECT_WSS_ENBL)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_COPYPROTECT_WSS_ENBL(v)   BF_CS1(TVENC_COPYPROTECT, WSS_ENBL, v)
#endif

//--- Register HW_TVENC_COPYPROTECT, field CGMS_ENBL

#define BP_TVENC_COPYPROTECT_CGMS_ENBL      14
#define BM_TVENC_COPYPROTECT_CGMS_ENBL      0x00004000

#define BF_TVENC_COPYPROTECT_CGMS_ENBL(v)   (((v) << 14) & BM_TVENC_COPYPROTECT_CGMS_ENBL)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_COPYPROTECT_CGMS_ENBL(v)   BF_CS1(TVENC_COPYPROTECT, CGMS_ENBL, v)
#endif

//--- Register HW_TVENC_COPYPROTECT, field WSS_CGMS_DATA

#define BP_TVENC_COPYPROTECT_WSS_CGMS_DATA      0
#define BM_TVENC_COPYPROTECT_WSS_CGMS_DATA      0x00003FFF

#define BF_TVENC_COPYPROTECT_WSS_CGMS_DATA(v)   (((v) << 0) & BM_TVENC_COPYPROTECT_WSS_CGMS_DATA)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_COPYPROTECT_WSS_CGMS_DATA(v)   BF_CS1(TVENC_COPYPROTECT, WSS_CGMS_DATA, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_TVENC_CLOSEDCAPTION - TV Encoder Closed Caption Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg16_t  CC_DATA;
        unsigned CC_FILL  :  2;
        unsigned CC_ENBL  :  2;
        unsigned RSRVD1   : 12;
    } B;
} hw_tvenc_closedcaption_t;
#endif


//
// constants & macros for entire HW_TVENC_CLOSEDCAPTION register
//

#define HW_TVENC_CLOSEDCAPTION_ADDR      (REGS_TVENC_BASE + 0x000000F0)
#define HW_TVENC_CLOSEDCAPTION_SET_ADDR  (REGS_TVENC_BASE + 0x000000F4)
#define HW_TVENC_CLOSEDCAPTION_CLR_ADDR  (REGS_TVENC_BASE + 0x000000F8)
#define HW_TVENC_CLOSEDCAPTION_TOG_ADDR  (REGS_TVENC_BASE + 0x000000FC)

#ifndef __LANGUAGE_ASM__
#define HW_TVENC_CLOSEDCAPTION           (*(volatile hw_tvenc_closedcaption_t *) HW_TVENC_CLOSEDCAPTION_ADDR)
#define HW_TVENC_CLOSEDCAPTION_RD()      (HW_TVENC_CLOSEDCAPTION.U)
#define HW_TVENC_CLOSEDCAPTION_WR(v)     (HW_TVENC_CLOSEDCAPTION.U = (v))
#define HW_TVENC_CLOSEDCAPTION_SET(v)    ((*(volatile reg32_t *) HW_TVENC_CLOSEDCAPTION_SET_ADDR) = (v))
#define HW_TVENC_CLOSEDCAPTION_CLR(v)    ((*(volatile reg32_t *) HW_TVENC_CLOSEDCAPTION_CLR_ADDR) = (v))
#define HW_TVENC_CLOSEDCAPTION_TOG(v)    ((*(volatile reg32_t *) HW_TVENC_CLOSEDCAPTION_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_TVENC_CLOSEDCAPTION bitfields
//

//--- Register HW_TVENC_CLOSEDCAPTION, field CC_ENBL

#define BP_TVENC_CLOSEDCAPTION_CC_ENBL      18
#define BM_TVENC_CLOSEDCAPTION_CC_ENBL      0x000C0000

#define BF_TVENC_CLOSEDCAPTION_CC_ENBL(v)   (((v) << 18) & BM_TVENC_CLOSEDCAPTION_CC_ENBL)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_CLOSEDCAPTION_CC_ENBL(v)   BF_CS1(TVENC_CLOSEDCAPTION, CC_ENBL, v)
#endif

//--- Register HW_TVENC_CLOSEDCAPTION, field CC_FILL

#define BP_TVENC_CLOSEDCAPTION_CC_FILL      16
#define BM_TVENC_CLOSEDCAPTION_CC_FILL      0x00030000

#define BF_TVENC_CLOSEDCAPTION_CC_FILL(v)   (((v) << 16) & BM_TVENC_CLOSEDCAPTION_CC_FILL)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_CLOSEDCAPTION_CC_FILL(v)   BF_CS1(TVENC_CLOSEDCAPTION, CC_FILL, v)
#endif

//--- Register HW_TVENC_CLOSEDCAPTION, field CC_DATA

#define BP_TVENC_CLOSEDCAPTION_CC_DATA      0
#define BM_TVENC_CLOSEDCAPTION_CC_DATA      0x0000FFFF

#define BF_TVENC_CLOSEDCAPTION_CC_DATA(v)   (((v) << 0) & BM_TVENC_CLOSEDCAPTION_CC_DATA)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_CLOSEDCAPTION_CC_DATA(v)   (HW_TVENC_CLOSEDCAPTION.B.CC_DATA = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_TVENC_COLORBURST - TV Encoder Color Burst Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSRVD2  : 12;
        unsigned RSRVD1  :  4;
        reg8_t   PBA;
        reg8_t   NBA;
    } B;
} hw_tvenc_colorburst_t;
#endif


//
// constants & macros for entire HW_TVENC_COLORBURST register
//

#define HW_TVENC_COLORBURST_ADDR      (REGS_TVENC_BASE + 0x00000140)
#define HW_TVENC_COLORBURST_SET_ADDR  (REGS_TVENC_BASE + 0x00000144)
#define HW_TVENC_COLORBURST_CLR_ADDR  (REGS_TVENC_BASE + 0x00000148)
#define HW_TVENC_COLORBURST_TOG_ADDR  (REGS_TVENC_BASE + 0x0000014C)

#ifndef __LANGUAGE_ASM__
#define HW_TVENC_COLORBURST           (*(volatile hw_tvenc_colorburst_t *) HW_TVENC_COLORBURST_ADDR)
#define HW_TVENC_COLORBURST_RD()      (HW_TVENC_COLORBURST.U)
#define HW_TVENC_COLORBURST_WR(v)     (HW_TVENC_COLORBURST.U = (v))
#define HW_TVENC_COLORBURST_SET(v)    ((*(volatile reg32_t *) HW_TVENC_COLORBURST_SET_ADDR) = (v))
#define HW_TVENC_COLORBURST_CLR(v)    ((*(volatile reg32_t *) HW_TVENC_COLORBURST_CLR_ADDR) = (v))
#define HW_TVENC_COLORBURST_TOG(v)    ((*(volatile reg32_t *) HW_TVENC_COLORBURST_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_TVENC_COLORBURST bitfields
//

//--- Register HW_TVENC_COLORBURST, field NBA

#define BP_TVENC_COLORBURST_NBA      24
#define BM_TVENC_COLORBURST_NBA      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_TVENC_COLORBURST_NBA(v)   ((((reg32_t) v) << 24) & BM_TVENC_COLORBURST_NBA)
#else
#define BF_TVENC_COLORBURST_NBA(v)   (((v) << 24) & BM_TVENC_COLORBURST_NBA)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_COLORBURST_NBA(v)   (HW_TVENC_COLORBURST.B.NBA = (v))
#endif

//--- Register HW_TVENC_COLORBURST, field PBA

#define BP_TVENC_COLORBURST_PBA      16
#define BM_TVENC_COLORBURST_PBA      0x00FF0000

#define BF_TVENC_COLORBURST_PBA(v)   (((v) << 16) & BM_TVENC_COLORBURST_PBA)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_COLORBURST_PBA(v)   (HW_TVENC_COLORBURST.B.PBA = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_TVENC_MACROVISION0 - TV Encoder Macrovision Parameter Register 0
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_tvenc_macrovision0_t;
#endif


//
// constants & macros for entire HW_TVENC_MACROVISION0 register
//

#define HW_TVENC_MACROVISION0_ADDR      (REGS_TVENC_BASE + 0x00000150)
#define HW_TVENC_MACROVISION0_SET_ADDR  (REGS_TVENC_BASE + 0x00000154)
#define HW_TVENC_MACROVISION0_CLR_ADDR  (REGS_TVENC_BASE + 0x00000158)
#define HW_TVENC_MACROVISION0_TOG_ADDR  (REGS_TVENC_BASE + 0x0000015C)

#ifndef __LANGUAGE_ASM__
#define HW_TVENC_MACROVISION0           (*(volatile hw_tvenc_macrovision0_t *) HW_TVENC_MACROVISION0_ADDR)
#define HW_TVENC_MACROVISION0_RD()      (HW_TVENC_MACROVISION0.U)
#define HW_TVENC_MACROVISION0_WR(v)     (HW_TVENC_MACROVISION0.U = (v))
#define HW_TVENC_MACROVISION0_SET(v)    ((*(volatile reg32_t *) HW_TVENC_MACROVISION0_SET_ADDR) = (v))
#define HW_TVENC_MACROVISION0_CLR(v)    ((*(volatile reg32_t *) HW_TVENC_MACROVISION0_CLR_ADDR) = (v))
#define HW_TVENC_MACROVISION0_TOG(v)    ((*(volatile reg32_t *) HW_TVENC_MACROVISION0_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_TVENC_MACROVISION0 bitfields
//

//--- Register HW_TVENC_MACROVISION0, field DATA

#define BP_TVENC_MACROVISION0_DATA      0
#define BM_TVENC_MACROVISION0_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_TVENC_MACROVISION0_DATA(v)   ((reg32_t) v)
#else
#define BF_TVENC_MACROVISION0_DATA(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_MACROVISION0_DATA(v)   (HW_TVENC_MACROVISION0.B.DATA = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_TVENC_MACROVISION1 - TV Encoder Macrovision Parameter Register 1
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_tvenc_macrovision1_t;
#endif


//
// constants & macros for entire HW_TVENC_MACROVISION1 register
//

#define HW_TVENC_MACROVISION1_ADDR      (REGS_TVENC_BASE + 0x00000160)
#define HW_TVENC_MACROVISION1_SET_ADDR  (REGS_TVENC_BASE + 0x00000164)
#define HW_TVENC_MACROVISION1_CLR_ADDR  (REGS_TVENC_BASE + 0x00000168)
#define HW_TVENC_MACROVISION1_TOG_ADDR  (REGS_TVENC_BASE + 0x0000016C)

#ifndef __LANGUAGE_ASM__
#define HW_TVENC_MACROVISION1           (*(volatile hw_tvenc_macrovision1_t *) HW_TVENC_MACROVISION1_ADDR)
#define HW_TVENC_MACROVISION1_RD()      (HW_TVENC_MACROVISION1.U)
#define HW_TVENC_MACROVISION1_WR(v)     (HW_TVENC_MACROVISION1.U = (v))
#define HW_TVENC_MACROVISION1_SET(v)    ((*(volatile reg32_t *) HW_TVENC_MACROVISION1_SET_ADDR) = (v))
#define HW_TVENC_MACROVISION1_CLR(v)    ((*(volatile reg32_t *) HW_TVENC_MACROVISION1_CLR_ADDR) = (v))
#define HW_TVENC_MACROVISION1_TOG(v)    ((*(volatile reg32_t *) HW_TVENC_MACROVISION1_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_TVENC_MACROVISION1 bitfields
//

//--- Register HW_TVENC_MACROVISION1, field DATA

#define BP_TVENC_MACROVISION1_DATA      0
#define BM_TVENC_MACROVISION1_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_TVENC_MACROVISION1_DATA(v)   ((reg32_t) v)
#else
#define BF_TVENC_MACROVISION1_DATA(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_MACROVISION1_DATA(v)   (HW_TVENC_MACROVISION1.B.DATA = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_TVENC_MACROVISION2 - TV Encoder Macrovision Parameter Register 2
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_tvenc_macrovision2_t;
#endif


//
// constants & macros for entire HW_TVENC_MACROVISION2 register
//

#define HW_TVENC_MACROVISION2_ADDR      (REGS_TVENC_BASE + 0x00000170)
#define HW_TVENC_MACROVISION2_SET_ADDR  (REGS_TVENC_BASE + 0x00000174)
#define HW_TVENC_MACROVISION2_CLR_ADDR  (REGS_TVENC_BASE + 0x00000178)
#define HW_TVENC_MACROVISION2_TOG_ADDR  (REGS_TVENC_BASE + 0x0000017C)

#ifndef __LANGUAGE_ASM__
#define HW_TVENC_MACROVISION2           (*(volatile hw_tvenc_macrovision2_t *) HW_TVENC_MACROVISION2_ADDR)
#define HW_TVENC_MACROVISION2_RD()      (HW_TVENC_MACROVISION2.U)
#define HW_TVENC_MACROVISION2_WR(v)     (HW_TVENC_MACROVISION2.U = (v))
#define HW_TVENC_MACROVISION2_SET(v)    ((*(volatile reg32_t *) HW_TVENC_MACROVISION2_SET_ADDR) = (v))
#define HW_TVENC_MACROVISION2_CLR(v)    ((*(volatile reg32_t *) HW_TVENC_MACROVISION2_CLR_ADDR) = (v))
#define HW_TVENC_MACROVISION2_TOG(v)    ((*(volatile reg32_t *) HW_TVENC_MACROVISION2_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_TVENC_MACROVISION2 bitfields
//

//--- Register HW_TVENC_MACROVISION2, field DATA

#define BP_TVENC_MACROVISION2_DATA      0
#define BM_TVENC_MACROVISION2_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_TVENC_MACROVISION2_DATA(v)   ((reg32_t) v)
#else
#define BF_TVENC_MACROVISION2_DATA(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_MACROVISION2_DATA(v)   (HW_TVENC_MACROVISION2.B.DATA = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_TVENC_MACROVISION3 - TV Encoder Macrovision Parameter Register 3
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_tvenc_macrovision3_t;
#endif


//
// constants & macros for entire HW_TVENC_MACROVISION3 register
//

#define HW_TVENC_MACROVISION3_ADDR      (REGS_TVENC_BASE + 0x00000180)
#define HW_TVENC_MACROVISION3_SET_ADDR  (REGS_TVENC_BASE + 0x00000184)
#define HW_TVENC_MACROVISION3_CLR_ADDR  (REGS_TVENC_BASE + 0x00000188)
#define HW_TVENC_MACROVISION3_TOG_ADDR  (REGS_TVENC_BASE + 0x0000018C)

#ifndef __LANGUAGE_ASM__
#define HW_TVENC_MACROVISION3           (*(volatile hw_tvenc_macrovision3_t *) HW_TVENC_MACROVISION3_ADDR)
#define HW_TVENC_MACROVISION3_RD()      (HW_TVENC_MACROVISION3.U)
#define HW_TVENC_MACROVISION3_WR(v)     (HW_TVENC_MACROVISION3.U = (v))
#define HW_TVENC_MACROVISION3_SET(v)    ((*(volatile reg32_t *) HW_TVENC_MACROVISION3_SET_ADDR) = (v))
#define HW_TVENC_MACROVISION3_CLR(v)    ((*(volatile reg32_t *) HW_TVENC_MACROVISION3_CLR_ADDR) = (v))
#define HW_TVENC_MACROVISION3_TOG(v)    ((*(volatile reg32_t *) HW_TVENC_MACROVISION3_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_TVENC_MACROVISION3 bitfields
//

//--- Register HW_TVENC_MACROVISION3, field DATA

#define BP_TVENC_MACROVISION3_DATA      0
#define BM_TVENC_MACROVISION3_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_TVENC_MACROVISION3_DATA(v)   ((reg32_t) v)
#else
#define BF_TVENC_MACROVISION3_DATA(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_MACROVISION3_DATA(v)   (HW_TVENC_MACROVISION3.B.DATA = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_TVENC_MACROVISION4 - TV Encoder Macrovision Parameter Register 4
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DATA      : 11;
        unsigned RSRVD1    :  5;
        reg8_t   MACV_TST;
        reg8_t   RSRVD2;
    } B;
} hw_tvenc_macrovision4_t;
#endif


//
// constants & macros for entire HW_TVENC_MACROVISION4 register
//

#define HW_TVENC_MACROVISION4_ADDR      (REGS_TVENC_BASE + 0x00000190)
#define HW_TVENC_MACROVISION4_SET_ADDR  (REGS_TVENC_BASE + 0x00000194)
#define HW_TVENC_MACROVISION4_CLR_ADDR  (REGS_TVENC_BASE + 0x00000198)
#define HW_TVENC_MACROVISION4_TOG_ADDR  (REGS_TVENC_BASE + 0x0000019C)

#ifndef __LANGUAGE_ASM__
#define HW_TVENC_MACROVISION4           (*(volatile hw_tvenc_macrovision4_t *) HW_TVENC_MACROVISION4_ADDR)
#define HW_TVENC_MACROVISION4_RD()      (HW_TVENC_MACROVISION4.U)
#define HW_TVENC_MACROVISION4_WR(v)     (HW_TVENC_MACROVISION4.U = (v))
#define HW_TVENC_MACROVISION4_SET(v)    ((*(volatile reg32_t *) HW_TVENC_MACROVISION4_SET_ADDR) = (v))
#define HW_TVENC_MACROVISION4_CLR(v)    ((*(volatile reg32_t *) HW_TVENC_MACROVISION4_CLR_ADDR) = (v))
#define HW_TVENC_MACROVISION4_TOG(v)    ((*(volatile reg32_t *) HW_TVENC_MACROVISION4_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_TVENC_MACROVISION4 bitfields
//

//--- Register HW_TVENC_MACROVISION4, field MACV_TST

#define BP_TVENC_MACROVISION4_MACV_TST      16
#define BM_TVENC_MACROVISION4_MACV_TST      0x00FF0000

#define BF_TVENC_MACROVISION4_MACV_TST(v)   (((v) << 16) & BM_TVENC_MACROVISION4_MACV_TST)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_MACROVISION4_MACV_TST(v)   (HW_TVENC_MACROVISION4.B.MACV_TST = (v))
#endif

//--- Register HW_TVENC_MACROVISION4, field DATA

#define BP_TVENC_MACROVISION4_DATA      0
#define BM_TVENC_MACROVISION4_DATA      0x000007FF

#define BF_TVENC_MACROVISION4_DATA(v)   (((v) << 0) & BM_TVENC_MACROVISION4_DATA)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_MACROVISION4_DATA(v)   BF_CS1(TVENC_MACROVISION4, DATA, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_TVENC_DACCTRL - TV Encoder DAC Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned CASC_ADJ            :  2;
        unsigned HALF_CURRENT        :  1;
        unsigned NO_INTERNAL_TERM    :  1;
        unsigned RVAL                :  3;
        unsigned LOWER_SIGNAL        :  1;
        unsigned DUMP_TOVDD1         :  1;
        unsigned RSRVD8              :  1;
        unsigned RSRVD7              :  1;
        unsigned WELL_TOVDD          :  1;
        unsigned PWRUP1              :  1;
        unsigned RSRVD6              :  1;
        unsigned RSRVD5              :  1;
        unsigned BYPASS_ACT_CASCODE  :  1;
        unsigned SELECT_CLK          :  1;
        unsigned INVERT_CLK          :  1;
        unsigned GAINUP              :  1;
        unsigned GAINDN              :  1;
        unsigned JACK_DIS_ADJ        :  2;
        unsigned DISABLE_GND_DETECT  :  1;
        unsigned TEST1               :  1;
        unsigned JACK1_DET_EN        :  1;
        unsigned RSRVD4              :  1;
        unsigned RSRVD3              :  1;
        unsigned TEST2               :  1;
        unsigned JACK1_DIS_DET_EN    :  1;
        unsigned RSRVD2              :  1;
        unsigned RSRVD1              :  1;
        unsigned TEST3               :  1;
    } B;
} hw_tvenc_dacctrl_t;
#endif


//
// constants & macros for entire HW_TVENC_DACCTRL register
//

#define HW_TVENC_DACCTRL_ADDR      (REGS_TVENC_BASE + 0x000001A0)
#define HW_TVENC_DACCTRL_SET_ADDR  (REGS_TVENC_BASE + 0x000001A4)
#define HW_TVENC_DACCTRL_CLR_ADDR  (REGS_TVENC_BASE + 0x000001A8)
#define HW_TVENC_DACCTRL_TOG_ADDR  (REGS_TVENC_BASE + 0x000001AC)

#ifndef __LANGUAGE_ASM__
#define HW_TVENC_DACCTRL           (*(volatile hw_tvenc_dacctrl_t *) HW_TVENC_DACCTRL_ADDR)
#define HW_TVENC_DACCTRL_RD()      (HW_TVENC_DACCTRL.U)
#define HW_TVENC_DACCTRL_WR(v)     (HW_TVENC_DACCTRL.U = (v))
#define HW_TVENC_DACCTRL_SET(v)    ((*(volatile reg32_t *) HW_TVENC_DACCTRL_SET_ADDR) = (v))
#define HW_TVENC_DACCTRL_CLR(v)    ((*(volatile reg32_t *) HW_TVENC_DACCTRL_CLR_ADDR) = (v))
#define HW_TVENC_DACCTRL_TOG(v)    ((*(volatile reg32_t *) HW_TVENC_DACCTRL_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_TVENC_DACCTRL bitfields
//

//--- Register HW_TVENC_DACCTRL, field TEST3

#define BP_TVENC_DACCTRL_TEST3      31
#define BM_TVENC_DACCTRL_TEST3      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_TVENC_DACCTRL_TEST3(v)   ((((reg32_t) v) << 31) & BM_TVENC_DACCTRL_TEST3)
#else
#define BF_TVENC_DACCTRL_TEST3(v)   (((v) << 31) & BM_TVENC_DACCTRL_TEST3)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_DACCTRL_TEST3(v)   BF_CS1(TVENC_DACCTRL, TEST3, v)
#endif

//--- Register HW_TVENC_DACCTRL, field JACK1_DIS_DET_EN

#define BP_TVENC_DACCTRL_JACK1_DIS_DET_EN      28
#define BM_TVENC_DACCTRL_JACK1_DIS_DET_EN      0x10000000

#define BF_TVENC_DACCTRL_JACK1_DIS_DET_EN(v)   (((v) << 28) & BM_TVENC_DACCTRL_JACK1_DIS_DET_EN)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_DACCTRL_JACK1_DIS_DET_EN(v)   BF_CS1(TVENC_DACCTRL, JACK1_DIS_DET_EN, v)
#endif

//--- Register HW_TVENC_DACCTRL, field TEST2

#define BP_TVENC_DACCTRL_TEST2      27
#define BM_TVENC_DACCTRL_TEST2      0x08000000

#define BF_TVENC_DACCTRL_TEST2(v)   (((v) << 27) & BM_TVENC_DACCTRL_TEST2)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_DACCTRL_TEST2(v)   BF_CS1(TVENC_DACCTRL, TEST2, v)
#endif

//--- Register HW_TVENC_DACCTRL, field JACK1_DET_EN

#define BP_TVENC_DACCTRL_JACK1_DET_EN      24
#define BM_TVENC_DACCTRL_JACK1_DET_EN      0x01000000

#define BF_TVENC_DACCTRL_JACK1_DET_EN(v)   (((v) << 24) & BM_TVENC_DACCTRL_JACK1_DET_EN)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_DACCTRL_JACK1_DET_EN(v)   BF_CS1(TVENC_DACCTRL, JACK1_DET_EN, v)
#endif

//--- Register HW_TVENC_DACCTRL, field TEST1

#define BP_TVENC_DACCTRL_TEST1      23
#define BM_TVENC_DACCTRL_TEST1      0x00800000

#define BF_TVENC_DACCTRL_TEST1(v)   (((v) << 23) & BM_TVENC_DACCTRL_TEST1)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_DACCTRL_TEST1(v)   BF_CS1(TVENC_DACCTRL, TEST1, v)
#endif

//--- Register HW_TVENC_DACCTRL, field DISABLE_GND_DETECT

#define BP_TVENC_DACCTRL_DISABLE_GND_DETECT      22
#define BM_TVENC_DACCTRL_DISABLE_GND_DETECT      0x00400000

#define BF_TVENC_DACCTRL_DISABLE_GND_DETECT(v)   (((v) << 22) & BM_TVENC_DACCTRL_DISABLE_GND_DETECT)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_DACCTRL_DISABLE_GND_DETECT(v)   BF_CS1(TVENC_DACCTRL, DISABLE_GND_DETECT, v)
#endif

//--- Register HW_TVENC_DACCTRL, field JACK_DIS_ADJ

#define BP_TVENC_DACCTRL_JACK_DIS_ADJ      20
#define BM_TVENC_DACCTRL_JACK_DIS_ADJ      0x00300000

#define BF_TVENC_DACCTRL_JACK_DIS_ADJ(v)   (((v) << 20) & BM_TVENC_DACCTRL_JACK_DIS_ADJ)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_DACCTRL_JACK_DIS_ADJ(v)   BF_CS1(TVENC_DACCTRL, JACK_DIS_ADJ, v)
#endif

//--- Register HW_TVENC_DACCTRL, field GAINDN

#define BP_TVENC_DACCTRL_GAINDN      19
#define BM_TVENC_DACCTRL_GAINDN      0x00080000

#define BF_TVENC_DACCTRL_GAINDN(v)   (((v) << 19) & BM_TVENC_DACCTRL_GAINDN)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_DACCTRL_GAINDN(v)   BF_CS1(TVENC_DACCTRL, GAINDN, v)
#endif

//--- Register HW_TVENC_DACCTRL, field GAINUP

#define BP_TVENC_DACCTRL_GAINUP      18
#define BM_TVENC_DACCTRL_GAINUP      0x00040000

#define BF_TVENC_DACCTRL_GAINUP(v)   (((v) << 18) & BM_TVENC_DACCTRL_GAINUP)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_DACCTRL_GAINUP(v)   BF_CS1(TVENC_DACCTRL, GAINUP, v)
#endif

//--- Register HW_TVENC_DACCTRL, field INVERT_CLK

#define BP_TVENC_DACCTRL_INVERT_CLK      17
#define BM_TVENC_DACCTRL_INVERT_CLK      0x00020000

#define BF_TVENC_DACCTRL_INVERT_CLK(v)   (((v) << 17) & BM_TVENC_DACCTRL_INVERT_CLK)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_DACCTRL_INVERT_CLK(v)   BF_CS1(TVENC_DACCTRL, INVERT_CLK, v)
#endif

//--- Register HW_TVENC_DACCTRL, field SELECT_CLK

#define BP_TVENC_DACCTRL_SELECT_CLK      16
#define BM_TVENC_DACCTRL_SELECT_CLK      0x00010000

#define BF_TVENC_DACCTRL_SELECT_CLK(v)   (((v) << 16) & BM_TVENC_DACCTRL_SELECT_CLK)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_DACCTRL_SELECT_CLK(v)   BF_CS1(TVENC_DACCTRL, SELECT_CLK, v)
#endif

//--- Register HW_TVENC_DACCTRL, field BYPASS_ACT_CASCODE

#define BP_TVENC_DACCTRL_BYPASS_ACT_CASCODE      15
#define BM_TVENC_DACCTRL_BYPASS_ACT_CASCODE      0x00008000

#define BF_TVENC_DACCTRL_BYPASS_ACT_CASCODE(v)   (((v) << 15) & BM_TVENC_DACCTRL_BYPASS_ACT_CASCODE)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_DACCTRL_BYPASS_ACT_CASCODE(v)   BF_CS1(TVENC_DACCTRL, BYPASS_ACT_CASCODE, v)
#endif

//--- Register HW_TVENC_DACCTRL, field PWRUP1

#define BP_TVENC_DACCTRL_PWRUP1      12
#define BM_TVENC_DACCTRL_PWRUP1      0x00001000

#define BF_TVENC_DACCTRL_PWRUP1(v)   (((v) << 12) & BM_TVENC_DACCTRL_PWRUP1)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_DACCTRL_PWRUP1(v)   BF_CS1(TVENC_DACCTRL, PWRUP1, v)
#endif

//--- Register HW_TVENC_DACCTRL, field WELL_TOVDD

#define BP_TVENC_DACCTRL_WELL_TOVDD      11
#define BM_TVENC_DACCTRL_WELL_TOVDD      0x00000800

#define BF_TVENC_DACCTRL_WELL_TOVDD(v)   (((v) << 11) & BM_TVENC_DACCTRL_WELL_TOVDD)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_DACCTRL_WELL_TOVDD(v)   BF_CS1(TVENC_DACCTRL, WELL_TOVDD, v)
#endif

//--- Register HW_TVENC_DACCTRL, field DUMP_TOVDD1

#define BP_TVENC_DACCTRL_DUMP_TOVDD1      8
#define BM_TVENC_DACCTRL_DUMP_TOVDD1      0x00000100

#define BF_TVENC_DACCTRL_DUMP_TOVDD1(v)   (((v) << 8) & BM_TVENC_DACCTRL_DUMP_TOVDD1)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_DACCTRL_DUMP_TOVDD1(v)   BF_CS1(TVENC_DACCTRL, DUMP_TOVDD1, v)
#endif

//--- Register HW_TVENC_DACCTRL, field LOWER_SIGNAL

#define BP_TVENC_DACCTRL_LOWER_SIGNAL      7
#define BM_TVENC_DACCTRL_LOWER_SIGNAL      0x00000080

#define BF_TVENC_DACCTRL_LOWER_SIGNAL(v)   (((v) << 7) & BM_TVENC_DACCTRL_LOWER_SIGNAL)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_DACCTRL_LOWER_SIGNAL(v)   BF_CS1(TVENC_DACCTRL, LOWER_SIGNAL, v)
#endif

//--- Register HW_TVENC_DACCTRL, field RVAL

#define BP_TVENC_DACCTRL_RVAL      4
#define BM_TVENC_DACCTRL_RVAL      0x00000070

#define BF_TVENC_DACCTRL_RVAL(v)   (((v) << 4) & BM_TVENC_DACCTRL_RVAL)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_DACCTRL_RVAL(v)   BF_CS1(TVENC_DACCTRL, RVAL, v)
#endif

//--- Register HW_TVENC_DACCTRL, field NO_INTERNAL_TERM

#define BP_TVENC_DACCTRL_NO_INTERNAL_TERM      3
#define BM_TVENC_DACCTRL_NO_INTERNAL_TERM      0x00000008

#define BF_TVENC_DACCTRL_NO_INTERNAL_TERM(v)   (((v) << 3) & BM_TVENC_DACCTRL_NO_INTERNAL_TERM)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_DACCTRL_NO_INTERNAL_TERM(v)   BF_CS1(TVENC_DACCTRL, NO_INTERNAL_TERM, v)
#endif

//--- Register HW_TVENC_DACCTRL, field HALF_CURRENT

#define BP_TVENC_DACCTRL_HALF_CURRENT      2
#define BM_TVENC_DACCTRL_HALF_CURRENT      0x00000004

#define BF_TVENC_DACCTRL_HALF_CURRENT(v)   (((v) << 2) & BM_TVENC_DACCTRL_HALF_CURRENT)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_DACCTRL_HALF_CURRENT(v)   BF_CS1(TVENC_DACCTRL, HALF_CURRENT, v)
#endif

//--- Register HW_TVENC_DACCTRL, field CASC_ADJ

#define BP_TVENC_DACCTRL_CASC_ADJ      0
#define BM_TVENC_DACCTRL_CASC_ADJ      0x00000003

#define BF_TVENC_DACCTRL_CASC_ADJ(v)   (((v) << 0) & BM_TVENC_DACCTRL_CASC_ADJ)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_DACCTRL_CASC_ADJ(v)   BF_CS1(TVENC_DACCTRL, CASC_ADJ, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_TVENC_DACSTATUS - TV Encoder DAC Status Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ENIRQ_JACK         :  1;
        unsigned JACK1_DET_IRQ      :  1;
        unsigned RSRVD9             :  1;
        unsigned RSRVD8             :  1;
        unsigned JACK1_DIS_DET_IRQ  :  1;
        unsigned RSRVD7             :  1;
        unsigned RSRVD6             :  1;
        unsigned JACK1_GROUNDED     :  1;
        unsigned RSRVD5             :  1;
        unsigned RSRVD4             :  1;
        unsigned JACK1_DET_STATUS   :  1;
        unsigned RSRVD3             :  1;
        unsigned RSRVD2             :  1;
        unsigned RSRVD1             : 19;
    } B;
} hw_tvenc_dacstatus_t;
#endif


//
// constants & macros for entire HW_TVENC_DACSTATUS register
//

#define HW_TVENC_DACSTATUS_ADDR      (REGS_TVENC_BASE + 0x000001B0)
#define HW_TVENC_DACSTATUS_SET_ADDR  (REGS_TVENC_BASE + 0x000001B4)
#define HW_TVENC_DACSTATUS_CLR_ADDR  (REGS_TVENC_BASE + 0x000001B8)
#define HW_TVENC_DACSTATUS_TOG_ADDR  (REGS_TVENC_BASE + 0x000001BC)

#ifndef __LANGUAGE_ASM__
#define HW_TVENC_DACSTATUS           (*(volatile hw_tvenc_dacstatus_t *) HW_TVENC_DACSTATUS_ADDR)
#define HW_TVENC_DACSTATUS_RD()      (HW_TVENC_DACSTATUS.U)
#define HW_TVENC_DACSTATUS_WR(v)     (HW_TVENC_DACSTATUS.U = (v))
#define HW_TVENC_DACSTATUS_SET(v)    ((*(volatile reg32_t *) HW_TVENC_DACSTATUS_SET_ADDR) = (v))
#define HW_TVENC_DACSTATUS_CLR(v)    ((*(volatile reg32_t *) HW_TVENC_DACSTATUS_CLR_ADDR) = (v))
#define HW_TVENC_DACSTATUS_TOG(v)    ((*(volatile reg32_t *) HW_TVENC_DACSTATUS_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_TVENC_DACSTATUS bitfields
//

//--- Register HW_TVENC_DACSTATUS, field JACK1_DET_STATUS

#define BP_TVENC_DACSTATUS_JACK1_DET_STATUS      10
#define BM_TVENC_DACSTATUS_JACK1_DET_STATUS      0x00000400

#define BF_TVENC_DACSTATUS_JACK1_DET_STATUS(v)   (((v) << 10) & BM_TVENC_DACSTATUS_JACK1_DET_STATUS)

//--- Register HW_TVENC_DACSTATUS, field JACK1_GROUNDED

#define BP_TVENC_DACSTATUS_JACK1_GROUNDED      7
#define BM_TVENC_DACSTATUS_JACK1_GROUNDED      0x00000080

#define BF_TVENC_DACSTATUS_JACK1_GROUNDED(v)   (((v) << 7) & BM_TVENC_DACSTATUS_JACK1_GROUNDED)

//--- Register HW_TVENC_DACSTATUS, field JACK1_DIS_DET_IRQ

#define BP_TVENC_DACSTATUS_JACK1_DIS_DET_IRQ      4
#define BM_TVENC_DACSTATUS_JACK1_DIS_DET_IRQ      0x00000010

#define BF_TVENC_DACSTATUS_JACK1_DIS_DET_IRQ(v)   (((v) << 4) & BM_TVENC_DACSTATUS_JACK1_DIS_DET_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_DACSTATUS_JACK1_DIS_DET_IRQ(v)   BF_CS1(TVENC_DACSTATUS, JACK1_DIS_DET_IRQ, v)
#endif

//--- Register HW_TVENC_DACSTATUS, field JACK1_DET_IRQ

#define BP_TVENC_DACSTATUS_JACK1_DET_IRQ      1
#define BM_TVENC_DACSTATUS_JACK1_DET_IRQ      0x00000002

#define BF_TVENC_DACSTATUS_JACK1_DET_IRQ(v)   (((v) << 1) & BM_TVENC_DACSTATUS_JACK1_DET_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_DACSTATUS_JACK1_DET_IRQ(v)   BF_CS1(TVENC_DACSTATUS, JACK1_DET_IRQ, v)
#endif

//--- Register HW_TVENC_DACSTATUS, field ENIRQ_JACK

#define BP_TVENC_DACSTATUS_ENIRQ_JACK      0
#define BM_TVENC_DACSTATUS_ENIRQ_JACK      0x00000001

#define BF_TVENC_DACSTATUS_ENIRQ_JACK(v)   (((v) << 0) & BM_TVENC_DACSTATUS_ENIRQ_JACK)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_DACSTATUS_ENIRQ_JACK(v)   BF_CS1(TVENC_DACSTATUS, ENIRQ_JACK, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_TVENC_VDACTEST - TV Encoder vDAC Test Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DATA                  : 10;
        unsigned TEST_FIFO_FULL        :  1;
        unsigned BYPASS_PIX_INT_DROOP  :  1;
        unsigned BYPASS_PIX_INT        :  1;
        unsigned ENABLE_PIX_INT_GAIN   :  1;
        unsigned RSRVD1                : 18;
    } B;
} hw_tvenc_vdactest_t;
#endif


//
// constants & macros for entire HW_TVENC_VDACTEST register
//

#define HW_TVENC_VDACTEST_ADDR      (REGS_TVENC_BASE + 0x000001C0)
#define HW_TVENC_VDACTEST_SET_ADDR  (REGS_TVENC_BASE + 0x000001C4)
#define HW_TVENC_VDACTEST_CLR_ADDR  (REGS_TVENC_BASE + 0x000001C8)
#define HW_TVENC_VDACTEST_TOG_ADDR  (REGS_TVENC_BASE + 0x000001CC)

#ifndef __LANGUAGE_ASM__
#define HW_TVENC_VDACTEST           (*(volatile hw_tvenc_vdactest_t *) HW_TVENC_VDACTEST_ADDR)
#define HW_TVENC_VDACTEST_RD()      (HW_TVENC_VDACTEST.U)
#define HW_TVENC_VDACTEST_WR(v)     (HW_TVENC_VDACTEST.U = (v))
#define HW_TVENC_VDACTEST_SET(v)    ((*(volatile reg32_t *) HW_TVENC_VDACTEST_SET_ADDR) = (v))
#define HW_TVENC_VDACTEST_CLR(v)    ((*(volatile reg32_t *) HW_TVENC_VDACTEST_CLR_ADDR) = (v))
#define HW_TVENC_VDACTEST_TOG(v)    ((*(volatile reg32_t *) HW_TVENC_VDACTEST_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_TVENC_VDACTEST bitfields
//

//--- Register HW_TVENC_VDACTEST, field ENABLE_PIX_INT_GAIN

#define BP_TVENC_VDACTEST_ENABLE_PIX_INT_GAIN      13
#define BM_TVENC_VDACTEST_ENABLE_PIX_INT_GAIN      0x00002000

#define BF_TVENC_VDACTEST_ENABLE_PIX_INT_GAIN(v)   (((v) << 13) & BM_TVENC_VDACTEST_ENABLE_PIX_INT_GAIN)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_VDACTEST_ENABLE_PIX_INT_GAIN(v)   BF_CS1(TVENC_VDACTEST, ENABLE_PIX_INT_GAIN, v)
#endif

//--- Register HW_TVENC_VDACTEST, field BYPASS_PIX_INT

#define BP_TVENC_VDACTEST_BYPASS_PIX_INT      12
#define BM_TVENC_VDACTEST_BYPASS_PIX_INT      0x00001000

#define BF_TVENC_VDACTEST_BYPASS_PIX_INT(v)   (((v) << 12) & BM_TVENC_VDACTEST_BYPASS_PIX_INT)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_VDACTEST_BYPASS_PIX_INT(v)   BF_CS1(TVENC_VDACTEST, BYPASS_PIX_INT, v)
#endif

//--- Register HW_TVENC_VDACTEST, field BYPASS_PIX_INT_DROOP

#define BP_TVENC_VDACTEST_BYPASS_PIX_INT_DROOP      11
#define BM_TVENC_VDACTEST_BYPASS_PIX_INT_DROOP      0x00000800

#define BF_TVENC_VDACTEST_BYPASS_PIX_INT_DROOP(v)   (((v) << 11) & BM_TVENC_VDACTEST_BYPASS_PIX_INT_DROOP)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_VDACTEST_BYPASS_PIX_INT_DROOP(v)   BF_CS1(TVENC_VDACTEST, BYPASS_PIX_INT_DROOP, v)
#endif

//--- Register HW_TVENC_VDACTEST, field TEST_FIFO_FULL

#define BP_TVENC_VDACTEST_TEST_FIFO_FULL      10
#define BM_TVENC_VDACTEST_TEST_FIFO_FULL      0x00000400

#define BF_TVENC_VDACTEST_TEST_FIFO_FULL(v)   (((v) << 10) & BM_TVENC_VDACTEST_TEST_FIFO_FULL)

//--- Register HW_TVENC_VDACTEST, field DATA

#define BP_TVENC_VDACTEST_DATA      0
#define BM_TVENC_VDACTEST_DATA      0x000003FF

#define BF_TVENC_VDACTEST_DATA(v)   (((v) << 0) & BM_TVENC_VDACTEST_DATA)

#ifndef __LANGUAGE_ASM__
#define BW_TVENC_VDACTEST_DATA(v)   BF_CS1(TVENC_VDACTEST, DATA, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_TVENC_VERSION - TV Encoder Version Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg16_t  STEP;
        reg8_t   MINOR;
        reg8_t   MAJOR;
    } B;
} hw_tvenc_version_t;
#endif


//
// constants & macros for entire HW_TVENC_VERSION register
//

#define HW_TVENC_VERSION_ADDR      (REGS_TVENC_BASE + 0x000001D0)

#ifndef __LANGUAGE_ASM__
#define HW_TVENC_VERSION           (*(volatile hw_tvenc_version_t *) HW_TVENC_VERSION_ADDR)
#define HW_TVENC_VERSION_RD()      (HW_TVENC_VERSION.U)
#endif


//
// constants & macros for individual HW_TVENC_VERSION bitfields
//

//--- Register HW_TVENC_VERSION, field MAJOR

#define BP_TVENC_VERSION_MAJOR      24
#define BM_TVENC_VERSION_MAJOR      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_TVENC_VERSION_MAJOR(v)   ((((reg32_t) v) << 24) & BM_TVENC_VERSION_MAJOR)
#else
#define BF_TVENC_VERSION_MAJOR(v)   (((v) << 24) & BM_TVENC_VERSION_MAJOR)
#endif

//--- Register HW_TVENC_VERSION, field MINOR

#define BP_TVENC_VERSION_MINOR      16
#define BM_TVENC_VERSION_MINOR      0x00FF0000

#define BF_TVENC_VERSION_MINOR(v)   (((v) << 16) & BM_TVENC_VERSION_MINOR)

//--- Register HW_TVENC_VERSION, field STEP

#define BP_TVENC_VERSION_STEP      0
#define BM_TVENC_VERSION_STEP      0x0000FFFF

#define BF_TVENC_VERSION_STEP(v)   (((v) << 0) & BM_TVENC_VERSION_STEP)


#endif // _REGSTVENC_H

////////////////////////////////////////////////////////////////////////////////
