import * as ESTree from 'estree';
import { TControlFlowCustomNodeFactory } from '../../../types/container/custom-nodes/TControlFlowCustomNodeFactory';
import { TControlFlowStorage } from '../../../types/storages/TControlFlowStorage';
import { IControlFlowReplacer } from '../../../interfaces/node-transformers/control-flow-transformers/IControlFlowReplacer';
import { ICustomNode } from '../../../interfaces/custom-nodes/ICustomNode';
import { IOptions } from '../../../interfaces/options/IOptions';
import { IRandomGenerator } from '../../../interfaces/utils/IRandomGenerator';
export declare abstract class AbstractControlFlowReplacer implements IControlFlowReplacer {
    protected readonly controlFlowCustomNodeFactory: TControlFlowCustomNodeFactory;
    protected readonly options: IOptions;
    protected readonly randomGenerator: IRandomGenerator;
    protected readonly replacerDataByControlFlowStorageId: Map<string, Map<string, string[]>>;
    constructor(controlFlowCustomNodeFactory: TControlFlowCustomNodeFactory, randomGenerator: IRandomGenerator, options: IOptions);
    protected static getStorageKeysByIdForCurrentStorage(identifierDataByControlFlowStorageId: Map<string, Map<string, string[]>>, controlFlowStorageId: string): Map<string, string[]>;
    protected insertCustomNodeToControlFlowStorage(customNode: ICustomNode, controlFlowStorage: TControlFlowStorage, replacerId: string, usingExistingIdentifierChance: number): string;
    abstract replace(node: ESTree.Node, parentNode: ESTree.Node, controlFlowStorage: TControlFlowStorage): ESTree.Node;
}
