// MPR121* Register Defines
module.exports = {
  MAPS: {
    MPR121QR2_SHIELD: {
      KEYS: {
        0: 1,
        1: 2,
        2: 3,
        3: 4,
        4: 5,
        5: 6,
        6: 7,
        7: 8,
        8: 9,
      },
      TARGETS: {
        256: 0,
        32: 1,
        4: 2,
        128: 3,
        16: 4,
        2: 5,
        64: 6,
        8: 7,
        1: 8,
      }
    },
    MPR121: {
      KEYS: {
        0: 0,
        1: 1,
        2: 2,
        3: 3,
        4: 4,
        5: 5,
        6: 6,
        7: 7,
        8: 8,
        9: 9,
        10: 10,
        11: 11,
      },
      TARGETS: {
        1: 0,
        2: 1,
        4: 2,
        8: 3,
        16: 4,
        32: 5,
        64: 6,
        128: 7,
        256: 8,
        512: 9,
        1024: 10,
        2048: 11,
      }
    },
    MPR121_KEYPAD: {
      KEYS: {
        0: 1,
        1: 2,
        2: 3,
        3: 4,
        4: 5,
        5: 6,
        6: 7,
        7: 8,
        8: 9,
        9: 10,
        10: 11,
        11: 12,
      },
      TARGETS: {
        8: 0,
        128: 1,
        2048: 2,
        4: 3,
        64: 4,
        1024: 5,
        2: 6,
        32: 7,
        512: 8,
        1: 9,
        16: 10,
        256: 11,
      },
    },
    MPR121_SHIELD: {
      KEYS: {
        0: 0,
        1: 1,
        2: 2,
        3: 3,
        4: 4,
        5: 5,
        6: 6,
        7: 7,
        8: 8,
        9: 9,
        10: 10,
        11: 11,
      },
      TARGETS: {
        1: 0,
        2: 1,
        4: 2,
        8: 3,
        16: 4,
        32: 5,
        64: 6,
        128: 7,
        256: 8,
        512: 9,
        1024: 10,
        2048: 11,
      },
    },
  },
  MPR121_DEFAULT_ADDRESS: 0x5A,
  MPR121_SOFTRESET: 0x80,

  // MPR121 Registers (from data sheet)
  ELE0_ELE7_TOUCH_STATUS: 0x00,
  ELE8_ELE11_ELEPROX_TOUCH_STATUS: 0x01,

  ELE0_7_OOR_STATUS: 0x02,
  ELE8_11_ELEPROX_OOR_STATUS: 0x03,

  ELE0_FILTERED_DATA_LSB: 0x04,
  ELE0_FILTERED_DATA_MSB: 0x05,
  ELE1_FILTERED_DATA_LSB: 0x06,
  ELE1_FILTERED_DATA_MSB: 0x07,
  ELE2_FILTERED_DATA_LSB: 0x08,
  ELE2_FILTERED_DATA_MSB: 0x09,
  ELE3_FILTERED_DATA_LSB: 0x0A,
  ELE3_FILTERED_DATA_MSB: 0x0B,
  ELE4_FILTERED_DATA_LSB: 0x0C,
  ELE4_FILTERED_DATA_MSB: 0x0D,
  ELE5_FILTERED_DATA_LSB: 0x0E,
  ELE5_FILTERED_DATA_MSB: 0x0F,
  ELE6_FILTERED_DATA_LSB: 0x10,
  ELE6_FILTERED_DATA_MSB: 0x11,
  ELE7_FILTERED_DATA_LSB: 0x12,
  ELE7_FILTERED_DATA_MSB: 0x13,
  ELE8_FILTERED_DATA_LSB: 0x14,
  ELE8_FILTERED_DATA_MSB: 0x15,
  ELE9_FILTERED_DATA_LSB: 0x16,
  ELE9_FILTERED_DATA_MSB: 0x17,
  ELE10_FILTERED_DATA_LSB: 0x18,
  ELE10_FILTERED_DATA_MSB: 0x19,
  ELE11_FILTERED_DATA_LSB: 0x1A,
  ELE11_FILTERED_DATA_MSB: 0x1B,
  ELEPROX_FILTERED_DATA_LSB: 0x1C,
  ELEPROX_FILTERED_DATA_MSB: 0x1D,

  ELE0_BASELINE_VALUE: 0x1E,
  ELE1_BASELINE_VALUE: 0x1F,
  ELE2_BASELINE_VALUE: 0x20,
  ELE3_BASELINE_VALUE: 0x21,
  ELE4_BASELINE_VALUE: 0x22,
  ELE5_BASELINE_VALUE: 0x23,
  ELE6_BASELINE_VALUE: 0x24,
  ELE7_BASELINE_VALUE: 0x25,
  ELE8_BASELINE_VALUE: 0x26,
  ELE9_BASELINE_VALUE: 0x27,
  ELE10_BASELINE_VALUE: 0x28,
  ELE11_BASELINE_VALUE: 0x29,
  ELEPROX_BASELINE_VALUE: 0x2A,

  MHD_RISING: 0x2B,
  NHD_AMOUNT_RISING: 0x2C,
  NCL_RISING: 0x2D,
  FDL_RISING: 0x2E,
  MHD_FALLING: 0x2F,
  NHD_AMOUNT_FALLING: 0x30,
  NCL_FALLING: 0x31,
  FDL_FALLING: 0x32,
  NHD_AMOUNT_TOUCHED: 0x33,
  NCL_TOUCHED: 0x34,
  FDL_TOUCHED: 0x35,
  ELEPROX_MHD_RISING: 0x36,
  ELEPROX_NHD_AMOUNT_RISING: 0x37,
  ELEPROX_NCL_RISING: 0x38,
  ELEPROX_FDL_RISING: 0x39,
  ELEPROX_MHD_FALLING: 0x3A,
  ELEPROX_NHD_AMOUNT_FALLING: 0x3B,
  ELEPROX_FDL_FALLING: 0x3C,
  ELEPROX_NHD_AMOUNT_TOUCHED: 0x3E,
  ELEPROX_NCL_TOUCHED: 0x3F,
  ELEPROX_FDL_TOUCHED: 0x40,

  ELE0_TOUCH_THRESHOLD: 0x41,
  ELE0_RELEASE_THRESHOLD: 0x42,
  ELE1_TOUCH_THRESHOLD: 0x43,
  ELE1_RELEASE_THRESHOLD: 0x44,
  ELE2_TOUCH_THRESHOLD: 0x45,
  ELE2_RELEASE_THRESHOLD: 0x46,
  ELE3_TOUCH_THRESHOLD: 0x47,
  ELE3_RELEASE_THRESHOLD: 0x48,
  ELE4_TOUCH_THRESHOLD: 0x49,
  ELE4_RELEASE_THRESHOLD: 0x4A,
  ELE5_TOUCH_THRESHOLD: 0x4B,
  ELE5_RELEASE_THRESHOLD: 0x4C,
  ELE6_TOUCH_THRESHOLD: 0x4D,
  ELE6_RELEASE_THRESHOLD: 0x4E,
  ELE7_TOUCH_THRESHOLD: 0x4F,
  ELE7_RELEASE_THRESHOLD: 0x50,
  ELE8_TOUCH_THRESHOLD: 0x51,
  ELE8_RELEASE_THRESHOLD: 0x52,
  ELE9_TOUCH_THRESHOLD: 0x53,
  ELE9_RELEASE_THRESHOLD: 0x54,
  ELE10_TOUCH_THRESHOLD: 0x55,
  ELE10_RELEASE_THRESHOLD: 0x56,
  ELE11_TOUCH_THRESHOLD: 0x57,
  ELE11_RELEASE_THRESHOLD: 0x58,
  ELEPROX_TOUCH_THRESHOLD: 0x59,
  ELEPROX_RELEASE_THRESHOLD: 0x5A,
  DEBOUNCE_TOUCH_AND_RELEASE: 0x5B,
  AFE_CONFIGURATION: 0x5C,

  FILTER_CONFIG: 0x5D,
  ELECTRODE_CONFIG: 0x5E,
  ELE0_CURRENT: 0x5F,
  ELE1_CURRENT: 0x60,
  ELE2_CURRENT: 0x61,
  ELE3_CURRENT: 0x62,
  ELE4_CURRENT: 0x63,
  ELE5_CURRENT: 0x64,
  ELE6_CURRENT: 0x65,
  ELE7_CURRENT: 0x66,
  ELE8_CURRENT: 0x67,
  ELE9_CURRENT: 0x68,
  ELE10_CURRENT: 0x69,
  ELE11_CURRENT: 0x6A,
  ELEPROX_CURRENT: 0x6B,

  ELE0_ELE1_CHARGE_TIME: 0x6C,
  ELE2_ELE3_CHARGE_TIME: 0x6D,
  ELE4_ELE5_CHARGE_TIME: 0x6E,
  ELE6_ELE7_CHARGE_TIME: 0x6F,
  ELE8_ELE9_CHARGE_TIME: 0x70,
  ELE10_ELE11_CHARGE_TIME: 0x71,
  ELEPROX_CHARGE_TIME: 0x72,

  GPIO_CONTROL_0: 0x73,
  GPIO_CONTROL_1: 0x74,
  GPIO_DATA: 0x75,
  GPIO_DIRECTION: 0x76,
  GPIO_ENABLE: 0x77,
  GPIO_SET: 0x78,
  GPIO_CLEAR: 0x79,
  GPIO_TOGGLE: 0x7A,
  AUTO_CONFIG_CONTROL_0: 0x7B,
  AUTO_CONFIG_CONTROL_1: 0x7C,
  AUTO_CONFIG_USL: 0x7D,
  AUTO_CONFIG_LSL: 0x7E,
  AUTO_CONFIG_TARGET_LEVEL: 0x7F,

  // Other Constants
  // these are suggested values from app note 3944
  TOUCH_THRESHOLD: 0x0F,
  RELEASE_THRESHOLD: 0x0A,
  NUM_CHANNELS: 12
};
