/*
 * ndpi_content_match.c
 *
 * Copyright (C) 2011-18 - ntop.org
 *
 * nDPI is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * nDPI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with nDPI.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/* ****************************************************** */

static ndpi_network host_protocol_list[] = {
  /*
    SoundCloud
  */
  { 0x22FB2FEE /* 34.251.47.238 */, 32, NDPI_PROTOCOL_SOUNDCLOUD },
  { 0x23A06456 /* 35.160.100.86 */, 32, NDPI_PROTOCOL_SOUNDCLOUD },
  { 0x36C0CA58 /* 54.192.202.88 */, 32, NDPI_PROTOCOL_SOUNDCLOUD },

  /*
    Facebook, Inc.
    origin AS32934, AS54115
  */

  { 0x1F0D1800 /* 31.13.24.0/21 */, 21, NDPI_PROTOCOL_FACEBOOK },
  { 0x1F0D4000 /* 31.13.64.0/18 */, 18, NDPI_PROTOCOL_FACEBOOK },
  { 0x2D402800 /* 45.64.40.0/22 */, 22, NDPI_PROTOCOL_FACEBOOK },
  { 0x42DC9000 /* 66.220.144.0/20 */, 20, NDPI_PROTOCOL_FACEBOOK },
  { 0x453FB000 /* 69.63.176.0/20 */, 20, NDPI_PROTOCOL_FACEBOOK },
  { 0x45ABE000 /* 69.171.224.0/19 */, 19, NDPI_PROTOCOL_FACEBOOK },
  { 0x4A774C00 /* 74.119.76.0/22 */, 22, NDPI_PROTOCOL_FACEBOOK },
  { 0x67046000 /* 103.4.96.0/22 */, 22, NDPI_PROTOCOL_FACEBOOK },
  { 0x81860000 /* 129.134.0.0/16 */, 16, NDPI_PROTOCOL_FACEBOOK },
  { 0x9DF00000 /* 157.240.0.0/16 */, 16, NDPI_PROTOCOL_FACEBOOK },
  { 0xADFC4000 /* 173.252.64.0/18 */, 18, NDPI_PROTOCOL_FACEBOOK },
  { 0xB33CC000 /* 179.60.192.0/22 */, 22, NDPI_PROTOCOL_FACEBOOK },
  { 0xB93CD800 /* 185.60.216.0/22 */, 22, NDPI_PROTOCOL_FACEBOOK },
  { 0xC7C94000 /* 199.201.64.0/22 */, 22, NDPI_PROTOCOL_FACEBOOK },
  { 0xCC0F1400 /* 204.15.20.0/22 */, 22, NDPI_PROTOCOL_FACEBOOK },

  /*
    Twitter Inc.
    origin AS13414, AS35995
  */

  { 0x0819C200 /* 8.25.194.0/23 */, 23, NDPI_PROTOCOL_TWITTER },
  { 0x0819C400 /* 8.25.196.0/23 */, 23, NDPI_PROTOCOL_TWITTER },
  { 0x450C3800 /* 69.12.56.0/21 */, 21, NDPI_PROTOCOL_TWITTER },
  { 0x67FC7000 /* 103.252.112.0/22 */, 22, NDPI_PROTOCOL_TWITTER },
  { 0x68F42800 /* 104.244.40.0/24 */, 24, NDPI_PROTOCOL_TWITTER },
  { 0x68F42900 /* 104.244.41.0/24 */, 24, NDPI_PROTOCOL_TWITTER },
  { 0x68F42A00 /* 104.244.42.0/24 */, 24, NDPI_PROTOCOL_TWITTER },
  { 0x68F42B00 /* 104.244.43.0/24 */, 24, NDPI_PROTOCOL_TWITTER },
  { 0x68F42C00 /* 104.244.44.0/24 */, 24, NDPI_PROTOCOL_TWITTER },
  { 0x68F42D00 /* 104.244.45.0/24 */, 24, NDPI_PROTOCOL_TWITTER },
  { 0x68F42E00 /* 104.244.46.0/24 */, 24, NDPI_PROTOCOL_TWITTER },
  { 0x68F42F00 /* 104.244.47.0/24 */, 24, NDPI_PROTOCOL_TWITTER },
  { 0xB92D0400 /* 185.45.4.0/23 */, 23, NDPI_PROTOCOL_TWITTER },
  { 0xB92D0600 /* 185.45.6.0/23 */, 23, NDPI_PROTOCOL_TWITTER },
  { 0xBC40E000 /* 188.64.224.0/21 */, 21, NDPI_PROTOCOL_TWITTER },
  { 0xC02C4400 /* 192.44.68.0/23 */, 23, NDPI_PROTOCOL_TWITTER },
  { 0xC0854C00 /* 192.133.76.0/22 */, 22, NDPI_PROTOCOL_TWITTER },
  { 0xC7109C00 /* 199.16.156.0/22 */, 22, NDPI_PROTOCOL_TWITTER },
  { 0xC73B9400 /* 199.59.148.0/22 */, 22, NDPI_PROTOCOL_TWITTER },
  { 0xC7453A00 /* 199.69.58.0/23 */, 23, NDPI_PROTOCOL_TWITTER },
  { 0xC7603800 /* 199.96.56.0/21 */, 21, NDPI_PROTOCOL_TWITTER },
  { 0xCAA08000 /* 202.160.128.0/22 */, 22, NDPI_PROTOCOL_TWITTER },

  /*
    WhatsApp Inc.
    List of the WhatsApp server IP addresses and ranges (https://developers.facebook.com/docs/whatsapp/network-debugging/ Dec 21, 2018)
  */
  { 0x6CA8AE00 /* 108.168.174.0/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0x6CA8B0C0 /* 108.168.176.192/26 */, 26, NDPI_PROTOCOL_WHATSAPP },
  { 0x6CA8B100 /* 108.168.177.0/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0x6CA8B460 /* 108.168.180.96/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0x6CA8FE41 /* 108.168.254.65/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x6CA8FFE0 /* 108.168.255.224/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x6CA8FFE3 /* 108.168.255.227/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00135 /* 157.240.1.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00136 /* 157.240.1.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00A35 /* 157.240.10.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00A36 /* 157.240.10.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00B35 /* 157.240.11.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00B36 /* 157.240.11.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00C35 /* 157.240.12.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00C36 /* 157.240.12.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00D36 /* 157.240.13.54/31 */, 31, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00E34 /* 157.240.14.52/31 */, 31, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00F35 /* 157.240.15.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00F36 /* 157.240.15.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF01034 /* 157.240.16.52/31 */, 31, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF01234 /* 157.240.18.52/31 */, 31, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF01335 /* 157.240.19.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF01336 /* 157.240.19.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00235 /* 157.240.2.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00236 /* 157.240.2.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF01434 /* 157.240.20.52/31 */, 31, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF01534 /* 157.240.21.52/31 */, 31, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF01635 /* 157.240.22.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF01636 /* 157.240.22.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF01735 /* 157.240.23.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF01736 /* 157.240.23.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF01D35 /* 157.240.29.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF01D36 /* 157.240.29.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00635 /* 157.240.6.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00636 /* 157.240.6.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00735 /* 157.240.7.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00736 /* 157.240.7.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00835 /* 157.240.8.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00836 /* 157.240.8.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00935 /* 157.240.9.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00936 /* 157.240.9.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9E550060 /* 158.85.0.96/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0x9E55E0A0 /* 158.85.224.160/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0x9E55E920 /* 158.85.233.32/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0x9E55F980 /* 158.85.249.128/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0x9E55FE40 /* 158.85.254.64/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0x9E552E80 /* 158.85.46.128/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0x9E5530E0 /* 158.85.48.224/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0x9E5505C0 /* 158.85.5.192/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0x9E553A00 /* 158.85.58.0/25 */, 25, NDPI_PROTOCOL_WHATSAPP },
  { 0x9E553DC0 /* 158.85.61.192/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92CA700 /* 169.44.167.0/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92C2400 /* 169.44.36.0/25 */, 25, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92C3940 /* 169.44.57.64/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92C3A40 /* 169.44.58.64/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92C5000 /* 169.44.80.0/26 */, 26, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92C5280 /* 169.44.82.128/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92C52C0 /* 169.44.82.192/26 */, 26, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92C5260 /* 169.44.82.96/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92C5300 /* 169.44.83.0/26 */, 26, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92C5380 /* 169.44.83.128/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92C53C0 /* 169.44.83.192/26 */, 26, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92C5360 /* 169.44.83.96/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92C5400 /* 169.44.84.0/24 */, 24, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92C5540 /* 169.44.85.64/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92C57A0 /* 169.44.87.160/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92DA9C0 /* 169.45.169.192/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92DB660 /* 169.45.182.96/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92DD240 /* 169.45.210.64/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92DD6E0 /* 169.45.214.224/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92DDBE0 /* 169.45.219.224/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92DEDC0 /* 169.45.237.192/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92DEE20 /* 169.45.238.32/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92DF2C0 /* 169.45.242.192/26 */, 26, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92DF8A0 /* 169.45.248.160/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92DF860 /* 169.45.248.96/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92D4720 /* 169.45.71.32/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92D4760 /* 169.45.71.96/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92D5780 /* 169.45.87.128/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92E6F90 /* 169.46.111.144/28 */, 28, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92E34E0 /* 169.46.52.224/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92F8260 /* 169.47.130.96/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92F9100 /* 169.47.145.0/26 */, 26, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92F9980 /* 169.47.153.128/25 */, 25, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92FC0C0 /* 169.47.192.192/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92FC280 /* 169.47.194.128/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92FC680 /* 169.47.198.128/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92FD4A0 /* 169.47.212.160/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92F2180 /* 169.47.33.128/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92F2320 /* 169.47.35.32/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92F2580 /* 169.47.37.128/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92F2880 /* 169.47.40.128/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92F2AA0 /* 169.47.42.160/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92F2AC0 /* 169.47.42.192/26 */, 26, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92F2A60 /* 169.47.42.96/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92F2FA0 /* 169.47.47.160/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92F05C0 /* 169.47.5.192/26 */, 26, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92F0640 /* 169.47.6.64/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA9307220 /* 169.48.114.32/28 */, 28, NDPI_PROTOCOL_WHATSAPP },
  { 0xA93079C0 /* 169.48.121.192/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA9307A40 /* 169.48.122.64/26 */, 26, NDPI_PROTOCOL_WHATSAPP },
  { 0xA930D2B0 /* 169.48.210.176/28 */, 28, NDPI_PROTOCOL_WHATSAPP },
  { 0xA930D2E0 /* 169.48.210.224/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA930D340 /* 169.48.211.64/26 */, 26, NDPI_PROTOCOL_WHATSAPP },
  { 0xA930D480 /* 169.48.212.128/25 */, 25, NDPI_PROTOCOL_WHATSAPP },
  { 0xA935FA80 /* 169.53.250.128/26 */, 26, NDPI_PROTOCOL_WHATSAPP },
  { 0xA935FC40 /* 169.53.252.64/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA935FF40 /* 169.53.255.64/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA9351D80 /* 169.53.29.128/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA9353020 /* 169.53.48.32/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA93547E0 /* 169.53.71.224/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA9355140 /* 169.53.81.64/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA936C1A0 /* 169.54.193.160/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA93602A0 /* 169.54.2.160/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA936D200 /* 169.54.210.0/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA936DE80 /* 169.54.222.128/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA9362CE0 /* 169.54.44.224/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA9363320 /* 169.54.51.32/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA93637C0 /* 169.54.55.192/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA93764A0 /* 169.55.100.160/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA9377E40 /* 169.55.126.64/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA937D260 /* 169.55.210.96/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA937EBA0 /* 169.55.235.160/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA9373C94 /* 169.55.60.148/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0xA9373CAA /* 169.55.60.170/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0xA93743E0 /* 169.55.67.224/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA9374580 /* 169.55.69.128/26 */, 26, NDPI_PROTOCOL_WHATSAPP },
  { 0xA9374A20 /* 169.55.74.32/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA9374B60 /* 169.55.75.96/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA93C8180 /* 169.60.129.128/25 */, 25, NDPI_PROTOCOL_WHATSAPP },
  { 0xA93C9300 /* 169.60.147.0/24 */, 24, NDPI_PROTOCOL_WHATSAPP },
  { 0xA93CC540 /* 169.60.197.64/26 */, 26, NDPI_PROTOCOL_WHATSAPP },
  { 0xA93C4A70 /* 169.60.74.112/28 */, 28, NDPI_PROTOCOL_WHATSAPP },
  { 0xA93C4A80 /* 169.60.74.128/26 */, 26, NDPI_PROTOCOL_WHATSAPP },
  { 0xA93C4A20 /* 169.60.74.32/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA93C4B80 /* 169.60.75.128/25 */, 25, NDPI_PROTOCOL_WHATSAPP },
  { 0xA93C4F00 /* 169.60.79.0/24 */, 24, NDPI_PROTOCOL_WHATSAPP },
  { 0xA93D6500 /* 169.61.101.0/24 */, 24, NDPI_PROTOCOL_WHATSAPP },
  { 0xA93D5190 /* 169.61.81.144/28 */, 28, NDPI_PROTOCOL_WHATSAPP },
  { 0xA93D51E0 /* 169.61.81.224/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA93D5240 /* 169.61.82.64/26 */, 26, NDPI_PROTOCOL_WHATSAPP },
  { 0xA93D5480 /* 169.61.84.128/25 */, 25, NDPI_PROTOCOL_WHATSAPP },
  { 0xA93F4080 /* 169.63.64.128/28 */, 28, NDPI_PROTOCOL_WHATSAPP },
  { 0xA93F4920 /* 169.63.73.32/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA93F4940 /* 169.63.73.64/26 */, 26, NDPI_PROTOCOL_WHATSAPP },
  { 0xA93F4C00 /* 169.63.76.0/25 */, 25, NDPI_PROTOCOL_WHATSAPP },
  { 0xADC0A220 /* 173.192.162.32/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xADC0DB80 /* 173.192.219.128/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xADC0DEA0 /* 173.192.222.160/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xADC1E680 /* 173.193.230.128/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xADC1E6C0 /* 173.193.230.192/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xADC1EF00 /* 173.193.239.0/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xAE24D080 /* 174.36.208.128/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xAE24D220 /* 174.36.210.32/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xAE24FBC0 /* 174.36.251.192/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xAE25F340 /* 174.37.243.64/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xAE25FB00 /* 174.37.251.0/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xB33CC030 /* 179.60.192.48/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0xB33CC031 /* 179.60.192.49/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0xB33CC033 /* 179.60.192.51/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0xB33CC134 /* 179.60.193.52/31 */, 31, NDPI_PROTOCOL_WHATSAPP },
  { 0xB33CC235 /* 179.60.194.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0xB33CC236 /* 179.60.194.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0xB33CC331 /* 179.60.195.49/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0xB33CC333 /* 179.60.195.51/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0xB8AD8840 /* 184.173.136.64/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xB8AD9320 /* 184.173.147.32/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xB8ADA140 /* 184.173.161.64/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0xB8ADAD74 /* 184.173.173.116/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0xB8ADB320 /* 184.173.179.32/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xB93CD835 /* 185.60.216.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0xB93CD836 /* 185.60.216.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0xB93CD935 /* 185.60.217.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0xB93CD936 /* 185.60.217.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0xB93CDA35 /* 185.60.218.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0xB93CDA36 /* 185.60.218.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0xB93CDB35 /* 185.60.219.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0xB93CDB36 /* 185.60.219.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0xC09BD4C0 /* 192.155.212.192/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xC60BC1B6 /* 198.11.193.182/31 */, 31, NDPI_PROTOCOL_WHATSAPP },
  { 0xC60BFB20 /* 198.11.251.32/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xC6175000 /* 198.23.80.0/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xD02B73C0 /* 208.43.115.192/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xD02B754F /* 208.43.117.79/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0xD02B7A80 /* 208.43.122.128/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4033 /* 31.13.64.51/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4035 /* 31.13.64.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4131 /* 31.13.65.49/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4132 /* 31.13.65.50/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4334 /* 31.13.67.52/31 */, 31, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4430 /* 31.13.68.48/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4434 /* 31.13.68.52/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D45F0 /* 31.13.69.240/31 */, 31, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4631 /* 31.13.70.49/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4632 /* 31.13.70.50/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4731 /* 31.13.71.49/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4732 /* 31.13.71.50/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4830 /* 31.13.72.48/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4834 /* 31.13.72.52/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4934 /* 31.13.73.52/31 */, 31, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4A34 /* 31.13.74.52/31 */, 31, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4B30 /* 31.13.75.48/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4B34 /* 31.13.75.52/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4C51 /* 31.13.76.81/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4C52 /* 31.13.76.82/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4E35 /* 31.13.78.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4E37 /* 31.13.78.55/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5030 /* 31.13.80.48/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5035 /* 31.13.80.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5130 /* 31.13.81.48/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5135 /* 31.13.81.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5233 /* 31.13.82.51/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5237 /* 31.13.82.55/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5331 /* 31.13.83.49/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5333 /* 31.13.83.51/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5431 /* 31.13.84.49/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5433 /* 31.13.84.51/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5531 /* 31.13.85.49/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5533 /* 31.13.85.51/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5631 /* 31.13.86.49/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5633 /* 31.13.86.51/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5730 /* 31.13.87.48/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5733 /* 31.13.87.51/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5831 /* 31.13.88.49/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5834 /* 31.13.88.52/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5935 /* 31.13.89.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5936 /* 31.13.89.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5A31 /* 31.13.90.49/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5A33 /* 31.13.90.51/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5B31 /* 31.13.91.49/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5B33 /* 31.13.91.51/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5C30 /* 31.13.92.48/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5C34 /* 31.13.92.52/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5D35 /* 31.13.93.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5D36 /* 31.13.93.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5E34 /* 31.13.94.52/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5E36 /* 31.13.94.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5F32 /* 31.13.95.50/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5F3F /* 31.13.95.63/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x3216C6CC /* 50.22.198.204/30 */, 30, NDPI_PROTOCOL_WHATSAPP },
  { 0x3216D280 /* 50.22.210.128/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0x3216D220 /* 50.22.210.32/30 */, 30, NDPI_PROTOCOL_WHATSAPP },
  { 0x3216E140 /* 50.22.225.64/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0x3216EBF8 /* 50.22.235.248/30 */, 30, NDPI_PROTOCOL_WHATSAPP },
  { 0x3216F0A0 /* 50.22.240.160/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0x32175A80 /* 50.23.90.128/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0x32613980 /* 50.97.57.128/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0x4B7E0C70 /* 75.126.12.112/28 */, 28, NDPI_PROTOCOL_WHATSAPP },
  { 0x4B7E7B40 /* 75.126.123.64/28 */, 28, NDPI_PROTOCOL_WHATSAPP },
  { 0x4B7E8AA0 /* 75.126.138.160/28 */, 28, NDPI_PROTOCOL_WHATSAPP },
  { 0x4B7E8D50 /* 75.126.141.80/28 */, 28, NDPI_PROTOCOL_WHATSAPP },
  { 0x4B7E1430 /* 75.126.20.48/28 */, 28, NDPI_PROTOCOL_WHATSAPP },
  { 0x4B7E2720 /* 75.126.39.32/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0x4B7E51C0 /* 75.126.81.192/28 */, 28, NDPI_PROTOCOL_WHATSAPP },
  { 0x66846036 /* 102.132.96.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x66846136 /* 102.132.97.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00D36 /* 157.240.13.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00E34 /* 157.240.14.52/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF01034 /* 157.240.16.52/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF01234 /* 157.240.18.52/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0C034 /* 157.240.192.52/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0C132 /* 157.240.193.50/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0C236 /* 157.240.194.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF01434 /* 157.240.20.52/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF01533 /* 157.240.21.51/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF01534 /* 157.240.21.52/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF01836 /* 157.240.24.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF01936 /* 157.240.25.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF01A36 /* 157.240.26.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF01B36 /* 157.240.27.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00336 /* 157.240.3.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF01E36 /* 157.240.30.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0xB33CC134 /* 179.60.193.52/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4238 /* 31.13.66.56/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4334 /* 31.13.67.52/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4934 /* 31.13.73.52/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4A34 /* 31.13.74.52/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4F35 /* 31.13.79.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  /* Files */
  { 0xB93CD835 /* 185.60.216.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP_FILES },
  { 0xB93CD836 /* 185.60.216.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP_FILES },
  { 0xB93CD935 /* 185.60.217.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP_FILES },
  { 0xB93CD936 /* 185.60.217.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP_FILES },
  { 0xB93CDA35 /* 185.60.218.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP_FILES },
  { 0xB93CDA36 /* 185.60.218.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP_FILES },
  { 0xB93CDB35 /* 185.60.219.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP_FILES },
  { 0xB93CDB36 /* 185.60.219.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP_FILES },

  /*
    WeChat
    origin AS132203, AS132591, AS45090
  */
  { 0xCBCD93AB /* 203.205.147.171/32 */, 32, NDPI_PROTOCOL_WECHAT },
  { 0xCBCD93AD /* 203.205.147.173/32 */, 32, NDPI_PROTOCOL_WECHAT },
  { 0xCBCD97A2 /* 203.205.151.162/32 */, 32, NDPI_PROTOCOL_WECHAT },
  { 0x67071E25 /* 103.7.30.37/32     */, 32, NDPI_PROTOCOL_WECHAT },
  { 0XCBCDB000 /* 203.205.176.0/20   */, 20, NDPI_PROTOCOL_WECHAT },
  { 0XCBCDC000 /* 203.205.192.0/18   */, 18, NDPI_PROTOCOL_WECHAT },

  /*
    OpenDNS, LLC
    origin AS36692, AS30607
  */

  { 0x26631400 /* 38.99.20.0/23 */, 23, NDPI_PROTOCOL_OPENDNS },
  { 0x3F504FC0 /* 63.80.79.192/26 */, 26, NDPI_PROTOCOL_OPENDNS },
  { 0x43D74000 /* 67.215.64.0/19 */, 19, NDPI_PROTOCOL_OPENDNS },
  { 0x92700000 /* 146.112.0.0/16 */, 16, NDPI_PROTOCOL_OPENDNS },
  { 0xB93C5400 /* 185.60.84.0/24 */, 24, NDPI_PROTOCOL_OPENDNS },
  { 0xB93C5500 /* 185.60.85.0/24 */, 24, NDPI_PROTOCOL_OPENDNS },
  { 0xB93C5600 /* 185.60.86.0/24 */, 24, NDPI_PROTOCOL_OPENDNS },
  { 0xB93C5700 /* 185.60.87.0/24 */, 24, NDPI_PROTOCOL_OPENDNS },
  { 0xCCC2E800 /* 204.194.232.0/21 */, 21, NDPI_PROTOCOL_OPENDNS },
  { 0xD043D800 /* 208.67.216.0/21 */, 21, NDPI_PROTOCOL_OPENDNS },
  { 0xD0452000 /* 208.69.32.0/21 */, 21, NDPI_PROTOCOL_OPENDNS },

  /*
    Microsoft Corporation (MS One Drive)
  */

  { 0xCC4FC300 /* 204.79.195.0/24 */, 24, NDPI_PROTOCOL_MS_ONE_DRIVE },
  { 0xCC4FC400 /* 204.79.196.0/23 */, 23, NDPI_PROTOCOL_MS_ONE_DRIVE },
  { 0x86AA0000 /* 134.170.0.0/16 */, 16, NDPI_PROTOCOL_MS_ONE_DRIVE },
  { 0x83FD0C00 /* 131.253.12.0/22 */, 22, NDPI_PROTOCOL_MS_ONE_DRIVE },
  { 0x83FD1000 /* 131.253.16.0/23 */, 23, NDPI_PROTOCOL_MS_ONE_DRIVE },
  { 0x83FD1200 /* 131.253.18.0/24 */, 24, NDPI_PROTOCOL_MS_ONE_DRIVE },
  { 0x4136BF00 /* 65.54.191.0/24 */, 24, NDPI_PROTOCOL_MS_ONE_DRIVE },

  /*
    Amazon.com, Inc. / Amazon Data Services Ireland Ltd
    origin AS16509, AS14618, AS7224, AS62785, AS8987
  */

  { 0x08129000 /* 8.18.144.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x08129100 /* 8.18.145.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x0D200000 /* 13.32.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x0D340000 /* 13.52.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x0D380000 /* 13.56.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x0D700000 /* 13.112.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x0D7C0000 /* 13.124.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x0DD00000 /* 13.208.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x0DE40000 /* 13.228.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x0DE80000 /* 13.232.0.0/13 */, 13, NDPI_PROTOCOL_AMAZON },
  { 0x0DF80000 /* 13.248.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x17140000 /* 23.20.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x1B000000 /* 27.0.0.0/22 */, 22, NDPI_PROTOCOL_AMAZON },
  { 0x22C00000 /* 34.192.0.0/10 */, 10, NDPI_PROTOCOL_AMAZON },
  { 0x23980000 /* 35.152.0.0/13 */, 13, NDPI_PROTOCOL_AMAZON },
  { 0x23B00000 /* 35.176.0.0/13 */, 13, NDPI_PROTOCOL_AMAZON },
  { 0x2BFAC000 /* 43.250.192.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x2BFAC100 /* 43.250.193.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x2E338000 /* 46.51.128.0/18 */, 18, NDPI_PROTOCOL_AMAZON },
  { 0x2E33C000 /* 46.51.192.0/20 */, 20, NDPI_PROTOCOL_AMAZON },
  { 0x2E33D800 /* 46.51.216.0/21 */, 21, NDPI_PROTOCOL_AMAZON },
  { 0x2E33E000 /* 46.51.224.0/19 */, 19, NDPI_PROTOCOL_AMAZON },
  { 0x2E890000 /* 46.137.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x2E898000 /* 46.137.128.0/18 */, 18, NDPI_PROTOCOL_AMAZON },
  { 0x2E89C000 /* 46.137.192.0/19 */, 19, NDPI_PROTOCOL_AMAZON },
  { 0x2E89E000 /* 46.137.224.0/19 */, 19, NDPI_PROTOCOL_AMAZON },
  { 0x32100000 /* 50.16.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x32700000 /* 50.112.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x34000000 /* 52.0.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x34020000 /* 52.2.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x34040000 /* 52.4.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x34080000 /* 52.8.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x34090000 /* 52.9.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x340A0000 /* 52.10.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x340C0000 /* 52.12.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x340E0000 /* 52.14.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x34100000 /* 52.16.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x34120000 /* 52.18.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x34140000 /* 52.20.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x34180000 /* 52.24.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x341C0000 /* 52.28.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x341D0000 /* 52.29.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x341E0000 /* 52.30.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x34200000 /* 52.32.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x34240000 /* 52.36.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x34280000 /* 52.40.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x342C0000 /* 52.44.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x342E0000 /* 52.46.0.0/18 */, 18, NDPI_PROTOCOL_AMAZON },
  { 0x342E5000 /* 52.46.80.0/21 */, 21, NDPI_PROTOCOL_AMAZON },
  { 0x342F0000 /* 52.47.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x34300000 /* 52.48.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x34340000 /* 52.52.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x34360000 /* 52.54.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x34380000 /* 52.56.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x34390000 /* 52.57.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x343A0000 /* 52.58.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x343C0000 /* 52.60.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x343E0000 /* 52.62.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x34400000 /* 52.64.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x34408000 /* 52.64.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x34410000 /* 52.65.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x34420000 /* 52.66.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x34430000 /* 52.67.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x34440000 /* 52.68.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x34460000 /* 52.70.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x34480000 /* 52.72.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x344A0000 /* 52.74.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x344C0000 /* 52.76.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x344C8000 /* 52.76.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x344D0000 /* 52.77.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x344E0000 /* 52.78.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x344F0000 /* 52.79.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x34520000 /* 52.82.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x34580000 /* 52.88.0.0/13 */, 13, NDPI_PROTOCOL_AMAZON },
  { 0x345A0000 /* 52.90.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x345F0000 /* 52.95.0.0/21 */, 21, NDPI_PROTOCOL_AMAZON },
  { 0x345F0A00 /* 52.95.10.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x345F0C00 /* 52.95.12.0/22 */, 22, NDPI_PROTOCOL_AMAZON },
  { 0x345F1000 /* 52.95.16.0/21 */, 21, NDPI_PROTOCOL_AMAZON },
  { 0x345F1800 /* 52.95.24.0/22 */, 22, NDPI_PROTOCOL_AMAZON },
  { 0x345F1E00 /* 52.95.30.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x345F2200 /* 52.95.34.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x345F2300 /* 52.95.35.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x345F2400 /* 52.95.36.0/22 */, 22, NDPI_PROTOCOL_AMAZON },
  { 0x345F3000 /* 52.95.48.0/22 */, 22, NDPI_PROTOCOL_AMAZON },
  { 0x345F3400 /* 52.95.52.0/22 */, 22, NDPI_PROTOCOL_AMAZON },
  { 0x345F3800 /* 52.95.56.0/22 */, 22, NDPI_PROTOCOL_AMAZON },
  { 0x345F4000 /* 52.95.64.0/20 */, 20, NDPI_PROTOCOL_AMAZON },
  { 0x345F5000 /* 52.95.80.0/20 */, 20, NDPI_PROTOCOL_AMAZON },
  { 0x345F6000 /* 52.95.96.0/22 */, 22, NDPI_PROTOCOL_AMAZON },
  { 0x345F6400 /* 52.95.100.0/22 */, 22, NDPI_PROTOCOL_AMAZON },
  { 0x345F6800 /* 52.95.104.0/22 */, 22, NDPI_PROTOCOL_AMAZON },
  { 0x345F6F00 /* 52.95.111.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x345F8000 /* 52.95.128.0/19 */, 19, NDPI_PROTOCOL_AMAZON },
  { 0x345FA000 /* 52.95.160.0/19 */, 19, NDPI_PROTOCOL_AMAZON },
  { 0x345FC000 /* 52.95.192.0/20 */, 20, NDPI_PROTOCOL_AMAZON },
  { 0x345FD400 /* 52.95.212.0/22 */, 22, NDPI_PROTOCOL_AMAZON },
  { 0x345FE000 /* 52.95.224.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x345FF000 /* 52.95.240.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x345FF100 /* 52.95.241.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x345FF200 /* 52.95.242.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x345FF300 /* 52.95.243.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x345FF400 /* 52.95.244.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x345FF500 /* 52.95.245.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x345FF600 /* 52.95.246.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x345FF700 /* 52.95.247.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x345FF800 /* 52.95.248.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x345FF900 /* 52.95.249.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x345FFA00 /* 52.95.250.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x345FFB00 /* 52.95.251.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x345FFC00 /* 52.95.252.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x345FFD00 /* 52.95.253.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x345FFE00 /* 52.95.254.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x34778000 /* 52.119.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x347C8000 /* 52.124.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x34818000 /* 52.129.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x34908000 /* 52.144.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x34C00000 /* 52.192.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x34C40000 /* 52.196.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x34C80000 /* 52.200.0.0/13 */, 13, NDPI_PROTOCOL_AMAZON },
  { 0x34D00000 /* 52.208.0.0/13 */, 13, NDPI_PROTOCOL_AMAZON },
  { 0x34D80000 /* 52.216.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x34DA0000 /* 52.218.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x34DA8000 /* 52.218.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x34DB0000 /* 52.219.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x34DB8000 /* 52.219.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x34DC0000 /* 52.220.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x34DE0000 /* 52.222.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x34DE8000 /* 52.222.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36400000 /* 54.64.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x36420000 /* 54.66.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36428000 /* 54.66.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36430000 /* 54.67.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36440000 /* 54.68.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x36460000 /* 54.70.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x36480000 /* 54.72.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x36490000 /* 54.73.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x364A0000 /* 54.74.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x364C0000 /* 54.76.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x364E0000 /* 54.78.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x364F0000 /* 54.79.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x364F8000 /* 54.79.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36500000 /* 54.80.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x36540000 /* 54.84.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x36560000 /* 54.86.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x36570000 /* 54.87.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x36580000 /* 54.88.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x36590000 /* 54.89.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x365A0000 /* 54.90.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x365C0000 /* 54.92.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x365C8000 /* 54.92.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x365D0000 /* 54.93.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x365E0000 /* 54.94.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x365E8000 /* 54.94.128.0/18 */, 18, NDPI_PROTOCOL_AMAZON },
  { 0x365EC000 /* 54.94.192.0/18 */, 18, NDPI_PROTOCOL_AMAZON },
  { 0x365F0000 /* 54.95.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x365F8000 /* 54.95.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36900000 /* 54.144.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x36940000 /* 54.148.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x36960000 /* 54.150.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x36970000 /* 54.151.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36978000 /* 54.151.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36980000 /* 54.152.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x36990000 /* 54.153.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36998000 /* 54.153.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x369A0000 /* 54.154.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x369B0000 /* 54.155.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x369C0000 /* 54.156.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x36A00000 /* 54.160.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x36A40000 /* 54.164.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x36A60000 /* 54.166.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x36A80000 /* 54.168.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x36A90000 /* 54.169.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36A98000 /* 54.169.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36AA0000 /* 54.170.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x36AB0000 /* 54.171.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x36AC0000 /* 54.172.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x36AE0000 /* 54.174.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x36B00000 /* 54.176.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x36B20000 /* 54.178.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36B28000 /* 54.178.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36B30000 /* 54.179.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36B38000 /* 54.179.128.0/18 */, 18, NDPI_PROTOCOL_AMAZON },
  { 0x36B3C000 /* 54.179.192.0/18 */, 18, NDPI_PROTOCOL_AMAZON },
  { 0x36B60000 /* 54.182.0.0/21 */, 21, NDPI_PROTOCOL_AMAZON },
  { 0x36B60800 /* 54.182.8.0/22 */, 22, NDPI_PROTOCOL_AMAZON },
  { 0x36B61000 /* 54.182.16.0/22 */, 22, NDPI_PROTOCOL_AMAZON },
  { 0x36B68000 /* 54.182.128.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B68200 /* 54.182.130.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B68400 /* 54.182.132.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B68600 /* 54.182.134.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B68800 /* 54.182.136.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B68A00 /* 54.182.138.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B68C00 /* 54.182.140.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B68E00 /* 54.182.142.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B69000 /* 54.182.144.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B69200 /* 54.182.146.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B69400 /* 54.182.148.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B69600 /* 54.182.150.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B69800 /* 54.182.152.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B69A00 /* 54.182.154.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B69C00 /* 54.182.156.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B69E00 /* 54.182.158.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B6A200 /* 54.182.162.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B6A400 /* 54.182.164.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B6A600 /* 54.182.166.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B6A800 /* 54.182.168.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B6AA00 /* 54.182.170.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6AE00 /* 54.182.174.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B6B000 /* 54.182.176.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B6B200 /* 54.182.178.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B6B400 /* 54.182.180.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B6B600 /* 54.182.182.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B6B800 /* 54.182.184.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B6BA00 /* 54.182.186.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B6BF00 /* 54.182.191.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6C000 /* 54.182.192.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6C100 /* 54.182.193.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6C200 /* 54.182.194.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6C300 /* 54.182.195.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6C400 /* 54.182.196.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6C500 /* 54.182.197.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6C600 /* 54.182.198.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6C700 /* 54.182.199.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6C800 /* 54.182.200.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6C900 /* 54.182.201.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6CA00 /* 54.182.202.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6CB00 /* 54.182.203.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6CC00 /* 54.182.204.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6CD00 /* 54.182.205.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6CE00 /* 54.182.206.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6CF00 /* 54.182.207.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6D100 /* 54.182.209.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6D200 /* 54.182.210.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6D300 /* 54.182.211.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6D400 /* 54.182.212.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6D500 /* 54.182.213.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6D600 /* 54.182.214.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6D700 /* 54.182.215.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6D800 /* 54.182.216.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6D900 /* 54.182.217.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6DA00 /* 54.182.218.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6DB00 /* 54.182.219.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6DC00 /* 54.182.220.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6DD00 /* 54.182.221.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6DE00 /* 54.182.222.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6DF00 /* 54.182.223.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6E000 /* 54.182.224.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B6E200 /* 54.182.226.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B6E400 /* 54.182.228.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B6E600 /* 54.182.230.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6E700 /* 54.182.231.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6E800 /* 54.182.232.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6E900 /* 54.182.233.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6EA00 /* 54.182.234.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6EB00 /* 54.182.235.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6EC00 /* 54.182.236.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6ED00 /* 54.182.237.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6EE00 /* 54.182.238.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6EF00 /* 54.182.239.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6F000 /* 54.182.240.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B6F200 /* 54.182.242.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6F300 /* 54.182.243.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6F400 /* 54.182.244.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6F500 /* 54.182.245.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6F600 /* 54.182.246.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B6F800 /* 54.182.248.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B6FA00 /* 54.182.250.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B6FC00 /* 54.182.252.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6FD00 /* 54.182.253.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6FE00 /* 54.182.254.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6FF00 /* 54.182.255.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B70000 /* 54.183.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36B78000 /* 54.183.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36B80000 /* 54.184.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x36BA0000 /* 54.186.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x36BC0000 /* 54.188.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x36BE0000 /* 54.190.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x36BF0000 /* 54.191.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x36C00000 /* 54.192.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x36C10000 /* 54.193.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36C18000 /* 54.193.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36C20000 /* 54.194.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x36C30000 /* 54.195.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x36C40000 /* 54.196.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x36C60000 /* 54.198.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x36C70000 /* 54.199.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36C78000 /* 54.199.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36C80000 /* 54.200.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x36CA0000 /* 54.202.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x36CC0000 /* 54.204.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x36CE0000 /* 54.206.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36CE8000 /* 54.206.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36CF0000 /* 54.207.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36CF8000 /* 54.207.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36D00000 /* 54.208.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x36D20000 /* 54.210.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x36D30000 /* 54.211.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x36D40000 /* 54.212.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x36D50000 /* 54.213.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x36D60000 /* 54.214.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36D68000 /* 54.214.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36D70000 /* 54.215.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36D78000 /* 54.215.128.0/18 */, 18, NDPI_PROTOCOL_AMAZON },
  { 0x36D7C000 /* 54.215.192.0/18 */, 18, NDPI_PROTOCOL_AMAZON },
  { 0x36D80000 /* 54.216.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x36DA0000 /* 54.218.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36DA8000 /* 54.218.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36DB0000 /* 54.219.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36DB8000 /* 54.219.128.0/18 */, 18, NDPI_PROTOCOL_AMAZON },
  { 0x36DBC000 /* 54.219.192.0/18 */, 18, NDPI_PROTOCOL_AMAZON },
  { 0x36DC0000 /* 54.220.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x36DD0000 /* 54.221.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x36DF2000 /* 54.223.32.0/19 */, 19, NDPI_PROTOCOL_AMAZON },
  { 0x36DF4000 /* 54.223.64.0/18 */, 18, NDPI_PROTOCOL_AMAZON },
  { 0x36E00000 /* 54.224.0.0/12 */, 12, NDPI_PROTOCOL_AMAZON },
  { 0x36F00000 /* 54.240.0.0/12 */, 12, NDPI_PROTOCOL_AMAZON },
  { 0x3F5C0C00 /* 63.92.12.0/22 */, 22, NDPI_PROTOCOL_AMAZON },
  { 0x3FEE0C00 /* 63.238.12.0/22 */, 22, NDPI_PROTOCOL_AMAZON },
  { 0x3FEE1000 /* 63.238.16.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x42074000 /* 66.7.64.0/19 */, 19, NDPI_PROTOCOL_AMAZON },
  { 0x43CA0000 /* 67.202.0.0/18 */, 18, NDPI_PROTOCOL_AMAZON },
  { 0x4815C000 /* 72.21.192.0/19 */, 19, NDPI_PROTOCOL_AMAZON },
  { 0x482C2000 /* 72.44.32.0/19 */, 19, NDPI_PROTOCOL_AMAZON },
  { 0x4B658000 /* 75.101.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x4F7D0000 /* 79.125.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x57EE5000 /* 87.238.80.0/21 */, 21, NDPI_PROTOCOL_AMAZON },
  { 0x607F0000 /* 96.127.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x67040800 /* 103.4.8.0/21 */, 21, NDPI_PROTOCOL_AMAZON },
  { 0x6708AC00 /* 103.8.172.0/22 */, 22, NDPI_PROTOCOL_AMAZON },
  { 0x67F69400 /* 103.246.148.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x67F69600 /* 103.246.150.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x6B140000 /* 107.20.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x7AF8C000 /* 122.248.192.0/18 */, 18, NDPI_PROTOCOL_AMAZON },
  { 0xAC606000 /* 172.96.96.0/20 */, 20, NDPI_PROTOCOL_AMAZON },
  { 0xAE810000 /* 174.129.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0xAF298000 /* 175.41.128.0/18 */, 18, NDPI_PROTOCOL_AMAZON },
  { 0xAF29C000 /* 175.41.192.0/18 */, 18, NDPI_PROTOCOL_AMAZON },
  { 0xB0204000 /* 176.32.64.0/19 */, 19, NDPI_PROTOCOL_AMAZON },
  { 0xB0206000 /* 176.32.96.0/21 */, 21, NDPI_PROTOCOL_AMAZON },
  { 0xB0206800 /* 176.32.104.0/21 */, 21, NDPI_PROTOCOL_AMAZON },
  { 0xB0207000 /* 176.32.112.0/21 */, 21, NDPI_PROTOCOL_AMAZON },
  { 0xB0207800 /* 176.32.120.0/22 */, 22, NDPI_PROTOCOL_AMAZON },
  { 0xB0207E00 /* 176.32.126.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0xB0220000 /* 176.34.0.0/19 */, 19, NDPI_PROTOCOL_AMAZON },
  { 0xB0222000 /* 176.34.32.0/19 */, 19, NDPI_PROTOCOL_AMAZON },
  { 0xB0224000 /* 176.34.64.0/18 */, 18, NDPI_PROTOCOL_AMAZON },
  { 0xB0228000 /* 176.34.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0xB1478000 /* 177.71.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0xB148F000 /* 177.72.240.0/21 */, 21, NDPI_PROTOCOL_AMAZON },
  { 0xB2EC0000 /* 178.236.0.0/20 */, 20, NDPI_PROTOCOL_AMAZON },
  { 0xB8480000 /* 184.72.0.0/18 */, 18, NDPI_PROTOCOL_AMAZON },
  { 0xB8484000 /* 184.72.64.0/19 */, 19, NDPI_PROTOCOL_AMAZON },
  { 0xB8486000 /* 184.72.96.0/19 */, 19, NDPI_PROTOCOL_AMAZON },
  { 0xB8488000 /* 184.72.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0xB8490000 /* 184.73.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0xB8A98000 /* 184.169.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0xB9307800 /* 185.48.120.0/22 */, 22, NDPI_PROTOCOL_AMAZON },
  { 0xB98F1000 /* 185.143.16.0/22 */, 22, NDPI_PROTOCOL_AMAZON },
  { 0xC77FE800 /* 199.127.232.0/22 */, 22, NDPI_PROTOCOL_AMAZON },
  { 0xC7FFC000 /* 199.255.192.0/22 */, 22, NDPI_PROTOCOL_AMAZON },
  { 0xCB53DC00 /* 203.83.220.0/22 */, 22, NDPI_PROTOCOL_AMAZON },
  { 0xCCEC8000 /* 204.236.128.0/18 */, 18, NDPI_PROTOCOL_AMAZON },
  { 0xCCECC000 /* 204.236.192.0/18 */, 18, NDPI_PROTOCOL_AMAZON },
  { 0xCCF6A000 /* 204.246.160.0/19 */, 19, NDPI_PROTOCOL_AMAZON },
  { 0xCDFBC000 /* 205.251.192.0/18 */, 18, NDPI_PROTOCOL_AMAZON },
  { 0xCFABA000 /* 207.171.160.0/19 */, 19, NDPI_PROTOCOL_AMAZON },
  { 0xD02FF800 /* 208.47.248.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0xD1C96000 /* 209.201.96.0/22 */, 22, NDPI_PROTOCOL_AMAZON },
  { 0xD8892000 /* 216.137.32.0/19 */, 19, NDPI_PROTOCOL_AMAZON },
  { 0xD8B6E000 /* 216.182.224.0/20 */, 20, NDPI_PROTOCOL_AMAZON },

  /*
    Netflix Inc. / Netflix Streaming Services Inc.
    origin AS2906, AS55095, AS40027
  */

  { 0x17F60000 /* 23.246.0.0/18 */, 18, NDPI_PROTOCOL_NETFLIX },
  { 0x254DB800 /* 37.77.184.0/21 */, 21, NDPI_PROTOCOL_NETFLIX },
  { 0x26487E00 /* 38.72.126.0/24 */, 24, NDPI_PROTOCOL_NETFLIX },
  { 0x2D390000 /* 45.57.0.0/17 */, 17, NDPI_PROTOCOL_NETFLIX },
  { 0x40788000 /* 64.120.128.0/17 */, 17, NDPI_PROTOCOL_NETFLIX },
  { 0x42C58000 /* 66.197.128.0/17 */, 17, NDPI_PROTOCOL_NETFLIX },
  { 0x4535E000 /* 69.53.224.0/19 */, 19, NDPI_PROTOCOL_NETFLIX },
  { 0x6CAF2000 /* 108.175.32.0/20 */, 20, NDPI_PROTOCOL_NETFLIX },
  { 0xB902DC00 /* 185.2.220.0/22 */, 22, NDPI_PROTOCOL_NETFLIX },
  { 0xB909BC00 /* 185.9.188.0/22 */, 22, NDPI_PROTOCOL_NETFLIX },
  { 0xC0AD4000 /* 192.173.64.0/18 */, 18, NDPI_PROTOCOL_NETFLIX },
  { 0xC6266000 /* 198.38.96.0/19 */, 19, NDPI_PROTOCOL_NETFLIX },
  { 0xC62D3000 /* 198.45.48.0/20 */, 20, NDPI_PROTOCOL_NETFLIX },
  { 0xD194D687 /* 209.148.214.135/21 */, 21, NDPI_PROTOCOL_NETFLIX },

  /*
    Cloudflare, Inc.
    origin AS13335, AS132892, AS203898, AS394536
  */

  { 0x321ff200 /* 50.31.242.0/23 */, 23, NDPI_PROTOCOL_CLOUDFLARE },
  { 0x6715f400 /* 103.21.244.0/22 */, 22, NDPI_PROTOCOL_CLOUDFLARE },
  { 0x6716c800 /* 103.22.200.0/22 */, 22, NDPI_PROTOCOL_CLOUDFLARE },
  { 0x671f0400 /* 103.31.4.0/22 */, 22, NDPI_PROTOCOL_CLOUDFLARE },
  { 0x68100000 /* 104.16.0.0/12 */, 12, NDPI_PROTOCOL_CLOUDFLARE },
  { 0x6CA2C000 /* 108.162.192.0/18 */, 18, NDPI_PROTOCOL_CLOUDFLARE },
  { 0x83004800 /* 131.0.72.0/22 */, 22, NDPI_PROTOCOL_CLOUDFLARE },
  { 0x8D654400 /* 141.101.68.0/24 */, 24, NDPI_PROTOCOL_CLOUDFLARE },
  { 0x8D654500 /* 141.101.69.0/24 */, 24, NDPI_PROTOCOL_CLOUDFLARE },
  { 0x8d656000 /* 141.101.96.0/21 */, 21, NDPI_PROTOCOL_CLOUDFLARE },
  { 0x8d654000 /* 141.101.64.0/20 */, 20, NDPI_PROTOCOL_CLOUDFLARE },
  { 0x8d655000 /* 141.101.80.0/21 */, 21, NDPI_PROTOCOL_CLOUDFLARE },
  { 0x8d655800 /* 141.101.88.0/19 */, 19, NDPI_PROTOCOL_CLOUDFLARE },
  { 0x8d656800 /* 141.101.104.0/21 */, 21, NDPI_PROTOCOL_CLOUDFLARE },
  { 0x8d657000 /* 141.101.112.0/21 */, 21, NDPI_PROTOCOL_CLOUDFLARE },
  { 0x8d657800 /* 141.101.120.0/22 */, 22, NDPI_PROTOCOL_CLOUDFLARE },
  { 0x8d657c00 /* 141.101.124.0/22 */, 22, NDPI_PROTOCOL_CLOUDFLARE },
  { 0xbe5df000 /* 190.93.240.0/20 */, 20, NDPI_PROTOCOL_CLOUDFLARE },
  { 0xA29E0000 /* 162.158.0.0/15 */, 15, NDPI_PROTOCOL_CLOUDFLARE },
  { 0xA2FB5200 /* 162.251.82.0/24 */, 24, NDPI_PROTOCOL_CLOUDFLARE },
  { 0xAC400000 /* 172.64.0.0/13 */, 13, NDPI_PROTOCOL_CLOUDFLARE },
  { 0xADF53000 /* 173.245.48.0/20 */, 20, NDPI_PROTOCOL_CLOUDFLARE },
  { 0xB97A0000 /* 185.122.0.0/22 */, 22, NDPI_PROTOCOL_CLOUDFLARE },
  { 0xBC726000 /* 188.114.96.0/22 */, 22, NDPI_PROTOCOL_CLOUDFLARE },
  { 0xBC726400 /* 188.114.100.0/22 */, 22, NDPI_PROTOCOL_CLOUDFLARE },
  { 0xBC726800 /* 188.114.104.0/24 */, 24, NDPI_PROTOCOL_CLOUDFLARE },
  { 0xBC726900 /* 188.114.105.0/24 */, 24, NDPI_PROTOCOL_CLOUDFLARE },
  { 0xBC726A00 /* 188.114.106.0/24 */, 24, NDPI_PROTOCOL_CLOUDFLARE },
  { 0xBC726B00 /* 188.114.107.0/24 */, 24, NDPI_PROTOCOL_CLOUDFLARE },
  { 0xBC726C00 /* 188.114.108.0/22 */, 22, NDPI_PROTOCOL_CLOUDFLARE },
  { 0xC6298000 /* 198.41.128.0/17 */, 17, NDPI_PROTOCOL_CLOUDFLARE },
  { 0xc5eaf000 /* 197.234.240.0/22 */, 22, NDPI_PROTOCOL_CLOUDFLARE },
  { 0xC71B8000 /* 199.27.128.0/21 */, 21, NDPI_PROTOCOL_CLOUDFLARE },

  /*
    OFFICE 365
  */

  { 0x0D6B0100 /* 13.107.1.0 */, 24 , NDPI_PROTOCOL_OFFICE_365 },
  { 0x0D6B0300 /* 13.107.3.0 */, 24 , NDPI_PROTOCOL_OFFICE_365 },
  { 0x0D6B0400 /* 13.107.4.0 */, 24 , NDPI_PROTOCOL_OFFICE_365 },
  { 0x0D6B0500 /* 13.107.5.0 */, 24 , NDPI_PROTOCOL_OFFICE_365 },
  { 0x0D6B0600 /* 13.107.6.0 */, 24 , NDPI_PROTOCOL_OFFICE_365 },
  { 0x0D6B0700 /* 13.107.7.0 */, 24 , NDPI_PROTOCOL_OFFICE_365 },
  { 0x0D6B0900 /* 13.107.9.0 */, 24 , NDPI_PROTOCOL_OFFICE_365 },
  { 0x0D6B0C00 /* 13.107.12.0 */, 24 , NDPI_PROTOCOL_OFFICE_365 },
  { 0x0D6B0D00 /* 13.107.13.0 */, 24 , NDPI_PROTOCOL_OFFICE_365 },
  { 0x0D6B0F00 /* 13.107.15.0 */, 24 , NDPI_PROTOCOL_OFFICE_365 },
  { 0x0D6B1000 /* 13.107.16.0 */, 24 , NDPI_PROTOCOL_OFFICE_365 },

  /*
    OCS GO (Orange Cinéma Séries)
  */

  { 0xB2F8D000 /* 178.248.208.0 */, 21, NDPI_PROTOCOL_OCS },


  /* Teamviewer 159.122.189.32-63 */
  { 0x9F7ABD30 /* 159.122.189.32 */, 21, NDPI_PROTOCOL_TEAMVIEWER },

#if 0
  /*
    IFLIX services -by www.vizuamatix.com R&D team
  */
  { 0x344D0000 /* 52.77.0.0 */, 16, NDPI_PROTOCOL_IFLIX },
  { 0x34DC0000 /* 52.220.0.0 */, 16, NDPI_PROTOCOL_IFLIX },
  { 0x344A0000 /* 52.74.0.0 */, 16, NDPI_PROTOCOL_IFLIX },
  { 0x36E69F00 /* 54.230.159.0 */, 24, NDPI_PROTOCOL_IFLIX },
  { 0x36C09C50 /* 54.192.156.80  */, 32, NDPI_PROTOCOL_IFLIX },
  { 0x36FBB6A8 /* 54.251.182.168  */, 32, NDPI_PROTOCOL_IFLIX },
  { 0x36C09600 /* 54.192.150.0  */, 24, NDPI_PROTOCOL_IFLIX },
  { 0x344AC0F7 /* 52.74.192.247  */, 32, NDPI_PROTOCOL_IFLIX },
  { 0x0215E718 /* 2.21.231.24 */, 32, NDPI_PROTOCOL_IFLIX },
#endif

  /*
    Citrix GotoMeeting (AS16815, AS21866)
  */

  { 0xD873D000 /* 216.115.208.0 */, 20, NDPI_PROTOCOL_CITRIX },
  { 0xD8DB7000 /* 216.219.112.0 */, 20, NDPI_PROTOCOL_CITRIX },

  /*
    Cisco Webex LLC
    origin AS13445
  */

  { 0x0819C000 /* 8.25.192.0/24 */, 24, NDPI_PROTOCOL_WEBEX },
  { 0x3E6DC000 /* 62.109.192.0/18 */, 18, NDPI_PROTOCOL_WEBEX },
  { 0x40446000 /* 64.68.96.0/19 */, 19, NDPI_PROTOCOL_WEBEX },
  { 0x4272A000 /* 66.114.160.0/20 */, 20, NDPI_PROTOCOL_WEBEX },
  { 0x42A32000 /* 66.163.32.0/19 */, 19, NDPI_PROTOCOL_WEBEX },
  { 0x721DC000 /* 114.29.192.0/19 */, 19, NDPI_PROTOCOL_WEBEX },
  { 0xADF30000 /* 173.243.0.0/20 */, 20, NDPI_PROTOCOL_WEBEX },
  { 0xCFB6A000 /* 207.182.160.0/19 */, 19, NDPI_PROTOCOL_WEBEX },
  { 0xD0085100 /* 208.8.81.0/24 */, 24, NDPI_PROTOCOL_WEBEX },
  { 0xD1C5C000 /* 209.197.192.0/19 */, 19, NDPI_PROTOCOL_WEBEX },
  { 0xD204C000 /* 210.4.192.0/20 */, 20, NDPI_PROTOCOL_WEBEX },

  /*
    Viber Media S.à r.l.
    https://whois.arin.net/rest/nets;q=AWS-VIBER-MEDIA?showDetails=true&showARIN=false&showNonArinTopLevelNet=false&ext=netref2
  */

  { 0x0DE61550 /* 13.230.21.80/28 */, 28, NDPI_PROTOCOL_VIBER },
  { 0x0D39B480 /* 13.57.180.128/28 */, 28, NDPI_PROTOCOL_VIBER },
  { 0x012C30400 /* 18.195.4.0/23 */, 23, NDPI_PROTOCOL_VIBER },
  { 0x012C45500 /* 18.196.85.0/25 */, 25, NDPI_PROTOCOL_VIBER },
  { 0x022E8A340 /* 34.232.163.64/28 */, 28, NDPI_PROTOCOL_VIBER },
  { 0x022F67200 /* 34.246.114.0/23 */, 23, NDPI_PROTOCOL_VIBER },
  { 0x3400FC00 /* 52.0.252.0/22 */, 22, NDPI_PROTOCOL_VIBER },
  { 0x3403A746 /* 52.3.167.70/32 */, 32, NDPI_PROTOCOL_VIBER },
  { 0x34162CEB /* 52.22.44.235/32 */, 32, NDPI_PROTOCOL_VIBER },
  { 0x34165F0F /* 52.22.95.15/32 */, 32, NDPI_PROTOCOL_VIBER },
  { 0x3640BFF0 /* 54.64.191.240/28 */, 28, NDPI_PROTOCOL_VIBER },
  { 0x3655545D /* 54.85.84.93/32 */, 32, NDPI_PROTOCOL_VIBER },
  { 0x3655565D /* 54.85.86.93/32 */, 32, NDPI_PROTOCOL_VIBER },
  { 0x36A5FFD0 /* 54.165.255.208/28 */, 28, NDPI_PROTOCOL_VIBER },
  { 0x36A5FFE0 /* 54.165.255.224/27 */, 27, NDPI_PROTOCOL_VIBER },
  { 0x36DBBFA0 /* 54.219.191.160/28 */, 28, NDPI_PROTOCOL_VIBER },
  { 0x36E8FB90 /* 54.232.251.144/28 */, 28, NDPI_PROTOCOL_VIBER },

  /*
    Apple Inc.
    origin AS714, AS6185
  */

  { 0x11000000 /* 17.0.0.0/8 */, 8, NDPI_PROTOCOL_APPLE },
  { 0xC0233200 /* 192.35.50.0/24 */, 24, NDPI_PROTOCOL_APPLE },
  { 0xC6B71000 /* 198.183.16.0/24 */, 24, NDPI_PROTOCOL_APPLE },
  { 0xC6B71100 /* 198.183.17.0/24 */, 24, NDPI_PROTOCOL_APPLE },
  { 0xCDB4AF00 /* 205.180.175.0/24 */, 24, NDPI_PROTOCOL_APPLE },

  /*
    Dropbox, Inc.
    origin AS19679
  */

  { 0x2D3A4000 /* 45.58.64.0/20 */, 20, NDPI_PROTOCOL_DROPBOX },
  { 0x6CA0A000 /* 108.160.160.0/20 */, 20, NDPI_PROTOCOL_DROPBOX },
  { 0xA27D0000 /* 162.125.0.0/16 */, 16, NDPI_PROTOCOL_DROPBOX },
  { 0xB92D0800 /* 185.45.8.0/22 */, 22, NDPI_PROTOCOL_DROPBOX },
  { 0xC72FD800 /* 199.47.216.0/22 */, 22, NDPI_PROTOCOL_DROPBOX },

  /*
    Skype (Microsoft CDN)
  */
  { 0x9D388740 /* 157.56.135.64 */, 26, NDPI_PROTOCOL_SKYPE },
  { 0x9D38B900 /* 157.56.185.0 */, 26, NDPI_PROTOCOL_SKYPE },
  { 0x9D383400 /* 157.56.52.0 */, 26, NDPI_PROTOCOL_SKYPE },
  { 0x9D383580 /* 157.56.53.128 */, 25, NDPI_PROTOCOL_SKYPE },
  { 0x9D38C600 /* 157.56.198.0 */, 26, NDPI_PROTOCOL_SKYPE },
  { 0x9D3C0000 /* 157.60.0.0 */, 16, NDPI_PROTOCOL_SKYPE },
  { 0x9D360000 /* 157.54.0.0 */, 15, NDPI_PROTOCOL_SKYPE },
  { 0x0D400000 /* 13.64.0.0 */, 11, NDPI_PROTOCOL_SKYPE },
  { 0x0D6B0380 /* 13.107.3.128 */, 32, NDPI_PROTOCOL_SKYPE },
  { 0x0D6B0381 /* 13.107.3.129 */, 32, NDPI_PROTOCOL_SKYPE },
  { 0x6FDD4000 /* 111.221.64.0 */, 18, NDPI_PROTOCOL_SKYPE },
  { 0x5BBED800 /* 91.190.216.0 */, 21, NDPI_PROTOCOL_SKYPE },
  { 0x5BBEDA00 /* 91.190.218.0 */, 24, NDPI_PROTOCOL_SKYPE },
  { 0x287F816D /* 40.126.129.109 */, 32, NDPI_PROTOCOL_SKYPE },
  { 0x4237DF00 /* 65.55.223.0 */, 26, NDPI_PROTOCOL_SKYPE },
  { 0x17600000 /* 23.96.0.0 */, 13, NDPI_PROTOCOL_SKYPE },
  { 0x34724A05 /* 52.114.74.5 */, 32, NDPI_PROTOCOL_SKYPE },

  /*
    Blizzard Entertainment, Inc
    origin AS57976
  */

  { 0x052AA000 /* 5.42.160.0/19 */, 19, NDPI_PROTOCOL_STARCRAFT },
  { 0x0C81DE00 /* 12.129.222.0/23 */, 23, NDPI_PROTOCOL_STARCRAFT },
  { 0x0C81E400 /* 12.129.228.0/23 */, 23, NDPI_PROTOCOL_STARCRAFT },
  { 0x0C81EC00 /* 12.129.236.0/23 */, 23, NDPI_PROTOCOL_STARCRAFT },
  { 0x0C81FE00 /* 12.129.254.0/23 */, 23, NDPI_PROTOCOL_STARCRAFT },
  { 0x0C82F400 /* 12.130.244.0/22 */, 22, NDPI_PROTOCOL_STARCRAFT },
  { 0x18690000 /* 24.105.0.0/18 */, 18, NDPI_PROTOCOL_STARCRAFT },
  { 0x25F40000 /* 37.244.0.0/18 */, 18, NDPI_PROTOCOL_STARCRAFT },
  { 0x3B992800 /* 59.153.40.0/22 */, 22, NDPI_PROTOCOL_STARCRAFT },
  { 0x3E73F400 /* 62.115.244.0/22 */, 22, NDPI_PROTOCOL_STARCRAFT },
  { 0x50EFD000 /* 80.239.208.0/22 */, 22, NDPI_PROTOCOL_STARCRAFT },
  { 0x67047200 /* 103.4.114.0/23 */, 23, NDPI_PROTOCOL_STARCRAFT },
  { 0x67C62000 /* 103.198.32.0/23 */, 23, NDPI_PROTOCOL_STARCRAFT },
  { 0x89DD4000 /* 137.221.64.0/18 */, 18, NDPI_PROTOCOL_STARCRAFT },
  { 0xB93C7000 /* 185.60.112.0/22 */, 22, NDPI_PROTOCOL_STARCRAFT },
  { 0xC30CF400 /* 195.12.244.0/22 */, 22, NDPI_PROTOCOL_STARCRAFT },
  { 0xC76C2000 /* 199.108.32.0/20 */, 20, NDPI_PROTOCOL_STARCRAFT },
  { 0xC76C3000 /* 199.108.48.0/20 */, 20, NDPI_PROTOCOL_STARCRAFT },
  { 0xCA094200 /* 202.9.66.0/23 */, 23, NDPI_PROTOCOL_STARCRAFT },

  /*
    Google Inc. / Google Switzerland GmbH / Google Ireland Limited
    origin AS15169, AS36384, AS41264, AS43515, AS36039, AS36040, AS36492
  */
  { 0x08063000 /* 8.6.48.0/21 */, 21, NDPI_PROTOCOL_GOOGLE },
  { 0x08080400 /* 8.8.4.0/24 */, 24, NDPI_PROTOCOL_GOOGLE },
  { 0x08080800 /* 8.8.8.0/24 */, 24, NDPI_PROTOCOL_GOOGLE },
  { 0x080FCA00 /* 8.15.202.0/24 */, 24, NDPI_PROTOCOL_GOOGLE },
  { 0x0822D000 /* 8.34.208.0/21 */, 21, NDPI_PROTOCOL_GOOGLE },
  { 0x0822D800 /* 8.34.216.0/21 */, 21, NDPI_PROTOCOL_GOOGLE },
  { 0x0823C000 /* 8.35.192.0/21 */, 21, NDPI_PROTOCOL_GOOGLE },
  { 0x0823C800 /* 8.35.200.0/21 */, 21, NDPI_PROTOCOL_GOOGLE },
  { 0x17EC3000 /* 23.236.48.0/20 */, 20, NDPI_PROTOCOL_GOOGLE },
  { 0x17FB8000 /* 23.251.128.0/19 */, 19, NDPI_PROTOCOL_GOOGLE },
  { 0x23B80000 /* 35.184.0.0/13 */, 13, NDPI_PROTOCOL_GOOGLE },
  { 0x2D79E400 /* 45.121.228.0/24 */, 24, NDPI_PROTOCOL_GOOGLE },
  { 0x2D79E500 /* 45.121.229.0/24 */, 24, NDPI_PROTOCOL_GOOGLE },
  { 0x2D79E600 /* 45.121.230.0/23 */, 23, NDPI_PROTOCOL_GOOGLE },
  { 0x2E1CF700 /* 46.28.247.0/24 */, 24, NDPI_PROTOCOL_GOOGLE },
  { 0x4009E000 /* 64.9.224.0/19 */, 19, NDPI_PROTOCOL_GOOGLE },
  { 0x400F7000 /* 64.15.112.0/20 */, 20, NDPI_PROTOCOL_GOOGLE },
  { 0x40E9A000 /* 64.233.160.0/19 */, 19, NDPI_PROTOCOL_GOOGLE },
  { 0x42660000 /* 66.102.0.0/20 */, 20, NDPI_PROTOCOL_GOOGLE },
  { 0x42F94000 /* 66.249.64.0/19 */, 19, NDPI_PROTOCOL_GOOGLE },
  { 0x46208000 /* 70.32.128.0/19 */, 19, NDPI_PROTOCOL_GOOGLE },
  { 0x480EC000 /* 72.14.192.0/18 */, 18, NDPI_PROTOCOL_GOOGLE },
  { 0x4A721800 /* 74.114.24.0/21 */, 21, NDPI_PROTOCOL_GOOGLE },
  { 0x4A7D0000 /* 74.125.0.0/16 */, 16, NDPI_PROTOCOL_GOOGLE },
  { 0x59CFE000 /* 89.207.224.0/21 */, 21, NDPI_PROTOCOL_GOOGLE },
  { 0x673E4000 /* 103.62.64.0/24 */, 24, NDPI_PROTOCOL_GOOGLE },
  { 0x673E4100 /* 103.62.65.0/24 */, 24, NDPI_PROTOCOL_GOOGLE },
  { 0x673E4200 /* 103.62.66.0/23 */, 23, NDPI_PROTOCOL_GOOGLE },
  { 0x68840000 /* 104.132.0.0/14 */, 14, NDPI_PROTOCOL_GOOGLE },
  { 0x689A0000 /* 104.154.0.0/15 */, 15, NDPI_PROTOCOL_GOOGLE },
  { 0x68C40000 /* 104.196.0.0/14 */, 14, NDPI_PROTOCOL_GOOGLE },
  { 0x68EDA000 /* 104.237.160.0/19 */, 19, NDPI_PROTOCOL_GOOGLE },
  { 0x6BA7A000 /* 107.167.160.0/19 */, 19, NDPI_PROTOCOL_GOOGLE },
  { 0x6BB2C000 /* 107.178.192.0/18 */, 18, NDPI_PROTOCOL_GOOGLE },
  { 0x6C3B5000 /* 108.59.80.0/20 */, 20, NDPI_PROTOCOL_GOOGLE },
  { 0x6CAAC000 /* 108.170.192.0/18 */, 18, NDPI_PROTOCOL_GOOGLE },
  { 0x6CB10000 /* 108.177.0.0/17 */, 17, NDPI_PROTOCOL_GOOGLE },
  { 0x71C56800 /* 113.197.104.0/22 */, 22, NDPI_PROTOCOL_GOOGLE },
  { 0x82D30000 /* 130.211.0.0/16 */, 16, NDPI_PROTOCOL_GOOGLE },
  { 0x8EFA0000 /* 142.250.0.0/15 */, 15, NDPI_PROTOCOL_GOOGLE },
  { 0x92940000 /* 146.148.0.0/17 */, 17, NDPI_PROTOCOL_GOOGLE },
  { 0xA2D89400 /* 162.216.148.0/22 */, 22, NDPI_PROTOCOL_GOOGLE },
  { 0xA2DEB000 /* 162.222.176.0/21 */, 21, NDPI_PROTOCOL_GOOGLE },
  { 0xAC660800 /* 172.102.8.0/21 */, 21, NDPI_PROTOCOL_GOOGLE },
  { 0xAC6E2000 /* 172.110.32.0/21 */, 21, NDPI_PROTOCOL_GOOGLE },
  { 0xACD90000 /* 172.217.0.0/16 */, 16, NDPI_PROTOCOL_GOOGLE },
  { 0xACFD0000 /* 172.253.0.0/16 */, 16, NDPI_PROTOCOL_GOOGLE },
  { 0xADC20000 /* 173.194.0.0/16 */, 16, NDPI_PROTOCOL_GOOGLE },
  { 0xADFF7000 /* 173.255.112.0/20 */, 20, NDPI_PROTOCOL_GOOGLE },
  { 0xB9191C00 /* 185.25.28.0/22 */, 22, NDPI_PROTOCOL_GOOGLE },
  { 0xB9969400 /* 185.150.148.0/22 */, 22, NDPI_PROTOCOL_GOOGLE },
  { 0xC068A000 /* 192.104.160.0/23 */, 23, NDPI_PROTOCOL_GOOGLE },
  { 0xC0771C00 /* 192.119.28.0/24 */, 24, NDPI_PROTOCOL_GOOGLE },
  { 0xC09E1C00 /* 192.158.28.0/22 */, 22, NDPI_PROTOCOL_GOOGLE },
  { 0xC0B20000 /* 192.178.0.0/15 */, 15, NDPI_PROTOCOL_GOOGLE },
  { 0xC1210400 /* 193.33.4.0/24 */, 24, NDPI_PROTOCOL_GOOGLE },
  { 0xC1210500 /* 193.33.5.0/24 */, 24, NDPI_PROTOCOL_GOOGLE },
  { 0xC1C8DE00 /* 193.200.222.0/24 */, 24, NDPI_PROTOCOL_GOOGLE },
  { 0xC27A5000 /* 194.122.80.0/22 */, 22, NDPI_PROTOCOL_GOOGLE },
  { 0xC7C07000 /* 199.192.112.0/22 */, 22, NDPI_PROTOCOL_GOOGLE },
  { 0xC7DFE800 /* 199.223.232.0/21 */, 21, NDPI_PROTOCOL_GOOGLE },
  { 0xCFDFA000 /* 207.223.160.0/20 */, 20, NDPI_PROTOCOL_GOOGLE },
  { 0xD0419800 /* 208.65.152.0/22 */, 22, NDPI_PROTOCOL_GOOGLE },
  { 0xD075E000 /* 208.117.224.0/19 */, 19, NDPI_PROTOCOL_GOOGLE },
  { 0xD1558000 /* 209.85.128.0/17 */, 17, NDPI_PROTOCOL_GOOGLE },
  { 0xD16BB000 /* 209.107.176.0/20 */, 20, NDPI_PROTOCOL_GOOGLE },
  { 0xD83AC000 /* 216.58.192.0/19 */, 19, NDPI_PROTOCOL_GOOGLE },
  { 0xD8495000 /* 216.73.80.0/20 */, 20, NDPI_PROTOCOL_GOOGLE },
  { 0xD8EF2000 /* 216.239.32.0/19 */, 19, NDPI_PROTOCOL_GOOGLE },
  { 0xD8FCDC00 /* 216.252.220.0/22 */, 22, NDPI_PROTOCOL_GOOGLE },

  /*
    Canonical Ltd (Ubuntu)
    origin AS41231z
  */

  { 0x5BBD5800 /* 91.189.88.0/21 */,   21, NDPI_PROTOCOL_UBUNTUONE },
  { 0xA2D52000 /* 162.213.32.0/22 */,  22, NDPI_PROTOCOL_UBUNTUONE },
  { 0xB97DBC00 /* 185.125.188.0/22 */, 22, NDPI_PROTOCOL_UBUNTUONE },

  /*
    Telegram Messenger LLP
    origin: AS62041, AS62014, AS59930
  */

  { 0x5B6C0400 /* 91.108.4.0/22 */, 22, NDPI_PROTOCOL_TELEGRAM },
  { 0x5B6C0800 /* 91.108.8.0/22 */, 22, NDPI_PROTOCOL_TELEGRAM },
  { 0x5B6C0C00 /* 91.108.12.0/22 */, 22, NDPI_PROTOCOL_TELEGRAM },
  { 0x5B6C1000 /* 91.108.16.0/22 */, 22, NDPI_PROTOCOL_TELEGRAM },
  { 0x5B6C1400 /* 91.108.20.0/22 */, 22, NDPI_PROTOCOL_TELEGRAM },
  { 0x5B6C3800 /* 91.108.56.0/22 */, 22, NDPI_PROTOCOL_TELEGRAM },
  { 0x959AA000 /* 149.154.160.0/20 */, 20, NDPI_PROTOCOL_TELEGRAM },

  /*
    BitTorrent
  */

  { 0xB9381424 /* 185.56.20.36/32 */, 32, NDPI_PROTOCOL_BITTORRENT },
  { 0xC0DEED0A /* 192.222.237.10/32 */, 32, NDPI_PROTOCOL_BITTORRENT },
  { 0x4DDEAE14 /* 77.222.174.20/32 */, 32, NDPI_PROTOCOL_BITTORRENT },
  { 0x25779CBD /* 37.119.156.189/32 */, 32, NDPI_PROTOCOL_BITTORRENT },
  { 0x05277C26 /* 5.39.124.38/32 */, 32, NDPI_PROTOCOL_BITTORRENT },
  { 0x4FC0AB43 /* 79.192.171.67/32 */, 32, NDPI_PROTOCOL_BITTORRENT },
  { 0xAC100010 /* 172.16.0.16/32 */, 32, NDPI_PROTOCOL_BITTORRENT },
  { 0xB2A4F550 /* 178.164.245.80/32 */, 32, NDPI_PROTOCOL_BITTORRENT },
  { 0xAE597B3E /* 174.89.123.62/32 */, 32, NDPI_PROTOCOL_BITTORRENT },

  /*
    Tor
    http://torstatus.blutmagie.de/ip_list_all.php/Tor_ip_list_ALL.csv
    From 02/17/2017
  */

  { 0x0122A339 /* 1.34.163.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x01EA0B8E /* 1.234.11.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x01F4E33D /* 1.244.227.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x02054D8A /* 2.5.77.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x020A43F9 /* 2.10.67.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0246CA2B /* 2.70.202.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x02565C41 /* 2.86.92.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x025C99E8 /* 2.92.153.232/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x025D0968 /* 2.93.9.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x025D1792 /* 2.93.23.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x025DCAEB /* 2.93.202.235/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x026C835B /* 2.108.131.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x026E3C44 /* 2.110.60.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x026EDB2F /* 2.110.219.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x026F5E2C /* 2.111.94.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x029B4710 /* 2.155.71.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x02E18D86 /* 2.225.141.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x02E1E75C /* 2.225.231.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x02E58252 /* 2.229.130.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x02E6A4FE /* 2.230.164.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x02EC0943 /* 2.236.9.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x02EC351D /* 2.236.53.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x02EE4464 /* 2.238.68.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x02F0439C /* 2.240.67.156/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x02F0561B /* 2.240.86.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x02F22990 /* 2.242.41.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x02F2529C /* 2.242.82.156/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x02F2AE32 /* 2.242.174.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x02F593C1 /* 2.245.147.193/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x041F4046 /* 4.31.64.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05015D72 /* 5.1.93.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05023698 /* 5.2.54.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x050240D1 /* 5.2.64.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0502481A /* 5.2.72.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x050249D9 /* 5.2.73.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05024A53 /* 5.2.74.83/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05080802 /* 5.8.8.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05090782 /* 5.9.7.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x050907FC /* 5.9.7.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05090C1D /* 5.9.12.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0509208F /* 5.9.32.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05092771 /* 5.9.39.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05092B03 /* 5.9.43.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05093254 /* 5.9.50.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05093A89 /* 5.9.58.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05093DCF /* 5.9.61.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05093E11 /* 5.9.62.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05093E49 /* 5.9.62.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x050948E9 /* 5.9.72.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05094906 /* 5.9.73.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05094A3B /* 5.9.74.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05094F06 /* 5.9.79.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05094F9A /* 5.9.79.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05095129 /* 5.9.81.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x050953CC /* 5.9.83.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0509584A /* 5.9.88.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0509622B /* 5.9.98.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x050966C6 /* 5.9.102.198/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05096C58 /* 5.9.108.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05096EEC /* 5.9.110.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0509794F /* 5.9.121.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x050979CF /* 5.9.121.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x050981DA /* 5.9.129.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05098C02 /* 5.9.140.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x050992CB /* 5.9.146.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x050993E2 /* 5.9.147.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05099564 /* 5.9.149.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05099628 /* 5.9.150.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x050997F1 /* 5.9.151.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05099972 /* 5.9.153.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05099C11 /* 5.9.156.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05099E4B /* 5.9.158.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05099F0E /* 5.9.159.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0509AB26 /* 5.9.171.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0509BCBA /* 5.9.188.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0509BF34 /* 5.9.191.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0509C56A /* 5.9.197.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0509D4CC /* 5.9.212.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0509FDEA /* 5.9.253.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x050C14C2 /* 5.12.20.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x050F53EA /* 5.15.83.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0513A267 /* 5.19.162.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0513B3FD /* 5.19.179.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0513B825 /* 5.19.184.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x051C3E55 /* 5.28.62.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0522B45E /* 5.34.180.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0522B71A /* 5.34.183.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0522B781 /* 5.34.183.129/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0522B7CD /* 5.34.183.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0522B7D2 /* 5.34.183.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0523FBF7 /* 5.35.251.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x052721B0 /* 5.39.33.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x052721B2 /* 5.39.33.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05274007 /* 5.39.64.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05274DD0 /* 5.39.77.208/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05274E65 /* 5.39.78.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0527501C /* 5.39.80.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05275087 /* 5.39.80.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05275166 /* 5.39.81.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05275199 /* 5.39.81.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x052752C0 /* 5.39.82.192/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0527531B /* 5.39.83.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x052753D9 /* 5.39.83.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x052754D9 /* 5.39.84.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x052756CE /* 5.39.86.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05275835 /* 5.39.88.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05275836 /* 5.39.88.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0527597C /* 5.39.89.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05275CC7 /* 5.39.92.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05275E3C /* 5.39.94.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05275EA9 /* 5.39.94.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05275F8E /* 5.39.95.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05277C60 /* 5.39.124.96/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0527D90E /* 5.39.217.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x052C65BE /* 5.44.101.190/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x052D617F /* 5.45.97.127/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x052D626F /* 5.45.98.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x052D6416 /* 5.45.100.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x052D6B38 /* 5.45.107.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x052D6C30 /* 5.45.108.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x052D6D3E /* 5.45.109.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05313BF0 /* 5.49.59.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0531DE9D /* 5.49.222.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05336A6C /* 5.51.106.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0533CCF1 /* 5.51.204.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0533DC1E /* 5.51.220.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0533E534 /* 5.51.229.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0538203C /* 5.56.32.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05388513 /* 5.56.133.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x053D223F /* 5.61.34.63/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x053DEF22 /* 5.61.239.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x054D2F8E /* 5.77.47.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x054F44A1 /* 5.79.68.161/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x054F5482 /* 5.79.84.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x054F560F /* 5.79.86.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0550EAA9 /* 5.80.234.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0564FD98 /* 5.100.253.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0564FD99 /* 5.100.253.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05656652 /* 5.101.102.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05656746 /* 5.101.103.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05673A1E /* 5.103.58.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05685A1D /* 5.104.90.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05686A26 /* 5.104.106.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0581FAAD /* 5.129.250.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05871525 /* 5.135.21.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05874191 /* 5.135.65.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05877322 /* 5.135.115.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05879842 /* 5.135.152.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0587988F /* 5.135.152.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05879B79 /* 5.135.155.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05879E65 /* 5.135.158.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05879F6E /* 5.135.159.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05879F80 /* 5.135.159.128/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0587A231 /* 5.135.162.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0587A2D9 /* 5.135.162.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0587A34E /* 5.135.163.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0587B2B8 /* 5.135.178.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0587B5D0 /* 5.135.181.208/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0587B5D5 /* 5.135.181.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0587B682 /* 5.135.182.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0587B818 /* 5.135.184.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0587B991 /* 5.135.185.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0587BA49 /* 5.135.186.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0587BACD /* 5.135.186.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0587BBC0 /* 5.135.187.192/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0587BF33 /* 5.135.191.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0587C70D /* 5.135.199.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x058D09A4 /* 5.141.9.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05912EA6 /* 5.145.46.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05926255 /* 5.146.98.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05928E81 /* 5.146.142.129/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x059290E8 /* 5.146.144.232/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05930775 /* 5.147.7.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0593C4FC /* 5.147.196.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0593F89E /* 5.147.248.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0594A50D /* 5.148.165.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0594AF23 /* 5.148.175.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0594B430 /* 5.148.180.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0595FA33 /* 5.149.250.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0596CCB0 /* 5.150.204.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0596CCEF /* 5.150.204.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0596DD89 /* 5.150.221.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x059ABFAD /* 5.154.191.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05A4CC92 /* 5.164.204.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05A79A71 /* 5.167.154.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05BD357B /* 5.189.53.123/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05BD59E9 /* 5.189.89.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05BD844F /* 5.189.132.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05BD85F5 /* 5.189.133.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05BD8A09 /* 5.189.138.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05BD8C15 /* 5.189.140.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05BD8E76 /* 5.189.142.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05BD8F1C /* 5.189.143.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05BD8FA9 /* 5.189.143.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05BD9285 /* 5.189.146.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05BD995B /* 5.189.153.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05BD99B9 /* 5.189.153.185/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05BD9DE6 /* 5.189.157.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05BD9F15 /* 5.189.159.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05BDA4E6 /* 5.189.164.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05BDAF34 /* 5.189.175.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05BDB3A4 /* 5.189.179.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05BDB53D /* 5.189.181.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05BDB62D /* 5.189.182.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05BDB83D /* 5.189.184.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05BDBC6F /* 5.189.188.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05C40181 /* 5.196.1.129/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05C40C4F /* 5.196.12.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05C40E33 /* 5.196.14.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05C41740 /* 5.196.23.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05C42416 /* 5.196.36.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05C43A60 /* 5.196.58.96/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05C441AD /* 5.196.65.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05C442A2 /* 5.196.66.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05C442F1 /* 5.196.66.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05C44562 /* 5.196.69.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05C44718 /* 5.196.71.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05C448E9 /* 5.196.72.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05C45862 /* 5.196.88.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05C45874 /* 5.196.88.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05C45FEC /* 5.196.95.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05C479A1 /* 5.196.121.161/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05C4DE38 /* 5.196.222.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05C4E3A1 /* 5.196.227.161/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05C4EF72 /* 5.196.239.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05C782BC /* 5.199.130.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05C785C1 /* 5.199.133.193/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05C78E70 /* 5.199.142.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05C78E7C /* 5.199.142.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05C78EC3 /* 5.199.142.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05C78EEC /* 5.199.142.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05C7957D /* 5.199.149.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05C7A7CF /* 5.199.167.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05C81590 /* 5.200.21.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05E40CDD /* 5.228.12.221/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05E68950 /* 5.230.137.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05E69141 /* 5.230.145.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05E693CA /* 5.230.147.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05F991A4 /* 5.249.145.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05F99599 /* 5.249.149.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05F995CC /* 5.249.149.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05F99F6C /* 5.249.159.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05F99FC6 /* 5.249.159.198/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05F99FD1 /* 5.249.159.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05FF3D82 /* 5.255.61.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05FF524B /* 5.255.82.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0818462C /* 8.24.70.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x081A5E12 /* 8.26.94.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x08250EDC /* 8.37.14.220/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0D447048 /* 13.68.112.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0D49A282 /* 13.73.162.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0D49A30F /* 13.73.163.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0D5076D2 /* 13.80.118.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0D5D7299 /* 13.93.114.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0E035769 /* 14.3.87.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0E035B2C /* 14.3.91.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0EC771B3 /* 14.199.113.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0ECA9DD9 /* 14.202.157.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0ECAE631 /* 14.202.230.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x12520056 /* 18.82.0.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1252005E /* 18.82.0.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1252011D /* 18.82.1.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x12520388 /* 18.82.3.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x125203C4 /* 18.82.3.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x125203CD /* 18.82.3.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x12B50525 /* 18.181.5.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x12F80098 /* 18.248.0.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x12F80155 /* 18.248.1.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1751425A /* 23.81.66.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x175B420B /* 23.91.66.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x175B7C7C /* 23.91.124.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x175BFEC8 /* 23.91.254.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x175C1371 /* 23.92.19.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x175C154A /* 23.92.21.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x175C161D /* 23.92.22.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x175C1B17 /* 23.92.27.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x175C1C17 /* 23.92.28.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x175E6595 /* 23.94.101.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x175EEA32 /* 23.94.234.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x175F092F /* 23.95.9.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x175F7105 /* 23.95.113.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1761ACE5 /* 23.97.172.229/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x176946AE /* 23.105.70.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x17A30099 /* 23.163.0.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x17EE11E5 /* 23.238.17.229/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x17EF077E /* 23.239.7.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x17EF0A90 /* 23.239.10.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x17EF1613 /* 23.239.22.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x17EF1B1C /* 23.239.27.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x17EF1DE2 /* 23.239.29.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x17EF7165 /* 23.239.113.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x17EF917D /* 23.239.145.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x17F24468 /* 23.242.68.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x17FE8026 /* 23.254.128.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x17FEA584 /* 23.254.165.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x17FEA5FA /* 23.254.165.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x17FEA6DE /* 23.254.166.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x17FEA7B4 /* 23.254.167.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x17FEA7B9 /* 23.254.167.185/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x17FEA7E7 /* 23.254.167.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x17FFD782 /* 23.255.215.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x18002A8B /* 24.0.42.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1803886A /* 24.3.136.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x18066A49 /* 24.6.106.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1806AE5E /* 24.6.174.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1807B899 /* 24.7.184.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x18084CAE /* 24.8.76.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1809B22E /* 24.9.178.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x18129BCE /* 24.18.155.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x181430FC /* 24.20.48.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1815D5B4 /* 24.21.213.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1816F50B /* 24.22.245.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x18228E69 /* 24.34.142.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x18288F0E /* 24.40.143.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1835303E /* 24.53.48.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1838F948 /* 24.56.249.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x183FD72F /* 24.63.215.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x184D7389 /* 24.77.115.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x18560435 /* 24.86.4.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x185D6D85 /* 24.93.109.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x185EB54F /* 24.94.181.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1860AD68 /* 24.96.173.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1860CED0 /* 24.96.206.208/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x18631C64 /* 24.99.28.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x18769E26 /* 24.118.158.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x18794054 /* 24.121.64.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x18821B00 /* 24.130.27.0/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1882DD76 /* 24.130.221.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x18943BB9 /* 24.148.59.185/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x18AB5048 /* 24.171.80.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x18B2F2B4 /* 24.178.242.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x18B7217A /* 24.183.33.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x18BA6CF9 /* 24.186.108.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x18BA6D04 /* 24.186.109.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x18C1EF3E /* 24.193.239.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x18CFD49A /* 24.207.212.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x18D97413 /* 24.217.116.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x18F635EB /* 24.246.53.235/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x18F8CB31 /* 24.248.203.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x18FF2173 /* 24.255.33.115/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1B00EB39 /* 27.0.235.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1B04D4C5 /* 27.4.212.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F039A0D /* 31.3.154.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F0646E1 /* 31.6.70.225/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F068F3E /* 31.6.143.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F07B826 /* 31.7.184.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F0E8788 /* 31.14.135.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F0F42DA /* 31.15.66.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F103016 /* 31.16.48.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F1059AA /* 31.16.89.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F105C19 /* 31.16.92.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F107B66 /* 31.16.123.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F10F410 /* 31.16.244.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F11002D /* 31.17.0.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F112C2D /* 31.17.44.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F113723 /* 31.17.55.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F1139ED /* 31.17.57.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F11E73D /* 31.17.231.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F124F4B /* 31.18.79.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F132A0B /* 31.19.42.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F137AC6 /* 31.19.122.198/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F17C113 /* 31.23.193.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F189425 /* 31.24.148.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F18E3F0 /* 31.24.227.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F192C37 /* 31.25.44.55/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F1CA8AE /* 31.28.168.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F1F49DE /* 31.31.73.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F1F4A2F /* 31.31.74.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F1F4A45 /* 31.31.74.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F1F4BB5 /* 31.31.75.181/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F1F4CA9 /* 31.31.76.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F1F4DB0 /* 31.31.77.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F1F4E31 /* 31.31.78.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F21B915 /* 31.33.185.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F22F15A /* 31.34.241.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F29DBE4 /* 31.41.219.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F2CE0ED /* 31.44.224.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F2CE638 /* 31.44.230.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F2D1035 /* 31.45.16.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F2FEE98 /* 31.47.238.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F360D08 /* 31.54.13.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F81A64E /* 31.129.166.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F82306D /* 31.130.48.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F8304A7 /* 31.131.4.167/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F83FB24 /* 31.131.251.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F849C88 /* 31.132.156.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F87F316 /* 31.135.243.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F87F38A /* 31.135.243.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F978323 /* 31.151.131.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1FA3F17E /* 31.163.241.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1FA81163 /* 31.168.17.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1FAA5229 /* 31.170.82.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1FAA694D /* 31.170.105.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1FAB9B1D /* 31.171.155.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1FAB9B66 /* 31.171.155.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1FAB9B6C /* 31.171.155.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1FABF433 /* 31.171.244.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1FAC56AD /* 31.172.86.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1FB28B8A /* 31.178.139.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1FB3842A /* 31.179.132.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1FB91BCB /* 31.185.27.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1FB96813 /* 31.185.104.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1FB96814 /* 31.185.104.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1FB96815 /* 31.185.104.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1FC06297 /* 31.192.98.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1FD008CB /* 31.208.8.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1FD02929 /* 31.208.41.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1FD047AD /* 31.208.71.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1FD0687E /* 31.208.104.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1FD0C9EC /* 31.208.201.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1FD22183 /* 31.210.33.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1FD69D53 /* 31.214.157.83/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1FDC0599 /* 31.220.5.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1FDC05C8 /* 31.220.5.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1FDC07CD /* 31.220.7.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1FDC1D7A /* 31.220.29.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x22C020B1 /* 34.192.32.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x22C16471 /* 34.193.100.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x22C55882 /* 34.197.88.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x22FA5400 /* 34.250.84.0/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x239C225F /* 35.156.34.95/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x239CF80C /* 35.156.248.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x23A1467D /* 35.161.70.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x23A32FF3 /* 35.163.47.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x23A436C1 /* 35.164.54.193/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x23A5B2E7 /* 35.165.178.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x23A75E0C /* 35.167.94.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x23B90E13 /* 35.185.14.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2437F33C /* 36.55.243.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x24E0398E /* 36.224.57.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2504ECD4 /* 37.4.236.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x250EC588 /* 37.14.197.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x250F704B /* 37.15.112.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x250F7AD8 /* 37.15.122.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2518C2C9 /* 37.24.194.201/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25223476 /* 37.34.52.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25236BEE /* 37.35.107.238/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25304971 /* 37.48.73.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x253050B4 /* 37.48.80.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25307809 /* 37.48.120.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x253078C4 /* 37.48.120.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25307A3C /* 37.48.122.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x253A39E7 /* 37.58.57.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x253B0227 /* 37.59.2.39/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x253B0A65 /* 37.59.10.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x253B0E5E /* 37.59.14.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x253B253B /* 37.59.37.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x253B28C1 /* 37.59.40.193/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x253B2E9F /* 37.59.46.159/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x253B32DA /* 37.59.50.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x253B4884 /* 37.59.72.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x253B59D6 /* 37.59.89.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x253B6BB9 /* 37.59.107.185/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x253B7007 /* 37.59.112.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x253B76F6 /* 37.59.118.246/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x253B7776 /* 37.59.119.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x253BFE09 /* 37.59.254.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x254E119E /* 37.78.17.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2561B974 /* 37.97.185.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x256E943B /* 37.110.148.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25719B64 /* 37.113.155.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25719FD5 /* 37.113.159.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25785989 /* 37.120.89.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2578A527 /* 37.120.165.39/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2578A9F3 /* 37.120.169.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2578ACF2 /* 37.120.172.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2578AD92 /* 37.120.173.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2578AEF9 /* 37.120.174.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2578B962 /* 37.120.185.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x257AD0DC /* 37.122.208.220/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x257B711D /* 37.123.113.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x257B8594 /* 37.123.133.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2582E385 /* 37.130.227.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2585166B /* 37.133.22.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x258B01D4 /* 37.139.1.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x258B0868 /* 37.139.8.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2599010A /* 37.153.1.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2599022C /* 37.153.2.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25992933 /* 37.153.41.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25993585 /* 37.153.53.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x259DC1A1 /* 37.157.193.161/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x259DC357 /* 37.157.195.87/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x259DC461 /* 37.157.196.97/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x259DC48E /* 37.157.196.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB0053 /* 37.187.0.83/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB011D /* 37.187.1.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB02AD /* 37.187.2.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB02E6 /* 37.187.2.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB036A /* 37.187.3.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB0408 /* 37.187.4.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB074A /* 37.187.7.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB1143 /* 37.187.17.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB115F /* 37.187.17.95/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB122B /* 37.187.18.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB126D /* 37.187.18.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB143B /* 37.187.20.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB144F /* 37.187.20.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB151C /* 37.187.21.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB159D /* 37.187.21.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB1657 /* 37.187.22.87/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB1683 /* 37.187.22.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB17A9 /* 37.187.23.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB17E8 /* 37.187.23.232/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB1E4E /* 37.187.30.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB1F27 /* 37.187.31.39/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB3F11 /* 37.187.63.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB4D34 /* 37.187.77.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB4ED2 /* 37.187.78.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB5A7A /* 37.187.90.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB5A95 /* 37.187.90.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB604E /* 37.187.96.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB6054 /* 37.187.96.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB6152 /* 37.187.97.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB615F /* 37.187.97.95/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB62B9 /* 37.187.98.185/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB658F /* 37.187.101.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB666C /* 37.187.102.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB66BA /* 37.187.102.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB66CA /* 37.187.102.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB679C /* 37.187.103.156/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB686F /* 37.187.104.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB68B2 /* 37.187.104.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB692B /* 37.187.105.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB6941 /* 37.187.105.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB6944 /* 37.187.105.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB6968 /* 37.187.105.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB6B5B /* 37.187.107.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB6C50 /* 37.187.108.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB6CD9 /* 37.187.108.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB6E81 /* 37.187.110.129/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB6ED8 /* 37.187.110.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB6FCD /* 37.187.111.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB732F /* 37.187.115.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB739D /* 37.187.115.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB7825 /* 37.187.120.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB7B79 /* 37.187.123.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB82E2 /* 37.187.130.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BBB040 /* 37.187.176.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BBB102 /* 37.187.177.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BBB404 /* 37.187.180.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BBB412 /* 37.187.180.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BBB470 /* 37.187.180.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BBEF08 /* 37.187.239.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BC5335 /* 37.188.83.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BFC7AD /* 37.191.199.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BFE748 /* 37.191.231.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BFE8E4 /* 37.191.232.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BFEC54 /* 37.191.236.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25C07417 /* 37.192.116.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25C86205 /* 37.200.98.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25C86275 /* 37.200.98.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25C863FB /* 37.200.99.251/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25CC3375 /* 37.204.51.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25CC834F /* 37.204.131.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25CD0983 /* 37.205.9.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25CD0A8C /* 37.205.10.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25CD0B95 /* 37.205.11.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25D11308 /* 37.209.19.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25D1771F /* 37.209.119.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25DAF015 /* 37.218.240.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25DAF032 /* 37.218.240.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25DAF044 /* 37.218.240.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25DAF050 /* 37.218.240.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25DAF065 /* 37.218.240.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25DAF7D9 /* 37.218.247.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25DC1229 /* 37.220.18.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25DC23CA /* 37.220.35.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25DC24F0 /* 37.220.36.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25DDA2E2 /* 37.221.162.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25DDABEA /* 37.221.171.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25DDABEC /* 37.221.171.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25DDC108 /* 37.221.193.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25DDC1C3 /* 37.221.193.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25DDC41F /* 37.221.196.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25DDC489 /* 37.221.196.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25DDD301 /* 37.221.211.1/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25E48667 /* 37.228.134.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25E5D380 /* 37.229.211.128/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25E67725 /* 37.230.119.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25E9639D /* 37.233.99.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25EB30F7 /* 37.235.48.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25EB3122 /* 37.235.49.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25EB317C /* 37.235.49.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25EB318A /* 37.235.49.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25EB3443 /* 37.235.52.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25EB3753 /* 37.235.55.83/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25EB38B4 /* 37.235.56.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25EB3C4D /* 37.235.60.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25F72A79 /* 37.247.42.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25F733C5 /* 37.247.51.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25FCBEB0 /* 37.252.190.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x26E5001C /* 38.229.0.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x26E5001D /* 38.229.0.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x26E54622 /* 38.229.70.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x26E5462B /* 38.229.70.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x26E54633 /* 38.229.70.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x26E54634 /* 38.229.70.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x26E54635 /* 38.229.70.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x26E54636 /* 38.229.70.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x26E5463D /* 38.229.70.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x26E54F02 /* 38.229.79.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x276E67D5 /* 39.110.103.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x294D88B2 /* 41.77.136.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x29B61914 /* 41.182.25.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x29B91CD6 /* 41.185.28.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x29CEBCCE /* 41.206.188.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x29D0D52E /* 41.208.213.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x29D7F232 /* 41.215.242.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x29DF358D /* 41.223.53.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x29E73565 /* 41.231.53.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2A024E0B /* 42.2.78.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2A70102A /* 42.112.16.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2A7010C2 /* 42.112.16.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2A7010C6 /* 42.112.16.198/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2A7010C8 /* 42.112.16.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2A7C24FC /* 42.124.36.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2BF00C3A /* 43.240.12.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2BF0633E /* 43.240.99.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2BFC250E /* 43.252.37.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D144301 /* 45.20.67.1/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D200159 /* 45.32.1.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D200322 /* 45.32.3.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D200C25 /* 45.32.12.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D201918 /* 45.32.25.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D201EB2 /* 45.32.30.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D203F93 /* 45.32.63.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D207501 /* 45.32.117.1/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D209255 /* 45.32.146.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D209749 /* 45.32.151.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D209CB3 /* 45.32.156.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D209FFD /* 45.32.159.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D20B16B /* 45.32.177.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D20BDB1 /* 45.32.189.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D20D9B8 /* 45.32.217.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D20E314 /* 45.32.227.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D20E9BF /* 45.32.233.191/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D20EDDB /* 45.32.237.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D20EE3D /* 45.32.238.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D20EE65 /* 45.32.238.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D20EFA6 /* 45.32.239.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D20F549 /* 45.32.245.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D20F620 /* 45.32.246.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D20F720 /* 45.32.247.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D20F7E6 /* 45.32.247.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D20FA2E /* 45.32.250.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D211717 /* 45.33.23.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D212752 /* 45.33.39.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D2130CC /* 45.33.48.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D21395B /* 45.33.57.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D213D28 /* 45.33.61.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D21402D /* 45.33.64.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D214144 /* 45.33.65.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D214B1C /* 45.33.75.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D214D34 /* 45.33.77.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D2178C9 /* 45.33.120.201/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D228F04 /* 45.34.143.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D234855 /* 45.35.72.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D245B78 /* 45.36.91.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D25AAF2 /* 45.37.170.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D324D34 /* 45.50.77.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D370C17 /* 45.55.12.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D371384 /* 45.55.19.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D371B46 /* 45.55.27.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D373297 /* 45.55.50.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D37374C /* 45.55.55.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D373EA1 /* 45.55.62.161/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D376C6E /* 45.55.108.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D378127 /* 45.55.129.39/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3785F9 /* 45.55.133.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D37A05E /* 45.55.160.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D37A721 /* 45.55.167.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D37C2AF /* 45.55.194.175/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D37D4D9 /* 45.55.212.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D37EC13 /* 45.55.236.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D37F8E4 /* 45.55.248.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3A263B /* 45.58.38.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3A31FB /* 45.58.49.251/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3A34DD /* 45.58.52.221/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3A3C7F /* 45.58.60.127/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3E7420 /* 45.62.116.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3ECC76 /* 45.62.204.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3ED297 /* 45.62.210.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3ED2B0 /* 45.62.210.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3ED5FA /* 45.62.213.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3EE196 /* 45.62.225.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3EE1B7 /* 45.62.225.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3EE23B /* 45.62.226.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3EE30A /* 45.62.227.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3EE459 /* 45.62.228.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3EE814 /* 45.62.232.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3EE8D4 /* 45.62.232.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3EEBCA /* 45.62.235.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3EEDEA /* 45.62.237.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3EF2C2 /* 45.62.242.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3EF3CC /* 45.62.243.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3EF4F0 /* 45.62.244.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3EF65B /* 45.62.246.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3EF684 /* 45.62.246.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3EF712 /* 45.62.247.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3EF71B /* 45.62.247.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3EF912 /* 45.62.249.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3EF9C3 /* 45.62.249.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3EFA42 /* 45.62.250.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3EFC42 /* 45.62.252.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3EFC48 /* 45.62.252.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3EFC4C /* 45.62.252.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3EFD71 /* 45.62.253.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3F0EE1 /* 45.63.14.225/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3F185E /* 45.63.24.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3F18E3 /* 45.63.24.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3F19B3 /* 45.63.25.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3F19EB /* 45.63.25.235/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3F1A30 /* 45.63.26.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3F1BC3 /* 45.63.27.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3F1EA7 /* 45.63.30.167/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3F2A5B /* 45.63.42.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3F368F /* 45.63.54.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3F4371 /* 45.63.67.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3F4EB1 /* 45.63.78.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3F54D9 /* 45.63.84.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3F57EE /* 45.63.87.238/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3F5935 /* 45.63.89.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3F7760 /* 45.63.119.96/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3F79B0 /* 45.63.121.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3F7ED2 /* 45.63.126.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4C154D /* 45.76.21.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4C25E7 /* 45.76.37.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4C26DB /* 45.76.38.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4C5418 /* 45.76.84.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4C5C75 /* 45.76.92.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4C6B8C /* 45.76.107.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4C6E2E /* 45.76.110.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4C8322 /* 45.76.131.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4C869F /* 45.76.134.159/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4C9570 /* 45.76.149.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4C9CA5 /* 45.76.156.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F0AC3 /* 45.79.10.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F43ED /* 45.79.67.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F4CAE /* 45.79.76.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F582B /* 45.79.88.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F5B7E /* 45.79.91.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F5C5E /* 45.79.92.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F5FF4 /* 45.79.95.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F6365 /* 45.79.99.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F6C60 /* 45.79.108.96/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F6D37 /* 45.79.109.55/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F6F7C /* 45.79.111.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F8A08 /* 45.79.138.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F92E3 /* 45.79.146.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4FB872 /* 45.79.184.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4FBA2B /* 45.79.186.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4FC4D3 /* 45.79.196.211/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4FCFB0 /* 45.79.207.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4FD7B0 /* 45.79.215.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D7AFD06 /* 45.122.253.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D7B7665 /* 45.123.118.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D7BBE74 /* 45.123.190.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E040059 /* 46.4.0.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E041343 /* 46.4.19.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E0422F2 /* 46.4.34.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E04268B /* 46.4.38.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E042843 /* 46.4.40.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E042DBC /* 46.4.45.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E0431C9 /* 46.4.49.201/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E0437B1 /* 46.4.55.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E043997 /* 46.4.57.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E043A5A /* 46.4.58.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E044E03 /* 46.4.78.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E045131 /* 46.4.81.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E046723 /* 46.4.103.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E046F7C /* 46.4.111.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E047AAD /* 46.4.122.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E047D02 /* 46.4.125.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E04803E /* 46.4.128.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E049051 /* 46.4.144.81/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E04AE34 /* 46.4.174.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E04FDC2 /* 46.4.253.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E0528D2 /* 46.5.40.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E05DE6A /* 46.5.222.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E05E9A1 /* 46.5.233.161/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E05EF26 /* 46.5.239.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E075A45 /* 46.7.90.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E07F1E0 /* 46.7.241.224/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E09C314 /* 46.9.195.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E0EF5CE /* 46.14.245.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E10EA83 /* 46.16.234.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E113FD6 /* 46.17.63.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E135DD4 /* 46.19.93.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E135DD6 /* 46.19.93.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E135DD8 /* 46.19.93.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E142372 /* 46.20.35.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E14F677 /* 46.20.246.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E16D163 /* 46.22.209.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E16D4E6 /* 46.22.212.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E1746C3 /* 46.23.70.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E174851 /* 46.23.72.81/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E17551F /* 46.23.85.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E1C40EA /* 46.28.64.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E1C449D /* 46.28.68.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E1C449E /* 46.28.68.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E1C5621 /* 46.28.86.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E1C6B52 /* 46.28.107.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E1C6DE7 /* 46.28.109.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E1C6E88 /* 46.28.110.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E1C6EF4 /* 46.28.110.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E1CCAFE /* 46.28.202.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E1CCDAA /* 46.28.205.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E1CCDBB /* 46.28.205.187/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E1CCE7E /* 46.28.206.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E1CCF13 /* 46.28.207.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E1CCF3A /* 46.28.207.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E1CCF6B /* 46.28.207.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E1CCF8D /* 46.28.207.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E1DF8EE /* 46.29.248.238/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E242549 /* 46.36.37.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E242786 /* 46.36.39.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E259D1F /* 46.37.157.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E26300C /* 46.38.48.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E2630E1 /* 46.38.48.225/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E263312 /* 46.38.51.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E2638D5 /* 46.38.56.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E26E7D1 /* 46.38.231.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E26E9F2 /* 46.38.233.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E26EA9E /* 46.38.234.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E26EC11 /* 46.38.236.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E26EDDD /* 46.38.237.221/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E26EE84 /* 46.38.238.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E26F110 /* 46.38.241.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E26FA27 /* 46.38.250.39/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E27E388 /* 46.39.227.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E27FB57 /* 46.39.251.87/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E2901A7 /* 46.41.1.167/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E293BDF /* 46.41.59.223/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E298244 /* 46.41.130.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E298454 /* 46.41.132.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E29964A /* 46.41.150.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E2D0F7B /* 46.45.15.123/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E3B489D /* 46.59.72.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E3B6325 /* 46.59.99.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E3B8535 /* 46.59.133.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E3BB9CE /* 46.59.185.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E3BC7B0 /* 46.59.199.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E3BD83E /* 46.59.216.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E491002 /* 46.73.16.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E49B49E /* 46.73.180.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E53768C /* 46.83.118.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E541269 /* 46.84.18.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E5443ED /* 46.84.67.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E566304 /* 46.86.99.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E59D7A4 /* 46.89.215.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E59D8D6 /* 46.89.216.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E5B6737 /* 46.91.103.55/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E650933 /* 46.101.9.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E65158F /* 46.101.21.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E6515C9 /* 46.101.21.201/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E6547B6 /* 46.101.71.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E655FEF /* 46.101.95.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E656647 /* 46.101.102.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E6568F5 /* 46.101.104.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E657F91 /* 46.101.127.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E658A2E /* 46.101.138.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E658B87 /* 46.101.139.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E658BF8 /* 46.101.139.248/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E658D0F /* 46.101.141.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E658EAE /* 46.101.142.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E659569 /* 46.101.149.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E659631 /* 46.101.150.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E6597DE /* 46.101.151.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E659893 /* 46.101.152.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E65A613 /* 46.101.166.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E65A997 /* 46.101.169.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E65B2BE /* 46.101.178.190/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E65B7A0 /* 46.101.183.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E65C0E6 /* 46.101.192.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E65CAE7 /* 46.101.202.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E65CE81 /* 46.101.206.129/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E65D847 /* 46.101.216.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E65DFE7 /* 46.101.223.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E65E72C /* 46.101.231.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E691DC8 /* 46.105.29.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E693F2C /* 46.105.63.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E6954B2 /* 46.105.84.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E696495 /* 46.105.100.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E69E36D /* 46.105.227.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E6C27DB /* 46.108.39.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E77FDF4 /* 46.119.253.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E7E0EBC /* 46.126.14.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E7F0C21 /* 46.127.12.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E7FA71E /* 46.127.167.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E803C3C /* 46.128.60.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E80720C /* 46.128.114.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E80C733 /* 46.128.199.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E8E51C0 /* 46.142.81.192/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E92F7A7 /* 46.146.247.167/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E941222 /* 46.148.18.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E941342 /* 46.148.19.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E941A6C /* 46.148.26.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E971AC2 /* 46.151.26.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E971B65 /* 46.151.27.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA102E0 /* 46.161.2.224/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA1924B /* 46.161.146.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA2C0A6 /* 46.162.192.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA34CAA /* 46.163.76.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA34E0E /* 46.163.78.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA4DA09 /* 46.164.218.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA4F360 /* 46.164.243.96/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA5C560 /* 46.165.197.96/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA5D64D /* 46.165.214.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA5DDA6 /* 46.165.221.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA5DFD9 /* 46.165.223.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA5E605 /* 46.165.230.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA5F2A6 /* 46.165.242.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA5F9D1 /* 46.165.249.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA5FAE0 /* 46.165.250.224/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA5FDA4 /* 46.165.253.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA5FDB4 /* 46.165.253.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA5FE28 /* 46.165.254.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA6948E /* 46.166.148.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA6948F /* 46.166.148.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA69490 /* 46.166.148.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA69491 /* 46.166.148.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA69492 /* 46.166.148.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA69498 /* 46.166.148.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA69499 /* 46.166.148.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA6949A /* 46.166.148.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA6949B /* 46.166.148.155/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA694B0 /* 46.166.148.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA694B1 /* 46.166.148.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA6A049 /* 46.166.160.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA6A222 /* 46.166.162.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA6A235 /* 46.166.162.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA6A372 /* 46.166.163.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA6A378 /* 46.166.163.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA6A512 /* 46.166.165.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA6A576 /* 46.166.165.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA6A581 /* 46.166.165.129/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA6A72E /* 46.166.167.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA6AD65 /* 46.166.173.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA7F533 /* 46.167.245.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EAD2695 /* 46.173.38.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EB6121D /* 46.182.18.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EB6126F /* 46.182.18.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EB612D6 /* 46.182.18.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EB612DF /* 46.182.18.223/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EB612F5 /* 46.182.18.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EB61397 /* 46.182.19.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EB613DB /* 46.182.19.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EB613E7 /* 46.182.19.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EB66ABE /* 46.182.106.190/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EB6D01C /* 46.182.208.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EB7D8CD /* 46.183.216.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EB7D8E0 /* 46.183.216.224/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EB7DAC6 /* 46.183.218.198/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EB7DAC7 /* 46.183.218.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EB7DD89 /* 46.183.221.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EB7DDE7 /* 46.183.221.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EBB039C /* 46.187.3.156/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EBC02E4 /* 46.188.2.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EBC0425 /* 46.188.4.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EBC2C19 /* 46.188.44.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EBC389E /* 46.188.56.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EC20F5D /* 46.194.15.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2ECE6DDD /* 46.206.109.221/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EDB020C /* 46.219.2.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EDF5011 /* 46.223.80.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EDF6387 /* 46.223.99.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EE343B5 /* 46.227.67.181/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EE360DA /* 46.227.96.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EE412ED /* 46.228.18.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EE5ADEB /* 46.229.173.235/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EE5EEAC /* 46.229.238.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EE90046 /* 46.233.0.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EEBE346 /* 46.235.227.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EEF6CC2 /* 46.239.108.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EF48887 /* 46.244.136.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EF4E6CC /* 46.244.230.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EF62AEC /* 46.246.42.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EF62B6B /* 46.246.43.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EF631CF /* 46.246.49.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EF659A9 /* 46.246.89.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EF65D46 /* 46.246.93.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EF91507 /* 46.249.21.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EF9256D /* 46.249.37.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EF9258F /* 46.249.37.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EF93147 /* 46.249.49.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EF93167 /* 46.249.49.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EF931E7 /* 46.249.49.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EFC1838 /* 46.252.24.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EFC19F9 /* 46.252.25.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EFC1A02 /* 46.252.26.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2F10B998 /* 47.16.185.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2F340306 /* 47.52.3.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2F3770E4 /* 47.55.112.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2F580304 /* 47.88.3.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2F580560 /* 47.88.5.96/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2F580626 /* 47.88.6.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2F580B9E /* 47.88.11.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2F580C0E /* 47.88.12.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2F5812DA /* 47.88.18.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2F581674 /* 47.88.22.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2F581BA1 /* 47.88.27.161/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2F581C38 /* 47.88.28.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2F58BCD1 /* 47.88.188.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2F58C22F /* 47.88.194.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2F58F20C /* 47.88.242.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2F5921A9 /* 47.89.33.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2F93BE47 /* 47.147.190.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2F946A1D /* 47.148.106.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2F96A641 /* 47.150.166.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2F98E3B8 /* 47.152.227.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2FB85DF1 /* 47.184.93.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2FBE0902 /* 47.190.9.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2FC7F0D4 /* 47.199.240.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2FCA878C /* 47.202.135.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2FDD0406 /* 47.221.4.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x31030B7A /* 49.3.11.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x31D4A626 /* 49.212.166.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32013381 /* 50.1.51.129/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3207730C /* 50.7.115.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32077343 /* 50.7.115.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32079720 /* 50.7.151.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3207972F /* 50.7.151.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3207977F /* 50.7.151.127/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3207A1DA /* 50.7.161.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3207B002 /* 50.7.176.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3207B222 /* 50.7.178.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3207B262 /* 50.7.178.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3207B292 /* 50.7.178.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3207B3CA /* 50.7.179.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3207B3FB /* 50.7.179.251/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3207B83A /* 50.7.184.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3207BA26 /* 50.7.186.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x321A02E8 /* 50.26.2.232/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x321E240F /* 50.30.36.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x321E2412 /* 50.30.36.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x321F70E7 /* 50.31.112.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x321FFC0B /* 50.31.252.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x321FFC2B /* 50.31.252.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32277A27 /* 50.39.122.39/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3227A54D /* 50.39.165.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x322E6D89 /* 50.46.109.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x322E7DA7 /* 50.46.125.167/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3235472D /* 50.53.71.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3235B52D /* 50.53.181.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3241A4B3 /* 50.65.164.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3242552D /* 50.66.85.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32428A4C /* 50.66.138.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x324C3161 /* 50.76.49.97/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x324C9FDA /* 50.76.159.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3258B15A /* 50.88.177.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3265F0E0 /* 50.101.240.224/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3273A471 /* 50.115.164.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32740095 /* 50.116.0.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x327403DF /* 50.116.3.223/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3274046B /* 50.116.4.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3274048D /* 50.116.4.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32740599 /* 50.116.5.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32740740 /* 50.116.7.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32740F49 /* 50.116.15.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x327415AC /* 50.116.21.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32741DB3 /* 50.116.29.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32742806 /* 50.116.40.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x327428E2 /* 50.116.40.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32742AF5 /* 50.116.42.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32743085 /* 50.116.48.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3274312E /* 50.116.49.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32743830 /* 50.116.56.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32808C86 /* 50.128.140.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3286A971 /* 50.134.169.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3287AAFC /* 50.135.170.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3288C5FD /* 50.136.197.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32894E81 /* 50.137.78.129/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x328AA937 /* 50.138.169.55/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32967772 /* 50.150.119.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32972D07 /* 50.151.45.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x329F7E15 /* 50.159.126.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32A11710 /* 50.161.23.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32A2D76C /* 50.162.215.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32A56D5B /* 50.165.109.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32AA0CB8 /* 50.170.12.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32AF9CE1 /* 50.175.156.225/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32B12972 /* 50.177.41.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32BBD74E /* 50.187.215.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32C113B2 /* 50.193.19.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32C18F2A /* 50.193.143.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32C1CA26 /* 50.193.202.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32F38312 /* 50.243.131.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32F4C8DD /* 50.244.200.221/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32F7C37C /* 50.247.195.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32F7F8AC /* 50.247.248.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32FAC9FE /* 50.250.201.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3306168B /* 51.6.22.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F017D /* 51.15.1.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F040A /* 51.15.4.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F040D /* 51.15.4.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F0437 /* 51.15.4.55/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F2495 /* 51.15.36.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F24A4 /* 51.15.36.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F24AC /* 51.15.36.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F24B7 /* 51.15.36.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F24CE /* 51.15.36.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F253B /* 51.15.37.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F2561 /* 51.15.37.97/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F260D /* 51.15.38.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F2637 /* 51.15.38.55/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F263A /* 51.15.38.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F2702 /* 51.15.39.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F28E9 /* 51.15.40.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F2A13 /* 51.15.42.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F2BCA /* 51.15.43.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F2BCD /* 51.15.43.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F2C36 /* 51.15.44.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F2C8E /* 51.15.44.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F2CFB /* 51.15.44.251/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F2E0F /* 51.15.46.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F2E2D /* 51.15.46.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F2E8E /* 51.15.46.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F2F3E /* 51.15.47.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F3095 /* 51.15.48.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F30FC /* 51.15.48.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F30FE /* 51.15.48.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F3108 /* 51.15.49.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F3224 /* 51.15.50.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F326D /* 51.15.50.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F32C0 /* 51.15.50.192/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F339C /* 51.15.51.156/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F339F /* 51.15.51.159/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F3410 /* 51.15.52.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F3478 /* 51.15.52.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F34F4 /* 51.15.52.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F354B /* 51.15.53.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F3553 /* 51.15.53.83/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F3576 /* 51.15.53.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F37F5 /* 51.15.55.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F3865 /* 51.15.56.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F3957 /* 51.15.57.87/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F3A69 /* 51.15.58.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F3A98 /* 51.15.58.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F3BDF /* 51.15.59.223/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F3C66 /* 51.15.60.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F3D03 /* 51.15.61.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F3D49 /* 51.15.61.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F3E82 /* 51.15.62.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F3EFC /* 51.15.62.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F8767 /* 51.15.135.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F8BC8 /* 51.15.139.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F8F11 /* 51.15.143.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F8FEF /* 51.15.143.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x338D06FA /* 51.141.6.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33AEC575 /* 51.174.197.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33AF32A2 /* 51.175.50.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33AF77B7 /* 51.175.119.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FE17CB /* 51.254.23.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FE2397 /* 51.254.35.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FE26F9 /* 51.254.38.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FE305D /* 51.254.48.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FE3D41 /* 51.254.61.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FE5640 /* 51.254.86.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FE6376 /* 51.254.99.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FE65F2 /* 51.254.101.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FE6670 /* 51.254.102.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FE7034 /* 51.254.112.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FE73E1 /* 51.254.115.225/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FE7404 /* 51.254.116.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FE7852 /* 51.254.120.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FE793F /* 51.254.121.63/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FE80C9 /* 51.254.128.201/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FE83E2 /* 51.254.131.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FE87D5 /* 51.254.135.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FE88C3 /* 51.254.136.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FEA432 /* 51.254.164.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FEAF54 /* 51.254.175.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FED1C5 /* 51.254.209.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FED906 /* 51.254.217.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FEDAF7 /* 51.254.218.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FEDD90 /* 51.254.221.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FEE104 /* 51.254.225.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FEF6CB /* 51.254.246.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FF28E3 /* 51.255.40.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FF2941 /* 51.255.41.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FF295B /* 51.255.41.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FF2CB7 /* 51.255.44.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FF304E /* 51.255.48.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FF4B03 /* 51.255.75.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FF63C7 /* 51.255.99.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FFA888 /* 51.255.168.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FFA90A /* 51.255.169.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FFC64D /* 51.255.198.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FFCA42 /* 51.255.202.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FFCE4A /* 51.255.206.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FFD302 /* 51.255.211.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FFD3EB /* 51.255.211.235/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x34060992 /* 52.6.9.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x340A7D8C /* 52.10.125.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x34108E2D /* 52.16.142.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3412C7EF /* 52.18.199.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x341363E8 /* 52.19.99.232/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x34230B02 /* 52.35.11.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3424553A /* 52.36.85.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3427F366 /* 52.39.243.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x342A5EC8 /* 52.42.94.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x343229E9 /* 52.50.41.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x34382A18 /* 52.56.42.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x34387CCC /* 52.56.124.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x343B3716 /* 52.59.55.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x343F8694 /* 52.63.134.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3441CBF7 /* 52.65.203.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x34424F66 /* 52.66.79.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3442757E /* 52.66.117.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3442987F /* 52.66.152.127/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3443BC29 /* 52.67.188.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x345A5415 /* 52.90.84.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x345ACE83 /* 52.90.206.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x345BE3FB /* 52.91.227.251/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x34A6C0B4 /* 52.166.192.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x34A90A5A /* 52.169.10.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x34B72F9B /* 52.183.47.155/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x34B89DEA /* 52.184.157.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x34D1200B /* 52.209.32.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x34D18505 /* 52.209.133.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x34D2A92C /* 52.210.169.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x34D355CD /* 52.211.85.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x34D38C46 /* 52.211.140.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x34D5740C /* 52.213.116.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x34D62D93 /* 52.214.45.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x34D67041 /* 52.214.112.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x36546A29 /* 54.84.106.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x36559EBB /* 54.85.158.187/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3656E88C /* 54.86.232.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x365DB1D9 /* 54.93.177.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x365E55C9 /* 54.94.85.201/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x365E660F /* 54.94.102.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x369F547E /* 54.159.84.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x36A148CC /* 54.161.72.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x36A6BADA /* 54.166.186.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x36B362CC /* 54.179.98.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x36BA1A45 /* 54.186.26.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x36BA3003 /* 54.186.48.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x36BA6869 /* 54.186.104.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x36BBEF10 /* 54.187.239.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x36C422BD /* 54.196.34.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x36C51CD3 /* 54.197.28.211/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x36C9C95D /* 54.201.201.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x36D3D06C /* 54.211.208.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x36D95C38 /* 54.217.92.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x36DAAC00 /* 54.218.172.0/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x36E44160 /* 54.228.65.96/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x36F10991 /* 54.241.9.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x36F23700 /* 54.242.55.0/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3A0650FA /* 58.6.80.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3A59560E /* 58.89.86.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3A99DD0A /* 58.153.221.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3AB7AE38 /* 58.183.174.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3B6629E1 /* 59.102.41.225/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3B73764C /* 59.115.118.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3B7FA39B /* 59.127.163.155/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3BB14343 /* 59.177.67.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3BB146D2 /* 59.177.70.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3BB311C3 /* 59.179.17.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3C362616 /* 60.54.38.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3CEA6524 /* 60.234.101.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3CF8A2B3 /* 60.248.162.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3D44D8AB /* 61.68.216.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3DE67487 /* 61.230.116.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3DE70128 /* 61.231.1.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E040F54 /* 62.4.15.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E0C736B /* 62.12.115.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E259614 /* 62.37.150.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E2D9C59 /* 62.45.156.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E2DB2A9 /* 62.45.178.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E3061B1 /* 62.48.97.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E3D8F8D /* 62.61.143.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E4852DE /* 62.72.82.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E4BFF25 /* 62.75.255.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E4C1146 /* 62.76.17.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E50C8BE /* 62.80.200.190/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E5ABCBC /* 62.90.188.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E669443 /* 62.102.148.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E6694A9 /* 62.102.148.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E6694AB /* 62.102.148.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E6694AC /* 62.102.148.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E6BB9CB /* 62.107.185.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E6D0473 /* 62.109.4.115/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E6D16C5 /* 62.109.22.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E71D3A3 /* 62.113.211.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E71D8AD /* 62.113.216.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E71D8B1 /* 62.113.216.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E71E37C /* 62.113.227.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E75AAC4 /* 62.117.170.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E858269 /* 62.133.130.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E8A02B8 /* 62.138.2.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E8A07AB /* 62.138.7.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E8A07E7 /* 62.138.7.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E8A0A3C /* 62.138.10.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E8A0A3D /* 62.138.10.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E8A0A3E /* 62.138.10.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E8D235B /* 62.141.35.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E8D2496 /* 62.141.36.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E8D258E /* 62.141.37.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E8D30AF /* 62.141.48.175/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E8D34B9 /* 62.141.52.185/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E8D3656 /* 62.141.54.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E8D3775 /* 62.141.55.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E8E9F55 /* 62.142.159.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E8F9ADF /* 62.143.154.223/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E9502BC /* 62.149.2.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E950D39 /* 62.149.13.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E982BCB /* 62.152.43.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E99066D /* 62.153.6.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E9B9E6D /* 62.155.158.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3EA62CF9 /* 62.166.44.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3EA74820 /* 62.167.72.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3EA803D4 /* 62.168.3.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3EAD9A99 /* 62.173.154.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3EB0EFE5 /* 62.176.239.229/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3EB23FA5 /* 62.178.63.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3EB278C5 /* 62.178.120.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3EB28703 /* 62.178.135.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3EB2F63A /* 62.178.246.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3EB46D0B /* 62.180.109.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3EC2ACA7 /* 62.194.172.167/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3EC32E81 /* 62.195.46.129/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3EC5CFB6 /* 62.197.207.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3EC7AEED /* 62.199.174.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED22410 /* 62.210.36.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2242E /* 62.210.36.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED22552 /* 62.210.37.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2454F /* 62.210.69.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED245EC /* 62.210.69.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED24A6E /* 62.210.74.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED24B54 /* 62.210.75.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED24C58 /* 62.210.76.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED25134 /* 62.210.81.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2522C /* 62.210.82.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED25422 /* 62.210.84.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED25AA4 /* 62.210.90.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED25C0B /* 62.210.92.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED25D8E /* 62.210.93.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2692F /* 62.210.105.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED26974 /* 62.210.105.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED26B56 /* 62.210.107.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED26D30 /* 62.210.109.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED26D85 /* 62.210.109.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED27393 /* 62.210.115.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED27B18 /* 62.210.123.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED27B85 /* 62.210.123.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED27C7C /* 62.210.124.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED27D82 /* 62.210.125.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED281F6 /* 62.210.129.246/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED28438 /* 62.210.132.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED289E6 /* 62.210.137.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED28A03 /* 62.210.138.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED28C77 /* 62.210.140.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED28E27 /* 62.210.142.39/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2AA8F /* 62.210.170.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2BE05 /* 62.210.190.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2CE19 /* 62.210.206.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2CE35 /* 62.210.206.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2D3CE /* 62.210.211.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2D511 /* 62.210.213.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2F492 /* 62.210.244.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2F58A /* 62.210.245.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2F59E /* 62.210.245.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2F6A3 /* 62.210.246.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2F7B2 /* 62.210.247.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2FAC0 /* 62.210.250.192/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2FB35 /* 62.210.251.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2FE7F /* 62.210.254.127/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2FE84 /* 62.210.254.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2FEC9 /* 62.210.254.201/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED4498D /* 62.212.73.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED6063D /* 62.214.6.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED80578 /* 62.216.5.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED97CFD /* 62.217.124.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3EDB2E85 /* 62.219.46.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3EDBB62A /* 62.219.182.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3EDC9457 /* 62.220.148.87/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3EDC9461 /* 62.220.148.97/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3EE04740 /* 62.224.71.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3EE04911 /* 62.224.73.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3EE0B81D /* 62.224.184.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3EEB2055 /* 62.235.32.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3EF9AABA /* 62.249.170.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3EFB32E8 /* 62.251.50.232/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3EFD8952 /* 62.253.137.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3F8DF6BA /* 63.141.246.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3F8E9DA2 /* 63.142.157.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3FDF4567 /* 63.223.69.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3FE4435E /* 63.228.67.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x401B118C /* 64.27.17.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x404E969F /* 64.78.150.159/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x405B06F4 /* 64.91.6.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x405D47FD /* 64.93.71.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4071201D /* 64.113.32.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x407C2054 /* 64.124.32.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x40898B49 /* 64.137.139.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089A6E8 /* 64.137.166.232/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089A944 /* 64.137.169.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089AACA /* 64.137.170.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089AC79 /* 64.137.172.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089AD2B /* 64.137.173.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089AD76 /* 64.137.173.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089ADEB /* 64.137.173.235/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089B04D /* 64.137.176.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089B203 /* 64.137.178.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089B22F /* 64.137.178.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089B4C5 /* 64.137.180.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089B698 /* 64.137.182.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089B69E /* 64.137.182.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089B824 /* 64.137.184.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089B896 /* 64.137.184.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089B952 /* 64.137.185.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089BCF1 /* 64.137.188.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089BD4D /* 64.137.189.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089BD6D /* 64.137.189.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089BFF3 /* 64.137.191.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089C3BA /* 64.137.195.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089C3D6 /* 64.137.195.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089C3E6 /* 64.137.195.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089C5E9 /* 64.137.197.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089C711 /* 64.137.199.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089C860 /* 64.137.200.96/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089C95A /* 64.137.201.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089C9B2 /* 64.137.201.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089CC42 /* 64.137.204.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089CC83 /* 64.137.204.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089CEF8 /* 64.137.206.248/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089D003 /* 64.137.208.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089D09F /* 64.137.208.159/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089D2FA /* 64.137.210.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089D454 /* 64.137.212.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089D6D8 /* 64.137.214.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089D932 /* 64.137.217.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089D9C1 /* 64.137.217.193/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089DAA7 /* 64.137.218.167/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089E09A /* 64.137.224.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089E47A /* 64.137.228.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089E5A0 /* 64.137.229.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089E64D /* 64.137.230.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089E663 /* 64.137.230.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089E738 /* 64.137.231.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089F30D /* 64.137.243.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089F343 /* 64.137.243.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089F413 /* 64.137.244.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089F460 /* 64.137.244.96/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089F538 /* 64.137.245.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089F768 /* 64.137.247.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089F7BF /* 64.137.247.191/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089FD92 /* 64.137.253.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4089FF82 /* 64.137.255.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x40BBA7E3 /* 64.187.167.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x40E5998F /* 64.229.153.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x40ED332E /* 64.237.51.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4113A782 /* 65.19.167.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4113A783 /* 65.19.167.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4113A784 /* 65.19.167.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4113A785 /* 65.19.167.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4113B2F1 /* 65.19.178.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x411BD32D /* 65.27.211.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4132CB05 /* 65.50.203.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x413C3C4E /* 65.60.60.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x416E64D6 /* 65.110.100.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x416FBA42 /* 65.111.186.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4170DD23 /* 65.112.221.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4181C419 /* 65.129.196.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x41B57BFE /* 65.181.123.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x41B792DD /* 65.183.146.221/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x42185436 /* 66.24.84.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4237431C /* 66.55.67.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4241310F /* 66.65.49.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x42554A7E /* 66.85.74.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x425A6575 /* 66.90.101.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x426EA84D /* 66.110.168.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x426F0210 /* 66.111.2.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x426F0214 /* 66.111.2.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x426F3E55 /* 66.111.62.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x42746CB3 /* 66.116.108.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4294745A /* 66.148.116.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x429B04D5 /* 66.155.4.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x42AA0BCB /* 66.170.11.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x42AC0CFE /* 66.172.12.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x42AFD94E /* 66.175.217.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x42AFDD18 /* 66.175.221.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x42AFDF91 /* 66.175.223.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x42B4C1DB /* 66.180.193.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x42BAE69A /* 66.186.230.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x42BE62FE /* 66.190.98.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x42D78E45 /* 66.215.142.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x42D7D4B0 /* 66.215.212.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x42DC03B3 /* 66.220.3.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x42DFA543 /* 66.223.165.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x42E42752 /* 66.228.39.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x42E42753 /* 66.228.39.83/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x42E433BA /* 66.228.51.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x42E43A14 /* 66.228.58.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x42EADAF7 /* 66.234.218.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x42EB073E /* 66.235.7.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x42F25CCB /* 66.242.92.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x42F64BA7 /* 66.246.75.167/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x430018B8 /* 67.0.24.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4316A2BA /* 67.22.162.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x435CADE3 /* 67.92.173.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x435CADE4 /* 67.92.173.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x435CADE5 /* 67.92.173.229/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x43A24B3C /* 67.162.75.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x43A46D15 /* 67.164.109.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x43AD7728 /* 67.173.119.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x43B49B15 /* 67.180.155.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x43B7FAD0 /* 67.183.250.208/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x43BA06AF /* 67.186.6.175/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x43BC2811 /* 67.188.40.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x43CD821B /* 67.205.130.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x43CD92A4 /* 67.205.146.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x43CDA785 /* 67.205.167.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x43D7FF8C /* 67.215.255.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x43E3C6B7 /* 67.227.198.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x43F1491A /* 67.241.73.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x43F56A30 /* 67.245.106.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x43F7FF21 /* 67.247.255.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x43F98A71 /* 67.249.138.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4405E096 /* 68.5.224.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x442AC1FC /* 68.42.193.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x44305597 /* 68.48.85.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x44441F0E /* 68.68.31.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4445A644 /* 68.69.166.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x44472E8A /* 68.71.46.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4466849E /* 68.102.132.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4468DE3A /* 68.104.222.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x446B4A1F /* 68.107.74.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x446BE751 /* 68.107.231.81/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x446D128D /* 68.109.18.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4481254C /* 68.129.37.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x44852C65 /* 68.133.44.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4494F65B /* 68.148.246.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4497A42B /* 68.151.164.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x44CE1486 /* 68.206.20.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x44E0F6A9 /* 68.224.246.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x44E0FCD2 /* 68.224.252.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x44E7DBD9 /* 68.231.219.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x450B0974 /* 69.11.9.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x45108914 /* 69.16.137.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x451C5A69 /* 69.28.90.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x451EC99E /* 69.30.201.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x451ECBFA /* 69.30.203.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x451ED66A /* 69.30.214.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x451ED6D2 /* 69.30.214.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x451ED72A /* 69.30.215.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x451ED7A2 /* 69.30.215.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x451EDABA /* 69.30.218.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x451EFCEE /* 69.30.252.238/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x452731C9 /* 69.39.49.201/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x452F3A0C /* 69.47.58.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x452FE688 /* 69.47.230.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x453D23B8 /* 69.61.35.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x453EA2B2 /* 69.62.162.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x45402E1B /* 69.64.46.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x454030A8 /* 69.64.48.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x454667CE /* 69.70.103.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x45544626 /* 69.84.70.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x45555CE0 /* 69.85.92.224/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x455A840A /* 69.90.132.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x455A840B /* 69.90.132.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x455A84B4 /* 69.90.132.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x455A84F8 /* 69.90.132.248/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x455A97E5 /* 69.90.151.229/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x455D630E /* 69.93.99.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x455D7F39 /* 69.93.127.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x45739110 /* 69.115.145.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4580A9E9 /* 69.128.169.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x458AA2C2 /* 69.138.162.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x458C8C8E /* 69.140.140.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x458FBA82 /* 69.143.186.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x45A26B05 /* 69.162.107.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x45A28B09 /* 69.162.139.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x45A323DE /* 69.163.35.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x45A3640C /* 69.163.100.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x45A4C35C /* 69.164.195.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x45A4C524 /* 69.164.197.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x45A4C567 /* 69.164.197.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x45A4C620 /* 69.164.198.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x45A4C6B5 /* 69.164.198.181/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x45A4CD93 /* 69.164.205.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x45A4CFEA /* 69.164.207.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x45A4D28C /* 69.164.210.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x45A4D28E /* 69.164.210.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x45A4D312 /* 69.164.211.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x45A4D4B4 /* 69.164.212.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x45A4D6C4 /* 69.164.214.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x45A4D6FA /* 69.164.214.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x45A4D852 /* 69.164.216.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x45A4D8E6 /* 69.164.216.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x45A4D961 /* 69.164.217.97/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x45A4DD41 /* 69.164.221.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x45A4DD4E /* 69.164.221.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x45A4DD99 /* 69.164.221.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x45ACAEB5 /* 69.172.174.181/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x45ACBA4F /* 69.172.186.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x45B58A79 /* 69.181.138.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x45C3929E /* 69.195.146.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x45C4A529 /* 69.196.165.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x45C4B929 /* 69.196.185.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x45F53BF4 /* 69.245.59.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x45F5D050 /* 69.245.208.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x46261F79 /* 70.38.31.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x463FAA56 /* 70.63.170.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x464FC330 /* 70.79.195.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x46551FF2 /* 70.85.31.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x465C56C0 /* 70.92.86.192/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x465F827F /* 70.95.130.127/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x465FBC58 /* 70.95.188.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x46705321 /* 70.112.83.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x46739B5C /* 70.115.155.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x46794F37 /* 70.121.79.55/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x467AD63B /* 70.122.214.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x467C9D6D /* 70.124.157.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x46A4C5CC /* 70.164.197.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x46A4FFAE /* 70.164.255.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x46A92268 /* 70.169.34.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x46BBAC10 /* 70.187.172.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x470EBC03 /* 71.14.188.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x470F2597 /* 71.15.37.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x471181CA /* 71.17.129.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x471390B8 /* 71.19.144.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x47139515 /* 71.19.149.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x47139A8A /* 71.19.154.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x47139BBB /* 71.19.155.187/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x47139D7F /* 71.19.157.127/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x47139DD5 /* 71.19.157.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x472EDC44 /* 71.46.220.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4738DCD9 /* 71.56.220.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x474F32B5 /* 71.79.50.181/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x475935A8 /* 71.89.53.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x475A52F3 /* 71.90.82.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x475B3B91 /* 71.91.59.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x475D67BC /* 71.93.103.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4787226D /* 71.135.34.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x47A59723 /* 71.165.151.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x47B3F68E /* 71.179.246.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x47BF5FD9 /* 71.191.95.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x47C7D0FA /* 71.199.208.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x47CCBC94 /* 71.204.188.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x47D4025A /* 71.212.2.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x47E4AABA /* 71.228.170.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x47E7860F /* 71.231.134.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x47EED615 /* 71.238.214.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x47F1FA34 /* 71.241.250.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x47F8B262 /* 71.248.178.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x47FC89F6 /* 71.252.137.246/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x480548E3 /* 72.5.72.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x480CCF0E /* 72.12.207.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x480EB30A /* 72.14.179.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x480EB70E /* 72.14.183.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x480EB915 /* 72.14.185.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x482E9BBA /* 72.46.155.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x48344B1B /* 72.52.75.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x48453A52 /* 72.69.58.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x48AE81B5 /* 72.174.129.181/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x48B39262 /* 72.179.146.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x48BCC700 /* 72.188.199.0/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x48C14756 /* 72.193.71.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x48C5066E /* 72.197.6.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x48CC5A10 /* 72.204.90.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x48DCA9A8 /* 72.220.169.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x48E6EBF9 /* 72.230.235.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x48EA9AA2 /* 72.234.154.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x48EE83EC /* 72.238.131.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x490403B2 /* 73.4.3.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x49141AF9 /* 73.20.26.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4918243A /* 73.24.36.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x492824AA /* 73.40.36.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x492D254B /* 73.45.37.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x493C39B8 /* 73.60.57.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x49425ED8 /* 73.66.94.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x494AD496 /* 73.74.212.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x494DD3B0 /* 73.77.211.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4959448A /* 73.89.68.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x495994B1 /* 73.89.148.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x495F534C /* 73.95.83.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4964011D /* 73.100.1.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x49999A11 /* 73.153.154.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x499D02CC /* 73.157.2.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x49A39AE2 /* 73.163.154.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x49A63404 /* 73.166.52.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x49AADDB8 /* 73.170.221.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x49B18E1A /* 73.177.142.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x49B28FEF /* 73.178.143.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x49BE15CA /* 73.190.21.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x49C0D90E /* 73.192.217.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x49C1F239 /* 73.193.242.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x49CA042A /* 73.202.4.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x49CB1E92 /* 73.203.30.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x49DAFBE3 /* 73.218.251.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x49EA0A84 /* 73.234.10.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x49EF52C1 /* 73.239.82.193/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x49F16918 /* 73.241.105.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4A03A527 /* 74.3.165.39/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4A323645 /* 74.50.54.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4A400746 /* 74.64.7.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4A41D5C0 /* 74.65.213.192/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4A4201CA /* 74.66.1.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4A43A511 /* 74.67.165.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4A47EA51 /* 74.71.234.81/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4A48CE45 /* 74.72.206.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4A498F92 /* 74.73.143.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4A5203E0 /* 74.82.3.224/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4A561813 /* 74.86.24.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4A5AF2A8 /* 74.90.242.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4A5B1502 /* 74.91.21.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4A62E668 /* 74.98.230.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4A6E911C /* 74.110.145.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4A74BA78 /* 74.116.186.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4A79B6CE /* 74.121.182.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4A8E4A9C /* 74.142.74.156/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4ACFE7BA /* 74.207.231.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4ACFECC5 /* 74.207.236.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4ACFED2C /* 74.207.237.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4ACFF01A /* 74.207.240.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4ACFF207 /* 74.207.242.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4ACFF2F7 /* 74.207.242.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4ACFF86E /* 74.207.248.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4AD04E82 /* 74.208.78.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4AD0DCDE /* 74.208.220.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4B484A7B /* 75.72.74.123/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4B57BF46 /* 75.87.191.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4B77FB0E /* 75.119.251.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4B7F6065 /* 75.127.96.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4B869AB1 /* 75.134.154.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4B877B4D /* 75.135.123.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4B897058 /* 75.137.112.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4B8F8310 /* 75.143.131.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4B8FBC3E /* 75.143.188.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4BA6543C /* 75.166.84.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4BA9D3F4 /* 75.169.211.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4BAF72B1 /* 75.175.114.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4BB02D57 /* 75.176.45.87/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4BC89768 /* 75.200.151.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4C09C0CC /* 76.9.192.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4C0A9D3A /* 76.10.157.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4C0AA1A6 /* 76.10.161.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4C0CDB68 /* 76.12.219.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4C1384A3 /* 76.19.132.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4C1ACBF3 /* 76.26.203.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4C49EAAD /* 76.73.234.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4C4DBABB /* 76.77.186.187/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4C5462F6 /* 76.84.98.246/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4C55C840 /* 76.85.200.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4C5E7309 /* 76.94.115.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4C7AFC1B /* 76.122.252.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4CA7D7E3 /* 76.167.215.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4CFBA499 /* 76.251.164.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4CFFCE24 /* 76.255.206.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D02B2B3 /* 77.2.178.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D0C660C /* 77.12.102.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D0C81F7 /* 77.12.129.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D0C9B56 /* 77.12.155.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D0CE6EA /* 77.12.230.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D1481EC /* 77.20.129.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D14B78D /* 77.20.183.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D152983 /* 77.21.41.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D157351 /* 77.21.115.81/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D16C1DF /* 77.22.193.223/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D172632 /* 77.23.38.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D172E1C /* 77.23.46.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D17C649 /* 77.23.198.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D17F590 /* 77.23.245.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D1B8CE4 /* 77.27.140.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D2588A5 /* 77.37.136.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D258EB3 /* 77.37.142.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D259207 /* 77.37.146.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D25A012 /* 77.37.160.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D25DA91 /* 77.37.218.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D25E45A /* 77.37.228.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D25F6E3 /* 77.37.246.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D3049BD /* 77.48.73.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D3049F6 /* 77.48.73.246/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D38B941 /* 77.56.185.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D397E24 /* 77.57.126.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D3A4995 /* 77.58.73.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D3A94FE /* 77.58.148.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D40E649 /* 77.64.230.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D420CB9 /* 77.66.12.185/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D440B2A /* 77.68.11.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D44245D /* 77.68.36.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D442A84 /* 77.68.42.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D463FDC /* 77.70.63.220/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D494033 /* 77.73.64.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D49426F /* 77.73.66.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D4A602B /* 77.74.96.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D4BA62B /* 77.75.166.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D4FBAED /* 77.79.186.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D51687C /* 77.81.104.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D516B8A /* 77.81.107.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D51F029 /* 77.81.240.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D52EF6E /* 77.82.239.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D59DC0A /* 77.89.220.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D5F0AF2 /* 77.95.10.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D67306F /* 77.103.48.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D6CCF29 /* 77.108.207.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D6D8B57 /* 77.109.139.87/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D77E033 /* 77.119.224.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D77E9B6 /* 77.119.233.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D77ECD5 /* 77.119.236.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D785EE9 /* 77.120.94.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D7A4F7E /* 77.122.79.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D800EF3 /* 77.128.14.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D806BEB /* 77.128.107.235/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D8C5D7F /* 77.140.93.127/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D8C7F44 /* 77.140.127.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4DA1229D /* 77.161.34.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4DAAE6A3 /* 77.170.230.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4DB0E4BC /* 77.176.228.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4DB31696 /* 77.179.22.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4DB34110 /* 77.179.65.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4DB37039 /* 77.179.112.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4DB41959 /* 77.180.25.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4DB55D29 /* 77.181.93.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4DB6972A /* 77.182.151.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4DBB53DC /* 77.187.83.220/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4DBBB8FE /* 77.187.184.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4DBC452F /* 77.188.69.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4DC0D245 /* 77.192.210.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4DC6638B /* 77.198.99.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4DCB0D39 /* 77.203.13.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4DE9EE82 /* 77.233.238.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4DEC2EA4 /* 77.236.46.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4DEC2EDA /* 77.236.46.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4DF69DA9 /* 77.246.157.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4DF6C13B /* 77.246.193.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4DF7B5A3 /* 77.247.181.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4DF7B5A5 /* 77.247.181.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4DF96756 /* 77.249.103.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4DFBEF7B /* 77.251.239.123/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4DFE0320 /* 77.254.3.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E08B0FE /* 78.8.176.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E15343A /* 78.21.52.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E184B35 /* 78.24.75.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E1FA429 /* 78.31.164.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2258DC /* 78.34.88.220/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E22BCE2 /* 78.34.188.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E242C36 /* 78.36.44.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E297391 /* 78.41.115.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2A36D3 /* 78.42.54.211/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E1617 /* 78.46.22.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E1E2B /* 78.46.30.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E2519 /* 78.46.37.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E251A /* 78.46.37.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E2DF2 /* 78.46.45.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E337C /* 78.46.51.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E350B /* 78.46.53.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E37E3 /* 78.46.55.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E3C1E /* 78.46.60.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E40F5 /* 78.46.64.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E434B /* 78.46.67.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E527B /* 78.46.82.123/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E5A17 /* 78.46.90.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E5F14 /* 78.46.95.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E70DB /* 78.46.112.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E8B99 /* 78.46.139.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E8BB6 /* 78.46.139.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E8D4A /* 78.46.141.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E913A /* 78.46.145.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E970B /* 78.46.151.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2EA233 /* 78.46.162.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2EA27B /* 78.46.162.123/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2EA2F6 /* 78.46.162.246/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2EB97C /* 78.46.185.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2EBD98 /* 78.46.189.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2EBDC3 /* 78.46.189.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2EC129 /* 78.46.193.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2EC21F /* 78.46.194.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2EC7B7 /* 78.46.199.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2ECB12 /* 78.46.203.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2ED170 /* 78.46.209.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2ED426 /* 78.46.212.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2EDC82 /* 78.46.220.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2EDD30 /* 78.46.221.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2EDF86 /* 78.46.223.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2EE12E /* 78.46.225.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2EEFB7 /* 78.46.239.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2EF61C /* 78.46.246.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2EF724 /* 78.46.247.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2EF947 /* 78.46.249.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F0915 /* 78.47.9.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F126E /* 78.47.18.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F1D44 /* 78.47.29.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F2323 /* 78.47.35.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F273C /* 78.47.39.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F3D5E /* 78.47.61.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F3D81 /* 78.47.61.129/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F3DDE /* 78.47.61.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F405B /* 78.47.64.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F4093 /* 78.47.64.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F467B /* 78.47.70.123/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F5462 /* 78.47.84.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F56D2 /* 78.47.86.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F5D16 /* 78.47.93.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F659D /* 78.47.101.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F86C3 /* 78.47.134.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F86C4 /* 78.47.134.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F883E /* 78.47.136.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F8ED3 /* 78.47.142.211/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2FA743 /* 78.47.167.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2FAE9B /* 78.47.174.155/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2FB04A /* 78.47.176.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2FDABE /* 78.47.218.190/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2FDD47 /* 78.47.221.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2FE0DB /* 78.47.224.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2FE0DE /* 78.47.224.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2FE101 /* 78.47.225.1/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2FE56B /* 78.47.229.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2FEF50 /* 78.47.239.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2FF9E2 /* 78.47.249.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E303064 /* 78.48.48.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E33FF42 /* 78.51.255.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E354732 /* 78.53.71.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E361CA0 /* 78.54.28.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E371126 /* 78.55.17.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E37D9C6 /* 78.55.217.198/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E382816 /* 78.56.40.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E387C10 /* 78.56.124.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E3A9597 /* 78.58.149.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E44EA63 /* 78.68.234.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E460AE6 /* 78.70.10.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E4993FD /* 78.73.147.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E5347A6 /* 78.83.71.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E54FD7A /* 78.84.253.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E5859F2 /* 78.88.89.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E5A0FE5 /* 78.90.15.229/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E5AE3E4 /* 78.90.227.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E5E456A /* 78.94.69.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E5E4AEC /* 78.94.74.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E5E5CAA /* 78.94.92.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E660C17 /* 78.102.12.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E6AF999 /* 78.106.249.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E6BED10 /* 78.107.237.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E6BEFD5 /* 78.107.239.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E6C2E72 /* 78.108.46.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E6C2E82 /* 78.108.46.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E6C2E83 /* 78.108.46.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E6C426E /* 78.108.66.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E6C4D56 /* 78.108.77.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E7502F4 /* 78.117.2.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E783339 /* 78.120.51.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E7C9F3B /* 78.124.159.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E7DFAE3 /* 78.125.250.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E81891C /* 78.129.137.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E81ED55 /* 78.129.237.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E82806A /* 78.130.128.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E82C387 /* 78.130.195.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E833886 /* 78.131.56.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E8E130B /* 78.142.19.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E8E13D7 /* 78.142.19.215/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E8E13E2 /* 78.142.19.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E8E8EF6 /* 78.142.142.246/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E8E918D /* 78.142.145.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E8EAF46 /* 78.142.175.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E9515EA /* 78.149.21.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E9C6E87 /* 78.156.110.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E9C75EC /* 78.156.117.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4EC07C94 /* 78.192.124.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4EC128CD /* 78.193.40.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4EC18C04 /* 78.193.140.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4EC1DA61 /* 78.193.218.97/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4EC2251D /* 78.194.37.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4EC2984B /* 78.194.152.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4EC2DC36 /* 78.194.220.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4EC6B4CD /* 78.198.180.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4EC827AF /* 78.200.39.175/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4EC89C77 /* 78.200.156.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4ED59256 /* 78.213.146.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4EDDDF3A /* 78.221.223.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4EDF9B68 /* 78.223.155.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4EE722BC /* 78.231.34.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4EE8E1A3 /* 78.232.225.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4EE96597 /* 78.233.101.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4EF8D759 /* 78.248.215.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F286537 /* 79.40.101.55/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F358078 /* 79.53.128.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F386648 /* 79.56.102.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F442316 /* 79.68.35.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F626912 /* 79.98.105.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F626C39 /* 79.98.108.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F626D30 /* 79.98.109.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F6FAB73 /* 79.111.171.115/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F703775 /* 79.112.55.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F73D242 /* 79.115.210.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F780A62 /* 79.120.10.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F782993 /* 79.120.41.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F7851B7 /* 79.120.81.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F785566 /* 79.120.85.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F7C070B /* 79.124.7.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F7C152D /* 79.124.21.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F7C3BC2 /* 79.124.59.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F7C3C84 /* 79.124.60.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F84E8B3 /* 79.132.232.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F85D20B /* 79.133.210.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F86EAF7 /* 79.134.234.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F86FFC8 /* 79.134.255.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F88014A /* 79.136.1.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F881D2B /* 79.136.29.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F88465D /* 79.136.70.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F88467D /* 79.136.70.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F889972 /* 79.136.153.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F892169 /* 79.137.33.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F892183 /* 79.137.33.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F892395 /* 79.137.35.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F892727 /* 79.137.39.39/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F894E65 /* 79.137.78.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F894F1F /* 79.137.79.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F895042 /* 79.137.80.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F8951A8 /* 79.137.81.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F895547 /* 79.137.85.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F8957D4 /* 79.137.87.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F8957D5 /* 79.137.87.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F896A9A /* 79.137.106.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F897004 /* 79.137.112.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F897005 /* 79.137.112.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F89742B /* 79.137.116.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F8C290D /* 79.140.41.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F8C2975 /* 79.140.41.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F8C2976 /* 79.140.41.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F8FB287 /* 79.143.178.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F8FB72C /* 79.143.183.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F8FBA11 /* 79.143.186.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F9ADC72 /* 79.154.220.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FA1F802 /* 79.161.248.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FA53834 /* 79.165.56.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FA5B4F3 /* 79.165.180.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FA9225F /* 79.169.34.95/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FAC1212 /* 79.172.18.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FAC1CCD /* 79.172.28.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FACC120 /* 79.172.193.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FACCC24 /* 79.172.204.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FB07031 /* 79.176.112.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FB1769C /* 79.177.118.156/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FC1CF94 /* 79.193.207.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FC4F70C /* 79.196.247.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FC56DEA /* 79.197.109.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FC5CD8D /* 79.197.205.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FC6AE73 /* 79.198.174.115/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FCB5108 /* 79.203.81.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FCC8FCE /* 79.204.143.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FCC931C /* 79.204.147.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FCD1428 /* 79.205.20.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FCDE527 /* 79.205.229.39/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FCFE3CA /* 79.207.227.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FD04520 /* 79.208.69.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FD26917 /* 79.210.105.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FD3FCD9 /* 79.211.252.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FD44F49 /* 79.212.79.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FD6F2FD /* 79.214.242.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FD99C2A /* 79.217.156.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FDA50AA /* 79.218.80.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FDEC135 /* 79.222.193.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FDEF68C /* 79.222.246.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FE0586C /* 79.224.88.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FE1D1EA /* 79.225.209.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FE3834A /* 79.227.131.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FE3DEAF /* 79.227.222.175/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FE5C065 /* 79.229.192.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FE75712 /* 79.231.87.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FE77B42 /* 79.231.123.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FE7E4AA /* 79.231.228.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FE96869 /* 79.233.104.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FE9BD96 /* 79.233.189.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FE9D01A /* 79.233.208.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FEAB928 /* 79.234.185.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FEE3FEE /* 79.238.63.238/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FEFCB56 /* 79.239.203.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FEFF6BC /* 79.239.246.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FF0E1D2 /* 79.240.225.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FF1C20A /* 79.241.194.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FF1CEA5 /* 79.241.206.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FF1F58B /* 79.241.245.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FF34FCE /* 79.243.79.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FF7728E /* 79.247.114.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FF78368 /* 79.247.131.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FF89FC8 /* 79.248.159.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x500736BB /* 80.7.54.187/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x500C5EB8 /* 80.12.94.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x500F627F /* 80.15.98.127/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x501ACE0B /* 80.26.206.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x501F4713 /* 80.31.71.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x501FF2DA /* 80.31.242.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x503CF5EA /* 80.60.245.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50404119 /* 80.64.65.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5042877B /* 80.66.135.123/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5043ACA2 /* 80.67.172.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50445CF9 /* 80.68.92.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50478339 /* 80.71.131.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50478577 /* 80.71.133.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50478C09 /* 80.71.140.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5049F28E /* 80.73.242.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x504F1707 /* 80.79.23.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50510C1D /* 80.81.12.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5051111F /* 80.81.17.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5051F378 /* 80.81.243.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5051F3EB /* 80.81.243.235/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x505242E9 /* 80.82.66.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50555417 /* 80.85.84.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50555448 /* 80.85.84.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x505554DE /* 80.85.84.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x505AFA45 /* 80.90.250.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5062B2B4 /* 80.98.178.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x506300DF /* 80.99.0.223/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50634673 /* 80.99.70.115/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5063A98E /* 80.99.169.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50640799 /* 80.100.7.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50649D29 /* 80.100.157.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5064FAF4 /* 80.100.250.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x506589DF /* 80.101.137.223/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x506C120B /* 80.108.18.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x506C1DAF /* 80.108.29.175/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x506C8F13 /* 80.108.143.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x506CC3FA /* 80.108.195.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x506DD102 /* 80.109.209.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x506DF964 /* 80.109.249.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5072219A /* 80.114.33.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5074C31C /* 80.116.195.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50778941 /* 80.119.137.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x507A5A2E /* 80.122.90.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x507F6B9A /* 80.127.107.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x507F6BB3 /* 80.127.107.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x507F6D32 /* 80.127.109.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x507F75B4 /* 80.127.117.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x507F765D /* 80.127.118.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x507F80BE /* 80.127.128.190/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x507F8913 /* 80.127.137.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x507F8F5A /* 80.127.143.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x507F97A2 /* 80.127.151.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5083F110 /* 80.131.241.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x508649F1 /* 80.134.73.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50887E89 /* 80.136.126.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5088A7B2 /* 80.136.167.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50895F35 /* 80.137.95.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x508C60BE /* 80.140.96.190/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x508DE120 /* 80.141.225.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5090E36A /* 80.144.227.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5091EE43 /* 80.145.238.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5093219D /* 80.147.33.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5093BE2F /* 80.147.190.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50990704 /* 80.153.7.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5099125B /* 80.153.18.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5099F1A9 /* 80.153.241.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50A22B48 /* 80.162.43.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50A9F14C /* 80.169.241.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50C2115C /* 80.194.17.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50CB8917 /* 80.203.137.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50DA541C /* 80.218.84.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50DABABF /* 80.218.186.191/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50DB0012 /* 80.219.0.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50DC141F /* 80.220.20.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50DC5AA8 /* 80.220.90.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50DCEA3F /* 80.220.234.63/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50E58CEF /* 80.229.140.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50E598E4 /* 80.229.152.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50E8CDD6 /* 80.232.205.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50E8F21F /* 80.232.242.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50E98632 /* 80.233.134.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50E98695 /* 80.233.134.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50EC3338 /* 80.236.51.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50EDE786 /* 80.237.231.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50EE7A6A /* 80.238.122.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50F086F6 /* 80.240.134.246/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50F08B6F /* 80.240.139.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50F0D8FD /* 80.240.216.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50F13CCF /* 80.241.60.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50F1DCDD /* 80.241.220.221/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50F368B6 /* 80.243.104.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50F451BF /* 80.244.81.191/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50F4F1FE /* 80.244.241.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50F4F39E /* 80.244.243.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50F8D083 /* 80.248.208.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50F8F02B /* 80.248.240.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50FEDB30 /* 80.254.219.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50FF060B /* 80.255.6.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50FF0BC4 /* 80.255.11.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51003B92 /* 81.0.59.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5100E203 /* 81.0.226.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5102C521 /* 81.2.197.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5102D10A /* 81.2.209.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5102EDDA /* 81.2.237.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5102F777 /* 81.2.247.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5102F7A5 /* 81.2.247.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5104655D /* 81.4.101.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x510467AA /* 81.4.103.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51046CC7 /* 81.4.108.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51046D2F /* 81.4.109.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51046DD0 /* 81.4.109.208/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51046E95 /* 81.4.110.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51047930 /* 81.4.121.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51047D0D /* 81.4.125.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5107038D /* 81.7.3.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x510703F7 /* 81.7.3.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51070A14 /* 81.7.10.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51070A1D /* 81.7.10.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51070A44 /* 81.7.10.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51070A5D /* 81.7.10.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51070AFB /* 81.7.10.251/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51070B16 /* 81.7.11.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51070B46 /* 81.7.11.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51070B8E /* 81.7.11.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51070B9A /* 81.7.11.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51070BFD /* 81.7.11.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51070D54 /* 81.7.13.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51070DF8 /* 81.7.13.248/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51070E19 /* 81.7.14.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51070EE3 /* 81.7.14.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5107101F /* 81.7.16.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5107103B /* 81.7.16.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5107108B /* 81.7.16.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x510710B1 /* 81.7.16.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x510710B6 /* 81.7.16.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51071254 /* 81.7.18.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x510A8C06 /* 81.10.140.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x510A9F12 /* 81.10.159.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5111102B /* 81.17.16.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51111182 /* 81.17.17.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51111183 /* 81.17.17.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51111E21 /* 81.17.30.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51111E2C /* 81.17.30.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51111E30 /* 81.17.30.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51130347 /* 81.19.3.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5116FF92 /* 81.22.255.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x511738FF /* 81.23.56.255/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51193683 /* 81.25.54.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x511E9E51 /* 81.30.158.81/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x511E9E90 /* 81.30.158.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x511E9ED5 /* 81.30.158.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x511E9EDF /* 81.30.158.223/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51218578 /* 81.33.133.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5125E02A /* 81.37.224.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5138C0E7 /* 81.56.192.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5139D087 /* 81.57.208.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5142884E /* 81.66.136.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5142CC1C /* 81.66.204.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x515900C3 /* 81.89.0.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x515900C4 /* 81.89.0.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x515900C5 /* 81.89.0.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x515900C6 /* 81.89.0.198/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x515900C7 /* 81.89.0.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x515900C8 /* 81.89.0.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x515900C9 /* 81.89.0.201/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x515900CA /* 81.89.0.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x515900CB /* 81.89.0.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x515900CC /* 81.89.0.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51593F96 /* 81.89.63.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x515F0D37 /* 81.95.13.55/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x515F3444 /* 81.95.52.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51618FF7 /* 81.97.143.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51672409 /* 81.103.36.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5184FFEF /* 81.132.255.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x518DE01A /* 81.141.224.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5195968F /* 81.149.150.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5199E91D /* 81.153.233.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x519B2F59 /* 81.155.47.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x519F452C /* 81.159.69.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51A46265 /* 81.164.98.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51A982D6 /* 81.169.130.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51A988CE /* 81.169.136.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51A98A33 /* 81.169.138.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51A98DDE /* 81.169.141.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51A99864 /* 81.169.152.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51A9A64A /* 81.169.166.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51A9AFA4 /* 81.169.175.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51A9B55F /* 81.169.181.95/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51A9B9E9 /* 81.169.185.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51A9DE9E /* 81.169.222.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51A9F6CC /* 81.169.246.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51AA841C /* 81.170.132.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51AA94C2 /* 81.170.148.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51AD9793 /* 81.173.151.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51AE962B /* 81.174.150.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51AE97D7 /* 81.174.151.215/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51AE9B2F /* 81.174.155.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51AEE712 /* 81.174.231.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51AFDB02 /* 81.175.219.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51AFDDCF /* 81.175.221.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51B77151 /* 81.183.113.81/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51BE6077 /* 81.190.96.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51C14B5B /* 81.193.75.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51D9121D /* 81.217.18.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51D920C1 /* 81.217.32.193/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51D9BB06 /* 81.217.187.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51DA5B9A /* 81.218.91.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51DA6DC3 /* 81.218.109.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51DA8A03 /* 81.218.138.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51DD947F /* 81.221.148.127/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51E3D84C /* 81.227.216.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51E4C09D /* 81.228.192.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51E4C74B /* 81.228.199.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51E66CC0 /* 81.230.108.192/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51E6A691 /* 81.230.166.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51E81EC2 /* 81.232.30.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51ECAF80 /* 81.236.175.128/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51F34BD0 /* 81.243.75.208/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51F52A42 /* 81.245.42.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51F5E6FD /* 81.245.230.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51FEAF31 /* 81.254.175.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52018046 /* 82.1.128.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52052A69 /* 82.5.42.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x520BAC32 /* 82.11.172.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5215D31D /* 82.21.211.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x521B7682 /* 82.27.118.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x521CE407 /* 82.28.228.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52290A87 /* 82.41.10.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x522CCB7C /* 82.44.203.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5231CF20 /* 82.49.207.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52433720 /* 82.67.55.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52449FD9 /* 82.68.159.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52454C23 /* 82.69.76.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5247D30D /* 82.71.211.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5247F64F /* 82.71.246.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x524CB63D /* 82.76.182.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52502163 /* 82.80.33.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52503640 /* 82.80.54.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5252BED7 /* 82.82.190.215/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x525ECCAA /* 82.94.204.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x525EE292 /* 82.94.226.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x525EFBE3 /* 82.94.251.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x525F42CB /* 82.95.66.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x525F6B33 /* 82.95.107.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52668ED2 /* 82.102.142.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52678C57 /* 82.103.140.87/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5273740B /* 82.115.116.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52747803 /* 82.116.120.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5276F20E /* 82.118.242.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5276F215 /* 82.118.242.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5276F27F /* 82.118.242.127/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5276F280 /* 82.118.242.128/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5276F293 /* 82.118.242.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5277E924 /* 82.119.233.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5282090F /* 82.130.9.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52820B94 /* 82.130.11.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52820D9A /* 82.130.13.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52834A12 /* 82.131.74.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x528B60C9 /* 82.139.96.201/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x529225CC /* 82.146.37.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52922F11 /* 82.146.47.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x529237CD /* 82.146.55.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5295F13D /* 82.149.241.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x529B43BE /* 82.155.67.190/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x529EA2AB /* 82.158.162.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52A1321E /* 82.161.50.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52A1B614 /* 82.161.182.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52A1D257 /* 82.161.210.87/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52A1D4D1 /* 82.161.212.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52A58E4F /* 82.165.142.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52A594A3 /* 82.165.148.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52A5CF66 /* 82.165.207.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52A80E92 /* 82.168.14.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52B301A2 /* 82.179.1.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52B574C7 /* 82.181.116.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52B5D46A /* 82.181.212.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52B5E7C4 /* 82.181.231.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52B5EE90 /* 82.181.238.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52C2AA1E /* 82.194.170.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52C406C7 /* 82.196.6.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52C4080D /* 82.196.8.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52C408E8 /* 82.196.8.232/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52C40E8E /* 82.196.14.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52C46AA0 /* 82.196.106.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52C47CC2 /* 82.196.124.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52C79B59 /* 82.199.155.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52CFED13 /* 82.207.237.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52D1B3A3 /* 82.209.179.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52D300B4 /* 82.211.0.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52D300C9 /* 82.211.0.201/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52D3138F /* 82.211.19.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52D31FF7 /* 82.211.31.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52D40E20 /* 82.212.14.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52D5DEEA /* 82.213.222.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52D9D6D7 /* 82.217.214.215/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52DB0959 /* 82.219.9.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52DC5935 /* 82.220.89.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52DD6543 /* 82.221.101.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52DD69C6 /* 82.221.105.198/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52DD8014 /* 82.221.128.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52DD80D9 /* 82.221.128.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52DD8B19 /* 82.221.139.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52DD8BBE /* 82.221.139.190/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52DF154A /* 82.223.21.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52E092B3 /* 82.224.146.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52E2473B /* 82.226.71.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52E28C77 /* 82.226.140.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52E4FC14 /* 82.228.252.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52E51AEB /* 82.229.26.235/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52E58A1F /* 82.229.138.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52E58A8F /* 82.229.138.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52E97597 /* 82.233.117.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52EE55F0 /* 82.238.85.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52EF01CD /* 82.239.1.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52F25792 /* 82.242.87.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52F298D3 /* 82.242.152.211/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52F385B4 /* 82.243.133.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52F4B127 /* 82.244.177.39/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52F7C6E3 /* 82.247.198.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52FA03EC /* 82.250.3.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52FB1146 /* 82.251.17.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52FB2188 /* 82.251.33.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5321BD8F /* 83.33.189.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53240901 /* 83.36.9.1/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x532CCF03 /* 83.44.207.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x533776BF /* 83.55.118.191/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x533FF441 /* 83.63.244.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5345F255 /* 83.69.242.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x534D9DFE /* 83.77.157.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53528CF1 /* 83.82.140.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5352EA6A /* 83.82.234.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5353FB49 /* 83.83.251.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x535573E3 /* 83.85.115.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5355FC37 /* 83.85.252.55/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53567804 /* 83.86.120.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x535969A0 /* 83.89.105.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53802930 /* 83.128.41.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x538632D0 /* 83.134.50.208/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5386E05A /* 83.134.224.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53885104 /* 83.136.81.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x538FF556 /* 83.143.245.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5391F1E7 /* 83.145.241.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5392F130 /* 83.146.241.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53951426 /* 83.149.20.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53960BCB /* 83.150.11.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x539613F3 /* 83.150.19.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5396527A /* 83.150.82.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x539A832B /* 83.154.131.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53A08BB7 /* 83.160.139.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53A1DAE2 /* 83.161.218.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53A22F1A /* 83.162.47.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53A2B243 /* 83.162.178.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53A2BC64 /* 83.162.188.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53A2C73C /* 83.162.199.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53A2CAB6 /* 83.162.202.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53A2CD44 /* 83.162.205.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53A34DC3 /* 83.163.77.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53A3C9A8 /* 83.163.201.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53A7B923 /* 83.167.185.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53A8C8CC /* 83.168.200.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53A9060C /* 83.169.6.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53ABA70D /* 83.171.167.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53AF6482 /* 83.175.100.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53CDEECD /* 83.205.238.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53D45257 /* 83.212.82.87/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53D45296 /* 83.212.82.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53D460B7 /* 83.212.96.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53D460CE /* 83.212.96.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53D46344 /* 83.212.99.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53D463D4 /* 83.212.99.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53D46464 /* 83.212.100.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53D46612 /* 83.212.102.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53D46672 /* 83.212.102.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53D4687C /* 83.212.104.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53D46891 /* 83.212.104.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53D46990 /* 83.212.105.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53D473E0 /* 83.212.115.224/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53D47661 /* 83.212.118.97/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53D4A8BA /* 83.212.168.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53DCB3AF /* 83.220.179.175/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53E336EA /* 83.227.54.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53E45D4C /* 83.228.93.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53E71225 /* 83.231.18.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53E94C6F /* 83.233.76.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53F065D1 /* 83.240.101.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53F74E5A /* 83.247.78.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53F82268 /* 83.248.34.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53F85AD3 /* 83.248.90.211/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53F8A8D8 /* 83.248.168.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53FB4937 /* 83.251.73.55/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53FC534F /* 83.252.83.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53FD0764 /* 83.253.7.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53FD3E77 /* 83.253.62.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53FD8858 /* 83.253.136.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53FE5D4E /* 83.254.93.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53FECFC5 /* 83.254.207.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53FF6C65 /* 83.255.108.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54030035 /* 84.3.0.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5413B24F /* 84.19.178.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5413B269 /* 84.19.178.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5413B29B /* 84.19.178.155/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5413B36A /* 84.19.179.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5413B3E5 /* 84.19.179.229/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5413B487 /* 84.19.180.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5413B881 /* 84.19.184.129/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5413BDF2 /* 84.19.189.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5413BE9D /* 84.19.190.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x541B5F35 /* 84.27.95.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x542862BB /* 84.40.98.187/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54287046 /* 84.40.112.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x542E1498 /* 84.46.20.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x542E1E4A /* 84.46.30.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x542E1EF5 /* 84.46.30.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5430C74E /* 84.48.199.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5435F7A9 /* 84.53.247.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5437525E /* 84.55.82.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54382D7B /* 84.56.45.123/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54398A2E /* 84.57.138.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x543C2DE8 /* 84.60.45.232/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x543D3004 /* 84.61.48.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x543D5E07 /* 84.61.94.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x543F40DB /* 84.63.64.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54482813 /* 84.72.40.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54490F5C /* 84.73.15.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54491458 /* 84.73.20.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5449149D /* 84.73.20.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5449244A /* 84.73.36.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5449DC41 /* 84.73.220.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x544A50D2 /* 84.74.80.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x544B19CA /* 84.75.25.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x544B44EB /* 84.75.68.235/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x544BC8E5 /* 84.75.200.229/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x544BE77C /* 84.75.231.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54505045 /* 84.80.80.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x545C6161 /* 84.92.97.97/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5468BF39 /* 84.104.191.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x546AEA98 /* 84.106.234.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x546B6E0C /* 84.107.110.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54702924 /* 84.112.41.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54720336 /* 84.114.3.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5472B966 /* 84.114.185.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x547323F8 /* 84.115.35.248/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5476AF83 /* 84.118.175.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54774190 /* 84.119.65.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5482A597 /* 84.130.165.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5484E3F1 /* 84.132.227.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54865441 /* 84.134.84.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x548945CA /* 84.137.69.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x548D7630 /* 84.141.118.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x548FD821 /* 84.143.216.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x548FDE8F /* 84.143.222.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54904522 /* 84.144.69.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x549073D9 /* 84.144.115.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5490E8AC /* 84.144.232.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5492A167 /* 84.146.161.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x549665CA /* 84.150.101.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x549675DA /* 84.150.117.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x549A7446 /* 84.154.116.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x549ABD38 /* 84.154.189.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x549C028A /* 84.156.2.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x549CBC46 /* 84.156.188.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x549EC45B /* 84.158.196.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x549F49CE /* 84.159.73.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x549F4C3F /* 84.159.76.63/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54A09ACC /* 84.160.154.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54A21CE2 /* 84.162.28.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54A5409F /* 84.165.64.159/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54A8F9D7 /* 84.168.249.215/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54AB51E6 /* 84.171.81.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54AB5BC7 /* 84.171.91.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54ADDF9F /* 84.173.223.159/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54AE63C4 /* 84.174.99.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54B0EA0E /* 84.176.234.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54B0FB8A /* 84.176.251.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54B166C5 /* 84.177.102.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54B4603C /* 84.180.96.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54B6A117 /* 84.182.161.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54B6BFDF /* 84.182.191.223/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54B7EEC3 /* 84.183.238.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54BA3653 /* 84.186.54.83/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54BB8B4A /* 84.187.139.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54BCA06A /* 84.188.160.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54BF23C8 /* 84.191.35.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54BFF098 /* 84.191.240.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54C10029 /* 84.193.0.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54C3E5B6 /* 84.195.229.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54C80821 /* 84.200.8.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54C808CF /* 84.200.8.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54C80ECE /* 84.200.14.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54C83212 /* 84.200.50.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54C83822 /* 84.200.56.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54C83824 /* 84.200.56.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54C84DF3 /* 84.200.77.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54C852A3 /* 84.200.82.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54C8CE63 /* 84.200.206.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54CA5A7A /* 84.202.90.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54CA74A4 /* 84.202.116.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54D11ABA /* 84.209.26.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54D6DC87 /* 84.214.220.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54D7A360 /* 84.215.163.96/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54D8E951 /* 84.216.233.81/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54D8FCC8 /* 84.216.252.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54DBF8F9 /* 84.219.248.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54E20D1B /* 84.226.13.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54E27D07 /* 84.226.125.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54E3DA07 /* 84.227.218.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54E61807 /* 84.230.24.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54EC35E6 /* 84.236.53.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54ED96AB /* 84.237.150.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54F03CEA /* 84.240.60.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54F14114 /* 84.241.65.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54F41F34 /* 84.244.31.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54F50FFD /* 84.245.15.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54F51940 /* 84.245.25.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54F51BD1 /* 84.245.27.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54F51E9A /* 84.245.30.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54F848E7 /* 84.248.72.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54F900C1 /* 84.249.0.193/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54F910D7 /* 84.249.16.215/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54F9C7E6 /* 84.249.199.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54FA1259 /* 84.250.18.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54FA720A /* 84.250.114.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54FB54F3 /* 84.251.84.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55002B59 /* 85.0.43.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55004029 /* 85.0.64.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55047E83 /* 85.4.126.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5507B414 /* 85.7.180.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x550A6A2F /* 85.10.106.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x550AC409 /* 85.10.196.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x550AC40C /* 85.10.196.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x550AC6EC /* 85.10.198.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x550AC92F /* 85.10.201.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x550ACA57 /* 85.10.202.87/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x550ACB47 /* 85.10.203.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x550ACBAB /* 85.10.203.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x550AF0FA /* 85.10.240.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x550EF337 /* 85.14.243.55/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x550EF9F7 /* 85.14.249.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5510AA7D /* 85.16.170.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55111A05 /* 85.17.26.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55117020 /* 85.17.112.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x551170A3 /* 85.17.112.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5511A4A5 /* 85.17.164.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5511A4AC /* 85.17.164.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5511AC4B /* 85.17.172.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5511C2B4 /* 85.17.194.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5511D6B1 /* 85.17.214.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x551590E0 /* 85.21.144.224/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55189139 /* 85.24.145.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5518A288 /* 85.24.162.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5518B4C8 /* 85.24.180.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55192C8D /* 85.25.44.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55196745 /* 85.25.103.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55198405 /* 85.25.132.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55198522 /* 85.25.133.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x551995A1 /* 85.25.149.161/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x551996D8 /* 85.25.150.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55199F41 /* 85.25.159.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55199FFD /* 85.25.159.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5519D5D3 /* 85.25.213.211/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5519F86C /* 85.25.248.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5519FF8C /* 85.25.255.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x551FBAA4 /* 85.31.186.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x551FBAFD /* 85.31.186.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55305EAE /* 85.48.94.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5556DA1B /* 85.86.218.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x555AF417 /* 85.90.244.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x555AF61E /* 85.90.246.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x555D102F /* 85.93.16.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x555D118F /* 85.93.17.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x555DD12C /* 85.93.209.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x555DD914 /* 85.93.217.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x555DDACC /* 85.93.218.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5571279A /* 85.113.39.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55728560 /* 85.114.133.96/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55775297 /* 85.119.82.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5577538D /* 85.119.83.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x557F54E9 /* 85.127.84.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x558398DD /* 85.131.152.221/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x558CB60C /* 85.140.182.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x558FD2E9 /* 85.143.210.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x558FDBD3 /* 85.143.219.211/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55902C37 /* 85.144.44.55/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5591AD1F /* 85.145.173.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5598E41D /* 85.152.228.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x559D7EA2 /* 85.157.126.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x559FD337 /* 85.159.211.55/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x559FEDD2 /* 85.159.237.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55A53635 /* 85.165.54.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55A71195 /* 85.167.17.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55ABADA1 /* 85.171.173.161/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55B584A4 /* 85.181.132.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55B8A080 /* 85.184.160.128/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55BEFF04 /* 85.190.255.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55BFF855 /* 85.191.248.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55C36BFA /* 85.195.107.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55C3CF6F /* 85.195.207.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55C3D709 /* 85.195.215.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55C3EB78 /* 85.195.235.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55C3F28A /* 85.195.242.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55C3F2E2 /* 85.195.242.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55C3FC68 /* 85.195.252.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55C3FCC6 /* 85.195.252.198/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D4009E /* 85.212.0.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D406BD /* 85.212.6.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D42363 /* 85.212.35.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D42B74 /* 85.212.43.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D42DB8 /* 85.212.45.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D4395F /* 85.212.57.95/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D617BC /* 85.214.23.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D62CAC /* 85.214.44.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D636FE /* 85.214.54.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D63AEC /* 85.214.58.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D63E30 /* 85.214.62.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D6407E /* 85.214.64.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D642BB /* 85.214.66.187/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D6454B /* 85.214.69.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D665E9 /* 85.214.101.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D66C5F /* 85.214.108.95/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D673D6 /* 85.214.115.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D67CA8 /* 85.214.124.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D67D0B /* 85.214.125.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D680A0 /* 85.214.128.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D680C7 /* 85.214.128.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D6907F /* 85.214.144.127/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D6909F /* 85.214.144.159/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D69748 /* 85.214.151.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D6CEDB /* 85.214.206.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D6E5B0 /* 85.214.229.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D6ECCF /* 85.214.236.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D6F40D /* 85.214.244.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D809FE /* 85.216.9.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D85A76 /* 85.216.90.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55DC2AC3 /* 85.220.42.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55DCBEF6 /* 85.220.190.246/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55DE00E5 /* 85.222.0.229/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55E2753E /* 85.226.117.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55E279EB /* 85.226.121.235/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55E3814C /* 85.227.129.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55E3BABD /* 85.227.186.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55E3BC91 /* 85.227.188.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55E3BCCD /* 85.227.188.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55E44587 /* 85.228.69.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55E55450 /* 85.229.84.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55E55FF1 /* 85.229.95.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55E5E4AE /* 85.229.228.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55E61558 /* 85.230.21.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55E6887E /* 85.230.136.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55E6EF64 /* 85.230.239.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55EBFA58 /* 85.235.250.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55F09F14 /* 85.240.159.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55F0FFE6 /* 85.240.255.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55F23B3B /* 85.242.59.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55F567DE /* 85.245.103.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55F8E3A3 /* 85.248.227.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55F8E3A4 /* 85.248.227.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55F8E3A5 /* 85.248.227.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55FF019E /* 85.255.1.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55FF0863 /* 85.255.8.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x56037EC1 /* 86.3.126.193/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x56078C1F /* 86.7.140.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x561277B3 /* 86.18.119.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x561704E0 /* 86.23.4.224/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5619641D /* 86.25.100.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x561DD073 /* 86.29.208.115/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x563864B9 /* 86.56.100.185/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x563B1526 /* 86.59.21.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x563B15A3 /* 86.59.21.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x563B7753 /* 86.59.119.83/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x563B7758 /* 86.59.119.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x563BA563 /* 86.59.165.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5646384E /* 86.70.56.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x564C4BF0 /* 86.76.75.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5653791D /* 86.83.121.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x56537ACB /* 86.83.122.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5656AD3E /* 86.86.173.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x565820C7 /* 86.88.32.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x56582191 /* 86.88.33.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x56657F7A /* 86.101.127.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5667BC2F /* 86.103.188.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x56680F0F /* 86.104.15.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5669D482 /* 86.105.212.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5669D4CC /* 86.105.212.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x566A8906 /* 86.106.137.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x566B6E22 /* 86.107.110.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x566B6E52 /* 86.107.110.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x566B6E8F /* 86.107.110.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x566B6EE0 /* 86.107.110.224/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x566E7549 /* 86.110.117.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x566E7595 /* 86.110.117.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x567BDFAE /* 86.123.223.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x567DE7E3 /* 86.125.231.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x56805BEF /* 86.128.91.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5687B16A /* 86.135.177.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x568EFA19 /* 86.142.250.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5699F453 /* 86.153.244.83/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x569BDBB7 /* 86.155.219.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x56AC5B6A /* 86.172.91.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x56AE499A /* 86.174.73.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x56B3C248 /* 86.179.194.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x56CA8ED2 /* 86.202.142.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x56CAE27C /* 86.202.226.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x56E53486 /* 86.229.52.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x56EE99B7 /* 86.238.153.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x56EEDDD9 /* 86.238.221.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x56F56FEC /* 86.245.111.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x56F6018B /* 86.246.1.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x56F6AC32 /* 86.246.172.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x56FD45C5 /* 86.253.69.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5702EC23 /* 87.2.236.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57056E71 /* 87.5.110.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57071528 /* 87.7.21.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5714C5DD /* 87.20.197.221/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57340321 /* 87.52.3.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x573CAC5C /* 87.60.172.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x574849E7 /* 87.72.73.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5748C571 /* 87.72.197.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5748EFBB /* 87.72.239.187/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5749544D /* 87.73.84.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x574F2E08 /* 87.79.46.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x574F4F5E /* 87.79.79.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x574F5F97 /* 87.79.95.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x574FFDCA /* 87.79.253.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5751943D /* 87.81.148.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x575C111C /* 87.92.17.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x575C61C2 /* 87.92.97.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x575CA318 /* 87.92.163.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57629897 /* 87.98.152.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5762B23D /* 87.98.178.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5762B905 /* 87.98.185.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5762F396 /* 87.98.243.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5762F554 /* 87.98.245.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5762FAF4 /* 87.98.250.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5762FD54 /* 87.98.253.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57660FD8 /* 87.102.15.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x576A0E9F /* 87.106.14.159/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x576A3B0C /* 87.106.59.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x576A8C18 /* 87.106.140.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x576AD0EC /* 87.106.208.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x576AF976 /* 87.106.249.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x577654B5 /* 87.118.84.181/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57765C2B /* 87.118.92.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57765EE3 /* 87.118.94.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57766436 /* 87.118.100.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57766A40 /* 87.118.106.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57766E71 /* 87.118.110.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57766E9E /* 87.118.110.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5776703F /* 87.118.112.63/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57767286 /* 87.118.114.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57767291 /* 87.118.114.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x577673B0 /* 87.118.115.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5776740C /* 87.118.116.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5776745A /* 87.118.116.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x577674E3 /* 87.118.116.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57767A1E /* 87.118.122.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57767A32 /* 87.118.122.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57767A33 /* 87.118.122.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57767AC9 /* 87.118.122.201/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57767AFE /* 87.118.122.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57767ECE /* 87.118.126.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57767EDA /* 87.118.126.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5778241A /* 87.120.36.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5778FE47 /* 87.120.254.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5778FECC /* 87.120.254.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5778FEF5 /* 87.120.254.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57806FBE /* 87.128.111.190/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57847BCB /* 87.132.123.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5784C8BC /* 87.132.200.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5786449E /* 87.134.68.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x578B21D9 /* 87.139.33.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x578B8B03 /* 87.139.139.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x578E63CC /* 87.142.99.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x578E6FB2 /* 87.142.111.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x578E7868 /* 87.142.120.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5793BF8D /* 87.147.191.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57948874 /* 87.148.136.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5796D6BD /* 87.150.214.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57987F6D /* 87.152.127.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5799207E /* 87.153.32.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x579C9AF5 /* 87.156.154.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x579DB391 /* 87.157.179.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x579F3CFD /* 87.159.60.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x579F5887 /* 87.159.88.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x579FBE89 /* 87.159.190.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x579FEBA5 /* 87.159.235.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57A247EF /* 87.162.71.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57A2C503 /* 87.162.197.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57A618C6 /* 87.166.24.198/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57A631E2 /* 87.166.49.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57AA8B6E /* 87.170.139.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57ABDF9F /* 87.171.223.159/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57AC14FA /* 87.172.20.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57ADD49F /* 87.173.212.159/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57AE6C25 /* 87.174.108.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57AECCC6 /* 87.174.204.198/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57AEE042 /* 87.174.224.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57AEFD48 /* 87.174.253.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57B18038 /* 87.177.128.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57B3C9DB /* 87.179.201.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57B4E2EE /* 87.180.226.238/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57B528B4 /* 87.181.40.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57B55BD9 /* 87.181.91.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57B6D189 /* 87.182.209.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57B91C30 /* 87.185.28.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57BA2215 /* 87.186.34.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57C1B3EE /* 87.193.179.238/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57C1D00E /* 87.193.208.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57D63AC8 /* 87.214.58.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57D8ABB3 /* 87.216.171.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57DECE2D /* 87.222.206.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57E61995 /* 87.230.25.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57ECC217 /* 87.236.194.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57ECD71E /* 87.236.215.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57ECD753 /* 87.236.215.83/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57FE5C78 /* 87.254.92.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5805A5DF /* 88.5.165.223/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x581B4113 /* 88.27.65.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x584187CD /* 88.65.135.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x584567A9 /* 88.69.103.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58485BDA /* 88.72.91.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5849369E /* 88.73.54.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x584C47D4 /* 88.76.71.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x584E43A5 /* 88.78.67.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58500705 /* 88.80.7.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5850D6BD /* 88.80.214.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x585666A3 /* 88.86.102.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5859086D /* 88.89.8.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5862FCEA /* 88.98.252.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58630E5C /* 88.99.14.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x586315A3 /* 88.99.21.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x586315AB /* 88.99.21.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58631B83 /* 88.99.27.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58631BE7 /* 88.99.27.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58631FBA /* 88.99.31.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5863230C /* 88.99.35.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x586323B2 /* 88.99.35.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58632420 /* 88.99.36.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5863466B /* 88.99.70.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58634B5E /* 88.99.75.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5863504E /* 88.99.80.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x586353A3 /* 88.99.83.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x586356AE /* 88.99.86.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58635784 /* 88.99.87.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x586360E0 /* 88.99.96.224/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5863685E /* 88.99.104.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x586D1267 /* 88.109.18.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5873E58C /* 88.115.229.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x588B8C5B /* 88.139.140.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x588E30D8 /* 88.142.48.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5895B559 /* 88.149.181.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5898AB67 /* 88.152.171.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5898ED49 /* 88.152.237.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x589C0AFD /* 88.156.10.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x589CB6C4 /* 88.156.182.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x589F2BF1 /* 88.159.43.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x589F4DC4 /* 88.159.77.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x589F8B11 /* 88.159.139.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x589F8E93 /* 88.159.142.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x589FA4F9 /* 88.159.164.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x589FF570 /* 88.159.245.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58A13860 /* 88.161.56.96/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58A7FEF1 /* 88.167.254.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58AE5A97 /* 88.174.90.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58B00C64 /* 88.176.12.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58B0B407 /* 88.176.180.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58B256CA /* 88.178.86.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58B3309A /* 88.179.48.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58B4AD3F /* 88.180.173.63/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58B99B86 /* 88.185.155.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58BA120C /* 88.186.18.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58BB785A /* 88.187.120.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58BBE91B /* 88.187.233.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58BCDCD1 /* 88.188.220.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58BDCE35 /* 88.189.206.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58BE765F /* 88.190.118.95/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58BED2F0 /* 88.190.210.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58BFCD30 /* 88.191.205.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58BFD421 /* 88.191.212.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58C0FD11 /* 88.192.253.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58C1997C /* 88.193.153.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58C38F0D /* 88.195.143.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58C60603 /* 88.198.6.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58C60BAB /* 88.198.11.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58C60D74 /* 88.198.13.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58C61304 /* 88.198.19.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58C617DD /* 88.198.23.221/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58C62424 /* 88.198.36.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58C62C91 /* 88.198.44.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58C63436 /* 88.198.52.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58C6388C /* 88.198.56.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58C66D95 /* 88.198.109.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58C66EC2 /* 88.198.110.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58C677C5 /* 88.198.119.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58C67D60 /* 88.198.125.96/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58C694FF /* 88.198.148.255/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58C6A4DB /* 88.198.164.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58C6C09C /* 88.198.192.156/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58C6C259 /* 88.198.194.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58C6CFDE /* 88.198.207.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58C6D403 /* 88.198.212.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58C6FD0D /* 88.198.253.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58C6FD18 /* 88.198.253.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58C6FD1B /* 88.198.253.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58C84964 /* 88.200.73.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58C99131 /* 88.201.145.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58CACA2A /* 88.202.202.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58CC70F2 /* 88.204.112.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58CC71BD /* 88.204.113.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58D0794E /* 88.208.121.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58D0F50A /* 88.208.245.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58D4228D /* 88.212.34.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58D74B9A /* 88.215.75.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58D7BAB9 /* 88.215.186.185/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58D96856 /* 88.217.104.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58D98F35 /* 88.217.143.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58D9ABE1 /* 88.217.171.225/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59002F22 /* 89.0.47.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59005227 /* 89.0.82.39/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59008F3F /* 89.0.143.63/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59036176 /* 89.3.97.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x590CB328 /* 89.12.179.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x590CCA35 /* 89.12.202.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x590DB50A /* 89.13.181.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5910B09E /* 89.16.176.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5912AC64 /* 89.18.172.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5912AC70 /* 89.18.172.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5912AD29 /* 89.18.173.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5916613A /* 89.22.97.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x591661C1 /* 89.22.97.193/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x591F393A /* 89.31.57.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x591F60A8 /* 89.31.96.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59207FB2 /* 89.32.127.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59210618 /* 89.33.6.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5921CF50 /* 89.33.207.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5921F672 /* 89.33.246.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5922ED15 /* 89.34.237.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5922ED65 /* 89.34.237.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5922ED79 /* 89.34.237.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5922ED88 /* 89.34.237.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5922EDC0 /* 89.34.237.192/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5923869A /* 89.35.134.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5923B268 /* 89.35.178.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5924DA7F /* 89.36.218.127/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5926D039 /* 89.38.208.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59274321 /* 89.39.67.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59284795 /* 89.40.71.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5928B56B /* 89.40.181.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x592D2394 /* 89.45.35.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x592D4389 /* 89.45.67.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x592DE21C /* 89.45.226.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x592E4662 /* 89.46.70.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x592E6447 /* 89.46.100.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x592E64A2 /* 89.46.100.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x594418D2 /* 89.68.24.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x594704AD /* 89.71.4.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5947A11E /* 89.71.161.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x594939B2 /* 89.73.57.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x595E01B3 /* 89.94.1.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59639B85 /* 89.99.155.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x596408AB /* 89.100.8.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5964217D /* 89.100.33.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59661F13 /* 89.102.31.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59668C7A /* 89.102.140.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59669309 /* 89.102.147.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59676FD9 /* 89.103.111.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x596B9BA2 /* 89.107.155.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x596DE24B /* 89.109.226.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x596E300A /* 89.110.48.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x596F1444 /* 89.111.20.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5980CD65 /* 89.128.205.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5984E1FA /* 89.132.225.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59857E05 /* 89.133.126.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59900C0F /* 89.144.12.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5996AE32 /* 89.150.174.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x599F5484 /* 89.159.84.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A1600E /* 89.161.96.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3803B /* 89.163.128.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A38042 /* 89.163.128.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3864C /* 89.163.134.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A38D73 /* 89.163.141.115/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A38D74 /* 89.163.141.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A38DEF /* 89.163.141.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A39130 /* 89.163.145.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3925D /* 89.163.146.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3940D /* 89.163.148.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A39D4F /* 89.163.157.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A39F2C /* 89.163.159.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3C4DD /* 89.163.196.221/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3D2A3 /* 89.163.210.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3D2A4 /* 89.163.210.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3D83C /* 89.163.216.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3D926 /* 89.163.217.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3DB1B /* 89.163.219.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3DB76 /* 89.163.219.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3E019 /* 89.163.224.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3E0BB /* 89.163.224.187/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3E0D4 /* 89.163.224.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3E0FA /* 89.163.224.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3E106 /* 89.163.225.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3E107 /* 89.163.225.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3E173 /* 89.163.225.115/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3E191 /* 89.163.225.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3E1B8 /* 89.163.225.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3F574 /* 89.163.245.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3F5B5 /* 89.163.245.181/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3F5B8 /* 89.163.245.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3F5C7 /* 89.163.245.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3F67F /* 89.163.246.127/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3F72B /* 89.163.247.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3F9C8 /* 89.163.249.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3F9C9 /* 89.163.249.201/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A6609C /* 89.166.96.156/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A67C0D /* 89.166.124.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59AC81D1 /* 89.172.129.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59AF1BA3 /* 89.175.27.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59B011EA /* 89.176.17.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59B2AAE4 /* 89.178.170.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59B377A5 /* 89.179.119.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59B37F7C /* 89.179.127.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59B74400 /* 89.183.68.0/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59BB8ED0 /* 89.187.142.208/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59BB8F51 /* 89.187.143.81/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59BB907A /* 89.187.144.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59BB9167 /* 89.187.145.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59BFC7F5 /* 89.191.199.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59BFD901 /* 89.191.217.1/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59CF8196 /* 89.207.129.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59DDD040 /* 89.221.208.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59DDD08A /* 89.221.208.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59DDD164 /* 89.221.209.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59DDD27A /* 89.221.210.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59DDD297 /* 89.221.210.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59DF1BF1 /* 89.223.27.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59EA9DFE /* 89.234.157.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59EAB76E /* 89.234.183.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59EABA24 /* 89.234.186.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59EC2275 /* 89.236.34.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59EE59C5 /* 89.238.89.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59F6CC36 /* 89.246.204.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59F8A69D /* 89.248.166.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59F8AAE3 /* 89.248.170.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59F94106 /* 89.249.65.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5A0106B5 /* 90.1.6.181/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5A06197C /* 90.6.25.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5A2C5DDA /* 90.44.93.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5A3FDA8B /* 90.63.218.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5A416676 /* 90.65.102.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5A4E1922 /* 90.78.25.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5A4F659A /* 90.79.101.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5A573FAD /* 90.87.63.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5A685368 /* 90.104.83.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5A6896BF /* 90.104.150.191/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5A69A893 /* 90.105.168.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5A700D78 /* 90.112.13.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5A708FA7 /* 90.112.143.167/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5A7887A8 /* 90.120.135.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5A7EADC0 /* 90.126.173.192/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5AB8DE76 /* 90.184.222.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5AB8EF9A /* 90.184.239.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5ABC1BB8 /* 90.188.27.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5ABF645B /* 90.191.100.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5AD0B354 /* 90.208.179.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5ADC0A6E /* 90.220.10.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5AE150DB /* 90.225.80.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5AE2B287 /* 90.226.178.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5AE68576 /* 90.230.133.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B007B9F /* 91.0.123.159/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B015603 /* 91.1.86.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B02AA6E /* 91.2.170.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B054CD4 /* 91.5.76.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B0846A3 /* 91.8.70.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B08D86F /* 91.8.216.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B09CB9D /* 91.9.203.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B0B28ED /* 91.11.40.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B1155E2 /* 91.17.85.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B12557C /* 91.18.85.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B12EA5A /* 91.18.234.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B13E9CF /* 91.19.233.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B147FDA /* 91.20.127.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B156D49 /* 91.21.109.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B208735 /* 91.32.135.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B20C025 /* 91.32.192.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B228FDD /* 91.34.143.221/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B2529A9 /* 91.37.41.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B293947 /* 91.41.57.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B298B37 /* 91.41.139.55/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B2A4735 /* 91.42.71.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B2AB21C /* 91.42.178.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B2D864A /* 91.45.134.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B31245C /* 91.49.36.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B339017 /* 91.51.144.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B352D2B /* 91.53.45.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B36C44C /* 91.54.196.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B3B43E1 /* 91.59.67.225/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B3BBE64 /* 91.59.190.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B3E5239 /* 91.62.82.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B3FA90B /* 91.63.169.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B40007D /* 91.64.0.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B408F14 /* 91.64.143.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B40A481 /* 91.64.164.129/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B40D118 /* 91.64.209.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B40FE7E /* 91.64.254.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B413DD9 /* 91.65.61.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B41A679 /* 91.65.166.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B42816A /* 91.66.129.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B436D56 /* 91.67.109.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B43858C /* 91.67.133.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B439B7F /* 91.67.155.127/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B4F1C58 /* 91.79.28.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B59FDD8 /* 91.89.253.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B600FC2 /* 91.96.15.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B61B4F8 /* 91.97.180.248/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B6467C4 /* 91.100.103.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B69CB5C /* 91.105.203.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B6A8BE1 /* 91.106.139.225/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B6AAB1D /* 91.106.171.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B6AAC3A /* 91.106.172.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B6AAD4B /* 91.106.173.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B6B68EE /* 91.107.104.238/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B6B692E /* 91.107.105.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B6D1DF1 /* 91.109.29.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B6D9C46 /* 91.109.156.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B720536 /* 91.114.5.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B790114 /* 91.121.1.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B790E99 /* 91.121.14.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B791043 /* 91.121.16.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B791764 /* 91.121.23.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B791C40 /* 91.121.28.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B791C42 /* 91.121.28.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B793608 /* 91.121.54.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B794CAF /* 91.121.76.175/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B794D25 /* 91.121.77.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B794FBC /* 91.121.79.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B795198 /* 91.121.81.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B795219 /* 91.121.82.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B79536C /* 91.121.83.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B795489 /* 91.121.84.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B795582 /* 91.121.85.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B795DA0 /* 91.121.93.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B79623A /* 91.121.98.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B796C40 /* 91.121.108.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B797168 /* 91.121.113.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B797422 /* 91.121.116.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B79777A /* 91.121.119.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B7985E1 /* 91.121.133.225/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B798884 /* 91.121.136.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B799341 /* 91.121.147.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B799991 /* 91.121.153.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B799B21 /* 91.121.155.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B799E11 /* 91.121.158.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B799F24 /* 91.121.159.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B79A006 /* 91.121.160.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B79A698 /* 91.121.166.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B79C09A /* 91.121.192.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B79C384 /* 91.121.195.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B79C3A9 /* 91.121.195.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B79D144 /* 91.121.209.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B79E00A /* 91.121.224.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B79E6D0 /* 91.121.230.208/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B79E6D2 /* 91.121.230.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B79E6D4 /* 91.121.230.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B79E6D6 /* 91.121.230.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B79E6D8 /* 91.121.230.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B79E6DA /* 91.121.230.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B7A1FAF /* 91.122.31.175/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B7A2FEA /* 91.122.47.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B7A34ED /* 91.122.52.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B7A640D /* 91.122.100.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B7D1BBB /* 91.125.27.187/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B7E2D22 /* 91.126.45.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B868558 /* 91.134.133.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B86870C /* 91.134.135.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B86886B /* 91.134.136.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B868963 /* 91.134.137.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B868BC8 /* 91.134.139.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B868BCF /* 91.134.139.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B868BD7 /* 91.134.139.215/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B869BF4 /* 91.134.155.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B86B4F0 /* 91.134.180.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B86D8A0 /* 91.134.216.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B86DAB0 /* 91.134.218.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B86E830 /* 91.134.232.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B86E831 /* 91.134.232.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B86F3AD /* 91.134.243.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B88A4E3 /* 91.136.164.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B8A1429 /* 91.138.20.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B8A47EC /* 91.138.71.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B8F50DC /* 91.143.80.220/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B8F5B7D /* 91.143.91.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B8F5B8E /* 91.143.91.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B9107E2 /* 91.145.7.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B91765D /* 91.145.118.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B927903 /* 91.146.121.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B927A2D /* 91.146.122.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B98713E /* 91.152.113.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B9A47D8 /* 91.154.71.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BA07B04 /* 91.160.123.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BB171C0 /* 91.177.113.192/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BBA0896 /* 91.186.8.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BBA3E92 /* 91.186.62.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BBC7D80 /* 91.188.125.128/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BBE754D /* 91.190.117.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BBEEA42 /* 91.190.234.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BC25A67 /* 91.194.90.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BC5EA66 /* 91.197.234.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BC5EA6A /* 91.197.234.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BC6D4FA /* 91.198.212.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BC80D07 /* 91.200.13.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BCA2969 /* 91.202.41.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BCA2EBD /* 91.202.46.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BCAA8B8 /* 91.202.168.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BCAA8B9 /* 91.202.168.185/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BCB0592 /* 91.203.5.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BCB05A1 /* 91.203.5.161/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BCB05A5 /* 91.203.5.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BCB927E /* 91.203.146.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BCDAD52 /* 91.205.173.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BCDAF8A /* 91.205.175.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BD2685B /* 91.210.104.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BD26A86 /* 91.210.106.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BD36BAC /* 91.211.107.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BD3F770 /* 91.211.247.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BD50854 /* 91.213.8.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BD50859 /* 91.213.8.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BD50865 /* 91.213.8.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BD508EB /* 91.213.8.235/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BD508EC /* 91.213.8.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BD5E93C /* 91.213.233.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BD5E96B /* 91.213.233.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BD5E98A /* 91.213.233.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BD6A945 /* 91.214.169.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDB1C55 /* 91.219.28.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDB1C63 /* 91.219.28.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDB1CD3 /* 91.219.28.211/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDB1D8E /* 91.219.29.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDB1D9D /* 91.219.29.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDB1DBC /* 91.219.29.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDB1DEE /* 91.219.29.238/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDBECAE /* 91.219.236.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDBECDA /* 91.219.236.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDBECE8 /* 91.219.236.232/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDBECFA /* 91.219.236.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDBED13 /* 91.219.237.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDBED75 /* 91.219.237.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDBED9A /* 91.219.237.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDBEDE5 /* 91.219.237.229/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDBEDEB /* 91.219.237.235/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDBEDF4 /* 91.219.237.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDBEEDD /* 91.219.238.221/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDBEF5C /* 91.219.239.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDBEFFA /* 91.219.239.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDCDC05 /* 91.220.220.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDD42DC /* 91.221.66.220/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDD7721 /* 91.221.119.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDF529C /* 91.223.82.156/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDF6A59 /* 91.223.106.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDF6A5A /* 91.223.106.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BE09521 /* 91.224.149.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BE09C75 /* 91.224.156.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BE09D63 /* 91.224.157.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BE434BA /* 91.228.52.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BE43556 /* 91.228.53.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BE5141B /* 91.229.20.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BE54C7C /* 91.229.76.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BE6CC50 /* 91.230.204.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BE75665 /* 91.231.86.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BE756CC /* 91.231.86.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BE8E12B /* 91.232.225.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BE96A79 /* 91.233.106.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BE96A91 /* 91.233.106.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BE96AAC /* 91.233.106.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BE96AED /* 91.233.106.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BE97433 /* 91.233.116.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BE97477 /* 91.233.116.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BE985F7 /* 91.233.133.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BEB8832 /* 91.235.136.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BEC7457 /* 91.236.116.87/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BEC745D /* 91.236.116.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BEC745E /* 91.236.116.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BECEF87 /* 91.236.239.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BECEF8C /* 91.236.239.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BECFB15 /* 91.236.251.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BECFB18 /* 91.236.251.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BECFB1E /* 91.236.251.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BECFB2A /* 91.236.251.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BECFB48 /* 91.236.251.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BED34AA /* 91.237.52.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BED5867 /* 91.237.88.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BED58B5 /* 91.237.88.181/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BEDF43E /* 91.237.244.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BEDF73E /* 91.237.247.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BEFE851 /* 91.239.232.81/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BF04305 /* 91.240.67.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BF0E5C3 /* 91.240.229.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BF2A3BA /* 91.242.163.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BF3CB50 /* 91.243.203.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BF3D521 /* 91.243.213.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BF7FB1A /* 91.247.251.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BF817F0 /* 91.248.23.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BFA75FC /* 91.250.117.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C1B07D1 /* 92.27.7.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C267E8C /* 92.38.126.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C26AD50 /* 92.38.173.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C27F62D /* 92.39.246.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C32A1F6 /* 92.50.161.246/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C33F583 /* 92.51.245.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C3FACF7 /* 92.63.172.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C3FAD18 /* 92.63.173.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C3FAE24 /* 92.63.174.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C3FAE47 /* 92.63.174.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C4BBA9C /* 92.75.186.156/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C4C66DE /* 92.76.102.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C59523D /* 92.89.82.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C5E640B /* 92.94.100.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C5F4274 /* 92.95.66.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C648326 /* 92.100.131.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C6CC255 /* 92.108.194.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C6D527B /* 92.109.82.123/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C6F04B1 /* 92.111.4.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C6F59EE /* 92.111.89.238/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C824D96 /* 92.130.77.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CA75FDB /* 92.167.95.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CA78C44 /* 92.167.140.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CA916D1 /* 92.169.22.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CC344A6 /* 92.195.68.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CC905E2 /* 92.201.5.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CCC0195 /* 92.204.1.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CCE1A1D /* 92.206.26.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CD3274D /* 92.211.39.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDC4808 /* 92.220.72.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDC4ED7 /* 92.220.78.215/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDD5AA1 /* 92.221.90.161/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDDC98A /* 92.221.201.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE0466 /* 92.222.4.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE060C /* 92.222.6.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE1482 /* 92.222.20.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE1625 /* 92.222.22.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE1671 /* 92.222.22.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE17C2 /* 92.222.23.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE19BF /* 92.222.25.191/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE1AD8 /* 92.222.26.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE1CF3 /* 92.222.28.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE2643 /* 92.222.38.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE27B7 /* 92.222.39.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE27C4 /* 92.222.39.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE4519 /* 92.222.69.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE45AD /* 92.222.69.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE46AC /* 92.222.70.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE4ACB /* 92.222.74.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE4AE2 /* 92.222.74.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE5488 /* 92.222.84.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE55AB /* 92.222.85.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE59BF /* 92.222.89.191/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE5A9C /* 92.222.90.156/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE5CFA /* 92.222.92.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE5E33 /* 92.222.94.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE67E8 /* 92.222.103.232/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE67E9 /* 92.222.103.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE731C /* 92.222.115.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE9993 /* 92.222.153.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDEA236 /* 92.222.162.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDEB457 /* 92.222.180.87/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDEB568 /* 92.222.181.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDEB57B /* 92.222.181.123/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDECC60 /* 92.222.204.96/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CE0048E /* 92.224.4.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CE0AC08 /* 92.224.172.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CE10812 /* 92.225.8.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CF228C0 /* 92.242.40.192/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CF24A87 /* 92.242.74.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CF3141E /* 92.243.20.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CF31ED0 /* 92.243.30.208/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CF34569 /* 92.243.69.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CF41F1C /* 92.244.31.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CF733A9 /* 92.247.51.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CF8E784 /* 92.248.231.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CF98F77 /* 92.249.143.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CF9955F /* 92.249.149.95/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CFE3951 /* 92.254.57.81/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CFFB08A /* 92.255.176.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CFFCF59 /* 92.255.207.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CFFFB42 /* 92.255.251.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D1B3351 /* 93.27.51.81/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D32BA03 /* 93.50.186.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D3A0B18 /* 93.58.11.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D40CF37 /* 93.64.207.55/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D41D51F /* 93.65.213.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D42D1BC /* 93.66.209.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D492760 /* 93.73.39.96/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D4A2AE6 /* 93.74.42.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D59651B /* 93.89.101.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D5CCB71 /* 93.92.203.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D5F64A4 /* 93.95.100.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D5F64A6 /* 93.95.100.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D5F64CA /* 93.95.100.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D5F64CB /* 93.95.100.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D5FE3F5 /* 93.95.227.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D5FE431 /* 93.95.228.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D5FE450 /* 93.95.228.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D648EB6 /* 93.100.142.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D64D3D8 /* 93.100.211.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D67E349 /* 93.103.227.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D68762D /* 93.104.118.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D68A579 /* 93.104.165.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D68D06A /* 93.104.208.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D68D120 /* 93.104.209.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D68D19E /* 93.104.209.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D68D33E /* 93.104.211.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D68D541 /* 93.104.213.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D71AF19 /* 93.113.175.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D731B34 /* 93.115.27.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D731C0D /* 93.115.28.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D731D56 /* 93.115.29.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D73548F /* 93.115.84.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D735B42 /* 93.115.91.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D735F26 /* 93.115.95.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D735FC9 /* 93.115.95.201/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D735FCA /* 93.115.95.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D735FCC /* 93.115.95.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D735FCD /* 93.115.95.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D735FCE /* 93.115.95.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D735FCF /* 93.115.95.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D735FD8 /* 93.115.95.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D7361F2 /* 93.115.97.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D73F102 /* 93.115.241.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D73F132 /* 93.115.241.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D73F1C2 /* 93.115.241.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D760102 /* 93.118.1.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D7B5A0D /* 93.123.90.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D7BE197 /* 93.123.225.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D81296E /* 93.129.41.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D989FDF /* 93.152.159.223/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D9D3316 /* 93.157.51.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D9ED834 /* 93.158.216.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D9ED83F /* 93.158.216.63/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D9ED88E /* 93.158.216.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DAA4D94 /* 93.170.77.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DAA4DAE /* 93.170.77.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DAA4DDF /* 93.170.77.223/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DAA4DE7 /* 93.170.77.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DAAA93E /* 93.170.169.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DAE5D85 /* 93.174.93.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DB4882B /* 93.180.136.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DB49A5E /* 93.180.154.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DB49C54 /* 93.180.156.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DB49D9A /* 93.180.157.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DB5035B /* 93.181.3.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DB81462 /* 93.184.20.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DB81E14 /* 93.184.30.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DB842E3 /* 93.184.66.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DB96DBF /* 93.185.109.191/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DBA0E46 /* 93.186.14.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DBAC844 /* 93.186.200.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DBAC8D5 /* 93.186.200.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DBACAC3 /* 93.186.202.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DBACAF1 /* 93.186.202.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DBD1A16 /* 93.189.26.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DBD5AF4 /* 93.189.90.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DBE5F18 /* 93.190.95.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DBE8D73 /* 93.190.141.115/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DC27838 /* 93.194.120.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DC4E9F0 /* 93.196.233.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DC5F186 /* 93.197.241.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DCBFEFE /* 93.203.254.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DCDACFE /* 93.205.172.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DCDE0CA /* 93.205.224.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DCE42BD /* 93.206.66.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DCF77FA /* 93.207.119.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DD12CEB /* 93.209.44.235/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DD1A8B8 /* 93.209.168.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DD3D5CF /* 93.211.213.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DD4544A /* 93.212.84.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DD77920 /* 93.215.121.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DDA60B7 /* 93.218.96.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DDB4A99 /* 93.219.74.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DDB4F18 /* 93.219.79.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DDEE4A5 /* 93.222.228.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DDF73C6 /* 93.223.115.198/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DE03EA0 /* 93.224.62.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DE1B52D /* 93.225.181.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DE32C29 /* 93.227.44.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DE38F2B /* 93.227.143.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DE44117 /* 93.228.65.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DE79F0B /* 93.231.159.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DE7E5FC /* 93.231.229.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DE8FF95 /* 93.232.255.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DE98875 /* 93.233.136.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DEAADD4 /* 93.234.173.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DECF646 /* 93.236.246.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DED9761 /* 93.237.151.97/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DED9CAC /* 93.237.156.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DEF2BAB /* 93.239.43.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DF42B23 /* 93.244.43.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E108907 /* 94.16.137.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E10AD6A /* 94.16.173.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E15EB8D /* 94.21.235.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E16C5B3 /* 94.22.197.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E1701A4 /* 94.23.1.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E1707A1 /* 94.23.7.161/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E17113A /* 94.23.17.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E1712A9 /* 94.23.18.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E17141C /* 94.23.20.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E171DCC /* 94.23.29.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E179031 /* 94.23.144.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E1799F1 /* 94.23.153.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E179A24 /* 94.23.154.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E17A526 /* 94.23.165.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E17AD5D /* 94.23.173.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E17ADF9 /* 94.23.173.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E17AE1A /* 94.23.174.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E17CCAF /* 94.23.204.175/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E17DBC0 /* 94.23.219.192/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E17DC58 /* 94.23.220.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E17F72A /* 94.23.247.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E17F89E /* 94.23.248.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E1A5862 /* 94.26.88.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E1A8C96 /* 94.26.140.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E1CF47B /* 94.28.244.123/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E1F35CB /* 94.31.53.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E225DB0 /* 94.34.93.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E2E0D0B /* 94.46.13.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E2E52EC /* 94.46.82.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E32882A /* 94.50.136.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E3CFF2A /* 94.60.255.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E3DCC41 /* 94.61.204.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E4A5171 /* 94.74.81.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E4BE8F2 /* 94.75.232.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E4F89B6 /* 94.79.137.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E4FADE2 /* 94.79.173.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E640617 /* 94.100.6.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E64061B /* 94.100.6.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E6415A2 /* 94.100.21.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E641712 /* 94.100.23.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E64171A /* 94.100.23.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E66322A /* 94.102.50.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E663C55 /* 94.102.60.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E70D94D /* 94.112.217.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E72ACDC /* 94.114.172.220/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E7EAAA5 /* 94.126.170.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E897888 /* 94.137.120.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E8C7868 /* 94.140.120.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E8C7882 /* 94.140.120.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E8C7A16 /* 94.140.122.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E8EF18A /* 94.142.241.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E8EF254 /* 94.142.242.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E8EF5CE /* 94.142.245.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E9B312F /* 94.155.49.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E9C4DC0 /* 94.156.77.192/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E9C800A /* 94.156.128.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E9CAF78 /* 94.156.175.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EB08BBA /* 94.176.139.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EB1E450 /* 94.177.228.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EB1EAF3 /* 94.177.234.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EB52C2D /* 94.181.44.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EB52DED /* 94.181.45.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EB95A56 /* 94.185.90.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EC1F171 /* 94.193.241.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EC6445C /* 94.198.68.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EC66218 /* 94.198.98.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EC66247 /* 94.198.98.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EC66411 /* 94.198.100.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EC66412 /* 94.198.100.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5ED1AF86 /* 94.209.175.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5ED1C399 /* 94.209.195.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5ED57791 /* 94.213.119.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5ED6CC43 /* 94.214.204.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5ED8790D /* 94.216.121.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EDABF26 /* 94.218.191.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EDB188C /* 94.219.24.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EDF9D93 /* 94.223.157.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EE02CA2 /* 94.224.44.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EE16454 /* 94.225.100.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EE26BA5 /* 94.226.107.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EE4560B /* 94.228.86.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EE45790 /* 94.228.87.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EE8AE42 /* 94.232.174.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EECF049 /* 94.236.240.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF12A9C /* 94.241.42.156/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF23902 /* 94.242.57.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF23954 /* 94.242.57.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF23970 /* 94.242.57.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF239A1 /* 94.242.57.161/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF239D4 /* 94.242.57.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF23A02 /* 94.242.58.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF23A97 /* 94.242.58.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF23AE9 /* 94.242.58.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF23B2F /* 94.242.59.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF23B93 /* 94.242.59.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF23BB6 /* 94.242.59.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF23BBB /* 94.242.59.187/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF2D178 /* 94.242.209.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF2D179 /* 94.242.209.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF2D1F4 /* 94.242.209.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF2DE19 /* 94.242.222.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF2DE81 /* 94.242.222.129/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF2DED9 /* 94.242.222.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF2E4AE /* 94.242.228.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF2F617 /* 94.242.246.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF2F618 /* 94.242.246.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF2FA76 /* 94.242.250.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF2FF70 /* 94.242.255.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF53531 /* 94.245.53.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EFD0CCB /* 94.253.12.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EFDB1E7 /* 94.253.177.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EFE121F /* 94.254.18.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EFE1905 /* 94.254.25.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EFE56CC /* 94.254.86.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EFE5E9B /* 94.254.94.155/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F199543 /* 95.25.149.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F1B83EE /* 95.27.131.238/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F1BA3AC /* 95.27.163.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F1BC4E5 /* 95.27.196.229/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F1C06B0 /* 95.28.6.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F1C290B /* 95.28.41.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F1C3802 /* 95.28.56.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F1F0EA0 /* 95.31.14.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F1F1892 /* 95.31.24.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F1F26D1 /* 95.31.38.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F1F7F71 /* 95.31.127.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F1FF207 /* 95.31.242.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F26CA17 /* 95.38.202.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F2A7EA7 /* 95.42.126.167/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F2E6211 /* 95.46.98.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F45E818 /* 95.69.232.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F479350 /* 95.71.147.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F47F93B /* 95.71.249.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F4947DE /* 95.73.71.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F4968B5 /* 95.73.104.181/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F4F6007 /* 95.79.96.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F502D4A /* 95.80.45.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F54A422 /* 95.84.164.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F54D17E /* 95.84.209.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F550171 /* 95.85.1.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F5503BF /* 95.85.3.191/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F5508E2 /* 95.85.8.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F550A47 /* 95.85.10.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F55132E /* 95.85.19.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F5513A2 /* 95.85.19.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F551449 /* 95.85.20.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F5516AD /* 95.85.22.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F55200A /* 95.85.32.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F55256F /* 95.85.37.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F553236 /* 95.85.50.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F5820BA /* 95.88.32.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F585BC5 /* 95.88.91.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F59EB89 /* 95.89.235.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F5AB216 /* 95.90.178.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F5B057D /* 95.91.5.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F5B1017 /* 95.91.16.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F5B222D /* 95.91.34.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F5B95DA /* 95.91.149.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F69A49D /* 95.105.164.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F6C7B1D /* 95.108.123.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F6D7A90 /* 95.109.122.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F722090 /* 95.114.32.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F77AD1B /* 95.119.173.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F7B33AC /* 95.123.51.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F802BA4 /* 95.128.43.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F8137AD /* 95.129.55.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F820B05 /* 95.130.11.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F820B0F /* 95.130.11.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F820B93 /* 95.130.11.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F820BAA /* 95.130.11.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F820BBA /* 95.130.11.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F820C1F /* 95.130.12.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F820C77 /* 95.130.12.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F841A81 /* 95.132.26.129/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F8C2AB7 /* 95.140.42.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F8D230F /* 95.141.35.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F8D5392 /* 95.141.83.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F8EA0E9 /* 95.142.160.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F8EA13F /* 95.142.161.63/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F8EAD12 /* 95.142.173.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F8FAC8C /* 95.143.172.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F8FAC93 /* 95.143.172.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F8FACBC /* 95.143.172.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F8FACD4 /* 95.143.172.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F8FACD6 /* 95.143.172.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F8FACE3 /* 95.143.172.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F8FC191 /* 95.143.193.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F9281D1 /* 95.146.129.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F9749C7 /* 95.151.73.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F9914D4 /* 95.153.20.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F991F08 /* 95.153.31.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F9C5F08 /* 95.156.95.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FA37923 /* 95.163.121.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FA37997 /* 95.163.121.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FA58516 /* 95.165.133.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FA58F70 /* 95.165.143.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FA5940C /* 95.165.148.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FA88A56 /* 95.168.138.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FA894E9 /* 95.168.148.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FA9BC67 /* 95.169.188.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FACEC3F /* 95.172.236.63/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FAEE6C9 /* 95.174.230.201/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FB7300C /* 95.183.48.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FB73081 /* 95.183.48.129/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FB730B4 /* 95.183.48.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FB7328A /* 95.183.50.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FB732D0 /* 95.183.50.208/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FB7337E /* 95.183.51.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FB734AC /* 95.183.52.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FB73735 /* 95.183.55.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD0AFA1 /* 95.208.175.161/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD3079E /* 95.211.7.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD31B84 /* 95.211.27.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD376C2 /* 95.211.118.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD38A07 /* 95.211.138.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD38A33 /* 95.211.138.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD39362 /* 95.211.147.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD3A094 /* 95.211.160.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD3BA50 /* 95.211.186.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD3CD8A /* 95.211.205.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD3D149 /* 95.211.209.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD3D248 /* 95.211.210.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD3D809 /* 95.211.216.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD3E00C /* 95.211.224.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD3E1A7 /* 95.211.225.167/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD3E242 /* 95.211.226.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD3E65E /* 95.211.230.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD5C3AB /* 95.213.195.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD5CAB2 /* 95.213.202.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD5FB52 /* 95.213.251.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72C66 /* 95.215.44.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72C69 /* 95.215.44.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72CA7 /* 95.215.44.167/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72CC2 /* 95.215.44.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72CE8 /* 95.215.44.232/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72D44 /* 95.215.45.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72D8E /* 95.215.45.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72DBC /* 95.215.45.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72E2E /* 95.215.46.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72E45 /* 95.215.46.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72E7B /* 95.215.46.123/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72EF2 /* 95.215.46.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72EF4 /* 95.215.46.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72F4B /* 95.215.47.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72F96 /* 95.215.47.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72FFB /* 95.215.47.251/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD73D04 /* 95.215.61.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FDC073C /* 95.220.7.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FDCDFA9 /* 95.220.223.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FDF4CB8 /* 95.223.76.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FEB08A7 /* 95.235.8.167/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6009F230 /* 96.9.242.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6012AAD4 /* 96.18.170.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x602112CA /* 96.33.18.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x60238285 /* 96.35.130.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x602785DB /* 96.39.133.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x602B82B2 /* 96.43.130.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x602FEF99 /* 96.47.239.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6034D4A3 /* 96.52.212.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x604144C1 /* 96.65.68.193/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x60417BF9 /* 96.65.123.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x60420F93 /* 96.66.15.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x60553F29 /* 96.85.63.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x60559BD9 /* 96.85.155.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x60598D1D /* 96.89.141.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x605B0B51 /* 96.91.11.81/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x605C7632 /* 96.92.118.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x607E6009 /* 96.126.96.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x607E605A /* 96.126.96.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x607E69DB /* 96.126.105.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x607E7AA6 /* 96.126.122.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x607E7DBB /* 96.126.125.187/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x60E94CE8 /* 96.233.76.232/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x60EB82FC /* 96.235.130.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x60ED40D5 /* 96.237.64.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x60EF7A14 /* 96.239.122.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x60F20D06 /* 96.242.13.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x60F29FB1 /* 96.242.159.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x60F2FC93 /* 96.242.252.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x60F805AC /* 96.248.5.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x60F9FE16 /* 96.249.254.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x60FD4E6C /* 96.253.78.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x60FF478B /* 96.255.71.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x614AEDC4 /* 97.74.237.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x61520CB7 /* 97.82.12.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x61553F86 /* 97.85.63.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x615E705B /* 97.94.112.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x615F230D /* 97.95.35.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x615FD82C /* 97.95.216.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x616B8418 /* 97.107.132.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x616B867F /* 97.107.134.127/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x616B8A44 /* 97.107.138.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x616B8B1C /* 97.107.139.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x616B8B6C /* 97.107.139.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x616B8E85 /* 97.107.142.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x616B8EEA /* 97.107.142.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x61785EA3 /* 97.120.94.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x617EC6DC /* 97.126.198.220/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x617F1B73 /* 97.127.27.115/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x621A2219 /* 98.26.34.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x621A3022 /* 98.26.48.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6273D502 /* 98.115.213.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x62A404DF /* 98.164.4.223/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x62B50CA9 /* 98.181.12.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x62C931E2 /* 98.201.49.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x62D14F33 /* 98.209.79.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x62D88697 /* 98.216.134.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x62D90833 /* 98.217.8.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x62D97962 /* 98.217.121.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x62DB0831 /* 98.219.8.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x62E19AB7 /* 98.225.154.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x62E3E03A /* 98.227.224.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x62EBB9A7 /* 98.235.185.167/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x62ED8805 /* 98.237.136.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x62F802E4 /* 98.248.2.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x62F82838 /* 98.248.40.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x63060E37 /* 99.6.14.55/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6334B0A2 /* 99.52.176.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x63474BAC /* 99.71.75.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x63F57360 /* 99.245.115.96/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x640069DB /* 100.0.105.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x640203AC /* 100.2.3.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6406B61E /* 100.6.182.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6408FAC3 /* 100.8.250.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x640B7706 /* 100.11.119.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x640F27AD /* 100.15.39.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x640F7203 /* 100.15.114.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6410DA28 /* 100.16.218.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x65377D0A /* 101.55.125.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x65648D37 /* 101.100.141.55/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x656490AE /* 101.100.144.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x65649FD6 /* 101.100.159.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x67033D72 /* 103.3.61.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x67084FE5 /* 103.8.79.229/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x670AC532 /* 103.10.197.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x670AC764 /* 103.10.199.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x670E2976 /* 103.14.41.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x67193A22 /* 103.25.58.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x671B7C52 /* 103.27.124.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x671D4617 /* 103.29.70.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x67233816 /* 103.35.56.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6729B13E /* 103.41.177.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6729B140 /* 103.41.177.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x672AE17E /* 103.42.225.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6738CF54 /* 103.56.207.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x67C7103A /* 103.199.16.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x67E26B10 /* 103.226.107.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x67EADCC5 /* 103.234.220.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x67ECC96E /* 103.236.201.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x67FA49C3 /* 103.250.73.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x67FA49E8 /* 103.250.73.232/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68201531 /* 104.32.21.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68253D9F /* 104.37.61.159/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6825C09C /* 104.37.192.156/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68299523 /* 104.41.149.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6880E070 /* 104.128.224.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6880E249 /* 104.128.226.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6882A979 /* 104.130.169.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x688304ED /* 104.131.4.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68830BD6 /* 104.131.11.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68830C8B /* 104.131.12.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68831377 /* 104.131.19.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6883177F /* 104.131.23.127/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68831C36 /* 104.131.28.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6883248A /* 104.131.36.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68832A95 /* 104.131.42.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68832D66 /* 104.131.45.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x688341E1 /* 104.131.65.225/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x688342C2 /* 104.131.66.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6883483D /* 104.131.72.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68835477 /* 104.131.84.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68835684 /* 104.131.86.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x688357B4 /* 104.131.87.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x688365FB /* 104.131.101.251/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68836AB5 /* 104.131.106.181/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68836C07 /* 104.131.108.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68836ECC /* 104.131.110.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68837B10 /* 104.131.123.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x688380F7 /* 104.131.128.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6883811E /* 104.131.129.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68838282 /* 104.131.130.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68838C45 /* 104.131.140.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68839456 /* 104.131.148.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68839554 /* 104.131.149.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6883B286 /* 104.131.178.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6883B5AE /* 104.131.181.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6883B815 /* 104.131.184.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6883CC93 /* 104.131.204.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6883CDC0 /* 104.131.205.192/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6883CE17 /* 104.131.206.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6883F537 /* 104.131.245.55/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x689C3CA3 /* 104.156.60.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x689C3CA6 /* 104.156.60.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x689C66C8 /* 104.156.102.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x689CE053 /* 104.156.224.83/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x689CE299 /* 104.156.226.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x689CE688 /* 104.156.230.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68A7645F /* 104.167.100.95/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68A76D4D /* 104.167.109.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68A774EA /* 104.167.116.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68A83EAE /* 104.168.62.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68A83ED1 /* 104.168.62.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68A857A7 /* 104.168.87.167/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68A8A722 /* 104.168.167.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68A92625 /* 104.169.38.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68BEA4AC /* 104.190.164.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68C00747 /* 104.192.7.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68C810E3 /* 104.200.16.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68C812F4 /* 104.200.18.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68C8142E /* 104.200.20.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68C8148E /* 104.200.20.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68CEED15 /* 104.206.237.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68CEED18 /* 104.206.237.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68CF802A /* 104.207.128.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68CF8069 /* 104.207.128.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68CF8514 /* 104.207.133.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68D12CF8 /* 104.209.44.248/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68DC3938 /* 104.220.57.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68DF0138 /* 104.223.1.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68DF0CE9 /* 104.223.12.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68DF1097 /* 104.223.16.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68DF67BB /* 104.223.103.187/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68DF7A45 /* 104.223.122.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68DF7A73 /* 104.223.122.115/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68DF7AD5 /* 104.223.122.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68DF7AEF /* 104.223.122.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68E0AD3A /* 104.224.173.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68E8775D /* 104.232.119.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68E9500F /* 104.233.80.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68E953CE /* 104.233.83.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68E95629 /* 104.233.86.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68E95EB5 /* 104.233.94.181/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68E96AD2 /* 104.233.106.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68E97255 /* 104.233.114.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68E9773E /* 104.233.119.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68E9786C /* 104.233.120.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68E97B49 /* 104.233.123.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68EC1696 /* 104.236.22.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68EC21AE /* 104.236.33.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68EC2938 /* 104.236.41.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68EC2C85 /* 104.236.44.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68EC2CE0 /* 104.236.44.224/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68EC2E0A /* 104.236.46.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68EC3410 /* 104.236.52.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68EC46C8 /* 104.236.70.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68EC575A /* 104.236.87.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68EC656C /* 104.236.101.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68EC67A7 /* 104.236.103.167/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68EC6881 /* 104.236.104.129/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68EC830F /* 104.236.131.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68EC8D9C /* 104.236.141.156/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68EC97A0 /* 104.236.151.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68ECAFCB /* 104.236.175.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68ECB6CD /* 104.236.182.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68ECB739 /* 104.236.183.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68ECC7D9 /* 104.236.199.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68ECE0E1 /* 104.236.224.225/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68ECE7C5 /* 104.236.231.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68ECEAB2 /* 104.236.234.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68ECF7DA /* 104.236.247.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68ECFCA9 /* 104.236.252.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68ECFD26 /* 104.236.253.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68ED9CD6 /* 104.237.156.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68EE86B8 /* 104.238.134.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68EE9FBF /* 104.238.159.191/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68EEA76F /* 104.238.167.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68EEBC62 /* 104.238.188.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68EEBE82 /* 104.238.190.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F323C4 /* 104.243.35.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44A0D /* 104.244.74.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44D8F /* 104.244.77.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F4DFCC /* 104.244.223.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F52450 /* 104.245.36.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68FA976C /* 104.250.151.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x699E356E /* 105.158.53.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6AB91C19 /* 106.185.28.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6ABA7981 /* 106.186.121.129/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6ABB2565 /* 106.187.37.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6ABB2F11 /* 106.187.47.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6B02D620 /* 107.2.214.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6B041F6F /* 107.4.31.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6B0D7797 /* 107.13.119.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6B9EFF15 /* 107.158.255.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6B9EFF16 /* 107.158.255.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BA111B4 /* 107.161.17.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BA11271 /* 107.161.18.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BA11286 /* 107.161.18.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BA150C3 /* 107.161.80.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BA1AC97 /* 107.161.172.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAA2047 /* 107.170.32.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAA4E2A /* 107.170.78.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAA4E53 /* 107.170.78.83/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAA5CED /* 107.170.92.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAA5D0D /* 107.170.93.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAA6527 /* 107.170.101.39/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAA6CDE /* 107.170.108.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAA711C /* 107.170.113.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAA71D4 /* 107.170.113.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAA771F /* 107.170.119.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAA8F75 /* 107.170.143.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAA9607 /* 107.170.150.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAA9950 /* 107.170.153.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAA9ED4 /* 107.170.158.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAABC9B /* 107.170.188.155/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAAC10E /* 107.170.193.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAACD08 /* 107.170.205.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAAD546 /* 107.170.213.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAAE7A9 /* 107.170.231.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAAE84B /* 107.170.232.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAAF442 /* 107.170.244.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAAF67B /* 107.170.246.123/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAAF721 /* 107.170.247.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAAFD74 /* 107.170.253.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAC170B /* 107.172.23.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAD2B23 /* 107.173.43.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAE3490 /* 107.174.52.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BB39941 /* 107.179.153.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BB59B83 /* 107.181.155.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BB5A60B /* 107.181.166.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BB5AE16 /* 107.181.174.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BB5AE54 /* 107.181.174.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BB5BBC7 /* 107.181.187.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BB6B3DC /* 107.182.179.220/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BBCBC39 /* 107.188.188.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BBF2ECC /* 107.191.46.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BBF2F57 /* 107.191.47.87/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BBF38C0 /* 107.191.56.192/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BBF672A /* 107.191.103.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BBF76AB /* 107.191.118.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BBF7EB8 /* 107.191.126.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BD3F863 /* 107.211.248.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6C0431B5 /* 108.4.49.181/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6C0CC48C /* 108.12.196.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6C1D0041 /* 108.29.0.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6C1F2805 /* 108.31.40.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6C1FA9E8 /* 108.31.169.232/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6C203114 /* 108.32.49.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6C2304B7 /* 108.35.4.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6C2929C7 /* 108.41.41.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6C2E22E8 /* 108.46.34.232/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6C331A8D /* 108.51.26.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6C339122 /* 108.51.145.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6C33EC02 /* 108.51.236.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6C35D09D /* 108.53.208.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3A90EA /* 108.58.144.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3B02D0 /* 108.59.2.208/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3D6027 /* 108.61.96.39/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3D60E6 /* 108.61.96.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3D6307 /* 108.61.99.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3D6395 /* 108.61.99.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3D774B /* 108.61.119.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3DA500 /* 108.61.165.0/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3DA5A9 /* 108.61.165.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3DA7D3 /* 108.61.167.211/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3DB64A /* 108.61.182.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3DBE8B /* 108.61.190.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3DD44E /* 108.61.212.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6C55630A /* 108.85.99.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6CA185BD /* 108.161.133.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6CA2AB42 /* 108.162.171.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6CA84202 /* 108.168.66.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6CAA920A /* 108.170.146.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6CAA9FFB /* 108.170.159.251/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6CAF02CD /* 108.175.2.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6CAF0BE6 /* 108.175.11.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6CB80514 /* 108.184.5.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6CF0B68C /* 108.240.182.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6CF857F2 /* 108.248.87.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D00AA2D /* 109.0.170.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D08CFA6 /* 109.8.207.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D18C1D8 /* 109.24.193.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D18DC07 /* 109.24.220.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D1EC5DE /* 109.30.197.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D3FEBB6 /* 109.63.235.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D44AE3C /* 109.68.174.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D44BF84 /* 109.68.191.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D44BF85 /* 109.68.191.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D454311 /* 109.69.67.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D4676A4 /* 109.70.118.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D4AC3BE /* 109.74.195.190/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D4ACE15 /* 109.74.206.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D4BB84D /* 109.75.184.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D5A0231 /* 109.90.2.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D5A4BC0 /* 109.90.75.192/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D5A6963 /* 109.90.105.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D5AB5BD /* 109.90.181.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D5B73C8 /* 109.91.115.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D6832B3 /* 109.104.50.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D696DA2 /* 109.105.109.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D6A3DF9 /* 109.106.61.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D6B239A /* 109.107.35.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D6C0357 /* 109.108.3.87/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D6C1DF2 /* 109.108.29.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D78B4F5 /* 109.120.180.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D78B5B1 /* 109.120.181.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D7E09E4 /* 109.126.9.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D806B66 /* 109.128.107.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D8086E1 /* 109.128.134.225/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D827E43 /* 109.130.126.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D914022 /* 109.145.64.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D92A821 /* 109.146.168.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D948254 /* 109.148.130.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D94B389 /* 109.148.179.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D9657AC /* 109.150.87.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D9CC5B9 /* 109.156.197.185/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D9DDFF9 /* 109.157.223.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DA3EA02 /* 109.163.234.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DA3EA04 /* 109.163.234.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DA3EA05 /* 109.163.234.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DA3EA07 /* 109.163.234.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DA3EA08 /* 109.163.234.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DA3EA09 /* 109.163.234.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DA4ECE7 /* 109.164.236.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DA921A3 /* 109.169.33.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DAD29A1 /* 109.173.41.161/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DAD3936 /* 109.173.57.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DAD39A9 /* 109.173.57.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DAD4CF8 /* 109.173.76.248/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DBBF630 /* 109.187.246.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DBC49D8 /* 109.188.73.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DBD4EDF /* 109.189.78.223/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DBD9D3F /* 109.189.157.63/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DBE1822 /* 109.190.24.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DBE4295 /* 109.190.66.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DBEB62C /* 109.190.182.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DC01159 /* 109.192.17.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DC0DDFB /* 109.192.221.251/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DC13134 /* 109.193.49.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DC146DB /* 109.193.70.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DC26E91 /* 109.194.110.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DC2E7B4 /* 109.194.231.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DC373CA /* 109.195.115.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DC393F8 /* 109.195.147.248/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DC41236 /* 109.196.18.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DC5C1A0 /* 109.197.193.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DC98564 /* 109.201.133.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DC99408 /* 109.201.148.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DE26195 /* 109.226.97.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DE48298 /* 109.228.130.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DE6E7A5 /* 109.230.231.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DE6EC59 /* 109.230.236.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DE97FE9 /* 109.233.127.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DEA24C4 /* 109.234.36.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DEC5809 /* 109.236.88.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DFE5606 /* 109.254.86.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DFF006B /* 109.255.0.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DFFBD87 /* 109.255.189.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6E042F8B /* 110.4.47.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6E43583F /* 110.67.88.63/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6E93A5CA /* 110.147.165.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6F59788D /* 111.89.120.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6F59A849 /* 111.89.168.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6F5A8C51 /* 111.90.140.81/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6F5A92DC /* 111.90.146.220/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6F5A94B2 /* 111.90.148.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x704E06F1 /* 112.78.6.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x71141F2D /* 113.20.31.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x71921957 /* 113.146.25.87/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x7197112D /* 113.151.17.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x71C5335F /* 113.197.51.95/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x72B688D9 /* 114.182.136.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x73463970 /* 115.70.57.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x734D68ED /* 115.77.104.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x7354E85B /* 115.84.232.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x737C70EB /* 115.124.112.235/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x73927FE0 /* 115.146.127.224/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x73A36FBA /* 115.163.111.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x73BAF33C /* 115.186.243.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x73BBF6B8 /* 115.187.246.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x7464807E /* 116.100.128.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x751263F9 /* 117.18.99.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x75C9F002 /* 117.201.240.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x76094F93 /* 118.9.79.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x7612FD23 /* 118.18.253.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x767F6C88 /* 118.127.108.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x76A34A9D /* 118.163.74.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x76D097C0 /* 118.208.151.192/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x76D0DAD3 /* 118.208.218.211/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x773B7F68 /* 119.59.127.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x77EBF988 /* 119.235.249.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x781DD92E /* 120.29.217.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x7838AA63 /* 120.56.170.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x792CD234 /* 121.44.210.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x792DBF12 /* 121.45.191.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x7936AF32 /* 121.54.175.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x794953C0 /* 121.73.83.192/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x7963E40E /* 121.99.228.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x7976CB7A /* 121.118.203.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x797971EA /* 121.121.113.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x797FFA9C /* 121.127.250.156/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x7A3B7991 /* 122.59.121.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x7B1E8847 /* 123.30.136.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x7C521DB5 /* 124.82.29.181/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x7C6D01CF /* 124.109.1.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x7CA8D5E7 /* 124.168.213.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x7CD9F316 /* 124.217.243.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x7CD9FA48 /* 124.217.250.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x7CD9FE37 /* 124.217.254.55/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x7CD9FE46 /* 124.217.254.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x7CD9FE63 /* 124.217.254.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x7CD9FEB1 /* 124.217.254.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x7CF8F4AE /* 124.248.244.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x7D01E599 /* 125.1.229.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x7DD19718 /* 125.209.151.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x7DD4D9C5 /* 125.212.217.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x7DD4DC3C /* 125.212.220.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x7DD4F1B6 /* 125.212.241.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x7DEEFF4B /* 125.238.255.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x7E460792 /* 126.70.7.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x800CB13B /* 128.12.177.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x801E4FCA /* 128.30.79.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x801F0022 /* 128.31.0.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8027081D /* 128.39.8.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80348069 /* 128.52.128.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8034B2E9 /* 128.52.178.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8034B3C0 /* 128.52.179.192/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8044C9FA /* 128.68.201.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8048D327 /* 128.72.211.39/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x807F2821 /* 128.127.40.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x807F2F40 /* 128.127.47.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x807F6A31 /* 128.127.106.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x807F6F19 /* 128.127.111.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8082CC5B /* 128.130.204.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8099927D /* 128.153.146.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7227A /* 128.199.34.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C72305 /* 128.199.35.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C723A2 /* 128.199.35.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7250C /* 128.199.37.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C729EE /* 128.199.41.238/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C72FA0 /* 128.199.47.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C72FEB /* 128.199.47.235/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C73725 /* 128.199.55.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C737CF /* 128.199.55.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C73B14 /* 128.199.59.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C745EA /* 128.199.69.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C75130 /* 128.199.81.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C755A5 /* 128.199.85.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C77A68 /* 128.199.122.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C783A8 /* 128.199.131.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C78407 /* 128.199.132.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7859A /* 128.199.133.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C78A4A /* 128.199.138.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C78BE0 /* 128.199.139.224/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C79C12 /* 128.199.156.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7A36C /* 128.199.163.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7AAF6 /* 128.199.170.246/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7B364 /* 128.199.179.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7C0E6 /* 128.199.192.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7C270 /* 128.199.194.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7C76B /* 128.199.199.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7C778 /* 128.199.199.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7D230 /* 128.199.210.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7DD23 /* 128.199.221.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7E058 /* 128.199.224.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7E42A /* 128.199.228.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7E43D /* 128.199.228.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7EA03 /* 128.199.234.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7EAFC /* 128.199.234.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7EC3C /* 128.199.236.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7F0C1 /* 128.199.240.193/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7F24B /* 128.199.242.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7F4CE /* 128.199.244.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7FB59 /* 128.199.251.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7FCC5 /* 128.199.252.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80D002E9 /* 128.208.2.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80E81239 /* 128.232.18.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x810A73D9 /* 129.10.115.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x810A73DA /* 129.10.115.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x810A73DB /* 129.10.115.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x810A73DC /* 129.10.115.220/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8164226A /* 129.100.34.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x81E8E70A /* 129.232.231.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x81F2DB33 /* 129.242.219.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x823FAD7E /* 130.63.173.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x82950E1F /* 130.149.14.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8295C80A /* 130.149.200.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x82B417E6 /* 130.180.23.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x82B41EFE /* 130.180.30.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x82B43F96 /* 130.180.63.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x82B448B2 /* 130.180.72.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x82B46F5E /* 130.180.111.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x82B96832 /* 130.185.104.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x82B9FA4C /* 130.185.250.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x82B9FA4D /* 130.185.250.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x82B9FAAB /* 130.185.250.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x82C10FBA /* 130.193.15.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x82CCA103 /* 130.204.161.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x82E1FE67 /* 130.225.254.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x82E671E4 /* 130.230.113.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x82E671E5 /* 130.230.113.229/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x82E671E6 /* 130.230.113.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x82E671E7 /* 130.230.113.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x82E671E8 /* 130.230.113.232/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x82E671E9 /* 130.230.113.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x82E671EA /* 130.230.113.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x82E671EB /* 130.230.113.235/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x82E671EC /* 130.230.113.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x82E671ED /* 130.230.113.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x82FF0ABF /* 130.255.10.191/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x82FF48A4 /* 130.255.72.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x83828E62 /* 131.130.142.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x839B477C /* 131.155.71.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x83BC28BC /* 131.188.40.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x83BC28BD /* 131.188.40.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x83D7ACD6 /* 131.215.172.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x83FF05EF /* 131.255.5.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x83FF073A /* 131.255.7.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x84D83602 /* 132.216.54.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x84E69651 /* 132.230.150.81/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8526CAC6 /* 133.38.202.198/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x85827CB9 /* 133.130.124.185/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x85E8E634 /* 133.232.230.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x85F29226 /* 133.242.146.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x85F2924E /* 133.242.146.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x860304E1 /* 134.3.4.225/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x86035FCB /* 134.3.95.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8613B16D /* 134.19.177.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x86229380 /* 134.34.147.128/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8631E95E /* 134.49.233.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x863A2C06 /* 134.58.44.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x863A2C3B /* 134.58.44.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x865B4E8F /* 134.91.78.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x866370A8 /* 134.99.112.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8666167A /* 134.102.22.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8666C865 /* 134.102.200.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x86770302 /* 134.119.3.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x867703A4 /* 134.119.3.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x86770923 /* 134.119.9.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x86771AC1 /* 134.119.26.193/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x867720D0 /* 134.119.32.208/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x867720F7 /* 134.119.32.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x86772487 /* 134.119.36.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8682B52B /* 134.130.181.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8682B531 /* 134.130.181.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8682B5D4 /* 134.130.181.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87177229 /* 135.23.114.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8820EE8D /* 136.32.238.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x883E0ED6 /* 136.62.14.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x883E12DD /* 136.62.18.221/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x883E1876 /* 136.62.24.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x88A8C999 /* 136.168.201.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x88F3019C /* 136.243.1.156/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x88F346C7 /* 136.243.70.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x88F3620C /* 136.243.98.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x88F36686 /* 136.243.102.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x88F36B04 /* 136.243.107.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x88F3723E /* 136.243.114.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x88F39552 /* 136.243.149.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x88F3AE61 /* 136.243.174.97/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x88F3B094 /* 136.243.176.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x88F3B185 /* 136.243.177.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x88F3BBA5 /* 136.243.187.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x88F3D134 /* 136.243.209.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x88F3D689 /* 136.243.214.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x894A15AD /* 137.74.21.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x894A19AF /* 137.74.25.175/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x894A284D /* 137.74.40.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x894A74A8 /* 137.74.116.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x894A74D6 /* 137.74.116.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x894A7534 /* 137.74.117.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x894AA191 /* 137.74.161.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x894AA4D5 /* 137.74.164.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x894AA760 /* 137.74.167.96/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x894AA7A1 /* 137.74.167.161/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x894AA7E0 /* 137.74.167.224/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x894AA9F1 /* 137.74.169.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x894AAD8F /* 137.74.173.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x894AE084 /* 137.74.224.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x89656D65 /* 137.101.109.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x898708E9 /* 137.135.8.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x89CD7C23 /* 137.205.124.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x89E26F7B /* 137.226.111.123/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8A440004 /* 138.68.0.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8A440077 /* 138.68.0.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8A44060F /* 138.68.6.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8A44082B /* 138.68.8.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8A440AF0 /* 138.68.10.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8A440DAB /* 138.68.13.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8A440E2A /* 138.68.14.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8A440FBF /* 138.68.15.191/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8A4425B2 /* 138.68.37.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8A443215 /* 138.68.50.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8A444545 /* 138.68.69.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8A44505B /* 138.68.80.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8A44506C /* 138.68.80.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8A446159 /* 138.68.97.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8A446BA3 /* 138.68.107.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8A446D32 /* 138.68.109.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8A44815D /* 138.68.129.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8A44829E /* 138.68.130.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8A4486F9 /* 138.68.134.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8A448CD7 /* 138.68.140.215/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8A448E83 /* 138.68.142.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8A4496A8 /* 138.68.150.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8A449F8E /* 138.68.159.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8A44E89B /* 138.68.232.155/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8A4B48B1 /* 138.75.72.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8A75942D /* 138.117.148.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC5044D /* 138.197.4.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC50EE2 /* 138.197.14.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC53B16 /* 138.197.59.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC54C0C /* 138.197.76.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC56030 /* 138.197.96.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC57DFC /* 138.197.125.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC58551 /* 138.197.133.81/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC585FF /* 138.197.133.255/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC58893 /* 138.197.136.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC58B4F /* 138.197.139.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC58F84 /* 138.197.143.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC5C2E6 /* 138.197.194.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC5C432 /* 138.197.196.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC5CA23 /* 138.197.202.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC5CD32 /* 138.197.205.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC5CFB0 /* 138.197.207.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC5CFB1 /* 138.197.207.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC5CFF3 /* 138.197.207.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC5D1FE /* 138.197.209.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC5D60B /* 138.197.214.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC5DFFA /* 138.197.223.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC9034B /* 138.201.3.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC9396D /* 138.201.57.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC93ACE /* 138.201.58.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC94B06 /* 138.201.75.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC953AB /* 138.201.83.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC95BD2 /* 138.201.91.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC95C74 /* 138.201.92.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC95CB7 /* 138.201.92.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC95EF9 /* 138.201.94.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC95F7D /* 138.201.95.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC96AD1 /* 138.201.106.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC975A7 /* 138.201.117.167/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC976FE /* 138.201.118.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC98411 /* 138.201.132.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC9876C /* 138.201.135.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC98FBA /* 138.201.143.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC99514 /* 138.201.149.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC99515 /* 138.201.149.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC99AD1 /* 138.201.154.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC99E2C /* 138.201.158.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC9A90C /* 138.201.169.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC9C6A4 /* 138.201.198.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC9D3EA /* 138.201.211.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC9D3EB /* 138.201.211.235/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC9F557 /* 138.201.245.87/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC9F702 /* 138.201.247.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC9F712 /* 138.201.247.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC9FFF5 /* 138.201.255.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8ACCAB67 /* 138.204.171.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8ADB2B8D /* 138.219.43.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B121923 /* 139.18.25.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B0006 /* 139.59.0.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B0025 /* 139.59.0.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B005E /* 139.59.0.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B0282 /* 139.59.2.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B02BA /* 139.59.2.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B077C /* 139.59.7.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B0886 /* 139.59.8.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B0B21 /* 139.59.11.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B0DD9 /* 139.59.13.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B1005 /* 139.59.16.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B1453 /* 139.59.20.83/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B16D5 /* 139.59.22.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B1AA7 /* 139.59.26.167/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B1D2E /* 139.59.29.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B1F4C /* 139.59.31.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B1FE3 /* 139.59.31.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B20BE /* 139.59.32.190/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B21AC /* 139.59.33.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B22D1 /* 139.59.34.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B2439 /* 139.59.36.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B2495 /* 139.59.36.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B2498 /* 139.59.36.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B2565 /* 139.59.37.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B2735 /* 139.59.39.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B29C5 /* 139.59.41.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B2ADF /* 139.59.42.223/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B2BBA /* 139.59.43.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B2C60 /* 139.59.44.96/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B2C79 /* 139.59.44.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B2E46 /* 139.59.46.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B2EAB /* 139.59.46.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B81A3 /* 139.59.129.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B9BAE /* 139.59.155.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B9ED2 /* 139.59.158.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3BAC5D /* 139.59.172.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3BEBAC /* 139.59.235.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B8CB597 /* 139.140.181.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA20728 /* 139.162.7.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA20991 /* 139.162.9.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA20A48 /* 139.162.10.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA2100D /* 139.162.16.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA213E9 /* 139.162.19.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA21C17 /* 139.162.28.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA21C1F /* 139.162.28.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA22C80 /* 139.162.44.128/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA239A7 /* 139.162.57.167/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA23D2C /* 139.162.61.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA23DB1 /* 139.162.61.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA24E3D /* 139.162.78.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA254B8 /* 139.162.84.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA26052 /* 139.162.96.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA2706F /* 139.162.112.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA28E1B /* 139.162.142.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA28E78 /* 139.162.142.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA29085 /* 139.162.144.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA29424 /* 139.162.148.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA29610 /* 139.162.150.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA29756 /* 139.162.151.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA2A543 /* 139.162.165.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA2B513 /* 139.162.181.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA2B978 /* 139.162.185.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA2BAB3 /* 139.162.186.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA2BFF3 /* 139.162.191.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA2D9DB /* 139.162.217.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA2E2F5 /* 139.162.226.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA2E81C /* 139.162.232.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA2F145 /* 139.162.241.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA2F578 /* 139.162.245.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA2F80D /* 139.162.248.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C71D049 /* 140.113.208.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C71D05B /* 140.113.208.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C71EB97 /* 140.113.235.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C73BDA4 /* 140.115.189.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C73BDBD /* 140.115.189.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C8A90AA /* 140.138.144.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8CC0DA8B /* 140.192.218.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8D00920E /* 141.0.146.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8D142143 /* 141.20.33.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8D142144 /* 141.20.33.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8D146719 /* 141.20.103.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8D160A39 /* 141.22.10.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8D337D10 /* 141.51.125.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8D369FB8 /* 141.54.159.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8D45CD79 /* 141.69.205.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8D467DE8 /* 141.70.125.232/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8D69433A /* 141.105.67.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8D8A8DD0 /* 141.138.141.208/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8DAA0235 /* 141.170.2.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8DFF0B78 /* 141.255.11.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8DFFA1A6 /* 141.255.161.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8DFFA1A7 /* 141.255.161.167/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8DFFA566 /* 141.255.165.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8DFFA68E /* 141.255.166.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8DFFA696 /* 141.255.166.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8DFFA6BD /* 141.255.166.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8DFFBDA1 /* 141.255.189.161/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E0420C4 /* 142.4.32.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E04D3BD /* 142.4.211.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E04D480 /* 142.4.212.128/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E04D6BB /* 142.4.214.187/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E36BAB2 /* 142.54.186.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E36BEFA /* 142.54.190.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8F6A3C46 /* 143.106.60.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8F6A3C56 /* 143.106.60.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8FB03433 /* 143.176.52.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8FF8394B /* 143.248.57.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8FF8DF6F /* 143.248.223.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904C06C7 /* 144.76.6.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904C0B64 /* 144.76.11.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904C0E91 /* 144.76.14.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904C1AAF /* 144.76.26.175/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904C1EA7 /* 144.76.30.167/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904C1FCA /* 144.76.31.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904C25F2 /* 144.76.37.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904C2879 /* 144.76.40.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904C2AEF /* 144.76.42.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904C2D4A /* 144.76.45.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904C3225 /* 144.76.50.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904C357D /* 144.76.53.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904C3D28 /* 144.76.61.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904C4042 /* 144.76.64.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904C438C /* 144.76.67.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904C4629 /* 144.76.70.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904C498C /* 144.76.73.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904C5044 /* 144.76.80.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904C51D7 /* 144.76.81.215/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904C5ACD /* 144.76.90.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904C5CB0 /* 144.76.92.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904C6007 /* 144.76.96.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904C6975 /* 144.76.105.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904C6D8A /* 144.76.109.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904C7055 /* 144.76.112.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904C75A9 /* 144.76.117.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904C843C /* 144.76.132.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904C9E88 /* 144.76.158.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904CA35D /* 144.76.163.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904CACBB /* 144.76.172.187/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904CAFCD /* 144.76.175.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904CFDE5 /* 144.76.253.229/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x90880513 /* 144.136.5.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x90D90FA4 /* 144.217.15.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x90D90FB3 /* 144.217.15.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x90D9388C /* 144.217.56.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x90D9388D /* 144.217.56.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x90D93CD3 /* 144.217.60.211/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x90D93CEF /* 144.217.60.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x90D9574E /* 144.217.87.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x90D95A8A /* 144.217.90.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x90D9632E /* 144.217.99.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x90D9A177 /* 144.217.161.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x90D9A29E /* 144.217.162.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x918102BC /* 145.129.2.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x91842AEA /* 145.132.42.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x91852984 /* 145.133.41.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x91FFF332 /* 145.255.243.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9200207A /* 146.0.32.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x92002084 /* 146.0.32.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x92002090 /* 146.0.32.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x92002A2B /* 146.0.42.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x92002B79 /* 146.0.43.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x92002B7E /* 146.0.43.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x92004D32 /* 146.0.77.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x92004FF3 /* 146.0.79.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x923449B4 /* 146.52.73.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x92345305 /* 146.52.83.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x923496A2 /* 146.52.150.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9234CF31 /* 146.52.207.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x92732C7C /* 146.115.44.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9273918F /* 146.115.145.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9273A25B /* 146.115.162.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x92B98269 /* 146.185.130.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x92B983EF /* 146.185.131.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x92B98823 /* 146.185.136.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x92B98DA3 /* 146.185.141.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x92B99170 /* 146.185.145.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x92B996DB /* 146.185.150.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x92B99BDA /* 146.185.155.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x92B99D3D /* 146.185.157.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x92B9A01E /* 146.185.160.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x92B9A32C /* 146.185.163.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x92B9A374 /* 146.185.163.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x92B9AA23 /* 146.185.170.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x92B9B024 /* 146.185.176.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x92B9B167 /* 146.185.177.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x92B9BDC5 /* 146.185.189.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x92B9BDCB /* 146.185.189.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x92B9FB28 /* 146.185.251.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x92B9FD65 /* 146.185.253.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x92FF39E4 /* 146.255.57.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9353AF2F /* 147.83.175.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9393BD78 /* 147.147.189.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x93AFBB8F /* 147.175.187.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x93AFBBB4 /* 147.175.187.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x93FB2ADD /* 147.251.42.221/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x94FB2AA4 /* 148.251.42.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x94FB31B4 /* 148.251.49.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x94FB324A /* 148.251.50.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x94FB37F6 /* 148.251.55.246/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x94FB4464 /* 148.251.68.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x94FB5884 /* 148.251.88.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x94FB71E6 /* 148.251.113.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x94FB809C /* 148.251.128.156/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x94FB8854 /* 148.251.136.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x94FB97F0 /* 148.251.151.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x94FBA8E2 /* 148.251.168.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x94FBB019 /* 148.251.176.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x94FBB652 /* 148.251.182.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x94FBBEE5 /* 148.251.190.229/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x94FBCE86 /* 148.251.206.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x94FBD635 /* 148.251.214.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x94FBDDA3 /* 148.251.221.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x94FBE30E /* 148.251.227.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x94FBEEFD /* 148.251.238.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x94FBF597 /* 148.251.245.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x94FBFEE5 /* 148.251.254.229/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x94FBFF5C /* 148.251.255.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9509001B /* 149.9.0.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x953801CC /* 149.56.1.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95380C4E /* 149.56.12.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95381954 /* 149.56.25.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95382DC8 /* 149.56.45.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x953860A5 /* 149.56.96.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95386319 /* 149.56.99.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95386494 /* 149.56.100.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95386776 /* 149.56.103.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95386CC4 /* 149.56.108.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95386EFA /* 149.56.110.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x953884A8 /* 149.56.132.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9538B938 /* 149.56.185.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9538C943 /* 149.56.201.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9538C9A8 /* 149.56.201.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9538CC7E /* 149.56.204.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9538CCDA /* 149.56.204.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9538DFF0 /* 149.56.223.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9538DFF2 /* 149.56.223.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9538DFF4 /* 149.56.223.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9538E510 /* 149.56.229.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9538E511 /* 149.56.229.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9538E98E /* 149.56.233.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x955675C2 /* 149.86.117.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x955B5261 /* 149.91.82.97/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x959A9879 /* 149.154.152.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x959A9D50 /* 149.154.157.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x959A9E7A /* 149.154.158.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x959A9EE4 /* 149.154.158.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x959A9F57 /* 149.154.159.87/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x959A9FAC /* 149.154.159.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95AC95AA /* 149.172.149.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95CA026A /* 149.202.2.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95CA186A /* 149.202.24.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95CA3157 /* 149.202.49.87/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95CA39D6 /* 149.202.57.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95CA3A29 /* 149.202.58.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95CA3F64 /* 149.202.63.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95CA3FD6 /* 149.202.63.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95CA62A0 /* 149.202.98.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95CA62A1 /* 149.202.98.161/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95CAA045 /* 149.202.160.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95CAB5D6 /* 149.202.181.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95CABE0E /* 149.202.190.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95CAC0CB /* 149.202.192.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95CADC50 /* 149.202.220.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95CAEEC6 /* 149.202.238.198/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95CAEECC /* 149.202.238.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95D2A4E4 /* 149.210.164.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95D2DA29 /* 149.210.218.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95D2DD30 /* 149.210.221.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95D2E29B /* 149.210.226.155/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95FF255A /* 149.255.37.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x965F8736 /* 150.95.135.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x965F8A2A /* 150.95.138.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9665F363 /* 150.101.243.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x966B9624 /* 150.107.150.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x966B9665 /* 150.107.150.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x966B9666 /* 150.107.150.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x969202F5 /* 150.146.2.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9701B6D9 /* 151.1.182.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x971B6AE0 /* 151.27.106.224/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x972DDDDB /* 151.45.221.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x97378BF5 /* 151.55.139.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x97437350 /* 151.67.115.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x97502591 /* 151.80.37.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x97502643 /* 151.80.38.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x97502848 /* 151.80.40.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x97502A67 /* 151.80.42.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x97502D31 /* 151.80.45.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9750388D /* 151.80.56.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x97503B90 /* 151.80.59.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x97506DA8 /* 151.80.109.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x975073B4 /* 151.80.115.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9750800C /* 151.80.128.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x97509399 /* 151.80.147.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9750EE98 /* 151.80.238.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x97E06098 /* 151.224.96.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x97E46D46 /* 151.228.109.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x97EC066E /* 151.236.6.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x97EC06C2 /* 151.236.6.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x97EC0B72 /* 151.236.11.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x97EC0C7E /* 151.236.12.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x97ECDA43 /* 151.236.218.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x97ECDD2C /* 151.236.221.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x97ECDED9 /* 151.236.222.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x97EDBE32 /* 151.237.190.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x97EDE583 /* 151.237.229.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x995C7EEA /* 153.92.126.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x995C7F69 /* 153.92.127.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x995C7FCE /* 153.92.127.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x995C7FEF /* 153.92.127.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x99782A89 /* 153.120.42.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9978ABB7 /* 153.120.171.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x997925A6 /* 153.121.37.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x99792C1E /* 153.121.44.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x997E9E41 /* 153.126.158.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x997EC45F /* 153.126.196.95/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x997FC77C /* 153.127.199.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x999562FB /* 153.149.98.251/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x99F80697 /* 153.248.6.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9A23AFE1 /* 154.35.175.225/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9A31D448 /* 154.49.212.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9A4699AF /* 154.70.153.175/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9A7F3C5C /* 154.127.60.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9A7F3C9A /* 154.127.60.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9A7F3D86 /* 154.127.61.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9A7F3DF9 /* 154.127.61.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9B0409EA /* 155.4.9.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9B0467D6 /* 155.4.103.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9B04B45D /* 155.4.180.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9B04D4B5 /* 155.4.212.181/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9B5EB5B3 /* 155.94.181.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9B620506 /* 155.98.5.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9B8526E2 /* 155.133.38.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9BFE31B2 /* 155.254.49.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E3AAA02 /* 158.58.170.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E3AAA1B /* 158.58.170.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E3AAA3F /* 158.58.170.63/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E3AAA42 /* 158.58.170.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E3AAA43 /* 158.58.170.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E3AAA63 /* 158.58.170.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E3AAA6F /* 158.58.170.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E3AAA8F /* 158.58.170.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E3AAA95 /* 158.58.170.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E3AAA9D /* 158.58.170.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E3AAA9F /* 158.58.170.159/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E3AAAB7 /* 158.58.170.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E3AAAC3 /* 158.58.170.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E3AAADC /* 158.58.170.220/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E3AAB8F /* 158.58.171.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E3AAB90 /* 158.58.171.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E3AAD4E /* 158.58.173.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E452483 /* 158.69.36.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E452498 /* 158.69.36.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E4525D5 /* 158.69.37.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E45304D /* 158.69.48.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E455C7F /* 158.69.92.127/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E4566D0 /* 158.69.102.208/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E457723 /* 158.69.119.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E45C1F3 /* 158.69.193.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E45CC24 /* 158.69.204.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E45CD5C /* 158.69.205.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E45CDCC /* 158.69.205.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E45CDD7 /* 158.69.205.215/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E45CDF7 /* 158.69.205.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E45CE9A /* 158.69.206.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E45CFD8 /* 158.69.207.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E45D59A /* 158.69.213.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E45D812 /* 158.69.216.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E45D922 /* 158.69.217.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E45F750 /* 158.69.247.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E8200F2 /* 158.130.0.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9EC19905 /* 158.193.153.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9EC19906 /* 158.193.153.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9EFF04F1 /* 158.255.4.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9EFF0575 /* 158.255.5.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9EFF05B4 /* 158.255.5.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9EFF05B5 /* 158.255.5.181/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9EFF05CE /* 158.255.5.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9EFF05CF /* 158.255.5.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9EFF06F2 /* 158.255.6.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9EFF073D /* 158.255.7.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9EFFD4B2 /* 158.255.212.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9EFFD729 /* 158.255.215.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F7A02D1 /* 159.122.2.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F94BA90 /* 159.148.186.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F94BAA2 /* 159.148.186.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F94BAC0 /* 159.148.186.192/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F94BAC4 /* 159.148.186.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F94BAC7 /* 159.148.186.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F94BAEC /* 159.148.186.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9FCB0156 /* 159.203.1.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9FCB03E0 /* 159.203.3.224/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9FCB0551 /* 159.203.5.81/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9FCB0F64 /* 159.203.15.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9FCB0F94 /* 159.203.15.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9FCB1017 /* 159.203.16.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9FCB10E9 /* 159.203.16.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9FCB1167 /* 159.203.17.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9FCB1263 /* 159.203.18.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9FCB1633 /* 159.203.22.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9FCB1B05 /* 159.203.27.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9FCB1B6F /* 159.203.27.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9FCB1DF0 /* 159.203.29.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9FCB2095 /* 159.203.32.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9FCB2136 /* 159.203.33.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9FCB26FA /* 159.203.38.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9FCB2977 /* 159.203.41.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9FCB2985 /* 159.203.41.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9FCB2A6B /* 159.203.42.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9FCB2EAE /* 159.203.46.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9FCB2FA6 /* 159.203.47.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9FCB5558 /* 159.203.85.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9FCB678A /* 159.203.103.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9FCBABFE /* 159.203.171.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9FCBAD26 /* 159.203.173.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9FCBC148 /* 159.203.193.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9FCBC1AF /* 159.203.193.175/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9FCBDB65 /* 159.203.219.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9FCBE019 /* 159.203.224.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9FCBEAF4 /* 159.203.234.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9FCBFBEC /* 159.203.251.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9FCBFDB7 /* 159.203.253.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA135A068 /* 161.53.160.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA161C332 /* 161.97.195.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA161C71E /* 161.97.199.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2C1E616 /* 162.193.230.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2DAEF7D /* 162.218.239.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2DB0739 /* 162.219.7.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2DCA5B9 /* 162.220.165.185/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2DCDA6D /* 162.220.218.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2DCF6E6 /* 162.220.246.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2DDC939 /* 162.221.201.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2DDCAE6 /* 162.221.202.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2DE3486 /* 162.222.52.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F308A1 /* 162.243.8.161/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F32430 /* 162.243.36.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F337CB /* 162.243.55.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F33C60 /* 162.243.60.96/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F3411C /* 162.243.65.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F348C6 /* 162.243.72.198/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F364E1 /* 162.243.100.225/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F3733B /* 162.243.115.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F386BC /* 162.243.134.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F3969C /* 162.243.150.156/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F396E5 /* 162.243.150.229/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F3A689 /* 162.243.166.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F3C376 /* 162.243.195.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F419D6 /* 162.244.25.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F41A09 /* 162.244.26.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F41A4C /* 162.244.26.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F517B0 /* 162.245.23.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F74807 /* 162.247.72.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F7481B /* 162.247.72.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F748C7 /* 162.247.72.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F748C8 /* 162.247.72.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F748C9 /* 162.247.72.201/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F748CA /* 162.247.72.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F748D5 /* 162.247.72.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F748D8 /* 162.247.72.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F748D9 /* 162.247.72.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F7494A /* 162.247.73.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F749C3 /* 162.247.73.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F749CC /* 162.247.73.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F749CE /* 162.247.73.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F74B76 /* 162.247.75.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F80A84 /* 162.248.10.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F80BB0 /* 162.248.11.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F8A50E /* 162.248.165.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2FCCC3E /* 162.252.204.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2FCF250 /* 162.252.242.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2FCF314 /* 162.252.243.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA31611D3 /* 163.22.17.211/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA32C709C /* 163.44.112.156/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA32C70E6 /* 163.44.112.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA32C951F /* 163.44.149.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA39EA814 /* 163.158.168.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA39EB313 /* 163.158.179.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC0826 /* 163.172.8.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC0AD0 /* 163.172.10.208/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC0DA5 /* 163.172.13.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC0EDD /* 163.172.14.221/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC1560 /* 163.172.21.96/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC1976 /* 163.172.25.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC1B27 /* 163.172.27.39/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC1B3E /* 163.172.27.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC1D14 /* 163.172.29.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC1D15 /* 163.172.29.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC23D3 /* 163.172.35.211/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC23F7 /* 163.172.35.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC23F9 /* 163.172.35.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC2421 /* 163.172.36.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC249C /* 163.172.36.156/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC2AEF /* 163.172.42.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC2D1E /* 163.172.45.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC38F8 /* 163.172.56.248/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC3D1C /* 163.172.61.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC43B4 /* 163.172.67.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC5203 /* 163.172.82.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC527C /* 163.172.82.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC545F /* 163.172.84.95/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC59E3 /* 163.172.89.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC5A80 /* 163.172.90.128/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC6B92 /* 163.172.107.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC7316 /* 163.172.115.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC8097 /* 163.172.128.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC811D /* 163.172.129.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC8132 /* 163.172.129.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC8143 /* 163.172.129.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC8251 /* 163.172.130.81/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC8358 /* 163.172.131.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC83A4 /* 163.172.131.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC83C0 /* 163.172.131.192/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC84B2 /* 163.172.132.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC8536 /* 163.172.133.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC8627 /* 163.172.134.39/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC86EE /* 163.172.134.238/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC87AC /* 163.172.135.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC8865 /* 163.172.136.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC8904 /* 163.172.137.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC898D /* 163.172.137.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC8A16 /* 163.172.138.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC8B68 /* 163.172.139.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC8B6F /* 163.172.139.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC8B86 /* 163.172.139.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC8B91 /* 163.172.139.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC8D0A /* 163.172.141.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC8D21 /* 163.172.141.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC8E0F /* 163.172.142.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC8E5C /* 163.172.142.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC90EC /* 163.172.144.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC915B /* 163.172.145.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC92CC /* 163.172.146.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC92E8 /* 163.172.146.232/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC957A /* 163.172.149.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC959B /* 163.172.149.155/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC972F /* 163.172.151.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC97AE /* 163.172.151.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC98E7 /* 163.172.152.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC98ED /* 163.172.152.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC990C /* 163.172.153.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC9BB5 /* 163.172.155.181/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC9C4C /* 163.172.156.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC9C89 /* 163.172.156.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC9DD5 /* 163.172.157.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC9F1B /* 163.172.159.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC9FE7 /* 163.172.159.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACA0B6 /* 163.172.160.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACA0EF /* 163.172.160.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACA287 /* 163.172.162.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACA2B6 /* 163.172.162.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACA506 /* 163.172.165.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACA5CB /* 163.172.165.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACA601 /* 163.172.166.1/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACA603 /* 163.172.166.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACA71C /* 163.172.167.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACAA17 /* 163.172.170.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACAA34 /* 163.172.170.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACAAD4 /* 163.172.170.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACAED1 /* 163.172.174.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACAFAE /* 163.172.175.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACB0A7 /* 163.172.176.167/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACB2B6 /* 163.172.178.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACB5A2 /* 163.172.181.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACB5F0 /* 163.172.181.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACB774 /* 163.172.183.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACB7A1 /* 163.172.183.161/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACB7DC /* 163.172.183.220/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACB984 /* 163.172.185.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACBAC8 /* 163.172.186.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACBB98 /* 163.172.187.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACBD64 /* 163.172.189.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACBE22 /* 163.172.190.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACBE6E /* 163.172.190.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACC235 /* 163.172.194.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACC93E /* 163.172.201.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACD1A1 /* 163.172.209.161/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACD1A2 /* 163.172.209.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACD1D6 /* 163.172.209.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACD1D8 /* 163.172.209.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACD5C9 /* 163.172.213.201/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACD666 /* 163.172.214.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACD73C /* 163.172.215.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACD74E /* 163.172.215.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACD8C3 /* 163.172.216.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACD8CA /* 163.172.216.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACD932 /* 163.172.217.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACD999 /* 163.172.217.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACDDD1 /* 163.172.221.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACDF52 /* 163.172.223.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACDF84 /* 163.172.223.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACDFA5 /* 163.172.223.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACDFC8 /* 163.172.223.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACDFD7 /* 163.172.223.215/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACE4BF /* 163.172.228.191/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA43A5114 /* 164.58.81.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA44601C1 /* 164.70.1.193/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA44D85DC /* 164.77.133.220/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA48414D1 /* 164.132.20.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA4842DF0 /* 164.132.45.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA48431CD /* 164.132.49.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA484335B /* 164.132.51.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA4844DAF /* 164.132.77.175/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA48461EA /* 164.132.97.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA4846A62 /* 164.132.106.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA4846B6C /* 164.132.107.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA48498B8 /* 164.132.152.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA484C426 /* 164.132.196.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA484D183 /* 164.132.209.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA484D464 /* 164.132.212.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA484E1F8 /* 164.132.225.248/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA484E622 /* 164.132.230.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA484F9F4 /* 164.132.249.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA4D774C2 /* 164.215.116.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA5E700F2 /* 165.231.0.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA5FF3BC4 /* 165.255.59.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA5FFD8F5 /* 165.255.216.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA6460F0E /* 166.70.15.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA6465E6A /* 166.70.94.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA646CF02 /* 166.70.207.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA64E6DCB /* 166.78.109.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA64E770D /* 166.78.119.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA65215C8 /* 166.82.21.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA6540737 /* 166.84.7.55/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA73F77A5 /* 167.63.119.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA758236C /* 167.88.35.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA75828AB /* 167.88.40.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA75829C2 /* 167.88.41.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA75871BB /* 167.88.113.187/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA77203A6 /* 167.114.3.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA77207A6 /* 167.114.7.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA7722102 /* 167.114.33.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA7722296 /* 167.114.34.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA772231C /* 167.114.35.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA7722366 /* 167.114.35.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA772236B /* 167.114.35.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA772423D /* 167.114.66.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA7724304 /* 167.114.67.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA77247BD /* 167.114.71.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA7726024 /* 167.114.96.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA7726713 /* 167.114.103.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA7727130 /* 167.114.113.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA7727186 /* 167.114.113.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA7729864 /* 167.114.152.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA7729BF9 /* 167.114.155.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA772AB04 /* 167.114.171.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA772ACDB /* 167.114.172.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA772DB3D /* 167.114.219.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA772E668 /* 167.114.230.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA772ED8C /* 167.114.237.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA772F566 /* 167.114.245.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA7A0B988 /* 167.160.185.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA7A0B9CA /* 167.160.185.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA896FB0F /* 168.150.251.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA8EB431E /* 168.235.67.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA8EB454F /* 168.235.69.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA8EB5AA5 /* 168.235.90.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA8EB5CB7 /* 168.235.92.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA8EB9214 /* 168.235.146.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA8EB99CB /* 168.235.153.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA939A547 /* 169.57.165.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA939A55E /* 169.57.165.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAA48070A /* 170.72.7.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAA4BA257 /* 170.75.162.87/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAA4BA374 /* 170.75.163.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAA4EE41E /* 170.78.228.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAA8C7745 /* 170.140.119.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAB19C109 /* 171.25.193.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAB19C114 /* 171.25.193.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAB19C119 /* 171.25.193.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAB19C14D /* 171.25.193.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAB19C14E /* 171.25.193.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAB19C183 /* 171.25.193.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAB19C184 /* 171.25.193.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAB19C1EB /* 171.25.193.235/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAB4F744F /* 171.79.116.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC56900F /* 172.86.144.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC56940A /* 172.86.148.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC5D333C /* 172.93.51.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC5D3353 /* 172.93.51.83/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC61672F /* 172.97.103.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC634E22 /* 172.99.78.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC71F0D7 /* 172.113.240.215/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xACF18C1A /* 172.241.140.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xACF518E4 /* 172.245.24.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xACF520B9 /* 172.245.32.185/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xACF520BA /* 172.245.32.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xACF5630A /* 172.245.99.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xACF57E46 /* 172.245.126.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xACF57E60 /* 172.245.126.96/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xACF5DB85 /* 172.245.219.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAD03F223 /* 173.3.242.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAD08D34A /* 173.8.211.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAD0EADE3 /* 173.14.173.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAD122918 /* 173.18.41.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAD1C99C7 /* 173.28.153.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAD309D99 /* 173.48.157.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAD32AF5A /* 173.50.175.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAD351E5B /* 173.53.30.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAD429470 /* 173.66.148.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAD431BE1 /* 173.67.27.225/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAD48240E /* 173.72.36.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAD494827 /* 173.73.72.39/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAD4F3E9F /* 173.79.62.159/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAD4FA2DC /* 173.79.162.220/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADA0B4BD /* 173.160.180.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADA4CEB5 /* 173.164.206.181/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADA4DBFA /* 173.164.219.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADA5CF1A /* 173.165.207.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADA5F099 /* 173.165.240.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADD0D572 /* 173.208.213.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADD4C570 /* 173.212.197.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADD56C74 /* 173.213.108.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADD5719B /* 173.213.113.155/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADE45B1D /* 173.228.91.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADE6835A /* 173.230.131.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADE6895B /* 173.230.137.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADE6996D /* 173.230.153.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADE69A5A /* 173.230.154.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADEF4FCB /* 173.239.79.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADEF4FD2 /* 173.239.79.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADFED842 /* 173.254.216.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADFED843 /* 173.254.216.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADFED844 /* 173.254.216.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADFED845 /* 173.254.216.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADFF7392 /* 173.255.115.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFCD71 /* 173.255.205.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFD745 /* 173.255.215.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFD9DE /* 173.255.217.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFDD60 /* 173.255.221.96/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFE28E /* 173.255.226.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFE455 /* 173.255.228.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFE486 /* 173.255.228.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFE508 /* 173.255.229.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFE5C2 /* 173.255.229.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFE77D /* 173.255.231.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFF1EB /* 173.255.241.235/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFF574 /* 173.255.245.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFF6A2 /* 173.255.246.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFFAE7 /* 173.255.250.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAE14C8EF /* 174.20.200.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAE22E1D7 /* 174.34.225.215/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAE33B292 /* 174.51.178.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAE43DA0C /* 174.67.218.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAE444AE7 /* 174.68.74.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAE6113E6 /* 174.97.19.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAE64402E /* 174.100.64.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAE681A7D /* 174.104.26.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAE7FE48A /* 174.127.228.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAE886952 /* 174.136.105.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAE886953 /* 174.136.105.83/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAE886C52 /* 174.136.108.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAE8DC829 /* 174.141.200.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB008995C /* 176.8.153.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB00901D3 /* 176.9.1.211/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB00904CE /* 176.9.4.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0090574 /* 176.9.5.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0091FD7 /* 176.9.31.215/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0092626 /* 176.9.38.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB00927DA /* 176.9.39.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0092831 /* 176.9.40.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0092B1A /* 176.9.43.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB00932F0 /* 176.9.50.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0093534 /* 176.9.53.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0093603 /* 176.9.54.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB009368E /* 176.9.54.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0094B6C /* 176.9.75.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0095425 /* 176.9.84.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB009558D /* 176.9.85.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0095AD7 /* 176.9.90.215/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0096386 /* 176.9.99.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0096623 /* 176.9.102.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0096708 /* 176.9.103.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0096E12 /* 176.9.110.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0096E8A /* 176.9.110.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB00972B6 /* 176.9.114.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0097516 /* 176.9.117.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0097A33 /* 176.9.122.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB009859A /* 176.9.133.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0098C6C /* 176.9.140.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0098FD0 /* 176.9.143.208/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB00993D5 /* 176.9.147.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB00994B0 /* 176.9.148.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0099E76 /* 176.9.158.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB009B42F /* 176.9.180.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB009BEF0 /* 176.9.190.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB009C0AB /* 176.9.192.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB009D740 /* 176.9.215.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A63C8 /* 176.10.99.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A63C9 /* 176.10.99.201/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A63CA /* 176.10.99.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A63CB /* 176.10.99.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A63CC /* 176.10.99.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A63CD /* 176.10.99.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A63CE /* 176.10.99.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A63CF /* 176.10.99.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A63D0 /* 176.10.99.208/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A63D1 /* 176.10.99.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A68F0 /* 176.10.104.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A68F3 /* 176.10.104.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A6BB4 /* 176.10.107.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A8346 /* 176.10.131.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB00AD7A4 /* 176.10.215.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB00AD98E /* 176.10.217.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB00AFFFD /* 176.10.255.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB00F7438 /* 176.15.116.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB014C4C1 /* 176.20.196.193/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB014EA66 /* 176.20.234.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0172222 /* 176.23.34.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0189B30 /* 176.24.155.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB01F0B7A /* 176.31.11.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB01F1760 /* 176.31.23.96/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB01F1C3F /* 176.31.28.63/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB01F2395 /* 176.31.35.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB01F2B33 /* 176.31.43.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB01F2D03 /* 176.31.45.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB01F5073 /* 176.31.80.115/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB01F6E30 /* 176.31.110.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB01F748C /* 176.31.116.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB01F7506 /* 176.31.117.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB01F78D7 /* 176.31.120.215/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB01F7E90 /* 176.31.126.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB01F9CC7 /* 176.31.156.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB01FAB0F /* 176.31.171.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB01FB49D /* 176.31.180.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB01FB8FF /* 176.31.184.255/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB01FBF1A /* 176.31.191.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB01FC87A /* 176.31.200.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB01FD79D /* 176.31.215.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0228589 /* 176.34.133.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0268C0D /* 176.38.140.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0269D26 /* 176.38.157.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB026A34D /* 176.38.163.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB026B1D0 /* 176.38.177.208/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB035168E /* 176.53.22.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB038EC5F /* 176.56.236.95/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB038EDBF /* 176.56.237.191/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB03A60C7 /* 176.58.96.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB03A6462 /* 176.58.100.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB03A6E42 /* 176.58.110.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB03A7122 /* 176.58.113.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB03A7816 /* 176.58.120.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB043A8D2 /* 176.67.168.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB043A9FE /* 176.67.169.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0653809 /* 176.101.56.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0653B22 /* 176.101.59.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0686AD0 /* 176.104.106.208/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB070E847 /* 176.112.232.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0728075 /* 176.114.128.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB072F82F /* 176.114.248.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB073FFA0 /* 176.115.255.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0746831 /* 176.116.104.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB07B01FD /* 176.123.1.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB07B0208 /* 176.123.2.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB07B02FA /* 176.123.2.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB07B02FE /* 176.123.2.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB07B03B4 /* 176.123.3.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB07B03D4 /* 176.123.3.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB07B04AB /* 176.123.4.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB07B07C5 /* 176.123.7.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB07B1A08 /* 176.123.26.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB07B1D38 /* 176.123.29.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB07EF231 /* 176.126.242.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB07EFC0B /* 176.126.252.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB07EFC0C /* 176.126.252.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0804B55 /* 176.128.75.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB082E4AD /* 176.130.228.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0881911 /* 176.136.25.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0889529 /* 176.136.149.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB08F08C3 /* 176.143.8.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0952D53 /* 176.149.45.83/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB09E8A7A /* 176.158.138.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB09E9B78 /* 176.158.155.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB09F0253 /* 176.159.2.83/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB09F0B1E /* 176.159.11.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0BD77B6 /* 176.189.119.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0C0B18F /* 176.192.177.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0C0C197 /* 176.192.193.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0C2F247 /* 176.194.242.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0C68452 /* 176.198.132.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0C694D1 /* 176.198.148.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0C6CC54 /* 176.198.204.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0C75545 /* 176.199.85.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0C79952 /* 176.199.153.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0C7DA8E /* 176.199.218.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0D5958D /* 176.213.149.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0D63585 /* 176.214.53.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0E29A3C /* 176.226.154.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB1CDB43D /* 177.205.180.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB203BAF1 /* 178.3.186.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB20441E6 /* 178.4.65.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2078D71 /* 178.7.141.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2083C01 /* 178.8.60.1/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB20A3039 /* 178.10.48.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB20A53E1 /* 178.10.83.225/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB20A6F56 /* 178.10.111.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB210D037 /* 178.16.208.55/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB210D038 /* 178.16.208.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB210D039 /* 178.16.208.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB210D03A /* 178.16.208.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB210D03B /* 178.16.208.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB210D03C /* 178.16.208.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB210D03D /* 178.16.208.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB210D03E /* 178.16.208.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AA1B /* 178.17.170.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AA4D /* 178.17.170.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AA95 /* 178.17.170.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AAA4 /* 178.17.170.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AAB3 /* 178.17.170.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AAD4 /* 178.17.170.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AB28 /* 178.17.171.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AB2B /* 178.17.171.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AB56 /* 178.17.171.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AB5D /* 178.17.171.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AD16 /* 178.17.173.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AE02 /* 178.17.174.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AE0A /* 178.17.174.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AE20 /* 178.17.174.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AE4F /* 178.17.174.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB21253D7 /* 178.18.83.215/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2136072 /* 178.19.96.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB21368E3 /* 178.19.104.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2143710 /* 178.20.55.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2143712 /* 178.20.55.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2183362 /* 178.24.51.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2189BC3 /* 178.24.155.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB219DB1E /* 178.25.219.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB21A856D /* 178.26.133.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB21B5735 /* 178.27.87.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB21B79E6 /* 178.27.121.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB220225B /* 178.32.34.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2202F8C /* 178.32.47.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB220355E /* 178.32.53.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB220422B /* 178.32.66.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2204C5F /* 178.32.76.95/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2206457 /* 178.32.100.87/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB220B560 /* 178.32.181.96/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB220B561 /* 178.32.181.97/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB220B562 /* 178.32.181.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB220B563 /* 178.32.181.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB220BD58 /* 178.32.189.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB220BE0F /* 178.32.190.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB220D861 /* 178.32.216.97/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB220D892 /* 178.32.216.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB220D944 /* 178.32.217.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB220DC3D /* 178.32.220.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB220DCBA /* 178.32.220.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB220DD3A /* 178.32.221.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB220DD97 /* 178.32.221.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB220DDCF /* 178.32.221.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB220DE15 /* 178.32.222.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB220DE7D /* 178.32.222.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2216B6D /* 178.33.107.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB221B7FB /* 178.33.183.251/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB221BC93 /* 178.33.188.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB22D27CC /* 178.45.39.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB22DC8CD /* 178.45.200.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB231FDD7 /* 178.49.253.215/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23CA523 /* 178.60.165.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E08BD /* 178.62.8.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E0999 /* 178.62.9.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E1475 /* 178.62.20.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E1624 /* 178.62.22.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E18D4 /* 178.62.24.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E2440 /* 178.62.36.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E2520 /* 178.62.37.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E2B05 /* 178.62.43.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E2E07 /* 178.62.46.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E3A2B /* 178.62.58.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E3C25 /* 178.62.60.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E4212 /* 178.62.66.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E48DC /* 178.62.72.220/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E4FE3 /* 178.62.79.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E5660 /* 178.62.86.96/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E56CE /* 178.62.86.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E586F /* 178.62.88.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E5D24 /* 178.62.93.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E5EF3 /* 178.62.94.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E64DC /* 178.62.100.220/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E6939 /* 178.62.105.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E6BC2 /* 178.62.107.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E6DA4 /* 178.62.109.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E7D7D /* 178.62.125.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23EADCB /* 178.62.173.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23EB893 /* 178.62.184.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23EBA9B /* 178.62.186.155/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23EC131 /* 178.62.193.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23EC447 /* 178.62.196.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23EC513 /* 178.62.197.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23EC552 /* 178.62.197.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23EC636 /* 178.62.198.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23EC7E2 /* 178.62.199.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23EC90F /* 178.62.201.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23ECA3B /* 178.62.202.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23ECB7E /* 178.62.203.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23ECCE0 /* 178.62.204.224/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23ED28A /* 178.62.210.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23ED9E9 /* 178.62.217.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23EDED6 /* 178.62.222.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23EF4A8 /* 178.62.244.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23EFBB8 /* 178.62.251.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23EFC52 /* 178.62.252.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23EFCEA /* 178.62.252.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23EFD06 /* 178.62.253.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23F09A5 /* 178.63.9.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23F1030 /* 178.63.16.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23F1219 /* 178.63.18.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23F190A /* 178.63.25.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23F3D43 /* 178.63.61.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23F41B3 /* 178.63.65.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23F4E08 /* 178.63.78.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23F550E /* 178.63.85.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23F6122 /* 178.63.97.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23F6E97 /* 178.63.110.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23F749D /* 178.63.116.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23F9A5D /* 178.63.154.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23FA2D4 /* 178.63.162.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23FC671 /* 178.63.198.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23FD133 /* 178.63.209.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB240253C /* 178.64.37.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2444089 /* 178.68.64.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB249D276 /* 178.73.210.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB24A158D /* 178.74.21.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB24B94CE /* 178.75.148.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB24D7B29 /* 178.77.123.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB24ED5D6 /* 178.78.213.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB24EEAC3 /* 178.78.234.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB24F86C4 /* 178.79.134.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB24F88E6 /* 178.79.136.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB24F8B11 /* 178.79.139.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB24F90A3 /* 178.79.144.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB24F9EDD /* 178.79.158.221/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB24F9F93 /* 178.79.159.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB24F9FE0 /* 178.79.159.224/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB24FA039 /* 178.79.160.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB24FA198 /* 178.79.161.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB24FA1B1 /* 178.79.161.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB24FA3A9 /* 178.79.163.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB24FA515 /* 178.79.165.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB24FAD93 /* 178.79.173.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB24FB194 /* 178.79.177.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB24FBCD4 /* 178.79.188.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB253BE6C /* 178.83.190.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB25C5A08 /* 178.92.90.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2844E94 /* 178.132.78.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB28C6812 /* 178.140.104.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB29BA723 /* 178.155.167.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB29CCAB2 /* 178.156.202.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2A242D4 /* 178.162.66.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2A2C252 /* 178.162.194.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2A2C2D2 /* 178.162.194.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2A2C30C /* 178.162.195.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2A2C742 /* 178.162.199.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2A2C870 /* 178.162.200.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2A2C871 /* 178.162.200.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2A2C872 /* 178.162.200.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2A2CE11 /* 178.162.206.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2A2CE12 /* 178.162.206.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2A4DC30 /* 178.164.220.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2A4E3FF /* 178.164.227.255/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2AEB438 /* 178.174.180.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2AF8032 /* 178.175.128.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2AF8242 /* 178.175.130.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2AF83C2 /* 178.175.131.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2BFED2B /* 178.191.237.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2C1F126 /* 178.193.241.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2C29763 /* 178.194.151.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2C29935 /* 178.194.153.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2C802E5 /* 178.200.2.229/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2C89DAD /* 178.200.157.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2C8D57E /* 178.200.213.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2C9937D /* 178.201.147.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2CAFFA1 /* 178.202.255.161/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2CBDB0B /* 178.203.219.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2CE7740 /* 178.206.119.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2D12EAD /* 178.209.46.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2D13297 /* 178.209.50.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2D13363 /* 178.209.51.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2D1342F /* 178.209.52.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2D13491 /* 178.209.52.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2D134A2 /* 178.209.52.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2D9B820 /* 178.217.184.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2D9BB27 /* 178.217.187.39/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2DA72AF /* 178.218.114.175/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2DB593B /* 178.219.89.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2EEE084 /* 178.238.224.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2EEE40C /* 178.238.228.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2EEE86E /* 178.238.232.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2EEED2C /* 178.238.237.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2F86C76 /* 178.248.108.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FBE48E /* 178.251.228.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FC1CC8 /* 178.252.28.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE0D5C /* 178.254.13.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE0D7E /* 178.254.13.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE1215 /* 178.254.18.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE1486 /* 178.254.20.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE1AF4 /* 178.254.26.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE1E56 /* 178.254.30.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE2224 /* 178.254.34.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE2755 /* 178.254.39.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE2914 /* 178.254.41.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE2C87 /* 178.254.44.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE3765 /* 178.254.55.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FF94C3 /* 178.255.148.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB32B86CA /* 179.43.134.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB32B86CB /* 179.43.134.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB32B86CC /* 179.43.134.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB32B86CD /* 179.43.134.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB32B92E6 /* 179.43.146.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB32B97E2 /* 179.43.151.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB32B97E3 /* 179.43.151.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB32B97E4 /* 179.43.151.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB32B97E5 /* 179.43.151.229/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB32B97E6 /* 179.43.151.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB32BA0C9 /* 179.43.160.201/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB32BA882 /* 179.43.168.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB32BA8A6 /* 179.43.168.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB32BA90E /* 179.43.169.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB32BBCCE /* 179.43.188.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB330F811 /* 179.48.248.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB36EB595 /* 179.110.181.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB3B337F6 /* 179.179.55.246/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB3B3C9A2 /* 179.179.201.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB40F9869 /* 180.15.152.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB42E910F /* 180.46.145.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB43F539C /* 180.63.83.156/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB4B5900D /* 180.181.144.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB52812CA /* 181.40.18.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB55FC092 /* 181.95.192.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB58B9234 /* 181.139.146.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB58F629E /* 181.143.98.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB6FD812C /* 182.253.129.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB7B53AA6 /* 183.181.58.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB838AD10 /* 184.56.173.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB844B4EE /* 184.68.180.238/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB85A4952 /* 184.90.73.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB8659839 /* 184.101.152.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB86990B4 /* 184.105.144.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB86990B5 /* 184.105.144.181/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB869DC18 /* 184.105.220.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB86A6DF4 /* 184.106.109.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB89CDDB7 /* 184.156.221.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB8A07785 /* 184.160.119.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB8A79277 /* 184.167.146.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB8AEABD3 /* 184.174.171.211/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB8B705CB /* 184.183.5.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9022B54 /* 185.2.43.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9022B57 /* 185.2.43.87/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9045C43 /* 185.4.92.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB90509BC /* 185.5.9.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9061D37 /* 185.6.29.55/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB907FE43 /* 185.7.254.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9083F26 /* 185.8.63.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB908EC83 /* 185.8.236.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB908ED2D /* 185.8.237.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB908EDD0 /* 185.8.237.208/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB908EE8B /* 185.8.238.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9091353 /* 185.9.19.83/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB909517C /* 185.9.81.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB90A445F /* 185.10.68.95/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB90A4477 /* 185.10.68.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB90A448E /* 185.10.68.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB90BB443 /* 185.11.180.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB90C1C74 /* 185.12.28.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB90C2D4F /* 185.12.45.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB90D26C5 /* 185.13.38.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB90D27C5 /* 185.13.39.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB90D27F9 /* 185.13.39.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB90E1C6A /* 185.14.28.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB90E1C9A /* 185.14.28.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB90E1EEE /* 185.14.30.238/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB90EB976 /* 185.14.185.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB90EB9F0 /* 185.14.185.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB90F483E /* 185.15.72.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB90F4975 /* 185.15.73.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB90F5E0E /* 185.15.94.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB90F5E11 /* 185.15.94.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB90FF47C /* 185.15.244.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9103C53 /* 185.16.60.83/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB910AC9B /* 185.16.172.155/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB910AD54 /* 185.16.173.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB910AD56 /* 185.16.173.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB910C8B0 /* 185.16.200.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9156432 /* 185.21.100.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB91564A3 /* 185.21.100.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9156532 /* 185.21.101.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB915D89D /* 185.21.216.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB915D8B7 /* 185.21.216.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB915D8BD /* 185.21.216.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB915D90D /* 185.21.217.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB915D91D /* 185.21.217.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB915D921 /* 185.21.217.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB916AD4E /* 185.22.173.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB916AD72 /* 185.22.173.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB916AD82 /* 185.22.173.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB916ADA2 /* 185.22.173.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB916AE29 /* 185.22.174.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB918E94A /* 185.24.233.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB919304C /* 185.25.48.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB919309D /* 185.25.48.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9193211 /* 185.25.50.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9193267 /* 185.25.50.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9193321 /* 185.25.51.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB919332A /* 185.25.51.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB919D8ED /* 185.25.216.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB91A9C1C /* 185.26.156.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB91A9C29 /* 185.26.156.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB91A9C2D /* 185.26.156.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB91A9C32 /* 185.26.156.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB91BAF18 /* 185.27.175.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB91D0884 /* 185.29.8.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB91D08D3 /* 185.29.8.211/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB91D9CE7 /* 185.29.156.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB91EEE4D /* 185.30.238.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB91FA166 /* 185.31.161.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB91FACEA /* 185.31.172.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB91FE645 /* 185.31.230.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB920A016 /* 185.32.160.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB920DDC9 /* 185.32.221.201/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB920DDE4 /* 185.32.221.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB92200BC /* 185.34.0.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9222102 /* 185.34.33.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9223460 /* 185.34.52.96/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9238A5C /* 185.35.138.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB923CADD /* 185.35.202.221/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB925912C /* 185.37.145.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9260EAB /* 185.38.14.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9260ED6 /* 185.38.14.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9260ED7 /* 185.38.14.215/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9284C0A /* 185.40.76.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9299A82 /* 185.41.154.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB92DC035 /* 185.45.192.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB92F3E51 /* 185.47.62.81/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB92F3F80 /* 185.47.63.128/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB92FDE22 /* 185.47.222.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB932BFFA /* 185.50.191.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9358346 /* 185.53.131.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9385426 /* 185.56.84.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB938AF9A /* 185.56.175.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB93A15C7 /* 185.58.21.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB93C92F5 /* 185.60.146.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB93D8A0D /* 185.61.138.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB93D941D /* 185.61.148.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB93D9450 /* 185.61.148.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB93D9479 /* 185.61.148.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB93D948E /* 185.61.148.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB93D94BD /* 185.61.148.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB93D94C7 /* 185.61.148.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB93D94DD /* 185.61.148.221/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB93D94E4 /* 185.61.148.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB93D9574 /* 185.61.149.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB93D95C1 /* 185.61.149.193/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB93D95F7 /* 185.61.149.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB93EBE17 /* 185.62.190.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB93FBE1C /* 185.63.190.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB93FFD82 /* 185.63.253.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB941C85D /* 185.65.200.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB941CD0A /* 185.65.205.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9426751 /* 185.66.103.81/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB942C80A /* 185.66.200.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB942FA8D /* 185.66.250.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB94535BC /* 185.69.53.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB948B248 /* 185.72.178.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB948F418 /* 185.72.244.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB948F425 /* 185.72.244.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB948F791 /* 185.72.247.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB94927BD /* 185.73.39.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9492C36 /* 185.73.44.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB949DC08 /* 185.73.220.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB949F0CD /* 185.73.240.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB94C916D /* 185.76.145.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB94D8123 /* 185.77.129.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB94E4328 /* 185.78.67.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB950DE69 /* 185.80.222.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB950DE9E /* 185.80.222.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB950DEA4 /* 185.80.222.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9521569 /* 185.82.21.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB952C8D0 /* 185.82.200.208/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB952C936 /* 185.82.201.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB952CB47 /* 185.82.203.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB952CBD1 /* 185.82.203.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB952D8E9 /* 185.82.216.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB952D90E /* 185.82.217.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB952D924 /* 185.82.217.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9564F5C /* 185.86.79.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9569496 /* 185.86.148.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9569518 /* 185.86.149.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9569555 /* 185.86.149.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB95695E6 /* 185.86.149.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB956962C /* 185.86.150.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9569766 /* 185.86.151.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB957B92D /* 185.87.185.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB957B9DD /* 185.87.185.221/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB957BA1B /* 185.87.186.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB95C4409 /* 185.92.68.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB95CDE34 /* 185.92.222.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB95CDED0 /* 185.92.222.208/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB95DB496 /* 185.93.180.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB960581D /* 185.96.88.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB960B41D /* 185.96.180.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9612012 /* 185.97.32.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9612022 /* 185.97.32.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9612024 /* 185.97.32.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9645452 /* 185.100.84.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB964546C /* 185.100.84.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB96454D4 /* 185.100.84.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB96454FB /* 185.100.84.251/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB964553D /* 185.100.85.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9645565 /* 185.100.85.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9645584 /* 185.100.85.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9645593 /* 185.100.85.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB96455BE /* 185.100.85.190/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB96455C0 /* 185.100.85.192/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB96455CF /* 185.100.85.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB96455DC /* 185.100.85.220/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB96455F4 /* 185.100.85.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9645645 /* 185.100.86.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9645656 /* 185.100.86.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9645664 /* 185.100.86.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9645673 /* 185.100.86.115/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9645680 /* 185.100.86.128/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB964569A /* 185.100.86.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB96456F4 /* 185.100.86.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB964571A /* 185.100.87.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB964572B /* 185.100.87.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9645752 /* 185.100.87.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9645759 /* 185.100.87.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB964578F /* 185.100.87.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB96457BA /* 185.100.87.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB96457C0 /* 185.100.87.192/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB96457F1 /* 185.100.87.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB965626C /* 185.101.98.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9656B21 /* 185.101.107.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB967633C /* 185.103.99.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9687802 /* 185.104.120.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9687803 /* 185.104.120.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9687804 /* 185.104.120.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9688CAC /* 185.104.140.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB968B833 /* 185.104.184.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB96BE0D0 /* 185.107.224.208/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB96D9007 /* 185.109.144.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB96D923E /* 185.109.146.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB96D9294 /* 185.109.146.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9709D7E /* 185.112.157.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9709D87 /* 185.112.157.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB970FEC3 /* 185.112.254.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB971804F /* 185.113.128.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9754B1B /* 185.117.75.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9755284 /* 185.117.82.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB975585C /* 185.117.88.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB975763B /* 185.117.118.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB975D709 /* 185.117.215.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB976FB14 /* 185.118.251.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB97893AB /* 185.120.147.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB979A8FE /* 185.121.168.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB97A3BED /* 185.122.59.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB97D213A /* 185.125.33.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB97DD942 /* 185.125.217.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB97DDBCB /* 185.125.219.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB98028EA /* 185.128.40.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9813C83 /* 185.129.60.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9813E3E /* 185.129.62.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9813E3F /* 185.129.62.63/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB98194D2 /* 185.129.148.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB98194D6 /* 185.129.148.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9879C5E /* 185.135.156.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB98F65FD /* 185.143.101.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9918065 /* 185.145.128.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9918095 /* 185.145.128.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB99181BA /* 185.145.129.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB99181C5 /* 185.145.129.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB992A813 /* 185.146.168.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB992A9C1 /* 185.146.169.193/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB992AA81 /* 185.146.170.129/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB992ABE7 /* 185.146.171.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB996BDAF /* 185.150.189.175/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB998E823 /* 185.152.232.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB999C572 /* 185.153.197.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB999C57D /* 185.153.197.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB999C60B /* 185.153.198.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB999C6DE /* 185.153.198.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB99C4084 /* 185.156.64.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB99CAD94 /* 185.156.173.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB99F522B /* 185.159.82.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9A20A6E /* 185.162.10.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9A20A79 /* 185.162.10.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9A32D18 /* 185.163.45.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9A32D96 /* 185.163.45.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9A32DB0 /* 185.163.45.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9A32DC1 /* 185.163.45.193/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9A32DF3 /* 185.163.45.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9A32DF9 /* 185.163.45.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9A48873 /* 185.164.136.115/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9A5A85E /* 185.165.168.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9A5A861 /* 185.165.168.97/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9A5A862 /* 185.165.168.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9A5A87B /* 185.165.168.123/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9A5A8A8 /* 185.165.168.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9A5A8AA /* 185.165.168.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9A5A8AD /* 185.165.168.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9A5A8C4 /* 185.165.168.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9A5F38D /* 185.165.243.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9A9E5A3 /* 185.169.229.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9AFD0B3 /* 185.175.208.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9AFD0B4 /* 185.175.208.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9B150F8 /* 185.177.80.248/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9B50815 /* 185.181.8.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9B56551 /* 185.181.101.81/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9B5E54D /* 185.181.229.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9B63254 /* 185.182.50.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9B63256 /* 185.182.50.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBA95F912 /* 186.149.249.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBACCF34A /* 186.204.243.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBACED69A /* 186.206.214.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBAE7787D /* 186.231.120.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBB3D899C /* 187.61.137.156/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBB3F6418 /* 187.63.100.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBBA354CD /* 187.163.84.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBBA738D4 /* 187.167.56.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC045A36 /* 188.4.90.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC16BC3B /* 188.22.188.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC17C56E /* 188.23.197.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC181FD5 /* 188.24.31.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC20E27B /* 188.32.226.123/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC20F2F4 /* 188.32.242.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC282973 /* 188.40.41.115/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC282AC3 /* 188.40.42.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC282C77 /* 188.40.44.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC283156 /* 188.40.49.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC2833E8 /* 188.40.51.232/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC284C73 /* 188.40.76.115/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC285B57 /* 188.40.91.87/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC286345 /* 188.40.99.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC286BCD /* 188.40.107.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC286D92 /* 188.40.109.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC2880F6 /* 188.40.128.246/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC28A61D /* 188.40.166.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC28CE05 /* 188.40.206.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC28EBD7 /* 188.40.235.215/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC28F839 /* 188.40.248.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC2AD853 /* 188.42.216.83/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC2AFD07 /* 188.42.253.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC2AFE2F /* 188.42.254.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC402D69 /* 188.64.45.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC44202A /* 188.68.32.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC4424D1 /* 188.68.36.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC4439BC /* 188.68.57.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC4DD3A0 /* 188.77.211.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC52A824 /* 188.82.168.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC5DD54B /* 188.93.213.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC614BED /* 188.97.75.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC61A044 /* 188.97.160.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC620431 /* 188.98.4.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC63D545 /* 188.99.213.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC66949C /* 188.102.148.156/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC66F7E4 /* 188.102.247.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC671F6D /* 188.103.31.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC672E4A /* 188.103.46.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC6972F8 /* 188.105.114.248/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC6BEFDF /* 188.107.239.223/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC728CF5 /* 188.114.140.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC728E48 /* 188.114.142.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC76D9EC /* 188.118.217.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC77976C /* 188.119.151.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC78EA1A /* 188.120.234.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC78F125 /* 188.120.241.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC78F178 /* 188.120.241.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC78F320 /* 188.120.243.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC78FB81 /* 188.120.251.129/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC7AD504 /* 188.122.213.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC7B6E0F /* 188.123.110.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC7E519B /* 188.126.81.155/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC7E5AD3 /* 188.126.90.211/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC7E5E4D /* 188.126.94.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC86055C /* 188.134.5.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC8A3DA5 /* 188.138.61.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC8A4B65 /* 188.138.75.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC8A6662 /* 188.138.102.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC8A6995 /* 188.138.105.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC8A703C /* 188.138.112.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC8D4955 /* 188.141.73.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC8F6EB5 /* 188.143.110.181/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA49A12 /* 188.164.154.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA500AB /* 188.165.0.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA5050E /* 188.165.5.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA50642 /* 188.165.6.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA5133D /* 188.165.19.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA51C98 /* 188.165.28.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA532F4 /* 188.165.50.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA53B2B /* 188.165.59.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA56AF9 /* 188.165.106.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA58A06 /* 188.165.138.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA5919D /* 188.165.145.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA5C2C3 /* 188.165.194.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA5D498 /* 188.165.212.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA5D59C /* 188.165.213.156/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA5E426 /* 188.165.228.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA5F108 /* 188.165.241.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA5F530 /* 188.165.245.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA6036B /* 188.166.3.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA6046D /* 188.166.4.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA604D1 /* 188.166.4.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA60898 /* 188.166.8.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA61057 /* 188.166.16.87/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA6105B /* 188.166.16.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA61096 /* 188.166.16.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA61143 /* 188.166.17.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA61168 /* 188.166.17.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA6177F /* 188.166.23.127/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA617F7 /* 188.166.23.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA620C8 /* 188.166.32.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA62296 /* 188.166.34.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA623AB /* 188.166.35.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA628C3 /* 188.166.40.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA6292E /* 188.166.41.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA629D2 /* 188.166.41.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA62DEA /* 188.166.45.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA632DE /* 188.166.50.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA643E7 /* 188.166.67.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA6523D /* 188.166.82.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA657A1 /* 188.166.87.161/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA6699D /* 188.166.105.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA67A3A /* 188.166.122.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA68585 /* 188.166.133.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA69577 /* 188.166.149.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA69E64 /* 188.166.158.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA6A7E6 /* 188.166.167.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA6A849 /* 188.166.168.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA6B1B8 /* 188.166.177.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA6B238 /* 188.166.178.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA6B921 /* 188.166.185.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA6D1AC /* 188.166.209.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA6DBCF /* 188.166.219.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA6E9E6 /* 188.166.233.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA6F0B6 /* 188.166.240.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA6F14B /* 188.166.241.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA6F5D9 /* 188.166.245.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA6F66A /* 188.166.246.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA6FFD1 /* 188.166.255.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA74043 /* 188.167.64.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA8225A /* 188.168.34.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCAE5BDE /* 188.174.91.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCAEA8C5 /* 188.174.168.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCAEAAE5 /* 188.174.170.229/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCAEB70A /* 188.174.183.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCB78653 /* 188.183.134.83/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCBBC04B /* 188.187.192.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCC0359E /* 188.192.53.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCC086DE /* 188.192.134.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCC08E02 /* 188.192.142.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCC099B8 /* 188.192.153.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCC0A25A /* 188.192.162.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCC0F519 /* 188.192.245.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCC13139 /* 188.193.49.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCC16C21 /* 188.193.108.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCC16D84 /* 188.193.109.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCC1A930 /* 188.193.169.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCC233FB /* 188.194.51.251/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCC23C1E /* 188.194.60.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCC24F69 /* 188.194.79.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCC279E1 /* 188.194.121.225/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCC2F8F9 /* 188.194.248.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCC30F2A /* 188.195.15.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCC329A5 /* 188.195.41.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCC3ACDF /* 188.195.172.223/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCC3AD19 /* 188.195.173.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCD13122 /* 188.209.49.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCD51CDE /* 188.213.28.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCD53137 /* 188.213.49.55/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCD58F77 /* 188.213.143.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCD5A565 /* 188.213.165.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCD5A6ED /* 188.213.166.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCD5AA68 /* 188.213.170.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCD61E99 /* 188.214.30.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCD68040 /* 188.214.128.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCD68115 /* 188.214.129.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCD68155 /* 188.214.129.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCDBE8A2 /* 188.219.232.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCDE6AEF /* 188.222.106.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE23EBA /* 188.226.62.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE24784 /* 188.226.71.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE28258 /* 188.226.130.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE2957C /* 188.226.149.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE2DDF3 /* 188.226.221.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE2DE13 /* 188.226.222.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE2ED9A /* 188.226.237.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE2F756 /* 188.226.247.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE2FDB5 /* 188.226.253.181/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE3C986 /* 188.227.201.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE43194 /* 188.228.49.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE813A5 /* 188.232.19.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCF0D059 /* 188.240.208.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCF2827A /* 188.242.130.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCF42660 /* 188.244.38.96/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCF42B19 /* 188.244.43.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCF48F6B /* 188.244.143.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCF6CC43 /* 188.246.204.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBD3E721D /* 189.62.114.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBD54152C /* 189.84.21.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBE08F0EE /* 190.8.240.238/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBE0A0832 /* 190.10.8.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBE0A0844 /* 190.10.8.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBE0A0898 /* 190.10.8.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBE0A0AAD /* 190.10.10.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBE61A58D /* 190.97.165.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBE7B2F74 /* 190.123.47.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBED2625A /* 190.210.98.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBED2B6AD /* 190.210.182.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBED80288 /* 190.216.2.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBEF55206 /* 190.245.82.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBF60F96E /* 191.96.249.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBF651F54 /* 191.101.31.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBF6532FC /* 191.101.50.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBF705F5B /* 191.112.95.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC000E651 /* 192.0.230.81/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC003941B /* 192.3.148.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC003D90C /* 192.3.217.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC01E202C /* 192.30.32.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC01F17F3 /* 192.31.23.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC021D21E /* 192.33.210.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0223F89 /* 192.34.63.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC02250B0 /* 192.34.80.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0241B04 /* 192.36.27.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0241B06 /* 192.36.27.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0241B07 /* 192.36.27.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0242621 /* 192.36.38.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC02A7166 /* 192.42.113.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC02A7365 /* 192.42.115.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC02A7366 /* 192.42.115.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC02A7410 /* 192.42.116.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC02A74A1 /* 192.42.116.161/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC02C1E28 /* 192.44.30.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC034A746 /* 192.52.167.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC034A747 /* 192.52.167.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC047F524 /* 192.71.245.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC047F589 /* 192.71.245.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC047F5D7 /* 192.71.245.215/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC049EF53 /* 192.73.239.83/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0518331 /* 192.81.131.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC051842E /* 192.81.132.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC051D97E /* 192.81.217.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC051DA89 /* 192.81.218.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC051FA76 /* 192.81.250.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0571C1C /* 192.87.28.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0571C52 /* 192.87.28.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC05F1692 /* 192.95.22.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC05F19CA /* 192.95.25.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC05F1B8F /* 192.95.27.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0630BC8 /* 192.99.11.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0630C95 /* 192.99.12.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0630D30 /* 192.99.13.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0630FDC /* 192.99.15.220/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC063259C /* 192.99.37.156/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0632DE5 /* 192.99.45.229/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC063364F /* 192.99.54.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0633F2C /* 192.99.63.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0634473 /* 192.99.68.115/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0639AEA /* 192.99.154.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC063D48B /* 192.99.212.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC063F665 /* 192.99.246.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC06F9072 /* 192.111.144.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0794449 /* 192.121.68.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC07CFA53 /* 192.124.250.83/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC087A8FB /* 192.135.168.251/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC096BB89 /* 192.150.187.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0999AF4 /* 192.153.154.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC09B5365 /* 192.155.83.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC09B5D65 /* 192.155.93.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC09B5FDE /* 192.155.95.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC09DEFF3 /* 192.157.239.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC09DFD7D /* 192.157.253.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0A066A4 /* 192.160.102.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0A066A5 /* 192.160.102.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0A066A6 /* 192.160.102.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0A066A7 /* 192.160.102.167/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0A066A8 /* 192.160.102.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0A066A9 /* 192.160.102.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0A066AA /* 192.160.102.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0A1B431 /* 192.161.180.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0A28D35 /* 192.162.141.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0A3E033 /* 192.163.224.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0A4FA32 /* 192.164.250.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0A543FE /* 192.165.67.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0A6DA3F /* 192.166.218.63/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0A6DBC2 /* 192.166.219.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0A9A69D /* 192.169.166.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0A9A827 /* 192.169.168.39/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0B7CE2A /* 192.183.206.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0B851A0 /* 192.184.81.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0B85280 /* 192.184.82.128/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0B85E6F /* 192.184.94.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0BB7C62 /* 192.187.124.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0C3500A /* 192.195.80.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0C35386 /* 192.195.83.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0D2C0E5 /* 192.210.192.229/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0D2CB10 /* 192.210.203.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0D2D37B /* 192.210.211.123/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0DED68B /* 192.222.214.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0E3A054 /* 192.227.160.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0E3AFEF /* 192.227.175.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0E4A702 /* 192.228.167.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F07B02 /* 192.240.123.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F1823C /* 192.241.130.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F1863E /* 192.241.134.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F1946C /* 192.241.148.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F1B41B /* 192.241.180.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F1B4A3 /* 192.241.180.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F1B5E9 /* 192.241.181.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F1C15D /* 192.241.193.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F1C3B2 /* 192.241.195.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F1C66A /* 192.241.198.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F1CA6F /* 192.241.202.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F1CEAB /* 192.241.206.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F1D1C1 /* 192.241.209.193/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F1D265 /* 192.241.210.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F1D878 /* 192.241.216.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F1E93A /* 192.241.233.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F1E9CB /* 192.241.233.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F462A6 /* 192.244.98.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F70D29 /* 192.247.13.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F93CC2 /* 192.249.60.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0FCA537 /* 192.252.165.55/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC100D52A /* 193.0.213.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC107B1DF /* 193.7.177.223/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC10A0599 /* 193.10.5.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC10B70A7 /* 193.11.112.167/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC10B722B /* 193.11.114.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC10B722D /* 193.11.114.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC10B722E /* 193.11.114.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC10B722F /* 193.11.114.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC10BA4F3 /* 193.11.164.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC10BA6C2 /* 193.11.166.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC10F1004 /* 193.15.16.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC117F4F4 /* 193.23.244.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC118D146 /* 193.24.209.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC118D27E /* 193.24.210.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC11DBB4B /* 193.29.187.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC11DBB4E /* 193.29.187.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC11DBB6A /* 193.29.187.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1233435 /* 193.35.52.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC12598C7 /* 193.37.152.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC12A9C6A /* 193.42.156.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1462698 /* 193.70.38.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1462B4C /* 193.70.43.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1465AC7 /* 193.70.90.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC151D8E3 /* 193.81.216.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC15A0C56 /* 193.90.12.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC15A0C57 /* 193.90.12.87/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC15A0C58 /* 193.90.12.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC15A0C59 /* 193.90.12.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC15A0C5A /* 193.90.12.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC168A903 /* 193.104.169.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC168DC23 /* 193.104.220.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC168DC36 /* 193.104.220.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1694950 /* 193.105.73.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1698667 /* 193.105.134.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC16AA51B /* 193.106.165.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC16B5538 /* 193.107.85.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC16B5539 /* 193.107.85.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC16B553E /* 193.107.85.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC16CF9D7 /* 193.108.249.215/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC16E9D97 /* 193.110.157.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC16F1A25 /* 193.111.26.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC16F8820 /* 193.111.136.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC16F8DA0 /* 193.111.141.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC17CB532 /* 193.124.181.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC17CB6BF /* 193.124.182.191/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC18A765E /* 193.138.118.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC18CE034 /* 193.140.224.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1960E3C /* 193.150.14.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC196791A /* 193.150.121.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC196794E /* 193.150.121.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1A48535 /* 193.164.133.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1A4D955 /* 193.164.217.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1A589CA /* 193.165.137.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1A98785 /* 193.169.135.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1A9879A /* 193.169.135.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1A9879D /* 193.169.135.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1ABCA92 /* 193.171.202.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1ABCA9A /* 193.171.202.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1AE0614 /* 193.174.6.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1B69035 /* 193.182.144.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1B7626D /* 193.183.98.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1B769CD /* 193.183.105.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1BEA835 /* 193.190.168.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1C66803 /* 193.198.104.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1C8F1C3 /* 193.200.241.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1C9E12D /* 193.201.225.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1D2E00D /* 193.210.224.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1E0A32B /* 193.224.163.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1E3C40A /* 193.227.196.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1E48F11 /* 193.228.143.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1E48FE1 /* 193.228.143.225/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC201EE73 /* 194.1.238.115/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC20F7323 /* 194.15.115.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC22A6C05 /* 194.42.108.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC23F8BE6 /* 194.63.139.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC23F8E0B /* 194.63.142.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC243D67B /* 194.67.214.123/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC24F1F12 /* 194.79.31.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC2575FB1 /* 194.87.95.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC2588F42 /* 194.88.143.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC26DCED4 /* 194.109.206.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC27EAF9D /* 194.126.175.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC291D134 /* 194.145.209.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC2BBCF2D /* 194.187.207.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC2BBF80F /* 194.187.248.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC2BBF974 /* 194.187.249.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC2BFFE97 /* 194.191.254.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC2DA034F /* 194.218.3.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC2ED9DB8 /* 194.237.157.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3012906 /* 195.1.41.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC30C3044 /* 195.12.48.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC30C304C /* 195.12.48.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC30C304D /* 195.12.48.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC30CBE26 /* 195.12.190.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3105805 /* 195.16.88.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC31E6BDC /* 195.30.107.220/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC328B523 /* 195.40.181.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC32A73A2 /* 195.42.115.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3391CCC /* 195.57.28.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC33B6622 /* 195.59.102.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC33B6623 /* 195.59.102.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC33B6624 /* 195.59.102.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC33B6625 /* 195.59.102.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC33B6626 /* 195.59.102.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC33BD0A2 /* 195.59.208.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC33BD0A3 /* 195.59.208.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC33BD0A4 /* 195.59.208.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC33BD0A5 /* 195.59.208.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC33BD0A6 /* 195.59.208.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC33E353A /* 195.62.53.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC344D71E /* 195.68.215.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3474454 /* 195.71.68.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC35298D0 /* 195.82.152.208/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC35BF462 /* 195.91.244.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC37BD1B8 /* 195.123.209.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC37BD226 /* 195.123.210.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC37BD25F /* 195.123.210.95/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC37BD284 /* 195.123.210.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC37BD422 /* 195.123.212.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3845544 /* 195.132.85.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC38A5E66 /* 195.138.94.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3947CC7 /* 195.148.124.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A0A6A /* 195.154.10.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A0C42 /* 195.154.12.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A0C92 /* 195.154.12.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A0D60 /* 195.154.13.96/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A411D /* 195.154.65.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A4B1D /* 195.154.75.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A4B54 /* 195.154.75.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A4BA5 /* 195.154.75.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A4D95 /* 195.154.77.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A4FC7 /* 195.154.79.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A516C /* 195.154.81.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A516E /* 195.154.81.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A518F /* 195.154.81.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A51A9 /* 195.154.81.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A51E3 /* 195.154.81.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A51F5 /* 195.154.81.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A5258 /* 195.154.82.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A52B4 /* 195.154.82.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A56F9 /* 195.154.86.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A57E7 /* 195.154.87.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A5A83 /* 195.154.90.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A5B3D /* 195.154.91.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A5B8B /* 195.154.91.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A5BC2 /* 195.154.91.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A5C46 /* 195.154.92.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A5C9B /* 195.154.92.155/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A600E /* 195.154.96.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A612B /* 195.154.97.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A61A0 /* 195.154.97.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A61A3 /* 195.154.97.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A6935 /* 195.154.105.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A6939 /* 195.154.105.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A6B17 /* 195.154.107.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A6B97 /* 195.154.107.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A6C0C /* 195.154.108.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A6C4E /* 195.154.108.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A6D9D /* 195.154.109.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A6F75 /* 195.154.111.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A714F /* 195.154.113.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A71C8 /* 195.154.113.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A74E8 /* 195.154.116.232/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A75A3 /* 195.154.117.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A75B6 /* 195.154.117.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A79C6 /* 195.154.121.198/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A7A20 /* 195.154.122.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A7A36 /* 195.154.122.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A7A8A /* 195.154.122.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A7BE3 /* 195.154.123.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A7E2B /* 195.154.126.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A7FF6 /* 195.154.127.246/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AA123 /* 195.154.161.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AA12F /* 195.154.161.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AA2AC /* 195.154.162.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AA377 /* 195.154.163.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AA422 /* 195.154.164.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AA4F3 /* 195.154.164.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AA540 /* 195.154.165.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AA570 /* 195.154.165.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AAB18 /* 195.154.171.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AAC16 /* 195.154.172.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AB79F /* 195.154.183.159/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AC881 /* 195.154.200.129/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AD15B /* 195.154.209.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AE9BA /* 195.154.233.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AED93 /* 195.154.237.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AF091 /* 195.154.240.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AF17D /* 195.154.241.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AFAEF /* 195.154.250.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AFC58 /* 195.154.252.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AFDE2 /* 195.154.253.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AFFAE /* 195.154.255.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39FCC5E /* 195.159.204.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3A97DE2 /* 195.169.125.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3B2A648 /* 195.178.166.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3B40BC4 /* 195.180.11.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3BFE9DD /* 195.191.233.221/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3C8ECC5 /* 195.200.236.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3D08B84 /* 195.208.139.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3E1D31A /* 195.225.211.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3E42DB0 /* 195.228.45.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3E44B95 /* 195.228.75.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3E6A853 /* 195.230.168.83/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3EA9856 /* 195.234.152.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3EEBE65 /* 195.238.190.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3FE874C /* 195.254.135.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC5E7DDD3 /* 197.231.221.211/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC60C5F30 /* 198.12.95.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6105C9D /* 198.16.92.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6178523 /* 198.23.133.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC61B40D7 /* 198.27.64.215/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC61B429F /* 198.27.66.159/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC61B42D1 /* 198.27.66.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC61B45C9 /* 198.27.69.201/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC61B56DD /* 198.27.86.221/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC61B61B8 /* 198.27.97.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC61B6D24 /* 198.27.109.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC62E8A12 /* 198.46.138.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC62E8A28 /* 198.46.138.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC62E9933 /* 198.46.153.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC62E9979 /* 198.46.153.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6314912 /* 198.49.73.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6328137 /* 198.50.129.55/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC63285F5 /* 198.50.133.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC63287D5 /* 198.50.135.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC63291CF /* 198.50.145.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC63292FC /* 198.50.146.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6329346 /* 198.50.147.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6329F9B /* 198.50.159.155/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC632BF5F /* 198.50.191.95/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC632C886 /* 198.50.200.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC632C887 /* 198.50.200.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC632F552 /* 198.50.245.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC63A64F0 /* 198.58.100.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC63A66EA /* 198.58.102.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC63A6B35 /* 198.58.107.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC63A6EDF /* 198.58.110.223/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC63A73D2 /* 198.58.115.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6475142 /* 198.71.81.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC648E523 /* 198.72.229.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6493247 /* 198.73.50.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC64A38BF /* 198.74.56.191/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC64A3939 /* 198.74.57.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC64A3C1A /* 198.74.60.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC64A3C52 /* 198.74.60.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC64A3D33 /* 198.74.61.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6609B03 /* 198.96.155.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC66232D4 /* 198.98.50.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC662337C /* 198.98.51.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6623505 /* 198.98.53.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC66493B8 /* 198.100.147.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6649470 /* 198.100.148.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6649492 /* 198.100.148.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6649F36 /* 198.100.159.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC68F88E4 /* 198.143.136.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC68F88ED /* 198.143.136.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6931652 /* 198.147.22.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC69451A7 /* 198.148.81.167/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC69A6A36 /* 198.154.106.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6A7DF21 /* 198.167.223.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6A7DF26 /* 198.167.223.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6A7DF2C /* 198.167.223.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6A7DF4B /* 198.167.223.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6C740D9 /* 198.199.64.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6C74896 /* 198.199.72.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6C748B3 /* 198.199.72.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6C75A33 /* 198.199.90.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6C75ACD /* 198.199.90.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6C767B2 /* 198.199.103.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6C76840 /* 198.199.104.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6C77079 /* 198.199.112.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6C770F7 /* 198.199.112.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6C775A4 /* 198.199.117.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6C77686 /* 198.199.118.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6D3671A /* 198.211.103.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6D3788A /* 198.211.120.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6D37ABF /* 198.211.122.191/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6D37CD6 /* 198.211.124.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6D37DF2 /* 198.211.125.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6E9CCA5 /* 198.233.204.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6F468AE /* 198.244.104.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6F532AF /* 198.245.50.175/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6F53348 /* 198.245.51.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6F53D95 /* 198.245.61.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6FC794F /* 198.252.121.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6FC9945 /* 198.252.153.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6FC996B /* 198.252.153.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6FF5E72 /* 198.255.94.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6FFB101 /* 198.255.177.1/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC70FFAD2 /* 199.15.250.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC71355FC /* 199.19.85.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC713D5B0 /* 199.19.213.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC744C47B /* 199.68.196.123/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC744C47C /* 199.68.196.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC744C47D /* 199.68.196.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC744C47E /* 199.68.196.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC747EA42 /* 199.71.234.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC74ADEAB /* 199.74.222.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7579AFF /* 199.87.154.255/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC773CDF8 /* 199.115.205.248/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC77FE296 /* 199.127.226.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7BCC235 /* 199.188.194.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7BD3EFB /* 199.189.62.251/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7BD564F /* 199.189.86.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7C3F9D4 /* 199.195.249.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7C3F9DD /* 199.195.249.221/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F11DDF /* 199.241.29.223/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7FEEE2C /* 199.254.238.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7FEEE35 /* 199.254.238.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7FFDF58 /* 199.255.223.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC87AB50F /* 200.122.181.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC8810B03 /* 200.129.11.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC8810B05 /* 200.129.11.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC8810B07 /* 200.129.11.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC8E5C1C2 /* 200.229.193.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC944D734 /* 201.68.215.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC9561F26 /* 201.86.31.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC9837EC9 /* 201.131.126.201/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCA81509A /* 202.129.80.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCA8F5548 /* 202.143.85.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCB6DEA48 /* 203.109.234.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCB8D9ACA /* 203.141.154.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCBBA4562 /* 203.186.69.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCBD9AD92 /* 203.217.173.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCBDC5CE6 /* 203.220.92.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCBDDCF6C /* 203.221.207.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCC089C8E /* 204.8.156.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCC093219 /* 204.9.50.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCC0B3283 /* 204.11.50.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCC0DA46E /* 204.13.164.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCC11382A /* 204.17.56.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCC1B3C93 /* 204.27.60.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCC2C5903 /* 204.44.89.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCC55BF1E /* 204.85.191.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCC66E0ED /* 204.102.224.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCC98DC44 /* 204.152.220.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCC98DCF7 /* 204.152.220.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCC98DCF8 /* 204.152.220.248/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCCC21D04 /* 204.194.29.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCDA85485 /* 205.168.84.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCDB9733C /* 205.185.115.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCDB97E76 /* 205.185.126.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCE2876E5 /* 206.40.118.229/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCE36A784 /* 206.54.167.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCE374A00 /* 206.55.74.0/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCE374A01 /* 206.55.74.1/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCE3FE590 /* 206.63.229.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCEAE719C /* 206.174.113.156/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCEB71F06 /* 206.183.31.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCEF8B87F /* 206.248.184.127/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCF265260 /* 207.38.82.96/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCF26D9BA /* 207.38.217.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCF26E8C8 /* 207.38.232.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCF701236 /* 207.112.18.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCFAC3596 /* 207.172.53.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCFC046FA /* 207.192.70.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCFF44623 /* 207.244.70.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD0240203 /* 208.36.2.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD0240204 /* 208.36.2.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD0240205 /* 208.36.2.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD026F36B /* 208.38.243.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD040AFD9 /* 208.64.175.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD04FD17C /* 208.79.209.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD0509A27 /* 208.80.154.39/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD053DF22 /* 208.83.223.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD059D3D0 /* 208.89.211.208/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD05EF21A /* 208.94.242.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD05EF2DE /* 208.94.242.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD05F031C /* 208.95.3.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD071A605 /* 208.113.166.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD076EB30 /* 208.118.235.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD1064FB4 /* 209.6.79.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD1068F99 /* 209.6.143.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD10F4ECD /* 209.15.78.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD12C72B2 /* 209.44.114.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD13AA08A /* 209.58.160.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD13AB45A /* 209.58.180.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD1427796 /* 209.66.119.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD15AE005 /* 209.90.224.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD17BEA17 /* 209.123.234.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD17E47E9 /* 209.126.71.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD17E67CE /* 209.126.103.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD18542D6 /* 209.133.66.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD18D22F0 /* 209.141.34.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD18D242A /* 209.141.36.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD18D2816 /* 209.141.40.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD18D3126 /* 209.141.49.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD18D328A /* 209.141.50.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD18D340D /* 209.141.52.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD18D3A44 /* 209.141.58.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD19F899C /* 209.159.137.156/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD1A6AC0A /* 209.166.172.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD1ABA216 /* 209.171.162.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD1B53DDB /* 209.181.61.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD1D04F05 /* 209.208.79.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD1D2D215 /* 209.210.210.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD1DE4DDC /* 209.222.77.220/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD1F06DEE /* 209.240.109.238/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD1F99D45 /* 209.249.157.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD1F9B4C6 /* 209.249.180.198/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD1FA06BE /* 209.250.6.190/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD2036698 /* 210.3.102.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD203669A /* 210.3.102.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD20366A5 /* 210.3.102.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD2362318 /* 210.54.35.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD298F13C /* 210.152.241.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD31AF589 /* 211.26.245.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD34C375C /* 211.76.55.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD37858ED /* 211.120.88.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD40370E2 /* 212.3.112.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD407D934 /* 212.7.217.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4106821 /* 212.16.104.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD410AA9E /* 212.16.170.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD411664D /* 212.17.102.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD41311D5 /* 212.19.17.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4143EE2 /* 212.20.62.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4154206 /* 212.21.66.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4190B15 /* 212.25.11.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD41A8C51 /* 212.26.140.81/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD41AF522 /* 212.26.245.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FDFC6 /* 212.47.223.198/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FE295 /* 212.47.226.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FE347 /* 212.47.227.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FE34B /* 212.47.227.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FE372 /* 212.47.227.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FE3C3 /* 212.47.227.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FE3EC /* 212.47.227.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FE473 /* 212.47.228.115/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FE502 /* 212.47.229.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FE58A /* 212.47.229.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FE605 /* 212.47.230.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FE631 /* 212.47.230.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FE7F1 /* 212.47.231.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FE8E3 /* 212.47.232.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FE8EC /* 212.47.232.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FE8ED /* 212.47.232.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FE921 /* 212.47.233.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FE956 /* 212.47.233.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FE9EB /* 212.47.233.235/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FEAC0 /* 212.47.234.192/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FEAD4 /* 212.47.234.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FEB51 /* 212.47.235.81/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FEC9D /* 212.47.236.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FED5F /* 212.47.237.95/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FEE41 /* 212.47.238.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FEEC1 /* 212.47.238.193/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FEF53 /* 212.47.239.83/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FEF97 /* 212.47.239.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FEFA3 /* 212.47.239.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FEFBB /* 212.47.239.187/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FF00A /* 212.47.240.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FF0BD /* 212.47.240.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FF115 /* 212.47.241.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FF35B /* 212.47.243.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FF38C /* 212.47.243.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FF3A6 /* 212.47.243.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FF426 /* 212.47.244.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FF462 /* 212.47.244.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FF54C /* 212.47.245.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FF5E3 /* 212.47.245.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FF612 /* 212.47.246.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FF615 /* 212.47.246.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FF6D3 /* 212.47.246.211/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FF871 /* 212.47.248.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FF93F /* 212.47.249.63/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FFBB3 /* 212.47.251.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FFDDF /* 212.47.253.223/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FFE82 /* 212.47.254.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD433867B /* 212.51.134.123/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4338AC4 /* 212.51.138.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4338F14 /* 212.51.143.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD43393ED /* 212.51.147.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4339619 /* 212.51.150.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD43396B8 /* 212.51.150.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4339755 /* 212.51.151.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD43397FA /* 212.51.151.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4339C4E /* 212.51.156.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4339E47 /* 212.51.158.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD438582F /* 212.56.88.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD438D6B2 /* 212.56.214.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD43C7E33 /* 212.60.126.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD43C8248 /* 212.60.130.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD444E4D5 /* 212.68.228.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD445A67A /* 212.69.166.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD445A699 /* 212.69.166.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD447FC74 /* 212.71.252.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD447FDE2 /* 212.71.253.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD448B013 /* 212.72.176.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD44AFEF3 /* 212.74.254.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD451C79F /* 212.81.199.159/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD45328EE /* 212.83.40.238/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD45328EF /* 212.83.40.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4538F2E /* 212.83.143.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4539A21 /* 212.83.154.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4539E05 /* 212.83.158.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4539E14 /* 212.83.158.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD453AE1A /* 212.83.174.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD453B03A /* 212.83.176.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD459E1F2 /* 212.89.225.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD45CD6F6 /* 212.92.214.246/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD45CDB0F /* 212.92.219.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD46B9CE2 /* 212.107.156.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD46B9CEE /* 212.107.156.238/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD46DD983 /* 212.109.217.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD46F28B1 /* 212.111.40.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD46F298F /* 212.111.41.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD472FE5B /* 212.114.254.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD475B421 /* 212.117.180.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD475B42D /* 212.117.180.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD475B46B /* 212.117.180.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4763E03 /* 212.118.62.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4810454 /* 212.129.4.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD48126FE /* 212.129.38.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4812A09 /* 212.129.42.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD481313B /* 212.129.49.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4813431 /* 212.129.52.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4813EE8 /* 212.129.62.232/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD496868C /* 212.150.134.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD49F4FE4 /* 212.159.79.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD49F5B15 /* 212.159.91.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD49F64E8 /* 212.159.100.232/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD49F70C4 /* 212.159.112.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD49FB1C6 /* 212.159.177.198/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4B5CE7A /* 212.181.206.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4B7D5E4 /* 212.183.213.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4BA4726 /* 212.186.71.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4BA59A2 /* 212.186.89.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4BB6183 /* 212.187.97.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4BBC8AA /* 212.187.200.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4C94483 /* 212.201.68.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4C94498 /* 212.201.68.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4E04C94 /* 212.224.76.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4E04EEA /* 212.224.78.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4E05FA1 /* 212.224.95.161/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4E05FE7 /* 212.224.95.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4E30936 /* 212.227.9.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4E81D65 /* 212.232.29.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4EEA021 /* 212.238.160.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4EED030 /* 212.238.208.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4FBD3FE /* 212.251.211.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD50544CA /* 213.5.68.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5117CB2 /* 213.17.124.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5150A1E /* 213.21.10.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD520136C /* 213.32.19.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5201537 /* 213.32.21.55/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD52037C3 /* 213.32.55.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD52037F7 /* 213.32.55.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD52042C0 /* 213.32.66.192/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5204465 /* 213.32.68.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5205A0F /* 213.32.90.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5205A9A /* 213.32.90.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD52077DB /* 213.32.119.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD52F3136 /* 213.47.49.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD53D4274 /* 213.61.66.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD53D4275 /* 213.61.66.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD53D4276 /* 213.61.66.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD53D957D /* 213.61.149.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD53D957E /* 213.61.149.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD540416A /* 213.64.65.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD54963B6 /* 213.73.99.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD55F1536 /* 213.95.21.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD55F56B4 /* 213.95.86.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD56C6947 /* 213.108.105.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD56C6CEB /* 213.108.108.235/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD56D38C8 /* 213.109.56.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5708465 /* 213.112.132.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5717475 /* 213.113.116.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD571778A /* 213.113.119.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5729166 /* 213.114.145.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD57292BB /* 213.114.146.187/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD57295A0 /* 213.114.149.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD572E11E /* 213.114.225.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD572E952 /* 213.114.233.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD57CA99F /* 213.124.169.159/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD57CB319 /* 213.124.179.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD58306BA /* 213.131.6.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD585639C /* 213.133.99.156/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD587C66A /* 213.135.198.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD58845A2 /* 213.136.69.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD58845ED /* 213.136.69.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5884715 /* 213.136.71.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD588506D /* 213.136.80.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5885159 /* 213.136.81.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5885CBC /* 213.136.92.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5885E0A /* 213.136.94.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD58A66D1 /* 213.138.102.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD58A6D90 /* 213.138.109.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD58A6F1F /* 213.138.111.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD58C5CC7 /* 213.140.92.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD58D82E7 /* 213.141.130.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD58D8AAE /* 213.141.138.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD58D9613 /* 213.141.150.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5909D4B /* 213.144.157.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5975904 /* 213.151.89.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD598A11E /* 213.152.161.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD598A128 /* 213.152.161.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD59954D7 /* 213.153.84.215/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD59D0FEB /* 213.157.15.235/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD59FD02B /* 213.159.208.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5A1050C /* 213.161.5.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5A296BF /* 213.162.150.191/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5A346EA /* 213.163.70.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5A354C4 /* 213.163.84.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5A354CC /* 213.163.84.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5A354CD /* 213.163.84.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5A7F2B7 /* 213.167.242.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5B5CD3D /* 213.181.205.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5B5CD3E /* 213.181.205.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5B5CD3F /* 213.181.205.63/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5B7388C /* 213.183.56.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5B87E02 /* 213.184.126.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5B87EF2 /* 213.184.126.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5BC3465 /* 213.188.52.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5BCF58B /* 213.188.245.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5BF1B7B /* 213.191.27.123/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5C5167C /* 213.197.22.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5C52623 /* 213.197.38.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5CAE924 /* 213.202.233.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5E1A0DF /* 213.225.160.223/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5E2B4A6 /* 213.226.180.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5E9E27B /* 213.233.226.123/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5EFC519 /* 213.239.197.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5EFCA95 /* 213.239.202.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5EFCDEF /* 213.239.205.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5EFD329 /* 213.239.211.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5EFD414 /* 213.239.212.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5EFD8DE /* 213.239.216.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5EFD912 /* 213.239.217.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5EFD944 /* 213.239.217.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5EFF947 /* 213.239.249.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5F3AC2E /* 213.243.172.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5F53ED4 /* 213.245.62.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5F62D4C /* 213.246.45.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5F6383E /* 213.246.56.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5F6384F /* 213.246.56.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5F6385F /* 213.246.56.95/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5FBC7AE /* 213.251.199.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5FCA60F /* 213.252.166.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5FCF469 /* 213.252.244.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5FE201A /* 213.254.32.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD80CC652 /* 216.12.198.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD80CC653 /* 216.12.198.83/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD80CC654 /* 216.12.198.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD8116390 /* 216.17.99.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD811654F /* 216.17.101.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD818F222 /* 216.24.242.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD837B515 /* 216.55.181.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD87FBB1D /* 216.127.187.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD89EE2D8 /* 216.158.226.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD8BAA827 /* 216.186.168.39/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD8BD96B9 /* 216.189.150.185/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD8C3851B /* 216.195.133.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD8C3A84E /* 216.195.168.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD8D37E59 /* 216.211.126.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD8DA860C /* 216.218.134.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD8DA9383 /* 216.218.147.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD8DADE0A /* 216.218.222.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD8DADE0B /* 216.218.222.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD8DADE0C /* 216.218.222.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD8DADE0D /* 216.218.222.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD8E6944D /* 216.230.148.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD8EF5A13 /* 216.239.90.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD8F455D3 /* 216.244.85.211/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD8FCA213 /* 216.252.162.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9083D43 /* 217.8.61.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD90B39E2 /* 217.11.57.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD90CC743 /* 217.12.199.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD90CC76C /* 217.12.199.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD90CC79E /* 217.12.199.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD90CC7BE /* 217.12.199.190/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD90CC7D0 /* 217.12.199.208/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD90CC7D1 /* 217.12.199.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD90CCA28 /* 217.12.202.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD90CCA4C /* 217.12.202.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD90CCA74 /* 217.12.202.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD90CCB2E /* 217.12.203.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD90CCCA1 /* 217.12.204.161/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD90CD075 /* 217.12.208.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD90CD230 /* 217.12.210.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD90CD25F /* 217.12.210.95/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD90CD2CF /* 217.12.210.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD90CD2D6 /* 217.12.210.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD90DC505 /* 217.13.197.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD910B514 /* 217.16.181.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD910B614 /* 217.16.182.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9148248 /* 217.20.130.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9170767 /* 217.23.7.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9170B59 /* 217.23.11.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9170B8A /* 217.23.11.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9170D81 /* 217.23.13.129/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9170FC8 /* 217.23.15.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9178A69 /* 217.23.138.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD919AD97 /* 217.25.173.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD919E2A0 /* 217.25.226.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD91C60B4 /* 217.28.96.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD91CDAEF /* 217.28.218.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD91D3AB8 /* 217.29.58.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD92ADC0E /* 217.42.220.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD93214DF /* 217.50.20.223/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD93FFE63 /* 217.63.254.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD945905E /* 217.69.144.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD946BF0D /* 217.70.191.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD94FB23C /* 217.79.178.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD94FB27E /* 217.79.178.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD94FB3B1 /* 217.79.179.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD94FB65F /* 217.79.182.95/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD94FBE19 /* 217.79.190.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD95235B5 /* 217.82.53.181/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD95509BC /* 217.85.9.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD967A496 /* 217.103.164.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD96BC10A /* 217.107.193.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9708318 /* 217.112.131.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9708362 /* 217.112.131.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9719E34 /* 217.113.158.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD97293F5 /* 217.114.147.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9730A83 /* 217.115.10.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9730A84 /* 217.115.10.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD975E3E2 /* 217.117.227.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD97AAF13 /* 217.122.175.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD97AC053 /* 217.122.192.83/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9840EFD /* 217.132.14.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD993D66B /* 217.147.214.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD996E2B4 /* 217.150.226.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD99B0A12 /* 217.155.10.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD99B2876 /* 217.155.40.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9A00DAD /* 217.160.13.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9A00FF7 /* 217.160.15.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9A08D34 /* 217.160.141.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9A0B20A /* 217.160.178.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9A0B3E9 /* 217.160.179.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9AAC96A /* 217.170.201.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9AACD71 /* 217.170.205.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9AC204C /* 217.172.32.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9ACF73C /* 217.172.247.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9C553A2 /* 217.197.83.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9C55415 /* 217.197.84.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9C55418 /* 217.197.84.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9C556AD /* 217.197.86.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9C55B91 /* 217.197.91.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9D1B3CA /* 217.209.179.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9D35942 /* 217.211.89.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9E416D8 /* 217.228.22.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9E4D647 /* 217.228.214.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9E74909 /* 217.231.73.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9EBEDEF /* 217.235.237.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9EEEC9E /* 217.238.236.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9EF0D24 /* 217.239.13.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9F176FD /* 217.241.118.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9F4AB1D /* 217.244.171.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9F6BE2B /* 217.246.190.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9F942DF /* 217.249.66.223/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9FAD604 /* 217.250.214.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9FB0E75 /* 217.251.14.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9FD2262 /* 217.253.34.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9FD2640 /* 217.253.38.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9FE5EEF /* 217.254.94.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xDAB44A3C /* 218.180.74.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xDB4EB793 /* 219.78.183.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xDB58E8E6 /* 219.88.232.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xDB685CD8 /* 219.104.92.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xDB6F57A5 /* 219.111.87.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xDB75CE2E /* 219.117.206.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xDB75F165 /* 219.117.241.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xDC870EE4 /* 220.135.14.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xDCDC4591 /* 220.220.69.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xDCE97BAC /* 220.233.123.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xDCE9A811 /* 220.233.168.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xDCF05090 /* 220.240.80.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xDCFD0FF1 /* 220.253.15.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xDD274EC9 /* 221.39.78.201/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xDD7999B8 /* 221.121.153.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xDDA12637 /* 221.161.38.55/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xDE036590 /* 222.3.101.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xDE0A3840 /* 222.10.56.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xDE9BA103 /* 222.155.161.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xDF10252D /* 223.16.37.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xDF1A30F8 /* 223.26.48.248/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xDF87439F /* 223.135.67.159/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xDF87D907 /* 223.135.217.7/32 */, 32, NDPI_PROTOCOL_TOR },

  /*
    Twitch Interactive Inc.
    origin AS46489
  */

  { 0x17A00000 /* 23.160.0.0/24 */, 24, NDPI_PROTOCOL_TWITCH },
  { 0x2D718000 /* 45.113.128.0/22 */, 22, NDPI_PROTOCOL_TWITCH },
  { 0x34DFC000 /* 52.223.192.0/20 */, 20, NDPI_PROTOCOL_TWITCH },
  { 0x34DFD000 /* 52.223.208.0/21 */, 21, NDPI_PROTOCOL_TWITCH },
  { 0x34DFD800 /* 52.223.216.0/21 */, 21, NDPI_PROTOCOL_TWITCH },
  { 0x34DFE000 /* 52.223.224.0/20 */, 20, NDPI_PROTOCOL_TWITCH },
  { 0x34DFF000 /* 52.223.240.0/20 */, 20, NDPI_PROTOCOL_TWITCH },
  { 0x67353000 /* 103.53.48.0/22 */, 22, NDPI_PROTOCOL_TWITCH },
  { 0xB92ACC00 /* 185.42.204.0/22 */, 22, NDPI_PROTOCOL_TWITCH },
  { 0xC0104000 /* 192.16.64.0/21 */, 21, NDPI_PROTOCOL_TWITCH },
  { 0xC06CEF00 /* 192.108.239.0/24 */, 24, NDPI_PROTOCOL_TWITCH },
  { 0xC709F800 /* 199.9.248.0/21 */, 21, NDPI_PROTOCOL_TWITCH },

  /*
    AnchorFree, Inc. (Hotspot Shield)
    origin AS26642
  */

  { 0x2E102200 /* 46.16.34.0/24 */, 24, NDPI_PROTOCOL_HOTSPOT_SHIELD },
  { 0x2E102300 /* 46.16.35.0/24 */, 24, NDPI_PROTOCOL_HOTSPOT_SHIELD },
  { 0x32752D00 /* 50.117.45.0/24 */, 24, NDPI_PROTOCOL_HOTSPOT_SHIELD },
  { 0x3F8DC600 /* 63.141.198.0/23 */, 23, NDPI_PROTOCOL_HOTSPOT_SHIELD },
  { 0x4A730100 /* 74.115.1.0/24 */, 24, NDPI_PROTOCOL_HOTSPOT_SHIELD },
  { 0x4A730500 /* 74.115.5.0/24 */, 24, NDPI_PROTOCOL_HOTSPOT_SHIELD },
  { 0x4A730600 /* 74.115.6.0/24 */, 24, NDPI_PROTOCOL_HOTSPOT_SHIELD },
  { 0x55EDC500 /* 85.237.197.0/24 */, 24, NDPI_PROTOCOL_HOTSPOT_SHIELD },
  { 0x55EDDE00 /* 85.237.222.0/24 */, 24, NDPI_PROTOCOL_HOTSPOT_SHIELD },
  { 0xC62F7300 /* 198.47.115.0/24 */, 24, NDPI_PROTOCOL_HOTSPOT_SHIELD },
  { 0xC6906800 /* 198.144.104.0/24 */, 24, NDPI_PROTOCOL_HOTSPOT_SHIELD },
  { 0xC7FFD700 /* 199.255.215.0/24 */, 24, NDPI_PROTOCOL_HOTSPOT_SHIELD },
  { 0xCC0E4A00 /* 204.14.74.0/24 */, 24, NDPI_PROTOCOL_HOTSPOT_SHIELD },
  { 0xCC0E4C00 /* 204.14.76.0/24 */, 24, NDPI_PROTOCOL_HOTSPOT_SHIELD },
  { 0xCC0E4D00 /* 204.14.77.0/24 */, 24, NDPI_PROTOCOL_HOTSPOT_SHIELD },
  { 0xCC0E4E00 /* 204.14.78.0/24 */, 24, NDPI_PROTOCOL_HOTSPOT_SHIELD },
  { 0xCDA42000 /* 205.164.32.0/24 */, 24, NDPI_PROTOCOL_HOTSPOT_SHIELD },
  { 0xD1498400 /* 209.73.132.0/24 */, 24, NDPI_PROTOCOL_HOTSPOT_SHIELD },
  { 0xD1499700 /* 209.73.151.0/24 */, 24, NDPI_PROTOCOL_HOTSPOT_SHIELD },
  { 0xD8AC8E00 /* 216.172.142.0/24 */, 24, NDPI_PROTOCOL_HOTSPOT_SHIELD },

  /*
    GitHub, Inc.
    origin AS36459
  */

  { 0xC01EFC00 /* 192.30.252.0/22 */, 22, NDPI_PROTOCOL_GITHUB },

  /*
    Valve Corporation (Steam)
    origin AS32590
  */

  { 0x2D79B800 /* 45.121.184.0/22 */, 22, NDPI_PROTOCOL_STEAM },
  { 0x670A7C00 /* 103.10.124.0/23 */, 23, NDPI_PROTOCOL_STEAM },
  { 0x671C3600 /* 103.28.54.0/23 */, 23, NDPI_PROTOCOL_STEAM },
  { 0x8F899200 /* 143.137.146.0/24 */, 24, NDPI_PROTOCOL_STEAM },
  { 0x92429800 /* 146.66.152.0/21 */, 21, NDPI_PROTOCOL_STEAM },
  { 0x99FE5600 /* 153.254.86.0/24 */, 24, NDPI_PROTOCOL_STEAM },
  { 0x9B85E000 /* 155.133.224.0/19 */, 19, NDPI_PROTOCOL_STEAM },
  { 0xA2FEC000 /* 162.254.192.0/21 */, 21, NDPI_PROTOCOL_STEAM },
  { 0xB919B400 /* 185.25.180.0/22 */, 22, NDPI_PROTOCOL_STEAM },
  { 0xBED87900 /* 190.216.121.0/24 */, 24, NDPI_PROTOCOL_STEAM },
  { 0xBED92100 /* 190.217.33.0/24 */, 24, NDPI_PROTOCOL_STEAM },
  { 0xC0456000 /* 192.69.96.0/22 */, 22, NDPI_PROTOCOL_STEAM },
  { 0xCDB9C200 /* 205.185.194.0/24 */, 24, NDPI_PROTOCOL_STEAM },
  { 0xCDC40600 /* 205.196.6.0/24 */, 24, NDPI_PROTOCOL_STEAM },
  { 0xD040C800 /* 208.64.200.0/24 */, 24, NDPI_PROTOCOL_STEAM },
  { 0xD040C900 /* 208.64.201.0/22 */, 22, NDPI_PROTOCOL_STEAM },
  { 0xD04EA400 /* 208.78.164.0/22 */, 22, NDPI_PROTOCOL_STEAM },

  { 0x0, 0, 0 }
};


/* ****************************************************** */

/*
  Host-based match

  HTTP:  Server: field
  HTTPS: Server certificate name

  Risk classification criteria
  ----------------------------

  NDPI_PROTOCOL_SAFE
  - Web sites (and CDNs) which are not commonly used to host malicious activities.
  - OS update hosts.
  - App stores.
  - Commonly used services with passwords in encrypted channels (SMTPS, POPS, etc)

  NDPI_PROTOCOL_ACCEPTABLE
  - Cloud services may be used to host malware (e.g., https://www.fireeye.com/blog/threat-research/2015/11/china-based-threat.html),
  but it is mostly used for normal purposes.
  - Webmail sites, which can be used to phising.
  - Encrypted administrative protocols, such as SSH.
  - Text, voice or video communication (e.g., Skype, Slack, Whatsapp).
  - Ads services are commonly used to spread malware
  (https://www.tripwire.com/state-of-security/security-data-protection/crypto-ransomware-spreads-via-poisoned-ads-on-major-websites/)

  NDPI_PROTOCOL_FUN
  - Social media sites and services.
  - Communication used for fun purposes, like Snapchat, Tinder, etc.
  - Audio and videostreamming services (e.g., Netflix).
  - Game services.

  NDPI_PROTOCOL_UNSAFE
  - Unencrypted administrative protocols, such as Telnet.
  - Cloud hosted servers when accessed by default domains, such as *.amazonaws.com.
  - "AWS Supports 41% of Malware Hosting Sites, More than Any Other Web Host or ISP"
  http://www.thewhir.com/web-hosting-news/aws-supports-41-malware-hosting-sites-web-host-isp
  - https://www.scmagazine.com/600-plus-cloud-repositories-spotted-hosting-malware-and-malicious-files/article/572205/
  - https://howtoremove.guide/remove-s3-amazonaws-virus/
  - Torrents.
  - Commonly used services with passwords in unencrypted channels (SMTP, POP, etc)

  NDPI_PROTOCOL_POTENTIALLY_DANGEROUS
  - Tor and other anonymization access.
  - Sites commonly used to host malware and not as commonly used by "normal" users. (e.g., pastebin.com)
  https://isc.sans.edu/forums/diary/Many+Malware+Samples+Found+on+Pastebin/22036/

  NDPI_PROTOCOL_UNRATED
  - Avoid this class.

*/

/* ****************************************************** */

/*

Each part of a domain name can be no longer than 63 characters. There are no single-digit top-level domains and none contain digits. It doesn't look like ICANN will approve such domains either.

https://www.regular-expressions.info/email.html

(?i) is to make searches case insensitive

(?:) is a non-capturing group used to allow patterns such as .co.uk or .com.cn
     The non-capturing group is used in a nested fashion to capture the
     .co, and then, optionally, another m.

*/

#define TLD "(?i)(?:\\.co(?:m)?)?\\.[a-z]{2,63}$"

/* ****************************************************** */

ndpi_protocol_match host_match[] = {
  { "s3.ll.dash.row.aiv-cdn.net", NULL, "s3\\.ll\\.dash\\.row\\.aiv-cdn\\.net",          "AmazonVideo",      NDPI_PROTOCOL_AMAZON_VIDEO, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN },
  { "s3-dub.cf.dash.row.aiv-cdn.net", NULL, "s3-dub\\.cf\\.dash\\.row\\.aiv-cdn\\.net",  "AmazonVideo",      NDPI_PROTOCOL_AMAZON_VIDEO, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN },
  { "dmqdd6hw24ucf.cloudfront.net", NULL, "dmqdd6hw24ucf\\.cloudfront\\.net",            "AmazonVideo",      NDPI_PROTOCOL_AMAZON_VIDEO, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN },
  { "d25xi40x97liuc.cloudfront.net", NULL, "d25xi40x97liuc\\.cloudfront\\.net",          "AmazonVideo",      NDPI_PROTOCOL_AMAZON_VIDEO, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN },
  { ".aiv-delivery.net", NULL, "\\.aiv-delivery\\.net",                                  "AmazonVideo",      NDPI_PROTOCOL_AMAZON_VIDEO, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN },
  { ".aiv-cdn.net", NULL, "\\.aiv-cdn\\.net",                                            "AmazonVideo",      NDPI_PROTOCOL_AMAZON_VIDEO, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN },
  { "amazon.", NULL, NULL,                                                               "Amazon",           NDPI_PROTOCOL_AMAZON, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },
  { "amazon.com", NULL, "amazon" TLD,                                                    "Amazon",           NDPI_PROTOCOL_AMAZON, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },
  { "images-amazon.com", NULL, "images-amazon" TLD,                                      "Amazon",           NDPI_PROTOCOL_AMAZON, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },
  { "amazonaws.com", NULL, "amazonaws" TLD,                                              "Amazon",           NDPI_PROTOCOL_AMAZON, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },
  { "amazon-adsystem.com", NULL, "amazon-adsystem" TLD,                                  "Amazon",           NDPI_PROTOCOL_AMAZON, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },
  { ".cloudfront.net", NULL, "\\.cloudfront" TLD,                                        "Amazon",           NDPI_PROTOCOL_AMAZON, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },

  { ".push.apple.com", NULL, "\\.push\\.apple" TLD,                   "ApplePush",        NDPI_PROTOCOL_APPLE_PUSH, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE },
  { ".apple-dns.net", NULL, "\\.apple-dns" TLD,                       "Apple",            NDPI_PROTOCOL_APPLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },
  { ".mzstatic.com", NULL, "\\.mzstatic" TLD,                         "Apple",            NDPI_PROTOCOL_APPLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },
  { ".aaplimg.com", NULL, "\\.aaplimg" TLD,                           "Apple",            NDPI_PROTOCOL_APPLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },
  { "aaplimg.com", NULL, "aaplimg" TLD,                               "Apple",            NDPI_PROTOCOL_APPLE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE },
  { ".apple.com", NULL, "\\.apple" TLD,                               "Apple",            NDPI_PROTOCOL_APPLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },
  { ".icloud.com", NULL, "\\.icloud\\.com",                           "AppleiCloud",      NDPI_PROTOCOL_APPLE_ICLOUD, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },
  { "iosapps.itunes.apple.com", NULL, "iosapps\\.itunes\\.apple" TLD, "AppleStore",       NDPI_PROTOCOL_APPLESTORE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE }, /* iOS */
  { "osxapps.itunes.apple.com", NULL, "osxapps\\.itunes\\.apple" TLD, "AppleStore",       NDPI_PROTOCOL_APPLESTORE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE }, /* MacOS */
  { "buy.itunes.apple.com", NULL, "buy\\.itunes\\.apple" TLD,         "AppleStore",       NDPI_PROTOCOL_APPLESTORE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE },
  { "su.itunes.apple.com", NULL, "su\\.itunes\\.apple" TLD,           "AppleStore",       NDPI_PROTOCOL_APPLESTORE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE },
  { "se.itunes.apple.com", NULL, "se\\.itunes\\.apple" TLD,           "AppleStore",       NDPI_PROTOCOL_APPLESTORE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE },
  { "myapp.itunes.apple.com", NULL, "myapp\\.itunes\\.apple" TLD,     "AppleStore",       NDPI_PROTOCOL_APPLESTORE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE },
  { "swscan.apple.com", NULL, "swscan\\.apple" TLD,                   "AppleStore",       NDPI_PROTOCOL_APPLESTORE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE },
  { "itunes-apple.com", NULL, "itunes-apple" TLD,                     "AppleStore",       NDPI_PROTOCOL_APPLESTORE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE },
  { "itunes.apple.com", NULL, "itunes\\.apple" TLD,                   "AppleiTunes",      NDPI_PROTOCOL_APPLE_ITUNES, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN },
  { "tlnk.io", NULL, "tlnk" TLD,         	                      "AppleiTunes",      NDPI_PROTOCOL_APPLE_ITUNES, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN },


  { ".cnn.c", NULL, "\\.cnn" TLD,           "CNN",              NDPI_PROTOCOL_CNN, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },
  { ".cnn.net", NULL, NULL,                 "CNN",              NDPI_PROTOCOL_CNN, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },

  { ".dropbox.com", NULL, "\\.dropbox" TLD,             "DropBox",          NDPI_PROTOCOL_DROPBOX, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_ACCEPTABLE },
  { ".dropboxstatic.com", NULL, "\\.dropboxstatic" TLD, "DropBox",          NDPI_PROTOCOL_DROPBOX, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_ACCEPTABLE },
  { ".dropbox-dns.com", NULL, "\\.dropbox-dns" TLD,     "DropBox",          NDPI_PROTOCOL_DROPBOX, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_ACCEPTABLE },
  { "log.getdropbox.com", NULL, "log\\.getdropbox" TLD, "DropBox",          NDPI_PROTOCOL_DROPBOX, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_ACCEPTABLE },

  { ".ebay.", NULL, "\\.ebay" TLD,                      "eBay",             NDPI_PROTOCOL_EBAY, NDPI_PROTOCOL_CATEGORY_SHOPPING, NDPI_PROTOCOL_SAFE },  /* or FUN */
  { ".ebay.com", NULL, NULL,                            "eBay",             NDPI_PROTOCOL_EBAY, NDPI_PROTOCOL_CATEGORY_SHOPPING, NDPI_PROTOCOL_SAFE },
  { ".ebaystatic.com", NULL, "\\.ebaystatic" TLD,       "eBay",             NDPI_PROTOCOL_EBAY, NDPI_PROTOCOL_CATEGORY_SHOPPING, NDPI_PROTOCOL_SAFE },
  { ".ebaydesc.com", NULL, "\\.ebaydesc" TLD,           "eBay",             NDPI_PROTOCOL_EBAY, NDPI_PROTOCOL_CATEGORY_SHOPPING, NDPI_PROTOCOL_SAFE },
  { ".ebayrtm.com", NULL, "\\.ebayrtm" TLD,             "eBay",             NDPI_PROTOCOL_EBAY, NDPI_PROTOCOL_CATEGORY_SHOPPING, NDPI_PROTOCOL_SAFE },
  { ".ebaystratus.com", NULL, "\\.ebaystratus" TLD,     "eBay",             NDPI_PROTOCOL_EBAY, NDPI_PROTOCOL_CATEGORY_SHOPPING, NDPI_PROTOCOL_SAFE },
  { ".ebayimg.com", NULL, "\\.ebayimg" TLD,             "eBay",             NDPI_PROTOCOL_EBAY, NDPI_PROTOCOL_CATEGORY_SHOPPING, NDPI_PROTOCOL_SAFE },

  /* Detected "instagram.c10r.facebook.com". Omitted "*amazonaws.com" and "*facebook.com" CDNs e.g. "ig-telegraph-shv-04-frc3.facebook.com" */
  { ".instagram.", NULL, "\\.instagram" TLD,            "Instagram",        NDPI_PROTOCOL_INSTAGRAM, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
  { "instagram.", NULL, "instagram" TLD,                "Instagram",        NDPI_PROTOCOL_INSTAGRAM, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
  { ".cdninstagram.com", NULL, "\\.cdninstagram" TLD,   "Instagram",        NDPI_PROTOCOL_INSTAGRAM, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },

  { "igcdn-photos-", NULL, "igcdn-photos-",             "Instagram",        NDPI_PROTOCOL_INSTAGRAM, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
  { "instagramimages-", NULL, "instagramimages-",       "Instagram",        NDPI_PROTOCOL_INSTAGRAM, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
  { "instagramstatic-", NULL, "instagramstatic-",       "Instagram",        NDPI_PROTOCOL_INSTAGRAM, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },

  { "facebook.com", NULL, "facebook" TLD,                         "Facebook",         NDPI_PROTOCOL_FACEBOOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
  { "fbstatic-a.akamaihd.net", NULL, "fbstatic-a\\.akamaihd" TLD, "Facebook",         NDPI_PROTOCOL_FACEBOOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
  { ".fbcdn.net", NULL, "\\.fbcdn" TLD,                           "Facebook",         NDPI_PROTOCOL_FACEBOOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
  { "fbcdn-", NULL, "fbcdn-",                                     "Facebook",         NDPI_PROTOCOL_FACEBOOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
  { ".facebook.net", NULL, "\\.facebook" TLD,                     "Facebook",         NDPI_PROTOCOL_FACEBOOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
  { ".fbsbx.com", NULL, "\\.fbsbx" TLD,                           "Facebook",         NDPI_PROTOCOL_FACEBOOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },

  { "speedtest.", NULL, "speedtest\\." TLD,                       "Ookla",            NDPI_PROTOCOL_OOKLA, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_SAFE },
  { ".ooklaserver.net", NULL, "\\.ooklaserver\\.net" TLD,         "Ookla",            NDPI_PROTOCOL_OOKLA, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_SAFE },

  { "ntop.org", NULL, "ntop\\.org$",                     "ntop",         NDPI_PROTOCOL_NTOP, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_SAFE },

  { "docs.googleusercontent.com", NULL, "docs.googleusercontent" TLD,   "GoogleDocs",     NDPI_PROTOCOL_GOOGLE_DOCS, NDPI_PROTOCOL_CATEGORY_MEDIA, NDPI_PROTOCOL_ACCEPTABLE },
  { "docs.google.com",            NULL, "docs.google" TLD,              "GoogleDocs",     NDPI_PROTOCOL_GOOGLE_DOCS, NDPI_PROTOCOL_CATEGORY_MEDIA, NDPI_PROTOCOL_ACCEPTABLE },

  { "drive-thirdparty.googleusercontent.com", NULL, "drive-thirdparty\\.googleusercontent" TLD,  "GoogleDrive",      NDPI_PROTOCOL_GOOGLE_DRIVE, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
  { "drive.google.com",                       NULL, "drive.google" TLD,                          "GoogleDrive",      NDPI_PROTOCOL_GOOGLE_DRIVE, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_ACCEPTABLE },

  { "android.clients.google.com", NULL, "android\\.clients\\.google" TLD,   "PlayStore",    NDPI_PROTOCOL_PLAYSTORE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE },

    /*
    https://www.fastvue.co/sophos/blog/google-data-saver-affect-security-confidentiality-reporting/
    Used by Google Chrome Lite Mode for Android

    This traffic will bypass checks and blocks as it will include all the communications from/to
    the browser instead of using the standard communication mechanisms SSL/HTTP(S)/DNS
  */
  { ".googlezip.net", NULL, ".googlezip\\.net" TLD,                       "DataSaver",     NDPI_PROTOCOL_DATASAVER, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },	 
  { "datasaver.googleapis.com", NULL, "datasaver\\.googleapis\\.com" TLD, "DataSaver",     NDPI_PROTOCOL_DATASAVER, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },

  /* http://check.googlezip.net/connect [check browser connectivity] */
  // { ".googlezip.net", NULL, "\\.googlezip" TLD,                   "Google",           NDPI_PROTOCOL_GOOGLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },

  { "dns.google", NULL, "dns\\.google" TLD, "DNSoverHTTPS",     NDPI_PROTOCOL_DNS_OVER_HTTPS, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
  // { "mozilla.cloudflare-dns.com", NULL, "mozilla\\.cloudflare-dns\\.com" TLD, "DNSoverHTTPS",     NDPI_PROTOCOL_DNS_OVER_HTTPS, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE }, /* Firefox */
  { "cloudflare-dns.com", NULL, "cloudflare-dns\\.com" TLD, "DNSoverHTTPS",     NDPI_PROTOCOL_DNS_OVER_HTTPS, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },


  /*
    See https://better.fyi/trackers/

    DoubleClick by Google (2mdn.net)
    DoubleClick by Google (doubleclick.net)
    DoubleClick by Google, Inc. (dmtry.com)
    Google AdSense by Google (google.com)
    Google AdSense by Google (google.se)
    Google AdSense by Google (googleadservices.com)
    Google Analytics by Google (google-analytics.com)
    Google APIs by Google (ajax.googleapis.com)
    Google Fonts by Google (fonts.googleapis.com)
    Google Interactive Media Ads (imasdk.googleapis.com)
    Google Syndication (googlesyndication.com)
    Google Tag Manager by Google (googletagmanager.com)
    Google Tag Manager by Google (googletagservices.com)
    Gstatic by Google (gstatic.com)
  */

  /* Google Advertisements */
  { ".googlesyndication.com", NULL, "\\.googlesyndication" TLD,   "Google",           NDPI_PROTOCOL_GOOGLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_TRACKER_ADS },
  { "googleads.", NULL, "googleads\\.",                           "Google",           NDPI_PROTOCOL_GOOGLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_TRACKER_ADS },
  { ".doubleclick.net", NULL, "\\.doubleclick" TLD,               "Google",           NDPI_PROTOCOL_GOOGLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_TRACKER_ADS },
  { "googleadservices.", NULL, "googleadservices\\.",             "Google",           NDPI_PROTOCOL_GOOGLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_TRACKER_ADS },
  { ".2mdn.net", NULL, "\\.2mdn" TLD,                             "Google",           NDPI_PROTOCOL_GOOGLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_TRACKER_ADS },
  { ".dmtry.com", NULL, "\\.dmtry" TLD,                           "Google",           NDPI_PROTOCOL_GOOGLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_TRACKER_ADS },
  { "google-analytics.", NULL, "google-analytics\\.",             "Google",           NDPI_PROTOCOL_GOOGLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_TRACKER_ADS },
  { "gtv1.com", NULL, "gtv1" TLD,                                 "Google",           NDPI_PROTOCOL_GOOGLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },

  /* Google Hangout */
  { "images2-hangout-opensocial.googleusercontent.com", NULL, "images2-hangout-opensocial\\.googleusercontent" TLD, "GoogleHangout", NDPI_PROTOCOL_HANGOUT, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE },

  /* Google Services */
  { "googleapis.com", NULL, "googleapis" TLD,                     "GoogleServices",   NDPI_PROTOCOL_GOOGLE_SERVICES, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },
  { ".googletagservices.com", NULL, "\\.googletagservices" TLD,   "GoogleServices",   NDPI_PROTOCOL_GOOGLE_SERVICES, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },
  { "mtalk.google.com", NULL, "mtalk\\.google" TLD,               "GoogleServices",   NDPI_PROTOCOL_GOOGLE_SERVICES, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },

  { "plus.google.com", NULL, "plus\\.google" TLD,                 "GooglePlus",       NDPI_PROTOCOL_GOOGLE_PLUS, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
  { "plus.url.google.com", NULL, "plus\\.url\\.google" TLD,       "GooglePlus",       NDPI_PROTOCOL_GOOGLE_PLUS, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },

  { "googleusercontent.com", NULL, "googleusercontent" TLD,       "Google",           NDPI_PROTOCOL_GOOGLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },
  { "1e100.net", NULL, "1e100" TLD,                               "Google",           NDPI_PROTOCOL_GOOGLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },

  { "maps.google.", NULL, "maps\\.google" TLD,                    "GoogleMaps",       NDPI_PROTOCOL_GOOGLE_MAPS, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },
  { "maps.gstatic.com", NULL, "maps\\.gstatic" TLD,               "GoogleMaps",       NDPI_PROTOCOL_GOOGLE_MAPS, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },

  { ".gmail.", NULL, "\\.gmail" TLD,                              "GMail",            NDPI_PROTOCOL_GMAIL, NDPI_PROTOCOL_CATEGORY_MAIL, NDPI_PROTOCOL_ACCEPTABLE },
  { "mail.google.", NULL, "mail\\.google" TLD,                    "GMail",            NDPI_PROTOCOL_GMAIL, NDPI_PROTOCOL_CATEGORY_MAIL, NDPI_PROTOCOL_ACCEPTABLE },

  { "google.", NULL, "google" TLD,                                "Google",           NDPI_PROTOCOL_GOOGLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },
  { ".google.", NULL, NULL,                                       "Google",           NDPI_PROTOCOL_GOOGLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },
  { ".gstatic.com", NULL, "\\.gstatic" TLD,                       "Google",           NDPI_PROTOCOL_GOOGLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },
  { "ggpht.com", NULL, "ggpht" TLD,                               "Google",           NDPI_PROTOCOL_GOOGLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },

  { "mail.outlook.com", NULL, "mail\\.outlook" TLD,               "Hotmail",          NDPI_PROTOCOL_HOTMAIL, NDPI_PROTOCOL_CATEGORY_MAIL, NDPI_PROTOCOL_ACCEPTABLE },

  { ".last.fm", NULL, "\\.last\\.fm$",                            "LastFM",           NDPI_PROTOCOL_LASTFM, NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN },

  { "msn.com", NULL, "msn" TLD,                                   "MSN",              NDPI_PROTOCOL_MSN, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE }, /* News site */

  { "netflix.com", NULL, "netflix" TLD,                           "NetFlix",          NDPI_PROTOCOL_NETFLIX, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN },
  { "nflxext.com", NULL, "nflxext" TLD,                           "NetFlix",          NDPI_PROTOCOL_NETFLIX, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN },
  { "nflximg.com", NULL, "nflximg" TLD,                           "NetFlix",          NDPI_PROTOCOL_NETFLIX, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN },
  { "nflximg.net", NULL, "nflximg" TLD,                           "NetFlix",          NDPI_PROTOCOL_NETFLIX, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN },
  { "nflxvideo.net", NULL, "nflxvideo" TLD,                       "NetFlix",          NDPI_PROTOCOL_NETFLIX, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN },
  { "nflxso.net", NULL, "nflxso" TLD,                             "NetFlix",          NDPI_PROTOCOL_NETFLIX, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN },

  { ".skype.", NULL, "\\.skype\\.",                                    "Skype",            NDPI_PROTOCOL_SKYPE, NDPI_PROTOCOL_CATEGORY_VOIP, NDPI_PROTOCOL_ACCEPTABLE },
  { ".skypeassets.", NULL, "\\.skypeassets\\.",                        "Skype",            NDPI_PROTOCOL_SKYPE, NDPI_PROTOCOL_CATEGORY_VOIP, NDPI_PROTOCOL_ACCEPTABLE },
  { ".skypedata.", NULL, "\\.skypedata\\.",                            "Skype",            NDPI_PROTOCOL_SKYPE, NDPI_PROTOCOL_CATEGORY_VOIP, NDPI_PROTOCOL_ACCEPTABLE },
  { ".skypeecs-", NULL, "\\.skypeecs-",                                "Skype",            NDPI_PROTOCOL_SKYPE, NDPI_PROTOCOL_CATEGORY_VOIP, NDPI_PROTOCOL_ACCEPTABLE },
  { ".skypeforbusiness.", NULL, "\\.skypeforbusiness\\.",              "Skype",            NDPI_PROTOCOL_SKYPE, NDPI_PROTOCOL_CATEGORY_VOIP, NDPI_PROTOCOL_ACCEPTABLE },
  { ".lync.com", NULL, "\\.lync" TLD,                                  "Skype",            NDPI_PROTOCOL_SKYPE, NDPI_PROTOCOL_CATEGORY_VOIP, NDPI_PROTOCOL_ACCEPTABLE },
  { "e7768.b.akamaiedge.net", NULL, "e7768\\.b\\.akamaiedge" TLD,      "Skype",            NDPI_PROTOCOL_SKYPE, NDPI_PROTOCOL_CATEGORY_VOIP, NDPI_PROTOCOL_ACCEPTABLE },
  { "e4593.dspg.akamaiedge.net", NULL, "e4593\\.dspg\\.akamaiedge" TLD,"Skype",            NDPI_PROTOCOL_SKYPE, NDPI_PROTOCOL_CATEGORY_VOIP, NDPI_PROTOCOL_ACCEPTABLE },
  { "e4593.g.akamaiedge.net", NULL, "e4593\\.g\\.akamaiedge" TLD,      "Skype",            NDPI_PROTOCOL_SKYPE, NDPI_PROTOCOL_CATEGORY_VOIP, NDPI_PROTOCOL_ACCEPTABLE },

  { ".tuenti.com", NULL, "\\.tuenti" TLD,                              "Tuenti",           NDPI_PROTOCOL_TUENTI, NDPI_PROTOCOL_CATEGORY_VOIP, NDPI_PROTOCOL_ACCEPTABLE },

  { ".twttr.com", NULL, "\\.twttr" TLD,                                "Twitter",          NDPI_PROTOCOL_TWITTER, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
  { "twitter.", NULL, "twitter" TLD,                                   "Twitter",          NDPI_PROTOCOL_TWITTER, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
  { "twimg.com", NULL, "twimg" TLD,                                    "Twitter",          NDPI_PROTOCOL_TWITTER, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },

  { ".viber.com", NULL, "\\.viber" TLD,                                "Viber",            NDPI_PROTOCOL_VIBER, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE },
  { ".cdn.viber.com", NULL, NULL,                                      "Viber",            NDPI_PROTOCOL_VIBER, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE },
  { ".viber.it", NULL, NULL,                                           "Viber",            NDPI_PROTOCOL_VIBER, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE },

  { "wikipedia.", NULL, "wikipedia" TLD,                               "Wikipedia",        NDPI_PROTOCOL_WIKIPEDIA, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },
  { "wikimedia.", NULL, "wikimedia" TLD,                               "Wikipedia",        NDPI_PROTOCOL_WIKIPEDIA, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },
  { "mediawiki.", NULL, "mediawiki" TLD,                               "Wikipedia",        NDPI_PROTOCOL_WIKIPEDIA, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },
  { "wikimediafoundation.", NULL, "wikimediafoundation" TLD,           "Wikipedia",        NDPI_PROTOCOL_WIKIPEDIA, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },

  { "mmg-fna.whatsapp.net", NULL, "mmg-fna\\.whatsapp" TLD,            "WhatsAppFiles",    NDPI_PROTOCOL_WHATSAPP_FILES, NDPI_PROTOCOL_CATEGORY_DOWNLOAD_FT, NDPI_PROTOCOL_ACCEPTABLE },
  { ".whatsapp.", NULL, "\\.whatsapp" TLD,                             "WhatsApp",         NDPI_PROTOCOL_WHATSAPP, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE },

  { ".yahoo.", NULL, "\\.yahoo" TLD,                                   "Yahoo",            NDPI_PROTOCOL_YAHOO, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },
  { ".yimg.com", NULL, "\\.yimg" TLD,                                  "Yahoo",            NDPI_PROTOCOL_YAHOO, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },
  { "yahooapis.", NULL, "yahooapis" TLD,                               "Yahoo",            NDPI_PROTOCOL_YAHOO, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },

  { "upload.youtube.com", NULL, "upload\\.youtube" TLD,                "YouTubeUpload",    NDPI_PROTOCOL_YOUTUBE_UPLOAD, NDPI_PROTOCOL_CATEGORY_MEDIA, NDPI_PROTOCOL_FUN },
  { "upload.video.google.com", NULL, "upload\\.video\\.google" TLD,    "YouTubeUpload",    NDPI_PROTOCOL_YOUTUBE_UPLOAD, NDPI_PROTOCOL_CATEGORY_MEDIA, NDPI_PROTOCOL_FUN },
  { "youtubei.googleapis.com", NULL, "youtubei\\.googleapis" TLD,      "YouTube",          NDPI_PROTOCOL_YOUTUBE, NDPI_PROTOCOL_CATEGORY_MEDIA, NDPI_PROTOCOL_FUN },
  { "youtube.", NULL, "youtube" TLD,                                   "YouTube",          NDPI_PROTOCOL_YOUTUBE, NDPI_PROTOCOL_CATEGORY_MEDIA, NDPI_PROTOCOL_FUN },
  { "youtu.be.", NULL, "youtu\\.be" TLD,                               "YouTube",          NDPI_PROTOCOL_YOUTUBE, NDPI_PROTOCOL_CATEGORY_MEDIA, NDPI_PROTOCOL_FUN },
  { "yt3.ggpht.com", NULL, "yt3\\.ggpht" TLD,                          "YouTube",          NDPI_PROTOCOL_YOUTUBE, NDPI_PROTOCOL_CATEGORY_MEDIA, NDPI_PROTOCOL_FUN },
  { ".googlevideo.com", NULL, "\\.googlevideo" TLD,                    "YouTube",          NDPI_PROTOCOL_YOUTUBE, NDPI_PROTOCOL_CATEGORY_MEDIA, NDPI_PROTOCOL_FUN },
  { ".ytimg.com", NULL, "\\.ytimg" TLD,                                "YouTube",          NDPI_PROTOCOL_YOUTUBE, NDPI_PROTOCOL_CATEGORY_MEDIA, NDPI_PROTOCOL_FUN },
  { "youtube-nocookie.", NULL, "youtube-nocookie" TLD,                 "YouTube",          NDPI_PROTOCOL_YOUTUBE, NDPI_PROTOCOL_CATEGORY_MEDIA, NDPI_PROTOCOL_FUN },

  { ".vevo.com", NULL, "\\.vevo" TLD,                                  "Vevo",             NDPI_PROTOCOL_VEVO,    NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN },

  { ".spotify.", NULL, "\\.spotify" TLD,                               "Spotify",          NDPI_PROTOCOL_SPOTIFY, NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN },
  { "audio-fa.scdn.co", NULL, "audio-fa\\.scdn" TLD,                   "Spotify",          NDPI_PROTOCOL_SPOTIFY, NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN },

  { "edge-mqtt.facebook.com", NULL, "edge-mqtt\\.facebook" TLD,        "Messenger",        NDPI_PROTOCOL_MESSENGER, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_FUN },
  { "mqtt-mini.facebook.com", NULL, "mqtt-mini\\.facebook" TLD,        "Messenger",        NDPI_PROTOCOL_MESSENGER, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_FUN }, /* Messenger Lite */
  { "messenger.com", NULL, "messenger\\.com" TLD,                      "Messenger",        NDPI_PROTOCOL_MESSENGER, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_FUN },

  { ".pandora.com", NULL, "\\.pandora" TLD,                            "Pandora",          NDPI_PROTOCOL_PANDORA,  NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN },

  { ".torproject.org", NULL, "\\.torproject\\.org$",                   "Tor",              NDPI_PROTOCOL_TOR, NDPI_PROTOCOL_CATEGORY_VPN, NDPI_PROTOCOL_POTENTIALLY_DANGEROUS },

  { ".kakao.com", NULL, "\\.kakao" TLD,                                "KakaoTalk",        NDPI_PROTOCOL_KAKAOTALK, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE },

  { "ttvnw.net", NULL, "ttvnw" TLD,                                    "Twitch",           NDPI_PROTOCOL_TWITCH, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN },
  { "static-cdn.jtvnw.net", NULL, "static-cdn\\.jtvnw" TLD,            "Twitch",           NDPI_PROTOCOL_TWITCH, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN },
  { "www-cdn.jtvnw.net", NULL, "www-cdn\\.jtvnw" TLD,                  "Twitch",           NDPI_PROTOCOL_TWITCH, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN },

  { ".qq.com", NULL, "\\.qq" TLD,                                      "QQ",               NDPI_PROTOCOL_QQ, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_FUN },
  { ".gtimg.com", NULL, "\\.gtimg" TLD,                                "QQ",               NDPI_PROTOCOL_QQ, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_FUN },

  { ".weibo.com", NULL, "\\.weibo" TLD,                                "Sina(Weibo)",      NDPI_PROTOCOL_SINA, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
  { ".weibo.cn", NULL, NULL,                                           "Sina(Weibo)",      NDPI_PROTOCOL_SINA, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
  { ".sinaimg.cn", NULL, "\\.sinaimg" TLD,                             "Sina",             NDPI_PROTOCOL_SINA, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
  { ".sinajs.cn", NULL, "\\.sinajs" TLD,                               "Sina",             NDPI_PROTOCOL_SINA, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
  { ".sina.cn", NULL, "\\.sina" TLD,                                   "Sina",             NDPI_PROTOCOL_SINA, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
  { ".sina.com.cn", NULL, "\\.sina\\.com\\.cn$",                       "Sina",             NDPI_PROTOCOL_SINA, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },

  /* https://support.cipafilter.com/index.php?/Knowledgebase/Article/View/117/0/snapchat---how-to-block */
  { "feelinsonice.appspot.com", NULL, "\\.appspot" TLD,                     "Snapchat",     NDPI_PROTOCOL_SNAPCHAT, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
  { "feelinsonice-hrd.appspot.com", NULL, "feelinsonice-hrd\\.appspot" TLD, "Snapchat",     NDPI_PROTOCOL_SNAPCHAT, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
  { "feelinsonice.com", NULL, "\\.feelsonice" TLD,                          "Snapchat",     NDPI_PROTOCOL_SNAPCHAT, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
  { ".snapchat.", NULL, "\\.snapchat" TLD,                                  "Snapchat",     NDPI_PROTOCOL_SNAPCHAT, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
  { ".snapads.", NULL, "\\.snapads" TLD,                                    "Snapchat",     NDPI_PROTOCOL_SNAPCHAT, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
  { ".sc-cdn.net", NULL, "\\.sc-cdn\\.net" TLD,                             "Snapchat",     NDPI_PROTOCOL_SNAPCHAT, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
  { ".sc-prod.net", NULL, "\\.sc-prod\\.net" TLD,                           "Snapchat",     NDPI_PROTOCOL_SNAPCHAT, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
  { ".sc-jpl.com", NULL, "\\.sc-jpl\\.com" TLD,                             "Snapchat",     NDPI_PROTOCOL_SNAPCHAT, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
  { "sc-analytics.appspot.com", NULL, "sc-analytics\\.appspot\\.com",       "Snapchat",     NDPI_PROTOCOL_SNAPCHAT, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },

  { ".waze.com", NULL, "\\.waze" TLD,                                  "Waze",             NDPI_PROTOCOL_WAZE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },

  { ".deezer.com", NULL, "\\.deezer" TLD,                              "Deezer",           NDPI_PROTOCOL_DEEZER, NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN },

  { ".microsoft.com", NULL, "\\.microsoft" TLD,                        "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },
  { "i-msdn.sec.s-msft.com", NULL, "i-msdn.sec\\.s-msft" TLD,          "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_SYSTEM_OS, NDPI_PROTOCOL_ACCEPTABLE },
  { "i2-msdn.sec.s-msft.com", NULL, "i2-msdn\\.sec\\.s-msft" TLD,      "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_SYSTEM_OS, NDPI_PROTOCOL_ACCEPTABLE },
  { ".webtrends.com", NULL, "\\.webtrends" TLD,                        "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },
  { ".msecnd.net", NULL, "\\.msecnd" TLD,                              "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },
  { "bing.com", NULL, "bing" TLD,                                      "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },
  { ".visualstudio.com", NULL, "\\.visualstudio" TLD,                  "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_SAFE },
  { "login.live.com", NULL, "login\\.live" TLD,                        "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },

  { "bn1301.storage.live.com", NULL, "bn1301\\.storage\\.live" TLD,               "MS_OneDrive",  NDPI_PROTOCOL_MS_ONE_DRIVE,NDPI_PROTOCOL_CATEGORY_CLOUD,  NDPI_PROTOCOL_ACCEPTABLE },
  { "*.gateway.messenger.live.com", NULL, "\\*\\.gateway\\.messenger\\.live" TLD, "MS_OneDrive",  NDPI_PROTOCOL_MS_ONE_DRIVE, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_ACCEPTABLE },
  { "skyapi.live.net", NULL, "skyapi\\.live" TLD,                                 "MS_OneDrive",  NDPI_PROTOCOL_MS_ONE_DRIVE, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_ACCEPTABLE },
  { "d.docs.live.net", NULL, "d\\.docs\\.live" TLD,                               "MS_OneDrive",  NDPI_PROTOCOL_MS_ONE_DRIVE, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_ACCEPTABLE },
  { "onedrive.live.com", NULL, "onedrive\\.live" TLD,                             "MS_OneDrive",  NDPI_PROTOCOL_MS_ONE_DRIVE, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_ACCEPTABLE },

  { "update.microsoft.com", NULL, "update\\.microsoft" TLD,            "WindowsUpdate",    NDPI_PROTOCOL_WINDOWS_UPDATE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE },
  { ".windowsupdate.com", NULL, "\\.windowsupdate" TLD,                "WindowsUpdate",    NDPI_PROTOCOL_WINDOWS_UPDATE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE },

  { "worldofwarcraft.com", NULL, "worldofwarcraft" TLD,                "WorldOfWarcraft",  NDPI_PROTOCOL_WORLDOFWARCRAFT, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN },

  { ".anchorfree.", NULL, "\\.anchorfree" TLD,                         "HotspotShield",    NDPI_PROTOCOL_HOTSPOT_SHIELD, NDPI_PROTOCOL_CATEGORY_VPN, NDPI_PROTOCOL_POTENTIALLY_DANGEROUS },
  { "hotspotshield.com", NULL, "hotspotshield" TLD,                    "HotspotShield",    NDPI_PROTOCOL_HOTSPOT_SHIELD, NDPI_PROTOCOL_CATEGORY_VPN, NDPI_PROTOCOL_POTENTIALLY_DANGEROUS },
  { ".northghost.com", NULL, "\\.northghost" TLD,                      "HotspotShield",    NDPI_PROTOCOL_HOTSPOT_SHIELD, NDPI_PROTOCOL_CATEGORY_VPN, NDPI_PROTOCOL_POTENTIALLY_DANGEROUS },

  { ".webex.com", NULL, "\\.webex" TLD,                                "Webex",            NDPI_PROTOCOL_WEBEX, NDPI_PROTOCOL_CATEGORY_VOIP, NDPI_PROTOCOL_ACCEPTABLE },

  { ".ocsdomain.com", NULL, "\\.ocsdomain" TLD,                        "OCS",              NDPI_PROTOCOL_OCS, NDPI_PROTOCOL_CATEGORY_MEDIA, NDPI_PROTOCOL_FUN },
  { "ocs.fr", NULL, "ocs" TLD,                                         "OCS",              NDPI_PROTOCOL_OCS, NDPI_PROTOCOL_CATEGORY_MEDIA, NDPI_PROTOCOL_FUN },
  { ".ocs.fr", NULL, NULL,                                             "OCS",              NDPI_PROTOCOL_OCS, NDPI_PROTOCOL_CATEGORY_MEDIA, NDPI_PROTOCOL_FUN },
  { ".labgency.ws", NULL, ".labgency" TLD,                             "OCS",              NDPI_PROTOCOL_OCS, NDPI_PROTOCOL_CATEGORY_MEDIA, NDPI_PROTOCOL_FUN },

  { ".iflix.com", NULL, "\\.iflix" TLD,                                "IFLIX",            NDPI_PROTOCOL_IFLIX, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN },
  { ".app.iflixcorp.com", NULL, "\\.app\\.iflixcorp" TLD,              "IFLIX",            NDPI_PROTOCOL_IFLIX, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN },
  { ".images.iflixassets.com", NULL, "\\.images\\.iflixassets" TLD,    "IFLIX",            NDPI_PROTOCOL_IFLIX, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN },

  { "crl.microsoft.com", NULL, "crl\\.microsoft" TLD,                  "Office365",    NDPI_PROTOCOL_OFFICE_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
  { "evsecure-ocsp.verisign.com", NULL, "evsecure-ocsp\\.verisign" TLD,"Office365",    NDPI_PROTOCOL_OFFICE_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
  { "evsecure-aia.verisign.com", NULL, "evsecure-aia\\.verisign" TLD,  "Office365",    NDPI_PROTOCOL_OFFICE_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
  { "evsecure-crl.verisign.com", NULL, "evsecure-crl\\.verisign" TLD,  "Office365",    NDPI_PROTOCOL_OFFICE_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
  { ".omniroot.com", NULL, "\\.omniroot" TLD,                          "Office365",    NDPI_PROTOCOL_OFFICE_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
  { ".microsoftonline.com", NULL, "\\.microsoftonline" TLD,            "Office365",    NDPI_PROTOCOL_OFFICE_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
  { ".office365.com", NULL, "\\.office365" TLD,                        "Office365",    NDPI_PROTOCOL_OFFICE_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
  { ".office.com", NULL, "\\.office" TLD,                              "Office365",    NDPI_PROTOCOL_OFFICE_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
  { "office.net", NULL, NULL,                                          "Office365",    NDPI_PROTOCOL_OFFICE_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
  { ".msocsp.com", NULL, "\\.msocsp" TLD,                              "Office365",    NDPI_PROTOCOL_OFFICE_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
  { ".msocdn.com", NULL, "\\.msocdn" TLD,                              "Office365",    NDPI_PROTOCOL_OFFICE_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
  { "officeapps.live.com", NULL, "officeapps\\.live" TLD,              "Office365",    NDPI_PROTOCOL_OFFICE_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
  { "outlook.live.com", NULL, "outlook\\.live" TLD,                    "Office365",    NDPI_PROTOCOL_OFFICE_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
  { "office.live.com", NULL, "office\\.live" TLD,                      "Office365",    NDPI_PROTOCOL_OFFICE_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
  { ".onenote.", NULL, "\\.onenote" TLD,                               "Office365",    NDPI_PROTOCOL_OFFICE_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },

  /* http://www.urlquery.net/report.php?id=1453233646161 */
  { "lifedom.top", NULL, "lifedom" TLD,                                "Cloudflare",       NDPI_PROTOCOL_CLOUDFLARE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },
  { "coby.ns.cloudflare.com", NULL, "coby\\.ns\\.cloudflare" TLD,      "Cloudflare",       NDPI_PROTOCOL_CLOUDFLARE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },
  { "amanda.ns.cloudflare.com", NULL, "amanda\\.ns\\.cloudflare" TLD,  "Cloudflare",       NDPI_PROTOCOL_CLOUDFLARE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },

  { "d295hzzivaok4k.cloudfront.net", NULL, "d295hzzivaok4k\\.cloudfront" TLD,"OpenDNS",      NDPI_PROTOCOL_OPENDNS, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },
  { ".opendns.com", NULL, "\\.opendns" TLD,                                  "OpenDNS",      NDPI_PROTOCOL_OPENDNS, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },

  /* https://get.slack.help/hc/en-us/articles/205138367-Troubleshooting-Slack-connection-issues */
  { "slack.com", NULL, "slack" TLD,                                    "Slack",            NDPI_PROTOCOL_SLACK, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
  { ".slack-msgs.com", NULL, "\\.slack-msgs" TLD,                      "Slack",            NDPI_PROTOCOL_SLACK, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
  { "slack-files.com", NULL, "slack-files" TLD,                        "Slack",            NDPI_PROTOCOL_SLACK, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
  { "slack-imgs.com", NULL, "slack-imgs" TLD,                          "Slack",            NDPI_PROTOCOL_SLACK, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
  { ".slack-edge.com", NULL, "\\.slack-edge" TLD,                      "Slack",            NDPI_PROTOCOL_SLACK, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
  { ".slack-core.com", NULL, "\\.slack-core" TLD,                      "Slack",            NDPI_PROTOCOL_SLACK, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
  { "slack-redir.net", NULL, "slack-redir" TLD,                        "Slack",            NDPI_PROTOCOL_SLACK, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
  /* Detected "slack-assets2.s3-us-west-2.amazonaws.com.". Omitted "*amazonaws.com" CDN, but no generic pattern to use on first part */
  { "slack-assets2.s3-", NULL, "slack-assets2\\.s3-",                  "Slack",            NDPI_PROTOCOL_SLACK, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },

  { "wechat.com", NULL, "wechat\\.com" TLD,                            "WeChat",           NDPI_PROTOCOL_WECHAT, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },

  { "github.com", NULL, "github" TLD,                                  "Github",           NDPI_PROTOCOL_GITHUB, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
  { ".github.com", NULL, "\\.github" TLD,                              "Github",           NDPI_PROTOCOL_GITHUB, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
  { "github.io", NULL, NULL,                                           "Github",           NDPI_PROTOCOL_GITHUB, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
  { ".github.io", NULL, NULL,                                          "Github",           NDPI_PROTOCOL_GITHUB, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
  { "githubusercontent.com", NULL, "githubusercontent" TLD,            "Github",           NDPI_PROTOCOL_GITHUB, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
  { ".githubusercontent.com", NULL, "\\.githubusercontent" TLD,        "Github",           NDPI_PROTOCOL_GITHUB, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },

  { ".steampowered.com", NULL, "\\.steampowered" TLD,                        "Steam",        NDPI_PROTOCOL_STEAM, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN },
  { "steamcommunity.com", NULL, "steamcommunity" TLD,                        "Steam",        NDPI_PROTOCOL_STEAM, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN },
  { ".steamcontent.com", NULL, "\\.steamcontent" TLD,                        "Steam",        NDPI_PROTOCOL_STEAM, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN },
  { ".steamstatic.com", NULL, "\\.steamstatic" TLD,                          "Steam",        NDPI_PROTOCOL_STEAM, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN },
  { "steamcommunity-a.akamaihd.net", NULL, "steamcommunity-a\\.akamaihd" TLD,"Steam",        NDPI_PROTOCOL_STEAM, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN },

  { ".wechat.com", NULL, "\\.wechat\\.com",                            "WeChat",           NDPI_PROTOCOL_WECHAT, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_FUN },
  { ".wechat.org", NULL, "\\.wechat\\.org",                            "WeChat",           NDPI_PROTOCOL_WECHAT, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_FUN },
  { ".wechatapp.com", NULL, "\\.wechatapp" TLD,                        "WeChat",           NDPI_PROTOCOL_WECHAT, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_FUN },
  { ".we.chat", NULL, "\\.we\\.chat",                                  "WeChat",           NDPI_PROTOCOL_WECHAT, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_FUN },
  { ".wx.", NULL, "\\.wx\\.",                                          "WeChat",           NDPI_PROTOCOL_WECHAT, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_FUN },
  { ".weixin.", NULL, "\\.weixin\\.",                                  "WeChat",           NDPI_PROTOCOL_WECHAT, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_FUN },
  { ".mmsns.qpic.cn", NULL, "\\.mmsns\\.qpic" TLD,                     "WeChat",           NDPI_PROTOCOL_WECHAT, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_FUN },

  { "dnscrypt.org", NULL, "dnscrypt\\.org$",                           "DNScrypt",         NDPI_PROTOCOL_DNSCRYPT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },

  { "torrent.", NULL, "torrent" TLD,                                   "BitTorrent",       NDPI_PROTOCOL_BITTORRENT, NDPI_PROTOCOL_CATEGORY_DOWNLOAD_FT, NDPI_PROTOCOL_UNSAFE },
  { "torrents.", NULL, "torrents" TLD,                                 "BitTorrent",       NDPI_PROTOCOL_BITTORRENT, NDPI_PROTOCOL_CATEGORY_DOWNLOAD_FT, NDPI_PROTOCOL_UNSAFE },
  { "torrentz.", NULL, "torrentz" TLD,                                 "BitTorrent",       NDPI_PROTOCOL_BITTORRENT, NDPI_PROTOCOL_CATEGORY_DOWNLOAD_FT, NDPI_PROTOCOL_UNSAFE },

  { ".nintendo.net", NULL, "\\.nintendo" TLD,                          "Nintendo",         NDPI_PROTOCOL_NINTENDO, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN },
  { ".nintendo.com", NULL, NULL,                                       "Nintendo",         NDPI_PROTOCOL_NINTENDO, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN },

  { ".playstation.net", NULL, "\\.playstation" TLD,                          "Playstation",  NDPI_PROTOCOL_PLAYSTATION, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN },
  { ".playstation.com", NULL, NULL,                                          "Playstation",  NDPI_PROTOCOL_PLAYSTATION, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN },
  { ".sonyentertainmentnetwork.com", NULL, "\\.sonyentertainmentnetwork" TLD,"Playstation",  NDPI_PROTOCOL_PLAYSTATION, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN },

  { ".linkedin.com", NULL, "\\.linkedin" TLD,                          "LinkedIn",         NDPI_PROTOCOL_LINKEDIN, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
  { ".licdn.com", NULL, "\\.licdn" TLD,                                "LinkedIn",         NDPI_PROTOCOL_LINKEDIN, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },

  { ".sndcdn.com", NULL, "\\.sndcdn" TLD,                              "SoundCloud",       NDPI_PROTOCOL_SOUNDCLOUD, NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN },
  { ".soundcloud.com", NULL, "\\.soundcloud" TLD,                      "SoundCloud",       NDPI_PROTOCOL_SOUNDCLOUD, NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN },
  { "getrockerbox.com", NULL, "getrockerbox" TLD,                      "SoundCloud",       NDPI_PROTOCOL_SOUNDCLOUD, NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN },

  { "web.telegram.org", NULL, "web\\.telegram" TLD,                    "Telegram",         NDPI_PROTOCOL_TELEGRAM, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE },
  { "tdesktop.com", NULL, "tdesktop" TLD,                              "Telegram",         NDPI_PROTOCOL_TELEGRAM, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE },
  { "tupdate.com", NULL, "tupdate" TLD,                                "Telegram",         NDPI_PROTOCOL_TELEGRAM, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE },

  { ".pastebin.com", NULL, "\\.pastebin" TLD,                          "Pastebin",         NDPI_PROTOCOL_PASTEBIN, NDPI_PROTOCOL_CATEGORY_DOWNLOAD_FT, NDPI_PROTOCOL_POTENTIALLY_DANGEROUS },

  { ".ppstream.com", NULL, "\\.ppstream" TLD,                          "PPStream",         NDPI_PROTOCOL_PPSTREAM, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN },
  { ".pps.tv", NULL, "\\.pps\\.tv$",                                   "PPStream",         NDPI_PROTOCOL_PPSTREAM, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN },

  /*
    VidTO streaming service
    NOTE: this is a possible candidate for NDPI_PROTOCOL_GENERIC
  */
  { ".vidto.me", NULL, "\\.vidto" TLD,                                 "VidTO",            NDPI_PROTOCOL_PPSTREAM, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN },
  { ".vidto.se", NULL, NULL,                                           "VidTO",            NDPI_PROTOCOL_PPSTREAM, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN },

  /*
    Not so popular services without a protocl dissector (and thus not worth a protocolId) that are handled/detected by categpory rather
    than by protocol id. They are bound to a generic protocol (NDPI_PROTOCOL_GENERIC) and placed onto the right category
  */
  { "quickplay.com", NULL, "quickplay" TLD,                            "QuickPlay",        NDPI_PROTOCOL_GENERIC, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN },

  { ".iqiyi.com", NULL, "\\.iqiyi" TLD,                                "iQIYI",            NDPI_PROTOCOL_GENERIC, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN },
  { ".qiyi.com", NULL, "\\.qiyi" TLD,                                  "iQIYI",            NDPI_PROTOCOL_GENERIC, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN },
  { ".71.am", NULL, "\\.71" TLD,                                       "iQIYI",            NDPI_PROTOCOL_GENERIC, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN },
  { ".qiyipic.com", NULL, "\\.qiyipic" TLD,                            "iQIYI",            NDPI_PROTOCOL_GENERIC, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN },

  { ".1kxun.", NULL, "\\.1kxun\\.",                                    "1kxun",            NDPI_PROTOCOL_GENERIC, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN },
  { "tcad.wedolook.com", NULL, "tcad\\.wedolook" TLD,                  "1kxun",            NDPI_PROTOCOL_GENERIC, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN },

  { "baidu.com", NULL, "baidu" TLD,                                    "baidu",            NDPI_PROTOCOL_GENERIC, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_FUN },

  { "icq.", NULL, "icq" TLD,                                           "ICQ",              NDPI_PROTOCOL_GENERIC, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE },
  { ".icq.", NULL, NULL,                                               "ICQ",              NDPI_PROTOCOL_GENERIC, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE },


  /* RapidVideo streaming */
  { ".rapidvideo.com", NULL, "\\.rapidvideo" TLD,                      "RapidVideo",       NDPI_PROTOCOL_GENERIC, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN },
  { ".playercdn.net", NULL, "\\.playercdn" TLD,                        "RapidVideo",       NDPI_PROTOCOL_GENERIC, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN },

  /* showmax.com video streaming */
  { "showmax.com", NULL, "showmax" TLD,                                "Showmax",          NDPI_PROTOCOL_GENERIC, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN },
  { "showmax.akamaized.net", NULL, "showmax\\.akamaized" TLD,          "Showmax",          NDPI_PROTOCOL_GENERIC, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN },

  { "snapcraft.io", NULL, "snapcraft\\.io" TLD,                        "UbuntuONE",        NDPI_PROTOCOL_UBUNTUONE, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_ACCEPTABLE },
  { "ubuntu.com", NULL, "ubuntu\\.com" TLD,                            "UbuntuONE",        NDPI_PROTOCOL_UBUNTUONE, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_ACCEPTABLE },

  { "signal.org", NULL, "signal\\.org" TLD,                            "Signal",           NDPI_PROTOCOL_SIGNAL, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE },
  { "whispersystems.org", NULL, "whispersystems\\.org" TLD,            "Signal",           NDPI_PROTOCOL_SIGNAL, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE },
  { "musical.ly", NULL, "musical\\.ly" TLD,                            "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
  { "muscdn.com", NULL, "muscndl\\.com" TLD,                           "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },

  { NULL, NULL, NULL, 0 }
};
/* ******************************************************************** */

/*
  Tor
  The tor protocol uses SSL to contact peers so it could be exchanged with
  standard SSL. However the host names such as

  - www.fgd2iwya7vinfutj5wq5we.com
  - www.qbtxzhetq4s2f.com
  - www.fgd2iwya7vinfutj5wq5we.net

  See also DGA (Domain Generation Algorithm)

  In essence www.<name>.com|net

  To do things properly we should check if host name in the certificate
  exists or if the IP address of the SSL peer resolves to a name. Unfortunately
  for performance reasons we can't afford to do a DNS lookup in nDPI (however apps
  can do it if possible) and thus we have created a heuristic algorithm that tries
  to check the host name (in the SSL certificate) to see if it looks like a
  random name or a real name. We cannot use a dictionary (how can the kernel read a file?)
  and this we use bigrams distribution to decide if the string looks like a
  word or just random chars.

  http://www3.nd.edu/~busiforc/handouts/cryptography/Letter%20Frequencies.html
*/

static const char *ndpi_en_bigrams[] = {
  "aa", "ba", "ca", "da", "ea", "fa", "ga", "ha", "ia", "ja", "ka", "la", "ma", "na", "oa", "pa", "qa",
  "ra", "sa", "ta", "ua", "va", "wa", "xa", "ya", "za", "ab", "bb", "db", "eb", "fb", "gb", "hb", "ib",
  "kb", "lb", "mb", "nb", "ob", "pb", "rb", "sb", "tb", "ub", "wb", "yb", "ac", "bc", "cc", "dc", "ec",
  "fc", "gc", "hc", "ic", "kc", "lc", "mc", "nc", "oc", "pc", "rc", "sc", "tc", "uc", "wc", "xc", "yc",
  "ad", "bd", "cd", "dd", "ed", "fd", "gd", "hd", "id", "kd", "ld", "md", "nd", "od", "pd", "rd", "sd",
  "td", "ud", "wd", "xd", "yd", "zd", "ae", "be", "ce", "de", "ee", "fe", "ge", "he", "ie", "je", "ke",
  "le", "me", "ne", "oe", "pe", "re", "se", "te", "ue", "ve", "we", "xe", "ye", "ze", "af", "bf", "df",
  "ef", "ff", "gf", "hf", "if", "kf", "lf", "mf", "nf", "of", "pf", "rf", "sf", "tf", "uf", "wf", "xf",
  "yf", "zf", "ag", "bg", "dg", "eg", "fg", "gg", "hg", "ig", "kg", "lg", "ng", "og", "pg", "rg", "sg",
  "tg", "ug", "wg", "yg", "ah", "bh", "ch", "dh", "eh", "fh", "gh", "hh", "ih", "kh", "lh", "mh", "nh",
  "oh", "ph", "rh", "sh", "th", "uh", "wh", "xh", "yh", "ai", "bi", "ci", "di", "ei", "fi", "gi", "hi",
  "ii", "ji", "ki", "li", "mi", "ni", "oi", "pi", "qi", "ri", "si", "ti", "ui", "vi", "wi", "xi", "yi",
  "zi", "aj", "bj", "dj", "ej", "fj", "gj", "hj", "ij", "jj", "kj", "lj", "nj", "oj", "pj", "rj", "sj",
  "tj", "uj", "wj", "yj", "ak", "ck", "dk", "ek", "gk", "ik", "kk", "lk", "mk", "nk", "ok", "pk", "rk",
  "sk", "tk", "uk", "wk", "yk", "zk", "al", "bl", "cl", "dl", "el", "fl", "gl", "hl", "il", "kl", "ll",
  "ml", "nl", "ol", "pl", "rl", "sl", "tl", "ul", "vl", "wl", "xl", "yl", "zl", "am", "bm", "cm", "dm",
  "em", "fm", "gm", "hm", "im", "km", "lm", "mm", "nm", "om", "pm", "rm", "sm", "tm", "um", "wm", "xm",
  "ym", "zm", "an", "bn", "cn", "dn", "en", "fn", "gn", "hn", "in", "kn", "ln", "mn", "nn", "on", "pn",
  "rn", "sn", "tn", "un", "wn", "xn", "yn", "ao", "bo", "co", "do", "eo", "fo", "go", "ho", "io", "jo",
  "ko", "lo", "mo", "no", "oo", "po", "ro", "so", "to", "uo", "vo", "wo", "xo", "yo", "zo", "ap", "bp",
  "dp", "ep", "fp", "gp", "hp", "ip", "kp", "lp", "mp", "np", "op", "pp", "rp", "sp", "tp", "up", "wp",
  "xp", "yp", "zp", "aq", "cq", "dq", "eq", "hq", "iq", "nq", "oq", "qq", "rq", "sq", "uq", "xq", "ar",
  "br", "cr", "dr", "er", "fr", "gr", "hr", "ir", "kr", "lr", "mr", "nr", "or", "pr", "rr", "sr", "tr",
  "ur", "vr", "wr", "xr", "yr", "as", "bs", "cs", "ds", "es", "fs", "gs", "hs", "is", "ks", "ls", "ms",
  "ns", "os", "ps", "rs", "ss", "ts", "us", "vs", "ws", "xs", "ys", "at", "bt", "ct", "dt", "et", "ft",
  "gt", "ht", "it", "kt", "lt", "mt", "nt", "ot", "pt", "rt", "st", "tt", "ut", "wt", "xt", "yt", "zt",
  "au", "bu", "cu", "du", "eu", "fu", "gu", "hu", "iu", "ju", "ku", "lu", "mu", "nu", "ou", "pu", "qu",
  "ru", "su", "tu", "uu", "vu", "wu", "xu", "yu", "zu", "av", "bv", "dv", "ev", "iv", "lv", "mv", "nv",
  "ov", "rv", "sv", "tv", "uv", "vv", "zv", "aw", "bw", "dw", "ew", "fw", "gw", "hw", "iw", "kw", "lw",
  "mw", "nw", "ow", "pw", "rw", "sw", "tw", "uw", "ww", "xw", "yw", "zw", "ax", "ex", "ix", "nx", "ox",
  "rx", "ux", "xx", "yx", "ay", "by", "cy", "dy", "ey", "fy", "gy", "hy", "ky", "ly", "my", "ny", "oy",
  "py", "ry", "sy", "ty", "uy", "vy", "wy", "xy", "yy", "zy", "az", "bz", "cz", "dz", "ez", "gz", "iz",
  "lz", "nz", "oz", "pz", "rz", "tz", "uz", "zz", NULL };

/* ******************************************************************** */

static const char *ndpi_en_impossible_bigrams[] = {
  "bk", "bq", "bx", "cb", "cf", "cg", "cj", "cp", "cv", "cw", "cx", "dx", "fk", "fq", "fv", "fx", /* "ee", removed it can be found in 'meeting' */
  "fz", "gq", "gv", "gx", "hh", "hk", "hv", "hx", "hz", "iy", "jb", /* "jc", jcrew.com */ "jd", "jf", "jg", "jh", "jk",
  "jl", "jm", "jn", "jp", "jq", "jr", /* "js", */ "jt", "jv", "jw", "jx", "jy", "jz", "kg", "kq", "kv", "kx",
  "kz", "lq", "lx", /* "mg" tamgrt.com , */ "mj", "mq", "mx", "mz", "pq", "pv", "px", "qb", "qc", "qd", "qe", "qf", "ii",
  "qg", "qh", "qj", "qk", "ql", "qm", "qn", "qo", "qp", "qr", "qs", "qt", "qv", "qw", "qx", "qy", "uu",
  "qz", "sx", "sz", "tq", "tx", "vb", "vc", "vd", "vf", "vg", "vh", "vj", "vm", "vn", /* "vp", Removed for vpbank.com */ "bw", /* "vk", "zr" Removed for kavkazr */
  "vq", "vt", "vw", "vx", "vz", "wq", "wv", "wx", "wz", /* "xb", foxbusiness.com */
  	"xg", "xj", "xk", "xv", "xz", "xw", "yd", /*"yp", Removed for paypal */
  "yj", "yq", "yv", "yz", "yw", "zb", "zc", "zg", "zh", "zj", "zn", "zq", "zs", "zx", "wh", "wk",
  "wb", "zk", "kp", "zk", "xy",
  NULL };


