import { Index, Options, Version, VersionSpec } from '../types';
/**
 * Upgrade a dependencies collection based on latest available versions. Supports npm aliases.
 *
 * @param currentDependencies current dependencies collection object
 * @param latestVersions latest available versions collection object
 * @param [options={}]
 * @returns upgraded dependency collection object
 */
declare function upgradeDependencies(currentDependencies: Index<VersionSpec>, latestVersions: Index<Version>, options?: Options): Index<VersionSpec>;
export default upgradeDependencies;
