/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.impl.bundle.obr.resource;

import java.util.HashMap;
import java.util.Map;
import org.osgi.impl.bundle.obr.resource.Parameter;
import org.osgi.impl.bundle.obr.resource.VersionRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManifestEntry
implements Comparable<ManifestEntry> {
    String name;
    VersionRange version;
    Map<String, String> attributes;
    public Map<String, String> directives;

    public ManifestEntry(String name) {
        this.name = name;
    }

    public ManifestEntry(String name, VersionRange version) {
        this.name = name;
        this.version = version;
    }

    public String toString() {
        if (this.version == null) {
            return this.name;
        }
        return this.name + " ;version=" + this.version;
    }

    public String getName() {
        return this.name;
    }

    public VersionRange getVersion() {
        if (this.version != null) {
            return this.version;
        }
        return new VersionRange("0");
    }

    @Override
    public int compareTo(ManifestEntry p) {
        return this.name.compareTo(p.name);
    }

    public Object getPath() {
        return this.getName().replace('.', '/');
    }

    public Map<String, String> getDirectives() {
        return this.directives;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void addParameter(Parameter parameter) {
        switch (parameter.type) {
            case 1: {
                if (this.attributes == null) {
                    this.attributes = new HashMap<String, String>();
                }
                this.attributes.put(parameter.key, parameter.value);
                if (!parameter.key.equalsIgnoreCase("version") && !parameter.key.equalsIgnoreCase("specification-version")) break;
                this.version = new VersionRange(parameter.value);
                break;
            }
            case 2: {
                if (this.directives == null) {
                    this.directives = new HashMap<String, String>();
                }
                this.directives.put(parameter.key, parameter.value);
            }
        }
    }

    public ManifestEntry getAlias(String key) {
        ManifestEntry me = new ManifestEntry(key);
        me.attributes = this.attributes;
        me.directives = this.directives;
        me.version = this.version;
        return me;
    }

    public String getDirective(String directive) {
        if (this.directives == null) {
            return null;
        }
        return this.directives.get(directive);
    }

    public String getAttribute(String attribute) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(attribute);
    }
}

