/*
 * Decompiled with CFR 0.152.
 */
package org.olsr.v1.info.api.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.InetAddress;
import org.olsr.v1.info.api.util.CompareUtils;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class JsonInfoHnaEntry
implements Comparable<JsonInfoHnaEntry> {
    private String gateway = "";
    private String destination = "";
    private int destinationPrefixLength = 0;
    private long validityTime = 0L;

    public String getGateway() {
        return this.gateway;
    }

    @JsonProperty(value="gateway")
    public void setGateway(InetAddress gateway) {
        this.gateway = gateway == null ? "" : gateway.getHostAddress();
    }

    public String getDestination() {
        return this.destination;
    }

    @JsonProperty(value="destination")
    public void setDestination(InetAddress destination) {
        this.destination = destination == null ? "" : destination.getHostAddress();
    }

    public int getDestinationPrefixLength() {
        return this.destinationPrefixLength;
    }

    @JsonProperty(value="genmask")
    public void setDestinationPrefixLength(int destinationPrefixLength) {
        this.destinationPrefixLength = destinationPrefixLength;
    }

    public long getValidityTime() {
        return this.validityTime;
    }

    @JsonProperty(value="validityTime")
    public void setValidityTime(long validityTime) {
        this.validityTime = validityTime;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.gateway.hashCode();
        result = 31 * result + this.destination.hashCode();
        result = 31 * result + this.destinationPrefixLength;
        result = 31 * result + (int)(this.validityTime ^ this.validityTime >>> 32);
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.compareTo((JsonInfoHnaEntry)other) == 0;
    }

    @Override
    public int compareTo(JsonInfoHnaEntry other) {
        if (other == null) {
            return -1;
        }
        int result = this.gateway.compareTo(other.gateway);
        if (result != 0) {
            return CompareUtils.clip(result);
        }
        result = this.destination.compareTo(other.destination);
        if (result != 0) {
            return CompareUtils.clip(result);
        }
        result = Integer.compare(this.destinationPrefixLength, other.destinationPrefixLength);
        if (result != 0) {
            return result;
        }
        result = Long.compare(this.validityTime, other.validityTime);
        if (result != 0) {
            return result;
        }
        return 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("JsonInfoHnaEntry [gateway=");
        builder.append(this.gateway);
        builder.append(", destination=");
        builder.append(this.destination);
        builder.append(", destinationPrefixLength=");
        builder.append(this.destinationPrefixLength);
        builder.append(", validityTime=");
        builder.append(this.validityTime);
        builder.append("]");
        return builder.toString();
    }
}

