--[[
# Copyright 2001-2014 Cisco Systems, Inc. and/or its affiliates. All rights
# reserved.
#
# This file contains proprietary Detector Content created by Cisco Systems,
# Inc. or its affiliates ("Cisco") and is distributed under the GNU General
# Public License, v2 (the "GPL").  This file may also include Detector Content
# contributed by third parties. Third party contributors are identified in the
# "authors" file.  The Detector Content created by Cisco is owned by, and
# remains the property of, Cisco.  Detector Content from third party
# contributors is owned by, and remains the property of, such third parties and
# is distributed under the GPL.  The term "Detector Content" means specifically
# formulated patterns and logic to identify applications based on network
# traffic characteristics, comprised of instructions in source code or object
# code form (including the structure, sequence, organization, and syntax
# thereof), and all documentation related thereto that have been officially
# approved by Cisco.  Modifications are considered part of the Detector
# Content.
--]]
--[[
detection_name: Payload Group "353"
version: 4
description: Group of payload detectors.
bundle_description: $VAR1 = {
          'Google G-Suite' => 'Google\'s suite of intelligent apps.',
          'ADP Resource' => 'An ADP payroll solution website.',
          'Beeg' => 'Adult video streaming site.',
          'PopAds' => 'Advertising network specialized in popunders on the Internet.',
          '9Gag' => 'Meme aggregation site.',
          'SuccessFactors' => 'Cloud-based human resources solutions.',
          'Ultimate Software' => 'HR and payroll software.',
          'Mama.cn' => 'A website that communicates knowledge about infants and young children, sharing parenting experiences and family life experiences.',
          'ADP Workforce Now' => 'An ADP payroll solution website.',
          'Baike.com' => 'Social networking site.',
          'Marine Traffic' => 'Real-time information on the movements of ships in harbours and ports.',
          'Xfinity' => 'A US cable television, telephone, & internet services provider.',
          'ADP TotalSource' => 'An ADP payroll solution website.',
          'PopCash' => 'Advertising platform.',
          'Quizlet' => 'Online learning tool.',
          'Steam social networking' => 'Steam social networking traffic.',
          'Naukri.com' => 'Indian job portal.',
          'Manorama' => 'Daily morning newspaper, in Malayalam language.',
          'Nice' => 'Software solutions for call centers.',
          'Avito' => 'Russian online marketplace.',
          'QuickBooks' => 'Intuit online accounting software.',
          'TEEPR' => 'Chinese news site.',
          'Fiesta' => 'Games website.',
          'GoToWebinar' => 'Citrix GoToMeeting service focused on delivering online seminars.',
          'Behance' => 'Showcase for artwork.',
          'ADP GlobalView' => 'An ADP payroll solution website.',
          'Pixiv' => 'Japanese online community for artists.',
          'NowNews' => 'Beirut-based Lebanese news website.',
          'Boom Beach' => 'A web-based game.',
          'Lyft' => 'Transportation network company offering car rides.',
          'Pixnet' => 'Online Taiwanese mobile photo sharing, blogging, and social networking service.',
          'OfferJuice' => 'General offerjuice.me website traffic.',
          'Qiita' => 'Technical knowledge sharing and collaboration platform for programmers.',
          'Walkme' => 'Software-as-a-service company that helps users navigate the features of other web-based services.',
          'Ndtv' => 'Web site of Indian television media company.',
          'Zalo' => 'Free messaging and calling application.',
          'Yle Areena' => 'Finland\'s national public broadcasting company.',
          'Sony LIV' => 'Entertainment media providing Video On Demand services.',
          'Mega' => 'Web site of cloud storage and file hosting service.',
          'Uber' => 'Ride sharing application.',
          'LeadLander' => 'Visiting websites which use LeadLander services to track customers.',
          'CNTV' => 'Chinese online news portal aorund the world.',
          'Albawaba' => 'Middle Eastern news.',
          'U.S State' => 'U.S. Department of State website.',
          'Elisa Viihde' => 'A Finnish telecommunications company.',
          'Souq' => 'An English-Arabic language e-commerce platform.',
          'Onavo' => 'Data management app for iOS and Android.',
          'Viaplay' => 'Video on Demand service which offers films, sports, and TV series.',
          'Clash of Clans' => 'A web-based game.',
          'OneDio' => 'Turkish media platform which provides video, short & funny lists, tests & breaking news.',
          'ResearchGate' => 'A social networking site for scientists and researchers to share papers, ask and answer questions, and find collaborators.',
          'Blogfa' => 'Persian language blogging site.',
          'Youth.cn' => 'A website for the Communist Youth League of China.',
          'MoPub' => 'Mobile ad traffic.',
          'Yemonisoni' => 'Mobile ad traffic.',
          'Oman Airways' => 'Oman Airways official website.',
          '1fichier' => 'Cloud storage service.',
          'GungHo Online Entertainment' => 'A Japanese game developer that produces console and mobile games.',
          'YouTube' => 'A video-sharing website on which users can upload, share, and view videos.',
          'blog.jp' => 'Japanese blogging site.',
          'Nametests' => 'News web site.',
          'Dealertrack' => 'Automobile dealership related Software-as-a-Service.',
          'Watan' => 'An Arabic newspaper.',
          'QuickBase' => 'Intuit business management software.',
          'MS CDN' => 'Traffic relating to Microsoft Azure\'s Content Delivery Network. Traffic going to and from msecnd.net.',
          'ADP Streamline' => 'An ADP payroll solution website.',
          'Taleo' => 'Cloud-based talent management software vendor acquired by Oracle.',
          'PixaBay' => 'Website for sharing high quality public domain photos, illustrations, vector graphics, and film footage.',
          'Paytm' => 'Indian electronic payment and e-commerce company based out of Delhi.',
          'Blackbaud' => 'Fundraising software company.',
          'Cydia' => 'An appstore for jailbroken IOS devices.',
          'Onet' => 'Polish news web portal.',
          'ASKfm' => 'Question and answer themed search engine.',
          'Qatar Ministry of Interior' => 'Qatar Ministry of Interior official website.',
          'MTV3' => 'Finnish commercial television station.',
          'NetSuite' => 'Advertising and marketing services.',
          'Snapchat' => 'Online photo sharing.',
          'Orange' => 'French multinational telecommunications corporation.',
          'Circuit' => 'A Team collaboration tool with messaging, video, document and screen sharing.',
          'Xiaomi' => 'Chinese electronics company which develops and sells smartphones, mobile apps, laptops, and related consumer electronics.',
          'The Sport Bible' => 'Latest sport news website.',
          'Merdeka.com' => 'Indonesian news site.',
          'ADP' => 'Payroll services.',
          'Bukalapak' => 'Online marketplace for retail goods.',
          'Azar Live' => 'Instant messaging and video.',
          'Medium' => 'Online publishing platform.',
          'Cerner Corporation' => 'Health care information systems.',
          'Ghaneely' => 'Music streaming service.',
          'TribunNews' => 'Indonesian news website.',
          'Russia Today' => 'Russian government run news website.',
          'Qatar Airways' => 'Qatar Airways Company official website.',
          'State Bank of India' => 'Internet banking service provided by State Bank of India.'
        };

--]]

require "DetectorCommon"

local DC = DetectorCommon

DetectorPackageInfo = {
    name =  "payload_group_353",
    proto =  DC.ipproto.tcp,
    client = {
        init =  'DetectorInit',
        clean =  'DetectorClean',
        minimum_matches =  1
    }
}

gUrlPatternList = {
    -- Nice
    { 0, 0, 0, 2232, 1, "nice.com", "/", "http:", "", 4661},
    { 0, 0, 0, 2232, 1, "niceincontact.com", "/", "http:", "", 4661},
    { 0, 0, 0, 2232, 1, "nice-incontact.com", "/", "http:", "", 4661},
    { 0, 0, 0, 2232, 1, "incontact.com", "/", "http:", "", 4661},
    -- Walkme
    { 0, 0, 0, 2064, 1, "walkme.com", "/", "http:", "", 4600},
    -- Sony LIV
    { 0, 0, 0, 2067, 1, "sonyliv.com", "/", "http:", "", 4567},
    -- Lyft
    { 0, 0, 0, 2073, 1, "lyft.com", "/", "http:", "", 4566},
    -- Yle Areena
    { 0, 0, 0, 2233, 1, "yle.fi", "/", "http:", "", 4565},
    -- Viaplay
    { 0, 0, 0, 2234, 1, "viaplay.tv", "/", "http:", "", 4564},
    { 0, 0, 0, 2234, 1, "viaplay.com", "/", "http:", "", 4564},
    -- MTV3
    { 0, 0, 0, 2235, 1, "katsomo.fi", "/", "http:", "", 4563},
    { 0, 0, 0, 2235, 1, "mtv.fi", "/", "http:", "", 4563},
    { 0, 0, 0, 2235, 1, "mtv_fi_api.frosomo.com", "/", "http:", "", 4563},
    -- Elisa Viihde
    { 0, 0, 0, 2236, 1, "elisa.fi", "/", "http:", "", 4561},
    -- Watan
    { 0, 0, 0, 2237, 1, "watanserb.com", "/", "http:", "", 4538},
    -- Oman Airways
    { 0, 0, 0, 2238, 1, "omanair.com", "/", "http:", "", 4537},
    -- U.S State
    { 0, 0, 0, 2239, 1, "state.gov", "/", "http:", "", 4532},
    { 0, 0, 0, 2239, 1, "usa.gov", "/", "http:", "", 4532},
    -- Marine Traffic
    { 0, 0, 0, 2240, 1, "marinetraffic.com", "/", "http:", "", 4517},
    -- Xiaomi
    { 0, 0, 0, 2241, 1, "mi.com", "/", "http:", "", 4386},
    { 0, 0, 0, 2241, 1, "appmifile.com", "/", "http:", "", 4386},
    { 0, 0, 0, 2241, 1, "miui.com", "/", "http:", "", 4386},
    -- Youth.cn
    { 0, 0, 0, 2242, 1, "youth.cn", "/", "http:", "", 4383},
    -- Xfinity
    { 0, 0, 0, 2243, 1, "xfinity.com", "/", "http:", "", 4376},
    -- CNTV
    { 0, 0, 0, 2244, 1, "cntv.cn", "/", "http:", "", 4310},
    -- TribunNews
    { 0, 0, 0, 2245, 1, "tribunnews.com", "/", "http:", "", 4301},
    { 0, 0, 0, 2245, 1, "tstatic.net", "/", "http:", "", 4301},
    -- The Sport Bible
    { 0, 0, 0, 2246, 1, "sportbible.com", "/", "http:", "", 4298},
    -- TEEPR
    { 0, 0, 0, 2247, 1, "teepr.com", "/", "http:", "", 4296},
    { 0, 0, 0, 2247, 1, "tamedia.com.tw", "/", "http:", "", 4296},
    -- Taleo
    { 0, 0, 0, 2248, 1, "taleo.net", "/", "http:", "", 4294},
    -- Souq
    { 0, 0, 0, 2249, 1, "souq.com", "/", "http:", "", 4288},
    -- Bukalapak
    { 0, 0, 0, 2250, 1, "bukalapak.com", "/", "http:", "", 4247},
    -- blog.jp
    { 0, 0, 0, 2251, 1, "blog.jp", "/", "http:", "", 4245},
    -- Blogfa
    { 0, 0, 0, 2252, 1, "blogfa.com", "/", "http:", "", 4244},
    -- PopCash
    { 0, 0, 0, 2253, 1, "popcash.net", "/", "http:", "", 4235},
    -- PopAds
    { 0, 0, 0, 2254, 1, "popads.net", "/", "http:", "", 4234},
    -- Pixnet
    { 0, 0, 0, 2255, 1, "pixnet.net", "/", "http:", "", 4233},
    -- Pixiv
    { 0, 0, 0, 2256, 1, "pixiv.net", "/", "http:", "", 4232},
    { 0, 0, 0, 2256, 1, "pixiv.org", "/", "http:", "", 4232},
    { 0, 0, 0, 2256, 1, "pximg.net", "/", "http:", "", 4232},
    { 0, 0, 0, 2256, 1, "ads-pixiv.net", "/", "http:", "", 4232},
    { 0, 0, 0, 2256, 1, "pixiv-recommend.net", "/", "http:", "", 4232},
    -- PixaBay
    { 0, 0, 0, 2257, 1, "pixabay.com", "/", "http:", "", 4231},
    -- Paytm
    { 0, 0, 0, 2258, 1, "paytm.com", "/", "http:", "", 4230},
    { 0, 0, 0, 2258, 1, "getpaytm.com", "/", "http:", "", 4230},
    -- Orange
    { 0, 0, 0, 2259, 1, "orange.com", "/", "http:", "", 4226},
    -- Onet
    { 0, 0, 0, 2260, 1, "onet.pl", "/", "http:", "", 4224},
    -- OneDio
    { 0, 0, 0, 2261, 1, "onedio.co", "/", "http:", "", 4223},
    -- OfferJuice
    { 0, 0, 0, 2262, 1, "offerjuice.me", "/", "http:", "", 4219},
    -- NowNews
    { 0, 0, 0, 2263, 1, "nownews.com", "/", "http:", "", 4216},
    -- Ndtv
    { 0, 0, 0, 2264, 1, "ndtv.com", "/", "http:", "", 4215},
    { 0, 0, 0, 2264, 1, "ndtvimg.com", "/", "http:", "", 4215},
    -- Naukri.com
    { 0, 0, 0, 2265, 1, "naukri.com", "/", "http:", "", 4214},
    -- Nametests
    { 0, 0, 0, 2266, 1, "nametests.com", "/", "http:", "", 4213},
    -- Merdeka.com
    { 0, 0, 0, 2267, 1, "merdeka.com", "/", "http:", "", 4209},
    -- Mega
    { 0, 0, 0, 2268, 1, "mega.co.nz", "/", "http:", "", 4208},
    { 0, 0, 0, 2268, 1, "mega.nz", "/", "http:", "", 4208},
    { 0, 0, 0, 2268, 1, "mega.io", "/", "http:", "", 4208},
    -- Medium
    { 0, 0, 0, 2269, 1, "medium.com", "/", "http:", "", 4207},
    -- Manorama
    { 0, 0, 0, 2270, 1, "manoramaonline.com", "/", "http:", "", 4205},
    -- Mama.cn
    { 0, 0, 0, 2271, 1, "mama.cn", "/", "http:", "", 4204},
    { 0, 0, 0, 2271, 1, "cdnmama.com", "/", "http:", "", 4204},
    -- State Bank of India
    { 0, 0, 0, 2272, 1, "onlinesbi.com", "/", "http:", "", 4202},
    -- Russia Today
    { 0, 0, 0, 2273, 1, "rt.com", "/", "http:", "", 4195},
    -- ResearchGate
    { 0, 0, 0, 2274, 1, "researchgate.net", "/", "http:", "", 4194},
    -- Quizlet
    { 0, 0, 0, 2275, 1, "quizlet.com", "/", "http:", "", 4189},
    -- Qatar Ministry of Interior
    { 0, 0, 0, 2276, 1, "portal.moi.gov.qa", "/", "http:", "", 4187},
    -- Qiita
    { 0, 0, 0, 2277, 1, "qiita.com", "/", "http:", "", 4186},
    -- Qatar Airways
    { 0, 0, 0, 2278, 1, "qatarairways.com", "/", "http:", "", 4182},
    -- Behance
    { 0, 0, 0, 2279, 1, "behance.net", "/", "http:", "", 4180},
    -- Beeg
    { 0, 0, 0, 2280, 1, "beeg.com", "/", "http:", "", 4179},
    -- Baike.com
    { 0, 0, 0, 2281, 1, "baike.com", "/", "http:", "", 4178},
    -- Avito
    { 0, 0, 0, 2282, 1, "avito.ma", "/", "http:", "", 4175},
    -- ASKfm
    { 0, 0, 0, 2283, 1, "ask.fm", "/", "http:", "", 4173},
    -- Albawaba
    { 0, 0, 0, 2284, 1, "albawaba.com", "/", "http:", "", 4172},
    -- 9Gag
    { 0, 0, 0, 2285, 1, "9gag.com", "/", "http:", "", 4167},
    -- 1fichier
    { 0, 0, 0, 2286, 1, "1fichier.com", "/", "http:", "", 4165},
    -- Ghaneely
    { 0, 0, 0, 2287, 1, "binarywaves.com", "/", "http:", "", 4158},
    -- Azar Live
    { 0, 0, 0, 2288, 1, "azarlive.com", "/", "http:", "", 4156},
    -- Uber
    { 0, 0, 0, 2289, 1, "uber.com", "/", "http:", "", 4137},
    -- Google G-Suite
    { 0, 0, 0, 2290, 1, "workspace.google.com", "/", "http:", "", 4126},
    -- Circuit
    { 0, 0, 0, 2291, 1, "circuit.com", "/", "http:", "", 4113},
    -- Cydia
    { 0, 0, 0, 2292, 1, "cydia.com", "/", "http:", "", 4099},
    { 0, 0, 0, 2292, 1, "cydia.saurik.com", "/", "http:", "", 4099},
    -- Clash of Clans
    { 0, 0, 0, 2293, 1, "clashofclans.com", "/", "http:", "", 4095},
    -- Boom Beach
    { 0, 0, 0, 2294, 1, "boombeach.com", "/", "http:", "", 4093},
    -- MoPub
    { 0, 0, 0, 2295, 1, "mopub.com", "/", "http:", "", 4085},
    -- Yemonisoni
    { 0, 0, 0, 2296, 1, "yemonisoni.com", "/", "http:", "", 4083},
    -- Fiesta
    { 0, 0, 0, 2297, 1, "fiesta.gamigo.com", "/", "http:", "", 4077},
    -- Ultimate Software
    { 0, 0, 0, 2298, 1, "ultimatesoftware.com", "/", "http:", "", 3944},
    -- QuickBooks
    { 0, 0, 0, 2299, 1, "quickbooks.intuit.com", "/", "http:", "", 3936},
    { 0, 0, 0, 2299, 1, "quickbooksconnect.com", "/", "http:", "", 3936},
    -- QuickBase
    { 0, 0, 0, 2300, 1, "quickbase.com", "/", "http:", "", 3935},
    -- Dealertrack
    { 0, 0, 0, 2301, 1, "dealertrack.com", "/", "http:", "", 3933},
    -- Cerner Corporation
    { 0, 0, 0, 2302, 1, "cerner.com", "/", "http:", "", 3930},
    -- ADP Workforce Now
    { 0, 0, 0, 2303, 1, "workforcenow.adp.com", "/", "http:", "", 3928},
    -- ADP TotalSource
    { 0, 0, 0, 2304, 1, "totalsource.adp.com", "/", "http:", "", 3926},
    -- ADP Streamline
    { 0, 0, 0, 2305, 1, "streamline.adp.com", "/", "http:", "", 3925},
    -- ADP Resource
    { 0, 0, 0, 2306, 1, "resource-secure.adp.com", "/", "http:", "", 3924},
    -- ADP GlobalView
    { 0, 0, 0, 2307, 1, "globalview.adp.com", "/", "http:", "", 3923},
    -- ADP
    { 0, 0, 0, 2308, 1, "adp.com", "/", "http:", "", 3922},
    -- SuccessFactors
    { 0, 0, 0, 2309, 1, "successfactors.com", "/", "http:", "", 3901},
    -- Onavo
    { 0, 0, 0, 2310, 1, "onavo.com", "/", "http:", "", 3893},
    -- NetSuite
    { 0, 0, 0, 2311, 1, "netsuite.com", "/", "http:", "", 3892},
    -- Blackbaud
    { 0, 0, 0, 2312, 1, "blackbaud.com", "/", "http:", "", 3889},
    -- GungHo Online Entertainment
    { 0, 0, 0, 2313, 1, "gunghoonline.com", "/", "http:", "", 3853},
    { 0, 0, 0, 2313, 1, "gungho.co.jp", "/", "http:", "", 3853},
    -- LeadLander
    { 0, 0, 0, 2314, 1, "leadlander.com", "/", "http:", "", 3821},
    -- MS CDN
    { 0, 0, 0, 2315, 1, "az416426.vo.msecdn.net", "/", "http:", "", 2811},
    { 0, 0, 0, 2315, 1, "msecdn.net", "/", "http:", "", 2811},
    -- GoToWebinar
    { 0, 0, 0, 2316, 1, "gotowebinar.com", "/", "http:", "", 2641},
    -- Steam social networking
    { 0, 0, 0, 2317, 1, "steamcommunity.com", "/", "http:", "", 1155},
    -- YouTube
    { 0, 0, 0, 74, 1, "youtubei.googleapis.com", "/", "http:", "", 929},
    { 0, 0, 0, 74, 1, "yt3.ggpht.com", "/", "http:", "", 929},
    -- Snapchat
    { 0, 0, 0, 2318, 1, "snapchat.com", "/", "http:", "", 1653},
    -- Zalo
    { 0, 0, 0, 2319, 1, "zalo.me", "/", "http:", "", 4662},
    { 0, 0, 0, 2319, 1, "zadn.vn", "/", "http:", "", 4662},
    { 0, 0, 0, 2319, 1, "zdn.vn", "/", "http:", "", 4662},
    { 0, 0, 0, 2319, 1, "zaloapp.com", "/", "http:", "", 4662},
    { 0, 0, 0, 2319, 1, "zalo.zadn.vn", "/", "http:", "", 4662},
}

function DetectorInit(detectorInstance)

    gDetector = detectorInstance;

    if gDetector.addAppUrl then
        for i,v in ipairs(gUrlPatternList) do
            gDetector:addAppUrl(v[1],v[2],v[3],v[4],v[5],v[6],v[7],v[8],v[9],v[10]);
        end
    end
    gUrlPatternList = nil

    return gDetector;
end

function DetectorClean()
end
