--[[
# Copyright 2001-2014 Cisco Systems, Inc. and/or its affiliates. All rights
# reserved.
#
# This file contains proprietary Detector Content created by Cisco Systems,
# Inc. or its affiliates ("Cisco") and is distributed under the GNU General
# Public License, v2 (the "GPL").  This file may also include Detector Content
# contributed by third parties. Third party contributors are identified in the
# "authors" file.  The Detector Content created by Cisco is owned by, and
# remains the property of, Cisco.  Detector Content from third party
# contributors is owned by, and remains the property of, such third parties and
# is distributed under the GPL.  The term "Detector Content" means specifically
# formulated patterns and logic to identify applications based on network
# traffic characteristics, comprised of instructions in source code or object
# code form (including the structure, sequence, organization, and syntax
# thereof), and all documentation related thereto that have been officially
# approved by Cisco.  Modifications are considered part of the Detector
# Content.
--]]
--[[
detection_name: SSL Group "334 part3"
version: 21
description: Group of SSL Host detectors.
bundle_description: $VAR1 = {
          'TMZ' => 'Entertainment news.',
          'ProFlowers' => 'United States\' flower retailer.',
          'Quickflix' => 'DVD rental company based in Australia.',
          'vente-privee.com' => 'Private online shopping club focused on fashion and lifestyle products.',
          'TopTenREVIEWS' => 'Information, Reviews and recommendation about the product.',
          'schuelerVZ' => 'German online classroom / social network.',
          'ClickBank' => 'Online marketplace for Digital products.',
          'Capital One' => 'U.S. based bank holding company.',
          'OpenBSD' => 'Open source code for security, enterprise and server.',
          'Ameba' => 'Japanese blogging and social networking website.',
          'spin.de' => 'German social network and dating site.',
          'CNET TV' => 'Videos on tech and gadget related website.',
          'Comedy Central' => 'Official website of Comedy Central, Television channel.',
          'Blue Nile' => 'Online jewelry and diamonds retailer.',
          'Balatarin' => 'Social bookmarking and community website aimed at an Iranian audience.',
          'Kogan Technologies' => 'Australian retailer of consumer electronic devices.',
          'Baidu Yun' => 'Baidu cloud storage and P2P file transfer.',
          'GOMTV Remote Control' => 'Mobile app that allows for remote control of GOM streaming to a television set or media player.',
          'Naver Mail' => 'Naver webmail.',
          'OsiriX' => 'Image processing tool for DICOM images.',
          'Twitter Link Service' => 't.co, Twitter\'s URL redirect service.',
          'Rhapsody' => 'Online streaming music service.',
          'LinkedIn Contacts' => 'LinkedIn application for networking with contacts.',
          'LiveJournal' => 'Social blogging site.',
          'Forbes' => 'Website for Forbes, a business news magazine.',
          'Fancy' => 'Social media to share and buy items.',
          'The Gap' => 'Clothing and accessories retailer, encompassing Gap, Old Navy, Banana Republic, Piperlime, and Athleta.',
          'Staples' => 'Office supply retailer.',
          'AccuWeather' => 'Weather forecasting website.',
          'Game Front' => 'Gaming news, reviews, cheats, and walkthroughs.',
          'Office Depot' => 'Office supply retailer.',
          'DSW' => 'Designer Shoe Warehouse - branded footwear.',
          'iHeartRadio' => 'Website that provides streaming access to local and digital-only radio stations.',
          'Tianya' => 'Chinese forum for blogging, microblogging and photo album services.',
          'MyWebSearch' => 'Web portal.',
          'Tomatopang' => 'Korean Peer to Peer file-sharing application.',
          'Cox' => 'Telecommunication and wireless service provider.',
          'Crutchfield' => 'Electronics retailer.',
          'Redmine' => 'Web based bug tracking and project management tool.',
          'SugarCRM' => 'Customer relationship management software company.',
          'Tinder' => 'Social Network for connecting people.',
          'Admin5' => 'Chinese directory of web admins.',
          'GOLF.com' => 'News, instruction and courses about Golf.',
          'ShowClix' => 'A full-service ticketing company.',
          'RetailMeNot' => 'Online coupon and deals.',
          'wimp.com' => 'Site that provides links to viral videos.',
          'Costco' => 'Warehouse club\'s online retail website.',
          'Times Union' => 'News local to Albany, New York.',
          'The Hollywood Reporter' => 'News related to the entertainment industry.',
          'WDT' => 'Weather Decision Technologies, a company that provides weather nowcasting apps.',
          'KVOA.com' => 'NBC-affiliated news channel for Tucson, Arizona.',
          'Schwab' => 'Brokerage and banking company.',
          'The Escapist Magazine' => 'Online Magazine for Video game lovers.',
          'TV Guide' => 'Listings and schedules for television programming.',
          'Basecamp' => 'Web based project management tool.',
          'uTorrent' => 'BitTorrent client known for its lightweight and efficient design.',
          'WordReference.com' => 'Online dictionaries, translator and word games.',
          'Kontiki' => 'Cloud based enterprise for video platform.',
          'The Independent' => 'Online portal for UK based and world news.',
          'FTD' => 'Floral retailer.',
          'Pandora TV' => 'Pandora streaming TV service.',
          'Boxnet Upload SSL' => 'Online repository for documents, spreadsheet and presentations.  This app can be detected from decrypted traffic only.',
          'Fox News' => 'Web Portal for news update.',
          'eRecht24' => 'Russian Web portal for all legal related information.',
          'Yellow Pages' => 'Online directory and Mapping services.',
          'SoulSeek' => 'Peer-to-peer network.',
          'Zhihu.com' => 'Chinese Q&A website.',
          'Issuu' => 'Web based document posting and sharing service.',
          'Soku' => 'Youku\'s search engine.',
          'Adtech' => 'Advertisement site.',
          'PerfectIBE' => 'An air travel booking consolidation engine.',
          'Lijit' => 'Advertising and analystics company.',
          'Business Insider' => 'Online news web portal.',
          'StubHub' => 'Website for buying and selling tickets for sports, concerts, and other events.',
          'AutoZone' => 'Automotive parts and accessories retailer.',
          'HostGator' => 'Web hosting portal.',
          'Dictionary.com' => 'Online free dictionary.',
          'Blizzard' => 'The website for Blizzard Software, a popular PC and console game company.',
          'SpeedRunsLive' => 'Online gaming.',
          'Conduit' => 'Online website to create community toolbar.',
          'Alisoft' => 'IT company for wesites design and development.',
          'WTOP' => 'Official web site for WTOP FM.',
          'Cheezburger' => 'Hang-out place for funny Photos and stories.',
          'Sanook.com' => 'Web portal for Entertainment purpose like games, lotery, news and music.',
          'MKRU' => 'News website for the Russian newspaper Moskovskij Komsomolets.',
          'VKontakte' => 'Russian social networking service.',
          'CNBC' => 'Official website for the CNBC channel which is basically meant for Business and Financial market related news.',
          'Western Digital' => 'Data storage company and hard disk drive manufacturers.',
          'The Huffington Post' => 'Online news website.',
          'yfrog' => 'Site for posting and sharing photos and videos on twitter.',
          'Searchnu' => 'Search engine.',
          'Tickets.com' => 'Ticket sales and distribution website for concerts, sports events, etc.',
          'OwnerIQ' => 'Advertisement site.',
          'Sprint' => 'Voice, data and internet service provider.',
          'Viewsurf' => 'French video streaming and download site.',
          'Infusionsoft' => 'Software company providing solutions for sales and marketing.',
          'MapleStory' => 'Online game portal.',
          'The Baltimore Sun' => 'Offcial website for the daily newspaper covering local and regional events in Baltimore.',
          'Swagbucks' => 'Online rewards program.',
          'People.com' => 'Web portal for the Weekly magazine People.',
          'Ganji' => 'Chinese website for classified information.',
          'MyDownloader' => 'Service for downloading files from numerous file hosting sites such as Rapidshare.',
          'USAIP' => 'VPN software.',
          'Feedly' => 'News Aggregator.',
          '2345.com' => 'Web portal.',
          'Renren' => 'Chinese social networking site.',
          'FogBugz' => 'Web-based project management and bug tracking system.',
          '7digital' => 'Digital music and video delivery company.',
          'GoToTraining' => 'Citrix GoToMeeting service focused on online training.',
          'RuneScape' => 'Browser based fantasy role-playing game.',
          'Weibo' => 'Chinese microblogging site produced by Sina.',
          'Jalopnik' => 'Automotive news and information blog.',
          'Blockbuster' => 'Movie and video game rental/streaming website.',
          'BigUpload' => 'File hosting and sharing service.',
          'EarthLink' => 'IT Solution provider for network and communications.',
          'J.C. Penney' => 'Clothing and accessory retailer.',
          'Top Gear' => 'Website for the related British TV series focused on cars.',
          'Weather.gov' => 'Weather web portal.',
          'The Onion' => 'Online humor and news satire site.',
          'HSBC' => 'Global banking and financial services company.',
          'Discover' => 'Financial services company.',
          'DCinside' => 'Internet forum for photography and Digital camera.',
          'Telecom Express' => 'Advertisement site.',
          'RitzCamera.com' => 'Photography goods and electronics retailer.',
          'Playstation.com' => 'Sony Playstation related e-commerce.',
          'news.com.au' => 'News site based in Australia.',
          'Windows Live SkyDrive' => 'Cloud based file hosting service.',
          'Vanguard' => 'Investment management company.',
          'REVOLVEclothing' => 'Designer clothing and accessories retailer.',
          'QQ' => 'Chinese instant messaging software.',
          'BigBlueButton' => 'Web conferencing system.',
          'Level 3' => 'Level 3 Communications content delivery network.',
          'PPTV' => 'Chinese file-streaming app.',
          'Kayak' => 'Online Flight and Hotel reservation/deals website.',
          'SmugMug' => 'Photo sharing website.',
          'Naver Blog' => 'Naver blogging app.',
          'Scribd' => 'Web based document posting and sharing service.',
          'Joomla' => 'Content Management System for building web sites.',
          'Home Depot' => 'Retailer for home improvement and construction goods/products.',
          'FORA.tv' => 'Website hosting videos of live events, lectures, and debates.',
          '2channel' => 'Japan based Internet forum.',
          'FOX' => 'Official website for Fox entertainment.',
          'Associated Press' => 'Official web site for the Associated Press, non-profit news agency.',
          'Hulu' => 'Video streaming.',
          'PayPal' => 'E-commerce website for handling online transactions.',
          'Eclipse Marketplace' => 'Marketplace for Eclipse application.',
          'Liberty Mutual' => 'Insurance company.',
          'NCAA' => 'National Collegiate Athletic Association - non-profit association for athletic programs.',
          'Okurin' => 'Japanese file upload site.',
          'Drugstore.com' => 'Online retailer for health, beauty, and wellness products.',
          'CDiscount' => 'French online retailer.',
          'California.gov' => 'California government official website.',
          'G4' => 'Video game news website to accompany its associated television channel.',
          '126.com' => 'Free webmail system.',
          'AutoTrader.com' => 'Used car listings by owner or dealer.',
          'Hangame' => 'Korean online game portal.',
          'Tiger Direct' => 'Online computer and electronics retailer.',
          'Badoo' => 'Social networking service.',
          'Slacker' => 'Internet radio service.',
          '1&1 Internet' => 'Internet and Domain name service provider.',
          'The New York Times' => 'Newspaper website.',
          'StayFriends' => 'German school focused social network.',
          'Swarovski' => 'Retailer for jewelry and other related luxury products.',
          'ThinkGeek' => 'Clothing, electronics, and gadget retailer tailored towards technology and computer enthusiasts.',
          'B&H Photo Video' => 'Online retailer of cameras.',
          'Bleacher Report' => 'Web Portal for Sports news update.',
          'GameSpy' => 'Video game news, reviews, and previews website.',
          'Gaia Online' => 'Anime themed social networking and forums website.',
          'Nintendo' => 'Content delivery and web traffic from Nintendo, a Japanese company.',
          'Doubleclick' => 'Web advertisement services.',
          'UOL' => 'Brazilian web portal for news and entertainment.',
          'Sky.com' => 'Web portal for news.',
          'Stitcher' => 'Internet radio for news and talk shows.',
          'SFGate' => 'Bay area news portal.',
          'wetpaint entertainment' => 'Television related news and media.',
          'Speedtest' => 'Test the download and upload speed of the internet.',
          'Licorize' => 'Social bookmarking service.',
          'FileDropper' => 'File hosting and sharing service.',
          'Mobile Theory' => 'Advertisement site.',
          'Media Hub' => 'Samsung video store.',
          'CNN.com' => 'Turner Broadcasting System\'s news website.',
          'Mininova' => 'BitTorrent downloads website.',
          'Deezer' => 'Music streaming service based in Paris.',
          'Autoblog' => 'Automobile news and information site.',
          'Showbox' => 'Mobile application providing streaming video content.',
          'Picasa' => 'Google picasa is an image organizer and image viewer for organizing and editing digital photos, plus an integrated photo-sharing website.',
          'VPNReactor' => 'An anonymizer that obfuscates web usage.',
          'Sears' => 'Department store retailer.',
          'Wikia' => 'Web portal to contribute and share the knowledge.',
          'YY' => 'Chinese Chat application.',
          'Zombo.com' => 'Website where you can do anything.',
          'Woot' => 'Online retailer that sells one discount product a day.',
          'Vine' => 'Mobile App for sharing photos and videos clips.',
          'Fidelity' => 'Mutual fund and financial services company.',
          'Orbitz' => 'Internet based travel services company.',
          'Autodesk' => 'A CAD and 3D printing software company.',
          '4399.com' => 'Chinese gaming website.',
          'WhereCoolThingsHappen' => 'Cool places and photos around the world.',
          'theCHIVE' => 'Funny photos and videos.',
          'Lineage' => 'Online game for multiplayer.',
          'Wired.com' => 'Online magazine.',
          'CareerBuilder.com' => 'Online job search portal.',
          'Fetion' => 'Chinese instant messaging client.',
          'Tiffany & Co.' => 'Jewelry and silverware retailer.',
          'Dillards' => 'Retail department store.',
          'Expedia' => 'Travel reservation website.',
          'Federated Media' => 'Advertisement site.',
          'NBC News' => 'NBCUniversal\'s news website.',
          'American Express' => 'Financial services company.',
          'Burnbook' => 'Anonymous messaging app.',
          'ZergNet' => 'Content aggregator for Sci-Fi Article.',
          '51.com' => 'Chinese social networking site.',
          'The Daily Beast' => 'American news reporting and opinion website.',
          'Walgreens' => 'Online Pharmacy in United States.',
          'PNAS' => 'Offical journal from United States National Academy of Sciences.',
          'ProxEasy' => 'Anonymous web based proxy service.',
          'Motorola' => 'Manufacturer of mobile devices and telephony equipment.',
          'Web Of Trust' => 'Community-based website reputation rating tool.',
          'Lord & Taylor' => 'Specialty-retail department store chain.',
          'QDown' => 'Korean Entertainment web portal.',
          'Daum' => 'Popular South Korean web portal.',
          'European Union' => 'Official website for European Union.',
          'Netvibes' => 'Web portal.',
          'L\'equipe.fr' => 'French sports news site.',
          'Millennial Media' => 'Web advertisement services.',
          'Casale' => 'Advertisement site.',
          'Ace Hardware Corporation' => 'Home improvement goods and hardware retailer.',
          'Indeed' => 'The job search engine.',
          'StreetFire' => 'Video portal for Automotive enthusiasts.',
          'OkCupid' => 'Online Dating website.',
          'Nordstrom' => 'Retail department store.',
          'WD softwares Download/Update' => 'Update/Download software provided by western digital.',
          'MegaMeeting' => 'Web based conferencing platform.',
          'Apache Nutch' => 'Open soruce web crawler.',
          'INRIX' => 'Mobile app for Traffic related updates.',
          'SLI Systems' => 'Advertisement site.',
          'Progressive' => 'Insurance company.',
          'Neteller' => 'Website for handling online payments and money transactions.',
          'Aliwangwang' => 'Instant messaging.',
          'Fox Sports' => 'Web Portal for Sports news update.',
          'Dilbert.com' => 'Offcial website for Dilbert, American comic strips.',
          'NPR' => 'National Public Radio - Associates US national radio station to provide news and other programs.',
          'Mibbit' => 'Web based chat client that supports IRC and Twitter.',
          'Neiman Marcus' => 'Luxury retail department store.',
          'Fiverr' => 'E-Commerce site generally for $5.',
          'Pastebin.com' => 'Online whiteboard application.',
          'HootSuite' => 'Social Network management.',
          'OfficeMax' => 'Office supplies retailer.',
          'eHow' => 'Website featuring tutorials on a wide variety of subjects.',
          'Wordpress' => 'An online blogging community.',
          'T Mobile' => 'Telecommunication and phone service provider.',
          'Diigo' => 'Social bookmarking website for storing, sharing, and finding web bookmarks.',
          'Letterpress' => 'Word game for iOS.',
          'Drugs.com' => 'Online pharmacy.',
          'GoToMyPC' => 'PC remote control software.',
          'Realtor.com' => 'Web portal Real Estate.',
          'Twitterrific' => 'Twitter client.',
          'Filemail' => 'File hosting and sharing service.',
          'Rockstar Games' => 'Developer and Publisher of video games.',
          'SOUNDROP' => 'Listen to music online.',
          'Detroit Free Press' => 'News local to Detroit metropolitan area.',
          'AllRecipes' => 'Recipes and cooking guide.',
          'Flexera Software' => 'Software tools for creating packages with compatible to cross platforms.',
          'Patch.com' => 'Local news website.',
          'The Seattle Times' => 'Newspaper with a focus on the Seattle metro area.',
          'Taobao' => 'Chinese online auction and shopping website.',
          'Tvigle' => 'Russian Video syndication website.',
          'CNZZ' => 'Advertisement site.',
          'Funny or Die' => 'Site that presents humorous videos and media.',
          'In.com' => 'Entertainment news and media.',
          'Chosun' => 'News aggregates from BBC in Korean.',
          'Sina Video' => 'Video streaming from Chinese news/social website Sina.',
          'Baidu Movies' => 'Video search engine by Baidu.',
          'Office 365' => 'Traffic generated by MS Office 365 applications and web services.',
          'Black & Decker Corporation' => 'Power tools, hardware, and home improvement products retailer.',
          'Ad Master' => 'Advertisement site.',
          'Etao' => 'Chinese web portal.',
          'Shoplet' => 'Office products retailer.',
          'Zappos' => 'Online shoe and apparel retailer.',
          'iAstrology' => 'Facebook astrology app.',
          'Avaya' => 'Network and Communication solution provider.',
          'CNET' => 'Tech and gadget related news, reviews, and shopping.',
          'Microsoft Azure' => 'Cloud computing by Microsoft.',
          'Aizhan' => 'Chinese web portal.',
          'TIME.com' => 'Webportal for TIME Magazine.',
          'Softonic' => 'Software download site.',
          'CBS Sports' => 'Sports news website.',
          'OpenSUSE' => 'Official website for OpenSUSE, Linux based OS.',
          'Sohu.com' => 'Chinese search engine with other services like games, advertising, etc.',
          'Verizon' => 'Internet, TV and Phone service provider.',
          'MapQuest' => 'Map and Driving service by AOL.',
          'Collider' => 'Movie/Television news, reviews and trailers.',
          'Saks Fifth Avenue' => 'Luxury, high-end specialty store.',
          'Baidu' => 'Chinese Search engine.',
          'NHL.com' => 'The National Hockey League official website.',
          'Acer' => 'Manufacturer of PCs and laptops.',
          'CNET Download' => 'Download of content from CNET.',
          'Neckermann' => 'General goods online retailer.',
          'BBC' => 'Web Portal for news update.',
          'Clubbox' => 'Korean online movie/channel/music.',
          'Kotaku' => 'Video game focused blog.',
          'Guangming Online' => 'Chinese news site.',
          'Nico Nico Douga Video' => 'Nico Nico Douga video streaming.',
          'Wood TV8' => 'Michigan TV news network.',
          'Libsyn' => 'Podcast hosting services.',
          'Bing Maps' => 'Microsoft online mapping and directions service.',
          'Qriocity' => 'Streaming music and video on demand service from Sony.',
          'Songza' => 'Web radio and music streaming service.',
          'Viki' => 'Watch and upload movies, TV shows and music online.',
          'Okta' => 'An enterprise service that manages login credentials in the cloud.',
          'Adify' => 'Advertisement site.',
          'Softpedia' => 'Software download site.',
          'WPS Office' => 'Mobile app for viewing and editing documents, spreadsheet and PPTs.',
          'Livemocha' => 'Language learning community and platform offering free and paid language courses.',
          'Wall Street Journal' => 'Web Portal for news update.',
          'Fnac' => 'International retail chain focused on cultural and electronic products.',
          'Overstock.com' => 'Online discount retailer.',
          'Technorati' => 'Search engine for blogs.',
          'NBC' => 'Official website for NBC\'s Television network.',
          'MyOnlineArcade' => 'Free web based games.',
          'LOVEFiLM' => 'Home video and video game rental service.',
          'POLITICO.com' => 'News portal.',
          'Yahoo! Finance' => 'Yahoo! Stock and finance website.',
          'WarriorForum' => 'Internet Marketing Forums.',
          'Freee TV' => 'International television streaming.',
          'Eset' => 'Eset Antivirus/Security software download and updates.',
          'TD Ameritrade' => 'Online stock brokerage service.',
          'Webhard' => 'Online storage service available in Korean and English.',
          'NIH' => 'National Institute of Health and Human services.',
          'Live365' => 'Internet radio.',
          'Rackspace' => 'Virtual and physical server hosting providers.',
          'Adorama' => 'Online camera retailer.',
          'USA Today' => 'Website for newspaper USA Today.',
          'Commvault' => 'Enterprise data backup and storage management software.',
          'Evony' => 'Browser-based online multiplayer game.',
          'Naver Cafe' => 'Naver forums and social networking.',
          'Yahoo!' => 'Yahoo! and it\'s online services.',
          'Monetate' => 'Advertisement site.',
          'Inbox.com' => 'Free web-based email service provider.',
          'AdSame' => 'Chinese digital marketting platform.',
          'Clear Channel' => 'Aggregates online radio broadcasting.',
          'Apple sites' => 'Apple corporate websites.',
          'MissLee' => 'Korean Instant Messenger.',
          'Afreeca' => 'Video streaming service based in South Korea.',
          'InsightExpress' => 'Analyser for online and Mobile advertisements.',
          'w3schools.com' => 'A web development learning website.',
          'Gizmodo' => 'Blogs about design and technology.',
          'TripAdvisor' => 'Travel services site for information and reviews regarding travel related content.',
          'Yahoo! Toolbar' => 'Yahoo!\'s browser toolbar.',
          'XiTi' => 'Advertising and analytics site.',
          'Trac' => 'Web based bug tracking and project management tool.',
          'City Sports' => 'Sporting goods and athletic apparel retailer.',
          'Cyworld' => 'South Korean social networking service.',
          'RuTube' => 'Russian online video sharing service.',
          'The Blaze' => 'News and Opinion website.',
          'CafeMom' => 'Social networking site targeted towards mothers.',
          'Reuters' => 'News portal.',
          'The Week Magazine' => 'Online new magazine.',
          'AOL Mail' => 'AOL\'s email client and webmail.',
          'MTv' => 'Official website for MTv.',
          'AdNetwork.net' => 'Ad Portal.',
          'Android.com' => 'Android web site.',
          'Djpod' => 'A suite of tools for podcasting.',
          'Menards' => 'Home improvement goods retailer.',
          'Flipkart' => 'India-based shopping site.',
          'Tchibo' => 'German retailer with weekly changing products.',
          'Wolfram Alpha' => 'Online answering for queries from the structred data.',
          'LeTV' => 'Chinese online video portal.',
          'beRecruited' => 'College athletic social networking site.',
          'Cute Overload' => 'Pictures,videos and stories about Animals.',
          'Intuit' => 'Software company for financial and tax related services.',
          'Jubii' => 'Web portal providing search engine, e-mail, and file sharing services.',
          'CheapTickets' => 'Travel services company focused on the leisure market.',
          'ToysRUs' => 'Official website for ToyRUs, which deals with toys.',
          'Livefyre' => 'Real-Time tools for socializing the web-sites.',
          'Chatroulette' => 'Service that pairs random strangers for video chat.',
          'Rona' => 'Hardware, home improvement, and gardening products retailer based in Canada.',
          'Tencent Video' => 'Tencent streaming video.',
          'Game Informer' => 'Video game news, reviews, and previews website.',
          'Cedexis' => 'Advertising and analytics site.',
          'Aweber' => 'Email marketing Service.',
          'Daum Cafe' => 'Daum forums and social networking.',
          'AddThis' => 'Social bookmarking service.',
          'BaiduHi' => 'Baidu instant messaging.',
          'GameTrailers' => 'Video game news, reviews, and previews website.',
          'RealClearPolitics' => 'Political news, opinions and polls website.',
          'ESPN' => 'Online Sports news and show.',
          'FilmOn' => 'Subscription based video on demand and TV streaming service.',
          'Break.com' => 'Web portal for sharing funny videos and pictures.',
          'Aptean' => 'Enterprise software company.',
          'TwitPic' => 'Site for posting and sharing photos and videos on twitter.',
          'Bizrate' => 'Lists best deals for online shopping.',
          'CamerasDirect.com.au' => 'Australian camera and photography gear retailer.',
          'Fuyin.TV' => 'Chinese website for Christians.',
          'Ad Nexus' => 'Web advertisement services.',
          'GameStop' => 'Video game retailer.',
          'Michigan Radio' => 'Public radio serving the American state of Michigan.',
          'Macy\'s' => 'Department store chain.',
          'MovieTickets.com' => 'Webportal for advanced movie ticketing, reviews and celebrity interviews.',
          'Manta' => 'Provides US company profiles and information.',
          '360 Safeguard' => 'Chinese anti-virus software.',
          'Fab.com' => 'E-commerce for all articles.',
          'WorldstarHipHop' => 'Entertainment, hip hop, music videos and blogs.',
          'ServiceNow' => 'Cloud storage provider.',
          'Food Network' => 'Official website for the TV network about food and cooking.',
          'CBS Interactive' => 'Division of CBS Corporation which coordinates ad sales and television programs together.',
          'China News' => 'Chinese news site.',
          'The Sharper Image' => 'General electronics and gifts retailer.',
          'MGID' => 'Service provider for advertising and marketing.',
          'Clip2Net' => 'Yandex cloud storage that acts like a clipboard.',
          '6.pm' => 'Discount shoes and clothing retailer.',
          'Southwest Airlines' => 'Airlines service in United States.',
          'Kohl\'s' => 'Department store/retailer.',
          'eyeReturn' => 'Advertisement site.',
          'IKEA.com' => 'Online storefront for international furniture retailer.',
          'Yesky' => 'Chinese IT portal.',
          'Joystiq' => 'Video gaming blog.',
          'eBay Bid' => 'Bidding in an eBay Auction.',
          'Adweek' => 'Marketing, Media and advertising news.',
          'Ad4mat' => 'Ad site.',
          'Kmart' => 'Discount department store/retailer.',
          'State Farm' => 'Insurance company.',
          'Pinterest' => 'Social photo sharing website.',
          'Livestream' => 'Live streaming video platform.',
          '56.com' => 'Large Chinese video sharing site.',
          'USAA' => 'Insurance company.',
          'NewsNow' => 'News aggregator website that links to thousands of publications.',
          'Best Buy' => 'Website and online retailer for national chain of electronics stores.',
          'Zippyshare' => 'File hosting site.',
          'CheapOAir' => 'Travel booking and price comparison site.',
          'Habbo' => 'Social networking site aimed at teenagers.',
          'Ybrant Digital' => 'Advertisement site.',
          'Bubble Witch Saga' => 'Witch-themed, bubble-bursting Facebook game.',
          'The Pirate Bay' => 'BitTorrent index and search engine.',
          'VLC Media Player' => 'Free and open source media player.',
          'Vonage' => 'Vonage is a VoIP company that provides telephone service via a broadband connection.',
          'Disqus' => 'Company which provides discussion forum features.',
          'Mister Wong' => 'European social bookmarking service.',
          'Weather Underground' => 'Weather web portal.',
          'SimplePie' => 'RSS Feed.',
          'Alibaba' => 'International trade site.',
          'Monster.com' => 'Online job search portal.',
          'The Free Dictionary' => 'Online dictionary aggregator.',
          'AOL' => 'American company develops, grows and invests in brands and web sites.',
          'Skyrock' => 'Social networking site popular in France.',
          'OCLC' => 'Online Computer Library Center - Nonprofit collaboration for providing online public access catalog.',
          'REI' => 'Outdoor sporting clothing and gear retailer.',
          'Moat' => 'Ad search and analystics.',
          'CTV News' => 'News channel by CTV.',
          'The Guardian' => 'Online news portal.',
          'Omegle' => 'Online chat service that pairs together strangers.',
          'Kiwoom' => 'Investment firm.',
          'Daily Mail' => 'Web Portal for news update.',
          'Gateway' => 'Manufacturer and retailer of PCs.',
          'Zol.com.cn' => 'Online website for IT professional.',
          'Youku' => 'Chinese video hosting and sharing service.',
          'Widget Media' => 'Social networking and gaming sites.',
          'Adap.tv' => 'Video advertising service.',
          'Sam\'s Club' => 'Warehouse club\'s online retail site.',
          '39.net' => 'Chinese health information web portal.',
          'Komli Media' => 'Online marketing and advertising.',
          'The Atlantic' => 'News portal.',
          'Craigslist' => 'Popular online classifieds.',
          'BitCoin' => 'Application and website for mining and exchanging BitCoins, a cryptographic currency.',
          'Synology DSM' => 'Synology is a Network Attached Storage (NAS) appliances running Synology\'s DSM Software.',
          'Yandex' => 'Russian search engine.',
          'Freelancer' => 'Site for job listings for temporary work.',
          'Clarizen' => 'Work management and project management system.',
          'People\'s Daily' => 'Chinese news website.',
          'McAfee' => 'McAfee Antivirus/Security software download and updates.',
          'China Daily' => 'Chinese news site.',
          'hi5' => 'Social networking and social gaming platform.',
          'The Hype Machine' => 'MP3 blog aggregator.',
          'Crackle' => 'Digital network providing streaming video content.',
          'Phanfare' => 'Subscription based photo and video sharing service.',
          'Ad Tech' => 'Advertisement site Adtech AG, part of AOL networks.',
          'ShopNBC' => 'General shopping website in association with it\'s related televised shopNBC broadcasts.',
          '247 Inc.' => 'Advertisement site.',
          'OneDrive' => 'Microsoft cloud storage offering, successor to SkyDrive.',
          'WebM Files' => 'Site for sharing videos in webm format.',
          'Netlog' => 'Social networking site geared towards European youth.',
          'Flickr Upload' => 'Online photo management and sharing.',
          'T. Rowe Price' => 'Public investment firm.',
          '1-800-Flowers' => 'Online retailer of flowers and other gifts.',
          'Messenger' => 'Facebook\'s standalone messenger app.',
          'Ad Mob' => 'Web advertisement services.',
          'Bejeweled Blitz' => 'Facebook version of Bejeweled 2.',
          'Blackberry sites' => 'Website for RIM\'s smartphone.',
          'Grantland' => 'Web portal for sports news by ESPN.',
          'Show My Weather' => 'Weather forecast site.',
          '33Across' => 'Social ad delivery service.',
          'Picsearch' => 'Image search engine.',
          'Neustar Information Services' => 'Advertisement site.',
          'Stack Overflow' => 'Question and Answering site for programmers.',
          'Al Jazeera' => 'News network based in the Arab world.',
          'Babelgum' => 'Internet TV service.',
          'Newegg' => 'Computer hardware and software retailer.',
          'Tuenti' => 'Invite only social networking website based in Spain.',
          'Space.com' => 'Provides news related to Space and Astronomy.',
          'Gyao' => 'Video streaming website by Yahoo! Japan.',
          'PC Connection' => 'Computer and electronic products retailer.',
          'Travelocity' => 'Online travel agency.',
          'About.com' => 'A site that provides original information on various subjects.',
          'InSkin Media' => 'Advertisement site.',
          'Goodreads' => 'Book review and cataloging.',
          'Disney' => 'Official Disney website.',
          'CarMax' => 'New and used car retailer.',
          'E! Online' => 'Online entertainment news.',
          'Wretch' => 'Taiwanese community website.',
          'USPS' => 'US Postal Service website.',
          'Adobe Analytics' => 'Traffic going to Adobe Analytics websites such as scene7.com, demdex.net, omtrdc.net, and 2o7.net.',
          'Fileguri' => 'Korean file sharing web site.',
          'Stanford University' => 'Official website for Stanford University, Educational Institute.',
          'NextBus' => 'Live updates on public transit system.',
          'Y8' => 'Internet gaming website.',
          'TypePad' => 'Blogging service website.',
          'Zales' => 'Jewelry retailer.',
          'Vimeo' => 'Website for viewing and sharing videos.',
          'De Telegraaf' => 'Dutch daily newspaper site.',
          'AMD' => 'A manufacturer or PC chipsets.',
          'Voyages-sncf.com' => 'Travel agency website.',
          'LiveStrong.com' => 'Health and fitness information.',
          'China.com' => 'Chinese social networking site.',
          'ESTsoft' => 'Provides software tools and online games.',
          'Adobe Software' => 'Adobe software and updates.',
          'Delta Search' => 'A search engine, with a toolbar that is commonly installed by mistake.',
          'VoiceFive' => 'Advertisement site.',
          'SUPERAntiSpyware' => 'Antivirus / antimalware application.',
          'Bejeweled Chrome Extension' => 'Bejeweled for the Chrome browser.',
          'Newser' => 'Online new portal.',
          'Wachovia' => 'Financial services company.',
          'Publishers Clearing House' => 'Online marketing company.',
          'AOL Games' => 'Online games on AOL.com.',
          'OverBlog' => 'Platform to create blogs.',
          'Glype' => 'Web-based proxy.',
          'Proxistore' => 'Advertising and analytics site.',
          'Salesforce.com Live Agent' => 'Salesforce.com\'s live chat support service.',
          'Tudou' => 'Popular Chinese video sharing website.',
          'Engadget' => 'E-commerce for gadgets and electronics.',
          'EA Games' => 'Web portal for Electronics Arts, a video games distributor.',
          'Nate' => 'Web portal and Search engine.',
          'VTunnel' => 'Web based proxy service.',
          'studiVZ' => 'German online classroom / social network.',
          'Exponential Interactive' => 'Advertisement site.',
          'Zmags' => 'Digital publisher for branded products to customer.',
          'SHOWTIME ANYTIME' => 'On-Demand access for Showtime series, movies and other entertainments.',
          'Car and Driver' => 'American automotive enthusiast news site.',
          'Amazon' => 'Online retailer of books and most other goods.',
          'Netease' => 'Chinese web portal.',
          'Nintendo WFC' => 'Nintendo Wi-Fi Connection, online multiplayer gaming service for Nintendo Wii and DS.',
          'WhitePages Inc' => 'Business and People\'s Contact directory in United States.',
          'Soso' => 'Chinese search engine.',
          'QVC' => 'General shopping website in association with its related televised QVC broadcasts.',
          'NFL.com' => 'American football news.',
          'Cabal Online' => 'Online multiplayer games.',
          'Naver' => 'Web portal.',
          'Jamendo' => 'Website that allows for the streaming, downloading, and uploading of free music.',
          'Indiatimes' => 'Online news portal.',
          'PPStream' => 'Chinese video streaming software.',
          'Haiku Learning Systems' => 'Online tool for teaching and learning.',
          'Ustream.tv' => 'Video streaming and sharing.',
          'Mashable' => 'News  blog website for social network and new technology.',
          'Ancestry.com' => 'Online family history resource.',
          'Wimbledon' => 'Tennis related website.',
          '4chan' => 'Website that hosts found images and discussions on them.',
          'Linux Mint' => 'Linux based Operating System.',
          'Yahoo! Douga' => 'Yahoo! Japan video streaming site.',
          'Phoca' => 'Software components useful for web design.',
          'XM Radio Online' => 'Streaming audio.',
          'Biography.com' => 'Stories, biographies about people.',
          'Amobee' => 'Advertisement site.',
          'Lowe\'s' => 'Home improvement and appliance retailer.',
          'Adblade' => 'Advertising platform.',
          'Bloomingdales' => 'Retail department store.',
          'BitTorrent' => 'A peer-to-peer file sharing protocol used for transferring large amounts of data.',
          'Coupons.com' => 'An online coupons and deals website.',
          'Bluefly' => 'Online fashion retailer.',
          'Douban' => 'Chinese social networking service.',
          'Napster' => 'Audio streaming and MP3 store.',
          'Newsvine' => 'Community based collaborative news website.',
          'Tesco.com' => 'General E-commerce website.',
          'Intel' => 'Computer chip builder.',
          'myUdutu' => 'Online course authoring tool.',
          'Wow' => 'A search engine.',
          'House of Fraser' => 'British department store.',
          'Ticketmaster' => 'Ticket sales and distribution website for concerts, sports events, etc.',
          'Library of Congress' => 'Online collection of American history memories and culture.',
          'MetaFilter' => 'Community weblog for link sharing.',
          'Snort.org' => 'An open source for Network intrusion prevention system.',
          'MobiTV' => 'A content aggregation company focusing on video.',
          'Kay Jewelers' => 'Retail jeweller.',
          'IMDB' => 'Movie information, reviews and previews.',
          'Investopedia' => 'A wiki focused on information related to investments.',
          'VeriSign' => 'SSL Certificates provider.',
          'Weebly' => 'Free, online website creation tool.',
          'Washington Times' => 'Official web site for the Washington times news portal.',
          'Eclipse Updates' => 'Software Updates for Eclipse.',
          'Xunlei Kankan' => 'Chinese webportal for video-on-demand service.',
          'Examiner.com' => 'News portal.',
          'ESPN Video' => 'Video streaming on ESPN.',
          'PubNub' => 'Cloud-based system for apps that require data to be pushed in real time.',
          'CloudMe' => 'Web desktop service.',
          'Goal' => 'Football news and statistics.',
          'MKRU Streaming' => 'Live streaming for the Russian newspaper Moskovskij Komsomolets.',
          'Nike' => 'Shoe and sports apparel manufacturer.'
        };

--]]

require "DetectorCommon"


local DC = DetectorCommon

DetectorPackageInfo = {
    name =  'ssl_host_group_334_part3',
    proto =  DC.ipproto.tcp,
    client = {
        init =  'DetectorInit',
        clean =  'DetectorClean',
        minimum_matches =  1
    }
}

gSSLHostPatternList = {
    -- ProxEasy
    { 0, 1001, 'proxeasy.com' },
    -- Qriocity
    { 0, 1002, 'qriocity.com' },
    -- RuneScape
    { 0, 1003, 'runescape.com' },
    -- Scribd
    { 0, 1005, 'scribd.com' },
    -- Songza
    { 0, 1006, 'songza.com' },
    -- Tudou
    { 0, 1014, 'tudou.com' },
    -- Tuenti
    { 0, 1016, 'tuenti.com' },
    -- VKontakte
    { 0, 1018, 'vk.com' },
    { 0, 1018, 'vkontakte.ru' },
    -- VTunnel
    { 0, 1019, 'vtunnel.com' },
    -- Webhard
    { 0, 1020, 'webhard.co.kr' },
    { 0, 1020, 'webhard.net' },
    -- Weibo
    { 0, 1022, 'weibo.com' },
    -- BigUpload
    { 0, 1027, 'bigupload.com' },
    -- Clarizen
    { 0, 1028, 'clarizen.com' },
    -- 56.com
    { 0, 1031, '56.com' },
    -- 51.com
    { 0, 1032, '51.com' },
    -- Youku
    { 0, 1033, 'youku.com' },
    -- Crackle
    { 0, 1034, 'crackle.com' },
    -- RuTube
    { 0, 1035, 'rutube.ru' },
    -- Afreeca
    { 0, 1037, 'afreeca.com' },
    { 0, 1037, 'afreecatv.com' },
    { 0, 1037, 'bizafreeca.com' },
    -- Babelgum
    { 0, 1038, 'babelgum.com' },
    -- Phanfare
    { 0, 1046, 'phanfare.com' },
    -- FilmOn
    { 0, 1048, 'filmon.com' },
    -- Mibbit
    { 0, 1049, 'mibbit.com' },
    -- BigBlueButton
    { 0, 1050, 'bigbluebutton.org' },
    -- MegaMeeting
    { 0, 1052, 'megameeting.co' },
    -- Badoo
    { 0, 1053, 'badoo.com' },
    -- CloudMe
    { 0, 1055, 'cloudme.com' },
    -- Skyrock
    { 0, 1057, 'skyrock.com' },
    -- Jubii
    { 0, 1060, 'jubii.dk' },
    -- TwitPic
    { 0, 1063, 'twitpic.com' },
    -- yfrog
    { 0, 1064, 'yfrog.com' },
    -- hi5.com
    { 0, 1066, 'hi5.com' },
    -- Livemocha
    { 0, 1067, 'livemocha.com' },
    -- Slacker
    { 0, 1068, 'slacker.com' },
    -- Douban
    { 0, 1069, 'douban.com' },
    -- Gaia Online
    { 0, 1071, 'gaiaonline.com' },
    -- AutoZone
    { 0, 1073, 'autozone.com' },
    -- Tesco.com
    { 0, 1077, 'tesco.com' },
    -- 4chan
    { 0, 1079, '4chan.org' },
    -- Rhapsody
    { 0, 1081, 'rhapsody.com' },
    -- Balatarin
    { 0, 1082, 'balatarin.com' },
    -- PC Connection
    { 0, 1109, 'pcconnection.com' },
    -- CafeMom
    { 0, 1129, 'cafemom.com' },
    -- Mininova
    { 0, 1133, 'mininova.org' },
    -- PayPal
    { 0, 1134, 'paypal.com' },
    -- Pinterest
    { 0, 1135, 'pinimg.com' },
    -- The Pirate Bay
    { 0, 1136, 'pirate-proxy.com' },
    { 0, 1136, 'pirateproxy.click' },
    { 0, 1136, 'proxybay.me' },
    { 0, 1136, 'proxybay.nl' },
    { 0, 1136, 'quluxingba.info' },
    { 0, 1136, 'thepiratebayorg.org' },
    { 0, 1136, 'tpb.herokuapp.com' },
    { 0, 1136, 'tpb.torrentproxy.nl' },
    { 0, 1136, 'tpbproxy.me' },
    { 0, 1136, 'tpbunion.com' },
    -- Technorati
    { 0, 1137, 'technorati.com' },
    -- TypePad
    { 0, 1139, 'typepad.com' },
    -- Bubble Witch Saga
    { 0, 1159, 'bubblewitch.king.com' },
    -- About.com
    { 0, 1167, 'about.com' },
    -- CNET
    { 0, 1170, 'cnet.com' },
    -- CNET Download
    { 0, 1171, 'download.cnet.com' },
    -- w3schools.com
    { 0, 1180, 'w3schools.com' },
    -- Weebly
    { 0, 1181, 'weebly.com' },
    { 0, 1181, 'weeblyimages1.com' },
    -- Apple sites
    { 0, 1185, 'imacstore.com' },
    -- CNN.com
    { 0, 1190, 'cnn-f.akamaihd.net' },
    { 0, 1190, 'cnnchile.com' },
    { 0, 1190, 'cnnios-f.akamaihd.net' },
    { 0, 1190, 'cnnmexico.com' },
    -- IMDB
    { 0, 1191, 'imdb.com' },
    -- BC News
    { 0, 1192, 'msnbc.com' },
    -- Dictionary.com
    { 0, 1195, 'dictionary.com' },
    { 0, 1195, 'dictionary.reference.com' },
    -- Bing Maps
    { 0, 1197, 'maps.bing.com' },
    -- 126.com
    { 0, 1206, '126.com' },
    -- 39.net
    { 0, 1207, '39.net' },
    -- Aizhan
    { 0, 1208, 'aizhan.com' },
    -- tease
    { 0, 1222, 'netease.com' },
    -- Soku
    { 0, 1226, 'soku.com' },
    -- Bejeweled Chrome Extension
    { 0, 1229, 'bejeweled.popcap.com' },
    { 0, 1229, 'gats.popcap.com' },
    -- iAstrology
    { 0, 1238, 'horoscope.s3.amazonaws.com' },
    -- Bejeweled Blitz
    { 0, 1252, 'labs.popcap.com' },
    { 0, 1256, '4399.cn' },
    { 0, 1256, '4399.com' },
    -- Admin5
    { 0, 1258, 'admin5.com' },
    -- Wretch
    { 0, 1262, 'wretch.cc' },
    { 0, 1263, 'y8.com' },
    -- The New York Times
    { 0, 1299, 'nyt.com' },
    -- Twitter Link Service
    { 0, 1300, 't.co' },
    -- Yahoo! Finance
    { 0, 1301, 'finance.yahoo.com' },
    -- Ad Mob
    { 0, 1307, 'admob.com' },
    -- ver
    { 0, 1309, 'naver.jp' },
    { 0, 1309, 'naver.net' },
    -- Doubleclick
    { 0, 1313, 'doubleclick.com' },
    -- Ad Nexus
    { 0, 1314, 'ib.adnxs.com' },
    -- Pandora TV
    { 0, 1327, 'pandora.tv' },
    -- eBay Bid
    { 0, 133, 'offer.befr.ebay.be' },
    { 0, 133, 'offer.benl.ebay.be' },
    { 0, 133, 'offer.ebay.at' },
    { 0, 133, 'offer.ebay.ca' },
    { 0, 133, 'offer.ebay.ch' },
    { 0, 133, 'offer.ebay.co.uk' },
    { 0, 133, 'offer.ebay.com.au' },
    { 0, 133, 'offer.ebay.com.hk' },
    { 0, 133, 'offer.ebay.com.my' },
    { 0, 133, 'offer.ebay.com.sg' },
    { 0, 133, 'offer.ebay.com' },
    { 0, 133, 'offer.ebay.de' },
    { 0, 133, 'offer.ebay.es' },
    { 0, 133, 'offer.ebay.fr' },
    { 0, 133, 'offer.ebay.ie' },
    { 0, 133, 'offer.ebay.in' },
    { 0, 133, 'offer.ebay.it' },
    { 0, 133, 'offer.ebay.nl' },
    { 0, 133, 'offer.ebay.ph' },
    { 0, 133, 'offer.ebay.pl' },
    -- USA Today
    { 0, 1335, 'usatoday.com' },
    -- Millennial Media
    { 0, 1337, 'ads.mp.mydas.mobi' },
    { 0, 1337, 'millennialmedia.com' },
    -- Weather Underground
    { 0, 1338, 'wunderground.com' },
    { 0, 1338, 'wxug.com' },
    -- Clubbox
    { 0, 1340, 'clubbox.co.kr' },
    -- Kiwoom
    { 0, 1341, 'kiwoom.com' },
    -- DCinside
    { 0, 1342, 'dcinside.com' },
    -- te
    { 0, 1343, 'nate.com' },
    -- Fileguri
    { 0, 1344, 'fileguri.com' },
    -- Baidu
    { 0, 1345, 'baidu.com' },
    { 0, 1345, 'bdstatic.com' },
    -- How
    { 0, 1363, 'ehow.com' },
    -- ESPN
    { 0, 1364, 'espncdn.com' },
    { 0, 1364, 'espn.com' },
    -- Fox News
    { 0, 1366, 'foxnews-f.akamaihd.net' },
    { 0, 1366, 'foxnews.com' },
    { 0, 1366, 'foxnews.demdex.net' },
    -- Weather.gov
    { 0, 1368, 'weather.gov' },
    -- The Huffington Post
    { 0, 1370, 'huffingtonpost.co.uk' },
    -- Conduit
    { 0, 1375, 'getu.com' },
    -- BBC
    { 0, 1376, 'bbc.co.uk' },
    { 0, 1376, 'bbc.com' },
    { 0, 1376, 'cbeebies.com' },
    { 0, 1376, 'feeds.bbci.co.uk' },
    -- Indeed
    { 0, 1378, 'indeed.com' },
    -- Publishers Clearing House
    { 0, 1379, 'pch.com' },
    -- Aweber
    { 0, 1381, 'aweber.com' },
    -- Fox Sports
    { 0, 1382, 'foxsports.com' },
    -- Searchnu
    { 0, 1383, 'searchnu.com' },
    -- Wall Street Journal
    { 0, 1390, 'fins.com' },
    { 0, 1390, 'smartmoney.com' },
    -- Daily Mail
    { 0, 1391, 'dailymail.co.uk' },
    -- Taobao
    { 0, 1399, 'taobao.com' },
    -- Engadget
    { 0, 1401, 'engadget.com' },
    -- Eclipse Updates
    { 0, 1412, 'download.eclipse.org' },
    -- Eclipse Marketplace
    { 0, 1414, 'marketplace.eclipse.org' },
    -- AOL
    { 0, 1419, 'aol.co.uk' },
    { 0, 1419, 'aol.ie' },
    { 0, 1419, 'aol.in' },
    { 0, 1419, 'aol.sg' },
    -- AdNetwork.net
    { 0, 1425, 'adnetwork.net' },
    -- Wolfram Alpha
    { 0, 1429, 'wolframalpha.com' },
    -- Eset
    { 0, 143, 'eset.eu' },
    { 0, 143, 'eset.sk' },
    -- VeriSign
    { 0, 1458, 'verisign.com' },
    -- CBS Sports
    { 0, 1459, 'cbssports.com' },
    -- InsightExpress
    { 0, 1461, 'ad.insightexpressai.com' },
    { 0, 1461, 'insightexpress.com' },
    -- Monster.com
    { 0, 1481, 'monster.com' },
    -- MapQuest
    { 0, 1482, 'mapquest.com' },
    -- Swagbucks
    { 0, 1483, 'swagbucks.com' },
    -- Verizon
    { 0, 1484, 'verizon.com' },
    { 0, 1484, 'verizon.net' },
    -- Wikia
    { 0, 1485, 'a.wikia-beacon.com' },
    { 0, 1485, 'wikia.com' },
    { 0, 1485, 'wikia.nocookie.net' },
    -- TMZ
    { 0, 1486, 'tmz.com' },
    -- HootSuite
    { 0, 1489, 'hootsuite.com' },
    -- Coupons.com
    { 0, 1490, 'coupons.com' },
    -- CareerBuilder.com
    { 0, 1491, 'careerbuilder.com' },
    { 0, 1491, 'icbdr.com' },
    -- Fiverr
    { 0, 1493, 'fiverr.com' },
    { 0, 1493, 'fiverrcdn.com' },
    -- AllRecipes
    { 0, 1496, 'allrecipes.com' },
    -- Yellow Pages
    { 0, 1497, 'yp.com' },
    -- Bleacher Report
    { 0, 1498, 'bleacherreport.com' },
    { 0, 1498, 'bleacherreport.net' },
    -- Stack Overflow
    { 0, 1499, 'stackoverflow.com' },
    -- Ancestry.com
    { 0, 1501, 'ancestry.com' },
    -- Business Insider
    { 0, 1505, 'businessinsider.com' },
    -- People.com
    { 0, 1506, 'peoplestylewatch.com' },
    --{ 0, 1506, 'timeinc.net' },
    -- Reuters
    { 0, 1507, 'reuters.com' },
    { 0, 1507, 'reutersmedia.com' },
    -- California.gov
    { 0, 1509, 'ca.gov' },
    -- Southwest Airlines
    { 0, 1510, 'southwest.com' },
    { 0, 1510, 'southwestairlines.tt.omtrdc.net' },
    -- IH
    { 0, 1511, 'nih.gov' },
    -- WhitePages Inc
    { 0, 1512, 'whitepages.com' },
    -- MGID
    { 0, 1513, 'mgid.com' },
    -- EarthLink
    { 0, 1514, 'earthlink.net' },
    { 0, 1514, 'earthlinkbusiness.com' },
    -- Disney
    { 0, 1515, 'disney.co.uk' },
    { 0, 1515, 'disney.com' },
    { 0, 1515, 'disneyinternational.com' },
    -- POLITICO.com
    { 0, 1516, 'politico.com' },
    -- Examiner.com
    { 0, 1518, 'examiner.com' },
    -- RetailMeNot
    { 0, 1519, 'retailmenot.com' },
    { 0, 1519, 'rmncdn.com' },
    -- AddThis
    { 0, 1520, 'addthis.com' },
    -- OkCupid
    { 0, 1522, 'okccdn.com' },
    { 0, 1522, 'okcimg.com' },
    { 0, 1522, 'okcupid.com' },
    -- Patch.com
    { 0, 1523, 'patch.com' },
    -- Realtor.com
    { 0, 1525, 'realtor.com' },
    -- Intuit
    { 0, 1526, 'intuit.com' },
    { 0, 1526, 'intuitstatic.com' },
    -- The Blaze
    { 0, 1527, 'gbtv.com' },
    { 0, 1527, 'theblaze.com' },
    -- HostGator
    { 0, 1528, 'hostgator.com' },
    -- Food Network
    { 0, 1529, 'foodnetwork.com' },
    -- ClickBank
    { 0, 1530, 'clickbank.com' },
    -- Cox
    { 0, 1531, 'cox.com' },
    { 0, 1531, 'cox.net' },
    -- Mashable
    { 0, 1532, 'mshcdn.com' },
    -- AccuWeather
    { 0, 1533, 'accuweather.com' },
    -- Sprint
    { 0, 1534, 'sprint.com' },
    -- Goodreads
    { 0, 1535, 'goodreads.com' },
    -- LiveStrong.com
    { 0, 1536, 'livestrong.com' },
    -- RealClearPolitics
    { 0, 1537, 'realclearpolitics.com' },
    -- Manta
    { 0, 1538, 'manta.com' },
    -- CNBC
    { 0, 1540, 'cnbc.com' },
    -- Widget Media
    { 0, 1541, 'widgetmedia.net' },
    -- Inbox.com
    { 0, 1542, 'inbox.com' },
    -- teller
    { 0, 1544, 'neteller.com' },
    -- T Mobile
    { 0, 1545, 'tmobile.com' },
    { 0, 1545, 'tmobile.tt.omtrdc.net' },
    -- Walgreens
    { 0, 1546, 'walgreens.com' },
    -- WorldstarHipHop
    { 0, 1547, 'worldstarhiphop.com' },
    -- PR
    { 0, 1548, 'npr.org' },
    -- Kayak
    { 0, 1549, 'kayak.com' },
    -- ToysRUs
    { 0, 1550, 'trus.imageg.net' },
    -- Sohu.com
    { 0, 1552, 'sohu.com' },
    -- 1&1 Internet
    { 0, 1553, '1and1.com' },
    -- Ameba
    { 0, 1554, 'ameba.jp' },
    -- Avaya
    { 0, 1555, 'avaya.com' },
    -- Snort.org
    { 0, 1557, 'snort.org' },
    -- Disqus
    { 0, 1558, 'disqus.com' },
    -- Infusionsoft
    { 0, 1559, 'infusionsoft.com' },
    -- Alisoft
    { 0, 1561, 'alisoft.net' },
    -- Salesforce.com Live Agent
    { 0, 1562, 'liveagentforsalesforce.com' },
    -- Fab.com
    { 0, 1567, 'fab.com' },
    -- GoToMyPC
    { 0, 1598, 'gotomypc.com' },
    -- USPS
    { 0, 1601, 'uspspostalone.com' },
    -- FogBugz
    { 0, 161, 'fogbugz.com' },
    -- Yandex
    { 0, 1616, 'yandex.net' },
    -- The Guardian
    { 0, 1618, 'guardiannews.com' },
    -- WarriorForum
    { 0, 1622, 'warriorforum.com' },
    -- Indiatimes
    { 0, 1623, 'indiatimes.com' },
    -- UOL
    { 0, 1626, 'imguol.com' },
    { 0, 1626, 'jsuol.com' },
    -- LeTV
    { 0, 1650, 'letv.com' },
    -- Tianya
    { 0, 1651, 'tianya.cn' },
    { 0, 1651, 'tianyaui.com' },
    -- YY
    { 0, 1663, 'hiido.cn' },
    { 0, 1663, 'hiido.com' },
    { 0, 1663, 'yy.com' },
    -- Fancy
    { 0, 1668, 'thefancy.s3.amazonaws.com' },
    -- Flexera Software
    { 0, 1676, 'flexerasoftware.com' },
    { 0, 1676, 'installshield.com' },
    -- OsiriX
    { 0, 1677, 'osirix-viewer.com' },
    -- SOUNDROP
    { 0, 1695, 'soundrop.fm' },
    -- Vine
    { 0, 1700, 'vines.s3.amazonaws.com' },
    -- Linux Mint
    { 0, 1707, 'linuxmint.com' },
    -- Playstation.com
    { 0, 1754, 'playstation.com' },
    -- VLC Media Player
    { 0, 1756, 'videolan.org' },
    -- Bizrate
    { 0, 1782, 'bizrate.com' },
    -- Cute Overload
    { 0, 1784, 'cuteoverload.com' },
    { 0, 1784, 'cuteoverload.files.wordpress.com' },
    -- Cheezburger
    { 0, 1785, 'cheezburger.com' },
    -- theCHIVE
    { 0, 1788, 'cdn.thechivemobile.com.edgesuite.net' },
    { 0, 1788, 'chivethethrottle.files.wordpress.com' },
    { 0, 1788, 'shechive.files.wordpress.com' },
    { 0, 1788, 'theberry.com' },
    { 0, 1788, 'thebrigade.com' },
    { 0, 1788, 'thechive.com' },
    { 0, 1788, 'thethrottle.thechive.com' },
    -- ZergNet
    { 0, 1790, 'zergnet.com' },
    -- WhereCoolThingsHappen
    { 0, 1791, 'wherecoolthingshappen.com' },
    -- Feedly
    { 0, 1799, 'feedly.com' },
    -- MTv
    { 0, 1805, 'mtv.com' },
    { 0, 1805, 'mtvn.demdex.net' },
    { 0, 1805, 'mtvnimages.com' },
    -- PubNub
    { 0, 1822, 'pubnub.com' },
    -- Nintendo WFC
    { 0, 1826, 'nintendowifi.net' },
    -- BC
    { 0, 1988, 'nbcdotcom-f.akamaihd.net' },
    { 0, 1988, 'nbcudigitaladops.com' },
    { 0, 1988, 'nbcuni.com' },
    { 0, 1988, 'nbcustr.netmng.com' },
    { 0, 1988, 'nbcvod-i.akamaihd.net' },
    -- Space.com
    { 0, 1990, 'space.com' },
    -- Zmags
    { 0, 1994, 'zmags.app4.hubspot.com' },
    -- ESTsoft
    { 0, 1996, 'estsoft.com' },
    -- Cabal Online
    { 0, 1997, 'cabal.estgames.com' },
    { 0, 1997, 'cabalsea.com' },
    -- Biography.com
    { 0, 2002, 'biography.com' },
    { 0, 2002, 'biography.disqus.com' },
    -- Comedy Central
    { 0, 2004, 'cc.com' },
    { 0, 2004, 'colbertnation.com' },
    { 0, 2004, 'colbertnation.mtvnimages.com' },
    { 0, 2004, 'comedycentral.com' },
    { 0, 2004, 'jokes.com' },
    { 0, 2004, 'jokes.mtvnimages.com' },
    { 0, 2004, 'thedailyshow.com' },
    { 0, 2004, 'thedailyshow.mtvnimages.com' },
    { 0, 2004, 'viacomedycentral.112.2o7.net' },
    -- Wired.com
    { 0, 2005, 'wiredinsider.tumblr.com' },
    { 0, 2005, 'wiredopinion.disqus.com' },
    -- E! Online
    { 0, 2006, 'eonline.com' },
    -- HL.com
    { 0, 2007, 'nhl.cdnllnwnl.neulion.net' },
    -- TopTenREVIEWS
    { 0, 2016, 'toptenreviews.com' },
    -- Adweek
    { 0, 2017, 'adweek.com' },
    { 0, 2017, 'adweekmedia.disqus.com' },
    -- The Week Magazine
    { 0, 2018, 'theweekus.disqus.com' },
    -- wser
    { 0, 2020, 'newser.com' },
    -- FOX
    { 0, 2050, 'fbchdvod-f.akamaihd.net' },
    { 0, 2050, 'fox.com' },
    { 0, 2050, 'foxnet.demdex.net' },
    { 0, 2050, 'foxnetworks.tt.omtrdc.net' },
    -- Washington Times
    { 0, 2051, 'washingtontimes.com' },
    { 0, 2051, 'washtimes.com' },
    { 0, 2051, 'washtimes.disqus.com' },
    -- xtBus
    { 0, 2052, 'nextbus.com' },
    -- OpenBSD
    { 0, 2053, 'openbsd.com' },
    { 0, 2053, 'openbsd.org' },
    -- Associated Press
    { 0, 2054, 'ap.org' },
    -- WTOP
    { 0, 2055, 'wtop.com' },
    -- OpenSUSE
    { 0, 2056, 'opensuse.com' },
    -- NCAA
    { 0, 2058, 'ncaa.com' },
    { 0, 2058, 'ncaa.org' },
    -- DSW
    { 0, 2059, 'dsw.112.2o7.net' },
    -- Livefyre
    { 0, 2062, 'livefyre.com' },
    -- Clear Channel
    { 0, 2064, 'clearchannelinternational.com' },
    -- GOLF.com
    { 0, 2065, 'golf.com' },
    -- OCLC
    { 0, 2070, 'oclc.org' },
    -- Chosun
    { 0, 2071, 'chosun.com' },
    -- Game Front
    { 0, 2082, 'gamefront.com' },
    -- BitCoin
    { 0, 2083, 'bitcoin.org' },
    -- Letterpress
    { 0, 2091, 'atebits.com' },
    -- Entertainment Weekly
    --{ 0, 2095, 'timeinc.net' },
    -- Speedtest
    { 0, 2103, 'speedtest.centurylink.net' },
    { 0, 2103, 'speedtest.net' },
    -- Boxnet Upload SSL
    { 0, 2104, 'upload.box.com' },
    -- Flickr Upload
    { 0, 2105, 'up.flickr.com' },
    -- Microsoft Azure
    { 0, 2111, 'thewindowsazureproductsite.disqus.com' },
    -- Adblade
    { 0, 2116, 'adblade.com' },
    -- Blackberry sites
    { 0, 2119, 'blackberry.com' },
    -- Djpod
    { 0, 2120, 'djpod.com' },
    -- MyOnlineArcade
    { 0, 2123, 'myonlinearcade.com' },
    -- SmugMug
    { 0, 2124, 'smugmug.com' },
    -- USAA
    { 0, 2126, 'usaa.com' },
    -- wimp.com
    { 0, 2127, 'wimp.com' },
    -- Show My Weather
    { 0, 2130, 'showmyweather.com' },
    -- MobiTV
    { 0, 2131, 'mobitv.com' },
    -- TV Guide
    { 0, 2132, 'tvguide.com' },
    -- Media Hub
    { 0, 2136, 'samsungmediahub.net' },
    -- CheapOAir
    { 0, 2137, 'cheapoair.com' },
    -- Intel
    { 0, 2143, 'intel.com' },
    -- AMD
    { 0, 2144, 'amd.com' },
    -- Acer
    { 0, 2146, 'acer.com' },
    -- Gateway
    { 0, 2147, 'gateway.com' },
    -- Motorola
    { 0, 2149, 'motorola.com' },
    -- Progressive
    { 0, 2152, 'progressive.com' },
    -- State Farm
    { 0, 2153, 'statefarm.com' },
    -- Liberty Mutual
    { 0, 2156, 'libertymutual.com' },
    -- PerfectIBE
    { 0, 2162, 'perfectibe.com' },
    -- Funny or Die
    { 0, 2163, 'funnyordie.com' },
    { 0, 2163, 'ordienetworks.com' },
    -- Zombo.com
    { 0, 2165, 'zombo.com' },
    -- Viki
    { 0, 2171, 'viki.com' },
    -- Al Jazeera
    { 0, 2180, 'aljazeera.com' },
    { 0, 2180, 'aljazeera.net' },
    -- Wimbledon
    { 0, 2181, 'wimbledon.com' },
    -- Times Union
    { 0, 2183, 'timesunion.com' },
    -- beRecruited
    { 0, 2184, 'berecruited.com' },
    -- Detroit Free Press
    { 0, 2186, 'freep.com' },
    -- Michigan Radio
    { 0, 2188, 'michiganradio.org' },
    -- De Telegraaf
    { 0, 2189, 'telegraaf.nl' },
    -- The Daily Beast
    { 0, 2191, 'thedailybeast.com' },
    -- The Free Dictionary
    { 0, 2192, 'thefreedictionary.com' },
    -- The Onion
    { 0, 2193, 'theonion.com' },
    -- Collider
    { 0, 2207, 'collider.com' },
    -- WordReference.com
    { 0, 2208, 'wordreference.com' },
    -- SpeedRunsLive
    { 0, 2238, 'speedrunslive.com' },
    -- WDT
    { 0, 2240, 'wdtinc.com' },
    -- Twitterrific
    { 0, 2241, 'twitterrific.com' },
    -- The Seattle Times
    { 0, 2242, 'seattletimes.com' },
    -- Okta
    { 0, 2246, 'okta.com' },
    -- ike
    { 0, 2247, 'nike.com' },
    -- Libsyn
    { 0, 2248, 'libsyn.com' },
    -- Investopedia
    { 0, 2250, 'investopedia.com' },
    -- The Hollywood Reporter
    { 0, 2251, 'hollywoodreporter.com' },
    -- CNET TV
    { 0, 2256, 'cnettv.cnet.com' },
    -- Adap.tv
    { 0, 2261, 'adap.tv' },
    -- Drugs.com
    { 0, 2269, 'drugs.com' },
    -- Wood TV8
    { 0, 2285, 'woodtv.com' },
    -- uTorrent
    { 0, 2299, 'utorrent.com' },
    -- Tinder
    { 0, 2302, 'gotinder.com' },
    -- Apache Nutch
    { 0, 2330, 'nutch.apache.org' },
    { 0, 2346, '2345.cn' },
    { 0, 2346, '2345.com' },
    -- Forbes
    { 0, 2347, 'forbes.com' },
    -- Freee TV
    { 0, 2348, 'freeetv.com' },
    -- IKEA.com
    { 0, 2349, 'ikea.is' },
    -- CBS Interactive
    { 0, 2354, 'cbsinteractive.com' },
    -- MyWebSearch
    { 0, 2365, 'mywebsearch.com' },
    -- China.com
    { 0, 2371, 'china.com' },
    -- In.com
    { 0, 2372, 'in.com' },
    -- FL.com
    { 0, 2376, 'nfl.com' },
    -- wetpaint entertainment
    { 0, 2378, 'wetpaint.com' },
    { 0, 2378, 'wetpaint.me' },
    -- PPTV
    { 0, 2380, 'pptv.com' },
    -- Alibaba
    { 0, 2386, 'alibabagroup.com' },
    -- Etao
    { 0, 2388, 'etao.com' },
    -- Amazon
    { 0, 24, 'amazon-presse.de' },
    -- 33Across
    { 0, 2419, '33across.com' },
    { 0, 2419, 'tynt.com' },
    -- The Atlantic
    { 0, 2424, 'atlanticmedia.122.2o7.net' },
    { 0, 2424, 'theatlantic.com' },
    { 0, 2424, 'theatlantic.disqus.com' },
    -- StreetFire
    { 0, 2426, 'streetfire.disqus.com' },
    -- The Escapist Magazine
    { 0, 2430, 'escapistmagazine.com' },
    -- Grantland
    { 0, 2432, 'grantland.com' },
    -- The Independent
    { 0, 2433, 'independent.co.uk' },
    { 0, 2433, 'independentnews.disqus.com' },
    -- Komli Media
    { 0, 2463, 'komli.com' },
    -- Android.com
    { 0, 2470, 'android.com' },
    -- Freelancer
    { 0, 2483, 'freelancer.co.uk' },
    -- Goal
    { 0, 2484, 'goal.com' },
    -- 247 Inc.
    { 0, 2492, '247-inc.com' },
    -- SLI Systems
    { 0, 2494, 'sli-systems.co.jp' },
    { 0, 2494, 'sli-systems.com.au' },
    { 0, 2494, 'sli-systems.com.br' },
    -- OwnerIQ
    { 0, 2495, 'owneriq.com' },
    -- Monetate
    { 0, 2496, 'monetate.com' },
    -- Adtech
    { 0, 2503, 'adtech-kansai.com' },
    { 0, 2503, 'adtech-tokyo.com' },
    -- Amobee
    { 0, 2504, 'amobee.com' },
    -- Mobile Theory
    { 0, 2506, 'mobiletheory.com' },
    -- Casale
    { 0, 2512, 'casalemedia.com' },
    -- Exponential Interactive
    { 0, 2518, 'exponential.com' },
    -- eyeReturn
    { 0, 2526, 'eyeReturn.com' },
    { 0, 2526, 'eyereturnmarketing.com' },
    -- InSkin Media
    { 0, 2527, 'inskinad.com' },
    { 0, 2527, 'inskinmedia.com' },
    -- ustar Information Services
    { 0, 2537, 'neustarlife.biz' },
    { 0, 2537, 'neustarsummit.biz' },
    { 0, 2537, 'tcpacompliance.com' },
    -- Ybrant Digital
    { 0, 2546, 'lygo.com' },
    { 0, 2546, 'www.volomp.com' },
    { 0, 2546, 'ybrantmobile.com' },
    -- Federated Media
    { 0, 2559, 'federatedmedia.net' },
    -- Adify
    { 0, 2570, 'adify.com' },
    -- Aptean
    { 0, 2581, 'aptean.com' },
    -- VoiceFive
    { 0, 2584, 'VoiceFive.com' },
    -- Telecom Express
    { 0, 2588, 'www.telecomexpress.co.uk' },
    -- CNZZ
    { 0, 2597, 'cnzz.com' },
    -- Softonic
    { 0, 2599, 'softonic.cn' },
    { 0, 2599, 'softonic.com.br' },
    { 0, 2599, 'softonic.de' },
    { 0, 2599, 'softonic.fr' },
    { 0, 2599, 'softonic.it' },
    { 0, 2599, 'softonic.jp' },
    { 0, 2599, 'softonic.pl' },
    -- Softpedia
    { 0, 2606, 'softpedia.com' },
    -- China News
    { 0, 2610, 'chinanews.com.cn' },
    { 0, 2610, 'chinanews.com' },
    -- Nico Nico Douga Video
    { 0, 2611, 'live.nicovideo.jp' },
    -- Aliwangwang
    --{ 0, 2617, 'taobao.com' },
    { 0, 2617, 'wangwang.taobao.com' },
    { 0, 2617, 'wangxin.taobao.com' },
    -- Xbox Live sites
    --{ 0, 2626, 'xbox.com' },
    -- GOMTV Remote Control
    { 0, 2638, 'remoteapi.gomlab.com' },
    -- Live365
    { 0, 264, 'live365.com' },
    -- GoToTraining
    { 0, 2642, 'gototraining.com' },
    -- PNAS
    { 0, 2651, 'pnascentral.org' },
    -- Stitcher
    { 0, 2653, 'stitcher.assets.s3.amazonaws.com' },
    -- The Baltimore Sun
    { 0, 2656, 'baltimoresun.com' },
    -- Dilbert.com
    { 0, 2657, 'dilbert.com' },
    -- INRIX
    { 0, 2662, 'inrix.com' },
    -- Lijit
    { 0, 2663, 'lijit.com' },
    -- Moat
    { 0, 2664, 'moat.com' },
    { 0, 2664, 'moatads.com' },
    { 0, 2664, 'moatsearch-data.s3.amazonaws.com' },
    -- Break.com
    { 0, 2666, 'breakmedia.com' },
    -- ibVPN Login
    --{ 0, 2680, 'ibvpn.com' },
    -- Fuyin.TV
    { 0, 2696, 'fuyin.tv' },
    -- SHOWTIME ANYTIME
    { 0, 2697, 'sho.com' },
    -- Sky.com
    { 0, 2699, 'news.sky.com' },
    { 0, 2699, 'skynews.com' },
    { 0, 2699, 'skysports.com' },
    -- EA Games
    { 0, 2701, 'easports.com' },
    { 0, 2701, 'maxis.com' },
    { 0, 2701, 'simcity.com' },
    { 0, 2701, 'thesims.com' },
    -- Gizmodo
    { 0, 2705, 'gizmodo.com' },
    -- SimplePie
    { 0, 2706, 'simplepie.org' },
    -- Zippyshare
    { 0, 2738, 'zippyshare.com' },
    -- GTA Online
    --{ 0, 2740, 'rockstargames.com' },
    -- Rockstar Games
    { 0, 2747, 'rockstargames.com' },
    { 0, 2747, 'rockstarleeds.co.uk' },
    { 0, 2747, 'rockstarlincoln.com' },
    { 0, 2747, 'rockstarnewengland.com' },
    { 0, 2747, 'rockstarnorth.com' },
    { 0, 2747, 'rockstarsandiego.com' },
    { 0, 2747, 'rockstartoronto.com' },
    -- CTV News
    { 0, 2751, 'ctvnews.cookieless.ca' },
    -- KVOA.com
    { 0, 2753, 'kvoa.com' },
    -- MovieTickets.com
    { 0, 2755, 'movieticketscom.122.2o7.net' },
    -- Tvigle
    { 0, 2761, 'tvigle.com' },
    { 0, 2761, 'tvigle.ru' },
    -- SFGate
    { 0, 2765, 'sfgate.com' },
    -- Library of Congress
    { 0, 2766, 'loc.gov' },
    -- OverBlog
    { 0, 2767, 'over-blog-kiwi.com' },
    { 0, 2767, 'over-blog.net' },
    { 0, 2767, 'overblog.com' },
    -- TIME.com
    { 0, 2770, 'timeinc.net' },
    -- Phoca
    { 0, 2771, 'phoca.cz' },
    -- Joomla
    { 0, 2779, 'joomla.org' },
    { 0, 2779, 'joomlacode.org' },
    -- Stanford University
    { 0, 2783, 'gostanford.com' },
    -- Recht24
    { 0, 2785, 'e-recht24.de' },
    -- European Union
    { 0, 2786, 'europa.eu' },
    -- McAfee
    { 0, 280, 'mcafee12.tt.omtrdc.net' },
    -- Office 365
    { 0, 2812, 'Home.Office.com' },
    { 0, 2812, 'Portal.Office.com' },
    -- Picsearch
    { 0, 2816, 'picsearch.com' },
    -- Fetion
    { 0, 2817, 'feixin.10086.cn' },
    -- Okurin
    { 0, 2822, 'okurin.bitpark.co.jp' },
    -- Hangame
    { 0, 2832, 'hangame.co.jp' },
    -- SugarCRM
    { 0, 2833, 'sugarcrm.com' },
    -- Pastebin.com
    { 0, 2839, 'pastebin.com' },
    -- Zhihu.com
    { 0, 2840, 'zhihu.com' },
    -- Adobe Analytics
    { 0, 2846, 'adobe.tt.omtrdc.net' },
    -- AdSame
    { 0, 2849, 'adsame.com' },
    -- Ganji
    { 0, 2854, 'ganji.com' },
    -- BBC iPlayer
    --{ 0, 2857, 'bbc.co.uk' },
    -- Zol.com.cn
    { 0, 2866, 'zol-img.com.cn' },
    { 0, 2866, 'zol.com.cn' },
    -- Baidu Movies
    { 0, 2869, 'movie.baidu.com' },
    { 0, 2869, 'v.baidu.com' },
    { 0, 2869, 'video.baidu.com' },
    -- Xunlei Kankan
    { 0, 2878, 'kankan.com' },
    { 0, 2878, 'sandai.net' },
    { 0, 2878, 'xlpan.com' },
    { 0, 2878, 'xunlei.com' },
    -- Myspace Photos
    --{ 0, 2882, 'myspace.com' },
    -- Myspace Videos
    --{ 0, 2883, 'myspace.com' },
    -- Gyao
    { 0, 2885, 'gyao.c.yimg.jp' },
    { 0, 2885, 'gyao.yahoo.co.jp' },
    -- Glype
    { 0, 2891, 'glype.com' },
    -- Sanook.com
    { 0, 2893, 'sanook.com' },
    -- YiXin
    --{ 0, 2914, 'netease.com' },
    -- Tomatopang
    { 0, 2943, 'tomatopang.net' },
    -- Sina Video
    { 0, 2948, 'video.sina.com' },
    -- Crackle Video
    --{ 0, 2955, 'crackle.com' },
    -- Napster
    { 0, 319, 'napster.co.uk' },
    { 0, 319, 'napster.com' },
    -- VPNReactor
    { 0, 3652, 'vpnreactorsupport.com' },
    { 0, 3652, 'vprdownload.com' },
    -- Delta Search
    { 0, 3657, 'delta-search.com' },
    { 0, 3657, 'royal-search.com' },
    -- news.com.au
    { 0, 3671, 'news.com.au' },
    -- Soso
    { 0, 3673, 'soso.com' },
    -- Ad4mat
    { 0, 3702, 'ad4mat.com' },
    { 0, 3702, 'ad4mat.de' },
    { 0, 3702, 'ad4mat.net' },
    -- Cedexis
    { 0, 3705, 'cedexis.com' },
    -- L'equipe.fr
    { 0, 3711, 'lequipe.fr' },
    { 0, 3711, 'lequipe21.fr' },
    { 0, 3711, 'logc215.xiti.com' },
    -- Proxistore
    { 0, 3717, 'proxistore.com' },
    -- Viewsurf
    { 0, 3722, 'viewsurf.com' },
    -- XiTi
    { 0, 3724, 'atinternet.com' },
    -- OneDrive
    { 0, 3735, 'ssw.live.com' },
    -- LinkedIn Contacts
    { 0, 3736, 'contacts.linkedin.com' },
    -- Rackspace
    { 0, 3737, 'rackspace.com' },
    -- ServiceNow
    { 0, 3738, 'servicenow.com' },
    -- PPStream
    { 0, 374, 'pps.tv' },
    { 0, 374, 'ppstream.com' },
    -- Blizzard
    { 0, 3745, 'blizzard.com' },
    { 0, 3745, 'blzstatic.cn' },
    { 0, 3745, 'blznews.akamaized.net' },
    { 0, 3745, 'blzprofile.akamaized.net' },
    { 0, 3745, 'blzmedia-a.akamaihd.net' },
    -- USAIP
    { 0, 3755, 'usaip.eu' },
    -- Yahoo! Douga
    { 0, 3756, 'streaming.yahoo.co.jp' },
    -- Clip2Net
    { 0, 3782, 'clip2net.com' },
    -- Yesky
    { 0, 3790, 'yesky.com' },
    -- Lineage
    { 0, 3801, 'lineage.com' },
    { 0, 3801, 'lineage.plaync.com' },
    { 0, 3801, 'lineage2.com' },
    -- MapleStory
    { 0, 3802, 'maplestory.nexon.net' },
    -- Level 3
    { 0, 3805, 'level3.com' },
    -- MissLee
    { 0, 3815, 'misslee.net' },
    -- QDown
    { 0, 3817, 'qdown.com' },
    -- BaiduHi
    { 0, 3838, 'im.baidu.com' },
    -- Ad Master
    { 0, 3846, 'admaster.com.cn' },
    -- Ad Tech
    { 0, 3847, 'adtech.com' },
    { 0, 3847, 'adtech.de' },
    { 0, 3847, 'adtechus.com' },
    { 0, 3847, 'oneadserver.aol.com' },
    -- QQ
    { 0, 386, 'qpic.cn.com' },
    -- 360 Safeguard
    { 0, 3866, '360.cn' },
    -- People's Daily
    { 0, 3868, 'people.com.cn' },
    -- China Daily
    { 0, 3871, 'chinadaily.com.cn' },
    -- Guangming Online
    { 0, 3872, 'gmw.cn' },
    -- Autodesk
    { 0, 3888, 'autodesk.com' },
    -- Wow
    { 0, 3910, 'wow.com' },
    -- Tencent Video
    { 0, 3942, 'vm.gtimg.cn' },
    -- Hulu Video
    --{ 0, 3946, 'hulu.com' },
    -- Flipkart
    { 0, 3970, 'flipkart.com' },
    -- SUPERAntiSpyware
    { 0, 3991, 'superantispyware.com' },
    -- WPS Office
    { 0, 4010, 'kingsoftstore.com' },
    { 0, 4010, 'wps.cn' },
    -- Kontiki
    { 0, 4013, 'kontiki.com' },
    -- Western Digital
    { 0, 4039, 'wdc.com' },
    -- WD softwares Download/Update
    { 0, 4040, 'download.wdc.com' },
    -- Baidu Yun
    { 0, 4043, 'yun.baidu.com' },
    -- Burnbook
    { 0, 4046, 'p.typekit.net' },
    -- Naver Blog
    { 0, 4050, 'blog.naver.com' },
    { 0, 4050, 'blog.poll.naver.com' },
    { 0, 4050, 'blogfiles13.naver.net' },
    { 0, 4050, 'blogfiles4.naver.net' },
    { 0, 4050, 'blogfiles5.naver.net' },
    { 0, 4050, 'blogfiles9.naver.net' },
    { 0, 4050, 'blogimgs.naver.com' },
    { 0, 4050, 'blogimgs.naver.net' },
    { 0, 4050, 'blogpfthumb.phinf.naver.net' },
    { 0, 4050, 'blogthumb2.naver.net' },
    { 0, 4050, 'mblogthumb4.phinf.naver.net' },
    { 0, 4050, 'static.naver.net' },
    -- Naver Cafe
    { 0, 4051, 'cafe.naver.com' },
    { 0, 4051, 'cafefiles.naver.net' },
    { 0, 4051, 'cafeimgs.naver.net' },
    { 0, 4051, 'cafeptthumb1.phinf.naver.net' },
    { 0, 4051, 'cafeptthumb2.phinf.naver.net' },
    { 0, 4051, 'cafeptthumb3.phinf.naver.net' },
    { 0, 4051, 'cafeptthumb4.phinf.naver.net' },
    { 0, 4051, 'lcs.naver.com' },
    -- Daum Cafe
    { 0, 4053, 'cafeimg.daum-img.net' },
    -- Naver Mail
    { 0, 4054, 'mail.naver.com' },
    -- Messenger
    { 0, 4073, 'chat.messenger.com' },
    -- Synology DSM
    { 0, 4089, 'checkip.synology.com' },
    { 0, 4089, 'download.synology.com' },
    { 0, 4089, 'keymaker.synology.com' },
    { 0, 4089, 'update.synology.com' },
    { 0, 4089, 'www.synology.com' },
    -- WebM Files
    { 0, 4109, 'webmfiles.org' },
    -- AOL Games
    { 0, 4117, 'games.aol.co.uk' },
    { 0, 4117, 'games.aol.com' },
    { 0, 4117, 'games.aol.de' },
    { 0, 4117, 'spiele.aol.de' },
    -- Nintendo
    { 0, 4130, 'nintendo.fr' },
    -- Showbox
    { 0, 4149, 'apk.org' },
    { 0, 4149, 'apkmirror.com' },
    { 0, 4149, 'showbox.org' },
    { 0, 4149, 'showboxapp.com' },
    { 0, 4149, 'showboxappandroid.com' },
    { 0, 4149, 'showboxappdownload.co' },
    { 0, 4149, 'showboxappdownloads.com' },
    -- SoulSeek
    { 0, 442, 'slsknet.org' },
    { 0, 442, 'soulseekqt.net' },
    -- MKRU
    { 0, 4522, 'mk.ru' },
    -- MKRU Streaming
    { 0, 4523, 'tv.mk.ru' },
    -- Vonage
    { 0, 495, 'vonage.com' },
    -- Wordpress
    { 0, 506, 'wordpress.org' },
    -- Yahoo!
    { 0, 524, 'yahoo.net' },
    -- 1-800-Flowers
    { 0, 535, '1800flowers.com' },
    -- 2channel
    { 0, 537, '2ch.net' },
    -- 6pm.com
    { 0, 538, '6pm.com' },
    -- Ace Hardware Corporation
    { 0, 539, 'acehardware.com' },
    -- Adobe Software
    { 0, 541, 'adobe.com' },
    -- Adorama
    { 0, 542, 'adorama.com' },
    -- American Express
    { 0, 544, 'americanexpress.ae' },
    { 0, 544, 'americanexpress.ch' },
    -- AOL Mail
    { 0, 546, 'mail.aol.se' },
    -- CC Studios
    --{ 0, 556, 'cc.com' },
    -- Autoblog
    { 0, 557, 'autoblog.com' },
    -- AutoTrader.com
    { 0, 558, 'autotrader.com' },
    -- B&H Photo Video
    { 0, 559, 'bhphotovideo.com' },
    -- Basecamp
    { 0, 563, 'basecamphq.com' },
    -- Best Buy
    { 0, 567, 'bestbuy.com' },
    -- Black & Decker Corporation
    { 0, 572, 'blackanddecker.com' },
    -- Blockbuster
    { 0, 575, 'blockbusteronline.com.br' },
    -- Bloomingdales
    { 0, 577, 'bloomingdales.com' },
    -- Blue Nile
    { 0, 578, 'bluenile.com' },
    -- Bluefly
    { 0, 579, 'bluefly.com' },
    -- CamerasDirect.com.au
    { 0, 581, 'camerasdirect.com.au' },
    -- Capital One
    { 0, 582, 'capitalone.ca' },
    -- Car and Driver
    { 0, 583, 'caranddriver.com' },
    -- CarMax
    { 0, 584, 'carmax.com' },
    -- CDiscount
    { 0, 585, 'cdiscount.com' },
    -- CheapTickets
    { 0, 588, 'cheaptickets.com' },
    -- City Sports
    { 0, 591, 'citysports.com' },
    -- Costco
    { 0, 593, 'costco.ca' },
    -- Craigslist
    { 0, 594, 'craigslist.ca' },
    { 0, 594, 'craigslist.ch' },
    { 0, 594, 'craigslist.de' },
    { 0, 594, 'craigslist.es' },
    { 0, 594, 'craigslist.gr' },
    { 0, 594, 'craigslist.hk' },
    { 0, 594, 'craigslist.it' },
    { 0, 594, 'craigslist.jp' },
    { 0, 594, 'craigslist.pl' },
    { 0, 594, 'craigslist.pt' },
    { 0, 594, 'craigslist.se' },
    -- Crutchfield
    { 0, 595, 'crutchfield.com' },
    -- BitTorrent
    { 0, 61, 'bittorrent.com' },
    -- Diigo
    { 0, 612, 'diigo.com' },
    -- Dillards
    { 0, 613, 'dillards.com' },
    -- Discover
    { 0, 615, 'discoverbank.com' },
    -- Drugstore.com
    { 0, 620, 'drugstore.com' },
    -- Expedia
    { 0, 628, 'expedia.at' },
    { 0, 628, 'expedia.be' },
    { 0, 628, 'expedia.ca' },
    { 0, 628, 'expedia.de' },
    { 0, 628, 'expedia.dk' },
    { 0, 628, 'expedia.es' },
    { 0, 628, 'expedia.fr' },
    { 0, 628, 'expedia.ie' },
    { 0, 628, 'expedia.it' },
    { 0, 628, 'expedia.nl' },
    { 0, 628, 'expedia.no' },
    { 0, 628, 'expedia.se' },
    -- Fidelity
    { 0, 636, 'fidelity-international.com' },
    { 0, 636, 'fidelity-italia.it' },
    { 0, 636, 'fidelity.at' },
    { 0, 636, 'fidelity.de' },
    { 0, 636, 'fidelity.fr' },
    { 0, 636, 'fidelity.nl' },
    { 0, 636, 'fidelity.se' },
    -- Fnac
    { 0, 640, 'fnac.ch' },
    { 0, 640, 'fnac.com' },
    { 0, 640, 'fnac.es' },
    { 0, 640, 'fnac.pt' },
    -- FTD
    { 0, 644, 'ftd.com' },
    { 0, 646, 'g4tv.com' },
    -- Game Informer
    { 0, 647, 'gameinformer.com' },
    -- GameSpy
    { 0, 649, 'gamespy.com' },
    -- GameStop
    { 0, 650, 'gamestop.ca' },
    { 0, 650, 'gamestop.com' },
    { 0, 650, 'gamestop.de' },
    { 0, 650, 'gamestop.dk' },
    { 0, 650, 'gamestop.es' },
    { 0, 650, 'gamestop.fi' },
    { 0, 650, 'gamestop.ie' },
    { 0, 650, 'gamestop.it' },
    { 0, 650, 'gamestop.no' },
    { 0, 650, 'gamestop.pt' },
    { 0, 650, 'gamestop.se' },
    -- GameTrailers
    { 0, 651, 'gametrailers.com' },
    -- Haiku Learning Systems
    { 0, 669, 'haikulearning.com' },
    -- Home Depot
    { 0, 670, 'homedepot.ca' },
    { 0, 670, 'homedepot.com' },
    -- House of Fraser
    { 0, 674, 'houseoffraser.co.uk' },
    -- HSBC
    { 0, 675, 'hsbc.am' },
    { 0, 675, 'hsbc.bm' },
    { 0, 675, 'hsbc.ca' },
    { 0, 675, 'hsbc.fr' },
    { 0, 675, 'hsbc.ge' },
    { 0, 675, 'hsbc.gr' },
    { 0, 675, 'hsbc.lk' },
    { 0, 675, 'hsbctrinkaus.de' },
    -- Hulu
    { 0, 677, 'hulu.com' },
    -- J.C. Penney
    { 0, 690, 'jcpenney.com' },
    -- Jalopnik
    { 0, 693, 'jalopnik.com' },
    -- Joystiq
    { 0, 696, 'joystiq.com' },
    -- Kay Jewelers
    { 0, 698, 'kay.com' },
    -- Kmart
    { 0, 702, 'kmart.com' },
    -- Kogan Technologies
    { 0, 703, 'kogan.co.uk' },
    { 0, 703, 'kogan.com.au' },
    -- Kohl's
    { 0, 704, 'kohls.com' },
    -- Kotaku
    { 0, 707, 'kotaku.com' },
    -- LiveJournal
    { 0, 716, 'livejournal.com' },
    -- Lord & Taylor
    { 0, 719, 'lordandtaylor.com' },
    -- LOVEFiLM
    { 0, 721, 'lovefilm.no' },
    -- Lowe's
    { 0, 722, 'lowes.ca' },
    { 0, 722, 'lowes.com' },
    -- Menards
    { 0, 727, 'menards.com' },
    -- MetaFilter
    { 0, 729, 'metafilter.com' },
    -- yUdutu
    { 0, 748, 'myudutu.com' },
    -- Neckermann
    { 0, 750, 'neck.be' },
    { 0, 750, 'neck.nl' },
    { 0, 750, 'neckermann.at' },
    { 0, 750, 'neckermann.ch' },
    { 0, 750, 'neckermann.com.pl' },
    { 0, 750, 'neckermann.cz' },
    { 0, 750, 'neckermann.de' },
    { 0, 750, 'neckermann.si' },
    -- Neiman Marcus
    { 0, 751, 'neimanmarcus.com' },
    -- tlog
    { 0, 757, 'netlog.com' },
    -- Netvibes
    { 0, 758, 'netvibes.com' },
    -- Newegg
    { 0, 759, 'newegg.ca' },
    { 0, 759, 'newegg.cn' },
    { 0, 759, 'neweggbusiness.com' },
    { 0, 759, 'neweggflash.com' },
    -- NewsNow
    { 0, 760, 'newsnow.co.uk' },
    -- Newsvine
    { 0, 761, 'newsvine.com' },
    -- Noordstrom
    { 0, 764, 'nordstrom.com' },
    -- Office Depot
    { 0, 768, 'office-depot.be' },
    { 0, 768, 'office-depot.ch' },
    { 0, 768, 'office-depot.fr' },
    { 0, 768, 'officedepot.at' },
    { 0, 768, 'officedepot.be' },
    { 0, 768, 'officedepot.ca' },
    { 0, 768, 'officedepot.ch' },
    { 0, 768, 'officedepot.cz' },
    { 0, 768, 'officedepot.de' },
    { 0, 768, 'officedepot.es' },
    { 0, 768, 'officedepot.fr' },
    { 0, 768, 'officedepot.hu' },
    { 0, 768, 'officedepot.ie' },
    { 0, 768, 'officedepot.lu' },
    { 0, 768, 'officedepot.sk' },
    -- OfficeMax
    { 0, 769, 'officemax.com' },
    -- Orbitz
    { 0, 775, 'orbitz.com' },
    -- Overstock.com
    { 0, 778, 'overstock.com' },
    -- Picasa
    { 0, 785, 'picasaweb.com' },
    -- ProFlowers
    { 0, 793, 'proflowers.com' },
    -- Quickflix
    { 0, 796, 'quickflix.com.au' },
    -- QVC
    { 0, 798, 'qvc.jp' },
    -- Redmine
    { 0, 805, 'redmine.org' },
    -- REI
    { 0, 806, 'rei.com' },
    -- Renren
    { 0, 808, 'renren.com' },
    -- REVOLVEclothing
    { 0, 809, 'revolveclothing.com' },
    -- Rona
    { 0, 810, 'rona.ca' },
    -- Saks Fifth Avenue
    { 0, 816, 'saksfifthavenue.com' },
    -- Sam's Club
    { 0, 817, 'sams.com.mx' },
    { 0, 817, 'samsclub.com' },
    -- schuelerVZ
    { 0, 818, 'schuelervz.net' },
    -- Schwab
    { 0, 819, 'schwab.com' },
    -- Sears
    { 0, 821, 'searsgaragedoors.com' },
    { 0, 821, 'searshardwarestores.com' },
    { 0, 821, 'searshomeapplianceshowroom.com' },
    { 0, 821, 'searshometownstores.com' },
    -- Shoplet
    { 0, 825, 'shoplet.com' },
    -- ShopNBC
    { 0, 826, 'shopnbc.com' },
    -- ShowClix
    { 0, 830, 'showclix.com' },
    -- spin.de
    { 0, 841, 'spin.de' },
    -- Staples
    { 0, 848, 'staples.de' },
    { 0, 848, 'staples.pt' },
    { 0, 848, 'staples.com' },
    -- StayFriends
    { 0, 849, 'stayfriends.de' },
    -- StubHub
    { 0, 850, 'stubhub.com' },
    -- studiVZ
    { 0, 851, 'studivz.net' },
    -- Swarovski
    { 0, 854, 'swarovski.com' },
    -- T. Rowe Price
    { 0, 855, 'troweprice.com' },
    -- Tchibo
    { 0, 859, 'eduscho.at' },
    { 0, 859, 'tchibo.ch' },
    { 0, 859, 'tchibo.com.tr' },
    { 0, 859, 'tchibo.cz' },
    { 0, 859, 'tchibo.de' },
    { 0, 859, 'tchibo.pl' },
    -- TD Ameritrade
    { 0, 860, 'tdameritrade.com' },
    -- The Gap
    { 0, 863, 'gap.cn' },
    { 0, 863, 'gap.co.jp' },
    { 0, 863, 'gap.com' },
    { 0, 863, 'gap.eu' },
    { 0, 863, 'gapcanada.ca' },
    -- The Sharper Image
    { 0, 864, 'sharperimage.com' },
    -- ThinkGeek
    { 0, 865, 'thinkgeek.com' },
    -- Ticketmaster
    { 0, 867, 'ticketmaster.ca' },
    { 0, 867, 'ticketmaster.com' },
    -- Tickets.com
    { 0, 868, 'tickets.com' },
    -- Tiffany & Co.
    { 0, 870, 'tiffany.at' },
    { 0, 870, 'tiffany.cn' },
    { 0, 870, 'tiffany.de' },
    { 0, 870, 'tiffany.fr' },
    { 0, 870, 'tiffany.it' },
    { 0, 870, 'tiffany.kr' },
    -- Tiger Direct
    { 0, 871, 'tigerdirect.ca' },
    { 0, 871, 'tigerdirect.com' },
    -- Top Gear
    { 0, 877, 'topgear.com' },
    -- Trac
    { 0, 878, 'trac.edgewall.org' },
    -- Travelocity
    { 0, 880, 'travelocity.ca' },
    { 0, 880, 'travelocity.com' },
    -- TripAdvisor
    { 0, 881, 'tripadvisor.com' },
    -- Ustream.tv
    { 0, 884, 'ustream.tv' },
    -- Vanguard
    { 0, 885, 'vanguardinvestments.ch' },
    { 0, 885, 'vanguardinvestments.de' },
    { 0, 885, 'vanguardinvestments.dk' },
    { 0, 885, 'vanguardinvestments.fr' },
    { 0, 885, 'vanguardinvestments.nl' },
    { 0, 885, 'vanguardinvestments.se' },
    -- vente-privee.com
    { 0, 888, 'vente-privee.com' },
    -- Vimeo
    { 0, 893, 'vimeo.com' },
    -- Voyages-sncf.com
    { 0, 899, 'voyages-sncf.com' },
    -- Wachovia
    { 0, 900, 'wachovia.com' },
    -- Web Of Trust
    { 0, 903, 'mywot.com' },
    -- Windows Live SkyDrive
    { 0, 911, 'skydrive.live.com' },
    -- Woot
    { 0, 917, 'woot.com' },
    -- XM Radio Online
    { 0, 923, 'xmradio.com' },
    -- Zales
    { 0, 930, 'zales.com' },
    -- Zappos
    { 0, 931, 'zappos.com' },
    -- tflix stream
    --{ 0, 939, 'netflix.com' },
    -- Yahoo! Toolbar
    { 0, 947, 'toolbar.yahoo.com' },
    -- RitzCamera.com
    { 0, 951, 'ritzcamera.com' },
    -- Macy's
    { 0, 952, 'macys.com' },
    -- 7digital
    { 0, 959, '7digital.com' },
    -- Commvault
    { 0, 96, 'commvault.be' },
    { 0, 96, 'commvault.ca' },
    { 0, 96, 'commvault.cl' },
    { 0, 96, 'commvault.co.uk' },
    { 0, 96, 'commvault.co.za' },
    { 0, 96, 'commvault.de' },
    { 0, 96, 'commvault.fr' },
    { 0, 96, 'commvault.in' },
    { 0, 96, 'commvault.it' },
    { 0, 96, 'commvault.jp' },
    { 0, 96, 'commvault.nl' },
    { 0, 96, 'commvault.ru' },
    { 0, 96, 'commvault.se' },
    -- Chatroulette
    { 0, 962, 'chatroulette.com' },
    -- Cyworld
    { 0, 963, 'cyworld.co' },
    -- Daum
    { 0, 964, 'daum.net' },
    -- Deezer
    { 0, 965, 'deezer.com' },
    -- Evony
    { 0, 970, 'evony.com' },
    -- FileDropper
    { 0, 971, 'filedropper.com' },
    -- Filemail
    { 0, 972, 'filemail.com' },
    -- Licorize
    { 0, 974, 'licorize.com' },
    -- FORA.tv
    { 0, 976, 'fora.tv' },
    -- Habbo
    { 0, 980, 'habbo.at' },
    { 0, 980, 'habbo.be' },
    { 0, 980, 'habbo.cl' },
    { 0, 980, 'habbo.de' },
    { 0, 980, 'habbo.dk' },
    { 0, 980, 'habbo.fi' },
    { 0, 980, 'habbo.fr' },
    { 0, 980, 'habbo.it' },
    { 0, 980, 'habbo.jp' },
    -- The Hype Machine
    { 0, 982, 'hypem.com' },
    -- iHeartRadio
    { 0, 984, 'iheartradio.com' },
    -- Issuu
    { 0, 985, 'issuu.co' },
    -- Jamendo
    { 0, 986, 'jamendo.com' },
    -- Livestream
    { 0, 991, 'livestream.com' },
    -- MyDownloader
    { 0, 995, 'mydownloader.net' },
    -- Omegle
    { 0, 997, 'omegle.com' },
    -- Mister Wong
    { 0, 999, 'mister-wong.com' },
    { 0, 999, 'mister-wong.de' },
    { 0, 999, 'mister-wong.es' },
    { 0, 999, 'mister-wong.fr' },
    -- ESPN Video
    { 0, 2933, 'media.video-cdn.espn.com' },
    { 0, 2933, 'watch-cdn.product.api.espn.com' },

}

gSSLCnamePatternList = {

    -- Blizzard
    { 0, 3745, 'cnc.blzstatic', },

}

function DetectorInit(detectorInstance)

    gDetector = detectorInstance;

    if gDetector.addSSLCertPattern then
        for i,v in ipairs(gSSLHostPatternList) do
            gDetector:addSSLCertPattern(v[1],v[2],v[3]);
        end
    end

    if gDetector.addSSLCnamePattern then
        for i,v in ipairs(gSSLCnamePatternList) do
            gDetector:addSSLCnamePattern(v[1],v[2],v[3]);
        end
    end

    return gDetector;
end

function DetectorClean()
end


