--[[
# Copyright 2001-2014 Cisco Systems, Inc. and/or its affiliates. All rights
# reserved.
#
# This file contains proprietary Detector Content created by Cisco Systems,
# Inc. or its affiliates ("Cisco") and is distributed under the GNU General
# Public License, v2 (the "GPL").  This file may also include Detector Content
# contributed by third parties. Third party contributors are identified in the
# "authors" file.  The Detector Content created by Cisco is owned by, and
# remains the property of, Cisco.  Detector Content from third party
# contributors is owned by, and remains the property of, such third parties and
# is distributed under the GPL.  The term "Detector Content" means specifically
# formulated patterns and logic to identify applications based on network
# traffic characteristics, comprised of instructions in source code or object
# code form (including the structure, sequence, organization, and syntax
# thereof), and all documentation related thereto that have been officially
# approved by Cisco.  Modifications are considered part of the Detector
# Content.
--]]
--[[
detection_name: SSL Group "347"
version: 2
description: Group of SSL Host detectors.
bundle_description: $VAR1 = {
          'Liputan 6' => 'Television news program on SCTV, an Indonesian TV station.',
          'Mathrubhumi' => 'Malayalam newspaper published from Kerala, India.',
          'UrduPoint.com' => 'Urudu news website providing latest news around the world.',
          'Catholic Education Australia' => 'Site for Catholic Schools and to the schools in the Archdiocese of Canberra and Goulburn.',
          'wikiHow' => 'Online guide for how to do anything.',
          'Xcar' => 'A Chinese automotive news website.',
          'LifeBuzz' => 'Online portal for trending contents.',
          'VICE' => 'Official website for VICE magazine, which focus on arts, culture and news topics.',
          'Princess Polly' => 'Online clothing store.',
          'MawDoo3' => 'Arabic online encyclopedia.',
          'Zscaler' => 'Cloud-based information security.',
          'Onshape' => 'Online product design platform.',
          'Xywycom' => 'A Chinese internet medical services platform.',
          'UDN' => 'Chinese newspaper.',
          'ups.com' => 'United Parcel service is the largest package delivery company.',
          'NelsonNet' => 'Educational games web portal.',
          'iflix' => 'Movie streaming.',
          'Coolmath' => 'Educational games portal.',
          'Youm7' => 'Egyptian news website.',
          'The Verge' => 'Technology news and media network operated by Vox media.',
          'Noteflight' => 'Online music writing application.',
          'LIFE' => 'Entertainment website from Taiwan.',
          'Western Journalism' => 'An American conservative news and political website.',
          'Lifehacker' => 'Weblog about life hacks and software.',
          'Varzesh3' => 'Persian news website.',
          'Viral Thread' => 'Online website for latest trending news.',
          'Udemy' => 'Online site for learning and teaching for students.',
          'Upwork' => 'Global freelancing platform for businesses and independent professionals be connected.',
          'Webtretho' => 'Vietnamese internet forum.',
          'Wirtualna Polska' => 'Polish news webportal.',
          'weblio' => 'Online Japnese-English dictionary.',
          'CimaClub' => 'Movie and video streaming website.',
          'Libero.it' => 'Itailian search engine and news portal.',
          'LTN' => 'Official website for Liberty Times Net, a Taiwan newspaper.',
          'Stile' => 'Online educational platform.',
          'Prodigy Games' => 'Online educational games.',
          'Cloudinary' => 'Cloud service solution for image management.',
          'Uptodown' => 'Mobile app for downloading software.',
          'Drift' => 'Conversational marketing platform.',
          'WIX' => 'Cloud-based web development platform.',
          'Wowhead' => 'Website intended to provide World of Warcraft players with tools to make their gameplay more enjoyable.'
        };

--]]

require "DetectorCommon"

local DC = DetectorCommon

DetectorPackageInfo = {
    name =  "ssl_host_group_347",
    proto =  DC.ipproto.tcp,
    client = {
        init =  'DetectorInit',
        clean =  'DetectorClean',
        minimum_matches =  1
    }
}

gSSLHostPatternList = {
    -- Catholic Education Australia
    {0, 4595, 'cg.catholic.edu.au', },
    {0, 4595, 'cgcatholic.org.au', },
    -- Stile
    {0, 4593, 'stileapp.com', },
    {0, 4593, 'stileeducation.com', },
    -- Zscaler
    {0, 4592, 'zscaler.com', },
    {0, 4592, 'zscaler.net', },
    {0, 4592, 'zscalerone.net', },
    {0, 4592, 'zscalertwo.net', },
    {0, 4592, 'zscalerthree.net', },
    {0, 4592, 'zscalerbeta.net', },
    {0, 4592, 'zscloud.net', },
    -- Princess Polly
    {0, 4591, 'princesspolly.com', },
    -- Drift
    {0, 4589, 'drift.com', },
    -- Cloudinary
    {0, 4588, 'cloudinary.com', },
    -- Coolmath
    {0, 4587, 'coolmath.com', },
    {0, 4587, 'coolmath4kids.com', },
    {0, 4587, 'coolmathgames.com', },
    -- Noteflight
    {0, 4586, 'noteflight.com', },
    -- Onshape
    {0, 4585, 'onshape.com', },
    -- NelsonNet
    {0, 4584, 'nelsonnet.com.au', },
    -- Prodigy Games
    {0, 4583, 'prodigygame.com', },
    -- MawDoo3
    {0, 4536, 'mawdoo3.com', },
    -- Mathrubhumi
    {0, 4535, 'mathrubhumi.com', },
    -- CimaClub
    {0, 4534, 'cima-club.club', },
    -- iflix
    {0, 4526, 'iflix.com', },
    -- Youm7
    {0, 4381, 'youm7.com', },
    -- Xywycom
    {0, 4379, 'xywy.com', },
    -- Xcar
    {0, 4375, 'xcar.com.cn', },
    -- Wowhead
    {0, 4372, 'wowhead.com', },
    {0, 4372, 'wow.zamimg.com', },
    -- WIX
    {0, 4371, 'wix.com', },
    -- Wirtualna Polska
    {0, 4369, 'wp.pl', },
    -- Udemy
    {0, 4353, 'udemy.com', },
    {0, 4353, 'udemycdn.com', },
    {0, 4353, 'udemymail.com', },
    -- wikiHow
    {0, 4368, 'wikihow.com', },
    {0, 4368, 'wikihow.cz', },
    {0, 4368, 'wikihow.it', },
    {0, 4368, 'wikihow.com.tr', },
    {0, 4368, 'wikihow.vn', },
    {0, 4368, 'wikihowfarsi.com', },
    -- Western Journalism
    {0, 4367, 'westernjournal.com', },
    -- Webtretho
    {0, 4366, 'webtretho.com', },
    -- weblio
    {0, 4365, 'weblio.jp', },
    {0, 4365, 'weblio.hs.llnwd.net', },
    -- Viral Thread
    {0, 4364, 'vt.co', },
    -- VICE
    {0, 4362, 'vice.com', },
    {0, 4362, 'vicetv.com', },
    -- The Verge
    {0, 4361, 'theverge.com', },
    -- Varzesh3
    {0, 4360, 'varzesh3.com', },
    -- UrduPoint.com
    {0, 4359, 'urdupoint.com', },
    -- Upwork
    {0, 4358, 'upwork.com', },
    {0, 4358, 'static-upwork.com', },
    -- Uptodown
    {0, 4357, 'uptodown.com', },
    {0, 4357, 'uptodown.io', },
    {0, 4357, 'uptodown.zendesk.com', },
    {0, 4357, 'utdstc.com', },
    -- ups.com
    {0, 4356, 'ups.com', },
    {0, 4356, 'ups.inq.com', },
    -- UDN
    {0, 4354, 'udn.com', },
    -- LTN
    {0, 4352, 'ltn.com.tw', },
    -- Liputan 6
    {0, 4350, 'liputan6.com', },
    {0, 4350, 'liputan6.id', },
    {0, 4350, 'one.co.id', },
    -- Lifehacker
    {0, 4348, 'lifehacker.com', },
    -- LifeBuzz
    {0, 4347, 'lifebuzz.com', },
    -- LIFE
    {0, 4346, 'life.tw', },
    -- Libero.it
    {0, 4345, 'libero.it', },
}

gSSLCnamePatternList = {
    -- Catholic Education Australia
    {0, 4595, 'cg.catholic.edu.au', },
    {0, 4595, 'cgcatholic.org.au', },
    -- Stile
    {0, 4593, 'stileapp.com', },
    {0, 4593, 'stileeducation.com', },
    -- Zscaler
    {0, 4592, 'zscaler.com', },
    {0, 4592, 'zscaler.net', },
    {0, 4592, 'zscalerone.net', },
    {0, 4592, 'zscalertwo.net', },
    {0, 4592, 'zscalerthree.net', },
    {0, 4592, 'zscalerbeta.net', },
    {0, 4592, 'zscloud.net', },
    -- Princess Polly
    {0, 4591, 'princesspolly.com', },
    -- Drift
    {0, 4589, 'drift.com', },
    -- Cloudinary
    {0, 4588, 'cloudinary.com', },
    -- Coolmath
    {0, 4587, 'coolmath.com', },
    {0, 4587, 'coolmath4kids.com', },
    {0, 4587, 'coolmathgames.com', },
    -- Noteflight
    {0, 4586, 'noteflight.com', },
    -- Onshape
    {0, 4585, 'onshape.com', },
    -- NelsonNet
    {0, 4584, 'nelsonnet.com.au', },
    -- Prodigy Games
    {0, 4583, 'prodigygame.com', },
    -- MawDoo3
    {0, 4536, 'mawdoo3.com', },
    -- Mathrubhumi
    {0, 4535, 'mathrubhumi.com', },
    -- CimaClub
    {0, 4534, 'cima-club.club', },
    -- iflix
    {0, 4526, 'iflix.com', },
    -- Youm7
    {0, 4381, 'youm7.com', },
    -- Xywycom
    {0, 4379, 'xywy.com', },
    -- Xcar
    {0, 4375, 'xcar.com.cn', },
    -- Wowhead
    {0, 4372, 'wowhead.com', },
    {0, 4372, 'wow.zamimg.com', },
    -- WIX
    {0, 4371, 'wix.com', },
    -- Wirtualna Polska
    {0, 4369, 'wp.pl', },
    -- Udemy
    {0, 4353, 'udemy.com', },
    -- wikiHow
    {0, 4368, 'wikihow.com', },
    {0, 4368, 'wikihow.cz', },
    {0, 4368, 'wikihow.it', },
    {0, 4368, 'wikihow.com.tr', },
    {0, 4368, 'wikihow.vn', },
    {0, 4368, 'wikihowfarsi.com', },
    -- Webtretho
    {0, 4366, 'webtretho.com', },
    -- weblio
    {0, 4365, 'weblio.jp', },
    -- Viral Thread
    {0, 4364, 'vt.co', },
    -- VICE
    {0, 4362, 'vice.com', },
    {0, 4362, 'vicetv.com', },
    -- Varzesh3
    {0, 4360, 'varzesh3.com', },
    -- UrduPoint.com
    {0, 4359, 'urdupoint.com', },
    -- Upwork
    {0, 4358, 'upwork.com', },
    -- Uptodown
    {0, 4357, 'uptodown.com', },
    {0, 4357, 'uptodown.io', },
    {0, 4357, 'uptodown.zendesk.com', },
    -- ups.com
    {0, 4356, 'ups.com', },
    {0, 4356, 'ups.inq.com', },
    -- UDN
    {0, 4354, 'udn.com', },
    -- LTN
    {0, 4352, 'ltn.com.tw', },
    -- Liputan 6
    {0, 4350, 'liputan6.com', },
    {0, 4350, 'liputan6.id', },
    -- LifeBuzz
    {0, 4347, 'lifebuzz.com', },
    -- Libero.it
    {0, 4345, 'libero.it', },
}

function DetectorInit(detectorInstance)

    gDetector = detectorInstance;

    if gDetector.addSSLCertPattern then
        for i,v in ipairs(gSSLHostPatternList) do
            gDetector:addSSLCertPattern(v[1],v[2],v[3]);
        end
    end

    if gDetector.addSSLCnamePattern then
        for i,v in ipairs(gSSLCnamePatternList) do
            gDetector:addSSLCnamePattern(v[1],v[2],v[3]);
        end
    end

    return gDetector;
end

function DetectorClean()
end