package main

import (
	"fmt"
	"strings"
	"time"
)

func (d *Descriptor) genNewCloner(sb *strings.Builder) {
	fmt.Fprintf(sb, "// %s represents any type exposing a method\n",
		d.ClonerInterfaceName())
	fmt.Fprintf(sb, "// like %s.WithToken.\n", d.APIStructName())
	fmt.Fprintf(sb, "type %s interface {\n", d.ClonerInterfaceName())
	fmt.Fprintf(sb, "\tWithToken(token string) %s\n", d.CallerInterfaceName())
	fmt.Fprint(sb, "}\n\n")
}

// GenClonersGo generates cloners.go.
func GenClonersGo(file string) {
	var sb strings.Builder
	fmt.Fprint(&sb, "// Code generated by go generate; DO NOT EDIT.\n")
	fmt.Fprintf(&sb, "// %s\n\n", time.Now())
	fmt.Fprint(&sb, "package ooapi\n\n")
	fmt.Fprintf(&sb, "//go:generate go run ./internal/generator -file %s\n\n", file)
	for _, desc := range Descriptors {
		if !desc.RequiresLogin {
			continue
		}
		desc.genNewCloner(&sb)
	}
	writefile(file, &sb)
}
