package main

import (
	"fmt"
	"strings"
	"time"
)

func (d *Descriptor) genNewCaller(sb *strings.Builder) {
	fmt.Fprintf(sb, "// %s represents any type exposing a method\n",
		d.CallerInterfaceName())
	fmt.Fprintf(sb, "// like %s.Call.\n", d.APIStructName())
	fmt.Fprintf(sb, "type %s interface {\n", d.CallerInterfaceName())
	fmt.Fprintf(sb, "\tCall(ctx context.Context, req %s) (%s, error)\n",
		d.RequestTypeName(), d.ResponseTypeName())
	fmt.Fprint(sb, "}\n\n")
}

// GenCallersGo generates callers.go.
func GenCallersGo(file string) {
	var sb strings.Builder
	fmt.Fprint(&sb, "// Code generated by go generate; DO NOT EDIT.\n")
	fmt.Fprintf(&sb, "// %s\n\n", time.Now())
	fmt.Fprint(&sb, "package ooapi\n\n")
	fmt.Fprintf(&sb, "//go:generate go run ./internal/generator -file %s\n\n", file)
	fmt.Fprint(&sb, "import (\n")
	fmt.Fprint(&sb, "\t\"context\"\n")
	fmt.Fprint(&sb, "\n")
	fmt.Fprint(&sb, "\t\"github.com/ooni/probe-cli/v3/internal/ooapi/apimodel\"\n")
	fmt.Fprint(&sb, ")\n")
	for _, desc := range Descriptors {
		desc.genNewCaller(&sb)
	}
	writefile(file, &sb)
}
