# -*- coding: UTF-8 -*-
# Code automatically generated by pycrate_asn1c

from pycrate_asn1rt.utils            import *
from pycrate_asn1rt.err              import *
from pycrate_asn1rt.glob             import make_GLOBAL, GLOBAL
from pycrate_asn1rt.dictobj          import ASN1Dict
from pycrate_asn1rt.refobj           import *
from pycrate_asn1rt.setobj           import *
from pycrate_asn1rt.asnobj_basic     import *
from pycrate_asn1rt.asnobj_str       import *
from pycrate_asn1rt.asnobj_construct import *
from pycrate_asn1rt.asnobj_class     import *
from pycrate_asn1rt.asnobj_ext       import *
from pycrate_asn1rt.init             import init_modules

class PKIX1Explicit88:

    _name_  = u'PKIX1Explicit88'
    _oid_   = [1, 3, 6, 1, 5, 5, 7, 0, 18]
    
    _obj_ = [
        u'id-pkix',
        u'id-pe',
        u'id-qt',
        u'id-kp',
        u'id-ad',
        u'id-qt-cps',
        u'id-qt-unotice',
        u'id-ad-ocsp',
        u'id-ad-caIssuers',
        u'id-ad-timeStamping',
        u'id-ad-caRepository',
        u'Attribute',
        u'AttributeType',
        u'AttributeValue',
        u'AttributeTypeAndValue',
        u'id-at',
        u'id-at-name',
        u'id-at-surname',
        u'id-at-givenName',
        u'id-at-initials',
        u'id-at-generationQualifier',
        u'X520name',
        u'id-at-commonName',
        u'X520CommonName',
        u'id-at-localityName',
        u'X520LocalityName',
        u'id-at-stateOrProvinceName',
        u'X520StateOrProvinceName',
        u'id-at-organizationName',
        u'X520OrganizationName',
        u'id-at-organizationalUnitName',
        u'X520OrganizationalUnitName',
        u'id-at-title',
        u'X520Title',
        u'id-at-dnQualifier',
        u'X520dnQualifier',
        u'id-at-countryName',
        u'X520countryName',
        u'id-at-serialNumber',
        u'X520SerialNumber',
        u'id-at-pseudonym',
        u'X520Pseudonym',
        u'id-domainComponent',
        u'DomainComponent',
        u'pkcs-9',
        u'id-emailAddress',
        u'EmailAddress',
        u'Name',
        u'RDNSequence',
        u'DistinguishedName',
        u'RelativeDistinguishedName',
        u'DirectoryString',
        u'Certificate',
        u'TBSCertificate',
        u'Version',
        u'CertificateSerialNumber',
        u'Validity',
        u'Time',
        u'UniqueIdentifier',
        u'SubjectPublicKeyInfo',
        u'Extensions',
        u'Extension',
        u'CertificateList',
        u'TBSCertList',
        u'AlgorithmIdentifier',
        u'ORAddress',
        u'BuiltInStandardAttributes',
        u'CountryName',
        u'AdministrationDomainName',
        u'NetworkAddress',
        u'X121Address',
        u'TerminalIdentifier',
        u'PrivateDomainName',
        u'OrganizationName',
        u'NumericUserIdentifier',
        u'PersonalName',
        u'OrganizationalUnitNames',
        u'OrganizationalUnitName',
        u'BuiltInDomainDefinedAttributes',
        u'BuiltInDomainDefinedAttribute',
        u'ExtensionAttributes',
        u'ExtensionAttribute',
        u'common-name',
        u'CommonName',
        u'teletex-common-name',
        u'TeletexCommonName',
        u'teletex-organization-name',
        u'TeletexOrganizationName',
        u'teletex-personal-name',
        u'TeletexPersonalName',
        u'teletex-organizational-unit-names',
        u'TeletexOrganizationalUnitNames',
        u'TeletexOrganizationalUnitName',
        u'pds-name',
        u'PDSName',
        u'physical-delivery-country-name',
        u'PhysicalDeliveryCountryName',
        u'postal-code',
        u'PostalCode',
        u'physical-delivery-office-name',
        u'PhysicalDeliveryOfficeName',
        u'physical-delivery-office-number',
        u'PhysicalDeliveryOfficeNumber',
        u'extension-OR-address-components',
        u'ExtensionORAddressComponents',
        u'physical-delivery-personal-name',
        u'PhysicalDeliveryPersonalName',
        u'physical-delivery-organization-name',
        u'PhysicalDeliveryOrganizationName',
        u'extension-physical-delivery-address-components',
        u'ExtensionPhysicalDeliveryAddressComponents',
        u'unformatted-postal-address',
        u'UnformattedPostalAddress',
        u'street-address',
        u'StreetAddress',
        u'post-office-box-address',
        u'PostOfficeBoxAddress',
        u'poste-restante-address',
        u'PosteRestanteAddress',
        u'unique-postal-name',
        u'UniquePostalName',
        u'local-postal-attributes',
        u'LocalPostalAttributes',
        u'PDSParameter',
        u'extended-network-address',
        u'ExtendedNetworkAddress',
        u'PresentationAddress',
        u'terminal-type',
        u'TerminalType',
        u'teletex-domain-defined-attributes',
        u'TeletexDomainDefinedAttributes',
        u'TeletexDomainDefinedAttribute',
        u'ub-name',
        u'ub-common-name',
        u'ub-locality-name',
        u'ub-state-name',
        u'ub-organization-name',
        u'ub-organizational-unit-name',
        u'ub-title',
        u'ub-serial-number',
        u'ub-match',
        u'ub-emailaddress-length',
        u'ub-common-name-length',
        u'ub-country-name-alpha-length',
        u'ub-country-name-numeric-length',
        u'ub-domain-defined-attributes',
        u'ub-domain-defined-attribute-type-length',
        u'ub-domain-defined-attribute-value-length',
        u'ub-domain-name-length',
        u'ub-extension-attributes',
        u'ub-e163-4-number-length',
        u'ub-e163-4-sub-address-length',
        u'ub-generation-qualifier-length',
        u'ub-given-name-length',
        u'ub-initials-length',
        u'ub-integer-options',
        u'ub-numeric-user-id-length',
        u'ub-organization-name-length',
        u'ub-organizational-unit-name-length',
        u'ub-organizational-units',
        u'ub-pds-name-length',
        u'ub-pds-parameter-length',
        u'ub-pds-physical-address-lines',
        u'ub-postal-code-length',
        u'ub-pseudonym',
        u'ub-surname-length',
        u'ub-terminal-id-length',
        u'ub-unformatted-address-length',
        u'ub-x121-address-length',
        ]
    _type_ = [
        u'Attribute',
        u'AttributeType',
        u'AttributeValue',
        u'AttributeTypeAndValue',
        u'X520name',
        u'X520CommonName',
        u'X520LocalityName',
        u'X520StateOrProvinceName',
        u'X520OrganizationName',
        u'X520OrganizationalUnitName',
        u'X520Title',
        u'X520dnQualifier',
        u'X520countryName',
        u'X520SerialNumber',
        u'X520Pseudonym',
        u'DomainComponent',
        u'EmailAddress',
        u'Name',
        u'RDNSequence',
        u'DistinguishedName',
        u'RelativeDistinguishedName',
        u'DirectoryString',
        u'Certificate',
        u'TBSCertificate',
        u'Version',
        u'CertificateSerialNumber',
        u'Validity',
        u'Time',
        u'UniqueIdentifier',
        u'SubjectPublicKeyInfo',
        u'Extensions',
        u'Extension',
        u'CertificateList',
        u'TBSCertList',
        u'AlgorithmIdentifier',
        u'ORAddress',
        u'BuiltInStandardAttributes',
        u'CountryName',
        u'AdministrationDomainName',
        u'NetworkAddress',
        u'X121Address',
        u'TerminalIdentifier',
        u'PrivateDomainName',
        u'OrganizationName',
        u'NumericUserIdentifier',
        u'PersonalName',
        u'OrganizationalUnitNames',
        u'OrganizationalUnitName',
        u'BuiltInDomainDefinedAttributes',
        u'BuiltInDomainDefinedAttribute',
        u'ExtensionAttributes',
        u'ExtensionAttribute',
        u'CommonName',
        u'TeletexCommonName',
        u'TeletexOrganizationName',
        u'TeletexPersonalName',
        u'TeletexOrganizationalUnitNames',
        u'TeletexOrganizationalUnitName',
        u'PDSName',
        u'PhysicalDeliveryCountryName',
        u'PostalCode',
        u'PhysicalDeliveryOfficeName',
        u'PhysicalDeliveryOfficeNumber',
        u'ExtensionORAddressComponents',
        u'PhysicalDeliveryPersonalName',
        u'PhysicalDeliveryOrganizationName',
        u'ExtensionPhysicalDeliveryAddressComponents',
        u'UnformattedPostalAddress',
        u'StreetAddress',
        u'PostOfficeBoxAddress',
        u'PosteRestanteAddress',
        u'UniquePostalName',
        u'LocalPostalAttributes',
        u'PDSParameter',
        u'ExtendedNetworkAddress',
        u'PresentationAddress',
        u'TerminalType',
        u'TeletexDomainDefinedAttributes',
        u'TeletexDomainDefinedAttribute',
        ]
    _set_ = [
        ]
    _val_ = [
        u'id-pkix',
        u'id-pe',
        u'id-qt',
        u'id-kp',
        u'id-ad',
        u'id-qt-cps',
        u'id-qt-unotice',
        u'id-ad-ocsp',
        u'id-ad-caIssuers',
        u'id-ad-timeStamping',
        u'id-ad-caRepository',
        u'id-at',
        u'id-at-name',
        u'id-at-surname',
        u'id-at-givenName',
        u'id-at-initials',
        u'id-at-generationQualifier',
        u'id-at-commonName',
        u'id-at-localityName',
        u'id-at-stateOrProvinceName',
        u'id-at-organizationName',
        u'id-at-organizationalUnitName',
        u'id-at-title',
        u'id-at-dnQualifier',
        u'id-at-countryName',
        u'id-at-serialNumber',
        u'id-at-pseudonym',
        u'id-domainComponent',
        u'pkcs-9',
        u'id-emailAddress',
        u'common-name',
        u'teletex-common-name',
        u'teletex-organization-name',
        u'teletex-personal-name',
        u'teletex-organizational-unit-names',
        u'pds-name',
        u'physical-delivery-country-name',
        u'postal-code',
        u'physical-delivery-office-name',
        u'physical-delivery-office-number',
        u'extension-OR-address-components',
        u'physical-delivery-personal-name',
        u'physical-delivery-organization-name',
        u'extension-physical-delivery-address-components',
        u'unformatted-postal-address',
        u'street-address',
        u'post-office-box-address',
        u'poste-restante-address',
        u'unique-postal-name',
        u'local-postal-attributes',
        u'extended-network-address',
        u'terminal-type',
        u'teletex-domain-defined-attributes',
        u'ub-name',
        u'ub-common-name',
        u'ub-locality-name',
        u'ub-state-name',
        u'ub-organization-name',
        u'ub-organizational-unit-name',
        u'ub-title',
        u'ub-serial-number',
        u'ub-match',
        u'ub-emailaddress-length',
        u'ub-common-name-length',
        u'ub-country-name-alpha-length',
        u'ub-country-name-numeric-length',
        u'ub-domain-defined-attributes',
        u'ub-domain-defined-attribute-type-length',
        u'ub-domain-defined-attribute-value-length',
        u'ub-domain-name-length',
        u'ub-extension-attributes',
        u'ub-e163-4-number-length',
        u'ub-e163-4-sub-address-length',
        u'ub-generation-qualifier-length',
        u'ub-given-name-length',
        u'ub-initials-length',
        u'ub-integer-options',
        u'ub-numeric-user-id-length',
        u'ub-organization-name-length',
        u'ub-organizational-unit-name-length',
        u'ub-organizational-units',
        u'ub-pds-name-length',
        u'ub-pds-parameter-length',
        u'ub-pds-physical-address-lines',
        u'ub-postal-code-length',
        u'ub-pseudonym',
        u'ub-surname-length',
        u'ub-terminal-id-length',
        u'ub-unformatted-address-length',
        u'ub-x121-address-length',
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< id-pkix >-----#
    id_pkix = OID(name=u'id-pkix', mode=MODE_VALUE)
    id_pkix._val = (1, 3, 6, 1, 5, 5, 7)
    
    #-----< id-pe >-----#
    id_pe = OID(name=u'id-pe', mode=MODE_VALUE)
    id_pe._val = (1, 3, 6, 1, 5, 5, 7, 1)
    
    #-----< id-qt >-----#
    id_qt = OID(name=u'id-qt', mode=MODE_VALUE)
    id_qt._val = (1, 3, 6, 1, 5, 5, 7, 2)
    
    #-----< id-kp >-----#
    id_kp = OID(name=u'id-kp', mode=MODE_VALUE)
    id_kp._val = (1, 3, 6, 1, 5, 5, 7, 3)
    
    #-----< id-ad >-----#
    id_ad = OID(name=u'id-ad', mode=MODE_VALUE)
    id_ad._val = (1, 3, 6, 1, 5, 5, 7, 48)
    
    #-----< id-qt-cps >-----#
    id_qt_cps = OID(name=u'id-qt-cps', mode=MODE_VALUE)
    id_qt_cps._val = (1, 3, 6, 1, 5, 5, 7, 2, 1)
    
    #-----< id-qt-unotice >-----#
    id_qt_unotice = OID(name=u'id-qt-unotice', mode=MODE_VALUE)
    id_qt_unotice._val = (1, 3, 6, 1, 5, 5, 7, 2, 2)
    
    #-----< id-ad-ocsp >-----#
    id_ad_ocsp = OID(name=u'id-ad-ocsp', mode=MODE_VALUE)
    id_ad_ocsp._val = (1, 3, 6, 1, 5, 5, 7, 48, 1)
    
    #-----< id-ad-caIssuers >-----#
    id_ad_caIssuers = OID(name=u'id-ad-caIssuers', mode=MODE_VALUE)
    id_ad_caIssuers._val = (1, 3, 6, 1, 5, 5, 7, 48, 2)
    
    #-----< id-ad-timeStamping >-----#
    id_ad_timeStamping = OID(name=u'id-ad-timeStamping', mode=MODE_VALUE)
    id_ad_timeStamping._val = (1, 3, 6, 1, 5, 5, 7, 48, 3)
    
    #-----< id-ad-caRepository >-----#
    id_ad_caRepository = OID(name=u'id-ad-caRepository', mode=MODE_VALUE)
    id_ad_caRepository._val = (1, 3, 6, 1, 5, 5, 7, 48, 5)
    
    #-----< Attribute >-----#
    Attribute = SEQ(name=u'Attribute', mode=MODE_TYPE)
    _Attribute_type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'AttributeType')))
    _Attribute_values = SET_OF(name=u'values', mode=MODE_TYPE)
    __Attribute_values__item_ = ANY(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'AttributeValue')))
    _Attribute_values._cont = __Attribute_values__item_
    Attribute._cont = ASN1Dict([
        (u'type', _Attribute_type),
        (u'values', _Attribute_values),
        ])
    Attribute._ext = None
    
    #-----< AttributeType >-----#
    AttributeType = OID(name=u'AttributeType', mode=MODE_TYPE)
    
    #-----< AttributeValue >-----#
    AttributeValue = ANY(name=u'AttributeValue', mode=MODE_TYPE)
    
    #-----< AttributeTypeAndValue >-----#
    AttributeTypeAndValue = SEQ(name=u'AttributeTypeAndValue', mode=MODE_TYPE)
    _AttributeTypeAndValue_type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'AttributeType')))
    _AttributeTypeAndValue_value = ANY(name=u'value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'AttributeValue')))
    AttributeTypeAndValue._cont = ASN1Dict([
        (u'type', _AttributeTypeAndValue_type),
        (u'value', _AttributeTypeAndValue_value),
        ])
    AttributeTypeAndValue._ext = None
    
    #-----< id-at >-----#
    id_at = OID(name=u'id-at', mode=MODE_VALUE)
    id_at._val = (2, 5, 4)
    
    #-----< id-at-name >-----#
    id_at_name = OID(name=u'id-at-name', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit88', 'AttributeType')))
    id_at_name._val = (2, 5, 4, 41)
    
    #-----< id-at-surname >-----#
    id_at_surname = OID(name=u'id-at-surname', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit88', 'AttributeType')))
    id_at_surname._val = (2, 5, 4, 4)
    
    #-----< id-at-givenName >-----#
    id_at_givenName = OID(name=u'id-at-givenName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit88', 'AttributeType')))
    id_at_givenName._val = (2, 5, 4, 42)
    
    #-----< id-at-initials >-----#
    id_at_initials = OID(name=u'id-at-initials', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit88', 'AttributeType')))
    id_at_initials._val = (2, 5, 4, 43)
    
    #-----< id-at-generationQualifier >-----#
    id_at_generationQualifier = OID(name=u'id-at-generationQualifier', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit88', 'AttributeType')))
    id_at_generationQualifier._val = (2, 5, 4, 44)
    
    #-----< X520name >-----#
    X520name = CHOICE(name=u'X520name', mode=MODE_TYPE)
    _X520name_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _X520name_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32768)], ev=None, er=[])
    _X520name_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _X520name_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32768)], ev=None, er=[])
    _X520name_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _X520name_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32768)], ev=None, er=[])
    _X520name_utf8String = STR_UTF8(name=u'utf8String', mode=MODE_TYPE)
    _X520name_utf8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32768)], ev=None, er=[])
    _X520name_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _X520name_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32768)], ev=None, er=[])
    X520name._cont = ASN1Dict([
        (u'teletexString', _X520name_teletexString),
        (u'printableString', _X520name_printableString),
        (u'universalString', _X520name_universalString),
        (u'utf8String', _X520name_utf8String),
        (u'bmpString', _X520name_bmpString),
        ])
    X520name._ext = None
    
    #-----< id-at-commonName >-----#
    id_at_commonName = OID(name=u'id-at-commonName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit88', 'AttributeType')))
    id_at_commonName._val = (2, 5, 4, 3)
    
    #-----< X520CommonName >-----#
    X520CommonName = CHOICE(name=u'X520CommonName', mode=MODE_TYPE)
    _X520CommonName_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _X520CommonName_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520CommonName_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _X520CommonName_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520CommonName_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _X520CommonName_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520CommonName_utf8String = STR_UTF8(name=u'utf8String', mode=MODE_TYPE)
    _X520CommonName_utf8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520CommonName_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _X520CommonName_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    X520CommonName._cont = ASN1Dict([
        (u'teletexString', _X520CommonName_teletexString),
        (u'printableString', _X520CommonName_printableString),
        (u'universalString', _X520CommonName_universalString),
        (u'utf8String', _X520CommonName_utf8String),
        (u'bmpString', _X520CommonName_bmpString),
        ])
    X520CommonName._ext = None
    
    #-----< id-at-localityName >-----#
    id_at_localityName = OID(name=u'id-at-localityName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit88', 'AttributeType')))
    id_at_localityName._val = (2, 5, 4, 7)
    
    #-----< X520LocalityName >-----#
    X520LocalityName = CHOICE(name=u'X520LocalityName', mode=MODE_TYPE)
    _X520LocalityName_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _X520LocalityName_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _X520LocalityName_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _X520LocalityName_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _X520LocalityName_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _X520LocalityName_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _X520LocalityName_utf8String = STR_UTF8(name=u'utf8String', mode=MODE_TYPE)
    _X520LocalityName_utf8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _X520LocalityName_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _X520LocalityName_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    X520LocalityName._cont = ASN1Dict([
        (u'teletexString', _X520LocalityName_teletexString),
        (u'printableString', _X520LocalityName_printableString),
        (u'universalString', _X520LocalityName_universalString),
        (u'utf8String', _X520LocalityName_utf8String),
        (u'bmpString', _X520LocalityName_bmpString),
        ])
    X520LocalityName._ext = None
    
    #-----< id-at-stateOrProvinceName >-----#
    id_at_stateOrProvinceName = OID(name=u'id-at-stateOrProvinceName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit88', 'AttributeType')))
    id_at_stateOrProvinceName._val = (2, 5, 4, 8)
    
    #-----< X520StateOrProvinceName >-----#
    X520StateOrProvinceName = CHOICE(name=u'X520StateOrProvinceName', mode=MODE_TYPE)
    _X520StateOrProvinceName_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _X520StateOrProvinceName_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _X520StateOrProvinceName_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _X520StateOrProvinceName_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _X520StateOrProvinceName_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _X520StateOrProvinceName_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _X520StateOrProvinceName_utf8String = STR_UTF8(name=u'utf8String', mode=MODE_TYPE)
    _X520StateOrProvinceName_utf8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _X520StateOrProvinceName_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _X520StateOrProvinceName_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    X520StateOrProvinceName._cont = ASN1Dict([
        (u'teletexString', _X520StateOrProvinceName_teletexString),
        (u'printableString', _X520StateOrProvinceName_printableString),
        (u'universalString', _X520StateOrProvinceName_universalString),
        (u'utf8String', _X520StateOrProvinceName_utf8String),
        (u'bmpString', _X520StateOrProvinceName_bmpString),
        ])
    X520StateOrProvinceName._ext = None
    
    #-----< id-at-organizationName >-----#
    id_at_organizationName = OID(name=u'id-at-organizationName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit88', 'AttributeType')))
    id_at_organizationName._val = (2, 5, 4, 10)
    
    #-----< X520OrganizationName >-----#
    X520OrganizationName = CHOICE(name=u'X520OrganizationName', mode=MODE_TYPE)
    _X520OrganizationName_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _X520OrganizationName_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520OrganizationName_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _X520OrganizationName_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520OrganizationName_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _X520OrganizationName_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520OrganizationName_utf8String = STR_UTF8(name=u'utf8String', mode=MODE_TYPE)
    _X520OrganizationName_utf8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520OrganizationName_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _X520OrganizationName_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    X520OrganizationName._cont = ASN1Dict([
        (u'teletexString', _X520OrganizationName_teletexString),
        (u'printableString', _X520OrganizationName_printableString),
        (u'universalString', _X520OrganizationName_universalString),
        (u'utf8String', _X520OrganizationName_utf8String),
        (u'bmpString', _X520OrganizationName_bmpString),
        ])
    X520OrganizationName._ext = None
    
    #-----< id-at-organizationalUnitName >-----#
    id_at_organizationalUnitName = OID(name=u'id-at-organizationalUnitName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit88', 'AttributeType')))
    id_at_organizationalUnitName._val = (2, 5, 4, 11)
    
    #-----< X520OrganizationalUnitName >-----#
    X520OrganizationalUnitName = CHOICE(name=u'X520OrganizationalUnitName', mode=MODE_TYPE)
    _X520OrganizationalUnitName_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _X520OrganizationalUnitName_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520OrganizationalUnitName_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _X520OrganizationalUnitName_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520OrganizationalUnitName_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _X520OrganizationalUnitName_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520OrganizationalUnitName_utf8String = STR_UTF8(name=u'utf8String', mode=MODE_TYPE)
    _X520OrganizationalUnitName_utf8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520OrganizationalUnitName_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _X520OrganizationalUnitName_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    X520OrganizationalUnitName._cont = ASN1Dict([
        (u'teletexString', _X520OrganizationalUnitName_teletexString),
        (u'printableString', _X520OrganizationalUnitName_printableString),
        (u'universalString', _X520OrganizationalUnitName_universalString),
        (u'utf8String', _X520OrganizationalUnitName_utf8String),
        (u'bmpString', _X520OrganizationalUnitName_bmpString),
        ])
    X520OrganizationalUnitName._ext = None
    
    #-----< id-at-title >-----#
    id_at_title = OID(name=u'id-at-title', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit88', 'AttributeType')))
    id_at_title._val = (2, 5, 4, 12)
    
    #-----< X520Title >-----#
    X520Title = CHOICE(name=u'X520Title', mode=MODE_TYPE)
    _X520Title_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _X520Title_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520Title_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _X520Title_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520Title_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _X520Title_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520Title_utf8String = STR_UTF8(name=u'utf8String', mode=MODE_TYPE)
    _X520Title_utf8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520Title_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _X520Title_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    X520Title._cont = ASN1Dict([
        (u'teletexString', _X520Title_teletexString),
        (u'printableString', _X520Title_printableString),
        (u'universalString', _X520Title_universalString),
        (u'utf8String', _X520Title_utf8String),
        (u'bmpString', _X520Title_bmpString),
        ])
    X520Title._ext = None
    
    #-----< id-at-dnQualifier >-----#
    id_at_dnQualifier = OID(name=u'id-at-dnQualifier', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit88', 'AttributeType')))
    id_at_dnQualifier._val = (2, 5, 4, 46)
    
    #-----< X520dnQualifier >-----#
    X520dnQualifier = STR_PRINT(name=u'X520dnQualifier', mode=MODE_TYPE)
    
    #-----< id-at-countryName >-----#
    id_at_countryName = OID(name=u'id-at-countryName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit88', 'AttributeType')))
    id_at_countryName._val = (2, 5, 4, 6)
    
    #-----< X520countryName >-----#
    X520countryName = STR_PRINT(name=u'X520countryName', mode=MODE_TYPE)
    X520countryName._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    
    #-----< id-at-serialNumber >-----#
    id_at_serialNumber = OID(name=u'id-at-serialNumber', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit88', 'AttributeType')))
    id_at_serialNumber._val = (2, 5, 4, 5)
    
    #-----< X520SerialNumber >-----#
    X520SerialNumber = STR_PRINT(name=u'X520SerialNumber', mode=MODE_TYPE)
    X520SerialNumber._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    
    #-----< id-at-pseudonym >-----#
    id_at_pseudonym = OID(name=u'id-at-pseudonym', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit88', 'AttributeType')))
    id_at_pseudonym._val = (2, 5, 4, 65)
    
    #-----< X520Pseudonym >-----#
    X520Pseudonym = CHOICE(name=u'X520Pseudonym', mode=MODE_TYPE)
    _X520Pseudonym_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _X520Pseudonym_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _X520Pseudonym_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _X520Pseudonym_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _X520Pseudonym_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _X520Pseudonym_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _X520Pseudonym_utf8String = STR_UTF8(name=u'utf8String', mode=MODE_TYPE)
    _X520Pseudonym_utf8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _X520Pseudonym_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _X520Pseudonym_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    X520Pseudonym._cont = ASN1Dict([
        (u'teletexString', _X520Pseudonym_teletexString),
        (u'printableString', _X520Pseudonym_printableString),
        (u'universalString', _X520Pseudonym_universalString),
        (u'utf8String', _X520Pseudonym_utf8String),
        (u'bmpString', _X520Pseudonym_bmpString),
        ])
    X520Pseudonym._ext = None
    
    #-----< id-domainComponent >-----#
    id_domainComponent = OID(name=u'id-domainComponent', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit88', 'AttributeType')))
    id_domainComponent._val = (0, 9, 2342, 19200300, 100, 1, 25)
    
    #-----< DomainComponent >-----#
    DomainComponent = STR_IA5(name=u'DomainComponent', mode=MODE_TYPE)
    
    #-----< pkcs-9 >-----#
    pkcs_9 = OID(name=u'pkcs-9', mode=MODE_VALUE)
    pkcs_9._val = (1, 2, 840, 113549, 1, 9)
    
    #-----< id-emailAddress >-----#
    id_emailAddress = OID(name=u'id-emailAddress', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit88', 'AttributeType')))
    id_emailAddress._val = (1, 2, 840, 113549, 1, 9, 1)
    
    #-----< EmailAddress >-----#
    EmailAddress = STR_IA5(name=u'EmailAddress', mode=MODE_TYPE)
    EmailAddress._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=255)], ev=None, er=[])
    
    #-----< Name >-----#
    Name = CHOICE(name=u'Name', mode=MODE_TYPE)
    _Name_rdnSequence = SEQ_OF(name=u'rdnSequence', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'RDNSequence')))
    Name._cont = ASN1Dict([
        (u'rdnSequence', _Name_rdnSequence),
        ])
    Name._ext = None
    
    #-----< RDNSequence >-----#
    RDNSequence = SEQ_OF(name=u'RDNSequence', mode=MODE_TYPE)
    _RDNSequence__item_ = SET_OF(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'RelativeDistinguishedName')))
    RDNSequence._cont = _RDNSequence__item_
    
    #-----< DistinguishedName >-----#
    DistinguishedName = SEQ_OF(name=u'DistinguishedName', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'RDNSequence')))
    
    #-----< RelativeDistinguishedName >-----#
    RelativeDistinguishedName = SET_OF(name=u'RelativeDistinguishedName', mode=MODE_TYPE)
    _RelativeDistinguishedName__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'AttributeTypeAndValue')))
    RelativeDistinguishedName._cont = _RelativeDistinguishedName__item_
    RelativeDistinguishedName._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< DirectoryString >-----#
    DirectoryString = CHOICE(name=u'DirectoryString', mode=MODE_TYPE)
    _DirectoryString_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _DirectoryString_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _DirectoryString_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _DirectoryString_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _DirectoryString_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _DirectoryString_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _DirectoryString_utf8String = STR_UTF8(name=u'utf8String', mode=MODE_TYPE)
    _DirectoryString_utf8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _DirectoryString_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _DirectoryString_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    DirectoryString._cont = ASN1Dict([
        (u'teletexString', _DirectoryString_teletexString),
        (u'printableString', _DirectoryString_printableString),
        (u'universalString', _DirectoryString_universalString),
        (u'utf8String', _DirectoryString_utf8String),
        (u'bmpString', _DirectoryString_bmpString),
        ])
    DirectoryString._ext = None
    
    #-----< Certificate >-----#
    Certificate = SEQ(name=u'Certificate', mode=MODE_TYPE)
    _Certificate_tbsCertificate = SEQ(name=u'tbsCertificate', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'TBSCertificate')))
    _Certificate_signatureAlgorithm = SEQ(name=u'signatureAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'AlgorithmIdentifier')))
    _Certificate_signature = BIT_STR(name=u'signature', mode=MODE_TYPE)
    Certificate._cont = ASN1Dict([
        (u'tbsCertificate', _Certificate_tbsCertificate),
        (u'signatureAlgorithm', _Certificate_signatureAlgorithm),
        (u'signature', _Certificate_signature),
        ])
    Certificate._ext = None
    
    #-----< TBSCertificate >-----#
    TBSCertificate = SEQ(name=u'TBSCertificate', mode=MODE_TYPE)
    _TBSCertificate_version = INT(name=u'version', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIX1Explicit88', 'Version')), default=0)
    _TBSCertificate_serialNumber = INT(name=u'serialNumber', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'CertificateSerialNumber')))
    _TBSCertificate_signature = SEQ(name=u'signature', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'AlgorithmIdentifier')))
    _TBSCertificate_issuer = CHOICE(name=u'issuer', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'Name')))
    _TBSCertificate_validity = SEQ(name=u'validity', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'Validity')))
    _TBSCertificate_subject = CHOICE(name=u'subject', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'Name')))
    _TBSCertificate_subjectPublicKeyInfo = SEQ(name=u'subjectPublicKeyInfo', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'SubjectPublicKeyInfo')))
    _TBSCertificate_issuerUniqueID = BIT_STR(name=u'issuerUniqueID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Explicit88', 'UniqueIdentifier')), opt=True)
    _TBSCertificate_subjectUniqueID = BIT_STR(name=u'subjectUniqueID', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Explicit88', 'UniqueIdentifier')), opt=True)
    _TBSCertificate_extensions = SEQ_OF(name=u'extensions', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIX1Explicit88', 'Extensions')), opt=True)
    TBSCertificate._cont = ASN1Dict([
        (u'version', _TBSCertificate_version),
        (u'serialNumber', _TBSCertificate_serialNumber),
        (u'signature', _TBSCertificate_signature),
        (u'issuer', _TBSCertificate_issuer),
        (u'validity', _TBSCertificate_validity),
        (u'subject', _TBSCertificate_subject),
        (u'subjectPublicKeyInfo', _TBSCertificate_subjectPublicKeyInfo),
        (u'issuerUniqueID', _TBSCertificate_issuerUniqueID),
        (u'subjectUniqueID', _TBSCertificate_subjectUniqueID),
        (u'extensions', _TBSCertificate_extensions),
        ])
    TBSCertificate._ext = None
    
    #-----< Version >-----#
    Version = INT(name=u'Version', mode=MODE_TYPE)
    Version._cont = ASN1Dict([(u'v1', 0), (u'v2', 1), (u'v3', 2)])
    
    #-----< CertificateSerialNumber >-----#
    CertificateSerialNumber = INT(name=u'CertificateSerialNumber', mode=MODE_TYPE)
    
    #-----< Validity >-----#
    Validity = SEQ(name=u'Validity', mode=MODE_TYPE)
    _Validity_notBefore = CHOICE(name=u'notBefore', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'Time')))
    _Validity_notAfter = CHOICE(name=u'notAfter', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'Time')))
    Validity._cont = ASN1Dict([
        (u'notBefore', _Validity_notBefore),
        (u'notAfter', _Validity_notAfter),
        ])
    Validity._ext = None
    
    #-----< Time >-----#
    Time = CHOICE(name=u'Time', mode=MODE_TYPE)
    _Time_utcTime = TIME_UTC(name=u'utcTime', mode=MODE_TYPE)
    _Time_generalTime = TIME_GEN(name=u'generalTime', mode=MODE_TYPE)
    Time._cont = ASN1Dict([
        (u'utcTime', _Time_utcTime),
        (u'generalTime', _Time_generalTime),
        ])
    Time._ext = None
    
    #-----< UniqueIdentifier >-----#
    UniqueIdentifier = BIT_STR(name=u'UniqueIdentifier', mode=MODE_TYPE)
    
    #-----< SubjectPublicKeyInfo >-----#
    SubjectPublicKeyInfo = SEQ(name=u'SubjectPublicKeyInfo', mode=MODE_TYPE)
    _SubjectPublicKeyInfo_algorithm = SEQ(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'AlgorithmIdentifier')))
    _SubjectPublicKeyInfo_subjectPublicKey = BIT_STR(name=u'subjectPublicKey', mode=MODE_TYPE)
    SubjectPublicKeyInfo._cont = ASN1Dict([
        (u'algorithm', _SubjectPublicKeyInfo_algorithm),
        (u'subjectPublicKey', _SubjectPublicKeyInfo_subjectPublicKey),
        ])
    SubjectPublicKeyInfo._ext = None
    
    #-----< Extensions >-----#
    Extensions = SEQ_OF(name=u'Extensions', mode=MODE_TYPE)
    _Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'Extension')))
    Extensions._cont = _Extensions__item_
    Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< Extension >-----#
    Extension = SEQ(name=u'Extension', mode=MODE_TYPE)
    _Extension_extnID = OID(name=u'extnID', mode=MODE_TYPE)
    _Extension_critical = BOOL(name=u'critical', mode=MODE_TYPE, default=False)
    _Extension_extnValue = OCT_STR(name=u'extnValue', mode=MODE_TYPE)
    Extension._cont = ASN1Dict([
        (u'extnID', _Extension_extnID),
        (u'critical', _Extension_critical),
        (u'extnValue', _Extension_extnValue),
        ])
    Extension._ext = None
    
    #-----< CertificateList >-----#
    CertificateList = SEQ(name=u'CertificateList', mode=MODE_TYPE)
    _CertificateList_tbsCertList = SEQ(name=u'tbsCertList', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'TBSCertList')))
    _CertificateList_signatureAlgorithm = SEQ(name=u'signatureAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'AlgorithmIdentifier')))
    _CertificateList_signature = BIT_STR(name=u'signature', mode=MODE_TYPE)
    CertificateList._cont = ASN1Dict([
        (u'tbsCertList', _CertificateList_tbsCertList),
        (u'signatureAlgorithm', _CertificateList_signatureAlgorithm),
        (u'signature', _CertificateList_signature),
        ])
    CertificateList._ext = None
    
    #-----< TBSCertList >-----#
    TBSCertList = SEQ(name=u'TBSCertList', mode=MODE_TYPE)
    _TBSCertList_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'Version')), opt=True)
    _TBSCertList_signature = SEQ(name=u'signature', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'AlgorithmIdentifier')))
    _TBSCertList_issuer = CHOICE(name=u'issuer', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'Name')))
    _TBSCertList_thisUpdate = CHOICE(name=u'thisUpdate', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'Time')))
    _TBSCertList_nextUpdate = CHOICE(name=u'nextUpdate', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'Time')), opt=True)
    _TBSCertList_revokedCertificates = SEQ_OF(name=u'revokedCertificates', mode=MODE_TYPE, opt=True)
    __TBSCertList_revokedCertificates__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    ___TBSCertList_revokedCertificates__item__userCertificate = INT(name=u'userCertificate', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'CertificateSerialNumber')))
    ___TBSCertList_revokedCertificates__item__revocationDate = CHOICE(name=u'revocationDate', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'Time')))
    ___TBSCertList_revokedCertificates__item__crlEntryExtensions = SEQ_OF(name=u'crlEntryExtensions', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'Extensions')), opt=True)
    __TBSCertList_revokedCertificates__item_._cont = ASN1Dict([
        (u'userCertificate', ___TBSCertList_revokedCertificates__item__userCertificate),
        (u'revocationDate', ___TBSCertList_revokedCertificates__item__revocationDate),
        (u'crlEntryExtensions', ___TBSCertList_revokedCertificates__item__crlEntryExtensions),
        ])
    __TBSCertList_revokedCertificates__item_._ext = None
    _TBSCertList_revokedCertificates._cont = __TBSCertList_revokedCertificates__item_
    _TBSCertList_crlExtensions = SEQ_OF(name=u'crlExtensions', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIX1Explicit88', 'Extensions')), opt=True)
    TBSCertList._cont = ASN1Dict([
        (u'version', _TBSCertList_version),
        (u'signature', _TBSCertList_signature),
        (u'issuer', _TBSCertList_issuer),
        (u'thisUpdate', _TBSCertList_thisUpdate),
        (u'nextUpdate', _TBSCertList_nextUpdate),
        (u'revokedCertificates', _TBSCertList_revokedCertificates),
        (u'crlExtensions', _TBSCertList_crlExtensions),
        ])
    TBSCertList._ext = None
    
    #-----< AlgorithmIdentifier >-----#
    AlgorithmIdentifier = SEQ(name=u'AlgorithmIdentifier', mode=MODE_TYPE)
    _AlgorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE)
    _AlgorithmIdentifier_parameters = ANY(name=u'parameters', mode=MODE_TYPE, opt=True, defby=u'algorithm')
    AlgorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _AlgorithmIdentifier_algorithm),
        (u'parameters', _AlgorithmIdentifier_parameters),
        ])
    AlgorithmIdentifier._ext = None
    
    #-----< ORAddress >-----#
    ORAddress = SEQ(name=u'ORAddress', mode=MODE_TYPE)
    _ORAddress_built_in_standard_attributes = SEQ(name=u'built-in-standard-attributes', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'BuiltInStandardAttributes')))
    _ORAddress_built_in_domain_defined_attributes = SEQ_OF(name=u'built-in-domain-defined-attributes', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'BuiltInDomainDefinedAttributes')), opt=True)
    _ORAddress_extension_attributes = SET_OF(name=u'extension-attributes', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'ExtensionAttributes')), opt=True)
    ORAddress._cont = ASN1Dict([
        (u'built-in-standard-attributes', _ORAddress_built_in_standard_attributes),
        (u'built-in-domain-defined-attributes', _ORAddress_built_in_domain_defined_attributes),
        (u'extension-attributes', _ORAddress_extension_attributes),
        ])
    ORAddress._ext = None
    
    #-----< BuiltInStandardAttributes >-----#
    BuiltInStandardAttributes = SEQ(name=u'BuiltInStandardAttributes', mode=MODE_TYPE)
    _BuiltInStandardAttributes_country_name = CHOICE(name=u'country-name', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'CountryName')), opt=True)
    _BuiltInStandardAttributes_administration_domain_name = CHOICE(name=u'administration-domain-name', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'AdministrationDomainName')), opt=True)
    _BuiltInStandardAttributes_network_address = STR_NUM(name=u'network-address', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Explicit88', 'NetworkAddress')), opt=True)
    _BuiltInStandardAttributes_terminal_identifier = STR_PRINT(name=u'terminal-identifier', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Explicit88', 'TerminalIdentifier')), opt=True)
    _BuiltInStandardAttributes_private_domain_name = CHOICE(name=u'private-domain-name', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIX1Explicit88', 'PrivateDomainName')), opt=True)
    _BuiltInStandardAttributes_organization_name = STR_PRINT(name=u'organization-name', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Explicit88', 'OrganizationName')), opt=True)
    _BuiltInStandardAttributes_numeric_user_identifier = STR_NUM(name=u'numeric-user-identifier', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Explicit88', 'NumericUserIdentifier')), opt=True)
    _BuiltInStandardAttributes_personal_name = SET(name=u'personal-name', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Explicit88', 'PersonalName')), opt=True)
    _BuiltInStandardAttributes_organizational_unit_names = SEQ_OF(name=u'organizational-unit-names', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Explicit88', 'OrganizationalUnitNames')), opt=True)
    BuiltInStandardAttributes._cont = ASN1Dict([
        (u'country-name', _BuiltInStandardAttributes_country_name),
        (u'administration-domain-name', _BuiltInStandardAttributes_administration_domain_name),
        (u'network-address', _BuiltInStandardAttributes_network_address),
        (u'terminal-identifier', _BuiltInStandardAttributes_terminal_identifier),
        (u'private-domain-name', _BuiltInStandardAttributes_private_domain_name),
        (u'organization-name', _BuiltInStandardAttributes_organization_name),
        (u'numeric-user-identifier', _BuiltInStandardAttributes_numeric_user_identifier),
        (u'personal-name', _BuiltInStandardAttributes_personal_name),
        (u'organizational-unit-names', _BuiltInStandardAttributes_organizational_unit_names),
        ])
    BuiltInStandardAttributes._ext = None
    
    #-----< CountryName >-----#
    CountryName = CHOICE(name=u'CountryName', mode=MODE_TYPE, tag=(1, TAG_APPLICATION, TAG_EXPLICIT))
    _CountryName_x121_dcc_code = STR_NUM(name=u'x121-dcc-code', mode=MODE_TYPE)
    _CountryName_x121_dcc_code._const_sz = ASN1Set(rv=[3], rr=[], ev=None, er=[])
    _CountryName_iso_3166_alpha2_code = STR_PRINT(name=u'iso-3166-alpha2-code', mode=MODE_TYPE)
    _CountryName_iso_3166_alpha2_code._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    CountryName._cont = ASN1Dict([
        (u'x121-dcc-code', _CountryName_x121_dcc_code),
        (u'iso-3166-alpha2-code', _CountryName_iso_3166_alpha2_code),
        ])
    CountryName._ext = None
    
    #-----< AdministrationDomainName >-----#
    AdministrationDomainName = CHOICE(name=u'AdministrationDomainName', mode=MODE_TYPE, tag=(2, TAG_APPLICATION, TAG_EXPLICIT))
    _AdministrationDomainName_numeric = STR_NUM(name=u'numeric', mode=MODE_TYPE)
    _AdministrationDomainName_numeric._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=16)], ev=None, er=[])
    _AdministrationDomainName_printable = STR_PRINT(name=u'printable', mode=MODE_TYPE)
    _AdministrationDomainName_printable._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=16)], ev=None, er=[])
    AdministrationDomainName._cont = ASN1Dict([
        (u'numeric', _AdministrationDomainName_numeric),
        (u'printable', _AdministrationDomainName_printable),
        ])
    AdministrationDomainName._ext = None
    
    #-----< NetworkAddress >-----#
    NetworkAddress = STR_NUM(name=u'NetworkAddress', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'X121Address')))
    
    #-----< X121Address >-----#
    X121Address = STR_NUM(name=u'X121Address', mode=MODE_TYPE)
    X121Address._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    
    #-----< TerminalIdentifier >-----#
    TerminalIdentifier = STR_PRINT(name=u'TerminalIdentifier', mode=MODE_TYPE)
    TerminalIdentifier._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=24)], ev=None, er=[])
    
    #-----< PrivateDomainName >-----#
    PrivateDomainName = CHOICE(name=u'PrivateDomainName', mode=MODE_TYPE)
    _PrivateDomainName_numeric = STR_NUM(name=u'numeric', mode=MODE_TYPE)
    _PrivateDomainName_numeric._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    _PrivateDomainName_printable = STR_PRINT(name=u'printable', mode=MODE_TYPE)
    _PrivateDomainName_printable._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    PrivateDomainName._cont = ASN1Dict([
        (u'numeric', _PrivateDomainName_numeric),
        (u'printable', _PrivateDomainName_printable),
        ])
    PrivateDomainName._ext = None
    
    #-----< OrganizationName >-----#
    OrganizationName = STR_PRINT(name=u'OrganizationName', mode=MODE_TYPE)
    OrganizationName._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    
    #-----< NumericUserIdentifier >-----#
    NumericUserIdentifier = STR_NUM(name=u'NumericUserIdentifier', mode=MODE_TYPE)
    NumericUserIdentifier._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    
    #-----< PersonalName >-----#
    PersonalName = SET(name=u'PersonalName', mode=MODE_TYPE)
    _PersonalName_surname = STR_PRINT(name=u'surname', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _PersonalName_surname._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=40)], ev=None, er=[])
    _PersonalName_given_name = STR_PRINT(name=u'given-name', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _PersonalName_given_name._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    _PersonalName_initials = STR_PRINT(name=u'initials', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _PersonalName_initials._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=5)], ev=None, er=[])
    _PersonalName_generation_qualifier = STR_PRINT(name=u'generation-qualifier', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _PersonalName_generation_qualifier._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=3)], ev=None, er=[])
    PersonalName._cont = ASN1Dict([
        (u'surname', _PersonalName_surname),
        (u'given-name', _PersonalName_given_name),
        (u'initials', _PersonalName_initials),
        (u'generation-qualifier', _PersonalName_generation_qualifier),
        ])
    PersonalName._ext = None
    
    #-----< OrganizationalUnitNames >-----#
    OrganizationalUnitNames = SEQ_OF(name=u'OrganizationalUnitNames', mode=MODE_TYPE)
    _OrganizationalUnitNames__item_ = STR_PRINT(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'OrganizationalUnitName')))
    OrganizationalUnitNames._cont = _OrganizationalUnitNames__item_
    OrganizationalUnitNames._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4)], ev=None, er=[])
    
    #-----< OrganizationalUnitName >-----#
    OrganizationalUnitName = STR_PRINT(name=u'OrganizationalUnitName', mode=MODE_TYPE)
    OrganizationalUnitName._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    
    #-----< BuiltInDomainDefinedAttributes >-----#
    BuiltInDomainDefinedAttributes = SEQ_OF(name=u'BuiltInDomainDefinedAttributes', mode=MODE_TYPE)
    _BuiltInDomainDefinedAttributes__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'BuiltInDomainDefinedAttribute')))
    BuiltInDomainDefinedAttributes._cont = _BuiltInDomainDefinedAttributes__item_
    BuiltInDomainDefinedAttributes._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4)], ev=None, er=[])
    
    #-----< BuiltInDomainDefinedAttribute >-----#
    BuiltInDomainDefinedAttribute = SEQ(name=u'BuiltInDomainDefinedAttribute', mode=MODE_TYPE)
    _BuiltInDomainDefinedAttribute_type = STR_PRINT(name=u'type', mode=MODE_TYPE)
    _BuiltInDomainDefinedAttribute_type._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    _BuiltInDomainDefinedAttribute_value = STR_PRINT(name=u'value', mode=MODE_TYPE)
    _BuiltInDomainDefinedAttribute_value._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    BuiltInDomainDefinedAttribute._cont = ASN1Dict([
        (u'type', _BuiltInDomainDefinedAttribute_type),
        (u'value', _BuiltInDomainDefinedAttribute_value),
        ])
    BuiltInDomainDefinedAttribute._ext = None
    
    #-----< ExtensionAttributes >-----#
    ExtensionAttributes = SET_OF(name=u'ExtensionAttributes', mode=MODE_TYPE)
    _ExtensionAttributes__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'ExtensionAttribute')))
    ExtensionAttributes._cont = _ExtensionAttributes__item_
    ExtensionAttributes._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    
    #-----< ExtensionAttribute >-----#
    ExtensionAttribute = SEQ(name=u'ExtensionAttribute', mode=MODE_TYPE)
    _ExtensionAttribute_extension_attribute_type = INT(name=u'extension-attribute-type', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ExtensionAttribute_extension_attribute_type._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=256)], ev=None, er=[])
    _ExtensionAttribute_extension_attribute_value = ANY(name=u'extension-attribute-value', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), defby=u'extension-attribute-type')
    ExtensionAttribute._cont = ASN1Dict([
        (u'extension-attribute-type', _ExtensionAttribute_extension_attribute_type),
        (u'extension-attribute-value', _ExtensionAttribute_extension_attribute_value),
        ])
    ExtensionAttribute._ext = None
    
    #-----< common-name >-----#
    common_name = INT(name=u'common-name', mode=MODE_VALUE)
    common_name._val = 1
    
    #-----< CommonName >-----#
    CommonName = STR_PRINT(name=u'CommonName', mode=MODE_TYPE)
    CommonName._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    
    #-----< teletex-common-name >-----#
    teletex_common_name = INT(name=u'teletex-common-name', mode=MODE_VALUE)
    teletex_common_name._val = 2
    
    #-----< TeletexCommonName >-----#
    TeletexCommonName = STR_TELE(name=u'TeletexCommonName', mode=MODE_TYPE)
    TeletexCommonName._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    
    #-----< teletex-organization-name >-----#
    teletex_organization_name = INT(name=u'teletex-organization-name', mode=MODE_VALUE)
    teletex_organization_name._val = 3
    
    #-----< TeletexOrganizationName >-----#
    TeletexOrganizationName = STR_TELE(name=u'TeletexOrganizationName', mode=MODE_TYPE)
    TeletexOrganizationName._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    
    #-----< teletex-personal-name >-----#
    teletex_personal_name = INT(name=u'teletex-personal-name', mode=MODE_VALUE)
    teletex_personal_name._val = 4
    
    #-----< TeletexPersonalName >-----#
    TeletexPersonalName = SET(name=u'TeletexPersonalName', mode=MODE_TYPE)
    _TeletexPersonalName_surname = STR_TELE(name=u'surname', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _TeletexPersonalName_surname._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=40)], ev=None, er=[])
    _TeletexPersonalName_given_name = STR_TELE(name=u'given-name', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _TeletexPersonalName_given_name._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    _TeletexPersonalName_initials = STR_TELE(name=u'initials', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _TeletexPersonalName_initials._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=5)], ev=None, er=[])
    _TeletexPersonalName_generation_qualifier = STR_TELE(name=u'generation-qualifier', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _TeletexPersonalName_generation_qualifier._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=3)], ev=None, er=[])
    TeletexPersonalName._cont = ASN1Dict([
        (u'surname', _TeletexPersonalName_surname),
        (u'given-name', _TeletexPersonalName_given_name),
        (u'initials', _TeletexPersonalName_initials),
        (u'generation-qualifier', _TeletexPersonalName_generation_qualifier),
        ])
    TeletexPersonalName._ext = None
    
    #-----< teletex-organizational-unit-names >-----#
    teletex_organizational_unit_names = INT(name=u'teletex-organizational-unit-names', mode=MODE_VALUE)
    teletex_organizational_unit_names._val = 5
    
    #-----< TeletexOrganizationalUnitNames >-----#
    TeletexOrganizationalUnitNames = SEQ_OF(name=u'TeletexOrganizationalUnitNames', mode=MODE_TYPE)
    _TeletexOrganizationalUnitNames__item_ = STR_TELE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'TeletexOrganizationalUnitName')))
    TeletexOrganizationalUnitNames._cont = _TeletexOrganizationalUnitNames__item_
    TeletexOrganizationalUnitNames._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4)], ev=None, er=[])
    
    #-----< TeletexOrganizationalUnitName >-----#
    TeletexOrganizationalUnitName = STR_TELE(name=u'TeletexOrganizationalUnitName', mode=MODE_TYPE)
    TeletexOrganizationalUnitName._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    
    #-----< pds-name >-----#
    pds_name = INT(name=u'pds-name', mode=MODE_VALUE)
    pds_name._val = 7
    
    #-----< PDSName >-----#
    PDSName = STR_PRINT(name=u'PDSName', mode=MODE_TYPE)
    PDSName._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    
    #-----< physical-delivery-country-name >-----#
    physical_delivery_country_name = INT(name=u'physical-delivery-country-name', mode=MODE_VALUE)
    physical_delivery_country_name._val = 8
    
    #-----< PhysicalDeliveryCountryName >-----#
    PhysicalDeliveryCountryName = CHOICE(name=u'PhysicalDeliveryCountryName', mode=MODE_TYPE)
    _PhysicalDeliveryCountryName_x121_dcc_code = STR_NUM(name=u'x121-dcc-code', mode=MODE_TYPE)
    _PhysicalDeliveryCountryName_x121_dcc_code._const_sz = ASN1Set(rv=[3], rr=[], ev=None, er=[])
    _PhysicalDeliveryCountryName_iso_3166_alpha2_code = STR_PRINT(name=u'iso-3166-alpha2-code', mode=MODE_TYPE)
    _PhysicalDeliveryCountryName_iso_3166_alpha2_code._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    PhysicalDeliveryCountryName._cont = ASN1Dict([
        (u'x121-dcc-code', _PhysicalDeliveryCountryName_x121_dcc_code),
        (u'iso-3166-alpha2-code', _PhysicalDeliveryCountryName_iso_3166_alpha2_code),
        ])
    PhysicalDeliveryCountryName._ext = None
    
    #-----< postal-code >-----#
    postal_code = INT(name=u'postal-code', mode=MODE_VALUE)
    postal_code._val = 9
    
    #-----< PostalCode >-----#
    PostalCode = CHOICE(name=u'PostalCode', mode=MODE_TYPE)
    _PostalCode_numeric_code = STR_NUM(name=u'numeric-code', mode=MODE_TYPE)
    _PostalCode_numeric_code._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    _PostalCode_printable_code = STR_PRINT(name=u'printable-code', mode=MODE_TYPE)
    _PostalCode_printable_code._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    PostalCode._cont = ASN1Dict([
        (u'numeric-code', _PostalCode_numeric_code),
        (u'printable-code', _PostalCode_printable_code),
        ])
    PostalCode._ext = None
    
    #-----< physical-delivery-office-name >-----#
    physical_delivery_office_name = INT(name=u'physical-delivery-office-name', mode=MODE_VALUE)
    physical_delivery_office_name._val = 10
    
    #-----< PhysicalDeliveryOfficeName >-----#
    PhysicalDeliveryOfficeName = SET(name=u'PhysicalDeliveryOfficeName', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'PDSParameter')))
    
    #-----< physical-delivery-office-number >-----#
    physical_delivery_office_number = INT(name=u'physical-delivery-office-number', mode=MODE_VALUE)
    physical_delivery_office_number._val = 11
    
    #-----< PhysicalDeliveryOfficeNumber >-----#
    PhysicalDeliveryOfficeNumber = SET(name=u'PhysicalDeliveryOfficeNumber', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'PDSParameter')))
    
    #-----< extension-OR-address-components >-----#
    extension_OR_address_components = INT(name=u'extension-OR-address-components', mode=MODE_VALUE)
    extension_OR_address_components._val = 12
    
    #-----< ExtensionORAddressComponents >-----#
    ExtensionORAddressComponents = SET(name=u'ExtensionORAddressComponents', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'PDSParameter')))
    
    #-----< physical-delivery-personal-name >-----#
    physical_delivery_personal_name = INT(name=u'physical-delivery-personal-name', mode=MODE_VALUE)
    physical_delivery_personal_name._val = 13
    
    #-----< PhysicalDeliveryPersonalName >-----#
    PhysicalDeliveryPersonalName = SET(name=u'PhysicalDeliveryPersonalName', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'PDSParameter')))
    
    #-----< physical-delivery-organization-name >-----#
    physical_delivery_organization_name = INT(name=u'physical-delivery-organization-name', mode=MODE_VALUE)
    physical_delivery_organization_name._val = 14
    
    #-----< PhysicalDeliveryOrganizationName >-----#
    PhysicalDeliveryOrganizationName = SET(name=u'PhysicalDeliveryOrganizationName', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'PDSParameter')))
    
    #-----< extension-physical-delivery-address-components >-----#
    extension_physical_delivery_address_components = INT(name=u'extension-physical-delivery-address-components', mode=MODE_VALUE)
    extension_physical_delivery_address_components._val = 15
    
    #-----< ExtensionPhysicalDeliveryAddressComponents >-----#
    ExtensionPhysicalDeliveryAddressComponents = SET(name=u'ExtensionPhysicalDeliveryAddressComponents', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'PDSParameter')))
    
    #-----< unformatted-postal-address >-----#
    unformatted_postal_address = INT(name=u'unformatted-postal-address', mode=MODE_VALUE)
    unformatted_postal_address._val = 16
    
    #-----< UnformattedPostalAddress >-----#
    UnformattedPostalAddress = SET(name=u'UnformattedPostalAddress', mode=MODE_TYPE)
    _UnformattedPostalAddress_printable_address = SEQ_OF(name=u'printable-address', mode=MODE_TYPE, opt=True)
    __UnformattedPostalAddress_printable_address__item_ = STR_PRINT(name='_item_', mode=MODE_TYPE)
    __UnformattedPostalAddress_printable_address__item_._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=30)], ev=None, er=[])
    _UnformattedPostalAddress_printable_address._cont = __UnformattedPostalAddress_printable_address__item_
    _UnformattedPostalAddress_printable_address._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=6)], ev=None, er=[])
    _UnformattedPostalAddress_teletex_string = STR_TELE(name=u'teletex-string', mode=MODE_TYPE, opt=True)
    _UnformattedPostalAddress_teletex_string._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=180)], ev=None, er=[])
    UnformattedPostalAddress._cont = ASN1Dict([
        (u'printable-address', _UnformattedPostalAddress_printable_address),
        (u'teletex-string', _UnformattedPostalAddress_teletex_string),
        ])
    UnformattedPostalAddress._ext = None
    
    #-----< street-address >-----#
    street_address = INT(name=u'street-address', mode=MODE_VALUE)
    street_address._val = 17
    
    #-----< StreetAddress >-----#
    StreetAddress = SET(name=u'StreetAddress', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'PDSParameter')))
    
    #-----< post-office-box-address >-----#
    post_office_box_address = INT(name=u'post-office-box-address', mode=MODE_VALUE)
    post_office_box_address._val = 18
    
    #-----< PostOfficeBoxAddress >-----#
    PostOfficeBoxAddress = SET(name=u'PostOfficeBoxAddress', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'PDSParameter')))
    
    #-----< poste-restante-address >-----#
    poste_restante_address = INT(name=u'poste-restante-address', mode=MODE_VALUE)
    poste_restante_address._val = 19
    
    #-----< PosteRestanteAddress >-----#
    PosteRestanteAddress = SET(name=u'PosteRestanteAddress', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'PDSParameter')))
    
    #-----< unique-postal-name >-----#
    unique_postal_name = INT(name=u'unique-postal-name', mode=MODE_VALUE)
    unique_postal_name._val = 20
    
    #-----< UniquePostalName >-----#
    UniquePostalName = SET(name=u'UniquePostalName', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'PDSParameter')))
    
    #-----< local-postal-attributes >-----#
    local_postal_attributes = INT(name=u'local-postal-attributes', mode=MODE_VALUE)
    local_postal_attributes._val = 21
    
    #-----< LocalPostalAttributes >-----#
    LocalPostalAttributes = SET(name=u'LocalPostalAttributes', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'PDSParameter')))
    
    #-----< PDSParameter >-----#
    PDSParameter = SET(name=u'PDSParameter', mode=MODE_TYPE)
    _PDSParameter_printable_string = STR_PRINT(name=u'printable-string', mode=MODE_TYPE, opt=True)
    _PDSParameter_printable_string._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=30)], ev=None, er=[])
    _PDSParameter_teletex_string = STR_TELE(name=u'teletex-string', mode=MODE_TYPE, opt=True)
    _PDSParameter_teletex_string._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=30)], ev=None, er=[])
    PDSParameter._cont = ASN1Dict([
        (u'printable-string', _PDSParameter_printable_string),
        (u'teletex-string', _PDSParameter_teletex_string),
        ])
    PDSParameter._ext = None
    
    #-----< extended-network-address >-----#
    extended_network_address = INT(name=u'extended-network-address', mode=MODE_VALUE)
    extended_network_address._val = 22
    
    #-----< ExtendedNetworkAddress >-----#
    ExtendedNetworkAddress = CHOICE(name=u'ExtendedNetworkAddress', mode=MODE_TYPE)
    _ExtendedNetworkAddress_e163_4_address = SEQ(name=u'e163-4-address', mode=MODE_TYPE)
    __ExtendedNetworkAddress_e163_4_address_number = STR_NUM(name=u'number', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __ExtendedNetworkAddress_e163_4_address_number._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=15)], ev=None, er=[])
    __ExtendedNetworkAddress_e163_4_address_sub_address = STR_NUM(name=u'sub-address', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __ExtendedNetworkAddress_e163_4_address_sub_address._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=40)], ev=None, er=[])
    _ExtendedNetworkAddress_e163_4_address._cont = ASN1Dict([
        (u'number', __ExtendedNetworkAddress_e163_4_address_number),
        (u'sub-address', __ExtendedNetworkAddress_e163_4_address_sub_address),
        ])
    _ExtendedNetworkAddress_e163_4_address._ext = None
    _ExtendedNetworkAddress_psap_address = SEQ(name=u'psap-address', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Explicit88', 'PresentationAddress')))
    ExtendedNetworkAddress._cont = ASN1Dict([
        (u'e163-4-address', _ExtendedNetworkAddress_e163_4_address),
        (u'psap-address', _ExtendedNetworkAddress_psap_address),
        ])
    ExtendedNetworkAddress._ext = None
    
    #-----< PresentationAddress >-----#
    PresentationAddress = SEQ(name=u'PresentationAddress', mode=MODE_TYPE)
    _PresentationAddress_pSelector = OCT_STR(name=u'pSelector', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _PresentationAddress_sSelector = OCT_STR(name=u'sSelector', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _PresentationAddress_tSelector = OCT_STR(name=u'tSelector', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _PresentationAddress_nAddresses = SET_OF(name=u'nAddresses', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __PresentationAddress_nAddresses__item_ = OCT_STR(name='_item_', mode=MODE_TYPE)
    _PresentationAddress_nAddresses._cont = __PresentationAddress_nAddresses__item_
    _PresentationAddress_nAddresses._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    PresentationAddress._cont = ASN1Dict([
        (u'pSelector', _PresentationAddress_pSelector),
        (u'sSelector', _PresentationAddress_sSelector),
        (u'tSelector', _PresentationAddress_tSelector),
        (u'nAddresses', _PresentationAddress_nAddresses),
        ])
    PresentationAddress._ext = None
    
    #-----< terminal-type >-----#
    terminal_type = INT(name=u'terminal-type', mode=MODE_VALUE)
    terminal_type._val = 23
    
    #-----< TerminalType >-----#
    TerminalType = INT(name=u'TerminalType', mode=MODE_TYPE)
    TerminalType._cont = ASN1Dict([(u'telex', 3), (u'teletex', 4), (u'g3-facsimile', 5), (u'g4-facsimile', 6), (u'ia5-terminal', 7), (u'videotex', 8)])
    TerminalType._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=256)], ev=None, er=[])
    
    #-----< teletex-domain-defined-attributes >-----#
    teletex_domain_defined_attributes = INT(name=u'teletex-domain-defined-attributes', mode=MODE_VALUE)
    teletex_domain_defined_attributes._val = 6
    
    #-----< TeletexDomainDefinedAttributes >-----#
    TeletexDomainDefinedAttributes = SEQ_OF(name=u'TeletexDomainDefinedAttributes', mode=MODE_TYPE)
    _TeletexDomainDefinedAttributes__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'TeletexDomainDefinedAttribute')))
    TeletexDomainDefinedAttributes._cont = _TeletexDomainDefinedAttributes__item_
    TeletexDomainDefinedAttributes._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4)], ev=None, er=[])
    
    #-----< TeletexDomainDefinedAttribute >-----#
    TeletexDomainDefinedAttribute = SEQ(name=u'TeletexDomainDefinedAttribute', mode=MODE_TYPE)
    _TeletexDomainDefinedAttribute_type = STR_TELE(name=u'type', mode=MODE_TYPE)
    _TeletexDomainDefinedAttribute_type._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    _TeletexDomainDefinedAttribute_value = STR_TELE(name=u'value', mode=MODE_TYPE)
    _TeletexDomainDefinedAttribute_value._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    TeletexDomainDefinedAttribute._cont = ASN1Dict([
        (u'type', _TeletexDomainDefinedAttribute_type),
        (u'value', _TeletexDomainDefinedAttribute_value),
        ])
    TeletexDomainDefinedAttribute._ext = None
    
    #-----< ub-name >-----#
    ub_name = INT(name=u'ub-name', mode=MODE_VALUE)
    ub_name._val = 32768
    
    #-----< ub-common-name >-----#
    ub_common_name = INT(name=u'ub-common-name', mode=MODE_VALUE)
    ub_common_name._val = 64
    
    #-----< ub-locality-name >-----#
    ub_locality_name = INT(name=u'ub-locality-name', mode=MODE_VALUE)
    ub_locality_name._val = 128
    
    #-----< ub-state-name >-----#
    ub_state_name = INT(name=u'ub-state-name', mode=MODE_VALUE)
    ub_state_name._val = 128
    
    #-----< ub-organization-name >-----#
    ub_organization_name = INT(name=u'ub-organization-name', mode=MODE_VALUE)
    ub_organization_name._val = 64
    
    #-----< ub-organizational-unit-name >-----#
    ub_organizational_unit_name = INT(name=u'ub-organizational-unit-name', mode=MODE_VALUE)
    ub_organizational_unit_name._val = 64
    
    #-----< ub-title >-----#
    ub_title = INT(name=u'ub-title', mode=MODE_VALUE)
    ub_title._val = 64
    
    #-----< ub-serial-number >-----#
    ub_serial_number = INT(name=u'ub-serial-number', mode=MODE_VALUE)
    ub_serial_number._val = 64
    
    #-----< ub-match >-----#
    ub_match = INT(name=u'ub-match', mode=MODE_VALUE)
    ub_match._val = 128
    
    #-----< ub-emailaddress-length >-----#
    ub_emailaddress_length = INT(name=u'ub-emailaddress-length', mode=MODE_VALUE)
    ub_emailaddress_length._val = 255
    
    #-----< ub-common-name-length >-----#
    ub_common_name_length = INT(name=u'ub-common-name-length', mode=MODE_VALUE)
    ub_common_name_length._val = 64
    
    #-----< ub-country-name-alpha-length >-----#
    ub_country_name_alpha_length = INT(name=u'ub-country-name-alpha-length', mode=MODE_VALUE)
    ub_country_name_alpha_length._val = 2
    
    #-----< ub-country-name-numeric-length >-----#
    ub_country_name_numeric_length = INT(name=u'ub-country-name-numeric-length', mode=MODE_VALUE)
    ub_country_name_numeric_length._val = 3
    
    #-----< ub-domain-defined-attributes >-----#
    ub_domain_defined_attributes = INT(name=u'ub-domain-defined-attributes', mode=MODE_VALUE)
    ub_domain_defined_attributes._val = 4
    
    #-----< ub-domain-defined-attribute-type-length >-----#
    ub_domain_defined_attribute_type_length = INT(name=u'ub-domain-defined-attribute-type-length', mode=MODE_VALUE)
    ub_domain_defined_attribute_type_length._val = 8
    
    #-----< ub-domain-defined-attribute-value-length >-----#
    ub_domain_defined_attribute_value_length = INT(name=u'ub-domain-defined-attribute-value-length', mode=MODE_VALUE)
    ub_domain_defined_attribute_value_length._val = 128
    
    #-----< ub-domain-name-length >-----#
    ub_domain_name_length = INT(name=u'ub-domain-name-length', mode=MODE_VALUE)
    ub_domain_name_length._val = 16
    
    #-----< ub-extension-attributes >-----#
    ub_extension_attributes = INT(name=u'ub-extension-attributes', mode=MODE_VALUE)
    ub_extension_attributes._val = 256
    
    #-----< ub-e163-4-number-length >-----#
    ub_e163_4_number_length = INT(name=u'ub-e163-4-number-length', mode=MODE_VALUE)
    ub_e163_4_number_length._val = 15
    
    #-----< ub-e163-4-sub-address-length >-----#
    ub_e163_4_sub_address_length = INT(name=u'ub-e163-4-sub-address-length', mode=MODE_VALUE)
    ub_e163_4_sub_address_length._val = 40
    
    #-----< ub-generation-qualifier-length >-----#
    ub_generation_qualifier_length = INT(name=u'ub-generation-qualifier-length', mode=MODE_VALUE)
    ub_generation_qualifier_length._val = 3
    
    #-----< ub-given-name-length >-----#
    ub_given_name_length = INT(name=u'ub-given-name-length', mode=MODE_VALUE)
    ub_given_name_length._val = 16
    
    #-----< ub-initials-length >-----#
    ub_initials_length = INT(name=u'ub-initials-length', mode=MODE_VALUE)
    ub_initials_length._val = 5
    
    #-----< ub-integer-options >-----#
    ub_integer_options = INT(name=u'ub-integer-options', mode=MODE_VALUE)
    ub_integer_options._val = 256
    
    #-----< ub-numeric-user-id-length >-----#
    ub_numeric_user_id_length = INT(name=u'ub-numeric-user-id-length', mode=MODE_VALUE)
    ub_numeric_user_id_length._val = 32
    
    #-----< ub-organization-name-length >-----#
    ub_organization_name_length = INT(name=u'ub-organization-name-length', mode=MODE_VALUE)
    ub_organization_name_length._val = 64
    
    #-----< ub-organizational-unit-name-length >-----#
    ub_organizational_unit_name_length = INT(name=u'ub-organizational-unit-name-length', mode=MODE_VALUE)
    ub_organizational_unit_name_length._val = 32
    
    #-----< ub-organizational-units >-----#
    ub_organizational_units = INT(name=u'ub-organizational-units', mode=MODE_VALUE)
    ub_organizational_units._val = 4
    
    #-----< ub-pds-name-length >-----#
    ub_pds_name_length = INT(name=u'ub-pds-name-length', mode=MODE_VALUE)
    ub_pds_name_length._val = 16
    
    #-----< ub-pds-parameter-length >-----#
    ub_pds_parameter_length = INT(name=u'ub-pds-parameter-length', mode=MODE_VALUE)
    ub_pds_parameter_length._val = 30
    
    #-----< ub-pds-physical-address-lines >-----#
    ub_pds_physical_address_lines = INT(name=u'ub-pds-physical-address-lines', mode=MODE_VALUE)
    ub_pds_physical_address_lines._val = 6
    
    #-----< ub-postal-code-length >-----#
    ub_postal_code_length = INT(name=u'ub-postal-code-length', mode=MODE_VALUE)
    ub_postal_code_length._val = 16
    
    #-----< ub-pseudonym >-----#
    ub_pseudonym = INT(name=u'ub-pseudonym', mode=MODE_VALUE)
    ub_pseudonym._val = 128
    
    #-----< ub-surname-length >-----#
    ub_surname_length = INT(name=u'ub-surname-length', mode=MODE_VALUE)
    ub_surname_length._val = 40
    
    #-----< ub-terminal-id-length >-----#
    ub_terminal_id_length = INT(name=u'ub-terminal-id-length', mode=MODE_VALUE)
    ub_terminal_id_length._val = 24
    
    #-----< ub-unformatted-address-length >-----#
    ub_unformatted_address_length = INT(name=u'ub-unformatted-address-length', mode=MODE_VALUE)
    ub_unformatted_address_length._val = 180
    
    #-----< ub-x121-address-length >-----#
    ub_x121_address_length = INT(name=u'ub-x121-address-length', mode=MODE_VALUE)
    ub_x121_address_length._val = 16
    
    _all_ = [
        id_pkix,
        id_pe,
        id_qt,
        id_kp,
        id_ad,
        id_qt_cps,
        id_qt_unotice,
        id_ad_ocsp,
        id_ad_caIssuers,
        id_ad_timeStamping,
        id_ad_caRepository,
        _Attribute_type,
        __Attribute_values__item_,
        _Attribute_values,
        Attribute,
        AttributeType,
        AttributeValue,
        _AttributeTypeAndValue_type,
        _AttributeTypeAndValue_value,
        AttributeTypeAndValue,
        id_at,
        id_at_name,
        id_at_surname,
        id_at_givenName,
        id_at_initials,
        id_at_generationQualifier,
        _X520name_teletexString,
        _X520name_printableString,
        _X520name_universalString,
        _X520name_utf8String,
        _X520name_bmpString,
        X520name,
        id_at_commonName,
        _X520CommonName_teletexString,
        _X520CommonName_printableString,
        _X520CommonName_universalString,
        _X520CommonName_utf8String,
        _X520CommonName_bmpString,
        X520CommonName,
        id_at_localityName,
        _X520LocalityName_teletexString,
        _X520LocalityName_printableString,
        _X520LocalityName_universalString,
        _X520LocalityName_utf8String,
        _X520LocalityName_bmpString,
        X520LocalityName,
        id_at_stateOrProvinceName,
        _X520StateOrProvinceName_teletexString,
        _X520StateOrProvinceName_printableString,
        _X520StateOrProvinceName_universalString,
        _X520StateOrProvinceName_utf8String,
        _X520StateOrProvinceName_bmpString,
        X520StateOrProvinceName,
        id_at_organizationName,
        _X520OrganizationName_teletexString,
        _X520OrganizationName_printableString,
        _X520OrganizationName_universalString,
        _X520OrganizationName_utf8String,
        _X520OrganizationName_bmpString,
        X520OrganizationName,
        id_at_organizationalUnitName,
        _X520OrganizationalUnitName_teletexString,
        _X520OrganizationalUnitName_printableString,
        _X520OrganizationalUnitName_universalString,
        _X520OrganizationalUnitName_utf8String,
        _X520OrganizationalUnitName_bmpString,
        X520OrganizationalUnitName,
        id_at_title,
        _X520Title_teletexString,
        _X520Title_printableString,
        _X520Title_universalString,
        _X520Title_utf8String,
        _X520Title_bmpString,
        X520Title,
        id_at_dnQualifier,
        X520dnQualifier,
        id_at_countryName,
        X520countryName,
        id_at_serialNumber,
        X520SerialNumber,
        id_at_pseudonym,
        _X520Pseudonym_teletexString,
        _X520Pseudonym_printableString,
        _X520Pseudonym_universalString,
        _X520Pseudonym_utf8String,
        _X520Pseudonym_bmpString,
        X520Pseudonym,
        id_domainComponent,
        DomainComponent,
        pkcs_9,
        id_emailAddress,
        EmailAddress,
        _Name_rdnSequence,
        Name,
        _RDNSequence__item_,
        RDNSequence,
        DistinguishedName,
        _RelativeDistinguishedName__item_,
        RelativeDistinguishedName,
        _DirectoryString_teletexString,
        _DirectoryString_printableString,
        _DirectoryString_universalString,
        _DirectoryString_utf8String,
        _DirectoryString_bmpString,
        DirectoryString,
        _Certificate_tbsCertificate,
        _Certificate_signatureAlgorithm,
        _Certificate_signature,
        Certificate,
        _TBSCertificate_version,
        _TBSCertificate_serialNumber,
        _TBSCertificate_signature,
        _TBSCertificate_issuer,
        _TBSCertificate_validity,
        _TBSCertificate_subject,
        _TBSCertificate_subjectPublicKeyInfo,
        _TBSCertificate_issuerUniqueID,
        _TBSCertificate_subjectUniqueID,
        _TBSCertificate_extensions,
        TBSCertificate,
        Version,
        CertificateSerialNumber,
        _Validity_notBefore,
        _Validity_notAfter,
        Validity,
        _Time_utcTime,
        _Time_generalTime,
        Time,
        UniqueIdentifier,
        _SubjectPublicKeyInfo_algorithm,
        _SubjectPublicKeyInfo_subjectPublicKey,
        SubjectPublicKeyInfo,
        _Extensions__item_,
        Extensions,
        _Extension_extnID,
        _Extension_critical,
        _Extension_extnValue,
        Extension,
        _CertificateList_tbsCertList,
        _CertificateList_signatureAlgorithm,
        _CertificateList_signature,
        CertificateList,
        _TBSCertList_version,
        _TBSCertList_signature,
        _TBSCertList_issuer,
        _TBSCertList_thisUpdate,
        _TBSCertList_nextUpdate,
        ___TBSCertList_revokedCertificates__item__userCertificate,
        ___TBSCertList_revokedCertificates__item__revocationDate,
        ___TBSCertList_revokedCertificates__item__crlEntryExtensions,
        __TBSCertList_revokedCertificates__item_,
        _TBSCertList_revokedCertificates,
        _TBSCertList_crlExtensions,
        TBSCertList,
        _AlgorithmIdentifier_algorithm,
        _AlgorithmIdentifier_parameters,
        AlgorithmIdentifier,
        _ORAddress_built_in_standard_attributes,
        _ORAddress_built_in_domain_defined_attributes,
        _ORAddress_extension_attributes,
        ORAddress,
        _BuiltInStandardAttributes_country_name,
        _BuiltInStandardAttributes_administration_domain_name,
        _BuiltInStandardAttributes_network_address,
        _BuiltInStandardAttributes_terminal_identifier,
        _BuiltInStandardAttributes_private_domain_name,
        _BuiltInStandardAttributes_organization_name,
        _BuiltInStandardAttributes_numeric_user_identifier,
        _BuiltInStandardAttributes_personal_name,
        _BuiltInStandardAttributes_organizational_unit_names,
        BuiltInStandardAttributes,
        _CountryName_x121_dcc_code,
        _CountryName_iso_3166_alpha2_code,
        CountryName,
        _AdministrationDomainName_numeric,
        _AdministrationDomainName_printable,
        AdministrationDomainName,
        NetworkAddress,
        X121Address,
        TerminalIdentifier,
        _PrivateDomainName_numeric,
        _PrivateDomainName_printable,
        PrivateDomainName,
        OrganizationName,
        NumericUserIdentifier,
        _PersonalName_surname,
        _PersonalName_given_name,
        _PersonalName_initials,
        _PersonalName_generation_qualifier,
        PersonalName,
        _OrganizationalUnitNames__item_,
        OrganizationalUnitNames,
        OrganizationalUnitName,
        _BuiltInDomainDefinedAttributes__item_,
        BuiltInDomainDefinedAttributes,
        _BuiltInDomainDefinedAttribute_type,
        _BuiltInDomainDefinedAttribute_value,
        BuiltInDomainDefinedAttribute,
        _ExtensionAttributes__item_,
        ExtensionAttributes,
        _ExtensionAttribute_extension_attribute_type,
        _ExtensionAttribute_extension_attribute_value,
        ExtensionAttribute,
        common_name,
        CommonName,
        teletex_common_name,
        TeletexCommonName,
        teletex_organization_name,
        TeletexOrganizationName,
        teletex_personal_name,
        _TeletexPersonalName_surname,
        _TeletexPersonalName_given_name,
        _TeletexPersonalName_initials,
        _TeletexPersonalName_generation_qualifier,
        TeletexPersonalName,
        teletex_organizational_unit_names,
        _TeletexOrganizationalUnitNames__item_,
        TeletexOrganizationalUnitNames,
        TeletexOrganizationalUnitName,
        pds_name,
        PDSName,
        physical_delivery_country_name,
        _PhysicalDeliveryCountryName_x121_dcc_code,
        _PhysicalDeliveryCountryName_iso_3166_alpha2_code,
        PhysicalDeliveryCountryName,
        postal_code,
        _PostalCode_numeric_code,
        _PostalCode_printable_code,
        PostalCode,
        physical_delivery_office_name,
        PhysicalDeliveryOfficeName,
        physical_delivery_office_number,
        PhysicalDeliveryOfficeNumber,
        extension_OR_address_components,
        ExtensionORAddressComponents,
        physical_delivery_personal_name,
        PhysicalDeliveryPersonalName,
        physical_delivery_organization_name,
        PhysicalDeliveryOrganizationName,
        extension_physical_delivery_address_components,
        ExtensionPhysicalDeliveryAddressComponents,
        unformatted_postal_address,
        __UnformattedPostalAddress_printable_address__item_,
        _UnformattedPostalAddress_printable_address,
        _UnformattedPostalAddress_teletex_string,
        UnformattedPostalAddress,
        street_address,
        StreetAddress,
        post_office_box_address,
        PostOfficeBoxAddress,
        poste_restante_address,
        PosteRestanteAddress,
        unique_postal_name,
        UniquePostalName,
        local_postal_attributes,
        LocalPostalAttributes,
        _PDSParameter_printable_string,
        _PDSParameter_teletex_string,
        PDSParameter,
        extended_network_address,
        __ExtendedNetworkAddress_e163_4_address_number,
        __ExtendedNetworkAddress_e163_4_address_sub_address,
        _ExtendedNetworkAddress_e163_4_address,
        _ExtendedNetworkAddress_psap_address,
        ExtendedNetworkAddress,
        _PresentationAddress_pSelector,
        _PresentationAddress_sSelector,
        _PresentationAddress_tSelector,
        __PresentationAddress_nAddresses__item_,
        _PresentationAddress_nAddresses,
        PresentationAddress,
        terminal_type,
        TerminalType,
        teletex_domain_defined_attributes,
        _TeletexDomainDefinedAttributes__item_,
        TeletexDomainDefinedAttributes,
        _TeletexDomainDefinedAttribute_type,
        _TeletexDomainDefinedAttribute_value,
        TeletexDomainDefinedAttribute,
        ub_name,
        ub_common_name,
        ub_locality_name,
        ub_state_name,
        ub_organization_name,
        ub_organizational_unit_name,
        ub_title,
        ub_serial_number,
        ub_match,
        ub_emailaddress_length,
        ub_common_name_length,
        ub_country_name_alpha_length,
        ub_country_name_numeric_length,
        ub_domain_defined_attributes,
        ub_domain_defined_attribute_type_length,
        ub_domain_defined_attribute_value_length,
        ub_domain_name_length,
        ub_extension_attributes,
        ub_e163_4_number_length,
        ub_e163_4_sub_address_length,
        ub_generation_qualifier_length,
        ub_given_name_length,
        ub_initials_length,
        ub_integer_options,
        ub_numeric_user_id_length,
        ub_organization_name_length,
        ub_organizational_unit_name_length,
        ub_organizational_units,
        ub_pds_name_length,
        ub_pds_parameter_length,
        ub_pds_physical_address_lines,
        ub_postal_code_length,
        ub_pseudonym,
        ub_surname_length,
        ub_terminal_id_length,
        ub_unformatted_address_length,
        ub_x121_address_length,
    ]

class CMSAesRsaesOaep:

    _name_  = u'CMSAesRsaesOaep'
    _oid_   = [1, 2, 840, 113549, 1, 9, 16, 0, 19]
    
    _obj_ = [
        u'aes',
        u'id-aes128-CBC',
        u'id-aes192-CBC',
        u'id-aes256-CBC',
        u'AES-IV',
        u'id-aes128-wrap',
        u'id-aes192-wrap',
        u'id-aes256-wrap',
        ]
    _type_ = [
        u'AES-IV',
        ]
    _set_ = [
        ]
    _val_ = [
        u'aes',
        u'id-aes128-CBC',
        u'id-aes192-CBC',
        u'id-aes256-CBC',
        u'id-aes128-wrap',
        u'id-aes192-wrap',
        u'id-aes256-wrap',
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< aes >-----#
    aes = OID(name=u'aes', mode=MODE_VALUE)
    aes._val = (2, 16, 840, 1, 101, 3, 4, 1)
    
    #-----< id-aes128-CBC >-----#
    id_aes128_CBC = OID(name=u'id-aes128-CBC', mode=MODE_VALUE)
    id_aes128_CBC._val = (2, 16, 840, 1, 101, 3, 4, 1, 2)
    
    #-----< id-aes192-CBC >-----#
    id_aes192_CBC = OID(name=u'id-aes192-CBC', mode=MODE_VALUE)
    id_aes192_CBC._val = (2, 16, 840, 1, 101, 3, 4, 1, 22)
    
    #-----< id-aes256-CBC >-----#
    id_aes256_CBC = OID(name=u'id-aes256-CBC', mode=MODE_VALUE)
    id_aes256_CBC._val = (2, 16, 840, 1, 101, 3, 4, 1, 42)
    
    #-----< AES-IV >-----#
    AES_IV = OCT_STR(name=u'AES-IV', mode=MODE_TYPE)
    AES_IV._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    
    #-----< id-aes128-wrap >-----#
    id_aes128_wrap = OID(name=u'id-aes128-wrap', mode=MODE_VALUE)
    id_aes128_wrap._val = (2, 16, 840, 1, 101, 3, 4, 1, 5)
    
    #-----< id-aes192-wrap >-----#
    id_aes192_wrap = OID(name=u'id-aes192-wrap', mode=MODE_VALUE)
    id_aes192_wrap._val = (2, 16, 840, 1, 101, 3, 4, 1, 25)
    
    #-----< id-aes256-wrap >-----#
    id_aes256_wrap = OID(name=u'id-aes256-wrap', mode=MODE_VALUE)
    id_aes256_wrap._val = (2, 16, 840, 1, 101, 3, 4, 1, 45)
    
    _all_ = [
        aes,
        id_aes128_CBC,
        id_aes192_CBC,
        id_aes256_CBC,
        AES_IV,
        id_aes128_wrap,
        id_aes192_wrap,
        id_aes256_wrap,
    ]

init_modules(PKIX1Explicit88, CMSAesRsaesOaep)
