# -*- coding: UTF-8 -*-
# Code automatically generated by pycrate_asn1c

from pycrate_asn1rt.utils            import *
from pycrate_asn1rt.err              import *
from pycrate_asn1rt.glob             import make_GLOBAL, GLOBAL
from pycrate_asn1rt.dictobj          import ASN1Dict
from pycrate_asn1rt.refobj           import *
from pycrate_asn1rt.setobj           import *
from pycrate_asn1rt.asnobj_basic     import *
from pycrate_asn1rt.asnobj_str       import *
from pycrate_asn1rt.asnobj_construct import *
from pycrate_asn1rt.asnobj_class     import *
from pycrate_asn1rt.asnobj_ext       import *
from pycrate_asn1rt.init             import init_modules

class LPP_PDU_Definitions:

    _name_  = u'LPP-PDU-Definitions'
    _oid_   = [0, 4, 0, 0, 21, 3, 7, 1, 1]
    
    _obj_ = [
        u'LPP-Message',
        u'SequenceNumber',
        u'Acknowledgement',
        u'LPP-MessageBody',
        u'LPP-TransactionID',
        u'Initiator',
        u'TransactionNumber',
        u'RequestCapabilities',
        u'RequestCapabilities-r9-IEs',
        u'ProvideCapabilities',
        u'ProvideCapabilities-r9-IEs',
        u'RequestAssistanceData',
        u'RequestAssistanceData-r9-IEs',
        u'ProvideAssistanceData',
        u'ProvideAssistanceData-r9-IEs',
        u'RequestLocationInformation',
        u'RequestLocationInformation-r9-IEs',
        u'ProvideLocationInformation',
        u'ProvideLocationInformation-r9-IEs',
        u'Abort',
        u'Abort-r9-IEs',
        u'Error',
        u'Error-r9-IEs',
        u'AccessTypes',
        u'ARFCN-ValueEUTRA',
        u'ARFCN-ValueEUTRA-v9a0',
        u'maxEARFCN',
        u'maxEARFCN-Plus1',
        u'maxEARFCN2',
        u'ARFCN-ValueUTRA',
        u'CellGlobalIdEUTRA-AndUTRA',
        u'CellGlobalIdGERAN',
        u'ECGI',
        u'Ellipsoid-Point',
        u'Ellipsoid-PointWithUncertaintyCircle',
        u'EllipsoidPointWithUncertaintyEllipse',
        u'EllipsoidPointWithAltitude',
        u'EllipsoidPointWithAltitudeAndUncertaintyEllipsoid',
        u'EllipsoidArc',
        u'EPDU-Sequence',
        u'maxEPDU',
        u'EPDU',
        u'EPDU-Identifier',
        u'EPDU-ID',
        u'EPDU-Name',
        u'EPDU-Body',
        u'HorizontalVelocity',
        u'HorizontalWithVerticalVelocity',
        u'HorizontalVelocityWithUncertainty',
        u'HorizontalWithVerticalVelocityAndUncertainty',
        u'LocationCoordinateTypes',
        u'Polygon',
        u'PolygonPoints',
        u'PositioningModes',
        u'VelocityTypes',
        u'CommonIEsRequestCapabilities',
        u'CommonIEsProvideCapabilities',
        u'CommonIEsRequestAssistanceData',
        u'CommonIEsProvideAssistanceData',
        u'CommonIEsRequestLocationInformation',
        u'LocationInformationType',
        u'PeriodicalReportingCriteria',
        u'TriggeredReportingCriteria',
        u'ReportingDuration',
        u'AdditionalInformation',
        u'QoS',
        u'HorizontalAccuracy',
        u'VerticalAccuracy',
        u'ResponseTime',
        u'Environment',
        u'CommonIEsProvideLocationInformation',
        u'LocationCoordinates',
        u'Velocity',
        u'LocationError',
        u'LocationFailureCause',
        u'EarlyFixReport-r12',
        u'LocationSource-r13',
        u'CommonIEsAbort',
        u'CommonIEsError',
        u'OTDOA-ProvideAssistanceData',
        u'OTDOA-ReferenceCellInfo',
        u'PRS-Info',
        u'OTDOA-NeighbourCellInfoList',
        u'OTDOA-NeighbourFreqInfo',
        u'OTDOA-NeighbourCellInfoElement',
        u'maxFreqLayers',
        u'OTDOA-RequestAssistanceData',
        u'OTDOA-ProvideLocationInformation',
        u'OTDOA-SignalMeasurementInformation',
        u'NeighbourMeasurementList',
        u'NeighbourMeasurementElement',
        u'OTDOA-MeasQuality',
        u'OTDOA-RequestLocationInformation',
        u'OTDOA-ProvideCapabilities',
        u'maxBands',
        u'SupportedBandEUTRA',
        u'SupportedBandEUTRA-v9a0',
        u'maxFBI',
        u'maxFBI-Plus1',
        u'maxFBI2',
        u'OTDOA-RequestCapabilities',
        u'OTDOA-Error',
        u'OTDOA-LocationServerErrorCauses',
        u'OTDOA-TargetDeviceErrorCauses',
        u'A-GNSS-ProvideAssistanceData',
        u'GNSS-CommonAssistData',
        u'GNSS-GenericAssistData',
        u'GNSS-GenericAssistDataElement',
        u'GNSS-ReferenceTime',
        u'GNSS-ReferenceTimeForOneCell',
        u'GNSS-SystemTime',
        u'GPS-TOW-Assist',
        u'GPS-TOW-AssistElement',
        u'NetworkTime',
        u'GNSS-ReferenceLocation',
        u'GNSS-IonosphericModel',
        u'KlobucharModelParameter',
        u'NeQuickModelParameter',
        u'GNSS-EarthOrientationParameters',
        u'GNSS-TimeModelList',
        u'GNSS-TimeModelElement',
        u'GNSS-DifferentialCorrections',
        u'DGNSS-SgnTypeList',
        u'DGNSS-SgnTypeElement',
        u'DGNSS-SatList',
        u'DGNSS-CorrectionsElement',
        u'GNSS-NavigationModel',
        u'GNSS-NavModelSatelliteList',
        u'GNSS-NavModelSatelliteElement',
        u'GNSS-ClockModel',
        u'GNSS-OrbitModel',
        u'StandardClockModelList',
        u'StandardClockModelElement',
        u'NAV-ClockModel',
        u'CNAV-ClockModel',
        u'GLONASS-ClockModel',
        u'SBAS-ClockModel',
        u'BDS-ClockModel-r12',
        u'NavModelKeplerianSet',
        u'NavModelNAV-KeplerianSet',
        u'NavModelCNAV-KeplerianSet',
        u'NavModel-GLONASS-ECEF',
        u'NavModel-SBAS-ECEF',
        u'NavModel-BDS-KeplerianSet-r12',
        u'GNSS-RealTimeIntegrity',
        u'GNSS-BadSignalList',
        u'BadSignalElement',
        u'GNSS-DataBitAssistance',
        u'GNSS-DataBitsSatList',
        u'GNSS-DataBitsSatElement',
        u'GNSS-DataBitsSgnList',
        u'GNSS-DataBitsSgnElement',
        u'GNSS-AcquisitionAssistance',
        u'GNSS-AcquisitionAssistList',
        u'GNSS-AcquisitionAssistElement',
        u'GNSS-Almanac',
        u'GNSS-AlmanacList',
        u'GNSS-AlmanacElement',
        u'AlmanacKeplerianSet',
        u'AlmanacNAV-KeplerianSet',
        u'AlmanacReducedKeplerianSet',
        u'AlmanacMidiAlmanacSet',
        u'AlmanacGLONASS-AlmanacSet',
        u'AlmanacECEF-SBAS-AlmanacSet',
        u'AlmanacBDS-AlmanacSet-r12',
        u'GNSS-UTC-Model',
        u'UTC-ModelSet1',
        u'UTC-ModelSet2',
        u'UTC-ModelSet3',
        u'UTC-ModelSet4',
        u'UTC-ModelSet5-r12',
        u'GNSS-AuxiliaryInformation',
        u'GNSS-ID-GPS',
        u'GNSS-ID-GPS-SatElement',
        u'GNSS-ID-GLONASS',
        u'GNSS-ID-GLONASS-SatElement',
        u'BDS-DifferentialCorrections-r12',
        u'BDS-SgnTypeList-r12',
        u'BDS-SgnTypeElement-r12',
        u'DBDS-CorrectionList-r12',
        u'DBDS-CorrectionElement-r12',
        u'BDS-GridModelParameter-r12',
        u'GridIonList-r12',
        u'GridIonElement-r12',
        u'A-GNSS-RequestAssistanceData',
        u'GNSS-CommonAssistDataReq',
        u'GNSS-GenericAssistDataReq',
        u'GNSS-GenericAssistDataReqElement',
        u'GNSS-ReferenceTimeReq',
        u'GNSS-ReferenceLocationReq',
        u'GNSS-IonosphericModelReq',
        u'GNSS-EarthOrientationParametersReq',
        u'GNSS-TimeModelListReq',
        u'GNSS-TimeModelElementReq',
        u'GNSS-DifferentialCorrectionsReq',
        u'GNSS-NavigationModelReq',
        u'StoredNavListInfo',
        u'SatListRelatedDataList',
        u'SatListRelatedDataElement',
        u'ReqNavListInfo',
        u'GNSS-RealTimeIntegrityReq',
        u'GNSS-DataBitAssistanceReq',
        u'GNSS-DataBitsReqSatList',
        u'GNSS-DataBitsReqSatElement',
        u'GNSS-AcquisitionAssistanceReq',
        u'GNSS-AlmanacReq',
        u'GNSS-UTC-ModelReq',
        u'GNSS-AuxiliaryInformationReq',
        u'BDS-DifferentialCorrectionsReq-r12',
        u'BDS-GridModelReq-r12',
        u'A-GNSS-ProvideLocationInformation',
        u'GNSS-SignalMeasurementInformation',
        u'MeasurementReferenceTime',
        u'GNSS-MeasurementList',
        u'GNSS-MeasurementForOneGNSS',
        u'GNSS-SgnMeasList',
        u'GNSS-SgnMeasElement',
        u'GNSS-SatMeasList',
        u'GNSS-SatMeasElement',
        u'GNSS-LocationInformation',
        u'A-GNSS-RequestLocationInformation',
        u'GNSS-PositioningInstructions',
        u'A-GNSS-ProvideCapabilities',
        u'GNSS-SupportList',
        u'GNSS-SupportElement',
        u'AssistanceDataSupportList',
        u'GNSS-CommonAssistanceDataSupport',
        u'GNSS-ReferenceTimeSupport',
        u'GNSS-ReferenceLocationSupport',
        u'GNSS-IonosphericModelSupport',
        u'GNSS-EarthOrientationParametersSupport',
        u'GNSS-GenericAssistanceDataSupport',
        u'GNSS-GenericAssistDataSupportElement',
        u'GNSS-TimeModelListSupport',
        u'GNSS-DifferentialCorrectionsSupport',
        u'GNSS-NavigationModelSupport',
        u'GNSS-RealTimeIntegritySupport',
        u'GNSS-DataBitAssistanceSupport',
        u'GNSS-AcquisitionAssistanceSupport',
        u'GNSS-AlmanacSupport',
        u'GNSS-UTC-ModelSupport',
        u'GNSS-AuxiliaryInformationSupport',
        u'BDS-DifferentialCorrectionsSupport-r12',
        u'BDS-GridModelSupport-r12',
        u'A-GNSS-RequestCapabilities',
        u'A-GNSS-Error',
        u'GNSS-LocationServerErrorCauses',
        u'GNSS-TargetDeviceErrorCauses',
        u'GNSS-ID',
        u'GNSS-ID-Bitmap',
        u'GNSS-SignalID',
        u'GNSS-SignalIDs',
        u'SBAS-ID',
        u'SBAS-IDs',
        u'SV-ID',
        u'ECID-ProvideLocationInformation',
        u'ECID-SignalMeasurementInformation',
        u'MeasuredResultsList',
        u'MeasuredResultsElement',
        u'ECID-RequestLocationInformation',
        u'ECID-ProvideCapabilities',
        u'ECID-RequestCapabilities',
        u'ECID-Error',
        u'ECID-LocationServerErrorCauses',
        u'ECID-TargetDeviceErrorCauses',
        u'TBS-ProvideLocationInformation-r13',
        u'TBS-MeasurementInformation-r13',
        u'MBS-BeaconMeasList-r13',
        u'MBS-BeaconMeasElement-r13',
        u'TBS-RequestLocationInformation-r13',
        u'TBS-ProvideCapabilities-r13',
        u'TBS-RequestCapabilities-r13',
        u'TBS-Error-r13',
        u'TBS-LocationServerErrorCauses-r13',
        u'TBS-TargetDeviceErrorCauses-r13',
        u'Sensor-ProvideLocationInformation-r13',
        u'Sensor-MeasurementInformation-r13',
        u'Sensor-RequestLocationInformation-r13',
        u'Sensor-ProvideCapabilities-r13',
        u'Sensor-RequestCapabilities-r13',
        u'Sensor-Error-r13',
        u'Sensor-LocationServerErrorCauses-r13',
        u'Sensor-TargetDeviceErrorCauses-r13',
        u'WLAN-ProvideLocationInformation-r13',
        u'WLAN-MeasurementInformation-r13',
        u'WLAN-MeasurementList-r13',
        u'WLAN-MeasurementElement-r13',
        u'WLAN-AP-Identifier-r13',
        u'WLAN-RTT-r13',
        u'maxWLAN-AP-r13',
        u'WLAN-RequestLocationInformation-r13',
        u'WLAN-ProvideCapabilities-r13',
        u'WLAN-RequestCapabilities-r13',
        u'WLAN-Error-r13',
        u'WLAN-LocationServerErrorCauses-r13',
        u'WLAN-TargetDeviceErrorCauses-r13',
        u'BT-ProvideLocationInformation-r13',
        u'BT-MeasurementInformation-r13',
        u'BT-MeasurementList-r13',
        u'BT-MeasurementElement-r13',
        u'maxBT-Beacon-r13',
        u'BT-RequestLocationInformation-r13',
        u'BT-ProvideCapabilities-r13',
        u'BT-RequestCapabilities-r13',
        u'BT-Error-r13',
        u'BT-LocationServerErrorCauses-r13',
        u'BT-TargetDeviceErrorCauses-r13',
        ]
    _type_ = [
        u'LPP-Message',
        u'SequenceNumber',
        u'Acknowledgement',
        u'LPP-MessageBody',
        u'LPP-TransactionID',
        u'Initiator',
        u'TransactionNumber',
        u'RequestCapabilities',
        u'RequestCapabilities-r9-IEs',
        u'ProvideCapabilities',
        u'ProvideCapabilities-r9-IEs',
        u'RequestAssistanceData',
        u'RequestAssistanceData-r9-IEs',
        u'ProvideAssistanceData',
        u'ProvideAssistanceData-r9-IEs',
        u'RequestLocationInformation',
        u'RequestLocationInformation-r9-IEs',
        u'ProvideLocationInformation',
        u'ProvideLocationInformation-r9-IEs',
        u'Abort',
        u'Abort-r9-IEs',
        u'Error',
        u'Error-r9-IEs',
        u'AccessTypes',
        u'ARFCN-ValueEUTRA',
        u'ARFCN-ValueEUTRA-v9a0',
        u'ARFCN-ValueUTRA',
        u'CellGlobalIdEUTRA-AndUTRA',
        u'CellGlobalIdGERAN',
        u'ECGI',
        u'Ellipsoid-Point',
        u'Ellipsoid-PointWithUncertaintyCircle',
        u'EllipsoidPointWithUncertaintyEllipse',
        u'EllipsoidPointWithAltitude',
        u'EllipsoidPointWithAltitudeAndUncertaintyEllipsoid',
        u'EllipsoidArc',
        u'EPDU-Sequence',
        u'EPDU',
        u'EPDU-Identifier',
        u'EPDU-ID',
        u'EPDU-Name',
        u'EPDU-Body',
        u'HorizontalVelocity',
        u'HorizontalWithVerticalVelocity',
        u'HorizontalVelocityWithUncertainty',
        u'HorizontalWithVerticalVelocityAndUncertainty',
        u'LocationCoordinateTypes',
        u'Polygon',
        u'PolygonPoints',
        u'PositioningModes',
        u'VelocityTypes',
        u'CommonIEsRequestCapabilities',
        u'CommonIEsProvideCapabilities',
        u'CommonIEsRequestAssistanceData',
        u'CommonIEsProvideAssistanceData',
        u'CommonIEsRequestLocationInformation',
        u'LocationInformationType',
        u'PeriodicalReportingCriteria',
        u'TriggeredReportingCriteria',
        u'ReportingDuration',
        u'AdditionalInformation',
        u'QoS',
        u'HorizontalAccuracy',
        u'VerticalAccuracy',
        u'ResponseTime',
        u'Environment',
        u'CommonIEsProvideLocationInformation',
        u'LocationCoordinates',
        u'Velocity',
        u'LocationError',
        u'LocationFailureCause',
        u'EarlyFixReport-r12',
        u'LocationSource-r13',
        u'CommonIEsAbort',
        u'CommonIEsError',
        u'OTDOA-ProvideAssistanceData',
        u'OTDOA-ReferenceCellInfo',
        u'PRS-Info',
        u'OTDOA-NeighbourCellInfoList',
        u'OTDOA-NeighbourFreqInfo',
        u'OTDOA-NeighbourCellInfoElement',
        u'OTDOA-RequestAssistanceData',
        u'OTDOA-ProvideLocationInformation',
        u'OTDOA-SignalMeasurementInformation',
        u'NeighbourMeasurementList',
        u'NeighbourMeasurementElement',
        u'OTDOA-MeasQuality',
        u'OTDOA-RequestLocationInformation',
        u'OTDOA-ProvideCapabilities',
        u'SupportedBandEUTRA',
        u'SupportedBandEUTRA-v9a0',
        u'OTDOA-RequestCapabilities',
        u'OTDOA-Error',
        u'OTDOA-LocationServerErrorCauses',
        u'OTDOA-TargetDeviceErrorCauses',
        u'A-GNSS-ProvideAssistanceData',
        u'GNSS-CommonAssistData',
        u'GNSS-GenericAssistData',
        u'GNSS-GenericAssistDataElement',
        u'GNSS-ReferenceTime',
        u'GNSS-ReferenceTimeForOneCell',
        u'GNSS-SystemTime',
        u'GPS-TOW-Assist',
        u'GPS-TOW-AssistElement',
        u'NetworkTime',
        u'GNSS-ReferenceLocation',
        u'GNSS-IonosphericModel',
        u'KlobucharModelParameter',
        u'NeQuickModelParameter',
        u'GNSS-EarthOrientationParameters',
        u'GNSS-TimeModelList',
        u'GNSS-TimeModelElement',
        u'GNSS-DifferentialCorrections',
        u'DGNSS-SgnTypeList',
        u'DGNSS-SgnTypeElement',
        u'DGNSS-SatList',
        u'DGNSS-CorrectionsElement',
        u'GNSS-NavigationModel',
        u'GNSS-NavModelSatelliteList',
        u'GNSS-NavModelSatelliteElement',
        u'GNSS-ClockModel',
        u'GNSS-OrbitModel',
        u'StandardClockModelList',
        u'StandardClockModelElement',
        u'NAV-ClockModel',
        u'CNAV-ClockModel',
        u'GLONASS-ClockModel',
        u'SBAS-ClockModel',
        u'BDS-ClockModel-r12',
        u'NavModelKeplerianSet',
        u'NavModelNAV-KeplerianSet',
        u'NavModelCNAV-KeplerianSet',
        u'NavModel-GLONASS-ECEF',
        u'NavModel-SBAS-ECEF',
        u'NavModel-BDS-KeplerianSet-r12',
        u'GNSS-RealTimeIntegrity',
        u'GNSS-BadSignalList',
        u'BadSignalElement',
        u'GNSS-DataBitAssistance',
        u'GNSS-DataBitsSatList',
        u'GNSS-DataBitsSatElement',
        u'GNSS-DataBitsSgnList',
        u'GNSS-DataBitsSgnElement',
        u'GNSS-AcquisitionAssistance',
        u'GNSS-AcquisitionAssistList',
        u'GNSS-AcquisitionAssistElement',
        u'GNSS-Almanac',
        u'GNSS-AlmanacList',
        u'GNSS-AlmanacElement',
        u'AlmanacKeplerianSet',
        u'AlmanacNAV-KeplerianSet',
        u'AlmanacReducedKeplerianSet',
        u'AlmanacMidiAlmanacSet',
        u'AlmanacGLONASS-AlmanacSet',
        u'AlmanacECEF-SBAS-AlmanacSet',
        u'AlmanacBDS-AlmanacSet-r12',
        u'GNSS-UTC-Model',
        u'UTC-ModelSet1',
        u'UTC-ModelSet2',
        u'UTC-ModelSet3',
        u'UTC-ModelSet4',
        u'UTC-ModelSet5-r12',
        u'GNSS-AuxiliaryInformation',
        u'GNSS-ID-GPS',
        u'GNSS-ID-GPS-SatElement',
        u'GNSS-ID-GLONASS',
        u'GNSS-ID-GLONASS-SatElement',
        u'BDS-DifferentialCorrections-r12',
        u'BDS-SgnTypeList-r12',
        u'BDS-SgnTypeElement-r12',
        u'DBDS-CorrectionList-r12',
        u'DBDS-CorrectionElement-r12',
        u'BDS-GridModelParameter-r12',
        u'GridIonList-r12',
        u'GridIonElement-r12',
        u'A-GNSS-RequestAssistanceData',
        u'GNSS-CommonAssistDataReq',
        u'GNSS-GenericAssistDataReq',
        u'GNSS-GenericAssistDataReqElement',
        u'GNSS-ReferenceTimeReq',
        u'GNSS-ReferenceLocationReq',
        u'GNSS-IonosphericModelReq',
        u'GNSS-EarthOrientationParametersReq',
        u'GNSS-TimeModelListReq',
        u'GNSS-TimeModelElementReq',
        u'GNSS-DifferentialCorrectionsReq',
        u'GNSS-NavigationModelReq',
        u'StoredNavListInfo',
        u'SatListRelatedDataList',
        u'SatListRelatedDataElement',
        u'ReqNavListInfo',
        u'GNSS-RealTimeIntegrityReq',
        u'GNSS-DataBitAssistanceReq',
        u'GNSS-DataBitsReqSatList',
        u'GNSS-DataBitsReqSatElement',
        u'GNSS-AcquisitionAssistanceReq',
        u'GNSS-AlmanacReq',
        u'GNSS-UTC-ModelReq',
        u'GNSS-AuxiliaryInformationReq',
        u'BDS-DifferentialCorrectionsReq-r12',
        u'BDS-GridModelReq-r12',
        u'A-GNSS-ProvideLocationInformation',
        u'GNSS-SignalMeasurementInformation',
        u'MeasurementReferenceTime',
        u'GNSS-MeasurementList',
        u'GNSS-MeasurementForOneGNSS',
        u'GNSS-SgnMeasList',
        u'GNSS-SgnMeasElement',
        u'GNSS-SatMeasList',
        u'GNSS-SatMeasElement',
        u'GNSS-LocationInformation',
        u'A-GNSS-RequestLocationInformation',
        u'GNSS-PositioningInstructions',
        u'A-GNSS-ProvideCapabilities',
        u'GNSS-SupportList',
        u'GNSS-SupportElement',
        u'AssistanceDataSupportList',
        u'GNSS-CommonAssistanceDataSupport',
        u'GNSS-ReferenceTimeSupport',
        u'GNSS-ReferenceLocationSupport',
        u'GNSS-IonosphericModelSupport',
        u'GNSS-EarthOrientationParametersSupport',
        u'GNSS-GenericAssistanceDataSupport',
        u'GNSS-GenericAssistDataSupportElement',
        u'GNSS-TimeModelListSupport',
        u'GNSS-DifferentialCorrectionsSupport',
        u'GNSS-NavigationModelSupport',
        u'GNSS-RealTimeIntegritySupport',
        u'GNSS-DataBitAssistanceSupport',
        u'GNSS-AcquisitionAssistanceSupport',
        u'GNSS-AlmanacSupport',
        u'GNSS-UTC-ModelSupport',
        u'GNSS-AuxiliaryInformationSupport',
        u'BDS-DifferentialCorrectionsSupport-r12',
        u'BDS-GridModelSupport-r12',
        u'A-GNSS-RequestCapabilities',
        u'A-GNSS-Error',
        u'GNSS-LocationServerErrorCauses',
        u'GNSS-TargetDeviceErrorCauses',
        u'GNSS-ID',
        u'GNSS-ID-Bitmap',
        u'GNSS-SignalID',
        u'GNSS-SignalIDs',
        u'SBAS-ID',
        u'SBAS-IDs',
        u'SV-ID',
        u'ECID-ProvideLocationInformation',
        u'ECID-SignalMeasurementInformation',
        u'MeasuredResultsList',
        u'MeasuredResultsElement',
        u'ECID-RequestLocationInformation',
        u'ECID-ProvideCapabilities',
        u'ECID-RequestCapabilities',
        u'ECID-Error',
        u'ECID-LocationServerErrorCauses',
        u'ECID-TargetDeviceErrorCauses',
        u'TBS-ProvideLocationInformation-r13',
        u'TBS-MeasurementInformation-r13',
        u'MBS-BeaconMeasList-r13',
        u'MBS-BeaconMeasElement-r13',
        u'TBS-RequestLocationInformation-r13',
        u'TBS-ProvideCapabilities-r13',
        u'TBS-RequestCapabilities-r13',
        u'TBS-Error-r13',
        u'TBS-LocationServerErrorCauses-r13',
        u'TBS-TargetDeviceErrorCauses-r13',
        u'Sensor-ProvideLocationInformation-r13',
        u'Sensor-MeasurementInformation-r13',
        u'Sensor-RequestLocationInformation-r13',
        u'Sensor-ProvideCapabilities-r13',
        u'Sensor-RequestCapabilities-r13',
        u'Sensor-Error-r13',
        u'Sensor-LocationServerErrorCauses-r13',
        u'Sensor-TargetDeviceErrorCauses-r13',
        u'WLAN-ProvideLocationInformation-r13',
        u'WLAN-MeasurementInformation-r13',
        u'WLAN-MeasurementList-r13',
        u'WLAN-MeasurementElement-r13',
        u'WLAN-AP-Identifier-r13',
        u'WLAN-RTT-r13',
        u'WLAN-RequestLocationInformation-r13',
        u'WLAN-ProvideCapabilities-r13',
        u'WLAN-RequestCapabilities-r13',
        u'WLAN-Error-r13',
        u'WLAN-LocationServerErrorCauses-r13',
        u'WLAN-TargetDeviceErrorCauses-r13',
        u'BT-ProvideLocationInformation-r13',
        u'BT-MeasurementInformation-r13',
        u'BT-MeasurementList-r13',
        u'BT-MeasurementElement-r13',
        u'BT-RequestLocationInformation-r13',
        u'BT-ProvideCapabilities-r13',
        u'BT-RequestCapabilities-r13',
        u'BT-Error-r13',
        u'BT-LocationServerErrorCauses-r13',
        u'BT-TargetDeviceErrorCauses-r13',
        ]
    _set_ = [
        ]
    _val_ = [
        u'maxEARFCN',
        u'maxEARFCN-Plus1',
        u'maxEARFCN2',
        u'maxEPDU',
        u'maxFreqLayers',
        u'maxBands',
        u'maxFBI',
        u'maxFBI-Plus1',
        u'maxFBI2',
        u'maxWLAN-AP-r13',
        u'maxBT-Beacon-r13',
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< LPP-Message >-----#
    LPP_Message = SEQ(name=u'LPP-Message', mode=MODE_TYPE)
    _LPP_Message_transactionID = SEQ(name=u'transactionID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'LPP-TransactionID')), opt=True)
    _LPP_Message_endTransaction = BOOL(name=u'endTransaction', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _LPP_Message_sequenceNumber = INT(name=u'sequenceNumber', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'SequenceNumber')), opt=True)
    _LPP_Message_acknowledgement = SEQ(name=u'acknowledgement', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'Acknowledgement')), opt=True)
    _LPP_Message_lpp_MessageBody = CHOICE(name=u'lpp-MessageBody', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'LPP-MessageBody')), opt=True)
    LPP_Message._cont = ASN1Dict([
        (u'transactionID', _LPP_Message_transactionID),
        (u'endTransaction', _LPP_Message_endTransaction),
        (u'sequenceNumber', _LPP_Message_sequenceNumber),
        (u'acknowledgement', _LPP_Message_acknowledgement),
        (u'lpp-MessageBody', _LPP_Message_lpp_MessageBody),
        ])
    LPP_Message._ext = None
    
    #-----< SequenceNumber >-----#
    SequenceNumber = INT(name=u'SequenceNumber', mode=MODE_TYPE)
    SequenceNumber._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    
    #-----< Acknowledgement >-----#
    Acknowledgement = SEQ(name=u'Acknowledgement', mode=MODE_TYPE)
    _Acknowledgement_ackRequested = BOOL(name=u'ackRequested', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _Acknowledgement_ackIndicator = INT(name=u'ackIndicator', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'SequenceNumber')), opt=True)
    Acknowledgement._cont = ASN1Dict([
        (u'ackRequested', _Acknowledgement_ackRequested),
        (u'ackIndicator', _Acknowledgement_ackIndicator),
        ])
    Acknowledgement._ext = None
    
    #-----< LPP-MessageBody >-----#
    LPP_MessageBody = CHOICE(name=u'LPP-MessageBody', mode=MODE_TYPE)
    _LPP_MessageBody_c1 = CHOICE(name=u'c1', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __LPP_MessageBody_c1_requestCapabilities = SEQ(name=u'requestCapabilities', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'RequestCapabilities')))
    __LPP_MessageBody_c1_provideCapabilities = SEQ(name=u'provideCapabilities', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'ProvideCapabilities')))
    __LPP_MessageBody_c1_requestAssistanceData = SEQ(name=u'requestAssistanceData', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'RequestAssistanceData')))
    __LPP_MessageBody_c1_provideAssistanceData = SEQ(name=u'provideAssistanceData', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'ProvideAssistanceData')))
    __LPP_MessageBody_c1_requestLocationInformation = SEQ(name=u'requestLocationInformation', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'RequestLocationInformation')))
    __LPP_MessageBody_c1_provideLocationInformation = SEQ(name=u'provideLocationInformation', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'ProvideLocationInformation')))
    __LPP_MessageBody_c1_abort = SEQ(name=u'abort', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'Abort')))
    __LPP_MessageBody_c1_error = CHOICE(name=u'error', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'Error')))
    __LPP_MessageBody_c1_spare7 = NULL(name=u'spare7', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __LPP_MessageBody_c1_spare6 = NULL(name=u'spare6', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __LPP_MessageBody_c1_spare5 = NULL(name=u'spare5', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __LPP_MessageBody_c1_spare4 = NULL(name=u'spare4', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __LPP_MessageBody_c1_spare3 = NULL(name=u'spare3', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __LPP_MessageBody_c1_spare2 = NULL(name=u'spare2', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __LPP_MessageBody_c1_spare1 = NULL(name=u'spare1', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __LPP_MessageBody_c1_spare0 = NULL(name=u'spare0', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _LPP_MessageBody_c1._cont = ASN1Dict([
        (u'requestCapabilities', __LPP_MessageBody_c1_requestCapabilities),
        (u'provideCapabilities', __LPP_MessageBody_c1_provideCapabilities),
        (u'requestAssistanceData', __LPP_MessageBody_c1_requestAssistanceData),
        (u'provideAssistanceData', __LPP_MessageBody_c1_provideAssistanceData),
        (u'requestLocationInformation', __LPP_MessageBody_c1_requestLocationInformation),
        (u'provideLocationInformation', __LPP_MessageBody_c1_provideLocationInformation),
        (u'abort', __LPP_MessageBody_c1_abort),
        (u'error', __LPP_MessageBody_c1_error),
        (u'spare7', __LPP_MessageBody_c1_spare7),
        (u'spare6', __LPP_MessageBody_c1_spare6),
        (u'spare5', __LPP_MessageBody_c1_spare5),
        (u'spare4', __LPP_MessageBody_c1_spare4),
        (u'spare3', __LPP_MessageBody_c1_spare3),
        (u'spare2', __LPP_MessageBody_c1_spare2),
        (u'spare1', __LPP_MessageBody_c1_spare1),
        (u'spare0', __LPP_MessageBody_c1_spare0),
        ])
    _LPP_MessageBody_c1._ext = None
    _LPP_MessageBody_messageClassExtension = SEQ(name=u'messageClassExtension', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _LPP_MessageBody_messageClassExtension._cont = ASN1Dict([
        ])
    _LPP_MessageBody_messageClassExtension._ext = None
    LPP_MessageBody._cont = ASN1Dict([
        (u'c1', _LPP_MessageBody_c1),
        (u'messageClassExtension', _LPP_MessageBody_messageClassExtension),
        ])
    LPP_MessageBody._ext = None
    
    #-----< LPP-TransactionID >-----#
    LPP_TransactionID = SEQ(name=u'LPP-TransactionID', mode=MODE_TYPE)
    _LPP_TransactionID_initiator = ENUM(name=u'initiator', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'Initiator')))
    _LPP_TransactionID_transactionNumber = INT(name=u'transactionNumber', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'TransactionNumber')))
    LPP_TransactionID._cont = ASN1Dict([
        (u'initiator', _LPP_TransactionID_initiator),
        (u'transactionNumber', _LPP_TransactionID_transactionNumber),
        ])
    LPP_TransactionID._ext = []
    
    #-----< Initiator >-----#
    Initiator = ENUM(name=u'Initiator', mode=MODE_TYPE)
    Initiator._cont = ASN1Dict([(u'locationServer', 0), (u'targetDevice', 1)])
    Initiator._ext = []
    
    #-----< TransactionNumber >-----#
    TransactionNumber = INT(name=u'TransactionNumber', mode=MODE_TYPE)
    TransactionNumber._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    
    #-----< RequestCapabilities >-----#
    RequestCapabilities = SEQ(name=u'RequestCapabilities', mode=MODE_TYPE)
    _RequestCapabilities_criticalExtensions = CHOICE(name=u'criticalExtensions', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __RequestCapabilities_criticalExtensions_c1 = CHOICE(name=u'c1', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ___RequestCapabilities_criticalExtensions_c1_requestCapabilities_r9 = SEQ(name=u'requestCapabilities-r9', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'RequestCapabilities-r9-IEs')))
    ___RequestCapabilities_criticalExtensions_c1_spare3 = NULL(name=u'spare3', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___RequestCapabilities_criticalExtensions_c1_spare2 = NULL(name=u'spare2', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___RequestCapabilities_criticalExtensions_c1_spare1 = NULL(name=u'spare1', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __RequestCapabilities_criticalExtensions_c1._cont = ASN1Dict([
        (u'requestCapabilities-r9', ___RequestCapabilities_criticalExtensions_c1_requestCapabilities_r9),
        (u'spare3', ___RequestCapabilities_criticalExtensions_c1_spare3),
        (u'spare2', ___RequestCapabilities_criticalExtensions_c1_spare2),
        (u'spare1', ___RequestCapabilities_criticalExtensions_c1_spare1),
        ])
    __RequestCapabilities_criticalExtensions_c1._ext = None
    __RequestCapabilities_criticalExtensions_criticalExtensionsFuture = SEQ(name=u'criticalExtensionsFuture', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __RequestCapabilities_criticalExtensions_criticalExtensionsFuture._cont = ASN1Dict([
        ])
    __RequestCapabilities_criticalExtensions_criticalExtensionsFuture._ext = None
    _RequestCapabilities_criticalExtensions._cont = ASN1Dict([
        (u'c1', __RequestCapabilities_criticalExtensions_c1),
        (u'criticalExtensionsFuture', __RequestCapabilities_criticalExtensions_criticalExtensionsFuture),
        ])
    _RequestCapabilities_criticalExtensions._ext = None
    RequestCapabilities._cont = ASN1Dict([
        (u'criticalExtensions', _RequestCapabilities_criticalExtensions),
        ])
    RequestCapabilities._ext = None
    
    #-----< RequestCapabilities-r9-IEs >-----#
    RequestCapabilities_r9_IEs = SEQ(name=u'RequestCapabilities-r9-IEs', mode=MODE_TYPE)
    _RequestCapabilities_r9_IEs_commonIEsRequestCapabilities = SEQ(name=u'commonIEsRequestCapabilities', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'CommonIEsRequestCapabilities')), opt=True)
    _RequestCapabilities_r9_IEs_a_gnss_RequestCapabilities = SEQ(name=u'a-gnss-RequestCapabilities', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'A-GNSS-RequestCapabilities')), opt=True)
    _RequestCapabilities_r9_IEs_otdoa_RequestCapabilities = SEQ(name=u'otdoa-RequestCapabilities', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'OTDOA-RequestCapabilities')), opt=True)
    _RequestCapabilities_r9_IEs_ecid_RequestCapabilities = SEQ(name=u'ecid-RequestCapabilities', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'ECID-RequestCapabilities')), opt=True)
    _RequestCapabilities_r9_IEs_epdu_RequestCapabilities = SEQ_OF(name=u'epdu-RequestCapabilities', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'EPDU-Sequence')), opt=True)
    _RequestCapabilities_r9_IEs_sensor_RequestCapabilities_r13 = SEQ(name=u'sensor-RequestCapabilities-r13', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'Sensor-RequestCapabilities-r13')), opt=True, group=0)
    _RequestCapabilities_r9_IEs_tbs_RequestCapabilities_r13 = SEQ(name=u'tbs-RequestCapabilities-r13', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'TBS-RequestCapabilities-r13')), opt=True, group=0)
    _RequestCapabilities_r9_IEs_wlan_RequestCapabilities_r13 = SEQ(name=u'wlan-RequestCapabilities-r13', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'WLAN-RequestCapabilities-r13')), opt=True, group=0)
    _RequestCapabilities_r9_IEs_bt_RequestCapabilities_r13 = SEQ(name=u'bt-RequestCapabilities-r13', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'BT-RequestCapabilities-r13')), opt=True, group=0)
    RequestCapabilities_r9_IEs._cont = ASN1Dict([
        (u'commonIEsRequestCapabilities', _RequestCapabilities_r9_IEs_commonIEsRequestCapabilities),
        (u'a-gnss-RequestCapabilities', _RequestCapabilities_r9_IEs_a_gnss_RequestCapabilities),
        (u'otdoa-RequestCapabilities', _RequestCapabilities_r9_IEs_otdoa_RequestCapabilities),
        (u'ecid-RequestCapabilities', _RequestCapabilities_r9_IEs_ecid_RequestCapabilities),
        (u'epdu-RequestCapabilities', _RequestCapabilities_r9_IEs_epdu_RequestCapabilities),
        (u'sensor-RequestCapabilities-r13', _RequestCapabilities_r9_IEs_sensor_RequestCapabilities_r13),
        (u'tbs-RequestCapabilities-r13', _RequestCapabilities_r9_IEs_tbs_RequestCapabilities_r13),
        (u'wlan-RequestCapabilities-r13', _RequestCapabilities_r9_IEs_wlan_RequestCapabilities_r13),
        (u'bt-RequestCapabilities-r13', _RequestCapabilities_r9_IEs_bt_RequestCapabilities_r13),
        ])
    RequestCapabilities_r9_IEs._ext = [u'sensor-RequestCapabilities-r13', u'tbs-RequestCapabilities-r13', u'wlan-RequestCapabilities-r13', u'bt-RequestCapabilities-r13']
    
    #-----< ProvideCapabilities >-----#
    ProvideCapabilities = SEQ(name=u'ProvideCapabilities', mode=MODE_TYPE)
    _ProvideCapabilities_criticalExtensions = CHOICE(name=u'criticalExtensions', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __ProvideCapabilities_criticalExtensions_c1 = CHOICE(name=u'c1', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ___ProvideCapabilities_criticalExtensions_c1_provideCapabilities_r9 = SEQ(name=u'provideCapabilities-r9', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'ProvideCapabilities-r9-IEs')))
    ___ProvideCapabilities_criticalExtensions_c1_spare3 = NULL(name=u'spare3', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___ProvideCapabilities_criticalExtensions_c1_spare2 = NULL(name=u'spare2', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___ProvideCapabilities_criticalExtensions_c1_spare1 = NULL(name=u'spare1', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __ProvideCapabilities_criticalExtensions_c1._cont = ASN1Dict([
        (u'provideCapabilities-r9', ___ProvideCapabilities_criticalExtensions_c1_provideCapabilities_r9),
        (u'spare3', ___ProvideCapabilities_criticalExtensions_c1_spare3),
        (u'spare2', ___ProvideCapabilities_criticalExtensions_c1_spare2),
        (u'spare1', ___ProvideCapabilities_criticalExtensions_c1_spare1),
        ])
    __ProvideCapabilities_criticalExtensions_c1._ext = None
    __ProvideCapabilities_criticalExtensions_criticalExtensionsFuture = SEQ(name=u'criticalExtensionsFuture', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __ProvideCapabilities_criticalExtensions_criticalExtensionsFuture._cont = ASN1Dict([
        ])
    __ProvideCapabilities_criticalExtensions_criticalExtensionsFuture._ext = None
    _ProvideCapabilities_criticalExtensions._cont = ASN1Dict([
        (u'c1', __ProvideCapabilities_criticalExtensions_c1),
        (u'criticalExtensionsFuture', __ProvideCapabilities_criticalExtensions_criticalExtensionsFuture),
        ])
    _ProvideCapabilities_criticalExtensions._ext = None
    ProvideCapabilities._cont = ASN1Dict([
        (u'criticalExtensions', _ProvideCapabilities_criticalExtensions),
        ])
    ProvideCapabilities._ext = None
    
    #-----< ProvideCapabilities-r9-IEs >-----#
    ProvideCapabilities_r9_IEs = SEQ(name=u'ProvideCapabilities-r9-IEs', mode=MODE_TYPE)
    _ProvideCapabilities_r9_IEs_commonIEsProvideCapabilities = SEQ(name=u'commonIEsProvideCapabilities', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'CommonIEsProvideCapabilities')), opt=True)
    _ProvideCapabilities_r9_IEs_a_gnss_ProvideCapabilities = SEQ(name=u'a-gnss-ProvideCapabilities', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'A-GNSS-ProvideCapabilities')), opt=True)
    _ProvideCapabilities_r9_IEs_otdoa_ProvideCapabilities = SEQ(name=u'otdoa-ProvideCapabilities', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'OTDOA-ProvideCapabilities')), opt=True)
    _ProvideCapabilities_r9_IEs_ecid_ProvideCapabilities = SEQ(name=u'ecid-ProvideCapabilities', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'ECID-ProvideCapabilities')), opt=True)
    _ProvideCapabilities_r9_IEs_epdu_ProvideCapabilities = SEQ_OF(name=u'epdu-ProvideCapabilities', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'EPDU-Sequence')), opt=True)
    _ProvideCapabilities_r9_IEs_sensor_ProvideCapabilities_r13 = SEQ(name=u'sensor-ProvideCapabilities-r13', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'Sensor-ProvideCapabilities-r13')), opt=True, group=0)
    _ProvideCapabilities_r9_IEs_tbs_ProvideCapabilities_r13 = SEQ(name=u'tbs-ProvideCapabilities-r13', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'TBS-ProvideCapabilities-r13')), opt=True, group=0)
    _ProvideCapabilities_r9_IEs_wlan_ProvideCapabilities_r13 = SEQ(name=u'wlan-ProvideCapabilities-r13', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'WLAN-ProvideCapabilities-r13')), opt=True, group=0)
    _ProvideCapabilities_r9_IEs_bt_ProvideCapabilities_r13 = SEQ(name=u'bt-ProvideCapabilities-r13', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'BT-ProvideCapabilities-r13')), opt=True, group=0)
    ProvideCapabilities_r9_IEs._cont = ASN1Dict([
        (u'commonIEsProvideCapabilities', _ProvideCapabilities_r9_IEs_commonIEsProvideCapabilities),
        (u'a-gnss-ProvideCapabilities', _ProvideCapabilities_r9_IEs_a_gnss_ProvideCapabilities),
        (u'otdoa-ProvideCapabilities', _ProvideCapabilities_r9_IEs_otdoa_ProvideCapabilities),
        (u'ecid-ProvideCapabilities', _ProvideCapabilities_r9_IEs_ecid_ProvideCapabilities),
        (u'epdu-ProvideCapabilities', _ProvideCapabilities_r9_IEs_epdu_ProvideCapabilities),
        (u'sensor-ProvideCapabilities-r13', _ProvideCapabilities_r9_IEs_sensor_ProvideCapabilities_r13),
        (u'tbs-ProvideCapabilities-r13', _ProvideCapabilities_r9_IEs_tbs_ProvideCapabilities_r13),
        (u'wlan-ProvideCapabilities-r13', _ProvideCapabilities_r9_IEs_wlan_ProvideCapabilities_r13),
        (u'bt-ProvideCapabilities-r13', _ProvideCapabilities_r9_IEs_bt_ProvideCapabilities_r13),
        ])
    ProvideCapabilities_r9_IEs._ext = [u'sensor-ProvideCapabilities-r13', u'tbs-ProvideCapabilities-r13', u'wlan-ProvideCapabilities-r13', u'bt-ProvideCapabilities-r13']
    
    #-----< RequestAssistanceData >-----#
    RequestAssistanceData = SEQ(name=u'RequestAssistanceData', mode=MODE_TYPE)
    _RequestAssistanceData_criticalExtensions = CHOICE(name=u'criticalExtensions', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __RequestAssistanceData_criticalExtensions_c1 = CHOICE(name=u'c1', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ___RequestAssistanceData_criticalExtensions_c1_requestAssistanceData_r9 = SEQ(name=u'requestAssistanceData-r9', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'RequestAssistanceData-r9-IEs')))
    ___RequestAssistanceData_criticalExtensions_c1_spare3 = NULL(name=u'spare3', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___RequestAssistanceData_criticalExtensions_c1_spare2 = NULL(name=u'spare2', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___RequestAssistanceData_criticalExtensions_c1_spare1 = NULL(name=u'spare1', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __RequestAssistanceData_criticalExtensions_c1._cont = ASN1Dict([
        (u'requestAssistanceData-r9', ___RequestAssistanceData_criticalExtensions_c1_requestAssistanceData_r9),
        (u'spare3', ___RequestAssistanceData_criticalExtensions_c1_spare3),
        (u'spare2', ___RequestAssistanceData_criticalExtensions_c1_spare2),
        (u'spare1', ___RequestAssistanceData_criticalExtensions_c1_spare1),
        ])
    __RequestAssistanceData_criticalExtensions_c1._ext = None
    __RequestAssistanceData_criticalExtensions_criticalExtensionsFuture = SEQ(name=u'criticalExtensionsFuture', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __RequestAssistanceData_criticalExtensions_criticalExtensionsFuture._cont = ASN1Dict([
        ])
    __RequestAssistanceData_criticalExtensions_criticalExtensionsFuture._ext = None
    _RequestAssistanceData_criticalExtensions._cont = ASN1Dict([
        (u'c1', __RequestAssistanceData_criticalExtensions_c1),
        (u'criticalExtensionsFuture', __RequestAssistanceData_criticalExtensions_criticalExtensionsFuture),
        ])
    _RequestAssistanceData_criticalExtensions._ext = None
    RequestAssistanceData._cont = ASN1Dict([
        (u'criticalExtensions', _RequestAssistanceData_criticalExtensions),
        ])
    RequestAssistanceData._ext = None
    
    #-----< RequestAssistanceData-r9-IEs >-----#
    RequestAssistanceData_r9_IEs = SEQ(name=u'RequestAssistanceData-r9-IEs', mode=MODE_TYPE)
    _RequestAssistanceData_r9_IEs_commonIEsRequestAssistanceData = SEQ(name=u'commonIEsRequestAssistanceData', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'CommonIEsRequestAssistanceData')), opt=True)
    _RequestAssistanceData_r9_IEs_a_gnss_RequestAssistanceData = SEQ(name=u'a-gnss-RequestAssistanceData', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'A-GNSS-RequestAssistanceData')), opt=True)
    _RequestAssistanceData_r9_IEs_otdoa_RequestAssistanceData = SEQ(name=u'otdoa-RequestAssistanceData', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'OTDOA-RequestAssistanceData')), opt=True)
    _RequestAssistanceData_r9_IEs_epdu_RequestAssistanceData = SEQ_OF(name=u'epdu-RequestAssistanceData', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'EPDU-Sequence')), opt=True)
    RequestAssistanceData_r9_IEs._cont = ASN1Dict([
        (u'commonIEsRequestAssistanceData', _RequestAssistanceData_r9_IEs_commonIEsRequestAssistanceData),
        (u'a-gnss-RequestAssistanceData', _RequestAssistanceData_r9_IEs_a_gnss_RequestAssistanceData),
        (u'otdoa-RequestAssistanceData', _RequestAssistanceData_r9_IEs_otdoa_RequestAssistanceData),
        (u'epdu-RequestAssistanceData', _RequestAssistanceData_r9_IEs_epdu_RequestAssistanceData),
        ])
    RequestAssistanceData_r9_IEs._ext = []
    
    #-----< ProvideAssistanceData >-----#
    ProvideAssistanceData = SEQ(name=u'ProvideAssistanceData', mode=MODE_TYPE)
    _ProvideAssistanceData_criticalExtensions = CHOICE(name=u'criticalExtensions', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __ProvideAssistanceData_criticalExtensions_c1 = CHOICE(name=u'c1', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ___ProvideAssistanceData_criticalExtensions_c1_provideAssistanceData_r9 = SEQ(name=u'provideAssistanceData-r9', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'ProvideAssistanceData-r9-IEs')))
    ___ProvideAssistanceData_criticalExtensions_c1_spare3 = NULL(name=u'spare3', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___ProvideAssistanceData_criticalExtensions_c1_spare2 = NULL(name=u'spare2', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___ProvideAssistanceData_criticalExtensions_c1_spare1 = NULL(name=u'spare1', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __ProvideAssistanceData_criticalExtensions_c1._cont = ASN1Dict([
        (u'provideAssistanceData-r9', ___ProvideAssistanceData_criticalExtensions_c1_provideAssistanceData_r9),
        (u'spare3', ___ProvideAssistanceData_criticalExtensions_c1_spare3),
        (u'spare2', ___ProvideAssistanceData_criticalExtensions_c1_spare2),
        (u'spare1', ___ProvideAssistanceData_criticalExtensions_c1_spare1),
        ])
    __ProvideAssistanceData_criticalExtensions_c1._ext = None
    __ProvideAssistanceData_criticalExtensions_criticalExtensionsFuture = SEQ(name=u'criticalExtensionsFuture', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __ProvideAssistanceData_criticalExtensions_criticalExtensionsFuture._cont = ASN1Dict([
        ])
    __ProvideAssistanceData_criticalExtensions_criticalExtensionsFuture._ext = None
    _ProvideAssistanceData_criticalExtensions._cont = ASN1Dict([
        (u'c1', __ProvideAssistanceData_criticalExtensions_c1),
        (u'criticalExtensionsFuture', __ProvideAssistanceData_criticalExtensions_criticalExtensionsFuture),
        ])
    _ProvideAssistanceData_criticalExtensions._ext = None
    ProvideAssistanceData._cont = ASN1Dict([
        (u'criticalExtensions', _ProvideAssistanceData_criticalExtensions),
        ])
    ProvideAssistanceData._ext = None
    
    #-----< ProvideAssistanceData-r9-IEs >-----#
    ProvideAssistanceData_r9_IEs = SEQ(name=u'ProvideAssistanceData-r9-IEs', mode=MODE_TYPE)
    _ProvideAssistanceData_r9_IEs_commonIEsProvideAssistanceData = SEQ(name=u'commonIEsProvideAssistanceData', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'CommonIEsProvideAssistanceData')), opt=True)
    _ProvideAssistanceData_r9_IEs_a_gnss_ProvideAssistanceData = SEQ(name=u'a-gnss-ProvideAssistanceData', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'A-GNSS-ProvideAssistanceData')), opt=True)
    _ProvideAssistanceData_r9_IEs_otdoa_ProvideAssistanceData = SEQ(name=u'otdoa-ProvideAssistanceData', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'OTDOA-ProvideAssistanceData')), opt=True)
    _ProvideAssistanceData_r9_IEs_epdu_Provide_Assistance_Data = SEQ_OF(name=u'epdu-Provide-Assistance-Data', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'EPDU-Sequence')), opt=True)
    ProvideAssistanceData_r9_IEs._cont = ASN1Dict([
        (u'commonIEsProvideAssistanceData', _ProvideAssistanceData_r9_IEs_commonIEsProvideAssistanceData),
        (u'a-gnss-ProvideAssistanceData', _ProvideAssistanceData_r9_IEs_a_gnss_ProvideAssistanceData),
        (u'otdoa-ProvideAssistanceData', _ProvideAssistanceData_r9_IEs_otdoa_ProvideAssistanceData),
        (u'epdu-Provide-Assistance-Data', _ProvideAssistanceData_r9_IEs_epdu_Provide_Assistance_Data),
        ])
    ProvideAssistanceData_r9_IEs._ext = []
    
    #-----< RequestLocationInformation >-----#
    RequestLocationInformation = SEQ(name=u'RequestLocationInformation', mode=MODE_TYPE)
    _RequestLocationInformation_criticalExtensions = CHOICE(name=u'criticalExtensions', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __RequestLocationInformation_criticalExtensions_c1 = CHOICE(name=u'c1', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ___RequestLocationInformation_criticalExtensions_c1_requestLocationInformation_r9 = SEQ(name=u'requestLocationInformation-r9', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'RequestLocationInformation-r9-IEs')))
    ___RequestLocationInformation_criticalExtensions_c1_spare3 = NULL(name=u'spare3', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___RequestLocationInformation_criticalExtensions_c1_spare2 = NULL(name=u'spare2', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___RequestLocationInformation_criticalExtensions_c1_spare1 = NULL(name=u'spare1', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __RequestLocationInformation_criticalExtensions_c1._cont = ASN1Dict([
        (u'requestLocationInformation-r9', ___RequestLocationInformation_criticalExtensions_c1_requestLocationInformation_r9),
        (u'spare3', ___RequestLocationInformation_criticalExtensions_c1_spare3),
        (u'spare2', ___RequestLocationInformation_criticalExtensions_c1_spare2),
        (u'spare1', ___RequestLocationInformation_criticalExtensions_c1_spare1),
        ])
    __RequestLocationInformation_criticalExtensions_c1._ext = None
    __RequestLocationInformation_criticalExtensions_criticalExtensionsFuture = SEQ(name=u'criticalExtensionsFuture', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __RequestLocationInformation_criticalExtensions_criticalExtensionsFuture._cont = ASN1Dict([
        ])
    __RequestLocationInformation_criticalExtensions_criticalExtensionsFuture._ext = None
    _RequestLocationInformation_criticalExtensions._cont = ASN1Dict([
        (u'c1', __RequestLocationInformation_criticalExtensions_c1),
        (u'criticalExtensionsFuture', __RequestLocationInformation_criticalExtensions_criticalExtensionsFuture),
        ])
    _RequestLocationInformation_criticalExtensions._ext = None
    RequestLocationInformation._cont = ASN1Dict([
        (u'criticalExtensions', _RequestLocationInformation_criticalExtensions),
        ])
    RequestLocationInformation._ext = None
    
    #-----< RequestLocationInformation-r9-IEs >-----#
    RequestLocationInformation_r9_IEs = SEQ(name=u'RequestLocationInformation-r9-IEs', mode=MODE_TYPE)
    _RequestLocationInformation_r9_IEs_commonIEsRequestLocationInformation = SEQ(name=u'commonIEsRequestLocationInformation', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'CommonIEsRequestLocationInformation')), opt=True)
    _RequestLocationInformation_r9_IEs_a_gnss_RequestLocationInformation = SEQ(name=u'a-gnss-RequestLocationInformation', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'A-GNSS-RequestLocationInformation')), opt=True)
    _RequestLocationInformation_r9_IEs_otdoa_RequestLocationInformation = SEQ(name=u'otdoa-RequestLocationInformation', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'OTDOA-RequestLocationInformation')), opt=True)
    _RequestLocationInformation_r9_IEs_ecid_RequestLocationInformation = SEQ(name=u'ecid-RequestLocationInformation', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'ECID-RequestLocationInformation')), opt=True)
    _RequestLocationInformation_r9_IEs_epdu_RequestLocationInformation = SEQ_OF(name=u'epdu-RequestLocationInformation', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'EPDU-Sequence')), opt=True)
    _RequestLocationInformation_r9_IEs_sensor_RequestLocationInformation_r13 = SEQ(name=u'sensor-RequestLocationInformation-r13', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'Sensor-RequestLocationInformation-r13')), opt=True, group=0)
    _RequestLocationInformation_r9_IEs_tbs_RequestLocationInformation_r13 = SEQ(name=u'tbs-RequestLocationInformation-r13', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'TBS-RequestLocationInformation-r13')), opt=True, group=0)
    _RequestLocationInformation_r9_IEs_wlan_RequestLocationInformation_r13 = SEQ(name=u'wlan-RequestLocationInformation-r13', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'WLAN-RequestLocationInformation-r13')), opt=True, group=0)
    _RequestLocationInformation_r9_IEs_bt_RequestLocationInformation_r13 = SEQ(name=u'bt-RequestLocationInformation-r13', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'BT-RequestLocationInformation-r13')), opt=True, group=0)
    RequestLocationInformation_r9_IEs._cont = ASN1Dict([
        (u'commonIEsRequestLocationInformation', _RequestLocationInformation_r9_IEs_commonIEsRequestLocationInformation),
        (u'a-gnss-RequestLocationInformation', _RequestLocationInformation_r9_IEs_a_gnss_RequestLocationInformation),
        (u'otdoa-RequestLocationInformation', _RequestLocationInformation_r9_IEs_otdoa_RequestLocationInformation),
        (u'ecid-RequestLocationInformation', _RequestLocationInformation_r9_IEs_ecid_RequestLocationInformation),
        (u'epdu-RequestLocationInformation', _RequestLocationInformation_r9_IEs_epdu_RequestLocationInformation),
        (u'sensor-RequestLocationInformation-r13', _RequestLocationInformation_r9_IEs_sensor_RequestLocationInformation_r13),
        (u'tbs-RequestLocationInformation-r13', _RequestLocationInformation_r9_IEs_tbs_RequestLocationInformation_r13),
        (u'wlan-RequestLocationInformation-r13', _RequestLocationInformation_r9_IEs_wlan_RequestLocationInformation_r13),
        (u'bt-RequestLocationInformation-r13', _RequestLocationInformation_r9_IEs_bt_RequestLocationInformation_r13),
        ])
    RequestLocationInformation_r9_IEs._ext = [u'sensor-RequestLocationInformation-r13', u'tbs-RequestLocationInformation-r13', u'wlan-RequestLocationInformation-r13', u'bt-RequestLocationInformation-r13']
    
    #-----< ProvideLocationInformation >-----#
    ProvideLocationInformation = SEQ(name=u'ProvideLocationInformation', mode=MODE_TYPE)
    _ProvideLocationInformation_criticalExtensions = CHOICE(name=u'criticalExtensions', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __ProvideLocationInformation_criticalExtensions_c1 = CHOICE(name=u'c1', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ___ProvideLocationInformation_criticalExtensions_c1_provideLocationInformation_r9 = SEQ(name=u'provideLocationInformation-r9', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'ProvideLocationInformation-r9-IEs')))
    ___ProvideLocationInformation_criticalExtensions_c1_spare3 = NULL(name=u'spare3', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___ProvideLocationInformation_criticalExtensions_c1_spare2 = NULL(name=u'spare2', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___ProvideLocationInformation_criticalExtensions_c1_spare1 = NULL(name=u'spare1', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __ProvideLocationInformation_criticalExtensions_c1._cont = ASN1Dict([
        (u'provideLocationInformation-r9', ___ProvideLocationInformation_criticalExtensions_c1_provideLocationInformation_r9),
        (u'spare3', ___ProvideLocationInformation_criticalExtensions_c1_spare3),
        (u'spare2', ___ProvideLocationInformation_criticalExtensions_c1_spare2),
        (u'spare1', ___ProvideLocationInformation_criticalExtensions_c1_spare1),
        ])
    __ProvideLocationInformation_criticalExtensions_c1._ext = None
    __ProvideLocationInformation_criticalExtensions_criticalExtensionsFuture = SEQ(name=u'criticalExtensionsFuture', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __ProvideLocationInformation_criticalExtensions_criticalExtensionsFuture._cont = ASN1Dict([
        ])
    __ProvideLocationInformation_criticalExtensions_criticalExtensionsFuture._ext = None
    _ProvideLocationInformation_criticalExtensions._cont = ASN1Dict([
        (u'c1', __ProvideLocationInformation_criticalExtensions_c1),
        (u'criticalExtensionsFuture', __ProvideLocationInformation_criticalExtensions_criticalExtensionsFuture),
        ])
    _ProvideLocationInformation_criticalExtensions._ext = None
    ProvideLocationInformation._cont = ASN1Dict([
        (u'criticalExtensions', _ProvideLocationInformation_criticalExtensions),
        ])
    ProvideLocationInformation._ext = None
    
    #-----< ProvideLocationInformation-r9-IEs >-----#
    ProvideLocationInformation_r9_IEs = SEQ(name=u'ProvideLocationInformation-r9-IEs', mode=MODE_TYPE)
    _ProvideLocationInformation_r9_IEs_commonIEsProvideLocationInformation = SEQ(name=u'commonIEsProvideLocationInformation', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'CommonIEsProvideLocationInformation')), opt=True)
    _ProvideLocationInformation_r9_IEs_a_gnss_ProvideLocationInformation = SEQ(name=u'a-gnss-ProvideLocationInformation', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'A-GNSS-ProvideLocationInformation')), opt=True)
    _ProvideLocationInformation_r9_IEs_otdoa_ProvideLocationInformation = SEQ(name=u'otdoa-ProvideLocationInformation', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'OTDOA-ProvideLocationInformation')), opt=True)
    _ProvideLocationInformation_r9_IEs_ecid_ProvideLocationInformation = SEQ(name=u'ecid-ProvideLocationInformation', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'ECID-ProvideLocationInformation')), opt=True)
    _ProvideLocationInformation_r9_IEs_epdu_ProvideLocationInformation = SEQ_OF(name=u'epdu-ProvideLocationInformation', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'EPDU-Sequence')), opt=True)
    _ProvideLocationInformation_r9_IEs_sensor_ProvideLocationInformation_r13 = SEQ(name=u'sensor-ProvideLocationInformation-r13', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'Sensor-ProvideLocationInformation-r13')), opt=True, group=0)
    _ProvideLocationInformation_r9_IEs_tbs_ProvideLocationInformation_r13 = SEQ(name=u'tbs-ProvideLocationInformation-r13', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'TBS-ProvideLocationInformation-r13')), opt=True, group=0)
    _ProvideLocationInformation_r9_IEs_wlan_ProvideLocationInformation_r13 = SEQ(name=u'wlan-ProvideLocationInformation-r13', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'WLAN-ProvideLocationInformation-r13')), opt=True, group=0)
    _ProvideLocationInformation_r9_IEs_bt_ProvideLocationInformation_r13 = SEQ(name=u'bt-ProvideLocationInformation-r13', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'BT-ProvideLocationInformation-r13')), opt=True, group=0)
    ProvideLocationInformation_r9_IEs._cont = ASN1Dict([
        (u'commonIEsProvideLocationInformation', _ProvideLocationInformation_r9_IEs_commonIEsProvideLocationInformation),
        (u'a-gnss-ProvideLocationInformation', _ProvideLocationInformation_r9_IEs_a_gnss_ProvideLocationInformation),
        (u'otdoa-ProvideLocationInformation', _ProvideLocationInformation_r9_IEs_otdoa_ProvideLocationInformation),
        (u'ecid-ProvideLocationInformation', _ProvideLocationInformation_r9_IEs_ecid_ProvideLocationInformation),
        (u'epdu-ProvideLocationInformation', _ProvideLocationInformation_r9_IEs_epdu_ProvideLocationInformation),
        (u'sensor-ProvideLocationInformation-r13', _ProvideLocationInformation_r9_IEs_sensor_ProvideLocationInformation_r13),
        (u'tbs-ProvideLocationInformation-r13', _ProvideLocationInformation_r9_IEs_tbs_ProvideLocationInformation_r13),
        (u'wlan-ProvideLocationInformation-r13', _ProvideLocationInformation_r9_IEs_wlan_ProvideLocationInformation_r13),
        (u'bt-ProvideLocationInformation-r13', _ProvideLocationInformation_r9_IEs_bt_ProvideLocationInformation_r13),
        ])
    ProvideLocationInformation_r9_IEs._ext = [u'sensor-ProvideLocationInformation-r13', u'tbs-ProvideLocationInformation-r13', u'wlan-ProvideLocationInformation-r13', u'bt-ProvideLocationInformation-r13']
    
    #-----< Abort >-----#
    Abort = SEQ(name=u'Abort', mode=MODE_TYPE)
    _Abort_criticalExtensions = CHOICE(name=u'criticalExtensions', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __Abort_criticalExtensions_c1 = CHOICE(name=u'c1', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ___Abort_criticalExtensions_c1_abort_r9 = SEQ(name=u'abort-r9', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'Abort-r9-IEs')))
    ___Abort_criticalExtensions_c1_spare3 = NULL(name=u'spare3', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___Abort_criticalExtensions_c1_spare2 = NULL(name=u'spare2', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___Abort_criticalExtensions_c1_spare1 = NULL(name=u'spare1', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __Abort_criticalExtensions_c1._cont = ASN1Dict([
        (u'abort-r9', ___Abort_criticalExtensions_c1_abort_r9),
        (u'spare3', ___Abort_criticalExtensions_c1_spare3),
        (u'spare2', ___Abort_criticalExtensions_c1_spare2),
        (u'spare1', ___Abort_criticalExtensions_c1_spare1),
        ])
    __Abort_criticalExtensions_c1._ext = None
    __Abort_criticalExtensions_criticalExtensionsFuture = SEQ(name=u'criticalExtensionsFuture', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __Abort_criticalExtensions_criticalExtensionsFuture._cont = ASN1Dict([
        ])
    __Abort_criticalExtensions_criticalExtensionsFuture._ext = None
    _Abort_criticalExtensions._cont = ASN1Dict([
        (u'c1', __Abort_criticalExtensions_c1),
        (u'criticalExtensionsFuture', __Abort_criticalExtensions_criticalExtensionsFuture),
        ])
    _Abort_criticalExtensions._ext = None
    Abort._cont = ASN1Dict([
        (u'criticalExtensions', _Abort_criticalExtensions),
        ])
    Abort._ext = None
    
    #-----< Abort-r9-IEs >-----#
    Abort_r9_IEs = SEQ(name=u'Abort-r9-IEs', mode=MODE_TYPE)
    _Abort_r9_IEs_commonIEsAbort = SEQ(name=u'commonIEsAbort', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'CommonIEsAbort')), opt=True)
    _Abort_r9_IEs_epdu_Abort = SEQ_OF(name=u'epdu-Abort', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'EPDU-Sequence')), opt=True)
    Abort_r9_IEs._cont = ASN1Dict([
        (u'commonIEsAbort', _Abort_r9_IEs_commonIEsAbort),
        (u'epdu-Abort', _Abort_r9_IEs_epdu_Abort),
        ])
    Abort_r9_IEs._ext = [u'epdu-Abort']
    
    #-----< Error >-----#
    Error = CHOICE(name=u'Error', mode=MODE_TYPE)
    _Error_error_r9 = SEQ(name=u'error-r9', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'Error-r9-IEs')))
    _Error_criticalExtensionsFuture = SEQ(name=u'criticalExtensionsFuture', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _Error_criticalExtensionsFuture._cont = ASN1Dict([
        ])
    _Error_criticalExtensionsFuture._ext = None
    Error._cont = ASN1Dict([
        (u'error-r9', _Error_error_r9),
        (u'criticalExtensionsFuture', _Error_criticalExtensionsFuture),
        ])
    Error._ext = None
    
    #-----< Error-r9-IEs >-----#
    Error_r9_IEs = SEQ(name=u'Error-r9-IEs', mode=MODE_TYPE)
    _Error_r9_IEs_commonIEsError = SEQ(name=u'commonIEsError', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'CommonIEsError')), opt=True)
    _Error_r9_IEs_epdu_Error = SEQ_OF(name=u'epdu-Error', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'EPDU-Sequence')), opt=True)
    Error_r9_IEs._cont = ASN1Dict([
        (u'commonIEsError', _Error_r9_IEs_commonIEsError),
        (u'epdu-Error', _Error_r9_IEs_epdu_Error),
        ])
    Error_r9_IEs._ext = [u'epdu-Error']
    
    #-----< AccessTypes >-----#
    AccessTypes = SEQ(name=u'AccessTypes', mode=MODE_TYPE)
    _AccessTypes_accessTypes = BIT_STR(name=u'accessTypes', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AccessTypes_accessTypes._cont = ASN1Dict([(u'eutra', 0), (u'utra', 1), (u'gsm', 2)])
    _AccessTypes_accessTypes._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    AccessTypes._cont = ASN1Dict([
        (u'accessTypes', _AccessTypes_accessTypes),
        ])
    AccessTypes._ext = []
    
    #-----< ARFCN-ValueEUTRA >-----#
    ARFCN_ValueEUTRA = INT(name=u'ARFCN-ValueEUTRA', mode=MODE_TYPE)
    ARFCN_ValueEUTRA._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    
    #-----< ARFCN-ValueEUTRA-v9a0 >-----#
    ARFCN_ValueEUTRA_v9a0 = INT(name=u'ARFCN-ValueEUTRA-v9a0', mode=MODE_TYPE)
    ARFCN_ValueEUTRA_v9a0._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=65536, ub=262143)], ev=None, er=[])
    
    #-----< maxEARFCN >-----#
    maxEARFCN = INT(name=u'maxEARFCN', mode=MODE_VALUE)
    maxEARFCN._val = 65535
    
    #-----< maxEARFCN-Plus1 >-----#
    maxEARFCN_Plus1 = INT(name=u'maxEARFCN-Plus1', mode=MODE_VALUE)
    maxEARFCN_Plus1._val = 65536
    
    #-----< maxEARFCN2 >-----#
    maxEARFCN2 = INT(name=u'maxEARFCN2', mode=MODE_VALUE)
    maxEARFCN2._val = 262143
    
    #-----< ARFCN-ValueUTRA >-----#
    ARFCN_ValueUTRA = INT(name=u'ARFCN-ValueUTRA', mode=MODE_TYPE)
    ARFCN_ValueUTRA._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=16383)], ev=None, er=[])
    
    #-----< CellGlobalIdEUTRA-AndUTRA >-----#
    CellGlobalIdEUTRA_AndUTRA = SEQ(name=u'CellGlobalIdEUTRA-AndUTRA', mode=MODE_TYPE)
    _CellGlobalIdEUTRA_AndUTRA_plmn_Identity = SEQ(name=u'plmn-Identity', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __CellGlobalIdEUTRA_AndUTRA_plmn_Identity_mcc = SEQ_OF(name=u'mcc', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___CellGlobalIdEUTRA_AndUTRA_plmn_Identity_mcc__item_ = INT(name='_item_', mode=MODE_TYPE)
    ___CellGlobalIdEUTRA_AndUTRA_plmn_Identity_mcc__item_._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=9)], ev=None, er=[])
    __CellGlobalIdEUTRA_AndUTRA_plmn_Identity_mcc._cont = ___CellGlobalIdEUTRA_AndUTRA_plmn_Identity_mcc__item_
    __CellGlobalIdEUTRA_AndUTRA_plmn_Identity_mcc._const_sz = ASN1Set(rv=[3], rr=[], ev=None, er=[])
    __CellGlobalIdEUTRA_AndUTRA_plmn_Identity_mnc = SEQ_OF(name=u'mnc', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___CellGlobalIdEUTRA_AndUTRA_plmn_Identity_mnc__item_ = INT(name='_item_', mode=MODE_TYPE)
    ___CellGlobalIdEUTRA_AndUTRA_plmn_Identity_mnc__item_._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=9)], ev=None, er=[])
    __CellGlobalIdEUTRA_AndUTRA_plmn_Identity_mnc._cont = ___CellGlobalIdEUTRA_AndUTRA_plmn_Identity_mnc__item_
    __CellGlobalIdEUTRA_AndUTRA_plmn_Identity_mnc._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=2, ub=3)], ev=None, er=[])
    _CellGlobalIdEUTRA_AndUTRA_plmn_Identity._cont = ASN1Dict([
        (u'mcc', __CellGlobalIdEUTRA_AndUTRA_plmn_Identity_mcc),
        (u'mnc', __CellGlobalIdEUTRA_AndUTRA_plmn_Identity_mnc),
        ])
    _CellGlobalIdEUTRA_AndUTRA_plmn_Identity._ext = None
    _CellGlobalIdEUTRA_AndUTRA_cellIdentity = CHOICE(name=u'cellIdentity', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __CellGlobalIdEUTRA_AndUTRA_cellIdentity_eutra = BIT_STR(name=u'eutra', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __CellGlobalIdEUTRA_AndUTRA_cellIdentity_eutra._const_sz = ASN1Set(rv=[28], rr=[], ev=None, er=[])
    __CellGlobalIdEUTRA_AndUTRA_cellIdentity_utra = BIT_STR(name=u'utra', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __CellGlobalIdEUTRA_AndUTRA_cellIdentity_utra._const_sz = ASN1Set(rv=[32], rr=[], ev=None, er=[])
    _CellGlobalIdEUTRA_AndUTRA_cellIdentity._cont = ASN1Dict([
        (u'eutra', __CellGlobalIdEUTRA_AndUTRA_cellIdentity_eutra),
        (u'utra', __CellGlobalIdEUTRA_AndUTRA_cellIdentity_utra),
        ])
    _CellGlobalIdEUTRA_AndUTRA_cellIdentity._ext = None
    CellGlobalIdEUTRA_AndUTRA._cont = ASN1Dict([
        (u'plmn-Identity', _CellGlobalIdEUTRA_AndUTRA_plmn_Identity),
        (u'cellIdentity', _CellGlobalIdEUTRA_AndUTRA_cellIdentity),
        ])
    CellGlobalIdEUTRA_AndUTRA._ext = []
    
    #-----< CellGlobalIdGERAN >-----#
    CellGlobalIdGERAN = SEQ(name=u'CellGlobalIdGERAN', mode=MODE_TYPE)
    _CellGlobalIdGERAN_plmn_Identity = SEQ(name=u'plmn-Identity', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __CellGlobalIdGERAN_plmn_Identity_mcc = SEQ_OF(name=u'mcc', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___CellGlobalIdGERAN_plmn_Identity_mcc__item_ = INT(name='_item_', mode=MODE_TYPE)
    ___CellGlobalIdGERAN_plmn_Identity_mcc__item_._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=9)], ev=None, er=[])
    __CellGlobalIdGERAN_plmn_Identity_mcc._cont = ___CellGlobalIdGERAN_plmn_Identity_mcc__item_
    __CellGlobalIdGERAN_plmn_Identity_mcc._const_sz = ASN1Set(rv=[3], rr=[], ev=None, er=[])
    __CellGlobalIdGERAN_plmn_Identity_mnc = SEQ_OF(name=u'mnc', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___CellGlobalIdGERAN_plmn_Identity_mnc__item_ = INT(name='_item_', mode=MODE_TYPE)
    ___CellGlobalIdGERAN_plmn_Identity_mnc__item_._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=9)], ev=None, er=[])
    __CellGlobalIdGERAN_plmn_Identity_mnc._cont = ___CellGlobalIdGERAN_plmn_Identity_mnc__item_
    __CellGlobalIdGERAN_plmn_Identity_mnc._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=2, ub=3)], ev=None, er=[])
    _CellGlobalIdGERAN_plmn_Identity._cont = ASN1Dict([
        (u'mcc', __CellGlobalIdGERAN_plmn_Identity_mcc),
        (u'mnc', __CellGlobalIdGERAN_plmn_Identity_mnc),
        ])
    _CellGlobalIdGERAN_plmn_Identity._ext = None
    _CellGlobalIdGERAN_locationAreaCode = BIT_STR(name=u'locationAreaCode', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _CellGlobalIdGERAN_locationAreaCode._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _CellGlobalIdGERAN_cellIdentity = BIT_STR(name=u'cellIdentity', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _CellGlobalIdGERAN_cellIdentity._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    CellGlobalIdGERAN._cont = ASN1Dict([
        (u'plmn-Identity', _CellGlobalIdGERAN_plmn_Identity),
        (u'locationAreaCode', _CellGlobalIdGERAN_locationAreaCode),
        (u'cellIdentity', _CellGlobalIdGERAN_cellIdentity),
        ])
    CellGlobalIdGERAN._ext = []
    
    #-----< ECGI >-----#
    ECGI = SEQ(name=u'ECGI', mode=MODE_TYPE)
    _ECGI_mcc = SEQ_OF(name=u'mcc', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __ECGI_mcc__item_ = INT(name='_item_', mode=MODE_TYPE)
    __ECGI_mcc__item_._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=9)], ev=None, er=[])
    _ECGI_mcc._cont = __ECGI_mcc__item_
    _ECGI_mcc._const_sz = ASN1Set(rv=[3], rr=[], ev=None, er=[])
    _ECGI_mnc = SEQ_OF(name=u'mnc', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __ECGI_mnc__item_ = INT(name='_item_', mode=MODE_TYPE)
    __ECGI_mnc__item_._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=9)], ev=None, er=[])
    _ECGI_mnc._cont = __ECGI_mnc__item_
    _ECGI_mnc._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=2, ub=3)], ev=None, er=[])
    _ECGI_cellidentity = BIT_STR(name=u'cellidentity', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ECGI_cellidentity._const_sz = ASN1Set(rv=[28], rr=[], ev=None, er=[])
    ECGI._cont = ASN1Dict([
        (u'mcc', _ECGI_mcc),
        (u'mnc', _ECGI_mnc),
        (u'cellidentity', _ECGI_cellidentity),
        ])
    ECGI._ext = None
    
    #-----< Ellipsoid-Point >-----#
    Ellipsoid_Point = SEQ(name=u'Ellipsoid-Point', mode=MODE_TYPE)
    _Ellipsoid_Point_latitudeSign = ENUM(name=u'latitudeSign', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _Ellipsoid_Point_latitudeSign._cont = ASN1Dict([(u'north', 0), (u'south', 1)])
    _Ellipsoid_Point_latitudeSign._ext = None
    _Ellipsoid_Point_degreesLatitude = INT(name=u'degreesLatitude', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _Ellipsoid_Point_degreesLatitude._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=8388607)], ev=None, er=[])
    _Ellipsoid_Point_degreesLongitude = INT(name=u'degreesLongitude', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _Ellipsoid_Point_degreesLongitude._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-8388608, ub=8388607)], ev=None, er=[])
    Ellipsoid_Point._cont = ASN1Dict([
        (u'latitudeSign', _Ellipsoid_Point_latitudeSign),
        (u'degreesLatitude', _Ellipsoid_Point_degreesLatitude),
        (u'degreesLongitude', _Ellipsoid_Point_degreesLongitude),
        ])
    Ellipsoid_Point._ext = None
    
    #-----< Ellipsoid-PointWithUncertaintyCircle >-----#
    Ellipsoid_PointWithUncertaintyCircle = SEQ(name=u'Ellipsoid-PointWithUncertaintyCircle', mode=MODE_TYPE)
    _Ellipsoid_PointWithUncertaintyCircle_latitudeSign = ENUM(name=u'latitudeSign', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _Ellipsoid_PointWithUncertaintyCircle_latitudeSign._cont = ASN1Dict([(u'north', 0), (u'south', 1)])
    _Ellipsoid_PointWithUncertaintyCircle_latitudeSign._ext = None
    _Ellipsoid_PointWithUncertaintyCircle_degreesLatitude = INT(name=u'degreesLatitude', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _Ellipsoid_PointWithUncertaintyCircle_degreesLatitude._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=8388607)], ev=None, er=[])
    _Ellipsoid_PointWithUncertaintyCircle_degreesLongitude = INT(name=u'degreesLongitude', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _Ellipsoid_PointWithUncertaintyCircle_degreesLongitude._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-8388608, ub=8388607)], ev=None, er=[])
    _Ellipsoid_PointWithUncertaintyCircle_uncertainty = INT(name=u'uncertainty', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _Ellipsoid_PointWithUncertaintyCircle_uncertainty._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    Ellipsoid_PointWithUncertaintyCircle._cont = ASN1Dict([
        (u'latitudeSign', _Ellipsoid_PointWithUncertaintyCircle_latitudeSign),
        (u'degreesLatitude', _Ellipsoid_PointWithUncertaintyCircle_degreesLatitude),
        (u'degreesLongitude', _Ellipsoid_PointWithUncertaintyCircle_degreesLongitude),
        (u'uncertainty', _Ellipsoid_PointWithUncertaintyCircle_uncertainty),
        ])
    Ellipsoid_PointWithUncertaintyCircle._ext = None
    
    #-----< EllipsoidPointWithUncertaintyEllipse >-----#
    EllipsoidPointWithUncertaintyEllipse = SEQ(name=u'EllipsoidPointWithUncertaintyEllipse', mode=MODE_TYPE)
    _EllipsoidPointWithUncertaintyEllipse_latitudeSign = ENUM(name=u'latitudeSign', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EllipsoidPointWithUncertaintyEllipse_latitudeSign._cont = ASN1Dict([(u'north', 0), (u'south', 1)])
    _EllipsoidPointWithUncertaintyEllipse_latitudeSign._ext = None
    _EllipsoidPointWithUncertaintyEllipse_degreesLatitude = INT(name=u'degreesLatitude', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EllipsoidPointWithUncertaintyEllipse_degreesLatitude._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=8388607)], ev=None, er=[])
    _EllipsoidPointWithUncertaintyEllipse_degreesLongitude = INT(name=u'degreesLongitude', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EllipsoidPointWithUncertaintyEllipse_degreesLongitude._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-8388608, ub=8388607)], ev=None, er=[])
    _EllipsoidPointWithUncertaintyEllipse_uncertaintySemiMajor = INT(name=u'uncertaintySemiMajor', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EllipsoidPointWithUncertaintyEllipse_uncertaintySemiMajor._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    _EllipsoidPointWithUncertaintyEllipse_uncertaintySemiMinor = INT(name=u'uncertaintySemiMinor', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EllipsoidPointWithUncertaintyEllipse_uncertaintySemiMinor._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    _EllipsoidPointWithUncertaintyEllipse_orientationMajorAxis = INT(name=u'orientationMajorAxis', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EllipsoidPointWithUncertaintyEllipse_orientationMajorAxis._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=179)], ev=None, er=[])
    _EllipsoidPointWithUncertaintyEllipse_confidence = INT(name=u'confidence', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EllipsoidPointWithUncertaintyEllipse_confidence._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=100)], ev=None, er=[])
    EllipsoidPointWithUncertaintyEllipse._cont = ASN1Dict([
        (u'latitudeSign', _EllipsoidPointWithUncertaintyEllipse_latitudeSign),
        (u'degreesLatitude', _EllipsoidPointWithUncertaintyEllipse_degreesLatitude),
        (u'degreesLongitude', _EllipsoidPointWithUncertaintyEllipse_degreesLongitude),
        (u'uncertaintySemiMajor', _EllipsoidPointWithUncertaintyEllipse_uncertaintySemiMajor),
        (u'uncertaintySemiMinor', _EllipsoidPointWithUncertaintyEllipse_uncertaintySemiMinor),
        (u'orientationMajorAxis', _EllipsoidPointWithUncertaintyEllipse_orientationMajorAxis),
        (u'confidence', _EllipsoidPointWithUncertaintyEllipse_confidence),
        ])
    EllipsoidPointWithUncertaintyEllipse._ext = None
    
    #-----< EllipsoidPointWithAltitude >-----#
    EllipsoidPointWithAltitude = SEQ(name=u'EllipsoidPointWithAltitude', mode=MODE_TYPE)
    _EllipsoidPointWithAltitude_latitudeSign = ENUM(name=u'latitudeSign', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EllipsoidPointWithAltitude_latitudeSign._cont = ASN1Dict([(u'north', 0), (u'south', 1)])
    _EllipsoidPointWithAltitude_latitudeSign._ext = None
    _EllipsoidPointWithAltitude_degreesLatitude = INT(name=u'degreesLatitude', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EllipsoidPointWithAltitude_degreesLatitude._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=8388607)], ev=None, er=[])
    _EllipsoidPointWithAltitude_degreesLongitude = INT(name=u'degreesLongitude', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EllipsoidPointWithAltitude_degreesLongitude._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-8388608, ub=8388607)], ev=None, er=[])
    _EllipsoidPointWithAltitude_altitudeDirection = ENUM(name=u'altitudeDirection', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EllipsoidPointWithAltitude_altitudeDirection._cont = ASN1Dict([(u'height', 0), (u'depth', 1)])
    _EllipsoidPointWithAltitude_altitudeDirection._ext = None
    _EllipsoidPointWithAltitude_altitude = INT(name=u'altitude', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EllipsoidPointWithAltitude_altitude._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=32767)], ev=None, er=[])
    EllipsoidPointWithAltitude._cont = ASN1Dict([
        (u'latitudeSign', _EllipsoidPointWithAltitude_latitudeSign),
        (u'degreesLatitude', _EllipsoidPointWithAltitude_degreesLatitude),
        (u'degreesLongitude', _EllipsoidPointWithAltitude_degreesLongitude),
        (u'altitudeDirection', _EllipsoidPointWithAltitude_altitudeDirection),
        (u'altitude', _EllipsoidPointWithAltitude_altitude),
        ])
    EllipsoidPointWithAltitude._ext = None
    
    #-----< EllipsoidPointWithAltitudeAndUncertaintyEllipsoid >-----#
    EllipsoidPointWithAltitudeAndUncertaintyEllipsoid = SEQ(name=u'EllipsoidPointWithAltitudeAndUncertaintyEllipsoid', mode=MODE_TYPE)
    _EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_latitudeSign = ENUM(name=u'latitudeSign', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_latitudeSign._cont = ASN1Dict([(u'north', 0), (u'south', 1)])
    _EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_latitudeSign._ext = None
    _EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_degreesLatitude = INT(name=u'degreesLatitude', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_degreesLatitude._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=8388607)], ev=None, er=[])
    _EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_degreesLongitude = INT(name=u'degreesLongitude', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_degreesLongitude._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-8388608, ub=8388607)], ev=None, er=[])
    _EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_altitudeDirection = ENUM(name=u'altitudeDirection', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_altitudeDirection._cont = ASN1Dict([(u'height', 0), (u'depth', 1)])
    _EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_altitudeDirection._ext = None
    _EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_altitude = INT(name=u'altitude', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_altitude._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=32767)], ev=None, er=[])
    _EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_uncertaintySemiMajor = INT(name=u'uncertaintySemiMajor', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_uncertaintySemiMajor._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    _EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_uncertaintySemiMinor = INT(name=u'uncertaintySemiMinor', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_uncertaintySemiMinor._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    _EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_orientationMajorAxis = INT(name=u'orientationMajorAxis', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_orientationMajorAxis._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=179)], ev=None, er=[])
    _EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_uncertaintyAltitude = INT(name=u'uncertaintyAltitude', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_uncertaintyAltitude._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    _EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_confidence = INT(name=u'confidence', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_confidence._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=100)], ev=None, er=[])
    EllipsoidPointWithAltitudeAndUncertaintyEllipsoid._cont = ASN1Dict([
        (u'latitudeSign', _EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_latitudeSign),
        (u'degreesLatitude', _EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_degreesLatitude),
        (u'degreesLongitude', _EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_degreesLongitude),
        (u'altitudeDirection', _EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_altitudeDirection),
        (u'altitude', _EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_altitude),
        (u'uncertaintySemiMajor', _EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_uncertaintySemiMajor),
        (u'uncertaintySemiMinor', _EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_uncertaintySemiMinor),
        (u'orientationMajorAxis', _EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_orientationMajorAxis),
        (u'uncertaintyAltitude', _EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_uncertaintyAltitude),
        (u'confidence', _EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_confidence),
        ])
    EllipsoidPointWithAltitudeAndUncertaintyEllipsoid._ext = None
    
    #-----< EllipsoidArc >-----#
    EllipsoidArc = SEQ(name=u'EllipsoidArc', mode=MODE_TYPE)
    _EllipsoidArc_latitudeSign = ENUM(name=u'latitudeSign', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EllipsoidArc_latitudeSign._cont = ASN1Dict([(u'north', 0), (u'south', 1)])
    _EllipsoidArc_latitudeSign._ext = None
    _EllipsoidArc_degreesLatitude = INT(name=u'degreesLatitude', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EllipsoidArc_degreesLatitude._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=8388607)], ev=None, er=[])
    _EllipsoidArc_degreesLongitude = INT(name=u'degreesLongitude', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EllipsoidArc_degreesLongitude._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-8388608, ub=8388607)], ev=None, er=[])
    _EllipsoidArc_innerRadius = INT(name=u'innerRadius', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EllipsoidArc_innerRadius._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    _EllipsoidArc_uncertaintyRadius = INT(name=u'uncertaintyRadius', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EllipsoidArc_uncertaintyRadius._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    _EllipsoidArc_offsetAngle = INT(name=u'offsetAngle', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EllipsoidArc_offsetAngle._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=179)], ev=None, er=[])
    _EllipsoidArc_includedAngle = INT(name=u'includedAngle', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EllipsoidArc_includedAngle._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=179)], ev=None, er=[])
    _EllipsoidArc_confidence = INT(name=u'confidence', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EllipsoidArc_confidence._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=100)], ev=None, er=[])
    EllipsoidArc._cont = ASN1Dict([
        (u'latitudeSign', _EllipsoidArc_latitudeSign),
        (u'degreesLatitude', _EllipsoidArc_degreesLatitude),
        (u'degreesLongitude', _EllipsoidArc_degreesLongitude),
        (u'innerRadius', _EllipsoidArc_innerRadius),
        (u'uncertaintyRadius', _EllipsoidArc_uncertaintyRadius),
        (u'offsetAngle', _EllipsoidArc_offsetAngle),
        (u'includedAngle', _EllipsoidArc_includedAngle),
        (u'confidence', _EllipsoidArc_confidence),
        ])
    EllipsoidArc._ext = None
    
    #-----< EPDU-Sequence >-----#
    EPDU_Sequence = SEQ_OF(name=u'EPDU-Sequence', mode=MODE_TYPE)
    _EPDU_Sequence__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('LPP-PDU-Definitions', 'EPDU')))
    EPDU_Sequence._cont = _EPDU_Sequence__item_
    EPDU_Sequence._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    
    #-----< maxEPDU >-----#
    maxEPDU = INT(name=u'maxEPDU', mode=MODE_VALUE)
    maxEPDU._val = 16
    
    #-----< EPDU >-----#
    EPDU = SEQ(name=u'EPDU', mode=MODE_TYPE)
    _EPDU_ePDU_Identifier = SEQ(name=u'ePDU-Identifier', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'EPDU-Identifier')))
    _EPDU_ePDU_Body = OCT_STR(name=u'ePDU-Body', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'EPDU-Body')))
    EPDU._cont = ASN1Dict([
        (u'ePDU-Identifier', _EPDU_ePDU_Identifier),
        (u'ePDU-Body', _EPDU_ePDU_Body),
        ])
    EPDU._ext = None
    
    #-----< EPDU-Identifier >-----#
    EPDU_Identifier = SEQ(name=u'EPDU-Identifier', mode=MODE_TYPE)
    _EPDU_Identifier_ePDU_ID = INT(name=u'ePDU-ID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'EPDU-ID')))
    _EPDU_Identifier_ePDU_Name = STR_VIS(name=u'ePDU-Name', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'EPDU-Name')), opt=True)
    EPDU_Identifier._cont = ASN1Dict([
        (u'ePDU-ID', _EPDU_Identifier_ePDU_ID),
        (u'ePDU-Name', _EPDU_Identifier_ePDU_Name),
        ])
    EPDU_Identifier._ext = []
    
    #-----< EPDU-ID >-----#
    EPDU_ID = INT(name=u'EPDU-ID', mode=MODE_TYPE)
    EPDU_ID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    
    #-----< EPDU-Name >-----#
    EPDU_Name = STR_VIS(name=u'EPDU-Name', mode=MODE_TYPE)
    EPDU_Name._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    
    #-----< EPDU-Body >-----#
    EPDU_Body = OCT_STR(name=u'EPDU-Body', mode=MODE_TYPE)
    
    #-----< HorizontalVelocity >-----#
    HorizontalVelocity = SEQ(name=u'HorizontalVelocity', mode=MODE_TYPE)
    _HorizontalVelocity_bearing = INT(name=u'bearing', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _HorizontalVelocity_bearing._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=359)], ev=None, er=[])
    _HorizontalVelocity_horizontalSpeed = INT(name=u'horizontalSpeed', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _HorizontalVelocity_horizontalSpeed._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=2047)], ev=None, er=[])
    HorizontalVelocity._cont = ASN1Dict([
        (u'bearing', _HorizontalVelocity_bearing),
        (u'horizontalSpeed', _HorizontalVelocity_horizontalSpeed),
        ])
    HorizontalVelocity._ext = None
    
    #-----< HorizontalWithVerticalVelocity >-----#
    HorizontalWithVerticalVelocity = SEQ(name=u'HorizontalWithVerticalVelocity', mode=MODE_TYPE)
    _HorizontalWithVerticalVelocity_bearing = INT(name=u'bearing', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _HorizontalWithVerticalVelocity_bearing._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=359)], ev=None, er=[])
    _HorizontalWithVerticalVelocity_horizontalSpeed = INT(name=u'horizontalSpeed', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _HorizontalWithVerticalVelocity_horizontalSpeed._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=2047)], ev=None, er=[])
    _HorizontalWithVerticalVelocity_verticalDirection = ENUM(name=u'verticalDirection', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _HorizontalWithVerticalVelocity_verticalDirection._cont = ASN1Dict([(u'upward', 0), (u'downward', 1)])
    _HorizontalWithVerticalVelocity_verticalDirection._ext = None
    _HorizontalWithVerticalVelocity_verticalSpeed = INT(name=u'verticalSpeed', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _HorizontalWithVerticalVelocity_verticalSpeed._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    HorizontalWithVerticalVelocity._cont = ASN1Dict([
        (u'bearing', _HorizontalWithVerticalVelocity_bearing),
        (u'horizontalSpeed', _HorizontalWithVerticalVelocity_horizontalSpeed),
        (u'verticalDirection', _HorizontalWithVerticalVelocity_verticalDirection),
        (u'verticalSpeed', _HorizontalWithVerticalVelocity_verticalSpeed),
        ])
    HorizontalWithVerticalVelocity._ext = None
    
    #-----< HorizontalVelocityWithUncertainty >-----#
    HorizontalVelocityWithUncertainty = SEQ(name=u'HorizontalVelocityWithUncertainty', mode=MODE_TYPE)
    _HorizontalVelocityWithUncertainty_bearing = INT(name=u'bearing', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _HorizontalVelocityWithUncertainty_bearing._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=359)], ev=None, er=[])
    _HorizontalVelocityWithUncertainty_horizontalSpeed = INT(name=u'horizontalSpeed', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _HorizontalVelocityWithUncertainty_horizontalSpeed._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=2047)], ev=None, er=[])
    _HorizontalVelocityWithUncertainty_uncertaintySpeed = INT(name=u'uncertaintySpeed', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _HorizontalVelocityWithUncertainty_uncertaintySpeed._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    HorizontalVelocityWithUncertainty._cont = ASN1Dict([
        (u'bearing', _HorizontalVelocityWithUncertainty_bearing),
        (u'horizontalSpeed', _HorizontalVelocityWithUncertainty_horizontalSpeed),
        (u'uncertaintySpeed', _HorizontalVelocityWithUncertainty_uncertaintySpeed),
        ])
    HorizontalVelocityWithUncertainty._ext = None
    
    #-----< HorizontalWithVerticalVelocityAndUncertainty >-----#
    HorizontalWithVerticalVelocityAndUncertainty = SEQ(name=u'HorizontalWithVerticalVelocityAndUncertainty', mode=MODE_TYPE)
    _HorizontalWithVerticalVelocityAndUncertainty_bearing = INT(name=u'bearing', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _HorizontalWithVerticalVelocityAndUncertainty_bearing._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=359)], ev=None, er=[])
    _HorizontalWithVerticalVelocityAndUncertainty_horizontalSpeed = INT(name=u'horizontalSpeed', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _HorizontalWithVerticalVelocityAndUncertainty_horizontalSpeed._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=2047)], ev=None, er=[])
    _HorizontalWithVerticalVelocityAndUncertainty_verticalDirection = ENUM(name=u'verticalDirection', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _HorizontalWithVerticalVelocityAndUncertainty_verticalDirection._cont = ASN1Dict([(u'upward', 0), (u'downward', 1)])
    _HorizontalWithVerticalVelocityAndUncertainty_verticalDirection._ext = None
    _HorizontalWithVerticalVelocityAndUncertainty_verticalSpeed = INT(name=u'verticalSpeed', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _HorizontalWithVerticalVelocityAndUncertainty_verticalSpeed._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _HorizontalWithVerticalVelocityAndUncertainty_horizontalUncertaintySpeed = INT(name=u'horizontalUncertaintySpeed', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _HorizontalWithVerticalVelocityAndUncertainty_horizontalUncertaintySpeed._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _HorizontalWithVerticalVelocityAndUncertainty_verticalUncertaintySpeed = INT(name=u'verticalUncertaintySpeed', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _HorizontalWithVerticalVelocityAndUncertainty_verticalUncertaintySpeed._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    HorizontalWithVerticalVelocityAndUncertainty._cont = ASN1Dict([
        (u'bearing', _HorizontalWithVerticalVelocityAndUncertainty_bearing),
        (u'horizontalSpeed', _HorizontalWithVerticalVelocityAndUncertainty_horizontalSpeed),
        (u'verticalDirection', _HorizontalWithVerticalVelocityAndUncertainty_verticalDirection),
        (u'verticalSpeed', _HorizontalWithVerticalVelocityAndUncertainty_verticalSpeed),
        (u'horizontalUncertaintySpeed', _HorizontalWithVerticalVelocityAndUncertainty_horizontalUncertaintySpeed),
        (u'verticalUncertaintySpeed', _HorizontalWithVerticalVelocityAndUncertainty_verticalUncertaintySpeed),
        ])
    HorizontalWithVerticalVelocityAndUncertainty._ext = None
    
    #-----< LocationCoordinateTypes >-----#
    LocationCoordinateTypes = SEQ(name=u'LocationCoordinateTypes', mode=MODE_TYPE)
    _LocationCoordinateTypes_ellipsoidPoint = BOOL(name=u'ellipsoidPoint', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _LocationCoordinateTypes_ellipsoidPointWithUncertaintyCircle = BOOL(name=u'ellipsoidPointWithUncertaintyCircle', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _LocationCoordinateTypes_ellipsoidPointWithUncertaintyEllipse = BOOL(name=u'ellipsoidPointWithUncertaintyEllipse', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _LocationCoordinateTypes_polygon = BOOL(name=u'polygon', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _LocationCoordinateTypes_ellipsoidPointWithAltitude = BOOL(name=u'ellipsoidPointWithAltitude', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _LocationCoordinateTypes_ellipsoidPointWithAltitudeAndUncertaintyEllipsoid = BOOL(name=u'ellipsoidPointWithAltitudeAndUncertaintyEllipsoid', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _LocationCoordinateTypes_ellipsoidArc = BOOL(name=u'ellipsoidArc', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    LocationCoordinateTypes._cont = ASN1Dict([
        (u'ellipsoidPoint', _LocationCoordinateTypes_ellipsoidPoint),
        (u'ellipsoidPointWithUncertaintyCircle', _LocationCoordinateTypes_ellipsoidPointWithUncertaintyCircle),
        (u'ellipsoidPointWithUncertaintyEllipse', _LocationCoordinateTypes_ellipsoidPointWithUncertaintyEllipse),
        (u'polygon', _LocationCoordinateTypes_polygon),
        (u'ellipsoidPointWithAltitude', _LocationCoordinateTypes_ellipsoidPointWithAltitude),
        (u'ellipsoidPointWithAltitudeAndUncertaintyEllipsoid', _LocationCoordinateTypes_ellipsoidPointWithAltitudeAndUncertaintyEllipsoid),
        (u'ellipsoidArc', _LocationCoordinateTypes_ellipsoidArc),
        ])
    LocationCoordinateTypes._ext = []
    
    #-----< Polygon >-----#
    Polygon = SEQ_OF(name=u'Polygon', mode=MODE_TYPE)
    _Polygon__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('LPP-PDU-Definitions', 'PolygonPoints')))
    Polygon._cont = _Polygon__item_
    Polygon._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=3, ub=15)], ev=None, er=[])
    
    #-----< PolygonPoints >-----#
    PolygonPoints = SEQ(name=u'PolygonPoints', mode=MODE_TYPE)
    _PolygonPoints_latitudeSign = ENUM(name=u'latitudeSign', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _PolygonPoints_latitudeSign._cont = ASN1Dict([(u'north', 0), (u'south', 1)])
    _PolygonPoints_latitudeSign._ext = None
    _PolygonPoints_degreesLatitude = INT(name=u'degreesLatitude', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _PolygonPoints_degreesLatitude._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=8388607)], ev=None, er=[])
    _PolygonPoints_degreesLongitude = INT(name=u'degreesLongitude', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _PolygonPoints_degreesLongitude._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-8388608, ub=8388607)], ev=None, er=[])
    PolygonPoints._cont = ASN1Dict([
        (u'latitudeSign', _PolygonPoints_latitudeSign),
        (u'degreesLatitude', _PolygonPoints_degreesLatitude),
        (u'degreesLongitude', _PolygonPoints_degreesLongitude),
        ])
    PolygonPoints._ext = None
    
    #-----< PositioningModes >-----#
    PositioningModes = SEQ(name=u'PositioningModes', mode=MODE_TYPE)
    _PositioningModes_posModes = BIT_STR(name=u'posModes', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _PositioningModes_posModes._cont = ASN1Dict([(u'standalone', 0), (u'ue-based', 1), (u'ue-assisted', 2)])
    _PositioningModes_posModes._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    PositioningModes._cont = ASN1Dict([
        (u'posModes', _PositioningModes_posModes),
        ])
    PositioningModes._ext = []
    
    #-----< VelocityTypes >-----#
    VelocityTypes = SEQ(name=u'VelocityTypes', mode=MODE_TYPE)
    _VelocityTypes_horizontalVelocity = BOOL(name=u'horizontalVelocity', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _VelocityTypes_horizontalWithVerticalVelocity = BOOL(name=u'horizontalWithVerticalVelocity', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _VelocityTypes_horizontalVelocityWithUncertainty = BOOL(name=u'horizontalVelocityWithUncertainty', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _VelocityTypes_horizontalWithVerticalVelocityAndUncertainty = BOOL(name=u'horizontalWithVerticalVelocityAndUncertainty', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    VelocityTypes._cont = ASN1Dict([
        (u'horizontalVelocity', _VelocityTypes_horizontalVelocity),
        (u'horizontalWithVerticalVelocity', _VelocityTypes_horizontalWithVerticalVelocity),
        (u'horizontalVelocityWithUncertainty', _VelocityTypes_horizontalVelocityWithUncertainty),
        (u'horizontalWithVerticalVelocityAndUncertainty', _VelocityTypes_horizontalWithVerticalVelocityAndUncertainty),
        ])
    VelocityTypes._ext = []
    
    #-----< CommonIEsRequestCapabilities >-----#
    CommonIEsRequestCapabilities = SEQ(name=u'CommonIEsRequestCapabilities', mode=MODE_TYPE)
    CommonIEsRequestCapabilities._cont = ASN1Dict([
        ])
    CommonIEsRequestCapabilities._ext = []
    
    #-----< CommonIEsProvideCapabilities >-----#
    CommonIEsProvideCapabilities = SEQ(name=u'CommonIEsProvideCapabilities', mode=MODE_TYPE)
    CommonIEsProvideCapabilities._cont = ASN1Dict([
        ])
    CommonIEsProvideCapabilities._ext = []
    
    #-----< CommonIEsRequestAssistanceData >-----#
    CommonIEsRequestAssistanceData = SEQ(name=u'CommonIEsRequestAssistanceData', mode=MODE_TYPE)
    _CommonIEsRequestAssistanceData_primaryCellID = SEQ(name=u'primaryCellID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'ECGI')), opt=True)
    CommonIEsRequestAssistanceData._cont = ASN1Dict([
        (u'primaryCellID', _CommonIEsRequestAssistanceData_primaryCellID),
        ])
    CommonIEsRequestAssistanceData._ext = []
    
    #-----< CommonIEsProvideAssistanceData >-----#
    CommonIEsProvideAssistanceData = SEQ(name=u'CommonIEsProvideAssistanceData', mode=MODE_TYPE)
    CommonIEsProvideAssistanceData._cont = ASN1Dict([
        ])
    CommonIEsProvideAssistanceData._ext = []
    
    #-----< CommonIEsRequestLocationInformation >-----#
    CommonIEsRequestLocationInformation = SEQ(name=u'CommonIEsRequestLocationInformation', mode=MODE_TYPE)
    _CommonIEsRequestLocationInformation_locationInformationType = ENUM(name=u'locationInformationType', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'LocationInformationType')))
    _CommonIEsRequestLocationInformation_triggeredReporting = SEQ(name=u'triggeredReporting', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'TriggeredReportingCriteria')), opt=True)
    _CommonIEsRequestLocationInformation_periodicalReporting = SEQ(name=u'periodicalReporting', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'PeriodicalReportingCriteria')), opt=True)
    _CommonIEsRequestLocationInformation_additionalInformation = ENUM(name=u'additionalInformation', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'AdditionalInformation')), opt=True)
    _CommonIEsRequestLocationInformation_qos = SEQ(name=u'qos', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'QoS')), opt=True)
    _CommonIEsRequestLocationInformation_environment = ENUM(name=u'environment', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'Environment')), opt=True)
    _CommonIEsRequestLocationInformation_locationCoordinateTypes = SEQ(name=u'locationCoordinateTypes', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'LocationCoordinateTypes')), opt=True)
    _CommonIEsRequestLocationInformation_velocityTypes = SEQ(name=u'velocityTypes', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'VelocityTypes')), opt=True)
    CommonIEsRequestLocationInformation._cont = ASN1Dict([
        (u'locationInformationType', _CommonIEsRequestLocationInformation_locationInformationType),
        (u'triggeredReporting', _CommonIEsRequestLocationInformation_triggeredReporting),
        (u'periodicalReporting', _CommonIEsRequestLocationInformation_periodicalReporting),
        (u'additionalInformation', _CommonIEsRequestLocationInformation_additionalInformation),
        (u'qos', _CommonIEsRequestLocationInformation_qos),
        (u'environment', _CommonIEsRequestLocationInformation_environment),
        (u'locationCoordinateTypes', _CommonIEsRequestLocationInformation_locationCoordinateTypes),
        (u'velocityTypes', _CommonIEsRequestLocationInformation_velocityTypes),
        ])
    CommonIEsRequestLocationInformation._ext = []
    
    #-----< LocationInformationType >-----#
    LocationInformationType = ENUM(name=u'LocationInformationType', mode=MODE_TYPE)
    LocationInformationType._cont = ASN1Dict([(u'locationEstimateRequired', 0), (u'locationMeasurementsRequired', 1), (u'locationEstimatePreferred', 2), (u'locationMeasurementsPreferred', 3)])
    LocationInformationType._ext = []
    
    #-----< PeriodicalReportingCriteria >-----#
    PeriodicalReportingCriteria = SEQ(name=u'PeriodicalReportingCriteria', mode=MODE_TYPE)
    _PeriodicalReportingCriteria_reportingAmount = ENUM(name=u'reportingAmount', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), default=u'ra-Infinity')
    _PeriodicalReportingCriteria_reportingAmount._cont = ASN1Dict([(u'ra1', 0), (u'ra2', 1), (u'ra4', 2), (u'ra8', 3), (u'ra16', 4), (u'ra32', 5), (u'ra64', 6), (u'ra-Infinity', 7)])
    _PeriodicalReportingCriteria_reportingAmount._ext = None
    _PeriodicalReportingCriteria_reportingInterval = ENUM(name=u'reportingInterval', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _PeriodicalReportingCriteria_reportingInterval._cont = ASN1Dict([(u'noPeriodicalReporting', 0), (u'ri0-25', 1), (u'ri0-5', 2), (u'ri1', 3), (u'ri2', 4), (u'ri4', 5), (u'ri8', 6), (u'ri16', 7), (u'ri32', 8), (u'ri64', 9)])
    _PeriodicalReportingCriteria_reportingInterval._ext = None
    PeriodicalReportingCriteria._cont = ASN1Dict([
        (u'reportingAmount', _PeriodicalReportingCriteria_reportingAmount),
        (u'reportingInterval', _PeriodicalReportingCriteria_reportingInterval),
        ])
    PeriodicalReportingCriteria._ext = None
    
    #-----< TriggeredReportingCriteria >-----#
    TriggeredReportingCriteria = SEQ(name=u'TriggeredReportingCriteria', mode=MODE_TYPE)
    _TriggeredReportingCriteria_cellChange = BOOL(name=u'cellChange', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _TriggeredReportingCriteria_reportingDuration = INT(name=u'reportingDuration', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'ReportingDuration')))
    TriggeredReportingCriteria._cont = ASN1Dict([
        (u'cellChange', _TriggeredReportingCriteria_cellChange),
        (u'reportingDuration', _TriggeredReportingCriteria_reportingDuration),
        ])
    TriggeredReportingCriteria._ext = []
    
    #-----< ReportingDuration >-----#
    ReportingDuration = INT(name=u'ReportingDuration', mode=MODE_TYPE)
    ReportingDuration._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    
    #-----< AdditionalInformation >-----#
    AdditionalInformation = ENUM(name=u'AdditionalInformation', mode=MODE_TYPE)
    AdditionalInformation._cont = ASN1Dict([(u'onlyReturnInformationRequested', 0), (u'mayReturnAditionalInformation', 1)])
    AdditionalInformation._ext = []
    
    #-----< QoS >-----#
    QoS = SEQ(name=u'QoS', mode=MODE_TYPE)
    _QoS_horizontalAccuracy = SEQ(name=u'horizontalAccuracy', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'HorizontalAccuracy')), opt=True)
    _QoS_verticalCoordinateRequest = BOOL(name=u'verticalCoordinateRequest', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _QoS_verticalAccuracy = SEQ(name=u'verticalAccuracy', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'VerticalAccuracy')), opt=True)
    _QoS_responseTime = SEQ(name=u'responseTime', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'ResponseTime')), opt=True)
    _QoS_velocityRequest = BOOL(name=u'velocityRequest', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    QoS._cont = ASN1Dict([
        (u'horizontalAccuracy', _QoS_horizontalAccuracy),
        (u'verticalCoordinateRequest', _QoS_verticalCoordinateRequest),
        (u'verticalAccuracy', _QoS_verticalAccuracy),
        (u'responseTime', _QoS_responseTime),
        (u'velocityRequest', _QoS_velocityRequest),
        ])
    QoS._ext = []
    
    #-----< HorizontalAccuracy >-----#
    HorizontalAccuracy = SEQ(name=u'HorizontalAccuracy', mode=MODE_TYPE)
    _HorizontalAccuracy_accuracy = INT(name=u'accuracy', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _HorizontalAccuracy_accuracy._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    _HorizontalAccuracy_confidence = INT(name=u'confidence', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _HorizontalAccuracy_confidence._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=100)], ev=None, er=[])
    HorizontalAccuracy._cont = ASN1Dict([
        (u'accuracy', _HorizontalAccuracy_accuracy),
        (u'confidence', _HorizontalAccuracy_confidence),
        ])
    HorizontalAccuracy._ext = []
    
    #-----< VerticalAccuracy >-----#
    VerticalAccuracy = SEQ(name=u'VerticalAccuracy', mode=MODE_TYPE)
    _VerticalAccuracy_accuracy = INT(name=u'accuracy', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _VerticalAccuracy_accuracy._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    _VerticalAccuracy_confidence = INT(name=u'confidence', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _VerticalAccuracy_confidence._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=100)], ev=None, er=[])
    VerticalAccuracy._cont = ASN1Dict([
        (u'accuracy', _VerticalAccuracy_accuracy),
        (u'confidence', _VerticalAccuracy_confidence),
        ])
    VerticalAccuracy._ext = []
    
    #-----< ResponseTime >-----#
    ResponseTime = SEQ(name=u'ResponseTime', mode=MODE_TYPE)
    _ResponseTime_time = INT(name=u'time', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ResponseTime_time._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _ResponseTime_responseTimeEarlyFix_r12 = INT(name=u'responseTimeEarlyFix-r12', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True, group=0)
    _ResponseTime_responseTimeEarlyFix_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    ResponseTime._cont = ASN1Dict([
        (u'time', _ResponseTime_time),
        (u'responseTimeEarlyFix-r12', _ResponseTime_responseTimeEarlyFix_r12),
        ])
    ResponseTime._ext = [u'responseTimeEarlyFix-r12']
    
    #-----< Environment >-----#
    Environment = ENUM(name=u'Environment', mode=MODE_TYPE)
    Environment._cont = ASN1Dict([(u'badArea', 0), (u'notBadArea', 1), (u'mixedArea', 2)])
    Environment._ext = []
    
    #-----< CommonIEsProvideLocationInformation >-----#
    CommonIEsProvideLocationInformation = SEQ(name=u'CommonIEsProvideLocationInformation', mode=MODE_TYPE)
    _CommonIEsProvideLocationInformation_locationEstimate = CHOICE(name=u'locationEstimate', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'LocationCoordinates')), opt=True)
    _CommonIEsProvideLocationInformation_velocityEstimate = CHOICE(name=u'velocityEstimate', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'Velocity')), opt=True)
    _CommonIEsProvideLocationInformation_locationError = SEQ(name=u'locationError', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'LocationError')), opt=True)
    _CommonIEsProvideLocationInformation_earlyFixReport_r12 = ENUM(name=u'earlyFixReport-r12', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'EarlyFixReport-r12')), opt=True, group=0)
    _CommonIEsProvideLocationInformation_locationSource_r13 = BIT_STR(name=u'locationSource-r13', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'LocationSource-r13')), opt=True, group=1)
    _CommonIEsProvideLocationInformation_locationTimestamp_r13 = TIME_UTC(name=u'locationTimestamp-r13', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True, group=1)
    CommonIEsProvideLocationInformation._cont = ASN1Dict([
        (u'locationEstimate', _CommonIEsProvideLocationInformation_locationEstimate),
        (u'velocityEstimate', _CommonIEsProvideLocationInformation_velocityEstimate),
        (u'locationError', _CommonIEsProvideLocationInformation_locationError),
        (u'earlyFixReport-r12', _CommonIEsProvideLocationInformation_earlyFixReport_r12),
        (u'locationSource-r13', _CommonIEsProvideLocationInformation_locationSource_r13),
        (u'locationTimestamp-r13', _CommonIEsProvideLocationInformation_locationTimestamp_r13),
        ])
    CommonIEsProvideLocationInformation._ext = [u'earlyFixReport-r12', u'locationSource-r13', u'locationTimestamp-r13']
    
    #-----< LocationCoordinates >-----#
    LocationCoordinates = CHOICE(name=u'LocationCoordinates', mode=MODE_TYPE)
    _LocationCoordinates_ellipsoidPoint = SEQ(name=u'ellipsoidPoint', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'Ellipsoid-Point')))
    _LocationCoordinates_ellipsoidPointWithUncertaintyCircle = SEQ(name=u'ellipsoidPointWithUncertaintyCircle', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'Ellipsoid-PointWithUncertaintyCircle')))
    _LocationCoordinates_ellipsoidPointWithUncertaintyEllipse = SEQ(name=u'ellipsoidPointWithUncertaintyEllipse', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'EllipsoidPointWithUncertaintyEllipse')))
    _LocationCoordinates_polygon = SEQ_OF(name=u'polygon', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'Polygon')))
    _LocationCoordinates_ellipsoidPointWithAltitude = SEQ(name=u'ellipsoidPointWithAltitude', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'EllipsoidPointWithAltitude')))
    _LocationCoordinates_ellipsoidPointWithAltitudeAndUncertaintyEllipsoid = SEQ(name=u'ellipsoidPointWithAltitudeAndUncertaintyEllipsoid', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'EllipsoidPointWithAltitudeAndUncertaintyEllipsoid')))
    _LocationCoordinates_ellipsoidArc = SEQ(name=u'ellipsoidArc', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'EllipsoidArc')))
    LocationCoordinates._cont = ASN1Dict([
        (u'ellipsoidPoint', _LocationCoordinates_ellipsoidPoint),
        (u'ellipsoidPointWithUncertaintyCircle', _LocationCoordinates_ellipsoidPointWithUncertaintyCircle),
        (u'ellipsoidPointWithUncertaintyEllipse', _LocationCoordinates_ellipsoidPointWithUncertaintyEllipse),
        (u'polygon', _LocationCoordinates_polygon),
        (u'ellipsoidPointWithAltitude', _LocationCoordinates_ellipsoidPointWithAltitude),
        (u'ellipsoidPointWithAltitudeAndUncertaintyEllipsoid', _LocationCoordinates_ellipsoidPointWithAltitudeAndUncertaintyEllipsoid),
        (u'ellipsoidArc', _LocationCoordinates_ellipsoidArc),
        ])
    LocationCoordinates._ext = []
    
    #-----< Velocity >-----#
    Velocity = CHOICE(name=u'Velocity', mode=MODE_TYPE)
    _Velocity_horizontalVelocity = SEQ(name=u'horizontalVelocity', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'HorizontalVelocity')))
    _Velocity_horizontalWithVerticalVelocity = SEQ(name=u'horizontalWithVerticalVelocity', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'HorizontalWithVerticalVelocity')))
    _Velocity_horizontalVelocityWithUncertainty = SEQ(name=u'horizontalVelocityWithUncertainty', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'HorizontalVelocityWithUncertainty')))
    _Velocity_horizontalWithVerticalVelocityAndUncertainty = SEQ(name=u'horizontalWithVerticalVelocityAndUncertainty', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'HorizontalWithVerticalVelocityAndUncertainty')))
    Velocity._cont = ASN1Dict([
        (u'horizontalVelocity', _Velocity_horizontalVelocity),
        (u'horizontalWithVerticalVelocity', _Velocity_horizontalWithVerticalVelocity),
        (u'horizontalVelocityWithUncertainty', _Velocity_horizontalVelocityWithUncertainty),
        (u'horizontalWithVerticalVelocityAndUncertainty', _Velocity_horizontalWithVerticalVelocityAndUncertainty),
        ])
    Velocity._ext = []
    
    #-----< LocationError >-----#
    LocationError = SEQ(name=u'LocationError', mode=MODE_TYPE)
    _LocationError_locationfailurecause = ENUM(name=u'locationfailurecause', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'LocationFailureCause')))
    LocationError._cont = ASN1Dict([
        (u'locationfailurecause', _LocationError_locationfailurecause),
        ])
    LocationError._ext = []
    
    #-----< LocationFailureCause >-----#
    LocationFailureCause = ENUM(name=u'LocationFailureCause', mode=MODE_TYPE)
    LocationFailureCause._cont = ASN1Dict([(u'undefined', 0), (u'requestedMethodNotSupported', 1), (u'positionMethodFailure', 2), (u'periodicLocationMeasurementsNotAvailable', 3)])
    LocationFailureCause._ext = []
    
    #-----< EarlyFixReport-r12 >-----#
    EarlyFixReport_r12 = ENUM(name=u'EarlyFixReport-r12', mode=MODE_TYPE)
    EarlyFixReport_r12._cont = ASN1Dict([(u'noMoreMessages', 0), (u'moreMessagesOnTheWay', 1)])
    EarlyFixReport_r12._ext = None
    
    #-----< LocationSource-r13 >-----#
    LocationSource_r13 = BIT_STR(name=u'LocationSource-r13', mode=MODE_TYPE)
    LocationSource_r13._cont = ASN1Dict([(u'a-gnss', 0), (u'wlan', 1), (u'bt', 2), (u'tbs', 3), (u'sensor', 4)])
    LocationSource_r13._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    
    #-----< CommonIEsAbort >-----#
    CommonIEsAbort = SEQ(name=u'CommonIEsAbort', mode=MODE_TYPE)
    _CommonIEsAbort_abortCause = ENUM(name=u'abortCause', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _CommonIEsAbort_abortCause._cont = ASN1Dict([(u'undefined', 0), (u'stopPeriodicReporting', 1), (u'targetDeviceAbort', 2), (u'networkAbort', 3)])
    _CommonIEsAbort_abortCause._ext = []
    CommonIEsAbort._cont = ASN1Dict([
        (u'abortCause', _CommonIEsAbort_abortCause),
        ])
    CommonIEsAbort._ext = None
    
    #-----< CommonIEsError >-----#
    CommonIEsError = SEQ(name=u'CommonIEsError', mode=MODE_TYPE)
    _CommonIEsError_errorCause = ENUM(name=u'errorCause', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _CommonIEsError_errorCause._cont = ASN1Dict([(u'undefined', 0), (u'lppMessageHeaderError', 1), (u'lppMessageBodyError', 2), (u'epduError', 3), (u'incorrectDataValue', 4)])
    _CommonIEsError_errorCause._ext = []
    CommonIEsError._cont = ASN1Dict([
        (u'errorCause', _CommonIEsError_errorCause),
        ])
    CommonIEsError._ext = None
    
    #-----< OTDOA-ProvideAssistanceData >-----#
    OTDOA_ProvideAssistanceData = SEQ(name=u'OTDOA-ProvideAssistanceData', mode=MODE_TYPE)
    _OTDOA_ProvideAssistanceData_otdoa_ReferenceCellInfo = SEQ(name=u'otdoa-ReferenceCellInfo', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'OTDOA-ReferenceCellInfo')), opt=True)
    _OTDOA_ProvideAssistanceData_otdoa_NeighbourCellInfo = SEQ_OF(name=u'otdoa-NeighbourCellInfo', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'OTDOA-NeighbourCellInfoList')), opt=True)
    _OTDOA_ProvideAssistanceData_otdoa_Error = CHOICE(name=u'otdoa-Error', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'OTDOA-Error')), opt=True)
    OTDOA_ProvideAssistanceData._cont = ASN1Dict([
        (u'otdoa-ReferenceCellInfo', _OTDOA_ProvideAssistanceData_otdoa_ReferenceCellInfo),
        (u'otdoa-NeighbourCellInfo', _OTDOA_ProvideAssistanceData_otdoa_NeighbourCellInfo),
        (u'otdoa-Error', _OTDOA_ProvideAssistanceData_otdoa_Error),
        ])
    OTDOA_ProvideAssistanceData._ext = []
    
    #-----< OTDOA-ReferenceCellInfo >-----#
    OTDOA_ReferenceCellInfo = SEQ(name=u'OTDOA-ReferenceCellInfo', mode=MODE_TYPE)
    _OTDOA_ReferenceCellInfo_physCellId = INT(name=u'physCellId', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OTDOA_ReferenceCellInfo_physCellId._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=503)], ev=None, er=[])
    _OTDOA_ReferenceCellInfo_cellGlobalId = SEQ(name=u'cellGlobalId', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'ECGI')), opt=True)
    _OTDOA_ReferenceCellInfo_earfcnRef = INT(name=u'earfcnRef', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'ARFCN-ValueEUTRA')), opt=True)
    _OTDOA_ReferenceCellInfo_antennaPortConfig = ENUM(name=u'antennaPortConfig', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OTDOA_ReferenceCellInfo_antennaPortConfig._cont = ASN1Dict([(u'ports1-or-2', 0), (u'ports4', 1)])
    _OTDOA_ReferenceCellInfo_antennaPortConfig._ext = []
    _OTDOA_ReferenceCellInfo_cpLength = ENUM(name=u'cpLength', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OTDOA_ReferenceCellInfo_cpLength._cont = ASN1Dict([(u'normal', 0), (u'extended', 1)])
    _OTDOA_ReferenceCellInfo_cpLength._ext = []
    _OTDOA_ReferenceCellInfo_prsInfo = SEQ(name=u'prsInfo', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'PRS-Info')), opt=True)
    _OTDOA_ReferenceCellInfo_earfcnRef_v9a0 = INT(name=u'earfcnRef-v9a0', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'ARFCN-ValueEUTRA-v9a0')), opt=True, group=0)
    OTDOA_ReferenceCellInfo._cont = ASN1Dict([
        (u'physCellId', _OTDOA_ReferenceCellInfo_physCellId),
        (u'cellGlobalId', _OTDOA_ReferenceCellInfo_cellGlobalId),
        (u'earfcnRef', _OTDOA_ReferenceCellInfo_earfcnRef),
        (u'antennaPortConfig', _OTDOA_ReferenceCellInfo_antennaPortConfig),
        (u'cpLength', _OTDOA_ReferenceCellInfo_cpLength),
        (u'prsInfo', _OTDOA_ReferenceCellInfo_prsInfo),
        (u'earfcnRef-v9a0', _OTDOA_ReferenceCellInfo_earfcnRef_v9a0),
        ])
    OTDOA_ReferenceCellInfo._ext = [u'earfcnRef-v9a0']
    
    #-----< PRS-Info >-----#
    PRS_Info = SEQ(name=u'PRS-Info', mode=MODE_TYPE)
    _PRS_Info_prs_Bandwidth = ENUM(name=u'prs-Bandwidth', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _PRS_Info_prs_Bandwidth._cont = ASN1Dict([(u'n6', 0), (u'n15', 1), (u'n25', 2), (u'n50', 3), (u'n75', 4), (u'n100', 5)])
    _PRS_Info_prs_Bandwidth._ext = []
    _PRS_Info_prs_ConfigurationIndex = INT(name=u'prs-ConfigurationIndex', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _PRS_Info_prs_ConfigurationIndex._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4095)], ev=None, er=[])
    _PRS_Info_numDL_Frames = ENUM(name=u'numDL-Frames', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _PRS_Info_numDL_Frames._cont = ASN1Dict([(u'sf-1', 0), (u'sf-2', 1), (u'sf-4', 2), (u'sf-6', 3)])
    _PRS_Info_numDL_Frames._ext = []
    _PRS_Info_prs_MutingInfo_r9 = CHOICE(name=u'prs-MutingInfo-r9', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __PRS_Info_prs_MutingInfo_r9_po2_r9 = BIT_STR(name=u'po2-r9', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __PRS_Info_prs_MutingInfo_r9_po2_r9._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    __PRS_Info_prs_MutingInfo_r9_po4_r9 = BIT_STR(name=u'po4-r9', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __PRS_Info_prs_MutingInfo_r9_po4_r9._const_sz = ASN1Set(rv=[4], rr=[], ev=None, er=[])
    __PRS_Info_prs_MutingInfo_r9_po8_r9 = BIT_STR(name=u'po8-r9', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __PRS_Info_prs_MutingInfo_r9_po8_r9._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    __PRS_Info_prs_MutingInfo_r9_po16_r9 = BIT_STR(name=u'po16-r9', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __PRS_Info_prs_MutingInfo_r9_po16_r9._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _PRS_Info_prs_MutingInfo_r9._cont = ASN1Dict([
        (u'po2-r9', __PRS_Info_prs_MutingInfo_r9_po2_r9),
        (u'po4-r9', __PRS_Info_prs_MutingInfo_r9_po4_r9),
        (u'po8-r9', __PRS_Info_prs_MutingInfo_r9_po8_r9),
        (u'po16-r9', __PRS_Info_prs_MutingInfo_r9_po16_r9),
        ])
    _PRS_Info_prs_MutingInfo_r9._ext = []
    PRS_Info._cont = ASN1Dict([
        (u'prs-Bandwidth', _PRS_Info_prs_Bandwidth),
        (u'prs-ConfigurationIndex', _PRS_Info_prs_ConfigurationIndex),
        (u'numDL-Frames', _PRS_Info_numDL_Frames),
        (u'prs-MutingInfo-r9', _PRS_Info_prs_MutingInfo_r9),
        ])
    PRS_Info._ext = [u'prs-MutingInfo-r9']
    
    #-----< OTDOA-NeighbourCellInfoList >-----#
    OTDOA_NeighbourCellInfoList = SEQ_OF(name=u'OTDOA-NeighbourCellInfoList', mode=MODE_TYPE)
    _OTDOA_NeighbourCellInfoList__item_ = SEQ_OF(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('LPP-PDU-Definitions', 'OTDOA-NeighbourFreqInfo')))
    OTDOA_NeighbourCellInfoList._cont = _OTDOA_NeighbourCellInfoList__item_
    OTDOA_NeighbourCellInfoList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=3)], ev=None, er=[])
    
    #-----< OTDOA-NeighbourFreqInfo >-----#
    OTDOA_NeighbourFreqInfo = SEQ_OF(name=u'OTDOA-NeighbourFreqInfo', mode=MODE_TYPE)
    _OTDOA_NeighbourFreqInfo__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('LPP-PDU-Definitions', 'OTDOA-NeighbourCellInfoElement')))
    OTDOA_NeighbourFreqInfo._cont = _OTDOA_NeighbourFreqInfo__item_
    OTDOA_NeighbourFreqInfo._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=24)], ev=None, er=[])
    
    #-----< OTDOA-NeighbourCellInfoElement >-----#
    OTDOA_NeighbourCellInfoElement = SEQ(name=u'OTDOA-NeighbourCellInfoElement', mode=MODE_TYPE)
    _OTDOA_NeighbourCellInfoElement_physCellId = INT(name=u'physCellId', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OTDOA_NeighbourCellInfoElement_physCellId._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=503)], ev=None, er=[])
    _OTDOA_NeighbourCellInfoElement_cellGlobalId = SEQ(name=u'cellGlobalId', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'ECGI')), opt=True)
    _OTDOA_NeighbourCellInfoElement_earfcn = INT(name=u'earfcn', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'ARFCN-ValueEUTRA')), opt=True)
    _OTDOA_NeighbourCellInfoElement_cpLength = ENUM(name=u'cpLength', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OTDOA_NeighbourCellInfoElement_cpLength._cont = ASN1Dict([(u'normal', 0), (u'extended', 1)])
    _OTDOA_NeighbourCellInfoElement_cpLength._ext = []
    _OTDOA_NeighbourCellInfoElement_prsInfo = SEQ(name=u'prsInfo', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'PRS-Info')), opt=True)
    _OTDOA_NeighbourCellInfoElement_antennaPortConfig = ENUM(name=u'antennaPortConfig', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OTDOA_NeighbourCellInfoElement_antennaPortConfig._cont = ASN1Dict([(u'ports-1-or-2', 0), (u'ports-4', 1)])
    _OTDOA_NeighbourCellInfoElement_antennaPortConfig._ext = []
    _OTDOA_NeighbourCellInfoElement_slotNumberOffset = INT(name=u'slotNumberOffset', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OTDOA_NeighbourCellInfoElement_slotNumberOffset._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=19)], ev=None, er=[])
    _OTDOA_NeighbourCellInfoElement_prs_SubframeOffset = INT(name=u'prs-SubframeOffset', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OTDOA_NeighbourCellInfoElement_prs_SubframeOffset._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=1279)], ev=None, er=[])
    _OTDOA_NeighbourCellInfoElement_expectedRSTD = INT(name=u'expectedRSTD', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OTDOA_NeighbourCellInfoElement_expectedRSTD._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=16383)], ev=None, er=[])
    _OTDOA_NeighbourCellInfoElement_expectedRSTD_Uncertainty = INT(name=u'expectedRSTD-Uncertainty', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OTDOA_NeighbourCellInfoElement_expectedRSTD_Uncertainty._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=1023)], ev=None, er=[])
    _OTDOA_NeighbourCellInfoElement_earfcn_v9a0 = INT(name=u'earfcn-v9a0', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'ARFCN-ValueEUTRA-v9a0')), opt=True, group=0)
    OTDOA_NeighbourCellInfoElement._cont = ASN1Dict([
        (u'physCellId', _OTDOA_NeighbourCellInfoElement_physCellId),
        (u'cellGlobalId', _OTDOA_NeighbourCellInfoElement_cellGlobalId),
        (u'earfcn', _OTDOA_NeighbourCellInfoElement_earfcn),
        (u'cpLength', _OTDOA_NeighbourCellInfoElement_cpLength),
        (u'prsInfo', _OTDOA_NeighbourCellInfoElement_prsInfo),
        (u'antennaPortConfig', _OTDOA_NeighbourCellInfoElement_antennaPortConfig),
        (u'slotNumberOffset', _OTDOA_NeighbourCellInfoElement_slotNumberOffset),
        (u'prs-SubframeOffset', _OTDOA_NeighbourCellInfoElement_prs_SubframeOffset),
        (u'expectedRSTD', _OTDOA_NeighbourCellInfoElement_expectedRSTD),
        (u'expectedRSTD-Uncertainty', _OTDOA_NeighbourCellInfoElement_expectedRSTD_Uncertainty),
        (u'earfcn-v9a0', _OTDOA_NeighbourCellInfoElement_earfcn_v9a0),
        ])
    OTDOA_NeighbourCellInfoElement._ext = [u'earfcn-v9a0']
    
    #-----< maxFreqLayers >-----#
    maxFreqLayers = INT(name=u'maxFreqLayers', mode=MODE_VALUE)
    maxFreqLayers._val = 3
    
    #-----< OTDOA-RequestAssistanceData >-----#
    OTDOA_RequestAssistanceData = SEQ(name=u'OTDOA-RequestAssistanceData', mode=MODE_TYPE)
    _OTDOA_RequestAssistanceData_physCellId = INT(name=u'physCellId', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OTDOA_RequestAssistanceData_physCellId._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=503)], ev=None, er=[])
    OTDOA_RequestAssistanceData._cont = ASN1Dict([
        (u'physCellId', _OTDOA_RequestAssistanceData_physCellId),
        ])
    OTDOA_RequestAssistanceData._ext = []
    
    #-----< OTDOA-ProvideLocationInformation >-----#
    OTDOA_ProvideLocationInformation = SEQ(name=u'OTDOA-ProvideLocationInformation', mode=MODE_TYPE)
    _OTDOA_ProvideLocationInformation_otdoaSignalMeasurementInformation = SEQ(name=u'otdoaSignalMeasurementInformation', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'OTDOA-SignalMeasurementInformation')), opt=True)
    _OTDOA_ProvideLocationInformation_otdoa_Error = CHOICE(name=u'otdoa-Error', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'OTDOA-Error')), opt=True)
    OTDOA_ProvideLocationInformation._cont = ASN1Dict([
        (u'otdoaSignalMeasurementInformation', _OTDOA_ProvideLocationInformation_otdoaSignalMeasurementInformation),
        (u'otdoa-Error', _OTDOA_ProvideLocationInformation_otdoa_Error),
        ])
    OTDOA_ProvideLocationInformation._ext = []
    
    #-----< OTDOA-SignalMeasurementInformation >-----#
    OTDOA_SignalMeasurementInformation = SEQ(name=u'OTDOA-SignalMeasurementInformation', mode=MODE_TYPE)
    _OTDOA_SignalMeasurementInformation_systemFrameNumber = BIT_STR(name=u'systemFrameNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OTDOA_SignalMeasurementInformation_systemFrameNumber._const_sz = ASN1Set(rv=[10], rr=[], ev=None, er=[])
    _OTDOA_SignalMeasurementInformation_physCellIdRef = INT(name=u'physCellIdRef', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OTDOA_SignalMeasurementInformation_physCellIdRef._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=503)], ev=None, er=[])
    _OTDOA_SignalMeasurementInformation_cellGlobalIdRef = SEQ(name=u'cellGlobalIdRef', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'ECGI')), opt=True)
    _OTDOA_SignalMeasurementInformation_earfcnRef = INT(name=u'earfcnRef', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'ARFCN-ValueEUTRA')), opt=True)
    _OTDOA_SignalMeasurementInformation_referenceQuality = SEQ(name=u'referenceQuality', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'OTDOA-MeasQuality')), opt=True)
    _OTDOA_SignalMeasurementInformation_neighbourMeasurementList = SEQ_OF(name=u'neighbourMeasurementList', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'NeighbourMeasurementList')))
    _OTDOA_SignalMeasurementInformation_earfcnRef_v9a0 = INT(name=u'earfcnRef-v9a0', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'ARFCN-ValueEUTRA-v9a0')), opt=True, group=0)
    OTDOA_SignalMeasurementInformation._cont = ASN1Dict([
        (u'systemFrameNumber', _OTDOA_SignalMeasurementInformation_systemFrameNumber),
        (u'physCellIdRef', _OTDOA_SignalMeasurementInformation_physCellIdRef),
        (u'cellGlobalIdRef', _OTDOA_SignalMeasurementInformation_cellGlobalIdRef),
        (u'earfcnRef', _OTDOA_SignalMeasurementInformation_earfcnRef),
        (u'referenceQuality', _OTDOA_SignalMeasurementInformation_referenceQuality),
        (u'neighbourMeasurementList', _OTDOA_SignalMeasurementInformation_neighbourMeasurementList),
        (u'earfcnRef-v9a0', _OTDOA_SignalMeasurementInformation_earfcnRef_v9a0),
        ])
    OTDOA_SignalMeasurementInformation._ext = [u'earfcnRef-v9a0']
    
    #-----< NeighbourMeasurementList >-----#
    NeighbourMeasurementList = SEQ_OF(name=u'NeighbourMeasurementList', mode=MODE_TYPE)
    _NeighbourMeasurementList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('LPP-PDU-Definitions', 'NeighbourMeasurementElement')))
    NeighbourMeasurementList._cont = _NeighbourMeasurementList__item_
    NeighbourMeasurementList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=24)], ev=None, er=[])
    
    #-----< NeighbourMeasurementElement >-----#
    NeighbourMeasurementElement = SEQ(name=u'NeighbourMeasurementElement', mode=MODE_TYPE)
    _NeighbourMeasurementElement_physCellIdNeighbour = INT(name=u'physCellIdNeighbour', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NeighbourMeasurementElement_physCellIdNeighbour._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=503)], ev=None, er=[])
    _NeighbourMeasurementElement_cellGlobalIdNeighbour = SEQ(name=u'cellGlobalIdNeighbour', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'ECGI')), opt=True)
    _NeighbourMeasurementElement_earfcnNeighbour = INT(name=u'earfcnNeighbour', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'ARFCN-ValueEUTRA')), opt=True)
    _NeighbourMeasurementElement_rstd = INT(name=u'rstd', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NeighbourMeasurementElement_rstd._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=12711)], ev=None, er=[])
    _NeighbourMeasurementElement_rstd_Quality = SEQ(name=u'rstd-Quality', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'OTDOA-MeasQuality')))
    _NeighbourMeasurementElement_earfcnNeighbour_v9a0 = INT(name=u'earfcnNeighbour-v9a0', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'ARFCN-ValueEUTRA-v9a0')), opt=True, group=0)
    NeighbourMeasurementElement._cont = ASN1Dict([
        (u'physCellIdNeighbour', _NeighbourMeasurementElement_physCellIdNeighbour),
        (u'cellGlobalIdNeighbour', _NeighbourMeasurementElement_cellGlobalIdNeighbour),
        (u'earfcnNeighbour', _NeighbourMeasurementElement_earfcnNeighbour),
        (u'rstd', _NeighbourMeasurementElement_rstd),
        (u'rstd-Quality', _NeighbourMeasurementElement_rstd_Quality),
        (u'earfcnNeighbour-v9a0', _NeighbourMeasurementElement_earfcnNeighbour_v9a0),
        ])
    NeighbourMeasurementElement._ext = [u'earfcnNeighbour-v9a0']
    
    #-----< OTDOA-MeasQuality >-----#
    OTDOA_MeasQuality = SEQ(name=u'OTDOA-MeasQuality', mode=MODE_TYPE)
    _OTDOA_MeasQuality_error_Resolution = BIT_STR(name=u'error-Resolution', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OTDOA_MeasQuality_error_Resolution._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    _OTDOA_MeasQuality_error_Value = BIT_STR(name=u'error-Value', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OTDOA_MeasQuality_error_Value._const_sz = ASN1Set(rv=[5], rr=[], ev=None, er=[])
    _OTDOA_MeasQuality_error_NumSamples = BIT_STR(name=u'error-NumSamples', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OTDOA_MeasQuality_error_NumSamples._const_sz = ASN1Set(rv=[3], rr=[], ev=None, er=[])
    OTDOA_MeasQuality._cont = ASN1Dict([
        (u'error-Resolution', _OTDOA_MeasQuality_error_Resolution),
        (u'error-Value', _OTDOA_MeasQuality_error_Value),
        (u'error-NumSamples', _OTDOA_MeasQuality_error_NumSamples),
        ])
    OTDOA_MeasQuality._ext = []
    
    #-----< OTDOA-RequestLocationInformation >-----#
    OTDOA_RequestLocationInformation = SEQ(name=u'OTDOA-RequestLocationInformation', mode=MODE_TYPE)
    _OTDOA_RequestLocationInformation_assistanceAvailability = BOOL(name=u'assistanceAvailability', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    OTDOA_RequestLocationInformation._cont = ASN1Dict([
        (u'assistanceAvailability', _OTDOA_RequestLocationInformation_assistanceAvailability),
        ])
    OTDOA_RequestLocationInformation._ext = []
    
    #-----< OTDOA-ProvideCapabilities >-----#
    OTDOA_ProvideCapabilities = SEQ(name=u'OTDOA-ProvideCapabilities', mode=MODE_TYPE)
    _OTDOA_ProvideCapabilities_otdoa_Mode = BIT_STR(name=u'otdoa-Mode', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OTDOA_ProvideCapabilities_otdoa_Mode._cont = ASN1Dict([(u'ue-assisted', 0)])
    _OTDOA_ProvideCapabilities_otdoa_Mode._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    _OTDOA_ProvideCapabilities_supportedBandListEUTRA = SEQ_OF(name=u'supportedBandListEUTRA', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OTDOA_ProvideCapabilities_supportedBandListEUTRA__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('LPP-PDU-Definitions', 'SupportedBandEUTRA')))
    _OTDOA_ProvideCapabilities_supportedBandListEUTRA._cont = __OTDOA_ProvideCapabilities_supportedBandListEUTRA__item_
    _OTDOA_ProvideCapabilities_supportedBandListEUTRA._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _OTDOA_ProvideCapabilities_supportedBandListEUTRA_v9a0 = SEQ_OF(name=u'supportedBandListEUTRA-v9a0', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OTDOA_ProvideCapabilities_supportedBandListEUTRA_v9a0__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('LPP-PDU-Definitions', 'SupportedBandEUTRA-v9a0')))
    _OTDOA_ProvideCapabilities_supportedBandListEUTRA_v9a0._cont = __OTDOA_ProvideCapabilities_supportedBandListEUTRA_v9a0__item_
    _OTDOA_ProvideCapabilities_supportedBandListEUTRA_v9a0._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _OTDOA_ProvideCapabilities_interFreqRSTDmeasurement_r10 = ENUM(name=u'interFreqRSTDmeasurement-r10', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OTDOA_ProvideCapabilities_interFreqRSTDmeasurement_r10._cont = ASN1Dict([(u'supported', 0)])
    _OTDOA_ProvideCapabilities_interFreqRSTDmeasurement_r10._ext = None
    _OTDOA_ProvideCapabilities_additionalNeighbourCellInfoList_r10 = ENUM(name=u'additionalNeighbourCellInfoList-r10', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OTDOA_ProvideCapabilities_additionalNeighbourCellInfoList_r10._cont = ASN1Dict([(u'supported', 0)])
    _OTDOA_ProvideCapabilities_additionalNeighbourCellInfoList_r10._ext = None
    OTDOA_ProvideCapabilities._cont = ASN1Dict([
        (u'otdoa-Mode', _OTDOA_ProvideCapabilities_otdoa_Mode),
        (u'supportedBandListEUTRA', _OTDOA_ProvideCapabilities_supportedBandListEUTRA),
        (u'supportedBandListEUTRA-v9a0', _OTDOA_ProvideCapabilities_supportedBandListEUTRA_v9a0),
        (u'interFreqRSTDmeasurement-r10', _OTDOA_ProvideCapabilities_interFreqRSTDmeasurement_r10),
        (u'additionalNeighbourCellInfoList-r10', _OTDOA_ProvideCapabilities_additionalNeighbourCellInfoList_r10),
        ])
    OTDOA_ProvideCapabilities._ext = [u'supportedBandListEUTRA', u'supportedBandListEUTRA-v9a0', u'interFreqRSTDmeasurement-r10', u'additionalNeighbourCellInfoList-r10']
    
    #-----< maxBands >-----#
    maxBands = INT(name=u'maxBands', mode=MODE_VALUE)
    maxBands._val = 64
    
    #-----< SupportedBandEUTRA >-----#
    SupportedBandEUTRA = SEQ(name=u'SupportedBandEUTRA', mode=MODE_TYPE)
    _SupportedBandEUTRA_bandEUTRA = INT(name=u'bandEUTRA', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _SupportedBandEUTRA_bandEUTRA._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    SupportedBandEUTRA._cont = ASN1Dict([
        (u'bandEUTRA', _SupportedBandEUTRA_bandEUTRA),
        ])
    SupportedBandEUTRA._ext = None
    
    #-----< SupportedBandEUTRA-v9a0 >-----#
    SupportedBandEUTRA_v9a0 = SEQ(name=u'SupportedBandEUTRA-v9a0', mode=MODE_TYPE)
    _SupportedBandEUTRA_v9a0_bandEUTRA_v9a0 = INT(name=u'bandEUTRA-v9a0', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _SupportedBandEUTRA_v9a0_bandEUTRA_v9a0._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=65, ub=256)], ev=None, er=[])
    SupportedBandEUTRA_v9a0._cont = ASN1Dict([
        (u'bandEUTRA-v9a0', _SupportedBandEUTRA_v9a0_bandEUTRA_v9a0),
        ])
    SupportedBandEUTRA_v9a0._ext = None
    
    #-----< maxFBI >-----#
    maxFBI = INT(name=u'maxFBI', mode=MODE_VALUE)
    maxFBI._val = 64
    
    #-----< maxFBI-Plus1 >-----#
    maxFBI_Plus1 = INT(name=u'maxFBI-Plus1', mode=MODE_VALUE)
    maxFBI_Plus1._val = 65
    
    #-----< maxFBI2 >-----#
    maxFBI2 = INT(name=u'maxFBI2', mode=MODE_VALUE)
    maxFBI2._val = 256
    
    #-----< OTDOA-RequestCapabilities >-----#
    OTDOA_RequestCapabilities = SEQ(name=u'OTDOA-RequestCapabilities', mode=MODE_TYPE)
    OTDOA_RequestCapabilities._cont = ASN1Dict([
        ])
    OTDOA_RequestCapabilities._ext = []
    
    #-----< OTDOA-Error >-----#
    OTDOA_Error = CHOICE(name=u'OTDOA-Error', mode=MODE_TYPE)
    _OTDOA_Error_locationServerErrorCauses = SEQ(name=u'locationServerErrorCauses', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'OTDOA-LocationServerErrorCauses')))
    _OTDOA_Error_targetDeviceErrorCauses = SEQ(name=u'targetDeviceErrorCauses', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'OTDOA-TargetDeviceErrorCauses')))
    OTDOA_Error._cont = ASN1Dict([
        (u'locationServerErrorCauses', _OTDOA_Error_locationServerErrorCauses),
        (u'targetDeviceErrorCauses', _OTDOA_Error_targetDeviceErrorCauses),
        ])
    OTDOA_Error._ext = []
    
    #-----< OTDOA-LocationServerErrorCauses >-----#
    OTDOA_LocationServerErrorCauses = SEQ(name=u'OTDOA-LocationServerErrorCauses', mode=MODE_TYPE)
    _OTDOA_LocationServerErrorCauses_cause = ENUM(name=u'cause', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OTDOA_LocationServerErrorCauses_cause._cont = ASN1Dict([(u'undefined', 0), (u'assistanceDataNotSupportedByServer', 1), (u'assistanceDataSupportedButCurrentlyNotAvailableByServer', 2)])
    _OTDOA_LocationServerErrorCauses_cause._ext = []
    OTDOA_LocationServerErrorCauses._cont = ASN1Dict([
        (u'cause', _OTDOA_LocationServerErrorCauses_cause),
        ])
    OTDOA_LocationServerErrorCauses._ext = []
    
    #-----< OTDOA-TargetDeviceErrorCauses >-----#
    OTDOA_TargetDeviceErrorCauses = SEQ(name=u'OTDOA-TargetDeviceErrorCauses', mode=MODE_TYPE)
    _OTDOA_TargetDeviceErrorCauses_cause = ENUM(name=u'cause', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OTDOA_TargetDeviceErrorCauses_cause._cont = ASN1Dict([(u'undefined', 0), (u'assistance-data-missing', 1), (u'unableToMeasureReferenceCell', 2), (u'unableToMeasureAnyNeighbourCell', 3), (u'attemptedButUnableToMeasureSomeNeighbourCells', 4)])
    _OTDOA_TargetDeviceErrorCauses_cause._ext = []
    OTDOA_TargetDeviceErrorCauses._cont = ASN1Dict([
        (u'cause', _OTDOA_TargetDeviceErrorCauses_cause),
        ])
    OTDOA_TargetDeviceErrorCauses._ext = []
    
    #-----< A-GNSS-ProvideAssistanceData >-----#
    A_GNSS_ProvideAssistanceData = SEQ(name=u'A-GNSS-ProvideAssistanceData', mode=MODE_TYPE)
    _A_GNSS_ProvideAssistanceData_gnss_CommonAssistData = SEQ(name=u'gnss-CommonAssistData', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-CommonAssistData')), opt=True)
    _A_GNSS_ProvideAssistanceData_gnss_GenericAssistData = SEQ_OF(name=u'gnss-GenericAssistData', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-GenericAssistData')), opt=True)
    _A_GNSS_ProvideAssistanceData_gnss_Error = CHOICE(name=u'gnss-Error', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'A-GNSS-Error')), opt=True)
    A_GNSS_ProvideAssistanceData._cont = ASN1Dict([
        (u'gnss-CommonAssistData', _A_GNSS_ProvideAssistanceData_gnss_CommonAssistData),
        (u'gnss-GenericAssistData', _A_GNSS_ProvideAssistanceData_gnss_GenericAssistData),
        (u'gnss-Error', _A_GNSS_ProvideAssistanceData_gnss_Error),
        ])
    A_GNSS_ProvideAssistanceData._ext = []
    
    #-----< GNSS-CommonAssistData >-----#
    GNSS_CommonAssistData = SEQ(name=u'GNSS-CommonAssistData', mode=MODE_TYPE)
    _GNSS_CommonAssistData_gnss_ReferenceTime = SEQ(name=u'gnss-ReferenceTime', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-ReferenceTime')), opt=True)
    _GNSS_CommonAssistData_gnss_ReferenceLocation = SEQ(name=u'gnss-ReferenceLocation', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-ReferenceLocation')), opt=True)
    _GNSS_CommonAssistData_gnss_IonosphericModel = SEQ(name=u'gnss-IonosphericModel', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-IonosphericModel')), opt=True)
    _GNSS_CommonAssistData_gnss_EarthOrientationParameters = SEQ(name=u'gnss-EarthOrientationParameters', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-EarthOrientationParameters')), opt=True)
    GNSS_CommonAssistData._cont = ASN1Dict([
        (u'gnss-ReferenceTime', _GNSS_CommonAssistData_gnss_ReferenceTime),
        (u'gnss-ReferenceLocation', _GNSS_CommonAssistData_gnss_ReferenceLocation),
        (u'gnss-IonosphericModel', _GNSS_CommonAssistData_gnss_IonosphericModel),
        (u'gnss-EarthOrientationParameters', _GNSS_CommonAssistData_gnss_EarthOrientationParameters),
        ])
    GNSS_CommonAssistData._ext = []
    
    #-----< GNSS-GenericAssistData >-----#
    GNSS_GenericAssistData = SEQ_OF(name=u'GNSS-GenericAssistData', mode=MODE_TYPE)
    _GNSS_GenericAssistData__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-GenericAssistDataElement')))
    GNSS_GenericAssistData._cont = _GNSS_GenericAssistData__item_
    GNSS_GenericAssistData._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    
    #-----< GNSS-GenericAssistDataElement >-----#
    GNSS_GenericAssistDataElement = SEQ(name=u'GNSS-GenericAssistDataElement', mode=MODE_TYPE)
    _GNSS_GenericAssistDataElement_gnss_ID = SEQ(name=u'gnss-ID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-ID')))
    _GNSS_GenericAssistDataElement_sbas_ID = SEQ(name=u'sbas-ID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'SBAS-ID')), opt=True)
    _GNSS_GenericAssistDataElement_gnss_TimeModels = SEQ_OF(name=u'gnss-TimeModels', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-TimeModelList')), opt=True)
    _GNSS_GenericAssistDataElement_gnss_DifferentialCorrections = SEQ(name=u'gnss-DifferentialCorrections', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-DifferentialCorrections')), opt=True)
    _GNSS_GenericAssistDataElement_gnss_NavigationModel = SEQ(name=u'gnss-NavigationModel', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-NavigationModel')), opt=True)
    _GNSS_GenericAssistDataElement_gnss_RealTimeIntegrity = SEQ(name=u'gnss-RealTimeIntegrity', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-RealTimeIntegrity')), opt=True)
    _GNSS_GenericAssistDataElement_gnss_DataBitAssistance = SEQ(name=u'gnss-DataBitAssistance', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-DataBitAssistance')), opt=True)
    _GNSS_GenericAssistDataElement_gnss_AcquisitionAssistance = SEQ(name=u'gnss-AcquisitionAssistance', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-AcquisitionAssistance')), opt=True)
    _GNSS_GenericAssistDataElement_gnss_Almanac = SEQ(name=u'gnss-Almanac', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-Almanac')), opt=True)
    _GNSS_GenericAssistDataElement_gnss_UTC_Model = CHOICE(name=u'gnss-UTC-Model', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-UTC-Model')), opt=True)
    _GNSS_GenericAssistDataElement_gnss_AuxiliaryInformation = CHOICE(name=u'gnss-AuxiliaryInformation', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-AuxiliaryInformation')), opt=True)
    _GNSS_GenericAssistDataElement_bds_DifferentialCorrections_r12 = SEQ(name=u'bds-DifferentialCorrections-r12', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'BDS-DifferentialCorrections-r12')), opt=True, group=0)
    _GNSS_GenericAssistDataElement_bds_GridModel_r12 = SEQ(name=u'bds-GridModel-r12', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'BDS-GridModelParameter-r12')), opt=True, group=0)
    GNSS_GenericAssistDataElement._cont = ASN1Dict([
        (u'gnss-ID', _GNSS_GenericAssistDataElement_gnss_ID),
        (u'sbas-ID', _GNSS_GenericAssistDataElement_sbas_ID),
        (u'gnss-TimeModels', _GNSS_GenericAssistDataElement_gnss_TimeModels),
        (u'gnss-DifferentialCorrections', _GNSS_GenericAssistDataElement_gnss_DifferentialCorrections),
        (u'gnss-NavigationModel', _GNSS_GenericAssistDataElement_gnss_NavigationModel),
        (u'gnss-RealTimeIntegrity', _GNSS_GenericAssistDataElement_gnss_RealTimeIntegrity),
        (u'gnss-DataBitAssistance', _GNSS_GenericAssistDataElement_gnss_DataBitAssistance),
        (u'gnss-AcquisitionAssistance', _GNSS_GenericAssistDataElement_gnss_AcquisitionAssistance),
        (u'gnss-Almanac', _GNSS_GenericAssistDataElement_gnss_Almanac),
        (u'gnss-UTC-Model', _GNSS_GenericAssistDataElement_gnss_UTC_Model),
        (u'gnss-AuxiliaryInformation', _GNSS_GenericAssistDataElement_gnss_AuxiliaryInformation),
        (u'bds-DifferentialCorrections-r12', _GNSS_GenericAssistDataElement_bds_DifferentialCorrections_r12),
        (u'bds-GridModel-r12', _GNSS_GenericAssistDataElement_bds_GridModel_r12),
        ])
    GNSS_GenericAssistDataElement._ext = [u'bds-DifferentialCorrections-r12', u'bds-GridModel-r12']
    
    #-----< GNSS-ReferenceTime >-----#
    GNSS_ReferenceTime = SEQ(name=u'GNSS-ReferenceTime', mode=MODE_TYPE)
    _GNSS_ReferenceTime_gnss_SystemTime = SEQ(name=u'gnss-SystemTime', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-SystemTime')))
    _GNSS_ReferenceTime_referenceTimeUnc = INT(name=u'referenceTimeUnc', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GNSS_ReferenceTime_referenceTimeUnc._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    _GNSS_ReferenceTime_gnss_ReferenceTimeForCells = SEQ_OF(name=u'gnss-ReferenceTimeForCells', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __GNSS_ReferenceTime_gnss_ReferenceTimeForCells__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-ReferenceTimeForOneCell')))
    _GNSS_ReferenceTime_gnss_ReferenceTimeForCells._cont = __GNSS_ReferenceTime_gnss_ReferenceTimeForCells__item_
    _GNSS_ReferenceTime_gnss_ReferenceTimeForCells._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    GNSS_ReferenceTime._cont = ASN1Dict([
        (u'gnss-SystemTime', _GNSS_ReferenceTime_gnss_SystemTime),
        (u'referenceTimeUnc', _GNSS_ReferenceTime_referenceTimeUnc),
        (u'gnss-ReferenceTimeForCells', _GNSS_ReferenceTime_gnss_ReferenceTimeForCells),
        ])
    GNSS_ReferenceTime._ext = []
    
    #-----< GNSS-ReferenceTimeForOneCell >-----#
    GNSS_ReferenceTimeForOneCell = SEQ(name=u'GNSS-ReferenceTimeForOneCell', mode=MODE_TYPE)
    _GNSS_ReferenceTimeForOneCell_networkTime = SEQ(name=u'networkTime', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'NetworkTime')))
    _GNSS_ReferenceTimeForOneCell_referenceTimeUnc = INT(name=u'referenceTimeUnc', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GNSS_ReferenceTimeForOneCell_referenceTimeUnc._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    _GNSS_ReferenceTimeForOneCell_bsAlign = ENUM(name=u'bsAlign', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GNSS_ReferenceTimeForOneCell_bsAlign._cont = ASN1Dict([(u'true', 0)])
    _GNSS_ReferenceTimeForOneCell_bsAlign._ext = None
    GNSS_ReferenceTimeForOneCell._cont = ASN1Dict([
        (u'networkTime', _GNSS_ReferenceTimeForOneCell_networkTime),
        (u'referenceTimeUnc', _GNSS_ReferenceTimeForOneCell_referenceTimeUnc),
        (u'bsAlign', _GNSS_ReferenceTimeForOneCell_bsAlign),
        ])
    GNSS_ReferenceTimeForOneCell._ext = []
    
    #-----< GNSS-SystemTime >-----#
    GNSS_SystemTime = SEQ(name=u'GNSS-SystemTime', mode=MODE_TYPE)
    _GNSS_SystemTime_gnss_TimeID = SEQ(name=u'gnss-TimeID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-ID')))
    _GNSS_SystemTime_gnss_DayNumber = INT(name=u'gnss-DayNumber', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GNSS_SystemTime_gnss_DayNumber._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=32767)], ev=None, er=[])
    _GNSS_SystemTime_gnss_TimeOfDay = INT(name=u'gnss-TimeOfDay', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GNSS_SystemTime_gnss_TimeOfDay._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=86399)], ev=None, er=[])
    _GNSS_SystemTime_gnss_TimeOfDayFrac_msec = INT(name=u'gnss-TimeOfDayFrac-msec', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GNSS_SystemTime_gnss_TimeOfDayFrac_msec._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=999)], ev=None, er=[])
    _GNSS_SystemTime_notificationOfLeapSecond = BIT_STR(name=u'notificationOfLeapSecond', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GNSS_SystemTime_notificationOfLeapSecond._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    _GNSS_SystemTime_gps_TOW_Assist = SEQ_OF(name=u'gps-TOW-Assist', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GPS-TOW-Assist')), opt=True)
    GNSS_SystemTime._cont = ASN1Dict([
        (u'gnss-TimeID', _GNSS_SystemTime_gnss_TimeID),
        (u'gnss-DayNumber', _GNSS_SystemTime_gnss_DayNumber),
        (u'gnss-TimeOfDay', _GNSS_SystemTime_gnss_TimeOfDay),
        (u'gnss-TimeOfDayFrac-msec', _GNSS_SystemTime_gnss_TimeOfDayFrac_msec),
        (u'notificationOfLeapSecond', _GNSS_SystemTime_notificationOfLeapSecond),
        (u'gps-TOW-Assist', _GNSS_SystemTime_gps_TOW_Assist),
        ])
    GNSS_SystemTime._ext = []
    
    #-----< GPS-TOW-Assist >-----#
    GPS_TOW_Assist = SEQ_OF(name=u'GPS-TOW-Assist', mode=MODE_TYPE)
    _GPS_TOW_Assist__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('LPP-PDU-Definitions', 'GPS-TOW-AssistElement')))
    GPS_TOW_Assist._cont = _GPS_TOW_Assist__item_
    GPS_TOW_Assist._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    
    #-----< GPS-TOW-AssistElement >-----#
    GPS_TOW_AssistElement = SEQ(name=u'GPS-TOW-AssistElement', mode=MODE_TYPE)
    _GPS_TOW_AssistElement_satelliteID = INT(name=u'satelliteID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_TOW_AssistElement_satelliteID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _GPS_TOW_AssistElement_tlmWord = INT(name=u'tlmWord', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_TOW_AssistElement_tlmWord._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=16383)], ev=None, er=[])
    _GPS_TOW_AssistElement_antiSpoof = INT(name=u'antiSpoof', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_TOW_AssistElement_antiSpoof._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=1)], ev=None, er=[])
    _GPS_TOW_AssistElement_alert = INT(name=u'alert', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_TOW_AssistElement_alert._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=1)], ev=None, er=[])
    _GPS_TOW_AssistElement_tlmRsvdBits = INT(name=u'tlmRsvdBits', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_TOW_AssistElement_tlmRsvdBits._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=3)], ev=None, er=[])
    GPS_TOW_AssistElement._cont = ASN1Dict([
        (u'satelliteID', _GPS_TOW_AssistElement_satelliteID),
        (u'tlmWord', _GPS_TOW_AssistElement_tlmWord),
        (u'antiSpoof', _GPS_TOW_AssistElement_antiSpoof),
        (u'alert', _GPS_TOW_AssistElement_alert),
        (u'tlmRsvdBits', _GPS_TOW_AssistElement_tlmRsvdBits),
        ])
    GPS_TOW_AssistElement._ext = []
    
    #-----< NetworkTime >-----#
    NetworkTime = SEQ(name=u'NetworkTime', mode=MODE_TYPE)
    _NetworkTime_secondsFromFrameStructureStart = INT(name=u'secondsFromFrameStructureStart', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NetworkTime_secondsFromFrameStructureStart._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=12533)], ev=None, er=[])
    _NetworkTime_fractionalSecondsFromFrameStructureStart = INT(name=u'fractionalSecondsFromFrameStructureStart', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NetworkTime_fractionalSecondsFromFrameStructureStart._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=3999999)], ev=None, er=[])
    _NetworkTime_frameDrift = INT(name=u'frameDrift', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _NetworkTime_frameDrift._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-64, ub=63)], ev=None, er=[])
    _NetworkTime_cellID = CHOICE(name=u'cellID', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __NetworkTime_cellID_eUTRA = SEQ(name=u'eUTRA', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___NetworkTime_cellID_eUTRA_physCellId = INT(name=u'physCellId', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___NetworkTime_cellID_eUTRA_physCellId._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=503)], ev=None, er=[])
    ___NetworkTime_cellID_eUTRA_cellGlobalIdEUTRA = SEQ(name=u'cellGlobalIdEUTRA', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'CellGlobalIdEUTRA-AndUTRA')), opt=True)
    ___NetworkTime_cellID_eUTRA_earfcn = INT(name=u'earfcn', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'ARFCN-ValueEUTRA')))
    ___NetworkTime_cellID_eUTRA_earfcn_v9a0 = INT(name=u'earfcn-v9a0', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'ARFCN-ValueEUTRA-v9a0')), opt=True, group=0)
    __NetworkTime_cellID_eUTRA._cont = ASN1Dict([
        (u'physCellId', ___NetworkTime_cellID_eUTRA_physCellId),
        (u'cellGlobalIdEUTRA', ___NetworkTime_cellID_eUTRA_cellGlobalIdEUTRA),
        (u'earfcn', ___NetworkTime_cellID_eUTRA_earfcn),
        (u'earfcn-v9a0', ___NetworkTime_cellID_eUTRA_earfcn_v9a0),
        ])
    __NetworkTime_cellID_eUTRA._ext = [u'earfcn-v9a0']
    __NetworkTime_cellID_uTRA = SEQ(name=u'uTRA', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___NetworkTime_cellID_uTRA_mode = CHOICE(name=u'mode', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ____NetworkTime_cellID_uTRA_mode_fdd = SEQ(name=u'fdd', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _____NetworkTime_cellID_uTRA_mode_fdd_primary_CPICH_Info = INT(name=u'primary-CPICH-Info', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _____NetworkTime_cellID_uTRA_mode_fdd_primary_CPICH_Info._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=511)], ev=None, er=[])
    ____NetworkTime_cellID_uTRA_mode_fdd._cont = ASN1Dict([
        (u'primary-CPICH-Info', _____NetworkTime_cellID_uTRA_mode_fdd_primary_CPICH_Info),
        ])
    ____NetworkTime_cellID_uTRA_mode_fdd._ext = []
    ____NetworkTime_cellID_uTRA_mode_tdd = SEQ(name=u'tdd', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _____NetworkTime_cellID_uTRA_mode_tdd_cellParameters = INT(name=u'cellParameters', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _____NetworkTime_cellID_uTRA_mode_tdd_cellParameters._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    ____NetworkTime_cellID_uTRA_mode_tdd._cont = ASN1Dict([
        (u'cellParameters', _____NetworkTime_cellID_uTRA_mode_tdd_cellParameters),
        ])
    ____NetworkTime_cellID_uTRA_mode_tdd._ext = []
    ___NetworkTime_cellID_uTRA_mode._cont = ASN1Dict([
        (u'fdd', ____NetworkTime_cellID_uTRA_mode_fdd),
        (u'tdd', ____NetworkTime_cellID_uTRA_mode_tdd),
        ])
    ___NetworkTime_cellID_uTRA_mode._ext = None
    ___NetworkTime_cellID_uTRA_cellGlobalIdUTRA = SEQ(name=u'cellGlobalIdUTRA', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'CellGlobalIdEUTRA-AndUTRA')), opt=True)
    ___NetworkTime_cellID_uTRA_uarfcn = INT(name=u'uarfcn', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'ARFCN-ValueUTRA')))
    __NetworkTime_cellID_uTRA._cont = ASN1Dict([
        (u'mode', ___NetworkTime_cellID_uTRA_mode),
        (u'cellGlobalIdUTRA', ___NetworkTime_cellID_uTRA_cellGlobalIdUTRA),
        (u'uarfcn', ___NetworkTime_cellID_uTRA_uarfcn),
        ])
    __NetworkTime_cellID_uTRA._ext = []
    __NetworkTime_cellID_gSM = SEQ(name=u'gSM', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___NetworkTime_cellID_gSM_bcchCarrier = INT(name=u'bcchCarrier', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___NetworkTime_cellID_gSM_bcchCarrier._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=1023)], ev=None, er=[])
    ___NetworkTime_cellID_gSM_bsic = INT(name=u'bsic', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___NetworkTime_cellID_gSM_bsic._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    ___NetworkTime_cellID_gSM_cellGlobalIdGERAN = SEQ(name=u'cellGlobalIdGERAN', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'CellGlobalIdGERAN')), opt=True)
    __NetworkTime_cellID_gSM._cont = ASN1Dict([
        (u'bcchCarrier', ___NetworkTime_cellID_gSM_bcchCarrier),
        (u'bsic', ___NetworkTime_cellID_gSM_bsic),
        (u'cellGlobalIdGERAN', ___NetworkTime_cellID_gSM_cellGlobalIdGERAN),
        ])
    __NetworkTime_cellID_gSM._ext = []
    _NetworkTime_cellID._cont = ASN1Dict([
        (u'eUTRA', __NetworkTime_cellID_eUTRA),
        (u'uTRA', __NetworkTime_cellID_uTRA),
        (u'gSM', __NetworkTime_cellID_gSM),
        ])
    _NetworkTime_cellID._ext = []
    NetworkTime._cont = ASN1Dict([
        (u'secondsFromFrameStructureStart', _NetworkTime_secondsFromFrameStructureStart),
        (u'fractionalSecondsFromFrameStructureStart', _NetworkTime_fractionalSecondsFromFrameStructureStart),
        (u'frameDrift', _NetworkTime_frameDrift),
        (u'cellID', _NetworkTime_cellID),
        ])
    NetworkTime._ext = []
    
    #-----< GNSS-ReferenceLocation >-----#
    GNSS_ReferenceLocation = SEQ(name=u'GNSS-ReferenceLocation', mode=MODE_TYPE)
    _GNSS_ReferenceLocation_threeDlocation = SEQ(name=u'threeDlocation', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'EllipsoidPointWithAltitudeAndUncertaintyEllipsoid')))
    GNSS_ReferenceLocation._cont = ASN1Dict([
        (u'threeDlocation', _GNSS_ReferenceLocation_threeDlocation),
        ])
    GNSS_ReferenceLocation._ext = []
    
    #-----< GNSS-IonosphericModel >-----#
    GNSS_IonosphericModel = SEQ(name=u'GNSS-IonosphericModel', mode=MODE_TYPE)
    _GNSS_IonosphericModel_klobucharModel = SEQ(name=u'klobucharModel', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'KlobucharModelParameter')), opt=True)
    _GNSS_IonosphericModel_neQuickModel = SEQ(name=u'neQuickModel', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'NeQuickModelParameter')), opt=True)
    GNSS_IonosphericModel._cont = ASN1Dict([
        (u'klobucharModel', _GNSS_IonosphericModel_klobucharModel),
        (u'neQuickModel', _GNSS_IonosphericModel_neQuickModel),
        ])
    GNSS_IonosphericModel._ext = []
    
    #-----< KlobucharModelParameter >-----#
    KlobucharModelParameter = SEQ(name=u'KlobucharModelParameter', mode=MODE_TYPE)
    _KlobucharModelParameter_dataID = BIT_STR(name=u'dataID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _KlobucharModelParameter_dataID._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    _KlobucharModelParameter_alfa0 = INT(name=u'alfa0', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _KlobucharModelParameter_alfa0._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-128, ub=127)], ev=None, er=[])
    _KlobucharModelParameter_alfa1 = INT(name=u'alfa1', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _KlobucharModelParameter_alfa1._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-128, ub=127)], ev=None, er=[])
    _KlobucharModelParameter_alfa2 = INT(name=u'alfa2', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _KlobucharModelParameter_alfa2._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-128, ub=127)], ev=None, er=[])
    _KlobucharModelParameter_alfa3 = INT(name=u'alfa3', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _KlobucharModelParameter_alfa3._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-128, ub=127)], ev=None, er=[])
    _KlobucharModelParameter_beta0 = INT(name=u'beta0', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _KlobucharModelParameter_beta0._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-128, ub=127)], ev=None, er=[])
    _KlobucharModelParameter_beta1 = INT(name=u'beta1', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _KlobucharModelParameter_beta1._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-128, ub=127)], ev=None, er=[])
    _KlobucharModelParameter_beta2 = INT(name=u'beta2', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _KlobucharModelParameter_beta2._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-128, ub=127)], ev=None, er=[])
    _KlobucharModelParameter_beta3 = INT(name=u'beta3', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _KlobucharModelParameter_beta3._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-128, ub=127)], ev=None, er=[])
    KlobucharModelParameter._cont = ASN1Dict([
        (u'dataID', _KlobucharModelParameter_dataID),
        (u'alfa0', _KlobucharModelParameter_alfa0),
        (u'alfa1', _KlobucharModelParameter_alfa1),
        (u'alfa2', _KlobucharModelParameter_alfa2),
        (u'alfa3', _KlobucharModelParameter_alfa3),
        (u'beta0', _KlobucharModelParameter_beta0),
        (u'beta1', _KlobucharModelParameter_beta1),
        (u'beta2', _KlobucharModelParameter_beta2),
        (u'beta3', _KlobucharModelParameter_beta3),
        ])
    KlobucharModelParameter._ext = []
    
    #-----< NeQuickModelParameter >-----#
    NeQuickModelParameter = SEQ(name=u'NeQuickModelParameter', mode=MODE_TYPE)
    _NeQuickModelParameter_ai0 = INT(name=u'ai0', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NeQuickModelParameter_ai0._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=2047)], ev=None, er=[])
    _NeQuickModelParameter_ai1 = INT(name=u'ai1', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NeQuickModelParameter_ai1._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-1024, ub=1023)], ev=None, er=[])
    _NeQuickModelParameter_ai2 = INT(name=u'ai2', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NeQuickModelParameter_ai2._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-8192, ub=8191)], ev=None, er=[])
    _NeQuickModelParameter_ionoStormFlag1 = INT(name=u'ionoStormFlag1', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _NeQuickModelParameter_ionoStormFlag1._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=1)], ev=None, er=[])
    _NeQuickModelParameter_ionoStormFlag2 = INT(name=u'ionoStormFlag2', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _NeQuickModelParameter_ionoStormFlag2._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=1)], ev=None, er=[])
    _NeQuickModelParameter_ionoStormFlag3 = INT(name=u'ionoStormFlag3', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _NeQuickModelParameter_ionoStormFlag3._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=1)], ev=None, er=[])
    _NeQuickModelParameter_ionoStormFlag4 = INT(name=u'ionoStormFlag4', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _NeQuickModelParameter_ionoStormFlag4._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=1)], ev=None, er=[])
    _NeQuickModelParameter_ionoStormFlag5 = INT(name=u'ionoStormFlag5', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _NeQuickModelParameter_ionoStormFlag5._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=1)], ev=None, er=[])
    NeQuickModelParameter._cont = ASN1Dict([
        (u'ai0', _NeQuickModelParameter_ai0),
        (u'ai1', _NeQuickModelParameter_ai1),
        (u'ai2', _NeQuickModelParameter_ai2),
        (u'ionoStormFlag1', _NeQuickModelParameter_ionoStormFlag1),
        (u'ionoStormFlag2', _NeQuickModelParameter_ionoStormFlag2),
        (u'ionoStormFlag3', _NeQuickModelParameter_ionoStormFlag3),
        (u'ionoStormFlag4', _NeQuickModelParameter_ionoStormFlag4),
        (u'ionoStormFlag5', _NeQuickModelParameter_ionoStormFlag5),
        ])
    NeQuickModelParameter._ext = []
    
    #-----< GNSS-EarthOrientationParameters >-----#
    GNSS_EarthOrientationParameters = SEQ(name=u'GNSS-EarthOrientationParameters', mode=MODE_TYPE)
    _GNSS_EarthOrientationParameters_teop = INT(name=u'teop', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GNSS_EarthOrientationParameters_teop._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    _GNSS_EarthOrientationParameters_pmX = INT(name=u'pmX', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GNSS_EarthOrientationParameters_pmX._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-1048576, ub=1048575)], ev=None, er=[])
    _GNSS_EarthOrientationParameters_pmXdot = INT(name=u'pmXdot', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GNSS_EarthOrientationParameters_pmXdot._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-16384, ub=16383)], ev=None, er=[])
    _GNSS_EarthOrientationParameters_pmY = INT(name=u'pmY', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GNSS_EarthOrientationParameters_pmY._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-1048576, ub=1048575)], ev=None, er=[])
    _GNSS_EarthOrientationParameters_pmYdot = INT(name=u'pmYdot', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GNSS_EarthOrientationParameters_pmYdot._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-16384, ub=16383)], ev=None, er=[])
    _GNSS_EarthOrientationParameters_deltaUT1 = INT(name=u'deltaUT1', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GNSS_EarthOrientationParameters_deltaUT1._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-1073741824, ub=1073741823)], ev=None, er=[])
    _GNSS_EarthOrientationParameters_deltaUT1dot = INT(name=u'deltaUT1dot', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GNSS_EarthOrientationParameters_deltaUT1dot._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-262144, ub=262143)], ev=None, er=[])
    GNSS_EarthOrientationParameters._cont = ASN1Dict([
        (u'teop', _GNSS_EarthOrientationParameters_teop),
        (u'pmX', _GNSS_EarthOrientationParameters_pmX),
        (u'pmXdot', _GNSS_EarthOrientationParameters_pmXdot),
        (u'pmY', _GNSS_EarthOrientationParameters_pmY),
        (u'pmYdot', _GNSS_EarthOrientationParameters_pmYdot),
        (u'deltaUT1', _GNSS_EarthOrientationParameters_deltaUT1),
        (u'deltaUT1dot', _GNSS_EarthOrientationParameters_deltaUT1dot),
        ])
    GNSS_EarthOrientationParameters._ext = []
    
    #-----< GNSS-TimeModelList >-----#
    GNSS_TimeModelList = SEQ_OF(name=u'GNSS-TimeModelList', mode=MODE_TYPE)
    _GNSS_TimeModelList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-TimeModelElement')))
    GNSS_TimeModelList._cont = _GNSS_TimeModelList__item_
    GNSS_TimeModelList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=15)], ev=None, er=[])
    
    #-----< GNSS-TimeModelElement >-----#
    GNSS_TimeModelElement = SEQ(name=u'GNSS-TimeModelElement', mode=MODE_TYPE)
    _GNSS_TimeModelElement_gnss_TimeModelRefTime = INT(name=u'gnss-TimeModelRefTime', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GNSS_TimeModelElement_gnss_TimeModelRefTime._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    _GNSS_TimeModelElement_tA0 = INT(name=u'tA0', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GNSS_TimeModelElement_tA0._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-67108864, ub=67108863)], ev=None, er=[])
    _GNSS_TimeModelElement_tA1 = INT(name=u'tA1', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GNSS_TimeModelElement_tA1._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-4096, ub=4095)], ev=None, er=[])
    _GNSS_TimeModelElement_tA2 = INT(name=u'tA2', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GNSS_TimeModelElement_tA2._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-64, ub=63)], ev=None, er=[])
    _GNSS_TimeModelElement_gnss_TO_ID = INT(name=u'gnss-TO-ID', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GNSS_TimeModelElement_gnss_TO_ID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=15)], ev=None, er=[])
    _GNSS_TimeModelElement_weekNumber = INT(name=u'weekNumber', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GNSS_TimeModelElement_weekNumber._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=8191)], ev=None, er=[])
    _GNSS_TimeModelElement_deltaT = INT(name=u'deltaT', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GNSS_TimeModelElement_deltaT._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-128, ub=127)], ev=None, er=[])
    GNSS_TimeModelElement._cont = ASN1Dict([
        (u'gnss-TimeModelRefTime', _GNSS_TimeModelElement_gnss_TimeModelRefTime),
        (u'tA0', _GNSS_TimeModelElement_tA0),
        (u'tA1', _GNSS_TimeModelElement_tA1),
        (u'tA2', _GNSS_TimeModelElement_tA2),
        (u'gnss-TO-ID', _GNSS_TimeModelElement_gnss_TO_ID),
        (u'weekNumber', _GNSS_TimeModelElement_weekNumber),
        (u'deltaT', _GNSS_TimeModelElement_deltaT),
        ])
    GNSS_TimeModelElement._ext = []
    
    #-----< GNSS-DifferentialCorrections >-----#
    GNSS_DifferentialCorrections = SEQ(name=u'GNSS-DifferentialCorrections', mode=MODE_TYPE)
    _GNSS_DifferentialCorrections_dgnss_RefTime = INT(name=u'dgnss-RefTime', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GNSS_DifferentialCorrections_dgnss_RefTime._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=3599)], ev=None, er=[])
    _GNSS_DifferentialCorrections_dgnss_SgnTypeList = SEQ_OF(name=u'dgnss-SgnTypeList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'DGNSS-SgnTypeList')))
    GNSS_DifferentialCorrections._cont = ASN1Dict([
        (u'dgnss-RefTime', _GNSS_DifferentialCorrections_dgnss_RefTime),
        (u'dgnss-SgnTypeList', _GNSS_DifferentialCorrections_dgnss_SgnTypeList),
        ])
    GNSS_DifferentialCorrections._ext = []
    
    #-----< DGNSS-SgnTypeList >-----#
    DGNSS_SgnTypeList = SEQ_OF(name=u'DGNSS-SgnTypeList', mode=MODE_TYPE)
    _DGNSS_SgnTypeList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('LPP-PDU-Definitions', 'DGNSS-SgnTypeElement')))
    DGNSS_SgnTypeList._cont = _DGNSS_SgnTypeList__item_
    DGNSS_SgnTypeList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=3)], ev=None, er=[])
    
    #-----< DGNSS-SgnTypeElement >-----#
    DGNSS_SgnTypeElement = SEQ(name=u'DGNSS-SgnTypeElement', mode=MODE_TYPE)
    _DGNSS_SgnTypeElement_gnss_SignalID = SEQ(name=u'gnss-SignalID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-SignalID')))
    _DGNSS_SgnTypeElement_gnss_StatusHealth = INT(name=u'gnss-StatusHealth', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _DGNSS_SgnTypeElement_gnss_StatusHealth._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=7)], ev=None, er=[])
    _DGNSS_SgnTypeElement_dgnss_SatList = SEQ_OF(name=u'dgnss-SatList', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'DGNSS-SatList')))
    DGNSS_SgnTypeElement._cont = ASN1Dict([
        (u'gnss-SignalID', _DGNSS_SgnTypeElement_gnss_SignalID),
        (u'gnss-StatusHealth', _DGNSS_SgnTypeElement_gnss_StatusHealth),
        (u'dgnss-SatList', _DGNSS_SgnTypeElement_dgnss_SatList),
        ])
    DGNSS_SgnTypeElement._ext = []
    
    #-----< DGNSS-SatList >-----#
    DGNSS_SatList = SEQ_OF(name=u'DGNSS-SatList', mode=MODE_TYPE)
    _DGNSS_SatList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('LPP-PDU-Definitions', 'DGNSS-CorrectionsElement')))
    DGNSS_SatList._cont = _DGNSS_SatList__item_
    DGNSS_SatList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    
    #-----< DGNSS-CorrectionsElement >-----#
    DGNSS_CorrectionsElement = SEQ(name=u'DGNSS-CorrectionsElement', mode=MODE_TYPE)
    _DGNSS_CorrectionsElement_svID = SEQ(name=u'svID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'SV-ID')))
    _DGNSS_CorrectionsElement_iod = BIT_STR(name=u'iod', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _DGNSS_CorrectionsElement_iod._const_sz = ASN1Set(rv=[11], rr=[], ev=None, er=[])
    _DGNSS_CorrectionsElement_udre = INT(name=u'udre', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _DGNSS_CorrectionsElement_udre._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=3)], ev=None, er=[])
    _DGNSS_CorrectionsElement_pseudoRangeCor = INT(name=u'pseudoRangeCor', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _DGNSS_CorrectionsElement_pseudoRangeCor._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-2047, ub=2047)], ev=None, er=[])
    _DGNSS_CorrectionsElement_rangeRateCor = INT(name=u'rangeRateCor', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _DGNSS_CorrectionsElement_rangeRateCor._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-127, ub=127)], ev=None, er=[])
    _DGNSS_CorrectionsElement_udreGrowthRate = INT(name=u'udreGrowthRate', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _DGNSS_CorrectionsElement_udreGrowthRate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=7)], ev=None, er=[])
    _DGNSS_CorrectionsElement_udreValidityTime = INT(name=u'udreValidityTime', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _DGNSS_CorrectionsElement_udreValidityTime._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=7)], ev=None, er=[])
    DGNSS_CorrectionsElement._cont = ASN1Dict([
        (u'svID', _DGNSS_CorrectionsElement_svID),
        (u'iod', _DGNSS_CorrectionsElement_iod),
        (u'udre', _DGNSS_CorrectionsElement_udre),
        (u'pseudoRangeCor', _DGNSS_CorrectionsElement_pseudoRangeCor),
        (u'rangeRateCor', _DGNSS_CorrectionsElement_rangeRateCor),
        (u'udreGrowthRate', _DGNSS_CorrectionsElement_udreGrowthRate),
        (u'udreValidityTime', _DGNSS_CorrectionsElement_udreValidityTime),
        ])
    DGNSS_CorrectionsElement._ext = []
    
    #-----< GNSS-NavigationModel >-----#
    GNSS_NavigationModel = SEQ(name=u'GNSS-NavigationModel', mode=MODE_TYPE)
    _GNSS_NavigationModel_nonBroadcastIndFlag = INT(name=u'nonBroadcastIndFlag', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GNSS_NavigationModel_nonBroadcastIndFlag._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=1)], ev=None, er=[])
    _GNSS_NavigationModel_gnss_SatelliteList = SEQ_OF(name=u'gnss-SatelliteList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-NavModelSatelliteList')))
    GNSS_NavigationModel._cont = ASN1Dict([
        (u'nonBroadcastIndFlag', _GNSS_NavigationModel_nonBroadcastIndFlag),
        (u'gnss-SatelliteList', _GNSS_NavigationModel_gnss_SatelliteList),
        ])
    GNSS_NavigationModel._ext = []
    
    #-----< GNSS-NavModelSatelliteList >-----#
    GNSS_NavModelSatelliteList = SEQ_OF(name=u'GNSS-NavModelSatelliteList', mode=MODE_TYPE)
    _GNSS_NavModelSatelliteList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-NavModelSatelliteElement')))
    GNSS_NavModelSatelliteList._cont = _GNSS_NavModelSatelliteList__item_
    GNSS_NavModelSatelliteList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    
    #-----< GNSS-NavModelSatelliteElement >-----#
    GNSS_NavModelSatelliteElement = SEQ(name=u'GNSS-NavModelSatelliteElement', mode=MODE_TYPE)
    _GNSS_NavModelSatelliteElement_svID = SEQ(name=u'svID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'SV-ID')))
    _GNSS_NavModelSatelliteElement_svHealth = BIT_STR(name=u'svHealth', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GNSS_NavModelSatelliteElement_svHealth._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _GNSS_NavModelSatelliteElement_iod = BIT_STR(name=u'iod', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GNSS_NavModelSatelliteElement_iod._const_sz = ASN1Set(rv=[11], rr=[], ev=None, er=[])
    _GNSS_NavModelSatelliteElement_gnss_ClockModel = CHOICE(name=u'gnss-ClockModel', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-ClockModel')))
    _GNSS_NavModelSatelliteElement_gnss_OrbitModel = CHOICE(name=u'gnss-OrbitModel', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-OrbitModel')))
    _GNSS_NavModelSatelliteElement_svHealthExt_v1240 = BIT_STR(name=u'svHealthExt-v1240', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True, group=0)
    _GNSS_NavModelSatelliteElement_svHealthExt_v1240._const_sz = ASN1Set(rv=[4], rr=[], ev=None, er=[])
    GNSS_NavModelSatelliteElement._cont = ASN1Dict([
        (u'svID', _GNSS_NavModelSatelliteElement_svID),
        (u'svHealth', _GNSS_NavModelSatelliteElement_svHealth),
        (u'iod', _GNSS_NavModelSatelliteElement_iod),
        (u'gnss-ClockModel', _GNSS_NavModelSatelliteElement_gnss_ClockModel),
        (u'gnss-OrbitModel', _GNSS_NavModelSatelliteElement_gnss_OrbitModel),
        (u'svHealthExt-v1240', _GNSS_NavModelSatelliteElement_svHealthExt_v1240),
        ])
    GNSS_NavModelSatelliteElement._ext = [u'svHealthExt-v1240']
    
    #-----< GNSS-ClockModel >-----#
    GNSS_ClockModel = CHOICE(name=u'GNSS-ClockModel', mode=MODE_TYPE)
    _GNSS_ClockModel_standardClockModelList = SEQ_OF(name=u'standardClockModelList', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'StandardClockModelList')))
    _GNSS_ClockModel_nav_ClockModel = SEQ(name=u'nav-ClockModel', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'NAV-ClockModel')))
    _GNSS_ClockModel_cnav_ClockModel = SEQ(name=u'cnav-ClockModel', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'CNAV-ClockModel')))
    _GNSS_ClockModel_glonass_ClockModel = SEQ(name=u'glonass-ClockModel', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GLONASS-ClockModel')))
    _GNSS_ClockModel_sbas_ClockModel = SEQ(name=u'sbas-ClockModel', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'SBAS-ClockModel')))
    _GNSS_ClockModel_bds_ClockModel_r12 = SEQ(name=u'bds-ClockModel-r12', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'BDS-ClockModel-r12')))
    GNSS_ClockModel._cont = ASN1Dict([
        (u'standardClockModelList', _GNSS_ClockModel_standardClockModelList),
        (u'nav-ClockModel', _GNSS_ClockModel_nav_ClockModel),
        (u'cnav-ClockModel', _GNSS_ClockModel_cnav_ClockModel),
        (u'glonass-ClockModel', _GNSS_ClockModel_glonass_ClockModel),
        (u'sbas-ClockModel', _GNSS_ClockModel_sbas_ClockModel),
        (u'bds-ClockModel-r12', _GNSS_ClockModel_bds_ClockModel_r12),
        ])
    GNSS_ClockModel._ext = [u'bds-ClockModel-r12']
    
    #-----< GNSS-OrbitModel >-----#
    GNSS_OrbitModel = CHOICE(name=u'GNSS-OrbitModel', mode=MODE_TYPE)
    _GNSS_OrbitModel_keplerianSet = SEQ(name=u'keplerianSet', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'NavModelKeplerianSet')))
    _GNSS_OrbitModel_nav_KeplerianSet = SEQ(name=u'nav-KeplerianSet', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'NavModelNAV-KeplerianSet')))
    _GNSS_OrbitModel_cnav_KeplerianSet = SEQ(name=u'cnav-KeplerianSet', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'NavModelCNAV-KeplerianSet')))
    _GNSS_OrbitModel_glonass_ECEF = SEQ(name=u'glonass-ECEF', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'NavModel-GLONASS-ECEF')))
    _GNSS_OrbitModel_sbas_ECEF = SEQ(name=u'sbas-ECEF', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'NavModel-SBAS-ECEF')))
    _GNSS_OrbitModel_bds_KeplerianSet_r12 = SEQ(name=u'bds-KeplerianSet-r12', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'NavModel-BDS-KeplerianSet-r12')))
    GNSS_OrbitModel._cont = ASN1Dict([
        (u'keplerianSet', _GNSS_OrbitModel_keplerianSet),
        (u'nav-KeplerianSet', _GNSS_OrbitModel_nav_KeplerianSet),
        (u'cnav-KeplerianSet', _GNSS_OrbitModel_cnav_KeplerianSet),
        (u'glonass-ECEF', _GNSS_OrbitModel_glonass_ECEF),
        (u'sbas-ECEF', _GNSS_OrbitModel_sbas_ECEF),
        (u'bds-KeplerianSet-r12', _GNSS_OrbitModel_bds_KeplerianSet_r12),
        ])
    GNSS_OrbitModel._ext = [u'bds-KeplerianSet-r12']
    
    #-----< StandardClockModelList >-----#
    StandardClockModelList = SEQ_OF(name=u'StandardClockModelList', mode=MODE_TYPE)
    _StandardClockModelList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('LPP-PDU-Definitions', 'StandardClockModelElement')))
    StandardClockModelList._cont = _StandardClockModelList__item_
    StandardClockModelList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=2)], ev=None, er=[])
    
    #-----< StandardClockModelElement >-----#
    StandardClockModelElement = SEQ(name=u'StandardClockModelElement', mode=MODE_TYPE)
    _StandardClockModelElement_stanClockToc = INT(name=u'stanClockToc', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _StandardClockModelElement_stanClockToc._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=16383)], ev=None, er=[])
    _StandardClockModelElement_stanClockAF2 = INT(name=u'stanClockAF2', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _StandardClockModelElement_stanClockAF2._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-32, ub=31)], ev=None, er=[])
    _StandardClockModelElement_stanClockAF1 = INT(name=u'stanClockAF1', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _StandardClockModelElement_stanClockAF1._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-1048576, ub=1048575)], ev=None, er=[])
    _StandardClockModelElement_stanClockAF0 = INT(name=u'stanClockAF0', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _StandardClockModelElement_stanClockAF0._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-1073741824, ub=1073741823)], ev=None, er=[])
    _StandardClockModelElement_stanClockTgd = INT(name=u'stanClockTgd', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _StandardClockModelElement_stanClockTgd._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-512, ub=511)], ev=None, er=[])
    _StandardClockModelElement_sisa = INT(name=u'sisa', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _StandardClockModelElement_sisa._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _StandardClockModelElement_stanModelID = INT(name=u'stanModelID', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _StandardClockModelElement_stanModelID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=1)], ev=None, er=[])
    StandardClockModelElement._cont = ASN1Dict([
        (u'stanClockToc', _StandardClockModelElement_stanClockToc),
        (u'stanClockAF2', _StandardClockModelElement_stanClockAF2),
        (u'stanClockAF1', _StandardClockModelElement_stanClockAF1),
        (u'stanClockAF0', _StandardClockModelElement_stanClockAF0),
        (u'stanClockTgd', _StandardClockModelElement_stanClockTgd),
        (u'sisa', _StandardClockModelElement_sisa),
        (u'stanModelID', _StandardClockModelElement_stanModelID),
        ])
    StandardClockModelElement._ext = []
    
    #-----< NAV-ClockModel >-----#
    NAV_ClockModel = SEQ(name=u'NAV-ClockModel', mode=MODE_TYPE)
    _NAV_ClockModel_navToc = INT(name=u'navToc', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NAV_ClockModel_navToc._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=37799)], ev=None, er=[])
    _NAV_ClockModel_navaf2 = INT(name=u'navaf2', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NAV_ClockModel_navaf2._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-128, ub=127)], ev=None, er=[])
    _NAV_ClockModel_navaf1 = INT(name=u'navaf1', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NAV_ClockModel_navaf1._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-32768, ub=32767)], ev=None, er=[])
    _NAV_ClockModel_navaf0 = INT(name=u'navaf0', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NAV_ClockModel_navaf0._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-2097152, ub=2097151)], ev=None, er=[])
    _NAV_ClockModel_navTgd = INT(name=u'navTgd', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NAV_ClockModel_navTgd._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-128, ub=127)], ev=None, er=[])
    NAV_ClockModel._cont = ASN1Dict([
        (u'navToc', _NAV_ClockModel_navToc),
        (u'navaf2', _NAV_ClockModel_navaf2),
        (u'navaf1', _NAV_ClockModel_navaf1),
        (u'navaf0', _NAV_ClockModel_navaf0),
        (u'navTgd', _NAV_ClockModel_navTgd),
        ])
    NAV_ClockModel._ext = []
    
    #-----< CNAV-ClockModel >-----#
    CNAV_ClockModel = SEQ(name=u'CNAV-ClockModel', mode=MODE_TYPE)
    _CNAV_ClockModel_cnavToc = INT(name=u'cnavToc', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _CNAV_ClockModel_cnavToc._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=2015)], ev=None, er=[])
    _CNAV_ClockModel_cnavTop = INT(name=u'cnavTop', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _CNAV_ClockModel_cnavTop._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=2015)], ev=None, er=[])
    _CNAV_ClockModel_cnavURA0 = INT(name=u'cnavURA0', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _CNAV_ClockModel_cnavURA0._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-16, ub=15)], ev=None, er=[])
    _CNAV_ClockModel_cnavURA1 = INT(name=u'cnavURA1', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _CNAV_ClockModel_cnavURA1._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=7)], ev=None, er=[])
    _CNAV_ClockModel_cnavURA2 = INT(name=u'cnavURA2', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _CNAV_ClockModel_cnavURA2._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=7)], ev=None, er=[])
    _CNAV_ClockModel_cnavAf2 = INT(name=u'cnavAf2', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _CNAV_ClockModel_cnavAf2._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-512, ub=511)], ev=None, er=[])
    _CNAV_ClockModel_cnavAf1 = INT(name=u'cnavAf1', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _CNAV_ClockModel_cnavAf1._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-524288, ub=524287)], ev=None, er=[])
    _CNAV_ClockModel_cnavAf0 = INT(name=u'cnavAf0', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _CNAV_ClockModel_cnavAf0._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-33554432, ub=33554431)], ev=None, er=[])
    _CNAV_ClockModel_cnavTgd = INT(name=u'cnavTgd', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _CNAV_ClockModel_cnavTgd._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-4096, ub=4095)], ev=None, er=[])
    _CNAV_ClockModel_cnavISCl1cp = INT(name=u'cnavISCl1cp', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CNAV_ClockModel_cnavISCl1cp._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-4096, ub=4095)], ev=None, er=[])
    _CNAV_ClockModel_cnavISCl1cd = INT(name=u'cnavISCl1cd', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CNAV_ClockModel_cnavISCl1cd._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-4096, ub=4095)], ev=None, er=[])
    _CNAV_ClockModel_cnavISCl1ca = INT(name=u'cnavISCl1ca', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CNAV_ClockModel_cnavISCl1ca._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-4096, ub=4095)], ev=None, er=[])
    _CNAV_ClockModel_cnavISCl2c = INT(name=u'cnavISCl2c', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CNAV_ClockModel_cnavISCl2c._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-4096, ub=4095)], ev=None, er=[])
    _CNAV_ClockModel_cnavISCl5i5 = INT(name=u'cnavISCl5i5', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CNAV_ClockModel_cnavISCl5i5._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-4096, ub=4095)], ev=None, er=[])
    _CNAV_ClockModel_cnavISCl5q5 = INT(name=u'cnavISCl5q5', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CNAV_ClockModel_cnavISCl5q5._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-4096, ub=4095)], ev=None, er=[])
    CNAV_ClockModel._cont = ASN1Dict([
        (u'cnavToc', _CNAV_ClockModel_cnavToc),
        (u'cnavTop', _CNAV_ClockModel_cnavTop),
        (u'cnavURA0', _CNAV_ClockModel_cnavURA0),
        (u'cnavURA1', _CNAV_ClockModel_cnavURA1),
        (u'cnavURA2', _CNAV_ClockModel_cnavURA2),
        (u'cnavAf2', _CNAV_ClockModel_cnavAf2),
        (u'cnavAf1', _CNAV_ClockModel_cnavAf1),
        (u'cnavAf0', _CNAV_ClockModel_cnavAf0),
        (u'cnavTgd', _CNAV_ClockModel_cnavTgd),
        (u'cnavISCl1cp', _CNAV_ClockModel_cnavISCl1cp),
        (u'cnavISCl1cd', _CNAV_ClockModel_cnavISCl1cd),
        (u'cnavISCl1ca', _CNAV_ClockModel_cnavISCl1ca),
        (u'cnavISCl2c', _CNAV_ClockModel_cnavISCl2c),
        (u'cnavISCl5i5', _CNAV_ClockModel_cnavISCl5i5),
        (u'cnavISCl5q5', _CNAV_ClockModel_cnavISCl5q5),
        ])
    CNAV_ClockModel._ext = []
    
    #-----< GLONASS-ClockModel >-----#
    GLONASS_ClockModel = SEQ(name=u'GLONASS-ClockModel', mode=MODE_TYPE)
    _GLONASS_ClockModel_gloTau = INT(name=u'gloTau', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GLONASS_ClockModel_gloTau._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-2097152, ub=2097151)], ev=None, er=[])
    _GLONASS_ClockModel_gloGamma = INT(name=u'gloGamma', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GLONASS_ClockModel_gloGamma._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-1024, ub=1023)], ev=None, er=[])
    _GLONASS_ClockModel_gloDeltaTau = INT(name=u'gloDeltaTau', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GLONASS_ClockModel_gloDeltaTau._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-16, ub=15)], ev=None, er=[])
    GLONASS_ClockModel._cont = ASN1Dict([
        (u'gloTau', _GLONASS_ClockModel_gloTau),
        (u'gloGamma', _GLONASS_ClockModel_gloGamma),
        (u'gloDeltaTau', _GLONASS_ClockModel_gloDeltaTau),
        ])
    GLONASS_ClockModel._ext = []
    
    #-----< SBAS-ClockModel >-----#
    SBAS_ClockModel = SEQ(name=u'SBAS-ClockModel', mode=MODE_TYPE)
    _SBAS_ClockModel_sbasTo = INT(name=u'sbasTo', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _SBAS_ClockModel_sbasTo._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=5399)], ev=None, er=[])
    _SBAS_ClockModel_sbasAgfo = INT(name=u'sbasAgfo', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _SBAS_ClockModel_sbasAgfo._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-2048, ub=2047)], ev=None, er=[])
    _SBAS_ClockModel_sbasAgf1 = INT(name=u'sbasAgf1', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _SBAS_ClockModel_sbasAgf1._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-128, ub=127)], ev=None, er=[])
    SBAS_ClockModel._cont = ASN1Dict([
        (u'sbasTo', _SBAS_ClockModel_sbasTo),
        (u'sbasAgfo', _SBAS_ClockModel_sbasAgfo),
        (u'sbasAgf1', _SBAS_ClockModel_sbasAgf1),
        ])
    SBAS_ClockModel._ext = []
    
    #-----< BDS-ClockModel-r12 >-----#
    BDS_ClockModel_r12 = SEQ(name=u'BDS-ClockModel-r12', mode=MODE_TYPE)
    _BDS_ClockModel_r12_bdsAODC_r12 = INT(name=u'bdsAODC-r12', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _BDS_ClockModel_r12_bdsAODC_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=31)], ev=None, er=[])
    _BDS_ClockModel_r12_bdsToc_r12 = INT(name=u'bdsToc-r12', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _BDS_ClockModel_r12_bdsToc_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=131071)], ev=None, er=[])
    _BDS_ClockModel_r12_bdsA0_r12 = INT(name=u'bdsA0-r12', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _BDS_ClockModel_r12_bdsA0_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-8388608, ub=8388607)], ev=None, er=[])
    _BDS_ClockModel_r12_bdsA1_r12 = INT(name=u'bdsA1-r12', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _BDS_ClockModel_r12_bdsA1_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-2097152, ub=2097151)], ev=None, er=[])
    _BDS_ClockModel_r12_bdsA2_r12 = INT(name=u'bdsA2-r12', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _BDS_ClockModel_r12_bdsA2_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-1024, ub=1023)], ev=None, er=[])
    _BDS_ClockModel_r12_bdsTgd1_r12 = INT(name=u'bdsTgd1-r12', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _BDS_ClockModel_r12_bdsTgd1_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-512, ub=511)], ev=None, er=[])
    BDS_ClockModel_r12._cont = ASN1Dict([
        (u'bdsAODC-r12', _BDS_ClockModel_r12_bdsAODC_r12),
        (u'bdsToc-r12', _BDS_ClockModel_r12_bdsToc_r12),
        (u'bdsA0-r12', _BDS_ClockModel_r12_bdsA0_r12),
        (u'bdsA1-r12', _BDS_ClockModel_r12_bdsA1_r12),
        (u'bdsA2-r12', _BDS_ClockModel_r12_bdsA2_r12),
        (u'bdsTgd1-r12', _BDS_ClockModel_r12_bdsTgd1_r12),
        ])
    BDS_ClockModel_r12._ext = []
    
    #-----< NavModelKeplerianSet >-----#
    NavModelKeplerianSet = SEQ(name=u'NavModelKeplerianSet', mode=MODE_TYPE)
    _NavModelKeplerianSet_keplerToe = INT(name=u'keplerToe', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelKeplerianSet_keplerToe._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=16383)], ev=None, er=[])
    _NavModelKeplerianSet_keplerW = INT(name=u'keplerW', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelKeplerianSet_keplerW._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-2147483648, ub=2147483647)], ev=None, er=[])
    _NavModelKeplerianSet_keplerDeltaN = INT(name=u'keplerDeltaN', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelKeplerianSet_keplerDeltaN._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-32768, ub=32767)], ev=None, er=[])
    _NavModelKeplerianSet_keplerM0 = INT(name=u'keplerM0', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelKeplerianSet_keplerM0._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-2147483648, ub=2147483647)], ev=None, er=[])
    _NavModelKeplerianSet_keplerOmegaDot = INT(name=u'keplerOmegaDot', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelKeplerianSet_keplerOmegaDot._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-8388608, ub=8388607)], ev=None, er=[])
    _NavModelKeplerianSet_keplerE = INT(name=u'keplerE', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelKeplerianSet_keplerE._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4294967295)], ev=None, er=[])
    _NavModelKeplerianSet_keplerIDot = INT(name=u'keplerIDot', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelKeplerianSet_keplerIDot._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-8192, ub=8191)], ev=None, er=[])
    _NavModelKeplerianSet_keplerAPowerHalf = INT(name=u'keplerAPowerHalf', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelKeplerianSet_keplerAPowerHalf._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4294967295)], ev=None, er=[])
    _NavModelKeplerianSet_keplerI0 = INT(name=u'keplerI0', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelKeplerianSet_keplerI0._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-2147483648, ub=2147483647)], ev=None, er=[])
    _NavModelKeplerianSet_keplerOmega0 = INT(name=u'keplerOmega0', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelKeplerianSet_keplerOmega0._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-2147483648, ub=2147483647)], ev=None, er=[])
    _NavModelKeplerianSet_keplerCrs = INT(name=u'keplerCrs', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelKeplerianSet_keplerCrs._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-32768, ub=32767)], ev=None, er=[])
    _NavModelKeplerianSet_keplerCis = INT(name=u'keplerCis', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelKeplerianSet_keplerCis._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-32768, ub=32767)], ev=None, er=[])
    _NavModelKeplerianSet_keplerCus = INT(name=u'keplerCus', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelKeplerianSet_keplerCus._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-32768, ub=32767)], ev=None, er=[])
    _NavModelKeplerianSet_keplerCrc = INT(name=u'keplerCrc', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelKeplerianSet_keplerCrc._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-32768, ub=32767)], ev=None, er=[])
    _NavModelKeplerianSet_keplerCic = INT(name=u'keplerCic', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelKeplerianSet_keplerCic._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-32768, ub=32767)], ev=None, er=[])
    _NavModelKeplerianSet_keplerCuc = INT(name=u'keplerCuc', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelKeplerianSet_keplerCuc._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-32768, ub=32767)], ev=None, er=[])
    NavModelKeplerianSet._cont = ASN1Dict([
        (u'keplerToe', _NavModelKeplerianSet_keplerToe),
        (u'keplerW', _NavModelKeplerianSet_keplerW),
        (u'keplerDeltaN', _NavModelKeplerianSet_keplerDeltaN),
        (u'keplerM0', _NavModelKeplerianSet_keplerM0),
        (u'keplerOmegaDot', _NavModelKeplerianSet_keplerOmegaDot),
        (u'keplerE', _NavModelKeplerianSet_keplerE),
        (u'keplerIDot', _NavModelKeplerianSet_keplerIDot),
        (u'keplerAPowerHalf', _NavModelKeplerianSet_keplerAPowerHalf),
        (u'keplerI0', _NavModelKeplerianSet_keplerI0),
        (u'keplerOmega0', _NavModelKeplerianSet_keplerOmega0),
        (u'keplerCrs', _NavModelKeplerianSet_keplerCrs),
        (u'keplerCis', _NavModelKeplerianSet_keplerCis),
        (u'keplerCus', _NavModelKeplerianSet_keplerCus),
        (u'keplerCrc', _NavModelKeplerianSet_keplerCrc),
        (u'keplerCic', _NavModelKeplerianSet_keplerCic),
        (u'keplerCuc', _NavModelKeplerianSet_keplerCuc),
        ])
    NavModelKeplerianSet._ext = []
    
    #-----< NavModelNAV-KeplerianSet >-----#
    NavModelNAV_KeplerianSet = SEQ(name=u'NavModelNAV-KeplerianSet', mode=MODE_TYPE)
    _NavModelNAV_KeplerianSet_navURA = INT(name=u'navURA', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelNAV_KeplerianSet_navURA._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=15)], ev=None, er=[])
    _NavModelNAV_KeplerianSet_navFitFlag = INT(name=u'navFitFlag', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelNAV_KeplerianSet_navFitFlag._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=1)], ev=None, er=[])
    _NavModelNAV_KeplerianSet_navToe = INT(name=u'navToe', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelNAV_KeplerianSet_navToe._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=37799)], ev=None, er=[])
    _NavModelNAV_KeplerianSet_navOmega = INT(name=u'navOmega', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelNAV_KeplerianSet_navOmega._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-2147483648, ub=2147483647)], ev=None, er=[])
    _NavModelNAV_KeplerianSet_navDeltaN = INT(name=u'navDeltaN', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelNAV_KeplerianSet_navDeltaN._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-32768, ub=32767)], ev=None, er=[])
    _NavModelNAV_KeplerianSet_navM0 = INT(name=u'navM0', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelNAV_KeplerianSet_navM0._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-2147483648, ub=2147483647)], ev=None, er=[])
    _NavModelNAV_KeplerianSet_navOmegaADot = INT(name=u'navOmegaADot', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelNAV_KeplerianSet_navOmegaADot._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-8388608, ub=8388607)], ev=None, er=[])
    _NavModelNAV_KeplerianSet_navE = INT(name=u'navE', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelNAV_KeplerianSet_navE._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4294967295)], ev=None, er=[])
    _NavModelNAV_KeplerianSet_navIDot = INT(name=u'navIDot', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelNAV_KeplerianSet_navIDot._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-8192, ub=8191)], ev=None, er=[])
    _NavModelNAV_KeplerianSet_navAPowerHalf = INT(name=u'navAPowerHalf', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelNAV_KeplerianSet_navAPowerHalf._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4294967295)], ev=None, er=[])
    _NavModelNAV_KeplerianSet_navI0 = INT(name=u'navI0', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelNAV_KeplerianSet_navI0._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-2147483648, ub=2147483647)], ev=None, er=[])
    _NavModelNAV_KeplerianSet_navOmegaA0 = INT(name=u'navOmegaA0', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelNAV_KeplerianSet_navOmegaA0._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-2147483648, ub=2147483647)], ev=None, er=[])
    _NavModelNAV_KeplerianSet_navCrs = INT(name=u'navCrs', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelNAV_KeplerianSet_navCrs._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-32768, ub=32767)], ev=None, er=[])
    _NavModelNAV_KeplerianSet_navCis = INT(name=u'navCis', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelNAV_KeplerianSet_navCis._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-32768, ub=32767)], ev=None, er=[])
    _NavModelNAV_KeplerianSet_navCus = INT(name=u'navCus', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelNAV_KeplerianSet_navCus._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-32768, ub=32767)], ev=None, er=[])
    _NavModelNAV_KeplerianSet_navCrc = INT(name=u'navCrc', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelNAV_KeplerianSet_navCrc._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-32768, ub=32767)], ev=None, er=[])
    _NavModelNAV_KeplerianSet_navCic = INT(name=u'navCic', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelNAV_KeplerianSet_navCic._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-32768, ub=32767)], ev=None, er=[])
    _NavModelNAV_KeplerianSet_navCuc = INT(name=u'navCuc', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelNAV_KeplerianSet_navCuc._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-32768, ub=32767)], ev=None, er=[])
    _NavModelNAV_KeplerianSet_addNAVparam = SEQ(name=u'addNAVparam', mode=MODE_TYPE, tag=(18, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __NavModelNAV_KeplerianSet_addNAVparam_ephemCodeOnL2 = INT(name=u'ephemCodeOnL2', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __NavModelNAV_KeplerianSet_addNAVparam_ephemCodeOnL2._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=3)], ev=None, er=[])
    __NavModelNAV_KeplerianSet_addNAVparam_ephemL2Pflag = INT(name=u'ephemL2Pflag', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __NavModelNAV_KeplerianSet_addNAVparam_ephemL2Pflag._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=1)], ev=None, er=[])
    __NavModelNAV_KeplerianSet_addNAVparam_ephemSF1Rsvd = SEQ(name=u'ephemSF1Rsvd', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___NavModelNAV_KeplerianSet_addNAVparam_ephemSF1Rsvd_reserved1 = INT(name=u'reserved1', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___NavModelNAV_KeplerianSet_addNAVparam_ephemSF1Rsvd_reserved1._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=8388607)], ev=None, er=[])
    ___NavModelNAV_KeplerianSet_addNAVparam_ephemSF1Rsvd_reserved2 = INT(name=u'reserved2', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___NavModelNAV_KeplerianSet_addNAVparam_ephemSF1Rsvd_reserved2._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=16777215)], ev=None, er=[])
    ___NavModelNAV_KeplerianSet_addNAVparam_ephemSF1Rsvd_reserved3 = INT(name=u'reserved3', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___NavModelNAV_KeplerianSet_addNAVparam_ephemSF1Rsvd_reserved3._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=16777215)], ev=None, er=[])
    ___NavModelNAV_KeplerianSet_addNAVparam_ephemSF1Rsvd_reserved4 = INT(name=u'reserved4', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___NavModelNAV_KeplerianSet_addNAVparam_ephemSF1Rsvd_reserved4._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    __NavModelNAV_KeplerianSet_addNAVparam_ephemSF1Rsvd._cont = ASN1Dict([
        (u'reserved1', ___NavModelNAV_KeplerianSet_addNAVparam_ephemSF1Rsvd_reserved1),
        (u'reserved2', ___NavModelNAV_KeplerianSet_addNAVparam_ephemSF1Rsvd_reserved2),
        (u'reserved3', ___NavModelNAV_KeplerianSet_addNAVparam_ephemSF1Rsvd_reserved3),
        (u'reserved4', ___NavModelNAV_KeplerianSet_addNAVparam_ephemSF1Rsvd_reserved4),
        ])
    __NavModelNAV_KeplerianSet_addNAVparam_ephemSF1Rsvd._ext = None
    __NavModelNAV_KeplerianSet_addNAVparam_ephemAODA = INT(name=u'ephemAODA', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __NavModelNAV_KeplerianSet_addNAVparam_ephemAODA._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=31)], ev=None, er=[])
    _NavModelNAV_KeplerianSet_addNAVparam._cont = ASN1Dict([
        (u'ephemCodeOnL2', __NavModelNAV_KeplerianSet_addNAVparam_ephemCodeOnL2),
        (u'ephemL2Pflag', __NavModelNAV_KeplerianSet_addNAVparam_ephemL2Pflag),
        (u'ephemSF1Rsvd', __NavModelNAV_KeplerianSet_addNAVparam_ephemSF1Rsvd),
        (u'ephemAODA', __NavModelNAV_KeplerianSet_addNAVparam_ephemAODA),
        ])
    _NavModelNAV_KeplerianSet_addNAVparam._ext = None
    NavModelNAV_KeplerianSet._cont = ASN1Dict([
        (u'navURA', _NavModelNAV_KeplerianSet_navURA),
        (u'navFitFlag', _NavModelNAV_KeplerianSet_navFitFlag),
        (u'navToe', _NavModelNAV_KeplerianSet_navToe),
        (u'navOmega', _NavModelNAV_KeplerianSet_navOmega),
        (u'navDeltaN', _NavModelNAV_KeplerianSet_navDeltaN),
        (u'navM0', _NavModelNAV_KeplerianSet_navM0),
        (u'navOmegaADot', _NavModelNAV_KeplerianSet_navOmegaADot),
        (u'navE', _NavModelNAV_KeplerianSet_navE),
        (u'navIDot', _NavModelNAV_KeplerianSet_navIDot),
        (u'navAPowerHalf', _NavModelNAV_KeplerianSet_navAPowerHalf),
        (u'navI0', _NavModelNAV_KeplerianSet_navI0),
        (u'navOmegaA0', _NavModelNAV_KeplerianSet_navOmegaA0),
        (u'navCrs', _NavModelNAV_KeplerianSet_navCrs),
        (u'navCis', _NavModelNAV_KeplerianSet_navCis),
        (u'navCus', _NavModelNAV_KeplerianSet_navCus),
        (u'navCrc', _NavModelNAV_KeplerianSet_navCrc),
        (u'navCic', _NavModelNAV_KeplerianSet_navCic),
        (u'navCuc', _NavModelNAV_KeplerianSet_navCuc),
        (u'addNAVparam', _NavModelNAV_KeplerianSet_addNAVparam),
        ])
    NavModelNAV_KeplerianSet._ext = []
    
    #-----< NavModelCNAV-KeplerianSet >-----#
    NavModelCNAV_KeplerianSet = SEQ(name=u'NavModelCNAV-KeplerianSet', mode=MODE_TYPE)
    _NavModelCNAV_KeplerianSet_cnavTop = INT(name=u'cnavTop', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelCNAV_KeplerianSet_cnavTop._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=2015)], ev=None, er=[])
    _NavModelCNAV_KeplerianSet_cnavURAindex = INT(name=u'cnavURAindex', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelCNAV_KeplerianSet_cnavURAindex._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-16, ub=15)], ev=None, er=[])
    _NavModelCNAV_KeplerianSet_cnavDeltaA = INT(name=u'cnavDeltaA', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelCNAV_KeplerianSet_cnavDeltaA._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-33554432, ub=33554431)], ev=None, er=[])
    _NavModelCNAV_KeplerianSet_cnavAdot = INT(name=u'cnavAdot', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelCNAV_KeplerianSet_cnavAdot._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-16777216, ub=16777215)], ev=None, er=[])
    _NavModelCNAV_KeplerianSet_cnavDeltaNo = INT(name=u'cnavDeltaNo', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelCNAV_KeplerianSet_cnavDeltaNo._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-65536, ub=65535)], ev=None, er=[])
    _NavModelCNAV_KeplerianSet_cnavDeltaNoDot = INT(name=u'cnavDeltaNoDot', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelCNAV_KeplerianSet_cnavDeltaNoDot._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-4194304, ub=4194303)], ev=None, er=[])
    _NavModelCNAV_KeplerianSet_cnavMo = INT(name=u'cnavMo', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelCNAV_KeplerianSet_cnavMo._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-4294967296, ub=4294967295)], ev=None, er=[])
    _NavModelCNAV_KeplerianSet_cnavE = INT(name=u'cnavE', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelCNAV_KeplerianSet_cnavE._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=8589934591)], ev=None, er=[])
    _NavModelCNAV_KeplerianSet_cnavOmega = INT(name=u'cnavOmega', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelCNAV_KeplerianSet_cnavOmega._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-4294967296, ub=4294967295)], ev=None, er=[])
    _NavModelCNAV_KeplerianSet_cnavOMEGA0 = INT(name=u'cnavOMEGA0', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelCNAV_KeplerianSet_cnavOMEGA0._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-4294967296, ub=4294967295)], ev=None, er=[])
    _NavModelCNAV_KeplerianSet_cnavDeltaOmegaDot = INT(name=u'cnavDeltaOmegaDot', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelCNAV_KeplerianSet_cnavDeltaOmegaDot._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-65536, ub=65535)], ev=None, er=[])
    _NavModelCNAV_KeplerianSet_cnavIo = INT(name=u'cnavIo', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelCNAV_KeplerianSet_cnavIo._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-4294967296, ub=4294967295)], ev=None, er=[])
    _NavModelCNAV_KeplerianSet_cnavIoDot = INT(name=u'cnavIoDot', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelCNAV_KeplerianSet_cnavIoDot._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-16384, ub=16383)], ev=None, er=[])
    _NavModelCNAV_KeplerianSet_cnavCis = INT(name=u'cnavCis', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelCNAV_KeplerianSet_cnavCis._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-32768, ub=32767)], ev=None, er=[])
    _NavModelCNAV_KeplerianSet_cnavCic = INT(name=u'cnavCic', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelCNAV_KeplerianSet_cnavCic._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-32768, ub=32767)], ev=None, er=[])
    _NavModelCNAV_KeplerianSet_cnavCrs = INT(name=u'cnavCrs', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelCNAV_KeplerianSet_cnavCrs._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-8388608, ub=8388607)], ev=None, er=[])
    _NavModelCNAV_KeplerianSet_cnavCrc = INT(name=u'cnavCrc', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelCNAV_KeplerianSet_cnavCrc._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-8388608, ub=8388607)], ev=None, er=[])
    _NavModelCNAV_KeplerianSet_cnavCus = INT(name=u'cnavCus', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelCNAV_KeplerianSet_cnavCus._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-1048576, ub=1048575)], ev=None, er=[])
    _NavModelCNAV_KeplerianSet_cnavCuc = INT(name=u'cnavCuc', mode=MODE_TYPE, tag=(18, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModelCNAV_KeplerianSet_cnavCuc._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-1048576, ub=1048575)], ev=None, er=[])
    NavModelCNAV_KeplerianSet._cont = ASN1Dict([
        (u'cnavTop', _NavModelCNAV_KeplerianSet_cnavTop),
        (u'cnavURAindex', _NavModelCNAV_KeplerianSet_cnavURAindex),
        (u'cnavDeltaA', _NavModelCNAV_KeplerianSet_cnavDeltaA),
        (u'cnavAdot', _NavModelCNAV_KeplerianSet_cnavAdot),
        (u'cnavDeltaNo', _NavModelCNAV_KeplerianSet_cnavDeltaNo),
        (u'cnavDeltaNoDot', _NavModelCNAV_KeplerianSet_cnavDeltaNoDot),
        (u'cnavMo', _NavModelCNAV_KeplerianSet_cnavMo),
        (u'cnavE', _NavModelCNAV_KeplerianSet_cnavE),
        (u'cnavOmega', _NavModelCNAV_KeplerianSet_cnavOmega),
        (u'cnavOMEGA0', _NavModelCNAV_KeplerianSet_cnavOMEGA0),
        (u'cnavDeltaOmegaDot', _NavModelCNAV_KeplerianSet_cnavDeltaOmegaDot),
        (u'cnavIo', _NavModelCNAV_KeplerianSet_cnavIo),
        (u'cnavIoDot', _NavModelCNAV_KeplerianSet_cnavIoDot),
        (u'cnavCis', _NavModelCNAV_KeplerianSet_cnavCis),
        (u'cnavCic', _NavModelCNAV_KeplerianSet_cnavCic),
        (u'cnavCrs', _NavModelCNAV_KeplerianSet_cnavCrs),
        (u'cnavCrc', _NavModelCNAV_KeplerianSet_cnavCrc),
        (u'cnavCus', _NavModelCNAV_KeplerianSet_cnavCus),
        (u'cnavCuc', _NavModelCNAV_KeplerianSet_cnavCuc),
        ])
    NavModelCNAV_KeplerianSet._ext = []
    
    #-----< NavModel-GLONASS-ECEF >-----#
    NavModel_GLONASS_ECEF = SEQ(name=u'NavModel-GLONASS-ECEF', mode=MODE_TYPE)
    _NavModel_GLONASS_ECEF_gloEn = INT(name=u'gloEn', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_GLONASS_ECEF_gloEn._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=31)], ev=None, er=[])
    _NavModel_GLONASS_ECEF_gloP1 = BIT_STR(name=u'gloP1', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_GLONASS_ECEF_gloP1._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    _NavModel_GLONASS_ECEF_gloP2 = BOOL(name=u'gloP2', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_GLONASS_ECEF_gloM = INT(name=u'gloM', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_GLONASS_ECEF_gloM._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=3)], ev=None, er=[])
    _NavModel_GLONASS_ECEF_gloX = INT(name=u'gloX', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_GLONASS_ECEF_gloX._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-67108864, ub=67108863)], ev=None, er=[])
    _NavModel_GLONASS_ECEF_gloXdot = INT(name=u'gloXdot', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_GLONASS_ECEF_gloXdot._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-8388608, ub=8388607)], ev=None, er=[])
    _NavModel_GLONASS_ECEF_gloXdotdot = INT(name=u'gloXdotdot', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_GLONASS_ECEF_gloXdotdot._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-16, ub=15)], ev=None, er=[])
    _NavModel_GLONASS_ECEF_gloY = INT(name=u'gloY', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_GLONASS_ECEF_gloY._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-67108864, ub=67108863)], ev=None, er=[])
    _NavModel_GLONASS_ECEF_gloYdot = INT(name=u'gloYdot', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_GLONASS_ECEF_gloYdot._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-8388608, ub=8388607)], ev=None, er=[])
    _NavModel_GLONASS_ECEF_gloYdotdot = INT(name=u'gloYdotdot', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_GLONASS_ECEF_gloYdotdot._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-16, ub=15)], ev=None, er=[])
    _NavModel_GLONASS_ECEF_gloZ = INT(name=u'gloZ', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_GLONASS_ECEF_gloZ._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-67108864, ub=67108863)], ev=None, er=[])
    _NavModel_GLONASS_ECEF_gloZdot = INT(name=u'gloZdot', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_GLONASS_ECEF_gloZdot._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-8388608, ub=8388607)], ev=None, er=[])
    _NavModel_GLONASS_ECEF_gloZdotdot = INT(name=u'gloZdotdot', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_GLONASS_ECEF_gloZdotdot._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-16, ub=15)], ev=None, er=[])
    NavModel_GLONASS_ECEF._cont = ASN1Dict([
        (u'gloEn', _NavModel_GLONASS_ECEF_gloEn),
        (u'gloP1', _NavModel_GLONASS_ECEF_gloP1),
        (u'gloP2', _NavModel_GLONASS_ECEF_gloP2),
        (u'gloM', _NavModel_GLONASS_ECEF_gloM),
        (u'gloX', _NavModel_GLONASS_ECEF_gloX),
        (u'gloXdot', _NavModel_GLONASS_ECEF_gloXdot),
        (u'gloXdotdot', _NavModel_GLONASS_ECEF_gloXdotdot),
        (u'gloY', _NavModel_GLONASS_ECEF_gloY),
        (u'gloYdot', _NavModel_GLONASS_ECEF_gloYdot),
        (u'gloYdotdot', _NavModel_GLONASS_ECEF_gloYdotdot),
        (u'gloZ', _NavModel_GLONASS_ECEF_gloZ),
        (u'gloZdot', _NavModel_GLONASS_ECEF_gloZdot),
        (u'gloZdotdot', _NavModel_GLONASS_ECEF_gloZdotdot),
        ])
    NavModel_GLONASS_ECEF._ext = []
    
    #-----< NavModel-SBAS-ECEF >-----#
    NavModel_SBAS_ECEF = SEQ(name=u'NavModel-SBAS-ECEF', mode=MODE_TYPE)
    _NavModel_SBAS_ECEF_sbasTo = INT(name=u'sbasTo', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _NavModel_SBAS_ECEF_sbasTo._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=5399)], ev=None, er=[])
    _NavModel_SBAS_ECEF_sbasAccuracy = BIT_STR(name=u'sbasAccuracy', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_SBAS_ECEF_sbasAccuracy._const_sz = ASN1Set(rv=[4], rr=[], ev=None, er=[])
    _NavModel_SBAS_ECEF_sbasXg = INT(name=u'sbasXg', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_SBAS_ECEF_sbasXg._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-536870912, ub=536870911)], ev=None, er=[])
    _NavModel_SBAS_ECEF_sbasYg = INT(name=u'sbasYg', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_SBAS_ECEF_sbasYg._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-536870912, ub=536870911)], ev=None, er=[])
    _NavModel_SBAS_ECEF_sbasZg = INT(name=u'sbasZg', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_SBAS_ECEF_sbasZg._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-16777216, ub=16777215)], ev=None, er=[])
    _NavModel_SBAS_ECEF_sbasXgDot = INT(name=u'sbasXgDot', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_SBAS_ECEF_sbasXgDot._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-65536, ub=65535)], ev=None, er=[])
    _NavModel_SBAS_ECEF_sbasYgDot = INT(name=u'sbasYgDot', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_SBAS_ECEF_sbasYgDot._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-65536, ub=65535)], ev=None, er=[])
    _NavModel_SBAS_ECEF_sbasZgDot = INT(name=u'sbasZgDot', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_SBAS_ECEF_sbasZgDot._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-131072, ub=131071)], ev=None, er=[])
    _NavModel_SBAS_ECEF_sbasXgDotDot = INT(name=u'sbasXgDotDot', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_SBAS_ECEF_sbasXgDotDot._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-512, ub=511)], ev=None, er=[])
    _NavModel_SBAS_ECEF_sbagYgDotDot = INT(name=u'sbagYgDotDot', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_SBAS_ECEF_sbagYgDotDot._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-512, ub=511)], ev=None, er=[])
    _NavModel_SBAS_ECEF_sbasZgDotDot = INT(name=u'sbasZgDotDot', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_SBAS_ECEF_sbasZgDotDot._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-512, ub=511)], ev=None, er=[])
    NavModel_SBAS_ECEF._cont = ASN1Dict([
        (u'sbasTo', _NavModel_SBAS_ECEF_sbasTo),
        (u'sbasAccuracy', _NavModel_SBAS_ECEF_sbasAccuracy),
        (u'sbasXg', _NavModel_SBAS_ECEF_sbasXg),
        (u'sbasYg', _NavModel_SBAS_ECEF_sbasYg),
        (u'sbasZg', _NavModel_SBAS_ECEF_sbasZg),
        (u'sbasXgDot', _NavModel_SBAS_ECEF_sbasXgDot),
        (u'sbasYgDot', _NavModel_SBAS_ECEF_sbasYgDot),
        (u'sbasZgDot', _NavModel_SBAS_ECEF_sbasZgDot),
        (u'sbasXgDotDot', _NavModel_SBAS_ECEF_sbasXgDotDot),
        (u'sbagYgDotDot', _NavModel_SBAS_ECEF_sbagYgDotDot),
        (u'sbasZgDotDot', _NavModel_SBAS_ECEF_sbasZgDotDot),
        ])
    NavModel_SBAS_ECEF._ext = []
    
    #-----< NavModel-BDS-KeplerianSet-r12 >-----#
    NavModel_BDS_KeplerianSet_r12 = SEQ(name=u'NavModel-BDS-KeplerianSet-r12', mode=MODE_TYPE)
    _NavModel_BDS_KeplerianSet_r12_bdsAODE_r12 = INT(name=u'bdsAODE-r12', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_BDS_KeplerianSet_r12_bdsAODE_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=31)], ev=None, er=[])
    _NavModel_BDS_KeplerianSet_r12_bdsURAI_r12 = INT(name=u'bdsURAI-r12', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_BDS_KeplerianSet_r12_bdsURAI_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=15)], ev=None, er=[])
    _NavModel_BDS_KeplerianSet_r12_bdsToe_r12 = INT(name=u'bdsToe-r12', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_BDS_KeplerianSet_r12_bdsToe_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=131071)], ev=None, er=[])
    _NavModel_BDS_KeplerianSet_r12_bdsAPowerHalf_r12 = INT(name=u'bdsAPowerHalf-r12', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_BDS_KeplerianSet_r12_bdsAPowerHalf_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4294967295)], ev=None, er=[])
    _NavModel_BDS_KeplerianSet_r12_bdsE_r12 = INT(name=u'bdsE-r12', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_BDS_KeplerianSet_r12_bdsE_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4294967295)], ev=None, er=[])
    _NavModel_BDS_KeplerianSet_r12_bdsW_r12 = INT(name=u'bdsW-r12', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_BDS_KeplerianSet_r12_bdsW_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-2147483648, ub=2147483647)], ev=None, er=[])
    _NavModel_BDS_KeplerianSet_r12_bdsDeltaN_r12 = INT(name=u'bdsDeltaN-r12', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_BDS_KeplerianSet_r12_bdsDeltaN_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-32768, ub=32767)], ev=None, er=[])
    _NavModel_BDS_KeplerianSet_r12_bdsM0_r12 = INT(name=u'bdsM0-r12', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_BDS_KeplerianSet_r12_bdsM0_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-2147483648, ub=2147483647)], ev=None, er=[])
    _NavModel_BDS_KeplerianSet_r12_bdsOmega0_r12 = INT(name=u'bdsOmega0-r12', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_BDS_KeplerianSet_r12_bdsOmega0_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-2147483648, ub=2147483647)], ev=None, er=[])
    _NavModel_BDS_KeplerianSet_r12_bdsOmegaDot_r12 = INT(name=u'bdsOmegaDot-r12', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_BDS_KeplerianSet_r12_bdsOmegaDot_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-8388608, ub=8388607)], ev=None, er=[])
    _NavModel_BDS_KeplerianSet_r12_bdsI0_r12 = INT(name=u'bdsI0-r12', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_BDS_KeplerianSet_r12_bdsI0_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-2147483648, ub=2147483647)], ev=None, er=[])
    _NavModel_BDS_KeplerianSet_r12_bdsIDot_r12 = INT(name=u'bdsIDot-r12', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_BDS_KeplerianSet_r12_bdsIDot_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-8192, ub=8191)], ev=None, er=[])
    _NavModel_BDS_KeplerianSet_r12_bdsCuc_r12 = INT(name=u'bdsCuc-r12', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_BDS_KeplerianSet_r12_bdsCuc_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-131072, ub=131071)], ev=None, er=[])
    _NavModel_BDS_KeplerianSet_r12_bdsCus_r12 = INT(name=u'bdsCus-r12', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_BDS_KeplerianSet_r12_bdsCus_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-131072, ub=131071)], ev=None, er=[])
    _NavModel_BDS_KeplerianSet_r12_bdsCrc_r12 = INT(name=u'bdsCrc-r12', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_BDS_KeplerianSet_r12_bdsCrc_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-131072, ub=131071)], ev=None, er=[])
    _NavModel_BDS_KeplerianSet_r12_bdsCrs_r12 = INT(name=u'bdsCrs-r12', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_BDS_KeplerianSet_r12_bdsCrs_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-131072, ub=131071)], ev=None, er=[])
    _NavModel_BDS_KeplerianSet_r12_bdsCic_r12 = INT(name=u'bdsCic-r12', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_BDS_KeplerianSet_r12_bdsCic_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-131072, ub=131071)], ev=None, er=[])
    _NavModel_BDS_KeplerianSet_r12_bdsCis_r12 = INT(name=u'bdsCis-r12', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_BDS_KeplerianSet_r12_bdsCis_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-131072, ub=131071)], ev=None, er=[])
    NavModel_BDS_KeplerianSet_r12._cont = ASN1Dict([
        (u'bdsAODE-r12', _NavModel_BDS_KeplerianSet_r12_bdsAODE_r12),
        (u'bdsURAI-r12', _NavModel_BDS_KeplerianSet_r12_bdsURAI_r12),
        (u'bdsToe-r12', _NavModel_BDS_KeplerianSet_r12_bdsToe_r12),
        (u'bdsAPowerHalf-r12', _NavModel_BDS_KeplerianSet_r12_bdsAPowerHalf_r12),
        (u'bdsE-r12', _NavModel_BDS_KeplerianSet_r12_bdsE_r12),
        (u'bdsW-r12', _NavModel_BDS_KeplerianSet_r12_bdsW_r12),
        (u'bdsDeltaN-r12', _NavModel_BDS_KeplerianSet_r12_bdsDeltaN_r12),
        (u'bdsM0-r12', _NavModel_BDS_KeplerianSet_r12_bdsM0_r12),
        (u'bdsOmega0-r12', _NavModel_BDS_KeplerianSet_r12_bdsOmega0_r12),
        (u'bdsOmegaDot-r12', _NavModel_BDS_KeplerianSet_r12_bdsOmegaDot_r12),
        (u'bdsI0-r12', _NavModel_BDS_KeplerianSet_r12_bdsI0_r12),
        (u'bdsIDot-r12', _NavModel_BDS_KeplerianSet_r12_bdsIDot_r12),
        (u'bdsCuc-r12', _NavModel_BDS_KeplerianSet_r12_bdsCuc_r12),
        (u'bdsCus-r12', _NavModel_BDS_KeplerianSet_r12_bdsCus_r12),
        (u'bdsCrc-r12', _NavModel_BDS_KeplerianSet_r12_bdsCrc_r12),
        (u'bdsCrs-r12', _NavModel_BDS_KeplerianSet_r12_bdsCrs_r12),
        (u'bdsCic-r12', _NavModel_BDS_KeplerianSet_r12_bdsCic_r12),
        (u'bdsCis-r12', _NavModel_BDS_KeplerianSet_r12_bdsCis_r12),
        ])
    NavModel_BDS_KeplerianSet_r12._ext = []
    
    #-----< GNSS-RealTimeIntegrity >-----#
    GNSS_RealTimeIntegrity = SEQ(name=u'GNSS-RealTimeIntegrity', mode=MODE_TYPE)
    _GNSS_RealTimeIntegrity_gnss_BadSignalList = SEQ_OF(name=u'gnss-BadSignalList', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-BadSignalList')))
    GNSS_RealTimeIntegrity._cont = ASN1Dict([
        (u'gnss-BadSignalList', _GNSS_RealTimeIntegrity_gnss_BadSignalList),
        ])
    GNSS_RealTimeIntegrity._ext = []
    
    #-----< GNSS-BadSignalList >-----#
    GNSS_BadSignalList = SEQ_OF(name=u'GNSS-BadSignalList', mode=MODE_TYPE)
    _GNSS_BadSignalList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('LPP-PDU-Definitions', 'BadSignalElement')))
    GNSS_BadSignalList._cont = _GNSS_BadSignalList__item_
    GNSS_BadSignalList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    
    #-----< BadSignalElement >-----#
    BadSignalElement = SEQ(name=u'BadSignalElement', mode=MODE_TYPE)
    _BadSignalElement_badSVID = SEQ(name=u'badSVID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'SV-ID')))
    _BadSignalElement_badSignalID = SEQ(name=u'badSignalID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-SignalIDs')), opt=True)
    BadSignalElement._cont = ASN1Dict([
        (u'badSVID', _BadSignalElement_badSVID),
        (u'badSignalID', _BadSignalElement_badSignalID),
        ])
    BadSignalElement._ext = []
    
    #-----< GNSS-DataBitAssistance >-----#
    GNSS_DataBitAssistance = SEQ(name=u'GNSS-DataBitAssistance', mode=MODE_TYPE)
    _GNSS_DataBitAssistance_gnss_TOD = INT(name=u'gnss-TOD', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GNSS_DataBitAssistance_gnss_TOD._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=3599)], ev=None, er=[])
    _GNSS_DataBitAssistance_gnss_TODfrac = INT(name=u'gnss-TODfrac', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GNSS_DataBitAssistance_gnss_TODfrac._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=999)], ev=None, er=[])
    _GNSS_DataBitAssistance_gnss_DataBitsSatList = SEQ_OF(name=u'gnss-DataBitsSatList', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-DataBitsSatList')))
    GNSS_DataBitAssistance._cont = ASN1Dict([
        (u'gnss-TOD', _GNSS_DataBitAssistance_gnss_TOD),
        (u'gnss-TODfrac', _GNSS_DataBitAssistance_gnss_TODfrac),
        (u'gnss-DataBitsSatList', _GNSS_DataBitAssistance_gnss_DataBitsSatList),
        ])
    GNSS_DataBitAssistance._ext = []
    
    #-----< GNSS-DataBitsSatList >-----#
    GNSS_DataBitsSatList = SEQ_OF(name=u'GNSS-DataBitsSatList', mode=MODE_TYPE)
    _GNSS_DataBitsSatList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-DataBitsSatElement')))
    GNSS_DataBitsSatList._cont = _GNSS_DataBitsSatList__item_
    GNSS_DataBitsSatList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    
    #-----< GNSS-DataBitsSatElement >-----#
    GNSS_DataBitsSatElement = SEQ(name=u'GNSS-DataBitsSatElement', mode=MODE_TYPE)
    _GNSS_DataBitsSatElement_svID = SEQ(name=u'svID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'SV-ID')))
    _GNSS_DataBitsSatElement_gnss_DataBitsSgnList = SEQ_OF(name=u'gnss-DataBitsSgnList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-DataBitsSgnList')))
    GNSS_DataBitsSatElement._cont = ASN1Dict([
        (u'svID', _GNSS_DataBitsSatElement_svID),
        (u'gnss-DataBitsSgnList', _GNSS_DataBitsSatElement_gnss_DataBitsSgnList),
        ])
    GNSS_DataBitsSatElement._ext = []
    
    #-----< GNSS-DataBitsSgnList >-----#
    GNSS_DataBitsSgnList = SEQ_OF(name=u'GNSS-DataBitsSgnList', mode=MODE_TYPE)
    _GNSS_DataBitsSgnList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-DataBitsSgnElement')))
    GNSS_DataBitsSgnList._cont = _GNSS_DataBitsSgnList__item_
    GNSS_DataBitsSgnList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    
    #-----< GNSS-DataBitsSgnElement >-----#
    GNSS_DataBitsSgnElement = SEQ(name=u'GNSS-DataBitsSgnElement', mode=MODE_TYPE)
    _GNSS_DataBitsSgnElement_gnss_SignalType = SEQ(name=u'gnss-SignalType', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-SignalID')))
    _GNSS_DataBitsSgnElement_gnss_DataBits = BIT_STR(name=u'gnss-DataBits', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GNSS_DataBitsSgnElement_gnss_DataBits._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=1024)], ev=None, er=[])
    GNSS_DataBitsSgnElement._cont = ASN1Dict([
        (u'gnss-SignalType', _GNSS_DataBitsSgnElement_gnss_SignalType),
        (u'gnss-DataBits', _GNSS_DataBitsSgnElement_gnss_DataBits),
        ])
    GNSS_DataBitsSgnElement._ext = []
    
    #-----< GNSS-AcquisitionAssistance >-----#
    GNSS_AcquisitionAssistance = SEQ(name=u'GNSS-AcquisitionAssistance', mode=MODE_TYPE)
    _GNSS_AcquisitionAssistance_gnss_SignalID = SEQ(name=u'gnss-SignalID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-SignalID')))
    _GNSS_AcquisitionAssistance_gnss_AcquisitionAssistList = SEQ_OF(name=u'gnss-AcquisitionAssistList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-AcquisitionAssistList')))
    _GNSS_AcquisitionAssistance_confidence_r10 = INT(name=u'confidence-r10', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GNSS_AcquisitionAssistance_confidence_r10._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=100)], ev=None, er=[])
    GNSS_AcquisitionAssistance._cont = ASN1Dict([
        (u'gnss-SignalID', _GNSS_AcquisitionAssistance_gnss_SignalID),
        (u'gnss-AcquisitionAssistList', _GNSS_AcquisitionAssistance_gnss_AcquisitionAssistList),
        (u'confidence-r10', _GNSS_AcquisitionAssistance_confidence_r10),
        ])
    GNSS_AcquisitionAssistance._ext = [u'confidence-r10']
    
    #-----< GNSS-AcquisitionAssistList >-----#
    GNSS_AcquisitionAssistList = SEQ_OF(name=u'GNSS-AcquisitionAssistList', mode=MODE_TYPE)
    _GNSS_AcquisitionAssistList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-AcquisitionAssistElement')))
    GNSS_AcquisitionAssistList._cont = _GNSS_AcquisitionAssistList__item_
    GNSS_AcquisitionAssistList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    
    #-----< GNSS-AcquisitionAssistElement >-----#
    GNSS_AcquisitionAssistElement = SEQ(name=u'GNSS-AcquisitionAssistElement', mode=MODE_TYPE)
    _GNSS_AcquisitionAssistElement_svID = SEQ(name=u'svID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'SV-ID')))
    _GNSS_AcquisitionAssistElement_doppler0 = INT(name=u'doppler0', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GNSS_AcquisitionAssistElement_doppler0._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-2048, ub=2047)], ev=None, er=[])
    _GNSS_AcquisitionAssistElement_doppler1 = INT(name=u'doppler1', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GNSS_AcquisitionAssistElement_doppler1._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    _GNSS_AcquisitionAssistElement_dopplerUncertainty = INT(name=u'dopplerUncertainty', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GNSS_AcquisitionAssistElement_dopplerUncertainty._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4)], ev=None, er=[])
    _GNSS_AcquisitionAssistElement_codePhase = INT(name=u'codePhase', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GNSS_AcquisitionAssistElement_codePhase._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=1022)], ev=None, er=[])
    _GNSS_AcquisitionAssistElement_intCodePhase = INT(name=u'intCodePhase', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GNSS_AcquisitionAssistElement_intCodePhase._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    _GNSS_AcquisitionAssistElement_codePhaseSearchWindow = INT(name=u'codePhaseSearchWindow', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GNSS_AcquisitionAssistElement_codePhaseSearchWindow._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=31)], ev=None, er=[])
    _GNSS_AcquisitionAssistElement_azimuth = INT(name=u'azimuth', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GNSS_AcquisitionAssistElement_azimuth._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=511)], ev=None, er=[])
    _GNSS_AcquisitionAssistElement_elevation = INT(name=u'elevation', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GNSS_AcquisitionAssistElement_elevation._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    _GNSS_AcquisitionAssistElement_codePhase1023 = BOOL(name=u'codePhase1023', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GNSS_AcquisitionAssistElement_dopplerUncertaintyExt_r10 = ENUM(name=u'dopplerUncertaintyExt-r10', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GNSS_AcquisitionAssistElement_dopplerUncertaintyExt_r10._cont = ASN1Dict([(u'd60', 0), (u'd80', 1), (u'd100', 2), (u'd120', 3), (u'noInformation', 4)])
    _GNSS_AcquisitionAssistElement_dopplerUncertaintyExt_r10._ext = []
    GNSS_AcquisitionAssistElement._cont = ASN1Dict([
        (u'svID', _GNSS_AcquisitionAssistElement_svID),
        (u'doppler0', _GNSS_AcquisitionAssistElement_doppler0),
        (u'doppler1', _GNSS_AcquisitionAssistElement_doppler1),
        (u'dopplerUncertainty', _GNSS_AcquisitionAssistElement_dopplerUncertainty),
        (u'codePhase', _GNSS_AcquisitionAssistElement_codePhase),
        (u'intCodePhase', _GNSS_AcquisitionAssistElement_intCodePhase),
        (u'codePhaseSearchWindow', _GNSS_AcquisitionAssistElement_codePhaseSearchWindow),
        (u'azimuth', _GNSS_AcquisitionAssistElement_azimuth),
        (u'elevation', _GNSS_AcquisitionAssistElement_elevation),
        (u'codePhase1023', _GNSS_AcquisitionAssistElement_codePhase1023),
        (u'dopplerUncertaintyExt-r10', _GNSS_AcquisitionAssistElement_dopplerUncertaintyExt_r10),
        ])
    GNSS_AcquisitionAssistElement._ext = [u'codePhase1023', u'dopplerUncertaintyExt-r10']
    
    #-----< GNSS-Almanac >-----#
    GNSS_Almanac = SEQ(name=u'GNSS-Almanac', mode=MODE_TYPE)
    _GNSS_Almanac_weekNumber = INT(name=u'weekNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GNSS_Almanac_weekNumber._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _GNSS_Almanac_toa = INT(name=u'toa', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GNSS_Almanac_toa._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _GNSS_Almanac_ioda = INT(name=u'ioda', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GNSS_Almanac_ioda._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=3)], ev=None, er=[])
    _GNSS_Almanac_completeAlmanacProvided = BOOL(name=u'completeAlmanacProvided', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GNSS_Almanac_gnss_AlmanacList = SEQ_OF(name=u'gnss-AlmanacList', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-AlmanacList')))
    _GNSS_Almanac_toa_ext_v1240 = INT(name=u'toa-ext-v1240', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True, group=0)
    _GNSS_Almanac_toa_ext_v1240._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=256, ub=1023)], ev=None, er=[])
    _GNSS_Almanac_ioda_ext_v1240 = INT(name=u'ioda-ext-v1240', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True, group=0)
    _GNSS_Almanac_ioda_ext_v1240._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=4, ub=15)], ev=None, er=[])
    GNSS_Almanac._cont = ASN1Dict([
        (u'weekNumber', _GNSS_Almanac_weekNumber),
        (u'toa', _GNSS_Almanac_toa),
        (u'ioda', _GNSS_Almanac_ioda),
        (u'completeAlmanacProvided', _GNSS_Almanac_completeAlmanacProvided),
        (u'gnss-AlmanacList', _GNSS_Almanac_gnss_AlmanacList),
        (u'toa-ext-v1240', _GNSS_Almanac_toa_ext_v1240),
        (u'ioda-ext-v1240', _GNSS_Almanac_ioda_ext_v1240),
        ])
    GNSS_Almanac._ext = [u'toa-ext-v1240', u'ioda-ext-v1240']
    
    #-----< GNSS-AlmanacList >-----#
    GNSS_AlmanacList = SEQ_OF(name=u'GNSS-AlmanacList', mode=MODE_TYPE)
    _GNSS_AlmanacList__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-AlmanacElement')))
    GNSS_AlmanacList._cont = _GNSS_AlmanacList__item_
    GNSS_AlmanacList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    
    #-----< GNSS-AlmanacElement >-----#
    GNSS_AlmanacElement = CHOICE(name=u'GNSS-AlmanacElement', mode=MODE_TYPE)
    _GNSS_AlmanacElement_keplerianAlmanacSet = SEQ(name=u'keplerianAlmanacSet', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'AlmanacKeplerianSet')))
    _GNSS_AlmanacElement_keplerianNAV_Almanac = SEQ(name=u'keplerianNAV-Almanac', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'AlmanacNAV-KeplerianSet')))
    _GNSS_AlmanacElement_keplerianReducedAlmanac = SEQ(name=u'keplerianReducedAlmanac', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'AlmanacReducedKeplerianSet')))
    _GNSS_AlmanacElement_keplerianMidiAlmanac = SEQ(name=u'keplerianMidiAlmanac', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'AlmanacMidiAlmanacSet')))
    _GNSS_AlmanacElement_keplerianGLONASS = SEQ(name=u'keplerianGLONASS', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'AlmanacGLONASS-AlmanacSet')))
    _GNSS_AlmanacElement_ecef_SBAS_Almanac = SEQ(name=u'ecef-SBAS-Almanac', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'AlmanacECEF-SBAS-AlmanacSet')))
    _GNSS_AlmanacElement_keplerianBDS_Almanac_r12 = SEQ(name=u'keplerianBDS-Almanac-r12', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'AlmanacBDS-AlmanacSet-r12')))
    GNSS_AlmanacElement._cont = ASN1Dict([
        (u'keplerianAlmanacSet', _GNSS_AlmanacElement_keplerianAlmanacSet),
        (u'keplerianNAV-Almanac', _GNSS_AlmanacElement_keplerianNAV_Almanac),
        (u'keplerianReducedAlmanac', _GNSS_AlmanacElement_keplerianReducedAlmanac),
        (u'keplerianMidiAlmanac', _GNSS_AlmanacElement_keplerianMidiAlmanac),
        (u'keplerianGLONASS', _GNSS_AlmanacElement_keplerianGLONASS),
        (u'ecef-SBAS-Almanac', _GNSS_AlmanacElement_ecef_SBAS_Almanac),
        (u'keplerianBDS-Almanac-r12', _GNSS_AlmanacElement_keplerianBDS_Almanac_r12),
        ])
    GNSS_AlmanacElement._ext = [u'keplerianBDS-Almanac-r12']
    
    #-----< AlmanacKeplerianSet >-----#
    AlmanacKeplerianSet = SEQ(name=u'AlmanacKeplerianSet', mode=MODE_TYPE)
    _AlmanacKeplerianSet_svID = SEQ(name=u'svID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'SV-ID')))
    _AlmanacKeplerianSet_kepAlmanacE = INT(name=u'kepAlmanacE', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacKeplerianSet_kepAlmanacE._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=2047)], ev=None, er=[])
    _AlmanacKeplerianSet_kepAlmanacDeltaI = INT(name=u'kepAlmanacDeltaI', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacKeplerianSet_kepAlmanacDeltaI._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-1024, ub=1023)], ev=None, er=[])
    _AlmanacKeplerianSet_kepAlmanacOmegaDot = INT(name=u'kepAlmanacOmegaDot', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacKeplerianSet_kepAlmanacOmegaDot._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-1024, ub=1023)], ev=None, er=[])
    _AlmanacKeplerianSet_kepSV_StatusINAV = BIT_STR(name=u'kepSV-StatusINAV', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacKeplerianSet_kepSV_StatusINAV._const_sz = ASN1Set(rv=[4], rr=[], ev=None, er=[])
    _AlmanacKeplerianSet_kepSV_StatusFNAV = BIT_STR(name=u'kepSV-StatusFNAV', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _AlmanacKeplerianSet_kepSV_StatusFNAV._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    _AlmanacKeplerianSet_kepAlmanacAPowerHalf = INT(name=u'kepAlmanacAPowerHalf', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacKeplerianSet_kepAlmanacAPowerHalf._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-4096, ub=4095)], ev=None, er=[])
    _AlmanacKeplerianSet_kepAlmanacOmega0 = INT(name=u'kepAlmanacOmega0', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacKeplerianSet_kepAlmanacOmega0._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-32768, ub=32767)], ev=None, er=[])
    _AlmanacKeplerianSet_kepAlmanacW = INT(name=u'kepAlmanacW', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacKeplerianSet_kepAlmanacW._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-32768, ub=32767)], ev=None, er=[])
    _AlmanacKeplerianSet_kepAlmanacM0 = INT(name=u'kepAlmanacM0', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacKeplerianSet_kepAlmanacM0._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-32768, ub=32767)], ev=None, er=[])
    _AlmanacKeplerianSet_kepAlmanacAF0 = INT(name=u'kepAlmanacAF0', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacKeplerianSet_kepAlmanacAF0._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-32768, ub=32767)], ev=None, er=[])
    _AlmanacKeplerianSet_kepAlmanacAF1 = INT(name=u'kepAlmanacAF1', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacKeplerianSet_kepAlmanacAF1._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-4096, ub=4095)], ev=None, er=[])
    AlmanacKeplerianSet._cont = ASN1Dict([
        (u'svID', _AlmanacKeplerianSet_svID),
        (u'kepAlmanacE', _AlmanacKeplerianSet_kepAlmanacE),
        (u'kepAlmanacDeltaI', _AlmanacKeplerianSet_kepAlmanacDeltaI),
        (u'kepAlmanacOmegaDot', _AlmanacKeplerianSet_kepAlmanacOmegaDot),
        (u'kepSV-StatusINAV', _AlmanacKeplerianSet_kepSV_StatusINAV),
        (u'kepSV-StatusFNAV', _AlmanacKeplerianSet_kepSV_StatusFNAV),
        (u'kepAlmanacAPowerHalf', _AlmanacKeplerianSet_kepAlmanacAPowerHalf),
        (u'kepAlmanacOmega0', _AlmanacKeplerianSet_kepAlmanacOmega0),
        (u'kepAlmanacW', _AlmanacKeplerianSet_kepAlmanacW),
        (u'kepAlmanacM0', _AlmanacKeplerianSet_kepAlmanacM0),
        (u'kepAlmanacAF0', _AlmanacKeplerianSet_kepAlmanacAF0),
        (u'kepAlmanacAF1', _AlmanacKeplerianSet_kepAlmanacAF1),
        ])
    AlmanacKeplerianSet._ext = []
    
    #-----< AlmanacNAV-KeplerianSet >-----#
    AlmanacNAV_KeplerianSet = SEQ(name=u'AlmanacNAV-KeplerianSet', mode=MODE_TYPE)
    _AlmanacNAV_KeplerianSet_svID = SEQ(name=u'svID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'SV-ID')))
    _AlmanacNAV_KeplerianSet_navAlmE = INT(name=u'navAlmE', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacNAV_KeplerianSet_navAlmE._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    _AlmanacNAV_KeplerianSet_navAlmDeltaI = INT(name=u'navAlmDeltaI', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacNAV_KeplerianSet_navAlmDeltaI._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-32768, ub=32767)], ev=None, er=[])
    _AlmanacNAV_KeplerianSet_navAlmOMEGADOT = INT(name=u'navAlmOMEGADOT', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacNAV_KeplerianSet_navAlmOMEGADOT._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-32768, ub=32767)], ev=None, er=[])
    _AlmanacNAV_KeplerianSet_navAlmSVHealth = INT(name=u'navAlmSVHealth', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacNAV_KeplerianSet_navAlmSVHealth._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _AlmanacNAV_KeplerianSet_navAlmSqrtA = INT(name=u'navAlmSqrtA', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacNAV_KeplerianSet_navAlmSqrtA._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=16777215)], ev=None, er=[])
    _AlmanacNAV_KeplerianSet_navAlmOMEGAo = INT(name=u'navAlmOMEGAo', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacNAV_KeplerianSet_navAlmOMEGAo._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-8388608, ub=8388607)], ev=None, er=[])
    _AlmanacNAV_KeplerianSet_navAlmOmega = INT(name=u'navAlmOmega', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacNAV_KeplerianSet_navAlmOmega._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-8388608, ub=8388607)], ev=None, er=[])
    _AlmanacNAV_KeplerianSet_navAlmMo = INT(name=u'navAlmMo', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacNAV_KeplerianSet_navAlmMo._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-8388608, ub=8388607)], ev=None, er=[])
    _AlmanacNAV_KeplerianSet_navAlmaf0 = INT(name=u'navAlmaf0', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacNAV_KeplerianSet_navAlmaf0._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-1024, ub=1023)], ev=None, er=[])
    _AlmanacNAV_KeplerianSet_navAlmaf1 = INT(name=u'navAlmaf1', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacNAV_KeplerianSet_navAlmaf1._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-1024, ub=1023)], ev=None, er=[])
    AlmanacNAV_KeplerianSet._cont = ASN1Dict([
        (u'svID', _AlmanacNAV_KeplerianSet_svID),
        (u'navAlmE', _AlmanacNAV_KeplerianSet_navAlmE),
        (u'navAlmDeltaI', _AlmanacNAV_KeplerianSet_navAlmDeltaI),
        (u'navAlmOMEGADOT', _AlmanacNAV_KeplerianSet_navAlmOMEGADOT),
        (u'navAlmSVHealth', _AlmanacNAV_KeplerianSet_navAlmSVHealth),
        (u'navAlmSqrtA', _AlmanacNAV_KeplerianSet_navAlmSqrtA),
        (u'navAlmOMEGAo', _AlmanacNAV_KeplerianSet_navAlmOMEGAo),
        (u'navAlmOmega', _AlmanacNAV_KeplerianSet_navAlmOmega),
        (u'navAlmMo', _AlmanacNAV_KeplerianSet_navAlmMo),
        (u'navAlmaf0', _AlmanacNAV_KeplerianSet_navAlmaf0),
        (u'navAlmaf1', _AlmanacNAV_KeplerianSet_navAlmaf1),
        ])
    AlmanacNAV_KeplerianSet._ext = []
    
    #-----< AlmanacReducedKeplerianSet >-----#
    AlmanacReducedKeplerianSet = SEQ(name=u'AlmanacReducedKeplerianSet', mode=MODE_TYPE)
    _AlmanacReducedKeplerianSet_svID = SEQ(name=u'svID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'SV-ID')))
    _AlmanacReducedKeplerianSet_redAlmDeltaA = INT(name=u'redAlmDeltaA', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacReducedKeplerianSet_redAlmDeltaA._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-128, ub=127)], ev=None, er=[])
    _AlmanacReducedKeplerianSet_redAlmOmega0 = INT(name=u'redAlmOmega0', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacReducedKeplerianSet_redAlmOmega0._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-64, ub=63)], ev=None, er=[])
    _AlmanacReducedKeplerianSet_redAlmPhi0 = INT(name=u'redAlmPhi0', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacReducedKeplerianSet_redAlmPhi0._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-64, ub=63)], ev=None, er=[])
    _AlmanacReducedKeplerianSet_redAlmL1Health = BOOL(name=u'redAlmL1Health', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacReducedKeplerianSet_redAlmL2Health = BOOL(name=u'redAlmL2Health', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacReducedKeplerianSet_redAlmL5Health = BOOL(name=u'redAlmL5Health', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    AlmanacReducedKeplerianSet._cont = ASN1Dict([
        (u'svID', _AlmanacReducedKeplerianSet_svID),
        (u'redAlmDeltaA', _AlmanacReducedKeplerianSet_redAlmDeltaA),
        (u'redAlmOmega0', _AlmanacReducedKeplerianSet_redAlmOmega0),
        (u'redAlmPhi0', _AlmanacReducedKeplerianSet_redAlmPhi0),
        (u'redAlmL1Health', _AlmanacReducedKeplerianSet_redAlmL1Health),
        (u'redAlmL2Health', _AlmanacReducedKeplerianSet_redAlmL2Health),
        (u'redAlmL5Health', _AlmanacReducedKeplerianSet_redAlmL5Health),
        ])
    AlmanacReducedKeplerianSet._ext = []
    
    #-----< AlmanacMidiAlmanacSet >-----#
    AlmanacMidiAlmanacSet = SEQ(name=u'AlmanacMidiAlmanacSet', mode=MODE_TYPE)
    _AlmanacMidiAlmanacSet_svID = SEQ(name=u'svID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'SV-ID')))
    _AlmanacMidiAlmanacSet_midiAlmE = INT(name=u'midiAlmE', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacMidiAlmanacSet_midiAlmE._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=2047)], ev=None, er=[])
    _AlmanacMidiAlmanacSet_midiAlmDeltaI = INT(name=u'midiAlmDeltaI', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacMidiAlmanacSet_midiAlmDeltaI._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-1024, ub=1023)], ev=None, er=[])
    _AlmanacMidiAlmanacSet_midiAlmOmegaDot = INT(name=u'midiAlmOmegaDot', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacMidiAlmanacSet_midiAlmOmegaDot._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-1024, ub=1023)], ev=None, er=[])
    _AlmanacMidiAlmanacSet_midiAlmSqrtA = INT(name=u'midiAlmSqrtA', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacMidiAlmanacSet_midiAlmSqrtA._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=131071)], ev=None, er=[])
    _AlmanacMidiAlmanacSet_midiAlmOmega0 = INT(name=u'midiAlmOmega0', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacMidiAlmanacSet_midiAlmOmega0._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-32768, ub=32767)], ev=None, er=[])
    _AlmanacMidiAlmanacSet_midiAlmOmega = INT(name=u'midiAlmOmega', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacMidiAlmanacSet_midiAlmOmega._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-32768, ub=32767)], ev=None, er=[])
    _AlmanacMidiAlmanacSet_midiAlmMo = INT(name=u'midiAlmMo', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacMidiAlmanacSet_midiAlmMo._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-32768, ub=32767)], ev=None, er=[])
    _AlmanacMidiAlmanacSet_midiAlmaf0 = INT(name=u'midiAlmaf0', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacMidiAlmanacSet_midiAlmaf0._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-1024, ub=1023)], ev=None, er=[])
    _AlmanacMidiAlmanacSet_midiAlmaf1 = INT(name=u'midiAlmaf1', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacMidiAlmanacSet_midiAlmaf1._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-512, ub=511)], ev=None, er=[])
    _AlmanacMidiAlmanacSet_midiAlmL1Health = BOOL(name=u'midiAlmL1Health', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacMidiAlmanacSet_midiAlmL2Health = BOOL(name=u'midiAlmL2Health', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacMidiAlmanacSet_midiAlmL5Health = BOOL(name=u'midiAlmL5Health', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    AlmanacMidiAlmanacSet._cont = ASN1Dict([
        (u'svID', _AlmanacMidiAlmanacSet_svID),
        (u'midiAlmE', _AlmanacMidiAlmanacSet_midiAlmE),
        (u'midiAlmDeltaI', _AlmanacMidiAlmanacSet_midiAlmDeltaI),
        (u'midiAlmOmegaDot', _AlmanacMidiAlmanacSet_midiAlmOmegaDot),
        (u'midiAlmSqrtA', _AlmanacMidiAlmanacSet_midiAlmSqrtA),
        (u'midiAlmOmega0', _AlmanacMidiAlmanacSet_midiAlmOmega0),
        (u'midiAlmOmega', _AlmanacMidiAlmanacSet_midiAlmOmega),
        (u'midiAlmMo', _AlmanacMidiAlmanacSet_midiAlmMo),
        (u'midiAlmaf0', _AlmanacMidiAlmanacSet_midiAlmaf0),
        (u'midiAlmaf1', _AlmanacMidiAlmanacSet_midiAlmaf1),
        (u'midiAlmL1Health', _AlmanacMidiAlmanacSet_midiAlmL1Health),
        (u'midiAlmL2Health', _AlmanacMidiAlmanacSet_midiAlmL2Health),
        (u'midiAlmL5Health', _AlmanacMidiAlmanacSet_midiAlmL5Health),
        ])
    AlmanacMidiAlmanacSet._ext = []
    
    #-----< AlmanacGLONASS-AlmanacSet >-----#
    AlmanacGLONASS_AlmanacSet = SEQ(name=u'AlmanacGLONASS-AlmanacSet', mode=MODE_TYPE)
    _AlmanacGLONASS_AlmanacSet_gloAlm_NA = INT(name=u'gloAlm-NA', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacGLONASS_AlmanacSet_gloAlm_NA._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=1461)], ev=None, er=[])
    _AlmanacGLONASS_AlmanacSet_gloAlmnA = INT(name=u'gloAlmnA', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacGLONASS_AlmanacSet_gloAlmnA._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=24)], ev=None, er=[])
    _AlmanacGLONASS_AlmanacSet_gloAlmHA = INT(name=u'gloAlmHA', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacGLONASS_AlmanacSet_gloAlmHA._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=31)], ev=None, er=[])
    _AlmanacGLONASS_AlmanacSet_gloAlmLambdaA = INT(name=u'gloAlmLambdaA', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacGLONASS_AlmanacSet_gloAlmLambdaA._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-1048576, ub=1048575)], ev=None, er=[])
    _AlmanacGLONASS_AlmanacSet_gloAlmtlambdaA = INT(name=u'gloAlmtlambdaA', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacGLONASS_AlmanacSet_gloAlmtlambdaA._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=2097151)], ev=None, er=[])
    _AlmanacGLONASS_AlmanacSet_gloAlmDeltaIa = INT(name=u'gloAlmDeltaIa', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacGLONASS_AlmanacSet_gloAlmDeltaIa._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-131072, ub=131071)], ev=None, er=[])
    _AlmanacGLONASS_AlmanacSet_gloAlmDeltaTA = INT(name=u'gloAlmDeltaTA', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacGLONASS_AlmanacSet_gloAlmDeltaTA._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-2097152, ub=2097151)], ev=None, er=[])
    _AlmanacGLONASS_AlmanacSet_gloAlmDeltaTdotA = INT(name=u'gloAlmDeltaTdotA', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacGLONASS_AlmanacSet_gloAlmDeltaTdotA._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-64, ub=63)], ev=None, er=[])
    _AlmanacGLONASS_AlmanacSet_gloAlmEpsilonA = INT(name=u'gloAlmEpsilonA', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacGLONASS_AlmanacSet_gloAlmEpsilonA._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=32767)], ev=None, er=[])
    _AlmanacGLONASS_AlmanacSet_gloAlmOmegaA = INT(name=u'gloAlmOmegaA', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacGLONASS_AlmanacSet_gloAlmOmegaA._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-32768, ub=32767)], ev=None, er=[])
    _AlmanacGLONASS_AlmanacSet_gloAlmTauA = INT(name=u'gloAlmTauA', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacGLONASS_AlmanacSet_gloAlmTauA._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-512, ub=511)], ev=None, er=[])
    _AlmanacGLONASS_AlmanacSet_gloAlmCA = INT(name=u'gloAlmCA', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacGLONASS_AlmanacSet_gloAlmCA._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=1)], ev=None, er=[])
    _AlmanacGLONASS_AlmanacSet_gloAlmMA = BIT_STR(name=u'gloAlmMA', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _AlmanacGLONASS_AlmanacSet_gloAlmMA._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    AlmanacGLONASS_AlmanacSet._cont = ASN1Dict([
        (u'gloAlm-NA', _AlmanacGLONASS_AlmanacSet_gloAlm_NA),
        (u'gloAlmnA', _AlmanacGLONASS_AlmanacSet_gloAlmnA),
        (u'gloAlmHA', _AlmanacGLONASS_AlmanacSet_gloAlmHA),
        (u'gloAlmLambdaA', _AlmanacGLONASS_AlmanacSet_gloAlmLambdaA),
        (u'gloAlmtlambdaA', _AlmanacGLONASS_AlmanacSet_gloAlmtlambdaA),
        (u'gloAlmDeltaIa', _AlmanacGLONASS_AlmanacSet_gloAlmDeltaIa),
        (u'gloAlmDeltaTA', _AlmanacGLONASS_AlmanacSet_gloAlmDeltaTA),
        (u'gloAlmDeltaTdotA', _AlmanacGLONASS_AlmanacSet_gloAlmDeltaTdotA),
        (u'gloAlmEpsilonA', _AlmanacGLONASS_AlmanacSet_gloAlmEpsilonA),
        (u'gloAlmOmegaA', _AlmanacGLONASS_AlmanacSet_gloAlmOmegaA),
        (u'gloAlmTauA', _AlmanacGLONASS_AlmanacSet_gloAlmTauA),
        (u'gloAlmCA', _AlmanacGLONASS_AlmanacSet_gloAlmCA),
        (u'gloAlmMA', _AlmanacGLONASS_AlmanacSet_gloAlmMA),
        ])
    AlmanacGLONASS_AlmanacSet._ext = []
    
    #-----< AlmanacECEF-SBAS-AlmanacSet >-----#
    AlmanacECEF_SBAS_AlmanacSet = SEQ(name=u'AlmanacECEF-SBAS-AlmanacSet', mode=MODE_TYPE)
    _AlmanacECEF_SBAS_AlmanacSet_sbasAlmDataID = INT(name=u'sbasAlmDataID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacECEF_SBAS_AlmanacSet_sbasAlmDataID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=3)], ev=None, er=[])
    _AlmanacECEF_SBAS_AlmanacSet_svID = SEQ(name=u'svID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'SV-ID')))
    _AlmanacECEF_SBAS_AlmanacSet_sbasAlmHealth = BIT_STR(name=u'sbasAlmHealth', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacECEF_SBAS_AlmanacSet_sbasAlmHealth._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _AlmanacECEF_SBAS_AlmanacSet_sbasAlmXg = INT(name=u'sbasAlmXg', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacECEF_SBAS_AlmanacSet_sbasAlmXg._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-16384, ub=16383)], ev=None, er=[])
    _AlmanacECEF_SBAS_AlmanacSet_sbasAlmYg = INT(name=u'sbasAlmYg', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacECEF_SBAS_AlmanacSet_sbasAlmYg._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-16384, ub=16383)], ev=None, er=[])
    _AlmanacECEF_SBAS_AlmanacSet_sbasAlmZg = INT(name=u'sbasAlmZg', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacECEF_SBAS_AlmanacSet_sbasAlmZg._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-256, ub=255)], ev=None, er=[])
    _AlmanacECEF_SBAS_AlmanacSet_sbasAlmXgdot = INT(name=u'sbasAlmXgdot', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacECEF_SBAS_AlmanacSet_sbasAlmXgdot._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-4, ub=3)], ev=None, er=[])
    _AlmanacECEF_SBAS_AlmanacSet_sbasAlmYgDot = INT(name=u'sbasAlmYgDot', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacECEF_SBAS_AlmanacSet_sbasAlmYgDot._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-4, ub=3)], ev=None, er=[])
    _AlmanacECEF_SBAS_AlmanacSet_sbasAlmZgDot = INT(name=u'sbasAlmZgDot', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacECEF_SBAS_AlmanacSet_sbasAlmZgDot._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-8, ub=7)], ev=None, er=[])
    _AlmanacECEF_SBAS_AlmanacSet_sbasAlmTo = INT(name=u'sbasAlmTo', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacECEF_SBAS_AlmanacSet_sbasAlmTo._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=2047)], ev=None, er=[])
    AlmanacECEF_SBAS_AlmanacSet._cont = ASN1Dict([
        (u'sbasAlmDataID', _AlmanacECEF_SBAS_AlmanacSet_sbasAlmDataID),
        (u'svID', _AlmanacECEF_SBAS_AlmanacSet_svID),
        (u'sbasAlmHealth', _AlmanacECEF_SBAS_AlmanacSet_sbasAlmHealth),
        (u'sbasAlmXg', _AlmanacECEF_SBAS_AlmanacSet_sbasAlmXg),
        (u'sbasAlmYg', _AlmanacECEF_SBAS_AlmanacSet_sbasAlmYg),
        (u'sbasAlmZg', _AlmanacECEF_SBAS_AlmanacSet_sbasAlmZg),
        (u'sbasAlmXgdot', _AlmanacECEF_SBAS_AlmanacSet_sbasAlmXgdot),
        (u'sbasAlmYgDot', _AlmanacECEF_SBAS_AlmanacSet_sbasAlmYgDot),
        (u'sbasAlmZgDot', _AlmanacECEF_SBAS_AlmanacSet_sbasAlmZgDot),
        (u'sbasAlmTo', _AlmanacECEF_SBAS_AlmanacSet_sbasAlmTo),
        ])
    AlmanacECEF_SBAS_AlmanacSet._ext = []
    
    #-----< AlmanacBDS-AlmanacSet-r12 >-----#
    AlmanacBDS_AlmanacSet_r12 = SEQ(name=u'AlmanacBDS-AlmanacSet-r12', mode=MODE_TYPE)
    _AlmanacBDS_AlmanacSet_r12_svID = SEQ(name=u'svID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'SV-ID')))
    _AlmanacBDS_AlmanacSet_r12_bdsAlmToa_r12 = INT(name=u'bdsAlmToa-r12', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _AlmanacBDS_AlmanacSet_r12_bdsAlmToa_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _AlmanacBDS_AlmanacSet_r12_bdsAlmSqrtA_r12 = INT(name=u'bdsAlmSqrtA-r12', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacBDS_AlmanacSet_r12_bdsAlmSqrtA_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=16777215)], ev=None, er=[])
    _AlmanacBDS_AlmanacSet_r12_bdsAlmE_r12 = INT(name=u'bdsAlmE-r12', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacBDS_AlmanacSet_r12_bdsAlmE_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=131071)], ev=None, er=[])
    _AlmanacBDS_AlmanacSet_r12_bdsAlmW_r12 = INT(name=u'bdsAlmW-r12', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacBDS_AlmanacSet_r12_bdsAlmW_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-8388608, ub=8388607)], ev=None, er=[])
    _AlmanacBDS_AlmanacSet_r12_bdsAlmM0_r12 = INT(name=u'bdsAlmM0-r12', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacBDS_AlmanacSet_r12_bdsAlmM0_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-8388608, ub=8388607)], ev=None, er=[])
    _AlmanacBDS_AlmanacSet_r12_bdsAlmOmega0_r12 = INT(name=u'bdsAlmOmega0-r12', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacBDS_AlmanacSet_r12_bdsAlmOmega0_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-8388608, ub=8388607)], ev=None, er=[])
    _AlmanacBDS_AlmanacSet_r12_bdsAlmOmegaDot_r12 = INT(name=u'bdsAlmOmegaDot-r12', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacBDS_AlmanacSet_r12_bdsAlmOmegaDot_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-65536, ub=65535)], ev=None, er=[])
    _AlmanacBDS_AlmanacSet_r12_bdsAlmDeltaI_r12 = INT(name=u'bdsAlmDeltaI-r12', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacBDS_AlmanacSet_r12_bdsAlmDeltaI_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-32768, ub=32767)], ev=None, er=[])
    _AlmanacBDS_AlmanacSet_r12_bdsAlmA0_r12 = INT(name=u'bdsAlmA0-r12', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacBDS_AlmanacSet_r12_bdsAlmA0_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-1024, ub=1023)], ev=None, er=[])
    _AlmanacBDS_AlmanacSet_r12_bdsAlmA1_r12 = INT(name=u'bdsAlmA1-r12', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacBDS_AlmanacSet_r12_bdsAlmA1_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-1024, ub=1023)], ev=None, er=[])
    _AlmanacBDS_AlmanacSet_r12_bdsSvHealth_r12 = BIT_STR(name=u'bdsSvHealth-r12', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _AlmanacBDS_AlmanacSet_r12_bdsSvHealth_r12._const_sz = ASN1Set(rv=[9], rr=[], ev=None, er=[])
    AlmanacBDS_AlmanacSet_r12._cont = ASN1Dict([
        (u'svID', _AlmanacBDS_AlmanacSet_r12_svID),
        (u'bdsAlmToa-r12', _AlmanacBDS_AlmanacSet_r12_bdsAlmToa_r12),
        (u'bdsAlmSqrtA-r12', _AlmanacBDS_AlmanacSet_r12_bdsAlmSqrtA_r12),
        (u'bdsAlmE-r12', _AlmanacBDS_AlmanacSet_r12_bdsAlmE_r12),
        (u'bdsAlmW-r12', _AlmanacBDS_AlmanacSet_r12_bdsAlmW_r12),
        (u'bdsAlmM0-r12', _AlmanacBDS_AlmanacSet_r12_bdsAlmM0_r12),
        (u'bdsAlmOmega0-r12', _AlmanacBDS_AlmanacSet_r12_bdsAlmOmega0_r12),
        (u'bdsAlmOmegaDot-r12', _AlmanacBDS_AlmanacSet_r12_bdsAlmOmegaDot_r12),
        (u'bdsAlmDeltaI-r12', _AlmanacBDS_AlmanacSet_r12_bdsAlmDeltaI_r12),
        (u'bdsAlmA0-r12', _AlmanacBDS_AlmanacSet_r12_bdsAlmA0_r12),
        (u'bdsAlmA1-r12', _AlmanacBDS_AlmanacSet_r12_bdsAlmA1_r12),
        (u'bdsSvHealth-r12', _AlmanacBDS_AlmanacSet_r12_bdsSvHealth_r12),
        ])
    AlmanacBDS_AlmanacSet_r12._ext = []
    
    #-----< GNSS-UTC-Model >-----#
    GNSS_UTC_Model = CHOICE(name=u'GNSS-UTC-Model', mode=MODE_TYPE)
    _GNSS_UTC_Model_utcModel1 = SEQ(name=u'utcModel1', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'UTC-ModelSet1')))
    _GNSS_UTC_Model_utcModel2 = SEQ(name=u'utcModel2', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'UTC-ModelSet2')))
    _GNSS_UTC_Model_utcModel3 = SEQ(name=u'utcModel3', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'UTC-ModelSet3')))
    _GNSS_UTC_Model_utcModel4 = SEQ(name=u'utcModel4', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'UTC-ModelSet4')))
    _GNSS_UTC_Model_utcModel5_r12 = SEQ(name=u'utcModel5-r12', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'UTC-ModelSet5-r12')))
    GNSS_UTC_Model._cont = ASN1Dict([
        (u'utcModel1', _GNSS_UTC_Model_utcModel1),
        (u'utcModel2', _GNSS_UTC_Model_utcModel2),
        (u'utcModel3', _GNSS_UTC_Model_utcModel3),
        (u'utcModel4', _GNSS_UTC_Model_utcModel4),
        (u'utcModel5-r12', _GNSS_UTC_Model_utcModel5_r12),
        ])
    GNSS_UTC_Model._ext = [u'utcModel5-r12']
    
    #-----< UTC-ModelSet1 >-----#
    UTC_ModelSet1 = SEQ(name=u'UTC-ModelSet1', mode=MODE_TYPE)
    _UTC_ModelSet1_gnss_Utc_A1 = INT(name=u'gnss-Utc-A1', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTC_ModelSet1_gnss_Utc_A1._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-8388608, ub=8388607)], ev=None, er=[])
    _UTC_ModelSet1_gnss_Utc_A0 = INT(name=u'gnss-Utc-A0', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTC_ModelSet1_gnss_Utc_A0._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-2147483648, ub=2147483647)], ev=None, er=[])
    _UTC_ModelSet1_gnss_Utc_Tot = INT(name=u'gnss-Utc-Tot', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTC_ModelSet1_gnss_Utc_Tot._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _UTC_ModelSet1_gnss_Utc_WNt = INT(name=u'gnss-Utc-WNt', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTC_ModelSet1_gnss_Utc_WNt._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _UTC_ModelSet1_gnss_Utc_DeltaTls = INT(name=u'gnss-Utc-DeltaTls', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTC_ModelSet1_gnss_Utc_DeltaTls._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-128, ub=127)], ev=None, er=[])
    _UTC_ModelSet1_gnss_Utc_WNlsf = INT(name=u'gnss-Utc-WNlsf', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTC_ModelSet1_gnss_Utc_WNlsf._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _UTC_ModelSet1_gnss_Utc_DN = INT(name=u'gnss-Utc-DN', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTC_ModelSet1_gnss_Utc_DN._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-128, ub=127)], ev=None, er=[])
    _UTC_ModelSet1_gnss_Utc_DeltaTlsf = INT(name=u'gnss-Utc-DeltaTlsf', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTC_ModelSet1_gnss_Utc_DeltaTlsf._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-128, ub=127)], ev=None, er=[])
    UTC_ModelSet1._cont = ASN1Dict([
        (u'gnss-Utc-A1', _UTC_ModelSet1_gnss_Utc_A1),
        (u'gnss-Utc-A0', _UTC_ModelSet1_gnss_Utc_A0),
        (u'gnss-Utc-Tot', _UTC_ModelSet1_gnss_Utc_Tot),
        (u'gnss-Utc-WNt', _UTC_ModelSet1_gnss_Utc_WNt),
        (u'gnss-Utc-DeltaTls', _UTC_ModelSet1_gnss_Utc_DeltaTls),
        (u'gnss-Utc-WNlsf', _UTC_ModelSet1_gnss_Utc_WNlsf),
        (u'gnss-Utc-DN', _UTC_ModelSet1_gnss_Utc_DN),
        (u'gnss-Utc-DeltaTlsf', _UTC_ModelSet1_gnss_Utc_DeltaTlsf),
        ])
    UTC_ModelSet1._ext = []
    
    #-----< UTC-ModelSet2 >-----#
    UTC_ModelSet2 = SEQ(name=u'UTC-ModelSet2', mode=MODE_TYPE)
    _UTC_ModelSet2_utcA0 = INT(name=u'utcA0', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTC_ModelSet2_utcA0._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-32768, ub=32767)], ev=None, er=[])
    _UTC_ModelSet2_utcA1 = INT(name=u'utcA1', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTC_ModelSet2_utcA1._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-4096, ub=4095)], ev=None, er=[])
    _UTC_ModelSet2_utcA2 = INT(name=u'utcA2', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTC_ModelSet2_utcA2._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-64, ub=63)], ev=None, er=[])
    _UTC_ModelSet2_utcDeltaTls = INT(name=u'utcDeltaTls', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTC_ModelSet2_utcDeltaTls._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-128, ub=127)], ev=None, er=[])
    _UTC_ModelSet2_utcTot = INT(name=u'utcTot', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTC_ModelSet2_utcTot._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    _UTC_ModelSet2_utcWNot = INT(name=u'utcWNot', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTC_ModelSet2_utcWNot._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=8191)], ev=None, er=[])
    _UTC_ModelSet2_utcWNlsf = INT(name=u'utcWNlsf', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTC_ModelSet2_utcWNlsf._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _UTC_ModelSet2_utcDN = BIT_STR(name=u'utcDN', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTC_ModelSet2_utcDN._const_sz = ASN1Set(rv=[4], rr=[], ev=None, er=[])
    _UTC_ModelSet2_utcDeltaTlsf = INT(name=u'utcDeltaTlsf', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTC_ModelSet2_utcDeltaTlsf._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-128, ub=127)], ev=None, er=[])
    UTC_ModelSet2._cont = ASN1Dict([
        (u'utcA0', _UTC_ModelSet2_utcA0),
        (u'utcA1', _UTC_ModelSet2_utcA1),
        (u'utcA2', _UTC_ModelSet2_utcA2),
        (u'utcDeltaTls', _UTC_ModelSet2_utcDeltaTls),
        (u'utcTot', _UTC_ModelSet2_utcTot),
        (u'utcWNot', _UTC_ModelSet2_utcWNot),
        (u'utcWNlsf', _UTC_ModelSet2_utcWNlsf),
        (u'utcDN', _UTC_ModelSet2_utcDN),
        (u'utcDeltaTlsf', _UTC_ModelSet2_utcDeltaTlsf),
        ])
    UTC_ModelSet2._ext = []
    
    #-----< UTC-ModelSet3 >-----#
    UTC_ModelSet3 = SEQ(name=u'UTC-ModelSet3', mode=MODE_TYPE)
    _UTC_ModelSet3_nA = INT(name=u'nA', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTC_ModelSet3_nA._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=1461)], ev=None, er=[])
    _UTC_ModelSet3_tauC = INT(name=u'tauC', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTC_ModelSet3_tauC._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-2147483648, ub=2147483647)], ev=None, er=[])
    _UTC_ModelSet3_b1 = INT(name=u'b1', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _UTC_ModelSet3_b1._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-1024, ub=1023)], ev=None, er=[])
    _UTC_ModelSet3_b2 = INT(name=u'b2', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _UTC_ModelSet3_b2._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-512, ub=511)], ev=None, er=[])
    _UTC_ModelSet3_kp = BIT_STR(name=u'kp', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _UTC_ModelSet3_kp._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    UTC_ModelSet3._cont = ASN1Dict([
        (u'nA', _UTC_ModelSet3_nA),
        (u'tauC', _UTC_ModelSet3_tauC),
        (u'b1', _UTC_ModelSet3_b1),
        (u'b2', _UTC_ModelSet3_b2),
        (u'kp', _UTC_ModelSet3_kp),
        ])
    UTC_ModelSet3._ext = []
    
    #-----< UTC-ModelSet4 >-----#
    UTC_ModelSet4 = SEQ(name=u'UTC-ModelSet4', mode=MODE_TYPE)
    _UTC_ModelSet4_utcA1wnt = INT(name=u'utcA1wnt', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTC_ModelSet4_utcA1wnt._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-8388608, ub=8388607)], ev=None, er=[])
    _UTC_ModelSet4_utcA0wnt = INT(name=u'utcA0wnt', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTC_ModelSet4_utcA0wnt._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-2147483648, ub=2147483647)], ev=None, er=[])
    _UTC_ModelSet4_utcTot = INT(name=u'utcTot', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTC_ModelSet4_utcTot._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _UTC_ModelSet4_utcWNt = INT(name=u'utcWNt', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTC_ModelSet4_utcWNt._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _UTC_ModelSet4_utcDeltaTls = INT(name=u'utcDeltaTls', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTC_ModelSet4_utcDeltaTls._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-128, ub=127)], ev=None, er=[])
    _UTC_ModelSet4_utcWNlsf = INT(name=u'utcWNlsf', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTC_ModelSet4_utcWNlsf._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _UTC_ModelSet4_utcDN = INT(name=u'utcDN', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTC_ModelSet4_utcDN._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-128, ub=127)], ev=None, er=[])
    _UTC_ModelSet4_utcDeltaTlsf = INT(name=u'utcDeltaTlsf', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTC_ModelSet4_utcDeltaTlsf._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-128, ub=127)], ev=None, er=[])
    _UTC_ModelSet4_utcStandardID = INT(name=u'utcStandardID', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTC_ModelSet4_utcStandardID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=7)], ev=None, er=[])
    UTC_ModelSet4._cont = ASN1Dict([
        (u'utcA1wnt', _UTC_ModelSet4_utcA1wnt),
        (u'utcA0wnt', _UTC_ModelSet4_utcA0wnt),
        (u'utcTot', _UTC_ModelSet4_utcTot),
        (u'utcWNt', _UTC_ModelSet4_utcWNt),
        (u'utcDeltaTls', _UTC_ModelSet4_utcDeltaTls),
        (u'utcWNlsf', _UTC_ModelSet4_utcWNlsf),
        (u'utcDN', _UTC_ModelSet4_utcDN),
        (u'utcDeltaTlsf', _UTC_ModelSet4_utcDeltaTlsf),
        (u'utcStandardID', _UTC_ModelSet4_utcStandardID),
        ])
    UTC_ModelSet4._ext = []
    
    #-----< UTC-ModelSet5-r12 >-----#
    UTC_ModelSet5_r12 = SEQ(name=u'UTC-ModelSet5-r12', mode=MODE_TYPE)
    _UTC_ModelSet5_r12_utcA0_r12 = INT(name=u'utcA0-r12', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTC_ModelSet5_r12_utcA0_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-2147483648, ub=2147483647)], ev=None, er=[])
    _UTC_ModelSet5_r12_utcA1_r12 = INT(name=u'utcA1-r12', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTC_ModelSet5_r12_utcA1_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-8388608, ub=8388607)], ev=None, er=[])
    _UTC_ModelSet5_r12_utcDeltaTls_r12 = INT(name=u'utcDeltaTls-r12', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTC_ModelSet5_r12_utcDeltaTls_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-128, ub=127)], ev=None, er=[])
    _UTC_ModelSet5_r12_utcWNlsf_r12 = INT(name=u'utcWNlsf-r12', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTC_ModelSet5_r12_utcWNlsf_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _UTC_ModelSet5_r12_utcDN_r12 = INT(name=u'utcDN-r12', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTC_ModelSet5_r12_utcDN_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _UTC_ModelSet5_r12_utcDeltaTlsf_r12 = INT(name=u'utcDeltaTlsf-r12', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTC_ModelSet5_r12_utcDeltaTlsf_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-128, ub=127)], ev=None, er=[])
    UTC_ModelSet5_r12._cont = ASN1Dict([
        (u'utcA0-r12', _UTC_ModelSet5_r12_utcA0_r12),
        (u'utcA1-r12', _UTC_ModelSet5_r12_utcA1_r12),
        (u'utcDeltaTls-r12', _UTC_ModelSet5_r12_utcDeltaTls_r12),
        (u'utcWNlsf-r12', _UTC_ModelSet5_r12_utcWNlsf_r12),
        (u'utcDN-r12', _UTC_ModelSet5_r12_utcDN_r12),
        (u'utcDeltaTlsf-r12', _UTC_ModelSet5_r12_utcDeltaTlsf_r12),
        ])
    UTC_ModelSet5_r12._ext = []
    
    #-----< GNSS-AuxiliaryInformation >-----#
    GNSS_AuxiliaryInformation = CHOICE(name=u'GNSS-AuxiliaryInformation', mode=MODE_TYPE)
    _GNSS_AuxiliaryInformation_gnss_ID_GPS = SEQ_OF(name=u'gnss-ID-GPS', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-ID-GPS')))
    _GNSS_AuxiliaryInformation_gnss_ID_GLONASS = SEQ_OF(name=u'gnss-ID-GLONASS', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-ID-GLONASS')))
    GNSS_AuxiliaryInformation._cont = ASN1Dict([
        (u'gnss-ID-GPS', _GNSS_AuxiliaryInformation_gnss_ID_GPS),
        (u'gnss-ID-GLONASS', _GNSS_AuxiliaryInformation_gnss_ID_GLONASS),
        ])
    GNSS_AuxiliaryInformation._ext = []
    
    #-----< GNSS-ID-GPS >-----#
    GNSS_ID_GPS = SEQ_OF(name=u'GNSS-ID-GPS', mode=MODE_TYPE)
    _GNSS_ID_GPS__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-ID-GPS-SatElement')))
    GNSS_ID_GPS._cont = _GNSS_ID_GPS__item_
    GNSS_ID_GPS._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    
    #-----< GNSS-ID-GPS-SatElement >-----#
    GNSS_ID_GPS_SatElement = SEQ(name=u'GNSS-ID-GPS-SatElement', mode=MODE_TYPE)
    _GNSS_ID_GPS_SatElement_svID = SEQ(name=u'svID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'SV-ID')))
    _GNSS_ID_GPS_SatElement_signalsAvailable = SEQ(name=u'signalsAvailable', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-SignalIDs')))
    GNSS_ID_GPS_SatElement._cont = ASN1Dict([
        (u'svID', _GNSS_ID_GPS_SatElement_svID),
        (u'signalsAvailable', _GNSS_ID_GPS_SatElement_signalsAvailable),
        ])
    GNSS_ID_GPS_SatElement._ext = []
    
    #-----< GNSS-ID-GLONASS >-----#
    GNSS_ID_GLONASS = SEQ_OF(name=u'GNSS-ID-GLONASS', mode=MODE_TYPE)
    _GNSS_ID_GLONASS__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-ID-GLONASS-SatElement')))
    GNSS_ID_GLONASS._cont = _GNSS_ID_GLONASS__item_
    GNSS_ID_GLONASS._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    
    #-----< GNSS-ID-GLONASS-SatElement >-----#
    GNSS_ID_GLONASS_SatElement = SEQ(name=u'GNSS-ID-GLONASS-SatElement', mode=MODE_TYPE)
    _GNSS_ID_GLONASS_SatElement_svID = SEQ(name=u'svID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'SV-ID')))
    _GNSS_ID_GLONASS_SatElement_signalsAvailable = SEQ(name=u'signalsAvailable', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-SignalIDs')))
    _GNSS_ID_GLONASS_SatElement_channelNumber = INT(name=u'channelNumber', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GNSS_ID_GLONASS_SatElement_channelNumber._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-7, ub=13)], ev=None, er=[])
    GNSS_ID_GLONASS_SatElement._cont = ASN1Dict([
        (u'svID', _GNSS_ID_GLONASS_SatElement_svID),
        (u'signalsAvailable', _GNSS_ID_GLONASS_SatElement_signalsAvailable),
        (u'channelNumber', _GNSS_ID_GLONASS_SatElement_channelNumber),
        ])
    GNSS_ID_GLONASS_SatElement._ext = []
    
    #-----< BDS-DifferentialCorrections-r12 >-----#
    BDS_DifferentialCorrections_r12 = SEQ(name=u'BDS-DifferentialCorrections-r12', mode=MODE_TYPE)
    _BDS_DifferentialCorrections_r12_dbds_RefTime_r12 = INT(name=u'dbds-RefTime-r12', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _BDS_DifferentialCorrections_r12_dbds_RefTime_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=3599)], ev=None, er=[])
    _BDS_DifferentialCorrections_r12_bds_SgnTypeList_r12 = SEQ_OF(name=u'bds-SgnTypeList-r12', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'BDS-SgnTypeList-r12')))
    BDS_DifferentialCorrections_r12._cont = ASN1Dict([
        (u'dbds-RefTime-r12', _BDS_DifferentialCorrections_r12_dbds_RefTime_r12),
        (u'bds-SgnTypeList-r12', _BDS_DifferentialCorrections_r12_bds_SgnTypeList_r12),
        ])
    BDS_DifferentialCorrections_r12._ext = []
    
    #-----< BDS-SgnTypeList-r12 >-----#
    BDS_SgnTypeList_r12 = SEQ_OF(name=u'BDS-SgnTypeList-r12', mode=MODE_TYPE)
    _BDS_SgnTypeList_r12__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('LPP-PDU-Definitions', 'BDS-SgnTypeElement-r12')))
    BDS_SgnTypeList_r12._cont = _BDS_SgnTypeList_r12__item_
    BDS_SgnTypeList_r12._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=3)], ev=None, er=[])
    
    #-----< BDS-SgnTypeElement-r12 >-----#
    BDS_SgnTypeElement_r12 = SEQ(name=u'BDS-SgnTypeElement-r12', mode=MODE_TYPE)
    _BDS_SgnTypeElement_r12_gnss_SignalID = SEQ(name=u'gnss-SignalID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-SignalID')), opt=True)
    _BDS_SgnTypeElement_r12_dbds_CorrectionList_r12 = SEQ_OF(name=u'dbds-CorrectionList-r12', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'DBDS-CorrectionList-r12')))
    BDS_SgnTypeElement_r12._cont = ASN1Dict([
        (u'gnss-SignalID', _BDS_SgnTypeElement_r12_gnss_SignalID),
        (u'dbds-CorrectionList-r12', _BDS_SgnTypeElement_r12_dbds_CorrectionList_r12),
        ])
    BDS_SgnTypeElement_r12._ext = []
    
    #-----< DBDS-CorrectionList-r12 >-----#
    DBDS_CorrectionList_r12 = SEQ_OF(name=u'DBDS-CorrectionList-r12', mode=MODE_TYPE)
    _DBDS_CorrectionList_r12__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('LPP-PDU-Definitions', 'DBDS-CorrectionElement-r12')))
    DBDS_CorrectionList_r12._cont = _DBDS_CorrectionList_r12__item_
    DBDS_CorrectionList_r12._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    
    #-----< DBDS-CorrectionElement-r12 >-----#
    DBDS_CorrectionElement_r12 = SEQ(name=u'DBDS-CorrectionElement-r12', mode=MODE_TYPE)
    _DBDS_CorrectionElement_r12_svID = SEQ(name=u'svID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'SV-ID')))
    _DBDS_CorrectionElement_r12_bds_UDREI_r12 = INT(name=u'bds-UDREI-r12', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _DBDS_CorrectionElement_r12_bds_UDREI_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=15)], ev=None, er=[])
    _DBDS_CorrectionElement_r12_bds_RURAI_r12 = INT(name=u'bds-RURAI-r12', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _DBDS_CorrectionElement_r12_bds_RURAI_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=15)], ev=None, er=[])
    _DBDS_CorrectionElement_r12_bds_ECC_DeltaT_r12 = INT(name=u'bds-ECC-DeltaT-r12', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _DBDS_CorrectionElement_r12_bds_ECC_DeltaT_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-4096, ub=4095)], ev=None, er=[])
    DBDS_CorrectionElement_r12._cont = ASN1Dict([
        (u'svID', _DBDS_CorrectionElement_r12_svID),
        (u'bds-UDREI-r12', _DBDS_CorrectionElement_r12_bds_UDREI_r12),
        (u'bds-RURAI-r12', _DBDS_CorrectionElement_r12_bds_RURAI_r12),
        (u'bds-ECC-DeltaT-r12', _DBDS_CorrectionElement_r12_bds_ECC_DeltaT_r12),
        ])
    DBDS_CorrectionElement_r12._ext = []
    
    #-----< BDS-GridModelParameter-r12 >-----#
    BDS_GridModelParameter_r12 = SEQ(name=u'BDS-GridModelParameter-r12', mode=MODE_TYPE)
    _BDS_GridModelParameter_r12_bds_RefTime_r12 = INT(name=u'bds-RefTime-r12', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _BDS_GridModelParameter_r12_bds_RefTime_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=3599)], ev=None, er=[])
    _BDS_GridModelParameter_r12_gridIonList_r12 = SEQ_OF(name=u'gridIonList-r12', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GridIonList-r12')))
    BDS_GridModelParameter_r12._cont = ASN1Dict([
        (u'bds-RefTime-r12', _BDS_GridModelParameter_r12_bds_RefTime_r12),
        (u'gridIonList-r12', _BDS_GridModelParameter_r12_gridIonList_r12),
        ])
    BDS_GridModelParameter_r12._ext = []
    
    #-----< GridIonList-r12 >-----#
    GridIonList_r12 = SEQ_OF(name=u'GridIonList-r12', mode=MODE_TYPE)
    _GridIonList_r12__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('LPP-PDU-Definitions', 'GridIonElement-r12')))
    GridIonList_r12._cont = _GridIonList_r12__item_
    GridIonList_r12._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=320)], ev=None, er=[])
    
    #-----< GridIonElement-r12 >-----#
    GridIonElement_r12 = SEQ(name=u'GridIonElement-r12', mode=MODE_TYPE)
    _GridIonElement_r12_igp_ID_r12 = INT(name=u'igp-ID-r12', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GridIonElement_r12_igp_ID_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=320)], ev=None, er=[])
    _GridIonElement_r12_dt_r12 = INT(name=u'dt-r12', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GridIonElement_r12_dt_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=511)], ev=None, er=[])
    _GridIonElement_r12_givei_r12 = INT(name=u'givei-r12', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GridIonElement_r12_givei_r12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=15)], ev=None, er=[])
    GridIonElement_r12._cont = ASN1Dict([
        (u'igp-ID-r12', _GridIonElement_r12_igp_ID_r12),
        (u'dt-r12', _GridIonElement_r12_dt_r12),
        (u'givei-r12', _GridIonElement_r12_givei_r12),
        ])
    GridIonElement_r12._ext = []
    
    #-----< A-GNSS-RequestAssistanceData >-----#
    A_GNSS_RequestAssistanceData = SEQ(name=u'A-GNSS-RequestAssistanceData', mode=MODE_TYPE)
    _A_GNSS_RequestAssistanceData_gnss_CommonAssistDataReq = SEQ(name=u'gnss-CommonAssistDataReq', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-CommonAssistDataReq')), opt=True)
    _A_GNSS_RequestAssistanceData_gnss_GenericAssistDataReq = SEQ_OF(name=u'gnss-GenericAssistDataReq', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-GenericAssistDataReq')), opt=True)
    A_GNSS_RequestAssistanceData._cont = ASN1Dict([
        (u'gnss-CommonAssistDataReq', _A_GNSS_RequestAssistanceData_gnss_CommonAssistDataReq),
        (u'gnss-GenericAssistDataReq', _A_GNSS_RequestAssistanceData_gnss_GenericAssistDataReq),
        ])
    A_GNSS_RequestAssistanceData._ext = []
    
    #-----< GNSS-CommonAssistDataReq >-----#
    GNSS_CommonAssistDataReq = SEQ(name=u'GNSS-CommonAssistDataReq', mode=MODE_TYPE)
    _GNSS_CommonAssistDataReq_gnss_ReferenceTimeReq = SEQ(name=u'gnss-ReferenceTimeReq', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-ReferenceTimeReq')), opt=True)
    _GNSS_CommonAssistDataReq_gnss_ReferenceLocationReq = SEQ(name=u'gnss-ReferenceLocationReq', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-ReferenceLocationReq')), opt=True)
    _GNSS_CommonAssistDataReq_gnss_IonosphericModelReq = SEQ(name=u'gnss-IonosphericModelReq', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-IonosphericModelReq')), opt=True)
    _GNSS_CommonAssistDataReq_gnss_EarthOrientationParametersReq = SEQ(name=u'gnss-EarthOrientationParametersReq', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-EarthOrientationParametersReq')), opt=True)
    GNSS_CommonAssistDataReq._cont = ASN1Dict([
        (u'gnss-ReferenceTimeReq', _GNSS_CommonAssistDataReq_gnss_ReferenceTimeReq),
        (u'gnss-ReferenceLocationReq', _GNSS_CommonAssistDataReq_gnss_ReferenceLocationReq),
        (u'gnss-IonosphericModelReq', _GNSS_CommonAssistDataReq_gnss_IonosphericModelReq),
        (u'gnss-EarthOrientationParametersReq', _GNSS_CommonAssistDataReq_gnss_EarthOrientationParametersReq),
        ])
    GNSS_CommonAssistDataReq._ext = []
    
    #-----< GNSS-GenericAssistDataReq >-----#
    GNSS_GenericAssistDataReq = SEQ_OF(name=u'GNSS-GenericAssistDataReq', mode=MODE_TYPE)
    _GNSS_GenericAssistDataReq__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-GenericAssistDataReqElement')))
    GNSS_GenericAssistDataReq._cont = _GNSS_GenericAssistDataReq__item_
    GNSS_GenericAssistDataReq._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    
    #-----< GNSS-GenericAssistDataReqElement >-----#
    GNSS_GenericAssistDataReqElement = SEQ(name=u'GNSS-GenericAssistDataReqElement', mode=MODE_TYPE)
    _GNSS_GenericAssistDataReqElement_gnss_ID = SEQ(name=u'gnss-ID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-ID')))
    _GNSS_GenericAssistDataReqElement_sbas_ID = SEQ(name=u'sbas-ID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'SBAS-ID')), opt=True)
    _GNSS_GenericAssistDataReqElement_gnss_TimeModelsReq = SEQ_OF(name=u'gnss-TimeModelsReq', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-TimeModelListReq')), opt=True)
    _GNSS_GenericAssistDataReqElement_gnss_DifferentialCorrectionsReq = SEQ(name=u'gnss-DifferentialCorrectionsReq', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-DifferentialCorrectionsReq')), opt=True)
    _GNSS_GenericAssistDataReqElement_gnss_NavigationModelReq = CHOICE(name=u'gnss-NavigationModelReq', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-NavigationModelReq')), opt=True)
    _GNSS_GenericAssistDataReqElement_gnss_RealTimeIntegrityReq = SEQ(name=u'gnss-RealTimeIntegrityReq', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-RealTimeIntegrityReq')), opt=True)
    _GNSS_GenericAssistDataReqElement_gnss_DataBitAssistanceReq = SEQ(name=u'gnss-DataBitAssistanceReq', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-DataBitAssistanceReq')), opt=True)
    _GNSS_GenericAssistDataReqElement_gnss_AcquisitionAssistanceReq = SEQ(name=u'gnss-AcquisitionAssistanceReq', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-AcquisitionAssistanceReq')), opt=True)
    _GNSS_GenericAssistDataReqElement_gnss_AlmanacReq = SEQ(name=u'gnss-AlmanacReq', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-AlmanacReq')), opt=True)
    _GNSS_GenericAssistDataReqElement_gnss_UTCModelReq = SEQ(name=u'gnss-UTCModelReq', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-UTC-ModelReq')), opt=True)
    _GNSS_GenericAssistDataReqElement_gnss_AuxiliaryInformationReq = SEQ(name=u'gnss-AuxiliaryInformationReq', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-AuxiliaryInformationReq')), opt=True)
    _GNSS_GenericAssistDataReqElement_bds_DifferentialCorrectionsReq_r12 = SEQ(name=u'bds-DifferentialCorrectionsReq-r12', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'BDS-DifferentialCorrectionsReq-r12')), opt=True, group=0)
    _GNSS_GenericAssistDataReqElement_bds_GridModelReq_r12 = SEQ(name=u'bds-GridModelReq-r12', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'BDS-GridModelReq-r12')), opt=True, group=0)
    GNSS_GenericAssistDataReqElement._cont = ASN1Dict([
        (u'gnss-ID', _GNSS_GenericAssistDataReqElement_gnss_ID),
        (u'sbas-ID', _GNSS_GenericAssistDataReqElement_sbas_ID),
        (u'gnss-TimeModelsReq', _GNSS_GenericAssistDataReqElement_gnss_TimeModelsReq),
        (u'gnss-DifferentialCorrectionsReq', _GNSS_GenericAssistDataReqElement_gnss_DifferentialCorrectionsReq),
        (u'gnss-NavigationModelReq', _GNSS_GenericAssistDataReqElement_gnss_NavigationModelReq),
        (u'gnss-RealTimeIntegrityReq', _GNSS_GenericAssistDataReqElement_gnss_RealTimeIntegrityReq),
        (u'gnss-DataBitAssistanceReq', _GNSS_GenericAssistDataReqElement_gnss_DataBitAssistanceReq),
        (u'gnss-AcquisitionAssistanceReq', _GNSS_GenericAssistDataReqElement_gnss_AcquisitionAssistanceReq),
        (u'gnss-AlmanacReq', _GNSS_GenericAssistDataReqElement_gnss_AlmanacReq),
        (u'gnss-UTCModelReq', _GNSS_GenericAssistDataReqElement_gnss_UTCModelReq),
        (u'gnss-AuxiliaryInformationReq', _GNSS_GenericAssistDataReqElement_gnss_AuxiliaryInformationReq),
        (u'bds-DifferentialCorrectionsReq-r12', _GNSS_GenericAssistDataReqElement_bds_DifferentialCorrectionsReq_r12),
        (u'bds-GridModelReq-r12', _GNSS_GenericAssistDataReqElement_bds_GridModelReq_r12),
        ])
    GNSS_GenericAssistDataReqElement._ext = [u'bds-DifferentialCorrectionsReq-r12', u'bds-GridModelReq-r12']
    
    #-----< GNSS-ReferenceTimeReq >-----#
    GNSS_ReferenceTimeReq = SEQ(name=u'GNSS-ReferenceTimeReq', mode=MODE_TYPE)
    _GNSS_ReferenceTimeReq_gnss_TimeReqPrefList = SEQ_OF(name=u'gnss-TimeReqPrefList', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __GNSS_ReferenceTimeReq_gnss_TimeReqPrefList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-ID')))
    _GNSS_ReferenceTimeReq_gnss_TimeReqPrefList._cont = __GNSS_ReferenceTimeReq_gnss_TimeReqPrefList__item_
    _GNSS_ReferenceTimeReq_gnss_TimeReqPrefList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    _GNSS_ReferenceTimeReq_gps_TOW_assistReq = BOOL(name=u'gps-TOW-assistReq', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GNSS_ReferenceTimeReq_notOfLeapSecReq = BOOL(name=u'notOfLeapSecReq', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    GNSS_ReferenceTimeReq._cont = ASN1Dict([
        (u'gnss-TimeReqPrefList', _GNSS_ReferenceTimeReq_gnss_TimeReqPrefList),
        (u'gps-TOW-assistReq', _GNSS_ReferenceTimeReq_gps_TOW_assistReq),
        (u'notOfLeapSecReq', _GNSS_ReferenceTimeReq_notOfLeapSecReq),
        ])
    GNSS_ReferenceTimeReq._ext = []
    
    #-----< GNSS-ReferenceLocationReq >-----#
    GNSS_ReferenceLocationReq = SEQ(name=u'GNSS-ReferenceLocationReq', mode=MODE_TYPE)
    GNSS_ReferenceLocationReq._cont = ASN1Dict([
        ])
    GNSS_ReferenceLocationReq._ext = []
    
    #-----< GNSS-IonosphericModelReq >-----#
    GNSS_IonosphericModelReq = SEQ(name=u'GNSS-IonosphericModelReq', mode=MODE_TYPE)
    _GNSS_IonosphericModelReq_klobucharModelReq = BIT_STR(name=u'klobucharModelReq', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GNSS_IonosphericModelReq_klobucharModelReq._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    _GNSS_IonosphericModelReq_neQuickModelReq = NULL(name=u'neQuickModelReq', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    GNSS_IonosphericModelReq._cont = ASN1Dict([
        (u'klobucharModelReq', _GNSS_IonosphericModelReq_klobucharModelReq),
        (u'neQuickModelReq', _GNSS_IonosphericModelReq_neQuickModelReq),
        ])
    GNSS_IonosphericModelReq._ext = []
    
    #-----< GNSS-EarthOrientationParametersReq >-----#
    GNSS_EarthOrientationParametersReq = SEQ(name=u'GNSS-EarthOrientationParametersReq', mode=MODE_TYPE)
    GNSS_EarthOrientationParametersReq._cont = ASN1Dict([
        ])
    GNSS_EarthOrientationParametersReq._ext = []
    
    #-----< GNSS-TimeModelListReq >-----#
    GNSS_TimeModelListReq = SEQ_OF(name=u'GNSS-TimeModelListReq', mode=MODE_TYPE)
    _GNSS_TimeModelListReq__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-TimeModelElementReq')))
    GNSS_TimeModelListReq._cont = _GNSS_TimeModelListReq__item_
    GNSS_TimeModelListReq._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=15)], ev=None, er=[])
    
    #-----< GNSS-TimeModelElementReq >-----#
    GNSS_TimeModelElementReq = SEQ(name=u'GNSS-TimeModelElementReq', mode=MODE_TYPE)
    _GNSS_TimeModelElementReq_gnss_TO_IDsReq = INT(name=u'gnss-TO-IDsReq', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GNSS_TimeModelElementReq_gnss_TO_IDsReq._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=15)], ev=None, er=[])
    _GNSS_TimeModelElementReq_deltaTreq = BOOL(name=u'deltaTreq', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    GNSS_TimeModelElementReq._cont = ASN1Dict([
        (u'gnss-TO-IDsReq', _GNSS_TimeModelElementReq_gnss_TO_IDsReq),
        (u'deltaTreq', _GNSS_TimeModelElementReq_deltaTreq),
        ])
    GNSS_TimeModelElementReq._ext = []
    
    #-----< GNSS-DifferentialCorrectionsReq >-----#
    GNSS_DifferentialCorrectionsReq = SEQ(name=u'GNSS-DifferentialCorrectionsReq', mode=MODE_TYPE)
    _GNSS_DifferentialCorrectionsReq_dgnss_SignalsReq = SEQ(name=u'dgnss-SignalsReq', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-SignalIDs')))
    _GNSS_DifferentialCorrectionsReq_dgnss_ValidityTimeReq = BOOL(name=u'dgnss-ValidityTimeReq', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    GNSS_DifferentialCorrectionsReq._cont = ASN1Dict([
        (u'dgnss-SignalsReq', _GNSS_DifferentialCorrectionsReq_dgnss_SignalsReq),
        (u'dgnss-ValidityTimeReq', _GNSS_DifferentialCorrectionsReq_dgnss_ValidityTimeReq),
        ])
    GNSS_DifferentialCorrectionsReq._ext = []
    
    #-----< GNSS-NavigationModelReq >-----#
    GNSS_NavigationModelReq = CHOICE(name=u'GNSS-NavigationModelReq', mode=MODE_TYPE)
    _GNSS_NavigationModelReq_storedNavList = SEQ(name=u'storedNavList', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'StoredNavListInfo')))
    _GNSS_NavigationModelReq_reqNavList = SEQ(name=u'reqNavList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'ReqNavListInfo')))
    GNSS_NavigationModelReq._cont = ASN1Dict([
        (u'storedNavList', _GNSS_NavigationModelReq_storedNavList),
        (u'reqNavList', _GNSS_NavigationModelReq_reqNavList),
        ])
    GNSS_NavigationModelReq._ext = []
    
    #-----< StoredNavListInfo >-----#
    StoredNavListInfo = SEQ(name=u'StoredNavListInfo', mode=MODE_TYPE)
    _StoredNavListInfo_gnss_WeekOrDay = INT(name=u'gnss-WeekOrDay', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _StoredNavListInfo_gnss_WeekOrDay._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4095)], ev=None, er=[])
    _StoredNavListInfo_gnss_Toe = INT(name=u'gnss-Toe', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _StoredNavListInfo_gnss_Toe._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _StoredNavListInfo_t_toeLimit = INT(name=u't-toeLimit', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _StoredNavListInfo_t_toeLimit._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=15)], ev=None, er=[])
    _StoredNavListInfo_satListRelatedDataList = SEQ_OF(name=u'satListRelatedDataList', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'SatListRelatedDataList')), opt=True)
    StoredNavListInfo._cont = ASN1Dict([
        (u'gnss-WeekOrDay', _StoredNavListInfo_gnss_WeekOrDay),
        (u'gnss-Toe', _StoredNavListInfo_gnss_Toe),
        (u't-toeLimit', _StoredNavListInfo_t_toeLimit),
        (u'satListRelatedDataList', _StoredNavListInfo_satListRelatedDataList),
        ])
    StoredNavListInfo._ext = []
    
    #-----< SatListRelatedDataList >-----#
    SatListRelatedDataList = SEQ_OF(name=u'SatListRelatedDataList', mode=MODE_TYPE)
    _SatListRelatedDataList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('LPP-PDU-Definitions', 'SatListRelatedDataElement')))
    SatListRelatedDataList._cont = _SatListRelatedDataList__item_
    SatListRelatedDataList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    
    #-----< SatListRelatedDataElement >-----#
    SatListRelatedDataElement = SEQ(name=u'SatListRelatedDataElement', mode=MODE_TYPE)
    _SatListRelatedDataElement_svID = SEQ(name=u'svID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'SV-ID')))
    _SatListRelatedDataElement_iod = BIT_STR(name=u'iod', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _SatListRelatedDataElement_iod._const_sz = ASN1Set(rv=[11], rr=[], ev=None, er=[])
    _SatListRelatedDataElement_clockModelID = INT(name=u'clockModelID', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _SatListRelatedDataElement_clockModelID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    _SatListRelatedDataElement_orbitModelID = INT(name=u'orbitModelID', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _SatListRelatedDataElement_orbitModelID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    SatListRelatedDataElement._cont = ASN1Dict([
        (u'svID', _SatListRelatedDataElement_svID),
        (u'iod', _SatListRelatedDataElement_iod),
        (u'clockModelID', _SatListRelatedDataElement_clockModelID),
        (u'orbitModelID', _SatListRelatedDataElement_orbitModelID),
        ])
    SatListRelatedDataElement._ext = []
    
    #-----< ReqNavListInfo >-----#
    ReqNavListInfo = SEQ(name=u'ReqNavListInfo', mode=MODE_TYPE)
    _ReqNavListInfo_svReqList = BIT_STR(name=u'svReqList', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ReqNavListInfo_svReqList._const_sz = ASN1Set(rv=[64], rr=[], ev=None, er=[])
    _ReqNavListInfo_clockModelID_PrefList = SEQ_OF(name=u'clockModelID-PrefList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __ReqNavListInfo_clockModelID_PrefList__item_ = INT(name='_item_', mode=MODE_TYPE)
    __ReqNavListInfo_clockModelID_PrefList__item_._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    _ReqNavListInfo_clockModelID_PrefList._cont = __ReqNavListInfo_clockModelID_PrefList__item_
    _ReqNavListInfo_clockModelID_PrefList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    _ReqNavListInfo_orbitModelID_PrefList = SEQ_OF(name=u'orbitModelID-PrefList', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __ReqNavListInfo_orbitModelID_PrefList__item_ = INT(name='_item_', mode=MODE_TYPE)
    __ReqNavListInfo_orbitModelID_PrefList__item_._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    _ReqNavListInfo_orbitModelID_PrefList._cont = __ReqNavListInfo_orbitModelID_PrefList__item_
    _ReqNavListInfo_orbitModelID_PrefList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    _ReqNavListInfo_addNavparamReq = BOOL(name=u'addNavparamReq', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    ReqNavListInfo._cont = ASN1Dict([
        (u'svReqList', _ReqNavListInfo_svReqList),
        (u'clockModelID-PrefList', _ReqNavListInfo_clockModelID_PrefList),
        (u'orbitModelID-PrefList', _ReqNavListInfo_orbitModelID_PrefList),
        (u'addNavparamReq', _ReqNavListInfo_addNavparamReq),
        ])
    ReqNavListInfo._ext = []
    
    #-----< GNSS-RealTimeIntegrityReq >-----#
    GNSS_RealTimeIntegrityReq = SEQ(name=u'GNSS-RealTimeIntegrityReq', mode=MODE_TYPE)
    GNSS_RealTimeIntegrityReq._cont = ASN1Dict([
        ])
    GNSS_RealTimeIntegrityReq._ext = []
    
    #-----< GNSS-DataBitAssistanceReq >-----#
    GNSS_DataBitAssistanceReq = SEQ(name=u'GNSS-DataBitAssistanceReq', mode=MODE_TYPE)
    _GNSS_DataBitAssistanceReq_gnss_TOD_Req = INT(name=u'gnss-TOD-Req', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GNSS_DataBitAssistanceReq_gnss_TOD_Req._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=3599)], ev=None, er=[])
    _GNSS_DataBitAssistanceReq_gnss_TOD_FracReq = INT(name=u'gnss-TOD-FracReq', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GNSS_DataBitAssistanceReq_gnss_TOD_FracReq._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=999)], ev=None, er=[])
    _GNSS_DataBitAssistanceReq_dataBitInterval = INT(name=u'dataBitInterval', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GNSS_DataBitAssistanceReq_dataBitInterval._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=15)], ev=None, er=[])
    _GNSS_DataBitAssistanceReq_gnss_SignalType = SEQ(name=u'gnss-SignalType', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-SignalIDs')))
    _GNSS_DataBitAssistanceReq_gnss_DataBitsReq = SEQ_OF(name=u'gnss-DataBitsReq', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-DataBitsReqSatList')), opt=True)
    GNSS_DataBitAssistanceReq._cont = ASN1Dict([
        (u'gnss-TOD-Req', _GNSS_DataBitAssistanceReq_gnss_TOD_Req),
        (u'gnss-TOD-FracReq', _GNSS_DataBitAssistanceReq_gnss_TOD_FracReq),
        (u'dataBitInterval', _GNSS_DataBitAssistanceReq_dataBitInterval),
        (u'gnss-SignalType', _GNSS_DataBitAssistanceReq_gnss_SignalType),
        (u'gnss-DataBitsReq', _GNSS_DataBitAssistanceReq_gnss_DataBitsReq),
        ])
    GNSS_DataBitAssistanceReq._ext = []
    
    #-----< GNSS-DataBitsReqSatList >-----#
    GNSS_DataBitsReqSatList = SEQ_OF(name=u'GNSS-DataBitsReqSatList', mode=MODE_TYPE)
    _GNSS_DataBitsReqSatList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-DataBitsReqSatElement')))
    GNSS_DataBitsReqSatList._cont = _GNSS_DataBitsReqSatList__item_
    GNSS_DataBitsReqSatList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    
    #-----< GNSS-DataBitsReqSatElement >-----#
    GNSS_DataBitsReqSatElement = SEQ(name=u'GNSS-DataBitsReqSatElement', mode=MODE_TYPE)
    _GNSS_DataBitsReqSatElement_svID = SEQ(name=u'svID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'SV-ID')))
    GNSS_DataBitsReqSatElement._cont = ASN1Dict([
        (u'svID', _GNSS_DataBitsReqSatElement_svID),
        ])
    GNSS_DataBitsReqSatElement._ext = []
    
    #-----< GNSS-AcquisitionAssistanceReq >-----#
    GNSS_AcquisitionAssistanceReq = SEQ(name=u'GNSS-AcquisitionAssistanceReq', mode=MODE_TYPE)
    _GNSS_AcquisitionAssistanceReq_gnss_SignalID_Req = SEQ(name=u'gnss-SignalID-Req', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-SignalID')))
    GNSS_AcquisitionAssistanceReq._cont = ASN1Dict([
        (u'gnss-SignalID-Req', _GNSS_AcquisitionAssistanceReq_gnss_SignalID_Req),
        ])
    GNSS_AcquisitionAssistanceReq._ext = []
    
    #-----< GNSS-AlmanacReq >-----#
    GNSS_AlmanacReq = SEQ(name=u'GNSS-AlmanacReq', mode=MODE_TYPE)
    _GNSS_AlmanacReq_modelID = INT(name=u'modelID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GNSS_AlmanacReq_modelID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    GNSS_AlmanacReq._cont = ASN1Dict([
        (u'modelID', _GNSS_AlmanacReq_modelID),
        ])
    GNSS_AlmanacReq._ext = []
    
    #-----< GNSS-UTC-ModelReq >-----#
    GNSS_UTC_ModelReq = SEQ(name=u'GNSS-UTC-ModelReq', mode=MODE_TYPE)
    _GNSS_UTC_ModelReq_modelID = INT(name=u'modelID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GNSS_UTC_ModelReq_modelID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    GNSS_UTC_ModelReq._cont = ASN1Dict([
        (u'modelID', _GNSS_UTC_ModelReq_modelID),
        ])
    GNSS_UTC_ModelReq._ext = []
    
    #-----< GNSS-AuxiliaryInformationReq >-----#
    GNSS_AuxiliaryInformationReq = SEQ(name=u'GNSS-AuxiliaryInformationReq', mode=MODE_TYPE)
    GNSS_AuxiliaryInformationReq._cont = ASN1Dict([
        ])
    GNSS_AuxiliaryInformationReq._ext = []
    
    #-----< BDS-DifferentialCorrectionsReq-r12 >-----#
    BDS_DifferentialCorrectionsReq_r12 = SEQ(name=u'BDS-DifferentialCorrectionsReq-r12', mode=MODE_TYPE)
    _BDS_DifferentialCorrectionsReq_r12_dgnss_SignalsReq = SEQ(name=u'dgnss-SignalsReq', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-SignalIDs')))
    BDS_DifferentialCorrectionsReq_r12._cont = ASN1Dict([
        (u'dgnss-SignalsReq', _BDS_DifferentialCorrectionsReq_r12_dgnss_SignalsReq),
        ])
    BDS_DifferentialCorrectionsReq_r12._ext = []
    
    #-----< BDS-GridModelReq-r12 >-----#
    BDS_GridModelReq_r12 = SEQ(name=u'BDS-GridModelReq-r12', mode=MODE_TYPE)
    BDS_GridModelReq_r12._cont = ASN1Dict([
        ])
    BDS_GridModelReq_r12._ext = []
    
    #-----< A-GNSS-ProvideLocationInformation >-----#
    A_GNSS_ProvideLocationInformation = SEQ(name=u'A-GNSS-ProvideLocationInformation', mode=MODE_TYPE)
    _A_GNSS_ProvideLocationInformation_gnss_SignalMeasurementInformation = SEQ(name=u'gnss-SignalMeasurementInformation', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-SignalMeasurementInformation')), opt=True)
    _A_GNSS_ProvideLocationInformation_gnss_LocationInformation = SEQ(name=u'gnss-LocationInformation', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-LocationInformation')), opt=True)
    _A_GNSS_ProvideLocationInformation_gnss_Error = CHOICE(name=u'gnss-Error', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'A-GNSS-Error')), opt=True)
    A_GNSS_ProvideLocationInformation._cont = ASN1Dict([
        (u'gnss-SignalMeasurementInformation', _A_GNSS_ProvideLocationInformation_gnss_SignalMeasurementInformation),
        (u'gnss-LocationInformation', _A_GNSS_ProvideLocationInformation_gnss_LocationInformation),
        (u'gnss-Error', _A_GNSS_ProvideLocationInformation_gnss_Error),
        ])
    A_GNSS_ProvideLocationInformation._ext = []
    
    #-----< GNSS-SignalMeasurementInformation >-----#
    GNSS_SignalMeasurementInformation = SEQ(name=u'GNSS-SignalMeasurementInformation', mode=MODE_TYPE)
    _GNSS_SignalMeasurementInformation_measurementReferenceTime = SEQ(name=u'measurementReferenceTime', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'MeasurementReferenceTime')))
    _GNSS_SignalMeasurementInformation_gnss_MeasurementList = SEQ_OF(name=u'gnss-MeasurementList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-MeasurementList')))
    GNSS_SignalMeasurementInformation._cont = ASN1Dict([
        (u'measurementReferenceTime', _GNSS_SignalMeasurementInformation_measurementReferenceTime),
        (u'gnss-MeasurementList', _GNSS_SignalMeasurementInformation_gnss_MeasurementList),
        ])
    GNSS_SignalMeasurementInformation._ext = []
    
    #-----< MeasurementReferenceTime >-----#
    MeasurementReferenceTime = SEQ(name=u'MeasurementReferenceTime', mode=MODE_TYPE)
    _MeasurementReferenceTime_gnss_TOD_msec = INT(name=u'gnss-TOD-msec', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MeasurementReferenceTime_gnss_TOD_msec._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=3599999)], ev=None, er=[])
    _MeasurementReferenceTime_gnss_TOD_frac = INT(name=u'gnss-TOD-frac', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MeasurementReferenceTime_gnss_TOD_frac._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=3999)], ev=None, er=[])
    _MeasurementReferenceTime_gnss_TOD_unc = INT(name=u'gnss-TOD-unc', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MeasurementReferenceTime_gnss_TOD_unc._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    _MeasurementReferenceTime_gnss_TimeID = SEQ(name=u'gnss-TimeID', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-ID')))
    _MeasurementReferenceTime_networkTime = CHOICE(name=u'networkTime', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __MeasurementReferenceTime_networkTime_eUTRA = SEQ(name=u'eUTRA', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___MeasurementReferenceTime_networkTime_eUTRA_physCellId = INT(name=u'physCellId', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___MeasurementReferenceTime_networkTime_eUTRA_physCellId._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=503)], ev=None, er=[])
    ___MeasurementReferenceTime_networkTime_eUTRA_cellGlobalId = SEQ(name=u'cellGlobalId', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'CellGlobalIdEUTRA-AndUTRA')), opt=True)
    ___MeasurementReferenceTime_networkTime_eUTRA_systemFrameNumber = BIT_STR(name=u'systemFrameNumber', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___MeasurementReferenceTime_networkTime_eUTRA_systemFrameNumber._const_sz = ASN1Set(rv=[10], rr=[], ev=None, er=[])
    __MeasurementReferenceTime_networkTime_eUTRA._cont = ASN1Dict([
        (u'physCellId', ___MeasurementReferenceTime_networkTime_eUTRA_physCellId),
        (u'cellGlobalId', ___MeasurementReferenceTime_networkTime_eUTRA_cellGlobalId),
        (u'systemFrameNumber', ___MeasurementReferenceTime_networkTime_eUTRA_systemFrameNumber),
        ])
    __MeasurementReferenceTime_networkTime_eUTRA._ext = []
    __MeasurementReferenceTime_networkTime_uTRA = SEQ(name=u'uTRA', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___MeasurementReferenceTime_networkTime_uTRA_mode = CHOICE(name=u'mode', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ____MeasurementReferenceTime_networkTime_uTRA_mode_fdd = SEQ(name=u'fdd', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _____MeasurementReferenceTime_networkTime_uTRA_mode_fdd_primary_CPICH_Info = INT(name=u'primary-CPICH-Info', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _____MeasurementReferenceTime_networkTime_uTRA_mode_fdd_primary_CPICH_Info._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=511)], ev=None, er=[])
    ____MeasurementReferenceTime_networkTime_uTRA_mode_fdd._cont = ASN1Dict([
        (u'primary-CPICH-Info', _____MeasurementReferenceTime_networkTime_uTRA_mode_fdd_primary_CPICH_Info),
        ])
    ____MeasurementReferenceTime_networkTime_uTRA_mode_fdd._ext = []
    ____MeasurementReferenceTime_networkTime_uTRA_mode_tdd = SEQ(name=u'tdd', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _____MeasurementReferenceTime_networkTime_uTRA_mode_tdd_cellParameters = INT(name=u'cellParameters', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _____MeasurementReferenceTime_networkTime_uTRA_mode_tdd_cellParameters._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    ____MeasurementReferenceTime_networkTime_uTRA_mode_tdd._cont = ASN1Dict([
        (u'cellParameters', _____MeasurementReferenceTime_networkTime_uTRA_mode_tdd_cellParameters),
        ])
    ____MeasurementReferenceTime_networkTime_uTRA_mode_tdd._ext = []
    ___MeasurementReferenceTime_networkTime_uTRA_mode._cont = ASN1Dict([
        (u'fdd', ____MeasurementReferenceTime_networkTime_uTRA_mode_fdd),
        (u'tdd', ____MeasurementReferenceTime_networkTime_uTRA_mode_tdd),
        ])
    ___MeasurementReferenceTime_networkTime_uTRA_mode._ext = None
    ___MeasurementReferenceTime_networkTime_uTRA_cellGlobalId = SEQ(name=u'cellGlobalId', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'CellGlobalIdEUTRA-AndUTRA')), opt=True)
    ___MeasurementReferenceTime_networkTime_uTRA_referenceSystemFrameNumber = INT(name=u'referenceSystemFrameNumber', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___MeasurementReferenceTime_networkTime_uTRA_referenceSystemFrameNumber._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4095)], ev=None, er=[])
    __MeasurementReferenceTime_networkTime_uTRA._cont = ASN1Dict([
        (u'mode', ___MeasurementReferenceTime_networkTime_uTRA_mode),
        (u'cellGlobalId', ___MeasurementReferenceTime_networkTime_uTRA_cellGlobalId),
        (u'referenceSystemFrameNumber', ___MeasurementReferenceTime_networkTime_uTRA_referenceSystemFrameNumber),
        ])
    __MeasurementReferenceTime_networkTime_uTRA._ext = []
    __MeasurementReferenceTime_networkTime_gSM = SEQ(name=u'gSM', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___MeasurementReferenceTime_networkTime_gSM_bcchCarrier = INT(name=u'bcchCarrier', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___MeasurementReferenceTime_networkTime_gSM_bcchCarrier._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=1023)], ev=None, er=[])
    ___MeasurementReferenceTime_networkTime_gSM_bsic = INT(name=u'bsic', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___MeasurementReferenceTime_networkTime_gSM_bsic._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    ___MeasurementReferenceTime_networkTime_gSM_cellGlobalId = SEQ(name=u'cellGlobalId', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'CellGlobalIdGERAN')), opt=True)
    ___MeasurementReferenceTime_networkTime_gSM_referenceFrame = SEQ(name=u'referenceFrame', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ____MeasurementReferenceTime_networkTime_gSM_referenceFrame_referenceFN = INT(name=u'referenceFN', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ____MeasurementReferenceTime_networkTime_gSM_referenceFrame_referenceFN._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    ____MeasurementReferenceTime_networkTime_gSM_referenceFrame_referenceFNMSB = INT(name=u'referenceFNMSB', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    ____MeasurementReferenceTime_networkTime_gSM_referenceFrame_referenceFNMSB._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    ___MeasurementReferenceTime_networkTime_gSM_referenceFrame._cont = ASN1Dict([
        (u'referenceFN', ____MeasurementReferenceTime_networkTime_gSM_referenceFrame_referenceFN),
        (u'referenceFNMSB', ____MeasurementReferenceTime_networkTime_gSM_referenceFrame_referenceFNMSB),
        ])
    ___MeasurementReferenceTime_networkTime_gSM_referenceFrame._ext = []
    ___MeasurementReferenceTime_networkTime_gSM_deltaGNSS_TOD = INT(name=u'deltaGNSS-TOD', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    ___MeasurementReferenceTime_networkTime_gSM_deltaGNSS_TOD._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    __MeasurementReferenceTime_networkTime_gSM._cont = ASN1Dict([
        (u'bcchCarrier', ___MeasurementReferenceTime_networkTime_gSM_bcchCarrier),
        (u'bsic', ___MeasurementReferenceTime_networkTime_gSM_bsic),
        (u'cellGlobalId', ___MeasurementReferenceTime_networkTime_gSM_cellGlobalId),
        (u'referenceFrame', ___MeasurementReferenceTime_networkTime_gSM_referenceFrame),
        (u'deltaGNSS-TOD', ___MeasurementReferenceTime_networkTime_gSM_deltaGNSS_TOD),
        ])
    __MeasurementReferenceTime_networkTime_gSM._ext = []
    _MeasurementReferenceTime_networkTime._cont = ASN1Dict([
        (u'eUTRA', __MeasurementReferenceTime_networkTime_eUTRA),
        (u'uTRA', __MeasurementReferenceTime_networkTime_uTRA),
        (u'gSM', __MeasurementReferenceTime_networkTime_gSM),
        ])
    _MeasurementReferenceTime_networkTime._ext = []
    MeasurementReferenceTime._cont = ASN1Dict([
        (u'gnss-TOD-msec', _MeasurementReferenceTime_gnss_TOD_msec),
        (u'gnss-TOD-frac', _MeasurementReferenceTime_gnss_TOD_frac),
        (u'gnss-TOD-unc', _MeasurementReferenceTime_gnss_TOD_unc),
        (u'gnss-TimeID', _MeasurementReferenceTime_gnss_TimeID),
        (u'networkTime', _MeasurementReferenceTime_networkTime),
        ])
    MeasurementReferenceTime._ext = []
    
    #-----< GNSS-MeasurementList >-----#
    GNSS_MeasurementList = SEQ_OF(name=u'GNSS-MeasurementList', mode=MODE_TYPE)
    _GNSS_MeasurementList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-MeasurementForOneGNSS')))
    GNSS_MeasurementList._cont = _GNSS_MeasurementList__item_
    GNSS_MeasurementList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    
    #-----< GNSS-MeasurementForOneGNSS >-----#
    GNSS_MeasurementForOneGNSS = SEQ(name=u'GNSS-MeasurementForOneGNSS', mode=MODE_TYPE)
    _GNSS_MeasurementForOneGNSS_gnss_ID = SEQ(name=u'gnss-ID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-ID')))
    _GNSS_MeasurementForOneGNSS_gnss_SgnMeasList = SEQ_OF(name=u'gnss-SgnMeasList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-SgnMeasList')))
    GNSS_MeasurementForOneGNSS._cont = ASN1Dict([
        (u'gnss-ID', _GNSS_MeasurementForOneGNSS_gnss_ID),
        (u'gnss-SgnMeasList', _GNSS_MeasurementForOneGNSS_gnss_SgnMeasList),
        ])
    GNSS_MeasurementForOneGNSS._ext = []
    
    #-----< GNSS-SgnMeasList >-----#
    GNSS_SgnMeasList = SEQ_OF(name=u'GNSS-SgnMeasList', mode=MODE_TYPE)
    _GNSS_SgnMeasList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-SgnMeasElement')))
    GNSS_SgnMeasList._cont = _GNSS_SgnMeasList__item_
    GNSS_SgnMeasList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    
    #-----< GNSS-SgnMeasElement >-----#
    GNSS_SgnMeasElement = SEQ(name=u'GNSS-SgnMeasElement', mode=MODE_TYPE)
    _GNSS_SgnMeasElement_gnss_SignalID = SEQ(name=u'gnss-SignalID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-SignalID')))
    _GNSS_SgnMeasElement_gnss_CodePhaseAmbiguity = INT(name=u'gnss-CodePhaseAmbiguity', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GNSS_SgnMeasElement_gnss_CodePhaseAmbiguity._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    _GNSS_SgnMeasElement_gnss_SatMeasList = SEQ_OF(name=u'gnss-SatMeasList', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-SatMeasList')))
    GNSS_SgnMeasElement._cont = ASN1Dict([
        (u'gnss-SignalID', _GNSS_SgnMeasElement_gnss_SignalID),
        (u'gnss-CodePhaseAmbiguity', _GNSS_SgnMeasElement_gnss_CodePhaseAmbiguity),
        (u'gnss-SatMeasList', _GNSS_SgnMeasElement_gnss_SatMeasList),
        ])
    GNSS_SgnMeasElement._ext = []
    
    #-----< GNSS-SatMeasList >-----#
    GNSS_SatMeasList = SEQ_OF(name=u'GNSS-SatMeasList', mode=MODE_TYPE)
    _GNSS_SatMeasList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-SatMeasElement')))
    GNSS_SatMeasList._cont = _GNSS_SatMeasList__item_
    GNSS_SatMeasList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    
    #-----< GNSS-SatMeasElement >-----#
    GNSS_SatMeasElement = SEQ(name=u'GNSS-SatMeasElement', mode=MODE_TYPE)
    _GNSS_SatMeasElement_svID = SEQ(name=u'svID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'SV-ID')))
    _GNSS_SatMeasElement_cNo = INT(name=u'cNo', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GNSS_SatMeasElement_cNo._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    _GNSS_SatMeasElement_mpathDet = ENUM(name=u'mpathDet', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GNSS_SatMeasElement_mpathDet._cont = ASN1Dict([(u'notMeasured', 0), (u'low', 1), (u'medium', 2), (u'high', 3)])
    _GNSS_SatMeasElement_mpathDet._ext = []
    _GNSS_SatMeasElement_carrierQualityInd = INT(name=u'carrierQualityInd', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GNSS_SatMeasElement_carrierQualityInd._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=3)], ev=None, er=[])
    _GNSS_SatMeasElement_codePhase = INT(name=u'codePhase', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GNSS_SatMeasElement_codePhase._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=2097151)], ev=None, er=[])
    _GNSS_SatMeasElement_integerCodePhase = INT(name=u'integerCodePhase', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GNSS_SatMeasElement_integerCodePhase._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    _GNSS_SatMeasElement_codePhaseRMSError = INT(name=u'codePhaseRMSError', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GNSS_SatMeasElement_codePhaseRMSError._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    _GNSS_SatMeasElement_doppler = INT(name=u'doppler', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GNSS_SatMeasElement_doppler._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-32768, ub=32767)], ev=None, er=[])
    _GNSS_SatMeasElement_adr = INT(name=u'adr', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GNSS_SatMeasElement_adr._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=33554431)], ev=None, er=[])
    GNSS_SatMeasElement._cont = ASN1Dict([
        (u'svID', _GNSS_SatMeasElement_svID),
        (u'cNo', _GNSS_SatMeasElement_cNo),
        (u'mpathDet', _GNSS_SatMeasElement_mpathDet),
        (u'carrierQualityInd', _GNSS_SatMeasElement_carrierQualityInd),
        (u'codePhase', _GNSS_SatMeasElement_codePhase),
        (u'integerCodePhase', _GNSS_SatMeasElement_integerCodePhase),
        (u'codePhaseRMSError', _GNSS_SatMeasElement_codePhaseRMSError),
        (u'doppler', _GNSS_SatMeasElement_doppler),
        (u'adr', _GNSS_SatMeasElement_adr),
        ])
    GNSS_SatMeasElement._ext = []
    
    #-----< GNSS-LocationInformation >-----#
    GNSS_LocationInformation = SEQ(name=u'GNSS-LocationInformation', mode=MODE_TYPE)
    _GNSS_LocationInformation_measurementReferenceTime = SEQ(name=u'measurementReferenceTime', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'MeasurementReferenceTime')))
    _GNSS_LocationInformation_agnss_List = SEQ(name=u'agnss-List', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-ID-Bitmap')))
    GNSS_LocationInformation._cont = ASN1Dict([
        (u'measurementReferenceTime', _GNSS_LocationInformation_measurementReferenceTime),
        (u'agnss-List', _GNSS_LocationInformation_agnss_List),
        ])
    GNSS_LocationInformation._ext = []
    
    #-----< A-GNSS-RequestLocationInformation >-----#
    A_GNSS_RequestLocationInformation = SEQ(name=u'A-GNSS-RequestLocationInformation', mode=MODE_TYPE)
    _A_GNSS_RequestLocationInformation_gnss_PositioningInstructions = SEQ(name=u'gnss-PositioningInstructions', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-PositioningInstructions')))
    A_GNSS_RequestLocationInformation._cont = ASN1Dict([
        (u'gnss-PositioningInstructions', _A_GNSS_RequestLocationInformation_gnss_PositioningInstructions),
        ])
    A_GNSS_RequestLocationInformation._ext = []
    
    #-----< GNSS-PositioningInstructions >-----#
    GNSS_PositioningInstructions = SEQ(name=u'GNSS-PositioningInstructions', mode=MODE_TYPE)
    _GNSS_PositioningInstructions_gnss_Methods = SEQ(name=u'gnss-Methods', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-ID-Bitmap')))
    _GNSS_PositioningInstructions_fineTimeAssistanceMeasReq = BOOL(name=u'fineTimeAssistanceMeasReq', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GNSS_PositioningInstructions_adrMeasReq = BOOL(name=u'adrMeasReq', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GNSS_PositioningInstructions_multiFreqMeasReq = BOOL(name=u'multiFreqMeasReq', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GNSS_PositioningInstructions_assistanceAvailability = BOOL(name=u'assistanceAvailability', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    GNSS_PositioningInstructions._cont = ASN1Dict([
        (u'gnss-Methods', _GNSS_PositioningInstructions_gnss_Methods),
        (u'fineTimeAssistanceMeasReq', _GNSS_PositioningInstructions_fineTimeAssistanceMeasReq),
        (u'adrMeasReq', _GNSS_PositioningInstructions_adrMeasReq),
        (u'multiFreqMeasReq', _GNSS_PositioningInstructions_multiFreqMeasReq),
        (u'assistanceAvailability', _GNSS_PositioningInstructions_assistanceAvailability),
        ])
    GNSS_PositioningInstructions._ext = []
    
    #-----< A-GNSS-ProvideCapabilities >-----#
    A_GNSS_ProvideCapabilities = SEQ(name=u'A-GNSS-ProvideCapabilities', mode=MODE_TYPE)
    _A_GNSS_ProvideCapabilities_gnss_SupportList = SEQ_OF(name=u'gnss-SupportList', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-SupportList')), opt=True)
    _A_GNSS_ProvideCapabilities_assistanceDataSupportList = SEQ(name=u'assistanceDataSupportList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'AssistanceDataSupportList')), opt=True)
    _A_GNSS_ProvideCapabilities_locationCoordinateTypes = SEQ(name=u'locationCoordinateTypes', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'LocationCoordinateTypes')), opt=True)
    _A_GNSS_ProvideCapabilities_velocityTypes = SEQ(name=u'velocityTypes', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'VelocityTypes')), opt=True)
    A_GNSS_ProvideCapabilities._cont = ASN1Dict([
        (u'gnss-SupportList', _A_GNSS_ProvideCapabilities_gnss_SupportList),
        (u'assistanceDataSupportList', _A_GNSS_ProvideCapabilities_assistanceDataSupportList),
        (u'locationCoordinateTypes', _A_GNSS_ProvideCapabilities_locationCoordinateTypes),
        (u'velocityTypes', _A_GNSS_ProvideCapabilities_velocityTypes),
        ])
    A_GNSS_ProvideCapabilities._ext = []
    
    #-----< GNSS-SupportList >-----#
    GNSS_SupportList = SEQ_OF(name=u'GNSS-SupportList', mode=MODE_TYPE)
    _GNSS_SupportList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-SupportElement')))
    GNSS_SupportList._cont = _GNSS_SupportList__item_
    GNSS_SupportList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    
    #-----< GNSS-SupportElement >-----#
    GNSS_SupportElement = SEQ(name=u'GNSS-SupportElement', mode=MODE_TYPE)
    _GNSS_SupportElement_gnss_ID = SEQ(name=u'gnss-ID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-ID')))
    _GNSS_SupportElement_sbas_IDs = SEQ(name=u'sbas-IDs', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'SBAS-IDs')), opt=True)
    _GNSS_SupportElement_agnss_Modes = SEQ(name=u'agnss-Modes', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'PositioningModes')))
    _GNSS_SupportElement_gnss_Signals = SEQ(name=u'gnss-Signals', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-SignalIDs')))
    _GNSS_SupportElement_fta_MeasSupport = SEQ(name=u'fta-MeasSupport', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __GNSS_SupportElement_fta_MeasSupport_cellTime = SEQ(name=u'cellTime', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'AccessTypes')))
    __GNSS_SupportElement_fta_MeasSupport_mode = SEQ(name=u'mode', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'PositioningModes')))
    _GNSS_SupportElement_fta_MeasSupport._cont = ASN1Dict([
        (u'cellTime', __GNSS_SupportElement_fta_MeasSupport_cellTime),
        (u'mode', __GNSS_SupportElement_fta_MeasSupport_mode),
        ])
    _GNSS_SupportElement_fta_MeasSupport._ext = []
    _GNSS_SupportElement_adr_Support = BOOL(name=u'adr-Support', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GNSS_SupportElement_velocityMeasurementSupport = BOOL(name=u'velocityMeasurementSupport', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    GNSS_SupportElement._cont = ASN1Dict([
        (u'gnss-ID', _GNSS_SupportElement_gnss_ID),
        (u'sbas-IDs', _GNSS_SupportElement_sbas_IDs),
        (u'agnss-Modes', _GNSS_SupportElement_agnss_Modes),
        (u'gnss-Signals', _GNSS_SupportElement_gnss_Signals),
        (u'fta-MeasSupport', _GNSS_SupportElement_fta_MeasSupport),
        (u'adr-Support', _GNSS_SupportElement_adr_Support),
        (u'velocityMeasurementSupport', _GNSS_SupportElement_velocityMeasurementSupport),
        ])
    GNSS_SupportElement._ext = []
    
    #-----< AssistanceDataSupportList >-----#
    AssistanceDataSupportList = SEQ(name=u'AssistanceDataSupportList', mode=MODE_TYPE)
    _AssistanceDataSupportList_gnss_CommonAssistanceDataSupport = SEQ(name=u'gnss-CommonAssistanceDataSupport', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-CommonAssistanceDataSupport')))
    _AssistanceDataSupportList_gnss_GenericAssistanceDataSupport = SEQ_OF(name=u'gnss-GenericAssistanceDataSupport', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-GenericAssistanceDataSupport')))
    AssistanceDataSupportList._cont = ASN1Dict([
        (u'gnss-CommonAssistanceDataSupport', _AssistanceDataSupportList_gnss_CommonAssistanceDataSupport),
        (u'gnss-GenericAssistanceDataSupport', _AssistanceDataSupportList_gnss_GenericAssistanceDataSupport),
        ])
    AssistanceDataSupportList._ext = []
    
    #-----< GNSS-CommonAssistanceDataSupport >-----#
    GNSS_CommonAssistanceDataSupport = SEQ(name=u'GNSS-CommonAssistanceDataSupport', mode=MODE_TYPE)
    _GNSS_CommonAssistanceDataSupport_gnss_ReferenceTimeSupport = SEQ(name=u'gnss-ReferenceTimeSupport', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-ReferenceTimeSupport')), opt=True)
    _GNSS_CommonAssistanceDataSupport_gnss_ReferenceLocationSupport = SEQ(name=u'gnss-ReferenceLocationSupport', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-ReferenceLocationSupport')), opt=True)
    _GNSS_CommonAssistanceDataSupport_gnss_IonosphericModelSupport = SEQ(name=u'gnss-IonosphericModelSupport', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-IonosphericModelSupport')), opt=True)
    _GNSS_CommonAssistanceDataSupport_gnss_EarthOrientationParametersSupport = SEQ(name=u'gnss-EarthOrientationParametersSupport', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-EarthOrientationParametersSupport')), opt=True)
    GNSS_CommonAssistanceDataSupport._cont = ASN1Dict([
        (u'gnss-ReferenceTimeSupport', _GNSS_CommonAssistanceDataSupport_gnss_ReferenceTimeSupport),
        (u'gnss-ReferenceLocationSupport', _GNSS_CommonAssistanceDataSupport_gnss_ReferenceLocationSupport),
        (u'gnss-IonosphericModelSupport', _GNSS_CommonAssistanceDataSupport_gnss_IonosphericModelSupport),
        (u'gnss-EarthOrientationParametersSupport', _GNSS_CommonAssistanceDataSupport_gnss_EarthOrientationParametersSupport),
        ])
    GNSS_CommonAssistanceDataSupport._ext = []
    
    #-----< GNSS-ReferenceTimeSupport >-----#
    GNSS_ReferenceTimeSupport = SEQ(name=u'GNSS-ReferenceTimeSupport', mode=MODE_TYPE)
    _GNSS_ReferenceTimeSupport_gnss_SystemTime = SEQ(name=u'gnss-SystemTime', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-ID-Bitmap')))
    _GNSS_ReferenceTimeSupport_fta_Support = SEQ(name=u'fta-Support', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'AccessTypes')), opt=True)
    GNSS_ReferenceTimeSupport._cont = ASN1Dict([
        (u'gnss-SystemTime', _GNSS_ReferenceTimeSupport_gnss_SystemTime),
        (u'fta-Support', _GNSS_ReferenceTimeSupport_fta_Support),
        ])
    GNSS_ReferenceTimeSupport._ext = []
    
    #-----< GNSS-ReferenceLocationSupport >-----#
    GNSS_ReferenceLocationSupport = SEQ(name=u'GNSS-ReferenceLocationSupport', mode=MODE_TYPE)
    GNSS_ReferenceLocationSupport._cont = ASN1Dict([
        ])
    GNSS_ReferenceLocationSupport._ext = []
    
    #-----< GNSS-IonosphericModelSupport >-----#
    GNSS_IonosphericModelSupport = SEQ(name=u'GNSS-IonosphericModelSupport', mode=MODE_TYPE)
    _GNSS_IonosphericModelSupport_ionoModel = BIT_STR(name=u'ionoModel', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GNSS_IonosphericModelSupport_ionoModel._cont = ASN1Dict([(u'klobuchar', 0), (u'neQuick', 1)])
    _GNSS_IonosphericModelSupport_ionoModel._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    GNSS_IonosphericModelSupport._cont = ASN1Dict([
        (u'ionoModel', _GNSS_IonosphericModelSupport_ionoModel),
        ])
    GNSS_IonosphericModelSupport._ext = []
    
    #-----< GNSS-EarthOrientationParametersSupport >-----#
    GNSS_EarthOrientationParametersSupport = SEQ(name=u'GNSS-EarthOrientationParametersSupport', mode=MODE_TYPE)
    GNSS_EarthOrientationParametersSupport._cont = ASN1Dict([
        ])
    GNSS_EarthOrientationParametersSupport._ext = []
    
    #-----< GNSS-GenericAssistanceDataSupport >-----#
    GNSS_GenericAssistanceDataSupport = SEQ_OF(name=u'GNSS-GenericAssistanceDataSupport', mode=MODE_TYPE)
    _GNSS_GenericAssistanceDataSupport__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-GenericAssistDataSupportElement')))
    GNSS_GenericAssistanceDataSupport._cont = _GNSS_GenericAssistanceDataSupport__item_
    GNSS_GenericAssistanceDataSupport._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    
    #-----< GNSS-GenericAssistDataSupportElement >-----#
    GNSS_GenericAssistDataSupportElement = SEQ(name=u'GNSS-GenericAssistDataSupportElement', mode=MODE_TYPE)
    _GNSS_GenericAssistDataSupportElement_gnss_ID = SEQ(name=u'gnss-ID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-ID')))
    _GNSS_GenericAssistDataSupportElement_sbas_ID = SEQ(name=u'sbas-ID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'SBAS-ID')), opt=True)
    _GNSS_GenericAssistDataSupportElement_gnss_TimeModelsSupport = SEQ(name=u'gnss-TimeModelsSupport', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-TimeModelListSupport')), opt=True)
    _GNSS_GenericAssistDataSupportElement_gnss_DifferentialCorrectionsSupport = SEQ(name=u'gnss-DifferentialCorrectionsSupport', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-DifferentialCorrectionsSupport')), opt=True)
    _GNSS_GenericAssistDataSupportElement_gnss_NavigationModelSupport = SEQ(name=u'gnss-NavigationModelSupport', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-NavigationModelSupport')), opt=True)
    _GNSS_GenericAssistDataSupportElement_gnss_RealTimeIntegritySupport = SEQ(name=u'gnss-RealTimeIntegritySupport', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-RealTimeIntegritySupport')), opt=True)
    _GNSS_GenericAssistDataSupportElement_gnss_DataBitAssistanceSupport = SEQ(name=u'gnss-DataBitAssistanceSupport', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-DataBitAssistanceSupport')), opt=True)
    _GNSS_GenericAssistDataSupportElement_gnss_AcquisitionAssistanceSupport = SEQ(name=u'gnss-AcquisitionAssistanceSupport', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-AcquisitionAssistanceSupport')), opt=True)
    _GNSS_GenericAssistDataSupportElement_gnss_AlmanacSupport = SEQ(name=u'gnss-AlmanacSupport', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-AlmanacSupport')), opt=True)
    _GNSS_GenericAssistDataSupportElement_gnss_UTC_ModelSupport = SEQ(name=u'gnss-UTC-ModelSupport', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-UTC-ModelSupport')), opt=True)
    _GNSS_GenericAssistDataSupportElement_gnss_AuxiliaryInformationSupport = SEQ(name=u'gnss-AuxiliaryInformationSupport', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-AuxiliaryInformationSupport')), opt=True)
    _GNSS_GenericAssistDataSupportElement_bds_DifferentialCorrectionsSupport_r12 = SEQ(name=u'bds-DifferentialCorrectionsSupport-r12', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'BDS-DifferentialCorrectionsSupport-r12')), opt=True, group=0)
    _GNSS_GenericAssistDataSupportElement_bds_GridModelSupport_r12 = SEQ(name=u'bds-GridModelSupport-r12', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'BDS-GridModelSupport-r12')), opt=True, group=0)
    GNSS_GenericAssistDataSupportElement._cont = ASN1Dict([
        (u'gnss-ID', _GNSS_GenericAssistDataSupportElement_gnss_ID),
        (u'sbas-ID', _GNSS_GenericAssistDataSupportElement_sbas_ID),
        (u'gnss-TimeModelsSupport', _GNSS_GenericAssistDataSupportElement_gnss_TimeModelsSupport),
        (u'gnss-DifferentialCorrectionsSupport', _GNSS_GenericAssistDataSupportElement_gnss_DifferentialCorrectionsSupport),
        (u'gnss-NavigationModelSupport', _GNSS_GenericAssistDataSupportElement_gnss_NavigationModelSupport),
        (u'gnss-RealTimeIntegritySupport', _GNSS_GenericAssistDataSupportElement_gnss_RealTimeIntegritySupport),
        (u'gnss-DataBitAssistanceSupport', _GNSS_GenericAssistDataSupportElement_gnss_DataBitAssistanceSupport),
        (u'gnss-AcquisitionAssistanceSupport', _GNSS_GenericAssistDataSupportElement_gnss_AcquisitionAssistanceSupport),
        (u'gnss-AlmanacSupport', _GNSS_GenericAssistDataSupportElement_gnss_AlmanacSupport),
        (u'gnss-UTC-ModelSupport', _GNSS_GenericAssistDataSupportElement_gnss_UTC_ModelSupport),
        (u'gnss-AuxiliaryInformationSupport', _GNSS_GenericAssistDataSupportElement_gnss_AuxiliaryInformationSupport),
        (u'bds-DifferentialCorrectionsSupport-r12', _GNSS_GenericAssistDataSupportElement_bds_DifferentialCorrectionsSupport_r12),
        (u'bds-GridModelSupport-r12', _GNSS_GenericAssistDataSupportElement_bds_GridModelSupport_r12),
        ])
    GNSS_GenericAssistDataSupportElement._ext = [u'bds-DifferentialCorrectionsSupport-r12', u'bds-GridModelSupport-r12']
    
    #-----< GNSS-TimeModelListSupport >-----#
    GNSS_TimeModelListSupport = SEQ(name=u'GNSS-TimeModelListSupport', mode=MODE_TYPE)
    GNSS_TimeModelListSupport._cont = ASN1Dict([
        ])
    GNSS_TimeModelListSupport._ext = []
    
    #-----< GNSS-DifferentialCorrectionsSupport >-----#
    GNSS_DifferentialCorrectionsSupport = SEQ(name=u'GNSS-DifferentialCorrectionsSupport', mode=MODE_TYPE)
    _GNSS_DifferentialCorrectionsSupport_gnssSignalIDs = SEQ(name=u'gnssSignalIDs', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-SignalIDs')))
    _GNSS_DifferentialCorrectionsSupport_dgnss_ValidityTimeSup = BOOL(name=u'dgnss-ValidityTimeSup', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    GNSS_DifferentialCorrectionsSupport._cont = ASN1Dict([
        (u'gnssSignalIDs', _GNSS_DifferentialCorrectionsSupport_gnssSignalIDs),
        (u'dgnss-ValidityTimeSup', _GNSS_DifferentialCorrectionsSupport_dgnss_ValidityTimeSup),
        ])
    GNSS_DifferentialCorrectionsSupport._ext = []
    
    #-----< GNSS-NavigationModelSupport >-----#
    GNSS_NavigationModelSupport = SEQ(name=u'GNSS-NavigationModelSupport', mode=MODE_TYPE)
    _GNSS_NavigationModelSupport_clockModel = BIT_STR(name=u'clockModel', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GNSS_NavigationModelSupport_clockModel._cont = ASN1Dict([(u'model-1', 0), (u'model-2', 1), (u'model-3', 2), (u'model-4', 3), (u'model-5', 4), (u'model-6', 5)])
    _GNSS_NavigationModelSupport_clockModel._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    _GNSS_NavigationModelSupport_orbitModel = BIT_STR(name=u'orbitModel', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GNSS_NavigationModelSupport_orbitModel._cont = ASN1Dict([(u'model-1', 0), (u'model-2', 1), (u'model-3', 2), (u'model-4', 3), (u'model-5', 4), (u'model-6', 5)])
    _GNSS_NavigationModelSupport_orbitModel._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    GNSS_NavigationModelSupport._cont = ASN1Dict([
        (u'clockModel', _GNSS_NavigationModelSupport_clockModel),
        (u'orbitModel', _GNSS_NavigationModelSupport_orbitModel),
        ])
    GNSS_NavigationModelSupport._ext = []
    
    #-----< GNSS-RealTimeIntegritySupport >-----#
    GNSS_RealTimeIntegritySupport = SEQ(name=u'GNSS-RealTimeIntegritySupport', mode=MODE_TYPE)
    GNSS_RealTimeIntegritySupport._cont = ASN1Dict([
        ])
    GNSS_RealTimeIntegritySupport._ext = []
    
    #-----< GNSS-DataBitAssistanceSupport >-----#
    GNSS_DataBitAssistanceSupport = SEQ(name=u'GNSS-DataBitAssistanceSupport', mode=MODE_TYPE)
    GNSS_DataBitAssistanceSupport._cont = ASN1Dict([
        ])
    GNSS_DataBitAssistanceSupport._ext = []
    
    #-----< GNSS-AcquisitionAssistanceSupport >-----#
    GNSS_AcquisitionAssistanceSupport = SEQ(name=u'GNSS-AcquisitionAssistanceSupport', mode=MODE_TYPE)
    _GNSS_AcquisitionAssistanceSupport_confidenceSupport_r10 = ENUM(name=u'confidenceSupport-r10', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GNSS_AcquisitionAssistanceSupport_confidenceSupport_r10._cont = ASN1Dict([(u'true', 0)])
    _GNSS_AcquisitionAssistanceSupport_confidenceSupport_r10._ext = None
    _GNSS_AcquisitionAssistanceSupport_dopplerUncertaintyExtSupport_r10 = ENUM(name=u'dopplerUncertaintyExtSupport-r10', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GNSS_AcquisitionAssistanceSupport_dopplerUncertaintyExtSupport_r10._cont = ASN1Dict([(u'true', 0)])
    _GNSS_AcquisitionAssistanceSupport_dopplerUncertaintyExtSupport_r10._ext = None
    GNSS_AcquisitionAssistanceSupport._cont = ASN1Dict([
        (u'confidenceSupport-r10', _GNSS_AcquisitionAssistanceSupport_confidenceSupport_r10),
        (u'dopplerUncertaintyExtSupport-r10', _GNSS_AcquisitionAssistanceSupport_dopplerUncertaintyExtSupport_r10),
        ])
    GNSS_AcquisitionAssistanceSupport._ext = [u'confidenceSupport-r10', u'dopplerUncertaintyExtSupport-r10']
    
    #-----< GNSS-AlmanacSupport >-----#
    GNSS_AlmanacSupport = SEQ(name=u'GNSS-AlmanacSupport', mode=MODE_TYPE)
    _GNSS_AlmanacSupport_almanacModel = BIT_STR(name=u'almanacModel', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GNSS_AlmanacSupport_almanacModel._cont = ASN1Dict([(u'model-1', 0), (u'model-2', 1), (u'model-3', 2), (u'model-4', 3), (u'model-5', 4), (u'model-6', 5), (u'model-7', 6)])
    _GNSS_AlmanacSupport_almanacModel._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    GNSS_AlmanacSupport._cont = ASN1Dict([
        (u'almanacModel', _GNSS_AlmanacSupport_almanacModel),
        ])
    GNSS_AlmanacSupport._ext = []
    
    #-----< GNSS-UTC-ModelSupport >-----#
    GNSS_UTC_ModelSupport = SEQ(name=u'GNSS-UTC-ModelSupport', mode=MODE_TYPE)
    _GNSS_UTC_ModelSupport_utc_Model = BIT_STR(name=u'utc-Model', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GNSS_UTC_ModelSupport_utc_Model._cont = ASN1Dict([(u'model-1', 0), (u'model-2', 1), (u'model-3', 2), (u'model-4', 3), (u'model-5', 4)])
    _GNSS_UTC_ModelSupport_utc_Model._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    GNSS_UTC_ModelSupport._cont = ASN1Dict([
        (u'utc-Model', _GNSS_UTC_ModelSupport_utc_Model),
        ])
    GNSS_UTC_ModelSupport._ext = []
    
    #-----< GNSS-AuxiliaryInformationSupport >-----#
    GNSS_AuxiliaryInformationSupport = SEQ(name=u'GNSS-AuxiliaryInformationSupport', mode=MODE_TYPE)
    GNSS_AuxiliaryInformationSupport._cont = ASN1Dict([
        ])
    GNSS_AuxiliaryInformationSupport._ext = []
    
    #-----< BDS-DifferentialCorrectionsSupport-r12 >-----#
    BDS_DifferentialCorrectionsSupport_r12 = SEQ(name=u'BDS-DifferentialCorrectionsSupport-r12', mode=MODE_TYPE)
    _BDS_DifferentialCorrectionsSupport_r12_gnssSignalIDs = SEQ(name=u'gnssSignalIDs', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-SignalIDs')))
    BDS_DifferentialCorrectionsSupport_r12._cont = ASN1Dict([
        (u'gnssSignalIDs', _BDS_DifferentialCorrectionsSupport_r12_gnssSignalIDs),
        ])
    BDS_DifferentialCorrectionsSupport_r12._ext = []
    
    #-----< BDS-GridModelSupport-r12 >-----#
    BDS_GridModelSupport_r12 = SEQ(name=u'BDS-GridModelSupport-r12', mode=MODE_TYPE)
    BDS_GridModelSupport_r12._cont = ASN1Dict([
        ])
    BDS_GridModelSupport_r12._ext = []
    
    #-----< A-GNSS-RequestCapabilities >-----#
    A_GNSS_RequestCapabilities = SEQ(name=u'A-GNSS-RequestCapabilities', mode=MODE_TYPE)
    _A_GNSS_RequestCapabilities_gnss_SupportListReq = BOOL(name=u'gnss-SupportListReq', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _A_GNSS_RequestCapabilities_assistanceDataSupportListReq = BOOL(name=u'assistanceDataSupportListReq', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _A_GNSS_RequestCapabilities_locationVelocityTypesReq = BOOL(name=u'locationVelocityTypesReq', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    A_GNSS_RequestCapabilities._cont = ASN1Dict([
        (u'gnss-SupportListReq', _A_GNSS_RequestCapabilities_gnss_SupportListReq),
        (u'assistanceDataSupportListReq', _A_GNSS_RequestCapabilities_assistanceDataSupportListReq),
        (u'locationVelocityTypesReq', _A_GNSS_RequestCapabilities_locationVelocityTypesReq),
        ])
    A_GNSS_RequestCapabilities._ext = []
    
    #-----< A-GNSS-Error >-----#
    A_GNSS_Error = CHOICE(name=u'A-GNSS-Error', mode=MODE_TYPE)
    _A_GNSS_Error_locationServerErrorCauses = SEQ(name=u'locationServerErrorCauses', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-LocationServerErrorCauses')))
    _A_GNSS_Error_targetDeviceErrorCauses = SEQ(name=u'targetDeviceErrorCauses', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-TargetDeviceErrorCauses')))
    A_GNSS_Error._cont = ASN1Dict([
        (u'locationServerErrorCauses', _A_GNSS_Error_locationServerErrorCauses),
        (u'targetDeviceErrorCauses', _A_GNSS_Error_targetDeviceErrorCauses),
        ])
    A_GNSS_Error._ext = []
    
    #-----< GNSS-LocationServerErrorCauses >-----#
    GNSS_LocationServerErrorCauses = SEQ(name=u'GNSS-LocationServerErrorCauses', mode=MODE_TYPE)
    _GNSS_LocationServerErrorCauses_cause = ENUM(name=u'cause', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GNSS_LocationServerErrorCauses_cause._cont = ASN1Dict([(u'undefined', 0), (u'undeliveredAssistanceDataIsNotSupportedByServer', 1), (u'undeliveredAssistanceDataIsSupportedButCurrentlyNotAvailableByServer', 2), (u'undeliveredAssistanceDataIsPartlyNotSupportedAndPartlyNotAvailableByServer', 3)])
    _GNSS_LocationServerErrorCauses_cause._ext = []
    GNSS_LocationServerErrorCauses._cont = ASN1Dict([
        (u'cause', _GNSS_LocationServerErrorCauses_cause),
        ])
    GNSS_LocationServerErrorCauses._ext = []
    
    #-----< GNSS-TargetDeviceErrorCauses >-----#
    GNSS_TargetDeviceErrorCauses = SEQ(name=u'GNSS-TargetDeviceErrorCauses', mode=MODE_TYPE)
    _GNSS_TargetDeviceErrorCauses_cause = ENUM(name=u'cause', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GNSS_TargetDeviceErrorCauses_cause._cont = ASN1Dict([(u'undefined', 0), (u'thereWereNotEnoughSatellitesReceived', 1), (u'assistanceDataMissing', 2), (u'notAllRequestedMeasurementsPossible', 3)])
    _GNSS_TargetDeviceErrorCauses_cause._ext = []
    _GNSS_TargetDeviceErrorCauses_fineTimeAssistanceMeasurementsNotPossible = NULL(name=u'fineTimeAssistanceMeasurementsNotPossible', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GNSS_TargetDeviceErrorCauses_adrMeasurementsNotPossible = NULL(name=u'adrMeasurementsNotPossible', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GNSS_TargetDeviceErrorCauses_multiFrequencyMeasurementsNotPossible = NULL(name=u'multiFrequencyMeasurementsNotPossible', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    GNSS_TargetDeviceErrorCauses._cont = ASN1Dict([
        (u'cause', _GNSS_TargetDeviceErrorCauses_cause),
        (u'fineTimeAssistanceMeasurementsNotPossible', _GNSS_TargetDeviceErrorCauses_fineTimeAssistanceMeasurementsNotPossible),
        (u'adrMeasurementsNotPossible', _GNSS_TargetDeviceErrorCauses_adrMeasurementsNotPossible),
        (u'multiFrequencyMeasurementsNotPossible', _GNSS_TargetDeviceErrorCauses_multiFrequencyMeasurementsNotPossible),
        ])
    GNSS_TargetDeviceErrorCauses._ext = []
    
    #-----< GNSS-ID >-----#
    GNSS_ID = SEQ(name=u'GNSS-ID', mode=MODE_TYPE)
    _GNSS_ID_gnss_id = ENUM(name=u'gnss-id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GNSS_ID_gnss_id._cont = ASN1Dict([(u'gps', 0), (u'sbas', 1), (u'qzss', 2), (u'galileo', 3), (u'glonass', 4), (u'bds', 5)])
    _GNSS_ID_gnss_id._ext = [u'bds']
    GNSS_ID._cont = ASN1Dict([
        (u'gnss-id', _GNSS_ID_gnss_id),
        ])
    GNSS_ID._ext = []
    
    #-----< GNSS-ID-Bitmap >-----#
    GNSS_ID_Bitmap = SEQ(name=u'GNSS-ID-Bitmap', mode=MODE_TYPE)
    _GNSS_ID_Bitmap_gnss_ids = BIT_STR(name=u'gnss-ids', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GNSS_ID_Bitmap_gnss_ids._cont = ASN1Dict([(u'gps', 0), (u'sbas', 1), (u'qzss', 2), (u'galileo', 3), (u'glonass', 4), (u'bds', 5)])
    _GNSS_ID_Bitmap_gnss_ids._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    GNSS_ID_Bitmap._cont = ASN1Dict([
        (u'gnss-ids', _GNSS_ID_Bitmap_gnss_ids),
        ])
    GNSS_ID_Bitmap._ext = []
    
    #-----< GNSS-SignalID >-----#
    GNSS_SignalID = SEQ(name=u'GNSS-SignalID', mode=MODE_TYPE)
    _GNSS_SignalID_gnss_SignalID = INT(name=u'gnss-SignalID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GNSS_SignalID_gnss_SignalID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=7)], ev=None, er=[])
    GNSS_SignalID._cont = ASN1Dict([
        (u'gnss-SignalID', _GNSS_SignalID_gnss_SignalID),
        ])
    GNSS_SignalID._ext = []
    
    #-----< GNSS-SignalIDs >-----#
    GNSS_SignalIDs = SEQ(name=u'GNSS-SignalIDs', mode=MODE_TYPE)
    _GNSS_SignalIDs_gnss_SignalIDs = BIT_STR(name=u'gnss-SignalIDs', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GNSS_SignalIDs_gnss_SignalIDs._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    GNSS_SignalIDs._cont = ASN1Dict([
        (u'gnss-SignalIDs', _GNSS_SignalIDs_gnss_SignalIDs),
        ])
    GNSS_SignalIDs._ext = []
    
    #-----< SBAS-ID >-----#
    SBAS_ID = SEQ(name=u'SBAS-ID', mode=MODE_TYPE)
    _SBAS_ID_sbas_id = ENUM(name=u'sbas-id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _SBAS_ID_sbas_id._cont = ASN1Dict([(u'waas', 0), (u'egnos', 1), (u'msas', 2), (u'gagan', 3)])
    _SBAS_ID_sbas_id._ext = []
    SBAS_ID._cont = ASN1Dict([
        (u'sbas-id', _SBAS_ID_sbas_id),
        ])
    SBAS_ID._ext = []
    
    #-----< SBAS-IDs >-----#
    SBAS_IDs = SEQ(name=u'SBAS-IDs', mode=MODE_TYPE)
    _SBAS_IDs_sbas_IDs = BIT_STR(name=u'sbas-IDs', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _SBAS_IDs_sbas_IDs._cont = ASN1Dict([(u'waas', 0), (u'egnos', 1), (u'msas', 2), (u'gagan', 3)])
    _SBAS_IDs_sbas_IDs._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    SBAS_IDs._cont = ASN1Dict([
        (u'sbas-IDs', _SBAS_IDs_sbas_IDs),
        ])
    SBAS_IDs._ext = []
    
    #-----< SV-ID >-----#
    SV_ID = SEQ(name=u'SV-ID', mode=MODE_TYPE)
    _SV_ID_satellite_id = INT(name=u'satellite-id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _SV_ID_satellite_id._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    SV_ID._cont = ASN1Dict([
        (u'satellite-id', _SV_ID_satellite_id),
        ])
    SV_ID._ext = []
    
    #-----< ECID-ProvideLocationInformation >-----#
    ECID_ProvideLocationInformation = SEQ(name=u'ECID-ProvideLocationInformation', mode=MODE_TYPE)
    _ECID_ProvideLocationInformation_ecid_SignalMeasurementInformation = SEQ(name=u'ecid-SignalMeasurementInformation', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'ECID-SignalMeasurementInformation')), opt=True)
    _ECID_ProvideLocationInformation_ecid_Error = CHOICE(name=u'ecid-Error', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'ECID-Error')), opt=True)
    ECID_ProvideLocationInformation._cont = ASN1Dict([
        (u'ecid-SignalMeasurementInformation', _ECID_ProvideLocationInformation_ecid_SignalMeasurementInformation),
        (u'ecid-Error', _ECID_ProvideLocationInformation_ecid_Error),
        ])
    ECID_ProvideLocationInformation._ext = []
    
    #-----< ECID-SignalMeasurementInformation >-----#
    ECID_SignalMeasurementInformation = SEQ(name=u'ECID-SignalMeasurementInformation', mode=MODE_TYPE)
    _ECID_SignalMeasurementInformation_primaryCellMeasuredResults = SEQ(name=u'primaryCellMeasuredResults', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'MeasuredResultsElement')), opt=True)
    _ECID_SignalMeasurementInformation_measuredResultsList = SEQ_OF(name=u'measuredResultsList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'MeasuredResultsList')))
    ECID_SignalMeasurementInformation._cont = ASN1Dict([
        (u'primaryCellMeasuredResults', _ECID_SignalMeasurementInformation_primaryCellMeasuredResults),
        (u'measuredResultsList', _ECID_SignalMeasurementInformation_measuredResultsList),
        ])
    ECID_SignalMeasurementInformation._ext = []
    
    #-----< MeasuredResultsList >-----#
    MeasuredResultsList = SEQ_OF(name=u'MeasuredResultsList', mode=MODE_TYPE)
    _MeasuredResultsList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('LPP-PDU-Definitions', 'MeasuredResultsElement')))
    MeasuredResultsList._cont = _MeasuredResultsList__item_
    MeasuredResultsList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    
    #-----< MeasuredResultsElement >-----#
    MeasuredResultsElement = SEQ(name=u'MeasuredResultsElement', mode=MODE_TYPE)
    _MeasuredResultsElement_physCellId = INT(name=u'physCellId', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MeasuredResultsElement_physCellId._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=503)], ev=None, er=[])
    _MeasuredResultsElement_cellGlobalId = SEQ(name=u'cellGlobalId', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'CellGlobalIdEUTRA-AndUTRA')), opt=True)
    _MeasuredResultsElement_arfcnEUTRA = INT(name=u'arfcnEUTRA', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'ARFCN-ValueEUTRA')))
    _MeasuredResultsElement_systemFrameNumber = BIT_STR(name=u'systemFrameNumber', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MeasuredResultsElement_systemFrameNumber._const_sz = ASN1Set(rv=[10], rr=[], ev=None, er=[])
    _MeasuredResultsElement_rsrp_Result = INT(name=u'rsrp-Result', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MeasuredResultsElement_rsrp_Result._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=97)], ev=None, er=[])
    _MeasuredResultsElement_rsrq_Result = INT(name=u'rsrq-Result', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MeasuredResultsElement_rsrq_Result._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=34)], ev=None, er=[])
    _MeasuredResultsElement_ue_RxTxTimeDiff = INT(name=u'ue-RxTxTimeDiff', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MeasuredResultsElement_ue_RxTxTimeDiff._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4095)], ev=None, er=[])
    _MeasuredResultsElement_arfcnEUTRA_v9a0 = INT(name=u'arfcnEUTRA-v9a0', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'ARFCN-ValueEUTRA-v9a0')), opt=True, group=0)
    MeasuredResultsElement._cont = ASN1Dict([
        (u'physCellId', _MeasuredResultsElement_physCellId),
        (u'cellGlobalId', _MeasuredResultsElement_cellGlobalId),
        (u'arfcnEUTRA', _MeasuredResultsElement_arfcnEUTRA),
        (u'systemFrameNumber', _MeasuredResultsElement_systemFrameNumber),
        (u'rsrp-Result', _MeasuredResultsElement_rsrp_Result),
        (u'rsrq-Result', _MeasuredResultsElement_rsrq_Result),
        (u'ue-RxTxTimeDiff', _MeasuredResultsElement_ue_RxTxTimeDiff),
        (u'arfcnEUTRA-v9a0', _MeasuredResultsElement_arfcnEUTRA_v9a0),
        ])
    MeasuredResultsElement._ext = [u'arfcnEUTRA-v9a0']
    
    #-----< ECID-RequestLocationInformation >-----#
    ECID_RequestLocationInformation = SEQ(name=u'ECID-RequestLocationInformation', mode=MODE_TYPE)
    _ECID_RequestLocationInformation_requestedMeasurements = BIT_STR(name=u'requestedMeasurements', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ECID_RequestLocationInformation_requestedMeasurements._cont = ASN1Dict([(u'rsrpReq', 0), (u'rsrqReq', 1), (u'ueRxTxReq', 2)])
    _ECID_RequestLocationInformation_requestedMeasurements._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    ECID_RequestLocationInformation._cont = ASN1Dict([
        (u'requestedMeasurements', _ECID_RequestLocationInformation_requestedMeasurements),
        ])
    ECID_RequestLocationInformation._ext = []
    
    #-----< ECID-ProvideCapabilities >-----#
    ECID_ProvideCapabilities = SEQ(name=u'ECID-ProvideCapabilities', mode=MODE_TYPE)
    _ECID_ProvideCapabilities_ecid_MeasSupported = BIT_STR(name=u'ecid-MeasSupported', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ECID_ProvideCapabilities_ecid_MeasSupported._cont = ASN1Dict([(u'rsrpSup', 0), (u'rsrqSup', 1), (u'ueRxTxSup', 2)])
    _ECID_ProvideCapabilities_ecid_MeasSupported._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    ECID_ProvideCapabilities._cont = ASN1Dict([
        (u'ecid-MeasSupported', _ECID_ProvideCapabilities_ecid_MeasSupported),
        ])
    ECID_ProvideCapabilities._ext = []
    
    #-----< ECID-RequestCapabilities >-----#
    ECID_RequestCapabilities = SEQ(name=u'ECID-RequestCapabilities', mode=MODE_TYPE)
    ECID_RequestCapabilities._cont = ASN1Dict([
        ])
    ECID_RequestCapabilities._ext = []
    
    #-----< ECID-Error >-----#
    ECID_Error = CHOICE(name=u'ECID-Error', mode=MODE_TYPE)
    _ECID_Error_locationServerErrorCauses = SEQ(name=u'locationServerErrorCauses', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'ECID-LocationServerErrorCauses')))
    _ECID_Error_targetDeviceErrorCauses = SEQ(name=u'targetDeviceErrorCauses', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'ECID-TargetDeviceErrorCauses')))
    ECID_Error._cont = ASN1Dict([
        (u'locationServerErrorCauses', _ECID_Error_locationServerErrorCauses),
        (u'targetDeviceErrorCauses', _ECID_Error_targetDeviceErrorCauses),
        ])
    ECID_Error._ext = []
    
    #-----< ECID-LocationServerErrorCauses >-----#
    ECID_LocationServerErrorCauses = SEQ(name=u'ECID-LocationServerErrorCauses', mode=MODE_TYPE)
    _ECID_LocationServerErrorCauses_cause = ENUM(name=u'cause', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ECID_LocationServerErrorCauses_cause._cont = ASN1Dict([(u'undefined', 0)])
    _ECID_LocationServerErrorCauses_cause._ext = []
    ECID_LocationServerErrorCauses._cont = ASN1Dict([
        (u'cause', _ECID_LocationServerErrorCauses_cause),
        ])
    ECID_LocationServerErrorCauses._ext = []
    
    #-----< ECID-TargetDeviceErrorCauses >-----#
    ECID_TargetDeviceErrorCauses = SEQ(name=u'ECID-TargetDeviceErrorCauses', mode=MODE_TYPE)
    _ECID_TargetDeviceErrorCauses_cause = ENUM(name=u'cause', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ECID_TargetDeviceErrorCauses_cause._cont = ASN1Dict([(u'undefined', 0), (u'requestedMeasurementNotAvailable', 1), (u'notAllrequestedMeasurementsPossible', 2)])
    _ECID_TargetDeviceErrorCauses_cause._ext = []
    _ECID_TargetDeviceErrorCauses_rsrpMeasurementNotPossible = NULL(name=u'rsrpMeasurementNotPossible', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _ECID_TargetDeviceErrorCauses_rsrqMeasurementNotPossible = NULL(name=u'rsrqMeasurementNotPossible', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _ECID_TargetDeviceErrorCauses_ueRxTxMeasurementNotPossible = NULL(name=u'ueRxTxMeasurementNotPossible', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    ECID_TargetDeviceErrorCauses._cont = ASN1Dict([
        (u'cause', _ECID_TargetDeviceErrorCauses_cause),
        (u'rsrpMeasurementNotPossible', _ECID_TargetDeviceErrorCauses_rsrpMeasurementNotPossible),
        (u'rsrqMeasurementNotPossible', _ECID_TargetDeviceErrorCauses_rsrqMeasurementNotPossible),
        (u'ueRxTxMeasurementNotPossible', _ECID_TargetDeviceErrorCauses_ueRxTxMeasurementNotPossible),
        ])
    ECID_TargetDeviceErrorCauses._ext = []
    
    #-----< TBS-ProvideLocationInformation-r13 >-----#
    TBS_ProvideLocationInformation_r13 = SEQ(name=u'TBS-ProvideLocationInformation-r13', mode=MODE_TYPE)
    _TBS_ProvideLocationInformation_r13_tbs_MeasurementInformation_r13 = SEQ(name=u'tbs-MeasurementInformation-r13', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'TBS-MeasurementInformation-r13')), opt=True)
    _TBS_ProvideLocationInformation_r13_tbs_Error_r13 = CHOICE(name=u'tbs-Error-r13', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'TBS-Error-r13')), opt=True)
    TBS_ProvideLocationInformation_r13._cont = ASN1Dict([
        (u'tbs-MeasurementInformation-r13', _TBS_ProvideLocationInformation_r13_tbs_MeasurementInformation_r13),
        (u'tbs-Error-r13', _TBS_ProvideLocationInformation_r13_tbs_Error_r13),
        ])
    TBS_ProvideLocationInformation_r13._ext = []
    
    #-----< TBS-MeasurementInformation-r13 >-----#
    TBS_MeasurementInformation_r13 = SEQ(name=u'TBS-MeasurementInformation-r13', mode=MODE_TYPE)
    _TBS_MeasurementInformation_r13_measurementReferenceTime_r13 = TIME_UTC(name=u'measurementReferenceTime-r13', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _TBS_MeasurementInformation_r13_mbs_SgnMeasList_r13 = SEQ_OF(name=u'mbs-SgnMeasList-r13', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'MBS-BeaconMeasList-r13')), opt=True)
    TBS_MeasurementInformation_r13._cont = ASN1Dict([
        (u'measurementReferenceTime-r13', _TBS_MeasurementInformation_r13_measurementReferenceTime_r13),
        (u'mbs-SgnMeasList-r13', _TBS_MeasurementInformation_r13_mbs_SgnMeasList_r13),
        ])
    TBS_MeasurementInformation_r13._ext = []
    
    #-----< MBS-BeaconMeasList-r13 >-----#
    MBS_BeaconMeasList_r13 = SEQ_OF(name=u'MBS-BeaconMeasList-r13', mode=MODE_TYPE)
    _MBS_BeaconMeasList_r13__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('LPP-PDU-Definitions', 'MBS-BeaconMeasElement-r13')))
    MBS_BeaconMeasList_r13._cont = _MBS_BeaconMeasList_r13__item_
    MBS_BeaconMeasList_r13._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    
    #-----< MBS-BeaconMeasElement-r13 >-----#
    MBS_BeaconMeasElement_r13 = SEQ(name=u'MBS-BeaconMeasElement-r13', mode=MODE_TYPE)
    _MBS_BeaconMeasElement_r13_transmitterID_r13 = INT(name=u'transmitterID-r13', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MBS_BeaconMeasElement_r13_transmitterID_r13._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=32767)], ev=None, er=[])
    _MBS_BeaconMeasElement_r13_codePhase_r13 = INT(name=u'codePhase-r13', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MBS_BeaconMeasElement_r13_codePhase_r13._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=2097151)], ev=None, er=[])
    _MBS_BeaconMeasElement_r13_codePhaseRMSError_r13 = INT(name=u'codePhaseRMSError-r13', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MBS_BeaconMeasElement_r13_codePhaseRMSError_r13._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    MBS_BeaconMeasElement_r13._cont = ASN1Dict([
        (u'transmitterID-r13', _MBS_BeaconMeasElement_r13_transmitterID_r13),
        (u'codePhase-r13', _MBS_BeaconMeasElement_r13_codePhase_r13),
        (u'codePhaseRMSError-r13', _MBS_BeaconMeasElement_r13_codePhaseRMSError_r13),
        ])
    MBS_BeaconMeasElement_r13._ext = []
    
    #-----< TBS-RequestLocationInformation-r13 >-----#
    TBS_RequestLocationInformation_r13 = SEQ(name=u'TBS-RequestLocationInformation-r13', mode=MODE_TYPE)
    _TBS_RequestLocationInformation_r13_mbsSgnMeasListReq_r13 = BOOL(name=u'mbsSgnMeasListReq-r13', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    TBS_RequestLocationInformation_r13._cont = ASN1Dict([
        (u'mbsSgnMeasListReq-r13', _TBS_RequestLocationInformation_r13_mbsSgnMeasListReq_r13),
        ])
    TBS_RequestLocationInformation_r13._ext = []
    
    #-----< TBS-ProvideCapabilities-r13 >-----#
    TBS_ProvideCapabilities_r13 = SEQ(name=u'TBS-ProvideCapabilities-r13', mode=MODE_TYPE)
    _TBS_ProvideCapabilities_r13_tbs_Modes_r13 = BIT_STR(name=u'tbs-Modes-r13', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _TBS_ProvideCapabilities_r13_tbs_Modes_r13._cont = ASN1Dict([(u'standalone', 0), (u'ue-assisted', 1)])
    _TBS_ProvideCapabilities_r13_tbs_Modes_r13._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    TBS_ProvideCapabilities_r13._cont = ASN1Dict([
        (u'tbs-Modes-r13', _TBS_ProvideCapabilities_r13_tbs_Modes_r13),
        ])
    TBS_ProvideCapabilities_r13._ext = []
    
    #-----< TBS-RequestCapabilities-r13 >-----#
    TBS_RequestCapabilities_r13 = SEQ(name=u'TBS-RequestCapabilities-r13', mode=MODE_TYPE)
    TBS_RequestCapabilities_r13._cont = ASN1Dict([
        ])
    TBS_RequestCapabilities_r13._ext = []
    
    #-----< TBS-Error-r13 >-----#
    TBS_Error_r13 = CHOICE(name=u'TBS-Error-r13', mode=MODE_TYPE)
    _TBS_Error_r13_locationServerErrorCauses_r13 = SEQ(name=u'locationServerErrorCauses-r13', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'TBS-LocationServerErrorCauses-r13')))
    _TBS_Error_r13_targetDeviceErrorCauses_r13 = SEQ(name=u'targetDeviceErrorCauses-r13', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'TBS-TargetDeviceErrorCauses-r13')))
    TBS_Error_r13._cont = ASN1Dict([
        (u'locationServerErrorCauses-r13', _TBS_Error_r13_locationServerErrorCauses_r13),
        (u'targetDeviceErrorCauses-r13', _TBS_Error_r13_targetDeviceErrorCauses_r13),
        ])
    TBS_Error_r13._ext = []
    
    #-----< TBS-LocationServerErrorCauses-r13 >-----#
    TBS_LocationServerErrorCauses_r13 = SEQ(name=u'TBS-LocationServerErrorCauses-r13', mode=MODE_TYPE)
    _TBS_LocationServerErrorCauses_r13_cause_r13 = ENUM(name=u'cause-r13', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _TBS_LocationServerErrorCauses_r13_cause_r13._cont = ASN1Dict([(u'undefined', 0)])
    _TBS_LocationServerErrorCauses_r13_cause_r13._ext = []
    TBS_LocationServerErrorCauses_r13._cont = ASN1Dict([
        (u'cause-r13', _TBS_LocationServerErrorCauses_r13_cause_r13),
        ])
    TBS_LocationServerErrorCauses_r13._ext = []
    
    #-----< TBS-TargetDeviceErrorCauses-r13 >-----#
    TBS_TargetDeviceErrorCauses_r13 = SEQ(name=u'TBS-TargetDeviceErrorCauses-r13', mode=MODE_TYPE)
    _TBS_TargetDeviceErrorCauses_r13_cause_r13 = ENUM(name=u'cause-r13', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _TBS_TargetDeviceErrorCauses_r13_cause_r13._cont = ASN1Dict([(u'undefined', 0), (u'thereWereNotEnoughMBSBeaconsReceived', 1)])
    _TBS_TargetDeviceErrorCauses_r13_cause_r13._ext = []
    TBS_TargetDeviceErrorCauses_r13._cont = ASN1Dict([
        (u'cause-r13', _TBS_TargetDeviceErrorCauses_r13_cause_r13),
        ])
    TBS_TargetDeviceErrorCauses_r13._ext = []
    
    #-----< Sensor-ProvideLocationInformation-r13 >-----#
    Sensor_ProvideLocationInformation_r13 = SEQ(name=u'Sensor-ProvideLocationInformation-r13', mode=MODE_TYPE)
    _Sensor_ProvideLocationInformation_r13_sensor_MeasurementInformation_r13 = SEQ(name=u'sensor-MeasurementInformation-r13', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'Sensor-MeasurementInformation-r13')), opt=True)
    _Sensor_ProvideLocationInformation_r13_sensor_Error_r13 = CHOICE(name=u'sensor-Error-r13', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'Sensor-Error-r13')), opt=True)
    Sensor_ProvideLocationInformation_r13._cont = ASN1Dict([
        (u'sensor-MeasurementInformation-r13', _Sensor_ProvideLocationInformation_r13_sensor_MeasurementInformation_r13),
        (u'sensor-Error-r13', _Sensor_ProvideLocationInformation_r13_sensor_Error_r13),
        ])
    Sensor_ProvideLocationInformation_r13._ext = []
    
    #-----< Sensor-MeasurementInformation-r13 >-----#
    Sensor_MeasurementInformation_r13 = SEQ(name=u'Sensor-MeasurementInformation-r13', mode=MODE_TYPE)
    _Sensor_MeasurementInformation_r13_measurementReferenceTime_r13 = TIME_UTC(name=u'measurementReferenceTime-r13', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _Sensor_MeasurementInformation_r13_uncompensatedBarometricPressure_r13 = INT(name=u'uncompensatedBarometricPressure-r13', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _Sensor_MeasurementInformation_r13_uncompensatedBarometricPressure_r13._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=30000, ub=115000)], ev=None, er=[])
    Sensor_MeasurementInformation_r13._cont = ASN1Dict([
        (u'measurementReferenceTime-r13', _Sensor_MeasurementInformation_r13_measurementReferenceTime_r13),
        (u'uncompensatedBarometricPressure-r13', _Sensor_MeasurementInformation_r13_uncompensatedBarometricPressure_r13),
        ])
    Sensor_MeasurementInformation_r13._ext = []
    
    #-----< Sensor-RequestLocationInformation-r13 >-----#
    Sensor_RequestLocationInformation_r13 = SEQ(name=u'Sensor-RequestLocationInformation-r13', mode=MODE_TYPE)
    _Sensor_RequestLocationInformation_r13_uncompensatedBarometricPressureReq_r13 = BOOL(name=u'uncompensatedBarometricPressureReq-r13', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    Sensor_RequestLocationInformation_r13._cont = ASN1Dict([
        (u'uncompensatedBarometricPressureReq-r13', _Sensor_RequestLocationInformation_r13_uncompensatedBarometricPressureReq_r13),
        ])
    Sensor_RequestLocationInformation_r13._ext = []
    
    #-----< Sensor-ProvideCapabilities-r13 >-----#
    Sensor_ProvideCapabilities_r13 = SEQ(name=u'Sensor-ProvideCapabilities-r13', mode=MODE_TYPE)
    _Sensor_ProvideCapabilities_r13_sensor_Modes_r13 = BIT_STR(name=u'sensor-Modes-r13', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _Sensor_ProvideCapabilities_r13_sensor_Modes_r13._cont = ASN1Dict([(u'standalone', 0), (u'ue-assisted', 1)])
    _Sensor_ProvideCapabilities_r13_sensor_Modes_r13._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    Sensor_ProvideCapabilities_r13._cont = ASN1Dict([
        (u'sensor-Modes-r13', _Sensor_ProvideCapabilities_r13_sensor_Modes_r13),
        ])
    Sensor_ProvideCapabilities_r13._ext = []
    
    #-----< Sensor-RequestCapabilities-r13 >-----#
    Sensor_RequestCapabilities_r13 = SEQ(name=u'Sensor-RequestCapabilities-r13', mode=MODE_TYPE)
    Sensor_RequestCapabilities_r13._cont = ASN1Dict([
        ])
    Sensor_RequestCapabilities_r13._ext = []
    
    #-----< Sensor-Error-r13 >-----#
    Sensor_Error_r13 = CHOICE(name=u'Sensor-Error-r13', mode=MODE_TYPE)
    _Sensor_Error_r13_locationServerErrorCauses_r13 = SEQ(name=u'locationServerErrorCauses-r13', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'Sensor-LocationServerErrorCauses-r13')))
    _Sensor_Error_r13_targetDeviceErrorCauses_r13 = SEQ(name=u'targetDeviceErrorCauses-r13', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'Sensor-TargetDeviceErrorCauses-r13')))
    Sensor_Error_r13._cont = ASN1Dict([
        (u'locationServerErrorCauses-r13', _Sensor_Error_r13_locationServerErrorCauses_r13),
        (u'targetDeviceErrorCauses-r13', _Sensor_Error_r13_targetDeviceErrorCauses_r13),
        ])
    Sensor_Error_r13._ext = []
    
    #-----< Sensor-LocationServerErrorCauses-r13 >-----#
    Sensor_LocationServerErrorCauses_r13 = SEQ(name=u'Sensor-LocationServerErrorCauses-r13', mode=MODE_TYPE)
    _Sensor_LocationServerErrorCauses_r13_cause_r13 = ENUM(name=u'cause-r13', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _Sensor_LocationServerErrorCauses_r13_cause_r13._cont = ASN1Dict([(u'undefined', 0)])
    _Sensor_LocationServerErrorCauses_r13_cause_r13._ext = []
    Sensor_LocationServerErrorCauses_r13._cont = ASN1Dict([
        (u'cause-r13', _Sensor_LocationServerErrorCauses_r13_cause_r13),
        ])
    Sensor_LocationServerErrorCauses_r13._ext = []
    
    #-----< Sensor-TargetDeviceErrorCauses-r13 >-----#
    Sensor_TargetDeviceErrorCauses_r13 = SEQ(name=u'Sensor-TargetDeviceErrorCauses-r13', mode=MODE_TYPE)
    _Sensor_TargetDeviceErrorCauses_r13_cause_r13 = ENUM(name=u'cause-r13', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _Sensor_TargetDeviceErrorCauses_r13_cause_r13._cont = ASN1Dict([(u'undefined', 0)])
    _Sensor_TargetDeviceErrorCauses_r13_cause_r13._ext = []
    Sensor_TargetDeviceErrorCauses_r13._cont = ASN1Dict([
        (u'cause-r13', _Sensor_TargetDeviceErrorCauses_r13_cause_r13),
        ])
    Sensor_TargetDeviceErrorCauses_r13._ext = []
    
    #-----< WLAN-ProvideLocationInformation-r13 >-----#
    WLAN_ProvideLocationInformation_r13 = SEQ(name=u'WLAN-ProvideLocationInformation-r13', mode=MODE_TYPE)
    _WLAN_ProvideLocationInformation_r13_wlan_MeasurementInformation_r13 = SEQ(name=u'wlan-MeasurementInformation-r13', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'WLAN-MeasurementInformation-r13')), opt=True)
    _WLAN_ProvideLocationInformation_r13_wlan_Error_r13 = CHOICE(name=u'wlan-Error-r13', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'WLAN-Error-r13')), opt=True)
    WLAN_ProvideLocationInformation_r13._cont = ASN1Dict([
        (u'wlan-MeasurementInformation-r13', _WLAN_ProvideLocationInformation_r13_wlan_MeasurementInformation_r13),
        (u'wlan-Error-r13', _WLAN_ProvideLocationInformation_r13_wlan_Error_r13),
        ])
    WLAN_ProvideLocationInformation_r13._ext = []
    
    #-----< WLAN-MeasurementInformation-r13 >-----#
    WLAN_MeasurementInformation_r13 = SEQ(name=u'WLAN-MeasurementInformation-r13', mode=MODE_TYPE)
    _WLAN_MeasurementInformation_r13_measurementReferenceTime_r13 = TIME_UTC(name=u'measurementReferenceTime-r13', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _WLAN_MeasurementInformation_r13_wlan_MeasurementList_r13 = SEQ_OF(name=u'wlan-MeasurementList-r13', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'WLAN-MeasurementList-r13')), opt=True)
    WLAN_MeasurementInformation_r13._cont = ASN1Dict([
        (u'measurementReferenceTime-r13', _WLAN_MeasurementInformation_r13_measurementReferenceTime_r13),
        (u'wlan-MeasurementList-r13', _WLAN_MeasurementInformation_r13_wlan_MeasurementList_r13),
        ])
    WLAN_MeasurementInformation_r13._ext = []
    
    #-----< WLAN-MeasurementList-r13 >-----#
    WLAN_MeasurementList_r13 = SEQ_OF(name=u'WLAN-MeasurementList-r13', mode=MODE_TYPE)
    _WLAN_MeasurementList_r13__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('LPP-PDU-Definitions', 'WLAN-MeasurementElement-r13')))
    WLAN_MeasurementList_r13._cont = _WLAN_MeasurementList_r13__item_
    WLAN_MeasurementList_r13._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    
    #-----< WLAN-MeasurementElement-r13 >-----#
    WLAN_MeasurementElement_r13 = SEQ(name=u'WLAN-MeasurementElement-r13', mode=MODE_TYPE)
    _WLAN_MeasurementElement_r13_wlan_AP_Identifier_r13 = SEQ(name=u'wlan-AP-Identifier-r13', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'WLAN-AP-Identifier-r13')))
    _WLAN_MeasurementElement_r13_rssi_r13 = INT(name=u'rssi-r13', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _WLAN_MeasurementElement_r13_rssi_r13._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-127, ub=128)], ev=None, er=[])
    _WLAN_MeasurementElement_r13_rtt_r13 = SEQ(name=u'rtt-r13', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'WLAN-RTT-r13')), opt=True)
    _WLAN_MeasurementElement_r13_apChannelFrequency_r13 = INT(name=u'apChannelFrequency-r13', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _WLAN_MeasurementElement_r13_apChannelFrequency_r13._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=256)], ev=None, er=[])
    _WLAN_MeasurementElement_r13_servingFlag_r13 = BOOL(name=u'servingFlag-r13', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    WLAN_MeasurementElement_r13._cont = ASN1Dict([
        (u'wlan-AP-Identifier-r13', _WLAN_MeasurementElement_r13_wlan_AP_Identifier_r13),
        (u'rssi-r13', _WLAN_MeasurementElement_r13_rssi_r13),
        (u'rtt-r13', _WLAN_MeasurementElement_r13_rtt_r13),
        (u'apChannelFrequency-r13', _WLAN_MeasurementElement_r13_apChannelFrequency_r13),
        (u'servingFlag-r13', _WLAN_MeasurementElement_r13_servingFlag_r13),
        ])
    WLAN_MeasurementElement_r13._ext = []
    
    #-----< WLAN-AP-Identifier-r13 >-----#
    WLAN_AP_Identifier_r13 = SEQ(name=u'WLAN-AP-Identifier-r13', mode=MODE_TYPE)
    _WLAN_AP_Identifier_r13_bssid_r13 = OCT_STR(name=u'bssid-r13', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _WLAN_AP_Identifier_r13_bssid_r13._const_sz = ASN1Set(rv=[6], rr=[], ev=None, er=[])
    _WLAN_AP_Identifier_r13_ssid_r13 = OCT_STR(name=u'ssid-r13', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _WLAN_AP_Identifier_r13_ssid_r13._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    WLAN_AP_Identifier_r13._cont = ASN1Dict([
        (u'bssid-r13', _WLAN_AP_Identifier_r13_bssid_r13),
        (u'ssid-r13', _WLAN_AP_Identifier_r13_ssid_r13),
        ])
    WLAN_AP_Identifier_r13._ext = []
    
    #-----< WLAN-RTT-r13 >-----#
    WLAN_RTT_r13 = SEQ(name=u'WLAN-RTT-r13', mode=MODE_TYPE)
    _WLAN_RTT_r13_rttValue_r13 = INT(name=u'rttValue-r13', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _WLAN_RTT_r13_rttValue_r13._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=16777215)], ev=None, er=[])
    _WLAN_RTT_r13_rttUnits_r13 = ENUM(name=u'rttUnits-r13', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _WLAN_RTT_r13_rttUnits_r13._cont = ASN1Dict([(u'microseconds', 0), (u'hundredsofnanoseconds', 1), (u'tensofnanoseconds', 2), (u'nanoseconds', 3), (u'tenthsofnanoseconds', 4)])
    _WLAN_RTT_r13_rttUnits_r13._ext = []
    _WLAN_RTT_r13_rttAccuracy_r13 = INT(name=u'rttAccuracy-r13', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _WLAN_RTT_r13_rttAccuracy_r13._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    WLAN_RTT_r13._cont = ASN1Dict([
        (u'rttValue-r13', _WLAN_RTT_r13_rttValue_r13),
        (u'rttUnits-r13', _WLAN_RTT_r13_rttUnits_r13),
        (u'rttAccuracy-r13', _WLAN_RTT_r13_rttAccuracy_r13),
        ])
    WLAN_RTT_r13._ext = []
    
    #-----< maxWLAN-AP-r13 >-----#
    maxWLAN_AP_r13 = INT(name=u'maxWLAN-AP-r13', mode=MODE_VALUE)
    maxWLAN_AP_r13._val = 64
    
    #-----< WLAN-RequestLocationInformation-r13 >-----#
    WLAN_RequestLocationInformation_r13 = SEQ(name=u'WLAN-RequestLocationInformation-r13', mode=MODE_TYPE)
    _WLAN_RequestLocationInformation_r13_requestedMeasurements_r13 = BIT_STR(name=u'requestedMeasurements-r13', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _WLAN_RequestLocationInformation_r13_requestedMeasurements_r13._cont = ASN1Dict([(u'rssi', 0), (u'rtt', 1)])
    _WLAN_RequestLocationInformation_r13_requestedMeasurements_r13._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    WLAN_RequestLocationInformation_r13._cont = ASN1Dict([
        (u'requestedMeasurements-r13', _WLAN_RequestLocationInformation_r13_requestedMeasurements_r13),
        ])
    WLAN_RequestLocationInformation_r13._ext = []
    
    #-----< WLAN-ProvideCapabilities-r13 >-----#
    WLAN_ProvideCapabilities_r13 = SEQ(name=u'WLAN-ProvideCapabilities-r13', mode=MODE_TYPE)
    _WLAN_ProvideCapabilities_r13_wlan_Modes_r13 = BIT_STR(name=u'wlan-Modes-r13', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _WLAN_ProvideCapabilities_r13_wlan_Modes_r13._cont = ASN1Dict([(u'standalone', 0), (u'ue-assisted', 1)])
    _WLAN_ProvideCapabilities_r13_wlan_Modes_r13._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    _WLAN_ProvideCapabilities_r13_wlan_MeasSupported_r13 = BIT_STR(name=u'wlan-MeasSupported-r13', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _WLAN_ProvideCapabilities_r13_wlan_MeasSupported_r13._cont = ASN1Dict([(u'rssi-r13', 0), (u'rtt-r13', 1)])
    _WLAN_ProvideCapabilities_r13_wlan_MeasSupported_r13._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    WLAN_ProvideCapabilities_r13._cont = ASN1Dict([
        (u'wlan-Modes-r13', _WLAN_ProvideCapabilities_r13_wlan_Modes_r13),
        (u'wlan-MeasSupported-r13', _WLAN_ProvideCapabilities_r13_wlan_MeasSupported_r13),
        ])
    WLAN_ProvideCapabilities_r13._ext = []
    
    #-----< WLAN-RequestCapabilities-r13 >-----#
    WLAN_RequestCapabilities_r13 = SEQ(name=u'WLAN-RequestCapabilities-r13', mode=MODE_TYPE)
    WLAN_RequestCapabilities_r13._cont = ASN1Dict([
        ])
    WLAN_RequestCapabilities_r13._ext = []
    
    #-----< WLAN-Error-r13 >-----#
    WLAN_Error_r13 = CHOICE(name=u'WLAN-Error-r13', mode=MODE_TYPE)
    _WLAN_Error_r13_locationServerErrorCauses_r13 = SEQ(name=u'locationServerErrorCauses-r13', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'WLAN-LocationServerErrorCauses-r13')))
    _WLAN_Error_r13_targetDeviceErrorCauses_r13 = SEQ(name=u'targetDeviceErrorCauses-r13', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'WLAN-TargetDeviceErrorCauses-r13')))
    WLAN_Error_r13._cont = ASN1Dict([
        (u'locationServerErrorCauses-r13', _WLAN_Error_r13_locationServerErrorCauses_r13),
        (u'targetDeviceErrorCauses-r13', _WLAN_Error_r13_targetDeviceErrorCauses_r13),
        ])
    WLAN_Error_r13._ext = []
    
    #-----< WLAN-LocationServerErrorCauses-r13 >-----#
    WLAN_LocationServerErrorCauses_r13 = SEQ(name=u'WLAN-LocationServerErrorCauses-r13', mode=MODE_TYPE)
    _WLAN_LocationServerErrorCauses_r13_cause_r13 = ENUM(name=u'cause-r13', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _WLAN_LocationServerErrorCauses_r13_cause_r13._cont = ASN1Dict([(u'undefined', 0)])
    _WLAN_LocationServerErrorCauses_r13_cause_r13._ext = []
    WLAN_LocationServerErrorCauses_r13._cont = ASN1Dict([
        (u'cause-r13', _WLAN_LocationServerErrorCauses_r13_cause_r13),
        ])
    WLAN_LocationServerErrorCauses_r13._ext = []
    
    #-----< WLAN-TargetDeviceErrorCauses-r13 >-----#
    WLAN_TargetDeviceErrorCauses_r13 = SEQ(name=u'WLAN-TargetDeviceErrorCauses-r13', mode=MODE_TYPE)
    _WLAN_TargetDeviceErrorCauses_r13_cause_r13 = ENUM(name=u'cause-r13', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _WLAN_TargetDeviceErrorCauses_r13_cause_r13._cont = ASN1Dict([(u'undefined', 0), (u'requestedMeasurementsNotAvailable', 1), (u'notAllrequestedMeasurementsPossible', 2)])
    _WLAN_TargetDeviceErrorCauses_r13_cause_r13._ext = []
    _WLAN_TargetDeviceErrorCauses_r13_wlan_AP_RSSI_MeasurementNotPossible_r13 = NULL(name=u'wlan-AP-RSSI-MeasurementNotPossible-r13', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _WLAN_TargetDeviceErrorCauses_r13_wlan_AP_RTT_MeasurementNotPossible_r13 = NULL(name=u'wlan-AP-RTT-MeasurementNotPossible-r13', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    WLAN_TargetDeviceErrorCauses_r13._cont = ASN1Dict([
        (u'cause-r13', _WLAN_TargetDeviceErrorCauses_r13_cause_r13),
        (u'wlan-AP-RSSI-MeasurementNotPossible-r13', _WLAN_TargetDeviceErrorCauses_r13_wlan_AP_RSSI_MeasurementNotPossible_r13),
        (u'wlan-AP-RTT-MeasurementNotPossible-r13', _WLAN_TargetDeviceErrorCauses_r13_wlan_AP_RTT_MeasurementNotPossible_r13),
        ])
    WLAN_TargetDeviceErrorCauses_r13._ext = []
    
    #-----< BT-ProvideLocationInformation-r13 >-----#
    BT_ProvideLocationInformation_r13 = SEQ(name=u'BT-ProvideLocationInformation-r13', mode=MODE_TYPE)
    _BT_ProvideLocationInformation_r13_bt_MeasurementInformation_r13 = SEQ(name=u'bt-MeasurementInformation-r13', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'BT-MeasurementInformation-r13')), opt=True)
    _BT_ProvideLocationInformation_r13_bt_Error_r13 = CHOICE(name=u'bt-Error-r13', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'BT-Error-r13')), opt=True)
    BT_ProvideLocationInformation_r13._cont = ASN1Dict([
        (u'bt-MeasurementInformation-r13', _BT_ProvideLocationInformation_r13_bt_MeasurementInformation_r13),
        (u'bt-Error-r13', _BT_ProvideLocationInformation_r13_bt_Error_r13),
        ])
    BT_ProvideLocationInformation_r13._ext = []
    
    #-----< BT-MeasurementInformation-r13 >-----#
    BT_MeasurementInformation_r13 = SEQ(name=u'BT-MeasurementInformation-r13', mode=MODE_TYPE)
    _BT_MeasurementInformation_r13_measurementReferenceTime_r13 = TIME_UTC(name=u'measurementReferenceTime-r13', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _BT_MeasurementInformation_r13_bt_MeasurementList_r13 = SEQ_OF(name=u'bt-MeasurementList-r13', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'BT-MeasurementList-r13')), opt=True)
    BT_MeasurementInformation_r13._cont = ASN1Dict([
        (u'measurementReferenceTime-r13', _BT_MeasurementInformation_r13_measurementReferenceTime_r13),
        (u'bt-MeasurementList-r13', _BT_MeasurementInformation_r13_bt_MeasurementList_r13),
        ])
    BT_MeasurementInformation_r13._ext = []
    
    #-----< BT-MeasurementList-r13 >-----#
    BT_MeasurementList_r13 = SEQ_OF(name=u'BT-MeasurementList-r13', mode=MODE_TYPE)
    _BT_MeasurementList_r13__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('LPP-PDU-Definitions', 'BT-MeasurementElement-r13')))
    BT_MeasurementList_r13._cont = _BT_MeasurementList_r13__item_
    BT_MeasurementList_r13._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    
    #-----< BT-MeasurementElement-r13 >-----#
    BT_MeasurementElement_r13 = SEQ(name=u'BT-MeasurementElement-r13', mode=MODE_TYPE)
    _BT_MeasurementElement_r13_btAddr_r13 = BIT_STR(name=u'btAddr-r13', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _BT_MeasurementElement_r13_btAddr_r13._const_sz = ASN1Set(rv=[48], rr=[], ev=None, er=[])
    _BT_MeasurementElement_r13_rssi_r13 = INT(name=u'rssi-r13', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _BT_MeasurementElement_r13_rssi_r13._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-128, ub=127)], ev=None, er=[])
    BT_MeasurementElement_r13._cont = ASN1Dict([
        (u'btAddr-r13', _BT_MeasurementElement_r13_btAddr_r13),
        (u'rssi-r13', _BT_MeasurementElement_r13_rssi_r13),
        ])
    BT_MeasurementElement_r13._ext = []
    
    #-----< maxBT-Beacon-r13 >-----#
    maxBT_Beacon_r13 = INT(name=u'maxBT-Beacon-r13', mode=MODE_VALUE)
    maxBT_Beacon_r13._val = 32
    
    #-----< BT-RequestLocationInformation-r13 >-----#
    BT_RequestLocationInformation_r13 = SEQ(name=u'BT-RequestLocationInformation-r13', mode=MODE_TYPE)
    _BT_RequestLocationInformation_r13_requestedMeasurements_r13 = BIT_STR(name=u'requestedMeasurements-r13', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _BT_RequestLocationInformation_r13_requestedMeasurements_r13._cont = ASN1Dict([(u'rssi', 0)])
    _BT_RequestLocationInformation_r13_requestedMeasurements_r13._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    BT_RequestLocationInformation_r13._cont = ASN1Dict([
        (u'requestedMeasurements-r13', _BT_RequestLocationInformation_r13_requestedMeasurements_r13),
        ])
    BT_RequestLocationInformation_r13._ext = []
    
    #-----< BT-ProvideCapabilities-r13 >-----#
    BT_ProvideCapabilities_r13 = SEQ(name=u'BT-ProvideCapabilities-r13', mode=MODE_TYPE)
    _BT_ProvideCapabilities_r13_bt_Modes_r13 = BIT_STR(name=u'bt-Modes-r13', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _BT_ProvideCapabilities_r13_bt_Modes_r13._cont = ASN1Dict([(u'standalone', 0), (u'ue-assisted', 1)])
    _BT_ProvideCapabilities_r13_bt_Modes_r13._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    _BT_ProvideCapabilities_r13_bt_MeasSupported_r13 = BIT_STR(name=u'bt-MeasSupported-r13', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _BT_ProvideCapabilities_r13_bt_MeasSupported_r13._cont = ASN1Dict([(u'rssi-r13', 0)])
    _BT_ProvideCapabilities_r13_bt_MeasSupported_r13._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    BT_ProvideCapabilities_r13._cont = ASN1Dict([
        (u'bt-Modes-r13', _BT_ProvideCapabilities_r13_bt_Modes_r13),
        (u'bt-MeasSupported-r13', _BT_ProvideCapabilities_r13_bt_MeasSupported_r13),
        ])
    BT_ProvideCapabilities_r13._ext = []
    
    #-----< BT-RequestCapabilities-r13 >-----#
    BT_RequestCapabilities_r13 = SEQ(name=u'BT-RequestCapabilities-r13', mode=MODE_TYPE)
    BT_RequestCapabilities_r13._cont = ASN1Dict([
        ])
    BT_RequestCapabilities_r13._ext = []
    
    #-----< BT-Error-r13 >-----#
    BT_Error_r13 = CHOICE(name=u'BT-Error-r13', mode=MODE_TYPE)
    _BT_Error_r13_locationServerErrorCauses_r13 = SEQ(name=u'locationServerErrorCauses-r13', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'BT-LocationServerErrorCauses-r13')))
    _BT_Error_r13_targetDeviceErrorCauses_r13 = SEQ(name=u'targetDeviceErrorCauses-r13', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'BT-TargetDeviceErrorCauses-r13')))
    BT_Error_r13._cont = ASN1Dict([
        (u'locationServerErrorCauses-r13', _BT_Error_r13_locationServerErrorCauses_r13),
        (u'targetDeviceErrorCauses-r13', _BT_Error_r13_targetDeviceErrorCauses_r13),
        ])
    BT_Error_r13._ext = []
    
    #-----< BT-LocationServerErrorCauses-r13 >-----#
    BT_LocationServerErrorCauses_r13 = SEQ(name=u'BT-LocationServerErrorCauses-r13', mode=MODE_TYPE)
    _BT_LocationServerErrorCauses_r13_cause_r13 = ENUM(name=u'cause-r13', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _BT_LocationServerErrorCauses_r13_cause_r13._cont = ASN1Dict([(u'undefined', 0)])
    _BT_LocationServerErrorCauses_r13_cause_r13._ext = []
    BT_LocationServerErrorCauses_r13._cont = ASN1Dict([
        (u'cause-r13', _BT_LocationServerErrorCauses_r13_cause_r13),
        ])
    BT_LocationServerErrorCauses_r13._ext = []
    
    #-----< BT-TargetDeviceErrorCauses-r13 >-----#
    BT_TargetDeviceErrorCauses_r13 = SEQ(name=u'BT-TargetDeviceErrorCauses-r13', mode=MODE_TYPE)
    _BT_TargetDeviceErrorCauses_r13_cause_r13 = ENUM(name=u'cause-r13', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _BT_TargetDeviceErrorCauses_r13_cause_r13._cont = ASN1Dict([(u'undefined', 0), (u'requestedMeasurementsNotAvailable', 1), (u'notAllrequestedMeasurementsPossible', 2)])
    _BT_TargetDeviceErrorCauses_r13_cause_r13._ext = []
    _BT_TargetDeviceErrorCauses_r13_bt_Beacon_rssiMeasurementNotPossible_r13 = NULL(name=u'bt-Beacon-rssiMeasurementNotPossible-r13', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    BT_TargetDeviceErrorCauses_r13._cont = ASN1Dict([
        (u'cause-r13', _BT_TargetDeviceErrorCauses_r13_cause_r13),
        (u'bt-Beacon-rssiMeasurementNotPossible-r13', _BT_TargetDeviceErrorCauses_r13_bt_Beacon_rssiMeasurementNotPossible_r13),
        ])
    BT_TargetDeviceErrorCauses_r13._ext = []
    
    _all_ = [
        _LPP_Message_transactionID,
        _LPP_Message_endTransaction,
        _LPP_Message_sequenceNumber,
        _LPP_Message_acknowledgement,
        _LPP_Message_lpp_MessageBody,
        LPP_Message,
        SequenceNumber,
        _Acknowledgement_ackRequested,
        _Acknowledgement_ackIndicator,
        Acknowledgement,
        __LPP_MessageBody_c1_requestCapabilities,
        __LPP_MessageBody_c1_provideCapabilities,
        __LPP_MessageBody_c1_requestAssistanceData,
        __LPP_MessageBody_c1_provideAssistanceData,
        __LPP_MessageBody_c1_requestLocationInformation,
        __LPP_MessageBody_c1_provideLocationInformation,
        __LPP_MessageBody_c1_abort,
        __LPP_MessageBody_c1_error,
        __LPP_MessageBody_c1_spare7,
        __LPP_MessageBody_c1_spare6,
        __LPP_MessageBody_c1_spare5,
        __LPP_MessageBody_c1_spare4,
        __LPP_MessageBody_c1_spare3,
        __LPP_MessageBody_c1_spare2,
        __LPP_MessageBody_c1_spare1,
        __LPP_MessageBody_c1_spare0,
        _LPP_MessageBody_c1,
        _LPP_MessageBody_messageClassExtension,
        LPP_MessageBody,
        _LPP_TransactionID_initiator,
        _LPP_TransactionID_transactionNumber,
        LPP_TransactionID,
        Initiator,
        TransactionNumber,
        ___RequestCapabilities_criticalExtensions_c1_requestCapabilities_r9,
        ___RequestCapabilities_criticalExtensions_c1_spare3,
        ___RequestCapabilities_criticalExtensions_c1_spare2,
        ___RequestCapabilities_criticalExtensions_c1_spare1,
        __RequestCapabilities_criticalExtensions_c1,
        __RequestCapabilities_criticalExtensions_criticalExtensionsFuture,
        _RequestCapabilities_criticalExtensions,
        RequestCapabilities,
        _RequestCapabilities_r9_IEs_commonIEsRequestCapabilities,
        _RequestCapabilities_r9_IEs_a_gnss_RequestCapabilities,
        _RequestCapabilities_r9_IEs_otdoa_RequestCapabilities,
        _RequestCapabilities_r9_IEs_ecid_RequestCapabilities,
        _RequestCapabilities_r9_IEs_epdu_RequestCapabilities,
        _RequestCapabilities_r9_IEs_sensor_RequestCapabilities_r13,
        _RequestCapabilities_r9_IEs_tbs_RequestCapabilities_r13,
        _RequestCapabilities_r9_IEs_wlan_RequestCapabilities_r13,
        _RequestCapabilities_r9_IEs_bt_RequestCapabilities_r13,
        RequestCapabilities_r9_IEs,
        ___ProvideCapabilities_criticalExtensions_c1_provideCapabilities_r9,
        ___ProvideCapabilities_criticalExtensions_c1_spare3,
        ___ProvideCapabilities_criticalExtensions_c1_spare2,
        ___ProvideCapabilities_criticalExtensions_c1_spare1,
        __ProvideCapabilities_criticalExtensions_c1,
        __ProvideCapabilities_criticalExtensions_criticalExtensionsFuture,
        _ProvideCapabilities_criticalExtensions,
        ProvideCapabilities,
        _ProvideCapabilities_r9_IEs_commonIEsProvideCapabilities,
        _ProvideCapabilities_r9_IEs_a_gnss_ProvideCapabilities,
        _ProvideCapabilities_r9_IEs_otdoa_ProvideCapabilities,
        _ProvideCapabilities_r9_IEs_ecid_ProvideCapabilities,
        _ProvideCapabilities_r9_IEs_epdu_ProvideCapabilities,
        _ProvideCapabilities_r9_IEs_sensor_ProvideCapabilities_r13,
        _ProvideCapabilities_r9_IEs_tbs_ProvideCapabilities_r13,
        _ProvideCapabilities_r9_IEs_wlan_ProvideCapabilities_r13,
        _ProvideCapabilities_r9_IEs_bt_ProvideCapabilities_r13,
        ProvideCapabilities_r9_IEs,
        ___RequestAssistanceData_criticalExtensions_c1_requestAssistanceData_r9,
        ___RequestAssistanceData_criticalExtensions_c1_spare3,
        ___RequestAssistanceData_criticalExtensions_c1_spare2,
        ___RequestAssistanceData_criticalExtensions_c1_spare1,
        __RequestAssistanceData_criticalExtensions_c1,
        __RequestAssistanceData_criticalExtensions_criticalExtensionsFuture,
        _RequestAssistanceData_criticalExtensions,
        RequestAssistanceData,
        _RequestAssistanceData_r9_IEs_commonIEsRequestAssistanceData,
        _RequestAssistanceData_r9_IEs_a_gnss_RequestAssistanceData,
        _RequestAssistanceData_r9_IEs_otdoa_RequestAssistanceData,
        _RequestAssistanceData_r9_IEs_epdu_RequestAssistanceData,
        RequestAssistanceData_r9_IEs,
        ___ProvideAssistanceData_criticalExtensions_c1_provideAssistanceData_r9,
        ___ProvideAssistanceData_criticalExtensions_c1_spare3,
        ___ProvideAssistanceData_criticalExtensions_c1_spare2,
        ___ProvideAssistanceData_criticalExtensions_c1_spare1,
        __ProvideAssistanceData_criticalExtensions_c1,
        __ProvideAssistanceData_criticalExtensions_criticalExtensionsFuture,
        _ProvideAssistanceData_criticalExtensions,
        ProvideAssistanceData,
        _ProvideAssistanceData_r9_IEs_commonIEsProvideAssistanceData,
        _ProvideAssistanceData_r9_IEs_a_gnss_ProvideAssistanceData,
        _ProvideAssistanceData_r9_IEs_otdoa_ProvideAssistanceData,
        _ProvideAssistanceData_r9_IEs_epdu_Provide_Assistance_Data,
        ProvideAssistanceData_r9_IEs,
        ___RequestLocationInformation_criticalExtensions_c1_requestLocationInformation_r9,
        ___RequestLocationInformation_criticalExtensions_c1_spare3,
        ___RequestLocationInformation_criticalExtensions_c1_spare2,
        ___RequestLocationInformation_criticalExtensions_c1_spare1,
        __RequestLocationInformation_criticalExtensions_c1,
        __RequestLocationInformation_criticalExtensions_criticalExtensionsFuture,
        _RequestLocationInformation_criticalExtensions,
        RequestLocationInformation,
        _RequestLocationInformation_r9_IEs_commonIEsRequestLocationInformation,
        _RequestLocationInformation_r9_IEs_a_gnss_RequestLocationInformation,
        _RequestLocationInformation_r9_IEs_otdoa_RequestLocationInformation,
        _RequestLocationInformation_r9_IEs_ecid_RequestLocationInformation,
        _RequestLocationInformation_r9_IEs_epdu_RequestLocationInformation,
        _RequestLocationInformation_r9_IEs_sensor_RequestLocationInformation_r13,
        _RequestLocationInformation_r9_IEs_tbs_RequestLocationInformation_r13,
        _RequestLocationInformation_r9_IEs_wlan_RequestLocationInformation_r13,
        _RequestLocationInformation_r9_IEs_bt_RequestLocationInformation_r13,
        RequestLocationInformation_r9_IEs,
        ___ProvideLocationInformation_criticalExtensions_c1_provideLocationInformation_r9,
        ___ProvideLocationInformation_criticalExtensions_c1_spare3,
        ___ProvideLocationInformation_criticalExtensions_c1_spare2,
        ___ProvideLocationInformation_criticalExtensions_c1_spare1,
        __ProvideLocationInformation_criticalExtensions_c1,
        __ProvideLocationInformation_criticalExtensions_criticalExtensionsFuture,
        _ProvideLocationInformation_criticalExtensions,
        ProvideLocationInformation,
        _ProvideLocationInformation_r9_IEs_commonIEsProvideLocationInformation,
        _ProvideLocationInformation_r9_IEs_a_gnss_ProvideLocationInformation,
        _ProvideLocationInformation_r9_IEs_otdoa_ProvideLocationInformation,
        _ProvideLocationInformation_r9_IEs_ecid_ProvideLocationInformation,
        _ProvideLocationInformation_r9_IEs_epdu_ProvideLocationInformation,
        _ProvideLocationInformation_r9_IEs_sensor_ProvideLocationInformation_r13,
        _ProvideLocationInformation_r9_IEs_tbs_ProvideLocationInformation_r13,
        _ProvideLocationInformation_r9_IEs_wlan_ProvideLocationInformation_r13,
        _ProvideLocationInformation_r9_IEs_bt_ProvideLocationInformation_r13,
        ProvideLocationInformation_r9_IEs,
        ___Abort_criticalExtensions_c1_abort_r9,
        ___Abort_criticalExtensions_c1_spare3,
        ___Abort_criticalExtensions_c1_spare2,
        ___Abort_criticalExtensions_c1_spare1,
        __Abort_criticalExtensions_c1,
        __Abort_criticalExtensions_criticalExtensionsFuture,
        _Abort_criticalExtensions,
        Abort,
        _Abort_r9_IEs_commonIEsAbort,
        _Abort_r9_IEs_epdu_Abort,
        Abort_r9_IEs,
        _Error_error_r9,
        _Error_criticalExtensionsFuture,
        Error,
        _Error_r9_IEs_commonIEsError,
        _Error_r9_IEs_epdu_Error,
        Error_r9_IEs,
        _AccessTypes_accessTypes,
        AccessTypes,
        ARFCN_ValueEUTRA,
        ARFCN_ValueEUTRA_v9a0,
        maxEARFCN,
        maxEARFCN_Plus1,
        maxEARFCN2,
        ARFCN_ValueUTRA,
        ___CellGlobalIdEUTRA_AndUTRA_plmn_Identity_mcc__item_,
        __CellGlobalIdEUTRA_AndUTRA_plmn_Identity_mcc,
        ___CellGlobalIdEUTRA_AndUTRA_plmn_Identity_mnc__item_,
        __CellGlobalIdEUTRA_AndUTRA_plmn_Identity_mnc,
        _CellGlobalIdEUTRA_AndUTRA_plmn_Identity,
        __CellGlobalIdEUTRA_AndUTRA_cellIdentity_eutra,
        __CellGlobalIdEUTRA_AndUTRA_cellIdentity_utra,
        _CellGlobalIdEUTRA_AndUTRA_cellIdentity,
        CellGlobalIdEUTRA_AndUTRA,
        ___CellGlobalIdGERAN_plmn_Identity_mcc__item_,
        __CellGlobalIdGERAN_plmn_Identity_mcc,
        ___CellGlobalIdGERAN_plmn_Identity_mnc__item_,
        __CellGlobalIdGERAN_plmn_Identity_mnc,
        _CellGlobalIdGERAN_plmn_Identity,
        _CellGlobalIdGERAN_locationAreaCode,
        _CellGlobalIdGERAN_cellIdentity,
        CellGlobalIdGERAN,
        __ECGI_mcc__item_,
        _ECGI_mcc,
        __ECGI_mnc__item_,
        _ECGI_mnc,
        _ECGI_cellidentity,
        ECGI,
        _Ellipsoid_Point_latitudeSign,
        _Ellipsoid_Point_degreesLatitude,
        _Ellipsoid_Point_degreesLongitude,
        Ellipsoid_Point,
        _Ellipsoid_PointWithUncertaintyCircle_latitudeSign,
        _Ellipsoid_PointWithUncertaintyCircle_degreesLatitude,
        _Ellipsoid_PointWithUncertaintyCircle_degreesLongitude,
        _Ellipsoid_PointWithUncertaintyCircle_uncertainty,
        Ellipsoid_PointWithUncertaintyCircle,
        _EllipsoidPointWithUncertaintyEllipse_latitudeSign,
        _EllipsoidPointWithUncertaintyEllipse_degreesLatitude,
        _EllipsoidPointWithUncertaintyEllipse_degreesLongitude,
        _EllipsoidPointWithUncertaintyEllipse_uncertaintySemiMajor,
        _EllipsoidPointWithUncertaintyEllipse_uncertaintySemiMinor,
        _EllipsoidPointWithUncertaintyEllipse_orientationMajorAxis,
        _EllipsoidPointWithUncertaintyEllipse_confidence,
        EllipsoidPointWithUncertaintyEllipse,
        _EllipsoidPointWithAltitude_latitudeSign,
        _EllipsoidPointWithAltitude_degreesLatitude,
        _EllipsoidPointWithAltitude_degreesLongitude,
        _EllipsoidPointWithAltitude_altitudeDirection,
        _EllipsoidPointWithAltitude_altitude,
        EllipsoidPointWithAltitude,
        _EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_latitudeSign,
        _EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_degreesLatitude,
        _EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_degreesLongitude,
        _EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_altitudeDirection,
        _EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_altitude,
        _EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_uncertaintySemiMajor,
        _EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_uncertaintySemiMinor,
        _EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_orientationMajorAxis,
        _EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_uncertaintyAltitude,
        _EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_confidence,
        EllipsoidPointWithAltitudeAndUncertaintyEllipsoid,
        _EllipsoidArc_latitudeSign,
        _EllipsoidArc_degreesLatitude,
        _EllipsoidArc_degreesLongitude,
        _EllipsoidArc_innerRadius,
        _EllipsoidArc_uncertaintyRadius,
        _EllipsoidArc_offsetAngle,
        _EllipsoidArc_includedAngle,
        _EllipsoidArc_confidence,
        EllipsoidArc,
        _EPDU_Sequence__item_,
        EPDU_Sequence,
        maxEPDU,
        _EPDU_ePDU_Identifier,
        _EPDU_ePDU_Body,
        EPDU,
        _EPDU_Identifier_ePDU_ID,
        _EPDU_Identifier_ePDU_Name,
        EPDU_Identifier,
        EPDU_ID,
        EPDU_Name,
        EPDU_Body,
        _HorizontalVelocity_bearing,
        _HorizontalVelocity_horizontalSpeed,
        HorizontalVelocity,
        _HorizontalWithVerticalVelocity_bearing,
        _HorizontalWithVerticalVelocity_horizontalSpeed,
        _HorizontalWithVerticalVelocity_verticalDirection,
        _HorizontalWithVerticalVelocity_verticalSpeed,
        HorizontalWithVerticalVelocity,
        _HorizontalVelocityWithUncertainty_bearing,
        _HorizontalVelocityWithUncertainty_horizontalSpeed,
        _HorizontalVelocityWithUncertainty_uncertaintySpeed,
        HorizontalVelocityWithUncertainty,
        _HorizontalWithVerticalVelocityAndUncertainty_bearing,
        _HorizontalWithVerticalVelocityAndUncertainty_horizontalSpeed,
        _HorizontalWithVerticalVelocityAndUncertainty_verticalDirection,
        _HorizontalWithVerticalVelocityAndUncertainty_verticalSpeed,
        _HorizontalWithVerticalVelocityAndUncertainty_horizontalUncertaintySpeed,
        _HorizontalWithVerticalVelocityAndUncertainty_verticalUncertaintySpeed,
        HorizontalWithVerticalVelocityAndUncertainty,
        _LocationCoordinateTypes_ellipsoidPoint,
        _LocationCoordinateTypes_ellipsoidPointWithUncertaintyCircle,
        _LocationCoordinateTypes_ellipsoidPointWithUncertaintyEllipse,
        _LocationCoordinateTypes_polygon,
        _LocationCoordinateTypes_ellipsoidPointWithAltitude,
        _LocationCoordinateTypes_ellipsoidPointWithAltitudeAndUncertaintyEllipsoid,
        _LocationCoordinateTypes_ellipsoidArc,
        LocationCoordinateTypes,
        _Polygon__item_,
        Polygon,
        _PolygonPoints_latitudeSign,
        _PolygonPoints_degreesLatitude,
        _PolygonPoints_degreesLongitude,
        PolygonPoints,
        _PositioningModes_posModes,
        PositioningModes,
        _VelocityTypes_horizontalVelocity,
        _VelocityTypes_horizontalWithVerticalVelocity,
        _VelocityTypes_horizontalVelocityWithUncertainty,
        _VelocityTypes_horizontalWithVerticalVelocityAndUncertainty,
        VelocityTypes,
        CommonIEsRequestCapabilities,
        CommonIEsProvideCapabilities,
        _CommonIEsRequestAssistanceData_primaryCellID,
        CommonIEsRequestAssistanceData,
        CommonIEsProvideAssistanceData,
        _CommonIEsRequestLocationInformation_locationInformationType,
        _CommonIEsRequestLocationInformation_triggeredReporting,
        _CommonIEsRequestLocationInformation_periodicalReporting,
        _CommonIEsRequestLocationInformation_additionalInformation,
        _CommonIEsRequestLocationInformation_qos,
        _CommonIEsRequestLocationInformation_environment,
        _CommonIEsRequestLocationInformation_locationCoordinateTypes,
        _CommonIEsRequestLocationInformation_velocityTypes,
        CommonIEsRequestLocationInformation,
        LocationInformationType,
        _PeriodicalReportingCriteria_reportingAmount,
        _PeriodicalReportingCriteria_reportingInterval,
        PeriodicalReportingCriteria,
        _TriggeredReportingCriteria_cellChange,
        _TriggeredReportingCriteria_reportingDuration,
        TriggeredReportingCriteria,
        ReportingDuration,
        AdditionalInformation,
        _QoS_horizontalAccuracy,
        _QoS_verticalCoordinateRequest,
        _QoS_verticalAccuracy,
        _QoS_responseTime,
        _QoS_velocityRequest,
        QoS,
        _HorizontalAccuracy_accuracy,
        _HorizontalAccuracy_confidence,
        HorizontalAccuracy,
        _VerticalAccuracy_accuracy,
        _VerticalAccuracy_confidence,
        VerticalAccuracy,
        _ResponseTime_time,
        _ResponseTime_responseTimeEarlyFix_r12,
        ResponseTime,
        Environment,
        _CommonIEsProvideLocationInformation_locationEstimate,
        _CommonIEsProvideLocationInformation_velocityEstimate,
        _CommonIEsProvideLocationInformation_locationError,
        _CommonIEsProvideLocationInformation_earlyFixReport_r12,
        _CommonIEsProvideLocationInformation_locationSource_r13,
        _CommonIEsProvideLocationInformation_locationTimestamp_r13,
        CommonIEsProvideLocationInformation,
        _LocationCoordinates_ellipsoidPoint,
        _LocationCoordinates_ellipsoidPointWithUncertaintyCircle,
        _LocationCoordinates_ellipsoidPointWithUncertaintyEllipse,
        _LocationCoordinates_polygon,
        _LocationCoordinates_ellipsoidPointWithAltitude,
        _LocationCoordinates_ellipsoidPointWithAltitudeAndUncertaintyEllipsoid,
        _LocationCoordinates_ellipsoidArc,
        LocationCoordinates,
        _Velocity_horizontalVelocity,
        _Velocity_horizontalWithVerticalVelocity,
        _Velocity_horizontalVelocityWithUncertainty,
        _Velocity_horizontalWithVerticalVelocityAndUncertainty,
        Velocity,
        _LocationError_locationfailurecause,
        LocationError,
        LocationFailureCause,
        EarlyFixReport_r12,
        LocationSource_r13,
        _CommonIEsAbort_abortCause,
        CommonIEsAbort,
        _CommonIEsError_errorCause,
        CommonIEsError,
        _OTDOA_ProvideAssistanceData_otdoa_ReferenceCellInfo,
        _OTDOA_ProvideAssistanceData_otdoa_NeighbourCellInfo,
        _OTDOA_ProvideAssistanceData_otdoa_Error,
        OTDOA_ProvideAssistanceData,
        _OTDOA_ReferenceCellInfo_physCellId,
        _OTDOA_ReferenceCellInfo_cellGlobalId,
        _OTDOA_ReferenceCellInfo_earfcnRef,
        _OTDOA_ReferenceCellInfo_antennaPortConfig,
        _OTDOA_ReferenceCellInfo_cpLength,
        _OTDOA_ReferenceCellInfo_prsInfo,
        _OTDOA_ReferenceCellInfo_earfcnRef_v9a0,
        OTDOA_ReferenceCellInfo,
        _PRS_Info_prs_Bandwidth,
        _PRS_Info_prs_ConfigurationIndex,
        _PRS_Info_numDL_Frames,
        __PRS_Info_prs_MutingInfo_r9_po2_r9,
        __PRS_Info_prs_MutingInfo_r9_po4_r9,
        __PRS_Info_prs_MutingInfo_r9_po8_r9,
        __PRS_Info_prs_MutingInfo_r9_po16_r9,
        _PRS_Info_prs_MutingInfo_r9,
        PRS_Info,
        _OTDOA_NeighbourCellInfoList__item_,
        OTDOA_NeighbourCellInfoList,
        _OTDOA_NeighbourFreqInfo__item_,
        OTDOA_NeighbourFreqInfo,
        _OTDOA_NeighbourCellInfoElement_physCellId,
        _OTDOA_NeighbourCellInfoElement_cellGlobalId,
        _OTDOA_NeighbourCellInfoElement_earfcn,
        _OTDOA_NeighbourCellInfoElement_cpLength,
        _OTDOA_NeighbourCellInfoElement_prsInfo,
        _OTDOA_NeighbourCellInfoElement_antennaPortConfig,
        _OTDOA_NeighbourCellInfoElement_slotNumberOffset,
        _OTDOA_NeighbourCellInfoElement_prs_SubframeOffset,
        _OTDOA_NeighbourCellInfoElement_expectedRSTD,
        _OTDOA_NeighbourCellInfoElement_expectedRSTD_Uncertainty,
        _OTDOA_NeighbourCellInfoElement_earfcn_v9a0,
        OTDOA_NeighbourCellInfoElement,
        maxFreqLayers,
        _OTDOA_RequestAssistanceData_physCellId,
        OTDOA_RequestAssistanceData,
        _OTDOA_ProvideLocationInformation_otdoaSignalMeasurementInformation,
        _OTDOA_ProvideLocationInformation_otdoa_Error,
        OTDOA_ProvideLocationInformation,
        _OTDOA_SignalMeasurementInformation_systemFrameNumber,
        _OTDOA_SignalMeasurementInformation_physCellIdRef,
        _OTDOA_SignalMeasurementInformation_cellGlobalIdRef,
        _OTDOA_SignalMeasurementInformation_earfcnRef,
        _OTDOA_SignalMeasurementInformation_referenceQuality,
        _OTDOA_SignalMeasurementInformation_neighbourMeasurementList,
        _OTDOA_SignalMeasurementInformation_earfcnRef_v9a0,
        OTDOA_SignalMeasurementInformation,
        _NeighbourMeasurementList__item_,
        NeighbourMeasurementList,
        _NeighbourMeasurementElement_physCellIdNeighbour,
        _NeighbourMeasurementElement_cellGlobalIdNeighbour,
        _NeighbourMeasurementElement_earfcnNeighbour,
        _NeighbourMeasurementElement_rstd,
        _NeighbourMeasurementElement_rstd_Quality,
        _NeighbourMeasurementElement_earfcnNeighbour_v9a0,
        NeighbourMeasurementElement,
        _OTDOA_MeasQuality_error_Resolution,
        _OTDOA_MeasQuality_error_Value,
        _OTDOA_MeasQuality_error_NumSamples,
        OTDOA_MeasQuality,
        _OTDOA_RequestLocationInformation_assistanceAvailability,
        OTDOA_RequestLocationInformation,
        _OTDOA_ProvideCapabilities_otdoa_Mode,
        __OTDOA_ProvideCapabilities_supportedBandListEUTRA__item_,
        _OTDOA_ProvideCapabilities_supportedBandListEUTRA,
        __OTDOA_ProvideCapabilities_supportedBandListEUTRA_v9a0__item_,
        _OTDOA_ProvideCapabilities_supportedBandListEUTRA_v9a0,
        _OTDOA_ProvideCapabilities_interFreqRSTDmeasurement_r10,
        _OTDOA_ProvideCapabilities_additionalNeighbourCellInfoList_r10,
        OTDOA_ProvideCapabilities,
        maxBands,
        _SupportedBandEUTRA_bandEUTRA,
        SupportedBandEUTRA,
        _SupportedBandEUTRA_v9a0_bandEUTRA_v9a0,
        SupportedBandEUTRA_v9a0,
        maxFBI,
        maxFBI_Plus1,
        maxFBI2,
        OTDOA_RequestCapabilities,
        _OTDOA_Error_locationServerErrorCauses,
        _OTDOA_Error_targetDeviceErrorCauses,
        OTDOA_Error,
        _OTDOA_LocationServerErrorCauses_cause,
        OTDOA_LocationServerErrorCauses,
        _OTDOA_TargetDeviceErrorCauses_cause,
        OTDOA_TargetDeviceErrorCauses,
        _A_GNSS_ProvideAssistanceData_gnss_CommonAssistData,
        _A_GNSS_ProvideAssistanceData_gnss_GenericAssistData,
        _A_GNSS_ProvideAssistanceData_gnss_Error,
        A_GNSS_ProvideAssistanceData,
        _GNSS_CommonAssistData_gnss_ReferenceTime,
        _GNSS_CommonAssistData_gnss_ReferenceLocation,
        _GNSS_CommonAssistData_gnss_IonosphericModel,
        _GNSS_CommonAssistData_gnss_EarthOrientationParameters,
        GNSS_CommonAssistData,
        _GNSS_GenericAssistData__item_,
        GNSS_GenericAssistData,
        _GNSS_GenericAssistDataElement_gnss_ID,
        _GNSS_GenericAssistDataElement_sbas_ID,
        _GNSS_GenericAssistDataElement_gnss_TimeModels,
        _GNSS_GenericAssistDataElement_gnss_DifferentialCorrections,
        _GNSS_GenericAssistDataElement_gnss_NavigationModel,
        _GNSS_GenericAssistDataElement_gnss_RealTimeIntegrity,
        _GNSS_GenericAssistDataElement_gnss_DataBitAssistance,
        _GNSS_GenericAssistDataElement_gnss_AcquisitionAssistance,
        _GNSS_GenericAssistDataElement_gnss_Almanac,
        _GNSS_GenericAssistDataElement_gnss_UTC_Model,
        _GNSS_GenericAssistDataElement_gnss_AuxiliaryInformation,
        _GNSS_GenericAssistDataElement_bds_DifferentialCorrections_r12,
        _GNSS_GenericAssistDataElement_bds_GridModel_r12,
        GNSS_GenericAssistDataElement,
        _GNSS_ReferenceTime_gnss_SystemTime,
        _GNSS_ReferenceTime_referenceTimeUnc,
        __GNSS_ReferenceTime_gnss_ReferenceTimeForCells__item_,
        _GNSS_ReferenceTime_gnss_ReferenceTimeForCells,
        GNSS_ReferenceTime,
        _GNSS_ReferenceTimeForOneCell_networkTime,
        _GNSS_ReferenceTimeForOneCell_referenceTimeUnc,
        _GNSS_ReferenceTimeForOneCell_bsAlign,
        GNSS_ReferenceTimeForOneCell,
        _GNSS_SystemTime_gnss_TimeID,
        _GNSS_SystemTime_gnss_DayNumber,
        _GNSS_SystemTime_gnss_TimeOfDay,
        _GNSS_SystemTime_gnss_TimeOfDayFrac_msec,
        _GNSS_SystemTime_notificationOfLeapSecond,
        _GNSS_SystemTime_gps_TOW_Assist,
        GNSS_SystemTime,
        _GPS_TOW_Assist__item_,
        GPS_TOW_Assist,
        _GPS_TOW_AssistElement_satelliteID,
        _GPS_TOW_AssistElement_tlmWord,
        _GPS_TOW_AssistElement_antiSpoof,
        _GPS_TOW_AssistElement_alert,
        _GPS_TOW_AssistElement_tlmRsvdBits,
        GPS_TOW_AssistElement,
        _NetworkTime_secondsFromFrameStructureStart,
        _NetworkTime_fractionalSecondsFromFrameStructureStart,
        _NetworkTime_frameDrift,
        ___NetworkTime_cellID_eUTRA_physCellId,
        ___NetworkTime_cellID_eUTRA_cellGlobalIdEUTRA,
        ___NetworkTime_cellID_eUTRA_earfcn,
        ___NetworkTime_cellID_eUTRA_earfcn_v9a0,
        __NetworkTime_cellID_eUTRA,
        _____NetworkTime_cellID_uTRA_mode_fdd_primary_CPICH_Info,
        ____NetworkTime_cellID_uTRA_mode_fdd,
        _____NetworkTime_cellID_uTRA_mode_tdd_cellParameters,
        ____NetworkTime_cellID_uTRA_mode_tdd,
        ___NetworkTime_cellID_uTRA_mode,
        ___NetworkTime_cellID_uTRA_cellGlobalIdUTRA,
        ___NetworkTime_cellID_uTRA_uarfcn,
        __NetworkTime_cellID_uTRA,
        ___NetworkTime_cellID_gSM_bcchCarrier,
        ___NetworkTime_cellID_gSM_bsic,
        ___NetworkTime_cellID_gSM_cellGlobalIdGERAN,
        __NetworkTime_cellID_gSM,
        _NetworkTime_cellID,
        NetworkTime,
        _GNSS_ReferenceLocation_threeDlocation,
        GNSS_ReferenceLocation,
        _GNSS_IonosphericModel_klobucharModel,
        _GNSS_IonosphericModel_neQuickModel,
        GNSS_IonosphericModel,
        _KlobucharModelParameter_dataID,
        _KlobucharModelParameter_alfa0,
        _KlobucharModelParameter_alfa1,
        _KlobucharModelParameter_alfa2,
        _KlobucharModelParameter_alfa3,
        _KlobucharModelParameter_beta0,
        _KlobucharModelParameter_beta1,
        _KlobucharModelParameter_beta2,
        _KlobucharModelParameter_beta3,
        KlobucharModelParameter,
        _NeQuickModelParameter_ai0,
        _NeQuickModelParameter_ai1,
        _NeQuickModelParameter_ai2,
        _NeQuickModelParameter_ionoStormFlag1,
        _NeQuickModelParameter_ionoStormFlag2,
        _NeQuickModelParameter_ionoStormFlag3,
        _NeQuickModelParameter_ionoStormFlag4,
        _NeQuickModelParameter_ionoStormFlag5,
        NeQuickModelParameter,
        _GNSS_EarthOrientationParameters_teop,
        _GNSS_EarthOrientationParameters_pmX,
        _GNSS_EarthOrientationParameters_pmXdot,
        _GNSS_EarthOrientationParameters_pmY,
        _GNSS_EarthOrientationParameters_pmYdot,
        _GNSS_EarthOrientationParameters_deltaUT1,
        _GNSS_EarthOrientationParameters_deltaUT1dot,
        GNSS_EarthOrientationParameters,
        _GNSS_TimeModelList__item_,
        GNSS_TimeModelList,
        _GNSS_TimeModelElement_gnss_TimeModelRefTime,
        _GNSS_TimeModelElement_tA0,
        _GNSS_TimeModelElement_tA1,
        _GNSS_TimeModelElement_tA2,
        _GNSS_TimeModelElement_gnss_TO_ID,
        _GNSS_TimeModelElement_weekNumber,
        _GNSS_TimeModelElement_deltaT,
        GNSS_TimeModelElement,
        _GNSS_DifferentialCorrections_dgnss_RefTime,
        _GNSS_DifferentialCorrections_dgnss_SgnTypeList,
        GNSS_DifferentialCorrections,
        _DGNSS_SgnTypeList__item_,
        DGNSS_SgnTypeList,
        _DGNSS_SgnTypeElement_gnss_SignalID,
        _DGNSS_SgnTypeElement_gnss_StatusHealth,
        _DGNSS_SgnTypeElement_dgnss_SatList,
        DGNSS_SgnTypeElement,
        _DGNSS_SatList__item_,
        DGNSS_SatList,
        _DGNSS_CorrectionsElement_svID,
        _DGNSS_CorrectionsElement_iod,
        _DGNSS_CorrectionsElement_udre,
        _DGNSS_CorrectionsElement_pseudoRangeCor,
        _DGNSS_CorrectionsElement_rangeRateCor,
        _DGNSS_CorrectionsElement_udreGrowthRate,
        _DGNSS_CorrectionsElement_udreValidityTime,
        DGNSS_CorrectionsElement,
        _GNSS_NavigationModel_nonBroadcastIndFlag,
        _GNSS_NavigationModel_gnss_SatelliteList,
        GNSS_NavigationModel,
        _GNSS_NavModelSatelliteList__item_,
        GNSS_NavModelSatelliteList,
        _GNSS_NavModelSatelliteElement_svID,
        _GNSS_NavModelSatelliteElement_svHealth,
        _GNSS_NavModelSatelliteElement_iod,
        _GNSS_NavModelSatelliteElement_gnss_ClockModel,
        _GNSS_NavModelSatelliteElement_gnss_OrbitModel,
        _GNSS_NavModelSatelliteElement_svHealthExt_v1240,
        GNSS_NavModelSatelliteElement,
        _GNSS_ClockModel_standardClockModelList,
        _GNSS_ClockModel_nav_ClockModel,
        _GNSS_ClockModel_cnav_ClockModel,
        _GNSS_ClockModel_glonass_ClockModel,
        _GNSS_ClockModel_sbas_ClockModel,
        _GNSS_ClockModel_bds_ClockModel_r12,
        GNSS_ClockModel,
        _GNSS_OrbitModel_keplerianSet,
        _GNSS_OrbitModel_nav_KeplerianSet,
        _GNSS_OrbitModel_cnav_KeplerianSet,
        _GNSS_OrbitModel_glonass_ECEF,
        _GNSS_OrbitModel_sbas_ECEF,
        _GNSS_OrbitModel_bds_KeplerianSet_r12,
        GNSS_OrbitModel,
        _StandardClockModelList__item_,
        StandardClockModelList,
        _StandardClockModelElement_stanClockToc,
        _StandardClockModelElement_stanClockAF2,
        _StandardClockModelElement_stanClockAF1,
        _StandardClockModelElement_stanClockAF0,
        _StandardClockModelElement_stanClockTgd,
        _StandardClockModelElement_sisa,
        _StandardClockModelElement_stanModelID,
        StandardClockModelElement,
        _NAV_ClockModel_navToc,
        _NAV_ClockModel_navaf2,
        _NAV_ClockModel_navaf1,
        _NAV_ClockModel_navaf0,
        _NAV_ClockModel_navTgd,
        NAV_ClockModel,
        _CNAV_ClockModel_cnavToc,
        _CNAV_ClockModel_cnavTop,
        _CNAV_ClockModel_cnavURA0,
        _CNAV_ClockModel_cnavURA1,
        _CNAV_ClockModel_cnavURA2,
        _CNAV_ClockModel_cnavAf2,
        _CNAV_ClockModel_cnavAf1,
        _CNAV_ClockModel_cnavAf0,
        _CNAV_ClockModel_cnavTgd,
        _CNAV_ClockModel_cnavISCl1cp,
        _CNAV_ClockModel_cnavISCl1cd,
        _CNAV_ClockModel_cnavISCl1ca,
        _CNAV_ClockModel_cnavISCl2c,
        _CNAV_ClockModel_cnavISCl5i5,
        _CNAV_ClockModel_cnavISCl5q5,
        CNAV_ClockModel,
        _GLONASS_ClockModel_gloTau,
        _GLONASS_ClockModel_gloGamma,
        _GLONASS_ClockModel_gloDeltaTau,
        GLONASS_ClockModel,
        _SBAS_ClockModel_sbasTo,
        _SBAS_ClockModel_sbasAgfo,
        _SBAS_ClockModel_sbasAgf1,
        SBAS_ClockModel,
        _BDS_ClockModel_r12_bdsAODC_r12,
        _BDS_ClockModel_r12_bdsToc_r12,
        _BDS_ClockModel_r12_bdsA0_r12,
        _BDS_ClockModel_r12_bdsA1_r12,
        _BDS_ClockModel_r12_bdsA2_r12,
        _BDS_ClockModel_r12_bdsTgd1_r12,
        BDS_ClockModel_r12,
        _NavModelKeplerianSet_keplerToe,
        _NavModelKeplerianSet_keplerW,
        _NavModelKeplerianSet_keplerDeltaN,
        _NavModelKeplerianSet_keplerM0,
        _NavModelKeplerianSet_keplerOmegaDot,
        _NavModelKeplerianSet_keplerE,
        _NavModelKeplerianSet_keplerIDot,
        _NavModelKeplerianSet_keplerAPowerHalf,
        _NavModelKeplerianSet_keplerI0,
        _NavModelKeplerianSet_keplerOmega0,
        _NavModelKeplerianSet_keplerCrs,
        _NavModelKeplerianSet_keplerCis,
        _NavModelKeplerianSet_keplerCus,
        _NavModelKeplerianSet_keplerCrc,
        _NavModelKeplerianSet_keplerCic,
        _NavModelKeplerianSet_keplerCuc,
        NavModelKeplerianSet,
        _NavModelNAV_KeplerianSet_navURA,
        _NavModelNAV_KeplerianSet_navFitFlag,
        _NavModelNAV_KeplerianSet_navToe,
        _NavModelNAV_KeplerianSet_navOmega,
        _NavModelNAV_KeplerianSet_navDeltaN,
        _NavModelNAV_KeplerianSet_navM0,
        _NavModelNAV_KeplerianSet_navOmegaADot,
        _NavModelNAV_KeplerianSet_navE,
        _NavModelNAV_KeplerianSet_navIDot,
        _NavModelNAV_KeplerianSet_navAPowerHalf,
        _NavModelNAV_KeplerianSet_navI0,
        _NavModelNAV_KeplerianSet_navOmegaA0,
        _NavModelNAV_KeplerianSet_navCrs,
        _NavModelNAV_KeplerianSet_navCis,
        _NavModelNAV_KeplerianSet_navCus,
        _NavModelNAV_KeplerianSet_navCrc,
        _NavModelNAV_KeplerianSet_navCic,
        _NavModelNAV_KeplerianSet_navCuc,
        __NavModelNAV_KeplerianSet_addNAVparam_ephemCodeOnL2,
        __NavModelNAV_KeplerianSet_addNAVparam_ephemL2Pflag,
        ___NavModelNAV_KeplerianSet_addNAVparam_ephemSF1Rsvd_reserved1,
        ___NavModelNAV_KeplerianSet_addNAVparam_ephemSF1Rsvd_reserved2,
        ___NavModelNAV_KeplerianSet_addNAVparam_ephemSF1Rsvd_reserved3,
        ___NavModelNAV_KeplerianSet_addNAVparam_ephemSF1Rsvd_reserved4,
        __NavModelNAV_KeplerianSet_addNAVparam_ephemSF1Rsvd,
        __NavModelNAV_KeplerianSet_addNAVparam_ephemAODA,
        _NavModelNAV_KeplerianSet_addNAVparam,
        NavModelNAV_KeplerianSet,
        _NavModelCNAV_KeplerianSet_cnavTop,
        _NavModelCNAV_KeplerianSet_cnavURAindex,
        _NavModelCNAV_KeplerianSet_cnavDeltaA,
        _NavModelCNAV_KeplerianSet_cnavAdot,
        _NavModelCNAV_KeplerianSet_cnavDeltaNo,
        _NavModelCNAV_KeplerianSet_cnavDeltaNoDot,
        _NavModelCNAV_KeplerianSet_cnavMo,
        _NavModelCNAV_KeplerianSet_cnavE,
        _NavModelCNAV_KeplerianSet_cnavOmega,
        _NavModelCNAV_KeplerianSet_cnavOMEGA0,
        _NavModelCNAV_KeplerianSet_cnavDeltaOmegaDot,
        _NavModelCNAV_KeplerianSet_cnavIo,
        _NavModelCNAV_KeplerianSet_cnavIoDot,
        _NavModelCNAV_KeplerianSet_cnavCis,
        _NavModelCNAV_KeplerianSet_cnavCic,
        _NavModelCNAV_KeplerianSet_cnavCrs,
        _NavModelCNAV_KeplerianSet_cnavCrc,
        _NavModelCNAV_KeplerianSet_cnavCus,
        _NavModelCNAV_KeplerianSet_cnavCuc,
        NavModelCNAV_KeplerianSet,
        _NavModel_GLONASS_ECEF_gloEn,
        _NavModel_GLONASS_ECEF_gloP1,
        _NavModel_GLONASS_ECEF_gloP2,
        _NavModel_GLONASS_ECEF_gloM,
        _NavModel_GLONASS_ECEF_gloX,
        _NavModel_GLONASS_ECEF_gloXdot,
        _NavModel_GLONASS_ECEF_gloXdotdot,
        _NavModel_GLONASS_ECEF_gloY,
        _NavModel_GLONASS_ECEF_gloYdot,
        _NavModel_GLONASS_ECEF_gloYdotdot,
        _NavModel_GLONASS_ECEF_gloZ,
        _NavModel_GLONASS_ECEF_gloZdot,
        _NavModel_GLONASS_ECEF_gloZdotdot,
        NavModel_GLONASS_ECEF,
        _NavModel_SBAS_ECEF_sbasTo,
        _NavModel_SBAS_ECEF_sbasAccuracy,
        _NavModel_SBAS_ECEF_sbasXg,
        _NavModel_SBAS_ECEF_sbasYg,
        _NavModel_SBAS_ECEF_sbasZg,
        _NavModel_SBAS_ECEF_sbasXgDot,
        _NavModel_SBAS_ECEF_sbasYgDot,
        _NavModel_SBAS_ECEF_sbasZgDot,
        _NavModel_SBAS_ECEF_sbasXgDotDot,
        _NavModel_SBAS_ECEF_sbagYgDotDot,
        _NavModel_SBAS_ECEF_sbasZgDotDot,
        NavModel_SBAS_ECEF,
        _NavModel_BDS_KeplerianSet_r12_bdsAODE_r12,
        _NavModel_BDS_KeplerianSet_r12_bdsURAI_r12,
        _NavModel_BDS_KeplerianSet_r12_bdsToe_r12,
        _NavModel_BDS_KeplerianSet_r12_bdsAPowerHalf_r12,
        _NavModel_BDS_KeplerianSet_r12_bdsE_r12,
        _NavModel_BDS_KeplerianSet_r12_bdsW_r12,
        _NavModel_BDS_KeplerianSet_r12_bdsDeltaN_r12,
        _NavModel_BDS_KeplerianSet_r12_bdsM0_r12,
        _NavModel_BDS_KeplerianSet_r12_bdsOmega0_r12,
        _NavModel_BDS_KeplerianSet_r12_bdsOmegaDot_r12,
        _NavModel_BDS_KeplerianSet_r12_bdsI0_r12,
        _NavModel_BDS_KeplerianSet_r12_bdsIDot_r12,
        _NavModel_BDS_KeplerianSet_r12_bdsCuc_r12,
        _NavModel_BDS_KeplerianSet_r12_bdsCus_r12,
        _NavModel_BDS_KeplerianSet_r12_bdsCrc_r12,
        _NavModel_BDS_KeplerianSet_r12_bdsCrs_r12,
        _NavModel_BDS_KeplerianSet_r12_bdsCic_r12,
        _NavModel_BDS_KeplerianSet_r12_bdsCis_r12,
        NavModel_BDS_KeplerianSet_r12,
        _GNSS_RealTimeIntegrity_gnss_BadSignalList,
        GNSS_RealTimeIntegrity,
        _GNSS_BadSignalList__item_,
        GNSS_BadSignalList,
        _BadSignalElement_badSVID,
        _BadSignalElement_badSignalID,
        BadSignalElement,
        _GNSS_DataBitAssistance_gnss_TOD,
        _GNSS_DataBitAssistance_gnss_TODfrac,
        _GNSS_DataBitAssistance_gnss_DataBitsSatList,
        GNSS_DataBitAssistance,
        _GNSS_DataBitsSatList__item_,
        GNSS_DataBitsSatList,
        _GNSS_DataBitsSatElement_svID,
        _GNSS_DataBitsSatElement_gnss_DataBitsSgnList,
        GNSS_DataBitsSatElement,
        _GNSS_DataBitsSgnList__item_,
        GNSS_DataBitsSgnList,
        _GNSS_DataBitsSgnElement_gnss_SignalType,
        _GNSS_DataBitsSgnElement_gnss_DataBits,
        GNSS_DataBitsSgnElement,
        _GNSS_AcquisitionAssistance_gnss_SignalID,
        _GNSS_AcquisitionAssistance_gnss_AcquisitionAssistList,
        _GNSS_AcquisitionAssistance_confidence_r10,
        GNSS_AcquisitionAssistance,
        _GNSS_AcquisitionAssistList__item_,
        GNSS_AcquisitionAssistList,
        _GNSS_AcquisitionAssistElement_svID,
        _GNSS_AcquisitionAssistElement_doppler0,
        _GNSS_AcquisitionAssistElement_doppler1,
        _GNSS_AcquisitionAssistElement_dopplerUncertainty,
        _GNSS_AcquisitionAssistElement_codePhase,
        _GNSS_AcquisitionAssistElement_intCodePhase,
        _GNSS_AcquisitionAssistElement_codePhaseSearchWindow,
        _GNSS_AcquisitionAssistElement_azimuth,
        _GNSS_AcquisitionAssistElement_elevation,
        _GNSS_AcquisitionAssistElement_codePhase1023,
        _GNSS_AcquisitionAssistElement_dopplerUncertaintyExt_r10,
        GNSS_AcquisitionAssistElement,
        _GNSS_Almanac_weekNumber,
        _GNSS_Almanac_toa,
        _GNSS_Almanac_ioda,
        _GNSS_Almanac_completeAlmanacProvided,
        _GNSS_Almanac_gnss_AlmanacList,
        _GNSS_Almanac_toa_ext_v1240,
        _GNSS_Almanac_ioda_ext_v1240,
        GNSS_Almanac,
        _GNSS_AlmanacList__item_,
        GNSS_AlmanacList,
        _GNSS_AlmanacElement_keplerianAlmanacSet,
        _GNSS_AlmanacElement_keplerianNAV_Almanac,
        _GNSS_AlmanacElement_keplerianReducedAlmanac,
        _GNSS_AlmanacElement_keplerianMidiAlmanac,
        _GNSS_AlmanacElement_keplerianGLONASS,
        _GNSS_AlmanacElement_ecef_SBAS_Almanac,
        _GNSS_AlmanacElement_keplerianBDS_Almanac_r12,
        GNSS_AlmanacElement,
        _AlmanacKeplerianSet_svID,
        _AlmanacKeplerianSet_kepAlmanacE,
        _AlmanacKeplerianSet_kepAlmanacDeltaI,
        _AlmanacKeplerianSet_kepAlmanacOmegaDot,
        _AlmanacKeplerianSet_kepSV_StatusINAV,
        _AlmanacKeplerianSet_kepSV_StatusFNAV,
        _AlmanacKeplerianSet_kepAlmanacAPowerHalf,
        _AlmanacKeplerianSet_kepAlmanacOmega0,
        _AlmanacKeplerianSet_kepAlmanacW,
        _AlmanacKeplerianSet_kepAlmanacM0,
        _AlmanacKeplerianSet_kepAlmanacAF0,
        _AlmanacKeplerianSet_kepAlmanacAF1,
        AlmanacKeplerianSet,
        _AlmanacNAV_KeplerianSet_svID,
        _AlmanacNAV_KeplerianSet_navAlmE,
        _AlmanacNAV_KeplerianSet_navAlmDeltaI,
        _AlmanacNAV_KeplerianSet_navAlmOMEGADOT,
        _AlmanacNAV_KeplerianSet_navAlmSVHealth,
        _AlmanacNAV_KeplerianSet_navAlmSqrtA,
        _AlmanacNAV_KeplerianSet_navAlmOMEGAo,
        _AlmanacNAV_KeplerianSet_navAlmOmega,
        _AlmanacNAV_KeplerianSet_navAlmMo,
        _AlmanacNAV_KeplerianSet_navAlmaf0,
        _AlmanacNAV_KeplerianSet_navAlmaf1,
        AlmanacNAV_KeplerianSet,
        _AlmanacReducedKeplerianSet_svID,
        _AlmanacReducedKeplerianSet_redAlmDeltaA,
        _AlmanacReducedKeplerianSet_redAlmOmega0,
        _AlmanacReducedKeplerianSet_redAlmPhi0,
        _AlmanacReducedKeplerianSet_redAlmL1Health,
        _AlmanacReducedKeplerianSet_redAlmL2Health,
        _AlmanacReducedKeplerianSet_redAlmL5Health,
        AlmanacReducedKeplerianSet,
        _AlmanacMidiAlmanacSet_svID,
        _AlmanacMidiAlmanacSet_midiAlmE,
        _AlmanacMidiAlmanacSet_midiAlmDeltaI,
        _AlmanacMidiAlmanacSet_midiAlmOmegaDot,
        _AlmanacMidiAlmanacSet_midiAlmSqrtA,
        _AlmanacMidiAlmanacSet_midiAlmOmega0,
        _AlmanacMidiAlmanacSet_midiAlmOmega,
        _AlmanacMidiAlmanacSet_midiAlmMo,
        _AlmanacMidiAlmanacSet_midiAlmaf0,
        _AlmanacMidiAlmanacSet_midiAlmaf1,
        _AlmanacMidiAlmanacSet_midiAlmL1Health,
        _AlmanacMidiAlmanacSet_midiAlmL2Health,
        _AlmanacMidiAlmanacSet_midiAlmL5Health,
        AlmanacMidiAlmanacSet,
        _AlmanacGLONASS_AlmanacSet_gloAlm_NA,
        _AlmanacGLONASS_AlmanacSet_gloAlmnA,
        _AlmanacGLONASS_AlmanacSet_gloAlmHA,
        _AlmanacGLONASS_AlmanacSet_gloAlmLambdaA,
        _AlmanacGLONASS_AlmanacSet_gloAlmtlambdaA,
        _AlmanacGLONASS_AlmanacSet_gloAlmDeltaIa,
        _AlmanacGLONASS_AlmanacSet_gloAlmDeltaTA,
        _AlmanacGLONASS_AlmanacSet_gloAlmDeltaTdotA,
        _AlmanacGLONASS_AlmanacSet_gloAlmEpsilonA,
        _AlmanacGLONASS_AlmanacSet_gloAlmOmegaA,
        _AlmanacGLONASS_AlmanacSet_gloAlmTauA,
        _AlmanacGLONASS_AlmanacSet_gloAlmCA,
        _AlmanacGLONASS_AlmanacSet_gloAlmMA,
        AlmanacGLONASS_AlmanacSet,
        _AlmanacECEF_SBAS_AlmanacSet_sbasAlmDataID,
        _AlmanacECEF_SBAS_AlmanacSet_svID,
        _AlmanacECEF_SBAS_AlmanacSet_sbasAlmHealth,
        _AlmanacECEF_SBAS_AlmanacSet_sbasAlmXg,
        _AlmanacECEF_SBAS_AlmanacSet_sbasAlmYg,
        _AlmanacECEF_SBAS_AlmanacSet_sbasAlmZg,
        _AlmanacECEF_SBAS_AlmanacSet_sbasAlmXgdot,
        _AlmanacECEF_SBAS_AlmanacSet_sbasAlmYgDot,
        _AlmanacECEF_SBAS_AlmanacSet_sbasAlmZgDot,
        _AlmanacECEF_SBAS_AlmanacSet_sbasAlmTo,
        AlmanacECEF_SBAS_AlmanacSet,
        _AlmanacBDS_AlmanacSet_r12_svID,
        _AlmanacBDS_AlmanacSet_r12_bdsAlmToa_r12,
        _AlmanacBDS_AlmanacSet_r12_bdsAlmSqrtA_r12,
        _AlmanacBDS_AlmanacSet_r12_bdsAlmE_r12,
        _AlmanacBDS_AlmanacSet_r12_bdsAlmW_r12,
        _AlmanacBDS_AlmanacSet_r12_bdsAlmM0_r12,
        _AlmanacBDS_AlmanacSet_r12_bdsAlmOmega0_r12,
        _AlmanacBDS_AlmanacSet_r12_bdsAlmOmegaDot_r12,
        _AlmanacBDS_AlmanacSet_r12_bdsAlmDeltaI_r12,
        _AlmanacBDS_AlmanacSet_r12_bdsAlmA0_r12,
        _AlmanacBDS_AlmanacSet_r12_bdsAlmA1_r12,
        _AlmanacBDS_AlmanacSet_r12_bdsSvHealth_r12,
        AlmanacBDS_AlmanacSet_r12,
        _GNSS_UTC_Model_utcModel1,
        _GNSS_UTC_Model_utcModel2,
        _GNSS_UTC_Model_utcModel3,
        _GNSS_UTC_Model_utcModel4,
        _GNSS_UTC_Model_utcModel5_r12,
        GNSS_UTC_Model,
        _UTC_ModelSet1_gnss_Utc_A1,
        _UTC_ModelSet1_gnss_Utc_A0,
        _UTC_ModelSet1_gnss_Utc_Tot,
        _UTC_ModelSet1_gnss_Utc_WNt,
        _UTC_ModelSet1_gnss_Utc_DeltaTls,
        _UTC_ModelSet1_gnss_Utc_WNlsf,
        _UTC_ModelSet1_gnss_Utc_DN,
        _UTC_ModelSet1_gnss_Utc_DeltaTlsf,
        UTC_ModelSet1,
        _UTC_ModelSet2_utcA0,
        _UTC_ModelSet2_utcA1,
        _UTC_ModelSet2_utcA2,
        _UTC_ModelSet2_utcDeltaTls,
        _UTC_ModelSet2_utcTot,
        _UTC_ModelSet2_utcWNot,
        _UTC_ModelSet2_utcWNlsf,
        _UTC_ModelSet2_utcDN,
        _UTC_ModelSet2_utcDeltaTlsf,
        UTC_ModelSet2,
        _UTC_ModelSet3_nA,
        _UTC_ModelSet3_tauC,
        _UTC_ModelSet3_b1,
        _UTC_ModelSet3_b2,
        _UTC_ModelSet3_kp,
        UTC_ModelSet3,
        _UTC_ModelSet4_utcA1wnt,
        _UTC_ModelSet4_utcA0wnt,
        _UTC_ModelSet4_utcTot,
        _UTC_ModelSet4_utcWNt,
        _UTC_ModelSet4_utcDeltaTls,
        _UTC_ModelSet4_utcWNlsf,
        _UTC_ModelSet4_utcDN,
        _UTC_ModelSet4_utcDeltaTlsf,
        _UTC_ModelSet4_utcStandardID,
        UTC_ModelSet4,
        _UTC_ModelSet5_r12_utcA0_r12,
        _UTC_ModelSet5_r12_utcA1_r12,
        _UTC_ModelSet5_r12_utcDeltaTls_r12,
        _UTC_ModelSet5_r12_utcWNlsf_r12,
        _UTC_ModelSet5_r12_utcDN_r12,
        _UTC_ModelSet5_r12_utcDeltaTlsf_r12,
        UTC_ModelSet5_r12,
        _GNSS_AuxiliaryInformation_gnss_ID_GPS,
        _GNSS_AuxiliaryInformation_gnss_ID_GLONASS,
        GNSS_AuxiliaryInformation,
        _GNSS_ID_GPS__item_,
        GNSS_ID_GPS,
        _GNSS_ID_GPS_SatElement_svID,
        _GNSS_ID_GPS_SatElement_signalsAvailable,
        GNSS_ID_GPS_SatElement,
        _GNSS_ID_GLONASS__item_,
        GNSS_ID_GLONASS,
        _GNSS_ID_GLONASS_SatElement_svID,
        _GNSS_ID_GLONASS_SatElement_signalsAvailable,
        _GNSS_ID_GLONASS_SatElement_channelNumber,
        GNSS_ID_GLONASS_SatElement,
        _BDS_DifferentialCorrections_r12_dbds_RefTime_r12,
        _BDS_DifferentialCorrections_r12_bds_SgnTypeList_r12,
        BDS_DifferentialCorrections_r12,
        _BDS_SgnTypeList_r12__item_,
        BDS_SgnTypeList_r12,
        _BDS_SgnTypeElement_r12_gnss_SignalID,
        _BDS_SgnTypeElement_r12_dbds_CorrectionList_r12,
        BDS_SgnTypeElement_r12,
        _DBDS_CorrectionList_r12__item_,
        DBDS_CorrectionList_r12,
        _DBDS_CorrectionElement_r12_svID,
        _DBDS_CorrectionElement_r12_bds_UDREI_r12,
        _DBDS_CorrectionElement_r12_bds_RURAI_r12,
        _DBDS_CorrectionElement_r12_bds_ECC_DeltaT_r12,
        DBDS_CorrectionElement_r12,
        _BDS_GridModelParameter_r12_bds_RefTime_r12,
        _BDS_GridModelParameter_r12_gridIonList_r12,
        BDS_GridModelParameter_r12,
        _GridIonList_r12__item_,
        GridIonList_r12,
        _GridIonElement_r12_igp_ID_r12,
        _GridIonElement_r12_dt_r12,
        _GridIonElement_r12_givei_r12,
        GridIonElement_r12,
        _A_GNSS_RequestAssistanceData_gnss_CommonAssistDataReq,
        _A_GNSS_RequestAssistanceData_gnss_GenericAssistDataReq,
        A_GNSS_RequestAssistanceData,
        _GNSS_CommonAssistDataReq_gnss_ReferenceTimeReq,
        _GNSS_CommonAssistDataReq_gnss_ReferenceLocationReq,
        _GNSS_CommonAssistDataReq_gnss_IonosphericModelReq,
        _GNSS_CommonAssistDataReq_gnss_EarthOrientationParametersReq,
        GNSS_CommonAssistDataReq,
        _GNSS_GenericAssistDataReq__item_,
        GNSS_GenericAssistDataReq,
        _GNSS_GenericAssistDataReqElement_gnss_ID,
        _GNSS_GenericAssistDataReqElement_sbas_ID,
        _GNSS_GenericAssistDataReqElement_gnss_TimeModelsReq,
        _GNSS_GenericAssistDataReqElement_gnss_DifferentialCorrectionsReq,
        _GNSS_GenericAssistDataReqElement_gnss_NavigationModelReq,
        _GNSS_GenericAssistDataReqElement_gnss_RealTimeIntegrityReq,
        _GNSS_GenericAssistDataReqElement_gnss_DataBitAssistanceReq,
        _GNSS_GenericAssistDataReqElement_gnss_AcquisitionAssistanceReq,
        _GNSS_GenericAssistDataReqElement_gnss_AlmanacReq,
        _GNSS_GenericAssistDataReqElement_gnss_UTCModelReq,
        _GNSS_GenericAssistDataReqElement_gnss_AuxiliaryInformationReq,
        _GNSS_GenericAssistDataReqElement_bds_DifferentialCorrectionsReq_r12,
        _GNSS_GenericAssistDataReqElement_bds_GridModelReq_r12,
        GNSS_GenericAssistDataReqElement,
        __GNSS_ReferenceTimeReq_gnss_TimeReqPrefList__item_,
        _GNSS_ReferenceTimeReq_gnss_TimeReqPrefList,
        _GNSS_ReferenceTimeReq_gps_TOW_assistReq,
        _GNSS_ReferenceTimeReq_notOfLeapSecReq,
        GNSS_ReferenceTimeReq,
        GNSS_ReferenceLocationReq,
        _GNSS_IonosphericModelReq_klobucharModelReq,
        _GNSS_IonosphericModelReq_neQuickModelReq,
        GNSS_IonosphericModelReq,
        GNSS_EarthOrientationParametersReq,
        _GNSS_TimeModelListReq__item_,
        GNSS_TimeModelListReq,
        _GNSS_TimeModelElementReq_gnss_TO_IDsReq,
        _GNSS_TimeModelElementReq_deltaTreq,
        GNSS_TimeModelElementReq,
        _GNSS_DifferentialCorrectionsReq_dgnss_SignalsReq,
        _GNSS_DifferentialCorrectionsReq_dgnss_ValidityTimeReq,
        GNSS_DifferentialCorrectionsReq,
        _GNSS_NavigationModelReq_storedNavList,
        _GNSS_NavigationModelReq_reqNavList,
        GNSS_NavigationModelReq,
        _StoredNavListInfo_gnss_WeekOrDay,
        _StoredNavListInfo_gnss_Toe,
        _StoredNavListInfo_t_toeLimit,
        _StoredNavListInfo_satListRelatedDataList,
        StoredNavListInfo,
        _SatListRelatedDataList__item_,
        SatListRelatedDataList,
        _SatListRelatedDataElement_svID,
        _SatListRelatedDataElement_iod,
        _SatListRelatedDataElement_clockModelID,
        _SatListRelatedDataElement_orbitModelID,
        SatListRelatedDataElement,
        _ReqNavListInfo_svReqList,
        __ReqNavListInfo_clockModelID_PrefList__item_,
        _ReqNavListInfo_clockModelID_PrefList,
        __ReqNavListInfo_orbitModelID_PrefList__item_,
        _ReqNavListInfo_orbitModelID_PrefList,
        _ReqNavListInfo_addNavparamReq,
        ReqNavListInfo,
        GNSS_RealTimeIntegrityReq,
        _GNSS_DataBitAssistanceReq_gnss_TOD_Req,
        _GNSS_DataBitAssistanceReq_gnss_TOD_FracReq,
        _GNSS_DataBitAssistanceReq_dataBitInterval,
        _GNSS_DataBitAssistanceReq_gnss_SignalType,
        _GNSS_DataBitAssistanceReq_gnss_DataBitsReq,
        GNSS_DataBitAssistanceReq,
        _GNSS_DataBitsReqSatList__item_,
        GNSS_DataBitsReqSatList,
        _GNSS_DataBitsReqSatElement_svID,
        GNSS_DataBitsReqSatElement,
        _GNSS_AcquisitionAssistanceReq_gnss_SignalID_Req,
        GNSS_AcquisitionAssistanceReq,
        _GNSS_AlmanacReq_modelID,
        GNSS_AlmanacReq,
        _GNSS_UTC_ModelReq_modelID,
        GNSS_UTC_ModelReq,
        GNSS_AuxiliaryInformationReq,
        _BDS_DifferentialCorrectionsReq_r12_dgnss_SignalsReq,
        BDS_DifferentialCorrectionsReq_r12,
        BDS_GridModelReq_r12,
        _A_GNSS_ProvideLocationInformation_gnss_SignalMeasurementInformation,
        _A_GNSS_ProvideLocationInformation_gnss_LocationInformation,
        _A_GNSS_ProvideLocationInformation_gnss_Error,
        A_GNSS_ProvideLocationInformation,
        _GNSS_SignalMeasurementInformation_measurementReferenceTime,
        _GNSS_SignalMeasurementInformation_gnss_MeasurementList,
        GNSS_SignalMeasurementInformation,
        _MeasurementReferenceTime_gnss_TOD_msec,
        _MeasurementReferenceTime_gnss_TOD_frac,
        _MeasurementReferenceTime_gnss_TOD_unc,
        _MeasurementReferenceTime_gnss_TimeID,
        ___MeasurementReferenceTime_networkTime_eUTRA_physCellId,
        ___MeasurementReferenceTime_networkTime_eUTRA_cellGlobalId,
        ___MeasurementReferenceTime_networkTime_eUTRA_systemFrameNumber,
        __MeasurementReferenceTime_networkTime_eUTRA,
        _____MeasurementReferenceTime_networkTime_uTRA_mode_fdd_primary_CPICH_Info,
        ____MeasurementReferenceTime_networkTime_uTRA_mode_fdd,
        _____MeasurementReferenceTime_networkTime_uTRA_mode_tdd_cellParameters,
        ____MeasurementReferenceTime_networkTime_uTRA_mode_tdd,
        ___MeasurementReferenceTime_networkTime_uTRA_mode,
        ___MeasurementReferenceTime_networkTime_uTRA_cellGlobalId,
        ___MeasurementReferenceTime_networkTime_uTRA_referenceSystemFrameNumber,
        __MeasurementReferenceTime_networkTime_uTRA,
        ___MeasurementReferenceTime_networkTime_gSM_bcchCarrier,
        ___MeasurementReferenceTime_networkTime_gSM_bsic,
        ___MeasurementReferenceTime_networkTime_gSM_cellGlobalId,
        ____MeasurementReferenceTime_networkTime_gSM_referenceFrame_referenceFN,
        ____MeasurementReferenceTime_networkTime_gSM_referenceFrame_referenceFNMSB,
        ___MeasurementReferenceTime_networkTime_gSM_referenceFrame,
        ___MeasurementReferenceTime_networkTime_gSM_deltaGNSS_TOD,
        __MeasurementReferenceTime_networkTime_gSM,
        _MeasurementReferenceTime_networkTime,
        MeasurementReferenceTime,
        _GNSS_MeasurementList__item_,
        GNSS_MeasurementList,
        _GNSS_MeasurementForOneGNSS_gnss_ID,
        _GNSS_MeasurementForOneGNSS_gnss_SgnMeasList,
        GNSS_MeasurementForOneGNSS,
        _GNSS_SgnMeasList__item_,
        GNSS_SgnMeasList,
        _GNSS_SgnMeasElement_gnss_SignalID,
        _GNSS_SgnMeasElement_gnss_CodePhaseAmbiguity,
        _GNSS_SgnMeasElement_gnss_SatMeasList,
        GNSS_SgnMeasElement,
        _GNSS_SatMeasList__item_,
        GNSS_SatMeasList,
        _GNSS_SatMeasElement_svID,
        _GNSS_SatMeasElement_cNo,
        _GNSS_SatMeasElement_mpathDet,
        _GNSS_SatMeasElement_carrierQualityInd,
        _GNSS_SatMeasElement_codePhase,
        _GNSS_SatMeasElement_integerCodePhase,
        _GNSS_SatMeasElement_codePhaseRMSError,
        _GNSS_SatMeasElement_doppler,
        _GNSS_SatMeasElement_adr,
        GNSS_SatMeasElement,
        _GNSS_LocationInformation_measurementReferenceTime,
        _GNSS_LocationInformation_agnss_List,
        GNSS_LocationInformation,
        _A_GNSS_RequestLocationInformation_gnss_PositioningInstructions,
        A_GNSS_RequestLocationInformation,
        _GNSS_PositioningInstructions_gnss_Methods,
        _GNSS_PositioningInstructions_fineTimeAssistanceMeasReq,
        _GNSS_PositioningInstructions_adrMeasReq,
        _GNSS_PositioningInstructions_multiFreqMeasReq,
        _GNSS_PositioningInstructions_assistanceAvailability,
        GNSS_PositioningInstructions,
        _A_GNSS_ProvideCapabilities_gnss_SupportList,
        _A_GNSS_ProvideCapabilities_assistanceDataSupportList,
        _A_GNSS_ProvideCapabilities_locationCoordinateTypes,
        _A_GNSS_ProvideCapabilities_velocityTypes,
        A_GNSS_ProvideCapabilities,
        _GNSS_SupportList__item_,
        GNSS_SupportList,
        _GNSS_SupportElement_gnss_ID,
        _GNSS_SupportElement_sbas_IDs,
        _GNSS_SupportElement_agnss_Modes,
        _GNSS_SupportElement_gnss_Signals,
        __GNSS_SupportElement_fta_MeasSupport_cellTime,
        __GNSS_SupportElement_fta_MeasSupport_mode,
        _GNSS_SupportElement_fta_MeasSupport,
        _GNSS_SupportElement_adr_Support,
        _GNSS_SupportElement_velocityMeasurementSupport,
        GNSS_SupportElement,
        _AssistanceDataSupportList_gnss_CommonAssistanceDataSupport,
        _AssistanceDataSupportList_gnss_GenericAssistanceDataSupport,
        AssistanceDataSupportList,
        _GNSS_CommonAssistanceDataSupport_gnss_ReferenceTimeSupport,
        _GNSS_CommonAssistanceDataSupport_gnss_ReferenceLocationSupport,
        _GNSS_CommonAssistanceDataSupport_gnss_IonosphericModelSupport,
        _GNSS_CommonAssistanceDataSupport_gnss_EarthOrientationParametersSupport,
        GNSS_CommonAssistanceDataSupport,
        _GNSS_ReferenceTimeSupport_gnss_SystemTime,
        _GNSS_ReferenceTimeSupport_fta_Support,
        GNSS_ReferenceTimeSupport,
        GNSS_ReferenceLocationSupport,
        _GNSS_IonosphericModelSupport_ionoModel,
        GNSS_IonosphericModelSupport,
        GNSS_EarthOrientationParametersSupport,
        _GNSS_GenericAssistanceDataSupport__item_,
        GNSS_GenericAssistanceDataSupport,
        _GNSS_GenericAssistDataSupportElement_gnss_ID,
        _GNSS_GenericAssistDataSupportElement_sbas_ID,
        _GNSS_GenericAssistDataSupportElement_gnss_TimeModelsSupport,
        _GNSS_GenericAssistDataSupportElement_gnss_DifferentialCorrectionsSupport,
        _GNSS_GenericAssistDataSupportElement_gnss_NavigationModelSupport,
        _GNSS_GenericAssistDataSupportElement_gnss_RealTimeIntegritySupport,
        _GNSS_GenericAssistDataSupportElement_gnss_DataBitAssistanceSupport,
        _GNSS_GenericAssistDataSupportElement_gnss_AcquisitionAssistanceSupport,
        _GNSS_GenericAssistDataSupportElement_gnss_AlmanacSupport,
        _GNSS_GenericAssistDataSupportElement_gnss_UTC_ModelSupport,
        _GNSS_GenericAssistDataSupportElement_gnss_AuxiliaryInformationSupport,
        _GNSS_GenericAssistDataSupportElement_bds_DifferentialCorrectionsSupport_r12,
        _GNSS_GenericAssistDataSupportElement_bds_GridModelSupport_r12,
        GNSS_GenericAssistDataSupportElement,
        GNSS_TimeModelListSupport,
        _GNSS_DifferentialCorrectionsSupport_gnssSignalIDs,
        _GNSS_DifferentialCorrectionsSupport_dgnss_ValidityTimeSup,
        GNSS_DifferentialCorrectionsSupport,
        _GNSS_NavigationModelSupport_clockModel,
        _GNSS_NavigationModelSupport_orbitModel,
        GNSS_NavigationModelSupport,
        GNSS_RealTimeIntegritySupport,
        GNSS_DataBitAssistanceSupport,
        _GNSS_AcquisitionAssistanceSupport_confidenceSupport_r10,
        _GNSS_AcquisitionAssistanceSupport_dopplerUncertaintyExtSupport_r10,
        GNSS_AcquisitionAssistanceSupport,
        _GNSS_AlmanacSupport_almanacModel,
        GNSS_AlmanacSupport,
        _GNSS_UTC_ModelSupport_utc_Model,
        GNSS_UTC_ModelSupport,
        GNSS_AuxiliaryInformationSupport,
        _BDS_DifferentialCorrectionsSupport_r12_gnssSignalIDs,
        BDS_DifferentialCorrectionsSupport_r12,
        BDS_GridModelSupport_r12,
        _A_GNSS_RequestCapabilities_gnss_SupportListReq,
        _A_GNSS_RequestCapabilities_assistanceDataSupportListReq,
        _A_GNSS_RequestCapabilities_locationVelocityTypesReq,
        A_GNSS_RequestCapabilities,
        _A_GNSS_Error_locationServerErrorCauses,
        _A_GNSS_Error_targetDeviceErrorCauses,
        A_GNSS_Error,
        _GNSS_LocationServerErrorCauses_cause,
        GNSS_LocationServerErrorCauses,
        _GNSS_TargetDeviceErrorCauses_cause,
        _GNSS_TargetDeviceErrorCauses_fineTimeAssistanceMeasurementsNotPossible,
        _GNSS_TargetDeviceErrorCauses_adrMeasurementsNotPossible,
        _GNSS_TargetDeviceErrorCauses_multiFrequencyMeasurementsNotPossible,
        GNSS_TargetDeviceErrorCauses,
        _GNSS_ID_gnss_id,
        GNSS_ID,
        _GNSS_ID_Bitmap_gnss_ids,
        GNSS_ID_Bitmap,
        _GNSS_SignalID_gnss_SignalID,
        GNSS_SignalID,
        _GNSS_SignalIDs_gnss_SignalIDs,
        GNSS_SignalIDs,
        _SBAS_ID_sbas_id,
        SBAS_ID,
        _SBAS_IDs_sbas_IDs,
        SBAS_IDs,
        _SV_ID_satellite_id,
        SV_ID,
        _ECID_ProvideLocationInformation_ecid_SignalMeasurementInformation,
        _ECID_ProvideLocationInformation_ecid_Error,
        ECID_ProvideLocationInformation,
        _ECID_SignalMeasurementInformation_primaryCellMeasuredResults,
        _ECID_SignalMeasurementInformation_measuredResultsList,
        ECID_SignalMeasurementInformation,
        _MeasuredResultsList__item_,
        MeasuredResultsList,
        _MeasuredResultsElement_physCellId,
        _MeasuredResultsElement_cellGlobalId,
        _MeasuredResultsElement_arfcnEUTRA,
        _MeasuredResultsElement_systemFrameNumber,
        _MeasuredResultsElement_rsrp_Result,
        _MeasuredResultsElement_rsrq_Result,
        _MeasuredResultsElement_ue_RxTxTimeDiff,
        _MeasuredResultsElement_arfcnEUTRA_v9a0,
        MeasuredResultsElement,
        _ECID_RequestLocationInformation_requestedMeasurements,
        ECID_RequestLocationInformation,
        _ECID_ProvideCapabilities_ecid_MeasSupported,
        ECID_ProvideCapabilities,
        ECID_RequestCapabilities,
        _ECID_Error_locationServerErrorCauses,
        _ECID_Error_targetDeviceErrorCauses,
        ECID_Error,
        _ECID_LocationServerErrorCauses_cause,
        ECID_LocationServerErrorCauses,
        _ECID_TargetDeviceErrorCauses_cause,
        _ECID_TargetDeviceErrorCauses_rsrpMeasurementNotPossible,
        _ECID_TargetDeviceErrorCauses_rsrqMeasurementNotPossible,
        _ECID_TargetDeviceErrorCauses_ueRxTxMeasurementNotPossible,
        ECID_TargetDeviceErrorCauses,
        _TBS_ProvideLocationInformation_r13_tbs_MeasurementInformation_r13,
        _TBS_ProvideLocationInformation_r13_tbs_Error_r13,
        TBS_ProvideLocationInformation_r13,
        _TBS_MeasurementInformation_r13_measurementReferenceTime_r13,
        _TBS_MeasurementInformation_r13_mbs_SgnMeasList_r13,
        TBS_MeasurementInformation_r13,
        _MBS_BeaconMeasList_r13__item_,
        MBS_BeaconMeasList_r13,
        _MBS_BeaconMeasElement_r13_transmitterID_r13,
        _MBS_BeaconMeasElement_r13_codePhase_r13,
        _MBS_BeaconMeasElement_r13_codePhaseRMSError_r13,
        MBS_BeaconMeasElement_r13,
        _TBS_RequestLocationInformation_r13_mbsSgnMeasListReq_r13,
        TBS_RequestLocationInformation_r13,
        _TBS_ProvideCapabilities_r13_tbs_Modes_r13,
        TBS_ProvideCapabilities_r13,
        TBS_RequestCapabilities_r13,
        _TBS_Error_r13_locationServerErrorCauses_r13,
        _TBS_Error_r13_targetDeviceErrorCauses_r13,
        TBS_Error_r13,
        _TBS_LocationServerErrorCauses_r13_cause_r13,
        TBS_LocationServerErrorCauses_r13,
        _TBS_TargetDeviceErrorCauses_r13_cause_r13,
        TBS_TargetDeviceErrorCauses_r13,
        _Sensor_ProvideLocationInformation_r13_sensor_MeasurementInformation_r13,
        _Sensor_ProvideLocationInformation_r13_sensor_Error_r13,
        Sensor_ProvideLocationInformation_r13,
        _Sensor_MeasurementInformation_r13_measurementReferenceTime_r13,
        _Sensor_MeasurementInformation_r13_uncompensatedBarometricPressure_r13,
        Sensor_MeasurementInformation_r13,
        _Sensor_RequestLocationInformation_r13_uncompensatedBarometricPressureReq_r13,
        Sensor_RequestLocationInformation_r13,
        _Sensor_ProvideCapabilities_r13_sensor_Modes_r13,
        Sensor_ProvideCapabilities_r13,
        Sensor_RequestCapabilities_r13,
        _Sensor_Error_r13_locationServerErrorCauses_r13,
        _Sensor_Error_r13_targetDeviceErrorCauses_r13,
        Sensor_Error_r13,
        _Sensor_LocationServerErrorCauses_r13_cause_r13,
        Sensor_LocationServerErrorCauses_r13,
        _Sensor_TargetDeviceErrorCauses_r13_cause_r13,
        Sensor_TargetDeviceErrorCauses_r13,
        _WLAN_ProvideLocationInformation_r13_wlan_MeasurementInformation_r13,
        _WLAN_ProvideLocationInformation_r13_wlan_Error_r13,
        WLAN_ProvideLocationInformation_r13,
        _WLAN_MeasurementInformation_r13_measurementReferenceTime_r13,
        _WLAN_MeasurementInformation_r13_wlan_MeasurementList_r13,
        WLAN_MeasurementInformation_r13,
        _WLAN_MeasurementList_r13__item_,
        WLAN_MeasurementList_r13,
        _WLAN_MeasurementElement_r13_wlan_AP_Identifier_r13,
        _WLAN_MeasurementElement_r13_rssi_r13,
        _WLAN_MeasurementElement_r13_rtt_r13,
        _WLAN_MeasurementElement_r13_apChannelFrequency_r13,
        _WLAN_MeasurementElement_r13_servingFlag_r13,
        WLAN_MeasurementElement_r13,
        _WLAN_AP_Identifier_r13_bssid_r13,
        _WLAN_AP_Identifier_r13_ssid_r13,
        WLAN_AP_Identifier_r13,
        _WLAN_RTT_r13_rttValue_r13,
        _WLAN_RTT_r13_rttUnits_r13,
        _WLAN_RTT_r13_rttAccuracy_r13,
        WLAN_RTT_r13,
        maxWLAN_AP_r13,
        _WLAN_RequestLocationInformation_r13_requestedMeasurements_r13,
        WLAN_RequestLocationInformation_r13,
        _WLAN_ProvideCapabilities_r13_wlan_Modes_r13,
        _WLAN_ProvideCapabilities_r13_wlan_MeasSupported_r13,
        WLAN_ProvideCapabilities_r13,
        WLAN_RequestCapabilities_r13,
        _WLAN_Error_r13_locationServerErrorCauses_r13,
        _WLAN_Error_r13_targetDeviceErrorCauses_r13,
        WLAN_Error_r13,
        _WLAN_LocationServerErrorCauses_r13_cause_r13,
        WLAN_LocationServerErrorCauses_r13,
        _WLAN_TargetDeviceErrorCauses_r13_cause_r13,
        _WLAN_TargetDeviceErrorCauses_r13_wlan_AP_RSSI_MeasurementNotPossible_r13,
        _WLAN_TargetDeviceErrorCauses_r13_wlan_AP_RTT_MeasurementNotPossible_r13,
        WLAN_TargetDeviceErrorCauses_r13,
        _BT_ProvideLocationInformation_r13_bt_MeasurementInformation_r13,
        _BT_ProvideLocationInformation_r13_bt_Error_r13,
        BT_ProvideLocationInformation_r13,
        _BT_MeasurementInformation_r13_measurementReferenceTime_r13,
        _BT_MeasurementInformation_r13_bt_MeasurementList_r13,
        BT_MeasurementInformation_r13,
        _BT_MeasurementList_r13__item_,
        BT_MeasurementList_r13,
        _BT_MeasurementElement_r13_btAddr_r13,
        _BT_MeasurementElement_r13_rssi_r13,
        BT_MeasurementElement_r13,
        maxBT_Beacon_r13,
        _BT_RequestLocationInformation_r13_requestedMeasurements_r13,
        BT_RequestLocationInformation_r13,
        _BT_ProvideCapabilities_r13_bt_Modes_r13,
        _BT_ProvideCapabilities_r13_bt_MeasSupported_r13,
        BT_ProvideCapabilities_r13,
        BT_RequestCapabilities_r13,
        _BT_Error_r13_locationServerErrorCauses_r13,
        _BT_Error_r13_targetDeviceErrorCauses_r13,
        BT_Error_r13,
        _BT_LocationServerErrorCauses_r13_cause_r13,
        BT_LocationServerErrorCauses_r13,
        _BT_TargetDeviceErrorCauses_r13_cause_r13,
        _BT_TargetDeviceErrorCauses_r13_bt_Beacon_rssiMeasurementNotPossible_r13,
        BT_TargetDeviceErrorCauses_r13,
    ]

class OMA_LPPE:

    _name_  = u'OMA-LPPE'
    _oid_   = []
    
    _obj_ = [
        u'OMA-LPPe-MessageExtension',
        u'OMA-LPPe-LPPeCompatibilityLevel',
        u'OMA-LPPe-LPPeVersion',
        u'OMA-LPPe-LPPeMode',
        u'OMA-LPPe-MessageExtensionBody',
        u'OMA-LPPe-ver1-1-BroadcastContainer',
        u'OMA-LPPe-ver1-1-BroadcastMessage',
        u'OMA-LPPe-ver1-1-BroadcastControlIEs',
        u'OMA-LPPe-ver1-1-CipheringIEs',
        u'OMA-LPPe-ver1-1-DigitalSignature',
        u'OMA-LPPe-RequestCapabilities',
        u'OMA-LPPe-ProvideCapabilities',
        u'OMA-LPPe-RequestAssistanceData',
        u'OMA-LPPe-ProvideAssistanceData',
        u'OMA-LPPe-RequestLocationInformation',
        u'OMA-LPPe-ProvideLocationInformation',
        u'OMA-LPPe-Abort',
        u'OMA-LPPe-Error',
        u'OMA-LPPe-AssistanceContainer-DataSerialNumber',
        u'OMA-LPPe-AssistanceContainerID',
        u'OMA-LPPe-AssistanceContainerProvideList',
        u'maxAssistanceContainerList',
        u'OMA-LPPe-AssistanceContainerProvide',
        u'OMA-LPPe-AssistanceContainerData',
        u'OMA-LPPe-AssistanceContainerProvideError',
        u'OMA-LPPe-AssistanceContainerRequestList',
        u'OMA-LPPe-AssistanceContainerRequest',
        u'OMA-LPPe-AssistanceContainerCheckOrUpdateReq',
        u'OMA-LPPe-CellLocalIdGERAN',
        u'OMA-LPPe-CellNonUniqueIDGERAN',
        u'OMA-LPPe-CharArray',
        u'OMA-LPPe-CivicLocation',
        u'OMA-LPPe-CivicAddressElementList',
        u'OMA-LPPe-CivicAddressElement',
        u'OMA-LPPe-Duration',
        u'OMA-LPPe-FixedAccessTypes',
        u'OMA-LPPe-ver1-1-GroundMorphologyModel',
        u'OMA-LPPe-ver1-1-AltitudeModel',
        u'OMA-LPPe-ver1-1-BuildingsHeightModel',
        u'DeltaAltitudes',
        u'DeltaHeight',
        u'OMA-LPPe-ver1-1-CellGlobalID',
        u'OMA-LPPe-HighAccuracy3Dposition',
        u'OMA-LPPe-HighAccuracy3Dvelocity',
        u'OMA-LPPe-LocationInformationContainerID',
        u'OMA-LPPe-LocationInformationContainer',
        u'OMA-LPPe-LocationInformationContainerDataList',
        u'OMA-LPPe-LocationInformationContainerData',
        u'OMA-LPPe-LocationInformationContainerRequest',
        u'OMA-LPPe-LocationInformationContainerRequestList',
        u'maxLocationInformationContainerDataList',
        u'OMA-LPPe-LocationInformationContainerRequestItem',
        u'OMA-LPPe-MapDataReference',
        u'OMA-LPPe-Orientation',
        u'OMA-LPPe-ReferencePoint',
        u'OMA-LPPe-MapDataInformation',
        u'OMA-LPPe-MapDataReferenceElement',
        u'OMA-LPPe-ReferencePointRelationship',
        u'OMA-LPPe-ReferencePointUniqueID',
        u'OMA-LPPe-RelativeLocation',
        u'OMA-LPPe-HorizontalUncertaintyAndConfidence',
        u'OMA-LPPe-RelativeAltitude',
        u'OMA-LPPe-GeodeticRelativeAltitude',
        u'OMA-LPPe-GeodeticUncertaintyAndConfidence',
        u'OMA-LPPe-CivicRelativeAltitude',
        u'OMA-LPPe-CivicUncertaintyAndConfidence',
        u'OMA-LPPe-Session-ID',
        u'OMA-LPPe-Uri',
        u'OMA-LPPe-ver1-1-BroadcastSystemID',
        u'OMA-LPPe-ver1-1-BroadcastADTypes',
        u'OMA-LPPe-ver1-1-LabelSet',
        u'maxLevel1-element',
        u'maxLevel2-element',
        u'maxLevel3-element',
        u'maxFinal-element',
        u'maxLPPLabelSets',
        u'maxLPPeLabelSets',
        u'OMA-LPPe-ver1-1-AccessNetworkID',
        u'OMA-LPPe-ver1-1-MCC-MNC',
        u'OMA-LPPe-ver1-1-BSID',
        u'OMA-LPPe-ver1-1-AuthenticationSetID',
        u'OMA-LPPe-ver1-1-AuthenticationSet',
        u'OMA-LPPe-ver1-1-CipherSetID',
        u'OMA-LPPe-ver1-1-CipherSet',
        u'OMA-LPPe-ver1-1-ServerID',
        u'OMA-LPPe-ValidityArea',
        u'OMA-LPPe-RleList',
        u'OMA-LPPe-ValidityPeriod',
        u'OMA-LPPe-VendorOrOperatorAssistanceDataIdentifier',
        u'OMA-LPPe-VendorOrOperatorID',
        u'OMA-LPPe-NonStandard-VendorOrOperatorID',
        u'OMA-LPPe-WirelessAccessTypes',
        u'OMA-LPPe-WLAN-AP-ID',
        u'OMA-LPPe-WLAN-AP-Type',
        u'OMA-LPPe-WLAN-AP-Type-List',
        u'OMA-LPPe-WLANFemtoCoverageArea',
        u'OMA-LPPe-WLANFemtoCoverageAreaElement',
        u'OMA-LPPe-CommonIEsRequestCapabilities',
        u'OMA-LPPe-IP-Address-RequestCapabilities',
        u'OMA-LPPe-AssistanceContainerSupportReq',
        u'OMA-LPPe-LocationInformationContainerSupportReq',
        u'OMA-LPPe-VendorOrOperatorIDList',
        u'maxVendorOrOperatorIDList',
        u'OMA-LPPe-RelativeLocationChange-RequestCapabilities',
        u'OMA-LPPe-HighAccuracyFormatCapabilitiesReq',
        u'OMA-LPPe-SegmentedAssistanceData-ReqCapabilities',
        u'OMA-LPPe-ReferencePointCapabilitiesReq',
        u'OMA-LPPe-ScheduledLocation-RequestCapabilities',
        u'OMA-LPPe-AccessCapabilitiesReq',
        u'OMA-LPPe-SegmentedLocationInformation-ReqCapabilities',
        u'OMA-LPPe-ver1-1-localCellInformation-ReqCapabilities',
        u'OMA-LPPe-ver1-1-broadcast-ReqCapabilities',
        u'OMA-LPPe-CommonIEsProvideCapabilities',
        u'OMA-LPPe-IP-Address-Capabilities',
        u'OMA-LPPe-AssistanceContainerSupport',
        u'OMA-LPPe-VendorOrOperatorAssistanceContainerList',
        u'OMA-LPPe-AssistanceContainerList',
        u'OMA-LPPe-LocationInformationContainerSupport',
        u'OMA-LPPe-VendorOrOperatorLocationInformationContainerList',
        u'OMA-LPPe-LocationInformationContainerList',
        u'maxLocationInformationContainerList',
        u'OMA-LPPe-RelativeLocationChange-Capabilities',
        u'OMA-LPPe-HighAccuracyFormatCapabilities',
        u'OMA-LPPe-SegmentedAssistanceData-ProvideCapabs',
        u'OMA-LPPe-ReferencePointCapabilities',
        u'OMA-LPPe-ReferencePointProviderSupportElement',
        u'OMA-LPPe-ScheduledLocation-Capabilities',
        u'OMA-LPPe-AccessCapabilities',
        u'OMA-LPPe-SegmentedLocationInformation-ProvideCapabs',
        u'OMA-LPPe-ver1-1-localCellInformation-ProvideCapabilities',
        u'OMA-LPPe-ver1-1-broadcast-ProvideCapabilities',
        u'OMA-LPPe-ver1-1-BroadcastSystem-Capabs',
        u'OMA-LPPe-ver1-1-point2pointAD',
        u'OMA-LPPe-ver1-1-Ciphering',
        u'OMA-LPPe-ver1-1-Authentication',
        u'OMA-LPPe-CommonIEsRequestAssistanceData',
        u'OMA-LPPe-RequestPeriodicADwithUpdate',
        u'TypeOfADRequest',
        u'OMA-LPPe-SegmentedADResume',
        u'OMA-LPPe-ReferencePointAssistanceReq',
        u'OMA-LPPe-ReferencePointAssistanceReqElement',
        u'OMA-LPPe-ver1-1-GroundMorphologyModelReq',
        u'OMA-LPPe-ver1-1-LocalCellInformationReq',
        u'OMA-LPPe-ver1-1-BroadcastAssistanceDataReq',
        u'OMA-LPPe-ver1-1-BroadcastSystem',
        u'OMA-LPPe-CommonIEsProvideAssistanceData',
        u'OMA-LPPe-ProvidePeriodicADwithUpdate',
        u'OMA-LPPe-TypeOfADProvide',
        u'OMA-LPPe-SegmentedADTransfer',
        u'OMA-LPPe-ver1-1-LocalCellInformation',
        u'maxCellSets',
        u'maxCells',
        u'OMA-LPPe-ver1-1-CellInformation',
        u'OMA-LPPe-ver1-1-BroadcastAssistanceData',
        u'OMA-LPPe-ver1-1-EncapsulatedMode',
        u'OMA-LPPe-CommonIEsRequestLocationInformation',
        u'OMA-LPPe-IP-Address-Request',
        u'OMA-LPPe-RequestPeriodicLocInfoWithUpdate',
        u'OMA-LPPe-TypeOfLocInfoRequest',
        u'OMA-LPPe-RelativeLocationChange-Request',
        u'OMA-LPPe-LocalPositionRequest',
        u'OMA-LPPe-ScheduledLocation-Request',
        u'OMA-LPPe-AccessTypeRequest',
        u'OMA-LPPe-SegmentedLIResume',
        u'OMA-LPPe-CommonIEsProvideLocationInformation',
        u'OMA-LPPe-LocalPosition',
        u'OMA-LPPe-IP-Address-List',
        u'maxIPAddress',
        u'OMA-LPPe-IP-Address',
        u'OMA-LPPe-Bearer',
        u'OMA-LPPe-ProvidePeriodicLocInfowithUpdate',
        u'OMA-LPPe-TypeOfLocInfoProvide',
        u'OMA-LPPe-RelativeLocationChangeList',
        u'OMA-LPPe-RelativeLocationChange',
        u'maxRelativeLocation',
        u'OMA-LPPe-ScheduledLocation',
        u'OMA-LPPe-AccessTypes',
        u'OMA-LPPe-SegmentedLITransfer',
        u'OMA-LPPe-TimeStamp',
        u'OMA-LPPe-LocationSource',
        u'OMA-LPPe-CommonIEsAbort',
        u'OMA-LPPe-CommonIEsError',
        u'OMA-LPPe-AGNSS-ProvideAssistanceData',
        u'OMA-LPPe-AGNSS-CommonAssistData',
        u'OMA-LPPe-AGNSS-GenericAssistData',
        u'OMA-LPPe-AGNSS-GenericAssistDataElement',
        u'OMA-LPPe-AGNSS-IonosphericModel',
        u'OMA-LPPe-AGNSS-LocalKlobucharModelList',
        u'OMA-LPPe-AGNSS-LocalKlobucharModelElement',
        u'OMA-LPPe-AGNSS-LocalKlobucharModel',
        u'OMA-LPPe-AGNSS-IonoStormIndication',
        u'OMA-LPPe-AGNSS-StormList',
        u'OMA-LPPe-AGNSS-StormElement',
        u'OMA-LPPe-AGNSS-RleListIono',
        u'OMA-LPPe-AGNSS-RleIonoElement',
        u'OMA-LPPe-AGNSS-NoaaScales',
        u'OMA-LPPe-AGNSS-WideAreaIonoSurfaceControlParametersProvide',
        u'OMA-LPPe-AGNSS-WideAreaIonoSurfaceCommon',
        u'OMA-LPPe-AGNSS-WideAreaIonoSurfacePerSVlist',
        u'OMA-LPPe-AGNSS-WideAreaIonoSurfacePerSVelement',
        u'OMA-LPPe-AGNSS-TroposphereModel',
        u'OMA-LPPe-AGNSS-LocalTroposphereDelayList',
        u'OMA-LPPe-AGNSS-LocalTroposphereDelayAreaElement',
        u'OMA-LPPe-AGNSS-LocalTroposphereDelayTimeElement',
        u'OMA-LPPe-AGNSS-LocalSurfaceParametersList',
        u'OMA-LPPe-AGNSS-LocalSurfaceParametersAreaElement',
        u'OMA-LPPe-AGNSS-LocalSurfaceParametersTimeElement',
        u'OMA-LPPe-AGNSS-MappingFunctionParameters',
        u'OMA-LPPe-AGNSS-AltitudeAssistanceList',
        u'OMA-LPPe-AGNSS-AltitudeAssistanceAreaElement',
        u'OMA-LPPe-AGNSS-PressureAssistanceElement',
        u'OMA-LPPe-AGNSS-SolarRadiation',
        u'OMA-LPPe-AGNSS-MechanicsForAllSVs',
        u'OMA-LPPe-AGNSS-MechanicsElement',
        u'OMA-LPPe-AGNSS-PCOelement',
        u'OMA-LPPe-AGNSS-SVtype',
        u'OMA-LPPe-AGNSS-DCBsForAllSVs',
        u'OMA-LPPe-AGNSS-DCBlistElement',
        u'OMA-LPPe-AGNSS-DCBlist',
        u'OMA-LPPe-AGNSS-DCBelement',
        u'OMA-LPPe-AGNSS-NavModelDegradationModelList',
        u'OMA-LPPe-AGNSS-NavModelDegradationModelElement',
        u'OMA-LPPe-AGNSS-ClockModelDegradationModel',
        u'OMA-LPPe-AGNSS-OrbitModelDegradationModel',
        u'OMA-LPPe-AGNSS-CCPassistCommonProvide',
        u'OMA-LPPe-AGNSS-CCPprovideCommonParameters',
        u'OMA-LPPe-AGNSS-CCPprovideControlParameters',
        u'OMA-LPPe-AGNSS-CCPsupportArea',
        u'OMA-LPPe-AGNSS-CCPsignalSupport',
        u'OMA-LPPe-AGNSS-CCPreferenceStationList',
        u'OMA-LPPe-AGNSS-CCPreferenceStationElement',
        u'OMA-LPPe-AGNSS-CCPassistGenericProvide',
        u'OMA-LPPe-AGNSS-CCPassistGenericProvideElement',
        u'OMA-LPPe-AGNSS-CCPperSignalElement',
        u'OMA-LPPe-AGNSS-CCPperSVelement',
        u'OMA-LPPe-AGNSS-CodePhaseError',
        u'OMA-LPPe-AGNSS-NavModelList',
        u'OMA-LPPe-AGNSS-NavModel-CoordinateBased',
        u'OMA-LPPe-AGNSS-NavModel-CoordinateBasedElement',
        u'OMA-LPPe-AGNSS-NavModel-PVTelement',
        u'OMA-LPPe-AGNSS-NavModel-BigNumber',
        u'OMA-LPPe-AGNSS-NavModel-STDmatrix',
        u'OMA-LPPe-AGNSS-RequestAssistanceData',
        u'OMA-LPPe-AGNSS-CommonAssistanceDataReq',
        u'OMA-LPPe-AGNSS-GenericAssistanceDataReq',
        u'OMA-LPPe-AGNSS-GenericAssistDataReqElement',
        u'OMA-LPPe-AGNSS-IonosphericModelReq',
        u'OMA-LPPe-AGNSS-WideAreaIonoSurfaceControlParametersRequest',
        u'OMA-LPPe-AGNSS-TroposphereModelReq',
        u'OMA-LPPe-AGNSS-AltitudeAssistanceReq',
        u'OMA-LPPe-AGNSS-SolarRadiationReq',
        u'OMA-LPPe-AGNSS-WaIonoSurfaceRequest',
        u'OMA-LPPe-AGNSS-NavModelDegradationModelReq',
        u'OMA-LPPe-AGNSS-DCBreq',
        u'OMA-LPPe-AGNSS-MechanicsReq',
        u'OMA-LPPe-AGNSS-CCPrequestControlParameters',
        u'OMA-LPPe-AGNSS-ReferenceStationIDlist',
        u'OMA-LPPe-AGNSS-QoR',
        u'OMA-LPPe-AGNSS-CCPassistGenericReq',
        u'OMA-LPPe-AGNSS-NavigationModelReq',
        u'OMA-LPPe-AGNSS-ProvideLocationInformation',
        u'OMA-LPPe-AGNSS-HAgnssProvide',
        u'OMA-LPPe-AGNSS-HAgnssMeasurementElement',
        u'OMA-LPPe-HAgnssPerSignalElement',
        u'OMA-LPPe-HAgnssPerSVelement',
        u'OMA-LPPe-AGNSS-IonosphereMeasurements',
        u'OMA-LPPe-AGNSS-TECPerSV',
        u'OMA-LPPe-AGNSS-TECPerSVElement',
        u'OMA-LPPe-AGNSS-TECAtZenith',
        u'OMA-LPPe-AGNSS-LocalSurfaceMeasurements',
        u'OMA-LPPe-AGNSS-RequestLocationInformation',
        u'OMA-LPPe-AGNSS-PositioningInstructions',
        u'OMA-LPPe-AGNSS-LocalSurfaceMeasurementReq',
        u'OMA-LPPe-AGNSS-HAgnssRequestControlParameters',
        u'OMA-LPPe-AGNSS-HAgnssSignalReqElement',
        u'OMA-LPPe-AGNSS-ProvideCapabilities',
        u'OMA-LPPe-AGNSS-AssistanceDataSupportList',
        u'OMA-LPPe-AGNSS-EnvironmentObservationSupportList',
        u'OMA-LPPe-AGNSS-CommonAssistanceDataSupport',
        u'OMA-LPPe-AGNSS-IonosphericModelSupport',
        u'OMA-LPPe-AGNSS-TroposphereModelSupport',
        u'OMA-LPPe-AGNSS-AltitudeAssistanceSupport',
        u'OMA-LPPe-AGNSS-SolarRadiationSupport',
        u'OMA-LPPe-AGNSS-CCPsupport',
        u'OMA-LPPe-AGNSS-GenericAssistanceDataSupport',
        u'OMA-LPPe-AGNSS-GenericAssistDataSupportElement',
        u'OMA-LPPe-AGNSS-MechanicsSupport',
        u'OMA-LPPe-AGNSS-DCBsupport',
        u'OMA-LPPe-AGNSS-NavModelAccuracyModelDegradationSupport',
        u'OMA-LPPe-AGNSS-NavModelSupport',
        u'OMA-LPPe-AGNSS-HAgnssSupport',
        u'OMA-LPPe-AGNSS-HAgnssPerGNSSsupport',
        u'OMA-LPPe-AGNSS-RequestCapabilities',
        u'OMA-LPPe-AGNSS-Error',
        u'OMA-LPPe-AGNSS-LocationServerErrorCauses',
        u'OMA-LPPe-AGNSS-TargetDeviceErrorCauses',
        u'OMA-LPPe-AGNSS-CCPreferenceStationID',
        u'maxReferenceStations',
        u'OMA-LPPe-AGNSS-AntennaDescription',
        u'OMA-LPPe-AGNSS-Abort',
        u'OMA-LPPe-OTDOA-ProvideAssistanceData',
        u'OMA-LPPe-OTDOA-ReferenceCellInfo',
        u'OMA-LPPe-OTDOA-PositionCalculationInfoRef',
        u'OMA-LPPe-OTDOA-NeighbourCellInfoList',
        u'maxFreqLayers',
        u'OMA-LPPe-OTDOA-NeighbourFreqCellInfoList',
        u'OMA-LPPe-OTDOA-NeighbourCellInfoElement-eNB',
        u'OMA-LPPe-OTDOA-NeighbourCellInfoElement-HeNB',
        u'OMA-LPPe-OTDOA-CellData',
        u'OMA-LPPe-OTDOA-RTDquality',
        u'OMA-LPPe-OTDOA-RequestAssistanceData',
        u'OMA-LPPe-OTDOA-ProvideLocationInformation',
        u'OMA-LPPe-OTDOA-LocationInformation',
        u'OMA-LPPe-OTDOA-RequestLocationInformation',
        u'OMA-LPPe-OTDOA-ProvideCapabilities',
        u'OMA-LPPe-OTDOA-RequestCapabilities',
        u'OMA-LPPe-OTDOA-Error',
        u'OMA-LPPe-OTDOA-LocationServerErrorCauses',
        u'OMA-LPPe-OTDOA-TargetDeviceErrorCauses',
        u'OMA-LPPe-EOTD-ProvideAssistanceData',
        u'OMA-LPPe-EOTD-ReferenceBTSForAssistance',
        u'OMA-LPPe-EOTD-MsrAssistDataList',
        u'OMA-LPPe-EOTD-MsrAssistBTS',
        u'OMA-LPPe-EOTD-SystemInfoAssistDataList',
        u'OMA-LPPe-EOTD-SystemInfoAssistBTS',
        u'OMA-LPPe-EOTD-AssistBTSData',
        u'OMA-LPPe-EOTD-CalcAssistanceBTS',
        u'OMA-LPPe-EOTD-relativePos',
        u'OMA-LPPe-EOTD-FineRTD',
        u'OMA-LPPe-EOTD-RelDistance',
        u'OMA-LPPe-EOTD-RelativeAlt',
        u'OMA-LPPe-EOTD-RequestAssistanceData',
        u'OMA-LPPe-EOTD-ProvideLocationInformation',
        u'OMA-LPPe-EOTD-MsrElement',
        u'OMA-LPPe-EOTD-TOA-MeasurementsOfRef',
        u'OMA-LPPe-EOTD-MeasurementWithID',
        u'OMA-LPPe-EOTD-NeighborIdentity',
        u'OMA-LPPe-EOTD-EOTDQuality',
        u'OMA-LPPe-EOTD-OTDValue',
        u'OMA-LPPe-EOTD-CellID',
        u'OMA-LPPe-EOTD-RequestIndex',
        u'OMA-LPPe-EOTD-SystemInfoIndex',
        u'OMA-LPPe-EOTD-MultiFrameCarrier',
        u'OMA-LPPe-EOTD-BCCHCarrier',
        u'OMA-LPPe-EOTD-RequestLocationInformation',
        u'OMA-LPPe-EOTD-ProvideCapabilities',
        u'OMA-LPPe-EOTD-RequestCapabilities',
        u'OMA-LPPe-EOTD-Error',
        u'OMA-LPPe-EOTD-LocationServerErrorCauses',
        u'OMA-LPPe-EOTD-TargetDeviceErrorCauses',
        u'OMA-LPPe-EOTD-TimeSlotScheme',
        u'OMA-LPPe-EOTD-MultiFrameOffset',
        u'OMA-LPPe-EOTD-RoughRTD',
        u'OMA-LPPe-EOTD-ExpectedOTD',
        u'OMA-LPPe-EOTD-ModuloTimeSlot',
        u'OMA-LPPe-OTDOA-UTRA-ProvideAssistanceData',
        u'OMA-LPPe-OTDOA-UTRA-ReferenceCellInfo',
        u'OMA-LPPe-OTDOA-UTRA-RefPosAssist',
        u'OMA-LPPe-OTDOA-UTRA-NeighborCellList',
        u'OMA-LPPe-OTDOA-UTRA-NeighborCellInfo',
        u'OMA-LPPe-OTDOA-UTRA-SFN-SFN-RelTimeDifference1',
        u'OMA-LPPe-OTDOA-UTRA-PositioningAssistance',
        u'utra-maxCellMeas',
        u'OMA-LPPe-OTDOA-UTRA-SFN-OffsetValidity',
        u'OMA-LPPe-OTDOA-UTRA-SFN-SFN-Drift',
        u'OMA-LPPe-OTDOA-UTRA-SearchWindowSize',
        u'OMA-LPPe-OTDOA-UTRA-fineSFN-SFN',
        u'OMA-LPPe-OTDOA-UTRA-IPDL-Parameters',
        u'OMA-LPPe-OTDOA-UTRA-IP-Spacing',
        u'OMA-LPPe-OTDOA-UTRA-IP-Length',
        u'OMA-LPPe-OTDOA-UTRA-IP-Spacing-TDD',
        u'OMA-LPPe-OTDOA-UTRA-IP-PCCPCH',
        u'OMA-LPPe-OTDOA-UTRA-BurstModeParameters',
        u'OMA-LPPe-OTDOA-UTRA-RequestAssistanceData',
        u'OMA-LPPe-OTDOA-UTRA-ProvideLocationInformation',
        u'OMA-LPPe-OTDOA-UTRA-Measurement',
        u'OMA-LPPe-OTDOA-UTRA-UE-RX-TX-TimeDifferenceType2Info',
        u'OMA-LPPe-OTDOA-UTRA-TimeDifferenceType2',
        u'OMA-LPPe-OTDOA-UTRA-NeighborList',
        u'OMA-LPPe-OTDOA-UTRA-Neighbor',
        u'OMA-LPPe-OTDOA-UTRA-NeighborQuality',
        u'OMA-LPPe-OTDOA-UTRA-SFN-SFN-ObsTimeDifference2',
        u'OMA-LPPe-OTDOA-UTRA-Quality',
        u'OMA-LPPe-OTDOA-UTRA-TimeStampData',
        u'OMA-LPPe-OTDOA-UTRA-RequestLocationInformation',
        u'OMA-LPPe-OTDOA-UTRA-ProvideCapabilities',
        u'OMA-LPPe-OTDOA-UTRA-RequestCapabilities',
        u'OMA-LPPe-OTDOA-UTRA-Error',
        u'OMA-LPPe-OTDOA-UTRA-LocationServerErrorCauses',
        u'OMA-LPPe-OTDOA-UTRA-TargetDeviceErrorCauses',
        u'OMA-LPPe-OTDOA-UTRA-PrimaryCPICH-Info',
        u'OMA-LPPe-OTDOA-UTRA-PrimaryScramblingCode',
        u'OMA-LPPe-OTDOA-UTRA-CellAndChannelIdentity',
        u'OMA-LPPe-OTDOA-UTRA-BurstType',
        u'OMA-LPPe-OTDOA-UTRA-MidambleShiftLong',
        u'OMA-LPPe-OTDOA-UTRA-TimeSlotNumber',
        u'OMA-LPPe-OTDOA-UTRA-CellParametersID',
        u'OMA-LPPe-ECID-LTE-ProvideAssistanceData',
        u'maxLTENetworks',
        u'OMA-LPPe-ECID-LTE-NetworkData',
        u'maxLTEeNBs',
        u'maxLTEHeNBs',
        u'OMA-LPPe-ECID-LTE-eNodeBData',
        u'maxLTEMacroCells',
        u'OMA-LPPe-ECID-LTE-HeNBData',
        u'OMA-LPPe-ECID-LTE-CellData',
        u'OMA-LPPe-ECID-LTE-RequestAssistanceData',
        u'OMA-LPPe-ECID-LTE-ProvideLocationInformation',
        u'OMA-LPPe-ECID-LTE-LocationInformationList',
        u'maxLTEECIDSize',
        u'OMA-LPPe-ECID-LTE-LocationInformation',
        u'OMA-LPPe-ECID-LTE-RequestLocationInformation',
        u'OMA-LPPe-ECID-LTE-ProvideCapabilities',
        u'OMA-LPPe-ECID-LTE-RequestCapabilities',
        u'OMA-LPPe-ECID-LTE-Error',
        u'OMA-LPPe-ECID-LTE-LocationServerErrorCauses',
        u'OMA-LPPe-ECID-LTE-TargetDeviceErrorCauses',
        u'OMA-LPPe-ECID-GSM-ProvideAssistanceData',
        u'maxGSMNetworks',
        u'OMA-LPPe-ECID-GSM-NetworkData',
        u'maxGSMBaseStations',
        u'OMA-LPPe-ECID-GSM-BaseStationData',
        u'maxGSMCells',
        u'OMA-LPPe-ECID-GSM-CellData',
        u'OMA-LPPe-ECID-GSM-RequestAssistanceData',
        u'OMA-LPPe-ECID-GSM-ProvideLocationInformation',
        u'OMA-LPPe-ECID-GSM-LocationInformationList',
        u'maxGSMECIDSize',
        u'OMA-LPPe-ECID-GSM-LocationInformation',
        u'OMA-LPPe-NMR-GERAN',
        u'OMA-LPPe-ECID-GSM-RequestLocationInformation',
        u'OMA-LPPe-ECID-GSM-ProvideCapabilities',
        u'OMA-LPPe-ECID-GSM-RequestCapabilities',
        u'OMA-LPPe-ECID-GSM-Error',
        u'OMA-LPPe-ECID-GSM-LocationServerErrorCauses',
        u'OMA-LPPe-ECID-GSM-TargetDeviceErrorCauses',
        u'OMA-LPPe-ECID-UTRA-ProvideAssistanceData',
        u'maxUTRANetworks',
        u'OMA-LPPe-ECID-UTRA-NetworkData',
        u'maxUTRAnodeBs',
        u'maxUTRAHNBs',
        u'OMA-LPPe-ECID-UTRA-NodeBData',
        u'maxUTRAMacroCells',
        u'OMA-LPPe-ECID-UTRA-HNBData',
        u'OMA-LPPe-ECID-UTRA-CellData',
        u'OMA-LPPe-ECID-UTRA-RequestAssistanceData',
        u'OMA-LPPe-ECID-UTRA-ProvideLocationInformation',
        u'OMA-LPPe-ECID-UTRA-LocationInformationList',
        u'maxECIDUTRASize',
        u'OMA-LPPe-ECID-UTRA-LocationInformation',
        u'OMA-LPPe-ECID-UTRA-UTRATimingAdvance',
        u'OMA-LPPe-ECID-UTRA-TAResolution',
        u'OMA-LPPe-ECID-UTRA-ChipRate',
        u'OMA-LPPe-UTRA-FrequencyInfo',
        u'OMA-LPPe-UTRA-ModeSpecificInfo',
        u'OMA-LPPe-UTRA-FrequencyInfoFDD',
        u'OMA-LPPe-UTRA-FrequencyInfoTDD',
        u'OMA-LPPe-ECID-UTRA-MeasuredResultsList',
        u'OMA-LPPe-ECID-UTRA-MeasuredResults',
        u'OMA-LPPe-ECID-UTRA-CellMeasuredResultsList',
        u'OMA-LPPe-ECID-UTRA-CarrierRSSI',
        u'OMA-LPPe-ECID-UTRA-CellMeasuredResults',
        u'OMA-LPPe-ECID-UTRA-PrimaryCCPCH-RSCP',
        u'OMA-LPPe-ECID-UTRA-CPICH-Ec-N0',
        u'OMA-LPPe-ECID-UTRA-CPICH-RSCP',
        u'OMA-LPPe-ECID-UTRA-Pathloss',
        u'maxFreq',
        u'OMA-LPPe-ECID-UTRA-RequestLocationInformation',
        u'OMA-LPPe-ECID-UTRA-ProvideCapabilities',
        u'OMA-LPPe-ECID-UTRA-RequestCapabilities',
        u'OMA-LPPe-ECID-UTRA-Error',
        u'OMA-LPPe-ECID-UTRA-LocationServerErrorCauses',
        u'OMA-LPPe-ECID-UTRA-TargetDeviceErrorCauses',
        u'OMA-LPPe-WLAN-AP-ProvideAssistanceData',
        u'maxWLANDataSets',
        u'OMA-LPPe-WLAN-DataSet',
        u'maxWLANAPs',
        u'Supported-Channels-11a',
        u'Supported-Channels-11bg',
        u'OMA-LPPe-WLAN-AP-Data',
        u'maxWLANTypes',
        u'OMA-LPPe-WLAN-AP-Type-Data',
        u'OMA-LPPe-WLAN-AP-RequestAssistanceData',
        u'OMA-LPPe-WLAN-AP-ProvideLocationInformation',
        u'OMA-LPPe-WLAN-AP-LocationInformationList',
        u'maxWLANAPSize',
        u'OMA-LPPe-WLAN-AP-LocationInformation',
        u'OMA-LPPe-WLAN-AP-PHY-Type',
        u'OMA-LPPe-WLAN-RTD',
        u'OMA-LPPe-WLAN-RTDUnits',
        u'OMA-LPPe-WLAN-ReportedLocation',
        u'OMA-LPPe-WLAN-LocationDataLCI',
        u'OMA-LPPe-WLAN-AP-RequestLocationInformation',
        u'OMA-LPPe-WLAN-AP-ProvideCapabilities',
        u'OMA-LPPe-WLAN-AP-Capability',
        u'OMA-LPPe-WLAN-AP-RequestCapabilities',
        u'OMA-LPPe-WLAN-AP-Error',
        u'OMA-LPPe-WLAN-AP-LocationServerErrorCauses',
        u'OMA-LPPe-WLAN-AP-TargetDeviceErrorCauses',
        u'OMA-LPPe-ECID-WiMax-ProvideLocationInformation',
        u'OMA-LPPe-ECID-WiMax-LocationInformationList',
        u'maxWiMaxECIDSize',
        u'OMA-LPPe-ECID-WiMax-LocationInformation',
        u'OMA-LPPe-ECID-WiMax-WimaxBsID',
        u'OMA-LPPe-ECID-WiMax-WimaxRTD',
        u'OMA-LPPe-ECID-WiMax-WimaxNMRList',
        u'OMA-LPPe-ECID-WiMax-WimaxNMR',
        u'maxWimaxBSMeas',
        u'OMA-LPPe-ECID-WiMax-RequestLocationInformation',
        u'OMA-LPPe-ECID-WiMax-ProvideCapabilities',
        u'OMA-LPPe-ECID-WiMax-RequestCapabilities',
        u'OMA-LPPe-ECID-WiMax-Error',
        u'OMA-LPPe-ECID-WiMax-LocationServerErrorCauses',
        u'OMA-LPPe-ECID-WiMax-TargetDeviceErrorCauses',
        u'OMA-LPPe-Sensor-ProvideAssistanceData',
        u'OMA-LPPe-AtmosphericPressureAD',
        u'OMA-LPPe-PressureValidityArea',
        u'OMA-LPPe-Sensor-RequestAssistanceData',
        u'OMA-LPPe-PressureSensorAD',
        u'OMA-LPPe-Sensor-ProvideLocationInformation',
        u'OMA-LPPe-Sensor-MotionStateList',
        u'OMA-LPPe-Sensor-MotionStateElement',
        u'OMA-LPPe-Sensor-RequestLocationInformation',
        u'OMA-LPPe-Sensor-MotionStateRequest',
        u'OMA-LPPe-Sensor-ProvideCapabilities',
        u'OMA-LPPe-Sensor-RequestCapabilities',
        u'OMA-LPPe-Sensor-Error',
        u'OMA-LPPe-Sensor-TargetError',
        u'OMA-LPPe-SRN-ProvideAssistanceData',
        u'OMA-LPPe-SRN-SRNgroupList',
        u'OMA-LPPe-SRN-SRNgroup',
        u'OMA-LPPe-SRN-SRNinfo',
        u'OMA-LPPe-SRN-SRNgroupUpdateResponse',
        u'OMA-LPPe-SRN-SRNgroupUpdateResponseElement',
        u'OMA-LPPe-SRN-AntennaPattern',
        u'OMA-LPPe-SRN-AntennaPatternElement',
        u'OMA-LPPe-SRN-AntennaPatternForChannels',
        u'OMA-LPPe-SRN-ChannelResponse',
        u'OMA-LPPe-SRN-ResponseInElevation',
        u'OMA-LPPe-SRN-ResponseInAzimuth',
        u'OMA-LPPe-ComplexNumber',
        u'maxChannels',
        u'OMA-LPPe-SRN-RequestAssistanceData',
        u'OMA-LPPe-SRN-SRNgroupRequest',
        u'OMA-LPPe-SRN-SRNProvideList',
        u'OMA-LPPe-SRN-SRNgroupUpdateRequest',
        u'OMA-LPPe-SRN-SRNgroupUpdateRequestElement',
        u'OMA-LPPe-SRN-AntennaPatternRequest',
        u'OMA-LPPe-SRN-AntennaPatternRequestElement',
        u'OMA-LPPe-SRN-ProvideLocationInformation',
        u'OMA-LPPe-SRN-MeasurementElement',
        u'OMA-LPPe-SRN-srnMeasurementElement',
        u'OMA-LPPe-SRN-RequestLocationInformation',
        u'OMA-LPPe-SRN-ReqLocInfo-Category',
        u'OMA-LPPe-SRN-ProvideCapabilities',
        u'OMA-LPPe-SRN-ProvideCapabilitiesElement',
        u'OMA-LPPe-SRN-RequestCapabilities',
        u'OMA-LPPe-SRN-Error',
        u'OMA-LPPe-SRN-LocationServerErrorCauses',
        u'OMA-LPPe-SRN-TargetDeviceErrorCauses',
        u'OMA-LPPe-SRN-TargetDeviceError',
        u'OMA-LPPe-SRN-SRNgroupUniqueID',
        u'OMA-LPPe-SRN-SRNtype',
        u'OMA-LPPe-SRN-Category',
        u'OMA-LPPe-SRN-SRNid',
        u'OMA-LPPe-SRN-Technologies',
        u'OMA-LPPe-SRN-MeasurementMask',
        ]
    _type_ = [
        u'OMA-LPPe-MessageExtension',
        u'OMA-LPPe-LPPeCompatibilityLevel',
        u'OMA-LPPe-LPPeVersion',
        u'OMA-LPPe-LPPeMode',
        u'OMA-LPPe-MessageExtensionBody',
        u'OMA-LPPe-ver1-1-BroadcastContainer',
        u'OMA-LPPe-ver1-1-BroadcastMessage',
        u'OMA-LPPe-ver1-1-BroadcastControlIEs',
        u'OMA-LPPe-ver1-1-CipheringIEs',
        u'OMA-LPPe-ver1-1-DigitalSignature',
        u'OMA-LPPe-RequestCapabilities',
        u'OMA-LPPe-ProvideCapabilities',
        u'OMA-LPPe-RequestAssistanceData',
        u'OMA-LPPe-ProvideAssistanceData',
        u'OMA-LPPe-RequestLocationInformation',
        u'OMA-LPPe-ProvideLocationInformation',
        u'OMA-LPPe-Abort',
        u'OMA-LPPe-Error',
        u'OMA-LPPe-AssistanceContainer-DataSerialNumber',
        u'OMA-LPPe-AssistanceContainerID',
        u'OMA-LPPe-AssistanceContainerProvideList',
        u'OMA-LPPe-AssistanceContainerProvide',
        u'OMA-LPPe-AssistanceContainerData',
        u'OMA-LPPe-AssistanceContainerProvideError',
        u'OMA-LPPe-AssistanceContainerRequestList',
        u'OMA-LPPe-AssistanceContainerRequest',
        u'OMA-LPPe-AssistanceContainerCheckOrUpdateReq',
        u'OMA-LPPe-CellLocalIdGERAN',
        u'OMA-LPPe-CellNonUniqueIDGERAN',
        u'OMA-LPPe-CharArray',
        u'OMA-LPPe-CivicLocation',
        u'OMA-LPPe-CivicAddressElementList',
        u'OMA-LPPe-CivicAddressElement',
        u'OMA-LPPe-Duration',
        u'OMA-LPPe-FixedAccessTypes',
        u'OMA-LPPe-ver1-1-GroundMorphologyModel',
        u'OMA-LPPe-ver1-1-AltitudeModel',
        u'OMA-LPPe-ver1-1-BuildingsHeightModel',
        u'DeltaAltitudes',
        u'DeltaHeight',
        u'OMA-LPPe-ver1-1-CellGlobalID',
        u'OMA-LPPe-HighAccuracy3Dposition',
        u'OMA-LPPe-HighAccuracy3Dvelocity',
        u'OMA-LPPe-LocationInformationContainerID',
        u'OMA-LPPe-LocationInformationContainer',
        u'OMA-LPPe-LocationInformationContainerDataList',
        u'OMA-LPPe-LocationInformationContainerData',
        u'OMA-LPPe-LocationInformationContainerRequest',
        u'OMA-LPPe-LocationInformationContainerRequestList',
        u'OMA-LPPe-LocationInformationContainerRequestItem',
        u'OMA-LPPe-MapDataReference',
        u'OMA-LPPe-Orientation',
        u'OMA-LPPe-ReferencePoint',
        u'OMA-LPPe-MapDataInformation',
        u'OMA-LPPe-MapDataReferenceElement',
        u'OMA-LPPe-ReferencePointRelationship',
        u'OMA-LPPe-ReferencePointUniqueID',
        u'OMA-LPPe-RelativeLocation',
        u'OMA-LPPe-HorizontalUncertaintyAndConfidence',
        u'OMA-LPPe-RelativeAltitude',
        u'OMA-LPPe-GeodeticRelativeAltitude',
        u'OMA-LPPe-GeodeticUncertaintyAndConfidence',
        u'OMA-LPPe-CivicRelativeAltitude',
        u'OMA-LPPe-CivicUncertaintyAndConfidence',
        u'OMA-LPPe-Session-ID',
        u'OMA-LPPe-Uri',
        u'OMA-LPPe-ver1-1-BroadcastSystemID',
        u'OMA-LPPe-ver1-1-BroadcastADTypes',
        u'OMA-LPPe-ver1-1-LabelSet',
        u'OMA-LPPe-ver1-1-AccessNetworkID',
        u'OMA-LPPe-ver1-1-MCC-MNC',
        u'OMA-LPPe-ver1-1-BSID',
        u'OMA-LPPe-ver1-1-AuthenticationSetID',
        u'OMA-LPPe-ver1-1-AuthenticationSet',
        u'OMA-LPPe-ver1-1-CipherSetID',
        u'OMA-LPPe-ver1-1-CipherSet',
        u'OMA-LPPe-ver1-1-ServerID',
        u'OMA-LPPe-ValidityArea',
        u'OMA-LPPe-RleList',
        u'OMA-LPPe-ValidityPeriod',
        u'OMA-LPPe-VendorOrOperatorAssistanceDataIdentifier',
        u'OMA-LPPe-VendorOrOperatorID',
        u'OMA-LPPe-NonStandard-VendorOrOperatorID',
        u'OMA-LPPe-WirelessAccessTypes',
        u'OMA-LPPe-WLAN-AP-ID',
        u'OMA-LPPe-WLAN-AP-Type',
        u'OMA-LPPe-WLAN-AP-Type-List',
        u'OMA-LPPe-WLANFemtoCoverageArea',
        u'OMA-LPPe-WLANFemtoCoverageAreaElement',
        u'OMA-LPPe-CommonIEsRequestCapabilities',
        u'OMA-LPPe-IP-Address-RequestCapabilities',
        u'OMA-LPPe-AssistanceContainerSupportReq',
        u'OMA-LPPe-LocationInformationContainerSupportReq',
        u'OMA-LPPe-VendorOrOperatorIDList',
        u'OMA-LPPe-RelativeLocationChange-RequestCapabilities',
        u'OMA-LPPe-HighAccuracyFormatCapabilitiesReq',
        u'OMA-LPPe-SegmentedAssistanceData-ReqCapabilities',
        u'OMA-LPPe-ReferencePointCapabilitiesReq',
        u'OMA-LPPe-ScheduledLocation-RequestCapabilities',
        u'OMA-LPPe-AccessCapabilitiesReq',
        u'OMA-LPPe-SegmentedLocationInformation-ReqCapabilities',
        u'OMA-LPPe-ver1-1-localCellInformation-ReqCapabilities',
        u'OMA-LPPe-ver1-1-broadcast-ReqCapabilities',
        u'OMA-LPPe-CommonIEsProvideCapabilities',
        u'OMA-LPPe-IP-Address-Capabilities',
        u'OMA-LPPe-AssistanceContainerSupport',
        u'OMA-LPPe-VendorOrOperatorAssistanceContainerList',
        u'OMA-LPPe-AssistanceContainerList',
        u'OMA-LPPe-LocationInformationContainerSupport',
        u'OMA-LPPe-VendorOrOperatorLocationInformationContainerList',
        u'OMA-LPPe-LocationInformationContainerList',
        u'OMA-LPPe-RelativeLocationChange-Capabilities',
        u'OMA-LPPe-HighAccuracyFormatCapabilities',
        u'OMA-LPPe-SegmentedAssistanceData-ProvideCapabs',
        u'OMA-LPPe-ReferencePointCapabilities',
        u'OMA-LPPe-ReferencePointProviderSupportElement',
        u'OMA-LPPe-ScheduledLocation-Capabilities',
        u'OMA-LPPe-AccessCapabilities',
        u'OMA-LPPe-SegmentedLocationInformation-ProvideCapabs',
        u'OMA-LPPe-ver1-1-localCellInformation-ProvideCapabilities',
        u'OMA-LPPe-ver1-1-broadcast-ProvideCapabilities',
        u'OMA-LPPe-ver1-1-BroadcastSystem-Capabs',
        u'OMA-LPPe-ver1-1-point2pointAD',
        u'OMA-LPPe-ver1-1-Ciphering',
        u'OMA-LPPe-ver1-1-Authentication',
        u'OMA-LPPe-CommonIEsRequestAssistanceData',
        u'OMA-LPPe-RequestPeriodicADwithUpdate',
        u'TypeOfADRequest',
        u'OMA-LPPe-SegmentedADResume',
        u'OMA-LPPe-ReferencePointAssistanceReq',
        u'OMA-LPPe-ReferencePointAssistanceReqElement',
        u'OMA-LPPe-ver1-1-GroundMorphologyModelReq',
        u'OMA-LPPe-ver1-1-LocalCellInformationReq',
        u'OMA-LPPe-ver1-1-BroadcastAssistanceDataReq',
        u'OMA-LPPe-ver1-1-BroadcastSystem',
        u'OMA-LPPe-CommonIEsProvideAssistanceData',
        u'OMA-LPPe-ProvidePeriodicADwithUpdate',
        u'OMA-LPPe-TypeOfADProvide',
        u'OMA-LPPe-SegmentedADTransfer',
        u'OMA-LPPe-ver1-1-LocalCellInformation',
        u'OMA-LPPe-ver1-1-CellInformation',
        u'OMA-LPPe-ver1-1-BroadcastAssistanceData',
        u'OMA-LPPe-ver1-1-EncapsulatedMode',
        u'OMA-LPPe-CommonIEsRequestLocationInformation',
        u'OMA-LPPe-IP-Address-Request',
        u'OMA-LPPe-RequestPeriodicLocInfoWithUpdate',
        u'OMA-LPPe-TypeOfLocInfoRequest',
        u'OMA-LPPe-RelativeLocationChange-Request',
        u'OMA-LPPe-LocalPositionRequest',
        u'OMA-LPPe-ScheduledLocation-Request',
        u'OMA-LPPe-AccessTypeRequest',
        u'OMA-LPPe-SegmentedLIResume',
        u'OMA-LPPe-CommonIEsProvideLocationInformation',
        u'OMA-LPPe-LocalPosition',
        u'OMA-LPPe-IP-Address-List',
        u'OMA-LPPe-IP-Address',
        u'OMA-LPPe-Bearer',
        u'OMA-LPPe-ProvidePeriodicLocInfowithUpdate',
        u'OMA-LPPe-TypeOfLocInfoProvide',
        u'OMA-LPPe-RelativeLocationChangeList',
        u'OMA-LPPe-RelativeLocationChange',
        u'OMA-LPPe-ScheduledLocation',
        u'OMA-LPPe-AccessTypes',
        u'OMA-LPPe-SegmentedLITransfer',
        u'OMA-LPPe-TimeStamp',
        u'OMA-LPPe-LocationSource',
        u'OMA-LPPe-CommonIEsAbort',
        u'OMA-LPPe-CommonIEsError',
        u'OMA-LPPe-AGNSS-ProvideAssistanceData',
        u'OMA-LPPe-AGNSS-CommonAssistData',
        u'OMA-LPPe-AGNSS-GenericAssistData',
        u'OMA-LPPe-AGNSS-GenericAssistDataElement',
        u'OMA-LPPe-AGNSS-IonosphericModel',
        u'OMA-LPPe-AGNSS-LocalKlobucharModelList',
        u'OMA-LPPe-AGNSS-LocalKlobucharModelElement',
        u'OMA-LPPe-AGNSS-LocalKlobucharModel',
        u'OMA-LPPe-AGNSS-IonoStormIndication',
        u'OMA-LPPe-AGNSS-StormList',
        u'OMA-LPPe-AGNSS-StormElement',
        u'OMA-LPPe-AGNSS-RleListIono',
        u'OMA-LPPe-AGNSS-RleIonoElement',
        u'OMA-LPPe-AGNSS-NoaaScales',
        u'OMA-LPPe-AGNSS-WideAreaIonoSurfaceControlParametersProvide',
        u'OMA-LPPe-AGNSS-WideAreaIonoSurfaceCommon',
        u'OMA-LPPe-AGNSS-WideAreaIonoSurfacePerSVlist',
        u'OMA-LPPe-AGNSS-WideAreaIonoSurfacePerSVelement',
        u'OMA-LPPe-AGNSS-TroposphereModel',
        u'OMA-LPPe-AGNSS-LocalTroposphereDelayList',
        u'OMA-LPPe-AGNSS-LocalTroposphereDelayAreaElement',
        u'OMA-LPPe-AGNSS-LocalTroposphereDelayTimeElement',
        u'OMA-LPPe-AGNSS-LocalSurfaceParametersList',
        u'OMA-LPPe-AGNSS-LocalSurfaceParametersAreaElement',
        u'OMA-LPPe-AGNSS-LocalSurfaceParametersTimeElement',
        u'OMA-LPPe-AGNSS-MappingFunctionParameters',
        u'OMA-LPPe-AGNSS-AltitudeAssistanceList',
        u'OMA-LPPe-AGNSS-AltitudeAssistanceAreaElement',
        u'OMA-LPPe-AGNSS-PressureAssistanceElement',
        u'OMA-LPPe-AGNSS-SolarRadiation',
        u'OMA-LPPe-AGNSS-MechanicsForAllSVs',
        u'OMA-LPPe-AGNSS-MechanicsElement',
        u'OMA-LPPe-AGNSS-PCOelement',
        u'OMA-LPPe-AGNSS-SVtype',
        u'OMA-LPPe-AGNSS-DCBsForAllSVs',
        u'OMA-LPPe-AGNSS-DCBlistElement',
        u'OMA-LPPe-AGNSS-DCBlist',
        u'OMA-LPPe-AGNSS-DCBelement',
        u'OMA-LPPe-AGNSS-NavModelDegradationModelList',
        u'OMA-LPPe-AGNSS-NavModelDegradationModelElement',
        u'OMA-LPPe-AGNSS-ClockModelDegradationModel',
        u'OMA-LPPe-AGNSS-OrbitModelDegradationModel',
        u'OMA-LPPe-AGNSS-CCPassistCommonProvide',
        u'OMA-LPPe-AGNSS-CCPprovideCommonParameters',
        u'OMA-LPPe-AGNSS-CCPprovideControlParameters',
        u'OMA-LPPe-AGNSS-CCPsupportArea',
        u'OMA-LPPe-AGNSS-CCPsignalSupport',
        u'OMA-LPPe-AGNSS-CCPreferenceStationList',
        u'OMA-LPPe-AGNSS-CCPreferenceStationElement',
        u'OMA-LPPe-AGNSS-CCPassistGenericProvide',
        u'OMA-LPPe-AGNSS-CCPassistGenericProvideElement',
        u'OMA-LPPe-AGNSS-CCPperSignalElement',
        u'OMA-LPPe-AGNSS-CCPperSVelement',
        u'OMA-LPPe-AGNSS-CodePhaseError',
        u'OMA-LPPe-AGNSS-NavModelList',
        u'OMA-LPPe-AGNSS-NavModel-CoordinateBased',
        u'OMA-LPPe-AGNSS-NavModel-CoordinateBasedElement',
        u'OMA-LPPe-AGNSS-NavModel-PVTelement',
        u'OMA-LPPe-AGNSS-NavModel-BigNumber',
        u'OMA-LPPe-AGNSS-NavModel-STDmatrix',
        u'OMA-LPPe-AGNSS-RequestAssistanceData',
        u'OMA-LPPe-AGNSS-CommonAssistanceDataReq',
        u'OMA-LPPe-AGNSS-GenericAssistanceDataReq',
        u'OMA-LPPe-AGNSS-GenericAssistDataReqElement',
        u'OMA-LPPe-AGNSS-IonosphericModelReq',
        u'OMA-LPPe-AGNSS-WideAreaIonoSurfaceControlParametersRequest',
        u'OMA-LPPe-AGNSS-TroposphereModelReq',
        u'OMA-LPPe-AGNSS-AltitudeAssistanceReq',
        u'OMA-LPPe-AGNSS-SolarRadiationReq',
        u'OMA-LPPe-AGNSS-WaIonoSurfaceRequest',
        u'OMA-LPPe-AGNSS-NavModelDegradationModelReq',
        u'OMA-LPPe-AGNSS-DCBreq',
        u'OMA-LPPe-AGNSS-MechanicsReq',
        u'OMA-LPPe-AGNSS-CCPrequestControlParameters',
        u'OMA-LPPe-AGNSS-ReferenceStationIDlist',
        u'OMA-LPPe-AGNSS-QoR',
        u'OMA-LPPe-AGNSS-CCPassistGenericReq',
        u'OMA-LPPe-AGNSS-NavigationModelReq',
        u'OMA-LPPe-AGNSS-ProvideLocationInformation',
        u'OMA-LPPe-AGNSS-HAgnssProvide',
        u'OMA-LPPe-AGNSS-HAgnssMeasurementElement',
        u'OMA-LPPe-HAgnssPerSignalElement',
        u'OMA-LPPe-HAgnssPerSVelement',
        u'OMA-LPPe-AGNSS-IonosphereMeasurements',
        u'OMA-LPPe-AGNSS-TECPerSV',
        u'OMA-LPPe-AGNSS-TECPerSVElement',
        u'OMA-LPPe-AGNSS-TECAtZenith',
        u'OMA-LPPe-AGNSS-LocalSurfaceMeasurements',
        u'OMA-LPPe-AGNSS-RequestLocationInformation',
        u'OMA-LPPe-AGNSS-PositioningInstructions',
        u'OMA-LPPe-AGNSS-LocalSurfaceMeasurementReq',
        u'OMA-LPPe-AGNSS-HAgnssRequestControlParameters',
        u'OMA-LPPe-AGNSS-HAgnssSignalReqElement',
        u'OMA-LPPe-AGNSS-ProvideCapabilities',
        u'OMA-LPPe-AGNSS-AssistanceDataSupportList',
        u'OMA-LPPe-AGNSS-EnvironmentObservationSupportList',
        u'OMA-LPPe-AGNSS-CommonAssistanceDataSupport',
        u'OMA-LPPe-AGNSS-IonosphericModelSupport',
        u'OMA-LPPe-AGNSS-TroposphereModelSupport',
        u'OMA-LPPe-AGNSS-AltitudeAssistanceSupport',
        u'OMA-LPPe-AGNSS-SolarRadiationSupport',
        u'OMA-LPPe-AGNSS-CCPsupport',
        u'OMA-LPPe-AGNSS-GenericAssistanceDataSupport',
        u'OMA-LPPe-AGNSS-GenericAssistDataSupportElement',
        u'OMA-LPPe-AGNSS-MechanicsSupport',
        u'OMA-LPPe-AGNSS-DCBsupport',
        u'OMA-LPPe-AGNSS-NavModelAccuracyModelDegradationSupport',
        u'OMA-LPPe-AGNSS-NavModelSupport',
        u'OMA-LPPe-AGNSS-HAgnssSupport',
        u'OMA-LPPe-AGNSS-HAgnssPerGNSSsupport',
        u'OMA-LPPe-AGNSS-RequestCapabilities',
        u'OMA-LPPe-AGNSS-Error',
        u'OMA-LPPe-AGNSS-LocationServerErrorCauses',
        u'OMA-LPPe-AGNSS-TargetDeviceErrorCauses',
        u'OMA-LPPe-AGNSS-CCPreferenceStationID',
        u'OMA-LPPe-AGNSS-AntennaDescription',
        u'OMA-LPPe-AGNSS-Abort',
        u'OMA-LPPe-OTDOA-ProvideAssistanceData',
        u'OMA-LPPe-OTDOA-ReferenceCellInfo',
        u'OMA-LPPe-OTDOA-PositionCalculationInfoRef',
        u'OMA-LPPe-OTDOA-NeighbourCellInfoList',
        u'OMA-LPPe-OTDOA-NeighbourFreqCellInfoList',
        u'OMA-LPPe-OTDOA-NeighbourCellInfoElement-eNB',
        u'OMA-LPPe-OTDOA-NeighbourCellInfoElement-HeNB',
        u'OMA-LPPe-OTDOA-CellData',
        u'OMA-LPPe-OTDOA-RTDquality',
        u'OMA-LPPe-OTDOA-RequestAssistanceData',
        u'OMA-LPPe-OTDOA-ProvideLocationInformation',
        u'OMA-LPPe-OTDOA-LocationInformation',
        u'OMA-LPPe-OTDOA-RequestLocationInformation',
        u'OMA-LPPe-OTDOA-ProvideCapabilities',
        u'OMA-LPPe-OTDOA-RequestCapabilities',
        u'OMA-LPPe-OTDOA-Error',
        u'OMA-LPPe-OTDOA-LocationServerErrorCauses',
        u'OMA-LPPe-OTDOA-TargetDeviceErrorCauses',
        u'OMA-LPPe-EOTD-ProvideAssistanceData',
        u'OMA-LPPe-EOTD-ReferenceBTSForAssistance',
        u'OMA-LPPe-EOTD-MsrAssistDataList',
        u'OMA-LPPe-EOTD-MsrAssistBTS',
        u'OMA-LPPe-EOTD-SystemInfoAssistDataList',
        u'OMA-LPPe-EOTD-SystemInfoAssistBTS',
        u'OMA-LPPe-EOTD-AssistBTSData',
        u'OMA-LPPe-EOTD-CalcAssistanceBTS',
        u'OMA-LPPe-EOTD-relativePos',
        u'OMA-LPPe-EOTD-FineRTD',
        u'OMA-LPPe-EOTD-RelDistance',
        u'OMA-LPPe-EOTD-RelativeAlt',
        u'OMA-LPPe-EOTD-RequestAssistanceData',
        u'OMA-LPPe-EOTD-ProvideLocationInformation',
        u'OMA-LPPe-EOTD-MsrElement',
        u'OMA-LPPe-EOTD-TOA-MeasurementsOfRef',
        u'OMA-LPPe-EOTD-MeasurementWithID',
        u'OMA-LPPe-EOTD-NeighborIdentity',
        u'OMA-LPPe-EOTD-EOTDQuality',
        u'OMA-LPPe-EOTD-OTDValue',
        u'OMA-LPPe-EOTD-CellID',
        u'OMA-LPPe-EOTD-RequestIndex',
        u'OMA-LPPe-EOTD-SystemInfoIndex',
        u'OMA-LPPe-EOTD-MultiFrameCarrier',
        u'OMA-LPPe-EOTD-BCCHCarrier',
        u'OMA-LPPe-EOTD-RequestLocationInformation',
        u'OMA-LPPe-EOTD-ProvideCapabilities',
        u'OMA-LPPe-EOTD-RequestCapabilities',
        u'OMA-LPPe-EOTD-Error',
        u'OMA-LPPe-EOTD-LocationServerErrorCauses',
        u'OMA-LPPe-EOTD-TargetDeviceErrorCauses',
        u'OMA-LPPe-EOTD-TimeSlotScheme',
        u'OMA-LPPe-EOTD-MultiFrameOffset',
        u'OMA-LPPe-EOTD-RoughRTD',
        u'OMA-LPPe-EOTD-ExpectedOTD',
        u'OMA-LPPe-EOTD-ModuloTimeSlot',
        u'OMA-LPPe-OTDOA-UTRA-ProvideAssistanceData',
        u'OMA-LPPe-OTDOA-UTRA-ReferenceCellInfo',
        u'OMA-LPPe-OTDOA-UTRA-RefPosAssist',
        u'OMA-LPPe-OTDOA-UTRA-NeighborCellList',
        u'OMA-LPPe-OTDOA-UTRA-NeighborCellInfo',
        u'OMA-LPPe-OTDOA-UTRA-SFN-SFN-RelTimeDifference1',
        u'OMA-LPPe-OTDOA-UTRA-PositioningAssistance',
        u'OMA-LPPe-OTDOA-UTRA-SFN-OffsetValidity',
        u'OMA-LPPe-OTDOA-UTRA-SFN-SFN-Drift',
        u'OMA-LPPe-OTDOA-UTRA-SearchWindowSize',
        u'OMA-LPPe-OTDOA-UTRA-fineSFN-SFN',
        u'OMA-LPPe-OTDOA-UTRA-IPDL-Parameters',
        u'OMA-LPPe-OTDOA-UTRA-IP-Spacing',
        u'OMA-LPPe-OTDOA-UTRA-IP-Length',
        u'OMA-LPPe-OTDOA-UTRA-IP-Spacing-TDD',
        u'OMA-LPPe-OTDOA-UTRA-IP-PCCPCH',
        u'OMA-LPPe-OTDOA-UTRA-BurstModeParameters',
        u'OMA-LPPe-OTDOA-UTRA-RequestAssistanceData',
        u'OMA-LPPe-OTDOA-UTRA-ProvideLocationInformation',
        u'OMA-LPPe-OTDOA-UTRA-Measurement',
        u'OMA-LPPe-OTDOA-UTRA-UE-RX-TX-TimeDifferenceType2Info',
        u'OMA-LPPe-OTDOA-UTRA-TimeDifferenceType2',
        u'OMA-LPPe-OTDOA-UTRA-NeighborList',
        u'OMA-LPPe-OTDOA-UTRA-Neighbor',
        u'OMA-LPPe-OTDOA-UTRA-NeighborQuality',
        u'OMA-LPPe-OTDOA-UTRA-SFN-SFN-ObsTimeDifference2',
        u'OMA-LPPe-OTDOA-UTRA-Quality',
        u'OMA-LPPe-OTDOA-UTRA-TimeStampData',
        u'OMA-LPPe-OTDOA-UTRA-RequestLocationInformation',
        u'OMA-LPPe-OTDOA-UTRA-ProvideCapabilities',
        u'OMA-LPPe-OTDOA-UTRA-RequestCapabilities',
        u'OMA-LPPe-OTDOA-UTRA-Error',
        u'OMA-LPPe-OTDOA-UTRA-LocationServerErrorCauses',
        u'OMA-LPPe-OTDOA-UTRA-TargetDeviceErrorCauses',
        u'OMA-LPPe-OTDOA-UTRA-PrimaryCPICH-Info',
        u'OMA-LPPe-OTDOA-UTRA-PrimaryScramblingCode',
        u'OMA-LPPe-OTDOA-UTRA-CellAndChannelIdentity',
        u'OMA-LPPe-OTDOA-UTRA-BurstType',
        u'OMA-LPPe-OTDOA-UTRA-MidambleShiftLong',
        u'OMA-LPPe-OTDOA-UTRA-TimeSlotNumber',
        u'OMA-LPPe-OTDOA-UTRA-CellParametersID',
        u'OMA-LPPe-ECID-LTE-ProvideAssistanceData',
        u'OMA-LPPe-ECID-LTE-NetworkData',
        u'OMA-LPPe-ECID-LTE-eNodeBData',
        u'OMA-LPPe-ECID-LTE-HeNBData',
        u'OMA-LPPe-ECID-LTE-CellData',
        u'OMA-LPPe-ECID-LTE-RequestAssistanceData',
        u'OMA-LPPe-ECID-LTE-ProvideLocationInformation',
        u'OMA-LPPe-ECID-LTE-LocationInformationList',
        u'OMA-LPPe-ECID-LTE-LocationInformation',
        u'OMA-LPPe-ECID-LTE-RequestLocationInformation',
        u'OMA-LPPe-ECID-LTE-ProvideCapabilities',
        u'OMA-LPPe-ECID-LTE-RequestCapabilities',
        u'OMA-LPPe-ECID-LTE-Error',
        u'OMA-LPPe-ECID-LTE-LocationServerErrorCauses',
        u'OMA-LPPe-ECID-LTE-TargetDeviceErrorCauses',
        u'OMA-LPPe-ECID-GSM-ProvideAssistanceData',
        u'OMA-LPPe-ECID-GSM-NetworkData',
        u'OMA-LPPe-ECID-GSM-BaseStationData',
        u'OMA-LPPe-ECID-GSM-CellData',
        u'OMA-LPPe-ECID-GSM-RequestAssistanceData',
        u'OMA-LPPe-ECID-GSM-ProvideLocationInformation',
        u'OMA-LPPe-ECID-GSM-LocationInformationList',
        u'OMA-LPPe-ECID-GSM-LocationInformation',
        u'OMA-LPPe-NMR-GERAN',
        u'OMA-LPPe-ECID-GSM-RequestLocationInformation',
        u'OMA-LPPe-ECID-GSM-ProvideCapabilities',
        u'OMA-LPPe-ECID-GSM-RequestCapabilities',
        u'OMA-LPPe-ECID-GSM-Error',
        u'OMA-LPPe-ECID-GSM-LocationServerErrorCauses',
        u'OMA-LPPe-ECID-GSM-TargetDeviceErrorCauses',
        u'OMA-LPPe-ECID-UTRA-ProvideAssistanceData',
        u'OMA-LPPe-ECID-UTRA-NetworkData',
        u'OMA-LPPe-ECID-UTRA-NodeBData',
        u'OMA-LPPe-ECID-UTRA-HNBData',
        u'OMA-LPPe-ECID-UTRA-CellData',
        u'OMA-LPPe-ECID-UTRA-RequestAssistanceData',
        u'OMA-LPPe-ECID-UTRA-ProvideLocationInformation',
        u'OMA-LPPe-ECID-UTRA-LocationInformationList',
        u'OMA-LPPe-ECID-UTRA-LocationInformation',
        u'OMA-LPPe-ECID-UTRA-UTRATimingAdvance',
        u'OMA-LPPe-ECID-UTRA-TAResolution',
        u'OMA-LPPe-ECID-UTRA-ChipRate',
        u'OMA-LPPe-UTRA-FrequencyInfo',
        u'OMA-LPPe-UTRA-ModeSpecificInfo',
        u'OMA-LPPe-UTRA-FrequencyInfoFDD',
        u'OMA-LPPe-UTRA-FrequencyInfoTDD',
        u'OMA-LPPe-ECID-UTRA-MeasuredResultsList',
        u'OMA-LPPe-ECID-UTRA-MeasuredResults',
        u'OMA-LPPe-ECID-UTRA-CellMeasuredResultsList',
        u'OMA-LPPe-ECID-UTRA-CarrierRSSI',
        u'OMA-LPPe-ECID-UTRA-CellMeasuredResults',
        u'OMA-LPPe-ECID-UTRA-PrimaryCCPCH-RSCP',
        u'OMA-LPPe-ECID-UTRA-CPICH-Ec-N0',
        u'OMA-LPPe-ECID-UTRA-CPICH-RSCP',
        u'OMA-LPPe-ECID-UTRA-Pathloss',
        u'OMA-LPPe-ECID-UTRA-RequestLocationInformation',
        u'OMA-LPPe-ECID-UTRA-ProvideCapabilities',
        u'OMA-LPPe-ECID-UTRA-RequestCapabilities',
        u'OMA-LPPe-ECID-UTRA-Error',
        u'OMA-LPPe-ECID-UTRA-LocationServerErrorCauses',
        u'OMA-LPPe-ECID-UTRA-TargetDeviceErrorCauses',
        u'OMA-LPPe-WLAN-AP-ProvideAssistanceData',
        u'OMA-LPPe-WLAN-DataSet',
        u'Supported-Channels-11a',
        u'Supported-Channels-11bg',
        u'OMA-LPPe-WLAN-AP-Data',
        u'OMA-LPPe-WLAN-AP-Type-Data',
        u'OMA-LPPe-WLAN-AP-RequestAssistanceData',
        u'OMA-LPPe-WLAN-AP-ProvideLocationInformation',
        u'OMA-LPPe-WLAN-AP-LocationInformationList',
        u'OMA-LPPe-WLAN-AP-LocationInformation',
        u'OMA-LPPe-WLAN-AP-PHY-Type',
        u'OMA-LPPe-WLAN-RTD',
        u'OMA-LPPe-WLAN-RTDUnits',
        u'OMA-LPPe-WLAN-ReportedLocation',
        u'OMA-LPPe-WLAN-LocationDataLCI',
        u'OMA-LPPe-WLAN-AP-RequestLocationInformation',
        u'OMA-LPPe-WLAN-AP-ProvideCapabilities',
        u'OMA-LPPe-WLAN-AP-Capability',
        u'OMA-LPPe-WLAN-AP-RequestCapabilities',
        u'OMA-LPPe-WLAN-AP-Error',
        u'OMA-LPPe-WLAN-AP-LocationServerErrorCauses',
        u'OMA-LPPe-WLAN-AP-TargetDeviceErrorCauses',
        u'OMA-LPPe-ECID-WiMax-ProvideLocationInformation',
        u'OMA-LPPe-ECID-WiMax-LocationInformationList',
        u'OMA-LPPe-ECID-WiMax-LocationInformation',
        u'OMA-LPPe-ECID-WiMax-WimaxBsID',
        u'OMA-LPPe-ECID-WiMax-WimaxRTD',
        u'OMA-LPPe-ECID-WiMax-WimaxNMRList',
        u'OMA-LPPe-ECID-WiMax-WimaxNMR',
        u'OMA-LPPe-ECID-WiMax-RequestLocationInformation',
        u'OMA-LPPe-ECID-WiMax-ProvideCapabilities',
        u'OMA-LPPe-ECID-WiMax-RequestCapabilities',
        u'OMA-LPPe-ECID-WiMax-Error',
        u'OMA-LPPe-ECID-WiMax-LocationServerErrorCauses',
        u'OMA-LPPe-ECID-WiMax-TargetDeviceErrorCauses',
        u'OMA-LPPe-Sensor-ProvideAssistanceData',
        u'OMA-LPPe-AtmosphericPressureAD',
        u'OMA-LPPe-PressureValidityArea',
        u'OMA-LPPe-Sensor-RequestAssistanceData',
        u'OMA-LPPe-PressureSensorAD',
        u'OMA-LPPe-Sensor-ProvideLocationInformation',
        u'OMA-LPPe-Sensor-MotionStateList',
        u'OMA-LPPe-Sensor-MotionStateElement',
        u'OMA-LPPe-Sensor-RequestLocationInformation',
        u'OMA-LPPe-Sensor-MotionStateRequest',
        u'OMA-LPPe-Sensor-ProvideCapabilities',
        u'OMA-LPPe-Sensor-RequestCapabilities',
        u'OMA-LPPe-Sensor-Error',
        u'OMA-LPPe-Sensor-TargetError',
        u'OMA-LPPe-SRN-ProvideAssistanceData',
        u'OMA-LPPe-SRN-SRNgroupList',
        u'OMA-LPPe-SRN-SRNgroup',
        u'OMA-LPPe-SRN-SRNinfo',
        u'OMA-LPPe-SRN-SRNgroupUpdateResponse',
        u'OMA-LPPe-SRN-SRNgroupUpdateResponseElement',
        u'OMA-LPPe-SRN-AntennaPattern',
        u'OMA-LPPe-SRN-AntennaPatternElement',
        u'OMA-LPPe-SRN-AntennaPatternForChannels',
        u'OMA-LPPe-SRN-ChannelResponse',
        u'OMA-LPPe-SRN-ResponseInElevation',
        u'OMA-LPPe-SRN-ResponseInAzimuth',
        u'OMA-LPPe-ComplexNumber',
        u'OMA-LPPe-SRN-RequestAssistanceData',
        u'OMA-LPPe-SRN-SRNgroupRequest',
        u'OMA-LPPe-SRN-SRNProvideList',
        u'OMA-LPPe-SRN-SRNgroupUpdateRequest',
        u'OMA-LPPe-SRN-SRNgroupUpdateRequestElement',
        u'OMA-LPPe-SRN-AntennaPatternRequest',
        u'OMA-LPPe-SRN-AntennaPatternRequestElement',
        u'OMA-LPPe-SRN-ProvideLocationInformation',
        u'OMA-LPPe-SRN-MeasurementElement',
        u'OMA-LPPe-SRN-srnMeasurementElement',
        u'OMA-LPPe-SRN-RequestLocationInformation',
        u'OMA-LPPe-SRN-ReqLocInfo-Category',
        u'OMA-LPPe-SRN-ProvideCapabilities',
        u'OMA-LPPe-SRN-ProvideCapabilitiesElement',
        u'OMA-LPPe-SRN-RequestCapabilities',
        u'OMA-LPPe-SRN-Error',
        u'OMA-LPPe-SRN-LocationServerErrorCauses',
        u'OMA-LPPe-SRN-TargetDeviceErrorCauses',
        u'OMA-LPPe-SRN-TargetDeviceError',
        u'OMA-LPPe-SRN-SRNgroupUniqueID',
        u'OMA-LPPe-SRN-SRNtype',
        u'OMA-LPPe-SRN-Category',
        u'OMA-LPPe-SRN-SRNid',
        u'OMA-LPPe-SRN-Technologies',
        u'OMA-LPPe-SRN-MeasurementMask',
        ]
    _set_ = [
        ]
    _val_ = [
        u'maxAssistanceContainerList',
        u'maxLocationInformationContainerDataList',
        u'maxLevel1-element',
        u'maxLevel2-element',
        u'maxLevel3-element',
        u'maxFinal-element',
        u'maxLPPLabelSets',
        u'maxLPPeLabelSets',
        u'maxVendorOrOperatorIDList',
        u'maxLocationInformationContainerList',
        u'maxCellSets',
        u'maxCells',
        u'maxIPAddress',
        u'maxRelativeLocation',
        u'maxReferenceStations',
        u'maxFreqLayers',
        u'utra-maxCellMeas',
        u'maxLTENetworks',
        u'maxLTEeNBs',
        u'maxLTEHeNBs',
        u'maxLTEMacroCells',
        u'maxLTEECIDSize',
        u'maxGSMNetworks',
        u'maxGSMBaseStations',
        u'maxGSMCells',
        u'maxGSMECIDSize',
        u'maxUTRANetworks',
        u'maxUTRAnodeBs',
        u'maxUTRAHNBs',
        u'maxUTRAMacroCells',
        u'maxECIDUTRASize',
        u'maxFreq',
        u'maxWLANDataSets',
        u'maxWLANAPs',
        u'maxWLANTypes',
        u'maxWLANAPSize',
        u'maxWiMaxECIDSize',
        u'maxWimaxBSMeas',
        u'maxChannels',
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< OMA-LPPe-MessageExtension >-----#
    OMA_LPPe_MessageExtension = SEQ(name=u'OMA-LPPe-MessageExtension', mode=MODE_TYPE)
    _OMA_LPPe_MessageExtension_lppeCompatibilityLevel = INT(name=u'lppeCompatibilityLevel', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-LPPeCompatibilityLevel')))
    _OMA_LPPe_MessageExtension_lppeVersion = SEQ(name=u'lppeVersion', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-LPPeVersion')))
    _OMA_LPPe_MessageExtension_lppeMode = ENUM(name=u'lppeMode', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-LPPeMode')))
    _OMA_LPPe_MessageExtension_messageExtensionBody = CHOICE(name=u'messageExtensionBody', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-MessageExtensionBody')))
    OMA_LPPe_MessageExtension._cont = ASN1Dict([
        (u'lppeCompatibilityLevel', _OMA_LPPe_MessageExtension_lppeCompatibilityLevel),
        (u'lppeVersion', _OMA_LPPe_MessageExtension_lppeVersion),
        (u'lppeMode', _OMA_LPPe_MessageExtension_lppeMode),
        (u'messageExtensionBody', _OMA_LPPe_MessageExtension_messageExtensionBody),
        ])
    OMA_LPPe_MessageExtension._ext = []
    
    #-----< OMA-LPPe-LPPeCompatibilityLevel >-----#
    OMA_LPPe_LPPeCompatibilityLevel = INT(name=u'OMA-LPPe-LPPeCompatibilityLevel', mode=MODE_TYPE)
    OMA_LPPe_LPPeCompatibilityLevel._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=15)], ev=None, er=[])
    
    #-----< OMA-LPPe-LPPeVersion >-----#
    OMA_LPPe_LPPeVersion = SEQ(name=u'OMA-LPPe-LPPeVersion', mode=MODE_TYPE)
    _OMA_LPPe_LPPeVersion_majorVersion = INT(name=u'majorVersion', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_LPPeVersion_majorVersion._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _OMA_LPPe_LPPeVersion_minorVersion = INT(name=u'minorVersion', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_LPPeVersion_minorVersion._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    OMA_LPPe_LPPeVersion._cont = ASN1Dict([
        (u'majorVersion', _OMA_LPPe_LPPeVersion_majorVersion),
        (u'minorVersion', _OMA_LPPe_LPPeVersion_minorVersion),
        ])
    OMA_LPPe_LPPeVersion._ext = None
    
    #-----< OMA-LPPe-LPPeMode >-----#
    OMA_LPPe_LPPeMode = ENUM(name=u'OMA-LPPe-LPPeMode', mode=MODE_TYPE)
    OMA_LPPe_LPPeMode._cont = ASN1Dict([(u'normal', 0), (u'reversed', 1)])
    OMA_LPPe_LPPeMode._ext = []
    
    #-----< OMA-LPPe-MessageExtensionBody >-----#
    OMA_LPPe_MessageExtensionBody = CHOICE(name=u'OMA-LPPe-MessageExtensionBody', mode=MODE_TYPE)
    _OMA_LPPe_MessageExtensionBody_requestCapabilities = SEQ(name=u'requestCapabilities', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-RequestCapabilities')))
    _OMA_LPPe_MessageExtensionBody_provideCapabilities = SEQ(name=u'provideCapabilities', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ProvideCapabilities')))
    _OMA_LPPe_MessageExtensionBody_requestAssistanceData = SEQ(name=u'requestAssistanceData', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-RequestAssistanceData')))
    _OMA_LPPe_MessageExtensionBody_provideAssistanceData = SEQ(name=u'provideAssistanceData', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ProvideAssistanceData')))
    _OMA_LPPe_MessageExtensionBody_requestLocationInformation = SEQ(name=u'requestLocationInformation', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-RequestLocationInformation')))
    _OMA_LPPe_MessageExtensionBody_provideLocationInformation = SEQ(name=u'provideLocationInformation', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ProvideLocationInformation')))
    _OMA_LPPe_MessageExtensionBody_error = SEQ(name=u'error', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-Error')))
    _OMA_LPPe_MessageExtensionBody_abort = SEQ(name=u'abort', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-Abort')))
    OMA_LPPe_MessageExtensionBody._cont = ASN1Dict([
        (u'requestCapabilities', _OMA_LPPe_MessageExtensionBody_requestCapabilities),
        (u'provideCapabilities', _OMA_LPPe_MessageExtensionBody_provideCapabilities),
        (u'requestAssistanceData', _OMA_LPPe_MessageExtensionBody_requestAssistanceData),
        (u'provideAssistanceData', _OMA_LPPe_MessageExtensionBody_provideAssistanceData),
        (u'requestLocationInformation', _OMA_LPPe_MessageExtensionBody_requestLocationInformation),
        (u'provideLocationInformation', _OMA_LPPe_MessageExtensionBody_provideLocationInformation),
        (u'error', _OMA_LPPe_MessageExtensionBody_error),
        (u'abort', _OMA_LPPe_MessageExtensionBody_abort),
        ])
    OMA_LPPe_MessageExtensionBody._ext = []
    
    #-----< OMA-LPPe-ver1-1-BroadcastContainer >-----#
    OMA_LPPe_ver1_1_BroadcastContainer = SEQ(name=u'OMA-LPPe-ver1-1-BroadcastContainer', mode=MODE_TYPE)
    _OMA_LPPe_ver1_1_BroadcastContainer_digitalSignature = SEQ(name=u'digitalSignature', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-DigitalSignature')), opt=True)
    _OMA_LPPe_ver1_1_BroadcastContainer_messageContents = OCT_STR(name=u'messageContents', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    OMA_LPPe_ver1_1_BroadcastContainer._cont = ASN1Dict([
        (u'digitalSignature', _OMA_LPPe_ver1_1_BroadcastContainer_digitalSignature),
        (u'messageContents', _OMA_LPPe_ver1_1_BroadcastContainer_messageContents),
        ])
    OMA_LPPe_ver1_1_BroadcastContainer._ext = []
    
    #-----< OMA-LPPe-ver1-1-BroadcastMessage >-----#
    OMA_LPPe_ver1_1_BroadcastMessage = SEQ(name=u'OMA-LPPe-ver1-1-BroadcastMessage', mode=MODE_TYPE)
    _OMA_LPPe_ver1_1_BroadcastMessage_broadcastControlIEs = SEQ(name=u'broadcastControlIEs', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-BroadcastControlIEs')))
    _OMA_LPPe_ver1_1_BroadcastMessage_cipheringIEs = SEQ(name=u'cipheringIEs', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-CipheringIEs')), opt=True)
    _OMA_LPPe_ver1_1_BroadcastMessage_broadcastMessage = OCT_STR(name=u'broadcastMessage', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    OMA_LPPe_ver1_1_BroadcastMessage._cont = ASN1Dict([
        (u'broadcastControlIEs', _OMA_LPPe_ver1_1_BroadcastMessage_broadcastControlIEs),
        (u'cipheringIEs', _OMA_LPPe_ver1_1_BroadcastMessage_cipheringIEs),
        (u'broadcastMessage', _OMA_LPPe_ver1_1_BroadcastMessage_broadcastMessage),
        ])
    OMA_LPPe_ver1_1_BroadcastMessage._ext = []
    
    #-----< OMA-LPPe-ver1-1-BroadcastControlIEs >-----#
    OMA_LPPe_ver1_1_BroadcastControlIEs = SEQ(name=u'OMA-LPPe-ver1-1-BroadcastControlIEs', mode=MODE_TYPE)
    _OMA_LPPe_ver1_1_BroadcastControlIEs_serverID = SEQ(name=u'serverID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-ServerID')))
    _OMA_LPPe_ver1_1_BroadcastControlIEs_messageID = OCT_STR(name=u'messageID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_ver1_1_BroadcastControlIEs_messageID._const_sz = ASN1Set(rv=[4], rr=[], ev=None, er=[])
    _OMA_LPPe_ver1_1_BroadcastControlIEs_validity_time = SEQ(name=u'validity-time', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ValidityPeriod')), opt=True)
    _OMA_LPPe_ver1_1_BroadcastControlIEs_validity_area = SEQ(name=u'validity-area', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ValidityArea')), opt=True)
    _OMA_LPPe_ver1_1_BroadcastControlIEs_broadcastADTypes = SEQ(name=u'broadcastADTypes', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-BroadcastADTypes')), opt=True)
    OMA_LPPe_ver1_1_BroadcastControlIEs._cont = ASN1Dict([
        (u'serverID', _OMA_LPPe_ver1_1_BroadcastControlIEs_serverID),
        (u'messageID', _OMA_LPPe_ver1_1_BroadcastControlIEs_messageID),
        (u'validity-time', _OMA_LPPe_ver1_1_BroadcastControlIEs_validity_time),
        (u'validity-area', _OMA_LPPe_ver1_1_BroadcastControlIEs_validity_area),
        (u'broadcastADTypes', _OMA_LPPe_ver1_1_BroadcastControlIEs_broadcastADTypes),
        ])
    OMA_LPPe_ver1_1_BroadcastControlIEs._ext = []
    
    #-----< OMA-LPPe-ver1-1-CipheringIEs >-----#
    OMA_LPPe_ver1_1_CipheringIEs = SEQ(name=u'OMA-LPPe-ver1-1-CipheringIEs', mode=MODE_TYPE)
    _OMA_LPPe_ver1_1_CipheringIEs_cipherSetID = INT(name=u'cipherSetID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-CipherSetID')))
    _OMA_LPPe_ver1_1_CipheringIEs_d0 = BIT_STR(name=u'd0', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_ver1_1_CipheringIEs_d0._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    OMA_LPPe_ver1_1_CipheringIEs._cont = ASN1Dict([
        (u'cipherSetID', _OMA_LPPe_ver1_1_CipheringIEs_cipherSetID),
        (u'd0', _OMA_LPPe_ver1_1_CipheringIEs_d0),
        ])
    OMA_LPPe_ver1_1_CipheringIEs._ext = []
    
    #-----< OMA-LPPe-ver1-1-DigitalSignature >-----#
    OMA_LPPe_ver1_1_DigitalSignature = SEQ(name=u'OMA-LPPe-ver1-1-DigitalSignature', mode=MODE_TYPE)
    _OMA_LPPe_ver1_1_DigitalSignature_authenticationSetID = INT(name=u'authenticationSetID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-AuthenticationSetID')))
    _OMA_LPPe_ver1_1_DigitalSignature_signature = BIT_STR(name=u'signature', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_ver1_1_DigitalSignature_signature._const_sz = ASN1Set(rv=[2048], rr=[], ev=None, er=[])
    OMA_LPPe_ver1_1_DigitalSignature._cont = ASN1Dict([
        (u'authenticationSetID', _OMA_LPPe_ver1_1_DigitalSignature_authenticationSetID),
        (u'signature', _OMA_LPPe_ver1_1_DigitalSignature_signature),
        ])
    OMA_LPPe_ver1_1_DigitalSignature._ext = []
    
    #-----< OMA-LPPe-RequestCapabilities >-----#
    OMA_LPPe_RequestCapabilities = SEQ(name=u'OMA-LPPe-RequestCapabilities', mode=MODE_TYPE)
    _OMA_LPPe_RequestCapabilities_commonIEsRequestCapabilities = SEQ(name=u'commonIEsRequestCapabilities', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-CommonIEsRequestCapabilities')), opt=True)
    _OMA_LPPe_RequestCapabilities_agnss_RequestCapabilities = SEQ(name=u'agnss-RequestCapabilities', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-RequestCapabilities')), opt=True)
    _OMA_LPPe_RequestCapabilities_otdoa_RequestCapabilities = SEQ(name=u'otdoa-RequestCapabilities', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-RequestCapabilities')), opt=True)
    _OMA_LPPe_RequestCapabilities_eotd_RequestCapabilities = SEQ(name=u'eotd-RequestCapabilities', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-EOTD-RequestCapabilities')), opt=True)
    _OMA_LPPe_RequestCapabilities_otdoa_utra_RequestCapabilities = SEQ(name=u'otdoa-utra-RequestCapabilities', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-UTRA-RequestCapabilities')), opt=True)
    _OMA_LPPe_RequestCapabilities_ecid_lte_RequestCapabilities = SEQ(name=u'ecid-lte-RequestCapabilities', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ECID-LTE-RequestCapabilities')), opt=True)
    _OMA_LPPe_RequestCapabilities_ecid_gsm_RequestCapabilities = SEQ(name=u'ecid-gsm-RequestCapabilities', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ECID-GSM-RequestCapabilities')), opt=True)
    _OMA_LPPe_RequestCapabilities_ecid_utra_RequestCapabilities = SEQ(name=u'ecid-utra-RequestCapabilities', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ECID-UTRA-RequestCapabilities')), opt=True)
    _OMA_LPPe_RequestCapabilities_wlan_ap_RequestCapabilities = SEQ(name=u'wlan-ap-RequestCapabilities', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-WLAN-AP-RequestCapabilities')), opt=True)
    _OMA_LPPe_RequestCapabilities_ecid_wimax_RequestCapabilities = SEQ(name=u'ecid-wimax-RequestCapabilities', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ECID-WiMax-RequestCapabilities')), opt=True)
    _OMA_LPPe_RequestCapabilities_sensor_RequestCapabilities = SEQ(name=u'sensor-RequestCapabilities', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-Sensor-RequestCapabilities')), opt=True)
    _OMA_LPPe_RequestCapabilities_srn_RequestCapabilities = SEQ(name=u'srn-RequestCapabilities', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-SRN-RequestCapabilities')), opt=True)
    OMA_LPPe_RequestCapabilities._cont = ASN1Dict([
        (u'commonIEsRequestCapabilities', _OMA_LPPe_RequestCapabilities_commonIEsRequestCapabilities),
        (u'agnss-RequestCapabilities', _OMA_LPPe_RequestCapabilities_agnss_RequestCapabilities),
        (u'otdoa-RequestCapabilities', _OMA_LPPe_RequestCapabilities_otdoa_RequestCapabilities),
        (u'eotd-RequestCapabilities', _OMA_LPPe_RequestCapabilities_eotd_RequestCapabilities),
        (u'otdoa-utra-RequestCapabilities', _OMA_LPPe_RequestCapabilities_otdoa_utra_RequestCapabilities),
        (u'ecid-lte-RequestCapabilities', _OMA_LPPe_RequestCapabilities_ecid_lte_RequestCapabilities),
        (u'ecid-gsm-RequestCapabilities', _OMA_LPPe_RequestCapabilities_ecid_gsm_RequestCapabilities),
        (u'ecid-utra-RequestCapabilities', _OMA_LPPe_RequestCapabilities_ecid_utra_RequestCapabilities),
        (u'wlan-ap-RequestCapabilities', _OMA_LPPe_RequestCapabilities_wlan_ap_RequestCapabilities),
        (u'ecid-wimax-RequestCapabilities', _OMA_LPPe_RequestCapabilities_ecid_wimax_RequestCapabilities),
        (u'sensor-RequestCapabilities', _OMA_LPPe_RequestCapabilities_sensor_RequestCapabilities),
        (u'srn-RequestCapabilities', _OMA_LPPe_RequestCapabilities_srn_RequestCapabilities),
        ])
    OMA_LPPe_RequestCapabilities._ext = []
    
    #-----< OMA-LPPe-ProvideCapabilities >-----#
    OMA_LPPe_ProvideCapabilities = SEQ(name=u'OMA-LPPe-ProvideCapabilities', mode=MODE_TYPE)
    _OMA_LPPe_ProvideCapabilities_commonIEsProvideCapabilities = SEQ(name=u'commonIEsProvideCapabilities', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-CommonIEsProvideCapabilities')), opt=True)
    _OMA_LPPe_ProvideCapabilities_agnss_ProvideCapabilities = SEQ(name=u'agnss-ProvideCapabilities', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-ProvideCapabilities')), opt=True)
    _OMA_LPPe_ProvideCapabilities_otdoa_ProvideCapabilities = SEQ(name=u'otdoa-ProvideCapabilities', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-ProvideCapabilities')), opt=True)
    _OMA_LPPe_ProvideCapabilities_eotd_ProvideCapabilities = SEQ(name=u'eotd-ProvideCapabilities', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-EOTD-ProvideCapabilities')), opt=True)
    _OMA_LPPe_ProvideCapabilities_otdoa_utra_ProvideCapabilities = SEQ(name=u'otdoa-utra-ProvideCapabilities', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-UTRA-ProvideCapabilities')), opt=True)
    _OMA_LPPe_ProvideCapabilities_ecid_lte_ProvideCapabilities = SEQ(name=u'ecid-lte-ProvideCapabilities', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ECID-LTE-ProvideCapabilities')), opt=True)
    _OMA_LPPe_ProvideCapabilities_ecid_gsm_ProvideCapabilities = SEQ(name=u'ecid-gsm-ProvideCapabilities', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ECID-GSM-ProvideCapabilities')), opt=True)
    _OMA_LPPe_ProvideCapabilities_ecid_utra_ProvideCapabilities = SEQ(name=u'ecid-utra-ProvideCapabilities', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ECID-UTRA-ProvideCapabilities')), opt=True)
    _OMA_LPPe_ProvideCapabilities_wlan_ap_ProvideCapabilities = SEQ(name=u'wlan-ap-ProvideCapabilities', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-WLAN-AP-ProvideCapabilities')), opt=True)
    _OMA_LPPe_ProvideCapabilities_ecid_wimax_ProvideCapabilities = SEQ(name=u'ecid-wimax-ProvideCapabilities', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ECID-WiMax-ProvideCapabilities')), opt=True)
    _OMA_LPPe_ProvideCapabilities_sensor_ProvideCapabilities = SEQ(name=u'sensor-ProvideCapabilities', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-Sensor-ProvideCapabilities')), opt=True)
    _OMA_LPPe_ProvideCapabilities_srn_ProvideCapabilities = SEQ(name=u'srn-ProvideCapabilities', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-SRN-ProvideCapabilities')), opt=True)
    OMA_LPPe_ProvideCapabilities._cont = ASN1Dict([
        (u'commonIEsProvideCapabilities', _OMA_LPPe_ProvideCapabilities_commonIEsProvideCapabilities),
        (u'agnss-ProvideCapabilities', _OMA_LPPe_ProvideCapabilities_agnss_ProvideCapabilities),
        (u'otdoa-ProvideCapabilities', _OMA_LPPe_ProvideCapabilities_otdoa_ProvideCapabilities),
        (u'eotd-ProvideCapabilities', _OMA_LPPe_ProvideCapabilities_eotd_ProvideCapabilities),
        (u'otdoa-utra-ProvideCapabilities', _OMA_LPPe_ProvideCapabilities_otdoa_utra_ProvideCapabilities),
        (u'ecid-lte-ProvideCapabilities', _OMA_LPPe_ProvideCapabilities_ecid_lte_ProvideCapabilities),
        (u'ecid-gsm-ProvideCapabilities', _OMA_LPPe_ProvideCapabilities_ecid_gsm_ProvideCapabilities),
        (u'ecid-utra-ProvideCapabilities', _OMA_LPPe_ProvideCapabilities_ecid_utra_ProvideCapabilities),
        (u'wlan-ap-ProvideCapabilities', _OMA_LPPe_ProvideCapabilities_wlan_ap_ProvideCapabilities),
        (u'ecid-wimax-ProvideCapabilities', _OMA_LPPe_ProvideCapabilities_ecid_wimax_ProvideCapabilities),
        (u'sensor-ProvideCapabilities', _OMA_LPPe_ProvideCapabilities_sensor_ProvideCapabilities),
        (u'srn-ProvideCapabilities', _OMA_LPPe_ProvideCapabilities_srn_ProvideCapabilities),
        ])
    OMA_LPPe_ProvideCapabilities._ext = []
    
    #-----< OMA-LPPe-RequestAssistanceData >-----#
    OMA_LPPe_RequestAssistanceData = SEQ(name=u'OMA-LPPe-RequestAssistanceData', mode=MODE_TYPE)
    _OMA_LPPe_RequestAssistanceData_commonIEsRequestAssistanceData = SEQ(name=u'commonIEsRequestAssistanceData', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-CommonIEsRequestAssistanceData')), opt=True)
    _OMA_LPPe_RequestAssistanceData_agnss_RequestAssistanceData = SEQ(name=u'agnss-RequestAssistanceData', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-RequestAssistanceData')), opt=True)
    _OMA_LPPe_RequestAssistanceData_otdoa_RequestAssistanceData = SEQ(name=u'otdoa-RequestAssistanceData', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-RequestAssistanceData')), opt=True)
    _OMA_LPPe_RequestAssistanceData_eotd_RequestAssistanceData = SEQ(name=u'eotd-RequestAssistanceData', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-EOTD-RequestAssistanceData')), opt=True)
    _OMA_LPPe_RequestAssistanceData_otdoa_utra_RequestAssistanceData = SEQ(name=u'otdoa-utra-RequestAssistanceData', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-UTRA-RequestAssistanceData')), opt=True)
    _OMA_LPPe_RequestAssistanceData_ecid_lte_RequestAssistanceData = SEQ(name=u'ecid-lte-RequestAssistanceData', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ECID-LTE-RequestAssistanceData')), opt=True)
    _OMA_LPPe_RequestAssistanceData_ecid_gsm_RequestAssistanceData = SEQ(name=u'ecid-gsm-RequestAssistanceData', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ECID-GSM-RequestAssistanceData')), opt=True)
    _OMA_LPPe_RequestAssistanceData_ecid_utra_RequestAssistanceData = SEQ(name=u'ecid-utra-RequestAssistanceData', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ECID-UTRA-RequestAssistanceData')), opt=True)
    _OMA_LPPe_RequestAssistanceData_wlan_ap_RequestAssistanceData = SEQ(name=u'wlan-ap-RequestAssistanceData', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-WLAN-AP-RequestAssistanceData')), opt=True)
    _OMA_LPPe_RequestAssistanceData_sensor_RequestAssistanceData = SEQ(name=u'sensor-RequestAssistanceData', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-Sensor-RequestAssistanceData')), opt=True)
    _OMA_LPPe_RequestAssistanceData_srn_RequestAssistanceData = SEQ(name=u'srn-RequestAssistanceData', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-SRN-RequestAssistanceData')), opt=True)
    OMA_LPPe_RequestAssistanceData._cont = ASN1Dict([
        (u'commonIEsRequestAssistanceData', _OMA_LPPe_RequestAssistanceData_commonIEsRequestAssistanceData),
        (u'agnss-RequestAssistanceData', _OMA_LPPe_RequestAssistanceData_agnss_RequestAssistanceData),
        (u'otdoa-RequestAssistanceData', _OMA_LPPe_RequestAssistanceData_otdoa_RequestAssistanceData),
        (u'eotd-RequestAssistanceData', _OMA_LPPe_RequestAssistanceData_eotd_RequestAssistanceData),
        (u'otdoa-utra-RequestAssistanceData', _OMA_LPPe_RequestAssistanceData_otdoa_utra_RequestAssistanceData),
        (u'ecid-lte-RequestAssistanceData', _OMA_LPPe_RequestAssistanceData_ecid_lte_RequestAssistanceData),
        (u'ecid-gsm-RequestAssistanceData', _OMA_LPPe_RequestAssistanceData_ecid_gsm_RequestAssistanceData),
        (u'ecid-utra-RequestAssistanceData', _OMA_LPPe_RequestAssistanceData_ecid_utra_RequestAssistanceData),
        (u'wlan-ap-RequestAssistanceData', _OMA_LPPe_RequestAssistanceData_wlan_ap_RequestAssistanceData),
        (u'sensor-RequestAssistanceData', _OMA_LPPe_RequestAssistanceData_sensor_RequestAssistanceData),
        (u'srn-RequestAssistanceData', _OMA_LPPe_RequestAssistanceData_srn_RequestAssistanceData),
        ])
    OMA_LPPe_RequestAssistanceData._ext = []
    
    #-----< OMA-LPPe-ProvideAssistanceData >-----#
    OMA_LPPe_ProvideAssistanceData = SEQ(name=u'OMA-LPPe-ProvideAssistanceData', mode=MODE_TYPE)
    _OMA_LPPe_ProvideAssistanceData_commonIEsProvideAssistanceData = SEQ(name=u'commonIEsProvideAssistanceData', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-CommonIEsProvideAssistanceData')), opt=True)
    _OMA_LPPe_ProvideAssistanceData_agnss_ProvideAssistanceData = SEQ(name=u'agnss-ProvideAssistanceData', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-ProvideAssistanceData')), opt=True)
    _OMA_LPPe_ProvideAssistanceData_otdoa_ProvideAssistanceData = SEQ(name=u'otdoa-ProvideAssistanceData', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-ProvideAssistanceData')), opt=True)
    _OMA_LPPe_ProvideAssistanceData_eotd_ProvideAssistanceData = SEQ(name=u'eotd-ProvideAssistanceData', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-EOTD-ProvideAssistanceData')), opt=True)
    _OMA_LPPe_ProvideAssistanceData_otdoa_utra_ProvideAssistanceData = SEQ(name=u'otdoa-utra-ProvideAssistanceData', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-UTRA-ProvideAssistanceData')), opt=True)
    _OMA_LPPe_ProvideAssistanceData_ecid_lte_ProvideAssistanceData = SEQ(name=u'ecid-lte-ProvideAssistanceData', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ECID-LTE-ProvideAssistanceData')), opt=True)
    _OMA_LPPe_ProvideAssistanceData_ecid_gsm_ProvideAssistanceData = SEQ(name=u'ecid-gsm-ProvideAssistanceData', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ECID-GSM-ProvideAssistanceData')), opt=True)
    _OMA_LPPe_ProvideAssistanceData_ecid_utra_ProvideAssistanceData = SEQ(name=u'ecid-utra-ProvideAssistanceData', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ECID-UTRA-ProvideAssistanceData')), opt=True)
    _OMA_LPPe_ProvideAssistanceData_wlan_ap_ProvideAssistanceData = SEQ(name=u'wlan-ap-ProvideAssistanceData', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-WLAN-AP-ProvideAssistanceData')), opt=True)
    _OMA_LPPe_ProvideAssistanceData_sensor_ProvideAssistanceData = SEQ(name=u'sensor-ProvideAssistanceData', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-Sensor-ProvideAssistanceData')), opt=True)
    _OMA_LPPe_ProvideAssistanceData_srn_ProvideAssistanceData = SEQ(name=u'srn-ProvideAssistanceData', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-SRN-ProvideAssistanceData')), opt=True)
    OMA_LPPe_ProvideAssistanceData._cont = ASN1Dict([
        (u'commonIEsProvideAssistanceData', _OMA_LPPe_ProvideAssistanceData_commonIEsProvideAssistanceData),
        (u'agnss-ProvideAssistanceData', _OMA_LPPe_ProvideAssistanceData_agnss_ProvideAssistanceData),
        (u'otdoa-ProvideAssistanceData', _OMA_LPPe_ProvideAssistanceData_otdoa_ProvideAssistanceData),
        (u'eotd-ProvideAssistanceData', _OMA_LPPe_ProvideAssistanceData_eotd_ProvideAssistanceData),
        (u'otdoa-utra-ProvideAssistanceData', _OMA_LPPe_ProvideAssistanceData_otdoa_utra_ProvideAssistanceData),
        (u'ecid-lte-ProvideAssistanceData', _OMA_LPPe_ProvideAssistanceData_ecid_lte_ProvideAssistanceData),
        (u'ecid-gsm-ProvideAssistanceData', _OMA_LPPe_ProvideAssistanceData_ecid_gsm_ProvideAssistanceData),
        (u'ecid-utra-ProvideAssistanceData', _OMA_LPPe_ProvideAssistanceData_ecid_utra_ProvideAssistanceData),
        (u'wlan-ap-ProvideAssistanceData', _OMA_LPPe_ProvideAssistanceData_wlan_ap_ProvideAssistanceData),
        (u'sensor-ProvideAssistanceData', _OMA_LPPe_ProvideAssistanceData_sensor_ProvideAssistanceData),
        (u'srn-ProvideAssistanceData', _OMA_LPPe_ProvideAssistanceData_srn_ProvideAssistanceData),
        ])
    OMA_LPPe_ProvideAssistanceData._ext = []
    
    #-----< OMA-LPPe-RequestLocationInformation >-----#
    OMA_LPPe_RequestLocationInformation = SEQ(name=u'OMA-LPPe-RequestLocationInformation', mode=MODE_TYPE)
    _OMA_LPPe_RequestLocationInformation_commonIEsRequestLocationInformation = SEQ(name=u'commonIEsRequestLocationInformation', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-CommonIEsRequestLocationInformation')), opt=True)
    _OMA_LPPe_RequestLocationInformation_agnss_RequestLocationInformation = SEQ(name=u'agnss-RequestLocationInformation', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-RequestLocationInformation')), opt=True)
    _OMA_LPPe_RequestLocationInformation_otdoa_RequestLocationInformation = SEQ(name=u'otdoa-RequestLocationInformation', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-RequestLocationInformation')), opt=True)
    _OMA_LPPe_RequestLocationInformation_eotd_RequestLocationInformation = SEQ(name=u'eotd-RequestLocationInformation', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-EOTD-RequestLocationInformation')), opt=True)
    _OMA_LPPe_RequestLocationInformation_otdoa_utra_RequestLocationInformation = SEQ(name=u'otdoa-utra-RequestLocationInformation', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-UTRA-RequestLocationInformation')), opt=True)
    _OMA_LPPe_RequestLocationInformation_ecid_lte_RequestLocationInformation = SEQ(name=u'ecid-lte-RequestLocationInformation', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ECID-LTE-RequestLocationInformation')), opt=True)
    _OMA_LPPe_RequestLocationInformation_ecid_gsm_RequestLocationInformation = SEQ(name=u'ecid-gsm-RequestLocationInformation', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ECID-GSM-RequestLocationInformation')), opt=True)
    _OMA_LPPe_RequestLocationInformation_ecid_utra_RequestLocationInformation = SEQ(name=u'ecid-utra-RequestLocationInformation', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ECID-UTRA-RequestLocationInformation')), opt=True)
    _OMA_LPPe_RequestLocationInformation_wlan_ap_RequestLocationInformation = SEQ(name=u'wlan-ap-RequestLocationInformation', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-WLAN-AP-RequestLocationInformation')), opt=True)
    _OMA_LPPe_RequestLocationInformation_ecid_wimax_RequestLocationInformation = SEQ(name=u'ecid-wimax-RequestLocationInformation', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ECID-WiMax-RequestLocationInformation')), opt=True)
    _OMA_LPPe_RequestLocationInformation_sensor_RequestLocationInformation = SEQ(name=u'sensor-RequestLocationInformation', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-Sensor-RequestLocationInformation')), opt=True)
    _OMA_LPPe_RequestLocationInformation_srn_RequestLocationInformation = SEQ(name=u'srn-RequestLocationInformation', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-SRN-RequestLocationInformation')), opt=True)
    OMA_LPPe_RequestLocationInformation._cont = ASN1Dict([
        (u'commonIEsRequestLocationInformation', _OMA_LPPe_RequestLocationInformation_commonIEsRequestLocationInformation),
        (u'agnss-RequestLocationInformation', _OMA_LPPe_RequestLocationInformation_agnss_RequestLocationInformation),
        (u'otdoa-RequestLocationInformation', _OMA_LPPe_RequestLocationInformation_otdoa_RequestLocationInformation),
        (u'eotd-RequestLocationInformation', _OMA_LPPe_RequestLocationInformation_eotd_RequestLocationInformation),
        (u'otdoa-utra-RequestLocationInformation', _OMA_LPPe_RequestLocationInformation_otdoa_utra_RequestLocationInformation),
        (u'ecid-lte-RequestLocationInformation', _OMA_LPPe_RequestLocationInformation_ecid_lte_RequestLocationInformation),
        (u'ecid-gsm-RequestLocationInformation', _OMA_LPPe_RequestLocationInformation_ecid_gsm_RequestLocationInformation),
        (u'ecid-utra-RequestLocationInformation', _OMA_LPPe_RequestLocationInformation_ecid_utra_RequestLocationInformation),
        (u'wlan-ap-RequestLocationInformation', _OMA_LPPe_RequestLocationInformation_wlan_ap_RequestLocationInformation),
        (u'ecid-wimax-RequestLocationInformation', _OMA_LPPe_RequestLocationInformation_ecid_wimax_RequestLocationInformation),
        (u'sensor-RequestLocationInformation', _OMA_LPPe_RequestLocationInformation_sensor_RequestLocationInformation),
        (u'srn-RequestLocationInformation', _OMA_LPPe_RequestLocationInformation_srn_RequestLocationInformation),
        ])
    OMA_LPPe_RequestLocationInformation._ext = []
    
    #-----< OMA-LPPe-ProvideLocationInformation >-----#
    OMA_LPPe_ProvideLocationInformation = SEQ(name=u'OMA-LPPe-ProvideLocationInformation', mode=MODE_TYPE)
    _OMA_LPPe_ProvideLocationInformation_commonIEsProvideLocationInformation = SEQ(name=u'commonIEsProvideLocationInformation', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-CommonIEsProvideLocationInformation')), opt=True)
    _OMA_LPPe_ProvideLocationInformation_agnss_ProvideLocationInformation = SEQ(name=u'agnss-ProvideLocationInformation', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-ProvideLocationInformation')), opt=True)
    _OMA_LPPe_ProvideLocationInformation_otdoa_ProvideLocationInformation = SEQ(name=u'otdoa-ProvideLocationInformation', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-ProvideLocationInformation')), opt=True)
    _OMA_LPPe_ProvideLocationInformation_eotd_ProvideLocationInformation = SEQ(name=u'eotd-ProvideLocationInformation', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-EOTD-ProvideLocationInformation')), opt=True)
    _OMA_LPPe_ProvideLocationInformation_otdoa_utra_ProvideLocationInformation = SEQ(name=u'otdoa-utra-ProvideLocationInformation', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-UTRA-ProvideLocationInformation')), opt=True)
    _OMA_LPPe_ProvideLocationInformation_ecid_lte_ProvideLocationInformation = SEQ(name=u'ecid-lte-ProvideLocationInformation', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ECID-LTE-ProvideLocationInformation')), opt=True)
    _OMA_LPPe_ProvideLocationInformation_ecid_gsm_ProvideLocationInformation = SEQ(name=u'ecid-gsm-ProvideLocationInformation', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ECID-GSM-ProvideLocationInformation')), opt=True)
    _OMA_LPPe_ProvideLocationInformation_ecid_utra_ProvideLocationInformation = SEQ(name=u'ecid-utra-ProvideLocationInformation', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ECID-UTRA-ProvideLocationInformation')), opt=True)
    _OMA_LPPe_ProvideLocationInformation_wlan_ap_ProvideLocationInformastion = SEQ(name=u'wlan-ap-ProvideLocationInformastion', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-WLAN-AP-ProvideLocationInformation')), opt=True)
    _OMA_LPPe_ProvideLocationInformation_ecid_wimax_ProvideLocationInformastion = SEQ(name=u'ecid-wimax-ProvideLocationInformastion', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ECID-WiMax-ProvideLocationInformation')), opt=True)
    _OMA_LPPe_ProvideLocationInformation_sensor_ProvideLocationInformation = SEQ(name=u'sensor-ProvideLocationInformation', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-Sensor-ProvideLocationInformation')), opt=True)
    _OMA_LPPe_ProvideLocationInformation_srn_ProvideLocationInformation = SEQ(name=u'srn-ProvideLocationInformation', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-SRN-ProvideLocationInformation')), opt=True)
    OMA_LPPe_ProvideLocationInformation._cont = ASN1Dict([
        (u'commonIEsProvideLocationInformation', _OMA_LPPe_ProvideLocationInformation_commonIEsProvideLocationInformation),
        (u'agnss-ProvideLocationInformation', _OMA_LPPe_ProvideLocationInformation_agnss_ProvideLocationInformation),
        (u'otdoa-ProvideLocationInformation', _OMA_LPPe_ProvideLocationInformation_otdoa_ProvideLocationInformation),
        (u'eotd-ProvideLocationInformation', _OMA_LPPe_ProvideLocationInformation_eotd_ProvideLocationInformation),
        (u'otdoa-utra-ProvideLocationInformation', _OMA_LPPe_ProvideLocationInformation_otdoa_utra_ProvideLocationInformation),
        (u'ecid-lte-ProvideLocationInformation', _OMA_LPPe_ProvideLocationInformation_ecid_lte_ProvideLocationInformation),
        (u'ecid-gsm-ProvideLocationInformation', _OMA_LPPe_ProvideLocationInformation_ecid_gsm_ProvideLocationInformation),
        (u'ecid-utra-ProvideLocationInformation', _OMA_LPPe_ProvideLocationInformation_ecid_utra_ProvideLocationInformation),
        (u'wlan-ap-ProvideLocationInformastion', _OMA_LPPe_ProvideLocationInformation_wlan_ap_ProvideLocationInformastion),
        (u'ecid-wimax-ProvideLocationInformastion', _OMA_LPPe_ProvideLocationInformation_ecid_wimax_ProvideLocationInformastion),
        (u'sensor-ProvideLocationInformation', _OMA_LPPe_ProvideLocationInformation_sensor_ProvideLocationInformation),
        (u'srn-ProvideLocationInformation', _OMA_LPPe_ProvideLocationInformation_srn_ProvideLocationInformation),
        ])
    OMA_LPPe_ProvideLocationInformation._ext = []
    
    #-----< OMA-LPPe-Abort >-----#
    OMA_LPPe_Abort = SEQ(name=u'OMA-LPPe-Abort', mode=MODE_TYPE)
    _OMA_LPPe_Abort_commonIEsAbort = SEQ(name=u'commonIEsAbort', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-CommonIEsAbort')), opt=True)
    _OMA_LPPe_Abort_agnssAbort = SEQ(name=u'agnssAbort', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-Abort')), opt=True)
    OMA_LPPe_Abort._cont = ASN1Dict([
        (u'commonIEsAbort', _OMA_LPPe_Abort_commonIEsAbort),
        (u'agnssAbort', _OMA_LPPe_Abort_agnssAbort),
        ])
    OMA_LPPe_Abort._ext = []
    
    #-----< OMA-LPPe-Error >-----#
    OMA_LPPe_Error = SEQ(name=u'OMA-LPPe-Error', mode=MODE_TYPE)
    _OMA_LPPe_Error_commonIEsError = SEQ(name=u'commonIEsError', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-CommonIEsError')), opt=True)
    OMA_LPPe_Error._cont = ASN1Dict([
        (u'commonIEsError', _OMA_LPPe_Error_commonIEsError),
        ])
    OMA_LPPe_Error._ext = []
    
    #-----< OMA-LPPe-AssistanceContainer-DataSerialNumber >-----#
    OMA_LPPe_AssistanceContainer_DataSerialNumber = SEQ(name=u'OMA-LPPe-AssistanceContainer-DataSerialNumber', mode=MODE_TYPE)
    _OMA_LPPe_AssistanceContainer_DataSerialNumber_dataSerialNumber = INT(name=u'dataSerialNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AssistanceContainer_DataSerialNumber_dataSerialNumber._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4294967295)], ev=None, er=[])
    OMA_LPPe_AssistanceContainer_DataSerialNumber._cont = ASN1Dict([
        (u'dataSerialNumber', _OMA_LPPe_AssistanceContainer_DataSerialNumber_dataSerialNumber),
        ])
    OMA_LPPe_AssistanceContainer_DataSerialNumber._ext = []
    
    #-----< OMA-LPPe-AssistanceContainerID >-----#
    OMA_LPPe_AssistanceContainerID = SEQ(name=u'OMA-LPPe-AssistanceContainerID', mode=MODE_TYPE)
    _OMA_LPPe_AssistanceContainerID_containerID = INT(name=u'containerID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AssistanceContainerID_containerID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    OMA_LPPe_AssistanceContainerID._cont = ASN1Dict([
        (u'containerID', _OMA_LPPe_AssistanceContainerID_containerID),
        ])
    OMA_LPPe_AssistanceContainerID._ext = []
    
    #-----< OMA-LPPe-AssistanceContainerProvideList >-----#
    OMA_LPPe_AssistanceContainerProvideList = SEQ_OF(name=u'OMA-LPPe-AssistanceContainerProvideList', mode=MODE_TYPE)
    _OMA_LPPe_AssistanceContainerProvideList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AssistanceContainerProvide')))
    OMA_LPPe_AssistanceContainerProvideList._cont = _OMA_LPPe_AssistanceContainerProvideList__item_
    OMA_LPPe_AssistanceContainerProvideList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    
    #-----< maxAssistanceContainerList >-----#
    maxAssistanceContainerList = INT(name=u'maxAssistanceContainerList', mode=MODE_VALUE)
    maxAssistanceContainerList._val = 16
    
    #-----< OMA-LPPe-AssistanceContainerProvide >-----#
    OMA_LPPe_AssistanceContainerProvide = SEQ(name=u'OMA-LPPe-AssistanceContainerProvide', mode=MODE_TYPE)
    _OMA_LPPe_AssistanceContainerProvide_dataIdentifier = SEQ(name=u'dataIdentifier', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-VendorOrOperatorAssistanceDataIdentifier')))
    _OMA_LPPe_AssistanceContainerProvide_checkOrUpdateOrError = ENUM(name=u'checkOrUpdateOrError', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AssistanceContainerProvide_checkOrUpdateOrError._cont = ASN1Dict([(u'targetHasLatestData', 0), (u'targetDataNotLatest', 1), (u'targetDataNotLatestButServerCannotProvideLatestData', 2), (u'targetHasValidData', 3), (u'targetDataInvalidButServerCannotProvideValidData', 4), (u'serverHasRequestedDataButUnableToProvideTemporarily', 5), (u'serverDoesNotHaveRequestedData', 6), (u'serverDoesNotRecognizeRequestedData', 7), (u'undefined', 8)])
    _OMA_LPPe_AssistanceContainerProvide_checkOrUpdateOrError._ext = []
    _OMA_LPPe_AssistanceContainerProvide_dataResult = CHOICE(name=u'dataResult', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __OMA_LPPe_AssistanceContainerProvide_dataResult_simulationResult = INT(name=u'simulationResult', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_AssistanceContainerProvide_dataResult_simulationResult._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=5000)], ev=None, er=[])
    __OMA_LPPe_AssistanceContainerProvide_dataResult_data = SEQ(name=u'data', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AssistanceContainerData')))
    _OMA_LPPe_AssistanceContainerProvide_dataResult._cont = ASN1Dict([
        (u'simulationResult', __OMA_LPPe_AssistanceContainerProvide_dataResult_simulationResult),
        (u'data', __OMA_LPPe_AssistanceContainerProvide_dataResult_data),
        ])
    _OMA_LPPe_AssistanceContainerProvide_dataResult._ext = []
    _OMA_LPPe_AssistanceContainerProvide_errorCode = SEQ(name=u'errorCode', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AssistanceContainerProvideError')), opt=True)
    OMA_LPPe_AssistanceContainerProvide._cont = ASN1Dict([
        (u'dataIdentifier', _OMA_LPPe_AssistanceContainerProvide_dataIdentifier),
        (u'checkOrUpdateOrError', _OMA_LPPe_AssistanceContainerProvide_checkOrUpdateOrError),
        (u'dataResult', _OMA_LPPe_AssistanceContainerProvide_dataResult),
        (u'errorCode', _OMA_LPPe_AssistanceContainerProvide_errorCode),
        ])
    OMA_LPPe_AssistanceContainerProvide._ext = []
    
    #-----< OMA-LPPe-AssistanceContainerData >-----#
    OMA_LPPe_AssistanceContainerData = SEQ(name=u'OMA-LPPe-AssistanceContainerData', mode=MODE_TYPE)
    _OMA_LPPe_AssistanceContainerData_dataSerialNumber = SEQ(name=u'dataSerialNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AssistanceContainer-DataSerialNumber')), opt=True)
    _OMA_LPPe_AssistanceContainerData_data = OCT_STR(name=u'data', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AssistanceContainerData_validityPeriod = SEQ(name=u'validityPeriod', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ValidityPeriod')), opt=True)
    _OMA_LPPe_AssistanceContainerData_validityArea = SEQ(name=u'validityArea', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ValidityArea')), opt=True)
    OMA_LPPe_AssistanceContainerData._cont = ASN1Dict([
        (u'dataSerialNumber', _OMA_LPPe_AssistanceContainerData_dataSerialNumber),
        (u'data', _OMA_LPPe_AssistanceContainerData_data),
        (u'validityPeriod', _OMA_LPPe_AssistanceContainerData_validityPeriod),
        (u'validityArea', _OMA_LPPe_AssistanceContainerData_validityArea),
        ])
    OMA_LPPe_AssistanceContainerData._ext = []
    
    #-----< OMA-LPPe-AssistanceContainerProvideError >-----#
    OMA_LPPe_AssistanceContainerProvideError = SEQ(name=u'OMA-LPPe-AssistanceContainerProvideError', mode=MODE_TYPE)
    _OMA_LPPe_AssistanceContainerProvideError_serverError = ENUM(name=u'serverError', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AssistanceContainerProvideError_serverError._cont = ASN1Dict([(u'assistanceContainerUnknownDataIdentifier', 0), (u'assistanceContainerUnknownDataSerialNumber', 1), (u'assistanceContainerDataTemporarilyUnavailable', 2), (u'assistanceContainerDataNoLongerSupported', 3), (u'assistanceContainerVendorOrOperatorNotSupported', 4)])
    _OMA_LPPe_AssistanceContainerProvideError_serverError._ext = []
    OMA_LPPe_AssistanceContainerProvideError._cont = ASN1Dict([
        (u'serverError', _OMA_LPPe_AssistanceContainerProvideError_serverError),
        ])
    OMA_LPPe_AssistanceContainerProvideError._ext = []
    
    #-----< OMA-LPPe-AssistanceContainerRequestList >-----#
    OMA_LPPe_AssistanceContainerRequestList = SEQ_OF(name=u'OMA-LPPe-AssistanceContainerRequestList', mode=MODE_TYPE)
    _OMA_LPPe_AssistanceContainerRequestList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AssistanceContainerRequest')))
    OMA_LPPe_AssistanceContainerRequestList._cont = _OMA_LPPe_AssistanceContainerRequestList__item_
    OMA_LPPe_AssistanceContainerRequestList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    
    #-----< OMA-LPPe-AssistanceContainerRequest >-----#
    OMA_LPPe_AssistanceContainerRequest = SEQ(name=u'OMA-LPPe-AssistanceContainerRequest', mode=MODE_TYPE)
    _OMA_LPPe_AssistanceContainerRequest_dataIdentifier = SEQ(name=u'dataIdentifier', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-VendorOrOperatorAssistanceDataIdentifier')))
    _OMA_LPPe_AssistanceContainerRequest_simulatedReq = BOOL(name=u'simulatedReq', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AssistanceContainerRequest_checkOrUpdateReq = SEQ(name=u'checkOrUpdateReq', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AssistanceContainerCheckOrUpdateReq')), opt=True)
    _OMA_LPPe_AssistanceContainerRequest_validityTimeRequest = SEQ(name=u'validityTimeRequest', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ValidityPeriod')), opt=True)
    _OMA_LPPe_AssistanceContainerRequest_proprietaryRequestParameters = OCT_STR(name=u'proprietaryRequestParameters', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    OMA_LPPe_AssistanceContainerRequest._cont = ASN1Dict([
        (u'dataIdentifier', _OMA_LPPe_AssistanceContainerRequest_dataIdentifier),
        (u'simulatedReq', _OMA_LPPe_AssistanceContainerRequest_simulatedReq),
        (u'checkOrUpdateReq', _OMA_LPPe_AssistanceContainerRequest_checkOrUpdateReq),
        (u'validityTimeRequest', _OMA_LPPe_AssistanceContainerRequest_validityTimeRequest),
        (u'proprietaryRequestParameters', _OMA_LPPe_AssistanceContainerRequest_proprietaryRequestParameters),
        ])
    OMA_LPPe_AssistanceContainerRequest._ext = []
    
    #-----< OMA-LPPe-AssistanceContainerCheckOrUpdateReq >-----#
    OMA_LPPe_AssistanceContainerCheckOrUpdateReq = SEQ(name=u'OMA-LPPe-AssistanceContainerCheckOrUpdateReq', mode=MODE_TYPE)
    _OMA_LPPe_AssistanceContainerCheckOrUpdateReq_dataSerialNumber = SEQ(name=u'dataSerialNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AssistanceContainer-DataSerialNumber')))
    _OMA_LPPe_AssistanceContainerCheckOrUpdateReq_checkLatest = ENUM(name=u'checkLatest', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AssistanceContainerCheckOrUpdateReq_checkLatest._cont = ASN1Dict([(u'returnLatestIfCurrentNotLatest', 0), (u'returnUpdateOnlyIfCurrentInvalid', 1)])
    _OMA_LPPe_AssistanceContainerCheckOrUpdateReq_checkLatest._ext = []
    OMA_LPPe_AssistanceContainerCheckOrUpdateReq._cont = ASN1Dict([
        (u'dataSerialNumber', _OMA_LPPe_AssistanceContainerCheckOrUpdateReq_dataSerialNumber),
        (u'checkLatest', _OMA_LPPe_AssistanceContainerCheckOrUpdateReq_checkLatest),
        ])
    OMA_LPPe_AssistanceContainerCheckOrUpdateReq._ext = []
    
    #-----< OMA-LPPe-CellLocalIdGERAN >-----#
    OMA_LPPe_CellLocalIdGERAN = SEQ(name=u'OMA-LPPe-CellLocalIdGERAN', mode=MODE_TYPE)
    _OMA_LPPe_CellLocalIdGERAN_locationAreaCode = BIT_STR(name=u'locationAreaCode', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_CellLocalIdGERAN_locationAreaCode._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _OMA_LPPe_CellLocalIdGERAN_cellIdentity = BIT_STR(name=u'cellIdentity', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_CellLocalIdGERAN_cellIdentity._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    OMA_LPPe_CellLocalIdGERAN._cont = ASN1Dict([
        (u'locationAreaCode', _OMA_LPPe_CellLocalIdGERAN_locationAreaCode),
        (u'cellIdentity', _OMA_LPPe_CellLocalIdGERAN_cellIdentity),
        ])
    OMA_LPPe_CellLocalIdGERAN._ext = []
    
    #-----< OMA-LPPe-CellNonUniqueIDGERAN >-----#
    OMA_LPPe_CellNonUniqueIDGERAN = SEQ(name=u'OMA-LPPe-CellNonUniqueIDGERAN', mode=MODE_TYPE)
    _OMA_LPPe_CellNonUniqueIDGERAN_bsic = INT(name=u'bsic', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_CellNonUniqueIDGERAN_bsic._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    _OMA_LPPe_CellNonUniqueIDGERAN_bcch = INT(name=u'bcch', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_CellNonUniqueIDGERAN_bcch._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=1023)], ev=None, er=[])
    OMA_LPPe_CellNonUniqueIDGERAN._cont = ASN1Dict([
        (u'bsic', _OMA_LPPe_CellNonUniqueIDGERAN_bsic),
        (u'bcch', _OMA_LPPe_CellNonUniqueIDGERAN_bcch),
        ])
    OMA_LPPe_CellNonUniqueIDGERAN._ext = []
    
    #-----< OMA-LPPe-CharArray >-----#
    OMA_LPPe_CharArray = STR_VIS(name=u'OMA-LPPe-CharArray', mode=MODE_TYPE)
    OMA_LPPe_CharArray._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=31)], ev=None, er=[])
    OMA_LPPe_CharArray._const_alpha = ASN1Set(rv=[u'.', u'-'], rr=[ASN1RangeStr(lb=u'a', ub=u'z'), ASN1RangeStr(lb=u'A', ub=u'Z'), ASN1RangeStr(lb=u'0', ub=u'9')], ev=None, er=[])
    
    #-----< OMA-LPPe-CivicLocation >-----#
    OMA_LPPe_CivicLocation = SEQ(name=u'OMA-LPPe-CivicLocation', mode=MODE_TYPE)
    _OMA_LPPe_CivicLocation_countryCode = OCT_STR(name=u'countryCode', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_CivicLocation_countryCode._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    _OMA_LPPe_CivicLocation_civicAddressElementList = SEQ_OF(name=u'civicAddressElementList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-CivicAddressElementList')))
    OMA_LPPe_CivicLocation._cont = ASN1Dict([
        (u'countryCode', _OMA_LPPe_CivicLocation_countryCode),
        (u'civicAddressElementList', _OMA_LPPe_CivicLocation_civicAddressElementList),
        ])
    OMA_LPPe_CivicLocation._ext = []
    
    #-----< OMA-LPPe-CivicAddressElementList >-----#
    OMA_LPPe_CivicAddressElementList = SEQ_OF(name=u'OMA-LPPe-CivicAddressElementList', mode=MODE_TYPE)
    _OMA_LPPe_CivicAddressElementList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-CivicAddressElement')))
    OMA_LPPe_CivicAddressElementList._cont = _OMA_LPPe_CivicAddressElementList__item_
    OMA_LPPe_CivicAddressElementList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    
    #-----< OMA-LPPe-CivicAddressElement >-----#
    OMA_LPPe_CivicAddressElement = SEQ(name=u'OMA-LPPe-CivicAddressElement', mode=MODE_TYPE)
    _OMA_LPPe_CivicAddressElement_caType = INT(name=u'caType', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_CivicAddressElement_caType._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=511)], ev=None, er=[])
    _OMA_LPPe_CivicAddressElement_caValue = OCT_STR(name=u'caValue', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_CivicAddressElement_caValue._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    OMA_LPPe_CivicAddressElement._cont = ASN1Dict([
        (u'caType', _OMA_LPPe_CivicAddressElement_caType),
        (u'caValue', _OMA_LPPe_CivicAddressElement_caValue),
        ])
    OMA_LPPe_CivicAddressElement._ext = []
    
    #-----< OMA-LPPe-Duration >-----#
    OMA_LPPe_Duration = SEQ(name=u'OMA-LPPe-Duration', mode=MODE_TYPE)
    _OMA_LPPe_Duration_duration = INT(name=u'duration', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_Duration_duration._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=63)], ev=None, er=[])
    _OMA_LPPe_Duration_durationLSB = INT(name=u'durationLSB', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_Duration_durationLSB._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=89)], ev=None, er=[])
    OMA_LPPe_Duration._cont = ASN1Dict([
        (u'duration', _OMA_LPPe_Duration_duration),
        (u'durationLSB', _OMA_LPPe_Duration_durationLSB),
        ])
    OMA_LPPe_Duration._ext = []
    
    #-----< OMA-LPPe-FixedAccessTypes >-----#
    OMA_LPPe_FixedAccessTypes = BIT_STR(name=u'OMA-LPPe-FixedAccessTypes', mode=MODE_TYPE)
    OMA_LPPe_FixedAccessTypes._cont = ASN1Dict([(u'cable', 0), (u'dsl', 1), (u'lan', 2), (u'pstn', 3), (u'other', 4)])
    OMA_LPPe_FixedAccessTypes._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    
    #-----< OMA-LPPe-ver1-1-GroundMorphologyModel >-----#
    OMA_LPPe_ver1_1_GroundMorphologyModel = SEQ(name=u'OMA-LPPe-ver1-1-GroundMorphologyModel', mode=MODE_TYPE)
    _OMA_LPPe_ver1_1_GroundMorphologyModel_altitudeModel = SEQ(name=u'altitudeModel', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-AltitudeModel')), opt=True)
    _OMA_LPPe_ver1_1_GroundMorphologyModel_buildingsProfileModel = SEQ(name=u'buildingsProfileModel', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-BuildingsHeightModel')), opt=True)
    OMA_LPPe_ver1_1_GroundMorphologyModel._cont = ASN1Dict([
        (u'altitudeModel', _OMA_LPPe_ver1_1_GroundMorphologyModel_altitudeModel),
        (u'buildingsProfileModel', _OMA_LPPe_ver1_1_GroundMorphologyModel_buildingsProfileModel),
        ])
    OMA_LPPe_ver1_1_GroundMorphologyModel._ext = []
    
    #-----< OMA-LPPe-ver1-1-AltitudeModel >-----#
    OMA_LPPe_ver1_1_AltitudeModel = SEQ(name=u'OMA-LPPe-ver1-1-AltitudeModel', mode=MODE_TYPE)
    _OMA_LPPe_ver1_1_AltitudeModel_northWestCorner = SEQ(name=u'northWestCorner', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'Ellipsoid-Point')))
    _OMA_LPPe_ver1_1_AltitudeModel_northwestCornerAltitude = INT(name=u'northwestCornerAltitude', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_ver1_1_AltitudeModel_northwestCornerAltitude._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-500, ub=9000)], ev=None, er=[])
    _OMA_LPPe_ver1_1_AltitudeModel_nrows = INT(name=u'nrows', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_ver1_1_AltitudeModel_nrows._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=2, ub=1012)], ev=None, er=[])
    _OMA_LPPe_ver1_1_AltitudeModel_ncols = INT(name=u'ncols', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_ver1_1_AltitudeModel_ncols._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=2, ub=1012)], ev=None, er=[])
    _OMA_LPPe_ver1_1_AltitudeModel_spanX = INT(name=u'spanX', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_ver1_1_AltitudeModel_spanX._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=6, ub=14)], ev=None, er=[])
    _OMA_LPPe_ver1_1_AltitudeModel_spanY = INT(name=u'spanY', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_ver1_1_AltitudeModel_spanY._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=6, ub=14)], ev=None, er=[])
    _OMA_LPPe_ver1_1_AltitudeModel_deltaAltUnits = INT(name=u'deltaAltUnits', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_ver1_1_AltitudeModel_deltaAltUnits._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _OMA_LPPe_ver1_1_AltitudeModel_altitudeGrid = SEQ_OF(name=u'altitudeGrid', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_ver1_1_AltitudeModel_altitudeGrid__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'DeltaAltitudes')))
    _OMA_LPPe_ver1_1_AltitudeModel_altitudeGrid._cont = __OMA_LPPe_ver1_1_AltitudeModel_altitudeGrid__item_
    _OMA_LPPe_ver1_1_AltitudeModel_altitudeGrid._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=10000)], ev=None, er=[])
    OMA_LPPe_ver1_1_AltitudeModel._cont = ASN1Dict([
        (u'northWestCorner', _OMA_LPPe_ver1_1_AltitudeModel_northWestCorner),
        (u'northwestCornerAltitude', _OMA_LPPe_ver1_1_AltitudeModel_northwestCornerAltitude),
        (u'nrows', _OMA_LPPe_ver1_1_AltitudeModel_nrows),
        (u'ncols', _OMA_LPPe_ver1_1_AltitudeModel_ncols),
        (u'spanX', _OMA_LPPe_ver1_1_AltitudeModel_spanX),
        (u'spanY', _OMA_LPPe_ver1_1_AltitudeModel_spanY),
        (u'deltaAltUnits', _OMA_LPPe_ver1_1_AltitudeModel_deltaAltUnits),
        (u'altitudeGrid', _OMA_LPPe_ver1_1_AltitudeModel_altitudeGrid),
        ])
    OMA_LPPe_ver1_1_AltitudeModel._ext = []
    
    #-----< OMA-LPPe-ver1-1-BuildingsHeightModel >-----#
    OMA_LPPe_ver1_1_BuildingsHeightModel = SEQ(name=u'OMA-LPPe-ver1-1-BuildingsHeightModel', mode=MODE_TYPE)
    _OMA_LPPe_ver1_1_BuildingsHeightModel_northWestCorner = SEQ(name=u'northWestCorner', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'Ellipsoid-Point')))
    _OMA_LPPe_ver1_1_BuildingsHeightModel_northwestCornerHeigth = INT(name=u'northwestCornerHeigth', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_ver1_1_BuildingsHeightModel_northwestCornerHeigth._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=500)], ev=None, er=[])
    _OMA_LPPe_ver1_1_BuildingsHeightModel_nrows = INT(name=u'nrows', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_ver1_1_BuildingsHeightModel_nrows._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=2, ub=1012)], ev=None, er=[])
    _OMA_LPPe_ver1_1_BuildingsHeightModel_ncols = INT(name=u'ncols', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_ver1_1_BuildingsHeightModel_ncols._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=2, ub=1012)], ev=None, er=[])
    _OMA_LPPe_ver1_1_BuildingsHeightModel_spanX = INT(name=u'spanX', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_ver1_1_BuildingsHeightModel_spanX._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=6, ub=14)], ev=None, er=[])
    _OMA_LPPe_ver1_1_BuildingsHeightModel_spanY = INT(name=u'spanY', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_ver1_1_BuildingsHeightModel_spanY._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=6, ub=14)], ev=None, er=[])
    _OMA_LPPe_ver1_1_BuildingsHeightModel_deltaHeigthUnits = INT(name=u'deltaHeigthUnits', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_ver1_1_BuildingsHeightModel_deltaHeigthUnits._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    _OMA_LPPe_ver1_1_BuildingsHeightModel_buildingsHeigthGrid = SEQ_OF(name=u'buildingsHeigthGrid', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_ver1_1_BuildingsHeightModel_buildingsHeigthGrid__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'DeltaHeight')))
    _OMA_LPPe_ver1_1_BuildingsHeightModel_buildingsHeigthGrid._cont = __OMA_LPPe_ver1_1_BuildingsHeightModel_buildingsHeigthGrid__item_
    _OMA_LPPe_ver1_1_BuildingsHeightModel_buildingsHeigthGrid._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=10000)], ev=None, er=[])
    OMA_LPPe_ver1_1_BuildingsHeightModel._cont = ASN1Dict([
        (u'northWestCorner', _OMA_LPPe_ver1_1_BuildingsHeightModel_northWestCorner),
        (u'northwestCornerHeigth', _OMA_LPPe_ver1_1_BuildingsHeightModel_northwestCornerHeigth),
        (u'nrows', _OMA_LPPe_ver1_1_BuildingsHeightModel_nrows),
        (u'ncols', _OMA_LPPe_ver1_1_BuildingsHeightModel_ncols),
        (u'spanX', _OMA_LPPe_ver1_1_BuildingsHeightModel_spanX),
        (u'spanY', _OMA_LPPe_ver1_1_BuildingsHeightModel_spanY),
        (u'deltaHeigthUnits', _OMA_LPPe_ver1_1_BuildingsHeightModel_deltaHeigthUnits),
        (u'buildingsHeigthGrid', _OMA_LPPe_ver1_1_BuildingsHeightModel_buildingsHeigthGrid),
        ])
    OMA_LPPe_ver1_1_BuildingsHeightModel._ext = []
    
    #-----< DeltaAltitudes >-----#
    DeltaAltitudes = SEQ(name=u'DeltaAltitudes', mode=MODE_TYPE)
    _DeltaAltitudes_deltaAlt = INT(name=u'deltaAlt', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _DeltaAltitudes_deltaAlt._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-15, ub=16)], ev=None, er=[])
    _DeltaAltitudes_numGridPoints = INT(name=u'numGridPoints', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _DeltaAltitudes_numGridPoints._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    DeltaAltitudes._cont = ASN1Dict([
        (u'deltaAlt', _DeltaAltitudes_deltaAlt),
        (u'numGridPoints', _DeltaAltitudes_numGridPoints),
        ])
    DeltaAltitudes._ext = []
    
    #-----< DeltaHeight >-----#
    DeltaHeight = SEQ(name=u'DeltaHeight', mode=MODE_TYPE)
    _DeltaHeight_deltaHeight = INT(name=u'deltaHeight', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _DeltaHeight_deltaHeight._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-15, ub=16)], ev=None, er=[])
    _DeltaHeight_numGridPoints = INT(name=u'numGridPoints', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _DeltaHeight_numGridPoints._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    DeltaHeight._cont = ASN1Dict([
        (u'deltaHeight', _DeltaHeight_deltaHeight),
        (u'numGridPoints', _DeltaHeight_numGridPoints),
        ])
    DeltaHeight._ext = []
    
    #-----< OMA-LPPe-ver1-1-CellGlobalID >-----#
    OMA_LPPe_ver1_1_CellGlobalID = CHOICE(name=u'OMA-LPPe-ver1-1-CellGlobalID', mode=MODE_TYPE)
    _OMA_LPPe_ver1_1_CellGlobalID_eUTRA = SEQ(name=u'eUTRA', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'CellGlobalIdEUTRA-AndUTRA')))
    _OMA_LPPe_ver1_1_CellGlobalID_uTRA = SEQ(name=u'uTRA', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'CellGlobalIdEUTRA-AndUTRA')))
    _OMA_LPPe_ver1_1_CellGlobalID_gSM = SEQ(name=u'gSM', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'CellGlobalIdGERAN')))
    OMA_LPPe_ver1_1_CellGlobalID._cont = ASN1Dict([
        (u'eUTRA', _OMA_LPPe_ver1_1_CellGlobalID_eUTRA),
        (u'uTRA', _OMA_LPPe_ver1_1_CellGlobalID_uTRA),
        (u'gSM', _OMA_LPPe_ver1_1_CellGlobalID_gSM),
        ])
    OMA_LPPe_ver1_1_CellGlobalID._ext = []
    
    #-----< OMA-LPPe-HighAccuracy3Dposition >-----#
    OMA_LPPe_HighAccuracy3Dposition = SEQ(name=u'OMA-LPPe-HighAccuracy3Dposition', mode=MODE_TYPE)
    _OMA_LPPe_HighAccuracy3Dposition_latitude = INT(name=u'latitude', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_HighAccuracy3Dposition_latitude._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-2147483648, ub=2147483647)], ev=None, er=[])
    _OMA_LPPe_HighAccuracy3Dposition_longitude = INT(name=u'longitude', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_HighAccuracy3Dposition_longitude._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-2147483648, ub=2147483647)], ev=None, er=[])
    _OMA_LPPe_HighAccuracy3Dposition_cep = INT(name=u'cep', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_HighAccuracy3Dposition_cep._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _OMA_LPPe_HighAccuracy3Dposition_uncertainty_semimajor = INT(name=u'uncertainty-semimajor', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_HighAccuracy3Dposition_uncertainty_semimajor._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _OMA_LPPe_HighAccuracy3Dposition_uncertainty_semiminor = INT(name=u'uncertainty-semiminor', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_HighAccuracy3Dposition_uncertainty_semiminor._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _OMA_LPPe_HighAccuracy3Dposition_offset_angle = INT(name=u'offset-angle', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_HighAccuracy3Dposition_offset_angle._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=179)], ev=None, er=[])
    _OMA_LPPe_HighAccuracy3Dposition_confidenceHorizontal = INT(name=u'confidenceHorizontal', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_HighAccuracy3Dposition_confidenceHorizontal._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=99)], ev=None, er=[])
    _OMA_LPPe_HighAccuracy3Dposition_altitude = INT(name=u'altitude', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_HighAccuracy3Dposition_altitude._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-64000, ub=1280000)], ev=None, er=[])
    _OMA_LPPe_HighAccuracy3Dposition_uncertainty_altitude = INT(name=u'uncertainty-altitude', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_HighAccuracy3Dposition_uncertainty_altitude._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _OMA_LPPe_HighAccuracy3Dposition_confidenceVertical = INT(name=u'confidenceVertical', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_HighAccuracy3Dposition_confidenceVertical._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=99)], ev=None, er=[])
    OMA_LPPe_HighAccuracy3Dposition._cont = ASN1Dict([
        (u'latitude', _OMA_LPPe_HighAccuracy3Dposition_latitude),
        (u'longitude', _OMA_LPPe_HighAccuracy3Dposition_longitude),
        (u'cep', _OMA_LPPe_HighAccuracy3Dposition_cep),
        (u'uncertainty-semimajor', _OMA_LPPe_HighAccuracy3Dposition_uncertainty_semimajor),
        (u'uncertainty-semiminor', _OMA_LPPe_HighAccuracy3Dposition_uncertainty_semiminor),
        (u'offset-angle', _OMA_LPPe_HighAccuracy3Dposition_offset_angle),
        (u'confidenceHorizontal', _OMA_LPPe_HighAccuracy3Dposition_confidenceHorizontal),
        (u'altitude', _OMA_LPPe_HighAccuracy3Dposition_altitude),
        (u'uncertainty-altitude', _OMA_LPPe_HighAccuracy3Dposition_uncertainty_altitude),
        (u'confidenceVertical', _OMA_LPPe_HighAccuracy3Dposition_confidenceVertical),
        ])
    OMA_LPPe_HighAccuracy3Dposition._ext = []
    
    #-----< OMA-LPPe-HighAccuracy3Dvelocity >-----#
    OMA_LPPe_HighAccuracy3Dvelocity = SEQ(name=u'OMA-LPPe-HighAccuracy3Dvelocity', mode=MODE_TYPE)
    _OMA_LPPe_HighAccuracy3Dvelocity_enu_origin = SEQ(name=u'enu-origin', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-HighAccuracy3Dposition')), opt=True)
    _OMA_LPPe_HighAccuracy3Dvelocity_east_component = INT(name=u'east-component', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_HighAccuracy3Dvelocity_east_component._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=511)], ev=None, er=[])
    _OMA_LPPe_HighAccuracy3Dvelocity_negative_sign_east = NULL(name=u'negative-sign-east', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_HighAccuracy3Dvelocity_north_component = INT(name=u'north-component', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_HighAccuracy3Dvelocity_north_component._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=511)], ev=None, er=[])
    _OMA_LPPe_HighAccuracy3Dvelocity_negative_sign_north = NULL(name=u'negative-sign-north', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_HighAccuracy3Dvelocity_up_component = INT(name=u'up-component', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_HighAccuracy3Dvelocity_up_component._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=511)], ev=None, er=[])
    _OMA_LPPe_HighAccuracy3Dvelocity_negative_sign_up = NULL(name=u'negative-sign-up', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_HighAccuracy3Dvelocity_cep = INT(name=u'cep', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_HighAccuracy3Dvelocity_cep._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _OMA_LPPe_HighAccuracy3Dvelocity_uncertainty_semimajor = INT(name=u'uncertainty-semimajor', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_HighAccuracy3Dvelocity_uncertainty_semimajor._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _OMA_LPPe_HighAccuracy3Dvelocity_uncertainty_semiminor = INT(name=u'uncertainty-semiminor', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_HighAccuracy3Dvelocity_uncertainty_semiminor._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _OMA_LPPe_HighAccuracy3Dvelocity_offset_angle = INT(name=u'offset-angle', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_HighAccuracy3Dvelocity_offset_angle._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=179)], ev=None, er=[])
    _OMA_LPPe_HighAccuracy3Dvelocity_confidenceHorizontal = INT(name=u'confidenceHorizontal', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_HighAccuracy3Dvelocity_confidenceHorizontal._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=99)], ev=None, er=[])
    _OMA_LPPe_HighAccuracy3Dvelocity_uncertainty_up_component = INT(name=u'uncertainty-up-component', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_HighAccuracy3Dvelocity_uncertainty_up_component._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _OMA_LPPe_HighAccuracy3Dvelocity_confidenceUp = INT(name=u'confidenceUp', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_HighAccuracy3Dvelocity_confidenceUp._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=99)], ev=None, er=[])
    OMA_LPPe_HighAccuracy3Dvelocity._cont = ASN1Dict([
        (u'enu-origin', _OMA_LPPe_HighAccuracy3Dvelocity_enu_origin),
        (u'east-component', _OMA_LPPe_HighAccuracy3Dvelocity_east_component),
        (u'negative-sign-east', _OMA_LPPe_HighAccuracy3Dvelocity_negative_sign_east),
        (u'north-component', _OMA_LPPe_HighAccuracy3Dvelocity_north_component),
        (u'negative-sign-north', _OMA_LPPe_HighAccuracy3Dvelocity_negative_sign_north),
        (u'up-component', _OMA_LPPe_HighAccuracy3Dvelocity_up_component),
        (u'negative-sign-up', _OMA_LPPe_HighAccuracy3Dvelocity_negative_sign_up),
        (u'cep', _OMA_LPPe_HighAccuracy3Dvelocity_cep),
        (u'uncertainty-semimajor', _OMA_LPPe_HighAccuracy3Dvelocity_uncertainty_semimajor),
        (u'uncertainty-semiminor', _OMA_LPPe_HighAccuracy3Dvelocity_uncertainty_semiminor),
        (u'offset-angle', _OMA_LPPe_HighAccuracy3Dvelocity_offset_angle),
        (u'confidenceHorizontal', _OMA_LPPe_HighAccuracy3Dvelocity_confidenceHorizontal),
        (u'uncertainty-up-component', _OMA_LPPe_HighAccuracy3Dvelocity_uncertainty_up_component),
        (u'confidenceUp', _OMA_LPPe_HighAccuracy3Dvelocity_confidenceUp),
        ])
    OMA_LPPe_HighAccuracy3Dvelocity._ext = []
    
    #-----< OMA-LPPe-LocationInformationContainerID >-----#
    OMA_LPPe_LocationInformationContainerID = SEQ(name=u'OMA-LPPe-LocationInformationContainerID', mode=MODE_TYPE)
    _OMA_LPPe_LocationInformationContainerID_containerID = INT(name=u'containerID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_LocationInformationContainerID_containerID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    OMA_LPPe_LocationInformationContainerID._cont = ASN1Dict([
        (u'containerID', _OMA_LPPe_LocationInformationContainerID_containerID),
        ])
    OMA_LPPe_LocationInformationContainerID._ext = []
    
    #-----< OMA-LPPe-LocationInformationContainer >-----#
    OMA_LPPe_LocationInformationContainer = SEQ(name=u'OMA-LPPe-LocationInformationContainer', mode=MODE_TYPE)
    _OMA_LPPe_LocationInformationContainer_vendorOrOperatorID = CHOICE(name=u'vendorOrOperatorID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-VendorOrOperatorID')))
    _OMA_LPPe_LocationInformationContainer_locationInformationContainerDataList = SEQ_OF(name=u'locationInformationContainerDataList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-LocationInformationContainerDataList')))
    OMA_LPPe_LocationInformationContainer._cont = ASN1Dict([
        (u'vendorOrOperatorID', _OMA_LPPe_LocationInformationContainer_vendorOrOperatorID),
        (u'locationInformationContainerDataList', _OMA_LPPe_LocationInformationContainer_locationInformationContainerDataList),
        ])
    OMA_LPPe_LocationInformationContainer._ext = []
    
    #-----< OMA-LPPe-LocationInformationContainerDataList >-----#
    OMA_LPPe_LocationInformationContainerDataList = SEQ_OF(name=u'OMA-LPPe-LocationInformationContainerDataList', mode=MODE_TYPE)
    _OMA_LPPe_LocationInformationContainerDataList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-LocationInformationContainerData')))
    OMA_LPPe_LocationInformationContainerDataList._cont = _OMA_LPPe_LocationInformationContainerDataList__item_
    OMA_LPPe_LocationInformationContainerDataList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=10)], ev=None, er=[])
    
    #-----< OMA-LPPe-LocationInformationContainerData >-----#
    OMA_LPPe_LocationInformationContainerData = SEQ(name=u'OMA-LPPe-LocationInformationContainerData', mode=MODE_TYPE)
    _OMA_LPPe_LocationInformationContainerData_containerID = SEQ(name=u'containerID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-LocationInformationContainerID')))
    _OMA_LPPe_LocationInformationContainerData_containerData = OCT_STR(name=u'containerData', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    OMA_LPPe_LocationInformationContainerData._cont = ASN1Dict([
        (u'containerID', _OMA_LPPe_LocationInformationContainerData_containerID),
        (u'containerData', _OMA_LPPe_LocationInformationContainerData_containerData),
        ])
    OMA_LPPe_LocationInformationContainerData._ext = []
    
    #-----< OMA-LPPe-LocationInformationContainerRequest >-----#
    OMA_LPPe_LocationInformationContainerRequest = SEQ(name=u'OMA-LPPe-LocationInformationContainerRequest', mode=MODE_TYPE)
    _OMA_LPPe_LocationInformationContainerRequest_vendorOrOperatorID = CHOICE(name=u'vendorOrOperatorID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-VendorOrOperatorID')))
    _OMA_LPPe_LocationInformationContainerRequest_locationInformationContainerRequestList = SEQ_OF(name=u'locationInformationContainerRequestList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-LocationInformationContainerRequestList')))
    OMA_LPPe_LocationInformationContainerRequest._cont = ASN1Dict([
        (u'vendorOrOperatorID', _OMA_LPPe_LocationInformationContainerRequest_vendorOrOperatorID),
        (u'locationInformationContainerRequestList', _OMA_LPPe_LocationInformationContainerRequest_locationInformationContainerRequestList),
        ])
    OMA_LPPe_LocationInformationContainerRequest._ext = []
    
    #-----< OMA-LPPe-LocationInformationContainerRequestList >-----#
    OMA_LPPe_LocationInformationContainerRequestList = SEQ_OF(name=u'OMA-LPPe-LocationInformationContainerRequestList', mode=MODE_TYPE)
    _OMA_LPPe_LocationInformationContainerRequestList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-LocationInformationContainerRequestItem')))
    OMA_LPPe_LocationInformationContainerRequestList._cont = _OMA_LPPe_LocationInformationContainerRequestList__item_
    OMA_LPPe_LocationInformationContainerRequestList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=10)], ev=None, er=[])
    
    #-----< maxLocationInformationContainerDataList >-----#
    maxLocationInformationContainerDataList = INT(name=u'maxLocationInformationContainerDataList', mode=MODE_VALUE)
    maxLocationInformationContainerDataList._val = 10
    
    #-----< OMA-LPPe-LocationInformationContainerRequestItem >-----#
    OMA_LPPe_LocationInformationContainerRequestItem = SEQ(name=u'OMA-LPPe-LocationInformationContainerRequestItem', mode=MODE_TYPE)
    _OMA_LPPe_LocationInformationContainerRequestItem_containerID = SEQ(name=u'containerID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-LocationInformationContainerID')))
    _OMA_LPPe_LocationInformationContainerRequestItem_additionalInformation = OCT_STR(name=u'additionalInformation', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    OMA_LPPe_LocationInformationContainerRequestItem._cont = ASN1Dict([
        (u'containerID', _OMA_LPPe_LocationInformationContainerRequestItem_containerID),
        (u'additionalInformation', _OMA_LPPe_LocationInformationContainerRequestItem_additionalInformation),
        ])
    OMA_LPPe_LocationInformationContainerRequestItem._ext = []
    
    #-----< OMA-LPPe-MapDataReference >-----#
    OMA_LPPe_MapDataReference = SEQ(name=u'OMA-LPPe-MapDataReference', mode=MODE_TYPE)
    _OMA_LPPe_MapDataReference_dataID = SEQ(name=u'dataID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AssistanceContainerID')))
    _OMA_LPPe_MapDataReference_mapReference = OCT_STR(name=u'mapReference', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_MapDataReference_mapReference._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _OMA_LPPe_MapDataReference_mapSize = INT(name=u'mapSize', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_MapDataReference_mapSize._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=5000)], ev=None, er=[])
    OMA_LPPe_MapDataReference._cont = ASN1Dict([
        (u'dataID', _OMA_LPPe_MapDataReference_dataID),
        (u'mapReference', _OMA_LPPe_MapDataReference_mapReference),
        (u'mapSize', _OMA_LPPe_MapDataReference_mapSize),
        ])
    OMA_LPPe_MapDataReference._ext = []
    
    #-----< OMA-LPPe-Orientation >-----#
    OMA_LPPe_Orientation = CHOICE(name=u'OMA-LPPe-Orientation', mode=MODE_TYPE)
    _OMA_LPPe_Orientation_eulerAngles = SEQ(name=u'eulerAngles', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_Orientation_eulerAngles_alpha = INT(name=u'alpha', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_Orientation_eulerAngles_alpha._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=359)], ev=None, er=[])
    __OMA_LPPe_Orientation_eulerAngles_beta = INT(name=u'beta', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_Orientation_eulerAngles_beta._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=180)], ev=None, er=[])
    __OMA_LPPe_Orientation_eulerAngles_gamma = INT(name=u'gamma', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_Orientation_eulerAngles_gamma._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=359)], ev=None, er=[])
    _OMA_LPPe_Orientation_eulerAngles._cont = ASN1Dict([
        (u'alpha', __OMA_LPPe_Orientation_eulerAngles_alpha),
        (u'beta', __OMA_LPPe_Orientation_eulerAngles_beta),
        (u'gamma', __OMA_LPPe_Orientation_eulerAngles_gamma),
        ])
    _OMA_LPPe_Orientation_eulerAngles._ext = []
    OMA_LPPe_Orientation._cont = ASN1Dict([
        (u'eulerAngles', _OMA_LPPe_Orientation_eulerAngles),
        ])
    OMA_LPPe_Orientation._ext = []
    
    #-----< OMA-LPPe-ReferencePoint >-----#
    OMA_LPPe_ReferencePoint = SEQ(name=u'OMA-LPPe-ReferencePoint', mode=MODE_TYPE)
    _OMA_LPPe_ReferencePoint_referencePointUniqueID = SEQ(name=u'referencePointUniqueID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ReferencePointUniqueID')), opt=True)
    _OMA_LPPe_ReferencePoint_referencePointGeographicLocation = CHOICE(name=u'referencePointGeographicLocation', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __OMA_LPPe_ReferencePoint_referencePointGeographicLocation_location3D = SEQ(name=u'location3D', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'EllipsoidPointWithAltitude')))
    __OMA_LPPe_ReferencePoint_referencePointGeographicLocation_location3DwithUncertainty = SEQ(name=u'location3DwithUncertainty', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'EllipsoidPointWithAltitudeAndUncertaintyEllipsoid')))
    __OMA_LPPe_ReferencePoint_referencePointGeographicLocation_locationwithhighaccuracy = SEQ(name=u'locationwithhighaccuracy', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-HighAccuracy3Dposition')))
    _OMA_LPPe_ReferencePoint_referencePointGeographicLocation._cont = ASN1Dict([
        (u'location3D', __OMA_LPPe_ReferencePoint_referencePointGeographicLocation_location3D),
        (u'location3DwithUncertainty', __OMA_LPPe_ReferencePoint_referencePointGeographicLocation_location3DwithUncertainty),
        (u'locationwithhighaccuracy', __OMA_LPPe_ReferencePoint_referencePointGeographicLocation_locationwithhighaccuracy),
        ])
    _OMA_LPPe_ReferencePoint_referencePointGeographicLocation._ext = []
    _OMA_LPPe_ReferencePoint_referencePointCivicLocation = SEQ(name=u'referencePointCivicLocation', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-CivicLocation')), opt=True)
    _OMA_LPPe_ReferencePoint_referencePointFloorLevel = INT(name=u'referencePointFloorLevel', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_ReferencePoint_referencePointFloorLevel._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-20, ub=235)], ev=None, er=[])
    _OMA_LPPe_ReferencePoint_relatedReferencePoints = SEQ_OF(name=u'relatedReferencePoints', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OMA_LPPe_ReferencePoint_relatedReferencePoints__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ReferencePointRelationship')))
    _OMA_LPPe_ReferencePoint_relatedReferencePoints._cont = __OMA_LPPe_ReferencePoint_relatedReferencePoints__item_
    _OMA_LPPe_ReferencePoint_relatedReferencePoints._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    _OMA_LPPe_ReferencePoint_mapDataInformation = SEQ_OF(name=u'mapDataInformation', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-MapDataInformation')), opt=True)
    OMA_LPPe_ReferencePoint._cont = ASN1Dict([
        (u'referencePointUniqueID', _OMA_LPPe_ReferencePoint_referencePointUniqueID),
        (u'referencePointGeographicLocation', _OMA_LPPe_ReferencePoint_referencePointGeographicLocation),
        (u'referencePointCivicLocation', _OMA_LPPe_ReferencePoint_referencePointCivicLocation),
        (u'referencePointFloorLevel', _OMA_LPPe_ReferencePoint_referencePointFloorLevel),
        (u'relatedReferencePoints', _OMA_LPPe_ReferencePoint_relatedReferencePoints),
        (u'mapDataInformation', _OMA_LPPe_ReferencePoint_mapDataInformation),
        ])
    OMA_LPPe_ReferencePoint._ext = []
    
    #-----< OMA-LPPe-MapDataInformation >-----#
    OMA_LPPe_MapDataInformation = SEQ_OF(name=u'OMA-LPPe-MapDataInformation', mode=MODE_TYPE)
    _OMA_LPPe_MapDataInformation__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-MapDataReferenceElement')))
    OMA_LPPe_MapDataInformation._cont = _OMA_LPPe_MapDataInformation__item_
    OMA_LPPe_MapDataInformation._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    
    #-----< OMA-LPPe-MapDataReferenceElement >-----#
    OMA_LPPe_MapDataReferenceElement = SEQ(name=u'OMA-LPPe-MapDataReferenceElement', mode=MODE_TYPE)
    _OMA_LPPe_MapDataReferenceElement_mapDataUrl = CHOICE(name=u'mapDataUrl', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __OMA_LPPe_MapDataReferenceElement_mapDataUrl_mapDataUrl = STR_VIS(name=u'mapDataUrl', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-Uri')))
    __OMA_LPPe_MapDataReferenceElement_mapDataUrl_mapDataUrl._const_alpha = ASN1Set(rv=[u':', u'/', u'?', u'#', u'[', u']', u'@', u'!', u'$', u'&', u"'", u'(', u')', u'*', u'+', u',', u';', u'=', u'-', u'.', u'_', u'~'], rr=[ASN1RangeStr(lb=u'a', ub=u'z'), ASN1RangeStr(lb=u'A', ub=u'Z'), ASN1RangeStr(lb=u'0', ub=u'9')], ev=None, er=[])
    __OMA_LPPe_MapDataReferenceElement_mapDataUrl_mapDataRef = SEQ(name=u'mapDataRef', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-MapDataReference')))
    _OMA_LPPe_MapDataReferenceElement_mapDataUrl._cont = ASN1Dict([
        (u'mapDataUrl', __OMA_LPPe_MapDataReferenceElement_mapDataUrl_mapDataUrl),
        (u'mapDataRef', __OMA_LPPe_MapDataReferenceElement_mapDataUrl_mapDataRef),
        ])
    _OMA_LPPe_MapDataReferenceElement_mapDataUrl._ext = None
    _OMA_LPPe_MapDataReferenceElement_mapProvider = CHOICE(name=u'mapProvider', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __OMA_LPPe_MapDataReferenceElement_mapProvider_sameAsRefPointProvider = NULL(name=u'sameAsRefPointProvider', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_MapDataReferenceElement_mapProvider_notSameAsRefPointProvider = CHOICE(name=u'notSameAsRefPointProvider', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-VendorOrOperatorID')))
    _OMA_LPPe_MapDataReferenceElement_mapProvider._cont = ASN1Dict([
        (u'sameAsRefPointProvider', __OMA_LPPe_MapDataReferenceElement_mapProvider_sameAsRefPointProvider),
        (u'notSameAsRefPointProvider', __OMA_LPPe_MapDataReferenceElement_mapProvider_notSameAsRefPointProvider),
        ])
    _OMA_LPPe_MapDataReferenceElement_mapProvider._ext = []
    _OMA_LPPe_MapDataReferenceElement_mapAssociation = CHOICE(name=u'mapAssociation', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __OMA_LPPe_MapDataReferenceElement_mapAssociation_referencePointUniqueID = NULL(name=u'referencePointUniqueID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_MapDataReferenceElement_mapAssociation_otherID = STR_VIS(name=u'otherID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_MapDataReferenceElement_mapAssociation_otherID._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __OMA_LPPe_MapDataReferenceElement_mapAssociation_mapOffset = SEQ(name=u'mapOffset', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-RelativeLocation')))
    __OMA_LPPe_MapDataReferenceElement_mapAssociation_origin = NULL(name=u'origin', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_MapDataReferenceElement_mapAssociation._cont = ASN1Dict([
        (u'referencePointUniqueID', __OMA_LPPe_MapDataReferenceElement_mapAssociation_referencePointUniqueID),
        (u'otherID', __OMA_LPPe_MapDataReferenceElement_mapAssociation_otherID),
        (u'mapOffset', __OMA_LPPe_MapDataReferenceElement_mapAssociation_mapOffset),
        (u'origin', __OMA_LPPe_MapDataReferenceElement_mapAssociation_origin),
        ])
    _OMA_LPPe_MapDataReferenceElement_mapAssociation._ext = []
    _OMA_LPPe_MapDataReferenceElement_mapHorizontalOrientation = INT(name=u'mapHorizontalOrientation', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_MapDataReferenceElement_mapHorizontalOrientation._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=359)], ev=None, er=[])
    OMA_LPPe_MapDataReferenceElement._cont = ASN1Dict([
        (u'mapDataUrl', _OMA_LPPe_MapDataReferenceElement_mapDataUrl),
        (u'mapProvider', _OMA_LPPe_MapDataReferenceElement_mapProvider),
        (u'mapAssociation', _OMA_LPPe_MapDataReferenceElement_mapAssociation),
        (u'mapHorizontalOrientation', _OMA_LPPe_MapDataReferenceElement_mapHorizontalOrientation),
        ])
    OMA_LPPe_MapDataReferenceElement._ext = []
    
    #-----< OMA-LPPe-ReferencePointRelationship >-----#
    OMA_LPPe_ReferencePointRelationship = SEQ(name=u'OMA-LPPe-ReferencePointRelationship', mode=MODE_TYPE)
    _OMA_LPPe_ReferencePointRelationship_referencePointUniqueID = SEQ(name=u'referencePointUniqueID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ReferencePointUniqueID')))
    _OMA_LPPe_ReferencePointRelationship_relativeLocation = SEQ(name=u'relativeLocation', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-RelativeLocation')))
    OMA_LPPe_ReferencePointRelationship._cont = ASN1Dict([
        (u'referencePointUniqueID', _OMA_LPPe_ReferencePointRelationship_referencePointUniqueID),
        (u'relativeLocation', _OMA_LPPe_ReferencePointRelationship_relativeLocation),
        ])
    OMA_LPPe_ReferencePointRelationship._ext = []
    
    #-----< OMA-LPPe-ReferencePointUniqueID >-----#
    OMA_LPPe_ReferencePointUniqueID = SEQ(name=u'OMA-LPPe-ReferencePointUniqueID', mode=MODE_TYPE)
    _OMA_LPPe_ReferencePointUniqueID_providerID = CHOICE(name=u'providerID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-VendorOrOperatorID')))
    _OMA_LPPe_ReferencePointUniqueID_providerAssignedID = OCT_STR(name=u'providerAssignedID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_ReferencePointUniqueID_version = INT(name=u'version', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_ReferencePointUniqueID_version._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    OMA_LPPe_ReferencePointUniqueID._cont = ASN1Dict([
        (u'providerID', _OMA_LPPe_ReferencePointUniqueID_providerID),
        (u'providerAssignedID', _OMA_LPPe_ReferencePointUniqueID_providerAssignedID),
        (u'version', _OMA_LPPe_ReferencePointUniqueID_version),
        ])
    OMA_LPPe_ReferencePointUniqueID._ext = []
    
    #-----< OMA-LPPe-RelativeLocation >-----#
    OMA_LPPe_RelativeLocation = SEQ(name=u'OMA-LPPe-RelativeLocation', mode=MODE_TYPE)
    _OMA_LPPe_RelativeLocation_units = ENUM(name=u'units', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_RelativeLocation_units._cont = ASN1Dict([(u'cm', 0), (u'dm', 1), (u'm10', 2)])
    _OMA_LPPe_RelativeLocation_units._ext = []
    _OMA_LPPe_RelativeLocation_arc_second_units = ENUM(name=u'arc-second-units', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_RelativeLocation_arc_second_units._cont = ASN1Dict([(u'as0-0003', 0), (u'as0-003', 1), (u'as0-03', 2), (u'as0-3', 3)])
    _OMA_LPPe_RelativeLocation_arc_second_units._ext = []
    _OMA_LPPe_RelativeLocation_relativeNorth = INT(name=u'relativeNorth', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_RelativeLocation_relativeNorth._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-524288, ub=524287)], ev=None, er=[])
    _OMA_LPPe_RelativeLocation_relativeEast = INT(name=u'relativeEast', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_RelativeLocation_relativeEast._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-524288, ub=524287)], ev=None, er=[])
    _OMA_LPPe_RelativeLocation_relativeAltitude = SEQ(name=u'relativeAltitude', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-RelativeAltitude')), opt=True)
    _OMA_LPPe_RelativeLocation_horizontalUncertainty = SEQ(name=u'horizontalUncertainty', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-HorizontalUncertaintyAndConfidence')), opt=True)
    OMA_LPPe_RelativeLocation._cont = ASN1Dict([
        (u'units', _OMA_LPPe_RelativeLocation_units),
        (u'arc-second-units', _OMA_LPPe_RelativeLocation_arc_second_units),
        (u'relativeNorth', _OMA_LPPe_RelativeLocation_relativeNorth),
        (u'relativeEast', _OMA_LPPe_RelativeLocation_relativeEast),
        (u'relativeAltitude', _OMA_LPPe_RelativeLocation_relativeAltitude),
        (u'horizontalUncertainty', _OMA_LPPe_RelativeLocation_horizontalUncertainty),
        ])
    OMA_LPPe_RelativeLocation._ext = []
    
    #-----< OMA-LPPe-HorizontalUncertaintyAndConfidence >-----#
    OMA_LPPe_HorizontalUncertaintyAndConfidence = SEQ(name=u'OMA-LPPe-HorizontalUncertaintyAndConfidence', mode=MODE_TYPE)
    _OMA_LPPe_HorizontalUncertaintyAndConfidence_uncShape = CHOICE(name=u'uncShape', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __OMA_LPPe_HorizontalUncertaintyAndConfidence_uncShape_circle = INT(name=u'circle', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_HorizontalUncertaintyAndConfidence_uncShape_circle._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    __OMA_LPPe_HorizontalUncertaintyAndConfidence_uncShape_ellipse = SEQ(name=u'ellipse', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___OMA_LPPe_HorizontalUncertaintyAndConfidence_uncShape_ellipse_semimajor = INT(name=u'semimajor', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___OMA_LPPe_HorizontalUncertaintyAndConfidence_uncShape_ellipse_semimajor._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    ___OMA_LPPe_HorizontalUncertaintyAndConfidence_uncShape_ellipse_semiminor = INT(name=u'semiminor', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___OMA_LPPe_HorizontalUncertaintyAndConfidence_uncShape_ellipse_semiminor._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    ___OMA_LPPe_HorizontalUncertaintyAndConfidence_uncShape_ellipse_offsetAngle = INT(name=u'offsetAngle', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___OMA_LPPe_HorizontalUncertaintyAndConfidence_uncShape_ellipse_offsetAngle._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=179)], ev=None, er=[])
    __OMA_LPPe_HorizontalUncertaintyAndConfidence_uncShape_ellipse._cont = ASN1Dict([
        (u'semimajor', ___OMA_LPPe_HorizontalUncertaintyAndConfidence_uncShape_ellipse_semimajor),
        (u'semiminor', ___OMA_LPPe_HorizontalUncertaintyAndConfidence_uncShape_ellipse_semiminor),
        (u'offsetAngle', ___OMA_LPPe_HorizontalUncertaintyAndConfidence_uncShape_ellipse_offsetAngle),
        ])
    __OMA_LPPe_HorizontalUncertaintyAndConfidence_uncShape_ellipse._ext = None
    _OMA_LPPe_HorizontalUncertaintyAndConfidence_uncShape._cont = ASN1Dict([
        (u'circle', __OMA_LPPe_HorizontalUncertaintyAndConfidence_uncShape_circle),
        (u'ellipse', __OMA_LPPe_HorizontalUncertaintyAndConfidence_uncShape_ellipse),
        ])
    _OMA_LPPe_HorizontalUncertaintyAndConfidence_uncShape._ext = []
    _OMA_LPPe_HorizontalUncertaintyAndConfidence_confidence = INT(name=u'confidence', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_HorizontalUncertaintyAndConfidence_confidence._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=99)], ev=None, er=[])
    OMA_LPPe_HorizontalUncertaintyAndConfidence._cont = ASN1Dict([
        (u'uncShape', _OMA_LPPe_HorizontalUncertaintyAndConfidence_uncShape),
        (u'confidence', _OMA_LPPe_HorizontalUncertaintyAndConfidence_confidence),
        ])
    OMA_LPPe_HorizontalUncertaintyAndConfidence._ext = []
    
    #-----< OMA-LPPe-RelativeAltitude >-----#
    OMA_LPPe_RelativeAltitude = SEQ(name=u'OMA-LPPe-RelativeAltitude', mode=MODE_TYPE)
    _OMA_LPPe_RelativeAltitude_geodeticRelativeAltitude = SEQ(name=u'geodeticRelativeAltitude', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-GeodeticRelativeAltitude')), opt=True)
    _OMA_LPPe_RelativeAltitude_civicRelativeAltitude = SEQ(name=u'civicRelativeAltitude', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-CivicRelativeAltitude')), opt=True)
    OMA_LPPe_RelativeAltitude._cont = ASN1Dict([
        (u'geodeticRelativeAltitude', _OMA_LPPe_RelativeAltitude_geodeticRelativeAltitude),
        (u'civicRelativeAltitude', _OMA_LPPe_RelativeAltitude_civicRelativeAltitude),
        ])
    OMA_LPPe_RelativeAltitude._ext = []
    
    #-----< OMA-LPPe-GeodeticRelativeAltitude >-----#
    OMA_LPPe_GeodeticRelativeAltitude = SEQ(name=u'OMA-LPPe-GeodeticRelativeAltitude', mode=MODE_TYPE)
    _OMA_LPPe_GeodeticRelativeAltitude_geodetic_height_depth = INT(name=u'geodetic-height-depth', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_GeodeticRelativeAltitude_geodetic_height_depth._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-32768, ub=32767)], ev=None, er=[])
    _OMA_LPPe_GeodeticRelativeAltitude_geodetic_uncertainty_and_confidence = SEQ(name=u'geodetic-uncertainty-and-confidence', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-GeodeticUncertaintyAndConfidence')), opt=True)
    OMA_LPPe_GeodeticRelativeAltitude._cont = ASN1Dict([
        (u'geodetic-height-depth', _OMA_LPPe_GeodeticRelativeAltitude_geodetic_height_depth),
        (u'geodetic-uncertainty-and-confidence', _OMA_LPPe_GeodeticRelativeAltitude_geodetic_uncertainty_and_confidence),
        ])
    OMA_LPPe_GeodeticRelativeAltitude._ext = []
    
    #-----< OMA-LPPe-GeodeticUncertaintyAndConfidence >-----#
    OMA_LPPe_GeodeticUncertaintyAndConfidence = SEQ(name=u'OMA-LPPe-GeodeticUncertaintyAndConfidence', mode=MODE_TYPE)
    _OMA_LPPe_GeodeticUncertaintyAndConfidence_uncertainty = INT(name=u'uncertainty', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_GeodeticUncertaintyAndConfidence_uncertainty._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    _OMA_LPPe_GeodeticUncertaintyAndConfidence_confidence = INT(name=u'confidence', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_GeodeticUncertaintyAndConfidence_confidence._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=99)], ev=None, er=[])
    OMA_LPPe_GeodeticUncertaintyAndConfidence._cont = ASN1Dict([
        (u'uncertainty', _OMA_LPPe_GeodeticUncertaintyAndConfidence_uncertainty),
        (u'confidence', _OMA_LPPe_GeodeticUncertaintyAndConfidence_confidence),
        ])
    OMA_LPPe_GeodeticUncertaintyAndConfidence._ext = []
    
    #-----< OMA-LPPe-CivicRelativeAltitude >-----#
    OMA_LPPe_CivicRelativeAltitude = SEQ(name=u'OMA-LPPe-CivicRelativeAltitude', mode=MODE_TYPE)
    _OMA_LPPe_CivicRelativeAltitude_civic_floors = INT(name=u'civic-floors', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_CivicRelativeAltitude_civic_floors._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-255, ub=256)], ev=None, er=[])
    _OMA_LPPe_CivicRelativeAltitude_civic_uncertainty_and_confidence = SEQ(name=u'civic-uncertainty-and-confidence', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-CivicUncertaintyAndConfidence')), opt=True)
    OMA_LPPe_CivicRelativeAltitude._cont = ASN1Dict([
        (u'civic-floors', _OMA_LPPe_CivicRelativeAltitude_civic_floors),
        (u'civic-uncertainty-and-confidence', _OMA_LPPe_CivicRelativeAltitude_civic_uncertainty_and_confidence),
        ])
    OMA_LPPe_CivicRelativeAltitude._ext = []
    
    #-----< OMA-LPPe-CivicUncertaintyAndConfidence >-----#
    OMA_LPPe_CivicUncertaintyAndConfidence = SEQ(name=u'OMA-LPPe-CivicUncertaintyAndConfidence', mode=MODE_TYPE)
    _OMA_LPPe_CivicUncertaintyAndConfidence_uncertainty = INT(name=u'uncertainty', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_CivicUncertaintyAndConfidence_uncertainty._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    _OMA_LPPe_CivicUncertaintyAndConfidence_confidence = INT(name=u'confidence', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_CivicUncertaintyAndConfidence_confidence._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=99)], ev=None, er=[])
    OMA_LPPe_CivicUncertaintyAndConfidence._cont = ASN1Dict([
        (u'uncertainty', _OMA_LPPe_CivicUncertaintyAndConfidence_uncertainty),
        (u'confidence', _OMA_LPPe_CivicUncertaintyAndConfidence_confidence),
        ])
    OMA_LPPe_CivicUncertaintyAndConfidence._ext = []
    
    #-----< OMA-LPPe-Session-ID >-----#
    OMA_LPPe_Session_ID = SEQ(name=u'OMA-LPPe-Session-ID', mode=MODE_TYPE)
    _OMA_LPPe_Session_ID_provider_ID = CHOICE(name=u'provider-ID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-VendorOrOperatorID')))
    _OMA_LPPe_Session_ID_server_ID = OCT_STR(name=u'server-ID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_Session_ID_server_ID._const_sz = ASN1Set(rv=[4], rr=[], ev=None, er=[])
    _OMA_LPPe_Session_ID_session_ID = OCT_STR(name=u'session-ID', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_Session_ID_session_ID._const_sz = ASN1Set(rv=[4], rr=[], ev=None, er=[])
    OMA_LPPe_Session_ID._cont = ASN1Dict([
        (u'provider-ID', _OMA_LPPe_Session_ID_provider_ID),
        (u'server-ID', _OMA_LPPe_Session_ID_server_ID),
        (u'session-ID', _OMA_LPPe_Session_ID_session_ID),
        ])
    OMA_LPPe_Session_ID._ext = []
    
    #-----< OMA-LPPe-Uri >-----#
    OMA_LPPe_Uri = STR_VIS(name=u'OMA-LPPe-Uri', mode=MODE_TYPE)
    OMA_LPPe_Uri._const_alpha = ASN1Set(rv=[u':', u'/', u'?', u'#', u'[', u']', u'@', u'!', u'$', u'&', u"'", u'(', u')', u'*', u'+', u',', u';', u'=', u'-', u'.', u'_', u'~'], rr=[ASN1RangeStr(lb=u'a', ub=u'z'), ASN1RangeStr(lb=u'A', ub=u'Z'), ASN1RangeStr(lb=u'0', ub=u'9')], ev=None, er=[])
    
    #-----< OMA-LPPe-ver1-1-BroadcastSystemID >-----#
    OMA_LPPe_ver1_1_BroadcastSystemID = CHOICE(name=u'OMA-LPPe-ver1-1-BroadcastSystemID', mode=MODE_TYPE)
    _OMA_LPPe_ver1_1_BroadcastSystemID_standardSystemID = INT(name=u'standardSystemID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_ver1_1_BroadcastSystemID_standardSystemID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    _OMA_LPPe_ver1_1_BroadcastSystemID_proprietarySystemID = SEQ(name=u'proprietarySystemID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_ver1_1_BroadcastSystemID_proprietarySystemID_vendorOrOperator = CHOICE(name=u'vendorOrOperator', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-VendorOrOperatorID')))
    __OMA_LPPe_ver1_1_BroadcastSystemID_proprietarySystemID_proprietarySystemID = INT(name=u'proprietarySystemID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_ver1_1_BroadcastSystemID_proprietarySystemID_proprietarySystemID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    _OMA_LPPe_ver1_1_BroadcastSystemID_proprietarySystemID._cont = ASN1Dict([
        (u'vendorOrOperator', __OMA_LPPe_ver1_1_BroadcastSystemID_proprietarySystemID_vendorOrOperator),
        (u'proprietarySystemID', __OMA_LPPe_ver1_1_BroadcastSystemID_proprietarySystemID_proprietarySystemID),
        ])
    _OMA_LPPe_ver1_1_BroadcastSystemID_proprietarySystemID._ext = None
    OMA_LPPe_ver1_1_BroadcastSystemID._cont = ASN1Dict([
        (u'standardSystemID', _OMA_LPPe_ver1_1_BroadcastSystemID_standardSystemID),
        (u'proprietarySystemID', _OMA_LPPe_ver1_1_BroadcastSystemID_proprietarySystemID),
        ])
    OMA_LPPe_ver1_1_BroadcastSystemID._ext = []
    
    #-----< OMA-LPPe-ver1-1-BroadcastADTypes >-----#
    OMA_LPPe_ver1_1_BroadcastADTypes = SEQ(name=u'OMA-LPPe-ver1-1-BroadcastADTypes', mode=MODE_TYPE)
    _OMA_LPPe_ver1_1_BroadcastADTypes_lppLabels = SEQ_OF(name=u'lppLabels', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_ver1_1_BroadcastADTypes_lppLabels__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-LabelSet')))
    _OMA_LPPe_ver1_1_BroadcastADTypes_lppLabels._cont = __OMA_LPPe_ver1_1_BroadcastADTypes_lppLabels__item_
    _OMA_LPPe_ver1_1_BroadcastADTypes_lppLabels._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _OMA_LPPe_ver1_1_BroadcastADTypes_lppeLabels = SEQ_OF(name=u'lppeLabels', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_ver1_1_BroadcastADTypes_lppeLabels__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-LabelSet')))
    _OMA_LPPe_ver1_1_BroadcastADTypes_lppeLabels._cont = __OMA_LPPe_ver1_1_BroadcastADTypes_lppeLabels__item_
    _OMA_LPPe_ver1_1_BroadcastADTypes_lppeLabels._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    OMA_LPPe_ver1_1_BroadcastADTypes._cont = ASN1Dict([
        (u'lppLabels', _OMA_LPPe_ver1_1_BroadcastADTypes_lppLabels),
        (u'lppeLabels', _OMA_LPPe_ver1_1_BroadcastADTypes_lppeLabels),
        ])
    OMA_LPPe_ver1_1_BroadcastADTypes._ext = []
    
    #-----< OMA-LPPe-ver1-1-LabelSet >-----#
    OMA_LPPe_ver1_1_LabelSet = SEQ(name=u'OMA-LPPe-ver1-1-LabelSet', mode=MODE_TYPE)
    _OMA_LPPe_ver1_1_LabelSet_level1_element = SEQ(name=u'level1-element', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OMA_LPPe_ver1_1_LabelSet_level1_element_level1_element_value = INT(name=u'level1-element-value', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_ver1_1_LabelSet_level1_element_level1_element_value._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    __OMA_LPPe_ver1_1_LabelSet_level1_element_level2_element = SEQ(name=u'level2-element', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    ___OMA_LPPe_ver1_1_LabelSet_level1_element_level2_element_level2_element_value = INT(name=u'level2-element-value', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___OMA_LPPe_ver1_1_LabelSet_level1_element_level2_element_level2_element_value._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    ___OMA_LPPe_ver1_1_LabelSet_level1_element_level2_element_level3_element = SEQ(name=u'level3-element', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    ____OMA_LPPe_ver1_1_LabelSet_level1_element_level2_element_level3_element_level3_element_value = INT(name=u'level3-element-value', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ____OMA_LPPe_ver1_1_LabelSet_level1_element_level2_element_level3_element_level3_element_value._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    ___OMA_LPPe_ver1_1_LabelSet_level1_element_level2_element_level3_element._cont = ASN1Dict([
        (u'level3-element-value', ____OMA_LPPe_ver1_1_LabelSet_level1_element_level2_element_level3_element_level3_element_value),
        ])
    ___OMA_LPPe_ver1_1_LabelSet_level1_element_level2_element_level3_element._ext = []
    __OMA_LPPe_ver1_1_LabelSet_level1_element_level2_element._cont = ASN1Dict([
        (u'level2-element-value', ___OMA_LPPe_ver1_1_LabelSet_level1_element_level2_element_level2_element_value),
        (u'level3-element', ___OMA_LPPe_ver1_1_LabelSet_level1_element_level2_element_level3_element),
        ])
    __OMA_LPPe_ver1_1_LabelSet_level1_element_level2_element._ext = []
    _OMA_LPPe_ver1_1_LabelSet_level1_element._cont = ASN1Dict([
        (u'level1-element-value', __OMA_LPPe_ver1_1_LabelSet_level1_element_level1_element_value),
        (u'level2-element', __OMA_LPPe_ver1_1_LabelSet_level1_element_level2_element),
        ])
    _OMA_LPPe_ver1_1_LabelSet_level1_element._ext = []
    _OMA_LPPe_ver1_1_LabelSet_lastElements = BIT_STR(name=u'lastElements', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_ver1_1_LabelSet_lastElements._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    _OMA_LPPe_ver1_1_LabelSet_additionalElements = ENUM(name=u'additionalElements', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_ver1_1_LabelSet_additionalElements._cont = ASN1Dict([(u'none', 0), (u'all', 1)])
    _OMA_LPPe_ver1_1_LabelSet_additionalElements._ext = []
    OMA_LPPe_ver1_1_LabelSet._cont = ASN1Dict([
        (u'level1-element', _OMA_LPPe_ver1_1_LabelSet_level1_element),
        (u'lastElements', _OMA_LPPe_ver1_1_LabelSet_lastElements),
        (u'additionalElements', _OMA_LPPe_ver1_1_LabelSet_additionalElements),
        ])
    OMA_LPPe_ver1_1_LabelSet._ext = []
    
    #-----< maxLevel1-element >-----#
    maxLevel1_element = INT(name=u'maxLevel1-element', mode=MODE_VALUE)
    maxLevel1_element._val = 32
    
    #-----< maxLevel2-element >-----#
    maxLevel2_element = INT(name=u'maxLevel2-element', mode=MODE_VALUE)
    maxLevel2_element._val = 32
    
    #-----< maxLevel3-element >-----#
    maxLevel3_element = INT(name=u'maxLevel3-element', mode=MODE_VALUE)
    maxLevel3_element._val = 32
    
    #-----< maxFinal-element >-----#
    maxFinal_element = INT(name=u'maxFinal-element', mode=MODE_VALUE)
    maxFinal_element._val = 32
    
    #-----< maxLPPLabelSets >-----#
    maxLPPLabelSets = INT(name=u'maxLPPLabelSets', mode=MODE_VALUE)
    maxLPPLabelSets._val = 64
    
    #-----< maxLPPeLabelSets >-----#
    maxLPPeLabelSets = INT(name=u'maxLPPeLabelSets', mode=MODE_VALUE)
    maxLPPeLabelSets._val = 128
    
    #-----< OMA-LPPe-ver1-1-AccessNetworkID >-----#
    OMA_LPPe_ver1_1_AccessNetworkID = CHOICE(name=u'OMA-LPPe-ver1-1-AccessNetworkID', mode=MODE_TYPE)
    _OMA_LPPe_ver1_1_AccessNetworkID_gSMAccess = SEQ(name=u'gSMAccess', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-MCC-MNC')))
    _OMA_LPPe_ver1_1_AccessNetworkID_wCDMAAccess = SEQ(name=u'wCDMAAccess', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-MCC-MNC')))
    _OMA_LPPe_ver1_1_AccessNetworkID_lTEAccess = SEQ(name=u'lTEAccess', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-MCC-MNC')))
    _OMA_LPPe_ver1_1_AccessNetworkID_wiMaxAccess = SEQ(name=u'wiMaxAccess', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-BSID')))
    _OMA_LPPe_ver1_1_AccessNetworkID_wLANAccess = SEQ(name=u'wLANAccess', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-WLAN-AP-ID')))
    OMA_LPPe_ver1_1_AccessNetworkID._cont = ASN1Dict([
        (u'gSMAccess', _OMA_LPPe_ver1_1_AccessNetworkID_gSMAccess),
        (u'wCDMAAccess', _OMA_LPPe_ver1_1_AccessNetworkID_wCDMAAccess),
        (u'lTEAccess', _OMA_LPPe_ver1_1_AccessNetworkID_lTEAccess),
        (u'wiMaxAccess', _OMA_LPPe_ver1_1_AccessNetworkID_wiMaxAccess),
        (u'wLANAccess', _OMA_LPPe_ver1_1_AccessNetworkID_wLANAccess),
        ])
    OMA_LPPe_ver1_1_AccessNetworkID._ext = []
    
    #-----< OMA-LPPe-ver1-1-MCC-MNC >-----#
    OMA_LPPe_ver1_1_MCC_MNC = SEQ(name=u'OMA-LPPe-ver1-1-MCC-MNC', mode=MODE_TYPE)
    _OMA_LPPe_ver1_1_MCC_MNC_mcc = SEQ_OF(name=u'mcc', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_ver1_1_MCC_MNC_mcc__item_ = INT(name='_item_', mode=MODE_TYPE)
    __OMA_LPPe_ver1_1_MCC_MNC_mcc__item_._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=9)], ev=None, er=[])
    _OMA_LPPe_ver1_1_MCC_MNC_mcc._cont = __OMA_LPPe_ver1_1_MCC_MNC_mcc__item_
    _OMA_LPPe_ver1_1_MCC_MNC_mcc._const_sz = ASN1Set(rv=[3], rr=[], ev=None, er=[])
    _OMA_LPPe_ver1_1_MCC_MNC_mnc = SEQ_OF(name=u'mnc', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_ver1_1_MCC_MNC_mnc__item_ = INT(name='_item_', mode=MODE_TYPE)
    __OMA_LPPe_ver1_1_MCC_MNC_mnc__item_._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=9)], ev=None, er=[])
    _OMA_LPPe_ver1_1_MCC_MNC_mnc._cont = __OMA_LPPe_ver1_1_MCC_MNC_mnc__item_
    _OMA_LPPe_ver1_1_MCC_MNC_mnc._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=2, ub=3)], ev=None, er=[])
    OMA_LPPe_ver1_1_MCC_MNC._cont = ASN1Dict([
        (u'mcc', _OMA_LPPe_ver1_1_MCC_MNC_mcc),
        (u'mnc', _OMA_LPPe_ver1_1_MCC_MNC_mnc),
        ])
    OMA_LPPe_ver1_1_MCC_MNC._ext = []
    
    #-----< OMA-LPPe-ver1-1-BSID >-----#
    OMA_LPPe_ver1_1_BSID = SEQ(name=u'OMA-LPPe-ver1-1-BSID', mode=MODE_TYPE)
    _OMA_LPPe_ver1_1_BSID_bsID_MSB = BIT_STR(name=u'bsID-MSB', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_ver1_1_BSID_bsID_MSB._const_sz = ASN1Set(rv=[24], rr=[], ev=None, er=[])
    _OMA_LPPe_ver1_1_BSID_bsID_LSB = BIT_STR(name=u'bsID-LSB', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_ver1_1_BSID_bsID_LSB._const_sz = ASN1Set(rv=[24], rr=[], ev=None, er=[])
    OMA_LPPe_ver1_1_BSID._cont = ASN1Dict([
        (u'bsID-MSB', _OMA_LPPe_ver1_1_BSID_bsID_MSB),
        (u'bsID-LSB', _OMA_LPPe_ver1_1_BSID_bsID_LSB),
        ])
    OMA_LPPe_ver1_1_BSID._ext = []
    
    #-----< OMA-LPPe-ver1-1-AuthenticationSetID >-----#
    OMA_LPPe_ver1_1_AuthenticationSetID = INT(name=u'OMA-LPPe-ver1-1-AuthenticationSetID', mode=MODE_TYPE)
    OMA_LPPe_ver1_1_AuthenticationSetID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    
    #-----< OMA-LPPe-ver1-1-AuthenticationSet >-----#
    OMA_LPPe_ver1_1_AuthenticationSet = SEQ(name=u'OMA-LPPe-ver1-1-AuthenticationSet', mode=MODE_TYPE)
    _OMA_LPPe_ver1_1_AuthenticationSet_authenticationSetID = INT(name=u'authenticationSetID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-AuthenticationSetID')))
    _OMA_LPPe_ver1_1_AuthenticationSet_rsaPublicKey = SEQ(name=u'rsaPublicKey', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_ver1_1_AuthenticationSet_rsaPublicKey_modulus = BIT_STR(name=u'modulus', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_ver1_1_AuthenticationSet_rsaPublicKey_modulus._const_sz = ASN1Set(rv=[2048], rr=[], ev=None, er=[])
    __OMA_LPPe_ver1_1_AuthenticationSet_rsaPublicKey_exponent = BIT_STR(name=u'exponent', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_ver1_1_AuthenticationSet_rsaPublicKey_exponent._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=2, ub=2048)], ev=None, er=[])
    _OMA_LPPe_ver1_1_AuthenticationSet_rsaPublicKey._cont = ASN1Dict([
        (u'modulus', __OMA_LPPe_ver1_1_AuthenticationSet_rsaPublicKey_modulus),
        (u'exponent', __OMA_LPPe_ver1_1_AuthenticationSet_rsaPublicKey_exponent),
        ])
    _OMA_LPPe_ver1_1_AuthenticationSet_rsaPublicKey._ext = None
    _OMA_LPPe_ver1_1_AuthenticationSet_saltLength = INT(name=u'saltLength', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_ver1_1_AuthenticationSet_saltLength._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=32)], ev=None, er=[])
    OMA_LPPe_ver1_1_AuthenticationSet._cont = ASN1Dict([
        (u'authenticationSetID', _OMA_LPPe_ver1_1_AuthenticationSet_authenticationSetID),
        (u'rsaPublicKey', _OMA_LPPe_ver1_1_AuthenticationSet_rsaPublicKey),
        (u'saltLength', _OMA_LPPe_ver1_1_AuthenticationSet_saltLength),
        ])
    OMA_LPPe_ver1_1_AuthenticationSet._ext = []
    
    #-----< OMA-LPPe-ver1-1-CipherSetID >-----#
    OMA_LPPe_ver1_1_CipherSetID = INT(name=u'OMA-LPPe-ver1-1-CipherSetID', mode=MODE_TYPE)
    OMA_LPPe_ver1_1_CipherSetID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    
    #-----< OMA-LPPe-ver1-1-CipherSet >-----#
    OMA_LPPe_ver1_1_CipherSet = SEQ(name=u'OMA-LPPe-ver1-1-CipherSet', mode=MODE_TYPE)
    _OMA_LPPe_ver1_1_CipherSet_cipherSetID = INT(name=u'cipherSetID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-CipherSetID')))
    _OMA_LPPe_ver1_1_CipherSet_cipherKey = BIT_STR(name=u'cipherKey', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_ver1_1_CipherSet_cipherKey._const_sz = ASN1Set(rv=[128], rr=[], ev=None, er=[])
    _OMA_LPPe_ver1_1_CipherSet_c0 = BIT_STR(name=u'c0', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_ver1_1_CipherSet_c0._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    OMA_LPPe_ver1_1_CipherSet._cont = ASN1Dict([
        (u'cipherSetID', _OMA_LPPe_ver1_1_CipherSet_cipherSetID),
        (u'cipherKey', _OMA_LPPe_ver1_1_CipherSet_cipherKey),
        (u'c0', _OMA_LPPe_ver1_1_CipherSet_c0),
        ])
    OMA_LPPe_ver1_1_CipherSet._ext = []
    
    #-----< OMA-LPPe-ver1-1-ServerID >-----#
    OMA_LPPe_ver1_1_ServerID = SEQ(name=u'OMA-LPPe-ver1-1-ServerID', mode=MODE_TYPE)
    _OMA_LPPe_ver1_1_ServerID_provider_ID = CHOICE(name=u'provider-ID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-VendorOrOperatorID')))
    _OMA_LPPe_ver1_1_ServerID_server_ID = OCT_STR(name=u'server-ID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_ver1_1_ServerID_server_ID._const_sz = ASN1Set(rv=[4], rr=[], ev=None, er=[])
    OMA_LPPe_ver1_1_ServerID._cont = ASN1Dict([
        (u'provider-ID', _OMA_LPPe_ver1_1_ServerID_provider_ID),
        (u'server-ID', _OMA_LPPe_ver1_1_ServerID_server_ID),
        ])
    OMA_LPPe_ver1_1_ServerID._ext = []
    
    #-----< OMA-LPPe-ValidityArea >-----#
    OMA_LPPe_ValidityArea = SEQ(name=u'OMA-LPPe-ValidityArea', mode=MODE_TYPE)
    _OMA_LPPe_ValidityArea_regionSizeInv = INT(name=u'regionSizeInv', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_ValidityArea_regionSizeInv._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=255)], ev=None, er=[])
    _OMA_LPPe_ValidityArea_areaWidth = INT(name=u'areaWidth', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_ValidityArea_areaWidth._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=2, ub=9180)], ev=None, er=[])
    _OMA_LPPe_ValidityArea_codedLatOfNWCorner = INT(name=u'codedLatOfNWCorner', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_ValidityArea_codedLatOfNWCorner._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4589)], ev=None, er=[])
    _OMA_LPPe_ValidityArea_codedLonOfNWCorner = INT(name=u'codedLonOfNWCorner', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_ValidityArea_codedLonOfNWCorner._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=9179)], ev=None, er=[])
    _OMA_LPPe_ValidityArea_rleList = SEQ_OF(name=u'rleList', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-RleList')), opt=True)
    OMA_LPPe_ValidityArea._cont = ASN1Dict([
        (u'regionSizeInv', _OMA_LPPe_ValidityArea_regionSizeInv),
        (u'areaWidth', _OMA_LPPe_ValidityArea_areaWidth),
        (u'codedLatOfNWCorner', _OMA_LPPe_ValidityArea_codedLatOfNWCorner),
        (u'codedLonOfNWCorner', _OMA_LPPe_ValidityArea_codedLonOfNWCorner),
        (u'rleList', _OMA_LPPe_ValidityArea_rleList),
        ])
    OMA_LPPe_ValidityArea._ext = []
    
    #-----< OMA-LPPe-RleList >-----#
    OMA_LPPe_RleList = SEQ_OF(name=u'OMA-LPPe-RleList', mode=MODE_TYPE)
    _OMA_LPPe_RleList__item_ = INT(name='_item_', mode=MODE_TYPE)
    _OMA_LPPe_RleList__item_._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    OMA_LPPe_RleList._cont = _OMA_LPPe_RleList__item_
    OMA_LPPe_RleList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    
    #-----< OMA-LPPe-ValidityPeriod >-----#
    OMA_LPPe_ValidityPeriod = SEQ(name=u'OMA-LPPe-ValidityPeriod', mode=MODE_TYPE)
    _OMA_LPPe_ValidityPeriod_beginTime = SEQ(name=u'beginTime', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-SystemTime')))
    _OMA_LPPe_ValidityPeriod_beginTimeAlt = INT(name=u'beginTimeAlt', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_ValidityPeriod_beginTimeAlt._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=2881)], ev=None, er=[])
    _OMA_LPPe_ValidityPeriod_duration = INT(name=u'duration', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_ValidityPeriod_duration._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=2881)], ev=None, er=[])
    OMA_LPPe_ValidityPeriod._cont = ASN1Dict([
        (u'beginTime', _OMA_LPPe_ValidityPeriod_beginTime),
        (u'beginTimeAlt', _OMA_LPPe_ValidityPeriod_beginTimeAlt),
        (u'duration', _OMA_LPPe_ValidityPeriod_duration),
        ])
    OMA_LPPe_ValidityPeriod._ext = []
    
    #-----< OMA-LPPe-VendorOrOperatorAssistanceDataIdentifier >-----#
    OMA_LPPe_VendorOrOperatorAssistanceDataIdentifier = SEQ(name=u'OMA-LPPe-VendorOrOperatorAssistanceDataIdentifier', mode=MODE_TYPE)
    _OMA_LPPe_VendorOrOperatorAssistanceDataIdentifier_vendorOrOperatorID = CHOICE(name=u'vendorOrOperatorID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-VendorOrOperatorID')))
    _OMA_LPPe_VendorOrOperatorAssistanceDataIdentifier_assistanceDataID = SEQ(name=u'assistanceDataID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AssistanceContainerID')))
    OMA_LPPe_VendorOrOperatorAssistanceDataIdentifier._cont = ASN1Dict([
        (u'vendorOrOperatorID', _OMA_LPPe_VendorOrOperatorAssistanceDataIdentifier_vendorOrOperatorID),
        (u'assistanceDataID', _OMA_LPPe_VendorOrOperatorAssistanceDataIdentifier_assistanceDataID),
        ])
    OMA_LPPe_VendorOrOperatorAssistanceDataIdentifier._ext = []
    
    #-----< OMA-LPPe-VendorOrOperatorID >-----#
    OMA_LPPe_VendorOrOperatorID = CHOICE(name=u'OMA-LPPe-VendorOrOperatorID', mode=MODE_TYPE)
    _OMA_LPPe_VendorOrOperatorID_standard_VendorOrOperatorID = INT(name=u'standard-VendorOrOperatorID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_VendorOrOperatorID_standard_VendorOrOperatorID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=1024)], ev=None, er=[])
    _OMA_LPPe_VendorOrOperatorID_nonStandard_VendorOrOperatorID = SEQ(name=u'nonStandard-VendorOrOperatorID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-NonStandard-VendorOrOperatorID')))
    OMA_LPPe_VendorOrOperatorID._cont = ASN1Dict([
        (u'standard-VendorOrOperatorID', _OMA_LPPe_VendorOrOperatorID_standard_VendorOrOperatorID),
        (u'nonStandard-VendorOrOperatorID', _OMA_LPPe_VendorOrOperatorID_nonStandard_VendorOrOperatorID),
        ])
    OMA_LPPe_VendorOrOperatorID._ext = []
    
    #-----< OMA-LPPe-NonStandard-VendorOrOperatorID >-----#
    OMA_LPPe_NonStandard_VendorOrOperatorID = SEQ(name=u'OMA-LPPe-NonStandard-VendorOrOperatorID', mode=MODE_TYPE)
    _OMA_LPPe_NonStandard_VendorOrOperatorID_encodedID = INT(name=u'encodedID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_NonStandard_VendorOrOperatorID_encodedID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    _OMA_LPPe_NonStandard_VendorOrOperatorID_visibleIdentification = STR_VIS(name=u'visibleIdentification', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-CharArray')), opt=True)
    _OMA_LPPe_NonStandard_VendorOrOperatorID_visibleIdentification._const_alpha = ASN1Set(rv=[u'.', u'-'], rr=[ASN1RangeStr(lb=u'a', ub=u'z'), ASN1RangeStr(lb=u'A', ub=u'Z'), ASN1RangeStr(lb=u'0', ub=u'9')], ev=None, er=[])
    OMA_LPPe_NonStandard_VendorOrOperatorID._cont = ASN1Dict([
        (u'encodedID', _OMA_LPPe_NonStandard_VendorOrOperatorID_encodedID),
        (u'visibleIdentification', _OMA_LPPe_NonStandard_VendorOrOperatorID_visibleIdentification),
        ])
    OMA_LPPe_NonStandard_VendorOrOperatorID._ext = []
    
    #-----< OMA-LPPe-WirelessAccessTypes >-----#
    OMA_LPPe_WirelessAccessTypes = BIT_STR(name=u'OMA-LPPe-WirelessAccessTypes', mode=MODE_TYPE)
    OMA_LPPe_WirelessAccessTypes._cont = ASN1Dict([(u'gsm', 0), (u'utra', 1), (u'lte', 2), (u'wimax', 3), (u'wifi', 4), (u'other', 5)])
    OMA_LPPe_WirelessAccessTypes._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    
    #-----< OMA-LPPe-WLAN-AP-ID >-----#
    OMA_LPPe_WLAN_AP_ID = SEQ(name=u'OMA-LPPe-WLAN-AP-ID', mode=MODE_TYPE)
    _OMA_LPPe_WLAN_AP_ID_apMacAddress = BIT_STR(name=u'apMacAddress', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_WLAN_AP_ID_apMacAddress._const_sz = ASN1Set(rv=[48], rr=[], ev=None, er=[])
    OMA_LPPe_WLAN_AP_ID._cont = ASN1Dict([
        (u'apMacAddress', _OMA_LPPe_WLAN_AP_ID_apMacAddress),
        ])
    OMA_LPPe_WLAN_AP_ID._ext = []
    
    #-----< OMA-LPPe-WLAN-AP-Type >-----#
    OMA_LPPe_WLAN_AP_Type = ENUM(name=u'OMA-LPPe-WLAN-AP-Type', mode=MODE_TYPE)
    OMA_LPPe_WLAN_AP_Type._cont = ASN1Dict([(u'ieee802-11a', 0), (u'ieee802-11b', 1), (u'ieee802-11g', 2), (u'ieee802-11n', 3), (u'ieee802-11ac', 4), (u'ieee802-11ad', 5)])
    OMA_LPPe_WLAN_AP_Type._ext = [u'ieee802-11ac', u'ieee802-11ad']
    
    #-----< OMA-LPPe-WLAN-AP-Type-List >-----#
    OMA_LPPe_WLAN_AP_Type_List = BIT_STR(name=u'OMA-LPPe-WLAN-AP-Type-List', mode=MODE_TYPE)
    OMA_LPPe_WLAN_AP_Type_List._cont = ASN1Dict([(u'ieee802-11a', 0), (u'ieee802-11b', 1), (u'ieee802-11g', 2), (u'ieee802-11n', 3), (u'ieee802-11ac', 4), (u'ieee802-11ad', 5)])
    OMA_LPPe_WLAN_AP_Type_List._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    
    #-----< OMA-LPPe-WLANFemtoCoverageArea >-----#
    OMA_LPPe_WLANFemtoCoverageArea = SEQ(name=u'OMA-LPPe-WLANFemtoCoverageArea', mode=MODE_TYPE)
    _OMA_LPPe_WLANFemtoCoverageArea_truncation = INT(name=u'truncation', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_WLANFemtoCoverageArea_truncation._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-127, ub=128)], ev=None, er=[])
    _OMA_LPPe_WLANFemtoCoverageArea_areaType = ENUM(name=u'areaType', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_WLANFemtoCoverageArea_areaType._cont = ASN1Dict([(u'gaussian', 0), (u'binaryDistribution', 1)])
    _OMA_LPPe_WLANFemtoCoverageArea_areaType._ext = []
    _OMA_LPPe_WLANFemtoCoverageArea_confidence = INT(name=u'confidence', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_WLANFemtoCoverageArea_confidence._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=99)], ev=None, er=[])
    _OMA_LPPe_WLANFemtoCoverageArea_componentList = SEQ_OF(name=u'componentList', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_WLANFemtoCoverageArea_componentList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-WLANFemtoCoverageAreaElement')))
    _OMA_LPPe_WLANFemtoCoverageArea_componentList._cont = __OMA_LPPe_WLANFemtoCoverageArea_componentList__item_
    _OMA_LPPe_WLANFemtoCoverageArea_componentList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    OMA_LPPe_WLANFemtoCoverageArea._cont = ASN1Dict([
        (u'truncation', _OMA_LPPe_WLANFemtoCoverageArea_truncation),
        (u'areaType', _OMA_LPPe_WLANFemtoCoverageArea_areaType),
        (u'confidence', _OMA_LPPe_WLANFemtoCoverageArea_confidence),
        (u'componentList', _OMA_LPPe_WLANFemtoCoverageArea_componentList),
        ])
    OMA_LPPe_WLANFemtoCoverageArea._ext = []
    
    #-----< OMA-LPPe-WLANFemtoCoverageAreaElement >-----#
    OMA_LPPe_WLANFemtoCoverageAreaElement = SEQ(name=u'OMA-LPPe-WLANFemtoCoverageAreaElement', mode=MODE_TYPE)
    _OMA_LPPe_WLANFemtoCoverageAreaElement_refPointAndArea = SEQ(name=u'refPointAndArea', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_WLANFemtoCoverageAreaElement_refPointAndArea_referenceLocation = ENUM(name=u'referenceLocation', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_WLANFemtoCoverageAreaElement_refPointAndArea_referenceLocation._cont = ASN1Dict([(u'antenna', 0), (u'referencePoint', 1)])
    __OMA_LPPe_WLANFemtoCoverageAreaElement_refPointAndArea_referenceLocation._ext = []
    __OMA_LPPe_WLANFemtoCoverageAreaElement_refPointAndArea_referencePoint = SEQ(name=u'referencePoint', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ReferencePointUniqueID')), opt=True)
    __OMA_LPPe_WLANFemtoCoverageAreaElement_refPointAndArea_locationAndArea = SEQ(name=u'locationAndArea', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-RelativeLocation')))
    _OMA_LPPe_WLANFemtoCoverageAreaElement_refPointAndArea._cont = ASN1Dict([
        (u'referenceLocation', __OMA_LPPe_WLANFemtoCoverageAreaElement_refPointAndArea_referenceLocation),
        (u'referencePoint', __OMA_LPPe_WLANFemtoCoverageAreaElement_refPointAndArea_referencePoint),
        (u'locationAndArea', __OMA_LPPe_WLANFemtoCoverageAreaElement_refPointAndArea_locationAndArea),
        ])
    _OMA_LPPe_WLANFemtoCoverageAreaElement_refPointAndArea._ext = []
    _OMA_LPPe_WLANFemtoCoverageAreaElement_type = ENUM(name=u'type', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_WLANFemtoCoverageAreaElement_type._cont = ASN1Dict([(u'indoor', 0), (u'outdoor', 1), (u'mixed', 2)])
    _OMA_LPPe_WLANFemtoCoverageAreaElement_type._ext = []
    _OMA_LPPe_WLANFemtoCoverageAreaElement_weight = INT(name=u'weight', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_WLANFemtoCoverageAreaElement_weight._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=100)], ev=None, er=[])
    OMA_LPPe_WLANFemtoCoverageAreaElement._cont = ASN1Dict([
        (u'refPointAndArea', _OMA_LPPe_WLANFemtoCoverageAreaElement_refPointAndArea),
        (u'type', _OMA_LPPe_WLANFemtoCoverageAreaElement_type),
        (u'weight', _OMA_LPPe_WLANFemtoCoverageAreaElement_weight),
        ])
    OMA_LPPe_WLANFemtoCoverageAreaElement._ext = []
    
    #-----< OMA-LPPe-CommonIEsRequestCapabilities >-----#
    OMA_LPPe_CommonIEsRequestCapabilities = SEQ(name=u'OMA-LPPe-CommonIEsRequestCapabilities', mode=MODE_TYPE)
    _OMA_LPPe_CommonIEsRequestCapabilities_iP_Address_RequestCapabilities = SEQ(name=u'iP-Address-RequestCapabilities', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-IP-Address-RequestCapabilities')), opt=True)
    _OMA_LPPe_CommonIEsRequestCapabilities_assistanceContainerSupportReq = SEQ(name=u'assistanceContainerSupportReq', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AssistanceContainerSupportReq')), opt=True)
    _OMA_LPPe_CommonIEsRequestCapabilities_locationInformationContainerSupportReq = SEQ(name=u'locationInformationContainerSupportReq', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-LocationInformationContainerSupportReq')), opt=True)
    _OMA_LPPe_CommonIEsRequestCapabilities_relativeLocationChange_RequestCapabilities = SEQ(name=u'relativeLocationChange-RequestCapabilities', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-RelativeLocationChange-RequestCapabilities')), opt=True)
    _OMA_LPPe_CommonIEsRequestCapabilities_highAccuracyFormatCapabilitiesReq = SEQ(name=u'highAccuracyFormatCapabilitiesReq', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-HighAccuracyFormatCapabilitiesReq')), opt=True)
    _OMA_LPPe_CommonIEsRequestCapabilities_segmentedAssistanceData_ReqCapabilities = SEQ(name=u'segmentedAssistanceData-ReqCapabilities', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-SegmentedAssistanceData-ReqCapabilities')), opt=True)
    _OMA_LPPe_CommonIEsRequestCapabilities_referencePointCapabilitiesReq = SEQ(name=u'referencePointCapabilitiesReq', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ReferencePointCapabilitiesReq')), opt=True)
    _OMA_LPPe_CommonIEsRequestCapabilities_scheduledLocation_RequestCapabilities = SEQ(name=u'scheduledLocation-RequestCapabilities', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ScheduledLocation-RequestCapabilities')), opt=True)
    _OMA_LPPe_CommonIEsRequestCapabilities_accessCapabilitiesReq = SEQ(name=u'accessCapabilitiesReq', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AccessCapabilitiesReq')), opt=True)
    _OMA_LPPe_CommonIEsRequestCapabilities_segmentedLocationInformation_ReqCapabilities = SEQ(name=u'segmentedLocationInformation-ReqCapabilities', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-SegmentedLocationInformation-ReqCapabilities')), opt=True)
    _OMA_LPPe_CommonIEsRequestCapabilities_ver1_1_localCellInformation_ReqCapabilities = SEQ(name=u'ver1-1-localCellInformation-ReqCapabilities', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-localCellInformation-ReqCapabilities')), opt=True)
    _OMA_LPPe_CommonIEsRequestCapabilities_ver1_1_broadcast_ReqCapabilities = SEQ(name=u'ver1-1-broadcast-ReqCapabilities', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-broadcast-ReqCapabilities')), opt=True)
    OMA_LPPe_CommonIEsRequestCapabilities._cont = ASN1Dict([
        (u'iP-Address-RequestCapabilities', _OMA_LPPe_CommonIEsRequestCapabilities_iP_Address_RequestCapabilities),
        (u'assistanceContainerSupportReq', _OMA_LPPe_CommonIEsRequestCapabilities_assistanceContainerSupportReq),
        (u'locationInformationContainerSupportReq', _OMA_LPPe_CommonIEsRequestCapabilities_locationInformationContainerSupportReq),
        (u'relativeLocationChange-RequestCapabilities', _OMA_LPPe_CommonIEsRequestCapabilities_relativeLocationChange_RequestCapabilities),
        (u'highAccuracyFormatCapabilitiesReq', _OMA_LPPe_CommonIEsRequestCapabilities_highAccuracyFormatCapabilitiesReq),
        (u'segmentedAssistanceData-ReqCapabilities', _OMA_LPPe_CommonIEsRequestCapabilities_segmentedAssistanceData_ReqCapabilities),
        (u'referencePointCapabilitiesReq', _OMA_LPPe_CommonIEsRequestCapabilities_referencePointCapabilitiesReq),
        (u'scheduledLocation-RequestCapabilities', _OMA_LPPe_CommonIEsRequestCapabilities_scheduledLocation_RequestCapabilities),
        (u'accessCapabilitiesReq', _OMA_LPPe_CommonIEsRequestCapabilities_accessCapabilitiesReq),
        (u'segmentedLocationInformation-ReqCapabilities', _OMA_LPPe_CommonIEsRequestCapabilities_segmentedLocationInformation_ReqCapabilities),
        (u'ver1-1-localCellInformation-ReqCapabilities', _OMA_LPPe_CommonIEsRequestCapabilities_ver1_1_localCellInformation_ReqCapabilities),
        (u'ver1-1-broadcast-ReqCapabilities', _OMA_LPPe_CommonIEsRequestCapabilities_ver1_1_broadcast_ReqCapabilities),
        ])
    OMA_LPPe_CommonIEsRequestCapabilities._ext = [u'ver1-1-localCellInformation-ReqCapabilities', u'ver1-1-broadcast-ReqCapabilities']
    
    #-----< OMA-LPPe-IP-Address-RequestCapabilities >-----#
    OMA_LPPe_IP_Address_RequestCapabilities = SEQ(name=u'OMA-LPPe-IP-Address-RequestCapabilities', mode=MODE_TYPE)
    OMA_LPPe_IP_Address_RequestCapabilities._cont = ASN1Dict([
        ])
    OMA_LPPe_IP_Address_RequestCapabilities._ext = []
    
    #-----< OMA-LPPe-AssistanceContainerSupportReq >-----#
    OMA_LPPe_AssistanceContainerSupportReq = SEQ(name=u'OMA-LPPe-AssistanceContainerSupportReq', mode=MODE_TYPE)
    _OMA_LPPe_AssistanceContainerSupportReq_vendorOrOperatorIDList = SEQ_OF(name=u'vendorOrOperatorIDList', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-VendorOrOperatorIDList')), opt=True)
    OMA_LPPe_AssistanceContainerSupportReq._cont = ASN1Dict([
        (u'vendorOrOperatorIDList', _OMA_LPPe_AssistanceContainerSupportReq_vendorOrOperatorIDList),
        ])
    OMA_LPPe_AssistanceContainerSupportReq._ext = []
    
    #-----< OMA-LPPe-LocationInformationContainerSupportReq >-----#
    OMA_LPPe_LocationInformationContainerSupportReq = SEQ(name=u'OMA-LPPe-LocationInformationContainerSupportReq', mode=MODE_TYPE)
    _OMA_LPPe_LocationInformationContainerSupportReq_vendorOrOperatorIDList = SEQ_OF(name=u'vendorOrOperatorIDList', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-VendorOrOperatorIDList')), opt=True)
    OMA_LPPe_LocationInformationContainerSupportReq._cont = ASN1Dict([
        (u'vendorOrOperatorIDList', _OMA_LPPe_LocationInformationContainerSupportReq_vendorOrOperatorIDList),
        ])
    OMA_LPPe_LocationInformationContainerSupportReq._ext = []
    
    #-----< OMA-LPPe-VendorOrOperatorIDList >-----#
    OMA_LPPe_VendorOrOperatorIDList = SEQ_OF(name=u'OMA-LPPe-VendorOrOperatorIDList', mode=MODE_TYPE)
    _OMA_LPPe_VendorOrOperatorIDList__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-VendorOrOperatorID')))
    OMA_LPPe_VendorOrOperatorIDList._cont = _OMA_LPPe_VendorOrOperatorIDList__item_
    OMA_LPPe_VendorOrOperatorIDList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    
    #-----< maxVendorOrOperatorIDList >-----#
    maxVendorOrOperatorIDList = INT(name=u'maxVendorOrOperatorIDList', mode=MODE_VALUE)
    maxVendorOrOperatorIDList._val = 32
    
    #-----< OMA-LPPe-RelativeLocationChange-RequestCapabilities >-----#
    OMA_LPPe_RelativeLocationChange_RequestCapabilities = SEQ(name=u'OMA-LPPe-RelativeLocationChange-RequestCapabilities', mode=MODE_TYPE)
    OMA_LPPe_RelativeLocationChange_RequestCapabilities._cont = ASN1Dict([
        ])
    OMA_LPPe_RelativeLocationChange_RequestCapabilities._ext = []
    
    #-----< OMA-LPPe-HighAccuracyFormatCapabilitiesReq >-----#
    OMA_LPPe_HighAccuracyFormatCapabilitiesReq = SEQ(name=u'OMA-LPPe-HighAccuracyFormatCapabilitiesReq', mode=MODE_TYPE)
    OMA_LPPe_HighAccuracyFormatCapabilitiesReq._cont = ASN1Dict([
        ])
    OMA_LPPe_HighAccuracyFormatCapabilitiesReq._ext = []
    
    #-----< OMA-LPPe-SegmentedAssistanceData-ReqCapabilities >-----#
    OMA_LPPe_SegmentedAssistanceData_ReqCapabilities = SEQ(name=u'OMA-LPPe-SegmentedAssistanceData-ReqCapabilities', mode=MODE_TYPE)
    OMA_LPPe_SegmentedAssistanceData_ReqCapabilities._cont = ASN1Dict([
        ])
    OMA_LPPe_SegmentedAssistanceData_ReqCapabilities._ext = []
    
    #-----< OMA-LPPe-ReferencePointCapabilitiesReq >-----#
    OMA_LPPe_ReferencePointCapabilitiesReq = SEQ(name=u'OMA-LPPe-ReferencePointCapabilitiesReq', mode=MODE_TYPE)
    _OMA_LPPe_ReferencePointCapabilitiesReq_referencePointProviderSupportListReq = SEQ_OF(name=u'referencePointProviderSupportListReq', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OMA_LPPe_ReferencePointCapabilitiesReq_referencePointProviderSupportListReq__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-VendorOrOperatorID')))
    _OMA_LPPe_ReferencePointCapabilitiesReq_referencePointProviderSupportListReq._cont = __OMA_LPPe_ReferencePointCapabilitiesReq_referencePointProviderSupportListReq__item_
    _OMA_LPPe_ReferencePointCapabilitiesReq_referencePointProviderSupportListReq._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    OMA_LPPe_ReferencePointCapabilitiesReq._cont = ASN1Dict([
        (u'referencePointProviderSupportListReq', _OMA_LPPe_ReferencePointCapabilitiesReq_referencePointProviderSupportListReq),
        ])
    OMA_LPPe_ReferencePointCapabilitiesReq._ext = []
    
    #-----< OMA-LPPe-ScheduledLocation-RequestCapabilities >-----#
    OMA_LPPe_ScheduledLocation_RequestCapabilities = SEQ(name=u'OMA-LPPe-ScheduledLocation-RequestCapabilities', mode=MODE_TYPE)
    OMA_LPPe_ScheduledLocation_RequestCapabilities._cont = ASN1Dict([
        ])
    OMA_LPPe_ScheduledLocation_RequestCapabilities._ext = []
    
    #-----< OMA-LPPe-AccessCapabilitiesReq >-----#
    OMA_LPPe_AccessCapabilitiesReq = SEQ(name=u'OMA-LPPe-AccessCapabilitiesReq', mode=MODE_TYPE)
    OMA_LPPe_AccessCapabilitiesReq._cont = ASN1Dict([
        ])
    OMA_LPPe_AccessCapabilitiesReq._ext = []
    
    #-----< OMA-LPPe-SegmentedLocationInformation-ReqCapabilities >-----#
    OMA_LPPe_SegmentedLocationInformation_ReqCapabilities = SEQ(name=u'OMA-LPPe-SegmentedLocationInformation-ReqCapabilities', mode=MODE_TYPE)
    OMA_LPPe_SegmentedLocationInformation_ReqCapabilities._cont = ASN1Dict([
        ])
    OMA_LPPe_SegmentedLocationInformation_ReqCapabilities._ext = []
    
    #-----< OMA-LPPe-ver1-1-localCellInformation-ReqCapabilities >-----#
    OMA_LPPe_ver1_1_localCellInformation_ReqCapabilities = SEQ(name=u'OMA-LPPe-ver1-1-localCellInformation-ReqCapabilities', mode=MODE_TYPE)
    OMA_LPPe_ver1_1_localCellInformation_ReqCapabilities._cont = ASN1Dict([
        ])
    OMA_LPPe_ver1_1_localCellInformation_ReqCapabilities._ext = []
    
    #-----< OMA-LPPe-ver1-1-broadcast-ReqCapabilities >-----#
    OMA_LPPe_ver1_1_broadcast_ReqCapabilities = SEQ(name=u'OMA-LPPe-ver1-1-broadcast-ReqCapabilities', mode=MODE_TYPE)
    _OMA_LPPe_ver1_1_broadcast_ReqCapabilities_broadcastSystems = SEQ_OF(name=u'broadcastSystems', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OMA_LPPe_ver1_1_broadcast_ReqCapabilities_broadcastSystems__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-BroadcastSystemID')))
    _OMA_LPPe_ver1_1_broadcast_ReqCapabilities_broadcastSystems._cont = __OMA_LPPe_ver1_1_broadcast_ReqCapabilities_broadcastSystems__item_
    _OMA_LPPe_ver1_1_broadcast_ReqCapabilities_broadcastSystems._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    OMA_LPPe_ver1_1_broadcast_ReqCapabilities._cont = ASN1Dict([
        (u'broadcastSystems', _OMA_LPPe_ver1_1_broadcast_ReqCapabilities_broadcastSystems),
        ])
    OMA_LPPe_ver1_1_broadcast_ReqCapabilities._ext = []
    
    #-----< OMA-LPPe-CommonIEsProvideCapabilities >-----#
    OMA_LPPe_CommonIEsProvideCapabilities = SEQ(name=u'OMA-LPPe-CommonIEsProvideCapabilities', mode=MODE_TYPE)
    _OMA_LPPe_CommonIEsProvideCapabilities_iP_Address_Capabilities = SEQ(name=u'iP-Address-Capabilities', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-IP-Address-Capabilities')), opt=True)
    _OMA_LPPe_CommonIEsProvideCapabilities_assistanceContainerSupport = SEQ_OF(name=u'assistanceContainerSupport', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AssistanceContainerSupport')), opt=True)
    _OMA_LPPe_CommonIEsProvideCapabilities_locationInformationContainerSupport = SEQ_OF(name=u'locationInformationContainerSupport', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-LocationInformationContainerSupport')), opt=True)
    _OMA_LPPe_CommonIEsProvideCapabilities_relativeLocationChange_Capabilities = SEQ(name=u'relativeLocationChange-Capabilities', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-RelativeLocationChange-Capabilities')), opt=True)
    _OMA_LPPe_CommonIEsProvideCapabilities_highAccuracyFormatCapabilities = BIT_STR(name=u'highAccuracyFormatCapabilities', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-HighAccuracyFormatCapabilities')), opt=True)
    _OMA_LPPe_CommonIEsProvideCapabilities_segmentedAssistanceData_ProvideCapabs = SEQ(name=u'segmentedAssistanceData-ProvideCapabs', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-SegmentedAssistanceData-ProvideCapabs')), opt=True)
    _OMA_LPPe_CommonIEsProvideCapabilities_referencePointCapabilities = SEQ(name=u'referencePointCapabilities', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ReferencePointCapabilities')), opt=True)
    _OMA_LPPe_CommonIEsProvideCapabilities_scheduledLocation_Capabilities = SEQ(name=u'scheduledLocation-Capabilities', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ScheduledLocation-Capabilities')), opt=True)
    _OMA_LPPe_CommonIEsProvideCapabilities_accessCapabilities = SEQ(name=u'accessCapabilities', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AccessCapabilities')), opt=True)
    _OMA_LPPe_CommonIEsProvideCapabilities_segmentedLocationInformation_ProvideCapabs = SEQ(name=u'segmentedLocationInformation-ProvideCapabs', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-SegmentedLocationInformation-ProvideCapabs')), opt=True)
    _OMA_LPPe_CommonIEsProvideCapabilities_ver1_1_localCellInformation_ProvideCapabilities = SEQ(name=u'ver1-1-localCellInformation-ProvideCapabilities', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-localCellInformation-ProvideCapabilities')), opt=True)
    _OMA_LPPe_CommonIEsProvideCapabilities_ver1_1_broadcast_ProvideCapabilities = SEQ_OF(name=u'ver1-1-broadcast-ProvideCapabilities', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-broadcast-ProvideCapabilities')), opt=True)
    OMA_LPPe_CommonIEsProvideCapabilities._cont = ASN1Dict([
        (u'iP-Address-Capabilities', _OMA_LPPe_CommonIEsProvideCapabilities_iP_Address_Capabilities),
        (u'assistanceContainerSupport', _OMA_LPPe_CommonIEsProvideCapabilities_assistanceContainerSupport),
        (u'locationInformationContainerSupport', _OMA_LPPe_CommonIEsProvideCapabilities_locationInformationContainerSupport),
        (u'relativeLocationChange-Capabilities', _OMA_LPPe_CommonIEsProvideCapabilities_relativeLocationChange_Capabilities),
        (u'highAccuracyFormatCapabilities', _OMA_LPPe_CommonIEsProvideCapabilities_highAccuracyFormatCapabilities),
        (u'segmentedAssistanceData-ProvideCapabs', _OMA_LPPe_CommonIEsProvideCapabilities_segmentedAssistanceData_ProvideCapabs),
        (u'referencePointCapabilities', _OMA_LPPe_CommonIEsProvideCapabilities_referencePointCapabilities),
        (u'scheduledLocation-Capabilities', _OMA_LPPe_CommonIEsProvideCapabilities_scheduledLocation_Capabilities),
        (u'accessCapabilities', _OMA_LPPe_CommonIEsProvideCapabilities_accessCapabilities),
        (u'segmentedLocationInformation-ProvideCapabs', _OMA_LPPe_CommonIEsProvideCapabilities_segmentedLocationInformation_ProvideCapabs),
        (u'ver1-1-localCellInformation-ProvideCapabilities', _OMA_LPPe_CommonIEsProvideCapabilities_ver1_1_localCellInformation_ProvideCapabilities),
        (u'ver1-1-broadcast-ProvideCapabilities', _OMA_LPPe_CommonIEsProvideCapabilities_ver1_1_broadcast_ProvideCapabilities),
        ])
    OMA_LPPe_CommonIEsProvideCapabilities._ext = [u'ver1-1-localCellInformation-ProvideCapabilities', u'ver1-1-broadcast-ProvideCapabilities']
    
    #-----< OMA-LPPe-IP-Address-Capabilities >-----#
    OMA_LPPe_IP_Address_Capabilities = SEQ(name=u'OMA-LPPe-IP-Address-Capabilities', mode=MODE_TYPE)
    _OMA_LPPe_IP_Address_Capabilities_iP_Address_support = BIT_STR(name=u'iP-Address-support', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_IP_Address_Capabilities_iP_Address_support._cont = ASN1Dict([(u'iPv4', 0), (u'iPv6', 1), (u'nat', 2)])
    _OMA_LPPe_IP_Address_Capabilities_iP_Address_support._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    OMA_LPPe_IP_Address_Capabilities._cont = ASN1Dict([
        (u'iP-Address-support', _OMA_LPPe_IP_Address_Capabilities_iP_Address_support),
        ])
    OMA_LPPe_IP_Address_Capabilities._ext = []
    
    #-----< OMA-LPPe-AssistanceContainerSupport >-----#
    OMA_LPPe_AssistanceContainerSupport = SEQ_OF(name=u'OMA-LPPe-AssistanceContainerSupport', mode=MODE_TYPE)
    _OMA_LPPe_AssistanceContainerSupport__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-VendorOrOperatorAssistanceContainerList')))
    OMA_LPPe_AssistanceContainerSupport._cont = _OMA_LPPe_AssistanceContainerSupport__item_
    OMA_LPPe_AssistanceContainerSupport._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    
    #-----< OMA-LPPe-VendorOrOperatorAssistanceContainerList >-----#
    OMA_LPPe_VendorOrOperatorAssistanceContainerList = SEQ(name=u'OMA-LPPe-VendorOrOperatorAssistanceContainerList', mode=MODE_TYPE)
    _OMA_LPPe_VendorOrOperatorAssistanceContainerList_vendorOrOperatorID = CHOICE(name=u'vendorOrOperatorID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-VendorOrOperatorID')))
    _OMA_LPPe_VendorOrOperatorAssistanceContainerList_assistanceContainerList = SEQ_OF(name=u'assistanceContainerList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AssistanceContainerList')))
    OMA_LPPe_VendorOrOperatorAssistanceContainerList._cont = ASN1Dict([
        (u'vendorOrOperatorID', _OMA_LPPe_VendorOrOperatorAssistanceContainerList_vendorOrOperatorID),
        (u'assistanceContainerList', _OMA_LPPe_VendorOrOperatorAssistanceContainerList_assistanceContainerList),
        ])
    OMA_LPPe_VendorOrOperatorAssistanceContainerList._ext = []
    
    #-----< OMA-LPPe-AssistanceContainerList >-----#
    OMA_LPPe_AssistanceContainerList = SEQ_OF(name=u'OMA-LPPe-AssistanceContainerList', mode=MODE_TYPE)
    _OMA_LPPe_AssistanceContainerList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AssistanceContainerID')))
    OMA_LPPe_AssistanceContainerList._cont = _OMA_LPPe_AssistanceContainerList__item_
    OMA_LPPe_AssistanceContainerList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    
    #-----< OMA-LPPe-LocationInformationContainerSupport >-----#
    OMA_LPPe_LocationInformationContainerSupport = SEQ_OF(name=u'OMA-LPPe-LocationInformationContainerSupport', mode=MODE_TYPE)
    _OMA_LPPe_LocationInformationContainerSupport__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-VendorOrOperatorLocationInformationContainerList')))
    OMA_LPPe_LocationInformationContainerSupport._cont = _OMA_LPPe_LocationInformationContainerSupport__item_
    OMA_LPPe_LocationInformationContainerSupport._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    
    #-----< OMA-LPPe-VendorOrOperatorLocationInformationContainerList >-----#
    OMA_LPPe_VendorOrOperatorLocationInformationContainerList = SEQ(name=u'OMA-LPPe-VendorOrOperatorLocationInformationContainerList', mode=MODE_TYPE)
    _OMA_LPPe_VendorOrOperatorLocationInformationContainerList_vendorOrOperatorID = CHOICE(name=u'vendorOrOperatorID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-VendorOrOperatorID')))
    _OMA_LPPe_VendorOrOperatorLocationInformationContainerList_locationInformationContainerList = SEQ_OF(name=u'locationInformationContainerList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-LocationInformationContainerList')))
    OMA_LPPe_VendorOrOperatorLocationInformationContainerList._cont = ASN1Dict([
        (u'vendorOrOperatorID', _OMA_LPPe_VendorOrOperatorLocationInformationContainerList_vendorOrOperatorID),
        (u'locationInformationContainerList', _OMA_LPPe_VendorOrOperatorLocationInformationContainerList_locationInformationContainerList),
        ])
    OMA_LPPe_VendorOrOperatorLocationInformationContainerList._ext = []
    
    #-----< OMA-LPPe-LocationInformationContainerList >-----#
    OMA_LPPe_LocationInformationContainerList = SEQ_OF(name=u'OMA-LPPe-LocationInformationContainerList', mode=MODE_TYPE)
    _OMA_LPPe_LocationInformationContainerList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-LocationInformationContainerID')))
    OMA_LPPe_LocationInformationContainerList._cont = _OMA_LPPe_LocationInformationContainerList__item_
    OMA_LPPe_LocationInformationContainerList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    
    #-----< maxLocationInformationContainerList >-----#
    maxLocationInformationContainerList = INT(name=u'maxLocationInformationContainerList', mode=MODE_VALUE)
    maxLocationInformationContainerList._val = 64
    
    #-----< OMA-LPPe-RelativeLocationChange-Capabilities >-----#
    OMA_LPPe_RelativeLocationChange_Capabilities = SEQ(name=u'OMA-LPPe-RelativeLocationChange-Capabilities', mode=MODE_TYPE)
    _OMA_LPPe_RelativeLocationChange_Capabilities_numberOfChanges = INT(name=u'numberOfChanges', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_RelativeLocationChange_Capabilities_numberOfChanges._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=5)], ev=None, er=[])
    OMA_LPPe_RelativeLocationChange_Capabilities._cont = ASN1Dict([
        (u'numberOfChanges', _OMA_LPPe_RelativeLocationChange_Capabilities_numberOfChanges),
        ])
    OMA_LPPe_RelativeLocationChange_Capabilities._ext = []
    
    #-----< OMA-LPPe-HighAccuracyFormatCapabilities >-----#
    OMA_LPPe_HighAccuracyFormatCapabilities = BIT_STR(name=u'OMA-LPPe-HighAccuracyFormatCapabilities', mode=MODE_TYPE)
    OMA_LPPe_HighAccuracyFormatCapabilities._cont = ASN1Dict([(u'hAposition', 0), (u'hAvelocity', 1)])
    OMA_LPPe_HighAccuracyFormatCapabilities._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    
    #-----< OMA-LPPe-SegmentedAssistanceData-ProvideCapabs >-----#
    OMA_LPPe_SegmentedAssistanceData_ProvideCapabs = SEQ(name=u'OMA-LPPe-SegmentedAssistanceData-ProvideCapabs', mode=MODE_TYPE)
    _OMA_LPPe_SegmentedAssistanceData_ProvideCapabs_maxSegments = INT(name=u'maxSegments', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_SegmentedAssistanceData_ProvideCapabs_maxSegments._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=2, ub=4096)], ev=None, er=[])
    _OMA_LPPe_SegmentedAssistanceData_ProvideCapabs_maxSize = INT(name=u'maxSize', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_SegmentedAssistanceData_ProvideCapabs_maxSize._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=5000)], ev=None, er=[])
    _OMA_LPPe_SegmentedAssistanceData_ProvideCapabs_minSize = INT(name=u'minSize', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_SegmentedAssistanceData_ProvideCapabs_minSize._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=5000)], ev=None, er=[])
    _OMA_LPPe_SegmentedAssistanceData_ProvideCapabs_resume = NULL(name=u'resume', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    OMA_LPPe_SegmentedAssistanceData_ProvideCapabs._cont = ASN1Dict([
        (u'maxSegments', _OMA_LPPe_SegmentedAssistanceData_ProvideCapabs_maxSegments),
        (u'maxSize', _OMA_LPPe_SegmentedAssistanceData_ProvideCapabs_maxSize),
        (u'minSize', _OMA_LPPe_SegmentedAssistanceData_ProvideCapabs_minSize),
        (u'resume', _OMA_LPPe_SegmentedAssistanceData_ProvideCapabs_resume),
        ])
    OMA_LPPe_SegmentedAssistanceData_ProvideCapabs._ext = []
    
    #-----< OMA-LPPe-ReferencePointCapabilities >-----#
    OMA_LPPe_ReferencePointCapabilities = SEQ(name=u'OMA-LPPe-ReferencePointCapabilities', mode=MODE_TYPE)
    _OMA_LPPe_ReferencePointCapabilities_relativeLocationReportingSupport = BIT_STR(name=u'relativeLocationReportingSupport', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_ReferencePointCapabilities_relativeLocationReportingSupport._cont = ASN1Dict([(u'geo', 0), (u'civic', 1), (u'otherProviders', 2)])
    _OMA_LPPe_ReferencePointCapabilities_relativeLocationReportingSupport._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    _OMA_LPPe_ReferencePointCapabilities_referencePointProviderSupportList = SEQ_OF(name=u'referencePointProviderSupportList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OMA_LPPe_ReferencePointCapabilities_referencePointProviderSupportList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ReferencePointProviderSupportElement')))
    _OMA_LPPe_ReferencePointCapabilities_referencePointProviderSupportList._cont = __OMA_LPPe_ReferencePointCapabilities_referencePointProviderSupportList__item_
    _OMA_LPPe_ReferencePointCapabilities_referencePointProviderSupportList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    OMA_LPPe_ReferencePointCapabilities._cont = ASN1Dict([
        (u'relativeLocationReportingSupport', _OMA_LPPe_ReferencePointCapabilities_relativeLocationReportingSupport),
        (u'referencePointProviderSupportList', _OMA_LPPe_ReferencePointCapabilities_referencePointProviderSupportList),
        ])
    OMA_LPPe_ReferencePointCapabilities._ext = []
    
    #-----< OMA-LPPe-ReferencePointProviderSupportElement >-----#
    OMA_LPPe_ReferencePointProviderSupportElement = SEQ(name=u'OMA-LPPe-ReferencePointProviderSupportElement', mode=MODE_TYPE)
    _OMA_LPPe_ReferencePointProviderSupportElement_referencePointProvider = CHOICE(name=u'referencePointProvider', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-VendorOrOperatorID')))
    _OMA_LPPe_ReferencePointProviderSupportElement_mapDataSupport = SEQ(name=u'mapDataSupport', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OMA_LPPe_ReferencePointProviderSupportElement_mapDataSupport_mapDataFormat = OCT_STR(name=u'mapDataFormat', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_ReferencePointProviderSupportElement_mapDataSupport._cont = ASN1Dict([
        (u'mapDataFormat', __OMA_LPPe_ReferencePointProviderSupportElement_mapDataSupport_mapDataFormat),
        ])
    _OMA_LPPe_ReferencePointProviderSupportElement_mapDataSupport._ext = []
    OMA_LPPe_ReferencePointProviderSupportElement._cont = ASN1Dict([
        (u'referencePointProvider', _OMA_LPPe_ReferencePointProviderSupportElement_referencePointProvider),
        (u'mapDataSupport', _OMA_LPPe_ReferencePointProviderSupportElement_mapDataSupport),
        ])
    OMA_LPPe_ReferencePointProviderSupportElement._ext = []
    
    #-----< OMA-LPPe-ScheduledLocation-Capabilities >-----#
    OMA_LPPe_ScheduledLocation_Capabilities = SEQ(name=u'OMA-LPPe-ScheduledLocation-Capabilities', mode=MODE_TYPE)
    _OMA_LPPe_ScheduledLocation_Capabilities_minimumWindow = INT(name=u'minimumWindow', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_ScheduledLocation_Capabilities_minimumWindow._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=1024)], ev=None, er=[])
    _OMA_LPPe_ScheduledLocation_Capabilities_gnssTimeReference = SEQ(name=u'gnssTimeReference', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-ID-Bitmap')), opt=True)
    _OMA_LPPe_ScheduledLocation_Capabilities_networkTimeReference = ENUM(name=u'networkTimeReference', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_ScheduledLocation_Capabilities_networkTimeReference._cont = ASN1Dict([(u'serving', 0), (u'servingOrNonServing', 1)])
    _OMA_LPPe_ScheduledLocation_Capabilities_networkTimeReference._ext = []
    OMA_LPPe_ScheduledLocation_Capabilities._cont = ASN1Dict([
        (u'minimumWindow', _OMA_LPPe_ScheduledLocation_Capabilities_minimumWindow),
        (u'gnssTimeReference', _OMA_LPPe_ScheduledLocation_Capabilities_gnssTimeReference),
        (u'networkTimeReference', _OMA_LPPe_ScheduledLocation_Capabilities_networkTimeReference),
        ])
    OMA_LPPe_ScheduledLocation_Capabilities._ext = []
    
    #-----< OMA-LPPe-AccessCapabilities >-----#
    OMA_LPPe_AccessCapabilities = SEQ(name=u'OMA-LPPe-AccessCapabilities', mode=MODE_TYPE)
    _OMA_LPPe_AccessCapabilities_accessTypeUnknown = NULL(name=u'accessTypeUnknown', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AccessCapabilities_fixedAccessTypes = BIT_STR(name=u'fixedAccessTypes', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-FixedAccessTypes')), opt=True)
    _OMA_LPPe_AccessCapabilities_wirelessAccessTypes = BIT_STR(name=u'wirelessAccessTypes', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-WirelessAccessTypes')), opt=True)
    OMA_LPPe_AccessCapabilities._cont = ASN1Dict([
        (u'accessTypeUnknown', _OMA_LPPe_AccessCapabilities_accessTypeUnknown),
        (u'fixedAccessTypes', _OMA_LPPe_AccessCapabilities_fixedAccessTypes),
        (u'wirelessAccessTypes', _OMA_LPPe_AccessCapabilities_wirelessAccessTypes),
        ])
    OMA_LPPe_AccessCapabilities._ext = []
    
    #-----< OMA-LPPe-SegmentedLocationInformation-ProvideCapabs >-----#
    OMA_LPPe_SegmentedLocationInformation_ProvideCapabs = SEQ(name=u'OMA-LPPe-SegmentedLocationInformation-ProvideCapabs', mode=MODE_TYPE)
    _OMA_LPPe_SegmentedLocationInformation_ProvideCapabs_maxSegments = INT(name=u'maxSegments', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_SegmentedLocationInformation_ProvideCapabs_maxSegments._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=2, ub=4096)], ev=None, er=[])
    _OMA_LPPe_SegmentedLocationInformation_ProvideCapabs_maxSize = INT(name=u'maxSize', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_SegmentedLocationInformation_ProvideCapabs_maxSize._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=5000)], ev=None, er=[])
    _OMA_LPPe_SegmentedLocationInformation_ProvideCapabs_minSize = INT(name=u'minSize', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_SegmentedLocationInformation_ProvideCapabs_minSize._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=5000)], ev=None, er=[])
    _OMA_LPPe_SegmentedLocationInformation_ProvideCapabs_resume = NULL(name=u'resume', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    OMA_LPPe_SegmentedLocationInformation_ProvideCapabs._cont = ASN1Dict([
        (u'maxSegments', _OMA_LPPe_SegmentedLocationInformation_ProvideCapabs_maxSegments),
        (u'maxSize', _OMA_LPPe_SegmentedLocationInformation_ProvideCapabs_maxSize),
        (u'minSize', _OMA_LPPe_SegmentedLocationInformation_ProvideCapabs_minSize),
        (u'resume', _OMA_LPPe_SegmentedLocationInformation_ProvideCapabs_resume),
        ])
    OMA_LPPe_SegmentedLocationInformation_ProvideCapabs._ext = []
    
    #-----< OMA-LPPe-ver1-1-localCellInformation-ProvideCapabilities >-----#
    OMA_LPPe_ver1_1_localCellInformation_ProvideCapabilities = SEQ(name=u'OMA-LPPe-ver1-1-localCellInformation-ProvideCapabilities', mode=MODE_TYPE)
    _OMA_LPPe_ver1_1_localCellInformation_ProvideCapabilities_localCellInformation_Support = BIT_STR(name=u'localCellInformation-Support', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_ver1_1_localCellInformation_ProvideCapabilities_localCellInformation_Support._cont = ASN1Dict([(u'gnssTiming', 0), (u'networkTiming', 1), (u'coverage', 2), (u'coordinates', 3), (u'frequencyAccuracy', 4)])
    _OMA_LPPe_ver1_1_localCellInformation_ProvideCapabilities_localCellInformation_Support._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    OMA_LPPe_ver1_1_localCellInformation_ProvideCapabilities._cont = ASN1Dict([
        (u'localCellInformation-Support', _OMA_LPPe_ver1_1_localCellInformation_ProvideCapabilities_localCellInformation_Support),
        ])
    OMA_LPPe_ver1_1_localCellInformation_ProvideCapabilities._ext = []
    
    #-----< OMA-LPPe-ver1-1-broadcast-ProvideCapabilities >-----#
    OMA_LPPe_ver1_1_broadcast_ProvideCapabilities = SEQ_OF(name=u'OMA-LPPe-ver1-1-broadcast-ProvideCapabilities', mode=MODE_TYPE)
    _OMA_LPPe_ver1_1_broadcast_ProvideCapabilities__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-BroadcastSystem-Capabs')))
    OMA_LPPe_ver1_1_broadcast_ProvideCapabilities._cont = _OMA_LPPe_ver1_1_broadcast_ProvideCapabilities__item_
    OMA_LPPe_ver1_1_broadcast_ProvideCapabilities._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    
    #-----< OMA-LPPe-ver1-1-BroadcastSystem-Capabs >-----#
    OMA_LPPe_ver1_1_BroadcastSystem_Capabs = SEQ(name=u'OMA-LPPe-ver1-1-BroadcastSystem-Capabs', mode=MODE_TYPE)
    _OMA_LPPe_ver1_1_BroadcastSystem_Capabs_broadcastSystemID = CHOICE(name=u'broadcastSystemID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-BroadcastSystemID')))
    _OMA_LPPe_ver1_1_BroadcastSystem_Capabs_broadcastADTypes = SEQ(name=u'broadcastADTypes', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-BroadcastADTypes')), opt=True)
    _OMA_LPPe_ver1_1_BroadcastSystem_Capabs_point2pointAD = SEQ(name=u'point2pointAD', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-point2pointAD')), opt=True)
    _OMA_LPPe_ver1_1_BroadcastSystem_Capabs_ciphering = SEQ(name=u'ciphering', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-Ciphering')), opt=True)
    _OMA_LPPe_ver1_1_BroadcastSystem_Capabs_authentication = SEQ(name=u'authentication', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-Authentication')), opt=True)
    OMA_LPPe_ver1_1_BroadcastSystem_Capabs._cont = ASN1Dict([
        (u'broadcastSystemID', _OMA_LPPe_ver1_1_BroadcastSystem_Capabs_broadcastSystemID),
        (u'broadcastADTypes', _OMA_LPPe_ver1_1_BroadcastSystem_Capabs_broadcastADTypes),
        (u'point2pointAD', _OMA_LPPe_ver1_1_BroadcastSystem_Capabs_point2pointAD),
        (u'ciphering', _OMA_LPPe_ver1_1_BroadcastSystem_Capabs_ciphering),
        (u'authentication', _OMA_LPPe_ver1_1_BroadcastSystem_Capabs_authentication),
        ])
    OMA_LPPe_ver1_1_BroadcastSystem_Capabs._ext = []
    
    #-----< OMA-LPPe-ver1-1-point2pointAD >-----#
    OMA_LPPe_ver1_1_point2pointAD = SEQ(name=u'OMA-LPPe-ver1-1-point2pointAD', mode=MODE_TYPE)
    OMA_LPPe_ver1_1_point2pointAD._cont = ASN1Dict([
        ])
    OMA_LPPe_ver1_1_point2pointAD._ext = []
    
    #-----< OMA-LPPe-ver1-1-Ciphering >-----#
    OMA_LPPe_ver1_1_Ciphering = SEQ(name=u'OMA-LPPe-ver1-1-Ciphering', mode=MODE_TYPE)
    OMA_LPPe_ver1_1_Ciphering._cont = ASN1Dict([
        ])
    OMA_LPPe_ver1_1_Ciphering._ext = []
    
    #-----< OMA-LPPe-ver1-1-Authentication >-----#
    OMA_LPPe_ver1_1_Authentication = SEQ(name=u'OMA-LPPe-ver1-1-Authentication', mode=MODE_TYPE)
    OMA_LPPe_ver1_1_Authentication._cont = ASN1Dict([
        ])
    OMA_LPPe_ver1_1_Authentication._ext = []
    
    #-----< OMA-LPPe-CommonIEsRequestAssistanceData >-----#
    OMA_LPPe_CommonIEsRequestAssistanceData = SEQ(name=u'OMA-LPPe-CommonIEsRequestAssistanceData', mode=MODE_TYPE)
    _OMA_LPPe_CommonIEsRequestAssistanceData_approximate_location = SEQ(name=u'approximate-location', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'EllipsoidPointWithAltitudeAndUncertaintyEllipsoid')), opt=True)
    _OMA_LPPe_CommonIEsRequestAssistanceData_assistanceContainerRequestList = SEQ_OF(name=u'assistanceContainerRequestList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AssistanceContainerRequestList')), opt=True)
    _OMA_LPPe_CommonIEsRequestAssistanceData_requestPeriodicADwithUpdate = SEQ(name=u'requestPeriodicADwithUpdate', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-RequestPeriodicADwithUpdate')), opt=True)
    _OMA_LPPe_CommonIEsRequestAssistanceData_segmentedADpreference = ENUM(name=u'segmentedADpreference', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_CommonIEsRequestAssistanceData_segmentedADpreference._cont = ASN1Dict([(u'useBasic', 0), (u'useResume', 1)])
    _OMA_LPPe_CommonIEsRequestAssistanceData_segmentedADpreference._ext = []
    _OMA_LPPe_CommonIEsRequestAssistanceData_segmentedADResume = SEQ(name=u'segmentedADResume', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-SegmentedADResume')), opt=True)
    _OMA_LPPe_CommonIEsRequestAssistanceData_referencePointAssistanceReq = SEQ(name=u'referencePointAssistanceReq', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ReferencePointAssistanceReq')), opt=True)
    _OMA_LPPe_CommonIEsRequestAssistanceData_ver1_1_localCellInformationReq = SEQ(name=u'ver1-1-localCellInformationReq', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-LocalCellInformationReq')), opt=True)
    _OMA_LPPe_CommonIEsRequestAssistanceData_ver1_1_BroadcastAssistanceDataReq = SEQ(name=u'ver1-1-BroadcastAssistanceDataReq', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-BroadcastAssistanceDataReq')), opt=True)
    _OMA_LPPe_CommonIEsRequestAssistanceData_ver1_1_AccessNetwork = CHOICE(name=u'ver1-1-AccessNetwork', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-AccessNetworkID')), opt=True)
    _OMA_LPPe_CommonIEsRequestAssistanceData_ver1_1_groundMorphologyModelReq = SEQ(name=u'ver1-1-groundMorphologyModelReq', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-GroundMorphologyModelReq')), opt=True)
    OMA_LPPe_CommonIEsRequestAssistanceData._cont = ASN1Dict([
        (u'approximate-location', _OMA_LPPe_CommonIEsRequestAssistanceData_approximate_location),
        (u'assistanceContainerRequestList', _OMA_LPPe_CommonIEsRequestAssistanceData_assistanceContainerRequestList),
        (u'requestPeriodicADwithUpdate', _OMA_LPPe_CommonIEsRequestAssistanceData_requestPeriodicADwithUpdate),
        (u'segmentedADpreference', _OMA_LPPe_CommonIEsRequestAssistanceData_segmentedADpreference),
        (u'segmentedADResume', _OMA_LPPe_CommonIEsRequestAssistanceData_segmentedADResume),
        (u'referencePointAssistanceReq', _OMA_LPPe_CommonIEsRequestAssistanceData_referencePointAssistanceReq),
        (u'ver1-1-localCellInformationReq', _OMA_LPPe_CommonIEsRequestAssistanceData_ver1_1_localCellInformationReq),
        (u'ver1-1-BroadcastAssistanceDataReq', _OMA_LPPe_CommonIEsRequestAssistanceData_ver1_1_BroadcastAssistanceDataReq),
        (u'ver1-1-AccessNetwork', _OMA_LPPe_CommonIEsRequestAssistanceData_ver1_1_AccessNetwork),
        (u'ver1-1-groundMorphologyModelReq', _OMA_LPPe_CommonIEsRequestAssistanceData_ver1_1_groundMorphologyModelReq),
        ])
    OMA_LPPe_CommonIEsRequestAssistanceData._ext = [u'ver1-1-localCellInformationReq', u'ver1-1-BroadcastAssistanceDataReq', u'ver1-1-AccessNetwork', u'ver1-1-groundMorphologyModelReq']
    
    #-----< OMA-LPPe-RequestPeriodicADwithUpdate >-----#
    OMA_LPPe_RequestPeriodicADwithUpdate = SEQ(name=u'OMA-LPPe-RequestPeriodicADwithUpdate', mode=MODE_TYPE)
    _OMA_LPPe_RequestPeriodicADwithUpdate_periodicAD_session_ID = OCT_STR(name=u'periodicAD-session-ID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_RequestPeriodicADwithUpdate_periodicAD_session_ID._const_sz = ASN1Set(rv=[4], rr=[], ev=None, er=[])
    _OMA_LPPe_RequestPeriodicADwithUpdate_typeOfADRequest = ENUM(name=u'typeOfADRequest', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'TypeOfADRequest')))
    OMA_LPPe_RequestPeriodicADwithUpdate._cont = ASN1Dict([
        (u'periodicAD-session-ID', _OMA_LPPe_RequestPeriodicADwithUpdate_periodicAD_session_ID),
        (u'typeOfADRequest', _OMA_LPPe_RequestPeriodicADwithUpdate_typeOfADRequest),
        ])
    OMA_LPPe_RequestPeriodicADwithUpdate._ext = []
    
    #-----< TypeOfADRequest >-----#
    TypeOfADRequest = ENUM(name=u'TypeOfADRequest', mode=MODE_TYPE)
    TypeOfADRequest._cont = ASN1Dict([(u'initialRequest', 0), (u'updateAndContinueIfUpdateFails', 1), (u'updateAndAbortIfUpdateFails', 2)])
    TypeOfADRequest._ext = []
    
    #-----< OMA-LPPe-SegmentedADResume >-----#
    OMA_LPPe_SegmentedADResume = SEQ(name=u'OMA-LPPe-SegmentedADResume', mode=MODE_TYPE)
    _OMA_LPPe_SegmentedADResume_segmentedAD_session_ID = SEQ(name=u'segmentedAD-session-ID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-Session-ID')))
    _OMA_LPPe_SegmentedADResume_next_segment_number = INT(name=u'next-segment-number', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_SegmentedADResume_next_segment_number._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4096)], ev=None, er=[])
    OMA_LPPe_SegmentedADResume._cont = ASN1Dict([
        (u'segmentedAD-session-ID', _OMA_LPPe_SegmentedADResume_segmentedAD_session_ID),
        (u'next-segment-number', _OMA_LPPe_SegmentedADResume_next_segment_number),
        ])
    OMA_LPPe_SegmentedADResume._ext = None
    
    #-----< OMA-LPPe-ReferencePointAssistanceReq >-----#
    OMA_LPPe_ReferencePointAssistanceReq = SEQ(name=u'OMA-LPPe-ReferencePointAssistanceReq', mode=MODE_TYPE)
    _OMA_LPPe_ReferencePointAssistanceReq_referencePointReq = SEQ_OF(name=u'referencePointReq', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_ReferencePointAssistanceReq_referencePointReq__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ReferencePointAssistanceReqElement')))
    _OMA_LPPe_ReferencePointAssistanceReq_referencePointReq._cont = __OMA_LPPe_ReferencePointAssistanceReq_referencePointReq__item_
    _OMA_LPPe_ReferencePointAssistanceReq_referencePointReq._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    OMA_LPPe_ReferencePointAssistanceReq._cont = ASN1Dict([
        (u'referencePointReq', _OMA_LPPe_ReferencePointAssistanceReq_referencePointReq),
        ])
    OMA_LPPe_ReferencePointAssistanceReq._ext = []
    
    #-----< OMA-LPPe-ReferencePointAssistanceReqElement >-----#
    OMA_LPPe_ReferencePointAssistanceReqElement = SEQ(name=u'OMA-LPPe-ReferencePointAssistanceReqElement', mode=MODE_TYPE)
    _OMA_LPPe_ReferencePointAssistanceReqElement_referencePointProvider = CHOICE(name=u'referencePointProvider', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-VendorOrOperatorID')))
    _OMA_LPPe_ReferencePointAssistanceReqElement_mapDataReq = OCT_STR(name=u'mapDataReq', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    OMA_LPPe_ReferencePointAssistanceReqElement._cont = ASN1Dict([
        (u'referencePointProvider', _OMA_LPPe_ReferencePointAssistanceReqElement_referencePointProvider),
        (u'mapDataReq', _OMA_LPPe_ReferencePointAssistanceReqElement_mapDataReq),
        ])
    OMA_LPPe_ReferencePointAssistanceReqElement._ext = []
    
    #-----< OMA-LPPe-ver1-1-GroundMorphologyModelReq >-----#
    OMA_LPPe_ver1_1_GroundMorphologyModelReq = SEQ(name=u'OMA-LPPe-ver1-1-GroundMorphologyModelReq', mode=MODE_TYPE)
    _OMA_LPPe_ver1_1_GroundMorphologyModelReq_modelsReq = BIT_STR(name=u'modelsReq', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_ver1_1_GroundMorphologyModelReq_modelsReq._cont = ASN1Dict([(u'altitude', 0), (u'buildings', 1)])
    _OMA_LPPe_ver1_1_GroundMorphologyModelReq_modelsReq._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    _OMA_LPPe_ver1_1_GroundMorphologyModelReq_refAreaParam = SEQ(name=u'refAreaParam', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OMA_LPPe_ver1_1_GroundMorphologyModelReq_refAreaParam_northWestCorner = SEQ(name=u'northWestCorner', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'Ellipsoid-Point')), opt=True)
    __OMA_LPPe_ver1_1_GroundMorphologyModelReq_refAreaParam_spanX = INT(name=u'spanX', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_ver1_1_GroundMorphologyModelReq_refAreaParam_spanX._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=6, ub=14)], ev=None, er=[])
    __OMA_LPPe_ver1_1_GroundMorphologyModelReq_refAreaParam_spanY = INT(name=u'spanY', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_ver1_1_GroundMorphologyModelReq_refAreaParam_spanY._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=6, ub=14)], ev=None, er=[])
    _OMA_LPPe_ver1_1_GroundMorphologyModelReq_refAreaParam._cont = ASN1Dict([
        (u'northWestCorner', __OMA_LPPe_ver1_1_GroundMorphologyModelReq_refAreaParam_northWestCorner),
        (u'spanX', __OMA_LPPe_ver1_1_GroundMorphologyModelReq_refAreaParam_spanX),
        (u'spanY', __OMA_LPPe_ver1_1_GroundMorphologyModelReq_refAreaParam_spanY),
        ])
    _OMA_LPPe_ver1_1_GroundMorphologyModelReq_refAreaParam._ext = []
    OMA_LPPe_ver1_1_GroundMorphologyModelReq._cont = ASN1Dict([
        (u'modelsReq', _OMA_LPPe_ver1_1_GroundMorphologyModelReq_modelsReq),
        (u'refAreaParam', _OMA_LPPe_ver1_1_GroundMorphologyModelReq_refAreaParam),
        ])
    OMA_LPPe_ver1_1_GroundMorphologyModelReq._ext = []
    
    #-----< OMA-LPPe-ver1-1-LocalCellInformationReq >-----#
    OMA_LPPe_ver1_1_LocalCellInformationReq = SEQ(name=u'OMA-LPPe-ver1-1-LocalCellInformationReq', mode=MODE_TYPE)
    _OMA_LPPe_ver1_1_LocalCellInformationReq_localCellInformationReq = BIT_STR(name=u'localCellInformationReq', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_ver1_1_LocalCellInformationReq_localCellInformationReq._cont = ASN1Dict([(u'gnssTiming', 0), (u'networkTiming', 1), (u'coverage', 2), (u'coordinates', 3), (u'frequencyAccuracy', 4)])
    _OMA_LPPe_ver1_1_LocalCellInformationReq_localCellInformationReq._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    _OMA_LPPe_ver1_1_LocalCellInformationReq_localCellID = CHOICE(name=u'localCellID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-CellGlobalID')), opt=True)
    _OMA_LPPe_ver1_1_LocalCellInformationReq_numberOfCells = INT(name=u'numberOfCells', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_ver1_1_LocalCellInformationReq_numberOfCells._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=7)], ev=None, er=[])
    OMA_LPPe_ver1_1_LocalCellInformationReq._cont = ASN1Dict([
        (u'localCellInformationReq', _OMA_LPPe_ver1_1_LocalCellInformationReq_localCellInformationReq),
        (u'localCellID', _OMA_LPPe_ver1_1_LocalCellInformationReq_localCellID),
        (u'numberOfCells', _OMA_LPPe_ver1_1_LocalCellInformationReq_numberOfCells),
        ])
    OMA_LPPe_ver1_1_LocalCellInformationReq._ext = []
    
    #-----< OMA-LPPe-ver1-1-BroadcastAssistanceDataReq >-----#
    OMA_LPPe_ver1_1_BroadcastAssistanceDataReq = SEQ(name=u'OMA-LPPe-ver1-1-BroadcastAssistanceDataReq', mode=MODE_TYPE)
    _OMA_LPPe_ver1_1_BroadcastAssistanceDataReq_broadcastSystem = SEQ(name=u'broadcastSystem', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-BroadcastSystem')), opt=True)
    OMA_LPPe_ver1_1_BroadcastAssistanceDataReq._cont = ASN1Dict([
        (u'broadcastSystem', _OMA_LPPe_ver1_1_BroadcastAssistanceDataReq_broadcastSystem),
        ])
    OMA_LPPe_ver1_1_BroadcastAssistanceDataReq._ext = []
    
    #-----< OMA-LPPe-ver1-1-BroadcastSystem >-----#
    OMA_LPPe_ver1_1_BroadcastSystem = SEQ(name=u'OMA-LPPe-ver1-1-BroadcastSystem', mode=MODE_TYPE)
    _OMA_LPPe_ver1_1_BroadcastSystem_broadcastSystemID = CHOICE(name=u'broadcastSystemID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-BroadcastSystemID')))
    _OMA_LPPe_ver1_1_BroadcastSystem_cipherSets = SEQ_OF(name=u'cipherSets', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OMA_LPPe_ver1_1_BroadcastSystem_cipherSets__item_ = INT(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-CipherSetID')))
    _OMA_LPPe_ver1_1_BroadcastSystem_cipherSets._cont = __OMA_LPPe_ver1_1_BroadcastSystem_cipherSets__item_
    _OMA_LPPe_ver1_1_BroadcastSystem_cipherSets._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    _OMA_LPPe_ver1_1_BroadcastSystem_authenticationSets = SEQ_OF(name=u'authenticationSets', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OMA_LPPe_ver1_1_BroadcastSystem_authenticationSets__item_ = INT(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-AuthenticationSetID')))
    _OMA_LPPe_ver1_1_BroadcastSystem_authenticationSets._cont = __OMA_LPPe_ver1_1_BroadcastSystem_authenticationSets__item_
    _OMA_LPPe_ver1_1_BroadcastSystem_authenticationSets._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4)], ev=None, er=[])
    OMA_LPPe_ver1_1_BroadcastSystem._cont = ASN1Dict([
        (u'broadcastSystemID', _OMA_LPPe_ver1_1_BroadcastSystem_broadcastSystemID),
        (u'cipherSets', _OMA_LPPe_ver1_1_BroadcastSystem_cipherSets),
        (u'authenticationSets', _OMA_LPPe_ver1_1_BroadcastSystem_authenticationSets),
        ])
    OMA_LPPe_ver1_1_BroadcastSystem._ext = []
    
    #-----< OMA-LPPe-CommonIEsProvideAssistanceData >-----#
    OMA_LPPe_CommonIEsProvideAssistanceData = SEQ(name=u'OMA-LPPe-CommonIEsProvideAssistanceData', mode=MODE_TYPE)
    _OMA_LPPe_CommonIEsProvideAssistanceData_assistanceContainerList = SEQ_OF(name=u'assistanceContainerList', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AssistanceContainerProvideList')), opt=True)
    _OMA_LPPe_CommonIEsProvideAssistanceData_providePeriodicADwithUpdate = SEQ(name=u'providePeriodicADwithUpdate', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ProvidePeriodicADwithUpdate')), opt=True)
    _OMA_LPPe_CommonIEsProvideAssistanceData_segmentedADTransfer = SEQ(name=u'segmentedADTransfer', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-SegmentedADTransfer')), opt=True)
    _OMA_LPPe_CommonIEsProvideAssistanceData_default_reference_point = SEQ(name=u'default-reference-point', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ReferencePoint')), opt=True)
    _OMA_LPPe_CommonIEsProvideAssistanceData_ver1_1_localCellInformation = SEQ(name=u'ver1-1-localCellInformation', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-LocalCellInformation')), opt=True)
    _OMA_LPPe_CommonIEsProvideAssistanceData_ver1_1_BroadcastAssistanceData = SEQ(name=u'ver1-1-BroadcastAssistanceData', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-BroadcastAssistanceData')), opt=True)
    _OMA_LPPe_CommonIEsProvideAssistanceData_ver1_1_groundMorphologyModel = SEQ(name=u'ver1-1-groundMorphologyModel', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-GroundMorphologyModel')), opt=True)
    OMA_LPPe_CommonIEsProvideAssistanceData._cont = ASN1Dict([
        (u'assistanceContainerList', _OMA_LPPe_CommonIEsProvideAssistanceData_assistanceContainerList),
        (u'providePeriodicADwithUpdate', _OMA_LPPe_CommonIEsProvideAssistanceData_providePeriodicADwithUpdate),
        (u'segmentedADTransfer', _OMA_LPPe_CommonIEsProvideAssistanceData_segmentedADTransfer),
        (u'default-reference-point', _OMA_LPPe_CommonIEsProvideAssistanceData_default_reference_point),
        (u'ver1-1-localCellInformation', _OMA_LPPe_CommonIEsProvideAssistanceData_ver1_1_localCellInformation),
        (u'ver1-1-BroadcastAssistanceData', _OMA_LPPe_CommonIEsProvideAssistanceData_ver1_1_BroadcastAssistanceData),
        (u'ver1-1-groundMorphologyModel', _OMA_LPPe_CommonIEsProvideAssistanceData_ver1_1_groundMorphologyModel),
        ])
    OMA_LPPe_CommonIEsProvideAssistanceData._ext = [u'ver1-1-localCellInformation', u'ver1-1-BroadcastAssistanceData', u'ver1-1-groundMorphologyModel']
    
    #-----< OMA-LPPe-ProvidePeriodicADwithUpdate >-----#
    OMA_LPPe_ProvidePeriodicADwithUpdate = SEQ(name=u'OMA-LPPe-ProvidePeriodicADwithUpdate', mode=MODE_TYPE)
    _OMA_LPPe_ProvidePeriodicADwithUpdate_periodicAD_session_ID = OCT_STR(name=u'periodicAD-session-ID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_ProvidePeriodicADwithUpdate_periodicAD_session_ID._const_sz = ASN1Set(rv=[4], rr=[], ev=None, er=[])
    _OMA_LPPe_ProvidePeriodicADwithUpdate_typeOfADProvide = ENUM(name=u'typeOfADProvide', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-TypeOfADProvide')))
    OMA_LPPe_ProvidePeriodicADwithUpdate._cont = ASN1Dict([
        (u'periodicAD-session-ID', _OMA_LPPe_ProvidePeriodicADwithUpdate_periodicAD_session_ID),
        (u'typeOfADProvide', _OMA_LPPe_ProvidePeriodicADwithUpdate_typeOfADProvide),
        ])
    OMA_LPPe_ProvidePeriodicADwithUpdate._ext = []
    
    #-----< OMA-LPPe-TypeOfADProvide >-----#
    OMA_LPPe_TypeOfADProvide = ENUM(name=u'OMA-LPPe-TypeOfADProvide', mode=MODE_TYPE)
    OMA_LPPe_TypeOfADProvide._cont = ASN1Dict([(u'responseToInitialRequest', 0), (u'providePeriodicAD', 1), (u'responseToTargetUpdateRequest', 2), (u'serverUpdate', 3)])
    OMA_LPPe_TypeOfADProvide._ext = []
    
    #-----< OMA-LPPe-SegmentedADTransfer >-----#
    OMA_LPPe_SegmentedADTransfer = SEQ(name=u'OMA-LPPe-SegmentedADTransfer', mode=MODE_TYPE)
    _OMA_LPPe_SegmentedADTransfer_segmentedAD_session_ID = SEQ(name=u'segmentedAD-session-ID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-Session-ID')))
    _OMA_LPPe_SegmentedADTransfer_segment_number = INT(name=u'segment-number', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_SegmentedADTransfer_segment_number._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4096)], ev=None, er=[])
    OMA_LPPe_SegmentedADTransfer._cont = ASN1Dict([
        (u'segmentedAD-session-ID', _OMA_LPPe_SegmentedADTransfer_segmentedAD_session_ID),
        (u'segment-number', _OMA_LPPe_SegmentedADTransfer_segment_number),
        ])
    OMA_LPPe_SegmentedADTransfer._ext = []
    
    #-----< OMA-LPPe-ver1-1-LocalCellInformation >-----#
    OMA_LPPe_ver1_1_LocalCellInformation = SEQ(name=u'OMA-LPPe-ver1-1-LocalCellInformation', mode=MODE_TYPE)
    _OMA_LPPe_ver1_1_LocalCellInformation_ver1_1_timingInformation = SEQ_OF(name=u'ver1-1-timingInformation', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OMA_LPPe_ver1_1_LocalCellInformation_ver1_1_timingInformation__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-ReferenceTime')))
    _OMA_LPPe_ver1_1_LocalCellInformation_ver1_1_timingInformation._cont = __OMA_LPPe_ver1_1_LocalCellInformation_ver1_1_timingInformation__item_
    _OMA_LPPe_ver1_1_LocalCellInformation_ver1_1_timingInformation._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    _OMA_LPPe_ver1_1_LocalCellInformation_ver1_1_other_CellInformation = SEQ_OF(name=u'ver1-1-other-CellInformation', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OMA_LPPe_ver1_1_LocalCellInformation_ver1_1_other_CellInformation__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-CellInformation')))
    _OMA_LPPe_ver1_1_LocalCellInformation_ver1_1_other_CellInformation._cont = __OMA_LPPe_ver1_1_LocalCellInformation_ver1_1_other_CellInformation__item_
    _OMA_LPPe_ver1_1_LocalCellInformation_ver1_1_other_CellInformation._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    OMA_LPPe_ver1_1_LocalCellInformation._cont = ASN1Dict([
        (u'ver1-1-timingInformation', _OMA_LPPe_ver1_1_LocalCellInformation_ver1_1_timingInformation),
        (u'ver1-1-other-CellInformation', _OMA_LPPe_ver1_1_LocalCellInformation_ver1_1_other_CellInformation),
        ])
    OMA_LPPe_ver1_1_LocalCellInformation._ext = []
    
    #-----< maxCellSets >-----#
    maxCellSets = INT(name=u'maxCellSets', mode=MODE_VALUE)
    maxCellSets._val = 8
    
    #-----< maxCells >-----#
    maxCells = INT(name=u'maxCells', mode=MODE_VALUE)
    maxCells._val = 128
    
    #-----< OMA-LPPe-ver1-1-CellInformation >-----#
    OMA_LPPe_ver1_1_CellInformation = SEQ(name=u'OMA-LPPe-ver1-1-CellInformation', mode=MODE_TYPE)
    _OMA_LPPe_ver1_1_CellInformation_cellID = CHOICE(name=u'cellID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-CellGlobalID')))
    _OMA_LPPe_ver1_1_CellInformation_coverage = CHOICE(name=u'coverage', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __OMA_LPPe_ver1_1_CellInformation_coverage_circle = SEQ(name=u'circle', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'Ellipsoid-PointWithUncertaintyCircle')))
    __OMA_LPPe_ver1_1_CellInformation_coverage_ellipse = SEQ(name=u'ellipse', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'EllipsoidPointWithUncertaintyEllipse')))
    __OMA_LPPe_ver1_1_CellInformation_coverage_arc = SEQ(name=u'arc', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'EllipsoidArc')))
    __OMA_LPPe_ver1_1_CellInformation_coverage_polygon = SEQ_OF(name=u'polygon', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'Polygon')))
    _OMA_LPPe_ver1_1_CellInformation_coverage._cont = ASN1Dict([
        (u'circle', __OMA_LPPe_ver1_1_CellInformation_coverage_circle),
        (u'ellipse', __OMA_LPPe_ver1_1_CellInformation_coverage_ellipse),
        (u'arc', __OMA_LPPe_ver1_1_CellInformation_coverage_arc),
        (u'polygon', __OMA_LPPe_ver1_1_CellInformation_coverage_polygon),
        ])
    _OMA_LPPe_ver1_1_CellInformation_coverage._ext = []
    _OMA_LPPe_ver1_1_CellInformation_coordinates = SEQ(name=u'coordinates', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'EllipsoidPointWithAltitudeAndUncertaintyEllipsoid')), opt=True)
    _OMA_LPPe_ver1_1_CellInformation_frequencyAccuracy = INT(name=u'frequencyAccuracy', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_ver1_1_CellInformation_frequencyAccuracy._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=6)], ev=None, er=[])
    OMA_LPPe_ver1_1_CellInformation._cont = ASN1Dict([
        (u'cellID', _OMA_LPPe_ver1_1_CellInformation_cellID),
        (u'coverage', _OMA_LPPe_ver1_1_CellInformation_coverage),
        (u'coordinates', _OMA_LPPe_ver1_1_CellInformation_coordinates),
        (u'frequencyAccuracy', _OMA_LPPe_ver1_1_CellInformation_frequencyAccuracy),
        ])
    OMA_LPPe_ver1_1_CellInformation._ext = []
    
    #-----< OMA-LPPe-ver1-1-BroadcastAssistanceData >-----#
    OMA_LPPe_ver1_1_BroadcastAssistanceData = SEQ(name=u'OMA-LPPe-ver1-1-BroadcastAssistanceData', mode=MODE_TYPE)
    _OMA_LPPe_ver1_1_BroadcastAssistanceData_broadcastSystem = CHOICE(name=u'broadcastSystem', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-BroadcastSystemID')))
    _OMA_LPPe_ver1_1_BroadcastAssistanceData_accessNetworks = SEQ_OF(name=u'accessNetworks', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_ver1_1_BroadcastAssistanceData_accessNetworks__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-AccessNetworkID')))
    _OMA_LPPe_ver1_1_BroadcastAssistanceData_accessNetworks._cont = __OMA_LPPe_ver1_1_BroadcastAssistanceData_accessNetworks__item_
    _OMA_LPPe_ver1_1_BroadcastAssistanceData_accessNetworks._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    _OMA_LPPe_ver1_1_BroadcastAssistanceData_coverageArea = CHOICE(name=u'coverageArea', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __OMA_LPPe_ver1_1_BroadcastAssistanceData_coverageArea_circle = SEQ(name=u'circle', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'Ellipsoid-PointWithUncertaintyCircle')))
    __OMA_LPPe_ver1_1_BroadcastAssistanceData_coverageArea_ellipse = SEQ(name=u'ellipse', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'EllipsoidPointWithUncertaintyEllipse')))
    __OMA_LPPe_ver1_1_BroadcastAssistanceData_coverageArea_polygon = SEQ_OF(name=u'polygon', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'Polygon')))
    _OMA_LPPe_ver1_1_BroadcastAssistanceData_coverageArea._cont = ASN1Dict([
        (u'circle', __OMA_LPPe_ver1_1_BroadcastAssistanceData_coverageArea_circle),
        (u'ellipse', __OMA_LPPe_ver1_1_BroadcastAssistanceData_coverageArea_ellipse),
        (u'polygon', __OMA_LPPe_ver1_1_BroadcastAssistanceData_coverageArea_polygon),
        ])
    _OMA_LPPe_ver1_1_BroadcastAssistanceData_coverageArea._ext = []
    _OMA_LPPe_ver1_1_BroadcastAssistanceData_broadcastADTypes = SEQ(name=u'broadcastADTypes', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-BroadcastADTypes')), opt=True)
    _OMA_LPPe_ver1_1_BroadcastAssistanceData_broadcastMode = CHOICE(name=u'broadcastMode', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __OMA_LPPe_ver1_1_BroadcastAssistanceData_broadcastMode_unencapsulated = NULL(name=u'unencapsulated', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_ver1_1_BroadcastAssistanceData_broadcastMode_encapsulated = SEQ(name=u'encapsulated', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-EncapsulatedMode')))
    _OMA_LPPe_ver1_1_BroadcastAssistanceData_broadcastMode._cont = ASN1Dict([
        (u'unencapsulated', __OMA_LPPe_ver1_1_BroadcastAssistanceData_broadcastMode_unencapsulated),
        (u'encapsulated', __OMA_LPPe_ver1_1_BroadcastAssistanceData_broadcastMode_encapsulated),
        ])
    _OMA_LPPe_ver1_1_BroadcastAssistanceData_broadcastMode._ext = []
    OMA_LPPe_ver1_1_BroadcastAssistanceData._cont = ASN1Dict([
        (u'broadcastSystem', _OMA_LPPe_ver1_1_BroadcastAssistanceData_broadcastSystem),
        (u'accessNetworks', _OMA_LPPe_ver1_1_BroadcastAssistanceData_accessNetworks),
        (u'coverageArea', _OMA_LPPe_ver1_1_BroadcastAssistanceData_coverageArea),
        (u'broadcastADTypes', _OMA_LPPe_ver1_1_BroadcastAssistanceData_broadcastADTypes),
        (u'broadcastMode', _OMA_LPPe_ver1_1_BroadcastAssistanceData_broadcastMode),
        ])
    OMA_LPPe_ver1_1_BroadcastAssistanceData._ext = []
    
    #-----< OMA-LPPe-ver1-1-EncapsulatedMode >-----#
    OMA_LPPe_ver1_1_EncapsulatedMode = SEQ(name=u'OMA-LPPe-ver1-1-EncapsulatedMode', mode=MODE_TYPE)
    _OMA_LPPe_ver1_1_EncapsulatedMode_serverID = SEQ(name=u'serverID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-ServerID')))
    _OMA_LPPe_ver1_1_EncapsulatedMode_cipherSets = SEQ_OF(name=u'cipherSets', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OMA_LPPe_ver1_1_EncapsulatedMode_cipherSets__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-CipherSet')))
    _OMA_LPPe_ver1_1_EncapsulatedMode_cipherSets._cont = __OMA_LPPe_ver1_1_EncapsulatedMode_cipherSets__item_
    _OMA_LPPe_ver1_1_EncapsulatedMode_cipherSets._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    _OMA_LPPe_ver1_1_EncapsulatedMode_authentication = SEQ_OF(name=u'authentication', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OMA_LPPe_ver1_1_EncapsulatedMode_authentication__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ver1-1-AuthenticationSet')))
    _OMA_LPPe_ver1_1_EncapsulatedMode_authentication._cont = __OMA_LPPe_ver1_1_EncapsulatedMode_authentication__item_
    _OMA_LPPe_ver1_1_EncapsulatedMode_authentication._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4)], ev=None, er=[])
    OMA_LPPe_ver1_1_EncapsulatedMode._cont = ASN1Dict([
        (u'serverID', _OMA_LPPe_ver1_1_EncapsulatedMode_serverID),
        (u'cipherSets', _OMA_LPPe_ver1_1_EncapsulatedMode_cipherSets),
        (u'authentication', _OMA_LPPe_ver1_1_EncapsulatedMode_authentication),
        ])
    OMA_LPPe_ver1_1_EncapsulatedMode._ext = []
    
    #-----< OMA-LPPe-CommonIEsRequestLocationInformation >-----#
    OMA_LPPe_CommonIEsRequestLocationInformation = SEQ(name=u'OMA-LPPe-CommonIEsRequestLocationInformation', mode=MODE_TYPE)
    _OMA_LPPe_CommonIEsRequestLocationInformation_iP_Address_Request = SEQ(name=u'iP-Address-Request', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-IP-Address-Request')), opt=True)
    _OMA_LPPe_CommonIEsRequestLocationInformation_locationInformationContainerRequest = SEQ(name=u'locationInformationContainerRequest', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-LocationInformationContainerRequest')), opt=True)
    _OMA_LPPe_CommonIEsRequestLocationInformation_requestPeriodicLocInfoWithUpdate = SEQ(name=u'requestPeriodicLocInfoWithUpdate', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-RequestPeriodicLocInfoWithUpdate')), opt=True)
    _OMA_LPPe_CommonIEsRequestLocationInformation_relativeLocationChange_Request = SEQ(name=u'relativeLocationChange-Request', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-RelativeLocationChange-Request')), opt=True)
    _OMA_LPPe_CommonIEsRequestLocationInformation_localPositionRequest = SEQ(name=u'localPositionRequest', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-LocalPositionRequest')), opt=True)
    _OMA_LPPe_CommonIEsRequestLocationInformation_scheduledLocation_Request = SEQ(name=u'scheduledLocation-Request', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ScheduledLocation-Request')), opt=True)
    _OMA_LPPe_CommonIEsRequestLocationInformation_accessTypeRequest = SEQ(name=u'accessTypeRequest', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AccessTypeRequest')), opt=True)
    _OMA_LPPe_CommonIEsRequestLocationInformation_segmentedLIpreference = ENUM(name=u'segmentedLIpreference', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_CommonIEsRequestLocationInformation_segmentedLIpreference._cont = ASN1Dict([(u'useBasic', 0), (u'useResume', 1)])
    _OMA_LPPe_CommonIEsRequestLocationInformation_segmentedLIpreference._ext = []
    _OMA_LPPe_CommonIEsRequestLocationInformation_segmentedLIResume = SEQ(name=u'segmentedLIResume', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-SegmentedLIResume')), opt=True)
    OMA_LPPe_CommonIEsRequestLocationInformation._cont = ASN1Dict([
        (u'iP-Address-Request', _OMA_LPPe_CommonIEsRequestLocationInformation_iP_Address_Request),
        (u'locationInformationContainerRequest', _OMA_LPPe_CommonIEsRequestLocationInformation_locationInformationContainerRequest),
        (u'requestPeriodicLocInfoWithUpdate', _OMA_LPPe_CommonIEsRequestLocationInformation_requestPeriodicLocInfoWithUpdate),
        (u'relativeLocationChange-Request', _OMA_LPPe_CommonIEsRequestLocationInformation_relativeLocationChange_Request),
        (u'localPositionRequest', _OMA_LPPe_CommonIEsRequestLocationInformation_localPositionRequest),
        (u'scheduledLocation-Request', _OMA_LPPe_CommonIEsRequestLocationInformation_scheduledLocation_Request),
        (u'accessTypeRequest', _OMA_LPPe_CommonIEsRequestLocationInformation_accessTypeRequest),
        (u'segmentedLIpreference', _OMA_LPPe_CommonIEsRequestLocationInformation_segmentedLIpreference),
        (u'segmentedLIResume', _OMA_LPPe_CommonIEsRequestLocationInformation_segmentedLIResume),
        ])
    OMA_LPPe_CommonIEsRequestLocationInformation._ext = []
    
    #-----< OMA-LPPe-IP-Address-Request >-----#
    OMA_LPPe_IP_Address_Request = SEQ(name=u'OMA-LPPe-IP-Address-Request', mode=MODE_TYPE)
    OMA_LPPe_IP_Address_Request._cont = ASN1Dict([
        ])
    OMA_LPPe_IP_Address_Request._ext = []
    
    #-----< OMA-LPPe-RequestPeriodicLocInfoWithUpdate >-----#
    OMA_LPPe_RequestPeriodicLocInfoWithUpdate = SEQ(name=u'OMA-LPPe-RequestPeriodicLocInfoWithUpdate', mode=MODE_TYPE)
    _OMA_LPPe_RequestPeriodicLocInfoWithUpdate_session_ID = OCT_STR(name=u'session-ID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_RequestPeriodicLocInfoWithUpdate_session_ID._const_sz = ASN1Set(rv=[4], rr=[], ev=None, er=[])
    _OMA_LPPe_RequestPeriodicLocInfoWithUpdate_typeOfLocInfoRequest = ENUM(name=u'typeOfLocInfoRequest', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-TypeOfLocInfoRequest')))
    OMA_LPPe_RequestPeriodicLocInfoWithUpdate._cont = ASN1Dict([
        (u'session-ID', _OMA_LPPe_RequestPeriodicLocInfoWithUpdate_session_ID),
        (u'typeOfLocInfoRequest', _OMA_LPPe_RequestPeriodicLocInfoWithUpdate_typeOfLocInfoRequest),
        ])
    OMA_LPPe_RequestPeriodicLocInfoWithUpdate._ext = []
    
    #-----< OMA-LPPe-TypeOfLocInfoRequest >-----#
    OMA_LPPe_TypeOfLocInfoRequest = ENUM(name=u'OMA-LPPe-TypeOfLocInfoRequest', mode=MODE_TYPE)
    OMA_LPPe_TypeOfLocInfoRequest._cont = ASN1Dict([(u'initialRequest', 0), (u'updateAndContinueIfUpdateFails', 1), (u'updateAndAbortIfUpdateFails', 2)])
    OMA_LPPe_TypeOfLocInfoRequest._ext = []
    
    #-----< OMA-LPPe-RelativeLocationChange-Request >-----#
    OMA_LPPe_RelativeLocationChange_Request = SEQ(name=u'OMA-LPPe-RelativeLocationChange-Request', mode=MODE_TYPE)
    _OMA_LPPe_RelativeLocationChange_Request_numberOfChanges = INT(name=u'numberOfChanges', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_RelativeLocationChange_Request_numberOfChanges._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=5)], ev=None, er=[])
    OMA_LPPe_RelativeLocationChange_Request._cont = ASN1Dict([
        (u'numberOfChanges', _OMA_LPPe_RelativeLocationChange_Request_numberOfChanges),
        ])
    OMA_LPPe_RelativeLocationChange_Request._ext = []
    
    #-----< OMA-LPPe-LocalPositionRequest >-----#
    OMA_LPPe_LocalPositionRequest = SEQ(name=u'OMA-LPPe-LocalPositionRequest', mode=MODE_TYPE)
    _OMA_LPPe_LocalPositionRequest_typeOfRequest = ENUM(name=u'typeOfRequest', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_LocalPositionRequest_typeOfRequest._cont = ASN1Dict([(u'localOptional', 0), (u'localMandatory', 1), (u'localOnly', 2)])
    _OMA_LPPe_LocalPositionRequest_typeOfRequest._ext = []
    _OMA_LPPe_LocalPositionRequest_referencePointReq = SEQ_OF(name=u'referencePointReq', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OMA_LPPe_LocalPositionRequest_referencePointReq__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ReferencePointUniqueID')))
    _OMA_LPPe_LocalPositionRequest_referencePointReq._cont = __OMA_LPPe_LocalPositionRequest_referencePointReq__item_
    _OMA_LPPe_LocalPositionRequest_referencePointReq._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    OMA_LPPe_LocalPositionRequest._cont = ASN1Dict([
        (u'typeOfRequest', _OMA_LPPe_LocalPositionRequest_typeOfRequest),
        (u'referencePointReq', _OMA_LPPe_LocalPositionRequest_referencePointReq),
        ])
    OMA_LPPe_LocalPositionRequest._ext = []
    
    #-----< OMA-LPPe-ScheduledLocation-Request >-----#
    OMA_LPPe_ScheduledLocation_Request = SEQ(name=u'OMA-LPPe-ScheduledLocation-Request', mode=MODE_TYPE)
    _OMA_LPPe_ScheduledLocation_Request_gnssTime = SEQ(name=u'gnssTime', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-SystemTime')), opt=True)
    _OMA_LPPe_ScheduledLocation_Request_networkTime = SEQ(name=u'networkTime', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'NetworkTime')), opt=True)
    _OMA_LPPe_ScheduledLocation_Request_relativeTime = INT(name=u'relativeTime', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_ScheduledLocation_Request_relativeTime._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=1024)], ev=None, er=[])
    _OMA_LPPe_ScheduledLocation_Request_windowSize = INT(name=u'windowSize', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_ScheduledLocation_Request_windowSize._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=1024)], ev=None, er=[])
    OMA_LPPe_ScheduledLocation_Request._cont = ASN1Dict([
        (u'gnssTime', _OMA_LPPe_ScheduledLocation_Request_gnssTime),
        (u'networkTime', _OMA_LPPe_ScheduledLocation_Request_networkTime),
        (u'relativeTime', _OMA_LPPe_ScheduledLocation_Request_relativeTime),
        (u'windowSize', _OMA_LPPe_ScheduledLocation_Request_windowSize),
        ])
    OMA_LPPe_ScheduledLocation_Request._ext = []
    
    #-----< OMA-LPPe-AccessTypeRequest >-----#
    OMA_LPPe_AccessTypeRequest = SEQ(name=u'OMA-LPPe-AccessTypeRequest', mode=MODE_TYPE)
    OMA_LPPe_AccessTypeRequest._cont = ASN1Dict([
        ])
    OMA_LPPe_AccessTypeRequest._ext = []
    
    #-----< OMA-LPPe-SegmentedLIResume >-----#
    OMA_LPPe_SegmentedLIResume = SEQ(name=u'OMA-LPPe-SegmentedLIResume', mode=MODE_TYPE)
    _OMA_LPPe_SegmentedLIResume_segmentedLI_session_ID = INT(name=u'segmentedLI-session-ID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_SegmentedLIResume_segmentedLI_session_ID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    _OMA_LPPe_SegmentedLIResume_next_segment_number = INT(name=u'next-segment-number', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_SegmentedLIResume_next_segment_number._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4096)], ev=None, er=[])
    OMA_LPPe_SegmentedLIResume._cont = ASN1Dict([
        (u'segmentedLI-session-ID', _OMA_LPPe_SegmentedLIResume_segmentedLI_session_ID),
        (u'next-segment-number', _OMA_LPPe_SegmentedLIResume_next_segment_number),
        ])
    OMA_LPPe_SegmentedLIResume._ext = None
    
    #-----< OMA-LPPe-CommonIEsProvideLocationInformation >-----#
    OMA_LPPe_CommonIEsProvideLocationInformation = SEQ(name=u'OMA-LPPe-CommonIEsProvideLocationInformation', mode=MODE_TYPE)
    _OMA_LPPe_CommonIEsProvideLocationInformation_highAccuracy3Dposition = SEQ(name=u'highAccuracy3Dposition', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-HighAccuracy3Dposition')), opt=True)
    _OMA_LPPe_CommonIEsProvideLocationInformation_localPosition = SEQ(name=u'localPosition', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-LocalPosition')), opt=True)
    _OMA_LPPe_CommonIEsProvideLocationInformation_highAccuracy3Dvelocity = SEQ(name=u'highAccuracy3Dvelocity', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-HighAccuracy3Dvelocity')), opt=True)
    _OMA_LPPe_CommonIEsProvideLocationInformation_iP_Address_List = SEQ_OF(name=u'iP-Address-List', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-IP-Address-List')), opt=True)
    _OMA_LPPe_CommonIEsProvideLocationInformation_locationInformationContainer = SEQ(name=u'locationInformationContainer', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-LocationInformationContainer')), opt=True)
    _OMA_LPPe_CommonIEsProvideLocationInformation_providePeriodicLocInfoWithUpdate = SEQ(name=u'providePeriodicLocInfoWithUpdate', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ProvidePeriodicLocInfowithUpdate')), opt=True)
    _OMA_LPPe_CommonIEsProvideLocationInformation_relativeLocationChangeList = SEQ_OF(name=u'relativeLocationChangeList', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-RelativeLocationChangeList')), opt=True)
    _OMA_LPPe_CommonIEsProvideLocationInformation_scheduledLocation = SEQ(name=u'scheduledLocation', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ScheduledLocation')), opt=True)
    _OMA_LPPe_CommonIEsProvideLocationInformation_accessTypes = SEQ(name=u'accessTypes', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AccessTypes')), opt=True)
    _OMA_LPPe_CommonIEsProvideLocationInformation_segmentedLITransfer = SEQ(name=u'segmentedLITransfer', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-SegmentedLITransfer')), opt=True)
    _OMA_LPPe_CommonIEsProvideLocationInformation_locationInformationTimeStamp = CHOICE(name=u'locationInformationTimeStamp', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-TimeStamp')), opt=True)
    _OMA_LPPe_CommonIEsProvideLocationInformation_locationSource = SEQ(name=u'locationSource', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-LocationSource')), opt=True)
    OMA_LPPe_CommonIEsProvideLocationInformation._cont = ASN1Dict([
        (u'highAccuracy3Dposition', _OMA_LPPe_CommonIEsProvideLocationInformation_highAccuracy3Dposition),
        (u'localPosition', _OMA_LPPe_CommonIEsProvideLocationInformation_localPosition),
        (u'highAccuracy3Dvelocity', _OMA_LPPe_CommonIEsProvideLocationInformation_highAccuracy3Dvelocity),
        (u'iP-Address-List', _OMA_LPPe_CommonIEsProvideLocationInformation_iP_Address_List),
        (u'locationInformationContainer', _OMA_LPPe_CommonIEsProvideLocationInformation_locationInformationContainer),
        (u'providePeriodicLocInfoWithUpdate', _OMA_LPPe_CommonIEsProvideLocationInformation_providePeriodicLocInfoWithUpdate),
        (u'relativeLocationChangeList', _OMA_LPPe_CommonIEsProvideLocationInformation_relativeLocationChangeList),
        (u'scheduledLocation', _OMA_LPPe_CommonIEsProvideLocationInformation_scheduledLocation),
        (u'accessTypes', _OMA_LPPe_CommonIEsProvideLocationInformation_accessTypes),
        (u'segmentedLITransfer', _OMA_LPPe_CommonIEsProvideLocationInformation_segmentedLITransfer),
        (u'locationInformationTimeStamp', _OMA_LPPe_CommonIEsProvideLocationInformation_locationInformationTimeStamp),
        (u'locationSource', _OMA_LPPe_CommonIEsProvideLocationInformation_locationSource),
        ])
    OMA_LPPe_CommonIEsProvideLocationInformation._ext = [u'locationSource']
    
    #-----< OMA-LPPe-LocalPosition >-----#
    OMA_LPPe_LocalPosition = SEQ(name=u'OMA-LPPe-LocalPosition', mode=MODE_TYPE)
    _OMA_LPPe_LocalPosition_referencePoint = SEQ(name=u'referencePoint', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ReferencePointUniqueID')))
    _OMA_LPPe_LocalPosition_subjectLocation = SEQ(name=u'subjectLocation', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-RelativeLocation')), opt=True)
    OMA_LPPe_LocalPosition._cont = ASN1Dict([
        (u'referencePoint', _OMA_LPPe_LocalPosition_referencePoint),
        (u'subjectLocation', _OMA_LPPe_LocalPosition_subjectLocation),
        ])
    OMA_LPPe_LocalPosition._ext = []
    
    #-----< OMA-LPPe-IP-Address-List >-----#
    OMA_LPPe_IP_Address_List = SEQ_OF(name=u'OMA-LPPe-IP-Address-List', mode=MODE_TYPE)
    _OMA_LPPe_IP_Address_List__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-IP-Address')))
    OMA_LPPe_IP_Address_List._cont = _OMA_LPPe_IP_Address_List__item_
    OMA_LPPe_IP_Address_List._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=5)], ev=None, er=[])
    
    #-----< maxIPAddress >-----#
    maxIPAddress = INT(name=u'maxIPAddress', mode=MODE_VALUE)
    maxIPAddress._val = 5
    
    #-----< OMA-LPPe-IP-Address >-----#
    OMA_LPPe_IP_Address = SEQ(name=u'OMA-LPPe-IP-Address', mode=MODE_TYPE)
    _OMA_LPPe_IP_Address_local_IP_Address = CHOICE(name=u'local-IP-Address', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __OMA_LPPe_IP_Address_local_IP_Address_iPv4 = BIT_STR(name=u'iPv4', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_IP_Address_local_IP_Address_iPv4._const_sz = ASN1Set(rv=[32], rr=[], ev=None, er=[])
    __OMA_LPPe_IP_Address_local_IP_Address_iPv6 = BIT_STR(name=u'iPv6', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_IP_Address_local_IP_Address_iPv6._const_sz = ASN1Set(rv=[128], rr=[], ev=None, er=[])
    _OMA_LPPe_IP_Address_local_IP_Address._cont = ASN1Dict([
        (u'iPv4', __OMA_LPPe_IP_Address_local_IP_Address_iPv4),
        (u'iPv6', __OMA_LPPe_IP_Address_local_IP_Address_iPv6),
        ])
    _OMA_LPPe_IP_Address_local_IP_Address._ext = []
    _OMA_LPPe_IP_Address_bearer = ENUM(name=u'bearer', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-Bearer')))
    _OMA_LPPe_IP_Address_nat = BOOL(name=u'nat', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    OMA_LPPe_IP_Address._cont = ASN1Dict([
        (u'local-IP-Address', _OMA_LPPe_IP_Address_local_IP_Address),
        (u'bearer', _OMA_LPPe_IP_Address_bearer),
        (u'nat', _OMA_LPPe_IP_Address_nat),
        ])
    OMA_LPPe_IP_Address._ext = []
    
    #-----< OMA-LPPe-Bearer >-----#
    OMA_LPPe_Bearer = ENUM(name=u'OMA-LPPe-Bearer', mode=MODE_TYPE)
    OMA_LPPe_Bearer._cont = ASN1Dict([(u'unknown', 0), (u'gsm', 1), (u'utran', 2), (u'lte', 3), (u'wlan', 4), (u'wimax', 5), (u'dsl', 6), (u'pktcable', 7), (u'other', 8)])
    OMA_LPPe_Bearer._ext = []
    
    #-----< OMA-LPPe-ProvidePeriodicLocInfowithUpdate >-----#
    OMA_LPPe_ProvidePeriodicLocInfowithUpdate = SEQ(name=u'OMA-LPPe-ProvidePeriodicLocInfowithUpdate', mode=MODE_TYPE)
    _OMA_LPPe_ProvidePeriodicLocInfowithUpdate_session_ID = OCT_STR(name=u'session-ID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_ProvidePeriodicLocInfowithUpdate_session_ID._const_sz = ASN1Set(rv=[4], rr=[], ev=None, er=[])
    _OMA_LPPe_ProvidePeriodicLocInfowithUpdate_typeOfLocInfoProvide = ENUM(name=u'typeOfLocInfoProvide', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-TypeOfLocInfoProvide')))
    OMA_LPPe_ProvidePeriodicLocInfowithUpdate._cont = ASN1Dict([
        (u'session-ID', _OMA_LPPe_ProvidePeriodicLocInfowithUpdate_session_ID),
        (u'typeOfLocInfoProvide', _OMA_LPPe_ProvidePeriodicLocInfowithUpdate_typeOfLocInfoProvide),
        ])
    OMA_LPPe_ProvidePeriodicLocInfowithUpdate._ext = []
    
    #-----< OMA-LPPe-TypeOfLocInfoProvide >-----#
    OMA_LPPe_TypeOfLocInfoProvide = ENUM(name=u'OMA-LPPe-TypeOfLocInfoProvide', mode=MODE_TYPE)
    OMA_LPPe_TypeOfLocInfoProvide._cont = ASN1Dict([(u'responseToInitialRequest', 0), (u'providePeriodicLocInfo', 1), (u'responseToServerUpdateRequest', 2), (u'targetUpdate', 3)])
    OMA_LPPe_TypeOfLocInfoProvide._ext = []
    
    #-----< OMA-LPPe-RelativeLocationChangeList >-----#
    OMA_LPPe_RelativeLocationChangeList = SEQ_OF(name=u'OMA-LPPe-RelativeLocationChangeList', mode=MODE_TYPE)
    _OMA_LPPe_RelativeLocationChangeList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-RelativeLocationChange')))
    OMA_LPPe_RelativeLocationChangeList._cont = _OMA_LPPe_RelativeLocationChangeList__item_
    OMA_LPPe_RelativeLocationChangeList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=5)], ev=None, er=[])
    
    #-----< OMA-LPPe-RelativeLocationChange >-----#
    OMA_LPPe_RelativeLocationChange = SEQ(name=u'OMA-LPPe-RelativeLocationChange', mode=MODE_TYPE)
    _OMA_LPPe_RelativeLocationChange_relativeTime = INT(name=u'relativeTime', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_RelativeLocationChange_relativeTime._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    _OMA_LPPe_RelativeLocationChange_transactionID = INT(name=u'transactionID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_RelativeLocationChange_transactionID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _OMA_LPPe_RelativeLocationChange_relativeLocation = SEQ(name=u'relativeLocation', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-RelativeLocation')))
    OMA_LPPe_RelativeLocationChange._cont = ASN1Dict([
        (u'relativeTime', _OMA_LPPe_RelativeLocationChange_relativeTime),
        (u'transactionID', _OMA_LPPe_RelativeLocationChange_transactionID),
        (u'relativeLocation', _OMA_LPPe_RelativeLocationChange_relativeLocation),
        ])
    OMA_LPPe_RelativeLocationChange._ext = []
    
    #-----< maxRelativeLocation >-----#
    maxRelativeLocation = INT(name=u'maxRelativeLocation', mode=MODE_VALUE)
    maxRelativeLocation._val = 5
    
    #-----< OMA-LPPe-ScheduledLocation >-----#
    OMA_LPPe_ScheduledLocation = SEQ(name=u'OMA-LPPe-ScheduledLocation', mode=MODE_TYPE)
    _OMA_LPPe_ScheduledLocation_disposition = ENUM(name=u'disposition', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_ScheduledLocation_disposition._cont = ASN1Dict([(u'withinWindow', 0), (u'outsideWindowOrNoWindow', 1), (u'notSupportedDueToNoCapability', 2), (u'notSupportedDueToNoTimeReference', 3), (u'notSupportedDueToConflictWithAnotherRequest', 4), (u'notSupportedForOtherReasons', 5)])
    _OMA_LPPe_ScheduledLocation_disposition._ext = []
    _OMA_LPPe_ScheduledLocation_actualWindow = SEQ(name=u'actualWindow', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OMA_LPPe_ScheduledLocation_actualWindow_start = INT(name=u'start', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_ScheduledLocation_actualWindow_start._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-512, ub=511)], ev=None, er=[])
    __OMA_LPPe_ScheduledLocation_actualWindow_duration = INT(name=u'duration', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_ScheduledLocation_actualWindow_duration._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=2047)], ev=None, er=[])
    _OMA_LPPe_ScheduledLocation_actualWindow._cont = ASN1Dict([
        (u'start', __OMA_LPPe_ScheduledLocation_actualWindow_start),
        (u'duration', __OMA_LPPe_ScheduledLocation_actualWindow_duration),
        ])
    _OMA_LPPe_ScheduledLocation_actualWindow._ext = None
    OMA_LPPe_ScheduledLocation._cont = ASN1Dict([
        (u'disposition', _OMA_LPPe_ScheduledLocation_disposition),
        (u'actualWindow', _OMA_LPPe_ScheduledLocation_actualWindow),
        ])
    OMA_LPPe_ScheduledLocation._ext = []
    
    #-----< OMA-LPPe-AccessTypes >-----#
    OMA_LPPe_AccessTypes = SEQ(name=u'OMA-LPPe-AccessTypes', mode=MODE_TYPE)
    _OMA_LPPe_AccessTypes_accessTypeUnknown = NULL(name=u'accessTypeUnknown', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AccessTypes_fixedAccessTypes = BIT_STR(name=u'fixedAccessTypes', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-FixedAccessTypes')), opt=True)
    _OMA_LPPe_AccessTypes_wirelessAccessTypes = BIT_STR(name=u'wirelessAccessTypes', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-WirelessAccessTypes')), opt=True)
    OMA_LPPe_AccessTypes._cont = ASN1Dict([
        (u'accessTypeUnknown', _OMA_LPPe_AccessTypes_accessTypeUnknown),
        (u'fixedAccessTypes', _OMA_LPPe_AccessTypes_fixedAccessTypes),
        (u'wirelessAccessTypes', _OMA_LPPe_AccessTypes_wirelessAccessTypes),
        ])
    OMA_LPPe_AccessTypes._ext = []
    
    #-----< OMA-LPPe-SegmentedLITransfer >-----#
    OMA_LPPe_SegmentedLITransfer = SEQ(name=u'OMA-LPPe-SegmentedLITransfer', mode=MODE_TYPE)
    _OMA_LPPe_SegmentedLITransfer_segmentedLI_session_ID = INT(name=u'segmentedLI-session-ID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_SegmentedLITransfer_segmentedLI_session_ID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    _OMA_LPPe_SegmentedLITransfer_segment_number = INT(name=u'segment-number', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_SegmentedLITransfer_segment_number._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4096)], ev=None, er=[])
    OMA_LPPe_SegmentedLITransfer._cont = ASN1Dict([
        (u'segmentedLI-session-ID', _OMA_LPPe_SegmentedLITransfer_segmentedLI_session_ID),
        (u'segment-number', _OMA_LPPe_SegmentedLITransfer_segment_number),
        ])
    OMA_LPPe_SegmentedLITransfer._ext = []
    
    #-----< OMA-LPPe-TimeStamp >-----#
    OMA_LPPe_TimeStamp = CHOICE(name=u'OMA-LPPe-TimeStamp', mode=MODE_TYPE)
    _OMA_LPPe_TimeStamp_gnssTime = SEQ(name=u'gnssTime', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-SystemTime')))
    _OMA_LPPe_TimeStamp_networkTime = SEQ(name=u'networkTime', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'NetworkTime')))
    _OMA_LPPe_TimeStamp_relativeTime = INT(name=u'relativeTime', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_TimeStamp_relativeTime._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=1024)], ev=None, er=[])
    OMA_LPPe_TimeStamp._cont = ASN1Dict([
        (u'gnssTime', _OMA_LPPe_TimeStamp_gnssTime),
        (u'networkTime', _OMA_LPPe_TimeStamp_networkTime),
        (u'relativeTime', _OMA_LPPe_TimeStamp_relativeTime),
        ])
    OMA_LPPe_TimeStamp._ext = []
    
    #-----< OMA-LPPe-LocationSource >-----#
    OMA_LPPe_LocationSource = SEQ(name=u'OMA-LPPe-LocationSource', mode=MODE_TYPE)
    _OMA_LPPe_LocationSource_agnss = NULL(name=u'agnss', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_LocationSource_otdoa = NULL(name=u'otdoa', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_LocationSource_eotd = NULL(name=u'eotd', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_LocationSource_otdoaUTRA = NULL(name=u'otdoaUTRA', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_LocationSource_ecidLTE = NULL(name=u'ecidLTE', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_LocationSource_ecidGSM = NULL(name=u'ecidGSM', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_LocationSource_ecidUTRA = NULL(name=u'ecidUTRA', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_LocationSource_wlanAP = NULL(name=u'wlanAP', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_LocationSource_srn = NULL(name=u'srn', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_LocationSource_sensors = NULL(name=u'sensors', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    OMA_LPPe_LocationSource._cont = ASN1Dict([
        (u'agnss', _OMA_LPPe_LocationSource_agnss),
        (u'otdoa', _OMA_LPPe_LocationSource_otdoa),
        (u'eotd', _OMA_LPPe_LocationSource_eotd),
        (u'otdoaUTRA', _OMA_LPPe_LocationSource_otdoaUTRA),
        (u'ecidLTE', _OMA_LPPe_LocationSource_ecidLTE),
        (u'ecidGSM', _OMA_LPPe_LocationSource_ecidGSM),
        (u'ecidUTRA', _OMA_LPPe_LocationSource_ecidUTRA),
        (u'wlanAP', _OMA_LPPe_LocationSource_wlanAP),
        (u'srn', _OMA_LPPe_LocationSource_srn),
        (u'sensors', _OMA_LPPe_LocationSource_sensors),
        ])
    OMA_LPPe_LocationSource._ext = []
    
    #-----< OMA-LPPe-CommonIEsAbort >-----#
    OMA_LPPe_CommonIEsAbort = SEQ(name=u'OMA-LPPe-CommonIEsAbort', mode=MODE_TYPE)
    _OMA_LPPe_CommonIEsAbort_abortCause = ENUM(name=u'abortCause', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_CommonIEsAbort_abortCause._cont = ASN1Dict([(u'periodicADsessionStop', 0), (u'periodicADprocedureNotSupported', 1), (u'periodicADprocedureNotAccepted', 2), (u'periodicLocInfoSessionStop', 3), (u'periodicLocInfoProcedureNotSupported', 4), (u'periodicLocInfoProcedureNotAccepted', 5)])
    _OMA_LPPe_CommonIEsAbort_abortCause._ext = []
    _OMA_LPPe_CommonIEsAbort_periodicSessionIDtoAbort = OCT_STR(name=u'periodicSessionIDtoAbort', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_CommonIEsAbort_periodicSessionIDtoAbort._const_sz = ASN1Set(rv=[4], rr=[], ev=None, er=[])
    OMA_LPPe_CommonIEsAbort._cont = ASN1Dict([
        (u'abortCause', _OMA_LPPe_CommonIEsAbort_abortCause),
        (u'periodicSessionIDtoAbort', _OMA_LPPe_CommonIEsAbort_periodicSessionIDtoAbort),
        ])
    OMA_LPPe_CommonIEsAbort._ext = []
    
    #-----< OMA-LPPe-CommonIEsError >-----#
    OMA_LPPe_CommonIEsError = SEQ(name=u'OMA-LPPe-CommonIEsError', mode=MODE_TYPE)
    OMA_LPPe_CommonIEsError._cont = ASN1Dict([
        ])
    OMA_LPPe_CommonIEsError._ext = []
    
    #-----< OMA-LPPe-AGNSS-ProvideAssistanceData >-----#
    OMA_LPPe_AGNSS_ProvideAssistanceData = SEQ(name=u'OMA-LPPe-AGNSS-ProvideAssistanceData', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_ProvideAssistanceData_commonAssistData = SEQ(name=u'commonAssistData', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-CommonAssistData')), opt=True)
    _OMA_LPPe_AGNSS_ProvideAssistanceData_genericAssistData = SEQ_OF(name=u'genericAssistData', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-GenericAssistData')), opt=True)
    _OMA_LPPe_AGNSS_ProvideAssistanceData_error = CHOICE(name=u'error', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-Error')), opt=True)
    OMA_LPPe_AGNSS_ProvideAssistanceData._cont = ASN1Dict([
        (u'commonAssistData', _OMA_LPPe_AGNSS_ProvideAssistanceData_commonAssistData),
        (u'genericAssistData', _OMA_LPPe_AGNSS_ProvideAssistanceData_genericAssistData),
        (u'error', _OMA_LPPe_AGNSS_ProvideAssistanceData_error),
        ])
    OMA_LPPe_AGNSS_ProvideAssistanceData._ext = []
    
    #-----< OMA-LPPe-AGNSS-CommonAssistData >-----#
    OMA_LPPe_AGNSS_CommonAssistData = SEQ(name=u'OMA-LPPe-AGNSS-CommonAssistData', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_CommonAssistData_ionosphericModel = CHOICE(name=u'ionosphericModel', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-IonosphericModel')), opt=True)
    _OMA_LPPe_AGNSS_CommonAssistData_troposphereModel = SEQ(name=u'troposphereModel', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-TroposphereModel')), opt=True)
    _OMA_LPPe_AGNSS_CommonAssistData_altitudeAssistance = SEQ_OF(name=u'altitudeAssistance', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-AltitudeAssistanceList')), opt=True)
    _OMA_LPPe_AGNSS_CommonAssistData_solarRadiation = SEQ(name=u'solarRadiation', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-SolarRadiation')), opt=True)
    _OMA_LPPe_AGNSS_CommonAssistData_ccpAssistCommonProvide = CHOICE(name=u'ccpAssistCommonProvide', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-CCPassistCommonProvide')), opt=True)
    OMA_LPPe_AGNSS_CommonAssistData._cont = ASN1Dict([
        (u'ionosphericModel', _OMA_LPPe_AGNSS_CommonAssistData_ionosphericModel),
        (u'troposphereModel', _OMA_LPPe_AGNSS_CommonAssistData_troposphereModel),
        (u'altitudeAssistance', _OMA_LPPe_AGNSS_CommonAssistData_altitudeAssistance),
        (u'solarRadiation', _OMA_LPPe_AGNSS_CommonAssistData_solarRadiation),
        (u'ccpAssistCommonProvide', _OMA_LPPe_AGNSS_CommonAssistData_ccpAssistCommonProvide),
        ])
    OMA_LPPe_AGNSS_CommonAssistData._ext = []
    
    #-----< OMA-LPPe-AGNSS-GenericAssistData >-----#
    OMA_LPPe_AGNSS_GenericAssistData = SEQ_OF(name=u'OMA-LPPe-AGNSS-GenericAssistData', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_GenericAssistData__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-GenericAssistDataElement')))
    OMA_LPPe_AGNSS_GenericAssistData._cont = _OMA_LPPe_AGNSS_GenericAssistData__item_
    OMA_LPPe_AGNSS_GenericAssistData._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    
    #-----< OMA-LPPe-AGNSS-GenericAssistDataElement >-----#
    OMA_LPPe_AGNSS_GenericAssistDataElement = SEQ(name=u'OMA-LPPe-AGNSS-GenericAssistDataElement', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_GenericAssistDataElement_gnss_ID = SEQ(name=u'gnss-ID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-ID')))
    _OMA_LPPe_AGNSS_GenericAssistDataElement_wideAreaIonoSurfacePerSVlist = SEQ_OF(name=u'wideAreaIonoSurfacePerSVlist', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-WideAreaIonoSurfacePerSVlist')), opt=True)
    _OMA_LPPe_AGNSS_GenericAssistDataElement_mechanicsForAllSVs = SEQ_OF(name=u'mechanicsForAllSVs', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-MechanicsForAllSVs')), opt=True)
    _OMA_LPPe_AGNSS_GenericAssistDataElement_dcbsForAllSVs = SEQ_OF(name=u'dcbsForAllSVs', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-DCBsForAllSVs')), opt=True)
    _OMA_LPPe_AGNSS_GenericAssistDataElement_navModelDegradationModel = SEQ_OF(name=u'navModelDegradationModel', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-NavModelDegradationModelList')), opt=True)
    _OMA_LPPe_AGNSS_GenericAssistDataElement_ccpAssistProvide = SEQ_OF(name=u'ccpAssistProvide', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-CCPassistGenericProvide')), opt=True)
    _OMA_LPPe_AGNSS_GenericAssistDataElement_navModelList = SEQ(name=u'navModelList', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-NavModelList')), opt=True)
    OMA_LPPe_AGNSS_GenericAssistDataElement._cont = ASN1Dict([
        (u'gnss-ID', _OMA_LPPe_AGNSS_GenericAssistDataElement_gnss_ID),
        (u'wideAreaIonoSurfacePerSVlist', _OMA_LPPe_AGNSS_GenericAssistDataElement_wideAreaIonoSurfacePerSVlist),
        (u'mechanicsForAllSVs', _OMA_LPPe_AGNSS_GenericAssistDataElement_mechanicsForAllSVs),
        (u'dcbsForAllSVs', _OMA_LPPe_AGNSS_GenericAssistDataElement_dcbsForAllSVs),
        (u'navModelDegradationModel', _OMA_LPPe_AGNSS_GenericAssistDataElement_navModelDegradationModel),
        (u'ccpAssistProvide', _OMA_LPPe_AGNSS_GenericAssistDataElement_ccpAssistProvide),
        (u'navModelList', _OMA_LPPe_AGNSS_GenericAssistDataElement_navModelList),
        ])
    OMA_LPPe_AGNSS_GenericAssistDataElement._ext = []
    
    #-----< OMA-LPPe-AGNSS-IonosphericModel >-----#
    OMA_LPPe_AGNSS_IonosphericModel = CHOICE(name=u'OMA-LPPe-AGNSS-IonosphericModel', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_IonosphericModel_staticModels = SEQ(name=u'staticModels', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_AGNSS_IonosphericModel_staticModels_localKlobucharModelList = SEQ_OF(name=u'localKlobucharModelList', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-LocalKlobucharModelList')), opt=True)
    __OMA_LPPe_AGNSS_IonosphericModel_staticModels_ionoStormIndication = SEQ(name=u'ionoStormIndication', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-IonoStormIndication')), opt=True)
    _OMA_LPPe_AGNSS_IonosphericModel_staticModels._cont = ASN1Dict([
        (u'localKlobucharModelList', __OMA_LPPe_AGNSS_IonosphericModel_staticModels_localKlobucharModelList),
        (u'ionoStormIndication', __OMA_LPPe_AGNSS_IonosphericModel_staticModels_ionoStormIndication),
        ])
    _OMA_LPPe_AGNSS_IonosphericModel_staticModels._ext = []
    _OMA_LPPe_AGNSS_IonosphericModel_waIono = CHOICE(name=u'waIono', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __OMA_LPPe_AGNSS_IonosphericModel_waIono_controlParameters = SEQ(name=u'controlParameters', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-WideAreaIonoSurfaceControlParametersProvide')))
    __OMA_LPPe_AGNSS_IonosphericModel_waIono_commonProvide = SEQ(name=u'commonProvide', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-WideAreaIonoSurfaceCommon')))
    _OMA_LPPe_AGNSS_IonosphericModel_waIono._cont = ASN1Dict([
        (u'controlParameters', __OMA_LPPe_AGNSS_IonosphericModel_waIono_controlParameters),
        (u'commonProvide', __OMA_LPPe_AGNSS_IonosphericModel_waIono_commonProvide),
        ])
    _OMA_LPPe_AGNSS_IonosphericModel_waIono._ext = []
    OMA_LPPe_AGNSS_IonosphericModel._cont = ASN1Dict([
        (u'staticModels', _OMA_LPPe_AGNSS_IonosphericModel_staticModels),
        (u'waIono', _OMA_LPPe_AGNSS_IonosphericModel_waIono),
        ])
    OMA_LPPe_AGNSS_IonosphericModel._ext = []
    
    #-----< OMA-LPPe-AGNSS-LocalKlobucharModelList >-----#
    OMA_LPPe_AGNSS_LocalKlobucharModelList = SEQ_OF(name=u'OMA-LPPe-AGNSS-LocalKlobucharModelList', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_LocalKlobucharModelList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-LocalKlobucharModelElement')))
    OMA_LPPe_AGNSS_LocalKlobucharModelList._cont = _OMA_LPPe_AGNSS_LocalKlobucharModelList__item_
    OMA_LPPe_AGNSS_LocalKlobucharModelList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    
    #-----< OMA-LPPe-AGNSS-LocalKlobucharModelElement >-----#
    OMA_LPPe_AGNSS_LocalKlobucharModelElement = SEQ(name=u'OMA-LPPe-AGNSS-LocalKlobucharModelElement', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_LocalKlobucharModelElement_validityArea = SEQ(name=u'validityArea', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ValidityArea')))
    _OMA_LPPe_AGNSS_LocalKlobucharModelElement_klobucharModel = SEQ_OF(name=u'klobucharModel', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_AGNSS_LocalKlobucharModelElement_klobucharModel__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-LocalKlobucharModel')))
    _OMA_LPPe_AGNSS_LocalKlobucharModelElement_klobucharModel._cont = __OMA_LPPe_AGNSS_LocalKlobucharModelElement_klobucharModel__item_
    _OMA_LPPe_AGNSS_LocalKlobucharModelElement_klobucharModel._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    OMA_LPPe_AGNSS_LocalKlobucharModelElement._cont = ASN1Dict([
        (u'validityArea', _OMA_LPPe_AGNSS_LocalKlobucharModelElement_validityArea),
        (u'klobucharModel', _OMA_LPPe_AGNSS_LocalKlobucharModelElement_klobucharModel),
        ])
    OMA_LPPe_AGNSS_LocalKlobucharModelElement._ext = []
    
    #-----< OMA-LPPe-AGNSS-LocalKlobucharModel >-----#
    OMA_LPPe_AGNSS_LocalKlobucharModel = SEQ(name=u'OMA-LPPe-AGNSS-LocalKlobucharModel', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_LocalKlobucharModel_validityPeriod = SEQ(name=u'validityPeriod', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ValidityPeriod')))
    _OMA_LPPe_AGNSS_LocalKlobucharModel_alfa0 = INT(name=u'alfa0', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_LocalKlobucharModel_alfa0._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-128, ub=127)], ev=None, er=[])
    _OMA_LPPe_AGNSS_LocalKlobucharModel_alfa1 = INT(name=u'alfa1', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_LocalKlobucharModel_alfa1._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-128, ub=127)], ev=None, er=[])
    _OMA_LPPe_AGNSS_LocalKlobucharModel_alfa2 = INT(name=u'alfa2', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_LocalKlobucharModel_alfa2._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-128, ub=127)], ev=None, er=[])
    _OMA_LPPe_AGNSS_LocalKlobucharModel_alfa3 = INT(name=u'alfa3', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_LocalKlobucharModel_alfa3._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-128, ub=127)], ev=None, er=[])
    _OMA_LPPe_AGNSS_LocalKlobucharModel_beta0 = INT(name=u'beta0', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_LocalKlobucharModel_beta0._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-128, ub=127)], ev=None, er=[])
    _OMA_LPPe_AGNSS_LocalKlobucharModel_beta1 = INT(name=u'beta1', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_LocalKlobucharModel_beta1._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-128, ub=127)], ev=None, er=[])
    _OMA_LPPe_AGNSS_LocalKlobucharModel_beta2 = INT(name=u'beta2', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_LocalKlobucharModel_beta2._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-128, ub=127)], ev=None, er=[])
    _OMA_LPPe_AGNSS_LocalKlobucharModel_beta3 = INT(name=u'beta3', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_LocalKlobucharModel_beta3._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-128, ub=127)], ev=None, er=[])
    OMA_LPPe_AGNSS_LocalKlobucharModel._cont = ASN1Dict([
        (u'validityPeriod', _OMA_LPPe_AGNSS_LocalKlobucharModel_validityPeriod),
        (u'alfa0', _OMA_LPPe_AGNSS_LocalKlobucharModel_alfa0),
        (u'alfa1', _OMA_LPPe_AGNSS_LocalKlobucharModel_alfa1),
        (u'alfa2', _OMA_LPPe_AGNSS_LocalKlobucharModel_alfa2),
        (u'alfa3', _OMA_LPPe_AGNSS_LocalKlobucharModel_alfa3),
        (u'beta0', _OMA_LPPe_AGNSS_LocalKlobucharModel_beta0),
        (u'beta1', _OMA_LPPe_AGNSS_LocalKlobucharModel_beta1),
        (u'beta2', _OMA_LPPe_AGNSS_LocalKlobucharModel_beta2),
        (u'beta3', _OMA_LPPe_AGNSS_LocalKlobucharModel_beta3),
        ])
    OMA_LPPe_AGNSS_LocalKlobucharModel._ext = []
    
    #-----< OMA-LPPe-AGNSS-IonoStormIndication >-----#
    OMA_LPPe_AGNSS_IonoStormIndication = SEQ(name=u'OMA-LPPe-AGNSS-IonoStormIndication', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_IonoStormIndication_area = SEQ(name=u'area', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ValidityArea')))
    _OMA_LPPe_AGNSS_IonoStormIndication_stormList = SEQ_OF(name=u'stormList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-StormList')))
    OMA_LPPe_AGNSS_IonoStormIndication._cont = ASN1Dict([
        (u'area', _OMA_LPPe_AGNSS_IonoStormIndication_area),
        (u'stormList', _OMA_LPPe_AGNSS_IonoStormIndication_stormList),
        ])
    OMA_LPPe_AGNSS_IonoStormIndication._ext = []
    
    #-----< OMA-LPPe-AGNSS-StormList >-----#
    OMA_LPPe_AGNSS_StormList = SEQ_OF(name=u'OMA-LPPe-AGNSS-StormList', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_StormList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-StormElement')))
    OMA_LPPe_AGNSS_StormList._cont = _OMA_LPPe_AGNSS_StormList__item_
    OMA_LPPe_AGNSS_StormList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    
    #-----< OMA-LPPe-AGNSS-StormElement >-----#
    OMA_LPPe_AGNSS_StormElement = SEQ(name=u'OMA-LPPe-AGNSS-StormElement', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_StormElement_validityPeriod = SEQ(name=u'validityPeriod', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ValidityPeriod')))
    _OMA_LPPe_AGNSS_StormElement_rleListIono = SEQ_OF(name=u'rleListIono', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-RleListIono')))
    OMA_LPPe_AGNSS_StormElement._cont = ASN1Dict([
        (u'validityPeriod', _OMA_LPPe_AGNSS_StormElement_validityPeriod),
        (u'rleListIono', _OMA_LPPe_AGNSS_StormElement_rleListIono),
        ])
    OMA_LPPe_AGNSS_StormElement._ext = []
    
    #-----< OMA-LPPe-AGNSS-RleListIono >-----#
    OMA_LPPe_AGNSS_RleListIono = SEQ_OF(name=u'OMA-LPPe-AGNSS-RleListIono', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_RleListIono__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-RleIonoElement')))
    OMA_LPPe_AGNSS_RleListIono._cont = _OMA_LPPe_AGNSS_RleListIono__item_
    OMA_LPPe_AGNSS_RleListIono._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    
    #-----< OMA-LPPe-AGNSS-RleIonoElement >-----#
    OMA_LPPe_AGNSS_RleIonoElement = SEQ(name=u'OMA-LPPe-AGNSS-RleIonoElement', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_RleIonoElement_regionCount = INT(name=u'regionCount', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_RleIonoElement_regionCount._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _OMA_LPPe_AGNSS_RleIonoElement_ionoIndex = CHOICE(name=u'ionoIndex', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __OMA_LPPe_AGNSS_RleIonoElement_ionoIndex_noaaScales = ENUM(name=u'noaaScales', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-NoaaScales')))
    _OMA_LPPe_AGNSS_RleIonoElement_ionoIndex._cont = ASN1Dict([
        (u'noaaScales', __OMA_LPPe_AGNSS_RleIonoElement_ionoIndex_noaaScales),
        ])
    _OMA_LPPe_AGNSS_RleIonoElement_ionoIndex._ext = []
    OMA_LPPe_AGNSS_RleIonoElement._cont = ASN1Dict([
        (u'regionCount', _OMA_LPPe_AGNSS_RleIonoElement_regionCount),
        (u'ionoIndex', _OMA_LPPe_AGNSS_RleIonoElement_ionoIndex),
        ])
    OMA_LPPe_AGNSS_RleIonoElement._ext = []
    
    #-----< OMA-LPPe-AGNSS-NoaaScales >-----#
    OMA_LPPe_AGNSS_NoaaScales = ENUM(name=u'OMA-LPPe-AGNSS-NoaaScales', mode=MODE_TYPE)
    OMA_LPPe_AGNSS_NoaaScales._cont = ASN1Dict([(u'g1', 0), (u'g2', 1), (u'g3', 2), (u'g4', 3), (u'g5', 4), (u'unknown', 5), (u'none', 6)])
    OMA_LPPe_AGNSS_NoaaScales._ext = []
    
    #-----< OMA-LPPe-AGNSS-WideAreaIonoSurfaceControlParametersProvide >-----#
    OMA_LPPe_AGNSS_WideAreaIonoSurfaceControlParametersProvide = SEQ(name=u'OMA-LPPe-AGNSS-WideAreaIonoSurfaceControlParametersProvide', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_WideAreaIonoSurfaceControlParametersProvide_duration = SEQ(name=u'duration', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-Duration')), opt=True)
    _OMA_LPPe_AGNSS_WideAreaIonoSurfaceControlParametersProvide_rate = INT(name=u'rate', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_WideAreaIonoSurfaceControlParametersProvide_rate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _OMA_LPPe_AGNSS_WideAreaIonoSurfaceControlParametersProvide_referencePosition = SEQ(name=u'referencePosition', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'Ellipsoid-Point')), opt=True)
    _OMA_LPPe_AGNSS_WideAreaIonoSurfaceControlParametersProvide_validityArea = SEQ(name=u'validityArea', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ValidityArea')), opt=True)
    OMA_LPPe_AGNSS_WideAreaIonoSurfaceControlParametersProvide._cont = ASN1Dict([
        (u'duration', _OMA_LPPe_AGNSS_WideAreaIonoSurfaceControlParametersProvide_duration),
        (u'rate', _OMA_LPPe_AGNSS_WideAreaIonoSurfaceControlParametersProvide_rate),
        (u'referencePosition', _OMA_LPPe_AGNSS_WideAreaIonoSurfaceControlParametersProvide_referencePosition),
        (u'validityArea', _OMA_LPPe_AGNSS_WideAreaIonoSurfaceControlParametersProvide_validityArea),
        ])
    OMA_LPPe_AGNSS_WideAreaIonoSurfaceControlParametersProvide._ext = []
    
    #-----< OMA-LPPe-AGNSS-WideAreaIonoSurfaceCommon >-----#
    OMA_LPPe_AGNSS_WideAreaIonoSurfaceCommon = SEQ(name=u'OMA-LPPe-AGNSS-WideAreaIonoSurfaceCommon', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_WideAreaIonoSurfaceCommon_validityPeriod = SEQ(name=u'validityPeriod', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ValidityPeriod')))
    OMA_LPPe_AGNSS_WideAreaIonoSurfaceCommon._cont = ASN1Dict([
        (u'validityPeriod', _OMA_LPPe_AGNSS_WideAreaIonoSurfaceCommon_validityPeriod),
        ])
    OMA_LPPe_AGNSS_WideAreaIonoSurfaceCommon._ext = []
    
    #-----< OMA-LPPe-AGNSS-WideAreaIonoSurfacePerSVlist >-----#
    OMA_LPPe_AGNSS_WideAreaIonoSurfacePerSVlist = SEQ_OF(name=u'OMA-LPPe-AGNSS-WideAreaIonoSurfacePerSVlist', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_WideAreaIonoSurfacePerSVlist__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-WideAreaIonoSurfacePerSVelement')))
    OMA_LPPe_AGNSS_WideAreaIonoSurfacePerSVlist._cont = _OMA_LPPe_AGNSS_WideAreaIonoSurfacePerSVlist__item_
    OMA_LPPe_AGNSS_WideAreaIonoSurfacePerSVlist._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    
    #-----< OMA-LPPe-AGNSS-WideAreaIonoSurfacePerSVelement >-----#
    OMA_LPPe_AGNSS_WideAreaIonoSurfacePerSVelement = SEQ(name=u'OMA-LPPe-AGNSS-WideAreaIonoSurfacePerSVelement', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_WideAreaIonoSurfacePerSVelement_svID = SEQ(name=u'svID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'SV-ID')))
    _OMA_LPPe_AGNSS_WideAreaIonoSurfacePerSVelement_a0 = INT(name=u'a0', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_WideAreaIonoSurfacePerSVelement_a0._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=8191)], ev=None, er=[])
    _OMA_LPPe_AGNSS_WideAreaIonoSurfacePerSVelement_e1 = INT(name=u'e1', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_WideAreaIonoSurfacePerSVelement_e1._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-4096, ub=4095)], ev=None, er=[])
    _OMA_LPPe_AGNSS_WideAreaIonoSurfacePerSVelement_n1 = INT(name=u'n1', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_WideAreaIonoSurfacePerSVelement_n1._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-4096, ub=4095)], ev=None, er=[])
    _OMA_LPPe_AGNSS_WideAreaIonoSurfacePerSVelement_e2 = INT(name=u'e2', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_WideAreaIonoSurfacePerSVelement_e2._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-4096, ub=4095)], ev=None, er=[])
    _OMA_LPPe_AGNSS_WideAreaIonoSurfacePerSVelement_n2 = INT(name=u'n2', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_WideAreaIonoSurfacePerSVelement_n2._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-4096, ub=4095)], ev=None, er=[])
    _OMA_LPPe_AGNSS_WideAreaIonoSurfacePerSVelement_en = INT(name=u'en', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_WideAreaIonoSurfacePerSVelement_en._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-4096, ub=4095)], ev=None, er=[])
    OMA_LPPe_AGNSS_WideAreaIonoSurfacePerSVelement._cont = ASN1Dict([
        (u'svID', _OMA_LPPe_AGNSS_WideAreaIonoSurfacePerSVelement_svID),
        (u'a0', _OMA_LPPe_AGNSS_WideAreaIonoSurfacePerSVelement_a0),
        (u'e1', _OMA_LPPe_AGNSS_WideAreaIonoSurfacePerSVelement_e1),
        (u'n1', _OMA_LPPe_AGNSS_WideAreaIonoSurfacePerSVelement_n1),
        (u'e2', _OMA_LPPe_AGNSS_WideAreaIonoSurfacePerSVelement_e2),
        (u'n2', _OMA_LPPe_AGNSS_WideAreaIonoSurfacePerSVelement_n2),
        (u'en', _OMA_LPPe_AGNSS_WideAreaIonoSurfacePerSVelement_en),
        ])
    OMA_LPPe_AGNSS_WideAreaIonoSurfacePerSVelement._ext = []
    
    #-----< OMA-LPPe-AGNSS-TroposphereModel >-----#
    OMA_LPPe_AGNSS_TroposphereModel = SEQ(name=u'OMA-LPPe-AGNSS-TroposphereModel', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_TroposphereModel_troposphereDelayList = SEQ_OF(name=u'troposphereDelayList', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-LocalTroposphereDelayList')), opt=True)
    _OMA_LPPe_AGNSS_TroposphereModel_surfaceParametersList = SEQ_OF(name=u'surfaceParametersList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-LocalSurfaceParametersList')), opt=True)
    OMA_LPPe_AGNSS_TroposphereModel._cont = ASN1Dict([
        (u'troposphereDelayList', _OMA_LPPe_AGNSS_TroposphereModel_troposphereDelayList),
        (u'surfaceParametersList', _OMA_LPPe_AGNSS_TroposphereModel_surfaceParametersList),
        ])
    OMA_LPPe_AGNSS_TroposphereModel._ext = []
    
    #-----< OMA-LPPe-AGNSS-LocalTroposphereDelayList >-----#
    OMA_LPPe_AGNSS_LocalTroposphereDelayList = SEQ_OF(name=u'OMA-LPPe-AGNSS-LocalTroposphereDelayList', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_LocalTroposphereDelayList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-LocalTroposphereDelayAreaElement')))
    OMA_LPPe_AGNSS_LocalTroposphereDelayList._cont = _OMA_LPPe_AGNSS_LocalTroposphereDelayList__item_
    OMA_LPPe_AGNSS_LocalTroposphereDelayList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    
    #-----< OMA-LPPe-AGNSS-LocalTroposphereDelayAreaElement >-----#
    OMA_LPPe_AGNSS_LocalTroposphereDelayAreaElement = SEQ(name=u'OMA-LPPe-AGNSS-LocalTroposphereDelayAreaElement', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_LocalTroposphereDelayAreaElement_validityArea = SEQ(name=u'validityArea', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ValidityArea')))
    _OMA_LPPe_AGNSS_LocalTroposphereDelayAreaElement_refAltitude = INT(name=u'refAltitude', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_LocalTroposphereDelayAreaElement_refAltitude._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-1000, ub=8192)], ev=None, er=[])
    _OMA_LPPe_AGNSS_LocalTroposphereDelayAreaElement_gradientReferencePosition = SEQ(name=u'gradientReferencePosition', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'Ellipsoid-Point')), opt=True)
    _OMA_LPPe_AGNSS_LocalTroposphereDelayAreaElement_delayList = SEQ_OF(name=u'delayList', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_AGNSS_LocalTroposphereDelayAreaElement_delayList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-LocalTroposphereDelayTimeElement')))
    _OMA_LPPe_AGNSS_LocalTroposphereDelayAreaElement_delayList._cont = __OMA_LPPe_AGNSS_LocalTroposphereDelayAreaElement_delayList__item_
    _OMA_LPPe_AGNSS_LocalTroposphereDelayAreaElement_delayList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    OMA_LPPe_AGNSS_LocalTroposphereDelayAreaElement._cont = ASN1Dict([
        (u'validityArea', _OMA_LPPe_AGNSS_LocalTroposphereDelayAreaElement_validityArea),
        (u'refAltitude', _OMA_LPPe_AGNSS_LocalTroposphereDelayAreaElement_refAltitude),
        (u'gradientReferencePosition', _OMA_LPPe_AGNSS_LocalTroposphereDelayAreaElement_gradientReferencePosition),
        (u'delayList', _OMA_LPPe_AGNSS_LocalTroposphereDelayAreaElement_delayList),
        ])
    OMA_LPPe_AGNSS_LocalTroposphereDelayAreaElement._ext = []
    
    #-----< OMA-LPPe-AGNSS-LocalTroposphereDelayTimeElement >-----#
    OMA_LPPe_AGNSS_LocalTroposphereDelayTimeElement = SEQ(name=u'OMA-LPPe-AGNSS-LocalTroposphereDelayTimeElement', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_LocalTroposphereDelayTimeElement_validityPeriod = SEQ(name=u'validityPeriod', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ValidityPeriod')))
    _OMA_LPPe_AGNSS_LocalTroposphereDelayTimeElement_zh0 = INT(name=u'zh0', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_LocalTroposphereDelayTimeElement_zh0._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4095)], ev=None, er=[])
    _OMA_LPPe_AGNSS_LocalTroposphereDelayTimeElement_eh = INT(name=u'eh', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_LocalTroposphereDelayTimeElement_eh._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4095)], ev=None, er=[])
    _OMA_LPPe_AGNSS_LocalTroposphereDelayTimeElement_zw0 = INT(name=u'zw0', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_LocalTroposphereDelayTimeElement_zw0._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4095)], ev=None, er=[])
    _OMA_LPPe_AGNSS_LocalTroposphereDelayTimeElement_ew = INT(name=u'ew', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_LocalTroposphereDelayTimeElement_ew._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4095)], ev=None, er=[])
    _OMA_LPPe_AGNSS_LocalTroposphereDelayTimeElement_gN = INT(name=u'gN', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_LocalTroposphereDelayTimeElement_gN._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-8192, ub=8191)], ev=None, er=[])
    _OMA_LPPe_AGNSS_LocalTroposphereDelayTimeElement_gE = INT(name=u'gE', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_LocalTroposphereDelayTimeElement_gE._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-8192, ub=8191)], ev=None, er=[])
    _OMA_LPPe_AGNSS_LocalTroposphereDelayTimeElement_mappingFunctionParameters = SEQ(name=u'mappingFunctionParameters', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-MappingFunctionParameters')))
    OMA_LPPe_AGNSS_LocalTroposphereDelayTimeElement._cont = ASN1Dict([
        (u'validityPeriod', _OMA_LPPe_AGNSS_LocalTroposphereDelayTimeElement_validityPeriod),
        (u'zh0', _OMA_LPPe_AGNSS_LocalTroposphereDelayTimeElement_zh0),
        (u'eh', _OMA_LPPe_AGNSS_LocalTroposphereDelayTimeElement_eh),
        (u'zw0', _OMA_LPPe_AGNSS_LocalTroposphereDelayTimeElement_zw0),
        (u'ew', _OMA_LPPe_AGNSS_LocalTroposphereDelayTimeElement_ew),
        (u'gN', _OMA_LPPe_AGNSS_LocalTroposphereDelayTimeElement_gN),
        (u'gE', _OMA_LPPe_AGNSS_LocalTroposphereDelayTimeElement_gE),
        (u'mappingFunctionParameters', _OMA_LPPe_AGNSS_LocalTroposphereDelayTimeElement_mappingFunctionParameters),
        ])
    OMA_LPPe_AGNSS_LocalTroposphereDelayTimeElement._ext = []
    
    #-----< OMA-LPPe-AGNSS-LocalSurfaceParametersList >-----#
    OMA_LPPe_AGNSS_LocalSurfaceParametersList = SEQ_OF(name=u'OMA-LPPe-AGNSS-LocalSurfaceParametersList', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_LocalSurfaceParametersList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-LocalSurfaceParametersAreaElement')))
    OMA_LPPe_AGNSS_LocalSurfaceParametersList._cont = _OMA_LPPe_AGNSS_LocalSurfaceParametersList__item_
    OMA_LPPe_AGNSS_LocalSurfaceParametersList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    
    #-----< OMA-LPPe-AGNSS-LocalSurfaceParametersAreaElement >-----#
    OMA_LPPe_AGNSS_LocalSurfaceParametersAreaElement = SEQ(name=u'OMA-LPPe-AGNSS-LocalSurfaceParametersAreaElement', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_LocalSurfaceParametersAreaElement_validityArea = SEQ(name=u'validityArea', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ValidityArea')))
    _OMA_LPPe_AGNSS_LocalSurfaceParametersAreaElement_refAltitude = INT(name=u'refAltitude', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_LocalSurfaceParametersAreaElement_refAltitude._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-1000, ub=8192)], ev=None, er=[])
    _OMA_LPPe_AGNSS_LocalSurfaceParametersAreaElement_gradientReferencePosition = SEQ(name=u'gradientReferencePosition', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'Ellipsoid-Point')), opt=True)
    _OMA_LPPe_AGNSS_LocalSurfaceParametersAreaElement_parameterList = SEQ_OF(name=u'parameterList', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_AGNSS_LocalSurfaceParametersAreaElement_parameterList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-LocalSurfaceParametersTimeElement')))
    _OMA_LPPe_AGNSS_LocalSurfaceParametersAreaElement_parameterList._cont = __OMA_LPPe_AGNSS_LocalSurfaceParametersAreaElement_parameterList__item_
    _OMA_LPPe_AGNSS_LocalSurfaceParametersAreaElement_parameterList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    OMA_LPPe_AGNSS_LocalSurfaceParametersAreaElement._cont = ASN1Dict([
        (u'validityArea', _OMA_LPPe_AGNSS_LocalSurfaceParametersAreaElement_validityArea),
        (u'refAltitude', _OMA_LPPe_AGNSS_LocalSurfaceParametersAreaElement_refAltitude),
        (u'gradientReferencePosition', _OMA_LPPe_AGNSS_LocalSurfaceParametersAreaElement_gradientReferencePosition),
        (u'parameterList', _OMA_LPPe_AGNSS_LocalSurfaceParametersAreaElement_parameterList),
        ])
    OMA_LPPe_AGNSS_LocalSurfaceParametersAreaElement._ext = []
    
    #-----< OMA-LPPe-AGNSS-LocalSurfaceParametersTimeElement >-----#
    OMA_LPPe_AGNSS_LocalSurfaceParametersTimeElement = SEQ(name=u'OMA-LPPe-AGNSS-LocalSurfaceParametersTimeElement', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_LocalSurfaceParametersTimeElement_validityPeriod = SEQ(name=u'validityPeriod', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ValidityPeriod')))
    _OMA_LPPe_AGNSS_LocalSurfaceParametersTimeElement_pressure = INT(name=u'pressure', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_LocalSurfaceParametersTimeElement_pressure._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-1024, ub=1023)], ev=None, er=[])
    _OMA_LPPe_AGNSS_LocalSurfaceParametersTimeElement_pressureRate = INT(name=u'pressureRate', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_LocalSurfaceParametersTimeElement_pressureRate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-128, ub=127)], ev=None, er=[])
    _OMA_LPPe_AGNSS_LocalSurfaceParametersTimeElement_gN_pressure = INT(name=u'gN-pressure', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_LocalSurfaceParametersTimeElement_gN_pressure._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-128, ub=127)], ev=None, er=[])
    _OMA_LPPe_AGNSS_LocalSurfaceParametersTimeElement_gE_pressure = INT(name=u'gE-pressure', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_LocalSurfaceParametersTimeElement_gE_pressure._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-128, ub=127)], ev=None, er=[])
    _OMA_LPPe_AGNSS_LocalSurfaceParametersTimeElement_temperature = INT(name=u'temperature', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_LocalSurfaceParametersTimeElement_temperature._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-64, ub=63)], ev=None, er=[])
    _OMA_LPPe_AGNSS_LocalSurfaceParametersTimeElement_temperatureRate = INT(name=u'temperatureRate', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_LocalSurfaceParametersTimeElement_temperatureRate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-16, ub=16)], ev=None, er=[])
    _OMA_LPPe_AGNSS_LocalSurfaceParametersTimeElement_gN_temperature = INT(name=u'gN-temperature', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_LocalSurfaceParametersTimeElement_gN_temperature._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-8, ub=7)], ev=None, er=[])
    _OMA_LPPe_AGNSS_LocalSurfaceParametersTimeElement_gE_temperature = INT(name=u'gE-temperature', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_LocalSurfaceParametersTimeElement_gE_temperature._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-8, ub=7)], ev=None, er=[])
    _OMA_LPPe_AGNSS_LocalSurfaceParametersTimeElement_mappingFunctionParameters = SEQ(name=u'mappingFunctionParameters', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-MappingFunctionParameters')))
    OMA_LPPe_AGNSS_LocalSurfaceParametersTimeElement._cont = ASN1Dict([
        (u'validityPeriod', _OMA_LPPe_AGNSS_LocalSurfaceParametersTimeElement_validityPeriod),
        (u'pressure', _OMA_LPPe_AGNSS_LocalSurfaceParametersTimeElement_pressure),
        (u'pressureRate', _OMA_LPPe_AGNSS_LocalSurfaceParametersTimeElement_pressureRate),
        (u'gN-pressure', _OMA_LPPe_AGNSS_LocalSurfaceParametersTimeElement_gN_pressure),
        (u'gE-pressure', _OMA_LPPe_AGNSS_LocalSurfaceParametersTimeElement_gE_pressure),
        (u'temperature', _OMA_LPPe_AGNSS_LocalSurfaceParametersTimeElement_temperature),
        (u'temperatureRate', _OMA_LPPe_AGNSS_LocalSurfaceParametersTimeElement_temperatureRate),
        (u'gN-temperature', _OMA_LPPe_AGNSS_LocalSurfaceParametersTimeElement_gN_temperature),
        (u'gE-temperature', _OMA_LPPe_AGNSS_LocalSurfaceParametersTimeElement_gE_temperature),
        (u'mappingFunctionParameters', _OMA_LPPe_AGNSS_LocalSurfaceParametersTimeElement_mappingFunctionParameters),
        ])
    OMA_LPPe_AGNSS_LocalSurfaceParametersTimeElement._ext = []
    
    #-----< OMA-LPPe-AGNSS-MappingFunctionParameters >-----#
    OMA_LPPe_AGNSS_MappingFunctionParameters = SEQ(name=u'OMA-LPPe-AGNSS-MappingFunctionParameters', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_MappingFunctionParameters_ah = INT(name=u'ah', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_MappingFunctionParameters_ah._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=16383)], ev=None, er=[])
    _OMA_LPPe_AGNSS_MappingFunctionParameters_bh = INT(name=u'bh', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_MappingFunctionParameters_bh._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=16383)], ev=None, er=[])
    _OMA_LPPe_AGNSS_MappingFunctionParameters_ch = INT(name=u'ch', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_MappingFunctionParameters_ch._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=16383)], ev=None, er=[])
    _OMA_LPPe_AGNSS_MappingFunctionParameters_aw = INT(name=u'aw', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_MappingFunctionParameters_aw._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=16383)], ev=None, er=[])
    _OMA_LPPe_AGNSS_MappingFunctionParameters_bw = INT(name=u'bw', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_MappingFunctionParameters_bw._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=16383)], ev=None, er=[])
    _OMA_LPPe_AGNSS_MappingFunctionParameters_cw = INT(name=u'cw', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_MappingFunctionParameters_cw._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=16383)], ev=None, er=[])
    OMA_LPPe_AGNSS_MappingFunctionParameters._cont = ASN1Dict([
        (u'ah', _OMA_LPPe_AGNSS_MappingFunctionParameters_ah),
        (u'bh', _OMA_LPPe_AGNSS_MappingFunctionParameters_bh),
        (u'ch', _OMA_LPPe_AGNSS_MappingFunctionParameters_ch),
        (u'aw', _OMA_LPPe_AGNSS_MappingFunctionParameters_aw),
        (u'bw', _OMA_LPPe_AGNSS_MappingFunctionParameters_bw),
        (u'cw', _OMA_LPPe_AGNSS_MappingFunctionParameters_cw),
        ])
    OMA_LPPe_AGNSS_MappingFunctionParameters._ext = []
    
    #-----< OMA-LPPe-AGNSS-AltitudeAssistanceList >-----#
    OMA_LPPe_AGNSS_AltitudeAssistanceList = SEQ_OF(name=u'OMA-LPPe-AGNSS-AltitudeAssistanceList', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_AltitudeAssistanceList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-AltitudeAssistanceAreaElement')))
    OMA_LPPe_AGNSS_AltitudeAssistanceList._cont = _OMA_LPPe_AGNSS_AltitudeAssistanceList__item_
    OMA_LPPe_AGNSS_AltitudeAssistanceList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    
    #-----< OMA-LPPe-AGNSS-AltitudeAssistanceAreaElement >-----#
    OMA_LPPe_AGNSS_AltitudeAssistanceAreaElement = SEQ(name=u'OMA-LPPe-AGNSS-AltitudeAssistanceAreaElement', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_AltitudeAssistanceAreaElement_validityArea = SEQ(name=u'validityArea', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ValidityArea')))
    _OMA_LPPe_AGNSS_AltitudeAssistanceAreaElement_gradientReferencePosition = SEQ(name=u'gradientReferencePosition', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'EllipsoidPointWithAltitudeAndUncertaintyEllipsoid')), opt=True)
    _OMA_LPPe_AGNSS_AltitudeAssistanceAreaElement_refAltitude = INT(name=u'refAltitude', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_AltitudeAssistanceAreaElement_refAltitude._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-1000, ub=8192)], ev=None, er=[])
    _OMA_LPPe_AGNSS_AltitudeAssistanceAreaElement_pressureAssistanceList = SEQ_OF(name=u'pressureAssistanceList', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_AGNSS_AltitudeAssistanceAreaElement_pressureAssistanceList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-PressureAssistanceElement')))
    _OMA_LPPe_AGNSS_AltitudeAssistanceAreaElement_pressureAssistanceList._cont = __OMA_LPPe_AGNSS_AltitudeAssistanceAreaElement_pressureAssistanceList__item_
    _OMA_LPPe_AGNSS_AltitudeAssistanceAreaElement_pressureAssistanceList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    OMA_LPPe_AGNSS_AltitudeAssistanceAreaElement._cont = ASN1Dict([
        (u'validityArea', _OMA_LPPe_AGNSS_AltitudeAssistanceAreaElement_validityArea),
        (u'gradientReferencePosition', _OMA_LPPe_AGNSS_AltitudeAssistanceAreaElement_gradientReferencePosition),
        (u'refAltitude', _OMA_LPPe_AGNSS_AltitudeAssistanceAreaElement_refAltitude),
        (u'pressureAssistanceList', _OMA_LPPe_AGNSS_AltitudeAssistanceAreaElement_pressureAssistanceList),
        ])
    OMA_LPPe_AGNSS_AltitudeAssistanceAreaElement._ext = []
    
    #-----< OMA-LPPe-AGNSS-PressureAssistanceElement >-----#
    OMA_LPPe_AGNSS_PressureAssistanceElement = SEQ(name=u'OMA-LPPe-AGNSS-PressureAssistanceElement', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_PressureAssistanceElement_validityPeriod = SEQ(name=u'validityPeriod', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ValidityPeriod')))
    _OMA_LPPe_AGNSS_PressureAssistanceElement_pressure = INT(name=u'pressure', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_PressureAssistanceElement_pressure._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-1024, ub=1023)], ev=None, er=[])
    _OMA_LPPe_AGNSS_PressureAssistanceElement_pressureRate = INT(name=u'pressureRate', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_PressureAssistanceElement_pressureRate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-128, ub=127)], ev=None, er=[])
    _OMA_LPPe_AGNSS_PressureAssistanceElement_gN = INT(name=u'gN', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_PressureAssistanceElement_gN._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-128, ub=127)], ev=None, er=[])
    _OMA_LPPe_AGNSS_PressureAssistanceElement_gE = INT(name=u'gE', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_PressureAssistanceElement_gE._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-128, ub=127)], ev=None, er=[])
    OMA_LPPe_AGNSS_PressureAssistanceElement._cont = ASN1Dict([
        (u'validityPeriod', _OMA_LPPe_AGNSS_PressureAssistanceElement_validityPeriod),
        (u'pressure', _OMA_LPPe_AGNSS_PressureAssistanceElement_pressure),
        (u'pressureRate', _OMA_LPPe_AGNSS_PressureAssistanceElement_pressureRate),
        (u'gN', _OMA_LPPe_AGNSS_PressureAssistanceElement_gN),
        (u'gE', _OMA_LPPe_AGNSS_PressureAssistanceElement_gE),
        ])
    OMA_LPPe_AGNSS_PressureAssistanceElement._ext = []
    
    #-----< OMA-LPPe-AGNSS-SolarRadiation >-----#
    OMA_LPPe_AGNSS_SolarRadiation = SEQ(name=u'OMA-LPPe-AGNSS-SolarRadiation', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_SolarRadiation_solarRadiation = INT(name=u'solarRadiation', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_SolarRadiation_solarRadiation._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1000, ub=2000)], ev=None, er=[])
    OMA_LPPe_AGNSS_SolarRadiation._cont = ASN1Dict([
        (u'solarRadiation', _OMA_LPPe_AGNSS_SolarRadiation_solarRadiation),
        ])
    OMA_LPPe_AGNSS_SolarRadiation._ext = []
    
    #-----< OMA-LPPe-AGNSS-MechanicsForAllSVs >-----#
    OMA_LPPe_AGNSS_MechanicsForAllSVs = SEQ_OF(name=u'OMA-LPPe-AGNSS-MechanicsForAllSVs', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_MechanicsForAllSVs__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-MechanicsElement')))
    OMA_LPPe_AGNSS_MechanicsForAllSVs._cont = _OMA_LPPe_AGNSS_MechanicsForAllSVs__item_
    OMA_LPPe_AGNSS_MechanicsForAllSVs._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    
    #-----< OMA-LPPe-AGNSS-MechanicsElement >-----#
    OMA_LPPe_AGNSS_MechanicsElement = SEQ(name=u'OMA-LPPe-AGNSS-MechanicsElement', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_MechanicsElement_svid = SEQ(name=u'svid', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'SV-ID')))
    _OMA_LPPe_AGNSS_MechanicsElement_mass = INT(name=u'mass', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_MechanicsElement_mass._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4095)], ev=None, er=[])
    _OMA_LPPe_AGNSS_MechanicsElement_effectiveReflectivityArea = INT(name=u'effectiveReflectivityArea', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_MechanicsElement_effectiveReflectivityArea._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=511)], ev=None, er=[])
    _OMA_LPPe_AGNSS_MechanicsElement_pco = SEQ(name=u'pco', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-PCOelement')), opt=True)
    _OMA_LPPe_AGNSS_MechanicsElement_svInfo = SEQ(name=u'svInfo', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OMA_LPPe_AGNSS_MechanicsElement_svInfo_svType = ENUM(name=u'svType', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-SVtype')))
    __OMA_LPPe_AGNSS_MechanicsElement_svInfo_svNumber = INT(name=u'svNumber', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_AGNSS_MechanicsElement_svInfo_svNumber._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=1000)], ev=None, er=[])
    _OMA_LPPe_AGNSS_MechanicsElement_svInfo._cont = ASN1Dict([
        (u'svType', __OMA_LPPe_AGNSS_MechanicsElement_svInfo_svType),
        (u'svNumber', __OMA_LPPe_AGNSS_MechanicsElement_svInfo_svNumber),
        ])
    _OMA_LPPe_AGNSS_MechanicsElement_svInfo._ext = []
    OMA_LPPe_AGNSS_MechanicsElement._cont = ASN1Dict([
        (u'svid', _OMA_LPPe_AGNSS_MechanicsElement_svid),
        (u'mass', _OMA_LPPe_AGNSS_MechanicsElement_mass),
        (u'effectiveReflectivityArea', _OMA_LPPe_AGNSS_MechanicsElement_effectiveReflectivityArea),
        (u'pco', _OMA_LPPe_AGNSS_MechanicsElement_pco),
        (u'svInfo', _OMA_LPPe_AGNSS_MechanicsElement_svInfo),
        ])
    OMA_LPPe_AGNSS_MechanicsElement._ext = []
    
    #-----< OMA-LPPe-AGNSS-PCOelement >-----#
    OMA_LPPe_AGNSS_PCOelement = SEQ(name=u'OMA-LPPe-AGNSS-PCOelement', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_PCOelement_xOffsetSBF = INT(name=u'xOffsetSBF', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_PCOelement_xOffsetSBF._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-30000, ub=30000)], ev=None, er=[])
    _OMA_LPPe_AGNSS_PCOelement_yOffsetSBF = INT(name=u'yOffsetSBF', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_PCOelement_yOffsetSBF._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-30000, ub=30000)], ev=None, er=[])
    _OMA_LPPe_AGNSS_PCOelement_zOffsetSBF = INT(name=u'zOffsetSBF', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_PCOelement_zOffsetSBF._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-30000, ub=30000)], ev=None, er=[])
    OMA_LPPe_AGNSS_PCOelement._cont = ASN1Dict([
        (u'xOffsetSBF', _OMA_LPPe_AGNSS_PCOelement_xOffsetSBF),
        (u'yOffsetSBF', _OMA_LPPe_AGNSS_PCOelement_yOffsetSBF),
        (u'zOffsetSBF', _OMA_LPPe_AGNSS_PCOelement_zOffsetSBF),
        ])
    OMA_LPPe_AGNSS_PCOelement._ext = []
    
    #-----< OMA-LPPe-AGNSS-SVtype >-----#
    OMA_LPPe_AGNSS_SVtype = ENUM(name=u'OMA-LPPe-AGNSS-SVtype', mode=MODE_TYPE)
    OMA_LPPe_AGNSS_SVtype._cont = ASN1Dict([(u'gpsIIR', 0), (u'gpsIIRM', 1), (u'gpsIIF', 2), (u'gpsIII', 3), (u'glonassM', 4), (u'glonassK1', 5), (u'glonassK2', 6), (u'glonassKM', 7), (u'unknown', 8)])
    OMA_LPPe_AGNSS_SVtype._ext = []
    
    #-----< OMA-LPPe-AGNSS-DCBsForAllSVs >-----#
    OMA_LPPe_AGNSS_DCBsForAllSVs = SEQ_OF(name=u'OMA-LPPe-AGNSS-DCBsForAllSVs', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_DCBsForAllSVs__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-DCBlistElement')))
    OMA_LPPe_AGNSS_DCBsForAllSVs._cont = _OMA_LPPe_AGNSS_DCBsForAllSVs__item_
    OMA_LPPe_AGNSS_DCBsForAllSVs._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    
    #-----< OMA-LPPe-AGNSS-DCBlistElement >-----#
    OMA_LPPe_AGNSS_DCBlistElement = SEQ(name=u'OMA-LPPe-AGNSS-DCBlistElement', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_DCBlistElement_svid = SEQ(name=u'svid', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'SV-ID')))
    _OMA_LPPe_AGNSS_DCBlistElement_reference = SEQ(name=u'reference', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_AGNSS_DCBlistElement_reference_signal = SEQ(name=u'signal', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-SignalID')))
    __OMA_LPPe_AGNSS_DCBlistElement_reference_pd = ENUM(name=u'pd', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_AGNSS_DCBlistElement_reference_pd._cont = ASN1Dict([(u'pilot', 0), (u'data', 1), (u'notapplicable', 2)])
    __OMA_LPPe_AGNSS_DCBlistElement_reference_pd._ext = []
    _OMA_LPPe_AGNSS_DCBlistElement_reference._cont = ASN1Dict([
        (u'signal', __OMA_LPPe_AGNSS_DCBlistElement_reference_signal),
        (u'pd', __OMA_LPPe_AGNSS_DCBlistElement_reference_pd),
        ])
    _OMA_LPPe_AGNSS_DCBlistElement_reference._ext = []
    _OMA_LPPe_AGNSS_DCBlistElement_dcbList = SEQ_OF(name=u'dcbList', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-DCBlist')))
    OMA_LPPe_AGNSS_DCBlistElement._cont = ASN1Dict([
        (u'svid', _OMA_LPPe_AGNSS_DCBlistElement_svid),
        (u'reference', _OMA_LPPe_AGNSS_DCBlistElement_reference),
        (u'dcbList', _OMA_LPPe_AGNSS_DCBlistElement_dcbList),
        ])
    OMA_LPPe_AGNSS_DCBlistElement._ext = []
    
    #-----< OMA-LPPe-AGNSS-DCBlist >-----#
    OMA_LPPe_AGNSS_DCBlist = SEQ_OF(name=u'OMA-LPPe-AGNSS-DCBlist', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_DCBlist__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-DCBelement')))
    OMA_LPPe_AGNSS_DCBlist._cont = _OMA_LPPe_AGNSS_DCBlist__item_
    OMA_LPPe_AGNSS_DCBlist._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    
    #-----< OMA-LPPe-AGNSS-DCBelement >-----#
    OMA_LPPe_AGNSS_DCBelement = SEQ(name=u'OMA-LPPe-AGNSS-DCBelement', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_DCBelement_signal = SEQ(name=u'signal', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-SignalID')))
    _OMA_LPPe_AGNSS_DCBelement_pd = ENUM(name=u'pd', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_DCBelement_pd._cont = ASN1Dict([(u'pilot', 0), (u'data', 1), (u'notapplicable', 2)])
    _OMA_LPPe_AGNSS_DCBelement_pd._ext = []
    _OMA_LPPe_AGNSS_DCBelement_dcb = INT(name=u'dcb', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_DCBelement_dcb._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-4096, ub=4095)], ev=None, er=[])
    OMA_LPPe_AGNSS_DCBelement._cont = ASN1Dict([
        (u'signal', _OMA_LPPe_AGNSS_DCBelement_signal),
        (u'pd', _OMA_LPPe_AGNSS_DCBelement_pd),
        (u'dcb', _OMA_LPPe_AGNSS_DCBelement_dcb),
        ])
    OMA_LPPe_AGNSS_DCBelement._ext = []
    
    #-----< OMA-LPPe-AGNSS-NavModelDegradationModelList >-----#
    OMA_LPPe_AGNSS_NavModelDegradationModelList = SEQ_OF(name=u'OMA-LPPe-AGNSS-NavModelDegradationModelList', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_NavModelDegradationModelList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-NavModelDegradationModelElement')))
    OMA_LPPe_AGNSS_NavModelDegradationModelList._cont = _OMA_LPPe_AGNSS_NavModelDegradationModelList__item_
    OMA_LPPe_AGNSS_NavModelDegradationModelList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    
    #-----< OMA-LPPe-AGNSS-NavModelDegradationModelElement >-----#
    OMA_LPPe_AGNSS_NavModelDegradationModelElement = SEQ(name=u'OMA-LPPe-AGNSS-NavModelDegradationModelElement', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_NavModelDegradationModelElement_svid = SEQ(name=u'svid', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'SV-ID')))
    _OMA_LPPe_AGNSS_NavModelDegradationModelElement_clockDegradationModel = SEQ(name=u'clockDegradationModel', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-ClockModelDegradationModel')))
    _OMA_LPPe_AGNSS_NavModelDegradationModelElement_orbitDegradationModel = SEQ(name=u'orbitDegradationModel', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-OrbitModelDegradationModel')))
    OMA_LPPe_AGNSS_NavModelDegradationModelElement._cont = ASN1Dict([
        (u'svid', _OMA_LPPe_AGNSS_NavModelDegradationModelElement_svid),
        (u'clockDegradationModel', _OMA_LPPe_AGNSS_NavModelDegradationModelElement_clockDegradationModel),
        (u'orbitDegradationModel', _OMA_LPPe_AGNSS_NavModelDegradationModelElement_orbitDegradationModel),
        ])
    OMA_LPPe_AGNSS_NavModelDegradationModelElement._ext = []
    
    #-----< OMA-LPPe-AGNSS-ClockModelDegradationModel >-----#
    OMA_LPPe_AGNSS_ClockModelDegradationModel = SEQ(name=u'OMA-LPPe-AGNSS-ClockModelDegradationModel', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_ClockModelDegradationModel_clockRMS0 = INT(name=u'clockRMS0', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_ClockModelDegradationModel_clockRMS0._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=31)], ev=None, er=[])
    _OMA_LPPe_AGNSS_ClockModelDegradationModel_clockRMS1 = INT(name=u'clockRMS1', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_ClockModelDegradationModel_clockRMS1._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=7)], ev=None, er=[])
    OMA_LPPe_AGNSS_ClockModelDegradationModel._cont = ASN1Dict([
        (u'clockRMS0', _OMA_LPPe_AGNSS_ClockModelDegradationModel_clockRMS0),
        (u'clockRMS1', _OMA_LPPe_AGNSS_ClockModelDegradationModel_clockRMS1),
        ])
    OMA_LPPe_AGNSS_ClockModelDegradationModel._ext = []
    
    #-----< OMA-LPPe-AGNSS-OrbitModelDegradationModel >-----#
    OMA_LPPe_AGNSS_OrbitModelDegradationModel = SEQ(name=u'OMA-LPPe-AGNSS-OrbitModelDegradationModel', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_OrbitModelDegradationModel_orbitRMS0 = INT(name=u'orbitRMS0', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_OrbitModelDegradationModel_orbitRMS0._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=31)], ev=None, er=[])
    _OMA_LPPe_AGNSS_OrbitModelDegradationModel_orbitRMS1 = INT(name=u'orbitRMS1', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_OrbitModelDegradationModel_orbitRMS1._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=7)], ev=None, er=[])
    OMA_LPPe_AGNSS_OrbitModelDegradationModel._cont = ASN1Dict([
        (u'orbitRMS0', _OMA_LPPe_AGNSS_OrbitModelDegradationModel_orbitRMS0),
        (u'orbitRMS1', _OMA_LPPe_AGNSS_OrbitModelDegradationModel_orbitRMS1),
        ])
    OMA_LPPe_AGNSS_OrbitModelDegradationModel._ext = []
    
    #-----< OMA-LPPe-AGNSS-CCPassistCommonProvide >-----#
    OMA_LPPe_AGNSS_CCPassistCommonProvide = CHOICE(name=u'OMA-LPPe-AGNSS-CCPassistCommonProvide', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_CCPassistCommonProvide_ccpProvideCommonParameters = SEQ(name=u'ccpProvideCommonParameters', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-CCPprovideCommonParameters')))
    _OMA_LPPe_AGNSS_CCPassistCommonProvide_ccpProvideControlParameters = SEQ(name=u'ccpProvideControlParameters', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-CCPprovideControlParameters')))
    OMA_LPPe_AGNSS_CCPassistCommonProvide._cont = ASN1Dict([
        (u'ccpProvideCommonParameters', _OMA_LPPe_AGNSS_CCPassistCommonProvide_ccpProvideCommonParameters),
        (u'ccpProvideControlParameters', _OMA_LPPe_AGNSS_CCPassistCommonProvide_ccpProvideControlParameters),
        ])
    OMA_LPPe_AGNSS_CCPassistCommonProvide._ext = []
    
    #-----< OMA-LPPe-AGNSS-CCPprovideCommonParameters >-----#
    OMA_LPPe_AGNSS_CCPprovideCommonParameters = SEQ(name=u'OMA-LPPe-AGNSS-CCPprovideCommonParameters', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_CCPprovideCommonParameters_ccpReferenceTime = SEQ(name=u'ccpReferenceTime', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-SystemTime')))
    OMA_LPPe_AGNSS_CCPprovideCommonParameters._cont = ASN1Dict([
        (u'ccpReferenceTime', _OMA_LPPe_AGNSS_CCPprovideCommonParameters_ccpReferenceTime),
        ])
    OMA_LPPe_AGNSS_CCPprovideCommonParameters._ext = []
    
    #-----< OMA-LPPe-AGNSS-CCPprovideControlParameters >-----#
    OMA_LPPe_AGNSS_CCPprovideControlParameters = SEQ(name=u'OMA-LPPe-AGNSS-CCPprovideControlParameters', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_CCPprovideControlParameters_ccpSupportArea = SEQ(name=u'ccpSupportArea', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-CCPsupportArea')), opt=True)
    _OMA_LPPe_AGNSS_CCPprovideControlParameters_ccpNeighborList = SEQ_OF(name=u'ccpNeighborList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-CCPreferenceStationList')), opt=True)
    _OMA_LPPe_AGNSS_CCPprovideControlParameters_duration = SEQ(name=u'duration', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-Duration')), opt=True)
    _OMA_LPPe_AGNSS_CCPprovideControlParameters_rate = INT(name=u'rate', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_CCPprovideControlParameters_rate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _OMA_LPPe_AGNSS_CCPprovideControlParameters_ccpReferenceStationList = SEQ_OF(name=u'ccpReferenceStationList', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-CCPreferenceStationList')), opt=True)
    OMA_LPPe_AGNSS_CCPprovideControlParameters._cont = ASN1Dict([
        (u'ccpSupportArea', _OMA_LPPe_AGNSS_CCPprovideControlParameters_ccpSupportArea),
        (u'ccpNeighborList', _OMA_LPPe_AGNSS_CCPprovideControlParameters_ccpNeighborList),
        (u'duration', _OMA_LPPe_AGNSS_CCPprovideControlParameters_duration),
        (u'rate', _OMA_LPPe_AGNSS_CCPprovideControlParameters_rate),
        (u'ccpReferenceStationList', _OMA_LPPe_AGNSS_CCPprovideControlParameters_ccpReferenceStationList),
        ])
    OMA_LPPe_AGNSS_CCPprovideControlParameters._ext = []
    
    #-----< OMA-LPPe-AGNSS-CCPsupportArea >-----#
    OMA_LPPe_AGNSS_CCPsupportArea = SEQ(name=u'OMA-LPPe-AGNSS-CCPsupportArea', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_CCPsupportArea_areaDescription = SEQ(name=u'areaDescription', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ValidityArea')))
    _OMA_LPPe_AGNSS_CCPsupportArea_signalSupport = SEQ_OF(name=u'signalSupport', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_AGNSS_CCPsupportArea_signalSupport__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-CCPsignalSupport')))
    _OMA_LPPe_AGNSS_CCPsupportArea_signalSupport._cont = __OMA_LPPe_AGNSS_CCPsupportArea_signalSupport__item_
    _OMA_LPPe_AGNSS_CCPsupportArea_signalSupport._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    OMA_LPPe_AGNSS_CCPsupportArea._cont = ASN1Dict([
        (u'areaDescription', _OMA_LPPe_AGNSS_CCPsupportArea_areaDescription),
        (u'signalSupport', _OMA_LPPe_AGNSS_CCPsupportArea_signalSupport),
        ])
    OMA_LPPe_AGNSS_CCPsupportArea._ext = []
    
    #-----< OMA-LPPe-AGNSS-CCPsignalSupport >-----#
    OMA_LPPe_AGNSS_CCPsignalSupport = SEQ(name=u'OMA-LPPe-AGNSS-CCPsignalSupport', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_CCPsignalSupport_gnss = SEQ(name=u'gnss', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-ID')))
    _OMA_LPPe_AGNSS_CCPsignalSupport_signals = SEQ(name=u'signals', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-SignalIDs')))
    OMA_LPPe_AGNSS_CCPsignalSupport._cont = ASN1Dict([
        (u'gnss', _OMA_LPPe_AGNSS_CCPsignalSupport_gnss),
        (u'signals', _OMA_LPPe_AGNSS_CCPsignalSupport_signals),
        ])
    OMA_LPPe_AGNSS_CCPsignalSupport._ext = []
    
    #-----< OMA-LPPe-AGNSS-CCPreferenceStationList >-----#
    OMA_LPPe_AGNSS_CCPreferenceStationList = SEQ_OF(name=u'OMA-LPPe-AGNSS-CCPreferenceStationList', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_CCPreferenceStationList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-CCPreferenceStationElement')))
    OMA_LPPe_AGNSS_CCPreferenceStationList._cont = _OMA_LPPe_AGNSS_CCPreferenceStationList__item_
    OMA_LPPe_AGNSS_CCPreferenceStationList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=8)], ev=None, er=[])
    
    #-----< OMA-LPPe-AGNSS-CCPreferenceStationElement >-----#
    OMA_LPPe_AGNSS_CCPreferenceStationElement = SEQ(name=u'OMA-LPPe-AGNSS-CCPreferenceStationElement', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_CCPreferenceStationElement_referenceStationID = SEQ(name=u'referenceStationID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-CCPreferenceStationID')))
    _OMA_LPPe_AGNSS_CCPreferenceStationElement_referenceStationLocation = SEQ(name=u'referenceStationLocation', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-HighAccuracy3Dposition')))
    _OMA_LPPe_AGNSS_CCPreferenceStationElement_antennaDescription = SEQ(name=u'antennaDescription', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-AntennaDescription')), opt=True)
    OMA_LPPe_AGNSS_CCPreferenceStationElement._cont = ASN1Dict([
        (u'referenceStationID', _OMA_LPPe_AGNSS_CCPreferenceStationElement_referenceStationID),
        (u'referenceStationLocation', _OMA_LPPe_AGNSS_CCPreferenceStationElement_referenceStationLocation),
        (u'antennaDescription', _OMA_LPPe_AGNSS_CCPreferenceStationElement_antennaDescription),
        ])
    OMA_LPPe_AGNSS_CCPreferenceStationElement._ext = []
    
    #-----< OMA-LPPe-AGNSS-CCPassistGenericProvide >-----#
    OMA_LPPe_AGNSS_CCPassistGenericProvide = SEQ_OF(name=u'OMA-LPPe-AGNSS-CCPassistGenericProvide', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_CCPassistGenericProvide__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-CCPassistGenericProvideElement')))
    OMA_LPPe_AGNSS_CCPassistGenericProvide._cont = _OMA_LPPe_AGNSS_CCPassistGenericProvide__item_
    OMA_LPPe_AGNSS_CCPassistGenericProvide._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    
    #-----< OMA-LPPe-AGNSS-CCPassistGenericProvideElement >-----#
    OMA_LPPe_AGNSS_CCPassistGenericProvideElement = SEQ(name=u'OMA-LPPe-AGNSS-CCPassistGenericProvideElement', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_CCPassistGenericProvideElement_referenceStationID = SEQ(name=u'referenceStationID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-CCPreferenceStationID')))
    _OMA_LPPe_AGNSS_CCPassistGenericProvideElement_ccpPerSignalList = SEQ_OF(name=u'ccpPerSignalList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_AGNSS_CCPassistGenericProvideElement_ccpPerSignalList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-CCPperSignalElement')))
    _OMA_LPPe_AGNSS_CCPassistGenericProvideElement_ccpPerSignalList._cont = __OMA_LPPe_AGNSS_CCPassistGenericProvideElement_ccpPerSignalList__item_
    _OMA_LPPe_AGNSS_CCPassistGenericProvideElement_ccpPerSignalList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    OMA_LPPe_AGNSS_CCPassistGenericProvideElement._cont = ASN1Dict([
        (u'referenceStationID', _OMA_LPPe_AGNSS_CCPassistGenericProvideElement_referenceStationID),
        (u'ccpPerSignalList', _OMA_LPPe_AGNSS_CCPassistGenericProvideElement_ccpPerSignalList),
        ])
    OMA_LPPe_AGNSS_CCPassistGenericProvideElement._ext = []
    
    #-----< OMA-LPPe-AGNSS-CCPperSignalElement >-----#
    OMA_LPPe_AGNSS_CCPperSignalElement = SEQ(name=u'OMA-LPPe-AGNSS-CCPperSignalElement', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_CCPperSignalElement_signal_ID = SEQ(name=u'signal-ID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-SignalID')))
    _OMA_LPPe_AGNSS_CCPperSignalElement_ccpPerSVlist = SEQ_OF(name=u'ccpPerSVlist', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_AGNSS_CCPperSignalElement_ccpPerSVlist__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-CCPperSVelement')))
    _OMA_LPPe_AGNSS_CCPperSignalElement_ccpPerSVlist._cont = __OMA_LPPe_AGNSS_CCPperSignalElement_ccpPerSVlist__item_
    _OMA_LPPe_AGNSS_CCPperSignalElement_ccpPerSVlist._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    OMA_LPPe_AGNSS_CCPperSignalElement._cont = ASN1Dict([
        (u'signal-ID', _OMA_LPPe_AGNSS_CCPperSignalElement_signal_ID),
        (u'ccpPerSVlist', _OMA_LPPe_AGNSS_CCPperSignalElement_ccpPerSVlist),
        ])
    OMA_LPPe_AGNSS_CCPperSignalElement._ext = []
    
    #-----< OMA-LPPe-AGNSS-CCPperSVelement >-----#
    OMA_LPPe_AGNSS_CCPperSVelement = SEQ(name=u'OMA-LPPe-AGNSS-CCPperSVelement', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_CCPperSVelement_svID = SEQ(name=u'svID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'SV-ID')))
    _OMA_LPPe_AGNSS_CCPperSVelement_integerCodePhase = INT(name=u'integerCodePhase', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_CCPperSVelement_integerCodePhase._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _OMA_LPPe_AGNSS_CCPperSVelement_codePhase = INT(name=u'codePhase', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_CCPperSVelement_codePhase._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=14989622)], ev=None, er=[])
    _OMA_LPPe_AGNSS_CCPperSVelement_codePhaseError = CHOICE(name=u'codePhaseError', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-CodePhaseError')), opt=True)
    _OMA_LPPe_AGNSS_CCPperSVelement_phaseRangeDelta = INT(name=u'phaseRangeDelta', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_CCPperSVelement_phaseRangeDelta._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-524288, ub=524287)], ev=None, er=[])
    _OMA_LPPe_AGNSS_CCPperSVelement_phaseRangeRMSerror = INT(name=u'phaseRangeRMSerror', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_CCPperSVelement_phaseRangeRMSerror._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    _OMA_LPPe_AGNSS_CCPperSVelement_lockIndicator = BOOL(name=u'lockIndicator', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    OMA_LPPe_AGNSS_CCPperSVelement._cont = ASN1Dict([
        (u'svID', _OMA_LPPe_AGNSS_CCPperSVelement_svID),
        (u'integerCodePhase', _OMA_LPPe_AGNSS_CCPperSVelement_integerCodePhase),
        (u'codePhase', _OMA_LPPe_AGNSS_CCPperSVelement_codePhase),
        (u'codePhaseError', _OMA_LPPe_AGNSS_CCPperSVelement_codePhaseError),
        (u'phaseRangeDelta', _OMA_LPPe_AGNSS_CCPperSVelement_phaseRangeDelta),
        (u'phaseRangeRMSerror', _OMA_LPPe_AGNSS_CCPperSVelement_phaseRangeRMSerror),
        (u'lockIndicator', _OMA_LPPe_AGNSS_CCPperSVelement_lockIndicator),
        ])
    OMA_LPPe_AGNSS_CCPperSVelement._ext = []
    
    #-----< OMA-LPPe-AGNSS-CodePhaseError >-----#
    OMA_LPPe_AGNSS_CodePhaseError = CHOICE(name=u'OMA-LPPe-AGNSS-CodePhaseError', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_CodePhaseError_codePhaseRMSError = INT(name=u'codePhaseRMSError', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_CodePhaseError_codePhaseRMSError._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    _OMA_LPPe_AGNSS_CodePhaseError_cnr = INT(name=u'cnr', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_CodePhaseError_cnr._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    OMA_LPPe_AGNSS_CodePhaseError._cont = ASN1Dict([
        (u'codePhaseRMSError', _OMA_LPPe_AGNSS_CodePhaseError_codePhaseRMSError),
        (u'cnr', _OMA_LPPe_AGNSS_CodePhaseError_cnr),
        ])
    OMA_LPPe_AGNSS_CodePhaseError._ext = []
    
    #-----< OMA-LPPe-AGNSS-NavModelList >-----#
    OMA_LPPe_AGNSS_NavModelList = SEQ(name=u'OMA-LPPe-AGNSS-NavModelList', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_NavModelList_coordinateBased = SEQ(name=u'coordinateBased', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-NavModel-CoordinateBased')), opt=True)
    OMA_LPPe_AGNSS_NavModelList._cont = ASN1Dict([
        (u'coordinateBased', _OMA_LPPe_AGNSS_NavModelList_coordinateBased),
        ])
    OMA_LPPe_AGNSS_NavModelList._ext = []
    
    #-----< OMA-LPPe-AGNSS-NavModel-CoordinateBased >-----#
    OMA_LPPe_AGNSS_NavModel_CoordinateBased = SEQ(name=u'OMA-LPPe-AGNSS-NavModel-CoordinateBased', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_NavModel_CoordinateBased_fixedInterval = SEQ(name=u'fixedInterval', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OMA_LPPe_AGNSS_NavModel_CoordinateBased_fixedInterval_beginTime = SEQ(name=u'beginTime', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-SystemTime')))
    __OMA_LPPe_AGNSS_NavModel_CoordinateBased_fixedInterval_interval = INT(name=u'interval', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_AGNSS_NavModel_CoordinateBased_fixedInterval_interval._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=30)], ev=None, er=[])
    _OMA_LPPe_AGNSS_NavModel_CoordinateBased_fixedInterval._cont = ASN1Dict([
        (u'beginTime', __OMA_LPPe_AGNSS_NavModel_CoordinateBased_fixedInterval_beginTime),
        (u'interval', __OMA_LPPe_AGNSS_NavModel_CoordinateBased_fixedInterval_interval),
        ])
    _OMA_LPPe_AGNSS_NavModel_CoordinateBased_fixedInterval._ext = []
    _OMA_LPPe_AGNSS_NavModel_CoordinateBased_bases = SEQ(name=u'bases', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OMA_LPPe_AGNSS_NavModel_CoordinateBased_bases_baseForPosVel = INT(name=u'baseForPosVel', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OMA_LPPe_AGNSS_NavModel_CoordinateBased_bases_baseForPosVel._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-100000000, ub=100000000)], ev=None, er=[])
    __OMA_LPPe_AGNSS_NavModel_CoordinateBased_bases_baseForCcRate = SEQ(name=u'baseForCcRate', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-NavModel-BigNumber')), opt=True)
    _OMA_LPPe_AGNSS_NavModel_CoordinateBased_bases._cont = ASN1Dict([
        (u'baseForPosVel', __OMA_LPPe_AGNSS_NavModel_CoordinateBased_bases_baseForPosVel),
        (u'baseForCcRate', __OMA_LPPe_AGNSS_NavModel_CoordinateBased_bases_baseForCcRate),
        ])
    _OMA_LPPe_AGNSS_NavModel_CoordinateBased_bases._ext = []
    _OMA_LPPe_AGNSS_NavModel_CoordinateBased_referencedTo = ENUM(name=u'referencedTo', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_NavModel_CoordinateBased_referencedTo._cont = ASN1Dict([(u'centerOfMass', 0), (u'antennaPhaseCenter', 1)])
    _OMA_LPPe_AGNSS_NavModel_CoordinateBased_referencedTo._ext = []
    _OMA_LPPe_AGNSS_NavModel_CoordinateBased_pointList = SEQ_OF(name=u'pointList', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_AGNSS_NavModel_CoordinateBased_pointList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-NavModel-CoordinateBasedElement')))
    _OMA_LPPe_AGNSS_NavModel_CoordinateBased_pointList._cont = __OMA_LPPe_AGNSS_NavModel_CoordinateBased_pointList__item_
    _OMA_LPPe_AGNSS_NavModel_CoordinateBased_pointList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=97)], ev=None, er=[])
    OMA_LPPe_AGNSS_NavModel_CoordinateBased._cont = ASN1Dict([
        (u'fixedInterval', _OMA_LPPe_AGNSS_NavModel_CoordinateBased_fixedInterval),
        (u'bases', _OMA_LPPe_AGNSS_NavModel_CoordinateBased_bases),
        (u'referencedTo', _OMA_LPPe_AGNSS_NavModel_CoordinateBased_referencedTo),
        (u'pointList', _OMA_LPPe_AGNSS_NavModel_CoordinateBased_pointList),
        ])
    OMA_LPPe_AGNSS_NavModel_CoordinateBased._ext = []
    
    #-----< OMA-LPPe-AGNSS-NavModel-CoordinateBasedElement >-----#
    OMA_LPPe_AGNSS_NavModel_CoordinateBasedElement = SEQ(name=u'OMA-LPPe-AGNSS-NavModel-CoordinateBasedElement', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_NavModel_CoordinateBasedElement_time_of_record = SEQ(name=u'time-of-record', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-SystemTime')), opt=True)
    _OMA_LPPe_AGNSS_NavModel_CoordinateBasedElement_svIdList = SEQ_OF(name=u'svIdList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_AGNSS_NavModel_CoordinateBasedElement_svIdList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-NavModel-PVTelement')))
    _OMA_LPPe_AGNSS_NavModel_CoordinateBasedElement_svIdList._cont = __OMA_LPPe_AGNSS_NavModel_CoordinateBasedElement_svIdList__item_
    _OMA_LPPe_AGNSS_NavModel_CoordinateBasedElement_svIdList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    OMA_LPPe_AGNSS_NavModel_CoordinateBasedElement._cont = ASN1Dict([
        (u'time-of-record', _OMA_LPPe_AGNSS_NavModel_CoordinateBasedElement_time_of_record),
        (u'svIdList', _OMA_LPPe_AGNSS_NavModel_CoordinateBasedElement_svIdList),
        ])
    OMA_LPPe_AGNSS_NavModel_CoordinateBasedElement._ext = []
    
    #-----< OMA-LPPe-AGNSS-NavModel-PVTelement >-----#
    OMA_LPPe_AGNSS_NavModel_PVTelement = SEQ(name=u'OMA-LPPe-AGNSS-NavModel-PVTelement', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_NavModel_PVTelement_svID = SEQ(name=u'svID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'SV-ID')))
    _OMA_LPPe_AGNSS_NavModel_PVTelement_svClockOffset = SEQ(name=u'svClockOffset', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-NavModel-BigNumber')))
    _OMA_LPPe_AGNSS_NavModel_PVTelement_ecefPositionX = SEQ(name=u'ecefPositionX', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-NavModel-BigNumber')))
    _OMA_LPPe_AGNSS_NavModel_PVTelement_ecefPositionY = SEQ(name=u'ecefPositionY', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-NavModel-BigNumber')))
    _OMA_LPPe_AGNSS_NavModel_PVTelement_ecefPositionZ = SEQ(name=u'ecefPositionZ', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-NavModel-BigNumber')))
    _OMA_LPPe_AGNSS_NavModel_PVTelement_clockPosSTD = SEQ(name=u'clockPosSTD', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-NavModel-STDmatrix')))
    _OMA_LPPe_AGNSS_NavModel_PVTelement_rateRecord = SEQ(name=u'rateRecord', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OMA_LPPe_AGNSS_NavModel_PVTelement_rateRecord_svClockRate = SEQ(name=u'svClockRate', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-NavModel-BigNumber')))
    __OMA_LPPe_AGNSS_NavModel_PVTelement_rateRecord_ecefVelocityX = SEQ(name=u'ecefVelocityX', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-NavModel-BigNumber')))
    __OMA_LPPe_AGNSS_NavModel_PVTelement_rateRecord_ecefVelocityY = SEQ(name=u'ecefVelocityY', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-NavModel-BigNumber')))
    __OMA_LPPe_AGNSS_NavModel_PVTelement_rateRecord_ecefVelocityZ = SEQ(name=u'ecefVelocityZ', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-NavModel-BigNumber')))
    __OMA_LPPe_AGNSS_NavModel_PVTelement_rateRecord_clockRateVelSTD = SEQ(name=u'clockRateVelSTD', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-NavModel-STDmatrix')))
    _OMA_LPPe_AGNSS_NavModel_PVTelement_rateRecord._cont = ASN1Dict([
        (u'svClockRate', __OMA_LPPe_AGNSS_NavModel_PVTelement_rateRecord_svClockRate),
        (u'ecefVelocityX', __OMA_LPPe_AGNSS_NavModel_PVTelement_rateRecord_ecefVelocityX),
        (u'ecefVelocityY', __OMA_LPPe_AGNSS_NavModel_PVTelement_rateRecord_ecefVelocityY),
        (u'ecefVelocityZ', __OMA_LPPe_AGNSS_NavModel_PVTelement_rateRecord_ecefVelocityZ),
        (u'clockRateVelSTD', __OMA_LPPe_AGNSS_NavModel_PVTelement_rateRecord_clockRateVelSTD),
        ])
    _OMA_LPPe_AGNSS_NavModel_PVTelement_rateRecord._ext = []
    OMA_LPPe_AGNSS_NavModel_PVTelement._cont = ASN1Dict([
        (u'svID', _OMA_LPPe_AGNSS_NavModel_PVTelement_svID),
        (u'svClockOffset', _OMA_LPPe_AGNSS_NavModel_PVTelement_svClockOffset),
        (u'ecefPositionX', _OMA_LPPe_AGNSS_NavModel_PVTelement_ecefPositionX),
        (u'ecefPositionY', _OMA_LPPe_AGNSS_NavModel_PVTelement_ecefPositionY),
        (u'ecefPositionZ', _OMA_LPPe_AGNSS_NavModel_PVTelement_ecefPositionZ),
        (u'clockPosSTD', _OMA_LPPe_AGNSS_NavModel_PVTelement_clockPosSTD),
        (u'rateRecord', _OMA_LPPe_AGNSS_NavModel_PVTelement_rateRecord),
        ])
    OMA_LPPe_AGNSS_NavModel_PVTelement._ext = []
    
    #-----< OMA-LPPe-AGNSS-NavModel-BigNumber >-----#
    OMA_LPPe_AGNSS_NavModel_BigNumber = SEQ(name=u'OMA-LPPe-AGNSS-NavModel-BigNumber', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_NavModel_BigNumber_msb = INT(name=u'msb', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_NavModel_BigNumber_msb._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-1000000000, ub=1000000000)], ev=None, er=[])
    _OMA_LPPe_AGNSS_NavModel_BigNumber_lsb = INT(name=u'lsb', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_NavModel_BigNumber_lsb._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=100)], ev=None, er=[])
    OMA_LPPe_AGNSS_NavModel_BigNumber._cont = ASN1Dict([
        (u'msb', _OMA_LPPe_AGNSS_NavModel_BigNumber_msb),
        (u'lsb', _OMA_LPPe_AGNSS_NavModel_BigNumber_lsb),
        ])
    OMA_LPPe_AGNSS_NavModel_BigNumber._ext = []
    
    #-----< OMA-LPPe-AGNSS-NavModel-STDmatrix >-----#
    OMA_LPPe_AGNSS_NavModel_STDmatrix = SEQ(name=u'OMA-LPPe-AGNSS-NavModel-STDmatrix', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_NavModel_STDmatrix_e11 = INT(name=u'e11', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_NavModel_STDmatrix_e11._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=1000)], ev=None, er=[])
    _OMA_LPPe_AGNSS_NavModel_STDmatrix_e22 = INT(name=u'e22', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_NavModel_STDmatrix_e22._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=1000)], ev=None, er=[])
    _OMA_LPPe_AGNSS_NavModel_STDmatrix_e33 = INT(name=u'e33', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_NavModel_STDmatrix_e33._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=1000)], ev=None, er=[])
    _OMA_LPPe_AGNSS_NavModel_STDmatrix_e44 = INT(name=u'e44', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_NavModel_STDmatrix_e44._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=1000000)], ev=None, er=[])
    _OMA_LPPe_AGNSS_NavModel_STDmatrix_e12 = INT(name=u'e12', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_NavModel_STDmatrix_e12._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=10000000)], ev=None, er=[])
    _OMA_LPPe_AGNSS_NavModel_STDmatrix_e13 = INT(name=u'e13', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_NavModel_STDmatrix_e13._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=10000000)], ev=None, er=[])
    _OMA_LPPe_AGNSS_NavModel_STDmatrix_e14 = INT(name=u'e14', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_NavModel_STDmatrix_e14._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=10000000)], ev=None, er=[])
    _OMA_LPPe_AGNSS_NavModel_STDmatrix_e23 = INT(name=u'e23', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_NavModel_STDmatrix_e23._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=10000000)], ev=None, er=[])
    _OMA_LPPe_AGNSS_NavModel_STDmatrix_e24 = INT(name=u'e24', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_NavModel_STDmatrix_e24._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=10000000)], ev=None, er=[])
    _OMA_LPPe_AGNSS_NavModel_STDmatrix_e34 = INT(name=u'e34', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_NavModel_STDmatrix_e34._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=10000000)], ev=None, er=[])
    OMA_LPPe_AGNSS_NavModel_STDmatrix._cont = ASN1Dict([
        (u'e11', _OMA_LPPe_AGNSS_NavModel_STDmatrix_e11),
        (u'e22', _OMA_LPPe_AGNSS_NavModel_STDmatrix_e22),
        (u'e33', _OMA_LPPe_AGNSS_NavModel_STDmatrix_e33),
        (u'e44', _OMA_LPPe_AGNSS_NavModel_STDmatrix_e44),
        (u'e12', _OMA_LPPe_AGNSS_NavModel_STDmatrix_e12),
        (u'e13', _OMA_LPPe_AGNSS_NavModel_STDmatrix_e13),
        (u'e14', _OMA_LPPe_AGNSS_NavModel_STDmatrix_e14),
        (u'e23', _OMA_LPPe_AGNSS_NavModel_STDmatrix_e23),
        (u'e24', _OMA_LPPe_AGNSS_NavModel_STDmatrix_e24),
        (u'e34', _OMA_LPPe_AGNSS_NavModel_STDmatrix_e34),
        ])
    OMA_LPPe_AGNSS_NavModel_STDmatrix._ext = []
    
    #-----< OMA-LPPe-AGNSS-RequestAssistanceData >-----#
    OMA_LPPe_AGNSS_RequestAssistanceData = SEQ(name=u'OMA-LPPe-AGNSS-RequestAssistanceData', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_RequestAssistanceData_commonAssistDataReq = SEQ(name=u'commonAssistDataReq', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-CommonAssistanceDataReq')), opt=True)
    _OMA_LPPe_AGNSS_RequestAssistanceData_genericAssistDataReq = SEQ_OF(name=u'genericAssistDataReq', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-GenericAssistanceDataReq')), opt=True)
    OMA_LPPe_AGNSS_RequestAssistanceData._cont = ASN1Dict([
        (u'commonAssistDataReq', _OMA_LPPe_AGNSS_RequestAssistanceData_commonAssistDataReq),
        (u'genericAssistDataReq', _OMA_LPPe_AGNSS_RequestAssistanceData_genericAssistDataReq),
        ])
    OMA_LPPe_AGNSS_RequestAssistanceData._ext = []
    
    #-----< OMA-LPPe-AGNSS-CommonAssistanceDataReq >-----#
    OMA_LPPe_AGNSS_CommonAssistanceDataReq = SEQ(name=u'OMA-LPPe-AGNSS-CommonAssistanceDataReq', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_CommonAssistanceDataReq_ionosphericModelReq = CHOICE(name=u'ionosphericModelReq', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-IonosphericModelReq')), opt=True)
    _OMA_LPPe_AGNSS_CommonAssistanceDataReq_troposphereModelReq = SEQ(name=u'troposphereModelReq', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-TroposphereModelReq')), opt=True)
    _OMA_LPPe_AGNSS_CommonAssistanceDataReq_altitudeAssistanceReq = SEQ(name=u'altitudeAssistanceReq', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-AltitudeAssistanceReq')), opt=True)
    _OMA_LPPe_AGNSS_CommonAssistanceDataReq_solarRadiationRequest = SEQ(name=u'solarRadiationRequest', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-SolarRadiationReq')), opt=True)
    _OMA_LPPe_AGNSS_CommonAssistanceDataReq_ccpRequestControlParameters = SEQ(name=u'ccpRequestControlParameters', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-CCPrequestControlParameters')), opt=True)
    OMA_LPPe_AGNSS_CommonAssistanceDataReq._cont = ASN1Dict([
        (u'ionosphericModelReq', _OMA_LPPe_AGNSS_CommonAssistanceDataReq_ionosphericModelReq),
        (u'troposphereModelReq', _OMA_LPPe_AGNSS_CommonAssistanceDataReq_troposphereModelReq),
        (u'altitudeAssistanceReq', _OMA_LPPe_AGNSS_CommonAssistanceDataReq_altitudeAssistanceReq),
        (u'solarRadiationRequest', _OMA_LPPe_AGNSS_CommonAssistanceDataReq_solarRadiationRequest),
        (u'ccpRequestControlParameters', _OMA_LPPe_AGNSS_CommonAssistanceDataReq_ccpRequestControlParameters),
        ])
    OMA_LPPe_AGNSS_CommonAssistanceDataReq._ext = []
    
    #-----< OMA-LPPe-AGNSS-GenericAssistanceDataReq >-----#
    OMA_LPPe_AGNSS_GenericAssistanceDataReq = SEQ_OF(name=u'OMA-LPPe-AGNSS-GenericAssistanceDataReq', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_GenericAssistanceDataReq__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-GenericAssistDataReqElement')))
    OMA_LPPe_AGNSS_GenericAssistanceDataReq._cont = _OMA_LPPe_AGNSS_GenericAssistanceDataReq__item_
    OMA_LPPe_AGNSS_GenericAssistanceDataReq._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    
    #-----< OMA-LPPe-AGNSS-GenericAssistDataReqElement >-----#
    OMA_LPPe_AGNSS_GenericAssistDataReqElement = SEQ(name=u'OMA-LPPe-AGNSS-GenericAssistDataReqElement', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_GenericAssistDataReqElement_gnss_ID = SEQ(name=u'gnss-ID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-ID')))
    _OMA_LPPe_AGNSS_GenericAssistDataReqElement_waIonoSurfaceReq = SEQ(name=u'waIonoSurfaceReq', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-WaIonoSurfaceRequest')), opt=True)
    _OMA_LPPe_AGNSS_GenericAssistDataReqElement_mechanicsReq = SEQ(name=u'mechanicsReq', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-MechanicsReq')), opt=True)
    _OMA_LPPe_AGNSS_GenericAssistDataReqElement_dcbReq = SEQ(name=u'dcbReq', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-DCBreq')), opt=True)
    _OMA_LPPe_AGNSS_GenericAssistDataReqElement_navModelDegradationModelReq = SEQ(name=u'navModelDegradationModelReq', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-NavModelDegradationModelReq')), opt=True)
    _OMA_LPPe_AGNSS_GenericAssistDataReqElement_ccpAssistGenericReq = SEQ(name=u'ccpAssistGenericReq', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-CCPassistGenericReq')), opt=True)
    _OMA_LPPe_AGNSS_GenericAssistDataReqElement_navigationModelReq = SEQ(name=u'navigationModelReq', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-NavigationModelReq')), opt=True)
    OMA_LPPe_AGNSS_GenericAssistDataReqElement._cont = ASN1Dict([
        (u'gnss-ID', _OMA_LPPe_AGNSS_GenericAssistDataReqElement_gnss_ID),
        (u'waIonoSurfaceReq', _OMA_LPPe_AGNSS_GenericAssistDataReqElement_waIonoSurfaceReq),
        (u'mechanicsReq', _OMA_LPPe_AGNSS_GenericAssistDataReqElement_mechanicsReq),
        (u'dcbReq', _OMA_LPPe_AGNSS_GenericAssistDataReqElement_dcbReq),
        (u'navModelDegradationModelReq', _OMA_LPPe_AGNSS_GenericAssistDataReqElement_navModelDegradationModelReq),
        (u'ccpAssistGenericReq', _OMA_LPPe_AGNSS_GenericAssistDataReqElement_ccpAssistGenericReq),
        (u'navigationModelReq', _OMA_LPPe_AGNSS_GenericAssistDataReqElement_navigationModelReq),
        ])
    OMA_LPPe_AGNSS_GenericAssistDataReqElement._ext = []
    
    #-----< OMA-LPPe-AGNSS-IonosphericModelReq >-----#
    OMA_LPPe_AGNSS_IonosphericModelReq = CHOICE(name=u'OMA-LPPe-AGNSS-IonosphericModelReq', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_IonosphericModelReq_staticModels = SEQ(name=u'staticModels', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_AGNSS_IonosphericModelReq_staticModels_ionoreq = BIT_STR(name=u'ionoreq', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_AGNSS_IonosphericModelReq_staticModels_ionoreq._cont = ASN1Dict([(u'klobucharModel', 0), (u'ionoStormWarning', 1)])
    __OMA_LPPe_AGNSS_IonosphericModelReq_staticModels_ionoreq._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    __OMA_LPPe_AGNSS_IonosphericModelReq_staticModels_requestBeginTime = SEQ(name=u'requestBeginTime', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-SystemTime')), opt=True)
    __OMA_LPPe_AGNSS_IonosphericModelReq_staticModels_duration = SEQ(name=u'duration', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-Duration')))
    _OMA_LPPe_AGNSS_IonosphericModelReq_staticModels._cont = ASN1Dict([
        (u'ionoreq', __OMA_LPPe_AGNSS_IonosphericModelReq_staticModels_ionoreq),
        (u'requestBeginTime', __OMA_LPPe_AGNSS_IonosphericModelReq_staticModels_requestBeginTime),
        (u'duration', __OMA_LPPe_AGNSS_IonosphericModelReq_staticModels_duration),
        ])
    _OMA_LPPe_AGNSS_IonosphericModelReq_staticModels._ext = []
    _OMA_LPPe_AGNSS_IonosphericModelReq_periodicModels = SEQ(name=u'periodicModels', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_AGNSS_IonosphericModelReq_periodicModels_waIonoSurface = SEQ(name=u'waIonoSurface', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-WideAreaIonoSurfaceControlParametersRequest')))
    _OMA_LPPe_AGNSS_IonosphericModelReq_periodicModels._cont = ASN1Dict([
        (u'waIonoSurface', __OMA_LPPe_AGNSS_IonosphericModelReq_periodicModels_waIonoSurface),
        ])
    _OMA_LPPe_AGNSS_IonosphericModelReq_periodicModels._ext = []
    OMA_LPPe_AGNSS_IonosphericModelReq._cont = ASN1Dict([
        (u'staticModels', _OMA_LPPe_AGNSS_IonosphericModelReq_staticModels),
        (u'periodicModels', _OMA_LPPe_AGNSS_IonosphericModelReq_periodicModels),
        ])
    OMA_LPPe_AGNSS_IonosphericModelReq._ext = []
    
    #-----< OMA-LPPe-AGNSS-WideAreaIonoSurfaceControlParametersRequest >-----#
    OMA_LPPe_AGNSS_WideAreaIonoSurfaceControlParametersRequest = SEQ(name=u'OMA-LPPe-AGNSS-WideAreaIonoSurfaceControlParametersRequest', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_WideAreaIonoSurfaceControlParametersRequest_duration = SEQ(name=u'duration', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-Duration')), opt=True)
    _OMA_LPPe_AGNSS_WideAreaIonoSurfaceControlParametersRequest_rate = INT(name=u'rate', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_WideAreaIonoSurfaceControlParametersRequest_rate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    OMA_LPPe_AGNSS_WideAreaIonoSurfaceControlParametersRequest._cont = ASN1Dict([
        (u'duration', _OMA_LPPe_AGNSS_WideAreaIonoSurfaceControlParametersRequest_duration),
        (u'rate', _OMA_LPPe_AGNSS_WideAreaIonoSurfaceControlParametersRequest_rate),
        ])
    OMA_LPPe_AGNSS_WideAreaIonoSurfaceControlParametersRequest._ext = []
    
    #-----< OMA-LPPe-AGNSS-TroposphereModelReq >-----#
    OMA_LPPe_AGNSS_TroposphereModelReq = SEQ(name=u'OMA-LPPe-AGNSS-TroposphereModelReq', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_TroposphereModelReq_troposphereModelReq = BIT_STR(name=u'troposphereModelReq', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_TroposphereModelReq_troposphereModelReq._cont = ASN1Dict([(u'delay', 0), (u'surface', 1)])
    _OMA_LPPe_AGNSS_TroposphereModelReq_troposphereModelReq._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    _OMA_LPPe_AGNSS_TroposphereModelReq_supportForMultipleGridPoints = BOOL(name=u'supportForMultipleGridPoints', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_TroposphereModelReq_requestBeginTime = SEQ(name=u'requestBeginTime', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-SystemTime')), opt=True)
    _OMA_LPPe_AGNSS_TroposphereModelReq_duration = SEQ(name=u'duration', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-Duration')))
    OMA_LPPe_AGNSS_TroposphereModelReq._cont = ASN1Dict([
        (u'troposphereModelReq', _OMA_LPPe_AGNSS_TroposphereModelReq_troposphereModelReq),
        (u'supportForMultipleGridPoints', _OMA_LPPe_AGNSS_TroposphereModelReq_supportForMultipleGridPoints),
        (u'requestBeginTime', _OMA_LPPe_AGNSS_TroposphereModelReq_requestBeginTime),
        (u'duration', _OMA_LPPe_AGNSS_TroposphereModelReq_duration),
        ])
    OMA_LPPe_AGNSS_TroposphereModelReq._ext = []
    
    #-----< OMA-LPPe-AGNSS-AltitudeAssistanceReq >-----#
    OMA_LPPe_AGNSS_AltitudeAssistanceReq = SEQ(name=u'OMA-LPPe-AGNSS-AltitudeAssistanceReq', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_AltitudeAssistanceReq_requestBeginTime = SEQ(name=u'requestBeginTime', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-SystemTime')), opt=True)
    _OMA_LPPe_AGNSS_AltitudeAssistanceReq_duration = SEQ(name=u'duration', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-Duration')), opt=True)
    OMA_LPPe_AGNSS_AltitudeAssistanceReq._cont = ASN1Dict([
        (u'requestBeginTime', _OMA_LPPe_AGNSS_AltitudeAssistanceReq_requestBeginTime),
        (u'duration', _OMA_LPPe_AGNSS_AltitudeAssistanceReq_duration),
        ])
    OMA_LPPe_AGNSS_AltitudeAssistanceReq._ext = []
    
    #-----< OMA-LPPe-AGNSS-SolarRadiationReq >-----#
    OMA_LPPe_AGNSS_SolarRadiationReq = SEQ(name=u'OMA-LPPe-AGNSS-SolarRadiationReq', mode=MODE_TYPE)
    OMA_LPPe_AGNSS_SolarRadiationReq._cont = ASN1Dict([
        ])
    OMA_LPPe_AGNSS_SolarRadiationReq._ext = []
    
    #-----< OMA-LPPe-AGNSS-WaIonoSurfaceRequest >-----#
    OMA_LPPe_AGNSS_WaIonoSurfaceRequest = SEQ(name=u'OMA-LPPe-AGNSS-WaIonoSurfaceRequest', mode=MODE_TYPE)
    OMA_LPPe_AGNSS_WaIonoSurfaceRequest._cont = ASN1Dict([
        ])
    OMA_LPPe_AGNSS_WaIonoSurfaceRequest._ext = []
    
    #-----< OMA-LPPe-AGNSS-NavModelDegradationModelReq >-----#
    OMA_LPPe_AGNSS_NavModelDegradationModelReq = SEQ(name=u'OMA-LPPe-AGNSS-NavModelDegradationModelReq', mode=MODE_TYPE)
    OMA_LPPe_AGNSS_NavModelDegradationModelReq._cont = ASN1Dict([
        ])
    OMA_LPPe_AGNSS_NavModelDegradationModelReq._ext = []
    
    #-----< OMA-LPPe-AGNSS-DCBreq >-----#
    OMA_LPPe_AGNSS_DCBreq = SEQ(name=u'OMA-LPPe-AGNSS-DCBreq', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_DCBreq_reference = SEQ(name=u'reference', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OMA_LPPe_AGNSS_DCBreq_reference_signal = SEQ(name=u'signal', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-SignalID')))
    __OMA_LPPe_AGNSS_DCBreq_reference_pd = ENUM(name=u'pd', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_AGNSS_DCBreq_reference_pd._cont = ASN1Dict([(u'pilot', 0), (u'data', 1), (u'notapplicable', 2)])
    __OMA_LPPe_AGNSS_DCBreq_reference_pd._ext = []
    _OMA_LPPe_AGNSS_DCBreq_reference._cont = ASN1Dict([
        (u'signal', __OMA_LPPe_AGNSS_DCBreq_reference_signal),
        (u'pd', __OMA_LPPe_AGNSS_DCBreq_reference_pd),
        ])
    _OMA_LPPe_AGNSS_DCBreq_reference._ext = []
    OMA_LPPe_AGNSS_DCBreq._cont = ASN1Dict([
        (u'reference', _OMA_LPPe_AGNSS_DCBreq_reference),
        ])
    OMA_LPPe_AGNSS_DCBreq._ext = []
    
    #-----< OMA-LPPe-AGNSS-MechanicsReq >-----#
    OMA_LPPe_AGNSS_MechanicsReq = SEQ(name=u'OMA-LPPe-AGNSS-MechanicsReq', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_MechanicsReq_massRequest = BOOL(name=u'massRequest', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_MechanicsReq_effectiveReflectivityAreaRequest = BOOL(name=u'effectiveReflectivityAreaRequest', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_MechanicsReq_pcoRequest = BOOL(name=u'pcoRequest', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_MechanicsReq_svInfoRequest = BOOL(name=u'svInfoRequest', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    OMA_LPPe_AGNSS_MechanicsReq._cont = ASN1Dict([
        (u'massRequest', _OMA_LPPe_AGNSS_MechanicsReq_massRequest),
        (u'effectiveReflectivityAreaRequest', _OMA_LPPe_AGNSS_MechanicsReq_effectiveReflectivityAreaRequest),
        (u'pcoRequest', _OMA_LPPe_AGNSS_MechanicsReq_pcoRequest),
        (u'svInfoRequest', _OMA_LPPe_AGNSS_MechanicsReq_svInfoRequest),
        ])
    OMA_LPPe_AGNSS_MechanicsReq._ext = []
    
    #-----< OMA-LPPe-AGNSS-CCPrequestControlParameters >-----#
    OMA_LPPe_AGNSS_CCPrequestControlParameters = SEQ(name=u'OMA-LPPe-AGNSS-CCPrequestControlParameters', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_CCPrequestControlParameters_ccpSupportAreaRequest = NULL(name=u'ccpSupportAreaRequest', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_CCPrequestControlParameters_ccpNeighborListRequest = NULL(name=u'ccpNeighborListRequest', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_CCPrequestControlParameters_ccpCommonRequest = SEQ(name=u'ccpCommonRequest', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_AGNSS_CCPrequestControlParameters_ccpCommonRequest_duration = SEQ(name=u'duration', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-Duration')), opt=True)
    __OMA_LPPe_AGNSS_CCPrequestControlParameters_ccpCommonRequest_rate = INT(name=u'rate', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OMA_LPPe_AGNSS_CCPrequestControlParameters_ccpCommonRequest_rate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __OMA_LPPe_AGNSS_CCPrequestControlParameters_ccpCommonRequest_refStation = CHOICE(name=u'refStation', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    ___OMA_LPPe_AGNSS_CCPrequestControlParameters_ccpCommonRequest_refStation_posBasedReferenceStationRequest = SEQ(name=u'posBasedReferenceStationRequest', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ____OMA_LPPe_AGNSS_CCPrequestControlParameters_ccpCommonRequest_refStation_posBasedReferenceStationRequest_requestedReferenceStationLocation = SEQ(name=u'requestedReferenceStationLocation', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-HighAccuracy3Dposition')))
    ____OMA_LPPe_AGNSS_CCPrequestControlParameters_ccpCommonRequest_refStation_posBasedReferenceStationRequest_qor = ENUM(name=u'qor', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-QoR')))
    ___OMA_LPPe_AGNSS_CCPrequestControlParameters_ccpCommonRequest_refStation_posBasedReferenceStationRequest._cont = ASN1Dict([
        (u'requestedReferenceStationLocation', ____OMA_LPPe_AGNSS_CCPrequestControlParameters_ccpCommonRequest_refStation_posBasedReferenceStationRequest_requestedReferenceStationLocation),
        (u'qor', ____OMA_LPPe_AGNSS_CCPrequestControlParameters_ccpCommonRequest_refStation_posBasedReferenceStationRequest_qor),
        ])
    ___OMA_LPPe_AGNSS_CCPrequestControlParameters_ccpCommonRequest_refStation_posBasedReferenceStationRequest._ext = []
    ___OMA_LPPe_AGNSS_CCPrequestControlParameters_ccpCommonRequest_refStation_idBasedReferenceStationRequest = SEQ_OF(name=u'idBasedReferenceStationRequest', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-ReferenceStationIDlist')))
    ___OMA_LPPe_AGNSS_CCPrequestControlParameters_ccpCommonRequest_refStation_referenceStationKillList = SEQ_OF(name=u'referenceStationKillList', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-ReferenceStationIDlist')))
    __OMA_LPPe_AGNSS_CCPrequestControlParameters_ccpCommonRequest_refStation._cont = ASN1Dict([
        (u'posBasedReferenceStationRequest', ___OMA_LPPe_AGNSS_CCPrequestControlParameters_ccpCommonRequest_refStation_posBasedReferenceStationRequest),
        (u'idBasedReferenceStationRequest', ___OMA_LPPe_AGNSS_CCPrequestControlParameters_ccpCommonRequest_refStation_idBasedReferenceStationRequest),
        (u'referenceStationKillList', ___OMA_LPPe_AGNSS_CCPrequestControlParameters_ccpCommonRequest_refStation_referenceStationKillList),
        ])
    __OMA_LPPe_AGNSS_CCPrequestControlParameters_ccpCommonRequest_refStation._ext = []
    _OMA_LPPe_AGNSS_CCPrequestControlParameters_ccpCommonRequest._cont = ASN1Dict([
        (u'duration', __OMA_LPPe_AGNSS_CCPrequestControlParameters_ccpCommonRequest_duration),
        (u'rate', __OMA_LPPe_AGNSS_CCPrequestControlParameters_ccpCommonRequest_rate),
        (u'refStation', __OMA_LPPe_AGNSS_CCPrequestControlParameters_ccpCommonRequest_refStation),
        ])
    _OMA_LPPe_AGNSS_CCPrequestControlParameters_ccpCommonRequest._ext = []
    OMA_LPPe_AGNSS_CCPrequestControlParameters._cont = ASN1Dict([
        (u'ccpSupportAreaRequest', _OMA_LPPe_AGNSS_CCPrequestControlParameters_ccpSupportAreaRequest),
        (u'ccpNeighborListRequest', _OMA_LPPe_AGNSS_CCPrequestControlParameters_ccpNeighborListRequest),
        (u'ccpCommonRequest', _OMA_LPPe_AGNSS_CCPrequestControlParameters_ccpCommonRequest),
        ])
    OMA_LPPe_AGNSS_CCPrequestControlParameters._ext = []
    
    #-----< OMA-LPPe-AGNSS-ReferenceStationIDlist >-----#
    OMA_LPPe_AGNSS_ReferenceStationIDlist = SEQ_OF(name=u'OMA-LPPe-AGNSS-ReferenceStationIDlist', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_ReferenceStationIDlist__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-CCPreferenceStationID')))
    OMA_LPPe_AGNSS_ReferenceStationIDlist._cont = _OMA_LPPe_AGNSS_ReferenceStationIDlist__item_
    OMA_LPPe_AGNSS_ReferenceStationIDlist._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    
    #-----< OMA-LPPe-AGNSS-QoR >-----#
    OMA_LPPe_AGNSS_QoR = ENUM(name=u'OMA-LPPe-AGNSS-QoR', mode=MODE_TYPE)
    OMA_LPPe_AGNSS_QoR._cont = ASN1Dict([(u'm10', 0), (u'km1', 1), (u'km10', 2), (u'km100', 3)])
    OMA_LPPe_AGNSS_QoR._ext = []
    
    #-----< OMA-LPPe-AGNSS-CCPassistGenericReq >-----#
    OMA_LPPe_AGNSS_CCPassistGenericReq = SEQ(name=u'OMA-LPPe-AGNSS-CCPassistGenericReq', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_CCPassistGenericReq_ccpAssist_SignalsReq = SEQ(name=u'ccpAssist-SignalsReq', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-SignalIDs')))
    OMA_LPPe_AGNSS_CCPassistGenericReq._cont = ASN1Dict([
        (u'ccpAssist-SignalsReq', _OMA_LPPe_AGNSS_CCPassistGenericReq_ccpAssist_SignalsReq),
        ])
    OMA_LPPe_AGNSS_CCPassistGenericReq._ext = []
    
    #-----< OMA-LPPe-AGNSS-NavigationModelReq >-----#
    OMA_LPPe_AGNSS_NavigationModelReq = SEQ(name=u'OMA-LPPe-AGNSS-NavigationModelReq', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_NavigationModelReq_navModelID_PrefList = SEQ_OF(name=u'navModelID-PrefList', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OMA_LPPe_AGNSS_NavigationModelReq_navModelID_PrefList__item_ = INT(name='_item_', mode=MODE_TYPE)
    __OMA_LPPe_AGNSS_NavigationModelReq_navModelID_PrefList__item_._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    _OMA_LPPe_AGNSS_NavigationModelReq_navModelID_PrefList._cont = __OMA_LPPe_AGNSS_NavigationModelReq_navModelID_PrefList__item_
    _OMA_LPPe_AGNSS_NavigationModelReq_navModelID_PrefList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    OMA_LPPe_AGNSS_NavigationModelReq._cont = ASN1Dict([
        (u'navModelID-PrefList', _OMA_LPPe_AGNSS_NavigationModelReq_navModelID_PrefList),
        ])
    OMA_LPPe_AGNSS_NavigationModelReq._ext = []
    
    #-----< OMA-LPPe-AGNSS-ProvideLocationInformation >-----#
    OMA_LPPe_AGNSS_ProvideLocationInformation = SEQ(name=u'OMA-LPPe-AGNSS-ProvideLocationInformation', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_ProvideLocationInformation_highAccuracyReferenceTime = SEQ(name=u'highAccuracyReferenceTime', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-SystemTime')), opt=True)
    _OMA_LPPe_AGNSS_ProvideLocationInformation_highAccuracyMeasurements = CHOICE(name=u'highAccuracyMeasurements', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-HAgnssProvide')), opt=True)
    _OMA_LPPe_AGNSS_ProvideLocationInformation_ionosphereMeasurements = SEQ(name=u'ionosphereMeasurements', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-IonosphereMeasurements')), opt=True)
    _OMA_LPPe_AGNSS_ProvideLocationInformation_localSurfaceMeasurements = SEQ(name=u'localSurfaceMeasurements', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-LocalSurfaceMeasurements')), opt=True)
    _OMA_LPPe_AGNSS_ProvideLocationInformation_error = CHOICE(name=u'error', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-Error')), opt=True)
    OMA_LPPe_AGNSS_ProvideLocationInformation._cont = ASN1Dict([
        (u'highAccuracyReferenceTime', _OMA_LPPe_AGNSS_ProvideLocationInformation_highAccuracyReferenceTime),
        (u'highAccuracyMeasurements', _OMA_LPPe_AGNSS_ProvideLocationInformation_highAccuracyMeasurements),
        (u'ionosphereMeasurements', _OMA_LPPe_AGNSS_ProvideLocationInformation_ionosphereMeasurements),
        (u'localSurfaceMeasurements', _OMA_LPPe_AGNSS_ProvideLocationInformation_localSurfaceMeasurements),
        (u'error', _OMA_LPPe_AGNSS_ProvideLocationInformation_error),
        ])
    OMA_LPPe_AGNSS_ProvideLocationInformation._ext = []
    
    #-----< OMA-LPPe-AGNSS-HAgnssProvide >-----#
    OMA_LPPe_AGNSS_HAgnssProvide = CHOICE(name=u'OMA-LPPe-AGNSS-HAgnssProvide', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_HAgnssProvide_controlParameters = SEQ(name=u'controlParameters', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_AGNSS_HAgnssProvide_controlParameters_duration = SEQ(name=u'duration', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-Duration')))
    __OMA_LPPe_AGNSS_HAgnssProvide_controlParameters_rate = INT(name=u'rate', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_AGNSS_HAgnssProvide_controlParameters_rate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __OMA_LPPe_AGNSS_HAgnssProvide_controlParameters_antennaDescription = SEQ(name=u'antennaDescription', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-AntennaDescription')), opt=True)
    _OMA_LPPe_AGNSS_HAgnssProvide_controlParameters._cont = ASN1Dict([
        (u'duration', __OMA_LPPe_AGNSS_HAgnssProvide_controlParameters_duration),
        (u'rate', __OMA_LPPe_AGNSS_HAgnssProvide_controlParameters_rate),
        (u'antennaDescription', __OMA_LPPe_AGNSS_HAgnssProvide_controlParameters_antennaDescription),
        ])
    _OMA_LPPe_AGNSS_HAgnssProvide_controlParameters._ext = []
    _OMA_LPPe_AGNSS_HAgnssProvide_measurements = SEQ(name=u'measurements', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_AGNSS_HAgnssProvide_measurements_position = SEQ(name=u'position', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'EllipsoidPointWithAltitudeAndUncertaintyEllipsoid')), opt=True)
    __OMA_LPPe_AGNSS_HAgnssProvide_measurements_referenceTime = SEQ(name=u'referenceTime', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-SystemTime')))
    __OMA_LPPe_AGNSS_HAgnssProvide_measurements_localPressure = SEQ(name=u'localPressure', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    ___OMA_LPPe_AGNSS_HAgnssProvide_measurements_localPressure_pressure = INT(name=u'pressure', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___OMA_LPPe_AGNSS_HAgnssProvide_measurements_localPressure_pressure._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-1024, ub=1023)], ev=None, er=[])
    ___OMA_LPPe_AGNSS_HAgnssProvide_measurements_localPressure_pressureUncertainty = INT(name=u'pressureUncertainty', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___OMA_LPPe_AGNSS_HAgnssProvide_measurements_localPressure_pressureUncertainty._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    __OMA_LPPe_AGNSS_HAgnssProvide_measurements_localPressure._cont = ASN1Dict([
        (u'pressure', ___OMA_LPPe_AGNSS_HAgnssProvide_measurements_localPressure_pressure),
        (u'pressureUncertainty', ___OMA_LPPe_AGNSS_HAgnssProvide_measurements_localPressure_pressureUncertainty),
        ])
    __OMA_LPPe_AGNSS_HAgnssProvide_measurements_localPressure._ext = []
    __OMA_LPPe_AGNSS_HAgnssProvide_measurements_antennaOrientation = CHOICE(name=u'antennaOrientation', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-Orientation')), opt=True)
    __OMA_LPPe_AGNSS_HAgnssProvide_measurements_signalMeasurements = SEQ_OF(name=u'signalMeasurements', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___OMA_LPPe_AGNSS_HAgnssProvide_measurements_signalMeasurements__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-HAgnssMeasurementElement')))
    __OMA_LPPe_AGNSS_HAgnssProvide_measurements_signalMeasurements._cont = ___OMA_LPPe_AGNSS_HAgnssProvide_measurements_signalMeasurements__item_
    __OMA_LPPe_AGNSS_HAgnssProvide_measurements_signalMeasurements._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    _OMA_LPPe_AGNSS_HAgnssProvide_measurements._cont = ASN1Dict([
        (u'position', __OMA_LPPe_AGNSS_HAgnssProvide_measurements_position),
        (u'referenceTime', __OMA_LPPe_AGNSS_HAgnssProvide_measurements_referenceTime),
        (u'localPressure', __OMA_LPPe_AGNSS_HAgnssProvide_measurements_localPressure),
        (u'antennaOrientation', __OMA_LPPe_AGNSS_HAgnssProvide_measurements_antennaOrientation),
        (u'signalMeasurements', __OMA_LPPe_AGNSS_HAgnssProvide_measurements_signalMeasurements),
        ])
    _OMA_LPPe_AGNSS_HAgnssProvide_measurements._ext = []
    OMA_LPPe_AGNSS_HAgnssProvide._cont = ASN1Dict([
        (u'controlParameters', _OMA_LPPe_AGNSS_HAgnssProvide_controlParameters),
        (u'measurements', _OMA_LPPe_AGNSS_HAgnssProvide_measurements),
        ])
    OMA_LPPe_AGNSS_HAgnssProvide._ext = []
    
    #-----< OMA-LPPe-AGNSS-HAgnssMeasurementElement >-----#
    OMA_LPPe_AGNSS_HAgnssMeasurementElement = SEQ(name=u'OMA-LPPe-AGNSS-HAgnssMeasurementElement', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_HAgnssMeasurementElement_gnss_ID = SEQ(name=u'gnss-ID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-ID')))
    _OMA_LPPe_AGNSS_HAgnssMeasurementElement_haGNSSperSignalList = SEQ_OF(name=u'haGNSSperSignalList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_AGNSS_HAgnssMeasurementElement_haGNSSperSignalList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-HAgnssPerSignalElement')))
    _OMA_LPPe_AGNSS_HAgnssMeasurementElement_haGNSSperSignalList._cont = __OMA_LPPe_AGNSS_HAgnssMeasurementElement_haGNSSperSignalList__item_
    _OMA_LPPe_AGNSS_HAgnssMeasurementElement_haGNSSperSignalList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    OMA_LPPe_AGNSS_HAgnssMeasurementElement._cont = ASN1Dict([
        (u'gnss-ID', _OMA_LPPe_AGNSS_HAgnssMeasurementElement_gnss_ID),
        (u'haGNSSperSignalList', _OMA_LPPe_AGNSS_HAgnssMeasurementElement_haGNSSperSignalList),
        ])
    OMA_LPPe_AGNSS_HAgnssMeasurementElement._ext = []
    
    #-----< OMA-LPPe-HAgnssPerSignalElement >-----#
    OMA_LPPe_HAgnssPerSignalElement = SEQ(name=u'OMA-LPPe-HAgnssPerSignalElement', mode=MODE_TYPE)
    _OMA_LPPe_HAgnssPerSignalElement_signal_ID = SEQ(name=u'signal-ID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-SignalID')))
    _OMA_LPPe_HAgnssPerSignalElement_haGNSSperSVlist = SEQ_OF(name=u'haGNSSperSVlist', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_HAgnssPerSignalElement_haGNSSperSVlist__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-HAgnssPerSVelement')))
    _OMA_LPPe_HAgnssPerSignalElement_haGNSSperSVlist._cont = __OMA_LPPe_HAgnssPerSignalElement_haGNSSperSVlist__item_
    _OMA_LPPe_HAgnssPerSignalElement_haGNSSperSVlist._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    OMA_LPPe_HAgnssPerSignalElement._cont = ASN1Dict([
        (u'signal-ID', _OMA_LPPe_HAgnssPerSignalElement_signal_ID),
        (u'haGNSSperSVlist', _OMA_LPPe_HAgnssPerSignalElement_haGNSSperSVlist),
        ])
    OMA_LPPe_HAgnssPerSignalElement._ext = []
    
    #-----< OMA-LPPe-HAgnssPerSVelement >-----#
    OMA_LPPe_HAgnssPerSVelement = SEQ(name=u'OMA-LPPe-HAgnssPerSVelement', mode=MODE_TYPE)
    _OMA_LPPe_HAgnssPerSVelement_svID = SEQ(name=u'svID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'SV-ID')))
    _OMA_LPPe_HAgnssPerSVelement_integerCodePhase = INT(name=u'integerCodePhase', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_HAgnssPerSVelement_integerCodePhase._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _OMA_LPPe_HAgnssPerSVelement_codePhase = INT(name=u'codePhase', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_HAgnssPerSVelement_codePhase._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=14989622)], ev=None, er=[])
    _OMA_LPPe_HAgnssPerSVelement_codePhaseRMSError = INT(name=u'codePhaseRMSError', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_HAgnssPerSVelement_codePhaseRMSError._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    _OMA_LPPe_HAgnssPerSVelement_multipathDetection = ENUM(name=u'multipathDetection', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_HAgnssPerSVelement_multipathDetection._cont = ASN1Dict([(u'low', 0), (u'moderate', 1), (u'high', 2), (u'notMeasured', 3)])
    _OMA_LPPe_HAgnssPerSVelement_multipathDetection._ext = []
    _OMA_LPPe_HAgnssPerSVelement_cnr = INT(name=u'cnr', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_HAgnssPerSVelement_cnr._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _OMA_LPPe_HAgnssPerSVelement_adr = INT(name=u'adr', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_HAgnssPerSVelement_adr._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=536870911)], ev=None, er=[])
    _OMA_LPPe_HAgnssPerSVelement_adrRMSerror = INT(name=u'adrRMSerror', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_HAgnssPerSVelement_adrRMSerror._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    _OMA_LPPe_HAgnssPerSVelement_lockIndicator = BOOL(name=u'lockIndicator', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    OMA_LPPe_HAgnssPerSVelement._cont = ASN1Dict([
        (u'svID', _OMA_LPPe_HAgnssPerSVelement_svID),
        (u'integerCodePhase', _OMA_LPPe_HAgnssPerSVelement_integerCodePhase),
        (u'codePhase', _OMA_LPPe_HAgnssPerSVelement_codePhase),
        (u'codePhaseRMSError', _OMA_LPPe_HAgnssPerSVelement_codePhaseRMSError),
        (u'multipathDetection', _OMA_LPPe_HAgnssPerSVelement_multipathDetection),
        (u'cnr', _OMA_LPPe_HAgnssPerSVelement_cnr),
        (u'adr', _OMA_LPPe_HAgnssPerSVelement_adr),
        (u'adrRMSerror', _OMA_LPPe_HAgnssPerSVelement_adrRMSerror),
        (u'lockIndicator', _OMA_LPPe_HAgnssPerSVelement_lockIndicator),
        ])
    OMA_LPPe_HAgnssPerSVelement._ext = []
    
    #-----< OMA-LPPe-AGNSS-IonosphereMeasurements >-----#
    OMA_LPPe_AGNSS_IonosphereMeasurements = SEQ(name=u'OMA-LPPe-AGNSS-IonosphereMeasurements', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_IonosphereMeasurements_gnssTime = SEQ(name=u'gnssTime', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-SystemTime')))
    _OMA_LPPe_AGNSS_IonosphereMeasurements_position = SEQ(name=u'position', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'EllipsoidPointWithAltitudeAndUncertaintyEllipsoid')))
    _OMA_LPPe_AGNSS_IonosphereMeasurements_tecPerSV = SEQ_OF(name=u'tecPerSV', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-TECPerSV')), opt=True)
    _OMA_LPPe_AGNSS_IonosphereMeasurements_tecAtZenith = SEQ(name=u'tecAtZenith', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-TECAtZenith')), opt=True)
    OMA_LPPe_AGNSS_IonosphereMeasurements._cont = ASN1Dict([
        (u'gnssTime', _OMA_LPPe_AGNSS_IonosphereMeasurements_gnssTime),
        (u'position', _OMA_LPPe_AGNSS_IonosphereMeasurements_position),
        (u'tecPerSV', _OMA_LPPe_AGNSS_IonosphereMeasurements_tecPerSV),
        (u'tecAtZenith', _OMA_LPPe_AGNSS_IonosphereMeasurements_tecAtZenith),
        ])
    OMA_LPPe_AGNSS_IonosphereMeasurements._ext = []
    
    #-----< OMA-LPPe-AGNSS-TECPerSV >-----#
    OMA_LPPe_AGNSS_TECPerSV = SEQ_OF(name=u'OMA-LPPe-AGNSS-TECPerSV', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_TECPerSV__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-TECPerSVElement')))
    OMA_LPPe_AGNSS_TECPerSV._cont = _OMA_LPPe_AGNSS_TECPerSV__item_
    OMA_LPPe_AGNSS_TECPerSV._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    
    #-----< OMA-LPPe-AGNSS-TECPerSVElement >-----#
    OMA_LPPe_AGNSS_TECPerSVElement = SEQ(name=u'OMA-LPPe-AGNSS-TECPerSVElement', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_TECPerSVElement_azimuth = INT(name=u'azimuth', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_TECPerSVElement_azimuth._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=359)], ev=None, er=[])
    _OMA_LPPe_AGNSS_TECPerSVElement_elevation = INT(name=u'elevation', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_TECPerSVElement_elevation._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=90)], ev=None, er=[])
    _OMA_LPPe_AGNSS_TECPerSVElement_tecValue = INT(name=u'tecValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_TECPerSVElement_tecValue._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=511)], ev=None, er=[])
    _OMA_LPPe_AGNSS_TECPerSVElement_tecUncertainty = INT(name=u'tecUncertainty', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_TECPerSVElement_tecUncertainty._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    OMA_LPPe_AGNSS_TECPerSVElement._cont = ASN1Dict([
        (u'azimuth', _OMA_LPPe_AGNSS_TECPerSVElement_azimuth),
        (u'elevation', _OMA_LPPe_AGNSS_TECPerSVElement_elevation),
        (u'tecValue', _OMA_LPPe_AGNSS_TECPerSVElement_tecValue),
        (u'tecUncertainty', _OMA_LPPe_AGNSS_TECPerSVElement_tecUncertainty),
        ])
    OMA_LPPe_AGNSS_TECPerSVElement._ext = []
    
    #-----< OMA-LPPe-AGNSS-TECAtZenith >-----#
    OMA_LPPe_AGNSS_TECAtZenith = SEQ(name=u'OMA-LPPe-AGNSS-TECAtZenith', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_TECAtZenith_tecValueAtZenith = INT(name=u'tecValueAtZenith', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_TECAtZenith_tecValueAtZenith._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=511)], ev=None, er=[])
    _OMA_LPPe_AGNSS_TECAtZenith_tecUncertaintyAtZenith = INT(name=u'tecUncertaintyAtZenith', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_TECAtZenith_tecUncertaintyAtZenith._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    OMA_LPPe_AGNSS_TECAtZenith._cont = ASN1Dict([
        (u'tecValueAtZenith', _OMA_LPPe_AGNSS_TECAtZenith_tecValueAtZenith),
        (u'tecUncertaintyAtZenith', _OMA_LPPe_AGNSS_TECAtZenith_tecUncertaintyAtZenith),
        ])
    OMA_LPPe_AGNSS_TECAtZenith._ext = []
    
    #-----< OMA-LPPe-AGNSS-LocalSurfaceMeasurements >-----#
    OMA_LPPe_AGNSS_LocalSurfaceMeasurements = SEQ(name=u'OMA-LPPe-AGNSS-LocalSurfaceMeasurements', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_LocalSurfaceMeasurements_gnssTime = SEQ(name=u'gnssTime', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-SystemTime')))
    _OMA_LPPe_AGNSS_LocalSurfaceMeasurements_position = SEQ(name=u'position', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'EllipsoidPointWithAltitudeAndUncertaintyEllipsoid')))
    _OMA_LPPe_AGNSS_LocalSurfaceMeasurements_pressure = INT(name=u'pressure', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_LocalSurfaceMeasurements_pressure._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-1024, ub=1023)], ev=None, er=[])
    _OMA_LPPe_AGNSS_LocalSurfaceMeasurements_pressureUncertainty = INT(name=u'pressureUncertainty', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_LocalSurfaceMeasurements_pressureUncertainty._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    _OMA_LPPe_AGNSS_LocalSurfaceMeasurements_temperatureMeasurement = SEQ(name=u'temperatureMeasurement', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OMA_LPPe_AGNSS_LocalSurfaceMeasurements_temperatureMeasurement_temperature = INT(name=u'temperature', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OMA_LPPe_AGNSS_LocalSurfaceMeasurements_temperatureMeasurement_temperature._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-64, ub=63)], ev=None, er=[])
    __OMA_LPPe_AGNSS_LocalSurfaceMeasurements_temperatureMeasurement_temperatureUncertainty = INT(name=u'temperatureUncertainty', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OMA_LPPe_AGNSS_LocalSurfaceMeasurements_temperatureMeasurement_temperatureUncertainty._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=7)], ev=None, er=[])
    _OMA_LPPe_AGNSS_LocalSurfaceMeasurements_temperatureMeasurement._cont = ASN1Dict([
        (u'temperature', __OMA_LPPe_AGNSS_LocalSurfaceMeasurements_temperatureMeasurement_temperature),
        (u'temperatureUncertainty', __OMA_LPPe_AGNSS_LocalSurfaceMeasurements_temperatureMeasurement_temperatureUncertainty),
        ])
    _OMA_LPPe_AGNSS_LocalSurfaceMeasurements_temperatureMeasurement._ext = []
    OMA_LPPe_AGNSS_LocalSurfaceMeasurements._cont = ASN1Dict([
        (u'gnssTime', _OMA_LPPe_AGNSS_LocalSurfaceMeasurements_gnssTime),
        (u'position', _OMA_LPPe_AGNSS_LocalSurfaceMeasurements_position),
        (u'pressure', _OMA_LPPe_AGNSS_LocalSurfaceMeasurements_pressure),
        (u'pressureUncertainty', _OMA_LPPe_AGNSS_LocalSurfaceMeasurements_pressureUncertainty),
        (u'temperatureMeasurement', _OMA_LPPe_AGNSS_LocalSurfaceMeasurements_temperatureMeasurement),
        ])
    OMA_LPPe_AGNSS_LocalSurfaceMeasurements._ext = []
    
    #-----< OMA-LPPe-AGNSS-RequestLocationInformation >-----#
    OMA_LPPe_AGNSS_RequestLocationInformation = SEQ(name=u'OMA-LPPe-AGNSS-RequestLocationInformation', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_RequestLocationInformation_positioningInstructions = SEQ(name=u'positioningInstructions', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-PositioningInstructions')), opt=True)
    _OMA_LPPe_AGNSS_RequestLocationInformation_ionosphereMeasurementsReq = BIT_STR(name=u'ionosphereMeasurementsReq', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_RequestLocationInformation_ionosphereMeasurementsReq._cont = ASN1Dict([(u'tecPerSV', 0), (u'zenithTEC', 1)])
    _OMA_LPPe_AGNSS_RequestLocationInformation_ionosphereMeasurementsReq._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    _OMA_LPPe_AGNSS_RequestLocationInformation_localSurfaceMeasurementReq = SEQ(name=u'localSurfaceMeasurementReq', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-LocalSurfaceMeasurementReq')), opt=True)
    OMA_LPPe_AGNSS_RequestLocationInformation._cont = ASN1Dict([
        (u'positioningInstructions', _OMA_LPPe_AGNSS_RequestLocationInformation_positioningInstructions),
        (u'ionosphereMeasurementsReq', _OMA_LPPe_AGNSS_RequestLocationInformation_ionosphereMeasurementsReq),
        (u'localSurfaceMeasurementReq', _OMA_LPPe_AGNSS_RequestLocationInformation_localSurfaceMeasurementReq),
        ])
    OMA_LPPe_AGNSS_RequestLocationInformation._ext = []
    
    #-----< OMA-LPPe-AGNSS-PositioningInstructions >-----#
    OMA_LPPe_AGNSS_PositioningInstructions = SEQ(name=u'OMA-LPPe-AGNSS-PositioningInstructions', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_PositioningInstructions_highAccuracyMethodRequested = BOOL(name=u'highAccuracyMethodRequested', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_PositioningInstructions_haGNSSreq = SEQ(name=u'haGNSSreq', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-HAgnssRequestControlParameters')), opt=True)
    OMA_LPPe_AGNSS_PositioningInstructions._cont = ASN1Dict([
        (u'highAccuracyMethodRequested', _OMA_LPPe_AGNSS_PositioningInstructions_highAccuracyMethodRequested),
        (u'haGNSSreq', _OMA_LPPe_AGNSS_PositioningInstructions_haGNSSreq),
        ])
    OMA_LPPe_AGNSS_PositioningInstructions._ext = []
    
    #-----< OMA-LPPe-AGNSS-LocalSurfaceMeasurementReq >-----#
    OMA_LPPe_AGNSS_LocalSurfaceMeasurementReq = SEQ(name=u'OMA-LPPe-AGNSS-LocalSurfaceMeasurementReq', mode=MODE_TYPE)
    OMA_LPPe_AGNSS_LocalSurfaceMeasurementReq._cont = ASN1Dict([
        ])
    OMA_LPPe_AGNSS_LocalSurfaceMeasurementReq._ext = []
    
    #-----< OMA-LPPe-AGNSS-HAgnssRequestControlParameters >-----#
    OMA_LPPe_AGNSS_HAgnssRequestControlParameters = SEQ(name=u'OMA-LPPe-AGNSS-HAgnssRequestControlParameters', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_HAgnssRequestControlParameters_duration = SEQ(name=u'duration', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-Duration')), opt=True)
    _OMA_LPPe_AGNSS_HAgnssRequestControlParameters_rate = INT(name=u'rate', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_HAgnssRequestControlParameters_rate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=63)], ev=None, er=[])
    _OMA_LPPe_AGNSS_HAgnssRequestControlParameters_antennaInformationReq = ENUM(name=u'antennaInformationReq', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_HAgnssRequestControlParameters_antennaInformationReq._cont = ASN1Dict([(u'antennaDescriptionOnly', 0), (u'antennaDescriptionAndOrientation', 1)])
    _OMA_LPPe_AGNSS_HAgnssRequestControlParameters_antennaInformationReq._ext = []
    _OMA_LPPe_AGNSS_HAgnssRequestControlParameters_pressureInformationReq = BOOL(name=u'pressureInformationReq', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_HAgnssRequestControlParameters_signalReqList = SEQ_OF(name=u'signalReqList', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OMA_LPPe_AGNSS_HAgnssRequestControlParameters_signalReqList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-HAgnssSignalReqElement')))
    _OMA_LPPe_AGNSS_HAgnssRequestControlParameters_signalReqList._cont = __OMA_LPPe_AGNSS_HAgnssRequestControlParameters_signalReqList__item_
    _OMA_LPPe_AGNSS_HAgnssRequestControlParameters_signalReqList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    OMA_LPPe_AGNSS_HAgnssRequestControlParameters._cont = ASN1Dict([
        (u'duration', _OMA_LPPe_AGNSS_HAgnssRequestControlParameters_duration),
        (u'rate', _OMA_LPPe_AGNSS_HAgnssRequestControlParameters_rate),
        (u'antennaInformationReq', _OMA_LPPe_AGNSS_HAgnssRequestControlParameters_antennaInformationReq),
        (u'pressureInformationReq', _OMA_LPPe_AGNSS_HAgnssRequestControlParameters_pressureInformationReq),
        (u'signalReqList', _OMA_LPPe_AGNSS_HAgnssRequestControlParameters_signalReqList),
        ])
    OMA_LPPe_AGNSS_HAgnssRequestControlParameters._ext = []
    
    #-----< OMA-LPPe-AGNSS-HAgnssSignalReqElement >-----#
    OMA_LPPe_AGNSS_HAgnssSignalReqElement = SEQ(name=u'OMA-LPPe-AGNSS-HAgnssSignalReqElement', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_HAgnssSignalReqElement_gnssID = SEQ(name=u'gnssID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-ID')))
    _OMA_LPPe_AGNSS_HAgnssSignalReqElement_signals = SEQ(name=u'signals', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-SignalIDs')))
    OMA_LPPe_AGNSS_HAgnssSignalReqElement._cont = ASN1Dict([
        (u'gnssID', _OMA_LPPe_AGNSS_HAgnssSignalReqElement_gnssID),
        (u'signals', _OMA_LPPe_AGNSS_HAgnssSignalReqElement_signals),
        ])
    OMA_LPPe_AGNSS_HAgnssSignalReqElement._ext = []
    
    #-----< OMA-LPPe-AGNSS-ProvideCapabilities >-----#
    OMA_LPPe_AGNSS_ProvideCapabilities = SEQ(name=u'OMA-LPPe-AGNSS-ProvideCapabilities', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_ProvideCapabilities_assistanceDataSupportList = SEQ(name=u'assistanceDataSupportList', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-AssistanceDataSupportList')), opt=True)
    _OMA_LPPe_AGNSS_ProvideCapabilities_environmentObservationSupportList = SEQ(name=u'environmentObservationSupportList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-EnvironmentObservationSupportList')), opt=True)
    _OMA_LPPe_AGNSS_ProvideCapabilities_haGNSSsupport = SEQ(name=u'haGNSSsupport', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-HAgnssSupport')), opt=True)
    OMA_LPPe_AGNSS_ProvideCapabilities._cont = ASN1Dict([
        (u'assistanceDataSupportList', _OMA_LPPe_AGNSS_ProvideCapabilities_assistanceDataSupportList),
        (u'environmentObservationSupportList', _OMA_LPPe_AGNSS_ProvideCapabilities_environmentObservationSupportList),
        (u'haGNSSsupport', _OMA_LPPe_AGNSS_ProvideCapabilities_haGNSSsupport),
        ])
    OMA_LPPe_AGNSS_ProvideCapabilities._ext = []
    
    #-----< OMA-LPPe-AGNSS-AssistanceDataSupportList >-----#
    OMA_LPPe_AGNSS_AssistanceDataSupportList = SEQ(name=u'OMA-LPPe-AGNSS-AssistanceDataSupportList', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_AssistanceDataSupportList_commonAssistanceDataSupport = SEQ(name=u'commonAssistanceDataSupport', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-CommonAssistanceDataSupport')))
    _OMA_LPPe_AGNSS_AssistanceDataSupportList_genericAssistanceDataSupport = SEQ_OF(name=u'genericAssistanceDataSupport', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-GenericAssistanceDataSupport')))
    OMA_LPPe_AGNSS_AssistanceDataSupportList._cont = ASN1Dict([
        (u'commonAssistanceDataSupport', _OMA_LPPe_AGNSS_AssistanceDataSupportList_commonAssistanceDataSupport),
        (u'genericAssistanceDataSupport', _OMA_LPPe_AGNSS_AssistanceDataSupportList_genericAssistanceDataSupport),
        ])
    OMA_LPPe_AGNSS_AssistanceDataSupportList._ext = []
    
    #-----< OMA-LPPe-AGNSS-EnvironmentObservationSupportList >-----#
    OMA_LPPe_AGNSS_EnvironmentObservationSupportList = SEQ(name=u'OMA-LPPe-AGNSS-EnvironmentObservationSupportList', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_EnvironmentObservationSupportList_ionosphereMeasurementSupport = BIT_STR(name=u'ionosphereMeasurementSupport', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_EnvironmentObservationSupportList_ionosphereMeasurementSupport._cont = ASN1Dict([(u'tecPerSVsupport', 0), (u'zenithTecSupport', 1)])
    _OMA_LPPe_AGNSS_EnvironmentObservationSupportList_ionosphereMeasurementSupport._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    _OMA_LPPe_AGNSS_EnvironmentObservationSupportList_pressureMeasurementSupported = BOOL(name=u'pressureMeasurementSupported', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_EnvironmentObservationSupportList_temperatureMeasurementSupported = BOOL(name=u'temperatureMeasurementSupported', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    OMA_LPPe_AGNSS_EnvironmentObservationSupportList._cont = ASN1Dict([
        (u'ionosphereMeasurementSupport', _OMA_LPPe_AGNSS_EnvironmentObservationSupportList_ionosphereMeasurementSupport),
        (u'pressureMeasurementSupported', _OMA_LPPe_AGNSS_EnvironmentObservationSupportList_pressureMeasurementSupported),
        (u'temperatureMeasurementSupported', _OMA_LPPe_AGNSS_EnvironmentObservationSupportList_temperatureMeasurementSupported),
        ])
    OMA_LPPe_AGNSS_EnvironmentObservationSupportList._ext = []
    
    #-----< OMA-LPPe-AGNSS-CommonAssistanceDataSupport >-----#
    OMA_LPPe_AGNSS_CommonAssistanceDataSupport = SEQ(name=u'OMA-LPPe-AGNSS-CommonAssistanceDataSupport', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_CommonAssistanceDataSupport_ionosphericModelSupport = SEQ(name=u'ionosphericModelSupport', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-IonosphericModelSupport')), opt=True)
    _OMA_LPPe_AGNSS_CommonAssistanceDataSupport_troposphereModelSupport = SEQ(name=u'troposphereModelSupport', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-TroposphereModelSupport')), opt=True)
    _OMA_LPPe_AGNSS_CommonAssistanceDataSupport_altitudeAssistanceSupport = SEQ(name=u'altitudeAssistanceSupport', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-AltitudeAssistanceSupport')), opt=True)
    _OMA_LPPe_AGNSS_CommonAssistanceDataSupport_solarRadiationSupport = SEQ(name=u'solarRadiationSupport', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-SolarRadiationSupport')), opt=True)
    _OMA_LPPe_AGNSS_CommonAssistanceDataSupport_ccpSupport = SEQ(name=u'ccpSupport', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-CCPsupport')), opt=True)
    OMA_LPPe_AGNSS_CommonAssistanceDataSupport._cont = ASN1Dict([
        (u'ionosphericModelSupport', _OMA_LPPe_AGNSS_CommonAssistanceDataSupport_ionosphericModelSupport),
        (u'troposphereModelSupport', _OMA_LPPe_AGNSS_CommonAssistanceDataSupport_troposphereModelSupport),
        (u'altitudeAssistanceSupport', _OMA_LPPe_AGNSS_CommonAssistanceDataSupport_altitudeAssistanceSupport),
        (u'solarRadiationSupport', _OMA_LPPe_AGNSS_CommonAssistanceDataSupport_solarRadiationSupport),
        (u'ccpSupport', _OMA_LPPe_AGNSS_CommonAssistanceDataSupport_ccpSupport),
        ])
    OMA_LPPe_AGNSS_CommonAssistanceDataSupport._ext = []
    
    #-----< OMA-LPPe-AGNSS-IonosphericModelSupport >-----#
    OMA_LPPe_AGNSS_IonosphericModelSupport = SEQ(name=u'OMA-LPPe-AGNSS-IonosphericModelSupport', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_IonosphericModelSupport_ionoModel = BIT_STR(name=u'ionoModel', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_IonosphericModelSupport_ionoModel._cont = ASN1Dict([(u'localKlobuchar', 0), (u'ionoStormWarning', 1), (u'wideAreaIonoSurface', 2)])
    _OMA_LPPe_AGNSS_IonosphericModelSupport_ionoModel._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    OMA_LPPe_AGNSS_IonosphericModelSupport._cont = ASN1Dict([
        (u'ionoModel', _OMA_LPPe_AGNSS_IonosphericModelSupport_ionoModel),
        ])
    OMA_LPPe_AGNSS_IonosphericModelSupport._ext = []
    
    #-----< OMA-LPPe-AGNSS-TroposphereModelSupport >-----#
    OMA_LPPe_AGNSS_TroposphereModelSupport = SEQ(name=u'OMA-LPPe-AGNSS-TroposphereModelSupport', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_TroposphereModelSupport_tropoModel = BIT_STR(name=u'tropoModel', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_TroposphereModelSupport_tropoModel._cont = ASN1Dict([(u'localTroposphereDelay', 0), (u'surfaceParameters', 1)])
    _OMA_LPPe_AGNSS_TroposphereModelSupport_tropoModel._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    _OMA_LPPe_AGNSS_TroposphereModelSupport_supportForMultipleGridPoints = BOOL(name=u'supportForMultipleGridPoints', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    OMA_LPPe_AGNSS_TroposphereModelSupport._cont = ASN1Dict([
        (u'tropoModel', _OMA_LPPe_AGNSS_TroposphereModelSupport_tropoModel),
        (u'supportForMultipleGridPoints', _OMA_LPPe_AGNSS_TroposphereModelSupport_supportForMultipleGridPoints),
        ])
    OMA_LPPe_AGNSS_TroposphereModelSupport._ext = []
    
    #-----< OMA-LPPe-AGNSS-AltitudeAssistanceSupport >-----#
    OMA_LPPe_AGNSS_AltitudeAssistanceSupport = SEQ(name=u'OMA-LPPe-AGNSS-AltitudeAssistanceSupport', mode=MODE_TYPE)
    OMA_LPPe_AGNSS_AltitudeAssistanceSupport._cont = ASN1Dict([
        ])
    OMA_LPPe_AGNSS_AltitudeAssistanceSupport._ext = []
    
    #-----< OMA-LPPe-AGNSS-SolarRadiationSupport >-----#
    OMA_LPPe_AGNSS_SolarRadiationSupport = SEQ(name=u'OMA-LPPe-AGNSS-SolarRadiationSupport', mode=MODE_TYPE)
    OMA_LPPe_AGNSS_SolarRadiationSupport._cont = ASN1Dict([
        ])
    OMA_LPPe_AGNSS_SolarRadiationSupport._ext = []
    
    #-----< OMA-LPPe-AGNSS-CCPsupport >-----#
    OMA_LPPe_AGNSS_CCPsupport = SEQ(name=u'OMA-LPPe-AGNSS-CCPsupport', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_CCPsupport_supportAreaAssistanceSupported = BOOL(name=u'supportAreaAssistanceSupported', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_CCPsupport_multiReferenceStationSupported = BOOL(name=u'multiReferenceStationSupported', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    OMA_LPPe_AGNSS_CCPsupport._cont = ASN1Dict([
        (u'supportAreaAssistanceSupported', _OMA_LPPe_AGNSS_CCPsupport_supportAreaAssistanceSupported),
        (u'multiReferenceStationSupported', _OMA_LPPe_AGNSS_CCPsupport_multiReferenceStationSupported),
        ])
    OMA_LPPe_AGNSS_CCPsupport._ext = []
    
    #-----< OMA-LPPe-AGNSS-GenericAssistanceDataSupport >-----#
    OMA_LPPe_AGNSS_GenericAssistanceDataSupport = SEQ_OF(name=u'OMA-LPPe-AGNSS-GenericAssistanceDataSupport', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_GenericAssistanceDataSupport__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-GenericAssistDataSupportElement')))
    OMA_LPPe_AGNSS_GenericAssistanceDataSupport._cont = _OMA_LPPe_AGNSS_GenericAssistanceDataSupport__item_
    OMA_LPPe_AGNSS_GenericAssistanceDataSupport._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    
    #-----< OMA-LPPe-AGNSS-GenericAssistDataSupportElement >-----#
    OMA_LPPe_AGNSS_GenericAssistDataSupportElement = SEQ(name=u'OMA-LPPe-AGNSS-GenericAssistDataSupportElement', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_GenericAssistDataSupportElement_gnss_ID = SEQ(name=u'gnss-ID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-ID')))
    _OMA_LPPe_AGNSS_GenericAssistDataSupportElement_mechnanicsSupport = SEQ(name=u'mechnanicsSupport', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-MechanicsSupport')), opt=True)
    _OMA_LPPe_AGNSS_GenericAssistDataSupportElement_dcbSupport = SEQ(name=u'dcbSupport', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-DCBsupport')), opt=True)
    _OMA_LPPe_AGNSS_GenericAssistDataSupportElement_navModelAccuracyModelDegradationSupport = SEQ(name=u'navModelAccuracyModelDegradationSupport', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-NavModelAccuracyModelDegradationSupport')), opt=True)
    _OMA_LPPe_AGNSS_GenericAssistDataSupportElement_ccpAssistanceSuppport = SEQ(name=u'ccpAssistanceSuppport', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-SignalIDs')), opt=True)
    _OMA_LPPe_AGNSS_GenericAssistDataSupportElement_navModelSupport = SEQ(name=u'navModelSupport', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-NavModelSupport')), opt=True)
    OMA_LPPe_AGNSS_GenericAssistDataSupportElement._cont = ASN1Dict([
        (u'gnss-ID', _OMA_LPPe_AGNSS_GenericAssistDataSupportElement_gnss_ID),
        (u'mechnanicsSupport', _OMA_LPPe_AGNSS_GenericAssistDataSupportElement_mechnanicsSupport),
        (u'dcbSupport', _OMA_LPPe_AGNSS_GenericAssistDataSupportElement_dcbSupport),
        (u'navModelAccuracyModelDegradationSupport', _OMA_LPPe_AGNSS_GenericAssistDataSupportElement_navModelAccuracyModelDegradationSupport),
        (u'ccpAssistanceSuppport', _OMA_LPPe_AGNSS_GenericAssistDataSupportElement_ccpAssistanceSuppport),
        (u'navModelSupport', _OMA_LPPe_AGNSS_GenericAssistDataSupportElement_navModelSupport),
        ])
    OMA_LPPe_AGNSS_GenericAssistDataSupportElement._ext = []
    
    #-----< OMA-LPPe-AGNSS-MechanicsSupport >-----#
    OMA_LPPe_AGNSS_MechanicsSupport = SEQ(name=u'OMA-LPPe-AGNSS-MechanicsSupport', mode=MODE_TYPE)
    OMA_LPPe_AGNSS_MechanicsSupport._cont = ASN1Dict([
        ])
    OMA_LPPe_AGNSS_MechanicsSupport._ext = []
    
    #-----< OMA-LPPe-AGNSS-DCBsupport >-----#
    OMA_LPPe_AGNSS_DCBsupport = SEQ(name=u'OMA-LPPe-AGNSS-DCBsupport', mode=MODE_TYPE)
    OMA_LPPe_AGNSS_DCBsupport._cont = ASN1Dict([
        ])
    OMA_LPPe_AGNSS_DCBsupport._ext = []
    
    #-----< OMA-LPPe-AGNSS-NavModelAccuracyModelDegradationSupport >-----#
    OMA_LPPe_AGNSS_NavModelAccuracyModelDegradationSupport = SEQ(name=u'OMA-LPPe-AGNSS-NavModelAccuracyModelDegradationSupport', mode=MODE_TYPE)
    OMA_LPPe_AGNSS_NavModelAccuracyModelDegradationSupport._cont = ASN1Dict([
        ])
    OMA_LPPe_AGNSS_NavModelAccuracyModelDegradationSupport._ext = []
    
    #-----< OMA-LPPe-AGNSS-NavModelSupport >-----#
    OMA_LPPe_AGNSS_NavModelSupport = SEQ(name=u'OMA-LPPe-AGNSS-NavModelSupport', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_NavModelSupport_navModelSupport = SEQ_OF(name=u'navModelSupport', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OMA_LPPe_AGNSS_NavModelSupport_navModelSupport__item_ = INT(name='_item_', mode=MODE_TYPE)
    __OMA_LPPe_AGNSS_NavModelSupport_navModelSupport__item_._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    _OMA_LPPe_AGNSS_NavModelSupport_navModelSupport._cont = __OMA_LPPe_AGNSS_NavModelSupport_navModelSupport__item_
    _OMA_LPPe_AGNSS_NavModelSupport_navModelSupport._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    OMA_LPPe_AGNSS_NavModelSupport._cont = ASN1Dict([
        (u'navModelSupport', _OMA_LPPe_AGNSS_NavModelSupport_navModelSupport),
        ])
    OMA_LPPe_AGNSS_NavModelSupport._ext = []
    
    #-----< OMA-LPPe-AGNSS-HAgnssSupport >-----#
    OMA_LPPe_AGNSS_HAgnssSupport = SEQ(name=u'OMA-LPPe-AGNSS-HAgnssSupport', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_HAgnssSupport_modeSupport = BIT_STR(name=u'modeSupport', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_HAgnssSupport_modeSupport._cont = ASN1Dict([(u'ueBased', 0), (u'ueAssisted', 1)])
    _OMA_LPPe_AGNSS_HAgnssSupport_modeSupport._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    _OMA_LPPe_AGNSS_HAgnssSupport_haGNSSpressureInformationSupport = BOOL(name=u'haGNSSpressureInformationSupport', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_HAgnssSupport_haGNSSantennaInformationSupport = BIT_STR(name=u'haGNSSantennaInformationSupport', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_HAgnssSupport_haGNSSantennaInformationSupport._cont = ASN1Dict([(u'antennaDescriptionSupported', 0), (u'antennaOrientationSupported', 1)])
    _OMA_LPPe_AGNSS_HAgnssSupport_haGNSSantennaInformationSupport._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _OMA_LPPe_AGNSS_HAgnssSupport_haGNSSperGNSSsupport = SEQ_OF(name=u'haGNSSperGNSSsupport', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_AGNSS_HAgnssSupport_haGNSSperGNSSsupport__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-HAgnssPerGNSSsupport')))
    _OMA_LPPe_AGNSS_HAgnssSupport_haGNSSperGNSSsupport._cont = __OMA_LPPe_AGNSS_HAgnssSupport_haGNSSperGNSSsupport__item_
    _OMA_LPPe_AGNSS_HAgnssSupport_haGNSSperGNSSsupport._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    OMA_LPPe_AGNSS_HAgnssSupport._cont = ASN1Dict([
        (u'modeSupport', _OMA_LPPe_AGNSS_HAgnssSupport_modeSupport),
        (u'haGNSSpressureInformationSupport', _OMA_LPPe_AGNSS_HAgnssSupport_haGNSSpressureInformationSupport),
        (u'haGNSSantennaInformationSupport', _OMA_LPPe_AGNSS_HAgnssSupport_haGNSSantennaInformationSupport),
        (u'haGNSSperGNSSsupport', _OMA_LPPe_AGNSS_HAgnssSupport_haGNSSperGNSSsupport),
        ])
    OMA_LPPe_AGNSS_HAgnssSupport._ext = []
    
    #-----< OMA-LPPe-AGNSS-HAgnssPerGNSSsupport >-----#
    OMA_LPPe_AGNSS_HAgnssPerGNSSsupport = SEQ(name=u'OMA-LPPe-AGNSS-HAgnssPerGNSSsupport', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_HAgnssPerGNSSsupport_gnss_ID = SEQ(name=u'gnss-ID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-ID')))
    _OMA_LPPe_AGNSS_HAgnssPerGNSSsupport_haGNSSsignalSupport = SEQ(name=u'haGNSSsignalSupport', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'GNSS-SignalIDs')))
    OMA_LPPe_AGNSS_HAgnssPerGNSSsupport._cont = ASN1Dict([
        (u'gnss-ID', _OMA_LPPe_AGNSS_HAgnssPerGNSSsupport_gnss_ID),
        (u'haGNSSsignalSupport', _OMA_LPPe_AGNSS_HAgnssPerGNSSsupport_haGNSSsignalSupport),
        ])
    OMA_LPPe_AGNSS_HAgnssPerGNSSsupport._ext = []
    
    #-----< OMA-LPPe-AGNSS-RequestCapabilities >-----#
    OMA_LPPe_AGNSS_RequestCapabilities = SEQ(name=u'OMA-LPPe-AGNSS-RequestCapabilities', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_RequestCapabilities_assistanceDataSupportListReq = NULL(name=u'assistanceDataSupportListReq', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_RequestCapabilities_environmentObservationSupportListReq = NULL(name=u'environmentObservationSupportListReq', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_RequestCapabilities_haGNSSsupportReq = NULL(name=u'haGNSSsupportReq', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    OMA_LPPe_AGNSS_RequestCapabilities._cont = ASN1Dict([
        (u'assistanceDataSupportListReq', _OMA_LPPe_AGNSS_RequestCapabilities_assistanceDataSupportListReq),
        (u'environmentObservationSupportListReq', _OMA_LPPe_AGNSS_RequestCapabilities_environmentObservationSupportListReq),
        (u'haGNSSsupportReq', _OMA_LPPe_AGNSS_RequestCapabilities_haGNSSsupportReq),
        ])
    OMA_LPPe_AGNSS_RequestCapabilities._ext = []
    
    #-----< OMA-LPPe-AGNSS-Error >-----#
    OMA_LPPe_AGNSS_Error = CHOICE(name=u'OMA-LPPe-AGNSS-Error', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_Error_agnss_locationServerErrorCauses = SEQ(name=u'agnss-locationServerErrorCauses', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-LocationServerErrorCauses')))
    _OMA_LPPe_AGNSS_Error_agnss_targetDeviceErrorCauses = SEQ(name=u'agnss-targetDeviceErrorCauses', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-AGNSS-TargetDeviceErrorCauses')))
    OMA_LPPe_AGNSS_Error._cont = ASN1Dict([
        (u'agnss-locationServerErrorCauses', _OMA_LPPe_AGNSS_Error_agnss_locationServerErrorCauses),
        (u'agnss-targetDeviceErrorCauses', _OMA_LPPe_AGNSS_Error_agnss_targetDeviceErrorCauses),
        ])
    OMA_LPPe_AGNSS_Error._ext = []
    
    #-----< OMA-LPPe-AGNSS-LocationServerErrorCauses >-----#
    OMA_LPPe_AGNSS_LocationServerErrorCauses = SEQ(name=u'OMA-LPPe-AGNSS-LocationServerErrorCauses', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_LocationServerErrorCauses_waIonoErrorCauses = ENUM(name=u'waIonoErrorCauses', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_LocationServerErrorCauses_waIonoErrorCauses._cont = ASN1Dict([(u'undefined', 0), (u'waIonoNotSupportedByServer', 1), (u'waIonoNotSupportedInTargetArea', 2), (u'waIonoNotSupportedForAnyRequestedGNSS', 3)])
    _OMA_LPPe_AGNSS_LocationServerErrorCauses_waIonoErrorCauses._ext = []
    _OMA_LPPe_AGNSS_LocationServerErrorCauses_ccpErrorCauses = ENUM(name=u'ccpErrorCauses', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_LocationServerErrorCauses_ccpErrorCauses._cont = ASN1Dict([(u'undefined', 0), (u'ccpNotSupportedByServer', 1), (u'ccpNotSupportedInTargetArea', 2), (u'ccpNotSupportedForAnyRequestedSignal', 3), (u'ccpQorCannotBeMet', 4), (u'ccpUnableToModifyControlParameters', 5), (u'ccpMultiReferenceStationNotSupported', 6), (u'ccpNeighborListNotSupported', 7), (u'ccpSupportAreaAssistanceNotSupported', 8)])
    _OMA_LPPe_AGNSS_LocationServerErrorCauses_ccpErrorCauses._ext = []
    OMA_LPPe_AGNSS_LocationServerErrorCauses._cont = ASN1Dict([
        (u'waIonoErrorCauses', _OMA_LPPe_AGNSS_LocationServerErrorCauses_waIonoErrorCauses),
        (u'ccpErrorCauses', _OMA_LPPe_AGNSS_LocationServerErrorCauses_ccpErrorCauses),
        ])
    OMA_LPPe_AGNSS_LocationServerErrorCauses._ext = []
    
    #-----< OMA-LPPe-AGNSS-TargetDeviceErrorCauses >-----#
    OMA_LPPe_AGNSS_TargetDeviceErrorCauses = SEQ(name=u'OMA-LPPe-AGNSS-TargetDeviceErrorCauses', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_TargetDeviceErrorCauses_highAccuracyErrorCauses = ENUM(name=u'highAccuracyErrorCauses', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_TargetDeviceErrorCauses_highAccuracyErrorCauses._cont = ASN1Dict([(u'undefined', 0), (u'highAccuracyMethodNotSupported', 1)])
    _OMA_LPPe_AGNSS_TargetDeviceErrorCauses_highAccuracyErrorCauses._ext = []
    _OMA_LPPe_AGNSS_TargetDeviceErrorCauses_ionosphereMeasurementErrorCauses = ENUM(name=u'ionosphereMeasurementErrorCauses', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_TargetDeviceErrorCauses_ionosphereMeasurementErrorCauses._cont = ASN1Dict([(u'undefined', 0), (u'ionosphereMeasurementsNotSupported', 1), (u'ionosphereMeasurementsNotAvailable', 2)])
    _OMA_LPPe_AGNSS_TargetDeviceErrorCauses_ionosphereMeasurementErrorCauses._ext = []
    _OMA_LPPe_AGNSS_TargetDeviceErrorCauses_environmentObservationErrorCauses = ENUM(name=u'environmentObservationErrorCauses', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_TargetDeviceErrorCauses_environmentObservationErrorCauses._cont = ASN1Dict([(u'undefined', 0), (u'surfaceMeasurementsNotSupported', 1), (u'surfaceMeasurementsNotAvailable', 2)])
    _OMA_LPPe_AGNSS_TargetDeviceErrorCauses_environmentObservationErrorCauses._ext = []
    _OMA_LPPe_AGNSS_TargetDeviceErrorCauses_haGNSSerrorCauses = ENUM(name=u'haGNSSerrorCauses', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_TargetDeviceErrorCauses_haGNSSerrorCauses._cont = ASN1Dict([(u'undefined', 0), (u'haGNSSnotSupportedByTarget', 1), (u'haGNSSunavailableForAllRequestedSignals', 2), (u'haGNSSantennaInformationNotSupported', 3), (u'haGNSSantennaInformationNotAvailable', 4), (u'haGNSSpressureInformationNotSupported', 5), (u'haGNSSpressureInformationNotAvailable', 6), (u'haGNSSunableToModifyControlParameters', 7)])
    _OMA_LPPe_AGNSS_TargetDeviceErrorCauses_haGNSSerrorCauses._ext = []
    OMA_LPPe_AGNSS_TargetDeviceErrorCauses._cont = ASN1Dict([
        (u'highAccuracyErrorCauses', _OMA_LPPe_AGNSS_TargetDeviceErrorCauses_highAccuracyErrorCauses),
        (u'ionosphereMeasurementErrorCauses', _OMA_LPPe_AGNSS_TargetDeviceErrorCauses_ionosphereMeasurementErrorCauses),
        (u'environmentObservationErrorCauses', _OMA_LPPe_AGNSS_TargetDeviceErrorCauses_environmentObservationErrorCauses),
        (u'haGNSSerrorCauses', _OMA_LPPe_AGNSS_TargetDeviceErrorCauses_haGNSSerrorCauses),
        ])
    OMA_LPPe_AGNSS_TargetDeviceErrorCauses._ext = []
    
    #-----< OMA-LPPe-AGNSS-CCPreferenceStationID >-----#
    OMA_LPPe_AGNSS_CCPreferenceStationID = SEQ(name=u'OMA-LPPe-AGNSS-CCPreferenceStationID', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_CCPreferenceStationID_stationID = INT(name=u'stationID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_AGNSS_CCPreferenceStationID_stationID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    OMA_LPPe_AGNSS_CCPreferenceStationID._cont = ASN1Dict([
        (u'stationID', _OMA_LPPe_AGNSS_CCPreferenceStationID_stationID),
        ])
    OMA_LPPe_AGNSS_CCPreferenceStationID._ext = []
    
    #-----< maxReferenceStations >-----#
    maxReferenceStations = INT(name=u'maxReferenceStations', mode=MODE_VALUE)
    maxReferenceStations._val = 8
    
    #-----< OMA-LPPe-AGNSS-AntennaDescription >-----#
    OMA_LPPe_AGNSS_AntennaDescription = SEQ(name=u'OMA-LPPe-AGNSS-AntennaDescription', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_AntennaDescription_antennaDescription = CHOICE(name=u'antennaDescription', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __OMA_LPPe_AGNSS_AntennaDescription_antennaDescription_igsAntennaName = STR_VIS(name=u'igsAntennaName', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-CharArray')))
    __OMA_LPPe_AGNSS_AntennaDescription_antennaDescription_igsAntennaName._const_alpha = ASN1Set(rv=[u'.', u'-'], rr=[ASN1RangeStr(lb=u'a', ub=u'z'), ASN1RangeStr(lb=u'A', ub=u'Z'), ASN1RangeStr(lb=u'0', ub=u'9')], ev=None, er=[])
    __OMA_LPPe_AGNSS_AntennaDescription_antennaDescription_proprietaryName = STR_VIS(name=u'proprietaryName', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-CharArray')))
    __OMA_LPPe_AGNSS_AntennaDescription_antennaDescription_proprietaryName._const_alpha = ASN1Set(rv=[u'.', u'-'], rr=[ASN1RangeStr(lb=u'a', ub=u'z'), ASN1RangeStr(lb=u'A', ub=u'Z'), ASN1RangeStr(lb=u'0', ub=u'9')], ev=None, er=[])
    _OMA_LPPe_AGNSS_AntennaDescription_antennaDescription._cont = ASN1Dict([
        (u'igsAntennaName', __OMA_LPPe_AGNSS_AntennaDescription_antennaDescription_igsAntennaName),
        (u'proprietaryName', __OMA_LPPe_AGNSS_AntennaDescription_antennaDescription_proprietaryName),
        ])
    _OMA_LPPe_AGNSS_AntennaDescription_antennaDescription._ext = []
    _OMA_LPPe_AGNSS_AntennaDescription_antennaSetupID = INT(name=u'antennaSetupID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_AGNSS_AntennaDescription_antennaSetupID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _OMA_LPPe_AGNSS_AntennaDescription_antennaSerialNumber = STR_VIS(name=u'antennaSerialNumber', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-CharArray')), opt=True)
    _OMA_LPPe_AGNSS_AntennaDescription_antennaSerialNumber._const_alpha = ASN1Set(rv=[u'.', u'-'], rr=[ASN1RangeStr(lb=u'a', ub=u'z'), ASN1RangeStr(lb=u'A', ub=u'Z'), ASN1RangeStr(lb=u'0', ub=u'9')], ev=None, er=[])
    OMA_LPPe_AGNSS_AntennaDescription._cont = ASN1Dict([
        (u'antennaDescription', _OMA_LPPe_AGNSS_AntennaDescription_antennaDescription),
        (u'antennaSetupID', _OMA_LPPe_AGNSS_AntennaDescription_antennaSetupID),
        (u'antennaSerialNumber', _OMA_LPPe_AGNSS_AntennaDescription_antennaSerialNumber),
        ])
    OMA_LPPe_AGNSS_AntennaDescription._ext = []
    
    #-----< OMA-LPPe-AGNSS-Abort >-----#
    OMA_LPPe_AGNSS_Abort = SEQ(name=u'OMA-LPPe-AGNSS-Abort', mode=MODE_TYPE)
    _OMA_LPPe_AGNSS_Abort_targetDeviceAbortCauses = SEQ(name=u'targetDeviceAbortCauses', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OMA_LPPe_AGNSS_Abort_targetDeviceAbortCauses_ccpAbort = ENUM(name=u'ccpAbort', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OMA_LPPe_AGNSS_Abort_targetDeviceAbortCauses_ccpAbort._cont = ASN1Dict([(u'undefined', 0), (u'ccpNotSupported', 1), (u'ccpNotSupportedForProvidedSignals', 2)])
    __OMA_LPPe_AGNSS_Abort_targetDeviceAbortCauses_ccpAbort._ext = []
    __OMA_LPPe_AGNSS_Abort_targetDeviceAbortCauses_waIonoAbort = ENUM(name=u'waIonoAbort', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OMA_LPPe_AGNSS_Abort_targetDeviceAbortCauses_waIonoAbort._cont = ASN1Dict([(u'undefined', 0), (u'waIonoNotSupported', 1), (u'waIonoNotSupportedForProvidedGNSSs', 2)])
    __OMA_LPPe_AGNSS_Abort_targetDeviceAbortCauses_waIonoAbort._ext = []
    _OMA_LPPe_AGNSS_Abort_targetDeviceAbortCauses._cont = ASN1Dict([
        (u'ccpAbort', __OMA_LPPe_AGNSS_Abort_targetDeviceAbortCauses_ccpAbort),
        (u'waIonoAbort', __OMA_LPPe_AGNSS_Abort_targetDeviceAbortCauses_waIonoAbort),
        ])
    _OMA_LPPe_AGNSS_Abort_targetDeviceAbortCauses._ext = []
    OMA_LPPe_AGNSS_Abort._cont = ASN1Dict([
        (u'targetDeviceAbortCauses', _OMA_LPPe_AGNSS_Abort_targetDeviceAbortCauses),
        ])
    OMA_LPPe_AGNSS_Abort._ext = []
    
    #-----< OMA-LPPe-OTDOA-ProvideAssistanceData >-----#
    OMA_LPPe_OTDOA_ProvideAssistanceData = SEQ(name=u'OMA-LPPe-OTDOA-ProvideAssistanceData', mode=MODE_TYPE)
    _OMA_LPPe_OTDOA_ProvideAssistanceData_otdoa_ReferenceCellInfo = SEQ(name=u'otdoa-ReferenceCellInfo', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-ReferenceCellInfo')), opt=True)
    _OMA_LPPe_OTDOA_ProvideAssistanceData_otdoa_NeighbourCellInfo = SEQ_OF(name=u'otdoa-NeighbourCellInfo', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-NeighbourCellInfoList')), opt=True)
    _OMA_LPPe_OTDOA_ProvideAssistanceData_otdoa_Error = CHOICE(name=u'otdoa-Error', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-Error')), opt=True)
    OMA_LPPe_OTDOA_ProvideAssistanceData._cont = ASN1Dict([
        (u'otdoa-ReferenceCellInfo', _OMA_LPPe_OTDOA_ProvideAssistanceData_otdoa_ReferenceCellInfo),
        (u'otdoa-NeighbourCellInfo', _OMA_LPPe_OTDOA_ProvideAssistanceData_otdoa_NeighbourCellInfo),
        (u'otdoa-Error', _OMA_LPPe_OTDOA_ProvideAssistanceData_otdoa_Error),
        ])
    OMA_LPPe_OTDOA_ProvideAssistanceData._ext = []
    
    #-----< OMA-LPPe-OTDOA-ReferenceCellInfo >-----#
    OMA_LPPe_OTDOA_ReferenceCellInfo = SEQ(name=u'OMA-LPPe-OTDOA-ReferenceCellInfo', mode=MODE_TYPE)
    _OMA_LPPe_OTDOA_ReferenceCellInfo_referenceCellInfo = SEQ(name=u'referenceCellInfo', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'OTDOA-ReferenceCellInfo')))
    _OMA_LPPe_OTDOA_ReferenceCellInfo_positionCalculationInfoRef = SEQ(name=u'positionCalculationInfoRef', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-PositionCalculationInfoRef')))
    OMA_LPPe_OTDOA_ReferenceCellInfo._cont = ASN1Dict([
        (u'referenceCellInfo', _OMA_LPPe_OTDOA_ReferenceCellInfo_referenceCellInfo),
        (u'positionCalculationInfoRef', _OMA_LPPe_OTDOA_ReferenceCellInfo_positionCalculationInfoRef),
        ])
    OMA_LPPe_OTDOA_ReferenceCellInfo._ext = []
    
    #-----< OMA-LPPe-OTDOA-PositionCalculationInfoRef >-----#
    OMA_LPPe_OTDOA_PositionCalculationInfoRef = SEQ(name=u'OMA-LPPe-OTDOA-PositionCalculationInfoRef', mode=MODE_TYPE)
    _OMA_LPPe_OTDOA_PositionCalculationInfoRef_systemFrameNumber = BIT_STR(name=u'systemFrameNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_OTDOA_PositionCalculationInfoRef_systemFrameNumber._const_sz = ASN1Set(rv=[10], rr=[], ev=None, er=[])
    _OMA_LPPe_OTDOA_PositionCalculationInfoRef_rtdReferenceStd = SEQ(name=u'rtdReferenceStd', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-RTDquality')), opt=True)
    _OMA_LPPe_OTDOA_PositionCalculationInfoRef_cellLocation = SEQ(name=u'cellLocation', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_OTDOA_PositionCalculationInfoRef_cellLocation_reference_point = SEQ(name=u'reference-point', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-ReferencePoint')), opt=True)
    __OMA_LPPe_OTDOA_PositionCalculationInfoRef_cellLocation_relative_location = SEQ(name=u'relative-location', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-RelativeLocation')), opt=True)
    _OMA_LPPe_OTDOA_PositionCalculationInfoRef_cellLocation._cont = ASN1Dict([
        (u'reference-point', __OMA_LPPe_OTDOA_PositionCalculationInfoRef_cellLocation_reference_point),
        (u'relative-location', __OMA_LPPe_OTDOA_PositionCalculationInfoRef_cellLocation_relative_location),
        ])
    _OMA_LPPe_OTDOA_PositionCalculationInfoRef_cellLocation._ext = []
    _OMA_LPPe_OTDOA_PositionCalculationInfoRef_femtoCellInfo = SEQ(name=u'femtoCellInfo', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OMA_LPPe_OTDOA_PositionCalculationInfoRef_femtoCellInfo_location_reliability = INT(name=u'location-reliability', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OMA_LPPe_OTDOA_PositionCalculationInfoRef_femtoCellInfo_location_reliability._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=100)], ev=None, er=[])
    _OMA_LPPe_OTDOA_PositionCalculationInfoRef_femtoCellInfo._cont = ASN1Dict([
        (u'location-reliability', __OMA_LPPe_OTDOA_PositionCalculationInfoRef_femtoCellInfo_location_reliability),
        ])
    _OMA_LPPe_OTDOA_PositionCalculationInfoRef_femtoCellInfo._ext = []
    OMA_LPPe_OTDOA_PositionCalculationInfoRef._cont = ASN1Dict([
        (u'systemFrameNumber', _OMA_LPPe_OTDOA_PositionCalculationInfoRef_systemFrameNumber),
        (u'rtdReferenceStd', _OMA_LPPe_OTDOA_PositionCalculationInfoRef_rtdReferenceStd),
        (u'cellLocation', _OMA_LPPe_OTDOA_PositionCalculationInfoRef_cellLocation),
        (u'femtoCellInfo', _OMA_LPPe_OTDOA_PositionCalculationInfoRef_femtoCellInfo),
        ])
    OMA_LPPe_OTDOA_PositionCalculationInfoRef._ext = []
    
    #-----< OMA-LPPe-OTDOA-NeighbourCellInfoList >-----#
    OMA_LPPe_OTDOA_NeighbourCellInfoList = SEQ_OF(name=u'OMA-LPPe-OTDOA-NeighbourCellInfoList', mode=MODE_TYPE)
    _OMA_LPPe_OTDOA_NeighbourCellInfoList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-NeighbourFreqCellInfoList')))
    OMA_LPPe_OTDOA_NeighbourCellInfoList._cont = _OMA_LPPe_OTDOA_NeighbourCellInfoList__item_
    OMA_LPPe_OTDOA_NeighbourCellInfoList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=3)], ev=None, er=[])
    
    #-----< maxFreqLayers >-----#
    maxFreqLayers = INT(name=u'maxFreqLayers', mode=MODE_VALUE)
    maxFreqLayers._val = 3
    
    #-----< OMA-LPPe-OTDOA-NeighbourFreqCellInfoList >-----#
    OMA_LPPe_OTDOA_NeighbourFreqCellInfoList = SEQ(name=u'OMA-LPPe-OTDOA-NeighbourFreqCellInfoList', mode=MODE_TYPE)
    _OMA_LPPe_OTDOA_NeighbourFreqCellInfoList_neighbourCellInfoList_eNB = SEQ_OF(name=u'neighbourCellInfoList-eNB', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OMA_LPPe_OTDOA_NeighbourFreqCellInfoList_neighbourCellInfoList_eNB__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-NeighbourCellInfoElement-eNB')))
    _OMA_LPPe_OTDOA_NeighbourFreqCellInfoList_neighbourCellInfoList_eNB._cont = __OMA_LPPe_OTDOA_NeighbourFreqCellInfoList_neighbourCellInfoList_eNB__item_
    _OMA_LPPe_OTDOA_NeighbourFreqCellInfoList_neighbourCellInfoList_eNB._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    _OMA_LPPe_OTDOA_NeighbourFreqCellInfoList_neighbourCellInfoList_HeNB = SEQ_OF(name=u'neighbourCellInfoList-HeNB', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OMA_LPPe_OTDOA_NeighbourFreqCellInfoList_neighbourCellInfoList_HeNB__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-NeighbourCellInfoElement-HeNB')))
    _OMA_LPPe_OTDOA_NeighbourFreqCellInfoList_neighbourCellInfoList_HeNB._cont = __OMA_LPPe_OTDOA_NeighbourFreqCellInfoList_neighbourCellInfoList_HeNB__item_
    _OMA_LPPe_OTDOA_NeighbourFreqCellInfoList_neighbourCellInfoList_HeNB._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    OMA_LPPe_OTDOA_NeighbourFreqCellInfoList._cont = ASN1Dict([
        (u'neighbourCellInfoList-eNB', _OMA_LPPe_OTDOA_NeighbourFreqCellInfoList_neighbourCellInfoList_eNB),
        (u'neighbourCellInfoList-HeNB', _OMA_LPPe_OTDOA_NeighbourFreqCellInfoList_neighbourCellInfoList_HeNB),
        ])
    OMA_LPPe_OTDOA_NeighbourFreqCellInfoList._ext = []
    
    #-----< OMA-LPPe-OTDOA-NeighbourCellInfoElement-eNB >-----#
    OMA_LPPe_OTDOA_NeighbourCellInfoElement_eNB = SEQ(name=u'OMA-LPPe-OTDOA-NeighbourCellInfoElement-eNB', mode=MODE_TYPE)
    _OMA_LPPe_OTDOA_NeighbourCellInfoElement_eNB_relative_Location = SEQ(name=u'relative-Location', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-RelativeLocation')))
    _OMA_LPPe_OTDOA_NeighbourCellInfoElement_eNB_otdoa_eNB_CellDataList = SEQ_OF(name=u'otdoa-eNB-CellDataList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_OTDOA_NeighbourCellInfoElement_eNB_otdoa_eNB_CellDataList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-CellData')))
    _OMA_LPPe_OTDOA_NeighbourCellInfoElement_eNB_otdoa_eNB_CellDataList._cont = __OMA_LPPe_OTDOA_NeighbourCellInfoElement_eNB_otdoa_eNB_CellDataList__item_
    _OMA_LPPe_OTDOA_NeighbourCellInfoElement_eNB_otdoa_eNB_CellDataList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    OMA_LPPe_OTDOA_NeighbourCellInfoElement_eNB._cont = ASN1Dict([
        (u'relative-Location', _OMA_LPPe_OTDOA_NeighbourCellInfoElement_eNB_relative_Location),
        (u'otdoa-eNB-CellDataList', _OMA_LPPe_OTDOA_NeighbourCellInfoElement_eNB_otdoa_eNB_CellDataList),
        ])
    OMA_LPPe_OTDOA_NeighbourCellInfoElement_eNB._ext = []
    
    #-----< OMA-LPPe-OTDOA-NeighbourCellInfoElement-HeNB >-----#
    OMA_LPPe_OTDOA_NeighbourCellInfoElement_HeNB = SEQ(name=u'OMA-LPPe-OTDOA-NeighbourCellInfoElement-HeNB', mode=MODE_TYPE)
    _OMA_LPPe_OTDOA_NeighbourCellInfoElement_HeNB_relative_Location = SEQ(name=u'relative-Location', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-RelativeLocation')))
    _OMA_LPPe_OTDOA_NeighbourCellInfoElement_HeNB_location_reliability = INT(name=u'location-reliability', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_OTDOA_NeighbourCellInfoElement_HeNB_location_reliability._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=100)], ev=None, er=[])
    _OMA_LPPe_OTDOA_NeighbourCellInfoElement_HeNB_otdoa_HeNB_CellDataList = SEQ(name=u'otdoa-HeNB-CellDataList', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-CellData')))
    OMA_LPPe_OTDOA_NeighbourCellInfoElement_HeNB._cont = ASN1Dict([
        (u'relative-Location', _OMA_LPPe_OTDOA_NeighbourCellInfoElement_HeNB_relative_Location),
        (u'location-reliability', _OMA_LPPe_OTDOA_NeighbourCellInfoElement_HeNB_location_reliability),
        (u'otdoa-HeNB-CellDataList', _OMA_LPPe_OTDOA_NeighbourCellInfoElement_HeNB_otdoa_HeNB_CellDataList),
        ])
    OMA_LPPe_OTDOA_NeighbourCellInfoElement_HeNB._ext = []
    
    #-----< OMA-LPPe-OTDOA-CellData >-----#
    OMA_LPPe_OTDOA_CellData = SEQ(name=u'OMA-LPPe-OTDOA-CellData', mode=MODE_TYPE)
    _OMA_LPPe_OTDOA_CellData_otdoa_NeighbourCellInfoElement = SEQ(name=u'otdoa-NeighbourCellInfoElement', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'OTDOA-NeighbourCellInfoElement')))
    _OMA_LPPe_OTDOA_CellData_rtdInfo = SEQ(name=u'rtdInfo', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_OTDOA_CellData_rtdInfo_subframeOffset = INT(name=u'subframeOffset', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OMA_LPPe_OTDOA_CellData_rtdInfo_subframeOffset._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=10229)], ev=None, er=[])
    __OMA_LPPe_OTDOA_CellData_rtdInfo_fineRTD = INT(name=u'fineRTD', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_OTDOA_CellData_rtdInfo_fineRTD._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=99999)], ev=None, er=[])
    __OMA_LPPe_OTDOA_CellData_rtdInfo_fineRTDstd = SEQ(name=u'fineRTDstd', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-RTDquality')))
    __OMA_LPPe_OTDOA_CellData_rtdInfo_fineRTDdriftRate = INT(name=u'fineRTDdriftRate', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OMA_LPPe_OTDOA_CellData_rtdInfo_fineRTDdriftRate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-100, ub=100)], ev=None, er=[])
    _OMA_LPPe_OTDOA_CellData_rtdInfo._cont = ASN1Dict([
        (u'subframeOffset', __OMA_LPPe_OTDOA_CellData_rtdInfo_subframeOffset),
        (u'fineRTD', __OMA_LPPe_OTDOA_CellData_rtdInfo_fineRTD),
        (u'fineRTDstd', __OMA_LPPe_OTDOA_CellData_rtdInfo_fineRTDstd),
        (u'fineRTDdriftRate', __OMA_LPPe_OTDOA_CellData_rtdInfo_fineRTDdriftRate),
        ])
    _OMA_LPPe_OTDOA_CellData_rtdInfo._ext = []
    OMA_LPPe_OTDOA_CellData._cont = ASN1Dict([
        (u'otdoa-NeighbourCellInfoElement', _OMA_LPPe_OTDOA_CellData_otdoa_NeighbourCellInfoElement),
        (u'rtdInfo', _OMA_LPPe_OTDOA_CellData_rtdInfo),
        ])
    OMA_LPPe_OTDOA_CellData._ext = []
    
    #-----< OMA-LPPe-OTDOA-RTDquality >-----#
    OMA_LPPe_OTDOA_RTDquality = SEQ(name=u'OMA-LPPe-OTDOA-RTDquality', mode=MODE_TYPE)
    _OMA_LPPe_OTDOA_RTDquality_resolution = ENUM(name=u'resolution', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_OTDOA_RTDquality_resolution._cont = ASN1Dict([(u'ns-5', 0), (u'ns-10', 1), (u'ns-50', 2), (u'ns-100', 3)])
    _OMA_LPPe_OTDOA_RTDquality_resolution._ext = []
    _OMA_LPPe_OTDOA_RTDquality_quality = INT(name=u'quality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_OTDOA_RTDquality_quality._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    OMA_LPPe_OTDOA_RTDquality._cont = ASN1Dict([
        (u'resolution', _OMA_LPPe_OTDOA_RTDquality_resolution),
        (u'quality', _OMA_LPPe_OTDOA_RTDquality_quality),
        ])
    OMA_LPPe_OTDOA_RTDquality._ext = []
    
    #-----< OMA-LPPe-OTDOA-RequestAssistanceData >-----#
    OMA_LPPe_OTDOA_RequestAssistanceData = SEQ(name=u'OMA-LPPe-OTDOA-RequestAssistanceData', mode=MODE_TYPE)
    _OMA_LPPe_OTDOA_RequestAssistanceData_lteCell = SEQ(name=u'lteCell', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_OTDOA_RequestAssistanceData_lteCell_physCellId = INT(name=u'physCellId', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OMA_LPPe_OTDOA_RequestAssistanceData_lteCell_physCellId._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=503)], ev=None, er=[])
    __OMA_LPPe_OTDOA_RequestAssistanceData_lteCell_eARFCN = INT(name=u'eARFCN', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'ARFCN-ValueEUTRA')))
    __OMA_LPPe_OTDOA_RequestAssistanceData_lteCell_ecgi = SEQ(name=u'ecgi', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'CellGlobalIdEUTRA-AndUTRA')), opt=True)
    _OMA_LPPe_OTDOA_RequestAssistanceData_lteCell._cont = ASN1Dict([
        (u'physCellId', __OMA_LPPe_OTDOA_RequestAssistanceData_lteCell_physCellId),
        (u'eARFCN', __OMA_LPPe_OTDOA_RequestAssistanceData_lteCell_eARFCN),
        (u'ecgi', __OMA_LPPe_OTDOA_RequestAssistanceData_lteCell_ecgi),
        ])
    _OMA_LPPe_OTDOA_RequestAssistanceData_lteCell._ext = []
    _OMA_LPPe_OTDOA_RequestAssistanceData_requestedCells = BIT_STR(name=u'requestedCells', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_OTDOA_RequestAssistanceData_requestedCells._cont = ASN1Dict([(u'eNBs', 0), (u'heNBs', 1)])
    _OMA_LPPe_OTDOA_RequestAssistanceData_requestedCells._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    OMA_LPPe_OTDOA_RequestAssistanceData._cont = ASN1Dict([
        (u'lteCell', _OMA_LPPe_OTDOA_RequestAssistanceData_lteCell),
        (u'requestedCells', _OMA_LPPe_OTDOA_RequestAssistanceData_requestedCells),
        ])
    OMA_LPPe_OTDOA_RequestAssistanceData._ext = []
    
    #-----< OMA-LPPe-OTDOA-ProvideLocationInformation >-----#
    OMA_LPPe_OTDOA_ProvideLocationInformation = SEQ(name=u'OMA-LPPe-OTDOA-ProvideLocationInformation', mode=MODE_TYPE)
    _OMA_LPPe_OTDOA_ProvideLocationInformation_otdoaLocationInformation = SEQ(name=u'otdoaLocationInformation', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-LocationInformation')), opt=True)
    _OMA_LPPe_OTDOA_ProvideLocationInformation_otdoaError = CHOICE(name=u'otdoaError', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-Error')), opt=True)
    OMA_LPPe_OTDOA_ProvideLocationInformation._cont = ASN1Dict([
        (u'otdoaLocationInformation', _OMA_LPPe_OTDOA_ProvideLocationInformation_otdoaLocationInformation),
        (u'otdoaError', _OMA_LPPe_OTDOA_ProvideLocationInformation_otdoaError),
        ])
    OMA_LPPe_OTDOA_ProvideLocationInformation._ext = []
    
    #-----< OMA-LPPe-OTDOA-LocationInformation >-----#
    OMA_LPPe_OTDOA_LocationInformation = SEQ(name=u'OMA-LPPe-OTDOA-LocationInformation', mode=MODE_TYPE)
    _OMA_LPPe_OTDOA_LocationInformation_systemFrameNumber = BIT_STR(name=u'systemFrameNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_OTDOA_LocationInformation_systemFrameNumber._const_sz = ASN1Set(rv=[10], rr=[], ev=None, er=[])
    _OMA_LPPe_OTDOA_LocationInformation_physCellId = INT(name=u'physCellId', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_OTDOA_LocationInformation_physCellId._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=503)], ev=None, er=[])
    _OMA_LPPe_OTDOA_LocationInformation_cellGlobalId = SEQ(name=u'cellGlobalId', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'CellGlobalIdEUTRA-AndUTRA')), opt=True)
    OMA_LPPe_OTDOA_LocationInformation._cont = ASN1Dict([
        (u'systemFrameNumber', _OMA_LPPe_OTDOA_LocationInformation_systemFrameNumber),
        (u'physCellId', _OMA_LPPe_OTDOA_LocationInformation_physCellId),
        (u'cellGlobalId', _OMA_LPPe_OTDOA_LocationInformation_cellGlobalId),
        ])
    OMA_LPPe_OTDOA_LocationInformation._ext = []
    
    #-----< OMA-LPPe-OTDOA-RequestLocationInformation >-----#
    OMA_LPPe_OTDOA_RequestLocationInformation = SEQ(name=u'OMA-LPPe-OTDOA-RequestLocationInformation', mode=MODE_TYPE)
    _OMA_LPPe_OTDOA_RequestLocationInformation_assistanceAvailability = BOOL(name=u'assistanceAvailability', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    OMA_LPPe_OTDOA_RequestLocationInformation._cont = ASN1Dict([
        (u'assistanceAvailability', _OMA_LPPe_OTDOA_RequestLocationInformation_assistanceAvailability),
        ])
    OMA_LPPe_OTDOA_RequestLocationInformation._ext = []
    
    #-----< OMA-LPPe-OTDOA-ProvideCapabilities >-----#
    OMA_LPPe_OTDOA_ProvideCapabilities = SEQ(name=u'OMA-LPPe-OTDOA-ProvideCapabilities', mode=MODE_TYPE)
    _OMA_LPPe_OTDOA_ProvideCapabilities_eNodeB_AD_sup = SEQ(name=u'eNodeB-AD-sup', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_OTDOA_ProvideCapabilities_eNodeB_AD_sup._cont = ASN1Dict([
        ])
    _OMA_LPPe_OTDOA_ProvideCapabilities_eNodeB_AD_sup._ext = []
    _OMA_LPPe_OTDOA_ProvideCapabilities_home_eNodeB_AD_sup = SEQ(name=u'home-eNodeB-AD-sup', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_OTDOA_ProvideCapabilities_home_eNodeB_AD_sup._cont = ASN1Dict([
        ])
    _OMA_LPPe_OTDOA_ProvideCapabilities_home_eNodeB_AD_sup._ext = []
    OMA_LPPe_OTDOA_ProvideCapabilities._cont = ASN1Dict([
        (u'eNodeB-AD-sup', _OMA_LPPe_OTDOA_ProvideCapabilities_eNodeB_AD_sup),
        (u'home-eNodeB-AD-sup', _OMA_LPPe_OTDOA_ProvideCapabilities_home_eNodeB_AD_sup),
        ])
    OMA_LPPe_OTDOA_ProvideCapabilities._ext = []
    
    #-----< OMA-LPPe-OTDOA-RequestCapabilities >-----#
    OMA_LPPe_OTDOA_RequestCapabilities = SEQ(name=u'OMA-LPPe-OTDOA-RequestCapabilities', mode=MODE_TYPE)
    OMA_LPPe_OTDOA_RequestCapabilities._cont = ASN1Dict([
        ])
    OMA_LPPe_OTDOA_RequestCapabilities._ext = []
    
    #-----< OMA-LPPe-OTDOA-Error >-----#
    OMA_LPPe_OTDOA_Error = CHOICE(name=u'OMA-LPPe-OTDOA-Error', mode=MODE_TYPE)
    _OMA_LPPe_OTDOA_Error_locationServerErrorCauses = SEQ(name=u'locationServerErrorCauses', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-LocationServerErrorCauses')))
    _OMA_LPPe_OTDOA_Error_targetDeviceErrorCauses = SEQ(name=u'targetDeviceErrorCauses', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-TargetDeviceErrorCauses')))
    OMA_LPPe_OTDOA_Error._cont = ASN1Dict([
        (u'locationServerErrorCauses', _OMA_LPPe_OTDOA_Error_locationServerErrorCauses),
        (u'targetDeviceErrorCauses', _OMA_LPPe_OTDOA_Error_targetDeviceErrorCauses),
        ])
    OMA_LPPe_OTDOA_Error._ext = []
    
    #-----< OMA-LPPe-OTDOA-LocationServerErrorCauses >-----#
    OMA_LPPe_OTDOA_LocationServerErrorCauses = SEQ(name=u'OMA-LPPe-OTDOA-LocationServerErrorCauses', mode=MODE_TYPE)
    _OMA_LPPe_OTDOA_LocationServerErrorCauses_cause = ENUM(name=u'cause', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_OTDOA_LocationServerErrorCauses_cause._cont = ASN1Dict([(u'undefined', 0), (u'locationCalculationAssistanceDataNotSupported', 1), (u'locationCalculationAssistanceDataSupportedButCurrentlyNotAvailable', 2)])
    _OMA_LPPe_OTDOA_LocationServerErrorCauses_cause._ext = []
    OMA_LPPe_OTDOA_LocationServerErrorCauses._cont = ASN1Dict([
        (u'cause', _OMA_LPPe_OTDOA_LocationServerErrorCauses_cause),
        ])
    OMA_LPPe_OTDOA_LocationServerErrorCauses._ext = []
    
    #-----< OMA-LPPe-OTDOA-TargetDeviceErrorCauses >-----#
    OMA_LPPe_OTDOA_TargetDeviceErrorCauses = SEQ(name=u'OMA-LPPe-OTDOA-TargetDeviceErrorCauses', mode=MODE_TYPE)
    _OMA_LPPe_OTDOA_TargetDeviceErrorCauses_cause = ENUM(name=u'cause', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_OTDOA_TargetDeviceErrorCauses_cause._cont = ASN1Dict([(u'undefined', 0), (u'there-were-not-enough-signals-received-for-ueBased-otdoa', 1), (u'location-calculation-assistance-data-missing', 2)])
    _OMA_LPPe_OTDOA_TargetDeviceErrorCauses_cause._ext = []
    OMA_LPPe_OTDOA_TargetDeviceErrorCauses._cont = ASN1Dict([
        (u'cause', _OMA_LPPe_OTDOA_TargetDeviceErrorCauses_cause),
        ])
    OMA_LPPe_OTDOA_TargetDeviceErrorCauses._ext = []
    
    #-----< OMA-LPPe-EOTD-ProvideAssistanceData >-----#
    OMA_LPPe_EOTD_ProvideAssistanceData = SEQ(name=u'OMA-LPPe-EOTD-ProvideAssistanceData', mode=MODE_TYPE)
    _OMA_LPPe_EOTD_ProvideAssistanceData_referenceBTS = SEQ(name=u'referenceBTS', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-EOTD-ReferenceBTSForAssistance')), opt=True)
    _OMA_LPPe_EOTD_ProvideAssistanceData_msrAssistDataList = SEQ_OF(name=u'msrAssistDataList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-EOTD-MsrAssistDataList')), opt=True)
    _OMA_LPPe_EOTD_ProvideAssistanceData_systemInfoAssistDataList = SEQ_OF(name=u'systemInfoAssistDataList', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-EOTD-SystemInfoAssistDataList')), opt=True)
    _OMA_LPPe_EOTD_ProvideAssistanceData_eotdError = CHOICE(name=u'eotdError', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-EOTD-Error')), opt=True)
    OMA_LPPe_EOTD_ProvideAssistanceData._cont = ASN1Dict([
        (u'referenceBTS', _OMA_LPPe_EOTD_ProvideAssistanceData_referenceBTS),
        (u'msrAssistDataList', _OMA_LPPe_EOTD_ProvideAssistanceData_msrAssistDataList),
        (u'systemInfoAssistDataList', _OMA_LPPe_EOTD_ProvideAssistanceData_systemInfoAssistDataList),
        (u'eotdError', _OMA_LPPe_EOTD_ProvideAssistanceData_eotdError),
        ])
    OMA_LPPe_EOTD_ProvideAssistanceData._ext = []
    
    #-----< OMA-LPPe-EOTD-ReferenceBTSForAssistance >-----#
    OMA_LPPe_EOTD_ReferenceBTSForAssistance = SEQ(name=u'OMA-LPPe-EOTD-ReferenceBTSForAssistance', mode=MODE_TYPE)
    _OMA_LPPe_EOTD_ReferenceBTSForAssistance_bsicAndCarrier = SEQ(name=u'bsicAndCarrier', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-CellNonUniqueIDGERAN')))
    _OMA_LPPe_EOTD_ReferenceBTSForAssistance_timeSlotScheme = ENUM(name=u'timeSlotScheme', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-EOTD-TimeSlotScheme')))
    _OMA_LPPe_EOTD_ReferenceBTSForAssistance_btsPosition = CHOICE(name=u'btsPosition', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __OMA_LPPe_EOTD_ReferenceBTSForAssistance_btsPosition_ellipsoidPoint = SEQ(name=u'ellipsoidPoint', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'Ellipsoid-Point')))
    __OMA_LPPe_EOTD_ReferenceBTSForAssistance_btsPosition_ellipsoidPointWithAltitudeAndUncertaintyEllipsoid = SEQ(name=u'ellipsoidPointWithAltitudeAndUncertaintyEllipsoid', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'EllipsoidPointWithAltitudeAndUncertaintyEllipsoid')))
    _OMA_LPPe_EOTD_ReferenceBTSForAssistance_btsPosition._cont = ASN1Dict([
        (u'ellipsoidPoint', __OMA_LPPe_EOTD_ReferenceBTSForAssistance_btsPosition_ellipsoidPoint),
        (u'ellipsoidPointWithAltitudeAndUncertaintyEllipsoid', __OMA_LPPe_EOTD_ReferenceBTSForAssistance_btsPosition_ellipsoidPointWithAltitudeAndUncertaintyEllipsoid),
        ])
    _OMA_LPPe_EOTD_ReferenceBTSForAssistance_btsPosition._ext = []
    OMA_LPPe_EOTD_ReferenceBTSForAssistance._cont = ASN1Dict([
        (u'bsicAndCarrier', _OMA_LPPe_EOTD_ReferenceBTSForAssistance_bsicAndCarrier),
        (u'timeSlotScheme', _OMA_LPPe_EOTD_ReferenceBTSForAssistance_timeSlotScheme),
        (u'btsPosition', _OMA_LPPe_EOTD_ReferenceBTSForAssistance_btsPosition),
        ])
    OMA_LPPe_EOTD_ReferenceBTSForAssistance._ext = []
    
    #-----< OMA-LPPe-EOTD-MsrAssistDataList >-----#
    OMA_LPPe_EOTD_MsrAssistDataList = SEQ_OF(name=u'OMA-LPPe-EOTD-MsrAssistDataList', mode=MODE_TYPE)
    _OMA_LPPe_EOTD_MsrAssistDataList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-EOTD-MsrAssistBTS')))
    OMA_LPPe_EOTD_MsrAssistDataList._cont = _OMA_LPPe_EOTD_MsrAssistDataList__item_
    OMA_LPPe_EOTD_MsrAssistDataList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=15)], ev=None, er=[])
    
    #-----< OMA-LPPe-EOTD-MsrAssistBTS >-----#
    OMA_LPPe_EOTD_MsrAssistBTS = SEQ(name=u'OMA-LPPe-EOTD-MsrAssistBTS', mode=MODE_TYPE)
    _OMA_LPPe_EOTD_MsrAssistBTS_bsicAndCarrier = SEQ(name=u'bsicAndCarrier', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-CellNonUniqueIDGERAN')))
    _OMA_LPPe_EOTD_MsrAssistBTS_multiFrameOffset = INT(name=u'multiFrameOffset', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-EOTD-MultiFrameOffset')))
    _OMA_LPPe_EOTD_MsrAssistBTS_timeSlotScheme = ENUM(name=u'timeSlotScheme', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-EOTD-TimeSlotScheme')))
    _OMA_LPPe_EOTD_MsrAssistBTS_roughRTD = INT(name=u'roughRTD', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-EOTD-RoughRTD')))
    _OMA_LPPe_EOTD_MsrAssistBTS_expectedOTD = SEQ(name=u'expectedOTD', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-EOTD-ExpectedOTD')))
    _OMA_LPPe_EOTD_MsrAssistBTS_calcAssistanceBTS = SEQ(name=u'calcAssistanceBTS', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-EOTD-CalcAssistanceBTS')), opt=True)
    OMA_LPPe_EOTD_MsrAssistBTS._cont = ASN1Dict([
        (u'bsicAndCarrier', _OMA_LPPe_EOTD_MsrAssistBTS_bsicAndCarrier),
        (u'multiFrameOffset', _OMA_LPPe_EOTD_MsrAssistBTS_multiFrameOffset),
        (u'timeSlotScheme', _OMA_LPPe_EOTD_MsrAssistBTS_timeSlotScheme),
        (u'roughRTD', _OMA_LPPe_EOTD_MsrAssistBTS_roughRTD),
        (u'expectedOTD', _OMA_LPPe_EOTD_MsrAssistBTS_expectedOTD),
        (u'calcAssistanceBTS', _OMA_LPPe_EOTD_MsrAssistBTS_calcAssistanceBTS),
        ])
    OMA_LPPe_EOTD_MsrAssistBTS._ext = []
    
    #-----< OMA-LPPe-EOTD-SystemInfoAssistDataList >-----#
    OMA_LPPe_EOTD_SystemInfoAssistDataList = SEQ_OF(name=u'OMA-LPPe-EOTD-SystemInfoAssistDataList', mode=MODE_TYPE)
    _OMA_LPPe_EOTD_SystemInfoAssistDataList__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-EOTD-SystemInfoAssistBTS')))
    OMA_LPPe_EOTD_SystemInfoAssistDataList._cont = _OMA_LPPe_EOTD_SystemInfoAssistDataList__item_
    OMA_LPPe_EOTD_SystemInfoAssistDataList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    
    #-----< OMA-LPPe-EOTD-SystemInfoAssistBTS >-----#
    OMA_LPPe_EOTD_SystemInfoAssistBTS = CHOICE(name=u'OMA-LPPe-EOTD-SystemInfoAssistBTS', mode=MODE_TYPE)
    _OMA_LPPe_EOTD_SystemInfoAssistBTS_notPresent = NULL(name=u'notPresent', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_EOTD_SystemInfoAssistBTS_present = SEQ(name=u'present', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-EOTD-AssistBTSData')))
    OMA_LPPe_EOTD_SystemInfoAssistBTS._cont = ASN1Dict([
        (u'notPresent', _OMA_LPPe_EOTD_SystemInfoAssistBTS_notPresent),
        (u'present', _OMA_LPPe_EOTD_SystemInfoAssistBTS_present),
        ])
    OMA_LPPe_EOTD_SystemInfoAssistBTS._ext = None
    
    #-----< OMA-LPPe-EOTD-AssistBTSData >-----#
    OMA_LPPe_EOTD_AssistBTSData = SEQ(name=u'OMA-LPPe-EOTD-AssistBTSData', mode=MODE_TYPE)
    _OMA_LPPe_EOTD_AssistBTSData_bsic = INT(name=u'bsic', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_EOTD_AssistBTSData_bsic._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    _OMA_LPPe_EOTD_AssistBTSData_multiFrameOffset = INT(name=u'multiFrameOffset', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-EOTD-MultiFrameOffset')))
    _OMA_LPPe_EOTD_AssistBTSData_timeSlotScheme = ENUM(name=u'timeSlotScheme', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-EOTD-TimeSlotScheme')))
    _OMA_LPPe_EOTD_AssistBTSData_roughRTD = INT(name=u'roughRTD', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-EOTD-RoughRTD')))
    _OMA_LPPe_EOTD_AssistBTSData_expectedOTD = SEQ(name=u'expectedOTD', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-EOTD-ExpectedOTD')), opt=True)
    _OMA_LPPe_EOTD_AssistBTSData_calcAssistanceBTS = SEQ(name=u'calcAssistanceBTS', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-EOTD-CalcAssistanceBTS')), opt=True)
    OMA_LPPe_EOTD_AssistBTSData._cont = ASN1Dict([
        (u'bsic', _OMA_LPPe_EOTD_AssistBTSData_bsic),
        (u'multiFrameOffset', _OMA_LPPe_EOTD_AssistBTSData_multiFrameOffset),
        (u'timeSlotScheme', _OMA_LPPe_EOTD_AssistBTSData_timeSlotScheme),
        (u'roughRTD', _OMA_LPPe_EOTD_AssistBTSData_roughRTD),
        (u'expectedOTD', _OMA_LPPe_EOTD_AssistBTSData_expectedOTD),
        (u'calcAssistanceBTS', _OMA_LPPe_EOTD_AssistBTSData_calcAssistanceBTS),
        ])
    OMA_LPPe_EOTD_AssistBTSData._ext = []
    
    #-----< OMA-LPPe-EOTD-CalcAssistanceBTS >-----#
    OMA_LPPe_EOTD_CalcAssistanceBTS = SEQ(name=u'OMA-LPPe-EOTD-CalcAssistanceBTS', mode=MODE_TYPE)
    _OMA_LPPe_EOTD_CalcAssistanceBTS_fineRTD = INT(name=u'fineRTD', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-EOTD-FineRTD')))
    _OMA_LPPe_EOTD_CalcAssistanceBTS_relativePos = SEQ(name=u'relativePos', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-EOTD-relativePos')))
    OMA_LPPe_EOTD_CalcAssistanceBTS._cont = ASN1Dict([
        (u'fineRTD', _OMA_LPPe_EOTD_CalcAssistanceBTS_fineRTD),
        (u'relativePos', _OMA_LPPe_EOTD_CalcAssistanceBTS_relativePos),
        ])
    OMA_LPPe_EOTD_CalcAssistanceBTS._ext = []
    
    #-----< OMA-LPPe-EOTD-relativePos >-----#
    OMA_LPPe_EOTD_relativePos = SEQ(name=u'OMA-LPPe-EOTD-relativePos', mode=MODE_TYPE)
    _OMA_LPPe_EOTD_relativePos_relativeNorth = INT(name=u'relativeNorth', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-EOTD-RelDistance')))
    _OMA_LPPe_EOTD_relativePos_relativeEast = INT(name=u'relativeEast', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-EOTD-RelDistance')))
    _OMA_LPPe_EOTD_relativePos_relativeAlt = INT(name=u'relativeAlt', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-EOTD-RelativeAlt')), opt=True)
    OMA_LPPe_EOTD_relativePos._cont = ASN1Dict([
        (u'relativeNorth', _OMA_LPPe_EOTD_relativePos_relativeNorth),
        (u'relativeEast', _OMA_LPPe_EOTD_relativePos_relativeEast),
        (u'relativeAlt', _OMA_LPPe_EOTD_relativePos_relativeAlt),
        ])
    OMA_LPPe_EOTD_relativePos._ext = []
    
    #-----< OMA-LPPe-EOTD-FineRTD >-----#
    OMA_LPPe_EOTD_FineRTD = INT(name=u'OMA-LPPe-EOTD-FineRTD', mode=MODE_TYPE)
    OMA_LPPe_EOTD_FineRTD._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    
    #-----< OMA-LPPe-EOTD-RelDistance >-----#
    OMA_LPPe_EOTD_RelDistance = INT(name=u'OMA-LPPe-EOTD-RelDistance', mode=MODE_TYPE)
    OMA_LPPe_EOTD_RelDistance._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-200000, ub=200000)], ev=None, er=[])
    
    #-----< OMA-LPPe-EOTD-RelativeAlt >-----#
    OMA_LPPe_EOTD_RelativeAlt = INT(name=u'OMA-LPPe-EOTD-RelativeAlt', mode=MODE_TYPE)
    OMA_LPPe_EOTD_RelativeAlt._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-4000, ub=4000)], ev=None, er=[])
    
    #-----< OMA-LPPe-EOTD-RequestAssistanceData >-----#
    OMA_LPPe_EOTD_RequestAssistanceData = SEQ(name=u'OMA-LPPe-EOTD-RequestAssistanceData', mode=MODE_TYPE)
    _OMA_LPPe_EOTD_RequestAssistanceData_eotdAssistanceReq = BIT_STR(name=u'eotdAssistanceReq', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_EOTD_RequestAssistanceData_eotdAssistanceReq._cont = ASN1Dict([(u'ueAssisted', 0), (u'ueBased', 1)])
    OMA_LPPe_EOTD_RequestAssistanceData._cont = ASN1Dict([
        (u'eotdAssistanceReq', _OMA_LPPe_EOTD_RequestAssistanceData_eotdAssistanceReq),
        ])
    OMA_LPPe_EOTD_RequestAssistanceData._ext = []
    
    #-----< OMA-LPPe-EOTD-ProvideLocationInformation >-----#
    OMA_LPPe_EOTD_ProvideLocationInformation = SEQ(name=u'OMA-LPPe-EOTD-ProvideLocationInformation', mode=MODE_TYPE)
    _OMA_LPPe_EOTD_ProvideLocationInformation_eotdMsrElement = SEQ(name=u'eotdMsrElement', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-EOTD-MsrElement')), opt=True)
    _OMA_LPPe_EOTD_ProvideLocationInformation_eotdError = CHOICE(name=u'eotdError', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-EOTD-Error')), opt=True)
    OMA_LPPe_EOTD_ProvideLocationInformation._cont = ASN1Dict([
        (u'eotdMsrElement', _OMA_LPPe_EOTD_ProvideLocationInformation_eotdMsrElement),
        (u'eotdError', _OMA_LPPe_EOTD_ProvideLocationInformation_eotdError),
        ])
    OMA_LPPe_EOTD_ProvideLocationInformation._ext = []
    
    #-----< OMA-LPPe-EOTD-MsrElement >-----#
    OMA_LPPe_EOTD_MsrElement = SEQ(name=u'OMA-LPPe-EOTD-MsrElement', mode=MODE_TYPE)
    _OMA_LPPe_EOTD_MsrElement_refFrameNumber = INT(name=u'refFrameNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_EOTD_MsrElement_refFrameNumber._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=42431)], ev=None, er=[])
    _OMA_LPPe_EOTD_MsrElement_referenceTimeSlot = INT(name=u'referenceTimeSlot', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-EOTD-ModuloTimeSlot')))
    _OMA_LPPe_EOTD_MsrElement_toaMeasurementsOfRef = SEQ(name=u'toaMeasurementsOfRef', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-EOTD-TOA-MeasurementsOfRef')), opt=True)
    _OMA_LPPe_EOTD_MsrElement_stdResolution = BIT_STR(name=u'stdResolution', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_EOTD_MsrElement_stdResolution._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    _OMA_LPPe_EOTD_MsrElement_taCorrection = INT(name=u'taCorrection', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_EOTD_MsrElement_taCorrection._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=960)], ev=None, er=[])
    _OMA_LPPe_EOTD_MsrElement_otd_FirstSetMsrs = SEQ_OF(name=u'otd-FirstSetMsrs', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OMA_LPPe_EOTD_MsrElement_otd_FirstSetMsrs__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-EOTD-MeasurementWithID')))
    _OMA_LPPe_EOTD_MsrElement_otd_FirstSetMsrs._cont = __OMA_LPPe_EOTD_MsrElement_otd_FirstSetMsrs__item_
    _OMA_LPPe_EOTD_MsrElement_otd_FirstSetMsrs._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=15)], ev=None, er=[])
    OMA_LPPe_EOTD_MsrElement._cont = ASN1Dict([
        (u'refFrameNumber', _OMA_LPPe_EOTD_MsrElement_refFrameNumber),
        (u'referenceTimeSlot', _OMA_LPPe_EOTD_MsrElement_referenceTimeSlot),
        (u'toaMeasurementsOfRef', _OMA_LPPe_EOTD_MsrElement_toaMeasurementsOfRef),
        (u'stdResolution', _OMA_LPPe_EOTD_MsrElement_stdResolution),
        (u'taCorrection', _OMA_LPPe_EOTD_MsrElement_taCorrection),
        (u'otd-FirstSetMsrs', _OMA_LPPe_EOTD_MsrElement_otd_FirstSetMsrs),
        ])
    OMA_LPPe_EOTD_MsrElement._ext = []
    
    #-----< OMA-LPPe-EOTD-TOA-MeasurementsOfRef >-----#
    OMA_LPPe_EOTD_TOA_MeasurementsOfRef = SEQ(name=u'OMA-LPPe-EOTD-TOA-MeasurementsOfRef', mode=MODE_TYPE)
    _OMA_LPPe_EOTD_TOA_MeasurementsOfRef_refQuality = BIT_STR(name=u'refQuality', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_EOTD_TOA_MeasurementsOfRef_refQuality._const_sz = ASN1Set(rv=[5], rr=[], ev=None, er=[])
    _OMA_LPPe_EOTD_TOA_MeasurementsOfRef_numOfMeasurements = BIT_STR(name=u'numOfMeasurements', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_EOTD_TOA_MeasurementsOfRef_numOfMeasurements._const_sz = ASN1Set(rv=[3], rr=[], ev=None, er=[])
    OMA_LPPe_EOTD_TOA_MeasurementsOfRef._cont = ASN1Dict([
        (u'refQuality', _OMA_LPPe_EOTD_TOA_MeasurementsOfRef_refQuality),
        (u'numOfMeasurements', _OMA_LPPe_EOTD_TOA_MeasurementsOfRef_numOfMeasurements),
        ])
    OMA_LPPe_EOTD_TOA_MeasurementsOfRef._ext = []
    
    #-----< OMA-LPPe-EOTD-MeasurementWithID >-----#
    OMA_LPPe_EOTD_MeasurementWithID = SEQ(name=u'OMA-LPPe-EOTD-MeasurementWithID', mode=MODE_TYPE)
    _OMA_LPPe_EOTD_MeasurementWithID_neighborIdentity = CHOICE(name=u'neighborIdentity', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-EOTD-NeighborIdentity')))
    _OMA_LPPe_EOTD_MeasurementWithID_nborTimeSlot = INT(name=u'nborTimeSlot', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-EOTD-ModuloTimeSlot')))
    _OMA_LPPe_EOTD_MeasurementWithID_eotdQuality = SEQ(name=u'eotdQuality', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-EOTD-EOTDQuality')))
    _OMA_LPPe_EOTD_MeasurementWithID_otdValue = INT(name=u'otdValue', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-EOTD-OTDValue')))
    OMA_LPPe_EOTD_MeasurementWithID._cont = ASN1Dict([
        (u'neighborIdentity', _OMA_LPPe_EOTD_MeasurementWithID_neighborIdentity),
        (u'nborTimeSlot', _OMA_LPPe_EOTD_MeasurementWithID_nborTimeSlot),
        (u'eotdQuality', _OMA_LPPe_EOTD_MeasurementWithID_eotdQuality),
        (u'otdValue', _OMA_LPPe_EOTD_MeasurementWithID_otdValue),
        ])
    OMA_LPPe_EOTD_MeasurementWithID._ext = []
    
    #-----< OMA-LPPe-EOTD-NeighborIdentity >-----#
    OMA_LPPe_EOTD_NeighborIdentity = CHOICE(name=u'OMA-LPPe-EOTD-NeighborIdentity', mode=MODE_TYPE)
    _OMA_LPPe_EOTD_NeighborIdentity_bsicAndCarrier = SEQ(name=u'bsicAndCarrier', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-CellNonUniqueIDGERAN')))
    _OMA_LPPe_EOTD_NeighborIdentity_ci = INT(name=u'ci', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-EOTD-CellID')))
    _OMA_LPPe_EOTD_NeighborIdentity_multiFrameCarrier = SEQ(name=u'multiFrameCarrier', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-EOTD-MultiFrameCarrier')))
    _OMA_LPPe_EOTD_NeighborIdentity_requestIndex = INT(name=u'requestIndex', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-EOTD-RequestIndex')))
    _OMA_LPPe_EOTD_NeighborIdentity_systemInfoIndex = INT(name=u'systemInfoIndex', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-EOTD-SystemInfoIndex')))
    _OMA_LPPe_EOTD_NeighborIdentity_ciAndLac = SEQ(name=u'ciAndLac', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-CellLocalIdGERAN')))
    OMA_LPPe_EOTD_NeighborIdentity._cont = ASN1Dict([
        (u'bsicAndCarrier', _OMA_LPPe_EOTD_NeighborIdentity_bsicAndCarrier),
        (u'ci', _OMA_LPPe_EOTD_NeighborIdentity_ci),
        (u'multiFrameCarrier', _OMA_LPPe_EOTD_NeighborIdentity_multiFrameCarrier),
        (u'requestIndex', _OMA_LPPe_EOTD_NeighborIdentity_requestIndex),
        (u'systemInfoIndex', _OMA_LPPe_EOTD_NeighborIdentity_systemInfoIndex),
        (u'ciAndLac', _OMA_LPPe_EOTD_NeighborIdentity_ciAndLac),
        ])
    OMA_LPPe_EOTD_NeighborIdentity._ext = []
    
    #-----< OMA-LPPe-EOTD-EOTDQuality >-----#
    OMA_LPPe_EOTD_EOTDQuality = SEQ(name=u'OMA-LPPe-EOTD-EOTDQuality', mode=MODE_TYPE)
    _OMA_LPPe_EOTD_EOTDQuality_nbrOfMeasurements = BIT_STR(name=u'nbrOfMeasurements', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_EOTD_EOTDQuality_nbrOfMeasurements._const_sz = ASN1Set(rv=[3], rr=[], ev=None, er=[])
    _OMA_LPPe_EOTD_EOTDQuality_stdOfEOTD = BIT_STR(name=u'stdOfEOTD', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_EOTD_EOTDQuality_stdOfEOTD._const_sz = ASN1Set(rv=[5], rr=[], ev=None, er=[])
    OMA_LPPe_EOTD_EOTDQuality._cont = ASN1Dict([
        (u'nbrOfMeasurements', _OMA_LPPe_EOTD_EOTDQuality_nbrOfMeasurements),
        (u'stdOfEOTD', _OMA_LPPe_EOTD_EOTDQuality_stdOfEOTD),
        ])
    OMA_LPPe_EOTD_EOTDQuality._ext = []
    
    #-----< OMA-LPPe-EOTD-OTDValue >-----#
    OMA_LPPe_EOTD_OTDValue = INT(name=u'OMA-LPPe-EOTD-OTDValue', mode=MODE_TYPE)
    OMA_LPPe_EOTD_OTDValue._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=39999)], ev=None, er=[])
    
    #-----< OMA-LPPe-EOTD-CellID >-----#
    OMA_LPPe_EOTD_CellID = INT(name=u'OMA-LPPe-EOTD-CellID', mode=MODE_TYPE)
    OMA_LPPe_EOTD_CellID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    
    #-----< OMA-LPPe-EOTD-RequestIndex >-----#
    OMA_LPPe_EOTD_RequestIndex = INT(name=u'OMA-LPPe-EOTD-RequestIndex', mode=MODE_TYPE)
    OMA_LPPe_EOTD_RequestIndex._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    
    #-----< OMA-LPPe-EOTD-SystemInfoIndex >-----#
    OMA_LPPe_EOTD_SystemInfoIndex = INT(name=u'OMA-LPPe-EOTD-SystemInfoIndex', mode=MODE_TYPE)
    OMA_LPPe_EOTD_SystemInfoIndex._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    
    #-----< OMA-LPPe-EOTD-MultiFrameCarrier >-----#
    OMA_LPPe_EOTD_MultiFrameCarrier = SEQ(name=u'OMA-LPPe-EOTD-MultiFrameCarrier', mode=MODE_TYPE)
    _OMA_LPPe_EOTD_MultiFrameCarrier_bcchCarrier = INT(name=u'bcchCarrier', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-EOTD-BCCHCarrier')))
    _OMA_LPPe_EOTD_MultiFrameCarrier_multiFrameOffset = INT(name=u'multiFrameOffset', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-EOTD-MultiFrameOffset')))
    OMA_LPPe_EOTD_MultiFrameCarrier._cont = ASN1Dict([
        (u'bcchCarrier', _OMA_LPPe_EOTD_MultiFrameCarrier_bcchCarrier),
        (u'multiFrameOffset', _OMA_LPPe_EOTD_MultiFrameCarrier_multiFrameOffset),
        ])
    OMA_LPPe_EOTD_MultiFrameCarrier._ext = []
    
    #-----< OMA-LPPe-EOTD-BCCHCarrier >-----#
    OMA_LPPe_EOTD_BCCHCarrier = INT(name=u'OMA-LPPe-EOTD-BCCHCarrier', mode=MODE_TYPE)
    OMA_LPPe_EOTD_BCCHCarrier._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=1023)], ev=None, er=[])
    
    #-----< OMA-LPPe-EOTD-RequestLocationInformation >-----#
    OMA_LPPe_EOTD_RequestLocationInformation = SEQ(name=u'OMA-LPPe-EOTD-RequestLocationInformation', mode=MODE_TYPE)
    OMA_LPPe_EOTD_RequestLocationInformation._cont = ASN1Dict([
        ])
    OMA_LPPe_EOTD_RequestLocationInformation._ext = []
    
    #-----< OMA-LPPe-EOTD-ProvideCapabilities >-----#
    OMA_LPPe_EOTD_ProvideCapabilities = SEQ(name=u'OMA-LPPe-EOTD-ProvideCapabilities', mode=MODE_TYPE)
    _OMA_LPPe_EOTD_ProvideCapabilities_eotdSupport = BIT_STR(name=u'eotdSupport', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_EOTD_ProvideCapabilities_eotdSupport._cont = ASN1Dict([(u'ueBased', 0), (u'ueAssisted', 1)])
    OMA_LPPe_EOTD_ProvideCapabilities._cont = ASN1Dict([
        (u'eotdSupport', _OMA_LPPe_EOTD_ProvideCapabilities_eotdSupport),
        ])
    OMA_LPPe_EOTD_ProvideCapabilities._ext = []
    
    #-----< OMA-LPPe-EOTD-RequestCapabilities >-----#
    OMA_LPPe_EOTD_RequestCapabilities = SEQ(name=u'OMA-LPPe-EOTD-RequestCapabilities', mode=MODE_TYPE)
    OMA_LPPe_EOTD_RequestCapabilities._cont = ASN1Dict([
        ])
    OMA_LPPe_EOTD_RequestCapabilities._ext = []
    
    #-----< OMA-LPPe-EOTD-Error >-----#
    OMA_LPPe_EOTD_Error = CHOICE(name=u'OMA-LPPe-EOTD-Error', mode=MODE_TYPE)
    _OMA_LPPe_EOTD_Error_locationServerErrorCauses = SEQ(name=u'locationServerErrorCauses', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-EOTD-LocationServerErrorCauses')))
    _OMA_LPPe_EOTD_Error_targetDeviceErrorCauses = SEQ(name=u'targetDeviceErrorCauses', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-EOTD-TargetDeviceErrorCauses')))
    OMA_LPPe_EOTD_Error._cont = ASN1Dict([
        (u'locationServerErrorCauses', _OMA_LPPe_EOTD_Error_locationServerErrorCauses),
        (u'targetDeviceErrorCauses', _OMA_LPPe_EOTD_Error_targetDeviceErrorCauses),
        ])
    OMA_LPPe_EOTD_Error._ext = []
    
    #-----< OMA-LPPe-EOTD-LocationServerErrorCauses >-----#
    OMA_LPPe_EOTD_LocationServerErrorCauses = SEQ(name=u'OMA-LPPe-EOTD-LocationServerErrorCauses', mode=MODE_TYPE)
    _OMA_LPPe_EOTD_LocationServerErrorCauses_cause = ENUM(name=u'cause', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_EOTD_LocationServerErrorCauses_cause._cont = ASN1Dict([(u'undefined', 0), (u'assistanceDataForUEbasedEOTDnotAvailable', 1), (u'assistanceDataForUEassistedEOTDnotAvailable', 2)])
    _OMA_LPPe_EOTD_LocationServerErrorCauses_cause._ext = []
    OMA_LPPe_EOTD_LocationServerErrorCauses._cont = ASN1Dict([
        (u'cause', _OMA_LPPe_EOTD_LocationServerErrorCauses_cause),
        ])
    OMA_LPPe_EOTD_LocationServerErrorCauses._ext = []
    
    #-----< OMA-LPPe-EOTD-TargetDeviceErrorCauses >-----#
    OMA_LPPe_EOTD_TargetDeviceErrorCauses = SEQ(name=u'OMA-LPPe-EOTD-TargetDeviceErrorCauses', mode=MODE_TYPE)
    _OMA_LPPe_EOTD_TargetDeviceErrorCauses_cause = ENUM(name=u'cause', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_EOTD_TargetDeviceErrorCauses_cause._cont = ASN1Dict([(u'undefinedError', 0), (u'notEnoughBTsforEOTD', 1), (u'assistanceDataMissing', 2), (u'referenceCellNotServingCell', 3), (u'eotdMeasurementsNotSupported', 4), (u'eotdMeasurementsNotAvailable', 5), (u'uebasedEOTDnotSupported', 6)])
    _OMA_LPPe_EOTD_TargetDeviceErrorCauses_cause._ext = []
    OMA_LPPe_EOTD_TargetDeviceErrorCauses._cont = ASN1Dict([
        (u'cause', _OMA_LPPe_EOTD_TargetDeviceErrorCauses_cause),
        ])
    OMA_LPPe_EOTD_TargetDeviceErrorCauses._ext = []
    
    #-----< OMA-LPPe-EOTD-TimeSlotScheme >-----#
    OMA_LPPe_EOTD_TimeSlotScheme = ENUM(name=u'OMA-LPPe-EOTD-TimeSlotScheme', mode=MODE_TYPE)
    OMA_LPPe_EOTD_TimeSlotScheme._cont = ASN1Dict([(u'equalLength', 0), (u'variousLength', 1)])
    OMA_LPPe_EOTD_TimeSlotScheme._ext = None
    
    #-----< OMA-LPPe-EOTD-MultiFrameOffset >-----#
    OMA_LPPe_EOTD_MultiFrameOffset = INT(name=u'OMA-LPPe-EOTD-MultiFrameOffset', mode=MODE_TYPE)
    OMA_LPPe_EOTD_MultiFrameOffset._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=51)], ev=None, er=[])
    
    #-----< OMA-LPPe-EOTD-RoughRTD >-----#
    OMA_LPPe_EOTD_RoughRTD = INT(name=u'OMA-LPPe-EOTD-RoughRTD', mode=MODE_TYPE)
    OMA_LPPe_EOTD_RoughRTD._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=1250)], ev=None, er=[])
    
    #-----< OMA-LPPe-EOTD-ExpectedOTD >-----#
    OMA_LPPe_EOTD_ExpectedOTD = SEQ(name=u'OMA-LPPe-EOTD-ExpectedOTD', mode=MODE_TYPE)
    _OMA_LPPe_EOTD_ExpectedOTD_expectedOTD = INT(name=u'expectedOTD', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_EOTD_ExpectedOTD_expectedOTD._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=1250)], ev=None, er=[])
    _OMA_LPPe_EOTD_ExpectedOTD_expOTDUncertainty = INT(name=u'expOTDUncertainty', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_EOTD_ExpectedOTD_expOTDUncertainty._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=7)], ev=None, er=[])
    OMA_LPPe_EOTD_ExpectedOTD._cont = ASN1Dict([
        (u'expectedOTD', _OMA_LPPe_EOTD_ExpectedOTD_expectedOTD),
        (u'expOTDUncertainty', _OMA_LPPe_EOTD_ExpectedOTD_expOTDUncertainty),
        ])
    OMA_LPPe_EOTD_ExpectedOTD._ext = []
    
    #-----< OMA-LPPe-EOTD-ModuloTimeSlot >-----#
    OMA_LPPe_EOTD_ModuloTimeSlot = INT(name=u'OMA-LPPe-EOTD-ModuloTimeSlot', mode=MODE_TYPE)
    OMA_LPPe_EOTD_ModuloTimeSlot._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=3)], ev=None, er=[])
    
    #-----< OMA-LPPe-OTDOA-UTRA-ProvideAssistanceData >-----#
    OMA_LPPe_OTDOA_UTRA_ProvideAssistanceData = SEQ(name=u'OMA-LPPe-OTDOA-UTRA-ProvideAssistanceData', mode=MODE_TYPE)
    _OMA_LPPe_OTDOA_UTRA_ProvideAssistanceData_referenceCellInfo = SEQ(name=u'referenceCellInfo', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-UTRA-ReferenceCellInfo')), opt=True)
    _OMA_LPPe_OTDOA_UTRA_ProvideAssistanceData_neigborCellList = SEQ_OF(name=u'neigborCellList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-UTRA-NeighborCellList')), opt=True)
    _OMA_LPPe_OTDOA_UTRA_ProvideAssistanceData_otdoaUtraError = CHOICE(name=u'otdoaUtraError', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-UTRA-Error')), opt=True)
    OMA_LPPe_OTDOA_UTRA_ProvideAssistanceData._cont = ASN1Dict([
        (u'referenceCellInfo', _OMA_LPPe_OTDOA_UTRA_ProvideAssistanceData_referenceCellInfo),
        (u'neigborCellList', _OMA_LPPe_OTDOA_UTRA_ProvideAssistanceData_neigborCellList),
        (u'otdoaUtraError', _OMA_LPPe_OTDOA_UTRA_ProvideAssistanceData_otdoaUtraError),
        ])
    OMA_LPPe_OTDOA_UTRA_ProvideAssistanceData._ext = []
    
    #-----< OMA-LPPe-OTDOA-UTRA-ReferenceCellInfo >-----#
    OMA_LPPe_OTDOA_UTRA_ReferenceCellInfo = SEQ(name=u'OMA-LPPe-OTDOA-UTRA-ReferenceCellInfo', mode=MODE_TYPE)
    _OMA_LPPe_OTDOA_UTRA_ReferenceCellInfo_sfn = INT(name=u'sfn', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_OTDOA_UTRA_ReferenceCellInfo_sfn._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4095)], ev=None, er=[])
    _OMA_LPPe_OTDOA_UTRA_ReferenceCellInfo_modeSpecificInfo = CHOICE(name=u'modeSpecificInfo', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __OMA_LPPe_OTDOA_UTRA_ReferenceCellInfo_modeSpecificInfo_fdd = SEQ(name=u'fdd', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___OMA_LPPe_OTDOA_UTRA_ReferenceCellInfo_modeSpecificInfo_fdd_primaryCPICH_info = SEQ(name=u'primaryCPICH-info', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-UTRA-PrimaryCPICH-Info')))
    __OMA_LPPe_OTDOA_UTRA_ReferenceCellInfo_modeSpecificInfo_fdd._cont = ASN1Dict([
        (u'primaryCPICH-info', ___OMA_LPPe_OTDOA_UTRA_ReferenceCellInfo_modeSpecificInfo_fdd_primaryCPICH_info),
        ])
    __OMA_LPPe_OTDOA_UTRA_ReferenceCellInfo_modeSpecificInfo_fdd._ext = None
    __OMA_LPPe_OTDOA_UTRA_ReferenceCellInfo_modeSpecificInfo_tdd = SEQ(name=u'tdd', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___OMA_LPPe_OTDOA_UTRA_ReferenceCellInfo_modeSpecificInfo_tdd_cellAndChannelIdentity = SEQ(name=u'cellAndChannelIdentity', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-UTRA-CellAndChannelIdentity')))
    __OMA_LPPe_OTDOA_UTRA_ReferenceCellInfo_modeSpecificInfo_tdd._cont = ASN1Dict([
        (u'cellAndChannelIdentity', ___OMA_LPPe_OTDOA_UTRA_ReferenceCellInfo_modeSpecificInfo_tdd_cellAndChannelIdentity),
        ])
    __OMA_LPPe_OTDOA_UTRA_ReferenceCellInfo_modeSpecificInfo_tdd._ext = None
    _OMA_LPPe_OTDOA_UTRA_ReferenceCellInfo_modeSpecificInfo._cont = ASN1Dict([
        (u'fdd', __OMA_LPPe_OTDOA_UTRA_ReferenceCellInfo_modeSpecificInfo_fdd),
        (u'tdd', __OMA_LPPe_OTDOA_UTRA_ReferenceCellInfo_modeSpecificInfo_tdd),
        ])
    _OMA_LPPe_OTDOA_UTRA_ReferenceCellInfo_modeSpecificInfo._ext = None
    _OMA_LPPe_OTDOA_UTRA_ReferenceCellInfo_frequencyInfo = SEQ(name=u'frequencyInfo', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-UTRA-FrequencyInfo')), opt=True)
    _OMA_LPPe_OTDOA_UTRA_ReferenceCellInfo_refPosAssist = SEQ(name=u'refPosAssist', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-UTRA-RefPosAssist')), opt=True)
    _OMA_LPPe_OTDOA_UTRA_ReferenceCellInfo_ipdl_parameters = SEQ(name=u'ipdl-parameters', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-UTRA-IPDL-Parameters')), opt=True)
    OMA_LPPe_OTDOA_UTRA_ReferenceCellInfo._cont = ASN1Dict([
        (u'sfn', _OMA_LPPe_OTDOA_UTRA_ReferenceCellInfo_sfn),
        (u'modeSpecificInfo', _OMA_LPPe_OTDOA_UTRA_ReferenceCellInfo_modeSpecificInfo),
        (u'frequencyInfo', _OMA_LPPe_OTDOA_UTRA_ReferenceCellInfo_frequencyInfo),
        (u'refPosAssist', _OMA_LPPe_OTDOA_UTRA_ReferenceCellInfo_refPosAssist),
        (u'ipdl-parameters', _OMA_LPPe_OTDOA_UTRA_ReferenceCellInfo_ipdl_parameters),
        ])
    OMA_LPPe_OTDOA_UTRA_ReferenceCellInfo._ext = []
    
    #-----< OMA-LPPe-OTDOA-UTRA-RefPosAssist >-----#
    OMA_LPPe_OTDOA_UTRA_RefPosAssist = SEQ(name=u'OMA-LPPe-OTDOA-UTRA-RefPosAssist', mode=MODE_TYPE)
    _OMA_LPPe_OTDOA_UTRA_RefPosAssist_cellPosition = CHOICE(name=u'cellPosition', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __OMA_LPPe_OTDOA_UTRA_RefPosAssist_cellPosition_ellipsoidPoint = SEQ(name=u'ellipsoidPoint', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'Ellipsoid-Point')))
    __OMA_LPPe_OTDOA_UTRA_RefPosAssist_cellPosition_ellipsoidPointWithAltitude = SEQ(name=u'ellipsoidPointWithAltitude', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('LPP-PDU-Definitions', 'EllipsoidPointWithAltitude')))
    _OMA_LPPe_OTDOA_UTRA_RefPosAssist_cellPosition._cont = ASN1Dict([
        (u'ellipsoidPoint', __OMA_LPPe_OTDOA_UTRA_RefPosAssist_cellPosition_ellipsoidPoint),
        (u'ellipsoidPointWithAltitude', __OMA_LPPe_OTDOA_UTRA_RefPosAssist_cellPosition_ellipsoidPointWithAltitude),
        ])
    _OMA_LPPe_OTDOA_UTRA_RefPosAssist_cellPosition._ext = []
    _OMA_LPPe_OTDOA_UTRA_RefPosAssist_roundTripTime = INT(name=u'roundTripTime', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_OTDOA_UTRA_RefPosAssist_roundTripTime._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=32766)], ev=None, er=[])
    _OMA_LPPe_OTDOA_UTRA_RefPosAssist_roundTripTimeExtension = INT(name=u'roundTripTimeExtension', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_OTDOA_UTRA_RefPosAssist_roundTripTimeExtension._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=70274)], ev=None, er=[])
    OMA_LPPe_OTDOA_UTRA_RefPosAssist._cont = ASN1Dict([
        (u'cellPosition', _OMA_LPPe_OTDOA_UTRA_RefPosAssist_cellPosition),
        (u'roundTripTime', _OMA_LPPe_OTDOA_UTRA_RefPosAssist_roundTripTime),
        (u'roundTripTimeExtension', _OMA_LPPe_OTDOA_UTRA_RefPosAssist_roundTripTimeExtension),
        ])
    OMA_LPPe_OTDOA_UTRA_RefPosAssist._ext = []
    
    #-----< OMA-LPPe-OTDOA-UTRA-NeighborCellList >-----#
    OMA_LPPe_OTDOA_UTRA_NeighborCellList = SEQ_OF(name=u'OMA-LPPe-OTDOA-UTRA-NeighborCellList', mode=MODE_TYPE)
    _OMA_LPPe_OTDOA_UTRA_NeighborCellList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-UTRA-NeighborCellInfo')))
    OMA_LPPe_OTDOA_UTRA_NeighborCellList._cont = _OMA_LPPe_OTDOA_UTRA_NeighborCellList__item_
    OMA_LPPe_OTDOA_UTRA_NeighborCellList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    
    #-----< OMA-LPPe-OTDOA-UTRA-NeighborCellInfo >-----#
    OMA_LPPe_OTDOA_UTRA_NeighborCellInfo = SEQ(name=u'OMA-LPPe-OTDOA-UTRA-NeighborCellInfo', mode=MODE_TYPE)
    _OMA_LPPe_OTDOA_UTRA_NeighborCellInfo_modeSpecificInfo = CHOICE(name=u'modeSpecificInfo', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __OMA_LPPe_OTDOA_UTRA_NeighborCellInfo_modeSpecificInfo_fdd = SEQ(name=u'fdd', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___OMA_LPPe_OTDOA_UTRA_NeighborCellInfo_modeSpecificInfo_fdd_primaryCPICH_info = SEQ(name=u'primaryCPICH-info', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-UTRA-PrimaryCPICH-Info')))
    __OMA_LPPe_OTDOA_UTRA_NeighborCellInfo_modeSpecificInfo_fdd._cont = ASN1Dict([
        (u'primaryCPICH-info', ___OMA_LPPe_OTDOA_UTRA_NeighborCellInfo_modeSpecificInfo_fdd_primaryCPICH_info),
        ])
    __OMA_LPPe_OTDOA_UTRA_NeighborCellInfo_modeSpecificInfo_fdd._ext = None
    __OMA_LPPe_OTDOA_UTRA_NeighborCellInfo_modeSpecificInfo_tdd = SEQ(name=u'tdd', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___OMA_LPPe_OTDOA_UTRA_NeighborCellInfo_modeSpecificInfo_tdd_cellAndChannelIdentity = SEQ(name=u'cellAndChannelIdentity', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-UTRA-CellAndChannelIdentity')))
    __OMA_LPPe_OTDOA_UTRA_NeighborCellInfo_modeSpecificInfo_tdd._cont = ASN1Dict([
        (u'cellAndChannelIdentity', ___OMA_LPPe_OTDOA_UTRA_NeighborCellInfo_modeSpecificInfo_tdd_cellAndChannelIdentity),
        ])
    __OMA_LPPe_OTDOA_UTRA_NeighborCellInfo_modeSpecificInfo_tdd._ext = None
    _OMA_LPPe_OTDOA_UTRA_NeighborCellInfo_modeSpecificInfo._cont = ASN1Dict([
        (u'fdd', __OMA_LPPe_OTDOA_UTRA_NeighborCellInfo_modeSpecificInfo_fdd),
        (u'tdd', __OMA_LPPe_OTDOA_UTRA_NeighborCellInfo_modeSpecificInfo_tdd),
        ])
    _OMA_LPPe_OTDOA_UTRA_NeighborCellInfo_modeSpecificInfo._ext = None
    _OMA_LPPe_OTDOA_UTRA_NeighborCellInfo_frequencyInfo = SEQ(name=u'frequencyInfo', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-UTRA-FrequencyInfo')), opt=True)
    _OMA_LPPe_OTDOA_UTRA_NeighborCellInfo_ipdl_parameters = SEQ(name=u'ipdl-parameters', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-UTRA-IPDL-Parameters')), opt=True)
    _OMA_LPPe_OTDOA_UTRA_NeighborCellInfo_sfn_SFN_relTimeDifference = SEQ(name=u'sfn-SFN-relTimeDifference', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-UTRA-SFN-SFN-RelTimeDifference1')))
    _OMA_LPPe_OTDOA_UTRA_NeighborCellInfo_sfn_offsetValidity = ENUM(name=u'sfn-offsetValidity', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-UTRA-SFN-OffsetValidity')), opt=True)
    _OMA_LPPe_OTDOA_UTRA_NeighborCellInfo_sfn_SFN_drift = ENUM(name=u'sfn-SFN-drift', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-UTRA-SFN-SFN-Drift')), opt=True)
    _OMA_LPPe_OTDOA_UTRA_NeighborCellInfo_searchWindowSize = ENUM(name=u'searchWindowSize', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-UTRA-SearchWindowSize')))
    _OMA_LPPe_OTDOA_UTRA_NeighborCellInfo_positioningAssistance = SEQ(name=u'positioningAssistance', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-UTRA-PositioningAssistance')), opt=True)
    OMA_LPPe_OTDOA_UTRA_NeighborCellInfo._cont = ASN1Dict([
        (u'modeSpecificInfo', _OMA_LPPe_OTDOA_UTRA_NeighborCellInfo_modeSpecificInfo),
        (u'frequencyInfo', _OMA_LPPe_OTDOA_UTRA_NeighborCellInfo_frequencyInfo),
        (u'ipdl-parameters', _OMA_LPPe_OTDOA_UTRA_NeighborCellInfo_ipdl_parameters),
        (u'sfn-SFN-relTimeDifference', _OMA_LPPe_OTDOA_UTRA_NeighborCellInfo_sfn_SFN_relTimeDifference),
        (u'sfn-offsetValidity', _OMA_LPPe_OTDOA_UTRA_NeighborCellInfo_sfn_offsetValidity),
        (u'sfn-SFN-drift', _OMA_LPPe_OTDOA_UTRA_NeighborCellInfo_sfn_SFN_drift),
        (u'searchWindowSize', _OMA_LPPe_OTDOA_UTRA_NeighborCellInfo_searchWindowSize),
        (u'positioningAssistance', _OMA_LPPe_OTDOA_UTRA_NeighborCellInfo_positioningAssistance),
        ])
    OMA_LPPe_OTDOA_UTRA_NeighborCellInfo._ext = []
    
    #-----< OMA-LPPe-OTDOA-UTRA-SFN-SFN-RelTimeDifference1 >-----#
    OMA_LPPe_OTDOA_UTRA_SFN_SFN_RelTimeDifference1 = SEQ(name=u'OMA-LPPe-OTDOA-UTRA-SFN-SFN-RelTimeDifference1', mode=MODE_TYPE)
    _OMA_LPPe_OTDOA_UTRA_SFN_SFN_RelTimeDifference1_sfn_offset = INT(name=u'sfn-offset', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_OTDOA_UTRA_SFN_SFN_RelTimeDifference1_sfn_offset._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4095)], ev=None, er=[])
    _OMA_LPPe_OTDOA_UTRA_SFN_SFN_RelTimeDifference1_sfn_sfn_relTimeDifference = INT(name=u'sfn-sfn-relTimeDifference', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_OTDOA_UTRA_SFN_SFN_RelTimeDifference1_sfn_sfn_relTimeDifference._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=38399)], ev=None, er=[])
    OMA_LPPe_OTDOA_UTRA_SFN_SFN_RelTimeDifference1._cont = ASN1Dict([
        (u'sfn-offset', _OMA_LPPe_OTDOA_UTRA_SFN_SFN_RelTimeDifference1_sfn_offset),
        (u'sfn-sfn-relTimeDifference', _OMA_LPPe_OTDOA_UTRA_SFN_SFN_RelTimeDifference1_sfn_sfn_relTimeDifference),
        ])
    OMA_LPPe_OTDOA_UTRA_SFN_SFN_RelTimeDifference1._ext = None
    
    #-----< OMA-LPPe-OTDOA-UTRA-PositioningAssistance >-----#
    OMA_LPPe_OTDOA_UTRA_PositioningAssistance = SEQ(name=u'OMA-LPPe-OTDOA-UTRA-PositioningAssistance', mode=MODE_TYPE)
    _OMA_LPPe_OTDOA_UTRA_PositioningAssistance_relativeNorth = INT(name=u'relativeNorth', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_OTDOA_UTRA_PositioningAssistance_relativeNorth._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-20000, ub=20000)], ev=None, er=[])
    _OMA_LPPe_OTDOA_UTRA_PositioningAssistance_relativeEast = INT(name=u'relativeEast', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_OTDOA_UTRA_PositioningAssistance_relativeEast._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-20000, ub=20000)], ev=None, er=[])
    _OMA_LPPe_OTDOA_UTRA_PositioningAssistance_relativeAltitude = INT(name=u'relativeAltitude', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_OTDOA_UTRA_PositioningAssistance_relativeAltitude._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-4000, ub=4000)], ev=None, er=[])
    _OMA_LPPe_OTDOA_UTRA_PositioningAssistance_fineSFN_SFN = INT(name=u'fineSFN-SFN', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-UTRA-fineSFN-SFN')))
    _OMA_LPPe_OTDOA_UTRA_PositioningAssistance_roundTripTime = INT(name=u'roundTripTime', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_OTDOA_UTRA_PositioningAssistance_roundTripTime._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=32766)], ev=None, er=[])
    _OMA_LPPe_OTDOA_UTRA_PositioningAssistance_roundTripTimeExtension = INT(name=u'roundTripTimeExtension', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _OMA_LPPe_OTDOA_UTRA_PositioningAssistance_roundTripTimeExtension._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=70274)], ev=None, er=[])
    OMA_LPPe_OTDOA_UTRA_PositioningAssistance._cont = ASN1Dict([
        (u'relativeNorth', _OMA_LPPe_OTDOA_UTRA_PositioningAssistance_relativeNorth),
        (u'relativeEast', _OMA_LPPe_OTDOA_UTRA_PositioningAssistance_relativeEast),
        (u'relativeAltitude', _OMA_LPPe_OTDOA_UTRA_PositioningAssistance_relativeAltitude),
        (u'fineSFN-SFN', _OMA_LPPe_OTDOA_UTRA_PositioningAssistance_fineSFN_SFN),
        (u'roundTripTime', _OMA_LPPe_OTDOA_UTRA_PositioningAssistance_roundTripTime),
        (u'roundTripTimeExtension', _OMA_LPPe_OTDOA_UTRA_PositioningAssistance_roundTripTimeExtension),
        ])
    OMA_LPPe_OTDOA_UTRA_PositioningAssistance._ext = []
    
    #-----< utra-maxCellMeas >-----#
    utra_maxCellMeas = INT(name=u'utra-maxCellMeas', mode=MODE_VALUE)
    utra_maxCellMeas._val = 32
    
    #-----< OMA-LPPe-OTDOA-UTRA-SFN-OffsetValidity >-----#
    OMA_LPPe_OTDOA_UTRA_SFN_OffsetValidity = ENUM(name=u'OMA-LPPe-OTDOA-UTRA-SFN-OffsetValidity', mode=MODE_TYPE)
    OMA_LPPe_OTDOA_UTRA_SFN_OffsetValidity._cont = ASN1Dict([(u'false', 0)])
    OMA_LPPe_OTDOA_UTRA_SFN_OffsetValidity._ext = None
    
    #-----< OMA-LPPe-OTDOA-UTRA-SFN-SFN-Drift >-----#
    OMA_LPPe_OTDOA_UTRA_SFN_SFN_Drift = ENUM(name=u'OMA-LPPe-OTDOA-UTRA-SFN-SFN-Drift', mode=MODE_TYPE)
    OMA_LPPe_OTDOA_UTRA_SFN_SFN_Drift._cont = ASN1Dict([(u'sfnsfndrift0', 0), (u'sfnsfndrift1', 1), (u'sfnsfndrift2', 2), (u'sfnsfndrift3', 3), (u'sfnsfndrift4', 4), (u'sfnsfndrift5', 5), (u'sfnsfndrift8', 6), (u'sfnsfndrift10', 7), (u'sfnsfndrift15', 8), (u'sfnsfndrift25', 9), (u'sfnsfndrift35', 10), (u'sfnsfndrift50', 11), (u'sfnsfndrift65', 12), (u'sfnsfndrift80', 13), (u'sfnsfndrift100', 14), (u'sfnsfndrift-1', 15), (u'sfnsfndrift-2', 16), (u'sfnsfndrift-3', 17), (u'sfnsfndrift-4', 18), (u'sfnsfndrift-5', 19), (u'sfnsfndrift-8', 20), (u'sfnsfndrift-10', 21), (u'sfnsfndrift-15', 22), (u'sfnsfndrift-25', 23), (u'sfnsfndrift-35', 24), (u'sfnsfndrift-50', 25), (u'sfnsfndrift-65', 26), (u'sfnsfndrift-80', 27), (u'sfnsfndrift-100', 28)])
    OMA_LPPe_OTDOA_UTRA_SFN_SFN_Drift._ext = []
    
    #-----< OMA-LPPe-OTDOA-UTRA-SearchWindowSize >-----#
    OMA_LPPe_OTDOA_UTRA_SearchWindowSize = ENUM(name=u'OMA-LPPe-OTDOA-UTRA-SearchWindowSize', mode=MODE_TYPE)
    OMA_LPPe_OTDOA_UTRA_SearchWindowSize._cont = ASN1Dict([(u'c20', 0), (u'c40', 1), (u'c80', 2), (u'c160', 3), (u'c320', 4), (u'c640', 5), (u'c1280', 6), (u'moreThan1280', 7)])
    OMA_LPPe_OTDOA_UTRA_SearchWindowSize._ext = []
    
    #-----< OMA-LPPe-OTDOA-UTRA-fineSFN-SFN >-----#
    OMA_LPPe_OTDOA_UTRA_fineSFN_SFN = INT(name=u'OMA-LPPe-OTDOA-UTRA-fineSFN-SFN', mode=MODE_TYPE)
    OMA_LPPe_OTDOA_UTRA_fineSFN_SFN._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=15)], ev=None, er=[])
    
    #-----< OMA-LPPe-OTDOA-UTRA-IPDL-Parameters >-----#
    OMA_LPPe_OTDOA_UTRA_IPDL_Parameters = SEQ(name=u'OMA-LPPe-OTDOA-UTRA-IPDL-Parameters', mode=MODE_TYPE)
    _OMA_LPPe_OTDOA_UTRA_IPDL_Parameters_modeSpecificInfo = CHOICE(name=u'modeSpecificInfo', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __OMA_LPPe_OTDOA_UTRA_IPDL_Parameters_modeSpecificInfo_fdd = SEQ(name=u'fdd', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___OMA_LPPe_OTDOA_UTRA_IPDL_Parameters_modeSpecificInfo_fdd_ip_spacing = ENUM(name=u'ip-spacing', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-UTRA-IP-Spacing')))
    ___OMA_LPPe_OTDOA_UTRA_IPDL_Parameters_modeSpecificInfo_fdd_ip_length = ENUM(name=u'ip-length', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-UTRA-IP-Length')))
    ___OMA_LPPe_OTDOA_UTRA_IPDL_Parameters_modeSpecificInfo_fdd_ip_Offset = INT(name=u'ip-Offset', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___OMA_LPPe_OTDOA_UTRA_IPDL_Parameters_modeSpecificInfo_fdd_ip_Offset._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=9)], ev=None, er=[])
    ___OMA_LPPe_OTDOA_UTRA_IPDL_Parameters_modeSpecificInfo_fdd_seed = INT(name=u'seed', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___OMA_LPPe_OTDOA_UTRA_IPDL_Parameters_modeSpecificInfo_fdd_seed._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    ___OMA_LPPe_OTDOA_UTRA_IPDL_Parameters_modeSpecificInfo_fdd_burstModeParameters = SEQ(name=u'burstModeParameters', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-UTRA-BurstModeParameters')), opt=True)
    __OMA_LPPe_OTDOA_UTRA_IPDL_Parameters_modeSpecificInfo_fdd._cont = ASN1Dict([
        (u'ip-spacing', ___OMA_LPPe_OTDOA_UTRA_IPDL_Parameters_modeSpecificInfo_fdd_ip_spacing),
        (u'ip-length', ___OMA_LPPe_OTDOA_UTRA_IPDL_Parameters_modeSpecificInfo_fdd_ip_length),
        (u'ip-Offset', ___OMA_LPPe_OTDOA_UTRA_IPDL_Parameters_modeSpecificInfo_fdd_ip_Offset),
        (u'seed', ___OMA_LPPe_OTDOA_UTRA_IPDL_Parameters_modeSpecificInfo_fdd_seed),
        (u'burstModeParameters', ___OMA_LPPe_OTDOA_UTRA_IPDL_Parameters_modeSpecificInfo_fdd_burstModeParameters),
        ])
    __OMA_LPPe_OTDOA_UTRA_IPDL_Parameters_modeSpecificInfo_fdd._ext = None
    __OMA_LPPe_OTDOA_UTRA_IPDL_Parameters_modeSpecificInfo_tdd = SEQ(name=u'tdd', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___OMA_LPPe_OTDOA_UTRA_IPDL_Parameters_modeSpecificInfo_tdd_ip_spacing_tdd = ENUM(name=u'ip-spacing-tdd', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-UTRA-IP-Spacing-TDD')))
    ___OMA_LPPe_OTDOA_UTRA_IPDL_Parameters_modeSpecificInfo_tdd_ip_slot = INT(name=u'ip-slot', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___OMA_LPPe_OTDOA_UTRA_IPDL_Parameters_modeSpecificInfo_tdd_ip_slot._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=14)], ev=None, er=[])
    ___OMA_LPPe_OTDOA_UTRA_IPDL_Parameters_modeSpecificInfo_tdd_ip_start = INT(name=u'ip-start', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___OMA_LPPe_OTDOA_UTRA_IPDL_Parameters_modeSpecificInfo_tdd_ip_start._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4095)], ev=None, er=[])
    ___OMA_LPPe_OTDOA_UTRA_IPDL_Parameters_modeSpecificInfo_tdd_ip_PCCPCH = BOOL(name=u'ip-PCCPCH', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-UTRA-IP-PCCPCH')), opt=True)
    ___OMA_LPPe_OTDOA_UTRA_IPDL_Parameters_modeSpecificInfo_tdd_burstModeParameters = SEQ(name=u'burstModeParameters', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-UTRA-BurstModeParameters')))
    __OMA_LPPe_OTDOA_UTRA_IPDL_Parameters_modeSpecificInfo_tdd._cont = ASN1Dict([
        (u'ip-spacing-tdd', ___OMA_LPPe_OTDOA_UTRA_IPDL_Parameters_modeSpecificInfo_tdd_ip_spacing_tdd),
        (u'ip-slot', ___OMA_LPPe_OTDOA_UTRA_IPDL_Parameters_modeSpecificInfo_tdd_ip_slot),
        (u'ip-start', ___OMA_LPPe_OTDOA_UTRA_IPDL_Parameters_modeSpecificInfo_tdd_ip_start),
        (u'ip-PCCPCH', ___OMA_LPPe_OTDOA_UTRA_IPDL_Parameters_modeSpecificInfo_tdd_ip_PCCPCH),
        (u'burstModeParameters', ___OMA_LPPe_OTDOA_UTRA_IPDL_Parameters_modeSpecificInfo_tdd_burstModeParameters),
        ])
    __OMA_LPPe_OTDOA_UTRA_IPDL_Parameters_modeSpecificInfo_tdd._ext = None
    _OMA_LPPe_OTDOA_UTRA_IPDL_Parameters_modeSpecificInfo._cont = ASN1Dict([
        (u'fdd', __OMA_LPPe_OTDOA_UTRA_IPDL_Parameters_modeSpecificInfo_fdd),
        (u'tdd', __OMA_LPPe_OTDOA_UTRA_IPDL_Parameters_modeSpecificInfo_tdd),
        ])
    _OMA_LPPe_OTDOA_UTRA_IPDL_Parameters_modeSpecificInfo._ext = None
    OMA_LPPe_OTDOA_UTRA_IPDL_Parameters._cont = ASN1Dict([
        (u'modeSpecificInfo', _OMA_LPPe_OTDOA_UTRA_IPDL_Parameters_modeSpecificInfo),
        ])
    OMA_LPPe_OTDOA_UTRA_IPDL_Parameters._ext = None
    
    #-----< OMA-LPPe-OTDOA-UTRA-IP-Spacing >-----#
    OMA_LPPe_OTDOA_UTRA_IP_Spacing = ENUM(name=u'OMA-LPPe-OTDOA-UTRA-IP-Spacing', mode=MODE_TYPE)
    OMA_LPPe_OTDOA_UTRA_IP_Spacing._cont = ASN1Dict([(u'e5', 0), (u'e7', 1), (u'e10', 2), (u'e15', 3), (u'e20', 4), (u'e30', 5), (u'e40', 6), (u'e50', 7)])
    OMA_LPPe_OTDOA_UTRA_IP_Spacing._ext = None
    
    #-----< OMA-LPPe-OTDOA-UTRA-IP-Length >-----#
    OMA_LPPe_OTDOA_UTRA_IP_Length = ENUM(name=u'OMA-LPPe-OTDOA-UTRA-IP-Length', mode=MODE_TYPE)
    OMA_LPPe_OTDOA_UTRA_IP_Length._cont = ASN1Dict([(u'ipl5', 0), (u'ipl10', 1)])
    OMA_LPPe_OTDOA_UTRA_IP_Length._ext = None
    
    #-----< OMA-LPPe-OTDOA-UTRA-IP-Spacing-TDD >-----#
    OMA_LPPe_OTDOA_UTRA_IP_Spacing_TDD = ENUM(name=u'OMA-LPPe-OTDOA-UTRA-IP-Spacing-TDD', mode=MODE_TYPE)
    OMA_LPPe_OTDOA_UTRA_IP_Spacing_TDD._cont = ASN1Dict([(u'e30', 0), (u'e40', 1), (u'e50', 2), (u'e70', 3), (u'e100', 4)])
    OMA_LPPe_OTDOA_UTRA_IP_Spacing_TDD._ext = None
    
    #-----< OMA-LPPe-OTDOA-UTRA-IP-PCCPCH >-----#
    OMA_LPPe_OTDOA_UTRA_IP_PCCPCH = BOOL(name=u'OMA-LPPe-OTDOA-UTRA-IP-PCCPCH', mode=MODE_TYPE)
    
    #-----< OMA-LPPe-OTDOA-UTRA-BurstModeParameters >-----#
    OMA_LPPe_OTDOA_UTRA_BurstModeParameters = SEQ(name=u'OMA-LPPe-OTDOA-UTRA-BurstModeParameters', mode=MODE_TYPE)
    _OMA_LPPe_OTDOA_UTRA_BurstModeParameters_burstStart = INT(name=u'burstStart', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_OTDOA_UTRA_BurstModeParameters_burstStart._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=15)], ev=None, er=[])
    _OMA_LPPe_OTDOA_UTRA_BurstModeParameters_burstLength = INT(name=u'burstLength', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_OTDOA_UTRA_BurstModeParameters_burstLength._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=10, ub=25)], ev=None, er=[])
    _OMA_LPPe_OTDOA_UTRA_BurstModeParameters_burstFreq = INT(name=u'burstFreq', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_OTDOA_UTRA_BurstModeParameters_burstFreq._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    OMA_LPPe_OTDOA_UTRA_BurstModeParameters._cont = ASN1Dict([
        (u'burstStart', _OMA_LPPe_OTDOA_UTRA_BurstModeParameters_burstStart),
        (u'burstLength', _OMA_LPPe_OTDOA_UTRA_BurstModeParameters_burstLength),
        (u'burstFreq', _OMA_LPPe_OTDOA_UTRA_BurstModeParameters_burstFreq),
        ])
    OMA_LPPe_OTDOA_UTRA_BurstModeParameters._ext = None
    
    #-----< OMA-LPPe-OTDOA-UTRA-RequestAssistanceData >-----#
    OMA_LPPe_OTDOA_UTRA_RequestAssistanceData = SEQ(name=u'OMA-LPPe-OTDOA-UTRA-RequestAssistanceData', mode=MODE_TYPE)
    _OMA_LPPe_OTDOA_UTRA_RequestAssistanceData_otdoaUtraAssistanceReq = BIT_STR(name=u'otdoaUtraAssistanceReq', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_OTDOA_UTRA_RequestAssistanceData_otdoaUtraAssistanceReq._cont = ASN1Dict([(u'ueAssisted', 0), (u'ueBased', 1)])
    _OMA_LPPe_OTDOA_UTRA_RequestAssistanceData_otdoaUtraAssistanceReq._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    OMA_LPPe_OTDOA_UTRA_RequestAssistanceData._cont = ASN1Dict([
        (u'otdoaUtraAssistanceReq', _OMA_LPPe_OTDOA_UTRA_RequestAssistanceData_otdoaUtraAssistanceReq),
        ])
    OMA_LPPe_OTDOA_UTRA_RequestAssistanceData._ext = []
    
    #-----< OMA-LPPe-OTDOA-UTRA-ProvideLocationInformation >-----#
    OMA_LPPe_OTDOA_UTRA_ProvideLocationInformation = SEQ(name=u'OMA-LPPe-OTDOA-UTRA-ProvideLocationInformation', mode=MODE_TYPE)
    _OMA_LPPe_OTDOA_UTRA_ProvideLocationInformation_otdoaUtraMeasurement = SEQ(name=u'otdoaUtraMeasurement', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-UTRA-Measurement')), opt=True)
    _OMA_LPPe_OTDOA_UTRA_ProvideLocationInformation_otdoaUtraError = CHOICE(name=u'otdoaUtraError', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-UTRA-Error')), opt=True)
    _OMA_LPPe_OTDOA_UTRA_ProvideLocationInformation_timeStampData = SEQ(name=u'timeStampData', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OMA-LPPE', 'OMA-LPPe-OTDOA-UTRA-TimeStampData')), opt=True)
    OMA_LPPe_OTDOA_UTRA_ProvideLocationInformation._cont = ASN1Dict([
        (u'otdoaUtraMeasurement', _OMA_LPPe_OTDOA_UTRA_ProvideLocationInformation_otdoaUtraMeasurement),
        (u'otdoaUtraError', _OMA_LPPe_OTDOA_UTRA_ProvideLocationInformation_otdoaUtraError),
        (u'timeStampData', _OMA_LPPe_OTDOA_UTRA_ProvideLocationInformation_timeStampData),
        ])
    OMA_LPPe_OTDOA_UTRA_ProvideLocationInformation._ext = []
    
    #-----< OMA-LPPe-OTDOA-UTRA-Measurement >-----#
    OMA_LPPe_OTDOA_UTRA_Measurement = SEQ(name=u'OMA-LPPe-OTDOA-UTRA-Measurement', mode=MODE_TYPE)
    _OMA_LPPe_OTDOA_UTRA_Measurement_sfn = INT(name=u'sfn', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OMA_LPPe_OTDOA_UTRA_Measurement_sfn._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4095)], ev=None, er=[])
    _OMA_LPPe_OTDOA_UTRA_Measurement_modeSpecificInfoMeas = CHOICE(name=u'modeSpecificInfoMeas', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __OMA_LPPe_OTDOA_UTRA_Measurement_modeSpecificInfoMeas_fdd = SEQ(name=u'fdd', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___OMA_LPPe_OTDOA_UTRA_Measurement_modeSpecificInfoMeas_fdd_refe