# -*- coding: UTF-8 -*-
# Code automatically generated by pycrate_asn1c

from pycrate_asn1rt.utils            import *
from pycrate_asn1rt.err              import *
from pycrate_asn1rt.glob             import make_GLOBAL, GLOBAL
from pycrate_asn1rt.dictobj          import ASN1Dict
from pycrate_asn1rt.refobj           import *
from pycrate_asn1rt.setobj           import *
from pycrate_asn1rt.asnobj_basic     import *
from pycrate_asn1rt.asnobj_str       import *
from pycrate_asn1rt.asnobj_construct import *
from pycrate_asn1rt.asnobj_class     import *
from pycrate_asn1rt.asnobj_ext       import *
from pycrate_asn1rt.init             import init_modules

class PCAP_CommonDataTypes:

    _name_  = u'PCAP-CommonDataTypes'
    _oid_   = [0, 4, 0, 0, 20, 3, 4, 1, 3]
    
    _obj_ = [
        u'maxPrivateIEs',
        u'maxProtocolExtensions',
        u'maxProtocolIEs',
        u'Criticality',
        u'Presence',
        u'PrivateIE-ID',
        u'ProcedureCode',
        u'ProtocolIE-ID',
        u'TransactionID',
        u'TriggeringMessage',
        ]
    _type_ = [
        u'Criticality',
        u'Presence',
        u'PrivateIE-ID',
        u'ProcedureCode',
        u'ProtocolIE-ID',
        u'TransactionID',
        u'TriggeringMessage',
        ]
    _set_ = [
        ]
    _val_ = [
        u'maxPrivateIEs',
        u'maxProtocolExtensions',
        u'maxProtocolIEs',
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< maxPrivateIEs >-----#
    maxPrivateIEs = INT(name=u'maxPrivateIEs', mode=MODE_VALUE)
    maxPrivateIEs._val = 65535
    
    #-----< maxProtocolExtensions >-----#
    maxProtocolExtensions = INT(name=u'maxProtocolExtensions', mode=MODE_VALUE)
    maxProtocolExtensions._val = 65535
    
    #-----< maxProtocolIEs >-----#
    maxProtocolIEs = INT(name=u'maxProtocolIEs', mode=MODE_VALUE)
    maxProtocolIEs._val = 65535
    
    #-----< Criticality >-----#
    Criticality = ENUM(name=u'Criticality', mode=MODE_TYPE)
    Criticality._cont = ASN1Dict([(u'reject', 0), (u'ignore', 1), (u'notify', 2)])
    Criticality._ext = None
    
    #-----< Presence >-----#
    Presence = ENUM(name=u'Presence', mode=MODE_TYPE)
    Presence._cont = ASN1Dict([(u'optional', 0), (u'conditional', 1), (u'mandatory', 2)])
    Presence._ext = None
    
    #-----< PrivateIE-ID >-----#
    PrivateIE_ID = CHOICE(name=u'PrivateIE-ID', mode=MODE_TYPE)
    _PrivateIE_ID_local = INT(name=u'local', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _PrivateIE_ID_local._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    _PrivateIE_ID_global_ = OID(name=u'global', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    PrivateIE_ID._cont = ASN1Dict([
        (u'local', _PrivateIE_ID_local),
        (u'global', _PrivateIE_ID_global_),
        ])
    PrivateIE_ID._ext = None
    
    #-----< ProcedureCode >-----#
    ProcedureCode = INT(name=u'ProcedureCode', mode=MODE_TYPE)
    ProcedureCode._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    
    #-----< ProtocolIE-ID >-----#
    ProtocolIE_ID = INT(name=u'ProtocolIE-ID', mode=MODE_TYPE)
    ProtocolIE_ID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    
    #-----< TransactionID >-----#
    TransactionID = CHOICE(name=u'TransactionID', mode=MODE_TYPE)
    _TransactionID_shortTID = INT(name=u'shortTID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _TransactionID_shortTID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    _TransactionID_longTID = INT(name=u'longTID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _TransactionID_longTID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=32767)], ev=None, er=[])
    TransactionID._cont = ASN1Dict([
        (u'shortTID', _TransactionID_shortTID),
        (u'longTID', _TransactionID_longTID),
        ])
    TransactionID._ext = None
    
    #-----< TriggeringMessage >-----#
    TriggeringMessage = ENUM(name=u'TriggeringMessage', mode=MODE_TYPE)
    TriggeringMessage._cont = ASN1Dict([(u'initiating-message', 0), (u'successful-outcome', 1), (u'unsuccessful-outcome', 2), (u'outcome', 3)])
    TriggeringMessage._ext = None
    
    _all_ = [
        maxPrivateIEs,
        maxProtocolExtensions,
        maxProtocolIEs,
        Criticality,
        Presence,
        _PrivateIE_ID_local,
        _PrivateIE_ID_global_,
        PrivateIE_ID,
        ProcedureCode,
        ProtocolIE_ID,
        _TransactionID_shortTID,
        _TransactionID_longTID,
        TransactionID,
        TriggeringMessage,
    ]

class PCAP_Constants:

    _name_  = u'PCAP-Constants'
    _oid_   = [0, 4, 0, 0, 20, 3, 4, 1, 4]
    
    _obj_ = [
        u'id-PositionCalculation',
        u'id-InformationExchangeInitiation',
        u'id-InformationReporting',
        u'id-InformationExchangeTermination',
        u'id-InformationExchangeFailure',
        u'id-ErrorIndication',
        u'id-privateMessage',
        u'id-PositionParameterModification',
        u'id-PositionInitiation',
        u'id-PositionActivation',
        u'id-Abort',
        u'id-PositionPeriodicReport',
        u'id-PositionPeriodicResult',
        u'id-PositionPeriodicTermination',
        u'maxNrOfErrors',
        u'maxSat',
        u'maxSatAlmanac',
        u'maxNrOfLevels',
        u'maxNrOfPoints',
        u'maxNrOfExpInfo',
        u'maxNrOfMeasNCell',
        u'maxNrOfMeasurements',
        u'maxNrOfSets',
        u'maxRateMatching',
        u'maxNrOfTFs',
        u'maxTTI-count',
        u'maxTS-1',
        u'maxCCTrCH',
        u'maxTF',
        u'maxTFC',
        u'maxPRACH',
        u'maxTrCH',
        u'maxTGPS',
        u'maxNoOfMeasurements',
        u'maxCellMeas',
        u'maxNrOfEDPCCH-PO-QUANTSTEPs',
        u'maxNrOfRefETFCI-PO-QUANTSTEPs',
        u'maxNrOfRefETFCIs',
        u'maxSet',
        u'maxGANSSSat',
        u'maxSgnType',
        u'maxGANSS',
        u'maxGANSSSet',
        u'maxGANSSSatAlmanac',
        u'maxGANSSClockMod',
        u'maxGANSS-1',
        u'maxNrOfIRATMeasurements',
        u'maxReportedGERANCells',
        u'maxIonGridInfo',
        u'maxAddPos',
        u'maxBeacons',
        u'maxBTs',
        u'maxWLANs',
        u'id-Cause',
        u'id-CriticalityDiagnostics',
        u'id-GPS-UTRAN-TRU',
        u'id-InformationExchangeID',
        u'id-InformationExchangeObjectType-InfEx-Rprt',
        u'id-InformationExchangeObjectType-InfEx-Rqst',
        u'id-InformationExchangeObjectType-InfEx-Rsp',
        u'id-InformationReportCharacteristics',
        u'id-InformationType',
        u'id-GPS-MeasuredResultsList',
        u'id-MethodType',
        u'id-RefPosition-InfEx-Rqst',
        u'id-RefPosition-InfEx-Rsp',
        u'id-RefPosition-Inf-Rprt',
        u'id-RequestedDataValue',
        u'id-RequestedDataValueInformation',
        u'id-TransactionID',
        u'id-UE-PositionEstimate',
        u'id-CellId-MeasuredResultsSets',
        u'id-OTDOA-MeasurementGroup',
        u'id-AccuracyFulfilmentIndicator',
        u'id-HorizontalAccuracyCode',
        u'id-VerticalAccuracyCode',
        u'id-UTDOA-Group',
        u'id-RequestType',
        u'id-UE-PositioningCapability',
        u'id-UC-id',
        u'id-ResponseTime',
        u'id-PositioningPriority',
        u'id-ClientType',
        u'id-PositioningMethod',
        u'id-UTDOAPositioning',
        u'id-GPSPositioning',
        u'id-OTDOAAssistanceData',
        u'id-Positioning-ResponseTime',
        u'id-EnvironmentCharacterisation',
        u'id-PositionData',
        u'id-IncludeVelocity',
        u'id-VelocityEstimate',
        u'id-rxTimingDeviation768Info',
        u'id-UC-ID-InfEx-Rqst',
        u'id-UE-PositionEstimateInfo',
        u'id-UTRAN-GPSReferenceTime',
        u'id-UTRAN-GPSReferenceTimeResult',
        u'id-UTRAN-GPS-DriftRate',
        u'id-OTDOA-AddMeasuredResultsInfo',
        u'id-GPS-ReferenceLocation',
        u'id-OTDOA-MeasuredResultsSets',
        u'id-rxTimingDeviation384extInfo',
        u'id-ExtendedRoundTripTime',
        u'id-PeriodicPosCalcInfo',
        u'id-PeriodicLocationInfo',
        u'id-AmountOfReporting',
        u'id-MeasInstructionsUsed',
        u'id-RRCstateChange',
        u'id-PeriodicTerminationCause',
        u'id-MeasurementValidity',
        u'id-roundTripTimeInfoWithType1',
        u'id-CellIDPositioning',
        u'id-AddMeasurementInfo',
        u'id-Extended-RNC-ID',
        u'id-GANSS-CommonAssistanceData',
        u'id-GANSS-GenericAssistanceDataList',
        u'id-GANSS-MeasuredResultsList',
        u'id-GANSS-UTRAN-TRU',
        u'id-GANSSPositioning',
        u'id-GANSS-PositioningDataSet',
        u'id-GNSS-PositioningMethod',
        u'id-NetworkAssistedGANSSSuport',
        u'id-TUTRANGANSSMeasurementValueInfo',
        u'id-AdditionalGPSAssistDataRequired',
        u'id-AdditionalGanssAssistDataRequired',
        u'id-angleOfArrivalLCR',
        u'id-extendedTimingAdvanceLCR',
        u'id-additionalMeasurementInforLCR',
        u'id-timingAdvanceLCR-R7',
        u'id-rxTimingDeviationLCR',
        u'id-GPSReferenceTimeUncertainty',
        u'id-GANSS-AddIonoModelReq',
        u'id-GANSS-EarthOrientParaReq',
        u'id-GANSS-Additional-Ionospheric-Model',
        u'id-GANSS-Earth-Orientation-Parameters',
        u'id-GANSS-Additional-Time-Models',
        u'id-GANSS-Additional-Navigation-Models',
        u'id-GANSS-Additional-UTC-Models',
        u'id-GANSS-Auxiliary-Information',
        u'id-GANSS-SBAS-ID',
        u'id-GANSS-SBAS-IDs',
        u'id-GANSS-Signal-IDs',
        u'id-supportGANSSNonNativeADchoices',
        u'id-PositionDataUEbased',
        u'id-ganssCodePhaseAmbiguityExt',
        u'id-ganssIntegerCodePhaseExt',
        u'id-GANSScarrierPhaseRequested',
        u'id-GANSSMultiFreqMeasRequested',
        u'id-ganssReq-AddIonosphericModel',
        u'id-ganssReq-EarthOrientPara',
        u'id-ganssAddNavigationModel-req',
        u'id-ganssAddUTCModel-req',
        u'id-ganssAuxInfo-req',
        u'id-GANSS-AlmanacModelChoice',
        u'id-GANSS-alm-keplerianNAVAlmanac',
        u'id-GANSS-alm-keplerianReducedAlmanac',
        u'id-GANSS-alm-keplerianMidiAlmanac',
        u'id-GANSS-alm-keplerianGLONASS',
        u'id-GANSS-alm-ecefSBASAlmanac',
        u'id-UTRAN-GANSSReferenceTimeResult',
        u'id-GANSS-Reference-Time-Only',
        u'id-GANSS-AddADchoices',
        u'id-OTDOA-ReferenceCellInfo',
        u'id-DGNSS-ValidityPeriod',
        u'id-AzimuthAndElevationLSB',
        u'id-completeAlmanacProvided',
        u'id-GPS-Week-Cycle',
        u'id-GANSS-Day-Cycle',
        u'id-ganss-Delta-T',
        u'id-requestedCellIDGERANMeasurements',
        u'id-CellId-IRATMeasuredResultsSets',
        u'id-IMSI',
        u'id-IMEI',
        u'id-GANSS-alm-keplerianBDSAlmanac',
        u'id-BDS-Ionospheric-Grid-Model',
        u'id-DBDS-Correction-Information',
        u'id-BDSIonosphericGridModel',
        u'id-DBDSCorrection',
        u'id-Confidence',
        u'id-ExtraDopplerInfoExtension',
        u'id-GANSS-Confidence',
        u'id-GANSS-ExtraDopplerExtension',
        u'id-Additional-PositioningDataSet',
        u'id-Additional-PositioningMethod',
        u'id-AddPos-MeasuredResults',
        u'id-AddPosSupport',
        ]
    _type_ = [
        ]
    _set_ = [
        ]
    _val_ = [
        u'id-PositionCalculation',
        u'id-InformationExchangeInitiation',
        u'id-InformationReporting',
        u'id-InformationExchangeTermination',
        u'id-InformationExchangeFailure',
        u'id-ErrorIndication',
        u'id-privateMessage',
        u'id-PositionParameterModification',
        u'id-PositionInitiation',
        u'id-PositionActivation',
        u'id-Abort',
        u'id-PositionPeriodicReport',
        u'id-PositionPeriodicResult',
        u'id-PositionPeriodicTermination',
        u'maxNrOfErrors',
        u'maxSat',
        u'maxSatAlmanac',
        u'maxNrOfLevels',
        u'maxNrOfPoints',
        u'maxNrOfExpInfo',
        u'maxNrOfMeasNCell',
        u'maxNrOfMeasurements',
        u'maxNrOfSets',
        u'maxRateMatching',
        u'maxNrOfTFs',
        u'maxTTI-count',
        u'maxTS-1',
        u'maxCCTrCH',
        u'maxTF',
        u'maxTFC',
        u'maxPRACH',
        u'maxTrCH',
        u'maxTGPS',
        u'maxNoOfMeasurements',
        u'maxCellMeas',
        u'maxNrOfEDPCCH-PO-QUANTSTEPs',
        u'maxNrOfRefETFCI-PO-QUANTSTEPs',
        u'maxNrOfRefETFCIs',
        u'maxSet',
        u'maxGANSSSat',
        u'maxSgnType',
        u'maxGANSS',
        u'maxGANSSSet',
        u'maxGANSSSatAlmanac',
        u'maxGANSSClockMod',
        u'maxGANSS-1',
        u'maxNrOfIRATMeasurements',
        u'maxReportedGERANCells',
        u'maxIonGridInfo',
        u'maxAddPos',
        u'maxBeacons',
        u'maxBTs',
        u'maxWLANs',
        u'id-Cause',
        u'id-CriticalityDiagnostics',
        u'id-GPS-UTRAN-TRU',
        u'id-InformationExchangeID',
        u'id-InformationExchangeObjectType-InfEx-Rprt',
        u'id-InformationExchangeObjectType-InfEx-Rqst',
        u'id-InformationExchangeObjectType-InfEx-Rsp',
        u'id-InformationReportCharacteristics',
        u'id-InformationType',
        u'id-GPS-MeasuredResultsList',
        u'id-MethodType',
        u'id-RefPosition-InfEx-Rqst',
        u'id-RefPosition-InfEx-Rsp',
        u'id-RefPosition-Inf-Rprt',
        u'id-RequestedDataValue',
        u'id-RequestedDataValueInformation',
        u'id-TransactionID',
        u'id-UE-PositionEstimate',
        u'id-CellId-MeasuredResultsSets',
        u'id-OTDOA-MeasurementGroup',
        u'id-AccuracyFulfilmentIndicator',
        u'id-HorizontalAccuracyCode',
        u'id-VerticalAccuracyCode',
        u'id-UTDOA-Group',
        u'id-RequestType',
        u'id-UE-PositioningCapability',
        u'id-UC-id',
        u'id-ResponseTime',
        u'id-PositioningPriority',
        u'id-ClientType',
        u'id-PositioningMethod',
        u'id-UTDOAPositioning',
        u'id-GPSPositioning',
        u'id-OTDOAAssistanceData',
        u'id-Positioning-ResponseTime',
        u'id-EnvironmentCharacterisation',
        u'id-PositionData',
        u'id-IncludeVelocity',
        u'id-VelocityEstimate',
        u'id-rxTimingDeviation768Info',
        u'id-UC-ID-InfEx-Rqst',
        u'id-UE-PositionEstimateInfo',
        u'id-UTRAN-GPSReferenceTime',
        u'id-UTRAN-GPSReferenceTimeResult',
        u'id-UTRAN-GPS-DriftRate',
        u'id-OTDOA-AddMeasuredResultsInfo',
        u'id-GPS-ReferenceLocation',
        u'id-OTDOA-MeasuredResultsSets',
        u'id-rxTimingDeviation384extInfo',
        u'id-ExtendedRoundTripTime',
        u'id-PeriodicPosCalcInfo',
        u'id-PeriodicLocationInfo',
        u'id-AmountOfReporting',
        u'id-MeasInstructionsUsed',
        u'id-RRCstateChange',
        u'id-PeriodicTerminationCause',
        u'id-MeasurementValidity',
        u'id-roundTripTimeInfoWithType1',
        u'id-CellIDPositioning',
        u'id-AddMeasurementInfo',
        u'id-Extended-RNC-ID',
        u'id-GANSS-CommonAssistanceData',
        u'id-GANSS-GenericAssistanceDataList',
        u'id-GANSS-MeasuredResultsList',
        u'id-GANSS-UTRAN-TRU',
        u'id-GANSSPositioning',
        u'id-GANSS-PositioningDataSet',
        u'id-GNSS-PositioningMethod',
        u'id-NetworkAssistedGANSSSuport',
        u'id-TUTRANGANSSMeasurementValueInfo',
        u'id-AdditionalGPSAssistDataRequired',
        u'id-AdditionalGanssAssistDataRequired',
        u'id-angleOfArrivalLCR',
        u'id-extendedTimingAdvanceLCR',
        u'id-additionalMeasurementInforLCR',
        u'id-timingAdvanceLCR-R7',
        u'id-rxTimingDeviationLCR',
        u'id-GPSReferenceTimeUncertainty',
        u'id-GANSS-AddIonoModelReq',
        u'id-GANSS-EarthOrientParaReq',
        u'id-GANSS-Additional-Ionospheric-Model',
        u'id-GANSS-Earth-Orientation-Parameters',
        u'id-GANSS-Additional-Time-Models',
        u'id-GANSS-Additional-Navigation-Models',
        u'id-GANSS-Additional-UTC-Models',
        u'id-GANSS-Auxiliary-Information',
        u'id-GANSS-SBAS-ID',
        u'id-GANSS-SBAS-IDs',
        u'id-GANSS-Signal-IDs',
        u'id-supportGANSSNonNativeADchoices',
        u'id-PositionDataUEbased',
        u'id-ganssCodePhaseAmbiguityExt',
        u'id-ganssIntegerCodePhaseExt',
        u'id-GANSScarrierPhaseRequested',
        u'id-GANSSMultiFreqMeasRequested',
        u'id-ganssReq-AddIonosphericModel',
        u'id-ganssReq-EarthOrientPara',
        u'id-ganssAddNavigationModel-req',
        u'id-ganssAddUTCModel-req',
        u'id-ganssAuxInfo-req',
        u'id-GANSS-AlmanacModelChoice',
        u'id-GANSS-alm-keplerianNAVAlmanac',
        u'id-GANSS-alm-keplerianReducedAlmanac',
        u'id-GANSS-alm-keplerianMidiAlmanac',
        u'id-GANSS-alm-keplerianGLONASS',
        u'id-GANSS-alm-ecefSBASAlmanac',
        u'id-UTRAN-GANSSReferenceTimeResult',
        u'id-GANSS-Reference-Time-Only',
        u'id-GANSS-AddADchoices',
        u'id-OTDOA-ReferenceCellInfo',
        u'id-DGNSS-ValidityPeriod',
        u'id-AzimuthAndElevationLSB',
        u'id-completeAlmanacProvided',
        u'id-GPS-Week-Cycle',
        u'id-GANSS-Day-Cycle',
        u'id-ganss-Delta-T',
        u'id-requestedCellIDGERANMeasurements',
        u'id-CellId-IRATMeasuredResultsSets',
        u'id-IMSI',
        u'id-IMEI',
        u'id-GANSS-alm-keplerianBDSAlmanac',
        u'id-BDS-Ionospheric-Grid-Model',
        u'id-DBDS-Correction-Information',
        u'id-BDSIonosphericGridModel',
        u'id-DBDSCorrection',
        u'id-Confidence',
        u'id-ExtraDopplerInfoExtension',
        u'id-GANSS-Confidence',
        u'id-GANSS-ExtraDopplerExtension',
        u'id-Additional-PositioningDataSet',
        u'id-Additional-PositioningMethod',
        u'id-AddPos-MeasuredResults',
        u'id-AddPosSupport',
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< id-PositionCalculation >-----#
    id_PositionCalculation = INT(name=u'id-PositionCalculation', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProcedureCode')))
    id_PositionCalculation._val = 1
    
    #-----< id-InformationExchangeInitiation >-----#
    id_InformationExchangeInitiation = INT(name=u'id-InformationExchangeInitiation', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProcedureCode')))
    id_InformationExchangeInitiation._val = 2
    
    #-----< id-InformationReporting >-----#
    id_InformationReporting = INT(name=u'id-InformationReporting', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProcedureCode')))
    id_InformationReporting._val = 3
    
    #-----< id-InformationExchangeTermination >-----#
    id_InformationExchangeTermination = INT(name=u'id-InformationExchangeTermination', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProcedureCode')))
    id_InformationExchangeTermination._val = 4
    
    #-----< id-InformationExchangeFailure >-----#
    id_InformationExchangeFailure = INT(name=u'id-InformationExchangeFailure', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProcedureCode')))
    id_InformationExchangeFailure._val = 5
    
    #-----< id-ErrorIndication >-----#
    id_ErrorIndication = INT(name=u'id-ErrorIndication', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProcedureCode')))
    id_ErrorIndication._val = 6
    
    #-----< id-privateMessage >-----#
    id_privateMessage = INT(name=u'id-privateMessage', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProcedureCode')))
    id_privateMessage._val = 7
    
    #-----< id-PositionParameterModification >-----#
    id_PositionParameterModification = INT(name=u'id-PositionParameterModification', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProcedureCode')))
    id_PositionParameterModification._val = 8
    
    #-----< id-PositionInitiation >-----#
    id_PositionInitiation = INT(name=u'id-PositionInitiation', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProcedureCode')))
    id_PositionInitiation._val = 9
    
    #-----< id-PositionActivation >-----#
    id_PositionActivation = INT(name=u'id-PositionActivation', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProcedureCode')))
    id_PositionActivation._val = 10
    
    #-----< id-Abort >-----#
    id_Abort = INT(name=u'id-Abort', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProcedureCode')))
    id_Abort._val = 11
    
    #-----< id-PositionPeriodicReport >-----#
    id_PositionPeriodicReport = INT(name=u'id-PositionPeriodicReport', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProcedureCode')))
    id_PositionPeriodicReport._val = 12
    
    #-----< id-PositionPeriodicResult >-----#
    id_PositionPeriodicResult = INT(name=u'id-PositionPeriodicResult', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProcedureCode')))
    id_PositionPeriodicResult._val = 13
    
    #-----< id-PositionPeriodicTermination >-----#
    id_PositionPeriodicTermination = INT(name=u'id-PositionPeriodicTermination', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProcedureCode')))
    id_PositionPeriodicTermination._val = 14
    
    #-----< maxNrOfErrors >-----#
    maxNrOfErrors = INT(name=u'maxNrOfErrors', mode=MODE_VALUE)
    maxNrOfErrors._val = 256
    
    #-----< maxSat >-----#
    maxSat = INT(name=u'maxSat', mode=MODE_VALUE)
    maxSat._val = 16
    
    #-----< maxSatAlmanac >-----#
    maxSatAlmanac = INT(name=u'maxSatAlmanac', mode=MODE_VALUE)
    maxSatAlmanac._val = 32
    
    #-----< maxNrOfLevels >-----#
    maxNrOfLevels = INT(name=u'maxNrOfLevels', mode=MODE_VALUE)
    maxNrOfLevels._val = 256
    
    #-----< maxNrOfPoints >-----#
    maxNrOfPoints = INT(name=u'maxNrOfPoints', mode=MODE_VALUE)
    maxNrOfPoints._val = 15
    
    #-----< maxNrOfExpInfo >-----#
    maxNrOfExpInfo = INT(name=u'maxNrOfExpInfo', mode=MODE_VALUE)
    maxNrOfExpInfo._val = 32
    
    #-----< maxNrOfMeasNCell >-----#
    maxNrOfMeasNCell = INT(name=u'maxNrOfMeasNCell', mode=MODE_VALUE)
    maxNrOfMeasNCell._val = 32
    
    #-----< maxNrOfMeasurements >-----#
    maxNrOfMeasurements = INT(name=u'maxNrOfMeasurements', mode=MODE_VALUE)
    maxNrOfMeasurements._val = 16
    
    #-----< maxNrOfSets >-----#
    maxNrOfSets = INT(name=u'maxNrOfSets', mode=MODE_VALUE)
    maxNrOfSets._val = 3
    
    #-----< maxRateMatching >-----#
    maxRateMatching = INT(name=u'maxRateMatching', mode=MODE_VALUE)
    maxRateMatching._val = 256
    
    #-----< maxNrOfTFs >-----#
    maxNrOfTFs = INT(name=u'maxNrOfTFs', mode=MODE_VALUE)
    maxNrOfTFs._val = 32
    
    #-----< maxTTI-count >-----#
    maxTTI_count = INT(name=u'maxTTI-count', mode=MODE_VALUE)
    maxTTI_count._val = 4
    
    #-----< maxTS-1 >-----#
    maxTS_1 = INT(name=u'maxTS-1', mode=MODE_VALUE)
    maxTS_1._val = 13
    
    #-----< maxCCTrCH >-----#
    maxCCTrCH = INT(name=u'maxCCTrCH', mode=MODE_VALUE)
    maxCCTrCH._val = 8
    
    #-----< maxTF >-----#
    maxTF = INT(name=u'maxTF', mode=MODE_VALUE)
    maxTF._val = 32
    
    #-----< maxTFC >-----#
    maxTFC = INT(name=u'maxTFC', mode=MODE_VALUE)
    maxTFC._val = 1024
    
    #-----< maxPRACH >-----#
    maxPRACH = INT(name=u'maxPRACH', mode=MODE_VALUE)
    maxPRACH._val = 16
    
    #-----< maxTrCH >-----#
    maxTrCH = INT(name=u'maxTrCH', mode=MODE_VALUE)
    maxTrCH._val = 32
    
    #-----< maxTGPS >-----#
    maxTGPS = INT(name=u'maxTGPS', mode=MODE_VALUE)
    maxTGPS._val = 6
    
    #-----< maxNoOfMeasurements >-----#
    maxNoOfMeasurements = INT(name=u'maxNoOfMeasurements', mode=MODE_VALUE)
    maxNoOfMeasurements._val = 16
    
    #-----< maxCellMeas >-----#
    maxCellMeas = INT(name=u'maxCellMeas', mode=MODE_VALUE)
    maxCellMeas._val = 32
    
    #-----< maxNrOfEDPCCH-PO-QUANTSTEPs >-----#
    maxNrOfEDPCCH_PO_QUANTSTEPs = INT(name=u'maxNrOfEDPCCH-PO-QUANTSTEPs', mode=MODE_VALUE)
    maxNrOfEDPCCH_PO_QUANTSTEPs._val = 8
    
    #-----< maxNrOfRefETFCI-PO-QUANTSTEPs >-----#
    maxNrOfRefETFCI_PO_QUANTSTEPs = INT(name=u'maxNrOfRefETFCI-PO-QUANTSTEPs', mode=MODE_VALUE)
    maxNrOfRefETFCI_PO_QUANTSTEPs._val = 8
    
    #-----< maxNrOfRefETFCIs >-----#
    maxNrOfRefETFCIs = INT(name=u'maxNrOfRefETFCIs', mode=MODE_VALUE)
    maxNrOfRefETFCIs._val = 8
    
    #-----< maxSet >-----#
    maxSet = INT(name=u'maxSet', mode=MODE_VALUE)
    maxSet._val = 9
    
    #-----< maxGANSSSat >-----#
    maxGANSSSat = INT(name=u'maxGANSSSat', mode=MODE_VALUE)
    maxGANSSSat._val = 64
    
    #-----< maxSgnType >-----#
    maxSgnType = INT(name=u'maxSgnType', mode=MODE_VALUE)
    maxSgnType._val = 8
    
    #-----< maxGANSS >-----#
    maxGANSS = INT(name=u'maxGANSS', mode=MODE_VALUE)
    maxGANSS._val = 8
    
    #-----< maxGANSSSet >-----#
    maxGANSSSet = INT(name=u'maxGANSSSet', mode=MODE_VALUE)
    maxGANSSSet._val = 9
    
    #-----< maxGANSSSatAlmanac >-----#
    maxGANSSSatAlmanac = INT(name=u'maxGANSSSatAlmanac', mode=MODE_VALUE)
    maxGANSSSatAlmanac._val = 36
    
    #-----< maxGANSSClockMod >-----#
    maxGANSSClockMod = INT(name=u'maxGANSSClockMod', mode=MODE_VALUE)
    maxGANSSClockMod._val = 4
    
    #-----< maxGANSS-1 >-----#
    maxGANSS_1 = INT(name=u'maxGANSS-1', mode=MODE_VALUE)
    maxGANSS_1._val = 7
    
    #-----< maxNrOfIRATMeasurements >-----#
    maxNrOfIRATMeasurements = INT(name=u'maxNrOfIRATMeasurements', mode=MODE_VALUE)
    maxNrOfIRATMeasurements._val = 16
    
    #-----< maxReportedGERANCells >-----#
    maxReportedGERANCells = INT(name=u'maxReportedGERANCells', mode=MODE_VALUE)
    maxReportedGERANCells._val = 6
    
    #-----< maxIonGridInfo >-----#
    maxIonGridInfo = INT(name=u'maxIonGridInfo', mode=MODE_VALUE)
    maxIonGridInfo._val = 320
    
    #-----< maxAddPos >-----#
    maxAddPos = INT(name=u'maxAddPos', mode=MODE_VALUE)
    maxAddPos._val = 8
    
    #-----< maxBeacons >-----#
    maxBeacons = INT(name=u'maxBeacons', mode=MODE_VALUE)
    maxBeacons._val = 64
    
    #-----< maxBTs >-----#
    maxBTs = INT(name=u'maxBTs', mode=MODE_VALUE)
    maxBTs._val = 32
    
    #-----< maxWLANs >-----#
    maxWLANs = INT(name=u'maxWLANs', mode=MODE_VALUE)
    maxWLANs._val = 64
    
    #-----< id-Cause >-----#
    id_Cause = INT(name=u'id-Cause', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_Cause._val = 1
    
    #-----< id-CriticalityDiagnostics >-----#
    id_CriticalityDiagnostics = INT(name=u'id-CriticalityDiagnostics', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_CriticalityDiagnostics._val = 2
    
    #-----< id-GPS-UTRAN-TRU >-----#
    id_GPS_UTRAN_TRU = INT(name=u'id-GPS-UTRAN-TRU', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_GPS_UTRAN_TRU._val = 3
    
    #-----< id-InformationExchangeID >-----#
    id_InformationExchangeID = INT(name=u'id-InformationExchangeID', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_InformationExchangeID._val = 4
    
    #-----< id-InformationExchangeObjectType-InfEx-Rprt >-----#
    id_InformationExchangeObjectType_InfEx_Rprt = INT(name=u'id-InformationExchangeObjectType-InfEx-Rprt', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_InformationExchangeObjectType_InfEx_Rprt._val = 5
    
    #-----< id-InformationExchangeObjectType-InfEx-Rqst >-----#
    id_InformationExchangeObjectType_InfEx_Rqst = INT(name=u'id-InformationExchangeObjectType-InfEx-Rqst', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_InformationExchangeObjectType_InfEx_Rqst._val = 6
    
    #-----< id-InformationExchangeObjectType-InfEx-Rsp >-----#
    id_InformationExchangeObjectType_InfEx_Rsp = INT(name=u'id-InformationExchangeObjectType-InfEx-Rsp', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_InformationExchangeObjectType_InfEx_Rsp._val = 7
    
    #-----< id-InformationReportCharacteristics >-----#
    id_InformationReportCharacteristics = INT(name=u'id-InformationReportCharacteristics', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_InformationReportCharacteristics._val = 8
    
    #-----< id-InformationType >-----#
    id_InformationType = INT(name=u'id-InformationType', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_InformationType._val = 9
    
    #-----< id-GPS-MeasuredResultsList >-----#
    id_GPS_MeasuredResultsList = INT(name=u'id-GPS-MeasuredResultsList', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_GPS_MeasuredResultsList._val = 10
    
    #-----< id-MethodType >-----#
    id_MethodType = INT(name=u'id-MethodType', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_MethodType._val = 11
    
    #-----< id-RefPosition-InfEx-Rqst >-----#
    id_RefPosition_InfEx_Rqst = INT(name=u'id-RefPosition-InfEx-Rqst', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_RefPosition_InfEx_Rqst._val = 12
    
    #-----< id-RefPosition-InfEx-Rsp >-----#
    id_RefPosition_InfEx_Rsp = INT(name=u'id-RefPosition-InfEx-Rsp', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_RefPosition_InfEx_Rsp._val = 13
    
    #-----< id-RefPosition-Inf-Rprt >-----#
    id_RefPosition_Inf_Rprt = INT(name=u'id-RefPosition-Inf-Rprt', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_RefPosition_Inf_Rprt._val = 14
    
    #-----< id-RequestedDataValue >-----#
    id_RequestedDataValue = INT(name=u'id-RequestedDataValue', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_RequestedDataValue._val = 15
    
    #-----< id-RequestedDataValueInformation >-----#
    id_RequestedDataValueInformation = INT(name=u'id-RequestedDataValueInformation', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_RequestedDataValueInformation._val = 16
    
    #-----< id-TransactionID >-----#
    id_TransactionID = INT(name=u'id-TransactionID', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_TransactionID._val = 17
    
    #-----< id-UE-PositionEstimate >-----#
    id_UE_PositionEstimate = INT(name=u'id-UE-PositionEstimate', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_UE_PositionEstimate._val = 18
    
    #-----< id-CellId-MeasuredResultsSets >-----#
    id_CellId_MeasuredResultsSets = INT(name=u'id-CellId-MeasuredResultsSets', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_CellId_MeasuredResultsSets._val = 20
    
    #-----< id-OTDOA-MeasurementGroup >-----#
    id_OTDOA_MeasurementGroup = INT(name=u'id-OTDOA-MeasurementGroup', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_OTDOA_MeasurementGroup._val = 22
    
    #-----< id-AccuracyFulfilmentIndicator >-----#
    id_AccuracyFulfilmentIndicator = INT(name=u'id-AccuracyFulfilmentIndicator', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_AccuracyFulfilmentIndicator._val = 23
    
    #-----< id-HorizontalAccuracyCode >-----#
    id_HorizontalAccuracyCode = INT(name=u'id-HorizontalAccuracyCode', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_HorizontalAccuracyCode._val = 24
    
    #-----< id-VerticalAccuracyCode >-----#
    id_VerticalAccuracyCode = INT(name=u'id-VerticalAccuracyCode', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_VerticalAccuracyCode._val = 25
    
    #-----< id-UTDOA-Group >-----#
    id_UTDOA_Group = INT(name=u'id-UTDOA-Group', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_UTDOA_Group._val = 26
    
    #-----< id-RequestType >-----#
    id_RequestType = INT(name=u'id-RequestType', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_RequestType._val = 28
    
    #-----< id-UE-PositioningCapability >-----#
    id_UE_PositioningCapability = INT(name=u'id-UE-PositioningCapability', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_UE_PositioningCapability._val = 29
    
    #-----< id-UC-id >-----#
    id_UC_id = INT(name=u'id-UC-id', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_UC_id._val = 30
    
    #-----< id-ResponseTime >-----#
    id_ResponseTime = INT(name=u'id-ResponseTime', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_ResponseTime._val = 31
    
    #-----< id-PositioningPriority >-----#
    id_PositioningPriority = INT(name=u'id-PositioningPriority', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_PositioningPriority._val = 32
    
    #-----< id-ClientType >-----#
    id_ClientType = INT(name=u'id-ClientType', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_ClientType._val = 33
    
    #-----< id-PositioningMethod >-----#
    id_PositioningMethod = INT(name=u'id-PositioningMethod', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_PositioningMethod._val = 34
    
    #-----< id-UTDOAPositioning >-----#
    id_UTDOAPositioning = INT(name=u'id-UTDOAPositioning', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_UTDOAPositioning._val = 35
    
    #-----< id-GPSPositioning >-----#
    id_GPSPositioning = INT(name=u'id-GPSPositioning', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_GPSPositioning._val = 36
    
    #-----< id-OTDOAAssistanceData >-----#
    id_OTDOAAssistanceData = INT(name=u'id-OTDOAAssistanceData', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_OTDOAAssistanceData._val = 37
    
    #-----< id-Positioning-ResponseTime >-----#
    id_Positioning_ResponseTime = INT(name=u'id-Positioning-ResponseTime', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_Positioning_ResponseTime._val = 38
    
    #-----< id-EnvironmentCharacterisation >-----#
    id_EnvironmentCharacterisation = INT(name=u'id-EnvironmentCharacterisation', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_EnvironmentCharacterisation._val = 39
    
    #-----< id-PositionData >-----#
    id_PositionData = INT(name=u'id-PositionData', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_PositionData._val = 40
    
    #-----< id-IncludeVelocity >-----#
    id_IncludeVelocity = INT(name=u'id-IncludeVelocity', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_IncludeVelocity._val = 41
    
    #-----< id-VelocityEstimate >-----#
    id_VelocityEstimate = INT(name=u'id-VelocityEstimate', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_VelocityEstimate._val = 42
    
    #-----< id-rxTimingDeviation768Info >-----#
    id_rxTimingDeviation768Info = INT(name=u'id-rxTimingDeviation768Info', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_rxTimingDeviation768Info._val = 43
    
    #-----< id-UC-ID-InfEx-Rqst >-----#
    id_UC_ID_InfEx_Rqst = INT(name=u'id-UC-ID-InfEx-Rqst', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_UC_ID_InfEx_Rqst._val = 44
    
    #-----< id-UE-PositionEstimateInfo >-----#
    id_UE_PositionEstimateInfo = INT(name=u'id-UE-PositionEstimateInfo', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_UE_PositionEstimateInfo._val = 45
    
    #-----< id-UTRAN-GPSReferenceTime >-----#
    id_UTRAN_GPSReferenceTime = INT(name=u'id-UTRAN-GPSReferenceTime', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_UTRAN_GPSReferenceTime._val = 46
    
    #-----< id-UTRAN-GPSReferenceTimeResult >-----#
    id_UTRAN_GPSReferenceTimeResult = INT(name=u'id-UTRAN-GPSReferenceTimeResult', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_UTRAN_GPSReferenceTimeResult._val = 47
    
    #-----< id-UTRAN-GPS-DriftRate >-----#
    id_UTRAN_GPS_DriftRate = INT(name=u'id-UTRAN-GPS-DriftRate', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_UTRAN_GPS_DriftRate._val = 48
    
    #-----< id-OTDOA-AddMeasuredResultsInfo >-----#
    id_OTDOA_AddMeasuredResultsInfo = INT(name=u'id-OTDOA-AddMeasuredResultsInfo', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_OTDOA_AddMeasuredResultsInfo._val = 49
    
    #-----< id-GPS-ReferenceLocation >-----#
    id_GPS_ReferenceLocation = INT(name=u'id-GPS-ReferenceLocation', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_GPS_ReferenceLocation._val = 50
    
    #-----< id-OTDOA-MeasuredResultsSets >-----#
    id_OTDOA_MeasuredResultsSets = INT(name=u'id-OTDOA-MeasuredResultsSets', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_OTDOA_MeasuredResultsSets._val = 51
    
    #-----< id-rxTimingDeviation384extInfo >-----#
    id_rxTimingDeviation384extInfo = INT(name=u'id-rxTimingDeviation384extInfo', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_rxTimingDeviation384extInfo._val = 55
    
    #-----< id-ExtendedRoundTripTime >-----#
    id_ExtendedRoundTripTime = INT(name=u'id-ExtendedRoundTripTime', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_ExtendedRoundTripTime._val = 56
    
    #-----< id-PeriodicPosCalcInfo >-----#
    id_PeriodicPosCalcInfo = INT(name=u'id-PeriodicPosCalcInfo', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_PeriodicPosCalcInfo._val = 57
    
    #-----< id-PeriodicLocationInfo >-----#
    id_PeriodicLocationInfo = INT(name=u'id-PeriodicLocationInfo', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_PeriodicLocationInfo._val = 58
    
    #-----< id-AmountOfReporting >-----#
    id_AmountOfReporting = INT(name=u'id-AmountOfReporting', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_AmountOfReporting._val = 59
    
    #-----< id-MeasInstructionsUsed >-----#
    id_MeasInstructionsUsed = INT(name=u'id-MeasInstructionsUsed', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_MeasInstructionsUsed._val = 60
    
    #-----< id-RRCstateChange >-----#
    id_RRCstateChange = INT(name=u'id-RRCstateChange', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_RRCstateChange._val = 61
    
    #-----< id-PeriodicTerminationCause >-----#
    id_PeriodicTerminationCause = INT(name=u'id-PeriodicTerminationCause', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_PeriodicTerminationCause._val = 62
    
    #-----< id-MeasurementValidity >-----#
    id_MeasurementValidity = INT(name=u'id-MeasurementValidity', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_MeasurementValidity._val = 63
    
    #-----< id-roundTripTimeInfoWithType1 >-----#
    id_roundTripTimeInfoWithType1 = INT(name=u'id-roundTripTimeInfoWithType1', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_roundTripTimeInfoWithType1._val = 64
    
    #-----< id-CellIDPositioning >-----#
    id_CellIDPositioning = INT(name=u'id-CellIDPositioning', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_CellIDPositioning._val = 66
    
    #-----< id-AddMeasurementInfo >-----#
    id_AddMeasurementInfo = INT(name=u'id-AddMeasurementInfo', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_AddMeasurementInfo._val = 67
    
    #-----< id-Extended-RNC-ID >-----#
    id_Extended_RNC_ID = INT(name=u'id-Extended-RNC-ID', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_Extended_RNC_ID._val = 68
    
    #-----< id-GANSS-CommonAssistanceData >-----#
    id_GANSS_CommonAssistanceData = INT(name=u'id-GANSS-CommonAssistanceData', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_GANSS_CommonAssistanceData._val = 69
    
    #-----< id-GANSS-GenericAssistanceDataList >-----#
    id_GANSS_GenericAssistanceDataList = INT(name=u'id-GANSS-GenericAssistanceDataList', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_GANSS_GenericAssistanceDataList._val = 70
    
    #-----< id-GANSS-MeasuredResultsList >-----#
    id_GANSS_MeasuredResultsList = INT(name=u'id-GANSS-MeasuredResultsList', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_GANSS_MeasuredResultsList._val = 71
    
    #-----< id-GANSS-UTRAN-TRU >-----#
    id_GANSS_UTRAN_TRU = INT(name=u'id-GANSS-UTRAN-TRU', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_GANSS_UTRAN_TRU._val = 72
    
    #-----< id-GANSSPositioning >-----#
    id_GANSSPositioning = INT(name=u'id-GANSSPositioning', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_GANSSPositioning._val = 73
    
    #-----< id-GANSS-PositioningDataSet >-----#
    id_GANSS_PositioningDataSet = INT(name=u'id-GANSS-PositioningDataSet', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_GANSS_PositioningDataSet._val = 74
    
    #-----< id-GNSS-PositioningMethod >-----#
    id_GNSS_PositioningMethod = INT(name=u'id-GNSS-PositioningMethod', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_GNSS_PositioningMethod._val = 75
    
    #-----< id-NetworkAssistedGANSSSuport >-----#
    id_NetworkAssistedGANSSSuport = INT(name=u'id-NetworkAssistedGANSSSuport', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_NetworkAssistedGANSSSuport._val = 76
    
    #-----< id-TUTRANGANSSMeasurementValueInfo >-----#
    id_TUTRANGANSSMeasurementValueInfo = INT(name=u'id-TUTRANGANSSMeasurementValueInfo', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_TUTRANGANSSMeasurementValueInfo._val = 77
    
    #-----< id-AdditionalGPSAssistDataRequired >-----#
    id_AdditionalGPSAssistDataRequired = INT(name=u'id-AdditionalGPSAssistDataRequired', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_AdditionalGPSAssistDataRequired._val = 78
    
    #-----< id-AdditionalGanssAssistDataRequired >-----#
    id_AdditionalGanssAssistDataRequired = INT(name=u'id-AdditionalGanssAssistDataRequired', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_AdditionalGanssAssistDataRequired._val = 79
    
    #-----< id-angleOfArrivalLCR >-----#
    id_angleOfArrivalLCR = INT(name=u'id-angleOfArrivalLCR', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_angleOfArrivalLCR._val = 80
    
    #-----< id-extendedTimingAdvanceLCR >-----#
    id_extendedTimingAdvanceLCR = INT(name=u'id-extendedTimingAdvanceLCR', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_extendedTimingAdvanceLCR._val = 81
    
    #-----< id-additionalMeasurementInforLCR >-----#
    id_additionalMeasurementInforLCR = INT(name=u'id-additionalMeasurementInforLCR', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_additionalMeasurementInforLCR._val = 82
    
    #-----< id-timingAdvanceLCR-R7 >-----#
    id_timingAdvanceLCR_R7 = INT(name=u'id-timingAdvanceLCR-R7', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_timingAdvanceLCR_R7._val = 83
    
    #-----< id-rxTimingDeviationLCR >-----#
    id_rxTimingDeviationLCR = INT(name=u'id-rxTimingDeviationLCR', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_rxTimingDeviationLCR._val = 84
    
    #-----< id-GPSReferenceTimeUncertainty >-----#
    id_GPSReferenceTimeUncertainty = INT(name=u'id-GPSReferenceTimeUncertainty', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_GPSReferenceTimeUncertainty._val = 85
    
    #-----< id-GANSS-AddIonoModelReq >-----#
    id_GANSS_AddIonoModelReq = INT(name=u'id-GANSS-AddIonoModelReq', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_GANSS_AddIonoModelReq._val = 86
    
    #-----< id-GANSS-EarthOrientParaReq >-----#
    id_GANSS_EarthOrientParaReq = INT(name=u'id-GANSS-EarthOrientParaReq', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_GANSS_EarthOrientParaReq._val = 87
    
    #-----< id-GANSS-Additional-Ionospheric-Model >-----#
    id_GANSS_Additional_Ionospheric_Model = INT(name=u'id-GANSS-Additional-Ionospheric-Model', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_GANSS_Additional_Ionospheric_Model._val = 88
    
    #-----< id-GANSS-Earth-Orientation-Parameters >-----#
    id_GANSS_Earth_Orientation_Parameters = INT(name=u'id-GANSS-Earth-Orientation-Parameters', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_GANSS_Earth_Orientation_Parameters._val = 89
    
    #-----< id-GANSS-Additional-Time-Models >-----#
    id_GANSS_Additional_Time_Models = INT(name=u'id-GANSS-Additional-Time-Models', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_GANSS_Additional_Time_Models._val = 90
    
    #-----< id-GANSS-Additional-Navigation-Models >-----#
    id_GANSS_Additional_Navigation_Models = INT(name=u'id-GANSS-Additional-Navigation-Models', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_GANSS_Additional_Navigation_Models._val = 91
    
    #-----< id-GANSS-Additional-UTC-Models >-----#
    id_GANSS_Additional_UTC_Models = INT(name=u'id-GANSS-Additional-UTC-Models', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_GANSS_Additional_UTC_Models._val = 92
    
    #-----< id-GANSS-Auxiliary-Information >-----#
    id_GANSS_Auxiliary_Information = INT(name=u'id-GANSS-Auxiliary-Information', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_GANSS_Auxiliary_Information._val = 93
    
    #-----< id-GANSS-SBAS-ID >-----#
    id_GANSS_SBAS_ID = INT(name=u'id-GANSS-SBAS-ID', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_GANSS_SBAS_ID._val = 94
    
    #-----< id-GANSS-SBAS-IDs >-----#
    id_GANSS_SBAS_IDs = INT(name=u'id-GANSS-SBAS-IDs', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_GANSS_SBAS_IDs._val = 95
    
    #-----< id-GANSS-Signal-IDs >-----#
    id_GANSS_Signal_IDs = INT(name=u'id-GANSS-Signal-IDs', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_GANSS_Signal_IDs._val = 96
    
    #-----< id-supportGANSSNonNativeADchoices >-----#
    id_supportGANSSNonNativeADchoices = INT(name=u'id-supportGANSSNonNativeADchoices', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_supportGANSSNonNativeADchoices._val = 97
    
    #-----< id-PositionDataUEbased >-----#
    id_PositionDataUEbased = INT(name=u'id-PositionDataUEbased', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_PositionDataUEbased._val = 98
    
    #-----< id-ganssCodePhaseAmbiguityExt >-----#
    id_ganssCodePhaseAmbiguityExt = INT(name=u'id-ganssCodePhaseAmbiguityExt', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_ganssCodePhaseAmbiguityExt._val = 99
    
    #-----< id-ganssIntegerCodePhaseExt >-----#
    id_ganssIntegerCodePhaseExt = INT(name=u'id-ganssIntegerCodePhaseExt', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_ganssIntegerCodePhaseExt._val = 100
    
    #-----< id-GANSScarrierPhaseRequested >-----#
    id_GANSScarrierPhaseRequested = INT(name=u'id-GANSScarrierPhaseRequested', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_GANSScarrierPhaseRequested._val = 101
    
    #-----< id-GANSSMultiFreqMeasRequested >-----#
    id_GANSSMultiFreqMeasRequested = INT(name=u'id-GANSSMultiFreqMeasRequested', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_GANSSMultiFreqMeasRequested._val = 102
    
    #-----< id-ganssReq-AddIonosphericModel >-----#
    id_ganssReq_AddIonosphericModel = INT(name=u'id-ganssReq-AddIonosphericModel', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_ganssReq_AddIonosphericModel._val = 103
    
    #-----< id-ganssReq-EarthOrientPara >-----#
    id_ganssReq_EarthOrientPara = INT(name=u'id-ganssReq-EarthOrientPara', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_ganssReq_EarthOrientPara._val = 104
    
    #-----< id-ganssAddNavigationModel-req >-----#
    id_ganssAddNavigationModel_req = INT(name=u'id-ganssAddNavigationModel-req', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_ganssAddNavigationModel_req._val = 105
    
    #-----< id-ganssAddUTCModel-req >-----#
    id_ganssAddUTCModel_req = INT(name=u'id-ganssAddUTCModel-req', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_ganssAddUTCModel_req._val = 106
    
    #-----< id-ganssAuxInfo-req >-----#
    id_ganssAuxInfo_req = INT(name=u'id-ganssAuxInfo-req', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_ganssAuxInfo_req._val = 107
    
    #-----< id-GANSS-AlmanacModelChoice >-----#
    id_GANSS_AlmanacModelChoice = INT(name=u'id-GANSS-AlmanacModelChoice', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_GANSS_AlmanacModelChoice._val = 108
    
    #-----< id-GANSS-alm-keplerianNAVAlmanac >-----#
    id_GANSS_alm_keplerianNAVAlmanac = INT(name=u'id-GANSS-alm-keplerianNAVAlmanac', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_GANSS_alm_keplerianNAVAlmanac._val = 109
    
    #-----< id-GANSS-alm-keplerianReducedAlmanac >-----#
    id_GANSS_alm_keplerianReducedAlmanac = INT(name=u'id-GANSS-alm-keplerianReducedAlmanac', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_GANSS_alm_keplerianReducedAlmanac._val = 110
    
    #-----< id-GANSS-alm-keplerianMidiAlmanac >-----#
    id_GANSS_alm_keplerianMidiAlmanac = INT(name=u'id-GANSS-alm-keplerianMidiAlmanac', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_GANSS_alm_keplerianMidiAlmanac._val = 111
    
    #-----< id-GANSS-alm-keplerianGLONASS >-----#
    id_GANSS_alm_keplerianGLONASS = INT(name=u'id-GANSS-alm-keplerianGLONASS', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_GANSS_alm_keplerianGLONASS._val = 112
    
    #-----< id-GANSS-alm-ecefSBASAlmanac >-----#
    id_GANSS_alm_ecefSBASAlmanac = INT(name=u'id-GANSS-alm-ecefSBASAlmanac', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_GANSS_alm_ecefSBASAlmanac._val = 113
    
    #-----< id-UTRAN-GANSSReferenceTimeResult >-----#
    id_UTRAN_GANSSReferenceTimeResult = INT(name=u'id-UTRAN-GANSSReferenceTimeResult', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_UTRAN_GANSSReferenceTimeResult._val = 114
    
    #-----< id-GANSS-Reference-Time-Only >-----#
    id_GANSS_Reference_Time_Only = INT(name=u'id-GANSS-Reference-Time-Only', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_GANSS_Reference_Time_Only._val = 115
    
    #-----< id-GANSS-AddADchoices >-----#
    id_GANSS_AddADchoices = INT(name=u'id-GANSS-AddADchoices', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_GANSS_AddADchoices._val = 116
    
    #-----< id-OTDOA-ReferenceCellInfo >-----#
    id_OTDOA_ReferenceCellInfo = INT(name=u'id-OTDOA-ReferenceCellInfo', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_OTDOA_ReferenceCellInfo._val = 117
    
    #-----< id-DGNSS-ValidityPeriod >-----#
    id_DGNSS_ValidityPeriod = INT(name=u'id-DGNSS-ValidityPeriod', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_DGNSS_ValidityPeriod._val = 118
    
    #-----< id-AzimuthAndElevationLSB >-----#
    id_AzimuthAndElevationLSB = INT(name=u'id-AzimuthAndElevationLSB', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_AzimuthAndElevationLSB._val = 119
    
    #-----< id-completeAlmanacProvided >-----#
    id_completeAlmanacProvided = INT(name=u'id-completeAlmanacProvided', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_completeAlmanacProvided._val = 120
    
    #-----< id-GPS-Week-Cycle >-----#
    id_GPS_Week_Cycle = INT(name=u'id-GPS-Week-Cycle', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_GPS_Week_Cycle._val = 121
    
    #-----< id-GANSS-Day-Cycle >-----#
    id_GANSS_Day_Cycle = INT(name=u'id-GANSS-Day-Cycle', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_GANSS_Day_Cycle._val = 122
    
    #-----< id-ganss-Delta-T >-----#
    id_ganss_Delta_T = INT(name=u'id-ganss-Delta-T', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_ganss_Delta_T._val = 123
    
    #-----< id-requestedCellIDGERANMeasurements >-----#
    id_requestedCellIDGERANMeasurements = INT(name=u'id-requestedCellIDGERANMeasurements', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_requestedCellIDGERANMeasurements._val = 124
    
    #-----< id-CellId-IRATMeasuredResultsSets >-----#
    id_CellId_IRATMeasuredResultsSets = INT(name=u'id-CellId-IRATMeasuredResultsSets', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_CellId_IRATMeasuredResultsSets._val = 125
    
    #-----< id-IMSI >-----#
    id_IMSI = INT(name=u'id-IMSI', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_IMSI._val = 128
    
    #-----< id-IMEI >-----#
    id_IMEI = INT(name=u'id-IMEI', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_IMEI._val = 129
    
    #-----< id-GANSS-alm-keplerianBDSAlmanac >-----#
    id_GANSS_alm_keplerianBDSAlmanac = INT(name=u'id-GANSS-alm-keplerianBDSAlmanac', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_GANSS_alm_keplerianBDSAlmanac._val = 130
    
    #-----< id-BDS-Ionospheric-Grid-Model >-----#
    id_BDS_Ionospheric_Grid_Model = INT(name=u'id-BDS-Ionospheric-Grid-Model', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_BDS_Ionospheric_Grid_Model._val = 131
    
    #-----< id-DBDS-Correction-Information >-----#
    id_DBDS_Correction_Information = INT(name=u'id-DBDS-Correction-Information', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_DBDS_Correction_Information._val = 132
    
    #-----< id-BDSIonosphericGridModel >-----#
    id_BDSIonosphericGridModel = INT(name=u'id-BDSIonosphericGridModel', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_BDSIonosphericGridModel._val = 133
    
    #-----< id-DBDSCorrection >-----#
    id_DBDSCorrection = INT(name=u'id-DBDSCorrection', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_DBDSCorrection._val = 134
    
    #-----< id-Confidence >-----#
    id_Confidence = INT(name=u'id-Confidence', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_Confidence._val = 135
    
    #-----< id-ExtraDopplerInfoExtension >-----#
    id_ExtraDopplerInfoExtension = INT(name=u'id-ExtraDopplerInfoExtension', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_ExtraDopplerInfoExtension._val = 136
    
    #-----< id-GANSS-Confidence >-----#
    id_GANSS_Confidence = INT(name=u'id-GANSS-Confidence', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_GANSS_Confidence._val = 137
    
    #-----< id-GANSS-ExtraDopplerExtension >-----#
    id_GANSS_ExtraDopplerExtension = INT(name=u'id-GANSS-ExtraDopplerExtension', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_GANSS_ExtraDopplerExtension._val = 138
    
    #-----< id-Additional-PositioningDataSet >-----#
    id_Additional_PositioningDataSet = INT(name=u'id-Additional-PositioningDataSet', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_Additional_PositioningDataSet._val = 139
    
    #-----< id-Additional-PositioningMethod >-----#
    id_Additional_PositioningMethod = INT(name=u'id-Additional-PositioningMethod', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_Additional_PositioningMethod._val = 140
    
    #-----< id-AddPos-MeasuredResults >-----#
    id_AddPos_MeasuredResults = INT(name=u'id-AddPos-MeasuredResults', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_AddPos_MeasuredResults._val = 141
    
    #-----< id-AddPosSupport >-----#
    id_AddPosSupport = INT(name=u'id-AddPosSupport', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    id_AddPosSupport._val = 142
    
    _all_ = [
        id_PositionCalculation,
        id_InformationExchangeInitiation,
        id_InformationReporting,
        id_InformationExchangeTermination,
        id_InformationExchangeFailure,
        id_ErrorIndication,
        id_privateMessage,
        id_PositionParameterModification,
        id_PositionInitiation,
        id_PositionActivation,
        id_Abort,
        id_PositionPeriodicReport,
        id_PositionPeriodicResult,
        id_PositionPeriodicTermination,
        maxNrOfErrors,
        maxSat,
        maxSatAlmanac,
        maxNrOfLevels,
        maxNrOfPoints,
        maxNrOfExpInfo,
        maxNrOfMeasNCell,
        maxNrOfMeasurements,
        maxNrOfSets,
        maxRateMatching,
        maxNrOfTFs,
        maxTTI_count,
        maxTS_1,
        maxCCTrCH,
        maxTF,
        maxTFC,
        maxPRACH,
        maxTrCH,
        maxTGPS,
        maxNoOfMeasurements,
        maxCellMeas,
        maxNrOfEDPCCH_PO_QUANTSTEPs,
        maxNrOfRefETFCI_PO_QUANTSTEPs,
        maxNrOfRefETFCIs,
        maxSet,
        maxGANSSSat,
        maxSgnType,
        maxGANSS,
        maxGANSSSet,
        maxGANSSSatAlmanac,
        maxGANSSClockMod,
        maxGANSS_1,
        maxNrOfIRATMeasurements,
        maxReportedGERANCells,
        maxIonGridInfo,
        maxAddPos,
        maxBeacons,
        maxBTs,
        maxWLANs,
        id_Cause,
        id_CriticalityDiagnostics,
        id_GPS_UTRAN_TRU,
        id_InformationExchangeID,
        id_InformationExchangeObjectType_InfEx_Rprt,
        id_InformationExchangeObjectType_InfEx_Rqst,
        id_InformationExchangeObjectType_InfEx_Rsp,
        id_InformationReportCharacteristics,
        id_InformationType,
        id_GPS_MeasuredResultsList,
        id_MethodType,
        id_RefPosition_InfEx_Rqst,
        id_RefPosition_InfEx_Rsp,
        id_RefPosition_Inf_Rprt,
        id_RequestedDataValue,
        id_RequestedDataValueInformation,
        id_TransactionID,
        id_UE_PositionEstimate,
        id_CellId_MeasuredResultsSets,
        id_OTDOA_MeasurementGroup,
        id_AccuracyFulfilmentIndicator,
        id_HorizontalAccuracyCode,
        id_VerticalAccuracyCode,
        id_UTDOA_Group,
        id_RequestType,
        id_UE_PositioningCapability,
        id_UC_id,
        id_ResponseTime,
        id_PositioningPriority,
        id_ClientType,
        id_PositioningMethod,
        id_UTDOAPositioning,
        id_GPSPositioning,
        id_OTDOAAssistanceData,
        id_Positioning_ResponseTime,
        id_EnvironmentCharacterisation,
        id_PositionData,
        id_IncludeVelocity,
        id_VelocityEstimate,
        id_rxTimingDeviation768Info,
        id_UC_ID_InfEx_Rqst,
        id_UE_PositionEstimateInfo,
        id_UTRAN_GPSReferenceTime,
        id_UTRAN_GPSReferenceTimeResult,
        id_UTRAN_GPS_DriftRate,
        id_OTDOA_AddMeasuredResultsInfo,
        id_GPS_ReferenceLocation,
        id_OTDOA_MeasuredResultsSets,
        id_rxTimingDeviation384extInfo,
        id_ExtendedRoundTripTime,
        id_PeriodicPosCalcInfo,
        id_PeriodicLocationInfo,
        id_AmountOfReporting,
        id_MeasInstructionsUsed,
        id_RRCstateChange,
        id_PeriodicTerminationCause,
        id_MeasurementValidity,
        id_roundTripTimeInfoWithType1,
        id_CellIDPositioning,
        id_AddMeasurementInfo,
        id_Extended_RNC_ID,
        id_GANSS_CommonAssistanceData,
        id_GANSS_GenericAssistanceDataList,
        id_GANSS_MeasuredResultsList,
        id_GANSS_UTRAN_TRU,
        id_GANSSPositioning,
        id_GANSS_PositioningDataSet,
        id_GNSS_PositioningMethod,
        id_NetworkAssistedGANSSSuport,
        id_TUTRANGANSSMeasurementValueInfo,
        id_AdditionalGPSAssistDataRequired,
        id_AdditionalGanssAssistDataRequired,
        id_angleOfArrivalLCR,
        id_extendedTimingAdvanceLCR,
        id_additionalMeasurementInforLCR,
        id_timingAdvanceLCR_R7,
        id_rxTimingDeviationLCR,
        id_GPSReferenceTimeUncertainty,
        id_GANSS_AddIonoModelReq,
        id_GANSS_EarthOrientParaReq,
        id_GANSS_Additional_Ionospheric_Model,
        id_GANSS_Earth_Orientation_Parameters,
        id_GANSS_Additional_Time_Models,
        id_GANSS_Additional_Navigation_Models,
        id_GANSS_Additional_UTC_Models,
        id_GANSS_Auxiliary_Information,
        id_GANSS_SBAS_ID,
        id_GANSS_SBAS_IDs,
        id_GANSS_Signal_IDs,
        id_supportGANSSNonNativeADchoices,
        id_PositionDataUEbased,
        id_ganssCodePhaseAmbiguityExt,
        id_ganssIntegerCodePhaseExt,
        id_GANSScarrierPhaseRequested,
        id_GANSSMultiFreqMeasRequested,
        id_ganssReq_AddIonosphericModel,
        id_ganssReq_EarthOrientPara,
        id_ganssAddNavigationModel_req,
        id_ganssAddUTCModel_req,
        id_ganssAuxInfo_req,
        id_GANSS_AlmanacModelChoice,
        id_GANSS_alm_keplerianNAVAlmanac,
        id_GANSS_alm_keplerianReducedAlmanac,
        id_GANSS_alm_keplerianMidiAlmanac,
        id_GANSS_alm_keplerianGLONASS,
        id_GANSS_alm_ecefSBASAlmanac,
        id_UTRAN_GANSSReferenceTimeResult,
        id_GANSS_Reference_Time_Only,
        id_GANSS_AddADchoices,
        id_OTDOA_ReferenceCellInfo,
        id_DGNSS_ValidityPeriod,
        id_AzimuthAndElevationLSB,
        id_completeAlmanacProvided,
        id_GPS_Week_Cycle,
        id_GANSS_Day_Cycle,
        id_ganss_Delta_T,
        id_requestedCellIDGERANMeasurements,
        id_CellId_IRATMeasuredResultsSets,
        id_IMSI,
        id_IMEI,
        id_GANSS_alm_keplerianBDSAlmanac,
        id_BDS_Ionospheric_Grid_Model,
        id_DBDS_Correction_Information,
        id_BDSIonosphericGridModel,
        id_DBDSCorrection,
        id_Confidence,
        id_ExtraDopplerInfoExtension,
        id_GANSS_Confidence,
        id_GANSS_ExtraDopplerExtension,
        id_Additional_PositioningDataSet,
        id_Additional_PositioningMethod,
        id_AddPos_MeasuredResults,
        id_AddPosSupport,
    ]

class PCAP_Containers:

    _name_  = u'PCAP-Containers'
    _oid_   = [0, 4, 0, 0, 20, 3, 4, 1, 5]
    
    _obj_ = [
        u'PCAP-PROTOCOL-IES',
        u'PCAP-PROTOCOL-EXTENSION',
        u'PCAP-PRIVATE-IES',
        u'ProtocolIE-Container',
        u'ProtocolIE-Single-Container',
        u'ProtocolIE-Field',
        u'ProtocolIE-ContainerList',
        u'ProtocolExtensionContainer',
        u'ProtocolExtensionField',
        u'PrivateIE-Container',
        u'PrivateIE-Field',
        ]
    _type_ = [
        u'PCAP-PROTOCOL-IES',
        u'PCAP-PROTOCOL-EXTENSION',
        u'PCAP-PRIVATE-IES',
        u'ProtocolIE-Container',
        u'ProtocolIE-Single-Container',
        u'ProtocolIE-Field',
        u'ProtocolIE-ContainerList',
        u'ProtocolExtensionContainer',
        u'ProtocolExtensionField',
        u'PrivateIE-Container',
        u'PrivateIE-Field',
        ]
    _set_ = [
        ]
    _val_ = [
        ]
    _class_ = [
        u'PCAP-PROTOCOL-IES',
        u'PCAP-PROTOCOL-EXTENSION',
        u'PCAP-PRIVATE-IES',
        ]
    _param_ = [
        u'ProtocolIE-Container',
        u'ProtocolIE-Single-Container',
        u'ProtocolIE-Field',
        u'ProtocolIE-ContainerList',
        u'ProtocolExtensionContainer',
        u'ProtocolExtensionField',
        u'PrivateIE-Container',
        u'PrivateIE-Field',
        ]
    
    #-----< PCAP-PROTOCOL-IES >-----#
    PCAP_PROTOCOL_IES = CLASS(name=u'PCAP-PROTOCOL-IES', mode=MODE_TYPE)
    _PCAP_PROTOCOL_IES_id = INT(name=u'id', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')), uniq=True)
    _PCAP_PROTOCOL_IES_criticality = ENUM(name=u'criticality', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'Criticality')))
    _PCAP_PROTOCOL_IES_Value = OPEN(name=u'Value', mode=MODE_TYPE)
    _PCAP_PROTOCOL_IES_presence = ENUM(name=u'presence', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'Presence')))
    PCAP_PROTOCOL_IES._cont = ASN1Dict([
        (u'id', _PCAP_PROTOCOL_IES_id),
        (u'criticality', _PCAP_PROTOCOL_IES_criticality),
        (u'Value', _PCAP_PROTOCOL_IES_Value),
        (u'presence', _PCAP_PROTOCOL_IES_presence),
        ])
    
    #-----< PCAP-PROTOCOL-EXTENSION >-----#
    PCAP_PROTOCOL_EXTENSION = CLASS(name=u'PCAP-PROTOCOL-EXTENSION', mode=MODE_TYPE)
    _PCAP_PROTOCOL_EXTENSION_id = INT(name=u'id', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')), uniq=True)
    _PCAP_PROTOCOL_EXTENSION_criticality = ENUM(name=u'criticality', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'Criticality')))
    _PCAP_PROTOCOL_EXTENSION_Extension = OPEN(name=u'Extension', mode=MODE_TYPE)
    _PCAP_PROTOCOL_EXTENSION_presence = ENUM(name=u'presence', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'Presence')))
    PCAP_PROTOCOL_EXTENSION._cont = ASN1Dict([
        (u'id', _PCAP_PROTOCOL_EXTENSION_id),
        (u'criticality', _PCAP_PROTOCOL_EXTENSION_criticality),
        (u'Extension', _PCAP_PROTOCOL_EXTENSION_Extension),
        (u'presence', _PCAP_PROTOCOL_EXTENSION_presence),
        ])
    
    #-----< PCAP-PRIVATE-IES >-----#
    PCAP_PRIVATE_IES = CLASS(name=u'PCAP-PRIVATE-IES', mode=MODE_TYPE)
    _PCAP_PRIVATE_IES_id = CHOICE(name=u'id', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'PrivateIE-ID')))
    _PCAP_PRIVATE_IES_criticality = ENUM(name=u'criticality', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'Criticality')))
    _PCAP_PRIVATE_IES_Value = OPEN(name=u'Value', mode=MODE_TYPE)
    _PCAP_PRIVATE_IES_presence = ENUM(name=u'presence', mode=MODE_VALUE, typeref=ASN1RefType(('PCAP-CommonDataTypes', 'Presence')))
    PCAP_PRIVATE_IES._cont = ASN1Dict([
        (u'id', _PCAP_PRIVATE_IES_id),
        (u'criticality', _PCAP_PRIVATE_IES_criticality),
        (u'Value', _PCAP_PRIVATE_IES_Value),
        (u'presence', _PCAP_PRIVATE_IES_presence),
        ])
    
    #-----< ProtocolIE-Container >-----#
    ProtocolIE_Container = SEQ_OF(name=u'ProtocolIE-Container', mode=MODE_TYPE, param=True)
    
    #-----< ProtocolIE-Single-Container >-----#
    ProtocolIE_Single_Container = SEQ(name=u'ProtocolIE-Single-Container', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolIE-Field')), param=True)
    
    #-----< ProtocolIE-Field >-----#
    ProtocolIE_Field = SEQ(name=u'ProtocolIE-Field', mode=MODE_TYPE, param=True)
    
    #-----< ProtocolIE-ContainerList >-----#
    ProtocolIE_ContainerList = SEQ_OF(name=u'ProtocolIE-ContainerList', mode=MODE_TYPE, param=True)
    
    #-----< ProtocolExtensionContainer >-----#
    ProtocolExtensionContainer = SEQ_OF(name=u'ProtocolExtensionContainer', mode=MODE_TYPE, param=True)
    
    #-----< ProtocolExtensionField >-----#
    ProtocolExtensionField = SEQ(name=u'ProtocolExtensionField', mode=MODE_TYPE, param=True)
    
    #-----< PrivateIE-Container >-----#
    PrivateIE_Container = SEQ_OF(name=u'PrivateIE-Container', mode=MODE_TYPE, param=True)
    
    #-----< PrivateIE-Field >-----#
    PrivateIE_Field = SEQ(name=u'PrivateIE-Field', mode=MODE_TYPE, param=True)
    
    _all_ = [
        _PCAP_PROTOCOL_IES_id,
        _PCAP_PROTOCOL_IES_criticality,
        _PCAP_PROTOCOL_IES_Value,
        _PCAP_PROTOCOL_IES_presence,
        PCAP_PROTOCOL_IES,
        _PCAP_PROTOCOL_EXTENSION_id,
        _PCAP_PROTOCOL_EXTENSION_criticality,
        _PCAP_PROTOCOL_EXTENSION_Extension,
        _PCAP_PROTOCOL_EXTENSION_presence,
        PCAP_PROTOCOL_EXTENSION,
        _PCAP_PRIVATE_IES_id,
        _PCAP_PRIVATE_IES_criticality,
        _PCAP_PRIVATE_IES_Value,
        _PCAP_PRIVATE_IES_presence,
        PCAP_PRIVATE_IES,
    ]

class PCAP_IEs:

    _name_  = u'PCAP-IEs'
    _oid_   = [0, 4, 0, 0, 20, 3, 4, 1, 2]
    
    _obj_ = [
        u'AccuracyFulfilmentIndicator',
        u'AdditionalMethodType',
        u'AddPos-MeasuredResults',
        u'AddPos-MeasuredResults-Element',
        u'BarometricPressure-ExtIEs',
        u'WLANMeasurementList-ExtIEs',
        u'BTMeasurementList-ExtIEs',
        u'MBSMeasurementList-ExtIEs',
        u'WLANMeasurementList',
        u'WLANMeasurementList-Element',
        u'WLANMeasurementList-Element-ExtIEs',
        u'BTMeasurementList',
        u'BTMeasurementList-Element',
        u'BTMeasurementList-Element-ExtIEs',
        u'MBSMeasurementList',
        u'MBSMeasurementList-Element',
        u'MBSMeasurementList-Element-ExtIEs',
        u'BaroMeasurement',
        u'AlmanacAndSatelliteHealthSIB',
        u'AlmanacAndSatelliteHealthSIB-ExtIEs',
        u'Cause',
        u'CauseRadioNetwork',
        u'CauseTransport',
        u'CauseProtocol',
        u'CauseMisc',
        u'CellId-MeasuredResultsSets',
        u'CellId-MeasuredResultsInfoList',
        u'CellId-MeasuredResultsInfo',
        u'CellId-MeasuredResultsInfo-ExtIEs',
        u'RoundTripTimeInfo',
        u'RoundTripTimeInfo-ExtIEs',
        u'RoundTripTimeInfoWithType1',
        u'RoundTripTimeInfoWithType1-ExtIEs',
        u'UE-RxTxTimeDifferenceType2',
        u'UE-RxTxTimeDifferenceType1',
        u'UE-PositioningMeasQuality',
        u'UE-PositioningMeasQuality-ExtIEs',
        u'RoundTripTime',
        u'ExtendedRoundTripTime',
        u'UTRANAccessPointPositionAltitude',
        u'UTRANAccessPointPositionAltitude-ExtIEs',
        u'RxTimingDeviationInfo',
        u'RxTimingDeviationInfo-ExtIEs',
        u'RxTimingDeviationLCRInfo',
        u'RxTimingDeviationLCRInfo-ExtIEs',
        u'ExtendedTimingAdvanceLCR',
        u'RxTimingDeviation768Info',
        u'RxTimingDeviation768Info-ExtIEs',
        u'RxTimingDeviation384extInfo',
        u'RxTimingDeviation384extInfo-ExtIEs',
        u'AddMeasurementInfo',
        u'AddMeasurementInfo-ExtIEs',
        u'AngleOfArrivalLCR',
        u'AngleOfArrivalLCR-ExtIEs',
        u'RxTimingDeviation',
        u'RxTimingDeviationLCR',
        u'RxTimingDeviation768',
        u'RxTimingDeviation384ext',
        u'TimingAdvance',
        u'TimingAdvanceLCR',
        u'TimingAdvance768',
        u'TimingAdvance384ext',
        u'Pathloss',
        u'CPICH-EcNo',
        u'CPICH-RSCP',
        u'AOA-LCR',
        u'AOA-LCR-Accuracy-Class',
        u'CellId-IRATMeasuredResultsSets',
        u'CellId-IRATMeasuredResultsInfoList',
        u'CellId-IRATMeasuredResultsInfoListExtIEs',
        u'GERAN-MeasuredResultsInfoList',
        u'GERAN-MeasuredResultsInfo',
        u'GERAN-MeasuredResultsInfo-ExtIEs',
        u'GERANCellGlobalID',
        u'GERANCellGlobalID-ExtIEs',
        u'PLMN-Identity',
        u'GSM-RSSI',
        u'GERANPhysicalCellID',
        u'GSM-BSIC',
        u'GSM-BCCH-ARFCN',
        u'CellIDPositioning',
        u'CellIDPositioning-ExtIEs',
        u'RequestedCellIDMeasurements',
        u'RequestedCellIDMeasurementsFDD-ExtIEs',
        u'RequestedCellIDMeasurementsTDD-ExtIEs',
        u'RequestedCellIDGERANMeasurements',
        u'RequestedCellIDGERANMeasurements-ExtIEs',
        u'ClientType',
        u'CriticalityDiagnostics',
        u'CriticalityDiagnostics-IE-List',
        u'CriticalityDiagnostics-IE-List-ExtIEs',
        u'CriticalityDiagnostics-ExtIEs',
        u'CriticalityDiagnosticsRepetition',
        u'TypeOfError',
        u'DGPSCorrections',
        u'DGPSCorrections-ExtIEs',
        u'DiffCorrectionStatus',
        u'DGPS-CorrectionSatInfoList',
        u'DGPS-CorrectionSatInfo',
        u'DGPS-CorrectionSatInfo-ExtIEs',
        u'DGNSS-ValidityPeriod',
        u'DGNSS-ValidityPeriod-ExtIEs',
        u'UDRE',
        u'UDREGrowthRate',
        u'UDREValidityTime',
        u'PRC',
        u'RRC',
        u'IMEI',
        u'IMSI',
        u'UE-PositionEstimate',
        u'GeographicalCoordinates',
        u'GeographicalCoordinates-ExtIEs',
        u'GA-AltitudeAndDirection',
        u'GA-EllipsoidArc',
        u'GA-EllipsoidArc-ExtIEs',
        u'GA-Point',
        u'GA-Point-ExtIEs',
        u'GA-PointWithAltitude',
        u'GA-PointWithAltitude-ExtIEs',
        u'GA-PointWithAltitudeAndUncertaintyEllipsoid',
        u'GA-PointWithAltitudeAndUncertaintyEllipsoid-ExtIEs',
        u'GA-PointWithUnCertainty',
        u'GA-PointWithUnCertainty-ExtIEs',
        u'GA-PointWithUnCertaintyEllipse',
        u'GA-PointWithUnCertaintyEllipse-ExtIEs',
        u'GA-Polygon',
        u'GA-Polygon-ExtIEs',
        u'GA-UncertaintyEllipse',
        u'UE-PositionEstimateInfo',
        u'UE-PositionEstimateInfo-ExtIEs',
        u'ReferenceTimeChoice',
        u'Extension-ReferenceTimeChoice',
        u'Extension-ReferenceTimeChoice-IE',
        u'Cell-Timing',
        u'Cell-Timing-ExtIEs',
        u'GANSS-Reference-Time-Only',
        u'GANSS-Reference-Time-Only-ExtIEs',
        u'PositionDataUEbased',
        u'PositionDataUEbased-ExtIEs',
        u'PositionData',
        u'PositionData-ExtIEs',
        u'GANSS-PositioningDataSet',
        u'GANSS-PositioningMethodAndUsage',
        u'PositioningDataDiscriminator',
        u'PositioningDataSet',
        u'PositioningMethodAndUsage',
        u'Additional-PositioningDataSet',
        u'Additional-PositioningMethodAndUsage',
        u'GPS-AcquisitionAssistance',
        u'GPS-AcquisitionAssistance-ExtIEs',
        u'AcquisitionSatInfoList',
        u'AcquisitionSatInfo',
        u'AcquisitionSatInfo-ExtIEs',
        u'ExtraDopplerInfo',
        u'ExtraDopplerInfo-ExtIEs',
        u'ExtraDopplerInfoExtension',
        u'ExtraDopplerInfoExtension-ExtIEs',
        u'DopplerUncertainty',
        u'DopplerUncertaintyExtension',
        u'CodePhaseSearchWindow',
        u'AzimuthAndElevation',
        u'AzimuthAndElevation-ExtIEs',
        u'AzimuthAndElevationLSB',
        u'AzimuthAndElevationLSB-ExtIEs',
        u'Confidence',
        u'AuxInfoGANSS-ID1',
        u'AuxInfoGANSS-ID1-element',
        u'AuxInfoGANSS-ID1-element-ExtIEs',
        u'AuxInfoGANSS-ID3',
        u'AuxInfoGANSS-ID3-element',
        u'AuxInfoGANSS-ID3-element-ExtIEs',
        u'CNAVclockModel',
        u'CNAVclockModel-ExtIEs',
        u'DeltaUT1',
        u'DeltaUT1-ExtIEs',
        u'DGANSS-Corrections',
        u'DGANSS-Corrections-ExtIEs',
        u'DGANSS-Information',
        u'DGANSS-InformationItem',
        u'DGANSS-InformationItem-ExtIEs',
        u'DGANSS-SignalInformation',
        u'DGANSS-SignalInformationItem',
        u'DGANSS-SignalInformationItem-ExtIEs',
        u'GANSS-AddClockModels',
        u'GANSS-AddOrbitModels',
        u'GANSS-Additional-Ionospheric-Model',
        u'GANSS-Additional-Ionospheric-Model-ExtIEs',
        u'GANSS-Additional-Navigation-Models',
        u'GANSS-Additional-Navigation-Models-ExtIEs',
        u'GANSS-Additional-Time-Models',
        u'GANSS-Additional-UTC-Models',
        u'GANSS-ALM-BDSKeplericanset',
        u'GANSS-ALM-BDSKeplericanset-ExtIEs',
        u'Satellite-Information-BDS-KP-List',
        u'Satellite-Information-BDS-KP-Item',
        u'Satellite-Information-BDS-KP-Item-ExtIEs',
        u'GANSS-ALM-ECEFsbasAlmanacSet',
        u'GANSS-ALM-ECEFsbasAlmanacSet-ExtIEs',
        u'GANSS-ALM-GlonassAlmanacSet',
        u'GANSS-ALM-GlonassAlmanacSet-ExtIEs',
        u'GANSS-ALM-MidiAlmanacSet',
        u'GANSS-ALM-MidiAlmanacSet-ExtIEs',
        u'GANSS-ALM-NAVKeplerianSet',
        u'GANSS-ALM-NAVKeplerianSet-ExtIEs',
        u'GANSS-ALM-ReducedKeplerianSet',
        u'GANSS-ALM-ReducedKeplerianSet-ExtIEs',
        u'GANSS-AlmanacAndSatelliteHealth',
        u'GANSS-AlmanacAndSatelliteHealth-ExtIEs',
        u'GANSS-AlmanacModel',
        u'Extension-GANSS-AlmanacModel',
        u'Extension-GANSS-AlmanacModel-IE',
        u'GANSS-Auxiliary-Information',
        u'GANSS-AzimuthAndElevation',
        u'GANSS-AzimuthAndElevation-ExtIEs',
        u'GANSS-Clock-Model',
        u'GANSS-CommonAssistanceData',
        u'GANSS-CommonAssistanceData-ExtIEs',
        u'GANSS-Data-Bit-Assistance',
        u'GANSS-Data-Bit-Assistance-ExtIEs',
        u'GANSS-DataBitAssistanceList',
        u'GANSS-DataBitAssistanceItem',
        u'GANSS-DataBitAssistanceItem-ExtIEs',
        u'GANSS-DataBitAssistanceSgnList',
        u'GANSS-DataBitAssistanceSgnItem',
        u'GANSS-DataBitAssistanceSgnItem-ExtIEs',
        u'GANSS-Earth-Orientation-Parameters',
        u'GANSS-Earth-Orientation-Parameters-ExtIEs',
        u'GANSS-ExtraDoppler',
        u'GANSS-ExtraDoppler-ExtIEs',
        u'GANSS-ExtraDopplerExtension',
        u'GANSS-ExtraDopplerExtension-ExtIEs',
        u'GANSS-GenericAssistanceDataList',
        u'GANSSGenericAssistanceData',
        u'GANSSGenericAssistance-ExtIEs',
        u'BDS-Ionospheric-Grid-Model',
        u'BDS-Ionospheric-Grid-Model-ExtIEs',
        u'BDS-Reference-Time',
        u'BDS-Ionospheric-Grid-Information',
        u'BDS-Ionospheric-Grid-Information-ExtIEs',
        u'DBDS-Correction-Information',
        u'DBDS-Correction-Information-ExtIEs',
        u'DBDS-Information',
        u'DBDS-Information-ExtIEs',
        u'DGANSS-Signal-Information',
        u'DGANSS-Signal-Information-ExtIEs',
        u'GANSS-GenericMeasurementInfo',
        u'GANSS-GenericMeasurementInfo-ExtIEs',
        u'GANSSID',
        u'GANSSID-ExtIEs',
        u'GANSSMeasurementSignalList',
        u'GANSSMeasurementSignalList-ExtIEs',
        u'GanssCodePhaseAmbiguityExt',
        u'GanssCodePhaseAmbiguityExt-ExtIEs',
        u'GANSS-Ionospheric-Model',
        u'GANSS-Ionospheric-Model-ExtIEs',
        u'GANSS-IonosphereRegionalStormFlags',
        u'GANSS-IonosphereRegionalStormFlags-ExtIEs',
        u'GANSS-KeplerianParametersAlm',
        u'GANSS-KeplerianParametersAlm-ExtIEs',
        u'GANSS-KeplerianParametersOrb',
        u'GANSS-KeplerianParametersOrb-ExtIEs',
        u'GANSS-MeasurementParameters',
        u'GANSS-MeasurementParametersItem',
        u'GANSS-MeasurementParametersItem-ExtIEs',
        u'GanssIntegerCodePhaseExt',
        u'GanssIntegerCodePhaseExt-ExtIEs',
        u'GANSS-MeasuredResultsList',
        u'GANSS-MeasuredResults',
        u'GANSS-MeasuredResults-ExtIEs',
        u'GANSS-Navigation-Model',
        u'GANSS-Navigation-Model-ExtIEs',
        u'GANSS-Orbit-Model',
        u'GANSS-Real-Time-Integrity',
        u'GANSS-RealTimeInformationItem',
        u'GANSS-RealTimeInformationItem-ExtIEs',
        u'GANSS-Reference-Location',
        u'GANSS-Reference-Location-ExtIEs',
        u'GANSS-ReferenceMeasurementInfo',
        u'GANSS-ReferenceMeasurementInfo-ExtIEs',
        u'GANSS-Reference-Time',
        u'GANSS-Reference-Time-ExtIEs',
        u'GANSS-Day-Cycle',
        u'GANSS-ReferenceTimeOnly',
        u'GANSS-ReferenceTimeOnly-ExtIEs',
        u'GANSS-SatelliteClockModelItem',
        u'GANSS-SatelliteClockModelItem-ExtIEs',
        u'GANSS-SatelliteInformation',
        u'GANSS-SatelliteInformationItem',
        u'GANSS-SatelliteInformationItem-ExtIEs',
        u'GANSS-SatelliteInformationKP',
        u'GANSS-SatelliteInformationKPItem',
        u'GANSS-SatelliteInformationKPItem-ExtIEs',
        u'GANSS-SAT-Info-Almanac-GLOkpList',
        u'GANSS-SAT-Info-Almanac-GLOkp',
        u'GANSS-SAT-Info-Almanac-GLOkp-ExtIEs',
        u'GANSS-SAT-Info-Almanac-MIDIkpList',
        u'GANSS-SAT-Info-Almanac-MIDIkp',
        u'GANSS-SAT-Info-Almanac-MIDIkp-ExtIEs',
        u'GANSS-SAT-Info-Almanac-NAVkpList',
        u'GANSS-SAT-Info-Almanac-NAVkp',
        u'GANSS-SAT-Info-Almanac-NAVkp-ExtIEs',
        u'GANSS-SAT-Info-Almanac-REDkpList',
        u'GANSS-SAT-Info-Almanac-REDkp',
        u'GANSS-SAT-Info-Almanac-REDkp-ExtIEs',
        u'GANSS-SAT-Info-Almanac-SBASecefList',
        u'GANSS-SAT-Info-Almanac-SBASecef',
        u'GANSS-SAT-Info-Almanac-SBASecef-ExtIEs',
        u'Ganss-Sat-Info-AddNavList',
        u'Ganss-Sat-Info-AddNavList-ExtIEs',
        u'GANSS-Sat-Info-Nav',
        u'GANSS-Sat-Info-Nav-ExtIEs',
        u'GANSS-SignalID',
        u'GANSS-SignalID-ExtIEs',
        u'GANSS-StatusHealth',
        u'GANSS-Time-Model',
        u'GANSS-Time-Model-ExtIEs',
        u'GANSS-Delta-T',
        u'GANSS-UTRAN-TimeRelationshipUncertainty',
        u'GANSS-UTRAN-TRU',
        u'GANSS-UTRAN-TRU-ExtIEs',
        u'GANSS-UTC-Model',
        u'GANSS-UTC-Model-ExtIEs',
        u'TUTRAN-GANSS-DriftRate',
        u'GLONASSclockModel',
        u'GLONASSclockModel-ExtIEs',
        u'NAVclockModel',
        u'NAVclockModel-ExtIEs',
        u'NavModel-CNAVKeplerianSet',
        u'NavModel-CNAVKeplerianSet-ExtIEs',
        u'NavModel-GLONASSecef',
        u'NavModel-GLONASSecef-ExtIEs',
        u'NavModel-NAVKeplerianSet',
        u'NavModel-NAVKeplerianSet-ExtIEs',
        u'NavModel-SBASecef',
        u'NavModel-SBASecef-ExtIEs',
        u'NavModel-BDSKeplerianSet',
        u'NavModel-BDSKeplerianSet-ExtIEs',
        u'SBASclockModel',
        u'SBASclockModel-ExtIEs',
        u'BDSClockModel',
        u'BDSClockModel-ExtIEs',
        u'UTCmodelSet1',
        u'UTCmodelSet1-ExtIEs',
        u'UTCmodelSet2',
        u'UTCmodelSet2-ExtIEs',
        u'UTCmodelSet3',
        u'UTCmodelSet3-ExtIEs',
        u'UTCmodelSet4',
        u'UTCmodelSet4-ExtIEs',
        u'UTRAN-GANSSReferenceTimeDL',
        u'UTRAN-GANSSReferenceTimeDL-ExtIEs',
        u'UTRAN-GANSSReferenceTimeUL',
        u'UTRAN-GANSSReferenceTimeUL-ExtIEs',
        u'GPS-AlmanacAndSatelliteHealth',
        u'GPS-AlmanacAndSatelliteHealth-ExtIEs',
        u'CompleteAlmanacProvided',
        u'AlmanacSatInfoList',
        u'AlmanacSatInfo',
        u'AlmanacSatInfo-ExtIEs',
        u'GPS-ClockAndEphemerisParameters',
        u'GPS-ClockAndEphemerisParameters-ExtIEs',
        u'SubFrame1Reserved',
        u'GPS-Ionospheric-Model',
        u'GPS-Ionospheric-Model-ExtIEs',
        u'MeasuredResultsList',
        u'GPS-MeasuredResults',
        u'GPS-MeasuredResults-ExtIEs',
        u'GPS-MeasurementParamList',
        u'GPS-MeasurementParam',
        u'MultipathIndicator',
        u'GPS-MeasurementParam-ExtIEs',
        u'GPS-NavigationModel',
        u'NavigationModelSatInfo',
        u'NavigationModelSatInfo-ExtIEs',
        u'SatelliteStatus',
        u'GPS-RealTimeIntegrity',
        u'BadSatList',
        u'NoBadSatellites',
        u'GPS-ReferenceLocation',
        u'GPS-ReferenceLocation-ExtIEs',
        u'GPS-ReferenceTime',
        u'GPS-ReferenceTime-ExtIEs',
        u'GPS-Week-Cycle',
        u'GPS-TOW-AssistList',
        u'GPS-TOW-Assist',
        u'GPS-TOW-Assist-ExtIEs',
        u'UTRAN-GPS-DriftRate',
        u'GPSReferenceTimeUncertainty',
        u'GPSReferenceTimeUncertainty-ExtIEs',
        u'GPS-Transmission-TOW',
        u'GPS-UTC-Model',
        u'GPS-UTCmodel-ExtIEs',
        u'GPS-UTRAN-TRU',
        u'AdditionalGPSAssistDataRequired',
        u'AdditionalGPSAssistDataRequired-ExtIEs',
        u'AdditionalGanssAssistDataRequired',
        u'AdditionalGanssAssistDataRequired-ExtIEs',
        u'GANSSReq-AddIonosphericModel',
        u'GANSSReq-AddIonosphericModel-ExtIEs',
        u'GANSSReq-EarthOrientPara',
        u'GanssRequestedGenericAssistanceDataList',
        u'GanssReqGenericData',
        u'GanssReqGenericData-ExtIEs',
        u'BDSIonosphericGridModel',
        u'DBDSCorrection',
        u'DBDSCorrection-ExtIEs',
        u'GANSS-AddNavigationModel-Req',
        u'GANSS-AddUTCModel-Req',
        u'GANSS-AuxInfo-req',
        u'GANSS-AddADchoices',
        u'GANSS-AddADchoices-ExtIEs',
        u'DGANSS-Sig-Id-Req',
        u'GanssDataBits',
        u'GanssDataBits-ExtIEs',
        u'ReqDataBitAssistanceList',
        u'ReqDataBitAssistanceList-ExtIEs',
        u'InformationExchangeID',
        u'InformationReportCharacteristics',
        u'InformationReportCharacteristicsType',
        u'InformationReportPeriodicity',
        u'InformationType',
        u'ExplicitInformationList',
        u'ExplicitInformation',
        u'DganssCorrectionsReq',
        u'DganssCorrectionsReq-ExtIEs',
        u'Ganss-almanacAndSatelliteHealthReq',
        u'Ganss-almanacAndSatelliteHealthReq-ExtIEs',
        u'GANSSCommonDataReq',
        u'GANSSCommonDataReq-ExtIEs',
        u'GANSS-AddIonoModelReq',
        u'GANSS-AddIonoModelReq-ExtIEs',
        u'GANSS-EarthOrientParaReq',
        u'GANSS-EarthOrientParaReq-ExtIEs',
        u'GANSSGenericDataList',
        u'GANSSGenericDataReq',
        u'AddNavigationModelsGANSS',
        u'AddNavigationModelsGANSS-ExtIEs',
        u'AddSatelliteRelatedDataListGANSS',
        u'AddSatelliteRelatedDataGANSS',
        u'AddSatelliteRelatedDataGANSS-ExtIEs',
        u'BDS-Ionospheric-Grid-Model-Request',
        u'DBDS-Corrections',
        u'DBDS-Corrections-ExtIEs',
        u'GANSS-AddUtcModelsReq',
        u'GANSS-AddUtcModelsReq-ExtIEs',
        u'GANSS-AuxInfoReq',
        u'GANSS-AuxInfoReq-ExtIEs',
        u'GANSS-SBAS-ID',
        u'Ganss-utcModelReq',
        u'Ganss-utcModelReq-ExtIEs',
        u'Ganss-realTimeIntegrityReq',
        u'Ganss-realTimeIntegrityReq-ExtIEs',
        u'Ganss-referenceMeasurementInfoReq',
        u'Ganss-referenceMeasurementInfoReq-ExtIEs',
        u'Ganss-TimeModel-Gnss-Gnss',
        u'Ganss-TimeModel-Gnss-Gnss-ExtIEs',
        u'TransmissionGanssTimeIndicator',
        u'AlmanacAndSatelliteHealth',
        u'UtcModel',
        u'UtcModel-ExtIEs',
        u'IonosphericModel',
        u'IonosphericModel-ExtIEs',
        u'NavigationModel',
        u'NavigationModel-ExtIEs',
        u'NavModelAdditionalData',
        u'NavModelAdditionalData-ExtIEs',
        u'SatelliteRelatedDataList',
        u'SatelliteRelatedData',
        u'SatelliteRelatedData-ExtIEs',
        u'NavigationModelGANSS',
        u'NavigationModelGANSS-ExtIEs',
        u'SatelliteRelatedDataListGANSS',
        u'SatelliteRelatedDataGANSS',
        u'SatelliteRelatedDataGANSS-ExtIEs',
        u'DgpsCorrections',
        u'ReferenceTime',
        u'AcquisitionAssistance',
        u'RealTimeIntegrity',
        u'AlmanacAndSatelliteHealthSIB-InfoType',
        u'AlmanacAndSatelliteHealthSIB-InfoType-ExtIEs',
        u'ReferenceLocation',
        u'TransmissionTOWIndicator',
        u'MessageStructure',
        u'MessageStructureRepetition',
        u'MessageStructure-ExtIEs',
        u'MeasInstructionsUsed',
        u'MeasInstructionsUsed-ExtIEs',
        u'MeasurementValidity',
        u'MeasurementValidity-ExtIEs',
        u'MethodType',
        u'OTDOA-MeasurementGroup',
        u'OTDOA-MeasurementGroup-ExtIEs',
        u'OTDOA-ReferenceCellInfo',
        u'OTDOA-ReferenceCellInfo-ExtIEs',
        u'OTDOA-ReferenceCellInfoSAS-centric',
        u'OTDOA-ReferenceCellInfoSAS-centric-ExtIEs',
        u'OTDOA-NeighbourCellInfoList',
        u'OTDOA-NeighbourCellInfo',
        u'OTDOA-NeighbourCellInfo-ExtIEs',
        u'OTDOA-MeasuredResultsSets',
        u'OTDOA-MeasuredResultsInfoList',
        u'OTDOA-MeasuredResultsInfo',
        u'OTDOA-MeasuredResultsInfo-ExtIEs',
        u'OTDOA-AddMeasuredResultsInfo',
        u'OTDOA-AddMeasuredResultsInfo-ExtIEs',
        u'UE-SFNSFNTimeDifferenceType2Info',
        u'UE-SFNSFNTimeDifferenceInfo-ExtIEs',
        u'UC-ID',
        u'UC-ID-ExtIEs',
        u'Extended-RNC-ID',
        u'RelativeTimingDifferenceInfo',
        u'SFNSFNMeasurementValueInfo',
        u'SFNSFNMeasurementValueInfo-ExtIEs',
        u'SFNSFNValue',
        u'SFNSFNQuality',
        u'SFNSFNDriftRate',
        u'SFNSFNDriftRateQuality',
        u'TUTRANGPSMeasurementValueInfo',
        u'TUTRANGPSMeasurementValueInfo-ExtIEs',
        u'SFN',
        u'TUTRANGPS',
        u'TUTRANGPSQuality',
        u'TUTRANGPSDriftRate',
        u'TUTRANGPSDriftRateQuality',
        u'TUTRANGANSSMeasurementValueInfo',
        u'TUTRANGANSSMeasurementValueInfo-ExtIEs',
        u'TUTRANGANSS',
        u'AdditionalMeasurementInforLCR',
        u'AdditionalMeasurementInforLCR-ExtIEs',
        u'TimingAdvanceLCR-R7',
        u'PeriodicPosCalcInfo',
        u'PeriodicPosCalcInfo-ExtIEs',
        u'PeriodicLocationInfo',
        u'PeriodicLocationInfo-ExtIEs',
        u'PeriodicTerminationCause',
        u'PositioningMethod',
        u'PositioningMethod-ExtIEs',
        u'GNSS-PositioningMethod',
        u'Additional-PositioningMethod',
        u'SelectedPositionMethod',
        u'PositioningPriority',
        u'RRCstateChange',
        u'RRCstateChange-ExtIEs',
        u'RequestedDataValue',
        u'RequestedDataValue-ExtIEs',
        u'RequestedDataValueInformation',
        u'InformationAvailable',
        u'InformationAvailable-ExtIEs',
        u'InformationNotAvailable',
        u'RequestType',
        u'RequestType-ExtIEs',
        u'RequestTypeEvent',
        u'RequestTypeReportArea',
        u'RequestTypeAccuracyCode',
        u'ResponseTime',
        u'HorizontalAccuracyCode',
        u'UE-PositioningCapability',
        u'UE-PositioningCapability-ExtIEs',
        u'NetworkAssistedGANSSSupport',
        u'AddPosSupport',
        u'AddPosSupport-Element',
        u'NetworkAssistedGANSSSuport-ExtIEs',
        u'NetworkAssistedGPSSuport',
        u'GANSS-SBAS-IDs',
        u'GANSS-SBAS-IDs-ExtIEs',
        u'GANSS-Signal-IDs',
        u'GANSS-Signal-IDs-ExtIEs',
        u'SupportGANSSNonNativeADchoices',
        u'UTDOAPositioning',
        u'UTDOAPositioning-ExtIEs',
        u'UTDOA-BitCount',
        u'UTDOA-TimeInterval',
        u'EnvironmentCharacterisation',
        u'GPSPositioning',
        u'GPSPositioning-ExtIEs',
        u'GPSPositioningInstructions',
        u'GPSPositioningInstructions-ExtIEs',
        u'GANSSPositioning',
        u'GANSSPositioning-ExtIEs',
        u'GANSS-PositioningInstructions',
        u'GANSS-PositioningInstructions-ExtIEs',
        u'GANSScarrierPhaseRequested',
        u'GANSSMultiFreqMeasRequested',
        u'OTDOAAssistanceData',
        u'OTDOAAssistanceData-ExtIEs',
        u'UE-Positioning-OTDOA-AssistanceData',
        u'UE-Positioning-OTDOAAssistanceData-ExtIEs',
        u'UE-Positioning-OTDOA-ReferenceCellInfo',
        u'UE-Positioning-OTDOAReferenceCellInfo-ExtIEs',
        u'ReferenceCellPosition',
        u'UE-Positioning-IPDL-Parameters',
        u'UE-Positioning-IPDL-Parameters-ExtIEs',
        u'IP-Spacing',
        u'IP-Length',
        u'BurstModeParameters',
        u'BurstModeParameters-ExtIEs',
        u'UE-Positioning-OTDOA-NeighbourCellList',
        u'UE-Positioning-OTDOA-NeighbourCellInfo',
        u'UE-Positioning-OTDOANeighbourCellInfo-ExtIEs',
        u'SFN-SFN-RelTimeDifference1',
        u'SFN-SFN-RelTimeDifference1-ExtIEs',
        u'SFN-Offset-Validity',
        u'OTDOA-SearchWindowSize',
        u'SFN-SFN-Drift',
        u'FineSFNSFN',
        u'VerticalAccuracyCode',
        u'UTDOA-Group',
        u'UTDOA-Group-ExtIEs',
        u'FrequencyInfo',
        u'FrequencyInfo-ExtIEs',
        u'FrequencyInfoFDD',
        u'FrequencyInfoFDD-ExtIEs',
        u'FrequencyInfoTDD',
        u'FrequencyInfoTDD-ExtIEs',
        u'UTDOA-RRCState',
        u'UTDOA-CELLDCH',
        u'UTDOA-CELLDCH-ExtIEs',
        u'UL-DPCHInfo',
        u'UL-DPCHInfoFDD-ExtIEs',
        u'UL-DPCHInfoTDD-ExtIEs',
        u'Compressed-Mode-Assistance-Data',
        u'Compressed-Mode-Assistance-DataFDD-ExtIEs',
        u'DL-InformationFDD',
        u'DL-InformationFDD-ExtIEs',
        u'UL-InformationFDD',
        u'UL-InformationFDD-ExtIEs',
        u'Transmission-Gap-Pattern-Sequence-Information',
        u'Transmission-Gap-Pattern-Sequence-Information-ExtIEs',
        u'TGD',
        u'TGPRC',
        u'TGPSID',
        u'TGSN',
        u'Uplink-Compressed-Mode-Method',
        u'GapDuration',
        u'GapLength',
        u'Active-Pattern-Sequence-Information',
        u'Active-Pattern-Sequence-Information-ExtIEs',
        u'Transmission-Gap-Pattern-Sequence-Status-List',
        u'Transmission-Gap-Pattern-Sequence-Status-List-ExtIEs',
        u'DCH-Information',
        u'DCH-Information-ExtIEs',
        u'TrChInfoList',
        u'UL-TrCHInfo',
        u'UL-TrCHInfo-ExtIEs',
        u'UL-TrCHType',
        u'E-DPCH-Information',
        u'E-DPCH-Information-ExtIEs',
        u'Max-Set-E-DPDCHs',
        u'E-TFCS-Information',
        u'E-TFCS-Information-ExtIEs',
        u'E-DCH-TFCS-Index',
        u'Reference-E-TFCI-Information',
        u'Reference-E-TFCI-Information-Item',
        u'Reference-E-TFCI-Information-Item-ExtIEs',
        u'Reference-E-TFCI-PO',
        u'E-TFCI',
        u'E-TTI',
        u'E-DPCCH-PO',
        u'CellParameterID',
        u'TFCI-Coding',
        u'RepetitionLength',
        u'RepetitionPeriod',
        u'TDD-DPCHOffset',
        u'UL-Timeslot-Information',
        u'maxNrOfULTSs',
        u'UL-Timeslot-InformationItem',
        u'UL-Timeslot-InformationItem-ExtIEs',
        u'TimeSlot',
        u'MidambleShiftAndBurstType',
        u'MidambleShiftLong',
        u'MidambleShiftShort',
        u'MidambleConfigurationBurstType1And3',
        u'MidambleConfigurationBurstType2',
        u'TDD-UL-Code-Information',
        u'maxNrOfDPCHs',
        u'TDD-UL-Code-InformationItem',
        u'TDD-UL-Code-InformationItem-ExtIEs',
        u'TDD-ChannelisationCode',
        u'SpecialBurstScheduling',
        u'UTDOA-CELLFACH',
        u'UTDOA-CELLFACH-ExtIEs',
        u'PRACHparameters',
        u'PRACH-ChannelInfo',
        u'PRACH-ChannelInfo-ExtIEs',
        u'PRACH-Info',
        u'PRACH-Info-FDD-ExtIEs',
        u'PRACH-Info-TDD-ExtIEs',
        u'SF-PRACH',
        u'AvailableSignatures',
        u'PreambleScramblingCodeWordNumber',
        u'PuncturingLimit',
        u'AvailableSubChannelNumbers',
        u'ScramblingCodeType',
        u'UL-ScramblingCode',
        u'NumberOfFBI-Bits',
        u'TransportFormatSet',
        u'TransportFormatSet-ExtIEs',
        u'TransportFormatSet-DynamicPartList',
        u'TransportFormatSet-DynamicPartList-ExtIEs',
        u'TbsTTIInfo',
        u'TbsTTIInfo-ExtIEs',
        u'RLC-Size',
        u'TransportFormatSet-NrOfTransportBlocks',
        u'TransportFormatSet-Semi-staticPart',
        u'TransportFormatSet-Semi-staticPart-ExtIEs',
        u'TransportFormatSet-TransmissionTimeIntervalSemiStatic',
        u'TransportFormatSet-ChannelCodingType',
        u'TransportFormatSet-CodingRate',
        u'TransportFormatSet-RateMatchingAttribute',
        u'TransportFormatSet-CRC-Size',
        u'TransportFormatSet-TransmissionTimeIntervalDynamic',
        u'TFCS',
        u'CTFC',
        u'C-RNTI',
        u'UARFCN',
        u'CFN',
        u'ChipOffset',
        u'FrameOffset',
        u'PrimaryScramblingCode',
        u'UschParameters',
        u'UschParameters-ExtIEs',
        u'USCH-SchedulingOffset',
        u'MaxPRACH-MidambleShifts',
        u'PRACH-Midamble',
        u'Positioning-ResponseTime',
        u'AmountOfReporting',
        u'IncludeVelocity',
        u'VelocityEstimate',
        u'HorizontalVelocity',
        u'HorizontalVelocity-ExtIEs',
        u'HorizontalWithVerticalVelocity',
        u'HorizontalWithVerticalVelocity-ExtIEs',
        u'HorizontalVelocityWithUncertainty',
        u'HorizontalVelocityWithUncertainty-ExtIEs',
        u'HorizontalWithVerticalVelocityAndUncertainty',
        u'HorizontalWithVerticalVelocityAndUncertainty-ExtIEs',
        u'HorizontalSpeedAndBearing',
        u'VerticalVelocity',
        u'VerticalSpeedDirection',
        u'UTRAN-GPSReferenceTime',
        u'UTRAN-GPSReferenceTime-ExtIEs',
        u'UTRAN-GPSReferenceTimeResult',
        u'UTRAN-GPSReferenceTimeResult-ExtIEs',
        u'UTRAN-GANSSReferenceTimeResult',
        u'UTRAN-GANSSReferenceTimeResult-ExtIEs',
        ]
    _type_ = [
        u'AccuracyFulfilmentIndicator',
        u'AdditionalMethodType',
        u'AddPos-MeasuredResults',
        u'AddPos-MeasuredResults-Element',
        u'WLANMeasurementList',
        u'WLANMeasurementList-Element',
        u'BTMeasurementList',
        u'BTMeasurementList-Element',
        u'MBSMeasurementList',
        u'MBSMeasurementList-Element',
        u'BaroMeasurement',
        u'AlmanacAndSatelliteHealthSIB',
        u'Cause',
        u'CauseRadioNetwork',
        u'CauseTransport',
        u'CauseProtocol',
        u'CauseMisc',
        u'CellId-MeasuredResultsSets',
        u'CellId-MeasuredResultsInfoList',
        u'CellId-MeasuredResultsInfo',
        u'RoundTripTimeInfo',
        u'RoundTripTimeInfoWithType1',
        u'UE-RxTxTimeDifferenceType2',
        u'UE-RxTxTimeDifferenceType1',
        u'UE-PositioningMeasQuality',
        u'RoundTripTime',
        u'ExtendedRoundTripTime',
        u'UTRANAccessPointPositionAltitude',
        u'RxTimingDeviationInfo',
        u'RxTimingDeviationLCRInfo',
        u'ExtendedTimingAdvanceLCR',
        u'RxTimingDeviation768Info',
        u'RxTimingDeviation384extInfo',
        u'AddMeasurementInfo',
        u'AngleOfArrivalLCR',
        u'RxTimingDeviation',
        u'RxTimingDeviationLCR',
        u'RxTimingDeviation768',
        u'RxTimingDeviation384ext',
        u'TimingAdvance',
        u'TimingAdvanceLCR',
        u'TimingAdvance768',
        u'TimingAdvance384ext',
        u'Pathloss',
        u'CPICH-EcNo',
        u'CPICH-RSCP',
        u'AOA-LCR',
        u'AOA-LCR-Accuracy-Class',
        u'CellId-IRATMeasuredResultsSets',
        u'CellId-IRATMeasuredResultsInfoList',
        u'GERAN-MeasuredResultsInfoList',
        u'GERAN-MeasuredResultsInfo',
        u'GERANCellGlobalID',
        u'PLMN-Identity',
        u'GSM-RSSI',
        u'GERANPhysicalCellID',
        u'GSM-BSIC',
        u'GSM-BCCH-ARFCN',
        u'CellIDPositioning',
        u'RequestedCellIDMeasurements',
        u'RequestedCellIDGERANMeasurements',
        u'ClientType',
        u'CriticalityDiagnostics',
        u'CriticalityDiagnostics-IE-List',
        u'CriticalityDiagnosticsRepetition',
        u'TypeOfError',
        u'DGPSCorrections',
        u'DiffCorrectionStatus',
        u'DGPS-CorrectionSatInfoList',
        u'DGPS-CorrectionSatInfo',
        u'DGNSS-ValidityPeriod',
        u'UDRE',
        u'UDREGrowthRate',
        u'UDREValidityTime',
        u'PRC',
        u'RRC',
        u'IMEI',
        u'IMSI',
        u'UE-PositionEstimate',
        u'GeographicalCoordinates',
        u'GA-AltitudeAndDirection',
        u'GA-EllipsoidArc',
        u'GA-Point',
        u'GA-PointWithAltitude',
        u'GA-PointWithAltitudeAndUncertaintyEllipsoid',
        u'GA-PointWithUnCertainty',
        u'GA-PointWithUnCertaintyEllipse',
        u'GA-Polygon',
        u'GA-UncertaintyEllipse',
        u'UE-PositionEstimateInfo',
        u'ReferenceTimeChoice',
        u'Extension-ReferenceTimeChoice',
        u'Cell-Timing',
        u'GANSS-Reference-Time-Only',
        u'PositionDataUEbased',
        u'PositionData',
        u'GANSS-PositioningDataSet',
        u'GANSS-PositioningMethodAndUsage',
        u'PositioningDataDiscriminator',
        u'PositioningDataSet',
        u'PositioningMethodAndUsage',
        u'Additional-PositioningDataSet',
        u'Additional-PositioningMethodAndUsage',
        u'GPS-AcquisitionAssistance',
        u'AcquisitionSatInfoList',
        u'AcquisitionSatInfo',
        u'ExtraDopplerInfo',
        u'ExtraDopplerInfoExtension',
        u'DopplerUncertainty',
        u'DopplerUncertaintyExtension',
        u'CodePhaseSearchWindow',
        u'AzimuthAndElevation',
        u'AzimuthAndElevationLSB',
        u'Confidence',
        u'AuxInfoGANSS-ID1',
        u'AuxInfoGANSS-ID1-element',
        u'AuxInfoGANSS-ID3',
        u'AuxInfoGANSS-ID3-element',
        u'CNAVclockModel',
        u'DeltaUT1',
        u'DGANSS-Corrections',
        u'DGANSS-Information',
        u'DGANSS-InformationItem',
        u'DGANSS-SignalInformation',
        u'DGANSS-SignalInformationItem',
        u'GANSS-AddClockModels',
        u'GANSS-AddOrbitModels',
        u'GANSS-Additional-Ionospheric-Model',
        u'GANSS-Additional-Navigation-Models',
        u'GANSS-Additional-Time-Models',
        u'GANSS-Additional-UTC-Models',
        u'GANSS-ALM-BDSKeplericanset',
        u'Satellite-Information-BDS-KP-List',
        u'Satellite-Information-BDS-KP-Item',
        u'GANSS-ALM-ECEFsbasAlmanacSet',
        u'GANSS-ALM-GlonassAlmanacSet',
        u'GANSS-ALM-MidiAlmanacSet',
        u'GANSS-ALM-NAVKeplerianSet',
        u'GANSS-ALM-ReducedKeplerianSet',
        u'GANSS-AlmanacAndSatelliteHealth',
        u'GANSS-AlmanacModel',
        u'Extension-GANSS-AlmanacModel',
        u'GANSS-Auxiliary-Information',
        u'GANSS-AzimuthAndElevation',
        u'GANSS-Clock-Model',
        u'GANSS-CommonAssistanceData',
        u'GANSS-Data-Bit-Assistance',
        u'GANSS-DataBitAssistanceList',
        u'GANSS-DataBitAssistanceItem',
        u'GANSS-DataBitAssistanceSgnList',
        u'GANSS-DataBitAssistanceSgnItem',
        u'GANSS-Earth-Orientation-Parameters',
        u'GANSS-ExtraDoppler',
        u'GANSS-ExtraDopplerExtension',
        u'GANSS-GenericAssistanceDataList',
        u'GANSSGenericAssistanceData',
        u'BDS-Ionospheric-Grid-Model',
        u'BDS-Reference-Time',
        u'BDS-Ionospheric-Grid-Information',
        u'DBDS-Correction-Information',
        u'DBDS-Information',
        u'DGANSS-Signal-Information',
        u'GANSS-GenericMeasurementInfo',
        u'GANSSID',
        u'GANSSMeasurementSignalList',
        u'GanssCodePhaseAmbiguityExt',
        u'GANSS-Ionospheric-Model',
        u'GANSS-IonosphereRegionalStormFlags',
        u'GANSS-KeplerianParametersAlm',
        u'GANSS-KeplerianParametersOrb',
        u'GANSS-MeasurementParameters',
        u'GANSS-MeasurementParametersItem',
        u'GanssIntegerCodePhaseExt',
        u'GANSS-MeasuredResultsList',
        u'GANSS-MeasuredResults',
        u'GANSS-Navigation-Model',
        u'GANSS-Orbit-Model',
        u'GANSS-Real-Time-Integrity',
        u'GANSS-RealTimeInformationItem',
        u'GANSS-Reference-Location',
        u'GANSS-ReferenceMeasurementInfo',
        u'GANSS-Reference-Time',
        u'GANSS-Day-Cycle',
        u'GANSS-ReferenceTimeOnly',
        u'GANSS-SatelliteClockModelItem',
        u'GANSS-SatelliteInformation',
        u'GANSS-SatelliteInformationItem',
        u'GANSS-SatelliteInformationKP',
        u'GANSS-SatelliteInformationKPItem',
        u'GANSS-SAT-Info-Almanac-GLOkpList',
        u'GANSS-SAT-Info-Almanac-GLOkp',
        u'GANSS-SAT-Info-Almanac-MIDIkpList',
        u'GANSS-SAT-Info-Almanac-MIDIkp',
        u'GANSS-SAT-Info-Almanac-NAVkpList',
        u'GANSS-SAT-Info-Almanac-NAVkp',
        u'GANSS-SAT-Info-Almanac-REDkpList',
        u'GANSS-SAT-Info-Almanac-REDkp',
        u'GANSS-SAT-Info-Almanac-SBASecefList',
        u'GANSS-SAT-Info-Almanac-SBASecef',
        u'Ganss-Sat-Info-AddNavList',
        u'GANSS-Sat-Info-Nav',
        u'GANSS-SignalID',
        u'GANSS-StatusHealth',
        u'GANSS-Time-Model',
        u'GANSS-Delta-T',
        u'GANSS-UTRAN-TimeRelationshipUncertainty',
        u'GANSS-UTRAN-TRU',
        u'GANSS-UTC-Model',
        u'TUTRAN-GANSS-DriftRate',
        u'GLONASSclockModel',
        u'NAVclockModel',
        u'NavModel-CNAVKeplerianSet',
        u'NavModel-GLONASSecef',
        u'NavModel-NAVKeplerianSet',
        u'NavModel-SBASecef',
        u'NavModel-BDSKeplerianSet',
        u'SBASclockModel',
        u'BDSClockModel',
        u'UTCmodelSet1',
        u'UTCmodelSet2',
        u'UTCmodelSet3',
        u'UTCmodelSet4',
        u'UTRAN-GANSSReferenceTimeDL',
        u'UTRAN-GANSSReferenceTimeUL',
        u'GPS-AlmanacAndSatelliteHealth',
        u'CompleteAlmanacProvided',
        u'AlmanacSatInfoList',
        u'AlmanacSatInfo',
        u'GPS-ClockAndEphemerisParameters',
        u'SubFrame1Reserved',
        u'GPS-Ionospheric-Model',
        u'MeasuredResultsList',
        u'GPS-MeasuredResults',
        u'GPS-MeasurementParamList',
        u'GPS-MeasurementParam',
        u'MultipathIndicator',
        u'GPS-NavigationModel',
        u'NavigationModelSatInfo',
        u'SatelliteStatus',
        u'GPS-RealTimeIntegrity',
        u'BadSatList',
        u'NoBadSatellites',
        u'GPS-ReferenceLocation',
        u'GPS-ReferenceTime',
        u'GPS-Week-Cycle',
        u'GPS-TOW-AssistList',
        u'GPS-TOW-Assist',
        u'UTRAN-GPS-DriftRate',
        u'GPSReferenceTimeUncertainty',
        u'GPS-Transmission-TOW',
        u'GPS-UTC-Model',
        u'GPS-UTRAN-TRU',
        u'AdditionalGPSAssistDataRequired',
        u'AdditionalGanssAssistDataRequired',
        u'GANSSReq-AddIonosphericModel',
        u'GANSSReq-EarthOrientPara',
        u'GanssRequestedGenericAssistanceDataList',
        u'GanssReqGenericData',
        u'BDSIonosphericGridModel',
        u'DBDSCorrection',
        u'GANSS-AddNavigationModel-Req',
        u'GANSS-AddUTCModel-Req',
        u'GANSS-AuxInfo-req',
        u'GANSS-AddADchoices',
        u'DGANSS-Sig-Id-Req',
        u'GanssDataBits',
        u'ReqDataBitAssistanceList',
        u'InformationExchangeID',
        u'InformationReportCharacteristics',
        u'InformationReportCharacteristicsType',
        u'InformationReportPeriodicity',
        u'InformationType',
        u'ExplicitInformationList',
        u'ExplicitInformation',
        u'DganssCorrectionsReq',
        u'Ganss-almanacAndSatelliteHealthReq',
        u'GANSSCommonDataReq',
        u'GANSS-AddIonoModelReq',
        u'GANSS-EarthOrientParaReq',
        u'GANSSGenericDataList',
        u'GANSSGenericDataReq',
        u'AddNavigationModelsGANSS',
        u'AddSatelliteRelatedDataListGANSS',
        u'AddSatelliteRelatedDataGANSS',
        u'BDS-Ionospheric-Grid-Model-Request',
        u'DBDS-Corrections',
        u'GANSS-AddUtcModelsReq',
        u'GANSS-AuxInfoReq',
        u'GANSS-SBAS-ID',
        u'Ganss-utcModelReq',
        u'Ganss-realTimeIntegrityReq',
        u'Ganss-referenceMeasurementInfoReq',
        u'Ganss-TimeModel-Gnss-Gnss',
        u'TransmissionGanssTimeIndicator',
        u'AlmanacAndSatelliteHealth',
        u'UtcModel',
        u'IonosphericModel',
        u'NavigationModel',
        u'NavModelAdditionalData',
        u'SatelliteRelatedDataList',
        u'SatelliteRelatedData',
        u'NavigationModelGANSS',
        u'SatelliteRelatedDataListGANSS',
        u'SatelliteRelatedDataGANSS',
        u'DgpsCorrections',
        u'ReferenceTime',
        u'AcquisitionAssistance',
        u'RealTimeIntegrity',
        u'AlmanacAndSatelliteHealthSIB-InfoType',
        u'ReferenceLocation',
        u'TransmissionTOWIndicator',
        u'MessageStructure',
        u'MessageStructureRepetition',
        u'MeasInstructionsUsed',
        u'MeasurementValidity',
        u'MethodType',
        u'OTDOA-MeasurementGroup',
        u'OTDOA-ReferenceCellInfo',
        u'OTDOA-ReferenceCellInfoSAS-centric',
        u'OTDOA-NeighbourCellInfoList',
        u'OTDOA-NeighbourCellInfo',
        u'OTDOA-MeasuredResultsSets',
        u'OTDOA-MeasuredResultsInfoList',
        u'OTDOA-MeasuredResultsInfo',
        u'OTDOA-AddMeasuredResultsInfo',
        u'UE-SFNSFNTimeDifferenceType2Info',
        u'UC-ID',
        u'Extended-RNC-ID',
        u'RelativeTimingDifferenceInfo',
        u'SFNSFNMeasurementValueInfo',
        u'SFNSFNValue',
        u'SFNSFNQuality',
        u'SFNSFNDriftRate',
        u'SFNSFNDriftRateQuality',
        u'TUTRANGPSMeasurementValueInfo',
        u'SFN',
        u'TUTRANGPS',
        u'TUTRANGPSQuality',
        u'TUTRANGPSDriftRate',
        u'TUTRANGPSDriftRateQuality',
        u'TUTRANGANSSMeasurementValueInfo',
        u'TUTRANGANSS',
        u'AdditionalMeasurementInforLCR',
        u'TimingAdvanceLCR-R7',
        u'PeriodicPosCalcInfo',
        u'PeriodicLocationInfo',
        u'PeriodicTerminationCause',
        u'PositioningMethod',
        u'GNSS-PositioningMethod',
        u'Additional-PositioningMethod',
        u'SelectedPositionMethod',
        u'PositioningPriority',
        u'RRCstateChange',
        u'RequestedDataValue',
        u'RequestedDataValueInformation',
        u'InformationAvailable',
        u'InformationNotAvailable',
        u'RequestType',
        u'RequestTypeEvent',
        u'RequestTypeReportArea',
        u'RequestTypeAccuracyCode',
        u'ResponseTime',
        u'HorizontalAccuracyCode',
        u'UE-PositioningCapability',
        u'NetworkAssistedGANSSSupport',
        u'AddPosSupport',
        u'AddPosSupport-Element',
        u'NetworkAssistedGPSSuport',
        u'GANSS-SBAS-IDs',
        u'GANSS-Signal-IDs',
        u'SupportGANSSNonNativeADchoices',
        u'UTDOAPositioning',
        u'UTDOA-BitCount',
        u'UTDOA-TimeInterval',
        u'EnvironmentCharacterisation',
        u'GPSPositioning',
        u'GPSPositioningInstructions',
        u'GANSSPositioning',
        u'GANSS-PositioningInstructions',
        u'GANSScarrierPhaseRequested',
        u'GANSSMultiFreqMeasRequested',
        u'OTDOAAssistanceData',
        u'UE-Positioning-OTDOA-AssistanceData',
        u'UE-Positioning-OTDOA-ReferenceCellInfo',
        u'ReferenceCellPosition',
        u'UE-Positioning-IPDL-Parameters',
        u'IP-Spacing',
        u'IP-Length',
        u'BurstModeParameters',
        u'UE-Positioning-OTDOA-NeighbourCellList',
        u'UE-Positioning-OTDOA-NeighbourCellInfo',
        u'SFN-SFN-RelTimeDifference1',
        u'SFN-Offset-Validity',
        u'OTDOA-SearchWindowSize',
        u'SFN-SFN-Drift',
        u'FineSFNSFN',
        u'VerticalAccuracyCode',
        u'UTDOA-Group',
        u'FrequencyInfo',
        u'FrequencyInfoFDD',
        u'FrequencyInfoTDD',
        u'UTDOA-RRCState',
        u'UTDOA-CELLDCH',
        u'UL-DPCHInfo',
        u'Compressed-Mode-Assistance-Data',
        u'DL-InformationFDD',
        u'UL-InformationFDD',
        u'Transmission-Gap-Pattern-Sequence-Information',
        u'TGD',
        u'TGPRC',
        u'TGPSID',
        u'TGSN',
        u'Uplink-Compressed-Mode-Method',
        u'GapDuration',
        u'GapLength',
        u'Active-Pattern-Sequence-Information',
        u'Transmission-Gap-Pattern-Sequence-Status-List',
        u'DCH-Information',
        u'TrChInfoList',
        u'UL-TrCHInfo',
        u'UL-TrCHType',
        u'E-DPCH-Information',
        u'Max-Set-E-DPDCHs',
        u'E-TFCS-Information',
        u'E-DCH-TFCS-Index',
        u'Reference-E-TFCI-Information',
        u'Reference-E-TFCI-Information-Item',
        u'Reference-E-TFCI-PO',
        u'E-TFCI',
        u'E-TTI',
        u'E-DPCCH-PO',
        u'CellParameterID',
        u'TFCI-Coding',
        u'RepetitionLength',
        u'RepetitionPeriod',
        u'TDD-DPCHOffset',
        u'UL-Timeslot-Information',
        u'UL-Timeslot-InformationItem',
        u'TimeSlot',
        u'MidambleShiftAndBurstType',
        u'MidambleShiftLong',
        u'MidambleShiftShort',
        u'MidambleConfigurationBurstType1And3',
        u'MidambleConfigurationBurstType2',
        u'TDD-UL-Code-Information',
        u'TDD-UL-Code-InformationItem',
        u'TDD-ChannelisationCode',
        u'SpecialBurstScheduling',
        u'UTDOA-CELLFACH',
        u'PRACHparameters',
        u'PRACH-ChannelInfo',
        u'PRACH-Info',
        u'SF-PRACH',
        u'AvailableSignatures',
        u'PreambleScramblingCodeWordNumber',
        u'PuncturingLimit',
        u'AvailableSubChannelNumbers',
        u'ScramblingCodeType',
        u'UL-ScramblingCode',
        u'NumberOfFBI-Bits',
        u'TransportFormatSet',
        u'TransportFormatSet-DynamicPartList',
        u'TbsTTIInfo',
        u'RLC-Size',
        u'TransportFormatSet-NrOfTransportBlocks',
        u'TransportFormatSet-Semi-staticPart',
        u'TransportFormatSet-TransmissionTimeIntervalSemiStatic',
        u'TransportFormatSet-ChannelCodingType',
        u'TransportFormatSet-CodingRate',
        u'TransportFormatSet-RateMatchingAttribute',
        u'TransportFormatSet-CRC-Size',
        u'TransportFormatSet-TransmissionTimeIntervalDynamic',
        u'TFCS',
        u'CTFC',
        u'C-RNTI',
        u'UARFCN',
        u'CFN',
        u'ChipOffset',
        u'FrameOffset',
        u'PrimaryScramblingCode',
        u'UschParameters',
        u'USCH-SchedulingOffset',
        u'MaxPRACH-MidambleShifts',
        u'PRACH-Midamble',
        u'Positioning-ResponseTime',
        u'AmountOfReporting',
        u'IncludeVelocity',
        u'VelocityEstimate',
        u'HorizontalVelocity',
        u'HorizontalWithVerticalVelocity',
        u'HorizontalVelocityWithUncertainty',
        u'HorizontalWithVerticalVelocityAndUncertainty',
        u'HorizontalSpeedAndBearing',
        u'VerticalVelocity',
        u'VerticalSpeedDirection',
        u'UTRAN-GPSReferenceTime',
        u'UTRAN-GPSReferenceTimeResult',
        u'UTRAN-GANSSReferenceTimeResult',
        ]
    _set_ = [
        u'BarometricPressure-ExtIEs',
        u'WLANMeasurementList-ExtIEs',
        u'BTMeasurementList-ExtIEs',
        u'MBSMeasurementList-ExtIEs',
        u'WLANMeasurementList-Element-ExtIEs',
        u'BTMeasurementList-Element-ExtIEs',
        u'MBSMeasurementList-Element-ExtIEs',
        u'AlmanacAndSatelliteHealthSIB-ExtIEs',
        u'CellId-MeasuredResultsInfo-ExtIEs',
        u'RoundTripTimeInfo-ExtIEs',
        u'RoundTripTimeInfoWithType1-ExtIEs',
        u'UE-PositioningMeasQuality-ExtIEs',
        u'UTRANAccessPointPositionAltitude-ExtIEs',
        u'RxTimingDeviationInfo-ExtIEs',
        u'RxTimingDeviationLCRInfo-ExtIEs',
        u'RxTimingDeviation768Info-ExtIEs',
        u'RxTimingDeviation384extInfo-ExtIEs',
        u'AddMeasurementInfo-ExtIEs',
        u'AngleOfArrivalLCR-ExtIEs',
        u'CellId-IRATMeasuredResultsInfoListExtIEs',
        u'GERAN-MeasuredResultsInfo-ExtIEs',
        u'GERANCellGlobalID-ExtIEs',
        u'CellIDPositioning-ExtIEs',
        u'RequestedCellIDMeasurementsFDD-ExtIEs',
        u'RequestedCellIDMeasurementsTDD-ExtIEs',
        u'RequestedCellIDGERANMeasurements-ExtIEs',
        u'CriticalityDiagnostics-IE-List-ExtIEs',
        u'CriticalityDiagnostics-ExtIEs',
        u'DGPSCorrections-ExtIEs',
        u'DGPS-CorrectionSatInfo-ExtIEs',
        u'DGNSS-ValidityPeriod-ExtIEs',
        u'GeographicalCoordinates-ExtIEs',
        u'GA-EllipsoidArc-ExtIEs',
        u'GA-Point-ExtIEs',
        u'GA-PointWithAltitude-ExtIEs',
        u'GA-PointWithAltitudeAndUncertaintyEllipsoid-ExtIEs',
        u'GA-PointWithUnCertainty-ExtIEs',
        u'GA-PointWithUnCertaintyEllipse-ExtIEs',
        u'GA-Polygon-ExtIEs',
        u'UE-PositionEstimateInfo-ExtIEs',
        u'Extension-ReferenceTimeChoice-IE',
        u'Cell-Timing-ExtIEs',
        u'GANSS-Reference-Time-Only-ExtIEs',
        u'PositionDataUEbased-ExtIEs',
        u'PositionData-ExtIEs',
        u'GPS-AcquisitionAssistance-ExtIEs',
        u'AcquisitionSatInfo-ExtIEs',
        u'ExtraDopplerInfo-ExtIEs',
        u'ExtraDopplerInfoExtension-ExtIEs',
        u'AzimuthAndElevation-ExtIEs',
        u'AzimuthAndElevationLSB-ExtIEs',
        u'AuxInfoGANSS-ID1-element-ExtIEs',
        u'AuxInfoGANSS-ID3-element-ExtIEs',
        u'CNAVclockModel-ExtIEs',
        u'DeltaUT1-ExtIEs',
        u'DGANSS-Corrections-ExtIEs',
        u'DGANSS-InformationItem-ExtIEs',
        u'DGANSS-SignalInformationItem-ExtIEs',
        u'GANSS-Additional-Ionospheric-Model-ExtIEs',
        u'GANSS-Additional-Navigation-Models-ExtIEs',
        u'GANSS-ALM-BDSKeplericanset-ExtIEs',
        u'Satellite-Information-BDS-KP-Item-ExtIEs',
        u'GANSS-ALM-ECEFsbasAlmanacSet-ExtIEs',
        u'GANSS-ALM-GlonassAlmanacSet-ExtIEs',
        u'GANSS-ALM-MidiAlmanacSet-ExtIEs',
        u'GANSS-ALM-NAVKeplerianSet-ExtIEs',
        u'GANSS-ALM-ReducedKeplerianSet-ExtIEs',
        u'GANSS-AlmanacAndSatelliteHealth-ExtIEs',
        u'Extension-GANSS-AlmanacModel-IE',
        u'GANSS-AzimuthAndElevation-ExtIEs',
        u'GANSS-CommonAssistanceData-ExtIEs',
        u'GANSS-Data-Bit-Assistance-ExtIEs',
        u'GANSS-DataBitAssistanceItem-ExtIEs',
        u'GANSS-DataBitAssistanceSgnItem-ExtIEs',
        u'GANSS-Earth-Orientation-Parameters-ExtIEs',
        u'GANSS-ExtraDoppler-ExtIEs',
        u'GANSS-ExtraDopplerExtension-ExtIEs',
        u'GANSSGenericAssistance-ExtIEs',
        u'BDS-Ionospheric-Grid-Model-ExtIEs',
        u'BDS-Ionospheric-Grid-Information-ExtIEs',
        u'DBDS-Correction-Information-ExtIEs',
        u'DBDS-Information-ExtIEs',
        u'DGANSS-Signal-Information-ExtIEs',
        u'GANSS-GenericMeasurementInfo-ExtIEs',
        u'GANSSID-ExtIEs',
        u'GANSSMeasurementSignalList-ExtIEs',
        u'GanssCodePhaseAmbiguityExt-ExtIEs',
        u'GANSS-Ionospheric-Model-ExtIEs',
        u'GANSS-IonosphereRegionalStormFlags-ExtIEs',
        u'GANSS-KeplerianParametersAlm-ExtIEs',
        u'GANSS-KeplerianParametersOrb-ExtIEs',
        u'GANSS-MeasurementParametersItem-ExtIEs',
        u'GanssIntegerCodePhaseExt-ExtIEs',
        u'GANSS-MeasuredResults-ExtIEs',
        u'GANSS-Navigation-Model-ExtIEs',
        u'GANSS-RealTimeInformationItem-ExtIEs',
        u'GANSS-Reference-Location-ExtIEs',
        u'GANSS-ReferenceMeasurementInfo-ExtIEs',
        u'GANSS-Reference-Time-ExtIEs',
        u'GANSS-ReferenceTimeOnly-ExtIEs',
        u'GANSS-SatelliteClockModelItem-ExtIEs',
        u'GANSS-SatelliteInformationItem-ExtIEs',
        u'GANSS-SatelliteInformationKPItem-ExtIEs',
        u'GANSS-SAT-Info-Almanac-GLOkp-ExtIEs',
        u'GANSS-SAT-Info-Almanac-MIDIkp-ExtIEs',
        u'GANSS-SAT-Info-Almanac-NAVkp-ExtIEs',
        u'GANSS-SAT-Info-Almanac-REDkp-ExtIEs',
        u'GANSS-SAT-Info-Almanac-SBASecef-ExtIEs',
        u'Ganss-Sat-Info-AddNavList-ExtIEs',
        u'GANSS-Sat-Info-Nav-ExtIEs',
        u'GANSS-SignalID-ExtIEs',
        u'GANSS-Time-Model-ExtIEs',
        u'GANSS-UTRAN-TRU-ExtIEs',
        u'GANSS-UTC-Model-ExtIEs',
        u'GLONASSclockModel-ExtIEs',
        u'NAVclockModel-ExtIEs',
        u'NavModel-CNAVKeplerianSet-ExtIEs',
        u'NavModel-GLONASSecef-ExtIEs',
        u'NavModel-NAVKeplerianSet-ExtIEs',
        u'NavModel-SBASecef-ExtIEs',
        u'NavModel-BDSKeplerianSet-ExtIEs',
        u'SBASclockModel-ExtIEs',
        u'BDSClockModel-ExtIEs',
        u'UTCmodelSet1-ExtIEs',
        u'UTCmodelSet2-ExtIEs',
        u'UTCmodelSet3-ExtIEs',
        u'UTCmodelSet4-ExtIEs',
        u'UTRAN-GANSSReferenceTimeDL-ExtIEs',
        u'UTRAN-GANSSReferenceTimeUL-ExtIEs',
        u'GPS-AlmanacAndSatelliteHealth-ExtIEs',
        u'AlmanacSatInfo-ExtIEs',
        u'GPS-ClockAndEphemerisParameters-ExtIEs',
        u'GPS-Ionospheric-Model-ExtIEs',
        u'GPS-MeasuredResults-ExtIEs',
        u'GPS-MeasurementParam-ExtIEs',
        u'NavigationModelSatInfo-ExtIEs',
        u'GPS-ReferenceLocation-ExtIEs',
        u'GPS-ReferenceTime-ExtIEs',
        u'GPS-TOW-Assist-ExtIEs',
        u'GPSReferenceTimeUncertainty-ExtIEs',
        u'GPS-UTCmodel-ExtIEs',
        u'AdditionalGPSAssistDataRequired-ExtIEs',
        u'AdditionalGanssAssistDataRequired-ExtIEs',
        u'GANSSReq-AddIonosphericModel-ExtIEs',
        u'GanssReqGenericData-ExtIEs',
        u'DBDSCorrection-ExtIEs',
        u'GANSS-AddADchoices-ExtIEs',
        u'GanssDataBits-ExtIEs',
        u'ReqDataBitAssistanceList-ExtIEs',
        u'DganssCorrectionsReq-ExtIEs',
        u'Ganss-almanacAndSatelliteHealthReq-ExtIEs',
        u'GANSSCommonDataReq-ExtIEs',
        u'GANSS-AddIonoModelReq-ExtIEs',
        u'GANSS-EarthOrientParaReq-ExtIEs',
        u'AddNavigationModelsGANSS-ExtIEs',
        u'AddSatelliteRelatedDataGANSS-ExtIEs',
        u'DBDS-Corrections-ExtIEs',
        u'GANSS-AddUtcModelsReq-ExtIEs',
        u'GANSS-AuxInfoReq-ExtIEs',
        u'Ganss-utcModelReq-ExtIEs',
        u'Ganss-realTimeIntegrityReq-ExtIEs',
        u'Ganss-referenceMeasurementInfoReq-ExtIEs',
        u'Ganss-TimeModel-Gnss-Gnss-ExtIEs',
        u'UtcModel-ExtIEs',
        u'IonosphericModel-ExtIEs',
        u'NavigationModel-ExtIEs',
        u'NavModelAdditionalData-ExtIEs',
        u'SatelliteRelatedData-ExtIEs',
        u'NavigationModelGANSS-ExtIEs',
        u'SatelliteRelatedDataGANSS-ExtIEs',
        u'AlmanacAndSatelliteHealthSIB-InfoType-ExtIEs',
        u'MessageStructure-ExtIEs',
        u'MeasInstructionsUsed-ExtIEs',
        u'MeasurementValidity-ExtIEs',
        u'OTDOA-MeasurementGroup-ExtIEs',
        u'OTDOA-ReferenceCellInfo-ExtIEs',
        u'OTDOA-ReferenceCellInfoSAS-centric-ExtIEs',
        u'OTDOA-NeighbourCellInfo-ExtIEs',
        u'OTDOA-MeasuredResultsInfo-ExtIEs',
        u'OTDOA-AddMeasuredResultsInfo-ExtIEs',
        u'UE-SFNSFNTimeDifferenceInfo-ExtIEs',
        u'UC-ID-ExtIEs',
        u'SFNSFNMeasurementValueInfo-ExtIEs',
        u'TUTRANGPSMeasurementValueInfo-ExtIEs',
        u'TUTRANGANSSMeasurementValueInfo-ExtIEs',
        u'AdditionalMeasurementInforLCR-ExtIEs',
        u'PeriodicPosCalcInfo-ExtIEs',
        u'PeriodicLocationInfo-ExtIEs',
        u'PositioningMethod-ExtIEs',
        u'RRCstateChange-ExtIEs',
        u'RequestedDataValue-ExtIEs',
        u'InformationAvailable-ExtIEs',
        u'RequestType-ExtIEs',
        u'UE-PositioningCapability-ExtIEs',
        u'NetworkAssistedGANSSSuport-ExtIEs',
        u'GANSS-SBAS-IDs-ExtIEs',
        u'GANSS-Signal-IDs-ExtIEs',
        u'UTDOAPositioning-ExtIEs',
        u'GPSPositioning-ExtIEs',
        u'GPSPositioningInstructions-ExtIEs',
        u'GANSSPositioning-ExtIEs',
        u'GANSS-PositioningInstructions-ExtIEs',
        u'OTDOAAssistanceData-ExtIEs',
        u'UE-Positioning-OTDOAAssistanceData-ExtIEs',
        u'UE-Positioning-OTDOAReferenceCellInfo-ExtIEs',
        u'UE-Positioning-IPDL-Parameters-ExtIEs',
        u'BurstModeParameters-ExtIEs',
        u'UE-Positioning-OTDOANeighbourCellInfo-ExtIEs',
        u'SFN-SFN-RelTimeDifference1-ExtIEs',
        u'UTDOA-Group-ExtIEs',
        u'FrequencyInfo-ExtIEs',
        u'FrequencyInfoFDD-ExtIEs',
        u'FrequencyInfoTDD-ExtIEs',
        u'UTDOA-CELLDCH-ExtIEs',
        u'UL-DPCHInfoFDD-ExtIEs',
        u'UL-DPCHInfoTDD-ExtIEs',
        u'Compressed-Mode-Assistance-DataFDD-ExtIEs',
        u'DL-InformationFDD-ExtIEs',
        u'UL-InformationFDD-ExtIEs',
        u'Transmission-Gap-Pattern-Sequence-Information-ExtIEs',
        u'Active-Pattern-Sequence-Information-ExtIEs',
        u'Transmission-Gap-Pattern-Sequence-Status-List-ExtIEs',
        u'DCH-Information-ExtIEs',
        u'UL-TrCHInfo-ExtIEs',
        u'E-DPCH-Information-ExtIEs',
        u'E-TFCS-Information-ExtIEs',
        u'Reference-E-TFCI-Information-Item-ExtIEs',
        u'UL-Timeslot-InformationItem-ExtIEs',
        u'TDD-UL-Code-InformationItem-ExtIEs',
        u'UTDOA-CELLFACH-ExtIEs',
        u'PRACH-ChannelInfo-ExtIEs',
        u'PRACH-Info-FDD-ExtIEs',
        u'PRACH-Info-TDD-ExtIEs',
        u'TransportFormatSet-ExtIEs',
        u'TransportFormatSet-DynamicPartList-ExtIEs',
        u'TbsTTIInfo-ExtIEs',
        u'TransportFormatSet-Semi-staticPart-ExtIEs',
        u'UschParameters-ExtIEs',
        u'HorizontalVelocity-ExtIEs',
        u'HorizontalWithVerticalVelocity-ExtIEs',
        u'HorizontalVelocityWithUncertainty-ExtIEs',
        u'HorizontalWithVerticalVelocityAndUncertainty-ExtIEs',
        u'UTRAN-GPSReferenceTime-ExtIEs',
        u'UTRAN-GPSReferenceTimeResult-ExtIEs',
        u'UTRAN-GANSSReferenceTimeResult-ExtIEs',
        ]
    _val_ = [
        u'maxNrOfULTSs',
        u'maxNrOfDPCHs',
        ]
    _class_ = [
        u'BarometricPressure-ExtIEs',
        u'WLANMeasurementList-ExtIEs',
        u'BTMeasurementList-ExtIEs',
        u'MBSMeasurementList-ExtIEs',
        u'WLANMeasurementList-Element-ExtIEs',
        u'BTMeasurementList-Element-ExtIEs',
        u'MBSMeasurementList-Element-ExtIEs',
        u'AlmanacAndSatelliteHealthSIB-ExtIEs',
        u'CellId-MeasuredResultsInfo-ExtIEs',
        u'RoundTripTimeInfo-ExtIEs',
        u'RoundTripTimeInfoWithType1-ExtIEs',
        u'UE-PositioningMeasQuality-ExtIEs',
        u'UTRANAccessPointPositionAltitude-ExtIEs',
        u'RxTimingDeviationInfo-ExtIEs',
        u'RxTimingDeviationLCRInfo-ExtIEs',
        u'RxTimingDeviation768Info-ExtIEs',
        u'RxTimingDeviation384extInfo-ExtIEs',
        u'AddMeasurementInfo-ExtIEs',
        u'AngleOfArrivalLCR-ExtIEs',
        u'CellId-IRATMeasuredResultsInfoListExtIEs',
        u'GERAN-MeasuredResultsInfo-ExtIEs',
        u'GERANCellGlobalID-ExtIEs',
        u'CellIDPositioning-ExtIEs',
        u'RequestedCellIDMeasurementsFDD-ExtIEs',
        u'RequestedCellIDMeasurementsTDD-ExtIEs',
        u'RequestedCellIDGERANMeasurements-ExtIEs',
        u'CriticalityDiagnostics-IE-List-ExtIEs',
        u'CriticalityDiagnostics-ExtIEs',
        u'DGPSCorrections-ExtIEs',
        u'DGPS-CorrectionSatInfo-ExtIEs',
        u'DGNSS-ValidityPeriod-ExtIEs',
        u'GeographicalCoordinates-ExtIEs',
        u'GA-EllipsoidArc-ExtIEs',
        u'GA-Point-ExtIEs',
        u'GA-PointWithAltitude-ExtIEs',
        u'GA-PointWithAltitudeAndUncertaintyEllipsoid-ExtIEs',
        u'GA-PointWithUnCertainty-ExtIEs',
        u'GA-PointWithUnCertaintyEllipse-ExtIEs',
        u'GA-Polygon-ExtIEs',
        u'UE-PositionEstimateInfo-ExtIEs',
        u'Extension-ReferenceTimeChoice-IE',
        u'Cell-Timing-ExtIEs',
        u'GANSS-Reference-Time-Only-ExtIEs',
        u'PositionDataUEbased-ExtIEs',
        u'PositionData-ExtIEs',
        u'GPS-AcquisitionAssistance-ExtIEs',
        u'AcquisitionSatInfo-ExtIEs',
        u'ExtraDopplerInfo-ExtIEs',
        u'ExtraDopplerInfoExtension-ExtIEs',
        u'AzimuthAndElevation-ExtIEs',
        u'AzimuthAndElevationLSB-ExtIEs',
        u'AuxInfoGANSS-ID1-element-ExtIEs',
        u'AuxInfoGANSS-ID3-element-ExtIEs',
        u'CNAVclockModel-ExtIEs',
        u'DeltaUT1-ExtIEs',
        u'DGANSS-Corrections-ExtIEs',
        u'DGANSS-InformationItem-ExtIEs',
        u'DGANSS-SignalInformationItem-ExtIEs',
        u'GANSS-Additional-Ionospheric-Model-ExtIEs',
        u'GANSS-Additional-Navigation-Models-ExtIEs',
        u'GANSS-ALM-BDSKeplericanset-ExtIEs',
        u'Satellite-Information-BDS-KP-Item-ExtIEs',
        u'GANSS-ALM-ECEFsbasAlmanacSet-ExtIEs',
        u'GANSS-ALM-GlonassAlmanacSet-ExtIEs',
        u'GANSS-ALM-MidiAlmanacSet-ExtIEs',
        u'GANSS-ALM-NAVKeplerianSet-ExtIEs',
        u'GANSS-ALM-ReducedKeplerianSet-ExtIEs',
        u'GANSS-AlmanacAndSatelliteHealth-ExtIEs',
        u'Extension-GANSS-AlmanacModel-IE',
        u'GANSS-AzimuthAndElevation-ExtIEs',
        u'GANSS-CommonAssistanceData-ExtIEs',
        u'GANSS-Data-Bit-Assistance-ExtIEs',
        u'GANSS-DataBitAssistanceItem-ExtIEs',
        u'GANSS-DataBitAssistanceSgnItem-ExtIEs',
        u'GANSS-Earth-Orientation-Parameters-ExtIEs',
        u'GANSS-ExtraDoppler-ExtIEs',
        u'GANSS-ExtraDopplerExtension-ExtIEs',
        u'GANSSGenericAssistance-ExtIEs',
        u'BDS-Ionospheric-Grid-Model-ExtIEs',
        u'BDS-Ionospheric-Grid-Information-ExtIEs',
        u'DBDS-Correction-Information-ExtIEs',
        u'DBDS-Information-ExtIEs',
        u'DGANSS-Signal-Information-ExtIEs',
        u'GANSS-GenericMeasurementInfo-ExtIEs',
        u'GANSSID-ExtIEs',
        u'GANSSMeasurementSignalList-ExtIEs',
        u'GanssCodePhaseAmbiguityExt-ExtIEs',
        u'GANSS-Ionospheric-Model-ExtIEs',
        u'GANSS-IonosphereRegionalStormFlags-ExtIEs',
        u'GANSS-KeplerianParametersAlm-ExtIEs',
        u'GANSS-KeplerianParametersOrb-ExtIEs',
        u'GANSS-MeasurementParametersItem-ExtIEs',
        u'GanssIntegerCodePhaseExt-ExtIEs',
        u'GANSS-MeasuredResults-ExtIEs',
        u'GANSS-Navigation-Model-ExtIEs',
        u'GANSS-RealTimeInformationItem-ExtIEs',
        u'GANSS-Reference-Location-ExtIEs',
        u'GANSS-ReferenceMeasurementInfo-ExtIEs',
        u'GANSS-Reference-Time-ExtIEs',
        u'GANSS-ReferenceTimeOnly-ExtIEs',
        u'GANSS-SatelliteClockModelItem-ExtIEs',
        u'GANSS-SatelliteInformationItem-ExtIEs',
        u'GANSS-SatelliteInformationKPItem-ExtIEs',
        u'GANSS-SAT-Info-Almanac-GLOkp-ExtIEs',
        u'GANSS-SAT-Info-Almanac-MIDIkp-ExtIEs',
        u'GANSS-SAT-Info-Almanac-NAVkp-ExtIEs',
        u'GANSS-SAT-Info-Almanac-REDkp-ExtIEs',
        u'GANSS-SAT-Info-Almanac-SBASecef-ExtIEs',
        u'Ganss-Sat-Info-AddNavList-ExtIEs',
        u'GANSS-Sat-Info-Nav-ExtIEs',
        u'GANSS-SignalID-ExtIEs',
        u'GANSS-Time-Model-ExtIEs',
        u'GANSS-UTRAN-TRU-ExtIEs',
        u'GANSS-UTC-Model-ExtIEs',
        u'GLONASSclockModel-ExtIEs',
        u'NAVclockModel-ExtIEs',
        u'NavModel-CNAVKeplerianSet-ExtIEs',
        u'NavModel-GLONASSecef-ExtIEs',
        u'NavModel-NAVKeplerianSet-ExtIEs',
        u'NavModel-SBASecef-ExtIEs',
        u'NavModel-BDSKeplerianSet-ExtIEs',
        u'SBASclockModel-ExtIEs',
        u'BDSClockModel-ExtIEs',
        u'UTCmodelSet1-ExtIEs',
        u'UTCmodelSet2-ExtIEs',
        u'UTCmodelSet3-ExtIEs',
        u'UTCmodelSet4-ExtIEs',
        u'UTRAN-GANSSReferenceTimeDL-ExtIEs',
        u'UTRAN-GANSSReferenceTimeUL-ExtIEs',
        u'GPS-AlmanacAndSatelliteHealth-ExtIEs',
        u'AlmanacSatInfo-ExtIEs',
        u'GPS-ClockAndEphemerisParameters-ExtIEs',
        u'GPS-Ionospheric-Model-ExtIEs',
        u'GPS-MeasuredResults-ExtIEs',
        u'GPS-MeasurementParam-ExtIEs',
        u'NavigationModelSatInfo-ExtIEs',
        u'GPS-ReferenceLocation-ExtIEs',
        u'GPS-ReferenceTime-ExtIEs',
        u'GPS-TOW-Assist-ExtIEs',
        u'GPSReferenceTimeUncertainty-ExtIEs',
        u'GPS-UTCmodel-ExtIEs',
        u'AdditionalGPSAssistDataRequired-ExtIEs',
        u'AdditionalGanssAssistDataRequired-ExtIEs',
        u'GANSSReq-AddIonosphericModel-ExtIEs',
        u'GanssReqGenericData-ExtIEs',
        u'DBDSCorrection-ExtIEs',
        u'GANSS-AddADchoices-ExtIEs',
        u'GanssDataBits-ExtIEs',
        u'ReqDataBitAssistanceList-ExtIEs',
        u'DganssCorrectionsReq-ExtIEs',
        u'Ganss-almanacAndSatelliteHealthReq-ExtIEs',
        u'GANSSCommonDataReq-ExtIEs',
        u'GANSS-AddIonoModelReq-ExtIEs',
        u'GANSS-EarthOrientParaReq-ExtIEs',
        u'AddNavigationModelsGANSS-ExtIEs',
        u'AddSatelliteRelatedDataGANSS-ExtIEs',
        u'DBDS-Corrections-ExtIEs',
        u'GANSS-AddUtcModelsReq-ExtIEs',
        u'GANSS-AuxInfoReq-ExtIEs',
        u'Ganss-utcModelReq-ExtIEs',
        u'Ganss-realTimeIntegrityReq-ExtIEs',
        u'Ganss-referenceMeasurementInfoReq-ExtIEs',
        u'Ganss-TimeModel-Gnss-Gnss-ExtIEs',
        u'UtcModel-ExtIEs',
        u'IonosphericModel-ExtIEs',
        u'NavigationModel-ExtIEs',
        u'NavModelAdditionalData-ExtIEs',
        u'SatelliteRelatedData-ExtIEs',
        u'NavigationModelGANSS-ExtIEs',
        u'SatelliteRelatedDataGANSS-ExtIEs',
        u'AlmanacAndSatelliteHealthSIB-InfoType-ExtIEs',
        u'MessageStructure-ExtIEs',
        u'MeasInstructionsUsed-ExtIEs',
        u'MeasurementValidity-ExtIEs',
        u'OTDOA-MeasurementGroup-ExtIEs',
        u'OTDOA-ReferenceCellInfo-ExtIEs',
        u'OTDOA-ReferenceCellInfoSAS-centric-ExtIEs',
        u'OTDOA-NeighbourCellInfo-ExtIEs',
        u'OTDOA-MeasuredResultsInfo-ExtIEs',
        u'OTDOA-AddMeasuredResultsInfo-ExtIEs',
        u'UE-SFNSFNTimeDifferenceInfo-ExtIEs',
        u'UC-ID-ExtIEs',
        u'SFNSFNMeasurementValueInfo-ExtIEs',
        u'TUTRANGPSMeasurementValueInfo-ExtIEs',
        u'TUTRANGANSSMeasurementValueInfo-ExtIEs',
        u'AdditionalMeasurementInforLCR-ExtIEs',
        u'PeriodicPosCalcInfo-ExtIEs',
        u'PeriodicLocationInfo-ExtIEs',
        u'PositioningMethod-ExtIEs',
        u'RRCstateChange-ExtIEs',
        u'RequestedDataValue-ExtIEs',
        u'InformationAvailable-ExtIEs',
        u'RequestType-ExtIEs',
        u'UE-PositioningCapability-ExtIEs',
        u'NetworkAssistedGANSSSuport-ExtIEs',
        u'GANSS-SBAS-IDs-ExtIEs',
        u'GANSS-Signal-IDs-ExtIEs',
        u'UTDOAPositioning-ExtIEs',
        u'GPSPositioning-ExtIEs',
        u'GPSPositioningInstructions-ExtIEs',
        u'GANSSPositioning-ExtIEs',
        u'GANSS-PositioningInstructions-ExtIEs',
        u'OTDOAAssistanceData-ExtIEs',
        u'UE-Positioning-OTDOAAssistanceData-ExtIEs',
        u'UE-Positioning-OTDOAReferenceCellInfo-ExtIEs',
        u'UE-Positioning-IPDL-Parameters-ExtIEs',
        u'BurstModeParameters-ExtIEs',
        u'UE-Positioning-OTDOANeighbourCellInfo-ExtIEs',
        u'SFN-SFN-RelTimeDifference1-ExtIEs',
        u'UTDOA-Group-ExtIEs',
        u'FrequencyInfo-ExtIEs',
        u'FrequencyInfoFDD-ExtIEs',
        u'FrequencyInfoTDD-ExtIEs',
        u'UTDOA-CELLDCH-ExtIEs',
        u'UL-DPCHInfoFDD-ExtIEs',
        u'UL-DPCHInfoTDD-ExtIEs',
        u'Compressed-Mode-Assistance-DataFDD-ExtIEs',
        u'DL-InformationFDD-ExtIEs',
        u'UL-InformationFDD-ExtIEs',
        u'Transmission-Gap-Pattern-Sequence-Information-ExtIEs',
        u'Active-Pattern-Sequence-Information-ExtIEs',
        u'Transmission-Gap-Pattern-Sequence-Status-List-ExtIEs',
        u'DCH-Information-ExtIEs',
        u'UL-TrCHInfo-ExtIEs',
        u'E-DPCH-Information-ExtIEs',
        u'E-TFCS-Information-ExtIEs',
        u'Reference-E-TFCI-Information-Item-ExtIEs',
        u'UL-Timeslot-InformationItem-ExtIEs',
        u'TDD-UL-Code-InformationItem-ExtIEs',
        u'UTDOA-CELLFACH-ExtIEs',
        u'PRACH-ChannelInfo-ExtIEs',
        u'PRACH-Info-FDD-ExtIEs',
        u'PRACH-Info-TDD-ExtIEs',
        u'TransportFormatSet-ExtIEs',
        u'TransportFormatSet-DynamicPartList-ExtIEs',
        u'TbsTTIInfo-ExtIEs',
        u'TransportFormatSet-Semi-staticPart-ExtIEs',
        u'UschParameters-ExtIEs',
        u'HorizontalVelocity-ExtIEs',
        u'HorizontalWithVerticalVelocity-ExtIEs',
        u'HorizontalVelocityWithUncertainty-ExtIEs',
        u'HorizontalWithVerticalVelocityAndUncertainty-ExtIEs',
        u'UTRAN-GPSReferenceTime-ExtIEs',
        u'UTRAN-GPSReferenceTimeResult-ExtIEs',
        u'UTRAN-GANSSReferenceTimeResult-ExtIEs',
        ]
    _param_ = [
        ]
    
    #-----< AccuracyFulfilmentIndicator >-----#
    AccuracyFulfilmentIndicator = ENUM(name=u'AccuracyFulfilmentIndicator', mode=MODE_TYPE)
    AccuracyFulfilmentIndicator._cont = ASN1Dict([(u'requested-Accuracy-Fulfilled', 0), (u'requested-Accuracy-Not-Fulfilled', 1)])
    AccuracyFulfilmentIndicator._ext = []
    
    #-----< AdditionalMethodType >-----#
    AdditionalMethodType = ENUM(name=u'AdditionalMethodType', mode=MODE_TYPE)
    AdditionalMethodType._cont = ASN1Dict([(u'ue-assisted', 0), (u'ue-based', 1), (u'ue-based-preferred-but-ue-assisted-allowed', 2), (u'ue-assisted-preferred-but-ue-based-allowed', 3)])
    AdditionalMethodType._ext = []
    
    #-----< AddPos-MeasuredResults >-----#
    AddPos_MeasuredResults = SEQ_OF(name=u'AddPos-MeasuredResults', mode=MODE_TYPE)
    _AddPos_MeasuredResults__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'AddPos-MeasuredResults-Element')))
    AddPos_MeasuredResults._cont = _AddPos_MeasuredResults__item_
    AddPos_MeasuredResults._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    
    #-----< AddPos-MeasuredResults-Element >-----#
    AddPos_MeasuredResults_Element = SEQ(name=u'AddPos-MeasuredResults-Element', mode=MODE_TYPE)
    _AddPos_MeasuredResults_Element_timestamp = TIME_UTC(name=u'timestamp', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _AddPos_MeasuredResults_Element_type = CHOICE(name=u'type', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __AddPos_MeasuredResults_Element_type_barometricPressure = SEQ(name=u'barometricPressure', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___AddPos_MeasuredResults_Element_type_barometricPressure_uncompensatedBarometricPressure = INT(name=u'uncompensatedBarometricPressure', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'BaroMeasurement')))
    ___AddPos_MeasuredResults_Element_type_barometricPressure_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    ____AddPos_MeasuredResults_Element_type_barometricPressure_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    _____AddPos_MeasuredResults_Element_type_barometricPressure_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ______AddPos_MeasuredResults_Element_type_barometricPressure_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ______AddPos_MeasuredResults_Element_type_barometricPressure_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____AddPos_MeasuredResults_Element_type_barometricPressure_iE_Extensions__item__id._const_tab = ______AddPos_MeasuredResults_Element_type_barometricPressure_iE_Extensions__item__id_tab
    _____AddPos_MeasuredResults_Element_type_barometricPressure_iE_Extensions__item__id._const_tab_at = None
    _____AddPos_MeasuredResults_Element_type_barometricPressure_iE_Extensions__item__id._const_tab_id = u'id'
    _____AddPos_MeasuredResults_Element_type_barometricPressure_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ______AddPos_MeasuredResults_Element_type_barometricPressure_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ______AddPos_MeasuredResults_Element_type_barometricPressure_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____AddPos_MeasuredResults_Element_type_barometricPressure_iE_Extensions__item__criticality._const_tab = ______AddPos_MeasuredResults_Element_type_barometricPressure_iE_Extensions__item__criticality_tab
    _____AddPos_MeasuredResults_Element_type_barometricPressure_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    _____AddPos_MeasuredResults_Element_type_barometricPressure_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    _____AddPos_MeasuredResults_Element_type_barometricPressure_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ______AddPos_MeasuredResults_Element_type_barometricPressure_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ______AddPos_MeasuredResults_Element_type_barometricPressure_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____AddPos_MeasuredResults_Element_type_barometricPressure_iE_Extensions__item__extensionValue._const_tab = ______AddPos_MeasuredResults_Element_type_barometricPressure_iE_Extensions__item__extensionValue_tab
    _____AddPos_MeasuredResults_Element_type_barometricPressure_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    _____AddPos_MeasuredResults_Element_type_barometricPressure_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    ____AddPos_MeasuredResults_Element_type_barometricPressure_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', _____AddPos_MeasuredResults_Element_type_barometricPressure_iE_Extensions__item__id),
        (u'criticality', _____AddPos_MeasuredResults_Element_type_barometricPressure_iE_Extensions__item__criticality),
        (u'extensionValue', _____AddPos_MeasuredResults_Element_type_barometricPressure_iE_Extensions__item__extensionValue),
        ])
    ____AddPos_MeasuredResults_Element_type_barometricPressure_iE_Extensions__item_._ext = None
    ___AddPos_MeasuredResults_Element_type_barometricPressure_iE_Extensions._cont = ____AddPos_MeasuredResults_Element_type_barometricPressure_iE_Extensions__item_
    ___AddPos_MeasuredResults_Element_type_barometricPressure_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    __AddPos_MeasuredResults_Element_type_barometricPressure._cont = ASN1Dict([
        (u'uncompensatedBarometricPressure', ___AddPos_MeasuredResults_Element_type_barometricPressure_uncompensatedBarometricPressure),
        (u'iE-Extensions', ___AddPos_MeasuredResults_Element_type_barometricPressure_iE_Extensions),
        ])
    __AddPos_MeasuredResults_Element_type_barometricPressure._ext = []
    __AddPos_MeasuredResults_Element_type_wlan = SEQ(name=u'wlan', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___AddPos_MeasuredResults_Element_type_wlan_wlanMeasurementList = SEQ_OF(name=u'wlanMeasurementList', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'WLANMeasurementList')))
    ___AddPos_MeasuredResults_Element_type_wlan_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    ____AddPos_MeasuredResults_Element_type_wlan_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    _____AddPos_MeasuredResults_Element_type_wlan_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ______AddPos_MeasuredResults_Element_type_wlan_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ______AddPos_MeasuredResults_Element_type_wlan_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____AddPos_MeasuredResults_Element_type_wlan_iE_Extensions__item__id._const_tab = ______AddPos_MeasuredResults_Element_type_wlan_iE_Extensions__item__id_tab
    _____AddPos_MeasuredResults_Element_type_wlan_iE_Extensions__item__id._const_tab_at = None
    _____AddPos_MeasuredResults_Element_type_wlan_iE_Extensions__item__id._const_tab_id = u'id'
    _____AddPos_MeasuredResults_Element_type_wlan_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ______AddPos_MeasuredResults_Element_type_wlan_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ______AddPos_MeasuredResults_Element_type_wlan_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____AddPos_MeasuredResults_Element_type_wlan_iE_Extensions__item__criticality._const_tab = ______AddPos_MeasuredResults_Element_type_wlan_iE_Extensions__item__criticality_tab
    _____AddPos_MeasuredResults_Element_type_wlan_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    _____AddPos_MeasuredResults_Element_type_wlan_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    _____AddPos_MeasuredResults_Element_type_wlan_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ______AddPos_MeasuredResults_Element_type_wlan_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ______AddPos_MeasuredResults_Element_type_wlan_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____AddPos_MeasuredResults_Element_type_wlan_iE_Extensions__item__extensionValue._const_tab = ______AddPos_MeasuredResults_Element_type_wlan_iE_Extensions__item__extensionValue_tab
    _____AddPos_MeasuredResults_Element_type_wlan_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    _____AddPos_MeasuredResults_Element_type_wlan_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    ____AddPos_MeasuredResults_Element_type_wlan_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', _____AddPos_MeasuredResults_Element_type_wlan_iE_Extensions__item__id),
        (u'criticality', _____AddPos_MeasuredResults_Element_type_wlan_iE_Extensions__item__criticality),
        (u'extensionValue', _____AddPos_MeasuredResults_Element_type_wlan_iE_Extensions__item__extensionValue),
        ])
    ____AddPos_MeasuredResults_Element_type_wlan_iE_Extensions__item_._ext = None
    ___AddPos_MeasuredResults_Element_type_wlan_iE_Extensions._cont = ____AddPos_MeasuredResults_Element_type_wlan_iE_Extensions__item_
    ___AddPos_MeasuredResults_Element_type_wlan_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    __AddPos_MeasuredResults_Element_type_wlan._cont = ASN1Dict([
        (u'wlanMeasurementList', ___AddPos_MeasuredResults_Element_type_wlan_wlanMeasurementList),
        (u'iE-Extensions', ___AddPos_MeasuredResults_Element_type_wlan_iE_Extensions),
        ])
    __AddPos_MeasuredResults_Element_type_wlan._ext = []
    __AddPos_MeasuredResults_Element_type_bt = SEQ(name=u'bt', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___AddPos_MeasuredResults_Element_type_bt_btMeasurementList = SEQ_OF(name=u'btMeasurementList', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'BTMeasurementList')))
    ___AddPos_MeasuredResults_Element_type_bt_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    ____AddPos_MeasuredResults_Element_type_bt_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    _____AddPos_MeasuredResults_Element_type_bt_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ______AddPos_MeasuredResults_Element_type_bt_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ______AddPos_MeasuredResults_Element_type_bt_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____AddPos_MeasuredResults_Element_type_bt_iE_Extensions__item__id._const_tab = ______AddPos_MeasuredResults_Element_type_bt_iE_Extensions__item__id_tab
    _____AddPos_MeasuredResults_Element_type_bt_iE_Extensions__item__id._const_tab_at = None
    _____AddPos_MeasuredResults_Element_type_bt_iE_Extensions__item__id._const_tab_id = u'id'
    _____AddPos_MeasuredResults_Element_type_bt_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ______AddPos_MeasuredResults_Element_type_bt_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ______AddPos_MeasuredResults_Element_type_bt_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____AddPos_MeasuredResults_Element_type_bt_iE_Extensions__item__criticality._const_tab = ______AddPos_MeasuredResults_Element_type_bt_iE_Extensions__item__criticality_tab
    _____AddPos_MeasuredResults_Element_type_bt_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    _____AddPos_MeasuredResults_Element_type_bt_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    _____AddPos_MeasuredResults_Element_type_bt_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ______AddPos_MeasuredResults_Element_type_bt_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ______AddPos_MeasuredResults_Element_type_bt_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____AddPos_MeasuredResults_Element_type_bt_iE_Extensions__item__extensionValue._const_tab = ______AddPos_MeasuredResults_Element_type_bt_iE_Extensions__item__extensionValue_tab
    _____AddPos_MeasuredResults_Element_type_bt_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    _____AddPos_MeasuredResults_Element_type_bt_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    ____AddPos_MeasuredResults_Element_type_bt_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', _____AddPos_MeasuredResults_Element_type_bt_iE_Extensions__item__id),
        (u'criticality', _____AddPos_MeasuredResults_Element_type_bt_iE_Extensions__item__criticality),
        (u'extensionValue', _____AddPos_MeasuredResults_Element_type_bt_iE_Extensions__item__extensionValue),
        ])
    ____AddPos_MeasuredResults_Element_type_bt_iE_Extensions__item_._ext = None
    ___AddPos_MeasuredResults_Element_type_bt_iE_Extensions._cont = ____AddPos_MeasuredResults_Element_type_bt_iE_Extensions__item_
    ___AddPos_MeasuredResults_Element_type_bt_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    __AddPos_MeasuredResults_Element_type_bt._cont = ASN1Dict([
        (u'btMeasurementList', ___AddPos_MeasuredResults_Element_type_bt_btMeasurementList),
        (u'iE-Extensions', ___AddPos_MeasuredResults_Element_type_bt_iE_Extensions),
        ])
    __AddPos_MeasuredResults_Element_type_bt._ext = []
    __AddPos_MeasuredResults_Element_type_mbs = SEQ(name=u'mbs', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___AddPos_MeasuredResults_Element_type_mbs_mbsMeasurementList = SEQ_OF(name=u'mbsMeasurementList', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'MBSMeasurementList')))
    ___AddPos_MeasuredResults_Element_type_mbs_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    ____AddPos_MeasuredResults_Element_type_mbs_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    _____AddPos_MeasuredResults_Element_type_mbs_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ______AddPos_MeasuredResults_Element_type_mbs_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ______AddPos_MeasuredResults_Element_type_mbs_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____AddPos_MeasuredResults_Element_type_mbs_iE_Extensions__item__id._const_tab = ______AddPos_MeasuredResults_Element_type_mbs_iE_Extensions__item__id_tab
    _____AddPos_MeasuredResults_Element_type_mbs_iE_Extensions__item__id._const_tab_at = None
    _____AddPos_MeasuredResults_Element_type_mbs_iE_Extensions__item__id._const_tab_id = u'id'
    _____AddPos_MeasuredResults_Element_type_mbs_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ______AddPos_MeasuredResults_Element_type_mbs_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ______AddPos_MeasuredResults_Element_type_mbs_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____AddPos_MeasuredResults_Element_type_mbs_iE_Extensions__item__criticality._const_tab = ______AddPos_MeasuredResults_Element_type_mbs_iE_Extensions__item__criticality_tab
    _____AddPos_MeasuredResults_Element_type_mbs_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    _____AddPos_MeasuredResults_Element_type_mbs_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    _____AddPos_MeasuredResults_Element_type_mbs_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ______AddPos_MeasuredResults_Element_type_mbs_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ______AddPos_MeasuredResults_Element_type_mbs_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____AddPos_MeasuredResults_Element_type_mbs_iE_Extensions__item__extensionValue._const_tab = ______AddPos_MeasuredResults_Element_type_mbs_iE_Extensions__item__extensionValue_tab
    _____AddPos_MeasuredResults_Element_type_mbs_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    _____AddPos_MeasuredResults_Element_type_mbs_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    ____AddPos_MeasuredResults_Element_type_mbs_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', _____AddPos_MeasuredResults_Element_type_mbs_iE_Extensions__item__id),
        (u'criticality', _____AddPos_MeasuredResults_Element_type_mbs_iE_Extensions__item__criticality),
        (u'extensionValue', _____AddPos_MeasuredResults_Element_type_mbs_iE_Extensions__item__extensionValue),
        ])
    ____AddPos_MeasuredResults_Element_type_mbs_iE_Extensions__item_._ext = None
    ___AddPos_MeasuredResults_Element_type_mbs_iE_Extensions._cont = ____AddPos_MeasuredResults_Element_type_mbs_iE_Extensions__item_
    ___AddPos_MeasuredResults_Element_type_mbs_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    __AddPos_MeasuredResults_Element_type_mbs._cont = ASN1Dict([
        (u'mbsMeasurementList', ___AddPos_MeasuredResults_Element_type_mbs_mbsMeasurementList),
        (u'iE-Extensions', ___AddPos_MeasuredResults_Element_type_mbs_iE_Extensions),
        ])
    __AddPos_MeasuredResults_Element_type_mbs._ext = []
    _AddPos_MeasuredResults_Element_type._cont = ASN1Dict([
        (u'barometricPressure', __AddPos_MeasuredResults_Element_type_barometricPressure),
        (u'wlan', __AddPos_MeasuredResults_Element_type_wlan),
        (u'bt', __AddPos_MeasuredResults_Element_type_bt),
        (u'mbs', __AddPos_MeasuredResults_Element_type_mbs),
        ])
    _AddPos_MeasuredResults_Element_type._ext = []
    AddPos_MeasuredResults_Element._cont = ASN1Dict([
        (u'timestamp', _AddPos_MeasuredResults_Element_timestamp),
        (u'type', _AddPos_MeasuredResults_Element_type),
        ])
    AddPos_MeasuredResults_Element._ext = []
    
    #-----< BarometricPressure-ExtIEs >-----#
    BarometricPressure_ExtIEs = CLASS(name=u'BarometricPressure-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    BarometricPressure_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< WLANMeasurementList-ExtIEs >-----#
    WLANMeasurementList_ExtIEs = CLASS(name=u'WLANMeasurementList-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    WLANMeasurementList_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< BTMeasurementList-ExtIEs >-----#
    BTMeasurementList_ExtIEs = CLASS(name=u'BTMeasurementList-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    BTMeasurementList_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< MBSMeasurementList-ExtIEs >-----#
    MBSMeasurementList_ExtIEs = CLASS(name=u'MBSMeasurementList-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    MBSMeasurementList_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< WLANMeasurementList >-----#
    WLANMeasurementList = SEQ_OF(name=u'WLANMeasurementList', mode=MODE_TYPE)
    _WLANMeasurementList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'WLANMeasurementList-Element')))
    WLANMeasurementList._cont = _WLANMeasurementList__item_
    WLANMeasurementList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    
    #-----< WLANMeasurementList-Element >-----#
    WLANMeasurementList_Element = SEQ(name=u'WLANMeasurementList-Element', mode=MODE_TYPE)
    _WLANMeasurementList_Element_wlanBSSID = OCT_STR(name=u'wlanBSSID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _WLANMeasurementList_Element_wlanBSSID._const_sz = ASN1Set(rv=[6], rr=[], ev=None, er=[])
    _WLANMeasurementList_Element_wlanSSID = OCT_STR(name=u'wlanSSID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _WLANMeasurementList_Element_wlanSSID._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    _WLANMeasurementList_Element_wlanRSSI = INT(name=u'wlanRSSI', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _WLANMeasurementList_Element_wlanRSSI._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-127, ub=128)], ev=None, er=[])
    _WLANMeasurementList_Element_wlanRTTvalue = INT(name=u'wlanRTTvalue', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _WLANMeasurementList_Element_wlanRTTvalue._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=16777215)], ev=None, er=[])
    _WLANMeasurementList_Element_wlanRTTunits = ENUM(name=u'wlanRTTunits', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _WLANMeasurementList_Element_wlanRTTunits._cont = ASN1Dict([(u'microseconds', 0), (u'hundredsofnanoseconds', 1), (u'tensofnanoseconds', 2), (u'nanoseconds', 3), (u'tenthsofnanosecond', 4)])
    _WLANMeasurementList_Element_wlanRTTunits._ext = []
    _WLANMeasurementList_Element_wlanRTTaccuracy = INT(name=u'wlanRTTaccuracy', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _WLANMeasurementList_Element_wlanRTTaccuracy._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _WLANMeasurementList_Element_wlanAPChannelFrequency = INT(name=u'wlanAPChannelFrequency', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _WLANMeasurementList_Element_wlanAPChannelFrequency._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=256)], ev=None, er=[])
    _WLANMeasurementList_Element_wlanServingFlag = BOOL(name=u'wlanServingFlag', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _WLANMeasurementList_Element_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __WLANMeasurementList_Element_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___WLANMeasurementList_Element_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____WLANMeasurementList_Element_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____WLANMeasurementList_Element_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___WLANMeasurementList_Element_iE_Extensions__item__id._const_tab = ____WLANMeasurementList_Element_iE_Extensions__item__id_tab
    ___WLANMeasurementList_Element_iE_Extensions__item__id._const_tab_at = None
    ___WLANMeasurementList_Element_iE_Extensions__item__id._const_tab_id = u'id'
    ___WLANMeasurementList_Element_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____WLANMeasurementList_Element_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____WLANMeasurementList_Element_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___WLANMeasurementList_Element_iE_Extensions__item__criticality._const_tab = ____WLANMeasurementList_Element_iE_Extensions__item__criticality_tab
    ___WLANMeasurementList_Element_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___WLANMeasurementList_Element_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___WLANMeasurementList_Element_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____WLANMeasurementList_Element_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____WLANMeasurementList_Element_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___WLANMeasurementList_Element_iE_Extensions__item__extensionValue._const_tab = ____WLANMeasurementList_Element_iE_Extensions__item__extensionValue_tab
    ___WLANMeasurementList_Element_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___WLANMeasurementList_Element_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __WLANMeasurementList_Element_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___WLANMeasurementList_Element_iE_Extensions__item__id),
        (u'criticality', ___WLANMeasurementList_Element_iE_Extensions__item__criticality),
        (u'extensionValue', ___WLANMeasurementList_Element_iE_Extensions__item__extensionValue),
        ])
    __WLANMeasurementList_Element_iE_Extensions__item_._ext = None
    _WLANMeasurementList_Element_iE_Extensions._cont = __WLANMeasurementList_Element_iE_Extensions__item_
    _WLANMeasurementList_Element_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    WLANMeasurementList_Element._cont = ASN1Dict([
        (u'wlanBSSID', _WLANMeasurementList_Element_wlanBSSID),
        (u'wlanSSID', _WLANMeasurementList_Element_wlanSSID),
        (u'wlanRSSI', _WLANMeasurementList_Element_wlanRSSI),
        (u'wlanRTTvalue', _WLANMeasurementList_Element_wlanRTTvalue),
        (u'wlanRTTunits', _WLANMeasurementList_Element_wlanRTTunits),
        (u'wlanRTTaccuracy', _WLANMeasurementList_Element_wlanRTTaccuracy),
        (u'wlanAPChannelFrequency', _WLANMeasurementList_Element_wlanAPChannelFrequency),
        (u'wlanServingFlag', _WLANMeasurementList_Element_wlanServingFlag),
        (u'iE-Extensions', _WLANMeasurementList_Element_iE_Extensions),
        ])
    WLANMeasurementList_Element._ext = []
    
    #-----< WLANMeasurementList-Element-ExtIEs >-----#
    WLANMeasurementList_Element_ExtIEs = CLASS(name=u'WLANMeasurementList-Element-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    WLANMeasurementList_Element_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< BTMeasurementList >-----#
    BTMeasurementList = SEQ_OF(name=u'BTMeasurementList', mode=MODE_TYPE)
    _BTMeasurementList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'BTMeasurementList-Element')))
    BTMeasurementList._cont = _BTMeasurementList__item_
    BTMeasurementList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    
    #-----< BTMeasurementList-Element >-----#
    BTMeasurementList_Element = SEQ(name=u'BTMeasurementList-Element', mode=MODE_TYPE)
    _BTMeasurementList_Element_btADDR = OCT_STR(name=u'btADDR', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _BTMeasurementList_Element_btADDR._const_sz = ASN1Set(rv=[6], rr=[], ev=None, er=[])
    _BTMeasurementList_Element_btRSSI = INT(name=u'btRSSI', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _BTMeasurementList_Element_btRSSI._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-127, ub=128)], ev=None, er=[])
    _BTMeasurementList_Element_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __BTMeasurementList_Element_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___BTMeasurementList_Element_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____BTMeasurementList_Element_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____BTMeasurementList_Element_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___BTMeasurementList_Element_iE_Extensions__item__id._const_tab = ____BTMeasurementList_Element_iE_Extensions__item__id_tab
    ___BTMeasurementList_Element_iE_Extensions__item__id._const_tab_at = None
    ___BTMeasurementList_Element_iE_Extensions__item__id._const_tab_id = u'id'
    ___BTMeasurementList_Element_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____BTMeasurementList_Element_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____BTMeasurementList_Element_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___BTMeasurementList_Element_iE_Extensions__item__criticality._const_tab = ____BTMeasurementList_Element_iE_Extensions__item__criticality_tab
    ___BTMeasurementList_Element_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___BTMeasurementList_Element_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___BTMeasurementList_Element_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____BTMeasurementList_Element_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____BTMeasurementList_Element_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___BTMeasurementList_Element_iE_Extensions__item__extensionValue._const_tab = ____BTMeasurementList_Element_iE_Extensions__item__extensionValue_tab
    ___BTMeasurementList_Element_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___BTMeasurementList_Element_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __BTMeasurementList_Element_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___BTMeasurementList_Element_iE_Extensions__item__id),
        (u'criticality', ___BTMeasurementList_Element_iE_Extensions__item__criticality),
        (u'extensionValue', ___BTMeasurementList_Element_iE_Extensions__item__extensionValue),
        ])
    __BTMeasurementList_Element_iE_Extensions__item_._ext = None
    _BTMeasurementList_Element_iE_Extensions._cont = __BTMeasurementList_Element_iE_Extensions__item_
    _BTMeasurementList_Element_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    BTMeasurementList_Element._cont = ASN1Dict([
        (u'btADDR', _BTMeasurementList_Element_btADDR),
        (u'btRSSI', _BTMeasurementList_Element_btRSSI),
        (u'iE-Extensions', _BTMeasurementList_Element_iE_Extensions),
        ])
    BTMeasurementList_Element._ext = []
    
    #-----< BTMeasurementList-Element-ExtIEs >-----#
    BTMeasurementList_Element_ExtIEs = CLASS(name=u'BTMeasurementList-Element-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    BTMeasurementList_Element_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< MBSMeasurementList >-----#
    MBSMeasurementList = SEQ_OF(name=u'MBSMeasurementList', mode=MODE_TYPE)
    _MBSMeasurementList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'MBSMeasurementList-Element')))
    MBSMeasurementList._cont = _MBSMeasurementList__item_
    MBSMeasurementList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    
    #-----< MBSMeasurementList-Element >-----#
    MBSMeasurementList_Element = SEQ(name=u'MBSMeasurementList-Element', mode=MODE_TYPE)
    _MBSMeasurementList_Element_transmitterID = INT(name=u'transmitterID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MBSMeasurementList_Element_transmitterID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=32767)], ev=None, er=[])
    _MBSMeasurementList_Element_codephase = INT(name=u'codephase', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MBSMeasurementList_Element_codephase._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=2097151)], ev=None, er=[])
    _MBSMeasurementList_Element_codephaseRMS = INT(name=u'codephaseRMS', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MBSMeasurementList_Element_codephaseRMS._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    _MBSMeasurementList_Element_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __MBSMeasurementList_Element_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___MBSMeasurementList_Element_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____MBSMeasurementList_Element_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____MBSMeasurementList_Element_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___MBSMeasurementList_Element_iE_Extensions__item__id._const_tab = ____MBSMeasurementList_Element_iE_Extensions__item__id_tab
    ___MBSMeasurementList_Element_iE_Extensions__item__id._const_tab_at = None
    ___MBSMeasurementList_Element_iE_Extensions__item__id._const_tab_id = u'id'
    ___MBSMeasurementList_Element_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____MBSMeasurementList_Element_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____MBSMeasurementList_Element_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___MBSMeasurementList_Element_iE_Extensions__item__criticality._const_tab = ____MBSMeasurementList_Element_iE_Extensions__item__criticality_tab
    ___MBSMeasurementList_Element_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___MBSMeasurementList_Element_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___MBSMeasurementList_Element_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____MBSMeasurementList_Element_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____MBSMeasurementList_Element_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___MBSMeasurementList_Element_iE_Extensions__item__extensionValue._const_tab = ____MBSMeasurementList_Element_iE_Extensions__item__extensionValue_tab
    ___MBSMeasurementList_Element_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___MBSMeasurementList_Element_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __MBSMeasurementList_Element_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___MBSMeasurementList_Element_iE_Extensions__item__id),
        (u'criticality', ___MBSMeasurementList_Element_iE_Extensions__item__criticality),
        (u'extensionValue', ___MBSMeasurementList_Element_iE_Extensions__item__extensionValue),
        ])
    __MBSMeasurementList_Element_iE_Extensions__item_._ext = None
    _MBSMeasurementList_Element_iE_Extensions._cont = __MBSMeasurementList_Element_iE_Extensions__item_
    _MBSMeasurementList_Element_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    MBSMeasurementList_Element._cont = ASN1Dict([
        (u'transmitterID', _MBSMeasurementList_Element_transmitterID),
        (u'codephase', _MBSMeasurementList_Element_codephase),
        (u'codephaseRMS', _MBSMeasurementList_Element_codephaseRMS),
        (u'iE-Extensions', _MBSMeasurementList_Element_iE_Extensions),
        ])
    MBSMeasurementList_Element._ext = []
    
    #-----< MBSMeasurementList-Element-ExtIEs >-----#
    MBSMeasurementList_Element_ExtIEs = CLASS(name=u'MBSMeasurementList-Element-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    MBSMeasurementList_Element_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< BaroMeasurement >-----#
    BaroMeasurement = INT(name=u'BaroMeasurement', mode=MODE_TYPE)
    BaroMeasurement._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=30000, ub=115000)], ev=None, er=[])
    
    #-----< AlmanacAndSatelliteHealthSIB >-----#
    AlmanacAndSatelliteHealthSIB = SEQ(name=u'AlmanacAndSatelliteHealthSIB', mode=MODE_TYPE)
    _AlmanacAndSatelliteHealthSIB_gpsAlmanacAndSatelliteHealth = SEQ(name=u'gpsAlmanacAndSatelliteHealth', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GPS-AlmanacAndSatelliteHealth')))
    _AlmanacAndSatelliteHealthSIB_satMask = BIT_STR(name=u'satMask', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacAndSatelliteHealthSIB_satMask._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    _AlmanacAndSatelliteHealthSIB_lsbTOW = BIT_STR(name=u'lsbTOW', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacAndSatelliteHealthSIB_lsbTOW._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _AlmanacAndSatelliteHealthSIB_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __AlmanacAndSatelliteHealthSIB_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___AlmanacAndSatelliteHealthSIB_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____AlmanacAndSatelliteHealthSIB_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____AlmanacAndSatelliteHealthSIB_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___AlmanacAndSatelliteHealthSIB_iE_Extensions__item__id._const_tab = ____AlmanacAndSatelliteHealthSIB_iE_Extensions__item__id_tab
    ___AlmanacAndSatelliteHealthSIB_iE_Extensions__item__id._const_tab_at = None
    ___AlmanacAndSatelliteHealthSIB_iE_Extensions__item__id._const_tab_id = u'id'
    ___AlmanacAndSatelliteHealthSIB_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____AlmanacAndSatelliteHealthSIB_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____AlmanacAndSatelliteHealthSIB_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___AlmanacAndSatelliteHealthSIB_iE_Extensions__item__criticality._const_tab = ____AlmanacAndSatelliteHealthSIB_iE_Extensions__item__criticality_tab
    ___AlmanacAndSatelliteHealthSIB_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___AlmanacAndSatelliteHealthSIB_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___AlmanacAndSatelliteHealthSIB_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____AlmanacAndSatelliteHealthSIB_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____AlmanacAndSatelliteHealthSIB_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___AlmanacAndSatelliteHealthSIB_iE_Extensions__item__extensionValue._const_tab = ____AlmanacAndSatelliteHealthSIB_iE_Extensions__item__extensionValue_tab
    ___AlmanacAndSatelliteHealthSIB_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___AlmanacAndSatelliteHealthSIB_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __AlmanacAndSatelliteHealthSIB_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___AlmanacAndSatelliteHealthSIB_iE_Extensions__item__id),
        (u'criticality', ___AlmanacAndSatelliteHealthSIB_iE_Extensions__item__criticality),
        (u'extensionValue', ___AlmanacAndSatelliteHealthSIB_iE_Extensions__item__extensionValue),
        ])
    __AlmanacAndSatelliteHealthSIB_iE_Extensions__item_._ext = None
    _AlmanacAndSatelliteHealthSIB_iE_Extensions._cont = __AlmanacAndSatelliteHealthSIB_iE_Extensions__item_
    _AlmanacAndSatelliteHealthSIB_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    AlmanacAndSatelliteHealthSIB._cont = ASN1Dict([
        (u'gpsAlmanacAndSatelliteHealth', _AlmanacAndSatelliteHealthSIB_gpsAlmanacAndSatelliteHealth),
        (u'satMask', _AlmanacAndSatelliteHealthSIB_satMask),
        (u'lsbTOW', _AlmanacAndSatelliteHealthSIB_lsbTOW),
        (u'iE-Extensions', _AlmanacAndSatelliteHealthSIB_iE_Extensions),
        ])
    AlmanacAndSatelliteHealthSIB._ext = []
    
    #-----< AlmanacAndSatelliteHealthSIB-ExtIEs >-----#
    AlmanacAndSatelliteHealthSIB_ExtIEs = CLASS(name=u'AlmanacAndSatelliteHealthSIB-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    AlmanacAndSatelliteHealthSIB_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< Cause >-----#
    Cause = CHOICE(name=u'Cause', mode=MODE_TYPE)
    _Cause_radioNetwork = ENUM(name=u'radioNetwork', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'CauseRadioNetwork')))
    _Cause_transport = ENUM(name=u'transport', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'CauseTransport')))
    _Cause_protocol = ENUM(name=u'protocol', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'CauseProtocol')))
    _Cause_misc = ENUM(name=u'misc', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'CauseMisc')))
    Cause._cont = ASN1Dict([
        (u'radioNetwork', _Cause_radioNetwork),
        (u'transport', _Cause_transport),
        (u'protocol', _Cause_protocol),
        (u'misc', _Cause_misc),
        ])
    Cause._ext = []
    
    #-----< CauseRadioNetwork >-----#
    CauseRadioNetwork = ENUM(name=u'CauseRadioNetwork', mode=MODE_TYPE)
    CauseRadioNetwork._cont = ASN1Dict([(u'invalid-reference-information', 0), (u'information-temporarily-not-available', 1), (u'information-provision-not-supported-for-the-object', 2), (u'position-calculation-error-invalid-GPS-measured-results', 3), (u'position-calculation-error-invalid-CellID-measured-results', 4), (u'position-calculation-error-invalid-OTDOA-measured-results', 5), (u'position-calculation-error-AGPS-positioning-method-not-supported', 6), (u'position-calculation-error-CellID-positioning-method-not-supported', 7), (u'position-calculation-error-OTDOA-positioning-method-not-supported', 8), (u'initial-UE-position-estimate-missing', 9), (u'position-caclulation-error-invalid-UTDOA-measured-results', 10), (u'position-calculation-error-UTDOA-positioning-method-not-supported', 11), (u'position-calculation-error-UTDOA-not-supported-UTRAN-cell', 12), (u'positioning-method-not-supported', 13), (u'loss-of-contact-with-UE', 14), (u'sAS-unable-to-perform-UTDOA-positioning-within-response-time', 15), (u'location-measurement-failure', 16), (u'ue-positioning-error-Not-enough-OTDOA-cells', 17), (u'ue-positioning-error-Not-enough-GPS-Satellites', 18), (u'ue-positioning-error-Reference-Cell-not-serving-cell', 19), (u'ue-positioning-error-Not-Accomplished-GPS-Timing-of-Cell-Frames', 20), (u'ue-positioning-error-Undefined-Error', 21), (u'position-calculation-error-invalid-Galileo-measured-results', 22), (u'position-calculation-error-AGalileo-positioning-method-not-supported', 23), (u'ue-positioning-error-Not-enough-Galileo-Satellites', 24), (u'ue-positioning-error-Not-Accomplished-Galileo-Timing-of-Cell-Frames', 25), (u'ue-positioning-error-Assistance-Data-missing', 26), (u'position-calculation-error-invalid-GLONASS-measured-results', 27), (u'position-calculation-error-invalid-GANSS-measured-results', 28), (u'position-calculation-error-AGANSS-positioning-method-not-supported', 29), (u'ue-positioning-error-Not-enough-GANSS-Satellites', 30), (u'ue-positioning-error-Not-Accomplished-GANSS-Timing-of-Cell-Frames', 31), (u'position-calculation-error-invalid-BDS-measured-results', 32), (u'ue-Positioning-Error-Not-enough-BDS-Satellites', 33), (u'position-calculation-error-A-BDS-positioning-method-not-supported', 34)])
    CauseRadioNetwork._ext = [u'position-calculation-error-invalid-CellID-measured-results', u'position-calculation-error-invalid-OTDOA-measured-results', u'position-calculation-error-AGPS-positioning-method-not-supported', u'position-calculation-error-CellID-positioning-method-not-supported', u'position-calculation-error-OTDOA-positioning-method-not-supported', u'initial-UE-position-estimate-missing', u'position-caclulation-error-invalid-UTDOA-measured-results', u'position-calculation-error-UTDOA-positioning-method-not-supported', u'position-calculation-error-UTDOA-not-supported-UTRAN-cell', u'positioning-method-not-supported', u'loss-of-contact-with-UE', u'sAS-unable-to-perform-UTDOA-positioning-within-response-time', u'location-measurement-failure', u'ue-positioning-error-Not-enough-OTDOA-cells', u'ue-positioning-error-Not-enough-GPS-Satellites', u'ue-positioning-error-Reference-Cell-not-serving-cell', u'ue-positioning-error-Not-Accomplished-GPS-Timing-of-Cell-Frames', u'ue-positioning-error-Undefined-Error', u'position-calculation-error-invalid-Galileo-measured-results', u'position-calculation-error-AGalileo-positioning-method-not-supported', u'ue-positioning-error-Not-enough-Galileo-Satellites', u'ue-positioning-error-Not-Accomplished-Galileo-Timing-of-Cell-Frames', u'ue-positioning-error-Assistance-Data-missing', u'position-calculation-error-invalid-GLONASS-measured-results', u'position-calculation-error-invalid-GANSS-measured-results', u'position-calculation-error-AGANSS-positioning-method-not-supported', u'ue-positioning-error-Not-enough-GANSS-Satellites', u'ue-positioning-error-Not-Accomplished-GANSS-Timing-of-Cell-Frames', u'position-calculation-error-invalid-BDS-measured-results', u'ue-Positioning-Error-Not-enough-BDS-Satellites', u'position-calculation-error-A-BDS-positioning-method-not-supported']
    
    #-----< CauseTransport >-----#
    CauseTransport = ENUM(name=u'CauseTransport', mode=MODE_TYPE)
    CauseTransport._cont = ASN1Dict([(u'transport-resource-unavailable', 0), (u'unspecified', 1)])
    CauseTransport._ext = []
    
    #-----< CauseProtocol >-----#
    CauseProtocol = ENUM(name=u'CauseProtocol', mode=MODE_TYPE)
    CauseProtocol._cont = ASN1Dict([(u'transfer-syntax-error', 0), (u'abstract-syntax-error-reject', 1), (u'abstract-syntax-error-ignore-and-notify', 2), (u'message-not-compatible-with-receiver-state', 3), (u'semantic-error', 4), (u'unspecified', 5), (u'abstract-syntax-error-falsely-constructed-message', 6)])
    CauseProtocol._ext = []
    
    #-----< CauseMisc >-----#
    CauseMisc = ENUM(name=u'CauseMisc', mode=MODE_TYPE)
    CauseMisc._cont = ASN1Dict([(u'processing-overload', 0), (u'hardware-failure', 1), (u'o-and-m-intervention', 2), (u'unspecified', 3)])
    CauseMisc._ext = []
    
    #-----< CellId-MeasuredResultsSets >-----#
    CellId_MeasuredResultsSets = SEQ_OF(name=u'CellId-MeasuredResultsSets', mode=MODE_TYPE)
    _CellId_MeasuredResultsSets__item_ = SEQ_OF(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'CellId-MeasuredResultsInfoList')))
    CellId_MeasuredResultsSets._cont = _CellId_MeasuredResultsSets__item_
    CellId_MeasuredResultsSets._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    
    #-----< CellId-MeasuredResultsInfoList >-----#
    CellId_MeasuredResultsInfoList = SEQ_OF(name=u'CellId-MeasuredResultsInfoList', mode=MODE_TYPE)
    _CellId_MeasuredResultsInfoList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'CellId-MeasuredResultsInfo')))
    CellId_MeasuredResultsInfoList._cont = _CellId_MeasuredResultsInfoList__item_
    CellId_MeasuredResultsInfoList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    
    #-----< CellId-MeasuredResultsInfo >-----#
    CellId_MeasuredResultsInfo = SEQ(name=u'CellId-MeasuredResultsInfo', mode=MODE_TYPE)
    _CellId_MeasuredResultsInfo_uC_ID = SEQ(name=u'uC-ID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'UC-ID')))
    _CellId_MeasuredResultsInfo_uTRANAccessPointPositionAltitude = SEQ(name=u'uTRANAccessPointPositionAltitude', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'UTRANAccessPointPositionAltitude')))
    _CellId_MeasuredResultsInfo_ue_PositionEstimate = CHOICE(name=u'ue-PositionEstimate', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'UE-PositionEstimate')), opt=True)
    _CellId_MeasuredResultsInfo_roundTripTimeInfo = SEQ(name=u'roundTripTimeInfo', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'RoundTripTimeInfo')), opt=True)
    _CellId_MeasuredResultsInfo_rxTimingDeviationInfo = SEQ(name=u'rxTimingDeviationInfo', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'RxTimingDeviationInfo')), opt=True)
    _CellId_MeasuredResultsInfo_rxTimingDeviationLCRInfo = SEQ(name=u'rxTimingDeviationLCRInfo', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'RxTimingDeviationLCRInfo')), opt=True)
    _CellId_MeasuredResultsInfo_pathloss = INT(name=u'pathloss', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'Pathloss')), opt=True)
    _CellId_MeasuredResultsInfo_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __CellId_MeasuredResultsInfo_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___CellId_MeasuredResultsInfo_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____CellId_MeasuredResultsInfo_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____CellId_MeasuredResultsInfo_iE_Extensions__item__id_tab_val_Extension_0 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'RxTimingDeviation768Info')))
    _____CellId_MeasuredResultsInfo_iE_Extensions__item__id_tab_val_Extension_1 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'RxTimingDeviation384extInfo')))
    _____CellId_MeasuredResultsInfo_iE_Extensions__item__id_tab_val_Extension_2 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'RoundTripTimeInfoWithType1')))
    _____CellId_MeasuredResultsInfo_iE_Extensions__item__id_tab_val_Extension_3 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'AddMeasurementInfo')))
    _____CellId_MeasuredResultsInfo_iE_Extensions__item__id_tab_val_Extension_4 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'AngleOfArrivalLCR')))
    ____CellId_MeasuredResultsInfo_iE_Extensions__item__id_tab._val = ASN1Set(rv=[dict([(u'id', 43), (u'criticality', u'reject'), (u'Extension', _____CellId_MeasuredResultsInfo_iE_Extensions__item__id_tab_val_Extension_0), (u'presence', u'optional')]), dict([(u'id', 55), (u'criticality', u'reject'), (u'Extension', _____CellId_MeasuredResultsInfo_iE_Extensions__item__id_tab_val_Extension_1), (u'presence', u'optional')]), dict([(u'id', 64), (u'criticality', u'ignore'), (u'Extension', _____CellId_MeasuredResultsInfo_iE_Extensions__item__id_tab_val_Extension_2), (u'presence', u'optional')]), dict([(u'id', 67), (u'criticality', u'ignore'), (u'Extension', _____CellId_MeasuredResultsInfo_iE_Extensions__item__id_tab_val_Extension_3), (u'presence', u'optional')]), dict([(u'id', 80), (u'criticality', u'ignore'), (u'Extension', _____CellId_MeasuredResultsInfo_iE_Extensions__item__id_tab_val_Extension_4), (u'presence', u'optional')])], rr=[], ev=None, er=[])
    ___CellId_MeasuredResultsInfo_iE_Extensions__item__id._const_tab = ____CellId_MeasuredResultsInfo_iE_Extensions__item__id_tab
    ___CellId_MeasuredResultsInfo_iE_Extensions__item__id._const_tab_at = None
    ___CellId_MeasuredResultsInfo_iE_Extensions__item__id._const_tab_id = u'id'
    ___CellId_MeasuredResultsInfo_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ___CellId_MeasuredResultsInfo_iE_Extensions__item__criticality._const_tab = ____CellId_MeasuredResultsInfo_iE_Extensions__item__id_tab
    ___CellId_MeasuredResultsInfo_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___CellId_MeasuredResultsInfo_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___CellId_MeasuredResultsInfo_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ___CellId_MeasuredResultsInfo_iE_Extensions__item__extensionValue._const_tab = ____CellId_MeasuredResultsInfo_iE_Extensions__item__id_tab
    ___CellId_MeasuredResultsInfo_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___CellId_MeasuredResultsInfo_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __CellId_MeasuredResultsInfo_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___CellId_MeasuredResultsInfo_iE_Extensions__item__id),
        (u'criticality', ___CellId_MeasuredResultsInfo_iE_Extensions__item__criticality),
        (u'extensionValue', ___CellId_MeasuredResultsInfo_iE_Extensions__item__extensionValue),
        ])
    __CellId_MeasuredResultsInfo_iE_Extensions__item_._ext = None
    _CellId_MeasuredResultsInfo_iE_Extensions._cont = __CellId_MeasuredResultsInfo_iE_Extensions__item_
    _CellId_MeasuredResultsInfo_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    CellId_MeasuredResultsInfo._cont = ASN1Dict([
        (u'uC-ID', _CellId_MeasuredResultsInfo_uC_ID),
        (u'uTRANAccessPointPositionAltitude', _CellId_MeasuredResultsInfo_uTRANAccessPointPositionAltitude),
        (u'ue-PositionEstimate', _CellId_MeasuredResultsInfo_ue_PositionEstimate),
        (u'roundTripTimeInfo', _CellId_MeasuredResultsInfo_roundTripTimeInfo),
        (u'rxTimingDeviationInfo', _CellId_MeasuredResultsInfo_rxTimingDeviationInfo),
        (u'rxTimingDeviationLCRInfo', _CellId_MeasuredResultsInfo_rxTimingDeviationLCRInfo),
        (u'pathloss', _CellId_MeasuredResultsInfo_pathloss),
        (u'iE-Extensions', _CellId_MeasuredResultsInfo_iE_Extensions),
        ])
    CellId_MeasuredResultsInfo._ext = []
    
    #-----< CellId-MeasuredResultsInfo-ExtIEs >-----#
    CellId_MeasuredResultsInfo_ExtIEs = CLASS(name=u'CellId-MeasuredResultsInfo-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _CellId_MeasuredResultsInfo_ExtIEs_val_Extension_0 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'RxTimingDeviation768Info')))
    _CellId_MeasuredResultsInfo_ExtIEs_val_Extension_1 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'RxTimingDeviation384extInfo')))
    _CellId_MeasuredResultsInfo_ExtIEs_val_Extension_2 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'RoundTripTimeInfoWithType1')))
    _CellId_MeasuredResultsInfo_ExtIEs_val_Extension_3 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'AddMeasurementInfo')))
    _CellId_MeasuredResultsInfo_ExtIEs_val_Extension_4 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'AngleOfArrivalLCR')))
    CellId_MeasuredResultsInfo_ExtIEs._val = ASN1Set(rv=[dict([(u'id', 43), (u'criticality', u'reject'), (u'Extension', _CellId_MeasuredResultsInfo_ExtIEs_val_Extension_0), (u'presence', u'optional')]), dict([(u'id', 55), (u'criticality', u'reject'), (u'Extension', _CellId_MeasuredResultsInfo_ExtIEs_val_Extension_1), (u'presence', u'optional')]), dict([(u'id', 64), (u'criticality', u'ignore'), (u'Extension', _CellId_MeasuredResultsInfo_ExtIEs_val_Extension_2), (u'presence', u'optional')]), dict([(u'id', 67), (u'criticality', u'ignore'), (u'Extension', _CellId_MeasuredResultsInfo_ExtIEs_val_Extension_3), (u'presence', u'optional')]), dict([(u'id', 80), (u'criticality', u'ignore'), (u'Extension', _CellId_MeasuredResultsInfo_ExtIEs_val_Extension_4), (u'presence', u'optional')])], rr=[], ev=[], er=[])
    
    #-----< RoundTripTimeInfo >-----#
    RoundTripTimeInfo = SEQ(name=u'RoundTripTimeInfo', mode=MODE_TYPE)
    _RoundTripTimeInfo_ue_RxTxTimeDifferenceType2 = INT(name=u'ue-RxTxTimeDifferenceType2', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'UE-RxTxTimeDifferenceType2')))
    _RoundTripTimeInfo_ue_PositioningMeasQuality = SEQ(name=u'ue-PositioningMeasQuality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'UE-PositioningMeasQuality')))
    _RoundTripTimeInfo_roundTripTime = INT(name=u'roundTripTime', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'RoundTripTime')))
    _RoundTripTimeInfo_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __RoundTripTimeInfo_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___RoundTripTimeInfo_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____RoundTripTimeInfo_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____RoundTripTimeInfo_iE_Extensions__item__id_tab_val_Extension_0 = INT(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'ExtendedRoundTripTime')))
    ____RoundTripTimeInfo_iE_Extensions__item__id_tab._val = ASN1Set(rv=[dict([(u'id', 56), (u'criticality', u'ignore'), (u'Extension', _____RoundTripTimeInfo_iE_Extensions__item__id_tab_val_Extension_0), (u'presence', u'optional')])], rr=[], ev=None, er=[])
    ___RoundTripTimeInfo_iE_Extensions__item__id._const_tab = ____RoundTripTimeInfo_iE_Extensions__item__id_tab
    ___RoundTripTimeInfo_iE_Extensions__item__id._const_tab_at = None
    ___RoundTripTimeInfo_iE_Extensions__item__id._const_tab_id = u'id'
    ___RoundTripTimeInfo_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ___RoundTripTimeInfo_iE_Extensions__item__criticality._const_tab = ____RoundTripTimeInfo_iE_Extensions__item__id_tab
    ___RoundTripTimeInfo_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___RoundTripTimeInfo_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___RoundTripTimeInfo_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ___RoundTripTimeInfo_iE_Extensions__item__extensionValue._const_tab = ____RoundTripTimeInfo_iE_Extensions__item__id_tab
    ___RoundTripTimeInfo_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___RoundTripTimeInfo_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __RoundTripTimeInfo_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___RoundTripTimeInfo_iE_Extensions__item__id),
        (u'criticality', ___RoundTripTimeInfo_iE_Extensions__item__criticality),
        (u'extensionValue', ___RoundTripTimeInfo_iE_Extensions__item__extensionValue),
        ])
    __RoundTripTimeInfo_iE_Extensions__item_._ext = None
    _RoundTripTimeInfo_iE_Extensions._cont = __RoundTripTimeInfo_iE_Extensions__item_
    _RoundTripTimeInfo_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    RoundTripTimeInfo._cont = ASN1Dict([
        (u'ue-RxTxTimeDifferenceType2', _RoundTripTimeInfo_ue_RxTxTimeDifferenceType2),
        (u'ue-PositioningMeasQuality', _RoundTripTimeInfo_ue_PositioningMeasQuality),
        (u'roundTripTime', _RoundTripTimeInfo_roundTripTime),
        (u'iE-Extensions', _RoundTripTimeInfo_iE_Extensions),
        ])
    RoundTripTimeInfo._ext = []
    
    #-----< RoundTripTimeInfo-ExtIEs >-----#
    RoundTripTimeInfo_ExtIEs = CLASS(name=u'RoundTripTimeInfo-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _RoundTripTimeInfo_ExtIEs_val_Extension_0 = INT(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'ExtendedRoundTripTime')))
    RoundTripTimeInfo_ExtIEs._val = ASN1Set(rv=[dict([(u'id', 56), (u'criticality', u'ignore'), (u'Extension', _RoundTripTimeInfo_ExtIEs_val_Extension_0), (u'presence', u'optional')])], rr=[], ev=[], er=[])
    
    #-----< RoundTripTimeInfoWithType1 >-----#
    RoundTripTimeInfoWithType1 = SEQ(name=u'RoundTripTimeInfoWithType1', mode=MODE_TYPE)
    _RoundTripTimeInfoWithType1_ue_RxTxTimeDifferenceType1 = INT(name=u'ue-RxTxTimeDifferenceType1', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'UE-RxTxTimeDifferenceType1')))
    _RoundTripTimeInfoWithType1_roundTripTime = INT(name=u'roundTripTime', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'RoundTripTime')))
    _RoundTripTimeInfoWithType1_extendedRoundTripTime = INT(name=u'extendedRoundTripTime', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'ExtendedRoundTripTime')), opt=True)
    _RoundTripTimeInfoWithType1_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __RoundTripTimeInfoWithType1_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___RoundTripTimeInfoWithType1_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____RoundTripTimeInfoWithType1_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____RoundTripTimeInfoWithType1_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___RoundTripTimeInfoWithType1_iE_Extensions__item__id._const_tab = ____RoundTripTimeInfoWithType1_iE_Extensions__item__id_tab
    ___RoundTripTimeInfoWithType1_iE_Extensions__item__id._const_tab_at = None
    ___RoundTripTimeInfoWithType1_iE_Extensions__item__id._const_tab_id = u'id'
    ___RoundTripTimeInfoWithType1_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____RoundTripTimeInfoWithType1_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____RoundTripTimeInfoWithType1_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___RoundTripTimeInfoWithType1_iE_Extensions__item__criticality._const_tab = ____RoundTripTimeInfoWithType1_iE_Extensions__item__criticality_tab
    ___RoundTripTimeInfoWithType1_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___RoundTripTimeInfoWithType1_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___RoundTripTimeInfoWithType1_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____RoundTripTimeInfoWithType1_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____RoundTripTimeInfoWithType1_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___RoundTripTimeInfoWithType1_iE_Extensions__item__extensionValue._const_tab = ____RoundTripTimeInfoWithType1_iE_Extensions__item__extensionValue_tab
    ___RoundTripTimeInfoWithType1_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___RoundTripTimeInfoWithType1_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __RoundTripTimeInfoWithType1_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___RoundTripTimeInfoWithType1_iE_Extensions__item__id),
        (u'criticality', ___RoundTripTimeInfoWithType1_iE_Extensions__item__criticality),
        (u'extensionValue', ___RoundTripTimeInfoWithType1_iE_Extensions__item__extensionValue),
        ])
    __RoundTripTimeInfoWithType1_iE_Extensions__item_._ext = None
    _RoundTripTimeInfoWithType1_iE_Extensions._cont = __RoundTripTimeInfoWithType1_iE_Extensions__item_
    _RoundTripTimeInfoWithType1_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    RoundTripTimeInfoWithType1._cont = ASN1Dict([
        (u'ue-RxTxTimeDifferenceType1', _RoundTripTimeInfoWithType1_ue_RxTxTimeDifferenceType1),
        (u'roundTripTime', _RoundTripTimeInfoWithType1_roundTripTime),
        (u'extendedRoundTripTime', _RoundTripTimeInfoWithType1_extendedRoundTripTime),
        (u'iE-Extensions', _RoundTripTimeInfoWithType1_iE_Extensions),
        ])
    RoundTripTimeInfoWithType1._ext = []
    
    #-----< RoundTripTimeInfoWithType1-ExtIEs >-----#
    RoundTripTimeInfoWithType1_ExtIEs = CLASS(name=u'RoundTripTimeInfoWithType1-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    RoundTripTimeInfoWithType1_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< UE-RxTxTimeDifferenceType2 >-----#
    UE_RxTxTimeDifferenceType2 = INT(name=u'UE-RxTxTimeDifferenceType2', mode=MODE_TYPE)
    UE_RxTxTimeDifferenceType2._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=8191)], ev=None, er=[])
    
    #-----< UE-RxTxTimeDifferenceType1 >-----#
    UE_RxTxTimeDifferenceType1 = INT(name=u'UE-RxTxTimeDifferenceType1', mode=MODE_TYPE)
    UE_RxTxTimeDifferenceType1._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=768, ub=1280)], ev=None, er=[])
    
    #-----< UE-PositioningMeasQuality >-----#
    UE_PositioningMeasQuality = SEQ(name=u'UE-PositioningMeasQuality', mode=MODE_TYPE)
    _UE_PositioningMeasQuality_stdResolution = BIT_STR(name=u'stdResolution', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UE_PositioningMeasQuality_stdResolution._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    _UE_PositioningMeasQuality_numberOfMeasurements = BIT_STR(name=u'numberOfMeasurements', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UE_PositioningMeasQuality_numberOfMeasurements._const_sz = ASN1Set(rv=[3], rr=[], ev=None, er=[])
    _UE_PositioningMeasQuality_stdOfMeasurements = BIT_STR(name=u'stdOfMeasurements', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UE_PositioningMeasQuality_stdOfMeasurements._const_sz = ASN1Set(rv=[5], rr=[], ev=None, er=[])
    _UE_PositioningMeasQuality_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __UE_PositioningMeasQuality_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___UE_PositioningMeasQuality_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____UE_PositioningMeasQuality_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____UE_PositioningMeasQuality_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___UE_PositioningMeasQuality_iE_Extensions__item__id._const_tab = ____UE_PositioningMeasQuality_iE_Extensions__item__id_tab
    ___UE_PositioningMeasQuality_iE_Extensions__item__id._const_tab_at = None
    ___UE_PositioningMeasQuality_iE_Extensions__item__id._const_tab_id = u'id'
    ___UE_PositioningMeasQuality_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____UE_PositioningMeasQuality_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____UE_PositioningMeasQuality_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___UE_PositioningMeasQuality_iE_Extensions__item__criticality._const_tab = ____UE_PositioningMeasQuality_iE_Extensions__item__criticality_tab
    ___UE_PositioningMeasQuality_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___UE_PositioningMeasQuality_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___UE_PositioningMeasQuality_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____UE_PositioningMeasQuality_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____UE_PositioningMeasQuality_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___UE_PositioningMeasQuality_iE_Extensions__item__extensionValue._const_tab = ____UE_PositioningMeasQuality_iE_Extensions__item__extensionValue_tab
    ___UE_PositioningMeasQuality_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___UE_PositioningMeasQuality_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __UE_PositioningMeasQuality_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___UE_PositioningMeasQuality_iE_Extensions__item__id),
        (u'criticality', ___UE_PositioningMeasQuality_iE_Extensions__item__criticality),
        (u'extensionValue', ___UE_PositioningMeasQuality_iE_Extensions__item__extensionValue),
        ])
    __UE_PositioningMeasQuality_iE_Extensions__item_._ext = None
    _UE_PositioningMeasQuality_iE_Extensions._cont = __UE_PositioningMeasQuality_iE_Extensions__item_
    _UE_PositioningMeasQuality_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    UE_PositioningMeasQuality._cont = ASN1Dict([
        (u'stdResolution', _UE_PositioningMeasQuality_stdResolution),
        (u'numberOfMeasurements', _UE_PositioningMeasQuality_numberOfMeasurements),
        (u'stdOfMeasurements', _UE_PositioningMeasQuality_stdOfMeasurements),
        (u'iE-Extensions', _UE_PositioningMeasQuality_iE_Extensions),
        ])
    UE_PositioningMeasQuality._ext = []
    
    #-----< UE-PositioningMeasQuality-ExtIEs >-----#
    UE_PositioningMeasQuality_ExtIEs = CLASS(name=u'UE-PositioningMeasQuality-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    UE_PositioningMeasQuality_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< RoundTripTime >-----#
    RoundTripTime = INT(name=u'RoundTripTime', mode=MODE_TYPE)
    RoundTripTime._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=32766)], ev=None, er=[])
    
    #-----< ExtendedRoundTripTime >-----#
    ExtendedRoundTripTime = INT(name=u'ExtendedRoundTripTime', mode=MODE_TYPE)
    ExtendedRoundTripTime._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=32767, ub=103041)], ev=None, er=[])
    
    #-----< UTRANAccessPointPositionAltitude >-----#
    UTRANAccessPointPositionAltitude = SEQ(name=u'UTRANAccessPointPositionAltitude', mode=MODE_TYPE)
    _UTRANAccessPointPositionAltitude_geographicalCoordinates = SEQ(name=u'geographicalCoordinates', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GeographicalCoordinates')))
    _UTRANAccessPointPositionAltitude_ga_AltitudeAndDirection = SEQ(name=u'ga-AltitudeAndDirection', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GA-AltitudeAndDirection')), opt=True)
    _UTRANAccessPointPositionAltitude_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __UTRANAccessPointPositionAltitude_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___UTRANAccessPointPositionAltitude_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____UTRANAccessPointPositionAltitude_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____UTRANAccessPointPositionAltitude_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___UTRANAccessPointPositionAltitude_iE_Extensions__item__id._const_tab = ____UTRANAccessPointPositionAltitude_iE_Extensions__item__id_tab
    ___UTRANAccessPointPositionAltitude_iE_Extensions__item__id._const_tab_at = None
    ___UTRANAccessPointPositionAltitude_iE_Extensions__item__id._const_tab_id = u'id'
    ___UTRANAccessPointPositionAltitude_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____UTRANAccessPointPositionAltitude_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____UTRANAccessPointPositionAltitude_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___UTRANAccessPointPositionAltitude_iE_Extensions__item__criticality._const_tab = ____UTRANAccessPointPositionAltitude_iE_Extensions__item__criticality_tab
    ___UTRANAccessPointPositionAltitude_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___UTRANAccessPointPositionAltitude_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___UTRANAccessPointPositionAltitude_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____UTRANAccessPointPositionAltitude_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____UTRANAccessPointPositionAltitude_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___UTRANAccessPointPositionAltitude_iE_Extensions__item__extensionValue._const_tab = ____UTRANAccessPointPositionAltitude_iE_Extensions__item__extensionValue_tab
    ___UTRANAccessPointPositionAltitude_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___UTRANAccessPointPositionAltitude_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __UTRANAccessPointPositionAltitude_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___UTRANAccessPointPositionAltitude_iE_Extensions__item__id),
        (u'criticality', ___UTRANAccessPointPositionAltitude_iE_Extensions__item__criticality),
        (u'extensionValue', ___UTRANAccessPointPositionAltitude_iE_Extensions__item__extensionValue),
        ])
    __UTRANAccessPointPositionAltitude_iE_Extensions__item_._ext = None
    _UTRANAccessPointPositionAltitude_iE_Extensions._cont = __UTRANAccessPointPositionAltitude_iE_Extensions__item_
    _UTRANAccessPointPositionAltitude_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    UTRANAccessPointPositionAltitude._cont = ASN1Dict([
        (u'geographicalCoordinates', _UTRANAccessPointPositionAltitude_geographicalCoordinates),
        (u'ga-AltitudeAndDirection', _UTRANAccessPointPositionAltitude_ga_AltitudeAndDirection),
        (u'iE-Extensions', _UTRANAccessPointPositionAltitude_iE_Extensions),
        ])
    UTRANAccessPointPositionAltitude._ext = []
    
    #-----< UTRANAccessPointPositionAltitude-ExtIEs >-----#
    UTRANAccessPointPositionAltitude_ExtIEs = CLASS(name=u'UTRANAccessPointPositionAltitude-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    UTRANAccessPointPositionAltitude_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< RxTimingDeviationInfo >-----#
    RxTimingDeviationInfo = SEQ(name=u'RxTimingDeviationInfo', mode=MODE_TYPE)
    _RxTimingDeviationInfo_rxTimingDeviation = INT(name=u'rxTimingDeviation', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'RxTimingDeviation')))
    _RxTimingDeviationInfo_timingAdvance = INT(name=u'timingAdvance', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'TimingAdvance')))
    _RxTimingDeviationInfo_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __RxTimingDeviationInfo_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___RxTimingDeviationInfo_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____RxTimingDeviationInfo_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____RxTimingDeviationInfo_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___RxTimingDeviationInfo_iE_Extensions__item__id._const_tab = ____RxTimingDeviationInfo_iE_Extensions__item__id_tab
    ___RxTimingDeviationInfo_iE_Extensions__item__id._const_tab_at = None
    ___RxTimingDeviationInfo_iE_Extensions__item__id._const_tab_id = u'id'
    ___RxTimingDeviationInfo_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____RxTimingDeviationInfo_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____RxTimingDeviationInfo_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___RxTimingDeviationInfo_iE_Extensions__item__criticality._const_tab = ____RxTimingDeviationInfo_iE_Extensions__item__criticality_tab
    ___RxTimingDeviationInfo_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___RxTimingDeviationInfo_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___RxTimingDeviationInfo_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____RxTimingDeviationInfo_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____RxTimingDeviationInfo_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___RxTimingDeviationInfo_iE_Extensions__item__extensionValue._const_tab = ____RxTimingDeviationInfo_iE_Extensions__item__extensionValue_tab
    ___RxTimingDeviationInfo_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___RxTimingDeviationInfo_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __RxTimingDeviationInfo_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___RxTimingDeviationInfo_iE_Extensions__item__id),
        (u'criticality', ___RxTimingDeviationInfo_iE_Extensions__item__criticality),
        (u'extensionValue', ___RxTimingDeviationInfo_iE_Extensions__item__extensionValue),
        ])
    __RxTimingDeviationInfo_iE_Extensions__item_._ext = None
    _RxTimingDeviationInfo_iE_Extensions._cont = __RxTimingDeviationInfo_iE_Extensions__item_
    _RxTimingDeviationInfo_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    RxTimingDeviationInfo._cont = ASN1Dict([
        (u'rxTimingDeviation', _RxTimingDeviationInfo_rxTimingDeviation),
        (u'timingAdvance', _RxTimingDeviationInfo_timingAdvance),
        (u'iE-Extensions', _RxTimingDeviationInfo_iE_Extensions),
        ])
    RxTimingDeviationInfo._ext = []
    
    #-----< RxTimingDeviationInfo-ExtIEs >-----#
    RxTimingDeviationInfo_ExtIEs = CLASS(name=u'RxTimingDeviationInfo-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    RxTimingDeviationInfo_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< RxTimingDeviationLCRInfo >-----#
    RxTimingDeviationLCRInfo = SEQ(name=u'RxTimingDeviationLCRInfo', mode=MODE_TYPE)
    _RxTimingDeviationLCRInfo_rxTimingDeviationLCR = INT(name=u'rxTimingDeviationLCR', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'RxTimingDeviationLCR')))
    _RxTimingDeviationLCRInfo_timingAdvanceLCR = INT(name=u'timingAdvanceLCR', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'TimingAdvanceLCR')))
    _RxTimingDeviationLCRInfo_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __RxTimingDeviationLCRInfo_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___RxTimingDeviationLCRInfo_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____RxTimingDeviationLCRInfo_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____RxTimingDeviationLCRInfo_iE_Extensions__item__id_tab_val_Extension_0 = INT(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'ExtendedTimingAdvanceLCR')))
    ____RxTimingDeviationLCRInfo_iE_Extensions__item__id_tab._val = ASN1Set(rv=[dict([(u'id', 81), (u'criticality', u'ignore'), (u'Extension', _____RxTimingDeviationLCRInfo_iE_Extensions__item__id_tab_val_Extension_0), (u'presence', u'optional')])], rr=[], ev=None, er=[])
    ___RxTimingDeviationLCRInfo_iE_Extensions__item__id._const_tab = ____RxTimingDeviationLCRInfo_iE_Extensions__item__id_tab
    ___RxTimingDeviationLCRInfo_iE_Extensions__item__id._const_tab_at = None
    ___RxTimingDeviationLCRInfo_iE_Extensions__item__id._const_tab_id = u'id'
    ___RxTimingDeviationLCRInfo_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ___RxTimingDeviationLCRInfo_iE_Extensions__item__criticality._const_tab = ____RxTimingDeviationLCRInfo_iE_Extensions__item__id_tab
    ___RxTimingDeviationLCRInfo_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___RxTimingDeviationLCRInfo_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___RxTimingDeviationLCRInfo_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ___RxTimingDeviationLCRInfo_iE_Extensions__item__extensionValue._const_tab = ____RxTimingDeviationLCRInfo_iE_Extensions__item__id_tab
    ___RxTimingDeviationLCRInfo_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___RxTimingDeviationLCRInfo_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __RxTimingDeviationLCRInfo_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___RxTimingDeviationLCRInfo_iE_Extensions__item__id),
        (u'criticality', ___RxTimingDeviationLCRInfo_iE_Extensions__item__criticality),
        (u'extensionValue', ___RxTimingDeviationLCRInfo_iE_Extensions__item__extensionValue),
        ])
    __RxTimingDeviationLCRInfo_iE_Extensions__item_._ext = None
    _RxTimingDeviationLCRInfo_iE_Extensions._cont = __RxTimingDeviationLCRInfo_iE_Extensions__item_
    _RxTimingDeviationLCRInfo_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    RxTimingDeviationLCRInfo._cont = ASN1Dict([
        (u'rxTimingDeviationLCR', _RxTimingDeviationLCRInfo_rxTimingDeviationLCR),
        (u'timingAdvanceLCR', _RxTimingDeviationLCRInfo_timingAdvanceLCR),
        (u'iE-Extensions', _RxTimingDeviationLCRInfo_iE_Extensions),
        ])
    RxTimingDeviationLCRInfo._ext = []
    
    #-----< RxTimingDeviationLCRInfo-ExtIEs >-----#
    RxTimingDeviationLCRInfo_ExtIEs = CLASS(name=u'RxTimingDeviationLCRInfo-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _RxTimingDeviationLCRInfo_ExtIEs_val_Extension_0 = INT(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'ExtendedTimingAdvanceLCR')))
    RxTimingDeviationLCRInfo_ExtIEs._val = ASN1Set(rv=[dict([(u'id', 81), (u'criticality', u'ignore'), (u'Extension', _RxTimingDeviationLCRInfo_ExtIEs_val_Extension_0), (u'presence', u'optional')])], rr=[], ev=[], er=[])
    
    #-----< ExtendedTimingAdvanceLCR >-----#
    ExtendedTimingAdvanceLCR = INT(name=u'ExtendedTimingAdvanceLCR', mode=MODE_TYPE)
    ExtendedTimingAdvanceLCR._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=2048, ub=8191)], ev=None, er=[])
    
    #-----< RxTimingDeviation768Info >-----#
    RxTimingDeviation768Info = SEQ(name=u'RxTimingDeviation768Info', mode=MODE_TYPE)
    _RxTimingDeviation768Info_rxTimingDeviation768 = INT(name=u'rxTimingDeviation768', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'RxTimingDeviation768')))
    _RxTimingDeviation768Info_timingAdvance768 = INT(name=u'timingAdvance768', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'TimingAdvance768')))
    _RxTimingDeviation768Info_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __RxTimingDeviation768Info_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___RxTimingDeviation768Info_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____RxTimingDeviation768Info_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____RxTimingDeviation768Info_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___RxTimingDeviation768Info_iE_Extensions__item__id._const_tab = ____RxTimingDeviation768Info_iE_Extensions__item__id_tab
    ___RxTimingDeviation768Info_iE_Extensions__item__id._const_tab_at = None
    ___RxTimingDeviation768Info_iE_Extensions__item__id._const_tab_id = u'id'
    ___RxTimingDeviation768Info_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____RxTimingDeviation768Info_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____RxTimingDeviation768Info_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___RxTimingDeviation768Info_iE_Extensions__item__criticality._const_tab = ____RxTimingDeviation768Info_iE_Extensions__item__criticality_tab
    ___RxTimingDeviation768Info_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___RxTimingDeviation768Info_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___RxTimingDeviation768Info_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____RxTimingDeviation768Info_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____RxTimingDeviation768Info_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___RxTimingDeviation768Info_iE_Extensions__item__extensionValue._const_tab = ____RxTimingDeviation768Info_iE_Extensions__item__extensionValue_tab
    ___RxTimingDeviation768Info_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___RxTimingDeviation768Info_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __RxTimingDeviation768Info_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___RxTimingDeviation768Info_iE_Extensions__item__id),
        (u'criticality', ___RxTimingDeviation768Info_iE_Extensions__item__criticality),
        (u'extensionValue', ___RxTimingDeviation768Info_iE_Extensions__item__extensionValue),
        ])
    __RxTimingDeviation768Info_iE_Extensions__item_._ext = None
    _RxTimingDeviation768Info_iE_Extensions._cont = __RxTimingDeviation768Info_iE_Extensions__item_
    _RxTimingDeviation768Info_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    RxTimingDeviation768Info._cont = ASN1Dict([
        (u'rxTimingDeviation768', _RxTimingDeviation768Info_rxTimingDeviation768),
        (u'timingAdvance768', _RxTimingDeviation768Info_timingAdvance768),
        (u'iE-Extensions', _RxTimingDeviation768Info_iE_Extensions),
        ])
    RxTimingDeviation768Info._ext = []
    
    #-----< RxTimingDeviation768Info-ExtIEs >-----#
    RxTimingDeviation768Info_ExtIEs = CLASS(name=u'RxTimingDeviation768Info-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    RxTimingDeviation768Info_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< RxTimingDeviation384extInfo >-----#
    RxTimingDeviation384extInfo = SEQ(name=u'RxTimingDeviation384extInfo', mode=MODE_TYPE)
    _RxTimingDeviation384extInfo_rxTimingDeviation384ext = INT(name=u'rxTimingDeviation384ext', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'RxTimingDeviation384ext')))
    _RxTimingDeviation384extInfo_timingAdvance384ext = INT(name=u'timingAdvance384ext', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'TimingAdvance384ext')))
    _RxTimingDeviation384extInfo_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __RxTimingDeviation384extInfo_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___RxTimingDeviation384extInfo_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____RxTimingDeviation384extInfo_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____RxTimingDeviation384extInfo_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___RxTimingDeviation384extInfo_iE_Extensions__item__id._const_tab = ____RxTimingDeviation384extInfo_iE_Extensions__item__id_tab
    ___RxTimingDeviation384extInfo_iE_Extensions__item__id._const_tab_at = None
    ___RxTimingDeviation384extInfo_iE_Extensions__item__id._const_tab_id = u'id'
    ___RxTimingDeviation384extInfo_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____RxTimingDeviation384extInfo_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____RxTimingDeviation384extInfo_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___RxTimingDeviation384extInfo_iE_Extensions__item__criticality._const_tab = ____RxTimingDeviation384extInfo_iE_Extensions__item__criticality_tab
    ___RxTimingDeviation384extInfo_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___RxTimingDeviation384extInfo_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___RxTimingDeviation384extInfo_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____RxTimingDeviation384extInfo_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____RxTimingDeviation384extInfo_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___RxTimingDeviation384extInfo_iE_Extensions__item__extensionValue._const_tab = ____RxTimingDeviation384extInfo_iE_Extensions__item__extensionValue_tab
    ___RxTimingDeviation384extInfo_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___RxTimingDeviation384extInfo_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __RxTimingDeviation384extInfo_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___RxTimingDeviation384extInfo_iE_Extensions__item__id),
        (u'criticality', ___RxTimingDeviation384extInfo_iE_Extensions__item__criticality),
        (u'extensionValue', ___RxTimingDeviation384extInfo_iE_Extensions__item__extensionValue),
        ])
    __RxTimingDeviation384extInfo_iE_Extensions__item_._ext = None
    _RxTimingDeviation384extInfo_iE_Extensions._cont = __RxTimingDeviation384extInfo_iE_Extensions__item_
    _RxTimingDeviation384extInfo_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    RxTimingDeviation384extInfo._cont = ASN1Dict([
        (u'rxTimingDeviation384ext', _RxTimingDeviation384extInfo_rxTimingDeviation384ext),
        (u'timingAdvance384ext', _RxTimingDeviation384extInfo_timingAdvance384ext),
        (u'iE-Extensions', _RxTimingDeviation384extInfo_iE_Extensions),
        ])
    RxTimingDeviation384extInfo._ext = []
    
    #-----< RxTimingDeviation384extInfo-ExtIEs >-----#
    RxTimingDeviation384extInfo_ExtIEs = CLASS(name=u'RxTimingDeviation384extInfo-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    RxTimingDeviation384extInfo_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< AddMeasurementInfo >-----#
    AddMeasurementInfo = SEQ(name=u'AddMeasurementInfo', mode=MODE_TYPE)
    _AddMeasurementInfo_cpich_RSCP = INT(name=u'cpich-RSCP', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'CPICH-RSCP')), opt=True)
    _AddMeasurementInfo_cpich_EcNo = INT(name=u'cpich-EcNo', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'CPICH-EcNo')), opt=True)
    _AddMeasurementInfo_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __AddMeasurementInfo_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___AddMeasurementInfo_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____AddMeasurementInfo_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____AddMeasurementInfo_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___AddMeasurementInfo_iE_Extensions__item__id._const_tab = ____AddMeasurementInfo_iE_Extensions__item__id_tab
    ___AddMeasurementInfo_iE_Extensions__item__id._const_tab_at = None
    ___AddMeasurementInfo_iE_Extensions__item__id._const_tab_id = u'id'
    ___AddMeasurementInfo_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____AddMeasurementInfo_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____AddMeasurementInfo_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___AddMeasurementInfo_iE_Extensions__item__criticality._const_tab = ____AddMeasurementInfo_iE_Extensions__item__criticality_tab
    ___AddMeasurementInfo_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___AddMeasurementInfo_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___AddMeasurementInfo_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____AddMeasurementInfo_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____AddMeasurementInfo_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___AddMeasurementInfo_iE_Extensions__item__extensionValue._const_tab = ____AddMeasurementInfo_iE_Extensions__item__extensionValue_tab
    ___AddMeasurementInfo_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___AddMeasurementInfo_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __AddMeasurementInfo_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___AddMeasurementInfo_iE_Extensions__item__id),
        (u'criticality', ___AddMeasurementInfo_iE_Extensions__item__criticality),
        (u'extensionValue', ___AddMeasurementInfo_iE_Extensions__item__extensionValue),
        ])
    __AddMeasurementInfo_iE_Extensions__item_._ext = None
    _AddMeasurementInfo_iE_Extensions._cont = __AddMeasurementInfo_iE_Extensions__item_
    _AddMeasurementInfo_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    AddMeasurementInfo._cont = ASN1Dict([
        (u'cpich-RSCP', _AddMeasurementInfo_cpich_RSCP),
        (u'cpich-EcNo', _AddMeasurementInfo_cpich_EcNo),
        (u'iE-Extensions', _AddMeasurementInfo_iE_Extensions),
        ])
    AddMeasurementInfo._ext = []
    
    #-----< AddMeasurementInfo-ExtIEs >-----#
    AddMeasurementInfo_ExtIEs = CLASS(name=u'AddMeasurementInfo-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    AddMeasurementInfo_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< AngleOfArrivalLCR >-----#
    AngleOfArrivalLCR = SEQ(name=u'AngleOfArrivalLCR', mode=MODE_TYPE)
    _AngleOfArrivalLCR_aOA_LCR = INT(name=u'aOA-LCR', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'AOA-LCR')))
    _AngleOfArrivalLCR_aOA_LCR_Accuracy_Class = ENUM(name=u'aOA-LCR-Accuracy-Class', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'AOA-LCR-Accuracy-Class')))
    _AngleOfArrivalLCR_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __AngleOfArrivalLCR_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___AngleOfArrivalLCR_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____AngleOfArrivalLCR_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____AngleOfArrivalLCR_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___AngleOfArrivalLCR_iE_Extensions__item__id._const_tab = ____AngleOfArrivalLCR_iE_Extensions__item__id_tab
    ___AngleOfArrivalLCR_iE_Extensions__item__id._const_tab_at = None
    ___AngleOfArrivalLCR_iE_Extensions__item__id._const_tab_id = u'id'
    ___AngleOfArrivalLCR_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____AngleOfArrivalLCR_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____AngleOfArrivalLCR_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___AngleOfArrivalLCR_iE_Extensions__item__criticality._const_tab = ____AngleOfArrivalLCR_iE_Extensions__item__criticality_tab
    ___AngleOfArrivalLCR_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___AngleOfArrivalLCR_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___AngleOfArrivalLCR_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____AngleOfArrivalLCR_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____AngleOfArrivalLCR_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___AngleOfArrivalLCR_iE_Extensions__item__extensionValue._const_tab = ____AngleOfArrivalLCR_iE_Extensions__item__extensionValue_tab
    ___AngleOfArrivalLCR_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___AngleOfArrivalLCR_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __AngleOfArrivalLCR_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___AngleOfArrivalLCR_iE_Extensions__item__id),
        (u'criticality', ___AngleOfArrivalLCR_iE_Extensions__item__criticality),
        (u'extensionValue', ___AngleOfArrivalLCR_iE_Extensions__item__extensionValue),
        ])
    __AngleOfArrivalLCR_iE_Extensions__item_._ext = None
    _AngleOfArrivalLCR_iE_Extensions._cont = __AngleOfArrivalLCR_iE_Extensions__item_
    _AngleOfArrivalLCR_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    AngleOfArrivalLCR._cont = ASN1Dict([
        (u'aOA-LCR', _AngleOfArrivalLCR_aOA_LCR),
        (u'aOA-LCR-Accuracy-Class', _AngleOfArrivalLCR_aOA_LCR_Accuracy_Class),
        (u'iE-Extensions', _AngleOfArrivalLCR_iE_Extensions),
        ])
    AngleOfArrivalLCR._ext = []
    
    #-----< AngleOfArrivalLCR-ExtIEs >-----#
    AngleOfArrivalLCR_ExtIEs = CLASS(name=u'AngleOfArrivalLCR-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    AngleOfArrivalLCR_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< RxTimingDeviation >-----#
    RxTimingDeviation = INT(name=u'RxTimingDeviation', mode=MODE_TYPE)
    RxTimingDeviation._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=8191)], ev=None, er=[])
    
    #-----< RxTimingDeviationLCR >-----#
    RxTimingDeviationLCR = INT(name=u'RxTimingDeviationLCR', mode=MODE_TYPE)
    RxTimingDeviationLCR._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=511)], ev=None, er=[])
    
    #-----< RxTimingDeviation768 >-----#
    RxTimingDeviation768 = INT(name=u'RxTimingDeviation768', mode=MODE_TYPE)
    RxTimingDeviation768._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    
    #-----< RxTimingDeviation384ext >-----#
    RxTimingDeviation384ext = INT(name=u'RxTimingDeviation384ext', mode=MODE_TYPE)
    RxTimingDeviation384ext._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=32767)], ev=None, er=[])
    
    #-----< TimingAdvance >-----#
    TimingAdvance = INT(name=u'TimingAdvance', mode=MODE_TYPE)
    TimingAdvance._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    
    #-----< TimingAdvanceLCR >-----#
    TimingAdvanceLCR = INT(name=u'TimingAdvanceLCR', mode=MODE_TYPE)
    TimingAdvanceLCR._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=2047)], ev=None, er=[])
    
    #-----< TimingAdvance768 >-----#
    TimingAdvance768 = INT(name=u'TimingAdvance768', mode=MODE_TYPE)
    TimingAdvance768._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=511)], ev=None, er=[])
    
    #-----< TimingAdvance384ext >-----#
    TimingAdvance384ext = INT(name=u'TimingAdvance384ext', mode=MODE_TYPE)
    TimingAdvance384ext._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    
    #-----< Pathloss >-----#
    Pathloss = INT(name=u'Pathloss', mode=MODE_TYPE)
    Pathloss._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=46, ub=158)], ev=None, er=[])
    
    #-----< CPICH-EcNo >-----#
    CPICH_EcNo = INT(name=u'CPICH-EcNo', mode=MODE_TYPE)
    CPICH_EcNo._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=49)], ev=None, er=[])
    
    #-----< CPICH-RSCP >-----#
    CPICH_RSCP = INT(name=u'CPICH-RSCP', mode=MODE_TYPE)
    CPICH_RSCP._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-5, ub=91)], ev=None, er=[])
    
    #-----< AOA-LCR >-----#
    AOA_LCR = INT(name=u'AOA-LCR', mode=MODE_TYPE)
    AOA_LCR._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=719)], ev=None, er=[])
    
    #-----< AOA-LCR-Accuracy-Class >-----#
    AOA_LCR_Accuracy_Class = ENUM(name=u'AOA-LCR-Accuracy-Class', mode=MODE_TYPE)
    AOA_LCR_Accuracy_Class._cont = ASN1Dict([(u'a', 0), (u'b', 1), (u'c', 2), (u'd', 3), (u'e', 4), (u'f', 5), (u'g', 6), (u'h', 7)])
    AOA_LCR_Accuracy_Class._ext = []
    
    #-----< CellId-IRATMeasuredResultsSets >-----#
    CellId_IRATMeasuredResultsSets = SEQ_OF(name=u'CellId-IRATMeasuredResultsSets', mode=MODE_TYPE)
    _CellId_IRATMeasuredResultsSets__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'CellId-IRATMeasuredResultsInfoList')))
    CellId_IRATMeasuredResultsSets._cont = _CellId_IRATMeasuredResultsSets__item_
    CellId_IRATMeasuredResultsSets._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    
    #-----< CellId-IRATMeasuredResultsInfoList >-----#
    CellId_IRATMeasuredResultsInfoList = SEQ(name=u'CellId-IRATMeasuredResultsInfoList', mode=MODE_TYPE)
    _CellId_IRATMeasuredResultsInfoList_gERAN_MeasuredResultsInfoList = SEQ_OF(name=u'gERAN-MeasuredResultsInfoList', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GERAN-MeasuredResultsInfoList')), opt=True)
    _CellId_IRATMeasuredResultsInfoList_iE_Extenstions = SEQ_OF(name=u'iE-Extenstions', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __CellId_IRATMeasuredResultsInfoList_iE_Extenstions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___CellId_IRATMeasuredResultsInfoList_iE_Extenstions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____CellId_IRATMeasuredResultsInfoList_iE_Extenstions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____CellId_IRATMeasuredResultsInfoList_iE_Extenstions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___CellId_IRATMeasuredResultsInfoList_iE_Extenstions__item__id._const_tab = ____CellId_IRATMeasuredResultsInfoList_iE_Extenstions__item__id_tab
    ___CellId_IRATMeasuredResultsInfoList_iE_Extenstions__item__id._const_tab_at = None
    ___CellId_IRATMeasuredResultsInfoList_iE_Extenstions__item__id._const_tab_id = u'id'
    ___CellId_IRATMeasuredResultsInfoList_iE_Extenstions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____CellId_IRATMeasuredResultsInfoList_iE_Extenstions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____CellId_IRATMeasuredResultsInfoList_iE_Extenstions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___CellId_IRATMeasuredResultsInfoList_iE_Extenstions__item__criticality._const_tab = ____CellId_IRATMeasuredResultsInfoList_iE_Extenstions__item__criticality_tab
    ___CellId_IRATMeasuredResultsInfoList_iE_Extenstions__item__criticality._const_tab_at = ('..', u'id')
    ___CellId_IRATMeasuredResultsInfoList_iE_Extenstions__item__criticality._const_tab_id = u'criticality'
    ___CellId_IRATMeasuredResultsInfoList_iE_Extenstions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____CellId_IRATMeasuredResultsInfoList_iE_Extenstions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____CellId_IRATMeasuredResultsInfoList_iE_Extenstions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___CellId_IRATMeasuredResultsInfoList_iE_Extenstions__item__extensionValue._const_tab = ____CellId_IRATMeasuredResultsInfoList_iE_Extenstions__item__extensionValue_tab
    ___CellId_IRATMeasuredResultsInfoList_iE_Extenstions__item__extensionValue._const_tab_at = ('..', u'id')
    ___CellId_IRATMeasuredResultsInfoList_iE_Extenstions__item__extensionValue._const_tab_id = u'Extension'
    __CellId_IRATMeasuredResultsInfoList_iE_Extenstions__item_._cont = ASN1Dict([
        (u'id', ___CellId_IRATMeasuredResultsInfoList_iE_Extenstions__item__id),
        (u'criticality', ___CellId_IRATMeasuredResultsInfoList_iE_Extenstions__item__criticality),
        (u'extensionValue', ___CellId_IRATMeasuredResultsInfoList_iE_Extenstions__item__extensionValue),
        ])
    __CellId_IRATMeasuredResultsInfoList_iE_Extenstions__item_._ext = None
    _CellId_IRATMeasuredResultsInfoList_iE_Extenstions._cont = __CellId_IRATMeasuredResultsInfoList_iE_Extenstions__item_
    _CellId_IRATMeasuredResultsInfoList_iE_Extenstions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    CellId_IRATMeasuredResultsInfoList._cont = ASN1Dict([
        (u'gERAN-MeasuredResultsInfoList', _CellId_IRATMeasuredResultsInfoList_gERAN_MeasuredResultsInfoList),
        (u'iE-Extenstions', _CellId_IRATMeasuredResultsInfoList_iE_Extenstions),
        ])
    CellId_IRATMeasuredResultsInfoList._ext = []
    
    #-----< CellId-IRATMeasuredResultsInfoListExtIEs >-----#
    CellId_IRATMeasuredResultsInfoListExtIEs = CLASS(name=u'CellId-IRATMeasuredResultsInfoListExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    CellId_IRATMeasuredResultsInfoListExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GERAN-MeasuredResultsInfoList >-----#
    GERAN_MeasuredResultsInfoList = SEQ_OF(name=u'GERAN-MeasuredResultsInfoList', mode=MODE_TYPE)
    _GERAN_MeasuredResultsInfoList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GERAN-MeasuredResultsInfo')))
    GERAN_MeasuredResultsInfoList._cont = _GERAN_MeasuredResultsInfoList__item_
    GERAN_MeasuredResultsInfoList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=6)], ev=None, er=[])
    
    #-----< GERAN-MeasuredResultsInfo >-----#
    GERAN_MeasuredResultsInfo = SEQ(name=u'GERAN-MeasuredResultsInfo', mode=MODE_TYPE)
    _GERAN_MeasuredResultsInfo_gERANCellID = SEQ(name=u'gERANCellID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GERANCellGlobalID')), opt=True)
    _GERAN_MeasuredResultsInfo_gERANPhysicalCellID = SEQ(name=u'gERANPhysicalCellID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GERANPhysicalCellID')))
    _GERAN_MeasuredResultsInfo_gSM_RSSI = INT(name=u'gSM-RSSI', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GSM-RSSI')))
    _GERAN_MeasuredResultsInfo_iE_Extenstions = SEQ_OF(name=u'iE-Extenstions', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GERAN_MeasuredResultsInfo_iE_Extenstions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GERAN_MeasuredResultsInfo_iE_Extenstions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GERAN_MeasuredResultsInfo_iE_Extenstions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GERAN_MeasuredResultsInfo_iE_Extenstions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GERAN_MeasuredResultsInfo_iE_Extenstions__item__id._const_tab = ____GERAN_MeasuredResultsInfo_iE_Extenstions__item__id_tab
    ___GERAN_MeasuredResultsInfo_iE_Extenstions__item__id._const_tab_at = None
    ___GERAN_MeasuredResultsInfo_iE_Extenstions__item__id._const_tab_id = u'id'
    ___GERAN_MeasuredResultsInfo_iE_Extenstions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GERAN_MeasuredResultsInfo_iE_Extenstions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GERAN_MeasuredResultsInfo_iE_Extenstions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GERAN_MeasuredResultsInfo_iE_Extenstions__item__criticality._const_tab = ____GERAN_MeasuredResultsInfo_iE_Extenstions__item__criticality_tab
    ___GERAN_MeasuredResultsInfo_iE_Extenstions__item__criticality._const_tab_at = ('..', u'id')
    ___GERAN_MeasuredResultsInfo_iE_Extenstions__item__criticality._const_tab_id = u'criticality'
    ___GERAN_MeasuredResultsInfo_iE_Extenstions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GERAN_MeasuredResultsInfo_iE_Extenstions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GERAN_MeasuredResultsInfo_iE_Extenstions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GERAN_MeasuredResultsInfo_iE_Extenstions__item__extensionValue._const_tab = ____GERAN_MeasuredResultsInfo_iE_Extenstions__item__extensionValue_tab
    ___GERAN_MeasuredResultsInfo_iE_Extenstions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GERAN_MeasuredResultsInfo_iE_Extenstions__item__extensionValue._const_tab_id = u'Extension'
    __GERAN_MeasuredResultsInfo_iE_Extenstions__item_._cont = ASN1Dict([
        (u'id', ___GERAN_MeasuredResultsInfo_iE_Extenstions__item__id),
        (u'criticality', ___GERAN_MeasuredResultsInfo_iE_Extenstions__item__criticality),
        (u'extensionValue', ___GERAN_MeasuredResultsInfo_iE_Extenstions__item__extensionValue),
        ])
    __GERAN_MeasuredResultsInfo_iE_Extenstions__item_._ext = None
    _GERAN_MeasuredResultsInfo_iE_Extenstions._cont = __GERAN_MeasuredResultsInfo_iE_Extenstions__item_
    _GERAN_MeasuredResultsInfo_iE_Extenstions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GERAN_MeasuredResultsInfo._cont = ASN1Dict([
        (u'gERANCellID', _GERAN_MeasuredResultsInfo_gERANCellID),
        (u'gERANPhysicalCellID', _GERAN_MeasuredResultsInfo_gERANPhysicalCellID),
        (u'gSM-RSSI', _GERAN_MeasuredResultsInfo_gSM_RSSI),
        (u'iE-Extenstions', _GERAN_MeasuredResultsInfo_iE_Extenstions),
        ])
    GERAN_MeasuredResultsInfo._ext = []
    
    #-----< GERAN-MeasuredResultsInfo-ExtIEs >-----#
    GERAN_MeasuredResultsInfo_ExtIEs = CLASS(name=u'GERAN-MeasuredResultsInfo-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GERAN_MeasuredResultsInfo_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GERANCellGlobalID >-----#
    GERANCellGlobalID = SEQ(name=u'GERANCellGlobalID', mode=MODE_TYPE)
    _GERANCellGlobalID_plmn_Identity = OCT_STR(name=u'plmn-Identity', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'PLMN-Identity')))
    _GERANCellGlobalID_locationAreaCode = BIT_STR(name=u'locationAreaCode', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GERANCellGlobalID_locationAreaCode._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _GERANCellGlobalID_cellIdentity = BIT_STR(name=u'cellIdentity', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GERANCellGlobalID_cellIdentity._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _GERANCellGlobalID_iE_Extenstions = SEQ_OF(name=u'iE-Extenstions', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GERANCellGlobalID_iE_Extenstions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GERANCellGlobalID_iE_Extenstions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GERANCellGlobalID_iE_Extenstions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GERANCellGlobalID_iE_Extenstions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GERANCellGlobalID_iE_Extenstions__item__id._const_tab = ____GERANCellGlobalID_iE_Extenstions__item__id_tab
    ___GERANCellGlobalID_iE_Extenstions__item__id._const_tab_at = None
    ___GERANCellGlobalID_iE_Extenstions__item__id._const_tab_id = u'id'
    ___GERANCellGlobalID_iE_Extenstions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GERANCellGlobalID_iE_Extenstions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GERANCellGlobalID_iE_Extenstions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GERANCellGlobalID_iE_Extenstions__item__criticality._const_tab = ____GERANCellGlobalID_iE_Extenstions__item__criticality_tab
    ___GERANCellGlobalID_iE_Extenstions__item__criticality._const_tab_at = ('..', u'id')
    ___GERANCellGlobalID_iE_Extenstions__item__criticality._const_tab_id = u'criticality'
    ___GERANCellGlobalID_iE_Extenstions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GERANCellGlobalID_iE_Extenstions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GERANCellGlobalID_iE_Extenstions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GERANCellGlobalID_iE_Extenstions__item__extensionValue._const_tab = ____GERANCellGlobalID_iE_Extenstions__item__extensionValue_tab
    ___GERANCellGlobalID_iE_Extenstions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GERANCellGlobalID_iE_Extenstions__item__extensionValue._const_tab_id = u'Extension'
    __GERANCellGlobalID_iE_Extenstions__item_._cont = ASN1Dict([
        (u'id', ___GERANCellGlobalID_iE_Extenstions__item__id),
        (u'criticality', ___GERANCellGlobalID_iE_Extenstions__item__criticality),
        (u'extensionValue', ___GERANCellGlobalID_iE_Extenstions__item__extensionValue),
        ])
    __GERANCellGlobalID_iE_Extenstions__item_._ext = None
    _GERANCellGlobalID_iE_Extenstions._cont = __GERANCellGlobalID_iE_Extenstions__item_
    _GERANCellGlobalID_iE_Extenstions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GERANCellGlobalID._cont = ASN1Dict([
        (u'plmn-Identity', _GERANCellGlobalID_plmn_Identity),
        (u'locationAreaCode', _GERANCellGlobalID_locationAreaCode),
        (u'cellIdentity', _GERANCellGlobalID_cellIdentity),
        (u'iE-Extenstions', _GERANCellGlobalID_iE_Extenstions),
        ])
    GERANCellGlobalID._ext = []
    
    #-----< GERANCellGlobalID-ExtIEs >-----#
    GERANCellGlobalID_ExtIEs = CLASS(name=u'GERANCellGlobalID-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GERANCellGlobalID_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< PLMN-Identity >-----#
    PLMN_Identity = OCT_STR(name=u'PLMN-Identity', mode=MODE_TYPE)
    PLMN_Identity._const_sz = ASN1Set(rv=[3], rr=[], ev=None, er=[])
    
    #-----< GSM-RSSI >-----#
    GSM_RSSI = INT(name=u'GSM-RSSI', mode=MODE_TYPE)
    GSM_RSSI._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    
    #-----< GERANPhysicalCellID >-----#
    GERANPhysicalCellID = SEQ(name=u'GERANPhysicalCellID', mode=MODE_TYPE)
    _GERANPhysicalCellID_bsic = SEQ(name=u'bsic', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GSM-BSIC')))
    _GERANPhysicalCellID_arfcn = INT(name=u'arfcn', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GSM-BCCH-ARFCN')))
    GERANPhysicalCellID._cont = ASN1Dict([
        (u'bsic', _GERANPhysicalCellID_bsic),
        (u'arfcn', _GERANPhysicalCellID_arfcn),
        ])
    GERANPhysicalCellID._ext = None
    
    #-----< GSM-BSIC >-----#
    GSM_BSIC = SEQ(name=u'GSM-BSIC', mode=MODE_TYPE)
    _GSM_BSIC_networkColourCode = BIT_STR(name=u'networkColourCode', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GSM_BSIC_networkColourCode._const_sz = ASN1Set(rv=[3], rr=[], ev=None, er=[])
    _GSM_BSIC_baseStationColourCode = BIT_STR(name=u'baseStationColourCode', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GSM_BSIC_baseStationColourCode._const_sz = ASN1Set(rv=[3], rr=[], ev=None, er=[])
    GSM_BSIC._cont = ASN1Dict([
        (u'networkColourCode', _GSM_BSIC_networkColourCode),
        (u'baseStationColourCode', _GSM_BSIC_baseStationColourCode),
        ])
    GSM_BSIC._ext = None
    
    #-----< GSM-BCCH-ARFCN >-----#
    GSM_BCCH_ARFCN = INT(name=u'GSM-BCCH-ARFCN', mode=MODE_TYPE)
    GSM_BCCH_ARFCN._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=1023)], ev=None, er=[])
    
    #-----< CellIDPositioning >-----#
    CellIDPositioning = SEQ(name=u'CellIDPositioning', mode=MODE_TYPE)
    _CellIDPositioning_requestedCellIDMeasurements = CHOICE(name=u'requestedCellIDMeasurements', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'RequestedCellIDMeasurements')))
    _CellIDPositioning_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __CellIDPositioning_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___CellIDPositioning_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____CellIDPositioning_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____CellIDPositioning_iE_Extensions__item__id_tab_val_Extension_0 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'RequestedCellIDGERANMeasurements')))
    ____CellIDPositioning_iE_Extensions__item__id_tab._val = ASN1Set(rv=[dict([(u'id', 124), (u'criticality', u'reject'), (u'Extension', _____CellIDPositioning_iE_Extensions__item__id_tab_val_Extension_0), (u'presence', u'optional')])], rr=[], ev=None, er=[])
    ___CellIDPositioning_iE_Extensions__item__id._const_tab = ____CellIDPositioning_iE_Extensions__item__id_tab
    ___CellIDPositioning_iE_Extensions__item__id._const_tab_at = None
    ___CellIDPositioning_iE_Extensions__item__id._const_tab_id = u'id'
    ___CellIDPositioning_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ___CellIDPositioning_iE_Extensions__item__criticality._const_tab = ____CellIDPositioning_iE_Extensions__item__id_tab
    ___CellIDPositioning_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___CellIDPositioning_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___CellIDPositioning_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ___CellIDPositioning_iE_Extensions__item__extensionValue._const_tab = ____CellIDPositioning_iE_Extensions__item__id_tab
    ___CellIDPositioning_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___CellIDPositioning_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __CellIDPositioning_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___CellIDPositioning_iE_Extensions__item__id),
        (u'criticality', ___CellIDPositioning_iE_Extensions__item__criticality),
        (u'extensionValue', ___CellIDPositioning_iE_Extensions__item__extensionValue),
        ])
    __CellIDPositioning_iE_Extensions__item_._ext = None
    _CellIDPositioning_iE_Extensions._cont = __CellIDPositioning_iE_Extensions__item_
    _CellIDPositioning_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    CellIDPositioning._cont = ASN1Dict([
        (u'requestedCellIDMeasurements', _CellIDPositioning_requestedCellIDMeasurements),
        (u'iE-Extensions', _CellIDPositioning_iE_Extensions),
        ])
    CellIDPositioning._ext = []
    
    #-----< CellIDPositioning-ExtIEs >-----#
    CellIDPositioning_ExtIEs = CLASS(name=u'CellIDPositioning-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _CellIDPositioning_ExtIEs_val_Extension_0 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'RequestedCellIDGERANMeasurements')))
    CellIDPositioning_ExtIEs._val = ASN1Set(rv=[dict([(u'id', 124), (u'criticality', u'reject'), (u'Extension', _CellIDPositioning_ExtIEs_val_Extension_0), (u'presence', u'optional')])], rr=[], ev=[], er=[])
    
    #-----< RequestedCellIDMeasurements >-----#
    RequestedCellIDMeasurements = CHOICE(name=u'RequestedCellIDMeasurements', mode=MODE_TYPE)
    _RequestedCellIDMeasurements_fdd = SEQ(name=u'fdd', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __RequestedCellIDMeasurements_fdd_roundTripTimeInfoWanted = BOOL(name=u'roundTripTimeInfoWanted', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __RequestedCellIDMeasurements_fdd_pathlossWanted = BOOL(name=u'pathlossWanted', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __RequestedCellIDMeasurements_fdd_roundTripTimeInfoWithType1Wanted = BOOL(name=u'roundTripTimeInfoWithType1Wanted', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __RequestedCellIDMeasurements_fdd_cpichRSCPWanted = BOOL(name=u'cpichRSCPWanted', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __RequestedCellIDMeasurements_fdd_cpicEcNoWanted = BOOL(name=u'cpicEcNoWanted', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __RequestedCellIDMeasurements_fdd_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    ___RequestedCellIDMeasurements_fdd_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ____RequestedCellIDMeasurements_fdd_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    _____RequestedCellIDMeasurements_fdd_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____RequestedCellIDMeasurements_fdd_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____RequestedCellIDMeasurements_fdd_iE_Extensions__item__id._const_tab = _____RequestedCellIDMeasurements_fdd_iE_Extensions__item__id_tab
    ____RequestedCellIDMeasurements_fdd_iE_Extensions__item__id._const_tab_at = None
    ____RequestedCellIDMeasurements_fdd_iE_Extensions__item__id._const_tab_id = u'id'
    ____RequestedCellIDMeasurements_fdd_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    _____RequestedCellIDMeasurements_fdd_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____RequestedCellIDMeasurements_fdd_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____RequestedCellIDMeasurements_fdd_iE_Extensions__item__criticality._const_tab = _____RequestedCellIDMeasurements_fdd_iE_Extensions__item__criticality_tab
    ____RequestedCellIDMeasurements_fdd_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ____RequestedCellIDMeasurements_fdd_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ____RequestedCellIDMeasurements_fdd_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    _____RequestedCellIDMeasurements_fdd_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____RequestedCellIDMeasurements_fdd_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____RequestedCellIDMeasurements_fdd_iE_Extensions__item__extensionValue._const_tab = _____RequestedCellIDMeasurements_fdd_iE_Extensions__item__extensionValue_tab
    ____RequestedCellIDMeasurements_fdd_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ____RequestedCellIDMeasurements_fdd_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    ___RequestedCellIDMeasurements_fdd_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ____RequestedCellIDMeasurements_fdd_iE_Extensions__item__id),
        (u'criticality', ____RequestedCellIDMeasurements_fdd_iE_Extensions__item__criticality),
        (u'extensionValue', ____RequestedCellIDMeasurements_fdd_iE_Extensions__item__extensionValue),
        ])
    ___RequestedCellIDMeasurements_fdd_iE_Extensions__item_._ext = None
    __RequestedCellIDMeasurements_fdd_iE_Extensions._cont = ___RequestedCellIDMeasurements_fdd_iE_Extensions__item_
    __RequestedCellIDMeasurements_fdd_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    _RequestedCellIDMeasurements_fdd._cont = ASN1Dict([
        (u'roundTripTimeInfoWanted', __RequestedCellIDMeasurements_fdd_roundTripTimeInfoWanted),
        (u'pathlossWanted', __RequestedCellIDMeasurements_fdd_pathlossWanted),
        (u'roundTripTimeInfoWithType1Wanted', __RequestedCellIDMeasurements_fdd_roundTripTimeInfoWithType1Wanted),
        (u'cpichRSCPWanted', __RequestedCellIDMeasurements_fdd_cpichRSCPWanted),
        (u'cpicEcNoWanted', __RequestedCellIDMeasurements_fdd_cpicEcNoWanted),
        (u'iE-Extensions', __RequestedCellIDMeasurements_fdd_iE_Extensions),
        ])
    _RequestedCellIDMeasurements_fdd._ext = []
    _RequestedCellIDMeasurements_tdd = SEQ(name=u'tdd', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __RequestedCellIDMeasurements_tdd_rxTimingDeviationInfoWanted = BOOL(name=u'rxTimingDeviationInfoWanted', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __RequestedCellIDMeasurements_tdd_pathlossWanted = BOOL(name=u'pathlossWanted', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __RequestedCellIDMeasurements_tdd_rxTimingDeviationLCRInfoWanted = BOOL(name=u'rxTimingDeviationLCRInfoWanted', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __RequestedCellIDMeasurements_tdd_rxTimingDeviation768InfoWanted = BOOL(name=u'rxTimingDeviation768InfoWanted', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __RequestedCellIDMeasurements_tdd_rxTimingDeviation384extInfoWanted = BOOL(name=u'rxTimingDeviation384extInfoWanted', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __RequestedCellIDMeasurements_tdd_angleOfArrivalLCRWanted = BOOL(name=u'angleOfArrivalLCRWanted', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __RequestedCellIDMeasurements_tdd_timingAdvanceLCRWanted = BOOL(name=u'timingAdvanceLCRWanted', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __RequestedCellIDMeasurements_tdd_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    ___RequestedCellIDMeasurements_tdd_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ____RequestedCellIDMeasurements_tdd_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    _____RequestedCellIDMeasurements_tdd_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____RequestedCellIDMeasurements_tdd_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____RequestedCellIDMeasurements_tdd_iE_Extensions__item__id._const_tab = _____RequestedCellIDMeasurements_tdd_iE_Extensions__item__id_tab
    ____RequestedCellIDMeasurements_tdd_iE_Extensions__item__id._const_tab_at = None
    ____RequestedCellIDMeasurements_tdd_iE_Extensions__item__id._const_tab_id = u'id'
    ____RequestedCellIDMeasurements_tdd_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    _____RequestedCellIDMeasurements_tdd_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____RequestedCellIDMeasurements_tdd_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____RequestedCellIDMeasurements_tdd_iE_Extensions__item__criticality._const_tab = _____RequestedCellIDMeasurements_tdd_iE_Extensions__item__criticality_tab
    ____RequestedCellIDMeasurements_tdd_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ____RequestedCellIDMeasurements_tdd_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ____RequestedCellIDMeasurements_tdd_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    _____RequestedCellIDMeasurements_tdd_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____RequestedCellIDMeasurements_tdd_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____RequestedCellIDMeasurements_tdd_iE_Extensions__item__extensionValue._const_tab = _____RequestedCellIDMeasurements_tdd_iE_Extensions__item__extensionValue_tab
    ____RequestedCellIDMeasurements_tdd_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ____RequestedCellIDMeasurements_tdd_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    ___RequestedCellIDMeasurements_tdd_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ____RequestedCellIDMeasurements_tdd_iE_Extensions__item__id),
        (u'criticality', ____RequestedCellIDMeasurements_tdd_iE_Extensions__item__criticality),
        (u'extensionValue', ____RequestedCellIDMeasurements_tdd_iE_Extensions__item__extensionValue),
        ])
    ___RequestedCellIDMeasurements_tdd_iE_Extensions__item_._ext = None
    __RequestedCellIDMeasurements_tdd_iE_Extensions._cont = ___RequestedCellIDMeasurements_tdd_iE_Extensions__item_
    __RequestedCellIDMeasurements_tdd_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    _RequestedCellIDMeasurements_tdd._cont = ASN1Dict([
        (u'rxTimingDeviationInfoWanted', __RequestedCellIDMeasurements_tdd_rxTimingDeviationInfoWanted),
        (u'pathlossWanted', __RequestedCellIDMeasurements_tdd_pathlossWanted),
        (u'rxTimingDeviationLCRInfoWanted', __RequestedCellIDMeasurements_tdd_rxTimingDeviationLCRInfoWanted),
        (u'rxTimingDeviation768InfoWanted', __RequestedCellIDMeasurements_tdd_rxTimingDeviation768InfoWanted),
        (u'rxTimingDeviation384extInfoWanted', __RequestedCellIDMeasurements_tdd_rxTimingDeviation384extInfoWanted),
        (u'angleOfArrivalLCRWanted', __RequestedCellIDMeasurements_tdd_angleOfArrivalLCRWanted),
        (u'timingAdvanceLCRWanted', __RequestedCellIDMeasurements_tdd_timingAdvanceLCRWanted),
        (u'iE-Extensions', __RequestedCellIDMeasurements_tdd_iE_Extensions),
        ])
    _RequestedCellIDMeasurements_tdd._ext = []
    RequestedCellIDMeasurements._cont = ASN1Dict([
        (u'fdd', _RequestedCellIDMeasurements_fdd),
        (u'tdd', _RequestedCellIDMeasurements_tdd),
        ])
    RequestedCellIDMeasurements._ext = []
    
    #-----< RequestedCellIDMeasurementsFDD-ExtIEs >-----#
    RequestedCellIDMeasurementsFDD_ExtIEs = CLASS(name=u'RequestedCellIDMeasurementsFDD-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    RequestedCellIDMeasurementsFDD_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< RequestedCellIDMeasurementsTDD-ExtIEs >-----#
    RequestedCellIDMeasurementsTDD_ExtIEs = CLASS(name=u'RequestedCellIDMeasurementsTDD-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    RequestedCellIDMeasurementsTDD_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< RequestedCellIDGERANMeasurements >-----#
    RequestedCellIDGERANMeasurements = SEQ(name=u'RequestedCellIDGERANMeasurements', mode=MODE_TYPE)
    _RequestedCellIDGERANMeasurements_rSSIMeasurementsWanted = BOOL(name=u'rSSIMeasurementsWanted', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _RequestedCellIDGERANMeasurements_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __RequestedCellIDGERANMeasurements_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___RequestedCellIDGERANMeasurements_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____RequestedCellIDGERANMeasurements_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____RequestedCellIDGERANMeasurements_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___RequestedCellIDGERANMeasurements_iE_Extensions__item__id._const_tab = ____RequestedCellIDGERANMeasurements_iE_Extensions__item__id_tab
    ___RequestedCellIDGERANMeasurements_iE_Extensions__item__id._const_tab_at = None
    ___RequestedCellIDGERANMeasurements_iE_Extensions__item__id._const_tab_id = u'id'
    ___RequestedCellIDGERANMeasurements_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____RequestedCellIDGERANMeasurements_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____RequestedCellIDGERANMeasurements_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___RequestedCellIDGERANMeasurements_iE_Extensions__item__criticality._const_tab = ____RequestedCellIDGERANMeasurements_iE_Extensions__item__criticality_tab
    ___RequestedCellIDGERANMeasurements_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___RequestedCellIDGERANMeasurements_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___RequestedCellIDGERANMeasurements_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____RequestedCellIDGERANMeasurements_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____RequestedCellIDGERANMeasurements_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___RequestedCellIDGERANMeasurements_iE_Extensions__item__extensionValue._const_tab = ____RequestedCellIDGERANMeasurements_iE_Extensions__item__extensionValue_tab
    ___RequestedCellIDGERANMeasurements_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___RequestedCellIDGERANMeasurements_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __RequestedCellIDGERANMeasurements_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___RequestedCellIDGERANMeasurements_iE_Extensions__item__id),
        (u'criticality', ___RequestedCellIDGERANMeasurements_iE_Extensions__item__criticality),
        (u'extensionValue', ___RequestedCellIDGERANMeasurements_iE_Extensions__item__extensionValue),
        ])
    __RequestedCellIDGERANMeasurements_iE_Extensions__item_._ext = None
    _RequestedCellIDGERANMeasurements_iE_Extensions._cont = __RequestedCellIDGERANMeasurements_iE_Extensions__item_
    _RequestedCellIDGERANMeasurements_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    RequestedCellIDGERANMeasurements._cont = ASN1Dict([
        (u'rSSIMeasurementsWanted', _RequestedCellIDGERANMeasurements_rSSIMeasurementsWanted),
        (u'iE-Extensions', _RequestedCellIDGERANMeasurements_iE_Extensions),
        ])
    RequestedCellIDGERANMeasurements._ext = []
    
    #-----< RequestedCellIDGERANMeasurements-ExtIEs >-----#
    RequestedCellIDGERANMeasurements_ExtIEs = CLASS(name=u'RequestedCellIDGERANMeasurements-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    RequestedCellIDGERANMeasurements_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< ClientType >-----#
    ClientType = ENUM(name=u'ClientType', mode=MODE_TYPE)
    ClientType._cont = ASN1Dict([(u'emergency-services', 0), (u'value-added-services', 1), (u'plmn-operator-services', 2), (u'lawful-intercept-services', 3), (u'plmn-operator-broadcast-services', 4), (u'plmn-operator-oam', 5), (u'plmn-operator-anonymous-statistics', 6), (u'plmn-operator-target-ms-service-support', 7)])
    ClientType._ext = []
    
    #-----< CriticalityDiagnostics >-----#
    CriticalityDiagnostics = SEQ(name=u'CriticalityDiagnostics', mode=MODE_TYPE)
    _CriticalityDiagnostics_procedureCode = INT(name=u'procedureCode', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProcedureCode')), opt=True)
    _CriticalityDiagnostics_triggeringMessage = ENUM(name=u'triggeringMessage', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-CommonDataTypes', 'TriggeringMessage')), opt=True)
    _CriticalityDiagnostics_procedureCriticality = ENUM(name=u'procedureCriticality', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-CommonDataTypes', 'Criticality')), opt=True)
    _CriticalityDiagnostics_transactionID = CHOICE(name=u'transactionID', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PCAP-CommonDataTypes', 'TransactionID')), opt=True)
    _CriticalityDiagnostics_iEsCriticalityDiagnostics = SEQ_OF(name=u'iEsCriticalityDiagnostics', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'CriticalityDiagnostics-IE-List')), opt=True)
    _CriticalityDiagnostics_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __CriticalityDiagnostics_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___CriticalityDiagnostics_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____CriticalityDiagnostics_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____CriticalityDiagnostics_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___CriticalityDiagnostics_iE_Extensions__item__id._const_tab = ____CriticalityDiagnostics_iE_Extensions__item__id_tab
    ___CriticalityDiagnostics_iE_Extensions__item__id._const_tab_at = None
    ___CriticalityDiagnostics_iE_Extensions__item__id._const_tab_id = u'id'
    ___CriticalityDiagnostics_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____CriticalityDiagnostics_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____CriticalityDiagnostics_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___CriticalityDiagnostics_iE_Extensions__item__criticality._const_tab = ____CriticalityDiagnostics_iE_Extensions__item__criticality_tab
    ___CriticalityDiagnostics_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___CriticalityDiagnostics_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___CriticalityDiagnostics_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____CriticalityDiagnostics_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____CriticalityDiagnostics_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___CriticalityDiagnostics_iE_Extensions__item__extensionValue._const_tab = ____CriticalityDiagnostics_iE_Extensions__item__extensionValue_tab
    ___CriticalityDiagnostics_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___CriticalityDiagnostics_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __CriticalityDiagnostics_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___CriticalityDiagnostics_iE_Extensions__item__id),
        (u'criticality', ___CriticalityDiagnostics_iE_Extensions__item__criticality),
        (u'extensionValue', ___CriticalityDiagnostics_iE_Extensions__item__extensionValue),
        ])
    __CriticalityDiagnostics_iE_Extensions__item_._ext = None
    _CriticalityDiagnostics_iE_Extensions._cont = __CriticalityDiagnostics_iE_Extensions__item_
    _CriticalityDiagnostics_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    CriticalityDiagnostics._cont = ASN1Dict([
        (u'procedureCode', _CriticalityDiagnostics_procedureCode),
        (u'triggeringMessage', _CriticalityDiagnostics_triggeringMessage),
        (u'procedureCriticality', _CriticalityDiagnostics_procedureCriticality),
        (u'transactionID', _CriticalityDiagnostics_transactionID),
        (u'iEsCriticalityDiagnostics', _CriticalityDiagnostics_iEsCriticalityDiagnostics),
        (u'iE-Extensions', _CriticalityDiagnostics_iE_Extensions),
        ])
    CriticalityDiagnostics._ext = []
    
    #-----< CriticalityDiagnostics-IE-List >-----#
    CriticalityDiagnostics_IE_List = SEQ_OF(name=u'CriticalityDiagnostics-IE-List', mode=MODE_TYPE)
    _CriticalityDiagnostics_IE_List__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    __CriticalityDiagnostics_IE_List__item__iECriticality = ENUM(name=u'iECriticality', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-CommonDataTypes', 'Criticality')))
    __CriticalityDiagnostics_IE_List__item__iE_ID = INT(name=u'iE-ID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-CommonDataTypes', 'ProtocolIE-ID')))
    __CriticalityDiagnostics_IE_List__item__repetitionNumber = INT(name=u'repetitionNumber', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'CriticalityDiagnosticsRepetition')), opt=True)
    __CriticalityDiagnostics_IE_List__item__messageStructure = SEQ_OF(name=u'messageStructure', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'MessageStructure')), opt=True)
    __CriticalityDiagnostics_IE_List__item__typeOfError = ENUM(name=u'typeOfError', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'TypeOfError')))
    __CriticalityDiagnostics_IE_List__item__iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    ___CriticalityDiagnostics_IE_List__item__iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    _____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__id._const_tab = _____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__id_tab
    ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__id._const_tab_at = None
    ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__id._const_tab_id = u'id'
    ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    _____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__criticality._const_tab = _____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__criticality_tab
    ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    _____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__extensionValue._const_tab = _____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__extensionValue_tab
    ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    ___CriticalityDiagnostics_IE_List__item__iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__id),
        (u'criticality', ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__criticality),
        (u'extensionValue', ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__extensionValue),
        ])
    ___CriticalityDiagnostics_IE_List__item__iE_Extensions__item_._ext = None
    __CriticalityDiagnostics_IE_List__item__iE_Extensions._cont = ___CriticalityDiagnostics_IE_List__item__iE_Extensions__item_
    __CriticalityDiagnostics_IE_List__item__iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    _CriticalityDiagnostics_IE_List__item_._cont = ASN1Dict([
        (u'iECriticality', __CriticalityDiagnostics_IE_List__item__iECriticality),
        (u'iE-ID', __CriticalityDiagnostics_IE_List__item__iE_ID),
        (u'repetitionNumber', __CriticalityDiagnostics_IE_List__item__repetitionNumber),
        (u'messageStructure', __CriticalityDiagnostics_IE_List__item__messageStructure),
        (u'typeOfError', __CriticalityDiagnostics_IE_List__item__typeOfError),
        (u'iE-Extensions', __CriticalityDiagnostics_IE_List__item__iE_Extensions),
        ])
    _CriticalityDiagnostics_IE_List__item_._ext = []
    CriticalityDiagnostics_IE_List._cont = _CriticalityDiagnostics_IE_List__item_
    CriticalityDiagnostics_IE_List._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    
    #-----< CriticalityDiagnostics-IE-List-ExtIEs >-----#
    CriticalityDiagnostics_IE_List_ExtIEs = CLASS(name=u'CriticalityDiagnostics-IE-List-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    CriticalityDiagnostics_IE_List_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< CriticalityDiagnostics-ExtIEs >-----#
    CriticalityDiagnostics_ExtIEs = CLASS(name=u'CriticalityDiagnostics-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    CriticalityDiagnostics_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< CriticalityDiagnosticsRepetition >-----#
    CriticalityDiagnosticsRepetition = INT(name=u'CriticalityDiagnosticsRepetition', mode=MODE_TYPE)
    CriticalityDiagnosticsRepetition._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    
    #-----< TypeOfError >-----#
    TypeOfError = ENUM(name=u'TypeOfError', mode=MODE_TYPE)
    TypeOfError._cont = ASN1Dict([(u'not-understood', 0), (u'missing', 1)])
    TypeOfError._ext = []
    
    #-----< DGPSCorrections >-----#
    DGPSCorrections = SEQ(name=u'DGPSCorrections', mode=MODE_TYPE)
    _DGPSCorrections_gps_TOW_sec = INT(name=u'gps-TOW-sec', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _DGPSCorrections_gps_TOW_sec._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=604799)], ev=None, er=[])
    _DGPSCorrections_statusHealth = ENUM(name=u'statusHealth', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'DiffCorrectionStatus')))
    _DGPSCorrections_dgps_CorrectionSatInfoList = SEQ_OF(name=u'dgps-CorrectionSatInfoList', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'DGPS-CorrectionSatInfoList')), opt=True)
    _DGPSCorrections_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __DGPSCorrections_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___DGPSCorrections_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____DGPSCorrections_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____DGPSCorrections_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___DGPSCorrections_iE_Extensions__item__id._const_tab = ____DGPSCorrections_iE_Extensions__item__id_tab
    ___DGPSCorrections_iE_Extensions__item__id._const_tab_at = None
    ___DGPSCorrections_iE_Extensions__item__id._const_tab_id = u'id'
    ___DGPSCorrections_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____DGPSCorrections_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____DGPSCorrections_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___DGPSCorrections_iE_Extensions__item__criticality._const_tab = ____DGPSCorrections_iE_Extensions__item__criticality_tab
    ___DGPSCorrections_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___DGPSCorrections_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___DGPSCorrections_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____DGPSCorrections_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____DGPSCorrections_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___DGPSCorrections_iE_Extensions__item__extensionValue._const_tab = ____DGPSCorrections_iE_Extensions__item__extensionValue_tab
    ___DGPSCorrections_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___DGPSCorrections_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __DGPSCorrections_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___DGPSCorrections_iE_Extensions__item__id),
        (u'criticality', ___DGPSCorrections_iE_Extensions__item__criticality),
        (u'extensionValue', ___DGPSCorrections_iE_Extensions__item__extensionValue),
        ])
    __DGPSCorrections_iE_Extensions__item_._ext = None
    _DGPSCorrections_iE_Extensions._cont = __DGPSCorrections_iE_Extensions__item_
    _DGPSCorrections_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    DGPSCorrections._cont = ASN1Dict([
        (u'gps-TOW-sec', _DGPSCorrections_gps_TOW_sec),
        (u'statusHealth', _DGPSCorrections_statusHealth),
        (u'dgps-CorrectionSatInfoList', _DGPSCorrections_dgps_CorrectionSatInfoList),
        (u'iE-Extensions', _DGPSCorrections_iE_Extensions),
        ])
    DGPSCorrections._ext = []
    
    #-----< DGPSCorrections-ExtIEs >-----#
    DGPSCorrections_ExtIEs = CLASS(name=u'DGPSCorrections-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    DGPSCorrections_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< DiffCorrectionStatus >-----#
    DiffCorrectionStatus = ENUM(name=u'DiffCorrectionStatus', mode=MODE_TYPE)
    DiffCorrectionStatus._cont = ASN1Dict([(u'udre-1-0', 0), (u'udre-0-75', 1), (u'udre-0-5', 2), (u'udre-0-3', 3), (u'udre-0-2', 4), (u'udre-0-1', 5), (u'noData', 6), (u'invalidData', 7)])
    DiffCorrectionStatus._ext = None
    
    #-----< DGPS-CorrectionSatInfoList >-----#
    DGPS_CorrectionSatInfoList = SEQ_OF(name=u'DGPS-CorrectionSatInfoList', mode=MODE_TYPE)
    _DGPS_CorrectionSatInfoList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'DGPS-CorrectionSatInfo')))
    DGPS_CorrectionSatInfoList._cont = _DGPS_CorrectionSatInfoList__item_
    DGPS_CorrectionSatInfoList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    
    #-----< DGPS-CorrectionSatInfo >-----#
    DGPS_CorrectionSatInfo = SEQ(name=u'DGPS-CorrectionSatInfo', mode=MODE_TYPE)
    _DGPS_CorrectionSatInfo_satID = INT(name=u'satID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _DGPS_CorrectionSatInfo_satID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    _DGPS_CorrectionSatInfo_iode = INT(name=u'iode', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _DGPS_CorrectionSatInfo_iode._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _DGPS_CorrectionSatInfo_udre = ENUM(name=u'udre', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'UDRE')))
    _DGPS_CorrectionSatInfo_prc = INT(name=u'prc', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'PRC')))
    _DGPS_CorrectionSatInfo_rrc = INT(name=u'rrc', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'RRC')))
    _DGPS_CorrectionSatInfo_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __DGPS_CorrectionSatInfo_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___DGPS_CorrectionSatInfo_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____DGPS_CorrectionSatInfo_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____DGPS_CorrectionSatInfo_iE_Extensions__item__id_tab_val_Extension_0 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'DGNSS-ValidityPeriod')))
    ____DGPS_CorrectionSatInfo_iE_Extensions__item__id_tab._val = ASN1Set(rv=[dict([(u'id', 118), (u'criticality', u'ignore'), (u'Extension', _____DGPS_CorrectionSatInfo_iE_Extensions__item__id_tab_val_Extension_0), (u'presence', u'optional')])], rr=[], ev=None, er=[])
    ___DGPS_CorrectionSatInfo_iE_Extensions__item__id._const_tab = ____DGPS_CorrectionSatInfo_iE_Extensions__item__id_tab
    ___DGPS_CorrectionSatInfo_iE_Extensions__item__id._const_tab_at = None
    ___DGPS_CorrectionSatInfo_iE_Extensions__item__id._const_tab_id = u'id'
    ___DGPS_CorrectionSatInfo_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ___DGPS_CorrectionSatInfo_iE_Extensions__item__criticality._const_tab = ____DGPS_CorrectionSatInfo_iE_Extensions__item__id_tab
    ___DGPS_CorrectionSatInfo_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___DGPS_CorrectionSatInfo_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___DGPS_CorrectionSatInfo_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ___DGPS_CorrectionSatInfo_iE_Extensions__item__extensionValue._const_tab = ____DGPS_CorrectionSatInfo_iE_Extensions__item__id_tab
    ___DGPS_CorrectionSatInfo_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___DGPS_CorrectionSatInfo_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __DGPS_CorrectionSatInfo_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___DGPS_CorrectionSatInfo_iE_Extensions__item__id),
        (u'criticality', ___DGPS_CorrectionSatInfo_iE_Extensions__item__criticality),
        (u'extensionValue', ___DGPS_CorrectionSatInfo_iE_Extensions__item__extensionValue),
        ])
    __DGPS_CorrectionSatInfo_iE_Extensions__item_._ext = None
    _DGPS_CorrectionSatInfo_iE_Extensions._cont = __DGPS_CorrectionSatInfo_iE_Extensions__item_
    _DGPS_CorrectionSatInfo_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    DGPS_CorrectionSatInfo._cont = ASN1Dict([
        (u'satID', _DGPS_CorrectionSatInfo_satID),
        (u'iode', _DGPS_CorrectionSatInfo_iode),
        (u'udre', _DGPS_CorrectionSatInfo_udre),
        (u'prc', _DGPS_CorrectionSatInfo_prc),
        (u'rrc', _DGPS_CorrectionSatInfo_rrc),
        (u'iE-Extensions', _DGPS_CorrectionSatInfo_iE_Extensions),
        ])
    DGPS_CorrectionSatInfo._ext = []
    
    #-----< DGPS-CorrectionSatInfo-ExtIEs >-----#
    DGPS_CorrectionSatInfo_ExtIEs = CLASS(name=u'DGPS-CorrectionSatInfo-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _DGPS_CorrectionSatInfo_ExtIEs_val_Extension_0 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'DGNSS-ValidityPeriod')))
    DGPS_CorrectionSatInfo_ExtIEs._val = ASN1Set(rv=[dict([(u'id', 118), (u'criticality', u'ignore'), (u'Extension', _DGPS_CorrectionSatInfo_ExtIEs_val_Extension_0), (u'presence', u'optional')])], rr=[], ev=[], er=[])
    
    #-----< DGNSS-ValidityPeriod >-----#
    DGNSS_ValidityPeriod = SEQ(name=u'DGNSS-ValidityPeriod', mode=MODE_TYPE)
    _DGNSS_ValidityPeriod_udreGrowthRate = ENUM(name=u'udreGrowthRate', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'UDREGrowthRate')))
    _DGNSS_ValidityPeriod_udreValidityTime = ENUM(name=u'udreValidityTime', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'UDREValidityTime')))
    _DGNSS_ValidityPeriod_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __DGNSS_ValidityPeriod_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___DGNSS_ValidityPeriod_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____DGNSS_ValidityPeriod_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____DGNSS_ValidityPeriod_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___DGNSS_ValidityPeriod_iE_Extensions__item__id._const_tab = ____DGNSS_ValidityPeriod_iE_Extensions__item__id_tab
    ___DGNSS_ValidityPeriod_iE_Extensions__item__id._const_tab_at = None
    ___DGNSS_ValidityPeriod_iE_Extensions__item__id._const_tab_id = u'id'
    ___DGNSS_ValidityPeriod_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____DGNSS_ValidityPeriod_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____DGNSS_ValidityPeriod_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___DGNSS_ValidityPeriod_iE_Extensions__item__criticality._const_tab = ____DGNSS_ValidityPeriod_iE_Extensions__item__criticality_tab
    ___DGNSS_ValidityPeriod_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___DGNSS_ValidityPeriod_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___DGNSS_ValidityPeriod_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____DGNSS_ValidityPeriod_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____DGNSS_ValidityPeriod_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___DGNSS_ValidityPeriod_iE_Extensions__item__extensionValue._const_tab = ____DGNSS_ValidityPeriod_iE_Extensions__item__extensionValue_tab
    ___DGNSS_ValidityPeriod_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___DGNSS_ValidityPeriod_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __DGNSS_ValidityPeriod_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___DGNSS_ValidityPeriod_iE_Extensions__item__id),
        (u'criticality', ___DGNSS_ValidityPeriod_iE_Extensions__item__criticality),
        (u'extensionValue', ___DGNSS_ValidityPeriod_iE_Extensions__item__extensionValue),
        ])
    __DGNSS_ValidityPeriod_iE_Extensions__item_._ext = None
    _DGNSS_ValidityPeriod_iE_Extensions._cont = __DGNSS_ValidityPeriod_iE_Extensions__item_
    _DGNSS_ValidityPeriod_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    DGNSS_ValidityPeriod._cont = ASN1Dict([
        (u'udreGrowthRate', _DGNSS_ValidityPeriod_udreGrowthRate),
        (u'udreValidityTime', _DGNSS_ValidityPeriod_udreValidityTime),
        (u'iE-Extensions', _DGNSS_ValidityPeriod_iE_Extensions),
        ])
    DGNSS_ValidityPeriod._ext = []
    
    #-----< DGNSS-ValidityPeriod-ExtIEs >-----#
    DGNSS_ValidityPeriod_ExtIEs = CLASS(name=u'DGNSS-ValidityPeriod-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    DGNSS_ValidityPeriod_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< UDRE >-----#
    UDRE = ENUM(name=u'UDRE', mode=MODE_TYPE)
    UDRE._cont = ASN1Dict([(u'lessThan1', 0), (u'between1-and-4', 1), (u'between4-and-8', 2), (u'over8', 3)])
    UDRE._ext = None
    
    #-----< UDREGrowthRate >-----#
    UDREGrowthRate = ENUM(name=u'UDREGrowthRate', mode=MODE_TYPE)
    UDREGrowthRate._cont = ASN1Dict([(u'growth-1-point-5', 0), (u'growth-2', 1), (u'growth-4', 2), (u'growth-6', 3), (u'growth-8', 4), (u'growth-10', 5), (u'growth-12', 6), (u'growth-16', 7)])
    UDREGrowthRate._ext = None
    
    #-----< UDREValidityTime >-----#
    UDREValidityTime = ENUM(name=u'UDREValidityTime', mode=MODE_TYPE)
    UDREValidityTime._cont = ASN1Dict([(u'val-20sec', 0), (u'val-40sec', 1), (u'val-80sec', 2), (u'val-160sec', 3), (u'val-320sec', 4), (u'val-640sec', 5), (u'val-1280sec', 6), (u'val-2560sec', 7)])
    UDREValidityTime._ext = None
    
    #-----< PRC >-----#
    PRC = INT(name=u'PRC', mode=MODE_TYPE)
    PRC._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-2047, ub=2047)], ev=None, er=[])
    
    #-----< RRC >-----#
    RRC = INT(name=u'RRC', mode=MODE_TYPE)
    RRC._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-127, ub=127)], ev=None, er=[])
    
    #-----< IMEI >-----#
    IMEI = OCT_STR(name=u'IMEI', mode=MODE_TYPE)
    IMEI._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    
    #-----< IMSI >-----#
    IMSI = OCT_STR(name=u'IMSI', mode=MODE_TYPE)
    IMSI._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=3, ub=8)], ev=None, er=[])
    
    #-----< UE-PositionEstimate >-----#
    UE_PositionEstimate = CHOICE(name=u'UE-PositionEstimate', mode=MODE_TYPE)
    _UE_PositionEstimate_point = SEQ(name=u'point', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GA-Point')))
    _UE_PositionEstimate_pointWithUnCertainty = SEQ(name=u'pointWithUnCertainty', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GA-PointWithUnCertainty')))
    _UE_PositionEstimate_polygon = SEQ_OF(name=u'polygon', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GA-Polygon')))
    _UE_PositionEstimate_pointWithUncertaintyEllipse = SEQ(name=u'pointWithUncertaintyEllipse', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GA-PointWithUnCertaintyEllipse')))
    _UE_PositionEstimate_pointWithAltitude = SEQ(name=u'pointWithAltitude', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GA-PointWithAltitude')))
    _UE_PositionEstimate_pointWithAltitudeAndUncertaintyEllipsoid = SEQ(name=u'pointWithAltitudeAndUncertaintyEllipsoid', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GA-PointWithAltitudeAndUncertaintyEllipsoid')))
    _UE_PositionEstimate_ellipsoidArc = SEQ(name=u'ellipsoidArc', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GA-EllipsoidArc')))
    UE_PositionEstimate._cont = ASN1Dict([
        (u'point', _UE_PositionEstimate_point),
        (u'pointWithUnCertainty', _UE_PositionEstimate_pointWithUnCertainty),
        (u'polygon', _UE_PositionEstimate_polygon),
        (u'pointWithUncertaintyEllipse', _UE_PositionEstimate_pointWithUncertaintyEllipse),
        (u'pointWithAltitude', _UE_PositionEstimate_pointWithAltitude),
        (u'pointWithAltitudeAndUncertaintyEllipsoid', _UE_PositionEstimate_pointWithAltitudeAndUncertaintyEllipsoid),
        (u'ellipsoidArc', _UE_PositionEstimate_ellipsoidArc),
        ])
    UE_PositionEstimate._ext = []
    
    #-----< GeographicalCoordinates >-----#
    GeographicalCoordinates = SEQ(name=u'GeographicalCoordinates', mode=MODE_TYPE)
    _GeographicalCoordinates_latitudeSign = ENUM(name=u'latitudeSign', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GeographicalCoordinates_latitudeSign._cont = ASN1Dict([(u'north', 0), (u'south', 1)])
    _GeographicalCoordinates_latitudeSign._ext = None
    _GeographicalCoordinates_latitude = INT(name=u'latitude', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GeographicalCoordinates_latitude._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=8388607)], ev=None, er=[])
    _GeographicalCoordinates_longitude = INT(name=u'longitude', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GeographicalCoordinates_longitude._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-8388608, ub=8388607)], ev=None, er=[])
    _GeographicalCoordinates_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GeographicalCoordinates_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GeographicalCoordinates_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GeographicalCoordinates_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GeographicalCoordinates_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GeographicalCoordinates_iE_Extensions__item__id._const_tab = ____GeographicalCoordinates_iE_Extensions__item__id_tab
    ___GeographicalCoordinates_iE_Extensions__item__id._const_tab_at = None
    ___GeographicalCoordinates_iE_Extensions__item__id._const_tab_id = u'id'
    ___GeographicalCoordinates_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GeographicalCoordinates_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GeographicalCoordinates_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GeographicalCoordinates_iE_Extensions__item__criticality._const_tab = ____GeographicalCoordinates_iE_Extensions__item__criticality_tab
    ___GeographicalCoordinates_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GeographicalCoordinates_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GeographicalCoordinates_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GeographicalCoordinates_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GeographicalCoordinates_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GeographicalCoordinates_iE_Extensions__item__extensionValue._const_tab = ____GeographicalCoordinates_iE_Extensions__item__extensionValue_tab
    ___GeographicalCoordinates_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GeographicalCoordinates_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GeographicalCoordinates_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GeographicalCoordinates_iE_Extensions__item__id),
        (u'criticality', ___GeographicalCoordinates_iE_Extensions__item__criticality),
        (u'extensionValue', ___GeographicalCoordinates_iE_Extensions__item__extensionValue),
        ])
    __GeographicalCoordinates_iE_Extensions__item_._ext = None
    _GeographicalCoordinates_iE_Extensions._cont = __GeographicalCoordinates_iE_Extensions__item_
    _GeographicalCoordinates_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GeographicalCoordinates._cont = ASN1Dict([
        (u'latitudeSign', _GeographicalCoordinates_latitudeSign),
        (u'latitude', _GeographicalCoordinates_latitude),
        (u'longitude', _GeographicalCoordinates_longitude),
        (u'iE-Extensions', _GeographicalCoordinates_iE_Extensions),
        ])
    GeographicalCoordinates._ext = []
    
    #-----< GeographicalCoordinates-ExtIEs >-----#
    GeographicalCoordinates_ExtIEs = CLASS(name=u'GeographicalCoordinates-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GeographicalCoordinates_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GA-AltitudeAndDirection >-----#
    GA_AltitudeAndDirection = SEQ(name=u'GA-AltitudeAndDirection', mode=MODE_TYPE)
    _GA_AltitudeAndDirection_directionOfAltitude = ENUM(name=u'directionOfAltitude', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GA_AltitudeAndDirection_directionOfAltitude._cont = ASN1Dict([(u'height', 0), (u'depth', 1)])
    _GA_AltitudeAndDirection_directionOfAltitude._ext = None
    _GA_AltitudeAndDirection_altitude = INT(name=u'altitude', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GA_AltitudeAndDirection_altitude._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=32767)], ev=None, er=[])
    GA_AltitudeAndDirection._cont = ASN1Dict([
        (u'directionOfAltitude', _GA_AltitudeAndDirection_directionOfAltitude),
        (u'altitude', _GA_AltitudeAndDirection_altitude),
        ])
    GA_AltitudeAndDirection._ext = []
    
    #-----< GA-EllipsoidArc >-----#
    GA_EllipsoidArc = SEQ(name=u'GA-EllipsoidArc', mode=MODE_TYPE)
    _GA_EllipsoidArc_geographicalCoordinates = SEQ(name=u'geographicalCoordinates', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GeographicalCoordinates')))
    _GA_EllipsoidArc_innerRadius = INT(name=u'innerRadius', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GA_EllipsoidArc_innerRadius._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    _GA_EllipsoidArc_uncertaintyRadius = INT(name=u'uncertaintyRadius', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GA_EllipsoidArc_uncertaintyRadius._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    _GA_EllipsoidArc_offsetAngle = INT(name=u'offsetAngle', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GA_EllipsoidArc_offsetAngle._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=179)], ev=None, er=[])
    _GA_EllipsoidArc_includedAngle = INT(name=u'includedAngle', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GA_EllipsoidArc_includedAngle._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=179)], ev=None, er=[])
    _GA_EllipsoidArc_confidence = INT(name=u'confidence', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GA_EllipsoidArc_confidence._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=100)], ev=None, er=[])
    _GA_EllipsoidArc_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GA_EllipsoidArc_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GA_EllipsoidArc_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GA_EllipsoidArc_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GA_EllipsoidArc_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GA_EllipsoidArc_iE_Extensions__item__id._const_tab = ____GA_EllipsoidArc_iE_Extensions__item__id_tab
    ___GA_EllipsoidArc_iE_Extensions__item__id._const_tab_at = None
    ___GA_EllipsoidArc_iE_Extensions__item__id._const_tab_id = u'id'
    ___GA_EllipsoidArc_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GA_EllipsoidArc_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GA_EllipsoidArc_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GA_EllipsoidArc_iE_Extensions__item__criticality._const_tab = ____GA_EllipsoidArc_iE_Extensions__item__criticality_tab
    ___GA_EllipsoidArc_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GA_EllipsoidArc_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GA_EllipsoidArc_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GA_EllipsoidArc_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GA_EllipsoidArc_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GA_EllipsoidArc_iE_Extensions__item__extensionValue._const_tab = ____GA_EllipsoidArc_iE_Extensions__item__extensionValue_tab
    ___GA_EllipsoidArc_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GA_EllipsoidArc_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GA_EllipsoidArc_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GA_EllipsoidArc_iE_Extensions__item__id),
        (u'criticality', ___GA_EllipsoidArc_iE_Extensions__item__criticality),
        (u'extensionValue', ___GA_EllipsoidArc_iE_Extensions__item__extensionValue),
        ])
    __GA_EllipsoidArc_iE_Extensions__item_._ext = None
    _GA_EllipsoidArc_iE_Extensions._cont = __GA_EllipsoidArc_iE_Extensions__item_
    _GA_EllipsoidArc_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GA_EllipsoidArc._cont = ASN1Dict([
        (u'geographicalCoordinates', _GA_EllipsoidArc_geographicalCoordinates),
        (u'innerRadius', _GA_EllipsoidArc_innerRadius),
        (u'uncertaintyRadius', _GA_EllipsoidArc_uncertaintyRadius),
        (u'offsetAngle', _GA_EllipsoidArc_offsetAngle),
        (u'includedAngle', _GA_EllipsoidArc_includedAngle),
        (u'confidence', _GA_EllipsoidArc_confidence),
        (u'iE-Extensions', _GA_EllipsoidArc_iE_Extensions),
        ])
    GA_EllipsoidArc._ext = []
    
    #-----< GA-EllipsoidArc-ExtIEs >-----#
    GA_EllipsoidArc_ExtIEs = CLASS(name=u'GA-EllipsoidArc-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GA_EllipsoidArc_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GA-Point >-----#
    GA_Point = SEQ(name=u'GA-Point', mode=MODE_TYPE)
    _GA_Point_geographicalCoordinates = SEQ(name=u'geographicalCoordinates', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GeographicalCoordinates')))
    _GA_Point_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GA_Point_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GA_Point_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GA_Point_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GA_Point_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GA_Point_iE_Extensions__item__id._const_tab = ____GA_Point_iE_Extensions__item__id_tab
    ___GA_Point_iE_Extensions__item__id._const_tab_at = None
    ___GA_Point_iE_Extensions__item__id._const_tab_id = u'id'
    ___GA_Point_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GA_Point_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GA_Point_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GA_Point_iE_Extensions__item__criticality._const_tab = ____GA_Point_iE_Extensions__item__criticality_tab
    ___GA_Point_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GA_Point_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GA_Point_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GA_Point_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GA_Point_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GA_Point_iE_Extensions__item__extensionValue._const_tab = ____GA_Point_iE_Extensions__item__extensionValue_tab
    ___GA_Point_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GA_Point_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GA_Point_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GA_Point_iE_Extensions__item__id),
        (u'criticality', ___GA_Point_iE_Extensions__item__criticality),
        (u'extensionValue', ___GA_Point_iE_Extensions__item__extensionValue),
        ])
    __GA_Point_iE_Extensions__item_._ext = None
    _GA_Point_iE_Extensions._cont = __GA_Point_iE_Extensions__item_
    _GA_Point_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GA_Point._cont = ASN1Dict([
        (u'geographicalCoordinates', _GA_Point_geographicalCoordinates),
        (u'iE-Extensions', _GA_Point_iE_Extensions),
        ])
    GA_Point._ext = []
    
    #-----< GA-Point-ExtIEs >-----#
    GA_Point_ExtIEs = CLASS(name=u'GA-Point-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GA_Point_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GA-PointWithAltitude >-----#
    GA_PointWithAltitude = SEQ(name=u'GA-PointWithAltitude', mode=MODE_TYPE)
    _GA_PointWithAltitude_geographicalCoordinates = SEQ(name=u'geographicalCoordinates', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GeographicalCoordinates')))
    _GA_PointWithAltitude_altitudeAndDirection = SEQ(name=u'altitudeAndDirection', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GA-AltitudeAndDirection')))
    _GA_PointWithAltitude_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GA_PointWithAltitude_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GA_PointWithAltitude_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GA_PointWithAltitude_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GA_PointWithAltitude_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GA_PointWithAltitude_iE_Extensions__item__id._const_tab = ____GA_PointWithAltitude_iE_Extensions__item__id_tab
    ___GA_PointWithAltitude_iE_Extensions__item__id._const_tab_at = None
    ___GA_PointWithAltitude_iE_Extensions__item__id._const_tab_id = u'id'
    ___GA_PointWithAltitude_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GA_PointWithAltitude_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GA_PointWithAltitude_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GA_PointWithAltitude_iE_Extensions__item__criticality._const_tab = ____GA_PointWithAltitude_iE_Extensions__item__criticality_tab
    ___GA_PointWithAltitude_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GA_PointWithAltitude_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GA_PointWithAltitude_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GA_PointWithAltitude_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GA_PointWithAltitude_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GA_PointWithAltitude_iE_Extensions__item__extensionValue._const_tab = ____GA_PointWithAltitude_iE_Extensions__item__extensionValue_tab
    ___GA_PointWithAltitude_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GA_PointWithAltitude_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GA_PointWithAltitude_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GA_PointWithAltitude_iE_Extensions__item__id),
        (u'criticality', ___GA_PointWithAltitude_iE_Extensions__item__criticality),
        (u'extensionValue', ___GA_PointWithAltitude_iE_Extensions__item__extensionValue),
        ])
    __GA_PointWithAltitude_iE_Extensions__item_._ext = None
    _GA_PointWithAltitude_iE_Extensions._cont = __GA_PointWithAltitude_iE_Extensions__item_
    _GA_PointWithAltitude_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GA_PointWithAltitude._cont = ASN1Dict([
        (u'geographicalCoordinates', _GA_PointWithAltitude_geographicalCoordinates),
        (u'altitudeAndDirection', _GA_PointWithAltitude_altitudeAndDirection),
        (u'iE-Extensions', _GA_PointWithAltitude_iE_Extensions),
        ])
    GA_PointWithAltitude._ext = []
    
    #-----< GA-PointWithAltitude-ExtIEs >-----#
    GA_PointWithAltitude_ExtIEs = CLASS(name=u'GA-PointWithAltitude-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GA_PointWithAltitude_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GA-PointWithAltitudeAndUncertaintyEllipsoid >-----#
    GA_PointWithAltitudeAndUncertaintyEllipsoid = SEQ(name=u'GA-PointWithAltitudeAndUncertaintyEllipsoid', mode=MODE_TYPE)
    _GA_PointWithAltitudeAndUncertaintyEllipsoid_geographicalCoordinates = SEQ(name=u'geographicalCoordinates', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GeographicalCoordinates')))
    _GA_PointWithAltitudeAndUncertaintyEllipsoid_altitudeAndDirection = SEQ(name=u'altitudeAndDirection', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GA-AltitudeAndDirection')))
    _GA_PointWithAltitudeAndUncertaintyEllipsoid_uncertaintyEllipse = SEQ(name=u'uncertaintyEllipse', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GA-UncertaintyEllipse')))
    _GA_PointWithAltitudeAndUncertaintyEllipsoid_uncertaintyAltitude = INT(name=u'uncertaintyAltitude', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GA_PointWithAltitudeAndUncertaintyEllipsoid_uncertaintyAltitude._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    _GA_PointWithAltitudeAndUncertaintyEllipsoid_confidence = INT(name=u'confidence', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GA_PointWithAltitudeAndUncertaintyEllipsoid_confidence._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=100)], ev=None, er=[])
    _GA_PointWithAltitudeAndUncertaintyEllipsoid_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GA_PointWithAltitudeAndUncertaintyEllipsoid_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GA_PointWithAltitudeAndUncertaintyEllipsoid_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GA_PointWithAltitudeAndUncertaintyEllipsoid_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GA_PointWithAltitudeAndUncertaintyEllipsoid_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GA_PointWithAltitudeAndUncertaintyEllipsoid_iE_Extensions__item__id._const_tab = ____GA_PointWithAltitudeAndUncertaintyEllipsoid_iE_Extensions__item__id_tab
    ___GA_PointWithAltitudeAndUncertaintyEllipsoid_iE_Extensions__item__id._const_tab_at = None
    ___GA_PointWithAltitudeAndUncertaintyEllipsoid_iE_Extensions__item__id._const_tab_id = u'id'
    ___GA_PointWithAltitudeAndUncertaintyEllipsoid_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GA_PointWithAltitudeAndUncertaintyEllipsoid_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GA_PointWithAltitudeAndUncertaintyEllipsoid_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GA_PointWithAltitudeAndUncertaintyEllipsoid_iE_Extensions__item__criticality._const_tab = ____GA_PointWithAltitudeAndUncertaintyEllipsoid_iE_Extensions__item__criticality_tab
    ___GA_PointWithAltitudeAndUncertaintyEllipsoid_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GA_PointWithAltitudeAndUncertaintyEllipsoid_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GA_PointWithAltitudeAndUncertaintyEllipsoid_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GA_PointWithAltitudeAndUncertaintyEllipsoid_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GA_PointWithAltitudeAndUncertaintyEllipsoid_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GA_PointWithAltitudeAndUncertaintyEllipsoid_iE_Extensions__item__extensionValue._const_tab = ____GA_PointWithAltitudeAndUncertaintyEllipsoid_iE_Extensions__item__extensionValue_tab
    ___GA_PointWithAltitudeAndUncertaintyEllipsoid_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GA_PointWithAltitudeAndUncertaintyEllipsoid_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GA_PointWithAltitudeAndUncertaintyEllipsoid_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GA_PointWithAltitudeAndUncertaintyEllipsoid_iE_Extensions__item__id),
        (u'criticality', ___GA_PointWithAltitudeAndUncertaintyEllipsoid_iE_Extensions__item__criticality),
        (u'extensionValue', ___GA_PointWithAltitudeAndUncertaintyEllipsoid_iE_Extensions__item__extensionValue),
        ])
    __GA_PointWithAltitudeAndUncertaintyEllipsoid_iE_Extensions__item_._ext = None
    _GA_PointWithAltitudeAndUncertaintyEllipsoid_iE_Extensions._cont = __GA_PointWithAltitudeAndUncertaintyEllipsoid_iE_Extensions__item_
    _GA_PointWithAltitudeAndUncertaintyEllipsoid_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GA_PointWithAltitudeAndUncertaintyEllipsoid._cont = ASN1Dict([
        (u'geographicalCoordinates', _GA_PointWithAltitudeAndUncertaintyEllipsoid_geographicalCoordinates),
        (u'altitudeAndDirection', _GA_PointWithAltitudeAndUncertaintyEllipsoid_altitudeAndDirection),
        (u'uncertaintyEllipse', _GA_PointWithAltitudeAndUncertaintyEllipsoid_uncertaintyEllipse),
        (u'uncertaintyAltitude', _GA_PointWithAltitudeAndUncertaintyEllipsoid_uncertaintyAltitude),
        (u'confidence', _GA_PointWithAltitudeAndUncertaintyEllipsoid_confidence),
        (u'iE-Extensions', _GA_PointWithAltitudeAndUncertaintyEllipsoid_iE_Extensions),
        ])
    GA_PointWithAltitudeAndUncertaintyEllipsoid._ext = []
    
    #-----< GA-PointWithAltitudeAndUncertaintyEllipsoid-ExtIEs >-----#
    GA_PointWithAltitudeAndUncertaintyEllipsoid_ExtIEs = CLASS(name=u'GA-PointWithAltitudeAndUncertaintyEllipsoid-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GA_PointWithAltitudeAndUncertaintyEllipsoid_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GA-PointWithUnCertainty >-----#
    GA_PointWithUnCertainty = SEQ(name=u'GA-PointWithUnCertainty', mode=MODE_TYPE)
    _GA_PointWithUnCertainty_geographicalCoordinates = SEQ(name=u'geographicalCoordinates', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GeographicalCoordinates')))
    _GA_PointWithUnCertainty_uncertaintyCode = INT(name=u'uncertaintyCode', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GA_PointWithUnCertainty_uncertaintyCode._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    _GA_PointWithUnCertainty_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GA_PointWithUnCertainty_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GA_PointWithUnCertainty_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GA_PointWithUnCertainty_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GA_PointWithUnCertainty_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GA_PointWithUnCertainty_iE_Extensions__item__id._const_tab = ____GA_PointWithUnCertainty_iE_Extensions__item__id_tab
    ___GA_PointWithUnCertainty_iE_Extensions__item__id._const_tab_at = None
    ___GA_PointWithUnCertainty_iE_Extensions__item__id._const_tab_id = u'id'
    ___GA_PointWithUnCertainty_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GA_PointWithUnCertainty_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GA_PointWithUnCertainty_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GA_PointWithUnCertainty_iE_Extensions__item__criticality._const_tab = ____GA_PointWithUnCertainty_iE_Extensions__item__criticality_tab
    ___GA_PointWithUnCertainty_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GA_PointWithUnCertainty_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GA_PointWithUnCertainty_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GA_PointWithUnCertainty_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GA_PointWithUnCertainty_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GA_PointWithUnCertainty_iE_Extensions__item__extensionValue._const_tab = ____GA_PointWithUnCertainty_iE_Extensions__item__extensionValue_tab
    ___GA_PointWithUnCertainty_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GA_PointWithUnCertainty_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GA_PointWithUnCertainty_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GA_PointWithUnCertainty_iE_Extensions__item__id),
        (u'criticality', ___GA_PointWithUnCertainty_iE_Extensions__item__criticality),
        (u'extensionValue', ___GA_PointWithUnCertainty_iE_Extensions__item__extensionValue),
        ])
    __GA_PointWithUnCertainty_iE_Extensions__item_._ext = None
    _GA_PointWithUnCertainty_iE_Extensions._cont = __GA_PointWithUnCertainty_iE_Extensions__item_
    _GA_PointWithUnCertainty_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GA_PointWithUnCertainty._cont = ASN1Dict([
        (u'geographicalCoordinates', _GA_PointWithUnCertainty_geographicalCoordinates),
        (u'uncertaintyCode', _GA_PointWithUnCertainty_uncertaintyCode),
        (u'iE-Extensions', _GA_PointWithUnCertainty_iE_Extensions),
        ])
    GA_PointWithUnCertainty._ext = []
    
    #-----< GA-PointWithUnCertainty-ExtIEs >-----#
    GA_PointWithUnCertainty_ExtIEs = CLASS(name=u'GA-PointWithUnCertainty-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GA_PointWithUnCertainty_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GA-PointWithUnCertaintyEllipse >-----#
    GA_PointWithUnCertaintyEllipse = SEQ(name=u'GA-PointWithUnCertaintyEllipse', mode=MODE_TYPE)
    _GA_PointWithUnCertaintyEllipse_geographicalCoordinates = SEQ(name=u'geographicalCoordinates', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GeographicalCoordinates')))
    _GA_PointWithUnCertaintyEllipse_uncertaintyEllipse = SEQ(name=u'uncertaintyEllipse', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GA-UncertaintyEllipse')))
    _GA_PointWithUnCertaintyEllipse_confidence = INT(name=u'confidence', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GA_PointWithUnCertaintyEllipse_confidence._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=100)], ev=None, er=[])
    _GA_PointWithUnCertaintyEllipse_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GA_PointWithUnCertaintyEllipse_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GA_PointWithUnCertaintyEllipse_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GA_PointWithUnCertaintyEllipse_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GA_PointWithUnCertaintyEllipse_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GA_PointWithUnCertaintyEllipse_iE_Extensions__item__id._const_tab = ____GA_PointWithUnCertaintyEllipse_iE_Extensions__item__id_tab
    ___GA_PointWithUnCertaintyEllipse_iE_Extensions__item__id._const_tab_at = None
    ___GA_PointWithUnCertaintyEllipse_iE_Extensions__item__id._const_tab_id = u'id'
    ___GA_PointWithUnCertaintyEllipse_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GA_PointWithUnCertaintyEllipse_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GA_PointWithUnCertaintyEllipse_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GA_PointWithUnCertaintyEllipse_iE_Extensions__item__criticality._const_tab = ____GA_PointWithUnCertaintyEllipse_iE_Extensions__item__criticality_tab
    ___GA_PointWithUnCertaintyEllipse_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GA_PointWithUnCertaintyEllipse_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GA_PointWithUnCertaintyEllipse_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GA_PointWithUnCertaintyEllipse_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GA_PointWithUnCertaintyEllipse_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GA_PointWithUnCertaintyEllipse_iE_Extensions__item__extensionValue._const_tab = ____GA_PointWithUnCertaintyEllipse_iE_Extensions__item__extensionValue_tab
    ___GA_PointWithUnCertaintyEllipse_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GA_PointWithUnCertaintyEllipse_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GA_PointWithUnCertaintyEllipse_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GA_PointWithUnCertaintyEllipse_iE_Extensions__item__id),
        (u'criticality', ___GA_PointWithUnCertaintyEllipse_iE_Extensions__item__criticality),
        (u'extensionValue', ___GA_PointWithUnCertaintyEllipse_iE_Extensions__item__extensionValue),
        ])
    __GA_PointWithUnCertaintyEllipse_iE_Extensions__item_._ext = None
    _GA_PointWithUnCertaintyEllipse_iE_Extensions._cont = __GA_PointWithUnCertaintyEllipse_iE_Extensions__item_
    _GA_PointWithUnCertaintyEllipse_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GA_PointWithUnCertaintyEllipse._cont = ASN1Dict([
        (u'geographicalCoordinates', _GA_PointWithUnCertaintyEllipse_geographicalCoordinates),
        (u'uncertaintyEllipse', _GA_PointWithUnCertaintyEllipse_uncertaintyEllipse),
        (u'confidence', _GA_PointWithUnCertaintyEllipse_confidence),
        (u'iE-Extensions', _GA_PointWithUnCertaintyEllipse_iE_Extensions),
        ])
    GA_PointWithUnCertaintyEllipse._ext = []
    
    #-----< GA-PointWithUnCertaintyEllipse-ExtIEs >-----#
    GA_PointWithUnCertaintyEllipse_ExtIEs = CLASS(name=u'GA-PointWithUnCertaintyEllipse-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GA_PointWithUnCertaintyEllipse_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GA-Polygon >-----#
    GA_Polygon = SEQ_OF(name=u'GA-Polygon', mode=MODE_TYPE)
    _GA_Polygon__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    __GA_Polygon__item__geographicalCoordinates = SEQ(name=u'geographicalCoordinates', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GeographicalCoordinates')))
    __GA_Polygon__item__iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    ___GA_Polygon__item__iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ____GA_Polygon__item__iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    _____GA_Polygon__item__iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____GA_Polygon__item__iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____GA_Polygon__item__iE_Extensions__item__id._const_tab = _____GA_Polygon__item__iE_Extensions__item__id_tab
    ____GA_Polygon__item__iE_Extensions__item__id._const_tab_at = None
    ____GA_Polygon__item__iE_Extensions__item__id._const_tab_id = u'id'
    ____GA_Polygon__item__iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    _____GA_Polygon__item__iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____GA_Polygon__item__iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____GA_Polygon__item__iE_Extensions__item__criticality._const_tab = _____GA_Polygon__item__iE_Extensions__item__criticality_tab
    ____GA_Polygon__item__iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ____GA_Polygon__item__iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ____GA_Polygon__item__iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    _____GA_Polygon__item__iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____GA_Polygon__item__iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____GA_Polygon__item__iE_Extensions__item__extensionValue._const_tab = _____GA_Polygon__item__iE_Extensions__item__extensionValue_tab
    ____GA_Polygon__item__iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ____GA_Polygon__item__iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    ___GA_Polygon__item__iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ____GA_Polygon__item__iE_Extensions__item__id),
        (u'criticality', ____GA_Polygon__item__iE_Extensions__item__criticality),
        (u'extensionValue', ____GA_Polygon__item__iE_Extensions__item__extensionValue),
        ])
    ___GA_Polygon__item__iE_Extensions__item_._ext = None
    __GA_Polygon__item__iE_Extensions._cont = ___GA_Polygon__item__iE_Extensions__item_
    __GA_Polygon__item__iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    _GA_Polygon__item_._cont = ASN1Dict([
        (u'geographicalCoordinates', __GA_Polygon__item__geographicalCoordinates),
        (u'iE-Extensions', __GA_Polygon__item__iE_Extensions),
        ])
    _GA_Polygon__item_._ext = []
    GA_Polygon._cont = _GA_Polygon__item_
    GA_Polygon._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=15)], ev=None, er=[])
    
    #-----< GA-Polygon-ExtIEs >-----#
    GA_Polygon_ExtIEs = CLASS(name=u'GA-Polygon-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GA_Polygon_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GA-UncertaintyEllipse >-----#
    GA_UncertaintyEllipse = SEQ(name=u'GA-UncertaintyEllipse', mode=MODE_TYPE)
    _GA_UncertaintyEllipse_uncertaintySemi_major = INT(name=u'uncertaintySemi-major', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GA_UncertaintyEllipse_uncertaintySemi_major._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    _GA_UncertaintyEllipse_uncertaintySemi_minor = INT(name=u'uncertaintySemi-minor', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GA_UncertaintyEllipse_uncertaintySemi_minor._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    _GA_UncertaintyEllipse_orientationOfMajorAxis = INT(name=u'orientationOfMajorAxis', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GA_UncertaintyEllipse_orientationOfMajorAxis._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=89)], ev=None, er=[])
    GA_UncertaintyEllipse._cont = ASN1Dict([
        (u'uncertaintySemi-major', _GA_UncertaintyEllipse_uncertaintySemi_major),
        (u'uncertaintySemi-minor', _GA_UncertaintyEllipse_uncertaintySemi_minor),
        (u'orientationOfMajorAxis', _GA_UncertaintyEllipse_orientationOfMajorAxis),
        ])
    GA_UncertaintyEllipse._ext = []
    
    #-----< UE-PositionEstimateInfo >-----#
    UE_PositionEstimateInfo = SEQ(name=u'UE-PositionEstimateInfo', mode=MODE_TYPE)
    _UE_PositionEstimateInfo_referenceTimeChoice = CHOICE(name=u'referenceTimeChoice', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'ReferenceTimeChoice')))
    _UE_PositionEstimateInfo_ue_positionEstimate = CHOICE(name=u'ue-positionEstimate', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'UE-PositionEstimate')))
    _UE_PositionEstimateInfo_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __UE_PositionEstimateInfo_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___UE_PositionEstimateInfo_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____UE_PositionEstimateInfo_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____UE_PositionEstimateInfo_iE_Extensions__item__id_tab_val_Extension_0 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GPSReferenceTimeUncertainty')))
    _____UE_PositionEstimateInfo_iE_Extensions__item__id_tab_val_Extension_1 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'PositionDataUEbased')))
    ____UE_PositionEstimateInfo_iE_Extensions__item__id_tab._val = ASN1Set(rv=[dict([(u'id', 85), (u'criticality', u'ignore'), (u'Extension', _____UE_PositionEstimateInfo_iE_Extensions__item__id_tab_val_Extension_0), (u'presence', u'optional')]), dict([(u'id', 98), (u'criticality', u'ignore'), (u'Extension', _____UE_PositionEstimateInfo_iE_Extensions__item__id_tab_val_Extension_1), (u'presence', u'optional')])], rr=[], ev=None, er=[])
    ___UE_PositionEstimateInfo_iE_Extensions__item__id._const_tab = ____UE_PositionEstimateInfo_iE_Extensions__item__id_tab
    ___UE_PositionEstimateInfo_iE_Extensions__item__id._const_tab_at = None
    ___UE_PositionEstimateInfo_iE_Extensions__item__id._const_tab_id = u'id'
    ___UE_PositionEstimateInfo_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ___UE_PositionEstimateInfo_iE_Extensions__item__criticality._const_tab = ____UE_PositionEstimateInfo_iE_Extensions__item__id_tab
    ___UE_PositionEstimateInfo_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___UE_PositionEstimateInfo_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___UE_PositionEstimateInfo_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ___UE_PositionEstimateInfo_iE_Extensions__item__extensionValue._const_tab = ____UE_PositionEstimateInfo_iE_Extensions__item__id_tab
    ___UE_PositionEstimateInfo_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___UE_PositionEstimateInfo_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __UE_PositionEstimateInfo_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___UE_PositionEstimateInfo_iE_Extensions__item__id),
        (u'criticality', ___UE_PositionEstimateInfo_iE_Extensions__item__criticality),
        (u'extensionValue', ___UE_PositionEstimateInfo_iE_Extensions__item__extensionValue),
        ])
    __UE_PositionEstimateInfo_iE_Extensions__item_._ext = None
    _UE_PositionEstimateInfo_iE_Extensions._cont = __UE_PositionEstimateInfo_iE_Extensions__item_
    _UE_PositionEstimateInfo_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    UE_PositionEstimateInfo._cont = ASN1Dict([
        (u'referenceTimeChoice', _UE_PositionEstimateInfo_referenceTimeChoice),
        (u'ue-positionEstimate', _UE_PositionEstimateInfo_ue_positionEstimate),
        (u'iE-Extensions', _UE_PositionEstimateInfo_iE_Extensions),
        ])
    UE_PositionEstimateInfo._ext = []
    
    #-----< UE-PositionEstimateInfo-ExtIEs >-----#
    UE_PositionEstimateInfo_ExtIEs = CLASS(name=u'UE-PositionEstimateInfo-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _UE_PositionEstimateInfo_ExtIEs_val_Extension_0 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GPSReferenceTimeUncertainty')))
    _UE_PositionEstimateInfo_ExtIEs_val_Extension_1 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'PositionDataUEbased')))
    UE_PositionEstimateInfo_ExtIEs._val = ASN1Set(rv=[dict([(u'id', 85), (u'criticality', u'ignore'), (u'Extension', _UE_PositionEstimateInfo_ExtIEs_val_Extension_0), (u'presence', u'optional')]), dict([(u'id', 98), (u'criticality', u'ignore'), (u'Extension', _UE_PositionEstimateInfo_ExtIEs_val_Extension_1), (u'presence', u'optional')])], rr=[], ev=[], er=[])
    
    #-----< ReferenceTimeChoice >-----#
    ReferenceTimeChoice = CHOICE(name=u'ReferenceTimeChoice', mode=MODE_TYPE)
    _ReferenceTimeChoice_utran_GPSReferenceTimeResult = SEQ(name=u'utran-GPSReferenceTimeResult', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'UTRAN-GPSReferenceTimeResult')))
    _ReferenceTimeChoice_gps_ReferenceTimeOnly = INT(name=u'gps-ReferenceTimeOnly', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ReferenceTimeChoice_gps_ReferenceTimeOnly._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=604799999)], ev=[], er=[])
    _ReferenceTimeChoice_cell_Timing = SEQ(name=u'cell-Timing', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'Cell-Timing')))
    _ReferenceTimeChoice_extension_ReferenceTimeChoice = SEQ(name=u'extension-ReferenceTimeChoice', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'Extension-ReferenceTimeChoice')))
    ReferenceTimeChoice._cont = ASN1Dict([
        (u'utran-GPSReferenceTimeResult', _ReferenceTimeChoice_utran_GPSReferenceTimeResult),
        (u'gps-ReferenceTimeOnly', _ReferenceTimeChoice_gps_ReferenceTimeOnly),
        (u'cell-Timing', _ReferenceTimeChoice_cell_Timing),
        (u'extension-ReferenceTimeChoice', _ReferenceTimeChoice_extension_ReferenceTimeChoice),
        ])
    ReferenceTimeChoice._ext = [u'extension-ReferenceTimeChoice']
    
    #-----< Extension-ReferenceTimeChoice >-----#
    Extension_ReferenceTimeChoice = SEQ(name=u'Extension-ReferenceTimeChoice', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolIE-Single-Container')))
    _Extension_ReferenceTimeChoice_id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-IES'), [u'id']))
    __Extension_ReferenceTimeChoice_id_tab = CLASS(name='_tab_PCAP-PROTOCOL-IES', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-IES')))
    ___Extension_ReferenceTimeChoice_id_tab_val_Value_0 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'UTRAN-GANSSReferenceTimeResult')))
    ___Extension_ReferenceTimeChoice_id_tab_val_Value_1 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-Reference-Time-Only')))
    __Extension_ReferenceTimeChoice_id_tab._val = ASN1Set(rv=[dict([(u'id', 114), (u'criticality', u'ignore'), (u'Value', ___Extension_ReferenceTimeChoice_id_tab_val_Value_0), (u'presence', u'mandatory')]), dict([(u'id', 115), (u'criticality', u'ignore'), (u'Value', ___Extension_ReferenceTimeChoice_id_tab_val_Value_1), (u'presence', u'mandatory')])], rr=[], ev=None, er=[])
    _Extension_ReferenceTimeChoice_id._const_tab = __Extension_ReferenceTimeChoice_id_tab
    _Extension_ReferenceTimeChoice_id._const_tab_at = None
    _Extension_ReferenceTimeChoice_id._const_tab_id = u'id'
    _Extension_ReferenceTimeChoice_criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-IES'), [u'criticality']))
    _Extension_ReferenceTimeChoice_criticality._const_tab = __Extension_ReferenceTimeChoice_id_tab
    _Extension_ReferenceTimeChoice_criticality._const_tab_at = ('..', u'id')
    _Extension_ReferenceTimeChoice_criticality._const_tab_id = u'criticality'
    _Extension_ReferenceTimeChoice_value = OPEN(name=u'value', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-IES'), [u'Value']))
    _Extension_ReferenceTimeChoice_value._const_tab = __Extension_ReferenceTimeChoice_id_tab
    _Extension_ReferenceTimeChoice_value._const_tab_at = ('..', u'id')
    _Extension_ReferenceTimeChoice_value._const_tab_id = u'Value'
    Extension_ReferenceTimeChoice._cont = ASN1Dict([
        (u'id', _Extension_ReferenceTimeChoice_id),
        (u'criticality', _Extension_ReferenceTimeChoice_criticality),
        (u'value', _Extension_ReferenceTimeChoice_value),
        ])
    Extension_ReferenceTimeChoice._ext = None
    
    #-----< Extension-ReferenceTimeChoice-IE >-----#
    Extension_ReferenceTimeChoice_IE = CLASS(name=u'Extension-ReferenceTimeChoice-IE', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-IES')))
    _Extension_ReferenceTimeChoice_IE_val_Value_0 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'UTRAN-GANSSReferenceTimeResult')))
    _Extension_ReferenceTimeChoice_IE_val_Value_1 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-Reference-Time-Only')))
    Extension_ReferenceTimeChoice_IE._val = ASN1Set(rv=[dict([(u'id', 114), (u'criticality', u'ignore'), (u'Value', _Extension_ReferenceTimeChoice_IE_val_Value_0), (u'presence', u'mandatory')]), dict([(u'id', 115), (u'criticality', u'ignore'), (u'Value', _Extension_ReferenceTimeChoice_IE_val_Value_1), (u'presence', u'mandatory')])], rr=[], ev=None, er=[])
    
    #-----< Cell-Timing >-----#
    Cell_Timing = SEQ(name=u'Cell-Timing', mode=MODE_TYPE)
    _Cell_Timing_sfn = INT(name=u'sfn', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _Cell_Timing_sfn._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4095)], ev=None, er=[])
    _Cell_Timing_uC_ID = SEQ(name=u'uC-ID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'UC-ID')))
    _Cell_Timing_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __Cell_Timing_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___Cell_Timing_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____Cell_Timing_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____Cell_Timing_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___Cell_Timing_iE_Extensions__item__id._const_tab = ____Cell_Timing_iE_Extensions__item__id_tab
    ___Cell_Timing_iE_Extensions__item__id._const_tab_at = None
    ___Cell_Timing_iE_Extensions__item__id._const_tab_id = u'id'
    ___Cell_Timing_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____Cell_Timing_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____Cell_Timing_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___Cell_Timing_iE_Extensions__item__criticality._const_tab = ____Cell_Timing_iE_Extensions__item__criticality_tab
    ___Cell_Timing_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___Cell_Timing_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___Cell_Timing_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____Cell_Timing_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____Cell_Timing_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___Cell_Timing_iE_Extensions__item__extensionValue._const_tab = ____Cell_Timing_iE_Extensions__item__extensionValue_tab
    ___Cell_Timing_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___Cell_Timing_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __Cell_Timing_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___Cell_Timing_iE_Extensions__item__id),
        (u'criticality', ___Cell_Timing_iE_Extensions__item__criticality),
        (u'extensionValue', ___Cell_Timing_iE_Extensions__item__extensionValue),
        ])
    __Cell_Timing_iE_Extensions__item_._ext = None
    _Cell_Timing_iE_Extensions._cont = __Cell_Timing_iE_Extensions__item_
    _Cell_Timing_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    Cell_Timing._cont = ASN1Dict([
        (u'sfn', _Cell_Timing_sfn),
        (u'uC-ID', _Cell_Timing_uC_ID),
        (u'iE-Extensions', _Cell_Timing_iE_Extensions),
        ])
    Cell_Timing._ext = []
    
    #-----< Cell-Timing-ExtIEs >-----#
    Cell_Timing_ExtIEs = CLASS(name=u'Cell-Timing-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    Cell_Timing_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GANSS-Reference-Time-Only >-----#
    GANSS_Reference_Time_Only = SEQ(name=u'GANSS-Reference-Time-Only', mode=MODE_TYPE)
    _GANSS_Reference_Time_Only_ganssTODmsec = INT(name=u'ganssTODmsec', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_Reference_Time_Only_ganssTODmsec._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=3599999)], ev=None, er=[])
    _GANSS_Reference_Time_Only_ganssTimeID = SEQ(name=u'ganssTimeID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSSID')), opt=True)
    _GANSS_Reference_Time_Only_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GANSS_Reference_Time_Only_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GANSS_Reference_Time_Only_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GANSS_Reference_Time_Only_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_Reference_Time_Only_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_Reference_Time_Only_iE_Extensions__item__id._const_tab = ____GANSS_Reference_Time_Only_iE_Extensions__item__id_tab
    ___GANSS_Reference_Time_Only_iE_Extensions__item__id._const_tab_at = None
    ___GANSS_Reference_Time_Only_iE_Extensions__item__id._const_tab_id = u'id'
    ___GANSS_Reference_Time_Only_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GANSS_Reference_Time_Only_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_Reference_Time_Only_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_Reference_Time_Only_iE_Extensions__item__criticality._const_tab = ____GANSS_Reference_Time_Only_iE_Extensions__item__criticality_tab
    ___GANSS_Reference_Time_Only_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GANSS_Reference_Time_Only_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GANSS_Reference_Time_Only_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GANSS_Reference_Time_Only_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_Reference_Time_Only_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_Reference_Time_Only_iE_Extensions__item__extensionValue._const_tab = ____GANSS_Reference_Time_Only_iE_Extensions__item__extensionValue_tab
    ___GANSS_Reference_Time_Only_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GANSS_Reference_Time_Only_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GANSS_Reference_Time_Only_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GANSS_Reference_Time_Only_iE_Extensions__item__id),
        (u'criticality', ___GANSS_Reference_Time_Only_iE_Extensions__item__criticality),
        (u'extensionValue', ___GANSS_Reference_Time_Only_iE_Extensions__item__extensionValue),
        ])
    __GANSS_Reference_Time_Only_iE_Extensions__item_._ext = None
    _GANSS_Reference_Time_Only_iE_Extensions._cont = __GANSS_Reference_Time_Only_iE_Extensions__item_
    _GANSS_Reference_Time_Only_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GANSS_Reference_Time_Only._cont = ASN1Dict([
        (u'ganssTODmsec', _GANSS_Reference_Time_Only_ganssTODmsec),
        (u'ganssTimeID', _GANSS_Reference_Time_Only_ganssTimeID),
        (u'iE-Extensions', _GANSS_Reference_Time_Only_iE_Extensions),
        ])
    GANSS_Reference_Time_Only._ext = []
    
    #-----< GANSS-Reference-Time-Only-ExtIEs >-----#
    GANSS_Reference_Time_Only_ExtIEs = CLASS(name=u'GANSS-Reference-Time-Only-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GANSS_Reference_Time_Only_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< PositionDataUEbased >-----#
    PositionDataUEbased = SEQ(name=u'PositionDataUEbased', mode=MODE_TYPE)
    _PositionDataUEbased_positionData = BIT_STR(name=u'positionData', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _PositionDataUEbased_positionData._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _PositionDataUEbased_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __PositionDataUEbased_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___PositionDataUEbased_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____PositionDataUEbased_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____PositionDataUEbased_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___PositionDataUEbased_iE_Extensions__item__id._const_tab = ____PositionDataUEbased_iE_Extensions__item__id_tab
    ___PositionDataUEbased_iE_Extensions__item__id._const_tab_at = None
    ___PositionDataUEbased_iE_Extensions__item__id._const_tab_id = u'id'
    ___PositionDataUEbased_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____PositionDataUEbased_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____PositionDataUEbased_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___PositionDataUEbased_iE_Extensions__item__criticality._const_tab = ____PositionDataUEbased_iE_Extensions__item__criticality_tab
    ___PositionDataUEbased_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___PositionDataUEbased_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___PositionDataUEbased_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____PositionDataUEbased_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____PositionDataUEbased_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___PositionDataUEbased_iE_Extensions__item__extensionValue._const_tab = ____PositionDataUEbased_iE_Extensions__item__extensionValue_tab
    ___PositionDataUEbased_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___PositionDataUEbased_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __PositionDataUEbased_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___PositionDataUEbased_iE_Extensions__item__id),
        (u'criticality', ___PositionDataUEbased_iE_Extensions__item__criticality),
        (u'extensionValue', ___PositionDataUEbased_iE_Extensions__item__extensionValue),
        ])
    __PositionDataUEbased_iE_Extensions__item_._ext = None
    _PositionDataUEbased_iE_Extensions._cont = __PositionDataUEbased_iE_Extensions__item_
    _PositionDataUEbased_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    PositionDataUEbased._cont = ASN1Dict([
        (u'positionData', _PositionDataUEbased_positionData),
        (u'iE-Extensions', _PositionDataUEbased_iE_Extensions),
        ])
    PositionDataUEbased._ext = []
    
    #-----< PositionDataUEbased-ExtIEs >-----#
    PositionDataUEbased_ExtIEs = CLASS(name=u'PositionDataUEbased-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    PositionDataUEbased_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< PositionData >-----#
    PositionData = SEQ(name=u'PositionData', mode=MODE_TYPE)
    _PositionData_positioningDataDiscriminator = BIT_STR(name=u'positioningDataDiscriminator', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'PositioningDataDiscriminator')))
    _PositionData_positioningDataSet = SEQ_OF(name=u'positioningDataSet', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'PositioningDataSet')), opt=True)
    _PositionData_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __PositionData_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___PositionData_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____PositionData_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____PositionData_iE_Extensions__item__id_tab_val_Extension_0 = SEQ_OF(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-PositioningDataSet')))
    _____PositionData_iE_Extensions__item__id_tab_val_Extension_1 = SEQ_OF(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'Additional-PositioningDataSet')))
    ____PositionData_iE_Extensions__item__id_tab._val = ASN1Set(rv=[dict([(u'id', 74), (u'criticality', u'ignore'), (u'Extension', _____PositionData_iE_Extensions__item__id_tab_val_Extension_0), (u'presence', u'optional')]), dict([(u'id', 139), (u'criticality', u'ignore'), (u'Extension', _____PositionData_iE_Extensions__item__id_tab_val_Extension_1), (u'presence', u'optional')])], rr=[], ev=None, er=[])
    ___PositionData_iE_Extensions__item__id._const_tab = ____PositionData_iE_Extensions__item__id_tab
    ___PositionData_iE_Extensions__item__id._const_tab_at = None
    ___PositionData_iE_Extensions__item__id._const_tab_id = u'id'
    ___PositionData_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ___PositionData_iE_Extensions__item__criticality._const_tab = ____PositionData_iE_Extensions__item__id_tab
    ___PositionData_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___PositionData_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___PositionData_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ___PositionData_iE_Extensions__item__extensionValue._const_tab = ____PositionData_iE_Extensions__item__id_tab
    ___PositionData_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___PositionData_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __PositionData_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___PositionData_iE_Extensions__item__id),
        (u'criticality', ___PositionData_iE_Extensions__item__criticality),
        (u'extensionValue', ___PositionData_iE_Extensions__item__extensionValue),
        ])
    __PositionData_iE_Extensions__item_._ext = None
    _PositionData_iE_Extensions._cont = __PositionData_iE_Extensions__item_
    _PositionData_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    PositionData._cont = ASN1Dict([
        (u'positioningDataDiscriminator', _PositionData_positioningDataDiscriminator),
        (u'positioningDataSet', _PositionData_positioningDataSet),
        (u'iE-Extensions', _PositionData_iE_Extensions),
        ])
    PositionData._ext = []
    
    #-----< PositionData-ExtIEs >-----#
    PositionData_ExtIEs = CLASS(name=u'PositionData-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _PositionData_ExtIEs_val_Extension_0 = SEQ_OF(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-PositioningDataSet')))
    _PositionData_ExtIEs_val_Extension_1 = SEQ_OF(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'Additional-PositioningDataSet')))
    PositionData_ExtIEs._val = ASN1Set(rv=[dict([(u'id', 74), (u'criticality', u'ignore'), (u'Extension', _PositionData_ExtIEs_val_Extension_0), (u'presence', u'optional')]), dict([(u'id', 139), (u'criticality', u'ignore'), (u'Extension', _PositionData_ExtIEs_val_Extension_1), (u'presence', u'optional')])], rr=[], ev=[], er=[])
    
    #-----< GANSS-PositioningDataSet >-----#
    GANSS_PositioningDataSet = SEQ_OF(name=u'GANSS-PositioningDataSet', mode=MODE_TYPE)
    _GANSS_PositioningDataSet__item_ = OCT_STR(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-PositioningMethodAndUsage')))
    GANSS_PositioningDataSet._cont = _GANSS_PositioningDataSet__item_
    GANSS_PositioningDataSet._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=9)], ev=None, er=[])
    
    #-----< GANSS-PositioningMethodAndUsage >-----#
    GANSS_PositioningMethodAndUsage = OCT_STR(name=u'GANSS-PositioningMethodAndUsage', mode=MODE_TYPE)
    GANSS_PositioningMethodAndUsage._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< PositioningDataDiscriminator >-----#
    PositioningDataDiscriminator = BIT_STR(name=u'PositioningDataDiscriminator', mode=MODE_TYPE)
    PositioningDataDiscriminator._const_sz = ASN1Set(rv=[4], rr=[], ev=None, er=[])
    
    #-----< PositioningDataSet >-----#
    PositioningDataSet = SEQ_OF(name=u'PositioningDataSet', mode=MODE_TYPE)
    _PositioningDataSet__item_ = OCT_STR(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'PositioningMethodAndUsage')))
    PositioningDataSet._cont = _PositioningDataSet__item_
    PositioningDataSet._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=9)], ev=None, er=[])
    
    #-----< PositioningMethodAndUsage >-----#
    PositioningMethodAndUsage = OCT_STR(name=u'PositioningMethodAndUsage', mode=MODE_TYPE)
    PositioningMethodAndUsage._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< Additional-PositioningDataSet >-----#
    Additional_PositioningDataSet = SEQ_OF(name=u'Additional-PositioningDataSet', mode=MODE_TYPE)
    _Additional_PositioningDataSet__item_ = OCT_STR(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'Additional-PositioningMethodAndUsage')))
    Additional_PositioningDataSet._cont = _Additional_PositioningDataSet__item_
    Additional_PositioningDataSet._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    
    #-----< Additional-PositioningMethodAndUsage >-----#
    Additional_PositioningMethodAndUsage = OCT_STR(name=u'Additional-PositioningMethodAndUsage', mode=MODE_TYPE)
    Additional_PositioningMethodAndUsage._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< GPS-AcquisitionAssistance >-----#
    GPS_AcquisitionAssistance = SEQ(name=u'GPS-AcquisitionAssistance', mode=MODE_TYPE)
    _GPS_AcquisitionAssistance_gps_TOW_1msec = INT(name=u'gps-TOW-1msec', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_AcquisitionAssistance_gps_TOW_1msec._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=604799999)], ev=None, er=[])
    _GPS_AcquisitionAssistance_satelliteInformationList = SEQ_OF(name=u'satelliteInformationList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'AcquisitionSatInfoList')))
    _GPS_AcquisitionAssistance_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GPS_AcquisitionAssistance_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GPS_AcquisitionAssistance_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GPS_AcquisitionAssistance_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____GPS_AcquisitionAssistance_iE_Extensions__item__id_tab_val_Extension_0 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'UTRAN-GPSReferenceTime')))
    _____GPS_AcquisitionAssistance_iE_Extensions__item__id_tab_val_Extension_1 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GPSReferenceTimeUncertainty')))
    _____GPS_AcquisitionAssistance_iE_Extensions__item__id_tab_val_Extension_2 = INT(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'Confidence')))
    ____GPS_AcquisitionAssistance_iE_Extensions__item__id_tab._val = ASN1Set(rv=[dict([(u'id', 46), (u'criticality', u'ignore'), (u'Extension', _____GPS_AcquisitionAssistance_iE_Extensions__item__id_tab_val_Extension_0), (u'presence', u'optional')]), dict([(u'id', 85), (u'criticality', u'ignore'), (u'Extension', _____GPS_AcquisitionAssistance_iE_Extensions__item__id_tab_val_Extension_1), (u'presence', u'optional')]), dict([(u'id', 135), (u'criticality', u'ignore'), (u'Extension', _____GPS_AcquisitionAssistance_iE_Extensions__item__id_tab_val_Extension_2), (u'presence', u'optional')])], rr=[], ev=None, er=[])
    ___GPS_AcquisitionAssistance_iE_Extensions__item__id._const_tab = ____GPS_AcquisitionAssistance_iE_Extensions__item__id_tab
    ___GPS_AcquisitionAssistance_iE_Extensions__item__id._const_tab_at = None
    ___GPS_AcquisitionAssistance_iE_Extensions__item__id._const_tab_id = u'id'
    ___GPS_AcquisitionAssistance_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ___GPS_AcquisitionAssistance_iE_Extensions__item__criticality._const_tab = ____GPS_AcquisitionAssistance_iE_Extensions__item__id_tab
    ___GPS_AcquisitionAssistance_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GPS_AcquisitionAssistance_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GPS_AcquisitionAssistance_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ___GPS_AcquisitionAssistance_iE_Extensions__item__extensionValue._const_tab = ____GPS_AcquisitionAssistance_iE_Extensions__item__id_tab
    ___GPS_AcquisitionAssistance_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GPS_AcquisitionAssistance_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GPS_AcquisitionAssistance_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GPS_AcquisitionAssistance_iE_Extensions__item__id),
        (u'criticality', ___GPS_AcquisitionAssistance_iE_Extensions__item__criticality),
        (u'extensionValue', ___GPS_AcquisitionAssistance_iE_Extensions__item__extensionValue),
        ])
    __GPS_AcquisitionAssistance_iE_Extensions__item_._ext = None
    _GPS_AcquisitionAssistance_iE_Extensions._cont = __GPS_AcquisitionAssistance_iE_Extensions__item_
    _GPS_AcquisitionAssistance_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GPS_AcquisitionAssistance._cont = ASN1Dict([
        (u'gps-TOW-1msec', _GPS_AcquisitionAssistance_gps_TOW_1msec),
        (u'satelliteInformationList', _GPS_AcquisitionAssistance_satelliteInformationList),
        (u'iE-Extensions', _GPS_AcquisitionAssistance_iE_Extensions),
        ])
    GPS_AcquisitionAssistance._ext = []
    
    #-----< GPS-AcquisitionAssistance-ExtIEs >-----#
    GPS_AcquisitionAssistance_ExtIEs = CLASS(name=u'GPS-AcquisitionAssistance-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _GPS_AcquisitionAssistance_ExtIEs_val_Extension_0 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'UTRAN-GPSReferenceTime')))
    _GPS_AcquisitionAssistance_ExtIEs_val_Extension_1 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GPSReferenceTimeUncertainty')))
    _GPS_AcquisitionAssistance_ExtIEs_val_Extension_2 = INT(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'Confidence')))
    GPS_AcquisitionAssistance_ExtIEs._val = ASN1Set(rv=[dict([(u'id', 46), (u'criticality', u'ignore'), (u'Extension', _GPS_AcquisitionAssistance_ExtIEs_val_Extension_0), (u'presence', u'optional')]), dict([(u'id', 85), (u'criticality', u'ignore'), (u'Extension', _GPS_AcquisitionAssistance_ExtIEs_val_Extension_1), (u'presence', u'optional')]), dict([(u'id', 135), (u'criticality', u'ignore'), (u'Extension', _GPS_AcquisitionAssistance_ExtIEs_val_Extension_2), (u'presence', u'optional')])], rr=[], ev=[], er=[])
    
    #-----< AcquisitionSatInfoList >-----#
    AcquisitionSatInfoList = SEQ_OF(name=u'AcquisitionSatInfoList', mode=MODE_TYPE)
    _AcquisitionSatInfoList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'AcquisitionSatInfo')))
    AcquisitionSatInfoList._cont = _AcquisitionSatInfoList__item_
    AcquisitionSatInfoList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    
    #-----< AcquisitionSatInfo >-----#
    AcquisitionSatInfo = SEQ(name=u'AcquisitionSatInfo', mode=MODE_TYPE)
    _AcquisitionSatInfo_satID = INT(name=u'satID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AcquisitionSatInfo_satID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    _AcquisitionSatInfo_doppler0thOrder = INT(name=u'doppler0thOrder', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AcquisitionSatInfo_doppler0thOrder._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-2048, ub=2047)], ev=None, er=[])
    _AcquisitionSatInfo_extraDopplerInfo = SEQ(name=u'extraDopplerInfo', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'ExtraDopplerInfo')), opt=True)
    _AcquisitionSatInfo_codePhase = INT(name=u'codePhase', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AcquisitionSatInfo_codePhase._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=1022)], ev=None, er=[])
    _AcquisitionSatInfo_integerCodePhase = INT(name=u'integerCodePhase', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AcquisitionSatInfo_integerCodePhase._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=19)], ev=None, er=[])
    _AcquisitionSatInfo_gps_BitNumber = INT(name=u'gps-BitNumber', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AcquisitionSatInfo_gps_BitNumber._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=3)], ev=None, er=[])
    _AcquisitionSatInfo_codePhaseSearchWindow = ENUM(name=u'codePhaseSearchWindow', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'CodePhaseSearchWindow')))
    _AcquisitionSatInfo_azimuthAndElevation = SEQ(name=u'azimuthAndElevation', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'AzimuthAndElevation')), opt=True)
    _AcquisitionSatInfo_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __AcquisitionSatInfo_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___AcquisitionSatInfo_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____AcquisitionSatInfo_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____AcquisitionSatInfo_iE_Extensions__item__id_tab_val_Extension_0 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'ExtraDopplerInfoExtension')))
    ____AcquisitionSatInfo_iE_Extensions__item__id_tab._val = ASN1Set(rv=[dict([(u'id', 136), (u'criticality', u'ignore'), (u'Extension', _____AcquisitionSatInfo_iE_Extensions__item__id_tab_val_Extension_0), (u'presence', u'optional')])], rr=[], ev=None, er=[])
    ___AcquisitionSatInfo_iE_Extensions__item__id._const_tab = ____AcquisitionSatInfo_iE_Extensions__item__id_tab
    ___AcquisitionSatInfo_iE_Extensions__item__id._const_tab_at = None
    ___AcquisitionSatInfo_iE_Extensions__item__id._const_tab_id = u'id'
    ___AcquisitionSatInfo_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ___AcquisitionSatInfo_iE_Extensions__item__criticality._const_tab = ____AcquisitionSatInfo_iE_Extensions__item__id_tab
    ___AcquisitionSatInfo_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___AcquisitionSatInfo_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___AcquisitionSatInfo_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ___AcquisitionSatInfo_iE_Extensions__item__extensionValue._const_tab = ____AcquisitionSatInfo_iE_Extensions__item__id_tab
    ___AcquisitionSatInfo_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___AcquisitionSatInfo_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __AcquisitionSatInfo_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___AcquisitionSatInfo_iE_Extensions__item__id),
        (u'criticality', ___AcquisitionSatInfo_iE_Extensions__item__criticality),
        (u'extensionValue', ___AcquisitionSatInfo_iE_Extensions__item__extensionValue),
        ])
    __AcquisitionSatInfo_iE_Extensions__item_._ext = None
    _AcquisitionSatInfo_iE_Extensions._cont = __AcquisitionSatInfo_iE_Extensions__item_
    _AcquisitionSatInfo_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    AcquisitionSatInfo._cont = ASN1Dict([
        (u'satID', _AcquisitionSatInfo_satID),
        (u'doppler0thOrder', _AcquisitionSatInfo_doppler0thOrder),
        (u'extraDopplerInfo', _AcquisitionSatInfo_extraDopplerInfo),
        (u'codePhase', _AcquisitionSatInfo_codePhase),
        (u'integerCodePhase', _AcquisitionSatInfo_integerCodePhase),
        (u'gps-BitNumber', _AcquisitionSatInfo_gps_BitNumber),
        (u'codePhaseSearchWindow', _AcquisitionSatInfo_codePhaseSearchWindow),
        (u'azimuthAndElevation', _AcquisitionSatInfo_azimuthAndElevation),
        (u'iE-Extensions', _AcquisitionSatInfo_iE_Extensions),
        ])
    AcquisitionSatInfo._ext = []
    
    #-----< AcquisitionSatInfo-ExtIEs >-----#
    AcquisitionSatInfo_ExtIEs = CLASS(name=u'AcquisitionSatInfo-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _AcquisitionSatInfo_ExtIEs_val_Extension_0 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'ExtraDopplerInfoExtension')))
    AcquisitionSatInfo_ExtIEs._val = ASN1Set(rv=[dict([(u'id', 136), (u'criticality', u'ignore'), (u'Extension', _AcquisitionSatInfo_ExtIEs_val_Extension_0), (u'presence', u'optional')])], rr=[], ev=[], er=[])
    
    #-----< ExtraDopplerInfo >-----#
    ExtraDopplerInfo = SEQ(name=u'ExtraDopplerInfo', mode=MODE_TYPE)
    _ExtraDopplerInfo_doppler1stOrder = INT(name=u'doppler1stOrder', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ExtraDopplerInfo_doppler1stOrder._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-42, ub=21)], ev=None, er=[])
    _ExtraDopplerInfo_dopplerUncertainty = ENUM(name=u'dopplerUncertainty', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'DopplerUncertainty')))
    _ExtraDopplerInfo_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __ExtraDopplerInfo_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___ExtraDopplerInfo_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____ExtraDopplerInfo_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____ExtraDopplerInfo_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___ExtraDopplerInfo_iE_Extensions__item__id._const_tab = ____ExtraDopplerInfo_iE_Extensions__item__id_tab
    ___ExtraDopplerInfo_iE_Extensions__item__id._const_tab_at = None
    ___ExtraDopplerInfo_iE_Extensions__item__id._const_tab_id = u'id'
    ___ExtraDopplerInfo_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____ExtraDopplerInfo_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____ExtraDopplerInfo_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___ExtraDopplerInfo_iE_Extensions__item__criticality._const_tab = ____ExtraDopplerInfo_iE_Extensions__item__criticality_tab
    ___ExtraDopplerInfo_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___ExtraDopplerInfo_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___ExtraDopplerInfo_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____ExtraDopplerInfo_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____ExtraDopplerInfo_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___ExtraDopplerInfo_iE_Extensions__item__extensionValue._const_tab = ____ExtraDopplerInfo_iE_Extensions__item__extensionValue_tab
    ___ExtraDopplerInfo_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___ExtraDopplerInfo_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __ExtraDopplerInfo_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___ExtraDopplerInfo_iE_Extensions__item__id),
        (u'criticality', ___ExtraDopplerInfo_iE_Extensions__item__criticality),
        (u'extensionValue', ___ExtraDopplerInfo_iE_Extensions__item__extensionValue),
        ])
    __ExtraDopplerInfo_iE_Extensions__item_._ext = None
    _ExtraDopplerInfo_iE_Extensions._cont = __ExtraDopplerInfo_iE_Extensions__item_
    _ExtraDopplerInfo_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    ExtraDopplerInfo._cont = ASN1Dict([
        (u'doppler1stOrder', _ExtraDopplerInfo_doppler1stOrder),
        (u'dopplerUncertainty', _ExtraDopplerInfo_dopplerUncertainty),
        (u'iE-Extensions', _ExtraDopplerInfo_iE_Extensions),
        ])
    ExtraDopplerInfo._ext = []
    
    #-----< ExtraDopplerInfo-ExtIEs >-----#
    ExtraDopplerInfo_ExtIEs = CLASS(name=u'ExtraDopplerInfo-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ExtraDopplerInfo_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< ExtraDopplerInfoExtension >-----#
    ExtraDopplerInfoExtension = SEQ(name=u'ExtraDopplerInfoExtension', mode=MODE_TYPE)
    _ExtraDopplerInfoExtension_doppler1stOrder = INT(name=u'doppler1stOrder', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ExtraDopplerInfoExtension_doppler1stOrder._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-42, ub=21)], ev=None, er=[])
    _ExtraDopplerInfoExtension_dopplerUncertaintyExtension = ENUM(name=u'dopplerUncertaintyExtension', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'DopplerUncertaintyExtension')))
    _ExtraDopplerInfoExtension_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __ExtraDopplerInfoExtension_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___ExtraDopplerInfoExtension_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____ExtraDopplerInfoExtension_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____ExtraDopplerInfoExtension_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___ExtraDopplerInfoExtension_iE_Extensions__item__id._const_tab = ____ExtraDopplerInfoExtension_iE_Extensions__item__id_tab
    ___ExtraDopplerInfoExtension_iE_Extensions__item__id._const_tab_at = None
    ___ExtraDopplerInfoExtension_iE_Extensions__item__id._const_tab_id = u'id'
    ___ExtraDopplerInfoExtension_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____ExtraDopplerInfoExtension_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____ExtraDopplerInfoExtension_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___ExtraDopplerInfoExtension_iE_Extensions__item__criticality._const_tab = ____ExtraDopplerInfoExtension_iE_Extensions__item__criticality_tab
    ___ExtraDopplerInfoExtension_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___ExtraDopplerInfoExtension_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___ExtraDopplerInfoExtension_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____ExtraDopplerInfoExtension_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____ExtraDopplerInfoExtension_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___ExtraDopplerInfoExtension_iE_Extensions__item__extensionValue._const_tab = ____ExtraDopplerInfoExtension_iE_Extensions__item__extensionValue_tab
    ___ExtraDopplerInfoExtension_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___ExtraDopplerInfoExtension_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __ExtraDopplerInfoExtension_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___ExtraDopplerInfoExtension_iE_Extensions__item__id),
        (u'criticality', ___ExtraDopplerInfoExtension_iE_Extensions__item__criticality),
        (u'extensionValue', ___ExtraDopplerInfoExtension_iE_Extensions__item__extensionValue),
        ])
    __ExtraDopplerInfoExtension_iE_Extensions__item_._ext = None
    _ExtraDopplerInfoExtension_iE_Extensions._cont = __ExtraDopplerInfoExtension_iE_Extensions__item_
    _ExtraDopplerInfoExtension_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    ExtraDopplerInfoExtension._cont = ASN1Dict([
        (u'doppler1stOrder', _ExtraDopplerInfoExtension_doppler1stOrder),
        (u'dopplerUncertaintyExtension', _ExtraDopplerInfoExtension_dopplerUncertaintyExtension),
        (u'iE-Extensions', _ExtraDopplerInfoExtension_iE_Extensions),
        ])
    ExtraDopplerInfoExtension._ext = []
    
    #-----< ExtraDopplerInfoExtension-ExtIEs >-----#
    ExtraDopplerInfoExtension_ExtIEs = CLASS(name=u'ExtraDopplerInfoExtension-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ExtraDopplerInfoExtension_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< DopplerUncertainty >-----#
    DopplerUncertainty = ENUM(name=u'DopplerUncertainty', mode=MODE_TYPE)
    DopplerUncertainty._cont = ASN1Dict([(u'hz12-5', 0), (u'hz25', 1), (u'hz50', 2), (u'hz100', 3), (u'hz200', 4)])
    DopplerUncertainty._ext = []
    
    #-----< DopplerUncertaintyExtension >-----#
    DopplerUncertaintyExtension = ENUM(name=u'DopplerUncertaintyExtension', mode=MODE_TYPE)
    DopplerUncertaintyExtension._cont = ASN1Dict([(u'hz300', 0), (u'hz400', 1), (u'hz500', 2), (u'hz600', 3), (u'noInformation', 4)])
    DopplerUncertaintyExtension._ext = []
    
    #-----< CodePhaseSearchWindow >-----#
    CodePhaseSearchWindow = ENUM(name=u'CodePhaseSearchWindow', mode=MODE_TYPE)
    CodePhaseSearchWindow._cont = ASN1Dict([(u'w1023', 0), (u'w1', 1), (u'w2', 2), (u'w3', 3), (u'w4', 4), (u'w6', 5), (u'w8', 6), (u'w12', 7), (u'w16', 8), (u'w24', 9), (u'w32', 10), (u'w48', 11), (u'w64', 12), (u'w96', 13), (u'w128', 14), (u'w192', 15)])
    CodePhaseSearchWindow._ext = None
    
    #-----< AzimuthAndElevation >-----#
    AzimuthAndElevation = SEQ(name=u'AzimuthAndElevation', mode=MODE_TYPE)
    _AzimuthAndElevation_azimuth = INT(name=u'azimuth', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AzimuthAndElevation_azimuth._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=31)], ev=None, er=[])
    _AzimuthAndElevation_elevation = INT(name=u'elevation', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AzimuthAndElevation_elevation._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=7)], ev=None, er=[])
    _AzimuthAndElevation_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __AzimuthAndElevation_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___AzimuthAndElevation_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____AzimuthAndElevation_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____AzimuthAndElevation_iE_Extensions__item__id_tab_val_Extension_0 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'AzimuthAndElevationLSB')))
    ____AzimuthAndElevation_iE_Extensions__item__id_tab._val = ASN1Set(rv=[dict([(u'id', 119), (u'criticality', u'ignore'), (u'Extension', _____AzimuthAndElevation_iE_Extensions__item__id_tab_val_Extension_0), (u'presence', u'optional')])], rr=[], ev=None, er=[])
    ___AzimuthAndElevation_iE_Extensions__item__id._const_tab = ____AzimuthAndElevation_iE_Extensions__item__id_tab
    ___AzimuthAndElevation_iE_Extensions__item__id._const_tab_at = None
    ___AzimuthAndElevation_iE_Extensions__item__id._const_tab_id = u'id'
    ___AzimuthAndElevation_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ___AzimuthAndElevation_iE_Extensions__item__criticality._const_tab = ____AzimuthAndElevation_iE_Extensions__item__id_tab
    ___AzimuthAndElevation_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___AzimuthAndElevation_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___AzimuthAndElevation_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ___AzimuthAndElevation_iE_Extensions__item__extensionValue._const_tab = ____AzimuthAndElevation_iE_Extensions__item__id_tab
    ___AzimuthAndElevation_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___AzimuthAndElevation_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __AzimuthAndElevation_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___AzimuthAndElevation_iE_Extensions__item__id),
        (u'criticality', ___AzimuthAndElevation_iE_Extensions__item__criticality),
        (u'extensionValue', ___AzimuthAndElevation_iE_Extensions__item__extensionValue),
        ])
    __AzimuthAndElevation_iE_Extensions__item_._ext = None
    _AzimuthAndElevation_iE_Extensions._cont = __AzimuthAndElevation_iE_Extensions__item_
    _AzimuthAndElevation_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    AzimuthAndElevation._cont = ASN1Dict([
        (u'azimuth', _AzimuthAndElevation_azimuth),
        (u'elevation', _AzimuthAndElevation_elevation),
        (u'iE-Extensions', _AzimuthAndElevation_iE_Extensions),
        ])
    AzimuthAndElevation._ext = []
    
    #-----< AzimuthAndElevation-ExtIEs >-----#
    AzimuthAndElevation_ExtIEs = CLASS(name=u'AzimuthAndElevation-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _AzimuthAndElevation_ExtIEs_val_Extension_0 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'AzimuthAndElevationLSB')))
    AzimuthAndElevation_ExtIEs._val = ASN1Set(rv=[dict([(u'id', 119), (u'criticality', u'ignore'), (u'Extension', _AzimuthAndElevation_ExtIEs_val_Extension_0), (u'presence', u'optional')])], rr=[], ev=[], er=[])
    
    #-----< AzimuthAndElevationLSB >-----#
    AzimuthAndElevationLSB = SEQ(name=u'AzimuthAndElevationLSB', mode=MODE_TYPE)
    _AzimuthAndElevationLSB_azimuthLSB = INT(name=u'azimuthLSB', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AzimuthAndElevationLSB_azimuthLSB._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=15)], ev=None, er=[])
    _AzimuthAndElevationLSB_elevationLSB = INT(name=u'elevationLSB', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AzimuthAndElevationLSB_elevationLSB._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=15)], ev=None, er=[])
    _AzimuthAndElevationLSB_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __AzimuthAndElevationLSB_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___AzimuthAndElevationLSB_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____AzimuthAndElevationLSB_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____AzimuthAndElevationLSB_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___AzimuthAndElevationLSB_iE_Extensions__item__id._const_tab = ____AzimuthAndElevationLSB_iE_Extensions__item__id_tab
    ___AzimuthAndElevationLSB_iE_Extensions__item__id._const_tab_at = None
    ___AzimuthAndElevationLSB_iE_Extensions__item__id._const_tab_id = u'id'
    ___AzimuthAndElevationLSB_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____AzimuthAndElevationLSB_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____AzimuthAndElevationLSB_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___AzimuthAndElevationLSB_iE_Extensions__item__criticality._const_tab = ____AzimuthAndElevationLSB_iE_Extensions__item__criticality_tab
    ___AzimuthAndElevationLSB_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___AzimuthAndElevationLSB_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___AzimuthAndElevationLSB_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____AzimuthAndElevationLSB_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____AzimuthAndElevationLSB_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___AzimuthAndElevationLSB_iE_Extensions__item__extensionValue._const_tab = ____AzimuthAndElevationLSB_iE_Extensions__item__extensionValue_tab
    ___AzimuthAndElevationLSB_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___AzimuthAndElevationLSB_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __AzimuthAndElevationLSB_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___AzimuthAndElevationLSB_iE_Extensions__item__id),
        (u'criticality', ___AzimuthAndElevationLSB_iE_Extensions__item__criticality),
        (u'extensionValue', ___AzimuthAndElevationLSB_iE_Extensions__item__extensionValue),
        ])
    __AzimuthAndElevationLSB_iE_Extensions__item_._ext = None
    _AzimuthAndElevationLSB_iE_Extensions._cont = __AzimuthAndElevationLSB_iE_Extensions__item_
    _AzimuthAndElevationLSB_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    AzimuthAndElevationLSB._cont = ASN1Dict([
        (u'azimuthLSB', _AzimuthAndElevationLSB_azimuthLSB),
        (u'elevationLSB', _AzimuthAndElevationLSB_elevationLSB),
        (u'iE-Extensions', _AzimuthAndElevationLSB_iE_Extensions),
        ])
    AzimuthAndElevationLSB._ext = []
    
    #-----< AzimuthAndElevationLSB-ExtIEs >-----#
    AzimuthAndElevationLSB_ExtIEs = CLASS(name=u'AzimuthAndElevationLSB-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    AzimuthAndElevationLSB_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< Confidence >-----#
    Confidence = INT(name=u'Confidence', mode=MODE_TYPE)
    Confidence._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=100)], ev=None, er=[])
    
    #-----< AuxInfoGANSS-ID1 >-----#
    AuxInfoGANSS_ID1 = SEQ_OF(name=u'AuxInfoGANSS-ID1', mode=MODE_TYPE)
    _AuxInfoGANSS_ID1__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'AuxInfoGANSS-ID1-element')))
    AuxInfoGANSS_ID1._cont = _AuxInfoGANSS_ID1__item_
    AuxInfoGANSS_ID1._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    
    #-----< AuxInfoGANSS-ID1-element >-----#
    AuxInfoGANSS_ID1_element = SEQ(name=u'AuxInfoGANSS-ID1-element', mode=MODE_TYPE)
    _AuxInfoGANSS_ID1_element_svID = INT(name=u'svID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AuxInfoGANSS_ID1_element_svID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    _AuxInfoGANSS_ID1_element_signalsAvailable = BIT_STR(name=u'signalsAvailable', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AuxInfoGANSS_ID1_element_signalsAvailable._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _AuxInfoGANSS_ID1_element_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __AuxInfoGANSS_ID1_element_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___AuxInfoGANSS_ID1_element_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____AuxInfoGANSS_ID1_element_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____AuxInfoGANSS_ID1_element_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___AuxInfoGANSS_ID1_element_ie_Extensions__item__id._const_tab = ____AuxInfoGANSS_ID1_element_ie_Extensions__item__id_tab
    ___AuxInfoGANSS_ID1_element_ie_Extensions__item__id._const_tab_at = None
    ___AuxInfoGANSS_ID1_element_ie_Extensions__item__id._const_tab_id = u'id'
    ___AuxInfoGANSS_ID1_element_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____AuxInfoGANSS_ID1_element_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____AuxInfoGANSS_ID1_element_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___AuxInfoGANSS_ID1_element_ie_Extensions__item__criticality._const_tab = ____AuxInfoGANSS_ID1_element_ie_Extensions__item__criticality_tab
    ___AuxInfoGANSS_ID1_element_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___AuxInfoGANSS_ID1_element_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___AuxInfoGANSS_ID1_element_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____AuxInfoGANSS_ID1_element_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____AuxInfoGANSS_ID1_element_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___AuxInfoGANSS_ID1_element_ie_Extensions__item__extensionValue._const_tab = ____AuxInfoGANSS_ID1_element_ie_Extensions__item__extensionValue_tab
    ___AuxInfoGANSS_ID1_element_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___AuxInfoGANSS_ID1_element_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __AuxInfoGANSS_ID1_element_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___AuxInfoGANSS_ID1_element_ie_Extensions__item__id),
        (u'criticality', ___AuxInfoGANSS_ID1_element_ie_Extensions__item__criticality),
        (u'extensionValue', ___AuxInfoGANSS_ID1_element_ie_Extensions__item__extensionValue),
        ])
    __AuxInfoGANSS_ID1_element_ie_Extensions__item_._ext = None
    _AuxInfoGANSS_ID1_element_ie_Extensions._cont = __AuxInfoGANSS_ID1_element_ie_Extensions__item_
    _AuxInfoGANSS_ID1_element_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    AuxInfoGANSS_ID1_element._cont = ASN1Dict([
        (u'svID', _AuxInfoGANSS_ID1_element_svID),
        (u'signalsAvailable', _AuxInfoGANSS_ID1_element_signalsAvailable),
        (u'ie-Extensions', _AuxInfoGANSS_ID1_element_ie_Extensions),
        ])
    AuxInfoGANSS_ID1_element._ext = []
    
    #-----< AuxInfoGANSS-ID1-element-ExtIEs >-----#
    AuxInfoGANSS_ID1_element_ExtIEs = CLASS(name=u'AuxInfoGANSS-ID1-element-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    AuxInfoGANSS_ID1_element_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< AuxInfoGANSS-ID3 >-----#
    AuxInfoGANSS_ID3 = SEQ_OF(name=u'AuxInfoGANSS-ID3', mode=MODE_TYPE)
    _AuxInfoGANSS_ID3__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'AuxInfoGANSS-ID3-element')))
    AuxInfoGANSS_ID3._cont = _AuxInfoGANSS_ID3__item_
    AuxInfoGANSS_ID3._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    
    #-----< AuxInfoGANSS-ID3-element >-----#
    AuxInfoGANSS_ID3_element = SEQ(name=u'AuxInfoGANSS-ID3-element', mode=MODE_TYPE)
    _AuxInfoGANSS_ID3_element_svID = INT(name=u'svID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AuxInfoGANSS_ID3_element_svID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    _AuxInfoGANSS_ID3_element_signalsAvailable = BIT_STR(name=u'signalsAvailable', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AuxInfoGANSS_ID3_element_signalsAvailable._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _AuxInfoGANSS_ID3_element_channelNumber = INT(name=u'channelNumber', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AuxInfoGANSS_ID3_element_channelNumber._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-7, ub=13)], ev=None, er=[])
    _AuxInfoGANSS_ID3_element_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __AuxInfoGANSS_ID3_element_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___AuxInfoGANSS_ID3_element_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____AuxInfoGANSS_ID3_element_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____AuxInfoGANSS_ID3_element_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___AuxInfoGANSS_ID3_element_ie_Extensions__item__id._const_tab = ____AuxInfoGANSS_ID3_element_ie_Extensions__item__id_tab
    ___AuxInfoGANSS_ID3_element_ie_Extensions__item__id._const_tab_at = None
    ___AuxInfoGANSS_ID3_element_ie_Extensions__item__id._const_tab_id = u'id'
    ___AuxInfoGANSS_ID3_element_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____AuxInfoGANSS_ID3_element_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____AuxInfoGANSS_ID3_element_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___AuxInfoGANSS_ID3_element_ie_Extensions__item__criticality._const_tab = ____AuxInfoGANSS_ID3_element_ie_Extensions__item__criticality_tab
    ___AuxInfoGANSS_ID3_element_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___AuxInfoGANSS_ID3_element_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___AuxInfoGANSS_ID3_element_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____AuxInfoGANSS_ID3_element_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____AuxInfoGANSS_ID3_element_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___AuxInfoGANSS_ID3_element_ie_Extensions__item__extensionValue._const_tab = ____AuxInfoGANSS_ID3_element_ie_Extensions__item__extensionValue_tab
    ___AuxInfoGANSS_ID3_element_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___AuxInfoGANSS_ID3_element_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __AuxInfoGANSS_ID3_element_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___AuxInfoGANSS_ID3_element_ie_Extensions__item__id),
        (u'criticality', ___AuxInfoGANSS_ID3_element_ie_Extensions__item__criticality),
        (u'extensionValue', ___AuxInfoGANSS_ID3_element_ie_Extensions__item__extensionValue),
        ])
    __AuxInfoGANSS_ID3_element_ie_Extensions__item_._ext = None
    _AuxInfoGANSS_ID3_element_ie_Extensions._cont = __AuxInfoGANSS_ID3_element_ie_Extensions__item_
    _AuxInfoGANSS_ID3_element_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    AuxInfoGANSS_ID3_element._cont = ASN1Dict([
        (u'svID', _AuxInfoGANSS_ID3_element_svID),
        (u'signalsAvailable', _AuxInfoGANSS_ID3_element_signalsAvailable),
        (u'channelNumber', _AuxInfoGANSS_ID3_element_channelNumber),
        (u'ie-Extensions', _AuxInfoGANSS_ID3_element_ie_Extensions),
        ])
    AuxInfoGANSS_ID3_element._ext = []
    
    #-----< AuxInfoGANSS-ID3-element-ExtIEs >-----#
    AuxInfoGANSS_ID3_element_ExtIEs = CLASS(name=u'AuxInfoGANSS-ID3-element-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    AuxInfoGANSS_ID3_element_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< CNAVclockModel >-----#
    CNAVclockModel = SEQ(name=u'CNAVclockModel', mode=MODE_TYPE)
    _CNAVclockModel_cnavToc = BIT_STR(name=u'cnavToc', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _CNAVclockModel_cnavToc._const_sz = ASN1Set(rv=[11], rr=[], ev=None, er=[])
    _CNAVclockModel_cnavTop = BIT_STR(name=u'cnavTop', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _CNAVclockModel_cnavTop._const_sz = ASN1Set(rv=[11], rr=[], ev=None, er=[])
    _CNAVclockModel_cnavURA0 = BIT_STR(name=u'cnavURA0', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _CNAVclockModel_cnavURA0._const_sz = ASN1Set(rv=[5], rr=[], ev=None, er=[])
    _CNAVclockModel_cnavURA1 = BIT_STR(name=u'cnavURA1', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _CNAVclockModel_cnavURA1._const_sz = ASN1Set(rv=[3], rr=[], ev=None, er=[])
    _CNAVclockModel_cnavURA2 = BIT_STR(name=u'cnavURA2', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _CNAVclockModel_cnavURA2._const_sz = ASN1Set(rv=[3], rr=[], ev=None, er=[])
    _CNAVclockModel_cnavAf2 = BIT_STR(name=u'cnavAf2', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _CNAVclockModel_cnavAf2._const_sz = ASN1Set(rv=[10], rr=[], ev=None, er=[])
    _CNAVclockModel_cnavAf1 = BIT_STR(name=u'cnavAf1', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _CNAVclockModel_cnavAf1._const_sz = ASN1Set(rv=[20], rr=[], ev=None, er=[])
    _CNAVclockModel_cnavAf0 = BIT_STR(name=u'cnavAf0', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _CNAVclockModel_cnavAf0._const_sz = ASN1Set(rv=[26], rr=[], ev=None, er=[])
    _CNAVclockModel_cnavTgd = BIT_STR(name=u'cnavTgd', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _CNAVclockModel_cnavTgd._const_sz = ASN1Set(rv=[13], rr=[], ev=None, er=[])
    _CNAVclockModel_cnavISCl1cp = BIT_STR(name=u'cnavISCl1cp', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CNAVclockModel_cnavISCl1cp._const_sz = ASN1Set(rv=[13], rr=[], ev=None, er=[])
    _CNAVclockModel_cnavISCl1cd = BIT_STR(name=u'cnavISCl1cd', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CNAVclockModel_cnavISCl1cd._const_sz = ASN1Set(rv=[13], rr=[], ev=None, er=[])
    _CNAVclockModel_cnavISCl1ca = BIT_STR(name=u'cnavISCl1ca', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CNAVclockModel_cnavISCl1ca._const_sz = ASN1Set(rv=[13], rr=[], ev=None, er=[])
    _CNAVclockModel_cnavISCl2c = BIT_STR(name=u'cnavISCl2c', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CNAVclockModel_cnavISCl2c._const_sz = ASN1Set(rv=[13], rr=[], ev=None, er=[])
    _CNAVclockModel_cnavISCl5i5 = BIT_STR(name=u'cnavISCl5i5', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CNAVclockModel_cnavISCl5i5._const_sz = ASN1Set(rv=[13], rr=[], ev=None, er=[])
    _CNAVclockModel_cnavISCl5q5 = BIT_STR(name=u'cnavISCl5q5', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CNAVclockModel_cnavISCl5q5._const_sz = ASN1Set(rv=[13], rr=[], ev=None, er=[])
    _CNAVclockModel_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __CNAVclockModel_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___CNAVclockModel_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____CNAVclockModel_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____CNAVclockModel_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___CNAVclockModel_ie_Extensions__item__id._const_tab = ____CNAVclockModel_ie_Extensions__item__id_tab
    ___CNAVclockModel_ie_Extensions__item__id._const_tab_at = None
    ___CNAVclockModel_ie_Extensions__item__id._const_tab_id = u'id'
    ___CNAVclockModel_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____CNAVclockModel_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____CNAVclockModel_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___CNAVclockModel_ie_Extensions__item__criticality._const_tab = ____CNAVclockModel_ie_Extensions__item__criticality_tab
    ___CNAVclockModel_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___CNAVclockModel_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___CNAVclockModel_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____CNAVclockModel_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____CNAVclockModel_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___CNAVclockModel_ie_Extensions__item__extensionValue._const_tab = ____CNAVclockModel_ie_Extensions__item__extensionValue_tab
    ___CNAVclockModel_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___CNAVclockModel_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __CNAVclockModel_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___CNAVclockModel_ie_Extensions__item__id),
        (u'criticality', ___CNAVclockModel_ie_Extensions__item__criticality),
        (u'extensionValue', ___CNAVclockModel_ie_Extensions__item__extensionValue),
        ])
    __CNAVclockModel_ie_Extensions__item_._ext = None
    _CNAVclockModel_ie_Extensions._cont = __CNAVclockModel_ie_Extensions__item_
    _CNAVclockModel_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    CNAVclockModel._cont = ASN1Dict([
        (u'cnavToc', _CNAVclockModel_cnavToc),
        (u'cnavTop', _CNAVclockModel_cnavTop),
        (u'cnavURA0', _CNAVclockModel_cnavURA0),
        (u'cnavURA1', _CNAVclockModel_cnavURA1),
        (u'cnavURA2', _CNAVclockModel_cnavURA2),
        (u'cnavAf2', _CNAVclockModel_cnavAf2),
        (u'cnavAf1', _CNAVclockModel_cnavAf1),
        (u'cnavAf0', _CNAVclockModel_cnavAf0),
        (u'cnavTgd', _CNAVclockModel_cnavTgd),
        (u'cnavISCl1cp', _CNAVclockModel_cnavISCl1cp),
        (u'cnavISCl1cd', _CNAVclockModel_cnavISCl1cd),
        (u'cnavISCl1ca', _CNAVclockModel_cnavISCl1ca),
        (u'cnavISCl2c', _CNAVclockModel_cnavISCl2c),
        (u'cnavISCl5i5', _CNAVclockModel_cnavISCl5i5),
        (u'cnavISCl5q5', _CNAVclockModel_cnavISCl5q5),
        (u'ie-Extensions', _CNAVclockModel_ie_Extensions),
        ])
    CNAVclockModel._ext = []
    
    #-----< CNAVclockModel-ExtIEs >-----#
    CNAVclockModel_ExtIEs = CLASS(name=u'CNAVclockModel-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    CNAVclockModel_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< DeltaUT1 >-----#
    DeltaUT1 = SEQ(name=u'DeltaUT1', mode=MODE_TYPE)
    _DeltaUT1_b1 = BIT_STR(name=u'b1', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _DeltaUT1_b1._const_sz = ASN1Set(rv=[11], rr=[], ev=None, er=[])
    _DeltaUT1_b2 = BIT_STR(name=u'b2', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _DeltaUT1_b2._const_sz = ASN1Set(rv=[10], rr=[], ev=None, er=[])
    _DeltaUT1_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __DeltaUT1_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___DeltaUT1_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____DeltaUT1_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____DeltaUT1_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___DeltaUT1_ie_Extensions__item__id._const_tab = ____DeltaUT1_ie_Extensions__item__id_tab
    ___DeltaUT1_ie_Extensions__item__id._const_tab_at = None
    ___DeltaUT1_ie_Extensions__item__id._const_tab_id = u'id'
    ___DeltaUT1_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____DeltaUT1_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____DeltaUT1_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___DeltaUT1_ie_Extensions__item__criticality._const_tab = ____DeltaUT1_ie_Extensions__item__criticality_tab
    ___DeltaUT1_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___DeltaUT1_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___DeltaUT1_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____DeltaUT1_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____DeltaUT1_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___DeltaUT1_ie_Extensions__item__extensionValue._const_tab = ____DeltaUT1_ie_Extensions__item__extensionValue_tab
    ___DeltaUT1_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___DeltaUT1_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __DeltaUT1_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___DeltaUT1_ie_Extensions__item__id),
        (u'criticality', ___DeltaUT1_ie_Extensions__item__criticality),
        (u'extensionValue', ___DeltaUT1_ie_Extensions__item__extensionValue),
        ])
    __DeltaUT1_ie_Extensions__item_._ext = None
    _DeltaUT1_ie_Extensions._cont = __DeltaUT1_ie_Extensions__item_
    _DeltaUT1_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    DeltaUT1._cont = ASN1Dict([
        (u'b1', _DeltaUT1_b1),
        (u'b2', _DeltaUT1_b2),
        (u'ie-Extensions', _DeltaUT1_ie_Extensions),
        ])
    DeltaUT1._ext = []
    
    #-----< DeltaUT1-ExtIEs >-----#
    DeltaUT1_ExtIEs = CLASS(name=u'DeltaUT1-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    DeltaUT1_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< DGANSS-Corrections >-----#
    DGANSS_Corrections = SEQ(name=u'DGANSS-Corrections', mode=MODE_TYPE)
    _DGANSS_Corrections_dGANSS_ReferenceTime = INT(name=u'dGANSS-ReferenceTime', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _DGANSS_Corrections_dGANSS_ReferenceTime._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=119)], ev=None, er=[])
    _DGANSS_Corrections_dGANSS_Information = SEQ_OF(name=u'dGANSS-Information', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'DGANSS-Information')))
    _DGANSS_Corrections_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __DGANSS_Corrections_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___DGANSS_Corrections_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____DGANSS_Corrections_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____DGANSS_Corrections_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___DGANSS_Corrections_ie_Extensions__item__id._const_tab = ____DGANSS_Corrections_ie_Extensions__item__id_tab
    ___DGANSS_Corrections_ie_Extensions__item__id._const_tab_at = None
    ___DGANSS_Corrections_ie_Extensions__item__id._const_tab_id = u'id'
    ___DGANSS_Corrections_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____DGANSS_Corrections_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____DGANSS_Corrections_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___DGANSS_Corrections_ie_Extensions__item__criticality._const_tab = ____DGANSS_Corrections_ie_Extensions__item__criticality_tab
    ___DGANSS_Corrections_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___DGANSS_Corrections_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___DGANSS_Corrections_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____DGANSS_Corrections_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____DGANSS_Corrections_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___DGANSS_Corrections_ie_Extensions__item__extensionValue._const_tab = ____DGANSS_Corrections_ie_Extensions__item__extensionValue_tab
    ___DGANSS_Corrections_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___DGANSS_Corrections_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __DGANSS_Corrections_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___DGANSS_Corrections_ie_Extensions__item__id),
        (u'criticality', ___DGANSS_Corrections_ie_Extensions__item__criticality),
        (u'extensionValue', ___DGANSS_Corrections_ie_Extensions__item__extensionValue),
        ])
    __DGANSS_Corrections_ie_Extensions__item_._ext = None
    _DGANSS_Corrections_ie_Extensions._cont = __DGANSS_Corrections_ie_Extensions__item_
    _DGANSS_Corrections_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    DGANSS_Corrections._cont = ASN1Dict([
        (u'dGANSS-ReferenceTime', _DGANSS_Corrections_dGANSS_ReferenceTime),
        (u'dGANSS-Information', _DGANSS_Corrections_dGANSS_Information),
        (u'ie-Extensions', _DGANSS_Corrections_ie_Extensions),
        ])
    DGANSS_Corrections._ext = []
    
    #-----< DGANSS-Corrections-ExtIEs >-----#
    DGANSS_Corrections_ExtIEs = CLASS(name=u'DGANSS-Corrections-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    DGANSS_Corrections_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< DGANSS-Information >-----#
    DGANSS_Information = SEQ_OF(name=u'DGANSS-Information', mode=MODE_TYPE)
    _DGANSS_Information__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'DGANSS-InformationItem')))
    DGANSS_Information._cont = _DGANSS_Information__item_
    DGANSS_Information._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    
    #-----< DGANSS-InformationItem >-----#
    DGANSS_InformationItem = SEQ(name=u'DGANSS-InformationItem', mode=MODE_TYPE)
    _DGANSS_InformationItem_gANSS_SignalId = SEQ(name=u'gANSS-SignalId', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSS-SignalID')), opt=True)
    _DGANSS_InformationItem_gANSS_StatusHealth = ENUM(name=u'gANSS-StatusHealth', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSS-StatusHealth')))
    _DGANSS_InformationItem_dGANSS_SignalInformation = SEQ_OF(name=u'dGANSS-SignalInformation', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'DGANSS-SignalInformation')), opt=True)
    _DGANSS_InformationItem_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __DGANSS_InformationItem_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___DGANSS_InformationItem_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____DGANSS_InformationItem_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____DGANSS_InformationItem_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___DGANSS_InformationItem_ie_Extensions__item__id._const_tab = ____DGANSS_InformationItem_ie_Extensions__item__id_tab
    ___DGANSS_InformationItem_ie_Extensions__item__id._const_tab_at = None
    ___DGANSS_InformationItem_ie_Extensions__item__id._const_tab_id = u'id'
    ___DGANSS_InformationItem_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____DGANSS_InformationItem_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____DGANSS_InformationItem_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___DGANSS_InformationItem_ie_Extensions__item__criticality._const_tab = ____DGANSS_InformationItem_ie_Extensions__item__criticality_tab
    ___DGANSS_InformationItem_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___DGANSS_InformationItem_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___DGANSS_InformationItem_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____DGANSS_InformationItem_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____DGANSS_InformationItem_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___DGANSS_InformationItem_ie_Extensions__item__extensionValue._const_tab = ____DGANSS_InformationItem_ie_Extensions__item__extensionValue_tab
    ___DGANSS_InformationItem_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___DGANSS_InformationItem_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __DGANSS_InformationItem_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___DGANSS_InformationItem_ie_Extensions__item__id),
        (u'criticality', ___DGANSS_InformationItem_ie_Extensions__item__criticality),
        (u'extensionValue', ___DGANSS_InformationItem_ie_Extensions__item__extensionValue),
        ])
    __DGANSS_InformationItem_ie_Extensions__item_._ext = None
    _DGANSS_InformationItem_ie_Extensions._cont = __DGANSS_InformationItem_ie_Extensions__item_
    _DGANSS_InformationItem_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    DGANSS_InformationItem._cont = ASN1Dict([
        (u'gANSS-SignalId', _DGANSS_InformationItem_gANSS_SignalId),
        (u'gANSS-StatusHealth', _DGANSS_InformationItem_gANSS_StatusHealth),
        (u'dGANSS-SignalInformation', _DGANSS_InformationItem_dGANSS_SignalInformation),
        (u'ie-Extensions', _DGANSS_InformationItem_ie_Extensions),
        ])
    DGANSS_InformationItem._ext = []
    
    #-----< DGANSS-InformationItem-ExtIEs >-----#
    DGANSS_InformationItem_ExtIEs = CLASS(name=u'DGANSS-InformationItem-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    DGANSS_InformationItem_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< DGANSS-SignalInformation >-----#
    DGANSS_SignalInformation = SEQ_OF(name=u'DGANSS-SignalInformation', mode=MODE_TYPE)
    _DGANSS_SignalInformation__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'DGANSS-SignalInformationItem')))
    DGANSS_SignalInformation._cont = _DGANSS_SignalInformation__item_
    DGANSS_SignalInformation._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    
    #-----< DGANSS-SignalInformationItem >-----#
    DGANSS_SignalInformationItem = SEQ(name=u'DGANSS-SignalInformationItem', mode=MODE_TYPE)
    _DGANSS_SignalInformationItem_satId = INT(name=u'satId', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _DGANSS_SignalInformationItem_satId._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    _DGANSS_SignalInformationItem_gANSS_iod = BIT_STR(name=u'gANSS-iod', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _DGANSS_SignalInformationItem_gANSS_iod._const_sz = ASN1Set(rv=[10], rr=[], ev=None, er=[])
    _DGANSS_SignalInformationItem_udre = ENUM(name=u'udre', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'UDRE')))
    _DGANSS_SignalInformationItem_ganss_prc = INT(name=u'ganss-prc', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _DGANSS_SignalInformationItem_ganss_prc._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-2047, ub=2047)], ev=None, er=[])
    _DGANSS_SignalInformationItem_ganss_rrc = INT(name=u'ganss-rrc', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _DGANSS_SignalInformationItem_ganss_rrc._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-127, ub=127)], ev=None, er=[])
    _DGANSS_SignalInformationItem_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __DGANSS_SignalInformationItem_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___DGANSS_SignalInformationItem_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____DGANSS_SignalInformationItem_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____DGANSS_SignalInformationItem_ie_Extensions__item__id_tab_val_Extension_0 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'DGNSS-ValidityPeriod')))
    ____DGANSS_SignalInformationItem_ie_Extensions__item__id_tab._val = ASN1Set(rv=[dict([(u'id', 118), (u'criticality', u'ignore'), (u'Extension', _____DGANSS_SignalInformationItem_ie_Extensions__item__id_tab_val_Extension_0), (u'presence', u'optional')])], rr=[], ev=None, er=[])
    ___DGANSS_SignalInformationItem_ie_Extensions__item__id._const_tab = ____DGANSS_SignalInformationItem_ie_Extensions__item__id_tab
    ___DGANSS_SignalInformationItem_ie_Extensions__item__id._const_tab_at = None
    ___DGANSS_SignalInformationItem_ie_Extensions__item__id._const_tab_id = u'id'
    ___DGANSS_SignalInformationItem_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ___DGANSS_SignalInformationItem_ie_Extensions__item__criticality._const_tab = ____DGANSS_SignalInformationItem_ie_Extensions__item__id_tab
    ___DGANSS_SignalInformationItem_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___DGANSS_SignalInformationItem_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___DGANSS_SignalInformationItem_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ___DGANSS_SignalInformationItem_ie_Extensions__item__extensionValue._const_tab = ____DGANSS_SignalInformationItem_ie_Extensions__item__id_tab
    ___DGANSS_SignalInformationItem_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___DGANSS_SignalInformationItem_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __DGANSS_SignalInformationItem_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___DGANSS_SignalInformationItem_ie_Extensions__item__id),
        (u'criticality', ___DGANSS_SignalInformationItem_ie_Extensions__item__criticality),
        (u'extensionValue', ___DGANSS_SignalInformationItem_ie_Extensions__item__extensionValue),
        ])
    __DGANSS_SignalInformationItem_ie_Extensions__item_._ext = None
    _DGANSS_SignalInformationItem_ie_Extensions._cont = __DGANSS_SignalInformationItem_ie_Extensions__item_
    _DGANSS_SignalInformationItem_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    DGANSS_SignalInformationItem._cont = ASN1Dict([
        (u'satId', _DGANSS_SignalInformationItem_satId),
        (u'gANSS-iod', _DGANSS_SignalInformationItem_gANSS_iod),
        (u'udre', _DGANSS_SignalInformationItem_udre),
        (u'ganss-prc', _DGANSS_SignalInformationItem_ganss_prc),
        (u'ganss-rrc', _DGANSS_SignalInformationItem_ganss_rrc),
        (u'ie-Extensions', _DGANSS_SignalInformationItem_ie_Extensions),
        ])
    DGANSS_SignalInformationItem._ext = []
    
    #-----< DGANSS-SignalInformationItem-ExtIEs >-----#
    DGANSS_SignalInformationItem_ExtIEs = CLASS(name=u'DGANSS-SignalInformationItem-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _DGANSS_SignalInformationItem_ExtIEs_val_Extension_0 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'DGNSS-ValidityPeriod')))
    DGANSS_SignalInformationItem_ExtIEs._val = ASN1Set(rv=[dict([(u'id', 118), (u'criticality', u'ignore'), (u'Extension', _DGANSS_SignalInformationItem_ExtIEs_val_Extension_0), (u'presence', u'optional')])], rr=[], ev=[], er=[])
    
    #-----< GANSS-AddClockModels >-----#
    GANSS_AddClockModels = CHOICE(name=u'GANSS-AddClockModels', mode=MODE_TYPE)
    _GANSS_AddClockModels_navClockModel = SEQ(name=u'navClockModel', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'NAVclockModel')))
    _GANSS_AddClockModels_cnavClockModel = SEQ(name=u'cnavClockModel', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'CNAVclockModel')))
    _GANSS_AddClockModels_glonassClockModel = SEQ(name=u'glonassClockModel', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GLONASSclockModel')))
    _GANSS_AddClockModels_sbasClockModel = SEQ(name=u'sbasClockModel', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'SBASclockModel')))
    _GANSS_AddClockModels_bDSClockModel = SEQ(name=u'bDSClockModel', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'BDSClockModel')))
    GANSS_AddClockModels._cont = ASN1Dict([
        (u'navClockModel', _GANSS_AddClockModels_navClockModel),
        (u'cnavClockModel', _GANSS_AddClockModels_cnavClockModel),
        (u'glonassClockModel', _GANSS_AddClockModels_glonassClockModel),
        (u'sbasClockModel', _GANSS_AddClockModels_sbasClockModel),
        (u'bDSClockModel', _GANSS_AddClockModels_bDSClockModel),
        ])
    GANSS_AddClockModels._ext = [u'bDSClockModel']
    
    #-----< GANSS-AddOrbitModels >-----#
    GANSS_AddOrbitModels = CHOICE(name=u'GANSS-AddOrbitModels', mode=MODE_TYPE)
    _GANSS_AddOrbitModels_navKeplerianSet = SEQ(name=u'navKeplerianSet', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'NavModel-NAVKeplerianSet')))
    _GANSS_AddOrbitModels_cnavKeplerianSet = SEQ(name=u'cnavKeplerianSet', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'NavModel-CNAVKeplerianSet')))
    _GANSS_AddOrbitModels_glonassECEF = SEQ(name=u'glonassECEF', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'NavModel-GLONASSecef')))
    _GANSS_AddOrbitModels_sbasECEF = SEQ(name=u'sbasECEF', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'NavModel-SBASecef')))
    _GANSS_AddOrbitModels_bDSKeplerianSet = SEQ(name=u'bDSKeplerianSet', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'NavModel-BDSKeplerianSet')))
    GANSS_AddOrbitModels._cont = ASN1Dict([
        (u'navKeplerianSet', _GANSS_AddOrbitModels_navKeplerianSet),
        (u'cnavKeplerianSet', _GANSS_AddOrbitModels_cnavKeplerianSet),
        (u'glonassECEF', _GANSS_AddOrbitModels_glonassECEF),
        (u'sbasECEF', _GANSS_AddOrbitModels_sbasECEF),
        (u'bDSKeplerianSet', _GANSS_AddOrbitModels_bDSKeplerianSet),
        ])
    GANSS_AddOrbitModels._ext = [u'bDSKeplerianSet']
    
    #-----< GANSS-Additional-Ionospheric-Model >-----#
    GANSS_Additional_Ionospheric_Model = SEQ(name=u'GANSS-Additional-Ionospheric-Model', mode=MODE_TYPE)
    _GANSS_Additional_Ionospheric_Model_dataID = BIT_STR(name=u'dataID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_Additional_Ionospheric_Model_dataID._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    _GANSS_Additional_Ionospheric_Model_alpha_beta_parameters = SEQ(name=u'alpha-beta-parameters', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GPS-Ionospheric-Model')))
    _GANSS_Additional_Ionospheric_Model_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GANSS_Additional_Ionospheric_Model_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GANSS_Additional_Ionospheric_Model_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GANSS_Additional_Ionospheric_Model_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_Additional_Ionospheric_Model_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_Additional_Ionospheric_Model_ie_Extensions__item__id._const_tab = ____GANSS_Additional_Ionospheric_Model_ie_Extensions__item__id_tab
    ___GANSS_Additional_Ionospheric_Model_ie_Extensions__item__id._const_tab_at = None
    ___GANSS_Additional_Ionospheric_Model_ie_Extensions__item__id._const_tab_id = u'id'
    ___GANSS_Additional_Ionospheric_Model_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GANSS_Additional_Ionospheric_Model_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_Additional_Ionospheric_Model_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_Additional_Ionospheric_Model_ie_Extensions__item__criticality._const_tab = ____GANSS_Additional_Ionospheric_Model_ie_Extensions__item__criticality_tab
    ___GANSS_Additional_Ionospheric_Model_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GANSS_Additional_Ionospheric_Model_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GANSS_Additional_Ionospheric_Model_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GANSS_Additional_Ionospheric_Model_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_Additional_Ionospheric_Model_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_Additional_Ionospheric_Model_ie_Extensions__item__extensionValue._const_tab = ____GANSS_Additional_Ionospheric_Model_ie_Extensions__item__extensionValue_tab
    ___GANSS_Additional_Ionospheric_Model_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GANSS_Additional_Ionospheric_Model_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GANSS_Additional_Ionospheric_Model_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GANSS_Additional_Ionospheric_Model_ie_Extensions__item__id),
        (u'criticality', ___GANSS_Additional_Ionospheric_Model_ie_Extensions__item__criticality),
        (u'extensionValue', ___GANSS_Additional_Ionospheric_Model_ie_Extensions__item__extensionValue),
        ])
    __GANSS_Additional_Ionospheric_Model_ie_Extensions__item_._ext = None
    _GANSS_Additional_Ionospheric_Model_ie_Extensions._cont = __GANSS_Additional_Ionospheric_Model_ie_Extensions__item_
    _GANSS_Additional_Ionospheric_Model_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GANSS_Additional_Ionospheric_Model._cont = ASN1Dict([
        (u'dataID', _GANSS_Additional_Ionospheric_Model_dataID),
        (u'alpha-beta-parameters', _GANSS_Additional_Ionospheric_Model_alpha_beta_parameters),
        (u'ie-Extensions', _GANSS_Additional_Ionospheric_Model_ie_Extensions),
        ])
    GANSS_Additional_Ionospheric_Model._ext = []
    
    #-----< GANSS-Additional-Ionospheric-Model-ExtIEs >-----#
    GANSS_Additional_Ionospheric_Model_ExtIEs = CLASS(name=u'GANSS-Additional-Ionospheric-Model-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GANSS_Additional_Ionospheric_Model_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GANSS-Additional-Navigation-Models >-----#
    GANSS_Additional_Navigation_Models = SEQ(name=u'GANSS-Additional-Navigation-Models', mode=MODE_TYPE)
    _GANSS_Additional_Navigation_Models_non_broadcastIndication = ENUM(name=u'non-broadcastIndication', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GANSS_Additional_Navigation_Models_non_broadcastIndication._cont = ASN1Dict([(u'true', 0)])
    _GANSS_Additional_Navigation_Models_non_broadcastIndication._ext = None
    _GANSS_Additional_Navigation_Models_ganssSatInfoNavList = SEQ_OF(name=u'ganssSatInfoNavList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'Ganss-Sat-Info-AddNavList')))
    _GANSS_Additional_Navigation_Models_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GANSS_Additional_Navigation_Models_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GANSS_Additional_Navigation_Models_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GANSS_Additional_Navigation_Models_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_Additional_Navigation_Models_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_Additional_Navigation_Models_ie_Extensions__item__id._const_tab = ____GANSS_Additional_Navigation_Models_ie_Extensions__item__id_tab
    ___GANSS_Additional_Navigation_Models_ie_Extensions__item__id._const_tab_at = None
    ___GANSS_Additional_Navigation_Models_ie_Extensions__item__id._const_tab_id = u'id'
    ___GANSS_Additional_Navigation_Models_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GANSS_Additional_Navigation_Models_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_Additional_Navigation_Models_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_Additional_Navigation_Models_ie_Extensions__item__criticality._const_tab = ____GANSS_Additional_Navigation_Models_ie_Extensions__item__criticality_tab
    ___GANSS_Additional_Navigation_Models_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GANSS_Additional_Navigation_Models_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GANSS_Additional_Navigation_Models_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GANSS_Additional_Navigation_Models_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_Additional_Navigation_Models_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_Additional_Navigation_Models_ie_Extensions__item__extensionValue._const_tab = ____GANSS_Additional_Navigation_Models_ie_Extensions__item__extensionValue_tab
    ___GANSS_Additional_Navigation_Models_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GANSS_Additional_Navigation_Models_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GANSS_Additional_Navigation_Models_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GANSS_Additional_Navigation_Models_ie_Extensions__item__id),
        (u'criticality', ___GANSS_Additional_Navigation_Models_ie_Extensions__item__criticality),
        (u'extensionValue', ___GANSS_Additional_Navigation_Models_ie_Extensions__item__extensionValue),
        ])
    __GANSS_Additional_Navigation_Models_ie_Extensions__item_._ext = None
    _GANSS_Additional_Navigation_Models_ie_Extensions._cont = __GANSS_Additional_Navigation_Models_ie_Extensions__item_
    _GANSS_Additional_Navigation_Models_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GANSS_Additional_Navigation_Models._cont = ASN1Dict([
        (u'non-broadcastIndication', _GANSS_Additional_Navigation_Models_non_broadcastIndication),
        (u'ganssSatInfoNavList', _GANSS_Additional_Navigation_Models_ganssSatInfoNavList),
        (u'ie-Extensions', _GANSS_Additional_Navigation_Models_ie_Extensions),
        ])
    GANSS_Additional_Navigation_Models._ext = []
    
    #-----< GANSS-Additional-Navigation-Models-ExtIEs >-----#
    GANSS_Additional_Navigation_Models_ExtIEs = CLASS(name=u'GANSS-Additional-Navigation-Models-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GANSS_Additional_Navigation_Models_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GANSS-Additional-Time-Models >-----#
    GANSS_Additional_Time_Models = SEQ_OF(name=u'GANSS-Additional-Time-Models', mode=MODE_TYPE)
    _GANSS_Additional_Time_Models__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-Time-Model')))
    GANSS_Additional_Time_Models._cont = _GANSS_Additional_Time_Models__item_
    GANSS_Additional_Time_Models._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=7)], ev=None, er=[])
    
    #-----< GANSS-Additional-UTC-Models >-----#
    GANSS_Additional_UTC_Models = CHOICE(name=u'GANSS-Additional-UTC-Models', mode=MODE_TYPE)
    _GANSS_Additional_UTC_Models_utcModel1 = SEQ(name=u'utcModel1', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'UTCmodelSet1')))
    _GANSS_Additional_UTC_Models_utcModel2 = SEQ(name=u'utcModel2', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'UTCmodelSet2')))
    _GANSS_Additional_UTC_Models_utcModel3 = SEQ(name=u'utcModel3', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'UTCmodelSet3')))
    _GANSS_Additional_UTC_Models_utcModel4 = SEQ(name=u'utcModel4', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'UTCmodelSet4')))
    GANSS_Additional_UTC_Models._cont = ASN1Dict([
        (u'utcModel1', _GANSS_Additional_UTC_Models_utcModel1),
        (u'utcModel2', _GANSS_Additional_UTC_Models_utcModel2),
        (u'utcModel3', _GANSS_Additional_UTC_Models_utcModel3),
        (u'utcModel4', _GANSS_Additional_UTC_Models_utcModel4),
        ])
    GANSS_Additional_UTC_Models._ext = [u'utcModel4']
    
    #-----< GANSS-ALM-BDSKeplericanset >-----#
    GANSS_ALM_BDSKeplericanset = SEQ(name=u'GANSS-ALM-BDSKeplericanset', mode=MODE_TYPE)
    _GANSS_ALM_BDSKeplericanset_satellite_Information_BDS_KP_List = SEQ_OF(name=u'satellite-Information-BDS-KP-List', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'Satellite-Information-BDS-KP-List')))
    _GANSS_ALM_BDSKeplericanset_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GANSS_ALM_BDSKeplericanset_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GANSS_ALM_BDSKeplericanset_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GANSS_ALM_BDSKeplericanset_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_ALM_BDSKeplericanset_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_ALM_BDSKeplericanset_ie_Extensions__item__id._const_tab = ____GANSS_ALM_BDSKeplericanset_ie_Extensions__item__id_tab
    ___GANSS_ALM_BDSKeplericanset_ie_Extensions__item__id._const_tab_at = None
    ___GANSS_ALM_BDSKeplericanset_ie_Extensions__item__id._const_tab_id = u'id'
    ___GANSS_ALM_BDSKeplericanset_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GANSS_ALM_BDSKeplericanset_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_ALM_BDSKeplericanset_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_ALM_BDSKeplericanset_ie_Extensions__item__criticality._const_tab = ____GANSS_ALM_BDSKeplericanset_ie_Extensions__item__criticality_tab
    ___GANSS_ALM_BDSKeplericanset_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GANSS_ALM_BDSKeplericanset_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GANSS_ALM_BDSKeplericanset_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GANSS_ALM_BDSKeplericanset_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_ALM_BDSKeplericanset_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_ALM_BDSKeplericanset_ie_Extensions__item__extensionValue._const_tab = ____GANSS_ALM_BDSKeplericanset_ie_Extensions__item__extensionValue_tab
    ___GANSS_ALM_BDSKeplericanset_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GANSS_ALM_BDSKeplericanset_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GANSS_ALM_BDSKeplericanset_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GANSS_ALM_BDSKeplericanset_ie_Extensions__item__id),
        (u'criticality', ___GANSS_ALM_BDSKeplericanset_ie_Extensions__item__criticality),
        (u'extensionValue', ___GANSS_ALM_BDSKeplericanset_ie_Extensions__item__extensionValue),
        ])
    __GANSS_ALM_BDSKeplericanset_ie_Extensions__item_._ext = None
    _GANSS_ALM_BDSKeplericanset_ie_Extensions._cont = __GANSS_ALM_BDSKeplericanset_ie_Extensions__item_
    _GANSS_ALM_BDSKeplericanset_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GANSS_ALM_BDSKeplericanset._cont = ASN1Dict([
        (u'satellite-Information-BDS-KP-List', _GANSS_ALM_BDSKeplericanset_satellite_Information_BDS_KP_List),
        (u'ie-Extensions', _GANSS_ALM_BDSKeplericanset_ie_Extensions),
        ])
    GANSS_ALM_BDSKeplericanset._ext = []
    
    #-----< GANSS-ALM-BDSKeplericanset-ExtIEs >-----#
    GANSS_ALM_BDSKeplericanset_ExtIEs = CLASS(name=u'GANSS-ALM-BDSKeplericanset-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GANSS_ALM_BDSKeplericanset_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< Satellite-Information-BDS-KP-List >-----#
    Satellite_Information_BDS_KP_List = SEQ_OF(name=u'Satellite-Information-BDS-KP-List', mode=MODE_TYPE)
    _Satellite_Information_BDS_KP_List__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'Satellite-Information-BDS-KP-Item')))
    Satellite_Information_BDS_KP_List._cont = _Satellite_Information_BDS_KP_List__item_
    Satellite_Information_BDS_KP_List._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=36)], ev=None, er=[])
    
    #-----< Satellite-Information-BDS-KP-Item >-----#
    Satellite_Information_BDS_KP_Item = SEQ(name=u'Satellite-Information-BDS-KP-Item', mode=MODE_TYPE)
    _Satellite_Information_BDS_KP_Item_sVID_BDS = INT(name=u'sVID-BDS', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _Satellite_Information_BDS_KP_Item_sVID_BDS._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    _Satellite_Information_BDS_KP_Item_tOA_BDS = BIT_STR(name=u'tOA-BDS', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _Satellite_Information_BDS_KP_Item_tOA_BDS._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _Satellite_Information_BDS_KP_Item_a21_BDS = BIT_STR(name=u'a21-BDS', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _Satellite_Information_BDS_KP_Item_a21_BDS._const_sz = ASN1Set(rv=[24], rr=[], ev=None, er=[])
    _Satellite_Information_BDS_KP_Item_e_BDS = BIT_STR(name=u'e-BDS', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _Satellite_Information_BDS_KP_Item_e_BDS._const_sz = ASN1Set(rv=[17], rr=[], ev=None, er=[])
    _Satellite_Information_BDS_KP_Item_omg_lower_BDS = BIT_STR(name=u'omg-lower-BDS', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _Satellite_Information_BDS_KP_Item_omg_lower_BDS._const_sz = ASN1Set(rv=[24], rr=[], ev=None, er=[])
    _Satellite_Information_BDS_KP_Item_m0_BDS = BIT_STR(name=u'm0-BDS', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _Satellite_Information_BDS_KP_Item_m0_BDS._const_sz = ASN1Set(rv=[24], rr=[], ev=None, er=[])
    _Satellite_Information_BDS_KP_Item_omg_0_BDS = BIT_STR(name=u'omg-0-BDS', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _Satellite_Information_BDS_KP_Item_omg_0_BDS._const_sz = ASN1Set(rv=[24], rr=[], ev=None, er=[])
    _Satellite_Information_BDS_KP_Item_omg_upper_BDS = BIT_STR(name=u'omg-upper-BDS', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _Satellite_Information_BDS_KP_Item_omg_upper_BDS._const_sz = ASN1Set(rv=[17], rr=[], ev=None, er=[])
    _Satellite_Information_BDS_KP_Item_delta_i_BDS = BIT_STR(name=u'delta-i-BDS', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _Satellite_Information_BDS_KP_Item_delta_i_BDS._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _Satellite_Information_BDS_KP_Item_a0_BDS = BIT_STR(name=u'a0-BDS', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _Satellite_Information_BDS_KP_Item_a0_BDS._const_sz = ASN1Set(rv=[11], rr=[], ev=None, er=[])
    _Satellite_Information_BDS_KP_Item_a1_BDS = BIT_STR(name=u'a1-BDS', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _Satellite_Information_BDS_KP_Item_a1_BDS._const_sz = ASN1Set(rv=[11], rr=[], ev=None, er=[])
    _Satellite_Information_BDS_KP_Item_hea_BDS = BIT_STR(name=u'hea-BDS', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _Satellite_Information_BDS_KP_Item_hea_BDS._const_sz = ASN1Set(rv=[9], rr=[], ev=None, er=[])
    _Satellite_Information_BDS_KP_Item_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __Satellite_Information_BDS_KP_Item_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___Satellite_Information_BDS_KP_Item_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____Satellite_Information_BDS_KP_Item_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____Satellite_Information_BDS_KP_Item_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___Satellite_Information_BDS_KP_Item_ie_Extensions__item__id._const_tab = ____Satellite_Information_BDS_KP_Item_ie_Extensions__item__id_tab
    ___Satellite_Information_BDS_KP_Item_ie_Extensions__item__id._const_tab_at = None
    ___Satellite_Information_BDS_KP_Item_ie_Extensions__item__id._const_tab_id = u'id'
    ___Satellite_Information_BDS_KP_Item_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____Satellite_Information_BDS_KP_Item_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____Satellite_Information_BDS_KP_Item_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___Satellite_Information_BDS_KP_Item_ie_Extensions__item__criticality._const_tab = ____Satellite_Information_BDS_KP_Item_ie_Extensions__item__criticality_tab
    ___Satellite_Information_BDS_KP_Item_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___Satellite_Information_BDS_KP_Item_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___Satellite_Information_BDS_KP_Item_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____Satellite_Information_BDS_KP_Item_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____Satellite_Information_BDS_KP_Item_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___Satellite_Information_BDS_KP_Item_ie_Extensions__item__extensionValue._const_tab = ____Satellite_Information_BDS_KP_Item_ie_Extensions__item__extensionValue_tab
    ___Satellite_Information_BDS_KP_Item_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___Satellite_Information_BDS_KP_Item_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __Satellite_Information_BDS_KP_Item_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___Satellite_Information_BDS_KP_Item_ie_Extensions__item__id),
        (u'criticality', ___Satellite_Information_BDS_KP_Item_ie_Extensions__item__criticality),
        (u'extensionValue', ___Satellite_Information_BDS_KP_Item_ie_Extensions__item__extensionValue),
        ])
    __Satellite_Information_BDS_KP_Item_ie_Extensions__item_._ext = None
    _Satellite_Information_BDS_KP_Item_ie_Extensions._cont = __Satellite_Information_BDS_KP_Item_ie_Extensions__item_
    _Satellite_Information_BDS_KP_Item_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    Satellite_Information_BDS_KP_Item._cont = ASN1Dict([
        (u'sVID-BDS', _Satellite_Information_BDS_KP_Item_sVID_BDS),
        (u'tOA-BDS', _Satellite_Information_BDS_KP_Item_tOA_BDS),
        (u'a21-BDS', _Satellite_Information_BDS_KP_Item_a21_BDS),
        (u'e-BDS', _Satellite_Information_BDS_KP_Item_e_BDS),
        (u'omg-lower-BDS', _Satellite_Information_BDS_KP_Item_omg_lower_BDS),
        (u'm0-BDS', _Satellite_Information_BDS_KP_Item_m0_BDS),
        (u'omg-0-BDS', _Satellite_Information_BDS_KP_Item_omg_0_BDS),
        (u'omg-upper-BDS', _Satellite_Information_BDS_KP_Item_omg_upper_BDS),
        (u'delta-i-BDS', _Satellite_Information_BDS_KP_Item_delta_i_BDS),
        (u'a0-BDS', _Satellite_Information_BDS_KP_Item_a0_BDS),
        (u'a1-BDS', _Satellite_Information_BDS_KP_Item_a1_BDS),
        (u'hea-BDS', _Satellite_Information_BDS_KP_Item_hea_BDS),
        (u'ie-Extensions', _Satellite_Information_BDS_KP_Item_ie_Extensions),
        ])
    Satellite_Information_BDS_KP_Item._ext = []
    
    #-----< Satellite-Information-BDS-KP-Item-ExtIEs >-----#
    Satellite_Information_BDS_KP_Item_ExtIEs = CLASS(name=u'Satellite-Information-BDS-KP-Item-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    Satellite_Information_BDS_KP_Item_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GANSS-ALM-ECEFsbasAlmanacSet >-----#
    GANSS_ALM_ECEFsbasAlmanacSet = SEQ(name=u'GANSS-ALM-ECEFsbasAlmanacSet', mode=MODE_TYPE)
    _GANSS_ALM_ECEFsbasAlmanacSet_sat_info_SBASecefList = SEQ_OF(name=u'sat-info-SBASecefList', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSS-SAT-Info-Almanac-SBASecefList')))
    _GANSS_ALM_ECEFsbasAlmanacSet_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GANSS_ALM_ECEFsbasAlmanacSet_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GANSS_ALM_ECEFsbasAlmanacSet_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GANSS_ALM_ECEFsbasAlmanacSet_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_ALM_ECEFsbasAlmanacSet_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_ALM_ECEFsbasAlmanacSet_ie_Extensions__item__id._const_tab = ____GANSS_ALM_ECEFsbasAlmanacSet_ie_Extensions__item__id_tab
    ___GANSS_ALM_ECEFsbasAlmanacSet_ie_Extensions__item__id._const_tab_at = None
    ___GANSS_ALM_ECEFsbasAlmanacSet_ie_Extensions__item__id._const_tab_id = u'id'
    ___GANSS_ALM_ECEFsbasAlmanacSet_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GANSS_ALM_ECEFsbasAlmanacSet_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_ALM_ECEFsbasAlmanacSet_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_ALM_ECEFsbasAlmanacSet_ie_Extensions__item__criticality._const_tab = ____GANSS_ALM_ECEFsbasAlmanacSet_ie_Extensions__item__criticality_tab
    ___GANSS_ALM_ECEFsbasAlmanacSet_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GANSS_ALM_ECEFsbasAlmanacSet_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GANSS_ALM_ECEFsbasAlmanacSet_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GANSS_ALM_ECEFsbasAlmanacSet_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_ALM_ECEFsbasAlmanacSet_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_ALM_ECEFsbasAlmanacSet_ie_Extensions__item__extensionValue._const_tab = ____GANSS_ALM_ECEFsbasAlmanacSet_ie_Extensions__item__extensionValue_tab
    ___GANSS_ALM_ECEFsbasAlmanacSet_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GANSS_ALM_ECEFsbasAlmanacSet_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GANSS_ALM_ECEFsbasAlmanacSet_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GANSS_ALM_ECEFsbasAlmanacSet_ie_Extensions__item__id),
        (u'criticality', ___GANSS_ALM_ECEFsbasAlmanacSet_ie_Extensions__item__criticality),
        (u'extensionValue', ___GANSS_ALM_ECEFsbasAlmanacSet_ie_Extensions__item__extensionValue),
        ])
    __GANSS_ALM_ECEFsbasAlmanacSet_ie_Extensions__item_._ext = None
    _GANSS_ALM_ECEFsbasAlmanacSet_ie_Extensions._cont = __GANSS_ALM_ECEFsbasAlmanacSet_ie_Extensions__item_
    _GANSS_ALM_ECEFsbasAlmanacSet_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GANSS_ALM_ECEFsbasAlmanacSet._cont = ASN1Dict([
        (u'sat-info-SBASecefList', _GANSS_ALM_ECEFsbasAlmanacSet_sat_info_SBASecefList),
        (u'ie-Extensions', _GANSS_ALM_ECEFsbasAlmanacSet_ie_Extensions),
        ])
    GANSS_ALM_ECEFsbasAlmanacSet._ext = []
    
    #-----< GANSS-ALM-ECEFsbasAlmanacSet-ExtIEs >-----#
    GANSS_ALM_ECEFsbasAlmanacSet_ExtIEs = CLASS(name=u'GANSS-ALM-ECEFsbasAlmanacSet-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GANSS_ALM_ECEFsbasAlmanacSet_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GANSS-ALM-GlonassAlmanacSet >-----#
    GANSS_ALM_GlonassAlmanacSet = SEQ(name=u'GANSS-ALM-GlonassAlmanacSet', mode=MODE_TYPE)
    _GANSS_ALM_GlonassAlmanacSet_sat_info_GLOkpList = SEQ_OF(name=u'sat-info-GLOkpList', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSS-SAT-Info-Almanac-GLOkpList')))
    _GANSS_ALM_GlonassAlmanacSet_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GANSS_ALM_GlonassAlmanacSet_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GANSS_ALM_GlonassAlmanacSet_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GANSS_ALM_GlonassAlmanacSet_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_ALM_GlonassAlmanacSet_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_ALM_GlonassAlmanacSet_ie_Extensions__item__id._const_tab = ____GANSS_ALM_GlonassAlmanacSet_ie_Extensions__item__id_tab
    ___GANSS_ALM_GlonassAlmanacSet_ie_Extensions__item__id._const_tab_at = None
    ___GANSS_ALM_GlonassAlmanacSet_ie_Extensions__item__id._const_tab_id = u'id'
    ___GANSS_ALM_GlonassAlmanacSet_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GANSS_ALM_GlonassAlmanacSet_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_ALM_GlonassAlmanacSet_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_ALM_GlonassAlmanacSet_ie_Extensions__item__criticality._const_tab = ____GANSS_ALM_GlonassAlmanacSet_ie_Extensions__item__criticality_tab
    ___GANSS_ALM_GlonassAlmanacSet_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GANSS_ALM_GlonassAlmanacSet_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GANSS_ALM_GlonassAlmanacSet_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GANSS_ALM_GlonassAlmanacSet_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_ALM_GlonassAlmanacSet_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_ALM_GlonassAlmanacSet_ie_Extensions__item__extensionValue._const_tab = ____GANSS_ALM_GlonassAlmanacSet_ie_Extensions__item__extensionValue_tab
    ___GANSS_ALM_GlonassAlmanacSet_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GANSS_ALM_GlonassAlmanacSet_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GANSS_ALM_GlonassAlmanacSet_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GANSS_ALM_GlonassAlmanacSet_ie_Extensions__item__id),
        (u'criticality', ___GANSS_ALM_GlonassAlmanacSet_ie_Extensions__item__criticality),
        (u'extensionValue', ___GANSS_ALM_GlonassAlmanacSet_ie_Extensions__item__extensionValue),
        ])
    __GANSS_ALM_GlonassAlmanacSet_ie_Extensions__item_._ext = None
    _GANSS_ALM_GlonassAlmanacSet_ie_Extensions._cont = __GANSS_ALM_GlonassAlmanacSet_ie_Extensions__item_
    _GANSS_ALM_GlonassAlmanacSet_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GANSS_ALM_GlonassAlmanacSet._cont = ASN1Dict([
        (u'sat-info-GLOkpList', _GANSS_ALM_GlonassAlmanacSet_sat_info_GLOkpList),
        (u'ie-Extensions', _GANSS_ALM_GlonassAlmanacSet_ie_Extensions),
        ])
    GANSS_ALM_GlonassAlmanacSet._ext = []
    
    #-----< GANSS-ALM-GlonassAlmanacSet-ExtIEs >-----#
    GANSS_ALM_GlonassAlmanacSet_ExtIEs = CLASS(name=u'GANSS-ALM-GlonassAlmanacSet-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GANSS_ALM_GlonassAlmanacSet_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GANSS-ALM-MidiAlmanacSet >-----#
    GANSS_ALM_MidiAlmanacSet = SEQ(name=u'GANSS-ALM-MidiAlmanacSet', mode=MODE_TYPE)
    _GANSS_ALM_MidiAlmanacSet_t_oa = INT(name=u't-oa', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_ALM_MidiAlmanacSet_t_oa._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _GANSS_ALM_MidiAlmanacSet_sat_info_MIDIkpList = SEQ_OF(name=u'sat-info-MIDIkpList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSS-SAT-Info-Almanac-MIDIkpList')))
    _GANSS_ALM_MidiAlmanacSet_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GANSS_ALM_MidiAlmanacSet_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GANSS_ALM_MidiAlmanacSet_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GANSS_ALM_MidiAlmanacSet_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_ALM_MidiAlmanacSet_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_ALM_MidiAlmanacSet_ie_Extensions__item__id._const_tab = ____GANSS_ALM_MidiAlmanacSet_ie_Extensions__item__id_tab
    ___GANSS_ALM_MidiAlmanacSet_ie_Extensions__item__id._const_tab_at = None
    ___GANSS_ALM_MidiAlmanacSet_ie_Extensions__item__id._const_tab_id = u'id'
    ___GANSS_ALM_MidiAlmanacSet_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GANSS_ALM_MidiAlmanacSet_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_ALM_MidiAlmanacSet_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_ALM_MidiAlmanacSet_ie_Extensions__item__criticality._const_tab = ____GANSS_ALM_MidiAlmanacSet_ie_Extensions__item__criticality_tab
    ___GANSS_ALM_MidiAlmanacSet_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GANSS_ALM_MidiAlmanacSet_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GANSS_ALM_MidiAlmanacSet_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GANSS_ALM_MidiAlmanacSet_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_ALM_MidiAlmanacSet_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_ALM_MidiAlmanacSet_ie_Extensions__item__extensionValue._const_tab = ____GANSS_ALM_MidiAlmanacSet_ie_Extensions__item__extensionValue_tab
    ___GANSS_ALM_MidiAlmanacSet_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GANSS_ALM_MidiAlmanacSet_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GANSS_ALM_MidiAlmanacSet_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GANSS_ALM_MidiAlmanacSet_ie_Extensions__item__id),
        (u'criticality', ___GANSS_ALM_MidiAlmanacSet_ie_Extensions__item__criticality),
        (u'extensionValue', ___GANSS_ALM_MidiAlmanacSet_ie_Extensions__item__extensionValue),
        ])
    __GANSS_ALM_MidiAlmanacSet_ie_Extensions__item_._ext = None
    _GANSS_ALM_MidiAlmanacSet_ie_Extensions._cont = __GANSS_ALM_MidiAlmanacSet_ie_Extensions__item_
    _GANSS_ALM_MidiAlmanacSet_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GANSS_ALM_MidiAlmanacSet._cont = ASN1Dict([
        (u't-oa', _GANSS_ALM_MidiAlmanacSet_t_oa),
        (u'sat-info-MIDIkpList', _GANSS_ALM_MidiAlmanacSet_sat_info_MIDIkpList),
        (u'ie-Extensions', _GANSS_ALM_MidiAlmanacSet_ie_Extensions),
        ])
    GANSS_ALM_MidiAlmanacSet._ext = []
    
    #-----< GANSS-ALM-MidiAlmanacSet-ExtIEs >-----#
    GANSS_ALM_MidiAlmanacSet_ExtIEs = CLASS(name=u'GANSS-ALM-MidiAlmanacSet-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GANSS_ALM_MidiAlmanacSet_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GANSS-ALM-NAVKeplerianSet >-----#
    GANSS_ALM_NAVKeplerianSet = SEQ(name=u'GANSS-ALM-NAVKeplerianSet', mode=MODE_TYPE)
    _GANSS_ALM_NAVKeplerianSet_t_oa = INT(name=u't-oa', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_ALM_NAVKeplerianSet_t_oa._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _GANSS_ALM_NAVKeplerianSet_sat_info_NAVkpList = SEQ_OF(name=u'sat-info-NAVkpList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSS-SAT-Info-Almanac-NAVkpList')))
    _GANSS_ALM_NAVKeplerianSet_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GANSS_ALM_NAVKeplerianSet_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GANSS_ALM_NAVKeplerianSet_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GANSS_ALM_NAVKeplerianSet_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_ALM_NAVKeplerianSet_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_ALM_NAVKeplerianSet_ie_Extensions__item__id._const_tab = ____GANSS_ALM_NAVKeplerianSet_ie_Extensions__item__id_tab
    ___GANSS_ALM_NAVKeplerianSet_ie_Extensions__item__id._const_tab_at = None
    ___GANSS_ALM_NAVKeplerianSet_ie_Extensions__item__id._const_tab_id = u'id'
    ___GANSS_ALM_NAVKeplerianSet_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GANSS_ALM_NAVKeplerianSet_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_ALM_NAVKeplerianSet_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_ALM_NAVKeplerianSet_ie_Extensions__item__criticality._const_tab = ____GANSS_ALM_NAVKeplerianSet_ie_Extensions__item__criticality_tab
    ___GANSS_ALM_NAVKeplerianSet_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GANSS_ALM_NAVKeplerianSet_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GANSS_ALM_NAVKeplerianSet_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GANSS_ALM_NAVKeplerianSet_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_ALM_NAVKeplerianSet_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_ALM_NAVKeplerianSet_ie_Extensions__item__extensionValue._const_tab = ____GANSS_ALM_NAVKeplerianSet_ie_Extensions__item__extensionValue_tab
    ___GANSS_ALM_NAVKeplerianSet_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GANSS_ALM_NAVKeplerianSet_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GANSS_ALM_NAVKeplerianSet_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GANSS_ALM_NAVKeplerianSet_ie_Extensions__item__id),
        (u'criticality', ___GANSS_ALM_NAVKeplerianSet_ie_Extensions__item__criticality),
        (u'extensionValue', ___GANSS_ALM_NAVKeplerianSet_ie_Extensions__item__extensionValue),
        ])
    __GANSS_ALM_NAVKeplerianSet_ie_Extensions__item_._ext = None
    _GANSS_ALM_NAVKeplerianSet_ie_Extensions._cont = __GANSS_ALM_NAVKeplerianSet_ie_Extensions__item_
    _GANSS_ALM_NAVKeplerianSet_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GANSS_ALM_NAVKeplerianSet._cont = ASN1Dict([
        (u't-oa', _GANSS_ALM_NAVKeplerianSet_t_oa),
        (u'sat-info-NAVkpList', _GANSS_ALM_NAVKeplerianSet_sat_info_NAVkpList),
        (u'ie-Extensions', _GANSS_ALM_NAVKeplerianSet_ie_Extensions),
        ])
    GANSS_ALM_NAVKeplerianSet._ext = []
    
    #-----< GANSS-ALM-NAVKeplerianSet-ExtIEs >-----#
    GANSS_ALM_NAVKeplerianSet_ExtIEs = CLASS(name=u'GANSS-ALM-NAVKeplerianSet-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GANSS_ALM_NAVKeplerianSet_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GANSS-ALM-ReducedKeplerianSet >-----#
    GANSS_ALM_ReducedKeplerianSet = SEQ(name=u'GANSS-ALM-ReducedKeplerianSet', mode=MODE_TYPE)
    _GANSS_ALM_ReducedKeplerianSet_t_oa = INT(name=u't-oa', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_ALM_ReducedKeplerianSet_t_oa._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _GANSS_ALM_ReducedKeplerianSet_sat_info_REDkpList = SEQ_OF(name=u'sat-info-REDkpList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSS-SAT-Info-Almanac-REDkpList')))
    _GANSS_ALM_ReducedKeplerianSet_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GANSS_ALM_ReducedKeplerianSet_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GANSS_ALM_ReducedKeplerianSet_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GANSS_ALM_ReducedKeplerianSet_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_ALM_ReducedKeplerianSet_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_ALM_ReducedKeplerianSet_ie_Extensions__item__id._const_tab = ____GANSS_ALM_ReducedKeplerianSet_ie_Extensions__item__id_tab
    ___GANSS_ALM_ReducedKeplerianSet_ie_Extensions__item__id._const_tab_at = None
    ___GANSS_ALM_ReducedKeplerianSet_ie_Extensions__item__id._const_tab_id = u'id'
    ___GANSS_ALM_ReducedKeplerianSet_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GANSS_ALM_ReducedKeplerianSet_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_ALM_ReducedKeplerianSet_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_ALM_ReducedKeplerianSet_ie_Extensions__item__criticality._const_tab = ____GANSS_ALM_ReducedKeplerianSet_ie_Extensions__item__criticality_tab
    ___GANSS_ALM_ReducedKeplerianSet_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GANSS_ALM_ReducedKeplerianSet_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GANSS_ALM_ReducedKeplerianSet_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GANSS_ALM_ReducedKeplerianSet_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_ALM_ReducedKeplerianSet_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_ALM_ReducedKeplerianSet_ie_Extensions__item__extensionValue._const_tab = ____GANSS_ALM_ReducedKeplerianSet_ie_Extensions__item__extensionValue_tab
    ___GANSS_ALM_ReducedKeplerianSet_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GANSS_ALM_ReducedKeplerianSet_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GANSS_ALM_ReducedKeplerianSet_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GANSS_ALM_ReducedKeplerianSet_ie_Extensions__item__id),
        (u'criticality', ___GANSS_ALM_ReducedKeplerianSet_ie_Extensions__item__criticality),
        (u'extensionValue', ___GANSS_ALM_ReducedKeplerianSet_ie_Extensions__item__extensionValue),
        ])
    __GANSS_ALM_ReducedKeplerianSet_ie_Extensions__item_._ext = None
    _GANSS_ALM_ReducedKeplerianSet_ie_Extensions._cont = __GANSS_ALM_ReducedKeplerianSet_ie_Extensions__item_
    _GANSS_ALM_ReducedKeplerianSet_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GANSS_ALM_ReducedKeplerianSet._cont = ASN1Dict([
        (u't-oa', _GANSS_ALM_ReducedKeplerianSet_t_oa),
        (u'sat-info-REDkpList', _GANSS_ALM_ReducedKeplerianSet_sat_info_REDkpList),
        (u'ie-Extensions', _GANSS_ALM_ReducedKeplerianSet_ie_Extensions),
        ])
    GANSS_ALM_ReducedKeplerianSet._ext = []
    
    #-----< GANSS-ALM-ReducedKeplerianSet-ExtIEs >-----#
    GANSS_ALM_ReducedKeplerianSet_ExtIEs = CLASS(name=u'GANSS-ALM-ReducedKeplerianSet-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GANSS_ALM_ReducedKeplerianSet_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GANSS-AlmanacAndSatelliteHealth >-----#
    GANSS_AlmanacAndSatelliteHealth = SEQ(name=u'GANSS-AlmanacAndSatelliteHealth', mode=MODE_TYPE)
    _GANSS_AlmanacAndSatelliteHealth_weekNumber = INT(name=u'weekNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_AlmanacAndSatelliteHealth_weekNumber._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _GANSS_AlmanacAndSatelliteHealth_gANSS_AlmanacModel = CHOICE(name=u'gANSS-AlmanacModel', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSS-AlmanacModel')))
    _GANSS_AlmanacAndSatelliteHealth_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GANSS_AlmanacAndSatelliteHealth_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GANSS_AlmanacAndSatelliteHealth_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GANSS_AlmanacAndSatelliteHealth_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____GANSS_AlmanacAndSatelliteHealth_ie_Extensions__item__id_tab_val_Extension_0 = BOOL(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'CompleteAlmanacProvided')))
    ____GANSS_AlmanacAndSatelliteHealth_ie_Extensions__item__id_tab._val = ASN1Set(rv=[dict([(u'id', 120), (u'criticality', u'ignore'), (u'Extension', _____GANSS_AlmanacAndSatelliteHealth_ie_Extensions__item__id_tab_val_Extension_0), (u'presence', u'optional')])], rr=[], ev=None, er=[])
    ___GANSS_AlmanacAndSatelliteHealth_ie_Extensions__item__id._const_tab = ____GANSS_AlmanacAndSatelliteHealth_ie_Extensions__item__id_tab
    ___GANSS_AlmanacAndSatelliteHealth_ie_Extensions__item__id._const_tab_at = None
    ___GANSS_AlmanacAndSatelliteHealth_ie_Extensions__item__id._const_tab_id = u'id'
    ___GANSS_AlmanacAndSatelliteHealth_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ___GANSS_AlmanacAndSatelliteHealth_ie_Extensions__item__criticality._const_tab = ____GANSS_AlmanacAndSatelliteHealth_ie_Extensions__item__id_tab
    ___GANSS_AlmanacAndSatelliteHealth_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GANSS_AlmanacAndSatelliteHealth_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GANSS_AlmanacAndSatelliteHealth_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ___GANSS_AlmanacAndSatelliteHealth_ie_Extensions__item__extensionValue._const_tab = ____GANSS_AlmanacAndSatelliteHealth_ie_Extensions__item__id_tab
    ___GANSS_AlmanacAndSatelliteHealth_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GANSS_AlmanacAndSatelliteHealth_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GANSS_AlmanacAndSatelliteHealth_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GANSS_AlmanacAndSatelliteHealth_ie_Extensions__item__id),
        (u'criticality', ___GANSS_AlmanacAndSatelliteHealth_ie_Extensions__item__criticality),
        (u'extensionValue', ___GANSS_AlmanacAndSatelliteHealth_ie_Extensions__item__extensionValue),
        ])
    __GANSS_AlmanacAndSatelliteHealth_ie_Extensions__item_._ext = None
    _GANSS_AlmanacAndSatelliteHealth_ie_Extensions._cont = __GANSS_AlmanacAndSatelliteHealth_ie_Extensions__item_
    _GANSS_AlmanacAndSatelliteHealth_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GANSS_AlmanacAndSatelliteHealth._cont = ASN1Dict([
        (u'weekNumber', _GANSS_AlmanacAndSatelliteHealth_weekNumber),
        (u'gANSS-AlmanacModel', _GANSS_AlmanacAndSatelliteHealth_gANSS_AlmanacModel),
        (u'ie-Extensions', _GANSS_AlmanacAndSatelliteHealth_ie_Extensions),
        ])
    GANSS_AlmanacAndSatelliteHealth._ext = []
    
    #-----< GANSS-AlmanacAndSatelliteHealth-ExtIEs >-----#
    GANSS_AlmanacAndSatelliteHealth_ExtIEs = CLASS(name=u'GANSS-AlmanacAndSatelliteHealth-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _GANSS_AlmanacAndSatelliteHealth_ExtIEs_val_Extension_0 = BOOL(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'CompleteAlmanacProvided')))
    GANSS_AlmanacAndSatelliteHealth_ExtIEs._val = ASN1Set(rv=[dict([(u'id', 120), (u'criticality', u'ignore'), (u'Extension', _GANSS_AlmanacAndSatelliteHealth_ExtIEs_val_Extension_0), (u'presence', u'optional')])], rr=[], ev=[], er=[])
    
    #-----< GANSS-AlmanacModel >-----#
    GANSS_AlmanacModel = CHOICE(name=u'GANSS-AlmanacModel', mode=MODE_TYPE)
    _GANSS_AlmanacModel_gANSS_keplerianParameters = SEQ(name=u'gANSS-keplerianParameters', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSS-KeplerianParametersAlm')))
    _GANSS_AlmanacModel_extension_GANSS_AlmanacModel = SEQ(name=u'extension-GANSS-AlmanacModel', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'Extension-GANSS-AlmanacModel')))
    GANSS_AlmanacModel._cont = ASN1Dict([
        (u'gANSS-keplerianParameters', _GANSS_AlmanacModel_gANSS_keplerianParameters),
        (u'extension-GANSS-AlmanacModel', _GANSS_AlmanacModel_extension_GANSS_AlmanacModel),
        ])
    GANSS_AlmanacModel._ext = [u'extension-GANSS-AlmanacModel']
    
    #-----< Extension-GANSS-AlmanacModel >-----#
    Extension_GANSS_AlmanacModel = SEQ(name=u'Extension-GANSS-AlmanacModel', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolIE-Single-Container')))
    _Extension_GANSS_AlmanacModel_id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-IES'), [u'id']))
    __Extension_GANSS_AlmanacModel_id_tab = CLASS(name='_tab_PCAP-PROTOCOL-IES', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-IES')))
    ___Extension_GANSS_AlmanacModel_id_tab_val_Value_0 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-ALM-NAVKeplerianSet')))
    ___Extension_GANSS_AlmanacModel_id_tab_val_Value_1 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-ALM-ReducedKeplerianSet')))
    ___Extension_GANSS_AlmanacModel_id_tab_val_Value_2 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-ALM-MidiAlmanacSet')))
    ___Extension_GANSS_AlmanacModel_id_tab_val_Value_3 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-ALM-GlonassAlmanacSet')))
    ___Extension_GANSS_AlmanacModel_id_tab_val_Value_4 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-ALM-ECEFsbasAlmanacSet')))
    ___Extension_GANSS_AlmanacModel_id_tab_val_Value_5 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-ALM-BDSKeplericanset')))
    __Extension_GANSS_AlmanacModel_id_tab._val = ASN1Set(rv=[dict([(u'id', 109), (u'criticality', u'ignore'), (u'Value', ___Extension_GANSS_AlmanacModel_id_tab_val_Value_0), (u'presence', u'mandatory')]), dict([(u'id', 110), (u'criticality', u'ignore'), (u'Value', ___Extension_GANSS_AlmanacModel_id_tab_val_Value_1), (u'presence', u'mandatory')]), dict([(u'id', 111), (u'criticality', u'ignore'), (u'Value', ___Extension_GANSS_AlmanacModel_id_tab_val_Value_2), (u'presence', u'mandatory')]), dict([(u'id', 112), (u'criticality', u'ignore'), (u'Value', ___Extension_GANSS_AlmanacModel_id_tab_val_Value_3), (u'presence', u'mandatory')]), dict([(u'id', 113), (u'criticality', u'ignore'), (u'Value', ___Extension_GANSS_AlmanacModel_id_tab_val_Value_4), (u'presence', u'mandatory')]), dict([(u'id', 130), (u'criticality', u'ignore'), (u'Value', ___Extension_GANSS_AlmanacModel_id_tab_val_Value_5), (u'presence', u'mandatory')])], rr=[], ev=None, er=[])
    _Extension_GANSS_AlmanacModel_id._const_tab = __Extension_GANSS_AlmanacModel_id_tab
    _Extension_GANSS_AlmanacModel_id._const_tab_at = None
    _Extension_GANSS_AlmanacModel_id._const_tab_id = u'id'
    _Extension_GANSS_AlmanacModel_criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-IES'), [u'criticality']))
    _Extension_GANSS_AlmanacModel_criticality._const_tab = __Extension_GANSS_AlmanacModel_id_tab
    _Extension_GANSS_AlmanacModel_criticality._const_tab_at = ('..', u'id')
    _Extension_GANSS_AlmanacModel_criticality._const_tab_id = u'criticality'
    _Extension_GANSS_AlmanacModel_value = OPEN(name=u'value', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-IES'), [u'Value']))
    _Extension_GANSS_AlmanacModel_value._const_tab = __Extension_GANSS_AlmanacModel_id_tab
    _Extension_GANSS_AlmanacModel_value._const_tab_at = ('..', u'id')
    _Extension_GANSS_AlmanacModel_value._const_tab_id = u'Value'
    Extension_GANSS_AlmanacModel._cont = ASN1Dict([
        (u'id', _Extension_GANSS_AlmanacModel_id),
        (u'criticality', _Extension_GANSS_AlmanacModel_criticality),
        (u'value', _Extension_GANSS_AlmanacModel_value),
        ])
    Extension_GANSS_AlmanacModel._ext = None
    
    #-----< Extension-GANSS-AlmanacModel-IE >-----#
    Extension_GANSS_AlmanacModel_IE = CLASS(name=u'Extension-GANSS-AlmanacModel-IE', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-IES')))
    _Extension_GANSS_AlmanacModel_IE_val_Value_0 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-ALM-NAVKeplerianSet')))
    _Extension_GANSS_AlmanacModel_IE_val_Value_1 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-ALM-ReducedKeplerianSet')))
    _Extension_GANSS_AlmanacModel_IE_val_Value_2 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-ALM-MidiAlmanacSet')))
    _Extension_GANSS_AlmanacModel_IE_val_Value_3 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-ALM-GlonassAlmanacSet')))
    _Extension_GANSS_AlmanacModel_IE_val_Value_4 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-ALM-ECEFsbasAlmanacSet')))
    _Extension_GANSS_AlmanacModel_IE_val_Value_5 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-ALM-BDSKeplericanset')))
    Extension_GANSS_AlmanacModel_IE._val = ASN1Set(rv=[dict([(u'id', 109), (u'criticality', u'ignore'), (u'Value', _Extension_GANSS_AlmanacModel_IE_val_Value_0), (u'presence', u'mandatory')]), dict([(u'id', 110), (u'criticality', u'ignore'), (u'Value', _Extension_GANSS_AlmanacModel_IE_val_Value_1), (u'presence', u'mandatory')]), dict([(u'id', 111), (u'criticality', u'ignore'), (u'Value', _Extension_GANSS_AlmanacModel_IE_val_Value_2), (u'presence', u'mandatory')]), dict([(u'id', 112), (u'criticality', u'ignore'), (u'Value', _Extension_GANSS_AlmanacModel_IE_val_Value_3), (u'presence', u'mandatory')]), dict([(u'id', 113), (u'criticality', u'ignore'), (u'Value', _Extension_GANSS_AlmanacModel_IE_val_Value_4), (u'presence', u'mandatory')]), dict([(u'id', 130), (u'criticality', u'ignore'), (u'Value', _Extension_GANSS_AlmanacModel_IE_val_Value_5), (u'presence', u'mandatory')])], rr=[], ev=None, er=[])
    
    #-----< GANSS-Auxiliary-Information >-----#
    GANSS_Auxiliary_Information = CHOICE(name=u'GANSS-Auxiliary-Information', mode=MODE_TYPE)
    _GANSS_Auxiliary_Information_ganssID1 = SEQ_OF(name=u'ganssID1', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'AuxInfoGANSS-ID1')))
    _GANSS_Auxiliary_Information_ganssID3 = SEQ_OF(name=u'ganssID3', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'AuxInfoGANSS-ID3')))
    GANSS_Auxiliary_Information._cont = ASN1Dict([
        (u'ganssID1', _GANSS_Auxiliary_Information_ganssID1),
        (u'ganssID3', _GANSS_Auxiliary_Information_ganssID3),
        ])
    GANSS_Auxiliary_Information._ext = []
    
    #-----< GANSS-AzimuthAndElevation >-----#
    GANSS_AzimuthAndElevation = SEQ(name=u'GANSS-AzimuthAndElevation', mode=MODE_TYPE)
    _GANSS_AzimuthAndElevation_azimuth = INT(name=u'azimuth', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_AzimuthAndElevation_azimuth._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=31)], ev=None, er=[])
    _GANSS_AzimuthAndElevation_elevation = INT(name=u'elevation', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_AzimuthAndElevation_elevation._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=75)], ev=None, er=[])
    _GANSS_AzimuthAndElevation_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GANSS_AzimuthAndElevation_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GANSS_AzimuthAndElevation_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GANSS_AzimuthAndElevation_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____GANSS_AzimuthAndElevation_ie_Extensions__item__id_tab_val_Extension_0 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'AzimuthAndElevationLSB')))
    ____GANSS_AzimuthAndElevation_ie_Extensions__item__id_tab._val = ASN1Set(rv=[dict([(u'id', 119), (u'criticality', u'ignore'), (u'Extension', _____GANSS_AzimuthAndElevation_ie_Extensions__item__id_tab_val_Extension_0), (u'presence', u'optional')])], rr=[], ev=None, er=[])
    ___GANSS_AzimuthAndElevation_ie_Extensions__item__id._const_tab = ____GANSS_AzimuthAndElevation_ie_Extensions__item__id_tab
    ___GANSS_AzimuthAndElevation_ie_Extensions__item__id._const_tab_at = None
    ___GANSS_AzimuthAndElevation_ie_Extensions__item__id._const_tab_id = u'id'
    ___GANSS_AzimuthAndElevation_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ___GANSS_AzimuthAndElevation_ie_Extensions__item__criticality._const_tab = ____GANSS_AzimuthAndElevation_ie_Extensions__item__id_tab
    ___GANSS_AzimuthAndElevation_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GANSS_AzimuthAndElevation_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GANSS_AzimuthAndElevation_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ___GANSS_AzimuthAndElevation_ie_Extensions__item__extensionValue._const_tab = ____GANSS_AzimuthAndElevation_ie_Extensions__item__id_tab
    ___GANSS_AzimuthAndElevation_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GANSS_AzimuthAndElevation_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GANSS_AzimuthAndElevation_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GANSS_AzimuthAndElevation_ie_Extensions__item__id),
        (u'criticality', ___GANSS_AzimuthAndElevation_ie_Extensions__item__criticality),
        (u'extensionValue', ___GANSS_AzimuthAndElevation_ie_Extensions__item__extensionValue),
        ])
    __GANSS_AzimuthAndElevation_ie_Extensions__item_._ext = None
    _GANSS_AzimuthAndElevation_ie_Extensions._cont = __GANSS_AzimuthAndElevation_ie_Extensions__item_
    _GANSS_AzimuthAndElevation_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GANSS_AzimuthAndElevation._cont = ASN1Dict([
        (u'azimuth', _GANSS_AzimuthAndElevation_azimuth),
        (u'elevation', _GANSS_AzimuthAndElevation_elevation),
        (u'ie-Extensions', _GANSS_AzimuthAndElevation_ie_Extensions),
        ])
    GANSS_AzimuthAndElevation._ext = []
    
    #-----< GANSS-AzimuthAndElevation-ExtIEs >-----#
    GANSS_AzimuthAndElevation_ExtIEs = CLASS(name=u'GANSS-AzimuthAndElevation-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _GANSS_AzimuthAndElevation_ExtIEs_val_Extension_0 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'AzimuthAndElevationLSB')))
    GANSS_AzimuthAndElevation_ExtIEs._val = ASN1Set(rv=[dict([(u'id', 119), (u'criticality', u'ignore'), (u'Extension', _GANSS_AzimuthAndElevation_ExtIEs_val_Extension_0), (u'presence', u'optional')])], rr=[], ev=[], er=[])
    
    #-----< GANSS-Clock-Model >-----#
    GANSS_Clock_Model = SEQ_OF(name=u'GANSS-Clock-Model', mode=MODE_TYPE)
    _GANSS_Clock_Model__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-SatelliteClockModelItem')))
    GANSS_Clock_Model._cont = _GANSS_Clock_Model__item_
    GANSS_Clock_Model._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4)], ev=None, er=[])
    
    #-----< GANSS-CommonAssistanceData >-----#
    GANSS_CommonAssistanceData = SEQ(name=u'GANSS-CommonAssistanceData', mode=MODE_TYPE)
    _GANSS_CommonAssistanceData_ganss_Reference_Time = SEQ(name=u'ganss-Reference-Time', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSS-Reference-Time')), opt=True)
    _GANSS_CommonAssistanceData_ganss_Ionospheric_Model = SEQ(name=u'ganss-Ionospheric-Model', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSS-Ionospheric-Model')), opt=True)
    _GANSS_CommonAssistanceData_ganss_Reference_Location = SEQ(name=u'ganss-Reference-Location', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSS-Reference-Location')), opt=True)
    _GANSS_CommonAssistanceData_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GANSS_CommonAssistanceData_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GANSS_CommonAssistanceData_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GANSS_CommonAssistanceData_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____GANSS_CommonAssistanceData_ie_Extensions__item__id_tab_val_Extension_0 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-Additional-Ionospheric-Model')))
    _____GANSS_CommonAssistanceData_ie_Extensions__item__id_tab_val_Extension_1 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-Earth-Orientation-Parameters')))
    ____GANSS_CommonAssistanceData_ie_Extensions__item__id_tab._val = ASN1Set(rv=[dict([(u'id', 88), (u'criticality', u'ignore'), (u'Extension', _____GANSS_CommonAssistanceData_ie_Extensions__item__id_tab_val_Extension_0), (u'presence', u'optional')]), dict([(u'id', 89), (u'criticality', u'ignore'), (u'Extension', _____GANSS_CommonAssistanceData_ie_Extensions__item__id_tab_val_Extension_1), (u'presence', u'optional')])], rr=[], ev=None, er=[])
    ___GANSS_CommonAssistanceData_ie_Extensions__item__id._const_tab = ____GANSS_CommonAssistanceData_ie_Extensions__item__id_tab
    ___GANSS_CommonAssistanceData_ie_Extensions__item__id._const_tab_at = None
    ___GANSS_CommonAssistanceData_ie_Extensions__item__id._const_tab_id = u'id'
    ___GANSS_CommonAssistanceData_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ___GANSS_CommonAssistanceData_ie_Extensions__item__criticality._const_tab = ____GANSS_CommonAssistanceData_ie_Extensions__item__id_tab
    ___GANSS_CommonAssistanceData_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GANSS_CommonAssistanceData_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GANSS_CommonAssistanceData_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ___GANSS_CommonAssistanceData_ie_Extensions__item__extensionValue._const_tab = ____GANSS_CommonAssistanceData_ie_Extensions__item__id_tab
    ___GANSS_CommonAssistanceData_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GANSS_CommonAssistanceData_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GANSS_CommonAssistanceData_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GANSS_CommonAssistanceData_ie_Extensions__item__id),
        (u'criticality', ___GANSS_CommonAssistanceData_ie_Extensions__item__criticality),
        (u'extensionValue', ___GANSS_CommonAssistanceData_ie_Extensions__item__extensionValue),
        ])
    __GANSS_CommonAssistanceData_ie_Extensions__item_._ext = None
    _GANSS_CommonAssistanceData_ie_Extensions._cont = __GANSS_CommonAssistanceData_ie_Extensions__item_
    _GANSS_CommonAssistanceData_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GANSS_CommonAssistanceData._cont = ASN1Dict([
        (u'ganss-Reference-Time', _GANSS_CommonAssistanceData_ganss_Reference_Time),
        (u'ganss-Ionospheric-Model', _GANSS_CommonAssistanceData_ganss_Ionospheric_Model),
        (u'ganss-Reference-Location', _GANSS_CommonAssistanceData_ganss_Reference_Location),
        (u'ie-Extensions', _GANSS_CommonAssistanceData_ie_Extensions),
        ])
    GANSS_CommonAssistanceData._ext = []
    
    #-----< GANSS-CommonAssistanceData-ExtIEs >-----#
    GANSS_CommonAssistanceData_ExtIEs = CLASS(name=u'GANSS-CommonAssistanceData-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _GANSS_CommonAssistanceData_ExtIEs_val_Extension_0 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-Additional-Ionospheric-Model')))
    _GANSS_CommonAssistanceData_ExtIEs_val_Extension_1 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-Earth-Orientation-Parameters')))
    GANSS_CommonAssistanceData_ExtIEs._val = ASN1Set(rv=[dict([(u'id', 88), (u'criticality', u'ignore'), (u'Extension', _GANSS_CommonAssistanceData_ExtIEs_val_Extension_0), (u'presence', u'optional')]), dict([(u'id', 89), (u'criticality', u'ignore'), (u'Extension', _GANSS_CommonAssistanceData_ExtIEs_val_Extension_1), (u'presence', u'optional')])], rr=[], ev=[], er=[])
    
    #-----< GANSS-Data-Bit-Assistance >-----#
    GANSS_Data_Bit_Assistance = SEQ(name=u'GANSS-Data-Bit-Assistance', mode=MODE_TYPE)
    _GANSS_Data_Bit_Assistance_ganssTod = INT(name=u'ganssTod', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_Data_Bit_Assistance_ganssTod._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=59)], ev=[], er=[])
    _GANSS_Data_Bit_Assistance_dataBitAssistancelist = SEQ_OF(name=u'dataBitAssistancelist', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSS-DataBitAssistanceList')))
    _GANSS_Data_Bit_Assistance_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GANSS_Data_Bit_Assistance_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GANSS_Data_Bit_Assistance_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GANSS_Data_Bit_Assistance_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_Data_Bit_Assistance_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_Data_Bit_Assistance_ie_Extensions__item__id._const_tab = ____GANSS_Data_Bit_Assistance_ie_Extensions__item__id_tab
    ___GANSS_Data_Bit_Assistance_ie_Extensions__item__id._const_tab_at = None
    ___GANSS_Data_Bit_Assistance_ie_Extensions__item__id._const_tab_id = u'id'
    ___GANSS_Data_Bit_Assistance_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GANSS_Data_Bit_Assistance_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_Data_Bit_Assistance_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_Data_Bit_Assistance_ie_Extensions__item__criticality._const_tab = ____GANSS_Data_Bit_Assistance_ie_Extensions__item__criticality_tab
    ___GANSS_Data_Bit_Assistance_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GANSS_Data_Bit_Assistance_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GANSS_Data_Bit_Assistance_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GANSS_Data_Bit_Assistance_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_Data_Bit_Assistance_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_Data_Bit_Assistance_ie_Extensions__item__extensionValue._const_tab = ____GANSS_Data_Bit_Assistance_ie_Extensions__item__extensionValue_tab
    ___GANSS_Data_Bit_Assistance_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GANSS_Data_Bit_Assistance_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GANSS_Data_Bit_Assistance_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GANSS_Data_Bit_Assistance_ie_Extensions__item__id),
        (u'criticality', ___GANSS_Data_Bit_Assistance_ie_Extensions__item__criticality),
        (u'extensionValue', ___GANSS_Data_Bit_Assistance_ie_Extensions__item__extensionValue),
        ])
    __GANSS_Data_Bit_Assistance_ie_Extensions__item_._ext = None
    _GANSS_Data_Bit_Assistance_ie_Extensions._cont = __GANSS_Data_Bit_Assistance_ie_Extensions__item_
    _GANSS_Data_Bit_Assistance_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GANSS_Data_Bit_Assistance._cont = ASN1Dict([
        (u'ganssTod', _GANSS_Data_Bit_Assistance_ganssTod),
        (u'dataBitAssistancelist', _GANSS_Data_Bit_Assistance_dataBitAssistancelist),
        (u'ie-Extensions', _GANSS_Data_Bit_Assistance_ie_Extensions),
        ])
    GANSS_Data_Bit_Assistance._ext = []
    
    #-----< GANSS-Data-Bit-Assistance-ExtIEs >-----#
    GANSS_Data_Bit_Assistance_ExtIEs = CLASS(name=u'GANSS-Data-Bit-Assistance-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GANSS_Data_Bit_Assistance_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GANSS-DataBitAssistanceList >-----#
    GANSS_DataBitAssistanceList = SEQ_OF(name=u'GANSS-DataBitAssistanceList', mode=MODE_TYPE)
    _GANSS_DataBitAssistanceList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-DataBitAssistanceItem')))
    GANSS_DataBitAssistanceList._cont = _GANSS_DataBitAssistanceList__item_
    GANSS_DataBitAssistanceList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    
    #-----< GANSS-DataBitAssistanceItem >-----#
    GANSS_DataBitAssistanceItem = SEQ(name=u'GANSS-DataBitAssistanceItem', mode=MODE_TYPE)
    _GANSS_DataBitAssistanceItem_satId = INT(name=u'satId', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_DataBitAssistanceItem_satId._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    _GANSS_DataBitAssistanceItem_dataBitAssistanceSgnList = SEQ_OF(name=u'dataBitAssistanceSgnList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSS-DataBitAssistanceSgnList')))
    _GANSS_DataBitAssistanceItem_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GANSS_DataBitAssistanceItem_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GANSS_DataBitAssistanceItem_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GANSS_DataBitAssistanceItem_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_DataBitAssistanceItem_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_DataBitAssistanceItem_ie_Extensions__item__id._const_tab = ____GANSS_DataBitAssistanceItem_ie_Extensions__item__id_tab
    ___GANSS_DataBitAssistanceItem_ie_Extensions__item__id._const_tab_at = None
    ___GANSS_DataBitAssistanceItem_ie_Extensions__item__id._const_tab_id = u'id'
    ___GANSS_DataBitAssistanceItem_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GANSS_DataBitAssistanceItem_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_DataBitAssistanceItem_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_DataBitAssistanceItem_ie_Extensions__item__criticality._const_tab = ____GANSS_DataBitAssistanceItem_ie_Extensions__item__criticality_tab
    ___GANSS_DataBitAssistanceItem_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GANSS_DataBitAssistanceItem_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GANSS_DataBitAssistanceItem_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GANSS_DataBitAssistanceItem_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_DataBitAssistanceItem_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_DataBitAssistanceItem_ie_Extensions__item__extensionValue._const_tab = ____GANSS_DataBitAssistanceItem_ie_Extensions__item__extensionValue_tab
    ___GANSS_DataBitAssistanceItem_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GANSS_DataBitAssistanceItem_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GANSS_DataBitAssistanceItem_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GANSS_DataBitAssistanceItem_ie_Extensions__item__id),
        (u'criticality', ___GANSS_DataBitAssistanceItem_ie_Extensions__item__criticality),
        (u'extensionValue', ___GANSS_DataBitAssistanceItem_ie_Extensions__item__extensionValue),
        ])
    __GANSS_DataBitAssistanceItem_ie_Extensions__item_._ext = None
    _GANSS_DataBitAssistanceItem_ie_Extensions._cont = __GANSS_DataBitAssistanceItem_ie_Extensions__item_
    _GANSS_DataBitAssistanceItem_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GANSS_DataBitAssistanceItem._cont = ASN1Dict([
        (u'satId', _GANSS_DataBitAssistanceItem_satId),
        (u'dataBitAssistanceSgnList', _GANSS_DataBitAssistanceItem_dataBitAssistanceSgnList),
        (u'ie-Extensions', _GANSS_DataBitAssistanceItem_ie_Extensions),
        ])
    GANSS_DataBitAssistanceItem._ext = []
    
    #-----< GANSS-DataBitAssistanceItem-ExtIEs >-----#
    GANSS_DataBitAssistanceItem_ExtIEs = CLASS(name=u'GANSS-DataBitAssistanceItem-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GANSS_DataBitAssistanceItem_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GANSS-DataBitAssistanceSgnList >-----#
    GANSS_DataBitAssistanceSgnList = SEQ_OF(name=u'GANSS-DataBitAssistanceSgnList', mode=MODE_TYPE)
    _GANSS_DataBitAssistanceSgnList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-DataBitAssistanceSgnItem')))
    GANSS_DataBitAssistanceSgnList._cont = _GANSS_DataBitAssistanceSgnList__item_
    GANSS_DataBitAssistanceSgnList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    
    #-----< GANSS-DataBitAssistanceSgnItem >-----#
    GANSS_DataBitAssistanceSgnItem = SEQ(name=u'GANSS-DataBitAssistanceSgnItem', mode=MODE_TYPE)
    _GANSS_DataBitAssistanceSgnItem_ganss_SignalId = SEQ(name=u'ganss-SignalId', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSS-SignalID')))
    _GANSS_DataBitAssistanceSgnItem_ganssDataBits = BIT_STR(name=u'ganssDataBits', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_DataBitAssistanceSgnItem_ganssDataBits._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=1024)], ev=None, er=[])
    _GANSS_DataBitAssistanceSgnItem_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GANSS_DataBitAssistanceSgnItem_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GANSS_DataBitAssistanceSgnItem_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GANSS_DataBitAssistanceSgnItem_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_DataBitAssistanceSgnItem_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_DataBitAssistanceSgnItem_ie_Extensions__item__id._const_tab = ____GANSS_DataBitAssistanceSgnItem_ie_Extensions__item__id_tab
    ___GANSS_DataBitAssistanceSgnItem_ie_Extensions__item__id._const_tab_at = None
    ___GANSS_DataBitAssistanceSgnItem_ie_Extensions__item__id._const_tab_id = u'id'
    ___GANSS_DataBitAssistanceSgnItem_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GANSS_DataBitAssistanceSgnItem_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_DataBitAssistanceSgnItem_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_DataBitAssistanceSgnItem_ie_Extensions__item__criticality._const_tab = ____GANSS_DataBitAssistanceSgnItem_ie_Extensions__item__criticality_tab
    ___GANSS_DataBitAssistanceSgnItem_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GANSS_DataBitAssistanceSgnItem_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GANSS_DataBitAssistanceSgnItem_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GANSS_DataBitAssistanceSgnItem_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_DataBitAssistanceSgnItem_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_DataBitAssistanceSgnItem_ie_Extensions__item__extensionValue._const_tab = ____GANSS_DataBitAssistanceSgnItem_ie_Extensions__item__extensionValue_tab
    ___GANSS_DataBitAssistanceSgnItem_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GANSS_DataBitAssistanceSgnItem_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GANSS_DataBitAssistanceSgnItem_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GANSS_DataBitAssistanceSgnItem_ie_Extensions__item__id),
        (u'criticality', ___GANSS_DataBitAssistanceSgnItem_ie_Extensions__item__criticality),
        (u'extensionValue', ___GANSS_DataBitAssistanceSgnItem_ie_Extensions__item__extensionValue),
        ])
    __GANSS_DataBitAssistanceSgnItem_ie_Extensions__item_._ext = None
    _GANSS_DataBitAssistanceSgnItem_ie_Extensions._cont = __GANSS_DataBitAssistanceSgnItem_ie_Extensions__item_
    _GANSS_DataBitAssistanceSgnItem_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GANSS_DataBitAssistanceSgnItem._cont = ASN1Dict([
        (u'ganss-SignalId', _GANSS_DataBitAssistanceSgnItem_ganss_SignalId),
        (u'ganssDataBits', _GANSS_DataBitAssistanceSgnItem_ganssDataBits),
        (u'ie-Extensions', _GANSS_DataBitAssistanceSgnItem_ie_Extensions),
        ])
    GANSS_DataBitAssistanceSgnItem._ext = []
    
    #-----< GANSS-DataBitAssistanceSgnItem-ExtIEs >-----#
    GANSS_DataBitAssistanceSgnItem_ExtIEs = CLASS(name=u'GANSS-DataBitAssistanceSgnItem-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GANSS_DataBitAssistanceSgnItem_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GANSS-Earth-Orientation-Parameters >-----#
    GANSS_Earth_Orientation_Parameters = SEQ(name=u'GANSS-Earth-Orientation-Parameters', mode=MODE_TYPE)
    _GANSS_Earth_Orientation_Parameters_teop = BIT_STR(name=u'teop', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_Earth_Orientation_Parameters_teop._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _GANSS_Earth_Orientation_Parameters_pmX = BIT_STR(name=u'pmX', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_Earth_Orientation_Parameters_pmX._const_sz = ASN1Set(rv=[21], rr=[], ev=None, er=[])
    _GANSS_Earth_Orientation_Parameters_pmXdot = BIT_STR(name=u'pmXdot', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_Earth_Orientation_Parameters_pmXdot._const_sz = ASN1Set(rv=[15], rr=[], ev=None, er=[])
    _GANSS_Earth_Orientation_Parameters_pmY = BIT_STR(name=u'pmY', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_Earth_Orientation_Parameters_pmY._const_sz = ASN1Set(rv=[21], rr=[], ev=None, er=[])
    _GANSS_Earth_Orientation_Parameters_pmYdot = BIT_STR(name=u'pmYdot', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_Earth_Orientation_Parameters_pmYdot._const_sz = ASN1Set(rv=[15], rr=[], ev=None, er=[])
    _GANSS_Earth_Orientation_Parameters_deltaUT1 = BIT_STR(name=u'deltaUT1', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_Earth_Orientation_Parameters_deltaUT1._const_sz = ASN1Set(rv=[31], rr=[], ev=None, er=[])
    _GANSS_Earth_Orientation_Parameters_deltaUT1dot = BIT_STR(name=u'deltaUT1dot', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_Earth_Orientation_Parameters_deltaUT1dot._const_sz = ASN1Set(rv=[19], rr=[], ev=None, er=[])
    _GANSS_Earth_Orientation_Parameters_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GANSS_Earth_Orientation_Parameters_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GANSS_Earth_Orientation_Parameters_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GANSS_Earth_Orientation_Parameters_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_Earth_Orientation_Parameters_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_Earth_Orientation_Parameters_ie_Extensions__item__id._const_tab = ____GANSS_Earth_Orientation_Parameters_ie_Extensions__item__id_tab
    ___GANSS_Earth_Orientation_Parameters_ie_Extensions__item__id._const_tab_at = None
    ___GANSS_Earth_Orientation_Parameters_ie_Extensions__item__id._const_tab_id = u'id'
    ___GANSS_Earth_Orientation_Parameters_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GANSS_Earth_Orientation_Parameters_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_Earth_Orientation_Parameters_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_Earth_Orientation_Parameters_ie_Extensions__item__criticality._const_tab = ____GANSS_Earth_Orientation_Parameters_ie_Extensions__item__criticality_tab
    ___GANSS_Earth_Orientation_Parameters_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GANSS_Earth_Orientation_Parameters_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GANSS_Earth_Orientation_Parameters_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GANSS_Earth_Orientation_Parameters_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_Earth_Orientation_Parameters_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_Earth_Orientation_Parameters_ie_Extensions__item__extensionValue._const_tab = ____GANSS_Earth_Orientation_Parameters_ie_Extensions__item__extensionValue_tab
    ___GANSS_Earth_Orientation_Parameters_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GANSS_Earth_Orientation_Parameters_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GANSS_Earth_Orientation_Parameters_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GANSS_Earth_Orientation_Parameters_ie_Extensions__item__id),
        (u'criticality', ___GANSS_Earth_Orientation_Parameters_ie_Extensions__item__criticality),
        (u'extensionValue', ___GANSS_Earth_Orientation_Parameters_ie_Extensions__item__extensionValue),
        ])
    __GANSS_Earth_Orientation_Parameters_ie_Extensions__item_._ext = None
    _GANSS_Earth_Orientation_Parameters_ie_Extensions._cont = __GANSS_Earth_Orientation_Parameters_ie_Extensions__item_
    _GANSS_Earth_Orientation_Parameters_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GANSS_Earth_Orientation_Parameters._cont = ASN1Dict([
        (u'teop', _GANSS_Earth_Orientation_Parameters_teop),
        (u'pmX', _GANSS_Earth_Orientation_Parameters_pmX),
        (u'pmXdot', _GANSS_Earth_Orientation_Parameters_pmXdot),
        (u'pmY', _GANSS_Earth_Orientation_Parameters_pmY),
        (u'pmYdot', _GANSS_Earth_Orientation_Parameters_pmYdot),
        (u'deltaUT1', _GANSS_Earth_Orientation_Parameters_deltaUT1),
        (u'deltaUT1dot', _GANSS_Earth_Orientation_Parameters_deltaUT1dot),
        (u'ie-Extensions', _GANSS_Earth_Orientation_Parameters_ie_Extensions),
        ])
    GANSS_Earth_Orientation_Parameters._ext = []
    
    #-----< GANSS-Earth-Orientation-Parameters-ExtIEs >-----#
    GANSS_Earth_Orientation_Parameters_ExtIEs = CLASS(name=u'GANSS-Earth-Orientation-Parameters-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GANSS_Earth_Orientation_Parameters_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GANSS-ExtraDoppler >-----#
    GANSS_ExtraDoppler = SEQ(name=u'GANSS-ExtraDoppler', mode=MODE_TYPE)
    _GANSS_ExtraDoppler_dopplerFirstOrder = INT(name=u'dopplerFirstOrder', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_ExtraDoppler_dopplerFirstOrder._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-42, ub=21)], ev=None, er=[])
    _GANSS_ExtraDoppler_dopplerUncertainty = ENUM(name=u'dopplerUncertainty', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_ExtraDoppler_dopplerUncertainty._cont = ASN1Dict([(u'dH40', 0), (u'dH20', 1), (u'dH10', 2), (u'dH5', 3), (u'dH2-5', 4)])
    _GANSS_ExtraDoppler_dopplerUncertainty._ext = None
    _GANSS_ExtraDoppler_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GANSS_ExtraDoppler_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GANSS_ExtraDoppler_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GANSS_ExtraDoppler_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_ExtraDoppler_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_ExtraDoppler_ie_Extensions__item__id._const_tab = ____GANSS_ExtraDoppler_ie_Extensions__item__id_tab
    ___GANSS_ExtraDoppler_ie_Extensions__item__id._const_tab_at = None
    ___GANSS_ExtraDoppler_ie_Extensions__item__id._const_tab_id = u'id'
    ___GANSS_ExtraDoppler_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GANSS_ExtraDoppler_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_ExtraDoppler_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_ExtraDoppler_ie_Extensions__item__criticality._const_tab = ____GANSS_ExtraDoppler_ie_Extensions__item__criticality_tab
    ___GANSS_ExtraDoppler_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GANSS_ExtraDoppler_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GANSS_ExtraDoppler_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GANSS_ExtraDoppler_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_ExtraDoppler_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_ExtraDoppler_ie_Extensions__item__extensionValue._const_tab = ____GANSS_ExtraDoppler_ie_Extensions__item__extensionValue_tab
    ___GANSS_ExtraDoppler_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GANSS_ExtraDoppler_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GANSS_ExtraDoppler_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GANSS_ExtraDoppler_ie_Extensions__item__id),
        (u'criticality', ___GANSS_ExtraDoppler_ie_Extensions__item__criticality),
        (u'extensionValue', ___GANSS_ExtraDoppler_ie_Extensions__item__extensionValue),
        ])
    __GANSS_ExtraDoppler_ie_Extensions__item_._ext = None
    _GANSS_ExtraDoppler_ie_Extensions._cont = __GANSS_ExtraDoppler_ie_Extensions__item_
    _GANSS_ExtraDoppler_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GANSS_ExtraDoppler._cont = ASN1Dict([
        (u'dopplerFirstOrder', _GANSS_ExtraDoppler_dopplerFirstOrder),
        (u'dopplerUncertainty', _GANSS_ExtraDoppler_dopplerUncertainty),
        (u'ie-Extensions', _GANSS_ExtraDoppler_ie_Extensions),
        ])
    GANSS_ExtraDoppler._ext = []
    
    #-----< GANSS-ExtraDoppler-ExtIEs >-----#
    GANSS_ExtraDoppler_ExtIEs = CLASS(name=u'GANSS-ExtraDoppler-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GANSS_ExtraDoppler_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GANSS-ExtraDopplerExtension >-----#
    GANSS_ExtraDopplerExtension = SEQ(name=u'GANSS-ExtraDopplerExtension', mode=MODE_TYPE)
    _GANSS_ExtraDopplerExtension_dopplerFirstOrder = INT(name=u'dopplerFirstOrder', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_ExtraDopplerExtension_dopplerFirstOrder._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-42, ub=21)], ev=None, er=[])
    _GANSS_ExtraDopplerExtension_dopplerUncertaintyExtension = ENUM(name=u'dopplerUncertaintyExtension', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_ExtraDopplerExtension_dopplerUncertaintyExtension._cont = ASN1Dict([(u'dH60', 0), (u'dH80', 1), (u'dH100', 2), (u'dH120', 3), (u'noInformation', 4)])
    _GANSS_ExtraDopplerExtension_dopplerUncertaintyExtension._ext = None
    _GANSS_ExtraDopplerExtension_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GANSS_ExtraDopplerExtension_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GANSS_ExtraDopplerExtension_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GANSS_ExtraDopplerExtension_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_ExtraDopplerExtension_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_ExtraDopplerExtension_ie_Extensions__item__id._const_tab = ____GANSS_ExtraDopplerExtension_ie_Extensions__item__id_tab
    ___GANSS_ExtraDopplerExtension_ie_Extensions__item__id._const_tab_at = None
    ___GANSS_ExtraDopplerExtension_ie_Extensions__item__id._const_tab_id = u'id'
    ___GANSS_ExtraDopplerExtension_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GANSS_ExtraDopplerExtension_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_ExtraDopplerExtension_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_ExtraDopplerExtension_ie_Extensions__item__criticality._const_tab = ____GANSS_ExtraDopplerExtension_ie_Extensions__item__criticality_tab
    ___GANSS_ExtraDopplerExtension_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GANSS_ExtraDopplerExtension_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GANSS_ExtraDopplerExtension_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GANSS_ExtraDopplerExtension_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_ExtraDopplerExtension_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_ExtraDopplerExtension_ie_Extensions__item__extensionValue._const_tab = ____GANSS_ExtraDopplerExtension_ie_Extensions__item__extensionValue_tab
    ___GANSS_ExtraDopplerExtension_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GANSS_ExtraDopplerExtension_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GANSS_ExtraDopplerExtension_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GANSS_ExtraDopplerExtension_ie_Extensions__item__id),
        (u'criticality', ___GANSS_ExtraDopplerExtension_ie_Extensions__item__criticality),
        (u'extensionValue', ___GANSS_ExtraDopplerExtension_ie_Extensions__item__extensionValue),
        ])
    __GANSS_ExtraDopplerExtension_ie_Extensions__item_._ext = None
    _GANSS_ExtraDopplerExtension_ie_Extensions._cont = __GANSS_ExtraDopplerExtension_ie_Extensions__item_
    _GANSS_ExtraDopplerExtension_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GANSS_ExtraDopplerExtension._cont = ASN1Dict([
        (u'dopplerFirstOrder', _GANSS_ExtraDopplerExtension_dopplerFirstOrder),
        (u'dopplerUncertaintyExtension', _GANSS_ExtraDopplerExtension_dopplerUncertaintyExtension),
        (u'ie-Extensions', _GANSS_ExtraDopplerExtension_ie_Extensions),
        ])
    GANSS_ExtraDopplerExtension._ext = []
    
    #-----< GANSS-ExtraDopplerExtension-ExtIEs >-----#
    GANSS_ExtraDopplerExtension_ExtIEs = CLASS(name=u'GANSS-ExtraDopplerExtension-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GANSS_ExtraDopplerExtension_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GANSS-GenericAssistanceDataList >-----#
    GANSS_GenericAssistanceDataList = SEQ_OF(name=u'GANSS-GenericAssistanceDataList', mode=MODE_TYPE)
    _GANSS_GenericAssistanceDataList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSSGenericAssistanceData')))
    GANSS_GenericAssistanceDataList._cont = _GANSS_GenericAssistanceDataList__item_
    GANSS_GenericAssistanceDataList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    
    #-----< GANSSGenericAssistanceData >-----#
    GANSSGenericAssistanceData = SEQ(name=u'GANSSGenericAssistanceData', mode=MODE_TYPE)
    _GANSSGenericAssistanceData_ganssId = SEQ(name=u'ganssId', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSSID')), opt=True)
    _GANSSGenericAssistanceData_ganss_Real_Time_Integrity = SEQ_OF(name=u'ganss-Real-Time-Integrity', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSS-Real-Time-Integrity')), opt=True)
    _GANSSGenericAssistanceData_ganss_DataBitAssistance = SEQ(name=u'ganss-DataBitAssistance', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSS-Data-Bit-Assistance')), opt=True)
    _GANSSGenericAssistanceData_dganss_Corrections = SEQ(name=u'dganss-Corrections', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'DGANSS-Corrections')), opt=True)
    _GANSSGenericAssistanceData_ganss_AlmanacAndSatelliteHealth = SEQ(name=u'ganss-AlmanacAndSatelliteHealth', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSS-AlmanacAndSatelliteHealth')), opt=True)
    _GANSSGenericAssistanceData_ganss_ReferenceMeasurementInfo = SEQ(name=u'ganss-ReferenceMeasurementInfo', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSS-ReferenceMeasurementInfo')), opt=True)
    _GANSSGenericAssistanceData_ganss_UTC_Model = SEQ(name=u'ganss-UTC-Model', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSS-UTC-Model')), opt=True)
    _GANSSGenericAssistanceData_ganss_Time_Model = SEQ(name=u'ganss-Time-Model', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSS-Time-Model')), opt=True)
    _GANSSGenericAssistanceData_ganss_Navigation_Model = SEQ(name=u'ganss-Navigation-Model', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSS-Navigation-Model')), opt=True)
    _GANSSGenericAssistanceData_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GANSSGenericAssistanceData_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GANSSGenericAssistanceData_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GANSSGenericAssistanceData_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____GANSSGenericAssistanceData_ie_Extensions__item__id_tab_val_Extension_0 = SEQ_OF(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-Additional-Time-Models')))
    _____GANSSGenericAssistanceData_ie_Extensions__item__id_tab_val_Extension_1 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-Additional-Navigation-Models')))
    _____GANSSGenericAssistanceData_ie_Extensions__item__id_tab_val_Extension_2 = CHOICE(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-Additional-UTC-Models')))
    _____GANSSGenericAssistanceData_ie_Extensions__item__id_tab_val_Extension_3 = CHOICE(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-Auxiliary-Information')))
    _____GANSSGenericAssistanceData_ie_Extensions__item__id_tab_val_Extension_4 = ENUM(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-SBAS-ID')))
    _____GANSSGenericAssistanceData_ie_Extensions__item__id_tab_val_Extension_5 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'BDS-Ionospheric-Grid-Model')))
    _____GANSSGenericAssistanceData_ie_Extensions__item__id_tab_val_Extension_6 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'DBDS-Correction-Information')))
    ____GANSSGenericAssistanceData_ie_Extensions__item__id_tab._val = ASN1Set(rv=[dict([(u'id', 90), (u'criticality', u'ignore'), (u'Extension', _____GANSSGenericAssistanceData_ie_Extensions__item__id_tab_val_Extension_0), (u'presence', u'optional')]), dict([(u'id', 91), (u'criticality', u'ignore'), (u'Extension', _____GANSSGenericAssistanceData_ie_Extensions__item__id_tab_val_Extension_1), (u'presence', u'optional')]), dict([(u'id', 92), (u'criticality', u'ignore'), (u'Extension', _____GANSSGenericAssistanceData_ie_Extensions__item__id_tab_val_Extension_2), (u'presence', u'optional')]), dict([(u'id', 93), (u'criticality', u'ignore'), (u'Extension', _____GANSSGenericAssistanceData_ie_Extensions__item__id_tab_val_Extension_3), (u'presence', u'optional')]), dict([(u'id', 94), (u'criticality', u'ignore'), (u'Extension', _____GANSSGenericAssistanceData_ie_Extensions__item__id_tab_val_Extension_4), (u'presence', u'optional')]), dict([(u'id', 131), (u'criticality', u'ignore'), (u'Extension', _____GANSSGenericAssistanceData_ie_Extensions__item__id_tab_val_Extension_5), (u'presence', u'optional')]), dict([(u'id', 132), (u'criticality', u'ignore'), (u'Extension', _____GANSSGenericAssistanceData_ie_Extensions__item__id_tab_val_Extension_6), (u'presence', u'optional')])], rr=[], ev=None, er=[])
    ___GANSSGenericAssistanceData_ie_Extensions__item__id._const_tab = ____GANSSGenericAssistanceData_ie_Extensions__item__id_tab
    ___GANSSGenericAssistanceData_ie_Extensions__item__id._const_tab_at = None
    ___GANSSGenericAssistanceData_ie_Extensions__item__id._const_tab_id = u'id'
    ___GANSSGenericAssistanceData_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ___GANSSGenericAssistanceData_ie_Extensions__item__criticality._const_tab = ____GANSSGenericAssistanceData_ie_Extensions__item__id_tab
    ___GANSSGenericAssistanceData_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GANSSGenericAssistanceData_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GANSSGenericAssistanceData_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ___GANSSGenericAssistanceData_ie_Extensions__item__extensionValue._const_tab = ____GANSSGenericAssistanceData_ie_Extensions__item__id_tab
    ___GANSSGenericAssistanceData_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GANSSGenericAssistanceData_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GANSSGenericAssistanceData_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GANSSGenericAssistanceData_ie_Extensions__item__id),
        (u'criticality', ___GANSSGenericAssistanceData_ie_Extensions__item__criticality),
        (u'extensionValue', ___GANSSGenericAssistanceData_ie_Extensions__item__extensionValue),
        ])
    __GANSSGenericAssistanceData_ie_Extensions__item_._ext = None
    _GANSSGenericAssistanceData_ie_Extensions._cont = __GANSSGenericAssistanceData_ie_Extensions__item_
    _GANSSGenericAssistanceData_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GANSSGenericAssistanceData._cont = ASN1Dict([
        (u'ganssId', _GANSSGenericAssistanceData_ganssId),
        (u'ganss-Real-Time-Integrity', _GANSSGenericAssistanceData_ganss_Real_Time_Integrity),
        (u'ganss-DataBitAssistance', _GANSSGenericAssistanceData_ganss_DataBitAssistance),
        (u'dganss-Corrections', _GANSSGenericAssistanceData_dganss_Corrections),
        (u'ganss-AlmanacAndSatelliteHealth', _GANSSGenericAssistanceData_ganss_AlmanacAndSatelliteHealth),
        (u'ganss-ReferenceMeasurementInfo', _GANSSGenericAssistanceData_ganss_ReferenceMeasurementInfo),
        (u'ganss-UTC-Model', _GANSSGenericAssistanceData_ganss_UTC_Model),
        (u'ganss-Time-Model', _GANSSGenericAssistanceData_ganss_Time_Model),
        (u'ganss-Navigation-Model', _GANSSGenericAssistanceData_ganss_Navigation_Model),
        (u'ie-Extensions', _GANSSGenericAssistanceData_ie_Extensions),
        ])
    GANSSGenericAssistanceData._ext = []
    
    #-----< GANSSGenericAssistance-ExtIEs >-----#
    GANSSGenericAssistance_ExtIEs = CLASS(name=u'GANSSGenericAssistance-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _GANSSGenericAssistance_ExtIEs_val_Extension_0 = SEQ_OF(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-Additional-Time-Models')))
    _GANSSGenericAssistance_ExtIEs_val_Extension_1 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-Additional-Navigation-Models')))
    _GANSSGenericAssistance_ExtIEs_val_Extension_2 = CHOICE(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-Additional-UTC-Models')))
    _GANSSGenericAssistance_ExtIEs_val_Extension_3 = CHOICE(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-Auxiliary-Information')))
    _GANSSGenericAssistance_ExtIEs_val_Extension_4 = ENUM(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-SBAS-ID')))
    _GANSSGenericAssistance_ExtIEs_val_Extension_5 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'BDS-Ionospheric-Grid-Model')))
    _GANSSGenericAssistance_ExtIEs_val_Extension_6 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'DBDS-Correction-Information')))
    GANSSGenericAssistance_ExtIEs._val = ASN1Set(rv=[dict([(u'id', 90), (u'criticality', u'ignore'), (u'Extension', _GANSSGenericAssistance_ExtIEs_val_Extension_0), (u'presence', u'optional')]), dict([(u'id', 91), (u'criticality', u'ignore'), (u'Extension', _GANSSGenericAssistance_ExtIEs_val_Extension_1), (u'presence', u'optional')]), dict([(u'id', 92), (u'criticality', u'ignore'), (u'Extension', _GANSSGenericAssistance_ExtIEs_val_Extension_2), (u'presence', u'optional')]), dict([(u'id', 93), (u'criticality', u'ignore'), (u'Extension', _GANSSGenericAssistance_ExtIEs_val_Extension_3), (u'presence', u'optional')]), dict([(u'id', 94), (u'criticality', u'ignore'), (u'Extension', _GANSSGenericAssistance_ExtIEs_val_Extension_4), (u'presence', u'optional')]), dict([(u'id', 131), (u'criticality', u'ignore'), (u'Extension', _GANSSGenericAssistance_ExtIEs_val_Extension_5), (u'presence', u'optional')]), dict([(u'id', 132), (u'criticality', u'ignore'), (u'Extension', _GANSSGenericAssistance_ExtIEs_val_Extension_6), (u'presence', u'optional')])], rr=[], ev=[], er=[])
    
    #-----< BDS-Ionospheric-Grid-Model >-----#
    BDS_Ionospheric_Grid_Model = SEQ(name=u'BDS-Ionospheric-Grid-Model', mode=MODE_TYPE)
    _BDS_Ionospheric_Grid_Model_bDS_Reference_Time = INT(name=u'bDS-Reference-Time', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'BDS-Reference-Time')))
    _BDS_Ionospheric_Grid_Model_bDS_Ionospheric_Grid_Information = SEQ_OF(name=u'bDS-Ionospheric-Grid-Information', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'BDS-Ionospheric-Grid-Information')))
    _BDS_Ionospheric_Grid_Model_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __BDS_Ionospheric_Grid_Model_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___BDS_Ionospheric_Grid_Model_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____BDS_Ionospheric_Grid_Model_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____BDS_Ionospheric_Grid_Model_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___BDS_Ionospheric_Grid_Model_ie_Extensions__item__id._const_tab = ____BDS_Ionospheric_Grid_Model_ie_Extensions__item__id_tab
    ___BDS_Ionospheric_Grid_Model_ie_Extensions__item__id._const_tab_at = None
    ___BDS_Ionospheric_Grid_Model_ie_Extensions__item__id._const_tab_id = u'id'
    ___BDS_Ionospheric_Grid_Model_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____BDS_Ionospheric_Grid_Model_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____BDS_Ionospheric_Grid_Model_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___BDS_Ionospheric_Grid_Model_ie_Extensions__item__criticality._const_tab = ____BDS_Ionospheric_Grid_Model_ie_Extensions__item__criticality_tab
    ___BDS_Ionospheric_Grid_Model_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___BDS_Ionospheric_Grid_Model_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___BDS_Ionospheric_Grid_Model_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____BDS_Ionospheric_Grid_Model_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____BDS_Ionospheric_Grid_Model_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___BDS_Ionospheric_Grid_Model_ie_Extensions__item__extensionValue._const_tab = ____BDS_Ionospheric_Grid_Model_ie_Extensions__item__extensionValue_tab
    ___BDS_Ionospheric_Grid_Model_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___BDS_Ionospheric_Grid_Model_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __BDS_Ionospheric_Grid_Model_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___BDS_Ionospheric_Grid_Model_ie_Extensions__item__id),
        (u'criticality', ___BDS_Ionospheric_Grid_Model_ie_Extensions__item__criticality),
        (u'extensionValue', ___BDS_Ionospheric_Grid_Model_ie_Extensions__item__extensionValue),
        ])
    __BDS_Ionospheric_Grid_Model_ie_Extensions__item_._ext = None
    _BDS_Ionospheric_Grid_Model_ie_Extensions._cont = __BDS_Ionospheric_Grid_Model_ie_Extensions__item_
    _BDS_Ionospheric_Grid_Model_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    BDS_Ionospheric_Grid_Model._cont = ASN1Dict([
        (u'bDS-Reference-Time', _BDS_Ionospheric_Grid_Model_bDS_Reference_Time),
        (u'bDS-Ionospheric-Grid-Information', _BDS_Ionospheric_Grid_Model_bDS_Ionospheric_Grid_Information),
        (u'ie-Extensions', _BDS_Ionospheric_Grid_Model_ie_Extensions),
        ])
    BDS_Ionospheric_Grid_Model._ext = []
    
    #-----< BDS-Ionospheric-Grid-Model-ExtIEs >-----#
    BDS_Ionospheric_Grid_Model_ExtIEs = CLASS(name=u'BDS-Ionospheric-Grid-Model-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    BDS_Ionospheric_Grid_Model_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< BDS-Reference-Time >-----#
    BDS_Reference_Time = INT(name=u'BDS-Reference-Time', mode=MODE_TYPE)
    BDS_Reference_Time._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=3570)], ev=None, er=[])
    
    #-----< BDS-Ionospheric-Grid-Information >-----#
    BDS_Ionospheric_Grid_Information = SEQ_OF(name=u'BDS-Ionospheric-Grid-Information', mode=MODE_TYPE)
    _BDS_Ionospheric_Grid_Information__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    __BDS_Ionospheric_Grid_Information__item__iGP_number_BDS = INT(name=u'iGP-number-BDS', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __BDS_Ionospheric_Grid_Information__item__iGP_number_BDS._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=320)], ev=None, er=[])
    __BDS_Ionospheric_Grid_Information__item__vertical_Delay_BDS = BIT_STR(name=u'vertical-Delay-BDS', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __BDS_Ionospheric_Grid_Information__item__vertical_Delay_BDS._const_sz = ASN1Set(rv=[9], rr=[], ev=None, er=[])
    __BDS_Ionospheric_Grid_Information__item__gIVEI_BDS = BIT_STR(name=u'gIVEI-BDS', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __BDS_Ionospheric_Grid_Information__item__gIVEI_BDS._const_sz = ASN1Set(rv=[4], rr=[], ev=None, er=[])
    __BDS_Ionospheric_Grid_Information__item__ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    ___BDS_Ionospheric_Grid_Information__item__ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ____BDS_Ionospheric_Grid_Information__item__ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    _____BDS_Ionospheric_Grid_Information__item__ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____BDS_Ionospheric_Grid_Information__item__ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____BDS_Ionospheric_Grid_Information__item__ie_Extensions__item__id._const_tab = _____BDS_Ionospheric_Grid_Information__item__ie_Extensions__item__id_tab
    ____BDS_Ionospheric_Grid_Information__item__ie_Extensions__item__id._const_tab_at = None
    ____BDS_Ionospheric_Grid_Information__item__ie_Extensions__item__id._const_tab_id = u'id'
    ____BDS_Ionospheric_Grid_Information__item__ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    _____BDS_Ionospheric_Grid_Information__item__ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____BDS_Ionospheric_Grid_Information__item__ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____BDS_Ionospheric_Grid_Information__item__ie_Extensions__item__criticality._const_tab = _____BDS_Ionospheric_Grid_Information__item__ie_Extensions__item__criticality_tab
    ____BDS_Ionospheric_Grid_Information__item__ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ____BDS_Ionospheric_Grid_Information__item__ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ____BDS_Ionospheric_Grid_Information__item__ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    _____BDS_Ionospheric_Grid_Information__item__ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____BDS_Ionospheric_Grid_Information__item__ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____BDS_Ionospheric_Grid_Information__item__ie_Extensions__item__extensionValue._const_tab = _____BDS_Ionospheric_Grid_Information__item__ie_Extensions__item__extensionValue_tab
    ____BDS_Ionospheric_Grid_Information__item__ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ____BDS_Ionospheric_Grid_Information__item__ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    ___BDS_Ionospheric_Grid_Information__item__ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ____BDS_Ionospheric_Grid_Information__item__ie_Extensions__item__id),
        (u'criticality', ____BDS_Ionospheric_Grid_Information__item__ie_Extensions__item__criticality),
        (u'extensionValue', ____BDS_Ionospheric_Grid_Information__item__ie_Extensions__item__extensionValue),
        ])
    ___BDS_Ionospheric_Grid_Information__item__ie_Extensions__item_._ext = None
    __BDS_Ionospheric_Grid_Information__item__ie_Extensions._cont = ___BDS_Ionospheric_Grid_Information__item__ie_Extensions__item_
    __BDS_Ionospheric_Grid_Information__item__ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    _BDS_Ionospheric_Grid_Information__item_._cont = ASN1Dict([
        (u'iGP-number-BDS', __BDS_Ionospheric_Grid_Information__item__iGP_number_BDS),
        (u'vertical-Delay-BDS', __BDS_Ionospheric_Grid_Information__item__vertical_Delay_BDS),
        (u'gIVEI-BDS', __BDS_Ionospheric_Grid_Information__item__gIVEI_BDS),
        (u'ie-Extensions', __BDS_Ionospheric_Grid_Information__item__ie_Extensions),
        ])
    _BDS_Ionospheric_Grid_Information__item_._ext = []
    BDS_Ionospheric_Grid_Information._cont = _BDS_Ionospheric_Grid_Information__item_
    BDS_Ionospheric_Grid_Information._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=320)], ev=None, er=[])
    
    #-----< BDS-Ionospheric-Grid-Information-ExtIEs >-----#
    BDS_Ionospheric_Grid_Information_ExtIEs = CLASS(name=u'BDS-Ionospheric-Grid-Information-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    BDS_Ionospheric_Grid_Information_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< DBDS-Correction-Information >-----#
    DBDS_Correction_Information = SEQ(name=u'DBDS-Correction-Information', mode=MODE_TYPE)
    _DBDS_Correction_Information_bDS_Reference_Time = INT(name=u'bDS-Reference-Time', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'BDS-Reference-Time')))
    _DBDS_Correction_Information_dBDS_Information = SEQ_OF(name=u'dBDS-Information', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'DBDS-Information')))
    _DBDS_Correction_Information_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __DBDS_Correction_Information_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___DBDS_Correction_Information_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____DBDS_Correction_Information_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____DBDS_Correction_Information_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___DBDS_Correction_Information_ie_Extensions__item__id._const_tab = ____DBDS_Correction_Information_ie_Extensions__item__id_tab
    ___DBDS_Correction_Information_ie_Extensions__item__id._const_tab_at = None
    ___DBDS_Correction_Information_ie_Extensions__item__id._const_tab_id = u'id'
    ___DBDS_Correction_Information_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____DBDS_Correction_Information_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____DBDS_Correction_Information_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___DBDS_Correction_Information_ie_Extensions__item__criticality._const_tab = ____DBDS_Correction_Information_ie_Extensions__item__criticality_tab
    ___DBDS_Correction_Information_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___DBDS_Correction_Information_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___DBDS_Correction_Information_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____DBDS_Correction_Information_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____DBDS_Correction_Information_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___DBDS_Correction_Information_ie_Extensions__item__extensionValue._const_tab = ____DBDS_Correction_Information_ie_Extensions__item__extensionValue_tab
    ___DBDS_Correction_Information_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___DBDS_Correction_Information_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __DBDS_Correction_Information_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___DBDS_Correction_Information_ie_Extensions__item__id),
        (u'criticality', ___DBDS_Correction_Information_ie_Extensions__item__criticality),
        (u'extensionValue', ___DBDS_Correction_Information_ie_Extensions__item__extensionValue),
        ])
    __DBDS_Correction_Information_ie_Extensions__item_._ext = None
    _DBDS_Correction_Information_ie_Extensions._cont = __DBDS_Correction_Information_ie_Extensions__item_
    _DBDS_Correction_Information_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    DBDS_Correction_Information._cont = ASN1Dict([
        (u'bDS-Reference-Time', _DBDS_Correction_Information_bDS_Reference_Time),
        (u'dBDS-Information', _DBDS_Correction_Information_dBDS_Information),
        (u'ie-Extensions', _DBDS_Correction_Information_ie_Extensions),
        ])
    DBDS_Correction_Information._ext = []
    
    #-----< DBDS-Correction-Information-ExtIEs >-----#
    DBDS_Correction_Information_ExtIEs = CLASS(name=u'DBDS-Correction-Information-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    DBDS_Correction_Information_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< DBDS-Information >-----#
    DBDS_Information = SEQ_OF(name=u'DBDS-Information', mode=MODE_TYPE)
    _DBDS_Information__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    __DBDS_Information__item__dBDS_Signal_ID = SEQ(name=u'dBDS-Signal-ID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSSID')), opt=True)
    __DBDS_Information__item__dGANSS_Signal_Information = SEQ_OF(name=u'dGANSS-Signal-Information', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'DGANSS-Signal-Information')))
    __DBDS_Information__item__ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    ___DBDS_Information__item__ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ____DBDS_Information__item__ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    _____DBDS_Information__item__ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____DBDS_Information__item__ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____DBDS_Information__item__ie_Extensions__item__id._const_tab = _____DBDS_Information__item__ie_Extensions__item__id_tab
    ____DBDS_Information__item__ie_Extensions__item__id._const_tab_at = None
    ____DBDS_Information__item__ie_Extensions__item__id._const_tab_id = u'id'
    ____DBDS_Information__item__ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    _____DBDS_Information__item__ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____DBDS_Information__item__ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____DBDS_Information__item__ie_Extensions__item__criticality._const_tab = _____DBDS_Information__item__ie_Extensions__item__criticality_tab
    ____DBDS_Information__item__ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ____DBDS_Information__item__ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ____DBDS_Information__item__ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    _____DBDS_Information__item__ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____DBDS_Information__item__ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____DBDS_Information__item__ie_Extensions__item__extensionValue._const_tab = _____DBDS_Information__item__ie_Extensions__item__extensionValue_tab
    ____DBDS_Information__item__ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ____DBDS_Information__item__ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    ___DBDS_Information__item__ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ____DBDS_Information__item__ie_Extensions__item__id),
        (u'criticality', ____DBDS_Information__item__ie_Extensions__item__criticality),
        (u'extensionValue', ____DBDS_Information__item__ie_Extensions__item__extensionValue),
        ])
    ___DBDS_Information__item__ie_Extensions__item_._ext = None
    __DBDS_Information__item__ie_Extensions._cont = ___DBDS_Information__item__ie_Extensions__item_
    __DBDS_Information__item__ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    _DBDS_Information__item_._cont = ASN1Dict([
        (u'dBDS-Signal-ID', __DBDS_Information__item__dBDS_Signal_ID),
        (u'dGANSS-Signal-Information', __DBDS_Information__item__dGANSS_Signal_Information),
        (u'ie-Extensions', __DBDS_Information__item__ie_Extensions),
        ])
    _DBDS_Information__item_._ext = []
    DBDS_Information._cont = _DBDS_Information__item_
    DBDS_Information._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    
    #-----< DBDS-Information-ExtIEs >-----#
    DBDS_Information_ExtIEs = CLASS(name=u'DBDS-Information-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    DBDS_Information_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< DGANSS-Signal-Information >-----#
    DGANSS_Signal_Information = SEQ_OF(name=u'DGANSS-Signal-Information', mode=MODE_TYPE)
    _DGANSS_Signal_Information__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    __DGANSS_Signal_Information__item__sat_ID_BDS = INT(name=u'sat-ID-BDS', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __DGANSS_Signal_Information__item__sat_ID_BDS._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    __DGANSS_Signal_Information__item__uDREI_BDS = INT(name=u'uDREI-BDS', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __DGANSS_Signal_Information__item__uDREI_BDS._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=15)], ev=None, er=[])
    __DGANSS_Signal_Information__item__rURAI_BDS = INT(name=u'rURAI-BDS', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __DGANSS_Signal_Information__item__rURAI_BDS._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=15)], ev=None, er=[])
    __DGANSS_Signal_Information__item__delta_t_BDS = BIT_STR(name=u'delta-t-BDS', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __DGANSS_Signal_Information__item__delta_t_BDS._const_sz = ASN1Set(rv=[13], rr=[], ev=None, er=[])
    __DGANSS_Signal_Information__item__ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    ___DGANSS_Signal_Information__item__ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ____DGANSS_Signal_Information__item__ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    _____DGANSS_Signal_Information__item__ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____DGANSS_Signal_Information__item__ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____DGANSS_Signal_Information__item__ie_Extensions__item__id._const_tab = _____DGANSS_Signal_Information__item__ie_Extensions__item__id_tab
    ____DGANSS_Signal_Information__item__ie_Extensions__item__id._const_tab_at = None
    ____DGANSS_Signal_Information__item__ie_Extensions__item__id._const_tab_id = u'id'
    ____DGANSS_Signal_Information__item__ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    _____DGANSS_Signal_Information__item__ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____DGANSS_Signal_Information__item__ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____DGANSS_Signal_Information__item__ie_Extensions__item__criticality._const_tab = _____DGANSS_Signal_Information__item__ie_Extensions__item__criticality_tab
    ____DGANSS_Signal_Information__item__ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ____DGANSS_Signal_Information__item__ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ____DGANSS_Signal_Information__item__ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    _____DGANSS_Signal_Information__item__ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____DGANSS_Signal_Information__item__ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____DGANSS_Signal_Information__item__ie_Extensions__item__extensionValue._const_tab = _____DGANSS_Signal_Information__item__ie_Extensions__item__extensionValue_tab
    ____DGANSS_Signal_Information__item__ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ____DGANSS_Signal_Information__item__ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    ___DGANSS_Signal_Information__item__ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ____DGANSS_Signal_Information__item__ie_Extensions__item__id),
        (u'criticality', ____DGANSS_Signal_Information__item__ie_Extensions__item__criticality),
        (u'extensionValue', ____DGANSS_Signal_Information__item__ie_Extensions__item__extensionValue),
        ])
    ___DGANSS_Signal_Information__item__ie_Extensions__item_._ext = None
    __DGANSS_Signal_Information__item__ie_Extensions._cont = ___DGANSS_Signal_Information__item__ie_Extensions__item_
    __DGANSS_Signal_Information__item__ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    _DGANSS_Signal_Information__item_._cont = ASN1Dict([
        (u'sat-ID-BDS', __DGANSS_Signal_Information__item__sat_ID_BDS),
        (u'uDREI-BDS', __DGANSS_Signal_Information__item__uDREI_BDS),
        (u'rURAI-BDS', __DGANSS_Signal_Information__item__rURAI_BDS),
        (u'delta-t-BDS', __DGANSS_Signal_Information__item__delta_t_BDS),
        (u'ie-Extensions', __DGANSS_Signal_Information__item__ie_Extensions),
        ])
    _DGANSS_Signal_Information__item_._ext = []
    DGANSS_Signal_Information._cont = _DGANSS_Signal_Information__item_
    DGANSS_Signal_Information._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    
    #-----< DGANSS-Signal-Information-ExtIEs >-----#
    DGANSS_Signal_Information_ExtIEs = CLASS(name=u'DGANSS-Signal-Information-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    DGANSS_Signal_Information_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GANSS-GenericMeasurementInfo >-----#
    GANSS_GenericMeasurementInfo = SEQ_OF(name=u'GANSS-GenericMeasurementInfo', mode=MODE_TYPE)
    _GANSS_GenericMeasurementInfo__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    __GANSS_GenericMeasurementInfo__item__ganssId = SEQ(name=u'ganssId', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSSID')), opt=True)
    __GANSS_GenericMeasurementInfo__item__ganssMeasurementSignalList = SEQ_OF(name=u'ganssMeasurementSignalList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSSMeasurementSignalList')))
    __GANSS_GenericMeasurementInfo__item__ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    ___GANSS_GenericMeasurementInfo__item__ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ____GANSS_GenericMeasurementInfo__item__ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    _____GANSS_GenericMeasurementInfo__item__ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____GANSS_GenericMeasurementInfo__item__ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____GANSS_GenericMeasurementInfo__item__ie_Extensions__item__id._const_tab = _____GANSS_GenericMeasurementInfo__item__ie_Extensions__item__id_tab
    ____GANSS_GenericMeasurementInfo__item__ie_Extensions__item__id._const_tab_at = None
    ____GANSS_GenericMeasurementInfo__item__ie_Extensions__item__id._const_tab_id = u'id'
    ____GANSS_GenericMeasurementInfo__item__ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    _____GANSS_GenericMeasurementInfo__item__ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____GANSS_GenericMeasurementInfo__item__ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____GANSS_GenericMeasurementInfo__item__ie_Extensions__item__criticality._const_tab = _____GANSS_GenericMeasurementInfo__item__ie_Extensions__item__criticality_tab
    ____GANSS_GenericMeasurementInfo__item__ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ____GANSS_GenericMeasurementInfo__item__ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ____GANSS_GenericMeasurementInfo__item__ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    _____GANSS_GenericMeasurementInfo__item__ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____GANSS_GenericMeasurementInfo__item__ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____GANSS_GenericMeasurementInfo__item__ie_Extensions__item__extensionValue._const_tab = _____GANSS_GenericMeasurementInfo__item__ie_Extensions__item__extensionValue_tab
    ____GANSS_GenericMeasurementInfo__item__ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ____GANSS_GenericMeasurementInfo__item__ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    ___GANSS_GenericMeasurementInfo__item__ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ____GANSS_GenericMeasurementInfo__item__ie_Extensions__item__id),
        (u'criticality', ____GANSS_GenericMeasurementInfo__item__ie_Extensions__item__criticality),
        (u'extensionValue', ____GANSS_GenericMeasurementInfo__item__ie_Extensions__item__extensionValue),
        ])
    ___GANSS_GenericMeasurementInfo__item__ie_Extensions__item_._ext = None
    __GANSS_GenericMeasurementInfo__item__ie_Extensions._cont = ___GANSS_GenericMeasurementInfo__item__ie_Extensions__item_
    __GANSS_GenericMeasurementInfo__item__ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    _GANSS_GenericMeasurementInfo__item_._cont = ASN1Dict([
        (u'ganssId', __GANSS_GenericMeasurementInfo__item__ganssId),
        (u'ganssMeasurementSignalList', __GANSS_GenericMeasurementInfo__item__ganssMeasurementSignalList),
        (u'ie-Extensions', __GANSS_GenericMeasurementInfo__item__ie_Extensions),
        ])
    _GANSS_GenericMeasurementInfo__item_._ext = []
    GANSS_GenericMeasurementInfo._cont = _GANSS_GenericMeasurementInfo__item_
    GANSS_GenericMeasurementInfo._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    
    #-----< GANSS-GenericMeasurementInfo-ExtIEs >-----#
    GANSS_GenericMeasurementInfo_ExtIEs = CLASS(name=u'GANSS-GenericMeasurementInfo-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GANSS_GenericMeasurementInfo_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GANSSID >-----#
    GANSSID = SEQ(name=u'GANSSID', mode=MODE_TYPE)
    _GANSSID_ganss_ID = INT(name=u'ganss-ID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSSID_ganss_ID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=7)], ev=None, er=[])
    _GANSSID_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GANSSID_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GANSSID_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GANSSID_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSSID_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSSID_ie_Extensions__item__id._const_tab = ____GANSSID_ie_Extensions__item__id_tab
    ___GANSSID_ie_Extensions__item__id._const_tab_at = None
    ___GANSSID_ie_Extensions__item__id._const_tab_id = u'id'
    ___GANSSID_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GANSSID_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSSID_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSSID_ie_Extensions__item__criticality._const_tab = ____GANSSID_ie_Extensions__item__criticality_tab
    ___GANSSID_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GANSSID_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GANSSID_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GANSSID_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSSID_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSSID_ie_Extensions__item__extensionValue._const_tab = ____GANSSID_ie_Extensions__item__extensionValue_tab
    ___GANSSID_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GANSSID_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GANSSID_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GANSSID_ie_Extensions__item__id),
        (u'criticality', ___GANSSID_ie_Extensions__item__criticality),
        (u'extensionValue', ___GANSSID_ie_Extensions__item__extensionValue),
        ])
    __GANSSID_ie_Extensions__item_._ext = None
    _GANSSID_ie_Extensions._cont = __GANSSID_ie_Extensions__item_
    _GANSSID_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GANSSID._cont = ASN1Dict([
        (u'ganss-ID', _GANSSID_ganss_ID),
        (u'ie-Extensions', _GANSSID_ie_Extensions),
        ])
    GANSSID._ext = []
    
    #-----< GANSSID-ExtIEs >-----#
    GANSSID_ExtIEs = CLASS(name=u'GANSSID-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GANSSID_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GANSSMeasurementSignalList >-----#
    GANSSMeasurementSignalList = SEQ_OF(name=u'GANSSMeasurementSignalList', mode=MODE_TYPE)
    _GANSSMeasurementSignalList__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    __GANSSMeasurementSignalList__item__ganssSignalId = SEQ(name=u'ganssSignalId', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSS-SignalID')), opt=True)
    __GANSSMeasurementSignalList__item__ganssCodePhaseAmbiguity = INT(name=u'ganssCodePhaseAmbiguity', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __GANSSMeasurementSignalList__item__ganssCodePhaseAmbiguity._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=31)], ev=None, er=[])
    __GANSSMeasurementSignalList__item__ganssMeasurementParameters = SEQ_OF(name=u'ganssMeasurementParameters', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSS-MeasurementParameters')))
    __GANSSMeasurementSignalList__item__ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    ___GANSSMeasurementSignalList__item__ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ____GANSSMeasurementSignalList__item__ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    _____GANSSMeasurementSignalList__item__ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ______GANSSMeasurementSignalList__item__ie_Extensions__item__id_tab_val_Extension_0 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GanssCodePhaseAmbiguityExt')))
    _____GANSSMeasurementSignalList__item__ie_Extensions__item__id_tab._val = ASN1Set(rv=[dict([(u'id', 99), (u'criticality', u'ignore'), (u'Extension', ______GANSSMeasurementSignalList__item__ie_Extensions__item__id_tab_val_Extension_0), (u'presence', u'optional')])], rr=[], ev=None, er=[])
    ____GANSSMeasurementSignalList__item__ie_Extensions__item__id._const_tab = _____GANSSMeasurementSignalList__item__ie_Extensions__item__id_tab
    ____GANSSMeasurementSignalList__item__ie_Extensions__item__id._const_tab_at = None
    ____GANSSMeasurementSignalList__item__ie_Extensions__item__id._const_tab_id = u'id'
    ____GANSSMeasurementSignalList__item__ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GANSSMeasurementSignalList__item__ie_Extensions__item__criticality._const_tab = _____GANSSMeasurementSignalList__item__ie_Extensions__item__id_tab
    ____GANSSMeasurementSignalList__item__ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ____GANSSMeasurementSignalList__item__ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ____GANSSMeasurementSignalList__item__ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GANSSMeasurementSignalList__item__ie_Extensions__item__extensionValue._const_tab = _____GANSSMeasurementSignalList__item__ie_Extensions__item__id_tab
    ____GANSSMeasurementSignalList__item__ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ____GANSSMeasurementSignalList__item__ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    ___GANSSMeasurementSignalList__item__ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ____GANSSMeasurementSignalList__item__ie_Extensions__item__id),
        (u'criticality', ____GANSSMeasurementSignalList__item__ie_Extensions__item__criticality),
        (u'extensionValue', ____GANSSMeasurementSignalList__item__ie_Extensions__item__extensionValue),
        ])
    ___GANSSMeasurementSignalList__item__ie_Extensions__item_._ext = None
    __GANSSMeasurementSignalList__item__ie_Extensions._cont = ___GANSSMeasurementSignalList__item__ie_Extensions__item_
    __GANSSMeasurementSignalList__item__ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    _GANSSMeasurementSignalList__item_._cont = ASN1Dict([
        (u'ganssSignalId', __GANSSMeasurementSignalList__item__ganssSignalId),
        (u'ganssCodePhaseAmbiguity', __GANSSMeasurementSignalList__item__ganssCodePhaseAmbiguity),
        (u'ganssMeasurementParameters', __GANSSMeasurementSignalList__item__ganssMeasurementParameters),
        (u'ie-Extensions', __GANSSMeasurementSignalList__item__ie_Extensions),
        ])
    _GANSSMeasurementSignalList__item_._ext = []
    GANSSMeasurementSignalList._cont = _GANSSMeasurementSignalList__item_
    GANSSMeasurementSignalList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    
    #-----< GANSSMeasurementSignalList-ExtIEs >-----#
    GANSSMeasurementSignalList_ExtIEs = CLASS(name=u'GANSSMeasurementSignalList-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _GANSSMeasurementSignalList_ExtIEs_val_Extension_0 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GanssCodePhaseAmbiguityExt')))
    GANSSMeasurementSignalList_ExtIEs._val = ASN1Set(rv=[dict([(u'id', 99), (u'criticality', u'ignore'), (u'Extension', _GANSSMeasurementSignalList_ExtIEs_val_Extension_0), (u'presence', u'optional')])], rr=[], ev=[], er=[])
    
    #-----< GanssCodePhaseAmbiguityExt >-----#
    GanssCodePhaseAmbiguityExt = SEQ(name=u'GanssCodePhaseAmbiguityExt', mode=MODE_TYPE)
    _GanssCodePhaseAmbiguityExt_ganssCodePhaseAmbiguity_ext = INT(name=u'ganssCodePhaseAmbiguity-ext', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GanssCodePhaseAmbiguityExt_ganssCodePhaseAmbiguity_ext._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=32, ub=127)], ev=None, er=[])
    _GanssCodePhaseAmbiguityExt_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GanssCodePhaseAmbiguityExt_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GanssCodePhaseAmbiguityExt_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GanssCodePhaseAmbiguityExt_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GanssCodePhaseAmbiguityExt_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GanssCodePhaseAmbiguityExt_ie_Extensions__item__id._const_tab = ____GanssCodePhaseAmbiguityExt_ie_Extensions__item__id_tab
    ___GanssCodePhaseAmbiguityExt_ie_Extensions__item__id._const_tab_at = None
    ___GanssCodePhaseAmbiguityExt_ie_Extensions__item__id._const_tab_id = u'id'
    ___GanssCodePhaseAmbiguityExt_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GanssCodePhaseAmbiguityExt_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GanssCodePhaseAmbiguityExt_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GanssCodePhaseAmbiguityExt_ie_Extensions__item__criticality._const_tab = ____GanssCodePhaseAmbiguityExt_ie_Extensions__item__criticality_tab
    ___GanssCodePhaseAmbiguityExt_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GanssCodePhaseAmbiguityExt_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GanssCodePhaseAmbiguityExt_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GanssCodePhaseAmbiguityExt_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GanssCodePhaseAmbiguityExt_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GanssCodePhaseAmbiguityExt_ie_Extensions__item__extensionValue._const_tab = ____GanssCodePhaseAmbiguityExt_ie_Extensions__item__extensionValue_tab
    ___GanssCodePhaseAmbiguityExt_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GanssCodePhaseAmbiguityExt_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GanssCodePhaseAmbiguityExt_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GanssCodePhaseAmbiguityExt_ie_Extensions__item__id),
        (u'criticality', ___GanssCodePhaseAmbiguityExt_ie_Extensions__item__criticality),
        (u'extensionValue', ___GanssCodePhaseAmbiguityExt_ie_Extensions__item__extensionValue),
        ])
    __GanssCodePhaseAmbiguityExt_ie_Extensions__item_._ext = None
    _GanssCodePhaseAmbiguityExt_ie_Extensions._cont = __GanssCodePhaseAmbiguityExt_ie_Extensions__item_
    _GanssCodePhaseAmbiguityExt_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GanssCodePhaseAmbiguityExt._cont = ASN1Dict([
        (u'ganssCodePhaseAmbiguity-ext', _GanssCodePhaseAmbiguityExt_ganssCodePhaseAmbiguity_ext),
        (u'ie-Extensions', _GanssCodePhaseAmbiguityExt_ie_Extensions),
        ])
    GanssCodePhaseAmbiguityExt._ext = []
    
    #-----< GanssCodePhaseAmbiguityExt-ExtIEs >-----#
    GanssCodePhaseAmbiguityExt_ExtIEs = CLASS(name=u'GanssCodePhaseAmbiguityExt-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GanssCodePhaseAmbiguityExt_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GANSS-Ionospheric-Model >-----#
    GANSS_Ionospheric_Model = SEQ(name=u'GANSS-Ionospheric-Model', mode=MODE_TYPE)
    _GANSS_Ionospheric_Model_alpha_zero_ionos = BIT_STR(name=u'alpha-zero-ionos', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_Ionospheric_Model_alpha_zero_ionos._const_sz = ASN1Set(rv=[11], rr=[], ev=None, er=[])
    _GANSS_Ionospheric_Model_alpha_one_ionos = BIT_STR(name=u'alpha-one-ionos', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_Ionospheric_Model_alpha_one_ionos._const_sz = ASN1Set(rv=[11], rr=[], ev=None, er=[])
    _GANSS_Ionospheric_Model_alpha_two_ionos = BIT_STR(name=u'alpha-two-ionos', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_Ionospheric_Model_alpha_two_ionos._const_sz = ASN1Set(rv=[14], rr=[], ev=None, er=[])
    _GANSS_Ionospheric_Model_gANSS_IonosphereRegionalStormFlags = SEQ(name=u'gANSS-IonosphereRegionalStormFlags', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSS-IonosphereRegionalStormFlags')), opt=True)
    _GANSS_Ionospheric_Model_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GANSS_Ionospheric_Model_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GANSS_Ionospheric_Model_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GANSS_Ionospheric_Model_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_Ionospheric_Model_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_Ionospheric_Model_ie_Extensions__item__id._const_tab = ____GANSS_Ionospheric_Model_ie_Extensions__item__id_tab
    ___GANSS_Ionospheric_Model_ie_Extensions__item__id._const_tab_at = None
    ___GANSS_Ionospheric_Model_ie_Extensions__item__id._const_tab_id = u'id'
    ___GANSS_Ionospheric_Model_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GANSS_Ionospheric_Model_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_Ionospheric_Model_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_Ionospheric_Model_ie_Extensions__item__criticality._const_tab = ____GANSS_Ionospheric_Model_ie_Extensions__item__criticality_tab
    ___GANSS_Ionospheric_Model_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GANSS_Ionospheric_Model_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GANSS_Ionospheric_Model_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GANSS_Ionospheric_Model_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_Ionospheric_Model_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_Ionospheric_Model_ie_Extensions__item__extensionValue._const_tab = ____GANSS_Ionospheric_Model_ie_Extensions__item__extensionValue_tab
    ___GANSS_Ionospheric_Model_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GANSS_Ionospheric_Model_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GANSS_Ionospheric_Model_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GANSS_Ionospheric_Model_ie_Extensions__item__id),
        (u'criticality', ___GANSS_Ionospheric_Model_ie_Extensions__item__criticality),
        (u'extensionValue', ___GANSS_Ionospheric_Model_ie_Extensions__item__extensionValue),
        ])
    __GANSS_Ionospheric_Model_ie_Extensions__item_._ext = None
    _GANSS_Ionospheric_Model_ie_Extensions._cont = __GANSS_Ionospheric_Model_ie_Extensions__item_
    _GANSS_Ionospheric_Model_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GANSS_Ionospheric_Model._cont = ASN1Dict([
        (u'alpha-zero-ionos', _GANSS_Ionospheric_Model_alpha_zero_ionos),
        (u'alpha-one-ionos', _GANSS_Ionospheric_Model_alpha_one_ionos),
        (u'alpha-two-ionos', _GANSS_Ionospheric_Model_alpha_two_ionos),
        (u'gANSS-IonosphereRegionalStormFlags', _GANSS_Ionospheric_Model_gANSS_IonosphereRegionalStormFlags),
        (u'ie-Extensions', _GANSS_Ionospheric_Model_ie_Extensions),
        ])
    GANSS_Ionospheric_Model._ext = []
    
    #-----< GANSS-Ionospheric-Model-ExtIEs >-----#
    GANSS_Ionospheric_Model_ExtIEs = CLASS(name=u'GANSS-Ionospheric-Model-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GANSS_Ionospheric_Model_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GANSS-IonosphereRegionalStormFlags >-----#
    GANSS_IonosphereRegionalStormFlags = SEQ(name=u'GANSS-IonosphereRegionalStormFlags', mode=MODE_TYPE)
    _GANSS_IonosphereRegionalStormFlags_storm_flag_one = BOOL(name=u'storm-flag-one', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_IonosphereRegionalStormFlags_storm_flag_two = BOOL(name=u'storm-flag-two', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_IonosphereRegionalStormFlags_storm_flag_three = BOOL(name=u'storm-flag-three', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_IonosphereRegionalStormFlags_storm_flag_four = BOOL(name=u'storm-flag-four', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_IonosphereRegionalStormFlags_storm_flag_five = BOOL(name=u'storm-flag-five', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_IonosphereRegionalStormFlags_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GANSS_IonosphereRegionalStormFlags_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GANSS_IonosphereRegionalStormFlags_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GANSS_IonosphereRegionalStormFlags_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_IonosphereRegionalStormFlags_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_IonosphereRegionalStormFlags_ie_Extensions__item__id._const_tab = ____GANSS_IonosphereRegionalStormFlags_ie_Extensions__item__id_tab
    ___GANSS_IonosphereRegionalStormFlags_ie_Extensions__item__id._const_tab_at = None
    ___GANSS_IonosphereRegionalStormFlags_ie_Extensions__item__id._const_tab_id = u'id'
    ___GANSS_IonosphereRegionalStormFlags_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GANSS_IonosphereRegionalStormFlags_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_IonosphereRegionalStormFlags_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_IonosphereRegionalStormFlags_ie_Extensions__item__criticality._const_tab = ____GANSS_IonosphereRegionalStormFlags_ie_Extensions__item__criticality_tab
    ___GANSS_IonosphereRegionalStormFlags_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GANSS_IonosphereRegionalStormFlags_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GANSS_IonosphereRegionalStormFlags_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GANSS_IonosphereRegionalStormFlags_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_IonosphereRegionalStormFlags_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_IonosphereRegionalStormFlags_ie_Extensions__item__extensionValue._const_tab = ____GANSS_IonosphereRegionalStormFlags_ie_Extensions__item__extensionValue_tab
    ___GANSS_IonosphereRegionalStormFlags_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GANSS_IonosphereRegionalStormFlags_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GANSS_IonosphereRegionalStormFlags_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GANSS_IonosphereRegionalStormFlags_ie_Extensions__item__id),
        (u'criticality', ___GANSS_IonosphereRegionalStormFlags_ie_Extensions__item__criticality),
        (u'extensionValue', ___GANSS_IonosphereRegionalStormFlags_ie_Extensions__item__extensionValue),
        ])
    __GANSS_IonosphereRegionalStormFlags_ie_Extensions__item_._ext = None
    _GANSS_IonosphereRegionalStormFlags_ie_Extensions._cont = __GANSS_IonosphereRegionalStormFlags_ie_Extensions__item_
    _GANSS_IonosphereRegionalStormFlags_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GANSS_IonosphereRegionalStormFlags._cont = ASN1Dict([
        (u'storm-flag-one', _GANSS_IonosphereRegionalStormFlags_storm_flag_one),
        (u'storm-flag-two', _GANSS_IonosphereRegionalStormFlags_storm_flag_two),
        (u'storm-flag-three', _GANSS_IonosphereRegionalStormFlags_storm_flag_three),
        (u'storm-flag-four', _GANSS_IonosphereRegionalStormFlags_storm_flag_four),
        (u'storm-flag-five', _GANSS_IonosphereRegionalStormFlags_storm_flag_five),
        (u'ie-Extensions', _GANSS_IonosphereRegionalStormFlags_ie_Extensions),
        ])
    GANSS_IonosphereRegionalStormFlags._ext = []
    
    #-----< GANSS-IonosphereRegionalStormFlags-ExtIEs >-----#
    GANSS_IonosphereRegionalStormFlags_ExtIEs = CLASS(name=u'GANSS-IonosphereRegionalStormFlags-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GANSS_IonosphereRegionalStormFlags_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GANSS-KeplerianParametersAlm >-----#
    GANSS_KeplerianParametersAlm = SEQ(name=u'GANSS-KeplerianParametersAlm', mode=MODE_TYPE)
    _GANSS_KeplerianParametersAlm_t_oa = INT(name=u't-oa', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_KeplerianParametersAlm_t_oa._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=1023)], ev=None, er=[])
    _GANSS_KeplerianParametersAlm_iod_a = INT(name=u'iod-a', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_KeplerianParametersAlm_iod_a._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=15)], ev=None, er=[])
    _GANSS_KeplerianParametersAlm_gANSS_SatelliteInformationKP = SEQ_OF(name=u'gANSS-SatelliteInformationKP', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSS-SatelliteInformationKP')))
    _GANSS_KeplerianParametersAlm_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GANSS_KeplerianParametersAlm_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GANSS_KeplerianParametersAlm_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GANSS_KeplerianParametersAlm_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_KeplerianParametersAlm_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_KeplerianParametersAlm_ie_Extensions__item__id._const_tab = ____GANSS_KeplerianParametersAlm_ie_Extensions__item__id_tab
    ___GANSS_KeplerianParametersAlm_ie_Extensions__item__id._const_tab_at = None
    ___GANSS_KeplerianParametersAlm_ie_Extensions__item__id._const_tab_id = u'id'
    ___GANSS_KeplerianParametersAlm_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GANSS_KeplerianParametersAlm_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_KeplerianParametersAlm_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_KeplerianParametersAlm_ie_Extensions__item__criticality._const_tab = ____GANSS_KeplerianParametersAlm_ie_Extensions__item__criticality_tab
    ___GANSS_KeplerianParametersAlm_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GANSS_KeplerianParametersAlm_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GANSS_KeplerianParametersAlm_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GANSS_KeplerianParametersAlm_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_KeplerianParametersAlm_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_KeplerianParametersAlm_ie_Extensions__item__extensionValue._const_tab = ____GANSS_KeplerianParametersAlm_ie_Extensions__item__extensionValue_tab
    ___GANSS_KeplerianParametersAlm_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GANSS_KeplerianParametersAlm_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GANSS_KeplerianParametersAlm_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GANSS_KeplerianParametersAlm_ie_Extensions__item__id),
        (u'criticality', ___GANSS_KeplerianParametersAlm_ie_Extensions__item__criticality),
        (u'extensionValue', ___GANSS_KeplerianParametersAlm_ie_Extensions__item__extensionValue),
        ])
    __GANSS_KeplerianParametersAlm_ie_Extensions__item_._ext = None
    _GANSS_KeplerianParametersAlm_ie_Extensions._cont = __GANSS_KeplerianParametersAlm_ie_Extensions__item_
    _GANSS_KeplerianParametersAlm_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GANSS_KeplerianParametersAlm._cont = ASN1Dict([
        (u't-oa', _GANSS_KeplerianParametersAlm_t_oa),
        (u'iod-a', _GANSS_KeplerianParametersAlm_iod_a),
        (u'gANSS-SatelliteInformationKP', _GANSS_KeplerianParametersAlm_gANSS_SatelliteInformationKP),
        (u'ie-Extensions', _GANSS_KeplerianParametersAlm_ie_Extensions),
        ])
    GANSS_KeplerianParametersAlm._ext = []
    
    #-----< GANSS-KeplerianParametersAlm-ExtIEs >-----#
    GANSS_KeplerianParametersAlm_ExtIEs = CLASS(name=u'GANSS-KeplerianParametersAlm-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GANSS_KeplerianParametersAlm_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GANSS-KeplerianParametersOrb >-----#
    GANSS_KeplerianParametersOrb = SEQ(name=u'GANSS-KeplerianParametersOrb', mode=MODE_TYPE)
    _GANSS_KeplerianParametersOrb_toe_nav = BIT_STR(name=u'toe-nav', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_KeplerianParametersOrb_toe_nav._const_sz = ASN1Set(rv=[14], rr=[], ev=None, er=[])
    _GANSS_KeplerianParametersOrb_ganss_omega_nav = BIT_STR(name=u'ganss-omega-nav', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_KeplerianParametersOrb_ganss_omega_nav._const_sz = ASN1Set(rv=[32], rr=[], ev=None, er=[])
    _GANSS_KeplerianParametersOrb_delta_n_nav = BIT_STR(name=u'delta-n-nav', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_KeplerianParametersOrb_delta_n_nav._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _GANSS_KeplerianParametersOrb_m_zero_nav = BIT_STR(name=u'm-zero-nav', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_KeplerianParametersOrb_m_zero_nav._const_sz = ASN1Set(rv=[32], rr=[], ev=None, er=[])
    _GANSS_KeplerianParametersOrb_omegadot_nav = BIT_STR(name=u'omegadot-nav', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_KeplerianParametersOrb_omegadot_nav._const_sz = ASN1Set(rv=[24], rr=[], ev=None, er=[])
    _GANSS_KeplerianParametersOrb_ganss_e_nav = BIT_STR(name=u'ganss-e-nav', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_KeplerianParametersOrb_ganss_e_nav._const_sz = ASN1Set(rv=[32], rr=[], ev=None, er=[])
    _GANSS_KeplerianParametersOrb_idot_nav = BIT_STR(name=u'idot-nav', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_KeplerianParametersOrb_idot_nav._const_sz = ASN1Set(rv=[14], rr=[], ev=None, er=[])
    _GANSS_KeplerianParametersOrb_a_sqrt_nav = BIT_STR(name=u'a-sqrt-nav', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_KeplerianParametersOrb_a_sqrt_nav._const_sz = ASN1Set(rv=[32], rr=[], ev=None, er=[])
    _GANSS_KeplerianParametersOrb_i_zero_nav = BIT_STR(name=u'i-zero-nav', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_KeplerianParametersOrb_i_zero_nav._const_sz = ASN1Set(rv=[32], rr=[], ev=None, er=[])
    _GANSS_KeplerianParametersOrb_omega_zero_nav = BIT_STR(name=u'omega-zero-nav', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_KeplerianParametersOrb_omega_zero_nav._const_sz = ASN1Set(rv=[32], rr=[], ev=None, er=[])
    _GANSS_KeplerianParametersOrb_c_rs_nav = BIT_STR(name=u'c-rs-nav', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_KeplerianParametersOrb_c_rs_nav._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _GANSS_KeplerianParametersOrb_c_is_nav = BIT_STR(name=u'c-is-nav', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_KeplerianParametersOrb_c_is_nav._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _GANSS_KeplerianParametersOrb_c_us_nav = BIT_STR(name=u'c-us-nav', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_KeplerianParametersOrb_c_us_nav._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _GANSS_KeplerianParametersOrb_c_rc_nav = BIT_STR(name=u'c-rc-nav', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_KeplerianParametersOrb_c_rc_nav._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _GANSS_KeplerianParametersOrb_c_ic_nav = BIT_STR(name=u'c-ic-nav', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_KeplerianParametersOrb_c_ic_nav._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _GANSS_KeplerianParametersOrb_c_uc_nav = BIT_STR(name=u'c-uc-nav', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_KeplerianParametersOrb_c_uc_nav._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _GANSS_KeplerianParametersOrb_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GANSS_KeplerianParametersOrb_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GANSS_KeplerianParametersOrb_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GANSS_KeplerianParametersOrb_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_KeplerianParametersOrb_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_KeplerianParametersOrb_ie_Extensions__item__id._const_tab = ____GANSS_KeplerianParametersOrb_ie_Extensions__item__id_tab
    ___GANSS_KeplerianParametersOrb_ie_Extensions__item__id._const_tab_at = None
    ___GANSS_KeplerianParametersOrb_ie_Extensions__item__id._const_tab_id = u'id'
    ___GANSS_KeplerianParametersOrb_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GANSS_KeplerianParametersOrb_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_KeplerianParametersOrb_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_KeplerianParametersOrb_ie_Extensions__item__criticality._const_tab = ____GANSS_KeplerianParametersOrb_ie_Extensions__item__criticality_tab
    ___GANSS_KeplerianParametersOrb_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GANSS_KeplerianParametersOrb_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GANSS_KeplerianParametersOrb_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GANSS_KeplerianParametersOrb_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_KeplerianParametersOrb_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_KeplerianParametersOrb_ie_Extensions__item__extensionValue._const_tab = ____GANSS_KeplerianParametersOrb_ie_Extensions__item__extensionValue_tab
    ___GANSS_KeplerianParametersOrb_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GANSS_KeplerianParametersOrb_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GANSS_KeplerianParametersOrb_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GANSS_KeplerianParametersOrb_ie_Extensions__item__id),
        (u'criticality', ___GANSS_KeplerianParametersOrb_ie_Extensions__item__criticality),
        (u'extensionValue', ___GANSS_KeplerianParametersOrb_ie_Extensions__item__extensionValue),
        ])
    __GANSS_KeplerianParametersOrb_ie_Extensions__item_._ext = None
    _GANSS_KeplerianParametersOrb_ie_Extensions._cont = __GANSS_KeplerianParametersOrb_ie_Extensions__item_
    _GANSS_KeplerianParametersOrb_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GANSS_KeplerianParametersOrb._cont = ASN1Dict([
        (u'toe-nav', _GANSS_KeplerianParametersOrb_toe_nav),
        (u'ganss-omega-nav', _GANSS_KeplerianParametersOrb_ganss_omega_nav),
        (u'delta-n-nav', _GANSS_KeplerianParametersOrb_delta_n_nav),
        (u'm-zero-nav', _GANSS_KeplerianParametersOrb_m_zero_nav),
        (u'omegadot-nav', _GANSS_KeplerianParametersOrb_omegadot_nav),
        (u'ganss-e-nav', _GANSS_KeplerianParametersOrb_ganss_e_nav),
        (u'idot-nav', _GANSS_KeplerianParametersOrb_idot_nav),
        (u'a-sqrt-nav', _GANSS_KeplerianParametersOrb_a_sqrt_nav),
        (u'i-zero-nav', _GANSS_KeplerianParametersOrb_i_zero_nav),
        (u'omega-zero-nav', _GANSS_KeplerianParametersOrb_omega_zero_nav),
        (u'c-rs-nav', _GANSS_KeplerianParametersOrb_c_rs_nav),
        (u'c-is-nav', _GANSS_KeplerianParametersOrb_c_is_nav),
        (u'c-us-nav', _GANSS_KeplerianParametersOrb_c_us_nav),
        (u'c-rc-nav', _GANSS_KeplerianParametersOrb_c_rc_nav),
        (u'c-ic-nav', _GANSS_KeplerianParametersOrb_c_ic_nav),
        (u'c-uc-nav', _GANSS_KeplerianParametersOrb_c_uc_nav),
        (u'ie-Extensions', _GANSS_KeplerianParametersOrb_ie_Extensions),
        ])
    GANSS_KeplerianParametersOrb._ext = []
    
    #-----< GANSS-KeplerianParametersOrb-ExtIEs >-----#
    GANSS_KeplerianParametersOrb_ExtIEs = CLASS(name=u'GANSS-KeplerianParametersOrb-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GANSS_KeplerianParametersOrb_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GANSS-MeasurementParameters >-----#
    GANSS_MeasurementParameters = SEQ_OF(name=u'GANSS-MeasurementParameters', mode=MODE_TYPE)
    _GANSS_MeasurementParameters__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-MeasurementParametersItem')))
    GANSS_MeasurementParameters._cont = _GANSS_MeasurementParameters__item_
    GANSS_MeasurementParameters._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    
    #-----< GANSS-MeasurementParametersItem >-----#
    GANSS_MeasurementParametersItem = SEQ(name=u'GANSS-MeasurementParametersItem', mode=MODE_TYPE)
    _GANSS_MeasurementParametersItem_satId = INT(name=u'satId', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_MeasurementParametersItem_satId._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    _GANSS_MeasurementParametersItem_cToNzero = INT(name=u'cToNzero', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_MeasurementParametersItem_cToNzero._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    _GANSS_MeasurementParametersItem_multipathIndicator = ENUM(name=u'multipathIndicator', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_MeasurementParametersItem_multipathIndicator._cont = ASN1Dict([(u'nM', 0), (u'low', 1), (u'medium', 2), (u'high', 3)])
    _GANSS_MeasurementParametersItem_multipathIndicator._ext = None
    _GANSS_MeasurementParametersItem_carrierQualityIndication = BIT_STR(name=u'carrierQualityIndication', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GANSS_MeasurementParametersItem_carrierQualityIndication._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    _GANSS_MeasurementParametersItem_ganssCodePhase = INT(name=u'ganssCodePhase', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_MeasurementParametersItem_ganssCodePhase._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=2097151)], ev=None, er=[])
    _GANSS_MeasurementParametersItem_ganssIntegerCodePhase = INT(name=u'ganssIntegerCodePhase', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GANSS_MeasurementParametersItem_ganssIntegerCodePhase._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    _GANSS_MeasurementParametersItem_codePhaseRmsError = INT(name=u'codePhaseRmsError', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_MeasurementParametersItem_codePhaseRmsError._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    _GANSS_MeasurementParametersItem_doppler = INT(name=u'doppler', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_MeasurementParametersItem_doppler._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-32768, ub=32767)], ev=None, er=[])
    _GANSS_MeasurementParametersItem_adr = INT(name=u'adr', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GANSS_MeasurementParametersItem_adr._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=33554431)], ev=None, er=[])
    _GANSS_MeasurementParametersItem_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GANSS_MeasurementParametersItem_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GANSS_MeasurementParametersItem_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GANSS_MeasurementParametersItem_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____GANSS_MeasurementParametersItem_ie_Extensions__item__id_tab_val_Extension_0 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GanssIntegerCodePhaseExt')))
    ____GANSS_MeasurementParametersItem_ie_Extensions__item__id_tab._val = ASN1Set(rv=[dict([(u'id', 100), (u'criticality', u'ignore'), (u'Extension', _____GANSS_MeasurementParametersItem_ie_Extensions__item__id_tab_val_Extension_0), (u'presence', u'optional')])], rr=[], ev=None, er=[])
    ___GANSS_MeasurementParametersItem_ie_Extensions__item__id._const_tab = ____GANSS_MeasurementParametersItem_ie_Extensions__item__id_tab
    ___GANSS_MeasurementParametersItem_ie_Extensions__item__id._const_tab_at = None
    ___GANSS_MeasurementParametersItem_ie_Extensions__item__id._const_tab_id = u'id'
    ___GANSS_MeasurementParametersItem_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ___GANSS_MeasurementParametersItem_ie_Extensions__item__criticality._const_tab = ____GANSS_MeasurementParametersItem_ie_Extensions__item__id_tab
    ___GANSS_MeasurementParametersItem_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GANSS_MeasurementParametersItem_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GANSS_MeasurementParametersItem_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ___GANSS_MeasurementParametersItem_ie_Extensions__item__extensionValue._const_tab = ____GANSS_MeasurementParametersItem_ie_Extensions__item__id_tab
    ___GANSS_MeasurementParametersItem_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GANSS_MeasurementParametersItem_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GANSS_MeasurementParametersItem_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GANSS_MeasurementParametersItem_ie_Extensions__item__id),
        (u'criticality', ___GANSS_MeasurementParametersItem_ie_Extensions__item__criticality),
        (u'extensionValue', ___GANSS_MeasurementParametersItem_ie_Extensions__item__extensionValue),
        ])
    __GANSS_MeasurementParametersItem_ie_Extensions__item_._ext = None
    _GANSS_MeasurementParametersItem_ie_Extensions._cont = __GANSS_MeasurementParametersItem_ie_Extensions__item_
    _GANSS_MeasurementParametersItem_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GANSS_MeasurementParametersItem._cont = ASN1Dict([
        (u'satId', _GANSS_MeasurementParametersItem_satId),
        (u'cToNzero', _GANSS_MeasurementParametersItem_cToNzero),
        (u'multipathIndicator', _GANSS_MeasurementParametersItem_multipathIndicator),
        (u'carrierQualityIndication', _GANSS_MeasurementParametersItem_carrierQualityIndication),
        (u'ganssCodePhase', _GANSS_MeasurementParametersItem_ganssCodePhase),
        (u'ganssIntegerCodePhase', _GANSS_MeasurementParametersItem_ganssIntegerCodePhase),
        (u'codePhaseRmsError', _GANSS_MeasurementParametersItem_codePhaseRmsError),
        (u'doppler', _GANSS_MeasurementParametersItem_doppler),
        (u'adr', _GANSS_MeasurementParametersItem_adr),
        (u'ie-Extensions', _GANSS_MeasurementParametersItem_ie_Extensions),
        ])
    GANSS_MeasurementParametersItem._ext = []
    
    #-----< GANSS-MeasurementParametersItem-ExtIEs >-----#
    GANSS_MeasurementParametersItem_ExtIEs = CLASS(name=u'GANSS-MeasurementParametersItem-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _GANSS_MeasurementParametersItem_ExtIEs_val_Extension_0 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GanssIntegerCodePhaseExt')))
    GANSS_MeasurementParametersItem_ExtIEs._val = ASN1Set(rv=[dict([(u'id', 100), (u'criticality', u'ignore'), (u'Extension', _GANSS_MeasurementParametersItem_ExtIEs_val_Extension_0), (u'presence', u'optional')])], rr=[], ev=[], er=[])
    
    #-----< GanssIntegerCodePhaseExt >-----#
    GanssIntegerCodePhaseExt = SEQ(name=u'GanssIntegerCodePhaseExt', mode=MODE_TYPE)
    _GanssIntegerCodePhaseExt_ganssIntegerCodePhase_ext = INT(name=u'ganssIntegerCodePhase-ext', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GanssIntegerCodePhaseExt_ganssIntegerCodePhase_ext._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=64, ub=127)], ev=None, er=[])
    _GanssIntegerCodePhaseExt_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GanssIntegerCodePhaseExt_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GanssIntegerCodePhaseExt_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GanssIntegerCodePhaseExt_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GanssIntegerCodePhaseExt_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GanssIntegerCodePhaseExt_ie_Extensions__item__id._const_tab = ____GanssIntegerCodePhaseExt_ie_Extensions__item__id_tab
    ___GanssIntegerCodePhaseExt_ie_Extensions__item__id._const_tab_at = None
    ___GanssIntegerCodePhaseExt_ie_Extensions__item__id._const_tab_id = u'id'
    ___GanssIntegerCodePhaseExt_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GanssIntegerCodePhaseExt_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GanssIntegerCodePhaseExt_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GanssIntegerCodePhaseExt_ie_Extensions__item__criticality._const_tab = ____GanssIntegerCodePhaseExt_ie_Extensions__item__criticality_tab
    ___GanssIntegerCodePhaseExt_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GanssIntegerCodePhaseExt_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GanssIntegerCodePhaseExt_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GanssIntegerCodePhaseExt_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GanssIntegerCodePhaseExt_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GanssIntegerCodePhaseExt_ie_Extensions__item__extensionValue._const_tab = ____GanssIntegerCodePhaseExt_ie_Extensions__item__extensionValue_tab
    ___GanssIntegerCodePhaseExt_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GanssIntegerCodePhaseExt_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GanssIntegerCodePhaseExt_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GanssIntegerCodePhaseExt_ie_Extensions__item__id),
        (u'criticality', ___GanssIntegerCodePhaseExt_ie_Extensions__item__criticality),
        (u'extensionValue', ___GanssIntegerCodePhaseExt_ie_Extensions__item__extensionValue),
        ])
    __GanssIntegerCodePhaseExt_ie_Extensions__item_._ext = None
    _GanssIntegerCodePhaseExt_ie_Extensions._cont = __GanssIntegerCodePhaseExt_ie_Extensions__item_
    _GanssIntegerCodePhaseExt_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GanssIntegerCodePhaseExt._cont = ASN1Dict([
        (u'ganssIntegerCodePhase-ext', _GanssIntegerCodePhaseExt_ganssIntegerCodePhase_ext),
        (u'ie-Extensions', _GanssIntegerCodePhaseExt_ie_Extensions),
        ])
    GanssIntegerCodePhaseExt._ext = []
    
    #-----< GanssIntegerCodePhaseExt-ExtIEs >-----#
    GanssIntegerCodePhaseExt_ExtIEs = CLASS(name=u'GanssIntegerCodePhaseExt-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GanssIntegerCodePhaseExt_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GANSS-MeasuredResultsList >-----#
    GANSS_MeasuredResultsList = SEQ_OF(name=u'GANSS-MeasuredResultsList', mode=MODE_TYPE)
    _GANSS_MeasuredResultsList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-MeasuredResults')))
    GANSS_MeasuredResultsList._cont = _GANSS_MeasuredResultsList__item_
    GANSS_MeasuredResultsList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=3)], ev=None, er=[])
    
    #-----< GANSS-MeasuredResults >-----#
    GANSS_MeasuredResults = SEQ(name=u'GANSS-MeasuredResults', mode=MODE_TYPE)
    _GANSS_MeasuredResults_referenceTime = CHOICE(name=u'referenceTime', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __GANSS_MeasuredResults_referenceTime_utranReferenceTime = SEQ(name=u'utranReferenceTime', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'UTRAN-GANSSReferenceTimeUL')))
    __GANSS_MeasuredResults_referenceTime_ganssReferenceTimeOnly = SEQ(name=u'ganssReferenceTimeOnly', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSS-ReferenceTimeOnly')))
    _GANSS_MeasuredResults_referenceTime._cont = ASN1Dict([
        (u'utranReferenceTime', __GANSS_MeasuredResults_referenceTime_utranReferenceTime),
        (u'ganssReferenceTimeOnly', __GANSS_MeasuredResults_referenceTime_ganssReferenceTimeOnly),
        ])
    _GANSS_MeasuredResults_referenceTime._ext = []
    _GANSS_MeasuredResults_ganssGenericMeasurementInfo = SEQ_OF(name=u'ganssGenericMeasurementInfo', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSS-GenericMeasurementInfo')))
    _GANSS_MeasuredResults_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GANSS_MeasuredResults_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GANSS_MeasuredResults_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GANSS_MeasuredResults_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_MeasuredResults_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_MeasuredResults_ie_Extensions__item__id._const_tab = ____GANSS_MeasuredResults_ie_Extensions__item__id_tab
    ___GANSS_MeasuredResults_ie_Extensions__item__id._const_tab_at = None
    ___GANSS_MeasuredResults_ie_Extensions__item__id._const_tab_id = u'id'
    ___GANSS_MeasuredResults_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GANSS_MeasuredResults_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_MeasuredResults_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_MeasuredResults_ie_Extensions__item__criticality._const_tab = ____GANSS_MeasuredResults_ie_Extensions__item__criticality_tab
    ___GANSS_MeasuredResults_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GANSS_MeasuredResults_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GANSS_MeasuredResults_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GANSS_MeasuredResults_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_MeasuredResults_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_MeasuredResults_ie_Extensions__item__extensionValue._const_tab = ____GANSS_MeasuredResults_ie_Extensions__item__extensionValue_tab
    ___GANSS_MeasuredResults_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GANSS_MeasuredResults_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GANSS_MeasuredResults_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GANSS_MeasuredResults_ie_Extensions__item__id),
        (u'criticality', ___GANSS_MeasuredResults_ie_Extensions__item__criticality),
        (u'extensionValue', ___GANSS_MeasuredResults_ie_Extensions__item__extensionValue),
        ])
    __GANSS_MeasuredResults_ie_Extensions__item_._ext = None
    _GANSS_MeasuredResults_ie_Extensions._cont = __GANSS_MeasuredResults_ie_Extensions__item_
    _GANSS_MeasuredResults_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GANSS_MeasuredResults._cont = ASN1Dict([
        (u'referenceTime', _GANSS_MeasuredResults_referenceTime),
        (u'ganssGenericMeasurementInfo', _GANSS_MeasuredResults_ganssGenericMeasurementInfo),
        (u'ie-Extensions', _GANSS_MeasuredResults_ie_Extensions),
        ])
    GANSS_MeasuredResults._ext = []
    
    #-----< GANSS-MeasuredResults-ExtIEs >-----#
    GANSS_MeasuredResults_ExtIEs = CLASS(name=u'GANSS-MeasuredResults-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GANSS_MeasuredResults_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GANSS-Navigation-Model >-----#
    GANSS_Navigation_Model = SEQ(name=u'GANSS-Navigation-Model', mode=MODE_TYPE)
    _GANSS_Navigation_Model_non_broadcastIndication = ENUM(name=u'non-broadcastIndication', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GANSS_Navigation_Model_non_broadcastIndication._cont = ASN1Dict([(u'true', 0)])
    _GANSS_Navigation_Model_non_broadcastIndication._ext = None
    _GANSS_Navigation_Model_ganssSatInfoNav = SEQ_OF(name=u'ganssSatInfoNav', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSS-Sat-Info-Nav')))
    _GANSS_Navigation_Model_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GANSS_Navigation_Model_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GANSS_Navigation_Model_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GANSS_Navigation_Model_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_Navigation_Model_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_Navigation_Model_ie_Extensions__item__id._const_tab = ____GANSS_Navigation_Model_ie_Extensions__item__id_tab
    ___GANSS_Navigation_Model_ie_Extensions__item__id._const_tab_at = None
    ___GANSS_Navigation_Model_ie_Extensions__item__id._const_tab_id = u'id'
    ___GANSS_Navigation_Model_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GANSS_Navigation_Model_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_Navigation_Model_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_Navigation_Model_ie_Extensions__item__criticality._const_tab = ____GANSS_Navigation_Model_ie_Extensions__item__criticality_tab
    ___GANSS_Navigation_Model_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GANSS_Navigation_Model_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GANSS_Navigation_Model_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GANSS_Navigation_Model_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_Navigation_Model_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_Navigation_Model_ie_Extensions__item__extensionValue._const_tab = ____GANSS_Navigation_Model_ie_Extensions__item__extensionValue_tab
    ___GANSS_Navigation_Model_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GANSS_Navigation_Model_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GANSS_Navigation_Model_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GANSS_Navigation_Model_ie_Extensions__item__id),
        (u'criticality', ___GANSS_Navigation_Model_ie_Extensions__item__criticality),
        (u'extensionValue', ___GANSS_Navigation_Model_ie_Extensions__item__extensionValue),
        ])
    __GANSS_Navigation_Model_ie_Extensions__item_._ext = None
    _GANSS_Navigation_Model_ie_Extensions._cont = __GANSS_Navigation_Model_ie_Extensions__item_
    _GANSS_Navigation_Model_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GANSS_Navigation_Model._cont = ASN1Dict([
        (u'non-broadcastIndication', _GANSS_Navigation_Model_non_broadcastIndication),
        (u'ganssSatInfoNav', _GANSS_Navigation_Model_ganssSatInfoNav),
        (u'ie-Extensions', _GANSS_Navigation_Model_ie_Extensions),
        ])
    GANSS_Navigation_Model._ext = []
    
    #-----< GANSS-Navigation-Model-ExtIEs >-----#
    GANSS_Navigation_Model_ExtIEs = CLASS(name=u'GANSS-Navigation-Model-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GANSS_Navigation_Model_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GANSS-Orbit-Model >-----#
    GANSS_Orbit_Model = CHOICE(name=u'GANSS-Orbit-Model', mode=MODE_TYPE)
    _GANSS_Orbit_Model_gANSS_keplerianParameters = SEQ(name=u'gANSS-keplerianParameters', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSS-KeplerianParametersOrb')))
    GANSS_Orbit_Model._cont = ASN1Dict([
        (u'gANSS-keplerianParameters', _GANSS_Orbit_Model_gANSS_keplerianParameters),
        ])
    GANSS_Orbit_Model._ext = []
    
    #-----< GANSS-Real-Time-Integrity >-----#
    GANSS_Real_Time_Integrity = SEQ_OF(name=u'GANSS-Real-Time-Integrity', mode=MODE_TYPE)
    _GANSS_Real_Time_Integrity__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-RealTimeInformationItem')))
    GANSS_Real_Time_Integrity._cont = _GANSS_Real_Time_Integrity__item_
    GANSS_Real_Time_Integrity._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    
    #-----< GANSS-RealTimeInformationItem >-----#
    GANSS_RealTimeInformationItem = SEQ(name=u'GANSS-RealTimeInformationItem', mode=MODE_TYPE)
    _GANSS_RealTimeInformationItem_bad_ganss_satId = INT(name=u'bad-ganss-satId', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_RealTimeInformationItem_bad_ganss_satId._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    _GANSS_RealTimeInformationItem_bad_ganss_signalId = BIT_STR(name=u'bad-ganss-signalId', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GANSS_RealTimeInformationItem_bad_ganss_signalId._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _GANSS_RealTimeInformationItem_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GANSS_RealTimeInformationItem_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GANSS_RealTimeInformationItem_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GANSS_RealTimeInformationItem_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_RealTimeInformationItem_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_RealTimeInformationItem_ie_Extensions__item__id._const_tab = ____GANSS_RealTimeInformationItem_ie_Extensions__item__id_tab
    ___GANSS_RealTimeInformationItem_ie_Extensions__item__id._const_tab_at = None
    ___GANSS_RealTimeInformationItem_ie_Extensions__item__id._const_tab_id = u'id'
    ___GANSS_RealTimeInformationItem_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GANSS_RealTimeInformationItem_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_RealTimeInformationItem_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_RealTimeInformationItem_ie_Extensions__item__criticality._const_tab = ____GANSS_RealTimeInformationItem_ie_Extensions__item__criticality_tab
    ___GANSS_RealTimeInformationItem_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GANSS_RealTimeInformationItem_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GANSS_RealTimeInformationItem_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GANSS_RealTimeInformationItem_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_RealTimeInformationItem_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_RealTimeInformationItem_ie_Extensions__item__extensionValue._const_tab = ____GANSS_RealTimeInformationItem_ie_Extensions__item__extensionValue_tab
    ___GANSS_RealTimeInformationItem_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GANSS_RealTimeInformationItem_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GANSS_RealTimeInformationItem_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GANSS_RealTimeInformationItem_ie_Extensions__item__id),
        (u'criticality', ___GANSS_RealTimeInformationItem_ie_Extensions__item__criticality),
        (u'extensionValue', ___GANSS_RealTimeInformationItem_ie_Extensions__item__extensionValue),
        ])
    __GANSS_RealTimeInformationItem_ie_Extensions__item_._ext = None
    _GANSS_RealTimeInformationItem_ie_Extensions._cont = __GANSS_RealTimeInformationItem_ie_Extensions__item_
    _GANSS_RealTimeInformationItem_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GANSS_RealTimeInformationItem._cont = ASN1Dict([
        (u'bad-ganss-satId', _GANSS_RealTimeInformationItem_bad_ganss_satId),
        (u'bad-ganss-signalId', _GANSS_RealTimeInformationItem_bad_ganss_signalId),
        (u'ie-Extensions', _GANSS_RealTimeInformationItem_ie_Extensions),
        ])
    GANSS_RealTimeInformationItem._ext = []
    
    #-----< GANSS-RealTimeInformationItem-ExtIEs >-----#
    GANSS_RealTimeInformationItem_ExtIEs = CLASS(name=u'GANSS-RealTimeInformationItem-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GANSS_RealTimeInformationItem_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GANSS-Reference-Location >-----#
    GANSS_Reference_Location = SEQ(name=u'GANSS-Reference-Location', mode=MODE_TYPE)
    _GANSS_Reference_Location_ue_PositionEstimate = CHOICE(name=u'ue-PositionEstimate', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'UE-PositionEstimate')))
    _GANSS_Reference_Location_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GANSS_Reference_Location_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GANSS_Reference_Location_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GANSS_Reference_Location_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_Reference_Location_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_Reference_Location_iE_Extensions__item__id._const_tab = ____GANSS_Reference_Location_iE_Extensions__item__id_tab
    ___GANSS_Reference_Location_iE_Extensions__item__id._const_tab_at = None
    ___GANSS_Reference_Location_iE_Extensions__item__id._const_tab_id = u'id'
    ___GANSS_Reference_Location_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GANSS_Reference_Location_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_Reference_Location_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_Reference_Location_iE_Extensions__item__criticality._const_tab = ____GANSS_Reference_Location_iE_Extensions__item__criticality_tab
    ___GANSS_Reference_Location_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GANSS_Reference_Location_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GANSS_Reference_Location_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GANSS_Reference_Location_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_Reference_Location_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_Reference_Location_iE_Extensions__item__extensionValue._const_tab = ____GANSS_Reference_Location_iE_Extensions__item__extensionValue_tab
    ___GANSS_Reference_Location_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GANSS_Reference_Location_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GANSS_Reference_Location_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GANSS_Reference_Location_iE_Extensions__item__id),
        (u'criticality', ___GANSS_Reference_Location_iE_Extensions__item__criticality),
        (u'extensionValue', ___GANSS_Reference_Location_iE_Extensions__item__extensionValue),
        ])
    __GANSS_Reference_Location_iE_Extensions__item_._ext = None
    _GANSS_Reference_Location_iE_Extensions._cont = __GANSS_Reference_Location_iE_Extensions__item_
    _GANSS_Reference_Location_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GANSS_Reference_Location._cont = ASN1Dict([
        (u'ue-PositionEstimate', _GANSS_Reference_Location_ue_PositionEstimate),
        (u'iE-Extensions', _GANSS_Reference_Location_iE_Extensions),
        ])
    GANSS_Reference_Location._ext = []
    
    #-----< GANSS-Reference-Location-ExtIEs >-----#
    GANSS_Reference_Location_ExtIEs = CLASS(name=u'GANSS-Reference-Location-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GANSS_Reference_Location_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GANSS-ReferenceMeasurementInfo >-----#
    GANSS_ReferenceMeasurementInfo = SEQ(name=u'GANSS-ReferenceMeasurementInfo', mode=MODE_TYPE)
    _GANSS_ReferenceMeasurementInfo_ganssSignalId = SEQ(name=u'ganssSignalId', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSS-SignalID')), opt=True)
    _GANSS_ReferenceMeasurementInfo_satelliteInformation = SEQ_OF(name=u'satelliteInformation', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSS-SatelliteInformation')))
    _GANSS_ReferenceMeasurementInfo_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GANSS_ReferenceMeasurementInfo_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GANSS_ReferenceMeasurementInfo_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GANSS_ReferenceMeasurementInfo_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____GANSS_ReferenceMeasurementInfo_ie_Extensions__item__id_tab_val_Extension_0 = INT(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'Confidence')))
    ____GANSS_ReferenceMeasurementInfo_ie_Extensions__item__id_tab._val = ASN1Set(rv=[dict([(u'id', 137), (u'criticality', u'ignore'), (u'Extension', _____GANSS_ReferenceMeasurementInfo_ie_Extensions__item__id_tab_val_Extension_0), (u'presence', u'optional')])], rr=[], ev=None, er=[])
    ___GANSS_ReferenceMeasurementInfo_ie_Extensions__item__id._const_tab = ____GANSS_ReferenceMeasurementInfo_ie_Extensions__item__id_tab
    ___GANSS_ReferenceMeasurementInfo_ie_Extensions__item__id._const_tab_at = None
    ___GANSS_ReferenceMeasurementInfo_ie_Extensions__item__id._const_tab_id = u'id'
    ___GANSS_ReferenceMeasurementInfo_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ___GANSS_ReferenceMeasurementInfo_ie_Extensions__item__criticality._const_tab = ____GANSS_ReferenceMeasurementInfo_ie_Extensions__item__id_tab
    ___GANSS_ReferenceMeasurementInfo_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GANSS_ReferenceMeasurementInfo_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GANSS_ReferenceMeasurementInfo_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ___GANSS_ReferenceMeasurementInfo_ie_Extensions__item__extensionValue._const_tab = ____GANSS_ReferenceMeasurementInfo_ie_Extensions__item__id_tab
    ___GANSS_ReferenceMeasurementInfo_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GANSS_ReferenceMeasurementInfo_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GANSS_ReferenceMeasurementInfo_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GANSS_ReferenceMeasurementInfo_ie_Extensions__item__id),
        (u'criticality', ___GANSS_ReferenceMeasurementInfo_ie_Extensions__item__criticality),
        (u'extensionValue', ___GANSS_ReferenceMeasurementInfo_ie_Extensions__item__extensionValue),
        ])
    __GANSS_ReferenceMeasurementInfo_ie_Extensions__item_._ext = None
    _GANSS_ReferenceMeasurementInfo_ie_Extensions._cont = __GANSS_ReferenceMeasurementInfo_ie_Extensions__item_
    _GANSS_ReferenceMeasurementInfo_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GANSS_ReferenceMeasurementInfo._cont = ASN1Dict([
        (u'ganssSignalId', _GANSS_ReferenceMeasurementInfo_ganssSignalId),
        (u'satelliteInformation', _GANSS_ReferenceMeasurementInfo_satelliteInformation),
        (u'ie-Extensions', _GANSS_ReferenceMeasurementInfo_ie_Extensions),
        ])
    GANSS_ReferenceMeasurementInfo._ext = []
    
    #-----< GANSS-ReferenceMeasurementInfo-ExtIEs >-----#
    GANSS_ReferenceMeasurementInfo_ExtIEs = CLASS(name=u'GANSS-ReferenceMeasurementInfo-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _GANSS_ReferenceMeasurementInfo_ExtIEs_val_Extension_0 = INT(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'Confidence')))
    GANSS_ReferenceMeasurementInfo_ExtIEs._val = ASN1Set(rv=[dict([(u'id', 137), (u'criticality', u'ignore'), (u'Extension', _GANSS_ReferenceMeasurementInfo_ExtIEs_val_Extension_0), (u'presence', u'optional')])], rr=[], ev=[], er=[])
    
    #-----< GANSS-Reference-Time >-----#
    GANSS_Reference_Time = SEQ(name=u'GANSS-Reference-Time', mode=MODE_TYPE)
    _GANSS_Reference_Time_ganssDay = INT(name=u'ganssDay', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GANSS_Reference_Time_ganssDay._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=8191)], ev=None, er=[])
    _GANSS_Reference_Time_ganssTod = INT(name=u'ganssTod', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_Reference_Time_ganssTod._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=86399)], ev=None, er=[])
    _GANSS_Reference_Time_ganssTodUncertainty = INT(name=u'ganssTodUncertainty', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GANSS_Reference_Time_ganssTodUncertainty._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    _GANSS_Reference_Time_ganssTimeId = SEQ(name=u'ganssTimeId', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSSID')), opt=True)
    _GANSS_Reference_Time_utran_ganssreferenceTime = SEQ(name=u'utran-ganssreferenceTime', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'UTRAN-GANSSReferenceTimeDL')), opt=True)
    _GANSS_Reference_Time_tutran_ganss_driftRate = ENUM(name=u'tutran-ganss-driftRate', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'TUTRAN-GANSS-DriftRate')), opt=True)
    _GANSS_Reference_Time_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GANSS_Reference_Time_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GANSS_Reference_Time_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GANSS_Reference_Time_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____GANSS_Reference_Time_ie_Extensions__item__id_tab_val_Extension_0 = INT(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-Day-Cycle')))
    ____GANSS_Reference_Time_ie_Extensions__item__id_tab._val = ASN1Set(rv=[dict([(u'id', 122), (u'criticality', u'ignore'), (u'Extension', _____GANSS_Reference_Time_ie_Extensions__item__id_tab_val_Extension_0), (u'presence', u'optional')])], rr=[], ev=None, er=[])
    ___GANSS_Reference_Time_ie_Extensions__item__id._const_tab = ____GANSS_Reference_Time_ie_Extensions__item__id_tab
    ___GANSS_Reference_Time_ie_Extensions__item__id._const_tab_at = None
    ___GANSS_Reference_Time_ie_Extensions__item__id._const_tab_id = u'id'
    ___GANSS_Reference_Time_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ___GANSS_Reference_Time_ie_Extensions__item__criticality._const_tab = ____GANSS_Reference_Time_ie_Extensions__item__id_tab
    ___GANSS_Reference_Time_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GANSS_Reference_Time_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GANSS_Reference_Time_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ___GANSS_Reference_Time_ie_Extensions__item__extensionValue._const_tab = ____GANSS_Reference_Time_ie_Extensions__item__id_tab
    ___GANSS_Reference_Time_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GANSS_Reference_Time_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GANSS_Reference_Time_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GANSS_Reference_Time_ie_Extensions__item__id),
        (u'criticality', ___GANSS_Reference_Time_ie_Extensions__item__criticality),
        (u'extensionValue', ___GANSS_Reference_Time_ie_Extensions__item__extensionValue),
        ])
    __GANSS_Reference_Time_ie_Extensions__item_._ext = None
    _GANSS_Reference_Time_ie_Extensions._cont = __GANSS_Reference_Time_ie_Extensions__item_
    _GANSS_Reference_Time_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GANSS_Reference_Time._cont = ASN1Dict([
        (u'ganssDay', _GANSS_Reference_Time_ganssDay),
        (u'ganssTod', _GANSS_Reference_Time_ganssTod),
        (u'ganssTodUncertainty', _GANSS_Reference_Time_ganssTodUncertainty),
        (u'ganssTimeId', _GANSS_Reference_Time_ganssTimeId),
        (u'utran-ganssreferenceTime', _GANSS_Reference_Time_utran_ganssreferenceTime),
        (u'tutran-ganss-driftRate', _GANSS_Reference_Time_tutran_ganss_driftRate),
        (u'ie-Extensions', _GANSS_Reference_Time_ie_Extensions),
        ])
    GANSS_Reference_Time._ext = []
    
    #-----< GANSS-Reference-Time-ExtIEs >-----#
    GANSS_Reference_Time_ExtIEs = CLASS(name=u'GANSS-Reference-Time-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _GANSS_Reference_Time_ExtIEs_val_Extension_0 = INT(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-Day-Cycle')))
    GANSS_Reference_Time_ExtIEs._val = ASN1Set(rv=[dict([(u'id', 122), (u'criticality', u'ignore'), (u'Extension', _GANSS_Reference_Time_ExtIEs_val_Extension_0), (u'presence', u'optional')])], rr=[], ev=[], er=[])
    
    #-----< GANSS-Day-Cycle >-----#
    GANSS_Day_Cycle = INT(name=u'GANSS-Day-Cycle', mode=MODE_TYPE)
    GANSS_Day_Cycle._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=7)], ev=None, er=[])
    
    #-----< GANSS-ReferenceTimeOnly >-----#
    GANSS_ReferenceTimeOnly = SEQ(name=u'GANSS-ReferenceTimeOnly', mode=MODE_TYPE)
    _GANSS_ReferenceTimeOnly_gANSS_tod = INT(name=u'gANSS-tod', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_ReferenceTimeOnly_gANSS_tod._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=3599999)], ev=None, er=[])
    _GANSS_ReferenceTimeOnly_gANSS_timeId = SEQ(name=u'gANSS-timeId', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSSID')), opt=True)
    _GANSS_ReferenceTimeOnly_gANSS_TimeUncertainty = INT(name=u'gANSS-TimeUncertainty', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GANSS_ReferenceTimeOnly_gANSS_TimeUncertainty._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    _GANSS_ReferenceTimeOnly_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GANSS_ReferenceTimeOnly_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GANSS_ReferenceTimeOnly_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GANSS_ReferenceTimeOnly_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_ReferenceTimeOnly_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_ReferenceTimeOnly_ie_Extensions__item__id._const_tab = ____GANSS_ReferenceTimeOnly_ie_Extensions__item__id_tab
    ___GANSS_ReferenceTimeOnly_ie_Extensions__item__id._const_tab_at = None
    ___GANSS_ReferenceTimeOnly_ie_Extensions__item__id._const_tab_id = u'id'
    ___GANSS_ReferenceTimeOnly_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GANSS_ReferenceTimeOnly_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_ReferenceTimeOnly_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_ReferenceTimeOnly_ie_Extensions__item__criticality._const_tab = ____GANSS_ReferenceTimeOnly_ie_Extensions__item__criticality_tab
    ___GANSS_ReferenceTimeOnly_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GANSS_ReferenceTimeOnly_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GANSS_ReferenceTimeOnly_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GANSS_ReferenceTimeOnly_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_ReferenceTimeOnly_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_ReferenceTimeOnly_ie_Extensions__item__extensionValue._const_tab = ____GANSS_ReferenceTimeOnly_ie_Extensions__item__extensionValue_tab
    ___GANSS_ReferenceTimeOnly_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GANSS_ReferenceTimeOnly_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GANSS_ReferenceTimeOnly_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GANSS_ReferenceTimeOnly_ie_Extensions__item__id),
        (u'criticality', ___GANSS_ReferenceTimeOnly_ie_Extensions__item__criticality),
        (u'extensionValue', ___GANSS_ReferenceTimeOnly_ie_Extensions__item__extensionValue),
        ])
    __GANSS_ReferenceTimeOnly_ie_Extensions__item_._ext = None
    _GANSS_ReferenceTimeOnly_ie_Extensions._cont = __GANSS_ReferenceTimeOnly_ie_Extensions__item_
    _GANSS_ReferenceTimeOnly_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GANSS_ReferenceTimeOnly._cont = ASN1Dict([
        (u'gANSS-tod', _GANSS_ReferenceTimeOnly_gANSS_tod),
        (u'gANSS-timeId', _GANSS_ReferenceTimeOnly_gANSS_timeId),
        (u'gANSS-TimeUncertainty', _GANSS_ReferenceTimeOnly_gANSS_TimeUncertainty),
        (u'ie-Extensions', _GANSS_ReferenceTimeOnly_ie_Extensions),
        ])
    GANSS_ReferenceTimeOnly._ext = []
    
    #-----< GANSS-ReferenceTimeOnly-ExtIEs >-----#
    GANSS_ReferenceTimeOnly_ExtIEs = CLASS(name=u'GANSS-ReferenceTimeOnly-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GANSS_ReferenceTimeOnly_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GANSS-SatelliteClockModelItem >-----#
    GANSS_SatelliteClockModelItem = SEQ(name=u'GANSS-SatelliteClockModelItem', mode=MODE_TYPE)
    _GANSS_SatelliteClockModelItem_t_oc = BIT_STR(name=u't-oc', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SatelliteClockModelItem_t_oc._const_sz = ASN1Set(rv=[14], rr=[], ev=None, er=[])
    _GANSS_SatelliteClockModelItem_a_i2 = BIT_STR(name=u'a-i2', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SatelliteClockModelItem_a_i2._const_sz = ASN1Set(rv=[6], rr=[], ev=None, er=[])
    _GANSS_SatelliteClockModelItem_a_i1 = BIT_STR(name=u'a-i1', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SatelliteClockModelItem_a_i1._const_sz = ASN1Set(rv=[21], rr=[], ev=None, er=[])
    _GANSS_SatelliteClockModelItem_a_i0 = BIT_STR(name=u'a-i0', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SatelliteClockModelItem_a_i0._const_sz = ASN1Set(rv=[31], rr=[], ev=None, er=[])
    _GANSS_SatelliteClockModelItem_t_gd = BIT_STR(name=u't-gd', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GANSS_SatelliteClockModelItem_t_gd._const_sz = ASN1Set(rv=[10], rr=[], ev=None, er=[])
    _GANSS_SatelliteClockModelItem_sisa = BIT_STR(name=u'sisa', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SatelliteClockModelItem_sisa._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _GANSS_SatelliteClockModelItem_model_id = INT(name=u'model-id', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GANSS_SatelliteClockModelItem_model_id._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=3)], ev=None, er=[])
    _GANSS_SatelliteClockModelItem_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GANSS_SatelliteClockModelItem_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GANSS_SatelliteClockModelItem_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GANSS_SatelliteClockModelItem_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_SatelliteClockModelItem_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_SatelliteClockModelItem_ie_Extensions__item__id._const_tab = ____GANSS_SatelliteClockModelItem_ie_Extensions__item__id_tab
    ___GANSS_SatelliteClockModelItem_ie_Extensions__item__id._const_tab_at = None
    ___GANSS_SatelliteClockModelItem_ie_Extensions__item__id._const_tab_id = u'id'
    ___GANSS_SatelliteClockModelItem_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GANSS_SatelliteClockModelItem_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_SatelliteClockModelItem_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_SatelliteClockModelItem_ie_Extensions__item__criticality._const_tab = ____GANSS_SatelliteClockModelItem_ie_Extensions__item__criticality_tab
    ___GANSS_SatelliteClockModelItem_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GANSS_SatelliteClockModelItem_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GANSS_SatelliteClockModelItem_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GANSS_SatelliteClockModelItem_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_SatelliteClockModelItem_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_SatelliteClockModelItem_ie_Extensions__item__extensionValue._const_tab = ____GANSS_SatelliteClockModelItem_ie_Extensions__item__extensionValue_tab
    ___GANSS_SatelliteClockModelItem_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GANSS_SatelliteClockModelItem_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GANSS_SatelliteClockModelItem_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GANSS_SatelliteClockModelItem_ie_Extensions__item__id),
        (u'criticality', ___GANSS_SatelliteClockModelItem_ie_Extensions__item__criticality),
        (u'extensionValue', ___GANSS_SatelliteClockModelItem_ie_Extensions__item__extensionValue),
        ])
    __GANSS_SatelliteClockModelItem_ie_Extensions__item_._ext = None
    _GANSS_SatelliteClockModelItem_ie_Extensions._cont = __GANSS_SatelliteClockModelItem_ie_Extensions__item_
    _GANSS_SatelliteClockModelItem_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GANSS_SatelliteClockModelItem._cont = ASN1Dict([
        (u't-oc', _GANSS_SatelliteClockModelItem_t_oc),
        (u'a-i2', _GANSS_SatelliteClockModelItem_a_i2),
        (u'a-i1', _GANSS_SatelliteClockModelItem_a_i1),
        (u'a-i0', _GANSS_SatelliteClockModelItem_a_i0),
        (u't-gd', _GANSS_SatelliteClockModelItem_t_gd),
        (u'sisa', _GANSS_SatelliteClockModelItem_sisa),
        (u'model-id', _GANSS_SatelliteClockModelItem_model_id),
        (u'ie-Extensions', _GANSS_SatelliteClockModelItem_ie_Extensions),
        ])
    GANSS_SatelliteClockModelItem._ext = []
    
    #-----< GANSS-SatelliteClockModelItem-ExtIEs >-----#
    GANSS_SatelliteClockModelItem_ExtIEs = CLASS(name=u'GANSS-SatelliteClockModelItem-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GANSS_SatelliteClockModelItem_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GANSS-SatelliteInformation >-----#
    GANSS_SatelliteInformation = SEQ_OF(name=u'GANSS-SatelliteInformation', mode=MODE_TYPE)
    _GANSS_SatelliteInformation__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-SatelliteInformationItem')))
    GANSS_SatelliteInformation._cont = _GANSS_SatelliteInformation__item_
    GANSS_SatelliteInformation._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    
    #-----< GANSS-SatelliteInformationItem >-----#
    GANSS_SatelliteInformationItem = SEQ(name=u'GANSS-SatelliteInformationItem', mode=MODE_TYPE)
    _GANSS_SatelliteInformationItem_ganssSatId = INT(name=u'ganssSatId', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SatelliteInformationItem_ganssSatId._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    _GANSS_SatelliteInformationItem_dopplerZeroOrder = INT(name=u'dopplerZeroOrder', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SatelliteInformationItem_dopplerZeroOrder._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-2048, ub=2047)], ev=None, er=[])
    _GANSS_SatelliteInformationItem_extraDoppler = SEQ(name=u'extraDoppler', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSS-ExtraDoppler')), opt=True)
    _GANSS_SatelliteInformationItem_codePhase = INT(name=u'codePhase', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SatelliteInformationItem_codePhase._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=1023)], ev=None, er=[])
    _GANSS_SatelliteInformationItem_integerCodePhase = INT(name=u'integerCodePhase', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SatelliteInformationItem_integerCodePhase._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    _GANSS_SatelliteInformationItem_codePhaseSearchWindow = INT(name=u'codePhaseSearchWindow', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SatelliteInformationItem_codePhaseSearchWindow._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=31)], ev=None, er=[])
    _GANSS_SatelliteInformationItem_azimuthAndElevation = SEQ(name=u'azimuthAndElevation', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSS-AzimuthAndElevation')), opt=True)
    _GANSS_SatelliteInformationItem_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GANSS_SatelliteInformationItem_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GANSS_SatelliteInformationItem_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GANSS_SatelliteInformationItem_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____GANSS_SatelliteInformationItem_ie_Extensions__item__id_tab_val_Extension_0 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-ExtraDopplerExtension')))
    ____GANSS_SatelliteInformationItem_ie_Extensions__item__id_tab._val = ASN1Set(rv=[dict([(u'id', 138), (u'criticality', u'ignore'), (u'Extension', _____GANSS_SatelliteInformationItem_ie_Extensions__item__id_tab_val_Extension_0), (u'presence', u'optional')])], rr=[], ev=None, er=[])
    ___GANSS_SatelliteInformationItem_ie_Extensions__item__id._const_tab = ____GANSS_SatelliteInformationItem_ie_Extensions__item__id_tab
    ___GANSS_SatelliteInformationItem_ie_Extensions__item__id._const_tab_at = None
    ___GANSS_SatelliteInformationItem_ie_Extensions__item__id._const_tab_id = u'id'
    ___GANSS_SatelliteInformationItem_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ___GANSS_SatelliteInformationItem_ie_Extensions__item__criticality._const_tab = ____GANSS_SatelliteInformationItem_ie_Extensions__item__id_tab
    ___GANSS_SatelliteInformationItem_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GANSS_SatelliteInformationItem_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GANSS_SatelliteInformationItem_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ___GANSS_SatelliteInformationItem_ie_Extensions__item__extensionValue._const_tab = ____GANSS_SatelliteInformationItem_ie_Extensions__item__id_tab
    ___GANSS_SatelliteInformationItem_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GANSS_SatelliteInformationItem_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GANSS_SatelliteInformationItem_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GANSS_SatelliteInformationItem_ie_Extensions__item__id),
        (u'criticality', ___GANSS_SatelliteInformationItem_ie_Extensions__item__criticality),
        (u'extensionValue', ___GANSS_SatelliteInformationItem_ie_Extensions__item__extensionValue),
        ])
    __GANSS_SatelliteInformationItem_ie_Extensions__item_._ext = None
    _GANSS_SatelliteInformationItem_ie_Extensions._cont = __GANSS_SatelliteInformationItem_ie_Extensions__item_
    _GANSS_SatelliteInformationItem_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GANSS_SatelliteInformationItem._cont = ASN1Dict([
        (u'ganssSatId', _GANSS_SatelliteInformationItem_ganssSatId),
        (u'dopplerZeroOrder', _GANSS_SatelliteInformationItem_dopplerZeroOrder),
        (u'extraDoppler', _GANSS_SatelliteInformationItem_extraDoppler),
        (u'codePhase', _GANSS_SatelliteInformationItem_codePhase),
        (u'integerCodePhase', _GANSS_SatelliteInformationItem_integerCodePhase),
        (u'codePhaseSearchWindow', _GANSS_SatelliteInformationItem_codePhaseSearchWindow),
        (u'azimuthAndElevation', _GANSS_SatelliteInformationItem_azimuthAndElevation),
        (u'ie-Extensions', _GANSS_SatelliteInformationItem_ie_Extensions),
        ])
    GANSS_SatelliteInformationItem._ext = []
    
    #-----< GANSS-SatelliteInformationItem-ExtIEs >-----#
    GANSS_SatelliteInformationItem_ExtIEs = CLASS(name=u'GANSS-SatelliteInformationItem-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _GANSS_SatelliteInformationItem_ExtIEs_val_Extension_0 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-ExtraDopplerExtension')))
    GANSS_SatelliteInformationItem_ExtIEs._val = ASN1Set(rv=[dict([(u'id', 138), (u'criticality', u'ignore'), (u'Extension', _GANSS_SatelliteInformationItem_ExtIEs_val_Extension_0), (u'presence', u'optional')])], rr=[], ev=[], er=[])
    
    #-----< GANSS-SatelliteInformationKP >-----#
    GANSS_SatelliteInformationKP = SEQ_OF(name=u'GANSS-SatelliteInformationKP', mode=MODE_TYPE)
    _GANSS_SatelliteInformationKP__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-SatelliteInformationKPItem')))
    GANSS_SatelliteInformationKP._cont = _GANSS_SatelliteInformationKP__item_
    GANSS_SatelliteInformationKP._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=36)], ev=None, er=[])
    
    #-----< GANSS-SatelliteInformationKPItem >-----#
    GANSS_SatelliteInformationKPItem = SEQ(name=u'GANSS-SatelliteInformationKPItem', mode=MODE_TYPE)
    _GANSS_SatelliteInformationKPItem_satId = INT(name=u'satId', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SatelliteInformationKPItem_satId._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    _GANSS_SatelliteInformationKPItem_ganss_e_alm = BIT_STR(name=u'ganss-e-alm', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SatelliteInformationKPItem_ganss_e_alm._const_sz = ASN1Set(rv=[11], rr=[], ev=None, er=[])
    _GANSS_SatelliteInformationKPItem_ganss_delta_I_alm = BIT_STR(name=u'ganss-delta-I-alm', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SatelliteInformationKPItem_ganss_delta_I_alm._const_sz = ASN1Set(rv=[11], rr=[], ev=None, er=[])
    _GANSS_SatelliteInformationKPItem_ganss_omegadot_alm = BIT_STR(name=u'ganss-omegadot-alm', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SatelliteInformationKPItem_ganss_omegadot_alm._const_sz = ASN1Set(rv=[11], rr=[], ev=None, er=[])
    _GANSS_SatelliteInformationKPItem_ganss_svStatusINAV_alm = BIT_STR(name=u'ganss-svStatusINAV-alm', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SatelliteInformationKPItem_ganss_svStatusINAV_alm._const_sz = ASN1Set(rv=[4], rr=[], ev=None, er=[])
    _GANSS_SatelliteInformationKPItem_ganss_svStatusFNAV_alm = BIT_STR(name=u'ganss-svStatusFNAV-alm', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GANSS_SatelliteInformationKPItem_ganss_svStatusFNAV_alm._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    _GANSS_SatelliteInformationKPItem_ganss_delta_a_sqrt_alm = BIT_STR(name=u'ganss-delta-a-sqrt-alm', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SatelliteInformationKPItem_ganss_delta_a_sqrt_alm._const_sz = ASN1Set(rv=[13], rr=[], ev=None, er=[])
    _GANSS_SatelliteInformationKPItem_ganss_omegazero_alm = BIT_STR(name=u'ganss-omegazero-alm', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SatelliteInformationKPItem_ganss_omegazero_alm._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _GANSS_SatelliteInformationKPItem_ganss_m_zero_alm = BIT_STR(name=u'ganss-m-zero-alm', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SatelliteInformationKPItem_ganss_m_zero_alm._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _GANSS_SatelliteInformationKPItem_ganss_omega_alm = BIT_STR(name=u'ganss-omega-alm', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SatelliteInformationKPItem_ganss_omega_alm._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _GANSS_SatelliteInformationKPItem_ganss_af_zero_alm = BIT_STR(name=u'ganss-af-zero-alm', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SatelliteInformationKPItem_ganss_af_zero_alm._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _GANSS_SatelliteInformationKPItem_ganss_af_one_alm = BIT_STR(name=u'ganss-af-one-alm', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SatelliteInformationKPItem_ganss_af_one_alm._const_sz = ASN1Set(rv=[13], rr=[], ev=None, er=[])
    _GANSS_SatelliteInformationKPItem_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GANSS_SatelliteInformationKPItem_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GANSS_SatelliteInformationKPItem_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GANSS_SatelliteInformationKPItem_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_SatelliteInformationKPItem_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_SatelliteInformationKPItem_ie_Extensions__item__id._const_tab = ____GANSS_SatelliteInformationKPItem_ie_Extensions__item__id_tab
    ___GANSS_SatelliteInformationKPItem_ie_Extensions__item__id._const_tab_at = None
    ___GANSS_SatelliteInformationKPItem_ie_Extensions__item__id._const_tab_id = u'id'
    ___GANSS_SatelliteInformationKPItem_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GANSS_SatelliteInformationKPItem_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_SatelliteInformationKPItem_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_SatelliteInformationKPItem_ie_Extensions__item__criticality._const_tab = ____GANSS_SatelliteInformationKPItem_ie_Extensions__item__criticality_tab
    ___GANSS_SatelliteInformationKPItem_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GANSS_SatelliteInformationKPItem_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GANSS_SatelliteInformationKPItem_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GANSS_SatelliteInformationKPItem_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_SatelliteInformationKPItem_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_SatelliteInformationKPItem_ie_Extensions__item__extensionValue._const_tab = ____GANSS_SatelliteInformationKPItem_ie_Extensions__item__extensionValue_tab
    ___GANSS_SatelliteInformationKPItem_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GANSS_SatelliteInformationKPItem_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GANSS_SatelliteInformationKPItem_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GANSS_SatelliteInformationKPItem_ie_Extensions__item__id),
        (u'criticality', ___GANSS_SatelliteInformationKPItem_ie_Extensions__item__criticality),
        (u'extensionValue', ___GANSS_SatelliteInformationKPItem_ie_Extensions__item__extensionValue),
        ])
    __GANSS_SatelliteInformationKPItem_ie_Extensions__item_._ext = None
    _GANSS_SatelliteInformationKPItem_ie_Extensions._cont = __GANSS_SatelliteInformationKPItem_ie_Extensions__item_
    _GANSS_SatelliteInformationKPItem_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GANSS_SatelliteInformationKPItem._cont = ASN1Dict([
        (u'satId', _GANSS_SatelliteInformationKPItem_satId),
        (u'ganss-e-alm', _GANSS_SatelliteInformationKPItem_ganss_e_alm),
        (u'ganss-delta-I-alm', _GANSS_SatelliteInformationKPItem_ganss_delta_I_alm),
        (u'ganss-omegadot-alm', _GANSS_SatelliteInformationKPItem_ganss_omegadot_alm),
        (u'ganss-svStatusINAV-alm', _GANSS_SatelliteInformationKPItem_ganss_svStatusINAV_alm),
        (u'ganss-svStatusFNAV-alm', _GANSS_SatelliteInformationKPItem_ganss_svStatusFNAV_alm),
        (u'ganss-delta-a-sqrt-alm', _GANSS_SatelliteInformationKPItem_ganss_delta_a_sqrt_alm),
        (u'ganss-omegazero-alm', _GANSS_SatelliteInformationKPItem_ganss_omegazero_alm),
        (u'ganss-m-zero-alm', _GANSS_SatelliteInformationKPItem_ganss_m_zero_alm),
        (u'ganss-omega-alm', _GANSS_SatelliteInformationKPItem_ganss_omega_alm),
        (u'ganss-af-zero-alm', _GANSS_SatelliteInformationKPItem_ganss_af_zero_alm),
        (u'ganss-af-one-alm', _GANSS_SatelliteInformationKPItem_ganss_af_one_alm),
        (u'ie-Extensions', _GANSS_SatelliteInformationKPItem_ie_Extensions),
        ])
    GANSS_SatelliteInformationKPItem._ext = []
    
    #-----< GANSS-SatelliteInformationKPItem-ExtIEs >-----#
    GANSS_SatelliteInformationKPItem_ExtIEs = CLASS(name=u'GANSS-SatelliteInformationKPItem-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GANSS_SatelliteInformationKPItem_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GANSS-SAT-Info-Almanac-GLOkpList >-----#
    GANSS_SAT_Info_Almanac_GLOkpList = SEQ_OF(name=u'GANSS-SAT-Info-Almanac-GLOkpList', mode=MODE_TYPE)
    _GANSS_SAT_Info_Almanac_GLOkpList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-SAT-Info-Almanac-GLOkp')))
    GANSS_SAT_Info_Almanac_GLOkpList._cont = _GANSS_SAT_Info_Almanac_GLOkpList__item_
    GANSS_SAT_Info_Almanac_GLOkpList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=36)], ev=None, er=[])
    
    #-----< GANSS-SAT-Info-Almanac-GLOkp >-----#
    GANSS_SAT_Info_Almanac_GLOkp = SEQ(name=u'GANSS-SAT-Info-Almanac-GLOkp', mode=MODE_TYPE)
    _GANSS_SAT_Info_Almanac_GLOkp_gloAlmNA = BIT_STR(name=u'gloAlmNA', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_GLOkp_gloAlmNA._const_sz = ASN1Set(rv=[11], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_GLOkp_gloAlmnA = BIT_STR(name=u'gloAlmnA', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_GLOkp_gloAlmnA._const_sz = ASN1Set(rv=[5], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_GLOkp_gloAlmHA = BIT_STR(name=u'gloAlmHA', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_GLOkp_gloAlmHA._const_sz = ASN1Set(rv=[5], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_GLOkp_gloAlmLambdaA = BIT_STR(name=u'gloAlmLambdaA', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_GLOkp_gloAlmLambdaA._const_sz = ASN1Set(rv=[21], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_GLOkp_gloAlmTlambdaA = BIT_STR(name=u'gloAlmTlambdaA', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_GLOkp_gloAlmTlambdaA._const_sz = ASN1Set(rv=[21], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_GLOkp_gloAlmDeltaIA = BIT_STR(name=u'gloAlmDeltaIA', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_GLOkp_gloAlmDeltaIA._const_sz = ASN1Set(rv=[18], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_GLOkp_gloAkmDeltaTA = BIT_STR(name=u'gloAkmDeltaTA', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_GLOkp_gloAkmDeltaTA._const_sz = ASN1Set(rv=[22], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_GLOkp_gloAlmDeltaTdotA = BIT_STR(name=u'gloAlmDeltaTdotA', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_GLOkp_gloAlmDeltaTdotA._const_sz = ASN1Set(rv=[7], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_GLOkp_gloAlmEpsilonA = BIT_STR(name=u'gloAlmEpsilonA', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_GLOkp_gloAlmEpsilonA._const_sz = ASN1Set(rv=[15], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_GLOkp_gloAlmOmegaA = BIT_STR(name=u'gloAlmOmegaA', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_GLOkp_gloAlmOmegaA._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_GLOkp_gloAlmTauA = BIT_STR(name=u'gloAlmTauA', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_GLOkp_gloAlmTauA._const_sz = ASN1Set(rv=[10], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_GLOkp_gloAlmCA = BIT_STR(name=u'gloAlmCA', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_GLOkp_gloAlmCA._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_GLOkp_gloAlmMA = BIT_STR(name=u'gloAlmMA', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GANSS_SAT_Info_Almanac_GLOkp_gloAlmMA._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_GLOkp_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GANSS_SAT_Info_Almanac_GLOkp_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GANSS_SAT_Info_Almanac_GLOkp_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GANSS_SAT_Info_Almanac_GLOkp_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_SAT_Info_Almanac_GLOkp_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_SAT_Info_Almanac_GLOkp_ie_Extensions__item__id._const_tab = ____GANSS_SAT_Info_Almanac_GLOkp_ie_Extensions__item__id_tab
    ___GANSS_SAT_Info_Almanac_GLOkp_ie_Extensions__item__id._const_tab_at = None
    ___GANSS_SAT_Info_Almanac_GLOkp_ie_Extensions__item__id._const_tab_id = u'id'
    ___GANSS_SAT_Info_Almanac_GLOkp_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GANSS_SAT_Info_Almanac_GLOkp_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_SAT_Info_Almanac_GLOkp_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_SAT_Info_Almanac_GLOkp_ie_Extensions__item__criticality._const_tab = ____GANSS_SAT_Info_Almanac_GLOkp_ie_Extensions__item__criticality_tab
    ___GANSS_SAT_Info_Almanac_GLOkp_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GANSS_SAT_Info_Almanac_GLOkp_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GANSS_SAT_Info_Almanac_GLOkp_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GANSS_SAT_Info_Almanac_GLOkp_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_SAT_Info_Almanac_GLOkp_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_SAT_Info_Almanac_GLOkp_ie_Extensions__item__extensionValue._const_tab = ____GANSS_SAT_Info_Almanac_GLOkp_ie_Extensions__item__extensionValue_tab
    ___GANSS_SAT_Info_Almanac_GLOkp_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GANSS_SAT_Info_Almanac_GLOkp_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GANSS_SAT_Info_Almanac_GLOkp_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GANSS_SAT_Info_Almanac_GLOkp_ie_Extensions__item__id),
        (u'criticality', ___GANSS_SAT_Info_Almanac_GLOkp_ie_Extensions__item__criticality),
        (u'extensionValue', ___GANSS_SAT_Info_Almanac_GLOkp_ie_Extensions__item__extensionValue),
        ])
    __GANSS_SAT_Info_Almanac_GLOkp_ie_Extensions__item_._ext = None
    _GANSS_SAT_Info_Almanac_GLOkp_ie_Extensions._cont = __GANSS_SAT_Info_Almanac_GLOkp_ie_Extensions__item_
    _GANSS_SAT_Info_Almanac_GLOkp_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GANSS_SAT_Info_Almanac_GLOkp._cont = ASN1Dict([
        (u'gloAlmNA', _GANSS_SAT_Info_Almanac_GLOkp_gloAlmNA),
        (u'gloAlmnA', _GANSS_SAT_Info_Almanac_GLOkp_gloAlmnA),
        (u'gloAlmHA', _GANSS_SAT_Info_Almanac_GLOkp_gloAlmHA),
        (u'gloAlmLambdaA', _GANSS_SAT_Info_Almanac_GLOkp_gloAlmLambdaA),
        (u'gloAlmTlambdaA', _GANSS_SAT_Info_Almanac_GLOkp_gloAlmTlambdaA),
        (u'gloAlmDeltaIA', _GANSS_SAT_Info_Almanac_GLOkp_gloAlmDeltaIA),
        (u'gloAkmDeltaTA', _GANSS_SAT_Info_Almanac_GLOkp_gloAkmDeltaTA),
        (u'gloAlmDeltaTdotA', _GANSS_SAT_Info_Almanac_GLOkp_gloAlmDeltaTdotA),
        (u'gloAlmEpsilonA', _GANSS_SAT_Info_Almanac_GLOkp_gloAlmEpsilonA),
        (u'gloAlmOmegaA', _GANSS_SAT_Info_Almanac_GLOkp_gloAlmOmegaA),
        (u'gloAlmTauA', _GANSS_SAT_Info_Almanac_GLOkp_gloAlmTauA),
        (u'gloAlmCA', _GANSS_SAT_Info_Almanac_GLOkp_gloAlmCA),
        (u'gloAlmMA', _GANSS_SAT_Info_Almanac_GLOkp_gloAlmMA),
        (u'ie-Extensions', _GANSS_SAT_Info_Almanac_GLOkp_ie_Extensions),
        ])
    GANSS_SAT_Info_Almanac_GLOkp._ext = []
    
    #-----< GANSS-SAT-Info-Almanac-GLOkp-ExtIEs >-----#
    GANSS_SAT_Info_Almanac_GLOkp_ExtIEs = CLASS(name=u'GANSS-SAT-Info-Almanac-GLOkp-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GANSS_SAT_Info_Almanac_GLOkp_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GANSS-SAT-Info-Almanac-MIDIkpList >-----#
    GANSS_SAT_Info_Almanac_MIDIkpList = SEQ_OF(name=u'GANSS-SAT-Info-Almanac-MIDIkpList', mode=MODE_TYPE)
    _GANSS_SAT_Info_Almanac_MIDIkpList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-SAT-Info-Almanac-MIDIkp')))
    GANSS_SAT_Info_Almanac_MIDIkpList._cont = _GANSS_SAT_Info_Almanac_MIDIkpList__item_
    GANSS_SAT_Info_Almanac_MIDIkpList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=36)], ev=None, er=[])
    
    #-----< GANSS-SAT-Info-Almanac-MIDIkp >-----#
    GANSS_SAT_Info_Almanac_MIDIkp = SEQ(name=u'GANSS-SAT-Info-Almanac-MIDIkp', mode=MODE_TYPE)
    _GANSS_SAT_Info_Almanac_MIDIkp_svID = INT(name=u'svID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_MIDIkp_svID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_MIDIkp_midiAlmE = BIT_STR(name=u'midiAlmE', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_MIDIkp_midiAlmE._const_sz = ASN1Set(rv=[11], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_MIDIkp_midiAlmDeltaI = BIT_STR(name=u'midiAlmDeltaI', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_MIDIkp_midiAlmDeltaI._const_sz = ASN1Set(rv=[11], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_MIDIkp_midiAlmOmegaDot = BIT_STR(name=u'midiAlmOmegaDot', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_MIDIkp_midiAlmOmegaDot._const_sz = ASN1Set(rv=[11], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_MIDIkp_midiAlmSqrtA = BIT_STR(name=u'midiAlmSqrtA', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_MIDIkp_midiAlmSqrtA._const_sz = ASN1Set(rv=[17], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_MIDIkp_midiAlmOmega0 = BIT_STR(name=u'midiAlmOmega0', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_MIDIkp_midiAlmOmega0._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_MIDIkp_midiAlmOmega = BIT_STR(name=u'midiAlmOmega', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_MIDIkp_midiAlmOmega._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_MIDIkp_midiAlmMo = BIT_STR(name=u'midiAlmMo', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_MIDIkp_midiAlmMo._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_MIDIkp_midiAlmaf0 = BIT_STR(name=u'midiAlmaf0', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_MIDIkp_midiAlmaf0._const_sz = ASN1Set(rv=[11], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_MIDIkp_midiAlmaf1 = BIT_STR(name=u'midiAlmaf1', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_MIDIkp_midiAlmaf1._const_sz = ASN1Set(rv=[10], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_MIDIkp_midiAlmL1Health = BIT_STR(name=u'midiAlmL1Health', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_MIDIkp_midiAlmL1Health._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_MIDIkp_midiAlmL2Health = BIT_STR(name=u'midiAlmL2Health', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_MIDIkp_midiAlmL2Health._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_MIDIkp_midiAlmL5Health = BIT_STR(name=u'midiAlmL5Health', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_MIDIkp_midiAlmL5Health._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_MIDIkp_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GANSS_SAT_Info_Almanac_MIDIkp_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GANSS_SAT_Info_Almanac_MIDIkp_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GANSS_SAT_Info_Almanac_MIDIkp_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_SAT_Info_Almanac_MIDIkp_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_SAT_Info_Almanac_MIDIkp_ie_Extensions__item__id._const_tab = ____GANSS_SAT_Info_Almanac_MIDIkp_ie_Extensions__item__id_tab
    ___GANSS_SAT_Info_Almanac_MIDIkp_ie_Extensions__item__id._const_tab_at = None
    ___GANSS_SAT_Info_Almanac_MIDIkp_ie_Extensions__item__id._const_tab_id = u'id'
    ___GANSS_SAT_Info_Almanac_MIDIkp_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GANSS_SAT_Info_Almanac_MIDIkp_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_SAT_Info_Almanac_MIDIkp_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_SAT_Info_Almanac_MIDIkp_ie_Extensions__item__criticality._const_tab = ____GANSS_SAT_Info_Almanac_MIDIkp_ie_Extensions__item__criticality_tab
    ___GANSS_SAT_Info_Almanac_MIDIkp_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GANSS_SAT_Info_Almanac_MIDIkp_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GANSS_SAT_Info_Almanac_MIDIkp_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GANSS_SAT_Info_Almanac_MIDIkp_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_SAT_Info_Almanac_MIDIkp_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_SAT_Info_Almanac_MIDIkp_ie_Extensions__item__extensionValue._const_tab = ____GANSS_SAT_Info_Almanac_MIDIkp_ie_Extensions__item__extensionValue_tab
    ___GANSS_SAT_Info_Almanac_MIDIkp_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GANSS_SAT_Info_Almanac_MIDIkp_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GANSS_SAT_Info_Almanac_MIDIkp_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GANSS_SAT_Info_Almanac_MIDIkp_ie_Extensions__item__id),
        (u'criticality', ___GANSS_SAT_Info_Almanac_MIDIkp_ie_Extensions__item__criticality),
        (u'extensionValue', ___GANSS_SAT_Info_Almanac_MIDIkp_ie_Extensions__item__extensionValue),
        ])
    __GANSS_SAT_Info_Almanac_MIDIkp_ie_Extensions__item_._ext = None
    _GANSS_SAT_Info_Almanac_MIDIkp_ie_Extensions._cont = __GANSS_SAT_Info_Almanac_MIDIkp_ie_Extensions__item_
    _GANSS_SAT_Info_Almanac_MIDIkp_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GANSS_SAT_Info_Almanac_MIDIkp._cont = ASN1Dict([
        (u'svID', _GANSS_SAT_Info_Almanac_MIDIkp_svID),
        (u'midiAlmE', _GANSS_SAT_Info_Almanac_MIDIkp_midiAlmE),
        (u'midiAlmDeltaI', _GANSS_SAT_Info_Almanac_MIDIkp_midiAlmDeltaI),
        (u'midiAlmOmegaDot', _GANSS_SAT_Info_Almanac_MIDIkp_midiAlmOmegaDot),
        (u'midiAlmSqrtA', _GANSS_SAT_Info_Almanac_MIDIkp_midiAlmSqrtA),
        (u'midiAlmOmega0', _GANSS_SAT_Info_Almanac_MIDIkp_midiAlmOmega0),
        (u'midiAlmOmega', _GANSS_SAT_Info_Almanac_MIDIkp_midiAlmOmega),
        (u'midiAlmMo', _GANSS_SAT_Info_Almanac_MIDIkp_midiAlmMo),
        (u'midiAlmaf0', _GANSS_SAT_Info_Almanac_MIDIkp_midiAlmaf0),
        (u'midiAlmaf1', _GANSS_SAT_Info_Almanac_MIDIkp_midiAlmaf1),
        (u'midiAlmL1Health', _GANSS_SAT_Info_Almanac_MIDIkp_midiAlmL1Health),
        (u'midiAlmL2Health', _GANSS_SAT_Info_Almanac_MIDIkp_midiAlmL2Health),
        (u'midiAlmL5Health', _GANSS_SAT_Info_Almanac_MIDIkp_midiAlmL5Health),
        (u'ie-Extensions', _GANSS_SAT_Info_Almanac_MIDIkp_ie_Extensions),
        ])
    GANSS_SAT_Info_Almanac_MIDIkp._ext = []
    
    #-----< GANSS-SAT-Info-Almanac-MIDIkp-ExtIEs >-----#
    GANSS_SAT_Info_Almanac_MIDIkp_ExtIEs = CLASS(name=u'GANSS-SAT-Info-Almanac-MIDIkp-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GANSS_SAT_Info_Almanac_MIDIkp_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GANSS-SAT-Info-Almanac-NAVkpList >-----#
    GANSS_SAT_Info_Almanac_NAVkpList = SEQ_OF(name=u'GANSS-SAT-Info-Almanac-NAVkpList', mode=MODE_TYPE)
    _GANSS_SAT_Info_Almanac_NAVkpList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-SAT-Info-Almanac-NAVkp')))
    GANSS_SAT_Info_Almanac_NAVkpList._cont = _GANSS_SAT_Info_Almanac_NAVkpList__item_
    GANSS_SAT_Info_Almanac_NAVkpList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=36)], ev=None, er=[])
    
    #-----< GANSS-SAT-Info-Almanac-NAVkp >-----#
    GANSS_SAT_Info_Almanac_NAVkp = SEQ(name=u'GANSS-SAT-Info-Almanac-NAVkp', mode=MODE_TYPE)
    _GANSS_SAT_Info_Almanac_NAVkp_svID = INT(name=u'svID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_NAVkp_svID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_NAVkp_navAlmE = BIT_STR(name=u'navAlmE', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_NAVkp_navAlmE._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_NAVkp_navAlmDeltaI = BIT_STR(name=u'navAlmDeltaI', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_NAVkp_navAlmDeltaI._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_NAVkp_navAlmOMEGADOT = BIT_STR(name=u'navAlmOMEGADOT', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_NAVkp_navAlmOMEGADOT._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_NAVkp_navAlmSVHealth = BIT_STR(name=u'navAlmSVHealth', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_NAVkp_navAlmSVHealth._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_NAVkp_navAlmSqrtA = BIT_STR(name=u'navAlmSqrtA', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_NAVkp_navAlmSqrtA._const_sz = ASN1Set(rv=[24], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_NAVkp_navAlmOMEGAo = BIT_STR(name=u'navAlmOMEGAo', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_NAVkp_navAlmOMEGAo._const_sz = ASN1Set(rv=[24], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_NAVkp_navAlmOmega = BIT_STR(name=u'navAlmOmega', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_NAVkp_navAlmOmega._const_sz = ASN1Set(rv=[24], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_NAVkp_navAlmMo = BIT_STR(name=u'navAlmMo', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_NAVkp_navAlmMo._const_sz = ASN1Set(rv=[24], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_NAVkp_navAlmaf0 = BIT_STR(name=u'navAlmaf0', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_NAVkp_navAlmaf0._const_sz = ASN1Set(rv=[11], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_NAVkp_navAlmaf1 = BIT_STR(name=u'navAlmaf1', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_NAVkp_navAlmaf1._const_sz = ASN1Set(rv=[11], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_NAVkp_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GANSS_SAT_Info_Almanac_NAVkp_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GANSS_SAT_Info_Almanac_NAVkp_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GANSS_SAT_Info_Almanac_NAVkp_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_SAT_Info_Almanac_NAVkp_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_SAT_Info_Almanac_NAVkp_ie_Extensions__item__id._const_tab = ____GANSS_SAT_Info_Almanac_NAVkp_ie_Extensions__item__id_tab
    ___GANSS_SAT_Info_Almanac_NAVkp_ie_Extensions__item__id._const_tab_at = None
    ___GANSS_SAT_Info_Almanac_NAVkp_ie_Extensions__item__id._const_tab_id = u'id'
    ___GANSS_SAT_Info_Almanac_NAVkp_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GANSS_SAT_Info_Almanac_NAVkp_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_SAT_Info_Almanac_NAVkp_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_SAT_Info_Almanac_NAVkp_ie_Extensions__item__criticality._const_tab = ____GANSS_SAT_Info_Almanac_NAVkp_ie_Extensions__item__criticality_tab
    ___GANSS_SAT_Info_Almanac_NAVkp_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GANSS_SAT_Info_Almanac_NAVkp_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GANSS_SAT_Info_Almanac_NAVkp_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GANSS_SAT_Info_Almanac_NAVkp_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_SAT_Info_Almanac_NAVkp_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_SAT_Info_Almanac_NAVkp_ie_Extensions__item__extensionValue._const_tab = ____GANSS_SAT_Info_Almanac_NAVkp_ie_Extensions__item__extensionValue_tab
    ___GANSS_SAT_Info_Almanac_NAVkp_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GANSS_SAT_Info_Almanac_NAVkp_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GANSS_SAT_Info_Almanac_NAVkp_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GANSS_SAT_Info_Almanac_NAVkp_ie_Extensions__item__id),
        (u'criticality', ___GANSS_SAT_Info_Almanac_NAVkp_ie_Extensions__item__criticality),
        (u'extensionValue', ___GANSS_SAT_Info_Almanac_NAVkp_ie_Extensions__item__extensionValue),
        ])
    __GANSS_SAT_Info_Almanac_NAVkp_ie_Extensions__item_._ext = None
    _GANSS_SAT_Info_Almanac_NAVkp_ie_Extensions._cont = __GANSS_SAT_Info_Almanac_NAVkp_ie_Extensions__item_
    _GANSS_SAT_Info_Almanac_NAVkp_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GANSS_SAT_Info_Almanac_NAVkp._cont = ASN1Dict([
        (u'svID', _GANSS_SAT_Info_Almanac_NAVkp_svID),
        (u'navAlmE', _GANSS_SAT_Info_Almanac_NAVkp_navAlmE),
        (u'navAlmDeltaI', _GANSS_SAT_Info_Almanac_NAVkp_navAlmDeltaI),
        (u'navAlmOMEGADOT', _GANSS_SAT_Info_Almanac_NAVkp_navAlmOMEGADOT),
        (u'navAlmSVHealth', _GANSS_SAT_Info_Almanac_NAVkp_navAlmSVHealth),
        (u'navAlmSqrtA', _GANSS_SAT_Info_Almanac_NAVkp_navAlmSqrtA),
        (u'navAlmOMEGAo', _GANSS_SAT_Info_Almanac_NAVkp_navAlmOMEGAo),
        (u'navAlmOmega', _GANSS_SAT_Info_Almanac_NAVkp_navAlmOmega),
        (u'navAlmMo', _GANSS_SAT_Info_Almanac_NAVkp_navAlmMo),
        (u'navAlmaf0', _GANSS_SAT_Info_Almanac_NAVkp_navAlmaf0),
        (u'navAlmaf1', _GANSS_SAT_Info_Almanac_NAVkp_navAlmaf1),
        (u'ie-Extensions', _GANSS_SAT_Info_Almanac_NAVkp_ie_Extensions),
        ])
    GANSS_SAT_Info_Almanac_NAVkp._ext = []
    
    #-----< GANSS-SAT-Info-Almanac-NAVkp-ExtIEs >-----#
    GANSS_SAT_Info_Almanac_NAVkp_ExtIEs = CLASS(name=u'GANSS-SAT-Info-Almanac-NAVkp-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GANSS_SAT_Info_Almanac_NAVkp_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GANSS-SAT-Info-Almanac-REDkpList >-----#
    GANSS_SAT_Info_Almanac_REDkpList = SEQ_OF(name=u'GANSS-SAT-Info-Almanac-REDkpList', mode=MODE_TYPE)
    _GANSS_SAT_Info_Almanac_REDkpList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-SAT-Info-Almanac-REDkp')))
    GANSS_SAT_Info_Almanac_REDkpList._cont = _GANSS_SAT_Info_Almanac_REDkpList__item_
    GANSS_SAT_Info_Almanac_REDkpList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=36)], ev=None, er=[])
    
    #-----< GANSS-SAT-Info-Almanac-REDkp >-----#
    GANSS_SAT_Info_Almanac_REDkp = SEQ(name=u'GANSS-SAT-Info-Almanac-REDkp', mode=MODE_TYPE)
    _GANSS_SAT_Info_Almanac_REDkp_svID = INT(name=u'svID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_REDkp_svID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_REDkp_redAlmDeltaA = BIT_STR(name=u'redAlmDeltaA', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_REDkp_redAlmDeltaA._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_REDkp_redAlmOmega0 = BIT_STR(name=u'redAlmOmega0', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_REDkp_redAlmOmega0._const_sz = ASN1Set(rv=[7], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_REDkp_redAlmPhi0 = BIT_STR(name=u'redAlmPhi0', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_REDkp_redAlmPhi0._const_sz = ASN1Set(rv=[7], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_REDkp_redAlmL1Health = BIT_STR(name=u'redAlmL1Health', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_REDkp_redAlmL1Health._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_REDkp_redAlmL2Health = BIT_STR(name=u'redAlmL2Health', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_REDkp_redAlmL2Health._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_REDkp_redAlmL5Health = BIT_STR(name=u'redAlmL5Health', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_REDkp_redAlmL5Health._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_REDkp_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GANSS_SAT_Info_Almanac_REDkp_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GANSS_SAT_Info_Almanac_REDkp_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GANSS_SAT_Info_Almanac_REDkp_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_SAT_Info_Almanac_REDkp_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_SAT_Info_Almanac_REDkp_ie_Extensions__item__id._const_tab = ____GANSS_SAT_Info_Almanac_REDkp_ie_Extensions__item__id_tab
    ___GANSS_SAT_Info_Almanac_REDkp_ie_Extensions__item__id._const_tab_at = None
    ___GANSS_SAT_Info_Almanac_REDkp_ie_Extensions__item__id._const_tab_id = u'id'
    ___GANSS_SAT_Info_Almanac_REDkp_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GANSS_SAT_Info_Almanac_REDkp_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_SAT_Info_Almanac_REDkp_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_SAT_Info_Almanac_REDkp_ie_Extensions__item__criticality._const_tab = ____GANSS_SAT_Info_Almanac_REDkp_ie_Extensions__item__criticality_tab
    ___GANSS_SAT_Info_Almanac_REDkp_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GANSS_SAT_Info_Almanac_REDkp_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GANSS_SAT_Info_Almanac_REDkp_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GANSS_SAT_Info_Almanac_REDkp_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_SAT_Info_Almanac_REDkp_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_SAT_Info_Almanac_REDkp_ie_Extensions__item__extensionValue._const_tab = ____GANSS_SAT_Info_Almanac_REDkp_ie_Extensions__item__extensionValue_tab
    ___GANSS_SAT_Info_Almanac_REDkp_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GANSS_SAT_Info_Almanac_REDkp_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GANSS_SAT_Info_Almanac_REDkp_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GANSS_SAT_Info_Almanac_REDkp_ie_Extensions__item__id),
        (u'criticality', ___GANSS_SAT_Info_Almanac_REDkp_ie_Extensions__item__criticality),
        (u'extensionValue', ___GANSS_SAT_Info_Almanac_REDkp_ie_Extensions__item__extensionValue),
        ])
    __GANSS_SAT_Info_Almanac_REDkp_ie_Extensions__item_._ext = None
    _GANSS_SAT_Info_Almanac_REDkp_ie_Extensions._cont = __GANSS_SAT_Info_Almanac_REDkp_ie_Extensions__item_
    _GANSS_SAT_Info_Almanac_REDkp_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GANSS_SAT_Info_Almanac_REDkp._cont = ASN1Dict([
        (u'svID', _GANSS_SAT_Info_Almanac_REDkp_svID),
        (u'redAlmDeltaA', _GANSS_SAT_Info_Almanac_REDkp_redAlmDeltaA),
        (u'redAlmOmega0', _GANSS_SAT_Info_Almanac_REDkp_redAlmOmega0),
        (u'redAlmPhi0', _GANSS_SAT_Info_Almanac_REDkp_redAlmPhi0),
        (u'redAlmL1Health', _GANSS_SAT_Info_Almanac_REDkp_redAlmL1Health),
        (u'redAlmL2Health', _GANSS_SAT_Info_Almanac_REDkp_redAlmL2Health),
        (u'redAlmL5Health', _GANSS_SAT_Info_Almanac_REDkp_redAlmL5Health),
        (u'ie-Extensions', _GANSS_SAT_Info_Almanac_REDkp_ie_Extensions),
        ])
    GANSS_SAT_Info_Almanac_REDkp._ext = []
    
    #-----< GANSS-SAT-Info-Almanac-REDkp-ExtIEs >-----#
    GANSS_SAT_Info_Almanac_REDkp_ExtIEs = CLASS(name=u'GANSS-SAT-Info-Almanac-REDkp-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GANSS_SAT_Info_Almanac_REDkp_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GANSS-SAT-Info-Almanac-SBASecefList >-----#
    GANSS_SAT_Info_Almanac_SBASecefList = SEQ_OF(name=u'GANSS-SAT-Info-Almanac-SBASecefList', mode=MODE_TYPE)
    _GANSS_SAT_Info_Almanac_SBASecefList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-SAT-Info-Almanac-SBASecef')))
    GANSS_SAT_Info_Almanac_SBASecefList._cont = _GANSS_SAT_Info_Almanac_SBASecefList__item_
    GANSS_SAT_Info_Almanac_SBASecefList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=36)], ev=None, er=[])
    
    #-----< GANSS-SAT-Info-Almanac-SBASecef >-----#
    GANSS_SAT_Info_Almanac_SBASecef = SEQ(name=u'GANSS-SAT-Info-Almanac-SBASecef', mode=MODE_TYPE)
    _GANSS_SAT_Info_Almanac_SBASecef_sbasAlmDataID = BIT_STR(name=u'sbasAlmDataID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_SBASecef_sbasAlmDataID._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_SBASecef_svID = INT(name=u'svID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_SBASecef_svID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_SBASecef_sbasAlmHealth = BIT_STR(name=u'sbasAlmHealth', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_SBASecef_sbasAlmHealth._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_SBASecef_sbasAlmXg = BIT_STR(name=u'sbasAlmXg', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_SBASecef_sbasAlmXg._const_sz = ASN1Set(rv=[15], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_SBASecef_sbasAlmYg = BIT_STR(name=u'sbasAlmYg', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_SBASecef_sbasAlmYg._const_sz = ASN1Set(rv=[15], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_SBASecef_sbasAlmZg = BIT_STR(name=u'sbasAlmZg', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_SBASecef_sbasAlmZg._const_sz = ASN1Set(rv=[9], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_SBASecef_sbasAlmXgdot = BIT_STR(name=u'sbasAlmXgdot', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_SBASecef_sbasAlmXgdot._const_sz = ASN1Set(rv=[3], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_SBASecef_sbasAlmYgDot = BIT_STR(name=u'sbasAlmYgDot', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_SBASecef_sbasAlmYgDot._const_sz = ASN1Set(rv=[3], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_SBASecef_sbasAlmZgDot = BIT_STR(name=u'sbasAlmZgDot', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_SBASecef_sbasAlmZgDot._const_sz = ASN1Set(rv=[4], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_SBASecef_sbasAlmTo = BIT_STR(name=u'sbasAlmTo', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SAT_Info_Almanac_SBASecef_sbasAlmTo._const_sz = ASN1Set(rv=[11], rr=[], ev=None, er=[])
    _GANSS_SAT_Info_Almanac_SBASecef_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GANSS_SAT_Info_Almanac_SBASecef_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GANSS_SAT_Info_Almanac_SBASecef_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GANSS_SAT_Info_Almanac_SBASecef_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_SAT_Info_Almanac_SBASecef_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_SAT_Info_Almanac_SBASecef_ie_Extensions__item__id._const_tab = ____GANSS_SAT_Info_Almanac_SBASecef_ie_Extensions__item__id_tab
    ___GANSS_SAT_Info_Almanac_SBASecef_ie_Extensions__item__id._const_tab_at = None
    ___GANSS_SAT_Info_Almanac_SBASecef_ie_Extensions__item__id._const_tab_id = u'id'
    ___GANSS_SAT_Info_Almanac_SBASecef_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GANSS_SAT_Info_Almanac_SBASecef_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_SAT_Info_Almanac_SBASecef_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_SAT_Info_Almanac_SBASecef_ie_Extensions__item__criticality._const_tab = ____GANSS_SAT_Info_Almanac_SBASecef_ie_Extensions__item__criticality_tab
    ___GANSS_SAT_Info_Almanac_SBASecef_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GANSS_SAT_Info_Almanac_SBASecef_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GANSS_SAT_Info_Almanac_SBASecef_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GANSS_SAT_Info_Almanac_SBASecef_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_SAT_Info_Almanac_SBASecef_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_SAT_Info_Almanac_SBASecef_ie_Extensions__item__extensionValue._const_tab = ____GANSS_SAT_Info_Almanac_SBASecef_ie_Extensions__item__extensionValue_tab
    ___GANSS_SAT_Info_Almanac_SBASecef_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GANSS_SAT_Info_Almanac_SBASecef_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GANSS_SAT_Info_Almanac_SBASecef_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GANSS_SAT_Info_Almanac_SBASecef_ie_Extensions__item__id),
        (u'criticality', ___GANSS_SAT_Info_Almanac_SBASecef_ie_Extensions__item__criticality),
        (u'extensionValue', ___GANSS_SAT_Info_Almanac_SBASecef_ie_Extensions__item__extensionValue),
        ])
    __GANSS_SAT_Info_Almanac_SBASecef_ie_Extensions__item_._ext = None
    _GANSS_SAT_Info_Almanac_SBASecef_ie_Extensions._cont = __GANSS_SAT_Info_Almanac_SBASecef_ie_Extensions__item_
    _GANSS_SAT_Info_Almanac_SBASecef_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GANSS_SAT_Info_Almanac_SBASecef._cont = ASN1Dict([
        (u'sbasAlmDataID', _GANSS_SAT_Info_Almanac_SBASecef_sbasAlmDataID),
        (u'svID', _GANSS_SAT_Info_Almanac_SBASecef_svID),
        (u'sbasAlmHealth', _GANSS_SAT_Info_Almanac_SBASecef_sbasAlmHealth),
        (u'sbasAlmXg', _GANSS_SAT_Info_Almanac_SBASecef_sbasAlmXg),
        (u'sbasAlmYg', _GANSS_SAT_Info_Almanac_SBASecef_sbasAlmYg),
        (u'sbasAlmZg', _GANSS_SAT_Info_Almanac_SBASecef_sbasAlmZg),
        (u'sbasAlmXgdot', _GANSS_SAT_Info_Almanac_SBASecef_sbasAlmXgdot),
        (u'sbasAlmYgDot', _GANSS_SAT_Info_Almanac_SBASecef_sbasAlmYgDot),
        (u'sbasAlmZgDot', _GANSS_SAT_Info_Almanac_SBASecef_sbasAlmZgDot),
        (u'sbasAlmTo', _GANSS_SAT_Info_Almanac_SBASecef_sbasAlmTo),
        (u'ie-Extensions', _GANSS_SAT_Info_Almanac_SBASecef_ie_Extensions),
        ])
    GANSS_SAT_Info_Almanac_SBASecef._ext = []
    
    #-----< GANSS-SAT-Info-Almanac-SBASecef-ExtIEs >-----#
    GANSS_SAT_Info_Almanac_SBASecef_ExtIEs = CLASS(name=u'GANSS-SAT-Info-Almanac-SBASecef-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GANSS_SAT_Info_Almanac_SBASecef_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< Ganss-Sat-Info-AddNavList >-----#
    Ganss_Sat_Info_AddNavList = SEQ_OF(name=u'Ganss-Sat-Info-AddNavList', mode=MODE_TYPE)
    _Ganss_Sat_Info_AddNavList__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    __Ganss_Sat_Info_AddNavList__item__satId = INT(name=u'satId', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __Ganss_Sat_Info_AddNavList__item__satId._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    __Ganss_Sat_Info_AddNavList__item__svHealth = BIT_STR(name=u'svHealth', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __Ganss_Sat_Info_AddNavList__item__svHealth._const_sz = ASN1Set(rv=[6], rr=[], ev=None, er=[])
    __Ganss_Sat_Info_AddNavList__item__iod = BIT_STR(name=u'iod', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __Ganss_Sat_Info_AddNavList__item__iod._const_sz = ASN1Set(rv=[11], rr=[], ev=None, er=[])
    __Ganss_Sat_Info_AddNavList__item__ganssAddClockModels = CHOICE(name=u'ganssAddClockModels', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSS-AddClockModels')))
    __Ganss_Sat_Info_AddNavList__item__ganssAddOrbitModels = CHOICE(name=u'ganssAddOrbitModels', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSS-AddOrbitModels')))
    __Ganss_Sat_Info_AddNavList__item__ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    ___Ganss_Sat_Info_AddNavList__item__ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ____Ganss_Sat_Info_AddNavList__item__ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    _____Ganss_Sat_Info_AddNavList__item__ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____Ganss_Sat_Info_AddNavList__item__ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____Ganss_Sat_Info_AddNavList__item__ie_Extensions__item__id._const_tab = _____Ganss_Sat_Info_AddNavList__item__ie_Extensions__item__id_tab
    ____Ganss_Sat_Info_AddNavList__item__ie_Extensions__item__id._const_tab_at = None
    ____Ganss_Sat_Info_AddNavList__item__ie_Extensions__item__id._const_tab_id = u'id'
    ____Ganss_Sat_Info_AddNavList__item__ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    _____Ganss_Sat_Info_AddNavList__item__ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____Ganss_Sat_Info_AddNavList__item__ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____Ganss_Sat_Info_AddNavList__item__ie_Extensions__item__criticality._const_tab = _____Ganss_Sat_Info_AddNavList__item__ie_Extensions__item__criticality_tab
    ____Ganss_Sat_Info_AddNavList__item__ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ____Ganss_Sat_Info_AddNavList__item__ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ____Ganss_Sat_Info_AddNavList__item__ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    _____Ganss_Sat_Info_AddNavList__item__ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____Ganss_Sat_Info_AddNavList__item__ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____Ganss_Sat_Info_AddNavList__item__ie_Extensions__item__extensionValue._const_tab = _____Ganss_Sat_Info_AddNavList__item__ie_Extensions__item__extensionValue_tab
    ____Ganss_Sat_Info_AddNavList__item__ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ____Ganss_Sat_Info_AddNavList__item__ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    ___Ganss_Sat_Info_AddNavList__item__ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ____Ganss_Sat_Info_AddNavList__item__ie_Extensions__item__id),
        (u'criticality', ____Ganss_Sat_Info_AddNavList__item__ie_Extensions__item__criticality),
        (u'extensionValue', ____Ganss_Sat_Info_AddNavList__item__ie_Extensions__item__extensionValue),
        ])
    ___Ganss_Sat_Info_AddNavList__item__ie_Extensions__item_._ext = None
    __Ganss_Sat_Info_AddNavList__item__ie_Extensions._cont = ___Ganss_Sat_Info_AddNavList__item__ie_Extensions__item_
    __Ganss_Sat_Info_AddNavList__item__ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    _Ganss_Sat_Info_AddNavList__item_._cont = ASN1Dict([
        (u'satId', __Ganss_Sat_Info_AddNavList__item__satId),
        (u'svHealth', __Ganss_Sat_Info_AddNavList__item__svHealth),
        (u'iod', __Ganss_Sat_Info_AddNavList__item__iod),
        (u'ganssAddClockModels', __Ganss_Sat_Info_AddNavList__item__ganssAddClockModels),
        (u'ganssAddOrbitModels', __Ganss_Sat_Info_AddNavList__item__ganssAddOrbitModels),
        (u'ie-Extensions', __Ganss_Sat_Info_AddNavList__item__ie_Extensions),
        ])
    _Ganss_Sat_Info_AddNavList__item_._ext = []
    Ganss_Sat_Info_AddNavList._cont = _Ganss_Sat_Info_AddNavList__item_
    Ganss_Sat_Info_AddNavList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    
    #-----< Ganss-Sat-Info-AddNavList-ExtIEs >-----#
    Ganss_Sat_Info_AddNavList_ExtIEs = CLASS(name=u'Ganss-Sat-Info-AddNavList-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    Ganss_Sat_Info_AddNavList_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GANSS-Sat-Info-Nav >-----#
    GANSS_Sat_Info_Nav = SEQ_OF(name=u'GANSS-Sat-Info-Nav', mode=MODE_TYPE)
    _GANSS_Sat_Info_Nav__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    __GANSS_Sat_Info_Nav__item__satId = INT(name=u'satId', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __GANSS_Sat_Info_Nav__item__satId._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    __GANSS_Sat_Info_Nav__item__svHealth = BIT_STR(name=u'svHealth', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __GANSS_Sat_Info_Nav__item__svHealth._const_sz = ASN1Set(rv=[9], rr=[], ev=None, er=[])
    __GANSS_Sat_Info_Nav__item__iod = BIT_STR(name=u'iod', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __GANSS_Sat_Info_Nav__item__iod._const_sz = ASN1Set(rv=[10], rr=[], ev=None, er=[])
    __GANSS_Sat_Info_Nav__item__ganssClockModel = SEQ_OF(name=u'ganssClockModel', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSS-Clock-Model')))
    __GANSS_Sat_Info_Nav__item__ganssOrbitModel = CHOICE(name=u'ganssOrbitModel', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSS-Orbit-Model')))
    __GANSS_Sat_Info_Nav__item__ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    ___GANSS_Sat_Info_Nav__item__ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ____GANSS_Sat_Info_Nav__item__ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    _____GANSS_Sat_Info_Nav__item__ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____GANSS_Sat_Info_Nav__item__ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____GANSS_Sat_Info_Nav__item__ie_Extensions__item__id._const_tab = _____GANSS_Sat_Info_Nav__item__ie_Extensions__item__id_tab
    ____GANSS_Sat_Info_Nav__item__ie_Extensions__item__id._const_tab_at = None
    ____GANSS_Sat_Info_Nav__item__ie_Extensions__item__id._const_tab_id = u'id'
    ____GANSS_Sat_Info_Nav__item__ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    _____GANSS_Sat_Info_Nav__item__ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____GANSS_Sat_Info_Nav__item__ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____GANSS_Sat_Info_Nav__item__ie_Extensions__item__criticality._const_tab = _____GANSS_Sat_Info_Nav__item__ie_Extensions__item__criticality_tab
    ____GANSS_Sat_Info_Nav__item__ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ____GANSS_Sat_Info_Nav__item__ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ____GANSS_Sat_Info_Nav__item__ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    _____GANSS_Sat_Info_Nav__item__ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____GANSS_Sat_Info_Nav__item__ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____GANSS_Sat_Info_Nav__item__ie_Extensions__item__extensionValue._const_tab = _____GANSS_Sat_Info_Nav__item__ie_Extensions__item__extensionValue_tab
    ____GANSS_Sat_Info_Nav__item__ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ____GANSS_Sat_Info_Nav__item__ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    ___GANSS_Sat_Info_Nav__item__ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ____GANSS_Sat_Info_Nav__item__ie_Extensions__item__id),
        (u'criticality', ____GANSS_Sat_Info_Nav__item__ie_Extensions__item__criticality),
        (u'extensionValue', ____GANSS_Sat_Info_Nav__item__ie_Extensions__item__extensionValue),
        ])
    ___GANSS_Sat_Info_Nav__item__ie_Extensions__item_._ext = None
    __GANSS_Sat_Info_Nav__item__ie_Extensions._cont = ___GANSS_Sat_Info_Nav__item__ie_Extensions__item_
    __GANSS_Sat_Info_Nav__item__ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    _GANSS_Sat_Info_Nav__item_._cont = ASN1Dict([
        (u'satId', __GANSS_Sat_Info_Nav__item__satId),
        (u'svHealth', __GANSS_Sat_Info_Nav__item__svHealth),
        (u'iod', __GANSS_Sat_Info_Nav__item__iod),
        (u'ganssClockModel', __GANSS_Sat_Info_Nav__item__ganssClockModel),
        (u'ganssOrbitModel', __GANSS_Sat_Info_Nav__item__ganssOrbitModel),
        (u'ie-Extensions', __GANSS_Sat_Info_Nav__item__ie_Extensions),
        ])
    _GANSS_Sat_Info_Nav__item_._ext = []
    GANSS_Sat_Info_Nav._cont = _GANSS_Sat_Info_Nav__item_
    GANSS_Sat_Info_Nav._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    
    #-----< GANSS-Sat-Info-Nav-ExtIEs >-----#
    GANSS_Sat_Info_Nav_ExtIEs = CLASS(name=u'GANSS-Sat-Info-Nav-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GANSS_Sat_Info_Nav_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GANSS-SignalID >-----#
    GANSS_SignalID = SEQ(name=u'GANSS-SignalID', mode=MODE_TYPE)
    _GANSS_SignalID_ganssSignalID = INT(name=u'ganssSignalID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_SignalID_ganssSignalID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=3)], ev=[], er=[ASN1RangeInt(lb=4, ub=7)])
    _GANSS_SignalID_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GANSS_SignalID_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GANSS_SignalID_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GANSS_SignalID_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_SignalID_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_SignalID_ie_Extensions__item__id._const_tab = ____GANSS_SignalID_ie_Extensions__item__id_tab
    ___GANSS_SignalID_ie_Extensions__item__id._const_tab_at = None
    ___GANSS_SignalID_ie_Extensions__item__id._const_tab_id = u'id'
    ___GANSS_SignalID_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GANSS_SignalID_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_SignalID_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_SignalID_ie_Extensions__item__criticality._const_tab = ____GANSS_SignalID_ie_Extensions__item__criticality_tab
    ___GANSS_SignalID_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GANSS_SignalID_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GANSS_SignalID_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GANSS_SignalID_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_SignalID_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_SignalID_ie_Extensions__item__extensionValue._const_tab = ____GANSS_SignalID_ie_Extensions__item__extensionValue_tab
    ___GANSS_SignalID_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GANSS_SignalID_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GANSS_SignalID_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GANSS_SignalID_ie_Extensions__item__id),
        (u'criticality', ___GANSS_SignalID_ie_Extensions__item__criticality),
        (u'extensionValue', ___GANSS_SignalID_ie_Extensions__item__extensionValue),
        ])
    __GANSS_SignalID_ie_Extensions__item_._ext = None
    _GANSS_SignalID_ie_Extensions._cont = __GANSS_SignalID_ie_Extensions__item_
    _GANSS_SignalID_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GANSS_SignalID._cont = ASN1Dict([
        (u'ganssSignalID', _GANSS_SignalID_ganssSignalID),
        (u'ie-Extensions', _GANSS_SignalID_ie_Extensions),
        ])
    GANSS_SignalID._ext = []
    
    #-----< GANSS-SignalID-ExtIEs >-----#
    GANSS_SignalID_ExtIEs = CLASS(name=u'GANSS-SignalID-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GANSS_SignalID_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GANSS-StatusHealth >-----#
    GANSS_StatusHealth = ENUM(name=u'GANSS-StatusHealth', mode=MODE_TYPE)
    GANSS_StatusHealth._cont = ASN1Dict([(u'udre-scale-1dot0', 0), (u'udre-scale-0dot75', 1), (u'udre-scale-0dot5', 2), (u'udre-scale-0dot3', 3), (u'udre-scale-Odot2', 4), (u'udre-scale-0dot1', 5), (u'no-data', 6), (u'invalid-data', 7)])
    GANSS_StatusHealth._ext = None
    
    #-----< GANSS-Time-Model >-----#
    GANSS_Time_Model = SEQ(name=u'GANSS-Time-Model', mode=MODE_TYPE)
    _GANSS_Time_Model_ganss_time_model_refTime = INT(name=u'ganss-time-model-refTime', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_Time_Model_ganss_time_model_refTime._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=37799)], ev=None, er=[])
    _GANSS_Time_Model_ganss_t_a0 = INT(name=u'ganss-t-a0', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_Time_Model_ganss_t_a0._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-2147483648, ub=2147483647)], ev=None, er=[])
    _GANSS_Time_Model_ganss_t_a1 = INT(name=u'ganss-t-a1', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GANSS_Time_Model_ganss_t_a1._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-8388608, ub=8388607)], ev=None, er=[])
    _GANSS_Time_Model_ganss_t_a2 = INT(name=u'ganss-t-a2', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GANSS_Time_Model_ganss_t_a2._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-64, ub=63)], ev=None, er=[])
    _GANSS_Time_Model_gnss_to_id = ENUM(name=u'gnss-to-id', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_Time_Model_gnss_to_id._cont = ASN1Dict([(u'gps', 0), (u'galileo', 1), (u'qzss', 2), (u'glonass', 3), (u'bds', 4)])
    _GANSS_Time_Model_gnss_to_id._ext = [u'galileo', u'qzss', u'glonass', u'bds']
    _GANSS_Time_Model_ganss_wk_number = INT(name=u'ganss-wk-number', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GANSS_Time_Model_ganss_wk_number._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=8191)], ev=None, er=[])
    _GANSS_Time_Model_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GANSS_Time_Model_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GANSS_Time_Model_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GANSS_Time_Model_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____GANSS_Time_Model_ie_Extensions__item__id_tab_val_Extension_0 = INT(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-Delta-T')))
    ____GANSS_Time_Model_ie_Extensions__item__id_tab._val = ASN1Set(rv=[dict([(u'id', 123), (u'criticality', u'ignore'), (u'Extension', _____GANSS_Time_Model_ie_Extensions__item__id_tab_val_Extension_0), (u'presence', u'optional')])], rr=[], ev=None, er=[])
    ___GANSS_Time_Model_ie_Extensions__item__id._const_tab = ____GANSS_Time_Model_ie_Extensions__item__id_tab
    ___GANSS_Time_Model_ie_Extensions__item__id._const_tab_at = None
    ___GANSS_Time_Model_ie_Extensions__item__id._const_tab_id = u'id'
    ___GANSS_Time_Model_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ___GANSS_Time_Model_ie_Extensions__item__criticality._const_tab = ____GANSS_Time_Model_ie_Extensions__item__id_tab
    ___GANSS_Time_Model_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GANSS_Time_Model_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GANSS_Time_Model_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ___GANSS_Time_Model_ie_Extensions__item__extensionValue._const_tab = ____GANSS_Time_Model_ie_Extensions__item__id_tab
    ___GANSS_Time_Model_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GANSS_Time_Model_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GANSS_Time_Model_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GANSS_Time_Model_ie_Extensions__item__id),
        (u'criticality', ___GANSS_Time_Model_ie_Extensions__item__criticality),
        (u'extensionValue', ___GANSS_Time_Model_ie_Extensions__item__extensionValue),
        ])
    __GANSS_Time_Model_ie_Extensions__item_._ext = None
    _GANSS_Time_Model_ie_Extensions._cont = __GANSS_Time_Model_ie_Extensions__item_
    _GANSS_Time_Model_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GANSS_Time_Model._cont = ASN1Dict([
        (u'ganss-time-model-refTime', _GANSS_Time_Model_ganss_time_model_refTime),
        (u'ganss-t-a0', _GANSS_Time_Model_ganss_t_a0),
        (u'ganss-t-a1', _GANSS_Time_Model_ganss_t_a1),
        (u'ganss-t-a2', _GANSS_Time_Model_ganss_t_a2),
        (u'gnss-to-id', _GANSS_Time_Model_gnss_to_id),
        (u'ganss-wk-number', _GANSS_Time_Model_ganss_wk_number),
        (u'ie-Extensions', _GANSS_Time_Model_ie_Extensions),
        ])
    GANSS_Time_Model._ext = []
    
    #-----< GANSS-Time-Model-ExtIEs >-----#
    GANSS_Time_Model_ExtIEs = CLASS(name=u'GANSS-Time-Model-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _GANSS_Time_Model_ExtIEs_val_Extension_0 = INT(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSS-Delta-T')))
    GANSS_Time_Model_ExtIEs._val = ASN1Set(rv=[dict([(u'id', 123), (u'criticality', u'ignore'), (u'Extension', _GANSS_Time_Model_ExtIEs_val_Extension_0), (u'presence', u'optional')])], rr=[], ev=[], er=[])
    
    #-----< GANSS-Delta-T >-----#
    GANSS_Delta_T = INT(name=u'GANSS-Delta-T', mode=MODE_TYPE)
    GANSS_Delta_T._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-128, ub=127)], ev=None, er=[])
    
    #-----< GANSS-UTRAN-TimeRelationshipUncertainty >-----#
    GANSS_UTRAN_TimeRelationshipUncertainty = ENUM(name=u'GANSS-UTRAN-TimeRelationshipUncertainty', mode=MODE_TYPE)
    GANSS_UTRAN_TimeRelationshipUncertainty._cont = ASN1Dict([(u'gANSS-UTRAN-TRU-50nano', 0), (u'gANSS-UTRAN-TRU-500nano', 1), (u'gANSS-UTRAN-TRU-1micro', 2), (u'gANSS-UTRAN-TRU-10micro', 3), (u'gANSS-UTRAN-TRU-1milli', 4), (u'gANSS-UTRAN-TRU-10milli', 5), (u'gANSS-UTRAN-TRU-100milli', 6), (u'gANSS-UTRAN-TRU-unreliable', 7)])
    GANSS_UTRAN_TimeRelationshipUncertainty._ext = []
    
    #-----< GANSS-UTRAN-TRU >-----#
    GANSS_UTRAN_TRU = SEQ(name=u'GANSS-UTRAN-TRU', mode=MODE_TYPE)
    _GANSS_UTRAN_TRU_gANSS_UTRAN_TimeRelationshipUncertainty = ENUM(name=u'gANSS-UTRAN-TimeRelationshipUncertainty', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSS-UTRAN-TimeRelationshipUncertainty')))
    _GANSS_UTRAN_TRU_ganssId = SEQ(name=u'ganssId', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSSID')), opt=True)
    _GANSS_UTRAN_TRU_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GANSS_UTRAN_TRU_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GANSS_UTRAN_TRU_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GANSS_UTRAN_TRU_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_UTRAN_TRU_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_UTRAN_TRU_ie_Extensions__item__id._const_tab = ____GANSS_UTRAN_TRU_ie_Extensions__item__id_tab
    ___GANSS_UTRAN_TRU_ie_Extensions__item__id._const_tab_at = None
    ___GANSS_UTRAN_TRU_ie_Extensions__item__id._const_tab_id = u'id'
    ___GANSS_UTRAN_TRU_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GANSS_UTRAN_TRU_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_UTRAN_TRU_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_UTRAN_TRU_ie_Extensions__item__criticality._const_tab = ____GANSS_UTRAN_TRU_ie_Extensions__item__criticality_tab
    ___GANSS_UTRAN_TRU_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GANSS_UTRAN_TRU_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GANSS_UTRAN_TRU_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GANSS_UTRAN_TRU_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_UTRAN_TRU_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_UTRAN_TRU_ie_Extensions__item__extensionValue._const_tab = ____GANSS_UTRAN_TRU_ie_Extensions__item__extensionValue_tab
    ___GANSS_UTRAN_TRU_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GANSS_UTRAN_TRU_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GANSS_UTRAN_TRU_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GANSS_UTRAN_TRU_ie_Extensions__item__id),
        (u'criticality', ___GANSS_UTRAN_TRU_ie_Extensions__item__criticality),
        (u'extensionValue', ___GANSS_UTRAN_TRU_ie_Extensions__item__extensionValue),
        ])
    __GANSS_UTRAN_TRU_ie_Extensions__item_._ext = None
    _GANSS_UTRAN_TRU_ie_Extensions._cont = __GANSS_UTRAN_TRU_ie_Extensions__item_
    _GANSS_UTRAN_TRU_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GANSS_UTRAN_TRU._cont = ASN1Dict([
        (u'gANSS-UTRAN-TimeRelationshipUncertainty', _GANSS_UTRAN_TRU_gANSS_UTRAN_TimeRelationshipUncertainty),
        (u'ganssId', _GANSS_UTRAN_TRU_ganssId),
        (u'ie-Extensions', _GANSS_UTRAN_TRU_ie_Extensions),
        ])
    GANSS_UTRAN_TRU._ext = []
    
    #-----< GANSS-UTRAN-TRU-ExtIEs >-----#
    GANSS_UTRAN_TRU_ExtIEs = CLASS(name=u'GANSS-UTRAN-TRU-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GANSS_UTRAN_TRU_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GANSS-UTC-Model >-----#
    GANSS_UTC_Model = SEQ(name=u'GANSS-UTC-Model', mode=MODE_TYPE)
    _GANSS_UTC_Model_a_one_utc = BIT_STR(name=u'a-one-utc', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_UTC_Model_a_one_utc._const_sz = ASN1Set(rv=[24], rr=[], ev=None, er=[])
    _GANSS_UTC_Model_a_zero_utc = BIT_STR(name=u'a-zero-utc', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_UTC_Model_a_zero_utc._const_sz = ASN1Set(rv=[32], rr=[], ev=None, er=[])
    _GANSS_UTC_Model_t_ot_utc = BIT_STR(name=u't-ot-utc', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_UTC_Model_t_ot_utc._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _GANSS_UTC_Model_w_n_t_utc = BIT_STR(name=u'w-n-t-utc', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_UTC_Model_w_n_t_utc._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _GANSS_UTC_Model_delta_t_ls_utc = BIT_STR(name=u'delta-t-ls-utc', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_UTC_Model_delta_t_ls_utc._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _GANSS_UTC_Model_w_n_lsf_utc = BIT_STR(name=u'w-n-lsf-utc', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_UTC_Model_w_n_lsf_utc._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _GANSS_UTC_Model_dn_utc = BIT_STR(name=u'dn-utc', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_UTC_Model_dn_utc._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _GANSS_UTC_Model_delta_t_lsf_utc = BIT_STR(name=u'delta-t-lsf-utc', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSS_UTC_Model_delta_t_lsf_utc._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _GANSS_UTC_Model_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GANSS_UTC_Model_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GANSS_UTC_Model_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GANSS_UTC_Model_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_UTC_Model_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_UTC_Model_ie_Extensions__item__id._const_tab = ____GANSS_UTC_Model_ie_Extensions__item__id_tab
    ___GANSS_UTC_Model_ie_Extensions__item__id._const_tab_at = None
    ___GANSS_UTC_Model_ie_Extensions__item__id._const_tab_id = u'id'
    ___GANSS_UTC_Model_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GANSS_UTC_Model_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_UTC_Model_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_UTC_Model_ie_Extensions__item__criticality._const_tab = ____GANSS_UTC_Model_ie_Extensions__item__criticality_tab
    ___GANSS_UTC_Model_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GANSS_UTC_Model_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GANSS_UTC_Model_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GANSS_UTC_Model_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSS_UTC_Model_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSS_UTC_Model_ie_Extensions__item__extensionValue._const_tab = ____GANSS_UTC_Model_ie_Extensions__item__extensionValue_tab
    ___GANSS_UTC_Model_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GANSS_UTC_Model_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GANSS_UTC_Model_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GANSS_UTC_Model_ie_Extensions__item__id),
        (u'criticality', ___GANSS_UTC_Model_ie_Extensions__item__criticality),
        (u'extensionValue', ___GANSS_UTC_Model_ie_Extensions__item__extensionValue),
        ])
    __GANSS_UTC_Model_ie_Extensions__item_._ext = None
    _GANSS_UTC_Model_ie_Extensions._cont = __GANSS_UTC_Model_ie_Extensions__item_
    _GANSS_UTC_Model_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GANSS_UTC_Model._cont = ASN1Dict([
        (u'a-one-utc', _GANSS_UTC_Model_a_one_utc),
        (u'a-zero-utc', _GANSS_UTC_Model_a_zero_utc),
        (u't-ot-utc', _GANSS_UTC_Model_t_ot_utc),
        (u'w-n-t-utc', _GANSS_UTC_Model_w_n_t_utc),
        (u'delta-t-ls-utc', _GANSS_UTC_Model_delta_t_ls_utc),
        (u'w-n-lsf-utc', _GANSS_UTC_Model_w_n_lsf_utc),
        (u'dn-utc', _GANSS_UTC_Model_dn_utc),
        (u'delta-t-lsf-utc', _GANSS_UTC_Model_delta_t_lsf_utc),
        (u'ie-Extensions', _GANSS_UTC_Model_ie_Extensions),
        ])
    GANSS_UTC_Model._ext = []
    
    #-----< GANSS-UTC-Model-ExtIEs >-----#
    GANSS_UTC_Model_ExtIEs = CLASS(name=u'GANSS-UTC-Model-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GANSS_UTC_Model_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< TUTRAN-GANSS-DriftRate >-----#
    TUTRAN_GANSS_DriftRate = ENUM(name=u'TUTRAN-GANSS-DriftRate', mode=MODE_TYPE)
    TUTRAN_GANSS_DriftRate._cont = ASN1Dict([(u'uTRAN-GANSSDrift0', 0), (u'uTRAN-GANSSDrift1', 1), (u'uTRAN-GANSSDrift2', 2), (u'uTRAN-GANSSDrift5', 3), (u'uTRAN-GANSSDrift10', 4), (u'uTRAN-GANSSDrift15', 5), (u'uTRAN-GANSSDrift25', 6), (u'uTRAN-GANSSDrift50', 7), (u'uTRAN-GANSSDrift-1', 8), (u'uTRAN-GANSSDrift-2', 9), (u'uTRAN-GANSSDrift-5', 10), (u'uTRAN-GANSSDrift-10', 11), (u'uTRAN-GANSSDrift-15', 12), (u'uTRAN-GANSSDrift-25', 13), (u'uTRAN-GANSSDrift-50', 14)])
    TUTRAN_GANSS_DriftRate._ext = []
    
    #-----< GLONASSclockModel >-----#
    GLONASSclockModel = SEQ(name=u'GLONASSclockModel', mode=MODE_TYPE)
    _GLONASSclockModel_gloTau = BIT_STR(name=u'gloTau', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GLONASSclockModel_gloTau._const_sz = ASN1Set(rv=[22], rr=[], ev=None, er=[])
    _GLONASSclockModel_gloGamma = BIT_STR(name=u'gloGamma', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GLONASSclockModel_gloGamma._const_sz = ASN1Set(rv=[11], rr=[], ev=None, er=[])
    _GLONASSclockModel_gloDeltaTau = BIT_STR(name=u'gloDeltaTau', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GLONASSclockModel_gloDeltaTau._const_sz = ASN1Set(rv=[5], rr=[], ev=None, er=[])
    _GLONASSclockModel_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GLONASSclockModel_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GLONASSclockModel_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GLONASSclockModel_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GLONASSclockModel_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GLONASSclockModel_ie_Extensions__item__id._const_tab = ____GLONASSclockModel_ie_Extensions__item__id_tab
    ___GLONASSclockModel_ie_Extensions__item__id._const_tab_at = None
    ___GLONASSclockModel_ie_Extensions__item__id._const_tab_id = u'id'
    ___GLONASSclockModel_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GLONASSclockModel_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GLONASSclockModel_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GLONASSclockModel_ie_Extensions__item__criticality._const_tab = ____GLONASSclockModel_ie_Extensions__item__criticality_tab
    ___GLONASSclockModel_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GLONASSclockModel_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GLONASSclockModel_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GLONASSclockModel_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GLONASSclockModel_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GLONASSclockModel_ie_Extensions__item__extensionValue._const_tab = ____GLONASSclockModel_ie_Extensions__item__extensionValue_tab
    ___GLONASSclockModel_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GLONASSclockModel_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GLONASSclockModel_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GLONASSclockModel_ie_Extensions__item__id),
        (u'criticality', ___GLONASSclockModel_ie_Extensions__item__criticality),
        (u'extensionValue', ___GLONASSclockModel_ie_Extensions__item__extensionValue),
        ])
    __GLONASSclockModel_ie_Extensions__item_._ext = None
    _GLONASSclockModel_ie_Extensions._cont = __GLONASSclockModel_ie_Extensions__item_
    _GLONASSclockModel_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GLONASSclockModel._cont = ASN1Dict([
        (u'gloTau', _GLONASSclockModel_gloTau),
        (u'gloGamma', _GLONASSclockModel_gloGamma),
        (u'gloDeltaTau', _GLONASSclockModel_gloDeltaTau),
        (u'ie-Extensions', _GLONASSclockModel_ie_Extensions),
        ])
    GLONASSclockModel._ext = []
    
    #-----< GLONASSclockModel-ExtIEs >-----#
    GLONASSclockModel_ExtIEs = CLASS(name=u'GLONASSclockModel-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GLONASSclockModel_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< NAVclockModel >-----#
    NAVclockModel = SEQ(name=u'NAVclockModel', mode=MODE_TYPE)
    _NAVclockModel_navToc = BIT_STR(name=u'navToc', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NAVclockModel_navToc._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _NAVclockModel_navaf2 = BIT_STR(name=u'navaf2', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NAVclockModel_navaf2._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _NAVclockModel_navaf1 = BIT_STR(name=u'navaf1', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NAVclockModel_navaf1._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _NAVclockModel_navaf0 = BIT_STR(name=u'navaf0', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NAVclockModel_navaf0._const_sz = ASN1Set(rv=[22], rr=[], ev=None, er=[])
    _NAVclockModel_navTgd = BIT_STR(name=u'navTgd', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NAVclockModel_navTgd._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _NAVclockModel_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __NAVclockModel_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___NAVclockModel_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____NAVclockModel_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____NAVclockModel_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___NAVclockModel_ie_Extensions__item__id._const_tab = ____NAVclockModel_ie_Extensions__item__id_tab
    ___NAVclockModel_ie_Extensions__item__id._const_tab_at = None
    ___NAVclockModel_ie_Extensions__item__id._const_tab_id = u'id'
    ___NAVclockModel_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____NAVclockModel_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____NAVclockModel_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___NAVclockModel_ie_Extensions__item__criticality._const_tab = ____NAVclockModel_ie_Extensions__item__criticality_tab
    ___NAVclockModel_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___NAVclockModel_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___NAVclockModel_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____NAVclockModel_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____NAVclockModel_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___NAVclockModel_ie_Extensions__item__extensionValue._const_tab = ____NAVclockModel_ie_Extensions__item__extensionValue_tab
    ___NAVclockModel_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___NAVclockModel_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __NAVclockModel_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___NAVclockModel_ie_Extensions__item__id),
        (u'criticality', ___NAVclockModel_ie_Extensions__item__criticality),
        (u'extensionValue', ___NAVclockModel_ie_Extensions__item__extensionValue),
        ])
    __NAVclockModel_ie_Extensions__item_._ext = None
    _NAVclockModel_ie_Extensions._cont = __NAVclockModel_ie_Extensions__item_
    _NAVclockModel_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    NAVclockModel._cont = ASN1Dict([
        (u'navToc', _NAVclockModel_navToc),
        (u'navaf2', _NAVclockModel_navaf2),
        (u'navaf1', _NAVclockModel_navaf1),
        (u'navaf0', _NAVclockModel_navaf0),
        (u'navTgd', _NAVclockModel_navTgd),
        (u'ie-Extensions', _NAVclockModel_ie_Extensions),
        ])
    NAVclockModel._ext = []
    
    #-----< NAVclockModel-ExtIEs >-----#
    NAVclockModel_ExtIEs = CLASS(name=u'NAVclockModel-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    NAVclockModel_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< NavModel-CNAVKeplerianSet >-----#
    NavModel_CNAVKeplerianSet = SEQ(name=u'NavModel-CNAVKeplerianSet', mode=MODE_TYPE)
    _NavModel_CNAVKeplerianSet_cnavTop = BIT_STR(name=u'cnavTop', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_CNAVKeplerianSet_cnavTop._const_sz = ASN1Set(rv=[11], rr=[], ev=None, er=[])
    _NavModel_CNAVKeplerianSet_cnavURAindex = BIT_STR(name=u'cnavURAindex', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_CNAVKeplerianSet_cnavURAindex._const_sz = ASN1Set(rv=[5], rr=[], ev=None, er=[])
    _NavModel_CNAVKeplerianSet_cnavDeltaA = BIT_STR(name=u'cnavDeltaA', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_CNAVKeplerianSet_cnavDeltaA._const_sz = ASN1Set(rv=[26], rr=[], ev=None, er=[])
    _NavModel_CNAVKeplerianSet_cnavAdot = BIT_STR(name=u'cnavAdot', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_CNAVKeplerianSet_cnavAdot._const_sz = ASN1Set(rv=[25], rr=[], ev=None, er=[])
    _NavModel_CNAVKeplerianSet_cnavDeltaNo = BIT_STR(name=u'cnavDeltaNo', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_CNAVKeplerianSet_cnavDeltaNo._const_sz = ASN1Set(rv=[17], rr=[], ev=None, er=[])
    _NavModel_CNAVKeplerianSet_cnavDeltaNoDot = BIT_STR(name=u'cnavDeltaNoDot', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_CNAVKeplerianSet_cnavDeltaNoDot._const_sz = ASN1Set(rv=[23], rr=[], ev=None, er=[])
    _NavModel_CNAVKeplerianSet_cnavMo = BIT_STR(name=u'cnavMo', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_CNAVKeplerianSet_cnavMo._const_sz = ASN1Set(rv=[33], rr=[], ev=None, er=[])
    _NavModel_CNAVKeplerianSet_cnavE = BIT_STR(name=u'cnavE', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_CNAVKeplerianSet_cnavE._const_sz = ASN1Set(rv=[33], rr=[], ev=None, er=[])
    _NavModel_CNAVKeplerianSet_cnavOmega = BIT_STR(name=u'cnavOmega', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_CNAVKeplerianSet_cnavOmega._const_sz = ASN1Set(rv=[33], rr=[], ev=None, er=[])
    _NavModel_CNAVKeplerianSet_cnavOMEGA0 = BIT_STR(name=u'cnavOMEGA0', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_CNAVKeplerianSet_cnavOMEGA0._const_sz = ASN1Set(rv=[33], rr=[], ev=None, er=[])
    _NavModel_CNAVKeplerianSet_cnavDeltaOmegaDot = BIT_STR(name=u'cnavDeltaOmegaDot', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_CNAVKeplerianSet_cnavDeltaOmegaDot._const_sz = ASN1Set(rv=[17], rr=[], ev=None, er=[])
    _NavModel_CNAVKeplerianSet_cnavIo = BIT_STR(name=u'cnavIo', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_CNAVKeplerianSet_cnavIo._const_sz = ASN1Set(rv=[33], rr=[], ev=None, er=[])
    _NavModel_CNAVKeplerianSet_cnavIoDot = BIT_STR(name=u'cnavIoDot', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_CNAVKeplerianSet_cnavIoDot._const_sz = ASN1Set(rv=[15], rr=[], ev=None, er=[])
    _NavModel_CNAVKeplerianSet_cnavCis = BIT_STR(name=u'cnavCis', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_CNAVKeplerianSet_cnavCis._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _NavModel_CNAVKeplerianSet_cnavCic = BIT_STR(name=u'cnavCic', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_CNAVKeplerianSet_cnavCic._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _NavModel_CNAVKeplerianSet_cnavCrs = BIT_STR(name=u'cnavCrs', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_CNAVKeplerianSet_cnavCrs._const_sz = ASN1Set(rv=[24], rr=[], ev=None, er=[])
    _NavModel_CNAVKeplerianSet_cnavCrc = BIT_STR(name=u'cnavCrc', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_CNAVKeplerianSet_cnavCrc._const_sz = ASN1Set(rv=[24], rr=[], ev=None, er=[])
    _NavModel_CNAVKeplerianSet_cnavCus = BIT_STR(name=u'cnavCus', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_CNAVKeplerianSet_cnavCus._const_sz = ASN1Set(rv=[21], rr=[], ev=None, er=[])
    _NavModel_CNAVKeplerianSet_cnavCuc = BIT_STR(name=u'cnavCuc', mode=MODE_TYPE, tag=(18, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_CNAVKeplerianSet_cnavCuc._const_sz = ASN1Set(rv=[21], rr=[], ev=None, er=[])
    _NavModel_CNAVKeplerianSet_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __NavModel_CNAVKeplerianSet_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___NavModel_CNAVKeplerianSet_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____NavModel_CNAVKeplerianSet_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____NavModel_CNAVKeplerianSet_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___NavModel_CNAVKeplerianSet_ie_Extensions__item__id._const_tab = ____NavModel_CNAVKeplerianSet_ie_Extensions__item__id_tab
    ___NavModel_CNAVKeplerianSet_ie_Extensions__item__id._const_tab_at = None
    ___NavModel_CNAVKeplerianSet_ie_Extensions__item__id._const_tab_id = u'id'
    ___NavModel_CNAVKeplerianSet_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____NavModel_CNAVKeplerianSet_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____NavModel_CNAVKeplerianSet_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___NavModel_CNAVKeplerianSet_ie_Extensions__item__criticality._const_tab = ____NavModel_CNAVKeplerianSet_ie_Extensions__item__criticality_tab
    ___NavModel_CNAVKeplerianSet_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___NavModel_CNAVKeplerianSet_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___NavModel_CNAVKeplerianSet_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____NavModel_CNAVKeplerianSet_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____NavModel_CNAVKeplerianSet_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___NavModel_CNAVKeplerianSet_ie_Extensions__item__extensionValue._const_tab = ____NavModel_CNAVKeplerianSet_ie_Extensions__item__extensionValue_tab
    ___NavModel_CNAVKeplerianSet_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___NavModel_CNAVKeplerianSet_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __NavModel_CNAVKeplerianSet_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___NavModel_CNAVKeplerianSet_ie_Extensions__item__id),
        (u'criticality', ___NavModel_CNAVKeplerianSet_ie_Extensions__item__criticality),
        (u'extensionValue', ___NavModel_CNAVKeplerianSet_ie_Extensions__item__extensionValue),
        ])
    __NavModel_CNAVKeplerianSet_ie_Extensions__item_._ext = None
    _NavModel_CNAVKeplerianSet_ie_Extensions._cont = __NavModel_CNAVKeplerianSet_ie_Extensions__item_
    _NavModel_CNAVKeplerianSet_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    NavModel_CNAVKeplerianSet._cont = ASN1Dict([
        (u'cnavTop', _NavModel_CNAVKeplerianSet_cnavTop),
        (u'cnavURAindex', _NavModel_CNAVKeplerianSet_cnavURAindex),
        (u'cnavDeltaA', _NavModel_CNAVKeplerianSet_cnavDeltaA),
        (u'cnavAdot', _NavModel_CNAVKeplerianSet_cnavAdot),
        (u'cnavDeltaNo', _NavModel_CNAVKeplerianSet_cnavDeltaNo),
        (u'cnavDeltaNoDot', _NavModel_CNAVKeplerianSet_cnavDeltaNoDot),
        (u'cnavMo', _NavModel_CNAVKeplerianSet_cnavMo),
        (u'cnavE', _NavModel_CNAVKeplerianSet_cnavE),
        (u'cnavOmega', _NavModel_CNAVKeplerianSet_cnavOmega),
        (u'cnavOMEGA0', _NavModel_CNAVKeplerianSet_cnavOMEGA0),
        (u'cnavDeltaOmegaDot', _NavModel_CNAVKeplerianSet_cnavDeltaOmegaDot),
        (u'cnavIo', _NavModel_CNAVKeplerianSet_cnavIo),
        (u'cnavIoDot', _NavModel_CNAVKeplerianSet_cnavIoDot),
        (u'cnavCis', _NavModel_CNAVKeplerianSet_cnavCis),
        (u'cnavCic', _NavModel_CNAVKeplerianSet_cnavCic),
        (u'cnavCrs', _NavModel_CNAVKeplerianSet_cnavCrs),
        (u'cnavCrc', _NavModel_CNAVKeplerianSet_cnavCrc),
        (u'cnavCus', _NavModel_CNAVKeplerianSet_cnavCus),
        (u'cnavCuc', _NavModel_CNAVKeplerianSet_cnavCuc),
        (u'ie-Extensions', _NavModel_CNAVKeplerianSet_ie_Extensions),
        ])
    NavModel_CNAVKeplerianSet._ext = []
    
    #-----< NavModel-CNAVKeplerianSet-ExtIEs >-----#
    NavModel_CNAVKeplerianSet_ExtIEs = CLASS(name=u'NavModel-CNAVKeplerianSet-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    NavModel_CNAVKeplerianSet_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< NavModel-GLONASSecef >-----#
    NavModel_GLONASSecef = SEQ(name=u'NavModel-GLONASSecef', mode=MODE_TYPE)
    _NavModel_GLONASSecef_gloEn = BIT_STR(name=u'gloEn', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_GLONASSecef_gloEn._const_sz = ASN1Set(rv=[5], rr=[], ev=None, er=[])
    _NavModel_GLONASSecef_gloP1 = BIT_STR(name=u'gloP1', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_GLONASSecef_gloP1._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    _NavModel_GLONASSecef_gloP2 = BIT_STR(name=u'gloP2', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_GLONASSecef_gloP2._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    _NavModel_GLONASSecef_gloM = BIT_STR(name=u'gloM', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _NavModel_GLONASSecef_gloM._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    _NavModel_GLONASSecef_gloX = BIT_STR(name=u'gloX', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_GLONASSecef_gloX._const_sz = ASN1Set(rv=[27], rr=[], ev=None, er=[])
    _NavModel_GLONASSecef_gloXdot = BIT_STR(name=u'gloXdot', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_GLONASSecef_gloXdot._const_sz = ASN1Set(rv=[24], rr=[], ev=None, er=[])
    _NavModel_GLONASSecef_gloXdotdot = BIT_STR(name=u'gloXdotdot', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_GLONASSecef_gloXdotdot._const_sz = ASN1Set(rv=[5], rr=[], ev=None, er=[])
    _NavModel_GLONASSecef_gloY = BIT_STR(name=u'gloY', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_GLONASSecef_gloY._const_sz = ASN1Set(rv=[27], rr=[], ev=None, er=[])
    _NavModel_GLONASSecef_gloYdot = BIT_STR(name=u'gloYdot', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_GLONASSecef_gloYdot._const_sz = ASN1Set(rv=[24], rr=[], ev=None, er=[])
    _NavModel_GLONASSecef_gloYdotdot = BIT_STR(name=u'gloYdotdot', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_GLONASSecef_gloYdotdot._const_sz = ASN1Set(rv=[5], rr=[], ev=None, er=[])
    _NavModel_GLONASSecef_gloZ = BIT_STR(name=u'gloZ', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_GLONASSecef_gloZ._const_sz = ASN1Set(rv=[27], rr=[], ev=None, er=[])
    _NavModel_GLONASSecef_gloZdot = BIT_STR(name=u'gloZdot', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_GLONASSecef_gloZdot._const_sz = ASN1Set(rv=[24], rr=[], ev=None, er=[])
    _NavModel_GLONASSecef_gloZdotdot = BIT_STR(name=u'gloZdotdot', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_GLONASSecef_gloZdotdot._const_sz = ASN1Set(rv=[5], rr=[], ev=None, er=[])
    _NavModel_GLONASSecef_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __NavModel_GLONASSecef_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___NavModel_GLONASSecef_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____NavModel_GLONASSecef_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____NavModel_GLONASSecef_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___NavModel_GLONASSecef_ie_Extensions__item__id._const_tab = ____NavModel_GLONASSecef_ie_Extensions__item__id_tab
    ___NavModel_GLONASSecef_ie_Extensions__item__id._const_tab_at = None
    ___NavModel_GLONASSecef_ie_Extensions__item__id._const_tab_id = u'id'
    ___NavModel_GLONASSecef_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____NavModel_GLONASSecef_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____NavModel_GLONASSecef_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___NavModel_GLONASSecef_ie_Extensions__item__criticality._const_tab = ____NavModel_GLONASSecef_ie_Extensions__item__criticality_tab
    ___NavModel_GLONASSecef_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___NavModel_GLONASSecef_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___NavModel_GLONASSecef_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____NavModel_GLONASSecef_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____NavModel_GLONASSecef_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___NavModel_GLONASSecef_ie_Extensions__item__extensionValue._const_tab = ____NavModel_GLONASSecef_ie_Extensions__item__extensionValue_tab
    ___NavModel_GLONASSecef_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___NavModel_GLONASSecef_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __NavModel_GLONASSecef_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___NavModel_GLONASSecef_ie_Extensions__item__id),
        (u'criticality', ___NavModel_GLONASSecef_ie_Extensions__item__criticality),
        (u'extensionValue', ___NavModel_GLONASSecef_ie_Extensions__item__extensionValue),
        ])
    __NavModel_GLONASSecef_ie_Extensions__item_._ext = None
    _NavModel_GLONASSecef_ie_Extensions._cont = __NavModel_GLONASSecef_ie_Extensions__item_
    _NavModel_GLONASSecef_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    NavModel_GLONASSecef._cont = ASN1Dict([
        (u'gloEn', _NavModel_GLONASSecef_gloEn),
        (u'gloP1', _NavModel_GLONASSecef_gloP1),
        (u'gloP2', _NavModel_GLONASSecef_gloP2),
        (u'gloM', _NavModel_GLONASSecef_gloM),
        (u'gloX', _NavModel_GLONASSecef_gloX),
        (u'gloXdot', _NavModel_GLONASSecef_gloXdot),
        (u'gloXdotdot', _NavModel_GLONASSecef_gloXdotdot),
        (u'gloY', _NavModel_GLONASSecef_gloY),
        (u'gloYdot', _NavModel_GLONASSecef_gloYdot),
        (u'gloYdotdot', _NavModel_GLONASSecef_gloYdotdot),
        (u'gloZ', _NavModel_GLONASSecef_gloZ),
        (u'gloZdot', _NavModel_GLONASSecef_gloZdot),
        (u'gloZdotdot', _NavModel_GLONASSecef_gloZdotdot),
        (u'ie-Extensions', _NavModel_GLONASSecef_ie_Extensions),
        ])
    NavModel_GLONASSecef._ext = []
    
    #-----< NavModel-GLONASSecef-ExtIEs >-----#
    NavModel_GLONASSecef_ExtIEs = CLASS(name=u'NavModel-GLONASSecef-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    NavModel_GLONASSecef_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< NavModel-NAVKeplerianSet >-----#
    NavModel_NAVKeplerianSet = SEQ(name=u'NavModel-NAVKeplerianSet', mode=MODE_TYPE)
    _NavModel_NAVKeplerianSet_navURA = BIT_STR(name=u'navURA', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_NAVKeplerianSet_navURA._const_sz = ASN1Set(rv=[4], rr=[], ev=None, er=[])
    _NavModel_NAVKeplerianSet_navFitFlag = BIT_STR(name=u'navFitFlag', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_NAVKeplerianSet_navFitFlag._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    _NavModel_NAVKeplerianSet_navToe = BIT_STR(name=u'navToe', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_NAVKeplerianSet_navToe._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _NavModel_NAVKeplerianSet_navOmega = BIT_STR(name=u'navOmega', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_NAVKeplerianSet_navOmega._const_sz = ASN1Set(rv=[32], rr=[], ev=None, er=[])
    _NavModel_NAVKeplerianSet_navDeltaN = BIT_STR(name=u'navDeltaN', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_NAVKeplerianSet_navDeltaN._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _NavModel_NAVKeplerianSet_navM0 = BIT_STR(name=u'navM0', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_NAVKeplerianSet_navM0._const_sz = ASN1Set(rv=[32], rr=[], ev=None, er=[])
    _NavModel_NAVKeplerianSet_navOmegaADot = BIT_STR(name=u'navOmegaADot', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_NAVKeplerianSet_navOmegaADot._const_sz = ASN1Set(rv=[24], rr=[], ev=None, er=[])
    _NavModel_NAVKeplerianSet_navE = BIT_STR(name=u'navE', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_NAVKeplerianSet_navE._const_sz = ASN1Set(rv=[32], rr=[], ev=None, er=[])
    _NavModel_NAVKeplerianSet_navIDot = BIT_STR(name=u'navIDot', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_NAVKeplerianSet_navIDot._const_sz = ASN1Set(rv=[14], rr=[], ev=None, er=[])
    _NavModel_NAVKeplerianSet_navAPowerHalf = BIT_STR(name=u'navAPowerHalf', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_NAVKeplerianSet_navAPowerHalf._const_sz = ASN1Set(rv=[32], rr=[], ev=None, er=[])
    _NavModel_NAVKeplerianSet_navI0 = BIT_STR(name=u'navI0', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_NAVKeplerianSet_navI0._const_sz = ASN1Set(rv=[32], rr=[], ev=None, er=[])
    _NavModel_NAVKeplerianSet_navOmegaA0 = BIT_STR(name=u'navOmegaA0', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_NAVKeplerianSet_navOmegaA0._const_sz = ASN1Set(rv=[32], rr=[], ev=None, er=[])
    _NavModel_NAVKeplerianSet_navCrs = BIT_STR(name=u'navCrs', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_NAVKeplerianSet_navCrs._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _NavModel_NAVKeplerianSet_navCis = BIT_STR(name=u'navCis', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_NAVKeplerianSet_navCis._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _NavModel_NAVKeplerianSet_navCus = BIT_STR(name=u'navCus', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_NAVKeplerianSet_navCus._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _NavModel_NAVKeplerianSet_navCrc = BIT_STR(name=u'navCrc', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_NAVKeplerianSet_navCrc._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _NavModel_NAVKeplerianSet_navCic = BIT_STR(name=u'navCic', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_NAVKeplerianSet_navCic._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _NavModel_NAVKeplerianSet_navCuc = BIT_STR(name=u'navCuc', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_NAVKeplerianSet_navCuc._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _NavModel_NAVKeplerianSet_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(18, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __NavModel_NAVKeplerianSet_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___NavModel_NAVKeplerianSet_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____NavModel_NAVKeplerianSet_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____NavModel_NAVKeplerianSet_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___NavModel_NAVKeplerianSet_ie_Extensions__item__id._const_tab = ____NavModel_NAVKeplerianSet_ie_Extensions__item__id_tab
    ___NavModel_NAVKeplerianSet_ie_Extensions__item__id._const_tab_at = None
    ___NavModel_NAVKeplerianSet_ie_Extensions__item__id._const_tab_id = u'id'
    ___NavModel_NAVKeplerianSet_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____NavModel_NAVKeplerianSet_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____NavModel_NAVKeplerianSet_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___NavModel_NAVKeplerianSet_ie_Extensions__item__criticality._const_tab = ____NavModel_NAVKeplerianSet_ie_Extensions__item__criticality_tab
    ___NavModel_NAVKeplerianSet_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___NavModel_NAVKeplerianSet_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___NavModel_NAVKeplerianSet_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____NavModel_NAVKeplerianSet_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____NavModel_NAVKeplerianSet_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___NavModel_NAVKeplerianSet_ie_Extensions__item__extensionValue._const_tab = ____NavModel_NAVKeplerianSet_ie_Extensions__item__extensionValue_tab
    ___NavModel_NAVKeplerianSet_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___NavModel_NAVKeplerianSet_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __NavModel_NAVKeplerianSet_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___NavModel_NAVKeplerianSet_ie_Extensions__item__id),
        (u'criticality', ___NavModel_NAVKeplerianSet_ie_Extensions__item__criticality),
        (u'extensionValue', ___NavModel_NAVKeplerianSet_ie_Extensions__item__extensionValue),
        ])
    __NavModel_NAVKeplerianSet_ie_Extensions__item_._ext = None
    _NavModel_NAVKeplerianSet_ie_Extensions._cont = __NavModel_NAVKeplerianSet_ie_Extensions__item_
    _NavModel_NAVKeplerianSet_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    NavModel_NAVKeplerianSet._cont = ASN1Dict([
        (u'navURA', _NavModel_NAVKeplerianSet_navURA),
        (u'navFitFlag', _NavModel_NAVKeplerianSet_navFitFlag),
        (u'navToe', _NavModel_NAVKeplerianSet_navToe),
        (u'navOmega', _NavModel_NAVKeplerianSet_navOmega),
        (u'navDeltaN', _NavModel_NAVKeplerianSet_navDeltaN),
        (u'navM0', _NavModel_NAVKeplerianSet_navM0),
        (u'navOmegaADot', _NavModel_NAVKeplerianSet_navOmegaADot),
        (u'navE', _NavModel_NAVKeplerianSet_navE),
        (u'navIDot', _NavModel_NAVKeplerianSet_navIDot),
        (u'navAPowerHalf', _NavModel_NAVKeplerianSet_navAPowerHalf),
        (u'navI0', _NavModel_NAVKeplerianSet_navI0),
        (u'navOmegaA0', _NavModel_NAVKeplerianSet_navOmegaA0),
        (u'navCrs', _NavModel_NAVKeplerianSet_navCrs),
        (u'navCis', _NavModel_NAVKeplerianSet_navCis),
        (u'navCus', _NavModel_NAVKeplerianSet_navCus),
        (u'navCrc', _NavModel_NAVKeplerianSet_navCrc),
        (u'navCic', _NavModel_NAVKeplerianSet_navCic),
        (u'navCuc', _NavModel_NAVKeplerianSet_navCuc),
        (u'ie-Extensions', _NavModel_NAVKeplerianSet_ie_Extensions),
        ])
    NavModel_NAVKeplerianSet._ext = []
    
    #-----< NavModel-NAVKeplerianSet-ExtIEs >-----#
    NavModel_NAVKeplerianSet_ExtIEs = CLASS(name=u'NavModel-NAVKeplerianSet-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    NavModel_NAVKeplerianSet_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< NavModel-SBASecef >-----#
    NavModel_SBASecef = SEQ(name=u'NavModel-SBASecef', mode=MODE_TYPE)
    _NavModel_SBASecef_sbasTo = BIT_STR(name=u'sbasTo', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _NavModel_SBASecef_sbasTo._const_sz = ASN1Set(rv=[13], rr=[], ev=None, er=[])
    _NavModel_SBASecef_sbasAccuracy = BIT_STR(name=u'sbasAccuracy', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_SBASecef_sbasAccuracy._const_sz = ASN1Set(rv=[4], rr=[], ev=None, er=[])
    _NavModel_SBASecef_sbasXg = BIT_STR(name=u'sbasXg', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_SBASecef_sbasXg._const_sz = ASN1Set(rv=[30], rr=[], ev=None, er=[])
    _NavModel_SBASecef_sbasYg = BIT_STR(name=u'sbasYg', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_SBASecef_sbasYg._const_sz = ASN1Set(rv=[30], rr=[], ev=None, er=[])
    _NavModel_SBASecef_sbasZg = BIT_STR(name=u'sbasZg', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_SBASecef_sbasZg._const_sz = ASN1Set(rv=[25], rr=[], ev=None, er=[])
    _NavModel_SBASecef_sbasXgDot = BIT_STR(name=u'sbasXgDot', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_SBASecef_sbasXgDot._const_sz = ASN1Set(rv=[17], rr=[], ev=None, er=[])
    _NavModel_SBASecef_sbasYgDot = BIT_STR(name=u'sbasYgDot', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_SBASecef_sbasYgDot._const_sz = ASN1Set(rv=[17], rr=[], ev=None, er=[])
    _NavModel_SBASecef_sbasZgDot = BIT_STR(name=u'sbasZgDot', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_SBASecef_sbasZgDot._const_sz = ASN1Set(rv=[18], rr=[], ev=None, er=[])
    _NavModel_SBASecef_sbasXgDotDot = BIT_STR(name=u'sbasXgDotDot', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_SBASecef_sbasXgDotDot._const_sz = ASN1Set(rv=[10], rr=[], ev=None, er=[])
    _NavModel_SBASecef_sbagYgDotDot = BIT_STR(name=u'sbagYgDotDot', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_SBASecef_sbagYgDotDot._const_sz = ASN1Set(rv=[10], rr=[], ev=None, er=[])
    _NavModel_SBASecef_sbasZgDotDot = BIT_STR(name=u'sbasZgDotDot', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_SBASecef_sbasZgDotDot._const_sz = ASN1Set(rv=[10], rr=[], ev=None, er=[])
    _NavModel_SBASecef_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __NavModel_SBASecef_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___NavModel_SBASecef_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____NavModel_SBASecef_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____NavModel_SBASecef_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___NavModel_SBASecef_ie_Extensions__item__id._const_tab = ____NavModel_SBASecef_ie_Extensions__item__id_tab
    ___NavModel_SBASecef_ie_Extensions__item__id._const_tab_at = None
    ___NavModel_SBASecef_ie_Extensions__item__id._const_tab_id = u'id'
    ___NavModel_SBASecef_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____NavModel_SBASecef_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____NavModel_SBASecef_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___NavModel_SBASecef_ie_Extensions__item__criticality._const_tab = ____NavModel_SBASecef_ie_Extensions__item__criticality_tab
    ___NavModel_SBASecef_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___NavModel_SBASecef_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___NavModel_SBASecef_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____NavModel_SBASecef_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____NavModel_SBASecef_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___NavModel_SBASecef_ie_Extensions__item__extensionValue._const_tab = ____NavModel_SBASecef_ie_Extensions__item__extensionValue_tab
    ___NavModel_SBASecef_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___NavModel_SBASecef_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __NavModel_SBASecef_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___NavModel_SBASecef_ie_Extensions__item__id),
        (u'criticality', ___NavModel_SBASecef_ie_Extensions__item__criticality),
        (u'extensionValue', ___NavModel_SBASecef_ie_Extensions__item__extensionValue),
        ])
    __NavModel_SBASecef_ie_Extensions__item_._ext = None
    _NavModel_SBASecef_ie_Extensions._cont = __NavModel_SBASecef_ie_Extensions__item_
    _NavModel_SBASecef_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    NavModel_SBASecef._cont = ASN1Dict([
        (u'sbasTo', _NavModel_SBASecef_sbasTo),
        (u'sbasAccuracy', _NavModel_SBASecef_sbasAccuracy),
        (u'sbasXg', _NavModel_SBASecef_sbasXg),
        (u'sbasYg', _NavModel_SBASecef_sbasYg),
        (u'sbasZg', _NavModel_SBASecef_sbasZg),
        (u'sbasXgDot', _NavModel_SBASecef_sbasXgDot),
        (u'sbasYgDot', _NavModel_SBASecef_sbasYgDot),
        (u'sbasZgDot', _NavModel_SBASecef_sbasZgDot),
        (u'sbasXgDotDot', _NavModel_SBASecef_sbasXgDotDot),
        (u'sbagYgDotDot', _NavModel_SBASecef_sbagYgDotDot),
        (u'sbasZgDotDot', _NavModel_SBASecef_sbasZgDotDot),
        (u'ie-Extensions', _NavModel_SBASecef_ie_Extensions),
        ])
    NavModel_SBASecef._ext = []
    
    #-----< NavModel-SBASecef-ExtIEs >-----#
    NavModel_SBASecef_ExtIEs = CLASS(name=u'NavModel-SBASecef-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    NavModel_SBASecef_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< NavModel-BDSKeplerianSet >-----#
    NavModel_BDSKeplerianSet = SEQ(name=u'NavModel-BDSKeplerianSet', mode=MODE_TYPE)
    _NavModel_BDSKeplerianSet_uRAIndex_BDS = BIT_STR(name=u'uRAIndex-BDS', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_BDSKeplerianSet_uRAIndex_BDS._const_sz = ASN1Set(rv=[4], rr=[], ev=None, er=[])
    _NavModel_BDSKeplerianSet_tOA_BDS = BIT_STR(name=u'tOA-BDS', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_BDSKeplerianSet_tOA_BDS._const_sz = ASN1Set(rv=[17], rr=[], ev=None, er=[])
    _NavModel_BDSKeplerianSet_a1_2_BDS = BIT_STR(name=u'a1-2-BDS', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_BDSKeplerianSet_a1_2_BDS._const_sz = ASN1Set(rv=[32], rr=[], ev=None, er=[])
    _NavModel_BDSKeplerianSet_e_BDS = BIT_STR(name=u'e-BDS', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_BDSKeplerianSet_e_BDS._const_sz = ASN1Set(rv=[32], rr=[], ev=None, er=[])
    _NavModel_BDSKeplerianSet_oMG_BDS = BIT_STR(name=u'oMG-BDS', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_BDSKeplerianSet_oMG_BDS._const_sz = ASN1Set(rv=[32], rr=[], ev=None, er=[])
    _NavModel_BDSKeplerianSet_dLTn_BDS = BIT_STR(name=u'dLTn-BDS', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_BDSKeplerianSet_dLTn_BDS._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _NavModel_BDSKeplerianSet_m0_BDS = BIT_STR(name=u'm0-BDS', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_BDSKeplerianSet_m0_BDS._const_sz = ASN1Set(rv=[32], rr=[], ev=None, er=[])
    _NavModel_BDSKeplerianSet_oMG0_BDS = BIT_STR(name=u'oMG0-BDS', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_BDSKeplerianSet_oMG0_BDS._const_sz = ASN1Set(rv=[32], rr=[], ev=None, er=[])
    _NavModel_BDSKeplerianSet_oMGdot_BDS = BIT_STR(name=u'oMGdot-BDS', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_BDSKeplerianSet_oMGdot_BDS._const_sz = ASN1Set(rv=[24], rr=[], ev=None, er=[])
    _NavModel_BDSKeplerianSet_i0_BDS = BIT_STR(name=u'i0-BDS', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_BDSKeplerianSet_i0_BDS._const_sz = ASN1Set(rv=[32], rr=[], ev=None, er=[])
    _NavModel_BDSKeplerianSet_iDOT_BDS = BIT_STR(name=u'iDOT-BDS', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_BDSKeplerianSet_iDOT_BDS._const_sz = ASN1Set(rv=[14], rr=[], ev=None, er=[])
    _NavModel_BDSKeplerianSet_cuc_BDS = BIT_STR(name=u'cuc-BDS', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_BDSKeplerianSet_cuc_BDS._const_sz = ASN1Set(rv=[18], rr=[], ev=None, er=[])
    _NavModel_BDSKeplerianSet_cus_BDS = BIT_STR(name=u'cus-BDS', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_BDSKeplerianSet_cus_BDS._const_sz = ASN1Set(rv=[18], rr=[], ev=None, er=[])
    _NavModel_BDSKeplerianSet_crc_BDS = BIT_STR(name=u'crc-BDS', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_BDSKeplerianSet_crc_BDS._const_sz = ASN1Set(rv=[18], rr=[], ev=None, er=[])
    _NavModel_BDSKeplerianSet_crs_BDS = BIT_STR(name=u'crs-BDS', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_BDSKeplerianSet_crs_BDS._const_sz = ASN1Set(rv=[18], rr=[], ev=None, er=[])
    _NavModel_BDSKeplerianSet_cic_BDS = BIT_STR(name=u'cic-BDS', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_BDSKeplerianSet_cic_BDS._const_sz = ASN1Set(rv=[18], rr=[], ev=None, er=[])
    _NavModel_BDSKeplerianSet_cis_BDS = BIT_STR(name=u'cis-BDS', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_BDSKeplerianSet_cis_BDS._const_sz = ASN1Set(rv=[18], rr=[], ev=None, er=[])
    _NavModel_BDSKeplerianSet_aODE_BDS = BIT_STR(name=u'aODE-BDS', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavModel_BDSKeplerianSet_aODE_BDS._const_sz = ASN1Set(rv=[5], rr=[], ev=None, er=[])
    _NavModel_BDSKeplerianSet_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(18, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __NavModel_BDSKeplerianSet_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___NavModel_BDSKeplerianSet_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____NavModel_BDSKeplerianSet_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____NavModel_BDSKeplerianSet_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___NavModel_BDSKeplerianSet_ie_Extensions__item__id._const_tab = ____NavModel_BDSKeplerianSet_ie_Extensions__item__id_tab
    ___NavModel_BDSKeplerianSet_ie_Extensions__item__id._const_tab_at = None
    ___NavModel_BDSKeplerianSet_ie_Extensions__item__id._const_tab_id = u'id'
    ___NavModel_BDSKeplerianSet_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____NavModel_BDSKeplerianSet_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____NavModel_BDSKeplerianSet_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___NavModel_BDSKeplerianSet_ie_Extensions__item__criticality._const_tab = ____NavModel_BDSKeplerianSet_ie_Extensions__item__criticality_tab
    ___NavModel_BDSKeplerianSet_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___NavModel_BDSKeplerianSet_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___NavModel_BDSKeplerianSet_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____NavModel_BDSKeplerianSet_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____NavModel_BDSKeplerianSet_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___NavModel_BDSKeplerianSet_ie_Extensions__item__extensionValue._const_tab = ____NavModel_BDSKeplerianSet_ie_Extensions__item__extensionValue_tab
    ___NavModel_BDSKeplerianSet_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___NavModel_BDSKeplerianSet_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __NavModel_BDSKeplerianSet_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___NavModel_BDSKeplerianSet_ie_Extensions__item__id),
        (u'criticality', ___NavModel_BDSKeplerianSet_ie_Extensions__item__criticality),
        (u'extensionValue', ___NavModel_BDSKeplerianSet_ie_Extensions__item__extensionValue),
        ])
    __NavModel_BDSKeplerianSet_ie_Extensions__item_._ext = None
    _NavModel_BDSKeplerianSet_ie_Extensions._cont = __NavModel_BDSKeplerianSet_ie_Extensions__item_
    _NavModel_BDSKeplerianSet_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    NavModel_BDSKeplerianSet._cont = ASN1Dict([
        (u'uRAIndex-BDS', _NavModel_BDSKeplerianSet_uRAIndex_BDS),
        (u'tOA-BDS', _NavModel_BDSKeplerianSet_tOA_BDS),
        (u'a1-2-BDS', _NavModel_BDSKeplerianSet_a1_2_BDS),
        (u'e-BDS', _NavModel_BDSKeplerianSet_e_BDS),
        (u'oMG-BDS', _NavModel_BDSKeplerianSet_oMG_BDS),
        (u'dLTn-BDS', _NavModel_BDSKeplerianSet_dLTn_BDS),
        (u'm0-BDS', _NavModel_BDSKeplerianSet_m0_BDS),
        (u'oMG0-BDS', _NavModel_BDSKeplerianSet_oMG0_BDS),
        (u'oMGdot-BDS', _NavModel_BDSKeplerianSet_oMGdot_BDS),
        (u'i0-BDS', _NavModel_BDSKeplerianSet_i0_BDS),
        (u'iDOT-BDS', _NavModel_BDSKeplerianSet_iDOT_BDS),
        (u'cuc-BDS', _NavModel_BDSKeplerianSet_cuc_BDS),
        (u'cus-BDS', _NavModel_BDSKeplerianSet_cus_BDS),
        (u'crc-BDS', _NavModel_BDSKeplerianSet_crc_BDS),
        (u'crs-BDS', _NavModel_BDSKeplerianSet_crs_BDS),
        (u'cic-BDS', _NavModel_BDSKeplerianSet_cic_BDS),
        (u'cis-BDS', _NavModel_BDSKeplerianSet_cis_BDS),
        (u'aODE-BDS', _NavModel_BDSKeplerianSet_aODE_BDS),
        (u'ie-Extensions', _NavModel_BDSKeplerianSet_ie_Extensions),
        ])
    NavModel_BDSKeplerianSet._ext = []
    
    #-----< NavModel-BDSKeplerianSet-ExtIEs >-----#
    NavModel_BDSKeplerianSet_ExtIEs = CLASS(name=u'NavModel-BDSKeplerianSet-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    NavModel_BDSKeplerianSet_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< SBASclockModel >-----#
    SBASclockModel = SEQ(name=u'SBASclockModel', mode=MODE_TYPE)
    _SBASclockModel_sbasTo = BIT_STR(name=u'sbasTo', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _SBASclockModel_sbasTo._const_sz = ASN1Set(rv=[13], rr=[], ev=None, er=[])
    _SBASclockModel_sbasAgfo = BIT_STR(name=u'sbasAgfo', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _SBASclockModel_sbasAgfo._const_sz = ASN1Set(rv=[12], rr=[], ev=None, er=[])
    _SBASclockModel_sbasAgf1 = BIT_STR(name=u'sbasAgf1', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _SBASclockModel_sbasAgf1._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _SBASclockModel_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __SBASclockModel_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___SBASclockModel_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____SBASclockModel_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____SBASclockModel_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___SBASclockModel_ie_Extensions__item__id._const_tab = ____SBASclockModel_ie_Extensions__item__id_tab
    ___SBASclockModel_ie_Extensions__item__id._const_tab_at = None
    ___SBASclockModel_ie_Extensions__item__id._const_tab_id = u'id'
    ___SBASclockModel_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____SBASclockModel_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____SBASclockModel_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___SBASclockModel_ie_Extensions__item__criticality._const_tab = ____SBASclockModel_ie_Extensions__item__criticality_tab
    ___SBASclockModel_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___SBASclockModel_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___SBASclockModel_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____SBASclockModel_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____SBASclockModel_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___SBASclockModel_ie_Extensions__item__extensionValue._const_tab = ____SBASclockModel_ie_Extensions__item__extensionValue_tab
    ___SBASclockModel_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___SBASclockModel_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __SBASclockModel_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___SBASclockModel_ie_Extensions__item__id),
        (u'criticality', ___SBASclockModel_ie_Extensions__item__criticality),
        (u'extensionValue', ___SBASclockModel_ie_Extensions__item__extensionValue),
        ])
    __SBASclockModel_ie_Extensions__item_._ext = None
    _SBASclockModel_ie_Extensions._cont = __SBASclockModel_ie_Extensions__item_
    _SBASclockModel_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    SBASclockModel._cont = ASN1Dict([
        (u'sbasTo', _SBASclockModel_sbasTo),
        (u'sbasAgfo', _SBASclockModel_sbasAgfo),
        (u'sbasAgf1', _SBASclockModel_sbasAgf1),
        (u'ie-Extensions', _SBASclockModel_ie_Extensions),
        ])
    SBASclockModel._ext = []
    
    #-----< SBASclockModel-ExtIEs >-----#
    SBASclockModel_ExtIEs = CLASS(name=u'SBASclockModel-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    SBASclockModel_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< BDSClockModel >-----#
    BDSClockModel = SEQ(name=u'BDSClockModel', mode=MODE_TYPE)
    _BDSClockModel_toc_BDS = BIT_STR(name=u'toc-BDS', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _BDSClockModel_toc_BDS._const_sz = ASN1Set(rv=[17], rr=[], ev=None, er=[])
    _BDSClockModel_a0_BDS = BIT_STR(name=u'a0-BDS', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _BDSClockModel_a0_BDS._const_sz = ASN1Set(rv=[24], rr=[], ev=None, er=[])
    _BDSClockModel_a1_BDS = BIT_STR(name=u'a1-BDS', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _BDSClockModel_a1_BDS._const_sz = ASN1Set(rv=[22], rr=[], ev=None, er=[])
    _BDSClockModel_a2_BDS = BIT_STR(name=u'a2-BDS', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _BDSClockModel_a2_BDS._const_sz = ASN1Set(rv=[11], rr=[], ev=None, er=[])
    _BDSClockModel_tGD1_BDS = BIT_STR(name=u'tGD1-BDS', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _BDSClockModel_tGD1_BDS._const_sz = ASN1Set(rv=[10], rr=[], ev=None, er=[])
    _BDSClockModel_aODC_BDS = BIT_STR(name=u'aODC-BDS', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _BDSClockModel_aODC_BDS._const_sz = ASN1Set(rv=[5], rr=[], ev=None, er=[])
    _BDSClockModel_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __BDSClockModel_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___BDSClockModel_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____BDSClockModel_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____BDSClockModel_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___BDSClockModel_ie_Extensions__item__id._const_tab = ____BDSClockModel_ie_Extensions__item__id_tab
    ___BDSClockModel_ie_Extensions__item__id._const_tab_at = None
    ___BDSClockModel_ie_Extensions__item__id._const_tab_id = u'id'
    ___BDSClockModel_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____BDSClockModel_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____BDSClockModel_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___BDSClockModel_ie_Extensions__item__criticality._const_tab = ____BDSClockModel_ie_Extensions__item__criticality_tab
    ___BDSClockModel_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___BDSClockModel_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___BDSClockModel_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____BDSClockModel_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____BDSClockModel_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___BDSClockModel_ie_Extensions__item__extensionValue._const_tab = ____BDSClockModel_ie_Extensions__item__extensionValue_tab
    ___BDSClockModel_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___BDSClockModel_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __BDSClockModel_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___BDSClockModel_ie_Extensions__item__id),
        (u'criticality', ___BDSClockModel_ie_Extensions__item__criticality),
        (u'extensionValue', ___BDSClockModel_ie_Extensions__item__extensionValue),
        ])
    __BDSClockModel_ie_Extensions__item_._ext = None
    _BDSClockModel_ie_Extensions._cont = __BDSClockModel_ie_Extensions__item_
    _BDSClockModel_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    BDSClockModel._cont = ASN1Dict([
        (u'toc-BDS', _BDSClockModel_toc_BDS),
        (u'a0-BDS', _BDSClockModel_a0_BDS),
        (u'a1-BDS', _BDSClockModel_a1_BDS),
        (u'a2-BDS', _BDSClockModel_a2_BDS),
        (u'tGD1-BDS', _BDSClockModel_tGD1_BDS),
        (u'aODC-BDS', _BDSClockModel_aODC_BDS),
        (u'ie-Extensions', _BDSClockModel_ie_Extensions),
        ])
    BDSClockModel._ext = []
    
    #-----< BDSClockModel-ExtIEs >-----#
    BDSClockModel_ExtIEs = CLASS(name=u'BDSClockModel-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    BDSClockModel_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< UTCmodelSet1 >-----#
    UTCmodelSet1 = SEQ(name=u'UTCmodelSet1', mode=MODE_TYPE)
    _UTCmodelSet1_utcA0 = BIT_STR(name=u'utcA0', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTCmodelSet1_utcA0._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _UTCmodelSet1_utcA1 = BIT_STR(name=u'utcA1', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTCmodelSet1_utcA1._const_sz = ASN1Set(rv=[13], rr=[], ev=None, er=[])
    _UTCmodelSet1_utcA2 = BIT_STR(name=u'utcA2', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTCmodelSet1_utcA2._const_sz = ASN1Set(rv=[7], rr=[], ev=None, er=[])
    _UTCmodelSet1_utcDeltaTls = BIT_STR(name=u'utcDeltaTls', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTCmodelSet1_utcDeltaTls._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _UTCmodelSet1_utcTot = BIT_STR(name=u'utcTot', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTCmodelSet1_utcTot._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _UTCmodelSet1_utcWNot = BIT_STR(name=u'utcWNot', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTCmodelSet1_utcWNot._const_sz = ASN1Set(rv=[13], rr=[], ev=None, er=[])
    _UTCmodelSet1_utcWNlsf = BIT_STR(name=u'utcWNlsf', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTCmodelSet1_utcWNlsf._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _UTCmodelSet1_utcDN = BIT_STR(name=u'utcDN', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTCmodelSet1_utcDN._const_sz = ASN1Set(rv=[4], rr=[], ev=None, er=[])
    _UTCmodelSet1_utcDeltaTlsf = BIT_STR(name=u'utcDeltaTlsf', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTCmodelSet1_utcDeltaTlsf._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _UTCmodelSet1_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __UTCmodelSet1_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___UTCmodelSet1_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____UTCmodelSet1_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____UTCmodelSet1_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___UTCmodelSet1_ie_Extensions__item__id._const_tab = ____UTCmodelSet1_ie_Extensions__item__id_tab
    ___UTCmodelSet1_ie_Extensions__item__id._const_tab_at = None
    ___UTCmodelSet1_ie_Extensions__item__id._const_tab_id = u'id'
    ___UTCmodelSet1_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____UTCmodelSet1_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____UTCmodelSet1_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___UTCmodelSet1_ie_Extensions__item__criticality._const_tab = ____UTCmodelSet1_ie_Extensions__item__criticality_tab
    ___UTCmodelSet1_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___UTCmodelSet1_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___UTCmodelSet1_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____UTCmodelSet1_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____UTCmodelSet1_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___UTCmodelSet1_ie_Extensions__item__extensionValue._const_tab = ____UTCmodelSet1_ie_Extensions__item__extensionValue_tab
    ___UTCmodelSet1_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___UTCmodelSet1_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __UTCmodelSet1_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___UTCmodelSet1_ie_Extensions__item__id),
        (u'criticality', ___UTCmodelSet1_ie_Extensions__item__criticality),
        (u'extensionValue', ___UTCmodelSet1_ie_Extensions__item__extensionValue),
        ])
    __UTCmodelSet1_ie_Extensions__item_._ext = None
    _UTCmodelSet1_ie_Extensions._cont = __UTCmodelSet1_ie_Extensions__item_
    _UTCmodelSet1_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    UTCmodelSet1._cont = ASN1Dict([
        (u'utcA0', _UTCmodelSet1_utcA0),
        (u'utcA1', _UTCmodelSet1_utcA1),
        (u'utcA2', _UTCmodelSet1_utcA2),
        (u'utcDeltaTls', _UTCmodelSet1_utcDeltaTls),
        (u'utcTot', _UTCmodelSet1_utcTot),
        (u'utcWNot', _UTCmodelSet1_utcWNot),
        (u'utcWNlsf', _UTCmodelSet1_utcWNlsf),
        (u'utcDN', _UTCmodelSet1_utcDN),
        (u'utcDeltaTlsf', _UTCmodelSet1_utcDeltaTlsf),
        (u'ie-Extensions', _UTCmodelSet1_ie_Extensions),
        ])
    UTCmodelSet1._ext = []
    
    #-----< UTCmodelSet1-ExtIEs >-----#
    UTCmodelSet1_ExtIEs = CLASS(name=u'UTCmodelSet1-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    UTCmodelSet1_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< UTCmodelSet2 >-----#
    UTCmodelSet2 = SEQ(name=u'UTCmodelSet2', mode=MODE_TYPE)
    _UTCmodelSet2_nA = BIT_STR(name=u'nA', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTCmodelSet2_nA._const_sz = ASN1Set(rv=[11], rr=[], ev=None, er=[])
    _UTCmodelSet2_tauC = BIT_STR(name=u'tauC', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTCmodelSet2_tauC._const_sz = ASN1Set(rv=[32], rr=[], ev=None, er=[])
    _UTCmodelSet2_deltaUT1 = SEQ(name=u'deltaUT1', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'DeltaUT1')), opt=True)
    _UTCmodelSet2_kp = BIT_STR(name=u'kp', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _UTCmodelSet2_kp._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    _UTCmodelSet2_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __UTCmodelSet2_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___UTCmodelSet2_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____UTCmodelSet2_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____UTCmodelSet2_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___UTCmodelSet2_ie_Extensions__item__id._const_tab = ____UTCmodelSet2_ie_Extensions__item__id_tab
    ___UTCmodelSet2_ie_Extensions__item__id._const_tab_at = None
    ___UTCmodelSet2_ie_Extensions__item__id._const_tab_id = u'id'
    ___UTCmodelSet2_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____UTCmodelSet2_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____UTCmodelSet2_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___UTCmodelSet2_ie_Extensions__item__criticality._const_tab = ____UTCmodelSet2_ie_Extensions__item__criticality_tab
    ___UTCmodelSet2_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___UTCmodelSet2_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___UTCmodelSet2_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____UTCmodelSet2_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____UTCmodelSet2_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___UTCmodelSet2_ie_Extensions__item__extensionValue._const_tab = ____UTCmodelSet2_ie_Extensions__item__extensionValue_tab
    ___UTCmodelSet2_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___UTCmodelSet2_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __UTCmodelSet2_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___UTCmodelSet2_ie_Extensions__item__id),
        (u'criticality', ___UTCmodelSet2_ie_Extensions__item__criticality),
        (u'extensionValue', ___UTCmodelSet2_ie_Extensions__item__extensionValue),
        ])
    __UTCmodelSet2_ie_Extensions__item_._ext = None
    _UTCmodelSet2_ie_Extensions._cont = __UTCmodelSet2_ie_Extensions__item_
    _UTCmodelSet2_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    UTCmodelSet2._cont = ASN1Dict([
        (u'nA', _UTCmodelSet2_nA),
        (u'tauC', _UTCmodelSet2_tauC),
        (u'deltaUT1', _UTCmodelSet2_deltaUT1),
        (u'kp', _UTCmodelSet2_kp),
        (u'ie-Extensions', _UTCmodelSet2_ie_Extensions),
        ])
    UTCmodelSet2._ext = []
    
    #-----< UTCmodelSet2-ExtIEs >-----#
    UTCmodelSet2_ExtIEs = CLASS(name=u'UTCmodelSet2-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    UTCmodelSet2_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< UTCmodelSet3 >-----#
    UTCmodelSet3 = SEQ(name=u'UTCmodelSet3', mode=MODE_TYPE)
    _UTCmodelSet3_utcA1wnt = BIT_STR(name=u'utcA1wnt', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTCmodelSet3_utcA1wnt._const_sz = ASN1Set(rv=[24], rr=[], ev=None, er=[])
    _UTCmodelSet3_utcA0wnt = BIT_STR(name=u'utcA0wnt', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTCmodelSet3_utcA0wnt._const_sz = ASN1Set(rv=[32], rr=[], ev=None, er=[])
    _UTCmodelSet3_utcTot = BIT_STR(name=u'utcTot', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTCmodelSet3_utcTot._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _UTCmodelSet3_utcWNt = BIT_STR(name=u'utcWNt', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTCmodelSet3_utcWNt._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _UTCmodelSet3_utcDeltaTls = BIT_STR(name=u'utcDeltaTls', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTCmodelSet3_utcDeltaTls._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _UTCmodelSet3_utcWNlsf = BIT_STR(name=u'utcWNlsf', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTCmodelSet3_utcWNlsf._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _UTCmodelSet3_utcDN = BIT_STR(name=u'utcDN', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTCmodelSet3_utcDN._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _UTCmodelSet3_utcDeltaTlsf = BIT_STR(name=u'utcDeltaTlsf', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTCmodelSet3_utcDeltaTlsf._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _UTCmodelSet3_utcStandardID = BIT_STR(name=u'utcStandardID', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTCmodelSet3_utcStandardID._const_sz = ASN1Set(rv=[3], rr=[], ev=None, er=[])
    _UTCmodelSet3_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __UTCmodelSet3_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___UTCmodelSet3_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____UTCmodelSet3_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____UTCmodelSet3_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___UTCmodelSet3_ie_Extensions__item__id._const_tab = ____UTCmodelSet3_ie_Extensions__item__id_tab
    ___UTCmodelSet3_ie_Extensions__item__id._const_tab_at = None
    ___UTCmodelSet3_ie_Extensions__item__id._const_tab_id = u'id'
    ___UTCmodelSet3_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____UTCmodelSet3_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____UTCmodelSet3_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___UTCmodelSet3_ie_Extensions__item__criticality._const_tab = ____UTCmodelSet3_ie_Extensions__item__criticality_tab
    ___UTCmodelSet3_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___UTCmodelSet3_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___UTCmodelSet3_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____UTCmodelSet3_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____UTCmodelSet3_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___UTCmodelSet3_ie_Extensions__item__extensionValue._const_tab = ____UTCmodelSet3_ie_Extensions__item__extensionValue_tab
    ___UTCmodelSet3_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___UTCmodelSet3_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __UTCmodelSet3_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___UTCmodelSet3_ie_Extensions__item__id),
        (u'criticality', ___UTCmodelSet3_ie_Extensions__item__criticality),
        (u'extensionValue', ___UTCmodelSet3_ie_Extensions__item__extensionValue),
        ])
    __UTCmodelSet3_ie_Extensions__item_._ext = None
    _UTCmodelSet3_ie_Extensions._cont = __UTCmodelSet3_ie_Extensions__item_
    _UTCmodelSet3_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    UTCmodelSet3._cont = ASN1Dict([
        (u'utcA1wnt', _UTCmodelSet3_utcA1wnt),
        (u'utcA0wnt', _UTCmodelSet3_utcA0wnt),
        (u'utcTot', _UTCmodelSet3_utcTot),
        (u'utcWNt', _UTCmodelSet3_utcWNt),
        (u'utcDeltaTls', _UTCmodelSet3_utcDeltaTls),
        (u'utcWNlsf', _UTCmodelSet3_utcWNlsf),
        (u'utcDN', _UTCmodelSet3_utcDN),
        (u'utcDeltaTlsf', _UTCmodelSet3_utcDeltaTlsf),
        (u'utcStandardID', _UTCmodelSet3_utcStandardID),
        (u'ie-Extensions', _UTCmodelSet3_ie_Extensions),
        ])
    UTCmodelSet3._ext = []
    
    #-----< UTCmodelSet3-ExtIEs >-----#
    UTCmodelSet3_ExtIEs = CLASS(name=u'UTCmodelSet3-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    UTCmodelSet3_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< UTCmodelSet4 >-----#
    UTCmodelSet4 = SEQ(name=u'UTCmodelSet4', mode=MODE_TYPE)
    _UTCmodelSet4_utca0_BDS = BIT_STR(name=u'utca0-BDS', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTCmodelSet4_utca0_BDS._const_sz = ASN1Set(rv=[32], rr=[], ev=None, er=[])
    _UTCmodelSet4_utca1_BDS = BIT_STR(name=u'utca1-BDS', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTCmodelSet4_utca1_BDS._const_sz = ASN1Set(rv=[24], rr=[], ev=None, er=[])
    _UTCmodelSet4_utcDeltatLS_BDS = BIT_STR(name=u'utcDeltatLS-BDS', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTCmodelSet4_utcDeltatLS_BDS._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _UTCmodelSet4_utcWNt = BIT_STR(name=u'utcWNt', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTCmodelSet4_utcWNt._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _UTCmodelSet4_utcDeltaTls = BIT_STR(name=u'utcDeltaTls', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTCmodelSet4_utcDeltaTls._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _UTCmodelSet4_utcWNlsf_BDS = BIT_STR(name=u'utcWNlsf-BDS', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTCmodelSet4_utcWNlsf_BDS._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _UTCmodelSet4_utcDN_BDS = BIT_STR(name=u'utcDN-BDS', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTCmodelSet4_utcDN_BDS._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _UTCmodelSet4_utcDeltaTlsf_BDS = BIT_STR(name=u'utcDeltaTlsf-BDS', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTCmodelSet4_utcDeltaTlsf_BDS._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _UTCmodelSet4_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __UTCmodelSet4_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___UTCmodelSet4_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____UTCmodelSet4_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____UTCmodelSet4_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___UTCmodelSet4_ie_Extensions__item__id._const_tab = ____UTCmodelSet4_ie_Extensions__item__id_tab
    ___UTCmodelSet4_ie_Extensions__item__id._const_tab_at = None
    ___UTCmodelSet4_ie_Extensions__item__id._const_tab_id = u'id'
    ___UTCmodelSet4_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____UTCmodelSet4_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____UTCmodelSet4_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___UTCmodelSet4_ie_Extensions__item__criticality._const_tab = ____UTCmodelSet4_ie_Extensions__item__criticality_tab
    ___UTCmodelSet4_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___UTCmodelSet4_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___UTCmodelSet4_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____UTCmodelSet4_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____UTCmodelSet4_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___UTCmodelSet4_ie_Extensions__item__extensionValue._const_tab = ____UTCmodelSet4_ie_Extensions__item__extensionValue_tab
    ___UTCmodelSet4_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___UTCmodelSet4_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __UTCmodelSet4_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___UTCmodelSet4_ie_Extensions__item__id),
        (u'criticality', ___UTCmodelSet4_ie_Extensions__item__criticality),
        (u'extensionValue', ___UTCmodelSet4_ie_Extensions__item__extensionValue),
        ])
    __UTCmodelSet4_ie_Extensions__item_._ext = None
    _UTCmodelSet4_ie_Extensions._cont = __UTCmodelSet4_ie_Extensions__item_
    _UTCmodelSet4_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    UTCmodelSet4._cont = ASN1Dict([
        (u'utca0-BDS', _UTCmodelSet4_utca0_BDS),
        (u'utca1-BDS', _UTCmodelSet4_utca1_BDS),
        (u'utcDeltatLS-BDS', _UTCmodelSet4_utcDeltatLS_BDS),
        (u'utcWNt', _UTCmodelSet4_utcWNt),
        (u'utcDeltaTls', _UTCmodelSet4_utcDeltaTls),
        (u'utcWNlsf-BDS', _UTCmodelSet4_utcWNlsf_BDS),
        (u'utcDN-BDS', _UTCmodelSet4_utcDN_BDS),
        (u'utcDeltaTlsf-BDS', _UTCmodelSet4_utcDeltaTlsf_BDS),
        (u'ie-Extensions', _UTCmodelSet4_ie_Extensions),
        ])
    UTCmodelSet4._ext = []
    
    #-----< UTCmodelSet4-ExtIEs >-----#
    UTCmodelSet4_ExtIEs = CLASS(name=u'UTCmodelSet4-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    UTCmodelSet4_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< UTRAN-GANSSReferenceTimeDL >-----#
    UTRAN_GANSSReferenceTimeDL = SEQ(name=u'UTRAN-GANSSReferenceTimeDL', mode=MODE_TYPE)
    _UTRAN_GANSSReferenceTimeDL_utran_GANSSTimingOfCellFrames = INT(name=u'utran-GANSSTimingOfCellFrames', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTRAN_GANSSReferenceTimeDL_utran_GANSSTimingOfCellFrames._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=3999999)], ev=None, er=[])
    _UTRAN_GANSSReferenceTimeDL_uC_ID = SEQ(name=u'uC-ID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'UC-ID')), opt=True)
    _UTRAN_GANSSReferenceTimeDL_referenceSfn = INT(name=u'referenceSfn', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTRAN_GANSSReferenceTimeDL_referenceSfn._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4095)], ev=None, er=[])
    _UTRAN_GANSSReferenceTimeDL_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __UTRAN_GANSSReferenceTimeDL_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___UTRAN_GANSSReferenceTimeDL_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____UTRAN_GANSSReferenceTimeDL_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____UTRAN_GANSSReferenceTimeDL_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___UTRAN_GANSSReferenceTimeDL_ie_Extensions__item__id._const_tab = ____UTRAN_GANSSReferenceTimeDL_ie_Extensions__item__id_tab
    ___UTRAN_GANSSReferenceTimeDL_ie_Extensions__item__id._const_tab_at = None
    ___UTRAN_GANSSReferenceTimeDL_ie_Extensions__item__id._const_tab_id = u'id'
    ___UTRAN_GANSSReferenceTimeDL_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____UTRAN_GANSSReferenceTimeDL_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____UTRAN_GANSSReferenceTimeDL_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___UTRAN_GANSSReferenceTimeDL_ie_Extensions__item__criticality._const_tab = ____UTRAN_GANSSReferenceTimeDL_ie_Extensions__item__criticality_tab
    ___UTRAN_GANSSReferenceTimeDL_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___UTRAN_GANSSReferenceTimeDL_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___UTRAN_GANSSReferenceTimeDL_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____UTRAN_GANSSReferenceTimeDL_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____UTRAN_GANSSReferenceTimeDL_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___UTRAN_GANSSReferenceTimeDL_ie_Extensions__item__extensionValue._const_tab = ____UTRAN_GANSSReferenceTimeDL_ie_Extensions__item__extensionValue_tab
    ___UTRAN_GANSSReferenceTimeDL_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___UTRAN_GANSSReferenceTimeDL_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __UTRAN_GANSSReferenceTimeDL_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___UTRAN_GANSSReferenceTimeDL_ie_Extensions__item__id),
        (u'criticality', ___UTRAN_GANSSReferenceTimeDL_ie_Extensions__item__criticality),
        (u'extensionValue', ___UTRAN_GANSSReferenceTimeDL_ie_Extensions__item__extensionValue),
        ])
    __UTRAN_GANSSReferenceTimeDL_ie_Extensions__item_._ext = None
    _UTRAN_GANSSReferenceTimeDL_ie_Extensions._cont = __UTRAN_GANSSReferenceTimeDL_ie_Extensions__item_
    _UTRAN_GANSSReferenceTimeDL_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    UTRAN_GANSSReferenceTimeDL._cont = ASN1Dict([
        (u'utran-GANSSTimingOfCellFrames', _UTRAN_GANSSReferenceTimeDL_utran_GANSSTimingOfCellFrames),
        (u'uC-ID', _UTRAN_GANSSReferenceTimeDL_uC_ID),
        (u'referenceSfn', _UTRAN_GANSSReferenceTimeDL_referenceSfn),
        (u'ie-Extensions', _UTRAN_GANSSReferenceTimeDL_ie_Extensions),
        ])
    UTRAN_GANSSReferenceTimeDL._ext = []
    
    #-----< UTRAN-GANSSReferenceTimeDL-ExtIEs >-----#
    UTRAN_GANSSReferenceTimeDL_ExtIEs = CLASS(name=u'UTRAN-GANSSReferenceTimeDL-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    UTRAN_GANSSReferenceTimeDL_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< UTRAN-GANSSReferenceTimeUL >-----#
    UTRAN_GANSSReferenceTimeUL = SEQ(name=u'UTRAN-GANSSReferenceTimeUL', mode=MODE_TYPE)
    _UTRAN_GANSSReferenceTimeUL_ue_GANSSTimingOfCellFrames = INT(name=u'ue-GANSSTimingOfCellFrames', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTRAN_GANSSReferenceTimeUL_ue_GANSSTimingOfCellFrames._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=345599999999)], ev=None, er=[])
    _UTRAN_GANSSReferenceTimeUL_gANSS_TimeId = SEQ(name=u'gANSS-TimeId', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSSID')), opt=True)
    _UTRAN_GANSSReferenceTimeUL_gANSS_TimeUncertainty = INT(name=u'gANSS-TimeUncertainty', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _UTRAN_GANSSReferenceTimeUL_gANSS_TimeUncertainty._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    _UTRAN_GANSSReferenceTimeUL_uC_ID = SEQ(name=u'uC-ID', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'UC-ID')))
    _UTRAN_GANSSReferenceTimeUL_referenceSfn = INT(name=u'referenceSfn', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UTRAN_GANSSReferenceTimeUL_referenceSfn._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4095)], ev=None, er=[])
    _UTRAN_GANSSReferenceTimeUL_ie_Extensions = SEQ_OF(name=u'ie-Extensions', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __UTRAN_GANSSReferenceTimeUL_ie_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___UTRAN_GANSSReferenceTimeUL_ie_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____UTRAN_GANSSReferenceTimeUL_ie_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____UTRAN_GANSSReferenceTimeUL_ie_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___UTRAN_GANSSReferenceTimeUL_ie_Extensions__item__id._const_tab = ____UTRAN_GANSSReferenceTimeUL_ie_Extensions__item__id_tab
    ___UTRAN_GANSSReferenceTimeUL_ie_Extensions__item__id._const_tab_at = None
    ___UTRAN_GANSSReferenceTimeUL_ie_Extensions__item__id._const_tab_id = u'id'
    ___UTRAN_GANSSReferenceTimeUL_ie_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____UTRAN_GANSSReferenceTimeUL_ie_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____UTRAN_GANSSReferenceTimeUL_ie_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___UTRAN_GANSSReferenceTimeUL_ie_Extensions__item__criticality._const_tab = ____UTRAN_GANSSReferenceTimeUL_ie_Extensions__item__criticality_tab
    ___UTRAN_GANSSReferenceTimeUL_ie_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___UTRAN_GANSSReferenceTimeUL_ie_Extensions__item__criticality._const_tab_id = u'criticality'
    ___UTRAN_GANSSReferenceTimeUL_ie_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____UTRAN_GANSSReferenceTimeUL_ie_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____UTRAN_GANSSReferenceTimeUL_ie_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___UTRAN_GANSSReferenceTimeUL_ie_Extensions__item__extensionValue._const_tab = ____UTRAN_GANSSReferenceTimeUL_ie_Extensions__item__extensionValue_tab
    ___UTRAN_GANSSReferenceTimeUL_ie_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___UTRAN_GANSSReferenceTimeUL_ie_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __UTRAN_GANSSReferenceTimeUL_ie_Extensions__item_._cont = ASN1Dict([
        (u'id', ___UTRAN_GANSSReferenceTimeUL_ie_Extensions__item__id),
        (u'criticality', ___UTRAN_GANSSReferenceTimeUL_ie_Extensions__item__criticality),
        (u'extensionValue', ___UTRAN_GANSSReferenceTimeUL_ie_Extensions__item__extensionValue),
        ])
    __UTRAN_GANSSReferenceTimeUL_ie_Extensions__item_._ext = None
    _UTRAN_GANSSReferenceTimeUL_ie_Extensions._cont = __UTRAN_GANSSReferenceTimeUL_ie_Extensions__item_
    _UTRAN_GANSSReferenceTimeUL_ie_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    UTRAN_GANSSReferenceTimeUL._cont = ASN1Dict([
        (u'ue-GANSSTimingOfCellFrames', _UTRAN_GANSSReferenceTimeUL_ue_GANSSTimingOfCellFrames),
        (u'gANSS-TimeId', _UTRAN_GANSSReferenceTimeUL_gANSS_TimeId),
        (u'gANSS-TimeUncertainty', _UTRAN_GANSSReferenceTimeUL_gANSS_TimeUncertainty),
        (u'uC-ID', _UTRAN_GANSSReferenceTimeUL_uC_ID),
        (u'referenceSfn', _UTRAN_GANSSReferenceTimeUL_referenceSfn),
        (u'ie-Extensions', _UTRAN_GANSSReferenceTimeUL_ie_Extensions),
        ])
    UTRAN_GANSSReferenceTimeUL._ext = []
    
    #-----< UTRAN-GANSSReferenceTimeUL-ExtIEs >-----#
    UTRAN_GANSSReferenceTimeUL_ExtIEs = CLASS(name=u'UTRAN-GANSSReferenceTimeUL-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    UTRAN_GANSSReferenceTimeUL_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GPS-AlmanacAndSatelliteHealth >-----#
    GPS_AlmanacAndSatelliteHealth = SEQ(name=u'GPS-AlmanacAndSatelliteHealth', mode=MODE_TYPE)
    _GPS_AlmanacAndSatelliteHealth_wn_a = BIT_STR(name=u'wn-a', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_AlmanacAndSatelliteHealth_wn_a._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _GPS_AlmanacAndSatelliteHealth_almanacSatInfoList = SEQ_OF(name=u'almanacSatInfoList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'AlmanacSatInfoList')))
    _GPS_AlmanacAndSatelliteHealth_svGlobalHealth = BIT_STR(name=u'svGlobalHealth', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GPS_AlmanacAndSatelliteHealth_svGlobalHealth._const_sz = ASN1Set(rv=[364], rr=[], ev=None, er=[])
    _GPS_AlmanacAndSatelliteHealth_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GPS_AlmanacAndSatelliteHealth_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GPS_AlmanacAndSatelliteHealth_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GPS_AlmanacAndSatelliteHealth_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____GPS_AlmanacAndSatelliteHealth_iE_Extensions__item__id_tab_val_Extension_0 = BOOL(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'CompleteAlmanacProvided')))
    ____GPS_AlmanacAndSatelliteHealth_iE_Extensions__item__id_tab._val = ASN1Set(rv=[dict([(u'id', 120), (u'criticality', u'ignore'), (u'Extension', _____GPS_AlmanacAndSatelliteHealth_iE_Extensions__item__id_tab_val_Extension_0), (u'presence', u'optional')])], rr=[], ev=None, er=[])
    ___GPS_AlmanacAndSatelliteHealth_iE_Extensions__item__id._const_tab = ____GPS_AlmanacAndSatelliteHealth_iE_Extensions__item__id_tab
    ___GPS_AlmanacAndSatelliteHealth_iE_Extensions__item__id._const_tab_at = None
    ___GPS_AlmanacAndSatelliteHealth_iE_Extensions__item__id._const_tab_id = u'id'
    ___GPS_AlmanacAndSatelliteHealth_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ___GPS_AlmanacAndSatelliteHealth_iE_Extensions__item__criticality._const_tab = ____GPS_AlmanacAndSatelliteHealth_iE_Extensions__item__id_tab
    ___GPS_AlmanacAndSatelliteHealth_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GPS_AlmanacAndSatelliteHealth_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GPS_AlmanacAndSatelliteHealth_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ___GPS_AlmanacAndSatelliteHealth_iE_Extensions__item__extensionValue._const_tab = ____GPS_AlmanacAndSatelliteHealth_iE_Extensions__item__id_tab
    ___GPS_AlmanacAndSatelliteHealth_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GPS_AlmanacAndSatelliteHealth_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GPS_AlmanacAndSatelliteHealth_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GPS_AlmanacAndSatelliteHealth_iE_Extensions__item__id),
        (u'criticality', ___GPS_AlmanacAndSatelliteHealth_iE_Extensions__item__criticality),
        (u'extensionValue', ___GPS_AlmanacAndSatelliteHealth_iE_Extensions__item__extensionValue),
        ])
    __GPS_AlmanacAndSatelliteHealth_iE_Extensions__item_._ext = None
    _GPS_AlmanacAndSatelliteHealth_iE_Extensions._cont = __GPS_AlmanacAndSatelliteHealth_iE_Extensions__item_
    _GPS_AlmanacAndSatelliteHealth_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GPS_AlmanacAndSatelliteHealth._cont = ASN1Dict([
        (u'wn-a', _GPS_AlmanacAndSatelliteHealth_wn_a),
        (u'almanacSatInfoList', _GPS_AlmanacAndSatelliteHealth_almanacSatInfoList),
        (u'svGlobalHealth', _GPS_AlmanacAndSatelliteHealth_svGlobalHealth),
        (u'iE-Extensions', _GPS_AlmanacAndSatelliteHealth_iE_Extensions),
        ])
    GPS_AlmanacAndSatelliteHealth._ext = []
    
    #-----< GPS-AlmanacAndSatelliteHealth-ExtIEs >-----#
    GPS_AlmanacAndSatelliteHealth_ExtIEs = CLASS(name=u'GPS-AlmanacAndSatelliteHealth-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _GPS_AlmanacAndSatelliteHealth_ExtIEs_val_Extension_0 = BOOL(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'CompleteAlmanacProvided')))
    GPS_AlmanacAndSatelliteHealth_ExtIEs._val = ASN1Set(rv=[dict([(u'id', 120), (u'criticality', u'ignore'), (u'Extension', _GPS_AlmanacAndSatelliteHealth_ExtIEs_val_Extension_0), (u'presence', u'optional')])], rr=[], ev=[], er=[])
    
    #-----< CompleteAlmanacProvided >-----#
    CompleteAlmanacProvided = BOOL(name=u'CompleteAlmanacProvided', mode=MODE_TYPE)
    
    #-----< AlmanacSatInfoList >-----#
    AlmanacSatInfoList = SEQ_OF(name=u'AlmanacSatInfoList', mode=MODE_TYPE)
    _AlmanacSatInfoList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'AlmanacSatInfo')))
    AlmanacSatInfoList._cont = _AlmanacSatInfoList__item_
    AlmanacSatInfoList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    
    #-----< AlmanacSatInfo >-----#
    AlmanacSatInfo = SEQ(name=u'AlmanacSatInfo', mode=MODE_TYPE)
    _AlmanacSatInfo_dataID = BIT_STR(name=u'dataID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacSatInfo_dataID._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    _AlmanacSatInfo_satID = INT(name=u'satID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacSatInfo_satID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    _AlmanacSatInfo_e = BIT_STR(name=u'e', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacSatInfo_e._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _AlmanacSatInfo_t_oa = BIT_STR(name=u't-oa', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacSatInfo_t_oa._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _AlmanacSatInfo_deltaI = BIT_STR(name=u'deltaI', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacSatInfo_deltaI._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _AlmanacSatInfo_omegaDot = BIT_STR(name=u'omegaDot', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacSatInfo_omegaDot._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _AlmanacSatInfo_satHealth = BIT_STR(name=u'satHealth', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacSatInfo_satHealth._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _AlmanacSatInfo_a_Sqrt = BIT_STR(name=u'a-Sqrt', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacSatInfo_a_Sqrt._const_sz = ASN1Set(rv=[24], rr=[], ev=None, er=[])
    _AlmanacSatInfo_omega0 = BIT_STR(name=u'omega0', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacSatInfo_omega0._const_sz = ASN1Set(rv=[24], rr=[], ev=None, er=[])
    _AlmanacSatInfo_m0 = BIT_STR(name=u'm0', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacSatInfo_m0._const_sz = ASN1Set(rv=[24], rr=[], ev=None, er=[])
    _AlmanacSatInfo_omega = BIT_STR(name=u'omega', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacSatInfo_omega._const_sz = ASN1Set(rv=[24], rr=[], ev=None, er=[])
    _AlmanacSatInfo_af0 = BIT_STR(name=u'af0', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacSatInfo_af0._const_sz = ASN1Set(rv=[11], rr=[], ev=None, er=[])
    _AlmanacSatInfo_af1 = BIT_STR(name=u'af1', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AlmanacSatInfo_af1._const_sz = ASN1Set(rv=[11], rr=[], ev=None, er=[])
    _AlmanacSatInfo_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __AlmanacSatInfo_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___AlmanacSatInfo_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____AlmanacSatInfo_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____AlmanacSatInfo_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___AlmanacSatInfo_iE_Extensions__item__id._const_tab = ____AlmanacSatInfo_iE_Extensions__item__id_tab
    ___AlmanacSatInfo_iE_Extensions__item__id._const_tab_at = None
    ___AlmanacSatInfo_iE_Extensions__item__id._const_tab_id = u'id'
    ___AlmanacSatInfo_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____AlmanacSatInfo_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____AlmanacSatInfo_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___AlmanacSatInfo_iE_Extensions__item__criticality._const_tab = ____AlmanacSatInfo_iE_Extensions__item__criticality_tab
    ___AlmanacSatInfo_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___AlmanacSatInfo_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___AlmanacSatInfo_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____AlmanacSatInfo_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____AlmanacSatInfo_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___AlmanacSatInfo_iE_Extensions__item__extensionValue._const_tab = ____AlmanacSatInfo_iE_Extensions__item__extensionValue_tab
    ___AlmanacSatInfo_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___AlmanacSatInfo_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __AlmanacSatInfo_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___AlmanacSatInfo_iE_Extensions__item__id),
        (u'criticality', ___AlmanacSatInfo_iE_Extensions__item__criticality),
        (u'extensionValue', ___AlmanacSatInfo_iE_Extensions__item__extensionValue),
        ])
    __AlmanacSatInfo_iE_Extensions__item_._ext = None
    _AlmanacSatInfo_iE_Extensions._cont = __AlmanacSatInfo_iE_Extensions__item_
    _AlmanacSatInfo_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    AlmanacSatInfo._cont = ASN1Dict([
        (u'dataID', _AlmanacSatInfo_dataID),
        (u'satID', _AlmanacSatInfo_satID),
        (u'e', _AlmanacSatInfo_e),
        (u't-oa', _AlmanacSatInfo_t_oa),
        (u'deltaI', _AlmanacSatInfo_deltaI),
        (u'omegaDot', _AlmanacSatInfo_omegaDot),
        (u'satHealth', _AlmanacSatInfo_satHealth),
        (u'a-Sqrt', _AlmanacSatInfo_a_Sqrt),
        (u'omega0', _AlmanacSatInfo_omega0),
        (u'm0', _AlmanacSatInfo_m0),
        (u'omega', _AlmanacSatInfo_omega),
        (u'af0', _AlmanacSatInfo_af0),
        (u'af1', _AlmanacSatInfo_af1),
        (u'iE-Extensions', _AlmanacSatInfo_iE_Extensions),
        ])
    AlmanacSatInfo._ext = []
    
    #-----< AlmanacSatInfo-ExtIEs >-----#
    AlmanacSatInfo_ExtIEs = CLASS(name=u'AlmanacSatInfo-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    AlmanacSatInfo_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GPS-ClockAndEphemerisParameters >-----#
    GPS_ClockAndEphemerisParameters = SEQ(name=u'GPS-ClockAndEphemerisParameters', mode=MODE_TYPE)
    _GPS_ClockAndEphemerisParameters_codeOnL2 = BIT_STR(name=u'codeOnL2', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_ClockAndEphemerisParameters_codeOnL2._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    _GPS_ClockAndEphemerisParameters_uraIndex = BIT_STR(name=u'uraIndex', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_ClockAndEphemerisParameters_uraIndex._const_sz = ASN1Set(rv=[4], rr=[], ev=None, er=[])
    _GPS_ClockAndEphemerisParameters_satHealth = BIT_STR(name=u'satHealth', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_ClockAndEphemerisParameters_satHealth._const_sz = ASN1Set(rv=[6], rr=[], ev=None, er=[])
    _GPS_ClockAndEphemerisParameters_iodc = BIT_STR(name=u'iodc', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_ClockAndEphemerisParameters_iodc._const_sz = ASN1Set(rv=[10], rr=[], ev=None, er=[])
    _GPS_ClockAndEphemerisParameters_l2Pflag = BIT_STR(name=u'l2Pflag', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_ClockAndEphemerisParameters_l2Pflag._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    _GPS_ClockAndEphemerisParameters_sf1Revd = SEQ(name=u'sf1Revd', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'SubFrame1Reserved')))
    _GPS_ClockAndEphemerisParameters_t_GD = BIT_STR(name=u't-GD', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_ClockAndEphemerisParameters_t_GD._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _GPS_ClockAndEphemerisParameters_t_oc = BIT_STR(name=u't-oc', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_ClockAndEphemerisParameters_t_oc._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _GPS_ClockAndEphemerisParameters_af2 = BIT_STR(name=u'af2', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_ClockAndEphemerisParameters_af2._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _GPS_ClockAndEphemerisParameters_af1 = BIT_STR(name=u'af1', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_ClockAndEphemerisParameters_af1._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _GPS_ClockAndEphemerisParameters_af0 = BIT_STR(name=u'af0', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_ClockAndEphemerisParameters_af0._const_sz = ASN1Set(rv=[22], rr=[], ev=None, er=[])
    _GPS_ClockAndEphemerisParameters_c_rs = BIT_STR(name=u'c-rs', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_ClockAndEphemerisParameters_c_rs._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _GPS_ClockAndEphemerisParameters_delta_n = BIT_STR(name=u'delta-n', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_ClockAndEphemerisParameters_delta_n._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _GPS_ClockAndEphemerisParameters_m0 = BIT_STR(name=u'm0', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_ClockAndEphemerisParameters_m0._const_sz = ASN1Set(rv=[32], rr=[], ev=None, er=[])
    _GPS_ClockAndEphemerisParameters_c_uc = BIT_STR(name=u'c-uc', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_ClockAndEphemerisParameters_c_uc._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _GPS_ClockAndEphemerisParameters_e = BIT_STR(name=u'e', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_ClockAndEphemerisParameters_e._const_sz = ASN1Set(rv=[32], rr=[], ev=None, er=[])
    _GPS_ClockAndEphemerisParameters_c_us = BIT_STR(name=u'c-us', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_ClockAndEphemerisParameters_c_us._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _GPS_ClockAndEphemerisParameters_a_Sqrt = BIT_STR(name=u'a-Sqrt', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_ClockAndEphemerisParameters_a_Sqrt._const_sz = ASN1Set(rv=[32], rr=[], ev=None, er=[])
    _GPS_ClockAndEphemerisParameters_t_oe = BIT_STR(name=u't-oe', mode=MODE_TYPE, tag=(18, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_ClockAndEphemerisParameters_t_oe._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _GPS_ClockAndEphemerisParameters_fitInterval = BIT_STR(name=u'fitInterval', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_ClockAndEphemerisParameters_fitInterval._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    _GPS_ClockAndEphemerisParameters_aodo = BIT_STR(name=u'aodo', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_ClockAndEphemerisParameters_aodo._const_sz = ASN1Set(rv=[5], rr=[], ev=None, er=[])
    _GPS_ClockAndEphemerisParameters_c_ic = BIT_STR(name=u'c-ic', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_ClockAndEphemerisParameters_c_ic._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _GPS_ClockAndEphemerisParameters_omega0 = BIT_STR(name=u'omega0', mode=MODE_TYPE, tag=(22, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_ClockAndEphemerisParameters_omega0._const_sz = ASN1Set(rv=[32], rr=[], ev=None, er=[])
    _GPS_ClockAndEphemerisParameters_c_is = BIT_STR(name=u'c-is', mode=MODE_TYPE, tag=(23, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_ClockAndEphemerisParameters_c_is._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _GPS_ClockAndEphemerisParameters_i0 = BIT_STR(name=u'i0', mode=MODE_TYPE, tag=(24, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_ClockAndEphemerisParameters_i0._const_sz = ASN1Set(rv=[32], rr=[], ev=None, er=[])
    _GPS_ClockAndEphemerisParameters_c_rc = BIT_STR(name=u'c-rc', mode=MODE_TYPE, tag=(25, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_ClockAndEphemerisParameters_c_rc._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _GPS_ClockAndEphemerisParameters_omega = BIT_STR(name=u'omega', mode=MODE_TYPE, tag=(26, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_ClockAndEphemerisParameters_omega._const_sz = ASN1Set(rv=[32], rr=[], ev=None, er=[])
    _GPS_ClockAndEphemerisParameters_omegaDot = BIT_STR(name=u'omegaDot', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_ClockAndEphemerisParameters_omegaDot._const_sz = ASN1Set(rv=[24], rr=[], ev=None, er=[])
    _GPS_ClockAndEphemerisParameters_iDot = BIT_STR(name=u'iDot', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_ClockAndEphemerisParameters_iDot._const_sz = ASN1Set(rv=[14], rr=[], ev=None, er=[])
    _GPS_ClockAndEphemerisParameters_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GPS_ClockAndEphemerisParameters_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GPS_ClockAndEphemerisParameters_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GPS_ClockAndEphemerisParameters_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GPS_ClockAndEphemerisParameters_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GPS_ClockAndEphemerisParameters_iE_Extensions__item__id._const_tab = ____GPS_ClockAndEphemerisParameters_iE_Extensions__item__id_tab
    ___GPS_ClockAndEphemerisParameters_iE_Extensions__item__id._const_tab_at = None
    ___GPS_ClockAndEphemerisParameters_iE_Extensions__item__id._const_tab_id = u'id'
    ___GPS_ClockAndEphemerisParameters_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GPS_ClockAndEphemerisParameters_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GPS_ClockAndEphemerisParameters_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GPS_ClockAndEphemerisParameters_iE_Extensions__item__criticality._const_tab = ____GPS_ClockAndEphemerisParameters_iE_Extensions__item__criticality_tab
    ___GPS_ClockAndEphemerisParameters_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GPS_ClockAndEphemerisParameters_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GPS_ClockAndEphemerisParameters_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GPS_ClockAndEphemerisParameters_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GPS_ClockAndEphemerisParameters_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GPS_ClockAndEphemerisParameters_iE_Extensions__item__extensionValue._const_tab = ____GPS_ClockAndEphemerisParameters_iE_Extensions__item__extensionValue_tab
    ___GPS_ClockAndEphemerisParameters_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GPS_ClockAndEphemerisParameters_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GPS_ClockAndEphemerisParameters_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GPS_ClockAndEphemerisParameters_iE_Extensions__item__id),
        (u'criticality', ___GPS_ClockAndEphemerisParameters_iE_Extensions__item__criticality),
        (u'extensionValue', ___GPS_ClockAndEphemerisParameters_iE_Extensions__item__extensionValue),
        ])
    __GPS_ClockAndEphemerisParameters_iE_Extensions__item_._ext = None
    _GPS_ClockAndEphemerisParameters_iE_Extensions._cont = __GPS_ClockAndEphemerisParameters_iE_Extensions__item_
    _GPS_ClockAndEphemerisParameters_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GPS_ClockAndEphemerisParameters._cont = ASN1Dict([
        (u'codeOnL2', _GPS_ClockAndEphemerisParameters_codeOnL2),
        (u'uraIndex', _GPS_ClockAndEphemerisParameters_uraIndex),
        (u'satHealth', _GPS_ClockAndEphemerisParameters_satHealth),
        (u'iodc', _GPS_ClockAndEphemerisParameters_iodc),
        (u'l2Pflag', _GPS_ClockAndEphemerisParameters_l2Pflag),
        (u'sf1Revd', _GPS_ClockAndEphemerisParameters_sf1Revd),
        (u't-GD', _GPS_ClockAndEphemerisParameters_t_GD),
        (u't-oc', _GPS_ClockAndEphemerisParameters_t_oc),
        (u'af2', _GPS_ClockAndEphemerisParameters_af2),
        (u'af1', _GPS_ClockAndEphemerisParameters_af1),
        (u'af0', _GPS_ClockAndEphemerisParameters_af0),
        (u'c-rs', _GPS_ClockAndEphemerisParameters_c_rs),
        (u'delta-n', _GPS_ClockAndEphemerisParameters_delta_n),
        (u'm0', _GPS_ClockAndEphemerisParameters_m0),
        (u'c-uc', _GPS_ClockAndEphemerisParameters_c_uc),
        (u'e', _GPS_ClockAndEphemerisParameters_e),
        (u'c-us', _GPS_ClockAndEphemerisParameters_c_us),
        (u'a-Sqrt', _GPS_ClockAndEphemerisParameters_a_Sqrt),
        (u't-oe', _GPS_ClockAndEphemerisParameters_t_oe),
        (u'fitInterval', _GPS_ClockAndEphemerisParameters_fitInterval),
        (u'aodo', _GPS_ClockAndEphemerisParameters_aodo),
        (u'c-ic', _GPS_ClockAndEphemerisParameters_c_ic),
        (u'omega0', _GPS_ClockAndEphemerisParameters_omega0),
        (u'c-is', _GPS_ClockAndEphemerisParameters_c_is),
        (u'i0', _GPS_ClockAndEphemerisParameters_i0),
        (u'c-rc', _GPS_ClockAndEphemerisParameters_c_rc),
        (u'omega', _GPS_ClockAndEphemerisParameters_omega),
        (u'omegaDot', _GPS_ClockAndEphemerisParameters_omegaDot),
        (u'iDot', _GPS_ClockAndEphemerisParameters_iDot),
        (u'iE-Extensions', _GPS_ClockAndEphemerisParameters_iE_Extensions),
        ])
    GPS_ClockAndEphemerisParameters._ext = []
    
    #-----< GPS-ClockAndEphemerisParameters-ExtIEs >-----#
    GPS_ClockAndEphemerisParameters_ExtIEs = CLASS(name=u'GPS-ClockAndEphemerisParameters-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GPS_ClockAndEphemerisParameters_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< SubFrame1Reserved >-----#
    SubFrame1Reserved = SEQ(name=u'SubFrame1Reserved', mode=MODE_TYPE)
    _SubFrame1Reserved_reserved1 = BIT_STR(name=u'reserved1', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _SubFrame1Reserved_reserved1._const_sz = ASN1Set(rv=[23], rr=[], ev=None, er=[])
    _SubFrame1Reserved_reserved2 = BIT_STR(name=u'reserved2', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _SubFrame1Reserved_reserved2._const_sz = ASN1Set(rv=[24], rr=[], ev=None, er=[])
    _SubFrame1Reserved_reserved3 = BIT_STR(name=u'reserved3', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _SubFrame1Reserved_reserved3._const_sz = ASN1Set(rv=[24], rr=[], ev=None, er=[])
    _SubFrame1Reserved_reserved4 = BIT_STR(name=u'reserved4', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _SubFrame1Reserved_reserved4._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    SubFrame1Reserved._cont = ASN1Dict([
        (u'reserved1', _SubFrame1Reserved_reserved1),
        (u'reserved2', _SubFrame1Reserved_reserved2),
        (u'reserved3', _SubFrame1Reserved_reserved3),
        (u'reserved4', _SubFrame1Reserved_reserved4),
        ])
    SubFrame1Reserved._ext = None
    
    #-----< GPS-Ionospheric-Model >-----#
    GPS_Ionospheric_Model = SEQ(name=u'GPS-Ionospheric-Model', mode=MODE_TYPE)
    _GPS_Ionospheric_Model_alfa0 = BIT_STR(name=u'alfa0', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_Ionospheric_Model_alfa0._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _GPS_Ionospheric_Model_alfa1 = BIT_STR(name=u'alfa1', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_Ionospheric_Model_alfa1._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _GPS_Ionospheric_Model_alfa2 = BIT_STR(name=u'alfa2', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_Ionospheric_Model_alfa2._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _GPS_Ionospheric_Model_alfa3 = BIT_STR(name=u'alfa3', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_Ionospheric_Model_alfa3._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _GPS_Ionospheric_Model_beta0 = BIT_STR(name=u'beta0', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_Ionospheric_Model_beta0._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _GPS_Ionospheric_Model_beta1 = BIT_STR(name=u'beta1', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_Ionospheric_Model_beta1._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _GPS_Ionospheric_Model_beta2 = BIT_STR(name=u'beta2', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_Ionospheric_Model_beta2._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _GPS_Ionospheric_Model_beta3 = BIT_STR(name=u'beta3', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_Ionospheric_Model_beta3._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _GPS_Ionospheric_Model_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GPS_Ionospheric_Model_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GPS_Ionospheric_Model_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GPS_Ionospheric_Model_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GPS_Ionospheric_Model_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GPS_Ionospheric_Model_iE_Extensions__item__id._const_tab = ____GPS_Ionospheric_Model_iE_Extensions__item__id_tab
    ___GPS_Ionospheric_Model_iE_Extensions__item__id._const_tab_at = None
    ___GPS_Ionospheric_Model_iE_Extensions__item__id._const_tab_id = u'id'
    ___GPS_Ionospheric_Model_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GPS_Ionospheric_Model_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GPS_Ionospheric_Model_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GPS_Ionospheric_Model_iE_Extensions__item__criticality._const_tab = ____GPS_Ionospheric_Model_iE_Extensions__item__criticality_tab
    ___GPS_Ionospheric_Model_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GPS_Ionospheric_Model_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GPS_Ionospheric_Model_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GPS_Ionospheric_Model_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GPS_Ionospheric_Model_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GPS_Ionospheric_Model_iE_Extensions__item__extensionValue._const_tab = ____GPS_Ionospheric_Model_iE_Extensions__item__extensionValue_tab
    ___GPS_Ionospheric_Model_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GPS_Ionospheric_Model_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GPS_Ionospheric_Model_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GPS_Ionospheric_Model_iE_Extensions__item__id),
        (u'criticality', ___GPS_Ionospheric_Model_iE_Extensions__item__criticality),
        (u'extensionValue', ___GPS_Ionospheric_Model_iE_Extensions__item__extensionValue),
        ])
    __GPS_Ionospheric_Model_iE_Extensions__item_._ext = None
    _GPS_Ionospheric_Model_iE_Extensions._cont = __GPS_Ionospheric_Model_iE_Extensions__item_
    _GPS_Ionospheric_Model_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GPS_Ionospheric_Model._cont = ASN1Dict([
        (u'alfa0', _GPS_Ionospheric_Model_alfa0),
        (u'alfa1', _GPS_Ionospheric_Model_alfa1),
        (u'alfa2', _GPS_Ionospheric_Model_alfa2),
        (u'alfa3', _GPS_Ionospheric_Model_alfa3),
        (u'beta0', _GPS_Ionospheric_Model_beta0),
        (u'beta1', _GPS_Ionospheric_Model_beta1),
        (u'beta2', _GPS_Ionospheric_Model_beta2),
        (u'beta3', _GPS_Ionospheric_Model_beta3),
        (u'iE-Extensions', _GPS_Ionospheric_Model_iE_Extensions),
        ])
    GPS_Ionospheric_Model._ext = []
    
    #-----< GPS-Ionospheric-Model-ExtIEs >-----#
    GPS_Ionospheric_Model_ExtIEs = CLASS(name=u'GPS-Ionospheric-Model-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GPS_Ionospheric_Model_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< MeasuredResultsList >-----#
    MeasuredResultsList = SEQ_OF(name=u'MeasuredResultsList', mode=MODE_TYPE)
    _MeasuredResultsList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GPS-MeasuredResults')))
    MeasuredResultsList._cont = _MeasuredResultsList__item_
    MeasuredResultsList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=3)], ev=None, er=[])
    
    #-----< GPS-MeasuredResults >-----#
    GPS_MeasuredResults = SEQ(name=u'GPS-MeasuredResults', mode=MODE_TYPE)
    _GPS_MeasuredResults_gps_TOW_1msec = INT(name=u'gps-TOW-1msec', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_MeasuredResults_gps_TOW_1msec._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=604799999)], ev=None, er=[])
    _GPS_MeasuredResults_gps_MeasurementParamList = SEQ_OF(name=u'gps-MeasurementParamList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GPS-MeasurementParamList')))
    _GPS_MeasuredResults_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GPS_MeasuredResults_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GPS_MeasuredResults_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GPS_MeasuredResults_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____GPS_MeasuredResults_iE_Extensions__item__id_tab_val_Extension_0 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'UTRAN-GPSReferenceTimeResult')))
    _____GPS_MeasuredResults_iE_Extensions__item__id_tab_val_Extension_1 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GPSReferenceTimeUncertainty')))
    ____GPS_MeasuredResults_iE_Extensions__item__id_tab._val = ASN1Set(rv=[dict([(u'id', 47), (u'criticality', u'ignore'), (u'Extension', _____GPS_MeasuredResults_iE_Extensions__item__id_tab_val_Extension_0), (u'presence', u'optional')]), dict([(u'id', 85), (u'criticality', u'ignore'), (u'Extension', _____GPS_MeasuredResults_iE_Extensions__item__id_tab_val_Extension_1), (u'presence', u'optional')])], rr=[], ev=None, er=[])
    ___GPS_MeasuredResults_iE_Extensions__item__id._const_tab = ____GPS_MeasuredResults_iE_Extensions__item__id_tab
    ___GPS_MeasuredResults_iE_Extensions__item__id._const_tab_at = None
    ___GPS_MeasuredResults_iE_Extensions__item__id._const_tab_id = u'id'
    ___GPS_MeasuredResults_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ___GPS_MeasuredResults_iE_Extensions__item__criticality._const_tab = ____GPS_MeasuredResults_iE_Extensions__item__id_tab
    ___GPS_MeasuredResults_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GPS_MeasuredResults_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GPS_MeasuredResults_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ___GPS_MeasuredResults_iE_Extensions__item__extensionValue._const_tab = ____GPS_MeasuredResults_iE_Extensions__item__id_tab
    ___GPS_MeasuredResults_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GPS_MeasuredResults_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GPS_MeasuredResults_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GPS_MeasuredResults_iE_Extensions__item__id),
        (u'criticality', ___GPS_MeasuredResults_iE_Extensions__item__criticality),
        (u'extensionValue', ___GPS_MeasuredResults_iE_Extensions__item__extensionValue),
        ])
    __GPS_MeasuredResults_iE_Extensions__item_._ext = None
    _GPS_MeasuredResults_iE_Extensions._cont = __GPS_MeasuredResults_iE_Extensions__item_
    _GPS_MeasuredResults_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GPS_MeasuredResults._cont = ASN1Dict([
        (u'gps-TOW-1msec', _GPS_MeasuredResults_gps_TOW_1msec),
        (u'gps-MeasurementParamList', _GPS_MeasuredResults_gps_MeasurementParamList),
        (u'iE-Extensions', _GPS_MeasuredResults_iE_Extensions),
        ])
    GPS_MeasuredResults._ext = []
    
    #-----< GPS-MeasuredResults-ExtIEs >-----#
    GPS_MeasuredResults_ExtIEs = CLASS(name=u'GPS-MeasuredResults-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _GPS_MeasuredResults_ExtIEs_val_Extension_0 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'UTRAN-GPSReferenceTimeResult')))
    _GPS_MeasuredResults_ExtIEs_val_Extension_1 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GPSReferenceTimeUncertainty')))
    GPS_MeasuredResults_ExtIEs._val = ASN1Set(rv=[dict([(u'id', 47), (u'criticality', u'ignore'), (u'Extension', _GPS_MeasuredResults_ExtIEs_val_Extension_0), (u'presence', u'optional')]), dict([(u'id', 85), (u'criticality', u'ignore'), (u'Extension', _GPS_MeasuredResults_ExtIEs_val_Extension_1), (u'presence', u'optional')])], rr=[], ev=[], er=[])
    
    #-----< GPS-MeasurementParamList >-----#
    GPS_MeasurementParamList = SEQ_OF(name=u'GPS-MeasurementParamList', mode=MODE_TYPE)
    _GPS_MeasurementParamList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GPS-MeasurementParam')))
    GPS_MeasurementParamList._cont = _GPS_MeasurementParamList__item_
    GPS_MeasurementParamList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    
    #-----< GPS-MeasurementParam >-----#
    GPS_MeasurementParam = SEQ(name=u'GPS-MeasurementParam', mode=MODE_TYPE)
    _GPS_MeasurementParam_satelliteID = INT(name=u'satelliteID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_MeasurementParam_satelliteID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    _GPS_MeasurementParam_c_N0 = INT(name=u'c-N0', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_MeasurementParam_c_N0._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    _GPS_MeasurementParam_doppler = INT(name=u'doppler', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_MeasurementParam_doppler._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-32768, ub=32768)], ev=None, er=[])
    _GPS_MeasurementParam_wholeGPS_Chips = INT(name=u'wholeGPS-Chips', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_MeasurementParam_wholeGPS_Chips._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=1022)], ev=None, er=[])
    _GPS_MeasurementParam_fractionalGPS_Chips = INT(name=u'fractionalGPS-Chips', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_MeasurementParam_fractionalGPS_Chips._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=1023)], ev=None, er=[])
    _GPS_MeasurementParam_multipathIndicator = ENUM(name=u'multipathIndicator', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'MultipathIndicator')))
    _GPS_MeasurementParam_pseudorangeRMS_Error = INT(name=u'pseudorangeRMS-Error', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_MeasurementParam_pseudorangeRMS_Error._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    _GPS_MeasurementParam_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GPS_MeasurementParam_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GPS_MeasurementParam_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GPS_MeasurementParam_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GPS_MeasurementParam_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GPS_MeasurementParam_iE_Extensions__item__id._const_tab = ____GPS_MeasurementParam_iE_Extensions__item__id_tab
    ___GPS_MeasurementParam_iE_Extensions__item__id._const_tab_at = None
    ___GPS_MeasurementParam_iE_Extensions__item__id._const_tab_id = u'id'
    ___GPS_MeasurementParam_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GPS_MeasurementParam_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GPS_MeasurementParam_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GPS_MeasurementParam_iE_Extensions__item__criticality._const_tab = ____GPS_MeasurementParam_iE_Extensions__item__criticality_tab
    ___GPS_MeasurementParam_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GPS_MeasurementParam_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GPS_MeasurementParam_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GPS_MeasurementParam_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GPS_MeasurementParam_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GPS_MeasurementParam_iE_Extensions__item__extensionValue._const_tab = ____GPS_MeasurementParam_iE_Extensions__item__extensionValue_tab
    ___GPS_MeasurementParam_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GPS_MeasurementParam_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GPS_MeasurementParam_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GPS_MeasurementParam_iE_Extensions__item__id),
        (u'criticality', ___GPS_MeasurementParam_iE_Extensions__item__criticality),
        (u'extensionValue', ___GPS_MeasurementParam_iE_Extensions__item__extensionValue),
        ])
    __GPS_MeasurementParam_iE_Extensions__item_._ext = None
    _GPS_MeasurementParam_iE_Extensions._cont = __GPS_MeasurementParam_iE_Extensions__item_
    _GPS_MeasurementParam_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GPS_MeasurementParam._cont = ASN1Dict([
        (u'satelliteID', _GPS_MeasurementParam_satelliteID),
        (u'c-N0', _GPS_MeasurementParam_c_N0),
        (u'doppler', _GPS_MeasurementParam_doppler),
        (u'wholeGPS-Chips', _GPS_MeasurementParam_wholeGPS_Chips),
        (u'fractionalGPS-Chips', _GPS_MeasurementParam_fractionalGPS_Chips),
        (u'multipathIndicator', _GPS_MeasurementParam_multipathIndicator),
        (u'pseudorangeRMS-Error', _GPS_MeasurementParam_pseudorangeRMS_Error),
        (u'iE-Extensions', _GPS_MeasurementParam_iE_Extensions),
        ])
    GPS_MeasurementParam._ext = []
    
    #-----< MultipathIndicator >-----#
    MultipathIndicator = ENUM(name=u'MultipathIndicator', mode=MODE_TYPE)
    MultipathIndicator._cont = ASN1Dict([(u'nm', 0), (u'low', 1), (u'medium', 2), (u'high', 3)])
    MultipathIndicator._ext = None
    
    #-----< GPS-MeasurementParam-ExtIEs >-----#
    GPS_MeasurementParam_ExtIEs = CLASS(name=u'GPS-MeasurementParam-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GPS_MeasurementParam_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GPS-NavigationModel >-----#
    GPS_NavigationModel = SEQ_OF(name=u'GPS-NavigationModel', mode=MODE_TYPE)
    _GPS_NavigationModel__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'NavigationModelSatInfo')))
    GPS_NavigationModel._cont = _GPS_NavigationModel__item_
    GPS_NavigationModel._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    
    #-----< NavigationModelSatInfo >-----#
    NavigationModelSatInfo = SEQ(name=u'NavigationModelSatInfo', mode=MODE_TYPE)
    _NavigationModelSatInfo_satID = INT(name=u'satID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NavigationModelSatInfo_satID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    _NavigationModelSatInfo_satelliteStatus = ENUM(name=u'satelliteStatus', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'SatelliteStatus')))
    _NavigationModelSatInfo_gps_clockAndEphemerisParms = SEQ(name=u'gps-clockAndEphemerisParms', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GPS-ClockAndEphemerisParameters')), opt=True)
    _NavigationModelSatInfo_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __NavigationModelSatInfo_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___NavigationModelSatInfo_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____NavigationModelSatInfo_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____NavigationModelSatInfo_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___NavigationModelSatInfo_iE_Extensions__item__id._const_tab = ____NavigationModelSatInfo_iE_Extensions__item__id_tab
    ___NavigationModelSatInfo_iE_Extensions__item__id._const_tab_at = None
    ___NavigationModelSatInfo_iE_Extensions__item__id._const_tab_id = u'id'
    ___NavigationModelSatInfo_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____NavigationModelSatInfo_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____NavigationModelSatInfo_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___NavigationModelSatInfo_iE_Extensions__item__criticality._const_tab = ____NavigationModelSatInfo_iE_Extensions__item__criticality_tab
    ___NavigationModelSatInfo_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___NavigationModelSatInfo_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___NavigationModelSatInfo_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____NavigationModelSatInfo_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____NavigationModelSatInfo_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___NavigationModelSatInfo_iE_Extensions__item__extensionValue._const_tab = ____NavigationModelSatInfo_iE_Extensions__item__extensionValue_tab
    ___NavigationModelSatInfo_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___NavigationModelSatInfo_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __NavigationModelSatInfo_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___NavigationModelSatInfo_iE_Extensions__item__id),
        (u'criticality', ___NavigationModelSatInfo_iE_Extensions__item__criticality),
        (u'extensionValue', ___NavigationModelSatInfo_iE_Extensions__item__extensionValue),
        ])
    __NavigationModelSatInfo_iE_Extensions__item_._ext = None
    _NavigationModelSatInfo_iE_Extensions._cont = __NavigationModelSatInfo_iE_Extensions__item_
    _NavigationModelSatInfo_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    NavigationModelSatInfo._cont = ASN1Dict([
        (u'satID', _NavigationModelSatInfo_satID),
        (u'satelliteStatus', _NavigationModelSatInfo_satelliteStatus),
        (u'gps-clockAndEphemerisParms', _NavigationModelSatInfo_gps_clockAndEphemerisParms),
        (u'iE-Extensions', _NavigationModelSatInfo_iE_Extensions),
        ])
    NavigationModelSatInfo._ext = []
    
    #-----< NavigationModelSatInfo-ExtIEs >-----#
    NavigationModelSatInfo_ExtIEs = CLASS(name=u'NavigationModelSatInfo-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    NavigationModelSatInfo_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< SatelliteStatus >-----#
    SatelliteStatus = ENUM(name=u'SatelliteStatus', mode=MODE_TYPE)
    SatelliteStatus._cont = ASN1Dict([(u'ns-NN', 0), (u'es-SN', 1), (u'es-NN', 2), (u'rev2', 3), (u'rev', 4)])
    SatelliteStatus._ext = None
    
    #-----< GPS-RealTimeIntegrity >-----#
    GPS_RealTimeIntegrity = CHOICE(name=u'GPS-RealTimeIntegrity', mode=MODE_TYPE)
    _GPS_RealTimeIntegrity_badSatellites = SEQ_OF(name=u'badSatellites', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'BadSatList')))
    _GPS_RealTimeIntegrity_noBadSatellites = NULL(name=u'noBadSatellites', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'NoBadSatellites')))
    GPS_RealTimeIntegrity._cont = ASN1Dict([
        (u'badSatellites', _GPS_RealTimeIntegrity_badSatellites),
        (u'noBadSatellites', _GPS_RealTimeIntegrity_noBadSatellites),
        ])
    GPS_RealTimeIntegrity._ext = []
    
    #-----< BadSatList >-----#
    BadSatList = SEQ_OF(name=u'BadSatList', mode=MODE_TYPE)
    _BadSatList__item_ = INT(name='_item_', mode=MODE_TYPE)
    _BadSatList__item_._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    BadSatList._cont = _BadSatList__item_
    BadSatList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    
    #-----< NoBadSatellites >-----#
    NoBadSatellites = NULL(name=u'NoBadSatellites', mode=MODE_TYPE)
    
    #-----< GPS-ReferenceLocation >-----#
    GPS_ReferenceLocation = SEQ(name=u'GPS-ReferenceLocation', mode=MODE_TYPE)
    _GPS_ReferenceLocation_ue_PositionEstimate = CHOICE(name=u'ue-PositionEstimate', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'UE-PositionEstimate')))
    _GPS_ReferenceLocation_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GPS_ReferenceLocation_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GPS_ReferenceLocation_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GPS_ReferenceLocation_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GPS_ReferenceLocation_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GPS_ReferenceLocation_iE_Extensions__item__id._const_tab = ____GPS_ReferenceLocation_iE_Extensions__item__id_tab
    ___GPS_ReferenceLocation_iE_Extensions__item__id._const_tab_at = None
    ___GPS_ReferenceLocation_iE_Extensions__item__id._const_tab_id = u'id'
    ___GPS_ReferenceLocation_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GPS_ReferenceLocation_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GPS_ReferenceLocation_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GPS_ReferenceLocation_iE_Extensions__item__criticality._const_tab = ____GPS_ReferenceLocation_iE_Extensions__item__criticality_tab
    ___GPS_ReferenceLocation_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GPS_ReferenceLocation_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GPS_ReferenceLocation_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GPS_ReferenceLocation_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GPS_ReferenceLocation_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GPS_ReferenceLocation_iE_Extensions__item__extensionValue._const_tab = ____GPS_ReferenceLocation_iE_Extensions__item__extensionValue_tab
    ___GPS_ReferenceLocation_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GPS_ReferenceLocation_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GPS_ReferenceLocation_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GPS_ReferenceLocation_iE_Extensions__item__id),
        (u'criticality', ___GPS_ReferenceLocation_iE_Extensions__item__criticality),
        (u'extensionValue', ___GPS_ReferenceLocation_iE_Extensions__item__extensionValue),
        ])
    __GPS_ReferenceLocation_iE_Extensions__item_._ext = None
    _GPS_ReferenceLocation_iE_Extensions._cont = __GPS_ReferenceLocation_iE_Extensions__item_
    _GPS_ReferenceLocation_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GPS_ReferenceLocation._cont = ASN1Dict([
        (u'ue-PositionEstimate', _GPS_ReferenceLocation_ue_PositionEstimate),
        (u'iE-Extensions', _GPS_ReferenceLocation_iE_Extensions),
        ])
    GPS_ReferenceLocation._ext = []
    
    #-----< GPS-ReferenceLocation-ExtIEs >-----#
    GPS_ReferenceLocation_ExtIEs = CLASS(name=u'GPS-ReferenceLocation-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GPS_ReferenceLocation_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GPS-ReferenceTime >-----#
    GPS_ReferenceTime = SEQ(name=u'GPS-ReferenceTime', mode=MODE_TYPE)
    _GPS_ReferenceTime_gps_Week = INT(name=u'gps-Week', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_ReferenceTime_gps_Week._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=1023)], ev=None, er=[])
    _GPS_ReferenceTime_gps_TOW_1msec = INT(name=u'gps-TOW-1msec', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_ReferenceTime_gps_TOW_1msec._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=604799999)], ev=None, er=[])
    _GPS_ReferenceTime_gps_TOW_AssistList = SEQ_OF(name=u'gps-TOW-AssistList', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GPS-TOW-AssistList')), opt=True)
    _GPS_ReferenceTime_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GPS_ReferenceTime_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GPS_ReferenceTime_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GPS_ReferenceTime_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____GPS_ReferenceTime_iE_Extensions__item__id_tab_val_Extension_0 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'UTRAN-GPSReferenceTime')))
    _____GPS_ReferenceTime_iE_Extensions__item__id_tab_val_Extension_1 = ENUM(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GPS-UTRAN-TRU')))
    _____GPS_ReferenceTime_iE_Extensions__item__id_tab_val_Extension_2 = ENUM(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'UTRAN-GPS-DriftRate')))
    _____GPS_ReferenceTime_iE_Extensions__item__id_tab_val_Extension_3 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GPSReferenceTimeUncertainty')))
    _____GPS_ReferenceTime_iE_Extensions__item__id_tab_val_Extension_4 = INT(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GPS-Week-Cycle')))
    ____GPS_ReferenceTime_iE_Extensions__item__id_tab._val = ASN1Set(rv=[dict([(u'id', 46), (u'criticality', u'ignore'), (u'Extension', _____GPS_ReferenceTime_iE_Extensions__item__id_tab_val_Extension_0), (u'presence', u'optional')]), dict([(u'id', 3), (u'criticality', u'ignore'), (u'Extension', _____GPS_ReferenceTime_iE_Extensions__item__id_tab_val_Extension_1), (u'presence', u'optional')]), dict([(u'id', 48), (u'criticality', u'ignore'), (u'Extension', _____GPS_ReferenceTime_iE_Extensions__item__id_tab_val_Extension_2), (u'presence', u'optional')]), dict([(u'id', 85), (u'criticality', u'ignore'), (u'Extension', _____GPS_ReferenceTime_iE_Extensions__item__id_tab_val_Extension_3), (u'presence', u'optional')]), dict([(u'id', 121), (u'criticality', u'ignore'), (u'Extension', _____GPS_ReferenceTime_iE_Extensions__item__id_tab_val_Extension_4), (u'presence', u'optional')])], rr=[], ev=None, er=[])
    ___GPS_ReferenceTime_iE_Extensions__item__id._const_tab = ____GPS_ReferenceTime_iE_Extensions__item__id_tab
    ___GPS_ReferenceTime_iE_Extensions__item__id._const_tab_at = None
    ___GPS_ReferenceTime_iE_Extensions__item__id._const_tab_id = u'id'
    ___GPS_ReferenceTime_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ___GPS_ReferenceTime_iE_Extensions__item__criticality._const_tab = ____GPS_ReferenceTime_iE_Extensions__item__id_tab
    ___GPS_ReferenceTime_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GPS_ReferenceTime_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GPS_ReferenceTime_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ___GPS_ReferenceTime_iE_Extensions__item__extensionValue._const_tab = ____GPS_ReferenceTime_iE_Extensions__item__id_tab
    ___GPS_ReferenceTime_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GPS_ReferenceTime_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GPS_ReferenceTime_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GPS_ReferenceTime_iE_Extensions__item__id),
        (u'criticality', ___GPS_ReferenceTime_iE_Extensions__item__criticality),
        (u'extensionValue', ___GPS_ReferenceTime_iE_Extensions__item__extensionValue),
        ])
    __GPS_ReferenceTime_iE_Extensions__item_._ext = None
    _GPS_ReferenceTime_iE_Extensions._cont = __GPS_ReferenceTime_iE_Extensions__item_
    _GPS_ReferenceTime_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GPS_ReferenceTime._cont = ASN1Dict([
        (u'gps-Week', _GPS_ReferenceTime_gps_Week),
        (u'gps-TOW-1msec', _GPS_ReferenceTime_gps_TOW_1msec),
        (u'gps-TOW-AssistList', _GPS_ReferenceTime_gps_TOW_AssistList),
        (u'iE-Extensions', _GPS_ReferenceTime_iE_Extensions),
        ])
    GPS_ReferenceTime._ext = []
    
    #-----< GPS-ReferenceTime-ExtIEs >-----#
    GPS_ReferenceTime_ExtIEs = CLASS(name=u'GPS-ReferenceTime-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _GPS_ReferenceTime_ExtIEs_val_Extension_0 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'UTRAN-GPSReferenceTime')))
    _GPS_ReferenceTime_ExtIEs_val_Extension_1 = ENUM(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GPS-UTRAN-TRU')))
    _GPS_ReferenceTime_ExtIEs_val_Extension_2 = ENUM(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'UTRAN-GPS-DriftRate')))
    _GPS_ReferenceTime_ExtIEs_val_Extension_3 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GPSReferenceTimeUncertainty')))
    _GPS_ReferenceTime_ExtIEs_val_Extension_4 = INT(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GPS-Week-Cycle')))
    GPS_ReferenceTime_ExtIEs._val = ASN1Set(rv=[dict([(u'id', 46), (u'criticality', u'ignore'), (u'Extension', _GPS_ReferenceTime_ExtIEs_val_Extension_0), (u'presence', u'optional')]), dict([(u'id', 3), (u'criticality', u'ignore'), (u'Extension', _GPS_ReferenceTime_ExtIEs_val_Extension_1), (u'presence', u'optional')]), dict([(u'id', 48), (u'criticality', u'ignore'), (u'Extension', _GPS_ReferenceTime_ExtIEs_val_Extension_2), (u'presence', u'optional')]), dict([(u'id', 85), (u'criticality', u'ignore'), (u'Extension', _GPS_ReferenceTime_ExtIEs_val_Extension_3), (u'presence', u'optional')]), dict([(u'id', 121), (u'criticality', u'ignore'), (u'Extension', _GPS_ReferenceTime_ExtIEs_val_Extension_4), (u'presence', u'optional')])], rr=[], ev=[], er=[])
    
    #-----< GPS-Week-Cycle >-----#
    GPS_Week_Cycle = INT(name=u'GPS-Week-Cycle', mode=MODE_TYPE)
    GPS_Week_Cycle._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=7)], ev=None, er=[])
    
    #-----< GPS-TOW-AssistList >-----#
    GPS_TOW_AssistList = SEQ_OF(name=u'GPS-TOW-AssistList', mode=MODE_TYPE)
    _GPS_TOW_AssistList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GPS-TOW-Assist')))
    GPS_TOW_AssistList._cont = _GPS_TOW_AssistList__item_
    GPS_TOW_AssistList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    
    #-----< GPS-TOW-Assist >-----#
    GPS_TOW_Assist = SEQ(name=u'GPS-TOW-Assist', mode=MODE_TYPE)
    _GPS_TOW_Assist_satID = INT(name=u'satID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_TOW_Assist_satID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    _GPS_TOW_Assist_tlm_Message = BIT_STR(name=u'tlm-Message', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_TOW_Assist_tlm_Message._const_sz = ASN1Set(rv=[14], rr=[], ev=None, er=[])
    _GPS_TOW_Assist_antiSpoof = BOOL(name=u'antiSpoof', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_TOW_Assist_alert = BOOL(name=u'alert', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_TOW_Assist_tlm_Reserved = BIT_STR(name=u'tlm-Reserved', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_TOW_Assist_tlm_Reserved._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    _GPS_TOW_Assist_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GPS_TOW_Assist_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GPS_TOW_Assist_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GPS_TOW_Assist_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GPS_TOW_Assist_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GPS_TOW_Assist_iE_Extensions__item__id._const_tab = ____GPS_TOW_Assist_iE_Extensions__item__id_tab
    ___GPS_TOW_Assist_iE_Extensions__item__id._const_tab_at = None
    ___GPS_TOW_Assist_iE_Extensions__item__id._const_tab_id = u'id'
    ___GPS_TOW_Assist_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GPS_TOW_Assist_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GPS_TOW_Assist_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GPS_TOW_Assist_iE_Extensions__item__criticality._const_tab = ____GPS_TOW_Assist_iE_Extensions__item__criticality_tab
    ___GPS_TOW_Assist_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GPS_TOW_Assist_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GPS_TOW_Assist_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GPS_TOW_Assist_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GPS_TOW_Assist_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GPS_TOW_Assist_iE_Extensions__item__extensionValue._const_tab = ____GPS_TOW_Assist_iE_Extensions__item__extensionValue_tab
    ___GPS_TOW_Assist_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GPS_TOW_Assist_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GPS_TOW_Assist_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GPS_TOW_Assist_iE_Extensions__item__id),
        (u'criticality', ___GPS_TOW_Assist_iE_Extensions__item__criticality),
        (u'extensionValue', ___GPS_TOW_Assist_iE_Extensions__item__extensionValue),
        ])
    __GPS_TOW_Assist_iE_Extensions__item_._ext = None
    _GPS_TOW_Assist_iE_Extensions._cont = __GPS_TOW_Assist_iE_Extensions__item_
    _GPS_TOW_Assist_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GPS_TOW_Assist._cont = ASN1Dict([
        (u'satID', _GPS_TOW_Assist_satID),
        (u'tlm-Message', _GPS_TOW_Assist_tlm_Message),
        (u'antiSpoof', _GPS_TOW_Assist_antiSpoof),
        (u'alert', _GPS_TOW_Assist_alert),
        (u'tlm-Reserved', _GPS_TOW_Assist_tlm_Reserved),
        (u'iE-Extensions', _GPS_TOW_Assist_iE_Extensions),
        ])
    GPS_TOW_Assist._ext = []
    
    #-----< GPS-TOW-Assist-ExtIEs >-----#
    GPS_TOW_Assist_ExtIEs = CLASS(name=u'GPS-TOW-Assist-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GPS_TOW_Assist_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< UTRAN-GPS-DriftRate >-----#
    UTRAN_GPS_DriftRate = ENUM(name=u'UTRAN-GPS-DriftRate', mode=MODE_TYPE)
    UTRAN_GPS_DriftRate._cont = ASN1Dict([(u'utran-GPSDrift0', 0), (u'utran-GPSDrift1', 1), (u'utran-GPSDrift2', 2), (u'utran-GPSDrift5', 3), (u'utran-GPSDrift10', 4), (u'utran-GPSDrift15', 5), (u'utran-GPSDrift25', 6), (u'utran-GPSDrift50', 7), (u'utran-GPSDrift-1', 8), (u'utran-GPSDrift-2', 9), (u'utran-GPSDrift-5', 10), (u'utran-GPSDrift-10', 11), (u'utran-GPSDrift-15', 12), (u'utran-GPSDrift-25', 13), (u'utran-GPSDrift-50', 14)])
    UTRAN_GPS_DriftRate._ext = []
    
    #-----< GPSReferenceTimeUncertainty >-----#
    GPSReferenceTimeUncertainty = SEQ(name=u'GPSReferenceTimeUncertainty', mode=MODE_TYPE)
    _GPSReferenceTimeUncertainty_gps_RefTimeUNC = INT(name=u'gps-RefTimeUNC', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPSReferenceTimeUncertainty_gps_RefTimeUNC._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    _GPSReferenceTimeUncertainty_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GPSReferenceTimeUncertainty_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GPSReferenceTimeUncertainty_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GPSReferenceTimeUncertainty_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GPSReferenceTimeUncertainty_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GPSReferenceTimeUncertainty_iE_Extensions__item__id._const_tab = ____GPSReferenceTimeUncertainty_iE_Extensions__item__id_tab
    ___GPSReferenceTimeUncertainty_iE_Extensions__item__id._const_tab_at = None
    ___GPSReferenceTimeUncertainty_iE_Extensions__item__id._const_tab_id = u'id'
    ___GPSReferenceTimeUncertainty_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GPSReferenceTimeUncertainty_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GPSReferenceTimeUncertainty_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GPSReferenceTimeUncertainty_iE_Extensions__item__criticality._const_tab = ____GPSReferenceTimeUncertainty_iE_Extensions__item__criticality_tab
    ___GPSReferenceTimeUncertainty_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GPSReferenceTimeUncertainty_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GPSReferenceTimeUncertainty_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GPSReferenceTimeUncertainty_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GPSReferenceTimeUncertainty_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GPSReferenceTimeUncertainty_iE_Extensions__item__extensionValue._const_tab = ____GPSReferenceTimeUncertainty_iE_Extensions__item__extensionValue_tab
    ___GPSReferenceTimeUncertainty_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GPSReferenceTimeUncertainty_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GPSReferenceTimeUncertainty_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GPSReferenceTimeUncertainty_iE_Extensions__item__id),
        (u'criticality', ___GPSReferenceTimeUncertainty_iE_Extensions__item__criticality),
        (u'extensionValue', ___GPSReferenceTimeUncertainty_iE_Extensions__item__extensionValue),
        ])
    __GPSReferenceTimeUncertainty_iE_Extensions__item_._ext = None
    _GPSReferenceTimeUncertainty_iE_Extensions._cont = __GPSReferenceTimeUncertainty_iE_Extensions__item_
    _GPSReferenceTimeUncertainty_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GPSReferenceTimeUncertainty._cont = ASN1Dict([
        (u'gps-RefTimeUNC', _GPSReferenceTimeUncertainty_gps_RefTimeUNC),
        (u'iE-Extensions', _GPSReferenceTimeUncertainty_iE_Extensions),
        ])
    GPSReferenceTimeUncertainty._ext = []
    
    #-----< GPSReferenceTimeUncertainty-ExtIEs >-----#
    GPSReferenceTimeUncertainty_ExtIEs = CLASS(name=u'GPSReferenceTimeUncertainty-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GPSReferenceTimeUncertainty_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GPS-Transmission-TOW >-----#
    GPS_Transmission_TOW = INT(name=u'GPS-Transmission-TOW', mode=MODE_TYPE)
    GPS_Transmission_TOW._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=604799)], ev=None, er=[])
    
    #-----< GPS-UTC-Model >-----#
    GPS_UTC_Model = SEQ(name=u'GPS-UTC-Model', mode=MODE_TYPE)
    _GPS_UTC_Model_a1 = BIT_STR(name=u'a1', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_UTC_Model_a1._const_sz = ASN1Set(rv=[24], rr=[], ev=None, er=[])
    _GPS_UTC_Model_a0 = BIT_STR(name=u'a0', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_UTC_Model_a0._const_sz = ASN1Set(rv=[32], rr=[], ev=None, er=[])
    _GPS_UTC_Model_t_ot = BIT_STR(name=u't-ot', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_UTC_Model_t_ot._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _GPS_UTC_Model_delta_t_LS = BIT_STR(name=u'delta-t-LS', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_UTC_Model_delta_t_LS._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _GPS_UTC_Model_wn_t = BIT_STR(name=u'wn-t', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_UTC_Model_wn_t._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _GPS_UTC_Model_wn_lsf = BIT_STR(name=u'wn-lsf', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_UTC_Model_wn_lsf._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _GPS_UTC_Model_dn = BIT_STR(name=u'dn', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_UTC_Model_dn._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _GPS_UTC_Model_delta_t_LSF = BIT_STR(name=u'delta-t-LSF', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GPS_UTC_Model_delta_t_LSF._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    _GPS_UTC_Model_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GPS_UTC_Model_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GPS_UTC_Model_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GPS_UTC_Model_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GPS_UTC_Model_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GPS_UTC_Model_iE_Extensions__item__id._const_tab = ____GPS_UTC_Model_iE_Extensions__item__id_tab
    ___GPS_UTC_Model_iE_Extensions__item__id._const_tab_at = None
    ___GPS_UTC_Model_iE_Extensions__item__id._const_tab_id = u'id'
    ___GPS_UTC_Model_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GPS_UTC_Model_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GPS_UTC_Model_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GPS_UTC_Model_iE_Extensions__item__criticality._const_tab = ____GPS_UTC_Model_iE_Extensions__item__criticality_tab
    ___GPS_UTC_Model_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GPS_UTC_Model_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GPS_UTC_Model_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GPS_UTC_Model_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GPS_UTC_Model_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GPS_UTC_Model_iE_Extensions__item__extensionValue._const_tab = ____GPS_UTC_Model_iE_Extensions__item__extensionValue_tab
    ___GPS_UTC_Model_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GPS_UTC_Model_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GPS_UTC_Model_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GPS_UTC_Model_iE_Extensions__item__id),
        (u'criticality', ___GPS_UTC_Model_iE_Extensions__item__criticality),
        (u'extensionValue', ___GPS_UTC_Model_iE_Extensions__item__extensionValue),
        ])
    __GPS_UTC_Model_iE_Extensions__item_._ext = None
    _GPS_UTC_Model_iE_Extensions._cont = __GPS_UTC_Model_iE_Extensions__item_
    _GPS_UTC_Model_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GPS_UTC_Model._cont = ASN1Dict([
        (u'a1', _GPS_UTC_Model_a1),
        (u'a0', _GPS_UTC_Model_a0),
        (u't-ot', _GPS_UTC_Model_t_ot),
        (u'delta-t-LS', _GPS_UTC_Model_delta_t_LS),
        (u'wn-t', _GPS_UTC_Model_wn_t),
        (u'wn-lsf', _GPS_UTC_Model_wn_lsf),
        (u'dn', _GPS_UTC_Model_dn),
        (u'delta-t-LSF', _GPS_UTC_Model_delta_t_LSF),
        (u'iE-Extensions', _GPS_UTC_Model_iE_Extensions),
        ])
    GPS_UTC_Model._ext = []
    
    #-----< GPS-UTCmodel-ExtIEs >-----#
    GPS_UTCmodel_ExtIEs = CLASS(name=u'GPS-UTCmodel-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GPS_UTCmodel_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GPS-UTRAN-TRU >-----#
    GPS_UTRAN_TRU = ENUM(name=u'GPS-UTRAN-TRU', mode=MODE_TYPE)
    GPS_UTRAN_TRU._cont = ASN1Dict([(u'nsec-50', 0), (u'nsec-500', 1), (u'usec-1', 2), (u'usec-10', 3), (u'msec-1', 4), (u'msec-10', 5), (u'msec-100', 6), (u'unreliable', 7)])
    GPS_UTRAN_TRU._ext = []
    
    #-----< AdditionalGPSAssistDataRequired >-----#
    AdditionalGPSAssistDataRequired = SEQ(name=u'AdditionalGPSAssistDataRequired', mode=MODE_TYPE)
    _AdditionalGPSAssistDataRequired_almanacRequest = BOOL(name=u'almanacRequest', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AdditionalGPSAssistDataRequired_utcModelRequest = BOOL(name=u'utcModelRequest', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AdditionalGPSAssistDataRequired_ionosphericModelRequest = BOOL(name=u'ionosphericModelRequest', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AdditionalGPSAssistDataRequired_navigationModelRequest = BOOL(name=u'navigationModelRequest', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AdditionalGPSAssistDataRequired_dgpsCorrectionsRequest = BOOL(name=u'dgpsCorrectionsRequest', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AdditionalGPSAssistDataRequired_referenceLocationRequest = BOOL(name=u'referenceLocationRequest', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AdditionalGPSAssistDataRequired_referenceTimeRequest = BOOL(name=u'referenceTimeRequest', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AdditionalGPSAssistDataRequired_aquisitionAssistanceRequest = BOOL(name=u'aquisitionAssistanceRequest', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AdditionalGPSAssistDataRequired_realTimeIntegrityRequest = BOOL(name=u'realTimeIntegrityRequest', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AdditionalGPSAssistDataRequired_navModelAddDataRequest = SEQ(name=u'navModelAddDataRequest', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'NavModelAdditionalData')), opt=True)
    _AdditionalGPSAssistDataRequired_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __AdditionalGPSAssistDataRequired_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___AdditionalGPSAssistDataRequired_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____AdditionalGPSAssistDataRequired_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____AdditionalGPSAssistDataRequired_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___AdditionalGPSAssistDataRequired_iE_Extensions__item__id._const_tab = ____AdditionalGPSAssistDataRequired_iE_Extensions__item__id_tab
    ___AdditionalGPSAssistDataRequired_iE_Extensions__item__id._const_tab_at = None
    ___AdditionalGPSAssistDataRequired_iE_Extensions__item__id._const_tab_id = u'id'
    ___AdditionalGPSAssistDataRequired_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____AdditionalGPSAssistDataRequired_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____AdditionalGPSAssistDataRequired_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___AdditionalGPSAssistDataRequired_iE_Extensions__item__criticality._const_tab = ____AdditionalGPSAssistDataRequired_iE_Extensions__item__criticality_tab
    ___AdditionalGPSAssistDataRequired_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___AdditionalGPSAssistDataRequired_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___AdditionalGPSAssistDataRequired_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____AdditionalGPSAssistDataRequired_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____AdditionalGPSAssistDataRequired_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___AdditionalGPSAssistDataRequired_iE_Extensions__item__extensionValue._const_tab = ____AdditionalGPSAssistDataRequired_iE_Extensions__item__extensionValue_tab
    ___AdditionalGPSAssistDataRequired_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___AdditionalGPSAssistDataRequired_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __AdditionalGPSAssistDataRequired_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___AdditionalGPSAssistDataRequired_iE_Extensions__item__id),
        (u'criticality', ___AdditionalGPSAssistDataRequired_iE_Extensions__item__criticality),
        (u'extensionValue', ___AdditionalGPSAssistDataRequired_iE_Extensions__item__extensionValue),
        ])
    __AdditionalGPSAssistDataRequired_iE_Extensions__item_._ext = None
    _AdditionalGPSAssistDataRequired_iE_Extensions._cont = __AdditionalGPSAssistDataRequired_iE_Extensions__item_
    _AdditionalGPSAssistDataRequired_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    AdditionalGPSAssistDataRequired._cont = ASN1Dict([
        (u'almanacRequest', _AdditionalGPSAssistDataRequired_almanacRequest),
        (u'utcModelRequest', _AdditionalGPSAssistDataRequired_utcModelRequest),
        (u'ionosphericModelRequest', _AdditionalGPSAssistDataRequired_ionosphericModelRequest),
        (u'navigationModelRequest', _AdditionalGPSAssistDataRequired_navigationModelRequest),
        (u'dgpsCorrectionsRequest', _AdditionalGPSAssistDataRequired_dgpsCorrectionsRequest),
        (u'referenceLocationRequest', _AdditionalGPSAssistDataRequired_referenceLocationRequest),
        (u'referenceTimeRequest', _AdditionalGPSAssistDataRequired_referenceTimeRequest),
        (u'aquisitionAssistanceRequest', _AdditionalGPSAssistDataRequired_aquisitionAssistanceRequest),
        (u'realTimeIntegrityRequest', _AdditionalGPSAssistDataRequired_realTimeIntegrityRequest),
        (u'navModelAddDataRequest', _AdditionalGPSAssistDataRequired_navModelAddDataRequest),
        (u'iE-Extensions', _AdditionalGPSAssistDataRequired_iE_Extensions),
        ])
    AdditionalGPSAssistDataRequired._ext = []
    
    #-----< AdditionalGPSAssistDataRequired-ExtIEs >-----#
    AdditionalGPSAssistDataRequired_ExtIEs = CLASS(name=u'AdditionalGPSAssistDataRequired-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    AdditionalGPSAssistDataRequired_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< AdditionalGanssAssistDataRequired >-----#
    AdditionalGanssAssistDataRequired = SEQ(name=u'AdditionalGanssAssistDataRequired', mode=MODE_TYPE)
    _AdditionalGanssAssistDataRequired_ganssReferenceTime = BOOL(name=u'ganssReferenceTime', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AdditionalGanssAssistDataRequired_ganssreferenceLocation = BOOL(name=u'ganssreferenceLocation', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AdditionalGanssAssistDataRequired_ganssIonosphericModel = BOOL(name=u'ganssIonosphericModel', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AdditionalGanssAssistDataRequired_ganssRequestedGenericAssistanceDataList = SEQ_OF(name=u'ganssRequestedGenericAssistanceDataList', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GanssRequestedGenericAssistanceDataList')))
    _AdditionalGanssAssistDataRequired_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __AdditionalGanssAssistDataRequired_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___AdditionalGanssAssistDataRequired_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____AdditionalGanssAssistDataRequired_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _____AdditionalGanssAssistDataRequired_iE_Extensions__item__id_tab_val_Extension_0 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSSReq-AddIonosphericModel')))
    _____AdditionalGanssAssistDataRequired_iE_Extensions__item__id_tab_val_Extension_1 = BOOL(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSSReq-EarthOrientPara')))
    ____AdditionalGanssAssistDataRequired_iE_Extensions__item__id_tab._val = ASN1Set(rv=[dict([(u'id', 103), (u'criticality', u'ignore'), (u'Extension', _____AdditionalGanssAssistDataRequired_iE_Extensions__item__id_tab_val_Extension_0), (u'presence', u'optional')]), dict([(u'id', 104), (u'criticality', u'ignore'), (u'Extension', _____AdditionalGanssAssistDataRequired_iE_Extensions__item__id_tab_val_Extension_1), (u'presence', u'optional')])], rr=[], ev=None, er=[])
    ___AdditionalGanssAssistDataRequired_iE_Extensions__item__id._const_tab = ____AdditionalGanssAssistDataRequired_iE_Extensions__item__id_tab
    ___AdditionalGanssAssistDataRequired_iE_Extensions__item__id._const_tab_at = None
    ___AdditionalGanssAssistDataRequired_iE_Extensions__item__id._const_tab_id = u'id'
    ___AdditionalGanssAssistDataRequired_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ___AdditionalGanssAssistDataRequired_iE_Extensions__item__criticality._const_tab = ____AdditionalGanssAssistDataRequired_iE_Extensions__item__id_tab
    ___AdditionalGanssAssistDataRequired_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___AdditionalGanssAssistDataRequired_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___AdditionalGanssAssistDataRequired_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ___AdditionalGanssAssistDataRequired_iE_Extensions__item__extensionValue._const_tab = ____AdditionalGanssAssistDataRequired_iE_Extensions__item__id_tab
    ___AdditionalGanssAssistDataRequired_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___AdditionalGanssAssistDataRequired_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __AdditionalGanssAssistDataRequired_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___AdditionalGanssAssistDataRequired_iE_Extensions__item__id),
        (u'criticality', ___AdditionalGanssAssistDataRequired_iE_Extensions__item__criticality),
        (u'extensionValue', ___AdditionalGanssAssistDataRequired_iE_Extensions__item__extensionValue),
        ])
    __AdditionalGanssAssistDataRequired_iE_Extensions__item_._ext = None
    _AdditionalGanssAssistDataRequired_iE_Extensions._cont = __AdditionalGanssAssistDataRequired_iE_Extensions__item_
    _AdditionalGanssAssistDataRequired_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    AdditionalGanssAssistDataRequired._cont = ASN1Dict([
        (u'ganssReferenceTime', _AdditionalGanssAssistDataRequired_ganssReferenceTime),
        (u'ganssreferenceLocation', _AdditionalGanssAssistDataRequired_ganssreferenceLocation),
        (u'ganssIonosphericModel', _AdditionalGanssAssistDataRequired_ganssIonosphericModel),
        (u'ganssRequestedGenericAssistanceDataList', _AdditionalGanssAssistDataRequired_ganssRequestedGenericAssistanceDataList),
        (u'iE-Extensions', _AdditionalGanssAssistDataRequired_iE_Extensions),
        ])
    AdditionalGanssAssistDataRequired._ext = []
    
    #-----< AdditionalGanssAssistDataRequired-ExtIEs >-----#
    AdditionalGanssAssistDataRequired_ExtIEs = CLASS(name=u'AdditionalGanssAssistDataRequired-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    _AdditionalGanssAssistDataRequired_ExtIEs_val_Extension_0 = SEQ(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSSReq-AddIonosphericModel')))
    _AdditionalGanssAssistDataRequired_ExtIEs_val_Extension_1 = BOOL(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GANSSReq-EarthOrientPara')))
    AdditionalGanssAssistDataRequired_ExtIEs._val = ASN1Set(rv=[dict([(u'id', 103), (u'criticality', u'ignore'), (u'Extension', _AdditionalGanssAssistDataRequired_ExtIEs_val_Extension_0), (u'presence', u'optional')]), dict([(u'id', 104), (u'criticality', u'ignore'), (u'Extension', _AdditionalGanssAssistDataRequired_ExtIEs_val_Extension_1), (u'presence', u'optional')])], rr=[], ev=[], er=[])
    
    #-----< GANSSReq-AddIonosphericModel >-----#
    GANSSReq_AddIonosphericModel = SEQ(name=u'GANSSReq-AddIonosphericModel', mode=MODE_TYPE)
    _GANSSReq_AddIonosphericModel_ganss_add_iono_mode_req = BIT_STR(name=u'ganss-add-iono-mode-req', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GANSSReq_AddIonosphericModel_ganss_add_iono_mode_req._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    _GANSSReq_AddIonosphericModel_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GANSSReq_AddIonosphericModel_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-Containers', 'ProtocolExtensionField')))
    ___GANSSReq_AddIonosphericModel_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'id']))
    ____GANSSReq_AddIonosphericModel_iE_Extensions__item__id_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSSReq_AddIonosphericModel_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSSReq_AddIonosphericModel_iE_Extensions__item__id._const_tab = ____GANSSReq_AddIonosphericModel_iE_Extensions__item__id_tab
    ___GANSSReq_AddIonosphericModel_iE_Extensions__item__id._const_tab_at = None
    ___GANSSReq_AddIonosphericModel_iE_Extensions__item__id._const_tab_id = u'id'
    ___GANSSReq_AddIonosphericModel_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GANSSReq_AddIonosphericModel_iE_Extensions__item__criticality_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSSReq_AddIonosphericModel_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSSReq_AddIonosphericModel_iE_Extensions__item__criticality._const_tab = ____GANSSReq_AddIonosphericModel_iE_Extensions__item__criticality_tab
    ___GANSSReq_AddIonosphericModel_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GANSSReq_AddIonosphericModel_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GANSSReq_AddIonosphericModel_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GANSSReq_AddIonosphericModel_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_PCAP-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    ____GANSSReq_AddIonosphericModel_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GANSSReq_AddIonosphericModel_iE_Extensions__item__extensionValue._const_tab = ____GANSSReq_AddIonosphericModel_iE_Extensions__item__extensionValue_tab
    ___GANSSReq_AddIonosphericModel_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GANSSReq_AddIonosphericModel_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GANSSReq_AddIonosphericModel_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GANSSReq_AddIonosphericModel_iE_Extensions__item__id),
        (u'criticality', ___GANSSReq_AddIonosphericModel_iE_Extensions__item__criticality),
        (u'extensionValue', ___GANSSReq_AddIonosphericModel_iE_Extensions__item__extensionValue),
        ])
    __GANSSReq_AddIonosphericModel_iE_Extensions__item_._ext = None
    _GANSSReq_AddIonosphericModel_iE_Extensions._cont = __GANSSReq_AddIonosphericModel_iE_Extensions__item_
    _GANSSReq_AddIonosphericModel_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GANSSReq_AddIonosphericModel._cont = ASN1Dict([
        (u'ganss-add-iono-mode-req', _GANSSReq_AddIonosphericModel_ganss_add_iono_mode_req),
        (u'iE-Extensions', _GANSSReq_AddIonosphericModel_iE_Extensions),
        ])
    GANSSReq_AddIonosphericModel._ext = []
    
    #-----< GANSSReq-AddIonosphericModel-ExtIEs >-----#
    GANSSReq_AddIonosphericModel_ExtIEs = CLASS(name=u'GANSSReq-AddIonosphericModel-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('PCAP-Containers', 'PCAP-PROTOCOL-EXTENSION')))
    GANSSReq_AddIonosphericModel_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GANSSReq-EarthOrientPara >-----#
    GANSSReq_EarthOrientPara = BOOL(name=u'GANSSReq-EarthOrientPara', mode=MODE_TYPE)
    
    #-----< GanssRequestedGenericAssistanceDataList >-----#
    GanssRequestedGenericAssistanceDataList = SEQ_OF(name=u'GanssRequestedGenericAssistanceDataList', mode=MODE_TYPE)
    _GanssRequestedGenericAssistanceDataList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PCAP-IEs', 'GanssReqGenericData')))
    GanssRequestedGenericAssistanceDataList._cont = _GanssRequestedGenericAssistanceDataList__item_
    GanssRequestedGenericAssistanceDataList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    
    #-----< GanssReqGenericData >-----#
    GanssReqGenericData = SEQ(name=u'GanssReqGenericData', mode=MODE_TYPE)
    _GanssReqGenericData_ganssId = SEQ(name=u'ganssId', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'GANSSID')), opt=True)
    _GanssReqGenericData_ganssRealTimeIntegrity = BOOL(name=u'ganssRealTimeIntegrity', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GanssReqGenericData_ganssDifferentialCorrection = BIT_STR(name=u'ganssDifferentialCorrection', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PCAP-IEs', 'DGANSS-Sig-Id-Req')), opt=True)
    _GanssReqGenericData_ganssAlmanac = BOOL(name=u'ganssAlmanac', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GanssReqGenericData_ganssNavigationModel = BOOL(name=u'ganssNavigationModel', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GanssReqGenericData_ganssTimeModelGnssGnss = BIT_STR(name=u'ganssTimeModelGnssGnss', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GanssReqGenericData_ganssTimeModelGnssGnss._const_sz = ASN1Set(rv=[9], rr=[], ev=None, er=[])
    _GanssReqGenericData_ganssReferenceMeasurementInfo = BOOL(