# -*- coding: UTF-8 -*-
#/**
# * Software Name : pycrate
# * Version : 0.4
# *
# * Copyright 2018. Benoit Michau. ANSSI. P1sec.
# *
# * This library is free software; you can redistribute it and/or
# * modify it under the terms of the GNU Lesser General Public
# * License as published by the Free Software Foundation; either
# * version 2.1 of the License, or (at your option) any later version.
# *
# * This library is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# * Lesser General Public License for more details.
# *
# * You should have received a copy of the GNU Lesser General Public
# * License along with this library; if not, write to the Free Software
# * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
# * MA 02110-1301  USA
# *
# *--------------------------------------------------------
# * File Name : pycrate_csn1dir/ec_system_information_type_1.py
# * Created : 2018-11-21
# * Authors : Benoit Michau
# *--------------------------------------------------------
#*/
# specification: TS 44.018 - d80
# section: 9.1.43p EC System information type 1
# top-level object: EC System Information Type 1



# code automatically generated by pycrate_csn1
# change object type with type=CSN1T_BSTR (default type is CSN1T_UINT) in init
# add dict for value interpretation with dic={...} in CSN1Bit init
# add dict for key interpretation with kdic={...} in CSN1Alt init

from pycrate_csn1.csnobj import *

spare_padding = CSN1Val(name='spare_padding', val='L', num=-1)
Spare_padding = spare_padding
Spare_Padding = spare_padding 

ec_mobile_allocation_struct = CSN1List(name='ec_mobile_allocation_struct', list=[
  CSN1Bit(name='ec_ma_number', bit=5),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='maio', bit=6)])}),
  CSN1Alt(alt={
    '0': ('', [
    CSN1Bit(name='arfcn', bit=10)]),
    '1': ('', [
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Alt(alt={
        '0': ('', []),
        '1': ('', [
        CSN1Bit(name='hsn', bit=6)])}),
      CSN1Bit(name='ma_length', bit=6),
      CSN1Bit(name='ma_bitmap', bit=([2], lambda x: x + 1))])})])})])

ec_mobile_allocation_list_struct = CSN1List(name='ec_mobile_allocation_list_struct', list=[
  CSN1List(num=-1, list=[
    CSN1Val(name='', val='1'),
    CSN1Ref(obj=ec_mobile_allocation_struct)]),
  CSN1Val(name='', val='0')])

ec_cell_channel_description_struct = CSN1List(name='ec_cell_channel_description_struct', list=[
  CSN1Bit(name='numberofoctets', bit=5),
  CSN1Bit(name='frequency_list_information', bit=([0], lambda x: 8 * (x + 1)))])

ec_system_information_type_1 = CSN1List(name='ec_system_information_type_1', list=[
  CSN1Bit(name='message_type', bit=3),
  CSN1Bit(name='ec_si_1_index', bit=2),
  CSN1Bit(name='ec_si_1_count', bit=2),
  CSN1Bit(name='ec_si_change_mark', bit=5),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='ec_cell_channel_description', obj=ec_cell_channel_description_struct)])}),
  CSN1Ref(name='ec_mobile_allocation_list', obj=ec_mobile_allocation_list_struct),
  CSN1Bit(name='band_indicator'),
  CSN1Ref(obj=spare_padding)])

