# -*- coding: UTF-8 -*-
#/**
# * Software Name : pycrate
# * Version : 0.4
# *
# * Copyright 2018. Benoit Michau. ANSSI. P1sec.
# *
# * This library is free software; you can redistribute it and/or
# * modify it under the terms of the GNU Lesser General Public
# * License as published by the Free Software Foundation; either
# * version 2.1 of the License, or (at your option) any later version.
# *
# * This library is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# * Lesser General Public License for more details.
# *
# * You should have received a copy of the GNU Lesser General Public
# * License along with this library; if not, write to the Free Software
# * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
# * MA 02110-1301  USA
# *
# *--------------------------------------------------------
# * File Name : pycrate_csn1dir/flo_ack_nack_description_ie.py
# * Created : 2018-11-21
# * Authors : Benoit Michau
# *--------------------------------------------------------
#*/
# specification: TS 44.060 - d60
# section: 12.3.2 FLO Ack/Nack Description
# top-level object: FLO Ack/Nack Description IE



# code automatically generated by pycrate_csn1
# change object type with type=CSN1T_BSTR (default type is CSN1T_UINT) in init
# add dict for value interpretation with dic={...} in CSN1Bit init
# add dict for key interpretation with kdic={...} in CSN1Alt init

from pycrate_csn1.csnobj import *

flo_ack_nack_description_struct = CSN1List(name='flo_ack_nack_description_struct', list=[
  CSN1Bit(name='beginning_of_window'),
  CSN1Bit(name='end_of_window'),
  CSN1Bit(name='starting_sequence_number', bit=10),
  CSN1Alt(alt={
    '0': ('', [
    CSN1Bit(name='compressed_bitmap_length', bit=7),
    CSN1Bit(name='compressed_bitmap_starting_color_code'),
    CSN1Bit(name='compressed_received_block_bitmap', bit=([1], lambda x: x))]),
    '1': ('', [
    CSN1Bit(name='uncompressed_received_block_bitmap', bit=-1)])})])

flo_ack_nack_description_ie = CSN1Ref(name='flo_ack_nack_description_ie', obj=flo_ack_nack_description_struct)

