# -*- coding: UTF-8 -*-
#/**
# * Software Name : pycrate
# * Version : 0.4
# *
# * Copyright 2018. Benoit Michau. ANSSI. P1sec.
# *
# * This library is free software; you can redistribute it and/or
# * modify it under the terms of the GNU Lesser General Public
# * License as published by the Free Software Foundation; either
# * version 2.1 of the License, or (at your option) any later version.
# *
# * This library is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# * Lesser General Public License for more details.
# *
# * You should have received a copy of the GNU Lesser General Public
# * License along with this library; if not, write to the Free Software
# * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
# * MA 02110-1301  USA
# *
# *--------------------------------------------------------
# * File Name : pycrate_csn1dir/ms_ra_capability_value_part.py
# * Created : 2018-11-21
# * Authors : Benoit Michau
# *--------------------------------------------------------
#*/
# specification: TS 24.008 - d90
# section: 10.5.5.12a MS Radio Access capability
# top-level object: MS RA capability value part

_AccessTechnoType_dict = {
    0 : 'GSM P',
    1 : 'GSM E  --note that GSM E covers GSM P',
    2 : 'GSM R  --note that GSM R covers GSM E and GSM P',
    3 : 'GSM 1800',
    4 : 'GSM 1900',
    5 : 'GSM 450',
    6 : 'GSM 480',
    7 : 'GSM 850',
    8 : 'GSM 750',
    9 : 'GSM T 380',
    10 : 'GSM T 410',
    11 : 'unused',
    12 : 'GSM 710',
    13 : 'GSM T 810',
}



# code automatically generated by pycrate_csn1
# change object type with type=CSN1T_BSTR (default type is CSN1T_UINT) in init
# add dict for value interpretation with dic={...} in CSN1Bit init
# add dict for key interpretation with kdic={...} in CSN1Alt init

from pycrate_csn1.csnobj import *

spare_bits = CSN1Bit(name='spare_bits', num=-1)
Spare_bits = spare_bits
Spare_Bits = spare_bits

multislot_capability_struct = CSN1List(name='multislot_capability_struct', list=[
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='hscsd_multislot_class', bit=5)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='gprs_multislot_class', bit=5),
    CSN1Bit(name='gprs_extended_dynamic_allocation_capability')])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='sms_value', bit=4),
    CSN1Bit(name='sm_value', bit=4)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='ecsd_multislot_class', bit=5)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='egprs_multislot_class', bit=5),
    CSN1Bit(name='egprs_extended_dynamic_allocation_capability')])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='dtm_gprs_multi_slot_class', bit=2),
    CSN1Bit(name='single_slot_dtm'),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='dtm_egprs_multi_slot_class', bit=2)])})])})])

dlmc_capability_struct = CSN1List(name='dlmc_capability_struct', list=[
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='dlmc_non_contiguous_intra_band_reception', bit=2),
    CSN1Bit(name='dlmc_inter_band_reception')])}),
  CSN1Bit(name='dlmc_maximum_bandwidth', bit=2),
  CSN1Bit(name='dlmc_maximum_number_of_downlink_timeslots', bit=6),
  CSN1Bit(name='dlmc_maximum_number_of_downlink_carriers', bit=3)])

a5_bits = CSN1List(name='a5_bits', list=[
  CSN1Bit(name='a5_1'),
  CSN1Bit(name='a5_2'),
  CSN1Bit(name='a5_3'),
  CSN1Bit(name='a5_4'),
  CSN1Bit(name='a5_5'),
  CSN1Bit(name='a5_6'),
  CSN1Bit(name='a5_7')])

additional_access_technologies_struct = CSN1List(name='additional_access_technologies_struct', list=[
  CSN1Bit(name='access_technology_type', bit=4),
  CSN1Bit(name='gmsk_power_class', bit=3),
  CSN1Bit(name='_8psk_power_class', bit=2)])

enhanced_flexible_timeslot_assignment_struct = CSN1Alt(name='enhanced_flexible_timeslot_assignment_struct', alt={
  '0': ('', []),
  '1': ('', [
  CSN1Bit(name='alternative_efta_multislot_class', bit=4),
  CSN1Bit(name='efta_multislot_capability_reduction_for_downlink_dual_carrier', bit=3)])})

content = CSN1List(name='content', trunc=True, list=[
  CSN1Bit(name='rf_power_capability', bit=3),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='a5_bits', obj=a5_bits)])}),
  CSN1Bit(name='es_ind'),
  CSN1Bit(name='ps'),
  CSN1Bit(name='vgcs'),
  CSN1Bit(name='vbs'),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='multislot_capability', obj=multislot_capability_struct)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='_8psk_power_capability', bit=2)])}),
  CSN1Bit(name='compact_interference_measurement_capability'),
  CSN1Bit(name='revision_level_indicator'),
  CSN1Bit(name='umts_fdd_radio_access_technology_capability'),
  CSN1Bit(name='umts_3_84_mcps_tdd_radio_access_technology_capability'),
  CSN1Bit(name='cdma_2000_radio_access_technology_capability'),
  CSN1Bit(name='umts_1_28_mcps_tdd_radio_access_technology_capability'),
  CSN1Bit(name='geran_feature_package_1'),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='extended_dtm_gprs_multi_slot_class', bit=2),
    CSN1Bit(name='extended_dtm_egprs_multi_slot_class', bit=2)])}),
  CSN1Bit(name='modulation_based_multislot_class_support'),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='high_multislot_capability', bit=2)])}),
  CSN1Val(name='', val='0'),
  CSN1Bit(name='gmsk_multislot_power_profile', bit=2),
  CSN1Bit(name='_8_psk_multislot_power_profile', bit=2),
  CSN1Bit(name='multiple_tbf_capability'),
  CSN1Bit(name='downlink_advanced_receiver_performance', bit=2),
  CSN1Bit(name='extended_rlc_mac_control_message_segmentation_capability'),
  CSN1Bit(name='dtm_enhancements_capability'),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='dtm_gprs_high_multi_slot_class', bit=3),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='dtm_egprs_high_multi_slot_class', bit=3)])})])}),
  CSN1Bit(name='ps_handover_capability'),
  CSN1Bit(name='dtm_handover_capability'),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='multislot_capability_reduction_for_downlink_dual_carrier', bit=3),
    CSN1Bit(name='downlink_dual_carrier_for_dtm_capability')])}),
  CSN1Bit(name='flexible_timeslot_assignment'),
  CSN1Bit(name='gan_ps_handover_capability'),
  CSN1Bit(name='rlc_non_persistent_mode'),
  CSN1Bit(name='reduced_latency_capability'),
  CSN1Bit(name='uplink_egprs2', bit=2),
  CSN1Bit(name='downlink_egprs2', bit=2),
  CSN1Bit(name='e_utra_fdd_support'),
  CSN1Bit(name='e_utra_tdd_support'),
  CSN1Bit(name='geran_to_e_utra_support_in_geran_packet_transfer_mode', bit=2),
  CSN1Bit(name='priority_based_reselection_support'),
  CSN1Ref(name='enhanced_flexible_timeslot_assignment', obj=enhanced_flexible_timeslot_assignment_struct),
  CSN1Bit(name='indication_of_upper_layer_pdu_start_capability_for_rlc_um'),
  CSN1Bit(name='emst_capability'),
  CSN1Bit(name='mtti_capability'),
  CSN1Bit(name='utra_csg_cells_reporting'),
  CSN1Bit(name='e_utra_csg_cells_reporting'),
  CSN1Bit(name='dtr_capability'),
  CSN1Bit(name='emsr_capability'),
  CSN1Bit(name='fast_downlink_frequency_switching_capability'),
  CSN1Bit(name='tighter_capability', bit=2),
  CSN1Bit(name='fanr_capability'),
  CSN1Bit(name='ipa_capability'),
  CSN1Bit(name='geran_network_sharing_support'),
  CSN1Bit(name='e_utra_wideband_rsrq_measurements_support'),
  CSN1Bit(name='utra_multiple_frequency_band_indicators_support'),
  CSN1Bit(name='e_utra_multiple_frequency_band_indicators_support'),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='dlmc_capability', obj=dlmc_capability_struct)])}),
  CSN1Bit(name='extended_tsc_set_capability_support'),
  CSN1Bit(name='extended_earfcn_value_range'),
  CSN1Bit(name='pch_monitoring_support', bit=2)])

access_capabilities_struct = CSN1List(name='access_capabilities_struct', list=[
  CSN1Bit(name='length', bit=7),
  CSN1List(lref=([0], lambda x: x), list=[
    CSN1Ref(name='access_capabilities', obj=content),
    CSN1Ref(obj=spare_bits, num=-1)])])

ms_ra_capability_value_part_struct = CSN1List(name='ms_ra_capability_value_part_struct', list=[
  CSN1Alt(alt={
    '0000': ('access_technology_type', [
    CSN1Ref(name='access_capabilities', obj=access_capabilities_struct)]),
    '0001': ('access_technology_type', [
    CSN1Ref(name='access_capabilities', obj=access_capabilities_struct)]),
    '0010': ('access_technology_type', [
    CSN1Ref(name='access_capabilities', obj=access_capabilities_struct)]),
    '0011': ('access_technology_type', [
    CSN1Ref(name='access_capabilities', obj=access_capabilities_struct)]),
    '0100': ('access_technology_type', [
    CSN1Ref(name='access_capabilities', obj=access_capabilities_struct)]),
    '0101': ('access_technology_type', [
    CSN1Ref(name='access_capabilities', obj=access_capabilities_struct)]),
    '0110': ('access_technology_type', [
    CSN1Ref(name='access_capabilities', obj=access_capabilities_struct)]),
    '0111': ('access_technology_type', [
    CSN1Ref(name='access_capabilities', obj=access_capabilities_struct)]),
    '1000': ('access_technology_type', [
    CSN1Ref(name='access_capabilities', obj=access_capabilities_struct)]),
    '1001': ('access_technology_type', [
    CSN1Ref(name='access_capabilities', obj=access_capabilities_struct)]),
    '1010': ('access_technology_type', [
    CSN1Ref(name='access_capabilities', obj=access_capabilities_struct)]),
    '1011': ('access_technology_type', [
    CSN1Ref(name='access_capabilities', obj=access_capabilities_struct)]),
    '1100': ('access_technology_type', [
    CSN1Ref(name='access_capabilities', obj=access_capabilities_struct)]),
    '1101': ('access_technology_type', [
    CSN1Ref(name='access_capabilities', obj=access_capabilities_struct)]),
    '1110': ('access_technology_type', [
    CSN1Ref(name='access_capabilities', obj=access_capabilities_struct)]),
    '1111': ('access_technology_type', [
    CSN1Bit(name='length', bit=7),
    CSN1List(lref=([1], lambda x: x), list=[
      CSN1List(num=-1, list=[
        CSN1Val(name='', val='1'),
        CSN1Ref(name='additional_access_technologies', obj=additional_access_technologies_struct)]),
      CSN1Val(name='', val='0'),
      CSN1Ref(obj=spare_bits, num=-1)])])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1SelfRef()])})],
  kdic=_AccessTechnoType_dict)

ms_ra_capability_value_part = CSN1List(name='ms_ra_capability_value_part', list=[
  CSN1Ref(obj=ms_ra_capability_value_part_struct),
  CSN1Ref(obj=spare_bits, num=-1)])

