# -*- coding: UTF-8 -*-
#/**
# * Software Name : pycrate
# * Version : 0.4
# *
# * Copyright 2018. Benoit Michau. ANSSI. P1sec.
# *
# * This library is free software; you can redistribute it and/or
# * modify it under the terms of the GNU Lesser General Public
# * License as published by the Free Software Foundation; either
# * version 2.1 of the License, or (at your option) any later version.
# *
# * This library is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# * Lesser General Public License for more details.
# *
# * You should have received a copy of the GNU Lesser General Public
# * License along with this library; if not, write to the Free Software
# * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
# * MA 02110-1301  USA
# *
# *--------------------------------------------------------
# * File Name : pycrate_csn1dir/non_gprs_cell_options_ie.py
# * Created : 2018-11-21
# * Authors : Benoit Michau
# *--------------------------------------------------------
#*/
# specification: TS 44.060 - d60
# section: 12.27 Non GPRS Cell Options IE
# top-level object: Non GPRS Cell Options IE

# external references
from pycrate_csn1dir.si3_rest_octet import _3g_early_classmark_sending_restriction

# code automatically generated by pycrate_csn1
# change object type with type=CSN1T_BSTR (default type is CSN1T_UINT) in init
# add dict for value interpretation with dic={...} in CSN1Bit init
# add dict for key interpretation with kdic={...} in CSN1Alt init

from pycrate_csn1.csnobj import *

spare_bit = CSN1Bit(name='spare_bit')
Spare_bit = spare_bit
Spare_Bit = spare_bit

_3g_ecsr = CSN1Ref(name='_3g_ecsr', obj=_3g_early_classmark_sending_restriction)

extension_information = CSN1List(name='extension_information', list=[
  CSN1Bit(name='ecsc'),
  CSN1Ref(obj=_3g_ecsr),
  CSN1Ref(obj=spare_bit, num=-1)])

non_gprs_cell_options_ie = CSN1List(name='non_gprs_cell_options_ie', list=[
  CSN1Bit(name='att'),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='t3212', bit=8)])}),
  CSN1Bit(name='neci'),
  CSN1Bit(name='pwrc'),
  CSN1Bit(name='dtx', bit=2),
  CSN1Bit(name='radio_link_timeout', bit=4),
  CSN1Bit(name='bs_ag_blks_res', bit=3),
  CSN1Bit(name='ccch_conf', bit=3),
  CSN1Bit(name='bs_pa_mfrms', bit=3),
  CSN1Bit(name='max_retrans', bit=2),
  CSN1Bit(name='tx_integer', bit=4),
  CSN1Bit(name='ec'),
  CSN1Bit(name='ms_txpwr_max_ccch', bit=5),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='extension_length', bit=6),
    CSN1Ref(obj=extension_information, lref=([1], lambda x: x + 1))])})])

