# -*- coding: UTF-8 -*-
#/**
# * Software Name : pycrate
# * Version : 0.4
# *
# * Copyright 2018. Benoit Michau. ANSSI. P1sec.
# *
# * This library is free software; you can redistribute it and/or
# * modify it under the terms of the GNU Lesser General Public
# * License as published by the Free Software Foundation; either
# * version 2.1 of the License, or (at your option) any later version.
# *
# * This library is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# * Lesser General Public License for more details.
# *
# * You should have received a copy of the GNU Lesser General Public
# * License along with this library; if not, write to the Free Software
# * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
# * MA 02110-1301  USA
# *
# *--------------------------------------------------------
# * File Name : pycrate_csn1dir/packet_dbpsch_assignment_message_content.py
# * Created : 2018-11-21
# * Authors : Benoit Michau
# *--------------------------------------------------------
#*/
# specification: TS 44.060 - d60
# section: 11.2.5b Packet DBPSCH Assignment
# top-level object: Packet DBPSCH Assignment message content

# external references
from pycrate_csn1dir.global_tfi_ie import global_tfi_ie
from pycrate_csn1dir.padding_bits import padding_bits
from pycrate_csn1dir.packet_request_reference_ie import packet_request_reference_ie

# code automatically generated by pycrate_csn1
# change object type with type=CSN1T_BSTR (default type is CSN1T_UINT) in init
# add dict for value interpretation with dic={...} in CSN1Bit init
# add dict for key interpretation with kdic={...} in CSN1Alt init

from pycrate_csn1.csnobj import *

response_time_sacch_struct = CSN1List(name='response_time_sacch_struct', list=[
  CSN1Bit(name='trmin_sacch'),
  CSN1Bit(name='tresp_sacch')])

power_command_struct = CSN1List(name='power_command_struct', list=[
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='fpc_epc')])}),
  CSN1Bit(name='power_level', bit=8)])

response_time_struct = CSN1List(name='response_time_struct', list=[
  CSN1Bit(name='trmin', bit=6),
  CSN1Bit(name='tresp_mac_dtm', bit=7),
  CSN1Bit(name='tresp_mac_dedicated', bit=7)])

channel_description_struct = CSN1List(name='channel_description_struct', list=[
  CSN1Bit(name='channel_type', bit=6),
  CSN1Bit(name='downlink_timeslot_allocation', bit=8),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='uplink_timeslot_allocation', bit=8)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='usf', bit=3),
    CSN1Bit(name='usf_granularity')])}),
  CSN1Ref(name='power_command', obj=power_command_struct),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='channel_mode', bit=8)])}),
  CSN1Bit(name='tsc', bit=3),
  CSN1Alt(alt={
    '0': ('', [
    CSN1Bit(name='maio', bit=6),
    CSN1Bit(name='hsn', bit=6)]),
    '1': ('', [
    CSN1Bit(name='arfcn', bit=10)])})])

response_time_sdcch_struct = CSN1List(name='response_time_sdcch_struct', list=[
  CSN1Bit(name='trmin_sdcch'),
  CSN1Bit(name='tresp_sdcch')])

network_response_times_struct = CSN1Alt(name='network_response_times_struct', alt={
  '0': ('', [
  CSN1Ref(name='response_time_sdcch', obj=response_time_sdcch_struct)]),
  '1': ('', [
  CSN1Ref(name='response_time_sacch', obj=response_time_sacch_struct),
  CSN1Alt(alt={
    '0': ('', [
    CSN1Ref(name='response_time_facch_f', obj=response_time_struct)]),
    '1': ('', [
    CSN1Ref(name='response_time_facch_h', obj=response_time_struct)])})])})

packet_dbpsch_assignment_message_content = CSN1List(name='packet_dbpsch_assignment_message_content', list=[
  CSN1Bit(name='page_mode', bit=2),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='persistence_level', bit=16)])}),
  CSN1List(list=[
    CSN1Alt(alt={
      '0': ('', [
      CSN1Ref(name='global_tfi', obj=global_tfi_ie)]),
      '10': ('', [
      CSN1Bit(name='g_rnti', bit=32)]),
      '11': ('', [
      CSN1Ref(name='packet_request_reference', obj=packet_request_reference_ie)])}),
    CSN1List(list=[
      CSN1Val(name='', val='0'),
      CSN1List(list=[
        CSN1Ref(name='channel_description', obj=channel_description_struct),
        CSN1Alt(alt={
          '0': ('', []),
          '1': ('', [
          CSN1Bit(name='timing_advance_value', bit=8)])}),
        CSN1Ref(name='network_response_times', obj=network_response_times_struct),
        CSN1Ref(obj=padding_bits)])])])])

