# -*- coding: UTF-8 -*-
#/**
# * Software Name : pycrate
# * Version : 0.4
# *
# * Copyright 2018. Benoit Michau. ANSSI. P1sec.
# *
# * This library is free software; you can redistribute it and/or
# * modify it under the terms of the GNU Lesser General Public
# * License as published by the Free Software Foundation; either
# * version 2.1 of the License, or (at your option) any later version.
# *
# * This library is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# * Lesser General Public License for more details.
# *
# * You should have received a copy of the GNU Lesser General Public
# * License along with this library; if not, write to the Free Software
# * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
# * MA 02110-1301  USA
# *
# *--------------------------------------------------------
# * File Name : pycrate_csn1dir/packet_timeslot_reconfigure_message_content.py
# * Created : 2018-11-21
# * Authors : Benoit Michau
# *--------------------------------------------------------
#*/
# specification: TS 44.060 - d60
# section: 11.2.31 Packet Timeslot Reconfigure
# top-level object: Packet Timeslot Reconfigure message content

# external references
from pycrate_csn1dir.pulse_format_ie import dlmc_frequency_parameters_ie
from pycrate_csn1dir.padding_bits import padding_bits
from pycrate_csn1dir.starting_frame_number_description_ie import starting_frame_number_description_ie
from pycrate_csn1dir.global_packet_timing_advance_ie import global_packet_timing_advance_ie
from pycrate_csn1dir.frequency_parameters_ie import frequency_parameters_ie
from pycrate_csn1dir.dynamic_allocation_3_ie import dynamic_allocation_3_ie
from pycrate_csn1dir.pulse_format_ie import pulse_format_ie
from pycrate_csn1dir.power_control_parameters_ie import power_control_parameters_ie
from pycrate_csn1dir.egprs_level_ie import egprs_level_ie
from pycrate_csn1dir.dtm_handover_ps_radio_resources_3_ie import additional_pfcs_struct
from pycrate_csn1dir.egprs_window_size_ie import egprs_window_size_ie
from pycrate_csn1dir.global_tfi_ie import global_tfi_ie
from pycrate_csn1dir.dual_carrier_frequency_parameters_ie import dual_carrier_frequency_parameters_ie
from pycrate_csn1dir.egprs_modulation_and_coding_scheme_ie import egprs_modulation_and_coding_scheme_ie
from pycrate_csn1dir.compact_reduced_ma_ie import compact_reduced_ma_ie

# code automatically generated by pycrate_csn1
# change object type with type=CSN1T_BSTR (default type is CSN1T_UINT) in init
# add dict for value interpretation with dic={...} in CSN1Bit init
# add dict for key interpretation with kdic={...} in CSN1Alt init

from pycrate_csn1.csnobj import *

dynamic_allocation_struct = CSN1List(name='dynamic_allocation_struct', list=[
  CSN1Bit(name='extended_dynamic__allocation'),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='p0', bit=4),
    CSN1Bit(name='pr_mode')])}),
  CSN1Bit(name='usf_granularity'),
  CSN1Val(name='', val='0'),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='tbf_starting_time', obj=starting_frame_number_description_ie)])}),
  CSN1Alt(alt={
    '0': ('', [
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='usf_tn0', bit=3)])}),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='usf_tn1', bit=3)])}),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='usf_tn2', bit=3)])}),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='usf_tn3', bit=3)])}),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='usf_tn4', bit=3)])}),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='usf_tn5', bit=3)])}),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='usf_tn6', bit=3)])}),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='usf_tn7', bit=3)])})]),
    '1': ('', [
    CSN1Bit(name='alpha', bit=4),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='usf_tn0', bit=3),
      CSN1Bit(name='gamma_tn0', bit=5)])}),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='usf_tn1', bit=3),
      CSN1Bit(name='gamma_tn1', bit=5)])}),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='usf_tn2', bit=3),
      CSN1Bit(name='gamma_tn2', bit=5)])}),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='usf_tn3', bit=3),
      CSN1Bit(name='gamma_tn3', bit=5)])}),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='usf_tn4', bit=3),
      CSN1Bit(name='gamma_tn4', bit=5)])}),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='usf_tn5', bit=3),
      CSN1Bit(name='gamma_tn5', bit=5)])}),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='usf_tn6', bit=3),
      CSN1Bit(name='gamma_tn6', bit=5)])}),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='usf_tn7', bit=3),
      CSN1Bit(name='gamma_tn7', bit=5)])})])})])

rlc_entity_struct = CSN1List(name='rlc_entity_struct', list=[
  CSN1Bit(name='tfi', bit=5),
  CSN1Bit(name='rlc_mode'),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='egprs_window_size', obj=egprs_window_size_ie)])}),
  CSN1Bit(name='pfi', bit=7)])

assignment_info_struct = CSN1List(name='assignment_info_struct', list=[
  CSN1Bit(name='assignment_type', bit=2),
  CSN1Bit(name='carrier_id')])

carrier_specific_info_struct = CSN1Alt(name='carrier_specific_info_struct', alt={
  '00': ('', []),
  '01': ('', []),
  '10': ('', [
  CSN1Alt(alt={
    '0': ('', [
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='timeslot_allocation', bit=8)])})]),
    '1': ('', [
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='downlink_pdch_pairs_dlmc', bit=8),
      CSN1Bit(name='rtti_downlink_pdch_pair_assignment_dlmc', bit=4)])})])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='maio', bit=6)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='p0', bit=4),
    CSN1Bit(name='pr_mode')])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='downlink_tfi_assignment', bit=5),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='downlink_etfi_assignment', bit=3)])})])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='power_control_parameters', obj=power_control_parameters_ie)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='rlc_entity_2', obj=rlc_entity_struct),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='downlink_etfi_assignment', bit=3)])}),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Ref(name='rlc_entity_3', obj=rlc_entity_struct)])}),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='downlink_etfi_assignment', bit=3)])})])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1List(num=-1, list=[
      CSN1Val(name='', val='1'),
      CSN1Ref(name='emsr_additional_pfcs_1', obj=additional_pfcs_struct),
      CSN1Alt(alt={
        '0': ('', []),
        '1': ('', [
        CSN1Bit(name='downlink_etfi_assignment', bit=3)])})]),
    CSN1Val(name='', val='0'),
    CSN1List(num=-1, list=[
      CSN1Val(name='', val='1'),
      CSN1Ref(name='emsr_additional_pfcs_2', obj=additional_pfcs_struct),
      CSN1Alt(alt={
        '0': ('', []),
        '1': ('', [
        CSN1Bit(name='downlink_etfi_assignment', bit=3)])})]),
    CSN1Val(name='', val='0'),
    CSN1List(num=-1, list=[
      CSN1Val(name='', val='1'),
      CSN1Ref(name='emsr_additional_pfcs_3', obj=additional_pfcs_struct),
      CSN1Alt(alt={
        '0': ('', []),
        '1': ('', [
        CSN1Bit(name='downlink_etfi_assignment', bit=3)])})]),
    CSN1Val(name='', val='0')])}),
  CSN1Bit(name='primary_tsc_set'),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='secondary_dl_tsc_set'),
    CSN1Bit(name='secondary_dl_tsc_value', bit=3)])})]),
  '11': ('', [
  CSN1Bit(bit=-1)])})

dlmc_ul_carrier_info_struct = CSN1Alt(name='dlmc_ul_carrier_info_struct', alt={
  '00': ('', []),
  '01': ('', []),
  '10': ('', [
  CSN1Alt(alt={
    '0': ('', [
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='uplink_timeslot_allocation', bit=8)])})]),
    '1': ('', [
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='uplink_pdch_pairs_dlmc', bit=8)])})])}),
  CSN1Ref(name='dynamic_allocation_3', obj=dynamic_allocation_3_ie),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='uplink_rlc_entity_2', obj=rlc_entity_struct),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Ref(name='uplink_rlc_entity_3', obj=rlc_entity_struct)])})])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1List(num=-1, list=[
      CSN1Val(name='', val='1'),
      CSN1Ref(name='emsr_additional_pfcs_1', obj=additional_pfcs_struct)]),
    CSN1Val(name='', val='0'),
    CSN1List(num=-1, list=[
      CSN1Val(name='', val='1'),
      CSN1Ref(name='emsr_additional_pfcs_2', obj=additional_pfcs_struct)]),
    CSN1Val(name='', val='0'),
    CSN1List(num=-1, list=[
      CSN1Val(name='', val='1'),
      CSN1Ref(name='emsr_additional_pfcs_3', obj=additional_pfcs_struct)]),
    CSN1Val(name='', val='0')])}),
  CSN1Bit(name='primary_tsc_set')]),
  '11': ('', [
  CSN1Bit(bit=-1)])})

dynamic_allocation_2_struct = CSN1List(name='dynamic_allocation_2_struct', list=[
  CSN1Bit(name='extended_dynamic_allocation'),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='p0_c1', bit=4),
    CSN1Bit(name='pr_mode_c1'),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='p0_c2', bit=4),
      CSN1Bit(name='pr_mode_c2')])})])}),
  CSN1Bit(name='usf_granularity'),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='uplink_tfi_assignment', bit=5)])}),
  CSN1Alt(alt={
    '0': ('', [
    CSN1Bit(name='n_usf', bit=4),
    CSN1Alt(num=([1], lambda x: x + 1), alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='usf', bit=3)])})]),
    '1': ('', [
    CSN1Bit(name='alpha_c1', bit=4),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='alpha_c2', bit=4)])}),
    CSN1Alt(alt={
      '0': ('', [
      CSN1Bit(name='n_ts', bit=4),
      CSN1Alt(num=([1], lambda x: x + 1), alt={
        '0': ('', []),
        '1': ('', [
        CSN1Bit(name='usf', bit=3),
        CSN1Bit(name='gamma', bit=5)])})]),
      '1': ('', [
      CSN1Bit(name='n_pairs', bit=3),
      CSN1Alt(num=([1], lambda x: x + 1), alt={
        '0': ('', []),
        '1': ('', [
        CSN1Bit(name='usf', bit=3),
        CSN1Bit(name='gamma', bit=5)])}),
      CSN1Alt(alt={
        '0': ('', []),
        '1': ('', [
        CSN1Alt(num=([-1, 1], lambda x: x + 1), alt={
          '0': ('', []),
          '1': ('', [
          CSN1Bit(name='usf_2', bit=3),
          CSN1Alt(alt={
            '0': ('', []),
            '1': ('', [
            CSN1Bit(name='gamma', bit=5)])})])})])})])})])})])

ufps_struct = CSN1Alt(name='ufps_struct', alt={
  '00': ('', []),
  '01': ('', []),
  '10': ('', [
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='dlmc_frequency_parameters', obj=dlmc_frequency_parameters_ie)])}),
  CSN1List(num=-1, list=[
    CSN1Val(name='', val='1'),
    CSN1Ref(name='carrier_specific_info', obj=carrier_specific_info_struct)]),
  CSN1Val(name='', val='0')]),
  '11': ('', [
  CSN1Bit(bit=-1)])})

packet_timeslot_reconfigure_message_content = CSN1List(name='packet_timeslot_reconfigure_message_content', list=[
  CSN1Bit(name='page_mode', bit=2),
  CSN1List(list=[
    CSN1Val(name='', val='0'),
    CSN1Ref(name='global_tfi', obj=global_tfi_ie),
    CSN1Alt(alt={
      '0': ('', [
      CSN1List(list=[
        CSN1Bit(name='channel_coding_command', bit=2),
        CSN1Ref(name='global_packet_timing_advance', obj=global_packet_timing_advance_ie),
        CSN1Bit(name='downlink_rlc_mode'),
        CSN1Bit(name='control_ack'),
        CSN1Alt(alt={
          '0': ('', []),
          '1': ('', [
          CSN1Bit(name='downlink_tfi_assignment', bit=5)])}),
        CSN1Alt(alt={
          '0': ('', []),
          '1': ('', [
          CSN1Bit(name='uplink_tfi_assignment', bit=5)])}),
        CSN1Bit(name='downlink_timeslot_allocation', bit=8),
        CSN1Alt(alt={
          '0': ('', []),
          '1': ('', [
          CSN1Ref(name='frequency_parameters', obj=frequency_parameters_ie)])}),
        CSN1Val(name='', val='0'),
        CSN1Ref(name='dynamic_allocation', obj=dynamic_allocation_struct),
        CSN1Alt(alt={
          '0': ('', [
          CSN1Bit(bit=-1)]),
          '1': ('', [
          CSN1Alt(alt={
            '0': ('', []),
            '1': ('', [
            CSN1Bit(name='packet_extended_timing_advance', bit=2)])}),
          CSN1Alt(alt={
            '0': ('', [
            CSN1Bit(bit=-1)]),
            '1': ('', [
            CSN1Alt(alt={
              '0': ('', []),
              '1': ('', [
              CSN1Bit(name='rb_id_of_downlink_tbf', bit=5),
              CSN1Bit(name='rb_id_of_uplink_tbf', bit=5)])}),
            CSN1Alt(alt={
              '0': ('', []),
              '1': ('', [
              CSN1Bit(name='uplink_control_timeslot', bit=3)])}),
            CSN1Alt(alt={
              '0': ('', [
              CSN1Bit(bit=-1)]),
              '1': ('', [
              CSN1Alt(alt={
                '0': ('', []),
                '1': ('', [
                CSN1Bit(name='pfi_of_downlink_tbf', bit=7)])}),
              CSN1Alt(alt={
                '0': ('', []),
                '1': ('', [
                CSN1Bit(name='pfi_of_uplink_tbf', bit=7)])}),
              CSN1Alt(alt={
                '0': ('', []),
                '1': ('', [
                CSN1Bit(name='uplink_rlc_mode')])}),
              CSN1Alt(alt={
                '0': ('', [
                CSN1Bit(name='emst_nw_capability')]),
                '1': ('', [
                CSN1Alt(alt={
                  '0': ('', []),
                  '1': ('', [
                  CSN1Ref(name='downlink_rlc_entity_2', obj=rlc_entity_struct),
                  CSN1Alt(alt={
                    '0': ('', []),
                    '1': ('', [
                    CSN1Ref(name='downlink_rlc_entity_3', obj=rlc_entity_struct)])})])}),
                CSN1Alt(alt={
                  '0': ('', []),
                  '1': ('', [
                  CSN1Ref(name='uplink_rlc_entity_2', obj=rlc_entity_struct),
                  CSN1Alt(alt={
                    '0': ('', []),
                    '1': ('', [
                    CSN1Ref(name='uplink_rlc_entity_3', obj=rlc_entity_struct)])})])})])}),
              CSN1Alt(alt={
                '0': ('', [
                CSN1Bit(bit=-1)]),
                '1': ('', [
                CSN1Alt(alt={
                  '0': ('', []),
                  '1': ('', [
                  CSN1List(num=-1, list=[
                    CSN1Val(name='', val='1'),
                    CSN1Ref(name='emsr_additional_pfcs_1', obj=additional_pfcs_struct)]),
                  CSN1Val(name='', val='0'),
                  CSN1List(num=-1, list=[
                    CSN1Val(name='', val='1'),
                    CSN1Ref(name='emsr_additional_pfcs_2', obj=additional_pfcs_struct)]),
                  CSN1Val(name='', val='0'),
                  CSN1List(num=-1, list=[
                    CSN1Val(name='', val='1'),
                    CSN1Ref(name='emsr_additional_pfcs_3', obj=additional_pfcs_struct)]),
                  CSN1Val(name='', val='0')])}),
                CSN1Alt(alt={
                  '0': ('', []),
                  '1': ('', [
                  CSN1List(num=-1, list=[
                    CSN1Val(name='', val='1'),
                    CSN1Ref(name='emsr_additional_pfcs_1', obj=additional_pfcs_struct)]),
                  CSN1Val(name='', val='0'),
                  CSN1List(num=-1, list=[
                    CSN1Val(name='', val='1'),
                    CSN1Ref(name='emsr_additional_pfcs_2', obj=additional_pfcs_struct)]),
                  CSN1Val(name='', val='0'),
                  CSN1List(num=-1, list=[
                    CSN1Val(name='', val='1'),
                    CSN1Ref(name='emsr_additional_pfcs_3', obj=additional_pfcs_struct)]),
                  CSN1Val(name='', val='0')])}),
                CSN1Alt(alt={
                  '0': ('', [
                  CSN1Bit(bit=-1)]),
                  '1': ('', [
                  CSN1Bit(name='primary_tsc_set'),
                  CSN1Alt(alt={
                    '0': ('', []),
                    '1': ('', [
                    CSN1Bit(name='secondary_dl_tsc_set'),
                    CSN1Bit(name='secondary_dl_tsc_value', bit=3)])}),
                  CSN1Ref(obj=padding_bits)]),
                  None: ('', [])})]),
                None: ('', [])})]),
              None: ('', [])})]),
            None: ('', [])})]),
          None: ('', [])})])]),
      '1': ('', [
      CSN1Alt(alt={
        '00': ('', [
        CSN1List(list=[
          CSN1Alt(alt={
            '0': ('', []),
            '1': ('', [
            CSN1Ref(name='compact_reduced_ma', obj=compact_reduced_ma_ie)])}),
          CSN1Ref(name='egprs_channel_coding_command', obj=egprs_modulation_and_coding_scheme_ie),
          CSN1Bit(name='resegment'),
          CSN1Alt(alt={
            '0': ('', []),
            '1': ('', [
            CSN1Ref(name='downlink_egprs_window_size', obj=egprs_window_size_ie)])}),
          CSN1Alt(alt={
            '0': ('', []),
            '1': ('', [
            CSN1Ref(name='uplink_egprs_window_size', obj=egprs_window_size_ie)])}),
          CSN1Bit(name='link_quality_measurement_mode', bit=2),
          CSN1Ref(name='global_packet_timing_advance', obj=global_packet_timing_advance_ie),
          CSN1Alt(alt={
            '0': ('', []),
            '1': ('', [
            CSN1Bit(name='packet_extended_timing_advance', bit=2)])}),
          CSN1Bit(name='downlink_rlc_mode'),
          CSN1Bit(name='control_ack'),
          CSN1Alt(alt={
            '0': ('', []),
            '1': ('', [
            CSN1Bit(name='downlink_tfi_assignment', bit=5)])}),
          CSN1Alt(alt={
            '0': ('', []),
            '1': ('', [
            CSN1Bit(name='uplink_tfi_assignment', bit=5)])}),
          CSN1Bit(name='downlink_timeslot_allocation', bit=8),
          CSN1Alt(alt={
            '0': ('', []),
            '1': ('', [
            CSN1Ref(name='frequency_parameters', obj=frequency_parameters_ie)])}),
          CSN1Val(name='', val='0'),
          CSN1Ref(name='dynamic_allocation', obj=dynamic_allocation_struct),
          CSN1Alt(alt={
            '0': ('', [
            CSN1Bit(bit=-1)]),
            '1': ('', [
            CSN1Alt(alt={
              '0': ('', []),
              '1': ('', [
              CSN1Bit(name='rb_id_of_downlink_tbf', bit=5),
              CSN1Bit(name='rb_id_of_uplink_tbf', bit=5)])}),
            CSN1Alt(alt={
              '0': ('', []),
              '1': ('', [
              CSN1Bit(name='uplink_control_timeslot', bit=3)])}),
            CSN1Alt(alt={
              '0': ('', [
              CSN1Bit(bit=-1)]),
              '1': ('', [
              CSN1Alt(alt={
                '0': ('', []),
                '1': ('', [
                CSN1Bit(name='pfi_of_downlink_tbf', bit=7)])}),
              CSN1Alt(alt={
                '0': ('', []),
                '1': ('', [
                CSN1Bit(name='pfi_of_uplink_tbf', bit=7)])}),
              CSN1Alt(alt={
                '0': ('', []),
                '1': ('', [
                CSN1Bit(name='uplink_rlc_mode')])}),
              CSN1Alt(alt={
                '0': ('', [
                CSN1Bit(bit=-1)]),
                '1': ('', [
                CSN1Alt(alt={
                  '0': ('', []),
                  '1': ('', [
                  CSN1Bit(name='downlink_npm_transfer_time', bit=5)])}),
                CSN1Alt(alt={
                  '0': ('', []),
                  '1': ('', [
                  CSN1Bit(name='uplink_npm_transfer_time', bit=5)])}),
                CSN1Alt(alt={
                  '0': ('', [
                  CSN1Bit(bit=-1)]),
                  '1': ('', [
                  CSN1Bit(name='indication_of_upper_layer_pdu_start_for_rlc_um'),
                  CSN1Bit(name='enhanced_flexible_timeslot_assignment'),
                  CSN1Alt(alt={
                    '0': ('', [
                    CSN1Bit(bit=-1)]),
                    '1': ('', [
                    CSN1Bit(name='primary_tsc_set'),
                    CSN1Alt(alt={
                      '0': ('', []),
                      '1': ('', [
                      CSN1Bit(name='secondary_dl_tsc_set'),
                      CSN1Bit(name='secondary_dl_tsc_value', bit=3)])}),
                    CSN1Ref(obj=padding_bits)]),
                    None: ('', [])})]),
                  None: ('', [])})]),
                None: ('', [])})]),
              None: ('', [])})]),
            None: ('', [])})])]),
        '01': ('', [
        CSN1List(list=[
          CSN1Ref(name='egprs_channel_coding_command', obj=egprs_modulation_and_coding_scheme_ie),
          CSN1Bit(name='resegment'),
          CSN1Ref(name='assignment_info', obj=assignment_info_struct),
          CSN1Alt(alt={
            '0': ('', []),
            '1': ('', [
            CSN1Ref(name='downlink_egprs_window_size', obj=egprs_window_size_ie)])}),
          CSN1Alt(alt={
            '0': ('', []),
            '1': ('', [
            CSN1Ref(name='uplink_egprs_window_size', obj=egprs_window_size_ie)])}),
          CSN1Bit(name='link_quality_measurement_mode', bit=2),
          CSN1Alt(alt={
            '0': ('', []),
            '1': ('', [
            CSN1Bit(name='bep_period2', bit=4)])}),
          CSN1Ref(name='global_packet_timing_advance', obj=global_packet_timing_advance_ie),
          CSN1Alt(alt={
            '0': ('', []),
            '1': ('', [
            CSN1Bit(name='packet_extended_timing_advance', bit=2)])}),
          CSN1Bit(name='downlink_rlc_mode'),
          CSN1Bit(name='control_ack'),
          CSN1Alt(alt={
            '0': ('', []),
            '1': ('', [
            CSN1Bit(name='downlink_tfi_assignment', bit=5)])}),
          CSN1Alt(alt={
            '0': ('', [
            CSN1Bit(name='timeslot_allocation_c1', bit=8),
            CSN1Alt(alt={
              '0': ('', []),
              '1': ('', [
              CSN1Bit(name='timeslot_allocation_c2', bit=8)])})]),
            '1': ('', [
            CSN1Bit(name='rtti_usf_mode'),
            CSN1Alt(alt={
              '0': ('', [
              CSN1Alt(alt={
                '00': ('', []),
                '01': ('', []),
                '10': ('', [
                CSN1Bit(name='downlink_pdch_pairs_c1', bit=8),
                CSN1Bit(name='uplink_pdch_pairs_c1', bit=8)])}),
              CSN1Bit(name='rtti_downlink_pdch_pair_assignment_sc', bit=4)]),
              '1': ('', [
              CSN1Alt(alt={
                '00': ('', []),
                '01': ('', []),
                '10': ('', [
                CSN1Bit(name='downlink_pdch_pairs_c1', bit=8),
                CSN1Bit(name='downlink_pdch_pairs_c2', bit=8),
                CSN1Bit(name='uplink_pdch_pairs_c1', bit=8),
                CSN1Bit(name='uplink_pdch_pairs_c2', bit=8)])}),
              CSN1Bit(name='rtti_downlink_pdch_pair_assignment_dc', bit=8)])})])}),
          CSN1Alt(alt={
            '00': ('', []),
            '01': ('', [
            CSN1Alt(alt={
              '0': ('', []),
              '1': ('', [
              CSN1Ref(name='frequency_parameters_c1', obj=frequency_parameters_ie)])}),
            CSN1Alt(alt={
              '0': ('', []),
              '1': ('', [
              CSN1Ref(name='frequency_parameters_c2', obj=frequency_parameters_ie)])})]),
            '10': ('', [
            CSN1Ref(name='dual_carrier_frequency_parameters', obj=dual_carrier_frequency_parameters_ie)])}),
          CSN1Ref(name='dynamic_allocation_2', obj=dynamic_allocation_2_struct),
          CSN1Alt(alt={
            '0': ('', []),
            '1': ('', [
            CSN1Bit(name='uplink_control_timeslot_c1', bit=3)])}),
          CSN1Alt(alt={
            '0': ('', []),
            '1': ('', [
            CSN1Bit(name='uplink_control_timeslot_c2', bit=3)])}),
          CSN1Alt(alt={
            '0': ('', []),
            '1': ('', [
            CSN1Bit(name='pfi_of_downlink_tbf', bit=7)])}),
          CSN1Alt(alt={
            '0': ('', []),
            '1': ('', [
            CSN1Bit(name='pfi_of_uplink_tbf', bit=7)])}),
          CSN1Alt(alt={
            '0': ('', []),
            '1': ('', [
            CSN1Bit(name='uplink_rlc_mode')])}),
          CSN1Alt(alt={
            '0': ('', []),
            '1': ('', [
            CSN1Bit(name='downlink_npm_transfer_time', bit=5)])}),
          CSN1Alt(alt={
            '0': ('', []),
            '1': ('', [
            CSN1Bit(name='uplink_npm_transfer_time', bit=5)])}),
          CSN1Alt(alt={
            '0': ('', []),
            '1': ('', [
            CSN1Bit(name='event_based_fanr')])}),
          CSN1Alt(alt={
            '0': ('', []),
            '1': ('', [
            CSN1Alt(alt={
              '0': ('', []),
              '1': ('', [
              CSN1Bit(name='reported_timeslots_c1', bit=8),
              CSN1Alt(alt={
                '0': ('', []),
                '1': ('', [
                CSN1Bit(name='reported_timeslots_c2', bit=8)])}),
              CSN1Bit(name='tsh', bit=2)])})])}),
          CSN1Ref(name='uplink_egprs_level', obj=egprs_level_ie),
          CSN1Ref(name='downlink_egprs_level', obj=egprs_level_ie),
          CSN1Alt(alt={
            '0': ('', []),
            '1': ('', [
            CSN1Ref(name='pulse_format', obj=pulse_format_ie)])}),
          CSN1Alt(alt={
            '0': ('', [
            CSN1Bit(bit=-1)]),
            '1': ('', [
            CSN1Bit(name='indication_of_upper_layer_pdu_start_for_rlc_um'),
            CSN1Bit(name='enhanced_flexible_timeslot_assignment'),
            CSN1Alt(alt={
              '0': ('', [
              CSN1Bit(name='emst_nw_capability')]),
              '1': ('', [
              CSN1Alt(alt={
                '0': ('', []),
                '1': ('', [
                CSN1Ref(name='downlink_rlc_entity_2', obj=rlc_entity_struct),
                CSN1Alt(alt={
                  '0': ('', []),
                  '1': ('', [
                  CSN1Ref(name='downlink_rlc_entity_3', obj=rlc_entity_struct)])})])}),
              CSN1Alt(alt={
                '0': ('', []),
                '1': ('', [
                CSN1Ref(name='uplink_rlc_entity_2', obj=rlc_entity_struct),
                CSN1Alt(alt={
                  '0': ('', []),
                  '1': ('', [
                  CSN1Ref(name='uplink_rlc_entity_3', obj=rlc_entity_struct)])})])})])}),
            CSN1Alt(alt={
              '0': ('', []),
              '1': ('', [
              CSN1Bit(name='mtti_downlink_assignment_c1')])}),
            CSN1Alt(alt={
              '0': ('', []),
              '1': ('', [
              CSN1Bit(name='mtti_downlink_assignment_c2')])}),
            CSN1Alt(alt={
              '0': ('', []),
              '1': ('', [
              CSN1Bit(name='mtti_uplink_assignment_c1')])}),
            CSN1Alt(alt={
              '0': ('', []),
              '1': ('', [
              CSN1Bit(name='mtti_uplink_assignment_c2')])}),
            CSN1Alt(alt={
              '0': ('', [
              CSN1Bit(bit=-1)]),
              '1': ('', [
              CSN1Alt(alt={
                '0': ('', []),
                '1': ('', [
                CSN1List(num=-1, list=[
                  CSN1Val(name='', val='1'),
                  CSN1Ref(name='emsr_additional_pfcs_1', obj=additional_pfcs_struct)]),
                CSN1Val(name='', val='0'),
                CSN1List(num=-1, list=[
                  CSN1Val(name='', val='1'),
                  CSN1Ref(name='emsr_additional_pfcs_2', obj=additional_pfcs_struct)]),
                CSN1Val(name='', val='0'),
                CSN1List(num=-1, list=[
                  CSN1Val(name='', val='1'),
                  CSN1Ref(name='emsr_additional_pfcs_3', obj=additional_pfcs_struct)]),
                CSN1Val(name='', val='0')])}),
              CSN1Alt(alt={
                '0': ('', []),
                '1': ('', [
                CSN1List(num=-1, list=[
                  CSN1Val(name='', val='1'),
                  CSN1Ref(name='emsr_additional_pfcs_1', obj=additional_pfcs_struct)]),
                CSN1Val(name='', val='0'),
                CSN1List(num=-1, list=[
                  CSN1Val(name='', val='1'),
                  CSN1Ref(name='emsr_additional_pfcs_2', obj=additional_pfcs_struct)]),
                CSN1Val(name='', val='0'),
                CSN1List(num=-1, list=[
                  CSN1Val(name='', val='1'),
                  CSN1Ref(name='emsr_additional_pfcs_3', obj=additional_pfcs_struct)]),
                CSN1Val(name='', val='0')])}),
              CSN1Alt(alt={
                '0': ('', [
                CSN1Bit(bit=-1)]),
                '1': ('', [
                CSN1Bit(name='egprs_packet_downlink_ack_nack_type_3_support'),
                CSN1Alt(alt={
                  '0': ('', [
                  CSN1Bit(bit=-1)]),
                  '1': ('', [
                  CSN1Bit(name='primary_tsc_set'),
                  CSN1Alt(alt={
                    '0': ('', []),
                    '1': ('', [
                    CSN1Bit(name='secondary_dl_tsc_set'),
                    CSN1Bit(name='secondary_dl_tsc_value', bit=3)])}),
                  CSN1Ref(obj=padding_bits)]),
                  None: ('', [])})]),
                None: ('', [])})]),
              None: ('', [])})]),
            None: ('', [])})])]),
        '10': ('', [
        CSN1List(list=[
          CSN1Bit(name='downlink_rlc_mode'),
          CSN1Bit(name='control_ack'),
          CSN1List(num=-1, list=[
            CSN1Val(name='', val='1'),
            CSN1Ref(name='ufps', obj=ufps_struct)]),
          CSN1Val(name='', val='0'),
          CSN1Bit(name='dlmc_measurement_type'),
          CSN1Bit(name='link_quality_measurement_mode', bit=2),
          CSN1Alt(alt={
            '0': ('', []),
            '1': ('', [
            CSN1Bit(name='carrier_for_interference_measurements', bit=4)])}),
          CSN1Ref(name='global_packet_timing_advance', obj=global_packet_timing_advance_ie),
          CSN1Alt(alt={
            '0': ('', []),
            '1': ('', [
            CSN1Bit(name='packet_extended_timing_advance', bit=2)])}),
          CSN1Alt(alt={
            '0': ('', []),
            '1': ('', [
            CSN1Bit(name='ptcch_carrier', bit=4)])}),
          CSN1Bit(name='pdan_coding'),
          CSN1Bit(name='extended_sns'),
          CSN1Alt(alt={
            '0': ('', []),
            '1': ('', [
            CSN1Bit(name='bep_period2', bit=4)])}),
          CSN1Alt(alt={
            '0': ('', []),
            '1': ('', [
            CSN1Bit(name='pfi_of_downlink_tbf', bit=7)])}),
          CSN1Alt(alt={
            '0': ('', []),
            '1': ('', [
            CSN1Bit(name='downlink_npm_transfer_time', bit=5)])}),
          CSN1Alt(alt={
            '0': ('', []),
            '1': ('', [
            CSN1Bit(name='event_based_fanr')])}),
          CSN1Ref(name='downlink_egprs_level', obj=egprs_level_ie),
          CSN1Bit(name='indication_of_upper_layer_pdu_start_for_rlc_um'),
          CSN1Bit(name='egprs_packet_downlink_ack_nack_type_3_support'),
          CSN1Ref(name='egprs_channel_coding_command', obj=egprs_modulation_and_coding_scheme_ie)]),
        CSN1List(list=[
          CSN1Bit(name='resegment'),
          CSN1List(num=-1, list=[
            CSN1Val(name='', val='1'),
            CSN1Ref(name='dlmc_ul_carrier_info', obj=dlmc_ul_carrier_info_struct)]),
          CSN1Val(name='', val='0'),
          CSN1Alt(alt={
            '0': ('', []),
            '1': ('', [
            CSN1Ref(name='uplink_egprs_window_size', obj=egprs_window_size_ie)])}),
          CSN1Bit(name='uplink_tfi_assignment', bit=5),
          CSN1Alt(alt={
            '0': ('', []),
            '1': ('', [
            CSN1Bit(name='pfi_of_uplink_tbf', bit=7)])}),
          CSN1Alt(alt={
            '0': ('', []),
            '1': ('', [
            CSN1Bit(name='uplink_rlc_mode')])}),
          CSN1Alt(alt={
            '0': ('', []),
            '1': ('', [
            CSN1Bit(name='uplink_npm_transfer_time', bit=5)])}),
          CSN1Alt(alt={
            '0': ('', []),
            '1': ('', [
            CSN1Alt(alt={
              '0': ('', []),
              '1': ('', [
              CSN1Bit(name='reported_timeslots', bit=8),
              CSN1Bit(name='tsh', bit=2)])})])}),
          CSN1Ref(name='uplink_egprs_level', obj=egprs_level_ie),
          CSN1Alt(alt={
            '0': ('', []),
            '1': ('', [
            CSN1Ref(name='pulse_format', obj=pulse_format_ie)])}),
          CSN1Bit(name='enhanced_flexible_timeslot_assignment'),
          CSN1Alt(alt={
            '0': ('', []),
            '1': ('', [
            CSN1Bit(name='uplink_control_timeslot', bit=3)])})])])})])})])])

