# -*- coding: UTF-8 -*-
# Code automatically generated by pycrate_asn1c

from pycrate_asn1rt.utils            import *
from pycrate_asn1rt.err              import *
from pycrate_asn1rt.glob             import make_GLOBAL, GLOBAL
from pycrate_asn1rt.dictobj          import ASN1Dict
from pycrate_asn1rt.refobj           import *
from pycrate_asn1rt.setobj           import *
from pycrate_asn1rt.asnobj_basic     import *
from pycrate_asn1rt.asnobj_str       import *
from pycrate_asn1rt.asnobj_construct import *
from pycrate_asn1rt.asnobj_class     import *
from pycrate_asn1rt.asnobj_ext       import *
from pycrate_asn1rt.init             import init_modules

class PKIX1Explicit88:

    _name_  = u'PKIX1Explicit88'
    _oid_   = [1, 3, 6, 1, 5, 5, 7, 0, 18]
    
    _obj_ = [
        u'id-pkix',
        u'id-pe',
        u'id-qt',
        u'id-kp',
        u'id-ad',
        u'id-qt-cps',
        u'id-qt-unotice',
        u'id-ad-ocsp',
        u'id-ad-caIssuers',
        u'id-ad-timeStamping',
        u'id-ad-caRepository',
        u'Attribute',
        u'AttributeType',
        u'AttributeValue',
        u'AttributeTypeAndValue',
        u'id-at',
        u'id-at-name',
        u'id-at-surname',
        u'id-at-givenName',
        u'id-at-initials',
        u'id-at-generationQualifier',
        u'X520name',
        u'id-at-commonName',
        u'X520CommonName',
        u'id-at-localityName',
        u'X520LocalityName',
        u'id-at-stateOrProvinceName',
        u'X520StateOrProvinceName',
        u'id-at-organizationName',
        u'X520OrganizationName',
        u'id-at-organizationalUnitName',
        u'X520OrganizationalUnitName',
        u'id-at-title',
        u'X520Title',
        u'id-at-dnQualifier',
        u'X520dnQualifier',
        u'id-at-countryName',
        u'X520countryName',
        u'id-at-serialNumber',
        u'X520SerialNumber',
        u'id-at-pseudonym',
        u'X520Pseudonym',
        u'id-domainComponent',
        u'DomainComponent',
        u'pkcs-9',
        u'id-emailAddress',
        u'EmailAddress',
        u'Name',
        u'RDNSequence',
        u'DistinguishedName',
        u'RelativeDistinguishedName',
        u'DirectoryString',
        u'Certificate',
        u'TBSCertificate',
        u'Version',
        u'CertificateSerialNumber',
        u'Validity',
        u'Time',
        u'UniqueIdentifier',
        u'SubjectPublicKeyInfo',
        u'Extensions',
        u'Extension',
        u'CertificateList',
        u'TBSCertList',
        u'AlgorithmIdentifier',
        u'ORAddress',
        u'BuiltInStandardAttributes',
        u'CountryName',
        u'AdministrationDomainName',
        u'NetworkAddress',
        u'X121Address',
        u'TerminalIdentifier',
        u'PrivateDomainName',
        u'OrganizationName',
        u'NumericUserIdentifier',
        u'PersonalName',
        u'OrganizationalUnitNames',
        u'OrganizationalUnitName',
        u'BuiltInDomainDefinedAttributes',
        u'BuiltInDomainDefinedAttribute',
        u'ExtensionAttributes',
        u'ExtensionAttribute',
        u'common-name',
        u'CommonName',
        u'teletex-common-name',
        u'TeletexCommonName',
        u'teletex-organization-name',
        u'TeletexOrganizationName',
        u'teletex-personal-name',
        u'TeletexPersonalName',
        u'teletex-organizational-unit-names',
        u'TeletexOrganizationalUnitNames',
        u'TeletexOrganizationalUnitName',
        u'pds-name',
        u'PDSName',
        u'physical-delivery-country-name',
        u'PhysicalDeliveryCountryName',
        u'postal-code',
        u'PostalCode',
        u'physical-delivery-office-name',
        u'PhysicalDeliveryOfficeName',
        u'physical-delivery-office-number',
        u'PhysicalDeliveryOfficeNumber',
        u'extension-OR-address-components',
        u'ExtensionORAddressComponents',
        u'physical-delivery-personal-name',
        u'PhysicalDeliveryPersonalName',
        u'physical-delivery-organization-name',
        u'PhysicalDeliveryOrganizationName',
        u'extension-physical-delivery-address-components',
        u'ExtensionPhysicalDeliveryAddressComponents',
        u'unformatted-postal-address',
        u'UnformattedPostalAddress',
        u'street-address',
        u'StreetAddress',
        u'post-office-box-address',
        u'PostOfficeBoxAddress',
        u'poste-restante-address',
        u'PosteRestanteAddress',
        u'unique-postal-name',
        u'UniquePostalName',
        u'local-postal-attributes',
        u'LocalPostalAttributes',
        u'PDSParameter',
        u'extended-network-address',
        u'ExtendedNetworkAddress',
        u'PresentationAddress',
        u'terminal-type',
        u'TerminalType',
        u'teletex-domain-defined-attributes',
        u'TeletexDomainDefinedAttributes',
        u'TeletexDomainDefinedAttribute',
        u'ub-name',
        u'ub-common-name',
        u'ub-locality-name',
        u'ub-state-name',
        u'ub-organization-name',
        u'ub-organizational-unit-name',
        u'ub-title',
        u'ub-serial-number',
        u'ub-match',
        u'ub-emailaddress-length',
        u'ub-common-name-length',
        u'ub-country-name-alpha-length',
        u'ub-country-name-numeric-length',
        u'ub-domain-defined-attributes',
        u'ub-domain-defined-attribute-type-length',
        u'ub-domain-defined-attribute-value-length',
        u'ub-domain-name-length',
        u'ub-extension-attributes',
        u'ub-e163-4-number-length',
        u'ub-e163-4-sub-address-length',
        u'ub-generation-qualifier-length',
        u'ub-given-name-length',
        u'ub-initials-length',
        u'ub-integer-options',
        u'ub-numeric-user-id-length',
        u'ub-organization-name-length',
        u'ub-organizational-unit-name-length',
        u'ub-organizational-units',
        u'ub-pds-name-length',
        u'ub-pds-parameter-length',
        u'ub-pds-physical-address-lines',
        u'ub-postal-code-length',
        u'ub-pseudonym',
        u'ub-surname-length',
        u'ub-terminal-id-length',
        u'ub-unformatted-address-length',
        u'ub-x121-address-length',
        ]
    _type_ = [
        u'Attribute',
        u'AttributeType',
        u'AttributeValue',
        u'AttributeTypeAndValue',
        u'X520name',
        u'X520CommonName',
        u'X520LocalityName',
        u'X520StateOrProvinceName',
        u'X520OrganizationName',
        u'X520OrganizationalUnitName',
        u'X520Title',
        u'X520dnQualifier',
        u'X520countryName',
        u'X520SerialNumber',
        u'X520Pseudonym',
        u'DomainComponent',
        u'EmailAddress',
        u'Name',
        u'RDNSequence',
        u'DistinguishedName',
        u'RelativeDistinguishedName',
        u'DirectoryString',
        u'Certificate',
        u'TBSCertificate',
        u'Version',
        u'CertificateSerialNumber',
        u'Validity',
        u'Time',
        u'UniqueIdentifier',
        u'SubjectPublicKeyInfo',
        u'Extensions',
        u'Extension',
        u'CertificateList',
        u'TBSCertList',
        u'AlgorithmIdentifier',
        u'ORAddress',
        u'BuiltInStandardAttributes',
        u'CountryName',
        u'AdministrationDomainName',
        u'NetworkAddress',
        u'X121Address',
        u'TerminalIdentifier',
        u'PrivateDomainName',
        u'OrganizationName',
        u'NumericUserIdentifier',
        u'PersonalName',
        u'OrganizationalUnitNames',
        u'OrganizationalUnitName',
        u'BuiltInDomainDefinedAttributes',
        u'BuiltInDomainDefinedAttribute',
        u'ExtensionAttributes',
        u'ExtensionAttribute',
        u'CommonName',
        u'TeletexCommonName',
        u'TeletexOrganizationName',
        u'TeletexPersonalName',
        u'TeletexOrganizationalUnitNames',
        u'TeletexOrganizationalUnitName',
        u'PDSName',
        u'PhysicalDeliveryCountryName',
        u'PostalCode',
        u'PhysicalDeliveryOfficeName',
        u'PhysicalDeliveryOfficeNumber',
        u'ExtensionORAddressComponents',
        u'PhysicalDeliveryPersonalName',
        u'PhysicalDeliveryOrganizationName',
        u'ExtensionPhysicalDeliveryAddressComponents',
        u'UnformattedPostalAddress',
        u'StreetAddress',
        u'PostOfficeBoxAddress',
        u'PosteRestanteAddress',
        u'UniquePostalName',
        u'LocalPostalAttributes',
        u'PDSParameter',
        u'ExtendedNetworkAddress',
        u'PresentationAddress',
        u'TerminalType',
        u'TeletexDomainDefinedAttributes',
        u'TeletexDomainDefinedAttribute',
        ]
    _set_ = [
        ]
    _val_ = [
        u'id-pkix',
        u'id-pe',
        u'id-qt',
        u'id-kp',
        u'id-ad',
        u'id-qt-cps',
        u'id-qt-unotice',
        u'id-ad-ocsp',
        u'id-ad-caIssuers',
        u'id-ad-timeStamping',
        u'id-ad-caRepository',
        u'id-at',
        u'id-at-name',
        u'id-at-surname',
        u'id-at-givenName',
        u'id-at-initials',
        u'id-at-generationQualifier',
        u'id-at-commonName',
        u'id-at-localityName',
        u'id-at-stateOrProvinceName',
        u'id-at-organizationName',
        u'id-at-organizationalUnitName',
        u'id-at-title',
        u'id-at-dnQualifier',
        u'id-at-countryName',
        u'id-at-serialNumber',
        u'id-at-pseudonym',
        u'id-domainComponent',
        u'pkcs-9',
        u'id-emailAddress',
        u'common-name',
        u'teletex-common-name',
        u'teletex-organization-name',
        u'teletex-personal-name',
        u'teletex-organizational-unit-names',
        u'pds-name',
        u'physical-delivery-country-name',
        u'postal-code',
        u'physical-delivery-office-name',
        u'physical-delivery-office-number',
        u'extension-OR-address-components',
        u'physical-delivery-personal-name',
        u'physical-delivery-organization-name',
        u'extension-physical-delivery-address-components',
        u'unformatted-postal-address',
        u'street-address',
        u'post-office-box-address',
        u'poste-restante-address',
        u'unique-postal-name',
        u'local-postal-attributes',
        u'extended-network-address',
        u'terminal-type',
        u'teletex-domain-defined-attributes',
        u'ub-name',
        u'ub-common-name',
        u'ub-locality-name',
        u'ub-state-name',
        u'ub-organization-name',
        u'ub-organizational-unit-name',
        u'ub-title',
        u'ub-serial-number',
        u'ub-match',
        u'ub-emailaddress-length',
        u'ub-common-name-length',
        u'ub-country-name-alpha-length',
        u'ub-country-name-numeric-length',
        u'ub-domain-defined-attributes',
        u'ub-domain-defined-attribute-type-length',
        u'ub-domain-defined-attribute-value-length',
        u'ub-domain-name-length',
        u'ub-extension-attributes',
        u'ub-e163-4-number-length',
        u'ub-e163-4-sub-address-length',
        u'ub-generation-qualifier-length',
        u'ub-given-name-length',
        u'ub-initials-length',
        u'ub-integer-options',
        u'ub-numeric-user-id-length',
        u'ub-organization-name-length',
        u'ub-organizational-unit-name-length',
        u'ub-organizational-units',
        u'ub-pds-name-length',
        u'ub-pds-parameter-length',
        u'ub-pds-physical-address-lines',
        u'ub-postal-code-length',
        u'ub-pseudonym',
        u'ub-surname-length',
        u'ub-terminal-id-length',
        u'ub-unformatted-address-length',
        u'ub-x121-address-length',
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< id-pkix >-----#
    id_pkix = OID(name=u'id-pkix', mode=MODE_VALUE)
    id_pkix._val = (1, 3, 6, 1, 5, 5, 7)
    
    #-----< id-pe >-----#
    id_pe = OID(name=u'id-pe', mode=MODE_VALUE)
    id_pe._val = (1, 3, 6, 1, 5, 5, 7, 1)
    
    #-----< id-qt >-----#
    id_qt = OID(name=u'id-qt', mode=MODE_VALUE)
    id_qt._val = (1, 3, 6, 1, 5, 5, 7, 2)
    
    #-----< id-kp >-----#
    id_kp = OID(name=u'id-kp', mode=MODE_VALUE)
    id_kp._val = (1, 3, 6, 1, 5, 5, 7, 3)
    
    #-----< id-ad >-----#
    id_ad = OID(name=u'id-ad', mode=MODE_VALUE)
    id_ad._val = (1, 3, 6, 1, 5, 5, 7, 48)
    
    #-----< id-qt-cps >-----#
    id_qt_cps = OID(name=u'id-qt-cps', mode=MODE_VALUE)
    id_qt_cps._val = (1, 3, 6, 1, 5, 5, 7, 2, 1)
    
    #-----< id-qt-unotice >-----#
    id_qt_unotice = OID(name=u'id-qt-unotice', mode=MODE_VALUE)
    id_qt_unotice._val = (1, 3, 6, 1, 5, 5, 7, 2, 2)
    
    #-----< id-ad-ocsp >-----#
    id_ad_ocsp = OID(name=u'id-ad-ocsp', mode=MODE_VALUE)
    id_ad_ocsp._val = (1, 3, 6, 1, 5, 5, 7, 48, 1)
    
    #-----< id-ad-caIssuers >-----#
    id_ad_caIssuers = OID(name=u'id-ad-caIssuers', mode=MODE_VALUE)
    id_ad_caIssuers._val = (1, 3, 6, 1, 5, 5, 7, 48, 2)
    
    #-----< id-ad-timeStamping >-----#
    id_ad_timeStamping = OID(name=u'id-ad-timeStamping', mode=MODE_VALUE)
    id_ad_timeStamping._val = (1, 3, 6, 1, 5, 5, 7, 48, 3)
    
    #-----< id-ad-caRepository >-----#
    id_ad_caRepository = OID(name=u'id-ad-caRepository', mode=MODE_VALUE)
    id_ad_caRepository._val = (1, 3, 6, 1, 5, 5, 7, 48, 5)
    
    #-----< Attribute >-----#
    Attribute = SEQ(name=u'Attribute', mode=MODE_TYPE)
    _Attribute_type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'AttributeType')))
    _Attribute_values = SET_OF(name=u'values', mode=MODE_TYPE)
    __Attribute_values__item_ = ANY(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'AttributeValue')))
    _Attribute_values._cont = __Attribute_values__item_
    Attribute._cont = ASN1Dict([
        (u'type', _Attribute_type),
        (u'values', _Attribute_values),
        ])
    Attribute._ext = None
    
    #-----< AttributeType >-----#
    AttributeType = OID(name=u'AttributeType', mode=MODE_TYPE)
    
    #-----< AttributeValue >-----#
    AttributeValue = ANY(name=u'AttributeValue', mode=MODE_TYPE)
    
    #-----< AttributeTypeAndValue >-----#
    AttributeTypeAndValue = SEQ(name=u'AttributeTypeAndValue', mode=MODE_TYPE)
    _AttributeTypeAndValue_type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'AttributeType')))
    _AttributeTypeAndValue_value = ANY(name=u'value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'AttributeValue')))
    AttributeTypeAndValue._cont = ASN1Dict([
        (u'type', _AttributeTypeAndValue_type),
        (u'value', _AttributeTypeAndValue_value),
        ])
    AttributeTypeAndValue._ext = None
    
    #-----< id-at >-----#
    id_at = OID(name=u'id-at', mode=MODE_VALUE)
    id_at._val = (2, 5, 4)
    
    #-----< id-at-name >-----#
    id_at_name = OID(name=u'id-at-name', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit88', 'AttributeType')))
    id_at_name._val = (2, 5, 4, 41)
    
    #-----< id-at-surname >-----#
    id_at_surname = OID(name=u'id-at-surname', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit88', 'AttributeType')))
    id_at_surname._val = (2, 5, 4, 4)
    
    #-----< id-at-givenName >-----#
    id_at_givenName = OID(name=u'id-at-givenName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit88', 'AttributeType')))
    id_at_givenName._val = (2, 5, 4, 42)
    
    #-----< id-at-initials >-----#
    id_at_initials = OID(name=u'id-at-initials', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit88', 'AttributeType')))
    id_at_initials._val = (2, 5, 4, 43)
    
    #-----< id-at-generationQualifier >-----#
    id_at_generationQualifier = OID(name=u'id-at-generationQualifier', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit88', 'AttributeType')))
    id_at_generationQualifier._val = (2, 5, 4, 44)
    
    #-----< X520name >-----#
    X520name = CHOICE(name=u'X520name', mode=MODE_TYPE)
    _X520name_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _X520name_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32768)], ev=None, er=[])
    _X520name_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _X520name_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32768)], ev=None, er=[])
    _X520name_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _X520name_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32768)], ev=None, er=[])
    _X520name_utf8String = STR_UTF8(name=u'utf8String', mode=MODE_TYPE)
    _X520name_utf8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32768)], ev=None, er=[])
    _X520name_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _X520name_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32768)], ev=None, er=[])
    X520name._cont = ASN1Dict([
        (u'teletexString', _X520name_teletexString),
        (u'printableString', _X520name_printableString),
        (u'universalString', _X520name_universalString),
        (u'utf8String', _X520name_utf8String),
        (u'bmpString', _X520name_bmpString),
        ])
    X520name._ext = None
    
    #-----< id-at-commonName >-----#
    id_at_commonName = OID(name=u'id-at-commonName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit88', 'AttributeType')))
    id_at_commonName._val = (2, 5, 4, 3)
    
    #-----< X520CommonName >-----#
    X520CommonName = CHOICE(name=u'X520CommonName', mode=MODE_TYPE)
    _X520CommonName_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _X520CommonName_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520CommonName_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _X520CommonName_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520CommonName_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _X520CommonName_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520CommonName_utf8String = STR_UTF8(name=u'utf8String', mode=MODE_TYPE)
    _X520CommonName_utf8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520CommonName_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _X520CommonName_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    X520CommonName._cont = ASN1Dict([
        (u'teletexString', _X520CommonName_teletexString),
        (u'printableString', _X520CommonName_printableString),
        (u'universalString', _X520CommonName_universalString),
        (u'utf8String', _X520CommonName_utf8String),
        (u'bmpString', _X520CommonName_bmpString),
        ])
    X520CommonName._ext = None
    
    #-----< id-at-localityName >-----#
    id_at_localityName = OID(name=u'id-at-localityName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit88', 'AttributeType')))
    id_at_localityName._val = (2, 5, 4, 7)
    
    #-----< X520LocalityName >-----#
    X520LocalityName = CHOICE(name=u'X520LocalityName', mode=MODE_TYPE)
    _X520LocalityName_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _X520LocalityName_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _X520LocalityName_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _X520LocalityName_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _X520LocalityName_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _X520LocalityName_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _X520LocalityName_utf8String = STR_UTF8(name=u'utf8String', mode=MODE_TYPE)
    _X520LocalityName_utf8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _X520LocalityName_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _X520LocalityName_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    X520LocalityName._cont = ASN1Dict([
        (u'teletexString', _X520LocalityName_teletexString),
        (u'printableString', _X520LocalityName_printableString),
        (u'universalString', _X520LocalityName_universalString),
        (u'utf8String', _X520LocalityName_utf8String),
        (u'bmpString', _X520LocalityName_bmpString),
        ])
    X520LocalityName._ext = None
    
    #-----< id-at-stateOrProvinceName >-----#
    id_at_stateOrProvinceName = OID(name=u'id-at-stateOrProvinceName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit88', 'AttributeType')))
    id_at_stateOrProvinceName._val = (2, 5, 4, 8)
    
    #-----< X520StateOrProvinceName >-----#
    X520StateOrProvinceName = CHOICE(name=u'X520StateOrProvinceName', mode=MODE_TYPE)
    _X520StateOrProvinceName_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _X520StateOrProvinceName_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _X520StateOrProvinceName_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _X520StateOrProvinceName_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _X520StateOrProvinceName_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _X520StateOrProvinceName_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _X520StateOrProvinceName_utf8String = STR_UTF8(name=u'utf8String', mode=MODE_TYPE)
    _X520StateOrProvinceName_utf8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _X520StateOrProvinceName_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _X520StateOrProvinceName_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    X520StateOrProvinceName._cont = ASN1Dict([
        (u'teletexString', _X520StateOrProvinceName_teletexString),
        (u'printableString', _X520StateOrProvinceName_printableString),
        (u'universalString', _X520StateOrProvinceName_universalString),
        (u'utf8String', _X520StateOrProvinceName_utf8String),
        (u'bmpString', _X520StateOrProvinceName_bmpString),
        ])
    X520StateOrProvinceName._ext = None
    
    #-----< id-at-organizationName >-----#
    id_at_organizationName = OID(name=u'id-at-organizationName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit88', 'AttributeType')))
    id_at_organizationName._val = (2, 5, 4, 10)
    
    #-----< X520OrganizationName >-----#
    X520OrganizationName = CHOICE(name=u'X520OrganizationName', mode=MODE_TYPE)
    _X520OrganizationName_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _X520OrganizationName_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520OrganizationName_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _X520OrganizationName_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520OrganizationName_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _X520OrganizationName_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520OrganizationName_utf8String = STR_UTF8(name=u'utf8String', mode=MODE_TYPE)
    _X520OrganizationName_utf8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520OrganizationName_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _X520OrganizationName_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    X520OrganizationName._cont = ASN1Dict([
        (u'teletexString', _X520OrganizationName_teletexString),
        (u'printableString', _X520OrganizationName_printableString),
        (u'universalString', _X520OrganizationName_universalString),
        (u'utf8String', _X520OrganizationName_utf8String),
        (u'bmpString', _X520OrganizationName_bmpString),
        ])
    X520OrganizationName._ext = None
    
    #-----< id-at-organizationalUnitName >-----#
    id_at_organizationalUnitName = OID(name=u'id-at-organizationalUnitName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit88', 'AttributeType')))
    id_at_organizationalUnitName._val = (2, 5, 4, 11)
    
    #-----< X520OrganizationalUnitName >-----#
    X520OrganizationalUnitName = CHOICE(name=u'X520OrganizationalUnitName', mode=MODE_TYPE)
    _X520OrganizationalUnitName_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _X520OrganizationalUnitName_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520OrganizationalUnitName_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _X520OrganizationalUnitName_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520OrganizationalUnitName_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _X520OrganizationalUnitName_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520OrganizationalUnitName_utf8String = STR_UTF8(name=u'utf8String', mode=MODE_TYPE)
    _X520OrganizationalUnitName_utf8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520OrganizationalUnitName_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _X520OrganizationalUnitName_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    X520OrganizationalUnitName._cont = ASN1Dict([
        (u'teletexString', _X520OrganizationalUnitName_teletexString),
        (u'printableString', _X520OrganizationalUnitName_printableString),
        (u'universalString', _X520OrganizationalUnitName_universalString),
        (u'utf8String', _X520OrganizationalUnitName_utf8String),
        (u'bmpString', _X520OrganizationalUnitName_bmpString),
        ])
    X520OrganizationalUnitName._ext = None
    
    #-----< id-at-title >-----#
    id_at_title = OID(name=u'id-at-title', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit88', 'AttributeType')))
    id_at_title._val = (2, 5, 4, 12)
    
    #-----< X520Title >-----#
    X520Title = CHOICE(name=u'X520Title', mode=MODE_TYPE)
    _X520Title_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _X520Title_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520Title_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _X520Title_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520Title_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _X520Title_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520Title_utf8String = STR_UTF8(name=u'utf8String', mode=MODE_TYPE)
    _X520Title_utf8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520Title_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _X520Title_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    X520Title._cont = ASN1Dict([
        (u'teletexString', _X520Title_teletexString),
        (u'printableString', _X520Title_printableString),
        (u'universalString', _X520Title_universalString),
        (u'utf8String', _X520Title_utf8String),
        (u'bmpString', _X520Title_bmpString),
        ])
    X520Title._ext = None
    
    #-----< id-at-dnQualifier >-----#
    id_at_dnQualifier = OID(name=u'id-at-dnQualifier', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit88', 'AttributeType')))
    id_at_dnQualifier._val = (2, 5, 4, 46)
    
    #-----< X520dnQualifier >-----#
    X520dnQualifier = STR_PRINT(name=u'X520dnQualifier', mode=MODE_TYPE)
    
    #-----< id-at-countryName >-----#
    id_at_countryName = OID(name=u'id-at-countryName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit88', 'AttributeType')))
    id_at_countryName._val = (2, 5, 4, 6)
    
    #-----< X520countryName >-----#
    X520countryName = STR_PRINT(name=u'X520countryName', mode=MODE_TYPE)
    X520countryName._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    
    #-----< id-at-serialNumber >-----#
    id_at_serialNumber = OID(name=u'id-at-serialNumber', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit88', 'AttributeType')))
    id_at_serialNumber._val = (2, 5, 4, 5)
    
    #-----< X520SerialNumber >-----#
    X520SerialNumber = STR_PRINT(name=u'X520SerialNumber', mode=MODE_TYPE)
    X520SerialNumber._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    
    #-----< id-at-pseudonym >-----#
    id_at_pseudonym = OID(name=u'id-at-pseudonym', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit88', 'AttributeType')))
    id_at_pseudonym._val = (2, 5, 4, 65)
    
    #-----< X520Pseudonym >-----#
    X520Pseudonym = CHOICE(name=u'X520Pseudonym', mode=MODE_TYPE)
    _X520Pseudonym_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _X520Pseudonym_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _X520Pseudonym_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _X520Pseudonym_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _X520Pseudonym_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _X520Pseudonym_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _X520Pseudonym_utf8String = STR_UTF8(name=u'utf8String', mode=MODE_TYPE)
    _X520Pseudonym_utf8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _X520Pseudonym_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _X520Pseudonym_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    X520Pseudonym._cont = ASN1Dict([
        (u'teletexString', _X520Pseudonym_teletexString),
        (u'printableString', _X520Pseudonym_printableString),
        (u'universalString', _X520Pseudonym_universalString),
        (u'utf8String', _X520Pseudonym_utf8String),
        (u'bmpString', _X520Pseudonym_bmpString),
        ])
    X520Pseudonym._ext = None
    
    #-----< id-domainComponent >-----#
    id_domainComponent = OID(name=u'id-domainComponent', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit88', 'AttributeType')))
    id_domainComponent._val = (0, 9, 2342, 19200300, 100, 1, 25)
    
    #-----< DomainComponent >-----#
    DomainComponent = STR_IA5(name=u'DomainComponent', mode=MODE_TYPE)
    
    #-----< pkcs-9 >-----#
    pkcs_9 = OID(name=u'pkcs-9', mode=MODE_VALUE)
    pkcs_9._val = (1, 2, 840, 113549, 1, 9)
    
    #-----< id-emailAddress >-----#
    id_emailAddress = OID(name=u'id-emailAddress', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit88', 'AttributeType')))
    id_emailAddress._val = (1, 2, 840, 113549, 1, 9, 1)
    
    #-----< EmailAddress >-----#
    EmailAddress = STR_IA5(name=u'EmailAddress', mode=MODE_TYPE)
    EmailAddress._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=255)], ev=None, er=[])
    
    #-----< Name >-----#
    Name = CHOICE(name=u'Name', mode=MODE_TYPE)
    _Name_rdnSequence = SEQ_OF(name=u'rdnSequence', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'RDNSequence')))
    Name._cont = ASN1Dict([
        (u'rdnSequence', _Name_rdnSequence),
        ])
    Name._ext = None
    
    #-----< RDNSequence >-----#
    RDNSequence = SEQ_OF(name=u'RDNSequence', mode=MODE_TYPE)
    _RDNSequence__item_ = SET_OF(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'RelativeDistinguishedName')))
    RDNSequence._cont = _RDNSequence__item_
    
    #-----< DistinguishedName >-----#
    DistinguishedName = SEQ_OF(name=u'DistinguishedName', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'RDNSequence')))
    
    #-----< RelativeDistinguishedName >-----#
    RelativeDistinguishedName = SET_OF(name=u'RelativeDistinguishedName', mode=MODE_TYPE)
    _RelativeDistinguishedName__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'AttributeTypeAndValue')))
    RelativeDistinguishedName._cont = _RelativeDistinguishedName__item_
    RelativeDistinguishedName._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< DirectoryString >-----#
    DirectoryString = CHOICE(name=u'DirectoryString', mode=MODE_TYPE)
    _DirectoryString_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _DirectoryString_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _DirectoryString_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _DirectoryString_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _DirectoryString_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _DirectoryString_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _DirectoryString_utf8String = STR_UTF8(name=u'utf8String', mode=MODE_TYPE)
    _DirectoryString_utf8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _DirectoryString_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _DirectoryString_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    DirectoryString._cont = ASN1Dict([
        (u'teletexString', _DirectoryString_teletexString),
        (u'printableString', _DirectoryString_printableString),
        (u'universalString', _DirectoryString_universalString),
        (u'utf8String', _DirectoryString_utf8String),
        (u'bmpString', _DirectoryString_bmpString),
        ])
    DirectoryString._ext = None
    
    #-----< Certificate >-----#
    Certificate = SEQ(name=u'Certificate', mode=MODE_TYPE)
    _Certificate_tbsCertificate = SEQ(name=u'tbsCertificate', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'TBSCertificate')))
    _Certificate_signatureAlgorithm = SEQ(name=u'signatureAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'AlgorithmIdentifier')))
    _Certificate_signature = BIT_STR(name=u'signature', mode=MODE_TYPE)
    Certificate._cont = ASN1Dict([
        (u'tbsCertificate', _Certificate_tbsCertificate),
        (u'signatureAlgorithm', _Certificate_signatureAlgorithm),
        (u'signature', _Certificate_signature),
        ])
    Certificate._ext = None
    
    #-----< TBSCertificate >-----#
    TBSCertificate = SEQ(name=u'TBSCertificate', mode=MODE_TYPE)
    _TBSCertificate_version = INT(name=u'version', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIX1Explicit88', 'Version')), default=0)
    _TBSCertificate_serialNumber = INT(name=u'serialNumber', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'CertificateSerialNumber')))
    _TBSCertificate_signature = SEQ(name=u'signature', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'AlgorithmIdentifier')))
    _TBSCertificate_issuer = CHOICE(name=u'issuer', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'Name')))
    _TBSCertificate_validity = SEQ(name=u'validity', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'Validity')))
    _TBSCertificate_subject = CHOICE(name=u'subject', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'Name')))
    _TBSCertificate_subjectPublicKeyInfo = SEQ(name=u'subjectPublicKeyInfo', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'SubjectPublicKeyInfo')))
    _TBSCertificate_issuerUniqueID = BIT_STR(name=u'issuerUniqueID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Explicit88', 'UniqueIdentifier')), opt=True)
    _TBSCertificate_subjectUniqueID = BIT_STR(name=u'subjectUniqueID', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Explicit88', 'UniqueIdentifier')), opt=True)
    _TBSCertificate_extensions = SEQ_OF(name=u'extensions', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIX1Explicit88', 'Extensions')), opt=True)
    TBSCertificate._cont = ASN1Dict([
        (u'version', _TBSCertificate_version),
        (u'serialNumber', _TBSCertificate_serialNumber),
        (u'signature', _TBSCertificate_signature),
        (u'issuer', _TBSCertificate_issuer),
        (u'validity', _TBSCertificate_validity),
        (u'subject', _TBSCertificate_subject),
        (u'subjectPublicKeyInfo', _TBSCertificate_subjectPublicKeyInfo),
        (u'issuerUniqueID', _TBSCertificate_issuerUniqueID),
        (u'subjectUniqueID', _TBSCertificate_subjectUniqueID),
        (u'extensions', _TBSCertificate_extensions),
        ])
    TBSCertificate._ext = None
    
    #-----< Version >-----#
    Version = INT(name=u'Version', mode=MODE_TYPE)
    Version._cont = ASN1Dict([(u'v1', 0), (u'v2', 1), (u'v3', 2)])
    
    #-----< CertificateSerialNumber >-----#
    CertificateSerialNumber = INT(name=u'CertificateSerialNumber', mode=MODE_TYPE)
    
    #-----< Validity >-----#
    Validity = SEQ(name=u'Validity', mode=MODE_TYPE)
    _Validity_notBefore = CHOICE(name=u'notBefore', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'Time')))
    _Validity_notAfter = CHOICE(name=u'notAfter', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'Time')))
    Validity._cont = ASN1Dict([
        (u'notBefore', _Validity_notBefore),
        (u'notAfter', _Validity_notAfter),
        ])
    Validity._ext = None
    
    #-----< Time >-----#
    Time = CHOICE(name=u'Time', mode=MODE_TYPE)
    _Time_utcTime = TIME_UTC(name=u'utcTime', mode=MODE_TYPE)
    _Time_generalTime = TIME_GEN(name=u'generalTime', mode=MODE_TYPE)
    Time._cont = ASN1Dict([
        (u'utcTime', _Time_utcTime),
        (u'generalTime', _Time_generalTime),
        ])
    Time._ext = None
    
    #-----< UniqueIdentifier >-----#
    UniqueIdentifier = BIT_STR(name=u'UniqueIdentifier', mode=MODE_TYPE)
    
    #-----< SubjectPublicKeyInfo >-----#
    SubjectPublicKeyInfo = SEQ(name=u'SubjectPublicKeyInfo', mode=MODE_TYPE)
    _SubjectPublicKeyInfo_algorithm = SEQ(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'AlgorithmIdentifier')))
    _SubjectPublicKeyInfo_subjectPublicKey = BIT_STR(name=u'subjectPublicKey', mode=MODE_TYPE)
    SubjectPublicKeyInfo._cont = ASN1Dict([
        (u'algorithm', _SubjectPublicKeyInfo_algorithm),
        (u'subjectPublicKey', _SubjectPublicKeyInfo_subjectPublicKey),
        ])
    SubjectPublicKeyInfo._ext = None
    
    #-----< Extensions >-----#
    Extensions = SEQ_OF(name=u'Extensions', mode=MODE_TYPE)
    _Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'Extension')))
    Extensions._cont = _Extensions__item_
    Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< Extension >-----#
    Extension = SEQ(name=u'Extension', mode=MODE_TYPE)
    _Extension_extnID = OID(name=u'extnID', mode=MODE_TYPE)
    _Extension_critical = BOOL(name=u'critical', mode=MODE_TYPE, default=False)
    _Extension_extnValue = OCT_STR(name=u'extnValue', mode=MODE_TYPE)
    Extension._cont = ASN1Dict([
        (u'extnID', _Extension_extnID),
        (u'critical', _Extension_critical),
        (u'extnValue', _Extension_extnValue),
        ])
    Extension._ext = None
    
    #-----< CertificateList >-----#
    CertificateList = SEQ(name=u'CertificateList', mode=MODE_TYPE)
    _CertificateList_tbsCertList = SEQ(name=u'tbsCertList', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'TBSCertList')))
    _CertificateList_signatureAlgorithm = SEQ(name=u'signatureAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'AlgorithmIdentifier')))
    _CertificateList_signature = BIT_STR(name=u'signature', mode=MODE_TYPE)
    CertificateList._cont = ASN1Dict([
        (u'tbsCertList', _CertificateList_tbsCertList),
        (u'signatureAlgorithm', _CertificateList_signatureAlgorithm),
        (u'signature', _CertificateList_signature),
        ])
    CertificateList._ext = None
    
    #-----< TBSCertList >-----#
    TBSCertList = SEQ(name=u'TBSCertList', mode=MODE_TYPE)
    _TBSCertList_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'Version')), opt=True)
    _TBSCertList_signature = SEQ(name=u'signature', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'AlgorithmIdentifier')))
    _TBSCertList_issuer = CHOICE(name=u'issuer', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'Name')))
    _TBSCertList_thisUpdate = CHOICE(name=u'thisUpdate', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'Time')))
    _TBSCertList_nextUpdate = CHOICE(name=u'nextUpdate', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'Time')), opt=True)
    _TBSCertList_revokedCertificates = SEQ_OF(name=u'revokedCertificates', mode=MODE_TYPE, opt=True)
    __TBSCertList_revokedCertificates__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    ___TBSCertList_revokedCertificates__item__userCertificate = INT(name=u'userCertificate', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'CertificateSerialNumber')))
    ___TBSCertList_revokedCertificates__item__revocationDate = CHOICE(name=u'revocationDate', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'Time')))
    ___TBSCertList_revokedCertificates__item__crlEntryExtensions = SEQ_OF(name=u'crlEntryExtensions', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'Extensions')), opt=True)
    __TBSCertList_revokedCertificates__item_._cont = ASN1Dict([
        (u'userCertificate', ___TBSCertList_revokedCertificates__item__userCertificate),
        (u'revocationDate', ___TBSCertList_revokedCertificates__item__revocationDate),
        (u'crlEntryExtensions', ___TBSCertList_revokedCertificates__item__crlEntryExtensions),
        ])
    __TBSCertList_revokedCertificates__item_._ext = None
    _TBSCertList_revokedCertificates._cont = __TBSCertList_revokedCertificates__item_
    _TBSCertList_crlExtensions = SEQ_OF(name=u'crlExtensions', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIX1Explicit88', 'Extensions')), opt=True)
    TBSCertList._cont = ASN1Dict([
        (u'version', _TBSCertList_version),
        (u'signature', _TBSCertList_signature),
        (u'issuer', _TBSCertList_issuer),
        (u'thisUpdate', _TBSCertList_thisUpdate),
        (u'nextUpdate', _TBSCertList_nextUpdate),
        (u'revokedCertificates', _TBSCertList_revokedCertificates),
        (u'crlExtensions', _TBSCertList_crlExtensions),
        ])
    TBSCertList._ext = None
    
    #-----< AlgorithmIdentifier >-----#
    AlgorithmIdentifier = SEQ(name=u'AlgorithmIdentifier', mode=MODE_TYPE)
    _AlgorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE)
    _AlgorithmIdentifier_parameters = ANY(name=u'parameters', mode=MODE_TYPE, opt=True, defby=u'algorithm')
    AlgorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _AlgorithmIdentifier_algorithm),
        (u'parameters', _AlgorithmIdentifier_parameters),
        ])
    AlgorithmIdentifier._ext = None
    
    #-----< ORAddress >-----#
    ORAddress = SEQ(name=u'ORAddress', mode=MODE_TYPE)
    _ORAddress_built_in_standard_attributes = SEQ(name=u'built-in-standard-attributes', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'BuiltInStandardAttributes')))
    _ORAddress_built_in_domain_defined_attributes = SEQ_OF(name=u'built-in-domain-defined-attributes', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'BuiltInDomainDefinedAttributes')), opt=True)
    _ORAddress_extension_attributes = SET_OF(name=u'extension-attributes', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'ExtensionAttributes')), opt=True)
    ORAddress._cont = ASN1Dict([
        (u'built-in-standard-attributes', _ORAddress_built_in_standard_attributes),
        (u'built-in-domain-defined-attributes', _ORAddress_built_in_domain_defined_attributes),
        (u'extension-attributes', _ORAddress_extension_attributes),
        ])
    ORAddress._ext = None
    
    #-----< BuiltInStandardAttributes >-----#
    BuiltInStandardAttributes = SEQ(name=u'BuiltInStandardAttributes', mode=MODE_TYPE)
    _BuiltInStandardAttributes_country_name = CHOICE(name=u'country-name', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'CountryName')), opt=True)
    _BuiltInStandardAttributes_administration_domain_name = CHOICE(name=u'administration-domain-name', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'AdministrationDomainName')), opt=True)
    _BuiltInStandardAttributes_network_address = STR_NUM(name=u'network-address', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Explicit88', 'NetworkAddress')), opt=True)
    _BuiltInStandardAttributes_terminal_identifier = STR_PRINT(name=u'terminal-identifier', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Explicit88', 'TerminalIdentifier')), opt=True)
    _BuiltInStandardAttributes_private_domain_name = CHOICE(name=u'private-domain-name', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIX1Explicit88', 'PrivateDomainName')), opt=True)
    _BuiltInStandardAttributes_organization_name = STR_PRINT(name=u'organization-name', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Explicit88', 'OrganizationName')), opt=True)
    _BuiltInStandardAttributes_numeric_user_identifier = STR_NUM(name=u'numeric-user-identifier', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Explicit88', 'NumericUserIdentifier')), opt=True)
    _BuiltInStandardAttributes_personal_name = SET(name=u'personal-name', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Explicit88', 'PersonalName')), opt=True)
    _BuiltInStandardAttributes_organizational_unit_names = SEQ_OF(name=u'organizational-unit-names', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Explicit88', 'OrganizationalUnitNames')), opt=True)
    BuiltInStandardAttributes._cont = ASN1Dict([
        (u'country-name', _BuiltInStandardAttributes_country_name),
        (u'administration-domain-name', _BuiltInStandardAttributes_administration_domain_name),
        (u'network-address', _BuiltInStandardAttributes_network_address),
        (u'terminal-identifier', _BuiltInStandardAttributes_terminal_identifier),
        (u'private-domain-name', _BuiltInStandardAttributes_private_domain_name),
        (u'organization-name', _BuiltInStandardAttributes_organization_name),
        (u'numeric-user-identifier', _BuiltInStandardAttributes_numeric_user_identifier),
        (u'personal-name', _BuiltInStandardAttributes_personal_name),
        (u'organizational-unit-names', _BuiltInStandardAttributes_organizational_unit_names),
        ])
    BuiltInStandardAttributes._ext = None
    
    #-----< CountryName >-----#
    CountryName = CHOICE(name=u'CountryName', mode=MODE_TYPE, tag=(1, TAG_APPLICATION, TAG_EXPLICIT))
    _CountryName_x121_dcc_code = STR_NUM(name=u'x121-dcc-code', mode=MODE_TYPE)
    _CountryName_x121_dcc_code._const_sz = ASN1Set(rv=[3], rr=[], ev=None, er=[])
    _CountryName_iso_3166_alpha2_code = STR_PRINT(name=u'iso-3166-alpha2-code', mode=MODE_TYPE)
    _CountryName_iso_3166_alpha2_code._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    CountryName._cont = ASN1Dict([
        (u'x121-dcc-code', _CountryName_x121_dcc_code),
        (u'iso-3166-alpha2-code', _CountryName_iso_3166_alpha2_code),
        ])
    CountryName._ext = None
    
    #-----< AdministrationDomainName >-----#
    AdministrationDomainName = CHOICE(name=u'AdministrationDomainName', mode=MODE_TYPE, tag=(2, TAG_APPLICATION, TAG_EXPLICIT))
    _AdministrationDomainName_numeric = STR_NUM(name=u'numeric', mode=MODE_TYPE)
    _AdministrationDomainName_numeric._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=16)], ev=None, er=[])
    _AdministrationDomainName_printable = STR_PRINT(name=u'printable', mode=MODE_TYPE)
    _AdministrationDomainName_printable._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=16)], ev=None, er=[])
    AdministrationDomainName._cont = ASN1Dict([
        (u'numeric', _AdministrationDomainName_numeric),
        (u'printable', _AdministrationDomainName_printable),
        ])
    AdministrationDomainName._ext = None
    
    #-----< NetworkAddress >-----#
    NetworkAddress = STR_NUM(name=u'NetworkAddress', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'X121Address')))
    
    #-----< X121Address >-----#
    X121Address = STR_NUM(name=u'X121Address', mode=MODE_TYPE)
    X121Address._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    
    #-----< TerminalIdentifier >-----#
    TerminalIdentifier = STR_PRINT(name=u'TerminalIdentifier', mode=MODE_TYPE)
    TerminalIdentifier._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=24)], ev=None, er=[])
    
    #-----< PrivateDomainName >-----#
    PrivateDomainName = CHOICE(name=u'PrivateDomainName', mode=MODE_TYPE)
    _PrivateDomainName_numeric = STR_NUM(name=u'numeric', mode=MODE_TYPE)
    _PrivateDomainName_numeric._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    _PrivateDomainName_printable = STR_PRINT(name=u'printable', mode=MODE_TYPE)
    _PrivateDomainName_printable._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    PrivateDomainName._cont = ASN1Dict([
        (u'numeric', _PrivateDomainName_numeric),
        (u'printable', _PrivateDomainName_printable),
        ])
    PrivateDomainName._ext = None
    
    #-----< OrganizationName >-----#
    OrganizationName = STR_PRINT(name=u'OrganizationName', mode=MODE_TYPE)
    OrganizationName._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    
    #-----< NumericUserIdentifier >-----#
    NumericUserIdentifier = STR_NUM(name=u'NumericUserIdentifier', mode=MODE_TYPE)
    NumericUserIdentifier._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    
    #-----< PersonalName >-----#
    PersonalName = SET(name=u'PersonalName', mode=MODE_TYPE)
    _PersonalName_surname = STR_PRINT(name=u'surname', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _PersonalName_surname._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=40)], ev=None, er=[])
    _PersonalName_given_name = STR_PRINT(name=u'given-name', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _PersonalName_given_name._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    _PersonalName_initials = STR_PRINT(name=u'initials', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _PersonalName_initials._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=5)], ev=None, er=[])
    _PersonalName_generation_qualifier = STR_PRINT(name=u'generation-qualifier', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _PersonalName_generation_qualifier._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=3)], ev=None, er=[])
    PersonalName._cont = ASN1Dict([
        (u'surname', _PersonalName_surname),
        (u'given-name', _PersonalName_given_name),
        (u'initials', _PersonalName_initials),
        (u'generation-qualifier', _PersonalName_generation_qualifier),
        ])
    PersonalName._ext = None
    
    #-----< OrganizationalUnitNames >-----#
    OrganizationalUnitNames = SEQ_OF(name=u'OrganizationalUnitNames', mode=MODE_TYPE)
    _OrganizationalUnitNames__item_ = STR_PRINT(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'OrganizationalUnitName')))
    OrganizationalUnitNames._cont = _OrganizationalUnitNames__item_
    OrganizationalUnitNames._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4)], ev=None, er=[])
    
    #-----< OrganizationalUnitName >-----#
    OrganizationalUnitName = STR_PRINT(name=u'OrganizationalUnitName', mode=MODE_TYPE)
    OrganizationalUnitName._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    
    #-----< BuiltInDomainDefinedAttributes >-----#
    BuiltInDomainDefinedAttributes = SEQ_OF(name=u'BuiltInDomainDefinedAttributes', mode=MODE_TYPE)
    _BuiltInDomainDefinedAttributes__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'BuiltInDomainDefinedAttribute')))
    BuiltInDomainDefinedAttributes._cont = _BuiltInDomainDefinedAttributes__item_
    BuiltInDomainDefinedAttributes._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4)], ev=None, er=[])
    
    #-----< BuiltInDomainDefinedAttribute >-----#
    BuiltInDomainDefinedAttribute = SEQ(name=u'BuiltInDomainDefinedAttribute', mode=MODE_TYPE)
    _BuiltInDomainDefinedAttribute_type = STR_PRINT(name=u'type', mode=MODE_TYPE)
    _BuiltInDomainDefinedAttribute_type._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    _BuiltInDomainDefinedAttribute_value = STR_PRINT(name=u'value', mode=MODE_TYPE)
    _BuiltInDomainDefinedAttribute_value._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    BuiltInDomainDefinedAttribute._cont = ASN1Dict([
        (u'type', _BuiltInDomainDefinedAttribute_type),
        (u'value', _BuiltInDomainDefinedAttribute_value),
        ])
    BuiltInDomainDefinedAttribute._ext = None
    
    #-----< ExtensionAttributes >-----#
    ExtensionAttributes = SET_OF(name=u'ExtensionAttributes', mode=MODE_TYPE)
    _ExtensionAttributes__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'ExtensionAttribute')))
    ExtensionAttributes._cont = _ExtensionAttributes__item_
    ExtensionAttributes._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    
    #-----< ExtensionAttribute >-----#
    ExtensionAttribute = SEQ(name=u'ExtensionAttribute', mode=MODE_TYPE)
    _ExtensionAttribute_extension_attribute_type = INT(name=u'extension-attribute-type', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ExtensionAttribute_extension_attribute_type._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=256)], ev=None, er=[])
    _ExtensionAttribute_extension_attribute_value = ANY(name=u'extension-attribute-value', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), defby=u'extension-attribute-type')
    ExtensionAttribute._cont = ASN1Dict([
        (u'extension-attribute-type', _ExtensionAttribute_extension_attribute_type),
        (u'extension-attribute-value', _ExtensionAttribute_extension_attribute_value),
        ])
    ExtensionAttribute._ext = None
    
    #-----< common-name >-----#
    common_name = INT(name=u'common-name', mode=MODE_VALUE)
    common_name._val = 1
    
    #-----< CommonName >-----#
    CommonName = STR_PRINT(name=u'CommonName', mode=MODE_TYPE)
    CommonName._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    
    #-----< teletex-common-name >-----#
    teletex_common_name = INT(name=u'teletex-common-name', mode=MODE_VALUE)
    teletex_common_name._val = 2
    
    #-----< TeletexCommonName >-----#
    TeletexCommonName = STR_TELE(name=u'TeletexCommonName', mode=MODE_TYPE)
    TeletexCommonName._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    
    #-----< teletex-organization-name >-----#
    teletex_organization_name = INT(name=u'teletex-organization-name', mode=MODE_VALUE)
    teletex_organization_name._val = 3
    
    #-----< TeletexOrganizationName >-----#
    TeletexOrganizationName = STR_TELE(name=u'TeletexOrganizationName', mode=MODE_TYPE)
    TeletexOrganizationName._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    
    #-----< teletex-personal-name >-----#
    teletex_personal_name = INT(name=u'teletex-personal-name', mode=MODE_VALUE)
    teletex_personal_name._val = 4
    
    #-----< TeletexPersonalName >-----#
    TeletexPersonalName = SET(name=u'TeletexPersonalName', mode=MODE_TYPE)
    _TeletexPersonalName_surname = STR_TELE(name=u'surname', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _TeletexPersonalName_surname._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=40)], ev=None, er=[])
    _TeletexPersonalName_given_name = STR_TELE(name=u'given-name', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _TeletexPersonalName_given_name._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    _TeletexPersonalName_initials = STR_TELE(name=u'initials', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _TeletexPersonalName_initials._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=5)], ev=None, er=[])
    _TeletexPersonalName_generation_qualifier = STR_TELE(name=u'generation-qualifier', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _TeletexPersonalName_generation_qualifier._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=3)], ev=None, er=[])
    TeletexPersonalName._cont = ASN1Dict([
        (u'surname', _TeletexPersonalName_surname),
        (u'given-name', _TeletexPersonalName_given_name),
        (u'initials', _TeletexPersonalName_initials),
        (u'generation-qualifier', _TeletexPersonalName_generation_qualifier),
        ])
    TeletexPersonalName._ext = None
    
    #-----< teletex-organizational-unit-names >-----#
    teletex_organizational_unit_names = INT(name=u'teletex-organizational-unit-names', mode=MODE_VALUE)
    teletex_organizational_unit_names._val = 5
    
    #-----< TeletexOrganizationalUnitNames >-----#
    TeletexOrganizationalUnitNames = SEQ_OF(name=u'TeletexOrganizationalUnitNames', mode=MODE_TYPE)
    _TeletexOrganizationalUnitNames__item_ = STR_TELE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'TeletexOrganizationalUnitName')))
    TeletexOrganizationalUnitNames._cont = _TeletexOrganizationalUnitNames__item_
    TeletexOrganizationalUnitNames._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4)], ev=None, er=[])
    
    #-----< TeletexOrganizationalUnitName >-----#
    TeletexOrganizationalUnitName = STR_TELE(name=u'TeletexOrganizationalUnitName', mode=MODE_TYPE)
    TeletexOrganizationalUnitName._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    
    #-----< pds-name >-----#
    pds_name = INT(name=u'pds-name', mode=MODE_VALUE)
    pds_name._val = 7
    
    #-----< PDSName >-----#
    PDSName = STR_PRINT(name=u'PDSName', mode=MODE_TYPE)
    PDSName._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    
    #-----< physical-delivery-country-name >-----#
    physical_delivery_country_name = INT(name=u'physical-delivery-country-name', mode=MODE_VALUE)
    physical_delivery_country_name._val = 8
    
    #-----< PhysicalDeliveryCountryName >-----#
    PhysicalDeliveryCountryName = CHOICE(name=u'PhysicalDeliveryCountryName', mode=MODE_TYPE)
    _PhysicalDeliveryCountryName_x121_dcc_code = STR_NUM(name=u'x121-dcc-code', mode=MODE_TYPE)
    _PhysicalDeliveryCountryName_x121_dcc_code._const_sz = ASN1Set(rv=[3], rr=[], ev=None, er=[])
    _PhysicalDeliveryCountryName_iso_3166_alpha2_code = STR_PRINT(name=u'iso-3166-alpha2-code', mode=MODE_TYPE)
    _PhysicalDeliveryCountryName_iso_3166_alpha2_code._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    PhysicalDeliveryCountryName._cont = ASN1Dict([
        (u'x121-dcc-code', _PhysicalDeliveryCountryName_x121_dcc_code),
        (u'iso-3166-alpha2-code', _PhysicalDeliveryCountryName_iso_3166_alpha2_code),
        ])
    PhysicalDeliveryCountryName._ext = None
    
    #-----< postal-code >-----#
    postal_code = INT(name=u'postal-code', mode=MODE_VALUE)
    postal_code._val = 9
    
    #-----< PostalCode >-----#
    PostalCode = CHOICE(name=u'PostalCode', mode=MODE_TYPE)
    _PostalCode_numeric_code = STR_NUM(name=u'numeric-code', mode=MODE_TYPE)
    _PostalCode_numeric_code._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    _PostalCode_printable_code = STR_PRINT(name=u'printable-code', mode=MODE_TYPE)
    _PostalCode_printable_code._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    PostalCode._cont = ASN1Dict([
        (u'numeric-code', _PostalCode_numeric_code),
        (u'printable-code', _PostalCode_printable_code),
        ])
    PostalCode._ext = None
    
    #-----< physical-delivery-office-name >-----#
    physical_delivery_office_name = INT(name=u'physical-delivery-office-name', mode=MODE_VALUE)
    physical_delivery_office_name._val = 10
    
    #-----< PhysicalDeliveryOfficeName >-----#
    PhysicalDeliveryOfficeName = SET(name=u'PhysicalDeliveryOfficeName', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'PDSParameter')))
    
    #-----< physical-delivery-office-number >-----#
    physical_delivery_office_number = INT(name=u'physical-delivery-office-number', mode=MODE_VALUE)
    physical_delivery_office_number._val = 11
    
    #-----< PhysicalDeliveryOfficeNumber >-----#
    PhysicalDeliveryOfficeNumber = SET(name=u'PhysicalDeliveryOfficeNumber', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'PDSParameter')))
    
    #-----< extension-OR-address-components >-----#
    extension_OR_address_components = INT(name=u'extension-OR-address-components', mode=MODE_VALUE)
    extension_OR_address_components._val = 12
    
    #-----< ExtensionORAddressComponents >-----#
    ExtensionORAddressComponents = SET(name=u'ExtensionORAddressComponents', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'PDSParameter')))
    
    #-----< physical-delivery-personal-name >-----#
    physical_delivery_personal_name = INT(name=u'physical-delivery-personal-name', mode=MODE_VALUE)
    physical_delivery_personal_name._val = 13
    
    #-----< PhysicalDeliveryPersonalName >-----#
    PhysicalDeliveryPersonalName = SET(name=u'PhysicalDeliveryPersonalName', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'PDSParameter')))
    
    #-----< physical-delivery-organization-name >-----#
    physical_delivery_organization_name = INT(name=u'physical-delivery-organization-name', mode=MODE_VALUE)
    physical_delivery_organization_name._val = 14
    
    #-----< PhysicalDeliveryOrganizationName >-----#
    PhysicalDeliveryOrganizationName = SET(name=u'PhysicalDeliveryOrganizationName', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'PDSParameter')))
    
    #-----< extension-physical-delivery-address-components >-----#
    extension_physical_delivery_address_components = INT(name=u'extension-physical-delivery-address-components', mode=MODE_VALUE)
    extension_physical_delivery_address_components._val = 15
    
    #-----< ExtensionPhysicalDeliveryAddressComponents >-----#
    ExtensionPhysicalDeliveryAddressComponents = SET(name=u'ExtensionPhysicalDeliveryAddressComponents', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'PDSParameter')))
    
    #-----< unformatted-postal-address >-----#
    unformatted_postal_address = INT(name=u'unformatted-postal-address', mode=MODE_VALUE)
    unformatted_postal_address._val = 16
    
    #-----< UnformattedPostalAddress >-----#
    UnformattedPostalAddress = SET(name=u'UnformattedPostalAddress', mode=MODE_TYPE)
    _UnformattedPostalAddress_printable_address = SEQ_OF(name=u'printable-address', mode=MODE_TYPE, opt=True)
    __UnformattedPostalAddress_printable_address__item_ = STR_PRINT(name='_item_', mode=MODE_TYPE)
    __UnformattedPostalAddress_printable_address__item_._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=30)], ev=None, er=[])
    _UnformattedPostalAddress_printable_address._cont = __UnformattedPostalAddress_printable_address__item_
    _UnformattedPostalAddress_printable_address._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=6)], ev=None, er=[])
    _UnformattedPostalAddress_teletex_string = STR_TELE(name=u'teletex-string', mode=MODE_TYPE, opt=True)
    _UnformattedPostalAddress_teletex_string._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=180)], ev=None, er=[])
    UnformattedPostalAddress._cont = ASN1Dict([
        (u'printable-address', _UnformattedPostalAddress_printable_address),
        (u'teletex-string', _UnformattedPostalAddress_teletex_string),
        ])
    UnformattedPostalAddress._ext = None
    
    #-----< street-address >-----#
    street_address = INT(name=u'street-address', mode=MODE_VALUE)
    street_address._val = 17
    
    #-----< StreetAddress >-----#
    StreetAddress = SET(name=u'StreetAddress', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'PDSParameter')))
    
    #-----< post-office-box-address >-----#
    post_office_box_address = INT(name=u'post-office-box-address', mode=MODE_VALUE)
    post_office_box_address._val = 18
    
    #-----< PostOfficeBoxAddress >-----#
    PostOfficeBoxAddress = SET(name=u'PostOfficeBoxAddress', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'PDSParameter')))
    
    #-----< poste-restante-address >-----#
    poste_restante_address = INT(name=u'poste-restante-address', mode=MODE_VALUE)
    poste_restante_address._val = 19
    
    #-----< PosteRestanteAddress >-----#
    PosteRestanteAddress = SET(name=u'PosteRestanteAddress', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'PDSParameter')))
    
    #-----< unique-postal-name >-----#
    unique_postal_name = INT(name=u'unique-postal-name', mode=MODE_VALUE)
    unique_postal_name._val = 20
    
    #-----< UniquePostalName >-----#
    UniquePostalName = SET(name=u'UniquePostalName', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'PDSParameter')))
    
    #-----< local-postal-attributes >-----#
    local_postal_attributes = INT(name=u'local-postal-attributes', mode=MODE_VALUE)
    local_postal_attributes._val = 21
    
    #-----< LocalPostalAttributes >-----#
    LocalPostalAttributes = SET(name=u'LocalPostalAttributes', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'PDSParameter')))
    
    #-----< PDSParameter >-----#
    PDSParameter = SET(name=u'PDSParameter', mode=MODE_TYPE)
    _PDSParameter_printable_string = STR_PRINT(name=u'printable-string', mode=MODE_TYPE, opt=True)
    _PDSParameter_printable_string._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=30)], ev=None, er=[])
    _PDSParameter_teletex_string = STR_TELE(name=u'teletex-string', mode=MODE_TYPE, opt=True)
    _PDSParameter_teletex_string._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=30)], ev=None, er=[])
    PDSParameter._cont = ASN1Dict([
        (u'printable-string', _PDSParameter_printable_string),
        (u'teletex-string', _PDSParameter_teletex_string),
        ])
    PDSParameter._ext = None
    
    #-----< extended-network-address >-----#
    extended_network_address = INT(name=u'extended-network-address', mode=MODE_VALUE)
    extended_network_address._val = 22
    
    #-----< ExtendedNetworkAddress >-----#
    ExtendedNetworkAddress = CHOICE(name=u'ExtendedNetworkAddress', mode=MODE_TYPE)
    _ExtendedNetworkAddress_e163_4_address = SEQ(name=u'e163-4-address', mode=MODE_TYPE)
    __ExtendedNetworkAddress_e163_4_address_number = STR_NUM(name=u'number', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __ExtendedNetworkAddress_e163_4_address_number._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=15)], ev=None, er=[])
    __ExtendedNetworkAddress_e163_4_address_sub_address = STR_NUM(name=u'sub-address', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __ExtendedNetworkAddress_e163_4_address_sub_address._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=40)], ev=None, er=[])
    _ExtendedNetworkAddress_e163_4_address._cont = ASN1Dict([
        (u'number', __ExtendedNetworkAddress_e163_4_address_number),
        (u'sub-address', __ExtendedNetworkAddress_e163_4_address_sub_address),
        ])
    _ExtendedNetworkAddress_e163_4_address._ext = None
    _ExtendedNetworkAddress_psap_address = SEQ(name=u'psap-address', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Explicit88', 'PresentationAddress')))
    ExtendedNetworkAddress._cont = ASN1Dict([
        (u'e163-4-address', _ExtendedNetworkAddress_e163_4_address),
        (u'psap-address', _ExtendedNetworkAddress_psap_address),
        ])
    ExtendedNetworkAddress._ext = None
    
    #-----< PresentationAddress >-----#
    PresentationAddress = SEQ(name=u'PresentationAddress', mode=MODE_TYPE)
    _PresentationAddress_pSelector = OCT_STR(name=u'pSelector', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _PresentationAddress_sSelector = OCT_STR(name=u'sSelector', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _PresentationAddress_tSelector = OCT_STR(name=u'tSelector', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _PresentationAddress_nAddresses = SET_OF(name=u'nAddresses', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __PresentationAddress_nAddresses__item_ = OCT_STR(name='_item_', mode=MODE_TYPE)
    _PresentationAddress_nAddresses._cont = __PresentationAddress_nAddresses__item_
    _PresentationAddress_nAddresses._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    PresentationAddress._cont = ASN1Dict([
        (u'pSelector', _PresentationAddress_pSelector),
        (u'sSelector', _PresentationAddress_sSelector),
        (u'tSelector', _PresentationAddress_tSelector),
        (u'nAddresses', _PresentationAddress_nAddresses),
        ])
    PresentationAddress._ext = None
    
    #-----< terminal-type >-----#
    terminal_type = INT(name=u'terminal-type', mode=MODE_VALUE)
    terminal_type._val = 23
    
    #-----< TerminalType >-----#
    TerminalType = INT(name=u'TerminalType', mode=MODE_TYPE)
    TerminalType._cont = ASN1Dict([(u'telex', 3), (u'teletex', 4), (u'g3-facsimile', 5), (u'g4-facsimile', 6), (u'ia5-terminal', 7), (u'videotex', 8)])
    TerminalType._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=256)], ev=None, er=[])
    
    #-----< teletex-domain-defined-attributes >-----#
    teletex_domain_defined_attributes = INT(name=u'teletex-domain-defined-attributes', mode=MODE_VALUE)
    teletex_domain_defined_attributes._val = 6
    
    #-----< TeletexDomainDefinedAttributes >-----#
    TeletexDomainDefinedAttributes = SEQ_OF(name=u'TeletexDomainDefinedAttributes', mode=MODE_TYPE)
    _TeletexDomainDefinedAttributes__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'TeletexDomainDefinedAttribute')))
    TeletexDomainDefinedAttributes._cont = _TeletexDomainDefinedAttributes__item_
    TeletexDomainDefinedAttributes._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4)], ev=None, er=[])
    
    #-----< TeletexDomainDefinedAttribute >-----#
    TeletexDomainDefinedAttribute = SEQ(name=u'TeletexDomainDefinedAttribute', mode=MODE_TYPE)
    _TeletexDomainDefinedAttribute_type = STR_TELE(name=u'type', mode=MODE_TYPE)
    _TeletexDomainDefinedAttribute_type._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    _TeletexDomainDefinedAttribute_value = STR_TELE(name=u'value', mode=MODE_TYPE)
    _TeletexDomainDefinedAttribute_value._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    TeletexDomainDefinedAttribute._cont = ASN1Dict([
        (u'type', _TeletexDomainDefinedAttribute_type),
        (u'value', _TeletexDomainDefinedAttribute_value),
        ])
    TeletexDomainDefinedAttribute._ext = None
    
    #-----< ub-name >-----#
    ub_name = INT(name=u'ub-name', mode=MODE_VALUE)
    ub_name._val = 32768
    
    #-----< ub-common-name >-----#
    ub_common_name = INT(name=u'ub-common-name', mode=MODE_VALUE)
    ub_common_name._val = 64
    
    #-----< ub-locality-name >-----#
    ub_locality_name = INT(name=u'ub-locality-name', mode=MODE_VALUE)
    ub_locality_name._val = 128
    
    #-----< ub-state-name >-----#
    ub_state_name = INT(name=u'ub-state-name', mode=MODE_VALUE)
    ub_state_name._val = 128
    
    #-----< ub-organization-name >-----#
    ub_organization_name = INT(name=u'ub-organization-name', mode=MODE_VALUE)
    ub_organization_name._val = 64
    
    #-----< ub-organizational-unit-name >-----#
    ub_organizational_unit_name = INT(name=u'ub-organizational-unit-name', mode=MODE_VALUE)
    ub_organizational_unit_name._val = 64
    
    #-----< ub-title >-----#
    ub_title = INT(name=u'ub-title', mode=MODE_VALUE)
    ub_title._val = 64
    
    #-----< ub-serial-number >-----#
    ub_serial_number = INT(name=u'ub-serial-number', mode=MODE_VALUE)
    ub_serial_number._val = 64
    
    #-----< ub-match >-----#
    ub_match = INT(name=u'ub-match', mode=MODE_VALUE)
    ub_match._val = 128
    
    #-----< ub-emailaddress-length >-----#
    ub_emailaddress_length = INT(name=u'ub-emailaddress-length', mode=MODE_VALUE)
    ub_emailaddress_length._val = 255
    
    #-----< ub-common-name-length >-----#
    ub_common_name_length = INT(name=u'ub-common-name-length', mode=MODE_VALUE)
    ub_common_name_length._val = 64
    
    #-----< ub-country-name-alpha-length >-----#
    ub_country_name_alpha_length = INT(name=u'ub-country-name-alpha-length', mode=MODE_VALUE)
    ub_country_name_alpha_length._val = 2
    
    #-----< ub-country-name-numeric-length >-----#
    ub_country_name_numeric_length = INT(name=u'ub-country-name-numeric-length', mode=MODE_VALUE)
    ub_country_name_numeric_length._val = 3
    
    #-----< ub-domain-defined-attributes >-----#
    ub_domain_defined_attributes = INT(name=u'ub-domain-defined-attributes', mode=MODE_VALUE)
    ub_domain_defined_attributes._val = 4
    
    #-----< ub-domain-defined-attribute-type-length >-----#
    ub_domain_defined_attribute_type_length = INT(name=u'ub-domain-defined-attribute-type-length', mode=MODE_VALUE)
    ub_domain_defined_attribute_type_length._val = 8
    
    #-----< ub-domain-defined-attribute-value-length >-----#
    ub_domain_defined_attribute_value_length = INT(name=u'ub-domain-defined-attribute-value-length', mode=MODE_VALUE)
    ub_domain_defined_attribute_value_length._val = 128
    
    #-----< ub-domain-name-length >-----#
    ub_domain_name_length = INT(name=u'ub-domain-name-length', mode=MODE_VALUE)
    ub_domain_name_length._val = 16
    
    #-----< ub-extension-attributes >-----#
    ub_extension_attributes = INT(name=u'ub-extension-attributes', mode=MODE_VALUE)
    ub_extension_attributes._val = 256
    
    #-----< ub-e163-4-number-length >-----#
    ub_e163_4_number_length = INT(name=u'ub-e163-4-number-length', mode=MODE_VALUE)
    ub_e163_4_number_length._val = 15
    
    #-----< ub-e163-4-sub-address-length >-----#
    ub_e163_4_sub_address_length = INT(name=u'ub-e163-4-sub-address-length', mode=MODE_VALUE)
    ub_e163_4_sub_address_length._val = 40
    
    #-----< ub-generation-qualifier-length >-----#
    ub_generation_qualifier_length = INT(name=u'ub-generation-qualifier-length', mode=MODE_VALUE)
    ub_generation_qualifier_length._val = 3
    
    #-----< ub-given-name-length >-----#
    ub_given_name_length = INT(name=u'ub-given-name-length', mode=MODE_VALUE)
    ub_given_name_length._val = 16
    
    #-----< ub-initials-length >-----#
    ub_initials_length = INT(name=u'ub-initials-length', mode=MODE_VALUE)
    ub_initials_length._val = 5
    
    #-----< ub-integer-options >-----#
    ub_integer_options = INT(name=u'ub-integer-options', mode=MODE_VALUE)
    ub_integer_options._val = 256
    
    #-----< ub-numeric-user-id-length >-----#
    ub_numeric_user_id_length = INT(name=u'ub-numeric-user-id-length', mode=MODE_VALUE)
    ub_numeric_user_id_length._val = 32
    
    #-----< ub-organization-name-length >-----#
    ub_organization_name_length = INT(name=u'ub-organization-name-length', mode=MODE_VALUE)
    ub_organization_name_length._val = 64
    
    #-----< ub-organizational-unit-name-length >-----#
    ub_organizational_unit_name_length = INT(name=u'ub-organizational-unit-name-length', mode=MODE_VALUE)
    ub_organizational_unit_name_length._val = 32
    
    #-----< ub-organizational-units >-----#
    ub_organizational_units = INT(name=u'ub-organizational-units', mode=MODE_VALUE)
    ub_organizational_units._val = 4
    
    #-----< ub-pds-name-length >-----#
    ub_pds_name_length = INT(name=u'ub-pds-name-length', mode=MODE_VALUE)
    ub_pds_name_length._val = 16
    
    #-----< ub-pds-parameter-length >-----#
    ub_pds_parameter_length = INT(name=u'ub-pds-parameter-length', mode=MODE_VALUE)
    ub_pds_parameter_length._val = 30
    
    #-----< ub-pds-physical-address-lines >-----#
    ub_pds_physical_address_lines = INT(name=u'ub-pds-physical-address-lines', mode=MODE_VALUE)
    ub_pds_physical_address_lines._val = 6
    
    #-----< ub-postal-code-length >-----#
    ub_postal_code_length = INT(name=u'ub-postal-code-length', mode=MODE_VALUE)
    ub_postal_code_length._val = 16
    
    #-----< ub-pseudonym >-----#
    ub_pseudonym = INT(name=u'ub-pseudonym', mode=MODE_VALUE)
    ub_pseudonym._val = 128
    
    #-----< ub-surname-length >-----#
    ub_surname_length = INT(name=u'ub-surname-length', mode=MODE_VALUE)
    ub_surname_length._val = 40
    
    #-----< ub-terminal-id-length >-----#
    ub_terminal_id_length = INT(name=u'ub-terminal-id-length', mode=MODE_VALUE)
    ub_terminal_id_length._val = 24
    
    #-----< ub-unformatted-address-length >-----#
    ub_unformatted_address_length = INT(name=u'ub-unformatted-address-length', mode=MODE_VALUE)
    ub_unformatted_address_length._val = 180
    
    #-----< ub-x121-address-length >-----#
    ub_x121_address_length = INT(name=u'ub-x121-address-length', mode=MODE_VALUE)
    ub_x121_address_length._val = 16
    
    _all_ = [
        id_pkix,
        id_pe,
        id_qt,
        id_kp,
        id_ad,
        id_qt_cps,
        id_qt_unotice,
        id_ad_ocsp,
        id_ad_caIssuers,
        id_ad_timeStamping,
        id_ad_caRepository,
        _Attribute_type,
        __Attribute_values__item_,
        _Attribute_values,
        Attribute,
        AttributeType,
        AttributeValue,
        _AttributeTypeAndValue_type,
        _AttributeTypeAndValue_value,
        AttributeTypeAndValue,
        id_at,
        id_at_name,
        id_at_surname,
        id_at_givenName,
        id_at_initials,
        id_at_generationQualifier,
        _X520name_teletexString,
        _X520name_printableString,
        _X520name_universalString,
        _X520name_utf8String,
        _X520name_bmpString,
        X520name,
        id_at_commonName,
        _X520CommonName_teletexString,
        _X520CommonName_printableString,
        _X520CommonName_universalString,
        _X520CommonName_utf8String,
        _X520CommonName_bmpString,
        X520CommonName,
        id_at_localityName,
        _X520LocalityName_teletexString,
        _X520LocalityName_printableString,
        _X520LocalityName_universalString,
        _X520LocalityName_utf8String,
        _X520LocalityName_bmpString,
        X520LocalityName,
        id_at_stateOrProvinceName,
        _X520StateOrProvinceName_teletexString,
        _X520StateOrProvinceName_printableString,
        _X520StateOrProvinceName_universalString,
        _X520StateOrProvinceName_utf8String,
        _X520StateOrProvinceName_bmpString,
        X520StateOrProvinceName,
        id_at_organizationName,
        _X520OrganizationName_teletexString,
        _X520OrganizationName_printableString,
        _X520OrganizationName_universalString,
        _X520OrganizationName_utf8String,
        _X520OrganizationName_bmpString,
        X520OrganizationName,
        id_at_organizationalUnitName,
        _X520OrganizationalUnitName_teletexString,
        _X520OrganizationalUnitName_printableString,
        _X520OrganizationalUnitName_universalString,
        _X520OrganizationalUnitName_utf8String,
        _X520OrganizationalUnitName_bmpString,
        X520OrganizationalUnitName,
        id_at_title,
        _X520Title_teletexString,
        _X520Title_printableString,
        _X520Title_universalString,
        _X520Title_utf8String,
        _X520Title_bmpString,
        X520Title,
        id_at_dnQualifier,
        X520dnQualifier,
        id_at_countryName,
        X520countryName,
        id_at_serialNumber,
        X520SerialNumber,
        id_at_pseudonym,
        _X520Pseudonym_teletexString,
        _X520Pseudonym_printableString,
        _X520Pseudonym_universalString,
        _X520Pseudonym_utf8String,
        _X520Pseudonym_bmpString,
        X520Pseudonym,
        id_domainComponent,
        DomainComponent,
        pkcs_9,
        id_emailAddress,
        EmailAddress,
        _Name_rdnSequence,
        Name,
        _RDNSequence__item_,
        RDNSequence,
        DistinguishedName,
        _RelativeDistinguishedName__item_,
        RelativeDistinguishedName,
        _DirectoryString_teletexString,
        _DirectoryString_printableString,
        _DirectoryString_universalString,
        _DirectoryString_utf8String,
        _DirectoryString_bmpString,
        DirectoryString,
        _Certificate_tbsCertificate,
        _Certificate_signatureAlgorithm,
        _Certificate_signature,
        Certificate,
        _TBSCertificate_version,
        _TBSCertificate_serialNumber,
        _TBSCertificate_signature,
        _TBSCertificate_issuer,
        _TBSCertificate_validity,
        _TBSCertificate_subject,
        _TBSCertificate_subjectPublicKeyInfo,
        _TBSCertificate_issuerUniqueID,
        _TBSCertificate_subjectUniqueID,
        _TBSCertificate_extensions,
        TBSCertificate,
        Version,
        CertificateSerialNumber,
        _Validity_notBefore,
        _Validity_notAfter,
        Validity,
        _Time_utcTime,
        _Time_generalTime,
        Time,
        UniqueIdentifier,
        _SubjectPublicKeyInfo_algorithm,
        _SubjectPublicKeyInfo_subjectPublicKey,
        SubjectPublicKeyInfo,
        _Extensions__item_,
        Extensions,
        _Extension_extnID,
        _Extension_critical,
        _Extension_extnValue,
        Extension,
        _CertificateList_tbsCertList,
        _CertificateList_signatureAlgorithm,
        _CertificateList_signature,
        CertificateList,
        _TBSCertList_version,
        _TBSCertList_signature,
        _TBSCertList_issuer,
        _TBSCertList_thisUpdate,
        _TBSCertList_nextUpdate,
        ___TBSCertList_revokedCertificates__item__userCertificate,
        ___TBSCertList_revokedCertificates__item__revocationDate,
        ___TBSCertList_revokedCertificates__item__crlEntryExtensions,
        __TBSCertList_revokedCertificates__item_,
        _TBSCertList_revokedCertificates,
        _TBSCertList_crlExtensions,
        TBSCertList,
        _AlgorithmIdentifier_algorithm,
        _AlgorithmIdentifier_parameters,
        AlgorithmIdentifier,
        _ORAddress_built_in_standard_attributes,
        _ORAddress_built_in_domain_defined_attributes,
        _ORAddress_extension_attributes,
        ORAddress,
        _BuiltInStandardAttributes_country_name,
        _BuiltInStandardAttributes_administration_domain_name,
        _BuiltInStandardAttributes_network_address,
        _BuiltInStandardAttributes_terminal_identifier,
        _BuiltInStandardAttributes_private_domain_name,
        _BuiltInStandardAttributes_organization_name,
        _BuiltInStandardAttributes_numeric_user_identifier,
        _BuiltInStandardAttributes_personal_name,
        _BuiltInStandardAttributes_organizational_unit_names,
        BuiltInStandardAttributes,
        _CountryName_x121_dcc_code,
        _CountryName_iso_3166_alpha2_code,
        CountryName,
        _AdministrationDomainName_numeric,
        _AdministrationDomainName_printable,
        AdministrationDomainName,
        NetworkAddress,
        X121Address,
        TerminalIdentifier,
        _PrivateDomainName_numeric,
        _PrivateDomainName_printable,
        PrivateDomainName,
        OrganizationName,
        NumericUserIdentifier,
        _PersonalName_surname,
        _PersonalName_given_name,
        _PersonalName_initials,
        _PersonalName_generation_qualifier,
        PersonalName,
        _OrganizationalUnitNames__item_,
        OrganizationalUnitNames,
        OrganizationalUnitName,
        _BuiltInDomainDefinedAttributes__item_,
        BuiltInDomainDefinedAttributes,
        _BuiltInDomainDefinedAttribute_type,
        _BuiltInDomainDefinedAttribute_value,
        BuiltInDomainDefinedAttribute,
        _ExtensionAttributes__item_,
        ExtensionAttributes,
        _ExtensionAttribute_extension_attribute_type,
        _ExtensionAttribute_extension_attribute_value,
        ExtensionAttribute,
        common_name,
        CommonName,
        teletex_common_name,
        TeletexCommonName,
        teletex_organization_name,
        TeletexOrganizationName,
        teletex_personal_name,
        _TeletexPersonalName_surname,
        _TeletexPersonalName_given_name,
        _TeletexPersonalName_initials,
        _TeletexPersonalName_generation_qualifier,
        TeletexPersonalName,
        teletex_organizational_unit_names,
        _TeletexOrganizationalUnitNames__item_,
        TeletexOrganizationalUnitNames,
        TeletexOrganizationalUnitName,
        pds_name,
        PDSName,
        physical_delivery_country_name,
        _PhysicalDeliveryCountryName_x121_dcc_code,
        _PhysicalDeliveryCountryName_iso_3166_alpha2_code,
        PhysicalDeliveryCountryName,
        postal_code,
        _PostalCode_numeric_code,
        _PostalCode_printable_code,
        PostalCode,
        physical_delivery_office_name,
        PhysicalDeliveryOfficeName,
        physical_delivery_office_number,
        PhysicalDeliveryOfficeNumber,
        extension_OR_address_components,
        ExtensionORAddressComponents,
        physical_delivery_personal_name,
        PhysicalDeliveryPersonalName,
        physical_delivery_organization_name,
        PhysicalDeliveryOrganizationName,
        extension_physical_delivery_address_components,
        ExtensionPhysicalDeliveryAddressComponents,
        unformatted_postal_address,
        __UnformattedPostalAddress_printable_address__item_,
        _UnformattedPostalAddress_printable_address,
        _UnformattedPostalAddress_teletex_string,
        UnformattedPostalAddress,
        street_address,
        StreetAddress,
        post_office_box_address,
        PostOfficeBoxAddress,
        poste_restante_address,
        PosteRestanteAddress,
        unique_postal_name,
        UniquePostalName,
        local_postal_attributes,
        LocalPostalAttributes,
        _PDSParameter_printable_string,
        _PDSParameter_teletex_string,
        PDSParameter,
        extended_network_address,
        __ExtendedNetworkAddress_e163_4_address_number,
        __ExtendedNetworkAddress_e163_4_address_sub_address,
        _ExtendedNetworkAddress_e163_4_address,
        _ExtendedNetworkAddress_psap_address,
        ExtendedNetworkAddress,
        _PresentationAddress_pSelector,
        _PresentationAddress_sSelector,
        _PresentationAddress_tSelector,
        __PresentationAddress_nAddresses__item_,
        _PresentationAddress_nAddresses,
        PresentationAddress,
        terminal_type,
        TerminalType,
        teletex_domain_defined_attributes,
        _TeletexDomainDefinedAttributes__item_,
        TeletexDomainDefinedAttributes,
        _TeletexDomainDefinedAttribute_type,
        _TeletexDomainDefinedAttribute_value,
        TeletexDomainDefinedAttribute,
        ub_name,
        ub_common_name,
        ub_locality_name,
        ub_state_name,
        ub_organization_name,
        ub_organizational_unit_name,
        ub_title,
        ub_serial_number,
        ub_match,
        ub_emailaddress_length,
        ub_common_name_length,
        ub_country_name_alpha_length,
        ub_country_name_numeric_length,
        ub_domain_defined_attributes,
        ub_domain_defined_attribute_type_length,
        ub_domain_defined_attribute_value_length,
        ub_domain_name_length,
        ub_extension_attributes,
        ub_e163_4_number_length,
        ub_e163_4_sub_address_length,
        ub_generation_qualifier_length,
        ub_given_name_length,
        ub_initials_length,
        ub_integer_options,
        ub_numeric_user_id_length,
        ub_organization_name_length,
        ub_organizational_unit_name_length,
        ub_organizational_units,
        ub_pds_name_length,
        ub_pds_parameter_length,
        ub_pds_physical_address_lines,
        ub_postal_code_length,
        ub_pseudonym,
        ub_surname_length,
        ub_terminal_id_length,
        ub_unformatted_address_length,
        ub_x121_address_length,
    ]

class PKIX1Implicit88:

    _name_  = u'PKIX1Implicit88'
    _oid_   = [1, 3, 6, 1, 5, 5, 7, 0, 19]
    
    _obj_ = [
        u'id-ce',
        u'id-ce-authorityKeyIdentifier',
        u'AuthorityKeyIdentifier',
        u'KeyIdentifier',
        u'id-ce-subjectKeyIdentifier',
        u'SubjectKeyIdentifier',
        u'id-ce-keyUsage',
        u'KeyUsage',
        u'id-ce-privateKeyUsagePeriod',
        u'PrivateKeyUsagePeriod',
        u'id-ce-certificatePolicies',
        u'anyPolicy',
        u'CertificatePolicies',
        u'PolicyInformation',
        u'CertPolicyId',
        u'PolicyQualifierInfo',
        u'PolicyQualifierId',
        u'CPSuri',
        u'UserNotice',
        u'NoticeReference',
        u'DisplayText',
        u'id-ce-policyMappings',
        u'PolicyMappings',
        u'id-ce-subjectAltName',
        u'SubjectAltName',
        u'GeneralNames',
        u'GeneralName',
        u'AnotherName',
        u'EDIPartyName',
        u'id-ce-issuerAltName',
        u'IssuerAltName',
        u'id-ce-subjectDirectoryAttributes',
        u'SubjectDirectoryAttributes',
        u'id-ce-basicConstraints',
        u'BasicConstraints',
        u'id-ce-nameConstraints',
        u'NameConstraints',
        u'GeneralSubtrees',
        u'GeneralSubtree',
        u'BaseDistance',
        u'id-ce-policyConstraints',
        u'PolicyConstraints',
        u'SkipCerts',
        u'id-ce-cRLDistributionPoints',
        u'CRLDistributionPoints',
        u'DistributionPoint',
        u'DistributionPointName',
        u'ReasonFlags',
        u'id-ce-extKeyUsage',
        u'ExtKeyUsageSyntax',
        u'KeyPurposeId',
        u'anyExtendedKeyUsage',
        u'id-kp-serverAuth',
        u'id-kp-clientAuth',
        u'id-kp-codeSigning',
        u'id-kp-emailProtection',
        u'id-kp-timeStamping',
        u'id-kp-OCSPSigning',
        u'id-ce-inhibitAnyPolicy',
        u'InhibitAnyPolicy',
        u'id-ce-freshestCRL',
        u'FreshestCRL',
        u'id-pe-authorityInfoAccess',
        u'AuthorityInfoAccessSyntax',
        u'AccessDescription',
        u'id-pe-subjectInfoAccess',
        u'SubjectInfoAccessSyntax',
        u'id-ce-cRLNumber',
        u'CRLNumber',
        u'id-ce-issuingDistributionPoint',
        u'IssuingDistributionPoint',
        u'id-ce-deltaCRLIndicator',
        u'BaseCRLNumber',
        u'id-ce-cRLReasons',
        u'CRLReason',
        u'id-ce-certificateIssuer',
        u'CertificateIssuer',
        u'id-ce-holdInstructionCode',
        u'HoldInstructionCode',
        u'holdInstruction',
        u'id-holdinstruction-none',
        u'id-holdinstruction-callissuer',
        u'id-holdinstruction-reject',
        u'id-ce-invalidityDate',
        u'InvalidityDate',
        ]
    _type_ = [
        u'AuthorityKeyIdentifier',
        u'KeyIdentifier',
        u'SubjectKeyIdentifier',
        u'KeyUsage',
        u'PrivateKeyUsagePeriod',
        u'CertificatePolicies',
        u'PolicyInformation',
        u'CertPolicyId',
        u'PolicyQualifierInfo',
        u'PolicyQualifierId',
        u'CPSuri',
        u'UserNotice',
        u'NoticeReference',
        u'DisplayText',
        u'PolicyMappings',
        u'SubjectAltName',
        u'GeneralNames',
        u'GeneralName',
        u'AnotherName',
        u'EDIPartyName',
        u'IssuerAltName',
        u'SubjectDirectoryAttributes',
        u'BasicConstraints',
        u'NameConstraints',
        u'GeneralSubtrees',
        u'GeneralSubtree',
        u'BaseDistance',
        u'PolicyConstraints',
        u'SkipCerts',
        u'CRLDistributionPoints',
        u'DistributionPoint',
        u'DistributionPointName',
        u'ReasonFlags',
        u'ExtKeyUsageSyntax',
        u'KeyPurposeId',
        u'InhibitAnyPolicy',
        u'FreshestCRL',
        u'AuthorityInfoAccessSyntax',
        u'AccessDescription',
        u'SubjectInfoAccessSyntax',
        u'CRLNumber',
        u'IssuingDistributionPoint',
        u'BaseCRLNumber',
        u'CRLReason',
        u'CertificateIssuer',
        u'HoldInstructionCode',
        u'InvalidityDate',
        ]
    _set_ = [
        ]
    _val_ = [
        u'id-ce',
        u'id-ce-authorityKeyIdentifier',
        u'id-ce-subjectKeyIdentifier',
        u'id-ce-keyUsage',
        u'id-ce-privateKeyUsagePeriod',
        u'id-ce-certificatePolicies',
        u'anyPolicy',
        u'id-ce-policyMappings',
        u'id-ce-subjectAltName',
        u'id-ce-issuerAltName',
        u'id-ce-subjectDirectoryAttributes',
        u'id-ce-basicConstraints',
        u'id-ce-nameConstraints',
        u'id-ce-policyConstraints',
        u'id-ce-cRLDistributionPoints',
        u'id-ce-extKeyUsage',
        u'anyExtendedKeyUsage',
        u'id-kp-serverAuth',
        u'id-kp-clientAuth',
        u'id-kp-codeSigning',
        u'id-kp-emailProtection',
        u'id-kp-timeStamping',
        u'id-kp-OCSPSigning',
        u'id-ce-inhibitAnyPolicy',
        u'id-ce-freshestCRL',
        u'id-pe-authorityInfoAccess',
        u'id-pe-subjectInfoAccess',
        u'id-ce-cRLNumber',
        u'id-ce-issuingDistributionPoint',
        u'id-ce-deltaCRLIndicator',
        u'id-ce-cRLReasons',
        u'id-ce-certificateIssuer',
        u'id-ce-holdInstructionCode',
        u'holdInstruction',
        u'id-holdinstruction-none',
        u'id-holdinstruction-callissuer',
        u'id-holdinstruction-reject',
        u'id-ce-invalidityDate',
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< id-ce >-----#
    id_ce = OID(name=u'id-ce', mode=MODE_VALUE)
    id_ce._val = (2, 5, 29)
    
    #-----< id-ce-authorityKeyIdentifier >-----#
    id_ce_authorityKeyIdentifier = OID(name=u'id-ce-authorityKeyIdentifier', mode=MODE_VALUE)
    id_ce_authorityKeyIdentifier._val = (2, 5, 29, 35)
    
    #-----< AuthorityKeyIdentifier >-----#
    AuthorityKeyIdentifier = SEQ(name=u'AuthorityKeyIdentifier', mode=MODE_TYPE)
    _AuthorityKeyIdentifier_keyIdentifier = OCT_STR(name=u'keyIdentifier', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit88', 'KeyIdentifier')), opt=True)
    _AuthorityKeyIdentifier_authorityCertIssuer = SEQ_OF(name=u'authorityCertIssuer', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit88', 'GeneralNames')), opt=True)
    _AuthorityKeyIdentifier_authorityCertSerialNumber = INT(name=u'authorityCertSerialNumber', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Explicit88', 'CertificateSerialNumber')), opt=True)
    AuthorityKeyIdentifier._cont = ASN1Dict([
        (u'keyIdentifier', _AuthorityKeyIdentifier_keyIdentifier),
        (u'authorityCertIssuer', _AuthorityKeyIdentifier_authorityCertIssuer),
        (u'authorityCertSerialNumber', _AuthorityKeyIdentifier_authorityCertSerialNumber),
        ])
    AuthorityKeyIdentifier._ext = None
    
    #-----< KeyIdentifier >-----#
    KeyIdentifier = OCT_STR(name=u'KeyIdentifier', mode=MODE_TYPE)
    
    #-----< id-ce-subjectKeyIdentifier >-----#
    id_ce_subjectKeyIdentifier = OID(name=u'id-ce-subjectKeyIdentifier', mode=MODE_VALUE)
    id_ce_subjectKeyIdentifier._val = (2, 5, 29, 14)
    
    #-----< SubjectKeyIdentifier >-----#
    SubjectKeyIdentifier = OCT_STR(name=u'SubjectKeyIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit88', 'KeyIdentifier')))
    
    #-----< id-ce-keyUsage >-----#
    id_ce_keyUsage = OID(name=u'id-ce-keyUsage', mode=MODE_VALUE)
    id_ce_keyUsage._val = (2, 5, 29, 15)
    
    #-----< KeyUsage >-----#
    KeyUsage = BIT_STR(name=u'KeyUsage', mode=MODE_TYPE)
    KeyUsage._cont = ASN1Dict([(u'digitalSignature', 0), (u'nonRepudiation', 1), (u'keyEncipherment', 2), (u'dataEncipherment', 3), (u'keyAgreement', 4), (u'keyCertSign', 5), (u'cRLSign', 6), (u'encipherOnly', 7), (u'decipherOnly', 8)])
    
    #-----< id-ce-privateKeyUsagePeriod >-----#
    id_ce_privateKeyUsagePeriod = OID(name=u'id-ce-privateKeyUsagePeriod', mode=MODE_VALUE)
    id_ce_privateKeyUsagePeriod._val = (2, 5, 29, 16)
    
    #-----< PrivateKeyUsagePeriod >-----#
    PrivateKeyUsagePeriod = SEQ(name=u'PrivateKeyUsagePeriod', mode=MODE_TYPE)
    _PrivateKeyUsagePeriod_notBefore = TIME_GEN(name=u'notBefore', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _PrivateKeyUsagePeriod_notAfter = TIME_GEN(name=u'notAfter', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    PrivateKeyUsagePeriod._cont = ASN1Dict([
        (u'notBefore', _PrivateKeyUsagePeriod_notBefore),
        (u'notAfter', _PrivateKeyUsagePeriod_notAfter),
        ])
    PrivateKeyUsagePeriod._ext = None
    
    #-----< id-ce-certificatePolicies >-----#
    id_ce_certificatePolicies = OID(name=u'id-ce-certificatePolicies', mode=MODE_VALUE)
    id_ce_certificatePolicies._val = (2, 5, 29, 32)
    
    #-----< anyPolicy >-----#
    anyPolicy = OID(name=u'anyPolicy', mode=MODE_VALUE)
    anyPolicy._val = (2, 5, 29, 32, 0)
    
    #-----< CertificatePolicies >-----#
    CertificatePolicies = SEQ_OF(name=u'CertificatePolicies', mode=MODE_TYPE)
    _CertificatePolicies__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit88', 'PolicyInformation')))
    CertificatePolicies._cont = _CertificatePolicies__item_
    CertificatePolicies._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< PolicyInformation >-----#
    PolicyInformation = SEQ(name=u'PolicyInformation', mode=MODE_TYPE)
    _PolicyInformation_policyIdentifier = OID(name=u'policyIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit88', 'CertPolicyId')))
    _PolicyInformation_policyQualifiers = SEQ_OF(name=u'policyQualifiers', mode=MODE_TYPE, opt=True)
    __PolicyInformation_policyQualifiers__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit88', 'PolicyQualifierInfo')))
    _PolicyInformation_policyQualifiers._cont = __PolicyInformation_policyQualifiers__item_
    _PolicyInformation_policyQualifiers._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    PolicyInformation._cont = ASN1Dict([
        (u'policyIdentifier', _PolicyInformation_policyIdentifier),
        (u'policyQualifiers', _PolicyInformation_policyQualifiers),
        ])
    PolicyInformation._ext = None
    
    #-----< CertPolicyId >-----#
    CertPolicyId = OID(name=u'CertPolicyId', mode=MODE_TYPE)
    
    #-----< PolicyQualifierInfo >-----#
    PolicyQualifierInfo = SEQ(name=u'PolicyQualifierInfo', mode=MODE_TYPE)
    _PolicyQualifierInfo_policyQualifierId = OID(name=u'policyQualifierId', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit88', 'PolicyQualifierId')))
    _PolicyQualifierInfo_qualifier = ANY(name=u'qualifier', mode=MODE_TYPE, defby=u'policyQualifierId')
    PolicyQualifierInfo._cont = ASN1Dict([
        (u'policyQualifierId', _PolicyQualifierInfo_policyQualifierId),
        (u'qualifier', _PolicyQualifierInfo_qualifier),
        ])
    PolicyQualifierInfo._ext = None
    
    #-----< PolicyQualifierId >-----#
    PolicyQualifierId = OID(name=u'PolicyQualifierId', mode=MODE_TYPE)
    PolicyQualifierId._const_val = ASN1Set(rv=[(1, 3, 6, 1, 5, 5, 7, 2, 1), (1, 3, 6, 1, 5, 5, 7, 2, 2)], rr=[], ev=None, er=[])
    
    #-----< CPSuri >-----#
    CPSuri = STR_IA5(name=u'CPSuri', mode=MODE_TYPE)
    
    #-----< UserNotice >-----#
    UserNotice = SEQ(name=u'UserNotice', mode=MODE_TYPE)
    _UserNotice_noticeRef = SEQ(name=u'noticeRef', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit88', 'NoticeReference')), opt=True)
    _UserNotice_explicitText = CHOICE(name=u'explicitText', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit88', 'DisplayText')), opt=True)
    UserNotice._cont = ASN1Dict([
        (u'noticeRef', _UserNotice_noticeRef),
        (u'explicitText', _UserNotice_explicitText),
        ])
    UserNotice._ext = None
    
    #-----< NoticeReference >-----#
    NoticeReference = SEQ(name=u'NoticeReference', mode=MODE_TYPE)
    _NoticeReference_organization = CHOICE(name=u'organization', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit88', 'DisplayText')))
    _NoticeReference_noticeNumbers = SEQ_OF(name=u'noticeNumbers', mode=MODE_TYPE)
    __NoticeReference_noticeNumbers__item_ = INT(name='_item_', mode=MODE_TYPE)
    _NoticeReference_noticeNumbers._cont = __NoticeReference_noticeNumbers__item_
    NoticeReference._cont = ASN1Dict([
        (u'organization', _NoticeReference_organization),
        (u'noticeNumbers', _NoticeReference_noticeNumbers),
        ])
    NoticeReference._ext = None
    
    #-----< DisplayText >-----#
    DisplayText = CHOICE(name=u'DisplayText', mode=MODE_TYPE)
    _DisplayText_ia5String = STR_IA5(name=u'ia5String', mode=MODE_TYPE)
    _DisplayText_ia5String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=200)], ev=None, er=[])
    _DisplayText_visibleString = STR_VIS(name=u'visibleString', mode=MODE_TYPE)
    _DisplayText_visibleString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=200)], ev=None, er=[])
    _DisplayText_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _DisplayText_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=200)], ev=None, er=[])
    _DisplayText_utf8String = STR_UTF8(name=u'utf8String', mode=MODE_TYPE)
    _DisplayText_utf8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=200)], ev=None, er=[])
    DisplayText._cont = ASN1Dict([
        (u'ia5String', _DisplayText_ia5String),
        (u'visibleString', _DisplayText_visibleString),
        (u'bmpString', _DisplayText_bmpString),
        (u'utf8String', _DisplayText_utf8String),
        ])
    DisplayText._ext = None
    
    #-----< id-ce-policyMappings >-----#
    id_ce_policyMappings = OID(name=u'id-ce-policyMappings', mode=MODE_VALUE)
    id_ce_policyMappings._val = (2, 5, 29, 33)
    
    #-----< PolicyMappings >-----#
    PolicyMappings = SEQ_OF(name=u'PolicyMappings', mode=MODE_TYPE)
    _PolicyMappings__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    __PolicyMappings__item__issuerDomainPolicy = OID(name=u'issuerDomainPolicy', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit88', 'CertPolicyId')))
    __PolicyMappings__item__subjectDomainPolicy = OID(name=u'subjectDomainPolicy', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit88', 'CertPolicyId')))
    _PolicyMappings__item_._cont = ASN1Dict([
        (u'issuerDomainPolicy', __PolicyMappings__item__issuerDomainPolicy),
        (u'subjectDomainPolicy', __PolicyMappings__item__subjectDomainPolicy),
        ])
    _PolicyMappings__item_._ext = None
    PolicyMappings._cont = _PolicyMappings__item_
    PolicyMappings._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< id-ce-subjectAltName >-----#
    id_ce_subjectAltName = OID(name=u'id-ce-subjectAltName', mode=MODE_VALUE)
    id_ce_subjectAltName._val = (2, 5, 29, 17)
    
    #-----< SubjectAltName >-----#
    SubjectAltName = SEQ_OF(name=u'SubjectAltName', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit88', 'GeneralNames')))
    
    #-----< GeneralNames >-----#
    GeneralNames = SEQ_OF(name=u'GeneralNames', mode=MODE_TYPE)
    _GeneralNames__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit88', 'GeneralName')))
    GeneralNames._cont = _GeneralNames__item_
    GeneralNames._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< GeneralName >-----#
    GeneralName = CHOICE(name=u'GeneralName', mode=MODE_TYPE)
    _GeneralName_otherName = SEQ(name=u'otherName', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit88', 'AnotherName')))
    _GeneralName_rfc822Name = STR_IA5(name=u'rfc822Name', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GeneralName_dNSName = STR_IA5(name=u'dNSName', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GeneralName_x400Address = SEQ(name=u'x400Address', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Explicit88', 'ORAddress')))
    _GeneralName_directoryName = CHOICE(name=u'directoryName', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Explicit88', 'Name')))
    _GeneralName_ediPartyName = SEQ(name=u'ediPartyName', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit88', 'EDIPartyName')))
    _GeneralName_uniformResourceIdentifier = STR_IA5(name=u'uniformResourceIdentifier', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GeneralName_iPAddress = OCT_STR(name=u'iPAddress', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GeneralName_registeredID = OID(name=u'registeredID', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    GeneralName._cont = ASN1Dict([
        (u'otherName', _GeneralName_otherName),
        (u'rfc822Name', _GeneralName_rfc822Name),
        (u'dNSName', _GeneralName_dNSName),
        (u'x400Address', _GeneralName_x400Address),
        (u'directoryName', _GeneralName_directoryName),
        (u'ediPartyName', _GeneralName_ediPartyName),
        (u'uniformResourceIdentifier', _GeneralName_uniformResourceIdentifier),
        (u'iPAddress', _GeneralName_iPAddress),
        (u'registeredID', _GeneralName_registeredID),
        ])
    GeneralName._ext = None
    
    #-----< AnotherName >-----#
    AnotherName = SEQ(name=u'AnotherName', mode=MODE_TYPE)
    _AnotherName_type_id = OID(name=u'type-id', mode=MODE_TYPE)
    _AnotherName_value = ANY(name=u'value', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), defby=u'type-id')
    AnotherName._cont = ASN1Dict([
        (u'type-id', _AnotherName_type_id),
        (u'value', _AnotherName_value),
        ])
    AnotherName._ext = None
    
    #-----< EDIPartyName >-----#
    EDIPartyName = SEQ(name=u'EDIPartyName', mode=MODE_TYPE)
    _EDIPartyName_nameAssigner = CHOICE(name=u'nameAssigner', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Explicit88', 'DirectoryString')), opt=True)
    _EDIPartyName_partyName = CHOICE(name=u'partyName', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Explicit88', 'DirectoryString')))
    EDIPartyName._cont = ASN1Dict([
        (u'nameAssigner', _EDIPartyName_nameAssigner),
        (u'partyName', _EDIPartyName_partyName),
        ])
    EDIPartyName._ext = None
    
    #-----< id-ce-issuerAltName >-----#
    id_ce_issuerAltName = OID(name=u'id-ce-issuerAltName', mode=MODE_VALUE)
    id_ce_issuerAltName._val = (2, 5, 29, 18)
    
    #-----< IssuerAltName >-----#
    IssuerAltName = SEQ_OF(name=u'IssuerAltName', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit88', 'GeneralNames')))
    
    #-----< id-ce-subjectDirectoryAttributes >-----#
    id_ce_subjectDirectoryAttributes = OID(name=u'id-ce-subjectDirectoryAttributes', mode=MODE_VALUE)
    id_ce_subjectDirectoryAttributes._val = (2, 5, 29, 9)
    
    #-----< SubjectDirectoryAttributes >-----#
    SubjectDirectoryAttributes = SEQ_OF(name=u'SubjectDirectoryAttributes', mode=MODE_TYPE)
    _SubjectDirectoryAttributes__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'Attribute')))
    SubjectDirectoryAttributes._cont = _SubjectDirectoryAttributes__item_
    SubjectDirectoryAttributes._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< id-ce-basicConstraints >-----#
    id_ce_basicConstraints = OID(name=u'id-ce-basicConstraints', mode=MODE_VALUE)
    id_ce_basicConstraints._val = (2, 5, 29, 19)
    
    #-----< BasicConstraints >-----#
    BasicConstraints = SEQ(name=u'BasicConstraints', mode=MODE_TYPE)
    _BasicConstraints_cA = BOOL(name=u'cA', mode=MODE_TYPE, default=False)
    _BasicConstraints_pathLenConstraint = INT(name=u'pathLenConstraint', mode=MODE_TYPE, opt=True)
    _BasicConstraints_pathLenConstraint._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    BasicConstraints._cont = ASN1Dict([
        (u'cA', _BasicConstraints_cA),
        (u'pathLenConstraint', _BasicConstraints_pathLenConstraint),
        ])
    BasicConstraints._ext = None
    
    #-----< id-ce-nameConstraints >-----#
    id_ce_nameConstraints = OID(name=u'id-ce-nameConstraints', mode=MODE_VALUE)
    id_ce_nameConstraints._val = (2, 5, 29, 30)
    
    #-----< NameConstraints >-----#
    NameConstraints = SEQ(name=u'NameConstraints', mode=MODE_TYPE)
    _NameConstraints_permittedSubtrees = SEQ_OF(name=u'permittedSubtrees', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit88', 'GeneralSubtrees')), opt=True)
    _NameConstraints_excludedSubtrees = SEQ_OF(name=u'excludedSubtrees', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit88', 'GeneralSubtrees')), opt=True)
    NameConstraints._cont = ASN1Dict([
        (u'permittedSubtrees', _NameConstraints_permittedSubtrees),
        (u'excludedSubtrees', _NameConstraints_excludedSubtrees),
        ])
    NameConstraints._ext = None
    
    #-----< GeneralSubtrees >-----#
    GeneralSubtrees = SEQ_OF(name=u'GeneralSubtrees', mode=MODE_TYPE)
    _GeneralSubtrees__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit88', 'GeneralSubtree')))
    GeneralSubtrees._cont = _GeneralSubtrees__item_
    GeneralSubtrees._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< GeneralSubtree >-----#
    GeneralSubtree = SEQ(name=u'GeneralSubtree', mode=MODE_TYPE)
    _GeneralSubtree_base = CHOICE(name=u'base', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit88', 'GeneralName')))
    _GeneralSubtree_minimum = INT(name=u'minimum', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit88', 'BaseDistance')), default=0)
    _GeneralSubtree_maximum = INT(name=u'maximum', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit88', 'BaseDistance')), opt=True)
    GeneralSubtree._cont = ASN1Dict([
        (u'base', _GeneralSubtree_base),
        (u'minimum', _GeneralSubtree_minimum),
        (u'maximum', _GeneralSubtree_maximum),
        ])
    GeneralSubtree._ext = None
    
    #-----< BaseDistance >-----#
    BaseDistance = INT(name=u'BaseDistance', mode=MODE_TYPE)
    BaseDistance._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    
    #-----< id-ce-policyConstraints >-----#
    id_ce_policyConstraints = OID(name=u'id-ce-policyConstraints', mode=MODE_VALUE)
    id_ce_policyConstraints._val = (2, 5, 29, 36)
    
    #-----< PolicyConstraints >-----#
    PolicyConstraints = SEQ(name=u'PolicyConstraints', mode=MODE_TYPE)
    _PolicyConstraints_requireExplicitPolicy = INT(name=u'requireExplicitPolicy', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit88', 'SkipCerts')), opt=True)
    _PolicyConstraints_inhibitPolicyMapping = INT(name=u'inhibitPolicyMapping', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit88', 'SkipCerts')), opt=True)
    PolicyConstraints._cont = ASN1Dict([
        (u'requireExplicitPolicy', _PolicyConstraints_requireExplicitPolicy),
        (u'inhibitPolicyMapping', _PolicyConstraints_inhibitPolicyMapping),
        ])
    PolicyConstraints._ext = None
    
    #-----< SkipCerts >-----#
    SkipCerts = INT(name=u'SkipCerts', mode=MODE_TYPE)
    SkipCerts._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    
    #-----< id-ce-cRLDistributionPoints >-----#
    id_ce_cRLDistributionPoints = OID(name=u'id-ce-cRLDistributionPoints', mode=MODE_VALUE)
    id_ce_cRLDistributionPoints._val = (2, 5, 29, 31)
    
    #-----< CRLDistributionPoints >-----#
    CRLDistributionPoints = SEQ_OF(name=u'CRLDistributionPoints', mode=MODE_TYPE)
    _CRLDistributionPoints__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit88', 'DistributionPoint')))
    CRLDistributionPoints._cont = _CRLDistributionPoints__item_
    CRLDistributionPoints._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< DistributionPoint >-----#
    DistributionPoint = SEQ(name=u'DistributionPoint', mode=MODE_TYPE)
    _DistributionPoint_distributionPoint = CHOICE(name=u'distributionPoint', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit88', 'DistributionPointName')), opt=True)
    _DistributionPoint_reasons = BIT_STR(name=u'reasons', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit88', 'ReasonFlags')), opt=True)
    _DistributionPoint_cRLIssuer = SEQ_OF(name=u'cRLIssuer', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit88', 'GeneralNames')), opt=True)
    DistributionPoint._cont = ASN1Dict([
        (u'distributionPoint', _DistributionPoint_distributionPoint),
        (u'reasons', _DistributionPoint_reasons),
        (u'cRLIssuer', _DistributionPoint_cRLIssuer),
        ])
    DistributionPoint._ext = None
    
    #-----< DistributionPointName >-----#
    DistributionPointName = CHOICE(name=u'DistributionPointName', mode=MODE_TYPE)
    _DistributionPointName_fullName = SEQ_OF(name=u'fullName', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit88', 'GeneralNames')))
    _DistributionPointName_nameRelativeToCRLIssuer = SET_OF(name=u'nameRelativeToCRLIssuer', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Explicit88', 'RelativeDistinguishedName')))
    DistributionPointName._cont = ASN1Dict([
        (u'fullName', _DistributionPointName_fullName),
        (u'nameRelativeToCRLIssuer', _DistributionPointName_nameRelativeToCRLIssuer),
        ])
    DistributionPointName._ext = None
    
    #-----< ReasonFlags >-----#
    ReasonFlags = BIT_STR(name=u'ReasonFlags', mode=MODE_TYPE)
    ReasonFlags._cont = ASN1Dict([(u'unused', 0), (u'keyCompromise', 1), (u'cACompromise', 2), (u'affiliationChanged', 3), (u'superseded', 4), (u'cessationOfOperation', 5), (u'certificateHold', 6), (u'privilegeWithdrawn', 7), (u'aACompromise', 8)])
    
    #-----< id-ce-extKeyUsage >-----#
    id_ce_extKeyUsage = OID(name=u'id-ce-extKeyUsage', mode=MODE_VALUE)
    id_ce_extKeyUsage._val = (2, 5, 29, 37)
    
    #-----< ExtKeyUsageSyntax >-----#
    ExtKeyUsageSyntax = SEQ_OF(name=u'ExtKeyUsageSyntax', mode=MODE_TYPE)
    _ExtKeyUsageSyntax__item_ = OID(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit88', 'KeyPurposeId')))
    ExtKeyUsageSyntax._cont = _ExtKeyUsageSyntax__item_
    ExtKeyUsageSyntax._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< KeyPurposeId >-----#
    KeyPurposeId = OID(name=u'KeyPurposeId', mode=MODE_TYPE)
    
    #-----< anyExtendedKeyUsage >-----#
    anyExtendedKeyUsage = OID(name=u'anyExtendedKeyUsage', mode=MODE_VALUE)
    anyExtendedKeyUsage._val = (2, 5, 29, 37, 0)
    
    #-----< id-kp-serverAuth >-----#
    id_kp_serverAuth = OID(name=u'id-kp-serverAuth', mode=MODE_VALUE)
    id_kp_serverAuth._val = (1, 3, 6, 1, 5, 5, 7, 3, 1)
    
    #-----< id-kp-clientAuth >-----#
    id_kp_clientAuth = OID(name=u'id-kp-clientAuth', mode=MODE_VALUE)
    id_kp_clientAuth._val = (1, 3, 6, 1, 5, 5, 7, 3, 2)
    
    #-----< id-kp-codeSigning >-----#
    id_kp_codeSigning = OID(name=u'id-kp-codeSigning', mode=MODE_VALUE)
    id_kp_codeSigning._val = (1, 3, 6, 1, 5, 5, 7, 3, 3)
    
    #-----< id-kp-emailProtection >-----#
    id_kp_emailProtection = OID(name=u'id-kp-emailProtection', mode=MODE_VALUE)
    id_kp_emailProtection._val = (1, 3, 6, 1, 5, 5, 7, 3, 4)
    
    #-----< id-kp-timeStamping >-----#
    id_kp_timeStamping = OID(name=u'id-kp-timeStamping', mode=MODE_VALUE)
    id_kp_timeStamping._val = (1, 3, 6, 1, 5, 5, 7, 3, 8)
    
    #-----< id-kp-OCSPSigning >-----#
    id_kp_OCSPSigning = OID(name=u'id-kp-OCSPSigning', mode=MODE_VALUE)
    id_kp_OCSPSigning._val = (1, 3, 6, 1, 5, 5, 7, 3, 9)
    
    #-----< id-ce-inhibitAnyPolicy >-----#
    id_ce_inhibitAnyPolicy = OID(name=u'id-ce-inhibitAnyPolicy', mode=MODE_VALUE)
    id_ce_inhibitAnyPolicy._val = (2, 5, 29, 54)
    
    #-----< InhibitAnyPolicy >-----#
    InhibitAnyPolicy = INT(name=u'InhibitAnyPolicy', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit88', 'SkipCerts')))
    
    #-----< id-ce-freshestCRL >-----#
    id_ce_freshestCRL = OID(name=u'id-ce-freshestCRL', mode=MODE_VALUE)
    id_ce_freshestCRL._val = (2, 5, 29, 46)
    
    #-----< FreshestCRL >-----#
    FreshestCRL = SEQ_OF(name=u'FreshestCRL', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit88', 'CRLDistributionPoints')))
    
    #-----< id-pe-authorityInfoAccess >-----#
    id_pe_authorityInfoAccess = OID(name=u'id-pe-authorityInfoAccess', mode=MODE_VALUE)
    id_pe_authorityInfoAccess._val = (1, 3, 6, 1, 5, 5, 7, 1, 1)
    
    #-----< AuthorityInfoAccessSyntax >-----#
    AuthorityInfoAccessSyntax = SEQ_OF(name=u'AuthorityInfoAccessSyntax', mode=MODE_TYPE)
    _AuthorityInfoAccessSyntax__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit88', 'AccessDescription')))
    AuthorityInfoAccessSyntax._cont = _AuthorityInfoAccessSyntax__item_
    AuthorityInfoAccessSyntax._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< AccessDescription >-----#
    AccessDescription = SEQ(name=u'AccessDescription', mode=MODE_TYPE)
    _AccessDescription_accessMethod = OID(name=u'accessMethod', mode=MODE_TYPE)
    _AccessDescription_accessLocation = CHOICE(name=u'accessLocation', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit88', 'GeneralName')))
    AccessDescription._cont = ASN1Dict([
        (u'accessMethod', _AccessDescription_accessMethod),
        (u'accessLocation', _AccessDescription_accessLocation),
        ])
    AccessDescription._ext = None
    
    #-----< id-pe-subjectInfoAccess >-----#
    id_pe_subjectInfoAccess = OID(name=u'id-pe-subjectInfoAccess', mode=MODE_VALUE)
    id_pe_subjectInfoAccess._val = (1, 3, 6, 1, 5, 5, 7, 1, 11)
    
    #-----< SubjectInfoAccessSyntax >-----#
    SubjectInfoAccessSyntax = SEQ_OF(name=u'SubjectInfoAccessSyntax', mode=MODE_TYPE)
    _SubjectInfoAccessSyntax__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit88', 'AccessDescription')))
    SubjectInfoAccessSyntax._cont = _SubjectInfoAccessSyntax__item_
    SubjectInfoAccessSyntax._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< id-ce-cRLNumber >-----#
    id_ce_cRLNumber = OID(name=u'id-ce-cRLNumber', mode=MODE_VALUE)
    id_ce_cRLNumber._val = (2, 5, 29, 20)
    
    #-----< CRLNumber >-----#
    CRLNumber = INT(name=u'CRLNumber', mode=MODE_TYPE)
    CRLNumber._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    
    #-----< id-ce-issuingDistributionPoint >-----#
    id_ce_issuingDistributionPoint = OID(name=u'id-ce-issuingDistributionPoint', mode=MODE_VALUE)
    id_ce_issuingDistributionPoint._val = (2, 5, 29, 28)
    
    #-----< IssuingDistributionPoint >-----#
    IssuingDistributionPoint = SEQ(name=u'IssuingDistributionPoint', mode=MODE_TYPE)
    _IssuingDistributionPoint_distributionPoint = CHOICE(name=u'distributionPoint', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit88', 'DistributionPointName')), opt=True)
    _IssuingDistributionPoint_onlyContainsUserCerts = BOOL(name=u'onlyContainsUserCerts', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), default=False)
    _IssuingDistributionPoint_onlyContainsCACerts = BOOL(name=u'onlyContainsCACerts', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), default=False)
    _IssuingDistributionPoint_onlySomeReasons = BIT_STR(name=u'onlySomeReasons', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit88', 'ReasonFlags')), opt=True)
    _IssuingDistributionPoint_indirectCRL = BOOL(name=u'indirectCRL', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), default=False)
    _IssuingDistributionPoint_onlyContainsAttributeCerts = BOOL(name=u'onlyContainsAttributeCerts', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), default=False)
    IssuingDistributionPoint._cont = ASN1Dict([
        (u'distributionPoint', _IssuingDistributionPoint_distributionPoint),
        (u'onlyContainsUserCerts', _IssuingDistributionPoint_onlyContainsUserCerts),
        (u'onlyContainsCACerts', _IssuingDistributionPoint_onlyContainsCACerts),
        (u'onlySomeReasons', _IssuingDistributionPoint_onlySomeReasons),
        (u'indirectCRL', _IssuingDistributionPoint_indirectCRL),
        (u'onlyContainsAttributeCerts', _IssuingDistributionPoint_onlyContainsAttributeCerts),
        ])
    IssuingDistributionPoint._ext = None
    
    #-----< id-ce-deltaCRLIndicator >-----#
    id_ce_deltaCRLIndicator = OID(name=u'id-ce-deltaCRLIndicator', mode=MODE_VALUE)
    id_ce_deltaCRLIndicator._val = (2, 5, 29, 27)
    
    #-----< BaseCRLNumber >-----#
    BaseCRLNumber = INT(name=u'BaseCRLNumber', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit88', 'CRLNumber')))
    
    #-----< id-ce-cRLReasons >-----#
    id_ce_cRLReasons = OID(name=u'id-ce-cRLReasons', mode=MODE_VALUE)
    id_ce_cRLReasons._val = (2, 5, 29, 21)
    
    #-----< CRLReason >-----#
    CRLReason = ENUM(name=u'CRLReason', mode=MODE_TYPE)
    CRLReason._cont = ASN1Dict([(u'unspecified', 0), (u'keyCompromise', 1), (u'cACompromise', 2), (u'affiliationChanged', 3), (u'superseded', 4), (u'cessationOfOperation', 5), (u'certificateHold', 6), (u'removeFromCRL', 8), (u'privilegeWithdrawn', 9), (u'aACompromise', 10)])
    CRLReason._ext = None
    
    #-----< id-ce-certificateIssuer >-----#
    id_ce_certificateIssuer = OID(name=u'id-ce-certificateIssuer', mode=MODE_VALUE)
    id_ce_certificateIssuer._val = (2, 5, 29, 29)
    
    #-----< CertificateIssuer >-----#
    CertificateIssuer = SEQ_OF(name=u'CertificateIssuer', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit88', 'GeneralNames')))
    
    #-----< id-ce-holdInstructionCode >-----#
    id_ce_holdInstructionCode = OID(name=u'id-ce-holdInstructionCode', mode=MODE_VALUE)
    id_ce_holdInstructionCode._val = (2, 5, 29, 23)
    
    #-----< HoldInstructionCode >-----#
    HoldInstructionCode = OID(name=u'HoldInstructionCode', mode=MODE_TYPE)
    
    #-----< holdInstruction >-----#
    holdInstruction = OID(name=u'holdInstruction', mode=MODE_VALUE)
    holdInstruction._val = (2, 2, 840, 10040, 2)
    
    #-----< id-holdinstruction-none >-----#
    id_holdinstruction_none = OID(name=u'id-holdinstruction-none', mode=MODE_VALUE)
    id_holdinstruction_none._val = (2, 2, 840, 10040, 2, 1)
    
    #-----< id-holdinstruction-callissuer >-----#
    id_holdinstruction_callissuer = OID(name=u'id-holdinstruction-callissuer', mode=MODE_VALUE)
    id_holdinstruction_callissuer._val = (2, 2, 840, 10040, 2, 2)
    
    #-----< id-holdinstruction-reject >-----#
    id_holdinstruction_reject = OID(name=u'id-holdinstruction-reject', mode=MODE_VALUE)
    id_holdinstruction_reject._val = (2, 2, 840, 10040, 2, 3)
    
    #-----< id-ce-invalidityDate >-----#
    id_ce_invalidityDate = OID(name=u'id-ce-invalidityDate', mode=MODE_VALUE)
    id_ce_invalidityDate._val = (2, 5, 29, 24)
    
    #-----< InvalidityDate >-----#
    InvalidityDate = TIME_GEN(name=u'InvalidityDate', mode=MODE_TYPE)
    
    _all_ = [
        id_ce,
        id_ce_authorityKeyIdentifier,
        _AuthorityKeyIdentifier_keyIdentifier,
        _AuthorityKeyIdentifier_authorityCertIssuer,
        _AuthorityKeyIdentifier_authorityCertSerialNumber,
        AuthorityKeyIdentifier,
        KeyIdentifier,
        id_ce_subjectKeyIdentifier,
        SubjectKeyIdentifier,
        id_ce_keyUsage,
        KeyUsage,
        id_ce_privateKeyUsagePeriod,
        _PrivateKeyUsagePeriod_notBefore,
        _PrivateKeyUsagePeriod_notAfter,
        PrivateKeyUsagePeriod,
        id_ce_certificatePolicies,
        anyPolicy,
        _CertificatePolicies__item_,
        CertificatePolicies,
        _PolicyInformation_policyIdentifier,
        __PolicyInformation_policyQualifiers__item_,
        _PolicyInformation_policyQualifiers,
        PolicyInformation,
        CertPolicyId,
        _PolicyQualifierInfo_policyQualifierId,
        _PolicyQualifierInfo_qualifier,
        PolicyQualifierInfo,
        PolicyQualifierId,
        CPSuri,
        _UserNotice_noticeRef,
        _UserNotice_explicitText,
        UserNotice,
        _NoticeReference_organization,
        __NoticeReference_noticeNumbers__item_,
        _NoticeReference_noticeNumbers,
        NoticeReference,
        _DisplayText_ia5String,
        _DisplayText_visibleString,
        _DisplayText_bmpString,
        _DisplayText_utf8String,
        DisplayText,
        id_ce_policyMappings,
        __PolicyMappings__item__issuerDomainPolicy,
        __PolicyMappings__item__subjectDomainPolicy,
        _PolicyMappings__item_,
        PolicyMappings,
        id_ce_subjectAltName,
        SubjectAltName,
        _GeneralNames__item_,
        GeneralNames,
        _GeneralName_otherName,
        _GeneralName_rfc822Name,
        _GeneralName_dNSName,
        _GeneralName_x400Address,
        _GeneralName_directoryName,
        _GeneralName_ediPartyName,
        _GeneralName_uniformResourceIdentifier,
        _GeneralName_iPAddress,
        _GeneralName_registeredID,
        GeneralName,
        _AnotherName_type_id,
        _AnotherName_value,
        AnotherName,
        _EDIPartyName_nameAssigner,
        _EDIPartyName_partyName,
        EDIPartyName,
        id_ce_issuerAltName,
        IssuerAltName,
        id_ce_subjectDirectoryAttributes,
        _SubjectDirectoryAttributes__item_,
        SubjectDirectoryAttributes,
        id_ce_basicConstraints,
        _BasicConstraints_cA,
        _BasicConstraints_pathLenConstraint,
        BasicConstraints,
        id_ce_nameConstraints,
        _NameConstraints_permittedSubtrees,
        _NameConstraints_excludedSubtrees,
        NameConstraints,
        _GeneralSubtrees__item_,
        GeneralSubtrees,
        _GeneralSubtree_base,
        _GeneralSubtree_minimum,
        _GeneralSubtree_maximum,
        GeneralSubtree,
        BaseDistance,
        id_ce_policyConstraints,
        _PolicyConstraints_requireExplicitPolicy,
        _PolicyConstraints_inhibitPolicyMapping,
        PolicyConstraints,
        SkipCerts,
        id_ce_cRLDistributionPoints,
        _CRLDistributionPoints__item_,
        CRLDistributionPoints,
        _DistributionPoint_distributionPoint,
        _DistributionPoint_reasons,
        _DistributionPoint_cRLIssuer,
        DistributionPoint,
        _DistributionPointName_fullName,
        _DistributionPointName_nameRelativeToCRLIssuer,
        DistributionPointName,
        ReasonFlags,
        id_ce_extKeyUsage,
        _ExtKeyUsageSyntax__item_,
        ExtKeyUsageSyntax,
        KeyPurposeId,
        anyExtendedKeyUsage,
        id_kp_serverAuth,
        id_kp_clientAuth,
        id_kp_codeSigning,
        id_kp_emailProtection,
        id_kp_timeStamping,
        id_kp_OCSPSigning,
        id_ce_inhibitAnyPolicy,
        InhibitAnyPolicy,
        id_ce_freshestCRL,
        FreshestCRL,
        id_pe_authorityInfoAccess,
        _AuthorityInfoAccessSyntax__item_,
        AuthorityInfoAccessSyntax,
        _AccessDescription_accessMethod,
        _AccessDescription_accessLocation,
        AccessDescription,
        id_pe_subjectInfoAccess,
        _SubjectInfoAccessSyntax__item_,
        SubjectInfoAccessSyntax,
        id_ce_cRLNumber,
        CRLNumber,
        id_ce_issuingDistributionPoint,
        _IssuingDistributionPoint_distributionPoint,
        _IssuingDistributionPoint_onlyContainsUserCerts,
        _IssuingDistributionPoint_onlyContainsCACerts,
        _IssuingDistributionPoint_onlySomeReasons,
        _IssuingDistributionPoint_indirectCRL,
        _IssuingDistributionPoint_onlyContainsAttributeCerts,
        IssuingDistributionPoint,
        id_ce_deltaCRLIndicator,
        BaseCRLNumber,
        id_ce_cRLReasons,
        CRLReason,
        id_ce_certificateIssuer,
        CertificateIssuer,
        id_ce_holdInstructionCode,
        HoldInstructionCode,
        holdInstruction,
        id_holdinstruction_none,
        id_holdinstruction_callissuer,
        id_holdinstruction_reject,
        id_ce_invalidityDate,
        InvalidityDate,
    ]

class PKIXAttributeCertificate:

    _name_  = u'PKIXAttributeCertificate'
    _oid_   = [1, 3, 6, 1, 5, 5, 7, 0, 12]
    
    _obj_ = [
        u'id-pe-ac-auditIdentity',
        u'id-pe-aaControls',
        u'id-pe-ac-proxying',
        u'id-ce-targetInformation',
        u'id-aca',
        u'id-aca-authenticationInfo',
        u'id-aca-accessIdentity',
        u'id-aca-chargingIdentity',
        u'id-aca-group',
        u'id-aca-encAttrs',
        u'id-at-role',
        u'id-at-clearance',
        u'AttributeCertificate',
        u'AttributeCertificateInfo',
        u'AttCertVersion',
        u'Holder',
        u'ObjectDigestInfo',
        u'AttCertIssuer',
        u'V2Form',
        u'IssuerSerial',
        u'AttCertValidityPeriod',
        u'Targets',
        u'Target',
        u'TargetCert',
        u'IetfAttrSyntax',
        u'SvceAuthInfo',
        u'RoleSyntax',
        u'Clearance',
        u'ClassList',
        u'SecurityCategory',
        u'AAControls',
        u'AttrSpec',
        u'ACClearAttrs',
        u'ProxyInfo',
        ]
    _type_ = [
        u'AttributeCertificate',
        u'AttributeCertificateInfo',
        u'AttCertVersion',
        u'Holder',
        u'ObjectDigestInfo',
        u'AttCertIssuer',
        u'V2Form',
        u'IssuerSerial',
        u'AttCertValidityPeriod',
        u'Targets',
        u'Target',
        u'TargetCert',
        u'IetfAttrSyntax',
        u'SvceAuthInfo',
        u'RoleSyntax',
        u'Clearance',
        u'ClassList',
        u'SecurityCategory',
        u'AAControls',
        u'AttrSpec',
        u'ACClearAttrs',
        u'ProxyInfo',
        ]
    _set_ = [
        ]
    _val_ = [
        u'id-pe-ac-auditIdentity',
        u'id-pe-aaControls',
        u'id-pe-ac-proxying',
        u'id-ce-targetInformation',
        u'id-aca',
        u'id-aca-authenticationInfo',
        u'id-aca-accessIdentity',
        u'id-aca-chargingIdentity',
        u'id-aca-group',
        u'id-aca-encAttrs',
        u'id-at-role',
        u'id-at-clearance',
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< id-pe-ac-auditIdentity >-----#
    id_pe_ac_auditIdentity = OID(name=u'id-pe-ac-auditIdentity', mode=MODE_VALUE)
    id_pe_ac_auditIdentity._val = (1, 3, 6, 1, 5, 5, 7, 1, 4)
    
    #-----< id-pe-aaControls >-----#
    id_pe_aaControls = OID(name=u'id-pe-aaControls', mode=MODE_VALUE)
    id_pe_aaControls._val = (1, 3, 6, 1, 5, 5, 7, 1, 6)
    
    #-----< id-pe-ac-proxying >-----#
    id_pe_ac_proxying = OID(name=u'id-pe-ac-proxying', mode=MODE_VALUE)
    id_pe_ac_proxying._val = (1, 3, 6, 1, 5, 5, 7, 1, 10)
    
    #-----< id-ce-targetInformation >-----#
    id_ce_targetInformation = OID(name=u'id-ce-targetInformation', mode=MODE_VALUE)
    id_ce_targetInformation._val = (2, 5, 29, 55)
    
    #-----< id-aca >-----#
    id_aca = OID(name=u'id-aca', mode=MODE_VALUE)
    id_aca._val = (1, 3, 6, 1, 5, 5, 7, 10)
    
    #-----< id-aca-authenticationInfo >-----#
    id_aca_authenticationInfo = OID(name=u'id-aca-authenticationInfo', mode=MODE_VALUE)
    id_aca_authenticationInfo._val = (1, 3, 6, 1, 5, 5, 7, 10, 1)
    
    #-----< id-aca-accessIdentity >-----#
    id_aca_accessIdentity = OID(name=u'id-aca-accessIdentity', mode=MODE_VALUE)
    id_aca_accessIdentity._val = (1, 3, 6, 1, 5, 5, 7, 10, 2)
    
    #-----< id-aca-chargingIdentity >-----#
    id_aca_chargingIdentity = OID(name=u'id-aca-chargingIdentity', mode=MODE_VALUE)
    id_aca_chargingIdentity._val = (1, 3, 6, 1, 5, 5, 7, 10, 3)
    
    #-----< id-aca-group >-----#
    id_aca_group = OID(name=u'id-aca-group', mode=MODE_VALUE)
    id_aca_group._val = (1, 3, 6, 1, 5, 5, 7, 10, 4)
    
    #-----< id-aca-encAttrs >-----#
    id_aca_encAttrs = OID(name=u'id-aca-encAttrs', mode=MODE_VALUE)
    id_aca_encAttrs._val = (1, 3, 6, 1, 5, 5, 7, 10, 6)
    
    #-----< id-at-role >-----#
    id_at_role = OID(name=u'id-at-role', mode=MODE_VALUE)
    id_at_role._val = (2, 5, 4, 72)
    
    #-----< id-at-clearance >-----#
    id_at_clearance = OID(name=u'id-at-clearance', mode=MODE_VALUE)
    id_at_clearance._val = (2, 5, 1, 5, 55)
    
    #-----< AttributeCertificate >-----#
    AttributeCertificate = SEQ(name=u'AttributeCertificate', mode=MODE_TYPE)
    _AttributeCertificate_acinfo = SEQ(name=u'acinfo', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate', 'AttributeCertificateInfo')))
    _AttributeCertificate_signatureAlgorithm = SEQ(name=u'signatureAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'AlgorithmIdentifier')))
    _AttributeCertificate_signatureValue = BIT_STR(name=u'signatureValue', mode=MODE_TYPE)
    AttributeCertificate._cont = ASN1Dict([
        (u'acinfo', _AttributeCertificate_acinfo),
        (u'signatureAlgorithm', _AttributeCertificate_signatureAlgorithm),
        (u'signatureValue', _AttributeCertificate_signatureValue),
        ])
    AttributeCertificate._ext = None
    
    #-----< AttributeCertificateInfo >-----#
    AttributeCertificateInfo = SEQ(name=u'AttributeCertificateInfo', mode=MODE_TYPE)
    _AttributeCertificateInfo_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate', 'AttCertVersion')))
    _AttributeCertificateInfo_holder = SEQ(name=u'holder', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate', 'Holder')))
    _AttributeCertificateInfo_issuer = CHOICE(name=u'issuer', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate', 'AttCertIssuer')))
    _AttributeCertificateInfo_signature = SEQ(name=u'signature', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'AlgorithmIdentifier')))
    _AttributeCertificateInfo_serialNumber = INT(name=u'serialNumber', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'CertificateSerialNumber')))
    _AttributeCertificateInfo_attrCertValidityPeriod = SEQ(name=u'attrCertValidityPeriod', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate', 'AttCertValidityPeriod')))
    _AttributeCertificateInfo_attributes = SEQ_OF(name=u'attributes', mode=MODE_TYPE)
    __AttributeCertificateInfo_attributes__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'Attribute')))
    _AttributeCertificateInfo_attributes._cont = __AttributeCertificateInfo_attributes__item_
    _AttributeCertificateInfo_issuerUniqueID = BIT_STR(name=u'issuerUniqueID', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'UniqueIdentifier')), opt=True)
    _AttributeCertificateInfo_extensions = SEQ_OF(name=u'extensions', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'Extensions')), opt=True)
    AttributeCertificateInfo._cont = ASN1Dict([
        (u'version', _AttributeCertificateInfo_version),
        (u'holder', _AttributeCertificateInfo_holder),
        (u'issuer', _AttributeCertificateInfo_issuer),
        (u'signature', _AttributeCertificateInfo_signature),
        (u'serialNumber', _AttributeCertificateInfo_serialNumber),
        (u'attrCertValidityPeriod', _AttributeCertificateInfo_attrCertValidityPeriod),
        (u'attributes', _AttributeCertificateInfo_attributes),
        (u'issuerUniqueID', _AttributeCertificateInfo_issuerUniqueID),
        (u'extensions', _AttributeCertificateInfo_extensions),
        ])
    AttributeCertificateInfo._ext = None
    
    #-----< AttCertVersion >-----#
    AttCertVersion = INT(name=u'AttCertVersion', mode=MODE_TYPE)
    AttCertVersion._cont = ASN1Dict([(u'v2', 1)])
    
    #-----< Holder >-----#
    Holder = SEQ(name=u'Holder', mode=MODE_TYPE)
    _Holder_baseCertificateID = SEQ(name=u'baseCertificateID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIXAttributeCertificate', 'IssuerSerial')), opt=True)
    _Holder_entityName = SEQ_OF(name=u'entityName', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit88', 'GeneralNames')), opt=True)
    _Holder_objectDigestInfo = SEQ(name=u'objectDigestInfo', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIXAttributeCertificate', 'ObjectDigestInfo')), opt=True)
    Holder._cont = ASN1Dict([
        (u'baseCertificateID', _Holder_baseCertificateID),
        (u'entityName', _Holder_entityName),
        (u'objectDigestInfo', _Holder_objectDigestInfo),
        ])
    Holder._ext = None
    
    #-----< ObjectDigestInfo >-----#
    ObjectDigestInfo = SEQ(name=u'ObjectDigestInfo', mode=MODE_TYPE)
    _ObjectDigestInfo_digestedObjectType = ENUM(name=u'digestedObjectType', mode=MODE_TYPE)
    _ObjectDigestInfo_digestedObjectType._cont = ASN1Dict([(u'publicKey', 0), (u'publicKeyCert', 1), (u'otherObjectTypes', 2)])
    _ObjectDigestInfo_digestedObjectType._ext = None
    _ObjectDigestInfo_otherObjectTypeID = OID(name=u'otherObjectTypeID', mode=MODE_TYPE, opt=True)
    _ObjectDigestInfo_digestAlgorithm = SEQ(name=u'digestAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'AlgorithmIdentifier')))
    _ObjectDigestInfo_objectDigest = BIT_STR(name=u'objectDigest', mode=MODE_TYPE)
    ObjectDigestInfo._cont = ASN1Dict([
        (u'digestedObjectType', _ObjectDigestInfo_digestedObjectType),
        (u'otherObjectTypeID', _ObjectDigestInfo_otherObjectTypeID),
        (u'digestAlgorithm', _ObjectDigestInfo_digestAlgorithm),
        (u'objectDigest', _ObjectDigestInfo_objectDigest),
        ])
    ObjectDigestInfo._ext = None
    
    #-----< AttCertIssuer >-----#
    AttCertIssuer = CHOICE(name=u'AttCertIssuer', mode=MODE_TYPE)
    _AttCertIssuer_v1Form = SEQ_OF(name=u'v1Form', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit88', 'GeneralNames')))
    _AttCertIssuer_v2Form = SEQ(name=u'v2Form', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIXAttributeCertificate', 'V2Form')))
    AttCertIssuer._cont = ASN1Dict([
        (u'v1Form', _AttCertIssuer_v1Form),
        (u'v2Form', _AttCertIssuer_v2Form),
        ])
    AttCertIssuer._ext = None
    
    #-----< V2Form >-----#
    V2Form = SEQ(name=u'V2Form', mode=MODE_TYPE)
    _V2Form_issuerName = SEQ_OF(name=u'issuerName', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit88', 'GeneralNames')), opt=True)
    _V2Form_baseCertificateID = SEQ(name=u'baseCertificateID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIXAttributeCertificate', 'IssuerSerial')), opt=True)
    _V2Form_objectDigestInfo = SEQ(name=u'objectDigestInfo', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIXAttributeCertificate', 'ObjectDigestInfo')), opt=True)
    V2Form._cont = ASN1Dict([
        (u'issuerName', _V2Form_issuerName),
        (u'baseCertificateID', _V2Form_baseCertificateID),
        (u'objectDigestInfo', _V2Form_objectDigestInfo),
        ])
    V2Form._ext = None
    
    #-----< IssuerSerial >-----#
    IssuerSerial = SEQ(name=u'IssuerSerial', mode=MODE_TYPE)
    _IssuerSerial_issuer = SEQ_OF(name=u'issuer', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit88', 'GeneralNames')))
    _IssuerSerial_serial = INT(name=u'serial', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'CertificateSerialNumber')))
    _IssuerSerial_issuerUID = BIT_STR(name=u'issuerUID', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'UniqueIdentifier')), opt=True)
    IssuerSerial._cont = ASN1Dict([
        (u'issuer', _IssuerSerial_issuer),
        (u'serial', _IssuerSerial_serial),
        (u'issuerUID', _IssuerSerial_issuerUID),
        ])
    IssuerSerial._ext = None
    
    #-----< AttCertValidityPeriod >-----#
    AttCertValidityPeriod = SEQ(name=u'AttCertValidityPeriod', mode=MODE_TYPE)
    _AttCertValidityPeriod_notBeforeTime = TIME_GEN(name=u'notBeforeTime', mode=MODE_TYPE)
    _AttCertValidityPeriod_notAfterTime = TIME_GEN(name=u'notAfterTime', mode=MODE_TYPE)
    AttCertValidityPeriod._cont = ASN1Dict([
        (u'notBeforeTime', _AttCertValidityPeriod_notBeforeTime),
        (u'notAfterTime', _AttCertValidityPeriod_notAfterTime),
        ])
    AttCertValidityPeriod._ext = None
    
    #-----< Targets >-----#
    Targets = SEQ_OF(name=u'Targets', mode=MODE_TYPE)
    _Targets__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate', 'Target')))
    Targets._cont = _Targets__item_
    
    #-----< Target >-----#
    Target = CHOICE(name=u'Target', mode=MODE_TYPE)
    _Target_targetName = CHOICE(name=u'targetName', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit88', 'GeneralName')))
    _Target_targetGroup = CHOICE(name=u'targetGroup', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit88', 'GeneralName')))
    _Target_targetCert = SEQ(name=u'targetCert', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIXAttributeCertificate', 'TargetCert')))
    Target._cont = ASN1Dict([
        (u'targetName', _Target_targetName),
        (u'targetGroup', _Target_targetGroup),
        (u'targetCert', _Target_targetCert),
        ])
    Target._ext = None
    
    #-----< TargetCert >-----#
    TargetCert = SEQ(name=u'TargetCert', mode=MODE_TYPE)
    _TargetCert_targetCertificate = SEQ(name=u'targetCertificate', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate', 'IssuerSerial')))
    _TargetCert_targetName = CHOICE(name=u'targetName', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit88', 'GeneralName')), opt=True)
    _TargetCert_certDigestInfo = SEQ(name=u'certDigestInfo', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate', 'ObjectDigestInfo')), opt=True)
    TargetCert._cont = ASN1Dict([
        (u'targetCertificate', _TargetCert_targetCertificate),
        (u'targetName', _TargetCert_targetName),
        (u'certDigestInfo', _TargetCert_certDigestInfo),
        ])
    TargetCert._ext = None
    
    #-----< IetfAttrSyntax >-----#
    IetfAttrSyntax = SEQ(name=u'IetfAttrSyntax', mode=MODE_TYPE)
    _IetfAttrSyntax_policyAuthority = SEQ_OF(name=u'policyAuthority', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit88', 'GeneralNames')), opt=True)
    _IetfAttrSyntax_values = SEQ_OF(name=u'values', mode=MODE_TYPE)
    __IetfAttrSyntax_values__item_ = CHOICE(name='_item_', mode=MODE_TYPE)
    ___IetfAttrSyntax_values__item__octets = OCT_STR(name=u'octets', mode=MODE_TYPE)
    ___IetfAttrSyntax_values__item__oid = OID(name=u'oid', mode=MODE_TYPE)
    ___IetfAttrSyntax_values__item__string = STR_UTF8(name=u'string', mode=MODE_TYPE)
    __IetfAttrSyntax_values__item_._cont = ASN1Dict([
        (u'octets', ___IetfAttrSyntax_values__item__octets),
        (u'oid', ___IetfAttrSyntax_values__item__oid),
        (u'string', ___IetfAttrSyntax_values__item__string),
        ])
    __IetfAttrSyntax_values__item_._ext = None
    _IetfAttrSyntax_values._cont = __IetfAttrSyntax_values__item_
    IetfAttrSyntax._cont = ASN1Dict([
        (u'policyAuthority', _IetfAttrSyntax_policyAuthority),
        (u'values', _IetfAttrSyntax_values),
        ])
    IetfAttrSyntax._ext = None
    
    #-----< SvceAuthInfo >-----#
    SvceAuthInfo = SEQ(name=u'SvceAuthInfo', mode=MODE_TYPE)
    _SvceAuthInfo_service = CHOICE(name=u'service', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit88', 'GeneralName')))
    _SvceAuthInfo_ident = CHOICE(name=u'ident', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit88', 'GeneralName')))
    _SvceAuthInfo_authInfo = OCT_STR(name=u'authInfo', mode=MODE_TYPE, opt=True)
    SvceAuthInfo._cont = ASN1Dict([
        (u'service', _SvceAuthInfo_service),
        (u'ident', _SvceAuthInfo_ident),
        (u'authInfo', _SvceAuthInfo_authInfo),
        ])
    SvceAuthInfo._ext = None
    
    #-----< RoleSyntax >-----#
    RoleSyntax = SEQ(name=u'RoleSyntax', mode=MODE_TYPE)
    _RoleSyntax_roleAuthority = SEQ_OF(name=u'roleAuthority', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit88', 'GeneralNames')), opt=True)
    _RoleSyntax_roleName = CHOICE(name=u'roleName', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit88', 'GeneralName')))
    RoleSyntax._cont = ASN1Dict([
        (u'roleAuthority', _RoleSyntax_roleAuthority),
        (u'roleName', _RoleSyntax_roleName),
        ])
    RoleSyntax._ext = None
    
    #-----< Clearance >-----#
    Clearance = SEQ(name=u'Clearance', mode=MODE_TYPE)
    _Clearance_policyId = OID(name=u'policyId', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _Clearance_classList = BIT_STR(name=u'classList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIXAttributeCertificate', 'ClassList')), default=(1, 2))
    _Clearance_securityCategories = SET_OF(name=u'securityCategories', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __Clearance_securityCategories__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate', 'SecurityCategory')))
    _Clearance_securityCategories._cont = __Clearance_securityCategories__item_
    Clearance._cont = ASN1Dict([
        (u'policyId', _Clearance_policyId),
        (u'classList', _Clearance_classList),
        (u'securityCategories', _Clearance_securityCategories),
        ])
    Clearance._ext = None
    
    #-----< ClassList >-----#
    ClassList = BIT_STR(name=u'ClassList', mode=MODE_TYPE)
    ClassList._cont = ASN1Dict([(u'unmarked', 0), (u'unclassified', 1), (u'restricted', 2), (u'confidential', 3), (u'secret', 4), (u'topSecret', 5)])
    
    #-----< SecurityCategory >-----#
    SecurityCategory = SEQ(name=u'SecurityCategory', mode=MODE_TYPE)
    _SecurityCategory_type = OID(name=u'type', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _SecurityCategory_value = ANY(name=u'value', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), defby=u'type')
    SecurityCategory._cont = ASN1Dict([
        (u'type', _SecurityCategory_type),
        (u'value', _SecurityCategory_value),
        ])
    SecurityCategory._ext = None
    
    #-----< AAControls >-----#
    AAControls = SEQ(name=u'AAControls', mode=MODE_TYPE)
    _AAControls_pathLenConstraint = INT(name=u'pathLenConstraint', mode=MODE_TYPE, opt=True)
    _AAControls_pathLenConstraint._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    _AAControls_permittedAttrs = SEQ_OF(name=u'permittedAttrs', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIXAttributeCertificate', 'AttrSpec')), opt=True)
    _AAControls_excludedAttrs = SEQ_OF(name=u'excludedAttrs', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIXAttributeCertificate', 'AttrSpec')), opt=True)
    _AAControls_permitUnSpecified = BOOL(name=u'permitUnSpecified', mode=MODE_TYPE, default=True)
    AAControls._cont = ASN1Dict([
        (u'pathLenConstraint', _AAControls_pathLenConstraint),
        (u'permittedAttrs', _AAControls_permittedAttrs),
        (u'excludedAttrs', _AAControls_excludedAttrs),
        (u'permitUnSpecified', _AAControls_permitUnSpecified),
        ])
    AAControls._ext = None
    
    #-----< AttrSpec >-----#
    AttrSpec = SEQ_OF(name=u'AttrSpec', mode=MODE_TYPE)
    _AttrSpec__item_ = OID(name='_item_', mode=MODE_TYPE)
    AttrSpec._cont = _AttrSpec__item_
    
    #-----< ACClearAttrs >-----#
    ACClearAttrs = SEQ(name=u'ACClearAttrs', mode=MODE_TYPE)
    _ACClearAttrs_acIssuer = CHOICE(name=u'acIssuer', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit88', 'GeneralName')))
    _ACClearAttrs_acSerial = INT(name=u'acSerial', mode=MODE_TYPE)
    _ACClearAttrs_attrs = SEQ_OF(name=u'attrs', mode=MODE_TYPE)
    __ACClearAttrs_attrs__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'Attribute')))
    _ACClearAttrs_attrs._cont = __ACClearAttrs_attrs__item_
    ACClearAttrs._cont = ASN1Dict([
        (u'acIssuer', _ACClearAttrs_acIssuer),
        (u'acSerial', _ACClearAttrs_acSerial),
        (u'attrs', _ACClearAttrs_attrs),
        ])
    ACClearAttrs._ext = None
    
    #-----< ProxyInfo >-----#
    ProxyInfo = SEQ_OF(name=u'ProxyInfo', mode=MODE_TYPE)
    _ProxyInfo__item_ = SEQ_OF(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate', 'Targets')))
    ProxyInfo._cont = _ProxyInfo__item_
    
    _all_ = [
        id_pe_ac_auditIdentity,
        id_pe_aaControls,
        id_pe_ac_proxying,
        id_ce_targetInformation,
        id_aca,
        id_aca_authenticationInfo,
        id_aca_accessIdentity,
        id_aca_chargingIdentity,
        id_aca_group,
        id_aca_encAttrs,
        id_at_role,
        id_at_clearance,
        _AttributeCertificate_acinfo,
        _AttributeCertificate_signatureAlgorithm,
        _AttributeCertificate_signatureValue,
        AttributeCertificate,
        _AttributeCertificateInfo_version,
        _AttributeCertificateInfo_holder,
        _AttributeCertificateInfo_issuer,
        _AttributeCertificateInfo_signature,
        _AttributeCertificateInfo_serialNumber,
        _AttributeCertificateInfo_attrCertValidityPeriod,
        __AttributeCertificateInfo_attributes__item_,
        _AttributeCertificateInfo_attributes,
        _AttributeCertificateInfo_issuerUniqueID,
        _AttributeCertificateInfo_extensions,
        AttributeCertificateInfo,
        AttCertVersion,
        _Holder_baseCertificateID,
        _Holder_entityName,
        _Holder_objectDigestInfo,
        Holder,
        _ObjectDigestInfo_digestedObjectType,
        _ObjectDigestInfo_otherObjectTypeID,
        _ObjectDigestInfo_digestAlgorithm,
        _ObjectDigestInfo_objectDigest,
        ObjectDigestInfo,
        _AttCertIssuer_v1Form,
        _AttCertIssuer_v2Form,
        AttCertIssuer,
        _V2Form_issuerName,
        _V2Form_baseCertificateID,
        _V2Form_objectDigestInfo,
        V2Form,
        _IssuerSerial_issuer,
        _IssuerSerial_serial,
        _IssuerSerial_issuerUID,
        IssuerSerial,
        _AttCertValidityPeriod_notBeforeTime,
        _AttCertValidityPeriod_notAfterTime,
        AttCertValidityPeriod,
        _Targets__item_,
        Targets,
        _Target_targetName,
        _Target_targetGroup,
        _Target_targetCert,
        Target,
        _TargetCert_targetCertificate,
        _TargetCert_targetName,
        _TargetCert_certDigestInfo,
        TargetCert,
        _IetfAttrSyntax_policyAuthority,
        ___IetfAttrSyntax_values__item__octets,
        ___IetfAttrSyntax_values__item__oid,
        ___IetfAttrSyntax_values__item__string,
        __IetfAttrSyntax_values__item_,
        _IetfAttrSyntax_values,
        IetfAttrSyntax,
        _SvceAuthInfo_service,
        _SvceAuthInfo_ident,
        _SvceAuthInfo_authInfo,
        SvceAuthInfo,
        _RoleSyntax_roleAuthority,
        _RoleSyntax_roleName,
        RoleSyntax,
        _Clearance_policyId,
        _Clearance_classList,
        __Clearance_securityCategories__item_,
        _Clearance_securityCategories,
        Clearance,
        ClassList,
        _SecurityCategory_type,
        _SecurityCategory_value,
        SecurityCategory,
        _AAControls_pathLenConstraint,
        _AAControls_permittedAttrs,
        _AAControls_excludedAttrs,
        _AAControls_permitUnSpecified,
        AAControls,
        _AttrSpec__item_,
        AttrSpec,
        _ACClearAttrs_acIssuer,
        _ACClearAttrs_acSerial,
        __ACClearAttrs_attrs__item_,
        _ACClearAttrs_attrs,
        ACClearAttrs,
        _ProxyInfo__item_,
        ProxyInfo,
    ]

class AttributeCertificateVersion1:

    _name_  = u'AttributeCertificateVersion1'
    _oid_   = [1, 2, 840, 113549, 1, 9, 16, 0, 15]
    
    _obj_ = [
        u'AttributeCertificateV1',
        u'AttributeCertificateInfoV1',
        u'AttCertVersionV1',
        ]
    _type_ = [
        u'AttributeCertificateV1',
        u'AttributeCertificateInfoV1',
        u'AttCertVersionV1',
        ]
    _set_ = [
        ]
    _val_ = [
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< AttributeCertificateV1 >-----#
    AttributeCertificateV1 = SEQ(name=u'AttributeCertificateV1', mode=MODE_TYPE)
    _AttributeCertificateV1_acInfo = SEQ(name=u'acInfo', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateVersion1', 'AttributeCertificateInfoV1')))
    _AttributeCertificateV1_signatureAlgorithm = SEQ(name=u'signatureAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'AlgorithmIdentifier')))
    _AttributeCertificateV1_signature = BIT_STR(name=u'signature', mode=MODE_TYPE)
    AttributeCertificateV1._cont = ASN1Dict([
        (u'acInfo', _AttributeCertificateV1_acInfo),
        (u'signatureAlgorithm', _AttributeCertificateV1_signatureAlgorithm),
        (u'signature', _AttributeCertificateV1_signature),
        ])
    AttributeCertificateV1._ext = None
    
    #-----< AttributeCertificateInfoV1 >-----#
    AttributeCertificateInfoV1 = SEQ(name=u'AttributeCertificateInfoV1', mode=MODE_TYPE)
    _AttributeCertificateInfoV1_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateVersion1', 'AttCertVersionV1')), default=0)
    _AttributeCertificateInfoV1_subject = CHOICE(name=u'subject', mode=MODE_TYPE)
    __AttributeCertificateInfoV1_subject_baseCertificateID = SEQ(name=u'baseCertificateID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIXAttributeCertificate', 'IssuerSerial')))
    __AttributeCertificateInfoV1_subject_subjectName = SEQ_OF(name=u'subjectName', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIX1Implicit88', 'GeneralNames')))
    _AttributeCertificateInfoV1_subject._cont = ASN1Dict([
        (u'baseCertificateID', __AttributeCertificateInfoV1_subject_baseCertificateID),
        (u'subjectName', __AttributeCertificateInfoV1_subject_subjectName),
        ])
    _AttributeCertificateInfoV1_subject._ext = None
    _AttributeCertificateInfoV1_issuer = SEQ_OF(name=u'issuer', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit88', 'GeneralNames')))
    _AttributeCertificateInfoV1_signature = SEQ(name=u'signature', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'AlgorithmIdentifier')))
    _AttributeCertificateInfoV1_serialNumber = INT(name=u'serialNumber', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'CertificateSerialNumber')))
    _AttributeCertificateInfoV1_attCertValidityPeriod = SEQ(name=u'attCertValidityPeriod', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate', 'AttCertValidityPeriod')))
    _AttributeCertificateInfoV1_attributes = SEQ_OF(name=u'attributes', mode=MODE_TYPE)
    __AttributeCertificateInfoV1_attributes__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'Attribute')))
    _AttributeCertificateInfoV1_attributes._cont = __AttributeCertificateInfoV1_attributes__item_
    _AttributeCertificateInfoV1_issuerUniqueID = BIT_STR(name=u'issuerUniqueID', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'UniqueIdentifier')), opt=True)
    _AttributeCertificateInfoV1_extensions = SEQ_OF(name=u'extensions', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'Extensions')), opt=True)
    AttributeCertificateInfoV1._cont = ASN1Dict([
        (u'version', _AttributeCertificateInfoV1_version),
        (u'subject', _AttributeCertificateInfoV1_subject),
        (u'issuer', _AttributeCertificateInfoV1_issuer),
        (u'signature', _AttributeCertificateInfoV1_signature),
        (u'serialNumber', _AttributeCertificateInfoV1_serialNumber),
        (u'attCertValidityPeriod', _AttributeCertificateInfoV1_attCertValidityPeriod),
        (u'attributes', _AttributeCertificateInfoV1_attributes),
        (u'issuerUniqueID', _AttributeCertificateInfoV1_issuerUniqueID),
        (u'extensions', _AttributeCertificateInfoV1_extensions),
        ])
    AttributeCertificateInfoV1._ext = None
    
    #-----< AttCertVersionV1 >-----#
    AttCertVersionV1 = INT(name=u'AttCertVersionV1', mode=MODE_TYPE)
    AttCertVersionV1._cont = ASN1Dict([(u'v1', 0)])
    
    _all_ = [
        _AttributeCertificateV1_acInfo,
        _AttributeCertificateV1_signatureAlgorithm,
        _AttributeCertificateV1_signature,
        AttributeCertificateV1,
        _AttributeCertificateInfoV1_version,
        __AttributeCertificateInfoV1_subject_baseCertificateID,
        __AttributeCertificateInfoV1_subject_subjectName,
        _AttributeCertificateInfoV1_subject,
        _AttributeCertificateInfoV1_issuer,
        _AttributeCertificateInfoV1_signature,
        _AttributeCertificateInfoV1_serialNumber,
        _AttributeCertificateInfoV1_attCertValidityPeriod,
        __AttributeCertificateInfoV1_attributes__item_,
        _AttributeCertificateInfoV1_attributes,
        _AttributeCertificateInfoV1_issuerUniqueID,
        _AttributeCertificateInfoV1_extensions,
        AttributeCertificateInfoV1,
        AttCertVersionV1,
    ]

class CryptographicMessageSyntax2004:

    _name_  = u'CryptographicMessageSyntax2004'
    _oid_   = [1, 2, 840, 113549, 1, 9, 16, 0, 24]
    
    _obj_ = [
        u'ContentInfo',
        u'ContentType',
        u'SignedData',
        u'DigestAlgorithmIdentifiers',
        u'SignerInfos',
        u'EncapsulatedContentInfo',
        u'SignerInfo',
        u'SignerIdentifier',
        u'SignedAttributes',
        u'UnsignedAttributes',
        u'Attribute',
        u'AttributeValue',
        u'SignatureValue',
        u'EnvelopedData',
        u'OriginatorInfo',
        u'RecipientInfos',
        u'EncryptedContentInfo',
        u'EncryptedContent',
        u'UnprotectedAttributes',
        u'RecipientInfo',
        u'EncryptedKey',
        u'KeyTransRecipientInfo',
        u'RecipientIdentifier',
        u'KeyAgreeRecipientInfo',
        u'OriginatorIdentifierOrKey',
        u'OriginatorPublicKey',
        u'RecipientEncryptedKeys',
        u'RecipientEncryptedKey',
        u'KeyAgreeRecipientIdentifier',
        u'RecipientKeyIdentifier',
        u'SubjectKeyIdentifier',
        u'KEKRecipientInfo',
        u'KEKIdentifier',
        u'PasswordRecipientInfo',
        u'OtherRecipientInfo',
        u'DigestedData',
        u'Digest',
        u'EncryptedData',
        u'AuthenticatedData',
        u'AuthAttributes',
        u'UnauthAttributes',
        u'MessageAuthenticationCode',
        u'DigestAlgorithmIdentifier',
        u'SignatureAlgorithmIdentifier',
        u'KeyEncryptionAlgorithmIdentifier',
        u'ContentEncryptionAlgorithmIdentifier',
        u'MessageAuthenticationCodeAlgorithm',
        u'KeyDerivationAlgorithmIdentifier',
        u'RevocationInfoChoices',
        u'RevocationInfoChoice',
        u'OtherRevocationInfoFormat',
        u'CertificateChoices',
        u'AttributeCertificateV2',
        u'OtherCertificateFormat',
        u'CertificateSet',
        u'IssuerAndSerialNumber',
        u'CMSVersion',
        u'UserKeyingMaterial',
        u'OtherKeyAttribute',
        u'id-ct-contentInfo',
        u'id-data',
        u'id-signedData',
        u'id-envelopedData',
        u'id-digestedData',
        u'id-encryptedData',
        u'id-ct-authData',
        u'MessageDigest',
        u'SigningTime',
        u'Time',
        u'Countersignature',
        u'id-contentType',
        u'id-messageDigest',
        u'id-signingTime',
        u'id-countersignature',
        u'ExtendedCertificateOrCertificate',
        u'ExtendedCertificate',
        u'ExtendedCertificateInfo',
        u'Signature',
        ]
    _type_ = [
        u'ContentInfo',
        u'ContentType',
        u'SignedData',
        u'DigestAlgorithmIdentifiers',
        u'SignerInfos',
        u'EncapsulatedContentInfo',
        u'SignerInfo',
        u'SignerIdentifier',
        u'SignedAttributes',
        u'UnsignedAttributes',
        u'Attribute',
        u'AttributeValue',
        u'SignatureValue',
        u'EnvelopedData',
        u'OriginatorInfo',
        u'RecipientInfos',
        u'EncryptedContentInfo',
        u'EncryptedContent',
        u'UnprotectedAttributes',
        u'RecipientInfo',
        u'EncryptedKey',
        u'KeyTransRecipientInfo',
        u'RecipientIdentifier',
        u'KeyAgreeRecipientInfo',
        u'OriginatorIdentifierOrKey',
        u'OriginatorPublicKey',
        u'RecipientEncryptedKeys',
        u'RecipientEncryptedKey',
        u'KeyAgreeRecipientIdentifier',
        u'RecipientKeyIdentifier',
        u'SubjectKeyIdentifier',
        u'KEKRecipientInfo',
        u'KEKIdentifier',
        u'PasswordRecipientInfo',
        u'OtherRecipientInfo',
        u'DigestedData',
        u'Digest',
        u'EncryptedData',
        u'AuthenticatedData',
        u'AuthAttributes',
        u'UnauthAttributes',
        u'MessageAuthenticationCode',
        u'DigestAlgorithmIdentifier',
        u'SignatureAlgorithmIdentifier',
        u'KeyEncryptionAlgorithmIdentifier',
        u'ContentEncryptionAlgorithmIdentifier',
        u'MessageAuthenticationCodeAlgorithm',
        u'KeyDerivationAlgorithmIdentifier',
        u'RevocationInfoChoices',
        u'RevocationInfoChoice',
        u'OtherRevocationInfoFormat',
        u'CertificateChoices',
        u'AttributeCertificateV2',
        u'OtherCertificateFormat',
        u'CertificateSet',
        u'IssuerAndSerialNumber',
        u'CMSVersion',
        u'UserKeyingMaterial',
        u'OtherKeyAttribute',
        u'MessageDigest',
        u'SigningTime',
        u'Time',
        u'Countersignature',
        u'ExtendedCertificateOrCertificate',
        u'ExtendedCertificate',
        u'ExtendedCertificateInfo',
        u'Signature',
        ]
    _set_ = [
        ]
    _val_ = [
        u'id-ct-contentInfo',
        u'id-data',
        u'id-signedData',
        u'id-envelopedData',
        u'id-digestedData',
        u'id-encryptedData',
        u'id-ct-authData',
        u'id-contentType',
        u'id-messageDigest',
        u'id-signingTime',
        u'id-countersignature',
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< ContentInfo >-----#
    ContentInfo = SEQ(name=u'ContentInfo', mode=MODE_TYPE)
    _ContentInfo_contentType = OID(name=u'contentType', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'ContentType')))
    _ContentInfo_content = ANY(name=u'content', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), defby=u'contentType')
    ContentInfo._cont = ASN1Dict([
        (u'contentType', _ContentInfo_contentType),
        (u'content', _ContentInfo_content),
        ])
    ContentInfo._ext = None
    
    #-----< ContentType >-----#
    ContentType = OID(name=u'ContentType', mode=MODE_TYPE)
    
    #-----< SignedData >-----#
    SignedData = SEQ(name=u'SignedData', mode=MODE_TYPE)
    _SignedData_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'CMSVersion')))
    _SignedData_digestAlgorithms = SET_OF(name=u'digestAlgorithms', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'DigestAlgorithmIdentifiers')))
    _SignedData_encapContentInfo = SEQ(name=u'encapContentInfo', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'EncapsulatedContentInfo')))
    _SignedData_certificates = SET_OF(name=u'certificates', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'CertificateSet')), opt=True)
    _SignedData_crls = SET_OF(name=u'crls', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'RevocationInfoChoices')), opt=True)
    _SignedData_signerInfos = SET_OF(name=u'signerInfos', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'SignerInfos')))
    SignedData._cont = ASN1Dict([
        (u'version', _SignedData_version),
        (u'digestAlgorithms', _SignedData_digestAlgorithms),
        (u'encapContentInfo', _SignedData_encapContentInfo),
        (u'certificates', _SignedData_certificates),
        (u'crls', _SignedData_crls),
        (u'signerInfos', _SignedData_signerInfos),
        ])
    SignedData._ext = None
    
    #-----< DigestAlgorithmIdentifiers >-----#
    DigestAlgorithmIdentifiers = SET_OF(name=u'DigestAlgorithmIdentifiers', mode=MODE_TYPE)
    _DigestAlgorithmIdentifiers__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'DigestAlgorithmIdentifier')))
    DigestAlgorithmIdentifiers._cont = _DigestAlgorithmIdentifiers__item_
    
    #-----< SignerInfos >-----#
    SignerInfos = SET_OF(name=u'SignerInfos', mode=MODE_TYPE)
    _SignerInfos__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'SignerInfo')))
    SignerInfos._cont = _SignerInfos__item_
    
    #-----< EncapsulatedContentInfo >-----#
    EncapsulatedContentInfo = SEQ(name=u'EncapsulatedContentInfo', mode=MODE_TYPE)
    _EncapsulatedContentInfo_eContentType = OID(name=u'eContentType', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'ContentType')))
    _EncapsulatedContentInfo_eContent = OCT_STR(name=u'eContent', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    EncapsulatedContentInfo._cont = ASN1Dict([
        (u'eContentType', _EncapsulatedContentInfo_eContentType),
        (u'eContent', _EncapsulatedContentInfo_eContent),
        ])
    EncapsulatedContentInfo._ext = None
    
    #-----< SignerInfo >-----#
    SignerInfo = SEQ(name=u'SignerInfo', mode=MODE_TYPE)
    _SignerInfo_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'CMSVersion')))
    _SignerInfo_sid = CHOICE(name=u'sid', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'SignerIdentifier')))
    _SignerInfo_digestAlgorithm = SEQ(name=u'digestAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'DigestAlgorithmIdentifier')))
    _SignerInfo_signedAttrs = SET_OF(name=u'signedAttrs', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'SignedAttributes')), opt=True)
    _SignerInfo_signatureAlgorithm = SEQ(name=u'signatureAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'SignatureAlgorithmIdentifier')))
    _SignerInfo_signature = OCT_STR(name=u'signature', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'SignatureValue')))
    _SignerInfo_unsignedAttrs = SET_OF(name=u'unsignedAttrs', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'UnsignedAttributes')), opt=True)
    SignerInfo._cont = ASN1Dict([
        (u'version', _SignerInfo_version),
        (u'sid', _SignerInfo_sid),
        (u'digestAlgorithm', _SignerInfo_digestAlgorithm),
        (u'signedAttrs', _SignerInfo_signedAttrs),
        (u'signatureAlgorithm', _SignerInfo_signatureAlgorithm),
        (u'signature', _SignerInfo_signature),
        (u'unsignedAttrs', _SignerInfo_unsignedAttrs),
        ])
    SignerInfo._ext = None
    
    #-----< SignerIdentifier >-----#
    SignerIdentifier = CHOICE(name=u'SignerIdentifier', mode=MODE_TYPE)
    _SignerIdentifier_issuerAndSerialNumber = SEQ(name=u'issuerAndSerialNumber', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'IssuerAndSerialNumber')))
    _SignerIdentifier_subjectKeyIdentifier = OCT_STR(name=u'subjectKeyIdentifier', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'SubjectKeyIdentifier')))
    SignerIdentifier._cont = ASN1Dict([
        (u'issuerAndSerialNumber', _SignerIdentifier_issuerAndSerialNumber),
        (u'subjectKeyIdentifier', _SignerIdentifier_subjectKeyIdentifier),
        ])
    SignerIdentifier._ext = None
    
    #-----< SignedAttributes >-----#
    SignedAttributes = SET_OF(name=u'SignedAttributes', mode=MODE_TYPE)
    _SignedAttributes__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'Attribute')))
    SignedAttributes._cont = _SignedAttributes__item_
    SignedAttributes._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< UnsignedAttributes >-----#
    UnsignedAttributes = SET_OF(name=u'UnsignedAttributes', mode=MODE_TYPE)
    _UnsignedAttributes__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'Attribute')))
    UnsignedAttributes._cont = _UnsignedAttributes__item_
    UnsignedAttributes._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< Attribute >-----#
    Attribute = SEQ(name=u'Attribute', mode=MODE_TYPE)
    _Attribute_attrType = OID(name=u'attrType', mode=MODE_TYPE)
    _Attribute_attrValues = SET_OF(name=u'attrValues', mode=MODE_TYPE)
    __Attribute_attrValues__item_ = ANY(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'AttributeValue')))
    _Attribute_attrValues._cont = __Attribute_attrValues__item_
    Attribute._cont = ASN1Dict([
        (u'attrType', _Attribute_attrType),
        (u'attrValues', _Attribute_attrValues),
        ])
    Attribute._ext = None
    
    #-----< AttributeValue >-----#
    AttributeValue = ANY(name=u'AttributeValue', mode=MODE_TYPE)
    
    #-----< SignatureValue >-----#
    SignatureValue = OCT_STR(name=u'SignatureValue', mode=MODE_TYPE)
    
    #-----< EnvelopedData >-----#
    EnvelopedData = SEQ(name=u'EnvelopedData', mode=MODE_TYPE)
    _EnvelopedData_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'CMSVersion')))
    _EnvelopedData_originatorInfo = SEQ(name=u'originatorInfo', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'OriginatorInfo')), opt=True)
    _EnvelopedData_recipientInfos = SET_OF(name=u'recipientInfos', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'RecipientInfos')))
    _EnvelopedData_encryptedContentInfo = SEQ(name=u'encryptedContentInfo', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'EncryptedContentInfo')))
    _EnvelopedData_unprotectedAttrs = SET_OF(name=u'unprotectedAttrs', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'UnprotectedAttributes')), opt=True)
    EnvelopedData._cont = ASN1Dict([
        (u'version', _EnvelopedData_version),
        (u'originatorInfo', _EnvelopedData_originatorInfo),
        (u'recipientInfos', _EnvelopedData_recipientInfos),
        (u'encryptedContentInfo', _EnvelopedData_encryptedContentInfo),
        (u'unprotectedAttrs', _EnvelopedData_unprotectedAttrs),
        ])
    EnvelopedData._ext = None
    
    #-----< OriginatorInfo >-----#
    OriginatorInfo = SEQ(name=u'OriginatorInfo', mode=MODE_TYPE)
    _OriginatorInfo_certs = SET_OF(name=u'certs', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'CertificateSet')), opt=True)
    _OriginatorInfo_crls = SET_OF(name=u'crls', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'RevocationInfoChoices')), opt=True)
    OriginatorInfo._cont = ASN1Dict([
        (u'certs', _OriginatorInfo_certs),
        (u'crls', _OriginatorInfo_crls),
        ])
    OriginatorInfo._ext = None
    
    #-----< RecipientInfos >-----#
    RecipientInfos = SET_OF(name=u'RecipientInfos', mode=MODE_TYPE)
    _RecipientInfos__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'RecipientInfo')))
    RecipientInfos._cont = _RecipientInfos__item_
    RecipientInfos._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< EncryptedContentInfo >-----#
    EncryptedContentInfo = SEQ(name=u'EncryptedContentInfo', mode=MODE_TYPE)
    _EncryptedContentInfo_contentType = OID(name=u'contentType', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'ContentType')))
    _EncryptedContentInfo_contentEncryptionAlgorithm = SEQ(name=u'contentEncryptionAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'ContentEncryptionAlgorithmIdentifier')))
    _EncryptedContentInfo_encryptedContent = OCT_STR(name=u'encryptedContent', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'EncryptedContent')), opt=True)
    EncryptedContentInfo._cont = ASN1Dict([
        (u'contentType', _EncryptedContentInfo_contentType),
        (u'contentEncryptionAlgorithm', _EncryptedContentInfo_contentEncryptionAlgorithm),
        (u'encryptedContent', _EncryptedContentInfo_encryptedContent),
        ])
    EncryptedContentInfo._ext = None
    
    #-----< EncryptedContent >-----#
    EncryptedContent = OCT_STR(name=u'EncryptedContent', mode=MODE_TYPE)
    
    #-----< UnprotectedAttributes >-----#
    UnprotectedAttributes = SET_OF(name=u'UnprotectedAttributes', mode=MODE_TYPE)
    _UnprotectedAttributes__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'Attribute')))
    UnprotectedAttributes._cont = _UnprotectedAttributes__item_
    UnprotectedAttributes._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< RecipientInfo >-----#
    RecipientInfo = CHOICE(name=u'RecipientInfo', mode=MODE_TYPE)
    _RecipientInfo_ktri = SEQ(name=u'ktri', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'KeyTransRecipientInfo')))
    _RecipientInfo_kari = SEQ(name=u'kari', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'KeyAgreeRecipientInfo')))
    _RecipientInfo_kekri = SEQ(name=u'kekri', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'KEKRecipientInfo')))
    _RecipientInfo_pwri = SEQ(name=u'pwri', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'PasswordRecipientInfo')))
    _RecipientInfo_ori = SEQ(name=u'ori', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'OtherRecipientInfo')))
    RecipientInfo._cont = ASN1Dict([
        (u'ktri', _RecipientInfo_ktri),
        (u'kari', _RecipientInfo_kari),
        (u'kekri', _RecipientInfo_kekri),
        (u'pwri', _RecipientInfo_pwri),
        (u'ori', _RecipientInfo_ori),
        ])
    RecipientInfo._ext = None
    
    #-----< EncryptedKey >-----#
    EncryptedKey = OCT_STR(name=u'EncryptedKey', mode=MODE_TYPE)
    
    #-----< KeyTransRecipientInfo >-----#
    KeyTransRecipientInfo = SEQ(name=u'KeyTransRecipientInfo', mode=MODE_TYPE)
    _KeyTransRecipientInfo_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'CMSVersion')))
    _KeyTransRecipientInfo_rid = CHOICE(name=u'rid', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'RecipientIdentifier')))
    _KeyTransRecipientInfo_keyEncryptionAlgorithm = SEQ(name=u'keyEncryptionAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'KeyEncryptionAlgorithmIdentifier')))
    _KeyTransRecipientInfo_encryptedKey = OCT_STR(name=u'encryptedKey', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'EncryptedKey')))
    KeyTransRecipientInfo._cont = ASN1Dict([
        (u'version', _KeyTransRecipientInfo_version),
        (u'rid', _KeyTransRecipientInfo_rid),
        (u'keyEncryptionAlgorithm', _KeyTransRecipientInfo_keyEncryptionAlgorithm),
        (u'encryptedKey', _KeyTransRecipientInfo_encryptedKey),
        ])
    KeyTransRecipientInfo._ext = None
    
    #-----< RecipientIdentifier >-----#
    RecipientIdentifier = CHOICE(name=u'RecipientIdentifier', mode=MODE_TYPE)
    _RecipientIdentifier_issuerAndSerialNumber = SEQ(name=u'issuerAndSerialNumber', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'IssuerAndSerialNumber')))
    _RecipientIdentifier_subjectKeyIdentifier = OCT_STR(name=u'subjectKeyIdentifier', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'SubjectKeyIdentifier')))
    RecipientIdentifier._cont = ASN1Dict([
        (u'issuerAndSerialNumber', _RecipientIdentifier_issuerAndSerialNumber),
        (u'subjectKeyIdentifier', _RecipientIdentifier_subjectKeyIdentifier),
        ])
    RecipientIdentifier._ext = None
    
    #-----< KeyAgreeRecipientInfo >-----#
    KeyAgreeRecipientInfo = SEQ(name=u'KeyAgreeRecipientInfo', mode=MODE_TYPE)
    _KeyAgreeRecipientInfo_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'CMSVersion')))
    _KeyAgreeRecipientInfo_originator = CHOICE(name=u'originator', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'OriginatorIdentifierOrKey')))
    _KeyAgreeRecipientInfo_ukm = OCT_STR(name=u'ukm', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'UserKeyingMaterial')), opt=True)
    _KeyAgreeRecipientInfo_keyEncryptionAlgorithm = SEQ(name=u'keyEncryptionAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'KeyEncryptionAlgorithmIdentifier')))
    _KeyAgreeRecipientInfo_recipientEncryptedKeys = SEQ_OF(name=u'recipientEncryptedKeys', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'RecipientEncryptedKeys')))
    KeyAgreeRecipientInfo._cont = ASN1Dict([
        (u'version', _KeyAgreeRecipientInfo_version),
        (u'originator', _KeyAgreeRecipientInfo_originator),
        (u'ukm', _KeyAgreeRecipientInfo_ukm),
        (u'keyEncryptionAlgorithm', _KeyAgreeRecipientInfo_keyEncryptionAlgorithm),
        (u'recipientEncryptedKeys', _KeyAgreeRecipientInfo_recipientEncryptedKeys),
        ])
    KeyAgreeRecipientInfo._ext = None
    
    #-----< OriginatorIdentifierOrKey >-----#
    OriginatorIdentifierOrKey = CHOICE(name=u'OriginatorIdentifierOrKey', mode=MODE_TYPE)
    _OriginatorIdentifierOrKey_issuerAndSerialNumber = SEQ(name=u'issuerAndSerialNumber', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'IssuerAndSerialNumber')))
    _OriginatorIdentifierOrKey_subjectKeyIdentifier = OCT_STR(name=u'subjectKeyIdentifier', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'SubjectKeyIdentifier')))
    _OriginatorIdentifierOrKey_originatorKey = SEQ(name=u'originatorKey', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'OriginatorPublicKey')))
    OriginatorIdentifierOrKey._cont = ASN1Dict([
        (u'issuerAndSerialNumber', _OriginatorIdentifierOrKey_issuerAndSerialNumber),
        (u'subjectKeyIdentifier', _OriginatorIdentifierOrKey_subjectKeyIdentifier),
        (u'originatorKey', _OriginatorIdentifierOrKey_originatorKey),
        ])
    OriginatorIdentifierOrKey._ext = None
    
    #-----< OriginatorPublicKey >-----#
    OriginatorPublicKey = SEQ(name=u'OriginatorPublicKey', mode=MODE_TYPE)
    _OriginatorPublicKey_algorithm = SEQ(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'AlgorithmIdentifier')))
    _OriginatorPublicKey_publicKey = BIT_STR(name=u'publicKey', mode=MODE_TYPE)
    OriginatorPublicKey._cont = ASN1Dict([
        (u'algorithm', _OriginatorPublicKey_algorithm),
        (u'publicKey', _OriginatorPublicKey_publicKey),
        ])
    OriginatorPublicKey._ext = None
    
    #-----< RecipientEncryptedKeys >-----#
    RecipientEncryptedKeys = SEQ_OF(name=u'RecipientEncryptedKeys', mode=MODE_TYPE)
    _RecipientEncryptedKeys__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'RecipientEncryptedKey')))
    RecipientEncryptedKeys._cont = _RecipientEncryptedKeys__item_
    
    #-----< RecipientEncryptedKey >-----#
    RecipientEncryptedKey = SEQ(name=u'RecipientEncryptedKey', mode=MODE_TYPE)
    _RecipientEncryptedKey_rid = CHOICE(name=u'rid', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'KeyAgreeRecipientIdentifier')))
    _RecipientEncryptedKey_encryptedKey = OCT_STR(name=u'encryptedKey', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'EncryptedKey')))
    RecipientEncryptedKey._cont = ASN1Dict([
        (u'rid', _RecipientEncryptedKey_rid),
        (u'encryptedKey', _RecipientEncryptedKey_encryptedKey),
        ])
    RecipientEncryptedKey._ext = None
    
    #-----< KeyAgreeRecipientIdentifier >-----#
    KeyAgreeRecipientIdentifier = CHOICE(name=u'KeyAgreeRecipientIdentifier', mode=MODE_TYPE)
    _KeyAgreeRecipientIdentifier_issuerAndSerialNumber = SEQ(name=u'issuerAndSerialNumber', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'IssuerAndSerialNumber')))
    _KeyAgreeRecipientIdentifier_rKeyId = SEQ(name=u'rKeyId', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'RecipientKeyIdentifier')))
    KeyAgreeRecipientIdentifier._cont = ASN1Dict([
        (u'issuerAndSerialNumber', _KeyAgreeRecipientIdentifier_issuerAndSerialNumber),
        (u'rKeyId', _KeyAgreeRecipientIdentifier_rKeyId),
        ])
    KeyAgreeRecipientIdentifier._ext = None
    
    #-----< RecipientKeyIdentifier >-----#
    RecipientKeyIdentifier = SEQ(name=u'RecipientKeyIdentifier', mode=MODE_TYPE)
    _RecipientKeyIdentifier_subjectKeyIdentifier = OCT_STR(name=u'subjectKeyIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'SubjectKeyIdentifier')))
    _RecipientKeyIdentifier_date = TIME_GEN(name=u'date', mode=MODE_TYPE, opt=True)
    _RecipientKeyIdentifier_other = SEQ(name=u'other', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'OtherKeyAttribute')), opt=True)
    RecipientKeyIdentifier._cont = ASN1Dict([
        (u'subjectKeyIdentifier', _RecipientKeyIdentifier_subjectKeyIdentifier),
        (u'date', _RecipientKeyIdentifier_date),
        (u'other', _RecipientKeyIdentifier_other),
        ])
    RecipientKeyIdentifier._ext = None
    
    #-----< SubjectKeyIdentifier >-----#
    SubjectKeyIdentifier = OCT_STR(name=u'SubjectKeyIdentifier', mode=MODE_TYPE)
    
    #-----< KEKRecipientInfo >-----#
    KEKRecipientInfo = SEQ(name=u'KEKRecipientInfo', mode=MODE_TYPE)
    _KEKRecipientInfo_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'CMSVersion')))
    _KEKRecipientInfo_kekid = SEQ(name=u'kekid', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'KEKIdentifier')))
    _KEKRecipientInfo_keyEncryptionAlgorithm = SEQ(name=u'keyEncryptionAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'KeyEncryptionAlgorithmIdentifier')))
    _KEKRecipientInfo_encryptedKey = OCT_STR(name=u'encryptedKey', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'EncryptedKey')))
    KEKRecipientInfo._cont = ASN1Dict([
        (u'version', _KEKRecipientInfo_version),
        (u'kekid', _KEKRecipientInfo_kekid),
        (u'keyEncryptionAlgorithm', _KEKRecipientInfo_keyEncryptionAlgorithm),
        (u'encryptedKey', _KEKRecipientInfo_encryptedKey),
        ])
    KEKRecipientInfo._ext = None
    
    #-----< KEKIdentifier >-----#
    KEKIdentifier = SEQ(name=u'KEKIdentifier', mode=MODE_TYPE)
    _KEKIdentifier_keyIdentifier = OCT_STR(name=u'keyIdentifier', mode=MODE_TYPE)
    _KEKIdentifier_date = TIME_GEN(name=u'date', mode=MODE_TYPE, opt=True)
    _KEKIdentifier_other = SEQ(name=u'other', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'OtherKeyAttribute')), opt=True)
    KEKIdentifier._cont = ASN1Dict([
        (u'keyIdentifier', _KEKIdentifier_keyIdentifier),
        (u'date', _KEKIdentifier_date),
        (u'other', _KEKIdentifier_other),
        ])
    KEKIdentifier._ext = None
    
    #-----< PasswordRecipientInfo >-----#
    PasswordRecipientInfo = SEQ(name=u'PasswordRecipientInfo', mode=MODE_TYPE)
    _PasswordRecipientInfo_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'CMSVersion')))
    _PasswordRecipientInfo_keyDerivationAlgorithm = SEQ(name=u'keyDerivationAlgorithm', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'KeyDerivationAlgorithmIdentifier')), opt=True)
    _PasswordRecipientInfo_keyEncryptionAlgorithm = SEQ(name=u'keyEncryptionAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'KeyEncryptionAlgorithmIdentifier')))
    _PasswordRecipientInfo_encryptedKey = OCT_STR(name=u'encryptedKey', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'EncryptedKey')))
    PasswordRecipientInfo._cont = ASN1Dict([
        (u'version', _PasswordRecipientInfo_version),
        (u'keyDerivationAlgorithm', _PasswordRecipientInfo_keyDerivationAlgorithm),
        (u'keyEncryptionAlgorithm', _PasswordRecipientInfo_keyEncryptionAlgorithm),
        (u'encryptedKey', _PasswordRecipientInfo_encryptedKey),
        ])
    PasswordRecipientInfo._ext = None
    
    #-----< OtherRecipientInfo >-----#
    OtherRecipientInfo = SEQ(name=u'OtherRecipientInfo', mode=MODE_TYPE)
    _OtherRecipientInfo_oriType = OID(name=u'oriType', mode=MODE_TYPE)
    _OtherRecipientInfo_oriValue = ANY(name=u'oriValue', mode=MODE_TYPE, defby=u'oriType')
    OtherRecipientInfo._cont = ASN1Dict([
        (u'oriType', _OtherRecipientInfo_oriType),
        (u'oriValue', _OtherRecipientInfo_oriValue),
        ])
    OtherRecipientInfo._ext = None
    
    #-----< DigestedData >-----#
    DigestedData = SEQ(name=u'DigestedData', mode=MODE_TYPE)
    _DigestedData_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'CMSVersion')))
    _DigestedData_digestAlgorithm = SEQ(name=u'digestAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'DigestAlgorithmIdentifier')))
    _DigestedData_encapContentInfo = SEQ(name=u'encapContentInfo', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'EncapsulatedContentInfo')))
    _DigestedData_digest = OCT_STR(name=u'digest', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'Digest')))
    DigestedData._cont = ASN1Dict([
        (u'version', _DigestedData_version),
        (u'digestAlgorithm', _DigestedData_digestAlgorithm),
        (u'encapContentInfo', _DigestedData_encapContentInfo),
        (u'digest', _DigestedData_digest),
        ])
    DigestedData._ext = None
    
    #-----< Digest >-----#
    Digest = OCT_STR(name=u'Digest', mode=MODE_TYPE)
    
    #-----< EncryptedData >-----#
    EncryptedData = SEQ(name=u'EncryptedData', mode=MODE_TYPE)
    _EncryptedData_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'CMSVersion')))
    _EncryptedData_encryptedContentInfo = SEQ(name=u'encryptedContentInfo', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'EncryptedContentInfo')))
    _EncryptedData_unprotectedAttrs = SET_OF(name=u'unprotectedAttrs', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'UnprotectedAttributes')), opt=True)
    EncryptedData._cont = ASN1Dict([
        (u'version', _EncryptedData_version),
        (u'encryptedContentInfo', _EncryptedData_encryptedContentInfo),
        (u'unprotectedAttrs', _EncryptedData_unprotectedAttrs),
        ])
    EncryptedData._ext = None
    
    #-----< AuthenticatedData >-----#
    AuthenticatedData = SEQ(name=u'AuthenticatedData', mode=MODE_TYPE)
    _AuthenticatedData_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'CMSVersion')))
    _AuthenticatedData_originatorInfo = SEQ(name=u'originatorInfo', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'OriginatorInfo')), opt=True)
    _AuthenticatedData_recipientInfos = SET_OF(name=u'recipientInfos', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'RecipientInfos')))
    _AuthenticatedData_macAlgorithm = SEQ(name=u'macAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'MessageAuthenticationCodeAlgorithm')))
    _AuthenticatedData_digestAlgorithm = SEQ(name=u'digestAlgorithm', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'DigestAlgorithmIdentifier')), opt=True)
    _AuthenticatedData_encapContentInfo = SEQ(name=u'encapContentInfo', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'EncapsulatedContentInfo')))
    _AuthenticatedData_authAttrs = SET_OF(name=u'authAttrs', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'AuthAttributes')), opt=True)
    _AuthenticatedData_mac = OCT_STR(name=u'mac', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'MessageAuthenticationCode')))
    _AuthenticatedData_unauthAttrs = SET_OF(name=u'unauthAttrs', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'UnauthAttributes')), opt=True)
    AuthenticatedData._cont = ASN1Dict([
        (u'version', _AuthenticatedData_version),
        (u'originatorInfo', _AuthenticatedData_originatorInfo),
        (u'recipientInfos', _AuthenticatedData_recipientInfos),
        (u'macAlgorithm', _AuthenticatedData_macAlgorithm),
        (u'digestAlgorithm', _AuthenticatedData_digestAlgorithm),
        (u'encapContentInfo', _AuthenticatedData_encapContentInfo),
        (u'authAttrs', _AuthenticatedData_authAttrs),
        (u'mac', _AuthenticatedData_mac),
        (u'unauthAttrs', _AuthenticatedData_unauthAttrs),
        ])
    AuthenticatedData._ext = None
    
    #-----< AuthAttributes >-----#
    AuthAttributes = SET_OF(name=u'AuthAttributes', mode=MODE_TYPE)
    _AuthAttributes__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'Attribute')))
    AuthAttributes._cont = _AuthAttributes__item_
    AuthAttributes._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< UnauthAttributes >-----#
    UnauthAttributes = SET_OF(name=u'UnauthAttributes', mode=MODE_TYPE)
    _UnauthAttributes__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'Attribute')))
    UnauthAttributes._cont = _UnauthAttributes__item_
    UnauthAttributes._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< MessageAuthenticationCode >-----#
    MessageAuthenticationCode = OCT_STR(name=u'MessageAuthenticationCode', mode=MODE_TYPE)
    
    #-----< DigestAlgorithmIdentifier >-----#
    DigestAlgorithmIdentifier = SEQ(name=u'DigestAlgorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'AlgorithmIdentifier')))
    
    #-----< SignatureAlgorithmIdentifier >-----#
    SignatureAlgorithmIdentifier = SEQ(name=u'SignatureAlgorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'AlgorithmIdentifier')))
    
    #-----< KeyEncryptionAlgorithmIdentifier >-----#
    KeyEncryptionAlgorithmIdentifier = SEQ(name=u'KeyEncryptionAlgorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'AlgorithmIdentifier')))
    
    #-----< ContentEncryptionAlgorithmIdentifier >-----#
    ContentEncryptionAlgorithmIdentifier = SEQ(name=u'ContentEncryptionAlgorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'AlgorithmIdentifier')))
    
    #-----< MessageAuthenticationCodeAlgorithm >-----#
    MessageAuthenticationCodeAlgorithm = SEQ(name=u'MessageAuthenticationCodeAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'AlgorithmIdentifier')))
    
    #-----< KeyDerivationAlgorithmIdentifier >-----#
    KeyDerivationAlgorithmIdentifier = SEQ(name=u'KeyDerivationAlgorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'AlgorithmIdentifier')))
    
    #-----< RevocationInfoChoices >-----#
    RevocationInfoChoices = SET_OF(name=u'RevocationInfoChoices', mode=MODE_TYPE)
    _RevocationInfoChoices__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'RevocationInfoChoice')))
    RevocationInfoChoices._cont = _RevocationInfoChoices__item_
    
    #-----< RevocationInfoChoice >-----#
    RevocationInfoChoice = CHOICE(name=u'RevocationInfoChoice', mode=MODE_TYPE)
    _RevocationInfoChoice_crl = SEQ(name=u'crl', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'CertificateList')))
    _RevocationInfoChoice_other = SEQ(name=u'other', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'OtherRevocationInfoFormat')))
    RevocationInfoChoice._cont = ASN1Dict([
        (u'crl', _RevocationInfoChoice_crl),
        (u'other', _RevocationInfoChoice_other),
        ])
    RevocationInfoChoice._ext = None
    
    #-----< OtherRevocationInfoFormat >-----#
    OtherRevocationInfoFormat = SEQ(name=u'OtherRevocationInfoFormat', mode=MODE_TYPE)
    _OtherRevocationInfoFormat_otherRevInfoFormat = OID(name=u'otherRevInfoFormat', mode=MODE_TYPE)
    _OtherRevocationInfoFormat_otherRevInfo = ANY(name=u'otherRevInfo', mode=MODE_TYPE, defby=u'otherRevInfoFormat')
    OtherRevocationInfoFormat._cont = ASN1Dict([
        (u'otherRevInfoFormat', _OtherRevocationInfoFormat_otherRevInfoFormat),
        (u'otherRevInfo', _OtherRevocationInfoFormat_otherRevInfo),
        ])
    OtherRevocationInfoFormat._ext = None
    
    #-----< CertificateChoices >-----#
    CertificateChoices = CHOICE(name=u'CertificateChoices', mode=MODE_TYPE)
    _CertificateChoices_certificate = SEQ(name=u'certificate', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'Certificate')))
    _CertificateChoices_extendedCertificate = SEQ(name=u'extendedCertificate', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'ExtendedCertificate')))
    _CertificateChoices_v1AttrCert = SEQ(name=u'v1AttrCert', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AttributeCertificateVersion1', 'AttributeCertificateV1')))
    _CertificateChoices_v2AttrCert = SEQ(name=u'v2AttrCert', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'AttributeCertificateV2')))
    _CertificateChoices_other = SEQ(name=u'other', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'OtherCertificateFormat')))
    CertificateChoices._cont = ASN1Dict([
        (u'certificate', _CertificateChoices_certificate),
        (u'extendedCertificate', _CertificateChoices_extendedCertificate),
        (u'v1AttrCert', _CertificateChoices_v1AttrCert),
        (u'v2AttrCert', _CertificateChoices_v2AttrCert),
        (u'other', _CertificateChoices_other),
        ])
    CertificateChoices._ext = None
    
    #-----< AttributeCertificateV2 >-----#
    AttributeCertificateV2 = SEQ(name=u'AttributeCertificateV2', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate', 'AttributeCertificate')))
    
    #-----< OtherCertificateFormat >-----#
    OtherCertificateFormat = SEQ(name=u'OtherCertificateFormat', mode=MODE_TYPE)
    _OtherCertificateFormat_otherCertFormat = OID(name=u'otherCertFormat', mode=MODE_TYPE)
    _OtherCertificateFormat_otherCert = ANY(name=u'otherCert', mode=MODE_TYPE, defby=u'otherCertFormat')
    OtherCertificateFormat._cont = ASN1Dict([
        (u'otherCertFormat', _OtherCertificateFormat_otherCertFormat),
        (u'otherCert', _OtherCertificateFormat_otherCert),
        ])
    OtherCertificateFormat._ext = None
    
    #-----< CertificateSet >-----#
    CertificateSet = SET_OF(name=u'CertificateSet', mode=MODE_TYPE)
    _CertificateSet__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'CertificateChoices')))
    CertificateSet._cont = _CertificateSet__item_
    
    #-----< IssuerAndSerialNumber >-----#
    IssuerAndSerialNumber = SEQ(name=u'IssuerAndSerialNumber', mode=MODE_TYPE)
    _IssuerAndSerialNumber_issuer = CHOICE(name=u'issuer', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'Name')))
    _IssuerAndSerialNumber_serialNumber = INT(name=u'serialNumber', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'CertificateSerialNumber')))
    IssuerAndSerialNumber._cont = ASN1Dict([
        (u'issuer', _IssuerAndSerialNumber_issuer),
        (u'serialNumber', _IssuerAndSerialNumber_serialNumber),
        ])
    IssuerAndSerialNumber._ext = None
    
    #-----< CMSVersion >-----#
    CMSVersion = INT(name=u'CMSVersion', mode=MODE_TYPE)
    CMSVersion._cont = ASN1Dict([(u'v0', 0), (u'v1', 1), (u'v2', 2), (u'v3', 3), (u'v4', 4), (u'v5', 5)])
    
    #-----< UserKeyingMaterial >-----#
    UserKeyingMaterial = OCT_STR(name=u'UserKeyingMaterial', mode=MODE_TYPE)
    
    #-----< OtherKeyAttribute >-----#
    OtherKeyAttribute = SEQ(name=u'OtherKeyAttribute', mode=MODE_TYPE)
    _OtherKeyAttribute_keyAttrId = OID(name=u'keyAttrId', mode=MODE_TYPE)
    _OtherKeyAttribute_keyAttr = ANY(name=u'keyAttr', mode=MODE_TYPE, opt=True, defby=u'keyAttrId')
    OtherKeyAttribute._cont = ASN1Dict([
        (u'keyAttrId', _OtherKeyAttribute_keyAttrId),
        (u'keyAttr', _OtherKeyAttribute_keyAttr),
        ])
    OtherKeyAttribute._ext = None
    
    #-----< id-ct-contentInfo >-----#
    id_ct_contentInfo = OID(name=u'id-ct-contentInfo', mode=MODE_VALUE)
    id_ct_contentInfo._val = (1, 2, 840, 113549, 1, 9, 16, 1, 6)
    
    #-----< id-data >-----#
    id_data = OID(name=u'id-data', mode=MODE_VALUE)
    id_data._val = (1, 2, 840, 113549, 1, 7, 1)
    
    #-----< id-signedData >-----#
    id_signedData = OID(name=u'id-signedData', mode=MODE_VALUE)
    id_signedData._val = (1, 2, 840, 113549, 1, 7, 2)
    
    #-----< id-envelopedData >-----#
    id_envelopedData = OID(name=u'id-envelopedData', mode=MODE_VALUE)
    id_envelopedData._val = (1, 2, 840, 113549, 1, 7, 3)
    
    #-----< id-digestedData >-----#
    id_digestedData = OID(name=u'id-digestedData', mode=MODE_VALUE)
    id_digestedData._val = (1, 2, 840, 113549, 1, 7, 5)
    
    #-----< id-encryptedData >-----#
    id_encryptedData = OID(name=u'id-encryptedData', mode=MODE_VALUE)
    id_encryptedData._val = (1, 2, 840, 113549, 1, 7, 6)
    
    #-----< id-ct-authData >-----#
    id_ct_authData = OID(name=u'id-ct-authData', mode=MODE_VALUE)
    id_ct_authData._val = (1, 2, 840, 113549, 1, 9, 16, 1, 2)
    
    #-----< MessageDigest >-----#
    MessageDigest = OCT_STR(name=u'MessageDigest', mode=MODE_TYPE)
    
    #-----< SigningTime >-----#
    SigningTime = CHOICE(name=u'SigningTime', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'Time')))
    
    #-----< Time >-----#
    Time = CHOICE(name=u'Time', mode=MODE_TYPE)
    _Time_utcTime = TIME_UTC(name=u'utcTime', mode=MODE_TYPE)
    _Time_generalTime = TIME_GEN(name=u'generalTime', mode=MODE_TYPE)
    Time._cont = ASN1Dict([
        (u'utcTime', _Time_utcTime),
        (u'generalTime', _Time_generalTime),
        ])
    Time._ext = None
    
    #-----< Countersignature >-----#
    Countersignature = SEQ(name=u'Countersignature', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'SignerInfo')))
    
    #-----< id-contentType >-----#
    id_contentType = OID(name=u'id-contentType', mode=MODE_VALUE)
    id_contentType._val = (1, 2, 840, 113549, 1, 9, 3)
    
    #-----< id-messageDigest >-----#
    id_messageDigest = OID(name=u'id-messageDigest', mode=MODE_VALUE)
    id_messageDigest._val = (1, 2, 840, 113549, 1, 9, 4)
    
    #-----< id-signingTime >-----#
    id_signingTime = OID(name=u'id-signingTime', mode=MODE_VALUE)
    id_signingTime._val = (1, 2, 840, 113549, 1, 9, 5)
    
    #-----< id-countersignature >-----#
    id_countersignature = OID(name=u'id-countersignature', mode=MODE_VALUE)
    id_countersignature._val = (1, 2, 840, 113549, 1, 9, 6)
    
    #-----< ExtendedCertificateOrCertificate >-----#
    ExtendedCertificateOrCertificate = CHOICE(name=u'ExtendedCertificateOrCertificate', mode=MODE_TYPE)
    _ExtendedCertificateOrCertificate_certificate = SEQ(name=u'certificate', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'Certificate')))
    _ExtendedCertificateOrCertificate_extendedCertificate = SEQ(name=u'extendedCertificate', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'ExtendedCertificate')))
    ExtendedCertificateOrCertificate._cont = ASN1Dict([
        (u'certificate', _ExtendedCertificateOrCertificate_certificate),
        (u'extendedCertificate', _ExtendedCertificateOrCertificate_extendedCertificate),
        ])
    ExtendedCertificateOrCertificate._ext = None
    
    #-----< ExtendedCertificate >-----#
    ExtendedCertificate = SEQ(name=u'ExtendedCertificate', mode=MODE_TYPE)
    _ExtendedCertificate_extendedCertificateInfo = SEQ(name=u'extendedCertificateInfo', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'ExtendedCertificateInfo')))
    _ExtendedCertificate_signatureAlgorithm = SEQ(name=u'signatureAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'SignatureAlgorithmIdentifier')))
    _ExtendedCertificate_signature = BIT_STR(name=u'signature', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'Signature')))
    ExtendedCertificate._cont = ASN1Dict([
        (u'extendedCertificateInfo', _ExtendedCertificate_extendedCertificateInfo),
        (u'signatureAlgorithm', _ExtendedCertificate_signatureAlgorithm),
        (u'signature', _ExtendedCertificate_signature),
        ])
    ExtendedCertificate._ext = None
    
    #-----< ExtendedCertificateInfo >-----#
    ExtendedCertificateInfo = SEQ(name=u'ExtendedCertificateInfo', mode=MODE_TYPE)
    _ExtendedCertificateInfo_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'CMSVersion')))
    _ExtendedCertificateInfo_certificate = SEQ(name=u'certificate', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit88', 'Certificate')))
    _ExtendedCertificateInfo_attributes = SET_OF(name=u'attributes', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'UnauthAttributes')))
    ExtendedCertificateInfo._cont = ASN1Dict([
        (u'version', _ExtendedCertificateInfo_version),
        (u'certificate', _ExtendedCertificateInfo_certificate),
        (u'attributes', _ExtendedCertificateInfo_attributes),
        ])
    ExtendedCertificateInfo._ext = None
    
    #-----< Signature >-----#
    Signature = BIT_STR(name=u'Signature', mode=MODE_TYPE)
    
    _all_ = [
        _ContentInfo_contentType,
        _ContentInfo_content,
        ContentInfo,
        ContentType,
        _SignedData_version,
        _SignedData_digestAlgorithms,
        _SignedData_encapContentInfo,
        _SignedData_certificates,
        _SignedData_crls,
        _SignedData_signerInfos,
        SignedData,
        _DigestAlgorithmIdentifiers__item_,
        DigestAlgorithmIdentifiers,
        _SignerInfos__item_,
        SignerInfos,
        _EncapsulatedContentInfo_eContentType,
        _EncapsulatedContentInfo_eContent,
        EncapsulatedContentInfo,
        _SignerInfo_version,
        _SignerInfo_sid,
        _SignerInfo_digestAlgorithm,
        _SignerInfo_signedAttrs,
        _SignerInfo_signatureAlgorithm,
        _SignerInfo_signature,
        _SignerInfo_unsignedAttrs,
        SignerInfo,
        _SignerIdentifier_issuerAndSerialNumber,
        _SignerIdentifier_subjectKeyIdentifier,
        SignerIdentifier,
        _SignedAttributes__item_,
        SignedAttributes,
        _UnsignedAttributes__item_,
        UnsignedAttributes,
        _Attribute_attrType,
        __Attribute_attrValues__item_,
        _Attribute_attrValues,
        Attribute,
        AttributeValue,
        SignatureValue,
        _EnvelopedData_version,
        _EnvelopedData_originatorInfo,
        _EnvelopedData_recipientInfos,
        _EnvelopedData_encryptedContentInfo,
        _EnvelopedData_unprotectedAttrs,
        EnvelopedData,
        _OriginatorInfo_certs,
        _OriginatorInfo_crls,
        OriginatorInfo,
        _RecipientInfos__item_,
        RecipientInfos,
        _EncryptedContentInfo_contentType,
        _EncryptedContentInfo_contentEncryptionAlgorithm,
        _EncryptedContentInfo_encryptedContent,
        EncryptedContentInfo,
        EncryptedContent,
        _UnprotectedAttributes__item_,
        UnprotectedAttributes,
        _RecipientInfo_ktri,
        _RecipientInfo_kari,
        _RecipientInfo_kekri,
        _RecipientInfo_pwri,
        _RecipientInfo_ori,
        RecipientInfo,
        EncryptedKey,
        _KeyTransRecipientInfo_version,
        _KeyTransRecipientInfo_rid,
        _KeyTransRecipientInfo_keyEncryptionAlgorithm,
        _KeyTransRecipientInfo_encryptedKey,
        KeyTransRecipientInfo,
        _RecipientIdentifier_issuerAndSerialNumber,
        _RecipientIdentifier_subjectKeyIdentifier,
        RecipientIdentifier,
        _KeyAgreeRecipientInfo_version,
        _KeyAgreeRecipientInfo_originator,
        _KeyAgreeRecipientInfo_ukm,
        _KeyAgreeRecipientInfo_keyEncryptionAlgorithm,
        _KeyAgreeRecipientInfo_recipientEncryptedKeys,
        KeyAgreeRecipientInfo,
        _OriginatorIdentifierOrKey_issuerAndSerialNumber,
        _OriginatorIdentifierOrKey_subjectKeyIdentifier,
        _OriginatorIdentifierOrKey_originatorKey,
        OriginatorIdentifierOrKey,
        _OriginatorPublicKey_algorithm,
        _OriginatorPublicKey_publicKey,
        OriginatorPublicKey,
        _RecipientEncryptedKeys__item_,
        RecipientEncryptedKeys,
        _RecipientEncryptedKey_rid,
        _RecipientEncryptedKey_encryptedKey,
        RecipientEncryptedKey,
        _KeyAgreeRecipientIdentifier_issuerAndSerialNumber,
        _KeyAgreeRecipientIdentifier_rKeyId,
        KeyAgreeRecipientIdentifier,
        _RecipientKeyIdentifier_subjectKeyIdentifier,
        _RecipientKeyIdentifier_date,
        _RecipientKeyIdentifier_other,
        RecipientKeyIdentifier,
        SubjectKeyIdentifier,
        _KEKRecipientInfo_version,
        _KEKRecipientInfo_kekid,
        _KEKRecipientInfo_keyEncryptionAlgorithm,
        _KEKRecipientInfo_encryptedKey,
        KEKRecipientInfo,
        _KEKIdentifier_keyIdentifier,
        _KEKIdentifier_date,
        _KEKIdentifier_other,
        KEKIdentifier,
        _PasswordRecipientInfo_version,
        _PasswordRecipientInfo_keyDerivationAlgorithm,
        _PasswordRecipientInfo_keyEncryptionAlgorithm,
        _PasswordRecipientInfo_encryptedKey,
        PasswordRecipientInfo,
        _OtherRecipientInfo_oriType,
        _OtherRecipientInfo_oriValue,
        OtherRecipientInfo,
        _DigestedData_version,
        _DigestedData_digestAlgorithm,
        _DigestedData_encapContentInfo,
        _DigestedData_digest,
        DigestedData,
        Digest,
        _EncryptedData_version,
        _EncryptedData_encryptedContentInfo,
        _EncryptedData_unprotectedAttrs,
        EncryptedData,
        _AuthenticatedData_version,
        _AuthenticatedData_originatorInfo,
        _AuthenticatedData_recipientInfos,
        _AuthenticatedData_macAlgorithm,
        _AuthenticatedData_digestAlgorithm,
        _AuthenticatedData_encapContentInfo,
        _AuthenticatedData_authAttrs,
        _AuthenticatedData_mac,
        _AuthenticatedData_unauthAttrs,
        AuthenticatedData,
        _AuthAttributes__item_,
        AuthAttributes,
        _UnauthAttributes__item_,
        UnauthAttributes,
        MessageAuthenticationCode,
        DigestAlgorithmIdentifier,
        SignatureAlgorithmIdentifier,
        KeyEncryptionAlgorithmIdentifier,
        ContentEncryptionAlgorithmIdentifier,
        MessageAuthenticationCodeAlgorithm,
        KeyDerivationAlgorithmIdentifier,
        _RevocationInfoChoices__item_,
        RevocationInfoChoices,
        _RevocationInfoChoice_crl,
        _RevocationInfoChoice_other,
        RevocationInfoChoice,
        _OtherRevocationInfoFormat_otherRevInfoFormat,
        _OtherRevocationInfoFormat_otherRevInfo,
        OtherRevocationInfoFormat,
        _CertificateChoices_certificate,
        _CertificateChoices_extendedCertificate,
        _CertificateChoices_v1AttrCert,
        _CertificateChoices_v2AttrCert,
        _CertificateChoices_other,
        CertificateChoices,
        AttributeCertificateV2,
        _OtherCertificateFormat_otherCertFormat,
        _OtherCertificateFormat_otherCert,
        OtherCertificateFormat,
        _CertificateSet__item_,
        CertificateSet,
        _IssuerAndSerialNumber_issuer,
        _IssuerAndSerialNumber_serialNumber,
        IssuerAndSerialNumber,
        CMSVersion,
        UserKeyingMaterial,
        _OtherKeyAttribute_keyAttrId,
        _OtherKeyAttribute_keyAttr,
        OtherKeyAttribute,
        id_ct_contentInfo,
        id_data,
        id_signedData,
        id_envelopedData,
        id_digestedData,
        id_encryptedData,
        id_ct_authData,
        MessageDigest,
        SigningTime,
        _Time_utcTime,
        _Time_generalTime,
        Time,
        Countersignature,
        id_contentType,
        id_messageDigest,
        id_signingTime,
        id_countersignature,
        _ExtendedCertificateOrCertificate_certificate,
        _ExtendedCertificateOrCertificate_extendedCertificate,
        ExtendedCertificateOrCertificate,
        _ExtendedCertificate_extendedCertificateInfo,
        _ExtendedCertificate_signatureAlgorithm,
        _ExtendedCertificate_signature,
        ExtendedCertificate,
        _ExtendedCertificateInfo_version,
        _ExtendedCertificateInfo_certificate,
        _ExtendedCertificateInfo_attributes,
        ExtendedCertificateInfo,
        Signature,
    ]

class CMSFirmwareWrapper:

    _name_  = u'CMSFirmwareWrapper'
    _oid_   = [1, 2, 840, 113549, 1, 9, 16, 0, 22]
    
    _obj_ = [
        u'id-ct-firmwarePackage',
        u'FirmwarePkgData',
        u'id-aa-firmwarePackageID',
        u'FirmwarePackageIdentifier',
        u'PreferredOrLegacyPackageIdentifier',
        u'PreferredPackageIdentifier',
        u'PreferredOrLegacyStalePackageIdentifier',
        u'id-aa-targetHardwareIDs',
        u'TargetHardwareIdentifiers',
        u'id-aa-decryptKeyID',
        u'DecryptKeyIdentifier',
        u'id-aa-implCryptoAlgs',
        u'ImplementedCryptoAlgorithms',
        u'id-aa-implCompressAlgs',
        u'ImplementedCompressAlgorithms',
        u'id-aa-communityIdentifiers',
        u'CommunityIdentifiers',
        u'CommunityIdentifier',
        u'HardwareModules',
        u'HardwareSerialEntry',
        u'id-aa-firmwarePackageInfo',
        u'FirmwarePackageInfo',
        u'id-aa-wrappedFirmwareKey',
        u'WrappedFirmwareKey',
        u'id-ct-firmwareLoadReceipt',
        u'FirmwarePackageLoadReceipt',
        u'FWReceiptVersion',
        u'id-ct-firmwareLoadError',
        u'FirmwarePackageLoadError',
        u'FWErrorVersion',
        u'CurrentFWConfig',
        u'FirmwarePackageLoadErrorCode',
        u'VendorLoadErrorCode',
        u'id-on-hardwareModuleName',
        u'HardwareModuleName',
        ]
    _type_ = [
        u'FirmwarePkgData',
        u'FirmwarePackageIdentifier',
        u'PreferredOrLegacyPackageIdentifier',
        u'PreferredPackageIdentifier',
        u'PreferredOrLegacyStalePackageIdentifier',
        u'TargetHardwareIdentifiers',
        u'DecryptKeyIdentifier',
        u'ImplementedCryptoAlgorithms',
        u'ImplementedCompressAlgorithms',
        u'CommunityIdentifiers',
        u'CommunityIdentifier',
        u'HardwareModules',
        u'HardwareSerialEntry',
        u'FirmwarePackageInfo',
        u'WrappedFirmwareKey',
        u'FirmwarePackageLoadReceipt',
        u'FWReceiptVersion',
        u'FirmwarePackageLoadError',
        u'FWErrorVersion',
        u'CurrentFWConfig',
        u'FirmwarePackageLoadErrorCode',
        u'VendorLoadErrorCode',
        u'HardwareModuleName',
        ]
    _set_ = [
        ]
    _val_ = [
        u'id-ct-firmwarePackage',
        u'id-aa-firmwarePackageID',
        u'id-aa-targetHardwareIDs',
        u'id-aa-decryptKeyID',
        u'id-aa-implCryptoAlgs',
        u'id-aa-implCompressAlgs',
        u'id-aa-communityIdentifiers',
        u'id-aa-firmwarePackageInfo',
        u'id-aa-wrappedFirmwareKey',
        u'id-ct-firmwareLoadReceipt',
        u'id-ct-firmwareLoadError',
        u'id-on-hardwareModuleName',
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< id-ct-firmwarePackage >-----#
    id_ct_firmwarePackage = OID(name=u'id-ct-firmwarePackage', mode=MODE_VALUE)
    id_ct_firmwarePackage._val = (1, 2, 840, 113549, 1, 9, 16, 1, 16)
    
    #-----< FirmwarePkgData >-----#
    FirmwarePkgData = OCT_STR(name=u'FirmwarePkgData', mode=MODE_TYPE)
    
    #-----< id-aa-firmwarePackageID >-----#
    id_aa_firmwarePackageID = OID(name=u'id-aa-firmwarePackageID', mode=MODE_VALUE)
    id_aa_firmwarePackageID._val = (1, 2, 840, 113549, 1, 9, 16, 2, 35)
    
    #-----< FirmwarePackageIdentifier >-----#
    FirmwarePackageIdentifier = SEQ(name=u'FirmwarePackageIdentifier', mode=MODE_TYPE)
    _FirmwarePackageIdentifier_name = CHOICE(name=u'name', mode=MODE_TYPE, typeref=ASN1RefType(('CMSFirmwareWrapper', 'PreferredOrLegacyPackageIdentifier')))
    _FirmwarePackageIdentifier_stale = CHOICE(name=u'stale', mode=MODE_TYPE, typeref=ASN1RefType(('CMSFirmwareWrapper', 'PreferredOrLegacyStalePackageIdentifier')), opt=True)
    FirmwarePackageIdentifier._cont = ASN1Dict([
        (u'name', _FirmwarePackageIdentifier_name),
        (u'stale', _FirmwarePackageIdentifier_stale),
        ])
    FirmwarePackageIdentifier._ext = None
    
    #-----< PreferredOrLegacyPackageIdentifier >-----#
    PreferredOrLegacyPackageIdentifier = CHOICE(name=u'PreferredOrLegacyPackageIdentifier', mode=MODE_TYPE)
    _PreferredOrLegacyPackageIdentifier_preferred = SEQ(name=u'preferred', mode=MODE_TYPE, typeref=ASN1RefType(('CMSFirmwareWrapper', 'PreferredPackageIdentifier')))
    _PreferredOrLegacyPackageIdentifier_legacy = OCT_STR(name=u'legacy', mode=MODE_TYPE)
    PreferredOrLegacyPackageIdentifier._cont = ASN1Dict([
        (u'preferred', _PreferredOrLegacyPackageIdentifier_preferred),
        (u'legacy', _PreferredOrLegacyPackageIdentifier_legacy),
        ])
    PreferredOrLegacyPackageIdentifier._ext = None
    
    #-----< PreferredPackageIdentifier >-----#
    PreferredPackageIdentifier = SEQ(name=u'PreferredPackageIdentifier', mode=MODE_TYPE)
    _PreferredPackageIdentifier_fwPkgID = OID(name=u'fwPkgID', mode=MODE_TYPE)
    _PreferredPackageIdentifier_verNum = INT(name=u'verNum', mode=MODE_TYPE)
    _PreferredPackageIdentifier_verNum._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    PreferredPackageIdentifier._cont = ASN1Dict([
        (u'fwPkgID', _PreferredPackageIdentifier_fwPkgID),
        (u'verNum', _PreferredPackageIdentifier_verNum),
        ])
    PreferredPackageIdentifier._ext = None
    
    #-----< PreferredOrLegacyStalePackageIdentifier >-----#
    PreferredOrLegacyStalePackageIdentifier = CHOICE(name=u'PreferredOrLegacyStalePackageIdentifier', mode=MODE_TYPE)
    _PreferredOrLegacyStalePackageIdentifier_preferredStaleVerNum = INT(name=u'preferredStaleVerNum', mode=MODE_TYPE)
    _PreferredOrLegacyStalePackageIdentifier_preferredStaleVerNum._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    _PreferredOrLegacyStalePackageIdentifier_legacyStaleVersion = OCT_STR(name=u'legacyStaleVersion', mode=MODE_TYPE)
    PreferredOrLegacyStalePackageIdentifier._cont = ASN1Dict([
        (u'preferredStaleVerNum', _PreferredOrLegacyStalePackageIdentifier_preferredStaleVerNum),
        (u'legacyStaleVersion', _PreferredOrLegacyStalePackageIdentifier_legacyStaleVersion),
        ])
    PreferredOrLegacyStalePackageIdentifier._ext = None
    
    #-----< id-aa-targetHardwareIDs >-----#
    id_aa_targetHardwareIDs = OID(name=u'id-aa-targetHardwareIDs', mode=MODE_VALUE)
    id_aa_targetHardwareIDs._val = (1, 2, 840, 113549, 1, 9, 16, 2, 36)
    
    #-----< TargetHardwareIdentifiers >-----#
    TargetHardwareIdentifiers = SEQ_OF(name=u'TargetHardwareIdentifiers', mode=MODE_TYPE)
    _TargetHardwareIdentifiers__item_ = OID(name='_item_', mode=MODE_TYPE)
    TargetHardwareIdentifiers._cont = _TargetHardwareIdentifiers__item_
    
    #-----< id-aa-decryptKeyID >-----#
    id_aa_decryptKeyID = OID(name=u'id-aa-decryptKeyID', mode=MODE_VALUE)
    id_aa_decryptKeyID._val = (1, 2, 840, 113549, 1, 9, 16, 2, 37)
    
    #-----< DecryptKeyIdentifier >-----#
    DecryptKeyIdentifier = OCT_STR(name=u'DecryptKeyIdentifier', mode=MODE_TYPE)
    
    #-----< id-aa-implCryptoAlgs >-----#
    id_aa_implCryptoAlgs = OID(name=u'id-aa-implCryptoAlgs', mode=MODE_VALUE)
    id_aa_implCryptoAlgs._val = (1, 2, 840, 113549, 1, 9, 16, 2, 38)
    
    #-----< ImplementedCryptoAlgorithms >-----#
    ImplementedCryptoAlgorithms = SEQ_OF(name=u'ImplementedCryptoAlgorithms', mode=MODE_TYPE)
    _ImplementedCryptoAlgorithms__item_ = OID(name='_item_', mode=MODE_TYPE)
    ImplementedCryptoAlgorithms._cont = _ImplementedCryptoAlgorithms__item_
    
    #-----< id-aa-implCompressAlgs >-----#
    id_aa_implCompressAlgs = OID(name=u'id-aa-implCompressAlgs', mode=MODE_VALUE)
    id_aa_implCompressAlgs._val = (1, 2, 840, 113549, 1, 9, 16, 2, 43)
    
    #-----< ImplementedCompressAlgorithms >-----#
    ImplementedCompressAlgorithms = SEQ_OF(name=u'ImplementedCompressAlgorithms', mode=MODE_TYPE)
    _ImplementedCompressAlgorithms__item_ = OID(name='_item_', mode=MODE_TYPE)
    ImplementedCompressAlgorithms._cont = _ImplementedCompressAlgorithms__item_
    
    #-----< id-aa-communityIdentifiers >-----#
    id_aa_communityIdentifiers = OID(name=u'id-aa-communityIdentifiers', mode=MODE_VALUE)
    id_aa_communityIdentifiers._val = (1, 2, 840, 113549, 1, 9, 16, 2, 40)
    
    #-----< CommunityIdentifiers >-----#
    CommunityIdentifiers = SEQ_OF(name=u'CommunityIdentifiers', mode=MODE_TYPE)
    _CommunityIdentifiers__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CMSFirmwareWrapper', 'CommunityIdentifier')))
    CommunityIdentifiers._cont = _CommunityIdentifiers__item_
    
    #-----< CommunityIdentifier >-----#
    CommunityIdentifier = CHOICE(name=u'CommunityIdentifier', mode=MODE_TYPE)
    _CommunityIdentifier_communityOID = OID(name=u'communityOID', mode=MODE_TYPE)
    _CommunityIdentifier_hwModuleList = SEQ(name=u'hwModuleList', mode=MODE_TYPE, typeref=ASN1RefType(('CMSFirmwareWrapper', 'HardwareModules')))
    CommunityIdentifier._cont = ASN1Dict([
        (u'communityOID', _CommunityIdentifier_communityOID),
        (u'hwModuleList', _CommunityIdentifier_hwModuleList),
        ])
    CommunityIdentifier._ext = None
    
    #-----< HardwareModules >-----#
    HardwareModules = SEQ(name=u'HardwareModules', mode=MODE_TYPE)
    _HardwareModules_hwType = OID(name=u'hwType', mode=MODE_TYPE)
    _HardwareModules_hwSerialEntries = SEQ_OF(name=u'hwSerialEntries', mode=MODE_TYPE)
    __HardwareModules_hwSerialEntries__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CMSFirmwareWrapper', 'HardwareSerialEntry')))
    _HardwareModules_hwSerialEntries._cont = __HardwareModules_hwSerialEntries__item_
    HardwareModules._cont = ASN1Dict([
        (u'hwType', _HardwareModules_hwType),
        (u'hwSerialEntries', _HardwareModules_hwSerialEntries),
        ])
    HardwareModules._ext = None
    
    #-----< HardwareSerialEntry >-----#
    HardwareSerialEntry = CHOICE(name=u'HardwareSerialEntry', mode=MODE_TYPE)
    _HardwareSerialEntry_all = NULL(name=u'all', mode=MODE_TYPE)
    _HardwareSerialEntry_single = OCT_STR(name=u'single', mode=MODE_TYPE)
    _HardwareSerialEntry_block = SEQ(name=u'block', mode=MODE_TYPE)
    __HardwareSerialEntry_block_low = OCT_STR(name=u'low', mode=MODE_TYPE)
    __HardwareSerialEntry_block_high = OCT_STR(name=u'high', mode=MODE_TYPE)
    _HardwareSerialEntry_block._cont = ASN1Dict([
        (u'low', __HardwareSerialEntry_block_low),
        (u'high', __HardwareSerialEntry_block_high),
        ])
    _HardwareSerialEntry_block._ext = None
    HardwareSerialEntry._cont = ASN1Dict([
        (u'all', _HardwareSerialEntry_all),
        (u'single', _HardwareSerialEntry_single),
        (u'block', _HardwareSerialEntry_block),
        ])
    HardwareSerialEntry._ext = None
    
    #-----< id-aa-firmwarePackageInfo >-----#
    id_aa_firmwarePackageInfo = OID(name=u'id-aa-firmwarePackageInfo', mode=MODE_VALUE)
    id_aa_firmwarePackageInfo._val = (1, 2, 840, 113549, 1, 9, 16, 2, 42)
    
    #-----< FirmwarePackageInfo >-----#
    FirmwarePackageInfo = SEQ(name=u'FirmwarePackageInfo', mode=MODE_TYPE)
    _FirmwarePackageInfo_fwPkgType = INT(name=u'fwPkgType', mode=MODE_TYPE, opt=True)
    _FirmwarePackageInfo_dependencies = SEQ_OF(name=u'dependencies', mode=MODE_TYPE, opt=True)
    __FirmwarePackageInfo_dependencies__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CMSFirmwareWrapper', 'PreferredOrLegacyPackageIdentifier')))
    _FirmwarePackageInfo_dependencies._cont = __FirmwarePackageInfo_dependencies__item_
    FirmwarePackageInfo._cont = ASN1Dict([
        (u'fwPkgType', _FirmwarePackageInfo_fwPkgType),
        (u'dependencies', _FirmwarePackageInfo_dependencies),
        ])
    FirmwarePackageInfo._ext = None
    
    #-----< id-aa-wrappedFirmwareKey >-----#
    id_aa_wrappedFirmwareKey = OID(name=u'id-aa-wrappedFirmwareKey', mode=MODE_VALUE)
    id_aa_wrappedFirmwareKey._val = (1, 2, 840, 113549, 1, 9, 16, 2, 39)
    
    #-----< WrappedFirmwareKey >-----#
    WrappedFirmwareKey = SEQ(name=u'WrappedFirmwareKey', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax2004', 'EnvelopedData')))
    
    #-----< id-ct-firmwareLoadReceipt >-----#
    id_ct_firmwareLoadReceipt = OID(name=u'id-ct-firmwareLoadReceipt', mode=MODE_VALUE)
    id_ct_firmwareLoadReceipt._val = (1, 2, 840, 113549, 1, 9, 16, 1, 17)
    
    #-----< FirmwarePackageLoadReceipt >-----#
    FirmwarePackageLoadReceipt = SEQ(name=u'FirmwarePackageLoadReceipt', mode=MODE_TYPE)
    _FirmwarePackageLoadReceipt_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('CMSFirmwareWrapper', 'FWReceiptVersion')), default=1)
    _FirmwarePackageLoadReceipt_hwType = OID(name=u'hwType', mode=MODE_TYPE)
    _FirmwarePackageLoadReceipt_hwSerialNum = OCT_STR(name=u'hwSerialNum', mode=MODE_TYPE)
    _FirmwarePackageLoadReceipt_fwPkgName = CHOICE(name=u'fwPkgName', mode=MODE_TYPE, typeref=ASN1RefType(('CMSFirmwareWrapper', 'PreferredOrLegacyPackageIdentifier')))
    _FirmwarePackageLoadReceipt_trustAnchorKeyID = OCT_STR(name=u'trustAnchorKeyID', mode=MODE_TYPE, opt=True)
    _FirmwarePackageLoadReceipt_decryptKeyID = OCT_STR(name=u'decryptKeyID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    FirmwarePackageLoadReceipt._cont = ASN1Dict([
        (u'version', _FirmwarePackageLoadReceipt_version),
        (u'hwType', _FirmwarePackageLoadReceipt_hwType),
        (u'hwSerialNum', _FirmwarePackageLoadReceipt_hwSerialNum),
        (u'fwPkgName', _FirmwarePackageLoadReceipt_fwPkgName),
        (u'trustAnchorKeyID', _FirmwarePackageLoadReceipt_trustAnchorKeyID),
        (u'decryptKeyID', _FirmwarePackageLoadReceipt_decryptKeyID),
        ])
    FirmwarePackageLoadReceipt._ext = None
    
    #-----< FWReceiptVersion >-----#
    FWReceiptVersion = INT(name=u'FWReceiptVersion', mode=MODE_TYPE)
    FWReceiptVersion._cont = ASN1Dict([(u'v1', 1)])
    
    #-----< id-ct-firmwareLoadError >-----#
    id_ct_firmwareLoadError = OID(name=u'id-ct-firmwareLoadError', mode=MODE_VALUE)
    id_ct_firmwareLoadError._val = (1, 2, 840, 113549, 1, 9, 16, 1, 18)
    
    #-----< FirmwarePackageLoadError >-----#
    FirmwarePackageLoadError = SEQ(name=u'FirmwarePackageLoadError', mode=MODE_TYPE)
    _FirmwarePackageLoadError_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('CMSFirmwareWrapper', 'FWErrorVersion')), default=1)
    _FirmwarePackageLoadError_hwType = OID(name=u'hwType', mode=MODE_TYPE)
    _FirmwarePackageLoadError_hwSerialNum = OCT_STR(name=u'hwSerialNum', mode=MODE_TYPE)
    _FirmwarePackageLoadError_errorCode = ENUM(name=u'errorCode', mode=MODE_TYPE, typeref=ASN1RefType(('CMSFirmwareWrapper', 'FirmwarePackageLoadErrorCode')))
    _FirmwarePackageLoadError_vendorErrorCode = INT(name=u'vendorErrorCode', mode=MODE_TYPE, typeref=ASN1RefType(('CMSFirmwareWrapper', 'VendorLoadErrorCode')), opt=True)
    _FirmwarePackageLoadError_fwPkgName = CHOICE(name=u'fwPkgName', mode=MODE_TYPE, typeref=ASN1RefType(('CMSFirmwareWrapper', 'PreferredOrLegacyPackageIdentifier')), opt=True)
    _FirmwarePackageLoadError_config = SEQ_OF(name=u'config', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __FirmwarePackageLoadError_config__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CMSFirmwareWrapper', 'CurrentFWConfig')))
    _FirmwarePackageLoadError_config._cont = __FirmwarePackageLoadError_config__item_
    FirmwarePackageLoadError._cont = ASN1Dict([
        (u'version', _FirmwarePackageLoadError_version),
        (u'hwType', _FirmwarePackageLoadError_hwType),
        (u'hwSerialNum', _FirmwarePackageLoadError_hwSerialNum),
        (u'errorCode', _FirmwarePackageLoadError_errorCode),
        (u'vendorErrorCode', _FirmwarePackageLoadError_vendorErrorCode),
        (u'fwPkgName', _FirmwarePackageLoadError_fwPkgName),
        (u'config', _FirmwarePackageLoadError_config),
        ])
    FirmwarePackageLoadError._ext = None
    
    #-----< FWErrorVersion >-----#
    FWErrorVersion = INT(name=u'FWErrorVersion', mode=MODE_TYPE)
    FWErrorVersion._cont = ASN1Dict([(u'v1', 1)])
    
    #-----< CurrentFWConfig >-----#
    CurrentFWConfig = SEQ(name=u'CurrentFWConfig', mode=MODE_TYPE)
    _CurrentFWConfig_fwPkgType = INT(name=u'fwPkgType', mode=MODE_TYPE, opt=True)
    _CurrentFWConfig_fwPkgName = CHOICE(name=u'fwPkgName', mode=MODE_TYPE, typeref=ASN1RefType(('CMSFirmwareWrapper', 'PreferredOrLegacyPackageIdentifier')))
    CurrentFWConfig._cont = ASN1Dict([
        (u'fwPkgType', _CurrentFWConfig_fwPkgType),
        (u'fwPkgName', _CurrentFWConfig_fwPkgName),
        ])
    CurrentFWConfig._ext = None
    
    #-----< FirmwarePackageLoadErrorCode >-----#
    FirmwarePackageLoadErrorCode = ENUM(name=u'FirmwarePackageLoadErrorCode', mode=MODE_TYPE)
    FirmwarePackageLoadErrorCode._cont = ASN1Dict([(u'decodeFailure', 1), (u'badContentInfo', 2), (u'badSignedData', 3), (u'badEncapContent', 4), (u'badCertificate', 5), (u'badSignerInfo', 6), (u'badSignedAttrs', 7), (u'badUnsignedAttrs', 8), (u'missingContent', 9), (u'noTrustAnchor', 10), (u'notAuthorized', 11), (u'badDigestAlgorithm', 12), (u'badSignatureAlgorithm', 13), (u'unsupportedKeySize', 14), (u'signatureFailure', 15), (u'contentTypeMismatch', 16), (u'badEncryptedData', 17), (u'unprotectedAttrsPresent', 18), (u'badEncryptContent', 19), (u'badEncryptAlgorithm', 20), (u'missingCiphertext', 21), (u'noDecryptKey', 22), (u'decryptFailure', 23), (u'badCompressAlgorithm', 24), (u'missingCompressedContent', 25), (u'decompressFailure', 26), (u'wrongHardware', 27), (u'stalePackage', 28), (u'notInCommunity', 29), (u'unsupportedPackageType', 30), (u'missingDependency', 31), (u'wrongDependencyVersion', 32), (u'insufficientMemory', 33), (u'badFirmware', 34), (u'unsupportedParameters', 35), (u'breaksDependency', 36), (u'otherError', 99)])
    FirmwarePackageLoadErrorCode._ext = None
    
    #-----< VendorLoadErrorCode >-----#
    VendorLoadErrorCode = INT(name=u'VendorLoadErrorCode', mode=MODE_TYPE)
    
    #-----< id-on-hardwareModuleName >-----#
    id_on_hardwareModuleName = OID(name=u'id-on-hardwareModuleName', mode=MODE_VALUE)
    id_on_hardwareModuleName._val = (1, 3, 6, 1, 5, 5, 7, 8, 4)
    
    #-----< HardwareModuleName >-----#
    HardwareModuleName = SEQ(name=u'HardwareModuleName', mode=MODE_TYPE)
    _HardwareModuleName_hwType = OID(name=u'hwType', mode=MODE_TYPE)
    _HardwareModuleName_hwSerialNum = OCT_STR(name=u'hwSerialNum', mode=MODE_TYPE)
    HardwareModuleName._cont = ASN1Dict([
        (u'hwType', _HardwareModuleName_hwType),
        (u'hwSerialNum', _HardwareModuleName_hwSerialNum),
        ])
    HardwareModuleName._ext = None
    
    _all_ = [
        id_ct_firmwarePackage,
        FirmwarePkgData,
        id_aa_firmwarePackageID,
        _FirmwarePackageIdentifier_name,
        _FirmwarePackageIdentifier_stale,
        FirmwarePackageIdentifier,
        _PreferredOrLegacyPackageIdentifier_preferred,
        _PreferredOrLegacyPackageIdentifier_legacy,
        PreferredOrLegacyPackageIdentifier,
        _PreferredPackageIdentifier_fwPkgID,
        _PreferredPackageIdentifier_verNum,
        PreferredPackageIdentifier,
        _PreferredOrLegacyStalePackageIdentifier_preferredStaleVerNum,
        _PreferredOrLegacyStalePackageIdentifier_legacyStaleVersion,
        PreferredOrLegacyStalePackageIdentifier,
        id_aa_targetHardwareIDs,
        _TargetHardwareIdentifiers__item_,
        TargetHardwareIdentifiers,
        id_aa_decryptKeyID,
        DecryptKeyIdentifier,
        id_aa_implCryptoAlgs,
        _ImplementedCryptoAlgorithms__item_,
        ImplementedCryptoAlgorithms,
        id_aa_implCompressAlgs,
        _ImplementedCompressAlgorithms__item_,
        ImplementedCompressAlgorithms,
        id_aa_communityIdentifiers,
        _CommunityIdentifiers__item_,
        CommunityIdentifiers,
        _CommunityIdentifier_communityOID,
        _CommunityIdentifier_hwModuleList,
        CommunityIdentifier,
        _HardwareModules_hwType,
        __HardwareModules_hwSerialEntries__item_,
        _HardwareModules_hwSerialEntries,
        HardwareModules,
        _HardwareSerialEntry_all,
        _HardwareSerialEntry_single,
        __HardwareSerialEntry_block_low,
        __HardwareSerialEntry_block_high,
        _HardwareSerialEntry_block,
        HardwareSerialEntry,
        id_aa_firmwarePackageInfo,
        _FirmwarePackageInfo_fwPkgType,
        __FirmwarePackageInfo_dependencies__item_,
        _FirmwarePackageInfo_dependencies,
        FirmwarePackageInfo,
        id_aa_wrappedFirmwareKey,
        WrappedFirmwareKey,
        id_ct_firmwareLoadReceipt,
        _FirmwarePackageLoadReceipt_version,
        _FirmwarePackageLoadReceipt_hwType,
        _FirmwarePackageLoadReceipt_hwSerialNum,
        _FirmwarePackageLoadReceipt_fwPkgName,
        _FirmwarePackageLoadReceipt_trustAnchorKeyID,
        _FirmwarePackageLoadReceipt_decryptKeyID,
        FirmwarePackageLoadReceipt,
        FWReceiptVersion,
        id_ct_firmwareLoadError,
        _FirmwarePackageLoadError_version,
        _FirmwarePackageLoadError_hwType,
        _FirmwarePackageLoadError_hwSerialNum,
        _FirmwarePackageLoadError_errorCode,
        _FirmwarePackageLoadError_vendorErrorCode,
        _FirmwarePackageLoadError_fwPkgName,
        __FirmwarePackageLoadError_config__item_,
        _FirmwarePackageLoadError_config,
        FirmwarePackageLoadError,
        FWErrorVersion,
        _CurrentFWConfig_fwPkgType,
        _CurrentFWConfig_fwPkgName,
        CurrentFWConfig,
        FirmwarePackageLoadErrorCode,
        VendorLoadErrorCode,
        id_on_hardwareModuleName,
        _HardwareModuleName_hwType,
        _HardwareModuleName_hwSerialNum,
        HardwareModuleName,
    ]

init_modules(PKIX1Explicit88, PKIX1Implicit88, PKIXAttributeCertificate, AttributeCertificateVersion1, CryptographicMessageSyntax2004, CMSFirmwareWrapper)
