# -*- coding: UTF-8 -*-
# Code automatically generated by pycrate_asn1c

from pycrate_asn1rt.utils            import *
from pycrate_asn1rt.err              import *
from pycrate_asn1rt.glob             import make_GLOBAL, GLOBAL
from pycrate_asn1rt.dictobj          import ASN1Dict
from pycrate_asn1rt.refobj           import *
from pycrate_asn1rt.setobj           import *
from pycrate_asn1rt.asnobj_basic     import *
from pycrate_asn1rt.asnobj_str       import *
from pycrate_asn1rt.asnobj_construct import *
from pycrate_asn1rt.asnobj_class     import *
from pycrate_asn1rt.asnobj_ext       import *
from pycrate_asn1rt.init             import init_modules

class MULTIMEDIA_SYSTEM_CONTROL:

    _name_  = u'MULTIMEDIA-SYSTEM-CONTROL'
    _oid_   = [0, 0, 8, 245, 0, 16, 0]
    
    _obj_ = [
        u'MultimediaSystemControlMessage',
        u'RequestMessage',
        u'ResponseMessage',
        u'CommandMessage',
        u'IndicationMessage',
        u'SequenceNumber',
        u'GenericMessage',
        u'GenericInformation',
        u'NonStandardMessage',
        u'NonStandardParameter',
        u'NonStandardIdentifier',
        u'MasterSlaveDetermination',
        u'MasterSlaveDeterminationAck',
        u'MasterSlaveDeterminationReject',
        u'MasterSlaveDeterminationRelease',
        u'TerminalCapabilitySet',
        u'CapabilityTableEntry',
        u'CapabilityDescriptor',
        u'AlternativeCapabilitySet',
        u'CapabilityTableEntryNumber',
        u'CapabilityDescriptorNumber',
        u'TerminalCapabilitySetAck',
        u'TerminalCapabilitySetReject',
        u'TerminalCapabilitySetRelease',
        u'Capability',
        u'H235SecurityCapability',
        u'MultiplexCapability',
        u'H222Capability',
        u'VCCapability',
        u'H223Capability',
        u'H223AnnexCCapability',
        u'V76Capability',
        u'V75Capability',
        u'H2250Capability',
        u'MediaPacketizationCapability',
        u'RSVPParameters',
        u'QOSMode',
        u'ATMParameters',
        u'ServicePriorityValue',
        u'ServicePriority',
        u'AuthorizationParameters',
        u'QOSType',
        u'QOSClass',
        u'QOSDescriptor',
        u'GenericTransportParameters',
        u'QOSCapability',
        u'MediaTransportType',
        u'MediaChannelCapability',
        u'TransportCapability',
        u'RedundancyEncodingCapability',
        u'RedundancyEncodingMethod',
        u'RTPH263VideoRedundancyEncoding',
        u'RTPH263VideoRedundancyFrameMapping',
        u'MultipointCapability',
        u'MediaDistributionCapability',
        u'VideoCapability',
        u'ExtendedVideoCapability',
        u'H261VideoCapability',
        u'H262VideoCapability',
        u'H263VideoCapability',
        u'EnhancementLayerInfo',
        u'BEnhancementParameters',
        u'EnhancementOptions',
        u'H263Options',
        u'TransparencyParameters',
        u'RefPictureSelection',
        u'CustomPictureClockFrequency',
        u'CustomPictureFormat',
        u'H263VideoModeCombos',
        u'H263ModeComboFlags',
        u'H263Version3Options',
        u'IS11172VideoCapability',
        u'AudioCapability',
        u'G729Extensions',
        u'G7231AnnexCCapability',
        u'IS11172AudioCapability',
        u'IS13818AudioCapability',
        u'GSMAudioCapability',
        u'VBDCapability',
        u'DataApplicationCapability',
        u'DataProtocolCapability',
        u'CompressionType',
        u'V42bis',
        u'T84Profile',
        u'T38FaxProfile',
        u'T38FaxRateManagement',
        u'T38FaxUdpOptions',
        u'T38FaxTcpOptions',
        u'EncryptionAuthenticationAndIntegrity',
        u'EncryptionCapability',
        u'MediaEncryptionAlgorithm',
        u'AuthenticationCapability',
        u'IntegrityCapability',
        u'UserInputCapability',
        u'ConferenceCapability',
        u'GenericCapability',
        u'CapabilityIdentifier',
        u'GenericParameter',
        u'ParameterIdentifier',
        u'ParameterValue',
        u'MultiplexedStreamCapability',
        u'MultiplexFormat',
        u'AudioTelephonyEventCapability',
        u'AudioToneCapability',
        u'NoPTAudioTelephonyEventCapability',
        u'NoPTAudioToneCapability',
        u'MultiplePayloadStreamCapability',
        u'DepFECCapability',
        u'FECCapability',
        u'MaxRedundancy',
        u'OpenLogicalChannel',
        u'LogicalChannelNumber',
        u'NetworkAccessParameters',
        u'Q2931Address',
        u'V75Parameters',
        u'DataType',
        u'H235Media',
        u'MultiplexedStreamParameter',
        u'H222LogicalChannelParameters',
        u'H223LogicalChannelParameters',
        u'H223AL1MParameters',
        u'H223AL2MParameters',
        u'H223AL3MParameters',
        u'H223AnnexCArqParameters',
        u'V76LogicalChannelParameters',
        u'V76HDLCParameters',
        u'CRCLength',
        u'H2250LogicalChannelParameters',
        u'RTPPayloadType',
        u'RedundancyEncoding',
        u'RedundancyEncodingElement',
        u'MultiplePayloadStream',
        u'MultiplePayloadStreamElement',
        u'DepFECData',
        u'FECData',
        u'TransportAddress',
        u'UnicastAddress',
        u'MulticastAddress',
        u'EncryptionSync',
        u'EscrowData',
        u'OpenLogicalChannelAck',
        u'OpenLogicalChannelReject',
        u'OpenLogicalChannelConfirm',
        u'H2250LogicalChannelAckParameters',
        u'CloseLogicalChannel',
        u'CloseLogicalChannelAck',
        u'RequestChannelClose',
        u'RequestChannelCloseAck',
        u'RequestChannelCloseReject',
        u'RequestChannelCloseRelease',
        u'MultiplexEntrySend',
        u'MultiplexEntryDescriptor',
        u'MultiplexElement',
        u'MultiplexTableEntryNumber',
        u'MultiplexEntrySendAck',
        u'MultiplexEntrySendReject',
        u'MultiplexEntryRejectionDescriptions',
        u'MultiplexEntrySendRelease',
        u'RequestMultiplexEntry',
        u'RequestMultiplexEntryAck',
        u'RequestMultiplexEntryReject',
        u'RequestMultiplexEntryRejectionDescriptions',
        u'RequestMultiplexEntryRelease',
        u'RequestMode',
        u'RequestModeAck',
        u'RequestModeReject',
        u'RequestModeRelease',
        u'ModeDescription',
        u'ModeElementType',
        u'ModeElement',
        u'H235Mode',
        u'MultiplexedStreamModeParameters',
        u'RedundancyEncodingDTMode',
        u'RedundancyEncodingDTModeElement',
        u'MultiplePayloadStreamMode',
        u'MultiplePayloadStreamElementMode',
        u'DepFECMode',
        u'FECMode',
        u'H223ModeParameters',
        u'V76ModeParameters',
        u'H2250ModeParameters',
        u'RedundancyEncodingMode',
        u'VideoMode',
        u'H261VideoMode',
        u'H262VideoMode',
        u'H263VideoMode',
        u'IS11172VideoMode',
        u'AudioMode',
        u'IS11172AudioMode',
        u'IS13818AudioMode',
        u'G7231AnnexCMode',
        u'VBDMode',
        u'DataMode',
        u'EncryptionMode',
        u'RoundTripDelayRequest',
        u'RoundTripDelayResponse',
        u'MaintenanceLoopRequest',
        u'MaintenanceLoopAck',
        u'MaintenanceLoopReject',
        u'MaintenanceLoopOffCommand',
        u'CommunicationModeCommand',
        u'CommunicationModeRequest',
        u'CommunicationModeResponse',
        u'CommunicationModeTableEntry',
        u'ConferenceRequest',
        u'CertSelectionCriteria',
        u'Criteria',
        u'TerminalLabel',
        u'McuNumber',
        u'TerminalNumber',
        u'ConferenceResponse',
        u'TerminalID',
        u'ConferenceID',
        u'Password',
        u'RequestAllTerminalIDsResponse',
        u'TerminalInformation',
        u'RemoteMCRequest',
        u'RemoteMCResponse',
        u'MultilinkRequest',
        u'MultilinkResponse',
        u'MultilinkIndication',
        u'DialingInformation',
        u'DialingInformationNumber',
        u'DialingInformationNetworkType',
        u'ConnectionIdentifier',
        u'MaximumBitRate',
        u'LogicalChannelRateRequest',
        u'LogicalChannelRateAcknowledge',
        u'LogicalChannelRateReject',
        u'LogicalChannelRateRejectReason',
        u'LogicalChannelRateRelease',
        u'SendTerminalCapabilitySet',
        u'EncryptionCommand',
        u'FlowControlCommand',
        u'EndSessionCommand',
        u'ConferenceCommand',
        u'SubstituteConferenceIDCommand',
        u'EncryptionUpdateDirection',
        u'MiscellaneousCommand',
        u'KeyProtectionMethod',
        u'EncryptionUpdateRequest',
        u'PictureReference',
        u'H223MultiplexReconfiguration',
        u'NewATMVCCommand',
        u'MobileMultilinkReconfigurationCommand',
        u'FunctionNotUnderstood',
        u'FunctionNotSupported',
        u'ConferenceIndication',
        u'TerminalYouAreSeeingInSubPictureNumber',
        u'VideoIndicateCompose',
        u'MiscellaneousIndication',
        u'JitterIndication',
        u'H223SkewIndication',
        u'H2250MaximumSkewIndication',
        u'MCLocationIndication',
        u'VendorIdentification',
        u'NewATMVCIndication',
        u'IV8',
        u'IV16',
        u'Params',
        u'UserInputIndication',
        u'FlowControlIndication',
        u'MobileMultilinkReconfigurationIndication',
        ]
    _type_ = [
        u'MultimediaSystemControlMessage',
        u'RequestMessage',
        u'ResponseMessage',
        u'CommandMessage',
        u'IndicationMessage',
        u'SequenceNumber',
        u'GenericMessage',
        u'GenericInformation',
        u'NonStandardMessage',
        u'NonStandardParameter',
        u'NonStandardIdentifier',
        u'MasterSlaveDetermination',
        u'MasterSlaveDeterminationAck',
        u'MasterSlaveDeterminationReject',
        u'MasterSlaveDeterminationRelease',
        u'TerminalCapabilitySet',
        u'CapabilityTableEntry',
        u'CapabilityDescriptor',
        u'AlternativeCapabilitySet',
        u'CapabilityTableEntryNumber',
        u'CapabilityDescriptorNumber',
        u'TerminalCapabilitySetAck',
        u'TerminalCapabilitySetReject',
        u'TerminalCapabilitySetRelease',
        u'Capability',
        u'H235SecurityCapability',
        u'MultiplexCapability',
        u'H222Capability',
        u'VCCapability',
        u'H223Capability',
        u'H223AnnexCCapability',
        u'V76Capability',
        u'V75Capability',
        u'H2250Capability',
        u'MediaPacketizationCapability',
        u'RSVPParameters',
        u'QOSMode',
        u'ATMParameters',
        u'ServicePriorityValue',
        u'ServicePriority',
        u'AuthorizationParameters',
        u'QOSType',
        u'QOSClass',
        u'QOSDescriptor',
        u'GenericTransportParameters',
        u'QOSCapability',
        u'MediaTransportType',
        u'MediaChannelCapability',
        u'TransportCapability',
        u'RedundancyEncodingCapability',
        u'RedundancyEncodingMethod',
        u'RTPH263VideoRedundancyEncoding',
        u'RTPH263VideoRedundancyFrameMapping',
        u'MultipointCapability',
        u'MediaDistributionCapability',
        u'VideoCapability',
        u'ExtendedVideoCapability',
        u'H261VideoCapability',
        u'H262VideoCapability',
        u'H263VideoCapability',
        u'EnhancementLayerInfo',
        u'BEnhancementParameters',
        u'EnhancementOptions',
        u'H263Options',
        u'TransparencyParameters',
        u'RefPictureSelection',
        u'CustomPictureClockFrequency',
        u'CustomPictureFormat',
        u'H263VideoModeCombos',
        u'H263ModeComboFlags',
        u'H263Version3Options',
        u'IS11172VideoCapability',
        u'AudioCapability',
        u'G729Extensions',
        u'G7231AnnexCCapability',
        u'IS11172AudioCapability',
        u'IS13818AudioCapability',
        u'GSMAudioCapability',
        u'VBDCapability',
        u'DataApplicationCapability',
        u'DataProtocolCapability',
        u'CompressionType',
        u'V42bis',
        u'T84Profile',
        u'T38FaxProfile',
        u'T38FaxRateManagement',
        u'T38FaxUdpOptions',
        u'T38FaxTcpOptions',
        u'EncryptionAuthenticationAndIntegrity',
        u'EncryptionCapability',
        u'MediaEncryptionAlgorithm',
        u'AuthenticationCapability',
        u'IntegrityCapability',
        u'UserInputCapability',
        u'ConferenceCapability',
        u'GenericCapability',
        u'CapabilityIdentifier',
        u'GenericParameter',
        u'ParameterIdentifier',
        u'ParameterValue',
        u'MultiplexedStreamCapability',
        u'MultiplexFormat',
        u'AudioTelephonyEventCapability',
        u'AudioToneCapability',
        u'NoPTAudioTelephonyEventCapability',
        u'NoPTAudioToneCapability',
        u'MultiplePayloadStreamCapability',
        u'DepFECCapability',
        u'FECCapability',
        u'MaxRedundancy',
        u'OpenLogicalChannel',
        u'LogicalChannelNumber',
        u'NetworkAccessParameters',
        u'Q2931Address',
        u'V75Parameters',
        u'DataType',
        u'H235Media',
        u'MultiplexedStreamParameter',
        u'H222LogicalChannelParameters',
        u'H223LogicalChannelParameters',
        u'H223AL1MParameters',
        u'H223AL2MParameters',
        u'H223AL3MParameters',
        u'H223AnnexCArqParameters',
        u'V76LogicalChannelParameters',
        u'V76HDLCParameters',
        u'CRCLength',
        u'H2250LogicalChannelParameters',
        u'RTPPayloadType',
        u'RedundancyEncoding',
        u'RedundancyEncodingElement',
        u'MultiplePayloadStream',
        u'MultiplePayloadStreamElement',
        u'DepFECData',
        u'FECData',
        u'TransportAddress',
        u'UnicastAddress',
        u'MulticastAddress',
        u'EncryptionSync',
        u'EscrowData',
        u'OpenLogicalChannelAck',
        u'OpenLogicalChannelReject',
        u'OpenLogicalChannelConfirm',
        u'H2250LogicalChannelAckParameters',
        u'CloseLogicalChannel',
        u'CloseLogicalChannelAck',
        u'RequestChannelClose',
        u'RequestChannelCloseAck',
        u'RequestChannelCloseReject',
        u'RequestChannelCloseRelease',
        u'MultiplexEntrySend',
        u'MultiplexEntryDescriptor',
        u'MultiplexElement',
        u'MultiplexTableEntryNumber',
        u'MultiplexEntrySendAck',
        u'MultiplexEntrySendReject',
        u'MultiplexEntryRejectionDescriptions',
        u'MultiplexEntrySendRelease',
        u'RequestMultiplexEntry',
        u'RequestMultiplexEntryAck',
        u'RequestMultiplexEntryReject',
        u'RequestMultiplexEntryRejectionDescriptions',
        u'RequestMultiplexEntryRelease',
        u'RequestMode',
        u'RequestModeAck',
        u'RequestModeReject',
        u'RequestModeRelease',
        u'ModeDescription',
        u'ModeElementType',
        u'ModeElement',
        u'H235Mode',
        u'MultiplexedStreamModeParameters',
        u'RedundancyEncodingDTMode',
        u'RedundancyEncodingDTModeElement',
        u'MultiplePayloadStreamMode',
        u'MultiplePayloadStreamElementMode',
        u'DepFECMode',
        u'FECMode',
        u'H223ModeParameters',
        u'V76ModeParameters',
        u'H2250ModeParameters',
        u'RedundancyEncodingMode',
        u'VideoMode',
        u'H261VideoMode',
        u'H262VideoMode',
        u'H263VideoMode',
        u'IS11172VideoMode',
        u'AudioMode',
        u'IS11172AudioMode',
        u'IS13818AudioMode',
        u'G7231AnnexCMode',
        u'VBDMode',
        u'DataMode',
        u'EncryptionMode',
        u'RoundTripDelayRequest',
        u'RoundTripDelayResponse',
        u'MaintenanceLoopRequest',
        u'MaintenanceLoopAck',
        u'MaintenanceLoopReject',
        u'MaintenanceLoopOffCommand',
        u'CommunicationModeCommand',
        u'CommunicationModeRequest',
        u'CommunicationModeResponse',
        u'CommunicationModeTableEntry',
        u'ConferenceRequest',
        u'CertSelectionCriteria',
        u'Criteria',
        u'TerminalLabel',
        u'McuNumber',
        u'TerminalNumber',
        u'ConferenceResponse',
        u'TerminalID',
        u'ConferenceID',
        u'Password',
        u'RequestAllTerminalIDsResponse',
        u'TerminalInformation',
        u'RemoteMCRequest',
        u'RemoteMCResponse',
        u'MultilinkRequest',
        u'MultilinkResponse',
        u'MultilinkIndication',
        u'DialingInformation',
        u'DialingInformationNumber',
        u'DialingInformationNetworkType',
        u'ConnectionIdentifier',
        u'MaximumBitRate',
        u'LogicalChannelRateRequest',
        u'LogicalChannelRateAcknowledge',
        u'LogicalChannelRateReject',
        u'LogicalChannelRateRejectReason',
        u'LogicalChannelRateRelease',
        u'SendTerminalCapabilitySet',
        u'EncryptionCommand',
        u'FlowControlCommand',
        u'EndSessionCommand',
        u'ConferenceCommand',
        u'SubstituteConferenceIDCommand',
        u'EncryptionUpdateDirection',
        u'MiscellaneousCommand',
        u'KeyProtectionMethod',
        u'EncryptionUpdateRequest',
        u'PictureReference',
        u'H223MultiplexReconfiguration',
        u'NewATMVCCommand',
        u'MobileMultilinkReconfigurationCommand',
        u'FunctionNotUnderstood',
        u'FunctionNotSupported',
        u'ConferenceIndication',
        u'TerminalYouAreSeeingInSubPictureNumber',
        u'VideoIndicateCompose',
        u'MiscellaneousIndication',
        u'JitterIndication',
        u'H223SkewIndication',
        u'H2250MaximumSkewIndication',
        u'MCLocationIndication',
        u'VendorIdentification',
        u'NewATMVCIndication',
        u'IV8',
        u'IV16',
        u'Params',
        u'UserInputIndication',
        u'FlowControlIndication',
        u'MobileMultilinkReconfigurationIndication',
        ]
    _set_ = [
        ]
    _val_ = [
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< MultimediaSystemControlMessage >-----#
    MultimediaSystemControlMessage = CHOICE(name=u'MultimediaSystemControlMessage', mode=MODE_TYPE)
    _MultimediaSystemControlMessage_request = CHOICE(name=u'request', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'RequestMessage')))
    _MultimediaSystemControlMessage_response = CHOICE(name=u'response', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'ResponseMessage')))
    _MultimediaSystemControlMessage_command = CHOICE(name=u'command', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'CommandMessage')))
    _MultimediaSystemControlMessage_indication = CHOICE(name=u'indication', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'IndicationMessage')))
    MultimediaSystemControlMessage._cont = ASN1Dict([
        (u'request', _MultimediaSystemControlMessage_request),
        (u'response', _MultimediaSystemControlMessage_response),
        (u'command', _MultimediaSystemControlMessage_command),
        (u'indication', _MultimediaSystemControlMessage_indication),
        ])
    MultimediaSystemControlMessage._ext = []
    
    #-----< RequestMessage >-----#
    RequestMessage = CHOICE(name=u'RequestMessage', mode=MODE_TYPE)
    _RequestMessage_nonStandard = SEQ(name=u'nonStandard', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardMessage')))
    _RequestMessage_masterSlaveDetermination = SEQ(name=u'masterSlaveDetermination', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MasterSlaveDetermination')))
    _RequestMessage_terminalCapabilitySet = SEQ(name=u'terminalCapabilitySet', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TerminalCapabilitySet')))
    _RequestMessage_openLogicalChannel = SEQ(name=u'openLogicalChannel', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'OpenLogicalChannel')))
    _RequestMessage_closeLogicalChannel = SEQ(name=u'closeLogicalChannel', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'CloseLogicalChannel')))
    _RequestMessage_requestChannelClose = SEQ(name=u'requestChannelClose', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'RequestChannelClose')))
    _RequestMessage_multiplexEntrySend = SEQ(name=u'multiplexEntrySend', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MultiplexEntrySend')))
    _RequestMessage_requestMultiplexEntry = SEQ(name=u'requestMultiplexEntry', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'RequestMultiplexEntry')))
    _RequestMessage_requestMode = SEQ(name=u'requestMode', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'RequestMode')))
    _RequestMessage_roundTripDelayRequest = SEQ(name=u'roundTripDelayRequest', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'RoundTripDelayRequest')))
    _RequestMessage_maintenanceLoopRequest = SEQ(name=u'maintenanceLoopRequest', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MaintenanceLoopRequest')))
    _RequestMessage_communicationModeRequest = SEQ(name=u'communicationModeRequest', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'CommunicationModeRequest')))
    _RequestMessage_conferenceRequest = CHOICE(name=u'conferenceRequest', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'ConferenceRequest')))
    _RequestMessage_multilinkRequest = CHOICE(name=u'multilinkRequest', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MultilinkRequest')))
    _RequestMessage_logicalChannelRateRequest = SEQ(name=u'logicalChannelRateRequest', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelRateRequest')))
    _RequestMessage_genericRequest = SEQ(name=u'genericRequest', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'GenericMessage')))
    RequestMessage._cont = ASN1Dict([
        (u'nonStandard', _RequestMessage_nonStandard),
        (u'masterSlaveDetermination', _RequestMessage_masterSlaveDetermination),
        (u'terminalCapabilitySet', _RequestMessage_terminalCapabilitySet),
        (u'openLogicalChannel', _RequestMessage_openLogicalChannel),
        (u'closeLogicalChannel', _RequestMessage_closeLogicalChannel),
        (u'requestChannelClose', _RequestMessage_requestChannelClose),
        (u'multiplexEntrySend', _RequestMessage_multiplexEntrySend),
        (u'requestMultiplexEntry', _RequestMessage_requestMultiplexEntry),
        (u'requestMode', _RequestMessage_requestMode),
        (u'roundTripDelayRequest', _RequestMessage_roundTripDelayRequest),
        (u'maintenanceLoopRequest', _RequestMessage_maintenanceLoopRequest),
        (u'communicationModeRequest', _RequestMessage_communicationModeRequest),
        (u'conferenceRequest', _RequestMessage_conferenceRequest),
        (u'multilinkRequest', _RequestMessage_multilinkRequest),
        (u'logicalChannelRateRequest', _RequestMessage_logicalChannelRateRequest),
        (u'genericRequest', _RequestMessage_genericRequest),
        ])
    RequestMessage._ext = [u'communicationModeRequest', u'conferenceRequest', u'multilinkRequest', u'logicalChannelRateRequest', u'genericRequest']
    
    #-----< ResponseMessage >-----#
    ResponseMessage = CHOICE(name=u'ResponseMessage', mode=MODE_TYPE)
    _ResponseMessage_nonStandard = SEQ(name=u'nonStandard', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardMessage')))
    _ResponseMessage_masterSlaveDeterminationAck = SEQ(name=u'masterSlaveDeterminationAck', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MasterSlaveDeterminationAck')))
    _ResponseMessage_masterSlaveDeterminationReject = SEQ(name=u'masterSlaveDeterminationReject', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MasterSlaveDeterminationReject')))
    _ResponseMessage_terminalCapabilitySetAck = SEQ(name=u'terminalCapabilitySetAck', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TerminalCapabilitySetAck')))
    _ResponseMessage_terminalCapabilitySetReject = SEQ(name=u'terminalCapabilitySetReject', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TerminalCapabilitySetReject')))
    _ResponseMessage_openLogicalChannelAck = SEQ(name=u'openLogicalChannelAck', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'OpenLogicalChannelAck')))
    _ResponseMessage_openLogicalChannelReject = SEQ(name=u'openLogicalChannelReject', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'OpenLogicalChannelReject')))
    _ResponseMessage_closeLogicalChannelAck = SEQ(name=u'closeLogicalChannelAck', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'CloseLogicalChannelAck')))
    _ResponseMessage_requestChannelCloseAck = SEQ(name=u'requestChannelCloseAck', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'RequestChannelCloseAck')))
    _ResponseMessage_requestChannelCloseReject = SEQ(name=u'requestChannelCloseReject', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'RequestChannelCloseReject')))
    _ResponseMessage_multiplexEntrySendAck = SEQ(name=u'multiplexEntrySendAck', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MultiplexEntrySendAck')))
    _ResponseMessage_multiplexEntrySendReject = SEQ(name=u'multiplexEntrySendReject', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MultiplexEntrySendReject')))
    _ResponseMessage_requestMultiplexEntryAck = SEQ(name=u'requestMultiplexEntryAck', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'RequestMultiplexEntryAck')))
    _ResponseMessage_requestMultiplexEntryReject = SEQ(name=u'requestMultiplexEntryReject', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'RequestMultiplexEntryReject')))
    _ResponseMessage_requestModeAck = SEQ(name=u'requestModeAck', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'RequestModeAck')))
    _ResponseMessage_requestModeReject = SEQ(name=u'requestModeReject', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'RequestModeReject')))
    _ResponseMessage_roundTripDelayResponse = SEQ(name=u'roundTripDelayResponse', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'RoundTripDelayResponse')))
    _ResponseMessage_maintenanceLoopAck = SEQ(name=u'maintenanceLoopAck', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MaintenanceLoopAck')))
    _ResponseMessage_maintenanceLoopReject = SEQ(name=u'maintenanceLoopReject', mode=MODE_TYPE, tag=(18, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MaintenanceLoopReject')))
    _ResponseMessage_communicationModeResponse = CHOICE(name=u'communicationModeResponse', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'CommunicationModeResponse')))
    _ResponseMessage_conferenceResponse = CHOICE(name=u'conferenceResponse', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'ConferenceResponse')))
    _ResponseMessage_multilinkResponse = CHOICE(name=u'multilinkResponse', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MultilinkResponse')))
    _ResponseMessage_logicalChannelRateAcknowledge = SEQ(name=u'logicalChannelRateAcknowledge', mode=MODE_TYPE, tag=(22, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelRateAcknowledge')))
    _ResponseMessage_logicalChannelRateReject = SEQ(name=u'logicalChannelRateReject', mode=MODE_TYPE, tag=(23, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelRateReject')))
    _ResponseMessage_genericResponse = SEQ(name=u'genericResponse', mode=MODE_TYPE, tag=(24, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'GenericMessage')))
    ResponseMessage._cont = ASN1Dict([
        (u'nonStandard', _ResponseMessage_nonStandard),
        (u'masterSlaveDeterminationAck', _ResponseMessage_masterSlaveDeterminationAck),
        (u'masterSlaveDeterminationReject', _ResponseMessage_masterSlaveDeterminationReject),
        (u'terminalCapabilitySetAck', _ResponseMessage_terminalCapabilitySetAck),
        (u'terminalCapabilitySetReject', _ResponseMessage_terminalCapabilitySetReject),
        (u'openLogicalChannelAck', _ResponseMessage_openLogicalChannelAck),
        (u'openLogicalChannelReject', _ResponseMessage_openLogicalChannelReject),
        (u'closeLogicalChannelAck', _ResponseMessage_closeLogicalChannelAck),
        (u'requestChannelCloseAck', _ResponseMessage_requestChannelCloseAck),
        (u'requestChannelCloseReject', _ResponseMessage_requestChannelCloseReject),
        (u'multiplexEntrySendAck', _ResponseMessage_multiplexEntrySendAck),
        (u'multiplexEntrySendReject', _ResponseMessage_multiplexEntrySendReject),
        (u'requestMultiplexEntryAck', _ResponseMessage_requestMultiplexEntryAck),
        (u'requestMultiplexEntryReject', _ResponseMessage_requestMultiplexEntryReject),
        (u'requestModeAck', _ResponseMessage_requestModeAck),
        (u'requestModeReject', _ResponseMessage_requestModeReject),
        (u'roundTripDelayResponse', _ResponseMessage_roundTripDelayResponse),
        (u'maintenanceLoopAck', _ResponseMessage_maintenanceLoopAck),
        (u'maintenanceLoopReject', _ResponseMessage_maintenanceLoopReject),
        (u'communicationModeResponse', _ResponseMessage_communicationModeResponse),
        (u'conferenceResponse', _ResponseMessage_conferenceResponse),
        (u'multilinkResponse', _ResponseMessage_multilinkResponse),
        (u'logicalChannelRateAcknowledge', _ResponseMessage_logicalChannelRateAcknowledge),
        (u'logicalChannelRateReject', _ResponseMessage_logicalChannelRateReject),
        (u'genericResponse', _ResponseMessage_genericResponse),
        ])
    ResponseMessage._ext = [u'communicationModeResponse', u'conferenceResponse', u'multilinkResponse', u'logicalChannelRateAcknowledge', u'logicalChannelRateReject', u'genericResponse']
    
    #-----< CommandMessage >-----#
    CommandMessage = CHOICE(name=u'CommandMessage', mode=MODE_TYPE)
    _CommandMessage_nonStandard = SEQ(name=u'nonStandard', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardMessage')))
    _CommandMessage_maintenanceLoopOffCommand = SEQ(name=u'maintenanceLoopOffCommand', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MaintenanceLoopOffCommand')))
    _CommandMessage_sendTerminalCapabilitySet = CHOICE(name=u'sendTerminalCapabilitySet', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'SendTerminalCapabilitySet')))
    _CommandMessage_encryptionCommand = CHOICE(name=u'encryptionCommand', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'EncryptionCommand')))
    _CommandMessage_flowControlCommand = SEQ(name=u'flowControlCommand', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'FlowControlCommand')))
    _CommandMessage_endSessionCommand = CHOICE(name=u'endSessionCommand', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'EndSessionCommand')))
    _CommandMessage_miscellaneousCommand = SEQ(name=u'miscellaneousCommand', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MiscellaneousCommand')))
    _CommandMessage_communicationModeCommand = SEQ(name=u'communicationModeCommand', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'CommunicationModeCommand')))
    _CommandMessage_conferenceCommand = CHOICE(name=u'conferenceCommand', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'ConferenceCommand')))
    _CommandMessage_h223MultiplexReconfiguration = CHOICE(name=u'h223MultiplexReconfiguration', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H223MultiplexReconfiguration')))
    _CommandMessage_newATMVCCommand = SEQ(name=u'newATMVCCommand', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NewATMVCCommand')))
    _CommandMessage_mobileMultilinkReconfigurationCommand = SEQ(name=u'mobileMultilinkReconfigurationCommand', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MobileMultilinkReconfigurationCommand')))
    _CommandMessage_genericCommand = SEQ(name=u'genericCommand', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'GenericMessage')))
    CommandMessage._cont = ASN1Dict([
        (u'nonStandard', _CommandMessage_nonStandard),
        (u'maintenanceLoopOffCommand', _CommandMessage_maintenanceLoopOffCommand),
        (u'sendTerminalCapabilitySet', _CommandMessage_sendTerminalCapabilitySet),
        (u'encryptionCommand', _CommandMessage_encryptionCommand),
        (u'flowControlCommand', _CommandMessage_flowControlCommand),
        (u'endSessionCommand', _CommandMessage_endSessionCommand),
        (u'miscellaneousCommand', _CommandMessage_miscellaneousCommand),
        (u'communicationModeCommand', _CommandMessage_communicationModeCommand),
        (u'conferenceCommand', _CommandMessage_conferenceCommand),
        (u'h223MultiplexReconfiguration', _CommandMessage_h223MultiplexReconfiguration),
        (u'newATMVCCommand', _CommandMessage_newATMVCCommand),
        (u'mobileMultilinkReconfigurationCommand', _CommandMessage_mobileMultilinkReconfigurationCommand),
        (u'genericCommand', _CommandMessage_genericCommand),
        ])
    CommandMessage._ext = [u'communicationModeCommand', u'conferenceCommand', u'h223MultiplexReconfiguration', u'newATMVCCommand', u'mobileMultilinkReconfigurationCommand', u'genericCommand']
    
    #-----< IndicationMessage >-----#
    IndicationMessage = CHOICE(name=u'IndicationMessage', mode=MODE_TYPE)
    _IndicationMessage_nonStandard = SEQ(name=u'nonStandard', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardMessage')))
    _IndicationMessage_functionNotUnderstood = CHOICE(name=u'functionNotUnderstood', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'FunctionNotUnderstood')))
    _IndicationMessage_masterSlaveDeterminationRelease = SEQ(name=u'masterSlaveDeterminationRelease', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MasterSlaveDeterminationRelease')))
    _IndicationMessage_terminalCapabilitySetRelease = SEQ(name=u'terminalCapabilitySetRelease', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TerminalCapabilitySetRelease')))
    _IndicationMessage_openLogicalChannelConfirm = SEQ(name=u'openLogicalChannelConfirm', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'OpenLogicalChannelConfirm')))
    _IndicationMessage_requestChannelCloseRelease = SEQ(name=u'requestChannelCloseRelease', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'RequestChannelCloseRelease')))
    _IndicationMessage_multiplexEntrySendRelease = SEQ(name=u'multiplexEntrySendRelease', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MultiplexEntrySendRelease')))
    _IndicationMessage_requestMultiplexEntryRelease = SEQ(name=u'requestMultiplexEntryRelease', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'RequestMultiplexEntryRelease')))
    _IndicationMessage_requestModeRelease = SEQ(name=u'requestModeRelease', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'RequestModeRelease')))
    _IndicationMessage_miscellaneousIndication = SEQ(name=u'miscellaneousIndication', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MiscellaneousIndication')))
    _IndicationMessage_jitterIndication = SEQ(name=u'jitterIndication', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'JitterIndication')))
    _IndicationMessage_h223SkewIndication = SEQ(name=u'h223SkewIndication', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H223SkewIndication')))
    _IndicationMessage_newATMVCIndication = SEQ(name=u'newATMVCIndication', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NewATMVCIndication')))
    _IndicationMessage_userInput = CHOICE(name=u'userInput', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'UserInputIndication')))
    _IndicationMessage_h2250MaximumSkewIndication = SEQ(name=u'h2250MaximumSkewIndication', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H2250MaximumSkewIndication')))
    _IndicationMessage_mcLocationIndication = SEQ(name=u'mcLocationIndication', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MCLocationIndication')))
    _IndicationMessage_conferenceIndication = CHOICE(name=u'conferenceIndication', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'ConferenceIndication')))
    _IndicationMessage_vendorIdentification = SEQ(name=u'vendorIdentification', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'VendorIdentification')))
    _IndicationMessage_functionNotSupported = SEQ(name=u'functionNotSupported', mode=MODE_TYPE, tag=(18, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'FunctionNotSupported')))
    _IndicationMessage_multilinkIndication = CHOICE(name=u'multilinkIndication', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MultilinkIndication')))
    _IndicationMessage_logicalChannelRateRelease = SEQ(name=u'logicalChannelRateRelease', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelRateRelease')))
    _IndicationMessage_flowControlIndication = SEQ(name=u'flowControlIndication', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'FlowControlIndication')))
    _IndicationMessage_mobileMultilinkReconfigurationIndication = SEQ(name=u'mobileMultilinkReconfigurationIndication', mode=MODE_TYPE, tag=(22, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MobileMultilinkReconfigurationIndication')))
    _IndicationMessage_genericIndication = SEQ(name=u'genericIndication', mode=MODE_TYPE, tag=(23, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'GenericMessage')))
    IndicationMessage._cont = ASN1Dict([
        (u'nonStandard', _IndicationMessage_nonStandard),
        (u'functionNotUnderstood', _IndicationMessage_functionNotUnderstood),
        (u'masterSlaveDeterminationRelease', _IndicationMessage_masterSlaveDeterminationRelease),
        (u'terminalCapabilitySetRelease', _IndicationMessage_terminalCapabilitySetRelease),
        (u'openLogicalChannelConfirm', _IndicationMessage_openLogicalChannelConfirm),
        (u'requestChannelCloseRelease', _IndicationMessage_requestChannelCloseRelease),
        (u'multiplexEntrySendRelease', _IndicationMessage_multiplexEntrySendRelease),
        (u'requestMultiplexEntryRelease', _IndicationMessage_requestMultiplexEntryRelease),
        (u'requestModeRelease', _IndicationMessage_requestModeRelease),
        (u'miscellaneousIndication', _IndicationMessage_miscellaneousIndication),
        (u'jitterIndication', _IndicationMessage_jitterIndication),
        (u'h223SkewIndication', _IndicationMessage_h223SkewIndication),
        (u'newATMVCIndication', _IndicationMessage_newATMVCIndication),
        (u'userInput', _IndicationMessage_userInput),
        (u'h2250MaximumSkewIndication', _IndicationMessage_h2250MaximumSkewIndication),
        (u'mcLocationIndication', _IndicationMessage_mcLocationIndication),
        (u'conferenceIndication', _IndicationMessage_conferenceIndication),
        (u'vendorIdentification', _IndicationMessage_vendorIdentification),
        (u'functionNotSupported', _IndicationMessage_functionNotSupported),
        (u'multilinkIndication', _IndicationMessage_multilinkIndication),
        (u'logicalChannelRateRelease', _IndicationMessage_logicalChannelRateRelease),
        (u'flowControlIndication', _IndicationMessage_flowControlIndication),
        (u'mobileMultilinkReconfigurationIndication', _IndicationMessage_mobileMultilinkReconfigurationIndication),
        (u'genericIndication', _IndicationMessage_genericIndication),
        ])
    IndicationMessage._ext = [u'h2250MaximumSkewIndication', u'mcLocationIndication', u'conferenceIndication', u'vendorIdentification', u'functionNotSupported', u'multilinkIndication', u'logicalChannelRateRelease', u'flowControlIndication', u'mobileMultilinkReconfigurationIndication', u'genericIndication']
    
    #-----< SequenceNumber >-----#
    SequenceNumber = INT(name=u'SequenceNumber', mode=MODE_TYPE)
    SequenceNumber._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    
    #-----< GenericMessage >-----#
    GenericMessage = SEQ(name=u'GenericMessage', mode=MODE_TYPE)
    _GenericMessage_messageIdentifier = CHOICE(name=u'messageIdentifier', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'CapabilityIdentifier')))
    _GenericMessage_subMessageIdentifier = INT(name=u'subMessageIdentifier', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GenericMessage_subMessageIdentifier._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    _GenericMessage_messageContent = SEQ_OF(name=u'messageContent', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __GenericMessage_messageContent__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'GenericParameter')))
    _GenericMessage_messageContent._cont = __GenericMessage_messageContent__item_
    GenericMessage._cont = ASN1Dict([
        (u'messageIdentifier', _GenericMessage_messageIdentifier),
        (u'subMessageIdentifier', _GenericMessage_subMessageIdentifier),
        (u'messageContent', _GenericMessage_messageContent),
        ])
    GenericMessage._ext = []
    
    #-----< GenericInformation >-----#
    GenericInformation = SEQ(name=u'GenericInformation', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'GenericMessage')))
    
    #-----< NonStandardMessage >-----#
    NonStandardMessage = SEQ(name=u'NonStandardMessage', mode=MODE_TYPE)
    _NonStandardMessage_nonStandardData = SEQ(name=u'nonStandardData', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')))
    NonStandardMessage._cont = ASN1Dict([
        (u'nonStandardData', _NonStandardMessage_nonStandardData),
        ])
    NonStandardMessage._ext = []
    
    #-----< NonStandardParameter >-----#
    NonStandardParameter = SEQ(name=u'NonStandardParameter', mode=MODE_TYPE)
    _NonStandardParameter_nonStandardIdentifier = CHOICE(name=u'nonStandardIdentifier', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardIdentifier')))
    _NonStandardParameter_data = OCT_STR(name=u'data', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    NonStandardParameter._cont = ASN1Dict([
        (u'nonStandardIdentifier', _NonStandardParameter_nonStandardIdentifier),
        (u'data', _NonStandardParameter_data),
        ])
    NonStandardParameter._ext = None
    
    #-----< NonStandardIdentifier >-----#
    NonStandardIdentifier = CHOICE(name=u'NonStandardIdentifier', mode=MODE_TYPE)
    _NonStandardIdentifier_object = OID(name=u'object', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NonStandardIdentifier_h221NonStandard = SEQ(name=u'h221NonStandard', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __NonStandardIdentifier_h221NonStandard_t35CountryCode = INT(name=u't35CountryCode', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __NonStandardIdentifier_h221NonStandard_t35CountryCode._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    __NonStandardIdentifier_h221NonStandard_t35Extension = INT(name=u't35Extension', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __NonStandardIdentifier_h221NonStandard_t35Extension._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    __NonStandardIdentifier_h221NonStandard_manufacturerCode = INT(name=u'manufacturerCode', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __NonStandardIdentifier_h221NonStandard_manufacturerCode._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    _NonStandardIdentifier_h221NonStandard._cont = ASN1Dict([
        (u't35CountryCode', __NonStandardIdentifier_h221NonStandard_t35CountryCode),
        (u't35Extension', __NonStandardIdentifier_h221NonStandard_t35Extension),
        (u'manufacturerCode', __NonStandardIdentifier_h221NonStandard_manufacturerCode),
        ])
    _NonStandardIdentifier_h221NonStandard._ext = None
    NonStandardIdentifier._cont = ASN1Dict([
        (u'object', _NonStandardIdentifier_object),
        (u'h221NonStandard', _NonStandardIdentifier_h221NonStandard),
        ])
    NonStandardIdentifier._ext = None
    
    #-----< MasterSlaveDetermination >-----#
    MasterSlaveDetermination = SEQ(name=u'MasterSlaveDetermination', mode=MODE_TYPE)
    _MasterSlaveDetermination_terminalType = INT(name=u'terminalType', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MasterSlaveDetermination_terminalType._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _MasterSlaveDetermination_statusDeterminationNumber = INT(name=u'statusDeterminationNumber', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MasterSlaveDetermination_statusDeterminationNumber._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=16777215)], ev=None, er=[])
    MasterSlaveDetermination._cont = ASN1Dict([
        (u'terminalType', _MasterSlaveDetermination_terminalType),
        (u'statusDeterminationNumber', _MasterSlaveDetermination_statusDeterminationNumber),
        ])
    MasterSlaveDetermination._ext = []
    
    #-----< MasterSlaveDeterminationAck >-----#
    MasterSlaveDeterminationAck = SEQ(name=u'MasterSlaveDeterminationAck', mode=MODE_TYPE)
    _MasterSlaveDeterminationAck_decision = CHOICE(name=u'decision', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __MasterSlaveDeterminationAck_decision_master = NULL(name=u'master', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MasterSlaveDeterminationAck_decision_slave = NULL(name=u'slave', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MasterSlaveDeterminationAck_decision._cont = ASN1Dict([
        (u'master', __MasterSlaveDeterminationAck_decision_master),
        (u'slave', __MasterSlaveDeterminationAck_decision_slave),
        ])
    _MasterSlaveDeterminationAck_decision._ext = None
    MasterSlaveDeterminationAck._cont = ASN1Dict([
        (u'decision', _MasterSlaveDeterminationAck_decision),
        ])
    MasterSlaveDeterminationAck._ext = []
    
    #-----< MasterSlaveDeterminationReject >-----#
    MasterSlaveDeterminationReject = SEQ(name=u'MasterSlaveDeterminationReject', mode=MODE_TYPE)
    _MasterSlaveDeterminationReject_cause = CHOICE(name=u'cause', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __MasterSlaveDeterminationReject_cause_identicalNumbers = NULL(name=u'identicalNumbers', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MasterSlaveDeterminationReject_cause._cont = ASN1Dict([
        (u'identicalNumbers', __MasterSlaveDeterminationReject_cause_identicalNumbers),
        ])
    _MasterSlaveDeterminationReject_cause._ext = []
    MasterSlaveDeterminationReject._cont = ASN1Dict([
        (u'cause', _MasterSlaveDeterminationReject_cause),
        ])
    MasterSlaveDeterminationReject._ext = []
    
    #-----< MasterSlaveDeterminationRelease >-----#
    MasterSlaveDeterminationRelease = SEQ(name=u'MasterSlaveDeterminationRelease', mode=MODE_TYPE)
    MasterSlaveDeterminationRelease._cont = ASN1Dict([
        ])
    MasterSlaveDeterminationRelease._ext = []
    
    #-----< TerminalCapabilitySet >-----#
    TerminalCapabilitySet = SEQ(name=u'TerminalCapabilitySet', mode=MODE_TYPE)
    _TerminalCapabilitySet_sequenceNumber = INT(name=u'sequenceNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'SequenceNumber')))
    _TerminalCapabilitySet_protocolIdentifier = OID(name=u'protocolIdentifier', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _TerminalCapabilitySet_multiplexCapability = CHOICE(name=u'multiplexCapability', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MultiplexCapability')), opt=True)
    _TerminalCapabilitySet_capabilityTable = SET_OF(name=u'capabilityTable', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __TerminalCapabilitySet_capabilityTable__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'CapabilityTableEntry')))
    _TerminalCapabilitySet_capabilityTable._cont = __TerminalCapabilitySet_capabilityTable__item_
    _TerminalCapabilitySet_capabilityTable._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    _TerminalCapabilitySet_capabilityDescriptors = SET_OF(name=u'capabilityDescriptors', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __TerminalCapabilitySet_capabilityDescriptors__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'CapabilityDescriptor')))
    _TerminalCapabilitySet_capabilityDescriptors._cont = __TerminalCapabilitySet_capabilityDescriptors__item_
    _TerminalCapabilitySet_capabilityDescriptors._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    _TerminalCapabilitySet_genericInformation = SEQ_OF(name=u'genericInformation', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __TerminalCapabilitySet_genericInformation__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'GenericInformation')))
    _TerminalCapabilitySet_genericInformation._cont = __TerminalCapabilitySet_genericInformation__item_
    TerminalCapabilitySet._cont = ASN1Dict([
        (u'sequenceNumber', _TerminalCapabilitySet_sequenceNumber),
        (u'protocolIdentifier', _TerminalCapabilitySet_protocolIdentifier),
        (u'multiplexCapability', _TerminalCapabilitySet_multiplexCapability),
        (u'capabilityTable', _TerminalCapabilitySet_capabilityTable),
        (u'capabilityDescriptors', _TerminalCapabilitySet_capabilityDescriptors),
        (u'genericInformation', _TerminalCapabilitySet_genericInformation),
        ])
    TerminalCapabilitySet._ext = [u'genericInformation']
    
    #-----< CapabilityTableEntry >-----#
    CapabilityTableEntry = SEQ(name=u'CapabilityTableEntry', mode=MODE_TYPE)
    _CapabilityTableEntry_capabilityTableEntryNumber = INT(name=u'capabilityTableEntryNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'CapabilityTableEntryNumber')))
    _CapabilityTableEntry_capability = CHOICE(name=u'capability', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'Capability')), opt=True)
    CapabilityTableEntry._cont = ASN1Dict([
        (u'capabilityTableEntryNumber', _CapabilityTableEntry_capabilityTableEntryNumber),
        (u'capability', _CapabilityTableEntry_capability),
        ])
    CapabilityTableEntry._ext = None
    
    #-----< CapabilityDescriptor >-----#
    CapabilityDescriptor = SEQ(name=u'CapabilityDescriptor', mode=MODE_TYPE)
    _CapabilityDescriptor_capabilityDescriptorNumber = INT(name=u'capabilityDescriptorNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'CapabilityDescriptorNumber')))
    _CapabilityDescriptor_simultaneousCapabilities = SET_OF(name=u'simultaneousCapabilities', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __CapabilityDescriptor_simultaneousCapabilities__item_ = SEQ_OF(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'AlternativeCapabilitySet')))
    _CapabilityDescriptor_simultaneousCapabilities._cont = __CapabilityDescriptor_simultaneousCapabilities__item_
    _CapabilityDescriptor_simultaneousCapabilities._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    CapabilityDescriptor._cont = ASN1Dict([
        (u'capabilityDescriptorNumber', _CapabilityDescriptor_capabilityDescriptorNumber),
        (u'simultaneousCapabilities', _CapabilityDescriptor_simultaneousCapabilities),
        ])
    CapabilityDescriptor._ext = None
    
    #-----< AlternativeCapabilitySet >-----#
    AlternativeCapabilitySet = SEQ_OF(name=u'AlternativeCapabilitySet', mode=MODE_TYPE)
    _AlternativeCapabilitySet__item_ = INT(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'CapabilityTableEntryNumber')))
    AlternativeCapabilitySet._cont = _AlternativeCapabilitySet__item_
    AlternativeCapabilitySet._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    
    #-----< CapabilityTableEntryNumber >-----#
    CapabilityTableEntryNumber = INT(name=u'CapabilityTableEntryNumber', mode=MODE_TYPE)
    CapabilityTableEntryNumber._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    
    #-----< CapabilityDescriptorNumber >-----#
    CapabilityDescriptorNumber = INT(name=u'CapabilityDescriptorNumber', mode=MODE_TYPE)
    CapabilityDescriptorNumber._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    
    #-----< TerminalCapabilitySetAck >-----#
    TerminalCapabilitySetAck = SEQ(name=u'TerminalCapabilitySetAck', mode=MODE_TYPE)
    _TerminalCapabilitySetAck_sequenceNumber = INT(name=u'sequenceNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'SequenceNumber')))
    _TerminalCapabilitySetAck_genericInformation = SEQ_OF(name=u'genericInformation', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __TerminalCapabilitySetAck_genericInformation__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'GenericInformation')))
    _TerminalCapabilitySetAck_genericInformation._cont = __TerminalCapabilitySetAck_genericInformation__item_
    TerminalCapabilitySetAck._cont = ASN1Dict([
        (u'sequenceNumber', _TerminalCapabilitySetAck_sequenceNumber),
        (u'genericInformation', _TerminalCapabilitySetAck_genericInformation),
        ])
    TerminalCapabilitySetAck._ext = [u'genericInformation']
    
    #-----< TerminalCapabilitySetReject >-----#
    TerminalCapabilitySetReject = SEQ(name=u'TerminalCapabilitySetReject', mode=MODE_TYPE)
    _TerminalCapabilitySetReject_sequenceNumber = INT(name=u'sequenceNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'SequenceNumber')))
    _TerminalCapabilitySetReject_cause = CHOICE(name=u'cause', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __TerminalCapabilitySetReject_cause_unspecified = NULL(name=u'unspecified', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __TerminalCapabilitySetReject_cause_undefinedTableEntryUsed = NULL(name=u'undefinedTableEntryUsed', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __TerminalCapabilitySetReject_cause_descriptorCapacityExceeded = NULL(name=u'descriptorCapacityExceeded', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded = CHOICE(name=u'tableEntryCapacityExceeded', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ___TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded_highestEntryNumberProcessed = INT(name=u'highestEntryNumberProcessed', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'CapabilityTableEntryNumber')))
    ___TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded_noneProcessed = NULL(name=u'noneProcessed', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded._cont = ASN1Dict([
        (u'highestEntryNumberProcessed', ___TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded_highestEntryNumberProcessed),
        (u'noneProcessed', ___TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded_noneProcessed),
        ])
    __TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded._ext = None
    _TerminalCapabilitySetReject_cause._cont = ASN1Dict([
        (u'unspecified', __TerminalCapabilitySetReject_cause_unspecified),
        (u'undefinedTableEntryUsed', __TerminalCapabilitySetReject_cause_undefinedTableEntryUsed),
        (u'descriptorCapacityExceeded', __TerminalCapabilitySetReject_cause_descriptorCapacityExceeded),
        (u'tableEntryCapacityExceeded', __TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded),
        ])
    _TerminalCapabilitySetReject_cause._ext = []
    _TerminalCapabilitySetReject_genericInformation = SEQ_OF(name=u'genericInformation', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __TerminalCapabilitySetReject_genericInformation__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'GenericInformation')))
    _TerminalCapabilitySetReject_genericInformation._cont = __TerminalCapabilitySetReject_genericInformation__item_
    TerminalCapabilitySetReject._cont = ASN1Dict([
        (u'sequenceNumber', _TerminalCapabilitySetReject_sequenceNumber),
        (u'cause', _TerminalCapabilitySetReject_cause),
        (u'genericInformation', _TerminalCapabilitySetReject_genericInformation),
        ])
    TerminalCapabilitySetReject._ext = [u'genericInformation']
    
    #-----< TerminalCapabilitySetRelease >-----#
    TerminalCapabilitySetRelease = SEQ(name=u'TerminalCapabilitySetRelease', mode=MODE_TYPE)
    _TerminalCapabilitySetRelease_genericInformation = SEQ_OF(name=u'genericInformation', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __TerminalCapabilitySetRelease_genericInformation__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'GenericInformation')))
    _TerminalCapabilitySetRelease_genericInformation._cont = __TerminalCapabilitySetRelease_genericInformation__item_
    TerminalCapabilitySetRelease._cont = ASN1Dict([
        (u'genericInformation', _TerminalCapabilitySetRelease_genericInformation),
        ])
    TerminalCapabilitySetRelease._ext = [u'genericInformation']
    
    #-----< Capability >-----#
    Capability = CHOICE(name=u'Capability', mode=MODE_TYPE)
    _Capability_nonStandard = SEQ(name=u'nonStandard', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')))
    _Capability_receiveVideoCapability = CHOICE(name=u'receiveVideoCapability', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'VideoCapability')))
    _Capability_transmitVideoCapability = CHOICE(name=u'transmitVideoCapability', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'VideoCapability')))
    _Capability_receiveAndTransmitVideoCapability = CHOICE(name=u'receiveAndTransmitVideoCapability', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'VideoCapability')))
    _Capability_receiveAudioCapability = CHOICE(name=u'receiveAudioCapability', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'AudioCapability')))
    _Capability_transmitAudioCapability = CHOICE(name=u'transmitAudioCapability', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'AudioCapability')))
    _Capability_receiveAndTransmitAudioCapability = CHOICE(name=u'receiveAndTransmitAudioCapability', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'AudioCapability')))
    _Capability_receiveDataApplicationCapability = SEQ(name=u'receiveDataApplicationCapability', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DataApplicationCapability')))
    _Capability_transmitDataApplicationCapability = SEQ(name=u'transmitDataApplicationCapability', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DataApplicationCapability')))
    _Capability_receiveAndTransmitDataApplicationCapability = SEQ(name=u'receiveAndTransmitDataApplicationCapability', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DataApplicationCapability')))
    _Capability_h233EncryptionTransmitCapability = BOOL(name=u'h233EncryptionTransmitCapability', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _Capability_h233EncryptionReceiveCapability = SEQ(name=u'h233EncryptionReceiveCapability', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __Capability_h233EncryptionReceiveCapability_h233IVResponseTime = INT(name=u'h233IVResponseTime', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __Capability_h233EncryptionReceiveCapability_h233IVResponseTime._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _Capability_h233EncryptionReceiveCapability._cont = ASN1Dict([
        (u'h233IVResponseTime', __Capability_h233EncryptionReceiveCapability_h233IVResponseTime),
        ])
    _Capability_h233EncryptionReceiveCapability._ext = []
    _Capability_conferenceCapability = SEQ(name=u'conferenceCapability', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'ConferenceCapability')))
    _Capability_h235SecurityCapability = SEQ(name=u'h235SecurityCapability', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H235SecurityCapability')))
    _Capability_maxPendingReplacementFor = INT(name=u'maxPendingReplacementFor', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _Capability_maxPendingReplacementFor._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _Capability_receiveUserInputCapability = CHOICE(name=u'receiveUserInputCapability', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'UserInputCapability')))
    _Capability_transmitUserInputCapability = CHOICE(name=u'transmitUserInputCapability', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'UserInputCapability')))
    _Capability_receiveAndTransmitUserInputCapability = CHOICE(name=u'receiveAndTransmitUserInputCapability', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'UserInputCapability')))
    _Capability_genericControlCapability = SEQ(name=u'genericControlCapability', mode=MODE_TYPE, tag=(18, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'GenericCapability')))
    _Capability_receiveMultiplexedStreamCapability = SEQ(name=u'receiveMultiplexedStreamCapability', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MultiplexedStreamCapability')))
    _Capability_transmitMultiplexedStreamCapability = SEQ(name=u'transmitMultiplexedStreamCapability', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MultiplexedStreamCapability')))
    _Capability_receiveAndTransmitMultiplexedStreamCapability = SEQ(name=u'receiveAndTransmitMultiplexedStreamCapability', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MultiplexedStreamCapability')))
    _Capability_receiveRTPAudioTelephonyEventCapability = SEQ(name=u'receiveRTPAudioTelephonyEventCapability', mode=MODE_TYPE, tag=(22, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'AudioTelephonyEventCapability')))
    _Capability_receiveRTPAudioToneCapability = SEQ(name=u'receiveRTPAudioToneCapability', mode=MODE_TYPE, tag=(23, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'AudioToneCapability')))
    _Capability_depFecCapability = CHOICE(name=u'depFecCapability', mode=MODE_TYPE, tag=(24, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DepFECCapability')))
    _Capability_multiplePayloadStreamCapability = SEQ(name=u'multiplePayloadStreamCapability', mode=MODE_TYPE, tag=(25, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MultiplePayloadStreamCapability')))
    _Capability_fecCapability = SEQ(name=u'fecCapability', mode=MODE_TYPE, tag=(26, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'FECCapability')))
    _Capability_redundancyEncodingCap = SEQ(name=u'redundancyEncodingCap', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'RedundancyEncodingCapability')))
    _Capability_oneOfCapabilities = SEQ_OF(name=u'oneOfCapabilities', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'AlternativeCapabilitySet')))
    Capability._cont = ASN1Dict([
        (u'nonStandard', _Capability_nonStandard),
        (u'receiveVideoCapability', _Capability_receiveVideoCapability),
        (u'transmitVideoCapability', _Capability_transmitVideoCapability),
        (u'receiveAndTransmitVideoCapability', _Capability_receiveAndTransmitVideoCapability),
        (u'receiveAudioCapability', _Capability_receiveAudioCapability),
        (u'transmitAudioCapability', _Capability_transmitAudioCapability),
        (u'receiveAndTransmitAudioCapability', _Capability_receiveAndTransmitAudioCapability),
        (u'receiveDataApplicationCapability', _Capability_receiveDataApplicationCapability),
        (u'transmitDataApplicationCapability', _Capability_transmitDataApplicationCapability),
        (u'receiveAndTransmitDataApplicationCapability', _Capability_receiveAndTransmitDataApplicationCapability),
        (u'h233EncryptionTransmitCapability', _Capability_h233EncryptionTransmitCapability),
        (u'h233EncryptionReceiveCapability', _Capability_h233EncryptionReceiveCapability),
        (u'conferenceCapability', _Capability_conferenceCapability),
        (u'h235SecurityCapability', _Capability_h235SecurityCapability),
        (u'maxPendingReplacementFor', _Capability_maxPendingReplacementFor),
        (u'receiveUserInputCapability', _Capability_receiveUserInputCapability),
        (u'transmitUserInputCapability', _Capability_transmitUserInputCapability),
        (u'receiveAndTransmitUserInputCapability', _Capability_receiveAndTransmitUserInputCapability),
        (u'genericControlCapability', _Capability_genericControlCapability),
        (u'receiveMultiplexedStreamCapability', _Capability_receiveMultiplexedStreamCapability),
        (u'transmitMultiplexedStreamCapability', _Capability_transmitMultiplexedStreamCapability),
        (u'receiveAndTransmitMultiplexedStreamCapability', _Capability_receiveAndTransmitMultiplexedStreamCapability),
        (u'receiveRTPAudioTelephonyEventCapability', _Capability_receiveRTPAudioTelephonyEventCapability),
        (u'receiveRTPAudioToneCapability', _Capability_receiveRTPAudioToneCapability),
        (u'depFecCapability', _Capability_depFecCapability),
        (u'multiplePayloadStreamCapability', _Capability_multiplePayloadStreamCapability),
        (u'fecCapability', _Capability_fecCapability),
        (u'redundancyEncodingCap', _Capability_redundancyEncodingCap),
        (u'oneOfCapabilities', _Capability_oneOfCapabilities),
        ])
    Capability._ext = [u'conferenceCapability', u'h235SecurityCapability', u'maxPendingReplacementFor', u'receiveUserInputCapability', u'transmitUserInputCapability', u'receiveAndTransmitUserInputCapability', u'genericControlCapability', u'receiveMultiplexedStreamCapability', u'transmitMultiplexedStreamCapability', u'receiveAndTransmitMultiplexedStreamCapability', u'receiveRTPAudioTelephonyEventCapability', u'receiveRTPAudioToneCapability', u'depFecCapability', u'multiplePayloadStreamCapability', u'fecCapability', u'redundancyEncodingCap', u'oneOfCapabilities']
    
    #-----< H235SecurityCapability >-----#
    H235SecurityCapability = SEQ(name=u'H235SecurityCapability', mode=MODE_TYPE)
    _H235SecurityCapability_encryptionAuthenticationAndIntegrity = SEQ(name=u'encryptionAuthenticationAndIntegrity', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'EncryptionAuthenticationAndIntegrity')))
    _H235SecurityCapability_mediaCapability = INT(name=u'mediaCapability', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'CapabilityTableEntryNumber')))
    H235SecurityCapability._cont = ASN1Dict([
        (u'encryptionAuthenticationAndIntegrity', _H235SecurityCapability_encryptionAuthenticationAndIntegrity),
        (u'mediaCapability', _H235SecurityCapability_mediaCapability),
        ])
    H235SecurityCapability._ext = []
    
    #-----< MultiplexCapability >-----#
    MultiplexCapability = CHOICE(name=u'MultiplexCapability', mode=MODE_TYPE)
    _MultiplexCapability_nonStandard = SEQ(name=u'nonStandard', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')))
    _MultiplexCapability_h222Capability = SEQ(name=u'h222Capability', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H222Capability')))
    _MultiplexCapability_h223Capability = SEQ(name=u'h223Capability', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H223Capability')))
    _MultiplexCapability_v76Capability = SEQ(name=u'v76Capability', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'V76Capability')))
    _MultiplexCapability_h2250Capability = SEQ(name=u'h2250Capability', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H2250Capability')))
    _MultiplexCapability_genericMultiplexCapability = SEQ(name=u'genericMultiplexCapability', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'GenericCapability')))
    MultiplexCapability._cont = ASN1Dict([
        (u'nonStandard', _MultiplexCapability_nonStandard),
        (u'h222Capability', _MultiplexCapability_h222Capability),
        (u'h223Capability', _MultiplexCapability_h223Capability),
        (u'v76Capability', _MultiplexCapability_v76Capability),
        (u'h2250Capability', _MultiplexCapability_h2250Capability),
        (u'genericMultiplexCapability', _MultiplexCapability_genericMultiplexCapability),
        ])
    MultiplexCapability._ext = [u'h2250Capability', u'genericMultiplexCapability']
    
    #-----< H222Capability >-----#
    H222Capability = SEQ(name=u'H222Capability', mode=MODE_TYPE)
    _H222Capability_numberOfVCs = INT(name=u'numberOfVCs', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H222Capability_numberOfVCs._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    _H222Capability_vcCapability = SET_OF(name=u'vcCapability', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H222Capability_vcCapability__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'VCCapability')))
    _H222Capability_vcCapability._cont = __H222Capability_vcCapability__item_
    H222Capability._cont = ASN1Dict([
        (u'numberOfVCs', _H222Capability_numberOfVCs),
        (u'vcCapability', _H222Capability_vcCapability),
        ])
    H222Capability._ext = []
    
    #-----< VCCapability >-----#
    VCCapability = SEQ(name=u'VCCapability', mode=MODE_TYPE)
    _VCCapability_aal1 = SEQ(name=u'aal1', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __VCCapability_aal1_nullClockRecovery = BOOL(name=u'nullClockRecovery', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __VCCapability_aal1_srtsClockRecovery = BOOL(name=u'srtsClockRecovery', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __VCCapability_aal1_adaptiveClockRecovery = BOOL(name=u'adaptiveClockRecovery', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __VCCapability_aal1_nullErrorCorrection = BOOL(name=u'nullErrorCorrection', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __VCCapability_aal1_longInterleaver = BOOL(name=u'longInterleaver', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __VCCapability_aal1_shortInterleaver = BOOL(name=u'shortInterleaver', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __VCCapability_aal1_errorCorrectionOnly = BOOL(name=u'errorCorrectionOnly', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __VCCapability_aal1_structuredDataTransfer = BOOL(name=u'structuredDataTransfer', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __VCCapability_aal1_partiallyFilledCells = BOOL(name=u'partiallyFilledCells', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _VCCapability_aal1._cont = ASN1Dict([
        (u'nullClockRecovery', __VCCapability_aal1_nullClockRecovery),
        (u'srtsClockRecovery', __VCCapability_aal1_srtsClockRecovery),
        (u'adaptiveClockRecovery', __VCCapability_aal1_adaptiveClockRecovery),
        (u'nullErrorCorrection', __VCCapability_aal1_nullErrorCorrection),
        (u'longInterleaver', __VCCapability_aal1_longInterleaver),
        (u'shortInterleaver', __VCCapability_aal1_shortInterleaver),
        (u'errorCorrectionOnly', __VCCapability_aal1_errorCorrectionOnly),
        (u'structuredDataTransfer', __VCCapability_aal1_structuredDataTransfer),
        (u'partiallyFilledCells', __VCCapability_aal1_partiallyFilledCells),
        ])
    _VCCapability_aal1._ext = []
    _VCCapability_aal5 = SEQ(name=u'aal5', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __VCCapability_aal5_forwardMaximumSDUSize = INT(name=u'forwardMaximumSDUSize', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __VCCapability_aal5_forwardMaximumSDUSize._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    __VCCapability_aal5_backwardMaximumSDUSize = INT(name=u'backwardMaximumSDUSize', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __VCCapability_aal5_backwardMaximumSDUSize._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    _VCCapability_aal5._cont = ASN1Dict([
        (u'forwardMaximumSDUSize', __VCCapability_aal5_forwardMaximumSDUSize),
        (u'backwardMaximumSDUSize', __VCCapability_aal5_backwardMaximumSDUSize),
        ])
    _VCCapability_aal5._ext = []
    _VCCapability_transportStream = BOOL(name=u'transportStream', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _VCCapability_programStream = BOOL(name=u'programStream', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _VCCapability_availableBitRates = SEQ(name=u'availableBitRates', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __VCCapability_availableBitRates_type = CHOICE(name=u'type', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ___VCCapability_availableBitRates_type_singleBitRate = INT(name=u'singleBitRate', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___VCCapability_availableBitRates_type_singleBitRate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    ___VCCapability_availableBitRates_type_rangeOfBitRates = SEQ(name=u'rangeOfBitRates', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ____VCCapability_availableBitRates_type_rangeOfBitRates_lowerBitRate = INT(name=u'lowerBitRate', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ____VCCapability_availableBitRates_type_rangeOfBitRates_lowerBitRate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    ____VCCapability_availableBitRates_type_rangeOfBitRates_higherBitRate = INT(name=u'higherBitRate', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ____VCCapability_availableBitRates_type_rangeOfBitRates_higherBitRate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    ___VCCapability_availableBitRates_type_rangeOfBitRates._cont = ASN1Dict([
        (u'lowerBitRate', ____VCCapability_availableBitRates_type_rangeOfBitRates_lowerBitRate),
        (u'higherBitRate', ____VCCapability_availableBitRates_type_rangeOfBitRates_higherBitRate),
        ])
    ___VCCapability_availableBitRates_type_rangeOfBitRates._ext = None
    __VCCapability_availableBitRates_type._cont = ASN1Dict([
        (u'singleBitRate', ___VCCapability_availableBitRates_type_singleBitRate),
        (u'rangeOfBitRates', ___VCCapability_availableBitRates_type_rangeOfBitRates),
        ])
    __VCCapability_availableBitRates_type._ext = None
    _VCCapability_availableBitRates._cont = ASN1Dict([
        (u'type', __VCCapability_availableBitRates_type),
        ])
    _VCCapability_availableBitRates._ext = []
    _VCCapability_aal1ViaGateway = SEQ(name=u'aal1ViaGateway', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __VCCapability_aal1ViaGateway_gatewayAddress = SET_OF(name=u'gatewayAddress', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___VCCapability_aal1ViaGateway_gatewayAddress__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'Q2931Address')))
    __VCCapability_aal1ViaGateway_gatewayAddress._cont = ___VCCapability_aal1ViaGateway_gatewayAddress__item_
    __VCCapability_aal1ViaGateway_gatewayAddress._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    __VCCapability_aal1ViaGateway_nullClockRecovery = BOOL(name=u'nullClockRecovery', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __VCCapability_aal1ViaGateway_srtsClockRecovery = BOOL(name=u'srtsClockRecovery', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __VCCapability_aal1ViaGateway_adaptiveClockRecovery = BOOL(name=u'adaptiveClockRecovery', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __VCCapability_aal1ViaGateway_nullErrorCorrection = BOOL(name=u'nullErrorCorrection', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __VCCapability_aal1ViaGateway_longInterleaver = BOOL(name=u'longInterleaver', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __VCCapability_aal1ViaGateway_shortInterleaver = BOOL(name=u'shortInterleaver', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __VCCapability_aal1ViaGateway_errorCorrectionOnly = BOOL(name=u'errorCorrectionOnly', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __VCCapability_aal1ViaGateway_structuredDataTransfer = BOOL(name=u'structuredDataTransfer', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __VCCapability_aal1ViaGateway_partiallyFilledCells = BOOL(name=u'partiallyFilledCells', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _VCCapability_aal1ViaGateway._cont = ASN1Dict([
        (u'gatewayAddress', __VCCapability_aal1ViaGateway_gatewayAddress),
        (u'nullClockRecovery', __VCCapability_aal1ViaGateway_nullClockRecovery),
        (u'srtsClockRecovery', __VCCapability_aal1ViaGateway_srtsClockRecovery),
        (u'adaptiveClockRecovery', __VCCapability_aal1ViaGateway_adaptiveClockRecovery),
        (u'nullErrorCorrection', __VCCapability_aal1ViaGateway_nullErrorCorrection),
        (u'longInterleaver', __VCCapability_aal1ViaGateway_longInterleaver),
        (u'shortInterleaver', __VCCapability_aal1ViaGateway_shortInterleaver),
        (u'errorCorrectionOnly', __VCCapability_aal1ViaGateway_errorCorrectionOnly),
        (u'structuredDataTransfer', __VCCapability_aal1ViaGateway_structuredDataTransfer),
        (u'partiallyFilledCells', __VCCapability_aal1ViaGateway_partiallyFilledCells),
        ])
    _VCCapability_aal1ViaGateway._ext = []
    VCCapability._cont = ASN1Dict([
        (u'aal1', _VCCapability_aal1),
        (u'aal5', _VCCapability_aal5),
        (u'transportStream', _VCCapability_transportStream),
        (u'programStream', _VCCapability_programStream),
        (u'availableBitRates', _VCCapability_availableBitRates),
        (u'aal1ViaGateway', _VCCapability_aal1ViaGateway),
        ])
    VCCapability._ext = [u'aal1ViaGateway']
    
    #-----< H223Capability >-----#
    H223Capability = SEQ(name=u'H223Capability', mode=MODE_TYPE)
    _H223Capability_transportWithI_frames = BOOL(name=u'transportWithI-frames', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H223Capability_videoWithAL1 = BOOL(name=u'videoWithAL1', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H223Capability_videoWithAL2 = BOOL(name=u'videoWithAL2', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H223Capability_videoWithAL3 = BOOL(name=u'videoWithAL3', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H223Capability_audioWithAL1 = BOOL(name=u'audioWithAL1', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H223Capability_audioWithAL2 = BOOL(name=u'audioWithAL2', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H223Capability_audioWithAL3 = BOOL(name=u'audioWithAL3', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H223Capability_dataWithAL1 = BOOL(name=u'dataWithAL1', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H223Capability_dataWithAL2 = BOOL(name=u'dataWithAL2', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H223Capability_dataWithAL3 = BOOL(name=u'dataWithAL3', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H223Capability_maximumAl2SDUSize = INT(name=u'maximumAl2SDUSize', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H223Capability_maximumAl2SDUSize._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    _H223Capability_maximumAl3SDUSize = INT(name=u'maximumAl3SDUSize', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H223Capability_maximumAl3SDUSize._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    _H223Capability_maximumDelayJitter = INT(name=u'maximumDelayJitter', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H223Capability_maximumDelayJitter._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=1023)], ev=None, er=[])
    _H223Capability_h223MultiplexTableCapability = CHOICE(name=u'h223MultiplexTableCapability', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __H223Capability_h223MultiplexTableCapability_basic = NULL(name=u'basic', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H223Capability_h223MultiplexTableCapability_enhanced = SEQ(name=u'enhanced', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___H223Capability_h223MultiplexTableCapability_enhanced_maximumNestingDepth = INT(name=u'maximumNestingDepth', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___H223Capability_h223MultiplexTableCapability_enhanced_maximumNestingDepth._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=15)], ev=None, er=[])
    ___H223Capability_h223MultiplexTableCapability_enhanced_maximumElementListSize = INT(name=u'maximumElementListSize', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___H223Capability_h223MultiplexTableCapability_enhanced_maximumElementListSize._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=2, ub=255)], ev=None, er=[])
    ___H223Capability_h223MultiplexTableCapability_enhanced_maximumSubElementListSize = INT(name=u'maximumSubElementListSize', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___H223Capability_h223MultiplexTableCapability_enhanced_maximumSubElementListSize._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=2, ub=255)], ev=None, er=[])
    __H223Capability_h223MultiplexTableCapability_enhanced._cont = ASN1Dict([
        (u'maximumNestingDepth', ___H223Capability_h223MultiplexTableCapability_enhanced_maximumNestingDepth),
        (u'maximumElementListSize', ___H223Capability_h223MultiplexTableCapability_enhanced_maximumElementListSize),
        (u'maximumSubElementListSize', ___H223Capability_h223MultiplexTableCapability_enhanced_maximumSubElementListSize),
        ])
    __H223Capability_h223MultiplexTableCapability_enhanced._ext = []
    _H223Capability_h223MultiplexTableCapability._cont = ASN1Dict([
        (u'basic', __H223Capability_h223MultiplexTableCapability_basic),
        (u'enhanced', __H223Capability_h223MultiplexTableCapability_enhanced),
        ])
    _H223Capability_h223MultiplexTableCapability._ext = None
    _H223Capability_maxMUXPDUSizeCapability = BOOL(name=u'maxMUXPDUSizeCapability', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H223Capability_nsrpSupport = BOOL(name=u'nsrpSupport', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H223Capability_mobileOperationTransmitCapability = SEQ(name=u'mobileOperationTransmitCapability', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __H223Capability_mobileOperationTransmitCapability_modeChangeCapability = BOOL(name=u'modeChangeCapability', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H223Capability_mobileOperationTransmitCapability_h223AnnexA = BOOL(name=u'h223AnnexA', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H223Capability_mobileOperationTransmitCapability_h223AnnexADoubleFlag = BOOL(name=u'h223AnnexADoubleFlag', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H223Capability_mobileOperationTransmitCapability_h223AnnexB = BOOL(name=u'h223AnnexB', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H223Capability_mobileOperationTransmitCapability_h223AnnexBwithHeader = BOOL(name=u'h223AnnexBwithHeader', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H223Capability_mobileOperationTransmitCapability._cont = ASN1Dict([
        (u'modeChangeCapability', __H223Capability_mobileOperationTransmitCapability_modeChangeCapability),
        (u'h223AnnexA', __H223Capability_mobileOperationTransmitCapability_h223AnnexA),
        (u'h223AnnexADoubleFlag', __H223Capability_mobileOperationTransmitCapability_h223AnnexADoubleFlag),
        (u'h223AnnexB', __H223Capability_mobileOperationTransmitCapability_h223AnnexB),
        (u'h223AnnexBwithHeader', __H223Capability_mobileOperationTransmitCapability_h223AnnexBwithHeader),
        ])
    _H223Capability_mobileOperationTransmitCapability._ext = []
    _H223Capability_h223AnnexCCapability = SEQ(name=u'h223AnnexCCapability', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H223AnnexCCapability')), opt=True)
    _H223Capability_bitRate = INT(name=u'bitRate', mode=MODE_TYPE, tag=(18, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _H223Capability_bitRate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=19200)], ev=None, er=[])
    _H223Capability_mobileMultilinkFrameCapability = SEQ(name=u'mobileMultilinkFrameCapability', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __H223Capability_mobileMultilinkFrameCapability_maximumSampleSize = INT(name=u'maximumSampleSize', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H223Capability_mobileMultilinkFrameCapability_maximumSampleSize._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=255)], ev=None, er=[])
    __H223Capability_mobileMultilinkFrameCapability_maximumPayloadLength = INT(name=u'maximumPayloadLength', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H223Capability_mobileMultilinkFrameCapability_maximumPayloadLength._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65025)], ev=None, er=[])
    _H223Capability_mobileMultilinkFrameCapability._cont = ASN1Dict([
        (u'maximumSampleSize', __H223Capability_mobileMultilinkFrameCapability_maximumSampleSize),
        (u'maximumPayloadLength', __H223Capability_mobileMultilinkFrameCapability_maximumPayloadLength),
        ])
    _H223Capability_mobileMultilinkFrameCapability._ext = []
    H223Capability._cont = ASN1Dict([
        (u'transportWithI-frames', _H223Capability_transportWithI_frames),
        (u'videoWithAL1', _H223Capability_videoWithAL1),
        (u'videoWithAL2', _H223Capability_videoWithAL2),
        (u'videoWithAL3', _H223Capability_videoWithAL3),
        (u'audioWithAL1', _H223Capability_audioWithAL1),
        (u'audioWithAL2', _H223Capability_audioWithAL2),
        (u'audioWithAL3', _H223Capability_audioWithAL3),
        (u'dataWithAL1', _H223Capability_dataWithAL1),
        (u'dataWithAL2', _H223Capability_dataWithAL2),
        (u'dataWithAL3', _H223Capability_dataWithAL3),
        (u'maximumAl2SDUSize', _H223Capability_maximumAl2SDUSize),
        (u'maximumAl3SDUSize', _H223Capability_maximumAl3SDUSize),
        (u'maximumDelayJitter', _H223Capability_maximumDelayJitter),
        (u'h223MultiplexTableCapability', _H223Capability_h223MultiplexTableCapability),
        (u'maxMUXPDUSizeCapability', _H223Capability_maxMUXPDUSizeCapability),
        (u'nsrpSupport', _H223Capability_nsrpSupport),
        (u'mobileOperationTransmitCapability', _H223Capability_mobileOperationTransmitCapability),
        (u'h223AnnexCCapability', _H223Capability_h223AnnexCCapability),
        (u'bitRate', _H223Capability_bitRate),
        (u'mobileMultilinkFrameCapability', _H223Capability_mobileMultilinkFrameCapability),
        ])
    H223Capability._ext = [u'maxMUXPDUSizeCapability', u'nsrpSupport', u'mobileOperationTransmitCapability', u'h223AnnexCCapability', u'bitRate', u'mobileMultilinkFrameCapability']
    
    #-----< H223AnnexCCapability >-----#
    H223AnnexCCapability = SEQ(name=u'H223AnnexCCapability', mode=MODE_TYPE)
    _H223AnnexCCapability_videoWithAL1M = BOOL(name=u'videoWithAL1M', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H223AnnexCCapability_videoWithAL2M = BOOL(name=u'videoWithAL2M', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H223AnnexCCapability_videoWithAL3M = BOOL(name=u'videoWithAL3M', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H223AnnexCCapability_audioWithAL1M = BOOL(name=u'audioWithAL1M', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H223AnnexCCapability_audioWithAL2M = BOOL(name=u'audioWithAL2M', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H223AnnexCCapability_audioWithAL3M = BOOL(name=u'audioWithAL3M', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H223AnnexCCapability_dataWithAL1M = BOOL(name=u'dataWithAL1M', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H223AnnexCCapability_dataWithAL2M = BOOL(name=u'dataWithAL2M', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H223AnnexCCapability_dataWithAL3M = BOOL(name=u'dataWithAL3M', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H223AnnexCCapability_alpduInterleaving = BOOL(name=u'alpduInterleaving', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H223AnnexCCapability_maximumAL1MPDUSize = INT(name=u'maximumAL1MPDUSize', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H223AnnexCCapability_maximumAL1MPDUSize._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    _H223AnnexCCapability_maximumAL2MSDUSize = INT(name=u'maximumAL2MSDUSize', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H223AnnexCCapability_maximumAL2MSDUSize._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    _H223AnnexCCapability_maximumAL3MSDUSize = INT(name=u'maximumAL3MSDUSize', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H223AnnexCCapability_maximumAL3MSDUSize._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    _H223AnnexCCapability_rsCodeCapability = BOOL(name=u'rsCodeCapability', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    H223AnnexCCapability._cont = ASN1Dict([
        (u'videoWithAL1M', _H223AnnexCCapability_videoWithAL1M),
        (u'videoWithAL2M', _H223AnnexCCapability_videoWithAL2M),
        (u'videoWithAL3M', _H223AnnexCCapability_videoWithAL3M),
        (u'audioWithAL1M', _H223AnnexCCapability_audioWithAL1M),
        (u'audioWithAL2M', _H223AnnexCCapability_audioWithAL2M),
        (u'audioWithAL3M', _H223AnnexCCapability_audioWithAL3M),
        (u'dataWithAL1M', _H223AnnexCCapability_dataWithAL1M),
        (u'dataWithAL2M', _H223AnnexCCapability_dataWithAL2M),
        (u'dataWithAL3M', _H223AnnexCCapability_dataWithAL3M),
        (u'alpduInterleaving', _H223AnnexCCapability_alpduInterleaving),
        (u'maximumAL1MPDUSize', _H223AnnexCCapability_maximumAL1MPDUSize),
        (u'maximumAL2MSDUSize', _H223AnnexCCapability_maximumAL2MSDUSize),
        (u'maximumAL3MSDUSize', _H223AnnexCCapability_maximumAL3MSDUSize),
        (u'rsCodeCapability', _H223AnnexCCapability_rsCodeCapability),
        ])
    H223AnnexCCapability._ext = [u'rsCodeCapability']
    
    #-----< V76Capability >-----#
    V76Capability = SEQ(name=u'V76Capability', mode=MODE_TYPE)
    _V76Capability_suspendResumeCapabilitywAddress = BOOL(name=u'suspendResumeCapabilitywAddress', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _V76Capability_suspendResumeCapabilitywoAddress = BOOL(name=u'suspendResumeCapabilitywoAddress', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _V76Capability_rejCapability = BOOL(name=u'rejCapability', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _V76Capability_sREJCapability = BOOL(name=u'sREJCapability', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _V76Capability_mREJCapability = BOOL(name=u'mREJCapability', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _V76Capability_crc8bitCapability = BOOL(name=u'crc8bitCapability', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _V76Capability_crc16bitCapability = BOOL(name=u'crc16bitCapability', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _V76Capability_crc32bitCapability = BOOL(name=u'crc32bitCapability', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _V76Capability_uihCapability = BOOL(name=u'uihCapability', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _V76Capability_numOfDLCS = INT(name=u'numOfDLCS', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _V76Capability_numOfDLCS._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=2, ub=8191)], ev=None, er=[])
    _V76Capability_twoOctetAddressFieldCapability = BOOL(name=u'twoOctetAddressFieldCapability', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _V76Capability_loopBackTestCapability = BOOL(name=u'loopBackTestCapability', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _V76Capability_n401Capability = INT(name=u'n401Capability', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _V76Capability_n401Capability._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4095)], ev=None, er=[])
    _V76Capability_maxWindowSizeCapability = INT(name=u'maxWindowSizeCapability', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _V76Capability_maxWindowSizeCapability._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=127)], ev=None, er=[])
    _V76Capability_v75Capability = SEQ(name=u'v75Capability', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'V75Capability')))
    V76Capability._cont = ASN1Dict([
        (u'suspendResumeCapabilitywAddress', _V76Capability_suspendResumeCapabilitywAddress),
        (u'suspendResumeCapabilitywoAddress', _V76Capability_suspendResumeCapabilitywoAddress),
        (u'rejCapability', _V76Capability_rejCapability),
        (u'sREJCapability', _V76Capability_sREJCapability),
        (u'mREJCapability', _V76Capability_mREJCapability),
        (u'crc8bitCapability', _V76Capability_crc8bitCapability),
        (u'crc16bitCapability', _V76Capability_crc16bitCapability),
        (u'crc32bitCapability', _V76Capability_crc32bitCapability),
        (u'uihCapability', _V76Capability_uihCapability),
        (u'numOfDLCS', _V76Capability_numOfDLCS),
        (u'twoOctetAddressFieldCapability', _V76Capability_twoOctetAddressFieldCapability),
        (u'loopBackTestCapability', _V76Capability_loopBackTestCapability),
        (u'n401Capability', _V76Capability_n401Capability),
        (u'maxWindowSizeCapability', _V76Capability_maxWindowSizeCapability),
        (u'v75Capability', _V76Capability_v75Capability),
        ])
    V76Capability._ext = []
    
    #-----< V75Capability >-----#
    V75Capability = SEQ(name=u'V75Capability', mode=MODE_TYPE)
    _V75Capability_audioHeader = BOOL(name=u'audioHeader', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    V75Capability._cont = ASN1Dict([
        (u'audioHeader', _V75Capability_audioHeader),
        ])
    V75Capability._ext = []
    
    #-----< H2250Capability >-----#
    H2250Capability = SEQ(name=u'H2250Capability', mode=MODE_TYPE)
    _H2250Capability_maximumAudioDelayJitter = INT(name=u'maximumAudioDelayJitter', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H2250Capability_maximumAudioDelayJitter._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=1023)], ev=None, er=[])
    _H2250Capability_receiveMultipointCapability = SEQ(name=u'receiveMultipointCapability', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MultipointCapability')))
    _H2250Capability_transmitMultipointCapability = SEQ(name=u'transmitMultipointCapability', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MultipointCapability')))
    _H2250Capability_receiveAndTransmitMultipointCapability = SEQ(name=u'receiveAndTransmitMultipointCapability', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MultipointCapability')))
    _H2250Capability_mcCapability = SEQ(name=u'mcCapability', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H2250Capability_mcCapability_centralizedConferenceMC = BOOL(name=u'centralizedConferenceMC', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H2250Capability_mcCapability_decentralizedConferenceMC = BOOL(name=u'decentralizedConferenceMC', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H2250Capability_mcCapability._cont = ASN1Dict([
        (u'centralizedConferenceMC', __H2250Capability_mcCapability_centralizedConferenceMC),
        (u'decentralizedConferenceMC', __H2250Capability_mcCapability_decentralizedConferenceMC),
        ])
    _H2250Capability_mcCapability._ext = []
    _H2250Capability_rtcpVideoControlCapability = BOOL(name=u'rtcpVideoControlCapability', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H2250Capability_mediaPacketizationCapability = SEQ(name=u'mediaPacketizationCapability', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MediaPacketizationCapability')))
    _H2250Capability_transportCapability = SEQ(name=u'transportCapability', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TransportCapability')), opt=True)
    _H2250Capability_redundancyEncodingCapability = SEQ_OF(name=u'redundancyEncodingCapability', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __H2250Capability_redundancyEncodingCapability__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'RedundancyEncodingCapability')))
    _H2250Capability_redundancyEncodingCapability._cont = __H2250Capability_redundancyEncodingCapability__item_
    _H2250Capability_redundancyEncodingCapability._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    _H2250Capability_logicalChannelSwitchingCapability = BOOL(name=u'logicalChannelSwitchingCapability', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H2250Capability_t120DynamicPortCapability = BOOL(name=u't120DynamicPortCapability', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    H2250Capability._cont = ASN1Dict([
        (u'maximumAudioDelayJitter', _H2250Capability_maximumAudioDelayJitter),
        (u'receiveMultipointCapability', _H2250Capability_receiveMultipointCapability),
        (u'transmitMultipointCapability', _H2250Capability_transmitMultipointCapability),
        (u'receiveAndTransmitMultipointCapability', _H2250Capability_receiveAndTransmitMultipointCapability),
        (u'mcCapability', _H2250Capability_mcCapability),
        (u'rtcpVideoControlCapability', _H2250Capability_rtcpVideoControlCapability),
        (u'mediaPacketizationCapability', _H2250Capability_mediaPacketizationCapability),
        (u'transportCapability', _H2250Capability_transportCapability),
        (u'redundancyEncodingCapability', _H2250Capability_redundancyEncodingCapability),
        (u'logicalChannelSwitchingCapability', _H2250Capability_logicalChannelSwitchingCapability),
        (u't120DynamicPortCapability', _H2250Capability_t120DynamicPortCapability),
        ])
    H2250Capability._ext = [u'transportCapability', u'redundancyEncodingCapability', u'logicalChannelSwitchingCapability', u't120DynamicPortCapability']
    
    #-----< MediaPacketizationCapability >-----#
    MediaPacketizationCapability = SEQ(name=u'MediaPacketizationCapability', mode=MODE_TYPE)
    _MediaPacketizationCapability_h261aVideoPacketization = BOOL(name=u'h261aVideoPacketization', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MediaPacketizationCapability_rtpPayloadType = SEQ_OF(name=u'rtpPayloadType', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __MediaPacketizationCapability_rtpPayloadType__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'RTPPayloadType')))
    _MediaPacketizationCapability_rtpPayloadType._cont = __MediaPacketizationCapability_rtpPayloadType__item_
    _MediaPacketizationCapability_rtpPayloadType._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    MediaPacketizationCapability._cont = ASN1Dict([
        (u'h261aVideoPacketization', _MediaPacketizationCapability_h261aVideoPacketization),
        (u'rtpPayloadType', _MediaPacketizationCapability_rtpPayloadType),
        ])
    MediaPacketizationCapability._ext = [u'rtpPayloadType']
    
    #-----< RSVPParameters >-----#
    RSVPParameters = SEQ(name=u'RSVPParameters', mode=MODE_TYPE)
    _RSVPParameters_qosMode = CHOICE(name=u'qosMode', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'QOSMode')), opt=True)
    _RSVPParameters_tokenRate = INT(name=u'tokenRate', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _RSVPParameters_tokenRate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4294967295)], ev=None, er=[])
    _RSVPParameters_bucketSize = INT(name=u'bucketSize', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _RSVPParameters_bucketSize._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4294967295)], ev=None, er=[])
    _RSVPParameters_peakRate = INT(name=u'peakRate', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _RSVPParameters_peakRate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4294967295)], ev=None, er=[])
    _RSVPParameters_minPoliced = INT(name=u'minPoliced', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _RSVPParameters_minPoliced._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4294967295)], ev=None, er=[])
    _RSVPParameters_maxPktSize = INT(name=u'maxPktSize', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _RSVPParameters_maxPktSize._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4294967295)], ev=None, er=[])
    RSVPParameters._cont = ASN1Dict([
        (u'qosMode', _RSVPParameters_qosMode),
        (u'tokenRate', _RSVPParameters_tokenRate),
        (u'bucketSize', _RSVPParameters_bucketSize),
        (u'peakRate', _RSVPParameters_peakRate),
        (u'minPoliced', _RSVPParameters_minPoliced),
        (u'maxPktSize', _RSVPParameters_maxPktSize),
        ])
    RSVPParameters._ext = []
    
    #-----< QOSMode >-----#
    QOSMode = CHOICE(name=u'QOSMode', mode=MODE_TYPE)
    _QOSMode_guaranteedQOS = NULL(name=u'guaranteedQOS', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _QOSMode_controlledLoad = NULL(name=u'controlledLoad', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    QOSMode._cont = ASN1Dict([
        (u'guaranteedQOS', _QOSMode_guaranteedQOS),
        (u'controlledLoad', _QOSMode_controlledLoad),
        ])
    QOSMode._ext = []
    
    #-----< ATMParameters >-----#
    ATMParameters = SEQ(name=u'ATMParameters', mode=MODE_TYPE)
    _ATMParameters_maxNTUSize = INT(name=u'maxNTUSize', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ATMParameters_maxNTUSize._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    _ATMParameters_atmUBR = BOOL(name=u'atmUBR', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ATMParameters_atmrtVBR = BOOL(name=u'atmrtVBR', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ATMParameters_atmnrtVBR = BOOL(name=u'atmnrtVBR', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ATMParameters_atmABR = BOOL(name=u'atmABR', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ATMParameters_atmCBR = BOOL(name=u'atmCBR', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ATMParameters._cont = ASN1Dict([
        (u'maxNTUSize', _ATMParameters_maxNTUSize),
        (u'atmUBR', _ATMParameters_atmUBR),
        (u'atmrtVBR', _ATMParameters_atmrtVBR),
        (u'atmnrtVBR', _ATMParameters_atmnrtVBR),
        (u'atmABR', _ATMParameters_atmABR),
        (u'atmCBR', _ATMParameters_atmCBR),
        ])
    ATMParameters._ext = []
    
    #-----< ServicePriorityValue >-----#
    ServicePriorityValue = SEQ(name=u'ServicePriorityValue', mode=MODE_TYPE)
    _ServicePriorityValue_nonStandardParameter = SEQ(name=u'nonStandardParameter', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')), opt=True)
    _ServicePriorityValue_value = INT(name=u'value', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ServicePriorityValue_value._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    ServicePriorityValue._cont = ASN1Dict([
        (u'nonStandardParameter', _ServicePriorityValue_nonStandardParameter),
        (u'value', _ServicePriorityValue_value),
        ])
    ServicePriorityValue._ext = [u'value']
    
    #-----< ServicePriority >-----#
    ServicePriority = SEQ(name=u'ServicePriority', mode=MODE_TYPE)
    _ServicePriority_nonStandardData = SEQ(name=u'nonStandardData', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')), opt=True)
    _ServicePriority_servicePrioritySignalled = BOOL(name=u'servicePrioritySignalled', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ServicePriority_servicePriorityValue = SEQ(name=u'servicePriorityValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'ServicePriorityValue')), opt=True)
    _ServicePriority_serviceClass = INT(name=u'serviceClass', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _ServicePriority_serviceClass._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4095)], ev=None, er=[])
    _ServicePriority_serviceSubclass = INT(name=u'serviceSubclass', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _ServicePriority_serviceSubclass._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    ServicePriority._cont = ASN1Dict([
        (u'nonStandardData', _ServicePriority_nonStandardData),
        (u'servicePrioritySignalled', _ServicePriority_servicePrioritySignalled),
        (u'servicePriorityValue', _ServicePriority_servicePriorityValue),
        (u'serviceClass', _ServicePriority_serviceClass),
        (u'serviceSubclass', _ServicePriority_serviceSubclass),
        ])
    ServicePriority._ext = [u'serviceClass', u'serviceSubclass']
    
    #-----< AuthorizationParameters >-----#
    AuthorizationParameters = SEQ(name=u'AuthorizationParameters', mode=MODE_TYPE)
    _AuthorizationParameters_nonStandardData = SEQ(name=u'nonStandardData', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')), opt=True)
    AuthorizationParameters._cont = ASN1Dict([
        (u'nonStandardData', _AuthorizationParameters_nonStandardData),
        ])
    AuthorizationParameters._ext = []
    
    #-----< QOSType >-----#
    QOSType = CHOICE(name=u'QOSType', mode=MODE_TYPE)
    _QOSType_desired = NULL(name=u'desired', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _QOSType_required = NULL(name=u'required', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    QOSType._cont = ASN1Dict([
        (u'desired', _QOSType_desired),
        (u'required', _QOSType_required),
        ])
    QOSType._ext = []
    
    #-----< QOSClass >-----#
    QOSClass = CHOICE(name=u'QOSClass', mode=MODE_TYPE)
    _QOSClass_class0 = NULL(name=u'class0', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _QOSClass_class1 = NULL(name=u'class1', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _QOSClass_class2 = NULL(name=u'class2', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _QOSClass_class3 = NULL(name=u'class3', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _QOSClass_class4 = NULL(name=u'class4', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _QOSClass_class5 = NULL(name=u'class5', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    QOSClass._cont = ASN1Dict([
        (u'class0', _QOSClass_class0),
        (u'class1', _QOSClass_class1),
        (u'class2', _QOSClass_class2),
        (u'class3', _QOSClass_class3),
        (u'class4', _QOSClass_class4),
        (u'class5', _QOSClass_class5),
        ])
    QOSClass._ext = []
    
    #-----< QOSDescriptor >-----#
    QOSDescriptor = SEQ(name=u'QOSDescriptor', mode=MODE_TYPE)
    _QOSDescriptor_nonStandardData = SEQ(name=u'nonStandardData', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')), opt=True)
    _QOSDescriptor_qosType = CHOICE(name=u'qosType', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'QOSType')))
    _QOSDescriptor_qosClass = CHOICE(name=u'qosClass', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'QOSClass')))
    QOSDescriptor._cont = ASN1Dict([
        (u'nonStandardData', _QOSDescriptor_nonStandardData),
        (u'qosType', _QOSDescriptor_qosType),
        (u'qosClass', _QOSDescriptor_qosClass),
        ])
    QOSDescriptor._ext = []
    
    #-----< GenericTransportParameters >-----#
    GenericTransportParameters = SEQ(name=u'GenericTransportParameters', mode=MODE_TYPE)
    _GenericTransportParameters_nonStandardData = SEQ(name=u'nonStandardData', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')), opt=True)
    _GenericTransportParameters_averageRate = INT(name=u'averageRate', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GenericTransportParameters_averageRate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4294967295)], ev=None, er=[])
    _GenericTransportParameters_burst = INT(name=u'burst', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GenericTransportParameters_burst._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4294967295)], ev=None, er=[])
    _GenericTransportParameters_peakRate = INT(name=u'peakRate', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GenericTransportParameters_peakRate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4294967295)], ev=None, er=[])
    _GenericTransportParameters_maxPktSize = INT(name=u'maxPktSize', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GenericTransportParameters_maxPktSize._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4294967295)], ev=None, er=[])
    GenericTransportParameters._cont = ASN1Dict([
        (u'nonStandardData', _GenericTransportParameters_nonStandardData),
        (u'averageRate', _GenericTransportParameters_averageRate),
        (u'burst', _GenericTransportParameters_burst),
        (u'peakRate', _GenericTransportParameters_peakRate),
        (u'maxPktSize', _GenericTransportParameters_maxPktSize),
        ])
    GenericTransportParameters._ext = []
    
    #-----< QOSCapability >-----#
    QOSCapability = SEQ(name=u'QOSCapability', mode=MODE_TYPE)
    _QOSCapability_nonStandardData = SEQ(name=u'nonStandardData', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')), opt=True)
    _QOSCapability_rsvpParameters = SEQ(name=u'rsvpParameters', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'RSVPParameters')), opt=True)
    _QOSCapability_atmParameters = SEQ(name=u'atmParameters', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'ATMParameters')), opt=True)
    _QOSCapability_localQoS = BOOL(name=u'localQoS', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _QOSCapability_genericTransportParameters = SEQ(name=u'genericTransportParameters', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'GenericTransportParameters')), opt=True)
    _QOSCapability_servicePriority = SEQ(name=u'servicePriority', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'ServicePriority')), opt=True)
    _QOSCapability_authorizationParameter = SEQ(name=u'authorizationParameter', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'AuthorizationParameters')), opt=True)
    _QOSCapability_qosDescriptor = SEQ(name=u'qosDescriptor', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'QOSDescriptor')), opt=True)
    _QOSCapability_dscpValue = INT(name=u'dscpValue', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _QOSCapability_dscpValue._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    QOSCapability._cont = ASN1Dict([
        (u'nonStandardData', _QOSCapability_nonStandardData),
        (u'rsvpParameters', _QOSCapability_rsvpParameters),
        (u'atmParameters', _QOSCapability_atmParameters),
        (u'localQoS', _QOSCapability_localQoS),
        (u'genericTransportParameters', _QOSCapability_genericTransportParameters),
        (u'servicePriority', _QOSCapability_servicePriority),
        (u'authorizationParameter', _QOSCapability_authorizationParameter),
        (u'qosDescriptor', _QOSCapability_qosDescriptor),
        (u'dscpValue', _QOSCapability_dscpValue),
        ])
    QOSCapability._ext = [u'localQoS', u'genericTransportParameters', u'servicePriority', u'authorizationParameter', u'qosDescriptor', u'dscpValue']
    
    #-----< MediaTransportType >-----#
    MediaTransportType = CHOICE(name=u'MediaTransportType', mode=MODE_TYPE)
    _MediaTransportType_ip_UDP = NULL(name=u'ip-UDP', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MediaTransportType_ip_TCP = NULL(name=u'ip-TCP', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MediaTransportType_atm_AAL5_UNIDIR = NULL(name=u'atm-AAL5-UNIDIR', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MediaTransportType_atm_AAL5_BIDIR = NULL(name=u'atm-AAL5-BIDIR', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MediaTransportType_atm_AAL5_compressed = SEQ(name=u'atm-AAL5-compressed', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MediaTransportType_atm_AAL5_compressed_variable_delta = BOOL(name=u'variable-delta', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MediaTransportType_atm_AAL5_compressed._cont = ASN1Dict([
        (u'variable-delta', __MediaTransportType_atm_AAL5_compressed_variable_delta),
        ])
    _MediaTransportType_atm_AAL5_compressed._ext = []
    MediaTransportType._cont = ASN1Dict([
        (u'ip-UDP', _MediaTransportType_ip_UDP),
        (u'ip-TCP', _MediaTransportType_ip_TCP),
        (u'atm-AAL5-UNIDIR', _MediaTransportType_atm_AAL5_UNIDIR),
        (u'atm-AAL5-BIDIR', _MediaTransportType_atm_AAL5_BIDIR),
        (u'atm-AAL5-compressed', _MediaTransportType_atm_AAL5_compressed),
        ])
    MediaTransportType._ext = [u'atm-AAL5-compressed']
    
    #-----< MediaChannelCapability >-----#
    MediaChannelCapability = SEQ(name=u'MediaChannelCapability', mode=MODE_TYPE)
    _MediaChannelCapability_mediaTransport = CHOICE(name=u'mediaTransport', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MediaTransportType')), opt=True)
    MediaChannelCapability._cont = ASN1Dict([
        (u'mediaTransport', _MediaChannelCapability_mediaTransport),
        ])
    MediaChannelCapability._ext = []
    
    #-----< TransportCapability >-----#
    TransportCapability = SEQ(name=u'TransportCapability', mode=MODE_TYPE)
    _TransportCapability_nonStandard = SEQ(name=u'nonStandard', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')), opt=True)
    _TransportCapability_qOSCapabilities = SEQ_OF(name=u'qOSCapabilities', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __TransportCapability_qOSCapabilities__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'QOSCapability')))
    _TransportCapability_qOSCapabilities._cont = __TransportCapability_qOSCapabilities__item_
    _TransportCapability_qOSCapabilities._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    _TransportCapability_mediaChannelCapabilities = SEQ_OF(name=u'mediaChannelCapabilities', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __TransportCapability_mediaChannelCapabilities__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MediaChannelCapability')))
    _TransportCapability_mediaChannelCapabilities._cont = __TransportCapability_mediaChannelCapabilities__item_
    _TransportCapability_mediaChannelCapabilities._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    TransportCapability._cont = ASN1Dict([
        (u'nonStandard', _TransportCapability_nonStandard),
        (u'qOSCapabilities', _TransportCapability_qOSCapabilities),
        (u'mediaChannelCapabilities', _TransportCapability_mediaChannelCapabilities),
        ])
    TransportCapability._ext = []
    
    #-----< RedundancyEncodingCapability >-----#
    RedundancyEncodingCapability = SEQ(name=u'RedundancyEncodingCapability', mode=MODE_TYPE)
    _RedundancyEncodingCapability_redundancyEncodingMethod = CHOICE(name=u'redundancyEncodingMethod', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'RedundancyEncodingMethod')))
    _RedundancyEncodingCapability_primaryEncoding = INT(name=u'primaryEncoding', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'CapabilityTableEntryNumber')))
    _RedundancyEncodingCapability_secondaryEncoding = SEQ_OF(name=u'secondaryEncoding', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __RedundancyEncodingCapability_secondaryEncoding__item_ = INT(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'CapabilityTableEntryNumber')))
    _RedundancyEncodingCapability_secondaryEncoding._cont = __RedundancyEncodingCapability_secondaryEncoding__item_
    _RedundancyEncodingCapability_secondaryEncoding._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    RedundancyEncodingCapability._cont = ASN1Dict([
        (u'redundancyEncodingMethod', _RedundancyEncodingCapability_redundancyEncodingMethod),
        (u'primaryEncoding', _RedundancyEncodingCapability_primaryEncoding),
        (u'secondaryEncoding', _RedundancyEncodingCapability_secondaryEncoding),
        ])
    RedundancyEncodingCapability._ext = []
    
    #-----< RedundancyEncodingMethod >-----#
    RedundancyEncodingMethod = CHOICE(name=u'RedundancyEncodingMethod', mode=MODE_TYPE)
    _RedundancyEncodingMethod_nonStandard = SEQ(name=u'nonStandard', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')))
    _RedundancyEncodingMethod_rtpAudioRedundancyEncoding = NULL(name=u'rtpAudioRedundancyEncoding', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _RedundancyEncodingMethod_rtpH263VideoRedundancyEncoding = SEQ(name=u'rtpH263VideoRedundancyEncoding', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'RTPH263VideoRedundancyEncoding')))
    RedundancyEncodingMethod._cont = ASN1Dict([
        (u'nonStandard', _RedundancyEncodingMethod_nonStandard),
        (u'rtpAudioRedundancyEncoding', _RedundancyEncodingMethod_rtpAudioRedundancyEncoding),
        (u'rtpH263VideoRedundancyEncoding', _RedundancyEncodingMethod_rtpH263VideoRedundancyEncoding),
        ])
    RedundancyEncodingMethod._ext = [u'rtpH263VideoRedundancyEncoding']
    
    #-----< RTPH263VideoRedundancyEncoding >-----#
    RTPH263VideoRedundancyEncoding = SEQ(name=u'RTPH263VideoRedundancyEncoding', mode=MODE_TYPE)
    _RTPH263VideoRedundancyEncoding_numberOfThreads = INT(name=u'numberOfThreads', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _RTPH263VideoRedundancyEncoding_numberOfThreads._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    _RTPH263VideoRedundancyEncoding_framesBetweenSyncPoints = INT(name=u'framesBetweenSyncPoints', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _RTPH263VideoRedundancyEncoding_framesBetweenSyncPoints._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    _RTPH263VideoRedundancyEncoding_frameToThreadMapping = CHOICE(name=u'frameToThreadMapping', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __RTPH263VideoRedundancyEncoding_frameToThreadMapping_roundrobin = NULL(name=u'roundrobin', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __RTPH263VideoRedundancyEncoding_frameToThreadMapping_custom = SEQ_OF(name=u'custom', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___RTPH263VideoRedundancyEncoding_frameToThreadMapping_custom__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'RTPH263VideoRedundancyFrameMapping')))
    __RTPH263VideoRedundancyEncoding_frameToThreadMapping_custom._cont = ___RTPH263VideoRedundancyEncoding_frameToThreadMapping_custom__item_
    __RTPH263VideoRedundancyEncoding_frameToThreadMapping_custom._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    _RTPH263VideoRedundancyEncoding_frameToThreadMapping._cont = ASN1Dict([
        (u'roundrobin', __RTPH263VideoRedundancyEncoding_frameToThreadMapping_roundrobin),
        (u'custom', __RTPH263VideoRedundancyEncoding_frameToThreadMapping_custom),
        ])
    _RTPH263VideoRedundancyEncoding_frameToThreadMapping._ext = []
    _RTPH263VideoRedundancyEncoding_containedThreads = SEQ_OF(name=u'containedThreads', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __RTPH263VideoRedundancyEncoding_containedThreads__item_ = INT(name='_item_', mode=MODE_TYPE)
    __RTPH263VideoRedundancyEncoding_containedThreads__item_._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=15)], ev=None, er=[])
    _RTPH263VideoRedundancyEncoding_containedThreads._cont = __RTPH263VideoRedundancyEncoding_containedThreads__item_
    _RTPH263VideoRedundancyEncoding_containedThreads._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    RTPH263VideoRedundancyEncoding._cont = ASN1Dict([
        (u'numberOfThreads', _RTPH263VideoRedundancyEncoding_numberOfThreads),
        (u'framesBetweenSyncPoints', _RTPH263VideoRedundancyEncoding_framesBetweenSyncPoints),
        (u'frameToThreadMapping', _RTPH263VideoRedundancyEncoding_frameToThreadMapping),
        (u'containedThreads', _RTPH263VideoRedundancyEncoding_containedThreads),
        ])
    RTPH263VideoRedundancyEncoding._ext = []
    
    #-----< RTPH263VideoRedundancyFrameMapping >-----#
    RTPH263VideoRedundancyFrameMapping = SEQ(name=u'RTPH263VideoRedundancyFrameMapping', mode=MODE_TYPE)
    _RTPH263VideoRedundancyFrameMapping_threadNumber = INT(name=u'threadNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _RTPH263VideoRedundancyFrameMapping_threadNumber._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=15)], ev=None, er=[])
    _RTPH263VideoRedundancyFrameMapping_frameSequence = SEQ_OF(name=u'frameSequence', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __RTPH263VideoRedundancyFrameMapping_frameSequence__item_ = INT(name='_item_', mode=MODE_TYPE)
    __RTPH263VideoRedundancyFrameMapping_frameSequence__item_._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _RTPH263VideoRedundancyFrameMapping_frameSequence._cont = __RTPH263VideoRedundancyFrameMapping_frameSequence__item_
    _RTPH263VideoRedundancyFrameMapping_frameSequence._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    RTPH263VideoRedundancyFrameMapping._cont = ASN1Dict([
        (u'threadNumber', _RTPH263VideoRedundancyFrameMapping_threadNumber),
        (u'frameSequence', _RTPH263VideoRedundancyFrameMapping_frameSequence),
        ])
    RTPH263VideoRedundancyFrameMapping._ext = []
    
    #-----< MultipointCapability >-----#
    MultipointCapability = SEQ(name=u'MultipointCapability', mode=MODE_TYPE)
    _MultipointCapability_multicastCapability = BOOL(name=u'multicastCapability', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MultipointCapability_multiUniCastConference = BOOL(name=u'multiUniCastConference', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MultipointCapability_mediaDistributionCapability = SEQ_OF(name=u'mediaDistributionCapability', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MultipointCapability_mediaDistributionCapability__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MediaDistributionCapability')))
    _MultipointCapability_mediaDistributionCapability._cont = __MultipointCapability_mediaDistributionCapability__item_
    MultipointCapability._cont = ASN1Dict([
        (u'multicastCapability', _MultipointCapability_multicastCapability),
        (u'multiUniCastConference', _MultipointCapability_multiUniCastConference),
        (u'mediaDistributionCapability', _MultipointCapability_mediaDistributionCapability),
        ])
    MultipointCapability._ext = []
    
    #-----< MediaDistributionCapability >-----#
    MediaDistributionCapability = SEQ(name=u'MediaDistributionCapability', mode=MODE_TYPE)
    _MediaDistributionCapability_centralizedControl = BOOL(name=u'centralizedControl', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MediaDistributionCapability_distributedControl = BOOL(name=u'distributedControl', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MediaDistributionCapability_centralizedAudio = BOOL(name=u'centralizedAudio', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MediaDistributionCapability_distributedAudio = BOOL(name=u'distributedAudio', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MediaDistributionCapability_centralizedVideo = BOOL(name=u'centralizedVideo', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MediaDistributionCapability_distributedVideo = BOOL(name=u'distributedVideo', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MediaDistributionCapability_centralizedData = SEQ_OF(name=u'centralizedData', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __MediaDistributionCapability_centralizedData__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DataApplicationCapability')))
    _MediaDistributionCapability_centralizedData._cont = __MediaDistributionCapability_centralizedData__item_
    _MediaDistributionCapability_distributedData = SEQ_OF(name=u'distributedData', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __MediaDistributionCapability_distributedData__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DataApplicationCapability')))
    _MediaDistributionCapability_distributedData._cont = __MediaDistributionCapability_distributedData__item_
    MediaDistributionCapability._cont = ASN1Dict([
        (u'centralizedControl', _MediaDistributionCapability_centralizedControl),
        (u'distributedControl', _MediaDistributionCapability_distributedControl),
        (u'centralizedAudio', _MediaDistributionCapability_centralizedAudio),
        (u'distributedAudio', _MediaDistributionCapability_distributedAudio),
        (u'centralizedVideo', _MediaDistributionCapability_centralizedVideo),
        (u'distributedVideo', _MediaDistributionCapability_distributedVideo),
        (u'centralizedData', _MediaDistributionCapability_centralizedData),
        (u'distributedData', _MediaDistributionCapability_distributedData),
        ])
    MediaDistributionCapability._ext = []
    
    #-----< VideoCapability >-----#
    VideoCapability = CHOICE(name=u'VideoCapability', mode=MODE_TYPE)
    _VideoCapability_nonStandard = SEQ(name=u'nonStandard', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')))
    _VideoCapability_h261VideoCapability = SEQ(name=u'h261VideoCapability', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H261VideoCapability')))
    _VideoCapability_h262VideoCapability = SEQ(name=u'h262VideoCapability', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H262VideoCapability')))
    _VideoCapability_h263VideoCapability = SEQ(name=u'h263VideoCapability', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H263VideoCapability')))
    _VideoCapability_is11172VideoCapability = SEQ(name=u'is11172VideoCapability', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'IS11172VideoCapability')))
    _VideoCapability_genericVideoCapability = SEQ(name=u'genericVideoCapability', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'GenericCapability')))
    _VideoCapability_extendedVideoCapability = SEQ(name=u'extendedVideoCapability', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'ExtendedVideoCapability')))
    VideoCapability._cont = ASN1Dict([
        (u'nonStandard', _VideoCapability_nonStandard),
        (u'h261VideoCapability', _VideoCapability_h261VideoCapability),
        (u'h262VideoCapability', _VideoCapability_h262VideoCapability),
        (u'h263VideoCapability', _VideoCapability_h263VideoCapability),
        (u'is11172VideoCapability', _VideoCapability_is11172VideoCapability),
        (u'genericVideoCapability', _VideoCapability_genericVideoCapability),
        (u'extendedVideoCapability', _VideoCapability_extendedVideoCapability),
        ])
    VideoCapability._ext = [u'genericVideoCapability', u'extendedVideoCapability']
    
    #-----< ExtendedVideoCapability >-----#
    ExtendedVideoCapability = SEQ(name=u'ExtendedVideoCapability', mode=MODE_TYPE)
    _ExtendedVideoCapability_videoCapability = SEQ_OF(name=u'videoCapability', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __ExtendedVideoCapability_videoCapability__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'VideoCapability')))
    _ExtendedVideoCapability_videoCapability._cont = __ExtendedVideoCapability_videoCapability__item_
    _ExtendedVideoCapability_videoCapabilityExtension = SEQ_OF(name=u'videoCapabilityExtension', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __ExtendedVideoCapability_videoCapabilityExtension__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'GenericCapability')))
    _ExtendedVideoCapability_videoCapabilityExtension._cont = __ExtendedVideoCapability_videoCapabilityExtension__item_
    ExtendedVideoCapability._cont = ASN1Dict([
        (u'videoCapability', _ExtendedVideoCapability_videoCapability),
        (u'videoCapabilityExtension', _ExtendedVideoCapability_videoCapabilityExtension),
        ])
    ExtendedVideoCapability._ext = []
    
    #-----< H261VideoCapability >-----#
    H261VideoCapability = SEQ(name=u'H261VideoCapability', mode=MODE_TYPE)
    _H261VideoCapability_qcifMPI = INT(name=u'qcifMPI', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _H261VideoCapability_qcifMPI._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4)], ev=None, er=[])
    _H261VideoCapability_cifMPI = INT(name=u'cifMPI', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _H261VideoCapability_cifMPI._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4)], ev=None, er=[])
    _H261VideoCapability_temporalSpatialTradeOffCapability = BOOL(name=u'temporalSpatialTradeOffCapability', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H261VideoCapability_maxBitRate = INT(name=u'maxBitRate', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H261VideoCapability_maxBitRate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=19200)], ev=None, er=[])
    _H261VideoCapability_stillImageTransmission = BOOL(name=u'stillImageTransmission', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H261VideoCapability_videoBadMBsCap = BOOL(name=u'videoBadMBsCap', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    H261VideoCapability._cont = ASN1Dict([
        (u'qcifMPI', _H261VideoCapability_qcifMPI),
        (u'cifMPI', _H261VideoCapability_cifMPI),
        (u'temporalSpatialTradeOffCapability', _H261VideoCapability_temporalSpatialTradeOffCapability),
        (u'maxBitRate', _H261VideoCapability_maxBitRate),
        (u'stillImageTransmission', _H261VideoCapability_stillImageTransmission),
        (u'videoBadMBsCap', _H261VideoCapability_videoBadMBsCap),
        ])
    H261VideoCapability._ext = [u'videoBadMBsCap']
    
    #-----< H262VideoCapability >-----#
    H262VideoCapability = SEQ(name=u'H262VideoCapability', mode=MODE_TYPE)
    _H262VideoCapability_profileAndLevel_SPatML = BOOL(name=u'profileAndLevel-SPatML', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H262VideoCapability_profileAndLevel_MPatLL = BOOL(name=u'profileAndLevel-MPatLL', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H262VideoCapability_profileAndLevel_MPatML = BOOL(name=u'profileAndLevel-MPatML', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H262VideoCapability_profileAndLevel_MPatH_14 = BOOL(name=u'profileAndLevel-MPatH-14', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H262VideoCapability_profileAndLevel_MPatHL = BOOL(name=u'profileAndLevel-MPatHL', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H262VideoCapability_profileAndLevel_SNRatLL = BOOL(name=u'profileAndLevel-SNRatLL', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H262VideoCapability_profileAndLevel_SNRatML = BOOL(name=u'profileAndLevel-SNRatML', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H262VideoCapability_profileAndLevel_SpatialatH_14 = BOOL(name=u'profileAndLevel-SpatialatH-14', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H262VideoCapability_profileAndLevel_HPatML = BOOL(name=u'profileAndLevel-HPatML', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H262VideoCapability_profileAndLevel_HPatH_14 = BOOL(name=u'profileAndLevel-HPatH-14', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H262VideoCapability_profileAndLevel_HPatHL = BOOL(name=u'profileAndLevel-HPatHL', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H262VideoCapability_videoBitRate = INT(name=u'videoBitRate', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _H262VideoCapability_videoBitRate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=1073741823)], ev=None, er=[])
    _H262VideoCapability_vbvBufferSize = INT(name=u'vbvBufferSize', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _H262VideoCapability_vbvBufferSize._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=262143)], ev=None, er=[])
    _H262VideoCapability_samplesPerLine = INT(name=u'samplesPerLine', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _H262VideoCapability_samplesPerLine._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=16383)], ev=None, er=[])
    _H262VideoCapability_linesPerFrame = INT(name=u'linesPerFrame', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _H262VideoCapability_linesPerFrame._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=16383)], ev=None, er=[])
    _H262VideoCapability_framesPerSecond = INT(name=u'framesPerSecond', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _H262VideoCapability_framesPerSecond._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=15)], ev=None, er=[])
    _H262VideoCapability_luminanceSampleRate = INT(name=u'luminanceSampleRate', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _H262VideoCapability_luminanceSampleRate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4294967295)], ev=None, er=[])
    _H262VideoCapability_videoBadMBsCap = BOOL(name=u'videoBadMBsCap', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    H262VideoCapability._cont = ASN1Dict([
        (u'profileAndLevel-SPatML', _H262VideoCapability_profileAndLevel_SPatML),
        (u'profileAndLevel-MPatLL', _H262VideoCapability_profileAndLevel_MPatLL),
        (u'profileAndLevel-MPatML', _H262VideoCapability_profileAndLevel_MPatML),
        (u'profileAndLevel-MPatH-14', _H262VideoCapability_profileAndLevel_MPatH_14),
        (u'profileAndLevel-MPatHL', _H262VideoCapability_profileAndLevel_MPatHL),
        (u'profileAndLevel-SNRatLL', _H262VideoCapability_profileAndLevel_SNRatLL),
        (u'profileAndLevel-SNRatML', _H262VideoCapability_profileAndLevel_SNRatML),
        (u'profileAndLevel-SpatialatH-14', _H262VideoCapability_profileAndLevel_SpatialatH_14),
        (u'profileAndLevel-HPatML', _H262VideoCapability_profileAndLevel_HPatML),
        (u'profileAndLevel-HPatH-14', _H262VideoCapability_profileAndLevel_HPatH_14),
        (u'profileAndLevel-HPatHL', _H262VideoCapability_profileAndLevel_HPatHL),
        (u'videoBitRate', _H262VideoCapability_videoBitRate),
        (u'vbvBufferSize', _H262VideoCapability_vbvBufferSize),
        (u'samplesPerLine', _H262VideoCapability_samplesPerLine),
        (u'linesPerFrame', _H262VideoCapability_linesPerFrame),
        (u'framesPerSecond', _H262VideoCapability_framesPerSecond),
        (u'luminanceSampleRate', _H262VideoCapability_luminanceSampleRate),
        (u'videoBadMBsCap', _H262VideoCapability_videoBadMBsCap),
        ])
    H262VideoCapability._ext = None
    
    #-----< H263VideoCapability >-----#
    H263VideoCapability = SEQ(name=u'H263VideoCapability', mode=MODE_TYPE)
    _H263VideoCapability_sqcifMPI = INT(name=u'sqcifMPI', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _H263VideoCapability_sqcifMPI._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    _H263VideoCapability_qcifMPI = INT(name=u'qcifMPI', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _H263VideoCapability_qcifMPI._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    _H263VideoCapability_cifMPI = INT(name=u'cifMPI', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _H263VideoCapability_cifMPI._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    _H263VideoCapability_cif4MPI = INT(name=u'cif4MPI', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _H263VideoCapability_cif4MPI._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    _H263VideoCapability_cif16MPI = INT(name=u'cif16MPI', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _H263VideoCapability_cif16MPI._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    _H263VideoCapability_maxBitRate = INT(name=u'maxBitRate', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263VideoCapability_maxBitRate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=192400)], ev=None, er=[])
    _H263VideoCapability_unrestrictedVector = BOOL(name=u'unrestrictedVector', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263VideoCapability_arithmeticCoding = BOOL(name=u'arithmeticCoding', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263VideoCapability_advancedPrediction = BOOL(name=u'advancedPrediction', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263VideoCapability_pbFrames = BOOL(name=u'pbFrames', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263VideoCapability_temporalSpatialTradeOffCapability = BOOL(name=u'temporalSpatialTradeOffCapability', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263VideoCapability_hrd_B = INT(name=u'hrd-B', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _H263VideoCapability_hrd_B._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=524287)], ev=None, er=[])
    _H263VideoCapability_bppMaxKb = INT(name=u'bppMaxKb', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _H263VideoCapability_bppMaxKb._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    _H263VideoCapability_slowSqcifMPI = INT(name=u'slowSqcifMPI', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _H263VideoCapability_slowSqcifMPI._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=3600)], ev=None, er=[])
    _H263VideoCapability_slowQcifMPI = INT(name=u'slowQcifMPI', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _H263VideoCapability_slowQcifMPI._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=3600)], ev=None, er=[])
    _H263VideoCapability_slowCifMPI = INT(name=u'slowCifMPI', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _H263VideoCapability_slowCifMPI._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=3600)], ev=None, er=[])
    _H263VideoCapability_slowCif4MPI = INT(name=u'slowCif4MPI', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _H263VideoCapability_slowCif4MPI._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=3600)], ev=None, er=[])
    _H263VideoCapability_slowCif16MPI = INT(name=u'slowCif16MPI', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _H263VideoCapability_slowCif16MPI._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=3600)], ev=None, er=[])
    _H263VideoCapability_errorCompensation = BOOL(name=u'errorCompensation', mode=MODE_TYPE, tag=(18, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263VideoCapability_enhancementLayerInfo = SEQ(name=u'enhancementLayerInfo', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'EnhancementLayerInfo')), opt=True)
    _H263VideoCapability_h263Options = SEQ(name=u'h263Options', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H263Options')), opt=True)
    H263VideoCapability._cont = ASN1Dict([
        (u'sqcifMPI', _H263VideoCapability_sqcifMPI),
        (u'qcifMPI', _H263VideoCapability_qcifMPI),
        (u'cifMPI', _H263VideoCapability_cifMPI),
        (u'cif4MPI', _H263VideoCapability_cif4MPI),
        (u'cif16MPI', _H263VideoCapability_cif16MPI),
        (u'maxBitRate', _H263VideoCapability_maxBitRate),
        (u'unrestrictedVector', _H263VideoCapability_unrestrictedVector),
        (u'arithmeticCoding', _H263VideoCapability_arithmeticCoding),
        (u'advancedPrediction', _H263VideoCapability_advancedPrediction),
        (u'pbFrames', _H263VideoCapability_pbFrames),
        (u'temporalSpatialTradeOffCapability', _H263VideoCapability_temporalSpatialTradeOffCapability),
        (u'hrd-B', _H263VideoCapability_hrd_B),
        (u'bppMaxKb', _H263VideoCapability_bppMaxKb),
        (u'slowSqcifMPI', _H263VideoCapability_slowSqcifMPI),
        (u'slowQcifMPI', _H263VideoCapability_slowQcifMPI),
        (u'slowCifMPI', _H263VideoCapability_slowCifMPI),
        (u'slowCif4MPI', _H263VideoCapability_slowCif4MPI),
        (u'slowCif16MPI', _H263VideoCapability_slowCif16MPI),
        (u'errorCompensation', _H263VideoCapability_errorCompensation),
        (u'enhancementLayerInfo', _H263VideoCapability_enhancementLayerInfo),
        (u'h263Options', _H263VideoCapability_h263Options),
        ])
    H263VideoCapability._ext = [u'slowSqcifMPI', u'slowQcifMPI', u'slowCifMPI', u'slowCif4MPI', u'slowCif16MPI', u'errorCompensation', u'enhancementLayerInfo', u'h263Options']
    
    #-----< EnhancementLayerInfo >-----#
    EnhancementLayerInfo = SEQ(name=u'EnhancementLayerInfo', mode=MODE_TYPE)
    _EnhancementLayerInfo_baseBitRateConstrained = BOOL(name=u'baseBitRateConstrained', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EnhancementLayerInfo_snrEnhancement = SET_OF(name=u'snrEnhancement', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __EnhancementLayerInfo_snrEnhancement__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'EnhancementOptions')))
    _EnhancementLayerInfo_snrEnhancement._cont = __EnhancementLayerInfo_snrEnhancement__item_
    _EnhancementLayerInfo_snrEnhancement._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=14)], ev=None, er=[])
    _EnhancementLayerInfo_spatialEnhancement = SET_OF(name=u'spatialEnhancement', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __EnhancementLayerInfo_spatialEnhancement__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'EnhancementOptions')))
    _EnhancementLayerInfo_spatialEnhancement._cont = __EnhancementLayerInfo_spatialEnhancement__item_
    _EnhancementLayerInfo_spatialEnhancement._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=14)], ev=None, er=[])
    _EnhancementLayerInfo_bPictureEnhancement = SET_OF(name=u'bPictureEnhancement', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __EnhancementLayerInfo_bPictureEnhancement__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'BEnhancementParameters')))
    _EnhancementLayerInfo_bPictureEnhancement._cont = __EnhancementLayerInfo_bPictureEnhancement__item_
    _EnhancementLayerInfo_bPictureEnhancement._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=14)], ev=None, er=[])
    EnhancementLayerInfo._cont = ASN1Dict([
        (u'baseBitRateConstrained', _EnhancementLayerInfo_baseBitRateConstrained),
        (u'snrEnhancement', _EnhancementLayerInfo_snrEnhancement),
        (u'spatialEnhancement', _EnhancementLayerInfo_spatialEnhancement),
        (u'bPictureEnhancement', _EnhancementLayerInfo_bPictureEnhancement),
        ])
    EnhancementLayerInfo._ext = []
    
    #-----< BEnhancementParameters >-----#
    BEnhancementParameters = SEQ(name=u'BEnhancementParameters', mode=MODE_TYPE)
    _BEnhancementParameters_enhancementOptions = SEQ(name=u'enhancementOptions', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'EnhancementOptions')))
    _BEnhancementParameters_numberOfBPictures = INT(name=u'numberOfBPictures', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _BEnhancementParameters_numberOfBPictures._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    BEnhancementParameters._cont = ASN1Dict([
        (u'enhancementOptions', _BEnhancementParameters_enhancementOptions),
        (u'numberOfBPictures', _BEnhancementParameters_numberOfBPictures),
        ])
    BEnhancementParameters._ext = []
    
    #-----< EnhancementOptions >-----#
    EnhancementOptions = SEQ(name=u'EnhancementOptions', mode=MODE_TYPE)
    _EnhancementOptions_sqcifMPI = INT(name=u'sqcifMPI', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _EnhancementOptions_sqcifMPI._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    _EnhancementOptions_qcifMPI = INT(name=u'qcifMPI', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _EnhancementOptions_qcifMPI._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    _EnhancementOptions_cifMPI = INT(name=u'cifMPI', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _EnhancementOptions_cifMPI._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    _EnhancementOptions_cif4MPI = INT(name=u'cif4MPI', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _EnhancementOptions_cif4MPI._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    _EnhancementOptions_cif16MPI = INT(name=u'cif16MPI', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _EnhancementOptions_cif16MPI._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    _EnhancementOptions_maxBitRate = INT(name=u'maxBitRate', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EnhancementOptions_maxBitRate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=192400)], ev=None, er=[])
    _EnhancementOptions_unrestrictedVector = BOOL(name=u'unrestrictedVector', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EnhancementOptions_arithmeticCoding = BOOL(name=u'arithmeticCoding', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EnhancementOptions_temporalSpatialTradeOffCapability = BOOL(name=u'temporalSpatialTradeOffCapability', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EnhancementOptions_slowSqcifMPI = INT(name=u'slowSqcifMPI', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _EnhancementOptions_slowSqcifMPI._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=3600)], ev=None, er=[])
    _EnhancementOptions_slowQcifMPI = INT(name=u'slowQcifMPI', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _EnhancementOptions_slowQcifMPI._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=3600)], ev=None, er=[])
    _EnhancementOptions_slowCifMPI = INT(name=u'slowCifMPI', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _EnhancementOptions_slowCifMPI._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=3600)], ev=None, er=[])
    _EnhancementOptions_slowCif4MPI = INT(name=u'slowCif4MPI', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _EnhancementOptions_slowCif4MPI._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=3600)], ev=None, er=[])
    _EnhancementOptions_slowCif16MPI = INT(name=u'slowCif16MPI', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _EnhancementOptions_slowCif16MPI._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=3600)], ev=None, er=[])
    _EnhancementOptions_errorCompensation = BOOL(name=u'errorCompensation', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EnhancementOptions_h263Options = SEQ(name=u'h263Options', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H263Options')), opt=True)
    EnhancementOptions._cont = ASN1Dict([
        (u'sqcifMPI', _EnhancementOptions_sqcifMPI),
        (u'qcifMPI', _EnhancementOptions_qcifMPI),
        (u'cifMPI', _EnhancementOptions_cifMPI),
        (u'cif4MPI', _EnhancementOptions_cif4MPI),
        (u'cif16MPI', _EnhancementOptions_cif16MPI),
        (u'maxBitRate', _EnhancementOptions_maxBitRate),
        (u'unrestrictedVector', _EnhancementOptions_unrestrictedVector),
        (u'arithmeticCoding', _EnhancementOptions_arithmeticCoding),
        (u'temporalSpatialTradeOffCapability', _EnhancementOptions_temporalSpatialTradeOffCapability),
        (u'slowSqcifMPI', _EnhancementOptions_slowSqcifMPI),
        (u'slowQcifMPI', _EnhancementOptions_slowQcifMPI),
        (u'slowCifMPI', _EnhancementOptions_slowCifMPI),
        (u'slowCif4MPI', _EnhancementOptions_slowCif4MPI),
        (u'slowCif16MPI', _EnhancementOptions_slowCif16MPI),
        (u'errorCompensation', _EnhancementOptions_errorCompensation),
        (u'h263Options', _EnhancementOptions_h263Options),
        ])
    EnhancementOptions._ext = []
    
    #-----< H263Options >-----#
    H263Options = SEQ(name=u'H263Options', mode=MODE_TYPE)
    _H263Options_advancedIntraCodingMode = BOOL(name=u'advancedIntraCodingMode', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263Options_deblockingFilterMode = BOOL(name=u'deblockingFilterMode', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263Options_improvedPBFramesMode = BOOL(name=u'improvedPBFramesMode', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263Options_unlimitedMotionVectors = BOOL(name=u'unlimitedMotionVectors', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263Options_fullPictureFreeze = BOOL(name=u'fullPictureFreeze', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263Options_partialPictureFreezeAndRelease = BOOL(name=u'partialPictureFreezeAndRelease', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263Options_resizingPartPicFreezeAndRelease = BOOL(name=u'resizingPartPicFreezeAndRelease', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263Options_fullPictureSnapshot = BOOL(name=u'fullPictureSnapshot', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263Options_partialPictureSnapshot = BOOL(name=u'partialPictureSnapshot', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263Options_videoSegmentTagging = BOOL(name=u'videoSegmentTagging', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263Options_progressiveRefinement = BOOL(name=u'progressiveRefinement', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263Options_dynamicPictureResizingByFour = BOOL(name=u'dynamicPictureResizingByFour', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263Options_dynamicPictureResizingSixteenthPel = BOOL(name=u'dynamicPictureResizingSixteenthPel', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263Options_dynamicWarpingHalfPel = BOOL(name=u'dynamicWarpingHalfPel', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263Options_dynamicWarpingSixteenthPel = BOOL(name=u'dynamicWarpingSixteenthPel', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263Options_independentSegmentDecoding = BOOL(name=u'independentSegmentDecoding', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263Options_slicesInOrder_NonRect = BOOL(name=u'slicesInOrder-NonRect', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263Options_slicesInOrder_Rect = BOOL(name=u'slicesInOrder-Rect', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263Options_slicesNoOrder_NonRect = BOOL(name=u'slicesNoOrder-NonRect', mode=MODE_TYPE, tag=(18, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263Options_slicesNoOrder_Rect = BOOL(name=u'slicesNoOrder-Rect', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263Options_alternateInterVLCMode = BOOL(name=u'alternateInterVLCMode', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263Options_modifiedQuantizationMode = BOOL(name=u'modifiedQuantizationMode', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263Options_reducedResolutionUpdate = BOOL(name=u'reducedResolutionUpdate', mode=MODE_TYPE, tag=(22, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263Options_transparencyParameters = SEQ(name=u'transparencyParameters', mode=MODE_TYPE, tag=(23, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TransparencyParameters')), opt=True)
    _H263Options_separateVideoBackChannel = BOOL(name=u'separateVideoBackChannel', mode=MODE_TYPE, tag=(24, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263Options_refPictureSelection = SEQ(name=u'refPictureSelection', mode=MODE_TYPE, tag=(25, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'RefPictureSelection')), opt=True)
    _H263Options_customPictureClockFrequency = SET_OF(name=u'customPictureClockFrequency', mode=MODE_TYPE, tag=(26, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __H263Options_customPictureClockFrequency__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'CustomPictureClockFrequency')))
    _H263Options_customPictureClockFrequency._cont = __H263Options_customPictureClockFrequency__item_
    _H263Options_customPictureClockFrequency._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    _H263Options_customPictureFormat = SET_OF(name=u'customPictureFormat', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __H263Options_customPictureFormat__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'CustomPictureFormat')))
    _H263Options_customPictureFormat._cont = __H263Options_customPictureFormat__item_
    _H263Options_customPictureFormat._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    _H263Options_modeCombos = SET_OF(name=u'modeCombos', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __H263Options_modeCombos__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H263VideoModeCombos')))
    _H263Options_modeCombos._cont = __H263Options_modeCombos__item_
    _H263Options_modeCombos._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    _H263Options_videoBadMBsCap = BOOL(name=u'videoBadMBsCap', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263Options_h263Version3Options = SEQ(name=u'h263Version3Options', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H263Version3Options')))
    H263Options._cont = ASN1Dict([
        (u'advancedIntraCodingMode', _H263Options_advancedIntraCodingMode),
        (u'deblockingFilterMode', _H263Options_deblockingFilterMode),
        (u'improvedPBFramesMode', _H263Options_improvedPBFramesMode),
        (u'unlimitedMotionVectors', _H263Options_unlimitedMotionVectors),
        (u'fullPictureFreeze', _H263Options_fullPictureFreeze),
        (u'partialPictureFreezeAndRelease', _H263Options_partialPictureFreezeAndRelease),
        (u'resizingPartPicFreezeAndRelease', _H263Options_resizingPartPicFreezeAndRelease),
        (u'fullPictureSnapshot', _H263Options_fullPictureSnapshot),
        (u'partialPictureSnapshot', _H263Options_partialPictureSnapshot),
        (u'videoSegmentTagging', _H263Options_videoSegmentTagging),
        (u'progressiveRefinement', _H263Options_progressiveRefinement),
        (u'dynamicPictureResizingByFour', _H263Options_dynamicPictureResizingByFour),
        (u'dynamicPictureResizingSixteenthPel', _H263Options_dynamicPictureResizingSixteenthPel),
        (u'dynamicWarpingHalfPel', _H263Options_dynamicWarpingHalfPel),
        (u'dynamicWarpingSixteenthPel', _H263Options_dynamicWarpingSixteenthPel),
        (u'independentSegmentDecoding', _H263Options_independentSegmentDecoding),
        (u'slicesInOrder-NonRect', _H263Options_slicesInOrder_NonRect),
        (u'slicesInOrder-Rect', _H263Options_slicesInOrder_Rect),
        (u'slicesNoOrder-NonRect', _H263Options_slicesNoOrder_NonRect),
        (u'slicesNoOrder-Rect', _H263Options_slicesNoOrder_Rect),
        (u'alternateInterVLCMode', _H263Options_alternateInterVLCMode),
        (u'modifiedQuantizationMode', _H263Options_modifiedQuantizationMode),
        (u'reducedResolutionUpdate', _H263Options_reducedResolutionUpdate),
        (u'transparencyParameters', _H263Options_transparencyParameters),
        (u'separateVideoBackChannel', _H263Options_separateVideoBackChannel),
        (u'refPictureSelection', _H263Options_refPictureSelection),
        (u'customPictureClockFrequency', _H263Options_customPictureClockFrequency),
        (u'customPictureFormat', _H263Options_customPictureFormat),
        (u'modeCombos', _H263Options_modeCombos),
        (u'videoBadMBsCap', _H263Options_videoBadMBsCap),
        (u'h263Version3Options', _H263Options_h263Version3Options),
        ])
    H263Options._ext = [u'videoBadMBsCap', u'h263Version3Options']
    
    #-----< TransparencyParameters >-----#
    TransparencyParameters = SEQ(name=u'TransparencyParameters', mode=MODE_TYPE)
    _TransparencyParameters_presentationOrder = INT(name=u'presentationOrder', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _TransparencyParameters_presentationOrder._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    _TransparencyParameters_offset_x = INT(name=u'offset-x', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _TransparencyParameters_offset_x._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-262144, ub=262143)], ev=None, er=[])
    _TransparencyParameters_offset_y = INT(name=u'offset-y', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _TransparencyParameters_offset_y._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-262144, ub=262143)], ev=None, er=[])
    _TransparencyParameters_scale_x = INT(name=u'scale-x', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _TransparencyParameters_scale_x._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=255)], ev=None, er=[])
    _TransparencyParameters_scale_y = INT(name=u'scale-y', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _TransparencyParameters_scale_y._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=255)], ev=None, er=[])
    TransparencyParameters._cont = ASN1Dict([
        (u'presentationOrder', _TransparencyParameters_presentationOrder),
        (u'offset-x', _TransparencyParameters_offset_x),
        (u'offset-y', _TransparencyParameters_offset_y),
        (u'scale-x', _TransparencyParameters_scale_x),
        (u'scale-y', _TransparencyParameters_scale_y),
        ])
    TransparencyParameters._ext = []
    
    #-----< RefPictureSelection >-----#
    RefPictureSelection = SEQ(name=u'RefPictureSelection', mode=MODE_TYPE)
    _RefPictureSelection_additionalPictureMemory = SEQ(name=u'additionalPictureMemory', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __RefPictureSelection_additionalPictureMemory_sqcifAdditionalPictureMemory = INT(name=u'sqcifAdditionalPictureMemory', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __RefPictureSelection_additionalPictureMemory_sqcifAdditionalPictureMemory._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    __RefPictureSelection_additionalPictureMemory_qcifAdditionalPictureMemory = INT(name=u'qcifAdditionalPictureMemory', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __RefPictureSelection_additionalPictureMemory_qcifAdditionalPictureMemory._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    __RefPictureSelection_additionalPictureMemory_cifAdditionalPictureMemory = INT(name=u'cifAdditionalPictureMemory', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __RefPictureSelection_additionalPictureMemory_cifAdditionalPictureMemory._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    __RefPictureSelection_additionalPictureMemory_cif4AdditionalPictureMemory = INT(name=u'cif4AdditionalPictureMemory', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __RefPictureSelection_additionalPictureMemory_cif4AdditionalPictureMemory._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    __RefPictureSelection_additionalPictureMemory_cif16AdditionalPictureMemory = INT(name=u'cif16AdditionalPictureMemory', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __RefPictureSelection_additionalPictureMemory_cif16AdditionalPictureMemory._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    __RefPictureSelection_additionalPictureMemory_bigCpfAdditionalPictureMemory = INT(name=u'bigCpfAdditionalPictureMemory', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __RefPictureSelection_additionalPictureMemory_bigCpfAdditionalPictureMemory._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    _RefPictureSelection_additionalPictureMemory._cont = ASN1Dict([
        (u'sqcifAdditionalPictureMemory', __RefPictureSelection_additionalPictureMemory_sqcifAdditionalPictureMemory),
        (u'qcifAdditionalPictureMemory', __RefPictureSelection_additionalPictureMemory_qcifAdditionalPictureMemory),
        (u'cifAdditionalPictureMemory', __RefPictureSelection_additionalPictureMemory_cifAdditionalPictureMemory),
        (u'cif4AdditionalPictureMemory', __RefPictureSelection_additionalPictureMemory_cif4AdditionalPictureMemory),
        (u'cif16AdditionalPictureMemory', __RefPictureSelection_additionalPictureMemory_cif16AdditionalPictureMemory),
        (u'bigCpfAdditionalPictureMemory', __RefPictureSelection_additionalPictureMemory_bigCpfAdditionalPictureMemory),
        ])
    _RefPictureSelection_additionalPictureMemory._ext = []
    _RefPictureSelection_videoMux = BOOL(name=u'videoMux', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _RefPictureSelection_videoBackChannelSend = CHOICE(name=u'videoBackChannelSend', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __RefPictureSelection_videoBackChannelSend_none = NULL(name=u'none', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __RefPictureSelection_videoBackChannelSend_ackMessageOnly = NULL(name=u'ackMessageOnly', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __RefPictureSelection_videoBackChannelSend_nackMessageOnly = NULL(name=u'nackMessageOnly', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __RefPictureSelection_videoBackChannelSend_ackOrNackMessageOnly = NULL(name=u'ackOrNackMessageOnly', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __RefPictureSelection_videoBackChannelSend_ackAndNackMessage = NULL(name=u'ackAndNackMessage', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _RefPictureSelection_videoBackChannelSend._cont = ASN1Dict([
        (u'none', __RefPictureSelection_videoBackChannelSend_none),
        (u'ackMessageOnly', __RefPictureSelection_videoBackChannelSend_ackMessageOnly),
        (u'nackMessageOnly', __RefPictureSelection_videoBackChannelSend_nackMessageOnly),
        (u'ackOrNackMessageOnly', __RefPictureSelection_videoBackChannelSend_ackOrNackMessageOnly),
        (u'ackAndNackMessage', __RefPictureSelection_videoBackChannelSend_ackAndNackMessage),
        ])
    _RefPictureSelection_videoBackChannelSend._ext = []
    _RefPictureSelection_enhancedReferencePicSelect = SEQ(name=u'enhancedReferencePicSelect', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters = SEQ(name=u'subPictureRemovalParameters', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    ___RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters_mpuHorizMBs = INT(name=u'mpuHorizMBs', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters_mpuHorizMBs._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    ___RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters_mpuVertMBs = INT(name=u'mpuVertMBs', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters_mpuVertMBs._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=72)], ev=None, er=[])
    ___RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters_mpuTotalNumber = INT(name=u'mpuTotalNumber', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters_mpuTotalNumber._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65536)], ev=None, er=[])
    __RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters._cont = ASN1Dict([
        (u'mpuHorizMBs', ___RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters_mpuHorizMBs),
        (u'mpuVertMBs', ___RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters_mpuVertMBs),
        (u'mpuTotalNumber', ___RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters_mpuTotalNumber),
        ])
    __RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters._ext = []
    _RefPictureSelection_enhancedReferencePicSelect._cont = ASN1Dict([
        (u'subPictureRemovalParameters', __RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters),
        ])
    _RefPictureSelection_enhancedReferencePicSelect._ext = []
    RefPictureSelection._cont = ASN1Dict([
        (u'additionalPictureMemory', _RefPictureSelection_additionalPictureMemory),
        (u'videoMux', _RefPictureSelection_videoMux),
        (u'videoBackChannelSend', _RefPictureSelection_videoBackChannelSend),
        (u'enhancedReferencePicSelect', _RefPictureSelection_enhancedReferencePicSelect),
        ])
    RefPictureSelection._ext = [u'enhancedReferencePicSelect']
    
    #-----< CustomPictureClockFrequency >-----#
    CustomPictureClockFrequency = SEQ(name=u'CustomPictureClockFrequency', mode=MODE_TYPE)
    _CustomPictureClockFrequency_clockConversionCode = INT(name=u'clockConversionCode', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _CustomPictureClockFrequency_clockConversionCode._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1000, ub=1001)], ev=None, er=[])
    _CustomPictureClockFrequency_clockDivisor = INT(name=u'clockDivisor', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _CustomPictureClockFrequency_clockDivisor._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=127)], ev=None, er=[])
    _CustomPictureClockFrequency_sqcifMPI = INT(name=u'sqcifMPI', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CustomPictureClockFrequency_sqcifMPI._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=2048)], ev=None, er=[])
    _CustomPictureClockFrequency_qcifMPI = INT(name=u'qcifMPI', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CustomPictureClockFrequency_qcifMPI._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=2048)], ev=None, er=[])
    _CustomPictureClockFrequency_cifMPI = INT(name=u'cifMPI', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CustomPictureClockFrequency_cifMPI._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=2048)], ev=None, er=[])
    _CustomPictureClockFrequency_cif4MPI = INT(name=u'cif4MPI', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CustomPictureClockFrequency_cif4MPI._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=2048)], ev=None, er=[])
    _CustomPictureClockFrequency_cif16MPI = INT(name=u'cif16MPI', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CustomPictureClockFrequency_cif16MPI._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=2048)], ev=None, er=[])
    CustomPictureClockFrequency._cont = ASN1Dict([
        (u'clockConversionCode', _CustomPictureClockFrequency_clockConversionCode),
        (u'clockDivisor', _CustomPictureClockFrequency_clockDivisor),
        (u'sqcifMPI', _CustomPictureClockFrequency_sqcifMPI),
        (u'qcifMPI', _CustomPictureClockFrequency_qcifMPI),
        (u'cifMPI', _CustomPictureClockFrequency_cifMPI),
        (u'cif4MPI', _CustomPictureClockFrequency_cif4MPI),
        (u'cif16MPI', _CustomPictureClockFrequency_cif16MPI),
        ])
    CustomPictureClockFrequency._ext = []
    
    #-----< CustomPictureFormat >-----#
    CustomPictureFormat = SEQ(name=u'CustomPictureFormat', mode=MODE_TYPE)
    _CustomPictureFormat_maxCustomPictureWidth = INT(name=u'maxCustomPictureWidth', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _CustomPictureFormat_maxCustomPictureWidth._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=2048)], ev=None, er=[])
    _CustomPictureFormat_maxCustomPictureHeight = INT(name=u'maxCustomPictureHeight', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _CustomPictureFormat_maxCustomPictureHeight._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=2048)], ev=None, er=[])
    _CustomPictureFormat_minCustomPictureWidth = INT(name=u'minCustomPictureWidth', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _CustomPictureFormat_minCustomPictureWidth._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=2048)], ev=None, er=[])
    _CustomPictureFormat_minCustomPictureHeight = INT(name=u'minCustomPictureHeight', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _CustomPictureFormat_minCustomPictureHeight._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=2048)], ev=None, er=[])
    _CustomPictureFormat_mPI = SEQ(name=u'mPI', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __CustomPictureFormat_mPI_standardMPI = INT(name=u'standardMPI', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __CustomPictureFormat_mPI_standardMPI._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=31)], ev=None, er=[])
    __CustomPictureFormat_mPI_customPCF = SET_OF(name=u'customPCF', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    ___CustomPictureFormat_mPI_customPCF__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    ____CustomPictureFormat_mPI_customPCF__item__clockConversionCode = INT(name=u'clockConversionCode', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ____CustomPictureFormat_mPI_customPCF__item__clockConversionCode._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1000, ub=1001)], ev=None, er=[])
    ____CustomPictureFormat_mPI_customPCF__item__clockDivisor = INT(name=u'clockDivisor', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ____CustomPictureFormat_mPI_customPCF__item__clockDivisor._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=127)], ev=None, er=[])
    ____CustomPictureFormat_mPI_customPCF__item__customMPI = INT(name=u'customMPI', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ____CustomPictureFormat_mPI_customPCF__item__customMPI._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=2048)], ev=None, er=[])
    ___CustomPictureFormat_mPI_customPCF__item_._cont = ASN1Dict([
        (u'clockConversionCode', ____CustomPictureFormat_mPI_customPCF__item__clockConversionCode),
        (u'clockDivisor', ____CustomPictureFormat_mPI_customPCF__item__clockDivisor),
        (u'customMPI', ____CustomPictureFormat_mPI_customPCF__item__customMPI),
        ])
    ___CustomPictureFormat_mPI_customPCF__item_._ext = []
    __CustomPictureFormat_mPI_customPCF._cont = ___CustomPictureFormat_mPI_customPCF__item_
    __CustomPictureFormat_mPI_customPCF._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    _CustomPictureFormat_mPI._cont = ASN1Dict([
        (u'standardMPI', __CustomPictureFormat_mPI_standardMPI),
        (u'customPCF', __CustomPictureFormat_mPI_customPCF),
        ])
    _CustomPictureFormat_mPI._ext = []
    _CustomPictureFormat_pixelAspectInformation = CHOICE(name=u'pixelAspectInformation', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __CustomPictureFormat_pixelAspectInformation_anyPixelAspectRatio = BOOL(name=u'anyPixelAspectRatio', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __CustomPictureFormat_pixelAspectInformation_pixelAspectCode = SET_OF(name=u'pixelAspectCode', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___CustomPictureFormat_pixelAspectInformation_pixelAspectCode__item_ = INT(name='_item_', mode=MODE_TYPE)
    ___CustomPictureFormat_pixelAspectInformation_pixelAspectCode__item_._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=14)], ev=None, er=[])
    __CustomPictureFormat_pixelAspectInformation_pixelAspectCode._cont = ___CustomPictureFormat_pixelAspectInformation_pixelAspectCode__item_
    __CustomPictureFormat_pixelAspectInformation_pixelAspectCode._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=14)], ev=None, er=[])
    __CustomPictureFormat_pixelAspectInformation_extendedPAR = SET_OF(name=u'extendedPAR', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___CustomPictureFormat_pixelAspectInformation_extendedPAR__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    ____CustomPictureFormat_pixelAspectInformation_extendedPAR__item__width = INT(name=u'width', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ____CustomPictureFormat_pixelAspectInformation_extendedPAR__item__width._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=255)], ev=None, er=[])
    ____CustomPictureFormat_pixelAspectInformation_extendedPAR__item__height = INT(name=u'height', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ____CustomPictureFormat_pixelAspectInformation_extendedPAR__item__height._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=255)], ev=None, er=[])
    ___CustomPictureFormat_pixelAspectInformation_extendedPAR__item_._cont = ASN1Dict([
        (u'width', ____CustomPictureFormat_pixelAspectInformation_extendedPAR__item__width),
        (u'height', ____CustomPictureFormat_pixelAspectInformation_extendedPAR__item__height),
        ])
    ___CustomPictureFormat_pixelAspectInformation_extendedPAR__item_._ext = []
    __CustomPictureFormat_pixelAspectInformation_extendedPAR._cont = ___CustomPictureFormat_pixelAspectInformation_extendedPAR__item_
    __CustomPictureFormat_pixelAspectInformation_extendedPAR._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    _CustomPictureFormat_pixelAspectInformation._cont = ASN1Dict([
        (u'anyPixelAspectRatio', __CustomPictureFormat_pixelAspectInformation_anyPixelAspectRatio),
        (u'pixelAspectCode', __CustomPictureFormat_pixelAspectInformation_pixelAspectCode),
        (u'extendedPAR', __CustomPictureFormat_pixelAspectInformation_extendedPAR),
        ])
    _CustomPictureFormat_pixelAspectInformation._ext = []
    CustomPictureFormat._cont = ASN1Dict([
        (u'maxCustomPictureWidth', _CustomPictureFormat_maxCustomPictureWidth),
        (u'maxCustomPictureHeight', _CustomPictureFormat_maxCustomPictureHeight),
        (u'minCustomPictureWidth', _CustomPictureFormat_minCustomPictureWidth),
        (u'minCustomPictureHeight', _CustomPictureFormat_minCustomPictureHeight),
        (u'mPI', _CustomPictureFormat_mPI),
        (u'pixelAspectInformation', _CustomPictureFormat_pixelAspectInformation),
        ])
    CustomPictureFormat._ext = []
    
    #-----< H263VideoModeCombos >-----#
    H263VideoModeCombos = SEQ(name=u'H263VideoModeCombos', mode=MODE_TYPE)
    _H263VideoModeCombos_h263VideoUncoupledModes = SEQ(name=u'h263VideoUncoupledModes', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H263ModeComboFlags')))
    _H263VideoModeCombos_h263VideoCoupledModes = SET_OF(name=u'h263VideoCoupledModes', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H263VideoModeCombos_h263VideoCoupledModes__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H263ModeComboFlags')))
    _H263VideoModeCombos_h263VideoCoupledModes._cont = __H263VideoModeCombos_h263VideoCoupledModes__item_
    _H263VideoModeCombos_h263VideoCoupledModes._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    H263VideoModeCombos._cont = ASN1Dict([
        (u'h263VideoUncoupledModes', _H263VideoModeCombos_h263VideoUncoupledModes),
        (u'h263VideoCoupledModes', _H263VideoModeCombos_h263VideoCoupledModes),
        ])
    H263VideoModeCombos._ext = []
    
    #-----< H263ModeComboFlags >-----#
    H263ModeComboFlags = SEQ(name=u'H263ModeComboFlags', mode=MODE_TYPE)
    _H263ModeComboFlags_unrestrictedVector = BOOL(name=u'unrestrictedVector', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263ModeComboFlags_arithmeticCoding = BOOL(name=u'arithmeticCoding', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263ModeComboFlags_advancedPrediction = BOOL(name=u'advancedPrediction', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263ModeComboFlags_pbFrames = BOOL(name=u'pbFrames', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263ModeComboFlags_advancedIntraCodingMode = BOOL(name=u'advancedIntraCodingMode', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263ModeComboFlags_deblockingFilterMode = BOOL(name=u'deblockingFilterMode', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263ModeComboFlags_unlimitedMotionVectors = BOOL(name=u'unlimitedMotionVectors', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263ModeComboFlags_slicesInOrder_NonRect = BOOL(name=u'slicesInOrder-NonRect', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263ModeComboFlags_slicesInOrder_Rect = BOOL(name=u'slicesInOrder-Rect', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263ModeComboFlags_slicesNoOrder_NonRect = BOOL(name=u'slicesNoOrder-NonRect', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263ModeComboFlags_slicesNoOrder_Rect = BOOL(name=u'slicesNoOrder-Rect', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263ModeComboFlags_improvedPBFramesMode = BOOL(name=u'improvedPBFramesMode', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263ModeComboFlags_referencePicSelect = BOOL(name=u'referencePicSelect', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263ModeComboFlags_dynamicPictureResizingByFour = BOOL(name=u'dynamicPictureResizingByFour', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263ModeComboFlags_dynamicPictureResizingSixteenthPel = BOOL(name=u'dynamicPictureResizingSixteenthPel', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263ModeComboFlags_dynamicWarpingHalfPel = BOOL(name=u'dynamicWarpingHalfPel', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263ModeComboFlags_dynamicWarpingSixteenthPel = BOOL(name=u'dynamicWarpingSixteenthPel', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263ModeComboFlags_reducedResolutionUpdate = BOOL(name=u'reducedResolutionUpdate', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263ModeComboFlags_independentSegmentDecoding = BOOL(name=u'independentSegmentDecoding', mode=MODE_TYPE, tag=(18, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263ModeComboFlags_alternateInterVLCMode = BOOL(name=u'alternateInterVLCMode', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263ModeComboFlags_modifiedQuantizationMode = BOOL(name=u'modifiedQuantizationMode', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263ModeComboFlags_enhancedReferencePicSelect = BOOL(name=u'enhancedReferencePicSelect', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263ModeComboFlags_h263Version3Options = SEQ(name=u'h263Version3Options', mode=MODE_TYPE, tag=(22, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H263Version3Options')))
    H263ModeComboFlags._cont = ASN1Dict([
        (u'unrestrictedVector', _H263ModeComboFlags_unrestrictedVector),
        (u'arithmeticCoding', _H263ModeComboFlags_arithmeticCoding),
        (u'advancedPrediction', _H263ModeComboFlags_advancedPrediction),
        (u'pbFrames', _H263ModeComboFlags_pbFrames),
        (u'advancedIntraCodingMode', _H263ModeComboFlags_advancedIntraCodingMode),
        (u'deblockingFilterMode', _H263ModeComboFlags_deblockingFilterMode),
        (u'unlimitedMotionVectors', _H263ModeComboFlags_unlimitedMotionVectors),
        (u'slicesInOrder-NonRect', _H263ModeComboFlags_slicesInOrder_NonRect),
        (u'slicesInOrder-Rect', _H263ModeComboFlags_slicesInOrder_Rect),
        (u'slicesNoOrder-NonRect', _H263ModeComboFlags_slicesNoOrder_NonRect),
        (u'slicesNoOrder-Rect', _H263ModeComboFlags_slicesNoOrder_Rect),
        (u'improvedPBFramesMode', _H263ModeComboFlags_improvedPBFramesMode),
        (u'referencePicSelect', _H263ModeComboFlags_referencePicSelect),
        (u'dynamicPictureResizingByFour', _H263ModeComboFlags_dynamicPictureResizingByFour),
        (u'dynamicPictureResizingSixteenthPel', _H263ModeComboFlags_dynamicPictureResizingSixteenthPel),
        (u'dynamicWarpingHalfPel', _H263ModeComboFlags_dynamicWarpingHalfPel),
        (u'dynamicWarpingSixteenthPel', _H263ModeComboFlags_dynamicWarpingSixteenthPel),
        (u'reducedResolutionUpdate', _H263ModeComboFlags_reducedResolutionUpdate),
        (u'independentSegmentDecoding', _H263ModeComboFlags_independentSegmentDecoding),
        (u'alternateInterVLCMode', _H263ModeComboFlags_alternateInterVLCMode),
        (u'modifiedQuantizationMode', _H263ModeComboFlags_modifiedQuantizationMode),
        (u'enhancedReferencePicSelect', _H263ModeComboFlags_enhancedReferencePicSelect),
        (u'h263Version3Options', _H263ModeComboFlags_h263Version3Options),
        ])
    H263ModeComboFlags._ext = [u'enhancedReferencePicSelect', u'h263Version3Options']
    
    #-----< H263Version3Options >-----#
    H263Version3Options = SEQ(name=u'H263Version3Options', mode=MODE_TYPE)
    _H263Version3Options_dataPartitionedSlices = BOOL(name=u'dataPartitionedSlices', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263Version3Options_fixedPointIDCT0 = BOOL(name=u'fixedPointIDCT0', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263Version3Options_interlacedFields = BOOL(name=u'interlacedFields', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263Version3Options_currentPictureHeaderRepetition = BOOL(name=u'currentPictureHeaderRepetition', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263Version3Options_previousPictureHeaderRepetition = BOOL(name=u'previousPictureHeaderRepetition', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263Version3Options_nextPictureHeaderRepetition = BOOL(name=u'nextPictureHeaderRepetition', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263Version3Options_pictureNumber = BOOL(name=u'pictureNumber', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263Version3Options_spareReferencePictures = BOOL(name=u'spareReferencePictures', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    H263Version3Options._cont = ASN1Dict([
        (u'dataPartitionedSlices', _H263Version3Options_dataPartitionedSlices),
        (u'fixedPointIDCT0', _H263Version3Options_fixedPointIDCT0),
        (u'interlacedFields', _H263Version3Options_interlacedFields),
        (u'currentPictureHeaderRepetition', _H263Version3Options_currentPictureHeaderRepetition),
        (u'previousPictureHeaderRepetition', _H263Version3Options_previousPictureHeaderRepetition),
        (u'nextPictureHeaderRepetition', _H263Version3Options_nextPictureHeaderRepetition),
        (u'pictureNumber', _H263Version3Options_pictureNumber),
        (u'spareReferencePictures', _H263Version3Options_spareReferencePictures),
        ])
    H263Version3Options._ext = []
    
    #-----< IS11172VideoCapability >-----#
    IS11172VideoCapability = SEQ(name=u'IS11172VideoCapability', mode=MODE_TYPE)
    _IS11172VideoCapability_constrainedBitstream = BOOL(name=u'constrainedBitstream', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IS11172VideoCapability_videoBitRate = INT(name=u'videoBitRate', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _IS11172VideoCapability_videoBitRate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=1073741823)], ev=None, er=[])
    _IS11172VideoCapability_vbvBufferSize = INT(name=u'vbvBufferSize', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _IS11172VideoCapability_vbvBufferSize._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=262143)], ev=None, er=[])
    _IS11172VideoCapability_samplesPerLine = INT(name=u'samplesPerLine', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _IS11172VideoCapability_samplesPerLine._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=16383)], ev=None, er=[])
    _IS11172VideoCapability_linesPerFrame = INT(name=u'linesPerFrame', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _IS11172VideoCapability_linesPerFrame._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=16383)], ev=None, er=[])
    _IS11172VideoCapability_pictureRate = INT(name=u'pictureRate', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _IS11172VideoCapability_pictureRate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=15)], ev=None, er=[])
    _IS11172VideoCapability_luminanceSampleRate = INT(name=u'luminanceSampleRate', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _IS11172VideoCapability_luminanceSampleRate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4294967295)], ev=None, er=[])
    _IS11172VideoCapability_videoBadMBsCap = BOOL(name=u'videoBadMBsCap', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    IS11172VideoCapability._cont = ASN1Dict([
        (u'constrainedBitstream', _IS11172VideoCapability_constrainedBitstream),
        (u'videoBitRate', _IS11172VideoCapability_videoBitRate),
        (u'vbvBufferSize', _IS11172VideoCapability_vbvBufferSize),
        (u'samplesPerLine', _IS11172VideoCapability_samplesPerLine),
        (u'linesPerFrame', _IS11172VideoCapability_linesPerFrame),
        (u'pictureRate', _IS11172VideoCapability_pictureRate),
        (u'luminanceSampleRate', _IS11172VideoCapability_luminanceSampleRate),
        (u'videoBadMBsCap', _IS11172VideoCapability_videoBadMBsCap),
        ])
    IS11172VideoCapability._ext = [u'videoBadMBsCap']
    
    #-----< AudioCapability >-----#
    AudioCapability = CHOICE(name=u'AudioCapability', mode=MODE_TYPE)
    _AudioCapability_nonStandard = SEQ(name=u'nonStandard', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')))
    _AudioCapability_g711Alaw64k = INT(name=u'g711Alaw64k', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AudioCapability_g711Alaw64k._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    _AudioCapability_g711Alaw56k = INT(name=u'g711Alaw56k', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AudioCapability_g711Alaw56k._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    _AudioCapability_g711Ulaw64k = INT(name=u'g711Ulaw64k', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AudioCapability_g711Ulaw64k._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    _AudioCapability_g711Ulaw56k = INT(name=u'g711Ulaw56k', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AudioCapability_g711Ulaw56k._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    _AudioCapability_g722_64k = INT(name=u'g722-64k', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AudioCapability_g722_64k._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    _AudioCapability_g722_56k = INT(name=u'g722-56k', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AudioCapability_g722_56k._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    _AudioCapability_g722_48k = INT(name=u'g722-48k', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AudioCapability_g722_48k._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    _AudioCapability_g7231 = SEQ(name=u'g7231', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __AudioCapability_g7231_maxAl_sduAudioFrames = INT(name=u'maxAl-sduAudioFrames', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __AudioCapability_g7231_maxAl_sduAudioFrames._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    __AudioCapability_g7231_silenceSuppression = BOOL(name=u'silenceSuppression', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AudioCapability_g7231._cont = ASN1Dict([
        (u'maxAl-sduAudioFrames', __AudioCapability_g7231_maxAl_sduAudioFrames),
        (u'silenceSuppression', __AudioCapability_g7231_silenceSuppression),
        ])
    _AudioCapability_g7231._ext = None
    _AudioCapability_g728 = INT(name=u'g728', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AudioCapability_g728._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    _AudioCapability_g729 = INT(name=u'g729', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AudioCapability_g729._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    _AudioCapability_g729AnnexA = INT(name=u'g729AnnexA', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AudioCapability_g729AnnexA._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    _AudioCapability_is11172AudioCapability = SEQ(name=u'is11172AudioCapability', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'IS11172AudioCapability')))
    _AudioCapability_is13818AudioCapability = SEQ(name=u'is13818AudioCapability', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'IS13818AudioCapability')))
    _AudioCapability_g729wAnnexB = INT(name=u'g729wAnnexB', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AudioCapability_g729wAnnexB._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    _AudioCapability_g729AnnexAwAnnexB = INT(name=u'g729AnnexAwAnnexB', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AudioCapability_g729AnnexAwAnnexB._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    _AudioCapability_g7231AnnexCCapability = SEQ(name=u'g7231AnnexCCapability', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'G7231AnnexCCapability')))
    _AudioCapability_gsmFullRate = SEQ(name=u'gsmFullRate', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'GSMAudioCapability')))
    _AudioCapability_gsmHalfRate = SEQ(name=u'gsmHalfRate', mode=MODE_TYPE, tag=(18, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'GSMAudioCapability')))
    _AudioCapability_gsmEnhancedFullRate = SEQ(name=u'gsmEnhancedFullRate', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'GSMAudioCapability')))
    _AudioCapability_genericAudioCapability = SEQ(name=u'genericAudioCapability', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'GenericCapability')))
    _AudioCapability_g729Extensions = SEQ(name=u'g729Extensions', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'G729Extensions')))
    _AudioCapability_vbd = SEQ(name=u'vbd', mode=MODE_TYPE, tag=(22, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'VBDCapability')))
    _AudioCapability_audioTelephonyEvent = SEQ(name=u'audioTelephonyEvent', mode=MODE_TYPE, tag=(23, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NoPTAudioTelephonyEventCapability')))
    _AudioCapability_audioTone = SEQ(name=u'audioTone', mode=MODE_TYPE, tag=(24, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NoPTAudioToneCapability')))
    AudioCapability._cont = ASN1Dict([
        (u'nonStandard', _AudioCapability_nonStandard),
        (u'g711Alaw64k', _AudioCapability_g711Alaw64k),
        (u'g711Alaw56k', _AudioCapability_g711Alaw56k),
        (u'g711Ulaw64k', _AudioCapability_g711Ulaw64k),
        (u'g711Ulaw56k', _AudioCapability_g711Ulaw56k),
        (u'g722-64k', _AudioCapability_g722_64k),
        (u'g722-56k', _AudioCapability_g722_56k),
        (u'g722-48k', _AudioCapability_g722_48k),
        (u'g7231', _AudioCapability_g7231),
        (u'g728', _AudioCapability_g728),
        (u'g729', _AudioCapability_g729),
        (u'g729AnnexA', _AudioCapability_g729AnnexA),
        (u'is11172AudioCapability', _AudioCapability_is11172AudioCapability),
        (u'is13818AudioCapability', _AudioCapability_is13818AudioCapability),
        (u'g729wAnnexB', _AudioCapability_g729wAnnexB),
        (u'g729AnnexAwAnnexB', _AudioCapability_g729AnnexAwAnnexB),
        (u'g7231AnnexCCapability', _AudioCapability_g7231AnnexCCapability),
        (u'gsmFullRate', _AudioCapability_gsmFullRate),
        (u'gsmHalfRate', _AudioCapability_gsmHalfRate),
        (u'gsmEnhancedFullRate', _AudioCapability_gsmEnhancedFullRate),
        (u'genericAudioCapability', _AudioCapability_genericAudioCapability),
        (u'g729Extensions', _AudioCapability_g729Extensions),
        (u'vbd', _AudioCapability_vbd),
        (u'audioTelephonyEvent', _AudioCapability_audioTelephonyEvent),
        (u'audioTone', _AudioCapability_audioTone),
        ])
    AudioCapability._ext = [u'g729wAnnexB', u'g729AnnexAwAnnexB', u'g7231AnnexCCapability', u'gsmFullRate', u'gsmHalfRate', u'gsmEnhancedFullRate', u'genericAudioCapability', u'g729Extensions', u'vbd', u'audioTelephonyEvent', u'audioTone']
    
    #-----< G729Extensions >-----#
    G729Extensions = SEQ(name=u'G729Extensions', mode=MODE_TYPE)
    _G729Extensions_audioUnit = INT(name=u'audioUnit', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _G729Extensions_audioUnit._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    _G729Extensions_annexA = BOOL(name=u'annexA', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _G729Extensions_annexB = BOOL(name=u'annexB', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _G729Extensions_annexD = BOOL(name=u'annexD', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _G729Extensions_annexE = BOOL(name=u'annexE', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _G729Extensions_annexF = BOOL(name=u'annexF', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _G729Extensions_annexG = BOOL(name=u'annexG', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _G729Extensions_annexH = BOOL(name=u'annexH', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    G729Extensions._cont = ASN1Dict([
        (u'audioUnit', _G729Extensions_audioUnit),
        (u'annexA', _G729Extensions_annexA),
        (u'annexB', _G729Extensions_annexB),
        (u'annexD', _G729Extensions_annexD),
        (u'annexE', _G729Extensions_annexE),
        (u'annexF', _G729Extensions_annexF),
        (u'annexG', _G729Extensions_annexG),
        (u'annexH', _G729Extensions_annexH),
        ])
    G729Extensions._ext = []
    
    #-----< G7231AnnexCCapability >-----#
    G7231AnnexCCapability = SEQ(name=u'G7231AnnexCCapability', mode=MODE_TYPE)
    _G7231AnnexCCapability_maxAl_sduAudioFrames = INT(name=u'maxAl-sduAudioFrames', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _G7231AnnexCCapability_maxAl_sduAudioFrames._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    _G7231AnnexCCapability_silenceSuppression = BOOL(name=u'silenceSuppression', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _G7231AnnexCCapability_g723AnnexCAudioMode = SEQ(name=u'g723AnnexCAudioMode', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __G7231AnnexCCapability_g723AnnexCAudioMode_highRateMode0 = INT(name=u'highRateMode0', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __G7231AnnexCCapability_g723AnnexCAudioMode_highRateMode0._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=27, ub=78)], ev=None, er=[])
    __G7231AnnexCCapability_g723AnnexCAudioMode_highRateMode1 = INT(name=u'highRateMode1', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __G7231AnnexCCapability_g723AnnexCAudioMode_highRateMode1._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=27, ub=78)], ev=None, er=[])
    __G7231AnnexCCapability_g723AnnexCAudioMode_lowRateMode0 = INT(name=u'lowRateMode0', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __G7231AnnexCCapability_g723AnnexCAudioMode_lowRateMode0._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=23, ub=66)], ev=None, er=[])
    __G7231AnnexCCapability_g723AnnexCAudioMode_lowRateMode1 = INT(name=u'lowRateMode1', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __G7231AnnexCCapability_g723AnnexCAudioMode_lowRateMode1._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=23, ub=66)], ev=None, er=[])
    __G7231AnnexCCapability_g723AnnexCAudioMode_sidMode0 = INT(name=u'sidMode0', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __G7231AnnexCCapability_g723AnnexCAudioMode_sidMode0._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=6, ub=17)], ev=None, er=[])
    __G7231AnnexCCapability_g723AnnexCAudioMode_sidMode1 = INT(name=u'sidMode1', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __G7231AnnexCCapability_g723AnnexCAudioMode_sidMode1._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=6, ub=17)], ev=None, er=[])
    _G7231AnnexCCapability_g723AnnexCAudioMode._cont = ASN1Dict([
        (u'highRateMode0', __G7231AnnexCCapability_g723AnnexCAudioMode_highRateMode0),
        (u'highRateMode1', __G7231AnnexCCapability_g723AnnexCAudioMode_highRateMode1),
        (u'lowRateMode0', __G7231AnnexCCapability_g723AnnexCAudioMode_lowRateMode0),
        (u'lowRateMode1', __G7231AnnexCCapability_g723AnnexCAudioMode_lowRateMode1),
        (u'sidMode0', __G7231AnnexCCapability_g723AnnexCAudioMode_sidMode0),
        (u'sidMode1', __G7231AnnexCCapability_g723AnnexCAudioMode_sidMode1),
        ])
    _G7231AnnexCCapability_g723AnnexCAudioMode._ext = []
    G7231AnnexCCapability._cont = ASN1Dict([
        (u'maxAl-sduAudioFrames', _G7231AnnexCCapability_maxAl_sduAudioFrames),
        (u'silenceSuppression', _G7231AnnexCCapability_silenceSuppression),
        (u'g723AnnexCAudioMode', _G7231AnnexCCapability_g723AnnexCAudioMode),
        ])
    G7231AnnexCCapability._ext = []
    
    #-----< IS11172AudioCapability >-----#
    IS11172AudioCapability = SEQ(name=u'IS11172AudioCapability', mode=MODE_TYPE)
    _IS11172AudioCapability_audioLayer1 = BOOL(name=u'audioLayer1', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IS11172AudioCapability_audioLayer2 = BOOL(name=u'audioLayer2', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IS11172AudioCapability_audioLayer3 = BOOL(name=u'audioLayer3', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IS11172AudioCapability_audioSampling32k = BOOL(name=u'audioSampling32k', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IS11172AudioCapability_audioSampling44k1 = BOOL(name=u'audioSampling44k1', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IS11172AudioCapability_audioSampling48k = BOOL(name=u'audioSampling48k', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IS11172AudioCapability_singleChannel = BOOL(name=u'singleChannel', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IS11172AudioCapability_twoChannels = BOOL(name=u'twoChannels', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IS11172AudioCapability_bitRate = INT(name=u'bitRate', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IS11172AudioCapability_bitRate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=448)], ev=None, er=[])
    IS11172AudioCapability._cont = ASN1Dict([
        (u'audioLayer1', _IS11172AudioCapability_audioLayer1),
        (u'audioLayer2', _IS11172AudioCapability_audioLayer2),
        (u'audioLayer3', _IS11172AudioCapability_audioLayer3),
        (u'audioSampling32k', _IS11172AudioCapability_audioSampling32k),
        (u'audioSampling44k1', _IS11172AudioCapability_audioSampling44k1),
        (u'audioSampling48k', _IS11172AudioCapability_audioSampling48k),
        (u'singleChannel', _IS11172AudioCapability_singleChannel),
        (u'twoChannels', _IS11172AudioCapability_twoChannels),
        (u'bitRate', _IS11172AudioCapability_bitRate),
        ])
    IS11172AudioCapability._ext = []
    
    #-----< IS13818AudioCapability >-----#
    IS13818AudioCapability = SEQ(name=u'IS13818AudioCapability', mode=MODE_TYPE)
    _IS13818AudioCapability_audioLayer1 = BOOL(name=u'audioLayer1', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IS13818AudioCapability_audioLayer2 = BOOL(name=u'audioLayer2', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IS13818AudioCapability_audioLayer3 = BOOL(name=u'audioLayer3', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IS13818AudioCapability_audioSampling16k = BOOL(name=u'audioSampling16k', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IS13818AudioCapability_audioSampling22k05 = BOOL(name=u'audioSampling22k05', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IS13818AudioCapability_audioSampling24k = BOOL(name=u'audioSampling24k', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IS13818AudioCapability_audioSampling32k = BOOL(name=u'audioSampling32k', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IS13818AudioCapability_audioSampling44k1 = BOOL(name=u'audioSampling44k1', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IS13818AudioCapability_audioSampling48k = BOOL(name=u'audioSampling48k', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IS13818AudioCapability_singleChannel = BOOL(name=u'singleChannel', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IS13818AudioCapability_twoChannels = BOOL(name=u'twoChannels', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IS13818AudioCapability_threeChannels2_1 = BOOL(name=u'threeChannels2-1', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IS13818AudioCapability_threeChannels3_0 = BOOL(name=u'threeChannels3-0', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IS13818AudioCapability_fourChannels2_0_2_0 = BOOL(name=u'fourChannels2-0-2-0', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IS13818AudioCapability_fourChannels2_2 = BOOL(name=u'fourChannels2-2', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IS13818AudioCapability_fourChannels3_1 = BOOL(name=u'fourChannels3-1', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IS13818AudioCapability_fiveChannels3_0_2_0 = BOOL(name=u'fiveChannels3-0-2-0', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IS13818AudioCapability_fiveChannels3_2 = BOOL(name=u'fiveChannels3-2', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IS13818AudioCapability_lowFrequencyEnhancement = BOOL(name=u'lowFrequencyEnhancement', mode=MODE_TYPE, tag=(18, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IS13818AudioCapability_multilingual = BOOL(name=u'multilingual', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IS13818AudioCapability_bitRate = INT(name=u'bitRate', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IS13818AudioCapability_bitRate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=1130)], ev=None, er=[])
    IS13818AudioCapability._cont = ASN1Dict([
        (u'audioLayer1', _IS13818AudioCapability_audioLayer1),
        (u'audioLayer2', _IS13818AudioCapability_audioLayer2),
        (u'audioLayer3', _IS13818AudioCapability_audioLayer3),
        (u'audioSampling16k', _IS13818AudioCapability_audioSampling16k),
        (u'audioSampling22k05', _IS13818AudioCapability_audioSampling22k05),
        (u'audioSampling24k', _IS13818AudioCapability_audioSampling24k),
        (u'audioSampling32k', _IS13818AudioCapability_audioSampling32k),
        (u'audioSampling44k1', _IS13818AudioCapability_audioSampling44k1),
        (u'audioSampling48k', _IS13818AudioCapability_audioSampling48k),
        (u'singleChannel', _IS13818AudioCapability_singleChannel),
        (u'twoChannels', _IS13818AudioCapability_twoChannels),
        (u'threeChannels2-1', _IS13818AudioCapability_threeChannels2_1),
        (u'threeChannels3-0', _IS13818AudioCapability_threeChannels3_0),
        (u'fourChannels2-0-2-0', _IS13818AudioCapability_fourChannels2_0_2_0),
        (u'fourChannels2-2', _IS13818AudioCapability_fourChannels2_2),
        (u'fourChannels3-1', _IS13818AudioCapability_fourChannels3_1),
        (u'fiveChannels3-0-2-0', _IS13818AudioCapability_fiveChannels3_0_2_0),
        (u'fiveChannels3-2', _IS13818AudioCapability_fiveChannels3_2),
        (u'lowFrequencyEnhancement', _IS13818AudioCapability_lowFrequencyEnhancement),
        (u'multilingual', _IS13818AudioCapability_multilingual),
        (u'bitRate', _IS13818AudioCapability_bitRate),
        ])
    IS13818AudioCapability._ext = []
    
    #-----< GSMAudioCapability >-----#
    GSMAudioCapability = SEQ(name=u'GSMAudioCapability', mode=MODE_TYPE)
    _GSMAudioCapability_audioUnitSize = INT(name=u'audioUnitSize', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GSMAudioCapability_audioUnitSize._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    _GSMAudioCapability_comfortNoise = BOOL(name=u'comfortNoise', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GSMAudioCapability_scrambled = BOOL(name=u'scrambled', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    GSMAudioCapability._cont = ASN1Dict([
        (u'audioUnitSize', _GSMAudioCapability_audioUnitSize),
        (u'comfortNoise', _GSMAudioCapability_comfortNoise),
        (u'scrambled', _GSMAudioCapability_scrambled),
        ])
    GSMAudioCapability._ext = []
    
    #-----< VBDCapability >-----#
    VBDCapability = SEQ(name=u'VBDCapability', mode=MODE_TYPE)
    _VBDCapability_type = CHOICE(name=u'type', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'AudioCapability')))
    VBDCapability._cont = ASN1Dict([
        (u'type', _VBDCapability_type),
        ])
    VBDCapability._ext = []
    
    #-----< DataApplicationCapability >-----#
    DataApplicationCapability = SEQ(name=u'DataApplicationCapability', mode=MODE_TYPE)
    _DataApplicationCapability_application = CHOICE(name=u'application', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __DataApplicationCapability_application_nonStandard = SEQ(name=u'nonStandard', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')))
    __DataApplicationCapability_application_t120 = CHOICE(name=u't120', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DataProtocolCapability')))
    __DataApplicationCapability_application_dsm_cc = CHOICE(name=u'dsm-cc', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DataProtocolCapability')))
    __DataApplicationCapability_application_userData = CHOICE(name=u'userData', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DataProtocolCapability')))
    __DataApplicationCapability_application_t84 = SEQ(name=u't84', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___DataApplicationCapability_application_t84_t84Protocol = CHOICE(name=u't84Protocol', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DataProtocolCapability')))
    ___DataApplicationCapability_application_t84_t84Profile = CHOICE(name=u't84Profile', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'T84Profile')))
    __DataApplicationCapability_application_t84._cont = ASN1Dict([
        (u't84Protocol', ___DataApplicationCapability_application_t84_t84Protocol),
        (u't84Profile', ___DataApplicationCapability_application_t84_t84Profile),
        ])
    __DataApplicationCapability_application_t84._ext = None
    __DataApplicationCapability_application_t434 = CHOICE(name=u't434', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DataProtocolCapability')))
    __DataApplicationCapability_application_h224 = CHOICE(name=u'h224', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DataProtocolCapability')))
    __DataApplicationCapability_application_nlpid = SEQ(name=u'nlpid', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___DataApplicationCapability_application_nlpid_nlpidProtocol = CHOICE(name=u'nlpidProtocol', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DataProtocolCapability')))
    ___DataApplicationCapability_application_nlpid_nlpidData = OCT_STR(name=u'nlpidData', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __DataApplicationCapability_application_nlpid._cont = ASN1Dict([
        (u'nlpidProtocol', ___DataApplicationCapability_application_nlpid_nlpidProtocol),
        (u'nlpidData', ___DataApplicationCapability_application_nlpid_nlpidData),
        ])
    __DataApplicationCapability_application_nlpid._ext = None
    __DataApplicationCapability_application_dsvdControl = NULL(name=u'dsvdControl', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __DataApplicationCapability_application_h222DataPartitioning = CHOICE(name=u'h222DataPartitioning', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DataProtocolCapability')))
    __DataApplicationCapability_application_t30fax = CHOICE(name=u't30fax', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DataProtocolCapability')))
    __DataApplicationCapability_application_t140 = CHOICE(name=u't140', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DataProtocolCapability')))
    __DataApplicationCapability_application_t38fax = SEQ(name=u't38fax', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___DataApplicationCapability_application_t38fax_t38FaxProtocol = CHOICE(name=u't38FaxProtocol', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DataProtocolCapability')))
    ___DataApplicationCapability_application_t38fax_t38FaxProfile = SEQ(name=u't38FaxProfile', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'T38FaxProfile')))
    __DataApplicationCapability_application_t38fax._cont = ASN1Dict([
        (u't38FaxProtocol', ___DataApplicationCapability_application_t38fax_t38FaxProtocol),
        (u't38FaxProfile', ___DataApplicationCapability_application_t38fax_t38FaxProfile),
        ])
    __DataApplicationCapability_application_t38fax._ext = None
    __DataApplicationCapability_application_genericDataCapability = SEQ(name=u'genericDataCapability', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'GenericCapability')))
    _DataApplicationCapability_application._cont = ASN1Dict([
        (u'nonStandard', __DataApplicationCapability_application_nonStandard),
        (u't120', __DataApplicationCapability_application_t120),
        (u'dsm-cc', __DataApplicationCapability_application_dsm_cc),
        (u'userData', __DataApplicationCapability_application_userData),
        (u't84', __DataApplicationCapability_application_t84),
        (u't434', __DataApplicationCapability_application_t434),
        (u'h224', __DataApplicationCapability_application_h224),
        (u'nlpid', __DataApplicationCapability_application_nlpid),
        (u'dsvdControl', __DataApplicationCapability_application_dsvdControl),
        (u'h222DataPartitioning', __DataApplicationCapability_application_h222DataPartitioning),
        (u't30fax', __DataApplicationCapability_application_t30fax),
        (u't140', __DataApplicationCapability_application_t140),
        (u't38fax', __DataApplicationCapability_application_t38fax),
        (u'genericDataCapability', __DataApplicationCapability_application_genericDataCapability),
        ])
    _DataApplicationCapability_application._ext = [u't30fax', u't140', u't38fax', u'genericDataCapability']
    _DataApplicationCapability_maxBitRate = INT(name=u'maxBitRate', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _DataApplicationCapability_maxBitRate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4294967295)], ev=None, er=[])
    DataApplicationCapability._cont = ASN1Dict([
        (u'application', _DataApplicationCapability_application),
        (u'maxBitRate', _DataApplicationCapability_maxBitRate),
        ])
    DataApplicationCapability._ext = []
    
    #-----< DataProtocolCapability >-----#
    DataProtocolCapability = CHOICE(name=u'DataProtocolCapability', mode=MODE_TYPE)
    _DataProtocolCapability_nonStandard = SEQ(name=u'nonStandard', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')))
    _DataProtocolCapability_v14buffered = NULL(name=u'v14buffered', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _DataProtocolCapability_v42lapm = NULL(name=u'v42lapm', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _DataProtocolCapability_hdlcFrameTunnelling = NULL(name=u'hdlcFrameTunnelling', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _DataProtocolCapability_h310SeparateVCStack = NULL(name=u'h310SeparateVCStack', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _DataProtocolCapability_h310SingleVCStack = NULL(name=u'h310SingleVCStack', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _DataProtocolCapability_transparent = NULL(name=u'transparent', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _DataProtocolCapability_segmentationAndReassembly = NULL(name=u'segmentationAndReassembly', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _DataProtocolCapability_hdlcFrameTunnelingwSAR = NULL(name=u'hdlcFrameTunnelingwSAR', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _DataProtocolCapability_v120 = NULL(name=u'v120', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _DataProtocolCapability_separateLANStack = NULL(name=u'separateLANStack', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _DataProtocolCapability_v76wCompression = CHOICE(name=u'v76wCompression', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __DataProtocolCapability_v76wCompression_transmitCompression = CHOICE(name=u'transmitCompression', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'CompressionType')))
    __DataProtocolCapability_v76wCompression_receiveCompression = CHOICE(name=u'receiveCompression', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'CompressionType')))
    __DataProtocolCapability_v76wCompression_transmitAndReceiveCompression = CHOICE(name=u'transmitAndReceiveCompression', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'CompressionType')))
    _DataProtocolCapability_v76wCompression._cont = ASN1Dict([
        (u'transmitCompression', __DataProtocolCapability_v76wCompression_transmitCompression),
        (u'receiveCompression', __DataProtocolCapability_v76wCompression_receiveCompression),
        (u'transmitAndReceiveCompression', __DataProtocolCapability_v76wCompression_transmitAndReceiveCompression),
        ])
    _DataProtocolCapability_v76wCompression._ext = []
    _DataProtocolCapability_tcp = NULL(name=u'tcp', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _DataProtocolCapability_udp = NULL(name=u'udp', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    DataProtocolCapability._cont = ASN1Dict([
        (u'nonStandard', _DataProtocolCapability_nonStandard),
        (u'v14buffered', _DataProtocolCapability_v14buffered),
        (u'v42lapm', _DataProtocolCapability_v42lapm),
        (u'hdlcFrameTunnelling', _DataProtocolCapability_hdlcFrameTunnelling),
        (u'h310SeparateVCStack', _DataProtocolCapability_h310SeparateVCStack),
        (u'h310SingleVCStack', _DataProtocolCapability_h310SingleVCStack),
        (u'transparent', _DataProtocolCapability_transparent),
        (u'segmentationAndReassembly', _DataProtocolCapability_segmentationAndReassembly),
        (u'hdlcFrameTunnelingwSAR', _DataProtocolCapability_hdlcFrameTunnelingwSAR),
        (u'v120', _DataProtocolCapability_v120),
        (u'separateLANStack', _DataProtocolCapability_separateLANStack),
        (u'v76wCompression', _DataProtocolCapability_v76wCompression),
        (u'tcp', _DataProtocolCapability_tcp),
        (u'udp', _DataProtocolCapability_udp),
        ])
    DataProtocolCapability._ext = [u'segmentationAndReassembly', u'hdlcFrameTunnelingwSAR', u'v120', u'separateLANStack', u'v76wCompression', u'tcp', u'udp']
    
    #-----< CompressionType >-----#
    CompressionType = CHOICE(name=u'CompressionType', mode=MODE_TYPE)
    _CompressionType_v42bis = SEQ(name=u'v42bis', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'V42bis')))
    CompressionType._cont = ASN1Dict([
        (u'v42bis', _CompressionType_v42bis),
        ])
    CompressionType._ext = []
    
    #-----< V42bis >-----#
    V42bis = SEQ(name=u'V42bis', mode=MODE_TYPE)
    _V42bis_numberOfCodewords = INT(name=u'numberOfCodewords', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _V42bis_numberOfCodewords._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65536)], ev=None, er=[])
    _V42bis_maximumStringLength = INT(name=u'maximumStringLength', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _V42bis_maximumStringLength._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    V42bis._cont = ASN1Dict([
        (u'numberOfCodewords', _V42bis_numberOfCodewords),
        (u'maximumStringLength', _V42bis_maximumStringLength),
        ])
    V42bis._ext = []
    
    #-----< T84Profile >-----#
    T84Profile = CHOICE(name=u'T84Profile', mode=MODE_TYPE)
    _T84Profile_t84Unrestricted = NULL(name=u't84Unrestricted', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _T84Profile_t84Restricted = SEQ(name=u't84Restricted', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __T84Profile_t84Restricted_qcif = BOOL(name=u'qcif', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __T84Profile_t84Restricted_cif = BOOL(name=u'cif', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __T84Profile_t84Restricted_ccir601Seq = BOOL(name=u'ccir601Seq', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __T84Profile_t84Restricted_ccir601Prog = BOOL(name=u'ccir601Prog', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __T84Profile_t84Restricted_hdtvSeq = BOOL(name=u'hdtvSeq', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __T84Profile_t84Restricted_hdtvProg = BOOL(name=u'hdtvProg', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __T84Profile_t84Restricted_g3FacsMH200x100 = BOOL(name=u'g3FacsMH200x100', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __T84Profile_t84Restricted_g3FacsMH200x200 = BOOL(name=u'g3FacsMH200x200', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __T84Profile_t84Restricted_g4FacsMMR200x100 = BOOL(name=u'g4FacsMMR200x100', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __T84Profile_t84Restricted_g4FacsMMR200x200 = BOOL(name=u'g4FacsMMR200x200', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __T84Profile_t84Restricted_jbig200x200Seq = BOOL(name=u'jbig200x200Seq', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __T84Profile_t84Restricted_jbig200x200Prog = BOOL(name=u'jbig200x200Prog', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __T84Profile_t84Restricted_jbig300x300Seq = BOOL(name=u'jbig300x300Seq', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __T84Profile_t84Restricted_jbig300x300Prog = BOOL(name=u'jbig300x300Prog', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __T84Profile_t84Restricted_digPhotoLow = BOOL(name=u'digPhotoLow', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __T84Profile_t84Restricted_digPhotoMedSeq = BOOL(name=u'digPhotoMedSeq', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __T84Profile_t84Restricted_digPhotoMedProg = BOOL(name=u'digPhotoMedProg', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __T84Profile_t84Restricted_digPhotoHighSeq = BOOL(name=u'digPhotoHighSeq', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __T84Profile_t84Restricted_digPhotoHighProg = BOOL(name=u'digPhotoHighProg', mode=MODE_TYPE, tag=(18, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _T84Profile_t84Restricted._cont = ASN1Dict([
        (u'qcif', __T84Profile_t84Restricted_qcif),
        (u'cif', __T84Profile_t84Restricted_cif),
        (u'ccir601Seq', __T84Profile_t84Restricted_ccir601Seq),
        (u'ccir601Prog', __T84Profile_t84Restricted_ccir601Prog),
        (u'hdtvSeq', __T84Profile_t84Restricted_hdtvSeq),
        (u'hdtvProg', __T84Profile_t84Restricted_hdtvProg),
        (u'g3FacsMH200x100', __T84Profile_t84Restricted_g3FacsMH200x100),
        (u'g3FacsMH200x200', __T84Profile_t84Restricted_g3FacsMH200x200),
        (u'g4FacsMMR200x100', __T84Profile_t84Restricted_g4FacsMMR200x100),
        (u'g4FacsMMR200x200', __T84Profile_t84Restricted_g4FacsMMR200x200),
        (u'jbig200x200Seq', __T84Profile_t84Restricted_jbig200x200Seq),
        (u'jbig200x200Prog', __T84Profile_t84Restricted_jbig200x200Prog),
        (u'jbig300x300Seq', __T84Profile_t84Restricted_jbig300x300Seq),
        (u'jbig300x300Prog', __T84Profile_t84Restricted_jbig300x300Prog),
        (u'digPhotoLow', __T84Profile_t84Restricted_digPhotoLow),
        (u'digPhotoMedSeq', __T84Profile_t84Restricted_digPhotoMedSeq),
        (u'digPhotoMedProg', __T84Profile_t84Restricted_digPhotoMedProg),
        (u'digPhotoHighSeq', __T84Profile_t84Restricted_digPhotoHighSeq),
        (u'digPhotoHighProg', __T84Profile_t84Restricted_digPhotoHighProg),
        ])
    _T84Profile_t84Restricted._ext = []
    T84Profile._cont = ASN1Dict([
        (u't84Unrestricted', _T84Profile_t84Unrestricted),
        (u't84Restricted', _T84Profile_t84Restricted),
        ])
    T84Profile._ext = None
    
    #-----< T38FaxProfile >-----#
    T38FaxProfile = SEQ(name=u'T38FaxProfile', mode=MODE_TYPE)
    _T38FaxProfile_fillBitRemoval = BOOL(name=u'fillBitRemoval', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _T38FaxProfile_transcodingJBIG = BOOL(name=u'transcodingJBIG', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _T38FaxProfile_transcodingMMR = BOOL(name=u'transcodingMMR', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _T38FaxProfile_version = INT(name=u'version', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _T38FaxProfile_version._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _T38FaxProfile_t38FaxRateManagement = CHOICE(name=u't38FaxRateManagement', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'T38FaxRateManagement')))
    _T38FaxProfile_t38FaxUdpOptions = SEQ(name=u't38FaxUdpOptions', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'T38FaxUdpOptions')), opt=True)
    _T38FaxProfile_t38FaxTcpOptions = SEQ(name=u't38FaxTcpOptions', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'T38FaxTcpOptions')), opt=True)
    T38FaxProfile._cont = ASN1Dict([
        (u'fillBitRemoval', _T38FaxProfile_fillBitRemoval),
        (u'transcodingJBIG', _T38FaxProfile_transcodingJBIG),
        (u'transcodingMMR', _T38FaxProfile_transcodingMMR),
        (u'version', _T38FaxProfile_version),
        (u't38FaxRateManagement', _T38FaxProfile_t38FaxRateManagement),
        (u't38FaxUdpOptions', _T38FaxProfile_t38FaxUdpOptions),
        (u't38FaxTcpOptions', _T38FaxProfile_t38FaxTcpOptions),
        ])
    T38FaxProfile._ext = [u'version', u't38FaxRateManagement', u't38FaxUdpOptions', u't38FaxTcpOptions']
    
    #-----< T38FaxRateManagement >-----#
    T38FaxRateManagement = CHOICE(name=u'T38FaxRateManagement', mode=MODE_TYPE)
    _T38FaxRateManagement_localTCF = NULL(name=u'localTCF', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _T38FaxRateManagement_transferredTCF = NULL(name=u'transferredTCF', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    T38FaxRateManagement._cont = ASN1Dict([
        (u'localTCF', _T38FaxRateManagement_localTCF),
        (u'transferredTCF', _T38FaxRateManagement_transferredTCF),
        ])
    T38FaxRateManagement._ext = []
    
    #-----< T38FaxUdpOptions >-----#
    T38FaxUdpOptions = SEQ(name=u'T38FaxUdpOptions', mode=MODE_TYPE)
    _T38FaxUdpOptions_t38FaxMaxBuffer = INT(name=u't38FaxMaxBuffer', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _T38FaxUdpOptions_t38FaxMaxDatagram = INT(name=u't38FaxMaxDatagram', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _T38FaxUdpOptions_t38FaxUdpEC = CHOICE(name=u't38FaxUdpEC', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __T38FaxUdpOptions_t38FaxUdpEC_t38UDPFEC = NULL(name=u't38UDPFEC', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __T38FaxUdpOptions_t38FaxUdpEC_t38UDPRedundancy = NULL(name=u't38UDPRedundancy', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _T38FaxUdpOptions_t38FaxUdpEC._cont = ASN1Dict([
        (u't38UDPFEC', __T38FaxUdpOptions_t38FaxUdpEC_t38UDPFEC),
        (u't38UDPRedundancy', __T38FaxUdpOptions_t38FaxUdpEC_t38UDPRedundancy),
        ])
    _T38FaxUdpOptions_t38FaxUdpEC._ext = []
    T38FaxUdpOptions._cont = ASN1Dict([
        (u't38FaxMaxBuffer', _T38FaxUdpOptions_t38FaxMaxBuffer),
        (u't38FaxMaxDatagram', _T38FaxUdpOptions_t38FaxMaxDatagram),
        (u't38FaxUdpEC', _T38FaxUdpOptions_t38FaxUdpEC),
        ])
    T38FaxUdpOptions._ext = None
    
    #-----< T38FaxTcpOptions >-----#
    T38FaxTcpOptions = SEQ(name=u'T38FaxTcpOptions', mode=MODE_TYPE)
    _T38FaxTcpOptions_t38TCPBidirectionalMode = BOOL(name=u't38TCPBidirectionalMode', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    T38FaxTcpOptions._cont = ASN1Dict([
        (u't38TCPBidirectionalMode', _T38FaxTcpOptions_t38TCPBidirectionalMode),
        ])
    T38FaxTcpOptions._ext = []
    
    #-----< EncryptionAuthenticationAndIntegrity >-----#
    EncryptionAuthenticationAndIntegrity = SEQ(name=u'EncryptionAuthenticationAndIntegrity', mode=MODE_TYPE)
    _EncryptionAuthenticationAndIntegrity_encryptionCapability = SEQ_OF(name=u'encryptionCapability', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'EncryptionCapability')), opt=True)
    _EncryptionAuthenticationAndIntegrity_authenticationCapability = SEQ(name=u'authenticationCapability', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'AuthenticationCapability')), opt=True)
    _EncryptionAuthenticationAndIntegrity_integrityCapability = SEQ(name=u'integrityCapability', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'IntegrityCapability')), opt=True)
    _EncryptionAuthenticationAndIntegrity_genericH235SecurityCapability = SEQ(name=u'genericH235SecurityCapability', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'GenericCapability')), opt=True)
    EncryptionAuthenticationAndIntegrity._cont = ASN1Dict([
        (u'encryptionCapability', _EncryptionAuthenticationAndIntegrity_encryptionCapability),
        (u'authenticationCapability', _EncryptionAuthenticationAndIntegrity_authenticationCapability),
        (u'integrityCapability', _EncryptionAuthenticationAndIntegrity_integrityCapability),
        (u'genericH235SecurityCapability', _EncryptionAuthenticationAndIntegrity_genericH235SecurityCapability),
        ])
    EncryptionAuthenticationAndIntegrity._ext = [u'genericH235SecurityCapability']
    
    #-----< EncryptionCapability >-----#
    EncryptionCapability = SEQ_OF(name=u'EncryptionCapability', mode=MODE_TYPE)
    _EncryptionCapability__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MediaEncryptionAlgorithm')))
    EncryptionCapability._cont = _EncryptionCapability__item_
    EncryptionCapability._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    
    #-----< MediaEncryptionAlgorithm >-----#
    MediaEncryptionAlgorithm = CHOICE(name=u'MediaEncryptionAlgorithm', mode=MODE_TYPE)
    _MediaEncryptionAlgorithm_nonStandard = SEQ(name=u'nonStandard', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')))
    _MediaEncryptionAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    MediaEncryptionAlgorithm._cont = ASN1Dict([
        (u'nonStandard', _MediaEncryptionAlgorithm_nonStandard),
        (u'algorithm', _MediaEncryptionAlgorithm_algorithm),
        ])
    MediaEncryptionAlgorithm._ext = []
    
    #-----< AuthenticationCapability >-----#
    AuthenticationCapability = SEQ(name=u'AuthenticationCapability', mode=MODE_TYPE)
    _AuthenticationCapability_nonStandard = SEQ(name=u'nonStandard', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')), opt=True)
    _AuthenticationCapability_antiSpamAlgorithm = OID(name=u'antiSpamAlgorithm', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    AuthenticationCapability._cont = ASN1Dict([
        (u'nonStandard', _AuthenticationCapability_nonStandard),
        (u'antiSpamAlgorithm', _AuthenticationCapability_antiSpamAlgorithm),
        ])
    AuthenticationCapability._ext = [u'antiSpamAlgorithm']
    
    #-----< IntegrityCapability >-----#
    IntegrityCapability = SEQ(name=u'IntegrityCapability', mode=MODE_TYPE)
    _IntegrityCapability_nonStandard = SEQ(name=u'nonStandard', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')), opt=True)
    IntegrityCapability._cont = ASN1Dict([
        (u'nonStandard', _IntegrityCapability_nonStandard),
        ])
    IntegrityCapability._ext = []
    
    #-----< UserInputCapability >-----#
    UserInputCapability = CHOICE(name=u'UserInputCapability', mode=MODE_TYPE)
    _UserInputCapability_nonStandard = SEQ_OF(name=u'nonStandard', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __UserInputCapability_nonStandard__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')))
    _UserInputCapability_nonStandard._cont = __UserInputCapability_nonStandard__item_
    _UserInputCapability_nonStandard._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    _UserInputCapability_basicString = NULL(name=u'basicString', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UserInputCapability_iA5String = NULL(name=u'iA5String', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UserInputCapability_generalString = NULL(name=u'generalString', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UserInputCapability_dtmf = NULL(name=u'dtmf', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UserInputCapability_hookflash = NULL(name=u'hookflash', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UserInputCapability_extendedAlphanumeric = NULL(name=u'extendedAlphanumeric', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UserInputCapability_encryptedBasicString = NULL(name=u'encryptedBasicString', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UserInputCapability_encryptedIA5String = NULL(name=u'encryptedIA5String', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UserInputCapability_encryptedGeneralString = NULL(name=u'encryptedGeneralString', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UserInputCapability_secureDTMF = NULL(name=u'secureDTMF', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UserInputCapability_genericUserInputCapability = SEQ(name=u'genericUserInputCapability', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'GenericCapability')))
    UserInputCapability._cont = ASN1Dict([
        (u'nonStandard', _UserInputCapability_nonStandard),
        (u'basicString', _UserInputCapability_basicString),
        (u'iA5String', _UserInputCapability_iA5String),
        (u'generalString', _UserInputCapability_generalString),
        (u'dtmf', _UserInputCapability_dtmf),
        (u'hookflash', _UserInputCapability_hookflash),
        (u'extendedAlphanumeric', _UserInputCapability_extendedAlphanumeric),
        (u'encryptedBasicString', _UserInputCapability_encryptedBasicString),
        (u'encryptedIA5String', _UserInputCapability_encryptedIA5String),
        (u'encryptedGeneralString', _UserInputCapability_encryptedGeneralString),
        (u'secureDTMF', _UserInputCapability_secureDTMF),
        (u'genericUserInputCapability', _UserInputCapability_genericUserInputCapability),
        ])
    UserInputCapability._ext = [u'extendedAlphanumeric', u'encryptedBasicString', u'encryptedIA5String', u'encryptedGeneralString', u'secureDTMF', u'genericUserInputCapability']
    
    #-----< ConferenceCapability >-----#
    ConferenceCapability = SEQ(name=u'ConferenceCapability', mode=MODE_TYPE)
    _ConferenceCapability_nonStandardData = SEQ_OF(name=u'nonStandardData', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __ConferenceCapability_nonStandardData__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')))
    _ConferenceCapability_nonStandardData._cont = __ConferenceCapability_nonStandardData__item_
    _ConferenceCapability_chairControlCapability = BOOL(name=u'chairControlCapability', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ConferenceCapability_videoIndicateMixingCapability = BOOL(name=u'videoIndicateMixingCapability', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ConferenceCapability_multipointVisualizationCapability = BOOL(name=u'multipointVisualizationCapability', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    ConferenceCapability._cont = ASN1Dict([
        (u'nonStandardData', _ConferenceCapability_nonStandardData),
        (u'chairControlCapability', _ConferenceCapability_chairControlCapability),
        (u'videoIndicateMixingCapability', _ConferenceCapability_videoIndicateMixingCapability),
        (u'multipointVisualizationCapability', _ConferenceCapability_multipointVisualizationCapability),
        ])
    ConferenceCapability._ext = [u'videoIndicateMixingCapability', u'multipointVisualizationCapability']
    
    #-----< GenericCapability >-----#
    GenericCapability = SEQ(name=u'GenericCapability', mode=MODE_TYPE)
    _GenericCapability_capabilityIdentifier = CHOICE(name=u'capabilityIdentifier', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'CapabilityIdentifier')))
    _GenericCapability_maxBitRate = INT(name=u'maxBitRate', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GenericCapability_maxBitRate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4294967295)], ev=None, er=[])
    _GenericCapability_collapsing = SEQ_OF(name=u'collapsing', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __GenericCapability_collapsing__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'GenericParameter')))
    _GenericCapability_collapsing._cont = __GenericCapability_collapsing__item_
    _GenericCapability_nonCollapsing = SEQ_OF(name=u'nonCollapsing', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __GenericCapability_nonCollapsing__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'GenericParameter')))
    _GenericCapability_nonCollapsing._cont = __GenericCapability_nonCollapsing__item_
    _GenericCapability_nonCollapsingRaw = OCT_STR(name=u'nonCollapsingRaw', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GenericCapability_transport = CHOICE(name=u'transport', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DataProtocolCapability')), opt=True)
    GenericCapability._cont = ASN1Dict([
        (u'capabilityIdentifier', _GenericCapability_capabilityIdentifier),
        (u'maxBitRate', _GenericCapability_maxBitRate),
        (u'collapsing', _GenericCapability_collapsing),
        (u'nonCollapsing', _GenericCapability_nonCollapsing),
        (u'nonCollapsingRaw', _GenericCapability_nonCollapsingRaw),
        (u'transport', _GenericCapability_transport),
        ])
    GenericCapability._ext = []
    
    #-----< CapabilityIdentifier >-----#
    CapabilityIdentifier = CHOICE(name=u'CapabilityIdentifier', mode=MODE_TYPE)
    _CapabilityIdentifier_standard = OID(name=u'standard', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _CapabilityIdentifier_h221NonStandard = SEQ(name=u'h221NonStandard', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')))
    _CapabilityIdentifier_uuid = OCT_STR(name=u'uuid', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _CapabilityIdentifier_uuid._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _CapabilityIdentifier_domainBased = STR_IA5(name=u'domainBased', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _CapabilityIdentifier_domainBased._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    CapabilityIdentifier._cont = ASN1Dict([
        (u'standard', _CapabilityIdentifier_standard),
        (u'h221NonStandard', _CapabilityIdentifier_h221NonStandard),
        (u'uuid', _CapabilityIdentifier_uuid),
        (u'domainBased', _CapabilityIdentifier_domainBased),
        ])
    CapabilityIdentifier._ext = []
    
    #-----< GenericParameter >-----#
    GenericParameter = SEQ(name=u'GenericParameter', mode=MODE_TYPE)
    _GenericParameter_parameterIdentifier = CHOICE(name=u'parameterIdentifier', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'ParameterIdentifier')))
    _GenericParameter_parameterValue = CHOICE(name=u'parameterValue', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'ParameterValue')))
    _GenericParameter_supersedes = SEQ_OF(name=u'supersedes', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __GenericParameter_supersedes__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'ParameterIdentifier')))
    _GenericParameter_supersedes._cont = __GenericParameter_supersedes__item_
    GenericParameter._cont = ASN1Dict([
        (u'parameterIdentifier', _GenericParameter_parameterIdentifier),
        (u'parameterValue', _GenericParameter_parameterValue),
        (u'supersedes', _GenericParameter_supersedes),
        ])
    GenericParameter._ext = []
    
    #-----< ParameterIdentifier >-----#
    ParameterIdentifier = CHOICE(name=u'ParameterIdentifier', mode=MODE_TYPE)
    _ParameterIdentifier_standard = INT(name=u'standard', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ParameterIdentifier_standard._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    _ParameterIdentifier_h221NonStandard = SEQ(name=u'h221NonStandard', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')))
    _ParameterIdentifier_uuid = OCT_STR(name=u'uuid', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ParameterIdentifier_uuid._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _ParameterIdentifier_domainBased = STR_IA5(name=u'domainBased', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ParameterIdentifier_domainBased._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    ParameterIdentifier._cont = ASN1Dict([
        (u'standard', _ParameterIdentifier_standard),
        (u'h221NonStandard', _ParameterIdentifier_h221NonStandard),
        (u'uuid', _ParameterIdentifier_uuid),
        (u'domainBased', _ParameterIdentifier_domainBased),
        ])
    ParameterIdentifier._ext = []
    
    #-----< ParameterValue >-----#
    ParameterValue = CHOICE(name=u'ParameterValue', mode=MODE_TYPE)
    _ParameterValue_logical = NULL(name=u'logical', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ParameterValue_booleanArray = INT(name=u'booleanArray', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ParameterValue_booleanArray._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _ParameterValue_unsignedMin = INT(name=u'unsignedMin', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ParameterValue_unsignedMin._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    _ParameterValue_unsignedMax = INT(name=u'unsignedMax', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ParameterValue_unsignedMax._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    _ParameterValue_unsigned32Min = INT(name=u'unsigned32Min', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ParameterValue_unsigned32Min._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4294967295)], ev=None, er=[])
    _ParameterValue_unsigned32Max = INT(name=u'unsigned32Max', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ParameterValue_unsigned32Max._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4294967295)], ev=None, er=[])
    _ParameterValue_octetString = OCT_STR(name=u'octetString', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ParameterValue_genericParameter = SEQ_OF(name=u'genericParameter', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __ParameterValue_genericParameter__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'GenericParameter')))
    _ParameterValue_genericParameter._cont = __ParameterValue_genericParameter__item_
    ParameterValue._cont = ASN1Dict([
        (u'logical', _ParameterValue_logical),
        (u'booleanArray', _ParameterValue_booleanArray),
        (u'unsignedMin', _ParameterValue_unsignedMin),
        (u'unsignedMax', _ParameterValue_unsignedMax),
        (u'unsigned32Min', _ParameterValue_unsigned32Min),
        (u'unsigned32Max', _ParameterValue_unsigned32Max),
        (u'octetString', _ParameterValue_octetString),
        (u'genericParameter', _ParameterValue_genericParameter),
        ])
    ParameterValue._ext = []
    
    #-----< MultiplexedStreamCapability >-----#
    MultiplexedStreamCapability = SEQ(name=u'MultiplexedStreamCapability', mode=MODE_TYPE)
    _MultiplexedStreamCapability_multiplexFormat = CHOICE(name=u'multiplexFormat', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MultiplexFormat')))
    _MultiplexedStreamCapability_controlOnMuxStream = BOOL(name=u'controlOnMuxStream', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MultiplexedStreamCapability_capabilityOnMuxStream = SET_OF(name=u'capabilityOnMuxStream', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __MultiplexedStreamCapability_capabilityOnMuxStream__item_ = SEQ_OF(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'AlternativeCapabilitySet')))
    _MultiplexedStreamCapability_capabilityOnMuxStream._cont = __MultiplexedStreamCapability_capabilityOnMuxStream__item_
    _MultiplexedStreamCapability_capabilityOnMuxStream._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    MultiplexedStreamCapability._cont = ASN1Dict([
        (u'multiplexFormat', _MultiplexedStreamCapability_multiplexFormat),
        (u'controlOnMuxStream', _MultiplexedStreamCapability_controlOnMuxStream),
        (u'capabilityOnMuxStream', _MultiplexedStreamCapability_capabilityOnMuxStream),
        ])
    MultiplexedStreamCapability._ext = []
    
    #-----< MultiplexFormat >-----#
    MultiplexFormat = CHOICE(name=u'MultiplexFormat', mode=MODE_TYPE)
    _MultiplexFormat_nonStandard = SEQ(name=u'nonStandard', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')))
    _MultiplexFormat_h222Capability = SEQ(name=u'h222Capability', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H222Capability')))
    _MultiplexFormat_h223Capability = SEQ(name=u'h223Capability', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H223Capability')))
    MultiplexFormat._cont = ASN1Dict([
        (u'nonStandard', _MultiplexFormat_nonStandard),
        (u'h222Capability', _MultiplexFormat_h222Capability),
        (u'h223Capability', _MultiplexFormat_h223Capability),
        ])
    MultiplexFormat._ext = []
    
    #-----< AudioTelephonyEventCapability >-----#
    AudioTelephonyEventCapability = SEQ(name=u'AudioTelephonyEventCapability', mode=MODE_TYPE)
    _AudioTelephonyEventCapability_dynamicRTPPayloadType = INT(name=u'dynamicRTPPayloadType', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AudioTelephonyEventCapability_dynamicRTPPayloadType._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=96, ub=127)], ev=None, er=[])
    _AudioTelephonyEventCapability_audioTelephoneEvent = STR_GENE(name=u'audioTelephoneEvent', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    AudioTelephonyEventCapability._cont = ASN1Dict([
        (u'dynamicRTPPayloadType', _AudioTelephonyEventCapability_dynamicRTPPayloadType),
        (u'audioTelephoneEvent', _AudioTelephonyEventCapability_audioTelephoneEvent),
        ])
    AudioTelephonyEventCapability._ext = []
    
    #-----< AudioToneCapability >-----#
    AudioToneCapability = SEQ(name=u'AudioToneCapability', mode=MODE_TYPE)
    _AudioToneCapability_dynamicRTPPayloadType = INT(name=u'dynamicRTPPayloadType', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AudioToneCapability_dynamicRTPPayloadType._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=96, ub=127)], ev=None, er=[])
    AudioToneCapability._cont = ASN1Dict([
        (u'dynamicRTPPayloadType', _AudioToneCapability_dynamicRTPPayloadType),
        ])
    AudioToneCapability._ext = []
    
    #-----< NoPTAudioTelephonyEventCapability >-----#
    NoPTAudioTelephonyEventCapability = SEQ(name=u'NoPTAudioTelephonyEventCapability', mode=MODE_TYPE)
    _NoPTAudioTelephonyEventCapability_audioTelephoneEvent = STR_GENE(name=u'audioTelephoneEvent', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    NoPTAudioTelephonyEventCapability._cont = ASN1Dict([
        (u'audioTelephoneEvent', _NoPTAudioTelephonyEventCapability_audioTelephoneEvent),
        ])
    NoPTAudioTelephonyEventCapability._ext = []
    
    #-----< NoPTAudioToneCapability >-----#
    NoPTAudioToneCapability = SEQ(name=u'NoPTAudioToneCapability', mode=MODE_TYPE)
    NoPTAudioToneCapability._cont = ASN1Dict([
        ])
    NoPTAudioToneCapability._ext = []
    
    #-----< MultiplePayloadStreamCapability >-----#
    MultiplePayloadStreamCapability = SEQ(name=u'MultiplePayloadStreamCapability', mode=MODE_TYPE)
    _MultiplePayloadStreamCapability_capabilities = SET_OF(name=u'capabilities', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MultiplePayloadStreamCapability_capabilities__item_ = SEQ_OF(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'AlternativeCapabilitySet')))
    _MultiplePayloadStreamCapability_capabilities._cont = __MultiplePayloadStreamCapability_capabilities__item_
    _MultiplePayloadStreamCapability_capabilities._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    MultiplePayloadStreamCapability._cont = ASN1Dict([
        (u'capabilities', _MultiplePayloadStreamCapability_capabilities),
        ])
    MultiplePayloadStreamCapability._ext = []
    
    #-----< DepFECCapability >-----#
    DepFECCapability = CHOICE(name=u'DepFECCapability', mode=MODE_TYPE)
    _DepFECCapability_rfc2733 = SEQ(name=u'rfc2733', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __DepFECCapability_rfc2733_redundancyEncoding = BOOL(name=u'redundancyEncoding', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __DepFECCapability_rfc2733_separateStream = SEQ(name=u'separateStream', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___DepFECCapability_rfc2733_separateStream_separatePort = BOOL(name=u'separatePort', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___DepFECCapability_rfc2733_separateStream_samePort = BOOL(name=u'samePort', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __DepFECCapability_rfc2733_separateStream._cont = ASN1Dict([
        (u'separatePort', ___DepFECCapability_rfc2733_separateStream_separatePort),
        (u'samePort', ___DepFECCapability_rfc2733_separateStream_samePort),
        ])
    __DepFECCapability_rfc2733_separateStream._ext = []
    _DepFECCapability_rfc2733._cont = ASN1Dict([
        (u'redundancyEncoding', __DepFECCapability_rfc2733_redundancyEncoding),
        (u'separateStream', __DepFECCapability_rfc2733_separateStream),
        ])
    _DepFECCapability_rfc2733._ext = []
    DepFECCapability._cont = ASN1Dict([
        (u'rfc2733', _DepFECCapability_rfc2733),
        ])
    DepFECCapability._ext = []
    
    #-----< FECCapability >-----#
    FECCapability = SEQ(name=u'FECCapability', mode=MODE_TYPE)
    _FECCapability_protectedCapability = INT(name=u'protectedCapability', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'CapabilityTableEntryNumber')))
    _FECCapability_fecScheme = OID(name=u'fecScheme', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _FECCapability_rfc2733Format = CHOICE(name=u'rfc2733Format', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __FECCapability_rfc2733Format_rfc2733rfc2198 = INT(name=u'rfc2733rfc2198', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MaxRedundancy')))
    __FECCapability_rfc2733Format_rfc2733sameport = INT(name=u'rfc2733sameport', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MaxRedundancy')))
    __FECCapability_rfc2733Format_rfc2733diffport = INT(name=u'rfc2733diffport', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MaxRedundancy')))
    _FECCapability_rfc2733Format._cont = ASN1Dict([
        (u'rfc2733rfc2198', __FECCapability_rfc2733Format_rfc2733rfc2198),
        (u'rfc2733sameport', __FECCapability_rfc2733Format_rfc2733sameport),
        (u'rfc2733diffport', __FECCapability_rfc2733Format_rfc2733diffport),
        ])
    _FECCapability_rfc2733Format._ext = None
    FECCapability._cont = ASN1Dict([
        (u'protectedCapability', _FECCapability_protectedCapability),
        (u'fecScheme', _FECCapability_fecScheme),
        (u'rfc2733Format', _FECCapability_rfc2733Format),
        ])
    FECCapability._ext = []
    
    #-----< MaxRedundancy >-----#
    MaxRedundancy = INT(name=u'MaxRedundancy', mode=MODE_TYPE)
    MaxRedundancy._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< OpenLogicalChannel >-----#
    OpenLogicalChannel = SEQ(name=u'OpenLogicalChannel', mode=MODE_TYPE)
    _OpenLogicalChannel_forwardLogicalChannelNumber = INT(name=u'forwardLogicalChannelNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelNumber')))
    _OpenLogicalChannel_forwardLogicalChannelParameters = SEQ(name=u'forwardLogicalChannelParameters', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OpenLogicalChannel_forwardLogicalChannelParameters_portNumber = INT(name=u'portNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OpenLogicalChannel_forwardLogicalChannelParameters_portNumber._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    __OpenLogicalChannel_forwardLogicalChannelParameters_dataType = CHOICE(name=u'dataType', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DataType')))
    __OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters = CHOICE(name=u'multiplexParameters', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ___OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_h222LogicalChannelParameters = SEQ(name=u'h222LogicalChannelParameters', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H222LogicalChannelParameters')))
    ___OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_h223LogicalChannelParameters = SEQ(name=u'h223LogicalChannelParameters', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H223LogicalChannelParameters')))
    ___OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_v76LogicalChannelParameters = SEQ(name=u'v76LogicalChannelParameters', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'V76LogicalChannelParameters')))
    ___OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_h2250LogicalChannelParameters = SEQ(name=u'h2250LogicalChannelParameters', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H2250LogicalChannelParameters')))
    ___OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_none = NULL(name=u'none', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters._cont = ASN1Dict([
        (u'h222LogicalChannelParameters', ___OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_h222LogicalChannelParameters),
        (u'h223LogicalChannelParameters', ___OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_h223LogicalChannelParameters),
        (u'v76LogicalChannelParameters', ___OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_v76LogicalChannelParameters),
        (u'h2250LogicalChannelParameters', ___OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_h2250LogicalChannelParameters),
        (u'none', ___OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_none),
        ])
    __OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters._ext = [u'h2250LogicalChannelParameters', u'none']
    __OpenLogicalChannel_forwardLogicalChannelParameters_forwardLogicalChannelDependency = INT(name=u'forwardLogicalChannelDependency', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelNumber')), opt=True)
    __OpenLogicalChannel_forwardLogicalChannelParameters_replacementFor = INT(name=u'replacementFor', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelNumber')), opt=True)
    _OpenLogicalChannel_forwardLogicalChannelParameters._cont = ASN1Dict([
        (u'portNumber', __OpenLogicalChannel_forwardLogicalChannelParameters_portNumber),
        (u'dataType', __OpenLogicalChannel_forwardLogicalChannelParameters_dataType),
        (u'multiplexParameters', __OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters),
        (u'forwardLogicalChannelDependency', __OpenLogicalChannel_forwardLogicalChannelParameters_forwardLogicalChannelDependency),
        (u'replacementFor', __OpenLogicalChannel_forwardLogicalChannelParameters_replacementFor),
        ])
    _OpenLogicalChannel_forwardLogicalChannelParameters._ext = [u'forwardLogicalChannelDependency', u'replacementFor']
    _OpenLogicalChannel_reverseLogicalChannelParameters = SEQ(name=u'reverseLogicalChannelParameters', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OpenLogicalChannel_reverseLogicalChannelParameters_dataType = CHOICE(name=u'dataType', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DataType')))
    __OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters = CHOICE(name=u'multiplexParameters', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    ___OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_h223LogicalChannelParameters = SEQ(name=u'h223LogicalChannelParameters', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H223LogicalChannelParameters')))
    ___OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_v76LogicalChannelParameters = SEQ(name=u'v76LogicalChannelParameters', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'V76LogicalChannelParameters')))
    ___OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_h2250LogicalChannelParameters = SEQ(name=u'h2250LogicalChannelParameters', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H2250LogicalChannelParameters')))
    __OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters._cont = ASN1Dict([
        (u'h223LogicalChannelParameters', ___OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_h223LogicalChannelParameters),
        (u'v76LogicalChannelParameters', ___OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_v76LogicalChannelParameters),
        (u'h2250LogicalChannelParameters', ___OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_h2250LogicalChannelParameters),
        ])
    __OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters._ext = [u'h2250LogicalChannelParameters']
    __OpenLogicalChannel_reverseLogicalChannelParameters_reverseLogicalChannelDependency = INT(name=u'reverseLogicalChannelDependency', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelNumber')), opt=True)
    __OpenLogicalChannel_reverseLogicalChannelParameters_replacementFor = INT(name=u'replacementFor', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelNumber')), opt=True)
    _OpenLogicalChannel_reverseLogicalChannelParameters._cont = ASN1Dict([
        (u'dataType', __OpenLogicalChannel_reverseLogicalChannelParameters_dataType),
        (u'multiplexParameters', __OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters),
        (u'reverseLogicalChannelDependency', __OpenLogicalChannel_reverseLogicalChannelParameters_reverseLogicalChannelDependency),
        (u'replacementFor', __OpenLogicalChannel_reverseLogicalChannelParameters_replacementFor),
        ])
    _OpenLogicalChannel_reverseLogicalChannelParameters._ext = [u'reverseLogicalChannelDependency', u'replacementFor']
    _OpenLogicalChannel_separateStack = SEQ(name=u'separateStack', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NetworkAccessParameters')), opt=True)
    _OpenLogicalChannel_encryptionSync = SEQ(name=u'encryptionSync', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'EncryptionSync')), opt=True)
    _OpenLogicalChannel_genericInformation = SEQ_OF(name=u'genericInformation', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OpenLogicalChannel_genericInformation__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'GenericInformation')))
    _OpenLogicalChannel_genericInformation._cont = __OpenLogicalChannel_genericInformation__item_
    OpenLogicalChannel._cont = ASN1Dict([
        (u'forwardLogicalChannelNumber', _OpenLogicalChannel_forwardLogicalChannelNumber),
        (u'forwardLogicalChannelParameters', _OpenLogicalChannel_forwardLogicalChannelParameters),
        (u'reverseLogicalChannelParameters', _OpenLogicalChannel_reverseLogicalChannelParameters),
        (u'separateStack', _OpenLogicalChannel_separateStack),
        (u'encryptionSync', _OpenLogicalChannel_encryptionSync),
        (u'genericInformation', _OpenLogicalChannel_genericInformation),
        ])
    OpenLogicalChannel._ext = [u'separateStack', u'encryptionSync', u'genericInformation']
    
    #-----< LogicalChannelNumber >-----#
    LogicalChannelNumber = INT(name=u'LogicalChannelNumber', mode=MODE_TYPE)
    LogicalChannelNumber._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    
    #-----< NetworkAccessParameters >-----#
    NetworkAccessParameters = SEQ(name=u'NetworkAccessParameters', mode=MODE_TYPE)
    _NetworkAccessParameters_distribution = CHOICE(name=u'distribution', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __NetworkAccessParameters_distribution_unicast = NULL(name=u'unicast', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __NetworkAccessParameters_distribution_multicast = NULL(name=u'multicast', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NetworkAccessParameters_distribution._cont = ASN1Dict([
        (u'unicast', __NetworkAccessParameters_distribution_unicast),
        (u'multicast', __NetworkAccessParameters_distribution_multicast),
        ])
    _NetworkAccessParameters_distribution._ext = []
    _NetworkAccessParameters_networkAddress = CHOICE(name=u'networkAddress', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __NetworkAccessParameters_networkAddress_q2931Address = SEQ(name=u'q2931Address', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'Q2931Address')))
    __NetworkAccessParameters_networkAddress_e164Address = STR_IA5(name=u'e164Address', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __NetworkAccessParameters_networkAddress_e164Address._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    __NetworkAccessParameters_networkAddress_e164Address._const_alpha = ASN1Set(rv=[u'0', u'1', u'2', u'3', u'4', u'5', u'6', u'7', u'8', u'9', u'#', u'*', u','], rr=[], ev=None, er=[])
    __NetworkAccessParameters_networkAddress_localAreaAddress = CHOICE(name=u'localAreaAddress', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TransportAddress')))
    _NetworkAccessParameters_networkAddress._cont = ASN1Dict([
        (u'q2931Address', __NetworkAccessParameters_networkAddress_q2931Address),
        (u'e164Address', __NetworkAccessParameters_networkAddress_e164Address),
        (u'localAreaAddress', __NetworkAccessParameters_networkAddress_localAreaAddress),
        ])
    _NetworkAccessParameters_networkAddress._ext = []
    _NetworkAccessParameters_associateConference = BOOL(name=u'associateConference', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NetworkAccessParameters_externalReference = OCT_STR(name=u'externalReference', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _NetworkAccessParameters_externalReference._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=255)], ev=None, er=[])
    _NetworkAccessParameters_t120SetupProcedure = CHOICE(name=u't120SetupProcedure', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __NetworkAccessParameters_t120SetupProcedure_originateCall = NULL(name=u'originateCall', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __NetworkAccessParameters_t120SetupProcedure_waitForCall = NULL(name=u'waitForCall', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __NetworkAccessParameters_t120SetupProcedure_issueQuery = NULL(name=u'issueQuery', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NetworkAccessParameters_t120SetupProcedure._cont = ASN1Dict([
        (u'originateCall', __NetworkAccessParameters_t120SetupProcedure_originateCall),
        (u'waitForCall', __NetworkAccessParameters_t120SetupProcedure_waitForCall),
        (u'issueQuery', __NetworkAccessParameters_t120SetupProcedure_issueQuery),
        ])
    _NetworkAccessParameters_t120SetupProcedure._ext = []
    NetworkAccessParameters._cont = ASN1Dict([
        (u'distribution', _NetworkAccessParameters_distribution),
        (u'networkAddress', _NetworkAccessParameters_networkAddress),
        (u'associateConference', _NetworkAccessParameters_associateConference),
        (u'externalReference', _NetworkAccessParameters_externalReference),
        (u't120SetupProcedure', _NetworkAccessParameters_t120SetupProcedure),
        ])
    NetworkAccessParameters._ext = [u't120SetupProcedure']
    
    #-----< Q2931Address >-----#
    Q2931Address = SEQ(name=u'Q2931Address', mode=MODE_TYPE)
    _Q2931Address_address = CHOICE(name=u'address', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __Q2931Address_address_internationalNumber = STR_NUM(name=u'internationalNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __Q2931Address_address_internationalNumber._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    __Q2931Address_address_nsapAddress = OCT_STR(name=u'nsapAddress', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __Q2931Address_address_nsapAddress._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=20)], ev=None, er=[])
    _Q2931Address_address._cont = ASN1Dict([
        (u'internationalNumber', __Q2931Address_address_internationalNumber),
        (u'nsapAddress', __Q2931Address_address_nsapAddress),
        ])
    _Q2931Address_address._ext = []
    _Q2931Address_subaddress = OCT_STR(name=u'subaddress', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _Q2931Address_subaddress._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=20)], ev=None, er=[])
    Q2931Address._cont = ASN1Dict([
        (u'address', _Q2931Address_address),
        (u'subaddress', _Q2931Address_subaddress),
        ])
    Q2931Address._ext = []
    
    #-----< V75Parameters >-----#
    V75Parameters = SEQ(name=u'V75Parameters', mode=MODE_TYPE)
    _V75Parameters_audioHeaderPresent = BOOL(name=u'audioHeaderPresent', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    V75Parameters._cont = ASN1Dict([
        (u'audioHeaderPresent', _V75Parameters_audioHeaderPresent),
        ])
    V75Parameters._ext = []
    
    #-----< DataType >-----#
    DataType = CHOICE(name=u'DataType', mode=MODE_TYPE)
    _DataType_nonStandard = SEQ(name=u'nonStandard', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')))
    _DataType_nullData = NULL(name=u'nullData', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _DataType_videoData = CHOICE(name=u'videoData', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'VideoCapability')))
    _DataType_audioData = CHOICE(name=u'audioData', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'AudioCapability')))
    _DataType_data = SEQ(name=u'data', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DataApplicationCapability')))
    _DataType_encryptionData = CHOICE(name=u'encryptionData', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'EncryptionMode')))
    _DataType_h235Control = SEQ(name=u'h235Control', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')))
    _DataType_h235Media = SEQ(name=u'h235Media', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H235Media')))
    _DataType_multiplexedStream = SEQ(name=u'multiplexedStream', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MultiplexedStreamParameter')))
    _DataType_redundancyEncoding = SEQ(name=u'redundancyEncoding', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'RedundancyEncoding')))
    _DataType_multiplePayloadStream = SEQ(name=u'multiplePayloadStream', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MultiplePayloadStream')))
    _DataType_depFec = CHOICE(name=u'depFec', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DepFECData')))
    _DataType_fec = CHOICE(name=u'fec', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'FECData')))
    DataType._cont = ASN1Dict([
        (u'nonStandard', _DataType_nonStandard),
        (u'nullData', _DataType_nullData),
        (u'videoData', _DataType_videoData),
        (u'audioData', _DataType_audioData),
        (u'data', _DataType_data),
        (u'encryptionData', _DataType_encryptionData),
        (u'h235Control', _DataType_h235Control),
        (u'h235Media', _DataType_h235Media),
        (u'multiplexedStream', _DataType_multiplexedStream),
        (u'redundancyEncoding', _DataType_redundancyEncoding),
        (u'multiplePayloadStream', _DataType_multiplePayloadStream),
        (u'depFec', _DataType_depFec),
        (u'fec', _DataType_fec),
        ])
    DataType._ext = [u'h235Control', u'h235Media', u'multiplexedStream', u'redundancyEncoding', u'multiplePayloadStream', u'depFec', u'fec']
    
    #-----< H235Media >-----#
    H235Media = SEQ(name=u'H235Media', mode=MODE_TYPE)
    _H235Media_encryptionAuthenticationAndIntegrity = SEQ(name=u'encryptionAuthenticationAndIntegrity', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'EncryptionAuthenticationAndIntegrity')))
    _H235Media_mediaType = CHOICE(name=u'mediaType', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __H235Media_mediaType_nonStandard = SEQ(name=u'nonStandard', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')))
    __H235Media_mediaType_videoData = CHOICE(name=u'videoData', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'VideoCapability')))
    __H235Media_mediaType_audioData = CHOICE(name=u'audioData', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'AudioCapability')))
    __H235Media_mediaType_data = SEQ(name=u'data', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DataApplicationCapability')))
    __H235Media_mediaType_redundancyEncoding = SEQ(name=u'redundancyEncoding', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'RedundancyEncoding')))
    __H235Media_mediaType_multiplePayloadStream = SEQ(name=u'multiplePayloadStream', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MultiplePayloadStream')))
    __H235Media_mediaType_depFec = CHOICE(name=u'depFec', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DepFECData')))
    __H235Media_mediaType_fec = CHOICE(name=u'fec', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'FECData')))
    _H235Media_mediaType._cont = ASN1Dict([
        (u'nonStandard', __H235Media_mediaType_nonStandard),
        (u'videoData', __H235Media_mediaType_videoData),
        (u'audioData', __H235Media_mediaType_audioData),
        (u'data', __H235Media_mediaType_data),
        (u'redundancyEncoding', __H235Media_mediaType_redundancyEncoding),
        (u'multiplePayloadStream', __H235Media_mediaType_multiplePayloadStream),
        (u'depFec', __H235Media_mediaType_depFec),
        (u'fec', __H235Media_mediaType_fec),
        ])
    _H235Media_mediaType._ext = [u'redundancyEncoding', u'multiplePayloadStream', u'depFec', u'fec']
    H235Media._cont = ASN1Dict([
        (u'encryptionAuthenticationAndIntegrity', _H235Media_encryptionAuthenticationAndIntegrity),
        (u'mediaType', _H235Media_mediaType),
        ])
    H235Media._ext = []
    
    #-----< MultiplexedStreamParameter >-----#
    MultiplexedStreamParameter = SEQ(name=u'MultiplexedStreamParameter', mode=MODE_TYPE)
    _MultiplexedStreamParameter_multiplexFormat = CHOICE(name=u'multiplexFormat', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MultiplexFormat')))
    _MultiplexedStreamParameter_controlOnMuxStream = BOOL(name=u'controlOnMuxStream', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    MultiplexedStreamParameter._cont = ASN1Dict([
        (u'multiplexFormat', _MultiplexedStreamParameter_multiplexFormat),
        (u'controlOnMuxStream', _MultiplexedStreamParameter_controlOnMuxStream),
        ])
    MultiplexedStreamParameter._ext = []
    
    #-----< H222LogicalChannelParameters >-----#
    H222LogicalChannelParameters = SEQ(name=u'H222LogicalChannelParameters', mode=MODE_TYPE)
    _H222LogicalChannelParameters_resourceID = INT(name=u'resourceID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H222LogicalChannelParameters_resourceID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    _H222LogicalChannelParameters_subChannelID = INT(name=u'subChannelID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H222LogicalChannelParameters_subChannelID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=8191)], ev=None, er=[])
    _H222LogicalChannelParameters_pcr_pid = INT(name=u'pcr-pid', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _H222LogicalChannelParameters_pcr_pid._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=8191)], ev=None, er=[])
    _H222LogicalChannelParameters_programDescriptors = OCT_STR(name=u'programDescriptors', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _H222LogicalChannelParameters_streamDescriptors = OCT_STR(name=u'streamDescriptors', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    H222LogicalChannelParameters._cont = ASN1Dict([
        (u'resourceID', _H222LogicalChannelParameters_resourceID),
        (u'subChannelID', _H222LogicalChannelParameters_subChannelID),
        (u'pcr-pid', _H222LogicalChannelParameters_pcr_pid),
        (u'programDescriptors', _H222LogicalChannelParameters_programDescriptors),
        (u'streamDescriptors', _H222LogicalChannelParameters_streamDescriptors),
        ])
    H222LogicalChannelParameters._ext = []
    
    #-----< H223LogicalChannelParameters >-----#
    H223LogicalChannelParameters = SEQ(name=u'H223LogicalChannelParameters', mode=MODE_TYPE)
    _H223LogicalChannelParameters_adaptationLayerType = CHOICE(name=u'adaptationLayerType', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __H223LogicalChannelParameters_adaptationLayerType_nonStandard = SEQ(name=u'nonStandard', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')))
    __H223LogicalChannelParameters_adaptationLayerType_al1Framed = NULL(name=u'al1Framed', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H223LogicalChannelParameters_adaptationLayerType_al1NotFramed = NULL(name=u'al1NotFramed', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H223LogicalChannelParameters_adaptationLayerType_al2WithoutSequenceNumbers = NULL(name=u'al2WithoutSequenceNumbers', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H223LogicalChannelParameters_adaptationLayerType_al2WithSequenceNumbers = NULL(name=u'al2WithSequenceNumbers', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H223LogicalChannelParameters_adaptationLayerType_al3 = SEQ(name=u'al3', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___H223LogicalChannelParameters_adaptationLayerType_al3_controlFieldOctets = INT(name=u'controlFieldOctets', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___H223LogicalChannelParameters_adaptationLayerType_al3_controlFieldOctets._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=2)], ev=None, er=[])
    ___H223LogicalChannelParameters_adaptationLayerType_al3_sendBufferSize = INT(name=u'sendBufferSize', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___H223LogicalChannelParameters_adaptationLayerType_al3_sendBufferSize._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=16777215)], ev=None, er=[])
    __H223LogicalChannelParameters_adaptationLayerType_al3._cont = ASN1Dict([
        (u'controlFieldOctets', ___H223LogicalChannelParameters_adaptationLayerType_al3_controlFieldOctets),
        (u'sendBufferSize', ___H223LogicalChannelParameters_adaptationLayerType_al3_sendBufferSize),
        ])
    __H223LogicalChannelParameters_adaptationLayerType_al3._ext = None
    __H223LogicalChannelParameters_adaptationLayerType_al1M = SEQ(name=u'al1M', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H223AL1MParameters')))
    __H223LogicalChannelParameters_adaptationLayerType_al2M = SEQ(name=u'al2M', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H223AL2MParameters')))
    __H223LogicalChannelParameters_adaptationLayerType_al3M = SEQ(name=u'al3M', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H223AL3MParameters')))
    _H223LogicalChannelParameters_adaptationLayerType._cont = ASN1Dict([
        (u'nonStandard', __H223LogicalChannelParameters_adaptationLayerType_nonStandard),
        (u'al1Framed', __H223LogicalChannelParameters_adaptationLayerType_al1Framed),
        (u'al1NotFramed', __H223LogicalChannelParameters_adaptationLayerType_al1NotFramed),
        (u'al2WithoutSequenceNumbers', __H223LogicalChannelParameters_adaptationLayerType_al2WithoutSequenceNumbers),
        (u'al2WithSequenceNumbers', __H223LogicalChannelParameters_adaptationLayerType_al2WithSequenceNumbers),
        (u'al3', __H223LogicalChannelParameters_adaptationLayerType_al3),
        (u'al1M', __H223LogicalChannelParameters_adaptationLayerType_al1M),
        (u'al2M', __H223LogicalChannelParameters_adaptationLayerType_al2M),
        (u'al3M', __H223LogicalChannelParameters_adaptationLayerType_al3M),
        ])
    _H223LogicalChannelParameters_adaptationLayerType._ext = [u'al1M', u'al2M', u'al3M']
    _H223LogicalChannelParameters_segmentableFlag = BOOL(name=u'segmentableFlag', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    H223LogicalChannelParameters._cont = ASN1Dict([
        (u'adaptationLayerType', _H223LogicalChannelParameters_adaptationLayerType),
        (u'segmentableFlag', _H223LogicalChannelParameters_segmentableFlag),
        ])
    H223LogicalChannelParameters._ext = []
    
    #-----< H223AL1MParameters >-----#
    H223AL1MParameters = SEQ(name=u'H223AL1MParameters', mode=MODE_TYPE)
    _H223AL1MParameters_transferMode = CHOICE(name=u'transferMode', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __H223AL1MParameters_transferMode_framed = NULL(name=u'framed', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H223AL1MParameters_transferMode_unframed = NULL(name=u'unframed', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H223AL1MParameters_transferMode._cont = ASN1Dict([
        (u'framed', __H223AL1MParameters_transferMode_framed),
        (u'unframed', __H223AL1MParameters_transferMode_unframed),
        ])
    _H223AL1MParameters_transferMode._ext = []
    _H223AL1MParameters_headerFEC = CHOICE(name=u'headerFEC', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __H223AL1MParameters_headerFEC_sebch16_7 = NULL(name=u'sebch16-7', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H223AL1MParameters_headerFEC_golay24_12 = NULL(name=u'golay24-12', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H223AL1MParameters_headerFEC._cont = ASN1Dict([
        (u'sebch16-7', __H223AL1MParameters_headerFEC_sebch16_7),
        (u'golay24-12', __H223AL1MParameters_headerFEC_golay24_12),
        ])
    _H223AL1MParameters_headerFEC._ext = []
    _H223AL1MParameters_crcLength = CHOICE(name=u'crcLength', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __H223AL1MParameters_crcLength_crc4bit = NULL(name=u'crc4bit', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H223AL1MParameters_crcLength_crc12bit = NULL(name=u'crc12bit', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H223AL1MParameters_crcLength_crc20bit = NULL(name=u'crc20bit', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H223AL1MParameters_crcLength_crc28bit = NULL(name=u'crc28bit', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H223AL1MParameters_crcLength_crc8bit = NULL(name=u'crc8bit', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H223AL1MParameters_crcLength_crc16bit = NULL(name=u'crc16bit', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H223AL1MParameters_crcLength_crc32bit = NULL(name=u'crc32bit', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H223AL1MParameters_crcLength_crcNotUsed = NULL(name=u'crcNotUsed', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H223AL1MParameters_crcLength._cont = ASN1Dict([
        (u'crc4bit', __H223AL1MParameters_crcLength_crc4bit),
        (u'crc12bit', __H223AL1MParameters_crcLength_crc12bit),
        (u'crc20bit', __H223AL1MParameters_crcLength_crc20bit),
        (u'crc28bit', __H223AL1MParameters_crcLength_crc28bit),
        (u'crc8bit', __H223AL1MParameters_crcLength_crc8bit),
        (u'crc16bit', __H223AL1MParameters_crcLength_crc16bit),
        (u'crc32bit', __H223AL1MParameters_crcLength_crc32bit),
        (u'crcNotUsed', __H223AL1MParameters_crcLength_crcNotUsed),
        ])
    _H223AL1MParameters_crcLength._ext = [u'crc8bit', u'crc16bit', u'crc32bit', u'crcNotUsed']
    _H223AL1MParameters_rcpcCodeRate = INT(name=u'rcpcCodeRate', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H223AL1MParameters_rcpcCodeRate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=8, ub=32)], ev=None, er=[])
    _H223AL1MParameters_arqType = CHOICE(name=u'arqType', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __H223AL1MParameters_arqType_noArq = NULL(name=u'noArq', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H223AL1MParameters_arqType_typeIArq = SEQ(name=u'typeIArq', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H223AnnexCArqParameters')))
    __H223AL1MParameters_arqType_typeIIArq = SEQ(name=u'typeIIArq', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H223AnnexCArqParameters')))
    _H223AL1MParameters_arqType._cont = ASN1Dict([
        (u'noArq', __H223AL1MParameters_arqType_noArq),
        (u'typeIArq', __H223AL1MParameters_arqType_typeIArq),
        (u'typeIIArq', __H223AL1MParameters_arqType_typeIIArq),
        ])
    _H223AL1MParameters_arqType._ext = []
    _H223AL1MParameters_alpduInterleaving = BOOL(name=u'alpduInterleaving', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H223AL1MParameters_alsduSplitting = BOOL(name=u'alsduSplitting', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H223AL1MParameters_rsCodeCorrection = INT(name=u'rsCodeCorrection', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _H223AL1MParameters_rsCodeCorrection._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    H223AL1MParameters._cont = ASN1Dict([
        (u'transferMode', _H223AL1MParameters_transferMode),
        (u'headerFEC', _H223AL1MParameters_headerFEC),
        (u'crcLength', _H223AL1MParameters_crcLength),
        (u'rcpcCodeRate', _H223AL1MParameters_rcpcCodeRate),
        (u'arqType', _H223AL1MParameters_arqType),
        (u'alpduInterleaving', _H223AL1MParameters_alpduInterleaving),
        (u'alsduSplitting', _H223AL1MParameters_alsduSplitting),
        (u'rsCodeCorrection', _H223AL1MParameters_rsCodeCorrection),
        ])
    H223AL1MParameters._ext = [u'rsCodeCorrection']
    
    #-----< H223AL2MParameters >-----#
    H223AL2MParameters = SEQ(name=u'H223AL2MParameters', mode=MODE_TYPE)
    _H223AL2MParameters_headerFEC = CHOICE(name=u'headerFEC', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __H223AL2MParameters_headerFEC_sebch16_5 = NULL(name=u'sebch16-5', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H223AL2MParameters_headerFEC_golay24_12 = NULL(name=u'golay24-12', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H223AL2MParameters_headerFEC._cont = ASN1Dict([
        (u'sebch16-5', __H223AL2MParameters_headerFEC_sebch16_5),
        (u'golay24-12', __H223AL2MParameters_headerFEC_golay24_12),
        ])
    _H223AL2MParameters_headerFEC._ext = []
    _H223AL2MParameters_alpduInterleaving = BOOL(name=u'alpduInterleaving', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    H223AL2MParameters._cont = ASN1Dict([
        (u'headerFEC', _H223AL2MParameters_headerFEC),
        (u'alpduInterleaving', _H223AL2MParameters_alpduInterleaving),
        ])
    H223AL2MParameters._ext = []
    
    #-----< H223AL3MParameters >-----#
    H223AL3MParameters = SEQ(name=u'H223AL3MParameters', mode=MODE_TYPE)
    _H223AL3MParameters_headerFormat = CHOICE(name=u'headerFormat', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __H223AL3MParameters_headerFormat_sebch16_7 = NULL(name=u'sebch16-7', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H223AL3MParameters_headerFormat_golay24_12 = NULL(name=u'golay24-12', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H223AL3MParameters_headerFormat._cont = ASN1Dict([
        (u'sebch16-7', __H223AL3MParameters_headerFormat_sebch16_7),
        (u'golay24-12', __H223AL3MParameters_headerFormat_golay24_12),
        ])
    _H223AL3MParameters_headerFormat._ext = []
    _H223AL3MParameters_crcLength = CHOICE(name=u'crcLength', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __H223AL3MParameters_crcLength_crc4bit = NULL(name=u'crc4bit', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H223AL3MParameters_crcLength_crc12bit = NULL(name=u'crc12bit', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H223AL3MParameters_crcLength_crc20bit = NULL(name=u'crc20bit', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H223AL3MParameters_crcLength_crc28bit = NULL(name=u'crc28bit', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H223AL3MParameters_crcLength_crc8bit = NULL(name=u'crc8bit', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H223AL3MParameters_crcLength_crc16bit = NULL(name=u'crc16bit', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H223AL3MParameters_crcLength_crc32bit = NULL(name=u'crc32bit', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H223AL3MParameters_crcLength_crcNotUsed = NULL(name=u'crcNotUsed', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H223AL3MParameters_crcLength._cont = ASN1Dict([
        (u'crc4bit', __H223AL3MParameters_crcLength_crc4bit),
        (u'crc12bit', __H223AL3MParameters_crcLength_crc12bit),
        (u'crc20bit', __H223AL3MParameters_crcLength_crc20bit),
        (u'crc28bit', __H223AL3MParameters_crcLength_crc28bit),
        (u'crc8bit', __H223AL3MParameters_crcLength_crc8bit),
        (u'crc16bit', __H223AL3MParameters_crcLength_crc16bit),
        (u'crc32bit', __H223AL3MParameters_crcLength_crc32bit),
        (u'crcNotUsed', __H223AL3MParameters_crcLength_crcNotUsed),
        ])
    _H223AL3MParameters_crcLength._ext = [u'crc8bit', u'crc16bit', u'crc32bit', u'crcNotUsed']
    _H223AL3MParameters_rcpcCodeRate = INT(name=u'rcpcCodeRate', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H223AL3MParameters_rcpcCodeRate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=8, ub=32)], ev=None, er=[])
    _H223AL3MParameters_arqType = CHOICE(name=u'arqType', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __H223AL3MParameters_arqType_noArq = NULL(name=u'noArq', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H223AL3MParameters_arqType_typeIArq = SEQ(name=u'typeIArq', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H223AnnexCArqParameters')))
    __H223AL3MParameters_arqType_typeIIArq = SEQ(name=u'typeIIArq', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H223AnnexCArqParameters')))
    _H223AL3MParameters_arqType._cont = ASN1Dict([
        (u'noArq', __H223AL3MParameters_arqType_noArq),
        (u'typeIArq', __H223AL3MParameters_arqType_typeIArq),
        (u'typeIIArq', __H223AL3MParameters_arqType_typeIIArq),
        ])
    _H223AL3MParameters_arqType._ext = []
    _H223AL3MParameters_alpduInterleaving = BOOL(name=u'alpduInterleaving', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H223AL3MParameters_rsCodeCorrection = INT(name=u'rsCodeCorrection', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _H223AL3MParameters_rsCodeCorrection._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    H223AL3MParameters._cont = ASN1Dict([
        (u'headerFormat', _H223AL3MParameters_headerFormat),
        (u'crcLength', _H223AL3MParameters_crcLength),
        (u'rcpcCodeRate', _H223AL3MParameters_rcpcCodeRate),
        (u'arqType', _H223AL3MParameters_arqType),
        (u'alpduInterleaving', _H223AL3MParameters_alpduInterleaving),
        (u'rsCodeCorrection', _H223AL3MParameters_rsCodeCorrection),
        ])
    H223AL3MParameters._ext = [u'rsCodeCorrection']
    
    #-----< H223AnnexCArqParameters >-----#
    H223AnnexCArqParameters = SEQ(name=u'H223AnnexCArqParameters', mode=MODE_TYPE)
    _H223AnnexCArqParameters_numberOfRetransmissions = CHOICE(name=u'numberOfRetransmissions', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __H223AnnexCArqParameters_numberOfRetransmissions_finite = INT(name=u'finite', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H223AnnexCArqParameters_numberOfRetransmissions_finite._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=16)], ev=None, er=[])
    __H223AnnexCArqParameters_numberOfRetransmissions_infinite = NULL(name=u'infinite', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H223AnnexCArqParameters_numberOfRetransmissions._cont = ASN1Dict([
        (u'finite', __H223AnnexCArqParameters_numberOfRetransmissions_finite),
        (u'infinite', __H223AnnexCArqParameters_numberOfRetransmissions_infinite),
        ])
    _H223AnnexCArqParameters_numberOfRetransmissions._ext = []
    _H223AnnexCArqParameters_sendBufferSize = INT(name=u'sendBufferSize', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H223AnnexCArqParameters_sendBufferSize._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=16777215)], ev=None, er=[])
    H223AnnexCArqParameters._cont = ASN1Dict([
        (u'numberOfRetransmissions', _H223AnnexCArqParameters_numberOfRetransmissions),
        (u'sendBufferSize', _H223AnnexCArqParameters_sendBufferSize),
        ])
    H223AnnexCArqParameters._ext = []
    
    #-----< V76LogicalChannelParameters >-----#
    V76LogicalChannelParameters = SEQ(name=u'V76LogicalChannelParameters', mode=MODE_TYPE)
    _V76LogicalChannelParameters_hdlcParameters = SEQ(name=u'hdlcParameters', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'V76HDLCParameters')))
    _V76LogicalChannelParameters_suspendResume = CHOICE(name=u'suspendResume', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __V76LogicalChannelParameters_suspendResume_noSuspendResume = NULL(name=u'noSuspendResume', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __V76LogicalChannelParameters_suspendResume_suspendResumewAddress = NULL(name=u'suspendResumewAddress', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __V76LogicalChannelParameters_suspendResume_suspendResumewoAddress = NULL(name=u'suspendResumewoAddress', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _V76LogicalChannelParameters_suspendResume._cont = ASN1Dict([
        (u'noSuspendResume', __V76LogicalChannelParameters_suspendResume_noSuspendResume),
        (u'suspendResumewAddress', __V76LogicalChannelParameters_suspendResume_suspendResumewAddress),
        (u'suspendResumewoAddress', __V76LogicalChannelParameters_suspendResume_suspendResumewoAddress),
        ])
    _V76LogicalChannelParameters_suspendResume._ext = []
    _V76LogicalChannelParameters_uIH = BOOL(name=u'uIH', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _V76LogicalChannelParameters_mode = CHOICE(name=u'mode', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __V76LogicalChannelParameters_mode_eRM = SEQ(name=u'eRM', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___V76LogicalChannelParameters_mode_eRM_windowSize = INT(name=u'windowSize', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___V76LogicalChannelParameters_mode_eRM_windowSize._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=127)], ev=None, er=[])
    ___V76LogicalChannelParameters_mode_eRM_recovery = CHOICE(name=u'recovery', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ____V76LogicalChannelParameters_mode_eRM_recovery_rej = NULL(name=u'rej', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ____V76LogicalChannelParameters_mode_eRM_recovery_sREJ = NULL(name=u'sREJ', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ____V76LogicalChannelParameters_mode_eRM_recovery_mSREJ = NULL(name=u'mSREJ', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___V76LogicalChannelParameters_mode_eRM_recovery._cont = ASN1Dict([
        (u'rej', ____V76LogicalChannelParameters_mode_eRM_recovery_rej),
        (u'sREJ', ____V76LogicalChannelParameters_mode_eRM_recovery_sREJ),
        (u'mSREJ', ____V76LogicalChannelParameters_mode_eRM_recovery_mSREJ),
        ])
    ___V76LogicalChannelParameters_mode_eRM_recovery._ext = []
    __V76LogicalChannelParameters_mode_eRM._cont = ASN1Dict([
        (u'windowSize', ___V76LogicalChannelParameters_mode_eRM_windowSize),
        (u'recovery', ___V76LogicalChannelParameters_mode_eRM_recovery),
        ])
    __V76LogicalChannelParameters_mode_eRM._ext = []
    __V76LogicalChannelParameters_mode_uNERM = NULL(name=u'uNERM', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _V76LogicalChannelParameters_mode._cont = ASN1Dict([
        (u'eRM', __V76LogicalChannelParameters_mode_eRM),
        (u'uNERM', __V76LogicalChannelParameters_mode_uNERM),
        ])
    _V76LogicalChannelParameters_mode._ext = []
    _V76LogicalChannelParameters_v75Parameters = SEQ(name=u'v75Parameters', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'V75Parameters')))
    V76LogicalChannelParameters._cont = ASN1Dict([
        (u'hdlcParameters', _V76LogicalChannelParameters_hdlcParameters),
        (u'suspendResume', _V76LogicalChannelParameters_suspendResume),
        (u'uIH', _V76LogicalChannelParameters_uIH),
        (u'mode', _V76LogicalChannelParameters_mode),
        (u'v75Parameters', _V76LogicalChannelParameters_v75Parameters),
        ])
    V76LogicalChannelParameters._ext = []
    
    #-----< V76HDLCParameters >-----#
    V76HDLCParameters = SEQ(name=u'V76HDLCParameters', mode=MODE_TYPE)
    _V76HDLCParameters_crcLength = CHOICE(name=u'crcLength', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'CRCLength')))
    _V76HDLCParameters_n401 = INT(name=u'n401', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _V76HDLCParameters_n401._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4095)], ev=None, er=[])
    _V76HDLCParameters_loopbackTestProcedure = BOOL(name=u'loopbackTestProcedure', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    V76HDLCParameters._cont = ASN1Dict([
        (u'crcLength', _V76HDLCParameters_crcLength),
        (u'n401', _V76HDLCParameters_n401),
        (u'loopbackTestProcedure', _V76HDLCParameters_loopbackTestProcedure),
        ])
    V76HDLCParameters._ext = []
    
    #-----< CRCLength >-----#
    CRCLength = CHOICE(name=u'CRCLength', mode=MODE_TYPE)
    _CRCLength_crc8bit = NULL(name=u'crc8bit', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _CRCLength_crc16bit = NULL(name=u'crc16bit', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _CRCLength_crc32bit = NULL(name=u'crc32bit', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    CRCLength._cont = ASN1Dict([
        (u'crc8bit', _CRCLength_crc8bit),
        (u'crc16bit', _CRCLength_crc16bit),
        (u'crc32bit', _CRCLength_crc32bit),
        ])
    CRCLength._ext = []
    
    #-----< H2250LogicalChannelParameters >-----#
    H2250LogicalChannelParameters = SEQ(name=u'H2250LogicalChannelParameters', mode=MODE_TYPE)
    _H2250LogicalChannelParameters_nonStandard = SEQ_OF(name=u'nonStandard', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __H2250LogicalChannelParameters_nonStandard__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')))
    _H2250LogicalChannelParameters_nonStandard._cont = __H2250LogicalChannelParameters_nonStandard__item_
    _H2250LogicalChannelParameters_sessionID = INT(name=u'sessionID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H2250LogicalChannelParameters_sessionID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _H2250LogicalChannelParameters_associatedSessionID = INT(name=u'associatedSessionID', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _H2250LogicalChannelParameters_associatedSessionID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=255)], ev=None, er=[])
    _H2250LogicalChannelParameters_mediaChannel = CHOICE(name=u'mediaChannel', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TransportAddress')), opt=True)
    _H2250LogicalChannelParameters_mediaGuaranteedDelivery = BOOL(name=u'mediaGuaranteedDelivery', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _H2250LogicalChannelParameters_mediaControlChannel = CHOICE(name=u'mediaControlChannel', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TransportAddress')), opt=True)
    _H2250LogicalChannelParameters_mediaControlGuaranteedDelivery = BOOL(name=u'mediaControlGuaranteedDelivery', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _H2250LogicalChannelParameters_silenceSuppression = BOOL(name=u'silenceSuppression', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _H2250LogicalChannelParameters_destination = SEQ(name=u'destination', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TerminalLabel')), opt=True)
    _H2250LogicalChannelParameters_dynamicRTPPayloadType = INT(name=u'dynamicRTPPayloadType', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _H2250LogicalChannelParameters_dynamicRTPPayloadType._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=96, ub=127)], ev=None, er=[])
    _H2250LogicalChannelParameters_mediaPacketization = CHOICE(name=u'mediaPacketization', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __H2250LogicalChannelParameters_mediaPacketization_h261aVideoPacketization = NULL(name=u'h261aVideoPacketization', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H2250LogicalChannelParameters_mediaPacketization_rtpPayloadType = SEQ(name=u'rtpPayloadType', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'RTPPayloadType')))
    _H2250LogicalChannelParameters_mediaPacketization._cont = ASN1Dict([
        (u'h261aVideoPacketization', __H2250LogicalChannelParameters_mediaPacketization_h261aVideoPacketization),
        (u'rtpPayloadType', __H2250LogicalChannelParameters_mediaPacketization_rtpPayloadType),
        ])
    _H2250LogicalChannelParameters_mediaPacketization._ext = [u'rtpPayloadType']
    _H2250LogicalChannelParameters_transportCapability = SEQ(name=u'transportCapability', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TransportCapability')), opt=True)
    _H2250LogicalChannelParameters_redundancyEncoding = SEQ(name=u'redundancyEncoding', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'RedundancyEncoding')), opt=True)
    _H2250LogicalChannelParameters_source = SEQ(name=u'source', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TerminalLabel')), opt=True)
    H2250LogicalChannelParameters._cont = ASN1Dict([
        (u'nonStandard', _H2250LogicalChannelParameters_nonStandard),
        (u'sessionID', _H2250LogicalChannelParameters_sessionID),
        (u'associatedSessionID', _H2250LogicalChannelParameters_associatedSessionID),
        (u'mediaChannel', _H2250LogicalChannelParameters_mediaChannel),
        (u'mediaGuaranteedDelivery', _H2250LogicalChannelParameters_mediaGuaranteedDelivery),
        (u'mediaControlChannel', _H2250LogicalChannelParameters_mediaControlChannel),
        (u'mediaControlGuaranteedDelivery', _H2250LogicalChannelParameters_mediaControlGuaranteedDelivery),
        (u'silenceSuppression', _H2250LogicalChannelParameters_silenceSuppression),
        (u'destination', _H2250LogicalChannelParameters_destination),
        (u'dynamicRTPPayloadType', _H2250LogicalChannelParameters_dynamicRTPPayloadType),
        (u'mediaPacketization', _H2250LogicalChannelParameters_mediaPacketization),
        (u'transportCapability', _H2250LogicalChannelParameters_transportCapability),
        (u'redundancyEncoding', _H2250LogicalChannelParameters_redundancyEncoding),
        (u'source', _H2250LogicalChannelParameters_source),
        ])
    H2250LogicalChannelParameters._ext = [u'transportCapability', u'redundancyEncoding', u'source']
    
    #-----< RTPPayloadType >-----#
    RTPPayloadType = SEQ(name=u'RTPPayloadType', mode=MODE_TYPE)
    _RTPPayloadType_payloadDescriptor = CHOICE(name=u'payloadDescriptor', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __RTPPayloadType_payloadDescriptor_nonStandardIdentifier = SEQ(name=u'nonStandardIdentifier', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')))
    __RTPPayloadType_payloadDescriptor_rfc_number = INT(name=u'rfc-number', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __RTPPayloadType_payloadDescriptor_rfc_number._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32768)], ev=[], er=[])
    __RTPPayloadType_payloadDescriptor_oid = OID(name=u'oid', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _RTPPayloadType_payloadDescriptor._cont = ASN1Dict([
        (u'nonStandardIdentifier', __RTPPayloadType_payloadDescriptor_nonStandardIdentifier),
        (u'rfc-number', __RTPPayloadType_payloadDescriptor_rfc_number),
        (u'oid', __RTPPayloadType_payloadDescriptor_oid),
        ])
    _RTPPayloadType_payloadDescriptor._ext = []
    _RTPPayloadType_payloadType = INT(name=u'payloadType', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _RTPPayloadType_payloadType._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    RTPPayloadType._cont = ASN1Dict([
        (u'payloadDescriptor', _RTPPayloadType_payloadDescriptor),
        (u'payloadType', _RTPPayloadType_payloadType),
        ])
    RTPPayloadType._ext = []
    
    #-----< RedundancyEncoding >-----#
    RedundancyEncoding = SEQ(name=u'RedundancyEncoding', mode=MODE_TYPE)
    _RedundancyEncoding_redundancyEncodingMethod = CHOICE(name=u'redundancyEncodingMethod', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'RedundancyEncodingMethod')))
    _RedundancyEncoding_secondaryEncoding = CHOICE(name=u'secondaryEncoding', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DataType')), opt=True)
    _RedundancyEncoding_rtpRedundancyEncoding = SEQ(name=u'rtpRedundancyEncoding', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __RedundancyEncoding_rtpRedundancyEncoding_primary = SEQ(name=u'primary', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'RedundancyEncodingElement')), opt=True)
    __RedundancyEncoding_rtpRedundancyEncoding_secondary = SEQ_OF(name=u'secondary', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    ___RedundancyEncoding_rtpRedundancyEncoding_secondary__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'RedundancyEncodingElement')))
    __RedundancyEncoding_rtpRedundancyEncoding_secondary._cont = ___RedundancyEncoding_rtpRedundancyEncoding_secondary__item_
    _RedundancyEncoding_rtpRedundancyEncoding._cont = ASN1Dict([
        (u'primary', __RedundancyEncoding_rtpRedundancyEncoding_primary),
        (u'secondary', __RedundancyEncoding_rtpRedundancyEncoding_secondary),
        ])
    _RedundancyEncoding_rtpRedundancyEncoding._ext = []
    RedundancyEncoding._cont = ASN1Dict([
        (u'redundancyEncodingMethod', _RedundancyEncoding_redundancyEncodingMethod),
        (u'secondaryEncoding', _RedundancyEncoding_secondaryEncoding),
        (u'rtpRedundancyEncoding', _RedundancyEncoding_rtpRedundancyEncoding),
        ])
    RedundancyEncoding._ext = [u'rtpRedundancyEncoding']
    
    #-----< RedundancyEncodingElement >-----#
    RedundancyEncodingElement = SEQ(name=u'RedundancyEncodingElement', mode=MODE_TYPE)
    _RedundancyEncodingElement_dataType = CHOICE(name=u'dataType', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DataType')))
    _RedundancyEncodingElement_payloadType = INT(name=u'payloadType', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _RedundancyEncodingElement_payloadType._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    RedundancyEncodingElement._cont = ASN1Dict([
        (u'dataType', _RedundancyEncodingElement_dataType),
        (u'payloadType', _RedundancyEncodingElement_payloadType),
        ])
    RedundancyEncodingElement._ext = []
    
    #-----< MultiplePayloadStream >-----#
    MultiplePayloadStream = SEQ(name=u'MultiplePayloadStream', mode=MODE_TYPE)
    _MultiplePayloadStream_elements = SEQ_OF(name=u'elements', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MultiplePayloadStream_elements__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MultiplePayloadStreamElement')))
    _MultiplePayloadStream_elements._cont = __MultiplePayloadStream_elements__item_
    MultiplePayloadStream._cont = ASN1Dict([
        (u'elements', _MultiplePayloadStream_elements),
        ])
    MultiplePayloadStream._ext = []
    
    #-----< MultiplePayloadStreamElement >-----#
    MultiplePayloadStreamElement = SEQ(name=u'MultiplePayloadStreamElement', mode=MODE_TYPE)
    _MultiplePayloadStreamElement_dataType = CHOICE(name=u'dataType', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DataType')))
    _MultiplePayloadStreamElement_payloadType = INT(name=u'payloadType', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MultiplePayloadStreamElement_payloadType._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    MultiplePayloadStreamElement._cont = ASN1Dict([
        (u'dataType', _MultiplePayloadStreamElement_dataType),
        (u'payloadType', _MultiplePayloadStreamElement_payloadType),
        ])
    MultiplePayloadStreamElement._ext = []
    
    #-----< DepFECData >-----#
    DepFECData = CHOICE(name=u'DepFECData', mode=MODE_TYPE)
    _DepFECData_rfc2733 = SEQ(name=u'rfc2733', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __DepFECData_rfc2733_mode = CHOICE(name=u'mode', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ___DepFECData_rfc2733_mode_redundancyEncoding = NULL(name=u'redundancyEncoding', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___DepFECData_rfc2733_mode_separateStream = CHOICE(name=u'separateStream', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ____DepFECData_rfc2733_mode_separateStream_differentPort = SEQ(name=u'differentPort', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _____DepFECData_rfc2733_mode_separateStream_differentPort_protectedSessionID = INT(name=u'protectedSessionID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _____DepFECData_rfc2733_mode_separateStream_differentPort_protectedSessionID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=255)], ev=None, er=[])
    _____DepFECData_rfc2733_mode_separateStream_differentPort_protectedPayloadType = INT(name=u'protectedPayloadType', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _____DepFECData_rfc2733_mode_separateStream_differentPort_protectedPayloadType._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    ____DepFECData_rfc2733_mode_separateStream_differentPort._cont = ASN1Dict([
        (u'protectedSessionID', _____DepFECData_rfc2733_mode_separateStream_differentPort_protectedSessionID),
        (u'protectedPayloadType', _____DepFECData_rfc2733_mode_separateStream_differentPort_protectedPayloadType),
        ])
    ____DepFECData_rfc2733_mode_separateStream_differentPort._ext = []
    ____DepFECData_rfc2733_mode_separateStream_samePort = SEQ(name=u'samePort', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _____DepFECData_rfc2733_mode_separateStream_samePort_protectedPayloadType = INT(name=u'protectedPayloadType', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _____DepFECData_rfc2733_mode_separateStream_samePort_protectedPayloadType._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    ____DepFECData_rfc2733_mode_separateStream_samePort._cont = ASN1Dict([
        (u'protectedPayloadType', _____DepFECData_rfc2733_mode_separateStream_samePort_protectedPayloadType),
        ])
    ____DepFECData_rfc2733_mode_separateStream_samePort._ext = []
    ___DepFECData_rfc2733_mode_separateStream._cont = ASN1Dict([
        (u'differentPort', ____DepFECData_rfc2733_mode_separateStream_differentPort),
        (u'samePort', ____DepFECData_rfc2733_mode_separateStream_samePort),
        ])
    ___DepFECData_rfc2733_mode_separateStream._ext = []
    __DepFECData_rfc2733_mode._cont = ASN1Dict([
        (u'redundancyEncoding', ___DepFECData_rfc2733_mode_redundancyEncoding),
        (u'separateStream', ___DepFECData_rfc2733_mode_separateStream),
        ])
    __DepFECData_rfc2733_mode._ext = []
    _DepFECData_rfc2733._cont = ASN1Dict([
        (u'mode', __DepFECData_rfc2733_mode),
        ])
    _DepFECData_rfc2733._ext = []
    DepFECData._cont = ASN1Dict([
        (u'rfc2733', _DepFECData_rfc2733),
        ])
    DepFECData._ext = None
    
    #-----< FECData >-----#
    FECData = CHOICE(name=u'FECData', mode=MODE_TYPE)
    _FECData_rfc2733 = SEQ(name=u'rfc2733', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __FECData_rfc2733_protectedPayloadType = INT(name=u'protectedPayloadType', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __FECData_rfc2733_protectedPayloadType._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    __FECData_rfc2733_fecScheme = OID(name=u'fecScheme', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __FECData_rfc2733_pktMode = CHOICE(name=u'pktMode', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ___FECData_rfc2733_pktMode_rfc2198coding = NULL(name=u'rfc2198coding', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___FECData_rfc2733_pktMode_rfc2733sameport = SEQ(name=u'rfc2733sameport', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___FECData_rfc2733_pktMode_rfc2733sameport._cont = ASN1Dict([
        ])
    ___FECData_rfc2733_pktMode_rfc2733sameport._ext = []
    ___FECData_rfc2733_pktMode_rfc2733diffport = SEQ(name=u'rfc2733diffport', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ____FECData_rfc2733_pktMode_rfc2733diffport_protectedChannel = INT(name=u'protectedChannel', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelNumber')))
    ___FECData_rfc2733_pktMode_rfc2733diffport._cont = ASN1Dict([
        (u'protectedChannel', ____FECData_rfc2733_pktMode_rfc2733diffport_protectedChannel),
        ])
    ___FECData_rfc2733_pktMode_rfc2733diffport._ext = []
    __FECData_rfc2733_pktMode._cont = ASN1Dict([
        (u'rfc2198coding', ___FECData_rfc2733_pktMode_rfc2198coding),
        (u'rfc2733sameport', ___FECData_rfc2733_pktMode_rfc2733sameport),
        (u'rfc2733diffport', ___FECData_rfc2733_pktMode_rfc2733diffport),
        ])
    __FECData_rfc2733_pktMode._ext = []
    _FECData_rfc2733._cont = ASN1Dict([
        (u'protectedPayloadType', __FECData_rfc2733_protectedPayloadType),
        (u'fecScheme', __FECData_rfc2733_fecScheme),
        (u'pktMode', __FECData_rfc2733_pktMode),
        ])
    _FECData_rfc2733._ext = []
    FECData._cont = ASN1Dict([
        (u'rfc2733', _FECData_rfc2733),
        ])
    FECData._ext = []
    
    #-----< TransportAddress >-----#
    TransportAddress = CHOICE(name=u'TransportAddress', mode=MODE_TYPE)
    _TransportAddress_unicastAddress = CHOICE(name=u'unicastAddress', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'UnicastAddress')))
    _TransportAddress_multicastAddress = CHOICE(name=u'multicastAddress', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MulticastAddress')))
    TransportAddress._cont = ASN1Dict([
        (u'unicastAddress', _TransportAddress_unicastAddress),
        (u'multicastAddress', _TransportAddress_multicastAddress),
        ])
    TransportAddress._ext = []
    
    #-----< UnicastAddress >-----#
    UnicastAddress = CHOICE(name=u'UnicastAddress', mode=MODE_TYPE)
    _UnicastAddress_iPAddress = SEQ(name=u'iPAddress', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __UnicastAddress_iPAddress_network = OCT_STR(name=u'network', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __UnicastAddress_iPAddress_network._const_sz = ASN1Set(rv=[4], rr=[], ev=None, er=[])
    __UnicastAddress_iPAddress_tsapIdentifier = INT(name=u'tsapIdentifier', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __UnicastAddress_iPAddress_tsapIdentifier._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    _UnicastAddress_iPAddress._cont = ASN1Dict([
        (u'network', __UnicastAddress_iPAddress_network),
        (u'tsapIdentifier', __UnicastAddress_iPAddress_tsapIdentifier),
        ])
    _UnicastAddress_iPAddress._ext = []
    _UnicastAddress_iPXAddress = SEQ(name=u'iPXAddress', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __UnicastAddress_iPXAddress_node = OCT_STR(name=u'node', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __UnicastAddress_iPXAddress_node._const_sz = ASN1Set(rv=[6], rr=[], ev=None, er=[])
    __UnicastAddress_iPXAddress_netnum = OCT_STR(name=u'netnum', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __UnicastAddress_iPXAddress_netnum._const_sz = ASN1Set(rv=[4], rr=[], ev=None, er=[])
    __UnicastAddress_iPXAddress_tsapIdentifier = OCT_STR(name=u'tsapIdentifier', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __UnicastAddress_iPXAddress_tsapIdentifier._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    _UnicastAddress_iPXAddress._cont = ASN1Dict([
        (u'node', __UnicastAddress_iPXAddress_node),
        (u'netnum', __UnicastAddress_iPXAddress_netnum),
        (u'tsapIdentifier', __UnicastAddress_iPXAddress_tsapIdentifier),
        ])
    _UnicastAddress_iPXAddress._ext = []
    _UnicastAddress_iP6Address = SEQ(name=u'iP6Address', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __UnicastAddress_iP6Address_network = OCT_STR(name=u'network', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __UnicastAddress_iP6Address_network._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    __UnicastAddress_iP6Address_tsapIdentifier = INT(name=u'tsapIdentifier', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __UnicastAddress_iP6Address_tsapIdentifier._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    _UnicastAddress_iP6Address._cont = ASN1Dict([
        (u'network', __UnicastAddress_iP6Address_network),
        (u'tsapIdentifier', __UnicastAddress_iP6Address_tsapIdentifier),
        ])
    _UnicastAddress_iP6Address._ext = []
    _UnicastAddress_netBios = OCT_STR(name=u'netBios', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UnicastAddress_netBios._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    _UnicastAddress_iPSourceRouteAddress = SEQ(name=u'iPSourceRouteAddress', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __UnicastAddress_iPSourceRouteAddress_routing = CHOICE(name=u'routing', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ___UnicastAddress_iPSourceRouteAddress_routing_strict = NULL(name=u'strict', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___UnicastAddress_iPSourceRouteAddress_routing_loose = NULL(name=u'loose', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __UnicastAddress_iPSourceRouteAddress_routing._cont = ASN1Dict([
        (u'strict', ___UnicastAddress_iPSourceRouteAddress_routing_strict),
        (u'loose', ___UnicastAddress_iPSourceRouteAddress_routing_loose),
        ])
    __UnicastAddress_iPSourceRouteAddress_routing._ext = None
    __UnicastAddress_iPSourceRouteAddress_network = OCT_STR(name=u'network', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __UnicastAddress_iPSourceRouteAddress_network._const_sz = ASN1Set(rv=[4], rr=[], ev=None, er=[])
    __UnicastAddress_iPSourceRouteAddress_tsapIdentifier = INT(name=u'tsapIdentifier', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __UnicastAddress_iPSourceRouteAddress_tsapIdentifier._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    __UnicastAddress_iPSourceRouteAddress_route = SEQ_OF(name=u'route', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___UnicastAddress_iPSourceRouteAddress_route__item_ = OCT_STR(name='_item_', mode=MODE_TYPE)
    ___UnicastAddress_iPSourceRouteAddress_route__item_._const_sz = ASN1Set(rv=[4], rr=[], ev=None, er=[])
    __UnicastAddress_iPSourceRouteAddress_route._cont = ___UnicastAddress_iPSourceRouteAddress_route__item_
    _UnicastAddress_iPSourceRouteAddress._cont = ASN1Dict([
        (u'routing', __UnicastAddress_iPSourceRouteAddress_routing),
        (u'network', __UnicastAddress_iPSourceRouteAddress_network),
        (u'tsapIdentifier', __UnicastAddress_iPSourceRouteAddress_tsapIdentifier),
        (u'route', __UnicastAddress_iPSourceRouteAddress_route),
        ])
    _UnicastAddress_iPSourceRouteAddress._ext = []
    _UnicastAddress_nsap = OCT_STR(name=u'nsap', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UnicastAddress_nsap._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=20)], ev=None, er=[])
    _UnicastAddress_nonStandardAddress = SEQ(name=u'nonStandardAddress', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')))
    UnicastAddress._cont = ASN1Dict([
        (u'iPAddress', _UnicastAddress_iPAddress),
        (u'iPXAddress', _UnicastAddress_iPXAddress),
        (u'iP6Address', _UnicastAddress_iP6Address),
        (u'netBios', _UnicastAddress_netBios),
        (u'iPSourceRouteAddress', _UnicastAddress_iPSourceRouteAddress),
        (u'nsap', _UnicastAddress_nsap),
        (u'nonStandardAddress', _UnicastAddress_nonStandardAddress),
        ])
    UnicastAddress._ext = [u'nsap', u'nonStandardAddress']
    
    #-----< MulticastAddress >-----#
    MulticastAddress = CHOICE(name=u'MulticastAddress', mode=MODE_TYPE)
    _MulticastAddress_iPAddress = SEQ(name=u'iPAddress', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MulticastAddress_iPAddress_network = OCT_STR(name=u'network', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MulticastAddress_iPAddress_network._const_sz = ASN1Set(rv=[4], rr=[], ev=None, er=[])
    __MulticastAddress_iPAddress_tsapIdentifier = INT(name=u'tsapIdentifier', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MulticastAddress_iPAddress_tsapIdentifier._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    _MulticastAddress_iPAddress._cont = ASN1Dict([
        (u'network', __MulticastAddress_iPAddress_network),
        (u'tsapIdentifier', __MulticastAddress_iPAddress_tsapIdentifier),
        ])
    _MulticastAddress_iPAddress._ext = []
    _MulticastAddress_iP6Address = SEQ(name=u'iP6Address', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MulticastAddress_iP6Address_network = OCT_STR(name=u'network', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MulticastAddress_iP6Address_network._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    __MulticastAddress_iP6Address_tsapIdentifier = INT(name=u'tsapIdentifier', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MulticastAddress_iP6Address_tsapIdentifier._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    _MulticastAddress_iP6Address._cont = ASN1Dict([
        (u'network', __MulticastAddress_iP6Address_network),
        (u'tsapIdentifier', __MulticastAddress_iP6Address_tsapIdentifier),
        ])
    _MulticastAddress_iP6Address._ext = []
    _MulticastAddress_nsap = OCT_STR(name=u'nsap', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MulticastAddress_nsap._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=20)], ev=None, er=[])
    _MulticastAddress_nonStandardAddress = SEQ(name=u'nonStandardAddress', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')))
    MulticastAddress._cont = ASN1Dict([
        (u'iPAddress', _MulticastAddress_iPAddress),
        (u'iP6Address', _MulticastAddress_iP6Address),
        (u'nsap', _MulticastAddress_nsap),
        (u'nonStandardAddress', _MulticastAddress_nonStandardAddress),
        ])
    MulticastAddress._ext = [u'nsap', u'nonStandardAddress']
    
    #-----< EncryptionSync >-----#
    EncryptionSync = SEQ(name=u'EncryptionSync', mode=MODE_TYPE)
    _EncryptionSync_nonStandard = SEQ(name=u'nonStandard', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')), opt=True)
    _EncryptionSync_synchFlag = INT(name=u'synchFlag', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EncryptionSync_synchFlag._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _EncryptionSync_h235Key = OCT_STR(name=u'h235Key', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EncryptionSync_h235Key._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    _EncryptionSync_escrowentry = SEQ_OF(name=u'escrowentry', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __EncryptionSync_escrowentry__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'EscrowData')))
    _EncryptionSync_escrowentry._cont = __EncryptionSync_escrowentry__item_
    _EncryptionSync_escrowentry._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    _EncryptionSync_genericParameter = SEQ(name=u'genericParameter', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'GenericParameter')), opt=True)
    EncryptionSync._cont = ASN1Dict([
        (u'nonStandard', _EncryptionSync_nonStandard),
        (u'synchFlag', _EncryptionSync_synchFlag),
        (u'h235Key', _EncryptionSync_h235Key),
        (u'escrowentry', _EncryptionSync_escrowentry),
        (u'genericParameter', _EncryptionSync_genericParameter),
        ])
    EncryptionSync._ext = [u'genericParameter']
    
    #-----< EscrowData >-----#
    EscrowData = SEQ(name=u'EscrowData', mode=MODE_TYPE)
    _EscrowData_escrowID = OID(name=u'escrowID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EscrowData_escrowValue = BIT_STR(name=u'escrowValue', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EscrowData_escrowValue._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    EscrowData._cont = ASN1Dict([
        (u'escrowID', _EscrowData_escrowID),
        (u'escrowValue', _EscrowData_escrowValue),
        ])
    EscrowData._ext = []
    
    #-----< OpenLogicalChannelAck >-----#
    OpenLogicalChannelAck = SEQ(name=u'OpenLogicalChannelAck', mode=MODE_TYPE)
    _OpenLogicalChannelAck_forwardLogicalChannelNumber = INT(name=u'forwardLogicalChannelNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelNumber')))
    _OpenLogicalChannelAck_reverseLogicalChannelParameters = SEQ(name=u'reverseLogicalChannelParameters', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OpenLogicalChannelAck_reverseLogicalChannelParameters_reverseLogicalChannelNumber = INT(name=u'reverseLogicalChannelNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelNumber')))
    __OpenLogicalChannelAck_reverseLogicalChannelParameters_portNumber = INT(name=u'portNumber', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OpenLogicalChannelAck_reverseLogicalChannelParameters_portNumber._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    __OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters = CHOICE(name=u'multiplexParameters', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    ___OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters_h222LogicalChannelParameters = SEQ(name=u'h222LogicalChannelParameters', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H222LogicalChannelParameters')))
    ___OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters_h2250LogicalChannelParameters = SEQ(name=u'h2250LogicalChannelParameters', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H2250LogicalChannelParameters')))
    __OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters._cont = ASN1Dict([
        (u'h222LogicalChannelParameters', ___OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters_h222LogicalChannelParameters),
        (u'h2250LogicalChannelParameters', ___OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters_h2250LogicalChannelParameters),
        ])
    __OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters._ext = [u'h2250LogicalChannelParameters']
    __OpenLogicalChannelAck_reverseLogicalChannelParameters_replacementFor = INT(name=u'replacementFor', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelNumber')), opt=True)
    _OpenLogicalChannelAck_reverseLogicalChannelParameters._cont = ASN1Dict([
        (u'reverseLogicalChannelNumber', __OpenLogicalChannelAck_reverseLogicalChannelParameters_reverseLogicalChannelNumber),
        (u'portNumber', __OpenLogicalChannelAck_reverseLogicalChannelParameters_portNumber),
        (u'multiplexParameters', __OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters),
        (u'replacementFor', __OpenLogicalChannelAck_reverseLogicalChannelParameters_replacementFor),
        ])
    _OpenLogicalChannelAck_reverseLogicalChannelParameters._ext = [u'replacementFor']
    _OpenLogicalChannelAck_separateStack = SEQ(name=u'separateStack', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NetworkAccessParameters')), opt=True)
    _OpenLogicalChannelAck_forwardMultiplexAckParameters = CHOICE(name=u'forwardMultiplexAckParameters', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __OpenLogicalChannelAck_forwardMultiplexAckParameters_h2250LogicalChannelAckParameters = SEQ(name=u'h2250LogicalChannelAckParameters', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H2250LogicalChannelAckParameters')))
    _OpenLogicalChannelAck_forwardMultiplexAckParameters._cont = ASN1Dict([
        (u'h2250LogicalChannelAckParameters', __OpenLogicalChannelAck_forwardMultiplexAckParameters_h2250LogicalChannelAckParameters),
        ])
    _OpenLogicalChannelAck_forwardMultiplexAckParameters._ext = []
    _OpenLogicalChannelAck_encryptionSync = SEQ(name=u'encryptionSync', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'EncryptionSync')), opt=True)
    _OpenLogicalChannelAck_genericInformation = SEQ_OF(name=u'genericInformation', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OpenLogicalChannelAck_genericInformation__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'GenericInformation')))
    _OpenLogicalChannelAck_genericInformation._cont = __OpenLogicalChannelAck_genericInformation__item_
    OpenLogicalChannelAck._cont = ASN1Dict([
        (u'forwardLogicalChannelNumber', _OpenLogicalChannelAck_forwardLogicalChannelNumber),
        (u'reverseLogicalChannelParameters', _OpenLogicalChannelAck_reverseLogicalChannelParameters),
        (u'separateStack', _OpenLogicalChannelAck_separateStack),
        (u'forwardMultiplexAckParameters', _OpenLogicalChannelAck_forwardMultiplexAckParameters),
        (u'encryptionSync', _OpenLogicalChannelAck_encryptionSync),
        (u'genericInformation', _OpenLogicalChannelAck_genericInformation),
        ])
    OpenLogicalChannelAck._ext = [u'separateStack', u'forwardMultiplexAckParameters', u'encryptionSync', u'genericInformation']
    
    #-----< OpenLogicalChannelReject >-----#
    OpenLogicalChannelReject = SEQ(name=u'OpenLogicalChannelReject', mode=MODE_TYPE)
    _OpenLogicalChannelReject_forwardLogicalChannelNumber = INT(name=u'forwardLogicalChannelNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelNumber')))
    _OpenLogicalChannelReject_cause = CHOICE(name=u'cause', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __OpenLogicalChannelReject_cause_unspecified = NULL(name=u'unspecified', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OpenLogicalChannelReject_cause_unsuitableReverseParameters = NULL(name=u'unsuitableReverseParameters', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OpenLogicalChannelReject_cause_dataTypeNotSupported = NULL(name=u'dataTypeNotSupported', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OpenLogicalChannelReject_cause_dataTypeNotAvailable = NULL(name=u'dataTypeNotAvailable', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OpenLogicalChannelReject_cause_unknownDataType = NULL(name=u'unknownDataType', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OpenLogicalChannelReject_cause_dataTypeALCombinationNotSupported = NULL(name=u'dataTypeALCombinationNotSupported', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OpenLogicalChannelReject_cause_multicastChannelNotAllowed = NULL(name=u'multicastChannelNotAllowed', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OpenLogicalChannelReject_cause_insufficientBandwidth = NULL(name=u'insufficientBandwidth', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OpenLogicalChannelReject_cause_separateStackEstablishmentFailed = NULL(name=u'separateStackEstablishmentFailed', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OpenLogicalChannelReject_cause_invalidSessionID = NULL(name=u'invalidSessionID', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OpenLogicalChannelReject_cause_masterSlaveConflict = NULL(name=u'masterSlaveConflict', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OpenLogicalChannelReject_cause_waitForCommunicationMode = NULL(name=u'waitForCommunicationMode', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OpenLogicalChannelReject_cause_invalidDependentChannel = NULL(name=u'invalidDependentChannel', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OpenLogicalChannelReject_cause_replacementForRejected = NULL(name=u'replacementForRejected', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OpenLogicalChannelReject_cause_securityDenied = NULL(name=u'securityDenied', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __OpenLogicalChannelReject_cause_qoSControlNotSupported = NULL(name=u'qoSControlNotSupported', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _OpenLogicalChannelReject_cause._cont = ASN1Dict([
        (u'unspecified', __OpenLogicalChannelReject_cause_unspecified),
        (u'unsuitableReverseParameters', __OpenLogicalChannelReject_cause_unsuitableReverseParameters),
        (u'dataTypeNotSupported', __OpenLogicalChannelReject_cause_dataTypeNotSupported),
        (u'dataTypeNotAvailable', __OpenLogicalChannelReject_cause_dataTypeNotAvailable),
        (u'unknownDataType', __OpenLogicalChannelReject_cause_unknownDataType),
        (u'dataTypeALCombinationNotSupported', __OpenLogicalChannelReject_cause_dataTypeALCombinationNotSupported),
        (u'multicastChannelNotAllowed', __OpenLogicalChannelReject_cause_multicastChannelNotAllowed),
        (u'insufficientBandwidth', __OpenLogicalChannelReject_cause_insufficientBandwidth),
        (u'separateStackEstablishmentFailed', __OpenLogicalChannelReject_cause_separateStackEstablishmentFailed),
        (u'invalidSessionID', __OpenLogicalChannelReject_cause_invalidSessionID),
        (u'masterSlaveConflict', __OpenLogicalChannelReject_cause_masterSlaveConflict),
        (u'waitForCommunicationMode', __OpenLogicalChannelReject_cause_waitForCommunicationMode),
        (u'invalidDependentChannel', __OpenLogicalChannelReject_cause_invalidDependentChannel),
        (u'replacementForRejected', __OpenLogicalChannelReject_cause_replacementForRejected),
        (u'securityDenied', __OpenLogicalChannelReject_cause_securityDenied),
        (u'qoSControlNotSupported', __OpenLogicalChannelReject_cause_qoSControlNotSupported),
        ])
    _OpenLogicalChannelReject_cause._ext = [u'multicastChannelNotAllowed', u'insufficientBandwidth', u'separateStackEstablishmentFailed', u'invalidSessionID', u'masterSlaveConflict', u'waitForCommunicationMode', u'invalidDependentChannel', u'replacementForRejected', u'securityDenied', u'qoSControlNotSupported']
    _OpenLogicalChannelReject_genericInformation = SEQ_OF(name=u'genericInformation', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OpenLogicalChannelReject_genericInformation__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'GenericInformation')))
    _OpenLogicalChannelReject_genericInformation._cont = __OpenLogicalChannelReject_genericInformation__item_
    OpenLogicalChannelReject._cont = ASN1Dict([
        (u'forwardLogicalChannelNumber', _OpenLogicalChannelReject_forwardLogicalChannelNumber),
        (u'cause', _OpenLogicalChannelReject_cause),
        (u'genericInformation', _OpenLogicalChannelReject_genericInformation),
        ])
    OpenLogicalChannelReject._ext = [u'genericInformation']
    
    #-----< OpenLogicalChannelConfirm >-----#
    OpenLogicalChannelConfirm = SEQ(name=u'OpenLogicalChannelConfirm', mode=MODE_TYPE)
    _OpenLogicalChannelConfirm_forwardLogicalChannelNumber = INT(name=u'forwardLogicalChannelNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelNumber')))
    _OpenLogicalChannelConfirm_genericInformation = SEQ_OF(name=u'genericInformation', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __OpenLogicalChannelConfirm_genericInformation__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'GenericInformation')))
    _OpenLogicalChannelConfirm_genericInformation._cont = __OpenLogicalChannelConfirm_genericInformation__item_
    OpenLogicalChannelConfirm._cont = ASN1Dict([
        (u'forwardLogicalChannelNumber', _OpenLogicalChannelConfirm_forwardLogicalChannelNumber),
        (u'genericInformation', _OpenLogicalChannelConfirm_genericInformation),
        ])
    OpenLogicalChannelConfirm._ext = [u'genericInformation']
    
    #-----< H2250LogicalChannelAckParameters >-----#
    H2250LogicalChannelAckParameters = SEQ(name=u'H2250LogicalChannelAckParameters', mode=MODE_TYPE)
    _H2250LogicalChannelAckParameters_nonStandard = SEQ_OF(name=u'nonStandard', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __H2250LogicalChannelAckParameters_nonStandard__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')))
    _H2250LogicalChannelAckParameters_nonStandard._cont = __H2250LogicalChannelAckParameters_nonStandard__item_
    _H2250LogicalChannelAckParameters_sessionID = INT(name=u'sessionID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _H2250LogicalChannelAckParameters_sessionID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=255)], ev=None, er=[])
    _H2250LogicalChannelAckParameters_mediaChannel = CHOICE(name=u'mediaChannel', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TransportAddress')), opt=True)
    _H2250LogicalChannelAckParameters_mediaControlChannel = CHOICE(name=u'mediaControlChannel', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TransportAddress')), opt=True)
    _H2250LogicalChannelAckParameters_dynamicRTPPayloadType = INT(name=u'dynamicRTPPayloadType', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _H2250LogicalChannelAckParameters_dynamicRTPPayloadType._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=96, ub=127)], ev=None, er=[])
    _H2250LogicalChannelAckParameters_flowControlToZero = BOOL(name=u'flowControlToZero', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H2250LogicalChannelAckParameters_portNumber = INT(name=u'portNumber', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _H2250LogicalChannelAckParameters_portNumber._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    _H2250LogicalChannelAckParameters_multiplePayloadStream = SEQ(name=u'multiplePayloadStream', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MultiplePayloadStream')), opt=True)
    H2250LogicalChannelAckParameters._cont = ASN1Dict([
        (u'nonStandard', _H2250LogicalChannelAckParameters_nonStandard),
        (u'sessionID', _H2250LogicalChannelAckParameters_sessionID),
        (u'mediaChannel', _H2250LogicalChannelAckParameters_mediaChannel),
        (u'mediaControlChannel', _H2250LogicalChannelAckParameters_mediaControlChannel),
        (u'dynamicRTPPayloadType', _H2250LogicalChannelAckParameters_dynamicRTPPayloadType),
        (u'flowControlToZero', _H2250LogicalChannelAckParameters_flowControlToZero),
        (u'portNumber', _H2250LogicalChannelAckParameters_portNumber),
        (u'multiplePayloadStream', _H2250LogicalChannelAckParameters_multiplePayloadStream),
        ])
    H2250LogicalChannelAckParameters._ext = [u'flowControlToZero', u'portNumber', u'multiplePayloadStream']
    
    #-----< CloseLogicalChannel >-----#
    CloseLogicalChannel = SEQ(name=u'CloseLogicalChannel', mode=MODE_TYPE)
    _CloseLogicalChannel_forwardLogicalChannelNumber = INT(name=u'forwardLogicalChannelNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelNumber')))
    _CloseLogicalChannel_source = CHOICE(name=u'source', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __CloseLogicalChannel_source_user = NULL(name=u'user', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __CloseLogicalChannel_source_lcse = NULL(name=u'lcse', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _CloseLogicalChannel_source._cont = ASN1Dict([
        (u'user', __CloseLogicalChannel_source_user),
        (u'lcse', __CloseLogicalChannel_source_lcse),
        ])
    _CloseLogicalChannel_source._ext = None
    _CloseLogicalChannel_reason = CHOICE(name=u'reason', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __CloseLogicalChannel_reason_unknown = NULL(name=u'unknown', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __CloseLogicalChannel_reason_reopen = NULL(name=u'reopen', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __CloseLogicalChannel_reason_reservationFailure = NULL(name=u'reservationFailure', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __CloseLogicalChannel_reason_networkErrorCode = INT(name=u'networkErrorCode', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __CloseLogicalChannel_reason_networkErrorCode._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _CloseLogicalChannel_reason._cont = ASN1Dict([
        (u'unknown', __CloseLogicalChannel_reason_unknown),
        (u'reopen', __CloseLogicalChannel_reason_reopen),
        (u'reservationFailure', __CloseLogicalChannel_reason_reservationFailure),
        (u'networkErrorCode', __CloseLogicalChannel_reason_networkErrorCode),
        ])
    _CloseLogicalChannel_reason._ext = [u'networkErrorCode']
    CloseLogicalChannel._cont = ASN1Dict([
        (u'forwardLogicalChannelNumber', _CloseLogicalChannel_forwardLogicalChannelNumber),
        (u'source', _CloseLogicalChannel_source),
        (u'reason', _CloseLogicalChannel_reason),
        ])
    CloseLogicalChannel._ext = [u'reason']
    
    #-----< CloseLogicalChannelAck >-----#
    CloseLogicalChannelAck = SEQ(name=u'CloseLogicalChannelAck', mode=MODE_TYPE)
    _CloseLogicalChannelAck_forwardLogicalChannelNumber = INT(name=u'forwardLogicalChannelNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelNumber')))
    CloseLogicalChannelAck._cont = ASN1Dict([
        (u'forwardLogicalChannelNumber', _CloseLogicalChannelAck_forwardLogicalChannelNumber),
        ])
    CloseLogicalChannelAck._ext = []
    
    #-----< RequestChannelClose >-----#
    RequestChannelClose = SEQ(name=u'RequestChannelClose', mode=MODE_TYPE)
    _RequestChannelClose_forwardLogicalChannelNumber = INT(name=u'forwardLogicalChannelNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelNumber')))
    _RequestChannelClose_qosCapability = SEQ(name=u'qosCapability', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'QOSCapability')), opt=True)
    _RequestChannelClose_reason = CHOICE(name=u'reason', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __RequestChannelClose_reason_unknown = NULL(name=u'unknown', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __RequestChannelClose_reason_normal = NULL(name=u'normal', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __RequestChannelClose_reason_reopen = NULL(name=u'reopen', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __RequestChannelClose_reason_reservationFailure = NULL(name=u'reservationFailure', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __RequestChannelClose_reason_networkErrorCode = INT(name=u'networkErrorCode', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __RequestChannelClose_reason_networkErrorCode._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _RequestChannelClose_reason._cont = ASN1Dict([
        (u'unknown', __RequestChannelClose_reason_unknown),
        (u'normal', __RequestChannelClose_reason_normal),
        (u'reopen', __RequestChannelClose_reason_reopen),
        (u'reservationFailure', __RequestChannelClose_reason_reservationFailure),
        (u'networkErrorCode', __RequestChannelClose_reason_networkErrorCode),
        ])
    _RequestChannelClose_reason._ext = [u'networkErrorCode']
    RequestChannelClose._cont = ASN1Dict([
        (u'forwardLogicalChannelNumber', _RequestChannelClose_forwardLogicalChannelNumber),
        (u'qosCapability', _RequestChannelClose_qosCapability),
        (u'reason', _RequestChannelClose_reason),
        ])
    RequestChannelClose._ext = [u'qosCapability', u'reason']
    
    #-----< RequestChannelCloseAck >-----#
    RequestChannelCloseAck = SEQ(name=u'RequestChannelCloseAck', mode=MODE_TYPE)
    _RequestChannelCloseAck_forwardLogicalChannelNumber = INT(name=u'forwardLogicalChannelNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelNumber')))
    RequestChannelCloseAck._cont = ASN1Dict([
        (u'forwardLogicalChannelNumber', _RequestChannelCloseAck_forwardLogicalChannelNumber),
        ])
    RequestChannelCloseAck._ext = []
    
    #-----< RequestChannelCloseReject >-----#
    RequestChannelCloseReject = SEQ(name=u'RequestChannelCloseReject', mode=MODE_TYPE)
    _RequestChannelCloseReject_forwardLogicalChannelNumber = INT(name=u'forwardLogicalChannelNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelNumber')))
    _RequestChannelCloseReject_cause = CHOICE(name=u'cause', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __RequestChannelCloseReject_cause_unspecified = NULL(name=u'unspecified', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _RequestChannelCloseReject_cause._cont = ASN1Dict([
        (u'unspecified', __RequestChannelCloseReject_cause_unspecified),
        ])
    _RequestChannelCloseReject_cause._ext = []
    RequestChannelCloseReject._cont = ASN1Dict([
        (u'forwardLogicalChannelNumber', _RequestChannelCloseReject_forwardLogicalChannelNumber),
        (u'cause', _RequestChannelCloseReject_cause),
        ])
    RequestChannelCloseReject._ext = []
    
    #-----< RequestChannelCloseRelease >-----#
    RequestChannelCloseRelease = SEQ(name=u'RequestChannelCloseRelease', mode=MODE_TYPE)
    _RequestChannelCloseRelease_forwardLogicalChannelNumber = INT(name=u'forwardLogicalChannelNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelNumber')))
    RequestChannelCloseRelease._cont = ASN1Dict([
        (u'forwardLogicalChannelNumber', _RequestChannelCloseRelease_forwardLogicalChannelNumber),
        ])
    RequestChannelCloseRelease._ext = []
    
    #-----< MultiplexEntrySend >-----#
    MultiplexEntrySend = SEQ(name=u'MultiplexEntrySend', mode=MODE_TYPE)
    _MultiplexEntrySend_sequenceNumber = INT(name=u'sequenceNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'SequenceNumber')))
    _MultiplexEntrySend_multiplexEntryDescriptors = SET_OF(name=u'multiplexEntryDescriptors', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MultiplexEntrySend_multiplexEntryDescriptors__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MultiplexEntryDescriptor')))
    _MultiplexEntrySend_multiplexEntryDescriptors._cont = __MultiplexEntrySend_multiplexEntryDescriptors__item_
    _MultiplexEntrySend_multiplexEntryDescriptors._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=15)], ev=None, er=[])
    MultiplexEntrySend._cont = ASN1Dict([
        (u'sequenceNumber', _MultiplexEntrySend_sequenceNumber),
        (u'multiplexEntryDescriptors', _MultiplexEntrySend_multiplexEntryDescriptors),
        ])
    MultiplexEntrySend._ext = []
    
    #-----< MultiplexEntryDescriptor >-----#
    MultiplexEntryDescriptor = SEQ(name=u'MultiplexEntryDescriptor', mode=MODE_TYPE)
    _MultiplexEntryDescriptor_multiplexTableEntryNumber = INT(name=u'multiplexTableEntryNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MultiplexTableEntryNumber')))
    _MultiplexEntryDescriptor_elementList = SEQ_OF(name=u'elementList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __MultiplexEntryDescriptor_elementList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MultiplexElement')))
    _MultiplexEntryDescriptor_elementList._cont = __MultiplexEntryDescriptor_elementList__item_
    _MultiplexEntryDescriptor_elementList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    MultiplexEntryDescriptor._cont = ASN1Dict([
        (u'multiplexTableEntryNumber', _MultiplexEntryDescriptor_multiplexTableEntryNumber),
        (u'elementList', _MultiplexEntryDescriptor_elementList),
        ])
    MultiplexEntryDescriptor._ext = None
    
    #-----< MultiplexElement >-----#
    MultiplexElement = SEQ(name=u'MultiplexElement', mode=MODE_TYPE)
    _MultiplexElement_type = CHOICE(name=u'type', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __MultiplexElement_type_logicalChannelNumber = INT(name=u'logicalChannelNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MultiplexElement_type_logicalChannelNumber._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    __MultiplexElement_type_subElementList = SEQ_OF(name=u'subElementList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___MultiplexElement_type_subElementList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MultiplexElement')))
    __MultiplexElement_type_subElementList._cont = ___MultiplexElement_type_subElementList__item_
    __MultiplexElement_type_subElementList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=2, ub=255)], ev=None, er=[])
    _MultiplexElement_type._cont = ASN1Dict([
        (u'logicalChannelNumber', __MultiplexElement_type_logicalChannelNumber),
        (u'subElementList', __MultiplexElement_type_subElementList),
        ])
    _MultiplexElement_type._ext = None
    _MultiplexElement_repeatCount = CHOICE(name=u'repeatCount', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __MultiplexElement_repeatCount_finite = INT(name=u'finite', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MultiplexElement_repeatCount_finite._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    __MultiplexElement_repeatCount_untilClosingFlag = NULL(name=u'untilClosingFlag', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MultiplexElement_repeatCount._cont = ASN1Dict([
        (u'finite', __MultiplexElement_repeatCount_finite),
        (u'untilClosingFlag', __MultiplexElement_repeatCount_untilClosingFlag),
        ])
    _MultiplexElement_repeatCount._ext = None
    MultiplexElement._cont = ASN1Dict([
        (u'type', _MultiplexElement_type),
        (u'repeatCount', _MultiplexElement_repeatCount),
        ])
    MultiplexElement._ext = None
    
    #-----< MultiplexTableEntryNumber >-----#
    MultiplexTableEntryNumber = INT(name=u'MultiplexTableEntryNumber', mode=MODE_TYPE)
    MultiplexTableEntryNumber._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=15)], ev=None, er=[])
    
    #-----< MultiplexEntrySendAck >-----#
    MultiplexEntrySendAck = SEQ(name=u'MultiplexEntrySendAck', mode=MODE_TYPE)
    _MultiplexEntrySendAck_sequenceNumber = INT(name=u'sequenceNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'SequenceNumber')))
    _MultiplexEntrySendAck_multiplexTableEntryNumber = SET_OF(name=u'multiplexTableEntryNumber', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MultiplexEntrySendAck_multiplexTableEntryNumber__item_ = INT(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MultiplexTableEntryNumber')))
    _MultiplexEntrySendAck_multiplexTableEntryNumber._cont = __MultiplexEntrySendAck_multiplexTableEntryNumber__item_
    _MultiplexEntrySendAck_multiplexTableEntryNumber._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=15)], ev=None, er=[])
    MultiplexEntrySendAck._cont = ASN1Dict([
        (u'sequenceNumber', _MultiplexEntrySendAck_sequenceNumber),
        (u'multiplexTableEntryNumber', _MultiplexEntrySendAck_multiplexTableEntryNumber),
        ])
    MultiplexEntrySendAck._ext = []
    
    #-----< MultiplexEntrySendReject >-----#
    MultiplexEntrySendReject = SEQ(name=u'MultiplexEntrySendReject', mode=MODE_TYPE)
    _MultiplexEntrySendReject_sequenceNumber = INT(name=u'sequenceNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'SequenceNumber')))
    _MultiplexEntrySendReject_rejectionDescriptions = SET_OF(name=u'rejectionDescriptions', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MultiplexEntrySendReject_rejectionDescriptions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MultiplexEntryRejectionDescriptions')))
    _MultiplexEntrySendReject_rejectionDescriptions._cont = __MultiplexEntrySendReject_rejectionDescriptions__item_
    _MultiplexEntrySendReject_rejectionDescriptions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=15)], ev=None, er=[])
    MultiplexEntrySendReject._cont = ASN1Dict([
        (u'sequenceNumber', _MultiplexEntrySendReject_sequenceNumber),
        (u'rejectionDescriptions', _MultiplexEntrySendReject_rejectionDescriptions),
        ])
    MultiplexEntrySendReject._ext = []
    
    #-----< MultiplexEntryRejectionDescriptions >-----#
    MultiplexEntryRejectionDescriptions = SEQ(name=u'MultiplexEntryRejectionDescriptions', mode=MODE_TYPE)
    _MultiplexEntryRejectionDescriptions_multiplexTableEntryNumber = INT(name=u'multiplexTableEntryNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MultiplexTableEntryNumber')))
    _MultiplexEntryRejectionDescriptions_cause = CHOICE(name=u'cause', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __MultiplexEntryRejectionDescriptions_cause_unspecifiedCause = NULL(name=u'unspecifiedCause', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MultiplexEntryRejectionDescriptions_cause_descriptorTooComplex = NULL(name=u'descriptorTooComplex', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MultiplexEntryRejectionDescriptions_cause._cont = ASN1Dict([
        (u'unspecifiedCause', __MultiplexEntryRejectionDescriptions_cause_unspecifiedCause),
        (u'descriptorTooComplex', __MultiplexEntryRejectionDescriptions_cause_descriptorTooComplex),
        ])
    _MultiplexEntryRejectionDescriptions_cause._ext = []
    MultiplexEntryRejectionDescriptions._cont = ASN1Dict([
        (u'multiplexTableEntryNumber', _MultiplexEntryRejectionDescriptions_multiplexTableEntryNumber),
        (u'cause', _MultiplexEntryRejectionDescriptions_cause),
        ])
    MultiplexEntryRejectionDescriptions._ext = []
    
    #-----< MultiplexEntrySendRelease >-----#
    MultiplexEntrySendRelease = SEQ(name=u'MultiplexEntrySendRelease', mode=MODE_TYPE)
    _MultiplexEntrySendRelease_multiplexTableEntryNumber = SET_OF(name=u'multiplexTableEntryNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MultiplexEntrySendRelease_multiplexTableEntryNumber__item_ = INT(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MultiplexTableEntryNumber')))
    _MultiplexEntrySendRelease_multiplexTableEntryNumber._cont = __MultiplexEntrySendRelease_multiplexTableEntryNumber__item_
    _MultiplexEntrySendRelease_multiplexTableEntryNumber._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=15)], ev=None, er=[])
    MultiplexEntrySendRelease._cont = ASN1Dict([
        (u'multiplexTableEntryNumber', _MultiplexEntrySendRelease_multiplexTableEntryNumber),
        ])
    MultiplexEntrySendRelease._ext = []
    
    #-----< RequestMultiplexEntry >-----#
    RequestMultiplexEntry = SEQ(name=u'RequestMultiplexEntry', mode=MODE_TYPE)
    _RequestMultiplexEntry_entryNumbers = SET_OF(name=u'entryNumbers', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __RequestMultiplexEntry_entryNumbers__item_ = INT(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MultiplexTableEntryNumber')))
    _RequestMultiplexEntry_entryNumbers._cont = __RequestMultiplexEntry_entryNumbers__item_
    _RequestMultiplexEntry_entryNumbers._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=15)], ev=None, er=[])
    RequestMultiplexEntry._cont = ASN1Dict([
        (u'entryNumbers', _RequestMultiplexEntry_entryNumbers),
        ])
    RequestMultiplexEntry._ext = []
    
    #-----< RequestMultiplexEntryAck >-----#
    RequestMultiplexEntryAck = SEQ(name=u'RequestMultiplexEntryAck', mode=MODE_TYPE)
    _RequestMultiplexEntryAck_entryNumbers = SET_OF(name=u'entryNumbers', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __RequestMultiplexEntryAck_entryNumbers__item_ = INT(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MultiplexTableEntryNumber')))
    _RequestMultiplexEntryAck_entryNumbers._cont = __RequestMultiplexEntryAck_entryNumbers__item_
    _RequestMultiplexEntryAck_entryNumbers._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=15)], ev=None, er=[])
    RequestMultiplexEntryAck._cont = ASN1Dict([
        (u'entryNumbers', _RequestMultiplexEntryAck_entryNumbers),
        ])
    RequestMultiplexEntryAck._ext = []
    
    #-----< RequestMultiplexEntryReject >-----#
    RequestMultiplexEntryReject = SEQ(name=u'RequestMultiplexEntryReject', mode=MODE_TYPE)
    _RequestMultiplexEntryReject_entryNumbers = SET_OF(name=u'entryNumbers', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __RequestMultiplexEntryReject_entryNumbers__item_ = INT(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MultiplexTableEntryNumber')))
    _RequestMultiplexEntryReject_entryNumbers._cont = __RequestMultiplexEntryReject_entryNumbers__item_
    _RequestMultiplexEntryReject_entryNumbers._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=15)], ev=None, er=[])
    _RequestMultiplexEntryReject_rejectionDescriptions = SET_OF(name=u'rejectionDescriptions', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __RequestMultiplexEntryReject_rejectionDescriptions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'RequestMultiplexEntryRejectionDescriptions')))
    _RequestMultiplexEntryReject_rejectionDescriptions._cont = __RequestMultiplexEntryReject_rejectionDescriptions__item_
    _RequestMultiplexEntryReject_rejectionDescriptions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=15)], ev=None, er=[])
    RequestMultiplexEntryReject._cont = ASN1Dict([
        (u'entryNumbers', _RequestMultiplexEntryReject_entryNumbers),
        (u'rejectionDescriptions', _RequestMultiplexEntryReject_rejectionDescriptions),
        ])
    RequestMultiplexEntryReject._ext = []
    
    #-----< RequestMultiplexEntryRejectionDescriptions >-----#
    RequestMultiplexEntryRejectionDescriptions = SEQ(name=u'RequestMultiplexEntryRejectionDescriptions', mode=MODE_TYPE)
    _RequestMultiplexEntryRejectionDescriptions_multiplexTableEntryNumber = INT(name=u'multiplexTableEntryNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MultiplexTableEntryNumber')))
    _RequestMultiplexEntryRejectionDescriptions_cause = CHOICE(name=u'cause', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __RequestMultiplexEntryRejectionDescriptions_cause_unspecifiedCause = NULL(name=u'unspecifiedCause', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _RequestMultiplexEntryRejectionDescriptions_cause._cont = ASN1Dict([
        (u'unspecifiedCause', __RequestMultiplexEntryRejectionDescriptions_cause_unspecifiedCause),
        ])
    _RequestMultiplexEntryRejectionDescriptions_cause._ext = []
    RequestMultiplexEntryRejectionDescriptions._cont = ASN1Dict([
        (u'multiplexTableEntryNumber', _RequestMultiplexEntryRejectionDescriptions_multiplexTableEntryNumber),
        (u'cause', _RequestMultiplexEntryRejectionDescriptions_cause),
        ])
    RequestMultiplexEntryRejectionDescriptions._ext = []
    
    #-----< RequestMultiplexEntryRelease >-----#
    RequestMultiplexEntryRelease = SEQ(name=u'RequestMultiplexEntryRelease', mode=MODE_TYPE)
    _RequestMultiplexEntryRelease_entryNumbers = SET_OF(name=u'entryNumbers', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __RequestMultiplexEntryRelease_entryNumbers__item_ = INT(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MultiplexTableEntryNumber')))
    _RequestMultiplexEntryRelease_entryNumbers._cont = __RequestMultiplexEntryRelease_entryNumbers__item_
    _RequestMultiplexEntryRelease_entryNumbers._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=15)], ev=None, er=[])
    RequestMultiplexEntryRelease._cont = ASN1Dict([
        (u'entryNumbers', _RequestMultiplexEntryRelease_entryNumbers),
        ])
    RequestMultiplexEntryRelease._ext = []
    
    #-----< RequestMode >-----#
    RequestMode = SEQ(name=u'RequestMode', mode=MODE_TYPE)
    _RequestMode_sequenceNumber = INT(name=u'sequenceNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'SequenceNumber')))
    _RequestMode_requestedModes = SEQ_OF(name=u'requestedModes', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __RequestMode_requestedModes__item_ = SET_OF(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'ModeDescription')))
    _RequestMode_requestedModes._cont = __RequestMode_requestedModes__item_
    _RequestMode_requestedModes._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    RequestMode._cont = ASN1Dict([
        (u'sequenceNumber', _RequestMode_sequenceNumber),
        (u'requestedModes', _RequestMode_requestedModes),
        ])
    RequestMode._ext = []
    
    #-----< RequestModeAck >-----#
    RequestModeAck = SEQ(name=u'RequestModeAck', mode=MODE_TYPE)
    _RequestModeAck_sequenceNumber = INT(name=u'sequenceNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'SequenceNumber')))
    _RequestModeAck_response = CHOICE(name=u'response', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __RequestModeAck_response_willTransmitMostPreferredMode = NULL(name=u'willTransmitMostPreferredMode', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __RequestModeAck_response_willTransmitLessPreferredMode = NULL(name=u'willTransmitLessPreferredMode', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _RequestModeAck_response._cont = ASN1Dict([
        (u'willTransmitMostPreferredMode', __RequestModeAck_response_willTransmitMostPreferredMode),
        (u'willTransmitLessPreferredMode', __RequestModeAck_response_willTransmitLessPreferredMode),
        ])
    _RequestModeAck_response._ext = []
    RequestModeAck._cont = ASN1Dict([
        (u'sequenceNumber', _RequestModeAck_sequenceNumber),
        (u'response', _RequestModeAck_response),
        ])
    RequestModeAck._ext = []
    
    #-----< RequestModeReject >-----#
    RequestModeReject = SEQ(name=u'RequestModeReject', mode=MODE_TYPE)
    _RequestModeReject_sequenceNumber = INT(name=u'sequenceNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'SequenceNumber')))
    _RequestModeReject_cause = CHOICE(name=u'cause', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __RequestModeReject_cause_modeUnavailable = NULL(name=u'modeUnavailable', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __RequestModeReject_cause_multipointConstraint = NULL(name=u'multipointConstraint', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __RequestModeReject_cause_requestDenied = NULL(name=u'requestDenied', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _RequestModeReject_cause._cont = ASN1Dict([
        (u'modeUnavailable', __RequestModeReject_cause_modeUnavailable),
        (u'multipointConstraint', __RequestModeReject_cause_multipointConstraint),
        (u'requestDenied', __RequestModeReject_cause_requestDenied),
        ])
    _RequestModeReject_cause._ext = []
    RequestModeReject._cont = ASN1Dict([
        (u'sequenceNumber', _RequestModeReject_sequenceNumber),
        (u'cause', _RequestModeReject_cause),
        ])
    RequestModeReject._ext = []
    
    #-----< RequestModeRelease >-----#
    RequestModeRelease = SEQ(name=u'RequestModeRelease', mode=MODE_TYPE)
    RequestModeRelease._cont = ASN1Dict([
        ])
    RequestModeRelease._ext = []
    
    #-----< ModeDescription >-----#
    ModeDescription = SET_OF(name=u'ModeDescription', mode=MODE_TYPE)
    _ModeDescription__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'ModeElement')))
    ModeDescription._cont = _ModeDescription__item_
    ModeDescription._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    
    #-----< ModeElementType >-----#
    ModeElementType = CHOICE(name=u'ModeElementType', mode=MODE_TYPE)
    _ModeElementType_nonStandard = SEQ(name=u'nonStandard', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')))
    _ModeElementType_videoMode = CHOICE(name=u'videoMode', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'VideoMode')))
    _ModeElementType_audioMode = CHOICE(name=u'audioMode', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'AudioMode')))
    _ModeElementType_dataMode = SEQ(name=u'dataMode', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DataMode')))
    _ModeElementType_encryptionMode = CHOICE(name=u'encryptionMode', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'EncryptionMode')))
    _ModeElementType_h235Mode = SEQ(name=u'h235Mode', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H235Mode')))
    _ModeElementType_multiplexedStreamMode = SEQ(name=u'multiplexedStreamMode', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MultiplexedStreamParameter')))
    _ModeElementType_redundancyEncodingDTMode = SEQ(name=u'redundancyEncodingDTMode', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'RedundancyEncodingDTMode')))
    _ModeElementType_multiplePayloadStreamMode = SEQ(name=u'multiplePayloadStreamMode', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MultiplePayloadStreamMode')))
    _ModeElementType_depFecMode = CHOICE(name=u'depFecMode', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DepFECMode')))
    _ModeElementType_fecMode = SEQ(name=u'fecMode', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'FECMode')))
    ModeElementType._cont = ASN1Dict([
        (u'nonStandard', _ModeElementType_nonStandard),
        (u'videoMode', _ModeElementType_videoMode),
        (u'audioMode', _ModeElementType_audioMode),
        (u'dataMode', _ModeElementType_dataMode),
        (u'encryptionMode', _ModeElementType_encryptionMode),
        (u'h235Mode', _ModeElementType_h235Mode),
        (u'multiplexedStreamMode', _ModeElementType_multiplexedStreamMode),
        (u'redundancyEncodingDTMode', _ModeElementType_redundancyEncodingDTMode),
        (u'multiplePayloadStreamMode', _ModeElementType_multiplePayloadStreamMode),
        (u'depFecMode', _ModeElementType_depFecMode),
        (u'fecMode', _ModeElementType_fecMode),
        ])
    ModeElementType._ext = [u'h235Mode', u'multiplexedStreamMode', u'redundancyEncodingDTMode', u'multiplePayloadStreamMode', u'depFecMode', u'fecMode']
    
    #-----< ModeElement >-----#
    ModeElement = SEQ(name=u'ModeElement', mode=MODE_TYPE)
    _ModeElement_type = CHOICE(name=u'type', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'ModeElementType')))
    _ModeElement_h223ModeParameters = SEQ(name=u'h223ModeParameters', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H223ModeParameters')), opt=True)
    _ModeElement_v76ModeParameters = CHOICE(name=u'v76ModeParameters', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'V76ModeParameters')), opt=True)
    _ModeElement_h2250ModeParameters = SEQ(name=u'h2250ModeParameters', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H2250ModeParameters')), opt=True)
    _ModeElement_genericModeParameters = SEQ(name=u'genericModeParameters', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'GenericCapability')), opt=True)
    _ModeElement_multiplexedStreamModeParameters = SEQ(name=u'multiplexedStreamModeParameters', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MultiplexedStreamModeParameters')), opt=True)
    _ModeElement_logicalChannelNumber = INT(name=u'logicalChannelNumber', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelNumber')), opt=True)
    ModeElement._cont = ASN1Dict([
        (u'type', _ModeElement_type),
        (u'h223ModeParameters', _ModeElement_h223ModeParameters),
        (u'v76ModeParameters', _ModeElement_v76ModeParameters),
        (u'h2250ModeParameters', _ModeElement_h2250ModeParameters),
        (u'genericModeParameters', _ModeElement_genericModeParameters),
        (u'multiplexedStreamModeParameters', _ModeElement_multiplexedStreamModeParameters),
        (u'logicalChannelNumber', _ModeElement_logicalChannelNumber),
        ])
    ModeElement._ext = [u'v76ModeParameters', u'h2250ModeParameters', u'genericModeParameters', u'multiplexedStreamModeParameters', u'logicalChannelNumber']
    
    #-----< H235Mode >-----#
    H235Mode = SEQ(name=u'H235Mode', mode=MODE_TYPE)
    _H235Mode_encryptionAuthenticationAndIntegrity = SEQ(name=u'encryptionAuthenticationAndIntegrity', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'EncryptionAuthenticationAndIntegrity')))
    _H235Mode_mediaMode = CHOICE(name=u'mediaMode', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __H235Mode_mediaMode_nonStandard = SEQ(name=u'nonStandard', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')))
    __H235Mode_mediaMode_videoMode = CHOICE(name=u'videoMode', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'VideoMode')))
    __H235Mode_mediaMode_audioMode = CHOICE(name=u'audioMode', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'AudioMode')))
    __H235Mode_mediaMode_dataMode = SEQ(name=u'dataMode', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DataMode')))
    _H235Mode_mediaMode._cont = ASN1Dict([
        (u'nonStandard', __H235Mode_mediaMode_nonStandard),
        (u'videoMode', __H235Mode_mediaMode_videoMode),
        (u'audioMode', __H235Mode_mediaMode_audioMode),
        (u'dataMode', __H235Mode_mediaMode_dataMode),
        ])
    _H235Mode_mediaMode._ext = []
    H235Mode._cont = ASN1Dict([
        (u'encryptionAuthenticationAndIntegrity', _H235Mode_encryptionAuthenticationAndIntegrity),
        (u'mediaMode', _H235Mode_mediaMode),
        ])
    H235Mode._ext = []
    
    #-----< MultiplexedStreamModeParameters >-----#
    MultiplexedStreamModeParameters = SEQ(name=u'MultiplexedStreamModeParameters', mode=MODE_TYPE)
    _MultiplexedStreamModeParameters_logicalChannelNumber = INT(name=u'logicalChannelNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelNumber')))
    MultiplexedStreamModeParameters._cont = ASN1Dict([
        (u'logicalChannelNumber', _MultiplexedStreamModeParameters_logicalChannelNumber),
        ])
    MultiplexedStreamModeParameters._ext = []
    
    #-----< RedundancyEncodingDTMode >-----#
    RedundancyEncodingDTMode = SEQ(name=u'RedundancyEncodingDTMode', mode=MODE_TYPE)
    _RedundancyEncodingDTMode_redundancyEncodingMethod = CHOICE(name=u'redundancyEncodingMethod', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'RedundancyEncodingMethod')))
    _RedundancyEncodingDTMode_primary = SEQ(name=u'primary', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'RedundancyEncodingDTModeElement')))
    _RedundancyEncodingDTMode_secondary = SEQ_OF(name=u'secondary', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __RedundancyEncodingDTMode_secondary__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'RedundancyEncodingDTModeElement')))
    _RedundancyEncodingDTMode_secondary._cont = __RedundancyEncodingDTMode_secondary__item_
    RedundancyEncodingDTMode._cont = ASN1Dict([
        (u'redundancyEncodingMethod', _RedundancyEncodingDTMode_redundancyEncodingMethod),
        (u'primary', _RedundancyEncodingDTMode_primary),
        (u'secondary', _RedundancyEncodingDTMode_secondary),
        ])
    RedundancyEncodingDTMode._ext = []
    
    #-----< RedundancyEncodingDTModeElement >-----#
    RedundancyEncodingDTModeElement = SEQ(name=u'RedundancyEncodingDTModeElement', mode=MODE_TYPE)
    _RedundancyEncodingDTModeElement_type = CHOICE(name=u'type', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __RedundancyEncodingDTModeElement_type_nonStandard = SEQ(name=u'nonStandard', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')))
    __RedundancyEncodingDTModeElement_type_videoMode = CHOICE(name=u'videoMode', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'VideoMode')))
    __RedundancyEncodingDTModeElement_type_audioMode = CHOICE(name=u'audioMode', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'AudioMode')))
    __RedundancyEncodingDTModeElement_type_dataMode = SEQ(name=u'dataMode', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DataMode')))
    __RedundancyEncodingDTModeElement_type_encryptionMode = CHOICE(name=u'encryptionMode', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'EncryptionMode')))
    __RedundancyEncodingDTModeElement_type_h235Mode = SEQ(name=u'h235Mode', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H235Mode')))
    __RedundancyEncodingDTModeElement_type_fecMode = SEQ(name=u'fecMode', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'FECMode')))
    _RedundancyEncodingDTModeElement_type._cont = ASN1Dict([
        (u'nonStandard', __RedundancyEncodingDTModeElement_type_nonStandard),
        (u'videoMode', __RedundancyEncodingDTModeElement_type_videoMode),
        (u'audioMode', __RedundancyEncodingDTModeElement_type_audioMode),
        (u'dataMode', __RedundancyEncodingDTModeElement_type_dataMode),
        (u'encryptionMode', __RedundancyEncodingDTModeElement_type_encryptionMode),
        (u'h235Mode', __RedundancyEncodingDTModeElement_type_h235Mode),
        (u'fecMode', __RedundancyEncodingDTModeElement_type_fecMode),
        ])
    _RedundancyEncodingDTModeElement_type._ext = [u'fecMode']
    RedundancyEncodingDTModeElement._cont = ASN1Dict([
        (u'type', _RedundancyEncodingDTModeElement_type),
        ])
    RedundancyEncodingDTModeElement._ext = []
    
    #-----< MultiplePayloadStreamMode >-----#
    MultiplePayloadStreamMode = SEQ(name=u'MultiplePayloadStreamMode', mode=MODE_TYPE)
    _MultiplePayloadStreamMode_elements = SEQ_OF(name=u'elements', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MultiplePayloadStreamMode_elements__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MultiplePayloadStreamElementMode')))
    _MultiplePayloadStreamMode_elements._cont = __MultiplePayloadStreamMode_elements__item_
    MultiplePayloadStreamMode._cont = ASN1Dict([
        (u'elements', _MultiplePayloadStreamMode_elements),
        ])
    MultiplePayloadStreamMode._ext = []
    
    #-----< MultiplePayloadStreamElementMode >-----#
    MultiplePayloadStreamElementMode = SEQ(name=u'MultiplePayloadStreamElementMode', mode=MODE_TYPE)
    _MultiplePayloadStreamElementMode_type = CHOICE(name=u'type', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'ModeElementType')))
    MultiplePayloadStreamElementMode._cont = ASN1Dict([
        (u'type', _MultiplePayloadStreamElementMode_type),
        ])
    MultiplePayloadStreamElementMode._ext = []
    
    #-----< DepFECMode >-----#
    DepFECMode = CHOICE(name=u'DepFECMode', mode=MODE_TYPE)
    _DepFECMode_rfc2733Mode = SEQ(name=u'rfc2733Mode', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __DepFECMode_rfc2733Mode_mode = CHOICE(name=u'mode', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ___DepFECMode_rfc2733Mode_mode_redundancyEncoding = NULL(name=u'redundancyEncoding', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___DepFECMode_rfc2733Mode_mode_separateStream = CHOICE(name=u'separateStream', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ____DepFECMode_rfc2733Mode_mode_separateStream_differentPort = SEQ(name=u'differentPort', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _____DepFECMode_rfc2733Mode_mode_separateStream_differentPort_protectedSessionID = INT(name=u'protectedSessionID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _____DepFECMode_rfc2733Mode_mode_separateStream_differentPort_protectedSessionID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=255)], ev=None, er=[])
    _____DepFECMode_rfc2733Mode_mode_separateStream_differentPort_protectedPayloadType = INT(name=u'protectedPayloadType', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _____DepFECMode_rfc2733Mode_mode_separateStream_differentPort_protectedPayloadType._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    ____DepFECMode_rfc2733Mode_mode_separateStream_differentPort._cont = ASN1Dict([
        (u'protectedSessionID', _____DepFECMode_rfc2733Mode_mode_separateStream_differentPort_protectedSessionID),
        (u'protectedPayloadType', _____DepFECMode_rfc2733Mode_mode_separateStream_differentPort_protectedPayloadType),
        ])
    ____DepFECMode_rfc2733Mode_mode_separateStream_differentPort._ext = []
    ____DepFECMode_rfc2733Mode_mode_separateStream_samePort = SEQ(name=u'samePort', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _____DepFECMode_rfc2733Mode_mode_separateStream_samePort_protectedType = CHOICE(name=u'protectedType', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'ModeElementType')))
    ____DepFECMode_rfc2733Mode_mode_separateStream_samePort._cont = ASN1Dict([
        (u'protectedType', _____DepFECMode_rfc2733Mode_mode_separateStream_samePort_protectedType),
        ])
    ____DepFECMode_rfc2733Mode_mode_separateStream_samePort._ext = []
    ___DepFECMode_rfc2733Mode_mode_separateStream._cont = ASN1Dict([
        (u'differentPort', ____DepFECMode_rfc2733Mode_mode_separateStream_differentPort),
        (u'samePort', ____DepFECMode_rfc2733Mode_mode_separateStream_samePort),
        ])
    ___DepFECMode_rfc2733Mode_mode_separateStream._ext = []
    __DepFECMode_rfc2733Mode_mode._cont = ASN1Dict([
        (u'redundancyEncoding', ___DepFECMode_rfc2733Mode_mode_redundancyEncoding),
        (u'separateStream', ___DepFECMode_rfc2733Mode_mode_separateStream),
        ])
    __DepFECMode_rfc2733Mode_mode._ext = []
    _DepFECMode_rfc2733Mode._cont = ASN1Dict([
        (u'mode', __DepFECMode_rfc2733Mode_mode),
        ])
    _DepFECMode_rfc2733Mode._ext = []
    DepFECMode._cont = ASN1Dict([
        (u'rfc2733Mode', _DepFECMode_rfc2733Mode),
        ])
    DepFECMode._ext = []
    
    #-----< FECMode >-----#
    FECMode = SEQ(name=u'FECMode', mode=MODE_TYPE)
    _FECMode_protectedElement = CHOICE(name=u'protectedElement', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'ModeElementType')))
    _FECMode_fecScheme = OID(name=u'fecScheme', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _FECMode_rfc2733Format = CHOICE(name=u'rfc2733Format', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __FECMode_rfc2733Format_rfc2733rfc2198 = INT(name=u'rfc2733rfc2198', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MaxRedundancy')))
    __FECMode_rfc2733Format_rfc2733sameport = INT(name=u'rfc2733sameport', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MaxRedundancy')))
    __FECMode_rfc2733Format_rfc2733diffport = INT(name=u'rfc2733diffport', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MaxRedundancy')))
    _FECMode_rfc2733Format._cont = ASN1Dict([
        (u'rfc2733rfc2198', __FECMode_rfc2733Format_rfc2733rfc2198),
        (u'rfc2733sameport', __FECMode_rfc2733Format_rfc2733sameport),
        (u'rfc2733diffport', __FECMode_rfc2733Format_rfc2733diffport),
        ])
    _FECMode_rfc2733Format._ext = None
    FECMode._cont = ASN1Dict([
        (u'protectedElement', _FECMode_protectedElement),
        (u'fecScheme', _FECMode_fecScheme),
        (u'rfc2733Format', _FECMode_rfc2733Format),
        ])
    FECMode._ext = []
    
    #-----< H223ModeParameters >-----#
    H223ModeParameters = SEQ(name=u'H223ModeParameters', mode=MODE_TYPE)
    _H223ModeParameters_adaptationLayerType = CHOICE(name=u'adaptationLayerType', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __H223ModeParameters_adaptationLayerType_nonStandard = SEQ(name=u'nonStandard', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')))
    __H223ModeParameters_adaptationLayerType_al1Framed = NULL(name=u'al1Framed', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H223ModeParameters_adaptationLayerType_al1NotFramed = NULL(name=u'al1NotFramed', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H223ModeParameters_adaptationLayerType_al2WithoutSequenceNumbers = NULL(name=u'al2WithoutSequenceNumbers', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H223ModeParameters_adaptationLayerType_al2WithSequenceNumbers = NULL(name=u'al2WithSequenceNumbers', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H223ModeParameters_adaptationLayerType_al3 = SEQ(name=u'al3', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___H223ModeParameters_adaptationLayerType_al3_controlFieldOctets = INT(name=u'controlFieldOctets', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___H223ModeParameters_adaptationLayerType_al3_controlFieldOctets._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=2)], ev=None, er=[])
    ___H223ModeParameters_adaptationLayerType_al3_sendBufferSize = INT(name=u'sendBufferSize', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___H223ModeParameters_adaptationLayerType_al3_sendBufferSize._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=16777215)], ev=None, er=[])
    __H223ModeParameters_adaptationLayerType_al3._cont = ASN1Dict([
        (u'controlFieldOctets', ___H223ModeParameters_adaptationLayerType_al3_controlFieldOctets),
        (u'sendBufferSize', ___H223ModeParameters_adaptationLayerType_al3_sendBufferSize),
        ])
    __H223ModeParameters_adaptationLayerType_al3._ext = None
    __H223ModeParameters_adaptationLayerType_al1M = SEQ(name=u'al1M', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H223AL1MParameters')))
    __H223ModeParameters_adaptationLayerType_al2M = SEQ(name=u'al2M', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H223AL2MParameters')))
    __H223ModeParameters_adaptationLayerType_al3M = SEQ(name=u'al3M', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H223AL3MParameters')))
    _H223ModeParameters_adaptationLayerType._cont = ASN1Dict([
        (u'nonStandard', __H223ModeParameters_adaptationLayerType_nonStandard),
        (u'al1Framed', __H223ModeParameters_adaptationLayerType_al1Framed),
        (u'al1NotFramed', __H223ModeParameters_adaptationLayerType_al1NotFramed),
        (u'al2WithoutSequenceNumbers', __H223ModeParameters_adaptationLayerType_al2WithoutSequenceNumbers),
        (u'al2WithSequenceNumbers', __H223ModeParameters_adaptationLayerType_al2WithSequenceNumbers),
        (u'al3', __H223ModeParameters_adaptationLayerType_al3),
        (u'al1M', __H223ModeParameters_adaptationLayerType_al1M),
        (u'al2M', __H223ModeParameters_adaptationLayerType_al2M),
        (u'al3M', __H223ModeParameters_adaptationLayerType_al3M),
        ])
    _H223ModeParameters_adaptationLayerType._ext = [u'al1M', u'al2M', u'al3M']
    _H223ModeParameters_segmentableFlag = BOOL(name=u'segmentableFlag', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    H223ModeParameters._cont = ASN1Dict([
        (u'adaptationLayerType', _H223ModeParameters_adaptationLayerType),
        (u'segmentableFlag', _H223ModeParameters_segmentableFlag),
        ])
    H223ModeParameters._ext = []
    
    #-----< V76ModeParameters >-----#
    V76ModeParameters = CHOICE(name=u'V76ModeParameters', mode=MODE_TYPE)
    _V76ModeParameters_suspendResumewAddress = NULL(name=u'suspendResumewAddress', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _V76ModeParameters_suspendResumewoAddress = NULL(name=u'suspendResumewoAddress', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    V76ModeParameters._cont = ASN1Dict([
        (u'suspendResumewAddress', _V76ModeParameters_suspendResumewAddress),
        (u'suspendResumewoAddress', _V76ModeParameters_suspendResumewoAddress),
        ])
    V76ModeParameters._ext = []
    
    #-----< H2250ModeParameters >-----#
    H2250ModeParameters = SEQ(name=u'H2250ModeParameters', mode=MODE_TYPE)
    _H2250ModeParameters_redundancyEncodingMode = SEQ(name=u'redundancyEncodingMode', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'RedundancyEncodingMode')), opt=True)
    H2250ModeParameters._cont = ASN1Dict([
        (u'redundancyEncodingMode', _H2250ModeParameters_redundancyEncodingMode),
        ])
    H2250ModeParameters._ext = []
    
    #-----< RedundancyEncodingMode >-----#
    RedundancyEncodingMode = SEQ(name=u'RedundancyEncodingMode', mode=MODE_TYPE)
    _RedundancyEncodingMode_redundancyEncodingMethod = CHOICE(name=u'redundancyEncodingMethod', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'RedundancyEncodingMethod')))
    _RedundancyEncodingMode_secondaryEncoding = CHOICE(name=u'secondaryEncoding', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __RedundancyEncodingMode_secondaryEncoding_nonStandard = SEQ(name=u'nonStandard', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')))
    __RedundancyEncodingMode_secondaryEncoding_audioData = CHOICE(name=u'audioData', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'AudioMode')))
    _RedundancyEncodingMode_secondaryEncoding._cont = ASN1Dict([
        (u'nonStandard', __RedundancyEncodingMode_secondaryEncoding_nonStandard),
        (u'audioData', __RedundancyEncodingMode_secondaryEncoding_audioData),
        ])
    _RedundancyEncodingMode_secondaryEncoding._ext = []
    RedundancyEncodingMode._cont = ASN1Dict([
        (u'redundancyEncodingMethod', _RedundancyEncodingMode_redundancyEncodingMethod),
        (u'secondaryEncoding', _RedundancyEncodingMode_secondaryEncoding),
        ])
    RedundancyEncodingMode._ext = []
    
    #-----< VideoMode >-----#
    VideoMode = CHOICE(name=u'VideoMode', mode=MODE_TYPE)
    _VideoMode_nonStandard = SEQ(name=u'nonStandard', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')))
    _VideoMode_h261VideoMode = SEQ(name=u'h261VideoMode', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H261VideoMode')))
    _VideoMode_h262VideoMode = SEQ(name=u'h262VideoMode', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H262VideoMode')))
    _VideoMode_h263VideoMode = SEQ(name=u'h263VideoMode', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H263VideoMode')))
    _VideoMode_is11172VideoMode = SEQ(name=u'is11172VideoMode', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'IS11172VideoMode')))
    _VideoMode_genericVideoMode = SEQ(name=u'genericVideoMode', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'GenericCapability')))
    VideoMode._cont = ASN1Dict([
        (u'nonStandard', _VideoMode_nonStandard),
        (u'h261VideoMode', _VideoMode_h261VideoMode),
        (u'h262VideoMode', _VideoMode_h262VideoMode),
        (u'h263VideoMode', _VideoMode_h263VideoMode),
        (u'is11172VideoMode', _VideoMode_is11172VideoMode),
        (u'genericVideoMode', _VideoMode_genericVideoMode),
        ])
    VideoMode._ext = [u'genericVideoMode']
    
    #-----< H261VideoMode >-----#
    H261VideoMode = SEQ(name=u'H261VideoMode', mode=MODE_TYPE)
    _H261VideoMode_resolution = CHOICE(name=u'resolution', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __H261VideoMode_resolution_qcif = NULL(name=u'qcif', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H261VideoMode_resolution_cif = NULL(name=u'cif', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H261VideoMode_resolution._cont = ASN1Dict([
        (u'qcif', __H261VideoMode_resolution_qcif),
        (u'cif', __H261VideoMode_resolution_cif),
        ])
    _H261VideoMode_resolution._ext = None
    _H261VideoMode_bitRate = INT(name=u'bitRate', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H261VideoMode_bitRate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=19200)], ev=None, er=[])
    _H261VideoMode_stillImageTransmission = BOOL(name=u'stillImageTransmission', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    H261VideoMode._cont = ASN1Dict([
        (u'resolution', _H261VideoMode_resolution),
        (u'bitRate', _H261VideoMode_bitRate),
        (u'stillImageTransmission', _H261VideoMode_stillImageTransmission),
        ])
    H261VideoMode._ext = []
    
    #-----< H262VideoMode >-----#
    H262VideoMode = SEQ(name=u'H262VideoMode', mode=MODE_TYPE)
    _H262VideoMode_profileAndLevel = CHOICE(name=u'profileAndLevel', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __H262VideoMode_profileAndLevel_profileAndLevel_SPatML = NULL(name=u'profileAndLevel-SPatML', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H262VideoMode_profileAndLevel_profileAndLevel_MPatLL = NULL(name=u'profileAndLevel-MPatLL', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H262VideoMode_profileAndLevel_profileAndLevel_MPatML = NULL(name=u'profileAndLevel-MPatML', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H262VideoMode_profileAndLevel_profileAndLevel_MPatH_14 = NULL(name=u'profileAndLevel-MPatH-14', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H262VideoMode_profileAndLevel_profileAndLevel_MPatHL = NULL(name=u'profileAndLevel-MPatHL', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H262VideoMode_profileAndLevel_profileAndLevel_SNRatLL = NULL(name=u'profileAndLevel-SNRatLL', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H262VideoMode_profileAndLevel_profileAndLevel_SNRatML = NULL(name=u'profileAndLevel-SNRatML', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H262VideoMode_profileAndLevel_profileAndLevel_SpatialatH_14 = NULL(name=u'profileAndLevel-SpatialatH-14', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H262VideoMode_profileAndLevel_profileAndLevel_HPatML = NULL(name=u'profileAndLevel-HPatML', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H262VideoMode_profileAndLevel_profileAndLevel_HPatH_14 = NULL(name=u'profileAndLevel-HPatH-14', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H262VideoMode_profileAndLevel_profileAndLevel_HPatHL = NULL(name=u'profileAndLevel-HPatHL', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H262VideoMode_profileAndLevel._cont = ASN1Dict([
        (u'profileAndLevel-SPatML', __H262VideoMode_profileAndLevel_profileAndLevel_SPatML),
        (u'profileAndLevel-MPatLL', __H262VideoMode_profileAndLevel_profileAndLevel_MPatLL),
        (u'profileAndLevel-MPatML', __H262VideoMode_profileAndLevel_profileAndLevel_MPatML),
        (u'profileAndLevel-MPatH-14', __H262VideoMode_profileAndLevel_profileAndLevel_MPatH_14),
        (u'profileAndLevel-MPatHL', __H262VideoMode_profileAndLevel_profileAndLevel_MPatHL),
        (u'profileAndLevel-SNRatLL', __H262VideoMode_profileAndLevel_profileAndLevel_SNRatLL),
        (u'profileAndLevel-SNRatML', __H262VideoMode_profileAndLevel_profileAndLevel_SNRatML),
        (u'profileAndLevel-SpatialatH-14', __H262VideoMode_profileAndLevel_profileAndLevel_SpatialatH_14),
        (u'profileAndLevel-HPatML', __H262VideoMode_profileAndLevel_profileAndLevel_HPatML),
        (u'profileAndLevel-HPatH-14', __H262VideoMode_profileAndLevel_profileAndLevel_HPatH_14),
        (u'profileAndLevel-HPatHL', __H262VideoMode_profileAndLevel_profileAndLevel_HPatHL),
        ])
    _H262VideoMode_profileAndLevel._ext = []
    _H262VideoMode_videoBitRate = INT(name=u'videoBitRate', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _H262VideoMode_videoBitRate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=1073741823)], ev=None, er=[])
    _H262VideoMode_vbvBufferSize = INT(name=u'vbvBufferSize', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _H262VideoMode_vbvBufferSize._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=262143)], ev=None, er=[])
    _H262VideoMode_samplesPerLine = INT(name=u'samplesPerLine', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _H262VideoMode_samplesPerLine._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=16383)], ev=None, er=[])
    _H262VideoMode_linesPerFrame = INT(name=u'linesPerFrame', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _H262VideoMode_linesPerFrame._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=16383)], ev=None, er=[])
    _H262VideoMode_framesPerSecond = INT(name=u'framesPerSecond', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _H262VideoMode_framesPerSecond._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=15)], ev=None, er=[])
    _H262VideoMode_luminanceSampleRate = INT(name=u'luminanceSampleRate', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _H262VideoMode_luminanceSampleRate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4294967295)], ev=None, er=[])
    H262VideoMode._cont = ASN1Dict([
        (u'profileAndLevel', _H262VideoMode_profileAndLevel),
        (u'videoBitRate', _H262VideoMode_videoBitRate),
        (u'vbvBufferSize', _H262VideoMode_vbvBufferSize),
        (u'samplesPerLine', _H262VideoMode_samplesPerLine),
        (u'linesPerFrame', _H262VideoMode_linesPerFrame),
        (u'framesPerSecond', _H262VideoMode_framesPerSecond),
        (u'luminanceSampleRate', _H262VideoMode_luminanceSampleRate),
        ])
    H262VideoMode._ext = []
    
    #-----< H263VideoMode >-----#
    H263VideoMode = SEQ(name=u'H263VideoMode', mode=MODE_TYPE)
    _H263VideoMode_resolution = CHOICE(name=u'resolution', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __H263VideoMode_resolution_sqcif = NULL(name=u'sqcif', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H263VideoMode_resolution_qcif = NULL(name=u'qcif', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H263VideoMode_resolution_cif = NULL(name=u'cif', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H263VideoMode_resolution_cif4 = NULL(name=u'cif4', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H263VideoMode_resolution_cif16 = NULL(name=u'cif16', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H263VideoMode_resolution_custom = NULL(name=u'custom', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263VideoMode_resolution._cont = ASN1Dict([
        (u'sqcif', __H263VideoMode_resolution_sqcif),
        (u'qcif', __H263VideoMode_resolution_qcif),
        (u'cif', __H263VideoMode_resolution_cif),
        (u'cif4', __H263VideoMode_resolution_cif4),
        (u'cif16', __H263VideoMode_resolution_cif16),
        (u'custom', __H263VideoMode_resolution_custom),
        ])
    _H263VideoMode_resolution._ext = [u'custom']
    _H263VideoMode_bitRate = INT(name=u'bitRate', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263VideoMode_bitRate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=19200)], ev=None, er=[])
    _H263VideoMode_unrestrictedVector = BOOL(name=u'unrestrictedVector', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263VideoMode_arithmeticCoding = BOOL(name=u'arithmeticCoding', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263VideoMode_advancedPrediction = BOOL(name=u'advancedPrediction', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263VideoMode_pbFrames = BOOL(name=u'pbFrames', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263VideoMode_errorCompensation = BOOL(name=u'errorCompensation', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H263VideoMode_enhancementLayerInfo = SEQ(name=u'enhancementLayerInfo', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'EnhancementLayerInfo')), opt=True)
    _H263VideoMode_h263Options = SEQ(name=u'h263Options', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'H263Options')), opt=True)
    H263VideoMode._cont = ASN1Dict([
        (u'resolution', _H263VideoMode_resolution),
        (u'bitRate', _H263VideoMode_bitRate),
        (u'unrestrictedVector', _H263VideoMode_unrestrictedVector),
        (u'arithmeticCoding', _H263VideoMode_arithmeticCoding),
        (u'advancedPrediction', _H263VideoMode_advancedPrediction),
        (u'pbFrames', _H263VideoMode_pbFrames),
        (u'errorCompensation', _H263VideoMode_errorCompensation),
        (u'enhancementLayerInfo', _H263VideoMode_enhancementLayerInfo),
        (u'h263Options', _H263VideoMode_h263Options),
        ])
    H263VideoMode._ext = [u'errorCompensation', u'enhancementLayerInfo', u'h263Options']
    
    #-----< IS11172VideoMode >-----#
    IS11172VideoMode = SEQ(name=u'IS11172VideoMode', mode=MODE_TYPE)
    _IS11172VideoMode_constrainedBitstream = BOOL(name=u'constrainedBitstream', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IS11172VideoMode_videoBitRate = INT(name=u'videoBitRate', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _IS11172VideoMode_videoBitRate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=1073741823)], ev=None, er=[])
    _IS11172VideoMode_vbvBufferSize = INT(name=u'vbvBufferSize', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _IS11172VideoMode_vbvBufferSize._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=262143)], ev=None, er=[])
    _IS11172VideoMode_samplesPerLine = INT(name=u'samplesPerLine', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _IS11172VideoMode_samplesPerLine._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=16383)], ev=None, er=[])
    _IS11172VideoMode_linesPerFrame = INT(name=u'linesPerFrame', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _IS11172VideoMode_linesPerFrame._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=16383)], ev=None, er=[])
    _IS11172VideoMode_pictureRate = INT(name=u'pictureRate', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _IS11172VideoMode_pictureRate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=15)], ev=None, er=[])
    _IS11172VideoMode_luminanceSampleRate = INT(name=u'luminanceSampleRate', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _IS11172VideoMode_luminanceSampleRate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4294967295)], ev=None, er=[])
    IS11172VideoMode._cont = ASN1Dict([
        (u'constrainedBitstream', _IS11172VideoMode_constrainedBitstream),
        (u'videoBitRate', _IS11172VideoMode_videoBitRate),
        (u'vbvBufferSize', _IS11172VideoMode_vbvBufferSize),
        (u'samplesPerLine', _IS11172VideoMode_samplesPerLine),
        (u'linesPerFrame', _IS11172VideoMode_linesPerFrame),
        (u'pictureRate', _IS11172VideoMode_pictureRate),
        (u'luminanceSampleRate', _IS11172VideoMode_luminanceSampleRate),
        ])
    IS11172VideoMode._ext = []
    
    #-----< AudioMode >-----#
    AudioMode = CHOICE(name=u'AudioMode', mode=MODE_TYPE)
    _AudioMode_nonStandard = SEQ(name=u'nonStandard', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')))
    _AudioMode_g711Alaw64k = NULL(name=u'g711Alaw64k', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AudioMode_g711Alaw56k = NULL(name=u'g711Alaw56k', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AudioMode_g711Ulaw64k = NULL(name=u'g711Ulaw64k', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AudioMode_g711Ulaw56k = NULL(name=u'g711Ulaw56k', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AudioMode_g722_64k = NULL(name=u'g722-64k', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AudioMode_g722_56k = NULL(name=u'g722-56k', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AudioMode_g722_48k = NULL(name=u'g722-48k', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AudioMode_g728 = NULL(name=u'g728', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AudioMode_g729 = NULL(name=u'g729', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AudioMode_g729AnnexA = NULL(name=u'g729AnnexA', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AudioMode_g7231 = CHOICE(name=u'g7231', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __AudioMode_g7231_noSilenceSuppressionLowRate = NULL(name=u'noSilenceSuppressionLowRate', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __AudioMode_g7231_noSilenceSuppressionHighRate = NULL(name=u'noSilenceSuppressionHighRate', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __AudioMode_g7231_silenceSuppressionLowRate = NULL(name=u'silenceSuppressionLowRate', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __AudioMode_g7231_silenceSuppressionHighRate = NULL(name=u'silenceSuppressionHighRate', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AudioMode_g7231._cont = ASN1Dict([
        (u'noSilenceSuppressionLowRate', __AudioMode_g7231_noSilenceSuppressionLowRate),
        (u'noSilenceSuppressionHighRate', __AudioMode_g7231_noSilenceSuppressionHighRate),
        (u'silenceSuppressionLowRate', __AudioMode_g7231_silenceSuppressionLowRate),
        (u'silenceSuppressionHighRate', __AudioMode_g7231_silenceSuppressionHighRate),
        ])
    _AudioMode_g7231._ext = None
    _AudioMode_is11172AudioMode = SEQ(name=u'is11172AudioMode', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'IS11172AudioMode')))
    _AudioMode_is13818AudioMode = SEQ(name=u'is13818AudioMode', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'IS13818AudioMode')))
    _AudioMode_g729wAnnexB = INT(name=u'g729wAnnexB', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AudioMode_g729wAnnexB._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    _AudioMode_g729AnnexAwAnnexB = INT(name=u'g729AnnexAwAnnexB', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AudioMode_g729AnnexAwAnnexB._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    _AudioMode_g7231AnnexCMode = SEQ(name=u'g7231AnnexCMode', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'G7231AnnexCMode')))
    _AudioMode_gsmFullRate = SEQ(name=u'gsmFullRate', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'GSMAudioCapability')))
    _AudioMode_gsmHalfRate = SEQ(name=u'gsmHalfRate', mode=MODE_TYPE, tag=(18, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'GSMAudioCapability')))
    _AudioMode_gsmEnhancedFullRate = SEQ(name=u'gsmEnhancedFullRate', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'GSMAudioCapability')))
    _AudioMode_genericAudioMode = SEQ(name=u'genericAudioMode', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'GenericCapability')))
    _AudioMode_g729Extensions = SEQ(name=u'g729Extensions', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'G729Extensions')))
    _AudioMode_vbd = SEQ(name=u'vbd', mode=MODE_TYPE, tag=(22, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'VBDMode')))
    AudioMode._cont = ASN1Dict([
        (u'nonStandard', _AudioMode_nonStandard),
        (u'g711Alaw64k', _AudioMode_g711Alaw64k),
        (u'g711Alaw56k', _AudioMode_g711Alaw56k),
        (u'g711Ulaw64k', _AudioMode_g711Ulaw64k),
        (u'g711Ulaw56k', _AudioMode_g711Ulaw56k),
        (u'g722-64k', _AudioMode_g722_64k),
        (u'g722-56k', _AudioMode_g722_56k),
        (u'g722-48k', _AudioMode_g722_48k),
        (u'g728', _AudioMode_g728),
        (u'g729', _AudioMode_g729),
        (u'g729AnnexA', _AudioMode_g729AnnexA),
        (u'g7231', _AudioMode_g7231),
        (u'is11172AudioMode', _AudioMode_is11172AudioMode),
        (u'is13818AudioMode', _AudioMode_is13818AudioMode),
        (u'g729wAnnexB', _AudioMode_g729wAnnexB),
        (u'g729AnnexAwAnnexB', _AudioMode_g729AnnexAwAnnexB),
        (u'g7231AnnexCMode', _AudioMode_g7231AnnexCMode),
        (u'gsmFullRate', _AudioMode_gsmFullRate),
        (u'gsmHalfRate', _AudioMode_gsmHalfRate),
        (u'gsmEnhancedFullRate', _AudioMode_gsmEnhancedFullRate),
        (u'genericAudioMode', _AudioMode_genericAudioMode),
        (u'g729Extensions', _AudioMode_g729Extensions),
        (u'vbd', _AudioMode_vbd),
        ])
    AudioMode._ext = [u'g729wAnnexB', u'g729AnnexAwAnnexB', u'g7231AnnexCMode', u'gsmFullRate', u'gsmHalfRate', u'gsmEnhancedFullRate', u'genericAudioMode', u'g729Extensions', u'vbd']
    
    #-----< IS11172AudioMode >-----#
    IS11172AudioMode = SEQ(name=u'IS11172AudioMode', mode=MODE_TYPE)
    _IS11172AudioMode_audioLayer = CHOICE(name=u'audioLayer', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __IS11172AudioMode_audioLayer_audioLayer1 = NULL(name=u'audioLayer1', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __IS11172AudioMode_audioLayer_audioLayer2 = NULL(name=u'audioLayer2', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __IS11172AudioMode_audioLayer_audioLayer3 = NULL(name=u'audioLayer3', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IS11172AudioMode_audioLayer._cont = ASN1Dict([
        (u'audioLayer1', __IS11172AudioMode_audioLayer_audioLayer1),
        (u'audioLayer2', __IS11172AudioMode_audioLayer_audioLayer2),
        (u'audioLayer3', __IS11172AudioMode_audioLayer_audioLayer3),
        ])
    _IS11172AudioMode_audioLayer._ext = None
    _IS11172AudioMode_audioSampling = CHOICE(name=u'audioSampling', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __IS11172AudioMode_audioSampling_audioSampling32k = NULL(name=u'audioSampling32k', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __IS11172AudioMode_audioSampling_audioSampling44k1 = NULL(name=u'audioSampling44k1', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __IS11172AudioMode_audioSampling_audioSampling48k = NULL(name=u'audioSampling48k', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IS11172AudioMode_audioSampling._cont = ASN1Dict([
        (u'audioSampling32k', __IS11172AudioMode_audioSampling_audioSampling32k),
        (u'audioSampling44k1', __IS11172AudioMode_audioSampling_audioSampling44k1),
        (u'audioSampling48k', __IS11172AudioMode_audioSampling_audioSampling48k),
        ])
    _IS11172AudioMode_audioSampling._ext = None
    _IS11172AudioMode_multichannelType = CHOICE(name=u'multichannelType', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __IS11172AudioMode_multichannelType_singleChannel = NULL(name=u'singleChannel', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __IS11172AudioMode_multichannelType_twoChannelStereo = NULL(name=u'twoChannelStereo', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __IS11172AudioMode_multichannelType_twoChannelDual = NULL(name=u'twoChannelDual', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IS11172AudioMode_multichannelType._cont = ASN1Dict([
        (u'singleChannel', __IS11172AudioMode_multichannelType_singleChannel),
        (u'twoChannelStereo', __IS11172AudioMode_multichannelType_twoChannelStereo),
        (u'twoChannelDual', __IS11172AudioMode_multichannelType_twoChannelDual),
        ])
    _IS11172AudioMode_multichannelType._ext = None
    _IS11172AudioMode_bitRate = INT(name=u'bitRate', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IS11172AudioMode_bitRate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=448)], ev=None, er=[])
    IS11172AudioMode._cont = ASN1Dict([
        (u'audioLayer', _IS11172AudioMode_audioLayer),
        (u'audioSampling', _IS11172AudioMode_audioSampling),
        (u'multichannelType', _IS11172AudioMode_multichannelType),
        (u'bitRate', _IS11172AudioMode_bitRate),
        ])
    IS11172AudioMode._ext = []
    
    #-----< IS13818AudioMode >-----#
    IS13818AudioMode = SEQ(name=u'IS13818AudioMode', mode=MODE_TYPE)
    _IS13818AudioMode_audioLayer = CHOICE(name=u'audioLayer', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __IS13818AudioMode_audioLayer_audioLayer1 = NULL(name=u'audioLayer1', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __IS13818AudioMode_audioLayer_audioLayer2 = NULL(name=u'audioLayer2', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __IS13818AudioMode_audioLayer_audioLayer3 = NULL(name=u'audioLayer3', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IS13818AudioMode_audioLayer._cont = ASN1Dict([
        (u'audioLayer1', __IS13818AudioMode_audioLayer_audioLayer1),
        (u'audioLayer2', __IS13818AudioMode_audioLayer_audioLayer2),
        (u'audioLayer3', __IS13818AudioMode_audioLayer_audioLayer3),
        ])
    _IS13818AudioMode_audioLayer._ext = None
    _IS13818AudioMode_audioSampling = CHOICE(name=u'audioSampling', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __IS13818AudioMode_audioSampling_audioSampling16k = NULL(name=u'audioSampling16k', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __IS13818AudioMode_audioSampling_audioSampling22k05 = NULL(name=u'audioSampling22k05', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __IS13818AudioMode_audioSampling_audioSampling24k = NULL(name=u'audioSampling24k', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __IS13818AudioMode_audioSampling_audioSampling32k = NULL(name=u'audioSampling32k', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __IS13818AudioMode_audioSampling_audioSampling44k1 = NULL(name=u'audioSampling44k1', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __IS13818AudioMode_audioSampling_audioSampling48k = NULL(name=u'audioSampling48k', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IS13818AudioMode_audioSampling._cont = ASN1Dict([
        (u'audioSampling16k', __IS13818AudioMode_audioSampling_audioSampling16k),
        (u'audioSampling22k05', __IS13818AudioMode_audioSampling_audioSampling22k05),
        (u'audioSampling24k', __IS13818AudioMode_audioSampling_audioSampling24k),
        (u'audioSampling32k', __IS13818AudioMode_audioSampling_audioSampling32k),
        (u'audioSampling44k1', __IS13818AudioMode_audioSampling_audioSampling44k1),
        (u'audioSampling48k', __IS13818AudioMode_audioSampling_audioSampling48k),
        ])
    _IS13818AudioMode_audioSampling._ext = None
    _IS13818AudioMode_multichannelType = CHOICE(name=u'multichannelType', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __IS13818AudioMode_multichannelType_singleChannel = NULL(name=u'singleChannel', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __IS13818AudioMode_multichannelType_twoChannelStereo = NULL(name=u'twoChannelStereo', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __IS13818AudioMode_multichannelType_twoChannelDual = NULL(name=u'twoChannelDual', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __IS13818AudioMode_multichannelType_threeChannels2_1 = NULL(name=u'threeChannels2-1', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __IS13818AudioMode_multichannelType_threeChannels3_0 = NULL(name=u'threeChannels3-0', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __IS13818AudioMode_multichannelType_fourChannels2_0_2_0 = NULL(name=u'fourChannels2-0-2-0', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __IS13818AudioMode_multichannelType_fourChannels2_2 = NULL(name=u'fourChannels2-2', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __IS13818AudioMode_multichannelType_fourChannels3_1 = NULL(name=u'fourChannels3-1', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __IS13818AudioMode_multichannelType_fiveChannels3_0_2_0 = NULL(name=u'fiveChannels3-0-2-0', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __IS13818AudioMode_multichannelType_fiveChannels3_2 = NULL(name=u'fiveChannels3-2', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IS13818AudioMode_multichannelType._cont = ASN1Dict([
        (u'singleChannel', __IS13818AudioMode_multichannelType_singleChannel),
        (u'twoChannelStereo', __IS13818AudioMode_multichannelType_twoChannelStereo),
        (u'twoChannelDual', __IS13818AudioMode_multichannelType_twoChannelDual),
        (u'threeChannels2-1', __IS13818AudioMode_multichannelType_threeChannels2_1),
        (u'threeChannels3-0', __IS13818AudioMode_multichannelType_threeChannels3_0),
        (u'fourChannels2-0-2-0', __IS13818AudioMode_multichannelType_fourChannels2_0_2_0),
        (u'fourChannels2-2', __IS13818AudioMode_multichannelType_fourChannels2_2),
        (u'fourChannels3-1', __IS13818AudioMode_multichannelType_fourChannels3_1),
        (u'fiveChannels3-0-2-0', __IS13818AudioMode_multichannelType_fiveChannels3_0_2_0),
        (u'fiveChannels3-2', __IS13818AudioMode_multichannelType_fiveChannels3_2),
        ])
    _IS13818AudioMode_multichannelType._ext = None
    _IS13818AudioMode_lowFrequencyEnhancement = BOOL(name=u'lowFrequencyEnhancement', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IS13818AudioMode_multilingual = BOOL(name=u'multilingual', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IS13818AudioMode_bitRate = INT(name=u'bitRate', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IS13818AudioMode_bitRate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=1130)], ev=None, er=[])
    IS13818AudioMode._cont = ASN1Dict([
        (u'audioLayer', _IS13818AudioMode_audioLayer),
        (u'audioSampling', _IS13818AudioMode_audioSampling),
        (u'multichannelType', _IS13818AudioMode_multichannelType),
        (u'lowFrequencyEnhancement', _IS13818AudioMode_lowFrequencyEnhancement),
        (u'multilingual', _IS13818AudioMode_multilingual),
        (u'bitRate', _IS13818AudioMode_bitRate),
        ])
    IS13818AudioMode._ext = []
    
    #-----< G7231AnnexCMode >-----#
    G7231AnnexCMode = SEQ(name=u'G7231AnnexCMode', mode=MODE_TYPE)
    _G7231AnnexCMode_maxAl_sduAudioFrames = INT(name=u'maxAl-sduAudioFrames', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _G7231AnnexCMode_maxAl_sduAudioFrames._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    _G7231AnnexCMode_silenceSuppression = BOOL(name=u'silenceSuppression', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _G7231AnnexCMode_g723AnnexCAudioMode = SEQ(name=u'g723AnnexCAudioMode', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __G7231AnnexCMode_g723AnnexCAudioMode_highRateMode0 = INT(name=u'highRateMode0', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __G7231AnnexCMode_g723AnnexCAudioMode_highRateMode0._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=27, ub=78)], ev=None, er=[])
    __G7231AnnexCMode_g723AnnexCAudioMode_highRateMode1 = INT(name=u'highRateMode1', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __G7231AnnexCMode_g723AnnexCAudioMode_highRateMode1._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=27, ub=78)], ev=None, er=[])
    __G7231AnnexCMode_g723AnnexCAudioMode_lowRateMode0 = INT(name=u'lowRateMode0', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __G7231AnnexCMode_g723AnnexCAudioMode_lowRateMode0._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=23, ub=66)], ev=None, er=[])
    __G7231AnnexCMode_g723AnnexCAudioMode_lowRateMode1 = INT(name=u'lowRateMode1', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __G7231AnnexCMode_g723AnnexCAudioMode_lowRateMode1._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=23, ub=66)], ev=None, er=[])
    __G7231AnnexCMode_g723AnnexCAudioMode_sidMode0 = INT(name=u'sidMode0', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __G7231AnnexCMode_g723AnnexCAudioMode_sidMode0._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=6, ub=17)], ev=None, er=[])
    __G7231AnnexCMode_g723AnnexCAudioMode_sidMode1 = INT(name=u'sidMode1', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __G7231AnnexCMode_g723AnnexCAudioMode_sidMode1._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=6, ub=17)], ev=None, er=[])
    _G7231AnnexCMode_g723AnnexCAudioMode._cont = ASN1Dict([
        (u'highRateMode0', __G7231AnnexCMode_g723AnnexCAudioMode_highRateMode0),
        (u'highRateMode1', __G7231AnnexCMode_g723AnnexCAudioMode_highRateMode1),
        (u'lowRateMode0', __G7231AnnexCMode_g723AnnexCAudioMode_lowRateMode0),
        (u'lowRateMode1', __G7231AnnexCMode_g723AnnexCAudioMode_lowRateMode1),
        (u'sidMode0', __G7231AnnexCMode_g723AnnexCAudioMode_sidMode0),
        (u'sidMode1', __G7231AnnexCMode_g723AnnexCAudioMode_sidMode1),
        ])
    _G7231AnnexCMode_g723AnnexCAudioMode._ext = []
    G7231AnnexCMode._cont = ASN1Dict([
        (u'maxAl-sduAudioFrames', _G7231AnnexCMode_maxAl_sduAudioFrames),
        (u'silenceSuppression', _G7231AnnexCMode_silenceSuppression),
        (u'g723AnnexCAudioMode', _G7231AnnexCMode_g723AnnexCAudioMode),
        ])
    G7231AnnexCMode._ext = []
    
    #-----< VBDMode >-----#
    VBDMode = SEQ(name=u'VBDMode', mode=MODE_TYPE)
    _VBDMode_type = CHOICE(name=u'type', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'AudioMode')))
    VBDMode._cont = ASN1Dict([
        (u'type', _VBDMode_type),
        ])
    VBDMode._ext = []
    
    #-----< DataMode >-----#
    DataMode = SEQ(name=u'DataMode', mode=MODE_TYPE)
    _DataMode_application = CHOICE(name=u'application', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __DataMode_application_nonStandard = SEQ(name=u'nonStandard', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')))
    __DataMode_application_t120 = CHOICE(name=u't120', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DataProtocolCapability')))
    __DataMode_application_dsm_cc = CHOICE(name=u'dsm-cc', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DataProtocolCapability')))
    __DataMode_application_userData = CHOICE(name=u'userData', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DataProtocolCapability')))
    __DataMode_application_t84 = CHOICE(name=u't84', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DataProtocolCapability')))
    __DataMode_application_t434 = CHOICE(name=u't434', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DataProtocolCapability')))
    __DataMode_application_h224 = CHOICE(name=u'h224', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DataProtocolCapability')))
    __DataMode_application_nlpid = SEQ(name=u'nlpid', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___DataMode_application_nlpid_nlpidProtocol = CHOICE(name=u'nlpidProtocol', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DataProtocolCapability')))
    ___DataMode_application_nlpid_nlpidData = OCT_STR(name=u'nlpidData', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __DataMode_application_nlpid._cont = ASN1Dict([
        (u'nlpidProtocol', ___DataMode_application_nlpid_nlpidProtocol),
        (u'nlpidData', ___DataMode_application_nlpid_nlpidData),
        ])
    __DataMode_application_nlpid._ext = None
    __DataMode_application_dsvdControl = NULL(name=u'dsvdControl', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __DataMode_application_h222DataPartitioning = CHOICE(name=u'h222DataPartitioning', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DataProtocolCapability')))
    __DataMode_application_t30fax = CHOICE(name=u't30fax', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DataProtocolCapability')))
    __DataMode_application_t140 = CHOICE(name=u't140', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DataProtocolCapability')))
    __DataMode_application_t38fax = SEQ(name=u't38fax', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___DataMode_application_t38fax_t38FaxProtocol = CHOICE(name=u't38FaxProtocol', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DataProtocolCapability')))
    ___DataMode_application_t38fax_t38FaxProfile = SEQ(name=u't38FaxProfile', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'T38FaxProfile')))
    __DataMode_application_t38fax._cont = ASN1Dict([
        (u't38FaxProtocol', ___DataMode_application_t38fax_t38FaxProtocol),
        (u't38FaxProfile', ___DataMode_application_t38fax_t38FaxProfile),
        ])
    __DataMode_application_t38fax._ext = None
    __DataMode_application_genericDataMode = SEQ(name=u'genericDataMode', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'GenericCapability')))
    _DataMode_application._cont = ASN1Dict([
        (u'nonStandard', __DataMode_application_nonStandard),
        (u't120', __DataMode_application_t120),
        (u'dsm-cc', __DataMode_application_dsm_cc),
        (u'userData', __DataMode_application_userData),
        (u't84', __DataMode_application_t84),
        (u't434', __DataMode_application_t434),
        (u'h224', __DataMode_application_h224),
        (u'nlpid', __DataMode_application_nlpid),
        (u'dsvdControl', __DataMode_application_dsvdControl),
        (u'h222DataPartitioning', __DataMode_application_h222DataPartitioning),
        (u't30fax', __DataMode_application_t30fax),
        (u't140', __DataMode_application_t140),
        (u't38fax', __DataMode_application_t38fax),
        (u'genericDataMode', __DataMode_application_genericDataMode),
        ])
    _DataMode_application._ext = [u't30fax', u't140', u't38fax', u'genericDataMode']
    _DataMode_bitRate = INT(name=u'bitRate', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _DataMode_bitRate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4294967295)], ev=None, er=[])
    DataMode._cont = ASN1Dict([
        (u'application', _DataMode_application),
        (u'bitRate', _DataMode_bitRate),
        ])
    DataMode._ext = []
    
    #-----< EncryptionMode >-----#
    EncryptionMode = CHOICE(name=u'EncryptionMode', mode=MODE_TYPE)
    _EncryptionMode_nonStandard = SEQ(name=u'nonStandard', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')))
    _EncryptionMode_h233Encryption = NULL(name=u'h233Encryption', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    EncryptionMode._cont = ASN1Dict([
        (u'nonStandard', _EncryptionMode_nonStandard),
        (u'h233Encryption', _EncryptionMode_h233Encryption),
        ])
    EncryptionMode._ext = []
    
    #-----< RoundTripDelayRequest >-----#
    RoundTripDelayRequest = SEQ(name=u'RoundTripDelayRequest', mode=MODE_TYPE)
    _RoundTripDelayRequest_sequenceNumber = INT(name=u'sequenceNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'SequenceNumber')))
    RoundTripDelayRequest._cont = ASN1Dict([
        (u'sequenceNumber', _RoundTripDelayRequest_sequenceNumber),
        ])
    RoundTripDelayRequest._ext = []
    
    #-----< RoundTripDelayResponse >-----#
    RoundTripDelayResponse = SEQ(name=u'RoundTripDelayResponse', mode=MODE_TYPE)
    _RoundTripDelayResponse_sequenceNumber = INT(name=u'sequenceNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'SequenceNumber')))
    RoundTripDelayResponse._cont = ASN1Dict([
        (u'sequenceNumber', _RoundTripDelayResponse_sequenceNumber),
        ])
    RoundTripDelayResponse._ext = []
    
    #-----< MaintenanceLoopRequest >-----#
    MaintenanceLoopRequest = SEQ(name=u'MaintenanceLoopRequest', mode=MODE_TYPE)
    _MaintenanceLoopRequest_type = CHOICE(name=u'type', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __MaintenanceLoopRequest_type_systemLoop = NULL(name=u'systemLoop', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MaintenanceLoopRequest_type_mediaLoop = INT(name=u'mediaLoop', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelNumber')))
    __MaintenanceLoopRequest_type_logicalChannelLoop = INT(name=u'logicalChannelLoop', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelNumber')))
    _MaintenanceLoopRequest_type._cont = ASN1Dict([
        (u'systemLoop', __MaintenanceLoopRequest_type_systemLoop),
        (u'mediaLoop', __MaintenanceLoopRequest_type_mediaLoop),
        (u'logicalChannelLoop', __MaintenanceLoopRequest_type_logicalChannelLoop),
        ])
    _MaintenanceLoopRequest_type._ext = []
    MaintenanceLoopRequest._cont = ASN1Dict([
        (u'type', _MaintenanceLoopRequest_type),
        ])
    MaintenanceLoopRequest._ext = []
    
    #-----< MaintenanceLoopAck >-----#
    MaintenanceLoopAck = SEQ(name=u'MaintenanceLoopAck', mode=MODE_TYPE)
    _MaintenanceLoopAck_type = CHOICE(name=u'type', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __MaintenanceLoopAck_type_systemLoop = NULL(name=u'systemLoop', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MaintenanceLoopAck_type_mediaLoop = INT(name=u'mediaLoop', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelNumber')))
    __MaintenanceLoopAck_type_logicalChannelLoop = INT(name=u'logicalChannelLoop', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelNumber')))
    _MaintenanceLoopAck_type._cont = ASN1Dict([
        (u'systemLoop', __MaintenanceLoopAck_type_systemLoop),
        (u'mediaLoop', __MaintenanceLoopAck_type_mediaLoop),
        (u'logicalChannelLoop', __MaintenanceLoopAck_type_logicalChannelLoop),
        ])
    _MaintenanceLoopAck_type._ext = []
    MaintenanceLoopAck._cont = ASN1Dict([
        (u'type', _MaintenanceLoopAck_type),
        ])
    MaintenanceLoopAck._ext = []
    
    #-----< MaintenanceLoopReject >-----#
    MaintenanceLoopReject = SEQ(name=u'MaintenanceLoopReject', mode=MODE_TYPE)
    _MaintenanceLoopReject_type = CHOICE(name=u'type', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __MaintenanceLoopReject_type_systemLoop = NULL(name=u'systemLoop', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MaintenanceLoopReject_type_mediaLoop = INT(name=u'mediaLoop', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelNumber')))
    __MaintenanceLoopReject_type_logicalChannelLoop = INT(name=u'logicalChannelLoop', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelNumber')))
    _MaintenanceLoopReject_type._cont = ASN1Dict([
        (u'systemLoop', __MaintenanceLoopReject_type_systemLoop),
        (u'mediaLoop', __MaintenanceLoopReject_type_mediaLoop),
        (u'logicalChannelLoop', __MaintenanceLoopReject_type_logicalChannelLoop),
        ])
    _MaintenanceLoopReject_type._ext = []
    _MaintenanceLoopReject_cause = CHOICE(name=u'cause', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __MaintenanceLoopReject_cause_canNotPerformLoop = NULL(name=u'canNotPerformLoop', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MaintenanceLoopReject_cause._cont = ASN1Dict([
        (u'canNotPerformLoop', __MaintenanceLoopReject_cause_canNotPerformLoop),
        ])
    _MaintenanceLoopReject_cause._ext = []
    MaintenanceLoopReject._cont = ASN1Dict([
        (u'type', _MaintenanceLoopReject_type),
        (u'cause', _MaintenanceLoopReject_cause),
        ])
    MaintenanceLoopReject._ext = []
    
    #-----< MaintenanceLoopOffCommand >-----#
    MaintenanceLoopOffCommand = SEQ(name=u'MaintenanceLoopOffCommand', mode=MODE_TYPE)
    MaintenanceLoopOffCommand._cont = ASN1Dict([
        ])
    MaintenanceLoopOffCommand._ext = []
    
    #-----< CommunicationModeCommand >-----#
    CommunicationModeCommand = SEQ(name=u'CommunicationModeCommand', mode=MODE_TYPE)
    _CommunicationModeCommand_communicationModeTable = SET_OF(name=u'communicationModeTable', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __CommunicationModeCommand_communicationModeTable__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'CommunicationModeTableEntry')))
    _CommunicationModeCommand_communicationModeTable._cont = __CommunicationModeCommand_communicationModeTable__item_
    _CommunicationModeCommand_communicationModeTable._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    CommunicationModeCommand._cont = ASN1Dict([
        (u'communicationModeTable', _CommunicationModeCommand_communicationModeTable),
        ])
    CommunicationModeCommand._ext = []
    
    #-----< CommunicationModeRequest >-----#
    CommunicationModeRequest = SEQ(name=u'CommunicationModeRequest', mode=MODE_TYPE)
    CommunicationModeRequest._cont = ASN1Dict([
        ])
    CommunicationModeRequest._ext = []
    
    #-----< CommunicationModeResponse >-----#
    CommunicationModeResponse = CHOICE(name=u'CommunicationModeResponse', mode=MODE_TYPE)
    _CommunicationModeResponse_communicationModeTable = SET_OF(name=u'communicationModeTable', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __CommunicationModeResponse_communicationModeTable__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'CommunicationModeTableEntry')))
    _CommunicationModeResponse_communicationModeTable._cont = __CommunicationModeResponse_communicationModeTable__item_
    _CommunicationModeResponse_communicationModeTable._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    CommunicationModeResponse._cont = ASN1Dict([
        (u'communicationModeTable', _CommunicationModeResponse_communicationModeTable),
        ])
    CommunicationModeResponse._ext = []
    
    #-----< CommunicationModeTableEntry >-----#
    CommunicationModeTableEntry = SEQ(name=u'CommunicationModeTableEntry', mode=MODE_TYPE)
    _CommunicationModeTableEntry_nonStandard = SEQ_OF(name=u'nonStandard', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __CommunicationModeTableEntry_nonStandard__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')))
    _CommunicationModeTableEntry_nonStandard._cont = __CommunicationModeTableEntry_nonStandard__item_
    _CommunicationModeTableEntry_sessionID = INT(name=u'sessionID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _CommunicationModeTableEntry_sessionID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=255)], ev=None, er=[])
    _CommunicationModeTableEntry_associatedSessionID = INT(name=u'associatedSessionID', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CommunicationModeTableEntry_associatedSessionID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=255)], ev=None, er=[])
    _CommunicationModeTableEntry_terminalLabel = SEQ(name=u'terminalLabel', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TerminalLabel')), opt=True)
    _CommunicationModeTableEntry_sessionDescription = STR_BMP(name=u'sessionDescription', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _CommunicationModeTableEntry_sessionDescription._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _CommunicationModeTableEntry_dataType = CHOICE(name=u'dataType', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __CommunicationModeTableEntry_dataType_videoData = CHOICE(name=u'videoData', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'VideoCapability')))
    __CommunicationModeTableEntry_dataType_audioData = CHOICE(name=u'audioData', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'AudioCapability')))
    __CommunicationModeTableEntry_dataType_data = SEQ(name=u'data', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DataApplicationCapability')))
    _CommunicationModeTableEntry_dataType._cont = ASN1Dict([
        (u'videoData', __CommunicationModeTableEntry_dataType_videoData),
        (u'audioData', __CommunicationModeTableEntry_dataType_audioData),
        (u'data', __CommunicationModeTableEntry_dataType_data),
        ])
    _CommunicationModeTableEntry_dataType._ext = []
    _CommunicationModeTableEntry_mediaChannel = CHOICE(name=u'mediaChannel', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TransportAddress')), opt=True)
    _CommunicationModeTableEntry_mediaGuaranteedDelivery = BOOL(name=u'mediaGuaranteedDelivery', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CommunicationModeTableEntry_mediaControlChannel = CHOICE(name=u'mediaControlChannel', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TransportAddress')), opt=True)
    _CommunicationModeTableEntry_mediaControlGuaranteedDelivery = BOOL(name=u'mediaControlGuaranteedDelivery', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CommunicationModeTableEntry_redundancyEncoding = SEQ(name=u'redundancyEncoding', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'RedundancyEncoding')), opt=True)
    _CommunicationModeTableEntry_sessionDependency = INT(name=u'sessionDependency', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CommunicationModeTableEntry_sessionDependency._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=255)], ev=None, er=[])
    _CommunicationModeTableEntry_destination = SEQ(name=u'destination', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TerminalLabel')), opt=True)
    CommunicationModeTableEntry._cont = ASN1Dict([
        (u'nonStandard', _CommunicationModeTableEntry_nonStandard),
        (u'sessionID', _CommunicationModeTableEntry_sessionID),
        (u'associatedSessionID', _CommunicationModeTableEntry_associatedSessionID),
        (u'terminalLabel', _CommunicationModeTableEntry_terminalLabel),
        (u'sessionDescription', _CommunicationModeTableEntry_sessionDescription),
        (u'dataType', _CommunicationModeTableEntry_dataType),
        (u'mediaChannel', _CommunicationModeTableEntry_mediaChannel),
        (u'mediaGuaranteedDelivery', _CommunicationModeTableEntry_mediaGuaranteedDelivery),
        (u'mediaControlChannel', _CommunicationModeTableEntry_mediaControlChannel),
        (u'mediaControlGuaranteedDelivery', _CommunicationModeTableEntry_mediaControlGuaranteedDelivery),
        (u'redundancyEncoding', _CommunicationModeTableEntry_redundancyEncoding),
        (u'sessionDependency', _CommunicationModeTableEntry_sessionDependency),
        (u'destination', _CommunicationModeTableEntry_destination),
        ])
    CommunicationModeTableEntry._ext = [u'redundancyEncoding', u'sessionDependency', u'destination']
    
    #-----< ConferenceRequest >-----#
    ConferenceRequest = CHOICE(name=u'ConferenceRequest', mode=MODE_TYPE)
    _ConferenceRequest_terminalListRequest = NULL(name=u'terminalListRequest', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ConferenceRequest_makeMeChair = NULL(name=u'makeMeChair', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ConferenceRequest_cancelMakeMeChair = NULL(name=u'cancelMakeMeChair', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ConferenceRequest_dropTerminal = SEQ(name=u'dropTerminal', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TerminalLabel')))
    _ConferenceRequest_requestTerminalID = SEQ(name=u'requestTerminalID', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TerminalLabel')))
    _ConferenceRequest_enterH243Password = NULL(name=u'enterH243Password', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ConferenceRequest_enterH243TerminalID = NULL(name=u'enterH243TerminalID', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ConferenceRequest_enterH243ConferenceID = NULL(name=u'enterH243ConferenceID', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ConferenceRequest_enterExtensionAddress = NULL(name=u'enterExtensionAddress', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ConferenceRequest_requestChairTokenOwner = NULL(name=u'requestChairTokenOwner', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ConferenceRequest_requestTerminalCertificate = SEQ(name=u'requestTerminalCertificate', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __ConferenceRequest_requestTerminalCertificate_terminalLabel = SEQ(name=u'terminalLabel', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TerminalLabel')), opt=True)
    __ConferenceRequest_requestTerminalCertificate_certSelectionCriteria = SEQ_OF(name=u'certSelectionCriteria', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'CertSelectionCriteria')), opt=True)
    __ConferenceRequest_requestTerminalCertificate_sRandom = INT(name=u'sRandom', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __ConferenceRequest_requestTerminalCertificate_sRandom._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4294967295)], ev=None, er=[])
    _ConferenceRequest_requestTerminalCertificate._cont = ASN1Dict([
        (u'terminalLabel', __ConferenceRequest_requestTerminalCertificate_terminalLabel),
        (u'certSelectionCriteria', __ConferenceRequest_requestTerminalCertificate_certSelectionCriteria),
        (u'sRandom', __ConferenceRequest_requestTerminalCertificate_sRandom),
        ])
    _ConferenceRequest_requestTerminalCertificate._ext = []
    _ConferenceRequest_broadcastMyLogicalChannel = INT(name=u'broadcastMyLogicalChannel', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelNumber')))
    _ConferenceRequest_makeTerminalBroadcaster = SEQ(name=u'makeTerminalBroadcaster', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TerminalLabel')))
    _ConferenceRequest_sendThisSource = SEQ(name=u'sendThisSource', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TerminalLabel')))
    _ConferenceRequest_requestAllTerminalIDs = NULL(name=u'requestAllTerminalIDs', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ConferenceRequest_remoteMCRequest = CHOICE(name=u'remoteMCRequest', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'RemoteMCRequest')))
    ConferenceRequest._cont = ASN1Dict([
        (u'terminalListRequest', _ConferenceRequest_terminalListRequest),
        (u'makeMeChair', _ConferenceRequest_makeMeChair),
        (u'cancelMakeMeChair', _ConferenceRequest_cancelMakeMeChair),
        (u'dropTerminal', _ConferenceRequest_dropTerminal),
        (u'requestTerminalID', _ConferenceRequest_requestTerminalID),
        (u'enterH243Password', _ConferenceRequest_enterH243Password),
        (u'enterH243TerminalID', _ConferenceRequest_enterH243TerminalID),
        (u'enterH243ConferenceID', _ConferenceRequest_enterH243ConferenceID),
        (u'enterExtensionAddress', _ConferenceRequest_enterExtensionAddress),
        (u'requestChairTokenOwner', _ConferenceRequest_requestChairTokenOwner),
        (u'requestTerminalCertificate', _ConferenceRequest_requestTerminalCertificate),
        (u'broadcastMyLogicalChannel', _ConferenceRequest_broadcastMyLogicalChannel),
        (u'makeTerminalBroadcaster', _ConferenceRequest_makeTerminalBroadcaster),
        (u'sendThisSource', _ConferenceRequest_sendThisSource),
        (u'requestAllTerminalIDs', _ConferenceRequest_requestAllTerminalIDs),
        (u'remoteMCRequest', _ConferenceRequest_remoteMCRequest),
        ])
    ConferenceRequest._ext = [u'enterExtensionAddress', u'requestChairTokenOwner', u'requestTerminalCertificate', u'broadcastMyLogicalChannel', u'makeTerminalBroadcaster', u'sendThisSource', u'requestAllTerminalIDs', u'remoteMCRequest']
    
    #-----< CertSelectionCriteria >-----#
    CertSelectionCriteria = SEQ_OF(name=u'CertSelectionCriteria', mode=MODE_TYPE)
    _CertSelectionCriteria__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'Criteria')))
    CertSelectionCriteria._cont = _CertSelectionCriteria__item_
    CertSelectionCriteria._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    
    #-----< Criteria >-----#
    Criteria = SEQ(name=u'Criteria', mode=MODE_TYPE)
    _Criteria_field = OID(name=u'field', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _Criteria_value = OCT_STR(name=u'value', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _Criteria_value._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    Criteria._cont = ASN1Dict([
        (u'field', _Criteria_field),
        (u'value', _Criteria_value),
        ])
    Criteria._ext = []
    
    #-----< TerminalLabel >-----#
    TerminalLabel = SEQ(name=u'TerminalLabel', mode=MODE_TYPE)
    _TerminalLabel_mcuNumber = INT(name=u'mcuNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'McuNumber')))
    _TerminalLabel_terminalNumber = INT(name=u'terminalNumber', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TerminalNumber')))
    TerminalLabel._cont = ASN1Dict([
        (u'mcuNumber', _TerminalLabel_mcuNumber),
        (u'terminalNumber', _TerminalLabel_terminalNumber),
        ])
    TerminalLabel._ext = []
    
    #-----< McuNumber >-----#
    McuNumber = INT(name=u'McuNumber', mode=MODE_TYPE)
    McuNumber._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=192)], ev=None, er=[])
    
    #-----< TerminalNumber >-----#
    TerminalNumber = INT(name=u'TerminalNumber', mode=MODE_TYPE)
    TerminalNumber._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=192)], ev=None, er=[])
    
    #-----< ConferenceResponse >-----#
    ConferenceResponse = CHOICE(name=u'ConferenceResponse', mode=MODE_TYPE)
    _ConferenceResponse_mCTerminalIDResponse = SEQ(name=u'mCTerminalIDResponse', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __ConferenceResponse_mCTerminalIDResponse_terminalLabel = SEQ(name=u'terminalLabel', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TerminalLabel')))
    __ConferenceResponse_mCTerminalIDResponse_terminalID = OCT_STR(name=u'terminalID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TerminalID')))
    _ConferenceResponse_mCTerminalIDResponse._cont = ASN1Dict([
        (u'terminalLabel', __ConferenceResponse_mCTerminalIDResponse_terminalLabel),
        (u'terminalID', __ConferenceResponse_mCTerminalIDResponse_terminalID),
        ])
    _ConferenceResponse_mCTerminalIDResponse._ext = []
    _ConferenceResponse_terminalIDResponse = SEQ(name=u'terminalIDResponse', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __ConferenceResponse_terminalIDResponse_terminalLabel = SEQ(name=u'terminalLabel', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TerminalLabel')))
    __ConferenceResponse_terminalIDResponse_terminalID = OCT_STR(name=u'terminalID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TerminalID')))
    _ConferenceResponse_terminalIDResponse._cont = ASN1Dict([
        (u'terminalLabel', __ConferenceResponse_terminalIDResponse_terminalLabel),
        (u'terminalID', __ConferenceResponse_terminalIDResponse_terminalID),
        ])
    _ConferenceResponse_terminalIDResponse._ext = []
    _ConferenceResponse_conferenceIDResponse = SEQ(name=u'conferenceIDResponse', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __ConferenceResponse_conferenceIDResponse_terminalLabel = SEQ(name=u'terminalLabel', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TerminalLabel')))
    __ConferenceResponse_conferenceIDResponse_conferenceID = OCT_STR(name=u'conferenceID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'ConferenceID')))
    _ConferenceResponse_conferenceIDResponse._cont = ASN1Dict([
        (u'terminalLabel', __ConferenceResponse_conferenceIDResponse_terminalLabel),
        (u'conferenceID', __ConferenceResponse_conferenceIDResponse_conferenceID),
        ])
    _ConferenceResponse_conferenceIDResponse._ext = []
    _ConferenceResponse_passwordResponse = SEQ(name=u'passwordResponse', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __ConferenceResponse_passwordResponse_terminalLabel = SEQ(name=u'terminalLabel', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TerminalLabel')))
    __ConferenceResponse_passwordResponse_password = OCT_STR(name=u'password', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'Password')))
    _ConferenceResponse_passwordResponse._cont = ASN1Dict([
        (u'terminalLabel', __ConferenceResponse_passwordResponse_terminalLabel),
        (u'password', __ConferenceResponse_passwordResponse_password),
        ])
    _ConferenceResponse_passwordResponse._ext = []
    _ConferenceResponse_terminalListResponse = SET_OF(name=u'terminalListResponse', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __ConferenceResponse_terminalListResponse__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TerminalLabel')))
    _ConferenceResponse_terminalListResponse._cont = __ConferenceResponse_terminalListResponse__item_
    _ConferenceResponse_terminalListResponse._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    _ConferenceResponse_videoCommandReject = NULL(name=u'videoCommandReject', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ConferenceResponse_terminalDropReject = NULL(name=u'terminalDropReject', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ConferenceResponse_makeMeChairResponse = CHOICE(name=u'makeMeChairResponse', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __ConferenceResponse_makeMeChairResponse_grantedChairToken = NULL(name=u'grantedChairToken', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __ConferenceResponse_makeMeChairResponse_deniedChairToken = NULL(name=u'deniedChairToken', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ConferenceResponse_makeMeChairResponse._cont = ASN1Dict([
        (u'grantedChairToken', __ConferenceResponse_makeMeChairResponse_grantedChairToken),
        (u'deniedChairToken', __ConferenceResponse_makeMeChairResponse_deniedChairToken),
        ])
    _ConferenceResponse_makeMeChairResponse._ext = []
    _ConferenceResponse_extensionAddressResponse = SEQ(name=u'extensionAddressResponse', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __ConferenceResponse_extensionAddressResponse_extensionAddress = OCT_STR(name=u'extensionAddress', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TerminalID')))
    _ConferenceResponse_extensionAddressResponse._cont = ASN1Dict([
        (u'extensionAddress', __ConferenceResponse_extensionAddressResponse_extensionAddress),
        ])
    _ConferenceResponse_extensionAddressResponse._ext = []
    _ConferenceResponse_chairTokenOwnerResponse = SEQ(name=u'chairTokenOwnerResponse', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __ConferenceResponse_chairTokenOwnerResponse_terminalLabel = SEQ(name=u'terminalLabel', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TerminalLabel')))
    __ConferenceResponse_chairTokenOwnerResponse_terminalID = OCT_STR(name=u'terminalID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TerminalID')))
    _ConferenceResponse_chairTokenOwnerResponse._cont = ASN1Dict([
        (u'terminalLabel', __ConferenceResponse_chairTokenOwnerResponse_terminalLabel),
        (u'terminalID', __ConferenceResponse_chairTokenOwnerResponse_terminalID),
        ])
    _ConferenceResponse_chairTokenOwnerResponse._ext = []
    _ConferenceResponse_terminalCertificateResponse = SEQ(name=u'terminalCertificateResponse', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __ConferenceResponse_terminalCertificateResponse_terminalLabel = SEQ(name=u'terminalLabel', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TerminalLabel')), opt=True)
    __ConferenceResponse_terminalCertificateResponse_certificateResponse = OCT_STR(name=u'certificateResponse', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __ConferenceResponse_terminalCertificateResponse_certificateResponse._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    _ConferenceResponse_terminalCertificateResponse._cont = ASN1Dict([
        (u'terminalLabel', __ConferenceResponse_terminalCertificateResponse_terminalLabel),
        (u'certificateResponse', __ConferenceResponse_terminalCertificateResponse_certificateResponse),
        ])
    _ConferenceResponse_terminalCertificateResponse._ext = []
    _ConferenceResponse_broadcastMyLogicalChannelResponse = CHOICE(name=u'broadcastMyLogicalChannelResponse', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __ConferenceResponse_broadcastMyLogicalChannelResponse_grantedBroadcastMyLogicalChannel = NULL(name=u'grantedBroadcastMyLogicalChannel', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __ConferenceResponse_broadcastMyLogicalChannelResponse_deniedBroadcastMyLogicalChannel = NULL(name=u'deniedBroadcastMyLogicalChannel', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ConferenceResponse_broadcastMyLogicalChannelResponse._cont = ASN1Dict([
        (u'grantedBroadcastMyLogicalChannel', __ConferenceResponse_broadcastMyLogicalChannelResponse_grantedBroadcastMyLogicalChannel),
        (u'deniedBroadcastMyLogicalChannel', __ConferenceResponse_broadcastMyLogicalChannelResponse_deniedBroadcastMyLogicalChannel),
        ])
    _ConferenceResponse_broadcastMyLogicalChannelResponse._ext = []
    _ConferenceResponse_makeTerminalBroadcasterResponse = CHOICE(name=u'makeTerminalBroadcasterResponse', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __ConferenceResponse_makeTerminalBroadcasterResponse_grantedMakeTerminalBroadcaster = NULL(name=u'grantedMakeTerminalBroadcaster', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __ConferenceResponse_makeTerminalBroadcasterResponse_deniedMakeTerminalBroadcaster = NULL(name=u'deniedMakeTerminalBroadcaster', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ConferenceResponse_makeTerminalBroadcasterResponse._cont = ASN1Dict([
        (u'grantedMakeTerminalBroadcaster', __ConferenceResponse_makeTerminalBroadcasterResponse_grantedMakeTerminalBroadcaster),
        (u'deniedMakeTerminalBroadcaster', __ConferenceResponse_makeTerminalBroadcasterResponse_deniedMakeTerminalBroadcaster),
        ])
    _ConferenceResponse_makeTerminalBroadcasterResponse._ext = []
    _ConferenceResponse_sendThisSourceResponse = CHOICE(name=u'sendThisSourceResponse', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __ConferenceResponse_sendThisSourceResponse_grantedSendThisSource = NULL(name=u'grantedSendThisSource', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __ConferenceResponse_sendThisSourceResponse_deniedSendThisSource = NULL(name=u'deniedSendThisSource', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ConferenceResponse_sendThisSourceResponse._cont = ASN1Dict([
        (u'grantedSendThisSource', __ConferenceResponse_sendThisSourceResponse_grantedSendThisSource),
        (u'deniedSendThisSource', __ConferenceResponse_sendThisSourceResponse_deniedSendThisSource),
        ])
    _ConferenceResponse_sendThisSourceResponse._ext = []
    _ConferenceResponse_requestAllTerminalIDsResponse = SEQ(name=u'requestAllTerminalIDsResponse', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'RequestAllTerminalIDsResponse')))
    _ConferenceResponse_remoteMCResponse = CHOICE(name=u'remoteMCResponse', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'RemoteMCResponse')))
    ConferenceResponse._cont = ASN1Dict([
        (u'mCTerminalIDResponse', _ConferenceResponse_mCTerminalIDResponse),
        (u'terminalIDResponse', _ConferenceResponse_terminalIDResponse),
        (u'conferenceIDResponse', _ConferenceResponse_conferenceIDResponse),
        (u'passwordResponse', _ConferenceResponse_passwordResponse),
        (u'terminalListResponse', _ConferenceResponse_terminalListResponse),
        (u'videoCommandReject', _ConferenceResponse_videoCommandReject),
        (u'terminalDropReject', _ConferenceResponse_terminalDropReject),
        (u'makeMeChairResponse', _ConferenceResponse_makeMeChairResponse),
        (u'extensionAddressResponse', _ConferenceResponse_extensionAddressResponse),
        (u'chairTokenOwnerResponse', _ConferenceResponse_chairTokenOwnerResponse),
        (u'terminalCertificateResponse', _ConferenceResponse_terminalCertificateResponse),
        (u'broadcastMyLogicalChannelResponse', _ConferenceResponse_broadcastMyLogicalChannelResponse),
        (u'makeTerminalBroadcasterResponse', _ConferenceResponse_makeTerminalBroadcasterResponse),
        (u'sendThisSourceResponse', _ConferenceResponse_sendThisSourceResponse),
        (u'requestAllTerminalIDsResponse', _ConferenceResponse_requestAllTerminalIDsResponse),
        (u'remoteMCResponse', _ConferenceResponse_remoteMCResponse),
        ])
    ConferenceResponse._ext = [u'extensionAddressResponse', u'chairTokenOwnerResponse', u'terminalCertificateResponse', u'broadcastMyLogicalChannelResponse', u'makeTerminalBroadcasterResponse', u'sendThisSourceResponse', u'requestAllTerminalIDsResponse', u'remoteMCResponse']
    
    #-----< TerminalID >-----#
    TerminalID = OCT_STR(name=u'TerminalID', mode=MODE_TYPE)
    TerminalID._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    
    #-----< ConferenceID >-----#
    ConferenceID = OCT_STR(name=u'ConferenceID', mode=MODE_TYPE)
    ConferenceID._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    
    #-----< Password >-----#
    Password = OCT_STR(name=u'Password', mode=MODE_TYPE)
    Password._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    
    #-----< RequestAllTerminalIDsResponse >-----#
    RequestAllTerminalIDsResponse = SEQ(name=u'RequestAllTerminalIDsResponse', mode=MODE_TYPE)
    _RequestAllTerminalIDsResponse_terminalInformation = SEQ_OF(name=u'terminalInformation', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __RequestAllTerminalIDsResponse_terminalInformation__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TerminalInformation')))
    _RequestAllTerminalIDsResponse_terminalInformation._cont = __RequestAllTerminalIDsResponse_terminalInformation__item_
    RequestAllTerminalIDsResponse._cont = ASN1Dict([
        (u'terminalInformation', _RequestAllTerminalIDsResponse_terminalInformation),
        ])
    RequestAllTerminalIDsResponse._ext = []
    
    #-----< TerminalInformation >-----#
    TerminalInformation = SEQ(name=u'TerminalInformation', mode=MODE_TYPE)
    _TerminalInformation_terminalLabel = SEQ(name=u'terminalLabel', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TerminalLabel')))
    _TerminalInformation_terminalID = OCT_STR(name=u'terminalID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TerminalID')))
    TerminalInformation._cont = ASN1Dict([
        (u'terminalLabel', _TerminalInformation_terminalLabel),
        (u'terminalID', _TerminalInformation_terminalID),
        ])
    TerminalInformation._ext = []
    
    #-----< RemoteMCRequest >-----#
    RemoteMCRequest = CHOICE(name=u'RemoteMCRequest', mode=MODE_TYPE)
    _RemoteMCRequest_masterActivate = NULL(name=u'masterActivate', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _RemoteMCRequest_slaveActivate = NULL(name=u'slaveActivate', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _RemoteMCRequest_deActivate = NULL(name=u'deActivate', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    RemoteMCRequest._cont = ASN1Dict([
        (u'masterActivate', _RemoteMCRequest_masterActivate),
        (u'slaveActivate', _RemoteMCRequest_slaveActivate),
        (u'deActivate', _RemoteMCRequest_deActivate),
        ])
    RemoteMCRequest._ext = []
    
    #-----< RemoteMCResponse >-----#
    RemoteMCResponse = CHOICE(name=u'RemoteMCResponse', mode=MODE_TYPE)
    _RemoteMCResponse_accept = NULL(name=u'accept', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _RemoteMCResponse_reject = CHOICE(name=u'reject', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __RemoteMCResponse_reject_unspecified = NULL(name=u'unspecified', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __RemoteMCResponse_reject_functionNotSupported = NULL(name=u'functionNotSupported', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _RemoteMCResponse_reject._cont = ASN1Dict([
        (u'unspecified', __RemoteMCResponse_reject_unspecified),
        (u'functionNotSupported', __RemoteMCResponse_reject_functionNotSupported),
        ])
    _RemoteMCResponse_reject._ext = []
    RemoteMCResponse._cont = ASN1Dict([
        (u'accept', _RemoteMCResponse_accept),
        (u'reject', _RemoteMCResponse_reject),
        ])
    RemoteMCResponse._ext = []
    
    #-----< MultilinkRequest >-----#
    MultilinkRequest = CHOICE(name=u'MultilinkRequest', mode=MODE_TYPE)
    _MultilinkRequest_nonStandard = SEQ(name=u'nonStandard', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardMessage')))
    _MultilinkRequest_callInformation = SEQ(name=u'callInformation', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MultilinkRequest_callInformation_maxNumberOfAdditionalConnections = INT(name=u'maxNumberOfAdditionalConnections', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MultilinkRequest_callInformation_maxNumberOfAdditionalConnections._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    _MultilinkRequest_callInformation._cont = ASN1Dict([
        (u'maxNumberOfAdditionalConnections', __MultilinkRequest_callInformation_maxNumberOfAdditionalConnections),
        ])
    _MultilinkRequest_callInformation._ext = []
    _MultilinkRequest_addConnection = SEQ(name=u'addConnection', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MultilinkRequest_addConnection_sequenceNumber = INT(name=u'sequenceNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'SequenceNumber')))
    __MultilinkRequest_addConnection_dialingInformation = CHOICE(name=u'dialingInformation', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DialingInformation')))
    _MultilinkRequest_addConnection._cont = ASN1Dict([
        (u'sequenceNumber', __MultilinkRequest_addConnection_sequenceNumber),
        (u'dialingInformation', __MultilinkRequest_addConnection_dialingInformation),
        ])
    _MultilinkRequest_addConnection._ext = []
    _MultilinkRequest_removeConnection = SEQ(name=u'removeConnection', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MultilinkRequest_removeConnection_connectionIdentifier = SEQ(name=u'connectionIdentifier', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'ConnectionIdentifier')))
    _MultilinkRequest_removeConnection._cont = ASN1Dict([
        (u'connectionIdentifier', __MultilinkRequest_removeConnection_connectionIdentifier),
        ])
    _MultilinkRequest_removeConnection._ext = []
    _MultilinkRequest_maximumHeaderInterval = SEQ(name=u'maximumHeaderInterval', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MultilinkRequest_maximumHeaderInterval_requestType = CHOICE(name=u'requestType', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ___MultilinkRequest_maximumHeaderInterval_requestType_currentIntervalInformation = NULL(name=u'currentIntervalInformation', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___MultilinkRequest_maximumHeaderInterval_requestType_requestedInterval = INT(name=u'requestedInterval', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___MultilinkRequest_maximumHeaderInterval_requestType_requestedInterval._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    __MultilinkRequest_maximumHeaderInterval_requestType._cont = ASN1Dict([
        (u'currentIntervalInformation', ___MultilinkRequest_maximumHeaderInterval_requestType_currentIntervalInformation),
        (u'requestedInterval', ___MultilinkRequest_maximumHeaderInterval_requestType_requestedInterval),
        ])
    __MultilinkRequest_maximumHeaderInterval_requestType._ext = []
    _MultilinkRequest_maximumHeaderInterval._cont = ASN1Dict([
        (u'requestType', __MultilinkRequest_maximumHeaderInterval_requestType),
        ])
    _MultilinkRequest_maximumHeaderInterval._ext = []
    MultilinkRequest._cont = ASN1Dict([
        (u'nonStandard', _MultilinkRequest_nonStandard),
        (u'callInformation', _MultilinkRequest_callInformation),
        (u'addConnection', _MultilinkRequest_addConnection),
        (u'removeConnection', _MultilinkRequest_removeConnection),
        (u'maximumHeaderInterval', _MultilinkRequest_maximumHeaderInterval),
        ])
    MultilinkRequest._ext = []
    
    #-----< MultilinkResponse >-----#
    MultilinkResponse = CHOICE(name=u'MultilinkResponse', mode=MODE_TYPE)
    _MultilinkResponse_nonStandard = SEQ(name=u'nonStandard', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardMessage')))
    _MultilinkResponse_callInformation = SEQ(name=u'callInformation', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MultilinkResponse_callInformation_dialingInformation = CHOICE(name=u'dialingInformation', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DialingInformation')))
    __MultilinkResponse_callInformation_callAssociationNumber = INT(name=u'callAssociationNumber', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MultilinkResponse_callInformation_callAssociationNumber._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4294967295)], ev=None, er=[])
    _MultilinkResponse_callInformation._cont = ASN1Dict([
        (u'dialingInformation', __MultilinkResponse_callInformation_dialingInformation),
        (u'callAssociationNumber', __MultilinkResponse_callInformation_callAssociationNumber),
        ])
    _MultilinkResponse_callInformation._ext = []
    _MultilinkResponse_addConnection = SEQ(name=u'addConnection', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MultilinkResponse_addConnection_sequenceNumber = INT(name=u'sequenceNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'SequenceNumber')))
    __MultilinkResponse_addConnection_responseCode = CHOICE(name=u'responseCode', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ___MultilinkResponse_addConnection_responseCode_accepted = NULL(name=u'accepted', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___MultilinkResponse_addConnection_responseCode_rejected = CHOICE(name=u'rejected', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ____MultilinkResponse_addConnection_responseCode_rejected_connectionsNotAvailable = NULL(name=u'connectionsNotAvailable', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ____MultilinkResponse_addConnection_responseCode_rejected_userRejected = NULL(name=u'userRejected', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___MultilinkResponse_addConnection_responseCode_rejected._cont = ASN1Dict([
        (u'connectionsNotAvailable', ____MultilinkResponse_addConnection_responseCode_rejected_connectionsNotAvailable),
        (u'userRejected', ____MultilinkResponse_addConnection_responseCode_rejected_userRejected),
        ])
    ___MultilinkResponse_addConnection_responseCode_rejected._ext = []
    __MultilinkResponse_addConnection_responseCode._cont = ASN1Dict([
        (u'accepted', ___MultilinkResponse_addConnection_responseCode_accepted),
        (u'rejected', ___MultilinkResponse_addConnection_responseCode_rejected),
        ])
    __MultilinkResponse_addConnection_responseCode._ext = []
    _MultilinkResponse_addConnection._cont = ASN1Dict([
        (u'sequenceNumber', __MultilinkResponse_addConnection_sequenceNumber),
        (u'responseCode', __MultilinkResponse_addConnection_responseCode),
        ])
    _MultilinkResponse_addConnection._ext = []
    _MultilinkResponse_removeConnection = SEQ(name=u'removeConnection', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MultilinkResponse_removeConnection_connectionIdentifier = SEQ(name=u'connectionIdentifier', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'ConnectionIdentifier')))
    _MultilinkResponse_removeConnection._cont = ASN1Dict([
        (u'connectionIdentifier', __MultilinkResponse_removeConnection_connectionIdentifier),
        ])
    _MultilinkResponse_removeConnection._ext = []
    _MultilinkResponse_maximumHeaderInterval = SEQ(name=u'maximumHeaderInterval', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MultilinkResponse_maximumHeaderInterval_currentInterval = INT(name=u'currentInterval', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MultilinkResponse_maximumHeaderInterval_currentInterval._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    _MultilinkResponse_maximumHeaderInterval._cont = ASN1Dict([
        (u'currentInterval', __MultilinkResponse_maximumHeaderInterval_currentInterval),
        ])
    _MultilinkResponse_maximumHeaderInterval._ext = []
    MultilinkResponse._cont = ASN1Dict([
        (u'nonStandard', _MultilinkResponse_nonStandard),
        (u'callInformation', _MultilinkResponse_callInformation),
        (u'addConnection', _MultilinkResponse_addConnection),
        (u'removeConnection', _MultilinkResponse_removeConnection),
        (u'maximumHeaderInterval', _MultilinkResponse_maximumHeaderInterval),
        ])
    MultilinkResponse._ext = []
    
    #-----< MultilinkIndication >-----#
    MultilinkIndication = CHOICE(name=u'MultilinkIndication', mode=MODE_TYPE)
    _MultilinkIndication_nonStandard = SEQ(name=u'nonStandard', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardMessage')))
    _MultilinkIndication_crcDesired = SEQ(name=u'crcDesired', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MultilinkIndication_crcDesired._cont = ASN1Dict([
        ])
    _MultilinkIndication_crcDesired._ext = []
    _MultilinkIndication_excessiveError = SEQ(name=u'excessiveError', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MultilinkIndication_excessiveError_connectionIdentifier = SEQ(name=u'connectionIdentifier', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'ConnectionIdentifier')))
    _MultilinkIndication_excessiveError._cont = ASN1Dict([
        (u'connectionIdentifier', __MultilinkIndication_excessiveError_connectionIdentifier),
        ])
    _MultilinkIndication_excessiveError._ext = []
    MultilinkIndication._cont = ASN1Dict([
        (u'nonStandard', _MultilinkIndication_nonStandard),
        (u'crcDesired', _MultilinkIndication_crcDesired),
        (u'excessiveError', _MultilinkIndication_excessiveError),
        ])
    MultilinkIndication._ext = []
    
    #-----< DialingInformation >-----#
    DialingInformation = CHOICE(name=u'DialingInformation', mode=MODE_TYPE)
    _DialingInformation_nonStandard = SEQ(name=u'nonStandard', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardMessage')))
    _DialingInformation_differential = SET_OF(name=u'differential', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __DialingInformation_differential__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DialingInformationNumber')))
    _DialingInformation_differential._cont = __DialingInformation_differential__item_
    _DialingInformation_differential._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    _DialingInformation_infoNotAvailable = INT(name=u'infoNotAvailable', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _DialingInformation_infoNotAvailable._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    DialingInformation._cont = ASN1Dict([
        (u'nonStandard', _DialingInformation_nonStandard),
        (u'differential', _DialingInformation_differential),
        (u'infoNotAvailable', _DialingInformation_infoNotAvailable),
        ])
    DialingInformation._ext = []
    
    #-----< DialingInformationNumber >-----#
    DialingInformationNumber = SEQ(name=u'DialingInformationNumber', mode=MODE_TYPE)
    _DialingInformationNumber_networkAddress = STR_NUM(name=u'networkAddress', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _DialingInformationNumber_networkAddress._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=40)], ev=None, er=[])
    _DialingInformationNumber_subAddress = STR_IA5(name=u'subAddress', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _DialingInformationNumber_subAddress._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=40)], ev=None, er=[])
    _DialingInformationNumber_networkType = SET_OF(name=u'networkType', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __DialingInformationNumber_networkType__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'DialingInformationNetworkType')))
    _DialingInformationNumber_networkType._cont = __DialingInformationNumber_networkType__item_
    _DialingInformationNumber_networkType._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=255)], ev=None, er=[])
    DialingInformationNumber._cont = ASN1Dict([
        (u'networkAddress', _DialingInformationNumber_networkAddress),
        (u'subAddress', _DialingInformationNumber_subAddress),
        (u'networkType', _DialingInformationNumber_networkType),
        ])
    DialingInformationNumber._ext = []
    
    #-----< DialingInformationNetworkType >-----#
    DialingInformationNetworkType = CHOICE(name=u'DialingInformationNetworkType', mode=MODE_TYPE)
    _DialingInformationNetworkType_nonStandard = SEQ(name=u'nonStandard', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardMessage')))
    _DialingInformationNetworkType_n_isdn = NULL(name=u'n-isdn', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _DialingInformationNetworkType_gstn = NULL(name=u'gstn', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _DialingInformationNetworkType_mobile = NULL(name=u'mobile', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    DialingInformationNetworkType._cont = ASN1Dict([
        (u'nonStandard', _DialingInformationNetworkType_nonStandard),
        (u'n-isdn', _DialingInformationNetworkType_n_isdn),
        (u'gstn', _DialingInformationNetworkType_gstn),
        (u'mobile', _DialingInformationNetworkType_mobile),
        ])
    DialingInformationNetworkType._ext = [u'mobile']
    
    #-----< ConnectionIdentifier >-----#
    ConnectionIdentifier = SEQ(name=u'ConnectionIdentifier', mode=MODE_TYPE)
    _ConnectionIdentifier_channelTag = INT(name=u'channelTag', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ConnectionIdentifier_channelTag._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4294967295)], ev=None, er=[])
    _ConnectionIdentifier_sequenceNumber = INT(name=u'sequenceNumber', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ConnectionIdentifier_sequenceNumber._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4294967295)], ev=None, er=[])
    ConnectionIdentifier._cont = ASN1Dict([
        (u'channelTag', _ConnectionIdentifier_channelTag),
        (u'sequenceNumber', _ConnectionIdentifier_sequenceNumber),
        ])
    ConnectionIdentifier._ext = []
    
    #-----< MaximumBitRate >-----#
    MaximumBitRate = INT(name=u'MaximumBitRate', mode=MODE_TYPE)
    MaximumBitRate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4294967295)], ev=None, er=[])
    
    #-----< LogicalChannelRateRequest >-----#
    LogicalChannelRateRequest = SEQ(name=u'LogicalChannelRateRequest', mode=MODE_TYPE)
    _LogicalChannelRateRequest_sequenceNumber = INT(name=u'sequenceNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'SequenceNumber')))
    _LogicalChannelRateRequest_logicalChannelNumber = INT(name=u'logicalChannelNumber', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelNumber')))
    _LogicalChannelRateRequest_maximumBitRate = INT(name=u'maximumBitRate', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MaximumBitRate')))
    LogicalChannelRateRequest._cont = ASN1Dict([
        (u'sequenceNumber', _LogicalChannelRateRequest_sequenceNumber),
        (u'logicalChannelNumber', _LogicalChannelRateRequest_logicalChannelNumber),
        (u'maximumBitRate', _LogicalChannelRateRequest_maximumBitRate),
        ])
    LogicalChannelRateRequest._ext = []
    
    #-----< LogicalChannelRateAcknowledge >-----#
    LogicalChannelRateAcknowledge = SEQ(name=u'LogicalChannelRateAcknowledge', mode=MODE_TYPE)
    _LogicalChannelRateAcknowledge_sequenceNumber = INT(name=u'sequenceNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'SequenceNumber')))
    _LogicalChannelRateAcknowledge_logicalChannelNumber = INT(name=u'logicalChannelNumber', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelNumber')))
    _LogicalChannelRateAcknowledge_maximumBitRate = INT(name=u'maximumBitRate', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MaximumBitRate')))
    LogicalChannelRateAcknowledge._cont = ASN1Dict([
        (u'sequenceNumber', _LogicalChannelRateAcknowledge_sequenceNumber),
        (u'logicalChannelNumber', _LogicalChannelRateAcknowledge_logicalChannelNumber),
        (u'maximumBitRate', _LogicalChannelRateAcknowledge_maximumBitRate),
        ])
    LogicalChannelRateAcknowledge._ext = []
    
    #-----< LogicalChannelRateReject >-----#
    LogicalChannelRateReject = SEQ(name=u'LogicalChannelRateReject', mode=MODE_TYPE)
    _LogicalChannelRateReject_sequenceNumber = INT(name=u'sequenceNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'SequenceNumber')))
    _LogicalChannelRateReject_logicalChannelNumber = INT(name=u'logicalChannelNumber', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelNumber')))
    _LogicalChannelRateReject_rejectReason = CHOICE(name=u'rejectReason', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelRateRejectReason')))
    _LogicalChannelRateReject_currentMaximumBitRate = INT(name=u'currentMaximumBitRate', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MaximumBitRate')), opt=True)
    LogicalChannelRateReject._cont = ASN1Dict([
        (u'sequenceNumber', _LogicalChannelRateReject_sequenceNumber),
        (u'logicalChannelNumber', _LogicalChannelRateReject_logicalChannelNumber),
        (u'rejectReason', _LogicalChannelRateReject_rejectReason),
        (u'currentMaximumBitRate', _LogicalChannelRateReject_currentMaximumBitRate),
        ])
    LogicalChannelRateReject._ext = []
    
    #-----< LogicalChannelRateRejectReason >-----#
    LogicalChannelRateRejectReason = CHOICE(name=u'LogicalChannelRateRejectReason', mode=MODE_TYPE)
    _LogicalChannelRateRejectReason_undefinedReason = NULL(name=u'undefinedReason', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _LogicalChannelRateRejectReason_insufficientResources = NULL(name=u'insufficientResources', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    LogicalChannelRateRejectReason._cont = ASN1Dict([
        (u'undefinedReason', _LogicalChannelRateRejectReason_undefinedReason),
        (u'insufficientResources', _LogicalChannelRateRejectReason_insufficientResources),
        ])
    LogicalChannelRateRejectReason._ext = []
    
    #-----< LogicalChannelRateRelease >-----#
    LogicalChannelRateRelease = SEQ(name=u'LogicalChannelRateRelease', mode=MODE_TYPE)
    LogicalChannelRateRelease._cont = ASN1Dict([
        ])
    LogicalChannelRateRelease._ext = []
    
    #-----< SendTerminalCapabilitySet >-----#
    SendTerminalCapabilitySet = CHOICE(name=u'SendTerminalCapabilitySet', mode=MODE_TYPE)
    _SendTerminalCapabilitySet_specificRequest = SEQ(name=u'specificRequest', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __SendTerminalCapabilitySet_specificRequest_multiplexCapability = BOOL(name=u'multiplexCapability', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __SendTerminalCapabilitySet_specificRequest_capabilityTableEntryNumbers = SET_OF(name=u'capabilityTableEntryNumbers', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    ___SendTerminalCapabilitySet_specificRequest_capabilityTableEntryNumbers__item_ = INT(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'CapabilityTableEntryNumber')))
    __SendTerminalCapabilitySet_specificRequest_capabilityTableEntryNumbers._cont = ___SendTerminalCapabilitySet_specificRequest_capabilityTableEntryNumbers__item_
    __SendTerminalCapabilitySet_specificRequest_capabilityTableEntryNumbers._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    __SendTerminalCapabilitySet_specificRequest_capabilityDescriptorNumbers = SET_OF(name=u'capabilityDescriptorNumbers', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    ___SendTerminalCapabilitySet_specificRequest_capabilityDescriptorNumbers__item_ = INT(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'CapabilityDescriptorNumber')))
    __SendTerminalCapabilitySet_specificRequest_capabilityDescriptorNumbers._cont = ___SendTerminalCapabilitySet_specificRequest_capabilityDescriptorNumbers__item_
    __SendTerminalCapabilitySet_specificRequest_capabilityDescriptorNumbers._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    _SendTerminalCapabilitySet_specificRequest._cont = ASN1Dict([
        (u'multiplexCapability', __SendTerminalCapabilitySet_specificRequest_multiplexCapability),
        (u'capabilityTableEntryNumbers', __SendTerminalCapabilitySet_specificRequest_capabilityTableEntryNumbers),
        (u'capabilityDescriptorNumbers', __SendTerminalCapabilitySet_specificRequest_capabilityDescriptorNumbers),
        ])
    _SendTerminalCapabilitySet_specificRequest._ext = []
    _SendTerminalCapabilitySet_genericRequest = NULL(name=u'genericRequest', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    SendTerminalCapabilitySet._cont = ASN1Dict([
        (u'specificRequest', _SendTerminalCapabilitySet_specificRequest),
        (u'genericRequest', _SendTerminalCapabilitySet_genericRequest),
        ])
    SendTerminalCapabilitySet._ext = []
    
    #-----< EncryptionCommand >-----#
    EncryptionCommand = CHOICE(name=u'EncryptionCommand', mode=MODE_TYPE)
    _EncryptionCommand_encryptionSE = OCT_STR(name=u'encryptionSE', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EncryptionCommand_encryptionIVRequest = NULL(name=u'encryptionIVRequest', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EncryptionCommand_encryptionAlgorithmID = SEQ(name=u'encryptionAlgorithmID', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __EncryptionCommand_encryptionAlgorithmID_h233AlgorithmIdentifier = INT(name=u'h233AlgorithmIdentifier', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'SequenceNumber')))
    __EncryptionCommand_encryptionAlgorithmID_associatedAlgorithm = SEQ(name=u'associatedAlgorithm', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')))
    _EncryptionCommand_encryptionAlgorithmID._cont = ASN1Dict([
        (u'h233AlgorithmIdentifier', __EncryptionCommand_encryptionAlgorithmID_h233AlgorithmIdentifier),
        (u'associatedAlgorithm', __EncryptionCommand_encryptionAlgorithmID_associatedAlgorithm),
        ])
    _EncryptionCommand_encryptionAlgorithmID._ext = None
    EncryptionCommand._cont = ASN1Dict([
        (u'encryptionSE', _EncryptionCommand_encryptionSE),
        (u'encryptionIVRequest', _EncryptionCommand_encryptionIVRequest),
        (u'encryptionAlgorithmID', _EncryptionCommand_encryptionAlgorithmID),
        ])
    EncryptionCommand._ext = []
    
    #-----< FlowControlCommand >-----#
    FlowControlCommand = SEQ(name=u'FlowControlCommand', mode=MODE_TYPE)
    _FlowControlCommand_scope = CHOICE(name=u'scope', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __FlowControlCommand_scope_logicalChannelNumber = INT(name=u'logicalChannelNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelNumber')))
    __FlowControlCommand_scope_resourceID = INT(name=u'resourceID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __FlowControlCommand_scope_resourceID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    __FlowControlCommand_scope_wholeMultiplex = NULL(name=u'wholeMultiplex', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _FlowControlCommand_scope._cont = ASN1Dict([
        (u'logicalChannelNumber', __FlowControlCommand_scope_logicalChannelNumber),
        (u'resourceID', __FlowControlCommand_scope_resourceID),
        (u'wholeMultiplex', __FlowControlCommand_scope_wholeMultiplex),
        ])
    _FlowControlCommand_scope._ext = None
    _FlowControlCommand_restriction = CHOICE(name=u'restriction', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __FlowControlCommand_restriction_maximumBitRate = INT(name=u'maximumBitRate', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __FlowControlCommand_restriction_maximumBitRate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=16777215)], ev=None, er=[])
    __FlowControlCommand_restriction_noRestriction = NULL(name=u'noRestriction', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _FlowControlCommand_restriction._cont = ASN1Dict([
        (u'maximumBitRate', __FlowControlCommand_restriction_maximumBitRate),
        (u'noRestriction', __FlowControlCommand_restriction_noRestriction),
        ])
    _FlowControlCommand_restriction._ext = None
    FlowControlCommand._cont = ASN1Dict([
        (u'scope', _FlowControlCommand_scope),
        (u'restriction', _FlowControlCommand_restriction),
        ])
    FlowControlCommand._ext = []
    
    #-----< EndSessionCommand >-----#
    EndSessionCommand = CHOICE(name=u'EndSessionCommand', mode=MODE_TYPE)
    _EndSessionCommand_nonStandard = SEQ(name=u'nonStandard', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')))
    _EndSessionCommand_disconnect = NULL(name=u'disconnect', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EndSessionCommand_gstnOptions = CHOICE(name=u'gstnOptions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __EndSessionCommand_gstnOptions_telephonyMode = NULL(name=u'telephonyMode', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __EndSessionCommand_gstnOptions_v8bis = NULL(name=u'v8bis', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __EndSessionCommand_gstnOptions_v34DSVD = NULL(name=u'v34DSVD', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __EndSessionCommand_gstnOptions_v34DuplexFAX = NULL(name=u'v34DuplexFAX', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __EndSessionCommand_gstnOptions_v34H324 = NULL(name=u'v34H324', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EndSessionCommand_gstnOptions._cont = ASN1Dict([
        (u'telephonyMode', __EndSessionCommand_gstnOptions_telephonyMode),
        (u'v8bis', __EndSessionCommand_gstnOptions_v8bis),
        (u'v34DSVD', __EndSessionCommand_gstnOptions_v34DSVD),
        (u'v34DuplexFAX', __EndSessionCommand_gstnOptions_v34DuplexFAX),
        (u'v34H324', __EndSessionCommand_gstnOptions_v34H324),
        ])
    _EndSessionCommand_gstnOptions._ext = []
    _EndSessionCommand_isdnOptions = CHOICE(name=u'isdnOptions', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __EndSessionCommand_isdnOptions_telephonyMode = NULL(name=u'telephonyMode', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __EndSessionCommand_isdnOptions_v140 = NULL(name=u'v140', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __EndSessionCommand_isdnOptions_terminalOnHold = NULL(name=u'terminalOnHold', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EndSessionCommand_isdnOptions._cont = ASN1Dict([
        (u'telephonyMode', __EndSessionCommand_isdnOptions_telephonyMode),
        (u'v140', __EndSessionCommand_isdnOptions_v140),
        (u'terminalOnHold', __EndSessionCommand_isdnOptions_terminalOnHold),
        ])
    _EndSessionCommand_isdnOptions._ext = []
    _EndSessionCommand_genericInformation = SEQ_OF(name=u'genericInformation', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __EndSessionCommand_genericInformation__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'GenericInformation')))
    _EndSessionCommand_genericInformation._cont = __EndSessionCommand_genericInformation__item_
    EndSessionCommand._cont = ASN1Dict([
        (u'nonStandard', _EndSessionCommand_nonStandard),
        (u'disconnect', _EndSessionCommand_disconnect),
        (u'gstnOptions', _EndSessionCommand_gstnOptions),
        (u'isdnOptions', _EndSessionCommand_isdnOptions),
        (u'genericInformation', _EndSessionCommand_genericInformation),
        ])
    EndSessionCommand._ext = [u'isdnOptions', u'genericInformation']
    
    #-----< ConferenceCommand >-----#
    ConferenceCommand = CHOICE(name=u'ConferenceCommand', mode=MODE_TYPE)
    _ConferenceCommand_broadcastMyLogicalChannel = INT(name=u'broadcastMyLogicalChannel', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelNumber')))
    _ConferenceCommand_cancelBroadcastMyLogicalChannel = INT(name=u'cancelBroadcastMyLogicalChannel', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelNumber')))
    _ConferenceCommand_makeTerminalBroadcaster = SEQ(name=u'makeTerminalBroadcaster', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TerminalLabel')))
    _ConferenceCommand_cancelMakeTerminalBroadcaster = NULL(name=u'cancelMakeTerminalBroadcaster', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ConferenceCommand_sendThisSource = SEQ(name=u'sendThisSource', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TerminalLabel')))
    _ConferenceCommand_cancelSendThisSource = NULL(name=u'cancelSendThisSource', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ConferenceCommand_dropConference = NULL(name=u'dropConference', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ConferenceCommand_substituteConferenceIDCommand = SEQ(name=u'substituteConferenceIDCommand', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'SubstituteConferenceIDCommand')))
    ConferenceCommand._cont = ASN1Dict([
        (u'broadcastMyLogicalChannel', _ConferenceCommand_broadcastMyLogicalChannel),
        (u'cancelBroadcastMyLogicalChannel', _ConferenceCommand_cancelBroadcastMyLogicalChannel),
        (u'makeTerminalBroadcaster', _ConferenceCommand_makeTerminalBroadcaster),
        (u'cancelMakeTerminalBroadcaster', _ConferenceCommand_cancelMakeTerminalBroadcaster),
        (u'sendThisSource', _ConferenceCommand_sendThisSource),
        (u'cancelSendThisSource', _ConferenceCommand_cancelSendThisSource),
        (u'dropConference', _ConferenceCommand_dropConference),
        (u'substituteConferenceIDCommand', _ConferenceCommand_substituteConferenceIDCommand),
        ])
    ConferenceCommand._ext = [u'substituteConferenceIDCommand']
    
    #-----< SubstituteConferenceIDCommand >-----#
    SubstituteConferenceIDCommand = SEQ(name=u'SubstituteConferenceIDCommand', mode=MODE_TYPE)
    _SubstituteConferenceIDCommand_conferenceIdentifier = OCT_STR(name=u'conferenceIdentifier', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _SubstituteConferenceIDCommand_conferenceIdentifier._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    SubstituteConferenceIDCommand._cont = ASN1Dict([
        (u'conferenceIdentifier', _SubstituteConferenceIDCommand_conferenceIdentifier),
        ])
    SubstituteConferenceIDCommand._ext = []
    
    #-----< EncryptionUpdateDirection >-----#
    EncryptionUpdateDirection = CHOICE(name=u'EncryptionUpdateDirection', mode=MODE_TYPE)
    _EncryptionUpdateDirection_masterToSlave = NULL(name=u'masterToSlave', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EncryptionUpdateDirection_slaveToMaster = NULL(name=u'slaveToMaster', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    EncryptionUpdateDirection._cont = ASN1Dict([
        (u'masterToSlave', _EncryptionUpdateDirection_masterToSlave),
        (u'slaveToMaster', _EncryptionUpdateDirection_slaveToMaster),
        ])
    EncryptionUpdateDirection._ext = []
    
    #-----< MiscellaneousCommand >-----#
    MiscellaneousCommand = SEQ(name=u'MiscellaneousCommand', mode=MODE_TYPE)
    _MiscellaneousCommand_logicalChannelNumber = INT(name=u'logicalChannelNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelNumber')))
    _MiscellaneousCommand_type = CHOICE(name=u'type', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __MiscellaneousCommand_type_equaliseDelay = NULL(name=u'equaliseDelay', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MiscellaneousCommand_type_zeroDelay = NULL(name=u'zeroDelay', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MiscellaneousCommand_type_multipointModeCommand = NULL(name=u'multipointModeCommand', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MiscellaneousCommand_type_cancelMultipointModeCommand = NULL(name=u'cancelMultipointModeCommand', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MiscellaneousCommand_type_videoFreezePicture = NULL(name=u'videoFreezePicture', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MiscellaneousCommand_type_videoFastUpdatePicture = NULL(name=u'videoFastUpdatePicture', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MiscellaneousCommand_type_videoFastUpdateGOB = SEQ(name=u'videoFastUpdateGOB', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___MiscellaneousCommand_type_videoFastUpdateGOB_firstGOB = INT(name=u'firstGOB', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___MiscellaneousCommand_type_videoFastUpdateGOB_firstGOB._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=17)], ev=None, er=[])
    ___MiscellaneousCommand_type_videoFastUpdateGOB_numberOfGOBs = INT(name=u'numberOfGOBs', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___MiscellaneousCommand_type_videoFastUpdateGOB_numberOfGOBs._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=18)], ev=None, er=[])
    __MiscellaneousCommand_type_videoFastUpdateGOB._cont = ASN1Dict([
        (u'firstGOB', ___MiscellaneousCommand_type_videoFastUpdateGOB_firstGOB),
        (u'numberOfGOBs', ___MiscellaneousCommand_type_videoFastUpdateGOB_numberOfGOBs),
        ])
    __MiscellaneousCommand_type_videoFastUpdateGOB._ext = None
    __MiscellaneousCommand_type_videoTemporalSpatialTradeOff = INT(name=u'videoTemporalSpatialTradeOff', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MiscellaneousCommand_type_videoTemporalSpatialTradeOff._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=31)], ev=None, er=[])
    __MiscellaneousCommand_type_videoSendSyncEveryGOB = NULL(name=u'videoSendSyncEveryGOB', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MiscellaneousCommand_type_videoSendSyncEveryGOBCancel = NULL(name=u'videoSendSyncEveryGOBCancel', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MiscellaneousCommand_type_videoFastUpdateMB = SEQ(name=u'videoFastUpdateMB', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___MiscellaneousCommand_type_videoFastUpdateMB_firstGOB = INT(name=u'firstGOB', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    ___MiscellaneousCommand_type_videoFastUpdateMB_firstGOB._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    ___MiscellaneousCommand_type_videoFastUpdateMB_firstMB = INT(name=u'firstMB', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    ___MiscellaneousCommand_type_videoFastUpdateMB_firstMB._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8192)], ev=None, er=[])
    ___MiscellaneousCommand_type_videoFastUpdateMB_numberOfMBs = INT(name=u'numberOfMBs', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___MiscellaneousCommand_type_videoFastUpdateMB_numberOfMBs._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8192)], ev=None, er=[])
    __MiscellaneousCommand_type_videoFastUpdateMB._cont = ASN1Dict([
        (u'firstGOB', ___MiscellaneousCommand_type_videoFastUpdateMB_firstGOB),
        (u'firstMB', ___MiscellaneousCommand_type_videoFastUpdateMB_firstMB),
        (u'numberOfMBs', ___MiscellaneousCommand_type_videoFastUpdateMB_numberOfMBs),
        ])
    __MiscellaneousCommand_type_videoFastUpdateMB._ext = []
    __MiscellaneousCommand_type_maxH223MUXPDUsize = INT(name=u'maxH223MUXPDUsize', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MiscellaneousCommand_type_maxH223MUXPDUsize._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    __MiscellaneousCommand_type_encryptionUpdate = SEQ(name=u'encryptionUpdate', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'EncryptionSync')))
    __MiscellaneousCommand_type_encryptionUpdateRequest = SEQ(name=u'encryptionUpdateRequest', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'EncryptionUpdateRequest')))
    __MiscellaneousCommand_type_switchReceiveMediaOff = NULL(name=u'switchReceiveMediaOff', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MiscellaneousCommand_type_switchReceiveMediaOn = NULL(name=u'switchReceiveMediaOn', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MiscellaneousCommand_type_progressiveRefinementStart = SEQ(name=u'progressiveRefinementStart', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___MiscellaneousCommand_type_progressiveRefinementStart_repeatCount = CHOICE(name=u'repeatCount', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ____MiscellaneousCommand_type_progressiveRefinementStart_repeatCount_doOneProgression = NULL(name=u'doOneProgression', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ____MiscellaneousCommand_type_progressiveRefinementStart_repeatCount_doContinuousProgressions = NULL(name=u'doContinuousProgressions', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ____MiscellaneousCommand_type_progressiveRefinementStart_repeatCount_doOneIndependentProgression = NULL(name=u'doOneIndependentProgression', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ____MiscellaneousCommand_type_progressiveRefinementStart_repeatCount_doContinuousIndependentProgressions = NULL(name=u'doContinuousIndependentProgressions', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___MiscellaneousCommand_type_progressiveRefinementStart_repeatCount._cont = ASN1Dict([
        (u'doOneProgression', ____MiscellaneousCommand_type_progressiveRefinementStart_repeatCount_doOneProgression),
        (u'doContinuousProgressions', ____MiscellaneousCommand_type_progressiveRefinementStart_repeatCount_doContinuousProgressions),
        (u'doOneIndependentProgression', ____MiscellaneousCommand_type_progressiveRefinementStart_repeatCount_doOneIndependentProgression),
        (u'doContinuousIndependentProgressions', ____MiscellaneousCommand_type_progressiveRefinementStart_repeatCount_doContinuousIndependentProgressions),
        ])
    ___MiscellaneousCommand_type_progressiveRefinementStart_repeatCount._ext = []
    __MiscellaneousCommand_type_progressiveRefinementStart._cont = ASN1Dict([
        (u'repeatCount', ___MiscellaneousCommand_type_progressiveRefinementStart_repeatCount),
        ])
    __MiscellaneousCommand_type_progressiveRefinementStart._ext = []
    __MiscellaneousCommand_type_progressiveRefinementAbortOne = NULL(name=u'progressiveRefinementAbortOne', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MiscellaneousCommand_type_progressiveRefinementAbortContinuous = NULL(name=u'progressiveRefinementAbortContinuous', mode=MODE_TYPE, tag=(18, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MiscellaneousCommand_type_videoBadMBs = SEQ(name=u'videoBadMBs', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___MiscellaneousCommand_type_videoBadMBs_firstMB = INT(name=u'firstMB', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___MiscellaneousCommand_type_videoBadMBs_firstMB._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=9216)], ev=None, er=[])
    ___MiscellaneousCommand_type_videoBadMBs_numberOfMBs = INT(name=u'numberOfMBs', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___MiscellaneousCommand_type_videoBadMBs_numberOfMBs._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=9216)], ev=None, er=[])
    ___MiscellaneousCommand_type_videoBadMBs_temporalReference = INT(name=u'temporalReference', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___MiscellaneousCommand_type_videoBadMBs_temporalReference._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=1023)], ev=None, er=[])
    __MiscellaneousCommand_type_videoBadMBs._cont = ASN1Dict([
        (u'firstMB', ___MiscellaneousCommand_type_videoBadMBs_firstMB),
        (u'numberOfMBs', ___MiscellaneousCommand_type_videoBadMBs_numberOfMBs),
        (u'temporalReference', ___MiscellaneousCommand_type_videoBadMBs_temporalReference),
        ])
    __MiscellaneousCommand_type_videoBadMBs._ext = []
    __MiscellaneousCommand_type_lostPicture = SEQ_OF(name=u'lostPicture', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___MiscellaneousCommand_type_lostPicture__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'PictureReference')))
    __MiscellaneousCommand_type_lostPicture._cont = ___MiscellaneousCommand_type_lostPicture__item_
    __MiscellaneousCommand_type_lostPartialPicture = SEQ(name=u'lostPartialPicture', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___MiscellaneousCommand_type_lostPartialPicture_pictureReference = CHOICE(name=u'pictureReference', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'PictureReference')))
    ___MiscellaneousCommand_type_lostPartialPicture_firstMB = INT(name=u'firstMB', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___MiscellaneousCommand_type_lostPartialPicture_firstMB._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=9216)], ev=None, er=[])
    ___MiscellaneousCommand_type_lostPartialPicture_numberOfMBs = INT(name=u'numberOfMBs', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___MiscellaneousCommand_type_lostPartialPicture_numberOfMBs._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=9216)], ev=None, er=[])
    __MiscellaneousCommand_type_lostPartialPicture._cont = ASN1Dict([
        (u'pictureReference', ___MiscellaneousCommand_type_lostPartialPicture_pictureReference),
        (u'firstMB', ___MiscellaneousCommand_type_lostPartialPicture_firstMB),
        (u'numberOfMBs', ___MiscellaneousCommand_type_lostPartialPicture_numberOfMBs),
        ])
    __MiscellaneousCommand_type_lostPartialPicture._ext = []
    __MiscellaneousCommand_type_recoveryReferencePicture = SEQ_OF(name=u'recoveryReferencePicture', mode=MODE_TYPE, tag=(22, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___MiscellaneousCommand_type_recoveryReferencePicture__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'PictureReference')))
    __MiscellaneousCommand_type_recoveryReferencePicture._cont = ___MiscellaneousCommand_type_recoveryReferencePicture__item_
    __MiscellaneousCommand_type_encryptionUpdateCommand = SEQ(name=u'encryptionUpdateCommand', mode=MODE_TYPE, tag=(23, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___MiscellaneousCommand_type_encryptionUpdateCommand_encryptionSync = SEQ(name=u'encryptionSync', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'EncryptionSync')))
    ___MiscellaneousCommand_type_encryptionUpdateCommand_multiplePayloadStream = SEQ(name=u'multiplePayloadStream', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'MultiplePayloadStream')), opt=True)
    __MiscellaneousCommand_type_encryptionUpdateCommand._cont = ASN1Dict([
        (u'encryptionSync', ___MiscellaneousCommand_type_encryptionUpdateCommand_encryptionSync),
        (u'multiplePayloadStream', ___MiscellaneousCommand_type_encryptionUpdateCommand_multiplePayloadStream),
        ])
    __MiscellaneousCommand_type_encryptionUpdateCommand._ext = []
    __MiscellaneousCommand_type_encryptionUpdateAck = SEQ(name=u'encryptionUpdateAck', mode=MODE_TYPE, tag=(24, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___MiscellaneousCommand_type_encryptionUpdateAck_synchFlag = INT(name=u'synchFlag', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___MiscellaneousCommand_type_encryptionUpdateAck_synchFlag._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    __MiscellaneousCommand_type_encryptionUpdateAck._cont = ASN1Dict([
        (u'synchFlag', ___MiscellaneousCommand_type_encryptionUpdateAck_synchFlag),
        ])
    __MiscellaneousCommand_type_encryptionUpdateAck._ext = []
    _MiscellaneousCommand_type._cont = ASN1Dict([
        (u'equaliseDelay', __MiscellaneousCommand_type_equaliseDelay),
        (u'zeroDelay', __MiscellaneousCommand_type_zeroDelay),
        (u'multipointModeCommand', __MiscellaneousCommand_type_multipointModeCommand),
        (u'cancelMultipointModeCommand', __MiscellaneousCommand_type_cancelMultipointModeCommand),
        (u'videoFreezePicture', __MiscellaneousCommand_type_videoFreezePicture),
        (u'videoFastUpdatePicture', __MiscellaneousCommand_type_videoFastUpdatePicture),
        (u'videoFastUpdateGOB', __MiscellaneousCommand_type_videoFastUpdateGOB),
        (u'videoTemporalSpatialTradeOff', __MiscellaneousCommand_type_videoTemporalSpatialTradeOff),
        (u'videoSendSyncEveryGOB', __MiscellaneousCommand_type_videoSendSyncEveryGOB),
        (u'videoSendSyncEveryGOBCancel', __MiscellaneousCommand_type_videoSendSyncEveryGOBCancel),
        (u'videoFastUpdateMB', __MiscellaneousCommand_type_videoFastUpdateMB),
        (u'maxH223MUXPDUsize', __MiscellaneousCommand_type_maxH223MUXPDUsize),
        (u'encryptionUpdate', __MiscellaneousCommand_type_encryptionUpdate),
        (u'encryptionUpdateRequest', __MiscellaneousCommand_type_encryptionUpdateRequest),
        (u'switchReceiveMediaOff', __MiscellaneousCommand_type_switchReceiveMediaOff),
        (u'switchReceiveMediaOn', __MiscellaneousCommand_type_switchReceiveMediaOn),
        (u'progressiveRefinementStart', __MiscellaneousCommand_type_progressiveRefinementStart),
        (u'progressiveRefinementAbortOne', __MiscellaneousCommand_type_progressiveRefinementAbortOne),
        (u'progressiveRefinementAbortContinuous', __MiscellaneousCommand_type_progressiveRefinementAbortContinuous),
        (u'videoBadMBs', __MiscellaneousCommand_type_videoBadMBs),
        (u'lostPicture', __MiscellaneousCommand_type_lostPicture),
        (u'lostPartialPicture', __MiscellaneousCommand_type_lostPartialPicture),
        (u'recoveryReferencePicture', __MiscellaneousCommand_type_recoveryReferencePicture),
        (u'encryptionUpdateCommand', __MiscellaneousCommand_type_encryptionUpdateCommand),
        (u'encryptionUpdateAck', __MiscellaneousCommand_type_encryptionUpdateAck),
        ])
    _MiscellaneousCommand_type._ext = [u'videoFastUpdateMB', u'maxH223MUXPDUsize', u'encryptionUpdate', u'encryptionUpdateRequest', u'switchReceiveMediaOff', u'switchReceiveMediaOn', u'progressiveRefinementStart', u'progressiveRefinementAbortOne', u'progressiveRefinementAbortContinuous', u'videoBadMBs', u'lostPicture', u'lostPartialPicture', u'recoveryReferencePicture', u'encryptionUpdateCommand', u'encryptionUpdateAck']
    _MiscellaneousCommand_direction = CHOICE(name=u'direction', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'EncryptionUpdateDirection')), opt=True)
    MiscellaneousCommand._cont = ASN1Dict([
        (u'logicalChannelNumber', _MiscellaneousCommand_logicalChannelNumber),
        (u'type', _MiscellaneousCommand_type),
        (u'direction', _MiscellaneousCommand_direction),
        ])
    MiscellaneousCommand._ext = [u'direction']
    
    #-----< KeyProtectionMethod >-----#
    KeyProtectionMethod = SEQ(name=u'KeyProtectionMethod', mode=MODE_TYPE)
    _KeyProtectionMethod_secureChannel = BOOL(name=u'secureChannel', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _KeyProtectionMethod_sharedSecret = BOOL(name=u'sharedSecret', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _KeyProtectionMethod_certProtectedKey = BOOL(name=u'certProtectedKey', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    KeyProtectionMethod._cont = ASN1Dict([
        (u'secureChannel', _KeyProtectionMethod_secureChannel),
        (u'sharedSecret', _KeyProtectionMethod_sharedSecret),
        (u'certProtectedKey', _KeyProtectionMethod_certProtectedKey),
        ])
    KeyProtectionMethod._ext = []
    
    #-----< EncryptionUpdateRequest >-----#
    EncryptionUpdateRequest = SEQ(name=u'EncryptionUpdateRequest', mode=MODE_TYPE)
    _EncryptionUpdateRequest_keyProtectionMethod = SEQ(name=u'keyProtectionMethod', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'KeyProtectionMethod')), opt=True)
    _EncryptionUpdateRequest_synchFlag = INT(name=u'synchFlag', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _EncryptionUpdateRequest_synchFlag._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    EncryptionUpdateRequest._cont = ASN1Dict([
        (u'keyProtectionMethod', _EncryptionUpdateRequest_keyProtectionMethod),
        (u'synchFlag', _EncryptionUpdateRequest_synchFlag),
        ])
    EncryptionUpdateRequest._ext = [u'synchFlag']
    
    #-----< PictureReference >-----#
    PictureReference = CHOICE(name=u'PictureReference', mode=MODE_TYPE)
    _PictureReference_pictureNumber = INT(name=u'pictureNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _PictureReference_pictureNumber._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=1023)], ev=None, er=[])
    _PictureReference_longTermPictureIndex = INT(name=u'longTermPictureIndex', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _PictureReference_longTermPictureIndex._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    PictureReference._cont = ASN1Dict([
        (u'pictureNumber', _PictureReference_pictureNumber),
        (u'longTermPictureIndex', _PictureReference_longTermPictureIndex),
        ])
    PictureReference._ext = []
    
    #-----< H223MultiplexReconfiguration >-----#
    H223MultiplexReconfiguration = CHOICE(name=u'H223MultiplexReconfiguration', mode=MODE_TYPE)
    _H223MultiplexReconfiguration_h223ModeChange = CHOICE(name=u'h223ModeChange', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __H223MultiplexReconfiguration_h223ModeChange_toLevel0 = NULL(name=u'toLevel0', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H223MultiplexReconfiguration_h223ModeChange_toLevel1 = NULL(name=u'toLevel1', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H223MultiplexReconfiguration_h223ModeChange_toLevel2 = NULL(name=u'toLevel2', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H223MultiplexReconfiguration_h223ModeChange_toLevel2withOptionalHeader = NULL(name=u'toLevel2withOptionalHeader', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H223MultiplexReconfiguration_h223ModeChange._cont = ASN1Dict([
        (u'toLevel0', __H223MultiplexReconfiguration_h223ModeChange_toLevel0),
        (u'toLevel1', __H223MultiplexReconfiguration_h223ModeChange_toLevel1),
        (u'toLevel2', __H223MultiplexReconfiguration_h223ModeChange_toLevel2),
        (u'toLevel2withOptionalHeader', __H223MultiplexReconfiguration_h223ModeChange_toLevel2withOptionalHeader),
        ])
    _H223MultiplexReconfiguration_h223ModeChange._ext = []
    _H223MultiplexReconfiguration_h223AnnexADoubleFlag = CHOICE(name=u'h223AnnexADoubleFlag', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __H223MultiplexReconfiguration_h223AnnexADoubleFlag_start = NULL(name=u'start', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __H223MultiplexReconfiguration_h223AnnexADoubleFlag_stop = NULL(name=u'stop', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H223MultiplexReconfiguration_h223AnnexADoubleFlag._cont = ASN1Dict([
        (u'start', __H223MultiplexReconfiguration_h223AnnexADoubleFlag_start),
        (u'stop', __H223MultiplexReconfiguration_h223AnnexADoubleFlag_stop),
        ])
    _H223MultiplexReconfiguration_h223AnnexADoubleFlag._ext = []
    H223MultiplexReconfiguration._cont = ASN1Dict([
        (u'h223ModeChange', _H223MultiplexReconfiguration_h223ModeChange),
        (u'h223AnnexADoubleFlag', _H223MultiplexReconfiguration_h223AnnexADoubleFlag),
        ])
    H223MultiplexReconfiguration._ext = []
    
    #-----< NewATMVCCommand >-----#
    NewATMVCCommand = SEQ(name=u'NewATMVCCommand', mode=MODE_TYPE)
    _NewATMVCCommand_resourceID = INT(name=u'resourceID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NewATMVCCommand_resourceID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    _NewATMVCCommand_bitRate = INT(name=u'bitRate', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NewATMVCCommand_bitRate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    _NewATMVCCommand_bitRateLockedToPCRClock = BOOL(name=u'bitRateLockedToPCRClock', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NewATMVCCommand_bitRateLockedToNetworkClock = BOOL(name=u'bitRateLockedToNetworkClock', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NewATMVCCommand_aal = CHOICE(name=u'aal', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __NewATMVCCommand_aal_aal1 = SEQ(name=u'aal1', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___NewATMVCCommand_aal_aal1_clockRecovery = CHOICE(name=u'clockRecovery', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ____NewATMVCCommand_aal_aal1_clockRecovery_nullClockRecovery = NULL(name=u'nullClockRecovery', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ____NewATMVCCommand_aal_aal1_clockRecovery_srtsClockRecovery = NULL(name=u'srtsClockRecovery', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ____NewATMVCCommand_aal_aal1_clockRecovery_adaptiveClockRecovery = NULL(name=u'adaptiveClockRecovery', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___NewATMVCCommand_aal_aal1_clockRecovery._cont = ASN1Dict([
        (u'nullClockRecovery', ____NewATMVCCommand_aal_aal1_clockRecovery_nullClockRecovery),
        (u'srtsClockRecovery', ____NewATMVCCommand_aal_aal1_clockRecovery_srtsClockRecovery),
        (u'adaptiveClockRecovery', ____NewATMVCCommand_aal_aal1_clockRecovery_adaptiveClockRecovery),
        ])
    ___NewATMVCCommand_aal_aal1_clockRecovery._ext = []
    ___NewATMVCCommand_aal_aal1_errorCorrection = CHOICE(name=u'errorCorrection', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ____NewATMVCCommand_aal_aal1_errorCorrection_nullErrorCorrection = NULL(name=u'nullErrorCorrection', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ____NewATMVCCommand_aal_aal1_errorCorrection_longInterleaver = NULL(name=u'longInterleaver', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ____NewATMVCCommand_aal_aal1_errorCorrection_shortInterleaver = NULL(name=u'shortInterleaver', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ____NewATMVCCommand_aal_aal1_errorCorrection_errorCorrectionOnly = NULL(name=u'errorCorrectionOnly', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___NewATMVCCommand_aal_aal1_errorCorrection._cont = ASN1Dict([
        (u'nullErrorCorrection', ____NewATMVCCommand_aal_aal1_errorCorrection_nullErrorCorrection),
        (u'longInterleaver', ____NewATMVCCommand_aal_aal1_errorCorrection_longInterleaver),
        (u'shortInterleaver', ____NewATMVCCommand_aal_aal1_errorCorrection_shortInterleaver),
        (u'errorCorrectionOnly', ____NewATMVCCommand_aal_aal1_errorCorrection_errorCorrectionOnly),
        ])
    ___NewATMVCCommand_aal_aal1_errorCorrection._ext = []
    ___NewATMVCCommand_aal_aal1_structuredDataTransfer = BOOL(name=u'structuredDataTransfer', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___NewATMVCCommand_aal_aal1_partiallyFilledCells = BOOL(name=u'partiallyFilledCells', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __NewATMVCCommand_aal_aal1._cont = ASN1Dict([
        (u'clockRecovery', ___NewATMVCCommand_aal_aal1_clockRecovery),
        (u'errorCorrection', ___NewATMVCCommand_aal_aal1_errorCorrection),
        (u'structuredDataTransfer', ___NewATMVCCommand_aal_aal1_structuredDataTransfer),
        (u'partiallyFilledCells', ___NewATMVCCommand_aal_aal1_partiallyFilledCells),
        ])
    __NewATMVCCommand_aal_aal1._ext = []
    __NewATMVCCommand_aal_aal5 = SEQ(name=u'aal5', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___NewATMVCCommand_aal_aal5_forwardMaximumSDUSize = INT(name=u'forwardMaximumSDUSize', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___NewATMVCCommand_aal_aal5_forwardMaximumSDUSize._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    ___NewATMVCCommand_aal_aal5_backwardMaximumSDUSize = INT(name=u'backwardMaximumSDUSize', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___NewATMVCCommand_aal_aal5_backwardMaximumSDUSize._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    __NewATMVCCommand_aal_aal5._cont = ASN1Dict([
        (u'forwardMaximumSDUSize', ___NewATMVCCommand_aal_aal5_forwardMaximumSDUSize),
        (u'backwardMaximumSDUSize', ___NewATMVCCommand_aal_aal5_backwardMaximumSDUSize),
        ])
    __NewATMVCCommand_aal_aal5._ext = []
    _NewATMVCCommand_aal._cont = ASN1Dict([
        (u'aal1', __NewATMVCCommand_aal_aal1),
        (u'aal5', __NewATMVCCommand_aal_aal5),
        ])
    _NewATMVCCommand_aal._ext = []
    _NewATMVCCommand_multiplex = CHOICE(name=u'multiplex', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __NewATMVCCommand_multiplex_noMultiplex = NULL(name=u'noMultiplex', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __NewATMVCCommand_multiplex_transportStream = NULL(name=u'transportStream', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __NewATMVCCommand_multiplex_programStream = NULL(name=u'programStream', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NewATMVCCommand_multiplex._cont = ASN1Dict([
        (u'noMultiplex', __NewATMVCCommand_multiplex_noMultiplex),
        (u'transportStream', __NewATMVCCommand_multiplex_transportStream),
        (u'programStream', __NewATMVCCommand_multiplex_programStream),
        ])
    _NewATMVCCommand_multiplex._ext = []
    _NewATMVCCommand_reverseParameters = SEQ(name=u'reverseParameters', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __NewATMVCCommand_reverseParameters_bitRate = INT(name=u'bitRate', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __NewATMVCCommand_reverseParameters_bitRate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    __NewATMVCCommand_reverseParameters_bitRateLockedToPCRClock = BOOL(name=u'bitRateLockedToPCRClock', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __NewATMVCCommand_reverseParameters_bitRateLockedToNetworkClock = BOOL(name=u'bitRateLockedToNetworkClock', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __NewATMVCCommand_reverseParameters_multiplex = CHOICE(name=u'multiplex', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ___NewATMVCCommand_reverseParameters_multiplex_noMultiplex = NULL(name=u'noMultiplex', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___NewATMVCCommand_reverseParameters_multiplex_transportStream = NULL(name=u'transportStream', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___NewATMVCCommand_reverseParameters_multiplex_programStream = NULL(name=u'programStream', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __NewATMVCCommand_reverseParameters_multiplex._cont = ASN1Dict([
        (u'noMultiplex', ___NewATMVCCommand_reverseParameters_multiplex_noMultiplex),
        (u'transportStream', ___NewATMVCCommand_reverseParameters_multiplex_transportStream),
        (u'programStream', ___NewATMVCCommand_reverseParameters_multiplex_programStream),
        ])
    __NewATMVCCommand_reverseParameters_multiplex._ext = []
    _NewATMVCCommand_reverseParameters._cont = ASN1Dict([
        (u'bitRate', __NewATMVCCommand_reverseParameters_bitRate),
        (u'bitRateLockedToPCRClock', __NewATMVCCommand_reverseParameters_bitRateLockedToPCRClock),
        (u'bitRateLockedToNetworkClock', __NewATMVCCommand_reverseParameters_bitRateLockedToNetworkClock),
        (u'multiplex', __NewATMVCCommand_reverseParameters_multiplex),
        ])
    _NewATMVCCommand_reverseParameters._ext = []
    NewATMVCCommand._cont = ASN1Dict([
        (u'resourceID', _NewATMVCCommand_resourceID),
        (u'bitRate', _NewATMVCCommand_bitRate),
        (u'bitRateLockedToPCRClock', _NewATMVCCommand_bitRateLockedToPCRClock),
        (u'bitRateLockedToNetworkClock', _NewATMVCCommand_bitRateLockedToNetworkClock),
        (u'aal', _NewATMVCCommand_aal),
        (u'multiplex', _NewATMVCCommand_multiplex),
        (u'reverseParameters', _NewATMVCCommand_reverseParameters),
        ])
    NewATMVCCommand._ext = []
    
    #-----< MobileMultilinkReconfigurationCommand >-----#
    MobileMultilinkReconfigurationCommand = SEQ(name=u'MobileMultilinkReconfigurationCommand', mode=MODE_TYPE)
    _MobileMultilinkReconfigurationCommand_sampleSize = INT(name=u'sampleSize', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MobileMultilinkReconfigurationCommand_sampleSize._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=255)], ev=None, er=[])
    _MobileMultilinkReconfigurationCommand_samplesPerFrame = INT(name=u'samplesPerFrame', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MobileMultilinkReconfigurationCommand_samplesPerFrame._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=255)], ev=None, er=[])
    _MobileMultilinkReconfigurationCommand_status = CHOICE(name=u'status', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __MobileMultilinkReconfigurationCommand_status_synchronized = NULL(name=u'synchronized', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MobileMultilinkReconfigurationCommand_status_reconfiguration = NULL(name=u'reconfiguration', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MobileMultilinkReconfigurationCommand_status._cont = ASN1Dict([
        (u'synchronized', __MobileMultilinkReconfigurationCommand_status_synchronized),
        (u'reconfiguration', __MobileMultilinkReconfigurationCommand_status_reconfiguration),
        ])
    _MobileMultilinkReconfigurationCommand_status._ext = []
    MobileMultilinkReconfigurationCommand._cont = ASN1Dict([
        (u'sampleSize', _MobileMultilinkReconfigurationCommand_sampleSize),
        (u'samplesPerFrame', _MobileMultilinkReconfigurationCommand_samplesPerFrame),
        (u'status', _MobileMultilinkReconfigurationCommand_status),
        ])
    MobileMultilinkReconfigurationCommand._ext = []
    
    #-----< FunctionNotUnderstood >-----#
    FunctionNotUnderstood = CHOICE(name=u'FunctionNotUnderstood', mode=MODE_TYPE)
    _FunctionNotUnderstood_request = CHOICE(name=u'request', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'RequestMessage')))
    _FunctionNotUnderstood_response = CHOICE(name=u'response', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'ResponseMessage')))
    _FunctionNotUnderstood_command = CHOICE(name=u'command', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'CommandMessage')))
    FunctionNotUnderstood._cont = ASN1Dict([
        (u'request', _FunctionNotUnderstood_request),
        (u'response', _FunctionNotUnderstood_response),
        (u'command', _FunctionNotUnderstood_command),
        ])
    FunctionNotUnderstood._ext = None
    
    #-----< FunctionNotSupported >-----#
    FunctionNotSupported = SEQ(name=u'FunctionNotSupported', mode=MODE_TYPE)
    _FunctionNotSupported_cause = CHOICE(name=u'cause', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __FunctionNotSupported_cause_syntaxError = NULL(name=u'syntaxError', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __FunctionNotSupported_cause_semanticError = NULL(name=u'semanticError', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __FunctionNotSupported_cause_unknownFunction = NULL(name=u'unknownFunction', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _FunctionNotSupported_cause._cont = ASN1Dict([
        (u'syntaxError', __FunctionNotSupported_cause_syntaxError),
        (u'semanticError', __FunctionNotSupported_cause_semanticError),
        (u'unknownFunction', __FunctionNotSupported_cause_unknownFunction),
        ])
    _FunctionNotSupported_cause._ext = []
    _FunctionNotSupported_returnedFunction = OCT_STR(name=u'returnedFunction', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    FunctionNotSupported._cont = ASN1Dict([
        (u'cause', _FunctionNotSupported_cause),
        (u'returnedFunction', _FunctionNotSupported_returnedFunction),
        ])
    FunctionNotSupported._ext = []
    
    #-----< ConferenceIndication >-----#
    ConferenceIndication = CHOICE(name=u'ConferenceIndication', mode=MODE_TYPE)
    _ConferenceIndication_sbeNumber = INT(name=u'sbeNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ConferenceIndication_sbeNumber._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=9)], ev=None, er=[])
    _ConferenceIndication_terminalNumberAssign = SEQ(name=u'terminalNumberAssign', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TerminalLabel')))
    _ConferenceIndication_terminalJoinedConference = SEQ(name=u'terminalJoinedConference', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TerminalLabel')))
    _ConferenceIndication_terminalLeftConference = SEQ(name=u'terminalLeftConference', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TerminalLabel')))
    _ConferenceIndication_seenByAtLeastOneOther = NULL(name=u'seenByAtLeastOneOther', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ConferenceIndication_cancelSeenByAtLeastOneOther = NULL(name=u'cancelSeenByAtLeastOneOther', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ConferenceIndication_seenByAll = NULL(name=u'seenByAll', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ConferenceIndication_cancelSeenByAll = NULL(name=u'cancelSeenByAll', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ConferenceIndication_terminalYouAreSeeing = SEQ(name=u'terminalYouAreSeeing', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TerminalLabel')))
    _ConferenceIndication_requestForFloor = NULL(name=u'requestForFloor', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ConferenceIndication_withdrawChairToken = NULL(name=u'withdrawChairToken', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ConferenceIndication_floorRequested = SEQ(name=u'floorRequested', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TerminalLabel')))
    _ConferenceIndication_terminalYouAreSeeingInSubPictureNumber = SEQ(name=u'terminalYouAreSeeingInSubPictureNumber', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TerminalYouAreSeeingInSubPictureNumber')))
    _ConferenceIndication_videoIndicateCompose = SEQ(name=u'videoIndicateCompose', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'VideoIndicateCompose')))
    _ConferenceIndication_masterMCU = NULL(name=u'masterMCU', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ConferenceIndication_cancelMasterMCU = NULL(name=u'cancelMasterMCU', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ConferenceIndication._cont = ASN1Dict([
        (u'sbeNumber', _ConferenceIndication_sbeNumber),
        (u'terminalNumberAssign', _ConferenceIndication_terminalNumberAssign),
        (u'terminalJoinedConference', _ConferenceIndication_terminalJoinedConference),
        (u'terminalLeftConference', _ConferenceIndication_terminalLeftConference),
        (u'seenByAtLeastOneOther', _ConferenceIndication_seenByAtLeastOneOther),
        (u'cancelSeenByAtLeastOneOther', _ConferenceIndication_cancelSeenByAtLeastOneOther),
        (u'seenByAll', _ConferenceIndication_seenByAll),
        (u'cancelSeenByAll', _ConferenceIndication_cancelSeenByAll),
        (u'terminalYouAreSeeing', _ConferenceIndication_terminalYouAreSeeing),
        (u'requestForFloor', _ConferenceIndication_requestForFloor),
        (u'withdrawChairToken', _ConferenceIndication_withdrawChairToken),
        (u'floorRequested', _ConferenceIndication_floorRequested),
        (u'terminalYouAreSeeingInSubPictureNumber', _ConferenceIndication_terminalYouAreSeeingInSubPictureNumber),
        (u'videoIndicateCompose', _ConferenceIndication_videoIndicateCompose),
        (u'masterMCU', _ConferenceIndication_masterMCU),
        (u'cancelMasterMCU', _ConferenceIndication_cancelMasterMCU),
        ])
    ConferenceIndication._ext = [u'withdrawChairToken', u'floorRequested', u'terminalYouAreSeeingInSubPictureNumber', u'videoIndicateCompose', u'masterMCU', u'cancelMasterMCU']
    
    #-----< TerminalYouAreSeeingInSubPictureNumber >-----#
    TerminalYouAreSeeingInSubPictureNumber = SEQ(name=u'TerminalYouAreSeeingInSubPictureNumber', mode=MODE_TYPE)
    _TerminalYouAreSeeingInSubPictureNumber_terminalNumber = INT(name=u'terminalNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TerminalNumber')))
    _TerminalYouAreSeeingInSubPictureNumber_subPictureNumber = INT(name=u'subPictureNumber', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _TerminalYouAreSeeingInSubPictureNumber_subPictureNumber._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _TerminalYouAreSeeingInSubPictureNumber_mcuNumber = INT(name=u'mcuNumber', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'McuNumber')))
    TerminalYouAreSeeingInSubPictureNumber._cont = ASN1Dict([
        (u'terminalNumber', _TerminalYouAreSeeingInSubPictureNumber_terminalNumber),
        (u'subPictureNumber', _TerminalYouAreSeeingInSubPictureNumber_subPictureNumber),
        (u'mcuNumber', _TerminalYouAreSeeingInSubPictureNumber_mcuNumber),
        ])
    TerminalYouAreSeeingInSubPictureNumber._ext = [u'mcuNumber']
    
    #-----< VideoIndicateCompose >-----#
    VideoIndicateCompose = SEQ(name=u'VideoIndicateCompose', mode=MODE_TYPE)
    _VideoIndicateCompose_compositionNumber = INT(name=u'compositionNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _VideoIndicateCompose_compositionNumber._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    VideoIndicateCompose._cont = ASN1Dict([
        (u'compositionNumber', _VideoIndicateCompose_compositionNumber),
        ])
    VideoIndicateCompose._ext = []
    
    #-----< MiscellaneousIndication >-----#
    MiscellaneousIndication = SEQ(name=u'MiscellaneousIndication', mode=MODE_TYPE)
    _MiscellaneousIndication_logicalChannelNumber = INT(name=u'logicalChannelNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelNumber')))
    _MiscellaneousIndication_type = CHOICE(name=u'type', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __MiscellaneousIndication_type_logicalChannelActive = NULL(name=u'logicalChannelActive', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MiscellaneousIndication_type_logicalChannelInactive = NULL(name=u'logicalChannelInactive', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MiscellaneousIndication_type_multipointConference = NULL(name=u'multipointConference', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MiscellaneousIndication_type_cancelMultipointConference = NULL(name=u'cancelMultipointConference', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MiscellaneousIndication_type_multipointZeroComm = NULL(name=u'multipointZeroComm', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MiscellaneousIndication_type_cancelMultipointZeroComm = NULL(name=u'cancelMultipointZeroComm', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MiscellaneousIndication_type_multipointSecondaryStatus = NULL(name=u'multipointSecondaryStatus', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MiscellaneousIndication_type_cancelMultipointSecondaryStatus = NULL(name=u'cancelMultipointSecondaryStatus', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MiscellaneousIndication_type_videoIndicateReadyToActivate = NULL(name=u'videoIndicateReadyToActivate', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MiscellaneousIndication_type_videoTemporalSpatialTradeOff = INT(name=u'videoTemporalSpatialTradeOff', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MiscellaneousIndication_type_videoTemporalSpatialTradeOff._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=31)], ev=None, er=[])
    __MiscellaneousIndication_type_videoNotDecodedMBs = SEQ(name=u'videoNotDecodedMBs', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___MiscellaneousIndication_type_videoNotDecodedMBs_firstMB = INT(name=u'firstMB', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___MiscellaneousIndication_type_videoNotDecodedMBs_firstMB._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8192)], ev=None, er=[])
    ___MiscellaneousIndication_type_videoNotDecodedMBs_numberOfMBs = INT(name=u'numberOfMBs', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___MiscellaneousIndication_type_videoNotDecodedMBs_numberOfMBs._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8192)], ev=None, er=[])
    ___MiscellaneousIndication_type_videoNotDecodedMBs_temporalReference = INT(name=u'temporalReference', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___MiscellaneousIndication_type_videoNotDecodedMBs_temporalReference._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    __MiscellaneousIndication_type_videoNotDecodedMBs._cont = ASN1Dict([
        (u'firstMB', ___MiscellaneousIndication_type_videoNotDecodedMBs_firstMB),
        (u'numberOfMBs', ___MiscellaneousIndication_type_videoNotDecodedMBs_numberOfMBs),
        (u'temporalReference', ___MiscellaneousIndication_type_videoNotDecodedMBs_temporalReference),
        ])
    __MiscellaneousIndication_type_videoNotDecodedMBs._ext = []
    __MiscellaneousIndication_type_transportCapability = SEQ(name=u'transportCapability', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TransportCapability')))
    _MiscellaneousIndication_type._cont = ASN1Dict([
        (u'logicalChannelActive', __MiscellaneousIndication_type_logicalChannelActive),
        (u'logicalChannelInactive', __MiscellaneousIndication_type_logicalChannelInactive),
        (u'multipointConference', __MiscellaneousIndication_type_multipointConference),
        (u'cancelMultipointConference', __MiscellaneousIndication_type_cancelMultipointConference),
        (u'multipointZeroComm', __MiscellaneousIndication_type_multipointZeroComm),
        (u'cancelMultipointZeroComm', __MiscellaneousIndication_type_cancelMultipointZeroComm),
        (u'multipointSecondaryStatus', __MiscellaneousIndication_type_multipointSecondaryStatus),
        (u'cancelMultipointSecondaryStatus', __MiscellaneousIndication_type_cancelMultipointSecondaryStatus),
        (u'videoIndicateReadyToActivate', __MiscellaneousIndication_type_videoIndicateReadyToActivate),
        (u'videoTemporalSpatialTradeOff', __MiscellaneousIndication_type_videoTemporalSpatialTradeOff),
        (u'videoNotDecodedMBs', __MiscellaneousIndication_type_videoNotDecodedMBs),
        (u'transportCapability', __MiscellaneousIndication_type_transportCapability),
        ])
    _MiscellaneousIndication_type._ext = [u'videoNotDecodedMBs', u'transportCapability']
    MiscellaneousIndication._cont = ASN1Dict([
        (u'logicalChannelNumber', _MiscellaneousIndication_logicalChannelNumber),
        (u'type', _MiscellaneousIndication_type),
        ])
    MiscellaneousIndication._ext = []
    
    #-----< JitterIndication >-----#
    JitterIndication = SEQ(name=u'JitterIndication', mode=MODE_TYPE)
    _JitterIndication_scope = CHOICE(name=u'scope', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __JitterIndication_scope_logicalChannelNumber = INT(name=u'logicalChannelNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelNumber')))
    __JitterIndication_scope_resourceID = INT(name=u'resourceID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __JitterIndication_scope_resourceID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    __JitterIndication_scope_wholeMultiplex = NULL(name=u'wholeMultiplex', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _JitterIndication_scope._cont = ASN1Dict([
        (u'logicalChannelNumber', __JitterIndication_scope_logicalChannelNumber),
        (u'resourceID', __JitterIndication_scope_resourceID),
        (u'wholeMultiplex', __JitterIndication_scope_wholeMultiplex),
        ])
    _JitterIndication_scope._ext = None
    _JitterIndication_estimatedReceivedJitterMantissa = INT(name=u'estimatedReceivedJitterMantissa', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _JitterIndication_estimatedReceivedJitterMantissa._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=3)], ev=None, er=[])
    _JitterIndication_estimatedReceivedJitterExponent = INT(name=u'estimatedReceivedJitterExponent', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _JitterIndication_estimatedReceivedJitterExponent._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=7)], ev=None, er=[])
    _JitterIndication_skippedFrameCount = INT(name=u'skippedFrameCount', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _JitterIndication_skippedFrameCount._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=15)], ev=None, er=[])
    _JitterIndication_additionalDecoderBuffer = INT(name=u'additionalDecoderBuffer', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _JitterIndication_additionalDecoderBuffer._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=262143)], ev=None, er=[])
    JitterIndication._cont = ASN1Dict([
        (u'scope', _JitterIndication_scope),
        (u'estimatedReceivedJitterMantissa', _JitterIndication_estimatedReceivedJitterMantissa),
        (u'estimatedReceivedJitterExponent', _JitterIndication_estimatedReceivedJitterExponent),
        (u'skippedFrameCount', _JitterIndication_skippedFrameCount),
        (u'additionalDecoderBuffer', _JitterIndication_additionalDecoderBuffer),
        ])
    JitterIndication._ext = []
    
    #-----< H223SkewIndication >-----#
    H223SkewIndication = SEQ(name=u'H223SkewIndication', mode=MODE_TYPE)
    _H223SkewIndication_logicalChannelNumber1 = INT(name=u'logicalChannelNumber1', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelNumber')))
    _H223SkewIndication_logicalChannelNumber2 = INT(name=u'logicalChannelNumber2', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelNumber')))
    _H223SkewIndication_skew = INT(name=u'skew', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H223SkewIndication_skew._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4095)], ev=None, er=[])
    H223SkewIndication._cont = ASN1Dict([
        (u'logicalChannelNumber1', _H223SkewIndication_logicalChannelNumber1),
        (u'logicalChannelNumber2', _H223SkewIndication_logicalChannelNumber2),
        (u'skew', _H223SkewIndication_skew),
        ])
    H223SkewIndication._ext = []
    
    #-----< H2250MaximumSkewIndication >-----#
    H2250MaximumSkewIndication = SEQ(name=u'H2250MaximumSkewIndication', mode=MODE_TYPE)
    _H2250MaximumSkewIndication_logicalChannelNumber1 = INT(name=u'logicalChannelNumber1', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelNumber')))
    _H2250MaximumSkewIndication_logicalChannelNumber2 = INT(name=u'logicalChannelNumber2', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelNumber')))
    _H2250MaximumSkewIndication_maximumSkew = INT(name=u'maximumSkew', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _H2250MaximumSkewIndication_maximumSkew._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4095)], ev=None, er=[])
    H2250MaximumSkewIndication._cont = ASN1Dict([
        (u'logicalChannelNumber1', _H2250MaximumSkewIndication_logicalChannelNumber1),
        (u'logicalChannelNumber2', _H2250MaximumSkewIndication_logicalChannelNumber2),
        (u'maximumSkew', _H2250MaximumSkewIndication_maximumSkew),
        ])
    H2250MaximumSkewIndication._ext = []
    
    #-----< MCLocationIndication >-----#
    MCLocationIndication = SEQ(name=u'MCLocationIndication', mode=MODE_TYPE)
    _MCLocationIndication_signalAddress = CHOICE(name=u'signalAddress', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'TransportAddress')))
    MCLocationIndication._cont = ASN1Dict([
        (u'signalAddress', _MCLocationIndication_signalAddress),
        ])
    MCLocationIndication._ext = []
    
    #-----< VendorIdentification >-----#
    VendorIdentification = SEQ(name=u'VendorIdentification', mode=MODE_TYPE)
    _VendorIdentification_vendor = CHOICE(name=u'vendor', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardIdentifier')))
    _VendorIdentification_productNumber = OCT_STR(name=u'productNumber', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _VendorIdentification_productNumber._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    _VendorIdentification_versionNumber = OCT_STR(name=u'versionNumber', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _VendorIdentification_versionNumber._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    VendorIdentification._cont = ASN1Dict([
        (u'vendor', _VendorIdentification_vendor),
        (u'productNumber', _VendorIdentification_productNumber),
        (u'versionNumber', _VendorIdentification_versionNumber),
        ])
    VendorIdentification._ext = []
    
    #-----< NewATMVCIndication >-----#
    NewATMVCIndication = SEQ(name=u'NewATMVCIndication', mode=MODE_TYPE)
    _NewATMVCIndication_resourceID = INT(name=u'resourceID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NewATMVCIndication_resourceID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    _NewATMVCIndication_bitRate = INT(name=u'bitRate', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NewATMVCIndication_bitRate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    _NewATMVCIndication_bitRateLockedToPCRClock = BOOL(name=u'bitRateLockedToPCRClock', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NewATMVCIndication_bitRateLockedToNetworkClock = BOOL(name=u'bitRateLockedToNetworkClock', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NewATMVCIndication_aal = CHOICE(name=u'aal', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __NewATMVCIndication_aal_aal1 = SEQ(name=u'aal1', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___NewATMVCIndication_aal_aal1_clockRecovery = CHOICE(name=u'clockRecovery', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ____NewATMVCIndication_aal_aal1_clockRecovery_nullClockRecovery = NULL(name=u'nullClockRecovery', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ____NewATMVCIndication_aal_aal1_clockRecovery_srtsClockRecovery = NULL(name=u'srtsClockRecovery', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ____NewATMVCIndication_aal_aal1_clockRecovery_adaptiveClockRecovery = NULL(name=u'adaptiveClockRecovery', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___NewATMVCIndication_aal_aal1_clockRecovery._cont = ASN1Dict([
        (u'nullClockRecovery', ____NewATMVCIndication_aal_aal1_clockRecovery_nullClockRecovery),
        (u'srtsClockRecovery', ____NewATMVCIndication_aal_aal1_clockRecovery_srtsClockRecovery),
        (u'adaptiveClockRecovery', ____NewATMVCIndication_aal_aal1_clockRecovery_adaptiveClockRecovery),
        ])
    ___NewATMVCIndication_aal_aal1_clockRecovery._ext = []
    ___NewATMVCIndication_aal_aal1_errorCorrection = CHOICE(name=u'errorCorrection', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ____NewATMVCIndication_aal_aal1_errorCorrection_nullErrorCorrection = NULL(name=u'nullErrorCorrection', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ____NewATMVCIndication_aal_aal1_errorCorrection_longInterleaver = NULL(name=u'longInterleaver', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ____NewATMVCIndication_aal_aal1_errorCorrection_shortInterleaver = NULL(name=u'shortInterleaver', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ____NewATMVCIndication_aal_aal1_errorCorrection_errorCorrectionOnly = NULL(name=u'errorCorrectionOnly', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___NewATMVCIndication_aal_aal1_errorCorrection._cont = ASN1Dict([
        (u'nullErrorCorrection', ____NewATMVCIndication_aal_aal1_errorCorrection_nullErrorCorrection),
        (u'longInterleaver', ____NewATMVCIndication_aal_aal1_errorCorrection_longInterleaver),
        (u'shortInterleaver', ____NewATMVCIndication_aal_aal1_errorCorrection_shortInterleaver),
        (u'errorCorrectionOnly', ____NewATMVCIndication_aal_aal1_errorCorrection_errorCorrectionOnly),
        ])
    ___NewATMVCIndication_aal_aal1_errorCorrection._ext = []
    ___NewATMVCIndication_aal_aal1_structuredDataTransfer = BOOL(name=u'structuredDataTransfer', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___NewATMVCIndication_aal_aal1_partiallyFilledCells = BOOL(name=u'partiallyFilledCells', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __NewATMVCIndication_aal_aal1._cont = ASN1Dict([
        (u'clockRecovery', ___NewATMVCIndication_aal_aal1_clockRecovery),
        (u'errorCorrection', ___NewATMVCIndication_aal_aal1_errorCorrection),
        (u'structuredDataTransfer', ___NewATMVCIndication_aal_aal1_structuredDataTransfer),
        (u'partiallyFilledCells', ___NewATMVCIndication_aal_aal1_partiallyFilledCells),
        ])
    __NewATMVCIndication_aal_aal1._ext = []
    __NewATMVCIndication_aal_aal5 = SEQ(name=u'aal5', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___NewATMVCIndication_aal_aal5_forwardMaximumSDUSize = INT(name=u'forwardMaximumSDUSize', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___NewATMVCIndication_aal_aal5_forwardMaximumSDUSize._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    ___NewATMVCIndication_aal_aal5_backwardMaximumSDUSize = INT(name=u'backwardMaximumSDUSize', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___NewATMVCIndication_aal_aal5_backwardMaximumSDUSize._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    __NewATMVCIndication_aal_aal5._cont = ASN1Dict([
        (u'forwardMaximumSDUSize', ___NewATMVCIndication_aal_aal5_forwardMaximumSDUSize),
        (u'backwardMaximumSDUSize', ___NewATMVCIndication_aal_aal5_backwardMaximumSDUSize),
        ])
    __NewATMVCIndication_aal_aal5._ext = []
    _NewATMVCIndication_aal._cont = ASN1Dict([
        (u'aal1', __NewATMVCIndication_aal_aal1),
        (u'aal5', __NewATMVCIndication_aal_aal5),
        ])
    _NewATMVCIndication_aal._ext = []
    _NewATMVCIndication_multiplex = CHOICE(name=u'multiplex', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __NewATMVCIndication_multiplex_noMultiplex = NULL(name=u'noMultiplex', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __NewATMVCIndication_multiplex_transportStream = NULL(name=u'transportStream', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __NewATMVCIndication_multiplex_programStream = NULL(name=u'programStream', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NewATMVCIndication_multiplex._cont = ASN1Dict([
        (u'noMultiplex', __NewATMVCIndication_multiplex_noMultiplex),
        (u'transportStream', __NewATMVCIndication_multiplex_transportStream),
        (u'programStream', __NewATMVCIndication_multiplex_programStream),
        ])
    _NewATMVCIndication_multiplex._ext = []
    _NewATMVCIndication_reverseParameters = SEQ(name=u'reverseParameters', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __NewATMVCIndication_reverseParameters_bitRate = INT(name=u'bitRate', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __NewATMVCIndication_reverseParameters_bitRate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    __NewATMVCIndication_reverseParameters_bitRateLockedToPCRClock = BOOL(name=u'bitRateLockedToPCRClock', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __NewATMVCIndication_reverseParameters_bitRateLockedToNetworkClock = BOOL(name=u'bitRateLockedToNetworkClock', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __NewATMVCIndication_reverseParameters_multiplex = CHOICE(name=u'multiplex', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ___NewATMVCIndication_reverseParameters_multiplex_noMultiplex = NULL(name=u'noMultiplex', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___NewATMVCIndication_reverseParameters_multiplex_transportStream = NULL(name=u'transportStream', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___NewATMVCIndication_reverseParameters_multiplex_programStream = NULL(name=u'programStream', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __NewATMVCIndication_reverseParameters_multiplex._cont = ASN1Dict([
        (u'noMultiplex', ___NewATMVCIndication_reverseParameters_multiplex_noMultiplex),
        (u'transportStream', ___NewATMVCIndication_reverseParameters_multiplex_transportStream),
        (u'programStream', ___NewATMVCIndication_reverseParameters_multiplex_programStream),
        ])
    __NewATMVCIndication_reverseParameters_multiplex._ext = []
    _NewATMVCIndication_reverseParameters._cont = ASN1Dict([
        (u'bitRate', __NewATMVCIndication_reverseParameters_bitRate),
        (u'bitRateLockedToPCRClock', __NewATMVCIndication_reverseParameters_bitRateLockedToPCRClock),
        (u'bitRateLockedToNetworkClock', __NewATMVCIndication_reverseParameters_bitRateLockedToNetworkClock),
        (u'multiplex', __NewATMVCIndication_reverseParameters_multiplex),
        ])
    _NewATMVCIndication_reverseParameters._ext = []
    NewATMVCIndication._cont = ASN1Dict([
        (u'resourceID', _NewATMVCIndication_resourceID),
        (u'bitRate', _NewATMVCIndication_bitRate),
        (u'bitRateLockedToPCRClock', _NewATMVCIndication_bitRateLockedToPCRClock),
        (u'bitRateLockedToNetworkClock', _NewATMVCIndication_bitRateLockedToNetworkClock),
        (u'aal', _NewATMVCIndication_aal),
        (u'multiplex', _NewATMVCIndication_multiplex),
        (u'reverseParameters', _NewATMVCIndication_reverseParameters),
        ])
    NewATMVCIndication._ext = [u'reverseParameters']
    
    #-----< IV8 >-----#
    IV8 = OCT_STR(name=u'IV8', mode=MODE_TYPE)
    IV8._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    
    #-----< IV16 >-----#
    IV16 = OCT_STR(name=u'IV16', mode=MODE_TYPE)
    IV16._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    
    #-----< Params >-----#
    Params = SEQ(name=u'Params', mode=MODE_TYPE)
    _Params_iv8 = OCT_STR(name=u'iv8', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'IV8')), opt=True)
    _Params_iv16 = OCT_STR(name=u'iv16', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'IV16')), opt=True)
    _Params_iv = OCT_STR(name=u'iv', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    Params._cont = ASN1Dict([
        (u'iv8', _Params_iv8),
        (u'iv16', _Params_iv16),
        (u'iv', _Params_iv),
        ])
    Params._ext = []
    
    #-----< UserInputIndication >-----#
    UserInputIndication = CHOICE(name=u'UserInputIndication', mode=MODE_TYPE)
    _UserInputIndication_nonStandard = SEQ(name=u'nonStandard', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')))
    _UserInputIndication_alphanumeric = STR_GENE(name=u'alphanumeric', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UserInputIndication_userInputSupportIndication = CHOICE(name=u'userInputSupportIndication', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __UserInputIndication_userInputSupportIndication_nonStandard = SEQ(name=u'nonStandard', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'NonStandardParameter')))
    __UserInputIndication_userInputSupportIndication_basicString = NULL(name=u'basicString', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __UserInputIndication_userInputSupportIndication_iA5String = NULL(name=u'iA5String', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __UserInputIndication_userInputSupportIndication_generalString = NULL(name=u'generalString', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __UserInputIndication_userInputSupportIndication_encryptedBasicString = NULL(name=u'encryptedBasicString', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __UserInputIndication_userInputSupportIndication_encryptedIA5String = NULL(name=u'encryptedIA5String', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __UserInputIndication_userInputSupportIndication_encryptedGeneralString = NULL(name=u'encryptedGeneralString', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UserInputIndication_userInputSupportIndication._cont = ASN1Dict([
        (u'nonStandard', __UserInputIndication_userInputSupportIndication_nonStandard),
        (u'basicString', __UserInputIndication_userInputSupportIndication_basicString),
        (u'iA5String', __UserInputIndication_userInputSupportIndication_iA5String),
        (u'generalString', __UserInputIndication_userInputSupportIndication_generalString),
        (u'encryptedBasicString', __UserInputIndication_userInputSupportIndication_encryptedBasicString),
        (u'encryptedIA5String', __UserInputIndication_userInputSupportIndication_encryptedIA5String),
        (u'encryptedGeneralString', __UserInputIndication_userInputSupportIndication_encryptedGeneralString),
        ])
    _UserInputIndication_userInputSupportIndication._ext = [u'encryptedBasicString', u'encryptedIA5String', u'encryptedGeneralString']
    _UserInputIndication_signal = SEQ(name=u'signal', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __UserInputIndication_signal_signalType = STR_IA5(name=u'signalType', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __UserInputIndication_signal_signalType._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    __UserInputIndication_signal_signalType._const_alpha = ASN1Set(rv=[u'0', u'1', u'2', u'3', u'4', u'5', u'6', u'7', u'8', u'9', u'#', u'*', u'A', u'B', u'C', u'D', u'!'], rr=[], ev=None, er=[])
    __UserInputIndication_signal_duration = INT(name=u'duration', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __UserInputIndication_signal_duration._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    __UserInputIndication_signal_rtp = SEQ(name=u'rtp', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    ___UserInputIndication_signal_rtp_timestamp = INT(name=u'timestamp', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    ___UserInputIndication_signal_rtp_timestamp._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4294967295)], ev=None, er=[])
    ___UserInputIndication_signal_rtp_expirationTime = INT(name=u'expirationTime', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    ___UserInputIndication_signal_rtp_expirationTime._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4294967295)], ev=None, er=[])
    ___UserInputIndication_signal_rtp_logicalChannelNumber = INT(name=u'logicalChannelNumber', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelNumber')))
    __UserInputIndication_signal_rtp._cont = ASN1Dict([
        (u'timestamp', ___UserInputIndication_signal_rtp_timestamp),
        (u'expirationTime', ___UserInputIndication_signal_rtp_expirationTime),
        (u'logicalChannelNumber', ___UserInputIndication_signal_rtp_logicalChannelNumber),
        ])
    __UserInputIndication_signal_rtp._ext = []
    __UserInputIndication_signal_rtpPayloadIndication = NULL(name=u'rtpPayloadIndication', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __UserInputIndication_signal_paramS = SEQ(name=u'paramS', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'Params')), opt=True)
    __UserInputIndication_signal_encryptedSignalType = OCT_STR(name=u'encryptedSignalType', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __UserInputIndication_signal_encryptedSignalType._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    __UserInputIndication_signal_algorithmOID = OID(name=u'algorithmOID', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _UserInputIndication_signal._cont = ASN1Dict([
        (u'signalType', __UserInputIndication_signal_signalType),
        (u'duration', __UserInputIndication_signal_duration),
        (u'rtp', __UserInputIndication_signal_rtp),
        (u'rtpPayloadIndication', __UserInputIndication_signal_rtpPayloadIndication),
        (u'paramS', __UserInputIndication_signal_paramS),
        (u'encryptedSignalType', __UserInputIndication_signal_encryptedSignalType),
        (u'algorithmOID', __UserInputIndication_signal_algorithmOID),
        ])
    _UserInputIndication_signal._ext = [u'rtpPayloadIndication', u'paramS', u'encryptedSignalType', u'algorithmOID']
    _UserInputIndication_signalUpdate = SEQ(name=u'signalUpdate', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __UserInputIndication_signalUpdate_duration = INT(name=u'duration', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __UserInputIndication_signalUpdate_duration._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    __UserInputIndication_signalUpdate_rtp = SEQ(name=u'rtp', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    ___UserInputIndication_signalUpdate_rtp_logicalChannelNumber = INT(name=u'logicalChannelNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelNumber')))
    __UserInputIndication_signalUpdate_rtp._cont = ASN1Dict([
        (u'logicalChannelNumber', ___UserInputIndication_signalUpdate_rtp_logicalChannelNumber),
        ])
    __UserInputIndication_signalUpdate_rtp._ext = []
    _UserInputIndication_signalUpdate._cont = ASN1Dict([
        (u'duration', __UserInputIndication_signalUpdate_duration),
        (u'rtp', __UserInputIndication_signalUpdate_rtp),
        ])
    _UserInputIndication_signalUpdate._ext = []
    _UserInputIndication_extendedAlphanumeric = SEQ(name=u'extendedAlphanumeric', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __UserInputIndication_extendedAlphanumeric_alphanumeric = STR_GENE(name=u'alphanumeric', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __UserInputIndication_extendedAlphanumeric_rtpPayloadIndication = NULL(name=u'rtpPayloadIndication', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __UserInputIndication_extendedAlphanumeric_encryptedAlphanumeric = SEQ(name=u'encryptedAlphanumeric', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    ___UserInputIndication_extendedAlphanumeric_encryptedAlphanumeric_algorithmOID = OID(name=u'algorithmOID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___UserInputIndication_extendedAlphanumeric_encryptedAlphanumeric_paramS = SEQ(name=u'paramS', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'Params')), opt=True)
    ___UserInputIndication_extendedAlphanumeric_encryptedAlphanumeric_encrypted = OCT_STR(name=u'encrypted', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __UserInputIndication_extendedAlphanumeric_encryptedAlphanumeric._cont = ASN1Dict([
        (u'algorithmOID', ___UserInputIndication_extendedAlphanumeric_encryptedAlphanumeric_algorithmOID),
        (u'paramS', ___UserInputIndication_extendedAlphanumeric_encryptedAlphanumeric_paramS),
        (u'encrypted', ___UserInputIndication_extendedAlphanumeric_encryptedAlphanumeric_encrypted),
        ])
    __UserInputIndication_extendedAlphanumeric_encryptedAlphanumeric._ext = []
    _UserInputIndication_extendedAlphanumeric._cont = ASN1Dict([
        (u'alphanumeric', __UserInputIndication_extendedAlphanumeric_alphanumeric),
        (u'rtpPayloadIndication', __UserInputIndication_extendedAlphanumeric_rtpPayloadIndication),
        (u'encryptedAlphanumeric', __UserInputIndication_extendedAlphanumeric_encryptedAlphanumeric),
        ])
    _UserInputIndication_extendedAlphanumeric._ext = [u'encryptedAlphanumeric']
    _UserInputIndication_encryptedAlphanumeric = SEQ(name=u'encryptedAlphanumeric', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __UserInputIndication_encryptedAlphanumeric_algorithmOID = OID(name=u'algorithmOID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __UserInputIndication_encryptedAlphanumeric_paramS = SEQ(name=u'paramS', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'Params')), opt=True)
    __UserInputIndication_encryptedAlphanumeric_encrypted = OCT_STR(name=u'encrypted', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UserInputIndication_encryptedAlphanumeric._cont = ASN1Dict([
        (u'algorithmOID', __UserInputIndication_encryptedAlphanumeric_algorithmOID),
        (u'paramS', __UserInputIndication_encryptedAlphanumeric_paramS),
        (u'encrypted', __UserInputIndication_encryptedAlphanumeric_encrypted),
        ])
    _UserInputIndication_encryptedAlphanumeric._ext = []
    _UserInputIndication_genericInformation = SEQ_OF(name=u'genericInformation', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __UserInputIndication_genericInformation__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'GenericInformation')))
    _UserInputIndication_genericInformation._cont = __UserInputIndication_genericInformation__item_
    UserInputIndication._cont = ASN1Dict([
        (u'nonStandard', _UserInputIndication_nonStandard),
        (u'alphanumeric', _UserInputIndication_alphanumeric),
        (u'userInputSupportIndication', _UserInputIndication_userInputSupportIndication),
        (u'signal', _UserInputIndication_signal),
        (u'signalUpdate', _UserInputIndication_signalUpdate),
        (u'extendedAlphanumeric', _UserInputIndication_extendedAlphanumeric),
        (u'encryptedAlphanumeric', _UserInputIndication_encryptedAlphanumeric),
        (u'genericInformation', _UserInputIndication_genericInformation),
        ])
    UserInputIndication._ext = [u'userInputSupportIndication', u'signal', u'signalUpdate', u'extendedAlphanumeric', u'encryptedAlphanumeric', u'genericInformation']
    
    #-----< FlowControlIndication >-----#
    FlowControlIndication = SEQ(name=u'FlowControlIndication', mode=MODE_TYPE)
    _FlowControlIndication_scope = CHOICE(name=u'scope', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __FlowControlIndication_scope_logicalChannelNumber = INT(name=u'logicalChannelNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MULTIMEDIA-SYSTEM-CONTROL', 'LogicalChannelNumber')))
    __FlowControlIndication_scope_resourceID = INT(name=u'resourceID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __FlowControlIndication_scope_resourceID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    __FlowControlIndication_scope_wholeMultiplex = NULL(name=u'wholeMultiplex', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _FlowControlIndication_scope._cont = ASN1Dict([
        (u'logicalChannelNumber', __FlowControlIndication_scope_logicalChannelNumber),
        (u'resourceID', __FlowControlIndication_scope_resourceID),
        (u'wholeMultiplex', __FlowControlIndication_scope_wholeMultiplex),
        ])
    _FlowControlIndication_scope._ext = None
    _FlowControlIndication_restriction = CHOICE(name=u'restriction', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __FlowControlIndication_restriction_maximumBitRate = INT(name=u'maximumBitRate', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __FlowControlIndication_restriction_maximumBitRate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=16777215)], ev=None, er=[])
    __FlowControlIndication_restriction_noRestriction = NULL(name=u'noRestriction', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _FlowControlIndication_restriction._cont = ASN1Dict([
        (u'maximumBitRate', __FlowControlIndication_restriction_maximumBitRate),
        (u'noRestriction', __FlowControlIndication_restriction_noRestriction),
        ])
    _FlowControlIndication_restriction._ext = None
    FlowControlIndication._cont = ASN1Dict([
        (u'scope', _FlowControlIndication_scope),
        (u'restriction', _FlowControlIndication_restriction),
        ])
    FlowControlIndication._ext = []
    
    #-----< MobileMultilinkReconfigurationIndication >-----#
    MobileMultilinkReconfigurationIndication = SEQ(name=u'MobileMultilinkReconfigurationIndication', mode=MODE_TYPE)
    _MobileMultilinkReconfigurationIndication_sampleSize = INT(name=u'sampleSize', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MobileMultilinkReconfigurationIndication_sampleSize._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=255)], ev=None, er=[])
    _MobileMultilinkReconfigurationIndication_samplesPerFrame = INT(name=u'samplesPerFrame', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MobileMultilinkReconfigurationIndication_samplesPerFrame._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=255)], ev=None, er=[])
    MobileMultilinkReconfigurationIndication._cont = ASN1Dict([
        (u'sampleSize', _MobileMultilinkReconfigurationIndication_sampleSize),
        (u'samplesPerFrame', _MobileMultilinkReconfigurationIndication_samplesPerFrame),
        ])
    MobileMultilinkReconfigurationIndication._ext = []
    
    _all_ = [
        _MultimediaSystemControlMessage_request,
        _MultimediaSystemControlMessage_response,
        _MultimediaSystemControlMessage_command,
        _MultimediaSystemControlMessage_indication,
        MultimediaSystemControlMessage,
        _RequestMessage_nonStandard,
        _RequestMessage_masterSlaveDetermination,
        _RequestMessage_terminalCapabilitySet,
        _RequestMessage_openLogicalChannel,
        _RequestMessage_closeLogicalChannel,
        _RequestMessage_requestChannelClose,
        _RequestMessage_multiplexEntrySend,
        _RequestMessage_requestMultiplexEntry,
        _RequestMessage_requestMode,
        _RequestMessage_roundTripDelayRequest,
        _RequestMessage_maintenanceLoopRequest,
        _RequestMessage_communicationModeRequest,
        _RequestMessage_conferenceRequest,
        _RequestMessage_multilinkRequest,
        _RequestMessage_logicalChannelRateRequest,
        _RequestMessage_genericRequest,
        RequestMessage,
        _ResponseMessage_nonStandard,
        _ResponseMessage_masterSlaveDeterminationAck,
        _ResponseMessage_masterSlaveDeterminationReject,
        _ResponseMessage_terminalCapabilitySetAck,
        _ResponseMessage_terminalCapabilitySetReject,
        _ResponseMessage_openLogicalChannelAck,
        _ResponseMessage_openLogicalChannelReject,
        _ResponseMessage_closeLogicalChannelAck,
        _ResponseMessage_requestChannelCloseAck,
        _ResponseMessage_requestChannelCloseReject,
        _ResponseMessage_multiplexEntrySendAck,
        _ResponseMessage_multiplexEntrySendReject,
        _ResponseMessage_requestMultiplexEntryAck,
        _ResponseMessage_requestMultiplexEntryReject,
        _ResponseMessage_requestModeAck,
        _ResponseMessage_requestModeReject,
        _ResponseMessage_roundTripDelayResponse,
        _ResponseMessage_maintenanceLoopAck,
        _ResponseMessage_maintenanceLoopReject,
        _ResponseMessage_communicationModeResponse,
        _ResponseMessage_conferenceResponse,
        _ResponseMessage_multilinkResponse,
        _ResponseMessage_logicalChannelRateAcknowledge,
        _ResponseMessage_logicalChannelRateReject,
        _ResponseMessage_genericResponse,
        ResponseMessage,
        _CommandMessage_nonStandard,
        _CommandMessage_maintenanceLoopOffCommand,
        _CommandMessage_sendTerminalCapabilitySet,
        _CommandMessage_encryptionCommand,
        _CommandMessage_flowControlCommand,
        _CommandMessage_endSessionCommand,
        _CommandMessage_miscellaneousCommand,
        _CommandMessage_communicationModeCommand,
        _CommandMessage_conferenceCommand,
        _CommandMessage_h223MultiplexReconfiguration,
        _CommandMessage_newATMVCCommand,
        _CommandMessage_mobileMultilinkReconfigurationCommand,
        _CommandMessage_genericCommand,
        CommandMessage,
        _IndicationMessage_nonStandard,
        _IndicationMessage_functionNotUnderstood,
        _IndicationMessage_masterSlaveDeterminationRelease,
        _IndicationMessage_terminalCapabilitySetRelease,
        _IndicationMessage_openLogicalChannelConfirm,
        _IndicationMessage_requestChannelCloseRelease,
        _IndicationMessage_multiplexEntrySendRelease,
        _IndicationMessage_requestMultiplexEntryRelease,
        _IndicationMessage_requestModeRelease,
        _IndicationMessage_miscellaneousIndication,
        _IndicationMessage_jitterIndication,
        _IndicationMessage_h223SkewIndication,
        _IndicationMessage_newATMVCIndication,
        _IndicationMessage_userInput,
        _IndicationMessage_h2250MaximumSkewIndication,
        _IndicationMessage_mcLocationIndication,
        _IndicationMessage_conferenceIndication,
        _IndicationMessage_vendorIdentification,
        _IndicationMessage_functionNotSupported,
        _IndicationMessage_multilinkIndication,
        _IndicationMessage_logicalChannelRateRelease,
        _IndicationMessage_flowControlIndication,
        _IndicationMessage_mobileMultilinkReconfigurationIndication,
        _IndicationMessage_genericIndication,
        IndicationMessage,
        SequenceNumber,
        _GenericMessage_messageIdentifier,
        _GenericMessage_subMessageIdentifier,
        __GenericMessage_messageContent__item_,
        _GenericMessage_messageContent,
        GenericMessage,
        GenericInformation,
        _NonStandardMessage_nonStandardData,
        NonStandardMessage,
        _NonStandardParameter_nonStandardIdentifier,
        _NonStandardParameter_data,
        NonStandardParameter,
        _NonStandardIdentifier_object,
        __NonStandardIdentifier_h221NonStandard_t35CountryCode,
        __NonStandardIdentifier_h221NonStandard_t35Extension,
        __NonStandardIdentifier_h221NonStandard_manufacturerCode,
        _NonStandardIdentifier_h221NonStandard,
        NonStandardIdentifier,
        _MasterSlaveDetermination_terminalType,
        _MasterSlaveDetermination_statusDeterminationNumber,
        MasterSlaveDetermination,
        __MasterSlaveDeterminationAck_decision_master,
        __MasterSlaveDeterminationAck_decision_slave,
        _MasterSlaveDeterminationAck_decision,
        MasterSlaveDeterminationAck,
        __MasterSlaveDeterminationReject_cause_identicalNumbers,
        _MasterSlaveDeterminationReject_cause,
        MasterSlaveDeterminationReject,
        MasterSlaveDeterminationRelease,
        _TerminalCapabilitySet_sequenceNumber,
        _TerminalCapabilitySet_protocolIdentifier,
        _TerminalCapabilitySet_multiplexCapability,
        __TerminalCapabilitySet_capabilityTable__item_,
        _TerminalCapabilitySet_capabilityTable,
        __TerminalCapabilitySet_capabilityDescriptors__item_,
        _TerminalCapabilitySet_capabilityDescriptors,
        __TerminalCapabilitySet_genericInformation__item_,
        _TerminalCapabilitySet_genericInformation,
        TerminalCapabilitySet,
        _CapabilityTableEntry_capabilityTableEntryNumber,
        _CapabilityTableEntry_capability,
        CapabilityTableEntry,
        _CapabilityDescriptor_capabilityDescriptorNumber,
        __CapabilityDescriptor_simultaneousCapabilities__item_,
        _CapabilityDescriptor_simultaneousCapabilities,
        CapabilityDescriptor,
        _AlternativeCapabilitySet__item_,
        AlternativeCapabilitySet,
        CapabilityTableEntryNumber,
        CapabilityDescriptorNumber,
        _TerminalCapabilitySetAck_sequenceNumber,
        __TerminalCapabilitySetAck_genericInformation__item_,
        _TerminalCapabilitySetAck_genericInformation,
        TerminalCapabilitySetAck,
        _TerminalCapabilitySetReject_sequenceNumber,
        __TerminalCapabilitySetReject_cause_unspecified,
        __TerminalCapabilitySetReject_cause_undefinedTableEntryUsed,
        __TerminalCapabilitySetReject_cause_descriptorCapacityExceeded,
        ___TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded_highestEntryNumberProcessed,
        ___TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded_noneProcessed,
        __TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded,
        _TerminalCapabilitySetReject_cause,
        __TerminalCapabilitySetReject_genericInformation__item_,
        _TerminalCapabilitySetReject_genericInformation,
        TerminalCapabilitySetReject,
        __TerminalCapabilitySetRelease_genericInformation__item_,
        _TerminalCapabilitySetRelease_genericInformation,
        TerminalCapabilitySetRelease,
        _Capability_nonStandard,
        _Capability_receiveVideoCapability,
        _Capability_transmitVideoCapability,
        _Capability_receiveAndTransmitVideoCapability,
        _Capability_receiveAudioCapability,
        _Capability_transmitAudioCapability,
        _Capability_receiveAndTransmitAudioCapability,
        _Capability_receiveDataApplicationCapability,
        _Capability_transmitDataApplicationCapability,
        _Capability_receiveAndTransmitDataApplicationCapability,
        _Capability_h233EncryptionTransmitCapability,
        __Capability_h233EncryptionReceiveCapability_h233IVResponseTime,
        _Capability_h233EncryptionReceiveCapability,
        _Capability_conferenceCapability,
        _Capability_h235SecurityCapability,
        _Capability_maxPendingReplacementFor,
        _Capability_receiveUserInputCapability,
        _Capability_transmitUserInputCapability,
        _Capability_receiveAndTransmitUserInputCapability,
        _Capability_genericControlCapability,
        _Capability_receiveMultiplexedStreamCapability,
        _Capability_transmitMultiplexedStreamCapability,
        _Capability_receiveAndTransmitMultiplexedStreamCapability,
        _Capability_receiveRTPAudioTelephonyEventCapability,
        _Capability_receiveRTPAudioToneCapability,
        _Capability_depFecCapability,
        _Capability_multiplePayloadStreamCapability,
        _Capability_fecCapability,
        _Capability_redundancyEncodingCap,
        _Capability_oneOfCapabilities,
        Capability,
        _H235SecurityCapability_encryptionAuthenticationAndIntegrity,
        _H235SecurityCapability_mediaCapability,
        H235SecurityCapability,
        _MultiplexCapability_nonStandard,
        _MultiplexCapability_h222Capability,
        _MultiplexCapability_h223Capability,
        _MultiplexCapability_v76Capability,
        _MultiplexCapability_h2250Capability,
        _MultiplexCapability_genericMultiplexCapability,
        MultiplexCapability,
        _H222Capability_numberOfVCs,
        __H222Capability_vcCapability__item_,
        _H222Capability_vcCapability,
        H222Capability,
        __VCCapability_aal1_nullClockRecovery,
        __VCCapability_aal1_srtsClockRecovery,
        __VCCapability_aal1_adaptiveClockRecovery,
        __VCCapability_aal1_nullErrorCorrection,
        __VCCapability_aal1_longInterleaver,
        __VCCapability_aal1_shortInterleaver,
        __VCCapability_aal1_errorCorrectionOnly,
        __VCCapability_aal1_structuredDataTransfer,
        __VCCapability_aal1_partiallyFilledCells,
        _VCCapability_aal1,
        __VCCapability_aal5_forwardMaximumSDUSize,
        __VCCapability_aal5_backwardMaximumSDUSize,
        _VCCapability_aal5,
        _VCCapability_transportStream,
        _VCCapability_programStream,
        ___VCCapability_availableBitRates_type_singleBitRate,
        ____VCCapability_availableBitRates_type_rangeOfBitRates_lowerBitRate,
        ____VCCapability_availableBitRates_type_rangeOfBitRates_higherBitRate,
        ___VCCapability_availableBitRates_type_rangeOfBitRates,
        __VCCapability_availableBitRates_type,
        _VCCapability_availableBitRates,
        ___VCCapability_aal1ViaGateway_gatewayAddress__item_,
        __VCCapability_aal1ViaGateway_gatewayAddress,
        __VCCapability_aal1ViaGateway_nullClockRecovery,
        __VCCapability_aal1ViaGateway_srtsClockRecovery,
        __VCCapability_aal1ViaGateway_adaptiveClockRecovery,
        __VCCapability_aal1ViaGateway_nullErrorCorrection,
        __VCCapability_aal1ViaGateway_longInterleaver,
        __VCCapability_aal1ViaGateway_shortInterleaver,
        __VCCapability_aal1ViaGateway_errorCorrectionOnly,
        __VCCapability_aal1ViaGateway_structuredDataTransfer,
        __VCCapability_aal1ViaGateway_partiallyFilledCells,
        _VCCapability_aal1ViaGateway,
        VCCapability,
        _H223Capability_transportWithI_frames,
        _H223Capability_videoWithAL1,
        _H223Capability_videoWithAL2,
        _H223Capability_videoWithAL3,
        _H223Capability_audioWithAL1,
        _H223Capability_audioWithAL2,
        _H223Capability_audioWithAL3,
        _H223Capability_dataWithAL1,
        _H223Capability_dataWithAL2,
        _H223Capability_dataWithAL3,
        _H223Capability_maximumAl2SDUSize,
        _H223Capability_maximumAl3SDUSize,
        _H223Capability_maximumDelayJitter,
        __H223Capability_h223MultiplexTableCapability_basic,
        ___H223Capability_h223MultiplexTableCapability_enhanced_maximumNestingDepth,
        ___H223Capability_h223MultiplexTableCapability_enhanced_maximumElementListSize,
        ___H223Capability_h223MultiplexTableCapability_enhanced_maximumSubElementListSize,
        __H223Capability_h223MultiplexTableCapability_enhanced,
        _H223Capability_h223MultiplexTableCapability,
        _H223Capability_maxMUXPDUSizeCapability,
        _H223Capability_nsrpSupport,
        __H223Capability_mobileOperationTransmitCapability_modeChangeCapability,
        __H223Capability_mobileOperationTransmitCapability_h223AnnexA,
        __H223Capability_mobileOperationTransmitCapability_h223AnnexADoubleFlag,
        __H223Capability_mobileOperationTransmitCapability_h223AnnexB,
        __H223Capability_mobileOperationTransmitCapability_h223AnnexBwithHeader,
        _H223Capability_mobileOperationTransmitCapability,
        _H223Capability_h223AnnexCCapability,
        _H223Capability_bitRate,
        __H223Capability_mobileMultilinkFrameCapability_maximumSampleSize,
        __H223Capability_mobileMultilinkFrameCapability_maximumPayloadLength,
        _H223Capability_mobileMultilinkFrameCapability,
        H223Capability,
        _H223AnnexCCapability_videoWithAL1M,
        _H223AnnexCCapability_videoWithAL2M,
        _H223AnnexCCapability_videoWithAL3M,
        _H223AnnexCCapability_audioWithAL1M,
        _H223AnnexCCapability_audioWithAL2M,
        _H223AnnexCCapability_audioWithAL3M,
        _H223AnnexCCapability_dataWithAL1M,
        _H223AnnexCCapability_dataWithAL2M,
        _H223AnnexCCapability_dataWithAL3M,
        _H223AnnexCCapability_alpduInterleaving,
        _H223AnnexCCapability_maximumAL1MPDUSize,
        _H223AnnexCCapability_maximumAL2MSDUSize,
        _H223AnnexCCapability_maximumAL3MSDUSize,
        _H223AnnexCCapability_rsCodeCapability,
        H223AnnexCCapability,
        _V76Capability_suspendResumeCapabilitywAddress,
        _V76Capability_suspendResumeCapabilitywoAddress,
        _V76Capability_rejCapability,
        _V76Capability_sREJCapability,
        _V76Capability_mREJCapability,
        _V76Capability_crc8bitCapability,
        _V76Capability_crc16bitCapability,
        _V76Capability_crc32bitCapability,
        _V76Capability_uihCapability,
        _V76Capability_numOfDLCS,
        _V76Capability_twoOctetAddressFieldCapability,
        _V76Capability_loopBackTestCapability,
        _V76Capability_n401Capability,
        _V76Capability_maxWindowSizeCapability,
        _V76Capability_v75Capability,
        V76Capability,
        _V75Capability_audioHeader,
        V75Capability,
        _H2250Capability_maximumAudioDelayJitter,
        _H2250Capability_receiveMultipointCapability,
        _H2250Capability_transmitMultipointCapability,
        _H2250Capability_receiveAndTransmitMultipointCapability,
        __H2250Capability_mcCapability_centralizedConferenceMC,
        __H2250Capability_mcCapability_decentralizedConferenceMC,
        _H2250Capability_mcCapability,
        _H2250Capability_rtcpVideoControlCapability,
        _H2250Capability_mediaPacketizationCapability,
        _H2250Capability_transportCapability,
        __H2250Capability_redundancyEncodingCapability__item_,
        _H2250Capability_redundancyEncodingCapability,
        _H2250Capability_logicalChannelSwitchingCapability,
        _H2250Capability_t120DynamicPortCapability,
        H2250Capability,
        _MediaPacketizationCapability_h261aVideoPacketization,
        __MediaPacketizationCapability_rtpPayloadType__item_,
        _MediaPacketizationCapability_rtpPayloadType,
        MediaPacketizationCapability,
        _RSVPParameters_qosMode,
        _RSVPParameters_tokenRate,
        _RSVPParameters_bucketSize,
        _RSVPParameters_peakRate,
        _RSVPParameters_minPoliced,
        _RSVPParameters_maxPktSize,
        RSVPParameters,
        _QOSMode_guaranteedQOS,
        _QOSMode_controlledLoad,
        QOSMode,
        _ATMParameters_maxNTUSize,
        _ATMParameters_atmUBR,
        _ATMParameters_atmrtVBR,
        _ATMParameters_atmnrtVBR,
        _ATMParameters_atmABR,
        _ATMParameters_atmCBR,
        ATMParameters,
        _ServicePriorityValue_nonStandardParameter,
        _ServicePriorityValue_value,
        ServicePriorityValue,
        _ServicePriority_nonStandardData,
        _ServicePriority_servicePrioritySignalled,
        _ServicePriority_servicePriorityValue,
        _ServicePriority_serviceClass,
        _ServicePriority_serviceSubclass,
        ServicePriority,
        _AuthorizationParameters_nonStandardData,
        AuthorizationParameters,
        _QOSType_desired,
        _QOSType_required,
        QOSType,
        _QOSClass_class0,
        _QOSClass_class1,
        _QOSClass_class2,
        _QOSClass_class3,
        _QOSClass_class4,
        _QOSClass_class5,
        QOSClass,
        _QOSDescriptor_nonStandardData,
        _QOSDescriptor_qosType,
        _QOSDescriptor_qosClass,
        QOSDescriptor,
        _GenericTransportParameters_nonStandardData,
        _GenericTransportParameters_averageRate,
        _GenericTransportParameters_burst,
        _GenericTransportParameters_peakRate,
        _GenericTransportParameters_maxPktSize,
        GenericTransportParameters,
        _QOSCapability_nonStandardData,
        _QOSCapability_rsvpParameters,
        _QOSCapability_atmParameters,
        _QOSCapability_localQoS,
        _QOSCapability_genericTransportParameters,
        _QOSCapability_servicePriority,
        _QOSCapability_authorizationParameter,
        _QOSCapability_qosDescriptor,
        _QOSCapability_dscpValue,
        QOSCapability,
        _MediaTransportType_ip_UDP,
        _MediaTransportType_ip_TCP,
        _MediaTransportType_atm_AAL5_UNIDIR,
        _MediaTransportType_atm_AAL5_BIDIR,
        __MediaTransportType_atm_AAL5_compressed_variable_delta,
        _MediaTransportType_atm_AAL5_compressed,
        MediaTransportType,
        _MediaChannelCapability_mediaTransport,
        MediaChannelCapability,
        _TransportCapability_nonStandard,
        __TransportCapability_qOSCapabilities__item_,
        _TransportCapability_qOSCapabilities,
        __TransportCapability_mediaChannelCapabilities__item_,
        _TransportCapability_mediaChannelCapabilities,
        TransportCapability,
        _RedundancyEncodingCapability_redundancyEncodingMethod,
        _RedundancyEncodingCapability_primaryEncoding,
        __RedundancyEncodingCapability_secondaryEncoding__item_,
        _RedundancyEncodingCapability_secondaryEncoding,
        RedundancyEncodingCapability,
        _RedundancyEncodingMethod_nonStandard,
        _RedundancyEncodingMethod_rtpAudioRedundancyEncoding,
        _RedundancyEncodingMethod_rtpH263VideoRedundancyEncoding,
        RedundancyEncodingMethod,
        _RTPH263VideoRedundancyEncoding_numberOfThreads,
        _RTPH263VideoRedundancyEncoding_framesBetweenSyncPoints,
        __RTPH263VideoRedundancyEncoding_frameToThreadMapping_roundrobin,
        ___RTPH263VideoRedundancyEncoding_frameToThreadMapping_custom__item_,
        __RTPH263VideoRedundancyEncoding_frameToThreadMapping_custom,
        _RTPH263VideoRedundancyEncoding_frameToThreadMapping,
        __RTPH263VideoRedundancyEncoding_containedThreads__item_,
        _RTPH263VideoRedundancyEncoding_containedThreads,
        RTPH263VideoRedundancyEncoding,
        _RTPH263VideoRedundancyFrameMapping_threadNumber,
        __RTPH263VideoRedundancyFrameMapping_frameSequence__item_,
        _RTPH263VideoRedundancyFrameMapping_frameSequence,
        RTPH263VideoRedundancyFrameMapping,
        _MultipointCapability_multicastCapability,
        _MultipointCapability_multiUniCastConference,
        __MultipointCapability_mediaDistributionCapability__item_,
        _MultipointCapability_mediaDistributionCapability,
        MultipointCapability,
        _MediaDistributionCapability_centralizedControl,
        _MediaDistributionCapability_distributedControl,
        _MediaDistributionCapability_centralizedAudio,
        _MediaDistributionCapability_distributedAudio,
        _MediaDistributionCapability_centralizedVideo,
        _MediaDistributionCapability_distributedVideo,
        __MediaDistributionCapability_centralizedData__item_,
        _MediaDistributionCapability_centralizedData,
        __MediaDistributionCapability_distributedData__item_,
        _MediaDistributionCapability_distributedData,
        MediaDistributionCapability,
        _VideoCapability_nonStandard,
        _VideoCapability_h261VideoCapability,
        _VideoCapability_h262VideoCapability,
        _VideoCapability_h263VideoCapability,
        _VideoCapability_is11172VideoCapability,
        _VideoCapability_genericVideoCapability,
        _VideoCapability_extendedVideoCapability,
        VideoCapability,
        __ExtendedVideoCapability_videoCapability__item_,
        _ExtendedVideoCapability_videoCapability,
        __ExtendedVideoCapability_videoCapabilityExtension__item_,
        _ExtendedVideoCapability_videoCapabilityExtension,
        ExtendedVideoCapability,
        _H261VideoCapability_qcifMPI,
        _H261VideoCapability_cifMPI,
        _H261VideoCapability_temporalSpatialTradeOffCapability,
        _H261VideoCapability_maxBitRate,
        _H261VideoCapability_stillImageTransmission,
        _H261VideoCapability_videoBadMBsCap,
        H261VideoCapability,
        _H262VideoCapability_profileAndLevel_SPatML,
        _H262VideoCapability_profileAndLevel_MPatLL,
        _H262VideoCapability_profileAndLevel_MPatML,
        _H262VideoCapability_profileAndLevel_MPatH_14,
        _H262VideoCapability_profileAndLevel_MPatHL,
        _H262VideoCapability_profileAndLevel_SNRatLL,
        _H262VideoCapability_profileAndLevel_SNRatML,
        _H262VideoCapability_profileAndLevel_SpatialatH_14,
        _H262VideoCapability_profileAndLevel_HPatML,
        _H262VideoCapability_profileAndLevel_HPatH_14,
        _H262VideoCapability_profileAndLevel_HPatHL,
        _H262VideoCapability_videoBitRate,
        _H262VideoCapability_vbvBufferSize,
        _H262VideoCapability_samplesPerLine,
        _H262VideoCapability_linesPerFrame,
        _H262VideoCapability_framesPerSecond,
        _H262VideoCapability_luminanceSampleRate,
        _H262VideoCapability_videoBadMBsCap,
        H262VideoCapability,
        _H263VideoCapability_sqcifMPI,
        _H263VideoCapability_qcifMPI,
        _H263VideoCapability_cifMPI,
        _H263VideoCapability_cif4MPI,
        _H263VideoCapability_cif16MPI,
        _H263VideoCapability_maxBitRate,
        _H263VideoCapability_unrestrictedVector,
        _H263VideoCapability_arithmeticCoding,
        _H263VideoCapability_advancedPrediction,
        _H263VideoCapability_pbFrames,
        _H263VideoCapability_temporalSpatialTradeOffCapability,
        _H263VideoCapability_hrd_B,
        _H263VideoCapability_bppMaxKb,
        _H263VideoCapability_slowSqcifMPI,
        _H263VideoCapability_slowQcifMPI,
        _H263VideoCapability_slowCifMPI,
        _H263VideoCapability_slowCif4MPI,
        _H263VideoCapability_slowCif16MPI,
        _H263VideoCapability_errorCompensation,
        _H263VideoCapability_enhancementLayerInfo,
        _H263VideoCapability_h263Options,
        H263VideoCapability,
        _EnhancementLayerInfo_baseBitRateConstrained,
        __EnhancementLayerInfo_snrEnhancement__item_,
        _EnhancementLayerInfo_snrEnhancement,
        __EnhancementLayerInfo_spatialEnhancement__item_,
        _EnhancementLayerInfo_spatialEnhancement,
        __EnhancementLayerInfo_bPictureEnhancement__item_,
        _EnhancementLayerInfo_bPictureEnhancement,
        EnhancementLayerInfo,
        _BEnhancementParameters_enhancementOptions,
        _BEnhancementParameters_numberOfBPictures,
        BEnhancementParameters,
        _EnhancementOptions_sqcifMPI,
        _EnhancementOptions_qcifMPI,
        _EnhancementOptions_cifMPI,
        _EnhancementOptions_cif4MPI,
        _EnhancementOptions_cif16MPI,
        _EnhancementOptions_maxBitRate,
        _EnhancementOptions_unrestrictedVector,
        _EnhancementOptions_arithmeticCoding,
        _EnhancementOptions_temporalSpatialTradeOffCapability,
        _EnhancementOptions_slowSqcifMPI,
        _EnhancementOptions_slowQcifMPI,
        _EnhancementOptions_slowCifMPI,
        _EnhancementOptions_slowCif4MPI,
        _EnhancementOptions_slowCif16MPI,
        _EnhancementOptions_errorCompensation,
        _EnhancementOptions_h263Options,
        EnhancementOptions,
        _H263Options_advancedIntraCodingMode,
        _H263Options_deblockingFilterMode,
        _H263Options_improvedPBFramesMode,
        _H263Options_unlimitedMotionVectors,
        _H263Options_fullPictureFreeze,
        _H263Options_partialPictureFreezeAndRelease,
        _H263Options_resizingPartPicFreezeAndRelease,
        _H263Options_fullPictureSnapshot,
        _H263Options_partialPictureSnapshot,
        _H263Options_videoSegmentTagging,
        _H263Options_progressiveRefinement,
        _H263Options_dynamicPictureResizingByFour,
        _H263Options_dynamicPictureResizingSixteenthPel,
        _H263Options_dynamicWarpingHalfPel,
        _H263Options_dynamicWarpingSixteenthPel,
        _H263Options_independentSegmentDecoding,
        _H263Options_slicesInOrder_NonRect,
        _H263Options_slicesInOrder_Rect,
        _H263Options_slicesNoOrder_NonRect,
        _H263Options_slicesNoOrder_Rect,
        _H263Options_alternateInterVLCMode,
        _H263Options_modifiedQuantizationMode,
        _H263Options_reducedResolutionUpdate,
        _H263Options_transparencyParameters,
        _H263Options_separateVideoBackChannel,
        _H263Options_refPictureSelection,
        __H263Options_customPictureClockFrequency__item_,
        _H263Options_customPictureClockFrequency,
        __H263Options_customPictureFormat__item_,
        _H263Options_customPictureFormat,
        __H263Options_modeCombos__item_,
        _H263Options_modeCombos,
        _H263Options_videoBadMBsCap,
        _H263Options_h263Version3Options,
        H263Options,
        _TransparencyParameters_presentationOrder,
        _TransparencyParameters_offset_x,
        _TransparencyParameters_offset_y,
        _TransparencyParameters_scale_x,
        _TransparencyParameters_scale_y,
        TransparencyParameters,
        __RefPictureSelection_additionalPictureMemory_sqcifAdditionalPictureMemory,
        __RefPictureSelection_additionalPictureMemory_qcifAdditionalPictureMemory,
        __RefPictureSelection_additionalPictureMemory_cifAdditionalPictureMemory,
        __RefPictureSelection_additionalPictureMemory_cif4AdditionalPictureMemory,
        __RefPictureSelection_additionalPictureMemory_cif16AdditionalPictureMemory,
        __RefPictureSelection_additionalPictureMemory_bigCpfAdditionalPictureMemory,
        _RefPictureSelection_additionalPictureMemory,
        _RefPictureSelection_videoMux,
        __RefPictureSelection_videoBackChannelSend_none,
        __RefPictureSelection_videoBackChannelSend_ackMessageOnly,
        __RefPictureSelection_videoBackChannelSend_nackMessageOnly,
        __RefPictureSelection_videoBackChannelSend_ackOrNackMessageOnly,
        __RefPictureSelection_videoBackChannelSend_ackAndNackMessage,
        _RefPictureSelection_videoBackChannelSend,
        ___RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters_mpuHorizMBs,
        ___RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters_mpuVertMBs,
        ___RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters_mpuTotalNumber,
        __RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters,
        _RefPictureSelection_enhancedReferencePicSelect,
        RefPictureSelection,
        _CustomPictureClockFrequency_clockConversionCode,
        _CustomPictureClockFrequency_clockDivisor,
        _CustomPictureClockFrequency_sqcifMPI,
        _CustomPictureClockFrequency_qcifMPI,
        _CustomPictureClockFrequency_cifMPI,
        _CustomPictureClockFrequency_cif4MPI,
        _CustomPictureClockFrequency_cif16MPI,
        CustomPictureClockFrequency,
        _CustomPictureFormat_maxCustomPictureWidth,
        _CustomPictureFormat_maxCustomPictureHeight,
        _CustomPictureFormat_minCustomPictureWidth,
        _CustomPictureFormat_minCustomPictureHeight,
        __CustomPictureFormat_mPI_standardMPI,
        ____CustomPictureFormat_mPI_customPCF__item__clockConversionCode,
        ____CustomPictureFormat_mPI_customPCF__item__clockDivisor,
        ____CustomPictureFormat_mPI_customPCF__item__customMPI,
        ___CustomPictureFormat_mPI_customPCF__item_,
        __CustomPictureFormat_mPI_customPCF,
        _CustomPictureFormat_mPI,
        __CustomPictureFormat_pixelAspectInformation_anyPixelAspectRatio,
        ___CustomPictureFormat_pixelAspectInformation_pixelAspectCode__item_,
        __CustomPictureFormat_pixelAspectInformation_pixelAspectCode,
        ____CustomPictureFormat_pixelAspectInformation_extendedPAR__item__width,
        ____CustomPictureFormat_pixelAspectInformation_extendedPAR__item__height,
        ___CustomPictureFormat_pixelAspectInformation_extendedPAR__item_,
        __CustomPictureFormat_pixelAspectInformation_extendedPAR,
        _CustomPictureFormat_pixelAspectInformation,
        CustomPictureFormat,
        _H263VideoModeCombos_h263VideoUncoupledModes,
        __H263VideoModeCombos_h263VideoCoupledModes__item_,
        _H263VideoModeCombos_h263VideoCoupledModes,
        H263VideoModeCombos,
        _H263ModeComboFlags_unrestrictedVector,
        _H263ModeComboFlags_arithmeticCoding,
        _H263ModeComboFlags_advancedPrediction,
        _H263ModeComboFlags_pbFrames,
        _H263ModeComboFlags_advancedIntraCodingMode,
        _H263ModeComboFlags_deblockingFilterMode,
        _H263ModeComboFlags_unlimitedMotionVectors,
        _H263ModeComboFlags_slicesInOrder_NonRect,
        _H263ModeComboFlags_slicesInOrder_Rect,
        _H263ModeComboFlags_slicesNoOrder_NonRect,
        _H263ModeComboFlags_slicesNoOrder_Rect,
        _H263ModeComboFlags_improvedPBFramesMode,
        _H263ModeComboFlags_referencePicSelect,
        _H263ModeComboFlags_dynamicPictureResizingByFour,
        _H263ModeComboFlags_dynamicPictureResizingSixteenthPel,
        _H263ModeComboFlags_dynamicWarpingHalfPel,
        _H263ModeComboFlags_dynamicWarpingSixteenthPel,
        _H263ModeComboFlags_reducedResolutionUpdate,
        _H263ModeComboFlags_independentSegmentDecoding,
        _H263ModeComboFlags_alternateInterVLCMode,
        _H263ModeComboFlags_modifiedQuantizationMode,
        _H263ModeComboFlags_enhancedReferencePicSelect,
        _H263ModeComboFlags_h263Version3Options,
        H263ModeComboFlags,
        _H263Version3Options_dataPartitionedSlices,
        _H263Version3Options_fixedPointIDCT0,
        _H263Version3Options_interlacedFields,
        _H263Version3Options_currentPictureHeaderRepetition,
        _H263Version3Options_previousPictureHeaderRepetition,
        _H263Version3Options_nextPictureHeaderRepetition,
        _H263Version3Options_pictureNumber,
        _H263Version3Options_spareReferencePictures,
        H263Version3Options,
        _IS11172VideoCapability_constrainedBitstream,
        _IS11172VideoCapability_videoBitRate,
        _IS11172VideoCapability_vbvBufferSize,
        _IS11172VideoCapability_samplesPerLine,
        _IS11172VideoCapability_linesPerFrame,
        _IS11172VideoCapability_pictureRate,
        _IS11172VideoCapability_luminanceSampleRate,
        _IS11172VideoCapability_videoBadMBsCap,
        IS11172VideoCapability,
        _AudioCapability_nonStandard,
        _AudioCapability_g711Alaw64k,
        _AudioCapability_g711Alaw56k,
        _AudioCapability_g711Ulaw64k,
        _AudioCapability_g711Ulaw56k,
        _AudioCapability_g722_64k,
        _AudioCapability_g722_56k,
        _AudioCapability_g722_48k,
        __AudioCapability_g7231_maxAl_sduAudioFrames,
        __AudioCapability_g7231_silenceSuppression,
        _AudioCapability_g7231,
        _AudioCapability_g728,
        _AudioCapability_g729,
        _AudioCapability_g729AnnexA,
        _AudioCapability_is11172AudioCapability,
        _AudioCapability_is13818AudioCapability,
        _AudioCapability_g729wAnnexB,
        _AudioCapability_g729AnnexAwAnnexB,
        _AudioCapability_g7231AnnexCCapability,
        _AudioCapability_gsmFullRate,
        _AudioCapability_gsmHalfRate,
        _AudioCapability_gsmEnhancedFullRate,
        _AudioCapability_genericAudioCapability,
        _AudioCapability_g729Extensions,
        _AudioCapability_vbd,
        _AudioCapability_audioTelephonyEvent,
        _AudioCapability_audioTone,
        AudioCapability,
        _G729Extensions_audioUnit,
        _G729Extensions_annexA,
        _G729Extensions_annexB,
        _G729Extensions_annexD,
        _G729Extensions_annexE,
        _G729Extensions_annexF,
        _G729Extensions_annexG,
        _G729Extensions_annexH,
        G729Extensions,
        _G7231AnnexCCapability_maxAl_sduAudioFrames,
        _G7231AnnexCCapability_silenceSuppression,
        __G7231AnnexCCapability_g723AnnexCAudioMode_highRateMode0,
        __G7231AnnexCCapability_g723AnnexCAudioMode_highRateMode1,
        __G7231AnnexCCapability_g723AnnexCAudioMode_lowRateMode0,
        __G7231AnnexCCapability_g723AnnexCAudioMode_lowRateMode1,
        __G7231AnnexCCapability_g723AnnexCAudioMode_sidMode0,
        __G7231AnnexCCapability_g723AnnexCAudioMode_sidMode1,
        _G7231AnnexCCapability_g723AnnexCAudioMode,
        G7231AnnexCCapability,
        _IS11172AudioCapability_audioLayer1,
        _IS11172AudioCapability_audioLayer2,
        _IS11172AudioCapability_audioLayer3,
        _IS11172AudioCapability_audioSampling32k,
        _IS11172AudioCapability_audioSampling44k1,
        _IS11172AudioCapability_audioSampling48k,
        _IS11172AudioCapability_singleChannel,
        _IS11172AudioCapability_twoChannels,
        _IS11172AudioCapability_bitRate,
        IS11172AudioCapability,
        _IS13818AudioCapability_audioLayer1,
        _IS13818AudioCapability_audioLayer2,
        _IS13818AudioCapability_audioLayer3,
        _IS13818AudioCapability_audioSampling16k,
        _IS13818AudioCapability_audioSampling22k05,
        _IS13818AudioCapability_audioSampling24k,
        _IS13818AudioCapability_audioSampling32k,
        _IS13818AudioCapability_audioSampling44k1,
        _IS13818AudioCapability_audioSampling48k,
        _IS13818AudioCapability_singleChannel,
        _IS13818AudioCapability_twoChannels,
        _IS13818AudioCapability_threeChannels2_1,
        _IS13818AudioCapability_threeChannels3_0,
        _IS13818AudioCapability_fourChannels2_0_2_0,
        _IS13818AudioCapability_fourChannels2_2,
        _IS13818AudioCapability_fourChannels3_1,
        _IS13818AudioCapability_fiveChannels3_0_2_0,
        _IS13818AudioCapability_fiveChannels3_2,
        _IS13818AudioCapability_lowFrequencyEnhancement,
        _IS13818AudioCapability_multilingual,
        _IS13818AudioCapability_bitRate,
        IS13818AudioCapability,
        _GSMAudioCapability_audioUnitSize,
        _GSMAudioCapability_comfortNoise,
        _GSMAudioCapability_scrambled,
        GSMAudioCapability,
        _VBDCapability_type,
        VBDCapability,
        __DataApplicationCapability_application_nonStandard,
        __DataApplicationCapability_application_t120,
        __DataApplicationCapability_application_dsm_cc,
        __DataApplicationCapability_application_userData,
        ___DataApplicationCapability_application_t84_t84Protocol,
        ___DataApplicationCapability_application_t84_t84Profile,
        __DataApplicationCapability_application_t84,
        __DataApplicationCapability_application_t434,
        __DataApplicationCapability_application_h224,
        ___DataApplicationCapability_application_nlpid_nlpidProtocol,
        ___DataApplicationCapability_application_nlpid_nlpidData,
        __DataApplicationCapability_application_nlpid,
        __DataApplicationCapability_application_dsvdControl,
        __DataApplicationCapability_application_h222DataPartitioning,
        __DataApplicationCapability_application_t30fax,
        __DataApplicationCapability_application_t140,
        ___DataApplicationCapability_application_t38fax_t38FaxProtocol,
        ___DataApplicationCapability_application_t38fax_t38FaxProfile,
        __DataApplicationCapability_application_t38fax,
        __DataApplicationCapability_application_genericDataCapability,
        _DataApplicationCapability_application,
        _DataApplicationCapability_maxBitRate,
        DataApplicationCapability,
        _DataProtocolCapability_nonStandard,
        _DataProtocolCapability_v14buffered,
        _DataProtocolCapability_v42lapm,
        _DataProtocolCapability_hdlcFrameTunnelling,
        _DataProtocolCapability_h310SeparateVCStack,
        _DataProtocolCapability_h310SingleVCStack,
        _DataProtocolCapability_transparent,
        _DataProtocolCapability_segmentationAndReassembly,
        _DataProtocolCapability_hdlcFrameTunnelingwSAR,
        _DataProtocolCapability_v120,
        _DataProtocolCapability_separateLANStack,
        __DataProtocolCapability_v76wCompression_transmitCompression,
        __DataProtocolCapability_v76wCompression_receiveCompression,
        __DataProtocolCapability_v76wCompression_transmitAndReceiveCompression,
        _DataProtocolCapability_v76wCompression,
        _DataProtocolCapability_tcp,
        _DataProtocolCapability_udp,
        DataProtocolCapability,
        _CompressionType_v42bis,
        CompressionType,
        _V42bis_numberOfCodewords,
        _V42bis_maximumStringLength,
        V42bis,
        _T84Profile_t84Unrestricted,
        __T84Profile_t84Restricted_qcif,
        __T84Profile_t84Restricted_cif,
        __T84Profile_t84Restricted_ccir601Seq,
        __T84Profile_t84Restricted_ccir601Prog,
        __T84Profile_t84Restricted_hdtvSeq,
        __T84Profile_t84Restricted_hdtvProg,
        __T84Profile_t84Restricted_g3FacsMH200x100,
        __T84Profile_t84Restricted_g3FacsMH200x200,
        __T84Profile_t84Restricted_g4FacsMMR200x100,
        __T84Profile_t84Restricted_g4FacsMMR200x200,
        __T84Profile_t84Restricted_jbig200x200Seq,
        __T84Profile_t84Restricted_jbig200x200Prog,
        __T84Profile_t84Restricted_jbig300x300Seq,
        __T84Profile_t84Restricted_jbig300x300Prog,
        __T84Profile_t84Restricted_digPhotoLow,
        __T84Profile_t84Restricted_digPhotoMedSeq,
        __T84Profile_t84Restricted_digPhotoMedProg,
        __T84Profile_t84Restricted_digPhotoHighSeq,
        __T84Profile_t84Restricted_digPhotoHighProg,
        _T84Profile_t84Restricted,
        T84Profile,
        _T38FaxProfile_fillBitRemoval,
        _T38FaxProfile_transcodingJBIG,
        _T38FaxProfile_transcodingMMR,
        _T38FaxProfile_version,
        _T38FaxProfile_t38FaxRateManagement,
        _T38FaxProfile_t38FaxUdpOptions,
        _T38FaxProfile_t38FaxTcpOptions,
        T38FaxProfile,
        _T38FaxRateManagement_localTCF,
        _T38FaxRateManagement_transferredTCF,
        T38FaxRateManagement,
        _T38FaxUdpOptions_t38FaxMaxBuffer,
        _T38FaxUdpOptions_t38FaxMaxDatagram,
        __T38FaxUdpOptions_t38FaxUdpEC_t38UDPFEC,
        __T38FaxUdpOptions_t38FaxUdpEC_t38UDPRedundancy,
        _T38FaxUdpOptions_t38FaxUdpEC,
        T38FaxUdpOptions,
        _T38FaxTcpOptions_t38TCPBidirectionalMode,
        T38FaxTcpOptions,
        _EncryptionAuthenticationAndIntegrity_encryptionCapability,
        _EncryptionAuthenticationAndIntegrity_authenticationCapability,
        _EncryptionAuthenticationAndIntegrity_integrityCapability,
        _EncryptionAuthenticationAndIntegrity_genericH235SecurityCapability,
        EncryptionAuthenticationAndIntegrity,
        _EncryptionCapability__item_,
        EncryptionCapability,
        _MediaEncryptionAlgorithm_nonStandard,
        _MediaEncryptionAlgorithm_algorithm,
        MediaEncryptionAlgorithm,
        _AuthenticationCapability_nonStandard,
        _AuthenticationCapability_antiSpamAlgorithm,
        AuthenticationCapability,
        _IntegrityCapability_nonStandard,
        IntegrityCapability,
        __UserInputCapability_nonStandard__item_,
        _UserInputCapability_nonStandard,
        _UserInputCapability_basicString,
        _UserInputCapability_iA5String,
        _UserInputCapability_generalString,
        _UserInputCapability_dtmf,
        _UserInputCapability_hookflash,
        _UserInputCapability_extendedAlphanumeric,
        _UserInputCapability_encryptedBasicString,
        _UserInputCapability_encryptedIA5String,
        _UserInputCapability_encryptedGeneralString,
        _UserInputCapability_secureDTMF,
        _UserInputCapability_genericUserInputCapability,
        UserInputCapability,
        __ConferenceCapability_nonStandardData__item_,
        _ConferenceCapability_nonStandardData,
        _ConferenceCapability_chairControlCapability,
        _ConferenceCapability_videoIndicateMixingCapability,
        _ConferenceCapability_multipointVisualizationCapability,
        ConferenceCapability,
        _GenericCapability_capabilityIdentifier,
        _GenericCapability_maxBitRate,
        __GenericCapability_collapsing__item_,
        _GenericCapability_collapsing,
        __GenericCapability_nonCollapsing__item_,
        _GenericCapability_nonCollapsing,
        _GenericCapability_nonCollapsingRaw,
        _GenericCapability_transport,
        GenericCapability,
        _CapabilityIdentifier_standard,
        _CapabilityIdentifier_h221NonStandard,
        _CapabilityIdentifier_uuid,
        _CapabilityIdentifier_domainBased,
        CapabilityIdentifier,
        _GenericParameter_parameterIdentifier,
        _GenericParameter_parameterValue,
        __GenericParameter_supersedes__item_,
        _GenericParameter_supersedes,
        GenericParameter,
        _ParameterIdentifier_standard,
        _ParameterIdentifier_h221NonStandard,
        _ParameterIdentifier_uuid,
        _ParameterIdentifier_domainBased,
        ParameterIdentifier,
        _ParameterValue_logical,
        _ParameterValue_booleanArray,
        _ParameterValue_unsignedMin,
        _ParameterValue_unsignedMax,
        _ParameterValue_unsigned32Min,
        _ParameterValue_unsigned32Max,
        _ParameterValue_octetString,
        __ParameterValue_genericParameter__item_,
        _ParameterValue_genericParameter,
        ParameterValue,
        _MultiplexedStreamCapability_multiplexFormat,
        _MultiplexedStreamCapability_controlOnMuxStream,
        __MultiplexedStreamCapability_capabilityOnMuxStream__item_,
        _MultiplexedStreamCapability_capabilityOnMuxStream,
        MultiplexedStreamCapability,
        _MultiplexFormat_nonStandard,
        _MultiplexFormat_h222Capability,
        _MultiplexFormat_h223Capability,
        MultiplexFormat,
        _AudioTelephonyEventCapability_dynamicRTPPayloadType,
        _AudioTelephonyEventCapability_audioTelephoneEvent,
        AudioTelephonyEventCapability,
        _AudioToneCapability_dynamicRTPPayloadType,
        AudioToneCapability,
        _NoPTAudioTelephonyEventCapability_audioTelephoneEvent,
        NoPTAudioTelephonyEventCapability,
        NoPTAudioToneCapability,
        __MultiplePayloadStreamCapability_capabilities__item_,
        _MultiplePayloadStreamCapability_capabilities,
        MultiplePayloadStreamCapability,
        __DepFECCapability_rfc2733_redundancyEncoding,
        ___DepFECCapability_rfc2733_separateStream_separatePort,
        ___DepFECCapability_rfc2733_separateStream_samePort,
        __DepFECCapability_rfc2733_separateStream,
        _DepFECCapability_rfc2733,
        DepFECCapability,
        _FECCapability_protectedCapability,
        _FECCapability_fecScheme,
        __FECCapability_rfc2733Format_rfc2733rfc2198,
        __FECCapability_rfc2733Format_rfc2733sameport,
        __FECCapability_rfc2733Format_rfc2733diffport,
        _FECCapability_rfc2733Format,
        FECCapability,
        MaxRedundancy,
        _OpenLogicalChannel_forwardLogicalChannelNumber,
        __OpenLogicalChannel_forwardLogicalChannelParameters_portNumber,
        __OpenLogicalChannel_forwardLogicalChannelParameters_dataType,
        ___OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_h222LogicalChannelParameters,
        ___OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_h223LogicalChannelParameters,
        ___OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_v76LogicalChannelParameters,
        ___OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_h2250LogicalChannelParameters,
        ___OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_none,
        __OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters,
        __OpenLogicalChannel_forwardLogicalChannelParameters_forwardLogicalChannelDependency,
        __OpenLogicalChannel_forwardLogicalChannelParameters_replacementFor,
        _OpenLogicalChannel_forwardLogicalChannelParameters,
        __OpenLogicalChannel_reverseLogicalChannelParameters_dataType,
        ___OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_h223LogicalChannelParameters,
        ___OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_v76LogicalChannelParameters,
        ___OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_h2250LogicalChannelParameters,
        __OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters,
        __OpenLogicalChannel_reverseLogicalChannelParameters_reverseLogicalChannelDependency,
        __OpenLogicalChannel_reverseLogicalChannelParameters_replacementFor,
        _OpenLogicalChannel_reverseLogicalChannelParameters,
        _OpenLogicalChannel_separateStack,
        _OpenLogicalChannel_encryptionSync,
        __OpenLogicalChannel_genericInformation__item_,
        _OpenLogicalChannel_genericInformation,
        OpenLogicalChannel,
        LogicalChannelNumber,
        __NetworkAccessParameters_distribution_unicast,
        __NetworkAccessParameters_distribution_multicast,
        _NetworkAccessParameters_distribution,
        __NetworkAccessParameters_networkAddress_q2931Address,
        __NetworkAccessParameters_networkAddress_e164Address,
        __NetworkAccessParameters_networkAddress_localAreaAddress,
        _NetworkAccessParameters_networkAddress,
        _NetworkAccessParameters_associateConference,
        _NetworkAccessParameters_externalReference,
        __NetworkAccessParameters_t120SetupProcedure_originateCall,
        __NetworkAccessParameters_t120SetupProcedure_waitForCall,
        __NetworkAccessParameters_t120SetupProcedure_issueQuery,
        _NetworkAccessParameters_t120SetupProcedure,
        NetworkAccessParameters,
        __Q2931Address_address_internationalNumber,
        __Q2931Address_address_nsapAddress,
        _Q2931Address_address,
        _Q2931Address_subaddress,
        Q2931Address,
        _V75Parameters_audioHeaderPresent,
        V75Parameters,
        _DataType_nonStandard,
        _DataType_nullData,
        _DataType_videoData,
        _DataType_audioData,
        _DataType_data,
        _DataType_encryptionData,
        _DataType_h235Control,
        _DataType_h235Media,
        _DataType_multiplexedStream,
        _DataType_redundancyEncoding,
        _DataType_multiplePayloadStream,
        _DataType_depFec,
        _DataType_fec,
        DataType,
        _H235Media_encryptionAuthenticationAndIntegrity,
        __H235Media_mediaType_nonStandard,
        __H235Media_mediaType_videoData,
        __H235Media_mediaType_audioData,
        __H235Media_mediaType_data,
        __H235Media_mediaType_redundancyEncoding,
        __H235Media_mediaType_multiplePayloadStream,
        __H235Media_mediaType_depFec,
        __H235Media_mediaType_fec,
        _H235Media_mediaType,
        H235Media,
        _MultiplexedStreamParameter_multiplexFormat,
        _MultiplexedStreamParameter_controlOnMuxStream,
        MultiplexedStreamParameter,
        _H222LogicalChannelParameters_resourceID,
        _H222LogicalChannelParameters_subChannelID,
        _H222LogicalChannelParameters_pcr_pid,
        _H222LogicalChannelParameters_programDescriptors,
        _H222LogicalChannelParameters_streamDescriptors,
        H222LogicalChannelParameters,
        __H223LogicalChannelParameters_adaptationLayerType_nonStandard,
        __H223LogicalChannelParameters_adaptationLayerType_al1Framed,
        __H223LogicalChannelParameters_adaptationLayerType_al1NotFramed,
        __H223LogicalChannelParameters_adaptationLayerType_al2WithoutSequenceNumbers,
        __H223LogicalChannelParameters_adaptationLayerType_al2WithSequenceNumbers,
        ___H223LogicalChannelParameters_adaptationLayerType_al3_controlFieldOctets,
        ___H223LogicalChannelParameters_adaptationLayerType_al3_sendBufferSize,
        __H223LogicalChannelParameters_adaptationLayerType_al3,
        __H223LogicalChannelParameters_adaptationLayerType_al1M,
        __H223LogicalChannelParameters_adaptationLayerType_al2M,
        __H223LogicalChannelParameters_adaptationLayerType_al3M,
        _H223LogicalChannelParameters_adaptationLayerType,
        _H223LogicalChannelParameters_segmentableFlag,
        H223LogicalChannelParameters,
        __H223AL1MParameters_transferMode_framed,
        __H223AL1MParameters_transferMode_unframed,
        _H223AL1MParameters_transferMode,
        __H223AL1MParameters_headerFEC_sebch16_7,
        __H223AL1MParameters_headerFEC_golay24_12,
        _H223AL1MParameters_headerFEC,
        __H223AL1MParameters_crcLength_crc4bit,
        __H223AL1MParameters_crcLength_crc12bit,
        __H223AL1MParameters_crcLength_crc20bit,
        __H223AL1MParameters_crcLength_crc28bit,
        __H223AL1MParameters_crcLength_crc8bit,
        __H223AL1MParameters_crcLength_crc16bit,
        __H223AL1MParameters_crcLength_crc32bit,
        __H223AL1MParameters_crcLength_crcNotUsed,
        _H223AL1MParameters_crcLength,
        _H223AL1MParameters_rcpcCodeRate,
        __H223AL1MParameters_arqType_noArq,
        __H223AL1MParameters_arqType_typeIArq,
        __H223AL1MParameters_arqType_typeIIArq,
        _H223AL1MParameters_arqType,
        _H223AL1MParameters_alpduInterleaving,
        _H223AL1MParameters_alsduSplitting,
        _H223AL1MParameters_rsCodeCorrection,
        H223AL1MParameters,
        __H223AL2MParameters_headerFEC_sebch16_5,
        __H223AL2MParameters_headerFEC_golay24_12,
        _H223AL2MParameters_headerFEC,
        _H223AL2MParameters_alpduInterleaving,
        H223AL2MParameters,
        __H223AL3MParameters_headerFormat_sebch16_7,
        __H223AL3MParameters_headerFormat_golay24_12,
        _H223AL3MParameters_headerFormat,
        __H223AL3MParameters_crcLength_crc4bit,
        __H223AL3MParameters_crcLength_crc12bit,
        __H223AL3MParameters_crcLength_crc20bit,
        __H223AL3MParameters_crcLength_crc28bit,
        __H223AL3MParameters_crcLength_crc8bit,
        __H223AL3MParameters_crcLength_crc16bit,
        __H223AL3MParameters_crcLength_crc32bit,
        __H223AL3MParameters_crcLength_crcNotUsed,
        _H223AL3MParameters_crcLength,
        _H223AL3MParameters_rcpcCodeRate,
        __H223AL3MParameters_arqType_noArq,
        __H223AL3MParameters_arqType_typeIArq,
        __H223AL3MParameters_arqType_typeIIArq,
        _H223AL3MParameters_arqType,
        _H223AL3MParameters_alpduInterleaving,
        _H223AL3MParameters_rsCodeCorrection,
        H223AL3MParameters,
        __H223AnnexCArqParameters_numberOfRetransmissions_finite,
        __H223AnnexCArqParameters_numberOfRetransmissions_infinite,
        _H223AnnexCArqParameters_numberOfRetransmissions,
        _H223AnnexCArqParameters_sendBufferSize,
        H223AnnexCArqParameters,
        _V76LogicalChannelParameters_hdlcParameters,
        __V76LogicalChannelParameters_suspendResume_noSuspendResume,
        __V76LogicalChannelParameters_suspendResume_suspendResumewAddress,
        __V76LogicalChannelParameters_suspendResume_suspendResumewoAddress,
        _V76LogicalChannelParameters_suspendResume,
        _V76LogicalChannelParameters_uIH,
        ___V76LogicalChannelParameters_mode_eRM_windowSize,
        ____V76LogicalChannelParameters_mode_eRM_recovery_rej,
        ____V76LogicalChannelParameters_mode_eRM_recovery_sREJ,
        ____V76LogicalChannelParameters_mode_eRM_recovery_mSREJ,
        ___V76LogicalChannelParameters_mode_eRM_recovery,
        __V76LogicalChannelParameters_mode_eRM,
        __V76LogicalChannelParameters_mode_uNERM,
        _V76LogicalChannelParameters_mode,
        _V76LogicalChannelParameters_v75Parameters,
        V76LogicalChannelParameters,
        _V76HDLCParameters_crcLength,
        _V76HDLCParameters_n401,
        _V76HDLCParameters_loopbackTestProcedure,
        V76HDLCParameters,
        _CRCLength_crc8bit,
        _CRCLength_crc16bit,
        _CRCLength_crc32bit,
        CRCLength,
        __H2250LogicalChannelParameters_nonStandard__item_,
        _H2250LogicalChannelParameters_nonStandard,
        _H2250LogicalChannelParameters_sessionID,
        _H2250LogicalChannelParameters_associatedSessionID,
        _H2250LogicalChannelParameters_mediaChannel,
        _H2250LogicalChannelParameters_mediaGuaranteedDelivery,
        _H2250LogicalChannelParameters_mediaControlChannel,
        _H2250LogicalChannelParameters_mediaControlGuaranteedDelivery,
        _H2250LogicalChannelParameters_silenceSuppression,
        _H2250LogicalChannelParameters_destination,
        _H2250LogicalChannelParameters_dynamicRTPPayloadType,
        __H2250LogicalChannelParameters_mediaPacketization_h261aVideoPacketization,
        __H2250LogicalChannelParameters_mediaPacketization_rtpPayloadType,
        _H2250LogicalChannelParameters_mediaPacketization,
        _H2250LogicalChannelParameters_transportCapability,
        _H2250LogicalChannelParameters_redundancyEncoding,
        _H2250LogicalChannelParameters_source,
        H2250LogicalChannelParameters,
        __RTPPayloadType_payloadDescriptor_nonStandardIdentifier,
        __RTPPayloadType_payloadDescriptor_rfc_number,
        __RTPPayloadType_payloadDescriptor_oid,
        _RTPPayloadType_payloadDescriptor,
        _RTPPayloadType_payloadType,
        RTPPayloadType,
        _RedundancyEncoding_redundancyEncodingMethod,
        _RedundancyEncoding_secondaryEncoding,
        __RedundancyEncoding_rtpRedundancyEncoding_primary,
        ___RedundancyEncoding_rtpRedundancyEncoding_secondary__item_,
        __RedundancyEncoding_rtpRedundancyEncoding_secondary,
        _RedundancyEncoding_rtpRedundancyEncoding,
        RedundancyEncoding,
        _RedundancyEncodingElement_dataType,
        _RedundancyEncodingElement_payloadType,
        RedundancyEncodingElement,
        __MultiplePayloadStream_elements__item_,
        _MultiplePayloadStream_elements,
        MultiplePayloadStream,
        _MultiplePayloadStreamElement_dataType,
        _MultiplePayloadStreamElement_payloadType,
        MultiplePayloadStreamElement,
        ___DepFECData_rfc2733_mode_redundancyEncoding,
        _____DepFECData_rfc2733_mode_separateStream_differentPort_protectedSessionID,
        _____DepFECData_rfc2733_mode_separateStream_differentPort_protectedPayloadType,
        ____DepFECData_rfc2733_mode_separateStream_differentPort,
        _____DepFECData_rfc2733_mode_separateStream_samePort_protectedPayloadType,
        ____DepFECData_rfc2733_mode_separateStream_samePort,
        ___DepFECData_rfc2733_mode_separateStream,
        __DepFECData_rfc2733_mode,
        _DepFECData_rfc2733,
        DepFECData,
        __FECData_rfc2733_protectedPayloadType,
        __FECData_rfc2733_fecScheme,
        ___FECData_rfc2733_pktMode_rfc2198coding,
        ___FECData_rfc2733_pktMode_rfc2733sameport,
        ____FECData_rfc2733_pktMode_rfc2733diffport_protectedChannel,
        ___FECData_rfc2733_pktMode_rfc2733diffport,
        __FECData_rfc2733_pktMode,
        _FECData_rfc2733,
        FECData,
        _TransportAddress_unicastAddress,
        _TransportAddress_multicastAddress,
        TransportAddress,
        __UnicastAddress_iPAddress_network,
        __UnicastAddress_iPAddress_tsapIdentifier,
        _UnicastAddress_iPAddress,
        __UnicastAddress_iPXAddress_node,
        __UnicastAddress_iPXAddress_netnum,
        __UnicastAddress_iPXAddress_tsapIdentifier,
        _UnicastAddress_iPXAddress,
        __UnicastAddress_iP6Address_network,
        __UnicastAddress_iP6Address_tsapIdentifier,
        _UnicastAddress_iP6Address,
        _UnicastAddress_netBios,
        ___UnicastAddress_iPSourceRouteAddress_routing_strict,
        ___UnicastAddress_iPSourceRouteAddress_routing_loose,
        __UnicastAddress_iPSourceRouteAddress_routing,
        __UnicastAddress_iPSourceRouteAddress_network,
        __UnicastAddress_iPSourceRouteAddress_tsapIdentifier,
        ___UnicastAddress_iPSourceRouteAddress_route__item_,
        __UnicastAddress_iPSourceRouteAddress_route,
        _UnicastAddress_iPSourceRouteAddress,
        _UnicastAddress_nsap,
        _UnicastAddress_nonStandardAddress,
        UnicastAddress,
        __MulticastAddress_iPAddress_network,
        __MulticastAddress_iPAddress_tsapIdentifier,
        _MulticastAddress_iPAddress,
        __MulticastAddress_iP6Address_network,
        __MulticastAddress_iP6Address_tsapIdentifier,
        _MulticastAddress_iP6Address,
        _MulticastAddress_nsap,
        _MulticastAddress_nonStandardAddress,
        MulticastAddress,
        _EncryptionSync_nonStandard,
        _EncryptionSync_synchFlag,
        _EncryptionSync_h235Key,
        __EncryptionSync_escrowentry__item_,
        _EncryptionSync_escrowentry,
        _EncryptionSync_genericParameter,
        EncryptionSync,
        _EscrowData_escrowID,
        _EscrowData_escrowValue,
        EscrowData,
        _OpenLogicalChannelAck_forwardLogicalChannelNumber,
        __OpenLogicalChannelAck_reverseLogicalChannelParameters_reverseLogicalChannelNumber,
        __OpenLogicalChannelAck_reverseLogicalChannelParameters_portNumber,
        ___OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters_h222LogicalChannelParameters,
        ___OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters_h2250LogicalChannelParameters,
        __OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters,
        __OpenLogicalChannelAck_reverseLogicalChannelParameters_replacementFor,
        _OpenLogicalChannelAck_reverseLogicalChannelParameters,
        _OpenLogicalChannelAck_separateStack,
        __OpenLogicalChannelAck_forwardMultiplexAckParameters_h2250LogicalChannelAckParameters,
        _OpenLogicalChannelAck_forwardMultiplexAckParameters,
        _OpenLogicalChannelAck_encryptionSync,
        __OpenLogicalChannelAck_genericInformation__item_,
        _OpenLogicalChannelAck_genericInformation,
        OpenLogicalChannelAck,
        _OpenLogicalChannelReject_forwardLogicalChannelNumber,
        __OpenLogicalChannelReject_cause_unspecified,
        __OpenLogicalChannelReject_cause_unsuitableReverseParameters,
        __OpenLogicalChannelReject_cause_dataTypeNotSupported,
        __OpenLogicalChannelReject_cause_dataTypeNotAvailable,
        __OpenLogicalChannelReject_cause_unknownDataType,
        __OpenLogicalChannelReject_cause_dataTypeALCombinationNotSupported,
        __OpenLogicalChannelReject_cause_multicastChannelNotAllowed,
        __OpenLogicalChannelReject_cause_insufficientBandwidth,
        __OpenLogicalChannelReject_cause_separateStackEstablishmentFailed,
        __OpenLogicalChannelReject_cause_invalidSessionID,
        __OpenLogicalChannelReject_cause_masterSlaveConflict,
        __OpenLogicalChannelReject_cause_waitForCommunicationMode,
        __OpenLogicalChannelReject_cause_invalidDependentChannel,
        __OpenLogicalChannelReject_cause_replacementForRejected,
        __OpenLogicalChannelReject_cause_securityDenied,
        __OpenLogicalChannelReject_cause_qoSControlNotSupported,
        _OpenLogicalChannelReject_cause,
        __OpenLogicalChannelReject_genericInformation__item_,
        _OpenLogicalChannelReject_genericInformation,
        OpenLogicalChannelReject,
        _OpenLogicalChannelConfirm_forwardLogicalChannelNumber,
        __OpenLogicalChannelConfirm_genericInformation__item_,
        _OpenLogicalChannelConfirm_genericInformation,
        OpenLogicalChannelConfirm,
        __H2250LogicalChannelAckParameters_nonStandard__item_,
        _H2250LogicalChannelAckParameters_nonStandard,
        _H2250LogicalChannelAckParameters_sessionID,
        _H2250LogicalChannelAckParameters_mediaChannel,
        _H2250LogicalChannelAckParameters_mediaControlChannel,
        _H2250LogicalChannelAckParameters_dynamicRTPPayloadType,
        _H2250LogicalChannelAckParameters_flowControlToZero,
        _H2250LogicalChannelAckParameters_portNumber,
        _H2250LogicalChannelAckParameters_multiplePayloadStream,
        H2250LogicalChannelAckParameters,
        _CloseLogicalChannel_forwardLogicalChannelNumber,
        __CloseLogicalChannel_source_user,
        __CloseLogicalChannel_source_lcse,
        _CloseLogicalChannel_source,
        __CloseLogicalChannel_reason_unknown,
        __CloseLogicalChannel_reason_reopen,
        __CloseLogicalChannel_reason_reservationFailure,
        __CloseLogicalChannel_reason_networkErrorCode,
        _CloseLogicalChannel_reason,
        CloseLogicalChannel,
        _CloseLogicalChannelAck_forwardLogicalChannelNumber,
        CloseLogicalChannelAck,
        _RequestChannelClose_forwardLogicalChannelNumber,
        _RequestChannelClose_qosCapability,
        __RequestChannelClose_reason_unknown,
        __RequestChannelClose_reason_normal,
        __RequestChannelClose_reason_reopen,
        __RequestChannelClose_reason_reservationFailure,
        __RequestChannelClose_reason_networkErrorCode,
        _RequestChannelClose_reason,
        RequestChannelClose,
        _RequestChannelCloseAck_forwardLogicalChannelNumber,
        RequestChannelCloseAck,
        _RequestChannelCloseReject_forwardLogicalChannelNumber,
        __RequestChannelCloseReject_cause_unspecified,
        _RequestChannelCloseReject_cause,
        RequestChannelCloseReject,
        _RequestChannelCloseRelease_forwardLogicalChannelNumber,
        RequestChannelCloseRelease,
        _MultiplexEntrySend_sequenceNumber,
        __MultiplexEntrySend_multiplexEntryDescriptors__item_,
        _MultiplexEntrySend_multiplexEntryDescriptors,
        MultiplexEntrySend,
        _MultiplexEntryDescriptor_multiplexTableEntryNumber,
        __MultiplexEntryDescriptor_elementList__item_,
        _MultiplexEntryDescriptor_elementList,
        MultiplexEntryDescriptor,
        __MultiplexElement_type_logicalChannelNumber,
        ___MultiplexElement_type_subElementList__item_,
        __MultiplexElement_type_subElementList,
        _MultiplexElement_type,
        __MultiplexElement_repeatCount_finite,
        __MultiplexElement_repeatCount_untilClosingFlag,
        _MultiplexElement_repeatCount,
        MultiplexElement,
        MultiplexTableEntryNumber,
        _MultiplexEntrySendAck_sequenceNumber,
        __MultiplexEntrySendAck_multiplexTableEntryNumber__item_,
        _MultiplexEntrySendAck_multiplexTableEntryNumber,
        MultiplexEntrySendAck,
        _MultiplexEntrySendReject_sequenceNumber,
        __MultiplexEntrySendReject_rejectionDescriptions__item_,
        _MultiplexEntrySendReject_rejectionDescriptions,
        MultiplexEntrySendReject,
        _MultiplexEntryRejectionDescriptions_multiplexTableEntryNumber,
        __MultiplexEntryRejectionDescriptions_cause_unspecifiedCause,
        __MultiplexEntryRejectionDescriptions_cause_descriptorTooComplex,
        _MultiplexEntryRejectionDescriptions_cause,
        MultiplexEntryRejectionDescriptions,
        __MultiplexEntrySendRelease_multiplexTableEntryNumber__item_,
        _MultiplexEntrySendRelease_multiplexTableEntryNumber,
        MultiplexEntrySendRelease,
        __RequestMultiplexEntry_entryNumbers__item_,
        _RequestMultiplexEntry_entryNumbers,
        RequestMultiplexEntry,
        __RequestMultiplexEntryAck_entryNumbers__item_,
        _RequestMultiplexEntryAck_entryNumbers,
        RequestMultiplexEntryAck,
        __RequestMultiplexEntryReject_entryNumbers__item_,
        _RequestMultiplexEntryReject_entryNumbers,
        __RequestMultiplexEntryReject_rejectionDescriptions__item_,
        _RequestMultiplexEntryReject_rejectionDescriptions,
        RequestMultiplexEntryReject,
        _RequestMultiplexEntryRejectionDescriptions_multiplexTableEntryNumber,
        __RequestMultiplexEntryRejectionDescriptions_cause_unspecifiedCause,
        _RequestMultiplexEntryRejectionDescriptions_cause,
        RequestMultiplexEntryRejectionDescriptions,
        __RequestMultiplexEntryRelease_entryNumbers__item_,
        _RequestMultiplexEntryRelease_entryNumbers,
        RequestMultiplexEntryRelease,
        _RequestMode_sequenceNumber,
        __RequestMode_requestedModes__item_,
        _RequestMode_requestedModes,
        RequestMode,
        _RequestModeAck_sequenceNumber,
        __RequestModeAck_response_willTransmitMostPreferredMode,
        __RequestModeAck_response_willTransmitLessPreferredMode,
        _RequestModeAck_response,
        RequestModeAck,
        _RequestModeReject_sequenceNumber,
        __RequestModeReject_cause_modeUnavailable,
        __RequestModeReject_cause_multipointConstraint,
        __RequestModeReject_cause_requestDenied,
        _RequestModeReject_cause,
        RequestModeReject,
        RequestModeRelease,
        _ModeDescription__item_,
        ModeDescription,
        _ModeElementType_nonStandard,
        _ModeElementType_videoMode,
        _ModeElementType_audioMode,
        _ModeElementType_dataMode,
        _ModeElementType_encryptionMode,
        _ModeElementType_h235Mode,
        _ModeElementType_multiplexedStreamMode,
        _ModeElementType_redundancyEncodingDTMode,
        _ModeElementType_multiplePayloadStreamMode,
        _ModeElementType_depFecMode,
        _ModeElementType_fecMode,
        ModeElementType,
        _ModeElement_type,
        _ModeElement_h223ModeParameters,
        _ModeElement_v76ModeParameters,
        _ModeElement_h2250ModeParameters,
        _ModeElement_genericModeParameters,
        _ModeElement_multiplexedStreamModeParameters,
        _ModeElement_logicalChannelNumber,
        ModeElement,
        _H235Mode_encryptionAuthenticationAndIntegrity,
        __H235Mode_mediaMode_nonStandard,
        __H235Mode_mediaMode_videoMode,
        __H235Mode_mediaMode_audioMode,
        __H235Mode_mediaMode_dataMode,
        _H235Mode_mediaMode,
        H235Mode,
        _MultiplexedStreamModeParameters_logicalChannelNumber,
        MultiplexedStreamModeParameters,
        _RedundancyEncodingDTMode_redundancyEncodingMethod,
        _RedundancyEncodingDTMode_primary,
        __RedundancyEncodingDTMode_secondary__item_,
        _RedundancyEncodingDTMode_secondary,
        RedundancyEncodingDTMode,
        __RedundancyEncodingDTModeElement_type_nonStandard,
        __RedundancyEncodingDTModeElement_type_videoMode,
        __RedundancyEncodingDTModeElement_type_audioMode,
        __RedundancyEncodingDTModeElement_type_dataMode,
        __RedundancyEncodingDTModeElement_type_encryptionMode,
        __RedundancyEncodingDTModeElement_type_h235Mode,
        __RedundancyEncodingDTModeElement_type_fecMode,
        _RedundancyEncodingDTModeElement_type,
        RedundancyEncodingDTModeElement,
        __MultiplePayloadStreamMode_elements__item_,
        _MultiplePayloadStreamMode_elements,
        MultiplePayloadStreamMode,
        _MultiplePayloadStreamElementMode_type,
        MultiplePayloadStreamElementMode,
        ___DepFECMode_rfc2733Mode_mode_redundancyEncoding,
        _____DepFECMode_rfc2733Mode_mode_separateStream_differentPort_protectedSessionID,
        _____DepFECMode_rfc2733Mode_mode_separateStream_differentPort_protectedPayloadType,
        ____DepFECMode_rfc2733Mode_mode_separateStream_differentPort,
        _____DepFECMode_rfc2733Mode_mode_separateStream_samePort_protectedType,
        ____DepFECMode_rfc2733Mode_mode_separateStream_samePort,
        ___DepFECMode_rfc2733Mode_mode_separateStream,
        __DepFECMode_rfc2733Mode_mode,
        _DepFECMode_rfc2733Mode,
        DepFECMode,
        _FECMode_protectedElement,
        _FECMode_fecScheme,
        __FECMode_rfc2733Format_rfc2733rfc2198,
        __FECMode_rfc2733Format_rfc2733sameport,
        __FECMode_rfc2733Format_rfc2733diffport,
        _FECMode_rfc2733Format,
        FECMode,
        __H223ModeParameters_adaptationLayerType_nonStandard,
        __H223ModeParameters_adaptationLayerType_al1Framed,
        __H223ModeParameters_adaptationLayerType_al1NotFramed,
        __H223ModeParameters_adaptationLayerType_al2WithoutSequenceNumbers,
        __H223ModeParameters_adaptationLayerType_al2WithSequenceNumbers,
        ___H223ModeParameters_adaptationLayerType_al3_controlFieldOctets,
        ___H223ModeParameters_adaptationLayerType_al3_sendBufferSize,
        __H223ModeParameters_adaptationLayerType_al3,
        __H223ModeParameters_adaptationLayerType_al1M,
        __H223ModeParameters_adaptationLayerType_al2M,
        __H223ModeParameters_adaptationLayerType_al3M,
        _H223ModeParameters_adaptationLayerType,
        _H223ModeParameters_segmentableFlag,
        H223ModeParameters,
        _V76ModeParameters_suspendResumewAddress,
        _V76ModeParameters_suspendResumewoAddress,
        V76ModeParameters,
        _H2250ModeParameters_redundancyEncodingMode,
        H2250ModeParameters,
        _RedundancyEncodingMode_redundancyEncodingMethod,
        __RedundancyEncodingMode_secondaryEncoding_nonStandard,
        __RedundancyEncodingMode_secondaryEncoding_audioData,
        _RedundancyEncodingMode_secondaryEncoding,
        RedundancyEncodingMode,
        _VideoMode_nonStandard,
        _VideoMode_h261VideoMode,
        _VideoMode_h262VideoMode,
        _VideoMode_h263VideoMode,
        _VideoMode_is11172VideoMode,
        _VideoMode_genericVideoMode,
        VideoMode,
        __H261VideoMode_resolution_qcif,
        __H261VideoMode_resolution_cif,
        _H261VideoMode_resolution,
        _H261VideoMode_bitRate,
        _H261VideoMode_stillImageTransmission,
        H261VideoMode,
        __H262VideoMode_profileAndLevel_profileAndLevel_SPatML,
        __H262VideoMode_profileAndLevel_profileAndLevel_MPatLL,
        __H262VideoMode_profileAndLevel_profileAndLevel_MPatML,
        __H262VideoMode_profileAndLevel_profileAndLevel_MPatH_14,
        __H262VideoMode_profileAndLevel_profileAndLevel_MPatHL,
        __H262VideoMode_profileAndLevel_profileAndLevel_SNRatLL,
        __H262VideoMode_profileAndLevel_profileAndLevel_SNRatML,
        __H262VideoMode_profileAndLevel_profileAndLevel_SpatialatH_14,
        __H262VideoMode_profileAndLevel_profileAndLevel_HPatML,
        __H262VideoMode_profileAndLevel_profileAndLevel_HPatH_14,
        __H262VideoMode_profileAndLevel_profileAndLevel_HPatHL,
        _H262VideoMode_profileAndLevel,
        _H262VideoMode_videoBitRate,
        _H262VideoMode_vbvBufferSize,
        _H262VideoMode_samplesPerLine,
        _H262VideoMode_linesPerFrame,
        _H262VideoMode_framesPerSecond,
        _H262VideoMode_luminanceSampleRate,
        H262VideoMode,
        __H263VideoMode_resolution_sqcif,
        __H263VideoMode_resolution_qcif,
        __H263VideoMode_resolution_cif,
        __H263VideoMode_resolution_cif4,
        __H263VideoMode_resolution_cif16,
        __H263VideoMode_resolution_custom,
        _H263VideoMode_resolution,
        _H263VideoMode_bitRate,
        _H263VideoMode_unrestrictedVector,
        _H263VideoMode_arithmeticCoding,
        _H263VideoMode_advancedPrediction,
        _H263VideoMode_pbFrames,
        _H263VideoMode_errorCompensation,
        _H263VideoMode_enhancementLayerInfo,
        _H263VideoMode_h263Options,
        H263VideoMode,
        _IS11172VideoMode_constrainedBitstream,
        _IS11172VideoMode_videoBitRate,
        _IS11172VideoMode_vbvBufferSize,
        _IS11172VideoMode_samplesPerLine,
        _IS11172VideoMode_linesPerFrame,
        _IS11172VideoMode_pictureRate,
        _IS11172VideoMode_luminanceSampleRate,
        IS11172VideoMode,
        _AudioMode_nonStandard,
        _AudioMode_g711Alaw64k,
        _AudioMode_g711Alaw56k,
        _AudioMode_g711Ulaw64k,
        _AudioMode_g711Ulaw56k,
        _AudioMode_g722_64k,
        _AudioMode_g722_56k,
        _AudioMode_g722_48k,
        _AudioMode_g728,
        _AudioMode_g729,
        _AudioMode_g729AnnexA,
        __AudioMode_g7231_noSilenceSuppressionLowRate,
        __AudioMode_g7231_noSilenceSuppressionHighRate,
        __AudioMode_g7231_silenceSuppressionLowRate,
        __AudioMode_g7231_silenceSuppressionHighRate,
        _AudioMode_g7231,
        _AudioMode_is11172AudioMode,
        _AudioMode_is13818AudioMode,
        _AudioMode_g729wAnnexB,
        _AudioMode_g729AnnexAwAnnexB,
        _AudioMode_g7231AnnexCMode,
        _AudioMode_gsmFullRate,
        _AudioMode_gsmHalfRate,
        _AudioMode_gsmEnhancedFullRate,
        _AudioMode_genericAudioMode,
        _AudioMode_g729Extensions,
        _AudioMode_vbd,
        AudioMode,
        __IS11172AudioMode_audioLayer_audioLayer1,
        __IS11172AudioMode_audioLayer_audioLayer2,
        __IS11172AudioMode_audioLayer_audioLayer3,
        _IS11172AudioMode_audioLayer,
        __IS11172AudioMode_audioSampling_audioSampling32k,
        __IS11172AudioMode_audioSampling_audioSampling44k1,
        __IS11172AudioMode_audioSampling_audioSampling48k,
        _IS11172AudioMode_audioSampling,
        __IS11172AudioMode_multichannelType_singleChannel,
        __IS11172AudioMode_multichannelType_twoChannelStereo,
        __IS11172AudioMode_multichannelType_twoChannelDual,
        _IS11172AudioMode_multichannelType,
        _IS11172AudioMode_bitRate,
        IS11172AudioMode,
        __IS13818AudioMode_audioLayer_audioLayer1,
        __IS13818AudioMode_audioLayer_audioLayer2,
        __IS13818AudioMode_audioLayer_audioLayer3,
        _IS13818AudioMode_audioLayer,
        __IS13818AudioMode_audioSampling_audioSampling16k,
        __IS13818AudioMode_audioSampling_audioSampling22k05,
        __IS13818AudioMode_audioSampling_audioSampling24k,
        __IS13818AudioMode_audioSampling_audioSampling32k,
        __IS13818AudioMode_audioSampling_audioSampling44k1,
        __IS13818AudioMode_audioSampling_audioSampling48k,
        _IS13818AudioMode_audioSampling,
        __IS13818AudioMode_multichannelType_singleChannel,
        __IS13818AudioMode_multichannelType_twoChannelStereo,
        __IS13818AudioMode_multichannelType_twoChannelDual,
        __IS13818AudioMode_multichannelType_threeChannels2_1,
        __IS13818AudioMode_multichannelType_threeChannels3_0,
        __IS13818AudioMode_multichannelType_fourChannels2_0_2_0,
        __IS13818AudioMode_multichannelType_fourChannels2_2,
        __IS13818AudioMode_multichannelType_fourChannels3_1,
        __IS13818AudioMode_multichannelType_fiveChannels3_0_2_0,
        __IS13818AudioMode_multichannelType_fiveChannels3_2,
        _IS13818AudioMode_multichannelType,
        _IS13818AudioMode_lowFrequencyEnhancement,
        _IS13818AudioMode_multilingual,
        _IS13818AudioMode_bitRate,
        IS13818AudioMode,
        _G7231AnnexCMode_maxAl_sduAudioFrames,
        _G7231AnnexCMode_silenceSuppression,
        __G7231AnnexCMode_g723AnnexCAudioMode_highRateMode0,
        __G7231AnnexCMode_g723AnnexCAudioMode_highRateMode1,
        __G7231AnnexCMode_g723AnnexCAudioMode_lowRateMode0,
        __G7231AnnexCMode_g723AnnexCAudioMode_lowRateMode1,
        __G7231AnnexCMode_g723AnnexCAudioMode_sidMode0,
        __G7231AnnexCMode_g723AnnexCAudioMode_sidMode1,
        _G7231AnnexCMode_g723AnnexCAudioMode,
        G7231AnnexCMode,
        _VBDMode_type,
        VBDMode,
        __DataMode_application_nonStandard,
        __DataMode_application_t120,
        __DataMode_application_dsm_cc,
        __DataMode_application_userData,
        __DataMode_application_t84,
        __DataMode_application_t434,
        __DataMode_application_h224,
        ___DataMode_application_nlpid_nlpidProtocol,
        ___DataMode_application_nlpid_nlpidData,
        __DataMode_application_nlpid,
        __DataMode_application_dsvdControl,
        __DataMode_application_h222DataPartitioning,
        __DataMode_application_t30fax,
        __DataMode_application_t140,
        ___DataMode_application_t38fax_t38FaxProtocol,
        ___DataMode_application_t38fax_t38FaxProfile,
        __DataMode_application_t38fax,
        __DataMode_application_genericDataMode,
        _DataMode_application,
        _DataMode_bitRate,
        DataMode,
        _EncryptionMode_nonStandard,
        _EncryptionMode_h233Encryption,
        EncryptionMode,
        _RoundTripDelayRequest_sequenceNumber,
        RoundTripDelayRequest,
        _RoundTripDelayResponse_sequenceNumber,
        RoundTripDelayResponse,
        __MaintenanceLoopRequest_type_systemLoop,
        __MaintenanceLoopRequest_type_mediaLoop,
        __MaintenanceLoopRequest_type_logicalChannelLoop,
        _MaintenanceLoopRequest_type,
        MaintenanceLoopRequest,
        __MaintenanceLoopAck_type_systemLoop,
        __MaintenanceLoopAck_type_mediaLoop,
        __MaintenanceLoopAck_type_logicalChannelLoop,
        _MaintenanceLoopAck_type,
        MaintenanceLoopAck,
        __MaintenanceLoopReject_type_systemLoop,
        __MaintenanceLoopReject_type_mediaLoop,
        __MaintenanceLoopReject_type_logicalChannelLoop,
        _MaintenanceLoopReject_type,
        __MaintenanceLoopReject_cause_canNotPerformLoop,
        _MaintenanceLoopReject_cause,
        MaintenanceLoopReject,
        MaintenanceLoopOffCommand,
        __CommunicationModeCommand_communicationModeTable__item_,
        _CommunicationModeCommand_communicationModeTable,
        CommunicationModeCommand,
        CommunicationModeRequest,
        __CommunicationModeResponse_communicationModeTable__item_,
        _CommunicationModeResponse_communicationModeTable,
        CommunicationModeResponse,
        __CommunicationModeTableEntry_nonStandard__item_,
        _CommunicationModeTableEntry_nonStandard,
        _CommunicationModeTableEntry_sessionID,
        _CommunicationModeTableEntry_associatedSessionID,
        _CommunicationModeTableEntry_terminalLabel,
        _CommunicationModeTableEntry_sessionDescription,
        __CommunicationModeTableEntry_dataType_videoData,
        __CommunicationModeTableEntry_dataType_audioData,
        __CommunicationModeTableEntry_dataType_data,
        _CommunicationModeTableEntry_dataType,
        _CommunicationModeTableEntry_mediaChannel,
        _CommunicationModeTableEntry_mediaGuaranteedDelivery,
        _CommunicationModeTableEntry_mediaControlChannel,
        _CommunicationModeTableEntry_mediaControlGuaranteedDelivery,
        _CommunicationModeTableEntry_redundancyEncoding,
        _CommunicationModeTableEntry_sessionDependency,
        _CommunicationModeTableEntry_destination,
        CommunicationModeTableEntry,
        _ConferenceRequest_terminalListRequest,
        _ConferenceRequest_makeMeChair,
        _ConferenceRequest_cancelMakeMeChair,
        _ConferenceRequest_dropTerminal,
        _ConferenceRequest_requestTerminalID,
        _ConferenceRequest_enterH243Password,
        _ConferenceRequest_enterH243TerminalID,
        _ConferenceRequest_enterH243ConferenceID,
        _ConferenceRequest_enterExtensionAddress,
        _ConferenceRequest_requestChairTokenOwner,
        __ConferenceRequest_requestTerminalCertificate_terminalLabel,
        __ConferenceRequest_requestTerminalCertificate_certSelectionCriteria,
        __ConferenceRequest_requestTerminalCertificate_sRandom,
        _ConferenceRequest_requestTerminalCertificate,
        _ConferenceRequest_broadcastMyLogicalChannel,
        _ConferenceRequest_makeTerminalBroadcaster,
        _ConferenceRequest_sendThisSource,
        _ConferenceRequest_requestAllTerminalIDs,
        _ConferenceRequest_remoteMCRequest,
        ConferenceRequest,
        _CertSelectionCriteria__item_,
        CertSelectionCriteria,
        _Criteria_field,
        _Criteria_value,
        Criteria,
        _TerminalLabel_mcuNumber,
        _TerminalLabel_terminalNumber,
        TerminalLabel,
        McuNumber,
        TerminalNumber,
        __ConferenceResponse_mCTerminalIDResponse_terminalLabel,
        __ConferenceResponse_mCTerminalIDResponse_terminalID,
        _ConferenceResponse_mCTerminalIDResponse,
        __ConferenceResponse_terminalIDResponse_terminalLabel,
        __ConferenceResponse_terminalIDResponse_terminalID,
        _ConferenceResponse_terminalIDResponse,
        __ConferenceResponse_conferenceIDResponse_terminalLabel,
        __ConferenceResponse_conferenceIDResponse_conferenceID,
        _ConferenceResponse_conferenceIDResponse,
        __ConferenceResponse_passwordResponse_terminalLabel,
        __ConferenceResponse_passwordResponse_password,
        _ConferenceResponse_passwordResponse,
        __ConferenceResponse_terminalListResponse__item_,
        _ConferenceResponse_terminalListResponse,
        _ConferenceResponse_videoCommandReject,
        _ConferenceResponse_terminalDropReject,
        __ConferenceResponse_makeMeChairResponse_grantedChairToken,
        __ConferenceResponse_makeMeChairResponse_deniedChairToken,
        _ConferenceResponse_makeMeChairResponse,
        __ConferenceResponse_extensionAddressResponse_extensionAddress,
        _ConferenceResponse_extensionAddressResponse,
        __ConferenceResponse_chairTokenOwnerResponse_terminalLabel,
        __ConferenceResponse_chairTokenOwnerResponse_terminalID,
        _ConferenceResponse_chairTokenOwnerResponse,
        __ConferenceResponse_terminalCertificateResponse_terminalLabel,
        __ConferenceResponse_terminalCertificateResponse_certificateResponse,
        _ConferenceResponse_terminalCertificateResponse,
        __ConferenceResponse_broadcastMyLogicalChannelResponse_grantedBroadcastMyLogicalChannel,
        __ConferenceResponse_broadcastMyLogicalChannelResponse_deniedBroadcastMyLogicalChannel,
        _ConferenceResponse_broadcastMyLogicalChannelResponse,
        __ConferenceResponse_makeTerminalBroadcasterResponse_grantedMakeTerminalBroadcaster,
        __ConferenceResponse_makeTerminalBroadcasterResponse_deniedMakeTerminalBroadcaster,
        _ConferenceResponse_makeTerminalBroadcasterResponse,
        __ConferenceResponse_sendThisSourceResponse_grantedSendThisSource,
        __ConferenceResponse_sendThisSourceResponse_deniedSendThisSource,
        _ConferenceResponse_sendThisSourceResponse,
        _ConferenceResponse_requestAllTerminalIDsResponse,
        _ConferenceResponse_remoteMCResponse,
        ConferenceResponse,
        TerminalID,
        ConferenceID,
        Password,
        __RequestAllTerminalIDsResponse_terminalInformation__item_,
        _RequestAllTerminalIDsResponse_terminalInformation,
        RequestAllTerminalIDsResponse,
        _TerminalInformation_terminalLabel,
        _TerminalInformation_terminalID,
        TerminalInformation,
        _RemoteMCRequest_masterActivate,
        _RemoteMCRequest_slaveActivate,
        _RemoteMCRequest_deActivate,
        RemoteMCRequest,
        _RemoteMCResponse_accept,
        __RemoteMCResponse_reject_unspecified,
        __RemoteMCResponse_reject_functionNotSupported,
        _RemoteMCResponse_reject,
        RemoteMCResponse,
        _MultilinkRequest_nonStandard,
        __MultilinkRequest_callInformation_maxNumberOfAdditionalConnections,
        _MultilinkRequest_callInformation,
        __MultilinkRequest_addConnection_sequenceNumber,
        __MultilinkRequest_addConnection_dialingInformation,
        _MultilinkRequest_addConnection,
        __MultilinkRequest_removeConnection_connectionIdentifier,
        _MultilinkRequest_removeConnection,
        ___MultilinkRequest_maximumHeaderInterval_requestType_currentIntervalInformation,
        ___MultilinkRequest_maximumHeaderInterval_requestType_requestedInterval,
        __MultilinkRequest_maximumHeaderInterval_requestType,
        _MultilinkRequest_maximumHeaderInterval,
        MultilinkRequest,
        _MultilinkResponse_nonStandard,
        __MultilinkResponse_callInformation_dialingInformation,
        __MultilinkResponse_callInformation_callAssociationNumber,
        _MultilinkResponse_callInformation,
        __MultilinkResponse_addConnection_sequenceNumber,
        ___MultilinkResponse_addConnection_responseCode_accepted,
        ____MultilinkResponse_addConnection_responseCode_rejected_connectionsNotAvailable,
        ____MultilinkResponse_addConnection_responseCode_rejected_userRejected,
        ___MultilinkResponse_addConnection_responseCode_rejected,
        __MultilinkResponse_addConnection_responseCode,
        _MultilinkResponse_addConnection,
        __MultilinkResponse_removeConnection_connectionIdentifier,
        _MultilinkResponse_removeConnection,
        __MultilinkResponse_maximumHeaderInterval_currentInterval,
        _MultilinkResponse_maximumHeaderInterval,
        MultilinkResponse,
        _MultilinkIndication_nonStandard,
        _MultilinkIndication_crcDesired,
        __MultilinkIndication_excessiveError_connectionIdentifier,
        _MultilinkIndication_excessiveError,
        MultilinkIndication,
        _DialingInformation_nonStandard,
        __DialingInformation_differential__item_,
        _DialingInformation_differential,
        _DialingInformation_infoNotAvailable,
        DialingInformation,
        _DialingInformationNumber_networkAddress,
        _DialingInformationNumber_subAddress,
        __DialingInformationNumber_networkType__item_,
        _DialingInformationNumber_networkType,
        DialingInformationNumber,
        _DialingInformationNetworkType_nonStandard,
        _DialingInformationNetworkType_n_isdn,
        _DialingInformationNetworkType_gstn,
        _DialingInformationNetworkType_mobile,
        DialingInformationNetworkType,
        _ConnectionIdentifier_channelTag,
        _ConnectionIdentifier_sequenceNumber,
        ConnectionIdentifier,
        MaximumBitRate,
        _LogicalChannelRateRequest_sequenceNumber,
        _LogicalChannelRateRequest_logicalChannelNumber,
        _LogicalChannelRateRequest_maximumBitRate,
        LogicalChannelRateRequest,
        _LogicalChannelRateAcknowledge_sequenceNumber,
        _LogicalChannelRateAcknowledge_logicalChannelNumber,
        _LogicalChannelRateAcknowledge_maximumBitRate,
        LogicalChannelRateAcknowledge,
        _LogicalChannelRateReject_sequenceNumber,
        _LogicalChannelRateReject_logicalChannelNumber,
        _LogicalChannelRateReject_rejectReason,
        _LogicalChannelRateReject_currentMaximumBitRate,
        LogicalChannelRateReject,
        _LogicalChannelRateRejectReason_undefinedReason,
        _LogicalChannelRateRejectReason_insufficientResources,
        LogicalChannelRateRejectReason,
        LogicalChannelRateRelease,
        __SendTerminalCapabilitySet_specificRequest_multiplexCapability,
        ___SendTerminalCapabilitySet_specificRequest_capabilityTableEntryNumbers__item_,
        __SendTerminalCapabilitySet_specificRequest_capabilityTableEntryNumbers,
        ___SendTerminalCapabilitySet_specificRequest_capabilityDescriptorNumbers__item_,
        __SendTerminalCapabilitySet_specificRequest_capabilityDescriptorNumbers,
        _SendTerminalCapabilitySet_specificRequest,
        _SendTerminalCapabilitySet_genericRequest,
        SendTerminalCapabilitySet,
        _EncryptionCommand_encryptionSE,
        _EncryptionCommand_encryptionIVRequest,
        __EncryptionCommand_encryptionAlgorithmID_h233AlgorithmIdentifier,
        __EncryptionCommand_encryptionAlgorithmID_associatedAlgorithm,
        _EncryptionCommand_encryptionAlgorithmID,
        EncryptionCommand,
        __FlowControlCommand_scope_logicalChannelNumber,
        __FlowControlCommand_scope_resourceID,
        __FlowControlCommand_scope_wholeMultiplex,
        _FlowControlCommand_scope,
        __FlowControlCommand_restriction_maximumBitRate,
        __FlowControlCommand_restriction_noRestriction,
        _FlowControlCommand_restriction,
        FlowControlCommand,
        _EndSessionCommand_nonStandard,
        _EndSessionCommand_disconnect,
        __EndSessionCommand_gstnOptions_telephonyMode,
        __EndSessionCommand_gstnOptions_v8bis,
        __EndSessionCommand_gstnOptions_v34DSVD,
        __EndSessionCommand_gstnOptions_v34DuplexFAX,
        __EndSessionCommand_gstnOptions_v34H324,
        _EndSessionCommand_gstnOptions,
        __EndSessionCommand_isdnOptions_telephonyMode,
        __EndSessionCommand_isdnOptions_v140,
        __EndSessionCommand_isdnOptions_terminalOnHold,
        _EndSessionCommand_isdnOptions,
        __EndSessionCommand_genericInformation__item_,
        _EndSessionCommand_genericInformation,
        EndSessionCommand,
        _ConferenceCommand_broadcastMyLogicalChannel,
        _ConferenceCommand_cancelBroadcastMyLogicalChannel,
        _ConferenceCommand_makeTerminalBroadcaster,
        _ConferenceCommand_cancelMakeTerminalBroadcaster,
        _ConferenceCommand_sendThisSource,
        _ConferenceCommand_cancelSendThisSource,
        _ConferenceCommand_dropConference,
        _ConferenceCommand_substituteConferenceIDCommand,
        ConferenceCommand,
        _SubstituteConferenceIDCommand_conferenceIdentifier,
        SubstituteConferenceIDCommand,
        _EncryptionUpdateDirection_masterToSlave,
        _EncryptionUpdateDirection_slaveToMaster,
        EncryptionUpdateDirection,
        _MiscellaneousCommand_logicalChannelNumber,
        __MiscellaneousCommand_type_equaliseDelay,
        __MiscellaneousCommand_type_zeroDelay,
        __MiscellaneousCommand_type_multipointModeCommand,
        __MiscellaneousCommand_type_cancelMultipointModeCommand,
        __MiscellaneousCommand_type_videoFreezePicture,
        __MiscellaneousCommand_type_videoFastUpdatePicture,
        ___MiscellaneousCommand_type_videoFastUpdateGOB_firstGOB,
        ___MiscellaneousCommand_type_videoFastUpdateGOB_numberOfGOBs,
        __MiscellaneousCommand_type_videoFastUpdateGOB,
        __MiscellaneousCommand_type_videoTemporalSpatialTradeOff,
        __MiscellaneousCommand_type_videoSendSyncEveryGOB,
        __MiscellaneousCommand_type_videoSendSyncEveryGOBCancel,
        ___MiscellaneousCommand_type_videoFastUpdateMB_firstGOB,
        ___MiscellaneousCommand_type_videoFastUpdateMB_firstMB,
        ___MiscellaneousCommand_type_videoFastUpdateMB_numberOfMBs,
        __MiscellaneousCommand_type_videoFastUpdateMB,
        __MiscellaneousCommand_type_maxH223MUXPDUsize,
        __MiscellaneousCommand_type_encryptionUpdate,
        __MiscellaneousCommand_type_encryptionUpdateRequest,
        __MiscellaneousCommand_type_switchReceiveMediaOff,
        __MiscellaneousCommand_type_switchReceiveMediaOn,
        ____MiscellaneousCommand_type_progressiveRefinementStart_repeatCount_doOneProgression,
        ____MiscellaneousCommand_type_progressiveRefinementStart_repeatCount_doContinuousProgressions,
        ____MiscellaneousCommand_type_progressiveRefinementStart_repeatCount_doOneIndependentProgression,
        ____MiscellaneousCommand_type_progressiveRefinementStart_repeatCount_doContinuousIndependentProgressions,
        ___MiscellaneousCommand_type_progressiveRefinementStart_repeatCount,
        __MiscellaneousCommand_type_progressiveRefinementStart,
        __MiscellaneousCommand_type_progressiveRefinementAbortOne,
        __MiscellaneousCommand_type_progressiveRefinementAbortContinuous,
        ___MiscellaneousCommand_type_videoBadMBs_firstMB,
        ___MiscellaneousCommand_type_videoBadMBs_numberOfMBs,
        ___MiscellaneousCommand_type_videoBadMBs_temporalReference,
        __MiscellaneousCommand_type_videoBadMBs,
        ___MiscellaneousCommand_type_lostPicture__item_,
        __MiscellaneousCommand_type_lostPicture,
        ___MiscellaneousCommand_type_lostPartialPicture_pictureReference,
        ___MiscellaneousCommand_type_lostPartialPicture_firstMB,
        ___MiscellaneousCommand_type_lostPartialPicture_numberOfMBs,
        __MiscellaneousCommand_type_lostPartialPicture,
        ___MiscellaneousCommand_type_recoveryReferencePicture__item_,
        __MiscellaneousCommand_type_recoveryReferencePicture,
        ___MiscellaneousCommand_type_encryptionUpdateCommand_encryptionSync,
        ___MiscellaneousCommand_type_encryptionUpdateCommand_multiplePayloadStream,
        __MiscellaneousCommand_type_encryptionUpdateCommand,
        ___MiscellaneousCommand_type_encryptionUpdateAck_synchFlag,
        __MiscellaneousCommand_type_encryptionUpdateAck,
        _MiscellaneousCommand_type,
        _MiscellaneousCommand_direction,
        MiscellaneousCommand,
        _KeyProtectionMethod_secureChannel,
        _KeyProtectionMethod_sharedSecret,
        _KeyProtectionMethod_certProtectedKey,
        KeyProtectionMethod,
        _EncryptionUpdateRequest_keyProtectionMethod,
        _EncryptionUpdateRequest_synchFlag,
        EncryptionUpdateRequest,
        _PictureReference_pictureNumber,
        _PictureReference_longTermPictureIndex,
        PictureReference,
        __H223MultiplexReconfiguration_h223ModeChange_toLevel0,
        __H223MultiplexReconfiguration_h223ModeChange_toLevel1,
        __H223MultiplexReconfiguration_h223ModeChange_toLevel2,
        __H223MultiplexReconfiguration_h223ModeChange_toLevel2withOptionalHeader,
        _H223MultiplexReconfiguration_h223ModeChange,
        __H223MultiplexReconfiguration_h223AnnexADoubleFlag_start,
        __H223MultiplexReconfiguration_h223AnnexADoubleFlag_stop,
        _H223MultiplexReconfiguration_h223AnnexADoubleFlag,
        H223MultiplexReconfiguration,
        _NewATMVCCommand_resourceID,
        _NewATMVCCommand_bitRate,
        _NewATMVCCommand_bitRateLockedToPCRClock,
        _NewATMVCCommand_bitRateLockedToNetworkClock,
        ____NewATMVCCommand_aal_aal1_clockRecovery_nullClockRecovery,
        ____NewATMVCCommand_aal_aal1_clockRecovery_srtsClockRecovery,
        ____NewATMVCCommand_aal_aal1_clockRecovery_adaptiveClockRecovery,
        ___NewATMVCCommand_aal_aal1_clockRecovery,
        ____NewATMVCCommand_aal_aal1_errorCorrection_nullErrorCorrection,
        ____NewATMVCCommand_aal_aal1_errorCorrection_longInterleaver,
        ____NewATMVCCommand_aal_aal1_errorCorrection_shortInterleaver,
        ____NewATMVCCommand_aal_aal1_errorCorrection_errorCorrectionOnly,
        ___NewATMVCCommand_aal_aal1_errorCorrection,
        ___NewATMVCCommand_aal_aal1_structuredDataTransfer,
        ___NewATMVCCommand_aal_aal1_partiallyFilledCells,
        __NewATMVCCommand_aal_aal1,
        ___NewATMVCCommand_aal_aal5_forwardMaximumSDUSize,
        ___NewATMVCCommand_aal_aal5_backwardMaximumSDUSize,
        __NewATMVCCommand_aal_aal5,
        _NewATMVCCommand_aal,
        __NewATMVCCommand_multiplex_noMultiplex,
        __NewATMVCCommand_multiplex_transportStream,
        __NewATMVCCommand_multiplex_programStream,
        _NewATMVCCommand_multiplex,
        __NewATMVCCommand_reverseParameters_bitRate,
        __NewATMVCCommand_reverseParameters_bitRateLockedToPCRClock,
        __NewATMVCCommand_reverseParameters_bitRateLockedToNetworkClock,
        ___NewATMVCCommand_reverseParameters_multiplex_noMultiplex,
        ___NewATMVCCommand_reverseParameters_multiplex_transportStream,
        ___NewATMVCCommand_reverseParameters_multiplex_programStream,
        __NewATMVCCommand_reverseParameters_multiplex,
        _NewATMVCCommand_reverseParameters,
        NewATMVCCommand,
        _MobileMultilinkReconfigurationCommand_sampleSize,
        _MobileMultilinkReconfigurationCommand_samplesPerFrame,
        __MobileMultilinkReconfigurationCommand_status_synchronized,
        __MobileMultilinkReconfigurationCommand_status_reconfiguration,
        _MobileMultilinkReconfigurationCommand_status,
        MobileMultilinkReconfigurationCommand,
        _FunctionNotUnderstood_request,
        _FunctionNotUnderstood_response,
        _FunctionNotUnderstood_command,
        FunctionNotUnderstood,
        __FunctionNotSupported_cause_syntaxError,
        __FunctionNotSupported_cause_semanticError,
        __FunctionNotSupported_cause_unknownFunction,
        _FunctionNotSupported_cause,
        _FunctionNotSupported_returnedFunction,
        FunctionNotSupported,
        _ConferenceIndication_sbeNumber,
        _ConferenceIndication_terminalNumberAssign,
        _ConferenceIndication_terminalJoinedConference,
        _ConferenceIndication_terminalLeftConference,
        _ConferenceIndication_seenByAtLeastOneOther,
        _ConferenceIndication_cancelSeenByAtLeastOneOther,
        _ConferenceIndication_seenByAll,
        _ConferenceIndication_cancelSeenByAll,
        _ConferenceIndication_terminalYouAreSeeing,
        _ConferenceIndication_requestForFloor,
        _ConferenceIndication_withdrawChairToken,
        _ConferenceIndication_floorRequested,
        _ConferenceIndication_terminalYouAreSeeingInSubPictureNumber,
        _ConferenceIndication_videoIndicateCompose,
        _ConferenceIndication_masterMCU,
        _ConferenceIndication_cancelMasterMCU,
        ConferenceIndication,
        _TerminalYouAreSeeingInSubPictureNumber_terminalNumber,
        _TerminalYouAreSeeingInSubPictureNumber_subPictureNumber,
        _TerminalYouAreSeeingInSubPictureNumber_mcuNumber,
        TerminalYouAreSeeingInSubPictureNumber,
        _VideoIndicateCompose_compositionNumber,
        VideoIndicateCompose,
        _MiscellaneousIndication_logicalChannelNumber,
        __MiscellaneousIndication_type_logicalChannelActive,
        __MiscellaneousIndication_type_logicalChannelInactive,
        __MiscellaneousIndication_type_multipointConference,
        __MiscellaneousIndication_type_cancelMultipointConference,
        __MiscellaneousIndication_type_multipointZeroComm,
        __MiscellaneousIndication_type_cancelMultipointZeroComm,
        __MiscellaneousIndication_type_multipointSecondaryStatus,
        __MiscellaneousIndication_type_cancelMultipointSecondaryStatus,
        __MiscellaneousIndication_type_videoIndicateReadyToActivate,
        __MiscellaneousIndication_type_videoTemporalSpatialTradeOff,
        ___MiscellaneousIndication_type_videoNotDecodedMBs_firstMB,
        ___MiscellaneousIndication_type_videoNotDecodedMBs_numberOfMBs,
        ___MiscellaneousIndication_type_videoNotDecodedMBs_temporalReference,
        __MiscellaneousIndication_type_videoNotDecodedMBs,
        __MiscellaneousIndication_type_transportCapability,
        _MiscellaneousIndication_type,
        MiscellaneousIndication,
        __JitterIndication_scope_logicalChannelNumber,
        __JitterIndication_scope_resourceID,
        __JitterIndication_scope_wholeMultiplex,
        _JitterIndication_scope,
        _JitterIndication_estimatedReceivedJitterMantissa,
        _JitterIndication_estimatedReceivedJitterExponent,
        _JitterIndication_skippedFrameCount,
        _JitterIndication_additionalDecoderBuffer,
        JitterIndication,
        _H223SkewIndication_logicalChannelNumber1,
        _H223SkewIndication_logicalChannelNumber2,
        _H223SkewIndication_skew,
        H223SkewIndication,
        _H2250MaximumSkewIndication_logicalChannelNumber1,
        _H2250MaximumSkewIndication_logicalChannelNumber2,
        _H2250MaximumSkewIndication_maximumSkew,
        H2250MaximumSkewIndication,
        _MCLocationIndication_signalAddress,
        MCLocationIndication,
        _VendorIdentification_vendor,
        _VendorIdentification_productNumber,
        _VendorIdentification_versionNumber,
        VendorIdentification,
        _NewATMVCIndication_resourceID,
        _NewATMVCIndication_bitRate,
        _NewATMVCIndication_bitRateLockedToPCRClock,
        _NewATMVCIndication_bitRateLockedToNetworkClock,
        ____NewATMVCIndication_aal_aal1_clockRecovery_nullClockRecovery,
        ____NewATMVCIndication_aal_aal1_clockRecovery_srtsClockRecovery,
        ____NewATMVCIndication_aal_aal1_clockRecovery_adaptiveClockRecovery,
        ___NewATMVCIndication_aal_aal1_clockRecovery,
        ____NewATMVCIndication_aal_aal1_errorCorrection_nullErrorCorrection,
        ____NewATMVCIndication_aal_aal1_errorCorrection_longInterleaver,
        ____NewATMVCIndication_aal_aal1_errorCorrection_shortInterleaver,
        ____NewATMVCIndication_aal_aal1_errorCorrection_errorCorrectionOnly,
        ___NewATMVCIndication_aal_aal1_errorCorrection,
        ___NewATMVCIndication_aal_aal1_structuredDataTransfer,
        ___NewATMVCIndication_aal_aal1_partiallyFilledCells,
        __NewATMVCIndication_aal_aal1,
        ___NewATMVCIndication_aal_aal5_forwardMaximumSDUSize,
        ___NewATMVCIndication_aal_aal5_backwardMaximumSDUSize,
        __NewATMVCIndication_aal_aal5,
        _NewATMVCIndication_aal,
        __NewATMVCIndication_multiplex_noMultiplex,
        __NewATMVCIndication_multiplex_transportStream,
        __NewATMVCIndication_multiplex_programStream,
        _NewATMVCIndication_multiplex,
        __NewATMVCIndication_reverseParameters_bitRate,
        __NewATMVCIndication_reverseParameters_bitRateLockedToPCRClock,
        __NewATMVCIndication_reverseParameters_bitRateLockedToNetworkClock,
        ___NewATMVCIndication_reverseParameters_multiplex_noMultiplex,
        ___NewATMVCIndication_reverseParameters_multiplex_transportStream,
        ___NewATMVCIndication_reverseParameters_multiplex_programStream,
        __NewATMVCIndication_reverseParameters_multiplex,
        _NewATMVCIndication_reverseParameters,
        NewATMVCIndication,
        IV8,
        IV16,
        _Params_iv8,
        _Params_iv16,
        _Params_iv,
        Params,
        _UserInputIndication_nonStandard,
        _UserInputIndication_alphanumeric,
        __UserInputIndication_userInputSupportIndication_nonStandard,
        __UserInputIndication_userInputSupportIndication_basicString,
        __UserInputIndication_userInputSupportIndication_iA5String,
        __UserInputIndication_userInputSupportIndication_generalString,
        __UserInputIndication_userInputSupportIndication_encryptedBasicString,
        __UserInputIndication_userInputSupportIndication_encryptedIA5String,
        __UserInputIndication_userInputSupportIndication_encryptedGeneralString,
        _UserInputIndication_userInputSupportIndication,
        __UserInputIndication_signal_signalType,
        __UserInputIndication_signal_duration,
        ___UserInputIndication_signal_rtp_timestamp,
        ___UserInputIndication_signal_rtp_expirationTime,
        ___UserInputIndication_signal_rtp_logicalChannelNumber,
        __UserInputIndication_signal_rtp,
        __UserInputIndication_signal_rtpPayloadIndication,
        __UserInputIndication_signal_paramS,
        __UserInputIndication_signal_encryptedSignalType,
        __UserInputIndication_signal_algorithmOID,
        _UserInputIndication_signal,
        __UserInputIndication_signalUpdate_duration,
        ___UserInputIndication_signalUpdate_rtp_logicalChannelNumber,
        __UserInputIndication_signalUpdate_rtp,
        _UserInputIndication_signalUpdate,
        __UserInputIndication_extendedAlphanumeric_alphanumeric,
        __UserInputIndication_extendedAlphanumeric_rtpPayloadIndication,
        ___UserInputIndication_extendedAlphanumeric_encryptedAlphanumeric_algorithmOID,
        ___UserInputIndication_extendedAlphanumeric_encryptedAlphanumeric_paramS,
        ___UserInputIndication_extendedAlphanumeric_encryptedAlphanumeric_encrypted,
        __UserInputIndication_extendedAlphanumeric_encryptedAlphanumeric,
        _UserInputIndication_extendedAlphanumeric,
        __UserInputIndication_encryptedAlphanumeric_algorithmOID,
        __UserInputIndication_encryptedAlphanumeric_paramS,
        __UserInputIndication_encryptedAlphanumeric_encrypted,
        _UserInputIndication_encryptedAlphanumeric,
        __UserInputIndication_genericInformation__item_,
        _UserInputIndication_genericInformation,
        UserInputIndication,
        __FlowControlIndication_scope_logicalChannelNumber,
        __FlowControlIndication_scope_resourceID,
        __FlowControlIndication_scope_wholeMultiplex,
        _FlowControlIndication_scope,
        __FlowControlIndication_restriction_maximumBitRate,
        __FlowControlIndication_restriction_noRestriction,
        _FlowControlIndication_restriction,
        FlowControlIndication,
        _MobileMultilinkReconfigurationIndication_sampleSize,
        _MobileMultilinkReconfigurationIndication_samplesPerFrame,
        MobileMultilinkReconfigurationIndication,
    ]

init_modules(MULTIMEDIA_SYSTEM_CONTROL)
