# -*- coding: UTF-8 -*-
# Code automatically generated by pycrate_asn1c

from pycrate_asn1rt.utils            import *
from pycrate_asn1rt.err              import *
from pycrate_asn1rt.glob             import make_GLOBAL, GLOBAL
from pycrate_asn1rt.dictobj          import ASN1Dict
from pycrate_asn1rt.refobj           import *
from pycrate_asn1rt.setobj           import *
from pycrate_asn1rt.asnobj_basic     import *
from pycrate_asn1rt.asnobj_str       import *
from pycrate_asn1rt.asnobj_construct import *
from pycrate_asn1rt.asnobj_class     import *
from pycrate_asn1rt.asnobj_ext       import *
from pycrate_asn1rt.init             import init_modules

class TS33128IdentityAssociation:

    _name_  = u'TS33128IdentityAssociation'
    _oid_   = [0, 4, 0, 2, 2, 4, 20, 16, 2]
    
    _obj_ = [
        u'tS33128IdentityAssociationOID',
        u'iEFRecordOID',
        u'IEFMessage',
        u'IEFRecord',
        u'IEFAssociationRecord',
        u'IEFDeassociationRecord',
        u'IEFKeepaliveMessage',
        u'FiveGGUTI',
        u'NCGI',
        u'PLMNID',
        u'NCI',
        u'TAI',
        u'SUPI',
        u'IMSI',
        u'NAI',
        u'FiveGSTAIList',
        u'PEI',
        u'IMEI',
        u'IMEISV',
        u'MACAddress',
        u'EUI64',
        u'SUCI',
        ]
    _type_ = [
        u'IEFMessage',
        u'IEFRecord',
        u'IEFAssociationRecord',
        u'IEFDeassociationRecord',
        u'IEFKeepaliveMessage',
        u'FiveGGUTI',
        u'NCGI',
        u'PLMNID',
        u'NCI',
        u'TAI',
        u'SUPI',
        u'IMSI',
        u'NAI',
        u'FiveGSTAIList',
        u'PEI',
        u'IMEI',
        u'IMEISV',
        u'MACAddress',
        u'EUI64',
        u'SUCI',
        ]
    _set_ = [
        ]
    _val_ = [
        u'tS33128IdentityAssociationOID',
        u'iEFRecordOID',
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< tS33128IdentityAssociationOID >-----#
    tS33128IdentityAssociationOID = REL_OID(name=u'tS33128IdentityAssociationOID', mode=MODE_VALUE)
    tS33128IdentityAssociationOID._val = (4, 20, 16, 2)
    
    #-----< iEFRecordOID >-----#
    iEFRecordOID = REL_OID(name=u'iEFRecordOID', mode=MODE_VALUE)
    iEFRecordOID._val = (4, 20, 16, 2, 1)
    
    #-----< IEFMessage >-----#
    IEFMessage = SEQ(name=u'IEFMessage', mode=MODE_TYPE)
    _IEFMessage_iEFRecordOID = REL_OID(name=u'iEFRecordOID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IEFMessage_record = CHOICE(name=u'record', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128IdentityAssociation', 'IEFRecord')))
    IEFMessage._cont = ASN1Dict([
        (u'iEFRecordOID', _IEFMessage_iEFRecordOID),
        (u'record', _IEFMessage_record),
        ])
    IEFMessage._ext = []
    
    #-----< IEFRecord >-----#
    IEFRecord = CHOICE(name=u'IEFRecord', mode=MODE_TYPE)
    _IEFRecord_associationRecord = SEQ(name=u'associationRecord', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128IdentityAssociation', 'IEFAssociationRecord')))
    _IEFRecord_deassociationRecord = SEQ(name=u'deassociationRecord', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128IdentityAssociation', 'IEFDeassociationRecord')))
    _IEFRecord_keepalive = SEQ(name=u'keepalive', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128IdentityAssociation', 'IEFKeepaliveMessage')))
    _IEFRecord_keepaliveResponse = SEQ(name=u'keepaliveResponse', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128IdentityAssociation', 'IEFKeepaliveMessage')))
    IEFRecord._cont = ASN1Dict([
        (u'associationRecord', _IEFRecord_associationRecord),
        (u'deassociationRecord', _IEFRecord_deassociationRecord),
        (u'keepalive', _IEFRecord_keepalive),
        (u'keepaliveResponse', _IEFRecord_keepaliveResponse),
        ])
    IEFRecord._ext = []
    
    #-----< IEFAssociationRecord >-----#
    IEFAssociationRecord = SEQ(name=u'IEFAssociationRecord', mode=MODE_TYPE)
    _IEFAssociationRecord_sUPI = CHOICE(name=u'sUPI', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128IdentityAssociation', 'SUPI')))
    _IEFAssociationRecord_fiveGGUTI = OCT_STR(name=u'fiveGGUTI', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128IdentityAssociation', 'FiveGGUTI')))
    _IEFAssociationRecord_timestamp = TIME_GEN(name=u'timestamp', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IEFAssociationRecord_tAI = OCT_STR(name=u'tAI', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128IdentityAssociation', 'TAI')))
    _IEFAssociationRecord_nCGI = SEQ(name=u'nCGI', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128IdentityAssociation', 'NCGI')))
    _IEFAssociationRecord_nCGITime = TIME_GEN(name=u'nCGITime', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IEFAssociationRecord_sUCI = OCT_STR(name=u'sUCI', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128IdentityAssociation', 'SUCI')), opt=True)
    _IEFAssociationRecord_pEI = CHOICE(name=u'pEI', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128IdentityAssociation', 'PEI')), opt=True)
    _IEFAssociationRecord_fiveGSTAIList = SEQ_OF(name=u'fiveGSTAIList', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128IdentityAssociation', 'FiveGSTAIList')), opt=True)
    IEFAssociationRecord._cont = ASN1Dict([
        (u'sUPI', _IEFAssociationRecord_sUPI),
        (u'fiveGGUTI', _IEFAssociationRecord_fiveGGUTI),
        (u'timestamp', _IEFAssociationRecord_timestamp),
        (u'tAI', _IEFAssociationRecord_tAI),
        (u'nCGI', _IEFAssociationRecord_nCGI),
        (u'nCGITime', _IEFAssociationRecord_nCGITime),
        (u'sUCI', _IEFAssociationRecord_sUCI),
        (u'pEI', _IEFAssociationRecord_pEI),
        (u'fiveGSTAIList', _IEFAssociationRecord_fiveGSTAIList),
        ])
    IEFAssociationRecord._ext = []
    
    #-----< IEFDeassociationRecord >-----#
    IEFDeassociationRecord = SEQ(name=u'IEFDeassociationRecord', mode=MODE_TYPE)
    _IEFDeassociationRecord_sUPI = CHOICE(name=u'sUPI', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128IdentityAssociation', 'SUPI')))
    _IEFDeassociationRecord_fiveGGUTI = OCT_STR(name=u'fiveGGUTI', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128IdentityAssociation', 'FiveGGUTI')))
    _IEFDeassociationRecord_timestamp = TIME_GEN(name=u'timestamp', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IEFDeassociationRecord_nCGI = SEQ(name=u'nCGI', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128IdentityAssociation', 'NCGI')))
    _IEFDeassociationRecord_nCGITime = TIME_GEN(name=u'nCGITime', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    IEFDeassociationRecord._cont = ASN1Dict([
        (u'sUPI', _IEFDeassociationRecord_sUPI),
        (u'fiveGGUTI', _IEFDeassociationRecord_fiveGGUTI),
        (u'timestamp', _IEFDeassociationRecord_timestamp),
        (u'nCGI', _IEFDeassociationRecord_nCGI),
        (u'nCGITime', _IEFDeassociationRecord_nCGITime),
        ])
    IEFDeassociationRecord._ext = []
    
    #-----< IEFKeepaliveMessage >-----#
    IEFKeepaliveMessage = SEQ(name=u'IEFKeepaliveMessage', mode=MODE_TYPE)
    _IEFKeepaliveMessage_sequenceNumber = INT(name=u'sequenceNumber', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    IEFKeepaliveMessage._cont = ASN1Dict([
        (u'sequenceNumber', _IEFKeepaliveMessage_sequenceNumber),
        ])
    IEFKeepaliveMessage._ext = []
    
    #-----< FiveGGUTI >-----#
    FiveGGUTI = OCT_STR(name=u'FiveGGUTI', mode=MODE_TYPE)
    FiveGGUTI._const_sz = ASN1Set(rv=[10], rr=[], ev=None, er=[])
    
    #-----< NCGI >-----#
    NCGI = SEQ(name=u'NCGI', mode=MODE_TYPE)
    _NCGI_pLMNID = OCT_STR(name=u'pLMNID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128IdentityAssociation', 'PLMNID')))
    _NCGI_nCI = BIT_STR(name=u'nCI', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128IdentityAssociation', 'NCI')))
    NCGI._cont = ASN1Dict([
        (u'pLMNID', _NCGI_pLMNID),
        (u'nCI', _NCGI_nCI),
        ])
    NCGI._ext = []
    
    #-----< PLMNID >-----#
    PLMNID = OCT_STR(name=u'PLMNID', mode=MODE_TYPE)
    PLMNID._const_sz = ASN1Set(rv=[3], rr=[], ev=None, er=[])
    
    #-----< NCI >-----#
    NCI = BIT_STR(name=u'NCI', mode=MODE_TYPE)
    NCI._const_sz = ASN1Set(rv=[36], rr=[], ev=None, er=[])
    
    #-----< TAI >-----#
    TAI = OCT_STR(name=u'TAI', mode=MODE_TYPE)
    TAI._const_sz = ASN1Set(rv=[6], rr=[], ev=None, er=[])
    
    #-----< SUPI >-----#
    SUPI = CHOICE(name=u'SUPI', mode=MODE_TYPE)
    _SUPI_iMSI = STR_NUM(name=u'iMSI', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128IdentityAssociation', 'IMSI')))
    _SUPI_nAI = STR_UTF8(name=u'nAI', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128IdentityAssociation', 'NAI')))
    SUPI._cont = ASN1Dict([
        (u'iMSI', _SUPI_iMSI),
        (u'nAI', _SUPI_nAI),
        ])
    SUPI._ext = []
    
    #-----< IMSI >-----#
    IMSI = STR_NUM(name=u'IMSI', mode=MODE_TYPE)
    IMSI._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=6, ub=15)], ev=None, er=[])
    
    #-----< NAI >-----#
    NAI = STR_UTF8(name=u'NAI', mode=MODE_TYPE)
    
    #-----< FiveGSTAIList >-----#
    FiveGSTAIList = SEQ_OF(name=u'FiveGSTAIList', mode=MODE_TYPE)
    _FiveGSTAIList__item_ = OCT_STR(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128IdentityAssociation', 'TAI')))
    FiveGSTAIList._cont = _FiveGSTAIList__item_
    
    #-----< PEI >-----#
    PEI = CHOICE(name=u'PEI', mode=MODE_TYPE)
    _PEI_iMEI = STR_NUM(name=u'iMEI', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128IdentityAssociation', 'IMEI')))
    _PEI_iMEISV = STR_NUM(name=u'iMEISV', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128IdentityAssociation', 'IMEISV')))
    _PEI_mACAddress = OCT_STR(name=u'mACAddress', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128IdentityAssociation', 'MACAddress')))
    _PEI_eUI64 = OCT_STR(name=u'eUI64', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128IdentityAssociation', 'EUI64')))
    PEI._cont = ASN1Dict([
        (u'iMEI', _PEI_iMEI),
        (u'iMEISV', _PEI_iMEISV),
        (u'mACAddress', _PEI_mACAddress),
        (u'eUI64', _PEI_eUI64),
        ])
    PEI._ext = []
    
    #-----< IMEI >-----#
    IMEI = STR_NUM(name=u'IMEI', mode=MODE_TYPE)
    IMEI._const_sz = ASN1Set(rv=[14], rr=[], ev=None, er=[])
    
    #-----< IMEISV >-----#
    IMEISV = STR_NUM(name=u'IMEISV', mode=MODE_TYPE)
    IMEISV._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    
    #-----< MACAddress >-----#
    MACAddress = OCT_STR(name=u'MACAddress', mode=MODE_TYPE)
    MACAddress._const_sz = ASN1Set(rv=[6], rr=[], ev=None, er=[])
    
    #-----< EUI64 >-----#
    EUI64 = OCT_STR(name=u'EUI64', mode=MODE_TYPE)
    EUI64._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    
    #-----< SUCI >-----#
    SUCI = OCT_STR(name=u'SUCI', mode=MODE_TYPE)
    SUCI._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=8, ub=3008)], ev=None, er=[])
    
    _all_ = [
        tS33128IdentityAssociationOID,
        iEFRecordOID,
        _IEFMessage_iEFRecordOID,
        _IEFMessage_record,
        IEFMessage,
        _IEFRecord_associationRecord,
        _IEFRecord_deassociationRecord,
        _IEFRecord_keepalive,
        _IEFRecord_keepaliveResponse,
        IEFRecord,
        _IEFAssociationRecord_sUPI,
        _IEFAssociationRecord_fiveGGUTI,
        _IEFAssociationRecord_timestamp,
        _IEFAssociationRecord_tAI,
        _IEFAssociationRecord_nCGI,
        _IEFAssociationRecord_nCGITime,
        _IEFAssociationRecord_sUCI,
        _IEFAssociationRecord_pEI,
        _IEFAssociationRecord_fiveGSTAIList,
        IEFAssociationRecord,
        _IEFDeassociationRecord_sUPI,
        _IEFDeassociationRecord_fiveGGUTI,
        _IEFDeassociationRecord_timestamp,
        _IEFDeassociationRecord_nCGI,
        _IEFDeassociationRecord_nCGITime,
        IEFDeassociationRecord,
        _IEFKeepaliveMessage_sequenceNumber,
        IEFKeepaliveMessage,
        FiveGGUTI,
        _NCGI_pLMNID,
        _NCGI_nCI,
        NCGI,
        PLMNID,
        NCI,
        TAI,
        _SUPI_iMSI,
        _SUPI_nAI,
        SUPI,
        IMSI,
        NAI,
        _FiveGSTAIList__item_,
        FiveGSTAIList,
        _PEI_iMEI,
        _PEI_iMEISV,
        _PEI_mACAddress,
        _PEI_eUI64,
        PEI,
        IMEI,
        IMEISV,
        MACAddress,
        EUI64,
        SUCI,
    ]

class TS33128Payloads:

    _name_  = u'TS33128Payloads'
    _oid_   = [0, 4, 0, 2, 2, 4, 19, 16, 5]
    
    _obj_ = [
        u'tS33128PayloadsOID',
        u'xIRIPayloadOID',
        u'xCCPayloadOID',
        u'iRIPayloadOID',
        u'cCPayloadOID',
        u'lINotificationPayloadOID',
        u'XIRIPayload',
        u'XIRIEvent',
        u'IRIPayload',
        u'IRIEvent',
        u'IRITargetIdentifier',
        u'CCPayload',
        u'CCPDU',
        u'LINotificationPayload',
        u'LINotificationMessage',
        u'AMFRegistration',
        u'AMFDeregistration',
        u'AMFLocationUpdate',
        u'AMFStartOfInterceptionWithRegisteredUE',
        u'AMFUnsuccessfulProcedure',
        u'AMFID',
        u'AMFDirection',
        u'AMFFailedProcedureType',
        u'AMFFailureCause',
        u'AMFPointer',
        u'AMFRegistrationResult',
        u'AMFRegionID',
        u'AMFRegistrationType',
        u'AMFSetID',
        u'SMFPDUSessionEstablishment',
        u'SMFPDUSessionModification',
        u'SMFPDUSessionRelease',
        u'SMFStartOfInterceptionWithEstablishedPDUSession',
        u'SMFUnsuccessfulProcedure',
        u'SMFPDUtoMAPDUSessionModification',
        u'SMFMAPDUSessionEstablishment',
        u'SMFMAPDUSessionModification',
        u'SMFMAPDUSessionRelease',
        u'SMFStartOfInterceptionWithEstablishedMAPDUSession',
        u'SMFMAUnsuccessfulProcedure',
        u'SMFFailedProcedureType',
        u'SMFServingNetwork',
        u'AccessInfo',
        u'ATSSSContainer',
        u'EstablishmentStatus',
        u'SMFMAUpgradeIndication',
        u'SMFEPSPDNCnxInfo',
        u'SMFMAAcceptedIndication',
        u'SMFErrorCodes',
        u'UEEPSPDNConnection',
        u'RequestIndication',
        u'UPFCCPDU',
        u'ExtendedUPFCCPDU',
        u'UPFCCPDUPayload',
        u'QFI',
        u'UDMServingSystemMessage',
        u'UDMSubscriberRecordChangeMessage',
        u'UDMCancelLocationMessage',
        u'UDMServingSystemMethod',
        u'UDMSubscriberRecordChangeMethod',
        u'UDMCancelLocationMethod',
        u'ServiceID',
        u'CAGID',
        u'SMSMessage',
        u'SMSReport',
        u'SMSAddress',
        u'SMSMessageType',
        u'SMSParty',
        u'SMSTransferStatus',
        u'SMSOtherMessageIndication',
        u'SMSNFAddress',
        u'SMSNFType',
        u'SMSRPMessageReference',
        u'SMSTPDUData',
        u'SMSTPDU',
        u'TruncatedSMSTPDU',
        u'MMSSend',
        u'MMSSendByNonLocalTarget',
        u'MMSNotification',
        u'MMSSendToNonLocalTarget',
        u'MMSNotificationResponse',
        u'MMSRetrieval',
        u'MMSDeliveryAck',
        u'MMSForward',
        u'MMSDeleteFromRelay',
        u'MMSMBoxStore',
        u'MMSMBoxUpload',
        u'MMSMBoxDelete',
        u'MMSDeliveryReport',
        u'MMSDeliveryReportNonLocalTarget',
        u'MMSReadReport',
        u'MMSReadReportNonLocalTarget',
        u'MMSCancel',
        u'MMSMBoxViewRequest',
        u'MMSMBoxViewResponse',
        u'MMBoxDescription',
        u'MMSCCPDU',
        u'MMSAdaptation',
        u'MMSCancelStatus',
        u'MMSContentClass',
        u'MMSContentType',
        u'MMSDeleteResponseStatus',
        u'MMSDirection',
        u'MMSElementDescriptor',
        u'MMSExpiry',
        u'MMFlags',
        u'MMSMessageClass',
        u'MMSParty',
        u'MMSPartyID',
        u'MMSPeriodFormat',
        u'MMSPreviouslySent',
        u'MMSPreviouslySentBy',
        u'MMSPriority',
        u'MMSQuota',
        u'MMSQuotaUnit',
        u'MMSReadStatus',
        u'MMSReadStatusText',
        u'MMSReplyCharging',
        u'MMSResponseStatus',
        u'MMSRetrieveStatus',
        u'MMSStoreStatus',
        u'MMState',
        u'MMStateFlag',
        u'MMStatus',
        u'MMStatusExtension',
        u'MMStatusText',
        u'MMSSubject',
        u'MMSVersion',
        u'PTCRegistration',
        u'PTCSessionInitiation',
        u'PTCSessionAbandon',
        u'PTCSessionStart',
        u'PTCSessionEnd',
        u'PTCStartOfInterception',
        u'PTCPreEstablishedSession',
        u'PTCInstantPersonalAlert',
        u'PTCPartyJoin',
        u'PTCPartyDrop',
        u'PTCPartyHold',
        u'PTCMediaModification',
        u'PTCGroupAdvertisement',
        u'PTCFloorControl',
        u'PTCTargetPresence',
        u'PTCParticipantPresence',
        u'PTCListManagement',
        u'PTCAccessPolicy',
        u'PTCRegistrationRequest',
        u'PTCRegistrationOutcome',
        u'PTCSessionEndCause',
        u'PTCTargetInformation',
        u'PTCIdentifiers',
        u'PTCSessionInfo',
        u'PTCSessionType',
        u'MultipleParticipantPresenceStatus',
        u'PTCParticipantPresenceStatus',
        u'PTCPresenceType',
        u'PTCPreEstStatus',
        u'RTPSetting',
        u'PTCIDList',
        u'PTCChatGroupID',
        u'PTCFloorActivity',
        u'PTCTBPriorityLevel',
        u'PTCTBReasonCode',
        u'PTCListManagementType',
        u'PTCListManagementAction',
        u'PTCAccessPolicyType',
        u'PTCUserAccessPolicy',
        u'PTCGroupAuthRule',
        u'PTCFailureCode',
        u'PTCListManagementFailure',
        u'PTCAccessPolicyFailure',
        u'LALSReport',
        u'PDHeaderReport',
        u'PDSummaryReport',
        u'PDSRSummaryTrigger',
        u'AMFIdentifierAssocation',
        u'MMEIdentifierAssocation',
        u'GUTI',
        u'MMEGroupID',
        u'MMECode',
        u'TMSI',
        u'LINotification',
        u'LINotificationType',
        u'LIAppliedDeliveryInformation',
        u'MDFCellSiteReport',
        u'AccessType',
        u'Direction',
        u'DNN',
        u'E164Number',
        u'EmailAddress',
        u'FiveGGUTI',
        u'FiveGMMCause',
        u'FiveGSMRequestType',
        u'FiveGSMCause',
        u'FiveGTMSI',
        u'FTEID',
        u'GPSI',
        u'GUAMI',
        u'GUMMEI',
        u'HomeNetworkPublicKeyID',
        u'HSMFURI',
        u'IMEI',
        u'IMEISV',
        u'IMPI',
        u'IMPU',
        u'IMSI',
        u'Initiator',
        u'IPAddress',
        u'IPv4Address',
        u'IPv6Address',
        u'IPv6FlowLabel',
        u'MACAddress',
        u'MCC',
        u'MNC',
        u'MMEID',
        u'MMEC',
        u'MMEGI',
        u'MSISDN',
        u'NAI',
        u'NextLayerProtocol',
        u'NonLocalID',
        u'NSSAI',
        u'PLMNID',
        u'PDUSessionID',
        u'PDUSessionType',
        u'PEI',
        u'PortNumber',
        u'ProtectionSchemeID',
        u'RATType',
        u'RejectedNSSAI',
        u'RejectedSNSSAI',
        u'RejectedSliceCauseValue',
        u'RoutingIndicator',
        u'SchemeOutput',
        u'SIPURI',
        u'Slice',
        u'SMPDUDNRequest',
        u'SNSSAI',
        u'SUCI',
        u'SUPI',
        u'SUPIUnauthenticatedIndication',
        u'TargetIdentifier',
        u'TargetIdentifierProvenance',
        u'TELURI',
        u'Timestamp',
        u'UEEndpointAddress',
        u'Location',
        u'CellSiteInformation',
        u'LocationInfo',
        u'UserLocation',
        u'EUTRALocation',
        u'NRLocation',
        u'N3GALocation',
        u'IPAddr',
        u'GlobalRANNodeID',
        u'ANNodeID',
        u'GNbID',
        u'TAI',
        u'ECGI',
        u'TAIList',
        u'NCGI',
        u'RANCGI',
        u'CellInformation',
        u'N3IWFIDNGAP',
        u'N3IWFIDSBI',
        u'TAC',
        u'EUTRACellID',
        u'NRCellID',
        u'NGENbID',
        u'NID',
        u'ENbID',
        u'PositioningInfo',
        u'RawMLPResponse',
        u'LocationData',
        u'LocationPresenceReport',
        u'AMFEventType',
        u'AMFEventArea',
        u'PresenceInfo',
        u'LADNInfo',
        u'PresenceState',
        u'RMInfo',
        u'CMInfo',
        u'UEReachability',
        u'RMState',
        u'CMState',
        u'GeographicArea',
        u'AccuracyFulfilmentIndicator',
        u'VelocityEstimate',
        u'CivicAddress',
        u'PositioningMethodAndUsage',
        u'GNSSPositioningMethodAndUsage',
        u'Point',
        u'PointUncertaintyCircle',
        u'PointUncertaintyEllipse',
        u'Polygon',
        u'PointAltitude',
        u'PointAltitudeUncertainty',
        u'EllipsoidArc',
        u'GeographicalCoordinates',
        u'UncertaintyEllipse',
        u'HorizontalVelocity',
        u'HorizontalWithVerticalVelocity',
        u'HorizontalVelocityWithUncertainty',
        u'HorizontalWithVerticalVelocityAndUncertainty',
        u'Altitude',
        u'Angle',
        u'Uncertainty',
        u'Orientation',
        u'Confidence',
        u'InnerRadius',
        u'AgeOfLocationEstimate',
        u'HorizontalSpeed',
        u'VerticalSpeed',
        u'SpeedUncertainty',
        u'BarometricPressure',
        u'VerticalDirection',
        u'PositioningMethod',
        u'PositioningMode',
        u'GNSSID',
        u'Usage',
        u'TimeZone',
        u'OGCURN',
        u'MethodCode',
        ]
    _type_ = [
        u'XIRIPayload',
        u'XIRIEvent',
        u'IRIPayload',
        u'IRIEvent',
        u'IRITargetIdentifier',
        u'CCPayload',
        u'CCPDU',
        u'LINotificationPayload',
        u'LINotificationMessage',
        u'AMFRegistration',
        u'AMFDeregistration',
        u'AMFLocationUpdate',
        u'AMFStartOfInterceptionWithRegisteredUE',
        u'AMFUnsuccessfulProcedure',
        u'AMFID',
        u'AMFDirection',
        u'AMFFailedProcedureType',
        u'AMFFailureCause',
        u'AMFPointer',
        u'AMFRegistrationResult',
        u'AMFRegionID',
        u'AMFRegistrationType',
        u'AMFSetID',
        u'SMFPDUSessionEstablishment',
        u'SMFPDUSessionModification',
        u'SMFPDUSessionRelease',
        u'SMFStartOfInterceptionWithEstablishedPDUSession',
        u'SMFUnsuccessfulProcedure',
        u'SMFPDUtoMAPDUSessionModification',
        u'SMFMAPDUSessionEstablishment',
        u'SMFMAPDUSessionModification',
        u'SMFMAPDUSessionRelease',
        u'SMFStartOfInterceptionWithEstablishedMAPDUSession',
        u'SMFMAUnsuccessfulProcedure',
        u'SMFFailedProcedureType',
        u'SMFServingNetwork',
        u'AccessInfo',
        u'ATSSSContainer',
        u'EstablishmentStatus',
        u'SMFMAUpgradeIndication',
        u'SMFEPSPDNCnxInfo',
        u'SMFMAAcceptedIndication',
        u'SMFErrorCodes',
        u'UEEPSPDNConnection',
        u'RequestIndication',
        u'UPFCCPDU',
        u'ExtendedUPFCCPDU',
        u'UPFCCPDUPayload',
        u'QFI',
        u'UDMServingSystemMessage',
        u'UDMSubscriberRecordChangeMessage',
        u'UDMCancelLocationMessage',
        u'UDMServingSystemMethod',
        u'UDMSubscriberRecordChangeMethod',
        u'UDMCancelLocationMethod',
        u'ServiceID',
        u'CAGID',
        u'SMSMessage',
        u'SMSReport',
        u'SMSAddress',
        u'SMSMessageType',
        u'SMSParty',
        u'SMSTransferStatus',
        u'SMSOtherMessageIndication',
        u'SMSNFAddress',
        u'SMSNFType',
        u'SMSRPMessageReference',
        u'SMSTPDUData',
        u'SMSTPDU',
        u'TruncatedSMSTPDU',
        u'MMSSend',
        u'MMSSendByNonLocalTarget',
        u'MMSNotification',
        u'MMSSendToNonLocalTarget',
        u'MMSNotificationResponse',
        u'MMSRetrieval',
        u'MMSDeliveryAck',
        u'MMSForward',
        u'MMSDeleteFromRelay',
        u'MMSMBoxStore',
        u'MMSMBoxUpload',
        u'MMSMBoxDelete',
        u'MMSDeliveryReport',
        u'MMSDeliveryReportNonLocalTarget',
        u'MMSReadReport',
        u'MMSReadReportNonLocalTarget',
        u'MMSCancel',
        u'MMSMBoxViewRequest',
        u'MMSMBoxViewResponse',
        u'MMBoxDescription',
        u'MMSCCPDU',
        u'MMSAdaptation',
        u'MMSCancelStatus',
        u'MMSContentClass',
        u'MMSContentType',
        u'MMSDeleteResponseStatus',
        u'MMSDirection',
        u'MMSElementDescriptor',
        u'MMSExpiry',
        u'MMFlags',
        u'MMSMessageClass',
        u'MMSParty',
        u'MMSPartyID',
        u'MMSPeriodFormat',
        u'MMSPreviouslySent',
        u'MMSPreviouslySentBy',
        u'MMSPriority',
        u'MMSQuota',
        u'MMSQuotaUnit',
        u'MMSReadStatus',
        u'MMSReadStatusText',
        u'MMSReplyCharging',
        u'MMSResponseStatus',
        u'MMSRetrieveStatus',
        u'MMSStoreStatus',
        u'MMState',
        u'MMStateFlag',
        u'MMStatus',
        u'MMStatusExtension',
        u'MMStatusText',
        u'MMSSubject',
        u'MMSVersion',
        u'PTCRegistration',
        u'PTCSessionInitiation',
        u'PTCSessionAbandon',
        u'PTCSessionStart',
        u'PTCSessionEnd',
        u'PTCStartOfInterception',
        u'PTCPreEstablishedSession',
        u'PTCInstantPersonalAlert',
        u'PTCPartyJoin',
        u'PTCPartyDrop',
        u'PTCPartyHold',
        u'PTCMediaModification',
        u'PTCGroupAdvertisement',
        u'PTCFloorControl',
        u'PTCTargetPresence',
        u'PTCParticipantPresence',
        u'PTCListManagement',
        u'PTCAccessPolicy',
        u'PTCRegistrationRequest',
        u'PTCRegistrationOutcome',
        u'PTCSessionEndCause',
        u'PTCTargetInformation',
        u'PTCIdentifiers',
        u'PTCSessionInfo',
        u'PTCSessionType',
        u'MultipleParticipantPresenceStatus',
        u'PTCParticipantPresenceStatus',
        u'PTCPresenceType',
        u'PTCPreEstStatus',
        u'RTPSetting',
        u'PTCIDList',
        u'PTCChatGroupID',
        u'PTCFloorActivity',
        u'PTCTBPriorityLevel',
        u'PTCTBReasonCode',
        u'PTCListManagementType',
        u'PTCListManagementAction',
        u'PTCAccessPolicyType',
        u'PTCUserAccessPolicy',
        u'PTCGroupAuthRule',
        u'PTCFailureCode',
        u'PTCListManagementFailure',
        u'PTCAccessPolicyFailure',
        u'LALSReport',
        u'PDHeaderReport',
        u'PDSummaryReport',
        u'PDSRSummaryTrigger',
        u'AMFIdentifierAssocation',
        u'MMEIdentifierAssocation',
        u'GUTI',
        u'MMEGroupID',
        u'MMECode',
        u'TMSI',
        u'LINotification',
        u'LINotificationType',
        u'LIAppliedDeliveryInformation',
        u'MDFCellSiteReport',
        u'AccessType',
        u'Direction',
        u'DNN',
        u'E164Number',
        u'EmailAddress',
        u'FiveGGUTI',
        u'FiveGMMCause',
        u'FiveGSMRequestType',
        u'FiveGSMCause',
        u'FiveGTMSI',
        u'FTEID',
        u'GPSI',
        u'GUAMI',
        u'GUMMEI',
        u'HomeNetworkPublicKeyID',
        u'HSMFURI',
        u'IMEI',
        u'IMEISV',
        u'IMPI',
        u'IMPU',
        u'IMSI',
        u'Initiator',
        u'IPAddress',
        u'IPv4Address',
        u'IPv6Address',
        u'IPv6FlowLabel',
        u'MACAddress',
        u'MCC',
        u'MNC',
        u'MMEID',
        u'MMEC',
        u'MMEGI',
        u'MSISDN',
        u'NAI',
        u'NextLayerProtocol',
        u'NonLocalID',
        u'NSSAI',
        u'PLMNID',
        u'PDUSessionID',
        u'PDUSessionType',
        u'PEI',
        u'PortNumber',
        u'ProtectionSchemeID',
        u'RATType',
        u'RejectedNSSAI',
        u'RejectedSNSSAI',
        u'RejectedSliceCauseValue',
        u'RoutingIndicator',
        u'SchemeOutput',
        u'SIPURI',
        u'Slice',
        u'SMPDUDNRequest',
        u'SNSSAI',
        u'SUCI',
        u'SUPI',
        u'SUPIUnauthenticatedIndication',
        u'TargetIdentifier',
        u'TargetIdentifierProvenance',
        u'TELURI',
        u'Timestamp',
        u'UEEndpointAddress',
        u'Location',
        u'CellSiteInformation',
        u'LocationInfo',
        u'UserLocation',
        u'EUTRALocation',
        u'NRLocation',
        u'N3GALocation',
        u'IPAddr',
        u'GlobalRANNodeID',
        u'ANNodeID',
        u'GNbID',
        u'TAI',
        u'ECGI',
        u'TAIList',
        u'NCGI',
        u'RANCGI',
        u'CellInformation',
        u'N3IWFIDNGAP',
        u'N3IWFIDSBI',
        u'TAC',
        u'EUTRACellID',
        u'NRCellID',
        u'NGENbID',
        u'NID',
        u'ENbID',
        u'PositioningInfo',
        u'RawMLPResponse',
        u'LocationData',
        u'LocationPresenceReport',
        u'AMFEventType',
        u'AMFEventArea',
        u'PresenceInfo',
        u'LADNInfo',
        u'PresenceState',
        u'RMInfo',
        u'CMInfo',
        u'UEReachability',
        u'RMState',
        u'CMState',
        u'GeographicArea',
        u'AccuracyFulfilmentIndicator',
        u'VelocityEstimate',
        u'CivicAddress',
        u'PositioningMethodAndUsage',
        u'GNSSPositioningMethodAndUsage',
        u'Point',
        u'PointUncertaintyCircle',
        u'PointUncertaintyEllipse',
        u'Polygon',
        u'PointAltitude',
        u'PointAltitudeUncertainty',
        u'EllipsoidArc',
        u'GeographicalCoordinates',
        u'UncertaintyEllipse',
        u'HorizontalVelocity',
        u'HorizontalWithVerticalVelocity',
        u'HorizontalVelocityWithUncertainty',
        u'HorizontalWithVerticalVelocityAndUncertainty',
        u'Altitude',
        u'Angle',
        u'Uncertainty',
        u'Orientation',
        u'Confidence',
        u'InnerRadius',
        u'AgeOfLocationEstimate',
        u'HorizontalSpeed',
        u'VerticalSpeed',
        u'SpeedUncertainty',
        u'BarometricPressure',
        u'VerticalDirection',
        u'PositioningMethod',
        u'PositioningMode',
        u'GNSSID',
        u'Usage',
        u'TimeZone',
        u'OGCURN',
        u'MethodCode',
        ]
    _set_ = [
        ]
    _val_ = [
        u'tS33128PayloadsOID',
        u'xIRIPayloadOID',
        u'xCCPayloadOID',
        u'iRIPayloadOID',
        u'cCPayloadOID',
        u'lINotificationPayloadOID',
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< tS33128PayloadsOID >-----#
    tS33128PayloadsOID = REL_OID(name=u'tS33128PayloadsOID', mode=MODE_VALUE)
    tS33128PayloadsOID._val = (4, 19, 16, 5)
    
    #-----< xIRIPayloadOID >-----#
    xIRIPayloadOID = REL_OID(name=u'xIRIPayloadOID', mode=MODE_VALUE)
    xIRIPayloadOID._val = (4, 19, 16, 5, 1)
    
    #-----< xCCPayloadOID >-----#
    xCCPayloadOID = REL_OID(name=u'xCCPayloadOID', mode=MODE_VALUE)
    xCCPayloadOID._val = (4, 19, 16, 5, 2)
    
    #-----< iRIPayloadOID >-----#
    iRIPayloadOID = REL_OID(name=u'iRIPayloadOID', mode=MODE_VALUE)
    iRIPayloadOID._val = (4, 19, 16, 5, 3)
    
    #-----< cCPayloadOID >-----#
    cCPayloadOID = REL_OID(name=u'cCPayloadOID', mode=MODE_VALUE)
    cCPayloadOID._val = (4, 19, 16, 5, 4)
    
    #-----< lINotificationPayloadOID >-----#
    lINotificationPayloadOID = REL_OID(name=u'lINotificationPayloadOID', mode=MODE_VALUE)
    lINotificationPayloadOID._val = (4, 19, 16, 5, 5)
    
    #-----< XIRIPayload >-----#
    XIRIPayload = SEQ(name=u'XIRIPayload', mode=MODE_TYPE)
    _XIRIPayload_xIRIPayloadOID = REL_OID(name=u'xIRIPayloadOID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _XIRIPayload_event = CHOICE(name=u'event', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'XIRIEvent')))
    XIRIPayload._cont = ASN1Dict([
        (u'xIRIPayloadOID', _XIRIPayload_xIRIPayloadOID),
        (u'event', _XIRIPayload_event),
        ])
    XIRIPayload._ext = []
    
    #-----< XIRIEvent >-----#
    XIRIEvent = CHOICE(name=u'XIRIEvent', mode=MODE_TYPE)
    _XIRIEvent_registration = SEQ(name=u'registration', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'AMFRegistration')))
    _XIRIEvent_deregistration = SEQ(name=u'deregistration', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'AMFDeregistration')))
    _XIRIEvent_locationUpdate = SEQ(name=u'locationUpdate', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'AMFLocationUpdate')))
    _XIRIEvent_startOfInterceptionWithRegisteredUE = SEQ(name=u'startOfInterceptionWithRegisteredUE', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'AMFStartOfInterceptionWithRegisteredUE')))
    _XIRIEvent_unsuccessfulAMProcedure = SEQ(name=u'unsuccessfulAMProcedure', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'AMFUnsuccessfulProcedure')))
    _XIRIEvent_pDUSessionEstablishment = SEQ(name=u'pDUSessionEstablishment', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMFPDUSessionEstablishment')))
    _XIRIEvent_pDUSessionModification = SEQ(name=u'pDUSessionModification', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMFPDUSessionModification')))
    _XIRIEvent_pDUSessionRelease = SEQ(name=u'pDUSessionRelease', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMFPDUSessionRelease')))
    _XIRIEvent_startOfInterceptionWithEstablishedPDUSession = SEQ(name=u'startOfInterceptionWithEstablishedPDUSession', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMFStartOfInterceptionWithEstablishedPDUSession')))
    _XIRIEvent_unsuccessfulSMProcedure = SEQ(name=u'unsuccessfulSMProcedure', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMFUnsuccessfulProcedure')))
    _XIRIEvent_servingSystemMessage = SEQ(name=u'servingSystemMessage', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'UDMServingSystemMessage')))
    _XIRIEvent_sMSMessage = SEQ(name=u'sMSMessage', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMSMessage')))
    _XIRIEvent_lALSReport = SEQ(name=u'lALSReport', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'LALSReport')))
    _XIRIEvent_pDHeaderReport = SEQ(name=u'pDHeaderReport', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PDHeaderReport')))
    _XIRIEvent_pDSummaryReport = SEQ(name=u'pDSummaryReport', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PDSummaryReport')))
    _XIRIEvent_mMSSend = SEQ(name=u'mMSSend', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSSend')))
    _XIRIEvent_mMSSendByNonLocalTarget = SEQ(name=u'mMSSendByNonLocalTarget', mode=MODE_TYPE, tag=(18, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSSendByNonLocalTarget')))
    _XIRIEvent_mMSNotification = SEQ(name=u'mMSNotification', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSNotification')))
    _XIRIEvent_mMSSendToNonLocalTarget = SEQ(name=u'mMSSendToNonLocalTarget', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSSendToNonLocalTarget')))
    _XIRIEvent_mMSNotificationResponse = SEQ(name=u'mMSNotificationResponse', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSNotificationResponse')))
    _XIRIEvent_mMSRetrieval = SEQ(name=u'mMSRetrieval', mode=MODE_TYPE, tag=(22, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSRetrieval')))
    _XIRIEvent_mMSDeliveryAck = SEQ(name=u'mMSDeliveryAck', mode=MODE_TYPE, tag=(23, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSDeliveryAck')))
    _XIRIEvent_mMSForward = SEQ(name=u'mMSForward', mode=MODE_TYPE, tag=(24, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSForward')))
    _XIRIEvent_mMSDeleteFromRelay = SEQ(name=u'mMSDeleteFromRelay', mode=MODE_TYPE, tag=(25, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSDeleteFromRelay')))
    _XIRIEvent_mMSDeliveryReport = SEQ(name=u'mMSDeliveryReport', mode=MODE_TYPE, tag=(26, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSDeliveryReport')))
    _XIRIEvent_mMSDeliveryReportNonLocalTarget = SEQ(name=u'mMSDeliveryReportNonLocalTarget', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSDeliveryReportNonLocalTarget')))
    _XIRIEvent_mMSReadReport = SEQ(name=u'mMSReadReport', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSReadReport')))
    _XIRIEvent_mMSReadReportNonLocalTarget = SEQ(name=u'mMSReadReportNonLocalTarget', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSReadReportNonLocalTarget')))
    _XIRIEvent_mMSCancel = SEQ(name=u'mMSCancel', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSCancel')))
    _XIRIEvent_mMSMBoxStore = SEQ(name=u'mMSMBoxStore', mode=MODE_TYPE, tag=(31, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSMBoxStore')))
    _XIRIEvent_mMSMBoxUpload = SEQ(name=u'mMSMBoxUpload', mode=MODE_TYPE, tag=(32, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSMBoxUpload')))
    _XIRIEvent_mMSMBoxDelete = SEQ(name=u'mMSMBoxDelete', mode=MODE_TYPE, tag=(33, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSMBoxDelete')))
    _XIRIEvent_mMSMBoxViewRequest = SEQ(name=u'mMSMBoxViewRequest', mode=MODE_TYPE, tag=(34, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSMBoxViewRequest')))
    _XIRIEvent_mMSMBoxViewResponse = SEQ(name=u'mMSMBoxViewResponse', mode=MODE_TYPE, tag=(35, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSMBoxViewResponse')))
    _XIRIEvent_pTCRegistration = SEQ(name=u'pTCRegistration', mode=MODE_TYPE, tag=(36, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCRegistration')))
    _XIRIEvent_pTCSessionInitiation = SEQ(name=u'pTCSessionInitiation', mode=MODE_TYPE, tag=(37, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCSessionInitiation')))
    _XIRIEvent_pTCSessionAbandon = SEQ(name=u'pTCSessionAbandon', mode=MODE_TYPE, tag=(38, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCSessionAbandon')))
    _XIRIEvent_pTCSessionStart = SEQ(name=u'pTCSessionStart', mode=MODE_TYPE, tag=(39, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCSessionStart')))
    _XIRIEvent_pTCSessionEnd = SEQ(name=u'pTCSessionEnd', mode=MODE_TYPE, tag=(40, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCSessionEnd')))
    _XIRIEvent_pTCStartOfInterception = SEQ(name=u'pTCStartOfInterception', mode=MODE_TYPE, tag=(41, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCStartOfInterception')))
    _XIRIEvent_pTCPreEstablishedSession = SEQ(name=u'pTCPreEstablishedSession', mode=MODE_TYPE, tag=(42, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCPreEstablishedSession')))
    _XIRIEvent_pTCInstantPersonalAlert = SEQ(name=u'pTCInstantPersonalAlert', mode=MODE_TYPE, tag=(43, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCInstantPersonalAlert')))
    _XIRIEvent_pTCPartyJoin = SEQ(name=u'pTCPartyJoin', mode=MODE_TYPE, tag=(44, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCPartyJoin')))
    _XIRIEvent_pTCPartyDrop = SEQ(name=u'pTCPartyDrop', mode=MODE_TYPE, tag=(45, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCPartyDrop')))
    _XIRIEvent_pTCPartyHold = SEQ(name=u'pTCPartyHold', mode=MODE_TYPE, tag=(46, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCPartyHold')))
    _XIRIEvent_pTCMediaModification = SEQ(name=u'pTCMediaModification', mode=MODE_TYPE, tag=(47, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCMediaModification')))
    _XIRIEvent_pTCGroupAdvertisement = SEQ(name=u'pTCGroupAdvertisement', mode=MODE_TYPE, tag=(48, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCGroupAdvertisement')))
    _XIRIEvent_pTCFloorControl = SEQ(name=u'pTCFloorControl', mode=MODE_TYPE, tag=(49, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCFloorControl')))
    _XIRIEvent_pTCTargetPresence = SEQ(name=u'pTCTargetPresence', mode=MODE_TYPE, tag=(50, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCTargetPresence')))
    _XIRIEvent_pTCParticipantPresence = SEQ(name=u'pTCParticipantPresence', mode=MODE_TYPE, tag=(51, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCParticipantPresence')))
    _XIRIEvent_pTCListManagement = SEQ(name=u'pTCListManagement', mode=MODE_TYPE, tag=(52, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCListManagement')))
    _XIRIEvent_pTCAccessPolicy = SEQ(name=u'pTCAccessPolicy', mode=MODE_TYPE, tag=(53, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCAccessPolicy')))
    _XIRIEvent_subscriberRecordChangeMessage = SEQ(name=u'subscriberRecordChangeMessage', mode=MODE_TYPE, tag=(54, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'UDMSubscriberRecordChangeMessage')))
    _XIRIEvent_cancelLocationMessage = SEQ(name=u'cancelLocationMessage', mode=MODE_TYPE, tag=(55, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'UDMCancelLocationMessage')))
    _XIRIEvent_sMSReport = SEQ(name=u'sMSReport', mode=MODE_TYPE, tag=(56, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMSReport')))
    _XIRIEvent_sMFMAPDUSessionEstablishment = SEQ(name=u'sMFMAPDUSessionEstablishment', mode=MODE_TYPE, tag=(57, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMFMAPDUSessionEstablishment')))
    _XIRIEvent_sMFMAPDUSessionModification = SEQ(name=u'sMFMAPDUSessionModification', mode=MODE_TYPE, tag=(58, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMFMAPDUSessionModification')))
    _XIRIEvent_sMFMAPDUSessionRelease = SEQ(name=u'sMFMAPDUSessionRelease', mode=MODE_TYPE, tag=(59, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMFMAPDUSessionRelease')))
    _XIRIEvent_startOfInterceptionWithEstablishedMAPDUSession = SEQ(name=u'startOfInterceptionWithEstablishedMAPDUSession', mode=MODE_TYPE, tag=(60, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMFStartOfInterceptionWithEstablishedMAPDUSession')))
    _XIRIEvent_unsuccessfulMASMProcedure = SEQ(name=u'unsuccessfulMASMProcedure', mode=MODE_TYPE, tag=(61, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMFMAUnsuccessfulProcedure')))
    _XIRIEvent_aMFIdentifierAssocation = SEQ(name=u'aMFIdentifierAssocation', mode=MODE_TYPE, tag=(62, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'AMFIdentifierAssocation')))
    _XIRIEvent_mMEIdentifierAssocation = SEQ(name=u'mMEIdentifierAssocation', mode=MODE_TYPE, tag=(63, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMEIdentifierAssocation')))
    _XIRIEvent_sMFPDUtoMAPDUSessionModification = SEQ(name=u'sMFPDUtoMAPDUSessionModification', mode=MODE_TYPE, tag=(64, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMFPDUtoMAPDUSessionModification')))
    XIRIEvent._cont = ASN1Dict([
        (u'registration', _XIRIEvent_registration),
        (u'deregistration', _XIRIEvent_deregistration),
        (u'locationUpdate', _XIRIEvent_locationUpdate),
        (u'startOfInterceptionWithRegisteredUE', _XIRIEvent_startOfInterceptionWithRegisteredUE),
        (u'unsuccessfulAMProcedure', _XIRIEvent_unsuccessfulAMProcedure),
        (u'pDUSessionEstablishment', _XIRIEvent_pDUSessionEstablishment),
        (u'pDUSessionModification', _XIRIEvent_pDUSessionModification),
        (u'pDUSessionRelease', _XIRIEvent_pDUSessionRelease),
        (u'startOfInterceptionWithEstablishedPDUSession', _XIRIEvent_startOfInterceptionWithEstablishedPDUSession),
        (u'unsuccessfulSMProcedure', _XIRIEvent_unsuccessfulSMProcedure),
        (u'servingSystemMessage', _XIRIEvent_servingSystemMessage),
        (u'sMSMessage', _XIRIEvent_sMSMessage),
        (u'lALSReport', _XIRIEvent_lALSReport),
        (u'pDHeaderReport', _XIRIEvent_pDHeaderReport),
        (u'pDSummaryReport', _XIRIEvent_pDSummaryReport),
        (u'mMSSend', _XIRIEvent_mMSSend),
        (u'mMSSendByNonLocalTarget', _XIRIEvent_mMSSendByNonLocalTarget),
        (u'mMSNotification', _XIRIEvent_mMSNotification),
        (u'mMSSendToNonLocalTarget', _XIRIEvent_mMSSendToNonLocalTarget),
        (u'mMSNotificationResponse', _XIRIEvent_mMSNotificationResponse),
        (u'mMSRetrieval', _XIRIEvent_mMSRetrieval),
        (u'mMSDeliveryAck', _XIRIEvent_mMSDeliveryAck),
        (u'mMSForward', _XIRIEvent_mMSForward),
        (u'mMSDeleteFromRelay', _XIRIEvent_mMSDeleteFromRelay),
        (u'mMSDeliveryReport', _XIRIEvent_mMSDeliveryReport),
        (u'mMSDeliveryReportNonLocalTarget', _XIRIEvent_mMSDeliveryReportNonLocalTarget),
        (u'mMSReadReport', _XIRIEvent_mMSReadReport),
        (u'mMSReadReportNonLocalTarget', _XIRIEvent_mMSReadReportNonLocalTarget),
        (u'mMSCancel', _XIRIEvent_mMSCancel),
        (u'mMSMBoxStore', _XIRIEvent_mMSMBoxStore),
        (u'mMSMBoxUpload', _XIRIEvent_mMSMBoxUpload),
        (u'mMSMBoxDelete', _XIRIEvent_mMSMBoxDelete),
        (u'mMSMBoxViewRequest', _XIRIEvent_mMSMBoxViewRequest),
        (u'mMSMBoxViewResponse', _XIRIEvent_mMSMBoxViewResponse),
        (u'pTCRegistration', _XIRIEvent_pTCRegistration),
        (u'pTCSessionInitiation', _XIRIEvent_pTCSessionInitiation),
        (u'pTCSessionAbandon', _XIRIEvent_pTCSessionAbandon),
        (u'pTCSessionStart', _XIRIEvent_pTCSessionStart),
        (u'pTCSessionEnd', _XIRIEvent_pTCSessionEnd),
        (u'pTCStartOfInterception', _XIRIEvent_pTCStartOfInterception),
        (u'pTCPreEstablishedSession', _XIRIEvent_pTCPreEstablishedSession),
        (u'pTCInstantPersonalAlert', _XIRIEvent_pTCInstantPersonalAlert),
        (u'pTCPartyJoin', _XIRIEvent_pTCPartyJoin),
        (u'pTCPartyDrop', _XIRIEvent_pTCPartyDrop),
        (u'pTCPartyHold', _XIRIEvent_pTCPartyHold),
        (u'pTCMediaModification', _XIRIEvent_pTCMediaModification),
        (u'pTCGroupAdvertisement', _XIRIEvent_pTCGroupAdvertisement),
        (u'pTCFloorControl', _XIRIEvent_pTCFloorControl),
        (u'pTCTargetPresence', _XIRIEvent_pTCTargetPresence),
        (u'pTCParticipantPresence', _XIRIEvent_pTCParticipantPresence),
        (u'pTCListManagement', _XIRIEvent_pTCListManagement),
        (u'pTCAccessPolicy', _XIRIEvent_pTCAccessPolicy),
        (u'subscriberRecordChangeMessage', _XIRIEvent_subscriberRecordChangeMessage),
        (u'cancelLocationMessage', _XIRIEvent_cancelLocationMessage),
        (u'sMSReport', _XIRIEvent_sMSReport),
        (u'sMFMAPDUSessionEstablishment', _XIRIEvent_sMFMAPDUSessionEstablishment),
        (u'sMFMAPDUSessionModification', _XIRIEvent_sMFMAPDUSessionModification),
        (u'sMFMAPDUSessionRelease', _XIRIEvent_sMFMAPDUSessionRelease),
        (u'startOfInterceptionWithEstablishedMAPDUSession', _XIRIEvent_startOfInterceptionWithEstablishedMAPDUSession),
        (u'unsuccessfulMASMProcedure', _XIRIEvent_unsuccessfulMASMProcedure),
        (u'aMFIdentifierAssocation', _XIRIEvent_aMFIdentifierAssocation),
        (u'mMEIdentifierAssocation', _XIRIEvent_mMEIdentifierAssocation),
        (u'sMFPDUtoMAPDUSessionModification', _XIRIEvent_sMFPDUtoMAPDUSessionModification),
        ])
    XIRIEvent._ext = []
    
    #-----< IRIPayload >-----#
    IRIPayload = SEQ(name=u'IRIPayload', mode=MODE_TYPE)
    _IRIPayload_iRIPayloadOID = REL_OID(name=u'iRIPayloadOID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _IRIPayload_event = CHOICE(name=u'event', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'IRIEvent')))
    _IRIPayload_targetIdentifiers = SEQ_OF(name=u'targetIdentifiers', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __IRIPayload_targetIdentifiers__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'IRITargetIdentifier')))
    _IRIPayload_targetIdentifiers._cont = __IRIPayload_targetIdentifiers__item_
    IRIPayload._cont = ASN1Dict([
        (u'iRIPayloadOID', _IRIPayload_iRIPayloadOID),
        (u'event', _IRIPayload_event),
        (u'targetIdentifiers', _IRIPayload_targetIdentifiers),
        ])
    IRIPayload._ext = []
    
    #-----< IRIEvent >-----#
    IRIEvent = CHOICE(name=u'IRIEvent', mode=MODE_TYPE)
    _IRIEvent_registration = SEQ(name=u'registration', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'AMFRegistration')))
    _IRIEvent_deregistration = SEQ(name=u'deregistration', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'AMFDeregistration')))
    _IRIEvent_locationUpdate = SEQ(name=u'locationUpdate', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'AMFLocationUpdate')))
    _IRIEvent_startOfInterceptionWithRegisteredUE = SEQ(name=u'startOfInterceptionWithRegisteredUE', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'AMFStartOfInterceptionWithRegisteredUE')))
    _IRIEvent_unsuccessfulRegistrationProcedure = SEQ(name=u'unsuccessfulRegistrationProcedure', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'AMFUnsuccessfulProcedure')))
    _IRIEvent_pDUSessionEstablishment = SEQ(name=u'pDUSessionEstablishment', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMFPDUSessionEstablishment')))
    _IRIEvent_pDUSessionModification = SEQ(name=u'pDUSessionModification', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMFPDUSessionModification')))
    _IRIEvent_pDUSessionRelease = SEQ(name=u'pDUSessionRelease', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMFPDUSessionRelease')))
    _IRIEvent_startOfInterceptionWithEstablishedPDUSession = SEQ(name=u'startOfInterceptionWithEstablishedPDUSession', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMFStartOfInterceptionWithEstablishedPDUSession')))
    _IRIEvent_unsuccessfulSessionProcedure = SEQ(name=u'unsuccessfulSessionProcedure', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMFUnsuccessfulProcedure')))
    _IRIEvent_servingSystemMessage = SEQ(name=u'servingSystemMessage', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'UDMServingSystemMessage')))
    _IRIEvent_sMSMessage = SEQ(name=u'sMSMessage', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMSMessage')))
    _IRIEvent_lALSReport = SEQ(name=u'lALSReport', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'LALSReport')))
    _IRIEvent_pDHeaderReport = SEQ(name=u'pDHeaderReport', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PDHeaderReport')))
    _IRIEvent_pDSummaryReport = SEQ(name=u'pDSummaryReport', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PDSummaryReport')))
    _IRIEvent_mDFCellSiteReport = SEQ_OF(name=u'mDFCellSiteReport', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MDFCellSiteReport')))
    _IRIEvent_mMSSend = SEQ(name=u'mMSSend', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSSend')))
    _IRIEvent_mMSSendByNonLocalTarget = SEQ(name=u'mMSSendByNonLocalTarget', mode=MODE_TYPE, tag=(18, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSSendByNonLocalTarget')))
    _IRIEvent_mMSNotification = SEQ(name=u'mMSNotification', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSNotification')))
    _IRIEvent_mMSSendToNonLocalTarget = SEQ(name=u'mMSSendToNonLocalTarget', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSSendToNonLocalTarget')))
    _IRIEvent_mMSNotificationResponse = SEQ(name=u'mMSNotificationResponse', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSNotificationResponse')))
    _IRIEvent_mMSRetrieval = SEQ(name=u'mMSRetrieval', mode=MODE_TYPE, tag=(22, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSRetrieval')))
    _IRIEvent_mMSDeliveryAck = SEQ(name=u'mMSDeliveryAck', mode=MODE_TYPE, tag=(23, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSDeliveryAck')))
    _IRIEvent_mMSForward = SEQ(name=u'mMSForward', mode=MODE_TYPE, tag=(24, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSForward')))
    _IRIEvent_mMSDeleteFromRelay = SEQ(name=u'mMSDeleteFromRelay', mode=MODE_TYPE, tag=(25, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSDeleteFromRelay')))
    _IRIEvent_mMSDeliveryReport = SEQ(name=u'mMSDeliveryReport', mode=MODE_TYPE, tag=(26, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSDeliveryReport')))
    _IRIEvent_mMSDeliveryReportNonLocalTarget = SEQ(name=u'mMSDeliveryReportNonLocalTarget', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSDeliveryReportNonLocalTarget')))
    _IRIEvent_mMSReadReport = SEQ(name=u'mMSReadReport', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSReadReport')))
    _IRIEvent_mMSReadReportNonLocalTarget = SEQ(name=u'mMSReadReportNonLocalTarget', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSReadReportNonLocalTarget')))
    _IRIEvent_mMSCancel = SEQ(name=u'mMSCancel', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSCancel')))
    _IRIEvent_mMSMBoxStore = SEQ(name=u'mMSMBoxStore', mode=MODE_TYPE, tag=(31, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSMBoxStore')))
    _IRIEvent_mMSMBoxUpload = SEQ(name=u'mMSMBoxUpload', mode=MODE_TYPE, tag=(32, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSMBoxUpload')))
    _IRIEvent_mMSMBoxDelete = SEQ(name=u'mMSMBoxDelete', mode=MODE_TYPE, tag=(33, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSMBoxDelete')))
    _IRIEvent_mMSMBoxViewRequest = SEQ(name=u'mMSMBoxViewRequest', mode=MODE_TYPE, tag=(34, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSMBoxViewRequest')))
    _IRIEvent_mMSMBoxViewResponse = SEQ(name=u'mMSMBoxViewResponse', mode=MODE_TYPE, tag=(35, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSMBoxViewResponse')))
    _IRIEvent_pTCRegistration = SEQ(name=u'pTCRegistration', mode=MODE_TYPE, tag=(36, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCRegistration')))
    _IRIEvent_pTCSessionInitiation = SEQ(name=u'pTCSessionInitiation', mode=MODE_TYPE, tag=(37, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCSessionInitiation')))
    _IRIEvent_pTCSessionAbandon = SEQ(name=u'pTCSessionAbandon', mode=MODE_TYPE, tag=(38, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCSessionAbandon')))
    _IRIEvent_pTCSessionStart = SEQ(name=u'pTCSessionStart', mode=MODE_TYPE, tag=(39, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCSessionStart')))
    _IRIEvent_pTCSessionEnd = SEQ(name=u'pTCSessionEnd', mode=MODE_TYPE, tag=(40, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCSessionEnd')))
    _IRIEvent_pTCStartOfInterception = SEQ(name=u'pTCStartOfInterception', mode=MODE_TYPE, tag=(41, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCStartOfInterception')))
    _IRIEvent_pTCPreEstablishedSession = SEQ(name=u'pTCPreEstablishedSession', mode=MODE_TYPE, tag=(42, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCPreEstablishedSession')))
    _IRIEvent_pTCInstantPersonalAlert = SEQ(name=u'pTCInstantPersonalAlert', mode=MODE_TYPE, tag=(43, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCInstantPersonalAlert')))
    _IRIEvent_pTCPartyJoin = SEQ(name=u'pTCPartyJoin', mode=MODE_TYPE, tag=(44, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCPartyJoin')))
    _IRIEvent_pTCPartyDrop = SEQ(name=u'pTCPartyDrop', mode=MODE_TYPE, tag=(45, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCPartyDrop')))
    _IRIEvent_pTCPartyHold = SEQ(name=u'pTCPartyHold', mode=MODE_TYPE, tag=(46, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCPartyHold')))
    _IRIEvent_pTCMediaModification = SEQ(name=u'pTCMediaModification', mode=MODE_TYPE, tag=(47, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCMediaModification')))
    _IRIEvent_pTCGroupAdvertisement = SEQ(name=u'pTCGroupAdvertisement', mode=MODE_TYPE, tag=(48, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCGroupAdvertisement')))
    _IRIEvent_pTCFloorControl = SEQ(name=u'pTCFloorControl', mode=MODE_TYPE, tag=(49, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCFloorControl')))
    _IRIEvent_pTCTargetPresence = SEQ(name=u'pTCTargetPresence', mode=MODE_TYPE, tag=(50, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCTargetPresence')))
    _IRIEvent_pTCParticipantPresence = SEQ(name=u'pTCParticipantPresence', mode=MODE_TYPE, tag=(51, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCParticipantPresence')))
    _IRIEvent_pTCListManagement = SEQ(name=u'pTCListManagement', mode=MODE_TYPE, tag=(52, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCListManagement')))
    _IRIEvent_pTCAccessPolicy = SEQ(name=u'pTCAccessPolicy', mode=MODE_TYPE, tag=(53, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCAccessPolicy')))
    _IRIEvent_subscriberRecordChangeMessage = SEQ(name=u'subscriberRecordChangeMessage', mode=MODE_TYPE, tag=(54, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'UDMSubscriberRecordChangeMessage')))
    _IRIEvent_cancelLocationMessage = SEQ(name=u'cancelLocationMessage', mode=MODE_TYPE, tag=(55, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'UDMCancelLocationMessage')))
    _IRIEvent_sMSReport = SEQ(name=u'sMSReport', mode=MODE_TYPE, tag=(56, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMSReport')))
    _IRIEvent_sMFMAPDUSessionEstablishment = SEQ(name=u'sMFMAPDUSessionEstablishment', mode=MODE_TYPE, tag=(57, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMFMAPDUSessionEstablishment')))
    _IRIEvent_sMFMAPDUSessionModification = SEQ(name=u'sMFMAPDUSessionModification', mode=MODE_TYPE, tag=(58, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMFMAPDUSessionModification')))
    _IRIEvent_sMFMAPDUSessionRelease = SEQ(name=u'sMFMAPDUSessionRelease', mode=MODE_TYPE, tag=(59, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMFMAPDUSessionRelease')))
    _IRIEvent_startOfInterceptionWithEstablishedMAPDUSession = SEQ(name=u'startOfInterceptionWithEstablishedMAPDUSession', mode=MODE_TYPE, tag=(60, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMFStartOfInterceptionWithEstablishedMAPDUSession')))
    _IRIEvent_unsuccessfulMASMProcedure = SEQ(name=u'unsuccessfulMASMProcedure', mode=MODE_TYPE, tag=(61, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMFMAUnsuccessfulProcedure')))
    _IRIEvent_aMFIdentifierAssocation = SEQ(name=u'aMFIdentifierAssocation', mode=MODE_TYPE, tag=(62, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'AMFIdentifierAssocation')))
    _IRIEvent_mMEIdentifierAssocation = SEQ(name=u'mMEIdentifierAssocation', mode=MODE_TYPE, tag=(63, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMEIdentifierAssocation')))
    _IRIEvent_sMFPDUtoMAPDUSessionModification = SEQ(name=u'sMFPDUtoMAPDUSessionModification', mode=MODE_TYPE, tag=(64, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMFPDUtoMAPDUSessionModification')))
    IRIEvent._cont = ASN1Dict([
        (u'registration', _IRIEvent_registration),
        (u'deregistration', _IRIEvent_deregistration),
        (u'locationUpdate', _IRIEvent_locationUpdate),
        (u'startOfInterceptionWithRegisteredUE', _IRIEvent_startOfInterceptionWithRegisteredUE),
        (u'unsuccessfulRegistrationProcedure', _IRIEvent_unsuccessfulRegistrationProcedure),
        (u'pDUSessionEstablishment', _IRIEvent_pDUSessionEstablishment),
        (u'pDUSessionModification', _IRIEvent_pDUSessionModification),
        (u'pDUSessionRelease', _IRIEvent_pDUSessionRelease),
        (u'startOfInterceptionWithEstablishedPDUSession', _IRIEvent_startOfInterceptionWithEstablishedPDUSession),
        (u'unsuccessfulSessionProcedure', _IRIEvent_unsuccessfulSessionProcedure),
        (u'servingSystemMessage', _IRIEvent_servingSystemMessage),
        (u'sMSMessage', _IRIEvent_sMSMessage),
        (u'lALSReport', _IRIEvent_lALSReport),
        (u'pDHeaderReport', _IRIEvent_pDHeaderReport),
        (u'pDSummaryReport', _IRIEvent_pDSummaryReport),
        (u'mDFCellSiteReport', _IRIEvent_mDFCellSiteReport),
        (u'mMSSend', _IRIEvent_mMSSend),
        (u'mMSSendByNonLocalTarget', _IRIEvent_mMSSendByNonLocalTarget),
        (u'mMSNotification', _IRIEvent_mMSNotification),
        (u'mMSSendToNonLocalTarget', _IRIEvent_mMSSendToNonLocalTarget),
        (u'mMSNotificationResponse', _IRIEvent_mMSNotificationResponse),
        (u'mMSRetrieval', _IRIEvent_mMSRetrieval),
        (u'mMSDeliveryAck', _IRIEvent_mMSDeliveryAck),
        (u'mMSForward', _IRIEvent_mMSForward),
        (u'mMSDeleteFromRelay', _IRIEvent_mMSDeleteFromRelay),
        (u'mMSDeliveryReport', _IRIEvent_mMSDeliveryReport),
        (u'mMSDeliveryReportNonLocalTarget', _IRIEvent_mMSDeliveryReportNonLocalTarget),
        (u'mMSReadReport', _IRIEvent_mMSReadReport),
        (u'mMSReadReportNonLocalTarget', _IRIEvent_mMSReadReportNonLocalTarget),
        (u'mMSCancel', _IRIEvent_mMSCancel),
        (u'mMSMBoxStore', _IRIEvent_mMSMBoxStore),
        (u'mMSMBoxUpload', _IRIEvent_mMSMBoxUpload),
        (u'mMSMBoxDelete', _IRIEvent_mMSMBoxDelete),
        (u'mMSMBoxViewRequest', _IRIEvent_mMSMBoxViewRequest),
        (u'mMSMBoxViewResponse', _IRIEvent_mMSMBoxViewResponse),
        (u'pTCRegistration', _IRIEvent_pTCRegistration),
        (u'pTCSessionInitiation', _IRIEvent_pTCSessionInitiation),
        (u'pTCSessionAbandon', _IRIEvent_pTCSessionAbandon),
        (u'pTCSessionStart', _IRIEvent_pTCSessionStart),
        (u'pTCSessionEnd', _IRIEvent_pTCSessionEnd),
        (u'pTCStartOfInterception', _IRIEvent_pTCStartOfInterception),
        (u'pTCPreEstablishedSession', _IRIEvent_pTCPreEstablishedSession),
        (u'pTCInstantPersonalAlert', _IRIEvent_pTCInstantPersonalAlert),
        (u'pTCPartyJoin', _IRIEvent_pTCPartyJoin),
        (u'pTCPartyDrop', _IRIEvent_pTCPartyDrop),
        (u'pTCPartyHold', _IRIEvent_pTCPartyHold),
        (u'pTCMediaModification', _IRIEvent_pTCMediaModification),
        (u'pTCGroupAdvertisement', _IRIEvent_pTCGroupAdvertisement),
        (u'pTCFloorControl', _IRIEvent_pTCFloorControl),
        (u'pTCTargetPresence', _IRIEvent_pTCTargetPresence),
        (u'pTCParticipantPresence', _IRIEvent_pTCParticipantPresence),
        (u'pTCListManagement', _IRIEvent_pTCListManagement),
        (u'pTCAccessPolicy', _IRIEvent_pTCAccessPolicy),
        (u'subscriberRecordChangeMessage', _IRIEvent_subscriberRecordChangeMessage),
        (u'cancelLocationMessage', _IRIEvent_cancelLocationMessage),
        (u'sMSReport', _IRIEvent_sMSReport),
        (u'sMFMAPDUSessionEstablishment', _IRIEvent_sMFMAPDUSessionEstablishment),
        (u'sMFMAPDUSessionModification', _IRIEvent_sMFMAPDUSessionModification),
        (u'sMFMAPDUSessionRelease', _IRIEvent_sMFMAPDUSessionRelease),
        (u'startOfInterceptionWithEstablishedMAPDUSession', _IRIEvent_startOfInterceptionWithEstablishedMAPDUSession),
        (u'unsuccessfulMASMProcedure', _IRIEvent_unsuccessfulMASMProcedure),
        (u'aMFIdentifierAssocation', _IRIEvent_aMFIdentifierAssocation),
        (u'mMEIdentifierAssocation', _IRIEvent_mMEIdentifierAssocation),
        (u'sMFPDUtoMAPDUSessionModification', _IRIEvent_sMFPDUtoMAPDUSessionModification),
        ])
    IRIEvent._ext = []
    
    #-----< IRITargetIdentifier >-----#
    IRITargetIdentifier = SEQ(name=u'IRITargetIdentifier', mode=MODE_TYPE)
    _IRITargetIdentifier_identifier = CHOICE(name=u'identifier', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'TargetIdentifier')))
    _IRITargetIdentifier_provenance = ENUM(name=u'provenance', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'TargetIdentifierProvenance')), opt=True)
    IRITargetIdentifier._cont = ASN1Dict([
        (u'identifier', _IRITargetIdentifier_identifier),
        (u'provenance', _IRITargetIdentifier_provenance),
        ])
    IRITargetIdentifier._ext = []
    
    #-----< CCPayload >-----#
    CCPayload = SEQ(name=u'CCPayload', mode=MODE_TYPE)
    _CCPayload_cCPayloadOID = REL_OID(name=u'cCPayloadOID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _CCPayload_pDU = CHOICE(name=u'pDU', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'CCPDU')))
    CCPayload._cont = ASN1Dict([
        (u'cCPayloadOID', _CCPayload_cCPayloadOID),
        (u'pDU', _CCPayload_pDU),
        ])
    CCPayload._ext = []
    
    #-----< CCPDU >-----#
    CCPDU = CHOICE(name=u'CCPDU', mode=MODE_TYPE)
    _CCPDU_uPFCCPDU = OCT_STR(name=u'uPFCCPDU', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'UPFCCPDU')))
    _CCPDU_extendedUPFCCPDU = SEQ(name=u'extendedUPFCCPDU', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'ExtendedUPFCCPDU')))
    _CCPDU_mMSCCPDU = SEQ(name=u'mMSCCPDU', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSCCPDU')))
    CCPDU._cont = ASN1Dict([
        (u'uPFCCPDU', _CCPDU_uPFCCPDU),
        (u'extendedUPFCCPDU', _CCPDU_extendedUPFCCPDU),
        (u'mMSCCPDU', _CCPDU_mMSCCPDU),
        ])
    CCPDU._ext = []
    
    #-----< LINotificationPayload >-----#
    LINotificationPayload = SEQ(name=u'LINotificationPayload', mode=MODE_TYPE)
    _LINotificationPayload_lINotificationPayloadOID = REL_OID(name=u'lINotificationPayloadOID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _LINotificationPayload_notification = CHOICE(name=u'notification', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'LINotificationMessage')))
    LINotificationPayload._cont = ASN1Dict([
        (u'lINotificationPayloadOID', _LINotificationPayload_lINotificationPayloadOID),
        (u'notification', _LINotificationPayload_notification),
        ])
    LINotificationPayload._ext = []
    
    #-----< LINotificationMessage >-----#
    LINotificationMessage = CHOICE(name=u'LINotificationMessage', mode=MODE_TYPE)
    _LINotificationMessage_lINotification = SEQ(name=u'lINotification', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'LINotification')))
    LINotificationMessage._cont = ASN1Dict([
        (u'lINotification', _LINotificationMessage_lINotification),
        ])
    LINotificationMessage._ext = []
    
    #-----< AMFRegistration >-----#
    AMFRegistration = SEQ(name=u'AMFRegistration', mode=MODE_TYPE)
    _AMFRegistration_registrationType = ENUM(name=u'registrationType', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'AMFRegistrationType')))
    _AMFRegistration_registrationResult = ENUM(name=u'registrationResult', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'AMFRegistrationResult')))
    _AMFRegistration_slice = SEQ(name=u'slice', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Slice')), opt=True)
    _AMFRegistration_sUPI = CHOICE(name=u'sUPI', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SUPI')))
    _AMFRegistration_sUCI = SEQ(name=u'sUCI', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SUCI')), opt=True)
    _AMFRegistration_pEI = CHOICE(name=u'pEI', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PEI')), opt=True)
    _AMFRegistration_gPSI = CHOICE(name=u'gPSI', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'GPSI')), opt=True)
    _AMFRegistration_gUTI = SEQ(name=u'gUTI', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'FiveGGUTI')))
    _AMFRegistration_location = SEQ(name=u'location', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Location')), opt=True)
    _AMFRegistration_non3GPPAccessEndpoint = CHOICE(name=u'non3GPPAccessEndpoint', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'UEEndpointAddress')), opt=True)
    _AMFRegistration_fiveGSTAIList = SEQ_OF(name=u'fiveGSTAIList', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'TAIList')), opt=True)
    AMFRegistration._cont = ASN1Dict([
        (u'registrationType', _AMFRegistration_registrationType),
        (u'registrationResult', _AMFRegistration_registrationResult),
        (u'slice', _AMFRegistration_slice),
        (u'sUPI', _AMFRegistration_sUPI),
        (u'sUCI', _AMFRegistration_sUCI),
        (u'pEI', _AMFRegistration_pEI),
        (u'gPSI', _AMFRegistration_gPSI),
        (u'gUTI', _AMFRegistration_gUTI),
        (u'location', _AMFRegistration_location),
        (u'non3GPPAccessEndpoint', _AMFRegistration_non3GPPAccessEndpoint),
        (u'fiveGSTAIList', _AMFRegistration_fiveGSTAIList),
        ])
    AMFRegistration._ext = []
    
    #-----< AMFDeregistration >-----#
    AMFDeregistration = SEQ(name=u'AMFDeregistration', mode=MODE_TYPE)
    _AMFDeregistration_deregistrationDirection = ENUM(name=u'deregistrationDirection', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'AMFDirection')))
    _AMFDeregistration_accessType = ENUM(name=u'accessType', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'AccessType')))
    _AMFDeregistration_sUPI = CHOICE(name=u'sUPI', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SUPI')), opt=True)
    _AMFDeregistration_sUCI = SEQ(name=u'sUCI', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SUCI')), opt=True)
    _AMFDeregistration_pEI = CHOICE(name=u'pEI', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PEI')), opt=True)
    _AMFDeregistration_gPSI = CHOICE(name=u'gPSI', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'GPSI')), opt=True)
    _AMFDeregistration_gUTI = SEQ(name=u'gUTI', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'FiveGGUTI')), opt=True)
    _AMFDeregistration_cause = INT(name=u'cause', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'FiveGMMCause')), opt=True)
    _AMFDeregistration_location = SEQ(name=u'location', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Location')), opt=True)
    AMFDeregistration._cont = ASN1Dict([
        (u'deregistrationDirection', _AMFDeregistration_deregistrationDirection),
        (u'accessType', _AMFDeregistration_accessType),
        (u'sUPI', _AMFDeregistration_sUPI),
        (u'sUCI', _AMFDeregistration_sUCI),
        (u'pEI', _AMFDeregistration_pEI),
        (u'gPSI', _AMFDeregistration_gPSI),
        (u'gUTI', _AMFDeregistration_gUTI),
        (u'cause', _AMFDeregistration_cause),
        (u'location', _AMFDeregistration_location),
        ])
    AMFDeregistration._ext = []
    
    #-----< AMFLocationUpdate >-----#
    AMFLocationUpdate = SEQ(name=u'AMFLocationUpdate', mode=MODE_TYPE)
    _AMFLocationUpdate_sUPI = CHOICE(name=u'sUPI', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SUPI')))
    _AMFLocationUpdate_sUCI = SEQ(name=u'sUCI', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SUCI')), opt=True)
    _AMFLocationUpdate_pEI = CHOICE(name=u'pEI', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PEI')), opt=True)
    _AMFLocationUpdate_gPSI = CHOICE(name=u'gPSI', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'GPSI')), opt=True)
    _AMFLocationUpdate_gUTI = SEQ(name=u'gUTI', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'FiveGGUTI')), opt=True)
    _AMFLocationUpdate_location = SEQ(name=u'location', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Location')))
    AMFLocationUpdate._cont = ASN1Dict([
        (u'sUPI', _AMFLocationUpdate_sUPI),
        (u'sUCI', _AMFLocationUpdate_sUCI),
        (u'pEI', _AMFLocationUpdate_pEI),
        (u'gPSI', _AMFLocationUpdate_gPSI),
        (u'gUTI', _AMFLocationUpdate_gUTI),
        (u'location', _AMFLocationUpdate_location),
        ])
    AMFLocationUpdate._ext = []
    
    #-----< AMFStartOfInterceptionWithRegisteredUE >-----#
    AMFStartOfInterceptionWithRegisteredUE = SEQ(name=u'AMFStartOfInterceptionWithRegisteredUE', mode=MODE_TYPE)
    _AMFStartOfInterceptionWithRegisteredUE_registrationResult = ENUM(name=u'registrationResult', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'AMFRegistrationResult')))
    _AMFStartOfInterceptionWithRegisteredUE_registrationType = ENUM(name=u'registrationType', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'AMFRegistrationType')), opt=True)
    _AMFStartOfInterceptionWithRegisteredUE_slice = SEQ(name=u'slice', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Slice')), opt=True)
    _AMFStartOfInterceptionWithRegisteredUE_sUPI = CHOICE(name=u'sUPI', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SUPI')))
    _AMFStartOfInterceptionWithRegisteredUE_sUCI = SEQ(name=u'sUCI', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SUCI')), opt=True)
    _AMFStartOfInterceptionWithRegisteredUE_pEI = CHOICE(name=u'pEI', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PEI')), opt=True)
    _AMFStartOfInterceptionWithRegisteredUE_gPSI = CHOICE(name=u'gPSI', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'GPSI')), opt=True)
    _AMFStartOfInterceptionWithRegisteredUE_gUTI = SEQ(name=u'gUTI', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'FiveGGUTI')))
    _AMFStartOfInterceptionWithRegisteredUE_location = SEQ(name=u'location', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Location')), opt=True)
    _AMFStartOfInterceptionWithRegisteredUE_non3GPPAccessEndpoint = CHOICE(name=u'non3GPPAccessEndpoint', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'UEEndpointAddress')), opt=True)
    _AMFStartOfInterceptionWithRegisteredUE_timeOfRegistration = TIME_GEN(name=u'timeOfRegistration', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Timestamp')), opt=True)
    _AMFStartOfInterceptionWithRegisteredUE_fiveGSTAIList = SEQ_OF(name=u'fiveGSTAIList', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'TAIList')), opt=True)
    AMFStartOfInterceptionWithRegisteredUE._cont = ASN1Dict([
        (u'registrationResult', _AMFStartOfInterceptionWithRegisteredUE_registrationResult),
        (u'registrationType', _AMFStartOfInterceptionWithRegisteredUE_registrationType),
        (u'slice', _AMFStartOfInterceptionWithRegisteredUE_slice),
        (u'sUPI', _AMFStartOfInterceptionWithRegisteredUE_sUPI),
        (u'sUCI', _AMFStartOfInterceptionWithRegisteredUE_sUCI),
        (u'pEI', _AMFStartOfInterceptionWithRegisteredUE_pEI),
        (u'gPSI', _AMFStartOfInterceptionWithRegisteredUE_gPSI),
        (u'gUTI', _AMFStartOfInterceptionWithRegisteredUE_gUTI),
        (u'location', _AMFStartOfInterceptionWithRegisteredUE_location),
        (u'non3GPPAccessEndpoint', _AMFStartOfInterceptionWithRegisteredUE_non3GPPAccessEndpoint),
        (u'timeOfRegistration', _AMFStartOfInterceptionWithRegisteredUE_timeOfRegistration),
        (u'fiveGSTAIList', _AMFStartOfInterceptionWithRegisteredUE_fiveGSTAIList),
        ])
    AMFStartOfInterceptionWithRegisteredUE._ext = []
    
    #-----< AMFUnsuccessfulProcedure >-----#
    AMFUnsuccessfulProcedure = SEQ(name=u'AMFUnsuccessfulProcedure', mode=MODE_TYPE)
    _AMFUnsuccessfulProcedure_failedProcedureType = ENUM(name=u'failedProcedureType', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'AMFFailedProcedureType')))
    _AMFUnsuccessfulProcedure_failureCause = CHOICE(name=u'failureCause', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'AMFFailureCause')))
    _AMFUnsuccessfulProcedure_requestedSlice = SEQ_OF(name=u'requestedSlice', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'NSSAI')), opt=True)
    _AMFUnsuccessfulProcedure_sUPI = CHOICE(name=u'sUPI', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SUPI')), opt=True)
    _AMFUnsuccessfulProcedure_sUCI = SEQ(name=u'sUCI', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SUCI')), opt=True)
    _AMFUnsuccessfulProcedure_pEI = CHOICE(name=u'pEI', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PEI')), opt=True)
    _AMFUnsuccessfulProcedure_gPSI = CHOICE(name=u'gPSI', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'GPSI')), opt=True)
    _AMFUnsuccessfulProcedure_gUTI = SEQ(name=u'gUTI', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'FiveGGUTI')), opt=True)
    _AMFUnsuccessfulProcedure_location = SEQ(name=u'location', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Location')), opt=True)
    AMFUnsuccessfulProcedure._cont = ASN1Dict([
        (u'failedProcedureType', _AMFUnsuccessfulProcedure_failedProcedureType),
        (u'failureCause', _AMFUnsuccessfulProcedure_failureCause),
        (u'requestedSlice', _AMFUnsuccessfulProcedure_requestedSlice),
        (u'sUPI', _AMFUnsuccessfulProcedure_sUPI),
        (u'sUCI', _AMFUnsuccessfulProcedure_sUCI),
        (u'pEI', _AMFUnsuccessfulProcedure_pEI),
        (u'gPSI', _AMFUnsuccessfulProcedure_gPSI),
        (u'gUTI', _AMFUnsuccessfulProcedure_gUTI),
        (u'location', _AMFUnsuccessfulProcedure_location),
        ])
    AMFUnsuccessfulProcedure._ext = []
    
    #-----< AMFID >-----#
    AMFID = SEQ(name=u'AMFID', mode=MODE_TYPE)
    _AMFID_aMFRegionID = INT(name=u'aMFRegionID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'AMFRegionID')))
    _AMFID_aMFSetID = INT(name=u'aMFSetID', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'AMFSetID')))
    _AMFID_aMFPointer = INT(name=u'aMFPointer', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'AMFPointer')))
    AMFID._cont = ASN1Dict([
        (u'aMFRegionID', _AMFID_aMFRegionID),
        (u'aMFSetID', _AMFID_aMFSetID),
        (u'aMFPointer', _AMFID_aMFPointer),
        ])
    AMFID._ext = []
    
    #-----< AMFDirection >-----#
    AMFDirection = ENUM(name=u'AMFDirection', mode=MODE_TYPE)
    AMFDirection._cont = ASN1Dict([(u'networkInitiated', 1), (u'uEInitiated', 2)])
    AMFDirection._ext = []
    
    #-----< AMFFailedProcedureType >-----#
    AMFFailedProcedureType = ENUM(name=u'AMFFailedProcedureType', mode=MODE_TYPE)
    AMFFailedProcedureType._cont = ASN1Dict([(u'registration', 1), (u'sMS', 2), (u'pDUSessionEstablishment', 3)])
    AMFFailedProcedureType._ext = []
    
    #-----< AMFFailureCause >-----#
    AMFFailureCause = CHOICE(name=u'AMFFailureCause', mode=MODE_TYPE)
    _AMFFailureCause_fiveGMMCause = INT(name=u'fiveGMMCause', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'FiveGMMCause')))
    _AMFFailureCause_fiveGSMCause = INT(name=u'fiveGSMCause', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'FiveGSMCause')))
    AMFFailureCause._cont = ASN1Dict([
        (u'fiveGMMCause', _AMFFailureCause_fiveGMMCause),
        (u'fiveGSMCause', _AMFFailureCause_fiveGSMCause),
        ])
    AMFFailureCause._ext = []
    
    #-----< AMFPointer >-----#
    AMFPointer = INT(name=u'AMFPointer', mode=MODE_TYPE)
    AMFPointer._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    
    #-----< AMFRegistrationResult >-----#
    AMFRegistrationResult = ENUM(name=u'AMFRegistrationResult', mode=MODE_TYPE)
    AMFRegistrationResult._cont = ASN1Dict([(u'threeGPPAccess', 1), (u'nonThreeGPPAccess', 2), (u'threeGPPAndNonThreeGPPAccess', 3)])
    AMFRegistrationResult._ext = []
    
    #-----< AMFRegionID >-----#
    AMFRegionID = INT(name=u'AMFRegionID', mode=MODE_TYPE)
    AMFRegionID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    
    #-----< AMFRegistrationType >-----#
    AMFRegistrationType = ENUM(name=u'AMFRegistrationType', mode=MODE_TYPE)
    AMFRegistrationType._cont = ASN1Dict([(u'initial', 1), (u'mobility', 2), (u'periodic', 3), (u'emergency', 4)])
    AMFRegistrationType._ext = []
    
    #-----< AMFSetID >-----#
    AMFSetID = INT(name=u'AMFSetID', mode=MODE_TYPE)
    AMFSetID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=1023)], ev=None, er=[])
    
    #-----< SMFPDUSessionEstablishment >-----#
    SMFPDUSessionEstablishment = SEQ(name=u'SMFPDUSessionEstablishment', mode=MODE_TYPE)
    _SMFPDUSessionEstablishment_sUPI = CHOICE(name=u'sUPI', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SUPI')), opt=True)
    _SMFPDUSessionEstablishment_sUPIUnauthenticated = BOOL(name=u'sUPIUnauthenticated', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SUPIUnauthenticatedIndication')), opt=True)
    _SMFPDUSessionEstablishment_pEI = CHOICE(name=u'pEI', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PEI')), opt=True)
    _SMFPDUSessionEstablishment_gPSI = CHOICE(name=u'gPSI', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'GPSI')), opt=True)
    _SMFPDUSessionEstablishment_pDUSessionID = INT(name=u'pDUSessionID', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PDUSessionID')))
    _SMFPDUSessionEstablishment_gTPTunnelID = SEQ(name=u'gTPTunnelID', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'FTEID')))
    _SMFPDUSessionEstablishment_pDUSessionType = ENUM(name=u'pDUSessionType', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PDUSessionType')))
    _SMFPDUSessionEstablishment_sNSSAI = SEQ(name=u'sNSSAI', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SNSSAI')), opt=True)
    _SMFPDUSessionEstablishment_uEEndpoint = SEQ_OF(name=u'uEEndpoint', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __SMFPDUSessionEstablishment_uEEndpoint__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'UEEndpointAddress')))
    _SMFPDUSessionEstablishment_uEEndpoint._cont = __SMFPDUSessionEstablishment_uEEndpoint__item_
    _SMFPDUSessionEstablishment_non3GPPAccessEndpoint = CHOICE(name=u'non3GPPAccessEndpoint', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'UEEndpointAddress')), opt=True)
    _SMFPDUSessionEstablishment_location = SEQ(name=u'location', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Location')), opt=True)
    _SMFPDUSessionEstablishment_dNN = STR_UTF8(name=u'dNN', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'DNN')))
    _SMFPDUSessionEstablishment_aMFID = SEQ(name=u'aMFID', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'AMFID')), opt=True)
    _SMFPDUSessionEstablishment_hSMFURI = STR_UTF8(name=u'hSMFURI', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'HSMFURI')), opt=True)
    _SMFPDUSessionEstablishment_requestType = ENUM(name=u'requestType', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'FiveGSMRequestType')))
    _SMFPDUSessionEstablishment_accessType = ENUM(name=u'accessType', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'AccessType')), opt=True)
    _SMFPDUSessionEstablishment_rATType = ENUM(name=u'rATType', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'RATType')), opt=True)
    _SMFPDUSessionEstablishment_sMPDUDNRequest = OCT_STR(name=u'sMPDUDNRequest', mode=MODE_TYPE, tag=(18, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMPDUDNRequest')), opt=True)
    _SMFPDUSessionEstablishment_uEEPSPDNConnection = OCT_STR(name=u'uEEPSPDNConnection', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'UEEPSPDNConnection')), opt=True)
    SMFPDUSessionEstablishment._cont = ASN1Dict([
        (u'sUPI', _SMFPDUSessionEstablishment_sUPI),
        (u'sUPIUnauthenticated', _SMFPDUSessionEstablishment_sUPIUnauthenticated),
        (u'pEI', _SMFPDUSessionEstablishment_pEI),
        (u'gPSI', _SMFPDUSessionEstablishment_gPSI),
        (u'pDUSessionID', _SMFPDUSessionEstablishment_pDUSessionID),
        (u'gTPTunnelID', _SMFPDUSessionEstablishment_gTPTunnelID),
        (u'pDUSessionType', _SMFPDUSessionEstablishment_pDUSessionType),
        (u'sNSSAI', _SMFPDUSessionEstablishment_sNSSAI),
        (u'uEEndpoint', _SMFPDUSessionEstablishment_uEEndpoint),
        (u'non3GPPAccessEndpoint', _SMFPDUSessionEstablishment_non3GPPAccessEndpoint),
        (u'location', _SMFPDUSessionEstablishment_location),
        (u'dNN', _SMFPDUSessionEstablishment_dNN),
        (u'aMFID', _SMFPDUSessionEstablishment_aMFID),
        (u'hSMFURI', _SMFPDUSessionEstablishment_hSMFURI),
        (u'requestType', _SMFPDUSessionEstablishment_requestType),
        (u'accessType', _SMFPDUSessionEstablishment_accessType),
        (u'rATType', _SMFPDUSessionEstablishment_rATType),
        (u'sMPDUDNRequest', _SMFPDUSessionEstablishment_sMPDUDNRequest),
        (u'uEEPSPDNConnection', _SMFPDUSessionEstablishment_uEEPSPDNConnection),
        ])
    SMFPDUSessionEstablishment._ext = []
    
    #-----< SMFPDUSessionModification >-----#
    SMFPDUSessionModification = SEQ(name=u'SMFPDUSessionModification', mode=MODE_TYPE)
    _SMFPDUSessionModification_sUPI = CHOICE(name=u'sUPI', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SUPI')), opt=True)
    _SMFPDUSessionModification_sUPIUnauthenticated = BOOL(name=u'sUPIUnauthenticated', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SUPIUnauthenticatedIndication')), opt=True)
    _SMFPDUSessionModification_pEI = CHOICE(name=u'pEI', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PEI')), opt=True)
    _SMFPDUSessionModification_gPSI = CHOICE(name=u'gPSI', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'GPSI')), opt=True)
    _SMFPDUSessionModification_sNSSAI = SEQ(name=u'sNSSAI', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SNSSAI')), opt=True)
    _SMFPDUSessionModification_non3GPPAccessEndpoint = CHOICE(name=u'non3GPPAccessEndpoint', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'UEEndpointAddress')), opt=True)
    _SMFPDUSessionModification_location = SEQ(name=u'location', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Location')), opt=True)
    _SMFPDUSessionModification_requestType = ENUM(name=u'requestType', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'FiveGSMRequestType')))
    _SMFPDUSessionModification_accessType = ENUM(name=u'accessType', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'AccessType')), opt=True)
    _SMFPDUSessionModification_rATType = ENUM(name=u'rATType', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'RATType')), opt=True)
    _SMFPDUSessionModification_pDUSessionID = INT(name=u'pDUSessionID', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PDUSessionID')), opt=True)
    SMFPDUSessionModification._cont = ASN1Dict([
        (u'sUPI', _SMFPDUSessionModification_sUPI),
        (u'sUPIUnauthenticated', _SMFPDUSessionModification_sUPIUnauthenticated),
        (u'pEI', _SMFPDUSessionModification_pEI),
        (u'gPSI', _SMFPDUSessionModification_gPSI),
        (u'sNSSAI', _SMFPDUSessionModification_sNSSAI),
        (u'non3GPPAccessEndpoint', _SMFPDUSessionModification_non3GPPAccessEndpoint),
        (u'location', _SMFPDUSessionModification_location),
        (u'requestType', _SMFPDUSessionModification_requestType),
        (u'accessType', _SMFPDUSessionModification_accessType),
        (u'rATType', _SMFPDUSessionModification_rATType),
        (u'pDUSessionID', _SMFPDUSessionModification_pDUSessionID),
        ])
    SMFPDUSessionModification._ext = []
    
    #-----< SMFPDUSessionRelease >-----#
    SMFPDUSessionRelease = SEQ(name=u'SMFPDUSessionRelease', mode=MODE_TYPE)
    _SMFPDUSessionRelease_sUPI = CHOICE(name=u'sUPI', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SUPI')))
    _SMFPDUSessionRelease_pEI = CHOICE(name=u'pEI', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PEI')), opt=True)
    _SMFPDUSessionRelease_gPSI = CHOICE(name=u'gPSI', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'GPSI')), opt=True)
    _SMFPDUSessionRelease_pDUSessionID = INT(name=u'pDUSessionID', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PDUSessionID')))
    _SMFPDUSessionRelease_timeOfFirstPacket = TIME_GEN(name=u'timeOfFirstPacket', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Timestamp')), opt=True)
    _SMFPDUSessionRelease_timeOfLastPacket = TIME_GEN(name=u'timeOfLastPacket', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Timestamp')), opt=True)
    _SMFPDUSessionRelease_uplinkVolume = INT(name=u'uplinkVolume', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _SMFPDUSessionRelease_downlinkVolume = INT(name=u'downlinkVolume', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _SMFPDUSessionRelease_location = SEQ(name=u'location', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Location')), opt=True)
    _SMFPDUSessionRelease_cause = STR_UTF8(name=u'cause', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMFErrorCodes')), opt=True)
    SMFPDUSessionRelease._cont = ASN1Dict([
        (u'sUPI', _SMFPDUSessionRelease_sUPI),
        (u'pEI', _SMFPDUSessionRelease_pEI),
        (u'gPSI', _SMFPDUSessionRelease_gPSI),
        (u'pDUSessionID', _SMFPDUSessionRelease_pDUSessionID),
        (u'timeOfFirstPacket', _SMFPDUSessionRelease_timeOfFirstPacket),
        (u'timeOfLastPacket', _SMFPDUSessionRelease_timeOfLastPacket),
        (u'uplinkVolume', _SMFPDUSessionRelease_uplinkVolume),
        (u'downlinkVolume', _SMFPDUSessionRelease_downlinkVolume),
        (u'location', _SMFPDUSessionRelease_location),
        (u'cause', _SMFPDUSessionRelease_cause),
        ])
    SMFPDUSessionRelease._ext = []
    
    #-----< SMFStartOfInterceptionWithEstablishedPDUSession >-----#
    SMFStartOfInterceptionWithEstablishedPDUSession = SEQ(name=u'SMFStartOfInterceptionWithEstablishedPDUSession', mode=MODE_TYPE)
    _SMFStartOfInterceptionWithEstablishedPDUSession_sUPI = CHOICE(name=u'sUPI', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SUPI')), opt=True)
    _SMFStartOfInterceptionWithEstablishedPDUSession_sUPIUnauthenticated = BOOL(name=u'sUPIUnauthenticated', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SUPIUnauthenticatedIndication')), opt=True)
    _SMFStartOfInterceptionWithEstablishedPDUSession_pEI = CHOICE(name=u'pEI', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PEI')), opt=True)
    _SMFStartOfInterceptionWithEstablishedPDUSession_gPSI = CHOICE(name=u'gPSI', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'GPSI')), opt=True)
    _SMFStartOfInterceptionWithEstablishedPDUSession_pDUSessionID = INT(name=u'pDUSessionID', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PDUSessionID')))
    _SMFStartOfInterceptionWithEstablishedPDUSession_gTPTunnelID = SEQ(name=u'gTPTunnelID', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'FTEID')))
    _SMFStartOfInterceptionWithEstablishedPDUSession_pDUSessionType = ENUM(name=u'pDUSessionType', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PDUSessionType')))
    _SMFStartOfInterceptionWithEstablishedPDUSession_sNSSAI = SEQ(name=u'sNSSAI', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SNSSAI')), opt=True)
    _SMFStartOfInterceptionWithEstablishedPDUSession_uEEndpoint = SEQ_OF(name=u'uEEndpoint', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __SMFStartOfInterceptionWithEstablishedPDUSession_uEEndpoint__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'UEEndpointAddress')))
    _SMFStartOfInterceptionWithEstablishedPDUSession_uEEndpoint._cont = __SMFStartOfInterceptionWithEstablishedPDUSession_uEEndpoint__item_
    _SMFStartOfInterceptionWithEstablishedPDUSession_non3GPPAccessEndpoint = CHOICE(name=u'non3GPPAccessEndpoint', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'UEEndpointAddress')), opt=True)
    _SMFStartOfInterceptionWithEstablishedPDUSession_location = SEQ(name=u'location', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Location')), opt=True)
    _SMFStartOfInterceptionWithEstablishedPDUSession_dNN = STR_UTF8(name=u'dNN', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'DNN')))
    _SMFStartOfInterceptionWithEstablishedPDUSession_aMFID = SEQ(name=u'aMFID', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'AMFID')), opt=True)
    _SMFStartOfInterceptionWithEstablishedPDUSession_hSMFURI = STR_UTF8(name=u'hSMFURI', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'HSMFURI')), opt=True)
    _SMFStartOfInterceptionWithEstablishedPDUSession_requestType = ENUM(name=u'requestType', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'FiveGSMRequestType')))
    _SMFStartOfInterceptionWithEstablishedPDUSession_accessType = ENUM(name=u'accessType', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'AccessType')), opt=True)
    _SMFStartOfInterceptionWithEstablishedPDUSession_rATType = ENUM(name=u'rATType', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'RATType')), opt=True)
    _SMFStartOfInterceptionWithEstablishedPDUSession_sMPDUDNRequest = OCT_STR(name=u'sMPDUDNRequest', mode=MODE_TYPE, tag=(18, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMPDUDNRequest')), opt=True)
    _SMFStartOfInterceptionWithEstablishedPDUSession_timeOfSessionEstablishment = TIME_GEN(name=u'timeOfSessionEstablishment', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Timestamp')), opt=True)
    SMFStartOfInterceptionWithEstablishedPDUSession._cont = ASN1Dict([
        (u'sUPI', _SMFStartOfInterceptionWithEstablishedPDUSession_sUPI),
        (u'sUPIUnauthenticated', _SMFStartOfInterceptionWithEstablishedPDUSession_sUPIUnauthenticated),
        (u'pEI', _SMFStartOfInterceptionWithEstablishedPDUSession_pEI),
        (u'gPSI', _SMFStartOfInterceptionWithEstablishedPDUSession_gPSI),
        (u'pDUSessionID', _SMFStartOfInterceptionWithEstablishedPDUSession_pDUSessionID),
        (u'gTPTunnelID', _SMFStartOfInterceptionWithEstablishedPDUSession_gTPTunnelID),
        (u'pDUSessionType', _SMFStartOfInterceptionWithEstablishedPDUSession_pDUSessionType),
        (u'sNSSAI', _SMFStartOfInterceptionWithEstablishedPDUSession_sNSSAI),
        (u'uEEndpoint', _SMFStartOfInterceptionWithEstablishedPDUSession_uEEndpoint),
        (u'non3GPPAccessEndpoint', _SMFStartOfInterceptionWithEstablishedPDUSession_non3GPPAccessEndpoint),
        (u'location', _SMFStartOfInterceptionWithEstablishedPDUSession_location),
        (u'dNN', _SMFStartOfInterceptionWithEstablishedPDUSession_dNN),
        (u'aMFID', _SMFStartOfInterceptionWithEstablishedPDUSession_aMFID),
        (u'hSMFURI', _SMFStartOfInterceptionWithEstablishedPDUSession_hSMFURI),
        (u'requestType', _SMFStartOfInterceptionWithEstablishedPDUSession_requestType),
        (u'accessType', _SMFStartOfInterceptionWithEstablishedPDUSession_accessType),
        (u'rATType', _SMFStartOfInterceptionWithEstablishedPDUSession_rATType),
        (u'sMPDUDNRequest', _SMFStartOfInterceptionWithEstablishedPDUSession_sMPDUDNRequest),
        (u'timeOfSessionEstablishment', _SMFStartOfInterceptionWithEstablishedPDUSession_timeOfSessionEstablishment),
        ])
    SMFStartOfInterceptionWithEstablishedPDUSession._ext = []
    
    #-----< SMFUnsuccessfulProcedure >-----#
    SMFUnsuccessfulProcedure = SEQ(name=u'SMFUnsuccessfulProcedure', mode=MODE_TYPE)
    _SMFUnsuccessfulProcedure_failedProcedureType = ENUM(name=u'failedProcedureType', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMFFailedProcedureType')))
    _SMFUnsuccessfulProcedure_failureCause = INT(name=u'failureCause', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'FiveGSMCause')))
    _SMFUnsuccessfulProcedure_initiator = ENUM(name=u'initiator', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Initiator')))
    _SMFUnsuccessfulProcedure_requestedSlice = SEQ_OF(name=u'requestedSlice', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'NSSAI')), opt=True)
    _SMFUnsuccessfulProcedure_sUPI = CHOICE(name=u'sUPI', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SUPI')), opt=True)
    _SMFUnsuccessfulProcedure_sUPIUnauthenticated = BOOL(name=u'sUPIUnauthenticated', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SUPIUnauthenticatedIndication')), opt=True)
    _SMFUnsuccessfulProcedure_pEI = CHOICE(name=u'pEI', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PEI')), opt=True)
    _SMFUnsuccessfulProcedure_gPSI = CHOICE(name=u'gPSI', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'GPSI')), opt=True)
    _SMFUnsuccessfulProcedure_pDUSessionID = INT(name=u'pDUSessionID', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PDUSessionID')), opt=True)
    _SMFUnsuccessfulProcedure_uEEndpoint = SEQ_OF(name=u'uEEndpoint', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __SMFUnsuccessfulProcedure_uEEndpoint__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'UEEndpointAddress')))
    _SMFUnsuccessfulProcedure_uEEndpoint._cont = __SMFUnsuccessfulProcedure_uEEndpoint__item_
    _SMFUnsuccessfulProcedure_non3GPPAccessEndpoint = CHOICE(name=u'non3GPPAccessEndpoint', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'UEEndpointAddress')), opt=True)
    _SMFUnsuccessfulProcedure_dNN = STR_UTF8(name=u'dNN', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'DNN')), opt=True)
    _SMFUnsuccessfulProcedure_aMFID = SEQ(name=u'aMFID', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'AMFID')), opt=True)
    _SMFUnsuccessfulProcedure_hSMFURI = STR_UTF8(name=u'hSMFURI', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'HSMFURI')), opt=True)
    _SMFUnsuccessfulProcedure_requestType = ENUM(name=u'requestType', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'FiveGSMRequestType')), opt=True)
    _SMFUnsuccessfulProcedure_accessType = ENUM(name=u'accessType', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'AccessType')), opt=True)
    _SMFUnsuccessfulProcedure_rATType = ENUM(name=u'rATType', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'RATType')), opt=True)
    _SMFUnsuccessfulProcedure_sMPDUDNRequest = OCT_STR(name=u'sMPDUDNRequest', mode=MODE_TYPE, tag=(18, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMPDUDNRequest')), opt=True)
    _SMFUnsuccessfulProcedure_location = SEQ(name=u'location', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Location')), opt=True)
    SMFUnsuccessfulProcedure._cont = ASN1Dict([
        (u'failedProcedureType', _SMFUnsuccessfulProcedure_failedProcedureType),
        (u'failureCause', _SMFUnsuccessfulProcedure_failureCause),
        (u'initiator', _SMFUnsuccessfulProcedure_initiator),
        (u'requestedSlice', _SMFUnsuccessfulProcedure_requestedSlice),
        (u'sUPI', _SMFUnsuccessfulProcedure_sUPI),
        (u'sUPIUnauthenticated', _SMFUnsuccessfulProcedure_sUPIUnauthenticated),
        (u'pEI', _SMFUnsuccessfulProcedure_pEI),
        (u'gPSI', _SMFUnsuccessfulProcedure_gPSI),
        (u'pDUSessionID', _SMFUnsuccessfulProcedure_pDUSessionID),
        (u'uEEndpoint', _SMFUnsuccessfulProcedure_uEEndpoint),
        (u'non3GPPAccessEndpoint', _SMFUnsuccessfulProcedure_non3GPPAccessEndpoint),
        (u'dNN', _SMFUnsuccessfulProcedure_dNN),
        (u'aMFID', _SMFUnsuccessfulProcedure_aMFID),
        (u'hSMFURI', _SMFUnsuccessfulProcedure_hSMFURI),
        (u'requestType', _SMFUnsuccessfulProcedure_requestType),
        (u'accessType', _SMFUnsuccessfulProcedure_accessType),
        (u'rATType', _SMFUnsuccessfulProcedure_rATType),
        (u'sMPDUDNRequest', _SMFUnsuccessfulProcedure_sMPDUDNRequest),
        (u'location', _SMFUnsuccessfulProcedure_location),
        ])
    SMFUnsuccessfulProcedure._ext = []
    
    #-----< SMFPDUtoMAPDUSessionModification >-----#
    SMFPDUtoMAPDUSessionModification = SEQ(name=u'SMFPDUtoMAPDUSessionModification', mode=MODE_TYPE)
    _SMFPDUtoMAPDUSessionModification_sUPI = CHOICE(name=u'sUPI', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SUPI')), opt=True)
    _SMFPDUtoMAPDUSessionModification_sUPIUnauthenticated = BOOL(name=u'sUPIUnauthenticated', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SUPIUnauthenticatedIndication')), opt=True)
    _SMFPDUtoMAPDUSessionModification_pEI = CHOICE(name=u'pEI', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PEI')), opt=True)
    _SMFPDUtoMAPDUSessionModification_gPSI = CHOICE(name=u'gPSI', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'GPSI')), opt=True)
    _SMFPDUtoMAPDUSessionModification_sNSSAI = SEQ(name=u'sNSSAI', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SNSSAI')), opt=True)
    _SMFPDUtoMAPDUSessionModification_non3GPPAccessEndpoint = CHOICE(name=u'non3GPPAccessEndpoint', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'UEEndpointAddress')), opt=True)
    _SMFPDUtoMAPDUSessionModification_location = SEQ(name=u'location', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Location')), opt=True)
    _SMFPDUtoMAPDUSessionModification_requestType = ENUM(name=u'requestType', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'FiveGSMRequestType')))
    _SMFPDUtoMAPDUSessionModification_accessType = ENUM(name=u'accessType', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'AccessType')), opt=True)
    _SMFPDUtoMAPDUSessionModification_rATType = ENUM(name=u'rATType', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'RATType')), opt=True)
    _SMFPDUtoMAPDUSessionModification_pDUSessionID = INT(name=u'pDUSessionID', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PDUSessionID')))
    _SMFPDUtoMAPDUSessionModification_requestIndication = ENUM(name=u'requestIndication', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'RequestIndication')))
    _SMFPDUtoMAPDUSessionModification_aTSSSContainer = OCT_STR(name=u'aTSSSContainer', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'ATSSSContainer')))
    SMFPDUtoMAPDUSessionModification._cont = ASN1Dict([
        (u'sUPI', _SMFPDUtoMAPDUSessionModification_sUPI),
        (u'sUPIUnauthenticated', _SMFPDUtoMAPDUSessionModification_sUPIUnauthenticated),
        (u'pEI', _SMFPDUtoMAPDUSessionModification_pEI),
        (u'gPSI', _SMFPDUtoMAPDUSessionModification_gPSI),
        (u'sNSSAI', _SMFPDUtoMAPDUSessionModification_sNSSAI),
        (u'non3GPPAccessEndpoint', _SMFPDUtoMAPDUSessionModification_non3GPPAccessEndpoint),
        (u'location', _SMFPDUtoMAPDUSessionModification_location),
        (u'requestType', _SMFPDUtoMAPDUSessionModification_requestType),
        (u'accessType', _SMFPDUtoMAPDUSessionModification_accessType),
        (u'rATType', _SMFPDUtoMAPDUSessionModification_rATType),
        (u'pDUSessionID', _SMFPDUtoMAPDUSessionModification_pDUSessionID),
        (u'requestIndication', _SMFPDUtoMAPDUSessionModification_requestIndication),
        (u'aTSSSContainer', _SMFPDUtoMAPDUSessionModification_aTSSSContainer),
        ])
    SMFPDUtoMAPDUSessionModification._ext = []
    
    #-----< SMFMAPDUSessionEstablishment >-----#
    SMFMAPDUSessionEstablishment = SEQ(name=u'SMFMAPDUSessionEstablishment', mode=MODE_TYPE)
    _SMFMAPDUSessionEstablishment_sUPI = CHOICE(name=u'sUPI', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SUPI')), opt=True)
    _SMFMAPDUSessionEstablishment_sUPIUnauthenticated = BOOL(name=u'sUPIUnauthenticated', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SUPIUnauthenticatedIndication')), opt=True)
    _SMFMAPDUSessionEstablishment_pEI = CHOICE(name=u'pEI', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PEI')), opt=True)
    _SMFMAPDUSessionEstablishment_gPSI = CHOICE(name=u'gPSI', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'GPSI')), opt=True)
    _SMFMAPDUSessionEstablishment_pDUSessionID = INT(name=u'pDUSessionID', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PDUSessionID')))
    _SMFMAPDUSessionEstablishment_pDUSessionType = ENUM(name=u'pDUSessionType', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PDUSessionType')))
    _SMFMAPDUSessionEstablishment_accessInfo = SEQ_OF(name=u'accessInfo', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __SMFMAPDUSessionEstablishment_accessInfo__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'AccessInfo')))
    _SMFMAPDUSessionEstablishment_accessInfo._cont = __SMFMAPDUSessionEstablishment_accessInfo__item_
    _SMFMAPDUSessionEstablishment_sNSSAI = SEQ(name=u'sNSSAI', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SNSSAI')), opt=True)
    _SMFMAPDUSessionEstablishment_uEEndpoint = SEQ_OF(name=u'uEEndpoint', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __SMFMAPDUSessionEstablishment_uEEndpoint__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'UEEndpointAddress')))
    _SMFMAPDUSessionEstablishment_uEEndpoint._cont = __SMFMAPDUSessionEstablishment_uEEndpoint__item_
    _SMFMAPDUSessionEstablishment_location = SEQ(name=u'location', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Location')), opt=True)
    _SMFMAPDUSessionEstablishment_dNN = STR_UTF8(name=u'dNN', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'DNN')))
    _SMFMAPDUSessionEstablishment_aMFID = SEQ(name=u'aMFID', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'AMFID')), opt=True)
    _SMFMAPDUSessionEstablishment_hSMFURI = STR_UTF8(name=u'hSMFURI', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'HSMFURI')), opt=True)
    _SMFMAPDUSessionEstablishment_requestType = ENUM(name=u'requestType', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'FiveGSMRequestType')))
    _SMFMAPDUSessionEstablishment_sMPDUDNRequest = OCT_STR(name=u'sMPDUDNRequest', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMPDUDNRequest')), opt=True)
    _SMFMAPDUSessionEstablishment_servingNetwork = SEQ(name=u'servingNetwork', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMFServingNetwork')))
    _SMFMAPDUSessionEstablishment_oldPDUSessionID = INT(name=u'oldPDUSessionID', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PDUSessionID')), opt=True)
    _SMFMAPDUSessionEstablishment_mAUpgradeIndication = BOOL(name=u'mAUpgradeIndication', mode=MODE_TYPE, tag=(18, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMFMAUpgradeIndication')), opt=True)
    _SMFMAPDUSessionEstablishment_ePSPDNCnxInfo = STR_UTF8(name=u'ePSPDNCnxInfo', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMFEPSPDNCnxInfo')), opt=True)
    _SMFMAPDUSessionEstablishment_mAAcceptedIndication = BOOL(name=u'mAAcceptedIndication', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMFMAAcceptedIndication')))
    _SMFMAPDUSessionEstablishment_aTSSSContainer = OCT_STR(name=u'aTSSSContainer', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'ATSSSContainer')), opt=True)
    SMFMAPDUSessionEstablishment._cont = ASN1Dict([
        (u'sUPI', _SMFMAPDUSessionEstablishment_sUPI),
        (u'sUPIUnauthenticated', _SMFMAPDUSessionEstablishment_sUPIUnauthenticated),
        (u'pEI', _SMFMAPDUSessionEstablishment_pEI),
        (u'gPSI', _SMFMAPDUSessionEstablishment_gPSI),
        (u'pDUSessionID', _SMFMAPDUSessionEstablishment_pDUSessionID),
        (u'pDUSessionType', _SMFMAPDUSessionEstablishment_pDUSessionType),
        (u'accessInfo', _SMFMAPDUSessionEstablishment_accessInfo),
        (u'sNSSAI', _SMFMAPDUSessionEstablishment_sNSSAI),
        (u'uEEndpoint', _SMFMAPDUSessionEstablishment_uEEndpoint),
        (u'location', _SMFMAPDUSessionEstablishment_location),
        (u'dNN', _SMFMAPDUSessionEstablishment_dNN),
        (u'aMFID', _SMFMAPDUSessionEstablishment_aMFID),
        (u'hSMFURI', _SMFMAPDUSessionEstablishment_hSMFURI),
        (u'requestType', _SMFMAPDUSessionEstablishment_requestType),
        (u'sMPDUDNRequest', _SMFMAPDUSessionEstablishment_sMPDUDNRequest),
        (u'servingNetwork', _SMFMAPDUSessionEstablishment_servingNetwork),
        (u'oldPDUSessionID', _SMFMAPDUSessionEstablishment_oldPDUSessionID),
        (u'mAUpgradeIndication', _SMFMAPDUSessionEstablishment_mAUpgradeIndication),
        (u'ePSPDNCnxInfo', _SMFMAPDUSessionEstablishment_ePSPDNCnxInfo),
        (u'mAAcceptedIndication', _SMFMAPDUSessionEstablishment_mAAcceptedIndication),
        (u'aTSSSContainer', _SMFMAPDUSessionEstablishment_aTSSSContainer),
        ])
    SMFMAPDUSessionEstablishment._ext = []
    
    #-----< SMFMAPDUSessionModification >-----#
    SMFMAPDUSessionModification = SEQ(name=u'SMFMAPDUSessionModification', mode=MODE_TYPE)
    _SMFMAPDUSessionModification_sUPI = CHOICE(name=u'sUPI', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SUPI')), opt=True)
    _SMFMAPDUSessionModification_sUPIUnauthenticated = BOOL(name=u'sUPIUnauthenticated', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SUPIUnauthenticatedIndication')), opt=True)
    _SMFMAPDUSessionModification_pEI = CHOICE(name=u'pEI', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PEI')), opt=True)
    _SMFMAPDUSessionModification_gPSI = CHOICE(name=u'gPSI', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'GPSI')), opt=True)
    _SMFMAPDUSessionModification_pDUSessionID = INT(name=u'pDUSessionID', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PDUSessionID')))
    _SMFMAPDUSessionModification_accessInfo = SEQ_OF(name=u'accessInfo', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __SMFMAPDUSessionModification_accessInfo__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'AccessInfo')))
    _SMFMAPDUSessionModification_accessInfo._cont = __SMFMAPDUSessionModification_accessInfo__item_
    _SMFMAPDUSessionModification_sNSSAI = SEQ(name=u'sNSSAI', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SNSSAI')), opt=True)
    _SMFMAPDUSessionModification_location = SEQ(name=u'location', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Location')), opt=True)
    _SMFMAPDUSessionModification_requestType = ENUM(name=u'requestType', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'FiveGSMRequestType')), opt=True)
    _SMFMAPDUSessionModification_servingNetwork = SEQ(name=u'servingNetwork', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMFServingNetwork')))
    _SMFMAPDUSessionModification_oldPDUSessionID = INT(name=u'oldPDUSessionID', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PDUSessionID')), opt=True)
    _SMFMAPDUSessionModification_mAUpgradeIndication = BOOL(name=u'mAUpgradeIndication', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMFMAUpgradeIndication')), opt=True)
    _SMFMAPDUSessionModification_ePSPDNCnxInfo = STR_UTF8(name=u'ePSPDNCnxInfo', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMFEPSPDNCnxInfo')), opt=True)
    _SMFMAPDUSessionModification_mAAcceptedIndication = BOOL(name=u'mAAcceptedIndication', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMFMAAcceptedIndication')))
    _SMFMAPDUSessionModification_aTSSSContainer = OCT_STR(name=u'aTSSSContainer', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'ATSSSContainer')), opt=True)
    SMFMAPDUSessionModification._cont = ASN1Dict([
        (u'sUPI', _SMFMAPDUSessionModification_sUPI),
        (u'sUPIUnauthenticated', _SMFMAPDUSessionModification_sUPIUnauthenticated),
        (u'pEI', _SMFMAPDUSessionModification_pEI),
        (u'gPSI', _SMFMAPDUSessionModification_gPSI),
        (u'pDUSessionID', _SMFMAPDUSessionModification_pDUSessionID),
        (u'accessInfo', _SMFMAPDUSessionModification_accessInfo),
        (u'sNSSAI', _SMFMAPDUSessionModification_sNSSAI),
        (u'location', _SMFMAPDUSessionModification_location),
        (u'requestType', _SMFMAPDUSessionModification_requestType),
        (u'servingNetwork', _SMFMAPDUSessionModification_servingNetwork),
        (u'oldPDUSessionID', _SMFMAPDUSessionModification_oldPDUSessionID),
        (u'mAUpgradeIndication', _SMFMAPDUSessionModification_mAUpgradeIndication),
        (u'ePSPDNCnxInfo', _SMFMAPDUSessionModification_ePSPDNCnxInfo),
        (u'mAAcceptedIndication', _SMFMAPDUSessionModification_mAAcceptedIndication),
        (u'aTSSSContainer', _SMFMAPDUSessionModification_aTSSSContainer),
        ])
    SMFMAPDUSessionModification._ext = []
    
    #-----< SMFMAPDUSessionRelease >-----#
    SMFMAPDUSessionRelease = SEQ(name=u'SMFMAPDUSessionRelease', mode=MODE_TYPE)
    _SMFMAPDUSessionRelease_sUPI = CHOICE(name=u'sUPI', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SUPI')))
    _SMFMAPDUSessionRelease_pEI = CHOICE(name=u'pEI', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PEI')), opt=True)
    _SMFMAPDUSessionRelease_gPSI = CHOICE(name=u'gPSI', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'GPSI')), opt=True)
    _SMFMAPDUSessionRelease_pDUSessionID = INT(name=u'pDUSessionID', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PDUSessionID')))
    _SMFMAPDUSessionRelease_timeOfFirstPacket = TIME_GEN(name=u'timeOfFirstPacket', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Timestamp')), opt=True)
    _SMFMAPDUSessionRelease_timeOfLastPacket = TIME_GEN(name=u'timeOfLastPacket', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Timestamp')), opt=True)
    _SMFMAPDUSessionRelease_uplinkVolume = INT(name=u'uplinkVolume', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _SMFMAPDUSessionRelease_downlinkVolume = INT(name=u'downlinkVolume', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _SMFMAPDUSessionRelease_location = SEQ(name=u'location', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Location')), opt=True)
    _SMFMAPDUSessionRelease_cause = STR_UTF8(name=u'cause', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMFErrorCodes')), opt=True)
    SMFMAPDUSessionRelease._cont = ASN1Dict([
        (u'sUPI', _SMFMAPDUSessionRelease_sUPI),
        (u'pEI', _SMFMAPDUSessionRelease_pEI),
        (u'gPSI', _SMFMAPDUSessionRelease_gPSI),
        (u'pDUSessionID', _SMFMAPDUSessionRelease_pDUSessionID),
        (u'timeOfFirstPacket', _SMFMAPDUSessionRelease_timeOfFirstPacket),
        (u'timeOfLastPacket', _SMFMAPDUSessionRelease_timeOfLastPacket),
        (u'uplinkVolume', _SMFMAPDUSessionRelease_uplinkVolume),
        (u'downlinkVolume', _SMFMAPDUSessionRelease_downlinkVolume),
        (u'location', _SMFMAPDUSessionRelease_location),
        (u'cause', _SMFMAPDUSessionRelease_cause),
        ])
    SMFMAPDUSessionRelease._ext = []
    
    #-----< SMFStartOfInterceptionWithEstablishedMAPDUSession >-----#
    SMFStartOfInterceptionWithEstablishedMAPDUSession = SEQ(name=u'SMFStartOfInterceptionWithEstablishedMAPDUSession', mode=MODE_TYPE)
    _SMFStartOfInterceptionWithEstablishedMAPDUSession_sUPI = CHOICE(name=u'sUPI', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SUPI')), opt=True)
    _SMFStartOfInterceptionWithEstablishedMAPDUSession_sUPIUnauthenticated = BOOL(name=u'sUPIUnauthenticated', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SUPIUnauthenticatedIndication')), opt=True)
    _SMFStartOfInterceptionWithEstablishedMAPDUSession_pEI = CHOICE(name=u'pEI', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PEI')), opt=True)
    _SMFStartOfInterceptionWithEstablishedMAPDUSession_gPSI = CHOICE(name=u'gPSI', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'GPSI')), opt=True)
    _SMFStartOfInterceptionWithEstablishedMAPDUSession_pDUSessionID = INT(name=u'pDUSessionID', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PDUSessionID')))
    _SMFStartOfInterceptionWithEstablishedMAPDUSession_pDUSessionType = ENUM(name=u'pDUSessionType', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PDUSessionType')))
    _SMFStartOfInterceptionWithEstablishedMAPDUSession_accessInfo = SEQ_OF(name=u'accessInfo', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __SMFStartOfInterceptionWithEstablishedMAPDUSession_accessInfo__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'AccessInfo')))
    _SMFStartOfInterceptionWithEstablishedMAPDUSession_accessInfo._cont = __SMFStartOfInterceptionWithEstablishedMAPDUSession_accessInfo__item_
    _SMFStartOfInterceptionWithEstablishedMAPDUSession_sNSSAI = SEQ(name=u'sNSSAI', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SNSSAI')), opt=True)
    _SMFStartOfInterceptionWithEstablishedMAPDUSession_uEEndpoint = SEQ_OF(name=u'uEEndpoint', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __SMFStartOfInterceptionWithEstablishedMAPDUSession_uEEndpoint__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'UEEndpointAddress')))
    _SMFStartOfInterceptionWithEstablishedMAPDUSession_uEEndpoint._cont = __SMFStartOfInterceptionWithEstablishedMAPDUSession_uEEndpoint__item_
    _SMFStartOfInterceptionWithEstablishedMAPDUSession_location = SEQ(name=u'location', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Location')), opt=True)
    _SMFStartOfInterceptionWithEstablishedMAPDUSession_dNN = STR_UTF8(name=u'dNN', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'DNN')))
    _SMFStartOfInterceptionWithEstablishedMAPDUSession_aMFID = SEQ(name=u'aMFID', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'AMFID')), opt=True)
    _SMFStartOfInterceptionWithEstablishedMAPDUSession_hSMFURI = STR_UTF8(name=u'hSMFURI', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'HSMFURI')), opt=True)
    _SMFStartOfInterceptionWithEstablishedMAPDUSession_requestType = ENUM(name=u'requestType', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'FiveGSMRequestType')), opt=True)
    _SMFStartOfInterceptionWithEstablishedMAPDUSession_sMPDUDNRequest = OCT_STR(name=u'sMPDUDNRequest', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMPDUDNRequest')), opt=True)
    _SMFStartOfInterceptionWithEstablishedMAPDUSession_servingNetwork = SEQ(name=u'servingNetwork', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMFServingNetwork')))
    _SMFStartOfInterceptionWithEstablishedMAPDUSession_oldPDUSessionID = INT(name=u'oldPDUSessionID', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PDUSessionID')), opt=True)
    _SMFStartOfInterceptionWithEstablishedMAPDUSession_mAUpgradeIndication = BOOL(name=u'mAUpgradeIndication', mode=MODE_TYPE, tag=(18, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMFMAUpgradeIndication')), opt=True)
    _SMFStartOfInterceptionWithEstablishedMAPDUSession_ePSPDNCnxInfo = STR_UTF8(name=u'ePSPDNCnxInfo', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMFEPSPDNCnxInfo')), opt=True)
    _SMFStartOfInterceptionWithEstablishedMAPDUSession_mAAcceptedIndication = BOOL(name=u'mAAcceptedIndication', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMFMAAcceptedIndication')))
    _SMFStartOfInterceptionWithEstablishedMAPDUSession_aTSSSContainer = OCT_STR(name=u'aTSSSContainer', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'ATSSSContainer')), opt=True)
    SMFStartOfInterceptionWithEstablishedMAPDUSession._cont = ASN1Dict([
        (u'sUPI', _SMFStartOfInterceptionWithEstablishedMAPDUSession_sUPI),
        (u'sUPIUnauthenticated', _SMFStartOfInterceptionWithEstablishedMAPDUSession_sUPIUnauthenticated),
        (u'pEI', _SMFStartOfInterceptionWithEstablishedMAPDUSession_pEI),
        (u'gPSI', _SMFStartOfInterceptionWithEstablishedMAPDUSession_gPSI),
        (u'pDUSessionID', _SMFStartOfInterceptionWithEstablishedMAPDUSession_pDUSessionID),
        (u'pDUSessionType', _SMFStartOfInterceptionWithEstablishedMAPDUSession_pDUSessionType),
        (u'accessInfo', _SMFStartOfInterceptionWithEstablishedMAPDUSession_accessInfo),
        (u'sNSSAI', _SMFStartOfInterceptionWithEstablishedMAPDUSession_sNSSAI),
        (u'uEEndpoint', _SMFStartOfInterceptionWithEstablishedMAPDUSession_uEEndpoint),
        (u'location', _SMFStartOfInterceptionWithEstablishedMAPDUSession_location),
        (u'dNN', _SMFStartOfInterceptionWithEstablishedMAPDUSession_dNN),
        (u'aMFID', _SMFStartOfInterceptionWithEstablishedMAPDUSession_aMFID),
        (u'hSMFURI', _SMFStartOfInterceptionWithEstablishedMAPDUSession_hSMFURI),
        (u'requestType', _SMFStartOfInterceptionWithEstablishedMAPDUSession_requestType),
        (u'sMPDUDNRequest', _SMFStartOfInterceptionWithEstablishedMAPDUSession_sMPDUDNRequest),
        (u'servingNetwork', _SMFStartOfInterceptionWithEstablishedMAPDUSession_servingNetwork),
        (u'oldPDUSessionID', _SMFStartOfInterceptionWithEstablishedMAPDUSession_oldPDUSessionID),
        (u'mAUpgradeIndication', _SMFStartOfInterceptionWithEstablishedMAPDUSession_mAUpgradeIndication),
        (u'ePSPDNCnxInfo', _SMFStartOfInterceptionWithEstablishedMAPDUSession_ePSPDNCnxInfo),
        (u'mAAcceptedIndication', _SMFStartOfInterceptionWithEstablishedMAPDUSession_mAAcceptedIndication),
        (u'aTSSSContainer', _SMFStartOfInterceptionWithEstablishedMAPDUSession_aTSSSContainer),
        ])
    SMFStartOfInterceptionWithEstablishedMAPDUSession._ext = []
    
    #-----< SMFMAUnsuccessfulProcedure >-----#
    SMFMAUnsuccessfulProcedure = SEQ(name=u'SMFMAUnsuccessfulProcedure', mode=MODE_TYPE)
    _SMFMAUnsuccessfulProcedure_failedProcedureType = ENUM(name=u'failedProcedureType', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMFFailedProcedureType')))
    _SMFMAUnsuccessfulProcedure_failureCause = INT(name=u'failureCause', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'FiveGSMCause')))
    _SMFMAUnsuccessfulProcedure_requestedSlice = SEQ_OF(name=u'requestedSlice', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'NSSAI')), opt=True)
    _SMFMAUnsuccessfulProcedure_initiator = ENUM(name=u'initiator', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Initiator')))
    _SMFMAUnsuccessfulProcedure_sUPI = CHOICE(name=u'sUPI', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SUPI')), opt=True)
    _SMFMAUnsuccessfulProcedure_sUPIUnauthenticated = BOOL(name=u'sUPIUnauthenticated', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SUPIUnauthenticatedIndication')), opt=True)
    _SMFMAUnsuccessfulProcedure_pEI = CHOICE(name=u'pEI', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PEI')), opt=True)
    _SMFMAUnsuccessfulProcedure_gPSI = CHOICE(name=u'gPSI', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'GPSI')), opt=True)
    _SMFMAUnsuccessfulProcedure_pDUSessionID = INT(name=u'pDUSessionID', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PDUSessionID')), opt=True)
    _SMFMAUnsuccessfulProcedure_accessInfo = SEQ_OF(name=u'accessInfo', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __SMFMAUnsuccessfulProcedure_accessInfo__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'AccessInfo')))
    _SMFMAUnsuccessfulProcedure_accessInfo._cont = __SMFMAUnsuccessfulProcedure_accessInfo__item_
    _SMFMAUnsuccessfulProcedure_uEEndpoint = SEQ_OF(name=u'uEEndpoint', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __SMFMAUnsuccessfulProcedure_uEEndpoint__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'UEEndpointAddress')))
    _SMFMAUnsuccessfulProcedure_uEEndpoint._cont = __SMFMAUnsuccessfulProcedure_uEEndpoint__item_
    _SMFMAUnsuccessfulProcedure_location = SEQ(name=u'location', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Location')), opt=True)
    _SMFMAUnsuccessfulProcedure_dNN = STR_UTF8(name=u'dNN', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'DNN')), opt=True)
    _SMFMAUnsuccessfulProcedure_aMFID = SEQ(name=u'aMFID', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'AMFID')), opt=True)
    _SMFMAUnsuccessfulProcedure_hSMFURI = STR_UTF8(name=u'hSMFURI', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'HSMFURI')), opt=True)
    _SMFMAUnsuccessfulProcedure_requestType = ENUM(name=u'requestType', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'FiveGSMRequestType')), opt=True)
    _SMFMAUnsuccessfulProcedure_sMPDUDNRequest = OCT_STR(name=u'sMPDUDNRequest', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMPDUDNRequest')), opt=True)
    SMFMAUnsuccessfulProcedure._cont = ASN1Dict([
        (u'failedProcedureType', _SMFMAUnsuccessfulProcedure_failedProcedureType),
        (u'failureCause', _SMFMAUnsuccessfulProcedure_failureCause),
        (u'requestedSlice', _SMFMAUnsuccessfulProcedure_requestedSlice),
        (u'initiator', _SMFMAUnsuccessfulProcedure_initiator),
        (u'sUPI', _SMFMAUnsuccessfulProcedure_sUPI),
        (u'sUPIUnauthenticated', _SMFMAUnsuccessfulProcedure_sUPIUnauthenticated),
        (u'pEI', _SMFMAUnsuccessfulProcedure_pEI),
        (u'gPSI', _SMFMAUnsuccessfulProcedure_gPSI),
        (u'pDUSessionID', _SMFMAUnsuccessfulProcedure_pDUSessionID),
        (u'accessInfo', _SMFMAUnsuccessfulProcedure_accessInfo),
        (u'uEEndpoint', _SMFMAUnsuccessfulProcedure_uEEndpoint),
        (u'location', _SMFMAUnsuccessfulProcedure_location),
        (u'dNN', _SMFMAUnsuccessfulProcedure_dNN),
        (u'aMFID', _SMFMAUnsuccessfulProcedure_aMFID),
        (u'hSMFURI', _SMFMAUnsuccessfulProcedure_hSMFURI),
        (u'requestType', _SMFMAUnsuccessfulProcedure_requestType),
        (u'sMPDUDNRequest', _SMFMAUnsuccessfulProcedure_sMPDUDNRequest),
        ])
    SMFMAUnsuccessfulProcedure._ext = []
    
    #-----< SMFFailedProcedureType >-----#
    SMFFailedProcedureType = ENUM(name=u'SMFFailedProcedureType', mode=MODE_TYPE)
    SMFFailedProcedureType._cont = ASN1Dict([(u'pDUSessionEstablishment', 1), (u'pDUSessionModification', 2), (u'pDUSessionRelease', 3)])
    SMFFailedProcedureType._ext = []
    
    #-----< SMFServingNetwork >-----#
    SMFServingNetwork = SEQ(name=u'SMFServingNetwork', mode=MODE_TYPE)
    _SMFServingNetwork_pLMNID = SEQ(name=u'pLMNID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PLMNID')))
    _SMFServingNetwork_nID = STR_UTF8(name=u'nID', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'NID')), opt=True)
    SMFServingNetwork._cont = ASN1Dict([
        (u'pLMNID', _SMFServingNetwork_pLMNID),
        (u'nID', _SMFServingNetwork_nID),
        ])
    SMFServingNetwork._ext = []
    
    #-----< AccessInfo >-----#
    AccessInfo = SEQ(name=u'AccessInfo', mode=MODE_TYPE)
    _AccessInfo_accessType = ENUM(name=u'accessType', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'AccessType')))
    _AccessInfo_rATType = ENUM(name=u'rATType', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'RATType')), opt=True)
    _AccessInfo_gTPTunnelID = SEQ(name=u'gTPTunnelID', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'FTEID')))
    _AccessInfo_non3GPPAccessEndpoint = CHOICE(name=u'non3GPPAccessEndpoint', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'UEEndpointAddress')), opt=True)
    _AccessInfo_establishmentStatus = ENUM(name=u'establishmentStatus', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'EstablishmentStatus')))
    _AccessInfo_aNTypeToReactivate = ENUM(name=u'aNTypeToReactivate', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'AccessType')), opt=True)
    AccessInfo._cont = ASN1Dict([
        (u'accessType', _AccessInfo_accessType),
        (u'rATType', _AccessInfo_rATType),
        (u'gTPTunnelID', _AccessInfo_gTPTunnelID),
        (u'non3GPPAccessEndpoint', _AccessInfo_non3GPPAccessEndpoint),
        (u'establishmentStatus', _AccessInfo_establishmentStatus),
        (u'aNTypeToReactivate', _AccessInfo_aNTypeToReactivate),
        ])
    AccessInfo._ext = []
    
    #-----< ATSSSContainer >-----#
    ATSSSContainer = OCT_STR(name=u'ATSSSContainer', mode=MODE_TYPE)
    
    #-----< EstablishmentStatus >-----#
    EstablishmentStatus = ENUM(name=u'EstablishmentStatus', mode=MODE_TYPE)
    EstablishmentStatus._cont = ASN1Dict([(u'established', 0), (u'released', 1)])
    EstablishmentStatus._ext = []
    
    #-----< SMFMAUpgradeIndication >-----#
    SMFMAUpgradeIndication = BOOL(name=u'SMFMAUpgradeIndication', mode=MODE_TYPE)
    
    #-----< SMFEPSPDNCnxInfo >-----#
    SMFEPSPDNCnxInfo = STR_UTF8(name=u'SMFEPSPDNCnxInfo', mode=MODE_TYPE)
    
    #-----< SMFMAAcceptedIndication >-----#
    SMFMAAcceptedIndication = BOOL(name=u'SMFMAAcceptedIndication', mode=MODE_TYPE)
    
    #-----< SMFErrorCodes >-----#
    SMFErrorCodes = STR_UTF8(name=u'SMFErrorCodes', mode=MODE_TYPE)
    
    #-----< UEEPSPDNConnection >-----#
    UEEPSPDNConnection = OCT_STR(name=u'UEEPSPDNConnection', mode=MODE_TYPE)
    
    #-----< RequestIndication >-----#
    RequestIndication = ENUM(name=u'RequestIndication', mode=MODE_TYPE)
    RequestIndication._cont = ASN1Dict([(u'uEREQPDUSESMOD', 0), (u'uEREQPDUSESREL', 1), (u'pDUSESMOB', 2), (u'nWREQPDUSESAUTH', 3), (u'nWREQPDUSESMOD', 4), (u'nWREQPDUSESREL', 5), (u'eBIASSIGNMENTREQ', 6), (u'rELDUETO5GANREQUEST', 7)])
    RequestIndication._ext = []
    
    #-----< UPFCCPDU >-----#
    UPFCCPDU = OCT_STR(name=u'UPFCCPDU', mode=MODE_TYPE)
    
    #-----< ExtendedUPFCCPDU >-----#
    ExtendedUPFCCPDU = SEQ(name=u'ExtendedUPFCCPDU', mode=MODE_TYPE)
    _ExtendedUPFCCPDU_payload = CHOICE(name=u'payload', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'UPFCCPDUPayload')))
    _ExtendedUPFCCPDU_qFI = INT(name=u'qFI', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'QFI')), opt=True)
    ExtendedUPFCCPDU._cont = ASN1Dict([
        (u'payload', _ExtendedUPFCCPDU_payload),
        (u'qFI', _ExtendedUPFCCPDU_qFI),
        ])
    ExtendedUPFCCPDU._ext = []
    
    #-----< UPFCCPDUPayload >-----#
    UPFCCPDUPayload = CHOICE(name=u'UPFCCPDUPayload', mode=MODE_TYPE)
    _UPFCCPDUPayload_uPFIPCC = OCT_STR(name=u'uPFIPCC', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UPFCCPDUPayload_uPFEthernetCC = OCT_STR(name=u'uPFEthernetCC', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _UPFCCPDUPayload_uPFUnstructuredCC = OCT_STR(name=u'uPFUnstructuredCC', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    UPFCCPDUPayload._cont = ASN1Dict([
        (u'uPFIPCC', _UPFCCPDUPayload_uPFIPCC),
        (u'uPFEthernetCC', _UPFCCPDUPayload_uPFEthernetCC),
        (u'uPFUnstructuredCC', _UPFCCPDUPayload_uPFUnstructuredCC),
        ])
    UPFCCPDUPayload._ext = []
    
    #-----< QFI >-----#
    QFI = INT(name=u'QFI', mode=MODE_TYPE)
    QFI._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=63)], ev=None, er=[])
    
    #-----< UDMServingSystemMessage >-----#
    UDMServingSystemMessage = SEQ(name=u'UDMServingSystemMessage', mode=MODE_TYPE)
    _UDMServingSystemMessage_sUPI = CHOICE(name=u'sUPI', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SUPI')))
    _UDMServingSystemMessage_pEI = CHOICE(name=u'pEI', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PEI')), opt=True)
    _UDMServingSystemMessage_gPSI = CHOICE(name=u'gPSI', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'GPSI')), opt=True)
    _UDMServingSystemMessage_gUAMI = SEQ(name=u'gUAMI', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'GUAMI')), opt=True)
    _UDMServingSystemMessage_gUMMEI = SEQ(name=u'gUMMEI', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'GUMMEI')), opt=True)
    _UDMServingSystemMessage_pLMNID = SEQ(name=u'pLMNID', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PLMNID')), opt=True)
    _UDMServingSystemMessage_servingSystemMethod = ENUM(name=u'servingSystemMethod', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'UDMServingSystemMethod')))
    _UDMServingSystemMessage_serviceID = SEQ(name=u'serviceID', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'ServiceID')), opt=True)
    UDMServingSystemMessage._cont = ASN1Dict([
        (u'sUPI', _UDMServingSystemMessage_sUPI),
        (u'pEI', _UDMServingSystemMessage_pEI),
        (u'gPSI', _UDMServingSystemMessage_gPSI),
        (u'gUAMI', _UDMServingSystemMessage_gUAMI),
        (u'gUMMEI', _UDMServingSystemMessage_gUMMEI),
        (u'pLMNID', _UDMServingSystemMessage_pLMNID),
        (u'servingSystemMethod', _UDMServingSystemMessage_servingSystemMethod),
        (u'serviceID', _UDMServingSystemMessage_serviceID),
        ])
    UDMServingSystemMessage._ext = []
    
    #-----< UDMSubscriberRecordChangeMessage >-----#
    UDMSubscriberRecordChangeMessage = SEQ(name=u'UDMSubscriberRecordChangeMessage', mode=MODE_TYPE)
    _UDMSubscriberRecordChangeMessage_sUPI = CHOICE(name=u'sUPI', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SUPI')), opt=True)
    _UDMSubscriberRecordChangeMessage_pEI = CHOICE(name=u'pEI', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PEI')), opt=True)
    _UDMSubscriberRecordChangeMessage_gPSI = CHOICE(name=u'gPSI', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'GPSI')), opt=True)
    _UDMSubscriberRecordChangeMessage_oldPEI = CHOICE(name=u'oldPEI', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PEI')), opt=True)
    _UDMSubscriberRecordChangeMessage_oldSUPI = CHOICE(name=u'oldSUPI', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SUPI')), opt=True)
    _UDMSubscriberRecordChangeMessage_oldGPSI = CHOICE(name=u'oldGPSI', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'GPSI')), opt=True)
    _UDMSubscriberRecordChangeMessage_oldserviceID = SEQ(name=u'oldserviceID', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'ServiceID')), opt=True)
    _UDMSubscriberRecordChangeMessage_subscriberRecordChangeMethod = ENUM(name=u'subscriberRecordChangeMethod', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'UDMSubscriberRecordChangeMethod')))
    _UDMSubscriberRecordChangeMessage_serviceID = SEQ(name=u'serviceID', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'ServiceID')), opt=True)
    UDMSubscriberRecordChangeMessage._cont = ASN1Dict([
        (u'sUPI', _UDMSubscriberRecordChangeMessage_sUPI),
        (u'pEI', _UDMSubscriberRecordChangeMessage_pEI),
        (u'gPSI', _UDMSubscriberRecordChangeMessage_gPSI),
        (u'oldPEI', _UDMSubscriberRecordChangeMessage_oldPEI),
        (u'oldSUPI', _UDMSubscriberRecordChangeMessage_oldSUPI),
        (u'oldGPSI', _UDMSubscriberRecordChangeMessage_oldGPSI),
        (u'oldserviceID', _UDMSubscriberRecordChangeMessage_oldserviceID),
        (u'subscriberRecordChangeMethod', _UDMSubscriberRecordChangeMessage_subscriberRecordChangeMethod),
        (u'serviceID', _UDMSubscriberRecordChangeMessage_serviceID),
        ])
    UDMSubscriberRecordChangeMessage._ext = []
    
    #-----< UDMCancelLocationMessage >-----#
    UDMCancelLocationMessage = SEQ(name=u'UDMCancelLocationMessage', mode=MODE_TYPE)
    _UDMCancelLocationMessage_sUPI = CHOICE(name=u'sUPI', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SUPI')))
    _UDMCancelLocationMessage_pEI = CHOICE(name=u'pEI', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PEI')), opt=True)
    _UDMCancelLocationMessage_gPSI = CHOICE(name=u'gPSI', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'GPSI')), opt=True)
    _UDMCancelLocationMessage_gUAMI = SEQ(name=u'gUAMI', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'GUAMI')), opt=True)
    _UDMCancelLocationMessage_pLMNID = SEQ(name=u'pLMNID', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PLMNID')), opt=True)
    _UDMCancelLocationMessage_cancelLocationMethod = ENUM(name=u'cancelLocationMethod', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'UDMCancelLocationMethod')))
    UDMCancelLocationMessage._cont = ASN1Dict([
        (u'sUPI', _UDMCancelLocationMessage_sUPI),
        (u'pEI', _UDMCancelLocationMessage_pEI),
        (u'gPSI', _UDMCancelLocationMessage_gPSI),
        (u'gUAMI', _UDMCancelLocationMessage_gUAMI),
        (u'pLMNID', _UDMCancelLocationMessage_pLMNID),
        (u'cancelLocationMethod', _UDMCancelLocationMessage_cancelLocationMethod),
        ])
    UDMCancelLocationMessage._ext = []
    
    #-----< UDMServingSystemMethod >-----#
    UDMServingSystemMethod = ENUM(name=u'UDMServingSystemMethod', mode=MODE_TYPE)
    UDMServingSystemMethod._cont = ASN1Dict([(u'amf3GPPAccessRegistration', 0), (u'amfNon3GPPAccessRegistration', 1), (u'unknown', 2)])
    UDMServingSystemMethod._ext = []
    
    #-----< UDMSubscriberRecordChangeMethod >-----#
    UDMSubscriberRecordChangeMethod = ENUM(name=u'UDMSubscriberRecordChangeMethod', mode=MODE_TYPE)
    UDMSubscriberRecordChangeMethod._cont = ASN1Dict([(u'pEIChange', 1), (u'sUPIChange', 2), (u'gPSIChange', 3), (u'uEDeprovisioning', 4), (u'unknown', 5), (u'serviceIDChange', 6)])
    UDMSubscriberRecordChangeMethod._ext = []
    
    #-----< UDMCancelLocationMethod >-----#
    UDMCancelLocationMethod = ENUM(name=u'UDMCancelLocationMethod', mode=MODE_TYPE)
    UDMCancelLocationMethod._cont = ASN1Dict([(u'aMF3GPPAccessDeregistration', 1), (u'aMFNon3GPPAccessDeregistration', 2), (u'uDMDeregistration', 3), (u'unknown', 4)])
    UDMCancelLocationMethod._ext = []
    
    #-----< ServiceID >-----#
    ServiceID = SEQ(name=u'ServiceID', mode=MODE_TYPE)
    _ServiceID_nSSAI = SEQ_OF(name=u'nSSAI', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'NSSAI')), opt=True)
    _ServiceID_cAGID = SEQ_OF(name=u'cAGID', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __ServiceID_cAGID__item_ = STR_UTF8(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'CAGID')))
    _ServiceID_cAGID._cont = __ServiceID_cAGID__item_
    ServiceID._cont = ASN1Dict([
        (u'nSSAI', _ServiceID_nSSAI),
        (u'cAGID', _ServiceID_cAGID),
        ])
    ServiceID._ext = []
    
    #-----< CAGID >-----#
    CAGID = STR_UTF8(name=u'CAGID', mode=MODE_TYPE)
    
    #-----< SMSMessage >-----#
    SMSMessage = SEQ(name=u'SMSMessage', mode=MODE_TYPE)
    _SMSMessage_originatingSMSParty = SEQ(name=u'originatingSMSParty', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMSParty')))
    _SMSMessage_terminatingSMSParty = SEQ(name=u'terminatingSMSParty', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMSParty')))
    _SMSMessage_direction = ENUM(name=u'direction', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Direction')))
    _SMSMessage_linkTransferStatus = ENUM(name=u'linkTransferStatus', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMSTransferStatus')))
    _SMSMessage_otherMessage = BOOL(name=u'otherMessage', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMSOtherMessageIndication')), opt=True)
    _SMSMessage_location = SEQ(name=u'location', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Location')), opt=True)
    _SMSMessage_peerNFAddress = CHOICE(name=u'peerNFAddress', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMSNFAddress')), opt=True)
    _SMSMessage_peerNFType = ENUM(name=u'peerNFType', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMSNFType')), opt=True)
    _SMSMessage_sMSTPDUData = CHOICE(name=u'sMSTPDUData', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMSTPDUData')), opt=True)
    _SMSMessage_messageType = ENUM(name=u'messageType', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMSMessageType')), opt=True)
    _SMSMessage_rPMessageReference = INT(name=u'rPMessageReference', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMSRPMessageReference')), opt=True)
    SMSMessage._cont = ASN1Dict([
        (u'originatingSMSParty', _SMSMessage_originatingSMSParty),
        (u'terminatingSMSParty', _SMSMessage_terminatingSMSParty),
        (u'direction', _SMSMessage_direction),
        (u'linkTransferStatus', _SMSMessage_linkTransferStatus),
        (u'otherMessage', _SMSMessage_otherMessage),
        (u'location', _SMSMessage_location),
        (u'peerNFAddress', _SMSMessage_peerNFAddress),
        (u'peerNFType', _SMSMessage_peerNFType),
        (u'sMSTPDUData', _SMSMessage_sMSTPDUData),
        (u'messageType', _SMSMessage_messageType),
        (u'rPMessageReference', _SMSMessage_rPMessageReference),
        ])
    SMSMessage._ext = []
    
    #-----< SMSReport >-----#
    SMSReport = SEQ(name=u'SMSReport', mode=MODE_TYPE)
    _SMSReport_location = SEQ(name=u'location', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Location')), opt=True)
    _SMSReport_sMSTPDUData = CHOICE(name=u'sMSTPDUData', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMSTPDUData')))
    _SMSReport_messageType = ENUM(name=u'messageType', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMSMessageType')))
    _SMSReport_rPMessageReference = INT(name=u'rPMessageReference', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMSRPMessageReference')))
    SMSReport._cont = ASN1Dict([
        (u'location', _SMSReport_location),
        (u'sMSTPDUData', _SMSReport_sMSTPDUData),
        (u'messageType', _SMSReport_messageType),
        (u'rPMessageReference', _SMSReport_rPMessageReference),
        ])
    SMSReport._ext = []
    
    #-----< SMSAddress >-----#
    SMSAddress = OCT_STR(name=u'SMSAddress', mode=MODE_TYPE)
    SMSAddress._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=2, ub=12)], ev=None, er=[])
    
    #-----< SMSMessageType >-----#
    SMSMessageType = ENUM(name=u'SMSMessageType', mode=MODE_TYPE)
    SMSMessageType._cont = ASN1Dict([(u'deliver', 1), (u'deliverReportAck', 2), (u'deliverReportError', 3), (u'statusReport', 4), (u'command', 5), (u'submit', 6), (u'submitReportAck', 7), (u'submitReportError', 8), (u'reserved', 9)])
    SMSMessageType._ext = []
    
    #-----< SMSParty >-----#
    SMSParty = SEQ(name=u'SMSParty', mode=MODE_TYPE)
    _SMSParty_sUPI = CHOICE(name=u'sUPI', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SUPI')), opt=True)
    _SMSParty_pEI = CHOICE(name=u'pEI', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PEI')), opt=True)
    _SMSParty_gPSI = CHOICE(name=u'gPSI', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'GPSI')), opt=True)
    _SMSParty_sMSAddress = OCT_STR(name=u'sMSAddress', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMSAddress')), opt=True)
    SMSParty._cont = ASN1Dict([
        (u'sUPI', _SMSParty_sUPI),
        (u'pEI', _SMSParty_pEI),
        (u'gPSI', _SMSParty_gPSI),
        (u'sMSAddress', _SMSParty_sMSAddress),
        ])
    SMSParty._ext = []
    
    #-----< SMSTransferStatus >-----#
    SMSTransferStatus = ENUM(name=u'SMSTransferStatus', mode=MODE_TYPE)
    SMSTransferStatus._cont = ASN1Dict([(u'transferSucceeded', 1), (u'transferFailed', 2), (u'undefined', 3)])
    SMSTransferStatus._ext = []
    
    #-----< SMSOtherMessageIndication >-----#
    SMSOtherMessageIndication = BOOL(name=u'SMSOtherMessageIndication', mode=MODE_TYPE)
    
    #-----< SMSNFAddress >-----#
    SMSNFAddress = CHOICE(name=u'SMSNFAddress', mode=MODE_TYPE)
    _SMSNFAddress_iPAddress = CHOICE(name=u'iPAddress', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'IPAddress')))
    _SMSNFAddress_e164Number = STR_NUM(name=u'e164Number', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'E164Number')))
    SMSNFAddress._cont = ASN1Dict([
        (u'iPAddress', _SMSNFAddress_iPAddress),
        (u'e164Number', _SMSNFAddress_e164Number),
        ])
    SMSNFAddress._ext = []
    
    #-----< SMSNFType >-----#
    SMSNFType = ENUM(name=u'SMSNFType', mode=MODE_TYPE)
    SMSNFType._cont = ASN1Dict([(u'sMSGMSC', 1), (u'iWMSC', 2), (u'sMSRouter', 3)])
    SMSNFType._ext = []
    
    #-----< SMSRPMessageReference >-----#
    SMSRPMessageReference = INT(name=u'SMSRPMessageReference', mode=MODE_TYPE)
    SMSRPMessageReference._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    
    #-----< SMSTPDUData >-----#
    SMSTPDUData = CHOICE(name=u'SMSTPDUData', mode=MODE_TYPE)
    _SMSTPDUData_sMSTPDU = OCT_STR(name=u'sMSTPDU', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SMSTPDU')))
    _SMSTPDUData_truncatedSMSTPDU = OCT_STR(name=u'truncatedSMSTPDU', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'TruncatedSMSTPDU')))
    SMSTPDUData._cont = ASN1Dict([
        (u'sMSTPDU', _SMSTPDUData_sMSTPDU),
        (u'truncatedSMSTPDU', _SMSTPDUData_truncatedSMSTPDU),
        ])
    SMSTPDUData._ext = []
    
    #-----< SMSTPDU >-----#
    SMSTPDU = OCT_STR(name=u'SMSTPDU', mode=MODE_TYPE)
    SMSTPDU._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=270)], ev=None, er=[])
    
    #-----< TruncatedSMSTPDU >-----#
    TruncatedSMSTPDU = OCT_STR(name=u'TruncatedSMSTPDU', mode=MODE_TYPE)
    TruncatedSMSTPDU._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=130)], ev=None, er=[])
    
    #-----< MMSSend >-----#
    MMSSend = SEQ(name=u'MMSSend', mode=MODE_TYPE)
    _MMSSend_transactionID = STR_UTF8(name=u'transactionID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MMSSend_version = SEQ(name=u'version', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSVersion')))
    _MMSSend_dateTime = TIME_GEN(name=u'dateTime', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Timestamp')))
    _MMSSend_originatingMMSParty = SEQ(name=u'originatingMMSParty', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSParty')))
    _MMSSend_terminatingMMSParty = SEQ_OF(name=u'terminatingMMSParty', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __MMSSend_terminatingMMSParty__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'MMSParty')))
    _MMSSend_terminatingMMSParty._cont = __MMSSend_terminatingMMSParty__item_
    _MMSSend_cCRecipients = SEQ_OF(name=u'cCRecipients', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __MMSSend_cCRecipients__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'MMSParty')))
    _MMSSend_cCRecipients._cont = __MMSSend_cCRecipients__item_
    _MMSSend_bCCRecipients = SEQ_OF(name=u'bCCRecipients', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __MMSSend_bCCRecipients__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'MMSParty')))
    _MMSSend_bCCRecipients._cont = __MMSSend_bCCRecipients__item_
    _MMSSend_direction = ENUM(name=u'direction', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSDirection')))
    _MMSSend_subject = STR_UTF8(name=u'subject', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSSubject')), opt=True)
    _MMSSend_messageClass = ENUM(name=u'messageClass', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSMessageClass')), opt=True)
    _MMSSend_expiry = SEQ(name=u'expiry', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSExpiry')))
    _MMSSend_desiredDeliveryTime = TIME_GEN(name=u'desiredDeliveryTime', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Timestamp')), opt=True)
    _MMSSend_priority = ENUM(name=u'priority', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSPriority')), opt=True)
    _MMSSend_senderVisibility = BOOL(name=u'senderVisibility', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSSend_deliveryReport = BOOL(name=u'deliveryReport', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSSend_readReport = BOOL(name=u'readReport', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSSend_store = BOOL(name=u'store', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSSend_state = ENUM(name=u'state', mode=MODE_TYPE, tag=(18, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMState')), opt=True)
    _MMSSend_flags = SEQ(name=u'flags', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMFlags')), opt=True)
    _MMSSend_replyCharging = ENUM(name=u'replyCharging', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSReplyCharging')), opt=True)
    _MMSSend_applicID = STR_UTF8(name=u'applicID', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSSend_replyApplicID = STR_UTF8(name=u'replyApplicID', mode=MODE_TYPE, tag=(22, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSSend_auxApplicInfo = STR_UTF8(name=u'auxApplicInfo', mode=MODE_TYPE, tag=(23, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSSend_contentClass = ENUM(name=u'contentClass', mode=MODE_TYPE, tag=(24, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSContentClass')), opt=True)
    _MMSSend_dRMContent = BOOL(name=u'dRMContent', mode=MODE_TYPE, tag=(25, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSSend_adaptationAllowed = SEQ(name=u'adaptationAllowed', mode=MODE_TYPE, tag=(26, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSAdaptation')), opt=True)
    _MMSSend_contentType = STR_UTF8(name=u'contentType', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSContentType')))
    _MMSSend_responseStatus = ENUM(name=u'responseStatus', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSResponseStatus')))
    _MMSSend_responseStatusText = STR_UTF8(name=u'responseStatusText', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSSend_messageID = STR_UTF8(name=u'messageID', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    MMSSend._cont = ASN1Dict([
        (u'transactionID', _MMSSend_transactionID),
        (u'version', _MMSSend_version),
        (u'dateTime', _MMSSend_dateTime),
        (u'originatingMMSParty', _MMSSend_originatingMMSParty),
        (u'terminatingMMSParty', _MMSSend_terminatingMMSParty),
        (u'cCRecipients', _MMSSend_cCRecipients),
        (u'bCCRecipients', _MMSSend_bCCRecipients),
        (u'direction', _MMSSend_direction),
        (u'subject', _MMSSend_subject),
        (u'messageClass', _MMSSend_messageClass),
        (u'expiry', _MMSSend_expiry),
        (u'desiredDeliveryTime', _MMSSend_desiredDeliveryTime),
        (u'priority', _MMSSend_priority),
        (u'senderVisibility', _MMSSend_senderVisibility),
        (u'deliveryReport', _MMSSend_deliveryReport),
        (u'readReport', _MMSSend_readReport),
        (u'store', _MMSSend_store),
        (u'state', _MMSSend_state),
        (u'flags', _MMSSend_flags),
        (u'replyCharging', _MMSSend_replyCharging),
        (u'applicID', _MMSSend_applicID),
        (u'replyApplicID', _MMSSend_replyApplicID),
        (u'auxApplicInfo', _MMSSend_auxApplicInfo),
        (u'contentClass', _MMSSend_contentClass),
        (u'dRMContent', _MMSSend_dRMContent),
        (u'adaptationAllowed', _MMSSend_adaptationAllowed),
        (u'contentType', _MMSSend_contentType),
        (u'responseStatus', _MMSSend_responseStatus),
        (u'responseStatusText', _MMSSend_responseStatusText),
        (u'messageID', _MMSSend_messageID),
        ])
    MMSSend._ext = []
    
    #-----< MMSSendByNonLocalTarget >-----#
    MMSSendByNonLocalTarget = SEQ(name=u'MMSSendByNonLocalTarget', mode=MODE_TYPE)
    _MMSSendByNonLocalTarget_version = SEQ(name=u'version', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSVersion')))
    _MMSSendByNonLocalTarget_transactionID = STR_UTF8(name=u'transactionID', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MMSSendByNonLocalTarget_messageID = STR_UTF8(name=u'messageID', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MMSSendByNonLocalTarget_terminatingMMSParty = SEQ_OF(name=u'terminatingMMSParty', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MMSSendByNonLocalTarget_terminatingMMSParty__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'MMSParty')))
    _MMSSendByNonLocalTarget_terminatingMMSParty._cont = __MMSSendByNonLocalTarget_terminatingMMSParty__item_
    _MMSSendByNonLocalTarget_originatingMMSParty = SEQ(name=u'originatingMMSParty', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSParty')))
    _MMSSendByNonLocalTarget_direction = ENUM(name=u'direction', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSDirection')))
    _MMSSendByNonLocalTarget_contentType = STR_UTF8(name=u'contentType', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSContentType')))
    _MMSSendByNonLocalTarget_messageClass = ENUM(name=u'messageClass', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSMessageClass')), opt=True)
    _MMSSendByNonLocalTarget_dateTime = TIME_GEN(name=u'dateTime', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Timestamp')))
    _MMSSendByNonLocalTarget_expiry = SEQ(name=u'expiry', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSExpiry')), opt=True)
    _MMSSendByNonLocalTarget_deliveryReport = BOOL(name=u'deliveryReport', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSSendByNonLocalTarget_priority = ENUM(name=u'priority', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSPriority')), opt=True)
    _MMSSendByNonLocalTarget_senderVisibility = BOOL(name=u'senderVisibility', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSSendByNonLocalTarget_readReport = BOOL(name=u'readReport', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSSendByNonLocalTarget_subject = STR_UTF8(name=u'subject', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSSubject')), opt=True)
    _MMSSendByNonLocalTarget_forwardCount = INT(name=u'forwardCount', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSSendByNonLocalTarget_previouslySentBy = SEQ_OF(name=u'previouslySentBy', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSPreviouslySentBy')), opt=True)
    _MMSSendByNonLocalTarget_prevSentByDateTime = TIME_GEN(name=u'prevSentByDateTime', mode=MODE_TYPE, tag=(18, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Timestamp')), opt=True)
    _MMSSendByNonLocalTarget_applicID = STR_UTF8(name=u'applicID', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSSendByNonLocalTarget_replyApplicID = STR_UTF8(name=u'replyApplicID', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSSendByNonLocalTarget_auxApplicInfo = STR_UTF8(name=u'auxApplicInfo', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSSendByNonLocalTarget_contentClass = ENUM(name=u'contentClass', mode=MODE_TYPE, tag=(22, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSContentClass')), opt=True)
    _MMSSendByNonLocalTarget_dRMContent = BOOL(name=u'dRMContent', mode=MODE_TYPE, tag=(23, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSSendByNonLocalTarget_adaptationAllowed = SEQ(name=u'adaptationAllowed', mode=MODE_TYPE, tag=(24, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSAdaptation')), opt=True)
    MMSSendByNonLocalTarget._cont = ASN1Dict([
        (u'version', _MMSSendByNonLocalTarget_version),
        (u'transactionID', _MMSSendByNonLocalTarget_transactionID),
        (u'messageID', _MMSSendByNonLocalTarget_messageID),
        (u'terminatingMMSParty', _MMSSendByNonLocalTarget_terminatingMMSParty),
        (u'originatingMMSParty', _MMSSendByNonLocalTarget_originatingMMSParty),
        (u'direction', _MMSSendByNonLocalTarget_direction),
        (u'contentType', _MMSSendByNonLocalTarget_contentType),
        (u'messageClass', _MMSSendByNonLocalTarget_messageClass),
        (u'dateTime', _MMSSendByNonLocalTarget_dateTime),
        (u'expiry', _MMSSendByNonLocalTarget_expiry),
        (u'deliveryReport', _MMSSendByNonLocalTarget_deliveryReport),
        (u'priority', _MMSSendByNonLocalTarget_priority),
        (u'senderVisibility', _MMSSendByNonLocalTarget_senderVisibility),
        (u'readReport', _MMSSendByNonLocalTarget_readReport),
        (u'subject', _MMSSendByNonLocalTarget_subject),
        (u'forwardCount', _MMSSendByNonLocalTarget_forwardCount),
        (u'previouslySentBy', _MMSSendByNonLocalTarget_previouslySentBy),
        (u'prevSentByDateTime', _MMSSendByNonLocalTarget_prevSentByDateTime),
        (u'applicID', _MMSSendByNonLocalTarget_applicID),
        (u'replyApplicID', _MMSSendByNonLocalTarget_replyApplicID),
        (u'auxApplicInfo', _MMSSendByNonLocalTarget_auxApplicInfo),
        (u'contentClass', _MMSSendByNonLocalTarget_contentClass),
        (u'dRMContent', _MMSSendByNonLocalTarget_dRMContent),
        (u'adaptationAllowed', _MMSSendByNonLocalTarget_adaptationAllowed),
        ])
    MMSSendByNonLocalTarget._ext = []
    
    #-----< MMSNotification >-----#
    MMSNotification = SEQ(name=u'MMSNotification', mode=MODE_TYPE)
    _MMSNotification_transactionID = STR_UTF8(name=u'transactionID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MMSNotification_version = SEQ(name=u'version', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSVersion')))
    _MMSNotification_originatingMMSParty = SEQ(name=u'originatingMMSParty', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSParty')), opt=True)
    _MMSNotification_direction = ENUM(name=u'direction', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSDirection')))
    _MMSNotification_subject = STR_UTF8(name=u'subject', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSSubject')), opt=True)
    _MMSNotification_deliveryReportRequested = BOOL(name=u'deliveryReportRequested', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSNotification_stored = BOOL(name=u'stored', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSNotification_messageClass = ENUM(name=u'messageClass', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSMessageClass')))
    _MMSNotification_priority = ENUM(name=u'priority', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSPriority')), opt=True)
    _MMSNotification_messageSize = INT(name=u'messageSize', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MMSNotification_expiry = SEQ(name=u'expiry', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSExpiry')))
    _MMSNotification_replyCharging = ENUM(name=u'replyCharging', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSReplyCharging')), opt=True)
    MMSNotification._cont = ASN1Dict([
        (u'transactionID', _MMSNotification_transactionID),
        (u'version', _MMSNotification_version),
        (u'originatingMMSParty', _MMSNotification_originatingMMSParty),
        (u'direction', _MMSNotification_direction),
        (u'subject', _MMSNotification_subject),
        (u'deliveryReportRequested', _MMSNotification_deliveryReportRequested),
        (u'stored', _MMSNotification_stored),
        (u'messageClass', _MMSNotification_messageClass),
        (u'priority', _MMSNotification_priority),
        (u'messageSize', _MMSNotification_messageSize),
        (u'expiry', _MMSNotification_expiry),
        (u'replyCharging', _MMSNotification_replyCharging),
        ])
    MMSNotification._ext = []
    
    #-----< MMSSendToNonLocalTarget >-----#
    MMSSendToNonLocalTarget = SEQ(name=u'MMSSendToNonLocalTarget', mode=MODE_TYPE)
    _MMSSendToNonLocalTarget_version = SEQ(name=u'version', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSVersion')))
    _MMSSendToNonLocalTarget_transactionID = STR_UTF8(name=u'transactionID', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MMSSendToNonLocalTarget_messageID = STR_UTF8(name=u'messageID', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MMSSendToNonLocalTarget_terminatingMMSParty = SEQ_OF(name=u'terminatingMMSParty', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MMSSendToNonLocalTarget_terminatingMMSParty__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'MMSParty')))
    _MMSSendToNonLocalTarget_terminatingMMSParty._cont = __MMSSendToNonLocalTarget_terminatingMMSParty__item_
    _MMSSendToNonLocalTarget_originatingMMSParty = SEQ(name=u'originatingMMSParty', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSParty')))
    _MMSSendToNonLocalTarget_direction = ENUM(name=u'direction', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSDirection')))
    _MMSSendToNonLocalTarget_contentType = STR_UTF8(name=u'contentType', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSContentType')))
    _MMSSendToNonLocalTarget_messageClass = ENUM(name=u'messageClass', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSMessageClass')), opt=True)
    _MMSSendToNonLocalTarget_dateTime = TIME_GEN(name=u'dateTime', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Timestamp')))
    _MMSSendToNonLocalTarget_expiry = SEQ(name=u'expiry', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSExpiry')), opt=True)
    _MMSSendToNonLocalTarget_deliveryReport = BOOL(name=u'deliveryReport', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSSendToNonLocalTarget_priority = ENUM(name=u'priority', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSPriority')), opt=True)
    _MMSSendToNonLocalTarget_senderVisibility = BOOL(name=u'senderVisibility', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSSendToNonLocalTarget_readReport = BOOL(name=u'readReport', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSSendToNonLocalTarget_subject = STR_UTF8(name=u'subject', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSSubject')), opt=True)
    _MMSSendToNonLocalTarget_forwardCount = INT(name=u'forwardCount', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSSendToNonLocalTarget_previouslySentBy = SEQ_OF(name=u'previouslySentBy', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSPreviouslySentBy')), opt=True)
    _MMSSendToNonLocalTarget_prevSentByDateTime = TIME_GEN(name=u'prevSentByDateTime', mode=MODE_TYPE, tag=(18, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Timestamp')), opt=True)
    _MMSSendToNonLocalTarget_applicID = STR_UTF8(name=u'applicID', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSSendToNonLocalTarget_replyApplicID = STR_UTF8(name=u'replyApplicID', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSSendToNonLocalTarget_auxApplicInfo = STR_UTF8(name=u'auxApplicInfo', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSSendToNonLocalTarget_contentClass = ENUM(name=u'contentClass', mode=MODE_TYPE, tag=(22, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSContentClass')), opt=True)
    _MMSSendToNonLocalTarget_dRMContent = BOOL(name=u'dRMContent', mode=MODE_TYPE, tag=(23, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSSendToNonLocalTarget_adaptationAllowed = SEQ(name=u'adaptationAllowed', mode=MODE_TYPE, tag=(24, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSAdaptation')), opt=True)
    MMSSendToNonLocalTarget._cont = ASN1Dict([
        (u'version', _MMSSendToNonLocalTarget_version),
        (u'transactionID', _MMSSendToNonLocalTarget_transactionID),
        (u'messageID', _MMSSendToNonLocalTarget_messageID),
        (u'terminatingMMSParty', _MMSSendToNonLocalTarget_terminatingMMSParty),
        (u'originatingMMSParty', _MMSSendToNonLocalTarget_originatingMMSParty),
        (u'direction', _MMSSendToNonLocalTarget_direction),
        (u'contentType', _MMSSendToNonLocalTarget_contentType),
        (u'messageClass', _MMSSendToNonLocalTarget_messageClass),
        (u'dateTime', _MMSSendToNonLocalTarget_dateTime),
        (u'expiry', _MMSSendToNonLocalTarget_expiry),
        (u'deliveryReport', _MMSSendToNonLocalTarget_deliveryReport),
        (u'priority', _MMSSendToNonLocalTarget_priority),
        (u'senderVisibility', _MMSSendToNonLocalTarget_senderVisibility),
        (u'readReport', _MMSSendToNonLocalTarget_readReport),
        (u'subject', _MMSSendToNonLocalTarget_subject),
        (u'forwardCount', _MMSSendToNonLocalTarget_forwardCount),
        (u'previouslySentBy', _MMSSendToNonLocalTarget_previouslySentBy),
        (u'prevSentByDateTime', _MMSSendToNonLocalTarget_prevSentByDateTime),
        (u'applicID', _MMSSendToNonLocalTarget_applicID),
        (u'replyApplicID', _MMSSendToNonLocalTarget_replyApplicID),
        (u'auxApplicInfo', _MMSSendToNonLocalTarget_auxApplicInfo),
        (u'contentClass', _MMSSendToNonLocalTarget_contentClass),
        (u'dRMContent', _MMSSendToNonLocalTarget_dRMContent),
        (u'adaptationAllowed', _MMSSendToNonLocalTarget_adaptationAllowed),
        ])
    MMSSendToNonLocalTarget._ext = []
    
    #-----< MMSNotificationResponse >-----#
    MMSNotificationResponse = SEQ(name=u'MMSNotificationResponse', mode=MODE_TYPE)
    _MMSNotificationResponse_transactionID = STR_UTF8(name=u'transactionID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MMSNotificationResponse_version = SEQ(name=u'version', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSVersion')))
    _MMSNotificationResponse_direction = ENUM(name=u'direction', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSDirection')))
    _MMSNotificationResponse_status = ENUM(name=u'status', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMStatus')))
    _MMSNotificationResponse_reportAllowed = BOOL(name=u'reportAllowed', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    MMSNotificationResponse._cont = ASN1Dict([
        (u'transactionID', _MMSNotificationResponse_transactionID),
        (u'version', _MMSNotificationResponse_version),
        (u'direction', _MMSNotificationResponse_direction),
        (u'status', _MMSNotificationResponse_status),
        (u'reportAllowed', _MMSNotificationResponse_reportAllowed),
        ])
    MMSNotificationResponse._ext = []
    
    #-----< MMSRetrieval >-----#
    MMSRetrieval = SEQ(name=u'MMSRetrieval', mode=MODE_TYPE)
    _MMSRetrieval_transactionID = STR_UTF8(name=u'transactionID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MMSRetrieval_version = SEQ(name=u'version', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSVersion')))
    _MMSRetrieval_messageID = STR_UTF8(name=u'messageID', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MMSRetrieval_dateTime = TIME_GEN(name=u'dateTime', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Timestamp')))
    _MMSRetrieval_originatingMMSParty = SEQ(name=u'originatingMMSParty', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSParty')), opt=True)
    _MMSRetrieval_previouslySentBy = SEQ_OF(name=u'previouslySentBy', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSPreviouslySentBy')), opt=True)
    _MMSRetrieval_prevSentByDateTime = TIME_GEN(name=u'prevSentByDateTime', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Timestamp')), opt=True)
    _MMSRetrieval_terminatingMMSParty = SEQ_OF(name=u'terminatingMMSParty', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __MMSRetrieval_terminatingMMSParty__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'MMSParty')))
    _MMSRetrieval_terminatingMMSParty._cont = __MMSRetrieval_terminatingMMSParty__item_
    _MMSRetrieval_cCRecipients = SEQ_OF(name=u'cCRecipients', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __MMSRetrieval_cCRecipients__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'MMSParty')))
    _MMSRetrieval_cCRecipients._cont = __MMSRetrieval_cCRecipients__item_
    _MMSRetrieval_direction = ENUM(name=u'direction', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSDirection')))
    _MMSRetrieval_subject = STR_UTF8(name=u'subject', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSSubject')), opt=True)
    _MMSRetrieval_state = ENUM(name=u'state', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMState')), opt=True)
    _MMSRetrieval_flags = SEQ(name=u'flags', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMFlags')), opt=True)
    _MMSRetrieval_messageClass = ENUM(name=u'messageClass', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSMessageClass')), opt=True)
    _MMSRetrieval_priority = ENUM(name=u'priority', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSPriority')))
    _MMSRetrieval_deliveryReport = BOOL(name=u'deliveryReport', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSRetrieval_readReport = BOOL(name=u'readReport', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSRetrieval_replyCharging = ENUM(name=u'replyCharging', mode=MODE_TYPE, tag=(18, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSReplyCharging')), opt=True)
    _MMSRetrieval_retrieveStatus = ENUM(name=u'retrieveStatus', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSRetrieveStatus')), opt=True)
    _MMSRetrieval_retrieveStatusText = STR_UTF8(name=u'retrieveStatusText', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSRetrieval_applicID = STR_UTF8(name=u'applicID', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSRetrieval_replyApplicID = STR_UTF8(name=u'replyApplicID', mode=MODE_TYPE, tag=(22, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSRetrieval_auxApplicInfo = STR_UTF8(name=u'auxApplicInfo', mode=MODE_TYPE, tag=(23, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSRetrieval_contentClass = ENUM(name=u'contentClass', mode=MODE_TYPE, tag=(24, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSContentClass')), opt=True)
    _MMSRetrieval_dRMContent = BOOL(name=u'dRMContent', mode=MODE_TYPE, tag=(25, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSRetrieval_replaceID = STR_UTF8(name=u'replaceID', mode=MODE_TYPE, tag=(26, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSRetrieval_contentType = STR_UTF8(name=u'contentType', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    MMSRetrieval._cont = ASN1Dict([
        (u'transactionID', _MMSRetrieval_transactionID),
        (u'version', _MMSRetrieval_version),
        (u'messageID', _MMSRetrieval_messageID),
        (u'dateTime', _MMSRetrieval_dateTime),
        (u'originatingMMSParty', _MMSRetrieval_originatingMMSParty),
        (u'previouslySentBy', _MMSRetrieval_previouslySentBy),
        (u'prevSentByDateTime', _MMSRetrieval_prevSentByDateTime),
        (u'terminatingMMSParty', _MMSRetrieval_terminatingMMSParty),
        (u'cCRecipients', _MMSRetrieval_cCRecipients),
        (u'direction', _MMSRetrieval_direction),
        (u'subject', _MMSRetrieval_subject),
        (u'state', _MMSRetrieval_state),
        (u'flags', _MMSRetrieval_flags),
        (u'messageClass', _MMSRetrieval_messageClass),
        (u'priority', _MMSRetrieval_priority),
        (u'deliveryReport', _MMSRetrieval_deliveryReport),
        (u'readReport', _MMSRetrieval_readReport),
        (u'replyCharging', _MMSRetrieval_replyCharging),
        (u'retrieveStatus', _MMSRetrieval_retrieveStatus),
        (u'retrieveStatusText', _MMSRetrieval_retrieveStatusText),
        (u'applicID', _MMSRetrieval_applicID),
        (u'replyApplicID', _MMSRetrieval_replyApplicID),
        (u'auxApplicInfo', _MMSRetrieval_auxApplicInfo),
        (u'contentClass', _MMSRetrieval_contentClass),
        (u'dRMContent', _MMSRetrieval_dRMContent),
        (u'replaceID', _MMSRetrieval_replaceID),
        (u'contentType', _MMSRetrieval_contentType),
        ])
    MMSRetrieval._ext = []
    
    #-----< MMSDeliveryAck >-----#
    MMSDeliveryAck = SEQ(name=u'MMSDeliveryAck', mode=MODE_TYPE)
    _MMSDeliveryAck_transactionID = STR_UTF8(name=u'transactionID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MMSDeliveryAck_version = SEQ(name=u'version', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSVersion')))
    _MMSDeliveryAck_reportAllowed = BOOL(name=u'reportAllowed', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSDeliveryAck_status = ENUM(name=u'status', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMStatus')))
    _MMSDeliveryAck_direction = ENUM(name=u'direction', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSDirection')))
    MMSDeliveryAck._cont = ASN1Dict([
        (u'transactionID', _MMSDeliveryAck_transactionID),
        (u'version', _MMSDeliveryAck_version),
        (u'reportAllowed', _MMSDeliveryAck_reportAllowed),
        (u'status', _MMSDeliveryAck_status),
        (u'direction', _MMSDeliveryAck_direction),
        ])
    MMSDeliveryAck._ext = []
    
    #-----< MMSForward >-----#
    MMSForward = SEQ(name=u'MMSForward', mode=MODE_TYPE)
    _MMSForward_transactionID = STR_UTF8(name=u'transactionID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MMSForward_version = SEQ(name=u'version', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSVersion')))
    _MMSForward_dateTime = TIME_GEN(name=u'dateTime', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Timestamp')), opt=True)
    _MMSForward_originatingMMSParty = SEQ(name=u'originatingMMSParty', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSParty')))
    _MMSForward_terminatingMMSParty = SEQ_OF(name=u'terminatingMMSParty', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __MMSForward_terminatingMMSParty__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'MMSParty')))
    _MMSForward_terminatingMMSParty._cont = __MMSForward_terminatingMMSParty__item_
    _MMSForward_cCRecipients = SEQ_OF(name=u'cCRecipients', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __MMSForward_cCRecipients__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'MMSParty')))
    _MMSForward_cCRecipients._cont = __MMSForward_cCRecipients__item_
    _MMSForward_bCCRecipients = SEQ_OF(name=u'bCCRecipients', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __MMSForward_bCCRecipients__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'MMSParty')))
    _MMSForward_bCCRecipients._cont = __MMSForward_bCCRecipients__item_
    _MMSForward_direction = ENUM(name=u'direction', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSDirection')))
    _MMSForward_expiry = SEQ(name=u'expiry', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSExpiry')), opt=True)
    _MMSForward_desiredDeliveryTime = TIME_GEN(name=u'desiredDeliveryTime', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Timestamp')), opt=True)
    _MMSForward_deliveryReportAllowed = BOOL(name=u'deliveryReportAllowed', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSForward_deliveryReport = BOOL(name=u'deliveryReport', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSForward_store = BOOL(name=u'store', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSForward_state = ENUM(name=u'state', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMState')), opt=True)
    _MMSForward_flags = SEQ(name=u'flags', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMFlags')), opt=True)
    _MMSForward_contentLocationReq = STR_UTF8(name=u'contentLocationReq', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MMSForward_replyCharging = ENUM(name=u'replyCharging', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSReplyCharging')), opt=True)
    _MMSForward_responseStatus = ENUM(name=u'responseStatus', mode=MODE_TYPE, tag=(18, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSResponseStatus')))
    _MMSForward_responseStatusText = STR_UTF8(name=u'responseStatusText', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSForward_messageID = STR_UTF8(name=u'messageID', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSForward_contentLocationConf = STR_UTF8(name=u'contentLocationConf', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSForward_storeStatus = ENUM(name=u'storeStatus', mode=MODE_TYPE, tag=(22, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSStoreStatus')), opt=True)
    _MMSForward_storeStatusText = STR_UTF8(name=u'storeStatusText', mode=MODE_TYPE, tag=(23, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    MMSForward._cont = ASN1Dict([
        (u'transactionID', _MMSForward_transactionID),
        (u'version', _MMSForward_version),
        (u'dateTime', _MMSForward_dateTime),
        (u'originatingMMSParty', _MMSForward_originatingMMSParty),
        (u'terminatingMMSParty', _MMSForward_terminatingMMSParty),
        (u'cCRecipients', _MMSForward_cCRecipients),
        (u'bCCRecipients', _MMSForward_bCCRecipients),
        (u'direction', _MMSForward_direction),
        (u'expiry', _MMSForward_expiry),
        (u'desiredDeliveryTime', _MMSForward_desiredDeliveryTime),
        (u'deliveryReportAllowed', _MMSForward_deliveryReportAllowed),
        (u'deliveryReport', _MMSForward_deliveryReport),
        (u'store', _MMSForward_store),
        (u'state', _MMSForward_state),
        (u'flags', _MMSForward_flags),
        (u'contentLocationReq', _MMSForward_contentLocationReq),
        (u'replyCharging', _MMSForward_replyCharging),
        (u'responseStatus', _MMSForward_responseStatus),
        (u'responseStatusText', _MMSForward_responseStatusText),
        (u'messageID', _MMSForward_messageID),
        (u'contentLocationConf', _MMSForward_contentLocationConf),
        (u'storeStatus', _MMSForward_storeStatus),
        (u'storeStatusText', _MMSForward_storeStatusText),
        ])
    MMSForward._ext = []
    
    #-----< MMSDeleteFromRelay >-----#
    MMSDeleteFromRelay = SEQ(name=u'MMSDeleteFromRelay', mode=MODE_TYPE)
    _MMSDeleteFromRelay_transactionID = STR_UTF8(name=u'transactionID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MMSDeleteFromRelay_version = SEQ(name=u'version', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSVersion')))
    _MMSDeleteFromRelay_direction = ENUM(name=u'direction', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSDirection')))
    _MMSDeleteFromRelay_contentLocationReq = SEQ_OF(name=u'contentLocationReq', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MMSDeleteFromRelay_contentLocationReq__item_ = STR_UTF8(name='_item_', mode=MODE_TYPE)
    _MMSDeleteFromRelay_contentLocationReq._cont = __MMSDeleteFromRelay_contentLocationReq__item_
    _MMSDeleteFromRelay_contentLocationConf = SEQ_OF(name=u'contentLocationConf', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MMSDeleteFromRelay_contentLocationConf__item_ = STR_UTF8(name='_item_', mode=MODE_TYPE)
    _MMSDeleteFromRelay_contentLocationConf._cont = __MMSDeleteFromRelay_contentLocationConf__item_
    _MMSDeleteFromRelay_deleteResponseStatus = ENUM(name=u'deleteResponseStatus', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSDeleteResponseStatus')))
    _MMSDeleteFromRelay_deleteResponseText = SEQ_OF(name=u'deleteResponseText', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MMSDeleteFromRelay_deleteResponseText__item_ = STR_UTF8(name='_item_', mode=MODE_TYPE)
    _MMSDeleteFromRelay_deleteResponseText._cont = __MMSDeleteFromRelay_deleteResponseText__item_
    MMSDeleteFromRelay._cont = ASN1Dict([
        (u'transactionID', _MMSDeleteFromRelay_transactionID),
        (u'version', _MMSDeleteFromRelay_version),
        (u'direction', _MMSDeleteFromRelay_direction),
        (u'contentLocationReq', _MMSDeleteFromRelay_contentLocationReq),
        (u'contentLocationConf', _MMSDeleteFromRelay_contentLocationConf),
        (u'deleteResponseStatus', _MMSDeleteFromRelay_deleteResponseStatus),
        (u'deleteResponseText', _MMSDeleteFromRelay_deleteResponseText),
        ])
    MMSDeleteFromRelay._ext = []
    
    #-----< MMSMBoxStore >-----#
    MMSMBoxStore = SEQ(name=u'MMSMBoxStore', mode=MODE_TYPE)
    _MMSMBoxStore_transactionID = STR_UTF8(name=u'transactionID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MMSMBoxStore_version = SEQ(name=u'version', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSVersion')))
    _MMSMBoxStore_direction = ENUM(name=u'direction', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSDirection')))
    _MMSMBoxStore_contentLocationReq = STR_UTF8(name=u'contentLocationReq', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MMSMBoxStore_state = ENUM(name=u'state', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMState')), opt=True)
    _MMSMBoxStore_flags = SEQ(name=u'flags', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMFlags')), opt=True)
    _MMSMBoxStore_contentLocationConf = STR_UTF8(name=u'contentLocationConf', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSMBoxStore_storeStatus = ENUM(name=u'storeStatus', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSStoreStatus')))
    _MMSMBoxStore_storeStatusText = STR_UTF8(name=u'storeStatusText', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    MMSMBoxStore._cont = ASN1Dict([
        (u'transactionID', _MMSMBoxStore_transactionID),
        (u'version', _MMSMBoxStore_version),
        (u'direction', _MMSMBoxStore_direction),
        (u'contentLocationReq', _MMSMBoxStore_contentLocationReq),
        (u'state', _MMSMBoxStore_state),
        (u'flags', _MMSMBoxStore_flags),
        (u'contentLocationConf', _MMSMBoxStore_contentLocationConf),
        (u'storeStatus', _MMSMBoxStore_storeStatus),
        (u'storeStatusText', _MMSMBoxStore_storeStatusText),
        ])
    MMSMBoxStore._ext = []
    
    #-----< MMSMBoxUpload >-----#
    MMSMBoxUpload = SEQ(name=u'MMSMBoxUpload', mode=MODE_TYPE)
    _MMSMBoxUpload_transactionID = STR_UTF8(name=u'transactionID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MMSMBoxUpload_version = SEQ(name=u'version', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSVersion')))
    _MMSMBoxUpload_direction = ENUM(name=u'direction', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSDirection')))
    _MMSMBoxUpload_state = ENUM(name=u'state', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMState')), opt=True)
    _MMSMBoxUpload_flags = SEQ(name=u'flags', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMFlags')), opt=True)
    _MMSMBoxUpload_contentType = STR_UTF8(name=u'contentType', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MMSMBoxUpload_contentLocation = STR_UTF8(name=u'contentLocation', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSMBoxUpload_storeStatus = ENUM(name=u'storeStatus', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSStoreStatus')))
    _MMSMBoxUpload_storeStatusText = STR_UTF8(name=u'storeStatusText', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSMBoxUpload_mMessages = SEQ_OF(name=u'mMessages', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MMSMBoxUpload_mMessages__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'MMBoxDescription')))
    _MMSMBoxUpload_mMessages._cont = __MMSMBoxUpload_mMessages__item_
    MMSMBoxUpload._cont = ASN1Dict([
        (u'transactionID', _MMSMBoxUpload_transactionID),
        (u'version', _MMSMBoxUpload_version),
        (u'direction', _MMSMBoxUpload_direction),
        (u'state', _MMSMBoxUpload_state),
        (u'flags', _MMSMBoxUpload_flags),
        (u'contentType', _MMSMBoxUpload_contentType),
        (u'contentLocation', _MMSMBoxUpload_contentLocation),
        (u'storeStatus', _MMSMBoxUpload_storeStatus),
        (u'storeStatusText', _MMSMBoxUpload_storeStatusText),
        (u'mMessages', _MMSMBoxUpload_mMessages),
        ])
    MMSMBoxUpload._ext = []
    
    #-----< MMSMBoxDelete >-----#
    MMSMBoxDelete = SEQ(name=u'MMSMBoxDelete', mode=MODE_TYPE)
    _MMSMBoxDelete_transactionID = STR_UTF8(name=u'transactionID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MMSMBoxDelete_version = SEQ(name=u'version', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSVersion')))
    _MMSMBoxDelete_direction = ENUM(name=u'direction', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSDirection')))
    _MMSMBoxDelete_contentLocationReq = SEQ_OF(name=u'contentLocationReq', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MMSMBoxDelete_contentLocationReq__item_ = STR_UTF8(name='_item_', mode=MODE_TYPE)
    _MMSMBoxDelete_contentLocationReq._cont = __MMSMBoxDelete_contentLocationReq__item_
    _MMSMBoxDelete_contentLocationConf = SEQ_OF(name=u'contentLocationConf', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __MMSMBoxDelete_contentLocationConf__item_ = STR_UTF8(name='_item_', mode=MODE_TYPE)
    _MMSMBoxDelete_contentLocationConf._cont = __MMSMBoxDelete_contentLocationConf__item_
    _MMSMBoxDelete_responseStatus = ENUM(name=u'responseStatus', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSDeleteResponseStatus')))
    _MMSMBoxDelete_responseStatusText = STR_UTF8(name=u'responseStatusText', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    MMSMBoxDelete._cont = ASN1Dict([
        (u'transactionID', _MMSMBoxDelete_transactionID),
        (u'version', _MMSMBoxDelete_version),
        (u'direction', _MMSMBoxDelete_direction),
        (u'contentLocationReq', _MMSMBoxDelete_contentLocationReq),
        (u'contentLocationConf', _MMSMBoxDelete_contentLocationConf),
        (u'responseStatus', _MMSMBoxDelete_responseStatus),
        (u'responseStatusText', _MMSMBoxDelete_responseStatusText),
        ])
    MMSMBoxDelete._ext = []
    
    #-----< MMSDeliveryReport >-----#
    MMSDeliveryReport = SEQ(name=u'MMSDeliveryReport', mode=MODE_TYPE)
    _MMSDeliveryReport_version = SEQ(name=u'version', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSVersion')))
    _MMSDeliveryReport_messageID = STR_UTF8(name=u'messageID', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MMSDeliveryReport_terminatingMMSParty = SEQ_OF(name=u'terminatingMMSParty', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MMSDeliveryReport_terminatingMMSParty__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'MMSParty')))
    _MMSDeliveryReport_terminatingMMSParty._cont = __MMSDeliveryReport_terminatingMMSParty__item_
    _MMSDeliveryReport_mMSDateTime = TIME_GEN(name=u'mMSDateTime', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Timestamp')))
    _MMSDeliveryReport_responseStatus = ENUM(name=u'responseStatus', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSResponseStatus')))
    _MMSDeliveryReport_responseStatusText = STR_UTF8(name=u'responseStatusText', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSDeliveryReport_applicID = STR_UTF8(name=u'applicID', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSDeliveryReport_replyApplicID = STR_UTF8(name=u'replyApplicID', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSDeliveryReport_auxApplicInfo = STR_UTF8(name=u'auxApplicInfo', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    MMSDeliveryReport._cont = ASN1Dict([
        (u'version', _MMSDeliveryReport_version),
        (u'messageID', _MMSDeliveryReport_messageID),
        (u'terminatingMMSParty', _MMSDeliveryReport_terminatingMMSParty),
        (u'mMSDateTime', _MMSDeliveryReport_mMSDateTime),
        (u'responseStatus', _MMSDeliveryReport_responseStatus),
        (u'responseStatusText', _MMSDeliveryReport_responseStatusText),
        (u'applicID', _MMSDeliveryReport_applicID),
        (u'replyApplicID', _MMSDeliveryReport_replyApplicID),
        (u'auxApplicInfo', _MMSDeliveryReport_auxApplicInfo),
        ])
    MMSDeliveryReport._ext = []
    
    #-----< MMSDeliveryReportNonLocalTarget >-----#
    MMSDeliveryReportNonLocalTarget = SEQ(name=u'MMSDeliveryReportNonLocalTarget', mode=MODE_TYPE)
    _MMSDeliveryReportNonLocalTarget_version = SEQ(name=u'version', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSVersion')))
    _MMSDeliveryReportNonLocalTarget_transactionID = STR_UTF8(name=u'transactionID', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MMSDeliveryReportNonLocalTarget_messageID = STR_UTF8(name=u'messageID', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MMSDeliveryReportNonLocalTarget_terminatingMMSParty = SEQ_OF(name=u'terminatingMMSParty', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MMSDeliveryReportNonLocalTarget_terminatingMMSParty__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'MMSParty')))
    _MMSDeliveryReportNonLocalTarget_terminatingMMSParty._cont = __MMSDeliveryReportNonLocalTarget_terminatingMMSParty__item_
    _MMSDeliveryReportNonLocalTarget_originatingMMSParty = SEQ(name=u'originatingMMSParty', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSParty')))
    _MMSDeliveryReportNonLocalTarget_direction = ENUM(name=u'direction', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSDirection')))
    _MMSDeliveryReportNonLocalTarget_mMSDateTime = TIME_GEN(name=u'mMSDateTime', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Timestamp')))
    _MMSDeliveryReportNonLocalTarget_forwardToOriginator = BOOL(name=u'forwardToOriginator', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSDeliveryReportNonLocalTarget_status = ENUM(name=u'status', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMStatus')))
    _MMSDeliveryReportNonLocalTarget_statusExtension = ENUM(name=u'statusExtension', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMStatusExtension')))
    _MMSDeliveryReportNonLocalTarget_statusText = STR_UTF8(name=u'statusText', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMStatusText')))
    _MMSDeliveryReportNonLocalTarget_applicID = STR_UTF8(name=u'applicID', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSDeliveryReportNonLocalTarget_replyApplicID = STR_UTF8(name=u'replyApplicID', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSDeliveryReportNonLocalTarget_auxApplicInfo = STR_UTF8(name=u'auxApplicInfo', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    MMSDeliveryReportNonLocalTarget._cont = ASN1Dict([
        (u'version', _MMSDeliveryReportNonLocalTarget_version),
        (u'transactionID', _MMSDeliveryReportNonLocalTarget_transactionID),
        (u'messageID', _MMSDeliveryReportNonLocalTarget_messageID),
        (u'terminatingMMSParty', _MMSDeliveryReportNonLocalTarget_terminatingMMSParty),
        (u'originatingMMSParty', _MMSDeliveryReportNonLocalTarget_originatingMMSParty),
        (u'direction', _MMSDeliveryReportNonLocalTarget_direction),
        (u'mMSDateTime', _MMSDeliveryReportNonLocalTarget_mMSDateTime),
        (u'forwardToOriginator', _MMSDeliveryReportNonLocalTarget_forwardToOriginator),
        (u'status', _MMSDeliveryReportNonLocalTarget_status),
        (u'statusExtension', _MMSDeliveryReportNonLocalTarget_statusExtension),
        (u'statusText', _MMSDeliveryReportNonLocalTarget_statusText),
        (u'applicID', _MMSDeliveryReportNonLocalTarget_applicID),
        (u'replyApplicID', _MMSDeliveryReportNonLocalTarget_replyApplicID),
        (u'auxApplicInfo', _MMSDeliveryReportNonLocalTarget_auxApplicInfo),
        ])
    MMSDeliveryReportNonLocalTarget._ext = []
    
    #-----< MMSReadReport >-----#
    MMSReadReport = SEQ(name=u'MMSReadReport', mode=MODE_TYPE)
    _MMSReadReport_version = SEQ(name=u'version', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSVersion')))
    _MMSReadReport_messageID = STR_UTF8(name=u'messageID', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MMSReadReport_terminatingMMSParty = SEQ_OF(name=u'terminatingMMSParty', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MMSReadReport_terminatingMMSParty__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'MMSParty')))
    _MMSReadReport_terminatingMMSParty._cont = __MMSReadReport_terminatingMMSParty__item_
    _MMSReadReport_originatingMMSParty = SEQ_OF(name=u'originatingMMSParty', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MMSReadReport_originatingMMSParty__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'MMSParty')))
    _MMSReadReport_originatingMMSParty._cont = __MMSReadReport_originatingMMSParty__item_
    _MMSReadReport_direction = ENUM(name=u'direction', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSDirection')))
    _MMSReadReport_mMSDateTime = TIME_GEN(name=u'mMSDateTime', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Timestamp')))
    _MMSReadReport_readStatus = ENUM(name=u'readStatus', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSReadStatus')))
    _MMSReadReport_applicID = STR_UTF8(name=u'applicID', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSReadReport_replyApplicID = STR_UTF8(name=u'replyApplicID', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSReadReport_auxApplicInfo = STR_UTF8(name=u'auxApplicInfo', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    MMSReadReport._cont = ASN1Dict([
        (u'version', _MMSReadReport_version),
        (u'messageID', _MMSReadReport_messageID),
        (u'terminatingMMSParty', _MMSReadReport_terminatingMMSParty),
        (u'originatingMMSParty', _MMSReadReport_originatingMMSParty),
        (u'direction', _MMSReadReport_direction),
        (u'mMSDateTime', _MMSReadReport_mMSDateTime),
        (u'readStatus', _MMSReadReport_readStatus),
        (u'applicID', _MMSReadReport_applicID),
        (u'replyApplicID', _MMSReadReport_replyApplicID),
        (u'auxApplicInfo', _MMSReadReport_auxApplicInfo),
        ])
    MMSReadReport._ext = []
    
    #-----< MMSReadReportNonLocalTarget >-----#
    MMSReadReportNonLocalTarget = SEQ(name=u'MMSReadReportNonLocalTarget', mode=MODE_TYPE)
    _MMSReadReportNonLocalTarget_version = SEQ(name=u'version', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSVersion')))
    _MMSReadReportNonLocalTarget_transactionID = STR_UTF8(name=u'transactionID', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MMSReadReportNonLocalTarget_terminatingMMSParty = SEQ_OF(name=u'terminatingMMSParty', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MMSReadReportNonLocalTarget_terminatingMMSParty__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'MMSParty')))
    _MMSReadReportNonLocalTarget_terminatingMMSParty._cont = __MMSReadReportNonLocalTarget_terminatingMMSParty__item_
    _MMSReadReportNonLocalTarget_originatingMMSParty = SEQ_OF(name=u'originatingMMSParty', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MMSReadReportNonLocalTarget_originatingMMSParty__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'MMSParty')))
    _MMSReadReportNonLocalTarget_originatingMMSParty._cont = __MMSReadReportNonLocalTarget_originatingMMSParty__item_
    _MMSReadReportNonLocalTarget_direction = ENUM(name=u'direction', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSDirection')))
    _MMSReadReportNonLocalTarget_messageID = STR_UTF8(name=u'messageID', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MMSReadReportNonLocalTarget_mMSDateTime = TIME_GEN(name=u'mMSDateTime', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Timestamp')))
    _MMSReadReportNonLocalTarget_readStatus = ENUM(name=u'readStatus', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSReadStatus')))
    _MMSReadReportNonLocalTarget_readStatusText = STR_UTF8(name=u'readStatusText', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSReadStatusText')), opt=True)
    _MMSReadReportNonLocalTarget_applicID = STR_UTF8(name=u'applicID', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSReadReportNonLocalTarget_replyApplicID = STR_UTF8(name=u'replyApplicID', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSReadReportNonLocalTarget_auxApplicInfo = STR_UTF8(name=u'auxApplicInfo', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    MMSReadReportNonLocalTarget._cont = ASN1Dict([
        (u'version', _MMSReadReportNonLocalTarget_version),
        (u'transactionID', _MMSReadReportNonLocalTarget_transactionID),
        (u'terminatingMMSParty', _MMSReadReportNonLocalTarget_terminatingMMSParty),
        (u'originatingMMSParty', _MMSReadReportNonLocalTarget_originatingMMSParty),
        (u'direction', _MMSReadReportNonLocalTarget_direction),
        (u'messageID', _MMSReadReportNonLocalTarget_messageID),
        (u'mMSDateTime', _MMSReadReportNonLocalTarget_mMSDateTime),
        (u'readStatus', _MMSReadReportNonLocalTarget_readStatus),
        (u'readStatusText', _MMSReadReportNonLocalTarget_readStatusText),
        (u'applicID', _MMSReadReportNonLocalTarget_applicID),
        (u'replyApplicID', _MMSReadReportNonLocalTarget_replyApplicID),
        (u'auxApplicInfo', _MMSReadReportNonLocalTarget_auxApplicInfo),
        ])
    MMSReadReportNonLocalTarget._ext = []
    
    #-----< MMSCancel >-----#
    MMSCancel = SEQ(name=u'MMSCancel', mode=MODE_TYPE)
    _MMSCancel_transactionID = STR_UTF8(name=u'transactionID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MMSCancel_version = SEQ(name=u'version', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSVersion')))
    _MMSCancel_cancelID = STR_UTF8(name=u'cancelID', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MMSCancel_direction = ENUM(name=u'direction', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSDirection')))
    MMSCancel._cont = ASN1Dict([
        (u'transactionID', _MMSCancel_transactionID),
        (u'version', _MMSCancel_version),
        (u'cancelID', _MMSCancel_cancelID),
        (u'direction', _MMSCancel_direction),
        ])
    MMSCancel._ext = []
    
    #-----< MMSMBoxViewRequest >-----#
    MMSMBoxViewRequest = SEQ(name=u'MMSMBoxViewRequest', mode=MODE_TYPE)
    _MMSMBoxViewRequest_transactionID = STR_UTF8(name=u'transactionID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MMSMBoxViewRequest_version = SEQ(name=u'version', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSVersion')))
    _MMSMBoxViewRequest_contentLocation = STR_UTF8(name=u'contentLocation', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSMBoxViewRequest_state = SEQ_OF(name=u'state', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __MMSMBoxViewRequest_state__item_ = ENUM(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'MMState')))
    _MMSMBoxViewRequest_state._cont = __MMSMBoxViewRequest_state__item_
    _MMSMBoxViewRequest_flags = SEQ_OF(name=u'flags', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __MMSMBoxViewRequest_flags__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'MMFlags')))
    _MMSMBoxViewRequest_flags._cont = __MMSMBoxViewRequest_flags__item_
    _MMSMBoxViewRequest_start = INT(name=u'start', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSMBoxViewRequest_limit = INT(name=u'limit', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSMBoxViewRequest_attributes = SEQ_OF(name=u'attributes', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __MMSMBoxViewRequest_attributes__item_ = STR_UTF8(name='_item_', mode=MODE_TYPE)
    _MMSMBoxViewRequest_attributes._cont = __MMSMBoxViewRequest_attributes__item_
    _MMSMBoxViewRequest_totals = INT(name=u'totals', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSMBoxViewRequest_quotas = SEQ(name=u'quotas', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSQuota')), opt=True)
    MMSMBoxViewRequest._cont = ASN1Dict([
        (u'transactionID', _MMSMBoxViewRequest_transactionID),
        (u'version', _MMSMBoxViewRequest_version),
        (u'contentLocation', _MMSMBoxViewRequest_contentLocation),
        (u'state', _MMSMBoxViewRequest_state),
        (u'flags', _MMSMBoxViewRequest_flags),
        (u'start', _MMSMBoxViewRequest_start),
        (u'limit', _MMSMBoxViewRequest_limit),
        (u'attributes', _MMSMBoxViewRequest_attributes),
        (u'totals', _MMSMBoxViewRequest_totals),
        (u'quotas', _MMSMBoxViewRequest_quotas),
        ])
    MMSMBoxViewRequest._ext = []
    
    #-----< MMSMBoxViewResponse >-----#
    MMSMBoxViewResponse = SEQ(name=u'MMSMBoxViewResponse', mode=MODE_TYPE)
    _MMSMBoxViewResponse_transactionID = STR_UTF8(name=u'transactionID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MMSMBoxViewResponse_version = SEQ(name=u'version', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSVersion')))
    _MMSMBoxViewResponse_contentLocation = STR_UTF8(name=u'contentLocation', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSMBoxViewResponse_state = SEQ_OF(name=u'state', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __MMSMBoxViewResponse_state__item_ = ENUM(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'MMState')))
    _MMSMBoxViewResponse_state._cont = __MMSMBoxViewResponse_state__item_
    _MMSMBoxViewResponse_flags = SEQ_OF(name=u'flags', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __MMSMBoxViewResponse_flags__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'MMFlags')))
    _MMSMBoxViewResponse_flags._cont = __MMSMBoxViewResponse_flags__item_
    _MMSMBoxViewResponse_start = INT(name=u'start', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSMBoxViewResponse_limit = INT(name=u'limit', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSMBoxViewResponse_attributes = SEQ_OF(name=u'attributes', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __MMSMBoxViewResponse_attributes__item_ = STR_UTF8(name='_item_', mode=MODE_TYPE)
    _MMSMBoxViewResponse_attributes._cont = __MMSMBoxViewResponse_attributes__item_
    _MMSMBoxViewResponse_mMSTotals = BOOL(name=u'mMSTotals', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSMBoxViewResponse_mMSQuotas = BOOL(name=u'mMSQuotas', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSMBoxViewResponse_mMessages = SEQ_OF(name=u'mMessages', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MMSMBoxViewResponse_mMessages__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'MMBoxDescription')))
    _MMSMBoxViewResponse_mMessages._cont = __MMSMBoxViewResponse_mMessages__item_
    MMSMBoxViewResponse._cont = ASN1Dict([
        (u'transactionID', _MMSMBoxViewResponse_transactionID),
        (u'version', _MMSMBoxViewResponse_version),
        (u'contentLocation', _MMSMBoxViewResponse_contentLocation),
        (u'state', _MMSMBoxViewResponse_state),
        (u'flags', _MMSMBoxViewResponse_flags),
        (u'start', _MMSMBoxViewResponse_start),
        (u'limit', _MMSMBoxViewResponse_limit),
        (u'attributes', _MMSMBoxViewResponse_attributes),
        (u'mMSTotals', _MMSMBoxViewResponse_mMSTotals),
        (u'mMSQuotas', _MMSMBoxViewResponse_mMSQuotas),
        (u'mMessages', _MMSMBoxViewResponse_mMessages),
        ])
    MMSMBoxViewResponse._ext = []
    
    #-----< MMBoxDescription >-----#
    MMBoxDescription = SEQ(name=u'MMBoxDescription', mode=MODE_TYPE)
    _MMBoxDescription_contentLocation = STR_UTF8(name=u'contentLocation', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMBoxDescription_messageID = STR_UTF8(name=u'messageID', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMBoxDescription_state = ENUM(name=u'state', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMState')), opt=True)
    _MMBoxDescription_flags = SEQ_OF(name=u'flags', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __MMBoxDescription_flags__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'MMFlags')))
    _MMBoxDescription_flags._cont = __MMBoxDescription_flags__item_
    _MMBoxDescription_dateTime = TIME_GEN(name=u'dateTime', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Timestamp')), opt=True)
    _MMBoxDescription_originatingMMSParty = SEQ(name=u'originatingMMSParty', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSParty')), opt=True)
    _MMBoxDescription_terminatingMMSParty = SEQ_OF(name=u'terminatingMMSParty', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __MMBoxDescription_terminatingMMSParty__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'MMSParty')))
    _MMBoxDescription_terminatingMMSParty._cont = __MMBoxDescription_terminatingMMSParty__item_
    _MMBoxDescription_cCRecipients = SEQ_OF(name=u'cCRecipients', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __MMBoxDescription_cCRecipients__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'MMSParty')))
    _MMBoxDescription_cCRecipients._cont = __MMBoxDescription_cCRecipients__item_
    _MMBoxDescription_bCCRecipients = SEQ_OF(name=u'bCCRecipients', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __MMBoxDescription_bCCRecipients__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'MMSParty')))
    _MMBoxDescription_bCCRecipients._cont = __MMBoxDescription_bCCRecipients__item_
    _MMBoxDescription_messageClass = ENUM(name=u'messageClass', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSMessageClass')), opt=True)
    _MMBoxDescription_subject = STR_UTF8(name=u'subject', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSSubject')), opt=True)
    _MMBoxDescription_priority = ENUM(name=u'priority', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSPriority')), opt=True)
    _MMBoxDescription_deliveryTime = TIME_GEN(name=u'deliveryTime', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Timestamp')), opt=True)
    _MMBoxDescription_readReport = BOOL(name=u'readReport', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMBoxDescription_messageSize = INT(name=u'messageSize', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMBoxDescription_replyCharging = ENUM(name=u'replyCharging', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSReplyCharging')), opt=True)
    _MMBoxDescription_previouslySentBy = SEQ_OF(name=u'previouslySentBy', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSPreviouslySentBy')), opt=True)
    _MMBoxDescription_previouslySentByDateTime = TIME_GEN(name=u'previouslySentByDateTime', mode=MODE_TYPE, tag=(18, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Timestamp')), opt=True)
    _MMBoxDescription_contentType = STR_UTF8(name=u'contentType', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    MMBoxDescription._cont = ASN1Dict([
        (u'contentLocation', _MMBoxDescription_contentLocation),
        (u'messageID', _MMBoxDescription_messageID),
        (u'state', _MMBoxDescription_state),
        (u'flags', _MMBoxDescription_flags),
        (u'dateTime', _MMBoxDescription_dateTime),
        (u'originatingMMSParty', _MMBoxDescription_originatingMMSParty),
        (u'terminatingMMSParty', _MMBoxDescription_terminatingMMSParty),
        (u'cCRecipients', _MMBoxDescription_cCRecipients),
        (u'bCCRecipients', _MMBoxDescription_bCCRecipients),
        (u'messageClass', _MMBoxDescription_messageClass),
        (u'subject', _MMBoxDescription_subject),
        (u'priority', _MMBoxDescription_priority),
        (u'deliveryTime', _MMBoxDescription_deliveryTime),
        (u'readReport', _MMBoxDescription_readReport),
        (u'messageSize', _MMBoxDescription_messageSize),
        (u'replyCharging', _MMBoxDescription_replyCharging),
        (u'previouslySentBy', _MMBoxDescription_previouslySentBy),
        (u'previouslySentByDateTime', _MMBoxDescription_previouslySentByDateTime),
        (u'contentType', _MMBoxDescription_contentType),
        ])
    MMBoxDescription._ext = []
    
    #-----< MMSCCPDU >-----#
    MMSCCPDU = SEQ(name=u'MMSCCPDU', mode=MODE_TYPE)
    _MMSCCPDU_version = SEQ(name=u'version', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSVersion')))
    _MMSCCPDU_transactionID = STR_UTF8(name=u'transactionID', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MMSCCPDU_mMSContent = OCT_STR(name=u'mMSContent', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    MMSCCPDU._cont = ASN1Dict([
        (u'version', _MMSCCPDU_version),
        (u'transactionID', _MMSCCPDU_transactionID),
        (u'mMSContent', _MMSCCPDU_mMSContent),
        ])
    MMSCCPDU._ext = []
    
    #-----< MMSAdaptation >-----#
    MMSAdaptation = SEQ(name=u'MMSAdaptation', mode=MODE_TYPE)
    _MMSAdaptation_allowed = BOOL(name=u'allowed', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MMSAdaptation_overriden = BOOL(name=u'overriden', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    MMSAdaptation._cont = ASN1Dict([
        (u'allowed', _MMSAdaptation_allowed),
        (u'overriden', _MMSAdaptation_overriden),
        ])
    MMSAdaptation._ext = []
    
    #-----< MMSCancelStatus >-----#
    MMSCancelStatus = ENUM(name=u'MMSCancelStatus', mode=MODE_TYPE)
    MMSCancelStatus._cont = ASN1Dict([(u'cancelRequestSuccessfullyReceived', 1), (u'cancelRequestCorrupted', 2)])
    MMSCancelStatus._ext = []
    
    #-----< MMSContentClass >-----#
    MMSContentClass = ENUM(name=u'MMSContentClass', mode=MODE_TYPE)
    MMSContentClass._cont = ASN1Dict([(u'text', 1), (u'imageBasic', 2), (u'imageRich', 3), (u'videoBasic', 4), (u'videoRich', 5), (u'megaPixel', 6), (u'contentBasic', 7), (u'contentRich', 8)])
    MMSContentClass._ext = []
    
    #-----< MMSContentType >-----#
    MMSContentType = STR_UTF8(name=u'MMSContentType', mode=MODE_TYPE)
    
    #-----< MMSDeleteResponseStatus >-----#
    MMSDeleteResponseStatus = ENUM(name=u'MMSDeleteResponseStatus', mode=MODE_TYPE)
    MMSDeleteResponseStatus._cont = ASN1Dict([(u'ok', 1), (u'errorUnspecified', 2), (u'errorServiceDenied', 3), (u'errorMessageFormatCorrupt', 4), (u'errorSendingAddressUnresolved', 5), (u'errorMessageNotFound', 6), (u'errorNetworkProblem', 7), (u'errorContentNotAccepted', 8), (u'errorUnsupportedMessage', 9), (u'errorTransientFailure', 10), (u'errorTransientSendingAddressUnresolved', 11), (u'errorTransientMessageNotFound', 12), (u'errorTransientNetworkProblem', 13), (u'errorTransientPartialSuccess', 14), (u'errorPermanentFailure', 15), (u'errorPermanentServiceDenied', 16), (u'errorPermanentMessageFormatCorrupt', 17), (u'errorPermanentSendingAddressUnresolved', 18), (u'errorPermanentMessageNotFound', 19), (u'errorPermanentContentNotAccepted', 20), (u'errorPermanentReplyChargingLimitationsNotMet', 21), (u'errorPermanentReplyChargingRequestNotAccepted', 22), (u'errorPermanentReplyChargingForwardingDenied', 23), (u'errorPermanentReplyChargingNotSupported', 24), (u'errorPermanentAddressHidingNotSupported', 25), (u'errorPermanentLackOfPrepaid', 26)])
    MMSDeleteResponseStatus._ext = []
    
    #-----< MMSDirection >-----#
    MMSDirection = ENUM(name=u'MMSDirection', mode=MODE_TYPE)
    MMSDirection._cont = ASN1Dict([(u'fromTarget', 0), (u'toTarget', 1)])
    MMSDirection._ext = []
    
    #-----< MMSElementDescriptor >-----#
    MMSElementDescriptor = SEQ(name=u'MMSElementDescriptor', mode=MODE_TYPE)
    _MMSElementDescriptor_reference = STR_UTF8(name=u'reference', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MMSElementDescriptor_parameter = STR_UTF8(name=u'parameter', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MMSElementDescriptor_value = STR_UTF8(name=u'value', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    MMSElementDescriptor._cont = ASN1Dict([
        (u'reference', _MMSElementDescriptor_reference),
        (u'parameter', _MMSElementDescriptor_parameter),
        (u'value', _MMSElementDescriptor_value),
        ])
    MMSElementDescriptor._ext = []
    
    #-----< MMSExpiry >-----#
    MMSExpiry = SEQ(name=u'MMSExpiry', mode=MODE_TYPE)
    _MMSExpiry_expiryPeriod = INT(name=u'expiryPeriod', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MMSExpiry_periodFormat = ENUM(name=u'periodFormat', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSPeriodFormat')))
    MMSExpiry._cont = ASN1Dict([
        (u'expiryPeriod', _MMSExpiry_expiryPeriod),
        (u'periodFormat', _MMSExpiry_periodFormat),
        ])
    MMSExpiry._ext = []
    
    #-----< MMFlags >-----#
    MMFlags = SEQ(name=u'MMFlags', mode=MODE_TYPE)
    _MMFlags_length = INT(name=u'length', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MMFlags_flag = ENUM(name=u'flag', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMStateFlag')))
    _MMFlags_flagString = STR_UTF8(name=u'flagString', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    MMFlags._cont = ASN1Dict([
        (u'length', _MMFlags_length),
        (u'flag', _MMFlags_flag),
        (u'flagString', _MMFlags_flagString),
        ])
    MMFlags._ext = []
    
    #-----< MMSMessageClass >-----#
    MMSMessageClass = ENUM(name=u'MMSMessageClass', mode=MODE_TYPE)
    MMSMessageClass._cont = ASN1Dict([(u'personal', 1), (u'advertisement', 2), (u'informational', 3), (u'auto', 4)])
    MMSMessageClass._ext = []
    
    #-----< MMSParty >-----#
    MMSParty = SEQ(name=u'MMSParty', mode=MODE_TYPE)
    _MMSParty_mMSPartyIDs = SEQ_OF(name=u'mMSPartyIDs', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __MMSParty_mMSPartyIDs__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'MMSPartyID')))
    _MMSParty_mMSPartyIDs._cont = __MMSParty_mMSPartyIDs__item_
    _MMSParty_nonLocalID = ENUM(name=u'nonLocalID', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'NonLocalID')))
    MMSParty._cont = ASN1Dict([
        (u'mMSPartyIDs', _MMSParty_mMSPartyIDs),
        (u'nonLocalID', _MMSParty_nonLocalID),
        ])
    MMSParty._ext = []
    
    #-----< MMSPartyID >-----#
    MMSPartyID = CHOICE(name=u'MMSPartyID', mode=MODE_TYPE)
    _MMSPartyID_e164Number = STR_NUM(name=u'e164Number', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'E164Number')))
    _MMSPartyID_emailAddress = STR_UTF8(name=u'emailAddress', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'EmailAddress')))
    _MMSPartyID_iMSI = STR_NUM(name=u'iMSI', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'IMSI')))
    _MMSPartyID_iMPU = CHOICE(name=u'iMPU', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'IMPU')))
    _MMSPartyID_iMPI = STR_UTF8(name=u'iMPI', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'IMPI')))
    _MMSPartyID_sUPI = CHOICE(name=u'sUPI', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SUPI')))
    _MMSPartyID_gPSI = CHOICE(name=u'gPSI', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'GPSI')))
    MMSPartyID._cont = ASN1Dict([
        (u'e164Number', _MMSPartyID_e164Number),
        (u'emailAddress', _MMSPartyID_emailAddress),
        (u'iMSI', _MMSPartyID_iMSI),
        (u'iMPU', _MMSPartyID_iMPU),
        (u'iMPI', _MMSPartyID_iMPI),
        (u'sUPI', _MMSPartyID_sUPI),
        (u'gPSI', _MMSPartyID_gPSI),
        ])
    MMSPartyID._ext = []
    
    #-----< MMSPeriodFormat >-----#
    MMSPeriodFormat = ENUM(name=u'MMSPeriodFormat', mode=MODE_TYPE)
    MMSPeriodFormat._cont = ASN1Dict([(u'absolute', 1), (u'relative', 2)])
    MMSPeriodFormat._ext = []
    
    #-----< MMSPreviouslySent >-----#
    MMSPreviouslySent = SEQ(name=u'MMSPreviouslySent', mode=MODE_TYPE)
    _MMSPreviouslySent_previouslySentByParty = SEQ(name=u'previouslySentByParty', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSParty')))
    _MMSPreviouslySent_sequenceNumber = INT(name=u'sequenceNumber', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MMSPreviouslySent_previousSendDateTime = TIME_GEN(name=u'previousSendDateTime', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Timestamp')))
    MMSPreviouslySent._cont = ASN1Dict([
        (u'previouslySentByParty', _MMSPreviouslySent_previouslySentByParty),
        (u'sequenceNumber', _MMSPreviouslySent_sequenceNumber),
        (u'previousSendDateTime', _MMSPreviouslySent_previousSendDateTime),
        ])
    MMSPreviouslySent._ext = []
    
    #-----< MMSPreviouslySentBy >-----#
    MMSPreviouslySentBy = SEQ_OF(name=u'MMSPreviouslySentBy', mode=MODE_TYPE)
    _MMSPreviouslySentBy__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'MMSPreviouslySent')))
    MMSPreviouslySentBy._cont = _MMSPreviouslySentBy__item_
    
    #-----< MMSPriority >-----#
    MMSPriority = ENUM(name=u'MMSPriority', mode=MODE_TYPE)
    MMSPriority._cont = ASN1Dict([(u'low', 1), (u'normal', 2), (u'high', 3)])
    MMSPriority._ext = []
    
    #-----< MMSQuota >-----#
    MMSQuota = SEQ(name=u'MMSQuota', mode=MODE_TYPE)
    _MMSQuota_quota = INT(name=u'quota', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MMSQuota_quotaUnit = ENUM(name=u'quotaUnit', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMSQuotaUnit')))
    MMSQuota._cont = ASN1Dict([
        (u'quota', _MMSQuota_quota),
        (u'quotaUnit', _MMSQuota_quotaUnit),
        ])
    MMSQuota._ext = []
    
    #-----< MMSQuotaUnit >-----#
    MMSQuotaUnit = ENUM(name=u'MMSQuotaUnit', mode=MODE_TYPE)
    MMSQuotaUnit._cont = ASN1Dict([(u'numMessages', 1), (u'bytes', 2)])
    MMSQuotaUnit._ext = []
    
    #-----< MMSReadStatus >-----#
    MMSReadStatus = ENUM(name=u'MMSReadStatus', mode=MODE_TYPE)
    MMSReadStatus._cont = ASN1Dict([(u'read', 1), (u'deletedWithoutBeingRead', 2)])
    MMSReadStatus._ext = []
    
    #-----< MMSReadStatusText >-----#
    MMSReadStatusText = STR_UTF8(name=u'MMSReadStatusText', mode=MODE_TYPE)
    
    #-----< MMSReplyCharging >-----#
    MMSReplyCharging = ENUM(name=u'MMSReplyCharging', mode=MODE_TYPE)
    MMSReplyCharging._cont = ASN1Dict([(u'requested', 0), (u'requestedTextOnly', 1), (u'accepted', 2), (u'acceptedTextOnly', 3)])
    MMSReplyCharging._ext = []
    
    #-----< MMSResponseStatus >-----#
    MMSResponseStatus = ENUM(name=u'MMSResponseStatus', mode=MODE_TYPE)
    MMSResponseStatus._cont = ASN1Dict([(u'ok', 1), (u'errorUnspecified', 2), (u'errorServiceDenied', 3), (u'errorMessageFormatCorrupt', 4), (u'errorSendingAddressUnresolved', 5), (u'errorMessageNotFound', 6), (u'errorNetworkProblem', 7), (u'errorContentNotAccepted', 8), (u'errorUnsupportedMessage', 9), (u'errorTransientFailure', 10), (u'errorTransientSendingAddressUnresolved', 11), (u'errorTransientMessageNotFound', 12), (u'errorTransientNetworkProblem', 13), (u'errorTransientPartialSuccess', 14), (u'errorPermanentFailure', 15), (u'errorPermanentServiceDenied', 16), (u'errorPermanentMessageFormatCorrupt', 17), (u'errorPermanentSendingAddressUnresolved', 18), (u'errorPermanentMessageNotFound', 19), (u'errorPermanentContentNotAccepted', 20), (u'errorPermanentReplyChargingLimitationsNotMet', 21), (u'errorPermanentReplyChargingRequestNotAccepted', 22), (u'errorPermanentReplyChargingForwardingDenied', 23), (u'errorPermanentReplyChargingNotSupported', 24), (u'errorPermanentAddressHidingNotSupported', 25), (u'errorPermanentLackOfPrepaid', 26)])
    MMSResponseStatus._ext = []
    
    #-----< MMSRetrieveStatus >-----#
    MMSRetrieveStatus = ENUM(name=u'MMSRetrieveStatus', mode=MODE_TYPE)
    MMSRetrieveStatus._cont = ASN1Dict([(u'success', 1), (u'errorTransientFailure', 2), (u'errorTransientMessageNotFound', 3), (u'errorTransientNetworkProblem', 4), (u'errorPermanentFailure', 5), (u'errorPermanentServiceDenied', 6), (u'errorPermanentMessageNotFound', 7), (u'errorPermanentContentUnsupported', 8)])
    MMSRetrieveStatus._ext = []
    
    #-----< MMSStoreStatus >-----#
    MMSStoreStatus = ENUM(name=u'MMSStoreStatus', mode=MODE_TYPE)
    MMSStoreStatus._cont = ASN1Dict([(u'success', 1), (u'errorTransientFailure', 2), (u'errorTransientNetworkProblem', 3), (u'errorPermanentFailure', 4), (u'errorPermanentServiceDenied', 5), (u'errorPermanentMessageFormatCorrupt', 6), (u'errorPermanentMessageNotFound', 7), (u'errorMMBoxFull', 8)])
    MMSStoreStatus._ext = []
    
    #-----< MMState >-----#
    MMState = ENUM(name=u'MMState', mode=MODE_TYPE)
    MMState._cont = ASN1Dict([(u'draft', 1), (u'sent', 2), (u'new', 3), (u'retrieved', 4), (u'forwarded', 5)])
    MMState._ext = []
    
    #-----< MMStateFlag >-----#
    MMStateFlag = ENUM(name=u'MMStateFlag', mode=MODE_TYPE)
    MMStateFlag._cont = ASN1Dict([(u'add', 1), (u'remove', 2), (u'filter', 3)])
    MMStateFlag._ext = []
    
    #-----< MMStatus >-----#
    MMStatus = ENUM(name=u'MMStatus', mode=MODE_TYPE)
    MMStatus._cont = ASN1Dict([(u'expired', 1), (u'retrieved', 2), (u'rejected', 3), (u'deferred', 4), (u'unrecognized', 5), (u'indeterminate', 6), (u'forwarded', 7), (u'unreachable', 8)])
    MMStatus._ext = []
    
    #-----< MMStatusExtension >-----#
    MMStatusExtension = ENUM(name=u'MMStatusExtension', mode=MODE_TYPE)
    MMStatusExtension._cont = ASN1Dict([(u'rejectionByMMSRecipient', 0), (u'rejectionByOtherRS', 1)])
    MMStatusExtension._ext = []
    
    #-----< MMStatusText >-----#
    MMStatusText = STR_UTF8(name=u'MMStatusText', mode=MODE_TYPE)
    
    #-----< MMSSubject >-----#
    MMSSubject = STR_UTF8(name=u'MMSSubject', mode=MODE_TYPE)
    
    #-----< MMSVersion >-----#
    MMSVersion = SEQ(name=u'MMSVersion', mode=MODE_TYPE)
    _MMSVersion_majorVersion = INT(name=u'majorVersion', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MMSVersion_minorVersion = INT(name=u'minorVersion', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    MMSVersion._cont = ASN1Dict([
        (u'majorVersion', _MMSVersion_majorVersion),
        (u'minorVersion', _MMSVersion_minorVersion),
        ])
    MMSVersion._ext = []
    
    #-----< PTCRegistration >-----#
    PTCRegistration = SEQ(name=u'PTCRegistration', mode=MODE_TYPE)
    _PTCRegistration_pTCTargetInformation = SEQ(name=u'pTCTargetInformation', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCTargetInformation')))
    _PTCRegistration_pTCServerURI = STR_UTF8(name=u'pTCServerURI', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _PTCRegistration_pTCRegistrationRequest = ENUM(name=u'pTCRegistrationRequest', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCRegistrationRequest')))
    _PTCRegistration_pTCRegistrationOutcome = ENUM(name=u'pTCRegistrationOutcome', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCRegistrationOutcome')))
    PTCRegistration._cont = ASN1Dict([
        (u'pTCTargetInformation', _PTCRegistration_pTCTargetInformation),
        (u'pTCServerURI', _PTCRegistration_pTCServerURI),
        (u'pTCRegistrationRequest', _PTCRegistration_pTCRegistrationRequest),
        (u'pTCRegistrationOutcome', _PTCRegistration_pTCRegistrationOutcome),
        ])
    PTCRegistration._ext = []
    
    #-----< PTCSessionInitiation >-----#
    PTCSessionInitiation = SEQ(name=u'PTCSessionInitiation', mode=MODE_TYPE)
    _PTCSessionInitiation_pTCTargetInformation = SEQ(name=u'pTCTargetInformation', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCTargetInformation')))
    _PTCSessionInitiation_pTCDirection = ENUM(name=u'pTCDirection', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Direction')))
    _PTCSessionInitiation_pTCServerURI = STR_UTF8(name=u'pTCServerURI', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _PTCSessionInitiation_pTCSessionInfo = SEQ(name=u'pTCSessionInfo', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCSessionInfo')))
    _PTCSessionInitiation_pTCOriginatingID = SEQ(name=u'pTCOriginatingID', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCTargetInformation')))
    _PTCSessionInitiation_pTCParticipants = SEQ_OF(name=u'pTCParticipants', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __PTCSessionInitiation_pTCParticipants__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'PTCTargetInformation')))
    _PTCSessionInitiation_pTCParticipants._cont = __PTCSessionInitiation_pTCParticipants__item_
    _PTCSessionInitiation_pTCParticipantPresenceStatus = SEQ_OF(name=u'pTCParticipantPresenceStatus', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MultipleParticipantPresenceStatus')), opt=True)
    _PTCSessionInitiation_location = SEQ(name=u'location', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Location')), opt=True)
    _PTCSessionInitiation_pTCBearerCapability = STR_UTF8(name=u'pTCBearerCapability', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _PTCSessionInitiation_pTCHost = SEQ(name=u'pTCHost', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCTargetInformation')), opt=True)
    PTCSessionInitiation._cont = ASN1Dict([
        (u'pTCTargetInformation', _PTCSessionInitiation_pTCTargetInformation),
        (u'pTCDirection', _PTCSessionInitiation_pTCDirection),
        (u'pTCServerURI', _PTCSessionInitiation_pTCServerURI),
        (u'pTCSessionInfo', _PTCSessionInitiation_pTCSessionInfo),
        (u'pTCOriginatingID', _PTCSessionInitiation_pTCOriginatingID),
        (u'pTCParticipants', _PTCSessionInitiation_pTCParticipants),
        (u'pTCParticipantPresenceStatus', _PTCSessionInitiation_pTCParticipantPresenceStatus),
        (u'location', _PTCSessionInitiation_location),
        (u'pTCBearerCapability', _PTCSessionInitiation_pTCBearerCapability),
        (u'pTCHost', _PTCSessionInitiation_pTCHost),
        ])
    PTCSessionInitiation._ext = []
    
    #-----< PTCSessionAbandon >-----#
    PTCSessionAbandon = SEQ(name=u'PTCSessionAbandon', mode=MODE_TYPE)
    _PTCSessionAbandon_pTCTargetInformation = SEQ(name=u'pTCTargetInformation', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCTargetInformation')))
    _PTCSessionAbandon_pTCDirection = ENUM(name=u'pTCDirection', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Direction')))
    _PTCSessionAbandon_pTCSessionInfo = SEQ(name=u'pTCSessionInfo', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCSessionInfo')))
    _PTCSessionAbandon_location = SEQ(name=u'location', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Location')), opt=True)
    _PTCSessionAbandon_pTCAbandonCause = INT(name=u'pTCAbandonCause', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    PTCSessionAbandon._cont = ASN1Dict([
        (u'pTCTargetInformation', _PTCSessionAbandon_pTCTargetInformation),
        (u'pTCDirection', _PTCSessionAbandon_pTCDirection),
        (u'pTCSessionInfo', _PTCSessionAbandon_pTCSessionInfo),
        (u'location', _PTCSessionAbandon_location),
        (u'pTCAbandonCause', _PTCSessionAbandon_pTCAbandonCause),
        ])
    PTCSessionAbandon._ext = []
    
    #-----< PTCSessionStart >-----#
    PTCSessionStart = SEQ(name=u'PTCSessionStart', mode=MODE_TYPE)
    _PTCSessionStart_pTCTargetInformation = SEQ(name=u'pTCTargetInformation', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCTargetInformation')))
    _PTCSessionStart_pTCDirection = ENUM(name=u'pTCDirection', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Direction')))
    _PTCSessionStart_pTCServerURI = STR_UTF8(name=u'pTCServerURI', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _PTCSessionStart_pTCSessionInfo = SEQ(name=u'pTCSessionInfo', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCSessionInfo')))
    _PTCSessionStart_pTCOriginatingID = SEQ(name=u'pTCOriginatingID', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCTargetInformation')))
    _PTCSessionStart_pTCParticipants = SEQ_OF(name=u'pTCParticipants', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __PTCSessionStart_pTCParticipants__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'PTCTargetInformation')))
    _PTCSessionStart_pTCParticipants._cont = __PTCSessionStart_pTCParticipants__item_
    _PTCSessionStart_pTCParticipantPresenceStatus = SEQ_OF(name=u'pTCParticipantPresenceStatus', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MultipleParticipantPresenceStatus')), opt=True)
    _PTCSessionStart_location = SEQ(name=u'location', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Location')), opt=True)
    _PTCSessionStart_pTCHost = SEQ(name=u'pTCHost', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCTargetInformation')), opt=True)
    _PTCSessionStart_pTCBearerCapability = STR_UTF8(name=u'pTCBearerCapability', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    PTCSessionStart._cont = ASN1Dict([
        (u'pTCTargetInformation', _PTCSessionStart_pTCTargetInformation),
        (u'pTCDirection', _PTCSessionStart_pTCDirection),
        (u'pTCServerURI', _PTCSessionStart_pTCServerURI),
        (u'pTCSessionInfo', _PTCSessionStart_pTCSessionInfo),
        (u'pTCOriginatingID', _PTCSessionStart_pTCOriginatingID),
        (u'pTCParticipants', _PTCSessionStart_pTCParticipants),
        (u'pTCParticipantPresenceStatus', _PTCSessionStart_pTCParticipantPresenceStatus),
        (u'location', _PTCSessionStart_location),
        (u'pTCHost', _PTCSessionStart_pTCHost),
        (u'pTCBearerCapability', _PTCSessionStart_pTCBearerCapability),
        ])
    PTCSessionStart._ext = []
    
    #-----< PTCSessionEnd >-----#
    PTCSessionEnd = SEQ(name=u'PTCSessionEnd', mode=MODE_TYPE)
    _PTCSessionEnd_pTCTargetInformation = SEQ(name=u'pTCTargetInformation', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCTargetInformation')))
    _PTCSessionEnd_pTCDirection = ENUM(name=u'pTCDirection', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Direction')))
    _PTCSessionEnd_pTCServerURI = STR_UTF8(name=u'pTCServerURI', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _PTCSessionEnd_pTCSessionInfo = SEQ(name=u'pTCSessionInfo', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCSessionInfo')))
    _PTCSessionEnd_pTCParticipants = SEQ_OF(name=u'pTCParticipants', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __PTCSessionEnd_pTCParticipants__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'PTCTargetInformation')))
    _PTCSessionEnd_pTCParticipants._cont = __PTCSessionEnd_pTCParticipants__item_
    _PTCSessionEnd_location = SEQ(name=u'location', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Location')), opt=True)
    _PTCSessionEnd_pTCSessionEndCause = ENUM(name=u'pTCSessionEndCause', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCSessionEndCause')))
    PTCSessionEnd._cont = ASN1Dict([
        (u'pTCTargetInformation', _PTCSessionEnd_pTCTargetInformation),
        (u'pTCDirection', _PTCSessionEnd_pTCDirection),
        (u'pTCServerURI', _PTCSessionEnd_pTCServerURI),
        (u'pTCSessionInfo', _PTCSessionEnd_pTCSessionInfo),
        (u'pTCParticipants', _PTCSessionEnd_pTCParticipants),
        (u'location', _PTCSessionEnd_location),
        (u'pTCSessionEndCause', _PTCSessionEnd_pTCSessionEndCause),
        ])
    PTCSessionEnd._ext = []
    
    #-----< PTCStartOfInterception >-----#
    PTCStartOfInterception = SEQ(name=u'PTCStartOfInterception', mode=MODE_TYPE)
    _PTCStartOfInterception_pTCTargetInformation = SEQ(name=u'pTCTargetInformation', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCTargetInformation')))
    _PTCStartOfInterception_pTCDirection = ENUM(name=u'pTCDirection', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Direction')))
    _PTCStartOfInterception_preEstSessionID = SEQ(name=u'preEstSessionID', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCSessionInfo')), opt=True)
    _PTCStartOfInterception_pTCOriginatingID = SEQ(name=u'pTCOriginatingID', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCTargetInformation')))
    _PTCStartOfInterception_pTCSessionInfo = SEQ(name=u'pTCSessionInfo', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCSessionInfo')), opt=True)
    _PTCStartOfInterception_pTCHost = SEQ(name=u'pTCHost', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCTargetInformation')), opt=True)
    _PTCStartOfInterception_pTCParticipants = SEQ_OF(name=u'pTCParticipants', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __PTCStartOfInterception_pTCParticipants__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'PTCTargetInformation')))
    _PTCStartOfInterception_pTCParticipants._cont = __PTCStartOfInterception_pTCParticipants__item_
    _PTCStartOfInterception_pTCMediaStreamAvail = BOOL(name=u'pTCMediaStreamAvail', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _PTCStartOfInterception_pTCBearerCapability = STR_UTF8(name=u'pTCBearerCapability', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    PTCStartOfInterception._cont = ASN1Dict([
        (u'pTCTargetInformation', _PTCStartOfInterception_pTCTargetInformation),
        (u'pTCDirection', _PTCStartOfInterception_pTCDirection),
        (u'preEstSessionID', _PTCStartOfInterception_preEstSessionID),
        (u'pTCOriginatingID', _PTCStartOfInterception_pTCOriginatingID),
        (u'pTCSessionInfo', _PTCStartOfInterception_pTCSessionInfo),
        (u'pTCHost', _PTCStartOfInterception_pTCHost),
        (u'pTCParticipants', _PTCStartOfInterception_pTCParticipants),
        (u'pTCMediaStreamAvail', _PTCStartOfInterception_pTCMediaStreamAvail),
        (u'pTCBearerCapability', _PTCStartOfInterception_pTCBearerCapability),
        ])
    PTCStartOfInterception._ext = []
    
    #-----< PTCPreEstablishedSession >-----#
    PTCPreEstablishedSession = SEQ(name=u'PTCPreEstablishedSession', mode=MODE_TYPE)
    _PTCPreEstablishedSession_pTCTargetInformation = SEQ(name=u'pTCTargetInformation', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCTargetInformation')))
    _PTCPreEstablishedSession_pTCServerURI = STR_UTF8(name=u'pTCServerURI', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _PTCPreEstablishedSession_rTPSetting = SEQ(name=u'rTPSetting', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'RTPSetting')))
    _PTCPreEstablishedSession_pTCMediaCapability = STR_UTF8(name=u'pTCMediaCapability', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _PTCPreEstablishedSession_pTCPreEstSessionID = SEQ(name=u'pTCPreEstSessionID', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCSessionInfo')))
    _PTCPreEstablishedSession_pTCPreEstStatus = ENUM(name=u'pTCPreEstStatus', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCPreEstStatus')))
    _PTCPreEstablishedSession_pTCMediaStreamAvail = BOOL(name=u'pTCMediaStreamAvail', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _PTCPreEstablishedSession_location = SEQ(name=u'location', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Location')), opt=True)
    _PTCPreEstablishedSession_pTCFailureCode = ENUM(name=u'pTCFailureCode', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCFailureCode')), opt=True)
    PTCPreEstablishedSession._cont = ASN1Dict([
        (u'pTCTargetInformation', _PTCPreEstablishedSession_pTCTargetInformation),
        (u'pTCServerURI', _PTCPreEstablishedSession_pTCServerURI),
        (u'rTPSetting', _PTCPreEstablishedSession_rTPSetting),
        (u'pTCMediaCapability', _PTCPreEstablishedSession_pTCMediaCapability),
        (u'pTCPreEstSessionID', _PTCPreEstablishedSession_pTCPreEstSessionID),
        (u'pTCPreEstStatus', _PTCPreEstablishedSession_pTCPreEstStatus),
        (u'pTCMediaStreamAvail', _PTCPreEstablishedSession_pTCMediaStreamAvail),
        (u'location', _PTCPreEstablishedSession_location),
        (u'pTCFailureCode', _PTCPreEstablishedSession_pTCFailureCode),
        ])
    PTCPreEstablishedSession._ext = []
    
    #-----< PTCInstantPersonalAlert >-----#
    PTCInstantPersonalAlert = SEQ(name=u'PTCInstantPersonalAlert', mode=MODE_TYPE)
    _PTCInstantPersonalAlert_pTCTargetInformation = SEQ(name=u'pTCTargetInformation', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCTargetInformation')))
    _PTCInstantPersonalAlert_pTCIPAPartyID = SEQ(name=u'pTCIPAPartyID', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCTargetInformation')))
    _PTCInstantPersonalAlert_pTCIPADirection = ENUM(name=u'pTCIPADirection', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Direction')))
    PTCInstantPersonalAlert._cont = ASN1Dict([
        (u'pTCTargetInformation', _PTCInstantPersonalAlert_pTCTargetInformation),
        (u'pTCIPAPartyID', _PTCInstantPersonalAlert_pTCIPAPartyID),
        (u'pTCIPADirection', _PTCInstantPersonalAlert_pTCIPADirection),
        ])
    PTCInstantPersonalAlert._ext = []
    
    #-----< PTCPartyJoin >-----#
    PTCPartyJoin = SEQ(name=u'PTCPartyJoin', mode=MODE_TYPE)
    _PTCPartyJoin_pTCTargetInformation = SEQ(name=u'pTCTargetInformation', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCTargetInformation')))
    _PTCPartyJoin_pTCDirection = ENUM(name=u'pTCDirection', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Direction')))
    _PTCPartyJoin_pTCSessionInfo = SEQ(name=u'pTCSessionInfo', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCSessionInfo')))
    _PTCPartyJoin_pTCParticipants = SEQ_OF(name=u'pTCParticipants', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __PTCPartyJoin_pTCParticipants__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'PTCTargetInformation')))
    _PTCPartyJoin_pTCParticipants._cont = __PTCPartyJoin_pTCParticipants__item_
    _PTCPartyJoin_pTCParticipantPresenceStatus = SEQ_OF(name=u'pTCParticipantPresenceStatus', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MultipleParticipantPresenceStatus')), opt=True)
    _PTCPartyJoin_pTCMediaStreamAvail = BOOL(name=u'pTCMediaStreamAvail', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _PTCPartyJoin_pTCBearerCapability = STR_UTF8(name=u'pTCBearerCapability', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    PTCPartyJoin._cont = ASN1Dict([
        (u'pTCTargetInformation', _PTCPartyJoin_pTCTargetInformation),
        (u'pTCDirection', _PTCPartyJoin_pTCDirection),
        (u'pTCSessionInfo', _PTCPartyJoin_pTCSessionInfo),
        (u'pTCParticipants', _PTCPartyJoin_pTCParticipants),
        (u'pTCParticipantPresenceStatus', _PTCPartyJoin_pTCParticipantPresenceStatus),
        (u'pTCMediaStreamAvail', _PTCPartyJoin_pTCMediaStreamAvail),
        (u'pTCBearerCapability', _PTCPartyJoin_pTCBearerCapability),
        ])
    PTCPartyJoin._ext = []
    
    #-----< PTCPartyDrop >-----#
    PTCPartyDrop = SEQ(name=u'PTCPartyDrop', mode=MODE_TYPE)
    _PTCPartyDrop_pTCTargetInformation = SEQ(name=u'pTCTargetInformation', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCTargetInformation')))
    _PTCPartyDrop_pTCDirection = ENUM(name=u'pTCDirection', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Direction')))
    _PTCPartyDrop_pTCSessionInfo = SEQ(name=u'pTCSessionInfo', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCSessionInfo')))
    _PTCPartyDrop_pTCPartyDrop = SEQ(name=u'pTCPartyDrop', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCTargetInformation')))
    _PTCPartyDrop_pTCParticipantPresenceStatus = SEQ(name=u'pTCParticipantPresenceStatus', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCParticipantPresenceStatus')), opt=True)
    PTCPartyDrop._cont = ASN1Dict([
        (u'pTCTargetInformation', _PTCPartyDrop_pTCTargetInformation),
        (u'pTCDirection', _PTCPartyDrop_pTCDirection),
        (u'pTCSessionInfo', _PTCPartyDrop_pTCSessionInfo),
        (u'pTCPartyDrop', _PTCPartyDrop_pTCPartyDrop),
        (u'pTCParticipantPresenceStatus', _PTCPartyDrop_pTCParticipantPresenceStatus),
        ])
    PTCPartyDrop._ext = []
    
    #-----< PTCPartyHold >-----#
    PTCPartyHold = SEQ(name=u'PTCPartyHold', mode=MODE_TYPE)
    _PTCPartyHold_pTCTargetInformation = SEQ(name=u'pTCTargetInformation', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCTargetInformation')))
    _PTCPartyHold_pTCDirection = ENUM(name=u'pTCDirection', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Direction')))
    _PTCPartyHold_pTCSessionInfo = SEQ(name=u'pTCSessionInfo', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCSessionInfo')))
    _PTCPartyHold_pTCParticipants = SEQ_OF(name=u'pTCParticipants', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __PTCPartyHold_pTCParticipants__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'PTCTargetInformation')))
    _PTCPartyHold_pTCParticipants._cont = __PTCPartyHold_pTCParticipants__item_
    _PTCPartyHold_pTCHoldID = SEQ_OF(name=u'pTCHoldID', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __PTCPartyHold_pTCHoldID__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'PTCTargetInformation')))
    _PTCPartyHold_pTCHoldID._cont = __PTCPartyHold_pTCHoldID__item_
    _PTCPartyHold_pTCHoldRetrieveInd = BOOL(name=u'pTCHoldRetrieveInd', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    PTCPartyHold._cont = ASN1Dict([
        (u'pTCTargetInformation', _PTCPartyHold_pTCTargetInformation),
        (u'pTCDirection', _PTCPartyHold_pTCDirection),
        (u'pTCSessionInfo', _PTCPartyHold_pTCSessionInfo),
        (u'pTCParticipants', _PTCPartyHold_pTCParticipants),
        (u'pTCHoldID', _PTCPartyHold_pTCHoldID),
        (u'pTCHoldRetrieveInd', _PTCPartyHold_pTCHoldRetrieveInd),
        ])
    PTCPartyHold._ext = []
    
    #-----< PTCMediaModification >-----#
    PTCMediaModification = SEQ(name=u'PTCMediaModification', mode=MODE_TYPE)
    _PTCMediaModification_pTCTargetInformation = SEQ(name=u'pTCTargetInformation', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCTargetInformation')))
    _PTCMediaModification_pTCDirection = ENUM(name=u'pTCDirection', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Direction')))
    _PTCMediaModification_pTCSessionInfo = SEQ(name=u'pTCSessionInfo', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCSessionInfo')))
    _PTCMediaModification_pTCMediaStreamAvail = BOOL(name=u'pTCMediaStreamAvail', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _PTCMediaModification_pTCBearerCapability = STR_UTF8(name=u'pTCBearerCapability', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    PTCMediaModification._cont = ASN1Dict([
        (u'pTCTargetInformation', _PTCMediaModification_pTCTargetInformation),
        (u'pTCDirection', _PTCMediaModification_pTCDirection),
        (u'pTCSessionInfo', _PTCMediaModification_pTCSessionInfo),
        (u'pTCMediaStreamAvail', _PTCMediaModification_pTCMediaStreamAvail),
        (u'pTCBearerCapability', _PTCMediaModification_pTCBearerCapability),
        ])
    PTCMediaModification._ext = []
    
    #-----< PTCGroupAdvertisement >-----#
    PTCGroupAdvertisement = SEQ(name=u'PTCGroupAdvertisement', mode=MODE_TYPE)
    _PTCGroupAdvertisement_pTCTargetInformation = SEQ(name=u'pTCTargetInformation', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCTargetInformation')))
    _PTCGroupAdvertisement_pTCDirection = ENUM(name=u'pTCDirection', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Direction')))
    _PTCGroupAdvertisement_pTCIDList = SEQ_OF(name=u'pTCIDList', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __PTCGroupAdvertisement_pTCIDList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'PTCTargetInformation')))
    _PTCGroupAdvertisement_pTCIDList._cont = __PTCGroupAdvertisement_pTCIDList__item_
    _PTCGroupAdvertisement_pTCGroupAuthRule = ENUM(name=u'pTCGroupAuthRule', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCGroupAuthRule')), opt=True)
    _PTCGroupAdvertisement_pTCGroupAdSender = SEQ(name=u'pTCGroupAdSender', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCTargetInformation')))
    _PTCGroupAdvertisement_pTCGroupNickname = STR_UTF8(name=u'pTCGroupNickname', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    PTCGroupAdvertisement._cont = ASN1Dict([
        (u'pTCTargetInformation', _PTCGroupAdvertisement_pTCTargetInformation),
        (u'pTCDirection', _PTCGroupAdvertisement_pTCDirection),
        (u'pTCIDList', _PTCGroupAdvertisement_pTCIDList),
        (u'pTCGroupAuthRule', _PTCGroupAdvertisement_pTCGroupAuthRule),
        (u'pTCGroupAdSender', _PTCGroupAdvertisement_pTCGroupAdSender),
        (u'pTCGroupNickname', _PTCGroupAdvertisement_pTCGroupNickname),
        ])
    PTCGroupAdvertisement._ext = []
    
    #-----< PTCFloorControl >-----#
    PTCFloorControl = SEQ(name=u'PTCFloorControl', mode=MODE_TYPE)
    _PTCFloorControl_pTCTargetInformation = SEQ(name=u'pTCTargetInformation', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCTargetInformation')))
    _PTCFloorControl_pTCDirection = ENUM(name=u'pTCDirection', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Direction')))
    _PTCFloorControl_pTCSessioninfo = SEQ(name=u'pTCSessioninfo', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCSessionInfo')))
    _PTCFloorControl_pTCFloorActivity = SEQ_OF(name=u'pTCFloorActivity', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __PTCFloorControl_pTCFloorActivity__item_ = ENUM(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'PTCFloorActivity')))
    _PTCFloorControl_pTCFloorActivity._cont = __PTCFloorControl_pTCFloorActivity__item_
    _PTCFloorControl_pTCFloorSpeakerID = SEQ(name=u'pTCFloorSpeakerID', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCTargetInformation')), opt=True)
    _PTCFloorControl_pTCMaxTBTime = INT(name=u'pTCMaxTBTime', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _PTCFloorControl_pTCQueuedFloorControl = BOOL(name=u'pTCQueuedFloorControl', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _PTCFloorControl_pTCQueuedPosition = INT(name=u'pTCQueuedPosition', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _PTCFloorControl_pTCTalkBurstPriority = ENUM(name=u'pTCTalkBurstPriority', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCTBPriorityLevel')), opt=True)
    _PTCFloorControl_pTCTalkBurstReason = ENUM(name=u'pTCTalkBurstReason', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCTBReasonCode')), opt=True)
    PTCFloorControl._cont = ASN1Dict([
        (u'pTCTargetInformation', _PTCFloorControl_pTCTargetInformation),
        (u'pTCDirection', _PTCFloorControl_pTCDirection),
        (u'pTCSessioninfo', _PTCFloorControl_pTCSessioninfo),
        (u'pTCFloorActivity', _PTCFloorControl_pTCFloorActivity),
        (u'pTCFloorSpeakerID', _PTCFloorControl_pTCFloorSpeakerID),
        (u'pTCMaxTBTime', _PTCFloorControl_pTCMaxTBTime),
        (u'pTCQueuedFloorControl', _PTCFloorControl_pTCQueuedFloorControl),
        (u'pTCQueuedPosition', _PTCFloorControl_pTCQueuedPosition),
        (u'pTCTalkBurstPriority', _PTCFloorControl_pTCTalkBurstPriority),
        (u'pTCTalkBurstReason', _PTCFloorControl_pTCTalkBurstReason),
        ])
    PTCFloorControl._ext = []
    
    #-----< PTCTargetPresence >-----#
    PTCTargetPresence = SEQ(name=u'PTCTargetPresence', mode=MODE_TYPE)
    _PTCTargetPresence_pTCTargetInformation = SEQ(name=u'pTCTargetInformation', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCTargetInformation')))
    _PTCTargetPresence_pTCTargetPresenceStatus = SEQ(name=u'pTCTargetPresenceStatus', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCParticipantPresenceStatus')))
    PTCTargetPresence._cont = ASN1Dict([
        (u'pTCTargetInformation', _PTCTargetPresence_pTCTargetInformation),
        (u'pTCTargetPresenceStatus', _PTCTargetPresence_pTCTargetPresenceStatus),
        ])
    PTCTargetPresence._ext = []
    
    #-----< PTCParticipantPresence >-----#
    PTCParticipantPresence = SEQ(name=u'PTCParticipantPresence', mode=MODE_TYPE)
    _PTCParticipantPresence_pTCTargetInformation = SEQ(name=u'pTCTargetInformation', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCTargetInformation')))
    _PTCParticipantPresence_pTCParticipantPresenceStatus = SEQ(name=u'pTCParticipantPresenceStatus', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCParticipantPresenceStatus')))
    PTCParticipantPresence._cont = ASN1Dict([
        (u'pTCTargetInformation', _PTCParticipantPresence_pTCTargetInformation),
        (u'pTCParticipantPresenceStatus', _PTCParticipantPresence_pTCParticipantPresenceStatus),
        ])
    PTCParticipantPresence._ext = []
    
    #-----< PTCListManagement >-----#
    PTCListManagement = SEQ(name=u'PTCListManagement', mode=MODE_TYPE)
    _PTCListManagement_pTCTargetInformation = SEQ(name=u'pTCTargetInformation', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCTargetInformation')))
    _PTCListManagement_pTCDirection = ENUM(name=u'pTCDirection', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Direction')))
    _PTCListManagement_pTCListManagementType = ENUM(name=u'pTCListManagementType', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCListManagementType')), opt=True)
    _PTCListManagement_pTCListManagementAction = ENUM(name=u'pTCListManagementAction', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCListManagementAction')), opt=True)
    _PTCListManagement_pTCListManagementFailure = ENUM(name=u'pTCListManagementFailure', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCListManagementFailure')), opt=True)
    _PTCListManagement_pTCContactID = SEQ(name=u'pTCContactID', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCTargetInformation')), opt=True)
    _PTCListManagement_pTCIDList = SEQ_OF(name=u'pTCIDList', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __PTCListManagement_pTCIDList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'PTCIDList')))
    _PTCListManagement_pTCIDList._cont = __PTCListManagement_pTCIDList__item_
    _PTCListManagement_pTCHost = SEQ(name=u'pTCHost', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCTargetInformation')), opt=True)
    PTCListManagement._cont = ASN1Dict([
        (u'pTCTargetInformation', _PTCListManagement_pTCTargetInformation),
        (u'pTCDirection', _PTCListManagement_pTCDirection),
        (u'pTCListManagementType', _PTCListManagement_pTCListManagementType),
        (u'pTCListManagementAction', _PTCListManagement_pTCListManagementAction),
        (u'pTCListManagementFailure', _PTCListManagement_pTCListManagementFailure),
        (u'pTCContactID', _PTCListManagement_pTCContactID),
        (u'pTCIDList', _PTCListManagement_pTCIDList),
        (u'pTCHost', _PTCListManagement_pTCHost),
        ])
    PTCListManagement._ext = []
    
    #-----< PTCAccessPolicy >-----#
    PTCAccessPolicy = SEQ(name=u'PTCAccessPolicy', mode=MODE_TYPE)
    _PTCAccessPolicy_pTCTargetInformation = SEQ(name=u'pTCTargetInformation', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCTargetInformation')))
    _PTCAccessPolicy_pTCDirection = ENUM(name=u'pTCDirection', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Direction')))
    _PTCAccessPolicy_pTCAccessPolicyType = ENUM(name=u'pTCAccessPolicyType', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCAccessPolicyType')), opt=True)
    _PTCAccessPolicy_pTCUserAccessPolicy = ENUM(name=u'pTCUserAccessPolicy', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCUserAccessPolicy')), opt=True)
    _PTCAccessPolicy_pTCGroupAuthRule = ENUM(name=u'pTCGroupAuthRule', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCGroupAuthRule')), opt=True)
    _PTCAccessPolicy_pTCContactID = SEQ(name=u'pTCContactID', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCTargetInformation')), opt=True)
    _PTCAccessPolicy_pTCAccessPolicyFailure = ENUM(name=u'pTCAccessPolicyFailure', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCAccessPolicyFailure')), opt=True)
    PTCAccessPolicy._cont = ASN1Dict([
        (u'pTCTargetInformation', _PTCAccessPolicy_pTCTargetInformation),
        (u'pTCDirection', _PTCAccessPolicy_pTCDirection),
        (u'pTCAccessPolicyType', _PTCAccessPolicy_pTCAccessPolicyType),
        (u'pTCUserAccessPolicy', _PTCAccessPolicy_pTCUserAccessPolicy),
        (u'pTCGroupAuthRule', _PTCAccessPolicy_pTCGroupAuthRule),
        (u'pTCContactID', _PTCAccessPolicy_pTCContactID),
        (u'pTCAccessPolicyFailure', _PTCAccessPolicy_pTCAccessPolicyFailure),
        ])
    PTCAccessPolicy._ext = []
    
    #-----< PTCRegistrationRequest >-----#
    PTCRegistrationRequest = ENUM(name=u'PTCRegistrationRequest', mode=MODE_TYPE)
    PTCRegistrationRequest._cont = ASN1Dict([(u'register', 1), (u'reRegister', 2), (u'deRegister', 3)])
    PTCRegistrationRequest._ext = []
    
    #-----< PTCRegistrationOutcome >-----#
    PTCRegistrationOutcome = ENUM(name=u'PTCRegistrationOutcome', mode=MODE_TYPE)
    PTCRegistrationOutcome._cont = ASN1Dict([(u'success', 1), (u'failure', 2)])
    PTCRegistrationOutcome._ext = []
    
    #-----< PTCSessionEndCause >-----#
    PTCSessionEndCause = ENUM(name=u'PTCSessionEndCause', mode=MODE_TYPE)
    PTCSessionEndCause._cont = ASN1Dict([(u'initiaterLeavesSession', 1), (u'definedParticipantLeaves', 2), (u'numberOfParticipants', 3), (u'sessionTimerExpired', 4), (u'pTCSpeechInactive', 5), (u'allMediaTypesInactive', 6)])
    PTCSessionEndCause._ext = []
    
    #-----< PTCTargetInformation >-----#
    PTCTargetInformation = SEQ(name=u'PTCTargetInformation', mode=MODE_TYPE)
    _PTCTargetInformation_identifiers = SEQ_OF(name=u'identifiers', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __PTCTargetInformation_identifiers__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'PTCIdentifiers')))
    _PTCTargetInformation_identifiers._cont = __PTCTargetInformation_identifiers__item_
    _PTCTargetInformation_identifiers._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    PTCTargetInformation._cont = ASN1Dict([
        (u'identifiers', _PTCTargetInformation_identifiers),
        ])
    PTCTargetInformation._ext = []
    
    #-----< PTCIdentifiers >-----#
    PTCIdentifiers = CHOICE(name=u'PTCIdentifiers', mode=MODE_TYPE)
    _PTCIdentifiers_mCPTTID = STR_UTF8(name=u'mCPTTID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _PTCIdentifiers_instanceIdentifierURN = STR_UTF8(name=u'instanceIdentifierURN', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _PTCIdentifiers_pTCChatGroupID = SEQ(name=u'pTCChatGroupID', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCChatGroupID')))
    _PTCIdentifiers_iMPU = CHOICE(name=u'iMPU', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'IMPU')))
    _PTCIdentifiers_iMPI = STR_UTF8(name=u'iMPI', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'IMPI')))
    PTCIdentifiers._cont = ASN1Dict([
        (u'mCPTTID', _PTCIdentifiers_mCPTTID),
        (u'instanceIdentifierURN', _PTCIdentifiers_instanceIdentifierURN),
        (u'pTCChatGroupID', _PTCIdentifiers_pTCChatGroupID),
        (u'iMPU', _PTCIdentifiers_iMPU),
        (u'iMPI', _PTCIdentifiers_iMPI),
        ])
    PTCIdentifiers._ext = []
    
    #-----< PTCSessionInfo >-----#
    PTCSessionInfo = SEQ(name=u'PTCSessionInfo', mode=MODE_TYPE)
    _PTCSessionInfo_pTCSessionURI = STR_UTF8(name=u'pTCSessionURI', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _PTCSessionInfo_pTCSessionType = ENUM(name=u'pTCSessionType', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCSessionType')))
    PTCSessionInfo._cont = ASN1Dict([
        (u'pTCSessionURI', _PTCSessionInfo_pTCSessionURI),
        (u'pTCSessionType', _PTCSessionInfo_pTCSessionType),
        ])
    PTCSessionInfo._ext = []
    
    #-----< PTCSessionType >-----#
    PTCSessionType = ENUM(name=u'PTCSessionType', mode=MODE_TYPE)
    PTCSessionType._cont = ASN1Dict([(u'ondemand', 1), (u'preEstablished', 2), (u'adhoc', 3), (u'prearranged', 4), (u'groupSession', 5)])
    PTCSessionType._ext = []
    
    #-----< MultipleParticipantPresenceStatus >-----#
    MultipleParticipantPresenceStatus = SEQ_OF(name=u'MultipleParticipantPresenceStatus', mode=MODE_TYPE)
    _MultipleParticipantPresenceStatus__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'PTCParticipantPresenceStatus')))
    MultipleParticipantPresenceStatus._cont = _MultipleParticipantPresenceStatus__item_
    
    #-----< PTCParticipantPresenceStatus >-----#
    PTCParticipantPresenceStatus = SEQ(name=u'PTCParticipantPresenceStatus', mode=MODE_TYPE)
    _PTCParticipantPresenceStatus_presenceID = SEQ(name=u'presenceID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCTargetInformation')))
    _PTCParticipantPresenceStatus_presenceType = ENUM(name=u'presenceType', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCPresenceType')))
    _PTCParticipantPresenceStatus_presenceStatus = BOOL(name=u'presenceStatus', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    PTCParticipantPresenceStatus._cont = ASN1Dict([
        (u'presenceID', _PTCParticipantPresenceStatus_presenceID),
        (u'presenceType', _PTCParticipantPresenceStatus_presenceType),
        (u'presenceStatus', _PTCParticipantPresenceStatus_presenceStatus),
        ])
    PTCParticipantPresenceStatus._ext = []
    
    #-----< PTCPresenceType >-----#
    PTCPresenceType = ENUM(name=u'PTCPresenceType', mode=MODE_TYPE)
    PTCPresenceType._cont = ASN1Dict([(u'pTCClient', 1), (u'pTCGroup', 2)])
    PTCPresenceType._ext = []
    
    #-----< PTCPreEstStatus >-----#
    PTCPreEstStatus = ENUM(name=u'PTCPreEstStatus', mode=MODE_TYPE)
    PTCPreEstStatus._cont = ASN1Dict([(u'established', 1), (u'modified', 2), (u'released', 3)])
    PTCPreEstStatus._ext = []
    
    #-----< RTPSetting >-----#
    RTPSetting = SEQ(name=u'RTPSetting', mode=MODE_TYPE)
    _RTPSetting_iPAddress = CHOICE(name=u'iPAddress', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'IPAddress')))
    _RTPSetting_portNumber = INT(name=u'portNumber', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PortNumber')))
    RTPSetting._cont = ASN1Dict([
        (u'iPAddress', _RTPSetting_iPAddress),
        (u'portNumber', _RTPSetting_portNumber),
        ])
    RTPSetting._ext = []
    
    #-----< PTCIDList >-----#
    PTCIDList = SEQ(name=u'PTCIDList', mode=MODE_TYPE)
    _PTCIDList_pTCPartyID = SEQ(name=u'pTCPartyID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCTargetInformation')))
    _PTCIDList_pTCChatGroupID = SEQ(name=u'pTCChatGroupID', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PTCChatGroupID')))
    PTCIDList._cont = ASN1Dict([
        (u'pTCPartyID', _PTCIDList_pTCPartyID),
        (u'pTCChatGroupID', _PTCIDList_pTCChatGroupID),
        ])
    PTCIDList._ext = []
    
    #-----< PTCChatGroupID >-----#
    PTCChatGroupID = SEQ(name=u'PTCChatGroupID', mode=MODE_TYPE)
    _PTCChatGroupID_groupIdentity = STR_UTF8(name=u'groupIdentity', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    PTCChatGroupID._cont = ASN1Dict([
        (u'groupIdentity', _PTCChatGroupID_groupIdentity),
        ])
    PTCChatGroupID._ext = []
    
    #-----< PTCFloorActivity >-----#
    PTCFloorActivity = ENUM(name=u'PTCFloorActivity', mode=MODE_TYPE)
    PTCFloorActivity._cont = ASN1Dict([(u'tBCPRequest', 1), (u'tBCPGranted', 2), (u'tBCPDeny', 3), (u'tBCPIdle', 4), (u'tBCPTaken', 5), (u'tBCPRevoke', 6), (u'tBCPQueued', 7), (u'tBCPRelease', 8)])
    PTCFloorActivity._ext = []
    
    #-----< PTCTBPriorityLevel >-----#
    PTCTBPriorityLevel = ENUM(name=u'PTCTBPriorityLevel', mode=MODE_TYPE)
    PTCTBPriorityLevel._cont = ASN1Dict([(u'preEmptive', 1), (u'highPriority', 2), (u'normalPriority', 3), (u'listenOnly', 4)])
    PTCTBPriorityLevel._ext = []
    
    #-----< PTCTBReasonCode >-----#
    PTCTBReasonCode = ENUM(name=u'PTCTBReasonCode', mode=MODE_TYPE)
    PTCTBReasonCode._cont = ASN1Dict([(u'noQueuingAllowed', 1), (u'oneParticipantSession', 2), (u'listenOnly', 3), (u'exceededMaxDuration', 4), (u'tBPrevented', 5)])
    PTCTBReasonCode._ext = []
    
    #-----< PTCListManagementType >-----#
    PTCListManagementType = ENUM(name=u'PTCListManagementType', mode=MODE_TYPE)
    PTCListManagementType._cont = ASN1Dict([(u'contactListManagementAttempt', 1), (u'groupListManagementAttempt', 2), (u'contactListManagementResult', 3), (u'groupListManagementResult', 4), (u'requestUnsuccessful', 5)])
    PTCListManagementType._ext = []
    
    #-----< PTCListManagementAction >-----#
    PTCListManagementAction = ENUM(name=u'PTCListManagementAction', mode=MODE_TYPE)
    PTCListManagementAction._cont = ASN1Dict([(u'create', 1), (u'modify', 2), (u'retrieve', 3), (u'delete', 4), (u'notify', 5)])
    PTCListManagementAction._ext = []
    
    #-----< PTCAccessPolicyType >-----#
    PTCAccessPolicyType = ENUM(name=u'PTCAccessPolicyType', mode=MODE_TYPE)
    PTCAccessPolicyType._cont = ASN1Dict([(u'pTCUserAccessPolicyAttempt', 1), (u'groupAuthorizationRulesAttempt', 2), (u'pTCUserAccessPolicyQuery', 3), (u'groupAuthorizationRulesQuery', 4), (u'pTCUserAccessPolicyResult', 5), (u'groupAuthorizationRulesResult', 6), (u'requestUnsuccessful', 7)])
    PTCAccessPolicyType._ext = []
    
    #-----< PTCUserAccessPolicy >-----#
    PTCUserAccessPolicy = ENUM(name=u'PTCUserAccessPolicy', mode=MODE_TYPE)
    PTCUserAccessPolicy._cont = ASN1Dict([(u'allowIncomingPTCSessionRequest', 1), (u'blockIncomingPTCSessionRequest', 2), (u'allowAutoAnswerMode', 3), (u'allowOverrideManualAnswerMode', 4)])
    PTCUserAccessPolicy._ext = []
    
    #-----< PTCGroupAuthRule >-----#
    PTCGroupAuthRule = ENUM(name=u'PTCGroupAuthRule', mode=MODE_TYPE)
    PTCGroupAuthRule._cont = ASN1Dict([(u'allowInitiatingPTCSession', 1), (u'blockInitiatingPTCSession', 2), (u'allowJoiningPTCSession', 3), (u'blockJoiningPTCSession', 4), (u'allowAddParticipants', 5), (u'blockAddParticipants', 6), (u'allowSubscriptionPTCSessionState', 7), (u'blockSubscriptionPTCSessionState', 8), (u'allowAnonymity', 9), (u'forbidAnonymity', 10)])
    PTCGroupAuthRule._ext = []
    
    #-----< PTCFailureCode >-----#
    PTCFailureCode = ENUM(name=u'PTCFailureCode', mode=MODE_TYPE)
    PTCFailureCode._cont = ASN1Dict([(u'sessionCannotBeEstablished', 1), (u'sessionCannotBeModified', 2)])
    PTCFailureCode._ext = []
    
    #-----< PTCListManagementFailure >-----#
    PTCListManagementFailure = ENUM(name=u'PTCListManagementFailure', mode=MODE_TYPE)
    PTCListManagementFailure._cont = ASN1Dict([(u'requestUnsuccessful', 1), (u'requestUnknown', 2)])
    PTCListManagementFailure._ext = []
    
    #-----< PTCAccessPolicyFailure >-----#
    PTCAccessPolicyFailure = ENUM(name=u'PTCAccessPolicyFailure', mode=MODE_TYPE)
    PTCAccessPolicyFailure._cont = ASN1Dict([(u'requestUnsuccessful', 1), (u'requestUnknown', 2)])
    PTCAccessPolicyFailure._ext = []
    
    #-----< LALSReport >-----#
    LALSReport = SEQ(name=u'LALSReport', mode=MODE_TYPE)
    _LALSReport_sUPI = CHOICE(name=u'sUPI', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SUPI')), opt=True)
    _LALSReport_pEI = CHOICE(name=u'pEI', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PEI')), opt=True)
    _LALSReport_gPSI = CHOICE(name=u'gPSI', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'GPSI')), opt=True)
    _LALSReport_location = SEQ(name=u'location', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Location')), opt=True)
    LALSReport._cont = ASN1Dict([
        (u'sUPI', _LALSReport_sUPI),
        (u'pEI', _LALSReport_pEI),
        (u'gPSI', _LALSReport_gPSI),
        (u'location', _LALSReport_location),
        ])
    LALSReport._ext = []
    
    #-----< PDHeaderReport >-----#
    PDHeaderReport = SEQ(name=u'PDHeaderReport', mode=MODE_TYPE)
    _PDHeaderReport_pDUSessionID = INT(name=u'pDUSessionID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PDUSessionID')))
    _PDHeaderReport_sourceIPAddress = CHOICE(name=u'sourceIPAddress', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'IPAddress')))
    _PDHeaderReport_sourcePort = INT(name=u'sourcePort', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PortNumber')), opt=True)
    _PDHeaderReport_destinationIPAddress = CHOICE(name=u'destinationIPAddress', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'IPAddress')))
    _PDHeaderReport_destinationPort = INT(name=u'destinationPort', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PortNumber')), opt=True)
    _PDHeaderReport_nextLayerProtocol = INT(name=u'nextLayerProtocol', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'NextLayerProtocol')))
    _PDHeaderReport_iPv6flowLabel = INT(name=u'iPv6flowLabel', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'IPv6FlowLabel')), opt=True)
    _PDHeaderReport_direction = ENUM(name=u'direction', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Direction')))
    _PDHeaderReport_packetSize = INT(name=u'packetSize', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    PDHeaderReport._cont = ASN1Dict([
        (u'pDUSessionID', _PDHeaderReport_pDUSessionID),
        (u'sourceIPAddress', _PDHeaderReport_sourceIPAddress),
        (u'sourcePort', _PDHeaderReport_sourcePort),
        (u'destinationIPAddress', _PDHeaderReport_destinationIPAddress),
        (u'destinationPort', _PDHeaderReport_destinationPort),
        (u'nextLayerProtocol', _PDHeaderReport_nextLayerProtocol),
        (u'iPv6flowLabel', _PDHeaderReport_iPv6flowLabel),
        (u'direction', _PDHeaderReport_direction),
        (u'packetSize', _PDHeaderReport_packetSize),
        ])
    PDHeaderReport._ext = []
    
    #-----< PDSummaryReport >-----#
    PDSummaryReport = SEQ(name=u'PDSummaryReport', mode=MODE_TYPE)
    _PDSummaryReport_pDUSessionID = INT(name=u'pDUSessionID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PDUSessionID')))
    _PDSummaryReport_sourceIPAddress = CHOICE(name=u'sourceIPAddress', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'IPAddress')))
    _PDSummaryReport_sourcePort = INT(name=u'sourcePort', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PortNumber')), opt=True)
    _PDSummaryReport_destinationIPAddress = CHOICE(name=u'destinationIPAddress', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'IPAddress')))
    _PDSummaryReport_destinationPort = INT(name=u'destinationPort', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PortNumber')), opt=True)
    _PDSummaryReport_nextLayerProtocol = INT(name=u'nextLayerProtocol', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'NextLayerProtocol')))
    _PDSummaryReport_iPv6flowLabel = INT(name=u'iPv6flowLabel', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'IPv6FlowLabel')), opt=True)
    _PDSummaryReport_direction = ENUM(name=u'direction', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Direction')))
    _PDSummaryReport_pDSRSummaryTrigger = ENUM(name=u'pDSRSummaryTrigger', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PDSRSummaryTrigger')))
    _PDSummaryReport_firstPacketTimestamp = TIME_GEN(name=u'firstPacketTimestamp', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Timestamp')))
    _PDSummaryReport_lastPacketTimestamp = TIME_GEN(name=u'lastPacketTimestamp', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Timestamp')))
    _PDSummaryReport_packetCount = INT(name=u'packetCount', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _PDSummaryReport_byteCount = INT(name=u'byteCount', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    PDSummaryReport._cont = ASN1Dict([
        (u'pDUSessionID', _PDSummaryReport_pDUSessionID),
        (u'sourceIPAddress', _PDSummaryReport_sourceIPAddress),
        (u'sourcePort', _PDSummaryReport_sourcePort),
        (u'destinationIPAddress', _PDSummaryReport_destinationIPAddress),
        (u'destinationPort', _PDSummaryReport_destinationPort),
        (u'nextLayerProtocol', _PDSummaryReport_nextLayerProtocol),
        (u'iPv6flowLabel', _PDSummaryReport_iPv6flowLabel),
        (u'direction', _PDSummaryReport_direction),
        (u'pDSRSummaryTrigger', _PDSummaryReport_pDSRSummaryTrigger),
        (u'firstPacketTimestamp', _PDSummaryReport_firstPacketTimestamp),
        (u'lastPacketTimestamp', _PDSummaryReport_lastPacketTimestamp),
        (u'packetCount', _PDSummaryReport_packetCount),
        (u'byteCount', _PDSummaryReport_byteCount),
        ])
    PDSummaryReport._ext = []
    
    #-----< PDSRSummaryTrigger >-----#
    PDSRSummaryTrigger = ENUM(name=u'PDSRSummaryTrigger', mode=MODE_TYPE)
    PDSRSummaryTrigger._cont = ASN1Dict([(u'timerExpiry', 1), (u'packetCount', 2), (u'byteCount', 3), (u'startOfFlow', 4), (u'endOfFlow', 5)])
    PDSRSummaryTrigger._ext = []
    
    #-----< AMFIdentifierAssocation >-----#
    AMFIdentifierAssocation = SEQ(name=u'AMFIdentifierAssocation', mode=MODE_TYPE)
    _AMFIdentifierAssocation_sUPI = CHOICE(name=u'sUPI', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SUPI')))
    _AMFIdentifierAssocation_sUCI = SEQ(name=u'sUCI', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SUCI')), opt=True)
    _AMFIdentifierAssocation_pEI = CHOICE(name=u'pEI', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PEI')), opt=True)
    _AMFIdentifierAssocation_gPSI = CHOICE(name=u'gPSI', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'GPSI')), opt=True)
    _AMFIdentifierAssocation_gUTI = SEQ(name=u'gUTI', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'FiveGGUTI')))
    _AMFIdentifierAssocation_location = SEQ(name=u'location', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Location')))
    _AMFIdentifierAssocation_fiveGSTAIList = SEQ_OF(name=u'fiveGSTAIList', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'TAIList')), opt=True)
    AMFIdentifierAssocation._cont = ASN1Dict([
        (u'sUPI', _AMFIdentifierAssocation_sUPI),
        (u'sUCI', _AMFIdentifierAssocation_sUCI),
        (u'pEI', _AMFIdentifierAssocation_pEI),
        (u'gPSI', _AMFIdentifierAssocation_gPSI),
        (u'gUTI', _AMFIdentifierAssocation_gUTI),
        (u'location', _AMFIdentifierAssocation_location),
        (u'fiveGSTAIList', _AMFIdentifierAssocation_fiveGSTAIList),
        ])
    AMFIdentifierAssocation._ext = []
    
    #-----< MMEIdentifierAssocation >-----#
    MMEIdentifierAssocation = SEQ(name=u'MMEIdentifierAssocation', mode=MODE_TYPE)
    _MMEIdentifierAssocation_iMSI = STR_NUM(name=u'iMSI', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'IMSI')))
    _MMEIdentifierAssocation_iMEI = STR_NUM(name=u'iMEI', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'IMEI')), opt=True)
    _MMEIdentifierAssocation_mSISDN = STR_NUM(name=u'mSISDN', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MSISDN')), opt=True)
    _MMEIdentifierAssocation_gUTI = SEQ(name=u'gUTI', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'GUTI')))
    _MMEIdentifierAssocation_location = SEQ(name=u'location', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Location')))
    _MMEIdentifierAssocation_tAIList = SEQ_OF(name=u'tAIList', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'TAIList')), opt=True)
    MMEIdentifierAssocation._cont = ASN1Dict([
        (u'iMSI', _MMEIdentifierAssocation_iMSI),
        (u'iMEI', _MMEIdentifierAssocation_iMEI),
        (u'mSISDN', _MMEIdentifierAssocation_mSISDN),
        (u'gUTI', _MMEIdentifierAssocation_gUTI),
        (u'location', _MMEIdentifierAssocation_location),
        (u'tAIList', _MMEIdentifierAssocation_tAIList),
        ])
    MMEIdentifierAssocation._ext = []
    
    #-----< GUTI >-----#
    GUTI = SEQ(name=u'GUTI', mode=MODE_TYPE)
    _GUTI_mCC = STR_NUM(name=u'mCC', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MCC')))
    _GUTI_mNC = STR_NUM(name=u'mNC', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MNC')))
    _GUTI_mMEGroupID = OCT_STR(name=u'mMEGroupID', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMEGroupID')))
    _GUTI_mMECode = OCT_STR(name=u'mMECode', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMECode')))
    _GUTI_mTMSI = OCT_STR(name=u'mTMSI', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'TMSI')))
    GUTI._cont = ASN1Dict([
        (u'mCC', _GUTI_mCC),
        (u'mNC', _GUTI_mNC),
        (u'mMEGroupID', _GUTI_mMEGroupID),
        (u'mMECode', _GUTI_mMECode),
        (u'mTMSI', _GUTI_mTMSI),
        ])
    GUTI._ext = []
    
    #-----< MMEGroupID >-----#
    MMEGroupID = OCT_STR(name=u'MMEGroupID', mode=MODE_TYPE)
    MMEGroupID._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    
    #-----< MMECode >-----#
    MMECode = OCT_STR(name=u'MMECode', mode=MODE_TYPE)
    MMECode._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< TMSI >-----#
    TMSI = OCT_STR(name=u'TMSI', mode=MODE_TYPE)
    TMSI._const_sz = ASN1Set(rv=[4], rr=[], ev=None, er=[])
    
    #-----< LINotification >-----#
    LINotification = SEQ(name=u'LINotification', mode=MODE_TYPE)
    _LINotification_notificationType = ENUM(name=u'notificationType', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'LINotificationType')))
    _LINotification_appliedTargetID = CHOICE(name=u'appliedTargetID', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'TargetIdentifier')), opt=True)
    _LINotification_appliedDeliveryInformation = SEQ_OF(name=u'appliedDeliveryInformation', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __LINotification_appliedDeliveryInformation__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'LIAppliedDeliveryInformation')))
    _LINotification_appliedDeliveryInformation._cont = __LINotification_appliedDeliveryInformation__item_
    _LINotification_appliedStartTime = TIME_GEN(name=u'appliedStartTime', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Timestamp')), opt=True)
    _LINotification_appliedEndTime = TIME_GEN(name=u'appliedEndTime', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Timestamp')), opt=True)
    LINotification._cont = ASN1Dict([
        (u'notificationType', _LINotification_notificationType),
        (u'appliedTargetID', _LINotification_appliedTargetID),
        (u'appliedDeliveryInformation', _LINotification_appliedDeliveryInformation),
        (u'appliedStartTime', _LINotification_appliedStartTime),
        (u'appliedEndTime', _LINotification_appliedEndTime),
        ])
    LINotification._ext = []
    
    #-----< LINotificationType >-----#
    LINotificationType = ENUM(name=u'LINotificationType', mode=MODE_TYPE)
    LINotificationType._cont = ASN1Dict([(u'activation', 1), (u'deactivation', 2), (u'modification', 3)])
    LINotificationType._ext = []
    
    #-----< LIAppliedDeliveryInformation >-----#
    LIAppliedDeliveryInformation = SEQ(name=u'LIAppliedDeliveryInformation', mode=MODE_TYPE)
    _LIAppliedDeliveryInformation_hI2DeliveryIPAddress = CHOICE(name=u'hI2DeliveryIPAddress', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'IPAddress')), opt=True)
    _LIAppliedDeliveryInformation_hI2DeliveryPortNumber = INT(name=u'hI2DeliveryPortNumber', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PortNumber')), opt=True)
    _LIAppliedDeliveryInformation_hI3DeliveryIPAddress = CHOICE(name=u'hI3DeliveryIPAddress', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'IPAddress')), opt=True)
    _LIAppliedDeliveryInformation_hI3DeliveryPortNumber = INT(name=u'hI3DeliveryPortNumber', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PortNumber')), opt=True)
    LIAppliedDeliveryInformation._cont = ASN1Dict([
        (u'hI2DeliveryIPAddress', _LIAppliedDeliveryInformation_hI2DeliveryIPAddress),
        (u'hI2DeliveryPortNumber', _LIAppliedDeliveryInformation_hI2DeliveryPortNumber),
        (u'hI3DeliveryIPAddress', _LIAppliedDeliveryInformation_hI3DeliveryIPAddress),
        (u'hI3DeliveryPortNumber', _LIAppliedDeliveryInformation_hI3DeliveryPortNumber),
        ])
    LIAppliedDeliveryInformation._ext = []
    
    #-----< MDFCellSiteReport >-----#
    MDFCellSiteReport = SEQ_OF(name=u'MDFCellSiteReport', mode=MODE_TYPE)
    _MDFCellSiteReport__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'CellInformation')))
    MDFCellSiteReport._cont = _MDFCellSiteReport__item_
    
    #-----< AccessType >-----#
    AccessType = ENUM(name=u'AccessType', mode=MODE_TYPE)
    AccessType._cont = ASN1Dict([(u'threeGPPAccess', 1), (u'nonThreeGPPAccess', 2), (u'threeGPPandNonThreeGPPAccess', 3)])
    AccessType._ext = []
    
    #-----< Direction >-----#
    Direction = ENUM(name=u'Direction', mode=MODE_TYPE)
    Direction._cont = ASN1Dict([(u'fromTarget', 1), (u'toTarget', 2)])
    Direction._ext = []
    
    #-----< DNN >-----#
    DNN = STR_UTF8(name=u'DNN', mode=MODE_TYPE)
    
    #-----< E164Number >-----#
    E164Number = STR_NUM(name=u'E164Number', mode=MODE_TYPE)
    E164Number._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=15)], ev=None, er=[])
    
    #-----< EmailAddress >-----#
    EmailAddress = STR_UTF8(name=u'EmailAddress', mode=MODE_TYPE)
    
    #-----< FiveGGUTI >-----#
    FiveGGUTI = SEQ(name=u'FiveGGUTI', mode=MODE_TYPE)
    _FiveGGUTI_mCC = STR_NUM(name=u'mCC', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MCC')))
    _FiveGGUTI_mNC = STR_NUM(name=u'mNC', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MNC')))
    _FiveGGUTI_aMFRegionID = INT(name=u'aMFRegionID', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'AMFRegionID')))
    _FiveGGUTI_aMFSetID = INT(name=u'aMFSetID', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'AMFSetID')))
    _FiveGGUTI_aMFPointer = INT(name=u'aMFPointer', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'AMFPointer')))
    _FiveGGUTI_fiveGTMSI = INT(name=u'fiveGTMSI', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'FiveGTMSI')))
    FiveGGUTI._cont = ASN1Dict([
        (u'mCC', _FiveGGUTI_mCC),
        (u'mNC', _FiveGGUTI_mNC),
        (u'aMFRegionID', _FiveGGUTI_aMFRegionID),
        (u'aMFSetID', _FiveGGUTI_aMFSetID),
        (u'aMFPointer', _FiveGGUTI_aMFPointer),
        (u'fiveGTMSI', _FiveGGUTI_fiveGTMSI),
        ])
    FiveGGUTI._ext = []
    
    #-----< FiveGMMCause >-----#
    FiveGMMCause = INT(name=u'FiveGMMCause', mode=MODE_TYPE)
    FiveGMMCause._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    
    #-----< FiveGSMRequestType >-----#
    FiveGSMRequestType = ENUM(name=u'FiveGSMRequestType', mode=MODE_TYPE)
    FiveGSMRequestType._cont = ASN1Dict([(u'initialRequest', 1), (u'existingPDUSession', 2), (u'initialEmergencyRequest', 3), (u'existingEmergencyPDUSession', 4), (u'modificationRequest', 5), (u'reserved', 6), (u'mAPDURequest', 7)])
    FiveGSMRequestType._ext = []
    
    #-----< FiveGSMCause >-----#
    FiveGSMCause = INT(name=u'FiveGSMCause', mode=MODE_TYPE)
    FiveGSMCause._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    
    #-----< FiveGTMSI >-----#
    FiveGTMSI = INT(name=u'FiveGTMSI', mode=MODE_TYPE)
    FiveGTMSI._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4294967295)], ev=None, er=[])
    
    #-----< FTEID >-----#
    FTEID = SEQ(name=u'FTEID', mode=MODE_TYPE)
    _FTEID_tEID = INT(name=u'tEID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _FTEID_tEID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4294967295)], ev=None, er=[])
    _FTEID_iPv4Address = OCT_STR(name=u'iPv4Address', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'IPv4Address')), opt=True)
    _FTEID_iPv6Address = OCT_STR(name=u'iPv6Address', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'IPv6Address')), opt=True)
    FTEID._cont = ASN1Dict([
        (u'tEID', _FTEID_tEID),
        (u'iPv4Address', _FTEID_iPv4Address),
        (u'iPv6Address', _FTEID_iPv6Address),
        ])
    FTEID._ext = []
    
    #-----< GPSI >-----#
    GPSI = CHOICE(name=u'GPSI', mode=MODE_TYPE)
    _GPSI_mSISDN = STR_NUM(name=u'mSISDN', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MSISDN')))
    _GPSI_nAI = STR_UTF8(name=u'nAI', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'NAI')))
    GPSI._cont = ASN1Dict([
        (u'mSISDN', _GPSI_mSISDN),
        (u'nAI', _GPSI_nAI),
        ])
    GPSI._ext = []
    
    #-----< GUAMI >-----#
    GUAMI = SEQ(name=u'GUAMI', mode=MODE_TYPE)
    _GUAMI_aMFID = SEQ(name=u'aMFID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'AMFID')))
    _GUAMI_pLMNID = SEQ(name=u'pLMNID', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PLMNID')))
    GUAMI._cont = ASN1Dict([
        (u'aMFID', _GUAMI_aMFID),
        (u'pLMNID', _GUAMI_pLMNID),
        ])
    GUAMI._ext = []
    
    #-----< GUMMEI >-----#
    GUMMEI = SEQ(name=u'GUMMEI', mode=MODE_TYPE)
    _GUMMEI_mMEID = SEQ(name=u'mMEID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMEID')))
    _GUMMEI_mCC = STR_NUM(name=u'mCC', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MCC')))
    _GUMMEI_mNC = STR_NUM(name=u'mNC', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MNC')))
    GUMMEI._cont = ASN1Dict([
        (u'mMEID', _GUMMEI_mMEID),
        (u'mCC', _GUMMEI_mCC),
        (u'mNC', _GUMMEI_mNC),
        ])
    GUMMEI._ext = []
    
    #-----< HomeNetworkPublicKeyID >-----#
    HomeNetworkPublicKeyID = OCT_STR(name=u'HomeNetworkPublicKeyID', mode=MODE_TYPE)
    
    #-----< HSMFURI >-----#
    HSMFURI = STR_UTF8(name=u'HSMFURI', mode=MODE_TYPE)
    
    #-----< IMEI >-----#
    IMEI = STR_NUM(name=u'IMEI', mode=MODE_TYPE)
    IMEI._const_sz = ASN1Set(rv=[14], rr=[], ev=None, er=[])
    
    #-----< IMEISV >-----#
    IMEISV = STR_NUM(name=u'IMEISV', mode=MODE_TYPE)
    IMEISV._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    
    #-----< IMPI >-----#
    IMPI = STR_UTF8(name=u'IMPI', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'NAI')))
    
    #-----< IMPU >-----#
    IMPU = CHOICE(name=u'IMPU', mode=MODE_TYPE)
    _IMPU_sIPURI = STR_UTF8(name=u'sIPURI', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SIPURI')))
    _IMPU_tELURI = STR_UTF8(name=u'tELURI', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'TELURI')))
    IMPU._cont = ASN1Dict([
        (u'sIPURI', _IMPU_sIPURI),
        (u'tELURI', _IMPU_tELURI),
        ])
    IMPU._ext = []
    
    #-----< IMSI >-----#
    IMSI = STR_NUM(name=u'IMSI', mode=MODE_TYPE)
    IMSI._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=6, ub=15)], ev=None, er=[])
    
    #-----< Initiator >-----#
    Initiator = ENUM(name=u'Initiator', mode=MODE_TYPE)
    Initiator._cont = ASN1Dict([(u'uE', 1), (u'network', 2), (u'unknown', 3)])
    Initiator._ext = []
    
    #-----< IPAddress >-----#
    IPAddress = CHOICE(name=u'IPAddress', mode=MODE_TYPE)
    _IPAddress_iPv4Address = OCT_STR(name=u'iPv4Address', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'IPv4Address')))
    _IPAddress_iPv6Address = OCT_STR(name=u'iPv6Address', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'IPv6Address')))
    IPAddress._cont = ASN1Dict([
        (u'iPv4Address', _IPAddress_iPv4Address),
        (u'iPv6Address', _IPAddress_iPv6Address),
        ])
    IPAddress._ext = []
    
    #-----< IPv4Address >-----#
    IPv4Address = OCT_STR(name=u'IPv4Address', mode=MODE_TYPE)
    IPv4Address._const_sz = ASN1Set(rv=[4], rr=[], ev=None, er=[])
    
    #-----< IPv6Address >-----#
    IPv6Address = OCT_STR(name=u'IPv6Address', mode=MODE_TYPE)
    IPv6Address._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    
    #-----< IPv6FlowLabel >-----#
    IPv6FlowLabel = INT(name=u'IPv6FlowLabel', mode=MODE_TYPE)
    IPv6FlowLabel._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=1048575)], ev=None, er=[])
    
    #-----< MACAddress >-----#
    MACAddress = OCT_STR(name=u'MACAddress', mode=MODE_TYPE)
    MACAddress._const_sz = ASN1Set(rv=[6], rr=[], ev=None, er=[])
    
    #-----< MCC >-----#
    MCC = STR_NUM(name=u'MCC', mode=MODE_TYPE)
    MCC._const_sz = ASN1Set(rv=[3], rr=[], ev=None, er=[])
    
    #-----< MNC >-----#
    MNC = STR_NUM(name=u'MNC', mode=MODE_TYPE)
    MNC._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=2, ub=3)], ev=None, er=[])
    
    #-----< MMEID >-----#
    MMEID = SEQ(name=u'MMEID', mode=MODE_TYPE)
    _MMEID_mMEGI = STR_NUM(name=u'mMEGI', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMEGI')))
    _MMEID_mMEC = STR_NUM(name=u'mMEC', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MMEC')))
    MMEID._cont = ASN1Dict([
        (u'mMEGI', _MMEID_mMEGI),
        (u'mMEC', _MMEID_mMEC),
        ])
    MMEID._ext = []
    
    #-----< MMEC >-----#
    MMEC = STR_NUM(name=u'MMEC', mode=MODE_TYPE)
    
    #-----< MMEGI >-----#
    MMEGI = STR_NUM(name=u'MMEGI', mode=MODE_TYPE)
    
    #-----< MSISDN >-----#
    MSISDN = STR_NUM(name=u'MSISDN', mode=MODE_TYPE)
    MSISDN._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=15)], ev=None, er=[])
    
    #-----< NAI >-----#
    NAI = STR_UTF8(name=u'NAI', mode=MODE_TYPE)
    
    #-----< NextLayerProtocol >-----#
    NextLayerProtocol = INT(name=u'NextLayerProtocol', mode=MODE_TYPE)
    NextLayerProtocol._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    
    #-----< NonLocalID >-----#
    NonLocalID = ENUM(name=u'NonLocalID', mode=MODE_TYPE)
    NonLocalID._cont = ASN1Dict([(u'local', 1), (u'nonLocal', 2)])
    NonLocalID._ext = []
    
    #-----< NSSAI >-----#
    NSSAI = SEQ_OF(name=u'NSSAI', mode=MODE_TYPE)
    _NSSAI__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'SNSSAI')))
    NSSAI._cont = _NSSAI__item_
    
    #-----< PLMNID >-----#
    PLMNID = SEQ(name=u'PLMNID', mode=MODE_TYPE)
    _PLMNID_mCC = STR_NUM(name=u'mCC', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MCC')))
    _PLMNID_mNC = STR_NUM(name=u'mNC', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MNC')))
    PLMNID._cont = ASN1Dict([
        (u'mCC', _PLMNID_mCC),
        (u'mNC', _PLMNID_mNC),
        ])
    PLMNID._ext = []
    
    #-----< PDUSessionID >-----#
    PDUSessionID = INT(name=u'PDUSessionID', mode=MODE_TYPE)
    PDUSessionID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    
    #-----< PDUSessionType >-----#
    PDUSessionType = ENUM(name=u'PDUSessionType', mode=MODE_TYPE)
    PDUSessionType._cont = ASN1Dict([(u'iPv4', 1), (u'iPv6', 2), (u'iPv4v6', 3), (u'unstructured', 4), (u'ethernet', 5)])
    PDUSessionType._ext = []
    
    #-----< PEI >-----#
    PEI = CHOICE(name=u'PEI', mode=MODE_TYPE)
    _PEI_iMEI = STR_NUM(name=u'iMEI', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'IMEI')))
    _PEI_iMEISV = STR_NUM(name=u'iMEISV', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'IMEISV')))
    PEI._cont = ASN1Dict([
        (u'iMEI', _PEI_iMEI),
        (u'iMEISV', _PEI_iMEISV),
        ])
    PEI._ext = []
    
    #-----< PortNumber >-----#
    PortNumber = INT(name=u'PortNumber', mode=MODE_TYPE)
    PortNumber._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    
    #-----< ProtectionSchemeID >-----#
    ProtectionSchemeID = INT(name=u'ProtectionSchemeID', mode=MODE_TYPE)
    ProtectionSchemeID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=15)], ev=None, er=[])
    
    #-----< RATType >-----#
    RATType = ENUM(name=u'RATType', mode=MODE_TYPE)
    RATType._cont = ASN1Dict([(u'nR', 1), (u'eUTRA', 2), (u'wLAN', 3), (u'virtual', 4), (u'nBIOT', 5), (u'wireline', 6), (u'wirelineCable', 7), (u'wirelineBBF', 8), (u'lTEM', 9), (u'nRU', 10), (u'eUTRAU', 11), (u'trustedN3GA', 12), (u'trustedWLAN', 13), (u'uTRA', 14), (u'gERA', 15)])
    RATType._ext = []
    
    #-----< RejectedNSSAI >-----#
    RejectedNSSAI = SEQ_OF(name=u'RejectedNSSAI', mode=MODE_TYPE)
    _RejectedNSSAI__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'RejectedSNSSAI')))
    RejectedNSSAI._cont = _RejectedNSSAI__item_
    
    #-----< RejectedSNSSAI >-----#
    RejectedSNSSAI = SEQ(name=u'RejectedSNSSAI', mode=MODE_TYPE)
    _RejectedSNSSAI_causeValue = INT(name=u'causeValue', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'RejectedSliceCauseValue')))
    _RejectedSNSSAI_sNSSAI = SEQ(name=u'sNSSAI', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SNSSAI')))
    RejectedSNSSAI._cont = ASN1Dict([
        (u'causeValue', _RejectedSNSSAI_causeValue),
        (u'sNSSAI', _RejectedSNSSAI_sNSSAI),
        ])
    RejectedSNSSAI._ext = []
    
    #-----< RejectedSliceCauseValue >-----#
    RejectedSliceCauseValue = INT(name=u'RejectedSliceCauseValue', mode=MODE_TYPE)
    RejectedSliceCauseValue._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    
    #-----< RoutingIndicator >-----#
    RoutingIndicator = INT(name=u'RoutingIndicator', mode=MODE_TYPE)
    RoutingIndicator._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=9999)], ev=None, er=[])
    
    #-----< SchemeOutput >-----#
    SchemeOutput = OCT_STR(name=u'SchemeOutput', mode=MODE_TYPE)
    
    #-----< SIPURI >-----#
    SIPURI = STR_UTF8(name=u'SIPURI', mode=MODE_TYPE)
    
    #-----< Slice >-----#
    Slice = SEQ(name=u'Slice', mode=MODE_TYPE)
    _Slice_allowedNSSAI = SEQ_OF(name=u'allowedNSSAI', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'NSSAI')), opt=True)
    _Slice_configuredNSSAI = SEQ_OF(name=u'configuredNSSAI', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'NSSAI')), opt=True)
    _Slice_rejectedNSSAI = SEQ_OF(name=u'rejectedNSSAI', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'RejectedNSSAI')), opt=True)
    Slice._cont = ASN1Dict([
        (u'allowedNSSAI', _Slice_allowedNSSAI),
        (u'configuredNSSAI', _Slice_configuredNSSAI),
        (u'rejectedNSSAI', _Slice_rejectedNSSAI),
        ])
    Slice._ext = []
    
    #-----< SMPDUDNRequest >-----#
    SMPDUDNRequest = OCT_STR(name=u'SMPDUDNRequest', mode=MODE_TYPE)
    
    #-----< SNSSAI >-----#
    SNSSAI = SEQ(name=u'SNSSAI', mode=MODE_TYPE)
    _SNSSAI_sliceServiceType = INT(name=u'sliceServiceType', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _SNSSAI_sliceServiceType._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _SNSSAI_sliceDifferentiator = OCT_STR(name=u'sliceDifferentiator', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _SNSSAI_sliceDifferentiator._const_sz = ASN1Set(rv=[3], rr=[], ev=None, er=[])
    SNSSAI._cont = ASN1Dict([
        (u'sliceServiceType', _SNSSAI_sliceServiceType),
        (u'sliceDifferentiator', _SNSSAI_sliceDifferentiator),
        ])
    SNSSAI._ext = []
    
    #-----< SUCI >-----#
    SUCI = SEQ(name=u'SUCI', mode=MODE_TYPE)
    _SUCI_mCC = STR_NUM(name=u'mCC', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MCC')))
    _SUCI_mNC = STR_NUM(name=u'mNC', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MNC')))
    _SUCI_routingIndicator = INT(name=u'routingIndicator', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'RoutingIndicator')))
    _SUCI_protectionSchemeID = INT(name=u'protectionSchemeID', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'ProtectionSchemeID')))
    _SUCI_homeNetworkPublicKeyID = OCT_STR(name=u'homeNetworkPublicKeyID', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'HomeNetworkPublicKeyID')))
    _SUCI_schemeOutput = OCT_STR(name=u'schemeOutput', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SchemeOutput')))
    SUCI._cont = ASN1Dict([
        (u'mCC', _SUCI_mCC),
        (u'mNC', _SUCI_mNC),
        (u'routingIndicator', _SUCI_routingIndicator),
        (u'protectionSchemeID', _SUCI_protectionSchemeID),
        (u'homeNetworkPublicKeyID', _SUCI_homeNetworkPublicKeyID),
        (u'schemeOutput', _SUCI_schemeOutput),
        ])
    SUCI._ext = []
    
    #-----< SUPI >-----#
    SUPI = CHOICE(name=u'SUPI', mode=MODE_TYPE)
    _SUPI_iMSI = STR_NUM(name=u'iMSI', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'IMSI')))
    _SUPI_nAI = STR_UTF8(name=u'nAI', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'NAI')))
    SUPI._cont = ASN1Dict([
        (u'iMSI', _SUPI_iMSI),
        (u'nAI', _SUPI_nAI),
        ])
    SUPI._ext = []
    
    #-----< SUPIUnauthenticatedIndication >-----#
    SUPIUnauthenticatedIndication = BOOL(name=u'SUPIUnauthenticatedIndication', mode=MODE_TYPE)
    
    #-----< TargetIdentifier >-----#
    TargetIdentifier = CHOICE(name=u'TargetIdentifier', mode=MODE_TYPE)
    _TargetIdentifier_sUPI = CHOICE(name=u'sUPI', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SUPI')))
    _TargetIdentifier_iMSI = STR_NUM(name=u'iMSI', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'IMSI')))
    _TargetIdentifier_pEI = CHOICE(name=u'pEI', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PEI')))
    _TargetIdentifier_iMEI = STR_NUM(name=u'iMEI', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'IMEI')))
    _TargetIdentifier_gPSI = CHOICE(name=u'gPSI', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'GPSI')))
    _TargetIdentifier_mSISDN = STR_NUM(name=u'mSISDN', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MSISDN')))
    _TargetIdentifier_nAI = STR_UTF8(name=u'nAI', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'NAI')))
    _TargetIdentifier_iPv4Address = OCT_STR(name=u'iPv4Address', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'IPv4Address')))
    _TargetIdentifier_iPv6Address = OCT_STR(name=u'iPv6Address', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'IPv6Address')))
    _TargetIdentifier_ethernetAddress = OCT_STR(name=u'ethernetAddress', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MACAddress')))
    TargetIdentifier._cont = ASN1Dict([
        (u'sUPI', _TargetIdentifier_sUPI),
        (u'iMSI', _TargetIdentifier_iMSI),
        (u'pEI', _TargetIdentifier_pEI),
        (u'iMEI', _TargetIdentifier_iMEI),
        (u'gPSI', _TargetIdentifier_gPSI),
        (u'mSISDN', _TargetIdentifier_mSISDN),
        (u'nAI', _TargetIdentifier_nAI),
        (u'iPv4Address', _TargetIdentifier_iPv4Address),
        (u'iPv6Address', _TargetIdentifier_iPv6Address),
        (u'ethernetAddress', _TargetIdentifier_ethernetAddress),
        ])
    TargetIdentifier._ext = []
    
    #-----< TargetIdentifierProvenance >-----#
    TargetIdentifierProvenance = ENUM(name=u'TargetIdentifierProvenance', mode=MODE_TYPE)
    TargetIdentifierProvenance._cont = ASN1Dict([(u'lEAProvided', 1), (u'observed', 2), (u'matchedOn', 3), (u'other', 4)])
    TargetIdentifierProvenance._ext = []
    
    #-----< TELURI >-----#
    TELURI = STR_UTF8(name=u'TELURI', mode=MODE_TYPE)
    
    #-----< Timestamp >-----#
    Timestamp = TIME_GEN(name=u'Timestamp', mode=MODE_TYPE)
    
    #-----< UEEndpointAddress >-----#
    UEEndpointAddress = CHOICE(name=u'UEEndpointAddress', mode=MODE_TYPE)
    _UEEndpointAddress_iPv4Address = OCT_STR(name=u'iPv4Address', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'IPv4Address')))
    _UEEndpointAddress_iPv6Address = OCT_STR(name=u'iPv6Address', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'IPv6Address')))
    _UEEndpointAddress_ethernetAddress = OCT_STR(name=u'ethernetAddress', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MACAddress')))
    UEEndpointAddress._cont = ASN1Dict([
        (u'iPv4Address', _UEEndpointAddress_iPv4Address),
        (u'iPv6Address', _UEEndpointAddress_iPv6Address),
        (u'ethernetAddress', _UEEndpointAddress_ethernetAddress),
        ])
    UEEndpointAddress._ext = []
    
    #-----< Location >-----#
    Location = SEQ(name=u'Location', mode=MODE_TYPE)
    _Location_locationInfo = SEQ(name=u'locationInfo', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'LocationInfo')), opt=True)
    _Location_positioningInfo = SEQ(name=u'positioningInfo', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PositioningInfo')), opt=True)
    _Location_locationPresenceReport = SEQ(name=u'locationPresenceReport', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'LocationPresenceReport')), opt=True)
    Location._cont = ASN1Dict([
        (u'locationInfo', _Location_locationInfo),
        (u'positioningInfo', _Location_positioningInfo),
        (u'locationPresenceReport', _Location_locationPresenceReport),
        ])
    Location._ext = []
    
    #-----< CellSiteInformation >-----#
    CellSiteInformation = SEQ(name=u'CellSiteInformation', mode=MODE_TYPE)
    _CellSiteInformation_geographicalCoordinates = SEQ(name=u'geographicalCoordinates', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'GeographicalCoordinates')))
    _CellSiteInformation_azimuth = INT(name=u'azimuth', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CellSiteInformation_azimuth._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=359)], ev=None, er=[])
    _CellSiteInformation_operatorSpecificInformation = STR_UTF8(name=u'operatorSpecificInformation', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    CellSiteInformation._cont = ASN1Dict([
        (u'geographicalCoordinates', _CellSiteInformation_geographicalCoordinates),
        (u'azimuth', _CellSiteInformation_azimuth),
        (u'operatorSpecificInformation', _CellSiteInformation_operatorSpecificInformation),
        ])
    CellSiteInformation._ext = []
    
    #-----< LocationInfo >-----#
    LocationInfo = SEQ(name=u'LocationInfo', mode=MODE_TYPE)
    _LocationInfo_userLocation = SEQ(name=u'userLocation', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'UserLocation')), opt=True)
    _LocationInfo_currentLoc = BOOL(name=u'currentLoc', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _LocationInfo_geoInfo = CHOICE(name=u'geoInfo', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'GeographicArea')), opt=True)
    _LocationInfo_rATType = ENUM(name=u'rATType', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'RATType')), opt=True)
    _LocationInfo_timeZone = STR_UTF8(name=u'timeZone', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'TimeZone')), opt=True)
    _LocationInfo_additionalCellIDs = SEQ_OF(name=u'additionalCellIDs', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __LocationInfo_additionalCellIDs__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'CellInformation')))
    _LocationInfo_additionalCellIDs._cont = __LocationInfo_additionalCellIDs__item_
    LocationInfo._cont = ASN1Dict([
        (u'userLocation', _LocationInfo_userLocation),
        (u'currentLoc', _LocationInfo_currentLoc),
        (u'geoInfo', _LocationInfo_geoInfo),
        (u'rATType', _LocationInfo_rATType),
        (u'timeZone', _LocationInfo_timeZone),
        (u'additionalCellIDs', _LocationInfo_additionalCellIDs),
        ])
    LocationInfo._ext = []
    
    #-----< UserLocation >-----#
    UserLocation = SEQ(name=u'UserLocation', mode=MODE_TYPE)
    _UserLocation_eUTRALocation = SEQ(name=u'eUTRALocation', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'EUTRALocation')), opt=True)
    _UserLocation_nRLocation = SEQ(name=u'nRLocation', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'NRLocation')), opt=True)
    _UserLocation_n3GALocation = SEQ(name=u'n3GALocation', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'N3GALocation')), opt=True)
    UserLocation._cont = ASN1Dict([
        (u'eUTRALocation', _UserLocation_eUTRALocation),
        (u'nRLocation', _UserLocation_nRLocation),
        (u'n3GALocation', _UserLocation_n3GALocation),
        ])
    UserLocation._ext = []
    
    #-----< EUTRALocation >-----#
    EUTRALocation = SEQ(name=u'EUTRALocation', mode=MODE_TYPE)
    _EUTRALocation_tAI = SEQ(name=u'tAI', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'TAI')))
    _EUTRALocation_eCGI = SEQ(name=u'eCGI', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'ECGI')))
    _EUTRALocation_ageOfLocatonInfo = INT(name=u'ageOfLocatonInfo', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _EUTRALocation_uELocationTimestamp = TIME_GEN(name=u'uELocationTimestamp', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Timestamp')), opt=True)
    _EUTRALocation_geographicalInformation = STR_UTF8(name=u'geographicalInformation', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _EUTRALocation_geodeticInformation = STR_UTF8(name=u'geodeticInformation', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _EUTRALocation_globalNGENbID = SEQ(name=u'globalNGENbID', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'GlobalRANNodeID')), opt=True)
    _EUTRALocation_cellSiteInformation = SEQ(name=u'cellSiteInformation', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'CellSiteInformation')), opt=True)
    _EUTRALocation_globalENbID = SEQ(name=u'globalENbID', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'GlobalRANNodeID')), opt=True)
    EUTRALocation._cont = ASN1Dict([
        (u'tAI', _EUTRALocation_tAI),
        (u'eCGI', _EUTRALocation_eCGI),
        (u'ageOfLocatonInfo', _EUTRALocation_ageOfLocatonInfo),
        (u'uELocationTimestamp', _EUTRALocation_uELocationTimestamp),
        (u'geographicalInformation', _EUTRALocation_geographicalInformation),
        (u'geodeticInformation', _EUTRALocation_geodeticInformation),
        (u'globalNGENbID', _EUTRALocation_globalNGENbID),
        (u'cellSiteInformation', _EUTRALocation_cellSiteInformation),
        (u'globalENbID', _EUTRALocation_globalENbID),
        ])
    EUTRALocation._ext = []
    
    #-----< NRLocation >-----#
    NRLocation = SEQ(name=u'NRLocation', mode=MODE_TYPE)
    _NRLocation_tAI = SEQ(name=u'tAI', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'TAI')))
    _NRLocation_nCGI = SEQ(name=u'nCGI', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'NCGI')))
    _NRLocation_ageOfLocatonInfo = INT(name=u'ageOfLocatonInfo', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _NRLocation_uELocationTimestamp = TIME_GEN(name=u'uELocationTimestamp', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Timestamp')), opt=True)
    _NRLocation_geographicalInformation = STR_UTF8(name=u'geographicalInformation', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _NRLocation_geodeticInformation = STR_UTF8(name=u'geodeticInformation', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _NRLocation_globalGNbID = SEQ(name=u'globalGNbID', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'GlobalRANNodeID')), opt=True)
    _NRLocation_cellSiteInformation = SEQ(name=u'cellSiteInformation', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'CellSiteInformation')), opt=True)
    NRLocation._cont = ASN1Dict([
        (u'tAI', _NRLocation_tAI),
        (u'nCGI', _NRLocation_nCGI),
        (u'ageOfLocatonInfo', _NRLocation_ageOfLocatonInfo),
        (u'uELocationTimestamp', _NRLocation_uELocationTimestamp),
        (u'geographicalInformation', _NRLocation_geographicalInformation),
        (u'geodeticInformation', _NRLocation_geodeticInformation),
        (u'globalGNbID', _NRLocation_globalGNbID),
        (u'cellSiteInformation', _NRLocation_cellSiteInformation),
        ])
    NRLocation._ext = []
    
    #-----< N3GALocation >-----#
    N3GALocation = SEQ(name=u'N3GALocation', mode=MODE_TYPE)
    _N3GALocation_tAI = SEQ(name=u'tAI', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'TAI')), opt=True)
    _N3GALocation_n3IWFID = BIT_STR(name=u'n3IWFID', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'N3IWFIDNGAP')), opt=True)
    _N3GALocation_uEIPAddr = SEQ(name=u'uEIPAddr', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'IPAddr')), opt=True)
    _N3GALocation_portNumber = INT(name=u'portNumber', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    N3GALocation._cont = ASN1Dict([
        (u'tAI', _N3GALocation_tAI),
        (u'n3IWFID', _N3GALocation_n3IWFID),
        (u'uEIPAddr', _N3GALocation_uEIPAddr),
        (u'portNumber', _N3GALocation_portNumber),
        ])
    N3GALocation._ext = []
    
    #-----< IPAddr >-----#
    IPAddr = SEQ(name=u'IPAddr', mode=MODE_TYPE)
    _IPAddr_iPv4Addr = OCT_STR(name=u'iPv4Addr', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'IPv4Address')), opt=True)
    _IPAddr_iPv6Addr = OCT_STR(name=u'iPv6Addr', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'IPv6Address')), opt=True)
    IPAddr._cont = ASN1Dict([
        (u'iPv4Addr', _IPAddr_iPv4Addr),
        (u'iPv6Addr', _IPAddr_iPv6Addr),
        ])
    IPAddr._ext = []
    
    #-----< GlobalRANNodeID >-----#
    GlobalRANNodeID = SEQ(name=u'GlobalRANNodeID', mode=MODE_TYPE)
    _GlobalRANNodeID_pLMNID = SEQ(name=u'pLMNID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PLMNID')))
    _GlobalRANNodeID_aNNodeID = CHOICE(name=u'aNNodeID', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'ANNodeID')))
    _GlobalRANNodeID_nID = STR_UTF8(name=u'nID', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'NID')), opt=True)
    GlobalRANNodeID._cont = ASN1Dict([
        (u'pLMNID', _GlobalRANNodeID_pLMNID),
        (u'aNNodeID', _GlobalRANNodeID_aNNodeID),
        (u'nID', _GlobalRANNodeID_nID),
        ])
    GlobalRANNodeID._ext = []
    
    #-----< ANNodeID >-----#
    ANNodeID = CHOICE(name=u'ANNodeID', mode=MODE_TYPE)
    _ANNodeID_n3IWFID = STR_UTF8(name=u'n3IWFID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'N3IWFIDSBI')))
    _ANNodeID_gNbID = BIT_STR(name=u'gNbID', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'GNbID')))
    _ANNodeID_nGENbID = CHOICE(name=u'nGENbID', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'NGENbID')))
    _ANNodeID_eNbID = CHOICE(name=u'eNbID', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'ENbID')))
    ANNodeID._cont = ASN1Dict([
        (u'n3IWFID', _ANNodeID_n3IWFID),
        (u'gNbID', _ANNodeID_gNbID),
        (u'nGENbID', _ANNodeID_nGENbID),
        (u'eNbID', _ANNodeID_eNbID),
        ])
    ANNodeID._ext = []
    
    #-----< GNbID >-----#
    GNbID = BIT_STR(name=u'GNbID', mode=MODE_TYPE)
    GNbID._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=22, ub=32)], ev=None, er=[])
    
    #-----< TAI >-----#
    TAI = SEQ(name=u'TAI', mode=MODE_TYPE)
    _TAI_pLMNID = SEQ(name=u'pLMNID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PLMNID')))
    _TAI_tAC = OCT_STR(name=u'tAC', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'TAC')))
    _TAI_nID = STR_UTF8(name=u'nID', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'NID')), opt=True)
    TAI._cont = ASN1Dict([
        (u'pLMNID', _TAI_pLMNID),
        (u'tAC', _TAI_tAC),
        (u'nID', _TAI_nID),
        ])
    TAI._ext = []
    
    #-----< ECGI >-----#
    ECGI = SEQ(name=u'ECGI', mode=MODE_TYPE)
    _ECGI_pLMNID = SEQ(name=u'pLMNID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PLMNID')))
    _ECGI_eUTRACellID = BIT_STR(name=u'eUTRACellID', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'EUTRACellID')))
    _ECGI_nID = STR_UTF8(name=u'nID', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'NID')), opt=True)
    ECGI._cont = ASN1Dict([
        (u'pLMNID', _ECGI_pLMNID),
        (u'eUTRACellID', _ECGI_eUTRACellID),
        (u'nID', _ECGI_nID),
        ])
    ECGI._ext = []
    
    #-----< TAIList >-----#
    TAIList = SEQ_OF(name=u'TAIList', mode=MODE_TYPE)
    _TAIList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'TAI')))
    TAIList._cont = _TAIList__item_
    
    #-----< NCGI >-----#
    NCGI = SEQ(name=u'NCGI', mode=MODE_TYPE)
    _NCGI_pLMNID = SEQ(name=u'pLMNID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PLMNID')))
    _NCGI_nRCellID = BIT_STR(name=u'nRCellID', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'NRCellID')))
    _NCGI_nID = STR_UTF8(name=u'nID', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'NID')), opt=True)
    NCGI._cont = ASN1Dict([
        (u'pLMNID', _NCGI_pLMNID),
        (u'nRCellID', _NCGI_nRCellID),
        (u'nID', _NCGI_nID),
        ])
    NCGI._ext = []
    
    #-----< RANCGI >-----#
    RANCGI = CHOICE(name=u'RANCGI', mode=MODE_TYPE)
    _RANCGI_eCGI = SEQ(name=u'eCGI', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'ECGI')))
    _RANCGI_nCGI = SEQ(name=u'nCGI', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'NCGI')))
    RANCGI._cont = ASN1Dict([
        (u'eCGI', _RANCGI_eCGI),
        (u'nCGI', _RANCGI_nCGI),
        ])
    RANCGI._ext = []
    
    #-----< CellInformation >-----#
    CellInformation = SEQ(name=u'CellInformation', mode=MODE_TYPE)
    _CellInformation_rANCGI = CHOICE(name=u'rANCGI', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'RANCGI')))
    _CellInformation_cellSiteinformation = SEQ(name=u'cellSiteinformation', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'CellSiteInformation')), opt=True)
    _CellInformation_timeOfLocation = TIME_GEN(name=u'timeOfLocation', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Timestamp')), opt=True)
    CellInformation._cont = ASN1Dict([
        (u'rANCGI', _CellInformation_rANCGI),
        (u'cellSiteinformation', _CellInformation_cellSiteinformation),
        (u'timeOfLocation', _CellInformation_timeOfLocation),
        ])
    CellInformation._ext = []
    
    #-----< N3IWFIDNGAP >-----#
    N3IWFIDNGAP = BIT_STR(name=u'N3IWFIDNGAP', mode=MODE_TYPE)
    N3IWFIDNGAP._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    
    #-----< N3IWFIDSBI >-----#
    N3IWFIDSBI = STR_UTF8(name=u'N3IWFIDSBI', mode=MODE_TYPE)
    
    #-----< TAC >-----#
    TAC = OCT_STR(name=u'TAC', mode=MODE_TYPE)
    TAC._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=2, ub=3)], ev=None, er=[])
    
    #-----< EUTRACellID >-----#
    EUTRACellID = BIT_STR(name=u'EUTRACellID', mode=MODE_TYPE)
    EUTRACellID._const_sz = ASN1Set(rv=[28], rr=[], ev=None, er=[])
    
    #-----< NRCellID >-----#
    NRCellID = BIT_STR(name=u'NRCellID', mode=MODE_TYPE)
    NRCellID._const_sz = ASN1Set(rv=[36], rr=[], ev=None, er=[])
    
    #-----< NGENbID >-----#
    NGENbID = CHOICE(name=u'NGENbID', mode=MODE_TYPE)
    _NGENbID_macroNGENbID = BIT_STR(name=u'macroNGENbID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NGENbID_macroNGENbID._const_sz = ASN1Set(rv=[20], rr=[], ev=None, er=[])
    _NGENbID_shortMacroNGENbID = BIT_STR(name=u'shortMacroNGENbID', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NGENbID_shortMacroNGENbID._const_sz = ASN1Set(rv=[18], rr=[], ev=None, er=[])
    _NGENbID_longMacroNGENbID = BIT_STR(name=u'longMacroNGENbID', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _NGENbID_longMacroNGENbID._const_sz = ASN1Set(rv=[21], rr=[], ev=None, er=[])
    NGENbID._cont = ASN1Dict([
        (u'macroNGENbID', _NGENbID_macroNGENbID),
        (u'shortMacroNGENbID', _NGENbID_shortMacroNGENbID),
        (u'longMacroNGENbID', _NGENbID_longMacroNGENbID),
        ])
    NGENbID._ext = []
    
    #-----< NID >-----#
    NID = STR_UTF8(name=u'NID', mode=MODE_TYPE)
    NID._const_sz = ASN1Set(rv=[11], rr=[], ev=None, er=[])
    
    #-----< ENbID >-----#
    ENbID = CHOICE(name=u'ENbID', mode=MODE_TYPE)
    _ENbID_macroENbID = BIT_STR(name=u'macroENbID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ENbID_macroENbID._const_sz = ASN1Set(rv=[20], rr=[], ev=None, er=[])
    _ENbID_homeENbID = BIT_STR(name=u'homeENbID', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ENbID_homeENbID._const_sz = ASN1Set(rv=[28], rr=[], ev=None, er=[])
    _ENbID_shortMacroENbID = BIT_STR(name=u'shortMacroENbID', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ENbID_shortMacroENbID._const_sz = ASN1Set(rv=[18], rr=[], ev=None, er=[])
    _ENbID_longMacroENbID = BIT_STR(name=u'longMacroENbID', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ENbID_longMacroENbID._const_sz = ASN1Set(rv=[21], rr=[], ev=None, er=[])
    ENbID._cont = ASN1Dict([
        (u'macroENbID', _ENbID_macroENbID),
        (u'homeENbID', _ENbID_homeENbID),
        (u'shortMacroENbID', _ENbID_shortMacroENbID),
        (u'longMacroENbID', _ENbID_longMacroENbID),
        ])
    ENbID._ext = []
    
    #-----< PositioningInfo >-----#
    PositioningInfo = SEQ(name=u'PositioningInfo', mode=MODE_TYPE)
    _PositioningInfo_positionInfo = SEQ(name=u'positionInfo', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'LocationData')), opt=True)
    _PositioningInfo_rawMLPResponse = CHOICE(name=u'rawMLPResponse', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'RawMLPResponse')), opt=True)
    PositioningInfo._cont = ASN1Dict([
        (u'positionInfo', _PositioningInfo_positionInfo),
        (u'rawMLPResponse', _PositioningInfo_rawMLPResponse),
        ])
    PositioningInfo._ext = []
    
    #-----< RawMLPResponse >-----#
    RawMLPResponse = CHOICE(name=u'RawMLPResponse', mode=MODE_TYPE)
    _RawMLPResponse_mLPPositionData = STR_UTF8(name=u'mLPPositionData', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _RawMLPResponse_mLPErrorCode = INT(name=u'mLPErrorCode', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _RawMLPResponse_mLPErrorCode._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=699)], ev=None, er=[])
    RawMLPResponse._cont = ASN1Dict([
        (u'mLPPositionData', _RawMLPResponse_mLPPositionData),
        (u'mLPErrorCode', _RawMLPResponse_mLPErrorCode),
        ])
    RawMLPResponse._ext = []
    
    #-----< LocationData >-----#
    LocationData = SEQ(name=u'LocationData', mode=MODE_TYPE)
    _LocationData_locationEstimate = CHOICE(name=u'locationEstimate', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'GeographicArea')))
    _LocationData_accuracyFulfilmentIndicator = ENUM(name=u'accuracyFulfilmentIndicator', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'AccuracyFulfilmentIndicator')), opt=True)
    _LocationData_ageOfLocationEstimate = INT(name=u'ageOfLocationEstimate', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'AgeOfLocationEstimate')), opt=True)
    _LocationData_velocityEstimate = CHOICE(name=u'velocityEstimate', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'VelocityEstimate')), opt=True)
    _LocationData_civicAddress = SEQ(name=u'civicAddress', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'CivicAddress')), opt=True)
    _LocationData_positioningDataList = SET_OF(name=u'positioningDataList', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __LocationData_positioningDataList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'PositioningMethodAndUsage')))
    _LocationData_positioningDataList._cont = __LocationData_positioningDataList__item_
    _LocationData_gNSSPositioningDataList = SET_OF(name=u'gNSSPositioningDataList', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __LocationData_gNSSPositioningDataList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'GNSSPositioningMethodAndUsage')))
    _LocationData_gNSSPositioningDataList._cont = __LocationData_gNSSPositioningDataList__item_
    _LocationData_eCGI = SEQ(name=u'eCGI', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'ECGI')), opt=True)
    _LocationData_nCGI = SEQ(name=u'nCGI', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'NCGI')), opt=True)
    _LocationData_altitude = STR_UTF8(name=u'altitude', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Altitude')), opt=True)
    _LocationData_barometricPressure = INT(name=u'barometricPressure', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'BarometricPressure')), opt=True)
    LocationData._cont = ASN1Dict([
        (u'locationEstimate', _LocationData_locationEstimate),
        (u'accuracyFulfilmentIndicator', _LocationData_accuracyFulfilmentIndicator),
        (u'ageOfLocationEstimate', _LocationData_ageOfLocationEstimate),
        (u'velocityEstimate', _LocationData_velocityEstimate),
        (u'civicAddress', _LocationData_civicAddress),
        (u'positioningDataList', _LocationData_positioningDataList),
        (u'gNSSPositioningDataList', _LocationData_gNSSPositioningDataList),
        (u'eCGI', _LocationData_eCGI),
        (u'nCGI', _LocationData_nCGI),
        (u'altitude', _LocationData_altitude),
        (u'barometricPressure', _LocationData_barometricPressure),
        ])
    LocationData._ext = []
    
    #-----< LocationPresenceReport >-----#
    LocationPresenceReport = SEQ(name=u'LocationPresenceReport', mode=MODE_TYPE)
    _LocationPresenceReport_type = ENUM(name=u'type', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'AMFEventType')))
    _LocationPresenceReport_timestamp = TIME_GEN(name=u'timestamp', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Timestamp')))
    _LocationPresenceReport_areaList = SET_OF(name=u'areaList', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __LocationPresenceReport_areaList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'AMFEventArea')))
    _LocationPresenceReport_areaList._cont = __LocationPresenceReport_areaList__item_
    _LocationPresenceReport_timeZone = STR_UTF8(name=u'timeZone', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'TimeZone')), opt=True)
    _LocationPresenceReport_accessTypes = SET_OF(name=u'accessTypes', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __LocationPresenceReport_accessTypes__item_ = ENUM(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'AccessType')))
    _LocationPresenceReport_accessTypes._cont = __LocationPresenceReport_accessTypes__item_
    _LocationPresenceReport_rMInfoList = SET_OF(name=u'rMInfoList', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __LocationPresenceReport_rMInfoList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'RMInfo')))
    _LocationPresenceReport_rMInfoList._cont = __LocationPresenceReport_rMInfoList__item_
    _LocationPresenceReport_cMInfoList = SET_OF(name=u'cMInfoList', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __LocationPresenceReport_cMInfoList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'CMInfo')))
    _LocationPresenceReport_cMInfoList._cont = __LocationPresenceReport_cMInfoList__item_
    _LocationPresenceReport_reachability = ENUM(name=u'reachability', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'UEReachability')), opt=True)
    _LocationPresenceReport_location = SEQ(name=u'location', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'UserLocation')), opt=True)
    _LocationPresenceReport_additionalCellIDs = SEQ_OF(name=u'additionalCellIDs', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __LocationPresenceReport_additionalCellIDs__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'CellInformation')))
    _LocationPresenceReport_additionalCellIDs._cont = __LocationPresenceReport_additionalCellIDs__item_
    LocationPresenceReport._cont = ASN1Dict([
        (u'type', _LocationPresenceReport_type),
        (u'timestamp', _LocationPresenceReport_timestamp),
        (u'areaList', _LocationPresenceReport_areaList),
        (u'timeZone', _LocationPresenceReport_timeZone),
        (u'accessTypes', _LocationPresenceReport_accessTypes),
        (u'rMInfoList', _LocationPresenceReport_rMInfoList),
        (u'cMInfoList', _LocationPresenceReport_cMInfoList),
        (u'reachability', _LocationPresenceReport_reachability),
        (u'location', _LocationPresenceReport_location),
        (u'additionalCellIDs', _LocationPresenceReport_additionalCellIDs),
        ])
    LocationPresenceReport._ext = []
    
    #-----< AMFEventType >-----#
    AMFEventType = ENUM(name=u'AMFEventType', mode=MODE_TYPE)
    AMFEventType._cont = ASN1Dict([(u'locationReport', 1), (u'presenceInAOIReport', 2)])
    AMFEventType._ext = []
    
    #-----< AMFEventArea >-----#
    AMFEventArea = SEQ(name=u'AMFEventArea', mode=MODE_TYPE)
    _AMFEventArea_presenceInfo = SEQ(name=u'presenceInfo', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PresenceInfo')), opt=True)
    _AMFEventArea_lADNInfo = SEQ(name=u'lADNInfo', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'LADNInfo')), opt=True)
    AMFEventArea._cont = ASN1Dict([
        (u'presenceInfo', _AMFEventArea_presenceInfo),
        (u'lADNInfo', _AMFEventArea_lADNInfo),
        ])
    AMFEventArea._ext = []
    
    #-----< PresenceInfo >-----#
    PresenceInfo = SEQ(name=u'PresenceInfo', mode=MODE_TYPE)
    _PresenceInfo_presenceState = ENUM(name=u'presenceState', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PresenceState')), opt=True)
    _PresenceInfo_trackingAreaList = SET_OF(name=u'trackingAreaList', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __PresenceInfo_trackingAreaList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'TAI')))
    _PresenceInfo_trackingAreaList._cont = __PresenceInfo_trackingAreaList__item_
    _PresenceInfo_eCGIList = SET_OF(name=u'eCGIList', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __PresenceInfo_eCGIList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'ECGI')))
    _PresenceInfo_eCGIList._cont = __PresenceInfo_eCGIList__item_
    _PresenceInfo_nCGIList = SET_OF(name=u'nCGIList', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __PresenceInfo_nCGIList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'NCGI')))
    _PresenceInfo_nCGIList._cont = __PresenceInfo_nCGIList__item_
    _PresenceInfo_globalRANNodeIDList = SET_OF(name=u'globalRANNodeIDList', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __PresenceInfo_globalRANNodeIDList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'GlobalRANNodeID')))
    _PresenceInfo_globalRANNodeIDList._cont = __PresenceInfo_globalRANNodeIDList__item_
    _PresenceInfo_globalENbIDList = SET_OF(name=u'globalENbIDList', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __PresenceInfo_globalENbIDList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'GlobalRANNodeID')))
    _PresenceInfo_globalENbIDList._cont = __PresenceInfo_globalENbIDList__item_
    PresenceInfo._cont = ASN1Dict([
        (u'presenceState', _PresenceInfo_presenceState),
        (u'trackingAreaList', _PresenceInfo_trackingAreaList),
        (u'eCGIList', _PresenceInfo_eCGIList),
        (u'nCGIList', _PresenceInfo_nCGIList),
        (u'globalRANNodeIDList', _PresenceInfo_globalRANNodeIDList),
        (u'globalENbIDList', _PresenceInfo_globalENbIDList),
        ])
    PresenceInfo._ext = []
    
    #-----< LADNInfo >-----#
    LADNInfo = SEQ(name=u'LADNInfo', mode=MODE_TYPE)
    _LADNInfo_lADN = STR_UTF8(name=u'lADN', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _LADNInfo_presence = ENUM(name=u'presence', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PresenceState')), opt=True)
    LADNInfo._cont = ASN1Dict([
        (u'lADN', _LADNInfo_lADN),
        (u'presence', _LADNInfo_presence),
        ])
    LADNInfo._ext = []
    
    #-----< PresenceState >-----#
    PresenceState = ENUM(name=u'PresenceState', mode=MODE_TYPE)
    PresenceState._cont = ASN1Dict([(u'inArea', 1), (u'outOfArea', 2), (u'unknown', 3), (u'inactive', 4)])
    PresenceState._ext = []
    
    #-----< RMInfo >-----#
    RMInfo = SEQ(name=u'RMInfo', mode=MODE_TYPE)
    _RMInfo_rMState = ENUM(name=u'rMState', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'RMState')))
    _RMInfo_accessType = ENUM(name=u'accessType', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'AccessType')))
    RMInfo._cont = ASN1Dict([
        (u'rMState', _RMInfo_rMState),
        (u'accessType', _RMInfo_accessType),
        ])
    RMInfo._ext = []
    
    #-----< CMInfo >-----#
    CMInfo = SEQ(name=u'CMInfo', mode=MODE_TYPE)
    _CMInfo_cMState = ENUM(name=u'cMState', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'CMState')))
    _CMInfo_accessType = ENUM(name=u'accessType', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'AccessType')))
    CMInfo._cont = ASN1Dict([
        (u'cMState', _CMInfo_cMState),
        (u'accessType', _CMInfo_accessType),
        ])
    CMInfo._ext = []
    
    #-----< UEReachability >-----#
    UEReachability = ENUM(name=u'UEReachability', mode=MODE_TYPE)
    UEReachability._cont = ASN1Dict([(u'unreachable', 1), (u'reachable', 2), (u'regulatoryOnly', 3)])
    UEReachability._ext = []
    
    #-----< RMState >-----#
    RMState = ENUM(name=u'RMState', mode=MODE_TYPE)
    RMState._cont = ASN1Dict([(u'registered', 1), (u'deregistered', 2)])
    RMState._ext = []
    
    #-----< CMState >-----#
    CMState = ENUM(name=u'CMState', mode=MODE_TYPE)
    CMState._cont = ASN1Dict([(u'idle', 1), (u'connected', 2)])
    CMState._ext = []
    
    #-----< GeographicArea >-----#
    GeographicArea = CHOICE(name=u'GeographicArea', mode=MODE_TYPE)
    _GeographicArea_point = SEQ(name=u'point', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Point')))
    _GeographicArea_pointUncertaintyCircle = SEQ(name=u'pointUncertaintyCircle', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PointUncertaintyCircle')))
    _GeographicArea_pointUncertaintyEllipse = SEQ(name=u'pointUncertaintyEllipse', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PointUncertaintyEllipse')))
    _GeographicArea_polygon = SEQ(name=u'polygon', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Polygon')))
    _GeographicArea_pointAltitude = SEQ(name=u'pointAltitude', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PointAltitude')))
    _GeographicArea_pointAltitudeUncertainty = SEQ(name=u'pointAltitudeUncertainty', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PointAltitudeUncertainty')))
    _GeographicArea_ellipsoidArc = SEQ(name=u'ellipsoidArc', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'EllipsoidArc')))
    GeographicArea._cont = ASN1Dict([
        (u'point', _GeographicArea_point),
        (u'pointUncertaintyCircle', _GeographicArea_pointUncertaintyCircle),
        (u'pointUncertaintyEllipse', _GeographicArea_pointUncertaintyEllipse),
        (u'polygon', _GeographicArea_polygon),
        (u'pointAltitude', _GeographicArea_pointAltitude),
        (u'pointAltitudeUncertainty', _GeographicArea_pointAltitudeUncertainty),
        (u'ellipsoidArc', _GeographicArea_ellipsoidArc),
        ])
    GeographicArea._ext = []
    
    #-----< AccuracyFulfilmentIndicator >-----#
    AccuracyFulfilmentIndicator = ENUM(name=u'AccuracyFulfilmentIndicator', mode=MODE_TYPE)
    AccuracyFulfilmentIndicator._cont = ASN1Dict([(u'requestedAccuracyFulfilled', 1), (u'requestedAccuracyNotFulfilled', 2)])
    AccuracyFulfilmentIndicator._ext = []
    
    #-----< VelocityEstimate >-----#
    VelocityEstimate = CHOICE(name=u'VelocityEstimate', mode=MODE_TYPE)
    _VelocityEstimate_horVelocity = SEQ(name=u'horVelocity', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'HorizontalVelocity')))
    _VelocityEstimate_horWithVertVelocity = SEQ(name=u'horWithVertVelocity', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'HorizontalWithVerticalVelocity')))
    _VelocityEstimate_horVelocityWithUncertainty = SEQ(name=u'horVelocityWithUncertainty', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'HorizontalVelocityWithUncertainty')))
    _VelocityEstimate_horWithVertVelocityAndUncertainty = SEQ(name=u'horWithVertVelocityAndUncertainty', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'HorizontalWithVerticalVelocityAndUncertainty')))
    VelocityEstimate._cont = ASN1Dict([
        (u'horVelocity', _VelocityEstimate_horVelocity),
        (u'horWithVertVelocity', _VelocityEstimate_horWithVertVelocity),
        (u'horVelocityWithUncertainty', _VelocityEstimate_horVelocityWithUncertainty),
        (u'horWithVertVelocityAndUncertainty', _VelocityEstimate_horWithVertVelocityAndUncertainty),
        ])
    VelocityEstimate._ext = []
    
    #-----< CivicAddress >-----#
    CivicAddress = SEQ(name=u'CivicAddress', mode=MODE_TYPE)
    _CivicAddress_country = STR_UTF8(name=u'country', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _CivicAddress_a1 = STR_UTF8(name=u'a1', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CivicAddress_a2 = STR_UTF8(name=u'a2', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CivicAddress_a3 = STR_UTF8(name=u'a3', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CivicAddress_a4 = STR_UTF8(name=u'a4', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CivicAddress_a5 = STR_UTF8(name=u'a5', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CivicAddress_a6 = STR_UTF8(name=u'a6', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CivicAddress_prd = STR_UTF8(name=u'prd', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CivicAddress_pod = STR_UTF8(name=u'pod', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CivicAddress_sts = STR_UTF8(name=u'sts', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CivicAddress_hno = STR_UTF8(name=u'hno', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CivicAddress_hns = STR_UTF8(name=u'hns', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CivicAddress_lmk = STR_UTF8(name=u'lmk', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CivicAddress_loc = STR_UTF8(name=u'loc', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CivicAddress_nam = STR_UTF8(name=u'nam', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CivicAddress_pc = STR_UTF8(name=u'pc', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CivicAddress_bld = STR_UTF8(name=u'bld', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CivicAddress_unit = STR_UTF8(name=u'unit', mode=MODE_TYPE, tag=(18, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CivicAddress_flr = STR_UTF8(name=u'flr', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CivicAddress_room = STR_UTF8(name=u'room', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CivicAddress_plc = STR_UTF8(name=u'plc', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CivicAddress_pcn = STR_UTF8(name=u'pcn', mode=MODE_TYPE, tag=(22, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CivicAddress_pobox = STR_UTF8(name=u'pobox', mode=MODE_TYPE, tag=(23, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CivicAddress_addcode = STR_UTF8(name=u'addcode', mode=MODE_TYPE, tag=(24, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CivicAddress_seat = STR_UTF8(name=u'seat', mode=MODE_TYPE, tag=(25, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CivicAddress_rd = STR_UTF8(name=u'rd', mode=MODE_TYPE, tag=(26, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CivicAddress_rdsec = STR_UTF8(name=u'rdsec', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CivicAddress_rdbr = STR_UTF8(name=u'rdbr', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CivicAddress_rdsubbr = STR_UTF8(name=u'rdsubbr', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CivicAddress_prm = STR_UTF8(name=u'prm', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CivicAddress_pom = STR_UTF8(name=u'pom', mode=MODE_TYPE, tag=(31, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    CivicAddress._cont = ASN1Dict([
        (u'country', _CivicAddress_country),
        (u'a1', _CivicAddress_a1),
        (u'a2', _CivicAddress_a2),
        (u'a3', _CivicAddress_a3),
        (u'a4', _CivicAddress_a4),
        (u'a5', _CivicAddress_a5),
        (u'a6', _CivicAddress_a6),
        (u'prd', _CivicAddress_prd),
        (u'pod', _CivicAddress_pod),
        (u'sts', _CivicAddress_sts),
        (u'hno', _CivicAddress_hno),
        (u'hns', _CivicAddress_hns),
        (u'lmk', _CivicAddress_lmk),
        (u'loc', _CivicAddress_loc),
        (u'nam', _CivicAddress_nam),
        (u'pc', _CivicAddress_pc),
        (u'bld', _CivicAddress_bld),
        (u'unit', _CivicAddress_unit),
        (u'flr', _CivicAddress_flr),
        (u'room', _CivicAddress_room),
        (u'plc', _CivicAddress_plc),
        (u'pcn', _CivicAddress_pcn),
        (u'pobox', _CivicAddress_pobox),
        (u'addcode', _CivicAddress_addcode),
        (u'seat', _CivicAddress_seat),
        (u'rd', _CivicAddress_rd),
        (u'rdsec', _CivicAddress_rdsec),
        (u'rdbr', _CivicAddress_rdbr),
        (u'rdsubbr', _CivicAddress_rdsubbr),
        (u'prm', _CivicAddress_prm),
        (u'pom', _CivicAddress_pom),
        ])
    CivicAddress._ext = []
    
    #-----< PositioningMethodAndUsage >-----#
    PositioningMethodAndUsage = SEQ(name=u'PositioningMethodAndUsage', mode=MODE_TYPE)
    _PositioningMethodAndUsage_method = ENUM(name=u'method', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PositioningMethod')))
    _PositioningMethodAndUsage_mode = ENUM(name=u'mode', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PositioningMode')))
    _PositioningMethodAndUsage_usage = ENUM(name=u'usage', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Usage')))
    _PositioningMethodAndUsage_methodCode = INT(name=u'methodCode', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'MethodCode')), opt=True)
    PositioningMethodAndUsage._cont = ASN1Dict([
        (u'method', _PositioningMethodAndUsage_method),
        (u'mode', _PositioningMethodAndUsage_mode),
        (u'usage', _PositioningMethodAndUsage_usage),
        (u'methodCode', _PositioningMethodAndUsage_methodCode),
        ])
    PositioningMethodAndUsage._ext = []
    
    #-----< GNSSPositioningMethodAndUsage >-----#
    GNSSPositioningMethodAndUsage = SEQ(name=u'GNSSPositioningMethodAndUsage', mode=MODE_TYPE)
    _GNSSPositioningMethodAndUsage_mode = ENUM(name=u'mode', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'PositioningMode')))
    _GNSSPositioningMethodAndUsage_gNSS = ENUM(name=u'gNSS', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'GNSSID')))
    _GNSSPositioningMethodAndUsage_usage = ENUM(name=u'usage', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Usage')))
    GNSSPositioningMethodAndUsage._cont = ASN1Dict([
        (u'mode', _GNSSPositioningMethodAndUsage_mode),
        (u'gNSS', _GNSSPositioningMethodAndUsage_gNSS),
        (u'usage', _GNSSPositioningMethodAndUsage_usage),
        ])
    GNSSPositioningMethodAndUsage._ext = []
    
    #-----< Point >-----#
    Point = SEQ(name=u'Point', mode=MODE_TYPE)
    _Point_geographicalCoordinates = SEQ(name=u'geographicalCoordinates', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'GeographicalCoordinates')))
    Point._cont = ASN1Dict([
        (u'geographicalCoordinates', _Point_geographicalCoordinates),
        ])
    Point._ext = []
    
    #-----< PointUncertaintyCircle >-----#
    PointUncertaintyCircle = SEQ(name=u'PointUncertaintyCircle', mode=MODE_TYPE)
    _PointUncertaintyCircle_geographicalCoordinates = SEQ(name=u'geographicalCoordinates', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'GeographicalCoordinates')))
    _PointUncertaintyCircle_uncertainty = INT(name=u'uncertainty', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Uncertainty')))
    PointUncertaintyCircle._cont = ASN1Dict([
        (u'geographicalCoordinates', _PointUncertaintyCircle_geographicalCoordinates),
        (u'uncertainty', _PointUncertaintyCircle_uncertainty),
        ])
    PointUncertaintyCircle._ext = []
    
    #-----< PointUncertaintyEllipse >-----#
    PointUncertaintyEllipse = SEQ(name=u'PointUncertaintyEllipse', mode=MODE_TYPE)
    _PointUncertaintyEllipse_geographicalCoordinates = SEQ(name=u'geographicalCoordinates', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'GeographicalCoordinates')))
    _PointUncertaintyEllipse_uncertainty = SEQ(name=u'uncertainty', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'UncertaintyEllipse')))
    _PointUncertaintyEllipse_confidence = INT(name=u'confidence', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Confidence')))
    PointUncertaintyEllipse._cont = ASN1Dict([
        (u'geographicalCoordinates', _PointUncertaintyEllipse_geographicalCoordinates),
        (u'uncertainty', _PointUncertaintyEllipse_uncertainty),
        (u'confidence', _PointUncertaintyEllipse_confidence),
        ])
    PointUncertaintyEllipse._ext = []
    
    #-----< Polygon >-----#
    Polygon = SEQ(name=u'Polygon', mode=MODE_TYPE)
    _Polygon_pointList = SET_OF(name=u'pointList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __Polygon_pointList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TS33128Payloads', 'GeographicalCoordinates')))
    _Polygon_pointList._cont = __Polygon_pointList__item_
    _Polygon_pointList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=3, ub=15)], ev=None, er=[])
    Polygon._cont = ASN1Dict([
        (u'pointList', _Polygon_pointList),
        ])
    Polygon._ext = []
    
    #-----< PointAltitude >-----#
    PointAltitude = SEQ(name=u'PointAltitude', mode=MODE_TYPE)
    _PointAltitude_point = SEQ(name=u'point', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'GeographicalCoordinates')))
    _PointAltitude_altitude = STR_UTF8(name=u'altitude', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Altitude')))
    PointAltitude._cont = ASN1Dict([
        (u'point', _PointAltitude_point),
        (u'altitude', _PointAltitude_altitude),
        ])
    PointAltitude._ext = []
    
    #-----< PointAltitudeUncertainty >-----#
    PointAltitudeUncertainty = SEQ(name=u'PointAltitudeUncertainty', mode=MODE_TYPE)
    _PointAltitudeUncertainty_point = SEQ(name=u'point', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'GeographicalCoordinates')))
    _PointAltitudeUncertainty_altitude = STR_UTF8(name=u'altitude', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Altitude')))
    _PointAltitudeUncertainty_uncertaintyEllipse = SEQ(name=u'uncertaintyEllipse', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'UncertaintyEllipse')))
    _PointAltitudeUncertainty_uncertaintyAltitude = INT(name=u'uncertaintyAltitude', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Uncertainty')))
    _PointAltitudeUncertainty_confidence = INT(name=u'confidence', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Confidence')))
    PointAltitudeUncertainty._cont = ASN1Dict([
        (u'point', _PointAltitudeUncertainty_point),
        (u'altitude', _PointAltitudeUncertainty_altitude),
        (u'uncertaintyEllipse', _PointAltitudeUncertainty_uncertaintyEllipse),
        (u'uncertaintyAltitude', _PointAltitudeUncertainty_uncertaintyAltitude),
        (u'confidence', _PointAltitudeUncertainty_confidence),
        ])
    PointAltitudeUncertainty._ext = []
    
    #-----< EllipsoidArc >-----#
    EllipsoidArc = SEQ(name=u'EllipsoidArc', mode=MODE_TYPE)
    _EllipsoidArc_point = SEQ(name=u'point', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'GeographicalCoordinates')))
    _EllipsoidArc_innerRadius = INT(name=u'innerRadius', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'InnerRadius')))
    _EllipsoidArc_uncertaintyRadius = INT(name=u'uncertaintyRadius', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Uncertainty')))
    _EllipsoidArc_offsetAngle = INT(name=u'offsetAngle', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Angle')))
    _EllipsoidArc_includedAngle = INT(name=u'includedAngle', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Angle')))
    _EllipsoidArc_confidence = INT(name=u'confidence', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Confidence')))
    EllipsoidArc._cont = ASN1Dict([
        (u'point', _EllipsoidArc_point),
        (u'innerRadius', _EllipsoidArc_innerRadius),
        (u'uncertaintyRadius', _EllipsoidArc_uncertaintyRadius),
        (u'offsetAngle', _EllipsoidArc_offsetAngle),
        (u'includedAngle', _EllipsoidArc_includedAngle),
        (u'confidence', _EllipsoidArc_confidence),
        ])
    EllipsoidArc._ext = []
    
    #-----< GeographicalCoordinates >-----#
    GeographicalCoordinates = SEQ(name=u'GeographicalCoordinates', mode=MODE_TYPE)
    _GeographicalCoordinates_latitude = STR_UTF8(name=u'latitude', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GeographicalCoordinates_longitude = STR_UTF8(name=u'longitude', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GeographicalCoordinates_mapDatumInformation = STR_UTF8(name=u'mapDatumInformation', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'OGCURN')), opt=True)
    GeographicalCoordinates._cont = ASN1Dict([
        (u'latitude', _GeographicalCoordinates_latitude),
        (u'longitude', _GeographicalCoordinates_longitude),
        (u'mapDatumInformation', _GeographicalCoordinates_mapDatumInformation),
        ])
    GeographicalCoordinates._ext = []
    
    #-----< UncertaintyEllipse >-----#
    UncertaintyEllipse = SEQ(name=u'UncertaintyEllipse', mode=MODE_TYPE)
    _UncertaintyEllipse_semiMajor = INT(name=u'semiMajor', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Uncertainty')))
    _UncertaintyEllipse_semiMinor = INT(name=u'semiMinor', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Uncertainty')))
    _UncertaintyEllipse_orientationMajor = INT(name=u'orientationMajor', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Orientation')))
    UncertaintyEllipse._cont = ASN1Dict([
        (u'semiMajor', _UncertaintyEllipse_semiMajor),
        (u'semiMinor', _UncertaintyEllipse_semiMinor),
        (u'orientationMajor', _UncertaintyEllipse_orientationMajor),
        ])
    UncertaintyEllipse._ext = []
    
    #-----< HorizontalVelocity >-----#
    HorizontalVelocity = SEQ(name=u'HorizontalVelocity', mode=MODE_TYPE)
    _HorizontalVelocity_hSpeed = STR_UTF8(name=u'hSpeed', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'HorizontalSpeed')))
    _HorizontalVelocity_bearing = INT(name=u'bearing', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Angle')))
    HorizontalVelocity._cont = ASN1Dict([
        (u'hSpeed', _HorizontalVelocity_hSpeed),
        (u'bearing', _HorizontalVelocity_bearing),
        ])
    HorizontalVelocity._ext = []
    
    #-----< HorizontalWithVerticalVelocity >-----#
    HorizontalWithVerticalVelocity = SEQ(name=u'HorizontalWithVerticalVelocity', mode=MODE_TYPE)
    _HorizontalWithVerticalVelocity_hSpeed = STR_UTF8(name=u'hSpeed', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'HorizontalSpeed')))
    _HorizontalWithVerticalVelocity_bearing = INT(name=u'bearing', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Angle')))
    _HorizontalWithVerticalVelocity_vSpeed = STR_UTF8(name=u'vSpeed', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'VerticalSpeed')))
    _HorizontalWithVerticalVelocity_vDirection = ENUM(name=u'vDirection', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'VerticalDirection')))
    HorizontalWithVerticalVelocity._cont = ASN1Dict([
        (u'hSpeed', _HorizontalWithVerticalVelocity_hSpeed),
        (u'bearing', _HorizontalWithVerticalVelocity_bearing),
        (u'vSpeed', _HorizontalWithVerticalVelocity_vSpeed),
        (u'vDirection', _HorizontalWithVerticalVelocity_vDirection),
        ])
    HorizontalWithVerticalVelocity._ext = []
    
    #-----< HorizontalVelocityWithUncertainty >-----#
    HorizontalVelocityWithUncertainty = SEQ(name=u'HorizontalVelocityWithUncertainty', mode=MODE_TYPE)
    _HorizontalVelocityWithUncertainty_hSpeed = STR_UTF8(name=u'hSpeed', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'HorizontalSpeed')))
    _HorizontalVelocityWithUncertainty_bearing = INT(name=u'bearing', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Angle')))
    _HorizontalVelocityWithUncertainty_uncertainty = STR_UTF8(name=u'uncertainty', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SpeedUncertainty')))
    HorizontalVelocityWithUncertainty._cont = ASN1Dict([
        (u'hSpeed', _HorizontalVelocityWithUncertainty_hSpeed),
        (u'bearing', _HorizontalVelocityWithUncertainty_bearing),
        (u'uncertainty', _HorizontalVelocityWithUncertainty_uncertainty),
        ])
    HorizontalVelocityWithUncertainty._ext = []
    
    #-----< HorizontalWithVerticalVelocityAndUncertainty >-----#
    HorizontalWithVerticalVelocityAndUncertainty = SEQ(name=u'HorizontalWithVerticalVelocityAndUncertainty', mode=MODE_TYPE)
    _HorizontalWithVerticalVelocityAndUncertainty_hspeed = STR_UTF8(name=u'hspeed', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'HorizontalSpeed')))
    _HorizontalWithVerticalVelocityAndUncertainty_bearing = INT(name=u'bearing', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'Angle')))
    _HorizontalWithVerticalVelocityAndUncertainty_vSpeed = STR_UTF8(name=u'vSpeed', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'VerticalSpeed')))
    _HorizontalWithVerticalVelocityAndUncertainty_vDirection = ENUM(name=u'vDirection', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'VerticalDirection')))
    _HorizontalWithVerticalVelocityAndUncertainty_hUncertainty = STR_UTF8(name=u'hUncertainty', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SpeedUncertainty')))
    _HorizontalWithVerticalVelocityAndUncertainty_vUncertainty = STR_UTF8(name=u'vUncertainty', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('TS33128Payloads', 'SpeedUncertainty')))
    HorizontalWithVerticalVelocityAndUncertainty._cont = ASN1Dict([
        (u'hspeed', _HorizontalWithVerticalVelocityAndUncertainty_hspeed),
        (u'bearing', _HorizontalWithVerticalVelocityAndUncertainty_bearing),
        (u'vSpeed', _HorizontalWithVerticalVelocityAndUncertainty_vSpeed),
        (u'vDirection', _HorizontalWithVerticalVelocityAndUncertainty_vDirection),
        (u'hUncertainty', _HorizontalWithVerticalVelocityAndUncertainty_hUncertainty),
        (u'vUncertainty', _HorizontalWithVerticalVelocityAndUncertainty_vUncertainty),
        ])
    HorizontalWithVerticalVelocityAndUncertainty._ext = []
    
    #-----< Altitude >-----#
    Altitude = STR_UTF8(name=u'Altitude', mode=MODE_TYPE)
    
    #-----< Angle >-----#
    Angle = INT(name=u'Angle', mode=MODE_TYPE)
    Angle._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=360)], ev=None, er=[])
    
    #-----< Uncertainty >-----#
    Uncertainty = INT(name=u'Uncertainty', mode=MODE_TYPE)
    Uncertainty._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    
    #-----< Orientation >-----#
    Orientation = INT(name=u'Orientation', mode=MODE_TYPE)
    Orientation._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=180)], ev=None, er=[])
    
    #-----< Confidence >-----#
    Confidence = INT(name=u'Confidence', mode=MODE_TYPE)
    Confidence._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=100)], ev=None, er=[])
    
    #-----< InnerRadius >-----#
    InnerRadius = INT(name=u'InnerRadius', mode=MODE_TYPE)
    InnerRadius._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    
    #-----< AgeOfLocationEstimate >-----#
    AgeOfLocationEstimate = INT(name=u'AgeOfLocationEstimate', mode=MODE_TYPE)
    AgeOfLocationEstimate._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=32767)], ev=None, er=[])
    
    #-----< HorizontalSpeed >-----#
    HorizontalSpeed = STR_UTF8(name=u'HorizontalSpeed', mode=MODE_TYPE)
    
    #-----< VerticalSpeed >-----#
    VerticalSpeed = STR_UTF8(name=u'VerticalSpeed', mode=MODE_TYPE)
    
    #-----< SpeedUncertainty >-----#
    SpeedUncertainty = STR_UTF8(name=u'SpeedUncertainty', mode=MODE_TYPE)
    
    #-----< BarometricPressure >-----#
    BarometricPressure = INT(name=u'BarometricPressure', mode=MODE_TYPE)
    BarometricPressure._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=30000, ub=155000)], ev=None, er=[])
    
    #-----< VerticalDirection >-----#
    VerticalDirection = ENUM(name=u'VerticalDirection', mode=MODE_TYPE)
    VerticalDirection._cont = ASN1Dict([(u'upward', 1), (u'downward', 2)])
    VerticalDirection._ext = []
    
    #-----< PositioningMethod >-----#
    PositioningMethod = ENUM(name=u'PositioningMethod', mode=MODE_TYPE)
    PositioningMethod._cont = ASN1Dict([(u'cellID', 1), (u'eCID', 2), (u'oTDOA', 3), (u'barometricPressure', 4), (u'wLAN', 5), (u'bluetooth', 6), (u'mBS', 7), (u'motionSensor', 8), (u'dLTDOA', 9), (u'dLAOD', 10), (u'multiRTT', 11), (u'nRECID', 12), (u'uLTDOA', 13), (u'uLAOA', 14), (u'networkSpecific', 15)])
    PositioningMethod._ext = []
    
    #-----< PositioningMode >-----#
    PositioningMode = ENUM(name=u'PositioningMode', mode=MODE_TYPE)
    PositioningMode._cont = ASN1Dict([(u'uEBased', 1), (u'uEAssisted', 2), (u'conventional', 3)])
    PositioningMode._ext = []
    
    #-----< GNSSID >-----#
    GNSSID = ENUM(name=u'GNSSID', mode=MODE_TYPE)
    GNSSID._cont = ASN1Dict([(u'gPS', 1), (u'galileo', 2), (u'sBAS', 3), (u'modernizedGPS', 4), (u'qZSS', 5), (u'gLONASS', 6), (u'bDS', 7), (u'nAVIC', 8)])
    GNSSID._ext = []
    
    #-----< Usage >-----#
    Usage = ENUM(name=u'Usage', mode=MODE_TYPE)
    Usage._cont = ASN1Dict([(u'unsuccess', 1), (u'successResultsNotUsed', 2), (u'successResultsUsedToVerifyLocation', 3), (u'successResultsUsedToGenerateLocation', 4), (u'successMethodNotDetermined', 5)])
    Usage._ext = []
    
    #-----< TimeZone >-----#
    TimeZone = STR_UTF8(name=u'TimeZone', mode=MODE_TYPE)
    
    #-----< OGCURN >-----#
    OGCURN = STR_UTF8(name=u'OGCURN', mode=MODE_TYPE)
    
    #-----< MethodCode >-----#
    MethodCode = INT(name=u'MethodCode', mode=MODE_TYPE)
    MethodCode._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=16, ub=31)], ev=None, er=[])
    
    _all_ = [
        tS33128PayloadsOID,
        xIRIPayloadOID,
        xCCPayloadOID,
        iRIPayloadOID,
        cCPayloadOID,
        lINotificationPayloadOID,
        _XIRIPayload_xIRIPayloadOID,
        _XIRIPayload_event,
        XIRIPayload,
        _XIRIEvent_registration,
        _XIRIEvent_deregistration,
        _XIRIEvent_locationUpdate,
        _XIRIEvent_startOfInterceptionWithRegisteredUE,
        _XIRIEvent_unsuccessfulAMProcedure,
        _XIRIEvent_pDUSessionEstablishment,
        _XIRIEvent_pDUSessionModification,
        _XIRIEvent_pDUSessionRelease,
        _XIRIEvent_startOfInterceptionWithEstablishedPDUSession,
        _XIRIEvent_unsuccessfulSMProcedure,
        _XIRIEvent_servingSystemMessage,
        _XIRIEvent_sMSMessage,
        _XIRIEvent_lALSReport,
        _XIRIEvent_pDHeaderReport,
        _XIRIEvent_pDSummaryReport,
        _XIRIEvent_mMSSend,
        _XIRIEvent_mMSSendByNonLocalTarget,
        _XIRIEvent_mMSNotification,
        _XIRIEvent_mMSSendToNonLocalTarget,
        _XIRIEvent_mMSNotificationResponse,
        _XIRIEvent_mMSRetrieval,
        _XIRIEvent_mMSDeliveryAck,
        _XIRIEvent_mMSForward,
        _XIRIEvent_mMSDeleteFromRelay,
        _XIRIEvent_mMSDeliveryReport,
        _XIRIEvent_mMSDeliveryReportNonLocalTarget,
        _XIRIEvent_mMSReadReport,
        _XIRIEvent_mMSReadReportNonLocalTarget,
        _XIRIEvent_mMSCancel,
        _XIRIEvent_mMSMBoxStore,
        _XIRIEvent_mMSMBoxUpload,
        _XIRIEvent_mMSMBoxDelete,
        _XIRIEvent_mMSMBoxViewRequest,
        _XIRIEvent_mMSMBoxViewResponse,
        _XIRIEvent_pTCRegistration,
        _XIRIEvent_pTCSessionInitiation,
        _XIRIEvent_pTCSessionAbandon,
        _XIRIEvent_pTCSessionStart,
        _XIRIEvent_pTCSessionEnd,
        _XIRIEvent_pTCStartOfInterception,
        _XIRIEvent_pTCPreEstablishedSession,
        _XIRIEvent_pTCInstantPersonalAlert,
        _XIRIEvent_pTCPartyJoin,
        _XIRIEvent_pTCPartyDrop,
        _XIRIEvent_pTCPartyHold,
        _XIRIEvent_pTCMediaModification,
        _XIRIEvent_pTCGroupAdvertisement,
        _XIRIEvent_pTCFloorControl,
        _XIRIEvent_pTCTargetPresence,
        _XIRIEvent_pTCParticipantPresence,
        _XIRIEvent_pTCListManagement,
        _XIRIEvent_pTCAccessPolicy,
        _XIRIEvent_subscriberRecordChangeMessage,
        _XIRIEvent_cancelLocationMessage,
        _XIRIEvent_sMSReport,
        _XIRIEvent_sMFMAPDUSessionEstablishment,
        _XIRIEvent_sMFMAPDUSessionModification,
        _XIRIEvent_sMFMAPDUSessionRelease,
        _XIRIEvent_startOfInterceptionWithEstablishedMAPDUSession,
        _XIRIEvent_unsuccessfulMASMProcedure,
        _XIRIEvent_aMFIdentifierAssocation,
        _XIRIEvent_mMEIdentifierAssocation,
        _XIRIEvent_sMFPDUtoMAPDUSessionModification,
        XIRIEvent,
        _IRIPayload_iRIPayloadOID,
        _IRIPayload_event,
        __IRIPayload_targetIdentifiers__item_,
        _IRIPayload_targetIdentifiers,
        IRIPayload,
        _IRIEvent_registration,
        _IRIEvent_deregistration,
        _IRIEvent_locationUpdate,
        _IRIEvent_startOfInterceptionWithRegisteredUE,
        _IRIEvent_unsuccessfulRegistrationProcedure,
        _IRIEvent_pDUSessionEstablishment,
        _IRIEvent_pDUSessionModification,
        _IRIEvent_pDUSessionRelease,
        _IRIEvent_startOfInterceptionWithEstablishedPDUSession,
        _IRIEvent_unsuccessfulSessionProcedure,
        _IRIEvent_servingSystemMessage,
        _IRIEvent_sMSMessage,
        _IRIEvent_lALSReport,
        _IRIEvent_pDHeaderReport,
        _IRIEvent_pDSummaryReport,
        _IRIEvent_mDFCellSiteReport,
        _IRIEvent_mMSSend,
        _IRIEvent_mMSSendByNonLocalTarget,
        _IRIEvent_mMSNotification,
        _IRIEvent_mMSSendToNonLocalTarget,
        _IRIEvent_mMSNotificationResponse,
        _IRIEvent_mMSRetrieval,
        _IRIEvent_mMSDeliveryAck,
        _IRIEvent_mMSForward,
        _IRIEvent_mMSDeleteFromRelay,
        _IRIEvent_mMSDeliveryReport,
        _IRIEvent_mMSDeliveryReportNonLocalTarget,
        _IRIEvent_mMSReadReport,
        _IRIEvent_mMSReadReportNonLocalTarget,
        _IRIEvent_mMSCancel,
        _IRIEvent_mMSMBoxStore,
        _IRIEvent_mMSMBoxUpload,
        _IRIEvent_mMSMBoxDelete,
        _IRIEvent_mMSMBoxViewRequest,
        _IRIEvent_mMSMBoxViewResponse,
        _IRIEvent_pTCRegistration,
        _IRIEvent_pTCSessionInitiation,
        _IRIEvent_pTCSessionAbandon,
        _IRIEvent_pTCSessionStart,
        _IRIEvent_pTCSessionEnd,
        _IRIEvent_pTCStartOfInterception,
        _IRIEvent_pTCPreEstablishedSession,
        _IRIEvent_pTCInstantPersonalAlert,
        _IRIEvent_pTCPartyJoin,
        _IRIEvent_pTCPartyDrop,
        _IRIEvent_pTCPartyHold,
        _IRIEvent_pTCMediaModification,
        _IRIEvent_pTCGroupAdvertisement,
        _IRIEvent_pTCFloorControl,
        _IRIEvent_pTCTargetPresence,
        _IRIEvent_pTCParticipantPresence,
        _IRIEvent_pTCListManagement,
        _IRIEvent_pTCAccessPolicy,
        _IRIEvent_subscriberRecordChangeMessage,
        _IRIEvent_cancelLocationMessage,
        _IRIEvent_sMSReport,
        _IRIEvent_sMFMAPDUSessionEstablishment,
        _IRIEvent_sMFMAPDUSessionModification,
        _IRIEvent_sMFMAPDUSessionRelease,
        _IRIEvent_startOfInterceptionWithEstablishedMAPDUSession,
        _IRIEvent_unsuccessfulMASMProcedure,
        _IRIEvent_aMFIdentifierAssocation,
        _IRIEvent_mMEIdentifierAssocation,
        _IRIEvent_sMFPDUtoMAPDUSessionModification,
        IRIEvent,
        _IRITargetIdentifier_identifier,
        _IRITargetIdentifier_provenance,
        IRITargetIdentifier,
        _CCPayload_cCPayloadOID,
        _CCPayload_pDU,
        CCPayload,
        _CCPDU_uPFCCPDU,
        _CCPDU_extendedUPFCCPDU,
        _CCPDU_mMSCCPDU,
        CCPDU,
        _LINotificationPayload_lINotificationPayloadOID,
        _LINotificationPayload_notification,
        LINotificationPayload,
        _LINotificationMessage_lINotification,
        LINotificationMessage,
        _AMFRegistration_registrationType,
        _AMFRegistration_registrationResult,
        _AMFRegistration_slice,
        _AMFRegistration_sUPI,
        _AMFRegistration_sUCI,
        _AMFRegistration_pEI,
        _AMFRegistration_gPSI,
        _AMFRegistration_gUTI,
        _AMFRegistration_location,
        _AMFRegistration_non3GPPAccessEndpoint,
        _AMFRegistration_fiveGSTAIList,
        AMFRegistration,
        _AMFDeregistration_deregistrationDirection,
        _AMFDeregistration_accessType,
        _AMFDeregistration_sUPI,
        _AMFDeregistration_sUCI,
        _AMFDeregistration_pEI,
        _AMFDeregistration_gPSI,
        _AMFDeregistration_gUTI,
        _AMFDeregistration_cause,
        _AMFDeregistration_location,
        AMFDeregistration,
        _AMFLocationUpdate_sUPI,
        _AMFLocationUpdate_sUCI,
        _AMFLocationUpdate_pEI,
        _AMFLocationUpdate_gPSI,
        _AMFLocationUpdate_gUTI,
        _AMFLocationUpdate_location,
        AMFLocationUpdate,
        _AMFStartOfInterceptionWithRegisteredUE_registrationResult,
        _AMFStartOfInterceptionWithRegisteredUE_registrationType,
        _AMFStartOfInterceptionWithRegisteredUE_slice,
        _AMFStartOfInterceptionWithRegisteredUE_sUPI,
        _AMFStartOfInterceptionWithRegisteredUE_sUCI,
        _AMFStartOfInterceptionWithRegisteredUE_pEI,
        _AMFStartOfInterceptionWithRegisteredUE_gPSI,
        _AMFStartOfInterceptionWithRegisteredUE_gUTI,
        _AMFStartOfInterceptionWithRegisteredUE_location,
        _AMFStartOfInterceptionWithRegisteredUE_non3GPPAccessEndpoint,
        _AMFStartOfInterceptionWithRegisteredUE_timeOfRegistration,
        _AMFStartOfInterceptionWithRegisteredUE_fiveGSTAIList,
        AMFStartOfInterceptionWithRegisteredUE,
        _AMFUnsuccessfulProcedure_failedProcedureType,
        _AMFUnsuccessfulProcedure_failureCause,
        _AMFUnsuccessfulProcedure_requestedSlice,
        _AMFUnsuccessfulProcedure_sUPI,
        _AMFUnsuccessfulProcedure_sUCI,
        _AMFUnsuccessfulProcedure_pEI,
        _AMFUnsuccessfulProcedure_gPSI,
        _AMFUnsuccessfulProcedure_gUTI,
        _AMFUnsuccessfulProcedure_location,
        AMFUnsuccessfulProcedure,
        _AMFID_aMFRegionID,
        _AMFID_aMFSetID,
        _AMFID_aMFPointer,
        AMFID,
        AMFDirection,
        AMFFailedProcedureType,
        _AMFFailureCause_fiveGMMCause,
        _AMFFailureCause_fiveGSMCause,
        AMFFailureCause,
        AMFPointer,
        AMFRegistrationResult,
        AMFRegionID,
        AMFRegistrationType,
        AMFSetID,
        _SMFPDUSessionEstablishment_sUPI,
        _SMFPDUSessionEstablishment_sUPIUnauthenticated,
        _SMFPDUSessionEstablishment_pEI,
        _SMFPDUSessionEstablishment_gPSI,
        _SMFPDUSessionEstablishment_pDUSessionID,
        _SMFPDUSessionEstablishment_gTPTunnelID,
        _SMFPDUSessionEstablishment_pDUSessionType,
        _SMFPDUSessionEstablishment_sNSSAI,
        __SMFPDUSessionEstablishment_uEEndpoint__item_,
        _SMFPDUSessionEstablishment_uEEndpoint,
        _SMFPDUSessionEstablishment_non3GPPAccessEndpoint,
        _SMFPDUSessionEstablishment_location,
        _SMFPDUSessionEstablishment_dNN,
        _SMFPDUSessionEstablishment_aMFID,
        _SMFPDUSessionEstablishment_hSMFURI,
        _SMFPDUSessionEstablishment_requestType,
        _SMFPDUSessionEstablishment_accessType,
        _SMFPDUSessionEstablishment_rATType,
        _SMFPDUSessionEstablishment_sMPDUDNRequest,
        _SMFPDUSessionEstablishment_uEEPSPDNConnection,
        SMFPDUSessionEstablishment,
        _SMFPDUSessionModification_sUPI,
        _SMFPDUSessionModification_sUPIUnauthenticated,
        _SMFPDUSessionModification_pEI,
        _SMFPDUSessionModification_gPSI,
        _SMFPDUSessionModification_sNSSAI,
        _SMFPDUSessionModification_non3GPPAccessEndpoint,
        _SMFPDUSessionModification_location,
        _SMFPDUSessionModification_requestType,
        _SMFPDUSessionModification_accessType,
        _SMFPDUSessionModification_rATType,
        _SMFPDUSessionModification_pDUSessionID,
        SMFPDUSessionModification,
        _SMFPDUSessionRelease_sUPI,
        _SMFPDUSessionRelease_pEI,
        _SMFPDUSessionRelease_gPSI,
        _SMFPDUSessionRelease_pDUSessionID,
        _SMFPDUSessionRelease_timeOfFirstPacket,
        _SMFPDUSessionRelease_timeOfLastPacket,
        _SMFPDUSessionRelease_uplinkVolume,
        _SMFPDUSessionRelease_downlinkVolume,
        _SMFPDUSessionRelease_location,
        _SMFPDUSessionRelease_cause,
        SMFPDUSessionRelease,
        _SMFStartOfInterceptionWithEstablishedPDUSession_sUPI,
        _SMFStartOfInterceptionWithEstablishedPDUSession_sUPIUnauthenticated,
        _SMFStartOfInterceptionWithEstablishedPDUSession_pEI,
        _SMFStartOfInterceptionWithEstablishedPDUSession_gPSI,
        _SMFStartOfInterceptionWithEstablishedPDUSession_pDUSessionID,
        _SMFStartOfInterceptionWithEstablishedPDUSession_gTPTunnelID,
        _SMFStartOfInterceptionWithEstablishedPDUSession_pDUSessionType,
        _SMFStartOfInterceptionWithEstablishedPDUSession_sNSSAI,
        __SMFStartOfInterceptionWithEstablishedPDUSession_uEEndpoint__item_,
        _SMFStartOfInterceptionWithEstablishedPDUSession_uEEndpoint,
        _SMFStartOfInterceptionWithEstablishedPDUSession_non3GPPAccessEndpoint,
        _SMFStartOfInterceptionWithEstablishedPDUSession_location,
        _SMFStartOfInterceptionWithEstablishedPDUSession_dNN,
        _SMFStartOfInterceptionWithEstablishedPDUSession_aMFID,
        _SMFStartOfInterceptionWithEstablishedPDUSession_hSMFURI,
        _SMFStartOfInterceptionWithEstablishedPDUSession_requestType,
        _SMFStartOfInterceptionWithEstablishedPDUSession_accessType,
        _SMFStartOfInterceptionWithEstablishedPDUSession_rATType,
        _SMFStartOfInterceptionWithEstablishedPDUSession_sMPDUDNRequest,
        _SMFStartOfInterceptionWithEstablishedPDUSession_timeOfSessionEstablishment,
        SMFStartOfInterceptionWithEstablishedPDUSession,
        _SMFUnsuccessfulProcedure_failedProcedureType,
        _SMFUnsuccessfulProcedure_failureCause,
        _SMFUnsuccessfulProcedure_initiator,
        _SMFUnsuccessfulProcedure_requestedSlice,
        _SMFUnsuccessfulProcedure_sUPI,
        _SMFUnsuccessfulProcedure_sUPIUnauthenticated,
        _SMFUnsuccessfulProcedure_pEI,
        _SMFUnsuccessfulProcedure_gPSI,
        _SMFUnsuccessfulProcedure_pDUSessionID,
        __SMFUnsuccessfulProcedure_uEEndpoint__item_,
        _SMFUnsuccessfulProcedure_uEEndpoint,
        _SMFUnsuccessfulProcedure_non3GPPAccessEndpoint,
        _SMFUnsuccessfulProcedure_dNN,
        _SMFUnsuccessfulProcedure_aMFID,
        _SMFUnsuccessfulProcedure_hSMFURI,
        _SMFUnsuccessfulProcedure_requestType,
        _SMFUnsuccessfulProcedure_accessType,
        _SMFUnsuccessfulProcedure_rATType,
        _SMFUnsuccessfulProcedure_sMPDUDNRequest,
        _SMFUnsuccessfulProcedure_location,
        SMFUnsuccessfulProcedure,
        _SMFPDUtoMAPDUSessionModification_sUPI,
        _SMFPDUtoMAPDUSessionModification_sUPIUnauthenticated,
        _SMFPDUtoMAPDUSessionModification_pEI,
        _SMFPDUtoMAPDUSessionModification_gPSI,
        _SMFPDUtoMAPDUSessionModification_sNSSAI,
        _SMFPDUtoMAPDUSessionModification_non3GPPAccessEndpoint,
        _SMFPDUtoMAPDUSessionModification_location,
        _SMFPDUtoMAPDUSessionModification_requestType,
        _SMFPDUtoMAPDUSessionModification_accessType,
        _SMFPDUtoMAPDUSessionModification_rATType,
        _SMFPDUtoMAPDUSessionModification_pDUSessionID,
        _SMFPDUtoMAPDUSessionModification_requestIndication,
        _SMFPDUtoMAPDUSessionModification_aTSSSContainer,
        SMFPDUtoMAPDUSessionModification,
        _SMFMAPDUSessionEstablishment_sUPI,
        _SMFMAPDUSessionEstablishment_sUPIUnauthenticated,
        _SMFMAPDUSessionEstablishment_pEI,
        _SMFMAPDUSessionEstablishment_gPSI,
        _SMFMAPDUSessionEstablishment_pDUSessionID,
        _SMFMAPDUSessionEstablishment_pDUSessionType,
        __SMFMAPDUSessionEstablishment_accessInfo__item_,
        _SMFMAPDUSessionEstablishment_accessInfo,
        _SMFMAPDUSessionEstablishment_sNSSAI,
        __SMFMAPDUSessionEstablishment_uEEndpoint__item_,
        _SMFMAPDUSessionEstablishment_uEEndpoint,
        _SMFMAPDUSessionEstablishment_location,
        _SMFMAPDUSessionEstablishment_dNN,
        _SMFMAPDUSessionEstablishment_aMFID,
        _SMFMAPDUSessionEstablishment_hSMFURI,
        _SMFMAPDUSessionEstablishment_requestType,
        _SMFMAPDUSessionEstablishment_sMPDUDNRequest,
        _SMFMAPDUSessionEstablishment_servingNetwork,
        _SMFMAPDUSessionEstablishment_oldPDUSessionID,
        _SMFMAPDUSessionEstablishment_mAUpgradeIndication,
        _SMFMAPDUSessionEstablishment_ePSPDNCnxInfo,
        _SMFMAPDUSessionEstablishment_mAAcceptedIndication,
        _SMFMAPDUSessionEstablishment_aTSSSContainer,
        SMFMAPDUSessionEstablishment,
        _SMFMAPDUSessionModification_sUPI,
        _SMFMAPDUSessionModification_sUPIUnauthenticated,
        _SMFMAPDUSessionModification_pEI,
        _SMFMAPDUSessionModification_gPSI,
        _SMFMAPDUSessionModification_pDUSessionID,
        __SMFMAPDUSessionModification_accessInfo__item_,
        _SMFMAPDUSessionModification_accessInfo,
        _SMFMAPDUSessionModification_sNSSAI,
        _SMFMAPDUSessionModification_location,
        _SMFMAPDUSessionModification_requestType,
        _SMFMAPDUSessionModification_servingNetwork,
        _SMFMAPDUSessionModification_oldPDUSessionID,
        _SMFMAPDUSessionModification_mAUpgradeIndication,
        _SMFMAPDUSessionModification_ePSPDNCnxInfo,
        _SMFMAPDUSessionModification_mAAcceptedIndication,
        _SMFMAPDUSessionModification_aTSSSContainer,
        SMFMAPDUSessionModification,
        _SMFMAPDUSessionRelease_sUPI,
        _SMFMAPDUSessionRelease_pEI,
        _SMFMAPDUSessionRelease_gPSI,
        _SMFMAPDUSessionRelease_pDUSessionID,
        _SMFMAPDUSessionRelease_timeOfFirstPacket,
        _SMFMAPDUSessionRelease_timeOfLastPacket,
        _SMFMAPDUSessionRelease_uplinkVolume,
        _SMFMAPDUSessionRelease_downlinkVolume,
        _SMFMAPDUSessionRelease_location,
        _SMFMAPDUSessionRelease_cause,
        SMFMAPDUSessionRelease,
        _SMFStartOfInterceptionWithEstablishedMAPDUSession_sUPI,
        _SMFStartOfInterceptionWithEstablishedMAPDUSession_sUPIUnauthenticated,
        _SMFStartOfInterceptionWithEstablishedMAPDUSession_pEI,
        _SMFStartOfInterceptionWithEstablishedMAPDUSession_gPSI,
        _SMFStartOfInterceptionWithEstablishedMAPDUSession_pDUSessionID,
        _SMFStartOfInterceptionWithEstablishedMAPDUSession_pDUSessionType,
        __SMFStartOfInterceptionWithEstablishedMAPDUSession_accessInfo__item_,
        _SMFStartOfInterceptionWithEstablishedMAPDUSession_accessInfo,
        _SMFStartOfInterceptionWithEstablishedMAPDUSession_sNSSAI,
        __SMFStartOfInterceptionWithEstablishedMAPDUSession_uEEndpoint__item_,
        _SMFStartOfInterceptionWithEstablishedMAPDUSession_uEEndpoint,
        _SMFStartOfInterceptionWithEstablishedMAPDUSession_location,
        _SMFStartOfInterceptionWithEstablishedMAPDUSession_dNN,
        _SMFStartOfInterceptionWithEstablishedMAPDUSession_aMFID,
        _SMFStartOfInterceptionWithEstablishedMAPDUSession_hSMFURI,
        _SMFStartOfInterceptionWithEstablishedMAPDUSession_requestType,
        _SMFStartOfInterceptionWithEstablishedMAPDUSession_sMPDUDNRequest,
        _SMFStartOfInterceptionWithEstablishedMAPDUSession_servingNetwork,
        _SMFStartOfInterceptionWithEstablishedMAPDUSession_oldPDUSessionID,
        _SMFStartOfInterceptionWithEstablishedMAPDUSession_mAUpgradeIndication,
        _SMFStartOfInterceptionWithEstablishedMAPDUSession_ePSPDNCnxInfo,
        _SMFStartOfInterceptionWithEstablishedMAPDUSession_mAAcceptedIndication,
        _SMFStartOfInterceptionWithEstablishedMAPDUSession_aTSSSContainer,
        SMFStartOfInterceptionWithEstablishedMAPDUSession,
        _SMFMAUnsuccessfulProcedure_failedProcedureType,
        _SMFMAUnsuccessfulProcedure_failureCause,
        _SMFMAUnsuccessfulProcedure_requestedSlice,
        _SMFMAUnsuccessfulProcedure_initiator,
        _SMFMAUnsuccessfulProcedure_sUPI,
        _SMFMAUnsuccessfulProcedure_sUPIUnauthenticated,
        _SMFMAUnsuccessfulProcedure_pEI,
        _SMFMAUnsuccessfulProcedure_gPSI,
        _SMFMAUnsuccessfulProcedure_pDUSessionID,
        __SMFMAUnsuccessfulProcedure_accessInfo__item_,
        _SMFMAUnsuccessfulProcedure_accessInfo,
        __SMFMAUnsuccessfulProcedure_uEEndpoint__item_,
        _SMFMAUnsuccessfulProcedure_uEEndpoint,
        _SMFMAUnsuccessfulProcedure_location,
        _SMFMAUnsuccessfulProcedure_dNN,
        _SMFMAUnsuccessfulProcedure_aMFID,
        _SMFMAUnsuccessfulProcedure_hSMFURI,
        _SMFMAUnsuccessfulProcedure_requestType,
        _SMFMAUnsuccessfulProcedure_sMPDUDNRequest,
        SMFMAUnsuccessfulProcedure,
        SMFFailedProcedureType,
        _SMFServingNetwork_pLMNID,
        _SMFServingNetwork_nID,
        SMFServingNetwork,
        _AccessInfo_accessType,
        _AccessInfo_rATType,
        _AccessInfo_gTPTunnelID,
        _AccessInfo_non3GPPAccessEndpoint,
        _AccessInfo_establishmentStatus,
        _AccessInfo_aNTypeToReactivate,
        AccessInfo,
        ATSSSContainer,
        EstablishmentStatus,
        SMFMAUpgradeIndication,
        SMFEPSPDNCnxInfo,
        SMFMAAcceptedIndication,
        SMFErrorCodes,
        UEEPSPDNConnection,
        RequestIndication,
        UPFCCPDU,
        _ExtendedUPFCCPDU_payload,
        _ExtendedUPFCCPDU_qFI,
        ExtendedUPFCCPDU,
        _UPFCCPDUPayload_uPFIPCC,
        _UPFCCPDUPayload_uPFEthernetCC,
        _UPFCCPDUPayload_uPFUnstructuredCC,
        UPFCCPDUPayload,
        QFI,
        _UDMServingSystemMessage_sUPI,
        _UDMServingSystemMessage_pEI,
        _UDMServingSystemMessage_gPSI,
        _UDMServingSystemMessage_gUAMI,
        _UDMServingSystemMessage_gUMMEI,
        _UDMServingSystemMessage_pLMNID,
        _UDMServingSystemMessage_servingSystemMethod,
        _UDMServingSystemMessage_serviceID,
        UDMServingSystemMessage,
        _UDMSubscriberRecordChangeMessage_sUPI,
        _UDMSubscriberRecordChangeMessage_pEI,
        _UDMSubscriberRecordChangeMessage_gPSI,
        _UDMSubscriberRecordChangeMessage_oldPEI,
        _UDMSubscriberRecordChangeMessage_oldSUPI,
        _UDMSubscriberRecordChangeMessage_oldGPSI,
        _UDMSubscriberRecordChangeMessage_oldserviceID,
        _UDMSubscriberRecordChangeMessage_subscriberRecordChangeMethod,
        _UDMSubscriberRecordChangeMessage_serviceID,
        UDMSubscriberRecordChangeMessage,
        _UDMCancelLocationMessage_sUPI,
        _UDMCancelLocationMessage_pEI,
        _UDMCancelLocationMessage_gPSI,
        _UDMCancelLocationMessage_gUAMI,
        _UDMCancelLocationMessage_pLMNID,
        _UDMCancelLocationMessage_cancelLocationMethod,
        UDMCancelLocationMessage,
        UDMServingSystemMethod,
        UDMSubscriberRecordChangeMethod,
        UDMCancelLocationMethod,
        _ServiceID_nSSAI,
        __ServiceID_cAGID__item_,
        _ServiceID_cAGID,
        ServiceID,
        CAGID,
        _SMSMessage_originatingSMSParty,
        _SMSMessage_terminatingSMSParty,
        _SMSMessage_direction,
        _SMSMessage_linkTransferStatus,
        _SMSMessage_otherMessage,
        _SMSMessage_location,
        _SMSMessage_peerNFAddress,
        _SMSMessage_peerNFType,
        _SMSMessage_sMSTPDUData,
        _SMSMessage_messageType,
        _SMSMessage_rPMessageReference,
        SMSMessage,
        _SMSReport_location,
        _SMSReport_sMSTPDUData,
        _SMSReport_messageType,
        _SMSReport_rPMessageReference,
        SMSReport,
        SMSAddress,
        SMSMessageType,
        _SMSParty_sUPI,
        _SMSParty_pEI,
        _SMSParty_gPSI,
        _SMSParty_sMSAddress,
        SMSParty,
        SMSTransferStatus,
        SMSOtherMessageIndication,
        _SMSNFAddress_iPAddress,
        _SMSNFAddress_e164Number,
        SMSNFAddress,
        SMSNFType,
        SMSRPMessageReference,
        _SMSTPDUData_sMSTPDU,
        _SMSTPDUData_truncatedSMSTPDU,
        SMSTPDUData,
        SMSTPDU,
        TruncatedSMSTPDU,
        _MMSSend_transactionID,
        _MMSSend_version,
        _MMSSend_dateTime,
        _MMSSend_originatingMMSParty,
        __MMSSend_terminatingMMSParty__item_,
        _MMSSend_terminatingMMSParty,
        __MMSSend_cCRecipients__item_,
        _MMSSend_cCRecipients,
        __MMSSend_bCCRecipients__item_,
        _MMSSend_bCCRecipients,
        _MMSSend_direction,
        _MMSSend_subject,
        _MMSSend_messageClass,
        _MMSSend_expiry,
        _MMSSend_desiredDeliveryTime,
        _MMSSend_priority,
        _MMSSend_senderVisibility,
        _MMSSend_deliveryReport,
        _MMSSend_readReport,
        _MMSSend_store,
        _MMSSend_state,
        _MMSSend_flags,
        _MMSSend_replyCharging,
        _MMSSend_applicID,
        _MMSSend_replyApplicID,
        _MMSSend_auxApplicInfo,
        _MMSSend_contentClass,
        _MMSSend_dRMContent,
        _MMSSend_adaptationAllowed,
        _MMSSend_contentType,
        _MMSSend_responseStatus,
        _MMSSend_responseStatusText,
        _MMSSend_messageID,
        MMSSend,
        _MMSSendByNonLocalTarget_version,
        _MMSSendByNonLocalTarget_transactionID,
        _MMSSendByNonLocalTarget_messageID,
        __MMSSendByNonLocalTarget_terminatingMMSParty__item_,
        _MMSSendByNonLocalTarget_terminatingMMSParty,
        _MMSSendByNonLocalTarget_originatingMMSParty,
        _MMSSendByNonLocalTarget_direction,
        _MMSSendByNonLocalTarget_contentType,
        _MMSSendByNonLocalTarget_messageClass,
        _MMSSendByNonLocalTarget_dateTime,
        _MMSSendByNonLocalTarget_expiry,
        _MMSSendByNonLocalTarget_deliveryReport,
        _MMSSendByNonLocalTarget_priority,
        _MMSSendByNonLocalTarget_senderVisibility,
        _MMSSendByNonLocalTarget_readReport,
        _MMSSendByNonLocalTarget_subject,
        _MMSSendByNonLocalTarget_forwardCount,
        _MMSSendByNonLocalTarget_previouslySentBy,
        _MMSSendByNonLocalTarget_prevSentByDateTime,
        _MMSSendByNonLocalTarget_applicID,
        _MMSSendByNonLocalTarget_replyApplicID,
        _MMSSendByNonLocalTarget_auxApplicInfo,
        _MMSSendByNonLocalTarget_contentClass,
        _MMSSendByNonLocalTarget_dRMContent,
        _MMSSendByNonLocalTarget_adaptationAllowed,
        MMSSendByNonLocalTarget,
        _MMSNotification_transactionID,
        _MMSNotification_version,
        _MMSNotification_originatingMMSParty,
        _MMSNotification_direction,
        _MMSNotification_subject,
        _MMSNotification_deliveryReportRequested,
        _MMSNotification_stored,
        _MMSNotification_messageClass,
        _MMSNotification_priority,
        _MMSNotification_messageSize,
        _MMSNotification_expiry,
        _MMSNotification_replyCharging,
        MMSNotification,
        _MMSSendToNonLocalTarget_version,
        _MMSSendToNonLocalTarget_transactionID,
        _MMSSendToNonLocalTarget_messageID,
        __MMSSendToNonLocalTarget_terminatingMMSParty__item_,
        _MMSSendToNonLocalTarget_terminatingMMSParty,
        _MMSSendToNonLocalTarget_originatingMMSParty,
        _MMSSendToNonLocalTarget_direction,
        _MMSSendToNonLocalTarget_contentType,
        _MMSSendToNonLocalTarget_messageClass,
        _MMSSendToNonLocalTarget_dateTime,
        _MMSSendToNonLocalTarget_expiry,
        _MMSSendToNonLocalTarget_deliveryReport,
        _MMSSendToNonLocalTarget_priority,
        _MMSSendToNonLocalTarget_senderVisibility,
        _MMSSendToNonLocalTarget_readReport,
        _MMSSendToNonLocalTarget_subject,
        _MMSSendToNonLocalTarget_forwardCount,
        _MMSSendToNonLocalTarget_previouslySentBy,
        _MMSSendToNonLocalTarget_prevSentByDateTime,
        _MMSSendToNonLocalTarget_applicID,
        _MMSSendToNonLocalTarget_replyApplicID,
        _MMSSendToNonLocalTarget_auxApplicInfo,
        _MMSSendToNonLocalTarget_contentClass,
        _MMSSendToNonLocalTarget_dRMContent,
        _MMSSendToNonLocalTarget_adaptationAllowed,
        MMSSendToNonLocalTarget,
        _MMSNotificationResponse_transactionID,
        _MMSNotificationResponse_version,
        _MMSNotificationResponse_direction,
        _MMSNotificationResponse_status,
        _MMSNotificationResponse_reportAllowed,
        MMSNotificationResponse,
        _MMSRetrieval_transactionID,
        _MMSRetrieval_version,
        _MMSRetrieval_messageID,
        _MMSRetrieval_dateTime,
        _MMSRetrieval_originatingMMSParty,
        _MMSRetrieval_previouslySentBy,
        _MMSRetrieval_prevSentByDateTime,
        __MMSRetrieval_terminatingMMSParty__item_,
        _MMSRetrieval_terminatingMMSParty,
        __MMSRetrieval_cCRecipients__item_,
        _MMSRetrieval_cCRecipients,
        _MMSRetrieval_direction,
        _MMSRetrieval_subject,
        _MMSRetrieval_state,
        _MMSRetrieval_flags,
        _MMSRetrieval_messageClass,
        _MMSRetrieval_priority,
        _MMSRetrieval_deliveryReport,
        _MMSRetrieval_readReport,
        _MMSRetrieval_replyCharging,
        _MMSRetrieval_retrieveStatus,
        _MMSRetrieval_retrieveStatusText,
        _MMSRetrieval_applicID,
        _MMSRetrieval_replyApplicID,
        _MMSRetrieval_auxApplicInfo,
        _MMSRetrieval_contentClass,
        _MMSRetrieval_dRMContent,
        _MMSRetrieval_replaceID,
        _MMSRetrieval_contentType,
        MMSRetrieval,
        _MMSDeliveryAck_transactionID,
        _MMSDeliveryAck_version,
        _MMSDeliveryAck_reportAllowed,
        _MMSDeliveryAck_status,
        _MMSDeliveryAck_direction,
        MMSDeliveryAck,
        _MMSForward_transactionID,
        _MMSForward_version,
        _MMSForward_dateTime,
        _MMSForward_originatingMMSParty,
        __MMSForward_terminatingMMSParty__item_,
        _MMSForward_terminatingMMSParty,
        __MMSForward_cCRecipients__item_,
        _MMSForward_cCRecipients,
        __MMSForward_bCCRecipients__item_,
        _MMSForward_bCCRecipients,
        _MMSForward_direction,
        _MMSForward_expiry,
        _MMSForward_desiredDeliveryTime,
        _MMSForward_deliveryReportAllowed,
        _MMSForward_deliveryReport,
        _MMSForward_store,
        _MMSForward_state,
        _MMSForward_flags,
        _MMSForward_contentLocationReq,
        _MMSForward_replyCharging,
        _MMSForward_responseStatus,
        _MMSForward_responseStatusText,
        _MMSForward_messageID,
        _MMSForward_contentLocationConf,
        _MMSForward_storeStatus,
        _MMSForward_storeStatusText,
        MMSForward,
        _MMSDeleteFromRelay_transactionID,
        _MMSDeleteFromRelay_version,
        _MMSDeleteFromRelay_direction,
        __MMSDeleteFromRelay_contentLocationReq__item_,
        _MMSDeleteFromRelay_contentLocationReq,
        __MMSDeleteFromRelay_contentLocationConf__item_,
        _MMSDeleteFromRelay_contentLocationConf,
        _MMSDeleteFromRelay_deleteResponseStatus,
        __MMSDeleteFromRelay_deleteResponseText__item_,
        _MMSDeleteFromRelay_deleteResponseText,
        MMSDeleteFromRelay,
        _MMSMBoxStore_transactionID,
        _MMSMBoxStore_version,
        _MMSMBoxStore_direction,
        _MMSMBoxStore_contentLocationReq,
        _MMSMBoxStore_state,
        _MMSMBoxStore_flags,
        _MMSMBoxStore_contentLocationConf,
        _MMSMBoxStore_storeStatus,
        _MMSMBoxStore_storeStatusText,
        MMSMBoxStore,
        _MMSMBoxUpload_transactionID,
        _MMSMBoxUpload_version,
        _MMSMBoxUpload_direction,
        _MMSMBoxUpload_state,
        _MMSMBoxUpload_flags,
        _MMSMBoxUpload_contentType,
        _MMSMBoxUpload_contentLocation,
        _MMSMBoxUpload_storeStatus,
        _MMSMBoxUpload_storeStatusText,
        __MMSMBoxUpload_mMessages__item_,
        _MMSMBoxUpload_mMessages,
        MMSMBoxUpload,
        _MMSMBoxDelete_transactionID,
        _MMSMBoxDelete_version,
        _MMSMBoxDelete_direction,
        __MMSMBoxDelete_contentLocationReq__item_,
        _MMSMBoxDelete_contentLocationReq,
        __MMSMBoxDelete_contentLocationConf__item_,
        _MMSMBoxDelete_contentLocationConf,
        _MMSMBoxDelete_responseStatus,
        _MMSMBoxDelete_responseStatusText,
        MMSMBoxDelete,
        _MMSDeliveryReport_version,
        _MMSDeliveryReport_messageID,
        __MMSDeliveryReport_terminatingMMSParty__item_,
        _MMSDeliveryReport_terminatingMMSParty,
        _MMSDeliveryReport_mMSDateTime,
        _MMSDeliveryReport_responseStatus,
        _MMSDeliveryReport_responseStatusText,
        _MMSDeliveryReport_applicID,
        _MMSDeliveryReport_replyApplicID,
        _MMSDeliveryReport_auxApplicInfo,
        MMSDeliveryReport,
        _MMSDeliveryReportNonLocalTarget_version,
        _MMSDeliveryReportNonLocalTarget_transactionID,
        _MMSDeliveryReportNonLocalTarget_messageID,
        __MMSDeliveryReportNonLocalTarget_terminatingMMSParty__item_,
        _MMSDeliveryReportNonLocalTarget_terminatingMMSParty,
        _MMSDeliveryReportNonLocalTarget_originatingMMSParty,
        _MMSDeliveryReportNonLocalTarget_direction,
        _MMSDeliveryReportNonLocalTarget_mMSDateTime,
        _MMSDeliveryReportNonLocalTarget_forwardToOriginator,
        _MMSDeliveryReportNonLocalTarget_status,
        _MMSDeliveryReportNonLocalTarget_statusExtension,
        _MMSDeliveryReportNonLocalTarget_statusText,
        _MMSDeliveryReportNonLocalTarget_applicID,
        _MMSDeliveryReportNonLocalTarget_replyApplicID,
        _MMSDeliveryReportNonLocalTarget_auxApplicInfo,
        MMSDeliveryReportNonLocalTarget,
        _MMSReadReport_version,
        _MMSReadReport_messageID,
        __MMSReadReport_terminatingMMSParty__item_,
        _MMSReadReport_terminatingMMSParty,
        __MMSReadReport_originatingMMSParty__item_,
        _MMSReadReport_originatingMMSParty,
        _MMSReadReport_direction,
        _MMSReadReport_mMSDateTime,
        _MMSReadReport_readStatus,
        _MMSReadReport_applicID,
        _MMSReadReport_replyApplicID,
        _MMSReadReport_auxApplicInfo,
        MMSReadReport,
        _MMSReadReportNonLocalTarget_version,
        _MMSReadReportNonLocalTarget_transactionID,
        __MMSReadReportNonLocalTarget_terminatingMMSParty__item_,
        _MMSReadReportNonLocalTarget_terminatingMMSParty,
        __MMSReadReportNonLocalTarget_originatingMMSParty__item_,
        _MMSReadReportNonLocalTarget_originatingMMSParty,
        _MMSReadReportNonLocalTarget_direction,
        _MMSReadReportNonLocalTarget_messageID,
        _MMSReadReportNonLocalTarget_mMSDateTime,
        _MMSReadReportNonLocalTarget_readStatus,
        _MMSReadReportNonLocalTarget_readStatusText,
        _MMSReadReportNonLocalTarget_applicID,
        _MMSReadReportNonLocalTarget_replyApplicID,
        _MMSReadReportNonLocalTarget_auxApplicInfo,
        MMSReadReportNonLocalTarget,
        _MMSCancel_transactionID,
        _MMSCancel_version,
        _MMSCancel_cancelID,
        _MMSCancel_direction,
        MMSCancel,
        _MMSMBoxViewRequest_transactionID,
        _MMSMBoxViewRequest_version,
        _MMSMBoxViewRequest_contentLocation,
        __MMSMBoxViewRequest_state__item_,
        _MMSMBoxViewRequest_state,
        __MMSMBoxViewRequest_flags__item_,
        _MMSMBoxViewRequest_flags,
        _MMSMBoxViewRequest_start,
        _MMSMBoxViewRequest_limit,
        __MMSMBoxViewRequest_attributes__item_,
        _MMSMBoxViewRequest_attributes,
        _MMSMBoxViewRequest_totals,
        _MMSMBoxViewRequest_quotas,
        MMSMBoxViewRequest,
        _MMSMBoxViewResponse_transactionID,
        _MMSMBoxViewResponse_version,
        _MMSMBoxViewResponse_contentLocation,
        __MMSMBoxViewResponse_state__item_,
        _MMSMBoxViewResponse_state,
        __MMSMBoxViewResponse_flags__item_,
        _MMSMBoxViewResponse_flags,
        _MMSMBoxViewResponse_start,
        _MMSMBoxViewResponse_limit,
        __MMSMBoxViewResponse_attributes__item_,
        _MMSMBoxViewResponse_attributes,
        _MMSMBoxViewResponse_mMSTotals,
        _MMSMBoxViewResponse_mMSQuotas,
        __MMSMBoxViewResponse_mMessages__item_,
        _MMSMBoxViewResponse_mMessages,
        MMSMBoxViewResponse,
        _MMBoxDescription_contentLocation,
        _MMBoxDescription_messageID,
        _MMBoxDescription_state,
        __MMBoxDescription_flags__item_,
        _MMBoxDescription_flags,
        _MMBoxDescription_dateTime,
        _MMBoxDescription_originatingMMSParty,
        __MMBoxDescription_terminatingMMSParty__item_,
        _MMBoxDescription_terminatingMMSParty,
        __MMBoxDescription_cCRecipients__item_,
        _MMBoxDescription_cCRecipients,
        __MMBoxDescription_bCCRecipients__item_,
        _MMBoxDescription_bCCRecipients,
        _MMBoxDescription_messageClass,
        _MMBoxDescription_subject,
        _MMBoxDescription_priority,
        _MMBoxDescription_deliveryTime,
        _MMBoxDescription_readReport,
        _MMBoxDescription_messageSize,
        _MMBoxDescription_replyCharging,
        _MMBoxDescription_previouslySentBy,
        _MMBoxDescription_previouslySentByDateTime,
        _MMBoxDescription_contentType,
        MMBoxDescription,
        _MMSCCPDU_version,
        _MMSCCPDU_transactionID,
        _MMSCCPDU_mMSContent,
        MMSCCPDU,
        _MMSAdaptation_allowed,
        _MMSAdaptation_overriden,
        MMSAdaptation,
        MMSCancelStatus,
        MMSContentClass,
        MMSContentType,
        MMSDeleteResponseStatus,
        MMSDirection,
        _MMSElementDescriptor_reference,
        _MMSElementDescriptor_parameter,
        _MMSElementDescriptor_value,
        MMSElementDescriptor,
        _MMSExpiry_expiryPeriod,
        _MMSExpiry_periodFormat,
        MMSExpiry,
        _MMFlags_length,
        _MMFlags_flag,
        _MMFlags_flagString,
        MMFlags,
        MMSMessageClass,
        __MMSParty_mMSPartyIDs__item_,
        _MMSParty_mMSPartyIDs,
        _MMSParty_nonLocalID,
        MMSParty,
        _MMSPartyID_e164Number,
        _MMSPartyID_emailAddress,
        _MMSPartyID_iMSI,
        _MMSPartyID_iMPU,
        _MMSPartyID_iMPI,
        _MMSPartyID_sUPI,
        _MMSPartyID_gPSI,
        MMSPartyID,
        MMSPeriodFormat,
        _MMSPreviouslySent_previouslySentByParty,
        _MMSPreviouslySent_sequenceNumber,
        _MMSPreviouslySent_previousSendDateTime,
        MMSPreviouslySent,
        _MMSPreviouslySentBy__item_,
        MMSPreviouslySentBy,
        MMSPriority,
        _MMSQuota_quota,
        _MMSQuota_quotaUnit,
        MMSQuota,
        MMSQuotaUnit,
        MMSReadStatus,
        MMSReadStatusText,
        MMSReplyCharging,
        MMSResponseStatus,
        MMSRetrieveStatus,
        MMSStoreStatus,
        MMState,
        MMStateFlag,
        MMStatus,
        MMStatusExtension,
        MMStatusText,
        MMSSubject,
        _MMSVersion_majorVersion,
        _MMSVersion_minorVersion,
        MMSVersion,
        _PTCRegistration_pTCTargetInformation,
        _PTCRegistration_pTCServerURI,
        _PTCRegistration_pTCRegistrationRequest,
        _PTCRegistration_pTCRegistrationOutcome,
        PTCRegistration,
        _PTCSessionInitiation_pTCTargetInformation,
        _PTCSessionInitiation_pTCDirection,
        _PTCSessionInitiation_pTCServerURI,
        _PTCSessionInitiation_pTCSessionInfo,
        _PTCSessionInitiation_pTCOriginatingID,
        __PTCSessionInitiation_pTCParticipants__item_,
        _PTCSessionInitiation_pTCParticipants,
        _PTCSessionInitiation_pTCParticipantPresenceStatus,
        _PTCSessionInitiation_location,
        _PTCSessionInitiation_pTCBearerCapability,
        _PTCSessionInitiation_pTCHost,
        PTCSessionInitiation,
        _PTCSessionAbandon_pTCTargetInformation,
        _PTCSessionAbandon_pTCDirection,
        _PTCSessionAbandon_pTCSessionInfo,
        _PTCSessionAbandon_location,
        _PTCSessionAbandon_pTCAbandonCause,
        PTCSessionAbandon,
        _PTCSessionStart_pTCTargetInformation,
        _PTCSessionStart_pTCDirection,
        _PTCSessionStart_pTCServerURI,
        _PTCSessionStart_pTCSessionInfo,
        _PTCSessionStart_pTCOriginatingID,
        __PTCSessionStart_pTCParticipants__item_,
        _PTCSessionStart_pTCParticipants,
        _PTCSessionStart_pTCParticipantPresenceStatus,
        _PTCSessionStart_location,
        _PTCSessionStart_pTCHost,
        _PTCSessionStart_pTCBearerCapability,
        PTCSessionStart,
        _PTCSessionEnd_pTCTargetInformation,
        _PTCSessionEnd_pTCDirection,
        _PTCSessionEnd_pTCServerURI,
        _PTCSessionEnd_pTCSessionInfo,
        __PTCSessionEnd_pTCParticipants__item_,
        _PTCSessionEnd_pTCParticipants,
        _PTCSessionEnd_location,
        _PTCSessionEnd_pTCSessionEndCause,
        PTCSessionEnd,
        _PTCStartOfInterception_pTCTargetInformation,
        _PTCStartOfInterception_pTCDirection,
        _PTCStartOfInterception_preEstSessionID,
        _PTCStartOfInterception_pTCOriginatingID,
        _PTCStartOfInterception_pTCSessionInfo,
        _PTCStartOfInterception_pTCHost,
        __PTCStartOfInterception_pTCParticipants__item_,
        _PTCStartOfInterception_pTCParticipants,
        _PTCStartOfInterception_pTCMediaStreamAvail,
        _PTCStartOfInterception_pTCBearerCapability,
        PTCStartOfInterception,
        _PTCPreEstablishedSession_pTCTargetInformation,
        _PTCPreEstablishedSession_pTCServerURI,
        _PTCPreEstablishedSession_rTPSetting,
        _PTCPreEstablishedSession_pTCMediaCapability,
        _PTCPreEstablishedSession_pTCPreEstSessionID,
        _PTCPreEstablishedSession_pTCPreEstStatus,
        _PTCPreEstablishedSession_pTCMediaStreamAvail,
        _PTCPreEstablishedSession_location,
        _PTCPreEstablishedSession_pTCFailureCode,
        PTCPreEstablishedSession,
        _PTCInstantPersonalAlert_pTCTargetInformation,
        _PTCInstantPersonalAlert_pTCIPAPartyID,
        _PTCInstantPersonalAlert_pTCIPADirection,
        PTCInstantPersonalAlert,
        _PTCPartyJoin_pTCTargetInformation,
        _PTCPartyJoin_pTCDirection,
        _PTCPartyJoin_pTCSessionInfo,
        __PTCPartyJoin_pTCParticipants__item_,
        _PTCPartyJoin_pTCParticipants,
        _PTCPartyJoin_pTCParticipantPresenceStatus,
        _PTCPartyJoin_pTCMediaStreamAvail,
        _PTCPartyJoin_pTCBearerCapability,
        PTCPartyJoin,
        _PTCPartyDrop_pTCTargetInformation,
        _PTCPartyDrop_pTCDirection,
        _PTCPartyDrop_pTCSessionInfo,
        _PTCPartyDrop_pTCPartyDrop,
        _PTCPartyDrop_pTCParticipantPresenceStatus,
        PTCPartyDrop,
        _PTCPartyHold_pTCTargetInformation,
        _PTCPartyHold_pTCDirection,
        _PTCPartyHold_pTCSessionInfo,
        __PTCPartyHold_pTCParticipants__item_,
        _PTCPartyHold_pTCParticipants,
        __PTCPartyHold_pTCHoldID__item_,
        _PTCPartyHold_pTCHoldID,
        _PTCPartyHold_pTCHoldRetrieveInd,
        PTCPartyHold,
        _PTCMediaModification_pTCTargetInformation,
        _PTCMediaModification_pTCDirection,
        _PTCMediaModification_pTCSessionInfo,
        _PTCMediaModification_pTCMediaStreamAvail,
        _PTCMediaModification_pTCBearerCapability,
        PTCMediaModification,
        _PTCGroupAdvertisement_pTCTargetInformation,
        _PTCGroupAdvertisement_pTCDirection,
        __PTCGroupAdvertisement_pTCIDList__item_,
        _PTCGroupAdvertisement_pTCIDList,
        _PTCGroupAdvertisement_pTCGroupAuthRule,
        _PTCGroupAdvertisement_pTCGroupAdSender,
        _PTCGroupAdvertisement_pTCGroupNickname,
        PTCGroupAdvertisement,
        _PTCFloorControl_pTCTargetInformation,
        _PTCFloorControl_pTCDirection,
        _PTCFloorControl_pTCSessioninfo,
        __PTCFloorControl_pTCFloorActivity__item_,
        _PTCFloorControl_pTCFloorActivity,
        _PTCFloorControl_pTCFloorSpeakerID,
        _PTCFloorControl_pTCMaxTBTime,
        _PTCFloorControl_pTCQueuedFloorControl,
        _PTCFloorControl_pTCQueuedPosition,
        _PTCFloorControl_pTCTalkBurstPriority,
        _PTCFloorControl_pTCTalkBurstReason,
        PTCFloorControl,
        _PTCTargetPresence_pTCTargetInformation,
        _PTCTargetPresence_pTCTargetPresenceStatus,
        PTCTargetPresence,
        _PTCParticipantPresence_pTCTargetInformation,
        _PTCParticipantPresence_pTCParticipantPresenceStatus,
        PTCParticipantPresence,
        _PTCListManagement_pTCTargetInformation,
        _PTCListManagement_pTCDirection,
        _PTCListManagement_pTCListManagementType,
        _PTCListManagement_pTCListManagementAction,
        _PTCListManagement_pTCListManagementFailure,
        _PTCListManagement_pTCContactID,
        __PTCListManagement_pTCIDList__item_,
        _PTCListManagement_pTCIDList,
        _PTCListManagement_pTCHost,
        PTCListManagement,
        _PTCAccessPolicy_pTCTargetInformation,
        _PTCAccessPolicy_pTCDirection,
        _PTCAccessPolicy_pTCAccessPolicyType,
        _PTCAccessPolicy_pTCUserAccessPolicy,
        _PTCAccessPolicy_pTCGroupAuthRule,
        _PTCAccessPolicy_pTCContactID,
        _PTCAccessPolicy_pTCAccessPolicyFailure,
        PTCAccessPolicy,
        PTCRegistrationRequest,
        PTCRegistrationOutcome,
        PTCSessionEndCause,
        __PTCTargetInformation_identifiers__item_,
        _PTCTargetInformation_identifiers,
        PTCTargetInformation,
        _PTCIdentifiers_mCPTTID,
        _PTCIdentifiers_instanceIdentifierURN,
        _PTCIdentifiers_pTCChatGroupID,
        _PTCIdentifiers_iMPU,
        _PTCIdentifiers_iMPI,
        PTCIdentifiers,
        _PTCSessionInfo_pTCSessionURI,
        _PTCSessionInfo_pTCSessionType,
        PTCSessionInfo,
        PTCSessionType,
        _MultipleParticipantPresenceStatus__item_,
        MultipleParticipantPresenceStatus,
        _PTCParticipantPresenceStatus_presenceID,
        _PTCParticipantPresenceStatus_presenceType,
        _PTCParticipantPresenceStatus_presenceStatus,
        PTCParticipantPresenceStatus,
        PTCPresenceType,
        PTCPreEstStatus,
        _RTPSetting_iPAddress,
        _RTPSetting_portNumber,
        RTPSetting,
        _PTCIDList_pTCPartyID,
        _PTCIDList_pTCChatGroupID,
        PTCIDList,
        _PTCChatGroupID_groupIdentity,
        PTCChatGroupID,
        PTCFloorActivity,
        PTCTBPriorityLevel,
        PTCTBReasonCode,
        PTCListManagementType,
        PTCListManagementAction,
        PTCAccessPolicyType,
        PTCUserAccessPolicy,
        PTCGroupAuthRule,
        PTCFailureCode,
        PTCListManagementFailure,
        PTCAccessPolicyFailure,
        _LALSReport_sUPI,
        _LALSReport_pEI,
        _LALSReport_gPSI,
        _LALSReport_location,
        LALSReport,
        _PDHeaderReport_pDUSessionID,
        _PDHeaderReport_sourceIPAddress,
        _PDHeaderReport_sourcePort,
        _PDHeaderReport_destinationIPAddress,
        _PDHeaderReport_destinationPort,
        _PDHeaderReport_nextLayerProtocol,
        _PDHeaderReport_iPv6flowLabel,
        _PDHeaderReport_direction,
        _PDHeaderReport_packetSize,
        PDHeaderReport,
        _PDSummaryReport_pDUSessionID,
        _PDSummaryReport_sourceIPAddress,
        _PDSummaryReport_sourcePort,
        _PDSummaryReport_destinationIPAddress,
        _PDSummaryReport_destinationPort,
        _PDSummaryReport_nextLayerProtocol,
        _PDSummaryReport_iPv6flowLabel,
        _PDSummaryReport_direction,
        _PDSummaryReport_pDSRSummaryTrigger,
        _PDSummaryReport_firstPacketTimestamp,
        _PDSummaryReport_lastPacketTimestamp,
        _PDSummaryReport_packetCount,
        _PDSummaryReport_byteCount,
        PDSummaryReport,
        PDSRSummaryTrigger,
        _AMFIdentifierAssocation_sUPI,
        _AMFIdentifierAssocation_sUCI,
        _AMFIdentifierAssocation_pEI,
        _AMFIdentifierAssocation_gPSI,
        _AMFIdentifierAssocation_gUTI,
        _AMFIdentifierAssocation_location,
        _AMFIdentifierAssocation_fiveGSTAIList,
        AMFIdentifierAssocation,
        _MMEIdentifierAssocation_iMSI,
        _MMEIdentifierAssocation_iMEI,
        _MMEIdentifierAssocation_mSISDN,
        _MMEIdentifierAssocation_gUTI,
        _MMEIdentifierAssocation_location,
        _MMEIdentifierAssocation_tAIList,
        MMEIdentifierAssocation,
        _GUTI_mCC,
        _GUTI_mNC,
        _GUTI_mMEGroupID,
        _GUTI_mMECode,
        _GUTI_mTMSI,
        GUTI,
        MMEGroupID,
        MMECode,
        TMSI,
        _LINotification_notificationType,
        _LINotification_appliedTargetID,
        __LINotification_appliedDeliveryInformation__item_,
        _LINotification_appliedDeliveryInformation,
        _LINotification_appliedStartTime,
        _LINotification_appliedEndTime,
        LINotification,
        LINotificationType,
        _LIAppliedDeliveryInformation_hI2DeliveryIPAddress,
        _LIAppliedDeliveryInformation_hI2DeliveryPortNumber,
        _LIAppliedDeliveryInformation_hI3DeliveryIPAddress,
        _LIAppliedDeliveryInformation_hI3DeliveryPortNumber,
        LIAppliedDeliveryInformation,
        _MDFCellSiteReport__item_,
        MDFCellSiteReport,
        AccessType,
        Direction,
        DNN,
        E164Number,
        EmailAddress,
        _FiveGGUTI_mCC,
        _FiveGGUTI_mNC,
        _FiveGGUTI_aMFRegionID,
        _FiveGGUTI_aMFSetID,
        _FiveGGUTI_aMFPointer,
        _FiveGGUTI_fiveGTMSI,
        FiveGGUTI,
        FiveGMMCause,
        FiveGSMRequestType,
        FiveGSMCause,
        FiveGTMSI,
        _FTEID_tEID,
        _FTEID_iPv4Address,
        _FTEID_iPv6Address,
        FTEID,
        _GPSI_mSISDN,
        _GPSI_nAI,
        GPSI,
        _GUAMI_aMFID,
        _GUAMI_pLMNID,
        GUAMI,
        _GUMMEI_mMEID,
        _GUMMEI_mCC,
        _GUMMEI_mNC,
        GUMMEI,
        HomeNetworkPublicKeyID,
        HSMFURI,
        IMEI,
        IMEISV,
        IMPI,
        _IMPU_sIPURI,
        _IMPU_tELURI,
        IMPU,
        IMSI,
        Initiator,
        _IPAddress_iPv4Address,
        _IPAddress_iPv6Address,
        IPAddress,
        IPv4Address,
        IPv6Address,
        IPv6FlowLabel,
        MACAddress,
        MCC,
        MNC,
        _MMEID_mMEGI,
        _MMEID_mMEC,
        MMEID,
        MMEC,
        MMEGI,
        MSISDN,
        NAI,
        NextLayerProtocol,
        NonLocalID,
        _NSSAI__item_,
        NSSAI,
        _PLMNID_mCC,
        _PLMNID_mNC,
        PLMNID,
        PDUSessionID,
        PDUSessionType,
        _PEI_iMEI,
        _PEI_iMEISV,
        PEI,
        PortNumber,
        ProtectionSchemeID,
        RATType,
        _RejectedNSSAI__item_,
        RejectedNSSAI,
        _RejectedSNSSAI_causeValue,
        _RejectedSNSSAI_sNSSAI,
        RejectedSNSSAI,
        RejectedSliceCauseValue,
        RoutingIndicator,
        SchemeOutput,
        SIPURI,
        _Slice_allowedNSSAI,
        _Slice_configuredNSSAI,
        _Slice_rejectedNSSAI,
        Slice,
        SMPDUDNRequest,
        _SNSSAI_sliceServiceType,
        _SNSSAI_sliceDifferentiator,
        SNSSAI,
        _SUCI_mCC,
        _SUCI_mNC,
        _SUCI_routingIndicator,
        _SUCI_protectionSchemeID,
        _SUCI_homeNetworkPublicKeyID,
        _SUCI_schemeOutput,
        SUCI,
        _SUPI_iMSI,
        _SUPI_nAI,
        SUPI,
        SUPIUnauthenticatedIndication,
        _TargetIdentifier_sUPI,
        _TargetIdentifier_iMSI,
        _TargetIdentifier_pEI,
        _TargetIdentifier_iMEI,
        _TargetIdentifier_gPSI,
        _TargetIdentifier_mSISDN,
        _TargetIdentifier_nAI,
        _TargetIdentifier_iPv4Address,
        _TargetIdentifier_iPv6Address,
        _TargetIdentifier_ethernetAddress,
        TargetIdentifier,
        TargetIdentifierProvenance,
        TELURI,
        Timestamp,
        _UEEndpointAddress_iPv4Address,
        _UEEndpointAddress_iPv6Address,
        _UEEndpointAddress_ethernetAddress,
        UEEndpointAddress,
        _Location_locationInfo,
        _Location_positioningInfo,
        _Location_locationPresenceReport,
        Location,
        _CellSiteInformation_geographicalCoordinates,
        _CellSiteInformation_azimuth,
        _CellSiteInformation_operatorSpecificInformation,
        CellSiteInformation,
        _LocationInfo_userLocation,
        _LocationInfo_currentLoc,
        _LocationInfo_geoInfo,
        _LocationInfo_rATType,
        _LocationInfo_timeZone,
        __LocationInfo_additionalCellIDs__item_,
        _LocationInfo_additionalCellIDs,
        LocationInfo,
        _UserLocation_eUTRALocation,
        _UserLocation_nRLocation,
        _UserLocation_n3GALocation,
        UserLocation,
        _EUTRALocation_tAI,
        _EUTRALocation_eCGI,
        _EUTRALocation_ageOfLocatonInfo,
        _EUTRALocation_uELocationTimestamp,
        _EUTRALocation_geographicalInformation,
        _EUTRALocation_geodeticInformation,
        _EUTRALocation_globalNGENbID,
        _EUTRALocation_cellSiteInformation,
        _EUTRALocation_globalENbID,
        EUTRALocation,
        _NRLocation_tAI,
        _NRLocation_nCGI,
        _NRLocation_ageOfLocatonInfo,
        _NRLocation_uELocationTimestamp,
        _NRLocation_geographicalInformation,
        _NRLocation_geodeticInformation,
        _NRLocation_globalGNbID,
        _NRLocation_cellSiteInformation,
        NRLocation,
        _N3GALocation_tAI,
        _N3GALocation_n3IWFID,
        _N3GALocation_uEIPAddr,
        _N3GALocation_portNumber,
        N3GALocation,
        _IPAddr_iPv4Addr,
        _IPAddr_iPv6Addr,
        IPAddr,
        _GlobalRANNodeID_pLMNID,
        _GlobalRANNodeID_aNNodeID,
        _GlobalRANNodeID_nID,
        GlobalRANNodeID,
        _ANNodeID_n3IWFID,
        _ANNodeID_gNbID,
        _ANNodeID_nGENbID,
        _ANNodeID_eNbID,
        ANNodeID,
        GNbID,
        _TAI_pLMNID,
        _TAI_tAC,
        _TAI_nID,
        TAI,
        _ECGI_pLMNID,
        _ECGI_eUTRACellID,
        _ECGI_nID,
        ECGI,
        _TAIList__item_,
        TAIList,
        _NCGI_pLMNID,
        _NCGI_nRCellID,
        _NCGI_nID,
        NCGI,
        _RANCGI_eCGI,
        _RANCGI_nCGI,
        RANCGI,
        _CellInformation_rANCGI,
        _CellInformation_cellSiteinformation,
        _CellInformation_timeOfLocation,
        CellInformation,
        N3IWFIDNGAP,
        N3IWFIDSBI,
        TAC,
        EUTRACellID,
        NRCellID,
        _NGENbID_macroNGENbID,
        _NGENbID_shortMacroNGENbID,
        _NGENbID_longMacroNGENbID,
        NGENbID,
        NID,
        _ENbID_macroENbID,
        _ENbID_homeENbID,
        _ENbID_shortMacroENbID,
        _ENbID_longMacroENbID,
        ENbID,
        _PositioningInfo_positionInfo,
        _PositioningInfo_rawMLPResponse,
        PositioningInfo,
        _RawMLPResponse_mLPPositionData,
        _RawMLPResponse_mLPErrorCode,
        RawMLPResponse,
        _LocationData_locationEstimate,
        _LocationData_accuracyFulfilmentIndicator,
        _LocationData_ageOfLocationEstimate,
        _LocationData_velocityEstimate,
        _LocationData_civicAddress,
        __LocationData_positioningDataList__item_,
        _LocationData_positioningDataList,
        __LocationData_gNSSPositioningDataList__item_,
        _LocationData_gNSSPositioningDataList,
        _LocationData_eCGI,
        _LocationData_nCGI,
        _LocationData_altitude,
        _LocationData_barometricPressure,
        LocationData,
        _LocationPresenceReport_type,
        _LocationPresenceReport_timestamp,
        __LocationPresenceReport_areaList__item_,
        _LocationPresenceReport_areaList,
        _LocationPresenceReport_timeZone,
        __LocationPresenceReport_accessTypes__item_,
        _LocationPresenceReport_accessTypes,
        __LocationPresenceReport_rMInfoList__item_,
        _LocationPresenceReport_rMInfoList,
        __LocationPresenceReport_cMInfoList__item_,
        _LocationPresenceReport_cMInfoList,
        _LocationPresenceReport_reachability,
        _LocationPresenceReport_location,
        __LocationPresenceReport_additionalCellIDs__item_,
        _LocationPresenceReport_additionalCellIDs,
        LocationPresenceReport,
        AMFEventType,
        _AMFEventArea_presenceInfo,
        _AMFEventArea_lADNInfo,
        AMFEventArea,
        _PresenceInfo_presenceState,
        __PresenceInfo_trackingAreaList__item_,
        _PresenceInfo_trackingAreaList,
        __PresenceInfo_eCGIList__item_,
        _PresenceInfo_eCGIList,
        __PresenceInfo_nCGIList__item_,
        _PresenceInfo_nCGIList,
        __PresenceInfo_globalRANNodeIDList__item_,
        _PresenceInfo_globalRANNodeIDList,
        __PresenceInfo_globalENbIDList__item_,
        _PresenceInfo_globalENbIDList,
        PresenceInfo,
        _LADNInfo_lADN,
        _LADNInfo_presence,
        LADNInfo,
        PresenceState,
        _RMInfo_rMState,
        _RMInfo_accessType,
        RMInfo,
        _CMInfo_cMState,
        _CMInfo_accessType,
        CMInfo,
        UEReachability,
        RMState,
        CMState,
        _GeographicArea_point,
        _GeographicArea_pointUncertaintyCircle,
        _GeographicArea_pointUncertaintyEllipse,
        _GeographicArea_polygon,
        _GeographicArea_pointAltitude,
        _GeographicArea_pointAltitudeUncertainty,
        _GeographicArea_ellipsoidArc,
        GeographicArea,
        AccuracyFulfilmentIndicator,
        _VelocityEstimate_horVelocity,
        _VelocityEstimate_horWithVertVelocity,
        _VelocityEstimate_horVelocityWithUncertainty,
        _VelocityEstimate_horWithVertVelocityAndUncertainty,
        VelocityEstimate,
        _CivicAddress_country,
        _CivicAddress_a1,
        _CivicAddress_a2,
        _CivicAddress_a3,
        _CivicAddress_a4,
        _CivicAddress_a5,
        _CivicAddress_a6,
        _CivicAddress_prd,
        _CivicAddress_pod,
        _CivicAddress_sts,
        _CivicAddress_hno,
        _CivicAddress_hns,
        _CivicAddress_lmk,
        _CivicAddress_loc,
        _CivicAddress_nam,
        _CivicAddress_pc,
        _CivicAddress_bld,
        _CivicAddress_unit,
        _CivicAddress_flr,
        _CivicAddress_room,
        _CivicAddress_plc,
        _CivicAddress_pcn,
        _CivicAddress_pobox,
        _CivicAddress_addcode,
        _CivicAddress_seat,
        _CivicAddress_rd,
        _CivicAddress_rdsec,
        _CivicAddress_rdbr,
        _CivicAddress_rdsubbr,
        _CivicAddress_prm,
        _CivicAddress_pom,
        CivicAddress,
        _PositioningMethodAndUsage_method,
        _PositioningMethodAndUsage_mode,
        _PositioningMethodAndUsage_usage,
        _PositioningMethodAndUsage_methodCode,
        PositioningMethodAndUsage,
        _GNSSPositioningMethodAndUsage_mode,
        _GNSSPositioningMethodAndUsage_gNSS,
        _GNSSPositioningMethodAndUsage_usage,
        GNSSPositioningMethodAndUsage,
        _Point_geographicalCoordinates,
        Point,
        _PointUncertaintyCircle_geographicalCoordinates,
        _PointUncertaintyCircle_uncertainty,
        PointUncertaintyCircle,
        _PointUncertaintyEllipse_geographicalCoordinates,
        _PointUncertaintyEllipse_uncertainty,
        _PointUncertaintyEllipse_confidence,
        PointUncertaintyEllipse,
        __Polygon_pointList__item_,
        _Polygon_pointList,
        Polygon,
        _PointAltitude_point,
        _PointAltitude_altitude,
        PointAltitude,
        _PointAltitudeUncertainty_point,
        _PointAltitudeUncertainty_altitude,
        _PointAltitudeUncertainty_uncertaintyEllipse,
        _PointAltitudeUncertainty_uncertaintyAltitude,
        _PointAltitudeUncertainty_confidence,
        PointAltitudeUncertainty,
        _EllipsoidArc_point,
        _EllipsoidArc_innerRadius,
        _EllipsoidArc_uncertaintyRadius,
        _EllipsoidArc_offsetAngle,
        _EllipsoidArc_includedAngle,
        _EllipsoidArc_confidence,
        EllipsoidArc,
        _GeographicalCoordinates_latitude,
        _GeographicalCoordinates_longitude,
        _GeographicalCoordinates_mapDatumInformation,
        GeographicalCoordinates,
        _UncertaintyEllipse_semiMajor,
        _UncertaintyEllipse_semiMinor,
        _UncertaintyEllipse_orientationMajor,
        UncertaintyEllipse,
        _HorizontalVelocity_hSpeed,
        _HorizontalVelocity_bearing,
        HorizontalVelocity,
        _HorizontalWithVerticalVelocity_hSpeed,
        _HorizontalWithVerticalVelocity_bearing,
        _HorizontalWithVerticalVelocity_vSpeed,
        _HorizontalWithVerticalVelocity_vDirection,
        HorizontalWithVerticalVelocity,
        _HorizontalVelocityWithUncertainty_hSpeed,
        _HorizontalVelocityWithUncertainty_bearing,
        _HorizontalVelocityWithUncertainty_uncertainty,
        HorizontalVelocityWithUncertainty,
        _HorizontalWithVerticalVelocityAndUncertainty_hspeed,
        _HorizontalWithVerticalVelocityAndUncertainty_bearing,
        _HorizontalWithVerticalVelocityAndUncertainty_vSpeed,
        _HorizontalWithVerticalVelocityAndUncertainty_vDirection,
        _HorizontalWithVerticalVelocityAndUncertainty_hUncertainty,
        _HorizontalWithVerticalVelocityAndUncertainty_vUncertainty,
        HorizontalWithVerticalVelocityAndUncertainty,
        Altitude,
        Angle,
        Uncertainty,
        Orientation,
        Confidence,
        InnerRadius,
        AgeOfLocationEstimate,
        HorizontalSpeed,
        VerticalSpeed,
        SpeedUncertainty,
        BarometricPressure,
        VerticalDirection,
        PositioningMethod,
        PositioningMode,
        GNSSID,
        Usage,
        TimeZone,
        OGCURN,
        MethodCode,
    ]

init_modules(TS33128IdentityAssociation, TS33128Payloads)
