# -*- coding: UTF-8 -*-
#/**
# * Software Name : pycrate
# * Version : 0.4
# *
# * Copyright 2018. Benoit Michau. ANSSI. P1sec.
# *
# * This library is free software; you can redistribute it and/or
# * modify it under the terms of the GNU Lesser General Public
# * License as published by the Free Software Foundation; either
# * version 2.1 of the License, or (at your option) any later version.
# *
# * This library is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# * Lesser General Public License for more details.
# *
# * You should have received a copy of the GNU Lesser General Public
# * License along with this library; if not, write to the Free Software
# * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
# * MA 02110-1301  USA
# *
# *--------------------------------------------------------
# * File Name : pycrate_csn1dir/classmark_3_value_part.py
# * Created : 2018-11-21
# * Authors : Benoit Michau
# *--------------------------------------------------------
#*/
# specification: TS 24.008 - d90
# section: 10.5.1.7 Mobile Station Classmark 3
# top-level object: Classmark 3 Value part



# code automatically generated by pycrate_csn1
# change object type with type=CSN1T_BSTR (default type is CSN1T_UINT) in init
# add dict for value interpretation with dic={...} in CSN1Bit init
# add dict for key interpretation with kdic={...} in CSN1Alt init

from pycrate_csn1.csnobj import *

spare_bit = CSN1Bit(name='spare_bit')
Spare_bit = spare_bit
Spare_Bit = spare_bit

spare_bits = CSN1Bit(name='spare_bits', num=-1)
Spare_bits = spare_bits
Spare_Bits = spare_bits

ms_measurement_capability = CSN1List(name='ms_measurement_capability', list=[
  CSN1Bit(name='sms_value', bit=4),
  CSN1Bit(name='sm_value', bit=4)])

ecsd_multi_slot_capability = CSN1Bit(name='ecsd_multi_slot_capability', bit=5)

hscsd_multi_slot_capability = CSN1Bit(name='hscsd_multi_slot_capability', bit=5)

a5_bits = CSN1List(name='a5_bits', list=[
  CSN1Bit(name='a5_7'),
  CSN1Bit(name='a5_6'),
  CSN1Bit(name='a5_5'),
  CSN1Bit(name='a5_4')])

_8_psk_struct = CSN1List(name='_8_psk_struct', list=[
  CSN1Bit(name='modulation_capability'),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='_8_psk_rf_power_capability_1', bit=2)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='_8_psk_rf_power_capability_2', bit=2)])})])

r_support = CSN1Bit(name='r_support', bit=3)

single_band_support = CSN1Bit(name='single_band_support', bit=4)

ms_positioning_method_capability = CSN1Bit(name='ms_positioning_method_capability', bit=5)

classmark_3_value_part = CSN1List(name='classmark_3_value_part', trunc=True, list=[
  CSN1Ref(obj=spare_bit),
  CSN1Alt(alt={
    '000': ('multiband_supported', [
    CSN1Ref(obj=a5_bits)]),
    '001': ('multiband_supported', [
    CSN1Ref(obj=a5_bits),
    CSN1Ref(obj=spare_bit, num=4),
    CSN1Bit(name='associated_radio_capability_1', bit=4)]),
    '010': ('multiband_supported', [
    CSN1Ref(obj=a5_bits),
    CSN1Ref(obj=spare_bit, num=4),
    CSN1Bit(name='associated_radio_capability_1', bit=4)]),
    '100': ('multiband_supported', [
    CSN1Ref(obj=a5_bits),
    CSN1Ref(obj=spare_bit, num=4),
    CSN1Bit(name='associated_radio_capability_1', bit=4)]),
    '101': ('multiband_supported', [
    CSN1Ref(obj=a5_bits),
    CSN1Bit(name='associated_radio_capability_2', bit=4),
    CSN1Bit(name='associated_radio_capability_1', bit=4)]),
    '110': ('multiband_supported', [
    CSN1Ref(obj=a5_bits),
    CSN1Bit(name='associated_radio_capability_2', bit=4),
    CSN1Bit(name='associated_radio_capability_1', bit=4)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(obj=r_support)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(obj=hscsd_multi_slot_capability)])}),
  CSN1Bit(name='ucs2_treatment'),
  CSN1Bit(name='extended_measurement_capability'),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(obj=ms_measurement_capability)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(obj=ms_positioning_method_capability)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(obj=ecsd_multi_slot_capability)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(obj=_8_psk_struct)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Alt(name='gsm_400_bands_supported', alt={
      '01': ('', []),
      '10': ('', []),
      '11': ('', [])}),
    CSN1Bit(name='gsm_400_associated_radio_capability', bit=4)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='gsm_850_associated_radio_capability', bit=4)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='gsm_1900_associated_radio_capability', bit=4)])}),
  CSN1Bit(name='umts_fdd_radio_access_technology_capability'),
  CSN1Bit(name='umts_3_84_mcps_tdd_radio_access_technology_capability'),
  CSN1Bit(name='cdma_2000_radio_access_technology_capability'),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='dtm_gprs_multi_slot_class', bit=2),
    CSN1Bit(name='single_slot_dtm'),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='dtm_egprs_multi_slot_class', bit=2)])})])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(obj=single_band_support)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='gsm_750_associated_radio_capability', bit=4)])}),
  CSN1Bit(name='umts_1_28_mcps_tdd_radio_access_technology_capability'),
  CSN1Bit(name='geran_feature_package_1'),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='extended_dtm_gprs_multi_slot_class', bit=2),
    CSN1Bit(name='extended_dtm_egprs_multi_slot_class', bit=2)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='high_multislot_capability', bit=2)])}),
  CSN1Val(name='', val='0'),
  CSN1Bit(name='geran_feature_package_2'),
  CSN1Bit(name='gmsk_multislot_power_profile', bit=2),
  CSN1Bit(name='_8_psk_multislot_power_profile', bit=2),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Alt(name='t_gsm_400_bands_supported', alt={
      '01': ('', []),
      '10': ('', []),
      '11': ('', [])}),
    CSN1Bit(name='t_gsm_400_associated_radio_capability', bit=4)])}),
  CSN1Val(name='', val='0'),
  CSN1Bit(name='downlink_advanced_receiver_performance', bit=2),
  CSN1Bit(name='dtm_enhancements_capability'),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='dtm_gprs_high_multi_slot_class', bit=3),
    CSN1Bit(name='offset_required'),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='dtm_egprs_high_multi_slot_class', bit=3)])})])}),
  CSN1Bit(name='repeated_acch_capability'),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='gsm_710_associated_radio_capability', bit=4)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='t_gsm_810_associated_radio_capability', bit=4)])}),
  CSN1Bit(name='ciphering_mode_setting_capability'),
  CSN1Bit(name='additional_positioning_capabilities'),
  CSN1Bit(name='e_utra_fdd_support'),
  CSN1Bit(name='e_utra_tdd_support'),
  CSN1Bit(name='e_utra_measurement_and_reporting_support'),
  CSN1Bit(name='priority_based_reselection_support'),
  CSN1Bit(name='utra_csg_cells_reporting'),
  CSN1Bit(name='vamos_level', bit=2),
  CSN1Bit(name='tighter_capability', bit=2),
  CSN1Bit(name='selective_ciphering_of_downlink_sacch'),
  CSN1Bit(name='cs_to_ps_srvcc_from_geran_to_utra', bit=2),
  CSN1Bit(name='cs_to_ps_srvcc_from_geran_to_e_utra', bit=2),
  CSN1Bit(name='geran_network_sharing_support'),
  CSN1Bit(name='e_utra_wideband_rsrq_measurements_support'),
  CSN1Bit(name='er_band_support'),
  CSN1Bit(name='utra_multiple_frequency_band_indicators_support'),
  CSN1Bit(name='e_utra_multiple_frequency_band_indicators_support'),
  CSN1Bit(name='extended_tsc_set_capability_support'),
  CSN1Bit(name='extended_earfcn_value_range'),
  CSN1Ref(obj=spare_bits)])

