# -*- coding: UTF-8 -*-
#/**
# * Software Name : pycrate
# * Version : 0.4
# *
# * Copyright 2018. Benoit Michau. ANSSI. P1sec.
# *
# * This library is free software; you can redistribute it and/or
# * modify it under the terms of the GNU Lesser General Public
# * License as published by the Free Software Foundation; either
# * version 2.1 of the License, or (at your option) any later version.
# *
# * This library is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# * Lesser General Public License for more details.
# *
# * You should have received a copy of the GNU Lesser General Public
# * License along with this library; if not, write to the Free Software
# * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
# * MA 02110-1301  USA
# *
# *--------------------------------------------------------
# * File Name : pycrate_csn1dir/dynamic_allocation_2_ie.py
# * Created : 2018-11-21
# * Authors : Benoit Michau
# *--------------------------------------------------------
#*/
# specification: TS 44.060 - d60
# section: 12.48a.4 Dynamic Allocation 2
# top-level object: Dynamic Allocation 2 IE



# code automatically generated by pycrate_csn1
# change object type with type=CSN1T_BSTR (default type is CSN1T_UINT) in init
# add dict for value interpretation with dic={...} in CSN1Bit init
# add dict for key interpretation with kdic={...} in CSN1Alt init

from pycrate_csn1.csnobj import *

dynamic_allocation_2_ie = CSN1List(name='dynamic_allocation_2_ie', list=[
  CSN1Bit(name='extended_dynamic_allocation'),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='p0_c1', bit=4),
    CSN1Bit(name='pr_mode_c1'),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='p0_c2', bit=4),
      CSN1Bit(name='pr_mode_c2')])})])}),
  CSN1Bit(name='usf_granularity'),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='uplink_tfi_assignment', bit=5)])}),
  CSN1Alt(alt={
    '0': ('', [
    CSN1Bit(name='n_usf', bit=4),
    CSN1Alt(num=([1], lambda x: x + 1), alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='usf', bit=3)])})]),
    '1': ('', [
    CSN1Bit(name='alpha_c1', bit=4),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='alpha_c2', bit=4)])}),
    CSN1Alt(alt={
      '0': ('', [
      CSN1Bit(name='n_ts', bit=4),
      CSN1Alt(num=([1], lambda x: x + 1), alt={
        '0': ('', []),
        '1': ('', [
        CSN1Bit(name='usf', bit=3),
        CSN1Bit(name='gamma', bit=5)])})]),
      '1': ('', [
      CSN1Bit(name='n_pairs', bit=3),
      CSN1Alt(num=([1], lambda x: x + 1), alt={
        '0': ('', []),
        '1': ('', [
        CSN1Bit(name='usf', bit=3),
        CSN1Bit(name='gamma', bit=5)])}),
      CSN1Alt(alt={
        '0': ('', []),
        '1': ('', [
        CSN1Alt(num=([-1, 1], lambda x: x + 1), alt={
          '0': ('', []),
          '1': ('', [
          CSN1Bit(name='usf_2', bit=3),
          CSN1Alt(alt={
            '0': ('', []),
            '1': ('', [
            CSN1Bit(name='gamma', bit=5)])})])})])})])})])})])

