# -*- coding: UTF-8 -*-
#/**
# * Software Name : pycrate
# * Version : 0.4
# *
# * Copyright 2018. Benoit Michau. ANSSI. P1sec.
# *
# * This library is free software; you can redistribute it and/or
# * modify it under the terms of the GNU Lesser General Public
# * License as published by the Free Software Foundation; either
# * version 2.1 of the License, or (at your option) any later version.
# *
# * This library is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# * Lesser General Public License for more details.
# *
# * You should have received a copy of the GNU Lesser General Public
# * License along with this library; if not, write to the Free Software
# * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
# * MA 02110-1301  USA
# *
# *--------------------------------------------------------
# * File Name : pycrate_csn1dir/ec_packet_uplink_ack_nack_and_contention_resolution_message_content.py
# * Created : 2018-11-21
# * Authors : Benoit Michau
# *--------------------------------------------------------
#*/
# specification: TS 44.060 - d60
# section: 11.2.59 EC Packet Uplink Ack/Nack and Contention Resolution
# top-level object: EC Packet Uplink Ack/Nack and Contention Resolution message content

# external references
from pycrate_csn1dir.padding_bits import padding_bits
from pycrate_csn1dir.ec_primary_ack_nack_description_ie import ec_primary_ack_nack_description_ie
from pycrate_csn1dir.used_dl_coverage_class_ie import used_dl_coverage_class_ie

# code automatically generated by pycrate_csn1
# change object type with type=CSN1T_BSTR (default type is CSN1T_UINT) in init
# add dict for value interpretation with dic={...} in CSN1Bit init
# add dict for key interpretation with kdic={...} in CSN1Alt init

from pycrate_csn1.csnobj import *

puancr_fixed_uplink_allocation_struct = CSN1List(name='puancr_fixed_uplink_allocation_struct', list=[
  CSN1Bit(name='start_first_ul_rlc_data_block', bit=4),
  CSN1List(num=-1, list=[
    CSN1Val(name='', val='1'),
    CSN1Alt(alt={
      '0': ('', [
      CSN1Bit(name='delay_next_ul_rlc_data_block', bit=3)]),
      '1': ('', [])})]),
  CSN1Val(name='', val='0')])

ec_packet_uplink_ack_nack_and_contention_resolution_message_content = CSN1List(name='ec_packet_uplink_ack_nack_and_contention_resolution_message_content', list=[
  CSN1Ref(name='used_dl_coverage_class', obj=used_dl_coverage_class_ie),
  CSN1List(list=[
    CSN1Bit(name='uplink_tfi', bit=5),
    CSN1List(list=[
      CSN1Bit(name='contention_resolution_tlli', bit=32),
      CSN1Ref(name='ec_primary_ack_nack_description', obj=ec_primary_ack_nack_description_ie),
      CSN1Ref(name='puancr_fixed_uplink_allocation', obj=puancr_fixed_uplink_allocation_struct),
      CSN1Bit(name='resegment'),
      CSN1Ref(obj=padding_bits)])])])

