# -*- coding: UTF-8 -*-
#/**
# * Software Name : pycrate
# * Version : 0.4
# *
# * Copyright 2018. Benoit Michau. ANSSI. P1sec.
# *
# * This library is free software; you can redistribute it and/or
# * modify it under the terms of the GNU Lesser General Public
# * License as published by the Free Software Foundation; either
# * version 2.1 of the License, or (at your option) any later version.
# *
# * This library is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# * Lesser General Public License for more details.
# *
# * You should have received a copy of the GNU Lesser General Public
# * License along with this library; if not, write to the Free Software
# * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
# * MA 02110-1301  USA
# *
# *--------------------------------------------------------
# * File Name : pycrate_csn1dir/enhanced_measurement_report.py
# * Created : 2018-11-21
# * Authors : Benoit Michau
# *--------------------------------------------------------
#*/
# specification: TS 44.018 - d80
# section: 9.1.55 ENHANCED MEASUREMENT REPORT
# top-level object: Enhanced Measurement report

# external references
from pycrate_csn1dir.utran_csg_measurement_report_ie import utran_csg_measurement_report_ie

# code automatically generated by pycrate_csn1
# change object type with type=CSN1T_BSTR (default type is CSN1T_UINT) in init
# add dict for value interpretation with dic={...} in CSN1Bit init
# add dict for key interpretation with kdic={...} in CSN1Alt init

from pycrate_csn1.csnobj import *

spare_padding = CSN1Val(name='spare_padding', val='L', num=-1)
Spare_padding = spare_padding
Spare_Padding = spare_padding 

eutran_measurement_report_struct = CSN1List(name='eutran_measurement_report_struct', list=[
  CSN1Bit(name='n_eutran', bit=2),
  CSN1List(num=([0], lambda x: x + 1), list=[
    CSN1Bit(name='eutran_frequency_index', bit=3),
    CSN1Bit(name='cell_identity', bit=9),
    CSN1Bit(name='reporting_quantity', bit=6)])])

repeated_invalid_bsic_information_struct = CSN1List(name='repeated_invalid_bsic_information_struct', list=[
  CSN1Bit(name='bcch_freq_ncell', bit=5),
  CSN1Bit(name='bsic', bit=6),
  CSN1Bit(name='rxlev_ncell', bit=6)])

serving_cell_data_struct = CSN1List(name='serving_cell_data_struct', list=[
  CSN1Bit(name='dtx_used'),
  CSN1Bit(name='rxlev_val', bit=6),
  CSN1Bit(name='rx_qual_full', bit=3),
  CSN1Bit(name='mean_bep', bit=5),
  CSN1Bit(name='cv_bep', bit=3),
  CSN1Bit(name='nbr_rcvd_blocks', bit=5)])

enhanced_measurement_report = CSN1List(name='enhanced_measurement_report', list=[
  CSN1Bit(name='rr_short_pd'),
  CSN1Bit(name='message_type', bit=5),
  CSN1Bit(name='short_layer_2_header', bit=2),
  CSN1Bit(name='ba_used'),
  CSN1Bit(name='_3g_ba_used'),
  CSN1Bit(name='bsic_seen'),
  CSN1Bit(name='scale'),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='serving_cell_data', obj=serving_cell_data_struct)])}),
  CSN1List(num=-1, list=[
    CSN1Val(name='', val='1'),
    CSN1Ref(name='repeated_invalid_bsic_information', obj=repeated_invalid_bsic_information_struct)]),
  CSN1Val(name='', val='0'),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Alt(num=-1, alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='reporting_quantity', bit=6)])})])}),
  CSN1Alt(alt={
    'H': ('', [
    CSN1Bit(name='bitmap_length', bit=7),
    CSN1Alt(num=([1], lambda x: x + 1), alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='reporting_quantity', bit=6)])}),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Ref(name='eutran_measurement_report', obj=eutran_measurement_report_struct)])}),
    CSN1Alt(alt={
      'H': ('', [
      CSN1Alt(alt={
        '0': ('', []),
        '1': ('', [
        CSN1Ref(name='utran_csg_measurement_report', obj=utran_csg_measurement_report_ie)])}),
      CSN1Alt(alt={
        'H': ('', [
        CSN1Bit(name='si23_ba_used')]),
        'L': ('', [
        CSN1Bit(bit=-1)]),
        None: ('', [])})]),
      'L': ('', [
      CSN1Bit(bit=-1)]),
      None: ('', [])})]),
    'L': ('', [
    CSN1Bit(bit=-1)]),
    None: ('', [])}),
  CSN1Ref(obj=spare_padding)])

