# -*- coding: UTF-8 -*-
#/**
# * Software Name : pycrate
# * Version : 0.4
# *
# * Copyright 2018. Benoit Michau. ANSSI. P1sec.
# *
# * This library is free software; you can redistribute it and/or
# * modify it under the terms of the GNU Lesser General Public
# * License as published by the Free Software Foundation; either
# * version 2.1 of the License, or (at your option) any later version.
# *
# * This library is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# * Lesser General Public License for more details.
# *
# * You should have received a copy of the GNU Lesser General Public
# * License along with this library; if not, write to the Free Software
# * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
# * MA 02110-1301  USA
# *
# *--------------------------------------------------------
# * File Name : pycrate_csn1dir/measurement_results_contents.py
# * Created : 2018-11-21
# * Authors : Benoit Michau
# *--------------------------------------------------------
#*/
# specification: TS 44.018 - d80
# section: 10.5.2.20 Measurement Results
# top-level object: Measurement Results Contents

# external references
from pycrate_csn1dir.utran_csg_measurement_report_ie import utran_csg_measurement_report_ie

# code automatically generated by pycrate_csn1
# change object type with type=CSN1T_BSTR (default type is CSN1T_UINT) in init
# add dict for value interpretation with dic={...} in CSN1Bit init
# add dict for key interpretation with kdic={...} in CSN1Alt init

from pycrate_csn1.csnobj import *

ncell_report_struct = CSN1List(name='ncell_report_struct', list=[
  CSN1Bit(name='rxlev_ncell', bit=6),
  CSN1Bit(name='bcch_freq_ncell', bit=5),
  CSN1Bit(name='bsic_ncell', bit=6)])

measurement_results_contents = CSN1List(name='measurement_results_contents', lref=128, list=[
  CSN1Bit(name='ba_used'),
  CSN1Bit(name='dtx_used'),
  CSN1Bit(name='rxlev_full_serving_cell', bit=6),
  CSN1Bit(name='_3g_ba_used'),
  CSN1Bit(name='meas_valid'),
  CSN1Bit(name='rxlev_sub_serving_cell', bit=6),
  CSN1Bit(name='si23_ba_used'),
  CSN1Bit(name='rxqual_full_serving_cell', bit=3),
  CSN1Bit(name='rxqual_sub_serving_cell', bit=3),
  CSN1Alt(alt={
    '000': ('no_ncell_m', [
    CSN1Ref(name='ncell_report', obj=ncell_report_struct, num=([0], lambda x: x)),
    CSN1Alt(alt={
      '0': ('', [
      CSN1Val(name='', val='0**')]),
      '1': ('', [
      CSN1Ref(name='utran_csg_measurement_report', obj=utran_csg_measurement_report_ie),
      CSN1Alt(alt={
        '0': ('', [
        CSN1Val(name='', val='0**')]),
        None: ('', [])})]),
      None: ('', [])})]),
    '001': ('no_ncell_m', [
    CSN1Ref(name='ncell_report', obj=ncell_report_struct, num=([0], lambda x: x)),
    CSN1Alt(alt={
      '0': ('', [
      CSN1Val(name='', val='0**')]),
      '1': ('', [
      CSN1Ref(name='utran_csg_measurement_report', obj=utran_csg_measurement_report_ie),
      CSN1Alt(alt={
        '0': ('', [
        CSN1Val(name='', val='0**')]),
        None: ('', [])})]),
      None: ('', [])})]),
    '010': ('no_ncell_m', [
    CSN1Ref(name='ncell_report', obj=ncell_report_struct, num=([0], lambda x: x)),
    CSN1Alt(alt={
      '0': ('', [
      CSN1Val(name='', val='0**')]),
      '1': ('', [
      CSN1Ref(name='utran_csg_measurement_report', obj=utran_csg_measurement_report_ie),
      CSN1Alt(alt={
        '0': ('', [
        CSN1Val(name='', val='0**')]),
        None: ('', [])})]),
      None: ('', [])})]),
    '011': ('no_ncell_m', [
    CSN1Ref(name='ncell_report', obj=ncell_report_struct, num=([0], lambda x: x)),
    CSN1Alt(alt={
      '0': ('', [
      CSN1Val(name='', val='0**')]),
      '1': ('', [
      CSN1Ref(name='utran_csg_measurement_report', obj=utran_csg_measurement_report_ie),
      CSN1Alt(alt={
        '0': ('', [
        CSN1Val(name='', val='0**')]),
        None: ('', [])})]),
      None: ('', [])})]),
    '100': ('no_ncell_m', [
    CSN1Ref(name='ncell_report', obj=ncell_report_struct, num=([0], lambda x: x)),
    CSN1Alt(alt={
      '0': ('', [
      CSN1Val(name='', val='0**')]),
      '1': ('', [
      CSN1Ref(name='utran_csg_measurement_report', obj=utran_csg_measurement_report_ie),
      CSN1Alt(alt={
        '0': ('', [
        CSN1Val(name='', val='0**')]),
        None: ('', [])})]),
      None: ('', [])})]),
    '101': ('no_ncell_m', [
    CSN1Ref(name='ncell_report', obj=ncell_report_struct, num=([0], lambda x: x)),
    CSN1Alt(alt={
      '0': ('', [
      CSN1Val(name='', val='0**')]),
      '1': ('', [
      CSN1Ref(name='utran_csg_measurement_report', obj=utran_csg_measurement_report_ie),
      CSN1Alt(alt={
        '0': ('', [
        CSN1Val(name='', val='0**')]),
        None: ('', [])})]),
      None: ('', [])})]),
    '110': ('no_ncell_m', [
    CSN1Ref(name='ncell_report', obj=ncell_report_struct, num=([0], lambda x: x)),
    CSN1Alt(alt={
      '0': ('', [
      CSN1Val(name='', val='0**')]),
      '1': ('', [
      CSN1Ref(name='utran_csg_measurement_report', obj=utran_csg_measurement_report_ie),
      CSN1Alt(alt={
        '0': ('', [
        CSN1Val(name='', val='0**')]),
        None: ('', [])})]),
      None: ('', [])})]),
    '111': ('no_ncell_m', [
    CSN1Val(name='', val='0**')])})])

