# -*- coding: UTF-8 -*-
#/**
# * Software Name : pycrate
# * Version : 0.4
# *
# * Copyright 2018. Benoit Michau. ANSSI. P1sec.
# *
# * This library is free software; you can redistribute it and/or
# * modify it under the terms of the GNU Lesser General Public
# * License as published by the Free Software Foundation; either
# * version 2.1 of the License, or (at your option) any later version.
# *
# * This library is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# * Lesser General Public License for more details.
# *
# * You should have received a copy of the GNU Lesser General Public
# * License along with this library; if not, write to the Free Software
# * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
# * MA 02110-1301  USA
# *
# *--------------------------------------------------------
# * File Name : pycrate_csn1dir/p2_rest_octets.py
# * Created : 2018-11-21
# * Authors : Benoit Michau
# *--------------------------------------------------------
#*/
# specification: TS 44.018 - d80
# section: 10.5.2.24 P2 Rest Octets
# top-level object: P2 Rest Octets

# external references
from pycrate_csn1dir.mbms_sessions_list_ie import mbms_sessions_list_ie
from pycrate_csn1dir.mbms_channel_parameters_ie import mbms_channel_parameters_ie

# code automatically generated by pycrate_csn1
# change object type with type=CSN1T_BSTR (default type is CSN1T_UINT) in init
# add dict for value interpretation with dic={...} in CSN1Bit init
# add dict for key interpretation with kdic={...} in CSN1Alt init

from pycrate_csn1.csnobj import *

spare_padding = CSN1Val(name='spare_padding', val='L', num=-1)
Spare_padding = spare_padding
Spare_Padding = spare_padding 

priority = CSN1Bit(name='priority', bit=3)

mbms_information = CSN1List(name='mbms_information', list=[
  CSN1Ref(name='mbms_sessions_list', obj=mbms_sessions_list_ie),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='mbms_sessions_list', obj=mbms_sessions_list_ie)])}),
  CSN1List(num=-1, list=[
    CSN1Val(name='', val='1'),
    CSN1Ref(name='mbms_channel_parameters', obj=mbms_channel_parameters_ie),
    CSN1Ref(name='mbms_sessions_list', obj=mbms_sessions_list_ie)]),
  CSN1Val(name='', val='0')])

p2_rest_octets = CSN1List(name='p2_rest_octets', list=[
  CSN1Alt(alt={
    'H': ('', [
    CSN1Bit(name='cn3', bit=2)]),
    'L': ('', [])}),
  CSN1Alt(alt={
    'H': ('', [
    CSN1Bit(name='nln_pch', bit=2),
    CSN1Bit(name='nln_status_pch')]),
    'L': ('', [])}),
  CSN1Alt(alt={
    'H': ('', [
    CSN1Ref(name='priority1', obj=priority)]),
    'L': ('', [])}),
  CSN1Alt(alt={
    'H': ('', [
    CSN1Ref(name='priority2', obj=priority)]),
    'L': ('', [])}),
  CSN1Alt(alt={
    'H': ('', [
    CSN1Ref(name='priority3', obj=priority)]),
    'L': ('', [])}),
  CSN1Alt(name='packet_page_indication_3', alt={
    'H': ('', []),
    'L': ('', [])}),
  CSN1Alt(alt={
    'H': ('', [
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Alt(alt={
        '0': ('', []),
        '1': ('', [
        CSN1Ref(name='mbms_notification_3', obj=mbms_channel_parameters_ie)])}),
      CSN1Alt(alt={
        '0': ('', []),
        '1': ('', [
        CSN1Ref(obj=mbms_information)])})])})]),
    'L': ('', []),
    None: ('', [])}),
  CSN1Alt(alt={
    'H': ('', [
    CSN1Bit(name='implicit_reject_cs'),
    CSN1Bit(name='implicit_reject_ps')]),
    'L': ('', []),
    None: ('', [])}),
  CSN1Alt(alt={
    'H': ('', [
    CSN1Bit(name='ipa_support')]),
    'L': ('', []),
    None: ('', [])}),
  CSN1Alt(alt={
    'H': ('', [
    CSN1Bit(name='peo_bcch_change_mark', bit=2),
    CSN1Bit(name='rcc', bit=3)]),
    'L': ('', []),
    None: ('', [])}),
  CSN1Ref(obj=spare_padding)])

