/*
 * Copyright (c) 2014-2019, 2021, The Linux Foundation. All rights reserved.
 * Copyright (c) 2021-2022, Qualcomm Innovation Center, Inc. All rights reserved.
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*qca808x_start*/
#ifndef _API_DESC_H_
#define _API_DESC_H_

#ifdef __cplusplus
extern "C" {
#endif                          /* __cplusplus */

#define SW_API_PT_DUPLEX_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_DUPLEX_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_DUPLEX_GET, SW_UINT32, 4, SW_PARAM_IN, "Port No."), \
    SW_PARAM_DEF(SW_API_PT_DUPLEX_GET, SW_DUPLEX, sizeof(fal_port_duplex_t), SW_PARAM_PTR|SW_PARAM_OUT, \
              "duplex"),

#define SW_API_PT_DUPLEX_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_DUPLEX_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_PT_DUPLEX_SET, SW_UINT32, 4, SW_PARAM_IN, "Port No."), \
    SW_PARAM_DEF(SW_API_PT_DUPLEX_SET, SW_DUPLEX, sizeof(fal_port_duplex_t), SW_PARAM_IN, \
              "duplex"),

#define SW_API_PT_SPEED_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_SPEED_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_SPEED_GET, SW_UINT32, 4, SW_PARAM_IN, "Port No."), \
    SW_PARAM_DEF(SW_API_PT_SPEED_GET, SW_SPEED, sizeof(fal_port_speed_t), SW_PARAM_PTR|SW_PARAM_OUT, \
              "speed"),

#define SW_API_PT_SPEED_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_SPEED_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_SPEED_SET, SW_UINT32, 4, SW_PARAM_IN, "Port No."), \
    SW_PARAM_DEF(SW_API_PT_SPEED_SET, SW_SPEED, sizeof(fal_port_speed_t), SW_PARAM_IN, \
              "speed"),

#define SW_API_PT_AN_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_AN_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_AN_GET, SW_UINT32, 4, SW_PARAM_IN, "Port No."), \
    SW_PARAM_DEF(SW_API_PT_AN_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "autoneg"),


#define SW_API_PT_AN_ENABLE_DESC \
    SW_PARAM_DEF(SW_API_PT_AN_ENABLE, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_AN_ENABLE, SW_UINT32, 4, SW_PARAM_IN, "Port No."),


#define SW_API_PT_AN_RESTART_DESC \
    SW_PARAM_DEF(SW_API_PT_AN_RESTART, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_AN_RESTART, SW_UINT32, 4, SW_PARAM_IN, "Port No."),

#define SW_API_PT_AN_ADV_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_AN_ADV_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_AN_ADV_GET, SW_UINT32, 4, SW_PARAM_IN, "Port No."), \
    SW_PARAM_DEF(SW_API_PT_AN_ADV_GET, SW_CAP, 4, SW_PARAM_PTR|SW_PARAM_OUT, "autoneg"),

#define SW_API_PT_AN_ADV_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_AN_ADV_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_AN_ADV_SET, SW_UINT32, 4, SW_PARAM_IN, "Port No."), \
    SW_PARAM_DEF(SW_API_PT_AN_ADV_SET, SW_CAP, 4, SW_PARAM_IN, "autoneg"),
/*qca808x_end*/

#define SW_API_PT_HDR_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_HDR_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_HDR_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_HDR_SET, SW_ENABLE, 4, SW_PARAM_IN, "Header"),

#define SW_API_PT_HDR_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_HDR_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_HDR_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_HDR_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Header"),

#define SW_API_PT_FLOWCTRL_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_FLOWCTRL_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_FLOWCTRL_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_FLOWCTRL_SET, SW_ENABLE, 4, SW_PARAM_IN, "Flow control"),

#define SW_API_PT_FLOWCTRL_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_FLOWCTRL_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_FLOWCTRL_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_FLOWCTRL_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Flow control"),

#define SW_API_PT_FLOWCTRL_MODE_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_FLOWCTRL_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_FLOWCTRL_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_FLOWCTRL_MODE_SET, SW_ENABLE, 4, SW_PARAM_IN, "Force mode"),

#define SW_API_PT_FLOWCTRL_MODE_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_FLOWCTRL_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_FLOWCTRL_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_FLOWCTRL_MODE_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Force mode"),

#define SW_API_PT_POWERSAVE_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_POWERSAVE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_POWERSAVE_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_POWERSAVE_SET, SW_ENABLE, 4, SW_PARAM_IN, "Powersave Status"),

#define SW_API_PT_POWERSAVE_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_POWERSAVE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_POWERSAVE_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_POWERSAVE_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Powersave Status"),
/*qca808x_start*/
#define SW_API_PT_HIBERNATE_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_HIBERNATE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_HIBERNATE_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_HIBERNATE_SET, SW_ENABLE, 4, SW_PARAM_IN, "Hibernate status"),

#define SW_API_PT_HIBERNATE_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_HIBERNATE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_HIBERNATE_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_HIBERNATE_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Hibernate Status"),

#define SW_API_PT_CDT_DESC \
    SW_PARAM_DEF(SW_API_PT_CDT, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_CDT, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_CDT, SW_UINT32, 4, SW_PARAM_IN, "MDI Pair ID"), \
    SW_PARAM_DEF(SW_API_PT_CDT, SW_CABLESTATUS, 4, SW_PARAM_PTR|SW_PARAM_OUT, "cable status"), \
    SW_PARAM_DEF(SW_API_PT_CDT, SW_CABLELEN, 4, SW_PARAM_PTR|SW_PARAM_OUT, "cable len"),
/*qca808x_end*/
#define SW_API_PT_TXHDR_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_TXHDR_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_TXHDR_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_TXHDR_SET, SW_HDRMODE, sizeof(fal_port_header_mode_t), \
              SW_PARAM_IN, "HdrMode"),

#define SW_API_PT_TXHDR_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_TXHDR_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_TXHDR_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_TXHDR_GET, SW_HDRMODE, sizeof(fal_port_header_mode_t), \
              SW_PARAM_PTR|SW_PARAM_OUT, "HdrMode"),

#define SW_API_PT_RXHDR_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_RXHDR_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_RXHDR_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_RXHDR_SET, SW_HDRMODE, sizeof(fal_port_header_mode_t), \
              SW_PARAM_IN, "HdrMode"),

#define SW_API_PT_RXHDR_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_RXHDR_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_RXHDR_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_RXHDR_GET, SW_HDRMODE, sizeof(fal_port_header_mode_t), \
              SW_PARAM_PTR|SW_PARAM_OUT, "HdrMode"),

#define SW_API_HEADER_TYPE_SET_DESC \
    SW_PARAM_DEF(SW_API_HEADER_TYPE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_HEADER_TYPE_SET, SW_ENABLE, 4, SW_PARAM_IN, "Enable"), \
    SW_PARAM_DEF(SW_API_HEADER_TYPE_SET, SW_UINT32, 4, SW_PARAM_IN, "Value"),

#define SW_API_HEADER_TYPE_GET_DESC \
    SW_PARAM_DEF(SW_API_HEADER_TYPE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_HEADER_TYPE_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Enable"), \
    SW_PARAM_DEF(SW_API_HEADER_TYPE_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Value"),

#define SW_API_TXMAC_STATUS_SET_DESC \
    SW_PARAM_DEF(SW_API_TXMAC_STATUS_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_TXMAC_STATUS_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_TXMAC_STATUS_SET, SW_ENABLE, 4, SW_PARAM_IN, "Value"),

#define SW_API_TXMAC_STATUS_GET_DESC \
    SW_PARAM_DEF(SW_API_TXMAC_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_TXMAC_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_TXMAC_STATUS_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Value"),

#define SW_API_RXMAC_STATUS_SET_DESC \
    SW_PARAM_DEF(SW_API_RXMAC_STATUS_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_RXMAC_STATUS_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_RXMAC_STATUS_SET, SW_ENABLE, 4, SW_PARAM_IN, "Value"),

#define SW_API_RXMAC_STATUS_GET_DESC \
    SW_PARAM_DEF(SW_API_RXMAC_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_RXMAC_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_RXMAC_STATUS_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Value"),

#define SW_API_TXFC_STATUS_SET_DESC \
    SW_PARAM_DEF(SW_API_TXFC_STATUS_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_TXFC_STATUS_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_TXFC_STATUS_SET, SW_ENABLE, 4, SW_PARAM_IN, "Value"),

#define SW_API_TXFC_STATUS_GET_DESC \
    SW_PARAM_DEF(SW_API_TXFC_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_TXFC_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_TXFC_STATUS_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Value"),

#define SW_API_RXFC_STATUS_SET_DESC \
    SW_PARAM_DEF(SW_API_RXFC_STATUS_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_RXFC_STATUS_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_RXFC_STATUS_SET, SW_ENABLE, 4, SW_PARAM_IN, "Value"),

#define SW_API_RXFC_STATUS_GET_DESC \
    SW_PARAM_DEF(SW_API_RXFC_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_RXFC_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_RXFC_STATUS_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Value"),

#define SW_API_BP_STATUS_SET_DESC \
    SW_PARAM_DEF(SW_API_BP_STATUS_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_BP_STATUS_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_BP_STATUS_SET, SW_ENABLE, 4, SW_PARAM_IN, "Value"),

#define SW_API_BP_STATUS_GET_DESC \
    SW_PARAM_DEF(SW_API_BP_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_BP_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_BP_STATUS_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Value"),

#define SW_API_PT_LINK_MODE_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_LINK_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_LINK_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_LINK_MODE_SET, SW_ENABLE, 4, SW_PARAM_IN, "Value"),

#define SW_API_PT_LINK_MODE_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_LINK_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_LINK_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_LINK_MODE_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Value"),
/*qca808x_start*/
#define SW_API_PT_LINK_STATUS_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_LINK_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_LINK_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_LINK_STATUS_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Status"),
/*qca808x_end*/
#define SW_API_PT_MAC_LOOPBACK_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_MAC_LOOPBACK_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_MAC_LOOPBACK_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_MAC_LOOPBACK_SET, SW_ENABLE, 4, SW_PARAM_IN, "Enable"),

#define SW_API_PT_MAC_LOOPBACK_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_MAC_LOOPBACK_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_MAC_LOOPBACK_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_MAC_LOOPBACK_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Enable"),

#define SW_API_PT_CONGESTION_DROP_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_CONGESTION_DROP_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_CONGESTION_DROP_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_CONGESTION_DROP_SET, SW_UINT32, 4, SW_PARAM_IN, "Queue ID"), \
    SW_PARAM_DEF(SW_API_PT_CONGESTION_DROP_SET, SW_ENABLE, 4, SW_PARAM_IN, "Enable"),

#define SW_API_PT_CONGESTION_DROP_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_CONGESTION_DROP_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_CONGESTION_DROP_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_CONGESTION_DROP_GET, SW_UINT32, 4, SW_PARAM_IN, "Queue ID"), \
    SW_PARAM_DEF(SW_API_PT_CONGESTION_DROP_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Enable"),

#define SW_API_PT_RING_FLOW_CTRL_THRES_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_RING_FLOW_CTRL_THRES_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_RING_FLOW_CTRL_THRES_SET, SW_UINT32, 4, SW_PARAM_IN, "Ring ID"), \
    SW_PARAM_DEF(SW_API_PT_RING_FLOW_CTRL_THRES_SET, SW_UINT16, 2, SW_PARAM_IN, "On Thres"), \
    SW_PARAM_DEF(SW_API_PT_RING_FLOW_CTRL_THRES_SET, SW_UINT16, 2, SW_PARAM_IN, "Off Thres"),

#define SW_API_PT_RING_FLOW_CTRL_THRES_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_RING_FLOW_CTRL_THRES_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_RING_FLOW_CTRL_THRES_GET, SW_UINT32, 4, SW_PARAM_IN, "Ring ID"), \
    SW_PARAM_DEF(SW_API_PT_RING_FLOW_CTRL_THRES_GET, SW_UINT16, 2, SW_PARAM_PTR|SW_PARAM_OUT, \
		    "On Thres"), \
    SW_PARAM_DEF(SW_API_PT_RING_FLOW_CTRL_THRES_GET, SW_UINT16, 2, SW_PARAM_PTR|SW_PARAM_OUT, \
		    "Off Thres"),

#define SW_API_PT_FLOW_CTRL_THRES_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_FLOW_CTRL_THRES_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_FLOW_CTRL_THRES_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_FLOW_CTRL_THRES_SET, SW_UINT16, sizeof(a_uint16_t), \
		    SW_PARAM_IN, "On Thres"), \
    SW_PARAM_DEF(SW_API_PT_FLOW_CTRL_THRES_SET, SW_UINT16, sizeof(a_uint16_t), \
		    SW_PARAM_IN, "Off Thres"),

#define SW_API_PT_FLOW_CTRL_THRES_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_FLOW_CTRL_THRES_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_FLOW_CTRL_THRES_GET, SW_UINT32, 4, SW_PARAM_IN, "Ring ID"), \
    SW_PARAM_DEF(SW_API_PT_FLOW_CTRL_THRES_GET, SW_UINT16, sizeof(a_uint16_t), \
		    SW_PARAM_PTR|SW_PARAM_OUT, "On Thres"), \
    SW_PARAM_DEF(SW_API_PT_FLOW_CTRL_THRES_GET, SW_UINT16, sizeof(a_uint16_t), \
		    SW_PARAM_PTR|SW_PARAM_OUT, "Off Thres"),

#define SW_API_PT_RING_FLOW_CTRL_STATUS_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_RING_FLOW_CTRL_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_RING_FLOW_CTRL_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Ring ID"), \
    SW_PARAM_DEF(SW_API_PT_RING_FLOW_CTRL_STATUS_GET, SW_ENABLE, sizeof(a_bool_t), \
		    SW_PARAM_PTR|SW_PARAM_OUT, "BackPressure status"),

#define SW_API_PT_RING_UNION_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_RING_UNION_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_RING_UNION_SET, SW_ENABLE, sizeof(a_bool_t), \
		    SW_PARAM_IN, "port0 port5 ring union"),

#define SW_API_PT_RING_UNION_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_RING_UNION_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_RING_UNION_GET, SW_ENABLE, sizeof(a_bool_t), \
		    SW_PARAM_PTR|SW_PARAM_OUT, "port0 port5 ring union"),

#define SW_API_PT_RING_FLOW_CTRL_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_RING_FLOW_CTRL_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_RING_FLOW_CTRL_SET, SW_UINT32, 4, SW_PARAM_IN, "Ring ID"), \
    SW_PARAM_DEF(SW_API_PT_RING_FLOW_CTRL_SET, SW_ENABLE, sizeof(a_bool_t), \
		    SW_PARAM_IN, "port0 port5 ring fc en"),

#define SW_API_PT_RING_FLOW_CTRL_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_RING_FLOW_CTRL_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_RING_FLOW_CTRL_GET, SW_UINT32, 4, SW_PARAM_IN, "Ring ID"), \
    SW_PARAM_DEF(SW_API_PT_RING_FLOW_CTRL_GET, SW_ENABLE, sizeof(a_bool_t), \
		    SW_PARAM_PTR|SW_PARAM_OUT, "port0 port5 ring fc en"),

#define SW_API_PTS_LINK_STATUS_GET_DESC \
    SW_PARAM_DEF(SW_API_PTS_LINK_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PTS_LINK_STATUS_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Status"),
/*qca808x_start*/
#define SW_API_PT_8023AZ_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_8023AZ_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_8023AZ_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_8023AZ_SET, SW_ENABLE, 4, SW_PARAM_IN, "8023az Status"),

#define SW_API_PT_8023AZ_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_8023AZ_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_8023AZ_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_8023AZ_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "8023az Status"),

#define SW_API_PT_MDIX_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_MDIX_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_MDIX_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_MDIX_SET, SW_CROSSOVER_MODE, sizeof(fal_port_mdix_mode_t), SW_PARAM_IN, "Crossover Mode"),


#define SW_API_PT_MDIX_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_MDIX_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_MDIX_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_MDIX_GET, SW_CROSSOVER_MODE, sizeof(fal_port_mdix_mode_t), SW_PARAM_PTR|SW_PARAM_OUT, \
              "Crossover Mode"),

#define SW_API_PT_MDIX_STATUS_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_MDIX_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_MDIX_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_MDIX_STATUS_GET, SW_CROSSOVER_STATUS, sizeof(fal_port_mdix_status_t), SW_PARAM_PTR|SW_PARAM_OUT, \
              "Crossover Status"),
/*qca808x_end*/

#define SW_API_PT_COMBO_PREFER_MEDIUM_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_COMBO_PREFER_MEDIUM_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_COMBO_PREFER_MEDIUM_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_COMBO_PREFER_MEDIUM_SET, SW_PREFER_MEDIUM, sizeof(fal_port_medium_t), SW_PARAM_IN, "Prefer Medium"),


#define SW_API_PT_COMBO_PREFER_MEDIUM_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_COMBO_PREFER_MEDIUM_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_COMBO_PREFER_MEDIUM_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_COMBO_PREFER_MEDIUM_GET, SW_PREFER_MEDIUM, sizeof(fal_port_medium_t), SW_PARAM_PTR|SW_PARAM_OUT, \
              "Prefer Medium"),

#define SW_API_PT_COMBO_MEDIUM_STATUS_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_COMBO_MEDIUM_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_COMBO_MEDIUM_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_COMBO_MEDIUM_STATUS_GET, SW_PREFER_MEDIUM, sizeof(fal_port_medium_t), SW_PARAM_PTR|SW_PARAM_OUT, \
              "Medium Type"),

#define SW_API_PT_COMBO_FIBER_MODE_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_COMBO_FIBER_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_COMBO_FIBER_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_COMBO_FIBER_MODE_SET, SW_FIBER_MODE, sizeof(fal_port_fiber_mode_t), SW_PARAM_IN, "Fbier Mode"),


#define SW_API_PT_COMBO_FIBER_MODE_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_COMBO_FIBER_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_COMBO_FIBER_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_COMBO_FIBER_MODE_GET, SW_FIBER_MODE, sizeof(fal_port_fiber_mode_t), SW_PARAM_PTR|SW_PARAM_OUT, \
              "Fiber Mode"),
/*qca808x_start*/
#define SW_API_PT_LOCAL_LOOPBACK_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_LOCAL_LOOPBACK_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_LOCAL_LOOPBACK_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_LOCAL_LOOPBACK_SET, SW_ENABLE, 4, SW_PARAM_IN, "Local Loopback Status"),

#define SW_API_PT_LOCAL_LOOPBACK_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_LOCAL_LOOPBACK_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_LOCAL_LOOPBACK_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_LOCAL_LOOPBACK_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Local Loopback Status"),

#define SW_API_PT_REMOTE_LOOPBACK_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_REMOTE_LOOPBACK_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_REMOTE_LOOPBACK_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_REMOTE_LOOPBACK_SET, SW_ENABLE, 4, SW_PARAM_IN, "Remote Loopback Status"),

#define SW_API_PT_REMOTE_LOOPBACK_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_REMOTE_LOOPBACK_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_REMOTE_LOOPBACK_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_REMOTE_LOOPBACK_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Remote Loopback Status"),

#define SW_API_PT_RESET_DESC \
    SW_PARAM_DEF(SW_API_PT_RESET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_RESET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),

#define SW_API_PT_POWER_OFF_DESC \
    SW_PARAM_DEF(SW_API_PT_POWER_OFF, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_POWER_OFF, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),

#define SW_API_PT_POWER_ON_DESC \
    SW_PARAM_DEF(SW_API_PT_POWER_ON, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_POWER_ON, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),

#define SW_API_PT_MAGIC_FRAME_MAC_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_MAGIC_FRAME_MAC_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_MAGIC_FRAME_MAC_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_MAGIC_FRAME_MAC_SET, SW_MACADDR, sizeof(fal_mac_addr_t), SW_PARAM_PTR|SW_PARAM_IN, "[Magic mac]"),

#define SW_API_PT_MAGIC_FRAME_MAC_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_MAGIC_FRAME_MAC_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_MAGIC_FRAME_MAC_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_MAGIC_FRAME_MAC_GET, SW_MACADDR, sizeof(fal_mac_addr_t), SW_PARAM_PTR|SW_PARAM_OUT, "[Magic mac]"),

#define SW_API_PT_PHY_ID_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_PHY_ID_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_PHY_ID_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_PHY_ID_GET, SW_UINT16, 2, SW_PARAM_PTR|SW_PARAM_OUT, "Org ID"), \
    SW_PARAM_DEF(SW_API_PT_PHY_ID_GET, SW_UINT16, 2, SW_PARAM_PTR|SW_PARAM_OUT, "Rev ID"),

#define SW_API_PT_WOL_STATUS_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_WOL_STATUS_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_WOL_STATUS_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_WOL_STATUS_SET, SW_ENABLE, 4, SW_PARAM_IN, "Wol Status"),

#define SW_API_PT_WOL_STATUS_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_WOL_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_WOL_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_WOL_STATUS_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Wol Status"),
/*qca808x_end*/
#define SW_API_PT_INTERFACE_MODE_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_INTERFACE_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_INTERFACE_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_INTERFACE_MODE_SET, SW_INTERFACE_MODE, sizeof(fal_port_interface_mode_t), SW_PARAM_IN, "Interface Mode"),


#define SW_API_PT_INTERFACE_MODE_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_INTERFACE_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_INTERFACE_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_INTERFACE_MODE_GET, SW_INTERFACE_MODE, sizeof(fal_port_interface_mode_t), SW_PARAM_PTR|SW_PARAM_OUT, \
              "Interface Mode"),

#define SW_API_PT_INTERFACE_MODE_APPLY_DESC \
		SW_PARAM_DEF(SW_API_PT_INTERFACE_MODE_APPLY, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),
/*qca808x_start*/
#define SW_API_PT_INTERFACE_MODE_STATUS_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_INTERFACE_MODE_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_INTERFACE_MODE_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_INTERFACE_MODE_STATUS_GET, SW_INTERFACE_MODE, sizeof(fal_port_interface_mode_t), SW_PARAM_PTR|SW_PARAM_OUT, \
              "Interface Status"),

#define SW_API_DEBUG_PHYCOUNTER_SET_DESC \
			SW_PARAM_DEF(SW_API_DEBUG_PHYCOUNTER_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
			SW_PARAM_DEF(SW_API_DEBUG_PHYCOUNTER_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
			SW_PARAM_DEF(SW_API_DEBUG_PHYCOUNTER_SET, SW_ENABLE, 4, SW_PARAM_IN, "Counter Status"),

#define SW_API_DEBUG_PHYCOUNTER_GET_DESC \
			SW_PARAM_DEF(SW_API_DEBUG_PHYCOUNTER_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
			SW_PARAM_DEF(SW_API_DEBUG_PHYCOUNTER_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
			SW_PARAM_DEF(SW_API_DEBUG_PHYCOUNTER_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Counter Status"),

#define SW_API_DEBUG_PHYCOUNTER_SHOW_DESC \
		SW_PARAM_DEF(SW_API_DEBUG_PHYCOUNTER_SHOW, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
		SW_PARAM_DEF(SW_API_DEBUG_PHYCOUNTER_SHOW, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
		SW_PARAM_DEF(SW_API_DEBUG_PHYCOUNTER_SHOW, SW_COUNTER_INFO, sizeof(fal_port_counter_info_t), SW_PARAM_PTR|SW_PARAM_OUT, \
				  "Phy Counter Statistics On port"),
/*qca808x_end*/
#define SW_API_PT_MTU_SET_DESC \
	SW_PARAM_DEF(SW_API_PT_MTU_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
	SW_PARAM_DEF(SW_API_PT_MTU_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
	SW_PARAM_DEF(SW_API_PT_MTU_SET, SW_MTU_ENTRY, sizeof(fal_mtu_ctrl_t), SW_PARAM_PTR|SW_PARAM_IN, "Port MTU"),

#define SW_API_PT_MTU_GET_DESC \
	SW_PARAM_DEF(SW_API_PT_MTU_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
	SW_PARAM_DEF(SW_API_PT_MTU_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
	SW_PARAM_DEF(SW_API_PT_MTU_GET, SW_MTU_INFO, sizeof(fal_mtu_ctrl_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Port MTU"),

#define SW_API_PT_MRU_SET_DESC \
	SW_PARAM_DEF(SW_API_PT_MRU_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
	SW_PARAM_DEF(SW_API_PT_MRU_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
	SW_PARAM_DEF(SW_API_PT_MRU_SET, SW_MRU_ENTRY, sizeof(fal_mru_ctrl_t), SW_PARAM_PTR|SW_PARAM_IN, "Port MRU"),

#define SW_API_PT_MRU_GET_DESC \
	SW_PARAM_DEF(SW_API_PT_MRU_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
	SW_PARAM_DEF(SW_API_PT_MRU_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
	SW_PARAM_DEF(SW_API_PT_MRU_GET, SW_MRU_INFO, sizeof(fal_mru_ctrl_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Port MRU"),

#define SW_API_PT_MTU_CFG_SET_DESC \
	SW_PARAM_DEF(SW_API_PT_MTU_CFG_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
	SW_PARAM_DEF(SW_API_PT_MTU_CFG_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
	SW_PARAM_DEF(SW_API_PT_MTU_CFG_SET, SW_MTU_CFG, sizeof(fal_mtu_cfg_t), \
		SW_PARAM_PTR|SW_PARAM_IN, "Port MTU CFG"),

#define SW_API_PT_MTU_CFG_GET_DESC \
	SW_PARAM_DEF(SW_API_PT_MTU_CFG_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
	SW_PARAM_DEF(SW_API_PT_MTU_CFG_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
	SW_PARAM_DEF(SW_API_PT_MTU_CFG_GET, SW_MTU_CFG, sizeof(fal_mtu_cfg_t), \
		SW_PARAM_PTR|SW_PARAM_OUT, "Port MTU CFG"),

#define SW_API_PT_MRU_MTU_SET_DESC \
		SW_PARAM_DEF(SW_API_PT_MRU_MTU_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
		SW_PARAM_DEF(SW_API_PT_MRU_MTU_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
		SW_PARAM_DEF(SW_API_PT_MRU_MTU_SET, SW_UINT32, 4, SW_PARAM_IN, "Mru size"), \
		SW_PARAM_DEF(SW_API_PT_MRU_MTU_SET, SW_UINT32, 4, SW_PARAM_IN, "Mtu size"),

#define SW_API_PT_MRU_MTU_GET_DESC \
		SW_PARAM_DEF(SW_API_PT_MRU_MTU_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
		SW_PARAM_DEF(SW_API_PT_MRU_MTU_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
		SW_PARAM_DEF(SW_API_PT_MRU_MTU_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, \
			"Mru size"), \
		SW_PARAM_DEF(SW_API_PT_MRU_MTU_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, \
			"Mtu size"),

#define SW_API_PT_SOURCE_FILTER_GET_DESC \
	SW_PARAM_DEF(SW_API_PT_SOURCE_FILTER_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
	SW_PARAM_DEF(SW_API_PT_SOURCE_FILTER_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
	SW_PARAM_DEF(SW_API_PT_SOURCE_FILTER_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Enable"),

#define SW_API_PT_SOURCE_FILTER_SET_DESC \
	SW_PARAM_DEF(SW_API_PT_SOURCE_FILTER_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
	SW_PARAM_DEF(SW_API_PT_SOURCE_FILTER_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
	SW_PARAM_DEF(SW_API_PT_SOURCE_FILTER_SET, SW_ENABLE, 4, SW_PARAM_IN, "Enable"),

#define SW_API_PT_FRAME_MAX_SIZE_GET_DESC \
	SW_PARAM_DEF(SW_API_PT_FRAME_MAX_SIZE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
	SW_PARAM_DEF(SW_API_PT_FRAME_MAX_SIZE_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
	SW_PARAM_DEF(SW_API_PT_FRAME_MAX_SIZE_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Frame Max Size"),

#define SW_API_PT_FRAME_MAX_SIZE_SET_DESC \
	SW_PARAM_DEF(SW_API_PT_FRAME_MAX_SIZE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
	SW_PARAM_DEF(SW_API_PT_FRAME_MAX_SIZE_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
	SW_PARAM_DEF(SW_API_PT_FRAME_MAX_SIZE_SET, SW_UINT32, 4, SW_PARAM_IN, "Frame Max Size"),

#define SW_API_PT_INTERFACE_3AZ_STATUS_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_INTERFACE_3AZ_STATUS_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_INTERFACE_3AZ_STATUS_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_INTERFACE_3AZ_STATUS_SET, SW_ENABLE, sizeof(a_bool_t), SW_PARAM_IN, "Status"),

#define SW_API_PT_INTERFACE_3AZ_STATUS_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_INTERFACE_3AZ_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_INTERFACE_3AZ_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_INTERFACE_3AZ_STATUS_GET, SW_ENABLE, sizeof(a_bool_t), SW_PARAM_PTR|SW_PARAM_OUT, "Status"),

#define SW_API_PT_PROMISC_MODE_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_PROMISC_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_PROMISC_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_PT_PROMISC_MODE_SET, SW_ENABLE, 4, SW_PARAM_IN, "Enable"),

#define SW_API_PT_PROMISC_MODE_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_PROMISC_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_PT_PROMISC_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_PT_PROMISC_MODE_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Enable"),

#define SW_API_PT_INTERFACE_EEE_CFG_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_INTERFACE_EEE_CFG_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_INTERFACE_EEE_CFG_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_INTERFACE_EEE_CFG_SET, SW_PORT_EEE_CONFIG, \
        sizeof(fal_port_eee_cfg_t), SW_PARAM_PTR|SW_PARAM_IN, "EEE"),

#define SW_API_PT_INTERFACE_EEE_CFG_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_INTERFACE_EEE_CFG_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_INTERFACE_EEE_CFG_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_INTERFACE_EEE_CFG_GET, SW_PORT_EEE_CONFIG,\
        sizeof(fal_port_eee_cfg_t), SW_PARAM_PTR|SW_PARAM_OUT, "EEE"),

#define SW_API_PT_SOURCE_FILTER_CONFIG_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_SOURCE_FILTER_CONFIG_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_PT_SOURCE_FILTER_CONFIG_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_SOURCE_FILTER_CONFIG_GET, SW_SRC_FILTER_CONFIG, \
        sizeof(fal_src_filter_config_t), SW_PARAM_PTR|SW_PARAM_OUT, "srcfilter config"),

#define SW_API_PT_SOURCE_FILTER_CONFIG_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_SOURCE_FILTER_CONFIG_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_PT_SOURCE_FILTER_CONFIG_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_SOURCE_FILTER_CONFIG_SET, SW_SRC_FILTER_CONFIG, \
        sizeof(fal_src_filter_config_t), SW_PARAM_PTR|SW_PARAM_IN, "srcfilter config"),

#define SW_API_PT_SWITCH_PORT_LOOPBACK_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_SWITCH_PORT_LOOPBACK_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_SWITCH_PORT_LOOPBACK_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_SWITCH_PORT_LOOPBACK_SET, SW_PORT_LOOPBACK_CONFIG, \
        sizeof(fal_loopback_config_t), SW_PARAM_PTR|SW_PARAM_IN, "LOOPBACK"),

#define SW_API_PT_SWITCH_PORT_LOOPBACK_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_SWITCH_PORT_LOOPBACK_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_SWITCH_PORT_LOOPBACK_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_SWITCH_PORT_LOOPBACK_GET, SW_PORT_LOOPBACK_CONFIG,\
        sizeof(fal_loopback_config_t), SW_PARAM_PTR|SW_PARAM_OUT, "LOOPBACK"),

#define SW_API_PT_8023AH_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_8023AH_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_8023AH_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_8023AH_SET, SW_PORT_8023AH_CTRL,\
        sizeof(fal_port_8023ah_ctrl_t), SW_PARAM_PTR|SW_PARAM_IN, "8023ah"),

#define SW_API_PT_CNT_CFG_SET_DESC \
		SW_PARAM_DEF(SW_API_PT_CNT_CFG_SET, SW_UINT32, \
				sizeof(a_uint32_t), SW_PARAM_IN, "Dev ID"), \
		SW_PARAM_DEF(SW_API_PT_CNT_CFG_SET, SW_UINT32, \
				sizeof(a_uint32_t), SW_PARAM_IN, "Port ID"), \
		SW_PARAM_DEF(SW_API_PT_CNT_CFG_SET, SW_PORT_CNT_CFG, \
				sizeof(fal_port_cnt_cfg_t), SW_PARAM_IN|SW_PARAM_PTR, "counter config"),

#define SW_API_PT_CNT_CFG_GET_DESC \
		SW_PARAM_DEF(SW_API_PT_CNT_CFG_GET, SW_UINT32, \
				sizeof(a_uint32_t), SW_PARAM_IN, "Dev ID"), \
		SW_PARAM_DEF(SW_API_PT_CNT_CFG_GET, SW_UINT32, \
				sizeof(a_uint32_t), SW_PARAM_IN, "Port ID"), \
		SW_PARAM_DEF(SW_API_PT_CNT_CFG_GET, SW_PORT_CNT_CFG, \
				sizeof(fal_port_cnt_cfg_t), SW_PARAM_OUT|SW_PARAM_PTR, "counter config"),

#define SW_API_PT_CNT_GET_DESC \
		SW_PARAM_DEF(SW_API_PT_CNT_GET, SW_UINT32, \
				sizeof(a_uint32_t), SW_PARAM_IN, "Dev ID"), \
		SW_PARAM_DEF(SW_API_PT_CNT_GET, SW_UINT32, \
				sizeof(a_uint32_t), SW_PARAM_IN, "Port ID"), \
		SW_PARAM_DEF(SW_API_PT_CNT_GET, SW_PORT_CNT, \
				sizeof(fal_port_cnt_t), SW_PARAM_OUT|SW_PARAM_PTR, "counter"),

#define SW_API_PT_CNT_FLUSH_DESC \
		SW_PARAM_DEF(SW_API_PT_CNT_FLUSH, SW_UINT32, \
				sizeof(a_uint32_t), SW_PARAM_IN, "Dev ID"), \
		SW_PARAM_DEF(SW_API_PT_CNT_FLUSH, SW_UINT32, \
				sizeof(a_uint32_t), SW_PARAM_IN, "Port ID"),

#define SW_API_PT_8023AH_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_8023AH_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_8023AH_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_8023AH_GET, SW_PORT_8023AH_CTRL,\
        sizeof(fal_port_8023ah_ctrl_t), SW_PARAM_PTR|SW_PARAM_OUT, "8023ah"),

#define SW_API_VLAN_ADD_DESC \
    SW_PARAM_DEF(SW_API_VLAN_ADD, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_VLAN_ADD, SW_UINT32, 4, SW_PARAM_IN, "Vlan Id"),

#define SW_API_VLAN_DEL_DESC \
    SW_PARAM_DEF(SW_API_VLAN_DEL, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_VLAN_DEL, SW_UINT32, 4, SW_PARAM_IN, "Vlan Id"),

#define SW_API_VLAN_MEM_UPDATE_DESC \
    SW_PARAM_DEF(SW_API_VLAN_MEM_UPDATE, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_VLAN_MEM_UPDATE, SW_UINT32, 4, SW_PARAM_IN, "Vlan Id"), \
    SW_PARAM_DEF(SW_API_VLAN_MEM_UPDATE, SW_PBMP, sizeof(fal_pbmp_t), SW_PARAM_IN, \
              "Member Port Map"), \
    SW_PARAM_DEF(SW_API_VLAN_MEM_UPDATE, SW_PBMP, sizeof(fal_pbmp_t), SW_PARAM_IN, \
              "U Member Port Map"),

#define SW_API_VLAN_FIND_DESC \
    SW_PARAM_DEF(SW_API_VLAN_FIND, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_VLAN_FIND, SW_UINT32, 4, SW_PARAM_IN, "Vlan Id"), \
    SW_PARAM_DEF(SW_API_VLAN_FIND, SW_VLAN, sizeof(fal_vlan_t), SW_PARAM_PTR|SW_PARAM_OUT, \
              "Vlan Entry"),

#define SW_API_VLAN_NEXT_DESC \
    SW_PARAM_DEF(SW_API_VLAN_NEXT, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_VLAN_NEXT, SW_UINT32, 4, SW_PARAM_IN, "Vlan Id"), \
    SW_PARAM_DEF(SW_API_VLAN_NEXT, SW_VLAN, sizeof(fal_vlan_t), SW_PARAM_PTR|SW_PARAM_OUT, \
              "Vlan Entry"),

#define SW_API_VLAN_APPEND_DESC \
    SW_PARAM_DEF(SW_API_VLAN_APPEND, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_VLAN_APPEND, SW_VLAN, sizeof(fal_vlan_t), SW_PARAM_PTR|SW_PARAM_IN, "Vlan Entry"),

#define SW_API_VLAN_FLUSH_DESC \
    SW_PARAM_DEF(SW_API_VLAN_FLUSH, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),

#define SW_API_VLAN_FID_SET_DESC \
    SW_PARAM_DEF(SW_API_VLAN_FID_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_VLAN_FID_SET, SW_UINT32, 4, SW_PARAM_IN, "Vlan ID"), \
    SW_PARAM_DEF(SW_API_VLAN_FID_SET, SW_UINT32, 4, SW_PARAM_IN, "FDB ID"),

#define SW_API_VLAN_FID_GET_DESC \
    SW_PARAM_DEF(SW_API_VLAN_FID_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_VLAN_FID_GET, SW_UINT32, 4, SW_PARAM_IN, "Vlan ID"), \
    SW_PARAM_DEF(SW_API_VLAN_FID_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "FDB ID"),

#define SW_API_VLAN_MEMBER_ADD_DESC \
    SW_PARAM_DEF(SW_API_VLAN_MEMBER_ADD, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_VLAN_MEMBER_ADD, SW_UINT32, 4, SW_PARAM_IN, "Vlan ID"), \
    SW_PARAM_DEF(SW_API_VLAN_MEMBER_ADD, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_VLAN_MEMBER_ADD, SW_EGMODE, sizeof(fal_pt_1q_egmode_t), \
                SW_PARAM_IN, "Port Info"),

#define SW_API_VLAN_MEMBER_DEL_DESC \
    SW_PARAM_DEF(SW_API_VLAN_MEMBER_DEL, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_VLAN_MEMBER_DEL, SW_UINT32, 4, SW_PARAM_IN, "Vlan ID"), \
    SW_PARAM_DEF(SW_API_VLAN_MEMBER_DEL, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),

#define SW_API_VLAN_LEARN_STATE_SET_DESC \
    SW_PARAM_DEF(SW_API_VLAN_LEARN_STATE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_VLAN_LEARN_STATE_SET, SW_UINT32, 4, SW_PARAM_IN, "Vlan ID"), \
    SW_PARAM_DEF(SW_API_VLAN_LEARN_STATE_SET, SW_ENABLE, 4, SW_PARAM_IN, "Enable"),

#define SW_API_VLAN_LEARN_STATE_GET_DESC \
    SW_PARAM_DEF(SW_API_VLAN_LEARN_STATE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_VLAN_LEARN_STATE_GET, SW_UINT32, 4, SW_PARAM_IN, "Vlan ID"), \
    SW_PARAM_DEF(SW_API_VLAN_LEARN_STATE_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Enable"),

#define SW_API_LAN_WAN_CFG_SET_DESC \
    SW_PARAM_DEF(SW_API_LAN_WAN_CFG_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_LAN_WAN_CFG_SET, SW_LAN_WAN_CFG, sizeof(qca_lan_wan_cfg_t), \
		    SW_PARAM_PTR|SW_PARAM_IN, "Vlan Lan Wan Configuration"),

#define SW_API_LAN_WAN_CFG_GET_DESC \
    SW_PARAM_DEF(SW_API_LAN_WAN_CFG_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_LAN_WAN_CFG_GET, SW_LAN_WAN_CFG, sizeof(qca_lan_wan_cfg_t), \
		    SW_PARAM_PTR|SW_PARAM_OUT, "Vlan Lan Wan Configuration"),

#define SW_API_PT_ING_MODE_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_ING_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_ING_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Port No."), \
    SW_PARAM_DEF(SW_API_PT_ING_MODE_GET, SW_1QMODE, sizeof(fal_pt_1qmode_t), \
              SW_PARAM_PTR|SW_PARAM_OUT, "1qmode"),

#define SW_API_PT_ING_MODE_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_ING_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_ING_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Port No."), \
    SW_PARAM_DEF(SW_API_PT_ING_MODE_SET, SW_1QMODE, sizeof(fal_pt_1qmode_t), \
              SW_PARAM_IN, "1qmode"),

#define SW_API_PT_EG_MODE_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_EG_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_EG_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Port No."), \
    SW_PARAM_DEF(SW_API_PT_EG_MODE_GET, SW_EGMODE, sizeof(fal_pt_1q_egmode_t),\
              SW_PARAM_PTR|SW_PARAM_OUT, "egvlan"),

#define SW_API_PT_EG_MODE_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_EG_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_EG_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Port No."), \
    SW_PARAM_DEF(SW_API_PT_EG_MODE_SET, SW_EGMODE, sizeof(fal_pt_1q_egmode_t),  \
              SW_PARAM_IN, "egvlan"),

#define SW_API_PT_VLAN_MEM_ADD_DESC \
    SW_PARAM_DEF(SW_API_PT_VLAN_MEM_ADD, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_VLAN_MEM_ADD, SW_UINT32, 4, SW_PARAM_IN, "Port No."), \
    SW_PARAM_DEF(SW_API_PT_VLAN_MEM_ADD, SW_UINT32, 4, SW_PARAM_IN, "Member Port Id"),

#define SW_API_PT_VLAN_MEM_DEL_DESC \
    SW_PARAM_DEF(SW_API_PT_VLAN_MEM_DEL, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_VLAN_MEM_DEL, SW_UINT32, 4, SW_PARAM_IN, "Port No."), \
    SW_PARAM_DEF(SW_API_PT_VLAN_MEM_DEL, SW_UINT32, 4, SW_PARAM_IN, "Member Port Id"),

#define SW_API_PT_VLAN_MEM_UPDATE_DESC \
    SW_PARAM_DEF(SW_API_PT_VLAN_MEM_UPDATE, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_VLAN_MEM_UPDATE, SW_UINT32, 4, SW_PARAM_IN, "Port No."), \
    SW_PARAM_DEF(SW_API_PT_VLAN_MEM_UPDATE, SW_PBMP, sizeof(fal_pbmp_t), SW_PARAM_IN, \
              "Member Port Bitmap"),

#define SW_API_PT_VLAN_MEM_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_VLAN_MEM_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_PT_VLAN_MEM_GET, SW_UINT32, 4, SW_PARAM_IN, "Port No."),  \
    SW_PARAM_DEF(SW_API_PT_VLAN_MEM_GET, SW_PBMP, sizeof(fal_pbmp_t), SW_PARAM_PTR|SW_PARAM_OUT, \
              "Member Port Bitmap"),

#define SW_API_PT_DEF_VID_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_DEF_VID_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_PT_DEF_VID_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID."),  \
    SW_PARAM_DEF(SW_API_PT_DEF_VID_SET, SW_UINT32, 4, SW_PARAM_IN, "Vlan Id"),

#define SW_API_PT_DEF_VID_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_DEF_VID_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_PT_DEF_VID_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID."),  \
    SW_PARAM_DEF(SW_API_PT_DEF_VID_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Vlan Id"),

#define SW_API_PT_FORCE_DEF_VID_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_FORCE_DEF_VID_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_PT_FORCE_DEF_VID_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),    \
    SW_PARAM_DEF(SW_API_PT_FORCE_DEF_VID_SET, SW_ENABLE, 4, SW_PARAM_IN, "Force"),

#define SW_API_PT_FORCE_DEF_VID_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_FORCE_DEF_VID_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_PT_FORCE_DEF_VID_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),    \
    SW_PARAM_DEF(SW_API_PT_FORCE_DEF_VID_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Force"),

#define SW_API_PT_FORCE_PORTVLAN_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_FORCE_PORTVLAN_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_PT_FORCE_PORTVLAN_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),    \
    SW_PARAM_DEF(SW_API_PT_FORCE_PORTVLAN_SET, SW_ENABLE, 4, SW_PARAM_IN, "Force"),

#define SW_API_PT_FORCE_PORTVLAN_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_FORCE_PORTVLAN_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_PT_FORCE_PORTVLAN_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),    \
    SW_PARAM_DEF(SW_API_PT_FORCE_PORTVLAN_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Force"),

#define SW_API_PT_NESTVLAN_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_NESTVLAN_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_PT_NESTVLAN_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),   \
    SW_PARAM_DEF(SW_API_PT_NESTVLAN_SET, SW_ENABLE, 4, SW_PARAM_IN, "Nestvlan"),

#define SW_API_PT_NESTVLAN_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_NESTVLAN_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_PT_NESTVLAN_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),    \
    SW_PARAM_DEF(SW_API_PT_NESTVLAN_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Nestvlan"),

#define SW_API_NESTVLAN_TPID_SET_DESC \
    SW_PARAM_DEF(SW_API_NESTVLAN_TPID_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_NESTVLAN_TPID_SET, SW_UINT32, 4, SW_PARAM_IN, "TPID"),

#define SW_API_NESTVLAN_TPID_GET_DESC \
    SW_PARAM_DEF(SW_API_NESTVLAN_TPID_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_NESTVLAN_TPID_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "TPID"),

#define SW_API_PT_IN_VLAN_MODE_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_IN_VLAN_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_PT_IN_VLAN_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),   \
    SW_PARAM_DEF(SW_API_PT_IN_VLAN_MODE_SET, SW_INVLAN, sizeof(fal_pt_invlan_mode_t), SW_PARAM_IN, "Invlan"),

#define SW_API_PT_IN_VLAN_MODE_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_IN_VLAN_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_PT_IN_VLAN_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),    \
    SW_PARAM_DEF(SW_API_PT_IN_VLAN_MODE_GET, SW_INVLAN, sizeof(fal_pt_invlan_mode_t), SW_PARAM_PTR|SW_PARAM_OUT, "Invlan"),

#define SW_API_PT_TLS_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_TLS_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_PT_TLS_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),    \
    SW_PARAM_DEF(SW_API_PT_TLS_SET, SW_ENABLE, 4, SW_PARAM_IN, "Enable"),

#define SW_API_PT_TLS_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_TLS_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_PT_TLS_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),    \
    SW_PARAM_DEF(SW_API_PT_TLS_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Enable"),

#define SW_API_PT_PRI_PROPAGATION_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_PRI_PROPAGATION_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_PT_PRI_PROPAGATION_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),   \
    SW_PARAM_DEF(SW_API_PT_PRI_PROPAGATION_SET, SW_ENABLE, 4, SW_PARAM_IN, "Enable"),

#define SW_API_PT_PRI_PROPAGATION_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_PRI_PROPAGATION_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_PT_PRI_PROPAGATION_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),    \
    SW_PARAM_DEF(SW_API_PT_PRI_PROPAGATION_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Enable"),

#define SW_API_PT_DEF_SVID_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_DEF_SVID_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_PT_DEF_SVID_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),   \
    SW_PARAM_DEF(SW_API_PT_DEF_SVID_SET, SW_UINT32, 4, SW_PARAM_IN, "svid"),

#define SW_API_PT_DEF_SVID_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_DEF_SVID_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_PT_DEF_SVID_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),    \
    SW_PARAM_DEF(SW_API_PT_DEF_SVID_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "svid"),

#define SW_API_PT_DEF_CVID_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_DEF_CVID_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_PT_DEF_CVID_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),   \
    SW_PARAM_DEF(SW_API_PT_DEF_CVID_SET, SW_UINT32, 4, SW_PARAM_IN, "cvid"),

#define SW_API_PT_DEF_CVID_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_DEF_CVID_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_PT_DEF_CVID_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),    \
    SW_PARAM_DEF(SW_API_PT_DEF_CVID_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "cvid"),

#define SW_API_PT_VLAN_PROPAGATION_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_VLAN_PROPAGATION_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_PT_VLAN_PROPAGATION_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),   \
    SW_PARAM_DEF(SW_API_PT_VLAN_PROPAGATION_SET, SW_VLANPROPAGATION, sizeof(fal_vlan_propagation_mode_t), SW_PARAM_IN, "Vlan propagation"),

#define SW_API_PT_VLAN_PROPAGATION_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_VLAN_PROPAGATION_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_PT_VLAN_PROPAGATION_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),    \
    SW_PARAM_DEF(SW_API_PT_VLAN_PROPAGATION_GET, SW_VLANPROPAGATION, sizeof(fal_vlan_propagation_mode_t), SW_PARAM_PTR|SW_PARAM_OUT, "Vlan propagation"),

#define SW_API_PT_VLAN_TRANS_ADD_DESC \
    SW_PARAM_DEF(SW_API_PT_VLAN_TRANS_ADD, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_PT_VLAN_TRANS_ADD, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_PT_VLAN_TRANS_ADD, SW_VLANTRANSLATION, sizeof(fal_vlan_trans_entry_t), SW_PARAM_PTR|SW_PARAM_IN, "Vlan Translation"),

#define SW_API_PT_VLAN_TRANS_DEL_DESC \
    SW_PARAM_DEF(SW_API_PT_VLAN_TRANS_DEL, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_PT_VLAN_TRANS_DEL, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_PT_VLAN_TRANS_DEL, SW_VLANTRANSLATION, sizeof(fal_vlan_trans_entry_t), SW_PARAM_PTR|SW_PARAM_IN, "Vlan Translation"),

#define SW_API_PT_VLAN_TRANS_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_VLAN_TRANS_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_PT_VLAN_TRANS_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_PT_VLAN_TRANS_GET, SW_VLANTRANSLATION, sizeof(fal_vlan_trans_entry_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Vlan Translation"),

#define SW_API_QINQ_MODE_SET_DESC \
    SW_PARAM_DEF(SW_API_QINQ_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_QINQ_MODE_SET, SW_QINQMODE, sizeof(fal_qinq_mode_t), SW_PARAM_IN, "qinq mode"),

#define SW_API_QINQ_MODE_GET_DESC \
    SW_PARAM_DEF(SW_API_QINQ_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_QINQ_MODE_GET, SW_QINQMODE, sizeof(fal_qinq_mode_t), SW_PARAM_PTR|SW_PARAM_OUT, "qinq mode"),

#define SW_API_PT_QINQ_ROLE_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_QINQ_ROLE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_PT_QINQ_ROLE_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),   \
    SW_PARAM_DEF(SW_API_PT_QINQ_ROLE_SET, SW_QINQROLE, sizeof(fal_qinq_port_role_t), SW_PARAM_IN, "qinq role"),

#define SW_API_PT_QINQ_ROLE_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_QINQ_ROLE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_PT_QINQ_ROLE_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),    \
    SW_PARAM_DEF(SW_API_PT_QINQ_ROLE_GET, SW_QINQROLE, sizeof(fal_qinq_port_role_t), SW_PARAM_PTR|SW_PARAM_OUT, "qinq role"),

#define SW_API_PT_VLAN_TRANS_ITERATE_DESC \
    SW_PARAM_DEF(SW_API_PT_VLAN_TRANS_ITERATE, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_PT_VLAN_TRANS_ITERATE, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_PT_VLAN_TRANS_ITERATE, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Iterator"),\
    SW_PARAM_DEF(SW_API_PT_VLAN_TRANS_ITERATE, SW_VLANTRANSLATION, sizeof(fal_vlan_trans_entry_t), SW_PARAM_PTR|SW_PARAM_OUT, "Vlan Translation"),

#define SW_API_PT_MAC_VLAN_XLT_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_MAC_VLAN_XLT_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_PT_MAC_VLAN_XLT_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),   \
    SW_PARAM_DEF(SW_API_PT_MAC_VLAN_XLT_SET, SW_ENABLE, 4, SW_PARAM_IN, "Status"),

#define SW_API_PT_MAC_VLAN_XLT_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_MAC_VLAN_XLT_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_PT_MAC_VLAN_XLT_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),    \
    SW_PARAM_DEF(SW_API_PT_MAC_VLAN_XLT_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Status"),

#define SW_API_NETISOLATE_SET_DESC \
    SW_PARAM_DEF(SW_API_NETISOLATE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_NETISOLATE_SET, SW_ENABLE, 4, SW_PARAM_IN, "enable"),

#define SW_API_NETISOLATE_GET_DESC \
    SW_PARAM_DEF(SW_API_NETISOLATE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_NETISOLATE_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "enable"),

#define SW_API_EG_FLTR_BYPASS_EN_SET_DESC \
    SW_PARAM_DEF(SW_API_EG_FLTR_BYPASS_EN_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_EG_FLTR_BYPASS_EN_SET, SW_ENABLE, 4, SW_PARAM_IN, "enable"),

#define SW_API_EG_FLTR_BYPASS_EN_GET_DESC \
    SW_PARAM_DEF(SW_API_EG_FLTR_BYPASS_EN_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_EG_FLTR_BYPASS_EN_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "enable"),

#define SW_API_PT_VRF_ID_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_VRF_ID_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_PT_VRF_ID_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),   \
    SW_PARAM_DEF(SW_API_PT_VRF_ID_SET, SW_UINT32, 4, SW_PARAM_IN, "vrf_id"),

#define SW_API_PT_VRF_ID_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_VRF_ID_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_PT_VRF_ID_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),    \
    SW_PARAM_DEF(SW_API_PT_VRF_ID_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "vrf_id"),

#define SW_API_GLOBAL_QINQ_MODE_SET_DESC \
    SW_PARAM_DEF(SW_API_GLOBAL_QINQ_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_GLOBAL_QINQ_MODE_SET, SW_GLOBAL_QINQMODE, sizeof(fal_global_qinq_mode_t), SW_PARAM_PTR|SW_PARAM_IN, "global qinq mode"),

#define SW_API_GLOBAL_QINQ_MODE_GET_DESC \
    SW_PARAM_DEF(SW_API_GLOBAL_QINQ_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_GLOBAL_QINQ_MODE_GET, SW_GLOBAL_QINQMODE, sizeof(fal_global_qinq_mode_t), SW_PARAM_PTR|SW_PARAM_OUT, "global qinq mode"),

#define SW_API_PORT_QINQ_MODE_SET_DESC \
    SW_PARAM_DEF( SW_API_PORT_QINQ_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF( SW_API_PORT_QINQ_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),   \
    SW_PARAM_DEF( SW_API_PORT_QINQ_MODE_SET, SW_PT_QINQMODE, sizeof(fal_port_qinq_role_t), SW_PARAM_PTR|SW_PARAM_IN, "port qinq mode"),

#define SW_API_PORT_QINQ_MODE_GET_DESC \
    SW_PARAM_DEF(SW_API_PORT_QINQ_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_PORT_QINQ_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),   \
    SW_PARAM_DEF(SW_API_PORT_QINQ_MODE_GET, SW_PT_QINQMODE, sizeof(fal_port_qinq_role_t), SW_PARAM_PTR|SW_PARAM_OUT, "port qinq mode"),

#define SW_API_TPID_SET_DESC \
    SW_PARAM_DEF(SW_API_TPID_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_TPID_SET, SW_TPID, sizeof(fal_tpid_t), SW_PARAM_PTR|SW_PARAM_IN, "ingress tpid"),

#define SW_API_TPID_GET_DESC \
    SW_PARAM_DEF(SW_API_TPID_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_TPID_GET, SW_TPID, sizeof(fal_tpid_t), SW_PARAM_PTR|SW_PARAM_OUT, "ingress tpid"),

#define SW_API_EGRESS_TPID_SET_DESC \
    SW_PARAM_DEF(SW_API_EGRESS_TPID_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_EGRESS_TPID_SET, SW_TPID, sizeof(fal_tpid_t), SW_PARAM_PTR|SW_PARAM_IN, "egress tpid"),

#define SW_API_EGRESS_TPID_GET_DESC \
    SW_PARAM_DEF(SW_API_EGRESS_TPID_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_EGRESS_TPID_GET, SW_TPID, sizeof(fal_tpid_t), SW_PARAM_PTR|SW_PARAM_OUT, "egress tpid"),

#define SW_API_PT_INGRESS_VLAN_FILTER_SET_DESC \
    SW_PARAM_DEF( SW_API_PT_INGRESS_VLAN_FILTER_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF( SW_API_PT_INGRESS_VLAN_FILTER_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),   \
    SW_PARAM_DEF( SW_API_PT_INGRESS_VLAN_FILTER_SET, SW_INGRESS_FILTER, sizeof(fal_ingress_vlan_filter_t), SW_PARAM_PTR|SW_PARAM_IN, "ingress filter mode"),

#define SW_API_PT_INGRESS_VLAN_FILTER_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_INGRESS_VLAN_FILTER_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_PT_INGRESS_VLAN_FILTER_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),   \
    SW_PARAM_DEF(SW_API_PT_INGRESS_VLAN_FILTER_GET, SW_INGRESS_FILTER, sizeof(fal_ingress_vlan_filter_t), SW_PARAM_PTR|SW_PARAM_OUT, "ingress filter mode"),

#define SW_API_PT_DEFAULT_VLANTAG_SET_DESC \
    SW_PARAM_DEF( SW_API_PT_DEFAULT_VLANTAG_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF( SW_API_PT_DEFAULT_VLANTAG_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),   \
    SW_PARAM_DEF( SW_API_PT_DEFAULT_VLANTAG_SET, SW_PT_VLAN_DIRECTION, sizeof(fal_port_vlan_direction_t), SW_PARAM_IN, "vlan direction"), \
    SW_PARAM_DEF( SW_API_PT_DEFAULT_VLANTAG_SET, SW_PT_DEF_VID_EN, sizeof(fal_port_default_vid_enable_t), SW_PARAM_PTR|SW_PARAM_IN, "default vid en"), \
    SW_PARAM_DEF( SW_API_PT_DEFAULT_VLANTAG_SET, SW_PT_VLAN_TAG, sizeof(fal_port_vlan_tag_t), SW_PARAM_PTR|SW_PARAM_IN, "vlan tag"),

#define SW_API_PT_DEFAULT_VLANTAG_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_DEFAULT_VLANTAG_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_PT_DEFAULT_VLANTAG_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),   \
    SW_PARAM_DEF(SW_API_PT_DEFAULT_VLANTAG_GET, SW_PT_VLAN_DIRECTION, sizeof(fal_port_vlan_direction_t), SW_PARAM_IN, "vlan direction"), \
    SW_PARAM_DEF(SW_API_PT_DEFAULT_VLANTAG_GET, SW_PT_DEF_VID_EN, sizeof(fal_port_default_vid_enable_t), SW_PARAM_PTR|SW_PARAM_OUT, "default vid en"), \
    SW_PARAM_DEF(SW_API_PT_DEFAULT_VLANTAG_GET, SW_PT_VLAN_TAG, sizeof(fal_port_vlan_tag_t), SW_PARAM_PTR|SW_PARAM_OUT, "vlan tag"),

#define SW_API_PT_TAG_PROPAGATION_SET_DESC \
    SW_PARAM_DEF( SW_API_PT_TAG_PROPAGATION_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF( SW_API_PT_TAG_PROPAGATION_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),   \
    SW_PARAM_DEF( SW_API_PT_TAG_PROPAGATION_SET, SW_PT_VLAN_DIRECTION, sizeof(fal_port_vlan_direction_t), SW_PARAM_IN, "vlan direction"), \
    SW_PARAM_DEF( SW_API_PT_TAG_PROPAGATION_SET, SW_TAG_PROPAGATION, sizeof(fal_vlantag_propagation_t), SW_PARAM_PTR|SW_PARAM_IN, "tag propagation"),

#define SW_API_PT_TAG_PROPAGATION_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_TAG_PROPAGATION_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_PT_TAG_PROPAGATION_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),   \
    SW_PARAM_DEF(SW_API_PT_TAG_PROPAGATION_GET, SW_PT_VLAN_DIRECTION, sizeof(fal_port_vlan_direction_t), SW_PARAM_IN, "vlan direction"), \
    SW_PARAM_DEF(SW_API_PT_TAG_PROPAGATION_GET, SW_TAG_PROPAGATION, sizeof(fal_vlantag_propagation_t), SW_PARAM_PTR|SW_PARAM_OUT, "tag propagation"),

#define SW_API_PT_VLANTAG_EGMODE_SET_DESC \
    SW_PARAM_DEF( SW_API_PT_VLANTAG_EGMODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF( SW_API_PT_VLANTAG_EGMODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),   \
    SW_PARAM_DEF( SW_API_PT_VLANTAG_EGMODE_SET, SW_EGRESS_MODE, sizeof(fal_vlantag_egress_mode_t), SW_PARAM_PTR|SW_PARAM_IN, "egress mode"),

#define SW_API_PT_VLANTAG_EGMODE_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_VLANTAG_EGMODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_PT_VLANTAG_EGMODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),   \
    SW_PARAM_DEF(SW_API_PT_VLANTAG_EGMODE_GET, SW_EGRESS_MODE, sizeof(fal_vlantag_egress_mode_t), SW_PARAM_PTR|SW_PARAM_OUT, "egress mode"),

#define SW_API_PT_VLAN_XLT_MISS_CMD_SET_DESC \
    SW_PARAM_DEF( SW_API_PT_VLAN_XLT_MISS_CMD_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF( SW_API_PT_VLAN_XLT_MISS_CMD_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),   \
    SW_PARAM_DEF( SW_API_PT_VLAN_XLT_MISS_CMD_SET, SW_MACCMD, sizeof(fal_fwd_cmd_t), SW_PARAM_IN, "translation_miss_action"),

#define SW_API_PT_VLAN_XLT_MISS_CMD_GET_DESC \
    SW_PARAM_DEF( SW_API_PT_VLAN_XLT_MISS_CMD_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF( SW_API_PT_VLAN_XLT_MISS_CMD_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),   \
    SW_PARAM_DEF( SW_API_PT_VLAN_XLT_MISS_CMD_GET, SW_MACCMD, sizeof(fal_fwd_cmd_t), SW_PARAM_PTR|SW_PARAM_OUT, "translation_miss_action"),

#define SW_API_PT_VSI_EGMODE_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_VSI_EGMODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_PT_VSI_EGMODE_SET, SW_UINT32, 4, SW_PARAM_IN, "VSI ID"),    \
    SW_PARAM_DEF(SW_API_PT_VSI_EGMODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),   \
    SW_PARAM_DEF(SW_API_PT_VSI_EGMODE_SET, SW_EGMODE, sizeof(fal_pt_1q_egmode_t), SW_PARAM_IN, "vsi_egress_vlan_mode"),

#define SW_API_PT_VSI_EGMODE_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_VSI_EGMODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_PT_VSI_EGMODE_GET, SW_UINT32, 4, SW_PARAM_IN, "VSI ID"),    \
    SW_PARAM_DEF(SW_API_PT_VSI_EGMODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),   \
    SW_PARAM_DEF(SW_API_PT_VSI_EGMODE_GET, SW_EGMODE, sizeof(fal_pt_1q_egmode_t), SW_PARAM_PTR|SW_PARAM_OUT, "vsi_egress_vlan_mode"),

#define SW_API_PT_VLANTAG_VSI_EGMODE_EN_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_VLANTAG_VSI_EGMODE_EN_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_PT_VLANTAG_VSI_EGMODE_EN_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),   \
    SW_PARAM_DEF(SW_API_PT_VLANTAG_VSI_EGMODE_EN_SET, SW_ENABLE, 4, SW_PARAM_IN, "vsi_egress_vlan_mode_en"),

#define SW_API_PT_VLANTAG_VSI_EGMODE_EN_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_VLANTAG_VSI_EGMODE_EN_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_PT_VLANTAG_VSI_EGMODE_EN_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),   \
    SW_PARAM_DEF(SW_API_PT_VLANTAG_VSI_EGMODE_EN_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "vsi_egress_vlan_mode_en"),

#define SW_API_PT_VLAN_TRANS_ADV_ADD_DESC \
    SW_PARAM_DEF(SW_API_PT_VLAN_TRANS_ADV_ADD, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_PT_VLAN_TRANS_ADV_ADD, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),   \
    SW_PARAM_DEF(SW_API_PT_VLAN_TRANS_ADV_ADD, SW_PT_VLAN_DIRECTION, sizeof(fal_port_vlan_direction_t), SW_PARAM_IN, "vlan direction"), \
    SW_PARAM_DEF(SW_API_PT_VLAN_TRANS_ADV_ADD, SW_PT_VLAN_TRANS_ADV_RULE, sizeof(fal_vlan_trans_adv_rule_t), SW_PARAM_PTR|SW_PARAM_IN, "vlan trans rule"), \
    SW_PARAM_DEF(SW_API_PT_VLAN_TRANS_ADV_ADD, SW_PT_VLAN_TRANS_ADV_ACTION, sizeof(fal_vlan_trans_adv_action_t), SW_PARAM_PTR|SW_PARAM_IN, "vlan trans action"),

#define SW_API_PT_VLAN_TRANS_ADV_DEL_DESC \
    SW_PARAM_DEF(SW_API_PT_VLAN_TRANS_ADV_DEL, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_PT_VLAN_TRANS_ADV_DEL, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),   \
    SW_PARAM_DEF(SW_API_PT_VLAN_TRANS_ADV_DEL, SW_PT_VLAN_DIRECTION, sizeof(fal_port_vlan_direction_t), SW_PARAM_IN, "vlan direction"), \
    SW_PARAM_DEF(SW_API_PT_VLAN_TRANS_ADV_DEL, SW_PT_VLAN_TRANS_ADV_RULE, sizeof(fal_vlan_trans_adv_rule_t), SW_PARAM_PTR|SW_PARAM_IN, "vlan trans rule"), \
    SW_PARAM_DEF(SW_API_PT_VLAN_TRANS_ADV_DEL, SW_PT_VLAN_TRANS_ADV_ACTION, sizeof(fal_vlan_trans_adv_action_t), SW_PARAM_PTR|SW_PARAM_IN, "vlan trans action"),

#define SW_API_PT_VLAN_TRANS_ADV_GETFIRST_DESC \
    SW_PARAM_DEF(SW_API_PT_VLAN_TRANS_ADV_GETFIRST, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_PT_VLAN_TRANS_ADV_GETFIRST, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),   \
    SW_PARAM_DEF(SW_API_PT_VLAN_TRANS_ADV_GETFIRST, SW_PT_VLAN_DIRECTION, sizeof(fal_port_vlan_direction_t), SW_PARAM_IN, "vlan direction"), \
    SW_PARAM_DEF(SW_API_PT_VLAN_TRANS_ADV_GETFIRST, SW_PT_VLAN_TRANS_ADV_RULE, sizeof(fal_vlan_trans_adv_rule_t), SW_PARAM_PTR|SW_PARAM_OUT, "vlan trans rule"), \
    SW_PARAM_DEF(SW_API_PT_VLAN_TRANS_ADV_GETFIRST, SW_PT_VLAN_TRANS_ADV_ACTION, sizeof(fal_vlan_trans_adv_action_t), SW_PARAM_PTR|SW_PARAM_OUT, "vlan trans action"),

#define SW_API_PT_VLAN_TRANS_ADV_GETNEXT_DESC \
    SW_PARAM_DEF(SW_API_PT_VLAN_TRANS_ADV_GETNEXT, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_PT_VLAN_TRANS_ADV_GETNEXT, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),   \
    SW_PARAM_DEF(SW_API_PT_VLAN_TRANS_ADV_GETNEXT, SW_PT_VLAN_DIRECTION, sizeof(fal_port_vlan_direction_t), SW_PARAM_IN, "vlan direction"), \
    SW_PARAM_DEF(SW_API_PT_VLAN_TRANS_ADV_GETNEXT, SW_PT_VLAN_TRANS_ADV_RULE, sizeof(fal_vlan_trans_adv_rule_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "vlan trans rule"), \
    SW_PARAM_DEF(SW_API_PT_VLAN_TRANS_ADV_GETNEXT, SW_PT_VLAN_TRANS_ADV_ACTION, sizeof(fal_vlan_trans_adv_action_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "vlan trans action"),

#define SW_API_PT_VLAN_COUNTER_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_VLAN_COUNTER_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_PT_VLAN_COUNTER_GET, SW_UINT32, 4, SW_PARAM_IN, "Cnt Index"), \
    SW_PARAM_DEF(SW_API_PT_VLAN_COUNTER_GET, SW_PT_VLAN_COUNTER, sizeof(fal_port_vlan_counter_t), SW_PARAM_PTR|SW_PARAM_OUT, "enable"),

#define SW_API_PT_VLAN_COUNTER_CLEANUP_DESC \
    SW_PARAM_DEF(SW_API_PT_VLAN_COUNTER_CLEANUP, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),    \
    SW_PARAM_DEF(SW_API_PT_VLAN_COUNTER_CLEANUP, SW_UINT32, 4, SW_PARAM_IN, "Cnt Index"),

#define SW_API_PT_VLAN_VPGROUP_SET_DESC \
	SW_PARAM_DEF(SW_API_PT_VLAN_VPGROUP_SET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_PT_VLAN_VPGROUP_SET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Vport Id"),\
	SW_PARAM_DEF(SW_API_PT_VLAN_VPGROUP_SET, SW_PT_VLAN_DIRECTION, \
			sizeof(fal_port_vlan_direction_t), SW_PARAM_IN, "Direction "),\
	SW_PARAM_DEF(SW_API_PT_VLAN_VPGROUP_SET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Vpgroup Id"),

#define SW_API_PT_VLAN_VPGROUP_GET_DESC \
	SW_PARAM_DEF(SW_API_PT_VLAN_VPGROUP_GET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_PT_VLAN_VPGROUP_GET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Vport Id"),\
	SW_PARAM_DEF(SW_API_PT_VLAN_VPGROUP_GET, SW_PT_VLAN_DIRECTION, \
			sizeof(fal_port_vlan_direction_t), SW_PARAM_IN, "Direction "),\
	SW_PARAM_DEF(SW_API_PT_VLAN_VPGROUP_GET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_PTR|SW_PARAM_OUT, "Vpgroup Id"),

#define SW_API_PT_VLAN_ISOL_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_VLAN_ISOL_SET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_VLAN_ISOL_SET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "Port Id"), \
    SW_PARAM_DEF(SW_API_PT_VLAN_ISOL_SET, SW_ISOL_CTRL, \
		    sizeof(fal_portvlan_isol_ctrl_t), SW_PARAM_PTR|SW_PARAM_IN, "Isol Control"),

#define SW_API_PT_VLAN_ISOL_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_VLAN_ISOL_GET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_VLAN_ISOL_GET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "Port Id"), \
    SW_PARAM_DEF(SW_API_PT_VLAN_ISOL_GET, SW_ISOL_CTRL, \
		    sizeof(fal_portvlan_isol_ctrl_t), SW_PARAM_PTR|SW_PARAM_OUT, "Isol Control"),

#define SW_API_PT_VLAN_ISOL_GROUP_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_VLAN_ISOL_GROUP_SET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_VLAN_ISOL_GROUP_SET, SW_UINT8, \
		    sizeof(a_uint8_t), SW_PARAM_IN, "Group Id"), \
    SW_PARAM_DEF(SW_API_PT_VLAN_ISOL_GROUP_SET, SW_UINT64, \
		    sizeof(a_uint64_t), SW_PARAM_PTR|SW_PARAM_IN, "Group member"),

#define SW_API_PT_VLAN_ISOL_GROUP_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_VLAN_ISOL_GROUP_GET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_VLAN_ISOL_GROUP_GET, SW_UINT8, \
		    sizeof(a_uint8_t), SW_PARAM_IN, "Group Id"), \
    SW_PARAM_DEF(SW_API_PT_VLAN_ISOL_GROUP_GET, SW_UINT64, \
		    sizeof(a_uint64_t), SW_PARAM_PTR|SW_PARAM_OUT, "Group member"),

#define SW_API_PT_EGRESS_VLAN_FILTER_GET_DESC \
    SW_PARAM_DEF( SW_API_PT_EGRESS_VLAN_FILTER_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF( SW_API_PT_EGRESS_VLAN_FILTER_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF( SW_API_PT_EGRESS_VLAN_FILTER_GET, SW_EGRESS_FILTER, \
		    sizeof(fal_egress_vlan_filter_t), SW_PARAM_PTR|SW_PARAM_OUT, \
		    "egress filter mode"),

#define SW_API_PT_EGRESS_VLAN_FILTER_SET_DESC \
    SW_PARAM_DEF( SW_API_PT_EGRESS_VLAN_FILTER_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF( SW_API_PT_EGRESS_VLAN_FILTER_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF( SW_API_PT_EGRESS_VLAN_FILTER_SET, SW_EGRESS_FILTER, \
		    sizeof(fal_egress_vlan_filter_t), SW_PARAM_PTR|SW_PARAM_IN, \
		    "egress filter mode"),

#define SW_API_FDB_ADD_DESC \
    SW_PARAM_DEF(SW_API_FDB_ADD, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_FDB_ADD, SW_FDBENTRY, sizeof(fal_fdb_entry_t), SW_PARAM_PTR|SW_PARAM_IN, "Fdb Entry"),

#define SW_API_FDB_DELALL_DESC \
    SW_PARAM_DEF(SW_API_FDB_DELALL, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_FDB_DELALL, SW_UINT32, 4, SW_PARAM_IN, "Flag"),

#define SW_API_FDB_DELPORT_DESC \
    SW_PARAM_DEF(SW_API_FDB_DELPORT, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_FDB_DELPORT, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_FDB_DELPORT, SW_UINT32, 4, SW_PARAM_IN, "Flag"),

#define SW_API_FDB_DELMAC_DESC \
    SW_PARAM_DEF(SW_API_FDB_DELMAC, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_FDB_DELMAC, SW_FDBENTRY, sizeof(fal_fdb_entry_t), SW_PARAM_PTR|SW_PARAM_IN, "Fdb Entry"),

#define SW_API_FDB_FIRST_DESC \
    SW_PARAM_DEF(SW_API_FDB_FIRST, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_FDB_FIRST, SW_FDBENTRY, sizeof(fal_fdb_entry_t), SW_PARAM_PTR|SW_PARAM_OUT, "Fdb Entry"),

#define SW_API_FDB_NEXT_DESC \
    SW_PARAM_DEF(SW_API_FDB_NEXT, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_FDB_NEXT, SW_FDBENTRY, sizeof(fal_fdb_entry_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Fdb Entry"),

#define SW_API_FDB_FIND_DESC \
    SW_PARAM_DEF(SW_API_FDB_FIND, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_FDB_FIND, SW_FDBENTRY, sizeof(fal_fdb_entry_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Fdb Entry"),

#define SW_API_FDB_PT_LEARN_SET_DESC \
    SW_PARAM_DEF(SW_API_FDB_PT_LEARN_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_FDB_PT_LEARN_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_FDB_PT_LEARN_SET, SW_ENABLE, 4, SW_PARAM_IN, "Learn"),

#define SW_API_FDB_PT_LEARN_GET_DESC \
    SW_PARAM_DEF(SW_API_FDB_PT_LEARN_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_FDB_PT_LEARN_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_FDB_PT_LEARN_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Learn"),

#define SW_API_FDB_PT_NEWADDR_LEARN_SET_DESC \
    SW_PARAM_DEF(SW_API_FDB_PT_NEWADDR_LEARN_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_FDB_PT_NEWADDR_LEARN_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_FDB_PT_NEWADDR_LEARN_SET, SW_ENABLE, 4, SW_PARAM_IN, "Learn Ctrl"),\
    SW_PARAM_DEF(SW_API_FDB_PT_NEWADDR_LEARN_SET, SW_MACCMD, sizeof(fal_fwd_cmd_t), SW_PARAM_IN, "Action"),

#define SW_API_FDB_PT_NEWADDR_LEARN_GET_DESC \
    SW_PARAM_DEF(SW_API_FDB_PT_NEWADDR_LEARN_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_FDB_PT_NEWADDR_LEARN_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_FDB_PT_NEWADDR_LEARN_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Learn Ctrl"),\
    SW_PARAM_DEF(SW_API_FDB_PT_NEWADDR_LEARN_GET, SW_MACCMD, sizeof(fal_fwd_cmd_t), SW_PARAM_PTR|SW_PARAM_OUT, "Action"),

#define SW_API_FDB_PT_STAMOVE_SET_DESC \
    SW_PARAM_DEF(SW_API_FDB_PT_STAMOVE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_FDB_PT_STAMOVE_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_FDB_PT_STAMOVE_SET, SW_ENABLE, 4, SW_PARAM_IN, "Station Move"),\
    SW_PARAM_DEF(SW_API_FDB_PT_STAMOVE_SET, SW_MACCMD, sizeof(fal_fwd_cmd_t), SW_PARAM_IN, "Action"),

#define SW_API_FDB_PT_STAMOVE_GET_DESC \
    SW_PARAM_DEF(SW_API_FDB_PT_STAMOVE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_FDB_PT_STAMOVE_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_FDB_PT_STAMOVE_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Station Move"),\
    SW_PARAM_DEF(SW_API_FDB_PT_STAMOVE_GET, SW_MACCMD, sizeof(fal_fwd_cmd_t), SW_PARAM_PTR|SW_PARAM_OUT, "Action"),

#define SW_API_FDB_AGE_CTRL_SET_DESC \
    SW_PARAM_DEF(SW_API_FDB_AGE_CTRL_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_FDB_AGE_CTRL_SET, SW_ENABLE, 4, SW_PARAM_IN, "Age"),

#define SW_API_FDB_AGE_CTRL_GET_DESC \
    SW_PARAM_DEF(SW_API_FDB_AGE_CTRL_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_FDB_AGE_CTRL_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Age"),

#define SW_API_FDB_LEARN_CTRL_SET_DESC \
    SW_PARAM_DEF(SW_API_FDB_LEARN_CTRL_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_FDB_LEARN_CTRL_SET, SW_ENABLE, 4, SW_PARAM_IN, "Learn Ctrl"),

#define SW_API_FDB_LEARN_CTRL_GET_DESC \
    SW_PARAM_DEF(SW_API_FDB_LEARN_CTRL_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_FDB_LEARN_CTRL_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Learn Ctrl"),

#define SW_API_FDB_VLAN_IVL_SVL_SET_DESC \
    SW_PARAM_DEF(SW_API_FDB_VLAN_IVL_SVL_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_FDB_VLAN_IVL_SVL_SET, SW_FDBSMODE, 4, SW_PARAM_IN, "Smode"),

#define SW_API_FDB_VLAN_IVL_SVL_GET_DESC \
    SW_PARAM_DEF(SW_API_FDB_VLAN_IVL_SVL_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_FDB_VLAN_IVL_SVL_GET, SW_FDBSMODE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Smode"),

#define SW_API_FDB_AGE_TIME_SET_DESC \
    SW_PARAM_DEF(SW_API_FDB_AGE_TIME_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_FDB_AGE_TIME_SET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Time"),

#define SW_API_FDB_AGE_TIME_GET_DESC \
    SW_PARAM_DEF(SW_API_FDB_AGE_TIME_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_FDB_AGE_TIME_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Time"),

#define SW_API_FDB_ITERATE_DESC \
    SW_PARAM_DEF(SW_API_FDB_ITERATE, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_FDB_ITERATE, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Iterator"),\
    SW_PARAM_DEF(SW_API_FDB_ITERATE, SW_FDBENTRY, sizeof(fal_fdb_entry_t), SW_PARAM_PTR|SW_PARAM_OUT, "Fdb Entry"),

#define SW_API_FDB_EXTEND_NEXT_DESC \
    SW_PARAM_DEF(SW_API_FDB_EXTEND_NEXT, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_FDB_EXTEND_NEXT, SW_FDBOPRATION, sizeof(fal_fdb_op_t), SW_PARAM_PTR|SW_PARAM_IN, "OperateOption"),\
    SW_PARAM_DEF(SW_API_FDB_EXTEND_NEXT, SW_FDBENTRY, sizeof(fal_fdb_entry_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Fdb Entry"),

#define SW_API_FDB_EXTEND_FIRST_DESC \
    SW_PARAM_DEF(SW_API_FDB_EXTEND_FIRST, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_FDB_EXTEND_FIRST, SW_FDBOPRATION, sizeof(fal_fdb_op_t), SW_PARAM_PTR|SW_PARAM_IN, "OperateOption"),\
    SW_PARAM_DEF(SW_API_FDB_EXTEND_FIRST, SW_FDBENTRY, sizeof(fal_fdb_entry_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Fdb Entry"),

#define SW_API_FDB_TRANSFER_DESC \
    SW_PARAM_DEF(SW_API_FDB_TRANSFER, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_FDB_TRANSFER, SW_UINT32, 4, SW_PARAM_IN, "Old Port ID"),\
    SW_PARAM_DEF(SW_API_FDB_TRANSFER, SW_UINT32, 4, SW_PARAM_IN, "New Port ID"),\
    SW_PARAM_DEF(SW_API_FDB_TRANSFER, SW_UINT32, 4, SW_PARAM_IN, "FID"),\
    SW_PARAM_DEF(SW_API_FDB_TRANSFER, SW_FDBOPRATION, sizeof(fal_fdb_op_t), SW_PARAM_PTR|SW_PARAM_IN, "OperateOption"),

#define SW_API_PT_FDB_LEARN_COUNTER_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_FDB_LEARN_COUNTER_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_FDB_LEARN_COUNTER_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_PT_FDB_LEARN_COUNTER_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "LearnCnt"),

#define SW_API_PT_FDB_LEARN_LIMIT_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_FDB_LEARN_LIMIT_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_FDB_LEARN_LIMIT_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_PT_FDB_LEARN_LIMIT_SET, SW_ENABLE, 4, SW_PARAM_IN, "Enable"), \
    SW_PARAM_DEF(SW_API_PT_FDB_LEARN_LIMIT_SET, SW_UINT32, 4, SW_PARAM_IN, "LimitCnt"),

#define SW_API_PT_FDB_LEARN_LIMIT_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_FDB_LEARN_LIMIT_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_PT_FDB_LEARN_LIMIT_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_PT_FDB_LEARN_LIMIT_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Enable"), \
    SW_PARAM_DEF(SW_API_PT_FDB_LEARN_LIMIT_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "LimitCnt"),

#define SW_API_PT_FDB_LEARN_EXCEED_CMD_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_FDB_LEARN_EXCEED_CMD_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_FDB_LEARN_EXCEED_CMD_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_PT_FDB_LEARN_EXCEED_CMD_SET, SW_MACCMD, sizeof(fal_fwd_cmd_t), SW_PARAM_IN, "cmd"),

#define SW_API_PT_FDB_LEARN_EXCEED_CMD_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_FDB_LEARN_EXCEED_CMD_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_FDB_LEARN_EXCEED_CMD_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_PT_FDB_LEARN_EXCEED_CMD_GET, SW_MACCMD, sizeof(fal_fwd_cmd_t), SW_PARAM_PTR|SW_PARAM_OUT, "cmd"),

#define SW_API_FDB_LEARN_LIMIT_SET_DESC \
    SW_PARAM_DEF(SW_API_FDB_LEARN_LIMIT_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_FDB_LEARN_LIMIT_SET, SW_ENABLE, 4, SW_PARAM_IN, "Enable"), \
    SW_PARAM_DEF(SW_API_FDB_LEARN_LIMIT_SET, SW_UINT32, 4, SW_PARAM_IN, "LimitCnt"),

#define SW_API_FDB_LEARN_LIMIT_GET_DESC \
    SW_PARAM_DEF(SW_API_FDB_LEARN_LIMIT_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_FDB_LEARN_LIMIT_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Enable"), \
    SW_PARAM_DEF(SW_API_FDB_LEARN_LIMIT_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "LimitCnt"),

#define SW_API_FDB_LEARN_EXCEED_CMD_SET_DESC \
    SW_PARAM_DEF(SW_API_FDB_LEARN_EXCEED_CMD_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_FDB_LEARN_EXCEED_CMD_SET, SW_MACCMD, sizeof(fal_fwd_cmd_t), SW_PARAM_IN, "cmd"),

#define SW_API_FDB_LEARN_EXCEED_CMD_GET_DESC \
    SW_PARAM_DEF(SW_API_FDB_LEARN_EXCEED_CMD_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_FDB_LEARN_EXCEED_CMD_GET, SW_MACCMD, sizeof(fal_fwd_cmd_t), SW_PARAM_PTR|SW_PARAM_OUT, "cmd"),

#define SW_API_FDB_RESV_ADD_DESC \
    SW_PARAM_DEF(SW_API_FDB_RESV_ADD, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_FDB_RESV_ADD, SW_FDBENTRY, sizeof(fal_fdb_entry_t), SW_PARAM_PTR|SW_PARAM_IN, "Fdb Resv Entry"),

#define SW_API_FDB_RESV_DEL_DESC \
    SW_PARAM_DEF(SW_API_FDB_RESV_DEL, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_FDB_RESV_DEL, SW_FDBENTRY, sizeof(fal_fdb_entry_t), SW_PARAM_PTR|SW_PARAM_IN, "Fdb Resv Entry"),

#define SW_API_FDB_RESV_FIND_DESC \
    SW_PARAM_DEF(SW_API_FDB_RESV_FIND, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_FDB_RESV_FIND, SW_FDBENTRY, sizeof(fal_fdb_entry_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Fdb Resv Entry"),

#define SW_API_FDB_RESV_ITERATE_DESC \
    SW_PARAM_DEF(SW_API_FDB_RESV_ITERATE, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_FDB_RESV_ITERATE, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Iterator"),\
    SW_PARAM_DEF(SW_API_FDB_RESV_ITERATE, SW_FDBENTRY, sizeof(fal_fdb_entry_t), SW_PARAM_PTR|SW_PARAM_OUT, "Fdb Resv Entry"),

#define SW_API_FDB_PT_LEARN_STATIC_SET_DESC \
    SW_PARAM_DEF(SW_API_FDB_PT_LEARN_STATIC_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_FDB_PT_LEARN_STATIC_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_FDB_PT_LEARN_STATIC_SET, SW_ENABLE, 4, SW_PARAM_IN, "LearnStatic"),

#define SW_API_FDB_PT_LEARN_STATIC_GET_DESC \
    SW_PARAM_DEF(SW_API_FDB_PT_LEARN_STATIC_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_FDB_PT_LEARN_STATIC_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_FDB_PT_LEARN_STATIC_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "LearnStatic"),

#define SW_API_FDB_PORT_ADD_DESC \
    SW_PARAM_DEF(SW_API_FDB_PORT_ADD, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_FDB_PORT_ADD, SW_UINT32, 4, SW_PARAM_IN, "FID"),\
    SW_PARAM_DEF(SW_API_FDB_PORT_ADD, SW_MACADDR, sizeof(fal_mac_addr_t), SW_PARAM_PTR|SW_PARAM_IN, "Address"),\
    SW_PARAM_DEF(SW_API_FDB_PORT_ADD, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),

#define SW_API_FDB_PORT_DEL_DESC \
    SW_PARAM_DEF(SW_API_FDB_PORT_DEL, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_FDB_PORT_DEL, SW_UINT32, 4, SW_PARAM_IN, "FID"),\
    SW_PARAM_DEF(SW_API_FDB_PORT_DEL, SW_MACADDR, sizeof(fal_mac_addr_t), SW_PARAM_PTR|SW_PARAM_IN, "Address"),\
    SW_PARAM_DEF(SW_API_FDB_PORT_DEL, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),

#define SW_API_FDB_RFS_SET_DESC \
		SW_PARAM_DEF(SW_API_FDB_RFS_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
		SW_PARAM_DEF(SW_API_FDB_RFS_SET, SW_FDB_RFS, sizeof(fal_fdb_rfs_t), SW_PARAM_PTR|SW_PARAM_IN, "Fdb Rfs"),

#define SW_API_FDB_RFS_DEL_DESC \
		SW_PARAM_DEF(SW_API_FDB_RFS_DEL, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
		SW_PARAM_DEF(SW_API_FDB_RFS_DEL, SW_FDB_RFS, sizeof(fal_fdb_rfs_t), SW_PARAM_PTR|SW_PARAM_IN, "Fdb Rfs"),

#define SW_API_FDB_PT_MACLIMIT_CTRL_SET_DESC \
    SW_PARAM_DEF(SW_API_FDB_PT_MACLIMIT_CTRL_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_FDB_PT_MACLIMIT_CTRL_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_FDB_PT_MACLIMIT_CTRL_SET, SW_MACLIMIT_CTRL, sizeof(fal_maclimit_ctrl_t), SW_PARAM_PTR|SW_PARAM_IN, "MacLimit Ctrl"),

#define SW_API_FDB_PT_MACLIMIT_CTRL_GET_DESC \
    SW_PARAM_DEF(SW_API_FDB_PT_MACLIMIT_CTRL_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_FDB_PT_MACLIMIT_CTRL_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_FDB_PT_MACLIMIT_CTRL_GET, SW_MACLIMIT_CTRL, sizeof(fal_maclimit_ctrl_t), SW_PARAM_PTR|SW_PARAM_OUT, "MacLimit Ctrl"),

#define SW_API_FDB_DEL_BY_FID_DESC \
    SW_PARAM_DEF(SW_API_FDB_DEL_BY_FID, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_FDB_DEL_BY_FID, SW_UINT16, 2, SW_PARAM_IN, "FID"),\
    SW_PARAM_DEF(SW_API_FDB_DEL_BY_FID, SW_UINT32, 4, SW_PARAM_IN, "Flag"),


#define SW_API_ACL_LIST_CREAT_DESC \
    SW_PARAM_DEF(SW_API_ACL_LIST_CREAT, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_ACL_LIST_CREAT, SW_UINT32, 4, SW_PARAM_IN, "List ID"),\
    SW_PARAM_DEF(SW_API_ACL_LIST_CREAT, SW_UINT32, 4, SW_PARAM_IN, "List Priority"),

#define SW_API_ACL_LIST_DESTROY_DESC \
    SW_PARAM_DEF(SW_API_ACL_LIST_DESTROY, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_ACL_LIST_DESTROY, SW_UINT32, 4, SW_PARAM_IN, "List ID"),

#define SW_API_ACL_RULE_ADD_DESC \
    SW_PARAM_DEF(SW_API_ACL_RULE_ADD, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_ACL_RULE_ADD, SW_UINT32, 4, SW_PARAM_IN, "List ID"),\
    SW_PARAM_DEF(SW_API_ACL_RULE_ADD, SW_UINT32, 4, SW_PARAM_IN, "Rule ID"),\
    SW_PARAM_DEF(SW_API_ACL_RULE_ADD, SW_UINT32, 4, SW_PARAM_IN, "Rule Number"),\
    SW_PARAM_DEF(SW_API_ACL_RULE_ADD, SW_ACLRULE,  sizeof(fal_acl_rule_t), SW_PARAM_PTR|SW_PARAM_IN, "Rule"),

#define SW_API_ACL_RULE_DELETE_DESC \
    SW_PARAM_DEF(SW_API_ACL_RULE_DELETE, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_ACL_RULE_DELETE, SW_UINT32, 4, SW_PARAM_IN, "List ID"),\
    SW_PARAM_DEF(SW_API_ACL_RULE_DELETE, SW_UINT32, 4, SW_PARAM_IN, "Rule ID"),\
    SW_PARAM_DEF(SW_API_ACL_RULE_DELETE, SW_UINT32, 4, SW_PARAM_IN, "Rule Number"),

#define SW_API_ACL_RULE_QUERY_DESC \
    SW_PARAM_DEF(SW_API_ACL_RULE_QUERY, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_ACL_RULE_QUERY, SW_UINT32, 4, SW_PARAM_IN, "List ID"),\
    SW_PARAM_DEF(SW_API_ACL_RULE_QUERY, SW_UINT32, 4, SW_PARAM_IN, "Rule ID"),\
    SW_PARAM_DEF(SW_API_ACL_RULE_QUERY, SW_ACLRULE, sizeof(fal_acl_rule_t), SW_PARAM_PTR|SW_PARAM_OUT, "Rule"),

#define SW_API_ACL_LIST_BIND_DESC \
    SW_PARAM_DEF(SW_API_ACL_LIST_BIND, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_ACL_LIST_BIND, SW_UINT32, 4, SW_PARAM_IN, "List ID"),\
    SW_PARAM_DEF(SW_API_ACL_LIST_BIND, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_ACL_LIST_BIND, SW_UINT32, 4, SW_PARAM_IN, "List ID"),\
    SW_PARAM_DEF(SW_API_ACL_LIST_BIND, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),

#define SW_API_ACL_LIST_UNBIND_DESC \
    SW_PARAM_DEF(SW_API_ACL_LIST_UNBIND, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_ACL_LIST_UNBIND, SW_UINT32, 4, SW_PARAM_IN, "List ID"),\
    SW_PARAM_DEF(SW_API_ACL_LIST_UNBIND, SW_UINT32, 4, SW_PARAM_IN, "Direction"),\
    SW_PARAM_DEF(SW_API_ACL_LIST_UNBIND, SW_UINT32, 4, SW_PARAM_IN, "Object Type"),\
    SW_PARAM_DEF(SW_API_ACL_LIST_UNBIND, SW_UINT32, 4, SW_PARAM_IN, "Object Index"),

#define SW_API_ACL_STATUS_SET_DESC \
    SW_PARAM_DEF(SW_API_ACL_STATUS_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_ACL_STATUS_SET, SW_ENABLE, 4, SW_PARAM_IN, "Status"),

#define SW_API_ACL_STATUS_GET_DESC \
    SW_PARAM_DEF(SW_API_ACL_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_ACL_STATUS_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Status"),

#define SW_API_ACL_LIST_DUMP_DESC \
    SW_PARAM_DEF(SW_API_ACL_LIST_DUMP, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),

#define SW_API_ACL_RULE_DUMP_DESC \
    SW_PARAM_DEF(SW_API_ACL_RULE_DUMP, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),

#define SW_API_ACL_PT_UDF_PROFILE_SET_DESC \
    SW_PARAM_DEF(SW_API_ACL_PT_UDF_PROFILE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_ACL_PT_UDF_PROFILE_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_ACL_PT_UDF_PROFILE_SET, SW_ACL_UDF_TYPE, sizeof(fal_acl_udf_type_t), SW_PARAM_IN, "udf_type"),\
    SW_PARAM_DEF(SW_API_ACL_PT_UDF_PROFILE_SET, SW_UINT32, 4, SW_PARAM_IN, "udf_offset"),\
    SW_PARAM_DEF(SW_API_ACL_PT_UDF_PROFILE_SET, SW_UINT32, 4, SW_PARAM_IN, "udf_length"),

#define SW_API_ACL_PT_UDF_PROFILE_GET_DESC \
    SW_PARAM_DEF(SW_API_ACL_PT_UDF_PROFILE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_ACL_PT_UDF_PROFILE_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_ACL_PT_UDF_PROFILE_GET, SW_ACL_UDF_TYPE, sizeof(fal_acl_udf_type_t), SW_PARAM_IN, "udf_type"),\
    SW_PARAM_DEF(SW_API_ACL_PT_UDF_PROFILE_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "udf_offset"),\
    SW_PARAM_DEF(SW_API_ACL_PT_UDF_PROFILE_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "udf_length"),

#define SW_API_ACL_RULE_ACTIVE_DESC \
    SW_PARAM_DEF(SW_API_ACL_RULE_ACTIVE, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_ACL_RULE_ACTIVE, SW_UINT32, 4, SW_PARAM_IN, "List ID"),\
    SW_PARAM_DEF(SW_API_ACL_RULE_ACTIVE, SW_UINT32, 4, SW_PARAM_IN, "Rule ID"),\
    SW_PARAM_DEF(SW_API_ACL_RULE_ACTIVE, SW_UINT32, 4, SW_PARAM_IN, "Rule Number"),

#define SW_API_ACL_RULE_DEACTIVE_DESC \
    SW_PARAM_DEF(SW_API_ACL_RULE_DEACTIVE, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_ACL_RULE_DEACTIVE, SW_UINT32, 4, SW_PARAM_IN, "List ID"),\
    SW_PARAM_DEF(SW_API_ACL_RULE_DEACTIVE, SW_UINT32, 4, SW_PARAM_IN, "Rule ID"),\
    SW_PARAM_DEF(SW_API_ACL_RULE_DEACTIVE, SW_UINT32, 4, SW_PARAM_IN, "Rule Number"),

#define SW_API_ACL_RULE_SRC_FILTER_STS_SET_DESC \
    SW_PARAM_DEF(SW_API_ACL_RULE_SRC_FILTER_STS_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_ACL_RULE_SRC_FILTER_STS_SET, SW_UINT32, 4, SW_PARAM_IN, "Rule ID"),\
    SW_PARAM_DEF(SW_API_ACL_RULE_SRC_FILTER_STS_SET, SW_ENABLE, 4, SW_PARAM_IN, "Enable"),

#define SW_API_ACL_RULE_SRC_FILTER_STS_GET_DESC \
    SW_PARAM_DEF(SW_API_ACL_RULE_SRC_FILTER_STS_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_ACL_RULE_SRC_FILTER_STS_GET, SW_UINT32, 4, SW_PARAM_IN, "Rule ID"),\
    SW_PARAM_DEF(SW_API_ACL_RULE_SRC_FILTER_STS_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Enable"),

#define SW_API_ACL_UDF_SET_DESC \
    SW_PARAM_DEF(SW_API_ACL_UDF_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_ACL_UDF_SET, SW_ACL_UDF_PKT_TYPE, sizeof(fal_acl_udf_pkt_type_t), SW_PARAM_IN, "udf_packet_type"),\
    SW_PARAM_DEF(SW_API_ACL_UDF_SET, SW_UINT32, 4, SW_PARAM_IN, "udf_index"),\
    SW_PARAM_DEF(SW_API_ACL_UDF_SET, SW_ACL_UDF_TYPE, sizeof(fal_acl_udf_type_t), SW_PARAM_IN, "udf_type"),\
    SW_PARAM_DEF(SW_API_ACL_UDF_SET, SW_UINT32, 4, SW_PARAM_IN, "udf_offset"),

#define SW_API_ACL_UDF_GET_DESC \
    SW_PARAM_DEF(SW_API_ACL_UDF_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_ACL_UDF_GET, SW_ACL_UDF_PKT_TYPE, sizeof(fal_acl_udf_pkt_type_t), SW_PARAM_IN, "udf_packet_type"),\
    SW_PARAM_DEF(SW_API_ACL_UDF_GET, SW_UINT32, 4, SW_PARAM_IN, "udf_index"),\
    SW_PARAM_DEF(SW_API_ACL_UDF_GET, SW_ACL_UDF_TYPE, sizeof(fal_acl_udf_type_t), SW_PARAM_PTR|SW_PARAM_OUT, "[udf_type]:"),\
    SW_PARAM_DEF(SW_API_ACL_UDF_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "udf_offset"),

#define SW_API_ACL_UDF_PROFILE_ENTRY_ADD_DESC \
    SW_PARAM_DEF(SW_API_ACL_UDF_PROFILE_ENTRY_ADD, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_ACL_UDF_PROFILE_ENTRY_ADD, SW_UINT32, 4, SW_PARAM_IN, "Profile ID"),\
    SW_PARAM_DEF(SW_API_ACL_UDF_PROFILE_ENTRY_ADD, SW_ACL_UDF_PROFILE_ENTRY, \
        sizeof(fal_acl_udf_profile_entry_t), SW_PARAM_PTR|SW_PARAM_IN, "udf profile entry"),

#define SW_API_ACL_UDF_PROFILE_ENTRY_DEL_DESC \
    SW_PARAM_DEF(SW_API_ACL_UDF_PROFILE_ENTRY_DEL, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_ACL_UDF_PROFILE_ENTRY_DEL, SW_UINT32, 4, SW_PARAM_IN, "Profile ID"),\
    SW_PARAM_DEF(SW_API_ACL_UDF_PROFILE_ENTRY_DEL, SW_ACL_UDF_PROFILE_ENTRY, \
        sizeof(fal_acl_udf_profile_entry_t), SW_PARAM_PTR|SW_PARAM_IN, "udf profile entry"),

#define SW_API_ACL_UDF_PROFILE_ENTRY_GETFIRST_DESC \
    SW_PARAM_DEF(SW_API_ACL_UDF_PROFILE_ENTRY_GETFIRST, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_ACL_UDF_PROFILE_ENTRY_GETFIRST, SW_UINT32, 4, SW_PARAM_IN, "Profile ID"),\
    SW_PARAM_DEF(SW_API_ACL_UDF_PROFILE_ENTRY_GETFIRST, SW_ACL_UDF_PROFILE_ENTRY, \
        sizeof(fal_acl_udf_profile_entry_t), SW_PARAM_PTR|SW_PARAM_OUT, "udf profile entry"),

#define SW_API_ACL_UDF_PROFILE_ENTRY_GETNEXT_DESC \
    SW_PARAM_DEF(SW_API_ACL_UDF_PROFILE_ENTRY_GETNEXT, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_ACL_UDF_PROFILE_ENTRY_GETNEXT, SW_UINT32, 4, SW_PARAM_IN, "Profile ID"),\
    SW_PARAM_DEF(SW_API_ACL_UDF_PROFILE_ENTRY_GETNEXT, SW_ACL_UDF_PROFILE_ENTRY, \
        sizeof(fal_acl_udf_profile_entry_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, \
        "udf profile entry"),

#define SW_API_ACL_UDF_PROFILE_CFG_SET_DESC \
    SW_PARAM_DEF(SW_API_ACL_UDF_PROFILE_CFG_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_ACL_UDF_PROFILE_CFG_SET, SW_UINT32, 4, SW_PARAM_IN, "udf_profile"),\
    SW_PARAM_DEF(SW_API_ACL_UDF_PROFILE_CFG_SET, SW_UINT32, 4, SW_PARAM_IN, "udf_index"),\
    SW_PARAM_DEF(SW_API_ACL_UDF_PROFILE_CFG_SET, SW_ACL_UDF_TYPE, \
        sizeof(fal_acl_udf_type_t), SW_PARAM_IN, "udf_type"),\
    SW_PARAM_DEF(SW_API_ACL_UDF_PROFILE_CFG_SET, SW_UINT32, 4, SW_PARAM_IN, "udf_offset"),

#define SW_API_ACL_UDF_PROFILE_CFG_GET_DESC \
    SW_PARAM_DEF(SW_API_ACL_UDF_PROFILE_CFG_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_ACL_UDF_PROFILE_CFG_GET, SW_UINT32, 4, SW_PARAM_IN, "udf_profile"),\
    SW_PARAM_DEF(SW_API_ACL_UDF_PROFILE_CFG_GET, SW_UINT32, 4, SW_PARAM_IN, "udf_index"),\
    SW_PARAM_DEF(SW_API_ACL_UDF_PROFILE_CFG_GET, SW_ACL_UDF_TYPE, \
        sizeof(fal_acl_udf_type_t), SW_PARAM_PTR|SW_PARAM_OUT, "[udf_type]:"),\
    SW_PARAM_DEF(SW_API_ACL_UDF_PROFILE_CFG_GET, SW_UINT32, 4, \
        SW_PARAM_PTR|SW_PARAM_OUT, "udf_offset"),

#define SW_API_ACL_VPGROUP_SET_DESC \
    SW_PARAM_DEF(SW_API_ACL_VPGROUP_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_ACL_VPGROUP_SET, SW_UINT32, \
        sizeof(a_uint32_t), SW_PARAM_IN, "vport_id"), \
    SW_PARAM_DEF(SW_API_ACL_VPGROUP_SET, SW_VPORT_TYPE, \
        sizeof(fal_vport_type_t), SW_PARAM_IN, "vport_type "),\
    SW_PARAM_DEF(SW_API_ACL_VPGROUP_SET, SW_UINT32, \
        sizeof(a_uint32_t), SW_PARAM_IN, "vpgroup_id"),

#define SW_API_ACL_VPGROUP_GET_DESC \
    SW_PARAM_DEF(SW_API_ACL_VPGROUP_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_ACL_VPGROUP_GET, SW_UINT32, \
        sizeof(a_uint32_t), SW_PARAM_IN, "vport_id"), \
    SW_PARAM_DEF(SW_API_ACL_VPGROUP_GET, SW_VPORT_TYPE, \
        sizeof(fal_vport_type_t), SW_PARAM_IN, "vport_type "),\
    SW_PARAM_DEF(SW_API_ACL_VPGROUP_GET, SW_UINT32, \
        sizeof(a_uint32_t), SW_PARAM_PTR|SW_PARAM_OUT, "vpgroup_id"),

#define SW_API_ACL_MAC_ENTRY_SET_DESC \
    SW_PARAM_DEF(SW_API_ACL_MAC_ENTRY_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_ACL_MAC_ENTRY_SET, SW_ACL_MAC_ENTRY, \
        sizeof(fal_acl_mac_entry_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "entry"),

#define SW_API_ACL_MAC_ENTRY_DUMP_DESC \
    SW_PARAM_DEF(SW_API_ACL_MAC_ENTRY_DUMP, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),

#define SW_API_QOS_SCH_MODE_SET_DESC \
    SW_PARAM_DEF(SW_API_QOS_SCH_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_SCH_MODE_SET, SW_SCH, sizeof(fal_sch_mode_t), SW_PARAM_IN, "Schedule mode"),\
    SW_PARAM_DEF(SW_API_QOS_SCH_MODE_SET, SW_UINT_A, 16, SW_PARAM_PTR|SW_PARAM_IN, "Weight"),

#define SW_API_QOS_SCH_MODE_GET_DESC \
    SW_PARAM_DEF(SW_API_QOS_SCH_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_SCH_MODE_GET, SW_SCH, sizeof(fal_sch_mode_t), SW_PARAM_PTR|SW_PARAM_OUT, "Schedule mode"),\
    SW_PARAM_DEF(SW_API_QOS_SCH_MODE_GET, SW_UINT_A, 16, SW_PARAM_PTR|SW_PARAM_OUT, "Weight"),

#define SW_API_QOS_QU_TX_BUF_ST_SET_DESC \
    SW_PARAM_DEF(SW_API_QOS_QU_TX_BUF_ST_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_QU_TX_BUF_ST_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_QOS_QU_TX_BUF_ST_SET, SW_ENABLE, 4, SW_PARAM_IN, "Buffer limit"),

#define SW_API_QOS_QU_TX_BUF_ST_GET_DESC \
    SW_PARAM_DEF(SW_API_QOS_QU_TX_BUF_ST_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_QU_TX_BUF_ST_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_QOS_QU_TX_BUF_ST_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Buffer limit"),

#define SW_API_QOS_QU_TX_BUF_NR_SET_DESC \
    SW_PARAM_DEF(SW_API_QOS_QU_TX_BUF_NR_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_QU_TX_BUF_NR_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_QOS_QU_TX_BUF_NR_SET, SW_UINT32, 4, SW_PARAM_IN, "Queue ID"),\
    SW_PARAM_DEF(SW_API_QOS_QU_TX_BUF_NR_SET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Buffer Number"),

#define SW_API_QOS_QU_TX_BUF_NR_GET_DESC \
    SW_PARAM_DEF(SW_API_QOS_QU_TX_BUF_NR_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_QU_TX_BUF_NR_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_QOS_QU_TX_BUF_NR_GET, SW_UINT32, 4, SW_PARAM_IN, "Queue ID"),\
    SW_PARAM_DEF(SW_API_QOS_QU_TX_BUF_NR_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Buffer Number"),

#define SW_API_QOS_PT_TX_BUF_ST_SET_DESC \
    SW_PARAM_DEF(SW_API_QOS_PT_TX_BUF_ST_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_PT_TX_BUF_ST_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_QOS_PT_TX_BUF_ST_SET, SW_ENABLE, 4, SW_PARAM_IN, "Buffer limit"),

#define SW_API_QOS_PT_TX_BUF_ST_GET_DESC \
    SW_PARAM_DEF(SW_API_QOS_PT_TX_BUF_ST_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_PT_TX_BUF_ST_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_QOS_PT_TX_BUF_ST_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Buffer limit"),

#define SW_API_QOS_PT_RED_EN_SET_DESC \
    SW_PARAM_DEF(SW_API_QOS_PT_RED_EN_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_PT_RED_EN_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_QOS_PT_RED_EN_SET, SW_ENABLE, 4, SW_PARAM_IN, "enable"),

#define SW_API_QOS_PT_RED_EN_GET_DESC \
    SW_PARAM_DEF(SW_API_QOS_PT_RED_EN_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_PT_RED_EN_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_QOS_PT_RED_EN_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "enable"),

#define SW_API_QOS_PT_TX_BUF_NR_SET_DESC \
    SW_PARAM_DEF(SW_API_QOS_PT_TX_BUF_NR_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_PT_TX_BUF_NR_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_QOS_PT_TX_BUF_NR_SET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Buffer Number"),

#define SW_API_QOS_PT_TX_BUF_NR_GET_DESC \
    SW_PARAM_DEF(SW_API_QOS_PT_TX_BUF_NR_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_PT_TX_BUF_NR_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_QOS_PT_TX_BUF_NR_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Buffer Number"),

#define SW_API_QOS_PT_RX_BUF_NR_SET_DESC \
    SW_PARAM_DEF(SW_API_QOS_PT_RX_BUF_NR_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_PT_RX_BUF_NR_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_QOS_PT_RX_BUF_NR_SET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Buffer Number"),

#define SW_API_QOS_PT_RX_BUF_NR_GET_DESC \
    SW_PARAM_DEF(SW_API_QOS_PT_RX_BUF_NR_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_PT_RX_BUF_NR_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_QOS_PT_RX_BUF_NR_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Buffer Number"),

#define SW_API_COSMAP_UP_QU_SET_DESC \
    SW_PARAM_DEF(SW_API_COSMAP_UP_QU_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_COSMAP_UP_QU_SET, SW_UINT32, 4, SW_PARAM_IN, "Dot1p"),\
    SW_PARAM_DEF(SW_API_COSMAP_UP_QU_SET, SW_UINT32, 4, SW_PARAM_IN, "Queue"),

#define SW_API_COSMAP_UP_QU_GET_DESC \
    SW_PARAM_DEF(SW_API_COSMAP_UP_QU_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_COSMAP_UP_QU_GET, SW_UINT32, 4, SW_PARAM_IN, "Dot1p"),\
    SW_PARAM_DEF(SW_API_COSMAP_UP_QU_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Queue"),

#define SW_API_COSMAP_DSCP_QU_SET_DESC \
    SW_PARAM_DEF(SW_API_COSMAP_DSCP_QU_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_COSMAP_DSCP_QU_SET, SW_UINT32, 4, SW_PARAM_IN, "DSCP"),\
    SW_PARAM_DEF(SW_API_COSMAP_DSCP_QU_SET, SW_UINT32, 4, SW_PARAM_IN, "Queue"),

#define SW_API_COSMAP_DSCP_QU_GET_DESC \
    SW_PARAM_DEF(SW_API_COSMAP_DSCP_QU_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_COSMAP_DSCP_QU_GET, SW_UINT32, 4, SW_PARAM_IN, "DSCP"),\
    SW_PARAM_DEF(SW_API_COSMAP_DSCP_QU_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Queue"),

#define SW_API_QOS_PT_MODE_SET_DESC \
    SW_PARAM_DEF(SW_API_QOS_PT_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_PT_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_QOS_PT_MODE_SET, SW_QOS, sizeof(fal_qos_mode_t), SW_PARAM_IN, "Qos mode"),\
    SW_PARAM_DEF(SW_API_QOS_PT_MODE_SET, SW_ENABLE, 4, SW_PARAM_IN, "Enable"),

#define SW_API_QOS_PT_MODE_GET_DESC \
    SW_PARAM_DEF(SW_API_QOS_PT_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_PT_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_QOS_PT_MODE_GET, SW_QOS, sizeof(fal_qos_mode_t), SW_PARAM_IN, "Qos mode"),\
    SW_PARAM_DEF(SW_API_QOS_PT_MODE_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Enable"),

#define SW_API_QOS_PT_MODE_PRI_SET_DESC \
    SW_PARAM_DEF(SW_API_QOS_PT_MODE_PRI_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_PT_MODE_PRI_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_QOS_PT_MODE_PRI_SET, SW_QOS, sizeof(fal_qos_mode_t), SW_PARAM_IN, "Qos mode"),\
    SW_PARAM_DEF(SW_API_QOS_PT_MODE_PRI_SET, SW_UINT32, 4, SW_PARAM_IN, "Priority"),

#define SW_API_QOS_PT_MODE_PRI_GET_DESC \
    SW_PARAM_DEF(SW_API_QOS_PT_MODE_PRI_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_PT_MODE_PRI_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_QOS_PT_MODE_PRI_GET, SW_QOS, sizeof(fal_qos_mode_t), SW_PARAM_IN, "Qos mode"),\
    SW_PARAM_DEF(SW_API_QOS_PT_MODE_PRI_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Priority"),

#define SW_API_QOS_PORT_DEF_UP_SET_DESC \
    SW_PARAM_DEF(SW_API_QOS_PORT_DEF_UP_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_PORT_DEF_UP_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_QOS_PORT_DEF_UP_SET, SW_UINT32, 4, SW_PARAM_IN, "default up"),

#define SW_API_QOS_PORT_DEF_UP_GET_DESC \
    SW_PARAM_DEF(SW_API_QOS_PORT_DEF_UP_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_PORT_DEF_UP_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_QOS_PORT_DEF_UP_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "default up"),

#define SW_API_QOS_PORT_SCH_MODE_SET_DESC \
    SW_PARAM_DEF(SW_API_QOS_PORT_SCH_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_PORT_SCH_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_QOS_PORT_SCH_MODE_SET, SW_SCH, sizeof(fal_sch_mode_t), SW_PARAM_IN, "Schedule mode"),\
    SW_PARAM_DEF(SW_API_QOS_PORT_SCH_MODE_SET, SW_UINT_A, 24, SW_PARAM_PTR|SW_PARAM_IN, "Weight"),

#define SW_API_QOS_PORT_SCH_MODE_GET_DESC \
    SW_PARAM_DEF(SW_API_QOS_PORT_SCH_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_PORT_SCH_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_QOS_PORT_SCH_MODE_GET, SW_SCH, sizeof(fal_sch_mode_t), SW_PARAM_PTR|SW_PARAM_OUT, "Schedule mode"),\
    SW_PARAM_DEF(SW_API_QOS_PORT_SCH_MODE_GET, SW_UINT_A, 24, SW_PARAM_PTR|SW_PARAM_OUT, "Weight"),

#define SW_API_QOS_PT_DEF_SPRI_SET_DESC \
    SW_PARAM_DEF(SW_API_QOS_PT_DEF_SPRI_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_PT_DEF_SPRI_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_QOS_PT_DEF_SPRI_SET, SW_UINT32, 4, SW_PARAM_IN, "default spri"),

#define SW_API_QOS_PT_DEF_SPRI_GET_DESC \
    SW_PARAM_DEF(SW_API_QOS_PT_DEF_SPRI_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_PT_DEF_SPRI_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_QOS_PT_DEF_SPRI_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "default spri"),

#define SW_API_QOS_PT_DEF_CPRI_SET_DESC \
    SW_PARAM_DEF(SW_API_QOS_PT_DEF_CPRI_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_PT_DEF_CPRI_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_QOS_PT_DEF_CPRI_SET, SW_UINT32, 4, SW_PARAM_IN, "default cpri"),


#define SW_API_QOS_PT_FORCE_SPRI_ST_SET_DESC \
    SW_PARAM_DEF(SW_API_QOS_PT_FORCE_SPRI_ST_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_PT_FORCE_SPRI_ST_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_QOS_PT_FORCE_SPRI_ST_SET, SW_ENABLE, 4, SW_PARAM_IN, "Enable"),

#define SW_API_QOS_PT_FORCE_SPRI_ST_GET_DESC \
    SW_PARAM_DEF(SW_API_QOS_PT_FORCE_SPRI_ST_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_PT_FORCE_SPRI_ST_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_QOS_PT_FORCE_SPRI_ST_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Enable"),

#define SW_API_QOS_PT_FORCE_CPRI_ST_SET_DESC \
    SW_PARAM_DEF(SW_API_QOS_PT_FORCE_CPRI_ST_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_PT_FORCE_CPRI_ST_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_QOS_PT_FORCE_CPRI_ST_SET, SW_ENABLE, 4, SW_PARAM_IN, "Enable"),

#define SW_API_QOS_PT_FORCE_CPRI_ST_GET_DESC \
    SW_PARAM_DEF(SW_API_QOS_PT_FORCE_CPRI_ST_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_PT_FORCE_CPRI_ST_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_QOS_PT_FORCE_CPRI_ST_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Enable"),



#define SW_API_QOS_PT_DEF_CPRI_GET_DESC \
    SW_PARAM_DEF(SW_API_QOS_PT_DEF_CPRI_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_PT_DEF_CPRI_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_QOS_PT_DEF_CPRI_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "default cpri"),


#define SW_API_QOS_QUEUE_REMARK_SET_DESC \
    SW_PARAM_DEF(SW_API_QOS_QUEUE_REMARK_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_QUEUE_REMARK_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_QOS_QUEUE_REMARK_SET, SW_UINT32, 4, SW_PARAM_IN, "Queue ID"),\
    SW_PARAM_DEF(SW_API_QOS_QUEUE_REMARK_SET, SW_UINT32, 4, SW_PARAM_IN, "Table ID"), \
    SW_PARAM_DEF(SW_API_QOS_QUEUE_REMARK_SET, SW_ENABLE, 4, SW_PARAM_IN, "Enable"),

#define SW_API_QOS_QUEUE_REMARK_GET_DESC \
    SW_PARAM_DEF(SW_API_QOS_QUEUE_REMARK_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_QUEUE_REMARK_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_QOS_QUEUE_REMARK_GET, SW_UINT32, 4, SW_PARAM_IN, "Queue ID"),\
    SW_PARAM_DEF(SW_API_QOS_QUEUE_REMARK_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Table ID"), \
    SW_PARAM_DEF(SW_API_QOS_QUEUE_REMARK_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Enable"),

#define SW_API_QOS_PORT_GROUP_SET_DESC \
    SW_PARAM_DEF(SW_API_QOS_PORT_GROUP_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_PORT_GROUP_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_QOS_PORT_GROUP_SET, SW_PORTGROUP, sizeof(fal_qos_group_t), SW_PARAM_PTR|SW_PARAM_IN, "PortGroup"),

#define SW_API_QOS_PORT_GROUP_GET_DESC \
    SW_PARAM_DEF(SW_API_QOS_PORT_GROUP_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_PORT_GROUP_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_QOS_PORT_GROUP_GET, SW_PORTGROUP, sizeof(fal_qos_group_t), SW_PARAM_PTR|SW_PARAM_OUT, "PortGroup"),

#define SW_API_QOS_PORT_PRI_SET_DESC \
    SW_PARAM_DEF(SW_API_QOS_PORT_PRI_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_PORT_PRI_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_QOS_PORT_PRI_SET, SW_PORTPRI, sizeof(fal_qos_pri_precedence_t), SW_PARAM_PTR|SW_PARAM_IN, "PortPri"),

#define SW_API_QOS_PORT_PRI_GET_DESC \
    SW_PARAM_DEF(SW_API_QOS_PORT_PRI_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_PORT_PRI_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_QOS_PORT_PRI_GET, SW_PORTPRI, sizeof(fal_qos_pri_precedence_t), SW_PARAM_PTR|SW_PARAM_OUT, "PortPri"),

#define SW_API_QOS_PORT_REMARK_SET_DESC \
    SW_PARAM_DEF(SW_API_QOS_PORT_REMARK_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_PORT_REMARK_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_QOS_PORT_REMARK_SET, SW_PORTREMARK, sizeof(fal_qos_remark_enable_t), SW_PARAM_PTR|SW_PARAM_IN, "PortRemark"),

#define SW_API_QOS_PORT_REMARK_GET_DESC \
    SW_PARAM_DEF(SW_API_QOS_PORT_REMARK_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_PORT_REMARK_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_QOS_PORT_REMARK_GET, SW_PORTREMARK, sizeof(fal_qos_remark_enable_t), SW_PARAM_PTR|SW_PARAM_OUT, "PortRemark"),

#define SW_API_QOS_PCP_MAP_SET_DESC \
    SW_PARAM_DEF(SW_API_QOS_PCP_MAP_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_PCP_MAP_SET, SW_UINT32, 4, SW_PARAM_IN, "Group ID"),\
    SW_PARAM_DEF(SW_API_QOS_PCP_MAP_SET, SW_UINT32, 4, SW_PARAM_IN, "PCP"),\
    SW_PARAM_DEF(SW_API_QOS_PCP_MAP_SET, SW_COSMAP, sizeof(fal_qos_cosmap_t), SW_PARAM_PTR|SW_PARAM_IN, "Cosmap"),

#define SW_API_QOS_PCP_MAP_GET_DESC \
    SW_PARAM_DEF(SW_API_QOS_PCP_MAP_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_PCP_MAP_GET, SW_UINT32, 4, SW_PARAM_IN, "Group ID"),\
    SW_PARAM_DEF(SW_API_QOS_PCP_MAP_GET, SW_UINT32, 4, SW_PARAM_IN, "PCP"),\
    SW_PARAM_DEF(SW_API_QOS_PCP_MAP_GET, SW_COSMAP, sizeof(fal_qos_cosmap_t), SW_PARAM_PTR|SW_PARAM_OUT, "Cosmap"),

#define SW_API_QOS_FLOW_MAP_SET_DESC \
    SW_PARAM_DEF(SW_API_QOS_FLOW_MAP_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_FLOW_MAP_SET, SW_UINT32, 4, SW_PARAM_IN, "Group ID"),\
    SW_PARAM_DEF(SW_API_QOS_FLOW_MAP_SET, SW_UINT32, 4, SW_PARAM_IN, "Flow"),\
    SW_PARAM_DEF(SW_API_QOS_FLOW_MAP_SET, SW_COSMAP, sizeof(fal_qos_cosmap_t), SW_PARAM_PTR|SW_PARAM_IN, "Cosmap"),

#define SW_API_QOS_FLOW_MAP_GET_DESC \
    SW_PARAM_DEF(SW_API_QOS_FLOW_MAP_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_FLOW_MAP_GET, SW_UINT32, 4, SW_PARAM_IN, "Group ID"),\
    SW_PARAM_DEF(SW_API_QOS_FLOW_MAP_GET, SW_UINT32, 4, SW_PARAM_IN, "Flow"),\
    SW_PARAM_DEF(SW_API_QOS_FLOW_MAP_GET, SW_COSMAP, sizeof(fal_qos_cosmap_t), SW_PARAM_PTR|SW_PARAM_OUT, "Cosmap"),

#define SW_API_QOS_DSCP_MAP_SET_DESC \
    SW_PARAM_DEF(SW_API_QOS_DSCP_MAP_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_DSCP_MAP_SET, SW_UINT32, 4, SW_PARAM_IN, "Group ID"),\
    SW_PARAM_DEF(SW_API_QOS_DSCP_MAP_SET, SW_UINT32, 4, SW_PARAM_IN, "Dscp"),\
    SW_PARAM_DEF(SW_API_QOS_DSCP_MAP_SET, SW_COSMAP, sizeof(fal_qos_cosmap_t), SW_PARAM_PTR|SW_PARAM_IN, "Cosmap"),

#define SW_API_QOS_DSCP_MAP_GET_DESC \
    SW_PARAM_DEF(SW_API_QOS_DSCP_MAP_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_DSCP_MAP_GET, SW_UINT32, 4, SW_PARAM_IN, "Group ID"),\
    SW_PARAM_DEF(SW_API_QOS_DSCP_MAP_GET, SW_UINT32, 4, SW_PARAM_IN, "Dscp"),\
    SW_PARAM_DEF(SW_API_QOS_DSCP_MAP_GET, SW_COSMAP, sizeof(fal_qos_cosmap_t), SW_PARAM_PTR|SW_PARAM_OUT, "Cosmap"),

#define SW_API_QOS_QUEUE_SCHEDULER_SET_DESC \
    SW_PARAM_DEF(SW_API_QOS_QUEUE_SCHEDULER_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_QUEUE_SCHEDULER_SET, SW_UINT32, 4, SW_PARAM_IN, "Node ID"),\
    SW_PARAM_DEF(SW_API_QOS_QUEUE_SCHEDULER_SET, SW_UINT32, 4, SW_PARAM_IN, "Level"),\
    SW_PARAM_DEF(SW_API_QOS_QUEUE_SCHEDULER_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_QOS_QUEUE_SCHEDULER_SET, SW_SCHEDULER, sizeof(fal_qos_scheduler_cfg_t), SW_PARAM_PTR|SW_PARAM_IN, "Scheduler"),

#define SW_API_QOS_QUEUE_SCHEDULER_GET_DESC \
    SW_PARAM_DEF(SW_API_QOS_QUEUE_SCHEDULER_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_QUEUE_SCHEDULER_GET, SW_UINT32, 4, SW_PARAM_IN, "Node ID"),\
    SW_PARAM_DEF(SW_API_QOS_QUEUE_SCHEDULER_GET, SW_UINT32, 4, SW_PARAM_IN, "Level"),\
    SW_PARAM_DEF(SW_API_QOS_QUEUE_SCHEDULER_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Port ID"),\
    SW_PARAM_DEF(SW_API_QOS_QUEUE_SCHEDULER_GET, SW_SCHEDULER, sizeof(fal_qos_scheduler_cfg_t), SW_PARAM_PTR|SW_PARAM_OUT, "Scheduler"),

#define SW_API_QOS_RING_QUEUE_MAP_SET_DESC \
    SW_PARAM_DEF(SW_API_QOS_RING_QUEUE_MAP_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_RING_QUEUE_MAP_SET, SW_UINT32, 4, SW_PARAM_IN, "Ring ID"),\
    SW_PARAM_DEF(SW_API_QOS_RING_QUEUE_MAP_SET, SW_QUEUEBMP, sizeof(fal_queue_bmp_t), SW_PARAM_PTR|SW_PARAM_IN, "Queue bmp"),

#define SW_API_QOS_RING_QUEUE_MAP_GET_DESC \
    SW_PARAM_DEF(SW_API_QOS_RING_QUEUE_MAP_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_RING_QUEUE_MAP_GET, SW_UINT32, 4, SW_PARAM_IN, "Ring ID"),\
    SW_PARAM_DEF(SW_API_QOS_RING_QUEUE_MAP_GET, SW_QUEUEBMP, sizeof(fal_queue_bmp_t), SW_PARAM_PTR|SW_PARAM_OUT, "Queue bmp"),

#define SW_API_QOS_PORT_QUEUES_GET_DESC \
    SW_PARAM_DEF(SW_API_QOS_PORT_QUEUES_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_PORT_QUEUES_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_QOS_PORT_QUEUES_GET, SW_QUEUEBMP, sizeof(fal_queue_bmp_t), SW_PARAM_PTR|SW_PARAM_OUT, "Queue bmp"),

#define SW_API_QOS_PORT_SCHEDULER_CFG_RESET_DESC \
    SW_PARAM_DEF(SW_API_QOS_PORT_SCHEDULER_CFG_RESET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_QOS_PORT_SCHEDULER_CFG_RESET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),

#define SW_API_QOS_SCHEDULER_DEQUEU_CTRL_SET_DESC \
    SW_PARAM_DEF(SW_API_QOS_SCHEDULER_DEQUEU_CTRL_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_QOS_SCHEDULER_DEQUEU_CTRL_SET, SW_UINT32, 4, SW_PARAM_IN, "queue ID"), \
    SW_PARAM_DEF(SW_API_QOS_SCHEDULER_DEQUEU_CTRL_SET, SW_ENABLE, sizeof(a_bool_t), SW_PARAM_IN, "dequeue en"),

#define SW_API_QOS_SCHEDULER_DEQUEU_CTRL_GET_DESC \
    SW_PARAM_DEF(SW_API_QOS_SCHEDULER_DEQUEU_CTRL_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_QOS_SCHEDULER_DEQUEU_CTRL_GET, SW_UINT32, 4, SW_PARAM_IN, "queue ID"), \
    SW_PARAM_DEF(SW_API_QOS_SCHEDULER_DEQUEU_CTRL_GET, SW_ENABLE, sizeof(a_bool_t), SW_PARAM_PTR|SW_PARAM_OUT, "dequeue en"),

#define SW_API_QOS_PORT_SCHEDULER_RESOURCE_GET_DESC \
    SW_PARAM_DEF(SW_API_QOS_PORT_SCHEDULER_RESOURCE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_QOS_PORT_SCHEDULER_RESOURCE_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_QOS_PORT_SCHEDULER_RESOURCE_GET, SW_RESOURCE_SCHE, sizeof(fal_portscheduler_resource_t), SW_PARAM_PTR|SW_PARAM_OUT, "scheduler resource"),

#define SW_API_PT_IGMPS_MODE_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_IGMPS_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_PT_IGMPS_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Port No."), \
    SW_PARAM_DEF(SW_API_PT_IGMPS_MODE_SET, SW_ENABLE, 4, SW_PARAM_IN, "IGMP snooping"),

#define SW_API_PT_IGMPS_MODE_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_IGMPS_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_IGMPS_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Port No."), \
    SW_PARAM_DEF(SW_API_PT_IGMPS_MODE_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "IGMP snooping"),

#define SW_API_IGMP_MLD_CMD_SET_DESC \
    SW_PARAM_DEF(SW_API_IGMP_MLD_CMD_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_IGMP_MLD_CMD_SET, SW_MACCMD, sizeof(fal_fwd_cmd_t), SW_PARAM_IN, "cmd"),

#define SW_API_IGMP_MLD_CMD_GET_DESC \
    SW_PARAM_DEF(SW_API_IGMP_MLD_CMD_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_IGMP_MLD_CMD_GET, SW_MACCMD, sizeof(fal_fwd_cmd_t), SW_PARAM_PTR|SW_PARAM_OUT, "cmd"),

#define SW_API_IGMP_PT_JOIN_SET_DESC \
    SW_PARAM_DEF(SW_API_IGMP_PT_JOIN_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_IGMP_PT_JOIN_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_IGMP_PT_JOIN_SET, SW_ENABLE, 4, SW_PARAM_IN, "Join"),

#define SW_API_IGMP_PT_JOIN_GET_DESC \
    SW_PARAM_DEF(SW_API_IGMP_PT_JOIN_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_IGMP_PT_JOIN_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_IGMP_PT_JOIN_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Join"),

#define SW_API_IGMP_PT_LEAVE_SET_DESC \
    SW_PARAM_DEF(SW_API_IGMP_PT_LEAVE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_IGMP_PT_LEAVE_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_IGMP_PT_LEAVE_SET, SW_ENABLE, 4, SW_PARAM_IN, "Leave"),

#define SW_API_IGMP_PT_LEAVE_GET_DESC \
    SW_PARAM_DEF(SW_API_IGMP_PT_LEAVE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_IGMP_PT_LEAVE_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_IGMP_PT_LEAVE_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Leave"),

#define SW_API_IGMP_RP_SET_DESC \
    SW_PARAM_DEF(SW_API_IGMP_RP_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_IGMP_RP_SET, SW_PBMP, sizeof(fal_pbmp_t), SW_PARAM_IN, "Ports"),

#define SW_API_IGMP_RP_GET_DESC \
    SW_PARAM_DEF(SW_API_IGMP_RP_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_IGMP_RP_GET, SW_PBMP, sizeof(fal_pbmp_t), SW_PARAM_PTR|SW_PARAM_OUT, "Ports"),

#define SW_API_IGMP_ENTRY_CREAT_SET_DESC \
    SW_PARAM_DEF(SW_API_IGMP_ENTRY_CREAT_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_IGMP_ENTRY_CREAT_SET, SW_ENABLE, 4, SW_PARAM_IN, "creat Entry"),

#define SW_API_IGMP_ENTRY_CREAT_GET_DESC \
    SW_PARAM_DEF(SW_API_IGMP_ENTRY_CREAT_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_IGMP_ENTRY_CREAT_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "creat Entry"),

#define SW_API_IGMP_ENTRY_STATIC_SET_DESC \
    SW_PARAM_DEF(SW_API_IGMP_ENTRY_STATIC_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_IGMP_ENTRY_STATIC_SET, SW_ENABLE, 4, SW_PARAM_IN, "static"),

#define SW_API_IGMP_ENTRY_STATIC_GET_DESC \
    SW_PARAM_DEF(SW_API_IGMP_ENTRY_STATIC_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_IGMP_ENTRY_STATIC_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "static"),

#define SW_API_IGMP_ENTRY_LEAKY_SET_DESC \
    SW_PARAM_DEF(SW_API_IGMP_ENTRY_LEAKY_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_IGMP_ENTRY_LEAKY_SET, SW_ENABLE, 4, SW_PARAM_IN, "leaky"),

#define SW_API_IGMP_ENTRY_LEAKY_GET_DESC \
    SW_PARAM_DEF(SW_API_IGMP_ENTRY_LEAKY_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_IGMP_ENTRY_LEAKY_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "leaky"),

#define SW_API_IGMP_ENTRY_V3_SET_DESC \
    SW_PARAM_DEF(SW_API_IGMP_ENTRY_V3_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_IGMP_ENTRY_V3_SET, SW_ENABLE, 4, SW_PARAM_IN, "version3"),

#define SW_API_IGMP_ENTRY_V3_GET_DESC \
    SW_PARAM_DEF(SW_API_IGMP_ENTRY_V3_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_IGMP_ENTRY_V3_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "version3"),

#define SW_API_IGMP_ENTRY_QUEUE_SET_DESC \
    SW_PARAM_DEF(SW_API_IGMP_ENTRY_QUEUE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_IGMP_ENTRY_QUEUE_SET, SW_ENABLE, 4, SW_PARAM_IN, "queue"), \
    SW_PARAM_DEF(SW_API_IGMP_ENTRY_QUEUE_SET, SW_UINT32, 4, SW_PARAM_IN, "queue_id"),

#define SW_API_IGMP_ENTRY_QUEUE_GET_DESC \
    SW_PARAM_DEF(SW_API_IGMP_ENTRY_QUEUE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_IGMP_ENTRY_QUEUE_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "queue"), \
    SW_PARAM_DEF(SW_API_IGMP_ENTRY_QUEUE_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "queue_id"),

#define SW_API_PT_IGMP_LEARN_LIMIT_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_IGMP_LEARN_LIMIT_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_IGMP_LEARN_LIMIT_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_PT_IGMP_LEARN_LIMIT_SET, SW_ENABLE, 4, SW_PARAM_IN, "Enable"), \
    SW_PARAM_DEF(SW_API_PT_IGMP_LEARN_LIMIT_SET, SW_UINT32, 4, SW_PARAM_IN, "LimitCnt"),

#define SW_API_PT_IGMP_LEARN_LIMIT_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_IGMP_LEARN_LIMIT_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_PT_IGMP_LEARN_LIMIT_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_PT_IGMP_LEARN_LIMIT_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Enable"), \
    SW_PARAM_DEF(SW_API_PT_IGMP_LEARN_LIMIT_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "LimitCnt"),

#define SW_API_PT_IGMP_LEARN_EXCEED_CMD_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_IGMP_LEARN_EXCEED_CMD_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_IGMP_LEARN_EXCEED_CMD_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_PT_IGMP_LEARN_EXCEED_CMD_SET, SW_MACCMD, sizeof(fal_fwd_cmd_t), SW_PARAM_IN, "cmd"),

#define SW_API_PT_IGMP_LEARN_EXCEED_CMD_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_IGMP_LEARN_EXCEED_CMD_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_IGMP_LEARN_EXCEED_CMD_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_PT_IGMP_LEARN_EXCEED_CMD_GET, SW_MACCMD, sizeof(fal_fwd_cmd_t), SW_PARAM_PTR|SW_PARAM_OUT, "cmd"),

#define SW_API_IGMP_SG_ENTRY_SET_DESC \
    SW_PARAM_DEF(SW_API_IGMP_SG_ENTRY_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_IGMP_SG_ENTRY_SET, SW_SGENTRY, sizeof(fal_igmp_sg_entry_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "entry"),

#define SW_API_IGMP_SG_ENTRY_CLEAR_DESC \
    SW_PARAM_DEF(SW_API_IGMP_SG_ENTRY_CLEAR, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_IGMP_SG_ENTRY_CLEAR, SW_SGENTRY, sizeof(fal_igmp_sg_entry_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "entry"),

#define SW_API_IGMP_SG_ENTRY_SHOW_DESC \
    SW_PARAM_DEF(SW_API_IGMP_SG_ENTRY_SHOW, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),

#define SW_API_IGMP_SG_ENTRY_QUERY_DESC \
    SW_PARAM_DEF(SW_API_IGMP_SG_ENTRY_QUERY, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_IGMP_SG_ENTRY_QUERY, SW_SGINFOENTRY, sizeof(fal_igmp_sg_info_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "info"),


#define SW_API_UC_LEAKY_MODE_SET_DESC \
    SW_PARAM_DEF(SW_API_UC_LEAKY_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_UC_LEAKY_MODE_SET, SW_LEAKY, sizeof(fal_leaky_ctrl_mode_t), SW_PARAM_IN, "Uc Leaky mode"),

#define SW_API_UC_LEAKY_MODE_GET_DESC \
    SW_PARAM_DEF(SW_API_UC_LEAKY_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_UC_LEAKY_MODE_GET, SW_LEAKY, sizeof(fal_leaky_ctrl_mode_t), SW_PARAM_PTR|SW_PARAM_OUT, "Uc Leaky mode"),

#define SW_API_MC_LEAKY_MODE_SET_DESC \
    SW_PARAM_DEF(SW_API_MC_LEAKY_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_MC_LEAKY_MODE_SET, SW_LEAKY, sizeof(fal_leaky_ctrl_mode_t), SW_PARAM_IN, "Mc Leaky mode"),

#define SW_API_MC_LEAKY_MODE_GET_DESC \
    SW_PARAM_DEF(SW_API_MC_LEAKY_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_MC_LEAKY_MODE_GET, SW_LEAKY, sizeof(fal_leaky_ctrl_mode_t), SW_PARAM_PTR|SW_PARAM_OUT, "Mc Leaky mode"),

#define SW_API_ARP_LEAKY_MODE_SET_DESC \
    SW_PARAM_DEF(SW_API_ARP_LEAKY_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_ARP_LEAKY_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_ARP_LEAKY_MODE_SET, SW_ENABLE, 4, SW_PARAM_IN, "Arp leaky"),

#define SW_API_ARP_LEAKY_MODE_GET_DESC \
    SW_PARAM_DEF(SW_API_ARP_LEAKY_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_ARP_LEAKY_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_ARP_LEAKY_MODE_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Arp leaky"),

#define SW_API_PT_UC_LEAKY_MODE_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_UC_LEAKY_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_UC_LEAKY_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_UC_LEAKY_MODE_SET, SW_ENABLE, 4, SW_PARAM_IN, "Port Unicast leaky"),

#define SW_API_PT_UC_LEAKY_MODE_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_UC_LEAKY_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_UC_LEAKY_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_UC_LEAKY_MODE_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Port Uc leaky"),

#define SW_API_PT_MC_LEAKY_MODE_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_MC_LEAKY_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_MC_LEAKY_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_MC_LEAKY_MODE_SET, SW_ENABLE, 4, SW_PARAM_IN, "Port Multicast leaky"),

#define SW_API_PT_MC_LEAKY_MODE_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_MC_LEAKY_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_MC_LEAKY_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_MC_LEAKY_MODE_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Port Mc leaky"),



#define SW_API_MIRROR_ANALY_PT_SET_DESC \
    SW_PARAM_DEF(SW_API_MIRROR_ANALY_PT_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_MIRROR_ANALY_PT_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),

#define SW_API_MIRROR_ANALY_PT_GET_DESC \
    SW_PARAM_DEF(SW_API_MIRROR_ANALY_PT_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_MIRROR_ANALY_PT_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Port ID"),

#define SW_API_MIRROR_IN_PT_SET_DESC \
    SW_PARAM_DEF(SW_API_MIRROR_IN_PT_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_MIRROR_IN_PT_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_MIRROR_IN_PT_SET, SW_ENABLE, 4, SW_PARAM_IN, "Ingerss mirror"),

#define SW_API_MIRROR_IN_PT_GET_DESC \
    SW_PARAM_DEF(SW_API_MIRROR_IN_PT_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_MIRROR_IN_PT_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_MIRROR_IN_PT_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Ingeress mirror"),

#define SW_API_MIRROR_EG_PT_SET_DESC \
    SW_PARAM_DEF(SW_API_MIRROR_EG_PT_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_MIRROR_EG_PT_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_MIRROR_EG_PT_SET, SW_ENABLE, 4, SW_PARAM_IN, "Egerss mirror"),

#define SW_API_MIRROR_EG_PT_GET_DESC \
    SW_PARAM_DEF(SW_API_MIRROR_EG_PT_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_MIRROR_EG_PT_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_MIRROR_EG_PT_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Egeress mirror"),

#define SW_API_MIRROR_ANALYSIS_CONFIG_SET_DESC \
    SW_PARAM_DEF(SW_API_MIRROR_ANALYSIS_CONFIG_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_MIRROR_ANALYSIS_CONFIG_SET, SW_MIRR_DIRECTION, sizeof(fal_mirr_direction_t), SW_PARAM_IN, "Direction"), \
    SW_PARAM_DEF(SW_API_MIRROR_ANALYSIS_CONFIG_SET, SW_MIRR_ANALYSIS_CONFIG, sizeof(fal_mirr_analysis_config_t), SW_PARAM_PTR|SW_PARAM_IN, "Config"),

#define SW_API_MIRROR_ANALYSIS_CONFIG_GET_DESC \
    SW_PARAM_DEF(SW_API_MIRROR_ANALYSIS_CONFIG_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_MIRROR_ANALYSIS_CONFIG_GET, SW_MIRR_DIRECTION, sizeof(fal_mirr_direction_t), SW_PARAM_IN, "Direction"), \
    SW_PARAM_DEF(SW_API_MIRROR_ANALYSIS_CONFIG_GET, SW_MIRR_ANALYSIS_CONFIG, sizeof(fal_mirr_analysis_config_t), SW_PARAM_PTR|SW_PARAM_OUT, "Config"),

#define SW_API_RSS_HASH_CONFIG_SET_DESC \
    SW_PARAM_DEF(SW_API_RSS_HASH_CONFIG_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_RSS_HASH_CONFIG_SET, SW_RSS_HASH_MODE, sizeof(fal_rss_hash_mode_t), SW_PARAM_IN, "Mode"), \
    SW_PARAM_DEF(SW_API_RSS_HASH_CONFIG_SET, SW_RSS_HASH_CONFIG, sizeof(fal_rss_hash_config_t), SW_PARAM_PTR|SW_PARAM_IN, "Config"),

#define SW_API_RSS_HASH_CONFIG_GET_DESC \
    SW_PARAM_DEF(SW_API_RSS_HASH_CONFIG_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_RSS_HASH_CONFIG_GET, SW_RSS_HASH_MODE, sizeof(fal_rss_hash_mode_t), SW_PARAM_IN, "Mode"), \
    SW_PARAM_DEF(SW_API_RSS_HASH_CONFIG_GET, SW_RSS_HASH_CONFIG, sizeof(fal_rss_hash_config_t), SW_PARAM_PTR|SW_PARAM_OUT, "Config"),


#define SW_API_RATE_QU_EGRL_SET_DESC \
    SW_PARAM_DEF(SW_API_RATE_QU_EGRL_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_RATE_QU_EGRL_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_RATE_QU_EGRL_SET, SW_UINT32, 4, SW_PARAM_IN, "Queue ID"),\
    SW_PARAM_DEF(SW_API_RATE_QU_EGRL_SET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Speed"),\
    SW_PARAM_DEF(SW_API_RATE_QU_EGRL_SET, SW_ENABLE, 4, SW_PARAM_IN, "Rate limit"),

#define SW_API_RATE_QU_EGRL_GET_DESC \
    SW_PARAM_DEF(SW_API_RATE_QU_EGRL_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_RATE_QU_EGRL_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_RATE_QU_EGRL_GET, SW_UINT32, 4, SW_PARAM_IN, "Queue ID"),\
    SW_PARAM_DEF(SW_API_RATE_QU_EGRL_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Speed"),\
    SW_PARAM_DEF(SW_API_RATE_QU_EGRL_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Rate limit"),

#define SW_API_RATE_PT_EGRL_SET_DESC \
    SW_PARAM_DEF(SW_API_RATE_PT_EGRL_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_RATE_PT_EGRL_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_RATE_PT_EGRL_SET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Speed"),\
    SW_PARAM_DEF(SW_API_RATE_PT_EGRL_SET, SW_ENABLE, 4, SW_PARAM_IN, "Rate limit"),

#define SW_API_RATE_PT_EGRL_GET_DESC \
    SW_PARAM_DEF(SW_API_RATE_PT_EGRL_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_RATE_PT_EGRL_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_RATE_PT_EGRL_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Speed"),\
    SW_PARAM_DEF(SW_API_RATE_PT_EGRL_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Rate limit"),

#define SW_API_RATE_PT_INRL_SET_DESC \
    SW_PARAM_DEF(SW_API_RATE_PT_INRL_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_RATE_PT_INRL_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_RATE_PT_INRL_SET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Speed"),\
    SW_PARAM_DEF(SW_API_RATE_PT_INRL_SET, SW_ENABLE, 4, SW_PARAM_IN, "Rate limit"),

#define SW_API_RATE_PT_INRL_GET_DESC \
    SW_PARAM_DEF(SW_API_RATE_PT_INRL_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_RATE_PT_INRL_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_RATE_PT_INRL_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Speed"),\
    SW_PARAM_DEF(SW_API_RATE_PT_INRL_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Rate limit"),

#define SW_API_STORM_CTRL_FRAME_SET_DESC \
    SW_PARAM_DEF(SW_API_STORM_CTRL_FRAME_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_STORM_CTRL_FRAME_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_STORM_CTRL_FRAME_SET, SW_STORM, sizeof(fal_storm_type_t), SW_PARAM_IN, "Frame type"),\
    SW_PARAM_DEF(SW_API_STORM_CTRL_FRAME_SET, SW_ENABLE, 4, SW_PARAM_IN, "strom contrl"),

#define SW_API_STORM_CTRL_FRAME_GET_DESC \
    SW_PARAM_DEF(SW_API_STORM_CTRL_FRAME_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_STORM_CTRL_FRAME_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_STORM_CTRL_FRAME_GET, SW_STORM, sizeof(fal_storm_type_t), SW_PARAM_IN, "Frame type"),\
    SW_PARAM_DEF(SW_API_STORM_CTRL_FRAME_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "strom contrl"),

#define SW_API_STORM_CTRL_RATE_SET_DESC \
    SW_PARAM_DEF(SW_API_STORM_CTRL_RATE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_STORM_CTRL_RATE_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_STORM_CTRL_RATE_SET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Speed"),

#define SW_API_STORM_CTRL_RATE_GET_DESC \
    SW_PARAM_DEF(SW_API_STORM_CTRL_RATE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_STORM_CTRL_RATE_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_STORM_CTRL_RATE_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Speed"),

#define SW_API_RATE_PORT_POLICER_SET_DESC \
    SW_PARAM_DEF(SW_API_RATE_PORT_POLICER_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_RATE_PORT_POLICER_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_RATE_PORT_POLICER_SET, SW_INGPOLICER, sizeof(fal_port_policer_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Policer"),

#define SW_API_RATE_PORT_POLICER_GET_DESC \
    SW_PARAM_DEF(SW_API_RATE_PORT_POLICER_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_RATE_PORT_POLICER_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_RATE_PORT_POLICER_GET, SW_INGPOLICER, sizeof(fal_port_policer_t), SW_PARAM_PTR|SW_PARAM_OUT, "Policer"),

#define SW_API_RATE_PORT_SHAPER_SET_DESC \
    SW_PARAM_DEF(SW_API_RATE_PORT_SHAPER_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_RATE_PORT_SHAPER_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_RATE_PORT_SHAPER_SET, SW_ENABLE, 4, SW_PARAM_IN, "Status"), \
    SW_PARAM_DEF(SW_API_RATE_PORT_SHAPER_SET, SW_EGSHAPER, sizeof(fal_egress_shaper_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Shaper"),

#define SW_API_RATE_PORT_SHAPER_GET_DESC \
    SW_PARAM_DEF(SW_API_RATE_PORT_SHAPER_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_RATE_PORT_SHAPER_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_RATE_PORT_SHAPER_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Status"), \
    SW_PARAM_DEF(SW_API_RATE_PORT_SHAPER_GET, SW_EGSHAPER, sizeof(fal_egress_shaper_t), SW_PARAM_PTR|SW_PARAM_OUT, "Shaper"),

#define SW_API_RATE_QUEUE_SHAPER_SET_DESC \
    SW_PARAM_DEF(SW_API_RATE_QUEUE_SHAPER_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_RATE_QUEUE_SHAPER_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_RATE_QUEUE_SHAPER_SET, SW_UINT32, 4, SW_PARAM_IN, "Queue ID"),\
    SW_PARAM_DEF(SW_API_RATE_QUEUE_SHAPER_SET, SW_ENABLE, 4, SW_PARAM_IN, "Enable"), \
    SW_PARAM_DEF(SW_API_RATE_QUEUE_SHAPER_SET, SW_EGSHAPER, sizeof(fal_egress_shaper_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Shaper"),

#define SW_API_RATE_QUEUE_SHAPER_GET_DESC \
    SW_PARAM_DEF(SW_API_RATE_QUEUE_SHAPER_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_RATE_QUEUE_SHAPER_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_RATE_QUEUE_SHAPER_GET, SW_UINT32, 4, SW_PARAM_IN, "Queue ID"),\
    SW_PARAM_DEF(SW_API_RATE_QUEUE_SHAPER_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Status"), \
    SW_PARAM_DEF(SW_API_RATE_QUEUE_SHAPER_GET, SW_EGSHAPER, sizeof(fal_egress_shaper_t), SW_PARAM_PTR|SW_PARAM_OUT, "Shaper"),

#define SW_API_RATE_ACL_POLICER_SET_DESC \
    SW_PARAM_DEF(SW_API_RATE_ACL_POLICER_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_RATE_ACL_POLICER_SET, SW_UINT32, 4, SW_PARAM_IN, "Policer ID"),\
    SW_PARAM_DEF(SW_API_RATE_ACL_POLICER_SET, SW_ACLPOLICER, sizeof(fal_acl_policer_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Policer"),

#define SW_API_RATE_ACL_POLICER_GET_DESC \
    SW_PARAM_DEF(SW_API_RATE_ACL_POLICER_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_RATE_ACL_POLICER_GET, SW_UINT32, 4, SW_PARAM_IN, "Policer ID"),\
    SW_PARAM_DEF(SW_API_RATE_ACL_POLICER_GET, SW_ACLPOLICER, sizeof(fal_acl_policer_t), SW_PARAM_PTR|SW_PARAM_OUT, "Policer"),

#define SW_API_RATE_PT_ADDRATEBYTE_SET_DESC\
    SW_PARAM_DEF(SW_API_RATE_PT_ADDRATEBYTE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_RATE_PT_ADDRATEBYTE_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_RATE_PT_ADDRATEBYTE_SET, SW_UINT32, 4, SW_PARAM_IN, "AddRateByte"),

#define SW_API_RATE_PT_ADDRATEBYTE_GET_DESC\
    SW_PARAM_DEF(SW_API_RATE_PT_ADDRATEBYTE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_RATE_PT_ADDRATEBYTE_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_RATE_PT_ADDRATEBYTE_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "AddRateByte"),

#define SW_API_RATE_PT_GOL_FLOW_EN_SET_DESC \
    SW_PARAM_DEF(SW_API_RATE_PT_GOL_FLOW_EN_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_RATE_PT_GOL_FLOW_EN_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_RATE_PT_GOL_FLOW_EN_SET, SW_ENABLE, 4, SW_PARAM_IN, "Enable"),

#define SW_API_RATE_PT_GOL_FLOW_EN_GET_DESC \
    SW_PARAM_DEF(SW_API_RATE_PT_GOL_FLOW_EN_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_RATE_PT_GOL_FLOW_EN_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_RATE_PT_GOL_FLOW_EN_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Enable"),

#define SW_API_STP_PT_STATE_SET_DESC \
    SW_PARAM_DEF(SW_API_STP_PT_STATE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_STP_PT_STATE_SET, SW_UINT32, 4, SW_PARAM_IN, "Spaning tree ID"),\
    SW_PARAM_DEF(SW_API_STP_PT_STATE_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_STP_PT_STATE_SET, SW_STP, sizeof(fal_stp_state_t), SW_PARAM_IN, "Port State"),

#define SW_API_STP_PT_STATE_GET_DESC \
    SW_PARAM_DEF(SW_API_STP_PT_STATE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_STP_PT_STATE_GET, SW_UINT32, 4, SW_PARAM_IN, "Spaning tree ID"),\
    SW_PARAM_DEF(SW_API_STP_PT_STATE_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),\
    SW_PARAM_DEF(SW_API_STP_PT_STATE_GET, SW_STP, sizeof(fal_stp_state_t), SW_PARAM_PTR|SW_PARAM_OUT, "Port State"),




#define SW_API_PT_MIB_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_MIB_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_MIB_GET, SW_UINT32, 4, SW_PARAM_IN, "Port No."), \
    SW_PARAM_DEF(SW_API_PT_MIB_GET, SW_MIB, sizeof(fal_mib_info_t), SW_PARAM_PTR|SW_PARAM_OUT, \
              "MIB info"),
#define SW_API_PT_XGMIB_GET_DESC \
		SW_PARAM_DEF(SW_API_PT_XGMIB_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
		SW_PARAM_DEF(SW_API_PT_XGMIB_GET, SW_UINT32, 4, SW_PARAM_IN, "Port No."), \
		SW_PARAM_DEF(SW_API_PT_XGMIB_GET, SW_XGMIB, sizeof(fal_xgmib_info_t), SW_PARAM_PTR|SW_PARAM_OUT, \
				  "XGMIB info"),

#define SW_API_MIB_STATUS_SET_DESC \
    SW_PARAM_DEF(SW_API_MIB_STATUS_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_MIB_STATUS_SET, SW_ENABLE, 4, SW_PARAM_IN, "MIB status"),

#define SW_API_MIB_STATUS_GET_DESC \
    SW_PARAM_DEF(SW_API_MIB_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_MIB_STATUS_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "MIB status"),

#define SW_API_PT_MIB_FLUSH_COUNTERS_DESC\
    SW_PARAM_DEF(SW_API_PT_MIB_FLUSH_COUNTERS, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_MIB_FLUSH_COUNTERS, SW_UINT32, 4, SW_PARAM_IN, "Port No."),

#define SW_API_MIB_CPU_KEEP_SET_DESC \
    SW_PARAM_DEF(SW_API_MIB_CPU_KEEP_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_MIB_CPU_KEEP_SET, SW_ENABLE, 4, SW_PARAM_IN, "CPU_KEEP Set"),

#define SW_API_MIB_CPU_KEEP_GET_DESC \
    SW_PARAM_DEF(SW_API_MIB_CPU_KEEP_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_MIB_CPU_KEEP_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "CPU_KEEP Get"),

#define SW_API_PT_MIB_COUNTER_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_MIB_COUNTER_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_MIB_COUNTER_GET, SW_UINT32, 4, SW_PARAM_IN, "Port No."), \
    SW_PARAM_DEF(SW_API_PT_MIB_COUNTER_GET, SW_MIB_CNTR, sizeof(fal_mib_counter_t), SW_PARAM_PTR|SW_PARAM_OUT, \
              "MIB Counter"),



#define SW_API_ARP_STATUS_SET_DESC \
    SW_PARAM_DEF(SW_API_ARP_STATUS_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_ARP_STATUS_SET, SW_ENABLE, 4, SW_PARAM_IN, "ARP acknowledge"),

#define SW_API_ARP_STATUS_GET_DESC \
    SW_PARAM_DEF(SW_API_ARP_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_ARP_STATUS_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "ARP acknowledge"),

#define SW_API_FRAME_MAX_SIZE_SET_DESC \
    SW_PARAM_DEF(SW_API_FRAME_MAX_SIZE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_FRAME_MAX_SIZE_SET, SW_UINT32, 4, SW_PARAM_IN, "Frame Size"),

#define SW_API_FRAME_MAX_SIZE_GET_DESC \
    SW_PARAM_DEF(SW_API_FRAME_MAX_SIZE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_FRAME_MAX_SIZE_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Frame Size"),

#define SW_API_PT_UNK_SA_CMD_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_UNK_SA_CMD_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_UNK_SA_CMD_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_UNK_SA_CMD_SET, SW_MACCMD, sizeof(fal_fwd_cmd_t), SW_PARAM_IN, "Forwarding"),

#define SW_API_PT_UNK_SA_CMD_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_UNK_SA_CMD_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_UNK_SA_CMD_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_UNK_SA_CMD_GET, SW_MACCMD, sizeof(fal_fwd_cmd_t), SW_PARAM_PTR|SW_PARAM_OUT, "Forwarding"),

#define SW_API_PT_UNK_UC_FILTER_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_UNK_UC_FILTER_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_UNK_UC_FILTER_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_UNK_UC_FILTER_SET, SW_ENABLE, 4, SW_PARAM_IN, "Filter"),

#define SW_API_PT_UNK_UC_FILTER_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_UNK_UC_FILTER_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_UNK_UC_FILTER_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_UNK_UC_FILTER_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Filter"),

#define SW_API_PT_UNK_MC_FILTER_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_UNK_MC_FILTER_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_UNK_MC_FILTER_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_UNK_MC_FILTER_SET, SW_ENABLE, 4, SW_PARAM_IN, "Filter"),

#define SW_API_PT_UNK_MC_FILTER_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_UNK_MC_FILTER_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_UNK_MC_FILTER_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_UNK_MC_FILTER_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Filter"),

#define SW_API_PT_BC_FILTER_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_BC_FILTER_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_BC_FILTER_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_BC_FILTER_SET, SW_ENABLE, 4, SW_PARAM_IN, "Filter"),

#define SW_API_PT_BC_FILTER_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_BC_FILTER_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_BC_FILTER_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_BC_FILTER_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Filter"),

#define SW_API_CPU_PORT_STATUS_SET_DESC \
    SW_PARAM_DEF(SW_API_CPU_PORT_STATUS_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_CPU_PORT_STATUS_SET, SW_ENABLE, 4, SW_PARAM_IN, "Cpu port"),

#define SW_API_CPU_PORT_STATUS_GET_DESC \
    SW_PARAM_DEF(SW_API_CPU_PORT_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_CPU_PORT_STATUS_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Cpu port"),

#define SW_API_BC_TO_CPU_PORT_SET_DESC \
    SW_PARAM_DEF(SW_API_BC_TO_CPU_PORT_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_BC_TO_CPU_PORT_SET, SW_ENABLE, 4, SW_PARAM_IN, "ToCpu"),

#define SW_API_BC_TO_CPU_PORT_GET_DESC \
    SW_PARAM_DEF(SW_API_BC_TO_CPU_PORT_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_BC_TO_CPU_PORT_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "ToCpu"),

#define SW_API_PPPOE_CMD_SET_DESC \
    SW_PARAM_DEF(SW_API_PPPOE_CMD_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PPPOE_CMD_SET, SW_MACCMD, sizeof(fal_fwd_cmd_t), SW_PARAM_IN, "Forwarding"),

#define SW_API_PPPOE_CMD_GET_DESC \
    SW_PARAM_DEF(SW_API_PPPOE_CMD_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PPPOE_CMD_GET, SW_MACCMD, sizeof(fal_fwd_cmd_t), SW_PARAM_PTR|SW_PARAM_OUT, "Forwarding"),

#define SW_API_PPPOE_STATUS_SET_DESC \
    SW_PARAM_DEF(SW_API_PPPOE_STATUS_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PPPOE_STATUS_SET, SW_ENABLE, 4, SW_PARAM_IN, "PPPOE"),

#define SW_API_PPPOE_STATUS_GET_DESC \
    SW_PARAM_DEF(SW_API_PPPOE_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PPPOE_STATUS_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "PPPOE"),

#define SW_API_PT_DHCP_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_DHCP_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_DHCP_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_DHCP_SET, SW_ENABLE, 4, SW_PARAM_IN, "DHCP"),

#define SW_API_PT_DHCP_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_DHCP_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_DHCP_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_DHCP_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "DHCP"),

#define SW_API_ARP_CMD_SET_DESC \
    SW_PARAM_DEF(SW_API_ARP_CMD_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_ARP_CMD_SET, SW_MACCMD, sizeof(fal_fwd_cmd_t), SW_PARAM_IN, "cmd"),

#define SW_API_ARP_CMD_GET_DESC \
    SW_PARAM_DEF(SW_API_ARP_CMD_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_ARP_CMD_GET, SW_MACCMD, sizeof(fal_fwd_cmd_t), SW_PARAM_PTR|SW_PARAM_OUT, "cmd"),

#define SW_API_EAPOL_CMD_SET_DESC \
    SW_PARAM_DEF(SW_API_EAPOL_CMD_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_EAPOL_CMD_SET, SW_MACCMD, sizeof(fal_fwd_cmd_t), SW_PARAM_IN, "cmd"),

#define SW_API_EAPOL_CMD_GET_DESC \
    SW_PARAM_DEF(SW_API_EAPOL_CMD_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_EAPOL_CMD_GET, SW_MACCMD, sizeof(fal_fwd_cmd_t), SW_PARAM_PTR|SW_PARAM_OUT, "cmd"),

#define SW_API_PPPOE_SESSION_ADD_DESC \
    SW_PARAM_DEF(SW_API_PPPOE_SESSION_ADD, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PPPOE_SESSION_ADD, SW_UINT32, 4, SW_PARAM_IN, "Session ID"), \
    SW_PARAM_DEF(SW_API_PPPOE_SESSION_ADD, SW_ENABLE, 4, SW_PARAM_IN, "StripHdr"),

#define SW_API_PPPOE_SESSION_DEL_DESC \
    SW_PARAM_DEF(SW_API_PPPOE_SESSION_DEL, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PPPOE_SESSION_DEL, SW_UINT32, 4, SW_PARAM_IN, "Session ID"),

#define SW_API_PPPOE_SESSION_GET_DESC \
    SW_PARAM_DEF(SW_API_PPPOE_SESSION_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PPPOE_SESSION_GET, SW_UINT32, 4, SW_PARAM_IN, "Session ID"), \
    SW_PARAM_DEF(SW_API_PPPOE_SESSION_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "StripHdr"),

#define SW_API_EAPOL_STATUS_SET_DESC \
    SW_PARAM_DEF(SW_API_EAPOL_STATUS_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_EAPOL_STATUS_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_EAPOL_STATUS_SET, SW_ENABLE, 4, SW_PARAM_IN, "Enable"),

#define SW_API_EAPOL_STATUS_GET_DESC \
    SW_PARAM_DEF(SW_API_EAPOL_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_EAPOL_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_EAPOL_STATUS_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Enable"),

#define SW_API_RIPV1_STATUS_SET_DESC \
    SW_PARAM_DEF(SW_API_RIPV1_STATUS_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_RIPV1_STATUS_SET, SW_ENABLE, 4, SW_PARAM_IN, "Enable"),

#define SW_API_RIPV1_STATUS_GET_DESC \
    SW_PARAM_DEF(SW_API_RIPV1_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_RIPV1_STATUS_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Enable"),

#define SW_API_PT_ARP_REQ_STATUS_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_ARP_REQ_STATUS_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_ARP_REQ_STATUS_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_ARP_REQ_STATUS_SET, SW_ENABLE, 4, SW_PARAM_IN, "ARP Req acknowledge"),

#define SW_API_PT_ARP_REQ_STATUS_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_ARP_REQ_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_ARP_REQ_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_ARP_REQ_STATUS_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "ARP Req acknowledge"),

#define SW_API_PT_ARP_ACK_STATUS_SET_DESC \
    SW_PARAM_DEF(SW_API_PT_ARP_ACK_STATUS_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_ARP_ACK_STATUS_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_ARP_ACK_STATUS_SET, SW_ENABLE, 4, SW_PARAM_IN, "ARP Ack acknowledge"),

#define SW_API_PT_ARP_ACK_STATUS_GET_DESC \
    SW_PARAM_DEF(SW_API_PT_ARP_ACK_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PT_ARP_ACK_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PT_ARP_ACK_STATUS_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "ARP Ack acknowledge"),

#define SW_API_PPPOE_SESSION_TABLE_ADD_DESC \
    SW_PARAM_DEF(SW_API_PPPOE_SESSION_TABLE_ADD, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PPPOE_SESSION_TABLE_ADD, SW_PPPOE,  sizeof(fal_pppoe_session_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Session"),

#define SW_API_PPPOE_SESSION_TABLE_DEL_DESC \
    SW_PARAM_DEF(SW_API_PPPOE_SESSION_TABLE_DEL, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PPPOE_SESSION_TABLE_DEL, SW_PPPOE,  sizeof(fal_pppoe_session_t), SW_PARAM_PTR|SW_PARAM_IN, "Session"),

#define SW_API_PPPOE_SESSION_TABLE_GET_DESC \
    SW_PARAM_DEF(SW_API_PPPOE_SESSION_TABLE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PPPOE_SESSION_TABLE_GET, SW_PPPOE,  sizeof(fal_pppoe_session_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Session"),

#define SW_API_PPPOE_SESSION_ID_SET_DESC \
    SW_PARAM_DEF(SW_API_PPPOE_SESSION_ID_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PPPOE_SESSION_ID_SET, SW_UINT32, 4, SW_PARAM_IN, "Index"), \
    SW_PARAM_DEF(SW_API_PPPOE_SESSION_ID_SET, SW_UINT32, 4, SW_PARAM_IN, "ID"),

#define SW_API_PPPOE_SESSION_ID_GET_DESC \
    SW_PARAM_DEF(SW_API_PPPOE_SESSION_ID_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PPPOE_SESSION_ID_GET, SW_UINT32, 4, SW_PARAM_IN, "Index"), \
    SW_PARAM_DEF(SW_API_PPPOE_SESSION_ID_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "ID"),

#define SW_API_INTR_MASK_SET_DESC \
    SW_PARAM_DEF(SW_API_INTR_MASK_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_INTR_MASK_SET, SW_UINT32, 4, SW_PARAM_IN, "Mask"),

#define SW_API_INTR_MASK_GET_DESC \
    SW_PARAM_DEF(SW_API_INTR_MASK_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_INTR_MASK_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Mask"),

#define SW_API_INTR_STATUS_GET_DESC \
    SW_PARAM_DEF(SW_API_INTR_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_INTR_STATUS_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Status"),

#define SW_API_INTR_STATUS_CLEAR_DESC \
    SW_PARAM_DEF(SW_API_INTR_STATUS_CLEAR, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_INTR_STATUS_CLEAR, SW_UINT32, 4, SW_PARAM_IN, "Status"),

#define SW_API_INTR_PORT_LINK_MASK_SET_DESC \
    SW_PARAM_DEF(SW_API_INTR_PORT_LINK_MASK_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_INTR_PORT_LINK_MASK_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_INTR_PORT_LINK_MASK_SET, SW_UINT32, 4, SW_PARAM_IN, "Mask"),

#define SW_API_INTR_PORT_LINK_MASK_GET_DESC \
    SW_PARAM_DEF(SW_API_INTR_PORT_LINK_MASK_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_INTR_PORT_LINK_MASK_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_INTR_PORT_LINK_MASK_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Mask"),

#define SW_API_INTR_PORT_LINK_STATUS_GET_DESC \
    SW_PARAM_DEF(SW_API_INTR_PORT_LINK_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_INTR_PORT_LINK_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_INTR_PORT_LINK_STATUS_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Status"),

#define SW_API_INTR_MASK_MAC_LINKCHG_SET_DESC \
    SW_PARAM_DEF(SW_API_INTR_MASK_MAC_LINKCHG_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_INTR_MASK_MAC_LINKCHG_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_INTR_MASK_MAC_LINKCHG_SET, SW_ENABLE, 4, SW_PARAM_IN, "Enable"),

#define SW_API_INTR_MASK_MAC_LINKCHG_GET_DESC \
    SW_PARAM_DEF(SW_API_INTR_MASK_MAC_LINKCHG_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_INTR_MASK_MAC_LINKCHG_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_INTR_MASK_MAC_LINKCHG_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Enable"),

#define SW_API_INTR_STATUS_MAC_LINKCHG_GET_DESC \
    SW_PARAM_DEF(SW_API_INTR_STATUS_MAC_LINKCHG_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_INTR_STATUS_MAC_LINKCHG_GET, SW_PBMP, sizeof(fal_pbmp_t), SW_PARAM_PTR|SW_PARAM_OUT, "Intr Port Bitmap"),

#define SW_API_INTR_STATUS_MAC_LINKCHG_CLEAR_DESC \
    SW_PARAM_DEF(SW_API_INTR_STATUS_MAC_LINKCHG_CLEAR, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),

#define SW_API_CPU_VID_EN_SET_DESC \
    SW_PARAM_DEF(SW_API_CPU_VID_EN_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_CPU_VID_EN_SET, SW_ENABLE, 4, SW_PARAM_IN, "Cpu vid"),

#define SW_API_CPU_VID_EN_GET_DESC \
    SW_PARAM_DEF(SW_API_CPU_VID_EN_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_CPU_VID_EN_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Cpu vid"),

#define SW_API_RTD_PPPOE_EN_SET_DESC \
    SW_PARAM_DEF(SW_API_RTD_PPPOE_EN_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_RTD_PPPOE_EN_SET, SW_ENABLE, 4, SW_PARAM_IN, "RTD PPPoE"),

#define SW_API_RTD_PPPOE_EN_GET_DESC \
    SW_PARAM_DEF(SW_API_RTD_PPPOE_EN_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_RTD_PPPOE_EN_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "RTD PPPoE"),

#define SW_API_PPPOE_EN_SET_DESC \
    SW_PARAM_DEF(SW_API_PPPOE_EN_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PPPOE_EN_SET, SW_UINT32, 4, SW_PARAM_IN, "L3 Interface"), \
    SW_PARAM_DEF(SW_API_PPPOE_EN_SET, SW_ENABLE, 4, SW_PARAM_IN, "Enable"),

#define SW_API_PPPOE_EN_GET_DESC \
    SW_PARAM_DEF(SW_API_PPPOE_EN_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PPPOE_EN_GET, SW_UINT32, 4, SW_PARAM_IN, "L3 Interface"), \
    SW_PARAM_DEF(SW_API_PPPOE_EN_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Enable"),

#define SW_API_PPPOE_L3_INTF_SET_DESC \
    SW_PARAM_DEF(SW_API_PPPOE_L3_INTF_SET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PPPOE_L3_INTF_SET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "PPPoE entry index"), \
    SW_PARAM_DEF(SW_API_PPPOE_L3_INTF_SET, SW_INTF_TYPE, \
		    sizeof(fal_intf_type_t), SW_PARAM_IN, "PPPoE L3 intf type"), \
    SW_PARAM_DEF(SW_API_PPPOE_L3_INTF_SET, SW_IP_VSI_INTF, \
		    sizeof(fal_intf_id_t), SW_PARAM_PTR|SW_PARAM_IN, "Enable"),

#define SW_API_PPPOE_L3_INTF_GET_DESC \
    SW_PARAM_DEF(SW_API_PPPOE_L3_INTF_GET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PPPOE_L3_INTF_GET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "PPPoE entry index"), \
    SW_PARAM_DEF(SW_API_PPPOE_L3_INTF_GET, SW_INTF_TYPE, \
		    sizeof(fal_intf_type_t), SW_PARAM_IN, "PPPoE L3 intf type"), \
    SW_PARAM_DEF(SW_API_PPPOE_L3_INTF_GET, SW_IP_VSI_INTF, \
		    sizeof(fal_intf_id_t), SW_PARAM_PTR|SW_PARAM_OUT, "Enable"),

#define SW_API_PPPOE_GLOBAL_CTRL_SET_DESC \
    SW_PARAM_DEF(SW_API_PPPOE_GLOBAL_CTRL_SET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PPPOE_GLOBAL_CTRL_SET, SW_PPPOE_CTRL, sizeof(fal_pppoe_global_cfg_t), \
		    SW_PARAM_PTR|SW_PARAM_IN, "PPPoE global control"),

#define SW_API_PPPOE_GLOBAL_CTRL_GET_DESC \
    SW_PARAM_DEF(SW_API_PPPOE_GLOBAL_CTRL_GET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PPPOE_GLOBAL_CTRL_GET, SW_PPPOE_CTRL, sizeof(fal_pppoe_global_cfg_t), \
		    SW_PARAM_PTR|SW_PARAM_OUT, "PPPoE global control"),

#define SW_API_GLOBAL_MACADDR_SET_DESC \
    SW_PARAM_DEF(SW_API_GLOBAL_MACADDR_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_GLOBAL_MACADDR_SET, SW_MACADDR, sizeof(fal_mac_addr_t), SW_PARAM_PTR|SW_PARAM_IN, "[Macaddr]:"),

#define SW_API_GLOBAL_MACADDR_GET_DESC \
    SW_PARAM_DEF(SW_API_GLOBAL_MACADDR_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_GLOBAL_MACADDR_GET, SW_MACADDR, sizeof(fal_mac_addr_t), SW_PARAM_PTR|SW_PARAM_OUT, "[Macaddr]:"),

#define SW_API_LLDP_STATUS_SET_DESC \
    SW_PARAM_DEF(SW_API_LLDP_STATUS_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_LLDP_STATUS_SET, SW_ENABLE, 4, SW_PARAM_IN, "LLDP"),

#define SW_API_LLDP_STATUS_GET_DESC \
    SW_PARAM_DEF(SW_API_LLDP_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_LLDP_STATUS_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "LLDP"),

#define SW_API_FRAME_CRC_RESERVE_SET_DESC \
    SW_PARAM_DEF(SW_API_FRAME_CRC_RESERVE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_FRAME_CRC_RESERVE_SET, SW_ENABLE, 4, SW_PARAM_IN, "Enable"),

#define SW_API_FRAME_CRC_RESERVE_GET_DESC \
    SW_PARAM_DEF(SW_API_FRAME_CRC_RESERVE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_FRAME_CRC_RESERVE_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Enable"),

#define SW_API_LED_PATTERN_SET_DESC \
    SW_PARAM_DEF(SW_API_LED_PATTERN_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_LED_PATTERN_SET, SW_UINT32, 4, SW_PARAM_IN, "Pattern Group"),\
    SW_PARAM_DEF(SW_API_LED_PATTERN_SET, SW_UINT32, 4, SW_PARAM_IN, "Pattern ID"),\
    SW_PARAM_DEF(SW_API_LED_PATTERN_SET, SW_LEDPATTERN, sizeof(led_ctrl_pattern_t), SW_PARAM_PTR|SW_PARAM_IN, "Pattern"),

#define SW_API_LED_PATTERN_GET_DESC \
    SW_PARAM_DEF(SW_API_LED_PATTERN_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_LED_PATTERN_GET, SW_UINT32, 4, SW_PARAM_IN, "Pattern Group"),\
    SW_PARAM_DEF(SW_API_LED_PATTERN_GET, SW_UINT32, 4, SW_PARAM_IN, "Pattern ID"),\
    SW_PARAM_DEF(SW_API_LED_PATTERN_GET, SW_LEDPATTERN, sizeof(led_ctrl_pattern_t), SW_PARAM_PTR|SW_PARAM_OUT, "Pattern"),

/*qca808x_start*/
#define SW_API_PHY_GET_DESC \
    SW_PARAM_DEF(SW_API_PHY_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_PHY_GET, SW_UINT32, 4, SW_PARAM_IN, "Phy ID"),\
    SW_PARAM_DEF(SW_API_PHY_GET, SW_UINT32, 4, SW_PARAM_IN, "Reg ID"),\
    SW_PARAM_DEF(SW_API_PHY_GET, SW_UINT16, 2, SW_PARAM_PTR|SW_PARAM_OUT, "Data"),


#define SW_API_PHY_SET_DESC \
    SW_PARAM_DEF(SW_API_PHY_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_PHY_SET, SW_UINT32, 4, SW_PARAM_IN, "Phy ID"),\
    SW_PARAM_DEF(SW_API_PHY_SET, SW_UINT32, 4, SW_PARAM_IN, "Reg ID"),\
    SW_PARAM_DEF(SW_API_PHY_SET, SW_UINT16, 2, SW_PARAM_IN, "Data"),
/*qca808x_end*/

#define SW_API_REG_GET_DESC \
    SW_PARAM_DEF(SW_API_REG_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_REG_GET, SW_UINT32, 4, SW_PARAM_IN, "Reg Addr"),\
    SW_PARAM_DEF(SW_API_REG_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Data"),\
    SW_PARAM_DEF(SW_API_REG_GET, SW_UINT32, 4, SW_PARAM_IN, "Data Len"),

#define SW_API_REG_SET_DESC \
    SW_PARAM_DEF(SW_API_REG_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_REG_SET, SW_UINT32, 4, SW_PARAM_IN, "Reg Addr"),\
    SW_PARAM_DEF(SW_API_REG_SET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_IN, "Data"),\
    SW_PARAM_DEF(SW_API_REG_SET, SW_UINT32, 4, SW_PARAM_IN, "Data Len"),

#define SW_API_PSGMII_REG_GET_DESC \
    SW_PARAM_DEF(SW_API_PSGMII_REG_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_PSGMII_REG_GET, SW_UINT32, 4, SW_PARAM_IN, "Reg Addr"),\
    SW_PARAM_DEF(SW_API_PSGMII_REG_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Data"),\
    SW_PARAM_DEF(SW_API_PSGMII_REG_GET, SW_UINT32, 4, SW_PARAM_IN, "Data Len"),

#define SW_API_PSGMII_REG_SET_DESC \
    SW_PARAM_DEF(SW_API_PSGMII_REG_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_PSGMII_REG_SET, SW_UINT32, 4, SW_PARAM_IN, "Reg Addr"),\
    SW_PARAM_DEF(SW_API_PSGMII_REG_SET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_IN, "Data"),\
    SW_PARAM_DEF(SW_API_PSGMII_REG_SET, SW_UINT32, 4, SW_PARAM_IN, "Data Len"),

#define SW_API_REG_FIELD_GET_DESC \
    SW_PARAM_DEF(SW_API_REG_FIELD_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_REG_FIELD_GET, SW_UINT32, 4, SW_PARAM_IN, "Reg Addr"),\
    SW_PARAM_DEF(SW_API_REG_FIELD_GET, SW_UINT32, 4, SW_PARAM_IN, "Bit Offset"),\
    SW_PARAM_DEF(SW_API_REG_FIELD_GET, SW_UINT32, 4, SW_PARAM_IN, "Field Len"),\
    SW_PARAM_DEF(SW_API_REG_FIELD_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Data"),\
    SW_PARAM_DEF(SW_API_REG_FIELD_GET, SW_UINT32, 4, SW_PARAM_IN, "Data Len"),

#define SW_API_REG_FIELD_SET_DESC \
    SW_PARAM_DEF(SW_API_REG_FIELD_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_REG_FIELD_SET, SW_UINT32, 4, SW_PARAM_IN, "Reg Addr"),\
    SW_PARAM_DEF(SW_API_REG_FIELD_SET, SW_UINT32, 4, SW_PARAM_IN, "Bit Offset"),\
    SW_PARAM_DEF(SW_API_REG_FIELD_SET, SW_UINT32, 4, SW_PARAM_IN, "Field Len"),\
    SW_PARAM_DEF(SW_API_REG_FIELD_SET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_IN, "Data"),\
    SW_PARAM_DEF(SW_API_REG_FIELD_SET, SW_UINT32, 4, SW_PARAM_IN, "Data Len"),

#define SW_API_REG_DUMP_DESC \
    SW_PARAM_DEF(SW_API_REG_DUMP, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_REG_DUMP, SW_UINT32, 4, SW_PARAM_IN, "Register group idx"), \
    SW_PARAM_DEF(SW_API_REG_DUMP, SW_REG_DUMP, sizeof(fal_reg_dump_t), SW_PARAM_PTR|SW_PARAM_OUT, \
              "Register dump"),

#define SW_API_DBG_REG_DUMP_DESC \
    SW_PARAM_DEF(SW_API_DBG_REG_DUMP, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_DBG_REG_DUMP, SW_DBG_REG_DUMP, sizeof(fal_debug_reg_dump_t), SW_PARAM_PTR|SW_PARAM_OUT, \
              "Debug Register dump"),

#define SW_API_DBG_PSGMII_SELF_TEST_DESC \
    SW_PARAM_DEF(SW_API_DBG_PSGMII_SELF_TEST, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_DBG_PSGMII_SELF_TEST, SW_ENABLE, 4, SW_PARAM_IN, "enable"),\
    SW_PARAM_DEF(SW_API_DBG_PSGMII_SELF_TEST, SW_UINT32, 4, SW_PARAM_IN, "times"),\
    SW_PARAM_DEF(SW_API_DBG_PSGMII_SELF_TEST, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Status"),

#define SW_API_PHY_DUMP_DESC \
	SW_PARAM_DEF(SW_API_PHY_DUMP, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
	SW_PARAM_DEF(SW_API_PHY_DUMP, SW_UINT32, 4, SW_PARAM_IN, "Phy ID"),\
	SW_PARAM_DEF(SW_API_PHY_DUMP, SW_UINT32, 4, SW_PARAM_IN, "Register group idx"), \
	SW_PARAM_DEF(SW_API_PHY_DUMP, SW_PHY_DUMP, sizeof(fal_phy_dump_t), SW_PARAM_PTR|SW_PARAM_OUT, \
		"PHY dump"),

#define SW_API_UNIPHY_REG_GET_DESC \
    SW_PARAM_DEF(SW_API_UNIPHY_REG_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_UNIPHY_REG_GET, SW_UINT32, 4, SW_PARAM_IN, "Reg Index"),\
    SW_PARAM_DEF(SW_API_UNIPHY_REG_GET, SW_UINT32, 4, SW_PARAM_IN, "Reg Addr"),\
    SW_PARAM_DEF(SW_API_UNIPHY_REG_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Data"),\
    SW_PARAM_DEF(SW_API_UNIPHY_REG_GET, SW_UINT32, 4, SW_PARAM_IN, "Data Len"),

#define SW_API_UNIPHY_REG_SET_DESC \
    SW_PARAM_DEF(SW_API_UNIPHY_REG_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_UNIPHY_REG_SET, SW_UINT32, 4, SW_PARAM_IN, "Reg Index"),\
    SW_PARAM_DEF(SW_API_UNIPHY_REG_SET, SW_UINT32, 4, SW_PARAM_IN, "Reg Addr"),\
    SW_PARAM_DEF(SW_API_UNIPHY_REG_SET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_IN, "Data"),\
    SW_PARAM_DEF(SW_API_UNIPHY_REG_SET, SW_UINT32, 4, SW_PARAM_IN, "Data Len"),

#define SW_API_COSMAP_DSCP_TO_PRI_SET_DESC \
    SW_PARAM_DEF(SW_API_COSMAP_DSCP_TO_PRI_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_COSMAP_DSCP_TO_PRI_SET, SW_UINT32, 4, SW_PARAM_IN, "DSCP"),     \
    SW_PARAM_DEF(SW_API_COSMAP_DSCP_TO_PRI_SET, SW_UINT32, 4, SW_PARAM_IN, "Priority"),

#define SW_API_COSMAP_DSCP_TO_PRI_GET_DESC \
    SW_PARAM_DEF(SW_API_COSMAP_DSCP_TO_PRI_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_COSMAP_DSCP_TO_PRI_GET, SW_UINT32, 4, SW_PARAM_IN, "DSCP"),    \
    SW_PARAM_DEF(SW_API_COSMAP_DSCP_TO_PRI_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Priority"),

#define SW_API_COSMAP_DSCP_TO_DP_SET_DESC \
    SW_PARAM_DEF(SW_API_COSMAP_DSCP_TO_DP_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_COSMAP_DSCP_TO_DP_SET, SW_UINT32, 4, SW_PARAM_IN, "DSCP"),     \
    SW_PARAM_DEF(SW_API_COSMAP_DSCP_TO_DP_SET, SW_UINT32, 4, SW_PARAM_IN, "DP"),

#define SW_API_COSMAP_DSCP_TO_DP_GET_DESC \
    SW_PARAM_DEF(SW_API_COSMAP_DSCP_TO_DP_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_COSMAP_DSCP_TO_DP_GET, SW_UINT32, 4, SW_PARAM_IN, "DSCP"),    \
    SW_PARAM_DEF(SW_API_COSMAP_DSCP_TO_DP_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "DP"),

#define SW_API_COSMAP_UP_TO_PRI_SET_DESC \
    SW_PARAM_DEF(SW_API_COSMAP_UP_TO_PRI_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_COSMAP_UP_TO_PRI_SET, SW_UINT32, 4, SW_PARAM_IN, "Dot1p"),     \
    SW_PARAM_DEF(SW_API_COSMAP_UP_TO_PRI_SET, SW_UINT32, 4, SW_PARAM_IN, "Priority"),

#define SW_API_COSMAP_UP_TO_PRI_GET_DESC \
    SW_PARAM_DEF(SW_API_COSMAP_UP_TO_PRI_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_COSMAP_UP_TO_PRI_GET, SW_UINT32, 4, SW_PARAM_IN, "Dot1p"),    \
    SW_PARAM_DEF(SW_API_COSMAP_UP_TO_PRI_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Priority"),

#define SW_API_COSMAP_UP_TO_DP_SET_DESC \
    SW_PARAM_DEF(SW_API_COSMAP_UP_TO_DP_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_COSMAP_UP_TO_DP_SET, SW_UINT32, 4, SW_PARAM_IN, "Dot1p"),     \
    SW_PARAM_DEF(SW_API_COSMAP_UP_TO_DP_SET, SW_UINT32, 4, SW_PARAM_IN, "DP"),

#define SW_API_COSMAP_UP_TO_DP_GET_DESC \
    SW_PARAM_DEF(SW_API_COSMAP_UP_TO_DP_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_COSMAP_UP_TO_DP_GET, SW_UINT32, 4, SW_PARAM_IN, "Dot1p"),    \
    SW_PARAM_DEF(SW_API_COSMAP_UP_TO_DP_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "DP"),

#define SW_API_COSMAP_DSCP_TO_EHPRI_SET_DESC \
    SW_PARAM_DEF(SW_API_COSMAP_DSCP_TO_EHPRI_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_COSMAP_DSCP_TO_EHPRI_SET, SW_UINT32, 4, SW_PARAM_IN, "DSCP"),     \
    SW_PARAM_DEF(SW_API_COSMAP_DSCP_TO_EHPRI_SET, SW_UINT32, 4, SW_PARAM_IN, "Priority"),

#define SW_API_COSMAP_DSCP_TO_EHPRI_GET_DESC \
    SW_PARAM_DEF(SW_API_COSMAP_DSCP_TO_EHPRI_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_COSMAP_DSCP_TO_EHPRI_GET, SW_UINT32, 4, SW_PARAM_IN, "DSCP"),    \
    SW_PARAM_DEF(SW_API_COSMAP_DSCP_TO_EHPRI_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Priority"),

#define SW_API_COSMAP_DSCP_TO_EHDP_SET_DESC \
    SW_PARAM_DEF(SW_API_COSMAP_DSCP_TO_EHDP_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_COSMAP_DSCP_TO_EHDP_SET, SW_UINT32, 4, SW_PARAM_IN, "DSCP"),     \
    SW_PARAM_DEF(SW_API_COSMAP_DSCP_TO_EHDP_SET, SW_UINT32, 4, SW_PARAM_IN, "DP"),

#define SW_API_COSMAP_DSCP_TO_EHDP_GET_DESC \
    SW_PARAM_DEF(SW_API_COSMAP_DSCP_TO_EHDP_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_COSMAP_DSCP_TO_EHDP_GET, SW_UINT32, 4, SW_PARAM_IN, "DSCP"),    \
    SW_PARAM_DEF(SW_API_COSMAP_DSCP_TO_EHDP_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "DP"),

#define SW_API_COSMAP_UP_TO_EHPRI_SET_DESC \
    SW_PARAM_DEF(SW_API_COSMAP_UP_TO_EHPRI_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_COSMAP_UP_TO_EHPRI_SET, SW_UINT32, 4, SW_PARAM_IN, "Dot1p"),     \
    SW_PARAM_DEF(SW_API_COSMAP_UP_TO_EHPRI_SET, SW_UINT32, 4, SW_PARAM_IN, "Priority"),

#define SW_API_COSMAP_UP_TO_EHPRI_GET_DESC \
    SW_PARAM_DEF(SW_API_COSMAP_UP_TO_EHPRI_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_COSMAP_UP_TO_EHPRI_GET, SW_UINT32, 4, SW_PARAM_IN, "Dot1p"),    \
    SW_PARAM_DEF(SW_API_COSMAP_UP_TO_EHPRI_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Priority"),

#define SW_API_COSMAP_UP_TO_EHDP_SET_DESC \
    SW_PARAM_DEF(SW_API_COSMAP_UP_TO_EHDP_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_COSMAP_UP_TO_EHDP_SET, SW_UINT32, 4, SW_PARAM_IN, "Dot1p"),     \
    SW_PARAM_DEF(SW_API_COSMAP_UP_TO_EHDP_SET, SW_UINT32, 4, SW_PARAM_IN, "DP"),

#define SW_API_COSMAP_UP_TO_EHDP_GET_DESC \
    SW_PARAM_DEF(SW_API_COSMAP_UP_TO_EHDP_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_COSMAP_UP_TO_EHDP_GET, SW_UINT32, 4, SW_PARAM_IN, "Dot1p"),    \
    SW_PARAM_DEF(SW_API_COSMAP_UP_TO_EHDP_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "DP"),

#define SW_API_COSMAP_PRI_TO_QU_SET_DESC \
    SW_PARAM_DEF(SW_API_COSMAP_PRI_TO_QU_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_COSMAP_PRI_TO_QU_SET, SW_UINT32, 4, SW_PARAM_IN, "Priority"), \
    SW_PARAM_DEF(SW_API_COSMAP_PRI_TO_QU_SET, SW_UINT32, 4, SW_PARAM_IN, "Queue"),

#define SW_API_COSMAP_PRI_TO_QU_GET_DESC \
    SW_PARAM_DEF(SW_API_COSMAP_PRI_TO_QU_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_COSMAP_PRI_TO_QU_GET, SW_UINT32, 4, SW_PARAM_IN, "Priority"), \
    SW_PARAM_DEF(SW_API_COSMAP_PRI_TO_QU_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Queue"),

#define SW_API_COSMAP_PRI_TO_EHQU_SET_DESC \
    SW_PARAM_DEF(SW_API_COSMAP_PRI_TO_EHQU_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_COSMAP_PRI_TO_EHQU_SET, SW_UINT32, 4, SW_PARAM_IN, "Priority"), \
    SW_PARAM_DEF(SW_API_COSMAP_PRI_TO_EHQU_SET, SW_UINT32, 4, SW_PARAM_IN, "Queue"),

#define SW_API_COSMAP_PRI_TO_EHQU_GET_DESC \
    SW_PARAM_DEF(SW_API_COSMAP_PRI_TO_EHQU_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_COSMAP_PRI_TO_EHQU_GET, SW_UINT32, 4, SW_PARAM_IN, "Priority"), \
    SW_PARAM_DEF(SW_API_COSMAP_PRI_TO_EHQU_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Queue"),

#define SW_API_COSMAP_EG_REMARK_SET_DESC \
    SW_PARAM_DEF(SW_API_COSMAP_EG_REMARK_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_COSMAP_EG_REMARK_SET, SW_UINT32, 4, SW_PARAM_IN, "Table ID"), \
    SW_PARAM_DEF(SW_API_COSMAP_EG_REMARK_SET, SW_REMARKENTRY, sizeof(fal_egress_remark_table_t), SW_PARAM_IN|SW_PARAM_PTR, "Table Entry"),

#define SW_API_COSMAP_EG_REMARK_GET_DESC \
    SW_PARAM_DEF(SW_API_COSMAP_EG_REMARK_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_COSMAP_EG_REMARK_GET, SW_UINT32, 4, SW_PARAM_IN, "Table ID"), \
    SW_PARAM_DEF(SW_API_COSMAP_EG_REMARK_GET, SW_REMARKENTRY, sizeof(fal_egress_remark_table_t), SW_PARAM_OUT|SW_PARAM_PTR, "Table Entry"),



#define SW_API_SEC_NORM_SET_DESC \
    SW_PARAM_DEF(SW_API_SEC_NORM_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_SEC_NORM_SET, SW_UINT32, 4, SW_PARAM_IN, "NormItem"), \
    SW_PARAM_DEF(SW_API_SEC_NORM_SET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_IN, "NormVal"),

#define SW_API_SEC_NORM_GET_DESC \
    SW_PARAM_DEF(SW_API_SEC_NORM_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_SEC_NORM_GET, SW_UINT32, 4, SW_PARAM_IN, "NormItem"), \
    SW_PARAM_DEF(SW_API_SEC_NORM_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "NormVal"),

#define SW_API_SEC_MAC_SET_DESC \
    SW_PARAM_DEF(SW_API_SEC_MAC_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_SEC_MAC_SET, SW_SEC_MAC, 4, SW_PARAM_IN, "MAC related normalized item"), \
    SW_PARAM_DEF(SW_API_SEC_MAC_SET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_IN, "NormVal"),

#define SW_API_SEC_MAC_GET_DESC \
    SW_PARAM_DEF(SW_API_SEC_MAC_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_SEC_MAC_GET, SW_SEC_MAC, 4, SW_PARAM_IN, "MAC related normalized item"), \
    SW_PARAM_DEF(SW_API_SEC_MAC_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "NormVal"),

#define SW_API_SEC_IP_SET_DESC \
    SW_PARAM_DEF(SW_API_SEC_IP_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_SEC_IP_SET, SW_SEC_IP, 4, SW_PARAM_IN, "IP related normalized item"), \
    SW_PARAM_DEF(SW_API_SEC_IP_SET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_IN, "NormVal"),

#define SW_API_SEC_IP_GET_DESC \
    SW_PARAM_DEF(SW_API_SEC_IP_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_SEC_IP_GET, SW_SEC_IP, 4, SW_PARAM_IN, "IP related normalized item"), \
    SW_PARAM_DEF(SW_API_SEC_IP_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "NormVal"),

#define SW_API_SEC_IP4_SET_DESC \
    SW_PARAM_DEF(SW_API_SEC_IP4_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_SEC_IP4_SET, SW_SEC_IP4, 4, SW_PARAM_IN, "IP4 related normalized item"), \
    SW_PARAM_DEF(SW_API_SEC_IP4_SET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_IN, "NormVal"),

#define SW_API_SEC_IP4_GET_DESC \
    SW_PARAM_DEF(SW_API_SEC_IP4_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_SEC_IP4_GET, SW_SEC_IP4, 4, SW_PARAM_IN, "IP4 related normalized item"), \
    SW_PARAM_DEF(SW_API_SEC_IP4_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "NormVal"),

#define SW_API_SEC_IP6_SET_DESC \
    SW_PARAM_DEF(SW_API_SEC_IP6_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_SEC_IP6_SET, SW_SEC_IP6, 4, SW_PARAM_IN, "IP6 related normalized item"), \
    SW_PARAM_DEF(SW_API_SEC_IP6_SET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_IN, "NormVal"),

#define SW_API_SEC_IP6_GET_DESC \
    SW_PARAM_DEF(SW_API_SEC_IP6_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_SEC_IP6_GET, SW_SEC_IP6, 4, SW_PARAM_IN, "IP6 related normalized item"), \
    SW_PARAM_DEF(SW_API_SEC_IP6_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "NormVal"),

#define SW_API_SEC_TCP_SET_DESC \
    SW_PARAM_DEF(SW_API_SEC_TCP_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_SEC_TCP_SET, SW_SEC_TCP, 4, SW_PARAM_IN, "TCP related normalized item"), \
    SW_PARAM_DEF(SW_API_SEC_TCP_SET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_IN, "NormVal"),

#define SW_API_SEC_TCP_GET_DESC \
    SW_PARAM_DEF(SW_API_SEC_TCP_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_SEC_TCP_GET, SW_SEC_TCP, 4, SW_PARAM_IN, "TCP related normalized item"), \
    SW_PARAM_DEF(SW_API_SEC_TCP_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "NormVal"),

#define SW_API_SEC_UDP_SET_DESC \
    SW_PARAM_DEF(SW_API_SEC_UDP_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_SEC_UDP_SET, SW_SEC_UDP, 4, SW_PARAM_IN, "UDP related normalized item"), \
    SW_PARAM_DEF(SW_API_SEC_UDP_SET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_IN, "NormVal"),

#define SW_API_SEC_UDP_GET_DESC \
    SW_PARAM_DEF(SW_API_SEC_UDP_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_SEC_UDP_GET, SW_SEC_UDP, 4, SW_PARAM_IN, "UDP related normalized item"), \
    SW_PARAM_DEF(SW_API_SEC_UDP_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "NormVal"),

#define SW_API_SEC_ICMP4_SET_DESC \
    SW_PARAM_DEF(SW_API_SEC_ICMP4_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_SEC_ICMP4_SET, SW_SEC_ICMP4, 4, SW_PARAM_IN, "ICMP4 related normalized item"), \
    SW_PARAM_DEF(SW_API_SEC_ICMP4_SET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_IN, "NormVal"),

#define SW_API_SEC_ICMP4_GET_DESC \
    SW_PARAM_DEF(SW_API_SEC_ICMP4_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_SEC_ICMP4_GET, SW_SEC_ICMP4, 4, SW_PARAM_IN, "ICMP4 related normalized item"), \
    SW_PARAM_DEF(SW_API_SEC_ICMP4_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "NormVal"),

#define SW_API_SEC_ICMP6_SET_DESC \
    SW_PARAM_DEF(SW_API_SEC_ICMP6_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_SEC_ICMP6_SET, SW_SEC_ICMP6, 4, SW_PARAM_IN, "ICMP6 related normalized item"), \
    SW_PARAM_DEF(SW_API_SEC_ICMP6_SET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_IN, "NormVal"),

#define SW_API_SEC_ICMP6_GET_DESC \
    SW_PARAM_DEF(SW_API_SEC_ICMP6_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_SEC_ICMP6_GET, SW_SEC_ICMP6, 4, SW_PARAM_IN, "ICMP6 related normalized item"), \
    SW_PARAM_DEF(SW_API_SEC_ICMP6_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "NormVal"),

#define SW_API_SEC_L3_PARSER_CTRL_GET_DESC \
    SW_PARAM_DEF(SW_API_SEC_L3_PARSER_CTRL_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_SEC_L3_PARSER_CTRL_GET, SW_L3_PARSER, sizeof(fal_l3_excep_parser_ctrl), SW_PARAM_PTR|SW_PARAM_OUT, "L3Parser"),

#define SW_API_SEC_L3_PARSER_CTRL_SET_DESC \
    SW_PARAM_DEF(SW_API_SEC_L3_PARSER_CTRL_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_SEC_L3_PARSER_CTRL_SET, SW_L3_PARSER, sizeof(fal_l3_excep_parser_ctrl), SW_PARAM_PTR|SW_PARAM_IN, "L3Parser"),

#define SW_API_SEC_L4_PARSER_CTRL_GET_DESC \
    SW_PARAM_DEF(SW_API_SEC_L4_PARSER_CTRL_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_SEC_L4_PARSER_CTRL_GET, SW_L4_PARSER, sizeof(fal_l4_excep_parser_ctrl), SW_PARAM_PTR|SW_PARAM_OUT, "L4Parser"),

#define SW_API_SEC_L4_PARSER_CTRL_SET_DESC \
    SW_PARAM_DEF(SW_API_SEC_L4_PARSER_CTRL_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_SEC_L4_PARSER_CTRL_SET, SW_L4_PARSER, sizeof(fal_l4_excep_parser_ctrl), SW_PARAM_PTR|SW_PARAM_IN, "L4Parser"),

#define SW_API_SEC_EXP_CTRL_GET_DESC \
    SW_PARAM_DEF(SW_API_SEC_EXP_CTRL_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_SEC_EXP_CTRL_GET, SW_UINT32, 4, SW_PARAM_IN, "ExpType"),   \
    SW_PARAM_DEF(SW_API_SEC_EXP_CTRL_GET, SW_EXP_CTRL, sizeof(fal_l3_excep_ctrl_t), SW_PARAM_PTR|SW_PARAM_OUT, "ExpCtrl"),

#define SW_API_SEC_EXP_CTRL_SET_DESC \
    SW_PARAM_DEF(SW_API_SEC_EXP_CTRL_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_SEC_EXP_CTRL_SET, SW_UINT32, 4, SW_PARAM_IN, "ExpType"),   \
    SW_PARAM_DEF(SW_API_SEC_EXP_CTRL_SET, SW_EXP_CTRL, sizeof(fal_l3_excep_ctrl_t), SW_PARAM_PTR|SW_PARAM_IN, "ExpCtrl"),

#define SW_API_SEC_L2_EXP_CTRL_SET_DESC \
    SW_PARAM_DEF(SW_API_SEC_L2_EXP_CTRL_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_SEC_L2_EXP_CTRL_SET, SW_UINT32, 4, SW_PARAM_IN, "L2ExpType"),   \
    SW_PARAM_DEF(SW_API_SEC_L2_EXP_CTRL_SET, SW_L2_EXP_CTRL, \
            sizeof(fal_l2_excep_ctrl_t), SW_PARAM_PTR|SW_PARAM_IN, "L2ExpCtrl"),

#define SW_API_SEC_L2_EXP_CTRL_GET_DESC \
    SW_PARAM_DEF(SW_API_SEC_L2_EXP_CTRL_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_SEC_L2_EXP_CTRL_GET, SW_UINT32, 4, SW_PARAM_IN, "L2ExpType"),   \
    SW_PARAM_DEF(SW_API_SEC_L2_EXP_CTRL_GET, SW_L2_EXP_CTRL, \
            sizeof(fal_l2_excep_ctrl_t), SW_PARAM_PTR|SW_PARAM_OUT, "L2ExpCtrl"),

#define SW_API_SEC_TUNNEL_EXP_CTRL_SET_DESC \
    SW_PARAM_DEF(SW_API_SEC_TUNNEL_EXP_CTRL_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_SEC_TUNNEL_EXP_CTRL_SET, SW_UINT32, 4, SW_PARAM_IN, "TunnelExpType"),   \
    SW_PARAM_DEF(SW_API_SEC_TUNNEL_EXP_CTRL_SET, SW_TUNNEL_EXP_CTRL, \
            sizeof(fal_tunnel_excep_ctrl_t), SW_PARAM_PTR|SW_PARAM_IN, "TunnelExpCtrl"),

#define SW_API_SEC_TUNNEL_EXP_CTRL_GET_DESC \
    SW_PARAM_DEF(SW_API_SEC_TUNNEL_EXP_CTRL_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_SEC_TUNNEL_EXP_CTRL_GET, SW_UINT32, 4, SW_PARAM_IN, "TunnelExpType"),   \
    SW_PARAM_DEF(SW_API_SEC_TUNNEL_EXP_CTRL_GET, SW_TUNNEL_EXP_CTRL, \
            sizeof(fal_tunnel_excep_ctrl_t), SW_PARAM_PTR|SW_PARAM_OUT, "TunnelExpCtrl"),

#define SW_API_SEC_TUNNEL_L3_PARSER_CTRL_SET_DESC \
    SW_PARAM_DEF(SW_API_SEC_TUNNEL_L3_PARSER_CTRL_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_SEC_TUNNEL_L3_PARSER_CTRL_SET, SW_L3_PARSER, \
            sizeof(fal_l3_excep_parser_ctrl), SW_PARAM_PTR|SW_PARAM_IN, "L3Parser"),

#define SW_API_SEC_TUNNEL_L3_PARSER_CTRL_GET_DESC \
    SW_PARAM_DEF(SW_API_SEC_TUNNEL_L3_PARSER_CTRL_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_SEC_TUNNEL_L3_PARSER_CTRL_GET, SW_L3_PARSER, \
            sizeof(fal_l3_excep_parser_ctrl), SW_PARAM_PTR|SW_PARAM_OUT, "L3Parser"),

#define SW_API_SEC_TUNNEL_L4_PARSER_CTRL_SET_DESC \
    SW_PARAM_DEF(SW_API_SEC_TUNNEL_L4_PARSER_CTRL_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_SEC_TUNNEL_L4_PARSER_CTRL_SET, SW_L4_PARSER, \
            sizeof(fal_l4_excep_parser_ctrl), SW_PARAM_PTR|SW_PARAM_IN, "L4Parser"),

#define SW_API_SEC_TUNNEL_L4_PARSER_CTRL_GET_DESC \
    SW_PARAM_DEF(SW_API_SEC_TUNNEL_L4_PARSER_CTRL_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_SEC_TUNNEL_L4_PARSER_CTRL_GET, SW_L4_PARSER, \
            sizeof(fal_l4_excep_parser_ctrl), SW_PARAM_PTR|SW_PARAM_OUT, "L4Parser"),

#define SW_API_SEC_TUNNEL_FLAGS_PARSER_CTRL_SET_DESC \
    SW_PARAM_DEF(SW_API_SEC_TUNNEL_FLAGS_PARSER_CTRL_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_SEC_TUNNEL_FLAGS_PARSER_CTRL_SET, SW_UINT32, 4, SW_PARAM_IN, "Entry index"),   \
    SW_PARAM_DEF(SW_API_SEC_TUNNEL_FLAGS_PARSER_CTRL_SET, SW_TUNNEL_FLAGS_PARSER, \
            sizeof(fal_tunnel_flags_excep_parser_ctrl_t), SW_PARAM_PTR|SW_PARAM_IN, "TunnelFlagsParser"),

#define SW_API_SEC_TUNNEL_FLAGS_PARSER_CTRL_GET_DESC \
    SW_PARAM_DEF(SW_API_SEC_TUNNEL_FLAGS_PARSER_CTRL_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_SEC_TUNNEL_FLAGS_PARSER_CTRL_GET, SW_UINT32, 4, SW_PARAM_IN, "Entry index"),   \
    SW_PARAM_DEF(SW_API_SEC_TUNNEL_FLAGS_PARSER_CTRL_GET, SW_TUNNEL_FLAGS_PARSER, \
            sizeof(fal_tunnel_flags_excep_parser_ctrl_t), SW_PARAM_PTR|SW_PARAM_OUT, "TunnelFlagsParser"),

#define SW_API_IP_HOST_ADD_DESC \
    SW_PARAM_DEF(SW_API_IP_HOST_ADD, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_IP_HOST_ADD, SW_IP_HOSTENTRY, sizeof(fal_host_entry_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Hostentry"),

#define SW_API_IP_HOST_DEL_DESC \
    SW_PARAM_DEF(SW_API_IP_HOST_DEL, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_IP_HOST_DEL, SW_UINT32, 4, SW_PARAM_IN, "DelMode"),  \
    SW_PARAM_DEF(SW_API_IP_HOST_DEL, SW_IP_HOSTENTRY, sizeof(fal_host_entry_t), SW_PARAM_PTR|SW_PARAM_IN, "Hostentry"),

#define SW_API_IP_HOST_GET_DESC \
    SW_PARAM_DEF(SW_API_IP_HOST_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_IP_HOST_GET, SW_UINT32, 4, SW_PARAM_IN, "GetMode"),  \
    SW_PARAM_DEF(SW_API_IP_HOST_GET, SW_IP_HOSTENTRY, sizeof(fal_host_entry_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Hostentry"),

#define SW_API_IP_HOST_NEXT_DESC \
    SW_PARAM_DEF(SW_API_IP_HOST_NEXT, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_IP_HOST_NEXT, SW_UINT32, 4, SW_PARAM_IN, "NextMode"),  \
    SW_PARAM_DEF(SW_API_IP_HOST_NEXT, SW_IP_HOSTENTRY, sizeof(fal_host_entry_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Hostentry"),

#define SW_API_IP_HOST_COUNTER_BIND_DESC \
    SW_PARAM_DEF(SW_API_IP_HOST_COUNTER_BIND, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_IP_HOST_COUNTER_BIND, SW_UINT32, 4, SW_PARAM_IN, "EntryID"),  \
    SW_PARAM_DEF(SW_API_IP_HOST_COUNTER_BIND, SW_UINT32, 4, SW_PARAM_IN, "CounterID"),\
    SW_PARAM_DEF(SW_API_IP_HOST_COUNTER_BIND, SW_ENABLE, 4, SW_PARAM_IN, "Enable"),

#define SW_API_IP_HOST_PPPOE_BIND_DESC \
    SW_PARAM_DEF(SW_API_IP_HOST_PPPOE_BIND, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_HOST_PPPOE_BIND, SW_UINT32, 4, SW_PARAM_IN, "EntryID"), \
    SW_PARAM_DEF(SW_API_IP_HOST_PPPOE_BIND, SW_UINT32, 4, SW_PARAM_IN, "PPPoEID"), \
    SW_PARAM_DEF(SW_API_IP_HOST_PPPOE_BIND, SW_ENABLE, 4, SW_PARAM_IN, "Enable"),

#define SW_API_IP_PT_ARP_LEARN_SET_DESC \
    SW_PARAM_DEF(SW_API_IP_PT_ARP_LEARN_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_PT_ARP_LEARN_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_IP_PT_ARP_LEARN_SET, SW_UINT32, 4, SW_PARAM_IN, "LearnStatus"),

#define SW_API_IP_PT_ARP_LEARN_GET_DESC \
    SW_PARAM_DEF(SW_API_IP_PT_ARP_LEARN_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_PT_ARP_LEARN_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_IP_PT_ARP_LEARN_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "LearnStatus"),

#define SW_API_IP_ARP_LEARN_SET_DESC \
    SW_PARAM_DEF(SW_API_IP_ARP_LEARN_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_ARP_LEARN_SET, SW_ARP_LEARNMODE, sizeof(fal_arp_learn_mode_t), SW_PARAM_IN, "LearnMode"),

#define SW_API_IP_ARP_LEARN_GET_DESC \
    SW_PARAM_DEF(SW_API_IP_ARP_LEARN_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_ARP_LEARN_GET, SW_ARP_LEARNMODE, sizeof(fal_arp_learn_mode_t), SW_PARAM_PTR|SW_PARAM_OUT, "LearnMode"),

#define SW_API_IP_SOURCE_GUARD_SET_DESC \
    SW_PARAM_DEF(SW_API_IP_SOURCE_GUARD_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_SOURCE_GUARD_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_IP_SOURCE_GUARD_SET, SW_IP_GUARDMODE, sizeof(fal_source_guard_mode_t), SW_PARAM_IN, "GuardMode"),

#define SW_API_IP_SOURCE_GUARD_GET_DESC \
    SW_PARAM_DEF(SW_API_IP_SOURCE_GUARD_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_SOURCE_GUARD_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_IP_SOURCE_GUARD_GET, SW_IP_GUARDMODE, sizeof(fal_source_guard_mode_t), SW_PARAM_PTR|SW_PARAM_OUT, "GuardMode"),

#define SW_API_IP_ARP_GUARD_SET_DESC \
    SW_PARAM_DEF(SW_API_IP_ARP_GUARD_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_ARP_GUARD_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_IP_ARP_GUARD_SET, SW_IP_GUARDMODE, sizeof(fal_source_guard_mode_t), SW_PARAM_IN, "GuardMode"),

#define SW_API_IP_ARP_GUARD_GET_DESC \
    SW_PARAM_DEF(SW_API_IP_ARP_GUARD_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_ARP_GUARD_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_IP_ARP_GUARD_GET, SW_IP_GUARDMODE, sizeof(fal_source_guard_mode_t), SW_PARAM_PTR|SW_PARAM_OUT, "GuardMode"),

#define SW_API_IP_ROUTE_STATUS_SET_DESC \
    SW_PARAM_DEF(SW_API_IP_ROUTE_STATUS_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_ROUTE_STATUS_SET, SW_ENABLE, 4, SW_PARAM_IN, "Status"),

#define SW_API_IP_ROUTE_STATUS_GET_DESC \
    SW_PARAM_DEF(SW_API_IP_ROUTE_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_ROUTE_STATUS_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Status"),

#define SW_API_IP_INTF_ENTRY_ADD_DESC \
    SW_PARAM_DEF(SW_API_IP_INTF_ENTRY_ADD, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_INTF_ENTRY_ADD, SW_INTFMACENTRY, sizeof(fal_intf_mac_entry_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Entry"),

#define SW_API_IP_INTF_ENTRY_DEL_DESC \
    SW_PARAM_DEF(SW_API_IP_INTF_ENTRY_DEL, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_INTF_ENTRY_DEL, SW_UINT32, 4, SW_PARAM_IN, "Del Mode"),  \
    SW_PARAM_DEF(SW_API_IP_INTF_ENTRY_DEL, SW_INTFMACENTRY, sizeof(fal_intf_mac_entry_t), SW_PARAM_PTR|SW_PARAM_IN, "Entry"),

#define SW_API_IP_INTF_ENTRY_NEXT_DESC \
    SW_PARAM_DEF(SW_API_IP_INTF_ENTRY_NEXT, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_INTF_ENTRY_NEXT, SW_UINT32, 4, SW_PARAM_IN, "Next Mode"),  \
    SW_PARAM_DEF(SW_API_IP_INTF_ENTRY_NEXT, SW_INTFMACENTRY, sizeof(fal_intf_mac_entry_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Entry"),

#define SW_API_IP_UNK_SOURCE_CMD_SET_DESC \
    SW_PARAM_DEF(SW_API_IP_UNK_SOURCE_CMD_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_IP_UNK_SOURCE_CMD_SET, SW_MACCMD, sizeof(fal_fwd_cmd_t), SW_PARAM_IN, "Forwarding"),

#define SW_API_IP_UNK_SOURCE_CMD_GET_DESC \
    SW_PARAM_DEF(SW_API_IP_UNK_SOURCE_CMD_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_IP_UNK_SOURCE_CMD_GET, SW_MACCMD, sizeof(fal_fwd_cmd_t), SW_PARAM_PTR|SW_PARAM_OUT, "Forwarding"),

#define SW_API_ARP_UNK_SOURCE_CMD_SET_DESC \
    SW_PARAM_DEF(SW_API_ARP_UNK_SOURCE_CMD_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_ARP_UNK_SOURCE_CMD_SET, SW_MACCMD, sizeof(fal_fwd_cmd_t), SW_PARAM_IN, "Forwarding"),

#define SW_API_ARP_UNK_SOURCE_CMD_GET_DESC \
    SW_PARAM_DEF(SW_API_ARP_UNK_SOURCE_CMD_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_ARP_UNK_SOURCE_CMD_GET, SW_MACCMD, sizeof(fal_fwd_cmd_t), SW_PARAM_PTR|SW_PARAM_OUT, "Forwarding"),

#define SW_API_IP_AGE_TIME_SET_DESC \
    SW_PARAM_DEF(SW_API_IP_AGE_TIME_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_IP_AGE_TIME_SET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Time"),

#define SW_API_IP_AGE_TIME_GET_DESC \
    SW_PARAM_DEF(SW_API_IP_AGE_TIME_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_IP_AGE_TIME_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Time"),

#define SW_API_WCMP_HASH_MODE_SET_DESC \
    SW_PARAM_DEF(SW_API_WCMP_HASH_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_WCMP_HASH_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Hash Mode"),

#define SW_API_WCMP_HASH_MODE_GET_DESC \
    SW_PARAM_DEF(SW_API_WCMP_HASH_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_WCMP_HASH_MODE_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Hash Mode"),

#define SW_API_IP_VRF_BASE_ADDR_SET_DESC \
    SW_PARAM_DEF(SW_API_IP_VRF_BASE_ADDR_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_VRF_BASE_ADDR_SET, SW_UINT32, 4, SW_PARAM_IN, "VRF ID"), \
    SW_PARAM_DEF(SW_API_IP_VRF_BASE_ADDR_SET, SW_IP4ADDR, sizeof(fal_ip4_addr_t), SW_PARAM_IN, "BaseAddr"),

#define SW_API_IP_VRF_BASE_ADDR_GET_DESC \
    SW_PARAM_DEF(SW_API_IP_VRF_BASE_ADDR_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_VRF_BASE_ADDR_GET, SW_UINT32, 4, SW_PARAM_IN, "VRF ID"), \
    SW_PARAM_DEF(SW_API_IP_VRF_BASE_ADDR_GET, SW_IP4ADDR, sizeof(fal_ip4_addr_t), SW_PARAM_PTR|SW_PARAM_OUT, "BaseAddr"),

#define SW_API_IP_VRF_BASE_MASK_SET_DESC \
    SW_PARAM_DEF(SW_API_IP_VRF_BASE_MASK_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_VRF_BASE_MASK_SET, SW_UINT32, 4, SW_PARAM_IN, "VRF ID"), \
    SW_PARAM_DEF(SW_API_IP_VRF_BASE_MASK_SET, SW_IP4ADDR, sizeof(fal_ip4_addr_t), SW_PARAM_IN, "BaseMask"),

#define SW_API_IP_VRF_BASE_MASK_GET_DESC \
    SW_PARAM_DEF(SW_API_IP_VRF_BASE_MASK_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_VRF_BASE_MASK_GET, SW_UINT32, 4, SW_PARAM_IN, "VRF ID"), \
    SW_PARAM_DEF(SW_API_IP_VRF_BASE_MASK_GET, SW_IP4ADDR, sizeof(fal_ip4_addr_t), SW_PARAM_PTR|SW_PARAM_OUT, "BaseMask"),

#define SW_API_IP_DEFAULT_ROUTE_SET_DESC \
    SW_PARAM_DEF(SW_API_IP_DEFAULT_ROUTE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_DEFAULT_ROUTE_SET, SW_UINT32, 4, SW_PARAM_IN, "DefaultRoute ID"), \
    SW_PARAM_DEF(SW_API_IP_DEFAULT_ROUTE_SET, SW_DEFAULT_ROUTE_ENTRY, sizeof(fal_default_route_t), SW_PARAM_PTR|SW_PARAM_IN, "DefaultRoute"),

#define SW_API_IP_DEFAULT_ROUTE_GET_DESC \
    SW_PARAM_DEF(SW_API_IP_DEFAULT_ROUTE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_DEFAULT_ROUTE_GET, SW_UINT32, 4, SW_PARAM_IN, "DefaultRoute ID"), \
    SW_PARAM_DEF(SW_API_IP_DEFAULT_ROUTE_GET, SW_DEFAULT_ROUTE_ENTRY, sizeof(fal_default_route_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "DefaultRoute"),

#define SW_API_IP_HOST_ROUTE_SET_DESC \
    SW_PARAM_DEF(SW_API_IP_HOST_ROUTE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_HOST_ROUTE_SET, SW_UINT32, 4, SW_PARAM_IN, "HostRoute ID"), \
    SW_PARAM_DEF(SW_API_IP_HOST_ROUTE_SET, SW_HOST_ROUTE_ENTRY, sizeof(fal_host_route_t), SW_PARAM_PTR|SW_PARAM_IN, "HostRoute"),

#define SW_API_IP_HOST_ROUTE_GET_DESC \
    SW_PARAM_DEF(SW_API_IP_HOST_ROUTE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_HOST_ROUTE_GET, SW_UINT32, 4, SW_PARAM_IN, "HostRoute ID"), \
    SW_PARAM_DEF(SW_API_IP_HOST_ROUTE_GET, SW_HOST_ROUTE_ENTRY, sizeof(fal_host_route_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "HostRoute"),

#define SW_API_IP_WCMP_ENTRY_SET_DESC \
    SW_PARAM_DEF(SW_API_IP_WCMP_ENTRY_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_WCMP_ENTRY_SET, SW_UINT32, 4, SW_PARAM_IN, "Wcmp ID"), \
    SW_PARAM_DEF(SW_API_IP_WCMP_ENTRY_SET, SW_IP_WCMP_ENTRY, sizeof(fal_ip_wcmp_t), SW_PARAM_PTR|SW_PARAM_IN, "WcmpEntry"),

#define SW_API_IP_WCMP_ENTRY_GET_DESC \
    SW_PARAM_DEF(SW_API_IP_WCMP_ENTRY_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_WCMP_ENTRY_GET, SW_UINT32, 4, SW_PARAM_IN, "Wcmp ID"), \
    SW_PARAM_DEF(SW_API_IP_WCMP_ENTRY_GET, SW_IP_WCMP_ENTRY, sizeof(fal_ip_wcmp_t), SW_PARAM_PTR|SW_PARAM_OUT, "WcmpEntry"),

#define SW_API_IP_RFS_IP4_SET_DESC \
    SW_PARAM_DEF(SW_API_IP_RFS_IP4_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_RFS_IP4_SET, SW_IP_RFS_IP4, sizeof(fal_ip4_rfs_t), SW_PARAM_PTR|SW_PARAM_IN, "RfsIp4"),

#define SW_API_IP_RFS_IP6_SET_DESC \
    SW_PARAM_DEF(SW_API_IP_RFS_IP6_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_RFS_IP6_SET, SW_IP_RFS_IP6, sizeof(fal_ip6_rfs_t), SW_PARAM_PTR|SW_PARAM_IN, "RfsIp6"),

#define SW_API_IP_RFS_IP4_DEL_DESC \
    SW_PARAM_DEF(SW_API_IP_RFS_IP4_DEL, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_RFS_IP4_DEL, SW_IP_RFS_IP4, sizeof(fal_ip4_rfs_t), SW_PARAM_PTR|SW_PARAM_IN, "RfsIp4"),

#define SW_API_IP_RFS_IP6_DEL_DESC \
    SW_PARAM_DEF(SW_API_IP_RFS_IP6_DEL, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_RFS_IP6_DEL, SW_IP_RFS_IP6, sizeof(fal_ip6_rfs_t), SW_PARAM_PTR|SW_PARAM_IN, "RfsIp6"),

#define SW_API_IP_DEFAULT_FLOW_CMD_SET_DESC \
    SW_PARAM_DEF(SW_API_IP_DEFAULT_FLOW_CMD_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_DEFAULT_FLOW_CMD_SET, SW_UINT32, 4, SW_PARAM_IN, "Vrf ID"), \
    SW_PARAM_DEF(SW_API_IP_DEFAULT_FLOW_CMD_SET, SW_FLOWTYPE, sizeof(fal_flow_type_t), SW_PARAM_IN, "FlowType"), \
    SW_PARAM_DEF(SW_API_IP_DEFAULT_FLOW_CMD_SET, SW_FLOWCMD, sizeof(fal_default_flow_cmd_t), SW_PARAM_IN, "FlowCmd"),

#define SW_API_IP_DEFAULT_FLOW_CMD_GET_DESC \
    SW_PARAM_DEF(SW_API_IP_DEFAULT_FLOW_CMD_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_DEFAULT_FLOW_CMD_GET, SW_UINT32, 4, SW_PARAM_IN, "Vrf ID"), \
    SW_PARAM_DEF(SW_API_IP_DEFAULT_FLOW_CMD_GET, SW_FLOWTYPE, sizeof(fal_flow_type_t), SW_PARAM_IN, "FlowType"), \
    SW_PARAM_DEF(SW_API_IP_DEFAULT_FLOW_CMD_GET, SW_FLOWCMD, sizeof(fal_default_flow_cmd_t), SW_PARAM_PTR|SW_PARAM_OUT, "FlowCmd"),

#define SW_API_IP_DEFAULT_RT_FLOW_CMD_SET_DESC \
    SW_PARAM_DEF(SW_API_IP_DEFAULT_RT_FLOW_CMD_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_DEFAULT_RT_FLOW_CMD_SET, SW_UINT32, 4, SW_PARAM_IN, "Vrf ID"), \
    SW_PARAM_DEF(SW_API_IP_DEFAULT_RT_FLOW_CMD_SET, SW_FLOWTYPE, sizeof(fal_flow_type_t), SW_PARAM_IN, "FlowType"), \
    SW_PARAM_DEF(SW_API_IP_DEFAULT_RT_FLOW_CMD_SET, SW_FLOWCMD, sizeof(fal_default_flow_cmd_t), SW_PARAM_IN, "FlowCmd"),

#define SW_API_IP_DEFAULT_RT_FLOW_CMD_GET_DESC \
    SW_PARAM_DEF(SW_API_IP_DEFAULT_RT_FLOW_CMD_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_DEFAULT_RT_FLOW_CMD_GET, SW_UINT32, 4, SW_PARAM_IN, "Vrf ID"), \
    SW_PARAM_DEF(SW_API_IP_DEFAULT_RT_FLOW_CMD_GET, SW_FLOWTYPE, sizeof(fal_flow_type_t), SW_PARAM_IN, "FlowType"), \
    SW_PARAM_DEF(SW_API_IP_DEFAULT_RT_FLOW_CMD_GET, SW_FLOWCMD, sizeof(fal_default_flow_cmd_t), SW_PARAM_PTR|SW_PARAM_OUT, "FlowCmd"),

#define SW_API_IP_VIS_ARP_SG_CFG_GET_DESC \
    SW_PARAM_DEF(SW_API_IP_VIS_ARP_SG_CFG_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_VIS_ARP_SG_CFG_GET, SW_UINT32, 4, SW_PARAM_IN, "VSI ID"), \
    SW_PARAM_DEF(SW_API_IP_VIS_ARP_SG_CFG_GET, SW_ARP_SG_CFG, sizeof(fal_arp_sg_cfg_t), SW_PARAM_PTR|SW_PARAM_OUT, "ArpSg"),

#define SW_API_IP_VIS_ARP_SG_CFG_SET_DESC \
    SW_PARAM_DEF(SW_API_IP_VIS_ARP_SG_CFG_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_VIS_ARP_SG_CFG_SET, SW_UINT32, 4, SW_PARAM_IN, "VSI ID"), \
    SW_PARAM_DEF(SW_API_IP_VIS_ARP_SG_CFG_SET, SW_ARP_SG_CFG, sizeof(fal_arp_sg_cfg_t), SW_PARAM_PTR|SW_PARAM_IN, "ArpSg"),

#define SW_API_IP_NETWORK_ROUTE_GET_DESC \
    SW_PARAM_DEF(SW_API_IP_NETWORK_ROUTE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_NETWORK_ROUTE_GET, SW_UINT32, 4, SW_PARAM_IN, "Index"), \
    SW_PARAM_DEF(SW_API_IP_NETWORK_ROUTE_GET, SW_UINT8, 1, SW_PARAM_IN, "Type"), \
    SW_PARAM_DEF(SW_API_IP_NETWORK_ROUTE_GET, SW_IP_NETWORK_ROUTE, sizeof(fal_network_route_entry_t), SW_PARAM_PTR|SW_PARAM_OUT, "NetworkRoute"),

#define SW_API_IP_NETWORK_ROUTE_ADD_DESC \
    SW_PARAM_DEF(SW_API_IP_NETWORK_ROUTE_ADD, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_NETWORK_ROUTE_ADD, SW_UINT32, 4, SW_PARAM_IN, "Index"), \
    SW_PARAM_DEF(SW_API_IP_NETWORK_ROUTE_ADD, SW_IP_NETWORK_ROUTE, sizeof(fal_network_route_entry_t), SW_PARAM_PTR|SW_PARAM_IN, "NetworkRoute"),

#define SW_API_IP_INTF_GET_DESC \
    SW_PARAM_DEF(SW_API_IP_INTF_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_INTF_GET, SW_UINT32, 4, SW_PARAM_IN, "Index"), \
    SW_PARAM_DEF(SW_API_IP_INTF_GET, SW_IP_INTF, sizeof(fal_intf_entry_t), SW_PARAM_PTR|SW_PARAM_OUT, "INTF"),

#define SW_API_IP_INTF_SET_DESC \
    SW_PARAM_DEF(SW_API_IP_INTF_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_INTF_SET, SW_UINT32, 4, SW_PARAM_IN, "Index"), \
    SW_PARAM_DEF(SW_API_IP_INTF_SET, SW_IP_INTF, sizeof(fal_intf_entry_t), SW_PARAM_PTR|SW_PARAM_IN, "INTF"),

#define SW_API_IP_VSI_INTF_GET_DESC \
    SW_PARAM_DEF(SW_API_IP_VSI_INTF_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_VSI_INTF_GET, SW_UINT32, 4, SW_PARAM_IN, "vSI"), \
    SW_PARAM_DEF(SW_API_IP_VSI_INTF_GET, SW_IP_VSI_INTF, sizeof(fal_intf_id_t), SW_PARAM_PTR|SW_PARAM_OUT, "VsiIntf"),

#define SW_API_IP_VSI_INTF_SET_DESC \
    SW_PARAM_DEF(SW_API_IP_VSI_INTF_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_VSI_INTF_SET, SW_UINT32, 4, SW_PARAM_IN, "Vsi"), \
    SW_PARAM_DEF(SW_API_IP_VSI_INTF_SET, SW_IP_VSI_INTF, sizeof(fal_intf_id_t), SW_PARAM_PTR|SW_PARAM_IN, "VsiIntf"),

#define SW_API_IP_PORT_INTF_GET_DESC \
    SW_PARAM_DEF(SW_API_IP_PORT_INTF_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_PORT_INTF_GET, SW_UINT32, 4, SW_PARAM_IN, "port"), \
    SW_PARAM_DEF(SW_API_IP_PORT_INTF_GET, SW_IP_VSI_INTF, sizeof(fal_intf_id_t), SW_PARAM_PTR|SW_PARAM_OUT, "PortIntf"),

#define SW_API_IP_PORT_INTF_SET_DESC \
    SW_PARAM_DEF(SW_API_IP_PORT_INTF_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_PORT_INTF_SET, SW_UINT32, 4, SW_PARAM_IN, "Port"), \
    SW_PARAM_DEF(SW_API_IP_PORT_INTF_SET, SW_IP_VSI_INTF, sizeof(fal_intf_id_t), SW_PARAM_PTR|SW_PARAM_IN, "PortIntf"),

#define SW_API_IP_NEXTHOP_GET_DESC \
    SW_PARAM_DEF(SW_API_IP_NEXTHOP_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_NEXTHOP_GET, SW_UINT32, 4, SW_PARAM_IN, "index"), \
    SW_PARAM_DEF(SW_API_IP_NEXTHOP_GET, SW_IP_NEXTHOP, sizeof(fal_ip_nexthop_t), SW_PARAM_PTR|SW_PARAM_OUT, "Nexthop"),

#define SW_API_IP_NEXTHOP_SET_DESC \
    SW_PARAM_DEF(SW_API_IP_NEXTHOP_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_NEXTHOP_SET, SW_UINT32, 4, SW_PARAM_IN, "index"), \
    SW_PARAM_DEF(SW_API_IP_NEXTHOP_SET, SW_IP_NEXTHOP, sizeof(fal_ip_nexthop_t), SW_PARAM_PTR|SW_PARAM_IN, "Nexthop"),

#define SW_API_IP_VSI_SG_SET_DESC \
    SW_PARAM_DEF(SW_API_IP_VSI_SG_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_VSI_SG_SET, SW_UINT32, 4, SW_PARAM_IN, "vsi"), \
    SW_PARAM_DEF(SW_API_IP_VSI_SG_SET, SW_IP_SG, sizeof(fal_sg_cfg_t), SW_PARAM_PTR|SW_PARAM_IN, "vsisg"),

#define SW_API_IP_VSI_SG_GET_DESC \
    SW_PARAM_DEF(SW_API_IP_VSI_SG_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_VSI_SG_GET, SW_UINT32, 4, SW_PARAM_IN, "vsi"), \
    SW_PARAM_DEF(SW_API_IP_VSI_SG_GET, SW_IP_SG, sizeof(fal_sg_cfg_t), SW_PARAM_PTR|SW_PARAM_OUT, "vsisg"),

#define SW_API_IP_PORT_SG_SET_DESC \
    SW_PARAM_DEF(SW_API_IP_PORT_SG_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_PORT_SG_SET, SW_UINT32, 4, SW_PARAM_IN, "port"), \
    SW_PARAM_DEF(SW_API_IP_PORT_SG_SET, SW_IP_SG, sizeof(fal_sg_cfg_t), SW_PARAM_PTR|SW_PARAM_IN, "portsg"),

#define SW_API_IP_PORT_SG_GET_DESC \
    SW_PARAM_DEF(SW_API_IP_PORT_SG_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_PORT_SG_GET, SW_UINT32, 4, SW_PARAM_IN, "port"), \
    SW_PARAM_DEF(SW_API_IP_PORT_SG_GET, SW_IP_SG, sizeof(fal_sg_cfg_t), SW_PARAM_PTR|SW_PARAM_OUT, "portsg"),

#define SW_API_IP_PUB_IP_SET_DESC \
    SW_PARAM_DEF(SW_API_IP_PUB_IP_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_PUB_IP_SET, SW_UINT32, 4, SW_PARAM_IN, "index"),  \
    SW_PARAM_DEF(SW_API_IP_PUB_IP_SET, SW_IP_PUB, sizeof(fal_ip_pub_addr_t), SW_PARAM_PTR|SW_PARAM_IN, "PubAdd"),

#define SW_API_IP_NETWORK_ROUTE_DEL_DESC \
    SW_PARAM_DEF(SW_API_IP_NETWORK_ROUTE_DEL, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_NETWORK_ROUTE_DEL, SW_UINT32, 4, SW_PARAM_IN, "index"),  \
    SW_PARAM_DEF(SW_API_IP_NETWORK_ROUTE_DEL, SW_UINT8, 1, SW_PARAM_IN, "type"),

#define SW_API_IP_PUB_IP_GET_DESC \
    SW_PARAM_DEF(SW_API_IP_PUB_IP_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_PUB_IP_GET, SW_UINT32, 4, SW_PARAM_IN, "index"),  \
    SW_PARAM_DEF(SW_API_IP_PUB_IP_GET, SW_IP_PUB, sizeof(fal_ip_pub_addr_t), SW_PARAM_PTR|SW_PARAM_OUT, "PubGet"),

#define SW_API_IP_PORT_MAC_GET_DESC \
    SW_PARAM_DEF(SW_API_IP_PORT_MAC_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_PORT_MAC_GET, SW_UINT32, 4, SW_PARAM_IN, "port"), \
    SW_PARAM_DEF(SW_API_IP_PORT_MAC_GET, SW_IP_PORTMAC, sizeof(fal_macaddr_entry_t), SW_PARAM_PTR|SW_PARAM_OUT, "portmac"),

#define SW_API_IP_PORT_MAC_SET_DESC \
    SW_PARAM_DEF(SW_API_IP_PORT_MAC_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_PORT_MAC_SET, SW_UINT32, 4, SW_PARAM_IN, "port"), \
    SW_PARAM_DEF(SW_API_IP_PORT_MAC_SET, SW_IP_PORTMAC, sizeof(fal_macaddr_entry_t), SW_PARAM_PTR|SW_PARAM_IN, "portmac"),

#define SW_API_IP_ROUTE_MISS_GET_DESC \
    SW_PARAM_DEF(SW_API_IP_ROUTE_MISS_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_ROUTE_MISS_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "cmd"),

#define SW_API_IP_ROUTE_MISS_SET_DESC \
    SW_PARAM_DEF(SW_API_IP_ROUTE_MISS_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_ROUTE_MISS_SET, SW_UINT32, 4, SW_PARAM_IN, "cmd"),

#define SW_API_IP_PORT_ARP_SG_GET_DESC \
    SW_PARAM_DEF(SW_API_IP_PORT_ARP_SG_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_PORT_ARP_SG_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_IP_PORT_ARP_SG_GET, SW_ARP_SG_CFG, \
		    sizeof(fal_arp_sg_cfg_t), SW_PARAM_PTR|SW_PARAM_OUT, "portArpSg"),

#define SW_API_IP_PORT_ARP_SG_SET_DESC \
    SW_PARAM_DEF(SW_API_IP_PORT_ARP_SG_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_PORT_ARP_SG_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_IP_PORT_ARP_SG_SET, SW_ARP_SG_CFG, \
		    sizeof(fal_arp_sg_cfg_t), SW_PARAM_PTR|SW_PARAM_IN, "portArpSg"),

#define SW_API_IP_VSI_MC_MODE_GET_DESC \
    SW_PARAM_DEF(SW_API_IP_VSI_MC_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_VSI_MC_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Vsi"), \
    SW_PARAM_DEF(SW_API_IP_VSI_MC_MODE_GET, SW_IP_MCMODE, \
		    sizeof(fal_mc_mode_cfg_t), SW_PARAM_PTR|SW_PARAM_OUT, "mcmode"),

#define SW_API_IP_VSI_MC_MODE_SET_DESC \
    SW_PARAM_DEF(SW_API_IP_VSI_MC_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_VSI_MC_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Vsi"), \
    SW_PARAM_DEF(SW_API_IP_VSI_MC_MODE_SET, SW_IP_MCMODE, \
		    sizeof(fal_mc_mode_cfg_t), SW_PARAM_PTR|SW_PARAM_IN, "mcmode"),

#define SW_API_GLOBAL_CTRL_SET_DESC \
    SW_PARAM_DEF(SW_API_GLOBAL_CTRL_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_GLOBAL_CTRL_SET, SW_IP_GLOBAL, \
		    sizeof(fal_ip_global_cfg_t), SW_PARAM_PTR|SW_PARAM_IN, "global"),

#define SW_API_GLOBAL_CTRL_GET_DESC \
    SW_PARAM_DEF(SW_API_GLOBAL_CTRL_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_GLOBAL_CTRL_GET, SW_IP_GLOBAL, \
		    sizeof(fal_ip_global_cfg_t), SW_PARAM_PTR|SW_PARAM_OUT, "global"),

#define SW_API_IP_INTF_MTU_MRU_SET_DESC \
    SW_PARAM_DEF(SW_API_IP_INTF_MTU_MRU_SET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_INTF_MTU_MRU_SET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "L3 intf id"), \
    SW_PARAM_DEF(SW_API_IP_INTF_MTU_MRU_SET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "mtu"), \
    SW_PARAM_DEF(SW_API_IP_INTF_MTU_MRU_SET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "mru"),

#define SW_API_IP_INTF_MTU_MRU_GET_DESC \
    SW_PARAM_DEF(SW_API_IP_INTF_MTU_MRU_GET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_INTF_MTU_MRU_GET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "L3 intf id"), \
    SW_PARAM_DEF(SW_API_IP_INTF_MTU_MRU_GET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_PTR|SW_PARAM_OUT, "mtu"), \
    SW_PARAM_DEF(SW_API_IP_INTF_MTU_MRU_GET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_PTR|SW_PARAM_OUT, "mru"),

#define SW_API_IP6_INTF_MTU_MRU_SET_DESC \
    SW_PARAM_DEF(SW_API_IP6_INTF_MTU_MRU_SET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP6_INTF_MTU_MRU_SET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "L3 intf id"), \
    SW_PARAM_DEF(SW_API_IP6_INTF_MTU_MRU_SET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "mtu"), \
    SW_PARAM_DEF(SW_API_IP6_INTF_MTU_MRU_SET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "mru"),

#define SW_API_IP6_INTF_MTU_MRU_GET_DESC \
    SW_PARAM_DEF(SW_API_IP6_INTF_MTU_MRU_GET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP6_INTF_MTU_MRU_GET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "L3 intf id"), \
    SW_PARAM_DEF(SW_API_IP6_INTF_MTU_MRU_GET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_PTR|SW_PARAM_OUT, "mtu"), \
    SW_PARAM_DEF(SW_API_IP6_INTF_MTU_MRU_GET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_PTR|SW_PARAM_OUT, "mru"),

#define SW_API_IP_INTF_MACADDR_ADD_DESC \
    SW_PARAM_DEF(SW_API_IP_INTF_MACADDR_ADD, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_INTF_MACADDR_ADD, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "L3 intf id"), \
    SW_PARAM_DEF(SW_API_IP_INTF_MACADDR_ADD, SW_INTF_MAC_ENTRY, \
		    sizeof(fal_intf_macaddr_t), SW_PARAM_PTR|SW_PARAM_IN, "mac entry"),

#define SW_API_IP_INTF_MACADDR_DEL_DESC \
    SW_PARAM_DEF(SW_API_IP_INTF_MACADDR_DEL, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_INTF_MACADDR_DEL, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "L3 intf id"), \
    SW_PARAM_DEF(SW_API_IP_INTF_MACADDR_DEL, SW_INTF_MAC_ENTRY, \
		    sizeof(fal_intf_macaddr_t), SW_PARAM_PTR|SW_PARAM_IN, "mac entry"),

#define SW_API_IP_INTF_MACADDR_GET_FIRST_DESC \
    SW_PARAM_DEF(SW_API_IP_INTF_MACADDR_GET_FIRST, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_INTF_MACADDR_GET_FIRST, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "L3 intf id"), \
    SW_PARAM_DEF(SW_API_IP_INTF_MACADDR_GET_FIRST, SW_INTF_MAC_ENTRY, \
		    sizeof(fal_intf_macaddr_t), SW_PARAM_PTR|SW_PARAM_OUT, "mac entry"),

#define SW_API_IP_INTF_MACADDR_GET_NEXT_DESC \
    SW_PARAM_DEF(SW_API_IP_INTF_MACADDR_GET_NEXT, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_INTF_MACADDR_GET_NEXT, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "L3 intf id"), \
    SW_PARAM_DEF(SW_API_IP_INTF_MACADDR_GET_NEXT, SW_INTF_MAC_ENTRY, \
		    sizeof(fal_intf_macaddr_t), \
		    SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "mac entry"),

#define SW_API_IP_INTF_DMAC_CHECK_SET_DESC \
    SW_PARAM_DEF(SW_API_IP_INTF_DMAC_CHECK_SET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_INTF_DMAC_CHECK_SET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "L3 intf id"), \
    SW_PARAM_DEF(SW_API_IP_INTF_DMAC_CHECK_SET, SW_ENABLE, \
		    sizeof(a_bool_t), SW_PARAM_IN, "enable DMAC check"),

#define SW_API_IP_INTF_DMAC_CHECK_GET_DESC \
    SW_PARAM_DEF(SW_API_IP_INTF_DMAC_CHECK_GET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_IP_INTF_DMAC_CHECK_GET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "L3 intf id"), \
    SW_PARAM_DEF(SW_API_IP_INTF_DMAC_CHECK_GET, SW_ENABLE, \
		    sizeof(a_bool_t), SW_PARAM_PTR|SW_PARAM_OUT, "enable DMAC check"),

#define SW_API_FLOW_STATUS_SET_DESC \
    SW_PARAM_DEF(SW_API_FLOW_STATUS_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_FLOW_STATUS_SET, SW_UINT32, 4, SW_PARAM_IN, "status"),

#define SW_API_FLOW_STATUS_GET_DESC \
    SW_PARAM_DEF(SW_API_FLOW_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_FLOW_STATUS_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "status"),

#define SW_API_FLOW_AGE_TIMER_SET_DESC \
    SW_PARAM_DEF(SW_API_FLOW_AGE_TIMER_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_FLOW_AGE_TIMER_SET, SW_FLOW_AGE, sizeof(fal_flow_age_timer_t), SW_PARAM_PTR|SW_PARAM_IN, "age"),

#define SW_API_FLOW_AGE_TIMER_GET_DESC \
    SW_PARAM_DEF(SW_API_FLOW_AGE_TIMER_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_FLOW_AGE_TIMER_GET, SW_FLOW_AGE, sizeof(fal_flow_age_timer_t), SW_PARAM_PTR|SW_PARAM_OUT, "age"),

#define SW_API_FLOW_CTRL_SET_DESC \
    SW_PARAM_DEF(SW_API_FLOW_CTRL_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_FLOW_CTRL_SET, SW_UINT32, 4, SW_PARAM_IN, "type"),  \
    SW_PARAM_DEF(SW_API_FLOW_CTRL_SET, SW_UINT32, 4, SW_PARAM_IN, "dir"),  \
    SW_PARAM_DEF(SW_API_FLOW_CTRL_SET, SW_FLOW_CTRL, sizeof(fal_flow_mgmt_t), SW_PARAM_PTR|SW_PARAM_IN, "ctrl"),

#define SW_API_FLOW_CTRL_GET_DESC \
    SW_PARAM_DEF(SW_API_FLOW_CTRL_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_FLOW_CTRL_GET, SW_UINT32, 4, SW_PARAM_IN, "type"),  \
    SW_PARAM_DEF(SW_API_FLOW_CTRL_GET, SW_UINT32, 4, SW_PARAM_IN, "dir"),  \
    SW_PARAM_DEF(SW_API_FLOW_CTRL_GET, SW_FLOW_CTRL, sizeof(fal_flow_mgmt_t), SW_PARAM_PTR|SW_PARAM_OUT, "ctrl"),

#define SW_API_FLOW_ENTRY_ADD_DESC \
    SW_PARAM_DEF(SW_API_FLOW_ENTRY_ADD, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_FLOW_ENTRY_ADD, SW_UINT32, 4, SW_PARAM_IN, "add mode"),  \
    SW_PARAM_DEF(SW_API_FLOW_ENTRY_ADD, SW_FLOW_ENTRY, sizeof(fal_flow_entry_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Flowentry"),

#define SW_API_FLOW_ENTRY_DEL_DESC \
    SW_PARAM_DEF(SW_API_FLOW_ENTRY_DEL, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_FLOW_ENTRY_DEL, SW_UINT32, 4, SW_PARAM_IN, "Del mode"),  \
    SW_PARAM_DEF(SW_API_FLOW_ENTRY_DEL, SW_FLOW_ENTRY, sizeof(fal_flow_entry_t), SW_PARAM_PTR|SW_PARAM_IN, "Flowentry"),

#define SW_API_FLOW_ENTRY_GET_DESC \
    SW_PARAM_DEF(SW_API_FLOW_ENTRY_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_FLOW_ENTRY_GET, SW_UINT32, 4, SW_PARAM_IN, "get mode"),  \
    SW_PARAM_DEF(SW_API_FLOW_ENTRY_GET, SW_FLOW_ENTRY, sizeof(fal_flow_entry_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Flowentry"),

#define SW_API_FLOW_HOST_ADD_DESC \
    SW_PARAM_DEF(SW_API_FLOW_HOST_ADD, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_FLOW_HOST_ADD, SW_UINT32, 4, SW_PARAM_IN, "add mode"),  \
    SW_PARAM_DEF(SW_API_FLOW_HOST_ADD, SW_FLOW_HOST, sizeof(fal_flow_host_entry_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Flowhost"),

#define SW_API_FLOW_HOST_DEL_DESC \
    SW_PARAM_DEF(SW_API_FLOW_HOST_DEL, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_FLOW_HOST_DEL, SW_UINT32, 4, SW_PARAM_IN, "Del mode"),  \
    SW_PARAM_DEF(SW_API_FLOW_HOST_DEL, SW_FLOW_HOST, sizeof(fal_flow_host_entry_t), SW_PARAM_PTR|SW_PARAM_IN, "Flowhost"),

#define SW_API_FLOW_HOST_GET_DESC \
    SW_PARAM_DEF(SW_API_FLOW_HOST_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_FLOW_HOST_GET, SW_UINT32, 4, SW_PARAM_IN, "get mode"),  \
    SW_PARAM_DEF(SW_API_FLOW_HOST_GET, SW_FLOW_HOST, sizeof(fal_flow_host_entry_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Flowhost"),

#define SW_API_FLOW_GLOBAL_CFG_GET_DESC \
    SW_PARAM_DEF(SW_API_FLOW_GLOBAL_CFG_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_FLOW_GLOBAL_CFG_GET, SW_FLOW_GLOBAL, sizeof(fal_flow_global_cfg_t), SW_PARAM_PTR|SW_PARAM_OUT, "Flowglobal"),

#define SW_API_FLOW_GLOBAL_CFG_SET_DESC \
    SW_PARAM_DEF(SW_API_FLOW_GLOBAL_CFG_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_FLOW_GLOBAL_CFG_SET, SW_FLOW_GLOBAL, sizeof(fal_flow_global_cfg_t), SW_PARAM_PTR|SW_PARAM_IN, "Flowglobal"),

#define SW_API_FLOWENTRY_NEXT_DESC \
    SW_PARAM_DEF(SW_API_FLOWENTRY_NEXT, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_FLOWENTRY_NEXT, SW_UINT32, 4, SW_PARAM_IN, "Next mode"),  \
    SW_PARAM_DEF(SW_API_FLOWENTRY_NEXT, SW_FLOW_ENTRY, sizeof(fal_flow_entry_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Flowentry"),

#define SW_API_FLOW_COUNTER_GET_DESC \
    SW_PARAM_DEF(SW_API_FLOW_COUNTER_GET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_FLOW_COUNTER_GET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "flow index"),  \
    SW_PARAM_DEF(SW_API_FLOW_COUNTER_GET, SW_ENTRY_COUNTER, \
		    sizeof(fal_entry_counter_t), SW_PARAM_PTR|SW_PARAM_OUT, "Flow entry counter"),

#define SW_API_FLOW_COUNTER_CLEANUP_DESC \
    SW_PARAM_DEF(SW_API_FLOW_COUNTER_CLEANUP, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_FLOW_COUNTER_CLEANUP, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "flow index"),

#define SW_API_FLOW_ENTRY_EN_SET_DESC \
    SW_PARAM_DEF(SW_API_FLOW_ENTRY_EN_SET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_FLOW_ENTRY_EN_SET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "flow index"),  \
    SW_PARAM_DEF(SW_API_FLOW_ENTRY_EN_SET, SW_ENABLE, \
		    sizeof(a_bool_t), SW_PARAM_IN, "Flow entry enable"),

#define SW_API_FLOW_ENTRY_EN_GET_DESC \
    SW_PARAM_DEF(SW_API_FLOW_ENTRY_EN_GET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_FLOW_ENTRY_EN_GET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "flow index"),  \
    SW_PARAM_DEF(SW_API_FLOW_ENTRY_EN_GET, SW_ENABLE, \
		    sizeof(a_bool_t), SW_PARAM_PTR|SW_PARAM_OUT, "Flow entry enable"),

#define SW_API_FLOW_QOS_SET_DESC \
    SW_PARAM_DEF(SW_API_FLOW_QOS_SET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_FLOW_QOS_SET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "flow index"),  \
    SW_PARAM_DEF(SW_API_FLOW_QOS_SET, SW_FLOW_QOS, \
		    sizeof(fal_flow_qos_t), SW_PARAM_PTR|SW_PARAM_IN, "Flow qos"),

#define SW_API_FLOW_QOS_GET_DESC \
    SW_PARAM_DEF(SW_API_FLOW_QOS_GET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_FLOW_QOS_GET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "flow index"),  \
    SW_PARAM_DEF(SW_API_FLOW_QOS_GET, SW_FLOW_QOS, \
		    sizeof(fal_flow_qos_t), SW_PARAM_PTR|SW_PARAM_OUT, "Flow qos"),

#define SW_API_NAT_ADD_DESC \
    SW_PARAM_DEF(SW_API_NAT_ADD, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_NAT_ADD, SW_NATENTRY, sizeof(fal_nat_entry_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Natentry"),

#define SW_API_NAT_DEL_DESC \
    SW_PARAM_DEF(SW_API_NAT_DEL, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_NAT_DEL, SW_UINT32, 4, SW_PARAM_IN, "DelMode"),  \
    SW_PARAM_DEF(SW_API_NAT_DEL, SW_NATENTRY, sizeof(fal_nat_entry_t), SW_PARAM_PTR|SW_PARAM_IN, "Natentry"),

#define SW_API_NAT_GET_DESC \
    SW_PARAM_DEF(SW_API_NAT_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_NAT_GET, SW_UINT32, 4, SW_PARAM_IN, "GetMode"),  \
    SW_PARAM_DEF(SW_API_NAT_GET, SW_NATENTRY, sizeof(fal_nat_entry_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Natentry"),

#define SW_API_NAT_NEXT_DESC \
    SW_PARAM_DEF(SW_API_NAT_NEXT, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_NAT_NEXT, SW_UINT32, 4, SW_PARAM_IN, "NextMode"),  \
    SW_PARAM_DEF(SW_API_NAT_NEXT, SW_NATENTRY, sizeof(fal_nat_entry_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Natentry"),

#define SW_API_NAT_COUNTER_BIND_DESC \
    SW_PARAM_DEF(SW_API_NAT_COUNTER_BIND, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_NAT_COUNTER_BIND, SW_UINT32, 4, SW_PARAM_IN, "EntryID"),  \
    SW_PARAM_DEF(SW_API_NAT_COUNTER_BIND, SW_UINT32, 4, SW_PARAM_IN, "CounterID"),\
    SW_PARAM_DEF(SW_API_NAT_COUNTER_BIND, SW_ENABLE, 4, SW_PARAM_IN, "Enable"),

#define SW_API_NAPT_ADD_DESC \
    SW_PARAM_DEF(SW_API_NAPT_ADD, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_NAPT_ADD, SW_NAPTENTRY, sizeof(fal_napt_entry_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Naptentry"),

#define SW_API_NAPT_DEL_DESC \
    SW_PARAM_DEF(SW_API_NAPT_DEL, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_NAPT_DEL, SW_UINT32, 4, SW_PARAM_IN, "DelMode"),  \
    SW_PARAM_DEF(SW_API_NAPT_DEL, SW_NAPTENTRY, sizeof(fal_napt_entry_t), SW_PARAM_PTR|SW_PARAM_IN, "Naptentry"),

#define SW_API_NAPT_GET_DESC \
    SW_PARAM_DEF(SW_API_NAPT_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_NAPT_GET, SW_UINT32, 4, SW_PARAM_IN, "GetMode"),  \
    SW_PARAM_DEF(SW_API_NAPT_GET, SW_NAPTENTRY, sizeof(fal_napt_entry_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Naptentry"),

#define SW_API_NAPT_NEXT_DESC \
    SW_PARAM_DEF(SW_API_NAPT_NEXT, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_NAPT_NEXT, SW_UINT32, 4, SW_PARAM_IN, "NextMode"),  \
    SW_PARAM_DEF(SW_API_NAPT_NEXT, SW_NAPTENTRY, sizeof(fal_napt_entry_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Naptentry"),

#define SW_API_NAPT_COUNTER_BIND_DESC \
    SW_PARAM_DEF(SW_API_NAPT_COUNTER_BIND, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_NAPT_COUNTER_BIND, SW_UINT32, 4, SW_PARAM_IN, "EntryID"),  \
    SW_PARAM_DEF(SW_API_NAPT_COUNTER_BIND, SW_UINT32, 4, SW_PARAM_IN, "CounterID"),\
    SW_PARAM_DEF(SW_API_NAPT_COUNTER_BIND, SW_ENABLE, 4, SW_PARAM_IN, "Enable"),

#define SW_API_FLOW_ADD_DESC \
    SW_PARAM_DEF(SW_API_FLOW_ADD, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_FLOW_ADD, SW_FLOWENTRY, sizeof(fal_napt_entry_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Flowentry"),

#define SW_API_FLOW_DEL_DESC \
    SW_PARAM_DEF(SW_API_FLOW_DEL, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_FLOW_DEL, SW_UINT32, 4, SW_PARAM_IN, "DelMode"),  \
    SW_PARAM_DEF(SW_API_FLOW_DEL, SW_FLOWENTRY, sizeof(fal_napt_entry_t), SW_PARAM_PTR|SW_PARAM_IN, "Flowentry"),

#define SW_API_FLOW_GET_DESC \
    SW_PARAM_DEF(SW_API_FLOW_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_FLOW_GET, SW_UINT32, 4, SW_PARAM_IN, "GetMode"),  \
    SW_PARAM_DEF(SW_API_FLOW_GET, SW_FLOWENTRY, sizeof(fal_napt_entry_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Flowentry"),

#define SW_API_FLOW_COOKIE_SET_DESC \
    SW_PARAM_DEF(SW_API_FLOW_COOKIE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_FLOW_COOKIE_SET, SW_FLOWCOOKIE, sizeof(fal_flow_cookie_t), SW_PARAM_PTR|SW_PARAM_IN, "Flowcookieentry"),

#define SW_API_FLOW_RFS_SET_DESC \
    SW_PARAM_DEF(SW_API_FLOW_RFS_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_FLOW_RFS_SET, SW_UINT32, 4, SW_PARAM_IN, "action"), \
    SW_PARAM_DEF(SW_API_FLOW_RFS_SET, SW_FLOWRFS, sizeof(fal_flow_rfs_t), SW_PARAM_PTR|SW_PARAM_IN, "Flowrfs"),


#define SW_API_FLOW_NEXT_DESC \
    SW_PARAM_DEF(SW_API_FLOW_NEXT, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_FLOW_NEXT, SW_UINT32, 4, SW_PARAM_IN, "NextMode"),  \
    SW_PARAM_DEF(SW_API_FLOW_NEXT, SW_FLOWENTRY, sizeof(fal_napt_entry_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Flowentry"),

#define SW_API_FLOW_COUNTER_BIND_DESC \
    SW_PARAM_DEF(SW_API_FLOW_COUNTER_BIND, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_FLOW_COUNTER_BIND, SW_UINT32, 4, SW_PARAM_IN, "EntryID"),  \
    SW_PARAM_DEF(SW_API_FLOW_COUNTER_BIND, SW_UINT32, 4, SW_PARAM_IN, "CounterID"),\
    SW_PARAM_DEF(SW_API_FLOW_COUNTER_BIND, SW_ENABLE, 4, SW_PARAM_IN, "Enable"),

#define SW_API_NAT_STATUS_SET_DESC \
    SW_PARAM_DEF(SW_API_NAT_STATUS_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_NAT_STATUS_SET, SW_ENABLE, 4, SW_PARAM_IN, "Status"),

#define SW_API_NAT_STATUS_GET_DESC \
    SW_PARAM_DEF(SW_API_NAT_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_NAT_STATUS_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Status"),

#define SW_API_NAT_HASH_MODE_SET_DESC \
    SW_PARAM_DEF(SW_API_NAT_HASH_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_NAT_HASH_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Hashmode"),

#define SW_API_NAT_HASH_MODE_GET_DESC \
    SW_PARAM_DEF(SW_API_NAT_HASH_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_NAT_HASH_MODE_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Hashmode"),

#define SW_API_NAPT_STATUS_SET_DESC \
    SW_PARAM_DEF(SW_API_NAPT_STATUS_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_NAPT_STATUS_SET, SW_ENABLE, 4, SW_PARAM_IN, "Status"),

#define SW_API_NAPT_STATUS_GET_DESC \
    SW_PARAM_DEF(SW_API_NAPT_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_NAPT_STATUS_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Status"),

#define SW_API_NAPT_MODE_SET_DESC \
    SW_PARAM_DEF(SW_API_NAPT_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_NAPT_MODE_SET, SW_NAPTMODE, sizeof(fal_napt_mode_t), SW_PARAM_IN, "Mode"),

#define SW_API_NAPT_MODE_GET_DESC \
    SW_PARAM_DEF(SW_API_NAPT_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_NAPT_MODE_GET, SW_NAPTMODE, sizeof(fal_napt_mode_t), SW_PARAM_PTR|SW_PARAM_OUT, "Mode"),

#define SW_API_PRV_BASE_ADDR_SET_DESC \
    SW_PARAM_DEF(SW_API_PRV_BASE_ADDR_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_PRV_BASE_ADDR_SET, SW_IP4ADDR, sizeof(fal_ip4_addr_t), SW_PARAM_IN, "BaseAddr"),

#define SW_API_PRV_BASE_ADDR_GET_DESC \
    SW_PARAM_DEF(SW_API_PRV_BASE_ADDR_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_PRV_BASE_ADDR_GET, SW_IP4ADDR, sizeof(fal_ip4_addr_t), SW_PARAM_PTR|SW_PARAM_OUT, "BaseAddr"),

#define SW_API_PRV_ADDR_MODE_SET_DESC \
    SW_PARAM_DEF(SW_API_PRV_ADDR_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_PRV_ADDR_MODE_SET, SW_ENABLE, sizeof(a_bool_t), SW_PARAM_IN, "Mode"),

#define SW_API_PRV_ADDR_MODE_GET_DESC \
    SW_PARAM_DEF(SW_API_PRV_ADDR_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_PRV_ADDR_MODE_GET, SW_ENABLE, sizeof(a_bool_t), SW_PARAM_PTR|SW_PARAM_OUT, "Mode"),

#define SW_API_PUB_ADDR_ENTRY_ADD_DESC \
    SW_PARAM_DEF(SW_API_PUB_ADDR_ENTRY_ADD, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_PUB_ADDR_ENTRY_ADD, SW_PUBADDRENTRY, sizeof(fal_nat_pub_addr_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "PubAddrEntry"),

#define SW_API_PUB_ADDR_ENTRY_DEL_DESC \
    SW_PARAM_DEF(SW_API_PUB_ADDR_ENTRY_DEL, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_PUB_ADDR_ENTRY_DEL, SW_UINT32, 4, SW_PARAM_IN, "DelMode"),  \
    SW_PARAM_DEF(SW_API_PUB_ADDR_ENTRY_DEL, SW_PUBADDRENTRY, sizeof(fal_nat_pub_addr_t), SW_PARAM_PTR|SW_PARAM_IN, "PubAddrEntry"),

#define SW_API_PUB_ADDR_ENTRY_NEXT_DESC \
    SW_PARAM_DEF(SW_API_PUB_ADDR_ENTRY_NEXT, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),   \
    SW_PARAM_DEF(SW_API_PUB_ADDR_ENTRY_NEXT, SW_UINT32, 4, SW_PARAM_IN, "NextMode"),  \
    SW_PARAM_DEF(SW_API_PUB_ADDR_ENTRY_NEXT, SW_PUBADDRENTRY, sizeof(fal_nat_pub_addr_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "PubAddrEntry"),

#define SW_API_NAT_UNK_SESSION_CMD_SET_DESC \
    SW_PARAM_DEF(SW_API_NAT_UNK_SESSION_CMD_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_NAT_UNK_SESSION_CMD_SET, SW_MACCMD, sizeof(fal_fwd_cmd_t), SW_PARAM_IN, "Forwarding"),

#define SW_API_NAT_UNK_SESSION_CMD_GET_DESC \
    SW_PARAM_DEF(SW_API_NAT_UNK_SESSION_CMD_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_NAT_UNK_SESSION_CMD_GET, SW_MACCMD, sizeof(fal_fwd_cmd_t), SW_PARAM_PTR|SW_PARAM_OUT, "Forwarding"),

#define SW_API_PRV_BASE_MASK_SET_DESC \
    SW_PARAM_DEF(SW_API_PRV_BASE_MASK_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_PRV_BASE_MASK_SET, SW_IP4ADDR, sizeof(fal_ip4_addr_t), SW_PARAM_IN, "BaseMask"),

#define SW_API_PRV_BASE_MASK_GET_DESC \
    SW_PARAM_DEF(SW_API_PRV_BASE_MASK_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_PRV_BASE_MASK_GET, SW_IP4ADDR, sizeof(fal_ip4_addr_t), SW_PARAM_PTR|SW_PARAM_OUT, "BaseMask"),

#define SW_API_NAT_GLOBAL_SET_DESC \
    SW_PARAM_DEF(SW_API_NAT_GLOBAL_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),  \
    SW_PARAM_DEF(SW_API_NAT_GLOBAL_SET, SW_ENABLE, 4, SW_PARAM_IN, "Status"),  \
    SW_PARAM_DEF(SW_API_NAT_GLOBAL_SET, SW_ENABLE, 4, SW_PARAM_IN, "Sync Flow Counter"), \
    SW_PARAM_DEF(SW_API_NAT_GLOBAL_SET, SW_UINT32, 4, SW_PARAM_IN, "wan portbmp"),

#define SW_API_TRUNK_GROUP_SET_DESC \
    SW_PARAM_DEF(SW_API_TRUNK_GROUP_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_TRUNK_GROUP_SET, SW_UINT32, 4, SW_PARAM_IN, "Trunk ID"), \
    SW_PARAM_DEF(SW_API_TRUNK_GROUP_SET, SW_ENABLE, sizeof(a_bool_t), SW_PARAM_IN, "Status"), \
    SW_PARAM_DEF(SW_API_TRUNK_GROUP_SET, SW_PBMP, sizeof(fal_pbmp_t), SW_PARAM_IN, "Member Port Bitmap"),

#define SW_API_TRUNK_GROUP_GET_DESC \
    SW_PARAM_DEF(SW_API_TRUNK_GROUP_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_TRUNK_GROUP_GET, SW_UINT32, 4, SW_PARAM_IN, "Trunk ID"), \
    SW_PARAM_DEF(SW_API_TRUNK_GROUP_GET, SW_ENABLE, sizeof(a_bool_t), SW_PARAM_PTR|SW_PARAM_OUT, "Status"), \
    SW_PARAM_DEF(SW_API_TRUNK_GROUP_GET, SW_PBMP, sizeof(fal_pbmp_t), SW_PARAM_PTR|SW_PARAM_OUT, "Member Port Bitmap"),

#define SW_API_TRUNK_HASH_SET_DESC \
    SW_PARAM_DEF(SW_API_TRUNK_HASH_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_TRUNK_HASH_SET, SW_UINT32, 4, SW_PARAM_IN, "Hash Mode"),

#define SW_API_TRUNK_HASH_GET_DESC \
    SW_PARAM_DEF(SW_API_TRUNK_HASH_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_TRUNK_HASH_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Hash Mode"),

#define SW_API_TRUNK_MAN_SA_SET_DESC \
    SW_PARAM_DEF(SW_API_TRUNK_MAN_SA_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_TRUNK_MAN_SA_SET, SW_MACADDR, sizeof(fal_mac_addr_t), SW_PARAM_PTR|SW_PARAM_IN, "[Manipulable SA]:"),

#define SW_API_TRUNK_MAN_SA_GET_DESC \
    SW_PARAM_DEF(SW_API_TRUNK_MAN_SA_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_TRUNK_MAN_SA_GET, SW_MACADDR, sizeof(fal_mac_addr_t), SW_PARAM_PTR|SW_PARAM_OUT, "[Manipulable SA]:"),

#define SW_API_TRUNK_FAILOVER_EN_SET_DESC \
    SW_PARAM_DEF(SW_API_TRUNK_FAILOVER_EN_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_TRUNK_FAILOVER_EN_SET, SW_ENABLE, 4, SW_PARAM_IN, "failover_en"),

#define SW_API_TRUNK_FAILOVER_EN_GET_DESC \
    SW_PARAM_DEF(SW_API_TRUNK_FAILOVER_EN_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_TRUNK_FAILOVER_EN_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "failover_en"),

#define SW_API_MAC_MODE_SET_DESC \
    SW_PARAM_DEF(SW_API_MAC_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_MAC_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_MAC_MODE_SET, SW_MACCONFIG, sizeof(fal_mac_config_t), SW_PARAM_PTR|SW_PARAM_IN, "MAC config"),

#define SW_API_MAC_MODE_GET_DESC \
    SW_PARAM_DEF(SW_API_MAC_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_MAC_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_MAC_MODE_GET, SW_MACCONFIG, sizeof(fal_mac_config_t), SW_PARAM_PTR|SW_PARAM_OUT, "MAC config"),

#define SW_API_PORT_3AZ_STATUS_SET_DESC \
    SW_PARAM_DEF(SW_API_PORT_3AZ_STATUS_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PORT_3AZ_STATUS_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PORT_3AZ_STATUS_SET, SW_ENABLE, sizeof(a_bool_t), SW_PARAM_IN, "Status"),

#define SW_API_PORT_3AZ_STATUS_GET_DESC \
    SW_PARAM_DEF(SW_API_PORT_3AZ_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PORT_3AZ_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PORT_3AZ_STATUS_GET, SW_ENABLE, sizeof(a_bool_t), SW_PARAM_PTR|SW_PARAM_OUT, "Status"),

#define SW_API_PHY_MODE_SET_DESC \
    SW_PARAM_DEF(SW_API_PHY_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PHY_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Phy ID"), \
    SW_PARAM_DEF(SW_API_PHY_MODE_SET, SW_PHYCONFIG, sizeof(fal_phy_config_t), SW_PARAM_PTR|SW_PARAM_IN, "PHY config"),

#define SW_API_PHY_MODE_GET_DESC \
    SW_PARAM_DEF(SW_API_PHY_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PHY_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Phy ID"), \
    SW_PARAM_DEF(SW_API_PHY_MODE_GET, SW_PHYCONFIG, sizeof(fal_phy_config_t), SW_PARAM_PTR|SW_PARAM_OUT, "PHY config"),

#define SW_API_FX100_CTRL_SET_DESC \
    SW_PARAM_DEF(SW_API_FX100_CTRL_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_FX100_CTRL_SET, SW_FX100CONFIG, sizeof(fal_fx100_ctrl_config_t), SW_PARAM_PTR|SW_PARAM_IN, "fx100 config"),

#define SW_API_FX100_CTRL_GET_DESC \
    SW_PARAM_DEF(SW_API_FX100_CTRL_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_FX100_CTRL_GET, SW_FX100CONFIG, sizeof(fal_fx100_ctrl_config_t), SW_PARAM_PTR|SW_PARAM_OUT, "fx100 config"),

#define SW_API_FX100_STATUS_GET_DESC \
    SW_PARAM_DEF(SW_API_FX100_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_FX100_STATUS_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "fx100 status"),


#define SW_API_MAC06_EXCH_SET_DESC \
    SW_PARAM_DEF(SW_API_MAC06_EXCH_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_MAC06_EXCH_SET, SW_ENABLE, sizeof(a_bool_t), SW_PARAM_IN, "enable"),

#define SW_API_MAC06_EXCH_GET_DESC \
    SW_PARAM_DEF(SW_API_MAC06_EXCH_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_MAC06_EXCH_GET, SW_ENABLE, sizeof(a_bool_t), SW_PARAM_PTR|SW_PARAM_OUT, "enable"),

#define SW_API_VSI_ALLOC_DESC \
    SW_PARAM_DEF(SW_API_VSI_ALLOC, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_VSI_ALLOC, SW_UINT32, sizeof(a_bool_t), SW_PARAM_PTR|SW_PARAM_OUT, "VSI value"),

#define SW_API_VSI_FREE_DESC \
    SW_PARAM_DEF(SW_API_VSI_FREE, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_VSI_FREE, SW_UINT32, 4, SW_PARAM_IN, "VSI value"), \

#define SW_API_PORT_VSI_SET_DESC \
    SW_PARAM_DEF(SW_API_PORT_VSI_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PORT_VSI_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PORT_VSI_SET, SW_UINT32, 4, SW_PARAM_IN, "VSI value"),

#define SW_API_PORT_VSI_GET_DESC \
    SW_PARAM_DEF(SW_API_PORT_VSI_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PORT_VSI_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PORT_VSI_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "VSI value"),

#define SW_API_PORT_VLAN_VSI_SET_DESC \
    SW_PARAM_DEF(SW_API_PORT_VLAN_VSI_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PORT_VLAN_VSI_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PORT_VLAN_VSI_SET, SW_UINT32, 4, SW_PARAM_IN, "STAG VID"), \
    SW_PARAM_DEF(SW_API_PORT_VLAN_VSI_SET, SW_UINT32, 4, SW_PARAM_IN, "CTAG VID"), \
    SW_PARAM_DEF(SW_API_PORT_VLAN_VSI_SET, SW_UINT32, 4, SW_PARAM_IN, "VSI value"),

#define SW_API_PORT_VLAN_VSI_GET_DESC \
    SW_PARAM_DEF(SW_API_PORT_VLAN_VSI_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PORT_VLAN_VSI_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PORT_VLAN_VSI_GET, SW_UINT32, 4, SW_PARAM_IN, "STAG VID"), \
    SW_PARAM_DEF(SW_API_PORT_VLAN_VSI_GET, SW_UINT32, 4, SW_PARAM_IN, "CTAG VID"), \
    SW_PARAM_DEF(SW_API_PORT_VLAN_VSI_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "VSI value"),

#define SW_API_VSI_TBL_DUMP_DESC \
    SW_PARAM_DEF(SW_API_VSI_TBL_DUMP, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \

#define SW_API_VSI_NEWADDR_LRN_GET_DESC \
    SW_PARAM_DEF(SW_API_VSI_NEWADDR_LRN_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_VSI_NEWADDR_LRN_GET, SW_UINT32, 4, SW_PARAM_IN, "VSI ID"), \
    SW_PARAM_DEF(SW_API_VSI_NEWADDR_LRN_GET, SW_VSI_NEWADDR_LRN, sizeof(fal_vsi_newaddr_lrn_t), SW_PARAM_PTR|SW_PARAM_OUT, "newaddr_lrn"),

#define SW_API_VSI_NEWADDR_LRN_SET_DESC \
    SW_PARAM_DEF(SW_API_VSI_NEWADDR_LRN_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_VSI_NEWADDR_LRN_SET, SW_UINT32, 4, SW_PARAM_IN, "VSI ID"), \
    SW_PARAM_DEF(SW_API_VSI_NEWADDR_LRN_SET, SW_VSI_NEWADDR_LRN, sizeof(fal_vsi_newaddr_lrn_t), SW_PARAM_PTR|SW_PARAM_IN, "newaddr_lrn"),

#define SW_API_VSI_STAMOVE_SET_DESC \
    SW_PARAM_DEF(SW_API_VSI_STAMOVE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_VSI_STAMOVE_SET, SW_UINT32, 4, SW_PARAM_IN, "VSI ID"), \
    SW_PARAM_DEF(SW_API_VSI_STAMOVE_SET, SW_VSI_STAMOVE, sizeof(fal_vsi_stamove_t), SW_PARAM_PTR|SW_PARAM_IN, "stamove"),

#define SW_API_VSI_STAMOVE_GET_DESC \
    SW_PARAM_DEF(SW_API_VSI_STAMOVE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_VSI_STAMOVE_GET, SW_UINT32, 4, SW_PARAM_IN, "VSI ID"), \
    SW_PARAM_DEF(SW_API_VSI_STAMOVE_GET, SW_VSI_STAMOVE, sizeof(fal_vsi_stamove_t), SW_PARAM_PTR|SW_PARAM_OUT, "stamove"),

#define SW_API_VSI_MEMBER_SET_DESC \
    SW_PARAM_DEF(SW_API_VSI_MEMBER_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_VSI_MEMBER_SET, SW_UINT32, 4, SW_PARAM_IN, "VSI ID"), \
    SW_PARAM_DEF(SW_API_VSI_MEMBER_SET, SW_VSI_MEMBER, sizeof(fal_vsi_member_t), SW_PARAM_PTR|SW_PARAM_IN, "members"),

#define SW_API_VSI_MEMBER_GET_DESC \
    SW_PARAM_DEF(SW_API_VSI_MEMBER_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_VSI_MEMBER_GET, SW_UINT32, 4, SW_PARAM_IN, "VSI ID"), \
    SW_PARAM_DEF(SW_API_VSI_MEMBER_GET, SW_VSI_MEMBER, sizeof(fal_vsi_member_t), SW_PARAM_PTR|SW_PARAM_OUT, "members"),

#define SW_API_VSI_COUNTER_GET_DESC \
    SW_PARAM_DEF(SW_API_VSI_COUNTER_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_VSI_COUNTER_GET, SW_UINT32, 4, SW_PARAM_IN, "VSI ID"), \
    SW_PARAM_DEF(SW_API_VSI_COUNTER_GET, SW_VSI_COUNTER, sizeof(fal_vsi_counter_t), SW_PARAM_PTR|SW_PARAM_OUT, "counter"),

#define SW_API_VSI_COUNTER_CLEANUP_DESC \
    SW_PARAM_DEF(SW_API_VSI_COUNTER_CLEANUP, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_VSI_COUNTER_CLEANUP, SW_UINT32, 4, SW_PARAM_IN, "VSI ID"),

#define SW_API_VSI_BRIDGE_VSI_GET_DESC \
    SW_PARAM_DEF(SW_API_VSI_BRIDGE_VSI_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_VSI_BRIDGE_VSI_GET, SW_UINT32, 4, SW_PARAM_IN, "VSI ID"), \
    SW_PARAM_DEF(SW_API_VSI_BRIDGE_VSI_GET, SW_VSI_BRIDGE_VSI, \
		    sizeof(fal_vsi_bridge_vsi_t), SW_PARAM_PTR|SW_PARAM_OUT, "bridge_vsi"),

#define SW_API_VSI_BRIDGE_VSI_SET_DESC \
    SW_PARAM_DEF(SW_API_VSI_BRIDGE_VSI_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_VSI_BRIDGE_VSI_SET, SW_UINT32, 4, SW_PARAM_IN, "VSI ID"), \
    SW_PARAM_DEF(SW_API_VSI_BRIDGE_VSI_SET, SW_VSI_BRIDGE_VSI, \
		    sizeof(fal_vsi_bridge_vsi_t), SW_PARAM_PTR|SW_PARAM_IN, "bridge_vsi"),

#define SW_API_VSI_INVALIDVSI_CTRL_GET_DESC \
	SW_PARAM_DEF(SW_API_VSI_INVALIDVSI_CTRL_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
	SW_PARAM_DEF(SW_API_VSI_INVALIDVSI_CTRL_GET, SW_UINT32, 4, SW_PARAM_IN, "PORT ID"), \
	SW_PARAM_DEF(SW_API_VSI_INVALIDVSI_CTRL_GET, SW_VSI_INVALIDVSI_CTRL, \
		    sizeof(fal_vsi_invalidvsi_ctrl_t), SW_PARAM_PTR|SW_PARAM_OUT, "invalidvsi_ctrl"),

#define SW_API_VSI_INVALIDVSI_CTRL_SET_DESC \
	SW_PARAM_DEF(SW_API_VSI_INVALIDVSI_CTRL_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
	SW_PARAM_DEF(SW_API_VSI_INVALIDVSI_CTRL_SET, SW_UINT32, 4, SW_PARAM_IN, "PORT ID"), \
	SW_PARAM_DEF(SW_API_VSI_INVALIDVSI_CTRL_SET, SW_VSI_INVALIDVSI_CTRL, \
		    sizeof(fal_vsi_invalidvsi_ctrl_t), SW_PARAM_PTR|SW_PARAM_IN, "invalidvsi_ctrl"),

#define SW_API_UCAST_QUEUE_BASE_PROFILE_SET_DESC \
    SW_PARAM_DEF(SW_API_UCAST_QUEUE_BASE_PROFILE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_UCAST_QUEUE_BASE_PROFILE_SET, SW_UCAST_QUEUE_MAP, sizeof(fal_ucast_queue_dest_t), SW_PARAM_PTR|SW_PARAM_IN, "queue dest"), \
    SW_PARAM_DEF(SW_API_UCAST_QUEUE_BASE_PROFILE_SET, SW_QM_QBASE, 4, SW_PARAM_IN, "Queue base"), \
    SW_PARAM_DEF(SW_API_UCAST_QUEUE_BASE_PROFILE_SET, SW_QM_PROFILE, 1, SW_PARAM_IN, "Profile"),

#define SW_API_UCAST_QUEUE_BASE_PROFILE_GET_DESC \
    SW_PARAM_DEF(SW_API_UCAST_QUEUE_BASE_PROFILE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_UCAST_QUEUE_BASE_PROFILE_GET, SW_UCAST_QUEUE_MAP, sizeof(fal_ucast_queue_dest_t), SW_PARAM_PTR|SW_PARAM_IN, "queue dest"), \
    SW_PARAM_DEF(SW_API_UCAST_QUEUE_BASE_PROFILE_GET, SW_QM_QBASE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Queue base"), \
    SW_PARAM_DEF(SW_API_UCAST_QUEUE_BASE_PROFILE_GET, SW_QM_PROFILE, 1, SW_PARAM_PTR|SW_PARAM_OUT, "Profile"),

#define SW_API_UCAST_PRIORITY_CLASS_SET_DESC \
    SW_PARAM_DEF(SW_API_UCAST_PRIORITY_CLASS_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_UCAST_PRIORITY_CLASS_SET, SW_UINT8, 1, SW_PARAM_IN, "Profile"), \
    SW_PARAM_DEF(SW_API_UCAST_PRIORITY_CLASS_SET, SW_QM_PRI, 1, SW_PARAM_IN, "Priority"), \
    SW_PARAM_DEF(SW_API_UCAST_PRIORITY_CLASS_SET, SW_QM_CLASS, 1, SW_PARAM_IN, "Class"),

#define SW_API_UCAST_PRIORITY_CLASS_GET_DESC \
    SW_PARAM_DEF(SW_API_UCAST_PRIORITY_CLASS_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_UCAST_PRIORITY_CLASS_GET, SW_UINT8, 1, SW_PARAM_IN, "Profile"), \
    SW_PARAM_DEF(SW_API_UCAST_PRIORITY_CLASS_GET, SW_QM_PRI, 1, SW_PARAM_IN, "Priority"), \
    SW_PARAM_DEF(SW_API_UCAST_PRIORITY_CLASS_GET, SW_QM_CLASS, 1, SW_PARAM_PTR|SW_PARAM_OUT, "Class"),

#define SW_API_UCAST_HASH_MAP_SET_DESC \
    SW_PARAM_DEF(SW_API_UCAST_HASH_MAP_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_UCAST_HASH_MAP_SET, SW_UINT8, 1, SW_PARAM_IN, "Profile"), \
    SW_PARAM_DEF(SW_API_UCAST_HASH_MAP_SET, SW_QM_HASH, 1, SW_PARAM_IN, "Rss hash"), \
    SW_PARAM_DEF(SW_API_UCAST_HASH_MAP_SET, SW_QM_CLASS, 1, SW_PARAM_IN, "Queue hash"),

#define SW_API_UCAST_HASH_MAP_GET_DESC \
    SW_PARAM_DEF(SW_API_UCAST_HASH_MAP_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_UCAST_HASH_MAP_GET, SW_UINT8, 1, SW_PARAM_IN, "Profile"), \
    SW_PARAM_DEF(SW_API_UCAST_HASH_MAP_GET, SW_QM_HASH, 1, SW_PARAM_IN, "Rss hash"), \
    SW_PARAM_DEF(SW_API_UCAST_HASH_MAP_GET, SW_QM_CLASS, 1, SW_PARAM_PTR|SW_PARAM_OUT, "Queue hash"),

#define SW_API_MCAST_CPUCODE_CLASS_SET_DESC \
    SW_PARAM_DEF(SW_API_MCAST_CPUCODE_CLASS_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_MCAST_CPUCODE_CLASS_SET, SW_UINT8, 1, SW_PARAM_IN, "Cpu code"), \
    SW_PARAM_DEF(SW_API_MCAST_CPUCODE_CLASS_SET, SW_UINT8, 1, SW_PARAM_IN, "Queue Class"),

#define SW_API_MCAST_CPUCODE_CLASS_GET_DESC \
    SW_PARAM_DEF(SW_API_MCAST_CPUCODE_CLASS_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_MCAST_CPUCODE_CLASS_GET, SW_UINT8, 1, SW_PARAM_IN, "Cpu code"), \
    SW_PARAM_DEF(SW_API_MCAST_CPUCODE_CLASS_GET, SW_UINT8, 1, SW_PARAM_PTR|SW_PARAM_OUT, "Queue Class"),

#define SW_API_MCAST_PRIORITY_CLASS_SET_DESC \
    SW_PARAM_DEF(SW_API_MCAST_PRIORITY_CLASS_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_MCAST_PRIORITY_CLASS_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_MCAST_PRIORITY_CLASS_SET, SW_QM_PRI, 1, SW_PARAM_IN, "Priority"), \
    SW_PARAM_DEF(SW_API_MCAST_PRIORITY_CLASS_SET, SW_QM_CLASS, 1, SW_PARAM_IN, "Queue Class"),

#define SW_API_MCAST_PRIORITY_CLASS_GET_DESC \
    SW_PARAM_DEF(SW_API_MCAST_PRIORITY_CLASS_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_MCAST_PRIORITY_CLASS_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_MCAST_PRIORITY_CLASS_GET, SW_QM_PRI, 1, SW_PARAM_IN, "Priority"), \
    SW_PARAM_DEF(SW_API_MCAST_PRIORITY_CLASS_GET, SW_QM_CLASS, 1, SW_PARAM_PTR|SW_PARAM_OUT, "Queue Class"),

#define SW_API_QUEUE_FLUSH_DESC \
    SW_PARAM_DEF(SW_API_QUEUE_FLUSH, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_QUEUE_FLUSH, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_QUEUE_FLUSH, SW_UINT16, 2, SW_PARAM_IN, "queue ID"),

#define SW_API_UCAST_DFLT_HASH_MAP_SET_DESC \
    SW_PARAM_DEF(SW_API_UCAST_DFLT_HASH_MAP_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_UCAST_DFLT_HASH_MAP_SET, SW_UINT8, 1, SW_PARAM_IN, "ucast dflt hash"),

#define SW_API_UCAST_DFLT_HASH_MAP_GET_DESC \
    SW_PARAM_DEF(SW_API_UCAST_DFLT_HASH_MAP_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_UCAST_DFLT_HASH_MAP_GET, SW_UINT8, 1, SW_PARAM_PTR|SW_PARAM_OUT, "ucast dflt hash"),

#define SW_API_AC_CTRL_SET_DESC \
    SW_PARAM_DEF(SW_API_AC_CTRL_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_AC_CTRL_SET, SW_AC_OBJ, sizeof(fal_ac_obj_t), SW_PARAM_PTR|SW_PARAM_IN, "ac obj"), \
    SW_PARAM_DEF(SW_API_AC_CTRL_SET, SW_AC_CTRL, sizeof(fal_ac_ctrl_t), SW_PARAM_PTR|SW_PARAM_IN, "ac ctrl"),

#define SW_API_AC_CTRL_GET_DESC \
    SW_PARAM_DEF(SW_API_AC_CTRL_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_AC_CTRL_GET, SW_AC_OBJ, sizeof(fal_ac_obj_t), SW_PARAM_PTR|SW_PARAM_IN, "AC obj"), \
    SW_PARAM_DEF(SW_API_AC_CTRL_GET, SW_AC_CTRL, sizeof(fal_ac_ctrl_t), SW_PARAM_PTR|SW_PARAM_OUT, "ac ctrl"),

#define SW_API_AC_PRE_BUFFER_SET_DESC \
    SW_PARAM_DEF(SW_API_AC_PRE_BUFFER_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_AC_PRE_BUFFER_SET, SW_AC_OBJ, sizeof(fal_ac_obj_t), SW_PARAM_PTR|SW_PARAM_IN, "AC obj"), \
    SW_PARAM_DEF(SW_API_AC_PRE_BUFFER_SET, SW_UINT16, 2, SW_PARAM_IN, "num"),

#define SW_API_AC_PRE_BUFFER_GET_DESC \
    SW_PARAM_DEF(SW_API_AC_PRE_BUFFER_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_AC_PRE_BUFFER_GET, SW_AC_OBJ, sizeof(fal_ac_obj_t), SW_PARAM_PTR|SW_PARAM_IN, "AC obj"), \
    SW_PARAM_DEF(SW_API_AC_PRE_BUFFER_GET, SW_UINT16, 2, SW_PARAM_PTR|SW_PARAM_OUT, "num"),

#define SW_API_QUEUE_GROUP_SET_DESC \
    SW_PARAM_DEF(SW_API_QUEUE_GROUP_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_QUEUE_GROUP_SET, SW_UINT32, 4, SW_PARAM_IN, "queue id"), \
    SW_PARAM_DEF(SW_API_QUEUE_GROUP_SET, SW_UINT8, 1, SW_PARAM_IN, "group id"),

#define SW_API_QUEUE_GROUP_GET_DESC \
    SW_PARAM_DEF(SW_API_QUEUE_GROUP_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_QUEUE_GROUP_GET, SW_UINT32, 4, SW_PARAM_IN, "queue id"), \
    SW_PARAM_DEF(SW_API_QUEUE_GROUP_GET, SW_UINT8, 1, SW_PARAM_PTR|SW_PARAM_OUT, "group id"),

#define SW_API_STATIC_THRESH_SET_DESC \
    SW_PARAM_DEF(SW_API_STATIC_THRESH_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_STATIC_THRESH_SET, SW_AC_OBJ, sizeof(fal_ac_obj_t), SW_PARAM_PTR|SW_PARAM_IN, "AC obj"), \
    SW_PARAM_DEF(SW_API_STATIC_THRESH_SET, SW_STATIC_THRESH, sizeof(fal_ac_static_threshold_t), SW_PARAM_PTR|SW_PARAM_IN, "static thresh"),

#define SW_API_STATIC_THRESH_GET_DESC \
    SW_PARAM_DEF(SW_API_STATIC_THRESH_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_STATIC_THRESH_GET, SW_AC_OBJ, sizeof(fal_ac_obj_t), SW_PARAM_PTR|SW_PARAM_IN, "AC obj"), \
    SW_PARAM_DEF(SW_API_STATIC_THRESH_GET, SW_STATIC_THRESH, sizeof(fal_ac_static_threshold_t), SW_PARAM_PTR|SW_PARAM_OUT, "static thresh"),

#define SW_API_DYNAMIC_THRESH_SET_DESC \
    SW_PARAM_DEF(SW_API_DYNAMIC_THRESH_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_DYNAMIC_THRESH_SET, SW_UINT32, 4, SW_PARAM_IN, "queue id"), \
    SW_PARAM_DEF(SW_API_DYNAMIC_THRESH_SET, SW_DYNAMIC_THRESH, sizeof(fal_ac_dynamic_threshold_t), SW_PARAM_PTR|SW_PARAM_IN, "dynamic thresh"),

#define SW_API_DYNAMIC_THRESH_GET_DESC \
    SW_PARAM_DEF(SW_API_DYNAMIC_THRESH_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_DYNAMIC_THRESH_GET, SW_UINT32, 4, SW_PARAM_IN, "queue id"), \
    SW_PARAM_DEF(SW_API_DYNAMIC_THRESH_GET, SW_DYNAMIC_THRESH, sizeof(fal_ac_dynamic_threshold_t), SW_PARAM_PTR|SW_PARAM_OUT, "dynamic thresh"),

#define SW_API_GOURP_BUFFER_SET_DESC \
    SW_PARAM_DEF(SW_API_GOURP_BUFFER_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_GOURP_BUFFER_SET, SW_UINT8, 1, SW_PARAM_IN, "group"), \
    SW_PARAM_DEF(SW_API_GOURP_BUFFER_SET, SW_GROUP_BUFFER, sizeof(fal_ac_group_buffer_t), SW_PARAM_PTR|SW_PARAM_IN, "buffer cfg"),

#define SW_API_GOURP_BUFFER_GET_DESC \
    SW_PARAM_DEF(SW_API_GOURP_BUFFER_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_GOURP_BUFFER_GET, SW_UINT8, 1, SW_PARAM_IN, "group"), \
    SW_PARAM_DEF(SW_API_GOURP_BUFFER_GET, SW_GROUP_BUFFER, sizeof(fal_ac_group_buffer_t), SW_PARAM_PTR|SW_PARAM_OUT, "buffer cfg"),

#define SW_API_QUEUE_CNT_CTRL_GET_DESC \
    SW_PARAM_DEF(SW_API_QUEUE_CNT_CTRL_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_QUEUE_CNT_CTRL_GET, SW_ENABLE, sizeof(a_bool_t), SW_PARAM_PTR|SW_PARAM_OUT, "queue cnt en"),

#define SW_API_QUEUE_CNT_CTRL_SET_DESC \
    SW_PARAM_DEF(SW_API_QUEUE_CNT_CTRL_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_QUEUE_CNT_CTRL_SET, SW_ENABLE, sizeof(a_bool_t), SW_PARAM_IN, "queue cnt en"),

#define SW_API_QUEUE_CNT_CLEANUP_DESC \
    SW_PARAM_DEF(SW_API_QUEUE_CNT_CLEANUP, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_QUEUE_CNT_CLEANUP, SW_UINT32, 4, SW_PARAM_IN, "queue id"),

#define SW_API_QUEUE_CNT_GET_DESC \
    SW_PARAM_DEF(SW_API_QUEUE_CNT_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_QUEUE_CNT_GET, SW_UINT32, 4, SW_PARAM_IN, "queue ID"), \
    SW_PARAM_DEF(SW_API_QUEUE_CNT_GET, SW_QM_CNT, sizeof(fal_queue_stats_t), SW_PARAM_PTR|SW_PARAM_OUT, "queue cnt"),

#define SW_API_QM_ENQUEUE_CTRL_SET_DESC \
    SW_PARAM_DEF(SW_API_QM_ENQUEUE_CTRL_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_QM_ENQUEUE_CTRL_SET, SW_UINT32, 4, SW_PARAM_IN, "queue ID"), \
    SW_PARAM_DEF(SW_API_QM_ENQUEUE_CTRL_SET, SW_ENABLE, sizeof(a_bool_t), SW_PARAM_IN, "enqueue en"),

#define SW_API_QM_ENQUEUE_CTRL_GET_DESC \
    SW_PARAM_DEF(SW_API_QM_ENQUEUE_CTRL_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_QM_ENQUEUE_CTRL_GET, SW_UINT32, 4, SW_PARAM_IN, "queue ID"), \
    SW_PARAM_DEF(SW_API_QM_ENQUEUE_CTRL_GET, SW_ENABLE, sizeof(a_bool_t), SW_PARAM_PTR|SW_PARAM_OUT, "enqueue en"),

#define SW_API_QM_SOURCE_PROFILE_SET_DESC \
    SW_PARAM_DEF(SW_API_QM_SOURCE_PROFILE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_QM_SOURCE_PROFILE_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_QM_SOURCE_PROFILE_SET, SW_UINT32, 4, SW_PARAM_IN, "Source profile"),

#define SW_API_QM_SOURCE_PROFILE_GET_DESC \
    SW_PARAM_DEF(SW_API_QM_SOURCE_PROFILE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_QM_SOURCE_PROFILE_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_QM_SOURCE_PROFILE_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Source profile"),

#define SW_API_QM_ENQUEUE_CFG_GET_DESC \
    SW_PARAM_DEF(SW_API_QM_ENQUEUE_CFG_GET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_QM_ENQUEUE_CFG_GET, SW_ENQUEUE_CFG, \
		    sizeof(fal_enqueue_cfg_t), SW_PARAM_PTR|SW_PARAM_OUT|SW_PARAM_IN, \
		    "enqueue configuration"),

#define SW_API_QM_ENQUEUE_CFG_SET_DESC \
    SW_PARAM_DEF(SW_API_QM_ENQUEUE_CFG_SET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_QM_ENQUEUE_CFG_SET, SW_ENQUEUE_CFG, \
		    sizeof(fal_enqueue_cfg_t), SW_PARAM_PTR|SW_PARAM_IN, \
		    "enqueue configuration"),

#define SW_API_MGMTCTRL_ETHTYPE_PROFILE_SET_DESC \
    SW_PARAM_DEF(SW_API_MGMTCTRL_ETHTYPE_PROFILE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_MGMTCTRL_ETHTYPE_PROFILE_SET, SW_UINT32, 4, SW_PARAM_IN, "Profile ID"), \
    SW_PARAM_DEF(SW_API_MGMTCTRL_ETHTYPE_PROFILE_SET, SW_UINT32, 4, SW_PARAM_IN, "Ethernet Type"),

#define SW_API_MGMTCTRL_ETHTYPE_PROFILE_GET_DESC \
    SW_PARAM_DEF(SW_API_MGMTCTRL_ETHTYPE_PROFILE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_MGMTCTRL_ETHTYPE_PROFILE_GET, SW_UINT32, 4, SW_PARAM_IN, "Profile ID"), \
    SW_PARAM_DEF(SW_API_MGMTCTRL_ETHTYPE_PROFILE_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Ethernet Type"),

#define SW_API_MGMTCTRL_RFDB_PROFILE_SET_DESC \
    SW_PARAM_DEF(SW_API_MGMTCTRL_RFDB_PROFILE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_MGMTCTRL_RFDB_PROFILE_SET, SW_UINT32, 4, SW_PARAM_IN, "Profile ID"), \
    SW_PARAM_DEF(SW_API_MGMTCTRL_RFDB_PROFILE_SET, SW_MACADDR, sizeof(fal_mac_addr_t), SW_PARAM_PTR|SW_PARAM_IN, "Address"),

#define SW_API_MGMTCTRL_RFDB_PROFILE_GET_DESC \
    SW_PARAM_DEF(SW_API_MGMTCTRL_RFDB_PROFILE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_MGMTCTRL_RFDB_PROFILE_GET, SW_UINT32, 4, SW_PARAM_IN, "Profile ID"), \
    SW_PARAM_DEF(SW_API_MGMTCTRL_RFDB_PROFILE_GET, SW_MACADDR, sizeof(fal_mac_addr_t), SW_PARAM_PTR|SW_PARAM_OUT, "Address"),

#define SW_API_MGMTCTRL_CTRLPKT_PROFILE_ADD_DESC \
    SW_PARAM_DEF(SW_API_MGMTCTRL_CTRLPKT_PROFILE_ADD, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_MGMTCTRL_CTRLPKT_PROFILE_ADD, SW_CTRLPKT_PROFILE, sizeof(fal_ctrlpkt_profile_t), SW_PARAM_PTR|SW_PARAM_IN, "app entry"),

#define SW_API_MGMTCTRL_CTRLPKT_PROFILE_DEL_DESC \
    SW_PARAM_DEF(SW_API_MGMTCTRL_CTRLPKT_PROFILE_DEL, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_MGMTCTRL_CTRLPKT_PROFILE_DEL, SW_CTRLPKT_PROFILE, sizeof(fal_ctrlpkt_profile_t), SW_PARAM_PTR|SW_PARAM_IN, "app entry"),

#define SW_API_MGMTCTRL_CTRLPKT_PROFILE_GETFIRST_DESC \
    SW_PARAM_DEF(SW_API_MGMTCTRL_CTRLPKT_PROFILE_GETFIRST, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_MGMTCTRL_CTRLPKT_PROFILE_GETFIRST, SW_CTRLPKT_PROFILE, sizeof(fal_ctrlpkt_profile_t), SW_PARAM_PTR|SW_PARAM_OUT, "app entry"),

#define SW_API_MGMTCTRL_CTRLPKT_PROFILE_GETNEXT_DESC \
    SW_PARAM_DEF(SW_API_MGMTCTRL_CTRLPKT_PROFILE_GETNEXT, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_MGMTCTRL_CTRLPKT_PROFILE_GETNEXT, SW_CTRLPKT_PROFILE, sizeof(fal_ctrlpkt_profile_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "app entry"),

#define SW_API_MGMTCTRL_VPGROUP_SET_DESC \
    SW_PARAM_DEF(SW_API_MGMTCTRL_VPGROUP_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_MGMTCTRL_VPGROUP_SET, SW_UINT32, sizeof(a_uint32_t), SW_PARAM_IN, \
        "port_id"), \
    SW_PARAM_DEF(SW_API_MGMTCTRL_VPGROUP_SET, SW_UINT32, sizeof(a_uint32_t), SW_PARAM_IN, \
        "vpgroup_id"),

#define SW_API_MGMTCTRL_VPGROUP_GET_DESC \
    SW_PARAM_DEF(SW_API_MGMTCTRL_VPGROUP_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_MGMTCTRL_VPGROUP_GET, SW_UINT32, sizeof(a_uint32_t), SW_PARAM_IN, \
        "port_id"), \
    SW_PARAM_DEF(SW_API_MGMTCTRL_VPGROUP_GET, SW_UINT32, sizeof(a_uint32_t), \
        SW_PARAM_PTR|SW_PARAM_OUT, "vpgroup_id"),

#define SW_API_MGMTCTRL_TUNNEL_DECAP_SET_DESC \
        SW_PARAM_DEF(SW_API_MGMTCTRL_TUNNEL_DECAP_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
        SW_PARAM_DEF(SW_API_MGMTCTRL_TUNNEL_DECAP_SET, SW_UINT32, 4, SW_PARAM_IN, \
            "CPU CODE ID"), \
        SW_PARAM_DEF(SW_API_MGMTCTRL_TUNNEL_DECAP_SET, SW_ENABLE, 4, SW_PARAM_IN, "Enable"),

#define SW_API_MGMTCTRL_TUNNEL_DECAP_GET_DESC \
        SW_PARAM_DEF(SW_API_MGMTCTRL_TUNNEL_DECAP_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
        SW_PARAM_DEF(SW_API_MGMTCTRL_TUNNEL_DECAP_GET, SW_UINT32, 4, SW_PARAM_IN, \
            "CPU CODE ID"), \
        SW_PARAM_DEF(SW_API_MGMTCTRL_TUNNEL_DECAP_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, \
            "Enable"),

#define SW_API_SERVCODE_CONFIG_SET_DESC \
    SW_PARAM_DEF(SW_API_SERVCODE_CONFIG_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_SERVCODE_CONFIG_SET, SW_UINT32, 4, SW_PARAM_IN, "Index"), \
    SW_PARAM_DEF(SW_API_SERVCODE_CONFIG_SET, SW_SERVCODE_CONFIG, sizeof(fal_servcode_config_t), SW_PARAM_PTR|SW_PARAM_IN, "Servcode Config"),

#define SW_API_SERVCODE_CONFIG_GET_DESC \
    SW_PARAM_DEF(SW_API_SERVCODE_CONFIG_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_SERVCODE_CONFIG_GET, SW_UINT32, 4, SW_PARAM_IN, "Index"), \
    SW_PARAM_DEF(SW_API_SERVCODE_CONFIG_GET, SW_SERVCODE_CONFIG, sizeof(fal_servcode_config_t), SW_PARAM_PTR|SW_PARAM_OUT, "Servcode Config"),

#define SW_API_SERVCODE_LOOPCHECK_EN_DESC \
    SW_PARAM_DEF(SW_API_SERVCODE_LOOPCHECK_EN, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_SERVCODE_LOOPCHECK_EN, SW_ENABLE, 4, SW_PARAM_IN, "Enable"),

#define SW_API_SERVCODE_LOOPCHECK_STATUS_GET_DESC \
    SW_PARAM_DEF(SW_API_SERVCODE_LOOPCHECK_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_SERVCODE_LOOPCHECK_STATUS_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Enable"),

#define SW_API_PORT_SERVCODE_SET_DESC \
    SW_PARAM_DEF(SW_API_PORT_SERVCODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PORT_SERVCODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PORT_SERVCODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Servcode Value"),

#define SW_API_PORT_SERVCODE_GET_DESC \
    SW_PARAM_DEF(SW_API_PORT_SERVCODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PORT_SERVCODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PORT_SERVCODE_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Servcode Value"),

#define SW_API_POLICER_TIMESLOT_SET_DESC \
    SW_PARAM_DEF(SW_API_POLICER_TIMESLOT_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_POLICER_TIMESLOT_SET, SW_UINT32, 4, SW_PARAM_IN, "Time Slot"),

#define SW_API_POLICER_TIMESLOT_GET_DESC \
    SW_PARAM_DEF(SW_API_POLICER_TIMESLOT_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_POLICER_TIMESLOT_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Time Slot"),

#define SW_API_POLICER_PORT_COUNTER_GET_DESC \
    SW_PARAM_DEF(SW_API_POLICER_PORT_COUNTER_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_POLICER_PORT_COUNTER_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_POLICER_PORT_COUNTER_GET, SW_POLICER_COUNTER, sizeof(fal_policer_counter_t), SW_PARAM_PTR|SW_PARAM_OUT, "Port Statistics"),

#define SW_API_POLICER_ACL_COUNTER_GET_DESC \
    SW_PARAM_DEF(SW_API_POLICER_ACL_COUNTER_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_POLICER_ACL_COUNTER_GET, SW_UINT32, 4, SW_PARAM_IN, "Index"), \
    SW_PARAM_DEF(SW_API_POLICER_ACL_COUNTER_GET, SW_POLICER_COUNTER, sizeof(fal_policer_counter_t), SW_PARAM_PTR|SW_PARAM_OUT, "ACL Statistics"),

#define SW_API_POLICER_COMPENSATION_SET_DESC \
    SW_PARAM_DEF(SW_API_POLICER_COMPENSATION_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_POLICER_COMPENSATION_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_POLICER_COMPENSATION_SET, SW_UINT32, 4, SW_PARAM_IN, "Number"),

#define SW_API_POLICER_COMPENSATION_GET_DESC \
    SW_PARAM_DEF(SW_API_POLICER_COMPENSATION_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_POLICER_COMPENSATION_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_POLICER_COMPENSATION_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Number"),

#define SW_API_POLICER_PORT_ENTRY_SET_DESC \
    SW_PARAM_DEF(SW_API_POLICER_PORT_ENTRY_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_POLICER_PORT_ENTRY_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_POLICER_PORT_ENTRY_SET, SW_POLICER_PORT_CONFIG, sizeof(fal_policer_config_t), SW_PARAM_PTR|SW_PARAM_IN, "Port Config"), \
    SW_PARAM_DEF(SW_API_POLICER_PORT_ENTRY_SET, SW_POLICER_CMD_CONFIG, sizeof(fal_policer_action_t), SW_PARAM_PTR|SW_PARAM_IN, "CMD"),

#define SW_API_POLICER_PORT_ENTRY_GET_DESC \
    SW_PARAM_DEF(SW_API_POLICER_PORT_ENTRY_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_POLICER_PORT_ENTRY_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_POLICER_PORT_ENTRY_GET, SW_POLICER_PORT_CONFIG, sizeof(fal_policer_config_t), SW_PARAM_PTR|SW_PARAM_OUT, "Port Config"), \
    SW_PARAM_DEF(SW_API_POLICER_PORT_ENTRY_GET, SW_POLICER_CMD_CONFIG, sizeof(fal_policer_action_t), SW_PARAM_PTR|SW_PARAM_OUT, "CMD"),

#define SW_API_POLICER_ACL_ENTRY_SET_DESC \
    SW_PARAM_DEF(SW_API_POLICER_ACL_ENTRY_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_POLICER_ACL_ENTRY_SET, SW_UINT32, 4, SW_PARAM_IN, "Index"), \
    SW_PARAM_DEF(SW_API_POLICER_ACL_ENTRY_SET, SW_POLICER_ACL_CONFIG, sizeof(fal_policer_config_t), SW_PARAM_PTR|SW_PARAM_IN, "ACL Config"), \
    SW_PARAM_DEF(SW_API_POLICER_ACL_ENTRY_SET, SW_POLICER_CMD_CONFIG, sizeof(fal_policer_action_t), SW_PARAM_PTR|SW_PARAM_IN, "CMD"),

#define SW_API_POLICER_ACL_ENTRY_GET_DESC \
    SW_PARAM_DEF(SW_API_POLICER_ACL_ENTRY_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_POLICER_ACL_ENTRY_GET, SW_UINT32, 4, SW_PARAM_IN, "Index"), \
    SW_PARAM_DEF(SW_API_POLICER_ACL_ENTRY_GET, SW_POLICER_ACL_CONFIG, sizeof(fal_policer_config_t), SW_PARAM_PTR|SW_PARAM_OUT, "ACL Config"), \
    SW_PARAM_DEF(SW_API_POLICER_ACL_ENTRY_GET, SW_POLICER_CMD_CONFIG, sizeof(fal_policer_action_t), SW_PARAM_PTR|SW_PARAM_OUT, "CMD"),

#define SW_API_POLICER_GLOBAL_COUNTER_GET_DESC \
    SW_PARAM_DEF(SW_API_POLICER_GLOBAL_COUNTER_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_POLICER_GLOBAL_COUNTER_GET, SW_POLICER_GLOBAL_COUNTER, sizeof(fal_policer_global_counter_t), SW_PARAM_PTR|SW_PARAM_OUT, "Global Statistics"),

#define SW_API_POLICER_BYPASS_EN_SET_DESC \
    SW_PARAM_DEF(SW_API_POLICER_BYPASS_EN_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_POLICER_BYPASS_EN_SET, SW_UINT32, 4, SW_PARAM_IN, "frame_type"), \
    SW_PARAM_DEF(SW_API_POLICER_BYPASS_EN_SET, SW_ENABLE, 4, SW_PARAM_IN, "Status"),

#define SW_API_POLICER_BYPASS_EN_GET_DESC \
    SW_PARAM_DEF(SW_API_POLICER_BYPASS_EN_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_POLICER_BYPASS_EN_GET, SW_UINT32, 4, SW_PARAM_IN, "frame_type"), \
    SW_PARAM_DEF(SW_API_POLICER_BYPASS_EN_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Status"),

#define SW_API_POLICER_PRIORITY_REMAP_SET_DESC \
    SW_PARAM_DEF(SW_API_POLICER_PRIORITY_REMAP_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_POLICER_PRIORITY_REMAP_SET, SW_POLICER_PRIORITY, \
                                sizeof(fal_policer_priority_t), SW_PARAM_PTR|SW_PARAM_IN, "PRIORITY"), \
    SW_PARAM_DEF(SW_API_POLICER_PRIORITY_REMAP_SET, SW_POLICER_REMAP, \
                                sizeof(fal_policer_remap_t), SW_PARAM_PTR|SW_PARAM_IN, "REMAP"),

#define SW_API_POLICER_PRIORITY_REMAP_GET_DESC \
    SW_PARAM_DEF(SW_API_POLICER_PRIORITY_REMAP_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_POLICER_PRIORITY_REMAP_GET, SW_POLICER_PRIORITY, \
                                sizeof(fal_policer_priority_t), SW_PARAM_PTR|SW_PARAM_IN, "PRIORITY"), \
    SW_PARAM_DEF(SW_API_POLICER_PRIORITY_REMAP_GET, SW_POLICER_REMAP, \
                                sizeof(fal_policer_remap_t), SW_PARAM_PTR|SW_PARAM_OUT, "REMAP"),

#define SW_API_POLICER_CTRL_SET_DESC \
    SW_PARAM_DEF(SW_API_POLICER_CTRL_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_POLICER_CTRL_SET, SW_POLICER_CTRL, \
                                 sizeof(fal_policer_ctrl_t), SW_PARAM_PTR|SW_PARAM_IN, "CTRL"),

#define SW_API_POLICER_CTRL_GET_DESC \
    SW_PARAM_DEF(SW_API_POLICER_CTRL_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_POLICER_CTRL_GET, SW_POLICER_CTRL, \
		    sizeof(fal_policer_ctrl_t), SW_PARAM_PTR|SW_PARAM_OUT, "CTRL"),

#define SW_API_PORT_SHAPER_TIMESLOT_SET_DESC \
    SW_PARAM_DEF(SW_API_PORT_SHAPER_TIMESLOT_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PORT_SHAPER_TIMESLOT_SET, SW_UINT32, 4, SW_PARAM_IN, "Time Slot"),

#define SW_API_PORT_SHAPER_TIMESLOT_GET_DESC \
    SW_PARAM_DEF(SW_API_PORT_SHAPER_TIMESLOT_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PORT_SHAPER_TIMESLOT_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Time Slot"),

#define SW_API_FLOW_SHAPER_TIMESLOT_SET_DESC \
    SW_PARAM_DEF(SW_API_FLOW_SHAPER_TIMESLOT_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_FLOW_SHAPER_TIMESLOT_SET, SW_UINT32, 4, SW_PARAM_IN, "Time Slot"),

#define SW_API_FLOW_SHAPER_TIMESLOT_GET_DESC \
    SW_PARAM_DEF(SW_API_FLOW_SHAPER_TIMESLOT_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_FLOW_SHAPER_TIMESLOT_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Time Slot"),

#define SW_API_QUEUE_SHAPER_TIMESLOT_SET_DESC \
    SW_PARAM_DEF(SW_API_QUEUE_SHAPER_TIMESLOT_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_QUEUE_SHAPER_TIMESLOT_SET, SW_UINT32, 4, SW_PARAM_IN, "Time Slot"),

#define SW_API_QUEUE_SHAPER_TIMESLOT_GET_DESC \
    SW_PARAM_DEF(SW_API_QUEUE_SHAPER_TIMESLOT_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_QUEUE_SHAPER_TIMESLOT_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "Time Slot"),

#define SW_API_PORT_SHAPER_TOKEN_NUMBER_SET_DESC \
    SW_PARAM_DEF(SW_API_PORT_SHAPER_TOKEN_NUMBER_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PORT_SHAPER_TOKEN_NUMBER_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PORT_SHAPER_TOKEN_NUMBER_SET, SW_PORT_SHAPER_TOKEN_CONFIG, sizeof(fal_shaper_token_number_t), SW_PARAM_PTR|SW_PARAM_IN, "CONFIG"),

#define SW_API_PORT_SHAPER_TOKEN_NUMBER_GET_DESC \
    SW_PARAM_DEF(SW_API_PORT_SHAPER_TOKEN_NUMBER_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PORT_SHAPER_TOKEN_NUMBER_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PORT_SHAPER_TOKEN_NUMBER_GET, SW_PORT_SHAPER_TOKEN_CONFIG, sizeof(fal_shaper_token_number_t), SW_PARAM_PTR|SW_PARAM_OUT, "CONFIG"),

#define SW_API_FLOW_SHAPER_TOKEN_NUMBER_SET_DESC \
    SW_PARAM_DEF(SW_API_FLOW_SHAPER_TOKEN_NUMBER_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_FLOW_SHAPER_TOKEN_NUMBER_SET, SW_UINT32, 4, SW_PARAM_IN, "Flow ID"), \
    SW_PARAM_DEF(SW_API_FLOW_SHAPER_TOKEN_NUMBER_SET, SW_SHAPER_TOKEN_CONFIG, sizeof(fal_shaper_token_number_t), SW_PARAM_PTR|SW_PARAM_IN, "CONFIG"),

#define SW_API_FLOW_SHAPER_TOKEN_NUMBER_GET_DESC \
    SW_PARAM_DEF(SW_API_FLOW_SHAPER_TOKEN_NUMBER_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_FLOW_SHAPER_TOKEN_NUMBER_GET, SW_UINT32, 4, SW_PARAM_IN, "Flow ID"), \
    SW_PARAM_DEF(SW_API_FLOW_SHAPER_TOKEN_NUMBER_GET, SW_SHAPER_TOKEN_CONFIG, sizeof(fal_shaper_token_number_t), SW_PARAM_PTR|SW_PARAM_OUT, "CONFIG"),

#define SW_API_QUEUE_SHAPER_TOKEN_NUMBER_SET_DESC \
    SW_PARAM_DEF(SW_API_QUEUE_SHAPER_TOKEN_NUMBER_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_QUEUE_SHAPER_TOKEN_NUMBER_SET, SW_UINT32, 4, SW_PARAM_IN, "Queue ID"), \
    SW_PARAM_DEF(SW_API_QUEUE_SHAPER_TOKEN_NUMBER_SET, SW_SHAPER_TOKEN_CONFIG, sizeof(fal_shaper_token_number_t), SW_PARAM_PTR|SW_PARAM_IN, "CONFIG"),

#define SW_API_QUEUE_SHAPER_TOKEN_NUMBER_GET_DESC \
    SW_PARAM_DEF(SW_API_QUEUE_SHAPER_TOKEN_NUMBER_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_QUEUE_SHAPER_TOKEN_NUMBER_GET, SW_UINT32, 4, SW_PARAM_IN, "Queue ID"), \
    SW_PARAM_DEF(SW_API_QUEUE_SHAPER_TOKEN_NUMBER_GET, SW_SHAPER_TOKEN_CONFIG, sizeof(fal_shaper_token_number_t), SW_PARAM_PTR|SW_PARAM_OUT, "CONFIG"),

#define SW_API_PORT_SHAPER_SET_DESC \
    SW_PARAM_DEF(SW_API_PORT_SHAPER_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PORT_SHAPER_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PORT_SHAPER_SET, SW_PORT_SHAPER_CONFIG, sizeof(fal_shaper_config_t), SW_PARAM_PTR|SW_PARAM_IN, "CONFIG"),

#define SW_API_PORT_SHAPER_GET_DESC \
    SW_PARAM_DEF(SW_API_PORT_SHAPER_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PORT_SHAPER_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PORT_SHAPER_GET, SW_PORT_SHAPER_CONFIG, sizeof(fal_shaper_config_t), SW_PARAM_PTR|SW_PARAM_OUT, "CONFIG"),

#define SW_API_FLOW_SHAPER_SET_DESC \
    SW_PARAM_DEF(SW_API_FLOW_SHAPER_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_FLOW_SHAPER_SET, SW_UINT32, 4, SW_PARAM_IN, "Flow ID"), \
    SW_PARAM_DEF(SW_API_FLOW_SHAPER_SET, SW_SHAPER_CONFIG, sizeof(fal_shaper_config_t), SW_PARAM_PTR|SW_PARAM_IN, "CONFIG"),

#define SW_API_FLOW_SHAPER_GET_DESC \
    SW_PARAM_DEF(SW_API_FLOW_SHAPER_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_FLOW_SHAPER_GET, SW_UINT32, 4, SW_PARAM_IN, "Flow ID"), \
    SW_PARAM_DEF(SW_API_FLOW_SHAPER_GET, SW_SHAPER_CONFIG, sizeof(fal_shaper_config_t), SW_PARAM_PTR|SW_PARAM_OUT, "CONFIG"),

#define SW_API_QUEUE_SHAPER_SET_DESC \
    SW_PARAM_DEF(SW_API_QUEUE_SHAPER_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_QUEUE_SHAPER_SET, SW_UINT32, 4, SW_PARAM_IN, "Queue ID"), \
    SW_PARAM_DEF(SW_API_QUEUE_SHAPER_SET, SW_SHAPER_CONFIG, sizeof(fal_shaper_config_t), SW_PARAM_PTR|SW_PARAM_IN, "CONFIG"),

#define SW_API_QUEUE_SHAPER_GET_DESC \
    SW_PARAM_DEF(SW_API_QUEUE_SHAPER_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_QUEUE_SHAPER_GET, SW_UINT32, 4, SW_PARAM_IN, "Queue ID"), \
    SW_PARAM_DEF(SW_API_QUEUE_SHAPER_GET, SW_SHAPER_CONFIG, sizeof(fal_shaper_config_t), SW_PARAM_PTR|SW_PARAM_OUT, "CONFIG"),

#define SW_API_SHAPER_IPG_PRE_SET_DESC \
    SW_PARAM_DEF(SW_API_SHAPER_IPG_PRE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_SHAPER_IPG_PRE_SET, SW_UINT32, 4, SW_PARAM_IN, "IPG and Preamble"),

#define SW_API_SHAPER_IPG_PRE_GET_DESC \
    SW_PARAM_DEF(SW_API_SHAPER_IPG_PRE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_SHAPER_IPG_PRE_GET, SW_UINT32, 4, SW_PARAM_PTR|SW_PARAM_OUT, "IPG and Preamble"),

#define SW_API_QUEUE_SHAPER_CTRL_SET_DESC \
    SW_PARAM_DEF(SW_API_QUEUE_SHAPER_CTRL_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_QUEUE_SHAPER_CTRL_SET, SW_QUEUE_SHAPER_CTRL, \
		    sizeof(fal_shaper_ctrl_t), SW_PARAM_PTR|SW_PARAM_IN, "CTRL"),

#define SW_API_QUEUE_SHAPER_CTRL_GET_DESC \
    SW_PARAM_DEF(SW_API_QUEUE_SHAPER_CTRL_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_QUEUE_SHAPER_CTRL_GET, SW_QUEUE_SHAPER_CTRL, \
		    sizeof(fal_shaper_ctrl_t), SW_PARAM_PTR|SW_PARAM_OUT, "CTRL"),

#define SW_API_FLOW_SHAPER_CTRL_SET_DESC \
    SW_PARAM_DEF(SW_API_FLOW_SHAPER_CTRL_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_FLOW_SHAPER_CTRL_SET, SW_FLOW_SHAPER_CTRL, \
		    sizeof(fal_shaper_ctrl_t), SW_PARAM_PTR|SW_PARAM_IN, "CTRL"),

#define SW_API_FLOW_SHAPER_CTRL_GET_DESC \
    SW_PARAM_DEF(SW_API_FLOW_SHAPER_CTRL_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_FLOW_SHAPER_CTRL_GET, SW_FLOW_SHAPER_CTRL, \
		    sizeof(fal_shaper_ctrl_t), SW_PARAM_PTR|SW_PARAM_OUT, "CTRL"),

#define SW_API_BM_CTRL_SET_DESC \
    SW_PARAM_DEF(SW_API_BM_CTRL_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_BM_CTRL_SET, SW_UINT32, 4, SW_PARAM_IN, "port id"), \
    SW_PARAM_DEF(SW_API_BM_CTRL_SET, SW_ENABLE, 4, SW_PARAM_IN, "bm ctrl"),

#define SW_API_BM_CTRL_GET_DESC \
    SW_PARAM_DEF(SW_API_BM_CTRL_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_BM_CTRL_GET, SW_UINT32, 4, SW_PARAM_IN, "port id"), \
    SW_PARAM_DEF(SW_API_BM_CTRL_GET, SW_ENABLE, 4, SW_PARAM_PTR|SW_PARAM_OUT, "bm ctrl"),

#define SW_API_BM_PORTGROUP_MAP_SET_DESC \
    SW_PARAM_DEF(SW_API_BM_PORTGROUP_MAP_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_BM_PORTGROUP_MAP_SET, SW_UINT32, 4, SW_PARAM_IN, "port id"), \
    SW_PARAM_DEF(SW_API_BM_PORTGROUP_MAP_SET, SW_UINT8, 4, SW_PARAM_IN, "group"),

#define SW_API_BM_PORTGROUP_MAP_GET_DESC \
    SW_PARAM_DEF(SW_API_BM_PORTGROUP_MAP_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_BM_PORTGROUP_MAP_GET, SW_UINT32, 4, SW_PARAM_IN, "port id"), \
    SW_PARAM_DEF(SW_API_BM_PORTGROUP_MAP_GET, SW_UINT8, 4, \
		    SW_PARAM_PTR|SW_PARAM_OUT, "group"),

#define SW_API_BM_GROUP_BUFFER_SET_DESC \
    SW_PARAM_DEF(SW_API_BM_GROUP_BUFFER_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_BM_GROUP_BUFFER_SET, SW_UINT8, 1, SW_PARAM_IN, "group id"), \
    SW_PARAM_DEF(SW_API_BM_GROUP_BUFFER_SET, SW_UINT16, 2, SW_PARAM_IN, "buff num"),

#define SW_API_BM_GROUP_BUFFER_GET_DESC \
    SW_PARAM_DEF(SW_API_BM_GROUP_BUFFER_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_BM_GROUP_BUFFER_GET, SW_UINT8, 1, SW_PARAM_IN, "group id"), \
    SW_PARAM_DEF(SW_API_BM_GROUP_BUFFER_GET, SW_UINT16, 2, \
		    SW_PARAM_PTR|SW_PARAM_OUT, "buff num"),

#define SW_API_BM_PORT_RSVBUFFER_SET_DESC \
    SW_PARAM_DEF(SW_API_BM_PORT_RSVBUFFER_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_BM_PORT_RSVBUFFER_SET, SW_UINT32, 4, SW_PARAM_IN, "port id"), \
    SW_PARAM_DEF(SW_API_BM_PORT_RSVBUFFER_SET, SW_UINT16, 2, SW_PARAM_IN, "prealloc buff"), \
    SW_PARAM_DEF(SW_API_BM_PORT_RSVBUFFER_SET, SW_UINT16, 2, SW_PARAM_IN, "react buff"),

#define SW_API_BM_PORT_RSVBUFFER_GET_DESC \
    SW_PARAM_DEF(SW_API_BM_PORT_RSVBUFFER_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_BM_PORT_RSVBUFFER_GET, SW_UINT32, 4, SW_PARAM_IN, "port id"), \
    SW_PARAM_DEF(SW_API_BM_PORT_RSVBUFFER_GET, SW_UINT16, 2, \
		    SW_PARAM_PTR|SW_PARAM_OUT, "prealloc num"), \
    SW_PARAM_DEF(SW_API_BM_PORT_RSVBUFFER_GET, SW_UINT16, 2, \
		    SW_PARAM_PTR|SW_PARAM_OUT, "react num"),

#define SW_API_BM_STATIC_THRESH_SET_DESC \
    SW_PARAM_DEF(SW_API_BM_STATIC_THRESH_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_BM_STATIC_THRESH_SET, SW_UINT32, 4, SW_PARAM_IN, "port id"), \
    SW_PARAM_DEF(SW_API_BM_STATIC_THRESH_SET, SW_BMSTHRESH, sizeof(fal_bm_static_cfg_t), \
		    SW_PARAM_PTR|SW_PARAM_IN, \
		    "static thresh"),

#define SW_API_BM_STATIC_THRESH_GET_DESC \
    SW_PARAM_DEF(SW_API_BM_STATIC_THRESH_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_BM_STATIC_THRESH_GET, SW_UINT32, 4, SW_PARAM_IN, "port id"), \
    SW_PARAM_DEF(SW_API_BM_STATIC_THRESH_GET, SW_BMSTHRESH, \
		    sizeof(fal_bm_static_cfg_t), SW_PARAM_PTR|SW_PARAM_OUT, \
		    "static thresh"),

#define SW_API_BM_DYNAMIC_THRESH_SET_DESC \
    SW_PARAM_DEF(SW_API_BM_DYNAMIC_THRESH_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_BM_DYNAMIC_THRESH_SET, SW_UINT32, 4, SW_PARAM_IN, "port id"), \
    SW_PARAM_DEF(SW_API_BM_DYNAMIC_THRESH_SET, SW_BMDTHRESH, \
		    sizeof(fal_bm_dynamic_cfg_t), SW_PARAM_PTR|SW_PARAM_IN, \
		    "dynamic thresh"),

#define SW_API_BM_DYNAMIC_THRESH_GET_DESC \
    SW_PARAM_DEF(SW_API_BM_DYNAMIC_THRESH_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_BM_DYNAMIC_THRESH_GET, SW_UINT32, 4, SW_PARAM_IN, "port id"), \
    SW_PARAM_DEF(SW_API_BM_DYNAMIC_THRESH_GET, SW_BMDTHRESH, \
		    sizeof(fal_bm_dynamic_cfg_t), SW_PARAM_PTR|SW_PARAM_OUT, \
		    "dynamic thresh"),

#define SW_API_BM_PORT_COUNTER_GET_DESC \
    SW_PARAM_DEF(SW_API_BM_PORT_COUNTER_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_BM_PORT_COUNTER_GET, SW_UINT32, 4, SW_PARAM_IN, "port id"), \
    SW_PARAM_DEF(SW_API_BM_PORT_COUNTER_GET, SW_BMPORTCNT, \
		    sizeof(fal_bm_port_counter_t), SW_PARAM_PTR|SW_PARAM_OUT, \
		    "port counter"),


#define SW_API_PTP_CONFIG_SET_DESC \
    SW_PARAM_DEF(SW_API_PTP_CONFIG_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PTP_CONFIG_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PTP_CONFIG_SET, SW_PTP_CONFIG, \
		    sizeof(fal_ptp_config_t), SW_PARAM_PTR|SW_PARAM_IN, "CONFIG"),

#define SW_API_PTP_CONFIG_GET_DESC \
    SW_PARAM_DEF(SW_API_PTP_CONFIG_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PTP_CONFIG_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PTP_CONFIG_GET, SW_PTP_CONFIG, \
		    sizeof(fal_ptp_config_t), SW_PARAM_PTR|SW_PARAM_OUT, "CONFIG"),

#define SW_API_PTP_REFERENCE_CLOCK_SET_DESC \
    SW_PARAM_DEF(SW_API_PTP_REFERENCE_CLOCK_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PTP_REFERENCE_CLOCK_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PTP_REFERENCE_CLOCK_SET, SW_PTP_REFERENCE_CLOCK, \
		    sizeof(fal_ptp_reference_clock_t), SW_PARAM_IN, "Ref Clock"),

#define SW_API_PTP_REFERENCE_CLOCK_GET_DESC \
    SW_PARAM_DEF(SW_API_PTP_REFERENCE_CLOCK_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PTP_REFERENCE_CLOCK_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PTP_REFERENCE_CLOCK_GET, SW_PTP_REFERENCE_CLOCK, \
		    sizeof(fal_ptp_reference_clock_t), SW_PARAM_PTR|SW_PARAM_OUT, \
		    "Ref Clock"),

#define SW_API_PTP_RX_TIMESTAMP_MODE_SET_DESC \
    SW_PARAM_DEF(SW_API_PTP_RX_TIMESTAMP_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PTP_RX_TIMESTAMP_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PTP_RX_TIMESTAMP_MODE_SET, SW_PTP_RX_TIMESTAMP_MODE, \
		    sizeof(fal_ptp_rx_timestamp_mode_t), SW_PARAM_IN, "Timestamp Mode"),

#define SW_API_PTP_RX_TIMESTAMP_MODE_GET_DESC \
    SW_PARAM_DEF(SW_API_PTP_RX_TIMESTAMP_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PTP_RX_TIMESTAMP_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PTP_RX_TIMESTAMP_MODE_GET, SW_PTP_RX_TIMESTAMP_MODE, \
		    sizeof(fal_ptp_rx_timestamp_mode_t), SW_PARAM_PTR|SW_PARAM_OUT, \
		    "Timestamp Mode"),

#define SW_API_PTP_TIMESTAMP_GET_DESC \
    SW_PARAM_DEF(SW_API_PTP_TIMESTAMP_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PTP_TIMESTAMP_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PTP_TIMESTAMP_GET, SW_PTP_DIRECTION, \
		    sizeof(fal_ptp_direction_t), SW_PARAM_IN, "Direction"), \
    SW_PARAM_DEF(SW_API_PTP_TIMESTAMP_GET, SW_PTP_PKT_INFO, \
		    sizeof(fal_ptp_pkt_info_t), \
		    SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Pkt Info"), \
    SW_PARAM_DEF(SW_API_PTP_TIMESTAMP_GET, SW_PTP_TIME, \
		    sizeof(fal_ptp_time_t), SW_PARAM_PTR|SW_PARAM_OUT, "Time"),

#define SW_API_PTP_PKT_TIMESTAMP_SET_DESC \
    SW_PARAM_DEF(SW_API_PTP_PKT_TIMESTAMP_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PTP_PKT_TIMESTAMP_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PTP_PKT_TIMESTAMP_SET, SW_PTP_TIME, \
		    sizeof(fal_ptp_time_t), SW_PARAM_PTR|SW_PARAM_IN, "Time"),

#define SW_API_PTP_PKT_TIMESTAMP_GET_DESC \
    SW_PARAM_DEF(SW_API_PTP_PKT_TIMESTAMP_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PTP_PKT_TIMESTAMP_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PTP_PKT_TIMESTAMP_GET, SW_PTP_TIME, \
		    sizeof(fal_ptp_time_t), SW_PARAM_PTR|SW_PARAM_OUT, "Time"),

#define SW_API_PTP_GRANDMASTER_MODE_SET_DESC \
    SW_PARAM_DEF(SW_API_PTP_GRANDMASTER_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PTP_GRANDMASTER_MODE_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PTP_GRANDMASTER_MODE_SET, SW_PTP_GRANDMASTER_MODE, \
		    sizeof(fal_ptp_grandmaster_mode_t), SW_PARAM_PTR|SW_PARAM_IN, \
		    "Grandmaster Mode"),

#define SW_API_PTP_GRANDMASTER_MODE_GET_DESC \
    SW_PARAM_DEF(SW_API_PTP_GRANDMASTER_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PTP_GRANDMASTER_MODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PTP_GRANDMASTER_MODE_GET, SW_PTP_GRANDMASTER_MODE, \
		    sizeof(fal_ptp_grandmaster_mode_t), SW_PARAM_PTR|SW_PARAM_OUT, \
		    "Grandmaster Mode"),

#define SW_API_PTP_RTC_TIME_SET_DESC \
    SW_PARAM_DEF(SW_API_PTP_RTC_TIME_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PTP_RTC_TIME_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PTP_RTC_TIME_SET, SW_PTP_TIME, \
		    sizeof(fal_ptp_time_t), SW_PARAM_PTR|SW_PARAM_IN, "Time"),

#define SW_API_PTP_RTC_TIME_GET_DESC \
    SW_PARAM_DEF(SW_API_PTP_RTC_TIME_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PTP_RTC_TIME_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PTP_RTC_TIME_GET, SW_PTP_TIME, \
		    sizeof(fal_ptp_time_t), SW_PARAM_PTR|SW_PARAM_OUT, "Time"),

#define SW_API_PTP_RTC_TIME_CLEAR_DESC \
    SW_PARAM_DEF(SW_API_PTP_RTC_TIME_CLEAR, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PTP_RTC_TIME_CLEAR, SW_UINT32, 4, SW_PARAM_IN, "Port ID"),

#define SW_API_PTP_RTC_ADJTIME_SET_DESC \
    SW_PARAM_DEF(SW_API_PTP_RTC_ADJTIME_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PTP_RTC_ADJTIME_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PTP_RTC_ADJTIME_SET, SW_PTP_TIME, \
		    sizeof(fal_ptp_time_t), SW_PARAM_PTR|SW_PARAM_IN, "Time"),

#define SW_API_PTP_RTC_ADJFREQ_SET_DESC \
    SW_PARAM_DEF(SW_API_PTP_RTC_ADJFREQ_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PTP_RTC_ADJFREQ_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PTP_RTC_ADJFREQ_SET, SW_PTP_TIME, \
		    sizeof(fal_ptp_time_t), SW_PARAM_PTR|SW_PARAM_IN, "Time"),

#define SW_API_PTP_RTC_ADJFREQ_GET_DESC \
    SW_PARAM_DEF(SW_API_PTP_RTC_ADJFREQ_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PTP_RTC_ADJFREQ_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PTP_RTC_ADJFREQ_GET, SW_PTP_TIME, \
		    sizeof(fal_ptp_time_t), SW_PARAM_PTR|SW_PARAM_OUT, "Time"),

#define SW_API_PTP_LINK_DELAY_SET_DESC \
    SW_PARAM_DEF(SW_API_PTP_LINK_DELAY_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PTP_LINK_DELAY_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PTP_LINK_DELAY_SET, SW_PTP_TIME, \
		    sizeof(fal_ptp_time_t), SW_PARAM_PTR|SW_PARAM_IN, "Time"),

#define SW_API_PTP_LINK_DELAY_GET_DESC \
    SW_PARAM_DEF(SW_API_PTP_LINK_DELAY_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PTP_LINK_DELAY_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PTP_LINK_DELAY_GET, SW_PTP_TIME, \
		    sizeof(fal_ptp_time_t), SW_PARAM_PTR|SW_PARAM_OUT, "Time"),

#define SW_API_PTP_SECURITY_SET_DESC \
    SW_PARAM_DEF(SW_API_PTP_SECURITY_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PTP_SECURITY_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PTP_SECURITY_SET, SW_PTP_SECURITY, \
		    sizeof(fal_ptp_security_t), SW_PARAM_PTR|SW_PARAM_IN, "Security"),

#define SW_API_PTP_SECURITY_GET_DESC \
    SW_PARAM_DEF(SW_API_PTP_SECURITY_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PTP_SECURITY_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PTP_SECURITY_GET, SW_PTP_SECURITY, \
		    sizeof(fal_ptp_security_t), SW_PARAM_PTR|SW_PARAM_OUT, "Security"),

#define SW_API_PTP_PPS_SIGNAL_CONTROL_SET_DESC \
    SW_PARAM_DEF(SW_API_PTP_PPS_SIGNAL_CONTROL_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PTP_PPS_SIGNAL_CONTROL_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PTP_PPS_SIGNAL_CONTROL_SET, SW_PTP_PPS_SIGNAL_CONTROL, \
		    sizeof(fal_ptp_pps_signal_control_t), SW_PARAM_PTR|SW_PARAM_IN, "Sig Ctrl"),

#define SW_API_PTP_PPS_SIGNAL_CONTROL_GET_DESC \
    SW_PARAM_DEF(SW_API_PTP_PPS_SIGNAL_CONTROL_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PTP_PPS_SIGNAL_CONTROL_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PTP_PPS_SIGNAL_CONTROL_GET, SW_PTP_PPS_SIGNAL_CONTROL, \
		    sizeof(fal_ptp_pps_signal_control_t), SW_PARAM_PTR|SW_PARAM_OUT, "Sig Ctrl"),

#define SW_API_PTP_RX_CRC_RECALC_SET_DESC \
    SW_PARAM_DEF(SW_API_PTP_RX_CRC_RECALC_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PTP_RX_CRC_RECALC_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PTP_RX_CRC_RECALC_SET, SW_ENABLE, \
		    sizeof(a_bool_t), SW_PARAM_IN, "Status"),

#define SW_API_PTP_RX_CRC_RECALC_GET_DESC \
    SW_PARAM_DEF(SW_API_PTP_RX_CRC_RECALC_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PTP_RX_CRC_RECALC_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PTP_RX_CRC_RECALC_GET, SW_ENABLE, \
		    sizeof(a_bool_t), SW_PARAM_PTR|SW_PARAM_OUT, "Status"),

#define SW_API_PTP_ASYM_CORRECTION_SET_DESC \
    SW_PARAM_DEF(SW_API_PTP_ASYM_CORRECTION_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PTP_ASYM_CORRECTION_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PTP_ASYM_CORRECTION_SET, SW_PTP_ASYM_CORRECTION, \
		    sizeof(fal_ptp_asym_correction_t), SW_PARAM_PTR|SW_PARAM_IN, "Asym CF"),

#define SW_API_PTP_ASYM_CORRECTION_GET_DESC \
    SW_PARAM_DEF(SW_API_PTP_ASYM_CORRECTION_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PTP_ASYM_CORRECTION_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PTP_ASYM_CORRECTION_GET, SW_PTP_ASYM_CORRECTION, \
		    sizeof(fal_ptp_asym_correction_t), SW_PARAM_PTR|SW_PARAM_OUT, "Asym CF"),

#define SW_API_PTP_OUTPUT_WAVEFORM_SET_DESC \
    SW_PARAM_DEF(SW_API_PTP_OUTPUT_WAVEFORM_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PTP_OUTPUT_WAVEFORM_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PTP_OUTPUT_WAVEFORM_SET, SW_PTP_OUTPUT_WAVEFORM, \
		    sizeof(fal_ptp_output_waveform_t), SW_PARAM_PTR|SW_PARAM_IN, "Waveform"),

#define SW_API_PTP_OUTPUT_WAVEFORM_GET_DESC \
    SW_PARAM_DEF(SW_API_PTP_OUTPUT_WAVEFORM_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PTP_OUTPUT_WAVEFORM_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PTP_OUTPUT_WAVEFORM_GET, SW_PTP_OUTPUT_WAVEFORM, \
		    sizeof(fal_ptp_output_waveform_t), SW_PARAM_PTR|SW_PARAM_OUT, "Waveform"),

#define SW_API_PTP_RTC_TIME_SNAPSHOT_SET_DESC \
    SW_PARAM_DEF(SW_API_PTP_RTC_TIME_SNAPSHOT_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PTP_RTC_TIME_SNAPSHOT_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PTP_RTC_TIME_SNAPSHOT_SET, SW_ENABLE, \
		    sizeof(a_bool_t), SW_PARAM_IN, "Status"),

#define SW_API_PTP_RTC_TIME_SNAPSHOT_GET_DESC \
    SW_PARAM_DEF(SW_API_PTP_RTC_TIME_SNAPSHOT_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PTP_RTC_TIME_SNAPSHOT_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PTP_RTC_TIME_SNAPSHOT_GET, SW_ENABLE, \
		    sizeof(a_bool_t), SW_PARAM_PTR|SW_PARAM_OUT, "Status"),

#define SW_API_PTP_INCREMENT_SYNC_FROM_CLOCK_SET_DESC \
    SW_PARAM_DEF(SW_API_PTP_INCREMENT_SYNC_FROM_CLOCK_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PTP_INCREMENT_SYNC_FROM_CLOCK_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PTP_INCREMENT_SYNC_FROM_CLOCK_SET, SW_ENABLE, \
		    sizeof(a_bool_t), SW_PARAM_IN, "Status"),

#define SW_API_PTP_INCREMENT_SYNC_FROM_CLOCK_GET_DESC \
    SW_PARAM_DEF(SW_API_PTP_INCREMENT_SYNC_FROM_CLOCK_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PTP_INCREMENT_SYNC_FROM_CLOCK_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PTP_INCREMENT_SYNC_FROM_CLOCK_GET, SW_ENABLE, \
		    sizeof(a_bool_t), SW_PARAM_PTR|SW_PARAM_OUT, "Status"),

#define SW_API_PTP_TOD_UART_SET_DESC \
    SW_PARAM_DEF(SW_API_PTP_TOD_UART_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PTP_TOD_UART_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PTP_TOD_UART_SET, SW_PTP_TOD_UART, \
		    sizeof(fal_ptp_tod_uart_t), SW_PARAM_PTR|SW_PARAM_IN, "TOD UART"),

#define SW_API_PTP_TOD_UART_GET_DESC \
    SW_PARAM_DEF(SW_API_PTP_TOD_UART_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PTP_TOD_UART_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PTP_TOD_UART_GET, SW_PTP_TOD_UART, \
		    sizeof(fal_ptp_tod_uart_t), SW_PARAM_PTR|SW_PARAM_OUT, "TOD UART"),

#define SW_API_PTP_ENHANCED_TIMESTAMP_ENGINE_SET_DESC \
    SW_PARAM_DEF(SW_API_PTP_ENHANCED_TIMESTAMP_ENGINE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PTP_ENHANCED_TIMESTAMP_ENGINE_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PTP_ENHANCED_TIMESTAMP_ENGINE_SET, SW_PTP_DIRECTION, \
		    sizeof(fal_ptp_direction_t), SW_PARAM_IN, "Direction"), \
    SW_PARAM_DEF(SW_API_PTP_ENHANCED_TIMESTAMP_ENGINE_SET, SW_PTP_ENHANCED_TS_ENGINE, \
		    sizeof(fal_ptp_enhanced_ts_engine_t), SW_PARAM_PTR|SW_PARAM_IN, "TS Engine"),

#define SW_API_PTP_ENHANCED_TIMESTAMP_ENGINE_GET_DESC \
    SW_PARAM_DEF(SW_API_PTP_ENHANCED_TIMESTAMP_ENGINE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PTP_ENHANCED_TIMESTAMP_ENGINE_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PTP_ENHANCED_TIMESTAMP_ENGINE_GET, \
		    SW_PTP_DIRECTION, sizeof(fal_ptp_direction_t), SW_PARAM_IN, "Direction"), \
    SW_PARAM_DEF(SW_API_PTP_ENHANCED_TIMESTAMP_ENGINE_GET, SW_PTP_ENHANCED_TS_ENGINE, \
		    sizeof(fal_ptp_enhanced_ts_engine_t), SW_PARAM_PTR|SW_PARAM_OUT, "TS Engine"),

#define SW_API_PTP_TRIGGER_SET_DESC \
    SW_PARAM_DEF(SW_API_PTP_TRIGGER_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PTP_TRIGGER_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PTP_TRIGGER_SET, SW_UINT32, 4, SW_PARAM_IN, "Trigger ID"), \
    SW_PARAM_DEF(SW_API_PTP_TRIGGER_SET, SW_PTP_TRIGGER, \
		    sizeof(fal_ptp_trigger_t), SW_PARAM_PTR|SW_PARAM_IN, "Trigger"),

#define SW_API_PTP_TRIGGER_GET_DESC \
    SW_PARAM_DEF(SW_API_PTP_TRIGGER_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PTP_TRIGGER_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PTP_TRIGGER_GET, SW_UINT32, 4, SW_PARAM_IN, "Trigger ID"), \
    SW_PARAM_DEF(SW_API_PTP_TRIGGER_GET, SW_PTP_TRIGGER, \
		    sizeof(fal_ptp_trigger_t), SW_PARAM_PTR|SW_PARAM_OUT, "Trigger"),

#define SW_API_PTP_CAPTURE_SET_DESC \
    SW_PARAM_DEF(SW_API_PTP_CAPTURE_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PTP_CAPTURE_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PTP_CAPTURE_SET, SW_UINT32, 4, SW_PARAM_IN, "Capture ID"), \
    SW_PARAM_DEF(SW_API_PTP_CAPTURE_SET, SW_PTP_CAPTURE, \
		    sizeof(fal_ptp_capture_t), SW_PARAM_PTR|SW_PARAM_IN, "Capture"),

#define SW_API_PTP_CAPTURE_GET_DESC \
    SW_PARAM_DEF(SW_API_PTP_CAPTURE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PTP_CAPTURE_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PTP_CAPTURE_GET, SW_UINT32, 4, SW_PARAM_IN, "Capture ID"), \
    SW_PARAM_DEF(SW_API_PTP_CAPTURE_GET, SW_PTP_CAPTURE, \
		    sizeof(fal_ptp_capture_t), SW_PARAM_PTR|SW_PARAM_OUT, "Capture"),

#define SW_API_PTP_INTERRUPT_SET_DESC \
    SW_PARAM_DEF(SW_API_PTP_INTERRUPT_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PTP_INTERRUPT_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PTP_INTERRUPT_SET, SW_PTP_INTERRUPT, \
		    sizeof(fal_ptp_interrupt_t), SW_PARAM_PTR|SW_PARAM_IN, "Interrupt"),

#define SW_API_PTP_INTERRUPT_GET_DESC \
    SW_PARAM_DEF(SW_API_PTP_INTERRUPT_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PTP_INTERRUPT_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PTP_INTERRUPT_GET, SW_PTP_INTERRUPT, \
		    sizeof(fal_ptp_interrupt_t), SW_PARAM_PTR|SW_PARAM_OUT, "Interrupt"),

#define SW_API_PTP_RTC_SYNC_SET_DESC \
    SW_PARAM_DEF(SW_API_PTP_RTC_SYNC_SET, SW_UINT32, sizeof(a_uint32_t), \
		    SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PTP_RTC_SYNC_SET, SW_UINT32, sizeof(a_uint32_t), \
		    SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PTP_RTC_SYNC_SET, SW_RTC_SRC_TYPE, sizeof(fal_ptp_rtc_src_type_t), \
		    SW_PARAM_IN, "RTC SRC type"), \
    SW_PARAM_DEF(SW_API_PTP_RTC_SYNC_SET, SW_UINT32, sizeof(a_uint32_t), \
		    SW_PARAM_IN, "SRC ID"),

#define SW_API_PTP_RTC_SYNC_GET_DESC \
    SW_PARAM_DEF(SW_API_PTP_RTC_SYNC_GET, SW_UINT32, sizeof(a_uint32_t), \
		    SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_PTP_RTC_SYNC_GET, SW_UINT32, sizeof(a_uint32_t), \
		    SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_PTP_RTC_SYNC_GET, SW_RTC_SRC_TYPE, sizeof(fal_ptp_rtc_src_type_t), \
		    SW_PARAM_PTR|SW_PARAM_OUT, "RTC SRC type"), \
    SW_PARAM_DEF(SW_API_PTP_RTC_SYNC_GET, SW_UINT32, sizeof(a_uint32_t), \
		    SW_PARAM_PTR|SW_PARAM_OUT, "SRC ID"),

#define SW_API_SFP_DATA_GET_DESC \
    SW_PARAM_DEF(SW_API_SFP_DATA_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_SFP_DATA_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_SFP_DATA_GET, SW_SFP_DATA, \
		    sizeof(fal_sfp_data_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Data"),

#define SW_API_SFP_DATA_SET_DESC \
    SW_PARAM_DEF(SW_API_SFP_DATA_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"),\
    SW_PARAM_DEF(SW_API_SFP_DATA_SET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_SFP_DATA_SET, SW_SFP_DATA, \
		    sizeof(fal_sfp_data_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Data"),

#define SW_API_SFP_DEV_TYPE_GET_DESC \
    SW_PARAM_DEF(SW_API_SFP_DEV_TYPE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_SFP_DEV_TYPE_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_SFP_DEV_TYPE_GET, SW_SFP_DEV_TYPE, \
		    sizeof(fal_sfp_dev_type_t), SW_PARAM_PTR|SW_PARAM_OUT, "Device Type"),

#define SW_API_SFP_TRANSC_CODE_GET_DESC \
    SW_PARAM_DEF(SW_API_SFP_TRANSC_CODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_SFP_TRANSC_CODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_SFP_TRANSC_CODE_GET, SW_SFP_TRANSC_CODE, \
		    sizeof(fal_sfp_transc_code_t), SW_PARAM_PTR|SW_PARAM_OUT, "Transceiver Code"),

#define SW_API_SFP_RATE_ENCODE_GET_DESC \
    SW_PARAM_DEF(SW_API_SFP_RATE_ENCODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_SFP_RATE_ENCODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_SFP_RATE_ENCODE_GET, SW_SFP_RATE_ENCODE, \
		    sizeof(fal_sfp_rate_encode_t), SW_PARAM_PTR|SW_PARAM_OUT, "Rate Encode"),

#define SW_API_SFP_LINK_LENGTH_GET_DESC \
    SW_PARAM_DEF(SW_API_SFP_LINK_LENGTH_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_SFP_LINK_LENGTH_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_SFP_LINK_LENGTH_GET, SW_SFP_LINK_LENGTH, \
		    sizeof(fal_sfp_link_length_t), SW_PARAM_PTR|SW_PARAM_OUT, "Link Length"),

#define SW_API_SFP_VENDOR_INFO_GET_DESC \
    SW_PARAM_DEF(SW_API_SFP_VENDOR_INFO_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_SFP_VENDOR_INFO_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_SFP_VENDOR_INFO_GET, SW_SFP_VENDOR_INFO, \
		    sizeof(fal_sfp_vendor_info_t), SW_PARAM_PTR|SW_PARAM_OUT, "Vendor Info"),

#define SW_API_SFP_LASER_WAVELENGTH_GET_DESC \
    SW_PARAM_DEF(SW_API_SFP_LASER_WAVELENGTH_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_SFP_LASER_WAVELENGTH_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_SFP_LASER_WAVELENGTH_GET, SW_SFP_LASER_WAVELENGTH, \
		    sizeof(fal_sfp_laser_wavelength_t), SW_PARAM_PTR|SW_PARAM_OUT, "Wave Length"),

#define SW_API_SFP_OPTION_GET_DESC \
    SW_PARAM_DEF(SW_API_SFP_OPTION_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_SFP_OPTION_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_SFP_OPTION_GET, SW_SFP_OPTION, \
		    sizeof(fal_sfp_option_t), SW_PARAM_PTR|SW_PARAM_OUT, "Option"),

#define SW_API_SFP_CTRL_RATE_GET_DESC \
    SW_PARAM_DEF(SW_API_SFP_CTRL_RATE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_SFP_CTRL_RATE_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_SFP_CTRL_RATE_GET, SW_SFP_CTRL_RATE, \
		    sizeof(fal_sfp_rate_t), SW_PARAM_PTR|SW_PARAM_OUT, "Control Rate"),

#define SW_API_SFP_ENHANCED_CFG_GET_DESC \
    SW_PARAM_DEF(SW_API_SFP_ENHANCED_CFG_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_SFP_ENHANCED_CFG_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_SFP_ENHANCED_CFG_GET, SW_SFP_ENHANCED_CFG, \
		    sizeof(fal_sfp_enhanced_cfg_t), SW_PARAM_PTR|SW_PARAM_OUT, "Enhanced Config"),

#define SW_API_SFP_DIAG_THRESHOLD_GET_DESC \
    SW_PARAM_DEF(SW_API_SFP_DIAG_THRESHOLD_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_SFP_DIAG_THRESHOLD_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_SFP_DIAG_THRESHOLD_GET, SW_SFP_DIAG_THRESHOLD, \
		    sizeof(fal_sfp_internal_threshold_t), SW_PARAM_PTR|SW_PARAM_OUT, "Threshold"),

#define SW_API_SFP_DIAG_CAL_CONST_GET_DESC \
    SW_PARAM_DEF(SW_API_SFP_DIAG_CAL_CONST_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_SFP_DIAG_CAL_CONST_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_SFP_DIAG_CAL_CONST_GET, SW_SFP_DIAG_CAL_CONST, \
		    sizeof(fal_sfp_cal_const_t), SW_PARAM_PTR|SW_PARAM_OUT, "Calibration"),

#define SW_API_SFP_DIAG_REALTIME_GET_DESC \
    SW_PARAM_DEF(SW_API_SFP_DIAG_REALTIME_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_SFP_DIAG_REALTIME_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_SFP_DIAG_REALTIME_GET, SW_SFP_DIAG_REALTIME, \
		    sizeof(fal_sfp_realtime_diag_t), SW_PARAM_PTR|SW_PARAM_OUT, "Realtime Diag"),

#define SW_API_SFP_DIAG_CTRL_STATUS_GET_DESC \
    SW_PARAM_DEF(SW_API_SFP_DIAG_CTRL_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_SFP_DIAG_CTRL_STATUS_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_SFP_DIAG_CTRL_STATUS_GET, SW_SFP_CTRL_STATUS, \
		    sizeof(fal_sfp_ctrl_status_t), SW_PARAM_PTR|SW_PARAM_OUT, "Control Status"),

#define SW_API_SFP_DIAG_ALARM_WARN_FLAG_GET_DESC \
    SW_PARAM_DEF(SW_API_SFP_DIAG_ALARM_WARN_FLAG_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_SFP_DIAG_ALARM_WARN_FLAG_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_SFP_DIAG_ALARM_WARN_FLAG_GET, SW_SFP_ALARM_WARN_FLAG, \
		    sizeof(fal_sfp_alarm_warn_flag_t), SW_PARAM_PTR|SW_PARAM_OUT, "A/W Flag"),

#define SW_API_SFP_CHECKCODE_GET_DESC \
    SW_PARAM_DEF(SW_API_SFP_CHECKCODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_SFP_CHECKCODE_GET, SW_UINT32, 4, SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_SFP_CHECKCODE_GET, SW_SFP_CCODE_TYPE, \
		    sizeof(fal_sfp_cc_type_t), SW_PARAM_IN, "Check Code Type"), \
    SW_PARAM_DEF(SW_API_SFP_CHECKCODE_GET, SW_UINT8, \
		    sizeof(a_uint8_t), SW_PARAM_PTR|SW_PARAM_OUT, "Check Code"),

#define SW_API_VPORT_PHYSICAL_PORT_GET_DESC \
    SW_PARAM_DEF(SW_API_VPORT_PHYSICAL_PORT_GET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_VPORT_PHYSICAL_PORT_GET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "Virtual Port ID"), \
    SW_PARAM_DEF(SW_API_VPORT_PHYSICAL_PORT_GET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_PTR|SW_PARAM_OUT, "Physical Port ID"),

#define SW_API_VPORT_PHYSICAL_PORT_SET_DESC \
    SW_PARAM_DEF(SW_API_VPORT_PHYSICAL_PORT_SET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_VPORT_PHYSICAL_PORT_SET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "Virtual Port ID"), \
    SW_PARAM_DEF(SW_API_VPORT_PHYSICAL_PORT_SET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "Physical Port ID"),

#define SW_API_VPORT_STATE_CHECK_SET_DESC \
    SW_PARAM_DEF(SW_API_VPORT_STATE_CHECK_SET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_VPORT_STATE_CHECK_SET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_VPORT_STATE_CHECK_SET, SW_VPORT_STATE, \
		    sizeof(fal_vport_state_t), SW_PARAM_IN|SW_PARAM_PTR, "state check"),

#define SW_API_VPORT_STATE_CHECK_GET_DESC \
    SW_PARAM_DEF(SW_API_VPORT_STATE_CHECK_GET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_VPORT_STATE_CHECK_GET, SW_UINT32, \
		    sizeof(a_uint32_t), SW_PARAM_IN, "Port ID"), \
    SW_PARAM_DEF(SW_API_VPORT_STATE_CHECK_GET, SW_VPORT_STATE, \
		    sizeof(fal_vport_state_t), SW_PARAM_OUT|SW_PARAM_PTR, "state check"),

#define SW_API_TUNNEL_INTF_SET_DESC \
	SW_PARAM_DEF(SW_API_TUNNEL_INTF_SET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_INTF_SET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "L3 If "),\
	SW_PARAM_DEF(SW_API_TUNNEL_INTF_SET, SW_TUNNEL_INTF, \
			sizeof(fal_tunnel_intf_t), SW_PARAM_PTR|SW_PARAM_IN, "Tunnel Intf"),

#define SW_API_TUNNEL_INTF_GET_DESC \
	SW_PARAM_DEF(SW_API_TUNNEL_INTF_GET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_INTF_GET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "L3 If "),\
	SW_PARAM_DEF(SW_API_TUNNEL_INTF_GET, SW_TUNNEL_INTF, \
			sizeof(fal_tunnel_intf_t), SW_PARAM_PTR|SW_PARAM_OUT, "Tunnel Intf"),

#define SW_API_TUNNEL_ENCAP_RULE_ENTRY_SET_DESC \
	SW_PARAM_DEF(SW_API_TUNNEL_ENCAP_RULE_ENTRY_SET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_ENCAP_RULE_ENTRY_SET, SW_UINT32,\
			sizeof(a_uint32_t), SW_PARAM_IN, "Rule Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_ENCAP_RULE_ENTRY_SET, SW_TUNNEL_ENCAP_RULE_ENTRY, \
			sizeof(fal_tunnel_encap_rule_t), SW_PARAM_PTR|SW_PARAM_IN, "Rule Entry"),

#define SW_API_TUNNEL_ENCAP_RULE_ENTRY_GET_DESC \
	SW_PARAM_DEF(SW_API_TUNNEL_ENCAP_RULE_ENTRY_GET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_ENCAP_RULE_ENTRY_GET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Rule Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_ENCAP_RULE_ENTRY_GET, SW_TUNNEL_ENCAP_RULE_ENTRY, \
			sizeof(fal_tunnel_encap_rule_t), SW_PARAM_PTR|SW_PARAM_OUT, "Rule Entry"),

#define SW_API_TUNNEL_ENCAP_RULE_ENTRY_DEL_DESC \
	SW_PARAM_DEF(SW_API_TUNNEL_ENCAP_RULE_ENTRY_DEL, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_ENCAP_RULE_ENTRY_DEL, SW_UINT32,\
			sizeof(a_uint32_t), SW_PARAM_IN, "Rule Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_ENCAP_RULE_ENTRY_DEL, SW_TUNNEL_ENCAP_RULE_ENTRY, \
			sizeof(fal_tunnel_encap_rule_t), SW_PARAM_PTR|SW_PARAM_IN, "Rule Entry"),

#define SW_API_TUNNEL_ENCAP_INTF_TUNNELID_SET_DESC \
	SW_PARAM_DEF(SW_API_TUNNEL_ENCAP_INTF_TUNNELID_SET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_ENCAP_INTF_TUNNELID_SET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Intf Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_ENCAP_INTF_TUNNELID_SET, SW_TUNNEL_TUNNEL_ID, \
			sizeof(fal_tunnel_id_t), SW_PARAM_PTR|SW_PARAM_IN, "Tunnel Id"),

#define SW_API_TUNNEL_ENCAP_INTF_TUNNELID_GET_DESC \
	SW_PARAM_DEF(SW_API_TUNNEL_ENCAP_INTF_TUNNELID_GET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_ENCAP_INTF_TUNNELID_GET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Intf Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_ENCAP_INTF_TUNNELID_GET, SW_TUNNEL_TUNNEL_ID, \
			sizeof(fal_tunnel_id_t), SW_PARAM_PTR|SW_PARAM_OUT, "Tunnel Id"),

#define SW_API_TUNNEL_VLAN_INTF_ADD_DESC \
	SW_PARAM_DEF(SW_API_TUNNEL_VLAN_INTF_ADD, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_VLAN_INTF_ADD, SW_TUNNEL_VLAN_INTF, \
			sizeof(fal_tunnel_vlan_intf_t), SW_PARAM_PTR|SW_PARAM_IN, "Vlan Cfg"),

#define SW_API_TUNNEL_VLAN_INTF_GETFIRST_DESC \
	SW_PARAM_DEF(SW_API_TUNNEL_VLAN_INTF_GETFIRST, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_VLAN_INTF_GETFIRST, SW_TUNNEL_VLAN_INTF, \
			sizeof(fal_tunnel_vlan_intf_t), SW_PARAM_PTR|SW_PARAM_OUT, "Vlan Cfg"),

#define SW_API_TUNNEL_VLAN_INTF_GETNEXT_DESC \
	SW_PARAM_DEF(SW_API_TUNNEL_VLAN_INTF_GETNEXT, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_VLAN_INTF_GETNEXT, SW_TUNNEL_VLAN_INTF, \
			sizeof(fal_tunnel_vlan_intf_t), \
			SW_PARAM_PTR|SW_PARAM_OUT|SW_PARAM_IN, "Vlan Cfg"),

#define SW_API_TUNNEL_VLAN_INTF_DEL_DESC \
	SW_PARAM_DEF(SW_API_TUNNEL_VLAN_INTF_DEL, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_VLAN_INTF_DEL, SW_TUNNEL_VLAN_INTF, \
			sizeof(fal_tunnel_vlan_intf_t), SW_PARAM_PTR|SW_PARAM_IN, "Vlan Cfg"),

#define SW_API_TUNNEL_ENCAP_PORT_TUNNELID_SET_DESC \
	SW_PARAM_DEF(SW_API_TUNNEL_ENCAP_PORT_TUNNELID_SET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_ENCAP_PORT_TUNNELID_SET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Port Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_ENCAP_PORT_TUNNELID_SET, SW_TUNNEL_TUNNEL_ID, \
			sizeof(fal_tunnel_id_t), SW_PARAM_PTR|SW_PARAM_IN, "Tunnel Id"),

#define SW_API_TUNNEL_ENCAP_PORT_TUNNELID_GET_DESC \
	SW_PARAM_DEF(SW_API_TUNNEL_ENCAP_PORT_TUNNELID_GET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_ENCAP_PORT_TUNNELID_GET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Port Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_ENCAP_PORT_TUNNELID_GET, SW_TUNNEL_TUNNEL_ID, \
			sizeof(fal_tunnel_id_t), SW_PARAM_PTR|SW_PARAM_OUT, "Tunnel Id"),

#define SW_API_TUNNEL_DECAP_ENTRY_ADD_DESC \
	SW_PARAM_DEF(SW_API_TUNNEL_DECAP_ENTRY_ADD, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_DECAP_ENTRY_ADD, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Add Mode "),\
	SW_PARAM_DEF(SW_API_TUNNEL_DECAP_ENTRY_ADD, SW_TUNNEL_DECAP_ENTRY, \
			sizeof(fal_tunnel_decap_entry_t), \
			SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Decap Entry"),

#define SW_API_TUNNEL_DECAP_ENTRY_GET_DESC \
	SW_PARAM_DEF(SW_API_TUNNEL_DECAP_ENTRY_GET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_DECAP_ENTRY_GET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Get Mode "),\
	SW_PARAM_DEF(SW_API_TUNNEL_DECAP_ENTRY_GET, SW_TUNNEL_DECAP_ENTRY, \
			sizeof(fal_tunnel_decap_entry_t), \
			SW_PARAM_PTR|SW_PARAM_OUT|SW_PARAM_IN, "Decap Entry"),

#define SW_API_TUNNEL_DECAP_ENTRY_GETNEXT_DESC \
	SW_PARAM_DEF(SW_API_TUNNEL_DECAP_ENTRY_GETNEXT, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_DECAP_ENTRY_GETNEXT, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Get Mode "),\
	SW_PARAM_DEF(SW_API_TUNNEL_DECAP_ENTRY_GETNEXT, SW_TUNNEL_DECAP_ENTRY, \
			sizeof(fal_tunnel_decap_entry_t), \
			SW_PARAM_PTR|SW_PARAM_OUT|SW_PARAM_IN, "Decap Entry"),

#define SW_API_TUNNEL_DECAP_ENTRY_FLUSH_DESC \
	SW_PARAM_DEF(SW_API_TUNNEL_DECAP_ENTRY_FLUSH, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),

#define SW_API_TUNNEL_DECAP_ENTRY_DEL_DESC \
	SW_PARAM_DEF(SW_API_TUNNEL_DECAP_ENTRY_DEL, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_DECAP_ENTRY_DEL, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Del Mode "),\
	SW_PARAM_DEF(SW_API_TUNNEL_DECAP_ENTRY_DEL, SW_TUNNEL_DECAP_ENTRY, \
			sizeof(fal_tunnel_decap_entry_t), \
			SW_PARAM_PTR|SW_PARAM_IN, "Decap Entry"),

#define SW_API_TUNNEL_ENCAP_ENTRY_ADD_DESC \
	SW_PARAM_DEF(SW_API_TUNNEL_ENCAP_ENTRY_ADD, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_ENCAP_ENTRY_ADD, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Tunnel Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_ENCAP_ENTRY_ADD, SW_TUNNEL_ENCAP_ENTRY, \
			sizeof(fal_tunnel_encap_cfg_t), \
			SW_PARAM_PTR|SW_PARAM_IN, "Encap Cfg"),

#define SW_API_TUNNEL_ENCAP_ENTRY_GET_DESC \
	SW_PARAM_DEF(SW_API_TUNNEL_ENCAP_ENTRY_GET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_ENCAP_ENTRY_GET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Tunnel Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_ENCAP_ENTRY_GET, SW_TUNNEL_ENCAP_ENTRY, \
			sizeof(fal_tunnel_encap_cfg_t), \
			SW_PARAM_PTR|SW_PARAM_OUT, "Encap Cfg"),

#define SW_API_TUNNEL_ENCAP_ENTRY_GETNEXT_DESC \
	SW_PARAM_DEF(SW_API_TUNNEL_ENCAP_ENTRY_GETNEXT, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_ENCAP_ENTRY_GETNEXT, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Tunnel Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_ENCAP_ENTRY_GETNEXT, SW_TUNNEL_ENCAP_ENTRY, \
			sizeof(fal_tunnel_encap_cfg_t), \
			SW_PARAM_PTR|SW_PARAM_OUT|SW_PARAM_IN, "Encap Cfg"),

#define SW_API_TUNNEL_ENCAP_ENTRY_DEL_DESC \
	SW_PARAM_DEF(SW_API_TUNNEL_ENCAP_ENTRY_DEL, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_ENCAP_ENTRY_DEL, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Tunnel Id "),

#define SW_API_TUNNEL_GLOBAL_CFG_SET_DESC \
	SW_PARAM_DEF(SW_API_TUNNEL_GLOBAL_CFG_SET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_GLOBAL_CFG_SET, SW_TUNNEL_GLOBAL_CFG, \
			sizeof(fal_tunnel_global_cfg_t), \
			SW_PARAM_PTR|SW_PARAM_IN, "Global Cfg"),

#define SW_API_TUNNEL_GLOBAL_CFG_GET_DESC \
	SW_PARAM_DEF(SW_API_TUNNEL_GLOBAL_CFG_GET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_GLOBAL_CFG_GET, SW_TUNNEL_GLOBAL_CFG, \
			sizeof(fal_tunnel_global_cfg_t), \
			SW_PARAM_PTR|SW_PARAM_OUT, "Global Cfg"),

#define SW_API_TUNNEL_DECAP_ECN_MODE_SET_DESC \
	SW_PARAM_DEF(SW_API_TUNNEL_DECAP_ECN_MODE_SET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_DECAP_ECN_MODE_SET, SW_TUNNEL_DECAP_ECN_RULE, \
			sizeof(fal_tunnel_decap_ecn_rule_t), \
			SW_PARAM_PTR|SW_PARAM_IN, "Decap ECN rule"), \
	SW_PARAM_DEF(SW_API_TUNNEL_DECAP_ECN_MODE_SET, SW_TUNNEL_DECAP_ECN_ACTION, \
			sizeof(fal_tunnel_decap_ecn_action_t), \
			SW_PARAM_PTR|SW_PARAM_IN, "Decap ECN action"),

#define SW_API_TUNNEL_DECAP_ECN_MODE_GET_DESC \
	SW_PARAM_DEF(SW_API_TUNNEL_DECAP_ECN_MODE_GET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_DECAP_ECN_MODE_GET, SW_TUNNEL_DECAP_ECN_RULE, \
			sizeof(fal_tunnel_decap_ecn_rule_t), \
			SW_PARAM_PTR|SW_PARAM_IN, "Decap ECN rule"), \
	SW_PARAM_DEF(SW_API_TUNNEL_DECAP_ECN_MODE_GET, SW_TUNNEL_DECAP_ECN_ACTION, \
			sizeof(fal_tunnel_decap_ecn_action_t), \
			SW_PARAM_PTR|SW_PARAM_OUT, "Decap ECN action"),

#define SW_API_TUNNEL_ENCAP_ECN_MODE_SET_DESC \
	SW_PARAM_DEF(SW_API_TUNNEL_ENCAP_ECN_MODE_SET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_ENCAP_ECN_MODE_SET, SW_TUNNEL_ENCAP_ECN_RULE, \
			sizeof(fal_tunnel_encap_ecn_t), \
			SW_PARAM_PTR|SW_PARAM_IN, "Encap ECN rule"), \
	SW_PARAM_DEF(SW_API_TUNNEL_ENCAP_ECN_MODE_SET, SW_TUNNEL_ECN_VAL, \
			sizeof(fal_tunnel_ecn_val_t), \
			SW_PARAM_PTR|SW_PARAM_IN, "Encap ECN value"),

#define SW_API_TUNNEL_ENCAP_ECN_MODE_GET_DESC \
	SW_PARAM_DEF(SW_API_TUNNEL_ENCAP_ECN_MODE_GET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_ENCAP_ECN_MODE_GET, SW_TUNNEL_ENCAP_ECN_RULE, \
			sizeof(fal_tunnel_encap_ecn_t), \
			SW_PARAM_PTR|SW_PARAM_IN, "Encap ECN rule"), \
	SW_PARAM_DEF(SW_API_TUNNEL_ENCAP_ECN_MODE_GET, SW_TUNNEL_ECN_VAL, \
			sizeof(fal_tunnel_ecn_val_t), \
			SW_PARAM_PTR|SW_PARAM_OUT, "Encap ECN value"),

#define SW_API_TUNNEL_ENCAP_HEADER_CTRL_SET_DESC \
	SW_PARAM_DEF(SW_API_TUNNEL_ENCAP_HEADER_CTRL_SET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_ENCAP_HEADER_CTRL_SET, SW_TUNNEL_ENCAP_HEADER_CTRL, \
			sizeof(fal_tunnel_encap_header_ctrl_t), \
			SW_PARAM_PTR|SW_PARAM_IN, "Global encap header control"),

#define SW_API_TUNNEL_ENCAP_HEADER_CTRL_GET_DESC \
	SW_PARAM_DEF(SW_API_TUNNEL_ENCAP_HEADER_CTRL_GET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_ENCAP_HEADER_CTRL_GET, SW_TUNNEL_ENCAP_HEADER_CTRL, \
			sizeof(fal_tunnel_encap_header_ctrl_t), \
			SW_PARAM_PTR|SW_PARAM_OUT, "Global encap header control"),

#define SW_API_TUNNEL_PORT_INTF_SET_DESC \
	SW_PARAM_DEF(SW_API_TUNNEL_PORT_INTF_SET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "), \
	SW_PARAM_DEF(SW_API_TUNNEL_PORT_INTF_SET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Port Id "), \
	SW_PARAM_DEF(SW_API_TUNNEL_PORT_INTF_SET, SW_TUNNEL_PORT_INTF, \
			sizeof(fal_tunnel_intf_t), \
			SW_PARAM_PTR|SW_PARAM_IN, "Port Intf"),

#define SW_API_TUNNEL_PORT_INTF_GET_DESC \
	SW_PARAM_DEF(SW_API_TUNNEL_PORT_INTF_GET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_PORT_INTF_GET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Port Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_PORT_INTF_GET, SW_TUNNEL_PORT_INTF, \
			sizeof(fal_tunnel_intf_t), \
			SW_PARAM_PTR|SW_PARAM_OUT, "Port Intf"),

#define SW_API_TUNNEL_UDF_PROFILE_ENTRY_ADD_DESC \
    SW_PARAM_DEF(SW_API_TUNNEL_UDF_PROFILE_ENTRY_ADD, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_TUNNEL_UDF_PROFILE_ENTRY_ADD, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Profile ID"), \
    SW_PARAM_DEF(SW_API_TUNNEL_UDF_PROFILE_ENTRY_ADD, SW_TUNNEL_UDF_PROFILE_ENTRY, \
			sizeof(fal_tunnel_udf_profile_entry_t), \
			SW_PARAM_PTR|SW_PARAM_IN, "udf profile entry"),

#define SW_API_TUNNEL_UDF_PROFILE_ENTRY_DEL_DESC \
    SW_PARAM_DEF(SW_API_TUNNEL_UDF_PROFILE_ENTRY_DEL, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_TUNNEL_UDF_PROFILE_ENTRY_DEL, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Profile ID"), \
    SW_PARAM_DEF(SW_API_TUNNEL_UDF_PROFILE_ENTRY_DEL, SW_TUNNEL_UDF_PROFILE_ENTRY, \
			sizeof(fal_tunnel_udf_profile_entry_t), \
			SW_PARAM_PTR|SW_PARAM_IN, "udf profile entry"),

#define SW_API_TUNNEL_UDF_PROFILE_ENTRY_GETFIRST_DESC \
    SW_PARAM_DEF(SW_API_TUNNEL_UDF_PROFILE_ENTRY_GETFIRST, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_TUNNEL_UDF_PROFILE_ENTRY_GETFIRST, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Profile ID"), \
    SW_PARAM_DEF(SW_API_TUNNEL_UDF_PROFILE_ENTRY_GETFIRST, SW_TUNNEL_UDF_PROFILE_ENTRY, \
			sizeof(fal_tunnel_udf_profile_entry_t), \
			SW_PARAM_PTR|SW_PARAM_OUT, "udf profile entry"),

#define SW_API_TUNNEL_UDF_PROFILE_ENTRY_GETNEXT_DESC \
    SW_PARAM_DEF(SW_API_TUNNEL_UDF_PROFILE_ENTRY_GETNEXT, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_TUNNEL_UDF_PROFILE_ENTRY_GETNEXT, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Profile ID"), \
    SW_PARAM_DEF(SW_API_TUNNEL_UDF_PROFILE_ENTRY_GETNEXT, SW_TUNNEL_UDF_PROFILE_ENTRY, \
			sizeof(fal_tunnel_udf_profile_entry_t), \
			SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "udf profile entry"),

#define SW_API_TUNNEL_UDF_PROFILE_CFG_SET_DESC \
    SW_PARAM_DEF(SW_API_TUNNEL_UDF_PROFILE_CFG_SET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_TUNNEL_UDF_PROFILE_CFG_SET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "udf_profile"), \
    SW_PARAM_DEF(SW_API_TUNNEL_UDF_PROFILE_CFG_SET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "udf_index"), \
    SW_PARAM_DEF(SW_API_TUNNEL_UDF_PROFILE_CFG_SET, SW_TUNNEL_UDF_TYPE, \
			sizeof(fal_tunnel_udf_type_t), SW_PARAM_IN, "udf_type"), \
    SW_PARAM_DEF(SW_API_TUNNEL_UDF_PROFILE_CFG_SET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "udf_offset"),

#define SW_API_TUNNEL_UDF_PROFILE_CFG_GET_DESC \
    SW_PARAM_DEF(SW_API_TUNNEL_UDF_PROFILE_CFG_GET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_TUNNEL_UDF_PROFILE_CFG_GET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "udf_profile"), \
    SW_PARAM_DEF(SW_API_TUNNEL_UDF_PROFILE_CFG_GET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "udf_index"), \
    SW_PARAM_DEF(SW_API_TUNNEL_UDF_PROFILE_CFG_GET, SW_TUNNEL_UDF_TYPE, \
			sizeof(fal_tunnel_udf_type_t), SW_PARAM_PTR|SW_PARAM_OUT, "[udf_type]:"),\
    SW_PARAM_DEF(SW_API_TUNNEL_UDF_PROFILE_CFG_GET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_PTR|SW_PARAM_OUT, "udf_offset"),

#define SW_API_TUNNEL_EXP_DECAP_GET_DESC \
	SW_PARAM_DEF(SW_API_TUNNEL_EXP_DECAP_GET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_EXP_DECAP_GET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Port Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_EXP_DECAP_GET, SW_ENABLE, \
			sizeof(a_bool_t), \
			SW_PARAM_PTR|SW_PARAM_OUT, "decap exp fmt control"),

#define SW_API_TUNNEL_EXP_DECAP_SET_DESC \
	SW_PARAM_DEF(SW_API_TUNNEL_EXP_DECAP_SET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_EXP_DECAP_SET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Port Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_EXP_DECAP_SET, SW_ENABLE, \
			sizeof(a_bool_t), \
			SW_PARAM_PTR|SW_PARAM_IN, "decap exp fmt control"),

#define SW_API_TUNNEL_DECAP_KEY_SET_DESC \
	SW_PARAM_DEF(SW_API_TUNNEL_DECAP_KEY_SET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_DECAP_KEY_SET, SW_TUNNEL_TYPE, \
			sizeof(fal_tunnel_type_t), SW_PARAM_IN, "tunnel type"),\
	SW_PARAM_DEF(SW_API_TUNNEL_DECAP_KEY_SET, SW_TUNNEL_KEY, \
			sizeof(fal_tunnel_decap_key_t), \
			SW_PARAM_PTR|SW_PARAM_IN, "decap key"),

#define SW_API_TUNNEL_DECAP_KEY_GET_DESC \
	SW_PARAM_DEF(SW_API_TUNNEL_DECAP_KEY_GET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_DECAP_KEY_GET, SW_TUNNEL_TYPE, \
			sizeof(fal_tunnel_type_t), SW_PARAM_IN, "tunnel type"),\
	SW_PARAM_DEF(SW_API_TUNNEL_DECAP_KEY_GET, SW_TUNNEL_KEY, \
			sizeof(fal_tunnel_decap_key_t), \
			SW_PARAM_PTR|SW_PARAM_OUT, "decap key"),

#define SW_API_TUNNEL_DECAP_EN_SET_DESC \
	SW_PARAM_DEF(SW_API_TUNNEL_DECAP_EN_SET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_DECAP_EN_SET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "tunnel index"),\
	SW_PARAM_DEF(SW_API_TUNNEL_DECAP_EN_SET, SW_ENABLE, \
			sizeof(a_bool_t), \
			SW_PARAM_IN, "decap enable"),

#define SW_API_TUNNEL_DECAP_EN_GET_DESC \
	SW_PARAM_DEF(SW_API_TUNNEL_DECAP_EN_GET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_DECAP_EN_GET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "tunnel index"),\
	SW_PARAM_DEF(SW_API_TUNNEL_DECAP_EN_GET, SW_ENABLE, \
			sizeof(a_bool_t), \
			SW_PARAM_PTR|SW_PARAM_OUT, "decap enable"),

#define SW_API_TUNNEL_DECAP_ACTION_UPDATE_DESC \
	SW_PARAM_DEF(SW_API_TUNNEL_DECAP_ACTION_UPDATE, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_DECAP_ACTION_UPDATE, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "tunnel index"),\
	SW_PARAM_DEF(SW_API_TUNNEL_DECAP_ACTION_UPDATE, SW_TUNNEL_DECAP_ACTION, \
			sizeof(fal_tunnel_action_t), \
			SW_PARAM_PTR|SW_PARAM_IN, "decap action update"),

#define SW_API_TUNNEL_DECAP_COUNTER_GET_DESC \
	SW_PARAM_DEF(SW_API_TUNNEL_DECAP_COUNTER_GET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_TUNNEL_DECAP_COUNTER_GET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "tunnel index"),\
	SW_PARAM_DEF(SW_API_TUNNEL_DECAP_COUNTER_GET, SW_ENTRY_COUNTER, \
			sizeof(fal_entry_counter_t), \
			SW_PARAM_PTR|SW_PARAM_OUT, "decap counter"),

#define SW_API_VXLAN_ENTRY_ADD_DESC \
    SW_PARAM_DEF(SW_API_VXLAN_ENTRY_ADD, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_VXLAN_ENTRY_ADD, SW_VXLAN_TYPE, \
		    sizeof(fal_vxlan_type_t), SW_PARAM_IN, "VxLAN Type"), \
    SW_PARAM_DEF(SW_API_VXLAN_ENTRY_ADD, SW_TUNNEL_UDP_ENTRY, \
		    sizeof(fal_tunnel_udp_entry_t), SW_PARAM_PTR|SW_PARAM_IN, "VxLAN Entry"),

#define SW_API_VXLAN_ENTRY_DEL_DESC \
    SW_PARAM_DEF(SW_API_VXLAN_ENTRY_DEL, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_VXLAN_ENTRY_DEL, SW_VXLAN_TYPE, \
		    sizeof(fal_vxlan_type_t), SW_PARAM_IN, "VxLAN Type"), \
    SW_PARAM_DEF(SW_API_VXLAN_ENTRY_DEL, SW_TUNNEL_UDP_ENTRY, \
		    sizeof(fal_tunnel_udp_entry_t), SW_PARAM_PTR|SW_PARAM_IN, "VxLAN Entry"),

#define SW_API_VXLAN_ENTRY_GETFIRST_DESC \
    SW_PARAM_DEF(SW_API_VXLAN_ENTRY_GETFIRST, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_VXLAN_ENTRY_GETFIRST, SW_VXLAN_TYPE, \
		    sizeof(fal_vxlan_type_t), SW_PARAM_IN, "VxLAN Type"), \
    SW_PARAM_DEF(SW_API_VXLAN_ENTRY_GETFIRST, SW_TUNNEL_UDP_ENTRY, \
		    sizeof(fal_tunnel_udp_entry_t), SW_PARAM_PTR|SW_PARAM_OUT, "VxLAN Entry"),

#define SW_API_VXLAN_ENTRY_GETNEXT_DESC \
    SW_PARAM_DEF(SW_API_VXLAN_ENTRY_GETNEXT, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_VXLAN_ENTRY_GETNEXT, SW_VXLAN_TYPE, \
		    sizeof(fal_vxlan_type_t), SW_PARAM_IN, "VxLAN Type"), \
    SW_PARAM_DEF(SW_API_VXLAN_ENTRY_GETNEXT, SW_TUNNEL_UDP_ENTRY, \
		    sizeof(fal_tunnel_udp_entry_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "VxLAN Entry"),

#define SW_API_VXLAN_GPE_PROTO_CFG_SET_DESC \
    SW_PARAM_DEF(SW_API_VXLAN_GPE_PROTO_CFG_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_VXLAN_GPE_PROTO_CFG_SET, SW_VXLAN_GPE_PROTO, \
		    sizeof(fal_vxlan_gpe_proto_cfg_t), SW_PARAM_PTR|SW_PARAM_IN, "VxLAN GPE Proto"),

#define SW_API_VXLAN_GPE_PROTO_CFG_GET_DESC \
    SW_PARAM_DEF(SW_API_VXLAN_GPE_PROTO_CFG_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_VXLAN_GPE_PROTO_CFG_GET, SW_VXLAN_GPE_PROTO, \
		    sizeof(fal_vxlan_gpe_proto_cfg_t), SW_PARAM_PTR|SW_PARAM_OUT, "VxLAN GPE Proto"),

#define SW_API_GENEVE_ENTRY_ADD_DESC \
    SW_PARAM_DEF(SW_API_GENEVE_ENTRY_ADD, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_GENEVE_ENTRY_ADD, SW_TUNNEL_UDP_ENTRY, \
                    sizeof(fal_tunnel_udp_entry_t), SW_PARAM_PTR|SW_PARAM_IN, "Geneve Entry"),

#define SW_API_GENEVE_ENTRY_DEL_DESC \
    SW_PARAM_DEF(SW_API_GENEVE_ENTRY_DEL, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_GENEVE_ENTRY_DEL, SW_TUNNEL_UDP_ENTRY, \
                    sizeof(fal_tunnel_udp_entry_t), SW_PARAM_PTR|SW_PARAM_IN, "Geneve Entry"),

#define SW_API_GENEVE_ENTRY_GETFIRST_DESC \
    SW_PARAM_DEF(SW_API_GENEVE_ENTRY_GETFIRST, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_GENEVE_ENTRY_GETFIRST, SW_TUNNEL_UDP_ENTRY, \
                    sizeof(fal_tunnel_udp_entry_t), SW_PARAM_PTR|SW_PARAM_OUT, "Geneve Entry"),

#define SW_API_GENEVE_ENTRY_GETNEXT_DESC \
    SW_PARAM_DEF(SW_API_GENEVE_ENTRY_GETNEXT, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_GENEVE_ENTRY_GETNEXT, SW_TUNNEL_UDP_ENTRY, \
                    sizeof(fal_tunnel_udp_entry_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Geneve Entry"),

#define SW_API_MAPT_DECAP_CTRL_SET_DESC \
	SW_PARAM_DEF(SW_API_MAPT_DECAP_CTRL_SET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_MAPT_DECAP_CTRL_SET, SW_MAPT_DECAP_CTRL, \
			sizeof(fal_mapt_decap_ctrl_t), SW_PARAM_PTR|SW_PARAM_IN, "Decap Ctrl"),

#define SW_API_MAPT_DECAP_CTRL_GET_DESC \
	SW_PARAM_DEF(SW_API_MAPT_DECAP_CTRL_GET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_MAPT_DECAP_CTRL_GET, SW_MAPT_DECAP_CTRL, \
			sizeof(fal_mapt_decap_ctrl_t), SW_PARAM_PTR|SW_PARAM_OUT, "Decap Ctrl"),

#define SW_API_MAPT_DECAP_RULE_ENTRY_SET_DESC \
	SW_PARAM_DEF(SW_API_MAPT_DECAP_RULE_ENTRY_SET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_MAPT_DECAP_RULE_ENTRY_SET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Rule Id "),\
	SW_PARAM_DEF(SW_API_MAPT_DECAP_RULE_ENTRY_SET, SW_MAPT_DECAP_RULE_ENTRY, \
			sizeof(fal_mapt_decap_edit_rule_entry_t), \
			SW_PARAM_PTR|SW_PARAM_IN, "Mapt Rule Entry"),

#define SW_API_MAPT_DECAP_RULE_ENTRY_GET_DESC \
	SW_PARAM_DEF(SW_API_MAPT_DECAP_RULE_ENTRY_GET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_MAPT_DECAP_RULE_ENTRY_GET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Rule Id "),\
	SW_PARAM_DEF(SW_API_MAPT_DECAP_RULE_ENTRY_GET, SW_MAPT_DECAP_RULE_ENTRY, \
			sizeof(fal_mapt_decap_edit_rule_entry_t), \
			SW_PARAM_PTR|SW_PARAM_OUT, "Mapt Rule Entry"),

#define SW_API_MAPT_DECAP_RULE_ENTRY_DEL_DESC \
	SW_PARAM_DEF(SW_API_MAPT_DECAP_RULE_ENTRY_DEL, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_MAPT_DECAP_RULE_ENTRY_DEL, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Rule Id "),

#define SW_API_MAPT_DECAP_ENTRY_ADD_DESC \
	SW_PARAM_DEF(SW_API_MAPT_DECAP_ENTRY_ADD, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_MAPT_DECAP_ENTRY_ADD, SW_MAPT_DECAP_ENTRY, \
			sizeof(fal_mapt_decap_entry_t), SW_PARAM_PTR|SW_PARAM_IN, "Mapt Entry"),

#define SW_API_MAPT_DECAP_ENTRY_DEL_DESC \
	SW_PARAM_DEF(SW_API_MAPT_DECAP_ENTRY_DEL, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_MAPT_DECAP_ENTRY_DEL, SW_MAPT_DECAP_ENTRY, \
			sizeof(fal_mapt_decap_entry_t), SW_PARAM_PTR|SW_PARAM_IN, "Mapt Entry"),

#define SW_API_MAPT_DECAP_ENTRY_GETFIRST_DESC \
	SW_PARAM_DEF(SW_API_MAPT_DECAP_ENTRY_GETFIRST, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_MAPT_DECAP_ENTRY_GETFIRST, SW_MAPT_DECAP_ENTRY, \
			sizeof(fal_mapt_decap_entry_t), SW_PARAM_PTR|SW_PARAM_OUT, "Mapt Entry"),

#define SW_API_MAPT_DECAP_ENTRY_GETNEXT_DESC \
	SW_PARAM_DEF(SW_API_MAPT_DECAP_ENTRY_GETNEXT, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_MAPT_DECAP_ENTRY_GETNEXT, SW_MAPT_DECAP_ENTRY, \
			sizeof(fal_mapt_decap_entry_t), \
			SW_PARAM_PTR|SW_PARAM_OUT|SW_PARAM_IN, "Mapt Entry"),

#define SW_API_MAPT_DECAP_EN_SET_DESC \
	SW_PARAM_DEF(SW_API_MAPT_DECAP_EN_SET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_MAPT_DECAP_EN_SET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Mapt Entry Index "),\
	SW_PARAM_DEF(SW_API_MAPT_DECAP_EN_SET, SW_ENABLE, \
			sizeof(a_bool_t), SW_PARAM_IN, "Decap enable"),

#define SW_API_MAPT_DECAP_EN_GET_DESC \
	SW_PARAM_DEF(SW_API_MAPT_DECAP_EN_GET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF(SW_API_MAPT_DECAP_EN_GET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Mapt Entry Index "),\
	SW_PARAM_DEF(SW_API_MAPT_DECAP_EN_GET, SW_ENABLE, \
			sizeof(a_bool_t), SW_PARAM_PTR|SW_PARAM_OUT, "Decap enable"),

#define SW_API_TUNNEL_PROGRAM_ENTRY_ADD_DESC \
    SW_PARAM_DEF(SW_API_TUNNEL_PROGRAM_ENTRY_ADD, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_TUNNEL_PROGRAM_ENTRY_ADD, SW_TUNNEL_PROGRAM_TYPE, \
                    sizeof(fal_tunnel_program_type_t), SW_PARAM_IN, "Program Type"), \
    SW_PARAM_DEF(SW_API_TUNNEL_PROGRAM_ENTRY_ADD, SW_TUNNEL_PROGRAM_ENTRY, \
                    sizeof(fal_tunnel_program_entry_t), SW_PARAM_PTR|SW_PARAM_IN, "Program Entry"),

#define SW_API_TUNNEL_PROGRAM_ENTRY_DEL_DESC \
    SW_PARAM_DEF(SW_API_TUNNEL_PROGRAM_ENTRY_DEL, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_TUNNEL_PROGRAM_ENTRY_DEL, SW_TUNNEL_PROGRAM_TYPE, \
                    sizeof(fal_tunnel_program_type_t), SW_PARAM_IN, "Program Type"), \
    SW_PARAM_DEF(SW_API_TUNNEL_PROGRAM_ENTRY_DEL, SW_TUNNEL_PROGRAM_ENTRY, \
                    sizeof(fal_tunnel_program_entry_t), SW_PARAM_PTR|SW_PARAM_IN, "Program Entry"),

#define SW_API_TUNNEL_PROGRAM_ENTRY_GETFIRST_DESC \
    SW_PARAM_DEF(SW_API_TUNNEL_PROGRAM_ENTRY_GETFIRST, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_TUNNEL_PROGRAM_ENTRY_GETFIRST, SW_TUNNEL_PROGRAM_TYPE, \
                    sizeof(fal_tunnel_program_type_t), SW_PARAM_IN, "Program Type"), \
    SW_PARAM_DEF(SW_API_TUNNEL_PROGRAM_ENTRY_GETFIRST, SW_TUNNEL_PROGRAM_ENTRY, \
                    sizeof(fal_tunnel_program_entry_t), SW_PARAM_PTR|SW_PARAM_OUT, "Program Entry"),

#define SW_API_TUNNEL_PROGRAM_ENTRY_GETNEXT_DESC \
    SW_PARAM_DEF(SW_API_TUNNEL_PROGRAM_ENTRY_GETNEXT, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_TUNNEL_PROGRAM_ENTRY_GETNEXT, SW_TUNNEL_PROGRAM_TYPE, \
                    sizeof(fal_tunnel_program_type_t), SW_PARAM_IN, "Program Type"), \
    SW_PARAM_DEF(SW_API_TUNNEL_PROGRAM_ENTRY_GETNEXT, SW_TUNNEL_PROGRAM_ENTRY, \
                    sizeof(fal_tunnel_program_entry_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Program Entry"),

#define SW_API_TUNNEL_PROGRAM_CFG_SET_DESC \
    SW_PARAM_DEF(SW_API_TUNNEL_PROGRAM_CFG_SET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_TUNNEL_PROGRAM_CFG_SET, SW_TUNNEL_PROGRAM_TYPE, \
                    sizeof(fal_tunnel_program_type_t), SW_PARAM_IN, "Program Type"), \
    SW_PARAM_DEF(SW_API_TUNNEL_PROGRAM_CFG_SET, SW_TUNNEL_PROGRAM_CFG, \
                    sizeof(fal_tunnel_program_cfg_t), SW_PARAM_PTR|SW_PARAM_IN, "Program Cfg"),

#define SW_API_TUNNEL_PROGRAM_CFG_GET_DESC \
    SW_PARAM_DEF(SW_API_TUNNEL_PROGRAM_CFG_GET, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_TUNNEL_PROGRAM_CFG_GET, SW_TUNNEL_PROGRAM_TYPE, \
                    sizeof(fal_tunnel_program_type_t), SW_PARAM_IN, "Program Type"), \
    SW_PARAM_DEF(SW_API_TUNNEL_PROGRAM_CFG_GET, SW_TUNNEL_PROGRAM_CFG, \
                    sizeof(fal_tunnel_program_cfg_t), SW_PARAM_PTR|SW_PARAM_OUT, "Program Cfg"),

#define SW_API_TUNNEL_PROGRAM_UDF_ADD_DESC \
    SW_PARAM_DEF(SW_API_TUNNEL_PROGRAM_UDF_ADD, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_TUNNEL_PROGRAM_UDF_ADD, SW_TUNNEL_PROGRAM_TYPE, \
                    sizeof(fal_tunnel_program_type_t), SW_PARAM_IN, "Program Type"), \
    SW_PARAM_DEF(SW_API_TUNNEL_PROGRAM_UDF_ADD, SW_TUNNEL_PROGRAM_UDF, \
                    sizeof(fal_tunnel_program_udf_t), SW_PARAM_PTR|SW_PARAM_IN, "Program Udf"),

#define SW_API_TUNNEL_PROGRAM_UDF_DEL_DESC \
    SW_PARAM_DEF(SW_API_TUNNEL_PROGRAM_UDF_DEL, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_TUNNEL_PROGRAM_UDF_DEL, SW_TUNNEL_PROGRAM_TYPE, \
                    sizeof(fal_tunnel_program_type_t), SW_PARAM_IN, "Program Type"), \
    SW_PARAM_DEF(SW_API_TUNNEL_PROGRAM_UDF_DEL, SW_TUNNEL_PROGRAM_UDF, \
                    sizeof(fal_tunnel_program_udf_t), SW_PARAM_PTR|SW_PARAM_IN, "Program Udf"),

#define SW_API_TUNNEL_PROGRAM_UDF_GETFIRST_DESC \
    SW_PARAM_DEF(SW_API_TUNNEL_PROGRAM_UDF_GETFIRST, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_TUNNEL_PROGRAM_UDF_GETFIRST, SW_TUNNEL_PROGRAM_TYPE, \
                    sizeof(fal_tunnel_program_type_t), SW_PARAM_IN, "Program Type"), \
    SW_PARAM_DEF(SW_API_TUNNEL_PROGRAM_UDF_GETFIRST, SW_TUNNEL_PROGRAM_UDF, \
                    sizeof(fal_tunnel_program_udf_t), SW_PARAM_PTR|SW_PARAM_OUT, "Program Udf"),

#define SW_API_TUNNEL_PROGRAM_UDF_GETNEXT_DESC \
    SW_PARAM_DEF(SW_API_TUNNEL_PROGRAM_UDF_GETNEXT, SW_UINT32, 4, SW_PARAM_IN, "Dev ID"), \
    SW_PARAM_DEF(SW_API_TUNNEL_PROGRAM_UDF_GETNEXT, SW_TUNNEL_PROGRAM_TYPE, \
                    sizeof(fal_tunnel_program_type_t), SW_PARAM_IN, "Program Type"), \
    SW_PARAM_DEF(SW_API_TUNNEL_PROGRAM_UDF_GETNEXT, SW_TUNNEL_PROGRAM_UDF, \
                    sizeof(fal_tunnel_program_udf_t), SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Program Udf"),

#define SW_API_ATHTAG_PRI_MAPPING_SET_DESC \
	SW_PARAM_DEF(SW_API_ATHTAG_PRI_MAPPING_SET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF( SW_API_ATHTAG_PRI_MAPPING_SET, SW_DIRECTION, \
			sizeof(fal_direction_t), SW_PARAM_IN, "direction"), \
	SW_PARAM_DEF(SW_API_ATHTAG_PRI_MAPPING_SET, SW_ATHTAG_PRI_MAPPING, \
			sizeof(fal_athtag_pri_mapping_t), SW_PARAM_PTR|SW_PARAM_IN, "Pri Mapping"),

#define SW_API_ATHTAG_PRI_MAPPING_GET_DESC \
	SW_PARAM_DEF(SW_API_ATHTAG_PRI_MAPPING_GET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF( SW_API_ATHTAG_PRI_MAPPING_GET, SW_DIRECTION, \
			sizeof(fal_direction_t), SW_PARAM_IN, "direction"), \
	SW_PARAM_DEF(SW_API_ATHTAG_PRI_MAPPING_GET, SW_ATHTAG_PRI_MAPPING, \
			sizeof(fal_athtag_pri_mapping_t), \
			SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Pri Mapping"),

#define SW_API_ATHTAG_PORT_MAPPING_SET_DESC \
	SW_PARAM_DEF(SW_API_ATHTAG_PORT_MAPPING_SET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF( SW_API_ATHTAG_PORT_MAPPING_SET, SW_DIRECTION, \
			sizeof(fal_direction_t), SW_PARAM_IN, "direction"), \
	SW_PARAM_DEF(SW_API_ATHTAG_PORT_MAPPING_SET, SW_ATHTAG_PORT_MAPPING, \
			sizeof(fal_athtag_port_mapping_t), \
			SW_PARAM_PTR|SW_PARAM_IN, "Port Mapping"),

#define SW_API_ATHTAG_PORT_MAPPING_GET_DESC \
	SW_PARAM_DEF(SW_API_ATHTAG_PORT_MAPPING_GET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF( SW_API_ATHTAG_PORT_MAPPING_GET, SW_DIRECTION, \
			sizeof(fal_direction_t), SW_PARAM_IN, "direction"), \
	SW_PARAM_DEF(SW_API_ATHTAG_PORT_MAPPING_GET, SW_ATHTAG_PORT_MAPPING, \
			sizeof(fal_athtag_port_mapping_t), \
			SW_PARAM_PTR|SW_PARAM_IN|SW_PARAM_OUT, "Port Mapping"),

#define SW_API_PORT_ATHTAG_RX_SET_DESC \
	SW_PARAM_DEF(SW_API_PORT_ATHTAG_RX_SET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF( SW_API_PORT_ATHTAG_RX_SET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Port Id"), \
	SW_PARAM_DEF(SW_API_PORT_ATHTAG_RX_SET, SW_ATHTAG_RX_CFG, \
			sizeof(fal_athtag_rx_cfg_t), SW_PARAM_PTR|SW_PARAM_IN, "Rx Cfg"),

#define SW_API_PORT_ATHTAG_RX_GET_DESC \
	SW_PARAM_DEF(SW_API_PORT_ATHTAG_RX_GET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF( SW_API_PORT_ATHTAG_RX_GET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Port Id"), \
	SW_PARAM_DEF(SW_API_PORT_ATHTAG_RX_GET, SW_ATHTAG_RX_CFG, \
			sizeof(fal_athtag_rx_cfg_t), SW_PARAM_PTR|SW_PARAM_OUT, "Rx Cfg"),

#define SW_API_PORT_ATHTAG_TX_SET_DESC \
	SW_PARAM_DEF(SW_API_PORT_ATHTAG_TX_SET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF( SW_API_PORT_ATHTAG_TX_SET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Port Id"), \
	SW_PARAM_DEF(SW_API_PORT_ATHTAG_TX_SET, SW_ATHTAG_TX_CFG, \
			sizeof(fal_athtag_tx_cfg_t), SW_PARAM_PTR|SW_PARAM_IN, "Tx Cfg"),

#define SW_API_PORT_ATHTAG_TX_GET_DESC \
	SW_PARAM_DEF(SW_API_PORT_ATHTAG_TX_GET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Dev Id "),\
	SW_PARAM_DEF( SW_API_PORT_ATHTAG_TX_GET, SW_UINT32, \
			sizeof(a_uint32_t), SW_PARAM_IN, "Port Id"), \
	SW_PARAM_DEF(SW_API_PORT_ATHTAG_TX_GET, SW_ATHTAG_TX_CFG, \
			sizeof(fal_athtag_tx_cfg_t), SW_PARAM_PTR|SW_PARAM_OUT, "Tx Cfg"),

/* auto_insert_flag */

/*qca808x_start*/
#define SW_API_DESC(api_id) api_id##_DESC

#ifdef __cplusplus
}
#endif                          /* __cplusplus */

#endif                          /* _API_DESC_H_ */
/*qca808x_end*/
