/*
 * Copyright (c) 2022 Qualcomm Innovation Center, Inc. All rights reserved.
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include "sw_ioctl.h"
#include "fal_athtag.h"
#include "fal_uk_if.h"

sw_error_t
fal_athtag_pri_mapping_set(a_uint32_t dev_id,
		fal_direction_t direction, fal_athtag_pri_mapping_t *pri_mapping)
{
    sw_error_t rv;

    rv = sw_uk_exec(SW_API_ATHTAG_PRI_MAPPING_SET, dev_id, direction, pri_mapping);
    return rv;
}

sw_error_t
fal_athtag_pri_mapping_get(a_uint32_t dev_id,
		fal_direction_t direction, fal_athtag_pri_mapping_t *pri_mapping)
{
    sw_error_t rv;

    rv = sw_uk_exec(SW_API_ATHTAG_PRI_MAPPING_GET, dev_id, direction, pri_mapping);
    return rv;
}

sw_error_t
fal_athtag_port_mapping_set(a_uint32_t dev_id,
		fal_direction_t direction, fal_athtag_port_mapping_t *port_mapping)
{
    sw_error_t rv;

    rv = sw_uk_exec(SW_API_ATHTAG_PORT_MAPPING_SET, dev_id, direction, port_mapping);
    return rv;
}

sw_error_t
fal_athtag_port_mapping_get(a_uint32_t dev_id,
		fal_direction_t direction, fal_athtag_port_mapping_t *port_mapping)
{
    sw_error_t rv;

    rv = sw_uk_exec(SW_API_ATHTAG_PORT_MAPPING_GET, dev_id, direction, port_mapping);
    return rv;
}

sw_error_t
fal_port_athtag_rx_set(a_uint32_t dev_id, fal_port_t port_id, fal_athtag_rx_cfg_t *cfg)
{
    sw_error_t rv;

    rv = sw_uk_exec(SW_API_PORT_ATHTAG_RX_SET, dev_id, port_id, cfg);
    return rv;
}

sw_error_t
fal_port_athtag_rx_get(a_uint32_t dev_id, fal_port_t port_id, fal_athtag_rx_cfg_t *cfg)
{
    sw_error_t rv;

    rv = sw_uk_exec(SW_API_PORT_ATHTAG_RX_GET, dev_id, port_id, cfg);
    return rv;
}

sw_error_t
fal_port_athtag_tx_set(a_uint32_t dev_id, fal_port_t port_id, fal_athtag_tx_cfg_t *cfg)
{
    sw_error_t rv;

    rv = sw_uk_exec(SW_API_PORT_ATHTAG_TX_SET, dev_id, port_id, cfg);
    return rv;
}

sw_error_t
fal_port_athtag_tx_get(a_uint32_t dev_id, fal_port_t port_id, fal_athtag_tx_cfg_t *cfg)
{
    sw_error_t rv;

    rv = sw_uk_exec(SW_API_PORT_ATHTAG_TX_GET, dev_id, port_id, cfg);
    return rv;
}
