//============================================================
// Description:
//
// This file is for 8192e1ant Co-exist mechanism
//
// History
// 2012/11/15 Cosa first check in.
//
//============================================================

//============================================================
// include files
//============================================================
#include "Mp_Precomp.h"
#if(BT_30_SUPPORT == 1)
//============================================================
// Global variables, these are static variables
//============================================================
static COEX_DM_8192E_1ANT		GLCoexDm8192e1Ant;
static PCOEX_DM_8192E_1ANT 	pCoexDm=&GLCoexDm8192e1Ant;
static COEX_STA_8192E_1ANT		GLCoexSta8192e1Ant;
static PCOEX_STA_8192E_1ANT	pCoexSta=&GLCoexSta8192e1Ant;

const char *const GLBtInfoSrc8192e1Ant[]= {
	"BT Info[wifi fw]",
	"BT Info[bt rsp]",
	"BT Info[bt auto report]",
};

u4Byte	GLCoexVerDate8192e1Ant=20130729;
u4Byte	GLCoexVer8192e1Ant=0x10;

//============================================================
// local function proto type if needed
//============================================================
//============================================================
// local function start with halbtc8192e1ant_
//============================================================
u1Byte
halbtc8192e1ant_BtRssiState(
    u1Byte			levelNum,
    u1Byte			rssiThresh,
    u1Byte			rssiThresh1
)
{
	s4Byte			btRssi=0;
	u1Byte			btRssiState=pCoexSta->preBtRssiState;

	btRssi = pCoexSta->btRssi;

	if(levelNum == 2) {
		if( (pCoexSta->preBtRssiState == BTC_RSSI_STATE_LOW) ||
		    (pCoexSta->preBtRssiState == BTC_RSSI_STATE_STAY_LOW)) {
			if(btRssi >= (rssiThresh+BTC_RSSI_COEX_THRESH_TOL_8192E_1ANT)) {
				btRssiState = BTC_RSSI_STATE_HIGH;
				BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_BT_RSSI_STATE, ("[BTCoex], BT Rssi state switch to High\n"));
			} else {
				btRssiState = BTC_RSSI_STATE_STAY_LOW;
				BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_BT_RSSI_STATE, ("[BTCoex], BT Rssi state stay at Low\n"));
			}
		} else {
			if(btRssi < rssiThresh) {
				btRssiState = BTC_RSSI_STATE_LOW;
				BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_BT_RSSI_STATE, ("[BTCoex], BT Rssi state switch to Low\n"));
			} else {
				btRssiState = BTC_RSSI_STATE_STAY_HIGH;
				BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_BT_RSSI_STATE, ("[BTCoex], BT Rssi state stay at High\n"));
			}
		}
	} else if(levelNum == 3) {
		if(rssiThresh > rssiThresh1) {
			BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_BT_RSSI_STATE, ("[BTCoex], BT Rssi thresh error!!\n"));
			return pCoexSta->preBtRssiState;
		}

		if( (pCoexSta->preBtRssiState == BTC_RSSI_STATE_LOW) ||
		    (pCoexSta->preBtRssiState == BTC_RSSI_STATE_STAY_LOW)) {
			if(btRssi >= (rssiThresh+BTC_RSSI_COEX_THRESH_TOL_8192E_1ANT)) {
				btRssiState = BTC_RSSI_STATE_MEDIUM;
				BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_BT_RSSI_STATE, ("[BTCoex], BT Rssi state switch to Medium\n"));
			} else {
				btRssiState = BTC_RSSI_STATE_STAY_LOW;
				BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_BT_RSSI_STATE, ("[BTCoex], BT Rssi state stay at Low\n"));
			}
		} else if( (pCoexSta->preBtRssiState == BTC_RSSI_STATE_MEDIUM) ||
		           (pCoexSta->preBtRssiState == BTC_RSSI_STATE_STAY_MEDIUM)) {
			if(btRssi >= (rssiThresh1+BTC_RSSI_COEX_THRESH_TOL_8192E_1ANT)) {
				btRssiState = BTC_RSSI_STATE_HIGH;
				BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_BT_RSSI_STATE, ("[BTCoex], BT Rssi state switch to High\n"));
			} else if(btRssi < rssiThresh) {
				btRssiState = BTC_RSSI_STATE_LOW;
				BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_BT_RSSI_STATE, ("[BTCoex], BT Rssi state switch to Low\n"));
			} else {
				btRssiState = BTC_RSSI_STATE_STAY_MEDIUM;
				BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_BT_RSSI_STATE, ("[BTCoex], BT Rssi state stay at Medium\n"));
			}
		} else {
			if(btRssi < rssiThresh1) {
				btRssiState = BTC_RSSI_STATE_MEDIUM;
				BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_BT_RSSI_STATE, ("[BTCoex], BT Rssi state switch to Medium\n"));
			} else {
				btRssiState = BTC_RSSI_STATE_STAY_HIGH;
				BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_BT_RSSI_STATE, ("[BTCoex], BT Rssi state stay at High\n"));
			}
		}
	}

	pCoexSta->preBtRssiState = btRssiState;

	return btRssiState;
}

u1Byte
halbtc8192e1ant_WifiRssiState(
    IN	PBTC_COEXIST		pBtCoexist,
    IN	u1Byte			index,
    IN	u1Byte			levelNum,
    IN	u1Byte			rssiThresh,
    IN	u1Byte			rssiThresh1
)
{
	s4Byte			wifiRssi=0;
	u1Byte			wifiRssiState=pCoexSta->preWifiRssiState[index];

	pBtCoexist->fBtcGet(pBtCoexist, BTC_GET_S4_WIFI_RSSI, &wifiRssi);

	if(levelNum == 2) {
		if( (pCoexSta->preWifiRssiState[index] == BTC_RSSI_STATE_LOW) ||
		    (pCoexSta->preWifiRssiState[index] == BTC_RSSI_STATE_STAY_LOW)) {
			if(wifiRssi >= (rssiThresh+BTC_RSSI_COEX_THRESH_TOL_8192E_1ANT)) {
				wifiRssiState = BTC_RSSI_STATE_HIGH;
				BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_WIFI_RSSI_STATE, ("[BTCoex], wifi RSSI state switch to High\n"));
			} else {
				wifiRssiState = BTC_RSSI_STATE_STAY_LOW;
				BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_WIFI_RSSI_STATE, ("[BTCoex], wifi RSSI state stay at Low\n"));
			}
		} else {
			if(wifiRssi < rssiThresh) {
				wifiRssiState = BTC_RSSI_STATE_LOW;
				BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_WIFI_RSSI_STATE, ("[BTCoex], wifi RSSI state switch to Low\n"));
			} else {
				wifiRssiState = BTC_RSSI_STATE_STAY_HIGH;
				BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_WIFI_RSSI_STATE, ("[BTCoex], wifi RSSI state stay at High\n"));
			}
		}
	} else if(levelNum == 3) {
		if(rssiThresh > rssiThresh1) {
			BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_WIFI_RSSI_STATE, ("[BTCoex], wifi RSSI thresh error!!\n"));
			return pCoexSta->preWifiRssiState[index];
		}

		if( (pCoexSta->preWifiRssiState[index] == BTC_RSSI_STATE_LOW) ||
		    (pCoexSta->preWifiRssiState[index] == BTC_RSSI_STATE_STAY_LOW)) {
			if(wifiRssi >= (rssiThresh+BTC_RSSI_COEX_THRESH_TOL_8192E_1ANT)) {
				wifiRssiState = BTC_RSSI_STATE_MEDIUM;
				BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_WIFI_RSSI_STATE, ("[BTCoex], wifi RSSI state switch to Medium\n"));
			} else {
				wifiRssiState = BTC_RSSI_STATE_STAY_LOW;
				BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_WIFI_RSSI_STATE, ("[BTCoex], wifi RSSI state stay at Low\n"));
			}
		} else if( (pCoexSta->preWifiRssiState[index] == BTC_RSSI_STATE_MEDIUM) ||
		           (pCoexSta->preWifiRssiState[index] == BTC_RSSI_STATE_STAY_MEDIUM)) {
			if(wifiRssi >= (rssiThresh1+BTC_RSSI_COEX_THRESH_TOL_8192E_1ANT)) {
				wifiRssiState = BTC_RSSI_STATE_HIGH;
				BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_WIFI_RSSI_STATE, ("[BTCoex], wifi RSSI state switch to High\n"));
			} else if(wifiRssi < rssiThresh) {
				wifiRssiState = BTC_RSSI_STATE_LOW;
				BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_WIFI_RSSI_STATE, ("[BTCoex], wifi RSSI state switch to Low\n"));
			} else {
				wifiRssiState = BTC_RSSI_STATE_STAY_MEDIUM;
				BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_WIFI_RSSI_STATE, ("[BTCoex], wifi RSSI state stay at Medium\n"));
			}
		} else {
			if(wifiRssi < rssiThresh1) {
				wifiRssiState = BTC_RSSI_STATE_MEDIUM;
				BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_WIFI_RSSI_STATE, ("[BTCoex], wifi RSSI state switch to Medium\n"));
			} else {
				wifiRssiState = BTC_RSSI_STATE_STAY_HIGH;
				BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_WIFI_RSSI_STATE, ("[BTCoex], wifi RSSI state stay at High\n"));
			}
		}
	}

	pCoexSta->preWifiRssiState[index] = wifiRssiState;

	return wifiRssiState;
}

VOID
halbtc8192e1ant_UpdateRaMask(
    IN	PBTC_COEXIST		pBtCoexist,
    IN	BOOLEAN				bForceExec,
    IN	u1Byte				type,
    IN	u4Byte				rateMask
)
{
	if(BTC_RATE_DISABLE == type) {
		pCoexDm->curRaMask |= rateMask;		// disable rate
	} else if(BTC_RATE_ENABLE == type) {
		pCoexDm->curRaMask &= ~rateMask;	// enable rate
	}

	if( bForceExec || (pCoexDm->preRaMask != pCoexDm->curRaMask)) {
		pBtCoexist->fBtcSet(pBtCoexist, BTC_SET_ACT_UPDATE_RAMASK, &pCoexDm->curRaMask);
	}
	pCoexDm->preRaMask = pCoexDm->curRaMask;
}

VOID
halbtc8192e1ant_MonitorBtCtr(
    IN	PBTC_COEXIST		pBtCoexist
)
{
	u4Byte 			regHPTxRx, regLPTxRx, u4Tmp;
	u4Byte			regHPTx=0, regHPRx=0, regLPTx=0, regLPRx=0;
	//u1Byte			u1Tmp;

	regHPTxRx = 0x770;
	regLPTxRx = 0x774;

	u4Tmp = pBtCoexist->fBtcRead4Byte(pBtCoexist, regHPTxRx);
	regHPTx = u4Tmp & bMaskLWord;
	regHPRx = (u4Tmp & bMaskHWord)>>16;

	u4Tmp = pBtCoexist->fBtcRead4Byte(pBtCoexist, regLPTxRx);
	regLPTx = u4Tmp & bMaskLWord;
	regLPRx = (u4Tmp & bMaskHWord)>>16;

	pCoexSta->highPriorityTx = regHPTx;
	pCoexSta->highPriorityRx = regHPRx;
	pCoexSta->lowPriorityTx = regLPTx;
	pCoexSta->lowPriorityRx = regLPRx;

	BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_BT_MONITOR, ("[BTCoex], High Priority Tx/Rx (reg 0x%x)=0x%x(%d)/0x%x(%d)\n",
	          regHPTxRx, regHPTx, regHPTx, regHPRx, regHPRx));
	BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_BT_MONITOR, ("[BTCoex], Low Priority Tx/Rx (reg 0x%x)=0x%x(%d)/0x%x(%d)\n",
	          regLPTxRx, regLPTx, regLPTx, regLPRx, regLPRx));

	// reset counter
	pBtCoexist->fBtcWrite1Byte(pBtCoexist, 0x76e, 0xc);
}

VOID
halbtc8192e1ant_QueryBtInfo(
    IN	PBTC_COEXIST		pBtCoexist
)
{
	u1Byte			H2C_Parameter[1] = {0};

	pCoexSta->bC2hBtInfoReqSent = TRUE;

	H2C_Parameter[0] |= BIT0;	// trigger

	BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE_FW_EXEC, ("[BTCoex], Query Bt Info, FW write 0x61=0x%x\n",
	          H2C_Parameter[0]));

	pBtCoexist->fBtcFillH2c(pBtCoexist, 0x61, 1, H2C_Parameter);
}

BOOLEAN
halbtc8192e1ant_IsWifiStatusChanged(
    IN	PBTC_COEXIST		pBtCoexist
)
{
	static BOOLEAN	bPreWifiBusy=FALSE, bPreUnder4way=FALSE, bPreBtHsOn=FALSE;
	BOOLEAN	bWifiBusy=FALSE, bUnder4way=FALSE, bBtHsOn=FALSE;
	BOOLEAN	bWifiConnected=FALSE;

	pBtCoexist->fBtcGet(pBtCoexist, BTC_GET_BL_WIFI_CONNECTED, &bWifiConnected);
	pBtCoexist->fBtcGet(pBtCoexist, BTC_GET_BL_WIFI_BUSY, &bWifiBusy);
	pBtCoexist->fBtcGet(pBtCoexist, BTC_GET_BL_HS_OPERATION, &bBtHsOn);
	pBtCoexist->fBtcGet(pBtCoexist, BTC_GET_BL_WIFI_4_WAY_PROGRESS, &bUnder4way);

	if(bWifiConnected) {
		if(bWifiBusy != bPreWifiBusy) {
			bPreWifiBusy = bWifiBusy;
			return TRUE;
		}
		if(bUnder4way != bPreUnder4way) {
			bPreUnder4way = bUnder4way;
			return TRUE;
		}
		if(bBtHsOn != bPreBtHsOn) {
			bPreBtHsOn = bBtHsOn;
			return TRUE;
		}
	}

	return FALSE;
}

VOID
halbtc8192e1ant_UpdateBtLinkInfo(
    IN	PBTC_COEXIST		pBtCoexist
)
{
	PBTC_BT_LINK_INFO	pBtLinkInfo=&pBtCoexist->btLinkInfo;

	pBtLinkInfo->bBtLinkExist = pCoexSta->bBtLinkExist;
	pBtLinkInfo->bScoExist = pCoexSta->bScoExist;
	pBtLinkInfo->bA2dpExist = pCoexSta->bA2dpExist;
	pBtLinkInfo->bPanExist = pCoexSta->bPanExist;
	pBtLinkInfo->bHidExist = pCoexSta->bHidExist;

	// check if Sco only
	if( pBtLinkInfo->bScoExist &&
	    !pBtLinkInfo->bA2dpExist &&
	    !pBtLinkInfo->bPanExist &&
	    !pBtLinkInfo->bHidExist )
		pBtLinkInfo->bScoOnly = TRUE;
	else
		pBtLinkInfo->bScoOnly = FALSE;

	// check if A2dp only
	if( !pBtLinkInfo->bScoExist &&
	    pBtLinkInfo->bA2dpExist &&
	    !pBtLinkInfo->bPanExist &&
	    !pBtLinkInfo->bHidExist )
		pBtLinkInfo->bA2dpOnly = TRUE;
	else
		pBtLinkInfo->bA2dpOnly = FALSE;

	// check if Pan only
	if( !pBtLinkInfo->bScoExist &&
	    !pBtLinkInfo->bA2dpExist &&
	    pBtLinkInfo->bPanExist &&
	    !pBtLinkInfo->bHidExist )
		pBtLinkInfo->bPanOnly = TRUE;
	else
		pBtLinkInfo->bPanOnly = FALSE;

	// check if Hid only
	if( !pBtLinkInfo->bScoExist &&
	    !pBtLinkInfo->bA2dpExist &&
	    !pBtLinkInfo->bPanExist &&
	    pBtLinkInfo->bHidExist )
		pBtLinkInfo->bHidOnly = TRUE;
	else
		pBtLinkInfo->bHidOnly = FALSE;
}

u1Byte
halbtc8192e1ant_ActionAlgorithm(
    IN	PBTC_COEXIST		pBtCoexist
)
{
	PBTC_BT_LINK_INFO	pBtLinkInfo=&pBtCoexist->btLinkInfo;
	BOOLEAN				bBtHsOn=FALSE;
	u1Byte				algorithm=BT_8192E_1ANT_COEX_ALGO_UNDEFINED;
	u1Byte				numOfDiffProfile=0;

	pBtCoexist->fBtcGet(pBtCoexist, BTC_GET_BL_HS_OPERATION, &bBtHsOn);

	if(!pBtLinkInfo->bBtLinkExist) {
		BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], No BT link exists!!!\n"));
		return algorithm;
	}

	if(pBtLinkInfo->bScoExist)
		numOfDiffProfile++;
	if(pBtLinkInfo->bHidExist)
		numOfDiffProfile++;
	if(pBtLinkInfo->bPanExist)
		numOfDiffProfile++;
	if(pBtLinkInfo->bA2dpExist)
		numOfDiffProfile++;

	if(numOfDiffProfile == 1) {
		if(pBtLinkInfo->bScoExist) {
			BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], SCO only\n"));
			algorithm = BT_8192E_1ANT_COEX_ALGO_SCO;
		} else {
			if(pBtLinkInfo->bHidExist) {
				BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], HID only\n"));
				algorithm = BT_8192E_1ANT_COEX_ALGO_HID;
			} else if(pBtLinkInfo->bA2dpExist) {
				BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], A2DP only\n"));
				algorithm = BT_8192E_1ANT_COEX_ALGO_A2DP;
			} else if(pBtLinkInfo->bPanExist) {
				if(bBtHsOn) {
					BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], PAN(HS) only\n"));
					algorithm = BT_8192E_1ANT_COEX_ALGO_PANHS;
				} else {
					BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], PAN(EDR) only\n"));
					algorithm = BT_8192E_1ANT_COEX_ALGO_PANEDR;
				}
			}
		}
	} else if(numOfDiffProfile == 2) {
		if(pBtLinkInfo->bScoExist) {
			if(pBtLinkInfo->bHidExist) {
				BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], SCO + HID\n"));
				algorithm = BT_8192E_1ANT_COEX_ALGO_HID;
			} else if(pBtLinkInfo->bA2dpExist) {
				BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], SCO + A2DP ==> SCO\n"));
				algorithm = BT_8192E_1ANT_COEX_ALGO_SCO;
			} else if(pBtLinkInfo->bPanExist) {
				if(bBtHsOn) {
					BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], SCO + PAN(HS)\n"));
					algorithm = BT_8192E_1ANT_COEX_ALGO_SCO;
				} else {
					BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], SCO + PAN(EDR)\n"));
					algorithm = BT_8192E_1ANT_COEX_ALGO_PANEDR_HID;
				}
			}
		} else {
			if( pBtLinkInfo->bHidExist &&
			    pBtLinkInfo->bA2dpExist ) {
				BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], HID + A2DP\n"));
				algorithm = BT_8192E_1ANT_COEX_ALGO_HID_A2DP;
			} else if( pBtLinkInfo->bHidExist &&
			           pBtLinkInfo->bPanExist ) {
				if(bBtHsOn) {
					BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], HID + PAN(HS)\n"));
					algorithm = BT_8192E_1ANT_COEX_ALGO_HID_A2DP;
				} else {
					BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], HID + PAN(EDR)\n"));
					algorithm = BT_8192E_1ANT_COEX_ALGO_PANEDR_HID;
				}
			} else if( pBtLinkInfo->bPanExist &&
			           pBtLinkInfo->bA2dpExist ) {
				if(bBtHsOn) {
					BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], A2DP + PAN(HS)\n"));
					algorithm = BT_8192E_1ANT_COEX_ALGO_A2DP_PANHS;
				} else {
					BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], A2DP + PAN(EDR)\n"));
					algorithm = BT_8192E_1ANT_COEX_ALGO_PANEDR_A2DP;
				}
			}
		}
	} else if(numOfDiffProfile == 3) {
		if(pBtLinkInfo->bScoExist) {
			if( pBtLinkInfo->bHidExist &&
			    pBtLinkInfo->bA2dpExist ) {
				BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], SCO + HID + A2DP ==> HID\n"));
				algorithm = BT_8192E_1ANT_COEX_ALGO_HID;
			} else if( pBtLinkInfo->bHidExist &&
			           pBtLinkInfo->bPanExist ) {
				if(bBtHsOn) {
					BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], SCO + HID + PAN(HS)\n"));
					algorithm = BT_8192E_1ANT_COEX_ALGO_HID_A2DP;
				} else {
					BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], SCO + HID + PAN(EDR)\n"));
					algorithm = BT_8192E_1ANT_COEX_ALGO_PANEDR_HID;
				}
			} else if( pBtLinkInfo->bPanExist &&
			           pBtLinkInfo->bA2dpExist ) {
				if(bBtHsOn) {
					BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], SCO + A2DP + PAN(HS)\n"));
					algorithm = BT_8192E_1ANT_COEX_ALGO_SCO;
				} else {
					BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], SCO + A2DP + PAN(EDR) ==> HID\n"));
					algorithm = BT_8192E_1ANT_COEX_ALGO_PANEDR_HID;
				}
			}
		} else {
			if( pBtLinkInfo->bHidExist &&
			    pBtLinkInfo->bPanExist &&
			    pBtLinkInfo->bA2dpExist ) {
				if(bBtHsOn) {
					BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], HID + A2DP + PAN(HS)\n"));
					algorithm = BT_8192E_1ANT_COEX_ALGO_HID_A2DP;
				} else {
					BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], HID + A2DP + PAN(EDR)\n"));
					algorithm = BT_8192E_1ANT_COEX_ALGO_HID_A2DP_PANEDR;
				}
			}
		}
	} else if(numOfDiffProfile >= 3) {
		if(pBtLinkInfo->bScoExist) {
			if( pBtLinkInfo->bHidExist &&
			    pBtLinkInfo->bPanExist &&
			    pBtLinkInfo->bA2dpExist ) {
				if(bBtHsOn) {
					BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], Error!!! SCO + HID + A2DP + PAN(HS)\n"));

				} else {
					BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], SCO + HID + A2DP + PAN(EDR)==>PAN(EDR)+HID\n"));
					algorithm = BT_8192E_1ANT_COEX_ALGO_PANEDR_HID;
				}
			}
		}
	}

	return algorithm;
}

VOID
halbtc8192e1ant_SetFwDacSwingLevel(
    IN	PBTC_COEXIST		pBtCoexist,
    IN	u1Byte			dacSwingLvl
)
{
	u1Byte			H2C_Parameter[1] = {0};

	// There are several type of dacswing
	// 0x18/ 0x10/ 0xc/ 0x8/ 0x4/ 0x6
	H2C_Parameter[0] = dacSwingLvl;

	BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE_FW_EXEC, ("[BTCoex], Set Dac Swing Level=0x%x\n", dacSwingLvl));
	BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE_FW_EXEC, ("[BTCoex], FW write 0x64=0x%x\n", H2C_Parameter[0]));

	pBtCoexist->fBtcFillH2c(pBtCoexist, 0x64, 1, H2C_Parameter);
}

VOID
halbtc8192e1ant_SetFwDecBtPwr(
    IN	PBTC_COEXIST		pBtCoexist,
    IN	u1Byte				decBtPwrLvl
)
{
	u1Byte			H2C_Parameter[1] = {0};

	H2C_Parameter[0] = decBtPwrLvl;

	BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE_FW_EXEC, ("[BTCoex], decrease Bt Power level = %d, FW write 0x62=0x%x\n",
	          decBtPwrLvl, H2C_Parameter[0]));

	pBtCoexist->fBtcFillH2c(pBtCoexist, 0x62, 1, H2C_Parameter);
}

VOID
halbtc8192e1ant_DecBtPwr(
    IN	PBTC_COEXIST		pBtCoexist,
    IN	BOOLEAN				bForceExec,
    IN	u1Byte				decBtPwrLvl
)
{
	BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE_FW, ("[BTCoex], %s Dec BT power level = %d\n",
	          (bForceExec? "force to":""), decBtPwrLvl));
	pCoexDm->curBtDecPwrLvl = decBtPwrLvl;

	if(!bForceExec) {
		BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE_FW_DETAIL, ("[BTCoex], BtDecPwrLvl=%d, curBtDecPwrLvl=%d\n",
		          pCoexDm->preBtDecPwrLvl, pCoexDm->curBtDecPwrLvl));

		if(pCoexDm->preBtDecPwrLvl == pCoexDm->curBtDecPwrLvl)
			return;
	}
	halbtc8192e1ant_SetFwDecBtPwr(pBtCoexist, pCoexDm->curBtDecPwrLvl);

	pCoexDm->preBtDecPwrLvl = pCoexDm->curBtDecPwrLvl;
}

VOID
halbtc8192e1ant_SetBtAutoReport(
    IN	PBTC_COEXIST		pBtCoexist,
    IN	BOOLEAN			bEnableAutoReport
)
{
	u1Byte			H2C_Parameter[1] = {0};

	H2C_Parameter[0] = 0;

	if(bEnableAutoReport) {
		H2C_Parameter[0] |= BIT0;
	}

	BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE_FW_EXEC, ("[BTCoex], BT FW auto report : %s, FW write 0x68=0x%x\n",
	          (bEnableAutoReport? "Enabled!!":"Disabled!!"), H2C_Parameter[0]));

	pBtCoexist->fBtcFillH2c(pBtCoexist, 0x68, 1, H2C_Parameter);
}

VOID
halbtc8192e1ant_BtAutoReport(
    IN	PBTC_COEXIST		pBtCoexist,
    IN	BOOLEAN			bForceExec,
    IN	BOOLEAN			bEnableAutoReport
)
{
	BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE_FW, ("[BTCoex], %s BT Auto report = %s\n",
	          (bForceExec? "force to":""), ((bEnableAutoReport)? "Enabled":"Disabled")));
	pCoexDm->bCurBtAutoReport = bEnableAutoReport;

	if(!bForceExec) {
		BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE_FW_DETAIL, ("[BTCoex], bPreBtAutoReport=%d, bCurBtAutoReport=%d\n",
		          pCoexDm->bPreBtAutoReport, pCoexDm->bCurBtAutoReport));

		if(pCoexDm->bPreBtAutoReport == pCoexDm->bCurBtAutoReport)
			return;
	}
	halbtc8192e1ant_SetBtAutoReport(pBtCoexist, pCoexDm->bCurBtAutoReport);

	pCoexDm->bPreBtAutoReport = pCoexDm->bCurBtAutoReport;
}

VOID
halbtc8192e1ant_FwDacSwingLvl(
    IN	PBTC_COEXIST		pBtCoexist,
    IN	BOOLEAN			bForceExec,
    IN	u1Byte			fwDacSwingLvl
)
{
	BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE_FW, ("[BTCoex], %s set FW Dac Swing level = %d\n",
	          (bForceExec? "force to":""), fwDacSwingLvl));
	pCoexDm->curFwDacSwingLvl = fwDacSwingLvl;

	if(!bForceExec) {
		BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE_FW_DETAIL, ("[BTCoex], preFwDacSwingLvl=%d, curFwDacSwingLvl=%d\n",
		          pCoexDm->preFwDacSwingLvl, pCoexDm->curFwDacSwingLvl));

		if(pCoexDm->preFwDacSwingLvl == pCoexDm->curFwDacSwingLvl)
			return;
	}

	halbtc8192e1ant_SetFwDacSwingLevel(pBtCoexist, pCoexDm->curFwDacSwingLvl);

	pCoexDm->preFwDacSwingLvl = pCoexDm->curFwDacSwingLvl;
}

VOID
halbtc8192e1ant_SetSwPenaltyTxRateAdaptive(
    IN	PBTC_COEXIST		pBtCoexist,
    IN	BOOLEAN			bLowPenaltyRa
)
{
	u1Byte	tmpU1;

	tmpU1 = pBtCoexist->fBtcRead1Byte(pBtCoexist, 0x4fd);
	tmpU1 |= BIT0;
	if(bLowPenaltyRa) {
		BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE_SW_EXEC, ("[BTCoex], Tx rate adaptive, set low penalty!!\n"));
		tmpU1 &= ~BIT2;
	} else {
		BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE_SW_EXEC, ("[BTCoex], Tx rate adaptive, set normal!!\n"));
		tmpU1 |= BIT2;
	}

	pBtCoexist->fBtcWrite1Byte(pBtCoexist, 0x4fd, tmpU1);
}

VOID
halbtc8192e1ant_LowPenaltyRa(
    IN	PBTC_COEXIST		pBtCoexist,
    IN	BOOLEAN			bForceExec,
    IN	BOOLEAN			bLowPenaltyRa
)
{
	return;
	BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE_SW, ("[BTCoex], %s turn LowPenaltyRA = %s\n",
	          (bForceExec? "force to":""), ((bLowPenaltyRa)? "ON":"OFF")));
	pCoexDm->bCurLowPenaltyRa = bLowPenaltyRa;

	if(!bForceExec) {
		BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE_SW_DETAIL, ("[BTCoex], bPreLowPenaltyRa=%d, bCurLowPenaltyRa=%d\n",
		          pCoexDm->bPreLowPenaltyRa, pCoexDm->bCurLowPenaltyRa));

		if(pCoexDm->bPreLowPenaltyRa == pCoexDm->bCurLowPenaltyRa)
			return;
	}
	halbtc8192e1ant_SetSwPenaltyTxRateAdaptive(pBtCoexist, pCoexDm->bCurLowPenaltyRa);

	pCoexDm->bPreLowPenaltyRa = pCoexDm->bCurLowPenaltyRa;
}

VOID
halbtc8192e1ant_SetDacSwingReg(
    IN	PBTC_COEXIST		pBtCoexist,
    IN	u4Byte			level
)
{
	u1Byte	val=(u1Byte)level;

	BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE_SW_EXEC, ("[BTCoex], Write SwDacSwing = 0x%x\n", level));
	pBtCoexist->fBtcWrite1ByteBitMask(pBtCoexist, 0x883, 0x3e, val);
}

VOID
halbtc8192e1ant_SetSwFullTimeDacSwing(
    IN	PBTC_COEXIST		pBtCoexist,
    IN	BOOLEAN			bSwDacSwingOn,
    IN	u4Byte			swDacSwingLvl
)
{
	if(bSwDacSwingOn) {
		halbtc8192e1ant_SetDacSwingReg(pBtCoexist, swDacSwingLvl);
	} else {
		halbtc8192e1ant_SetDacSwingReg(pBtCoexist, 0x18);
	}
}

VOID
halbtc8192e1ant_DacSwing(
    IN	PBTC_COEXIST		pBtCoexist,
    IN	BOOLEAN			bForceExec,
    IN	BOOLEAN			bDacSwingOn,
    IN	u4Byte			dacSwingLvl
)
{
	BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE_SW, ("[BTCoex], %s turn DacSwing=%s, dacSwingLvl=0x%x\n",
	          (bForceExec? "force to":""), ((bDacSwingOn)? "ON":"OFF"), dacSwingLvl));
	pCoexDm->bCurDacSwingOn = bDacSwingOn;
	pCoexDm->curDacSwingLvl = dacSwingLvl;

	if(!bForceExec) {
		BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE_SW_DETAIL, ("[BTCoex], bPreDacSwingOn=%d, preDacSwingLvl=0x%x, bCurDacSwingOn=%d, curDacSwingLvl=0x%x\n",
		          pCoexDm->bPreDacSwingOn, pCoexDm->preDacSwingLvl,
		          pCoexDm->bCurDacSwingOn, pCoexDm->curDacSwingLvl));

		if( (pCoexDm->bPreDacSwingOn == pCoexDm->bCurDacSwingOn) &&
		    (pCoexDm->preDacSwingLvl == pCoexDm->curDacSwingLvl) )
			return;
	}
	delay_ms(30);
	halbtc8192e1ant_SetSwFullTimeDacSwing(pBtCoexist, bDacSwingOn, dacSwingLvl);

	pCoexDm->bPreDacSwingOn = pCoexDm->bCurDacSwingOn;
	pCoexDm->preDacSwingLvl = pCoexDm->curDacSwingLvl;
}

VOID
halbtc8192e1ant_SetCoexTable(
    IN	PBTC_COEXIST	pBtCoexist,
    IN	u4Byte		val0x6c0,
    IN	u4Byte		val0x6c4,
    IN	u4Byte		val0x6c8,
    IN	u1Byte		val0x6cc
)
{
	BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE_SW_EXEC, ("[BTCoex], set coex table, set 0x6c0=0x%x\n", val0x6c0));
	pBtCoexist->fBtcWrite4Byte(pBtCoexist, 0x6c0, val0x6c0);

	BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE_SW_EXEC, ("[BTCoex], set coex table, set 0x6c4=0x%x\n", val0x6c4));
	pBtCoexist->fBtcWrite4Byte(pBtCoexist, 0x6c4, val0x6c4);

	BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE_SW_EXEC, ("[BTCoex], set coex table, set 0x6c8=0x%x\n", val0x6c8));
	pBtCoexist->fBtcWrite4Byte(pBtCoexist, 0x6c8, val0x6c8);

	BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE_SW_EXEC, ("[BTCoex], set coex table, set 0x6cc=0x%x\n", val0x6cc));
	pBtCoexist->fBtcWrite1Byte(pBtCoexist, 0x6cc, val0x6cc);
}

VOID
halbtc8192e1ant_CoexTable(
    IN	PBTC_COEXIST		pBtCoexist,
    IN	BOOLEAN			bForceExec,
    IN	u4Byte			val0x6c0,
    IN	u4Byte			val0x6c4,
    IN	u4Byte			val0x6c8,
    IN	u1Byte			val0x6cc
)
{
	BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE_SW, ("[BTCoex], %s write Coex Table 0x6c0=0x%x, 0x6c4=0x%x, 0x6c8=0x%x, 0x6cc=0x%x\n",
	          (bForceExec? "force to":""), val0x6c0, val0x6c4, val0x6c8, val0x6cc));
	pCoexDm->curVal0x6c0 = val0x6c0;
	pCoexDm->curVal0x6c4 = val0x6c4;
	pCoexDm->curVal0x6c8 = val0x6c8;
	pCoexDm->curVal0x6cc = val0x6cc;

	if(!bForceExec) {
		BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE_SW_DETAIL, ("[BTCoex], preVal0x6c0=0x%x, preVal0x6c4=0x%x, preVal0x6c8=0x%x, preVal0x6cc=0x%x !!\n",
		          pCoexDm->preVal0x6c0, pCoexDm->preVal0x6c4, pCoexDm->preVal0x6c8, pCoexDm->preVal0x6cc));
		BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE_SW_DETAIL, ("[BTCoex], curVal0x6c0=0x%x, curVal0x6c4=0x%x, curVal0x6c8=0x%x, curVal0x6cc=0x%x !!\n",
		          pCoexDm->curVal0x6c0, pCoexDm->curVal0x6c4, pCoexDm->curVal0x6c8, pCoexDm->curVal0x6cc));

		if( (pCoexDm->preVal0x6c0 == pCoexDm->curVal0x6c0) &&
		    (pCoexDm->preVal0x6c4 == pCoexDm->curVal0x6c4) &&
		    (pCoexDm->preVal0x6c8 == pCoexDm->curVal0x6c8) &&
		    (pCoexDm->preVal0x6cc == pCoexDm->curVal0x6cc) )
			return;
	}
	halbtc8192e1ant_SetCoexTable(pBtCoexist, val0x6c0, val0x6c4, val0x6c8, val0x6cc);

	pCoexDm->preVal0x6c0 = pCoexDm->curVal0x6c0;
	pCoexDm->preVal0x6c4 = pCoexDm->curVal0x6c4;
	pCoexDm->preVal0x6c8 = pCoexDm->curVal0x6c8;
	pCoexDm->preVal0x6cc = pCoexDm->curVal0x6cc;
}

VOID
halbtc8192e1ant_CoexTableWithType(
    IN	PBTC_COEXIST		pBtCoexist,
    IN	BOOLEAN				bForceExec,
    IN	u1Byte				type
)
{
	switch(type) {
	case 0:
		halbtc8192e1ant_CoexTable(pBtCoexist, bForceExec, 0x55555555, 0x55555555, 0xffffff, 0x3);
		break;
	case 1:
		halbtc8192e1ant_CoexTable(pBtCoexist, bForceExec, 0x55555555, 0x5a5a5a5a, 0xffffff, 0x3);
		break;
	case 2:
		halbtc8192e1ant_CoexTable(pBtCoexist, bForceExec, 0x5a5a5a5a, 0x5a5a5a5a, 0xffffff, 0x3);
		break;
	case 3:
		halbtc8192e1ant_CoexTable(pBtCoexist, bForceExec, 0xaaaaaaaa, 0xaaaaaaaa, 0xffffff, 0x3);
		break;
	case 4:
		halbtc8192e1ant_CoexTable(pBtCoexist, bForceExec, 0xffffffff, 0xffffffff, 0xffffff, 0x3);
		break;
	case 5:
		halbtc8192e1ant_CoexTable(pBtCoexist, bForceExec, 0x5fff5fff, 0x5fff5fff, 0xffffff, 0x3);
		break;
	case 6:
		halbtc8192e1ant_CoexTable(pBtCoexist, bForceExec, 0x55ff55ff, 0x5a5a5a5a, 0xffffff, 0x3);
		break;
	case 7:
		halbtc8192e1ant_CoexTable(pBtCoexist, bForceExec, 0xddffddff, 0xddffddff, 0xffffff, 0x3);
		break;
	case 8:
		halbtc8192e1ant_CoexTable(pBtCoexist, bForceExec, 0x55ff55ff, 0x5afa5afa, 0xffffff, 0x3);
		break;
	case 9:
		halbtc8192e1ant_CoexTable(pBtCoexist, bForceExec, 0x5f5f5f5f, 0x5f5f5f5f, 0xffffff, 0x3);
		break;
	default:
		break;
	}
}

VOID
halbtc8192e1ant_SetFwIgnoreWlanAct(
    IN	PBTC_COEXIST		pBtCoexist,
    IN	BOOLEAN			bEnable
)
{
	u1Byte			H2C_Parameter[1] = {0};

	if(bEnable) {
		H2C_Parameter[0] |= BIT0;		// function enable
	}

	BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE_FW_EXEC, ("[BTCoex], set FW for BT Ignore Wlan_Act, FW write 0x63=0x%x\n",
	          H2C_Parameter[0]));

	pBtCoexist->fBtcFillH2c(pBtCoexist, 0x63, 1, H2C_Parameter);
}

VOID
halbtc8192e1ant_IgnoreWlanAct(
    IN	PBTC_COEXIST		pBtCoexist,
    IN	BOOLEAN			bForceExec,
    IN	BOOLEAN			bEnable
)
{
	BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE_FW, ("[BTCoex], %s turn Ignore WlanAct %s\n",
	          (bForceExec? "force to":""), (bEnable? "ON":"OFF")));
	pCoexDm->bCurIgnoreWlanAct = bEnable;

	if(!bForceExec) {
		BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE_FW_DETAIL, ("[BTCoex], bPreIgnoreWlanAct = %d, bCurIgnoreWlanAct = %d!!\n",
		          pCoexDm->bPreIgnoreWlanAct, pCoexDm->bCurIgnoreWlanAct));

		if(pCoexDm->bPreIgnoreWlanAct == pCoexDm->bCurIgnoreWlanAct)
			return;
	}
	halbtc8192e1ant_SetFwIgnoreWlanAct(pBtCoexist, bEnable);

	pCoexDm->bPreIgnoreWlanAct = pCoexDm->bCurIgnoreWlanAct;
}

VOID
halbtc8192e1ant_SetFwPstdma(
    IN	PBTC_COEXIST		pBtCoexist,
    IN	u1Byte			byte1,
    IN	u1Byte			byte2,
    IN	u1Byte			byte3,
    IN	u1Byte			byte4,
    IN	u1Byte			byte5
)
{
	u1Byte			H2C_Parameter[5] = {0};

	H2C_Parameter[0] = byte1;
	H2C_Parameter[1] = byte2;
	H2C_Parameter[2] = byte3;
	H2C_Parameter[3] = byte4;
	H2C_Parameter[4] = byte5;

	pCoexDm->psTdmaPara[0] = byte1;
	pCoexDm->psTdmaPara[1] = byte2;
	pCoexDm->psTdmaPara[2] = byte3;
	pCoexDm->psTdmaPara[3] = byte4;
	pCoexDm->psTdmaPara[4] = byte5;

	BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE_FW_EXEC, ("[BTCoex], FW write 0x60(5bytes)=0x%x%08x\n",
	          H2C_Parameter[0],
	          H2C_Parameter[1]<<24|H2C_Parameter[2]<<16|H2C_Parameter[3]<<8|H2C_Parameter[4]));

	pBtCoexist->fBtcFillH2c(pBtCoexist, 0x60, 5, H2C_Parameter);
}

VOID
halbtc8192e1ant_SetLpsRpwm(
    IN	PBTC_COEXIST		pBtCoexist,
    IN	u1Byte			lpsVal,
    IN	u1Byte			rpwmVal
)
{
	u1Byte	lps=lpsVal;
	u1Byte	rpwm=rpwmVal;

	pBtCoexist->fBtcSet(pBtCoexist, BTC_SET_U1_LPS_VAL, &lps);
	pBtCoexist->fBtcSet(pBtCoexist, BTC_SET_U1_RPWM_VAL, &rpwm);
}

VOID
halbtc8192e1ant_LpsRpwm(
    IN	PBTC_COEXIST		pBtCoexist,
    IN	BOOLEAN			bForceExec,
    IN	u1Byte			lpsVal,
    IN	u1Byte			rpwmVal
)
{
	//BOOLEAN	bForceExecPwrCmd=FALSE;

	BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE_FW, ("[BTCoex], %s set lps/rpwm=0x%x/0x%x \n",
	          (bForceExec? "force to":""), lpsVal, rpwmVal));
	pCoexDm->curLps = lpsVal;
	pCoexDm->curRpwm = rpwmVal;

	if(!bForceExec) {
		BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE_FW_DETAIL, ("[BTCoex], preLps/curLps=0x%x/0x%x, preRpwm/curRpwm=0x%x/0x%x!!\n",
		          pCoexDm->preLps, pCoexDm->curLps, pCoexDm->preRpwm, pCoexDm->curRpwm));

		if( (pCoexDm->preLps == pCoexDm->curLps) &&
		    (pCoexDm->preRpwm == pCoexDm->curRpwm) ) {
			return;
		}
	}
	halbtc8192e1ant_SetLpsRpwm(pBtCoexist, lpsVal, rpwmVal);

	pCoexDm->preLps = pCoexDm->curLps;
	pCoexDm->preRpwm = pCoexDm->curRpwm;
}

VOID
halbtc8192e1ant_SetAntPath(
    IN	PBTC_COEXIST		pBtCoexist,
    IN	u1Byte				antPosType,
    IN	BOOLEAN				bInitHwCfg,
    IN	BOOLEAN				bWifiOff
)
{
	u4Byte			u4Tmp=0;

	if(bInitHwCfg) {
		pBtCoexist->fBtcWrite1Byte(pBtCoexist, 0x944, 0x24);
		pBtCoexist->fBtcWrite4Byte(pBtCoexist, 0x930, 0x700700);
		if(pBtCoexist->chipInterface == BTC_INTF_USB)
			pBtCoexist->fBtcWrite4Byte(pBtCoexist, 0x64, 0x30430004);
		else
			pBtCoexist->fBtcWrite4Byte(pBtCoexist, 0x64, 0x30030004);

		// 0x4c[27][24]='00', Set Antenna to BB
		u4Tmp = pBtCoexist->fBtcRead4Byte(pBtCoexist, 0x4c);
		u4Tmp &= ~BIT24;
		u4Tmp &= ~BIT27;
		pBtCoexist->fBtcWrite4Byte(pBtCoexist, 0x4c, u4Tmp);
	} else if(bWifiOff) {
		if(pBtCoexist->chipInterface == BTC_INTF_USB)
			pBtCoexist->fBtcWrite4Byte(pBtCoexist, 0x64, 0x30430004);
		else
			pBtCoexist->fBtcWrite4Byte(pBtCoexist, 0x64, 0x30030004);

		// 0x4c[27][24]='11', Set Antenna to BT, 0x64[8:7]=0, 0x64[2]=1
		u4Tmp = pBtCoexist->fBtcRead4Byte(pBtCoexist, 0x4c);
		u4Tmp |= BIT24;
		u4Tmp |= BIT27;
		pBtCoexist->fBtcWrite4Byte(pBtCoexist, 0x4c, u4Tmp);
	}

	// ext switch setting
	switch(antPosType) {
	case BTC_ANT_PATH_WIFI:
		pBtCoexist->fBtcWrite1Byte(pBtCoexist, 0x92c, 0x4);
		break;
	case BTC_ANT_PATH_BT:
		pBtCoexist->fBtcWrite1Byte(pBtCoexist, 0x92c, 0x20);
		break;
	default:
	case BTC_ANT_PATH_PTA:
		pBtCoexist->fBtcWrite1Byte(pBtCoexist, 0x92c, 0x4);
		break;
	}
}

VOID
halbtc8192e1ant_PsTdma(
    IN	PBTC_COEXIST		pBtCoexist,
    IN	BOOLEAN			bForceExec,
    IN	BOOLEAN			bTurnOn,
    IN	u1Byte			type
)
{
	//BOOLEAN			bTurnOnByCnt=FALSE;
	u1Byte			rssiAdjustVal=0;

	BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE_FW, ("[BTCoex], %s turn %s PS TDMA, type=%d\n",
	          (bForceExec? "force to":""), (bTurnOn? "ON":"OFF"), type));
	pCoexDm->bCurPsTdmaOn = bTurnOn;
	pCoexDm->curPsTdma = type;

	if(!bForceExec) {
		BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE_FW_DETAIL, ("[BTCoex], bPrePsTdmaOn = %d, bCurPsTdmaOn = %d!!\n",
		          pCoexDm->bPrePsTdmaOn, pCoexDm->bCurPsTdmaOn));
		BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE_FW_DETAIL, ("[BTCoex], prePsTdma = %d, curPsTdma = %d!!\n",
		          pCoexDm->prePsTdma, pCoexDm->curPsTdma));

		if( (pCoexDm->bPrePsTdmaOn == pCoexDm->bCurPsTdmaOn) &&
		    (pCoexDm->prePsTdma == pCoexDm->curPsTdma) )
			return;
	}
	if(bTurnOn) {
		switch(type) {
		default:
			halbtc8192e1ant_SetFwPstdma(pBtCoexist, 0x53, 0x2c, 0x03, 0x10, 0x50);
			break;
		case 1:
			halbtc8192e1ant_SetFwPstdma(pBtCoexist, 0x53, 0x2c, 0x03, 0x10, 0x50);
			rssiAdjustVal = 11;
			break;
		case 2:
			halbtc8192e1ant_SetFwPstdma(pBtCoexist, 0x53, 0x25, 0x03, 0x10, 0x50);
			rssiAdjustVal = 14;
			break;
		case 3:
			halbtc8192e1ant_SetFwPstdma(pBtCoexist, 0x93, 0x25, 0x3, 0x10, 0x40);
			break;
		case 4:
			halbtc8192e1ant_SetFwPstdma(pBtCoexist, 0x93, 0x15, 0x3, 0x14, 0x0);
			rssiAdjustVal = 17;
			break;
		case 5:
			halbtc8192e1ant_SetFwPstdma(pBtCoexist, 0x61, 0x15, 0x3, 0x31, 0x0);
			break;
		case 6:
			halbtc8192e1ant_SetFwPstdma(pBtCoexist, 0x13, 0xa, 0x3, 0x0, 0x0);
			break;
		case 7:
			halbtc8192e1ant_SetFwPstdma(pBtCoexist, 0x13, 0xc, 0x5, 0x0, 0x0);
			break;
		case 8:
			halbtc8192e1ant_SetFwPstdma(pBtCoexist, 0x93, 0x25, 0x3, 0x10, 0x0);
			break;
		case 9:
			halbtc8192e1ant_SetFwPstdma(pBtCoexist, 0x53, 0x1e, 0x03, 0x10, 0x50);
			rssiAdjustVal = 18;
			break;
		case 10:
			halbtc8192e1ant_SetFwPstdma(pBtCoexist, 0x13, 0xa, 0xa, 0x0, 0x40);
			break;
		case 11:
			halbtc8192e1ant_SetFwPstdma(pBtCoexist, 0x53, 0x12, 0x03, 0x10, 0x50);
			rssiAdjustVal = 20;
			break;
		case 12:
			halbtc8192e1ant_SetFwPstdma(pBtCoexist, 0xeb, 0xa, 0x3, 0x31, 0x18);
			break;

		case 15:
			halbtc8192e1ant_SetFwPstdma(pBtCoexist, 0x13, 0xa, 0x3, 0x8, 0x0);
			break;
		case 16:
			halbtc8192e1ant_SetFwPstdma(pBtCoexist, 0x93, 0x15, 0x3, 0x10, 0x0);
			rssiAdjustVal = 18;
			break;

		case 18:
			halbtc8192e1ant_SetFwPstdma(pBtCoexist, 0x93, 0x25, 0x3, 0x10, 0x0);
			rssiAdjustVal = 14;
			break;

		case 20:
			halbtc8192e1ant_SetFwPstdma(pBtCoexist, 0x13, 0x25, 0x25, 0x0, 0x0);
			break;
		case 21:
			halbtc8192e1ant_SetFwPstdma(pBtCoexist, 0x93, 0x20, 0x3, 0x10, 0x40);
			break;
		case 22:
			halbtc8192e1ant_SetFwPstdma(pBtCoexist, 0x13, 0x8, 0x8, 0x0, 0x40);
			break;
		case 23:
			halbtc8192e1ant_SetFwPstdma(pBtCoexist, 0xe3, 0x25, 0x3, 0x31, 0x18);
			rssiAdjustVal = 22;
			break;
		case 24:
			halbtc8192e1ant_SetFwPstdma(pBtCoexist, 0xe3, 0x15, 0x3, 0x31, 0x18);
			rssiAdjustVal = 22;
			break;
		case 25:
			halbtc8192e1ant_SetFwPstdma(pBtCoexist, 0xe3, 0xa, 0x3, 0x31, 0x18);
			rssiAdjustVal = 22;
			break;
		case 26:
			halbtc8192e1ant_SetFwPstdma(pBtCoexist, 0xe3, 0xa, 0x3, 0x31, 0x18);
			rssiAdjustVal = 22;
			break;
		case 27:
			halbtc8192e1ant_SetFwPstdma(pBtCoexist, 0xe3, 0x25, 0x3, 0x31, 0x98);
			rssiAdjustVal = 22;
			break;
		case 28:
			halbtc8192e1ant_SetFwPstdma(pBtCoexist, 0x69, 0x25, 0x3, 0x31, 0x0);
			break;
		case 29:
			halbtc8192e1ant_SetFwPstdma(pBtCoexist, 0xab, 0x1a, 0x1a, 0x1, 0x10);
			break;
		case 30:
			halbtc8192e1ant_SetFwPstdma(pBtCoexist, 0x93, 0x15, 0x3, 0x14, 0x0);
			break;
		case 31:
			halbtc8192e1ant_SetFwPstdma(pBtCoexist, 0xd3, 0x1a, 0x1a, 0, 0x58);
			break;
		case 32:
			halbtc8192e1ant_SetFwPstdma(pBtCoexist, 0xab, 0xa, 0x3, 0x31, 0x90);
			break;
		case 33:
			halbtc8192e1ant_SetFwPstdma(pBtCoexist, 0xa3, 0x25, 0x3, 0x30, 0x90);
			break;
		case 34:
			halbtc8192e1ant_SetFwPstdma(pBtCoexist, 0xd3, 0x1a, 0x1a, 0x0, 0x10);
			break;
		case 35:
			halbtc8192e1ant_SetFwPstdma(pBtCoexist, 0xe3, 0x1a, 0x1a, 0x0, 0x10);
			break;
		case 36:
			halbtc8192e1ant_SetFwPstdma(pBtCoexist, 0xd3, 0x12, 0x3, 0x14, 0x50);
			break;
		case 37:
			halbtc8192e1ant_SetFwPstdma(pBtCoexist, 0x53, 0x25, 0x3, 0x10, 0x50);
			break;
		case 38:
			halbtc8192e1ant_SetFwPstdma(pBtCoexist, 0xe3, 0x12, 0x12, 0xe1, 0x90);
			break;
		}
	} else {
		// disable PS tdma
		switch(type) {
		case 8:		//0x778 = 1, ant2PTA
			halbtc8192e1ant_SetFwPstdma(pBtCoexist, 0x8, 0x0, 0x0, 0x0, 0x0);
			halbtc8192e1ant_SetAntPath(pBtCoexist, BTC_ANT_PATH_PTA, FALSE, FALSE);
			break;
		case 0:		//0x778 = 1, ant2BT
		default:
			halbtc8192e1ant_SetFwPstdma(pBtCoexist, 0x0, 0x0, 0x0, 0x0, 0x0);
			delay_ms(5);
			halbtc8192e1ant_SetAntPath(pBtCoexist, BTC_ANT_PATH_BT, FALSE, FALSE);
			break;
		case 9:		//0x778 = 1, ant2WIFI
			halbtc8192e1ant_SetFwPstdma(pBtCoexist, 0x0, 0x0, 0x0, 0x0, 0x0);
			halbtc8192e1ant_SetAntPath(pBtCoexist, BTC_ANT_PATH_WIFI, FALSE, FALSE);
			break;
		case 10:	//0x778 = 3, ant2BT
			halbtc8192e1ant_SetFwPstdma(pBtCoexist, 0x0, 0x0, 0x0, 0x8, 0x0);
			delay_ms(5);
			halbtc8192e1ant_SetAntPath(pBtCoexist, BTC_ANT_PATH_BT, FALSE, FALSE);
			break;
		}
	}
	rssiAdjustVal =0;
	pBtCoexist->fBtcSet(pBtCoexist, BTC_SET_U1_RSSI_ADJ_VAL_FOR_1ANT_COEX_TYPE, &rssiAdjustVal);

	// update pre state
	pCoexDm->bPrePsTdmaOn = pCoexDm->bCurPsTdmaOn;
	pCoexDm->prePsTdma = pCoexDm->curPsTdma;
}

VOID
halbtc8192e1ant_SetSwitchSsType(
    IN	PBTC_COEXIST		pBtCoexist,
    IN	u1Byte				ssType
)
{
	u1Byte	mimoPs=BTC_MIMO_PS_DYNAMIC;

	BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], REAL set SS Type = %d\n", ssType));

	if(ssType == 1) {
		halbtc8192e1ant_UpdateRaMask(pBtCoexist, FORCE_EXEC, BTC_RATE_DISABLE, 0xfff00000);	// disable 2ss
		halbtc8192e1ant_PsTdma(pBtCoexist, FORCE_EXEC, FALSE, 0);
		// switch ofdm path
		pBtCoexist->fBtcWrite1Byte(pBtCoexist, 0xc04, 0x11);
		pBtCoexist->fBtcWrite1Byte(pBtCoexist, 0xd04, 0x1);
		pBtCoexist->fBtcWrite4Byte(pBtCoexist, 0x90c, 0x81111111);
		// switch cck patch
		pBtCoexist->fBtcWrite1ByteBitMask(pBtCoexist, 0xe77, 0x4, 0x1);
		pBtCoexist->fBtcWrite1Byte(pBtCoexist, 0xa07, 0x81);
		mimoPs=BTC_MIMO_PS_STATIC;
	} else if(ssType == 2) {
		halbtc8192e1ant_UpdateRaMask(pBtCoexist, FORCE_EXEC, BTC_RATE_ENABLE, 0xfff00000);	// enable 2ss
		halbtc8192e1ant_PsTdma(pBtCoexist, FORCE_EXEC, FALSE, 8);
		pBtCoexist->fBtcWrite1Byte(pBtCoexist, 0xc04, 0x33);
		pBtCoexist->fBtcWrite1Byte(pBtCoexist, 0xd04, 0x3);
		pBtCoexist->fBtcWrite4Byte(pBtCoexist, 0x90c, 0x81121313);
		pBtCoexist->fBtcWrite1ByteBitMask(pBtCoexist, 0xe77, 0x4, 0x0);
		pBtCoexist->fBtcWrite1Byte(pBtCoexist, 0xa07, 0x41);
		mimoPs=BTC_MIMO_PS_DYNAMIC;
	}

	pBtCoexist->fBtcSet(pBtCoexist, BTC_SET_ACT_SEND_MIMO_PS, &mimoPs);	// set rx 1ss or 2ss
}

VOID
halbtc8192e1ant_SwitchSsType(
    IN	PBTC_COEXIST		pBtCoexist,
    IN	BOOLEAN				bForceExec,
    IN	u1Byte				newSsType
)
{
	BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], %s Switch SS Type = %d\n",
	          (bForceExec? "force to":""), newSsType));
	pCoexDm->curSsType = newSsType;

	if(!bForceExec) {
		if(pCoexDm->preSsType == pCoexDm->curSsType)
			return;
	}
	halbtc8192e1ant_SetSwitchSsType(pBtCoexist, pCoexDm->curSsType);

	pCoexDm->preSsType = pCoexDm->curSsType;
}

VOID
halbtc8192e1ant_CoexAllOff(
    IN	PBTC_COEXIST		pBtCoexist
)
{
	halbtc8192e1ant_DecBtPwr(pBtCoexist, NORMAL_EXEC, 0);

	// hw all off
	halbtc8192e1ant_CoexTableWithType(pBtCoexist, NORMAL_EXEC, 0);
}

BOOLEAN
halbtc8192e1ant_IsCommonAction(
    IN	PBTC_COEXIST		pBtCoexist
)
{
	BOOLEAN			bCommon=FALSE, bWifiConnected=FALSE, bWifiBusy=FALSE;

	pBtCoexist->fBtcGet(pBtCoexist, BTC_GET_BL_WIFI_CONNECTED, &bWifiConnected);
	pBtCoexist->fBtcGet(pBtCoexist, BTC_GET_BL_WIFI_BUSY, &bWifiBusy);

	if(!bWifiConnected &&
	   BT_8192E_1ANT_BT_STATUS_NON_CONNECTED_IDLE == pCoexDm->btStatus) {
		BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], Wifi non connected-idle + BT non connected-idle!!\n"));
		bCommon = TRUE;
	} else if(bWifiConnected &&
	          (BT_8192E_1ANT_BT_STATUS_NON_CONNECTED_IDLE == pCoexDm->btStatus) ) {
		BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], Wifi connected + BT non connected-idle!!\n"));

		bCommon = TRUE;
	} else if(!bWifiConnected &&
	          (BT_8192E_1ANT_BT_STATUS_CONNECTED_IDLE == pCoexDm->btStatus) ) {
		BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], Wifi non connected-idle + BT connected-idle!!\n"));

		bCommon = TRUE;
	} else if(bWifiConnected &&
	          (BT_8192E_1ANT_BT_STATUS_CONNECTED_IDLE == pCoexDm->btStatus) ) {
		BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], Wifi connected + BT connected-idle!!\n"));

		bCommon = TRUE;
	} else if(!bWifiConnected &&
	          (BT_8192E_1ANT_BT_STATUS_CONNECTED_IDLE != pCoexDm->btStatus) ) {
		BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], Wifi non connected-idle + BT Busy!!\n"));

		bCommon = TRUE;
	} else {
		bCommon = FALSE;
	}

	return bCommon;
}


VOID
halbtc8192e1ant_TdmaDurationAdjustForAcl(
    IN	PBTC_COEXIST		pBtCoexist,
    IN	u1Byte				wifiStatus
)
{
	static s4Byte		up,dn,m,n,WaitCount;
	s4Byte			result;   //0: no change, +1: increase WiFi duration, -1: decrease WiFi duration
	u1Byte			retryCount=0, btInfoExt;

	BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE_FW, ("[BTCoex], TdmaDurationAdjustForAcl()\n"));

	if( (BT_8192E_1ANT_WIFI_STATUS_NON_CONNECTED_ASSO_AUTH_SCAN == wifiStatus) ||
	    (BT_8192E_1ANT_WIFI_STATUS_CONNECTED_SCAN == wifiStatus) ||
	    (BT_8192E_1ANT_WIFI_STATUS_CONNECTED_SPECIAL_PKT == wifiStatus) ) {
		if( pCoexDm->curPsTdma != 1 &&
		    pCoexDm->curPsTdma != 2 &&
		    pCoexDm->curPsTdma != 3 &&
		    pCoexDm->curPsTdma != 9 ) {
			halbtc8192e1ant_PsTdma(pBtCoexist, NORMAL_EXEC, TRUE, 9);
			pCoexDm->psTdmaDuAdjType = 9;

			up = 0;
			dn = 0;
			m = 1;
			n= 3;
			result = 0;
			WaitCount = 0;
		}
		return;
	}

	if(!pCoexDm->bAutoTdmaAdjust) {
		pCoexDm->bAutoTdmaAdjust = TRUE;
		BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE_FW_DETAIL, ("[BTCoex], first run TdmaDurationAdjust()!!\n"));

		halbtc8192e1ant_PsTdma(pBtCoexist, NORMAL_EXEC, TRUE, 2);
		pCoexDm->psTdmaDuAdjType = 2;
		//============
		up = 0;
		dn = 0;
		m = 1;
		n= 3;
		result = 0;
		WaitCount = 0;
	} else {
		//accquire the BT TRx retry count from BT_Info byte2
		retryCount = pCoexSta->btRetryCnt;
		btInfoExt = pCoexSta->btInfoExt;
		BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE_FW_DETAIL, ("[BTCoex], retryCount = %d\n", retryCount));
		BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE_FW_DETAIL, ("[BTCoex], up=%d, dn=%d, m=%d, n=%d, WaitCount=%d\n",
		          up, dn, m, n, WaitCount));
		result = 0;
		WaitCount++;

		if(retryCount == 0) { // no retry in the last 2-second duration
			up++;
			dn--;

			if (dn <= 0)
				dn = 0;

			if(up >= n) {	// if s n 2 retry count0, hռeWiFi duration
				WaitCount = 0;
				n = 3;
				up = 0;
				dn = 0;
				result = 1;
				BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE_FW_DETAIL, ("[BTCoex], Increase wifi duration!!\n"));
			}
		} else if (retryCount <= 3) {	// <=3 retry in the last 2-second duration
			up--;
			dn++;

			if (up <= 0)
				up = 0;

			if (dn == 2) {	// if s 2 2 retry count< 3, hկWiFi duration
				if (WaitCount <= 2)
					m++; // קK@blevelӦ^
				else
					m = 1;

				if ( m >= 20) //m ̤j = 20 ' ̤j120 recheckO_վ WiFi duration.
					m = 20;

				n = 3*m;
				up = 0;
				dn = 0;
				WaitCount = 0;
				result = -1;
				BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE_FW_DETAIL, ("[BTCoex], Decrease wifi duration for retryCounter<3!!\n"));
			}
		} else { //retry count > 3, un1 retry count > 3, hկWiFi duration
			if (WaitCount == 1)
				m++; // קK@blevelӦ^
			else
				m = 1;

			if ( m >= 20) //m ̤j = 20 ' ̤j120 recheckO_վ WiFi duration.
				m = 20;

			n = 3*m;
			up = 0;
			dn = 0;
			WaitCount = 0;
			result = -1;
			BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE_FW_DETAIL, ("[BTCoex], Decrease wifi duration for retryCounter>3!!\n"));
		}

		if(result == -1) {
			if( (BT_INFO_8192E_1ANT_A2DP_BASIC_RATE(btInfoExt)) &&
			    ((pCoexDm->curPsTdma == 1) ||(pCoexDm->curPsTdma == 2)) ) {
				halbtc8192e1ant_PsTdma(pBtCoexist, NORMAL_EXEC, TRUE, 9);
				pCoexDm->psTdmaDuAdjType = 9;
			} else if(pCoexDm->curPsTdma == 1) {
				halbtc8192e1ant_PsTdma(pBtCoexist, NORMAL_EXEC, TRUE, 2);
				pCoexDm->psTdmaDuAdjType = 2;
			} else if(pCoexDm->curPsTdma == 2) {
				halbtc8192e1ant_PsTdma(pBtCoexist, NORMAL_EXEC, TRUE, 9);
				pCoexDm->psTdmaDuAdjType = 9;
			} else if(pCoexDm->curPsTdma == 9) {
				halbtc8192e1ant_PsTdma(pBtCoexist, NORMAL_EXEC, TRUE, 11);
				pCoexDm->psTdmaDuAdjType = 11;
			}
		} else if(result == 1) {
			if( (BT_INFO_8192E_1ANT_A2DP_BASIC_RATE(btInfoExt)) &&
			    ((pCoexDm->curPsTdma == 1) ||(pCoexDm->curPsTdma == 2)) ) {
				halbtc8192e1ant_PsTdma(pBtCoexist, NORMAL_EXEC, TRUE, 9);
				pCoexDm->psTdmaDuAdjType = 9;
			} else if(pCoexDm->curPsTdma == 11) {
				halbtc8192e1ant_PsTdma(pBtCoexist, NORMAL_EXEC, TRUE, 9);
				pCoexDm->psTdmaDuAdjType = 9;
			} else if(pCoexDm->curPsTdma == 9) {
				halbtc8192e1ant_PsTdma(pBtCoexist, NORMAL_EXEC, TRUE, 2);
				pCoexDm->psTdmaDuAdjType = 2;
			} else if(pCoexDm->curPsTdma == 2) {
				halbtc8192e1ant_PsTdma(pBtCoexist, NORMAL_EXEC, TRUE, 1);
				pCoexDm->psTdmaDuAdjType = 1;
			}
		}

		if( pCoexDm->curPsTdma != 1 &&
		    pCoexDm->curPsTdma != 2 &&
		    pCoexDm->curPsTdma != 9 &&
		    pCoexDm->curPsTdma != 11 ) {
			// recover to previous adjust type
			halbtc8192e1ant_PsTdma(pBtCoexist, NORMAL_EXEC, TRUE, pCoexDm->psTdmaDuAdjType);
		}
	}
}

u1Byte
halbtc8192e1ant_PsTdmaTypeByWifiRssi(
    IN	s4Byte	wifiRssi,
    IN	s4Byte	preWifiRssi,
    IN	u1Byte	wifiRssiThresh
)
{
	u1Byte	psTdmaType=0;

	if(wifiRssi > preWifiRssi) {
		if(wifiRssi > (wifiRssiThresh+5)) {
			psTdmaType = 26;
		} else {
			psTdmaType = 25;
		}
	} else {
		if(wifiRssi > wifiRssiThresh) {
			psTdmaType = 26;
		} else {
			psTdmaType = 25;
		}
	}

	return psTdmaType;
}

VOID
halbtc8192e1ant_PsTdmaCheckForPowerSaveState(
    IN	PBTC_COEXIST		pBtCoexist,
    IN	BOOLEAN			bNewPsState
)
{
	u1Byte	lpsMode=0x0;

	pBtCoexist->fBtcGet(pBtCoexist, BTC_GET_U1_LPS_MODE, &lpsMode);

	if(lpsMode) {	// already under LPS state
		if(bNewPsState) {
			// keep state under LPS, do nothing.
		} else {
			// will leave LPS state, turn off psTdma first
			halbtc8192e1ant_PsTdma(pBtCoexist, NORMAL_EXEC, FALSE, 0);
		}
	} else {					// NO PS state
		if(bNewPsState) {
			// will enter LPS state, turn off psTdma first
			halbtc8192e1ant_PsTdma(pBtCoexist, NORMAL_EXEC, FALSE, 0);
		} else {
			// keep state under NO PS state, do nothing.
		}
	}
}

VOID
halbtc8192e1ant_PowerSaveState(
    IN	PBTC_COEXIST		pBtCoexist,
    IN	u1Byte				psType,
    IN	u1Byte				lpsVal,
    IN	u1Byte				rpwmVal
)
{
	BOOLEAN		bLowPwrDisable=FALSE;

	switch(psType) {
	case BTC_PS_WIFI_NATIVE:
		// recover to original 32k low power setting
		bLowPwrDisable = FALSE;
		pBtCoexist->fBtcSet(pBtCoexist, BTC_SET_ACT_DISABLE_LOW_POWER, &bLowPwrDisable);
		pBtCoexist->fBtcSet(pBtCoexist, BTC_SET_ACT_NORMAL_LPS, NULL);
		break;
	case BTC_PS_LPS_ON:
		halbtc8192e1ant_PsTdmaCheckForPowerSaveState(pBtCoexist, TRUE);
		halbtc8192e1ant_LpsRpwm(pBtCoexist, NORMAL_EXEC, lpsVal, rpwmVal);
		// when coex force to enter LPS, do not enter 32k low power.
		bLowPwrDisable = TRUE;
		pBtCoexist->fBtcSet(pBtCoexist, BTC_SET_ACT_DISABLE_LOW_POWER, &bLowPwrDisable);
		// power save must executed before psTdma.
		pBtCoexist->fBtcSet(pBtCoexist, BTC_SET_ACT_ENTER_LPS, NULL);
		break;
	case BTC_PS_LPS_OFF:
		halbtc8192e1ant_PsTdmaCheckForPowerSaveState(pBtCoexist, FALSE);
		pBtCoexist->fBtcSet(pBtCoexist, BTC_SET_ACT_LEAVE_LPS, NULL);
		break;
	default:
		break;
	}
}


VOID
halbtc8192e1ant_ActionWifiOnly(
    IN	PBTC_COEXIST		pBtCoexist
)
{
	halbtc8192e1ant_CoexTableWithType(pBtCoexist, NORMAL_EXEC, 0);
	halbtc8192e1ant_PsTdma(pBtCoexist, NORMAL_EXEC, FALSE, 9);
}

VOID
halbtc8192e1ant_MonitorBtEnableDisable(
    IN 	PBTC_COEXIST		pBtCoexist
)
{
	static BOOLEAN	bPreBtDisabled=FALSE;
	static u4Byte		btDisableCnt=0;
	BOOLEAN			bBtActive=TRUE, bBtDisabled=FALSE;

	// This function check if bt is disabled

	if(	pCoexSta->highPriorityTx == 0 &&
	    pCoexSta->highPriorityRx == 0 &&
	    pCoexSta->lowPriorityTx == 0 &&
	    pCoexSta->lowPriorityRx == 0) {
		bBtActive = FALSE;
	}
	if(	pCoexSta->highPriorityTx == 0xffff &&
	    pCoexSta->highPriorityRx == 0xffff &&
	    pCoexSta->lowPriorityTx == 0xffff &&
	    pCoexSta->lowPriorityRx == 0xffff) {
		bBtActive = FALSE;
	}
	if(bBtActive) {
		btDisableCnt = 0;
		bBtDisabled = FALSE;
		pBtCoexist->fBtcSet(pBtCoexist, BTC_SET_BL_BT_DISABLE, &bBtDisabled);
		BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_BT_MONITOR, ("[BTCoex], BT is enabled !!\n"));
	} else {
		btDisableCnt++;
		BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_BT_MONITOR, ("[BTCoex], bt all counters=0, %d times!!\n",
		          btDisableCnt));
		if(btDisableCnt >= 2) {
			bBtDisabled = TRUE;
			pBtCoexist->fBtcSet(pBtCoexist, BTC_SET_BL_BT_DISABLE, &bBtDisabled);
			BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_BT_MONITOR, ("[BTCoex], BT is disabled !!\n"));
			halbtc8192e1ant_ActionWifiOnly(pBtCoexist);
		}
	}
	if(bPreBtDisabled != bBtDisabled) {
		BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_BT_MONITOR, ("[BTCoex], BT is from %s to %s!!\n",
		          (bPreBtDisabled ? "disabled":"enabled"),
		          (bBtDisabled ? "disabled":"enabled")));
		bPreBtDisabled = bBtDisabled;
		if(!bBtDisabled) {
		} else {
			pBtCoexist->fBtcSet(pBtCoexist, BTC_SET_ACT_LEAVE_LPS, NULL);
			pBtCoexist->fBtcSet(pBtCoexist, BTC_SET_ACT_NORMAL_LPS, NULL);
		}
	}
}

//=============================================
//
//	Software Coex Mechanism start
//
//=============================================

// SCO only or SCO+PAN(HS)
VOID
halbtc8192e1ant_ActionSco(
    IN	PBTC_COEXIST		pBtCoexist
)
{
}

VOID
halbtc8192e1ant_ActionHid(
    IN	PBTC_COEXIST		pBtCoexist
)
{
}

//A2DP only / PAN(EDR) only/ A2DP+PAN(HS)
VOID
halbtc8192e1ant_ActionA2dp(
    IN	PBTC_COEXIST		pBtCoexist
)
{
}

VOID
halbtc8192e1ant_ActionA2dpPanHs(
    IN	PBTC_COEXIST		pBtCoexist
)
{
}

VOID
halbtc8192e1ant_ActionPanEdr(
    IN	PBTC_COEXIST		pBtCoexist
)
{
}

//PAN(HS) only
VOID
halbtc8192e1ant_ActionPanHs(
    IN	PBTC_COEXIST		pBtCoexist
)
{
}

//PAN(EDR)+A2DP
VOID
halbtc8192e1ant_ActionPanEdrA2dp(
    IN	PBTC_COEXIST		pBtCoexist
)
{
}

VOID
halbtc8192e1ant_ActionPanEdrHid(
    IN	PBTC_COEXIST		pBtCoexist
)
{
}

// HID+A2DP+PAN(EDR)
VOID
halbtc8192e1ant_ActionHidA2dpPanEdr(
    IN	PBTC_COEXIST		pBtCoexist
)
{
}

VOID
halbtc8192e1ant_ActionHidA2dp(
    IN	PBTC_COEXIST		pBtCoexist
)
{
}

//=============================================
//
//	Non-Software Coex Mechanism start
//
//=============================================
VOID
halbtc8192e1ant_ActionBtInquiry(
    IN	PBTC_COEXIST		pBtCoexist
)
{
	PBTC_BT_LINK_INFO	pBtLinkInfo=&pBtCoexist->btLinkInfo;
	BOOLEAN				bWifiConnected=FALSE, bBtHsOn=FALSE;

	// Note:
	// Do not do DacSwing here, use original setting.

	pBtCoexist->fBtcGet(pBtCoexist, BTC_GET_BL_WIFI_CONNECTED, &bWifiConnected);

	pBtCoexist->fBtcGet(pBtCoexist, BTC_GET_BL_HS_OPERATION, &bBtHsOn);
	if(bBtHsOn)
		return;

	if(!bWifiConnected) {
		halbtc8192e1ant_PowerSaveState(pBtCoexist, BTC_PS_WIFI_NATIVE, 0x0, 0x0);

		halbtc8192e1ant_DecBtPwr(pBtCoexist, NORMAL_EXEC, 0);

		halbtc8192e1ant_PsTdma(pBtCoexist, NORMAL_EXEC, FALSE, 8);
		halbtc8192e1ant_CoexTableWithType(pBtCoexist, NORMAL_EXEC, 0);
	} else if( (pBtLinkInfo->bScoExist) ||
	           (pBtLinkInfo->bHidOnly) ) {
		// SCO/HID-only busy
		halbtc8192e1ant_PowerSaveState(pBtCoexist, BTC_PS_WIFI_NATIVE, 0x0, 0x0);

		halbtc8192e1ant_DecBtPwr(pBtCoexist, NORMAL_EXEC, 0);

		halbtc8192e1ant_PsTdma(pBtCoexist, NORMAL_EXEC, TRUE, 32);
		halbtc8192e1ant_CoexTableWithType(pBtCoexist, NORMAL_EXEC, 1);
	} else {
		halbtc8192e1ant_PowerSaveState(pBtCoexist, BTC_PS_LPS_ON, 0x50, 0x0);

		halbtc8192e1ant_DecBtPwr(pBtCoexist, NORMAL_EXEC, 0);

		halbtc8192e1ant_PsTdma(pBtCoexist, NORMAL_EXEC, TRUE, 30);
		halbtc8192e1ant_CoexTableWithType(pBtCoexist, NORMAL_EXEC, 0);
	}
}

VOID
halbtc8192e1ant_ActionBtScoHidOnlyBusy(
    IN	PBTC_COEXIST		pBtCoexist,
    IN	u1Byte				wifiStatus
)
{
	PBTC_BT_LINK_INFO pBtLinkInfo=&pBtCoexist->btLinkInfo;
	u1Byte		btRssiState=BTC_RSSI_STATE_HIGH;

	if(BT_8192E_1ANT_WIFI_STATUS_NON_CONNECTED_ASSO_AUTH_SCAN == wifiStatus) {
		halbtc8192e1ant_DecBtPwr(pBtCoexist, NORMAL_EXEC, 0);
		halbtc8192e1ant_DacSwing(pBtCoexist, NORMAL_EXEC, FALSE, 0);

		halbtc8192e1ant_PsTdma(pBtCoexist, NORMAL_EXEC, FALSE, 8);
		halbtc8192e1ant_CoexTableWithType(pBtCoexist, NORMAL_EXEC, 0);
	} else {
		if(pBtLinkInfo->bHidOnly) {
			halbtc8192e1ant_DecBtPwr(pBtCoexist, NORMAL_EXEC, 0);
			halbtc8192e1ant_DacSwing(pBtCoexist, NORMAL_EXEC, FALSE, 0);

			halbtc8192e1ant_PsTdma(pBtCoexist, NORMAL_EXEC, FALSE, 8);
			halbtc8192e1ant_CoexTableWithType(pBtCoexist, NORMAL_EXEC, 2);
		} else {
			// dec bt power for diff level
			btRssiState = halbtc8192e1ant_BtRssiState(3, 34, 42);
			if( (btRssiState == BTC_RSSI_STATE_LOW) ||
			    (btRssiState == BTC_RSSI_STATE_STAY_LOW) ) {
				halbtc8192e1ant_DecBtPwr(pBtCoexist, NORMAL_EXEC, 0);
			} else if( (btRssiState == BTC_RSSI_STATE_MEDIUM) ||
			           (btRssiState == BTC_RSSI_STATE_STAY_MEDIUM) ) {
				halbtc8192e1ant_DecBtPwr(pBtCoexist, NORMAL_EXEC, 2);
			} else if( (btRssiState == BTC_RSSI_STATE_HIGH) ||
			           (btRssiState == BTC_RSSI_STATE_STAY_HIGH) ) {
				halbtc8192e1ant_DecBtPwr(pBtCoexist, NORMAL_EXEC, 6);
			}

			// sw dacSwing
			halbtc8192e1ant_DacSwing(pBtCoexist, NORMAL_EXEC, TRUE, 0xc);

			halbtc8192e1ant_PsTdma(pBtCoexist, NORMAL_EXEC, FALSE, 0);
			halbtc8192e1ant_CoexTableWithType(pBtCoexist, NORMAL_EXEC, 7);
		}
	}
}

VOID
halbtc8192e1ant_ActionHs(
    IN	PBTC_COEXIST		pBtCoexist
)
{
	//PBTC_BT_LINK_INFO pBtLinkInfo=&pBtCoexist->btLinkInfo;

	BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], Action for HS!!!\n"));

	halbtc8192e1ant_PowerSaveState(pBtCoexist, BTC_PS_WIFI_NATIVE, 0x0, 0x0);

	if(BT_8192E_1ANT_BT_STATUS_NON_CONNECTED_IDLE == pCoexDm->btStatus) {
		// error, should not be here
		pCoexDm->errorCondition = 1;
	} else if(BT_8192E_1ANT_BT_STATUS_CONNECTED_IDLE == pCoexDm->btStatus) {
		halbtc8192e1ant_DecBtPwr(pBtCoexist, NORMAL_EXEC, 0);
		halbtc8192e1ant_DacSwing(pBtCoexist, NORMAL_EXEC, TRUE, 6);

		halbtc8192e1ant_PsTdma(pBtCoexist, NORMAL_EXEC, FALSE, 10);
		halbtc8192e1ant_CoexTableWithType(pBtCoexist, NORMAL_EXEC, 0);
	} else if(BT_8192E_1ANT_BT_STATUS_ACL_BUSY == pCoexDm->btStatus &&
	          !pBtCoexist->btLinkInfo.bHidOnly) {
		if(pCoexDm->curSsType == 1) {
			halbtc8192e1ant_DecBtPwr(pBtCoexist, NORMAL_EXEC, 0);
			halbtc8192e1ant_DacSwing(pBtCoexist, NORMAL_EXEC, TRUE, 6);
			halbtc8192e1ant_PsTdma(pBtCoexist, NORMAL_EXEC, FALSE, 10);
			halbtc8192e1ant_CoexTableWithType(pBtCoexist, NORMAL_EXEC, 0);
		}
	} else {
		halbtc8192e1ant_ActionBtScoHidOnlyBusy(pBtCoexist,
		                                       BT_8192E_1ANT_WIFI_STATUS_CONNECTED_BUSY);
	}
}

VOID
halbtc8192e1ant_ActionWifiConnectedBtAclBusy(
    IN	PBTC_COEXIST		pBtCoexist,
    IN	u1Byte				wifiStatus
)
{
	PBTC_BT_LINK_INFO pBtLinkInfo=&pBtCoexist->btLinkInfo;

	if(pBtLinkInfo->bHidOnly) {
		halbtc8192e1ant_ActionBtScoHidOnlyBusy(pBtCoexist, wifiStatus);
		pCoexDm->bAutoTdmaAdjust = FALSE;
		return;
	}

	halbtc8192e1ant_DecBtPwr(pBtCoexist, NORMAL_EXEC, 0);
	halbtc8192e1ant_DacSwing(pBtCoexist, NORMAL_EXEC, FALSE, 0);

	if( (pBtLinkInfo->bA2dpOnly) ||
	    (pBtLinkInfo->bHidExist&&pBtLinkInfo->bA2dpExist) ) {
		halbtc8192e1ant_TdmaDurationAdjustForAcl(pBtCoexist, wifiStatus);
	} else if( (pBtLinkInfo->bPanOnly) ||
	           (pBtLinkInfo->bHidExist&&pBtLinkInfo->bPanExist) ) {
		halbtc8192e1ant_PsTdma(pBtCoexist, NORMAL_EXEC, TRUE, 3);
		pCoexDm->bAutoTdmaAdjust = FALSE;
	} else {
		if( (BT_8192E_1ANT_WIFI_STATUS_NON_CONNECTED_ASSO_AUTH_SCAN == wifiStatus) ||
		    (BT_8192E_1ANT_WIFI_STATUS_CONNECTED_SCAN == wifiStatus) ||
		    (BT_8192E_1ANT_WIFI_STATUS_CONNECTED_SPECIAL_PKT == wifiStatus) )
			halbtc8192e1ant_PsTdma(pBtCoexist, NORMAL_EXEC, TRUE, 9);
		else
			halbtc8192e1ant_PsTdma(pBtCoexist, NORMAL_EXEC, TRUE, 11);
		pCoexDm->bAutoTdmaAdjust = FALSE;
	}

	halbtc8192e1ant_CoexTableWithType(pBtCoexist, NORMAL_EXEC, 1);
}


VOID
halbtc8192e1ant_ActionWifiNotConnected(
    IN	PBTC_COEXIST		pBtCoexist
)
{
	// power save state
	halbtc8192e1ant_PowerSaveState(pBtCoexist, BTC_PS_WIFI_NATIVE, 0x0, 0x0);

	halbtc8192e1ant_DecBtPwr(pBtCoexist, NORMAL_EXEC, 0);
	halbtc8192e1ant_DacSwing(pBtCoexist, NORMAL_EXEC, FALSE, 0);

	halbtc8192e1ant_PsTdma(pBtCoexist, NORMAL_EXEC, FALSE, 8);
	halbtc8192e1ant_CoexTableWithType(pBtCoexist, NORMAL_EXEC, 0);
}

VOID
halbtc8192e1ant_ActionWifiNotConnectedAssoAuthScan(
    IN	PBTC_COEXIST		pBtCoexist
)
{
	halbtc8192e1ant_PowerSaveState(pBtCoexist, BTC_PS_WIFI_NATIVE, 0x0, 0x0);

	halbtc8192e1ant_DecBtPwr(pBtCoexist, NORMAL_EXEC, 0);
	halbtc8192e1ant_DacSwing(pBtCoexist, NORMAL_EXEC, FALSE, 0);

	halbtc8192e1ant_PsTdma(pBtCoexist, NORMAL_EXEC, FALSE, 8);
	halbtc8192e1ant_CoexTableWithType(pBtCoexist, NORMAL_EXEC, 0);
}

VOID
halbtc8192e1ant_ActionWifiConnectedScan(
    IN	PBTC_COEXIST		pBtCoexist
)
{
	// power save state
	if(BT_8192E_1ANT_BT_STATUS_ACL_BUSY == pCoexDm->btStatus && !pBtCoexist->btLinkInfo.bHidOnly)
		halbtc8192e1ant_PowerSaveState(pBtCoexist, BTC_PS_LPS_ON, 0x50, 0x0);
	else
		halbtc8192e1ant_PowerSaveState(pBtCoexist, BTC_PS_WIFI_NATIVE, 0x0, 0x0);

	if(BT_8192E_1ANT_BT_STATUS_ACL_BUSY == pCoexDm->btStatus) {
		halbtc8192e1ant_ActionWifiConnectedBtAclBusy(pBtCoexist,
		        BT_8192E_1ANT_WIFI_STATUS_CONNECTED_SCAN);
	} else if( (BT_8192E_1ANT_BT_STATUS_SCO_BUSY == pCoexDm->btStatus) ||
	           (BT_8192E_1ANT_BT_STATUS_ACL_SCO_BUSY == pCoexDm->btStatus) ) {
		halbtc8192e1ant_ActionBtScoHidOnlyBusy(pBtCoexist,
		                                       BT_8192E_1ANT_WIFI_STATUS_CONNECTED_SCAN);
	} else {
		halbtc8192e1ant_DecBtPwr(pBtCoexist, NORMAL_EXEC, 0);
		halbtc8192e1ant_DacSwing(pBtCoexist, NORMAL_EXEC, FALSE, 0);
		halbtc8192e1ant_PsTdma(pBtCoexist, NORMAL_EXEC, FALSE, 8);
		halbtc8192e1ant_CoexTableWithType(pBtCoexist, NORMAL_EXEC, 2);
	}
}


VOID
halbtc8192e1ant_ActionWifiConnectedSpecialPacket(
    IN	PBTC_COEXIST		pBtCoexist
)
{
	// power save state
	if(BT_8192E_1ANT_BT_STATUS_ACL_BUSY == pCoexDm->btStatus && !pBtCoexist->btLinkInfo.bHidOnly)
		halbtc8192e1ant_PowerSaveState(pBtCoexist, BTC_PS_LPS_ON, 0x50, 0x0);
	else
		halbtc8192e1ant_PowerSaveState(pBtCoexist, BTC_PS_WIFI_NATIVE, 0x0, 0x0);

	if(BT_8192E_1ANT_BT_STATUS_ACL_BUSY == pCoexDm->btStatus) {
		halbtc8192e1ant_ActionWifiConnectedBtAclBusy(pBtCoexist,
		        BT_8192E_1ANT_WIFI_STATUS_CONNECTED_SPECIAL_PKT);
	} else {
		halbtc8192e1ant_DecBtPwr(pBtCoexist, NORMAL_EXEC, 0);
		halbtc8192e1ant_DacSwing(pBtCoexist, NORMAL_EXEC, FALSE, 0);
		halbtc8192e1ant_PsTdma(pBtCoexist, NORMAL_EXEC, FALSE, 8);
		halbtc8192e1ant_CoexTableWithType(pBtCoexist, NORMAL_EXEC, 2);
	}
}

VOID
halbtc8192e1ant_ActionWifiConnected(
    IN	PBTC_COEXIST		pBtCoexist
)
{
	BOOLEAN 	bWifiConnected=FALSE, bWifiBusy=FALSE;
	BOOLEAN 	bScan=FALSE, bLink=FALSE, bRoam=FALSE;
	BOOLEAN 	bUnder4way=FALSE;
	//u4Byte		wifiBw;

	BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], CoexForWifiConnect()===>\n"));

	pBtCoexist->fBtcGet(pBtCoexist, BTC_GET_BL_WIFI_CONNECTED, &bWifiConnected);
	if(!bWifiConnected) {
		BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], CoexForWifiConnect(), return for wifi not connected<===\n"));
		return;
	}

	pBtCoexist->fBtcGet(pBtCoexist, BTC_GET_BL_WIFI_4_WAY_PROGRESS, &bUnder4way);
	if(bUnder4way) {
		halbtc8192e1ant_ActionWifiConnectedSpecialPacket(pBtCoexist);
		BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], CoexForWifiConnect(), return for wifi is under 4way<===\n"));
		return;
	}

	pBtCoexist->fBtcGet(pBtCoexist, BTC_GET_BL_WIFI_SCAN, &bScan);
	pBtCoexist->fBtcGet(pBtCoexist, BTC_GET_BL_WIFI_LINK, &bLink);
	pBtCoexist->fBtcGet(pBtCoexist, BTC_GET_BL_WIFI_ROAM, &bRoam);
	if(bScan || bLink || bRoam) {
		halbtc8192e1ant_ActionWifiConnectedScan(pBtCoexist);
		BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], CoexForWifiConnect(), return for wifi is under scan<===\n"));
		return;
	}

	// power save state
	if(BT_8192E_1ANT_BT_STATUS_ACL_BUSY == pCoexDm->btStatus && !pBtCoexist->btLinkInfo.bHidOnly)
		halbtc8192e1ant_PowerSaveState(pBtCoexist, BTC_PS_LPS_ON, 0x50, 0x0);
	else
		halbtc8192e1ant_PowerSaveState(pBtCoexist, BTC_PS_WIFI_NATIVE, 0x0, 0x0);

	pBtCoexist->fBtcGet(pBtCoexist, BTC_GET_BL_WIFI_BUSY, &bWifiBusy);
	if(!bWifiBusy) {
		if(BT_8192E_1ANT_BT_STATUS_ACL_BUSY == pCoexDm->btStatus) {
			halbtc8192e1ant_ActionWifiConnectedBtAclBusy(pBtCoexist,
			        BT_8192E_1ANT_WIFI_STATUS_CONNECTED_IDLE);
		} else if( (BT_8192E_1ANT_BT_STATUS_SCO_BUSY == pCoexDm->btStatus) ||
		           (BT_8192E_1ANT_BT_STATUS_ACL_SCO_BUSY == pCoexDm->btStatus) ) {
			halbtc8192e1ant_ActionBtScoHidOnlyBusy(pBtCoexist,
			                                       BT_8192E_1ANT_WIFI_STATUS_CONNECTED_IDLE);
		} else {
			halbtc8192e1ant_DecBtPwr(pBtCoexist, NORMAL_EXEC, 0);
			halbtc8192e1ant_DacSwing(pBtCoexist, NORMAL_EXEC, FALSE, 0);
			halbtc8192e1ant_PsTdma(pBtCoexist, NORMAL_EXEC, FALSE, 8);
			halbtc8192e1ant_CoexTableWithType(pBtCoexist, NORMAL_EXEC, 2);
		}
	} else {
		if(BT_8192E_1ANT_BT_STATUS_NON_CONNECTED_IDLE == pCoexDm->btStatus) {
			halbtc8192e1ant_DecBtPwr(pBtCoexist, NORMAL_EXEC, 0);
			halbtc8192e1ant_DacSwing(pBtCoexist, NORMAL_EXEC, FALSE, 0);
			halbtc8192e1ant_PsTdma(pBtCoexist, NORMAL_EXEC, TRUE, 5);
			halbtc8192e1ant_CoexTableWithType(pBtCoexist, NORMAL_EXEC, 2);
		} else if(BT_8192E_1ANT_BT_STATUS_CONNECTED_IDLE == pCoexDm->btStatus) {
			halbtc8192e1ant_DecBtPwr(pBtCoexist, NORMAL_EXEC, 0);
			halbtc8192e1ant_DacSwing(pBtCoexist, NORMAL_EXEC, FALSE, 0);
			halbtc8192e1ant_PsTdma(pBtCoexist, NORMAL_EXEC, TRUE, 5);
			halbtc8192e1ant_CoexTableWithType(pBtCoexist, NORMAL_EXEC, 2);
		} else if(BT_8192E_1ANT_BT_STATUS_ACL_BUSY == pCoexDm->btStatus) {
			halbtc8192e1ant_ActionWifiConnectedBtAclBusy(pBtCoexist,
			        BT_8192E_1ANT_WIFI_STATUS_CONNECTED_BUSY);
		} else if( (BT_8192E_1ANT_BT_STATUS_SCO_BUSY == pCoexDm->btStatus) ||
		           (BT_8192E_1ANT_BT_STATUS_ACL_SCO_BUSY == pCoexDm->btStatus) ) {
			halbtc8192e1ant_ActionBtScoHidOnlyBusy(pBtCoexist,
			                                       BT_8192E_1ANT_WIFI_STATUS_CONNECTED_BUSY);
		} else {
			halbtc8192e1ant_DecBtPwr(pBtCoexist, NORMAL_EXEC, 0);
			halbtc8192e1ant_DacSwing(pBtCoexist, NORMAL_EXEC, FALSE, 0);
			halbtc8192e1ant_PsTdma(pBtCoexist, NORMAL_EXEC, FALSE, 8);
			halbtc8192e1ant_CoexTableWithType(pBtCoexist, NORMAL_EXEC, 2);
		}
	}
}

VOID
halbtc8192e1ant_RunSwCoexistMechanism(
    IN	PBTC_COEXIST		pBtCoexist
)
{
	//BOOLEAN				bWifiUnder5G=FALSE, bWifiBusy=FALSE, bWifiConnected=FALSE;
	//u1Byte				btInfoOriginal=0, btRetryCnt=0;
	u1Byte				algorithm=0;

	return;

	algorithm = halbtc8192e1ant_ActionAlgorithm(pBtCoexist);
	pCoexDm->curAlgorithm = algorithm;

	if(halbtc8192e1ant_IsCommonAction(pBtCoexist)) {
	} else {
		switch(pCoexDm->curAlgorithm) {
		case BT_8192E_1ANT_COEX_ALGO_SCO:
			BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], Action algorithm = SCO.\n"));
			halbtc8192e1ant_ActionSco(pBtCoexist);
			break;
		case BT_8192E_1ANT_COEX_ALGO_HID:
			BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], Action algorithm = HID.\n"));
			halbtc8192e1ant_ActionHid(pBtCoexist);
			break;
		case BT_8192E_1ANT_COEX_ALGO_A2DP:
			BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], Action algorithm = A2DP.\n"));
			halbtc8192e1ant_ActionA2dp(pBtCoexist);
			break;
		case BT_8192E_1ANT_COEX_ALGO_A2DP_PANHS:
			BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], Action algorithm = A2DP+PAN(HS).\n"));
			halbtc8192e1ant_ActionA2dpPanHs(pBtCoexist);
			break;
		case BT_8192E_1ANT_COEX_ALGO_PANEDR:
			BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], Action algorithm = PAN(EDR).\n"));
			halbtc8192e1ant_ActionPanEdr(pBtCoexist);
			break;
		case BT_8192E_1ANT_COEX_ALGO_PANHS:
			BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], Action algorithm = HS mode.\n"));
			halbtc8192e1ant_ActionPanHs(pBtCoexist);
			break;
		case BT_8192E_1ANT_COEX_ALGO_PANEDR_A2DP:
			BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], Action algorithm = PAN+A2DP.\n"));
			halbtc8192e1ant_ActionPanEdrA2dp(pBtCoexist);
			break;
		case BT_8192E_1ANT_COEX_ALGO_PANEDR_HID:
			BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], Action algorithm = PAN(EDR)+HID.\n"));
			halbtc8192e1ant_ActionPanEdrHid(pBtCoexist);
			break;
		case BT_8192E_1ANT_COEX_ALGO_HID_A2DP_PANEDR:
			BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], Action algorithm = HID+A2DP+PAN.\n"));
			halbtc8192e1ant_ActionHidA2dpPanEdr(pBtCoexist);
			break;
		case BT_8192E_1ANT_COEX_ALGO_HID_A2DP:
			BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], Action algorithm = HID+A2DP.\n"));
			halbtc8192e1ant_ActionHidA2dp(pBtCoexist);
			break;
		default:
			BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], Action algorithm = coexist All Off!!\n"));
			halbtc8192e1ant_CoexAllOff(pBtCoexist);
			break;
		}
		pCoexDm->preAlgorithm = pCoexDm->curAlgorithm;
	}
}

VOID
halbtc8192e1ant_RunCoexistMechanism(
    IN	PBTC_COEXIST		pBtCoexist
)
{
	PBTC_BT_LINK_INFO	pBtLinkInfo=&pBtCoexist->btLinkInfo;
	BOOLEAN	bWifiConnected=FALSE, bBtHsOn=FALSE;

	BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], RunCoexistMechanism()===>\n"));

	if(pBtCoexist->bManualControl) {
		BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], RunCoexistMechanism(), return for Manual CTRL <===\n"));
		return;
	}

	if(pBtCoexist->bStopCoexDm) {
		BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], RunCoexistMechanism(), return for Stop Coex DM <===\n"));
		return;
	}

	if(pCoexSta->bUnderIps) {
		BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], wifi is under IPS !!!\n"));
		return;
	}

	halbtc8192e1ant_RunSwCoexistMechanism(pBtCoexist);

	pBtCoexist->fBtcGet(pBtCoexist, BTC_GET_BL_HS_OPERATION, &bBtHsOn);
	if(pCoexSta->bC2hBtInquiryPage) {
		halbtc8192e1ant_ActionBtInquiry(pBtCoexist);
		return;
	}

	// 1ss or 2ss
	if(pBtLinkInfo->bScoExist) {
		halbtc8192e1ant_SwitchSsType(pBtCoexist, NORMAL_EXEC, 1);
	} else if(bBtHsOn) {
		if(pBtLinkInfo->bHidOnly)
			halbtc8192e1ant_SwitchSsType(pBtCoexist, NORMAL_EXEC, 2);
		else
			halbtc8192e1ant_SwitchSsType(pBtCoexist, NORMAL_EXEC, 1);
	} else
		halbtc8192e1ant_SwitchSsType(pBtCoexist, NORMAL_EXEC, 2);

	if(bBtHsOn) {
		halbtc8192e1ant_ActionHs(pBtCoexist);
		return;
	}

	pBtCoexist->fBtcGet(pBtCoexist, BTC_GET_BL_WIFI_CONNECTED, &bWifiConnected);
	if(!bWifiConnected) {
		BOOLEAN	bScan=FALSE, bLink=FALSE, bRoam=FALSE;

		BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], wifi is non connected-idle !!!\n"));

		pBtCoexist->fBtcGet(pBtCoexist, BTC_GET_BL_WIFI_SCAN, &bScan);
		pBtCoexist->fBtcGet(pBtCoexist, BTC_GET_BL_WIFI_LINK, &bLink);
		pBtCoexist->fBtcGet(pBtCoexist, BTC_GET_BL_WIFI_ROAM, &bRoam);

		if(bScan || bLink || bRoam)
			halbtc8192e1ant_ActionWifiNotConnectedAssoAuthScan(pBtCoexist);
		else
			halbtc8192e1ant_ActionWifiNotConnected(pBtCoexist);
	} else {
		halbtc8192e1ant_ActionWifiConnected(pBtCoexist);
	}
}

VOID
halbtc8192e1ant_InitCoexDm(
    IN	PBTC_COEXIST		pBtCoexist
)
{
	// force to reset coex mechanism
	halbtc8192e1ant_FwDacSwingLvl(pBtCoexist, FORCE_EXEC, 6);
	halbtc8192e1ant_DecBtPwr(pBtCoexist, FORCE_EXEC, 0);

	halbtc8192e1ant_SwitchSsType(pBtCoexist, FORCE_EXEC, 2);

	halbtc8192e1ant_PsTdma(pBtCoexist, FORCE_EXEC, FALSE, 8);
	halbtc8192e1ant_CoexTableWithType(pBtCoexist, FORCE_EXEC, 0);
}

//============================================================
// work around function start with wa_halbtc8192e1ant_
//============================================================
//============================================================
// extern function start with EXhalbtc8192e1ant_
//============================================================
VOID
EXhalbtc8192e1ant_PowerOnSetting(
    IN	PBTC_COEXIST		pBtCoexist
)
{
}

VOID
EXhalbtc8192e1ant_InitHwConfig(
    IN	PBTC_COEXIST		pBtCoexist,
    IN	BOOLEAN				bWifiOnly
)
{
	//u4Byte	u4Tmp=0;
	u2Byte	u2Tmp=0;
	u1Byte	u1Tmp=0;

	BTC_PRINT(BTC_MSG_INTERFACE, INTF_INIT, ("[BTCoex], 1Ant Init HW Config!!\n"));

	// antenna sw ctrl to bt
	halbtc8192e1ant_SetAntPath(pBtCoexist, BTC_ANT_PATH_BT, TRUE, FALSE);

	halbtc8192e1ant_CoexTableWithType(pBtCoexist, FORCE_EXEC, 0);

	// antenna switch control parameter
	pBtCoexist->fBtcWrite4Byte(pBtCoexist, 0x858, 0x55555555);

	// coex parameters
	pBtCoexist->fBtcWrite1Byte(pBtCoexist, 0x778, 0x1);
	// 0x790[5:0]=0x5
	u1Tmp = pBtCoexist->fBtcRead1Byte(pBtCoexist, 0x790);
	u1Tmp &= 0xc0;
	u1Tmp |= 0x5;
	pBtCoexist->fBtcWrite1Byte(pBtCoexist, 0x790, u1Tmp);

	// enable counter statistics
	pBtCoexist->fBtcWrite1Byte(pBtCoexist, 0x76e, 0x4);

	// enable PTA
	pBtCoexist->fBtcWrite1Byte(pBtCoexist, 0x40, 0x20);
	// enable mailbox interface
	u2Tmp = pBtCoexist->fBtcRead2Byte(pBtCoexist, 0x40);
	u2Tmp |= BIT9;
	pBtCoexist->fBtcWrite2Byte(pBtCoexist, 0x40, u2Tmp);

	// enable PTA I2C mailbox
	u1Tmp = pBtCoexist->fBtcRead1Byte(pBtCoexist, 0x101);
	u1Tmp |= BIT4;
	pBtCoexist->fBtcWrite1Byte(pBtCoexist, 0x101, u1Tmp);

	// enable bt clock when wifi is disabled.
	u1Tmp = pBtCoexist->fBtcRead1Byte(pBtCoexist, 0x93);
	u1Tmp |= BIT0;
	pBtCoexist->fBtcWrite1Byte(pBtCoexist, 0x93, u1Tmp);
	// enable bt clock when suspend.
	u1Tmp = pBtCoexist->fBtcRead1Byte(pBtCoexist, 0x7);
	u1Tmp |= BIT0;
	pBtCoexist->fBtcWrite1Byte(pBtCoexist, 0x7, u1Tmp);
}

VOID
EXhalbtc8192e1ant_InitCoexDm(
    IN	PBTC_COEXIST		pBtCoexist
)
{
	BTC_PRINT(BTC_MSG_INTERFACE, INTF_INIT, ("[BTCoex], Coex Mechanism Init!!\n"));

	pBtCoexist->bStopCoexDm = FALSE;

	halbtc8192e1ant_InitCoexDm(pBtCoexist);
}

VOID
EXhalbtc8192e1ant_DisplayCoexInfo(
    IN	PBTC_COEXIST		pBtCoexist
)
{
	PBTC_BOARD_INFO		pBoardInfo=&pBtCoexist->boardInfo;
	PBTC_STACK_INFO		pStackInfo=&pBtCoexist->stackInfo;
	PBTC_BT_LINK_INFO	pBtLinkInfo=&pBtCoexist->btLinkInfo;
	pu1Byte				cliBuf=pBtCoexist->cliBuf;
	u1Byte				u1Tmp[4], i, btInfoExt, psTdmaCase=0;
	u4Byte				u4Tmp[4];
	u4Byte				fwVer=0, btPatchVer=0;

	CL_SPRINTF(cliBuf, BT_TMP_BUF_SIZE, "\r\n ============[BT Coexist info]============");
	CL_PRINTF(cliBuf);

	if(pBtCoexist->bManualControl) {
		CL_SPRINTF(cliBuf, BT_TMP_BUF_SIZE, "\r\n ============[Under Manual Control]============");
		CL_PRINTF(cliBuf);
		CL_SPRINTF(cliBuf, BT_TMP_BUF_SIZE, "\r\n ==========================================");
		CL_PRINTF(cliBuf);
	}
	if(pBtCoexist->bStopCoexDm) {
		CL_SPRINTF(cliBuf, BT_TMP_BUF_SIZE, "\r\n ============[Coex is STOPPED]============");
		CL_PRINTF(cliBuf);
		CL_SPRINTF(cliBuf, BT_TMP_BUF_SIZE, "\r\n ==========================================");
		CL_PRINTF(cliBuf);
	}

	CL_SPRINTF(cliBuf, BT_TMP_BUF_SIZE, "\r\n %-35s = %d/ %d ", "Ant PG number/ Ant mechanism:", \
	           pBoardInfo->pgAntNum, pBoardInfo->btdmAntNum);
	CL_PRINTF(cliBuf);

	CL_SPRINTF(cliBuf, BT_TMP_BUF_SIZE, "\r\n %-35s = %s / %d", "BT stack/ hci ext ver", \
	           ((pStackInfo->bProfileNotified)? "Yes":"No"), pStackInfo->hciVersion);
	CL_PRINTF(cliBuf);

	pBtCoexist->fBtcGet(pBtCoexist, BTC_GET_U4_BT_PATCH_VER, &btPatchVer);
	pBtCoexist->fBtcGet(pBtCoexist, BTC_GET_U4_WIFI_FW_VER, &fwVer);
	CL_SPRINTF(cliBuf, BT_TMP_BUF_SIZE, "\r\n %-35s = %d_%d/ 0x%x/ 0x%x(%d)", "CoexVer/ FwVer/ PatchVer", \
	           GLCoexVerDate8192e1Ant, GLCoexVer8192e1Ant, fwVer, btPatchVer, btPatchVer);
	CL_PRINTF(cliBuf);

	CL_SPRINTF(cliBuf, BT_TMP_BUF_SIZE, "\r\n %-35s = %02x %02x %02x ", "Wifi channel informed to BT", \
	           pCoexDm->wifiChnlInfo[0], pCoexDm->wifiChnlInfo[1],
	           pCoexDm->wifiChnlInfo[2]);
	CL_PRINTF(cliBuf);

	// wifi status
	CL_SPRINTF(cliBuf, BT_TMP_BUF_SIZE, "\r\n %-35s", "============[Wifi Status]============");
	CL_PRINTF(cliBuf);
	pBtCoexist->fBtcDispDbgMsg(pBtCoexist, BTC_DBG_DISP_WIFI_STATUS);

	CL_SPRINTF(cliBuf, BT_TMP_BUF_SIZE, "\r\n %-35s", "============[BT Status]============");
	CL_PRINTF(cliBuf);

	CL_SPRINTF(cliBuf, BT_TMP_BUF_SIZE, "\r\n %-35s = [%s/ %d/ %d] ", "BT [status/ rssi/ retryCnt]", \
	           ((pBtCoexist->btInfo.bBtDisabled)? ("disabled"):	((pCoexSta->bC2hBtInquiryPage)?("inquiry/page scan"):((BT_8192E_1ANT_BT_STATUS_NON_CONNECTED_IDLE == pCoexDm->btStatus)? "non-connected idle":
	                   (  (BT_8192E_1ANT_BT_STATUS_CONNECTED_IDLE == pCoexDm->btStatus)? "connected-idle":"busy")))),
	           pCoexSta->btRssi, pCoexSta->btRetryCnt);
	CL_PRINTF(cliBuf);

	CL_SPRINTF(cliBuf, BT_TMP_BUF_SIZE, "\r\n %-35s = %d / %d / %d / %d", "SCO/HID/PAN/A2DP", \
	           pBtLinkInfo->bScoExist, pBtLinkInfo->bHidExist, pBtLinkInfo->bPanExist, pBtLinkInfo->bA2dpExist);
	CL_PRINTF(cliBuf);
	pBtCoexist->fBtcDispDbgMsg(pBtCoexist, BTC_DBG_DISP_BT_LINK_INFO);

	btInfoExt = pCoexSta->btInfoExt;
	CL_SPRINTF(cliBuf, BT_TMP_BUF_SIZE, "\r\n %-35s = %s", "BT Info A2DP rate", \
	           (btInfoExt&BIT0)? "Basic rate":"EDR rate");
	CL_PRINTF(cliBuf);

	for(i=0; i<BT_INFO_SRC_8192E_1ANT_MAX; i++) {
		if(pCoexSta->btInfoC2hCnt[i]) {
			CL_SPRINTF(cliBuf, BT_TMP_BUF_SIZE, "\r\n %-35s = %02x %02x %02x %02x %02x %02x %02x(%d)", GLBtInfoSrc8192e1Ant[i], \
			           pCoexSta->btInfoC2h[i][0], pCoexSta->btInfoC2h[i][1],
			           pCoexSta->btInfoC2h[i][2], pCoexSta->btInfoC2h[i][3],
			           pCoexSta->btInfoC2h[i][4], pCoexSta->btInfoC2h[i][5],
			           pCoexSta->btInfoC2h[i][6], pCoexSta->btInfoC2hCnt[i]);
			CL_PRINTF(cliBuf);
		}
	}

	if(!pBtCoexist->bManualControl) {
		// Sw mechanism
		CL_SPRINTF(cliBuf, BT_TMP_BUF_SIZE, "\r\n %-35s", "============[Sw mechanism]============");
		CL_PRINTF(cliBuf);

		CL_SPRINTF(cliBuf, BT_TMP_BUF_SIZE, "\r\n %-35s = %s/ %s/ %d ", "DelBA/ BtCtrlAgg/ AggSize", \
		           (pBtCoexist->btInfo.bRejectAggPkt? "Yes":"No"), (pBtCoexist->btInfo.bBtCtrlAggBufSize? "Yes":"No"),
		           pBtCoexist->btInfo.aggBufSize);
		CL_PRINTF(cliBuf);
		CL_SPRINTF(cliBuf, BT_TMP_BUF_SIZE, "\r\n %-35s = 0x%x ", "Rate Mask", \
		           pBtCoexist->btInfo.raMask);
		CL_PRINTF(cliBuf);

		// Fw mechanism
		CL_SPRINTF(cliBuf, BT_TMP_BUF_SIZE, "\r\n %-35s", "============[Fw mechanism]============");
		CL_PRINTF(cliBuf);

		psTdmaCase = pCoexDm->curPsTdma;
		CL_SPRINTF(cliBuf, BT_TMP_BUF_SIZE, "\r\n %-35s = %02x %02x %02x %02x %02x case-%d (auto:%d)", "PS TDMA", \
		           pCoexDm->psTdmaPara[0], pCoexDm->psTdmaPara[1],
		           pCoexDm->psTdmaPara[2], pCoexDm->psTdmaPara[3],
		           pCoexDm->psTdmaPara[4], psTdmaCase, pCoexDm->bAutoTdmaAdjust);
		CL_PRINTF(cliBuf);

		CL_SPRINTF(cliBuf, BT_TMP_BUF_SIZE, "\r\n %-35s = 0x%x ", "Latest error condition(should be 0)", \
		           pCoexDm->errorCondition);
		CL_PRINTF(cliBuf);

		CL_SPRINTF(cliBuf, BT_TMP_BUF_SIZE, "\r\n %-35s = %d ", "IgnWlanAct", \
		           pCoexDm->bCurIgnoreWlanAct);
		CL_PRINTF(cliBuf);
	}

	// Hw setting
	CL_SPRINTF(cliBuf, BT_TMP_BUF_SIZE, "\r\n %-35s", "============[Hw setting]============");
	CL_PRINTF(cliBuf);

	u4Tmp[0] = pBtCoexist->fBtcRead4Byte(pBtCoexist, 0xc04);
	u4Tmp[1] = pBtCoexist->fBtcRead4Byte(pBtCoexist, 0xd04);
	u4Tmp[2] = pBtCoexist->fBtcRead4Byte(pBtCoexist, 0x90c);
	CL_SPRINTF(cliBuf, BT_TMP_BUF_SIZE, "\r\n %-35s = 0x%x/ 0x%x/ 0x%x", "0xc04/ 0xd04/ 0x90c", \
	           u4Tmp[0], u4Tmp[1], u4Tmp[2]);
	CL_PRINTF(cliBuf);

	u1Tmp[0] = pBtCoexist->fBtcRead1Byte(pBtCoexist, 0x778);
	CL_SPRINTF(cliBuf, BT_TMP_BUF_SIZE, "\r\n %-35s = 0x%x", "0x778", \
	           u1Tmp[0]);
	CL_PRINTF(cliBuf);

	u1Tmp[0] = pBtCoexist->fBtcRead1Byte(pBtCoexist, 0x92c);
	u4Tmp[0] = pBtCoexist->fBtcRead4Byte(pBtCoexist, 0x930);
	CL_SPRINTF(cliBuf, BT_TMP_BUF_SIZE, "\r\n %-35s = 0x%x/ 0x%x", "0x92c/ 0x930", \
	           (u1Tmp[0]), u4Tmp[0]);
	CL_PRINTF(cliBuf);

	u1Tmp[0] = pBtCoexist->fBtcRead1Byte(pBtCoexist, 0x40);
	u1Tmp[1] = pBtCoexist->fBtcRead1Byte(pBtCoexist, 0x4f);
	CL_SPRINTF(cliBuf, BT_TMP_BUF_SIZE, "\r\n %-35s = 0x%x/ 0x%x", "0x40/ 0x4f", \
	           u1Tmp[0], u1Tmp[1]);
	CL_PRINTF(cliBuf);

	u4Tmp[0] = pBtCoexist->fBtcRead4Byte(pBtCoexist, 0x550);
	u1Tmp[0] = pBtCoexist->fBtcRead1Byte(pBtCoexist, 0x522);
	CL_SPRINTF(cliBuf, BT_TMP_BUF_SIZE, "\r\n %-35s = 0x%x/ 0x%x", "0x550(bcn ctrl)/0x522", \
	           u4Tmp[0], u1Tmp[0]);
	CL_PRINTF(cliBuf);

	u4Tmp[0] = pBtCoexist->fBtcRead4Byte(pBtCoexist, 0xc50);
	CL_SPRINTF(cliBuf, BT_TMP_BUF_SIZE, "\r\n %-35s = 0x%x", "0xc50(dig)", \
	           u4Tmp[0]);
	CL_PRINTF(cliBuf);

	u4Tmp[0] = pBtCoexist->fBtcRead4Byte(pBtCoexist, 0x6c0);
	u4Tmp[1] = pBtCoexist->fBtcRead4Byte(pBtCoexist, 0x6c4);
	u4Tmp[2] = pBtCoexist->fBtcRead4Byte(pBtCoexist, 0x6c8);
	u1Tmp[0] = pBtCoexist->fBtcRead1Byte(pBtCoexist, 0x6cc);
	CL_SPRINTF(cliBuf, BT_TMP_BUF_SIZE, "\r\n %-35s = 0x%x/ 0x%x/ 0x%x/ 0x%x", "0x6c0/0x6c4/0x6c8/0x6cc(coexTable)", \
	           u4Tmp[0], u4Tmp[1], u4Tmp[2], u1Tmp[0]);
	CL_PRINTF(cliBuf);

	CL_SPRINTF(cliBuf, BT_TMP_BUF_SIZE, "\r\n %-35s = %d/ %d", "0x770(hp rx[31:16]/tx[15:0])", \
	           pCoexSta->highPriorityRx, pCoexSta->highPriorityTx);
	CL_PRINTF(cliBuf);
	CL_SPRINTF(cliBuf, BT_TMP_BUF_SIZE, "\r\n %-35s = %d/ %d", "0x774(lp rx[31:16]/tx[15:0])", \
	           pCoexSta->lowPriorityRx, pCoexSta->lowPriorityTx);
	CL_PRINTF(cliBuf);
#if(BT_AUTO_REPORT_ONLY_8192E_1ANT == 1)
	halbtc8192e1ant_MonitorBtCtr(pBtCoexist);
#endif

	pBtCoexist->fBtcDispDbgMsg(pBtCoexist, BTC_DBG_DISP_COEX_STATISTICS);
}


VOID
EXhalbtc8192e1ant_IpsNotify(
    IN	PBTC_COEXIST		pBtCoexist,
    IN	u1Byte			type
)
{
	//u4Byte	u4Tmp=0;

	if(pBtCoexist->bManualControl ||	pBtCoexist->bStopCoexDm)
		return;

	if(BTC_IPS_ENTER == type) {
		BTC_PRINT(BTC_MSG_INTERFACE, INTF_NOTIFY, ("[BTCoex], IPS ENTER notify\n"));
		pCoexSta->bUnderIps = TRUE;
		halbtc8192e1ant_CoexAllOff(pBtCoexist);
		halbtc8192e1ant_SetAntPath(pBtCoexist, BTC_ANT_PATH_BT, FALSE, TRUE);
	} else if(BTC_IPS_LEAVE == type) {
		BTC_PRINT(BTC_MSG_INTERFACE, INTF_NOTIFY, ("[BTCoex], IPS LEAVE notify\n"));
		pCoexSta->bUnderIps = FALSE;
	}
}

VOID
EXhalbtc8192e1ant_LpsNotify(
    IN	PBTC_COEXIST		pBtCoexist,
    IN	u1Byte			type
)
{
	if(pBtCoexist->bManualControl || pBtCoexist->bStopCoexDm)
		return;

	if(BTC_LPS_ENABLE == type) {
		BTC_PRINT(BTC_MSG_INTERFACE, INTF_NOTIFY, ("[BTCoex], LPS ENABLE notify\n"));
		pCoexSta->bUnderLps = TRUE;
	} else if(BTC_LPS_DISABLE == type) {
		BTC_PRINT(BTC_MSG_INTERFACE, INTF_NOTIFY, ("[BTCoex], LPS DISABLE notify\n"));
		pCoexSta->bUnderLps = FALSE;
	}
}

VOID
EXhalbtc8192e1ant_ScanNotify(
    IN	PBTC_COEXIST		pBtCoexist,
    IN	u1Byte			type
)
{
	BOOLEAN 		bWifiConnected=FALSE, bBtHsOn=FALSE;

	if(pBtCoexist->bManualControl ||
	   pBtCoexist->bStopCoexDm ||
	   pBtCoexist->btInfo.bBtDisabled )
		return;

	pBtCoexist->fBtcGet(pBtCoexist, BTC_GET_BL_HS_OPERATION, &bBtHsOn);
	if(pCoexSta->bC2hBtInquiryPage) {
		halbtc8192e1ant_ActionBtInquiry(pBtCoexist);
		return;
	} else if(bBtHsOn) {
		halbtc8192e1ant_ActionHs(pBtCoexist);
		return;
	}

	pBtCoexist->fBtcGet(pBtCoexist, BTC_GET_BL_WIFI_CONNECTED, &bWifiConnected);
	if(BTC_SCAN_START == type) {
		BTC_PRINT(BTC_MSG_INTERFACE, INTF_NOTIFY, ("[BTCoex], SCAN START notify\n"));
		if(!bWifiConnected) {	// non-connected scan
			halbtc8192e1ant_ActionWifiNotConnectedAssoAuthScan(pBtCoexist);
		} else {	// wifi is connected
			halbtc8192e1ant_ActionWifiConnectedScan(pBtCoexist);
		}
	} else if(BTC_SCAN_FINISH == type) {
		BTC_PRINT(BTC_MSG_INTERFACE, INTF_NOTIFY, ("[BTCoex], SCAN FINISH notify\n"));
		if(!bWifiConnected) {	// non-connected scan
			halbtc8192e1ant_ActionWifiNotConnected(pBtCoexist);
		} else {
			halbtc8192e1ant_ActionWifiConnected(pBtCoexist);
		}
	}
}

VOID
EXhalbtc8192e1ant_ConnectNotify(
    IN	PBTC_COEXIST		pBtCoexist,
    IN	u1Byte			type
)
{
	BOOLEAN	bWifiConnected=FALSE, bBtHsOn=FALSE;

	if(pBtCoexist->bManualControl ||
	   pBtCoexist->bStopCoexDm ||
	   pBtCoexist->btInfo.bBtDisabled )
		return;

	pBtCoexist->fBtcGet(pBtCoexist, BTC_GET_BL_HS_OPERATION, &bBtHsOn);
	if(pCoexSta->bC2hBtInquiryPage) {
		halbtc8192e1ant_ActionBtInquiry(pBtCoexist);
		return;
	} else if(bBtHsOn) {
		halbtc8192e1ant_ActionHs(pBtCoexist);
		return;
	}

	if(BTC_ASSOCIATE_START == type) {
		BTC_PRINT(BTC_MSG_INTERFACE, INTF_NOTIFY, ("[BTCoex], CONNECT START notify\n"));
		halbtc8192e1ant_ActionWifiNotConnectedAssoAuthScan(pBtCoexist);
	} else if(BTC_ASSOCIATE_FINISH == type) {
		BTC_PRINT(BTC_MSG_INTERFACE, INTF_NOTIFY, ("[BTCoex], CONNECT FINISH notify\n"));

		pBtCoexist->fBtcGet(pBtCoexist, BTC_GET_BL_WIFI_CONNECTED, &bWifiConnected);
		if(!bWifiConnected) { // non-connected scan
			halbtc8192e1ant_ActionWifiNotConnected(pBtCoexist);
		} else {
			halbtc8192e1ant_ActionWifiConnected(pBtCoexist);
		}
	}
}

VOID
EXhalbtc8192e1ant_MediaStatusNotify(
    IN	PBTC_COEXIST			pBtCoexist,
    IN	u1Byte				type
)
{
	u1Byte			H2C_Parameter[3] = {0};
	u4Byte			wifiBw;
	u1Byte			wifiCentralChnl;

	if(pBtCoexist->bManualControl ||
	   pBtCoexist->bStopCoexDm ||
	   pBtCoexist->btInfo.bBtDisabled )
		return;

	if(BTC_MEDIA_CONNECT == type) {
		BTC_PRINT(BTC_MSG_INTERFACE, INTF_NOTIFY, ("[BTCoex], MEDIA connect notify\n"));
	} else {
		BTC_PRINT(BTC_MSG_INTERFACE, INTF_NOTIFY, ("[BTCoex], MEDIA disconnect notify\n"));
	}

	// only 2.4G we need to inform bt the chnl mask
	pBtCoexist->fBtcGet(pBtCoexist, BTC_GET_U1_WIFI_CENTRAL_CHNL, &wifiCentralChnl);
	if( (BTC_MEDIA_CONNECT == type) &&
	    (wifiCentralChnl <= 14) ) {
		H2C_Parameter[0] = 0x1;
		H2C_Parameter[1] = wifiCentralChnl;
		pBtCoexist->fBtcGet(pBtCoexist, BTC_GET_U4_WIFI_BW, &wifiBw);
		if(BTC_WIFI_BW_HT40 == wifiBw)
			H2C_Parameter[2] = 0x30;
		else
			H2C_Parameter[2] = 0x20;
	}

	pCoexDm->wifiChnlInfo[0] = H2C_Parameter[0];
	pCoexDm->wifiChnlInfo[1] = H2C_Parameter[1];
	pCoexDm->wifiChnlInfo[2] = H2C_Parameter[2];

	BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE_FW_EXEC, ("[BTCoex], FW write 0x66=0x%x\n",
	          H2C_Parameter[0]<<16|H2C_Parameter[1]<<8|H2C_Parameter[2]));

	pBtCoexist->fBtcFillH2c(pBtCoexist, 0x66, 3, H2C_Parameter);
}

VOID
EXhalbtc8192e1ant_SpecialPacketNotify(
    IN	PBTC_COEXIST			pBtCoexist,
    IN	u1Byte				type
)
{
	BOOLEAN	bBtHsOn=FALSE;

	if(pBtCoexist->bManualControl ||
	   pBtCoexist->bStopCoexDm ||
	   pBtCoexist->btInfo.bBtDisabled )
		return;

	pBtCoexist->fBtcGet(pBtCoexist, BTC_GET_BL_HS_OPERATION, &bBtHsOn);
	if(pCoexSta->bC2hBtInquiryPage) {
		halbtc8192e1ant_ActionBtInquiry(pBtCoexist);
		return;
	} else if(bBtHsOn) {
		halbtc8192e1ant_ActionHs(pBtCoexist);
		return;
	}

	if( BTC_PACKET_DHCP == type ||
	    BTC_PACKET_EAPOL == type ) {
		BTC_PRINT(BTC_MSG_INTERFACE, INTF_NOTIFY, ("[BTCoex], special Packet(%d) notify\n", type));
		halbtc8192e1ant_ActionWifiConnectedSpecialPacket(pBtCoexist);
	}
}

VOID
EXhalbtc8192e1ant_BtInfoNotify(
    IN	PBTC_COEXIST		pBtCoexist,
    IN	pu1Byte			tmpBuf,
    IN	u1Byte			length
)
{
	PBTC_BT_LINK_INFO	pBtLinkInfo=&pBtCoexist->btLinkInfo;
	u1Byte				btInfo=0;
	u1Byte				i, rspSource=0;
	static u4Byte		setBtPsdMode=0;
	BOOLEAN				bBtBusy=FALSE;
	BOOLEAN				bWifiConnected=FALSE;
	BOOLEAN				bBtCtrlAggBufSize=FALSE;

	pCoexSta->bC2hBtInfoReqSent = FALSE;

	rspSource = tmpBuf[0]&0xf;
	if(rspSource >= BT_INFO_SRC_8192E_1ANT_MAX)
		rspSource = BT_INFO_SRC_8192E_1ANT_WIFI_FW;
	pCoexSta->btInfoC2hCnt[rspSource]++;

	BTC_PRINT(BTC_MSG_INTERFACE, INTF_NOTIFY, ("[BTCoex], Bt info[%d], length=%d, hex data=[", rspSource, length));
	for(i=0; i<length; i++) {
		pCoexSta->btInfoC2h[rspSource][i] = tmpBuf[i];
		if(i == 1)
			btInfo = tmpBuf[i];
		if(i == length-1) {
			BTC_PRINT(BTC_MSG_INTERFACE, INTF_NOTIFY, ("0x%02x]\n", tmpBuf[i]));
		} else {
			BTC_PRINT(BTC_MSG_INTERFACE, INTF_NOTIFY, ("0x%02x, ", tmpBuf[i]));
		}
	}

	if(pBtCoexist->btInfo.bBtDisabled) {
		BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], BtInfoNotify(), return for BT is disabled <===\n"));
		return;
	}

	if(pBtCoexist->bManualControl) {
		BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], BtInfoNotify(), return for Manual CTRL<===\n"));
		return;
	}
	if(pBtCoexist->bStopCoexDm) {
		BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], BtInfoNotify(), return for Coex STOPPED!!<===\n"));
		return;
	}

	if(BT_INFO_SRC_8192E_1ANT_WIFI_FW != rspSource) {
		pCoexSta->btRetryCnt =	// [3:0]
		    pCoexSta->btInfoC2h[rspSource][2]&0xf;

		pCoexSta->btRssi =
		    pCoexSta->btInfoC2h[rspSource][3]*2+10;

		pCoexSta->btInfoExt =
		    pCoexSta->btInfoC2h[rspSource][4];

		// Here we need to resend some wifi info to BT
		// because bt is reset and loss of the info.
		if( (pCoexSta->btInfoExt & BIT1) ) {
			BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], BT ext info bit1 check, send wifi BW&Chnl to BT!!\n"));
			pBtCoexist->fBtcGet(pBtCoexist, BTC_GET_BL_WIFI_CONNECTED, &bWifiConnected);
			if(bWifiConnected) {
				EXhalbtc8192e1ant_MediaStatusNotify(pBtCoexist, BTC_MEDIA_CONNECT);
			} else {
				EXhalbtc8192e1ant_MediaStatusNotify(pBtCoexist, BTC_MEDIA_DISCONNECT);
			}

			setBtPsdMode = 0;
		}

		// test-chip bt patch only rsp the status for BT_RSP,
		// so temporary we consider the following only under BT_RSP
		if(BT_INFO_SRC_8192E_1ANT_BT_RSP == rspSource) {
			if( (pCoexSta->btInfoExt & BIT3) ) {
				BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], BT ext info bit3 check, set BT NOT to ignore Wlan active!!\n"));
				halbtc8192e1ant_IgnoreWlanAct(pBtCoexist, FORCE_EXEC, FALSE);
			} else {
				// BT already NOT ignore Wlan active, do nothing here.
			}
#if(BT_AUTO_REPORT_ONLY_8192E_1ANT == 0)
			if( (pCoexSta->btInfoExt & BIT4) ) {
				// BT auto report already enabled, do nothing
			} else {
				BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], BT ext info bit4 check, set BT to enable Auto Report!!\n"));
				halbtc8192e1ant_BtAutoReport(pBtCoexist, FORCE_EXEC, TRUE);
			}
#endif
		}
	}

	// check BIT2 first ==> check if bt is under inquiry or page scan
	if(btInfo & BT_INFO_8192E_1ANT_B_INQ_PAGE)
		pCoexSta->bC2hBtInquiryPage = TRUE;
	else
		pCoexSta->bC2hBtInquiryPage = FALSE;

	// set link exist status
	if(!(btInfo&BT_INFO_8192E_1ANT_B_CONNECTION)) {
		pCoexSta->bBtLinkExist = FALSE;
		pCoexSta->bPanExist = FALSE;
		pCoexSta->bA2dpExist = FALSE;
		pCoexSta->bHidExist = FALSE;
		pCoexSta->bScoExist = FALSE;
	} else { // connection exists
		pCoexSta->bBtLinkExist = TRUE;
		if(btInfo & BT_INFO_8192E_1ANT_B_FTP)
			pCoexSta->bPanExist = TRUE;
		else
			pCoexSta->bPanExist = FALSE;
		if(btInfo & BT_INFO_8192E_1ANT_B_A2DP)
			pCoexSta->bA2dpExist = TRUE;
		else
			pCoexSta->bA2dpExist = FALSE;
		if(btInfo & BT_INFO_8192E_1ANT_B_HID)
			pCoexSta->bHidExist = TRUE;
		else
			pCoexSta->bHidExist = FALSE;
		if(btInfo & BT_INFO_8192E_1ANT_B_SCO_ESCO)
			pCoexSta->bScoExist = TRUE;
		else
			pCoexSta->bScoExist = FALSE;
	}

	halbtc8192e1ant_UpdateBtLinkInfo(pBtCoexist);

	if(!(btInfo&BT_INFO_8192E_1ANT_B_CONNECTION)) {
		pCoexDm->btStatus = BT_8192E_1ANT_BT_STATUS_NON_CONNECTED_IDLE;
		BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], BtInfoNotify(), bt non-connected idle!!!\n"));
	} else if(btInfo == BT_INFO_8192E_1ANT_B_CONNECTION) {	// connection exists but no busy
		pCoexDm->btStatus = BT_8192E_1ANT_BT_STATUS_CONNECTED_IDLE;
		BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], BtInfoNotify(), bt connected-idle!!!\n"));
	} else if((btInfo&BT_INFO_8192E_1ANT_B_SCO_ESCO) ||
	          (btInfo&BT_INFO_8192E_1ANT_B_SCO_BUSY)) {
		pCoexDm->btStatus = BT_8192E_1ANT_BT_STATUS_SCO_BUSY;
		BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], BtInfoNotify(), bt sco busy!!!\n"));
	} else if( (btInfo&BT_INFO_8192E_1ANT_B_ACL_BUSY) ||
	           (btInfo&BT_INFO_8192E_1ANT_B_A2DP) ||
	           (btInfo&BT_INFO_8192E_1ANT_B_FTP) ) {
		if(BT_8192E_1ANT_BT_STATUS_ACL_BUSY != pCoexDm->btStatus)
			pCoexDm->bAutoTdmaAdjust = FALSE;
		pCoexDm->btStatus = BT_8192E_1ANT_BT_STATUS_ACL_BUSY;
		BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], BtInfoNotify(), bt acl busy!!!\n"));
	} else {
		pCoexDm->btStatus = BT_8192E_1ANT_BT_STATUS_MAX;
		BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], BtInfoNotify(), bt non-defined state!!!\n"));
	}

	// ra mask check
	if(pBtLinkInfo->bScoExist || pBtLinkInfo->bHidExist) {
		halbtc8192e1ant_UpdateRaMask(pBtCoexist, NORMAL_EXEC, BTC_RATE_DISABLE, 0x00000003);	// disable tx cck 1M/2M
	} else {
		halbtc8192e1ant_UpdateRaMask(pBtCoexist, NORMAL_EXEC, BTC_RATE_ENABLE, 0x00000003);	// enable tx cck 1M/2M
	}

	if( (BT_8192E_1ANT_BT_STATUS_ACL_BUSY == pCoexDm->btStatus) ||
	    (BT_8192E_1ANT_BT_STATUS_SCO_BUSY == pCoexDm->btStatus) ||
	    (BT_8192E_1ANT_BT_STATUS_ACL_SCO_BUSY == pCoexDm->btStatus) ) {
		bBtBusy = TRUE;
		if(pBtLinkInfo->bHidExist)
			bBtCtrlAggBufSize = TRUE;
	} else {
		bBtBusy = FALSE;
	}
	pBtCoexist->fBtcSet(pBtCoexist, BTC_SET_BL_BT_TRAFFIC_BUSY, &bBtBusy);

	//============================================
	//	Aggregation related setting
	//============================================
	// if sco, reject AddBA
	//pBtCoexist->fBtcSet(pBtCoexist, BTC_SET_BL_TO_REJ_AP_AGG_PKT, &bRejApAggPkt);

	// decide BT control aggregation buf size or not
	pBtCoexist->fBtcSet(pBtCoexist, BTC_SET_BL_BT_CTRL_AGG_SIZE, &bBtCtrlAggBufSize);
	// real update aggregation setting
	pBtCoexist->fBtcSet(pBtCoexist, BTC_SET_ACT_AGGREGATE_CTRL, NULL);
	//============================================

	halbtc8192e1ant_RunCoexistMechanism(pBtCoexist);
}

VOID
EXhalbtc8192e1ant_HaltNotify(
    IN	PBTC_COEXIST			pBtCoexist
)
{
	BTC_PRINT(BTC_MSG_INTERFACE, INTF_NOTIFY, ("[BTCoex], Halt notify\n"));

	pBtCoexist->bStopCoexDm = TRUE;
	halbtc8192e1ant_IgnoreWlanAct(pBtCoexist, FORCE_EXEC, TRUE);

	halbtc8192e1ant_PowerSaveState(pBtCoexist, BTC_PS_WIFI_NATIVE, 0x0, 0x0);

	halbtc8192e1ant_SetAntPath(pBtCoexist, BTC_ANT_PATH_BT, FALSE, TRUE);

	EXhalbtc8192e1ant_MediaStatusNotify(pBtCoexist, BTC_MEDIA_DISCONNECT);
}

VOID
EXhalbtc8192e1ant_PnpNotify(
    IN	PBTC_COEXIST			pBtCoexist,
    IN	u1Byte				pnpState
)
{
	BTC_PRINT(BTC_MSG_INTERFACE, INTF_NOTIFY, ("[BTCoex], Pnp notify\n"));

	if(BTC_WIFI_PNP_SLEEP == pnpState) {
		pBtCoexist->bStopCoexDm = TRUE;
		halbtc8192e1ant_IgnoreWlanAct(pBtCoexist, FORCE_EXEC, TRUE);
		halbtc8192e1ant_PowerSaveState(pBtCoexist, BTC_PS_WIFI_NATIVE, 0x0, 0x0);
		halbtc8192e1ant_PsTdma(pBtCoexist, NORMAL_EXEC, FALSE, 9);
	} else if(BTC_WIFI_PNP_WAKE_UP == pnpState) {

	}
}

VOID
EXhalbtc8192e1ant_Periodical(
    IN	PBTC_COEXIST			pBtCoexist
)
{
	static u1Byte		disVerInfoCnt=0;
	u4Byte				fwVer=0, btPatchVer=0;
	//PBTC_BOARD_INFO		pBoardInfo=&pBtCoexist->boardInfo;
	//PBTC_STACK_INFO		pStackInfo=&pBtCoexist->stackInfo;

	BTC_PRINT(BTC_MSG_ALGORITHM, ALGO_TRACE, ("[BTCoex], ==========================Periodical===========================\n"));

	if(disVerInfoCnt <= 5) {
		disVerInfoCnt += 1;
		BTC_PRINT(BTC_MSG_INTERFACE, INTF_INIT, ("[BTCoex], ****************************************************************\n"));
		BTC_PRINT(BTC_MSG_INTERFACE, INTF_INIT, ("[BTCoex], Ant PG Num/ Ant Mech/ Ant Pos = %d/ %d/ %d\n", \
		          pBoardInfo->pgAntNum, pBoardInfo->btdmAntNum, pBoardInfo->btdmAntPos));
		BTC_PRINT(BTC_MSG_INTERFACE, INTF_INIT, ("[BTCoex], BT stack/ hci ext ver = %s / %d\n", \
		          ((pStackInfo->bProfileNotified)? "Yes":"No"), pStackInfo->hciVersion));
		pBtCoexist->fBtcGet(pBtCoexist, BTC_GET_U4_BT_PATCH_VER, &btPatchVer);
		pBtCoexist->fBtcGet(pBtCoexist, BTC_GET_U4_WIFI_FW_VER, &fwVer);
		BTC_PRINT(BTC_MSG_INTERFACE, INTF_INIT, ("[BTCoex], CoexVer/ FwVer/ PatchVer = %d_%x/ 0x%x/ 0x%x(%d)\n", \
		          GLCoexVerDate8192e1Ant, GLCoexVer8192e1Ant, fwVer, btPatchVer, btPatchVer));
		BTC_PRINT(BTC_MSG_INTERFACE, INTF_INIT, ("[BTCoex], ****************************************************************\n"));
	}
#if(BT_AUTO_REPORT_ONLY_8192E_1ANT == 0)
	halbtc8192e1ant_QueryBtInfo(pBtCoexist);
	halbtc8192e1ant_MonitorBtCtr(pBtCoexist);
	halbtc8192e1ant_MonitorBtEnableDisable(pBtCoexist);
#else
	if( halbtc8192e1ant_IsWifiStatusChanged(pBtCoexist) ||
	    pCoexDm->bAutoTdmaAdjust) {
		halbtc8192e1ant_RunCoexistMechanism(pBtCoexist);
	}
#endif
}

VOID
EXhalbtc8192e1ant_DbgControl(
    IN	PBTC_COEXIST			pBtCoexist,
    IN	u1Byte				opCode,
    IN	u1Byte				opLen,
    IN	pu1Byte				pData
)
{
	switch(opCode) {
	case BTC_DBG_SET_COEX_NORMAL:
		pBtCoexist->bManualControl = FALSE;
		halbtc8192e1ant_InitCoexDm(pBtCoexist);
		break;
	case BTC_DBG_SET_COEX_WIFI_ONLY:
		pBtCoexist->bManualControl = TRUE;
		halbtc8192e1ant_PowerSaveState(pBtCoexist, BTC_PS_WIFI_NATIVE, 0x0, 0x0);
		halbtc8192e1ant_PsTdma(pBtCoexist, NORMAL_EXEC, FALSE, 9);
		break;
	case BTC_DBG_SET_COEX_BT_ONLY:
		// todo
		break;
	default:
		break;
	}
}
#endif
