# 常见问题

## 设计

#### 为什么 sing-box 没有功能 X？

每个程序都包含新颖的功能并省略了某人最喜欢的功能。 sing-box 的设计着眼于高性能、轻量、可用性、模块化和代码质量的需求。
您最喜欢的功能可能会丢失，因为它不适合，因为它会影响性能或设计清晰度，或者因为它是一个坏主意。

如果 sing-box 缺少功能 X 让您感到困扰，请原谅我们并调查 sing-box 确实有的功能。 您可能会发现它们以有趣的方式弥补了 X 的缺失。

#### Naive 出站

NaïveProxy 的主要功能是 chromium 的网络栈，仅实现它的传输协议是舍本逐末的。

#### 协议组合

v2ray-core 中的 "底层传输协议" 实际上是一些专有协议的组合，并使用其上游协议的名称，造成了大量的语言腐败。

例如，v2ray 社区将 v2ray 专有的 gRPC 协议称为 Trojan gRPC，其实并不是一个 协议，在滥用 CDN 之外没有任何作用。

## Tun

#### 什么是 tun？

tun 是 unix 系统中的虚拟网络设备，在 windows 中有 WireGuard 开发的 wintun 作为替代。
sing-box 的 tun 模块包括流量处理、自动路由和网络设备监听，并主要用作透明代理。

#### 它与系统代理有什么不同？

系统代理通常只支持 TCP，且不被所有应用程序接受，但 tun 可以处理所有流量。

#### 它与传统的透明代理有什么不同？

它们通常仅支持 Linux，并且需要操作防火墙像 iptables，而 tun 仅修改路由表。

tproxy UDP 被认为性能很差，因为在 v2ray 和 clash 中每次回写都需要创建一个新连接，但 sing-box 进行了优化，因此您仍然可以在需要时使用它。

#### 它如何处理 DNS？

在传统的透明代理中，通常需要手动劫持 53 端口到 DNS 代理服务器，而 tun 更灵活。

sing-box 的 `auto_route` 将劫持所有 DNS 请求，除了 [特殊情况](./known-issues#dns)。

您需要手动配置以处理 tun 劫持的 DNS 流量，请参阅 [DNS劫持](/zh/examples/dns-hijack)。

#### 为什么我不能将它与其他本地代理一起使用（例如通过 socks）？

tun 将劫持所有流量，包括其他代理应用程序。
为了使 tun 与其他应用程序一起工作，您需要创建入站以代理来自其他程序的流量或让它们绕过路由。