/*   -*- buffer-read-only: t -*- vi: set ro:
 *
 *  DO NOT EDIT THIS FILE   (tcpreplay_opts.h)
 *
 *  It has been AutoGen-ed
 *  From the definitions    tcpreplay_opts.def
 *  and the template file   options
 *
 * Generated from AutoOpts 41:1:16 templates.
 *
 *  AutoOpts is a copyrighted work.  This header file is not encumbered
 *  by AutoOpts licensing, but is provided under the licensing terms chosen
 *  by the tcpreplay author or copyright holder.  AutoOpts is
 *  licensed under the terms of the LGPL.  The redistributable library
 *  (``libopts'') is licensed under the terms of either the LGPL or, at the
 *  users discretion, the BSD license.  See the AutoOpts and/or libopts sources
 *  for details.
 *
 * The tcpreplay program is copyrighted and licensed
 * under the following terms:
 *
 *  Copyright (C) 2000-2022 Aaron Turner and Fred Klassen, all rights reserved.
 *  This is free software. It is licensed for use, modification and
 *  redistribution under the terms of the GNU General Public License,
 *  version 3 or later <http://gnu.org/licenses/gpl.html>
 *
 *  tcpreplay is free software: you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  tcpreplay is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 *  This file contains the programmatic interface to the Automated
 *  Options generated for the tcpreplay program.
 *  These macros are documented in the AutoGen info file in the
 *  "AutoOpts" chapter.  Please refer to that doc for usage help.
 */
#ifndef AUTOOPTS_TCPREPLAY_OPTS_H_GUARD
#define AUTOOPTS_TCPREPLAY_OPTS_H_GUARD 1
#include "config.h"
#include <autoopts/options.h>

/**
 *  Ensure that the library used for compiling this generated header is at
 *  least as new as the version current when the header template was released
 *  (not counting patch version increments).  Also ensure that the oldest
 *  tolerable version is at least as old as what was current when the header
 *  template was released.
 */
#define AO_TEMPLATE_VERSION 167937
#if (AO_TEMPLATE_VERSION < OPTIONS_MINIMUM_VERSION) \
 || (AO_TEMPLATE_VERSION > OPTIONS_STRUCT_VERSION)
# error option template version mismatches autoopts/options.h header
  Choke Me.
#endif

/**
 *  Enumeration of each option type for tcpreplay
 */
typedef enum {
    INDEX_OPT_DBUG             =  0,
    INDEX_OPT_QUIET            =  1,
    INDEX_OPT_TIMER            =  2,
    INDEX_OPT_MAXSLEEP         =  3,
    INDEX_OPT_VERBOSE          =  4,
    INDEX_OPT_DECODE           =  5,
    INDEX_OPT_PRELOAD_PCAP     =  6,
    INDEX_OPT_CACHEFILE        =  7,
    INDEX_OPT_DUALFILE         =  8,
    INDEX_OPT_INTF1            =  9,
    INDEX_OPT_INTF2            = 10,
    INDEX_OPT_LISTNICS         = 11,
    INDEX_OPT_LOOP             = 12,
    INDEX_OPT_LOOPDELAY_MS     = 13,
    INDEX_OPT_PKTLEN           = 14,
    INDEX_OPT_LIMIT            = 15,
    INDEX_OPT_DURATION         = 16,
    INDEX_OPT_MULTIPLIER       = 17,
    INDEX_OPT_PPS              = 18,
    INDEX_OPT_MBPS             = 19,
    INDEX_OPT_TOPSPEED         = 20,
    INDEX_OPT_ONEATATIME       = 21,
    INDEX_OPT_PPS_MULTI        = 22,
    INDEX_OPT_UNIQUE_IP        = 23,
    INDEX_OPT_UNIQUE_IP_LOOPS  = 24,
    INDEX_OPT_NETMAP           = 25,
    INDEX_OPT_NM_DELAY         = 26,
    INDEX_OPT_NO_FLOW_STATS    = 27,
    INDEX_OPT_FLOW_EXPIRY      = 28,
    INDEX_OPT_PID              = 29,
    INDEX_OPT_STATS            = 30,
    INDEX_OPT_VERSION          = 31,
    INDEX_OPT_LESS_HELP        = 32,
    INDEX_OPT_HELP             = 33,
    INDEX_OPT_MORE_HELP        = 34,
    INDEX_OPT_SAVE_OPTS        = 35,
    INDEX_OPT_LOAD_OPTS        = 36
} teOptIndex;
/** count of all options for tcpreplay */
#define OPTION_CT    37

/**
 *  Interface defines for all options.  Replace "n" with the UPPER_CASED
 *  option name (as in the teOptIndex enumeration above).
 *  e.g. HAVE_OPT(DBUG)
 */
#define         DESC(n) (tcpreplayOptions.pOptDesc[INDEX_OPT_## n])
/** 'true' if an option has been specified in any way */
#define     HAVE_OPT(n) (! UNUSED_OPT(& DESC(n)))
/** The string argument to an option. The argument type must be \"string\". */
#define      OPT_ARG(n) (DESC(n).optArg.argString)
/** Mask the option state revealing how an option was specified.
 *  It will be one and only one of \a OPTST_SET, \a OPTST_PRESET,
 * \a OPTST_DEFINED, \a OPTST_RESET or zero.
 */
#define    STATE_OPT(n) (DESC(n).fOptState & OPTST_SET_MASK)
/** Count of option's occurrances *on the command line*. */
#define    COUNT_OPT(n) (DESC(n).optOccCt)
/** mask of \a OPTST_SET and \a OPTST_DEFINED. */
#define    ISSEL_OPT(n) (SELECTED_OPT(&DESC(n)))
/** 'true' if \a HAVE_OPT would yield 'false'. */
#define ISUNUSED_OPT(n) (UNUSED_OPT(& DESC(n)))
/** 'true' if OPTST_DISABLED bit not set. */
#define  ENABLED_OPT(n) (! DISABLED_OPT(& DESC(n)))
/** number of stacked option arguments.
 *  Valid only for stacked option arguments. */
#define  STACKCT_OPT(n) (((tArgList*)(DESC(n).optCookie))->useCt)
/** stacked argument vector.
 *  Valid only for stacked option arguments. */
#define STACKLST_OPT(n) (((tArgList*)(DESC(n).optCookie))->apzArgs)
/** Reset an option. */
#define    CLEAR_OPT(n) STMTS( \
                DESC(n).fOptState &= OPTST_PERSISTENT_MASK;   \
                if ((DESC(n).fOptState & OPTST_INITENABLED) == 0) \
                    DESC(n).fOptState |= OPTST_DISABLED; \
                DESC(n).optCookie = NULL )
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/**
 *  Enumeration of tcpreplay exit codes
 */
typedef enum {
    TCPREPLAY_EXIT_SUCCESS         = 0,
    TCPREPLAY_EXIT_FAILURE         = 1,
    TCPREPLAY_EXIT_USAGE_ERROR     = 64,
    TCPREPLAY_EXIT_NO_CONFIG_INPUT = 66,
    TCPREPLAY_EXIT_LIBOPTS_FAILURE = 70
}   tcpreplay_exit_code_t;
/**
 *  Interface defines for specific options.
 * @{
 */
#define VALUE_OPT_DBUG           'd'
#ifdef DEBUG
#define OPT_VALUE_DBUG           (DESC(DBUG).optArg.argInt)
#endif /* DEBUG */
#define VALUE_OPT_QUIET          'q'
#define VALUE_OPT_TIMER          'T'
#define VALUE_OPT_MAXSLEEP       0x1001

#define OPT_VALUE_MAXSLEEP       (DESC(MAXSLEEP).optArg.argInt)
#define VALUE_OPT_VERBOSE        'v'
#ifdef ENABLE_VERBOSE
#define SET_OPT_VERBOSE   STMTS( \
        DESC(VERBOSE).optActualIndex = 4; \
        DESC(VERBOSE).optActualValue = VALUE_OPT_VERBOSE; \
        DESC(VERBOSE).fOptState &= OPTST_PERSISTENT_MASK; \
        DESC(VERBOSE).fOptState |= OPTST_SET )
#endif /* ENABLE_VERBOSE */
#define VALUE_OPT_DECODE         'A'
#define VALUE_OPT_PRELOAD_PCAP   'K'
#define VALUE_OPT_CACHEFILE      'c'
#define VALUE_OPT_DUALFILE       '2'
#define VALUE_OPT_INTF1          'i'
#define VALUE_OPT_INTF2          'I'
#define VALUE_OPT_LISTNICS       0x1002
#define VALUE_OPT_LOOP           'l'

#define OPT_VALUE_LOOP           (DESC(LOOP).optArg.argInt)
#define VALUE_OPT_LOOPDELAY_MS   0x1003

#define OPT_VALUE_LOOPDELAY_MS   (DESC(LOOPDELAY_MS).optArg.argInt)
#define VALUE_OPT_PKTLEN         0x1004
#define VALUE_OPT_LIMIT          'L'

#define OPT_VALUE_LIMIT          (DESC(LIMIT).optArg.argInt)
#define VALUE_OPT_DURATION       0x1005

#define OPT_VALUE_DURATION       (DESC(DURATION).optArg.argInt)
#define VALUE_OPT_MULTIPLIER     'x'
#define VALUE_OPT_PPS            'p'
#define VALUE_OPT_MBPS           'M'
#define VALUE_OPT_TOPSPEED       't'
#define VALUE_OPT_ONEATATIME     'o'
#define VALUE_OPT_PPS_MULTI      0x1006

#define OPT_VALUE_PPS_MULTI      (DESC(PPS_MULTI).optArg.argInt)
#define VALUE_OPT_UNIQUE_IP      0x1007
#define VALUE_OPT_UNIQUE_IP_LOOPS 0x1008
#define VALUE_OPT_NETMAP         0x1009
#define VALUE_OPT_NM_DELAY       0x100A
#ifdef HAVE_NETMAP
#define OPT_VALUE_NM_DELAY       (DESC(NM_DELAY).optArg.argInt)
#endif /* HAVE_NETMAP */
#define VALUE_OPT_NO_FLOW_STATS  0x100B
#define VALUE_OPT_FLOW_EXPIRY    0x100C

#define OPT_VALUE_FLOW_EXPIRY    (DESC(FLOW_EXPIRY).optArg.argInt)
#define VALUE_OPT_PID            'P'
#define VALUE_OPT_STATS          0x100D

#define OPT_VALUE_STATS          (DESC(STATS).optArg.argInt)
#define VALUE_OPT_VERSION        'V'
#define VALUE_OPT_LESS_HELP      'h'
/** option flag (value) for help-value option */
#define VALUE_OPT_HELP          'H'
/** option flag (value) for more-help-value option */
#define VALUE_OPT_MORE_HELP     '!'
/** option flag (value) for save-opts-value option */
#define VALUE_OPT_SAVE_OPTS     0x100E
/** option flag (value) for load-opts-value option */
#define VALUE_OPT_LOAD_OPTS     0x100F
#define SET_OPT_SAVE_OPTS(a)   STMTS( \
        DESC(SAVE_OPTS).fOptState &= OPTST_PERSISTENT_MASK; \
        DESC(SAVE_OPTS).fOptState |= OPTST_SET; \
        DESC(SAVE_OPTS).optArg.argString = (char const*)(a))
/*
 *  Interface defines not associated with particular options
 */
#define ERRSKIP_OPTERR  STMTS(tcpreplayOptions.fOptSet &= ~OPTPROC_ERRSTOP)
#define ERRSTOP_OPTERR  STMTS(tcpreplayOptions.fOptSet |= OPTPROC_ERRSTOP)
#define RESTART_OPT(n)  STMTS( \
                tcpreplayOptions.curOptIdx = (n); \
                tcpreplayOptions.pzCurOpt  = NULL )
#define START_OPT       RESTART_OPT(1)
#define USAGE(c)        (*tcpreplayOptions.pUsageProc)(&tcpreplayOptions, c)

#ifdef  __cplusplus
extern "C" {
#endif


/* * * * * *
 *
 *  Declare the tcpreplay option descriptor.
 */
extern tOptions tcpreplayOptions;

#if defined(ENABLE_NLS)
# ifndef _
#   include <stdio.h>
#   ifndef HAVE_GETTEXT
      extern char * gettext(char const *);
#   else
#     include <libintl.h>
#   endif

# ifndef ATTRIBUTE_FORMAT_ARG
#   define ATTRIBUTE_FORMAT_ARG(_a)
# endif

static inline char* aoGetsText(char const* pz) ATTRIBUTE_FORMAT_ARG(1);
static inline char* aoGetsText(char const* pz) {
    if (pz == NULL) return NULL;
    return (char*)gettext(pz);
}
#   define _(s)  aoGetsText(s)
# endif /* _() */

# define OPT_NO_XLAT_CFG_NAMES  STMTS(tcpreplayOptions.fOptSet |= \
                                    OPTPROC_NXLAT_OPT_CFG;)
# define OPT_NO_XLAT_OPT_NAMES  STMTS(tcpreplayOptions.fOptSet |= \
                                    OPTPROC_NXLAT_OPT|OPTPROC_NXLAT_OPT_CFG;)

# define OPT_XLAT_CFG_NAMES     STMTS(tcpreplayOptions.fOptSet &= \
                                  ~(OPTPROC_NXLAT_OPT|OPTPROC_NXLAT_OPT_CFG);)
# define OPT_XLAT_OPT_NAMES     STMTS(tcpreplayOptions.fOptSet &= \
                                  ~OPTPROC_NXLAT_OPT;)

#else   /* ENABLE_NLS */
# define OPT_NO_XLAT_CFG_NAMES
# define OPT_NO_XLAT_OPT_NAMES

# define OPT_XLAT_CFG_NAMES
# define OPT_XLAT_OPT_NAMES

# ifndef _
#   define _(_s)  _s
# endif
#endif  /* ENABLE_NLS */

#ifdef  __cplusplus
}
#endif
#endif /* AUTOOPTS_TCPREPLAY_OPTS_H_GUARD */

/* tcpreplay_opts.h ends here */
