/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { SerializableClass } from '../../../interfaces';
import { TrustProductsChannelEndpointAssignmentList } from './trustProducts/trustProductsChannelEndpointAssignment';
import { TrustProductsChannelEndpointAssignmentListInstance } from './trustProducts/trustProductsChannelEndpointAssignment';
import { TrustProductsEntityAssignmentsList } from './trustProducts/trustProductsEntityAssignments';
import { TrustProductsEntityAssignmentsListInstance } from './trustProducts/trustProductsEntityAssignments';
import { TrustProductsEvaluationsList } from './trustProducts/trustProductsEvaluations';
import { TrustProductsEvaluationsListInstance } from './trustProducts/trustProductsEvaluations';

type TrustProductsEndUserType = 'individual'|'business';

type TrustProductsStatus = 'draft'|'pending-review'|'in-review'|'twilio-rejected'|'twilio-approved';

/**
 * Initialize the TrustProductsList
 *
 * @param version - Version of the resource
 */
declare function TrustProductsList(version: V1): TrustProductsListInstance;

/**
 * Options to pass to update
 *
 * @property email - The email address
 * @property friendlyName - The string that you assigned to describe the resource
 * @property status - The verification status of the Customer-Profile resource
 * @property statusCallback - The URL we call to inform your application of status changes.
 */
interface TrustProductsInstanceUpdateOptions {
  email?: string;
  friendlyName?: string;
  status?: TrustProductsStatus;
  statusCallback?: string;
}

interface TrustProductsListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): TrustProductsContext;
  /**
   * create a TrustProductsInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: TrustProductsListInstanceCreateOptions, callback?: (error: Error | null, item: TrustProductsInstance) => any): Promise<TrustProductsInstance>;
  /**
   * Streams TrustProductsInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: TrustProductsInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams TrustProductsInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: TrustProductsListInstanceEachOptions, callback?: (item: TrustProductsInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a trust_products
   *
   * @param sid - The unique string that identifies the resource.
   */
  get(sid: string): TrustProductsContext;
  /**
   * Retrieve a single target page of TrustProductsInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: TrustProductsPage) => any): Promise<TrustProductsPage>;
  /**
   * Retrieve a single target page of TrustProductsInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: TrustProductsPage) => any): Promise<TrustProductsPage>;
  /**
   * Lists TrustProductsInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: TrustProductsInstance[]) => any): Promise<TrustProductsInstance[]>;
  /**
   * Lists TrustProductsInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: TrustProductsListInstanceOptions, callback?: (error: Error | null, items: TrustProductsInstance[]) => any): Promise<TrustProductsInstance[]>;
  /**
   * Retrieve a single page of TrustProductsInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: TrustProductsPage) => any): Promise<TrustProductsPage>;
  /**
   * Retrieve a single page of TrustProductsInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: TrustProductsListInstancePageOptions, callback?: (error: Error | null, items: TrustProductsPage) => any): Promise<TrustProductsPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property email - The email address
 * @property friendlyName - The string that you assigned to describe the resource
 * @property policySid - The unique string of a policy.
 * @property statusCallback - The URL we call to inform your application of status changes.
 */
interface TrustProductsListInstanceCreateOptions {
  email: string;
  friendlyName: string;
  policySid: string;
  statusCallback?: string;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property friendlyName - The string that you assigned to describe the resource
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 * @property policySid - The unique string of a policy.
 * @property status - The verification status of the Customer-Profile resource
 */
interface TrustProductsListInstanceEachOptions {
  callback?: (item: TrustProductsInstance, done: (err?: Error) => void) => void;
  done?: Function;
  friendlyName?: string;
  limit?: number;
  pageSize?: number;
  policySid?: string;
  status?: TrustProductsStatus;
}

/**
 * Options to pass to list
 *
 * @property friendlyName - The string that you assigned to describe the resource
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 * @property policySid - The unique string of a policy.
 * @property status - The verification status of the Customer-Profile resource
 */
interface TrustProductsListInstanceOptions {
  friendlyName?: string;
  limit?: number;
  pageSize?: number;
  policySid?: string;
  status?: TrustProductsStatus;
}

/**
 * Options to pass to page
 *
 * @property friendlyName - The string that you assigned to describe the resource
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 * @property policySid - The unique string of a policy.
 * @property status - The verification status of the Customer-Profile resource
 */
interface TrustProductsListInstancePageOptions {
  friendlyName?: string;
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
  policySid?: string;
  status?: TrustProductsStatus;
}

interface TrustProductsPayload extends TrustProductsResource, Page.TwilioResponsePayload {
}

interface TrustProductsResource {
  account_sid: string;
  date_created: Date;
  date_updated: Date;
  email: string;
  friendly_name: string;
  links: string;
  policy_sid: string;
  sid: string;
  status: TrustProductsStatus;
  status_callback: string;
  url: string;
  valid_until: Date;
}

interface TrustProductsSolution {
}


declare class TrustProductsContext {
  /**
   * Initialize the TrustProductsContext
   *
   * @param version - Version of the resource
   * @param sid - The unique string that identifies the resource.
   */
  constructor(version: V1, sid: string);

  /**
   * fetch a TrustProductsInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: TrustProductsInstance) => any): Promise<TrustProductsInstance>;
  /**
   * remove a TrustProductsInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: TrustProductsInstance) => any): Promise<boolean>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  trustProductsChannelEndpointAssignment: TrustProductsChannelEndpointAssignmentListInstance;
  trustProductsEntityAssignments: TrustProductsEntityAssignmentsListInstance;
  trustProductsEvaluations: TrustProductsEvaluationsListInstance;
  /**
   * update a TrustProductsInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: TrustProductsInstance) => any): Promise<TrustProductsInstance>;
  /**
   * update a TrustProductsInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: TrustProductsInstanceUpdateOptions, callback?: (error: Error | null, items: TrustProductsInstance) => any): Promise<TrustProductsInstance>;
}


declare class TrustProductsInstance extends SerializableClass {
  /**
   * Initialize the TrustProductsContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param sid - The unique string that identifies the resource.
   */
  constructor(version: V1, payload: TrustProductsPayload, sid: string);

  private _proxy: TrustProductsContext;
  accountSid: string;
  dateCreated: Date;
  dateUpdated: Date;
  email: string;
  /**
   * fetch a TrustProductsInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: TrustProductsInstance) => any): Promise<TrustProductsInstance>;
  friendlyName: string;
  links: string;
  policySid: string;
  /**
   * remove a TrustProductsInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: TrustProductsInstance) => any): Promise<boolean>;
  sid: string;
  status: TrustProductsStatus;
  statusCallback: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * Access the trustProductsChannelEndpointAssignment
   */
  trustProductsChannelEndpointAssignment(): TrustProductsChannelEndpointAssignmentListInstance;
  /**
   * Access the trustProductsEntityAssignments
   */
  trustProductsEntityAssignments(): TrustProductsEntityAssignmentsListInstance;
  /**
   * Access the trustProductsEvaluations
   */
  trustProductsEvaluations(): TrustProductsEvaluationsListInstance;
  /**
   * update a TrustProductsInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: TrustProductsInstance) => any): Promise<TrustProductsInstance>;
  /**
   * update a TrustProductsInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: TrustProductsInstanceUpdateOptions, callback?: (error: Error | null, items: TrustProductsInstance) => any): Promise<TrustProductsInstance>;
  url: string;
  validUntil: Date;
}


declare class TrustProductsPage extends Page<V1, TrustProductsPayload, TrustProductsResource, TrustProductsInstance> {
  /**
   * Initialize the TrustProductsPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: TrustProductsSolution);

  /**
   * Build an instance of TrustProductsInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: TrustProductsPayload): TrustProductsInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { TrustProductsContext, TrustProductsEndUserType, TrustProductsInstance, TrustProductsInstanceUpdateOptions, TrustProductsList, TrustProductsListInstance, TrustProductsListInstanceCreateOptions, TrustProductsListInstanceEachOptions, TrustProductsListInstanceOptions, TrustProductsListInstancePageOptions, TrustProductsPage, TrustProductsPayload, TrustProductsResource, TrustProductsSolution, TrustProductsStatus }
