'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../../../base/deserialize');  /* jshint ignore:line */
var serialize = require(
    '../../../../../base/serialize');  /* jshint ignore:line */
var values = require('../../../../../base/values');  /* jshint ignore:line */

var UserChannelList;
var UserChannelPage;
var UserChannelInstance;
var UserChannelContext;

/* jshint ignore:start */
/**
 * Initialize the UserChannelList
 *
 * @constructor Twilio.Chat.V2.ServiceContext.UserContext.UserChannelList
 *
 * @param {Twilio.Chat.V2} version - Version of the resource
 * @param {string} serviceSid -
 *          The SID of the Service that the resource is associated with
 * @param {string} userSid - The SID of the User the User Channel belongs to
 */
/* jshint ignore:end */
UserChannelList = function UserChannelList(version, serviceSid, userSid) {
  /* jshint ignore:start */
  /**
   * @function userChannels
   * @memberof Twilio.Chat.V2.ServiceContext.UserContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Chat.V2.ServiceContext.UserContext.UserChannelContext}
   */
  /* jshint ignore:end */
  function UserChannelListInstance(sid) {
    return UserChannelListInstance.get(sid);
  }

  UserChannelListInstance._version = version;
  // Path Solution
  UserChannelListInstance._solution = {serviceSid: serviceSid, userSid: userSid};
  UserChannelListInstance._uri = `/Services/${serviceSid}/Users/${userSid}/Channels`;
  /* jshint ignore:start */
  /**
   * Streams UserChannelInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Chat.V2.ServiceContext.UserContext.UserChannelList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  UserChannelListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists UserChannelInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Chat.V2.ServiceContext.UserContext.UserChannelList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  UserChannelListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of UserChannelInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Chat.V2.ServiceContext.UserContext.UserChannelList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  UserChannelListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new UserChannelPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of UserChannelInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Chat.V2.ServiceContext.UserContext.UserChannelList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  UserChannelListInstance.getPage = function getPage(targetUrl, callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new UserChannelPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a user_channel
   *
   * @function get
   * @memberof Twilio.Chat.V2.ServiceContext.UserContext.UserChannelList#
   *
   * @param {string} channelSid -
   *          The SID of the Channel that has the User Channel to fetch
   *
   * @returns {Twilio.Chat.V2.ServiceContext.UserContext.UserChannelContext}
   */
  /* jshint ignore:end */
  UserChannelListInstance.get = function get(channelSid) {
    return new UserChannelContext(
      this._version,
      this._solution.serviceSid,
      this._solution.userSid,
      channelSid
    );
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Chat.V2.ServiceContext.UserContext.UserChannelList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  UserChannelListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  UserChannelListInstance[util.inspect.custom] = function inspect(depth, options)
      {
    return util.inspect(this.toJSON(), options);
  };

  return UserChannelListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the UserChannelPage
 *
 * @constructor Twilio.Chat.V2.ServiceContext.UserContext.UserChannelPage
 *
 * @param {V2} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {UserChannelSolution} solution - Path solution
 *
 * @returns UserChannelPage
 */
/* jshint ignore:end */
UserChannelPage = function UserChannelPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(UserChannelPage.prototype, Page.prototype);
UserChannelPage.prototype.constructor = UserChannelPage;

/* jshint ignore:start */
/**
 * Build an instance of UserChannelInstance
 *
 * @function getInstance
 * @memberof Twilio.Chat.V2.ServiceContext.UserContext.UserChannelPage#
 *
 * @param {UserChannelPayload} payload - Payload response from the API
 *
 * @returns UserChannelInstance
 */
/* jshint ignore:end */
UserChannelPage.prototype.getInstance = function getInstance(payload) {
  return new UserChannelInstance(
    this._version,
    payload,
    this._solution.serviceSid,
    this._solution.userSid
  );
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Chat.V2.ServiceContext.UserContext.UserChannelPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
UserChannelPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

UserChannelPage.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the UserChannelContext
 *
 * @constructor Twilio.Chat.V2.ServiceContext.UserContext.UserChannelInstance
 *
 * @property {string} accountSid - The SID of the Account that created the resource
 * @property {string} serviceSid -
 *          The SID of the Service that the resource is associated with
 * @property {string} channelSid - The SID of the Channel the resource belongs to
 * @property {string} userSid - The SID of the User the User Channel belongs to
 * @property {string} memberSid - The SID of the User as a Member in the Channel
 * @property {user_channel.channel_status} status -
 *          The status of the User on the Channel
 * @property {number} lastConsumedMessageIndex -
 *          The index of the last Message in the Channel the Member has read
 * @property {number} unreadMessagesCount -
 *          The number of unread Messages in the Channel for the User
 * @property {string} links -
 *          Absolute URLs to access the Members, Messages , Invites and, if it exists, the last Message for the Channel
 * @property {string} url - The absolute URL of the resource
 * @property {user_channel.notification_level} notificationLevel -
 *          The push notification level of the User for the Channel
 *
 * @param {V2} version - Version of the resource
 * @param {UserChannelPayload} payload - The instance payload
 * @param {sid} serviceSid -
 *          The SID of the Service that the resource is associated with
 * @param {sid} userSid - The SID of the User the User Channel belongs to
 * @param {sid_like} channelSid -
 *          The SID of the Channel that has the User Channel to fetch
 */
/* jshint ignore:end */
UserChannelInstance = function UserChannelInstance(version, payload, serviceSid,
                                                    userSid, channelSid) {
  this._version = version;

  // Marshaled Properties
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.serviceSid = payload.service_sid; // jshint ignore:line
  this.channelSid = payload.channel_sid; // jshint ignore:line
  this.userSid = payload.user_sid; // jshint ignore:line
  this.memberSid = payload.member_sid; // jshint ignore:line
  this.status = payload.status; // jshint ignore:line
  this.lastConsumedMessageIndex = deserialize.integer(payload.last_consumed_message_index); // jshint ignore:line
  this.unreadMessagesCount = deserialize.integer(payload.unread_messages_count); // jshint ignore:line
  this.links = payload.links; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line
  this.notificationLevel = payload.notification_level; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {
    serviceSid: serviceSid,
    userSid: userSid,
    channelSid: channelSid || this.channelSid,
  };
};

Object.defineProperty(UserChannelInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new UserChannelContext(
          this._version,
          this._solution.serviceSid,
          this._solution.userSid,
          this._solution.channelSid
        );
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a UserChannelInstance
 *
 * @function fetch
 * @memberof Twilio.Chat.V2.ServiceContext.UserContext.UserChannelInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed UserChannelInstance
 */
/* jshint ignore:end */
UserChannelInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * remove a UserChannelInstance
 *
 * @function remove
 * @memberof Twilio.Chat.V2.ServiceContext.UserContext.UserChannelInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed UserChannelInstance
 */
/* jshint ignore:end */
UserChannelInstance.prototype.remove = function remove(callback) {
  return this._proxy.remove(callback);
};

/* jshint ignore:start */
/**
 * update a UserChannelInstance
 *
 * @function update
 * @memberof Twilio.Chat.V2.ServiceContext.UserContext.UserChannelInstance#
 *
 * @param {object} [opts] - Options for request
 * @param {user_channel.notification_level} [opts.notificationLevel] -
 *          The push notification level to assign to the User Channel
 * @param {number} [opts.lastConsumedMessageIndex] -
 *          The index of the last Message that the Member has read within the Channel
 * @param {Date} [opts.lastConsumptionTimestamp] -
 *          The ISO 8601 based timestamp string that represents the datetime of the last Message read event for the Member within the Channel
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed UserChannelInstance
 */
/* jshint ignore:end */
UserChannelInstance.prototype.update = function update(opts, callback) {
  return this._proxy.update(opts, callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Chat.V2.ServiceContext.UserContext.UserChannelInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
UserChannelInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

UserChannelInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the UserChannelContext
 *
 * @constructor Twilio.Chat.V2.ServiceContext.UserContext.UserChannelContext
 *
 * @param {V2} version - Version of the resource
 * @param {sid} serviceSid -
 *          The SID of the Service to fetch the User Channel resource from
 * @param {sid_like} userSid -
 *          The SID of the User to fetch the User Channel resource from
 * @param {sid_like} channelSid -
 *          The SID of the Channel that has the User Channel to fetch
 */
/* jshint ignore:end */
UserChannelContext = function UserChannelContext(version, serviceSid, userSid,
                                                  channelSid) {
  this._version = version;

  // Path Solution
  this._solution = {serviceSid: serviceSid, userSid: userSid, channelSid: channelSid, };
  this._uri = `/Services/${serviceSid}/Users/${userSid}/Channels/${channelSid}`;
};

/* jshint ignore:start */
/**
 * fetch a UserChannelInstance
 *
 * @function fetch
 * @memberof Twilio.Chat.V2.ServiceContext.UserContext.UserChannelContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed UserChannelInstance
 */
/* jshint ignore:end */
UserChannelContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new UserChannelInstance(
      this._version,
      payload,
      this._solution.serviceSid,
      this._solution.userSid,
      this._solution.channelSid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * remove a UserChannelInstance
 *
 * @function remove
 * @memberof Twilio.Chat.V2.ServiceContext.UserContext.UserChannelContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed UserChannelInstance
 */
/* jshint ignore:end */
UserChannelContext.prototype.remove = function remove(callback) {
  var deferred = Q.defer();
  var promise = this._version.remove({uri: this._uri, method: 'DELETE'});

  promise = promise.then(function(payload) {
    deferred.resolve(payload);
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * update a UserChannelInstance
 *
 * @function update
 * @memberof Twilio.Chat.V2.ServiceContext.UserContext.UserChannelContext#
 *
 * @param {object} [opts] - Options for request
 * @param {user_channel.notification_level} [opts.notificationLevel] -
 *          The push notification level to assign to the User Channel
 * @param {number} [opts.lastConsumedMessageIndex] -
 *          The index of the last Message that the Member has read within the Channel
 * @param {Date} [opts.lastConsumptionTimestamp] -
 *          The ISO 8601 based timestamp string that represents the datetime of the last Message read event for the Member within the Channel
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed UserChannelInstance
 */
/* jshint ignore:end */
UserChannelContext.prototype.update = function update(opts, callback) {
  if (_.isFunction(opts)) {
    callback = opts;
    opts = {};
  }
  opts = opts || {};

  var deferred = Q.defer();
  var data = values.of({
    'NotificationLevel': _.get(opts, 'notificationLevel'),
    'LastConsumedMessageIndex': _.get(opts, 'lastConsumedMessageIndex'),
    'LastConsumptionTimestamp': serialize.iso8601DateTime(_.get(opts, 'lastConsumptionTimestamp'))
  });

  var promise = this._version.update({uri: this._uri, method: 'POST', data: data});

  promise = promise.then(function(payload) {
    deferred.resolve(new UserChannelInstance(
      this._version,
      payload,
      this._solution.serviceSid,
      this._solution.userSid,
      this._solution.channelSid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Chat.V2.ServiceContext.UserContext.UserChannelContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
UserChannelContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

UserChannelContext.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  UserChannelList: UserChannelList,
  UserChannelPage: UserChannelPage,
  UserChannelInstance: UserChannelInstance,
  UserChannelContext: UserChannelContext
};
