'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../../base/deserialize');  /* jshint ignore:line */
var values = require('../../../../base/values');  /* jshint ignore:line */

var DependentHostedNumberOrderList;
var DependentHostedNumberOrderPage;
var DependentHostedNumberOrderInstance;

/* jshint ignore:start */
/**
 * Initialize the DependentHostedNumberOrderList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.HostedNumbers.AuthorizationDocumentContext.DependentHostedNumberOrderList
 *
 * @param {Twilio.Preview.HostedNumbers} version - Version of the resource
 * @param {string} signingDocumentSid - LOA document sid.
 */
/* jshint ignore:end */
DependentHostedNumberOrderList = function
    DependentHostedNumberOrderList(version, signingDocumentSid) {
  /* jshint ignore:start */
  /**
   * @function dependentHostedNumberOrders
   * @memberof Twilio.Preview.HostedNumbers.AuthorizationDocumentContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Preview.HostedNumbers.AuthorizationDocumentContext.DependentHostedNumberOrderContext}
   */
  /* jshint ignore:end */
  function DependentHostedNumberOrderListInstance(sid) {
    return DependentHostedNumberOrderListInstance.get(sid);
  }

  DependentHostedNumberOrderListInstance._version = version;
  // Path Solution
  DependentHostedNumberOrderListInstance._solution = {signingDocumentSid: signingDocumentSid};
  DependentHostedNumberOrderListInstance._uri = `/AuthorizationDocuments/${signingDocumentSid}/DependentHostedNumberOrders`;
  /* jshint ignore:start */
  /**
   * Streams DependentHostedNumberOrderInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Preview.HostedNumbers.AuthorizationDocumentContext.DependentHostedNumberOrderList#
   *
   * @param {object} [opts] - Options for request
   * @param {dependent_hosted_number_order.status} [opts.status] -
   *          The Status of this HostedNumberOrder.
   * @param {string} [opts.phoneNumber] - An E164 formatted phone number.
   * @param {string} [opts.incomingPhoneNumberSid] - IncomingPhoneNumber sid.
   * @param {string} [opts.friendlyName] -
   *          A human readable description of this resource.
   * @param {string} [opts.uniqueName] -
   *          A unique, developer assigned name of this HostedNumberOrder.
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  DependentHostedNumberOrderListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists DependentHostedNumberOrderInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Preview.HostedNumbers.AuthorizationDocumentContext.DependentHostedNumberOrderList#
   *
   * @param {object} [opts] - Options for request
   * @param {dependent_hosted_number_order.status} [opts.status] -
   *          The Status of this HostedNumberOrder.
   * @param {string} [opts.phoneNumber] - An E164 formatted phone number.
   * @param {string} [opts.incomingPhoneNumberSid] - IncomingPhoneNumber sid.
   * @param {string} [opts.friendlyName] -
   *          A human readable description of this resource.
   * @param {string} [opts.uniqueName] -
   *          A unique, developer assigned name of this HostedNumberOrder.
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  DependentHostedNumberOrderListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of DependentHostedNumberOrderInstance records from the
   * API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Preview.HostedNumbers.AuthorizationDocumentContext.DependentHostedNumberOrderList#
   *
   * @param {object} [opts] - Options for request
   * @param {dependent_hosted_number_order.status} [opts.status] -
   *          The Status of this HostedNumberOrder.
   * @param {string} [opts.phoneNumber] - An E164 formatted phone number.
   * @param {string} [opts.incomingPhoneNumberSid] - IncomingPhoneNumber sid.
   * @param {string} [opts.friendlyName] -
   *          A human readable description of this resource.
   * @param {string} [opts.uniqueName] -
   *          A unique, developer assigned name of this HostedNumberOrder.
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  DependentHostedNumberOrderListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'Status': _.get(opts, 'status'),
      'PhoneNumber': _.get(opts, 'phoneNumber'),
      'IncomingPhoneNumberSid': _.get(opts, 'incomingPhoneNumberSid'),
      'FriendlyName': _.get(opts, 'friendlyName'),
      'UniqueName': _.get(opts, 'uniqueName'),
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new DependentHostedNumberOrderPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of DependentHostedNumberOrderInstance records from
   * the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Preview.HostedNumbers.AuthorizationDocumentContext.DependentHostedNumberOrderList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  DependentHostedNumberOrderListInstance.getPage = function getPage(targetUrl,
      callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new DependentHostedNumberOrderPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Preview.HostedNumbers.AuthorizationDocumentContext.DependentHostedNumberOrderList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  DependentHostedNumberOrderListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  DependentHostedNumberOrderListInstance[util.inspect.custom] = function
      inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return DependentHostedNumberOrderListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the DependentHostedNumberOrderPage
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.HostedNumbers.AuthorizationDocumentContext.DependentHostedNumberOrderPage
 *
 * @param {HostedNumbers} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {DependentHostedNumberOrderSolution} solution - Path solution
 *
 * @returns DependentHostedNumberOrderPage
 */
/* jshint ignore:end */
DependentHostedNumberOrderPage = function
    DependentHostedNumberOrderPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(DependentHostedNumberOrderPage.prototype, Page.prototype);
DependentHostedNumberOrderPage.prototype.constructor = DependentHostedNumberOrderPage;

/* jshint ignore:start */
/**
 * Build an instance of DependentHostedNumberOrderInstance
 *
 * @function getInstance
 * @memberof Twilio.Preview.HostedNumbers.AuthorizationDocumentContext.DependentHostedNumberOrderPage#
 *
 * @param {DependentHostedNumberOrderPayload} payload -
 *          Payload response from the API
 *
 * @returns DependentHostedNumberOrderInstance
 */
/* jshint ignore:end */
DependentHostedNumberOrderPage.prototype.getInstance = function
    getInstance(payload) {
  return new DependentHostedNumberOrderInstance(
    this._version,
    payload,
    this._solution.signingDocumentSid
  );
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Preview.HostedNumbers.AuthorizationDocumentContext.DependentHostedNumberOrderPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
DependentHostedNumberOrderPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

DependentHostedNumberOrderPage.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the DependentHostedNumberOrderContext
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.HostedNumbers.AuthorizationDocumentContext.DependentHostedNumberOrderInstance
 *
 * @property {string} sid - HostedNumberOrder sid.
 * @property {string} accountSid - Account sid.
 * @property {string} incomingPhoneNumberSid - IncomingPhoneNumber sid.
 * @property {string} addressSid - Address sid.
 * @property {string} signingDocumentSid - LOA document sid.
 * @property {string} phoneNumber - An E164 formatted phone number.
 * @property {PhoneNumberCapabilities} capabilities -
 *          A mapping of phone number capabilities.
 * @property {string} friendlyName - A human readable description of this resource.
 * @property {string} uniqueName -
 *          A unique, developer assigned name of this HostedNumberOrder.
 * @property {dependent_hosted_number_order.status} status -
 *          The Status of this HostedNumberOrder.
 * @property {string} failureReason -
 *          Why a hosted_number_order reached status "action-required"
 * @property {Date} dateCreated - The date this HostedNumberOrder was created.
 * @property {Date} dateUpdated - The date this HostedNumberOrder was updated.
 * @property {number} verificationAttempts -
 *          The number of attempts made to verify ownership of the phone number.
 * @property {string} email - Email.
 * @property {string} ccEmails - A list of emails.
 * @property {dependent_hosted_number_order.verification_type} verificationType -
 *          The method used for verifying ownership of the number to be hosted.
 * @property {string} verificationDocumentSid - Verification Document Sid.
 * @property {string} extension -
 *          Phone extension to use for ownership verification call.
 * @property {number} callDelay -
 *          Seconds (0-30) to delay ownership verification call by.
 * @property {string} verificationCode -
 *          The digits passed during the ownership verification call.
 * @property {string} verificationCallSids -
 *          List of IDs for ownership verification calls.
 *
 * @param {HostedNumbers} version - Version of the resource
 * @param {DependentHostedNumberOrderPayload} payload - The instance payload
 * @param {sid} signingDocumentSid - LOA document sid.
 */
/* jshint ignore:end */
DependentHostedNumberOrderInstance = function
    DependentHostedNumberOrderInstance(version, payload, signingDocumentSid) {
  this._version = version;

  // Marshaled Properties
  this.sid = payload.sid; // jshint ignore:line
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.incomingPhoneNumberSid = payload.incoming_phone_number_sid; // jshint ignore:line
  this.addressSid = payload.address_sid; // jshint ignore:line
  this.signingDocumentSid = payload.signing_document_sid; // jshint ignore:line
  this.phoneNumber = payload.phone_number; // jshint ignore:line
  this.capabilities = payload.capabilities; // jshint ignore:line
  this.friendlyName = payload.friendly_name; // jshint ignore:line
  this.uniqueName = payload.unique_name; // jshint ignore:line
  this.status = payload.status; // jshint ignore:line
  this.failureReason = payload.failure_reason; // jshint ignore:line
  this.dateCreated = deserialize.iso8601DateTime(payload.date_created); // jshint ignore:line
  this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated); // jshint ignore:line
  this.verificationAttempts = deserialize.integer(payload.verification_attempts); // jshint ignore:line
  this.email = payload.email; // jshint ignore:line
  this.ccEmails = payload.cc_emails; // jshint ignore:line
  this.verificationType = payload.verification_type; // jshint ignore:line
  this.verificationDocumentSid = payload.verification_document_sid; // jshint ignore:line
  this.extension = payload.extension; // jshint ignore:line
  this.callDelay = deserialize.integer(payload.call_delay); // jshint ignore:line
  this.verificationCode = payload.verification_code; // jshint ignore:line
  this.verificationCallSids = payload.verification_call_sids; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {signingDocumentSid: signingDocumentSid, };
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Preview.HostedNumbers.AuthorizationDocumentContext.DependentHostedNumberOrderInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
DependentHostedNumberOrderInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

DependentHostedNumberOrderInstance.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  DependentHostedNumberOrderList: DependentHostedNumberOrderList,
  DependentHostedNumberOrderPage: DependentHostedNumberOrderPage,
  DependentHostedNumberOrderInstance: DependentHostedNumberOrderInstance
};
