'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var AccessTokenList = require('./service/accessToken').AccessTokenList;
var EntityList = require('./service/entity').EntityList;
var MessagingConfigurationList = require(
    './service/messagingConfiguration').MessagingConfigurationList;
var Page = require('../../../base/Page');  /* jshint ignore:line */
var RateLimitList = require('./service/rateLimit').RateLimitList;
var VerificationCheckList = require(
    './service/verificationCheck').VerificationCheckList;
var VerificationList = require('./service/verification').VerificationList;
var WebhookList = require('./service/webhook').WebhookList;
var deserialize = require(
    '../../../base/deserialize');  /* jshint ignore:line */
var serialize = require('../../../base/serialize');  /* jshint ignore:line */
var values = require('../../../base/values');  /* jshint ignore:line */

var ServiceList;
var ServicePage;
var ServiceInstance;
var ServiceContext;

/* jshint ignore:start */
/**
 * Initialize the ServiceList
 *
 * @constructor Twilio.Verify.V2.ServiceList
 *
 * @param {Twilio.Verify.V2} version - Version of the resource
 */
/* jshint ignore:end */
ServiceList = function ServiceList(version) {
  /* jshint ignore:start */
  /**
   * @function services
   * @memberof Twilio.Verify.V2#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Verify.V2.ServiceContext}
   */
  /* jshint ignore:end */
  function ServiceListInstance(sid) {
    return ServiceListInstance.get(sid);
  }

  ServiceListInstance._version = version;
  // Path Solution
  ServiceListInstance._solution = {};
  ServiceListInstance._uri = `/Services`;
  /* jshint ignore:start */
  /**
   * create a ServiceInstance
   *
   * @function create
   * @memberof Twilio.Verify.V2.ServiceList#
   *
   * @param {object} opts - Options for request
   * @param {string} opts.friendlyName -
   *          A string to describe the verification service
   * @param {number} [opts.codeLength] -
   *          The length of the verification code to generate
   * @param {boolean} [opts.lookupEnabled] -
   *          Whether to perform a lookup with each verification
   * @param {boolean} [opts.skipSmsToLandlines] -
   *          Whether to skip sending SMS verifications to landlines
   * @param {boolean} [opts.dtmfInputRequired] -
   *          Whether to ask the user to press a number before delivering the verify code in a phone call
   * @param {string} [opts.ttsName] -
   *          The name of an alternative text-to-speech service to use in phone calls
   * @param {boolean} [opts.psd2Enabled] -
   *          Whether to pass PSD2 transaction parameters when starting a verification
   * @param {boolean} [opts.doNotShareWarningEnabled] -
   *          Whether to add a security warning at the end of an SMS.
   * @param {boolean} [opts.customCodeEnabled] -
   *          Whether to allow sending verifications with a custom code.
   * @param {boolean} [opts.push.includeDate] -
   *          Optional. Include the date in the Challenge's reponse. Default: true
   * @param {string} [opts.push.apnCredentialSid] -
   *          Optional. Set APN Credential for this service.
   * @param {string} [opts.push.fcmCredentialSid] -
   *          Optional. Set FCM Credential for this service.
   * @param {string} [opts.totp.issuer] - Optional. Set TOTP Issuer for this service.
   * @param {number} [opts.totp.timeStep] -
   *          Optional. How often, in seconds, are TOTP codes generated
   * @param {number} [opts.totp.codeLength] -
   *          Optional. Number of digits for generated TOTP codes
   * @param {number} [opts.totp.skew] -
   *          Optional. The number of past and future time-steps valid at a given time
   * @param {string} [opts.defaultTemplateSid] -
   *          The verification template SMS messages.
   * @param {function} [callback] - Callback to handle processed record
   *
   * @returns {Promise} Resolves to processed ServiceInstance
   */
  /* jshint ignore:end */
  ServiceListInstance.create = function create(opts, callback) {
    if (_.isUndefined(opts)) {
      throw new Error('Required parameter "opts" missing.');
    }
    if (_.isUndefined(opts.friendlyName)) {
      throw new Error('Required parameter "opts.friendlyName" missing.');
    }

    var deferred = Q.defer();
    var data = values.of({
      'FriendlyName': _.get(opts, 'friendlyName'),
      'CodeLength': _.get(opts, 'codeLength'),
      'LookupEnabled': serialize.bool(_.get(opts, 'lookupEnabled')),
      'SkipSmsToLandlines': serialize.bool(_.get(opts, 'skipSmsToLandlines')),
      'DtmfInputRequired': serialize.bool(_.get(opts, 'dtmfInputRequired')),
      'TtsName': _.get(opts, 'ttsName'),
      'Psd2Enabled': serialize.bool(_.get(opts, 'psd2Enabled')),
      'DoNotShareWarningEnabled': serialize.bool(_.get(opts, 'doNotShareWarningEnabled')),
      'CustomCodeEnabled': serialize.bool(_.get(opts, 'customCodeEnabled')),
      'Push.IncludeDate': serialize.bool(_.get(opts, 'push.includeDate')),
      'Push.ApnCredentialSid': _.get(opts, 'push.apnCredentialSid'),
      'Push.FcmCredentialSid': _.get(opts, 'push.fcmCredentialSid'),
      'Totp.Issuer': _.get(opts, 'totp.issuer'),
      'Totp.TimeStep': _.get(opts, 'totp.timeStep'),
      'Totp.CodeLength': _.get(opts, 'totp.codeLength'),
      'Totp.Skew': _.get(opts, 'totp.skew'),
      'DefaultTemplateSid': _.get(opts, 'defaultTemplateSid')
    });

    var promise = this._version.create({uri: this._uri, method: 'POST', data: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new ServiceInstance(this._version, payload, this._solution.sid));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Streams ServiceInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Verify.V2.ServiceList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  ServiceListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists ServiceInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Verify.V2.ServiceList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  ServiceListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of ServiceInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Verify.V2.ServiceList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  ServiceListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new ServicePage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of ServiceInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Verify.V2.ServiceList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  ServiceListInstance.getPage = function getPage(targetUrl, callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new ServicePage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a service
   *
   * @function get
   * @memberof Twilio.Verify.V2.ServiceList#
   *
   * @param {string} sid - The unique string that identifies the resource
   *
   * @returns {Twilio.Verify.V2.ServiceContext}
   */
  /* jshint ignore:end */
  ServiceListInstance.get = function get(sid) {
    return new ServiceContext(this._version, sid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Verify.V2.ServiceList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  ServiceListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  ServiceListInstance[util.inspect.custom] = function inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return ServiceListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the ServicePage
 *
 * @constructor Twilio.Verify.V2.ServicePage
 *
 * @param {V2} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {ServiceSolution} solution - Path solution
 *
 * @returns ServicePage
 */
/* jshint ignore:end */
ServicePage = function ServicePage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(ServicePage.prototype, Page.prototype);
ServicePage.prototype.constructor = ServicePage;

/* jshint ignore:start */
/**
 * Build an instance of ServiceInstance
 *
 * @function getInstance
 * @memberof Twilio.Verify.V2.ServicePage#
 *
 * @param {ServicePayload} payload - Payload response from the API
 *
 * @returns ServiceInstance
 */
/* jshint ignore:end */
ServicePage.prototype.getInstance = function getInstance(payload) {
  return new ServiceInstance(this._version, payload);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Verify.V2.ServicePage#
 *
 * @returns Object
 */
/* jshint ignore:end */
ServicePage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

ServicePage.prototype[util.inspect.custom] = function inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the ServiceContext
 *
 * @constructor Twilio.Verify.V2.ServiceInstance
 *
 * @property {string} sid - The unique string that identifies the resource
 * @property {string} accountSid - The SID of the Account that created the resource
 * @property {string} friendlyName -
 *          The string that you assigned to describe the verification service
 * @property {number} codeLength - The length of the verification code
 * @property {boolean} lookupEnabled -
 *          Whether to perform a lookup with each verification
 * @property {boolean} psd2Enabled -
 *          Whether to pass PSD2 transaction parameters when starting a verification
 * @property {boolean} skipSmsToLandlines -
 *          Whether to skip sending SMS verifications to landlines
 * @property {boolean} dtmfInputRequired -
 *          Whether to ask the user to press a number before delivering the verify code in a phone call
 * @property {string} ttsName -
 *          The name of an alternative text-to-speech service to use in phone calls
 * @property {boolean} doNotShareWarningEnabled -
 *          Whether to add a security warning at the end of an SMS.
 * @property {boolean} customCodeEnabled -
 *          Whether to allow sending verifications with a custom code.
 * @property {object} push - The service level configuration of factor push type.
 * @property {object} totp - The service level configuration of factor TOTP type.
 * @property {string} defaultTemplateSid - The default_template_sid
 * @property {Date} dateCreated -
 *          The RFC 2822 date and time in GMT when the resource was created
 * @property {Date} dateUpdated -
 *          The RFC 2822 date and time in GMT when the resource was last updated
 * @property {string} url - The absolute URL of the resource
 * @property {string} links - The URLs of related resources
 *
 * @param {V2} version - Version of the resource
 * @param {ServicePayload} payload - The instance payload
 * @param {sid} sid - The unique string that identifies the resource
 */
/* jshint ignore:end */
ServiceInstance = function ServiceInstance(version, payload, sid) {
  this._version = version;

  // Marshaled Properties
  this.sid = payload.sid; // jshint ignore:line
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.friendlyName = payload.friendly_name; // jshint ignore:line
  this.codeLength = deserialize.integer(payload.code_length); // jshint ignore:line
  this.lookupEnabled = payload.lookup_enabled; // jshint ignore:line
  this.psd2Enabled = payload.psd2_enabled; // jshint ignore:line
  this.skipSmsToLandlines = payload.skip_sms_to_landlines; // jshint ignore:line
  this.dtmfInputRequired = payload.dtmf_input_required; // jshint ignore:line
  this.ttsName = payload.tts_name; // jshint ignore:line
  this.doNotShareWarningEnabled = payload.do_not_share_warning_enabled; // jshint ignore:line
  this.customCodeEnabled = payload.custom_code_enabled; // jshint ignore:line
  this.push = payload.push; // jshint ignore:line
  this.totp = payload.totp; // jshint ignore:line
  this.defaultTemplateSid = payload.default_template_sid; // jshint ignore:line
  this.dateCreated = deserialize.iso8601DateTime(payload.date_created); // jshint ignore:line
  this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated); // jshint ignore:line
  this.url = payload.url; // jshint ignore:line
  this.links = payload.links; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {sid: sid || this.sid, };
};

Object.defineProperty(ServiceInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new ServiceContext(this._version, this._solution.sid);
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a ServiceInstance
 *
 * @function fetch
 * @memberof Twilio.Verify.V2.ServiceInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed ServiceInstance
 */
/* jshint ignore:end */
ServiceInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * remove a ServiceInstance
 *
 * @function remove
 * @memberof Twilio.Verify.V2.ServiceInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed ServiceInstance
 */
/* jshint ignore:end */
ServiceInstance.prototype.remove = function remove(callback) {
  return this._proxy.remove(callback);
};

/* jshint ignore:start */
/**
 * update a ServiceInstance
 *
 * @function update
 * @memberof Twilio.Verify.V2.ServiceInstance#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.friendlyName] -
 *          A string to describe the verification service
 * @param {number} [opts.codeLength] -
 *          The length of the verification code to generate
 * @param {boolean} [opts.lookupEnabled] -
 *          Whether to perform a lookup with each verification
 * @param {boolean} [opts.skipSmsToLandlines] -
 *          Whether to skip sending SMS verifications to landlines
 * @param {boolean} [opts.dtmfInputRequired] -
 *          Whether to ask the user to press a number before delivering the verify code in a phone call
 * @param {string} [opts.ttsName] -
 *          The name of an alternative text-to-speech service to use in phone calls
 * @param {boolean} [opts.psd2Enabled] -
 *          Whether to pass PSD2 transaction parameters when starting a verification
 * @param {boolean} [opts.doNotShareWarningEnabled] -
 *          Whether to add a privacy warning at the end of an SMS.
 * @param {boolean} [opts.customCodeEnabled] -
 *          Whether to allow sending verifications with a custom code.
 * @param {boolean} [opts.push.includeDate] -
 *          Optional. Include the date in the Challenge's reponse. Default: true
 * @param {string} [opts.push.apnCredentialSid] -
 *          Optional. Set APN Credential for this service.
 * @param {string} [opts.push.fcmCredentialSid] -
 *          Optional. Set FCM Credential for this service.
 * @param {string} [opts.totp.issuer] - Optional. Set TOTP Issuer for this service.
 * @param {number} [opts.totp.timeStep] -
 *          Optional. How often, in seconds, are TOTP codes generated
 * @param {number} [opts.totp.codeLength] -
 *          Optional. Number of digits for generated TOTP codes
 * @param {number} [opts.totp.skew] -
 *          Optional. The number of past and future time-steps valid at a given time
 * @param {string} [opts.defaultTemplateSid] -
 *          The verification template SMS messages.
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed ServiceInstance
 */
/* jshint ignore:end */
ServiceInstance.prototype.update = function update(opts, callback) {
  return this._proxy.update(opts, callback);
};

/* jshint ignore:start */
/**
 * Access the verifications
 *
 * @function verifications
 * @memberof Twilio.Verify.V2.ServiceInstance#
 *
 * @returns {Twilio.Verify.V2.ServiceContext.VerificationList}
 */
/* jshint ignore:end */
ServiceInstance.prototype.verifications = function verifications() {
  return this._proxy.verifications;
};

/* jshint ignore:start */
/**
 * Access the verificationChecks
 *
 * @function verificationChecks
 * @memberof Twilio.Verify.V2.ServiceInstance#
 *
 * @returns {Twilio.Verify.V2.ServiceContext.VerificationCheckList}
 */
/* jshint ignore:end */
ServiceInstance.prototype.verificationChecks = function verificationChecks() {
  return this._proxy.verificationChecks;
};

/* jshint ignore:start */
/**
 * Access the rateLimits
 *
 * @function rateLimits
 * @memberof Twilio.Verify.V2.ServiceInstance#
 *
 * @returns {Twilio.Verify.V2.ServiceContext.RateLimitList}
 */
/* jshint ignore:end */
ServiceInstance.prototype.rateLimits = function rateLimits() {
  return this._proxy.rateLimits;
};

/* jshint ignore:start */
/**
 * Access the messagingConfigurations
 *
 * @function messagingConfigurations
 * @memberof Twilio.Verify.V2.ServiceInstance#
 *
 * @returns {Twilio.Verify.V2.ServiceContext.MessagingConfigurationList}
 */
/* jshint ignore:end */
ServiceInstance.prototype.messagingConfigurations = function
    messagingConfigurations() {
  return this._proxy.messagingConfigurations;
};

/* jshint ignore:start */
/**
 * Access the entities
 *
 * @function entities
 * @memberof Twilio.Verify.V2.ServiceInstance#
 *
 * @returns {Twilio.Verify.V2.ServiceContext.EntityList}
 */
/* jshint ignore:end */
ServiceInstance.prototype.entities = function entities() {
  return this._proxy.entities;
};

/* jshint ignore:start */
/**
 * Access the webhooks
 *
 * @function webhooks
 * @memberof Twilio.Verify.V2.ServiceInstance#
 *
 * @returns {Twilio.Verify.V2.ServiceContext.WebhookList}
 */
/* jshint ignore:end */
ServiceInstance.prototype.webhooks = function webhooks() {
  return this._proxy.webhooks;
};

/* jshint ignore:start */
/**
 * Access the accessTokens
 *
 * @function accessTokens
 * @memberof Twilio.Verify.V2.ServiceInstance#
 *
 * @returns {Twilio.Verify.V2.ServiceContext.AccessTokenList}
 */
/* jshint ignore:end */
ServiceInstance.prototype.accessTokens = function accessTokens() {
  return this._proxy.accessTokens;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Verify.V2.ServiceInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
ServiceInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

ServiceInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the ServiceContext
 *
 * @constructor Twilio.Verify.V2.ServiceContext
 *
 * @property {Twilio.Verify.V2.ServiceContext.VerificationList} verifications -
 *          verifications resource
 * @property {Twilio.Verify.V2.ServiceContext.VerificationCheckList} verificationChecks -
 *          verificationChecks resource
 * @property {Twilio.Verify.V2.ServiceContext.RateLimitList} rateLimits -
 *          rateLimits resource
 * @property {Twilio.Verify.V2.ServiceContext.MessagingConfigurationList} messagingConfigurations -
 *          messagingConfigurations resource
 * @property {Twilio.Verify.V2.ServiceContext.EntityList} entities -
 *          entities resource
 * @property {Twilio.Verify.V2.ServiceContext.WebhookList} webhooks -
 *          webhooks resource
 * @property {Twilio.Verify.V2.ServiceContext.AccessTokenList} accessTokens -
 *          accessTokens resource
 *
 * @param {V2} version - Version of the resource
 * @param {sid} sid - The unique string that identifies the resource
 */
/* jshint ignore:end */
ServiceContext = function ServiceContext(version, sid) {
  this._version = version;

  // Path Solution
  this._solution = {sid: sid, };
  this._uri = `/Services/${sid}`;

  // Dependents
  this._verifications = undefined;
  this._verificationChecks = undefined;
  this._rateLimits = undefined;
  this._messagingConfigurations = undefined;
  this._entities = undefined;
  this._webhooks = undefined;
  this._accessTokens = undefined;
};

/* jshint ignore:start */
/**
 * fetch a ServiceInstance
 *
 * @function fetch
 * @memberof Twilio.Verify.V2.ServiceContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed ServiceInstance
 */
/* jshint ignore:end */
ServiceContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new ServiceInstance(this._version, payload, this._solution.sid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * remove a ServiceInstance
 *
 * @function remove
 * @memberof Twilio.Verify.V2.ServiceContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed ServiceInstance
 */
/* jshint ignore:end */
ServiceContext.prototype.remove = function remove(callback) {
  var deferred = Q.defer();
  var promise = this._version.remove({uri: this._uri, method: 'DELETE'});

  promise = promise.then(function(payload) {
    deferred.resolve(payload);
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * update a ServiceInstance
 *
 * @function update
 * @memberof Twilio.Verify.V2.ServiceContext#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.friendlyName] -
 *          A string to describe the verification service
 * @param {number} [opts.codeLength] -
 *          The length of the verification code to generate
 * @param {boolean} [opts.lookupEnabled] -
 *          Whether to perform a lookup with each verification
 * @param {boolean} [opts.skipSmsToLandlines] -
 *          Whether to skip sending SMS verifications to landlines
 * @param {boolean} [opts.dtmfInputRequired] -
 *          Whether to ask the user to press a number before delivering the verify code in a phone call
 * @param {string} [opts.ttsName] -
 *          The name of an alternative text-to-speech service to use in phone calls
 * @param {boolean} [opts.psd2Enabled] -
 *          Whether to pass PSD2 transaction parameters when starting a verification
 * @param {boolean} [opts.doNotShareWarningEnabled] -
 *          Whether to add a privacy warning at the end of an SMS.
 * @param {boolean} [opts.customCodeEnabled] -
 *          Whether to allow sending verifications with a custom code.
 * @param {boolean} [opts.push.includeDate] -
 *          Optional. Include the date in the Challenge's reponse. Default: true
 * @param {string} [opts.push.apnCredentialSid] -
 *          Optional. Set APN Credential for this service.
 * @param {string} [opts.push.fcmCredentialSid] -
 *          Optional. Set FCM Credential for this service.
 * @param {string} [opts.totp.issuer] - Optional. Set TOTP Issuer for this service.
 * @param {number} [opts.totp.timeStep] -
 *          Optional. How often, in seconds, are TOTP codes generated
 * @param {number} [opts.totp.codeLength] -
 *          Optional. Number of digits for generated TOTP codes
 * @param {number} [opts.totp.skew] -
 *          Optional. The number of past and future time-steps valid at a given time
 * @param {string} [opts.defaultTemplateSid] -
 *          The verification template SMS messages.
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed ServiceInstance
 */
/* jshint ignore:end */
ServiceContext.prototype.update = function update(opts, callback) {
  if (_.isFunction(opts)) {
    callback = opts;
    opts = {};
  }
  opts = opts || {};

  var deferred = Q.defer();
  var data = values.of({
    'FriendlyName': _.get(opts, 'friendlyName'),
    'CodeLength': _.get(opts, 'codeLength'),
    'LookupEnabled': serialize.bool(_.get(opts, 'lookupEnabled')),
    'SkipSmsToLandlines': serialize.bool(_.get(opts, 'skipSmsToLandlines')),
    'DtmfInputRequired': serialize.bool(_.get(opts, 'dtmfInputRequired')),
    'TtsName': _.get(opts, 'ttsName'),
    'Psd2Enabled': serialize.bool(_.get(opts, 'psd2Enabled')),
    'DoNotShareWarningEnabled': serialize.bool(_.get(opts, 'doNotShareWarningEnabled')),
    'CustomCodeEnabled': serialize.bool(_.get(opts, 'customCodeEnabled')),
    'Push.IncludeDate': serialize.bool(_.get(opts, 'push.includeDate')),
    'Push.ApnCredentialSid': _.get(opts, 'push.apnCredentialSid'),
    'Push.FcmCredentialSid': _.get(opts, 'push.fcmCredentialSid'),
    'Totp.Issuer': _.get(opts, 'totp.issuer'),
    'Totp.TimeStep': _.get(opts, 'totp.timeStep'),
    'Totp.CodeLength': _.get(opts, 'totp.codeLength'),
    'Totp.Skew': _.get(opts, 'totp.skew'),
    'DefaultTemplateSid': _.get(opts, 'defaultTemplateSid')
  });

  var promise = this._version.update({uri: this._uri, method: 'POST', data: data});

  promise = promise.then(function(payload) {
    deferred.resolve(new ServiceInstance(this._version, payload, this._solution.sid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

Object.defineProperty(ServiceContext.prototype,
  'verifications', {
    get: function() {
      if (!this._verifications) {
        this._verifications = new VerificationList(this._version, this._solution.sid);
      }
      return this._verifications;
    }
});

Object.defineProperty(ServiceContext.prototype,
  'verificationChecks', {
    get: function() {
      if (!this._verificationChecks) {
        this._verificationChecks = new VerificationCheckList(this._version, this._solution.sid);
      }
      return this._verificationChecks;
    }
});

Object.defineProperty(ServiceContext.prototype,
  'rateLimits', {
    get: function() {
      if (!this._rateLimits) {
        this._rateLimits = new RateLimitList(this._version, this._solution.sid);
      }
      return this._rateLimits;
    }
});

Object.defineProperty(ServiceContext.prototype,
  'messagingConfigurations', {
    get: function() {
      if (!this._messagingConfigurations) {
        this._messagingConfigurations = new MessagingConfigurationList(this._version, this._solution.sid);
      }
      return this._messagingConfigurations;
    }
});

Object.defineProperty(ServiceContext.prototype,
  'entities', {
    get: function() {
      if (!this._entities) {
        this._entities = new EntityList(this._version, this._solution.sid);
      }
      return this._entities;
    }
});

Object.defineProperty(ServiceContext.prototype,
  'webhooks', {
    get: function() {
      if (!this._webhooks) {
        this._webhooks = new WebhookList(this._version, this._solution.sid);
      }
      return this._webhooks;
    }
});

Object.defineProperty(ServiceContext.prototype,
  'accessTokens', {
    get: function() {
      if (!this._accessTokens) {
        this._accessTokens = new AccessTokenList(this._version, this._solution.sid);
      }
      return this._accessTokens;
    }
});

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Verify.V2.ServiceContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
ServiceContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

ServiceContext.prototype[util.inspect.custom] = function inspect(depth, options)
    {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  ServiceList: ServiceList,
  ServicePage: ServicePage,
  ServiceInstance: ServiceInstance,
  ServiceContext: ServiceContext
};
