/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { CountryListInstance } from './messaging/country';
import { SerializableClass } from '../../../interfaces';

/**
 * Initialize the MessagingList
 *
 * @param version - Version of the resource
 */
declare function MessagingList(version: V1): MessagingListInstance;

interface MessagingListInstance {
  countries?: CountryListInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface MessagingPayload extends MessagingResource, Page.TwilioResponsePayload {
}

interface MessagingResource {
  links: string;
  name: string;
  url: string;
}

interface MessagingSolution {
}


declare class MessagingInstance extends SerializableClass {
  /**
   * Initialize the MessagingContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   */
  constructor(version: V1, payload: MessagingPayload);

  links: string;
  name: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
}


declare class MessagingPage extends Page<V1, MessagingPayload, MessagingResource, MessagingInstance> {
  /**
   * Initialize the MessagingPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: MessagingSolution);

  /**
   * Build an instance of MessagingInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: MessagingPayload): MessagingInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { MessagingInstance, MessagingList, MessagingListInstance, MessagingPage, MessagingPayload, MessagingResource, MessagingSolution }
