'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../../base/deserialize');  /* jshint ignore:line */
var values = require('../../../../base/values');  /* jshint ignore:line */

var PublicKeyList;
var PublicKeyPage;
var PublicKeyInstance;
var PublicKeyContext;

/* jshint ignore:start */
/**
 * Initialize the PublicKeyList
 *
 * @constructor Twilio.Accounts.V1.CredentialContext.PublicKeyList
 *
 * @param {Twilio.Accounts.V1} version - Version of the resource
 */
/* jshint ignore:end */
PublicKeyList = function PublicKeyList(version) {
  /* jshint ignore:start */
  /**
   * @function publicKey
   * @memberof Twilio.Accounts.V1.CredentialContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Accounts.V1.CredentialContext.PublicKeyContext}
   */
  /* jshint ignore:end */
  function PublicKeyListInstance(sid) {
    return PublicKeyListInstance.get(sid);
  }

  PublicKeyListInstance._version = version;
  // Path Solution
  PublicKeyListInstance._solution = {};
  PublicKeyListInstance._uri = `/Credentials/PublicKeys`;
  /* jshint ignore:start */
  /**
   * Streams PublicKeyInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Accounts.V1.CredentialContext.PublicKeyList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  PublicKeyListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        } else {
          onComplete();
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists PublicKeyInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Accounts.V1.CredentialContext.PublicKeyList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  PublicKeyListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of PublicKeyInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Accounts.V1.CredentialContext.PublicKeyList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  PublicKeyListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new PublicKeyPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of PublicKeyInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Accounts.V1.CredentialContext.PublicKeyList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  PublicKeyListInstance.getPage = function getPage(targetUrl, callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new PublicKeyPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * create a PublicKeyInstance
   *
   * @function create
   * @memberof Twilio.Accounts.V1.CredentialContext.PublicKeyList#
   *
   * @param {object} opts - Options for request
   * @param {string} opts.publicKey - A URL encoded representation of the public key
   * @param {string} [opts.friendlyName] - A string to describe the resource
   * @param {string} [opts.accountSid] -
   *          The Subaccount this Credential should be associated with.
   * @param {function} [callback] - Callback to handle processed record
   *
   * @returns {Promise} Resolves to processed PublicKeyInstance
   */
  /* jshint ignore:end */
  PublicKeyListInstance.create = function create(opts, callback) {
    if (_.isUndefined(opts)) {
      throw new Error('Required parameter "opts" missing.');
    }
    if (_.isUndefined(opts['publicKey'])) {
      throw new Error('Required parameter "opts[\'publicKey\']" missing.');
    }

    var deferred = Q.defer();
    var data = values.of({
      'PublicKey': _.get(opts, 'publicKey'),
      'FriendlyName': _.get(opts, 'friendlyName'),
      'AccountSid': _.get(opts, 'accountSid')
    });

    var promise = this._version.create({uri: this._uri, method: 'POST', data: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new PublicKeyInstance(this._version, payload, this._solution.sid));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a public_key
   *
   * @function get
   * @memberof Twilio.Accounts.V1.CredentialContext.PublicKeyList#
   *
   * @param {string} sid - The unique string that identifies the resource
   *
   * @returns {Twilio.Accounts.V1.CredentialContext.PublicKeyContext}
   */
  /* jshint ignore:end */
  PublicKeyListInstance.get = function get(sid) {
    return new PublicKeyContext(this._version, sid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Accounts.V1.CredentialContext.PublicKeyList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  PublicKeyListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  PublicKeyListInstance[util.inspect.custom] = function inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return PublicKeyListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the PublicKeyPage
 *
 * @constructor Twilio.Accounts.V1.CredentialContext.PublicKeyPage
 *
 * @param {V1} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {PublicKeySolution} solution - Path solution
 *
 * @returns PublicKeyPage
 */
/* jshint ignore:end */
PublicKeyPage = function PublicKeyPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(PublicKeyPage.prototype, Page.prototype);
PublicKeyPage.prototype.constructor = PublicKeyPage;

/* jshint ignore:start */
/**
 * Build an instance of PublicKeyInstance
 *
 * @function getInstance
 * @memberof Twilio.Accounts.V1.CredentialContext.PublicKeyPage#
 *
 * @param {PublicKeyPayload} payload - Payload response from the API
 *
 * @returns PublicKeyInstance
 */
/* jshint ignore:end */
PublicKeyPage.prototype.getInstance = function getInstance(payload) {
  return new PublicKeyInstance(this._version, payload);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Accounts.V1.CredentialContext.PublicKeyPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
PublicKeyPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

PublicKeyPage.prototype[util.inspect.custom] = function inspect(depth, options)
    {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the PublicKeyContext
 *
 * @constructor Twilio.Accounts.V1.CredentialContext.PublicKeyInstance
 *
 * @property {string} sid - The unique string that identifies the resource
 * @property {string} accountSid -
 *          The SID of the Account that created the Credential that the PublicKey resource belongs to
 * @property {string} friendlyName -
 *          The string that you assigned to describe the resource
 * @property {Date} dateCreated -
 *          The RFC 2822 date and time in GMT when the resource was created
 * @property {Date} dateUpdated -
 *          The RFC 2822 date and time in GMT when the resource was last updated
 * @property {string} url -
 *          The URI for this resource, relative to `https://accounts.twilio.com`
 *
 * @param {V1} version - Version of the resource
 * @param {PublicKeyPayload} payload - The instance payload
 * @param {sid} sid - The unique string that identifies the resource
 */
/* jshint ignore:end */
PublicKeyInstance = function PublicKeyInstance(version, payload, sid) {
  this._version = version;

  // Marshaled Properties
  this.sid = payload.sid; // jshint ignore:line
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.friendlyName = payload.friendly_name; // jshint ignore:line
  this.dateCreated = deserialize.iso8601DateTime(payload.date_created); // jshint ignore:line
  this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated); // jshint ignore:line
  this.url = payload.url; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {sid: sid || this.sid, };
};

Object.defineProperty(PublicKeyInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new PublicKeyContext(this._version, this._solution.sid);
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a PublicKeyInstance
 *
 * @function fetch
 * @memberof Twilio.Accounts.V1.CredentialContext.PublicKeyInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed PublicKeyInstance
 */
/* jshint ignore:end */
PublicKeyInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * update a PublicKeyInstance
 *
 * @function update
 * @memberof Twilio.Accounts.V1.CredentialContext.PublicKeyInstance#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.friendlyName] - A string to describe the resource
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed PublicKeyInstance
 */
/* jshint ignore:end */
PublicKeyInstance.prototype.update = function update(opts, callback) {
  return this._proxy.update(opts, callback);
};

/* jshint ignore:start */
/**
 * remove a PublicKeyInstance
 *
 * @function remove
 * @memberof Twilio.Accounts.V1.CredentialContext.PublicKeyInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed PublicKeyInstance
 */
/* jshint ignore:end */
PublicKeyInstance.prototype.remove = function remove(callback) {
  return this._proxy.remove(callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Accounts.V1.CredentialContext.PublicKeyInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
PublicKeyInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

PublicKeyInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the PublicKeyContext
 *
 * @constructor Twilio.Accounts.V1.CredentialContext.PublicKeyContext
 *
 * @param {V1} version - Version of the resource
 * @param {sid} sid - The unique string that identifies the resource
 */
/* jshint ignore:end */
PublicKeyContext = function PublicKeyContext(version, sid) {
  this._version = version;

  // Path Solution
  this._solution = {sid: sid, };
  this._uri = `/Credentials/PublicKeys/${sid}`;
};

/* jshint ignore:start */
/**
 * fetch a PublicKeyInstance
 *
 * @function fetch
 * @memberof Twilio.Accounts.V1.CredentialContext.PublicKeyContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed PublicKeyInstance
 */
/* jshint ignore:end */
PublicKeyContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new PublicKeyInstance(this._version, payload, this._solution.sid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * update a PublicKeyInstance
 *
 * @function update
 * @memberof Twilio.Accounts.V1.CredentialContext.PublicKeyContext#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.friendlyName] - A string to describe the resource
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed PublicKeyInstance
 */
/* jshint ignore:end */
PublicKeyContext.prototype.update = function update(opts, callback) {
  if (_.isFunction(opts)) {
    callback = opts;
    opts = {};
  }
  opts = opts || {};

  var deferred = Q.defer();
  var data = values.of({'FriendlyName': _.get(opts, 'friendlyName')});

  var promise = this._version.update({uri: this._uri, method: 'POST', data: data});

  promise = promise.then(function(payload) {
    deferred.resolve(new PublicKeyInstance(this._version, payload, this._solution.sid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * remove a PublicKeyInstance
 *
 * @function remove
 * @memberof Twilio.Accounts.V1.CredentialContext.PublicKeyContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed PublicKeyInstance
 */
/* jshint ignore:end */
PublicKeyContext.prototype.remove = function remove(callback) {
  var deferred = Q.defer();
  var promise = this._version.remove({uri: this._uri, method: 'DELETE'});

  promise = promise.then(function(payload) {
    deferred.resolve(payload);
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Accounts.V1.CredentialContext.PublicKeyContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
PublicKeyContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

PublicKeyContext.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  PublicKeyList: PublicKeyList,
  PublicKeyPage: PublicKeyPage,
  PublicKeyInstance: PublicKeyInstance,
  PublicKeyContext: PublicKeyContext
};
